<?php
// +----------------------------------------------------------------------
// | HkCms 搜索页
// +----------------------------------------------------------------------
// | Copyright (c) 2020-2021 http://www.hkcms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 广州恒企教育科技有限公司 <admin@hkcms.cn>
// +----------------------------------------------------------------------

declare (strict_types=1);

namespace app\index\controller;

use app\admin\model\cms\Model;

class Search extends BaseController
{
    /**
     * 搜索结果列表
     * @return string|void
     */
    public function index()
    {
        $param['keyword'] = $this->request->param('keyword','');
        $param['model_id'] = $this->request->param('model_id','', 'intval');

        // 当前语言
        $tag['lang'] = get_curlang();

        $map = [['status','=','normal'],['lang','=',$tag['lang']]];
        if (empty($param['keyword'])) {
            $this->error(lang('Please input keywords'));
        }
        $map[] = ['title','like',"%{$param['keyword']}%"];
        if (empty($param['model_id'])) {  // 没有指定模型ID时，从所有模型里搜索
            $models = Model::where(['status'=>'normal','is_search'=>1])->order('controller')->select();
            if ($models->isEmpty()) {
                return $this->view->fetch('index/search', ['__SDATA__'=>[],'__SPAGE__'=>[],'__modelInfo__'=>[],'__param__'=>$param]);
            }
            $obj = [];

            foreach ($models as $key=>$value) {
                $mapTmp = $map;
                $c = '\app\admin\model\cms\\'.$value->controller;
                $mapTmp[] = ['model_id','=',$value['id']];
                $obj = (new $c)->setTable($value->tablename)
                    ->with(['category'])
                    ->where($mapTmp)
                    ->order('update_time desc')
                    ->append(['publish_time_text','url'])
                    ->paginate([
                        'path'=>'/search/index',
                        'list_rows'=> 10,
                        'var_page' => 'page',
                        'query' => $param
                    ], false);

                if ($obj->isEmpty()) {
                    continue;
                } else {
                    break;
                }
            }
        } else {
            $map[] = ['model_id','=',$param['model_id']];

            $model = Model::where(['id'=>$param['model_id']])->find();
            if (empty($model)) {
                $this->error(lang('Model doesn\'t exist!'));
            }

            // 搜索查询
            $c = '\app\admin\model\cms\\'.$model->controller;
            $obj = (new $c)->setTable($model->tablename)
                ->with(['category'])
                ->where($map)
                ->order('update_time desc')
                ->append(['publish_time_text','url'])
                ->paginate([
                    'path'=>'/search/index',
                    'list_rows'=> 10,
                    'var_page' => 'page',
                    'query' => $param
                ], false);
        }

        $array = $obj->toArray()['data'];
        $page = $obj;

        $modelInfo = Model::where(['status'=>'normal','is_search'=>1])->order('controller')->select()->toArray();
        foreach ($modelInfo as $key=>&$value) {
            $value['url'] = (string) url('/search/index',['model_id'=>$value['id'],'keyword'=>$param['keyword']??'']);
            $value['currentstyle'] = $param['model_id']==$value['id'] ? 'active' : '';
        }
        return $this->view->fetch('index/search', [
            '__SDATA__'=>$array,
            '__SPAGE__'=>$page,
            '__modelInfo__'=>$modelInfo,
            '__param__'=>$param,
        ]);
    }
}