
> 使用前请准备好所需环境：`Visual Studio 2019`、`.NET Core3.1 SDK`、`Mysql 5.7`、`Centos(可选)`、`Docker(可选)`。

> 本系列文档均是以先在本地获得发布文件再部署的方式，Dockerfile也是以这种方式编写，如果要以源码方式部署请自行修改。


下载源码到本地，然后用VS2019打开解决方案并编译通过。


打开项目Hos.ScheduleMaster.Web根目录下的`appsettings.json`文件，先修改Mysql数据库连接字符串以保证数据库正常访问：
```json
{
  "ConnectionStrings": {
    "MysqlConnection": "Data Source=192.168.8.27;Database=schedule_master;User ID=root;Password=123456;pooling=true;CharSet=utf8;port=3306;sslmode=none;TreatTinyAsBoolean=true"
  }
}
```

再找到`NodeSetting`节点，修改`IP`字段为Master将要部署的ip地址（Master端口固定为30000不用修改）:
```json
{
  "NodeSetting": {
    "IdentityName": "master-node", //节点名称
    "Role": "master", //节点角色
    "Protocol": "http", //访问协议
    "IP": "localhost", //IP地址
    "Port": 30000 //访问端口
  }	
}
```

在项目上右击选择"发布..."，发布到本地文件夹。


打开项目Hos.ScheduleMaster.QuartzHost根目录下的`appsettings.json`文件，同样先修改Mysql连接字符串，再找到`NodeSetting`节点，设置Worker的名称`IdentityName`，修改`IP`字段为将要部署的ip地址，`Port`字段为要监听的地址（推荐为30001）：
```json
{
  "NodeSetting": {
    "IdentityName": "worker1", //节点名称
    "Role": "worker", //节点角色
    "Protocol": "http", //访问协议
    "IP": "localhost", //IP地址
    "Port": 30001, //访问端口
    "Priority": 1, //权重
    "MaxConcurrency": 20 //quartz实例最大并发量
  }
}
```

在项目上右击选择"发布..."，发布到本地文件夹。

如果要新增Worker，按同样方式配置`IdentityName、IP、Port`再发布到新目录即可，Worker在启动后会把自己的信息注入到数据库中，在Master中可以看到。

> **注意：节点名称一定不能重复，否则节点无效，IP和端口必须是所有节点间能相互访问到的，必须网络互通。**


其他发布方式亦可，下面以部署1个Master和2个Worker节点为例。

<br />

### 在Windows中运行

* 找到Master的发布目录，执行命令`dotnet Hos.ScheduleMaster.Web.dll`启动程序，**首次启动会自动迁移生成数据库结构并初始化种子数据**，打开浏览器输入ip和端口访问即可（初始用户名`admin`，密码`111111`）。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.Web\bin\Release\netcoreapp3.1>dotnet Hos.ScheduleMaster.Web.dll
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30000
info: Hos.ScheduleMaster.Web.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.Web\bin\Release\netcoreapp3.1
```

* 找到Worker1的发布目录，执行命令`dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30001`启动程序，打开浏览器输入ip和端口会看到一个欢迎页面，表示Worker已启动成功。注意这里指定的启动端口要和配置文件中的一致。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1\site1>dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30001
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30001
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      enabled auto register...
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1\site1
```

* 找到Worker2的发布目录，执行命令`dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30002`启动程序，指定的启动端口要和配置文件中的一致。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1\site2>dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30002
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30002
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      enabled auto register...
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1\site2
```

* 登录到Master中，可以看到**节点管理**菜单下各节点的运行状态。

<br />

### 在Linux(Centos)中运行

> 运行前请确保机器已经安装好`.NET Core3.1`运行时环境。

把发布文件复制到Centos中，操作步骤同Windows。

<br />

### 在Docker中运行

* 在Master的发布目录中执行`docker build -t ms_master .`命令生成master镜像，再执行`docker run -d -p 30000:30000 --name="mymaster" ms_master`运行容器。
``` shell
[root@master1 ms_master]# docker run  -d -p 30000:30000  --name="mymaster" ms_master
3bbbec2398d9147f9aa1d9e57a4741385ffd33558f83320d62a92d011e9aa143
```

* 在Worker1的发布目录中执行`docker build -t ms_worker1 .`命令生成worker镜像，再执行`docker run -d -p 30001:80 --name="myworker1" ms_worker1`运行容器启动worker1。
``` shell
[root@master1 ms_worker1]# docker run  -d -p 30001:80  --name="myworker1" ms_worker1
5e446997d4a28b3c6ec0708a88d42a4d6baad1e5d5ae686d88c03e99c4e2003f
```

* 在Worker2的发布目录中执行`docker build -t ms_worker2 .`命令生成worker镜像，再执行`docker run -d -p 30002:80 --name="myworker2" ms_worker2`运行容器启动worker2。
``` shell
[root@master1 ms_worker2]# docker run  -d -p 30002:80  --name="myworker2" ms_worker2
0cad44660657d2251e71b73a46189117ec3aad1445c5176276d32fa06360d56e
```

* 执行`docker ps`查看各容器运行状态，如果运行不起来请检查容器log。


> 注意：配置文件的端口必须是容器对外的端口。


可以看到使用Docker部署非常不方便，使用动态参数可以解决这个问题。