
由于.NET Core天生就对云原生的友好支持，本项目针对各种部署场景提供了多种简单有效的方式。

从不同角度来看，它又支持不同的形式。

- 按应用配置角度：支持**静态配置文件**和**运行时动态参数**。

- 按应用启动角度：支持**自动注册模式**和**手动连接模式**。

以上几种方式都是互相结合使用，相辅相成的。


再稍微解释下本项目涉及的几个核心概念：

- **Master**：系统主控制台，表现上是一个ASP.NET Core MVC的web应用，它是所有任务和节点的控制中心，是用户和调度系统的交互窗口。 

- **Worker**：任务执行器，也就是实际执行任务的载体，由Master通过HTTP的方式进行管理。

- **Node(节点)**：运行了Master或Worker的一个web进程，系统要运行必须要至少启动2个节点，也就是1个Master和至少1个Worker。


<br />

### 多数据库支持

目前项目支持使用`Mysql`、`SQLServer`、`PostgreSQL`三种类型的数据库作为持久化。

在文件`appsettings.json`中的DbConnector节点配置了使用的数据库类型以及连接字符串：

- Provider的可选值：sqlserver、postgresql、mysql，默认为mysql
-  ConnectionString是对应数据库类型的连接字符串，格式示例：
    - sqlserver："Persist Security Info = False; User ID =sa; Password =123456; Initial Catalog =schedule_master; Server =."
    - postgresql："Server=localhost;Port=5432;Database=schedule_master;User Id=postgres;Password=123456;Pooling=true;MaxPoolSize=20;"
    - mysql："Data Source=localhost;Database=schedule_master;User ID=root;Password=123456;pooling=true;CharSet=utf8mb4;port=3306;sslmode=none;TreatTinyAsBoolean=true"

> 要注意的是，Master和Worker必须使用同一个数据库。

### 静态配置文件启动

这是项目早期唯一支持的启动方式，在节点启动前通过修改配置文件`appsettings.json`中指定配置项`NodeSetting`的参数实现节点信息配置。
```json
{
  "NodeSetting": {
    "IdentityName": "master-node",
    "Role": "master",
    "Protocol": "http",
    "IP": "localhost",
    "Port": 30000,
    "Priority": 1
  }	
}
```

在自动注册模式下，这些配置信息将被注册到数据库中，成为节点间互相访问的依据。

在手动连接模式下，配置信息将会失效，这时候节点间访问完全依赖于在控制台中手动配置的信息。

> 要注意的是，Master只提供了自动注册模式，也就是必须要在启动前配置好参数，而Worker可以支持上面提到的2种模式，下同。

这种启动方式适合节点数不是很多，并且使用传统部署方式的场景。


<br />

### 动态参数启动

在很多场景下，使用配置文件并不是一种好的方案，特别是参数中的IP和端口并不好提前预定，很典型的是在使用Docker部署的情况下需要根据不同的配置文件生成不同的镜像，又或者是使用Kubernetes进行节点弹性伸缩时非常不便，这是不能忍受的。

为了充分适应容器部署，我设计了动态参数启动模式，支持使用运行时参数改变节点配置。

在自动注册模式下，可以使用命令行参数覆盖对应的配置文件参数，对应的参数名分别是：`--identity`、`--protocol`、`--ip`、`--port`、`--priority`、`--maxc`，这种模式下还是要依赖于配置文件，只是动态参数有更高的优先级。

在手动连接模式下，节点信息依赖于控制台中的配置，**但是必须要使用动态参数告诉应用禁用自动注册**，有如下2种方式：

- 使用环境变量，设置 **`SMCORE_AUTOR=false`** 和 **`SMCORE_WORKEROF=你的master节点名称`**。
- 使用命令行参数，设置 **`--autor=false`** 和 **`--workerof=你的master节点名称`**。

有了动态参数，我们可以使用一个Docker镜像，通过不同启动参数就能部署多个节点。而有了手动连接方式，可以非常方便的使用Kubernetes对节点做弹性伸缩。

<br />

**系统默认情况下是以配置文件和自动注册模式启动。**
