
参考《配置文件启动》的步骤先获得项目的发布文件。

动态参数对自动注册模式和手动连接模式都有效，下面分别介绍这两种模式下的使用。

<br />

### 自动注册节点

这是系统默认的启动方式，适用于Master和Worker，除非显式声明禁用。

禁用方式为使用环境变量 **`SMCORE_AUTOR=false`** 或者命令行参数 **`--autor=false`** ，禁用的同时必须指定要连接的Master节点名称： **`SMCORE_WORKEROF=你的master节点名称`** 或者 **`--workerof=你的master节点名称`**。注意：禁用只对Worker部署有效！

自动注册模式下支持配置文件+命令行参数的配置方式，如果设置了命令行参数则会覆盖对应的配置文件参数。

#### 在Windows中运行

演示如何使用命令行参数覆盖配置文件中的IP和端口字段(假设配置文件中的IP是localhost，端口是100)：

* 找到Master的发布目录，执行命令`dotnet Hos.ScheduleMaster.Web.dll --ip=192.168.8.27 --port=30000`启动程序。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.Web\bin\Release\netcoreapp3.1>dotnet Hos.ScheduleMaster.Web.dll --ip=192.168.8.27 --port=30000
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30000
info: Hos.ScheduleMaster.Web.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.Web\bin\Release\netcoreapp3.1
```

* 找到Worker的发布目录，执行命令`dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30001 --identity=worker1 --ip=192.168.8.27 --port=30001`启动程序。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1>dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30001
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30001
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      enabled auto register...
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1
```

* 还是在这个Worker的发布目录，执行命令`dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30002 --identity=worker2 --ip=192.168.8.27 --port=30002`即可再启动一个Worker进程。
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1>dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://*:30002 --identity=worker2 --ip=192.168.8.27 --port=30002
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://[::]:30002
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      enabled auto register...
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1
```

打开Master的控制台，进入节点管理页面，发现命令行参数已生效。

#### 在Linux中运行

操作步骤同上。

#### 在Docker中运行

* 在Master的发布目录中执行`docker build -t ms_master .`命令生成master镜像，再执行`docker run -d -p 30000:30000 --name="mymaster" ms_master bash  --ip=192.168.8.27 --port=30000`运行容器。
``` shell
[root@master1 ms_master]# docker run  -d -p 30000:30000  --name="mymaster" ms_master --ip=192.168.8.27 --port=30000
3bbbec2398d9147f9aa1d9e57a4741385ffd33558f83320d62a92d011e9aa143
```

* 在Worker的发布目录中执行`docker build -t ms_worker .`命令生成worker镜像，再执行`docker run -d -p 30001:80 --name="myworker1" ms_worker bash --identity=docker-worker1 --ip=192.168.8.27 --port=30001`运行容器启动worker1。
``` shell
[root@master1 ms_worker1]# docker run  -d -p 30001:80  --name="myworker1" ms_worker bash --identity=docker-worker1 --ip=192.168.8.27 --port=30001
5e446997d4a28b3c6ec0708a88d42a4d6baad1e5d5ae686d88c03e99c4e2003f
```

* 继续执行`docker run -d -p 30002:80 --name="myworker2" ms_worker bash --identity=docker-worker2 --ip=192.168.8.27 --port=30002`运行容器启动worker2。
``` shell
[root@master1 ms_worker2]# docker run  -d -p 30002:80  --name="myworker2" ms_worker bash --identity=docker-worker2 --ip=192.168.8.27 --port=30002
0cad44660657d2251e71b73a46189117ec3aad1445c5176276d32fa06360d56e
```

* 执行`docker ps`查看各容器运行状态，如果运行不起来请检查容器log。

可以看到不需要重复给不同的Worker生成镜像了，如果你不使用容器编排工具部署，以上方式已经足够了。

<br />

### 手动连接模式

手动连接模式要解决的核心问题是那些不能提前预知IP和端口以及Worker平滑伸缩的场景，使用命令行参数依然要给每个容器(应用)单独指定配置，使用Kubernetes Deployment做伸缩时还是不方便。

这时候可以禁用自动注册，采用手动连接方式和Worker建立通信。下面只介绍在Windows下的使用方式，其他平台也是类似。

* 第一步先启动Worker进程：
``` shell
D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1>dotnet Hos.ScheduleMaster.QuartzHost.dll --urls http://192.168.8.27:30001 --autor=false --workerof=你的master名称
info: Microsoft.Hosting.Lifetime[0]
      Now listening on: http://192.168.8.27:30001
info: Hos.ScheduleMaster.QuartzHost.AppStart.AppLifetimeHostedService[0]
      Hosted service OnStarted
info: Microsoft.Hosting.Lifetime[0]
      Application started. Press Ctrl+C to shut down.
info: Microsoft.Hosting.Lifetime[0]
      Hosting environment: Production
info: Microsoft.Hosting.Lifetime[0]
      Content root path: D:\ScheduleMasterCore\Hos.ScheduleMaster.QuartzHost\bin\Release\netcoreapp3.1
```

* 第二步在控制台创建一个节点(注意这里的主机地址要填Worker真实监听的地址)：

![ ](https://imgkr.cn-bj.ufileos.com/4bff500d-ce3d-442f-a8d7-13827c3e865a.png)

* 第三步对节点执行“连接”操作，可以看到节点连接成功信息：
``` shell
info: Hos.ScheduleMaster.QuartzHost.Controllers.QuartzController[0]
      successfully connected to master-node!
``` 

节点连接成功后是空闲状态，可以对它执行“启用”开启调度功能。

> 小提示：对于这种部署场景，最好的办法是在项目属性中设置环境变量彻底禁用自动注册（或者在Dockerfile中设置环境变量），这样就不用每次通过命令行参数禁用了。
