# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `webrick` gem.
# Please instead update this file by running `bin/tapioca gem webrick`.

# AccessLog provides logging to various files in various formats.
#
# Multiple logs may be written to at the same time:
#
#   access_log = [
#     [$stderr, WEBrick::AccessLog::COMMON_LOG_FORMAT],
#     [$stderr, WEBrick::AccessLog::REFERER_LOG_FORMAT],
#   ]
#
#   server = WEBrick::HTTPServer.new :AccessLog => access_log
#
# Custom log formats may be defined.  WEBrick::AccessLog provides a subset
# of the formatting from Apache's mod_log_config
# http://httpd.apache.org/docs/mod/mod_log_config.html#formats.  See
# AccessLog::setup_params for a list of supported options
module WEBrick::AccessLog
  private

  # Escapes control characters in +data+
  #
  # source://webrick//lib/webrick/accesslog.rb#151
  def escape(data); end

  # Formats +params+ according to +format_string+ which is described in
  # setup_params.
  #
  # source://webrick//lib/webrick/accesslog.rb#123
  def format(format_string, params); end

  # This format specification is a subset of mod_log_config of Apache:
  #
  # %a:: Remote IP address
  # %b:: Total response size
  # %e{variable}:: Given variable in ENV
  # %f:: Response filename
  # %h:: Remote host name
  # %{header}i:: Given request header
  # %l:: Remote logname, always "-"
  # %m:: Request method
  # %{attr}n:: Given request attribute from <tt>req.attributes</tt>
  # %{header}o:: Given response header
  # %p:: Server's request port
  # %{format}p:: The canonical port of the server serving the request or the
  #              actual port or the client's actual port.  Valid formats are
  #              canonical, local or remote.
  # %q:: Request query string
  # %r:: First line of the request
  # %s:: Request status
  # %t:: Time the request was received
  # %T:: Time taken to process the request
  # %u:: Remote user from auth
  # %U:: Unparsed URI
  # %%:: Literal %
  #
  # source://webrick//lib/webrick/accesslog.rb#95
  def setup_params(config, req, res); end

  class << self
    # Escapes control characters in +data+
    #
    # source://webrick//lib/webrick/accesslog.rb#151
    def escape(data); end

    # Formats +params+ according to +format_string+ which is described in
    # setup_params.
    #
    # source://webrick//lib/webrick/accesslog.rb#123
    def format(format_string, params); end

    # This format specification is a subset of mod_log_config of Apache:
    #
    # %a:: Remote IP address
    # %b:: Total response size
    # %e{variable}:: Given variable in ENV
    # %f:: Response filename
    # %h:: Remote host name
    # %{header}i:: Given request header
    # %l:: Remote logname, always "-"
    # %m:: Request method
    # %{attr}n:: Given request attribute from <tt>req.attributes</tt>
    # %{header}o:: Given response header
    # %p:: Server's request port
    # %{format}p:: The canonical port of the server serving the request or the
    #              actual port or the client's actual port.  Valid formats are
    #              canonical, local or remote.
    # %q:: Request query string
    # %r:: First line of the request
    # %s:: Request status
    # %t:: Time the request was received
    # %T:: Time taken to process the request
    # %u:: Remote user from auth
    # %U:: Unparsed URI
    # %%:: Literal %
    #
    # source://webrick//lib/webrick/accesslog.rb#95
    def setup_params(config, req, res); end
  end
end

# A generic logging class
class WEBrick::BasicLog
  # Initializes a new logger for +log_file+ that outputs messages at +level+
  # or higher.  +log_file+ can be a filename, an IO-like object that
  # responds to #<< or nil which outputs to $stderr.
  #
  # If no level is given INFO is chosen by default
  #
  # @return [BasicLog] a new instance of BasicLog
  #
  # source://webrick//lib/webrick/log.rb#50
  def initialize(log_file = T.unsafe(nil), level = T.unsafe(nil)); end

  # Synonym for log(INFO, obj.to_s)
  #
  # source://webrick//lib/webrick/log.rb#84
  def <<(obj); end

  # Closes the logger (also closes the log device associated to the logger)
  #
  # source://webrick//lib/webrick/log.rb#66
  def close; end

  # Shortcut for logging a DEBUG message
  #
  # source://webrick//lib/webrick/log.rb#97
  def debug(msg); end

  # Will the logger output DEBUG messages?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/log.rb#108
  def debug?; end

  # Shortcut for logging an ERROR message
  #
  # source://webrick//lib/webrick/log.rb#91
  def error(msg); end

  # Will the logger output ERROR messages?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/log.rb#102
  def error?; end

  # Shortcut for logging a FATAL message
  #
  # source://webrick//lib/webrick/log.rb#89
  def fatal(msg); end

  # Will the logger output FATAL messages?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/log.rb#100
  def fatal?; end

  # Shortcut for logging an INFO message
  #
  # source://webrick//lib/webrick/log.rb#95
  def info(msg); end

  # Will the logger output INFO messages?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/log.rb#106
  def info?; end

  # log-level, messages above this level will be logged
  #
  # source://webrick//lib/webrick/log.rb#41
  def level; end

  # log-level, messages above this level will be logged
  #
  # source://webrick//lib/webrick/log.rb#41
  def level=(_arg0); end

  # Logs +data+ at +level+ if the given level is above the current log
  # level.
  #
  # source://webrick//lib/webrick/log.rb#75
  def log(level, data); end

  # Shortcut for logging a WARN message
  #
  # source://webrick//lib/webrick/log.rb#93
  def warn(msg); end

  # Will the logger output WARN messages?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/log.rb#104
  def warn?; end

  private

  # Formats +arg+ for the logger
  #
  # * If +arg+ is an Exception, it will format the error message and
  #   the back trace.
  # * If +arg+ responds to #to_str, it will return it.
  # * Otherwise it will return +arg+.inspect.
  #
  # source://webrick//lib/webrick/log.rb#119
  def format(arg); end
end

# --
# Updates WEBrick::GenericServer with SSL functionality
class WEBrick::GenericServer
  # Creates a new generic server from +config+.  The default configuration
  # comes from +default+.
  #
  # @return [GenericServer] a new instance of GenericServer
  #
  # source://webrick//lib/webrick/server.rb#88
  def initialize(config = T.unsafe(nil), default = T.unsafe(nil)); end

  # Retrieves +key+ from the configuration
  #
  # source://webrick//lib/webrick/server.rb#121
  def [](key); end

  # The server configuration
  #
  # source://webrick//lib/webrick/server.rb#66
  def config; end

  # Updates +listen+ to enable SSL when the SSL configuration is active.
  #
  # source://webrick//lib/webrick/server.rb#129
  def listen(address, port); end

  # Sockets listening for connections.
  #
  # source://webrick//lib/webrick/server.rb#82
  def listeners; end

  # The server logger.  This is independent from the HTTP access log.
  #
  # source://webrick//lib/webrick/server.rb#71
  def logger; end

  # You must subclass GenericServer and implement \#run which accepts a TCP
  # client socket
  #
  # source://webrick//lib/webrick/server.rb#244
  def run(sock); end

  # Shuts down the server and all listening sockets.  New listeners must be
  # provided to restart the server.
  #
  # source://webrick//lib/webrick/server.rb#234
  def shutdown; end

  # Starts the server and runs the +block+ for each connection.  This method
  # does not return until the server is stopped from a signal handler or
  # another thread using #stop or #shutdown.
  #
  # If the block raises a subclass of StandardError the exception is logged
  # and ignored.  If an IOError or Errno::EBADF exception is raised the
  # exception is ignored.  If an Exception subclass is raised the exception
  # is logged and re-raised which stops the server.
  #
  # To completely shut down a server call #shutdown from ensure:
  #
  #   server = WEBrick::GenericServer.new
  #   # or WEBrick::HTTPServer.new
  #
  #   begin
  #     server.start
  #   ensure
  #     server.shutdown
  #   end
  #
  # @raise [ServerError]
  #
  # source://webrick//lib/webrick/server.rb#154
  def start(&block); end

  # The server status.  One of :Stop, :Running or :Shutdown
  #
  # source://webrick//lib/webrick/server.rb#61
  def status; end

  # Stops the server from accepting new connections.
  #
  # source://webrick//lib/webrick/server.rb#222
  def stop; end

  # Tokens control the number of outstanding clients.  The
  # <code>:MaxClients</code> configuration sets this.
  #
  # source://webrick//lib/webrick/server.rb#77
  def tokens; end

  private

  # Accepts a TCP client socket from the TCP server socket +svr+ and returns
  # the client socket.
  #
  # source://webrick//lib/webrick/server.rb#256
  def accept_client(svr); end

  # source://webrick//lib/webrick/server.rb#347
  def alarm_shutdown_pipe; end

  # Calls the callback +callback_name+ from the configuration with +args+
  #
  # source://webrick//lib/webrick/server.rb#334
  def call_callback(callback_name, *args); end

  # source://webrick//lib/webrick/server.rb#359
  def cleanup_listener; end

  # source://webrick//lib/webrick/server.rb#342
  def cleanup_shutdown_pipe(shutdown_pipe); end

  # source://webrick//lib/webrick/server.rb#338
  def setup_shutdown_pipe; end

  # Starts a server thread for the client socket +sock+ that runs the given
  # +block+.
  #
  # Sets the socket to the <code>:WEBrickSocket</code> thread local variable
  # in the thread.
  #
  # If any errors occur in the block they are logged and handled.
  #
  # source://webrick//lib/webrick/server.rb#288
  def start_thread(sock, &block); end
end

module WEBrick::HTMLUtils
  private

  # Escapes &, ", > and < in +string+
  #
  # source://webrick//lib/webrick/htmlutils.rb#18
  def escape(string); end

  class << self
    # Escapes &, ", > and < in +string+
    #
    # source://webrick//lib/webrick/htmlutils.rb#18
    def escape(string); end
  end
end

# HTTPAuth provides both basic and digest authentication.
#
# To enable authentication for requests in WEBrick you will need a user
# database and an authenticator.  To start, here's an Htpasswd database for
# use with a DigestAuth authenticator:
#
#   config = { :Realm => 'DigestAuth example realm' }
#
#   htpasswd = WEBrick::HTTPAuth::Htpasswd.new 'my_password_file'
#   htpasswd.auth_type = WEBrick::HTTPAuth::DigestAuth
#   htpasswd.set_passwd config[:Realm], 'username', 'password'
#   htpasswd.flush
#
# The +:Realm+ is used to provide different access to different groups
# across several resources on a server.  Typically you'll need only one
# realm for a server.
#
# This database can be used to create an authenticator:
#
#   config[:UserDB] = htpasswd
#
#   digest_auth = WEBrick::HTTPAuth::DigestAuth.new config
#
# To authenticate a request call #authenticate with a request and response
# object in a servlet:
#
#   def do_GET req, res
#     @authenticator.authenticate req, res
#   end
#
# For digest authentication the authenticator must not be created every
# request, it must be passed in as an option via WEBrick::HTTPServer#mount.
module WEBrick::HTTPAuth
  private

  # source://webrick//lib/webrick/httpauth.rb#57
  def _basic_auth(req, res, realm, req_field, res_field, err_type, block); end

  # Simple wrapper for providing basic authentication for a request.  When
  # called with a request +req+, response +res+, authentication +realm+ and
  # +block+ the block will be called with a +username+ and +password+.  If
  # the block returns true the request is allowed to continue, otherwise an
  # HTTPStatus::Unauthorized error is raised.
  #
  # source://webrick//lib/webrick/httpauth.rb#79
  def basic_auth(req, res, realm, &block); end

  # Simple wrapper for providing basic authentication for a proxied request.
  # When called with a request +req+, response +res+, authentication +realm+
  # and +block+ the block will be called with a +username+ and +password+.
  # If the block returns true the request is allowed to continue, otherwise
  # an HTTPStatus::ProxyAuthenticationRequired error is raised.
  #
  # source://webrick//lib/webrick/httpauth.rb#91
  def proxy_basic_auth(req, res, realm, &block); end

  class << self
    # source://webrick//lib/webrick/httpauth.rb#57
    def _basic_auth(req, res, realm, req_field, res_field, err_type, block); end

    # Simple wrapper for providing basic authentication for a request.  When
    # called with a request +req+, response +res+, authentication +realm+ and
    # +block+ the block will be called with a +username+ and +password+.  If
    # the block returns true the request is allowed to continue, otherwise an
    # HTTPStatus::Unauthorized error is raised.
    #
    # source://webrick//lib/webrick/httpauth.rb#79
    def basic_auth(req, res, realm, &block); end

    # Simple wrapper for providing basic authentication for a proxied request.
    # When called with a request +req+, response +res+, authentication +realm+
    # and +block+ the block will be called with a +username+ and +password+.
    # If the block returns true the request is allowed to continue, otherwise
    # an HTTPStatus::ProxyAuthenticationRequired error is raised.
    #
    # source://webrick//lib/webrick/httpauth.rb#91
    def proxy_basic_auth(req, res, realm, &block); end
  end
end

# Module providing generic support for both Digest and Basic
# authentication schemes.
module WEBrick::HTTPAuth::Authenticator
  # The logger for this authenticator
  #
  # source://webrick//lib/webrick/httpauth/authenticator.rb#43
  def logger; end

  # The realm this authenticator covers
  #
  # source://webrick//lib/webrick/httpauth/authenticator.rb#33
  def realm; end

  # The user database for this authenticator
  #
  # source://webrick//lib/webrick/httpauth/authenticator.rb#38
  def userdb; end

  private

  # Initializes the authenticator from +config+
  #
  # source://webrick//lib/webrick/httpauth/authenticator.rb#52
  def check_init(config); end

  # Ensures +req+ has credentials that can be authenticated.
  #
  # source://webrick//lib/webrick/httpauth/authenticator.rb#72
  def check_scheme(req); end

  # source://webrick//lib/webrick/httpauth/authenticator.rb#91
  def error(fmt, *args); end

  # source://webrick//lib/webrick/httpauth/authenticator.rb#97
  def info(fmt, *args); end

  # source://webrick//lib/webrick/httpauth/authenticator.rb#85
  def log(meth, fmt, *args); end
end

# source://webrick//lib/webrick/httpauth/authenticator.rb#23
WEBrick::HTTPAuth::Authenticator::AuthException = WEBrick::HTTPStatus::Unauthorized

# Basic Authentication for WEBrick
#
# Use this class to add basic authentication to a WEBrick servlet.
#
# Here is an example of how to set up a BasicAuth:
#
#   config = { :Realm => 'BasicAuth example realm' }
#
#   htpasswd = WEBrick::HTTPAuth::Htpasswd.new 'my_password_file', password_hash: :bcrypt
#   htpasswd.set_passwd config[:Realm], 'username', 'password'
#   htpasswd.flush
#
#   config[:UserDB] = htpasswd
#
#   basic_auth = WEBrick::HTTPAuth::BasicAuth.new config
class WEBrick::HTTPAuth::BasicAuth
  include ::WEBrick::HTTPAuth::Authenticator

  # Creates a new BasicAuth instance.
  #
  # See WEBrick::Config::BasicAuth for default configuration entries
  #
  # You must supply the following configuration entries:
  #
  # :Realm:: The name of the realm being protected.
  # :UserDB:: A database of usernames and passwords.
  #           A WEBrick::HTTPAuth::Htpasswd instance should be used.
  #
  # @return [BasicAuth] a new instance of BasicAuth
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#61
  def initialize(config, default = T.unsafe(nil)); end

  # Authenticates a +req+ and returns a 401 Unauthorized using +res+ if
  # the authentication was not correct.
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#70
  def authenticate(req, res); end

  # Returns a challenge response which asks for authentication information
  #
  # @raise [@auth_exception]
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#103
  def challenge(req, res); end

  # Returns the value of attribute logger.
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#48
  def logger; end

  # Returns the value of attribute realm.
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#48
  def realm; end

  # Returns the value of attribute userdb.
  #
  # source://webrick//lib/webrick/httpauth/basicauth.rb#48
  def userdb; end

  class << self
    # Used by UserDB to create a basic password entry
    #
    # source://webrick//lib/webrick/httpauth/basicauth.rb#43
    def make_passwd(realm, user, pass); end
  end
end

# RFC 2617 Digest Access Authentication for WEBrick
#
# Use this class to add digest authentication to a WEBrick servlet.
#
# Here is an example of how to set up DigestAuth:
#
#   config = { :Realm => 'DigestAuth example realm' }
#
#   htdigest = WEBrick::HTTPAuth::Htdigest.new 'my_password_file'
#   htdigest.set_passwd config[:Realm], 'username', 'password'
#   htdigest.flush
#
#   config[:UserDB] = htdigest
#
#   digest_auth = WEBrick::HTTPAuth::DigestAuth.new config
#
# When using this as with a servlet be sure not to create a new DigestAuth
# object in the servlet's #initialize.  By default WEBrick creates a new
# servlet instance for every request and the DigestAuth object must be
# used across requests.
class WEBrick::HTTPAuth::DigestAuth
  include ::WEBrick::HTTPAuth::Authenticator

  # Creates a new DigestAuth instance.  Be sure to use the same DigestAuth
  # instance for multiple requests as it saves state between requests in
  # order to perform authentication.
  #
  # See WEBrick::Config::DigestAuth for default configuration entries
  #
  # You must supply the following configuration entries:
  #
  # :Realm:: The name of the realm being protected.
  # :UserDB:: A database of usernames and passwords.
  #           A WEBrick::HTTPAuth::Htdigest instance should be used.
  #
  # @return [DigestAuth] a new instance of DigestAuth
  #
  # source://webrick//lib/webrick/httpauth/digestauth.rb#87
  def initialize(config, default = T.unsafe(nil)); end

  # Digest authentication algorithm
  #
  # source://webrick//lib/webrick/httpauth/digestauth.rb#59
  def algorithm; end

  # Authenticates a +req+ and returns a 401 Unauthorized using +res+ if
  # the authentication was not correct.
  #
  # source://webrick//lib/webrick/httpauth/digestauth.rb#121
  def authenticate(req, res); end

  # Returns a challenge response which asks for authentication information
  #
  # @raise [@auth_exception]
  #
  # source://webrick//lib/webrick/httpauth/digestauth.rb#134
  def challenge(req, res, stale = T.unsafe(nil)); end

  # Quality of protection.  RFC 2617 defines "auth" and "auth-int"
  #
  # source://webrick//lib/webrick/httpauth/digestauth.rb#64
  def qop; end

  private

  # source://webrick//lib/webrick/httpauth/digestauth.rb#163
  def _authenticate(req, res); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#306
  def check_nonce(req, auth_req); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#349
  def check_opaque(opaque_struct, req, auth_req); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#365
  def check_uri(req, auth_req); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#299
  def generate_next_nonce(req); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#332
  def generate_opaque(req); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#376
  def hexdigest(*args); end

  # source://webrick//lib/webrick/httpauth/digestauth.rb#291
  def split_param_value(string); end

  class << self
    # Used by UserDB to create a digest password entry
    #
    # source://webrick//lib/webrick/httpauth/digestauth.rb#69
    def make_passwd(realm, user, pass); end
  end
end

# Htdigest accesses apache-compatible digest password files.  Passwords are
# matched to a realm where they are valid.  For security, the path for a
# digest password database should be stored outside of the paths available
# to the HTTP server.
#
# Htdigest is intended for use with WEBrick::HTTPAuth::DigestAuth and
# stores passwords using cryptographic hashes.
#
#   htpasswd = WEBrick::HTTPAuth::Htdigest.new 'my_password_file'
#   htpasswd.set_passwd 'my realm', 'username', 'password'
#   htpasswd.flush
class WEBrick::HTTPAuth::Htdigest
  include ::WEBrick::HTTPAuth::UserDB

  # Open a digest password database at +path+
  #
  # @return [Htdigest] a new instance of Htdigest
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#37
  def initialize(path); end

  # Removes a password from the database for +user+ in +realm+.
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#113
  def delete_passwd(realm, user); end

  # Iterate passwords in the database.
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#122
  def each; end

  # Flush the password database.  If +output+ is given the database will
  # be written there instead of to the original path.
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#72
  def flush(output = T.unsafe(nil)); end

  # Retrieves a password from the database for +user+ in +realm+.  If
  # +reload_db+ is true the database will be reloaded first.
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#91
  def get_passwd(realm, user, reload_db); end

  # Reloads passwords from the database
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#50
  def reload; end

  # Sets a password in the database for +user+ in +realm+ to +pass+.
  #
  # source://webrick//lib/webrick/httpauth/htdigest.rb#101
  def set_passwd(realm, user, pass); end
end

# Htgroup accesses apache-compatible group files.  Htgroup can be used to
# provide group-based authentication for users.  Currently Htgroup is not
# directly integrated with any authenticators in WEBrick.  For security,
# the path for a digest password database should be stored outside of the
# paths available to the HTTP server.
#
# Example:
#
#   htgroup = WEBrick::HTTPAuth::Htgroup.new 'my_group_file'
#   htgroup.add 'superheroes', %w[spiderman batman]
#
#   htgroup.members('superheroes').include? 'magneto' # => false
class WEBrick::HTTPAuth::Htgroup
  # Open a group database at +path+
  #
  # @return [Htgroup] a new instance of Htgroup
  #
  # source://webrick//lib/webrick/httpauth/htgroup.rb#35
  def initialize(path); end

  # Add an Array of +members+ to +group+
  #
  # source://webrick//lib/webrick/httpauth/htgroup.rb#92
  def add(group, members); end

  # Flush the group database.  If +output+ is given the database will be
  # written there instead of to the original path.
  #
  # source://webrick//lib/webrick/httpauth/htgroup.rb#64
  def flush(output = T.unsafe(nil)); end

  # Retrieve the list of members from +group+
  #
  # source://webrick//lib/webrick/httpauth/htgroup.rb#84
  def members(group); end

  # Reload groups from the database
  #
  # source://webrick//lib/webrick/httpauth/htgroup.rb#46
  def reload; end
end

# Htpasswd accesses apache-compatible password files.  Passwords are
# matched to a realm where they are valid.  For security, the path for a
# password database should be stored outside of the paths available to the
# HTTP server.
#
# Htpasswd is intended for use with WEBrick::HTTPAuth::BasicAuth.
#
# To create an Htpasswd database with a single user:
#
#   htpasswd = WEBrick::HTTPAuth::Htpasswd.new 'my_password_file'
#   htpasswd.set_passwd 'my realm', 'username', 'password'
#   htpasswd.flush
class WEBrick::HTTPAuth::Htpasswd
  include ::WEBrick::HTTPAuth::UserDB

  # Open a password database at +path+
  #
  # @return [Htpasswd] a new instance of Htpasswd
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#38
  def initialize(path, password_hash: T.unsafe(nil)); end

  # Removes a password from the database for +user+ in +realm+.
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#144
  def delete_passwd(realm, user); end

  # Iterate passwords in the database.
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#151
  def each; end

  # Flush the password database.  If +output+ is given the database will
  # be written there instead of to the original path.
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#103
  def flush(output = T.unsafe(nil)); end

  # Retrieves a password from the database for +user+ in +realm+.  If
  # +reload_db+ is true the database will be reloaded first.
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#122
  def get_passwd(realm, user, reload_db); end

  # Reload passwords from the database
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#68
  def reload; end

  # Sets a password in the database for +user+ in +realm+ to +pass+.
  #
  # source://webrick//lib/webrick/httpauth/htpasswd.rb#130
  def set_passwd(realm, user, pass); end
end

# source://webrick//lib/webrick/httpauth/authenticator.rb#114
WEBrick::HTTPAuth::ProxyAuthenticator::AuthException = WEBrick::HTTPStatus::ProxyAuthenticationRequired

# Basic authentication for proxy servers.  See BasicAuth for details.
class WEBrick::HTTPAuth::ProxyBasicAuth < ::WEBrick::HTTPAuth::BasicAuth
  include ::WEBrick::HTTPAuth::ProxyAuthenticator
end

# Digest authentication for proxy servers.  See DigestAuth for details.
class WEBrick::HTTPAuth::ProxyDigestAuth < ::WEBrick::HTTPAuth::DigestAuth
  include ::WEBrick::HTTPAuth::ProxyAuthenticator

  private

  # source://webrick//lib/webrick/httpauth/digestauth.rb#390
  def check_uri(req, auth_req); end
end

# User database mixin for HTTPAuth.  This mixin dispatches user record
# access to the underlying auth_type for this database.
module WEBrick::HTTPAuth::UserDB
  # The authentication type.
  #
  # WEBrick::HTTPAuth::BasicAuth or WEBrick::HTTPAuth::DigestAuth are
  # built-in.
  #
  # source://webrick//lib/webrick/httpauth/userdb.rb#26
  def auth_type; end

  # The authentication type.
  #
  # WEBrick::HTTPAuth::BasicAuth or WEBrick::HTTPAuth::DigestAuth are
  # built-in.
  #
  # source://webrick//lib/webrick/httpauth/userdb.rb#26
  def auth_type=(_arg0); end

  # Retrieves a password in +realm+ for +user+ for the auth_type of this
  # database.  +reload_db+ is a dummy value.
  #
  # source://webrick//lib/webrick/httpauth/userdb.rb#48
  def get_passwd(realm, user, reload_db = T.unsafe(nil)); end

  # Creates an obscured password in +realm+ with +user+ and +password+
  # using the auth_type of this database.
  #
  # source://webrick//lib/webrick/httpauth/userdb.rb#32
  def make_passwd(realm, user, pass); end

  # Sets a password in +realm+ with +user+ and +password+ for the
  # auth_type of this database.
  #
  # source://webrick//lib/webrick/httpauth/userdb.rb#40
  def set_passwd(realm, user, pass); end
end

# --
# Adds SSL functionality to WEBrick::HTTPRequest
class WEBrick::HTTPRequest
  # Creates a new HTTP request.  WEBrick::Config::HTTP is the default
  # configuration.
  #
  # @return [HTTPRequest] a new instance of HTTPRequest
  #
  # source://webrick//lib/webrick/httprequest.rb#153
  def initialize(config); end

  # Retrieves +header_name+
  #
  # source://webrick//lib/webrick/httprequest.rb#318
  def [](header_name); end

  # The Accept header value
  #
  # source://webrick//lib/webrick/httprequest.rb#100
  def accept; end

  # The Accept-Charset header value
  #
  # source://webrick//lib/webrick/httprequest.rb#105
  def accept_charset; end

  # The Accept-Encoding header value
  #
  # source://webrick//lib/webrick/httprequest.rb#110
  def accept_encoding; end

  # The Accept-Language header value
  #
  # source://webrick//lib/webrick/httprequest.rb#115
  def accept_language; end

  # The socket address of the server
  #
  # source://webrick//lib/webrick/httprequest.rb#127
  def addr; end

  # Hash of request attributes
  #
  # source://webrick//lib/webrick/httprequest.rb#137
  def attributes; end

  # Returns the request body.
  #
  # source://webrick//lib/webrick/httprequest.rb#255
  def body(&block); end

  # Prepares the HTTPRequest object for use as the
  # source for IO.copy_stream
  #
  # source://webrick//lib/webrick/httprequest.rb#265
  def body_reader; end

  # The content-length header
  #
  # source://webrick//lib/webrick/httprequest.rb#304
  def content_length; end

  # The content-type header
  #
  # source://webrick//lib/webrick/httprequest.rb#311
  def content_type; end

  # Generate HTTP/1.1 100 continue response if the client expects it,
  # otherwise does nothing.
  #
  # source://webrick//lib/webrick/httprequest.rb#245
  def continue; end

  # The parsed request cookies
  #
  # source://webrick//lib/webrick/httprequest.rb#95
  def cookies; end

  # Iterates over the request headers
  #
  # source://webrick//lib/webrick/httprequest.rb#328
  def each; end

  # Consumes any remaining body and updates keep-alive status
  #
  # source://webrick//lib/webrick/httprequest.rb#390
  def fixup; end

  # The parsed header of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#90
  def header; end

  # The host this request is for
  #
  # source://webrick//lib/webrick/httprequest.rb#340
  def host; end

  # The HTTP version of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#51
  def http_version; end

  # Is this a keep-alive connection?
  #
  # source://webrick//lib/webrick/httprequest.rb#142
  def keep_alive; end

  # Should the connection this request was made on be kept alive?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httprequest.rb#375
  def keep_alive?; end

  # This method provides the metavariables defined by the revision 3
  # of "The WWW Common Gateway Interface Version 1.1"
  # To browse the current document of CGI Version 1.1, see below:
  # http://tools.ietf.org/html/rfc3875
  #
  # source://webrick//lib/webrick/httprequest.rb#407
  def meta_vars; end

  # Parses a request from +socket+.  This is called internally by
  # WEBrick::HTTPServer.
  #
  # source://webrick//lib/webrick/httprequest.rb#193
  def parse(socket = T.unsafe(nil)); end

  # The request path
  #
  # source://webrick//lib/webrick/httprequest.rb#63
  def path; end

  # The path info (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#73
  def path_info; end

  # The path info (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#73
  def path_info=(_arg0); end

  # The socket address of the client
  #
  # source://webrick//lib/webrick/httprequest.rb#132
  def peeraddr; end

  # The port this request is for
  #
  # source://webrick//lib/webrick/httprequest.rb#347
  def port; end

  # Request query as a Hash
  #
  # source://webrick//lib/webrick/httprequest.rb#294
  def query; end

  # The query from the URI of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#78
  def query_string; end

  # The query from the URI of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#78
  def query_string=(_arg0); end

  # The raw header of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#85
  def raw_header; end

  # for IO.copy_stream.
  #
  # source://webrick//lib/webrick/httprequest.rb#278
  def readpartial(size, buf = T.unsafe(nil)); end

  # The client's IP address
  #
  # source://webrick//lib/webrick/httprequest.rb#361
  def remote_ip; end

  # The complete request line such as:
  #
  #   GET / HTTP/1.1
  #
  # source://webrick//lib/webrick/httprequest.rb#36
  def request_line; end

  # The request method, GET, POST, PUT, etc.
  #
  # source://webrick//lib/webrick/httprequest.rb#41
  def request_method; end

  # The local time this request was received
  #
  # source://webrick//lib/webrick/httprequest.rb#147
  def request_time; end

  # The parsed URI of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#58
  def request_uri; end

  # The script name (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#68
  def script_name; end

  # The script name (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#68
  def script_name=(_arg0); end

  # The server name this request is for
  #
  # source://webrick//lib/webrick/httprequest.rb#354
  def server_name; end

  # Is this an SSL request?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httprequest.rb#368
  def ssl?; end

  # source://webrick//lib/webrick/httprequest.rb#379
  def to_s; end

  # The unparsed URI of the request
  #
  # source://webrick//lib/webrick/httprequest.rb#46
  def unparsed_uri; end

  # The remote user (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#122
  def user; end

  # The remote user (CGI variable)
  #
  # source://webrick//lib/webrick/httprequest.rb#122
  def user=(_arg0); end

  private

  # source://webrick//lib/webrick/httprequest.rb#562
  def _read_data(io, method, *arg); end

  # source://webrick//lib/webrick/httprequest.rb#582
  def parse_query; end

  # source://webrick//lib/webrick/httprequest.rb#484
  def parse_uri(str, scheme = T.unsafe(nil)); end

  # source://webrick//lib/webrick/httprequest.rb#507
  def read_body(socket, block); end

  # source://webrick//lib/webrick/httprequest.rb#531
  def read_chunk_size(socket); end

  # source://webrick//lib/webrick/httprequest.rb#542
  def read_chunked(socket, block); end

  # source://webrick//lib/webrick/httprequest.rb#578
  def read_data(io, size); end

  # source://webrick//lib/webrick/httprequest.rb#471
  def read_header(socket); end

  # source://webrick//lib/webrick/httprequest.rb#574
  def read_line(io, size = T.unsafe(nil)); end

  # @raise [HTTPStatus::EOFError]
  #
  # source://webrick//lib/webrick/httprequest.rb#451
  def read_request_line(socket); end

  # It's said that all X-Forwarded-* headers will contain more than one
  # (comma-separated) value if the original request already contained one of
  # these headers. Since we could use these values as Host header, we choose
  # the initial(first) value. (apr_table_mergen() adds new value after the
  # existing value with ", " prefix)
  #
  # source://webrick//lib/webrick/httprequest.rb#610
  def setup_forwarded_info; end
end

# same as Mongrel, Thin and Puma
#
# source://webrick//lib/webrick/httprequest.rb#449
WEBrick::HTTPRequest::MAX_HEADER_LENGTH = T.let(T.unsafe(nil), Integer)

# An HTTP response.  This is filled in by the service or do_* methods of a
# WEBrick HTTP Servlet.
class WEBrick::HTTPResponse
  # Creates a new HTTP response object.  WEBrick::Config::HTTP is the
  # default configuration.
  #
  # @return [HTTPResponse] a new instance of HTTPResponse
  #
  # source://webrick//lib/webrick/httpresponse.rb#112
  def initialize(config); end

  # Retrieves the response header +field+
  #
  # source://webrick//lib/webrick/httpresponse.rb#150
  def [](field); end

  # Sets the response header +field+ to +value+
  #
  # source://webrick//lib/webrick/httpresponse.rb#157
  def []=(field, value); end

  # source://webrick//lib/webrick/httpresponse.rb#240
  def _rack_setup_header; end

  # Body may be:
  # * a String;
  # * an IO-like object that responds to +#read+ and +#readpartial+;
  # * a Proc-like object that responds to +#call+.
  #
  # In the latter case, either #chunked= should be set to +true+,
  # or <code>header['content-length']</code> explicitly provided.
  # Example:
  #
  #   server.mount_proc '/' do |req, res|
  #     res.chunked = true
  #     # or
  #     # res.header['content-length'] = 10
  #     res.body = proc { |out| out.write(Time.now.to_s) }
  #   end
  #
  # source://webrick//lib/webrick/httpresponse.rb#70
  def body; end

  # Body may be:
  # * a String;
  # * an IO-like object that responds to +#read+ and +#readpartial+;
  # * a Proc-like object that responds to +#call+.
  #
  # In the latter case, either #chunked= should be set to +true+,
  # or <code>header['content-length']</code> explicitly provided.
  # Example:
  #
  #   server.mount_proc '/' do |req, res|
  #     res.chunked = true
  #     # or
  #     # res.header['content-length'] = 10
  #     res.body = proc { |out| out.write(Time.now.to_s) }
  #   end
  #
  # source://webrick//lib/webrick/httpresponse.rb#70
  def body=(_arg0); end

  # Enables chunked transfer encoding.
  #
  # source://webrick//lib/webrick/httpresponse.rb#209
  def chunked=(val); end

  # Will this response body be returned using chunked transfer-encoding?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpresponse.rb#202
  def chunked?; end

  # Configuration for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#101
  def config; end

  # The content-length header
  #
  # source://webrick//lib/webrick/httpresponse.rb#165
  def content_length; end

  # Sets the content-length header to +len+
  #
  # source://webrick//lib/webrick/httpresponse.rb#174
  def content_length=(len); end

  # The content-type header
  #
  # source://webrick//lib/webrick/httpresponse.rb#181
  def content_type; end

  # Sets the content-type header to +type+
  #
  # source://webrick//lib/webrick/httpresponse.rb#188
  def content_type=(type); end

  # Response cookies
  #
  # source://webrick//lib/webrick/httpresponse.rb#46
  def cookies; end

  # Iterates over each header in the response
  #
  # source://webrick//lib/webrick/httpresponse.rb#195
  def each; end

  # Filename of the static file in this response.  Only used by the
  # FileHandler servlet.
  #
  # source://webrick//lib/webrick/httpresponse.rb#91
  def filename; end

  # Filename of the static file in this response.  Only used by the
  # FileHandler servlet.
  #
  # source://webrick//lib/webrick/httpresponse.rb#91
  def filename=(_arg0); end

  # Response header
  #
  # source://webrick//lib/webrick/httpresponse.rb#41
  def header; end

  # HTTP Response version
  #
  # source://webrick//lib/webrick/httpresponse.rb#31
  def http_version; end

  # Is this a keep-alive response?
  #
  # source://webrick//lib/webrick/httpresponse.rb#96
  def keep_alive; end

  # Is this a keep-alive response?
  #
  # source://webrick//lib/webrick/httpresponse.rb#96
  def keep_alive=(_arg0); end

  # Will this response's connection be kept alive?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpresponse.rb#216
  def keep_alive?; end

  # source://webrick//lib/webrick/httpresponse.rb#303
  def make_body_tempfile; end

  # Response reason phrase ("OK")
  #
  # source://webrick//lib/webrick/httpresponse.rb#51
  def reason_phrase; end

  # Response reason phrase ("OK")
  #
  # source://webrick//lib/webrick/httpresponse.rb#51
  def reason_phrase=(_arg0); end

  # source://webrick//lib/webrick/httpresponse.rb#321
  def remove_body_tempfile; end

  # Request HTTP version for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#85
  def request_http_version; end

  # Request HTTP version for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#85
  def request_http_version=(_arg0); end

  # Request method for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#75
  def request_method; end

  # Request method for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#75
  def request_method=(_arg0); end

  # Request URI for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#80
  def request_uri; end

  # Request URI for this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#80
  def request_uri=(_arg0); end

  # Sends the body on +socket+
  #
  # source://webrick//lib/webrick/httpresponse.rb#356
  def send_body(socket); end

  # Sends the headers on +socket+
  #
  # source://webrick//lib/webrick/httpresponse.rb#333
  def send_header(socket); end

  # Sends the response on +socket+
  #
  # source://webrick//lib/webrick/httpresponse.rb#223
  def send_response(socket); end

  # Bytes sent in this response
  #
  # source://webrick//lib/webrick/httpresponse.rb#106
  def sent_size; end

  # Creates an error page for exception +ex+ with an optional +backtrace+
  #
  # source://webrick//lib/webrick/httpresponse.rb#383
  def set_error(ex, backtrace = T.unsafe(nil)); end

  # Redirects to +url+ with a WEBrick::HTTPStatus::Redirect +status+.
  #
  # Example:
  #
  #   res.set_redirect WEBrick::HTTPStatus::TemporaryRedirect
  #
  # source://webrick//lib/webrick/httpresponse.rb#373
  def set_redirect(status, url); end

  # Response status code (200)
  #
  # source://webrick//lib/webrick/httpresponse.rb#36
  def status; end

  # Sets the response's status to the +status+ code
  #
  # source://webrick//lib/webrick/httpresponse.rb#142
  def status=(status); end

  # The response's HTTP status line
  #
  # source://webrick//lib/webrick/httpresponse.rb#135
  def status_line; end

  private

  # preserved for compatibility with some 3rd-party handlers
  #
  # source://webrick//lib/webrick/httpresponse.rb#557
  def _write_data(socket, data); end

  # source://webrick//lib/webrick/httpresponse.rb#410
  def check_header(header_value); end

  # :stopdoc:
  #
  # source://webrick//lib/webrick/httpresponse.rb#421
  def error_body(backtrace, ex, host, port); end

  # source://webrick//lib/webrick/httpresponse.rb#451
  def send_body_io(socket); end

  # source://webrick//lib/webrick/httpresponse.rb#513
  def send_body_proc(socket); end

  # source://webrick//lib/webrick/httpresponse.rb#491
  def send_body_string(socket); end
end

class WEBrick::HTTPResponse::ChunkedWrapper
  # @return [ChunkedWrapper] a new instance of ChunkedWrapper
  #
  # source://webrick//lib/webrick/httpresponse.rb#532
  def initialize(socket, resp); end

  # source://webrick//lib/webrick/httpresponse.rb#550
  def <<(*buf); end

  # source://webrick//lib/webrick/httpresponse.rb#537
  def write(buf); end
end

# An HTTP Server
class WEBrick::HTTPServer < ::WEBrick::GenericServer
  # Creates a new HTTP server according to +config+
  #
  # An HTTP server uses the following attributes:
  #
  # :AccessLog:: An array of access logs.  See WEBrick::AccessLog
  # :BindAddress:: Local address for the server to bind to
  # :DocumentRoot:: Root path to serve files from
  # :DocumentRootOptions:: Options for the default HTTPServlet::FileHandler
  # :HTTPVersion:: The HTTP version of this server
  # :Port:: Port to listen on
  # :RequestCallback:: Called with a request and response before each
  #                    request is serviced.
  # :RequestTimeout:: Maximum time to wait between requests
  # :ServerAlias:: Array of alternate names for this server for virtual
  #                hosting
  # :ServerName:: Name for this server for virtual hosting
  #
  # @return [HTTPServer] a new instance of HTTPServer
  #
  # source://webrick//lib/webrick/httpserver.rb#46
  def initialize(config = T.unsafe(nil), default = T.unsafe(nil)); end

  # Logs +req+ and +res+ in the access logs.  +config+ is used for the
  # server name.
  #
  # source://webrick//lib/webrick/httpserver.rb#220
  def access_log(config, req, res); end

  # Creates the HTTPRequest used when handling the HTTP
  # request. Can be overridden by subclasses.
  #
  # source://webrick//lib/webrick/httpserver.rb#230
  def create_request(with_webrick_config); end

  # Creates the HTTPResponse used when handling the HTTP
  # request. Can be overridden by subclasses.
  #
  # source://webrick//lib/webrick/httpserver.rb#237
  def create_response(with_webrick_config); end

  # The default OPTIONS request handler says GET, HEAD, POST and OPTIONS
  # requests are allowed.
  #
  # source://webrick//lib/webrick/httpserver.rb#147
  def do_OPTIONS(req, res); end

  # Finds the appropriate virtual host to handle +req+
  #
  # source://webrick//lib/webrick/httpserver.rb#207
  def lookup_server(req); end

  # Mounts +servlet+ on +dir+ passing +options+ to the servlet at creation
  # time
  #
  # source://webrick//lib/webrick/httpserver.rb#155
  def mount(dir, servlet, *options); end

  # Mounts +proc+ or +block+ on +dir+ and calls it with a
  # WEBrick::HTTPRequest and WEBrick::HTTPResponse
  #
  # @raise [HTTPServerError]
  #
  # source://webrick//lib/webrick/httpserver.rb#164
  def mount_proc(dir, proc = T.unsafe(nil), &block); end

  # Processes requests on +sock+
  #
  # source://webrick//lib/webrick/httpserver.rb#69
  def run(sock); end

  # Finds a servlet for +path+
  #
  # source://webrick//lib/webrick/httpserver.rb#182
  def search_servlet(path); end

  # Services +req+ and fills in +res+
  #
  # @raise [HTTPStatus::NotFound]
  #
  # source://webrick//lib/webrick/httpserver.rb#125
  def service(req, res); end

  # Unmounts +dir+
  #
  # source://webrick//lib/webrick/httpserver.rb#173
  def umount(dir); end

  # Unmounts +dir+
  #
  # source://webrick//lib/webrick/httpserver.rb#173
  def unmount(dir); end

  # Adds +server+ as a virtual host.
  #
  # source://webrick//lib/webrick/httpserver.rb#193
  def virtual_host(server); end
end

# Mount table for the path a servlet is mounted on in the directory space
# of the server.  Users of WEBrick can only access this indirectly via
# WEBrick::HTTPServer#mount, WEBrick::HTTPServer#unmount and
# WEBrick::HTTPServer#search_servlet
class WEBrick::HTTPServer::MountTable
  # @return [MountTable] a new instance of MountTable
  #
  # source://webrick//lib/webrick/httpserver.rb#248
  def initialize; end

  # source://webrick//lib/webrick/httpserver.rb#253
  def [](dir); end

  # source://webrick//lib/webrick/httpserver.rb#258
  def []=(dir, val); end

  # source://webrick//lib/webrick/httpserver.rb#265
  def delete(dir); end

  # source://webrick//lib/webrick/httpserver.rb#272
  def scan(path); end

  private

  # source://webrick//lib/webrick/httpserver.rb#279
  def compile; end

  # source://webrick//lib/webrick/httpserver.rb#287
  def normalize(dir); end
end

# AbstractServlet allows HTTP server modules to be reused across multiple
# servers and allows encapsulation of functionality.
#
# By default a servlet will respond to GET, HEAD (through an alias to GET)
# and OPTIONS requests.
#
# By default a new servlet is initialized for every request.  A servlet
# instance can be reused by overriding ::get_instance in the
# AbstractServlet subclass.
#
# == A Simple Servlet
#
#  class Simple < WEBrick::HTTPServlet::AbstractServlet
#    def do_GET request, response
#      status, content_type, body = do_stuff_with request
#
#      response.status = status
#      response['Content-Type'] = content_type
#      response.body = body
#    end
#
#    def do_stuff_with request
#      return 200, 'text/plain', 'you got a page'
#    end
#  end
#
# This servlet can be mounted on a server at a given path:
#
#   server.mount '/simple', Simple
#
# == Servlet Configuration
#
# Servlets can be configured via initialize.  The first argument is the
# HTTP server the servlet is being initialized for.
#
#  class Configurable < Simple
#    def initialize server, color, size
#      super server
#      @color = color
#      @size = size
#    end
#
#    def do_stuff_with request
#      content = "<p " \
#                %q{style="color: #{@color}; font-size: #{@size}"} \
#                ">Hello, World!"
#
#      return 200, "text/html", content
#    end
#  end
#
# This servlet must be provided two arguments at mount time:
#
#   server.mount '/configurable', Configurable, 'red', '2em'
class WEBrick::HTTPServlet::AbstractServlet
  # Initializes a new servlet for +server+ using +options+ which are
  # stored as-is in +@options+.  +@logger+ is also provided.
  #
  # @return [AbstractServlet] a new instance of AbstractServlet
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#91
  def initialize(server, *options); end

  # Raises a NotFound exception
  #
  # @raise [HTTPStatus::NotFound]
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#115
  def do_GET(req, res); end

  # Dispatches to do_GET
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#122
  def do_HEAD(req, res); end

  # Returns the allowed HTTP request methods
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#129
  def do_OPTIONS(req, res); end

  # Dispatches to a +do_+ method based on +req+ if such a method is
  # available.  (+do_GET+ for a GET request).  Raises a MethodNotAllowed
  # exception if the method is not implemented.
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#102
  def service(req, res); end

  private

  # Redirects to a path ending in /
  #
  # source://webrick//lib/webrick/httpservlet/abstract.rb#140
  def redirect_to_directory_uri(req, res); end

  class << self
    # Factory for servlet instances that will handle a request from +server+
    # using +options+ from the mount point.  By default a new servlet
    # instance is created for every call.
    #
    # source://webrick//lib/webrick/httpservlet/abstract.rb#83
    def get_instance(server, *options); end
  end
end

# Servlet for handling CGI scripts
#
# Example:
#
#  server.mount('/cgi/my_script', WEBrick::HTTPServlet::CGIHandler,
#               '/path/to/my_script')
class WEBrick::HTTPServlet::CGIHandler < ::WEBrick::HTTPServlet::AbstractServlet
  # Creates a new CGI script servlet for the script at +name+
  #
  # @return [CGIHandler] a new instance of CGIHandler
  #
  # source://webrick//lib/webrick/httpservlet/cgihandler.rb#36
  def initialize(server, name); end

  # :stopdoc:
  #
  # @raise [HTTPStatus::InternalServerError]
  #
  # source://webrick//lib/webrick/httpservlet/cgihandler.rb#50
  def do_GET(req, res); end

  # :stopdoc:
  #
  # @raise [HTTPStatus::InternalServerError]
  #
  # source://webrick//lib/webrick/httpservlet/cgihandler.rb#50
  def do_POST(req, res); end
end

# source://webrick//lib/webrick/httpservlet/cgihandler.rb#31
WEBrick::HTTPServlet::CGIHandler::CGIRunnerArray = T.let(T.unsafe(nil), Array)

# Servlet for serving a single file.  You probably want to use the
# FileHandler servlet instead as it handles directories and fancy indexes.
#
# Example:
#
#   server.mount('/my_page.txt', WEBrick::HTTPServlet::DefaultFileHandler,
#                '/path/to/my_page.txt')
#
# This servlet handles If-Modified-Since and Range requests.
class WEBrick::HTTPServlet::DefaultFileHandler < ::WEBrick::HTTPServlet::AbstractServlet
  # Creates a DefaultFileHandler instance for the file at +local_path+.
  #
  # @return [DefaultFileHandler] a new instance of DefaultFileHandler
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#37
  def initialize(server, local_path); end

  # :stopdoc:
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#44
  def do_GET(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#118
  def make_partial_content(req, res, filename, filesize); end

  # returns a lambda for webrick/httpresponse.rb send_body_proc
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#90
  def multipart_body(body, parts, boundary, mtype, filesize); end

  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#64
  def not_modified?(req, res, mtime, etag); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#155
  def prepare_range(range, filesize); end
end

# ERBHandler evaluates an ERB file and returns the result.  This handler
# is automatically used if there are .rhtml files in a directory served by
# the FileHandler.
#
# ERBHandler supports GET and POST methods.
#
# The ERB file is evaluated with the local variables +servlet_request+ and
# +servlet_response+ which are a WEBrick::HTTPRequest and
# WEBrick::HTTPResponse respectively.
#
# Example .rhtml file:
#
#   Request to <%= servlet_request.request_uri %>
#
#   Query params <%= servlet_request.query.inspect %>
class WEBrick::HTTPServlet::ERBHandler < ::WEBrick::HTTPServlet::AbstractServlet
  # Creates a new ERBHandler on +server+ that will evaluate and serve the
  # ERB file +name+
  #
  # @return [ERBHandler] a new instance of ERBHandler
  #
  # source://webrick//lib/webrick/httpservlet/erbhandler.rb#42
  def initialize(server, name); end

  # Handles GET requests
  #
  # source://webrick//lib/webrick/httpservlet/erbhandler.rb#50
  def do_GET(req, res); end

  # Handles GET requests
  #
  # Handles POST requests
  #
  # source://webrick//lib/webrick/httpservlet/erbhandler.rb#50
  def do_POST(req, res); end

  private

  # Evaluates +erb+ providing +servlet_request+ and +servlet_response+ as
  # local variables.
  #
  # source://webrick//lib/webrick/httpservlet/erbhandler.rb#79
  def evaluate(erb, servlet_request, servlet_response); end
end

# Serves a directory including fancy indexing and a variety of other
# options.
#
# Example:
#
#   server.mount('/assets', WEBrick::HTTPServlet::FileHandler,
#                '/path/to/assets')
class WEBrick::HTTPServlet::FileHandler < ::WEBrick::HTTPServlet::AbstractServlet
  # Creates a FileHandler servlet on +server+ that serves files starting
  # at directory +root+
  #
  # +options+ may be a Hash containing keys from
  # WEBrick::Config::FileHandler or +true+ or +false+.
  #
  # If +options+ is true or false then +:FancyIndexing+ is enabled or
  # disabled respectively.
  #
  # @return [FileHandler] a new instance of FileHandler
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#203
  def initialize(server, root, options = T.unsafe(nil), default = T.unsafe(nil)); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#245
  def do_GET(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#257
  def do_OPTIONS(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#251
  def do_POST(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#224
  def service(req, res); end

  # :stopdoc:
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#215
  def set_filesystem_encoding(str); end

  private

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#416
  def call_callback(callback_name, req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#369
  def check_filename(req, res, name); end

  # @raise [HTTPStatus::NotFound]
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#309
  def exec_handler(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#322
  def get_handler(req, res); end

  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#428
  def nondisclosure_name?(name); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#286
  def prevent_directory_traversal(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#394
  def search_file(req, res, basename); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#385
  def search_index_file(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#437
  def set_dir_list(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#335
  def set_filename(req, res); end

  # source://webrick//lib/webrick/httpservlet/filehandler.rb#376
  def shift_path_info(req, res, path_info, base = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#277
  def trailing_pathsep?(path); end

  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpservlet/filehandler.rb#422
  def windows_ambiguous_name?(name); end

  class << self
    # Allow custom handling of requests for files with +suffix+ by class
    # +handler+
    #
    # source://webrick//lib/webrick/httpservlet/filehandler.rb#182
    def add_handler(suffix, handler); end

    # Remove custom handling of requests for files with +suffix+
    #
    # source://webrick//lib/webrick/httpservlet/filehandler.rb#189
    def remove_handler(suffix); end
  end
end

# This module is used to manager HTTP status codes.
#
# See http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html for more
# information.
module WEBrick::HTTPStatus
  private

  # Is +code+ a client error status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#170
  def client_error?(code); end

  # Is +code+ an error status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#164
  def error?(code); end

  # Is +code+ an informational status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#146
  def info?(code); end

  # Returns the description corresponding to the HTTP status +code+
  #
  #   WEBrick::HTTPStatus.reason_phrase 404
  #   => "Not Found"
  #
  # source://webrick//lib/webrick/httpstatus.rb#140
  def reason_phrase(code); end

  # Is +code+ a redirection status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#158
  def redirect?(code); end

  # Is +code+ a server error status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#176
  def server_error?(code); end

  # Is +code+ a successful status?
  #
  # @return [Boolean]
  #
  # source://webrick//lib/webrick/httpstatus.rb#152
  def success?(code); end

  class << self
    # Returns the status class corresponding to +code+
    #
    #   WEBrick::HTTPStatus[302]
    #   => WEBrick::HTTPStatus::NotFound
    #
    # source://webrick//lib/webrick/httpstatus.rb#186
    def [](code); end

    # Is +code+ a client error status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#170
    def client_error?(code); end

    # Is +code+ an error status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#164
    def error?(code); end

    # Is +code+ an informational status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#146
    def info?(code); end

    # Returns the description corresponding to the HTTP status +code+
    #
    #   WEBrick::HTTPStatus.reason_phrase 404
    #   => "Not Found"
    #
    # source://webrick//lib/webrick/httpstatus.rb#140
    def reason_phrase(code); end

    # Is +code+ a redirection status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#158
    def redirect?(code); end

    # Is +code+ a server error status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#176
    def server_error?(code); end

    # Is +code+ a successful status?
    #
    # @return [Boolean]
    #
    # source://webrick//lib/webrick/httpstatus.rb#152
    def success?(code); end
  end
end

# Root of the HTTP status class hierarchy
class WEBrick::HTTPStatus::Status < ::StandardError
  # Returns the HTTP status code
  #
  # source://webrick//lib/webrick/httpstatus.rb#31
  def code; end

  # Returns the HTTP status description
  #
  # source://webrick//lib/webrick/httpstatus.rb#34
  def reason_phrase; end

  # Returns the HTTP status code
  #
  # source://webrick//lib/webrick/httpstatus.rb#31
  def to_i; end

  class << self
    # source://webrick//lib/webrick/httpstatus.rb#27
    def code; end

    # source://webrick//lib/webrick/httpstatus.rb#27
    def reason_phrase; end
  end
end

# HTTPUtils provides utility methods for working with the HTTP protocol.
#
# This module is generally used internally by WEBrick
module WEBrick::HTTPUtils
  private

  # source://webrick//lib/webrick/httputils.rb#443
  def _escape(str, regex); end

  # :stopdoc:
  #
  # source://webrick//lib/webrick/httputils.rb#441
  def _make_regex(str); end

  # source://webrick//lib/webrick/httputils.rb#442
  def _make_regex!(str); end

  # source://webrick//lib/webrick/httputils.rb#449
  def _unescape(str, regex); end

  # Removes quotes and escapes from +str+
  #
  # source://webrick//lib/webrick/httputils.rb#223
  def dequote(str); end

  # Escapes HTTP reserved and unwise characters in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#467
  def escape(str); end

  # Escapes 8 bit characters in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#508
  def escape8bit(str); end

  # Escapes form reserved characters in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#481
  def escape_form(str); end

  # Escapes path +str+
  #
  # source://webrick//lib/webrick/httputils.rb#497
  def escape_path(str); end

  # Loads Apache-compatible mime.types in +file+.
  #
  # source://webrick//lib/webrick/httputils.rb#112
  def load_mime_types(file); end

  # Returns the mime type of +filename+ from the list in +mime_tab+.  If no
  # mime type was found application/octet-stream is returned.
  #
  # source://webrick//lib/webrick/httputils.rb#134
  def mime_type(filename, mime_tab); end

  # Normalizes a request path.  Raises an exception if the path cannot be
  # normalized.
  #
  # source://webrick//lib/webrick/httputils.rb#31
  def normalize_path(path); end

  # Parses form data in +io+ with the given +boundary+
  #
  # source://webrick//lib/webrick/httputils.rb#395
  def parse_form_data(io, boundary); end

  # Parses an HTTP header +raw+ into a hash of header fields with an Array
  # of values.
  #
  # source://webrick//lib/webrick/httputils.rb#145
  def parse_header(raw); end

  # Parses the query component of a URI in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#371
  def parse_query(str); end

  # Parses q values in +value+ as used in Accept headers.
  #
  # source://webrick//lib/webrick/httputils.rb#202
  def parse_qvalues(value); end

  # Parses a Range header value +ranges_specifier+
  #
  # source://webrick//lib/webrick/httputils.rb#184
  def parse_range_header(ranges_specifier); end

  # Quotes and escapes quotes in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#233
  def quote(str); end

  # Splits a header value +str+ according to HTTP specification.
  #
  # source://webrick//lib/webrick/httputils.rb#175
  def split_header_value(str); end

  # Unescapes HTTP reserved and unwise characters in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#474
  def unescape(str); end

  # Unescapes form reserved characters in +str+
  #
  # source://webrick//lib/webrick/httputils.rb#490
  def unescape_form(str); end

  class << self
    # source://webrick//lib/webrick/httputils.rb#443
    def _escape(str, regex); end

    # :stopdoc:
    #
    # source://webrick//lib/webrick/httputils.rb#441
    def _make_regex(str); end

    # source://webrick//lib/webrick/httputils.rb#442
    def _make_regex!(str); end

    # source://webrick//lib/webrick/httputils.rb#449
    def _unescape(str, regex); end

    # Removes quotes and escapes from +str+
    #
    # source://webrick//lib/webrick/httputils.rb#223
    def dequote(str); end

    # Escapes HTTP reserved and unwise characters in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#467
    def escape(str); end

    # Escapes 8 bit characters in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#508
    def escape8bit(str); end

    # Escapes form reserved characters in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#481
    def escape_form(str); end

    # Escapes path +str+
    #
    # source://webrick//lib/webrick/httputils.rb#497
    def escape_path(str); end

    # Loads Apache-compatible mime.types in +file+.
    #
    # source://webrick//lib/webrick/httputils.rb#112
    def load_mime_types(file); end

    # Returns the mime type of +filename+ from the list in +mime_tab+.  If no
    # mime type was found application/octet-stream is returned.
    #
    # source://webrick//lib/webrick/httputils.rb#134
    def mime_type(filename, mime_tab); end

    # Normalizes a request path.  Raises an exception if the path cannot be
    # normalized.
    #
    # source://webrick//lib/webrick/httputils.rb#31
    def normalize_path(path); end

    # Parses form data in +io+ with the given +boundary+
    #
    # source://webrick//lib/webrick/httputils.rb#395
    def parse_form_data(io, boundary); end

    # Parses an HTTP header +raw+ into a hash of header fields with an Array
    # of values.
    #
    # source://webrick//lib/webrick/httputils.rb#145
    def parse_header(raw); end

    # Parses the query component of a URI in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#371
    def parse_query(str); end

    # Parses q values in +value+ as used in Accept headers.
    #
    # source://webrick//lib/webrick/httputils.rb#202
    def parse_qvalues(value); end

    # Parses a Range header value +ranges_specifier+
    #
    # source://webrick//lib/webrick/httputils.rb#184
    def parse_range_header(ranges_specifier); end

    # Quotes and escapes quotes in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#233
    def quote(str); end

    # Splits a header value +str+ according to HTTP specification.
    #
    # source://webrick//lib/webrick/httputils.rb#175
    def split_header_value(str); end

    # Unescapes HTTP reserved and unwise characters in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#474
    def unescape(str); end

    # Unescapes form reserved characters in +str+
    #
    # source://webrick//lib/webrick/httputils.rb#490
    def unescape_form(str); end
  end
end

# Stores multipart form data.  FormData objects are created when
# WEBrick::HTTPUtils.parse_form_data is called.
class WEBrick::HTTPUtils::FormData < ::String
  # Creates a new FormData object.
  #
  # +args+ is an Array of form data entries.  One FormData will be created
  # for each entry.
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you
  #
  # @return [FormData] a new instance of FormData
  #
  # source://webrick//lib/webrick/httputils.rb#267
  def initialize(*args); end

  # Adds +str+ to this FormData which may be the body, a header or a
  # header entry.
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you
  #
  # source://webrick//lib/webrick/httputils.rb#300
  def <<(str); end

  # Retrieves the header at the first entry in +key+
  #
  # source://webrick//lib/webrick/httputils.rb#286
  def [](*key); end

  # Adds +data+ at the end of the chain of entries
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you.
  #
  # source://webrick//lib/webrick/httputils.rb#320
  def append_data(data); end

  # Yields each entry in this FormData
  #
  # source://webrick//lib/webrick/httputils.rb#335
  def each_data; end

  # The filename of the form data part
  #
  # source://webrick//lib/webrick/httputils.rb#254
  def filename; end

  # The filename of the form data part
  #
  # source://webrick//lib/webrick/httputils.rb#254
  def filename=(_arg0); end

  # Returns all the FormData as an Array
  #
  # source://webrick//lib/webrick/httputils.rb#347
  def list; end

  # The name of the form data part
  #
  # source://webrick//lib/webrick/httputils.rb#249
  def name; end

  # The name of the form data part
  #
  # source://webrick//lib/webrick/httputils.rb#249
  def name=(_arg0); end

  # source://webrick//lib/webrick/httputils.rb#256
  def next_data=(_arg0); end

  # Returns all the FormData as an Array
  #
  # A FormData will behave like an Array
  #
  # source://webrick//lib/webrick/httputils.rb#347
  def to_ary; end

  # This FormData's body
  #
  # source://webrick//lib/webrick/httputils.rb#363
  def to_s; end

  protected

  # source://webrick//lib/webrick/httputils.rb#256
  def next_data; end
end

module WEBrick::Utils
  private

  # Creates TCP server sockets bound to +address+:+port+ and returns them.
  #
  # It will create IPV4 and IPV6 sockets on all interfaces.
  #
  # source://webrick//lib/webrick/utils.rb#56
  def create_listeners(address, port); end

  # The server hostname
  #
  # source://webrick//lib/webrick/utils.rb#47
  def getservername; end

  # Generates a random string of length +len+
  #
  # source://webrick//lib/webrick/utils.rb#79
  def random_string(len); end

  # Sets the close on exec flag for +io+
  #
  # source://webrick//lib/webrick/utils.rb#27
  def set_close_on_exec(io); end

  # Sets IO operations on +io+ to be non-blocking
  #
  # source://webrick//lib/webrick/utils.rb#20
  def set_non_blocking(io); end

  # Changes the process's uid and gid to the ones of +user+
  #
  # source://webrick//lib/webrick/utils.rb#34
  def su(user); end

  # Executes the passed block and raises +exception+ if execution takes more
  # than +seconds+.
  #
  # If +seconds+ is zero or nil, simply executes the block
  #
  # source://webrick//lib/webrick/utils.rb#253
  def timeout(seconds, exception = T.unsafe(nil)); end

  class << self
    # Creates TCP server sockets bound to +address+:+port+ and returns them.
    #
    # It will create IPV4 and IPV6 sockets on all interfaces.
    #
    # source://webrick//lib/webrick/utils.rb#56
    def create_listeners(address, port); end

    # The server hostname
    #
    # source://webrick//lib/webrick/utils.rb#47
    def getservername; end

    # Generates a random string of length +len+
    #
    # source://webrick//lib/webrick/utils.rb#79
    def random_string(len); end

    # Sets the close on exec flag for +io+
    #
    # source://webrick//lib/webrick/utils.rb#27
    def set_close_on_exec(io); end

    # Sets IO operations on +io+ to be non-blocking
    #
    # source://webrick//lib/webrick/utils.rb#20
    def set_non_blocking(io); end

    # Changes the process's uid and gid to the ones of +user+
    #
    # source://webrick//lib/webrick/utils.rb#34
    def su(user); end

    # Executes the passed block and raises +exception+ if execution takes more
    # than +seconds+.
    #
    # If +seconds+ is zero or nil, simply executes the block
    #
    # source://webrick//lib/webrick/utils.rb#253
    def timeout(seconds, exception = T.unsafe(nil)); end
  end
end

# Class used to manage timeout handlers across multiple threads.
#
# Timeout handlers should be managed by using the class methods which are
# synchronized.
#
#   id = TimeoutHandler.register(10, Timeout::Error)
#   begin
#     sleep 20
#     puts 'foo'
#   ensure
#     TimeoutHandler.cancel(id)
#   end
#
# will raise Timeout::Error
#
#   id = TimeoutHandler.register(10, Timeout::Error)
#   begin
#     sleep 5
#     puts 'foo'
#   ensure
#     TimeoutHandler.cancel(id)
#   end
#
# will print 'foo'
class WEBrick::Utils::TimeoutHandler
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # Creates a new TimeoutHandler.  You should use ::register and ::cancel
  # instead of creating the timeout handler directly.
  #
  # @return [TimeoutHandler] a new instance of TimeoutHandler
  #
  # source://webrick//lib/webrick/utils.rb#148
  def initialize; end

  # Cancels the timeout handler +id+
  #
  # source://webrick//lib/webrick/utils.rb#226
  def cancel(thread, id); end

  # Interrupts the timeout handler +id+ and raises +exception+
  #
  # source://webrick//lib/webrick/utils.rb#203
  def interrupt(thread, id, exception); end

  # Registers a new timeout handler
  #
  # +time+:: Timeout in seconds
  # +exception+:: Exception to raise when timeout elapsed
  #
  # source://webrick//lib/webrick/utils.rb#214
  def register(thread, time, exception); end

  # source://webrick//lib/webrick/utils.rb#240
  def terminate; end

  private

  # source://webrick//lib/webrick/utils.rb#158
  def watch; end

  # source://webrick//lib/webrick/utils.rb#193
  def watcher; end

  class << self
    # Cancels the timeout handler +id+
    #
    # source://webrick//lib/webrick/utils.rb#137
    def cancel(id); end

    # Registers a new timeout handler
    #
    # +time+:: Timeout in seconds
    # +exception+:: Exception to raise when timeout elapsed
    #
    # source://webrick//lib/webrick/utils.rb#130
    def register(seconds, exception); end

    # source://webrick//lib/webrick/utils.rb#141
    def terminate; end
  end
end
