# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `timeout` gem.
# Please instead update this file by running `bin/tapioca gem timeout`.

# source://timeout//lib/timeout.rb#25
module Timeout
  private

  # Perform an operation in a block, raising an error if it takes longer than
  # +sec+ seconds to complete.
  #
  # +sec+:: Number of seconds to wait for the block to terminate. Any number
  #         may be used, including Floats to specify fractional seconds. A
  #         value of 0 or +nil+ will execute the block without any timeout.
  # +klass+:: Exception Class to raise if the block fails to terminate
  #           in +sec+ seconds.  Omitting will use the default, Timeout::Error
  # +message+:: Error message to raise with Exception Class.
  #             Omitting will use the default, "execution expired"
  #
  # Returns the result of the block *if* the block completed before
  # +sec+ seconds, otherwise throws an exception, based on the value of +klass+.
  #
  # The exception thrown to terminate the given block cannot be rescued inside
  # the block unless +klass+ is given explicitly. However, the block can use
  # ensure to prevent the handling of the exception.  For that reason, this
  # method cannot be relied on to enforce timeouts for untrusted blocks.
  #
  # If a scheduler is defined, it will be used to handle the timeout by invoking
  # Scheduler#timeout_after.
  #
  # Note that this is both a method of module Timeout, so you can <tt>include
  # Timeout</tt> into your classes so they have a #timeout method, as well as
  # a module method, so you can call it directly as Timeout.timeout().
  #
  # source://timeout//lib/timeout.rb#172
  def timeout(sec, klass = T.unsafe(nil), message = T.unsafe(nil), &block); end

  class << self
    # source://timeout//lib/timeout.rb#130
    def ensure_timeout_thread_created; end

    # Perform an operation in a block, raising an error if it takes longer than
    # +sec+ seconds to complete.
    #
    # +sec+:: Number of seconds to wait for the block to terminate. Any number
    #         may be used, including Floats to specify fractional seconds. A
    #         value of 0 or +nil+ will execute the block without any timeout.
    # +klass+:: Exception Class to raise if the block fails to terminate
    #           in +sec+ seconds.  Omitting will use the default, Timeout::Error
    # +message+:: Error message to raise with Exception Class.
    #             Omitting will use the default, "execution expired"
    #
    # Returns the result of the block *if* the block completed before
    # +sec+ seconds, otherwise throws an exception, based on the value of +klass+.
    #
    # The exception thrown to terminate the given block cannot be rescued inside
    # the block unless +klass+ is given explicitly. However, the block can use
    # ensure to prevent the handling of the exception.  For that reason, this
    # method cannot be relied on to enforce timeouts for untrusted blocks.
    #
    # If a scheduler is defined, it will be used to handle the timeout by invoking
    # Scheduler#timeout_after.
    #
    # Note that this is both a method of module Timeout, so you can <tt>include
    # Timeout</tt> into your classes so they have a #timeout method, as well as
    # a module method, so you can call it directly as Timeout.timeout().
    #
    # source://timeout//lib/timeout.rb#172
    def timeout(sec, klass = T.unsafe(nil), message = T.unsafe(nil), &block); end

    private

    # source://timeout//lib/timeout.rb#100
    def create_timeout_thread; end
  end
end

# :stopdoc:
#
# source://timeout//lib/timeout.rb#53
Timeout::CONDVAR = T.let(T.unsafe(nil), Thread::ConditionVariable)

# Raised by Timeout.timeout when the block times out.
#
# source://timeout//lib/timeout.rb#29
class Timeout::Error < ::RuntimeError
  # source://timeout//lib/timeout.rb#39
  def exception(*_arg0); end

  # Returns the value of attribute thread.
  #
  # source://timeout//lib/timeout.rb#30
  def thread; end

  class << self
    # source://timeout//lib/timeout.rb#32
    def catch(*args); end
  end
end

# We keep a private reference so that time mocking libraries won't break
# Timeout.
#
# source://timeout//lib/timeout.rb#142
Timeout::GET_TIME = T.let(T.unsafe(nil), Method)

# source://timeout//lib/timeout.rb#54
Timeout::QUEUE = T.let(T.unsafe(nil), Thread::Queue)

# source://timeout//lib/timeout.rb#55
Timeout::QUEUE_MUTEX = T.let(T.unsafe(nil), Thread::Mutex)

# source://timeout//lib/timeout.rb#60
class Timeout::Request
  # @return [Request] a new instance of Request
  #
  # source://timeout//lib/timeout.rb#63
  def initialize(thread, timeout, exception_class, message); end

  # Returns the value of attribute deadline.
  #
  # source://timeout//lib/timeout.rb#61
  def deadline; end

  # @return [Boolean]
  #
  # source://timeout//lib/timeout.rb#73
  def done?; end

  # @return [Boolean]
  #
  # source://timeout//lib/timeout.rb#79
  def expired?(now); end

  # source://timeout//lib/timeout.rb#92
  def finished; end

  # source://timeout//lib/timeout.rb#83
  def interrupt; end
end

# source://timeout//lib/timeout.rb#56
Timeout::TIMEOUT_THREAD_MUTEX = T.let(T.unsafe(nil), Thread::Mutex)

# source://timeout//lib/timeout.rb#26
Timeout::VERSION = T.let(T.unsafe(nil), String)
