# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `terser` gem.
# Please instead update this file by running `bin/tapioca gem terser`.

# A wrapper around the Terser interface
class Terser
  # Initialize new context for Terser with given options
  #
  # @param options [Hash] optional overrides to +Terser::DEFAULTS+
  # @raise [ArgumentError]
  # @return [Terser] a new instance of Terser
  #
  # source://terser//lib/terser.rb#149
  def initialize(options = T.unsafe(nil)); end

  # Minifies JavaScript code
  #
  # @param source [IO, String] valid JS source code.
  # @param source_map_options [Hash] optional
  # @return [String] minified code.
  #
  # source://terser//lib/terser.rb#161
  def compile(source, source_map_options = T.unsafe(nil)); end

  # Minifies JavaScript code and generates a source map
  #
  # @param source [IO, String] valid JS source code.
  # @param source_map_options [Hash] optional
  # @return [Array(String, String)] minified code and source map.
  #
  # source://terser//lib/terser.rb#178
  def compile_with_map(source, source_map_options = T.unsafe(nil)); end

  # Minifies JavaScript code
  #
  # @param source [IO, String] valid JS source code.
  # @param source_map_options [Hash] optional
  # @return [String] minified code.
  #
  # source://terser//lib/terser.rb#161
  def compress(source, source_map_options = T.unsafe(nil)); end

  private

  # source://terser//lib/terser.rb#358
  def comment_options; end

  # source://terser//lib/terser.rb#389
  def comment_setting; end

  # source://terser//lib/terser.rb#333
  def compressor_options; end

  # source://terser//lib/terser.rb#469
  def conditional_option(value, defaults, overrides = T.unsafe(nil)); end

  # source://terser//lib/terser.rb#184
  def context; end

  # source://terser//lib/terser.rb#262
  def context_lines_message(source, line_number, column); end

  # source://terser//lib/terser.rb#449
  def enclose_options; end

  # source://terser//lib/terser.rb#459
  def encode_regexp(regexp); end

  # source://terser//lib/terser.rb#234
  def error_context_format_options(low, high, line_index, column); end

  # source://terser//lib/terser.rb#230
  def error_context_lines; end

  # source://terser//lib/terser.rb#276
  def error_message(result, options); end

  # source://terser//lib/terser.rb#491
  def extract_source_mapping_url(source); end

  # source://terser//lib/terser.rb#245
  def format_error_line(line, options); end

  # source://terser//lib/terser.rb#252
  def format_lines(lines, options); end

  # source://terser//lib/terser.rb#501
  def input_source_map(source, generate_map, options); end

  # @return [Boolean]
  #
  # source://terser//lib/terser.rb#413
  def keep_classnames?(type); end

  # @return [Boolean]
  #
  # source://terser//lib/terser.rb#404
  def keep_fnames?(type); end

  # source://terser//lib/terser.rb#300
  def mangle_options; end

  # source://terser//lib/terser.rb#314
  def mangle_properties_options; end

  # Prevent negate_iife when wrap_iife is true
  #
  # source://terser//lib/terser.rb#350
  def negate_iife_block; end

  # source://terser//lib/terser.rb#399
  def output_options; end

  # source://terser//lib/terser.rb#436
  def parse_options(source_map_options); end

  # @raise [Error]
  #
  # source://terser//lib/terser.rb#282
  def parse_result(result, generate_map, options, source_map_options = T.unsafe(nil)); end

  # source://terser//lib/terser.rb#441
  def parse_source_map_options(source_map_options); end

  # source://terser//lib/terser.rb#373
  def quote_style; end

  # source://terser//lib/terser.rb#292
  def read_source(source); end

  # Run TerserJS for given source code
  #
  # source://terser//lib/terser.rb#215
  def run_terserjs(input, generate_map, source_map_options = T.unsafe(nil)); end

  # source://terser//lib/terser.rb#479
  def sanitize_map_root(map); end

  # source://terser//lib/terser.rb#198
  def source_map_comments(source_map_options); end

  # source://terser//lib/terser.rb#422
  def source_map_options(input_map, source_map_options); end

  # source://terser//lib/terser.rb#207
  def source_with(path); end

  class << self
    # Minifies JavaScript code using implicit context.
    #
    # @param source [IO, String] valid JS source code.
    # @param options [Hash] optional overrides to +Terser::DEFAULTS+
    # @return [String] minified code.
    #
    # source://terser//lib/terser.rb#133
    def compile(source, options = T.unsafe(nil)); end

    # Minifies JavaScript code and generates a source map using implicit context.
    #
    # @param source [IO, String] valid JS source code.
    # @param options [Hash] optional overrides to +Terser::DEFAULTS+
    # @return [Array(String, String)] minified code and source map.
    #
    # source://terser//lib/terser.rb#142
    def compile_with_map(source, options = T.unsafe(nil)); end
  end
end

# A wrapper for Sprockets
class Terser::Compressor
  # @return [Compressor] a new instance of Compressor
  #
  # source://terser//lib/terser/compressor.rb#11
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://terser//lib/terser/compressor.rb#30
  def cache_key; end

  # source://terser//lib/terser/compressor.rb#33
  def call(input); end

  class << self
    # source://terser//lib/terser/compressor.rb#26
    def cache_key; end

    # source://terser//lib/terser/compressor.rb#22
    def call(input); end

    # source://terser//lib/terser/compressor.rb#18
    def instance; end
  end
end

# source://terser//lib/terser/compressor.rb#9
Terser::Compressor::VERSION = T.let(T.unsafe(nil), String)

# Default options for compilation
#
# source://terser//lib/terser.rb#29
Terser::DEFAULTS = T.let(T.unsafe(nil), Hash)

# ES5 shims source path
#
# source://terser//lib/terser.rb#22
Terser::ES5FallbackPath = T.let(T.unsafe(nil), String)

# source://terser//lib/terser.rb#106
Terser::EXTRA_OPTIONS = T.let(T.unsafe(nil), Array)

# Error class for compilation errors.
class Terser::Error < ::StandardError; end

# source://terser//lib/terser.rb#108
Terser::MANGLE_PROPERTIES_DEFAULTS = T.let(T.unsafe(nil), Hash)

# Railtie for Rails
class Terser::Railtie < ::Rails::Railtie; end

# source://terser//lib/terser.rb#116
Terser::SOURCE_MAP_DEFAULTS = T.let(T.unsafe(nil), Hash)

# Source Map path
#
# source://terser//lib/terser.rb#20
Terser::SourceMapPath = T.let(T.unsafe(nil), String)

# TerserJS source path
#
# source://terser//lib/terser.rb#18
Terser::SourcePath = T.let(T.unsafe(nil), String)

# String.split shim source path
#
# source://terser//lib/terser.rb#24
Terser::SplitFallbackPath = T.let(T.unsafe(nil), String)

# TerserJS wrapper path
#
# source://terser//lib/terser.rb#26
Terser::TerserJSWrapperPath = T.let(T.unsafe(nil), String)

# Current version of Terser.
#
# source://terser//lib/terser/version.rb#5
Terser::VERSION = T.let(T.unsafe(nil), String)
