# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `term-ansicolor` gem.
# Please instead update this file by running `bin/tapioca gem term-ansicolor`.

module Term; end

# The ANSIColor module can be used for namespacing and mixed into your own
# classes.
module Term::ANSIColor
  include ::Term::ANSIColor::Movement
  extend ::Term::ANSIColor::Movement
  extend ::Term::ANSIColor

  # Returns an array of all Term::ANSIColor attributes as symbols.
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#119
  def attributes; end

  def black(string = T.unsafe(nil), &block); end
  def blink(string = T.unsafe(nil), &block); end
  def blue(string = T.unsafe(nil), &block); end
  def bold(string = T.unsafe(nil), &block); end
  def bright_black(string = T.unsafe(nil), &block); end
  def bright_blue(string = T.unsafe(nil), &block); end
  def bright_cyan(string = T.unsafe(nil), &block); end
  def bright_green(string = T.unsafe(nil), &block); end
  def bright_magenta(string = T.unsafe(nil), &block); end
  def bright_red(string = T.unsafe(nil), &block); end
  def bright_white(string = T.unsafe(nil), &block); end
  def bright_yellow(string = T.unsafe(nil), &block); end
  def clear(string = T.unsafe(nil), &block); end

  # Return +string+ or the result string of the given +block+ colored with
  # color +name+. If string isn't a string only the escape sequence to switch
  # on the color +name+ is returned.
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#87
  def color(name, string = T.unsafe(nil), &block); end

  def conceal(string = T.unsafe(nil), &block); end
  def concealed(string = T.unsafe(nil), &block); end
  def cyan(string = T.unsafe(nil), &block); end
  def dark(string = T.unsafe(nil), &block); end
  def faint(string = T.unsafe(nil), &block); end
  def green(string = T.unsafe(nil), &block); end
  def intense_black(string = T.unsafe(nil), &block); end
  def intense_blue(string = T.unsafe(nil), &block); end
  def intense_cyan(string = T.unsafe(nil), &block); end
  def intense_green(string = T.unsafe(nil), &block); end
  def intense_magenta(string = T.unsafe(nil), &block); end
  def intense_red(string = T.unsafe(nil), &block); end
  def intense_white(string = T.unsafe(nil), &block); end
  def intense_yellow(string = T.unsafe(nil), &block); end
  def italic(string = T.unsafe(nil), &block); end
  def magenta(string = T.unsafe(nil), &block); end
  def negative(string = T.unsafe(nil), &block); end
  def on_black(string = T.unsafe(nil), &block); end
  def on_blue(string = T.unsafe(nil), &block); end
  def on_bright_black(string = T.unsafe(nil), &block); end
  def on_bright_blue(string = T.unsafe(nil), &block); end
  def on_bright_cyan(string = T.unsafe(nil), &block); end
  def on_bright_green(string = T.unsafe(nil), &block); end
  def on_bright_magenta(string = T.unsafe(nil), &block); end
  def on_bright_red(string = T.unsafe(nil), &block); end
  def on_bright_white(string = T.unsafe(nil), &block); end
  def on_bright_yellow(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor.rb#104
  def on_color(name, string = T.unsafe(nil), &block); end

  def on_cyan(string = T.unsafe(nil), &block); end
  def on_green(string = T.unsafe(nil), &block); end
  def on_intense_black(string = T.unsafe(nil), &block); end
  def on_intense_blue(string = T.unsafe(nil), &block); end
  def on_intense_cyan(string = T.unsafe(nil), &block); end
  def on_intense_green(string = T.unsafe(nil), &block); end
  def on_intense_magenta(string = T.unsafe(nil), &block); end
  def on_intense_red(string = T.unsafe(nil), &block); end
  def on_intense_white(string = T.unsafe(nil), &block); end
  def on_intense_yellow(string = T.unsafe(nil), &block); end
  def on_magenta(string = T.unsafe(nil), &block); end
  def on_red(string = T.unsafe(nil), &block); end
  def on_white(string = T.unsafe(nil), &block); end
  def on_yellow(string = T.unsafe(nil), &block); end
  def rapid_blink(string = T.unsafe(nil), &block); end
  def red(string = T.unsafe(nil), &block); end
  def reset(string = T.unsafe(nil), &block); end
  def reverse(string = T.unsafe(nil), &block); end
  def strikethrough(string = T.unsafe(nil), &block); end

  # Returns true if Term::ANSIColor supports the +feature+.
  #
  # The feature :clear, that is mixing the clear color attribute into String,
  # is only supported on ruby implementations, that do *not* already
  # implement the String#clear method. It's better to use the reset color
  # attribute instead.
  #
  # @return [Boolean]
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#31
  def support?(feature); end

  # Returns an array of all Term::ANSIColor attributes as symbols.
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#119
  def term_ansicolor_attributes; end

  # Returns an uncolored version of the string, that is all
  # ANSI-Attributes are stripped from the string.
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#70
  def uncolor(string = T.unsafe(nil)); end

  # Returns an uncolored version of the string, that is all
  # ANSI-Attributes are stripped from the string.
  #
  # source://term-ansicolor//lib/term/ansicolor.rb#70
  def uncolored(string = T.unsafe(nil)); end

  def underline(string = T.unsafe(nil), &block); end
  def underscore(string = T.unsafe(nil), &block); end
  def white(string = T.unsafe(nil), &block); end
  def yellow(string = T.unsafe(nil), &block); end

  class << self
    # Returns an array of all Term::ANSIColor attributes as symbols.
    #
    # source://term-ansicolor//lib/term/ansicolor.rb#111
    def attributes; end

    # Turns the coloring on or off globally, so you can easily do
    # this for example:
    #  Term::ANSIColor::coloring = STDOUT.isatty
    #
    # source://term-ansicolor//lib/term/ansicolor.rb#46
    def coloring=(val); end

    # Returns true, if the coloring function of this module
    # is switched on, false otherwise.
    #
    # @return [Boolean]
    #
    # source://term-ansicolor//lib/term/ansicolor.rb#39
    def coloring?; end

    # source://term-ansicolor//lib/term/ansicolor.rb#51
    def create_color_method(color_name, color_value); end

    # Returns an array of all Term::ANSIColor attributes as symbols.
    #
    # source://term-ansicolor//lib/term/ansicolor.rb#111
    def term_ansicolor_attributes; end
  end
end

# :stopdoc:
#
# source://term-ansicolor//lib/term/ansicolor.rb#22
Term::ANSIColor::ATTRIBUTE_NAMES = T.let(T.unsafe(nil), Array)

class Term::ANSIColor::Attribute
  # @return [Attribute] a new instance of Attribute
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#73
  def initialize(name, code, options = T.unsafe(nil)); end

  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#95
  def apply(string = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#99
  def background?; end

  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#87
  def code; end

  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#117
  def distance_to(other, options = T.unsafe(nil)); end

  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#128
  def gradient_to(other, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#109
  def gray?; end

  # Returns the value of attribute name.
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#85
  def name; end

  # Returns the value of attribute rgb.
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#103
  def rgb; end

  # @return [Boolean]
  #
  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#105
  def rgb_color?; end

  # source://term-ansicolor//lib/term/ansicolor/attribute.rb#113
  def to_rgb_triple; end

  class << self
    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#33
    def [](name); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#28
    def attributes(&block); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#45
    def get(name); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#57
    def named_attributes(&block); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#61
    def nearest_rgb_color(color, options = T.unsafe(nil)); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#67
    def nearest_rgb_on_color(color, options = T.unsafe(nil)); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#49
    def rgb_colors(options = T.unsafe(nil), &block); end

    # source://term-ansicolor//lib/term/ansicolor/attribute.rb#21
    def set(name, code, options = T.unsafe(nil)); end
  end
end

class Term::ANSIColor::Attribute::Color256; end
class Term::ANSIColor::Attribute::Color8; end
class Term::ANSIColor::Attribute::IntenseColor8; end
class Term::ANSIColor::Attribute::Text; end

# Regular expression that is used to scan for ANSI-Attributes while
# uncoloring strings.
#
# source://term-ansicolor//lib/term/ansicolor.rb#66
Term::ANSIColor::COLORED_REGEXP = T.let(T.unsafe(nil), Regexp)

class Term::ANSIColor::HSLTriple
  # @return [HSLTriple] a new instance of HSLTriple
  #
  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#73
  def initialize(hue, saturation, lightness); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#156
  def ==(other); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#101
  def adjust_hue(degree); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#109
  def complement; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#152
  def css; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#89
  def darken(percentage); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#97
  def desaturate(percentage); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#105
  def grayscale; end

  # Returns the value of attribute hue.
  #
  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#79
  def hue; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#85
  def lighten(percentage); end

  # Returns the value of attribute lightness.
  #
  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#83
  def lightness; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#160
  def method_missing(name, *args, &block); end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#93
  def saturate(percentage); end

  # Returns the value of attribute saturation.
  #
  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#81
  def saturation; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#148
  def to_hsl_triple; end

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#123
  def to_rgb_triple; end

  private

  # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#113
  def hue2rgb(x, y, h); end

  class << self
    # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#60
    def [](thing); end

    # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#45
    def from_css(css); end

    # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#52
    def from_hash(options); end

    # source://term-ansicolor//lib/term/ansicolor/hsl_triple.rb#4
    def from_rgb_triple(rgb); end
  end
end

module Term::ANSIColor::Movement
  # source://term-ansicolor//lib/term/ansicolor/movement.rb#54
  def clear_screen(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#58
  def erase_in_display(n = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#62
  def erase_in_line(n = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#90
  def hide_cursor(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#38
  def move_backward(columns = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#30
  def move_down(lines = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#34
  def move_forward(columns = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#50
  def move_home(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#14
  def move_to(line = T.unsafe(nil), column = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#18
  def move_to_column(column = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#22
  def move_to_line(line = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#42
  def move_to_next_line(lines = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#46
  def move_to_previous_line(lines = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#26
  def move_up(lines = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#78
  def restore_position(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#82
  def return_to_position(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#74
  def save_position(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#70
  def scroll_down(pages = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#66
  def scroll_up(pages = T.unsafe(nil), string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#86
  def show_cursor(string = T.unsafe(nil), &block); end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#10
  def terminal_columns; end

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#6
  def terminal_lines; end

  private

  # source://term-ansicolor//lib/term/ansicolor/movement.rb#96
  def move_command(move, string = T.unsafe(nil)); end
end

class Term::ANSIColor::PPMReader
  include ::Term::ANSIColor::Movement
  include ::Term::ANSIColor

  # @return [PPMReader] a new instance of PPMReader
  #
  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#6
  def initialize(io, options = T.unsafe(nil)); end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#20
  def each_row; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#12
  def reset_io; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#27
  def to_a; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#31
  def to_s; end

  private

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#89
  def next_line; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#74
  def parse_header; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#58
  def parse_next_pixel; end

  # source://term-ansicolor//lib/term/ansicolor/ppm_reader.rb#50
  def parse_row; end
end

module Term::ANSIColor::RGBColorMetrics
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#37
    def metric(name); end

    # @return [Boolean]
    #
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#41
    def metric?(name); end

    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#47
    def metrics; end
  end
end

module Term::ANSIColor::RGBColorMetrics::CIELab
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#153
    def distance(rgb1, rgb2); end
  end
end

class Term::ANSIColor::RGBColorMetrics::CIELab::CIELabTriple < ::Struct
  include ::Term::ANSIColor::RGBColorMetricsHelpers::WeightedEuclideanDistance
  extend ::Term::ANSIColor::RGBColorMetricsHelpers::NormalizeRGBTriple

  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#127
    def from_rgb_triple(rgb_triple); end
  end
end

module Term::ANSIColor::RGBColorMetrics::CIEXYZ
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#115
    def distance(rgb1, rgb2); end
  end
end

class Term::ANSIColor::RGBColorMetrics::CIEXYZ::CIEXYZTriple < ::Struct
  include ::Term::ANSIColor::RGBColorMetricsHelpers::WeightedEuclideanDistance
  extend ::Term::ANSIColor::RGBColorMetricsHelpers::NormalizeRGBTriple

  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#100
    def from_rgb_triple(rgb_triple); end
  end
end

# Implements color distance as given in:
#   http://www.compuphase.com/cmetric.htm
module Term::ANSIColor::RGBColorMetrics::CompuPhase
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#68
    def distance(rgb1, rgb2); end
  end
end

# Implements color distance how the old greeks and most donkeys would…
module Term::ANSIColor::RGBColorMetrics::Euclidean
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#53
    def distance(rgb1, rgb2); end
  end
end

# Implements color distance the best way everybody knows…
module Term::ANSIColor::RGBColorMetrics::NTSC
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#60
    def distance(rgb1, rgb2); end
  end
end

module Term::ANSIColor::RGBColorMetrics::YUV
  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#88
    def distance(rgb1, rgb2); end
  end
end

class Term::ANSIColor::RGBColorMetrics::YUV::YUVTriple < ::Struct
  include ::Term::ANSIColor::RGBColorMetricsHelpers::WeightedEuclideanDistance

  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#79
    def from_rgb_triple(rgb_triple); end
  end
end

module Term::ANSIColor::RGBColorMetricsHelpers; end

module Term::ANSIColor::RGBColorMetricsHelpers::NormalizeRGBTriple
  private

  # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#17
  def normalize(v); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#26
  def normalize_rgb_triple(rgb_triple); end
end

module Term::ANSIColor::RGBColorMetricsHelpers::WeightedEuclideanDistance
  # source://term-ansicolor//lib/term/ansicolor/rgb_color_metrics.rb#5
  def weighted_euclidean_distance_to(other, weights = T.unsafe(nil)); end
end

class Term::ANSIColor::RGBTriple
  include ::Term::ANSIColor::RGBColorMetricsHelpers::WeightedEuclideanDistance

  # @return [RGBTriple] a new instance of RGBTriple
  #
  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#61
  def initialize(red, green, blue); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#132
  def ==(other); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#75
  def blue; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#91
  def blue_p; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#136
  def color(string); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#109
  def css(percentage: T.unsafe(nil)); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#140
  def distance_to(other, options = T.unsafe(nil)); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#151
  def gradient_to(other, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#99
  def gray?; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#71
  def green; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#87
  def green_p; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#103
  def html; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#95
  def invert; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#170
  def method_missing(name, *args, &block); end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#79
  def percentages; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#67
  def red; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#83
  def red_p; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#128
  def to_a; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#121
  def to_hsl_triple; end

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#117
  def to_rgb_triple; end

  protected

  # Returns the value of attribute values.
  #
  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#125
  def values; end

  private

  # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#145
  def initialize_copy(other); end

  class << self
    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#48
    def [](thing); end

    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#44
    def from_array(array); end

    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#27
    def from_css(css); end

    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#36
    def from_hash(options); end

    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#18
    def from_html(html); end

    private

    # source://term-ansicolor//lib/term/ansicolor/rgb_triple.rb#8
    def convert_value(color, max: T.unsafe(nil)); end
  end
end

# Term::ANSIColor version
#
# source://term-ansicolor//lib/term/ansicolor/version.rb#3
Term::ANSIColor::VERSION = T.let(T.unsafe(nil), String)

# source://term-ansicolor//lib/term/ansicolor/version.rb#4
Term::ANSIColor::VERSION_ARRAY = T.let(T.unsafe(nil), Array)

# source://term-ansicolor//lib/term/ansicolor/version.rb#7
Term::ANSIColor::VERSION_BUILD = T.let(T.unsafe(nil), Integer)

# source://term-ansicolor//lib/term/ansicolor/version.rb#5
Term::ANSIColor::VERSION_MAJOR = T.let(T.unsafe(nil), Integer)

# source://term-ansicolor//lib/term/ansicolor/version.rb#6
Term::ANSIColor::VERSION_MINOR = T.let(T.unsafe(nil), Integer)
