# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `temple` gem.
# Please instead update this file by running `bin/tapioca gem temple`.

module Temple; end

# ERB example implementation
#
# Example usage:
#   Temple::ERB::Template.new { "<%= 'Hello, world!' %>" }.render
module Temple::ERB; end

# Example ERB engine implementation
#
# @api public
class Temple::ERB::Engine < ::Temple::Engine; end

# Example ERB parser
#
# @api public
class Temple::ERB::Parser < ::Temple::Parser
  # @api public
  #
  # source://temple//lib/temple/erb/parser.rb#9
  def call(input); end
end

# @api public
#
# source://temple//lib/temple/erb/parser.rb#7
Temple::ERB::Parser::ERB_PATTERN = T.let(T.unsafe(nil), Regexp)

# ERB Template class
class Temple::ERB::Template < ::Temple::Templates::Tilt; end

# ERB trimming like in erubis
# Deletes spaces around '<% %>' and leave spaces around '<%= %>'.
#
# @api public
class Temple::ERB::Trimming < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/erb/trimming.rb#9
  def on_multi(*exps); end
end

# An engine is simply a chain of compilers (that often includes a parser,
# some filters and a generator).
#
#   class MyEngine < Temple::Engine
#     # First run MyParser, passing the :strict option
#     use MyParser, :strict
#
#     # Then a custom filter
#     use MyFilter
#
#     # Then some general optimizations filters
#     filter :MultiFlattener
#     filter :StaticMerger
#     filter :DynamicInliner
#
#     # Finally the generator
#     generator :ArrayBuffer, :buffer
#   end
#
#   class SpecialEngine < MyEngine
#     append MyCodeOptimizer
#     before :ArrayBuffer, Temple::Filters::Validator
#     replace :ArrayBuffer, Temple::Generators::RailsOutputBuffer
#   end
#
#   engine = MyEngine.new(strict: "For MyParser")
#   engine.call(something)
#
# @api public
class Temple::Engine
  include ::Temple::Mixins::Options
  include ::Temple::Mixins::EngineDSL
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::ThreadOptions
  extend ::Temple::Mixins::EngineDSL

  # @api public
  # @return [Engine] a new instance of Engine
  #
  # source://temple//lib/temple/engine.rb#44
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/engine.rb#49
  def call(input); end

  # @api public
  #
  # source://temple//lib/temple/engine.rb#38
  def chain; end

  protected

  # @api public
  #
  # source://temple//lib/temple/engine.rb#59
  def call_chain; end

  # @api public
  #
  # source://temple//lib/temple/engine.rb#55
  def chain_modified!; end

  class << self
    # @api public
    #
    # source://temple//lib/temple/engine.rb#40
    def chain; end
  end
end

# Temple base filter
#
# @api public
class Temple::Filter
  include ::Temple::Utils
  include ::Temple::Mixins::CompiledDispatcher
  include ::Temple::Mixins::CoreDispatcher
  include ::Temple::Mixins::EscapeDispatcher
  include ::Temple::Mixins::ControlFlowDispatcher
  include ::Temple::Mixins::Dispatcher
  include ::Temple::Mixins::Options
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::ThreadOptions
end

# Exception raised if something bad happens in a Temple filter
#
# @api public
class Temple::FilterError < ::RuntimeError; end

module Temple::Filters; end

# @api public
class Temple::Filters::CodeMerger < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/code_merger.rb#5
  def on_multi(*exps); end
end

# Control flow filter which processes [:if, condition, yes-exp, no-exp]
# and [:block, code, content] expressions.
# This is useful for ruby code generation with lots of conditionals.
#
# @api public
class Temple::Filters::ControlFlow < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/control_flow.rb#34
  def on_block(code, exp); end

  # @api public
  #
  # source://temple//lib/temple/filters/control_flow.rb#20
  def on_case(arg, *cases); end

  # @api public
  #
  # source://temple//lib/temple/filters/control_flow.rb#30
  def on_cond(*cases); end

  # @api public
  #
  # source://temple//lib/temple/filters/control_flow.rb#9
  def on_if(condition, yes, no = T.unsafe(nil)); end
end

# Inlines several static/dynamic into a single dynamic.
#
# @api public
class Temple::Filters::DynamicInliner < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/dynamic_inliner.rb#7
  def on_multi(*exps); end
end

# Try to encode input string
#
# @api public
class Temple::Filters::Encoding < ::Temple::Parser
  # @api public
  #
  # source://temple//lib/temple/filters/encoding.rb#9
  def call(s); end
end

# Erase expressions with a certain type
#
# @api public
class Temple::Filters::Eraser < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/eraser.rb#10
  def compile(exp); end

  protected

  # @api public
  # @return [Boolean]
  #
  # source://temple//lib/temple/filters/eraser.rb#17
  def do?(list, exp); end
end

# Escape dynamic or static expressions.
# This filter must be used after Temple::HTML::* and before the generators.
# It can be enclosed with Temple::Filters::DynamicInliner filters to
# reduce calls to Temple::Utils#escape_html.
#
# @api public
class Temple::Filters::Escapable < ::Temple::Filter
  # @api public
  # @return [Escapable] a new instance of Escapable
  #
  # source://temple//lib/temple/filters/escapable.rb#15
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/filters/escapable.rb#35
  def on_dynamic(value); end

  # @api public
  #
  # source://temple//lib/temple/filters/escapable.rb#23
  def on_escape(flag, exp); end

  # @api public
  #
  # source://temple//lib/temple/filters/escapable.rb#31
  def on_static(value); end
end

# Flattens nested multi expressions
#
# @api public
class Temple::Filters::MultiFlattener < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/multi_flattener.rb#7
  def on_multi(*exps); end
end

# Remove BOM from input string
#
# @api public
class Temple::Filters::RemoveBOM < ::Temple::Parser
  # @api public
  #
  # source://temple//lib/temple/filters/remove_bom.rb#7
  def call(s); end
end

# Convert [:dynamic, code] to [:static, text] if code is static Ruby expression.
class Temple::Filters::StaticAnalyzer < ::Temple::Filter
  # source://temple//lib/temple/filters/static_analyzer.rb#5
  def call(exp); end

  # source://temple//lib/temple/filters/static_analyzer.rb#14
  def on_dynamic(code); end
end

# Merges several statics into a single static.  Example:
#
#   [:multi,
#     [:static, "Hello "],
#     [:static, "World!"]]
#
# Compiles to:
#
#   [:static, "Hello World!"]
#
# @api public
class Temple::Filters::StaticMerger < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/static_merger.rb#15
  def on_multi(*exps); end
end

# Compile [:dynamic, "foo#{bar}"] to [:multi, [:static, 'foo'], [:dynamic, 'bar']]
class Temple::Filters::StringSplitter < ::Temple::Filter
  # source://temple//lib/temple/filters/string_splitter.rb#77
  def on_dynamic(code); end

  private

  # @return [Boolean]
  #
  # source://temple//lib/temple/filters/string_splitter.rb#95
  def string_literal?(code); end

  class << self
    # `code` param must be valid string literal
    #
    # source://temple//lib/temple/filters/string_splitter.rb#13
    def compile(code); end

    private

    # source://temple//lib/temple/filters/string_splitter.rb#41
    def compile_tokens!(exps, tokens); end

    # source://temple//lib/temple/filters/string_splitter.rb#57
    def shift_balanced_embexpr(tokens); end

    # source://temple//lib/temple/filters/string_splitter.rb#27
    def strip_quotes!(tokens); end
  end
end

class Temple::Filters::StringSplitter::SyntaxChecker < ::Ripper
  private

  # @raise [ParseError]
  #
  # source://temple//lib/temple/filters/string_splitter.rb#118
  def on_parse_error(*_arg0); end

  class << self
    # @return [Boolean]
    #
    # source://temple//lib/temple/filters/string_splitter.rb#109
    def syntax_error?(code); end
  end
end

class Temple::Filters::StringSplitter::SyntaxChecker::ParseError < ::StandardError; end

# Validates temple expression with given grammar
#
# @api public
class Temple::Filters::Validator < ::Temple::Filter
  # @api public
  #
  # source://temple//lib/temple/filters/validator.rb#9
  def compile(exp); end
end

# Abstract generator base class
# Generators should inherit this class and
# compile the Core Abstraction to ruby code.
#
# @api public
class Temple::Generator
  include ::Temple::Utils
  include ::Temple::Mixins::CompiledDispatcher
  include ::Temple::Mixins::Options
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::ThreadOptions

  # @api public
  #
  # source://temple//lib/temple/generator.rb#17
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#37
  def create_buffer; end

  # @api public
  # @raise [InvalidExpression]
  #
  # source://temple//lib/temple/generator.rb#44
  def on(*exp); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#56
  def on_capture(name, exp); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#68
  def on_code(code); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#64
  def on_dynamic(code); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#48
  def on_multi(*exp); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#52
  def on_newline; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#60
  def on_static(text); end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#25
  def postamble; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#21
  def preamble; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#33
  def restore_buffer; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#40
  def return_buffer; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#29
  def save_buffer; end

  protected

  # @api public
  #
  # source://temple//lib/temple/generator.rb#74
  def buffer; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#78
  def capture_generator; end

  # @api public
  #
  # source://temple//lib/temple/generator.rb#84
  def concat(str); end
end

module Temple::Generators; end

# Implements an array buffer.
#
#   _buf = []
#   _buf << "static"
#   _buf << dynamic
#   _buf
#
# @api public
class Temple::Generators::Array < ::Temple::Generator
  # @api public
  #
  # source://temple//lib/temple/generators/array.rb#12
  def create_buffer; end

  # @api public
  #
  # source://temple//lib/temple/generators/array.rb#16
  def return_buffer; end
end

# Just like Array, but calls #join on the array.
#
#   _buf = []
#   _buf << "static"
#   _buf << dynamic
#   _buf.join("")
#
# @api public
class Temple::Generators::ArrayBuffer < ::Temple::Generators::Array
  # @api public
  #
  # source://temple//lib/temple/generators/array_buffer.rb#12
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/generators/array_buffer.rb#23
  def return_buffer; end
end

# Implements an ERB generator.
#
# @api public
class Temple::Generators::ERB < ::Temple::Generator
  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#7
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#15
  def on_capture(name, exp); end

  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#27
  def on_code(code); end

  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#23
  def on_dynamic(code); end

  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#11
  def on_multi(*exp); end

  # @api public
  #
  # source://temple//lib/temple/generators/erb.rb#19
  def on_static(text); end
end

# Implements a rails output buffer.
#
#   @output_buffer = ActiveSupport::SafeBuffer
#   @output_buffer.safe_concat "static"
#   @output_buffer.safe_concat dynamic.to_s
#   @output_buffer
#
# @api public
class Temple::Generators::RailsOutputBuffer < ::Temple::Generators::StringBuffer
  # @api public
  #
  # source://temple//lib/temple/generators/rails_output_buffer.rb#18
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/generators/rails_output_buffer.rb#30
  def concat(str); end

  # @api public
  #
  # source://temple//lib/temple/generators/rails_output_buffer.rb#22
  def create_buffer; end
end

# Implements a string buffer.
#
#   _buf = ''
#   _buf << "static"
#   _buf << dynamic.to_s
#   _buf
#
# @api public
class Temple::Generators::StringBuffer < ::Temple::Generators::ArrayBuffer
  # @api public
  #
  # source://temple//lib/temple/generators/string_buffer.rb#12
  def create_buffer; end

  # @api public
  #
  # source://temple//lib/temple/generators/string_buffer.rb#20
  def on_dynamic(code); end

  # @api public
  #
  # source://temple//lib/temple/generators/string_buffer.rb#16
  def return_buffer; end
end

# Temple expression grammar which can be used to validate Temple expressions.
#
# Example:
#   Temple::Grammar.match? [:static, 'Valid Temple Expression']
#   Temple::Grammar.validate! [:multi, 'Invalid Temple Expression']
#
# See {file:EXPRESSIONS.md Expression documentation}.
#
# @api public
module Temple::Grammar
  extend ::Temple::Mixins::GrammarDSL
end

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::Bool = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::Case = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::Condition = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::EmptyExp = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::Expression = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::HTMLAttr = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

# source://temple//lib/temple/mixins/grammar_dsl.rb#166
Temple::Grammar::HTMLIdentifier = T.let(T.unsafe(nil), Temple::Mixins::GrammarDSL::Root)

module Temple::HTML; end

# This filter merges html attributes (e.g. used for id and class)
#
# @api public
class Temple::HTML::AttributeMerger < ::Temple::HTML::Filter
  # @api public
  #
  # source://temple//lib/temple/html/attribute_merger.rb#8
  def on_html_attrs(*attrs); end
end

# This filter removes empty attributes
#
# @api public
class Temple::HTML::AttributeRemover < ::Temple::HTML::Filter
  # @api public
  # @raise [ArgumentError]
  # @return [AttributeRemover] a new instance of AttributeRemover
  #
  # source://temple//lib/temple/html/attribute_remover.rb#8
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/html/attribute_remover.rb#18
  def on_html_attr(name, value); end

  # @api public
  #
  # source://temple//lib/temple/html/attribute_remover.rb#14
  def on_html_attrs(*attrs); end
end

# This filter sorts html attributes.
#
# @api public
class Temple::HTML::AttributeSorter < ::Temple::HTML::Filter
  # @api public
  #
  # source://temple//lib/temple/html/attribute_sorter.rb#8
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/html/attribute_sorter.rb#12
  def on_html_attrs(*attrs); end
end

# @api private
module Temple::HTML::Dispatcher
  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#9
  def on_html_attr(name, content); end

  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#5
  def on_html_attrs(*attrs); end

  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#13
  def on_html_comment(content); end

  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#17
  def on_html_condcomment(condition, content); end

  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#21
  def on_html_js(content); end

  # @api private
  #
  # source://temple//lib/temple/html/dispatcher.rb#25
  def on_html_tag(name, attrs, content = T.unsafe(nil)); end
end

# @api public
class Temple::HTML::Fast < ::Temple::HTML::Filter
  # @api public
  # @return [Fast] a new instance of Fast
  #
  # source://temple//lib/temple/html/fast.rb#36
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#107
  def on_html_attr(name, value); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#103
  def on_html_attrs(*attrs); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#79
  def on_html_comment(content); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#86
  def on_html_condcomment(condition, content); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#65
  def on_html_doctype(type); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#118
  def on_html_js(content); end

  # @api public
  #
  # source://temple//lib/temple/html/fast.rb#93
  def on_html_tag(name, attrs, content = T.unsafe(nil)); end
end

# @api public
#
# source://temple//lib/temple/html/fast.rb#5
Temple::HTML::Fast::DOCTYPES = T.let(T.unsafe(nil), Hash)

# See http://www.w3.org/html/wg/drafts/html/master/single-page.html#void-elements
#
# @api public
#
# source://temple//lib/temple/html/fast.rb#29
Temple::HTML::Fast::HTML_VOID_ELEMENTS = T.let(T.unsafe(nil), Array)

# @api public
class Temple::HTML::Filter < ::Temple::Filter
  include ::Temple::HTML::Dispatcher

  # @api public
  # @return [Boolean]
  #
  # source://temple//lib/temple/html/filter.rb#7
  def contains_nonempty_static?(exp); end
end

# @api public
class Temple::HTML::Pretty < ::Temple::HTML::Fast
  # @api public
  # @return [Pretty] a new instance of Pretty
  #
  # source://temple//lib/temple/html/pretty.rb#14
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#22
  def call(exp); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#36
  def on_dynamic(code); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#47
  def on_html_comment(content); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#42
  def on_html_doctype(type); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#54
  def on_html_tag(name, attrs, content = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#26
  def on_static(content); end

  protected

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#86
  def indent; end

  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#80
  def preamble; end

  # Return indentation before tag
  #
  # @api public
  #
  # source://temple//lib/temple/html/pretty.rb#91
  def tag_indent(name); end
end

# Immutable map class which supports map merging
#
# @api public
class Temple::ImmutableMap
  include ::Enumerable

  # @api public
  # @return [ImmutableMap] a new instance of ImmutableMap
  #
  # source://temple//lib/temple/map.rb#7
  def initialize(*map); end

  # @api public
  #
  # source://temple//lib/temple/map.rb#15
  def [](key); end

  # @api public
  #
  # source://temple//lib/temple/map.rb#20
  def each; end

  # @api public
  # @return [Boolean]
  #
  # source://temple//lib/temple/map.rb#11
  def include?(key); end

  # @api public
  #
  # source://temple//lib/temple/map.rb#24
  def keys; end

  # @api public
  #
  # source://temple//lib/temple/map.rb#32
  def to_hash; end

  # @api public
  #
  # source://temple//lib/temple/map.rb#28
  def values; end
end

# Exception raised if invalid temple expression is found
#
# @api public
class Temple::InvalidExpression < ::RuntimeError; end

module Temple::Mixins; end

# @api public
module Temple::Mixins::ClassOptions
  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#10
  def default_options; end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#35
  def define_deprecated_options(*opts); end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#26
  def define_options(*opts); end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#44
  def disable_option_validator!; end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#19
  def options; end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#5
  def set_default_options(opts); end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#15
  def set_options(opts); end
end

# @api private
module Temple::Mixins::CompiledDispatcher
  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#44
  def call(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#48
  def compile(exp); end

  private

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#72
  def dispatched_methods; end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#54
  def dispatcher(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#58
  def replace_dispatcher(exp); end
end

# @api private
class Temple::Mixins::CompiledDispatcher::DispatchNode < ::Hash
  # @api private
  # @return [DispatchNode] a new instance of DispatchNode
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#81
  def initialize; end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#86
  def compile(level = T.unsafe(nil), call_parent = T.unsafe(nil)); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#79
  def method; end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#79
  def method=(_arg0); end
end

# @api private
module Temple::Mixins::ControlFlowDispatcher
  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#33
  def on_block(code, content); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#29
  def on_case(arg, *cases); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#37
  def on_cond(*cases); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#25
  def on_if(condition, *cases); end
end

# @api private
module Temple::Mixins::CoreDispatcher
  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#11
  def on_capture(name, exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#5
  def on_multi(*exps); end
end

# Implements a compatible call-method
# based on the including classe's methods.
#
# It uses every method starting with
# "on" and uses the rest of the method
# name as prefix of the expression it
# will receive. So, if a dispatcher
# has a method named "on_x", this method
# will be called with arg0,..,argN
# whenever an expression like [:x, arg0,..,argN ]
# is encountered.
#
# This works with longer prefixes, too.
# For example a method named "on_y_z"
# will be called whenever an expression
# like [:y, :z, .. ] is found. Furthermore,
# if additionally a method named "on_y"
# is present, it will be called when an
# expression starts with :y but then does
# not contain with :z. This way a
# dispatcher can implement namespaces.
#
# @api public
# @example
#   class MyAwesomeDispatch
#   include Temple::Mixins::Dispatcher
#   def on_awesome(thing) # keep awesome things
#   return [:awesome, thing]
#   end
#   def on_boring(thing) # make boring things awesome
#   return [:awesome, thing+" with bacon"]
#   end
#   def on(type,*args) # unknown stuff is boring too
#   return [:awesome, 'just bacon']
#   end
#   end
#   filter = MyAwesomeDispatch.new
#   # Boring things are converted:
#   filter.call([:boring, 'egg']) #=> [:awesome, 'egg with bacon']
#   # Unknown things too:
#   filter.call([:foo]) #=> [:awesome, 'just bacon']
#   # Known but not boring things won't be touched:
#   filter.call([:awesome, 'chuck norris']) #=>[:awesome, 'chuck norris']
# @note Processing does not reach into unknown
#   expression types by default.
module Temple::Mixins::Dispatcher
  include ::Temple::Mixins::CompiledDispatcher
  include ::Temple::Mixins::CoreDispatcher
  include ::Temple::Mixins::EscapeDispatcher
  include ::Temple::Mixins::ControlFlowDispatcher
end

# @api private
module Temple::Mixins::EngineDSL
  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#34
  def after(name, *args, &block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#8
  def append(*args, &block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#26
  def before(name, *args, &block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#5
  def chain_modified!; end

  # source://temple//lib/temple/mixins/engine_dsl.rb#54
  def filter(name, *options); end

  # source://temple//lib/temple/mixins/engine_dsl.rb#54
  def generator(name, *options); end

  # source://temple//lib/temple/mixins/engine_dsl.rb#54
  def html(name, *options); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#13
  def prepend(*args, &block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#18
  def remove(name); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#42
  def replace(name, *args, &block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#8
  def use(*args, &block); end

  private

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#74
  def chain_class_constructor(filter, local_options); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#107
  def chain_element(args, block); end

  # @api private
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#61
  def chain_name(name); end

  # @api private
  # @raise [ArgumentError]
  #
  # source://temple//lib/temple/mixins/engine_dsl.rb#84
  def chain_proc_constructor(name, filter); end
end

# @api private
module Temple::Mixins::EscapeDispatcher
  # @api private
  #
  # source://temple//lib/temple/mixins/dispatcher.rb#18
  def on_escape(flag, exp); end
end

# @api private
module Temple::Mixins::GrammarDSL
  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#122
  def ===(exp); end

  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#122
  def =~(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#136
  def Rule(rule); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#132
  def Value(value); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#165
  def const_missing(name); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#115
  def extended(mod); end

  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#122
  def match?(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#128
  def validate!(exp); end
end

# @api private
class Temple::Mixins::GrammarDSL::Element < ::Temple::Mixins::GrammarDSL::Or
  # @api private
  # @return [Element] a new instance of Element
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#85
  def initialize(grammar, rule); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#96
  def after_copy(source); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#90
  def match(exp, unmatched); end
end

# @api private
class Temple::Mixins::GrammarDSL::Or < ::Temple::Mixins::GrammarDSL::Rule
  # @api private
  # @return [Or] a new instance of Or
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#28
  def initialize(grammar, *children); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#33
  def <<(rule); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#45
  def after_copy(source); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#40
  def match(exp, unmatched); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#33
  def |(rule); end
end

# @api private
class Temple::Mixins::GrammarDSL::Root < ::Temple::Mixins::GrammarDSL::Or
  # @api private
  # @return [Root] a new instance of Root
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#51
  def initialize(grammar, name); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#78
  def after_copy(source); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#74
  def copy_to(grammar); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#56
  def match(exp, unmatched); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#62
  def validate!(exp); end
end

# @api private
class Temple::Mixins::GrammarDSL::Rule
  # @api private
  # @return [Rule] a new instance of Rule
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#6
  def initialize(grammar); end

  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#10
  def ===(exp); end

  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#10
  def =~(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#20
  def copy_to(grammar); end

  # @api private
  # @return [Boolean]
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#10
  def match?(exp); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#16
  def |(rule); end
end

# @api private
class Temple::Mixins::GrammarDSL::Value < ::Temple::Mixins::GrammarDSL::Rule
  # @api private
  # @return [Value] a new instance of Value
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#105
  def initialize(grammar, value); end

  # @api private
  #
  # source://temple//lib/temple/mixins/grammar_dsl.rb#110
  def match(exp, unmatched); end
end

# @api public
module Temple::Mixins::Options
  mixes_in_class_methods ::Temple::Mixins::ClassOptions
  mixes_in_class_methods ::Temple::Mixins::ThreadOptions

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#80
  def initialize(opts = T.unsafe(nil)); end

  # @api public
  #
  # source://temple//lib/temple/mixins/options.rb#78
  def options; end

  class << self
    # @api public
    # @private
    #
    # source://temple//lib/temple/mixins/options.rb#71
    def included(base); end
  end
end

# @api private
module Temple::Mixins::Template
  include ::Temple::Mixins::ClassOptions

  # @api private
  #
  # source://temple//lib/temple/mixins/template.rb#7
  def compile(code, options); end

  # @api private
  #
  # source://temple//lib/temple/mixins/template.rb#17
  def create(engine, options); end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://temple//lib/temple/mixins/template.rb#13
  def register_as(*names); end
end

module Temple::Mixins::ThreadOptions
  # source://temple//lib/temple/mixins/options.rb#58
  def thread_options; end

  # source://temple//lib/temple/mixins/options.rb#50
  def with_options(options); end

  protected

  # source://temple//lib/temple/mixins/options.rb#64
  def thread_options_key; end
end

# Mutable map class which supports map merging
#
# @api public
class Temple::MutableMap < ::Temple::ImmutableMap
  # @api public
  # @return [MutableMap] a new instance of MutableMap
  #
  # source://temple//lib/temple/map.rb#42
  def initialize(*map); end

  # @api public
  #
  # source://temple//lib/temple/map.rb#46
  def []=(key, value); end

  # @api public
  #
  # source://temple//lib/temple/map.rb#50
  def update(map); end
end

class Temple::OptionMap < ::Temple::MutableMap
  # @return [OptionMap] a new instance of OptionMap
  #
  # source://temple//lib/temple/map.rb#56
  def initialize(*map, &block); end

  # source://temple//lib/temple/map.rb#63
  def []=(key, value); end

  # source://temple//lib/temple/map.rb#82
  def add_deprecated_keys(*keys); end

  # source://temple//lib/temple/map.rb#78
  def add_valid_keys(*keys); end

  # @return [Boolean]
  #
  # source://temple//lib/temple/map.rb#95
  def deprecated_key?(key); end

  # source://temple//lib/temple/map.rb#68
  def update(map); end

  # @return [Boolean]
  #
  # source://temple//lib/temple/map.rb#100
  def valid_key?(key); end

  # source://temple//lib/temple/map.rb#73
  def valid_keys; end

  # source://temple//lib/temple/map.rb#90
  def validate_key!(key); end

  # source://temple//lib/temple/map.rb#86
  def validate_map!(map); end
end

# Temple base parser
#
# @api public
class Temple::Parser
  include ::Temple::Utils
  include ::Temple::Mixins::Options
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::ThreadOptions
end

module Temple::StaticAnalyzer
  class << self
    # @return [Boolean]
    #
    # source://temple//lib/temple/static_analyzer.rb#32
    def available?; end

    # @return [Boolean]
    #
    # source://temple//lib/temple/static_analyzer.rb#36
    def static?(code); end

    # @return [Boolean]
    #
    # source://temple//lib/temple/static_analyzer.rb#57
    def syntax_error?(code); end
  end
end

# source://temple//lib/temple/static_analyzer.rb#19
Temple::StaticAnalyzer::DYNAMIC_TOKENS = T.let(T.unsafe(nil), Array)

# source://temple//lib/temple/static_analyzer.rb#23
Temple::StaticAnalyzer::STATIC_KEYWORDS = T.let(T.unsafe(nil), Array)

# source://temple//lib/temple/static_analyzer.rb#27
Temple::StaticAnalyzer::STATIC_OPERATORS = T.let(T.unsafe(nil), Array)

# source://temple//lib/temple/static_analyzer.rb#8
Temple::StaticAnalyzer::STATIC_TOKENS = T.let(T.unsafe(nil), Array)

class Temple::StaticAnalyzer::SyntaxChecker < ::Ripper
  private

  # @raise [ParseError]
  #
  # source://temple//lib/temple/static_analyzer.rb#71
  def on_parse_error(*_arg0); end
end

class Temple::StaticAnalyzer::SyntaxChecker::ParseError < ::StandardError; end

# @api public
module Temple::Templates
  class << self
    # @api public
    #
    # source://temple//lib/temple/templates.rb#7
    def method_missing(name, engine, options = T.unsafe(nil)); end
  end
end

class Temple::Templates::Rails
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::Template

  # source://temple//lib/temple/templates/rails.rb#6
  def call(template, source = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://temple//lib/temple/templates/rails.rb#11
  def supports_streaming?; end

  class << self
    # source://temple//lib/temple/templates/rails.rb#15
    def register_as(*names); end
  end
end

class Temple::Templates::Tilt < ::Tilt::Template
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::Template

  # A string containing the (Ruby) source code for the template.
  #
  # @param locals [Hash] Local variables
  # @return [String] Compiled template ruby code
  #
  # source://temple//lib/temple/templates/tilt.rb#37
  def precompiled_template(locals = T.unsafe(nil)); end

  # Prepare Temple template
  #
  # Called immediately after template data is loaded.
  #
  # @return [void]
  #
  # source://temple//lib/temple/templates/tilt.rb#23
  def prepare; end

  class << self
    # source://temple//lib/temple/templates/tilt.rb#10
    def default_mime_type; end

    # source://temple//lib/temple/templates/tilt.rb#14
    def default_mime_type=(mime_type); end

    # source://temple//lib/temple/templates/tilt.rb#41
    def register_as(*names); end
  end
end

# @api public
module Temple::Utils
  extend ::Temple::Utils

  # Check if expression is empty
  #
  # @api public
  # @param exp [Array] Temple expression
  # @return [Boolean] true if expression is empty
  #
  # source://temple//lib/temple/utils.rb#76
  def empty_exp?(exp); end

  # Returns an escaped copy of `html`.
  #
  # @api public
  # @param html [String] The string to escape
  # @return [String] The escaped string
  #
  # source://temple//lib/temple/utils.rb#37
  def escape_html(html); end

  # Returns an escaped copy of `html`.
  # Strings which are declared as html_safe are not escaped.
  #
  # @api public
  # @param html [String] The string to escape
  # @return [String] The escaped string
  #
  # source://temple//lib/temple/utils.rb#20
  def escape_html_safe(html); end

  # @api public
  #
  # source://temple//lib/temple/utils.rb#87
  def indent_dynamic(text, indent_next, indent, pre_tags = T.unsafe(nil)); end

  # Generate unique variable name
  #
  # @api public
  # @param prefix [String] Variable name prefix
  # @return [String] Variable name
  #
  # source://temple//lib/temple/utils.rb#66
  def unique_name(prefix = T.unsafe(nil)); end
end

# source://temple//lib/temple/version.rb#2
Temple::VERSION = T.let(T.unsafe(nil), String)
