# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sprockets` gem.
# Please instead update this file by running `bin/tapioca gem sprockets`.

# Define some basic Sprockets error classes
module Sprockets
  extend ::Sprockets::Utils
  extend ::Sprockets::URIUtils
  extend ::Sprockets::PathUtils
  extend ::Sprockets::DigestUtils
  extend ::Sprockets::PathDigestUtils
  extend ::Sprockets::Dependencies
  extend ::Sprockets::Compressing
  extend ::Sprockets::Exporting
  extend ::Sprockets::ProcessorUtils
  extend ::Sprockets::Processing
  extend ::Sprockets::HTTPUtils
  extend ::Sprockets::Transformers
  extend ::Sprockets::Mime
  extend ::Sprockets::Paths
  extend ::Sprockets::Configuration
end

# This is a processor designed to add a source map "comment"
# to the bottom of a css or JS file that is serving a source
# map. An example of a comment might look like this
#
#    //# application.js-80af0efcc960fc2ac93eda2f7b12e3db40ab360bf6ea269ceed3bea3678326f9.map
#
# As an asset is built it gets source map information added
# to the `asset.to_hash[:metadata][:map]` key. This contains all the
# information that is needed to build a source map file.
#
# To add this comment we must have an asset we can link to.
# To do this we ensure that the original asset is loaded, then
# we use a use a special mime type. For example `application/js-sourcemap+json`
# for a JS source map.
#
# This will trigger a new asset to be loaded and generated by the
# `SourceMapProcessor` processor.
#
# Finally once we have that file, we can generate a link to it
# with it's full fingerprint. This is done and then
# added to the original asset as a comment at the bottom.
class Sprockets::AddSourceMapCommentToAssetProcessor
  class << self
    # source://sprockets//lib/sprockets/add_source_map_comment_to_asset_processor.rb#29
    def call(input); end
  end
end

class Sprockets::ArgumentError < ::Sprockets::Error; end

class Sprockets::Asset
  # Private: Initialize Asset wrapper from attributes Hash.
  #
  # Asset wrappers should not be initialized directly, only
  # Environment#find_asset should vend them.
  #
  # attributes - Hash of ivars
  #
  # Returns Asset.
  #
  # @return [Asset] a new instance of Asset
  #
  # source://sprockets//lib/sprockets/asset.rb#17
  def initialize(attributes = T.unsafe(nil)); end

  # Public: Compare assets.
  #
  # Assets are equal if they share the same path and digest.
  #
  # Returns true or false.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/asset.rb#207
  def ==(other); end

  # Public: Returns String base64 digest of source.
  #
  # source://sprockets//lib/sprockets/asset.rb#152
  def base64digest; end

  # Public: Returns Integer length of source.
  #
  # source://sprockets//lib/sprockets/asset.rb#120
  def bytesize; end

  # Public: Get charset of source.
  #
  # Returns a String charset name or nil if binary.
  #
  # source://sprockets//lib/sprockets/asset.rb#115
  def charset; end

  # Public: Returns String MIME type of asset. Returns nil if type is unknown.
  #
  # source://sprockets//lib/sprockets/asset.rb#82
  def content_type; end

  # Public: Returns String byte digest of source.
  #
  # source://sprockets//lib/sprockets/asset.rb#126
  def digest; end

  # Public: Return logical path with digest spliced in.
  #
  #   "foo/bar-37b51d194a7513e45b56f6524f2d51f2.js"
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/asset.rb#66
  def digest_path; end

  # Public: Add enumerator to allow `Asset` instances to be used as Rack
  # compatible body objects.
  #
  # block
  #   part - String body chunk
  #
  # Returns nothing.
  #
  # @yield [to_s]
  #
  # source://sprockets//lib/sprockets/asset.rb#168
  def each; end

  # Private: Return the version of the environment where the asset was generated.
  #
  # source://sprockets//lib/sprockets/asset.rb#131
  def environment_version; end

  # Public: Compare assets.
  #
  # Assets are equal if they share the same path and digest.
  #
  # Returns true or false.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/asset.rb#207
  def eql?(other); end

  # Pubic: ETag String of Asset.
  #
  # source://sprockets//lib/sprockets/asset.rb#141
  def etag; end

  # Public: Returns String path of asset.
  #
  # source://sprockets//lib/sprockets/asset.rb#47
  def filename; end

  # Public: Return load path + logical path with digest spliced in.
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/asset.rb#77
  def full_digest_path; end

  # Public: Implements Object#hash so Assets can be used as a Hash key or
  # in a Set.
  #
  # Returns Integer hash of the id.
  #
  # source://sprockets//lib/sprockets/asset.rb#198
  def hash; end

  # Public: Returns String hexdigest of source.
  #
  # source://sprockets//lib/sprockets/asset.rb#136
  def hexdigest; end

  # Internal: Unique asset object ID.
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/asset.rb#52
  def id; end

  # Public: Pretty inspect
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/asset.rb#190
  def inspect; end

  # Public: A "named information" URL for subresource integrity.
  #
  # source://sprockets//lib/sprockets/asset.rb#157
  def integrity; end

  # Public: Returns Integer length of source.
  #
  # source://sprockets//lib/sprockets/asset.rb#120
  def length; end

  # Public: Get all externally linked asset filenames from asset.
  #
  # All linked assets should be compiled anytime this asset is.
  #
  # Returns Set of String asset URIs.
  #
  # source://sprockets//lib/sprockets/asset.rb#89
  def links; end

  # Returns the value of attribute logical_path.
  #
  # source://sprockets//lib/sprockets/asset.rb#7
  def logical_path; end

  # Public: Metadata accumulated from pipeline process.
  #
  # The API status of the keys is dependent on the pipeline processors
  # itself. So some values maybe considered public and others internal.
  # See the pipeline processor documentation itself.
  #
  # Returns Hash.
  #
  # source://sprockets//lib/sprockets/asset.rb#44
  def metadata; end

  # Public: Return `String` of concatenated source.
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/asset.rb#96
  def source; end

  # Internal: Return all internal instance variables as a hash.
  #
  # Returns a Hash.
  #
  # source://sprockets//lib/sprockets/asset.rb#33
  def to_hash; end

  # Public: Alias for #source.
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/asset.rb#108
  def to_s; end

  # Public: Internal URI to lookup asset by.
  #
  # NOT a publicly accessible URL.
  #
  # Returns URI.
  #
  # source://sprockets//lib/sprockets/asset.rb#59
  def uri; end

  # Deprecated: Save asset to disk.
  #
  # filename - String target
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/asset.rb#177
  def write_to(filename); end
end

module Sprockets::Autoload; end

# source://sprockets//lib/sprockets/autoload/sassc.rb#6
Sprockets::Autoload::SassC = SassC

class Sprockets::BabelProcessor
  # @return [BabelProcessor] a new instance of BabelProcessor
  #
  # source://sprockets//lib/sprockets/babel_processor.rb#25
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/babel_processor.rb#23
  def cache_key; end

  # source://sprockets//lib/sprockets/babel_processor.rb#40
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/babel_processor.rb#19
    def cache_key; end

    # source://sprockets//lib/sprockets/babel_processor.rb#15
    def call(input); end

    # source://sprockets//lib/sprockets/babel_processor.rb#11
    def instance; end
  end
end

# source://sprockets//lib/sprockets/babel_processor.rb#9
Sprockets::BabelProcessor::VERSION = T.let(T.unsafe(nil), String)

# `Base` class for `Environment` and `CachedEnvironment`.
class Sprockets::Base
  include ::Sprockets::SourceMapUtils
  include ::Sprockets::Utils
  include ::Sprockets::PathUtils
  include ::Sprockets::DigestUtils
  include ::Sprockets::PathDigestUtils
  include ::Sprockets::URIUtils
  include ::Sprockets::PathDependencyUtils
  include ::Sprockets::Dependencies
  include ::Sprockets::Compressing
  include ::Sprockets::Exporting
  include ::Sprockets::ProcessorUtils
  include ::Sprockets::Resolve
  include ::Sprockets::Processing
  include ::Sprockets::HTTPUtils
  include ::Sprockets::Transformers
  include ::Sprockets::Mime
  include ::Sprockets::Paths
  include ::Sprockets::Configuration
  include ::Sprockets::Server
  include ::Sprockets::Loader
  include ::Sprockets::Bower
  include ::Sprockets::Npm

  # Preferred `find_asset` shorthand.
  #
  #     environment['application.js']
  #
  # source://sprockets//lib/sprockets/base.rb#118
  def [](*args, **options); end

  # Get persistent cache store
  #
  # source://sprockets//lib/sprockets/base.rb#41
  def cache; end

  # Set persistent cache store
  #
  # The cache store must implement a pair of getters and
  # setters. Either `get(key)`/`set(key, value)`,
  # `[key]`/`[key]=value`, `read(key)`/`write(key, value)`.
  #
  # source://sprockets//lib/sprockets/base.rb#48
  def cache=(cache); end

  # Return an `CachedEnvironment`. Must be implemented by the subclass.
  #
  # @raise [NotImplementedError]
  #
  # source://sprockets//lib/sprockets/base.rb#53
  def cached; end

  # source://sprockets//lib/sprockets/base.rb#139
  def compress_from_root(uri); end

  # source://sprockets//lib/sprockets/base.rb#143
  def expand_from_root(uri); end

  # Internal: Compute digest for path.
  #
  # path - String filename or directory path.
  #
  # Returns a String digest or nil.
  #
  # source://sprockets//lib/sprockets/base.rb#63
  def file_digest(path); end

  # @yield [asset]
  #
  # source://sprockets//lib/sprockets/base.rb#85
  def find_all_linked_assets(*args); end

  # Find asset by logical path or expanded path.
  #
  # source://sprockets//lib/sprockets/base.rb#78
  def find_asset(*args, **options); end

  # Find asset by logical path or expanded path.
  #
  # If the asset is not found an error will be raised.
  #
  # source://sprockets//lib/sprockets/base.rb#125
  def find_asset!(*args); end

  # Return an `CachedEnvironment`. Must be implemented by the subclass.
  #
  # @raise [NotImplementedError]
  #
  # source://sprockets//lib/sprockets/base.rb#53
  def index; end

  # Pretty inspect
  #
  # source://sprockets//lib/sprockets/base.rb#133
  def inspect; end
end

module Sprockets::Bower
  # Internal: Read bower.json's main directive.
  #
  # dirname  - String path to component directory.
  # filename - String path to bower.json.
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/bower.rb#48
  def read_bower_main(dirname, filename); end

  # Internal: Override resolve_alternates to install bower.json behavior.
  #
  # load_path    - String environment path
  # logical_path - String path relative to base
  #
  # Returns candidate filenames.
  #
  # source://sprockets//lib/sprockets/bower.rb#17
  def resolve_alternates(load_path, logical_path); end
end

# Internal: All supported bower.json files.
#
# https://github.com/bower/json/blob/0.4.0/lib/json.js#L7
#
# source://sprockets//lib/sprockets/bower.rb#9
Sprockets::Bower::POSSIBLE_BOWER_JSONS = T.let(T.unsafe(nil), Array)

# Internal: Bundle processor takes a single file asset and prepends all the
# `:required` URIs to the contents.
#
# Uses pipeline metadata:
#
#   :required - Ordered Set of asset URIs to prepend
#   :stubbed  - Set of asset URIs to subtract from the required set.
#
# Also see DirectiveProcessor.
class Sprockets::Bundle
  class << self
    # source://sprockets//lib/sprockets/bundle.rb#17
    def call(input); end

    # Internal: Removes uri from required if it's already included as an alias.
    #
    # required - Set of required uris
    #
    # Returns deduped set of uris
    #
    # source://sprockets//lib/sprockets/bundle.rb#61
    def dedup(required); end

    # Internal: Run bundle reducers on set of Assets producing a reduced
    # metadata Hash.
    #
    # filename - String bundle filename
    # assets - Array of Assets
    # reducers - Array of [initial, reducer_proc] pairs
    #
    # Returns reduced asset metadata Hash.
    #
    # source://sprockets//lib/sprockets/bundle.rb#80
    def process_bundle_reducers(input, assets, reducers); end
  end
end

# Public: Wrapper interface to backend cache stores. Ensures a consistent API
# even when the backend uses get/set or read/write.
#
# Public cache interface
#
# Always assign the backend store instance to Environment#cache=.
#
#     environment.cache = Sprockets::Cache::MemoryStore.new(1000)
#
# Environment#cache will always return a wrapped Cache interface. See the
# methods marked public on this class.
#
#
# Backend cache interface
#
# The Backend cache store must implement two methods.
#
# get(key)
#
#   key - An opaque String with a length less than 250 characters.
#
#   Returns an JSON serializable object.
#
# set(key, value)
#
#   Will only be called once per key. Setting a key "foo" with value "bar",
#   then later key "foo" with value "baz" is an undefined behavior.
#
#   key   - An opaque String with a length less than 250 characters.
#   value - A JSON serializable object.
#
#   Returns argument value.
#
# clear(options)
#
#   Clear the entire cache. Be careful with this method since it could
#   affect other processes if shared cache is being used.
#
#   The options hash is passed to the underlying cache implementation.
class Sprockets::Cache
  # Internal: Wrap a backend cache store.
  #
  # Always assign a backend cache store instance to Environment#cache= and
  # use Environment#cache to retrieve a wrapped interface.
  #
  # cache - A compatible backend cache store instance.
  #
  # @return [Cache] a new instance of Cache
  #
  # source://sprockets//lib/sprockets/cache.rb#68
  def initialize(cache = T.unsafe(nil), logger = T.unsafe(nil)); end

  # Public: Clear cache
  #
  # Returns truthy on success, potentially raises exception on failure
  #
  # source://sprockets//lib/sprockets/cache.rb#156
  def clear(options = T.unsafe(nil)); end

  # Public: Prefer API to retrieve and set values in the cache store.
  #
  # key   - JSON serializable key
  # block -
  #   Must return a consistent JSON serializable object for the given key.
  #
  # Examples
  #
  #   cache.fetch("foo") { "bar" }
  #
  # Returns a JSON serializable object.
  #
  # source://sprockets//lib/sprockets/cache.rb#85
  def fetch(key); end

  # Public: Low level API to retrieve item directly from the backend cache
  # store.
  #
  # This API may be used publicly, but may have undefined behavior
  # depending on the backend store being used. Prefer the
  # Cache#fetch API over using this.
  #
  # key   - JSON serializable key
  # local - Check local cache first (default: false)
  #
  # Returns a JSON serializable object or nil if there was a cache miss.
  #
  # source://sprockets//lib/sprockets/cache.rb#115
  def get(key, local = T.unsafe(nil)); end

  # Public: Pretty inspect
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/cache.rb#149
  def inspect; end

  # Public: Low level API to set item directly to the backend cache store.
  #
  # This API may be used publicly, but may have undefined behavior
  # depending on the backend store being used. Prefer the
  # Cache#fetch API over using this.
  #
  # key   - JSON serializable key
  # value - A consistent JSON serializable object for the given key. Setting
  #         a different value for the given key has undefined behavior.
  # local - Set on local cache (default: false)
  #
  # Returns the value argument.
  #
  # source://sprockets//lib/sprockets/cache.rb#140
  def set(key, value, local = T.unsafe(nil)); end

  private

  # Internal: Expand object cache key into a short String key.
  #
  # The String should be under 250 characters so its compatible with
  # Memcache.
  #
  # key - JSON serializable key
  #
  # Returns a String with a length less than 250 characters.
  #
  # source://sprockets//lib/sprockets/cache.rb#170
  def expand_key(key); end

  # source://sprockets//lib/sprockets/cache.rb#196
  def get_cache_wrapper(cache); end

  # Internal: Show first 100 characters of cache key for logging purposes.
  #
  # Returns a String with a length less than 100 characters.
  #
  # source://sprockets//lib/sprockets/cache.rb#181
  def peek_key(key); end

  class << self
    # source://sprockets//lib/sprockets/cache.rb#56
    def default_logger; end
  end
end

# Public: A file system cache store that automatically cleans up old keys.
#
# Assign the instance to the Environment#cache.
#
#     environment.cache = Sprockets::Cache::FileStore.new("/tmp")
#
# See Also
#
#   ActiveSupport::Cache::FileStore
class Sprockets::Cache::FileStore
  # Public: Initialize the cache store.
  #
  # root     - A String path to a directory to persist cached values to.
  # max_size - A Integer of the maximum size the store will hold (in bytes).
  #            (default: 25MB).
  # logger   - The logger to which some info will be printed.
  #            (default logger level is FATAL and won't output anything).
  #
  # @return [FileStore] a new instance of FileStore
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#42
  def initialize(root, max_size = T.unsafe(nil), logger = T.unsafe(nil)); end

  # Public: Clear the cache
  #
  # adapted from ActiveSupport::Cache::FileStore#clear
  #
  # Deletes all items from the cache. In this case it deletes all the entries in the specified
  # file store directory except for .keep or .gitkeep. Be careful which directory is specified
  # as @root because everything in that directory will be deleted.
  #
  # Returns true
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#139
  def clear(options = T.unsafe(nil)); end

  # Public: Retrieve value from cache.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key - String cache key.
  #
  # Returns Object or nil or the value is not set.
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#56
  def get(key); end

  # Public: Pretty inspect
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#126
  def inspect; end

  # Public: Set a key and value in the cache.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key   - String cache key.
  # value - Object value.
  #
  # Returns Object value.
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#85
  def set(key, value); end

  private

  # source://sprockets//lib/sprockets/cache/file_store.rb#166
  def compute_size(caches); end

  # Internal: Get all cache files along with stats.
  #
  # Returns an Array of [String filename, File::Stat] pairs sorted by
  # mtime.
  #
  # source://sprockets//lib/sprockets/cache/file_store.rb#152
  def find_caches; end

  # source://sprockets//lib/sprockets/cache/file_store.rb#183
  def gc!; end

  # source://sprockets//lib/sprockets/cache/file_store.rb#176
  def safe_open(path, &block); end

  # source://sprockets//lib/sprockets/cache/file_store.rb#170
  def safe_stat(fn); end

  # source://sprockets//lib/sprockets/cache/file_store.rb#162
  def size; end

  class << self
    # Internal: Default standard error fatal logger.
    #
    # Returns a Logger.
    #
    # source://sprockets//lib/sprockets/cache/file_store.rb#29
    def default_logger; end
  end
end

# Internal: Default key limit for store.
#
# source://sprockets//lib/sprockets/cache/file_store.rb#22
Sprockets::Cache::FileStore::DEFAULT_MAX_SIZE = T.let(T.unsafe(nil), Integer)

# source://sprockets//lib/sprockets/cache/file_store.rb#23
Sprockets::Cache::FileStore::EXCLUDED_DIRS = T.let(T.unsafe(nil), Array)

# source://sprockets//lib/sprockets/cache/file_store.rb#24
Sprockets::Cache::FileStore::GITKEEP_FILES = T.let(T.unsafe(nil), Array)

class Sprockets::Cache::GetWrapper < ::Sprockets::Cache::Wrapper
  # source://sprockets//lib/sprockets/cache.rb#230
  def clear(options = T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/cache.rb#222
  def get(key); end

  # source://sprockets//lib/sprockets/cache.rb#226
  def set(key, value); end
end

class Sprockets::Cache::HashWrapper < ::Sprockets::Cache::Wrapper
  # source://sprockets//lib/sprockets/cache.rb#250
  def clear(options = T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/cache.rb#242
  def get(key); end

  # source://sprockets//lib/sprockets/cache.rb#246
  def set(key, value); end
end

# Public: Basic in memory LRU cache.
#
# Assign the instance to the Environment#cache.
#
#     environment.cache = Sprockets::Cache::MemoryStore.new(1000)
#
# See Also
#
#   ActiveSupport::Cache::MemoryStore
class Sprockets::Cache::MemoryStore
  # Public: Initialize the cache store.
  #
  # max_size - A Integer of the maximum number of keys the store will hold.
  #            (default: 1000).
  #
  # @return [MemoryStore] a new instance of MemoryStore
  #
  # source://sprockets//lib/sprockets/cache/memory_store.rb#22
  def initialize(max_size = T.unsafe(nil)); end

  # Public: Clear the cache
  #
  # Returns true
  #
  # source://sprockets//lib/sprockets/cache/memory_store.rb#76
  def clear(options = T.unsafe(nil)); end

  # Public: Retrieve value from cache.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key - String cache key.
  #
  # Returns Object or nil or the value is not set.
  #
  # source://sprockets//lib/sprockets/cache/memory_store.rb#35
  def get(key); end

  # Public: Pretty inspect
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/cache/memory_store.rb#67
  def inspect; end

  # Public: Set a key and value in the cache.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key   - String cache key.
  # value - Object value.
  #
  # Returns Object value.
  #
  # source://sprockets//lib/sprockets/cache/memory_store.rb#55
  def set(key, value); end
end

# Internal: Default key limit for store.
#
# source://sprockets//lib/sprockets/cache/memory_store.rb#16
Sprockets::Cache::MemoryStore::DEFAULT_MAX_SIZE = T.let(T.unsafe(nil), Integer)

# Public: A compatible cache store that doesn't store anything. Used by
# default when no Environment#cache is configured.
#
# Assign the instance to the Environment#cache.
#
#     environment.cache = Sprockets::Cache::NullStore.new
#
# See Also
#
#   ActiveSupport::Cache::NullStore
class Sprockets::Cache::NullStore
  # Public: Simulate clearing the cache
  #
  # Returns true
  #
  # source://sprockets//lib/sprockets/cache/null_store.rb#49
  def clear(options = T.unsafe(nil)); end

  # Public: Simulate a cache miss.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key - String cache key.
  #
  # Returns nil.
  #
  # source://sprockets//lib/sprockets/cache/null_store.rb#23
  def get(key); end

  # Public: Pretty inspect
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/cache/null_store.rb#42
  def inspect; end

  # Public: Simulate setting a value in the cache.
  #
  # This API should not be used directly, but via the Cache wrapper API.
  #
  # key   - String cache key.
  # value - Object value.
  #
  # Returns Object value.
  #
  # source://sprockets//lib/sprockets/cache/null_store.rb#35
  def set(key, value); end
end

# source://sprockets//lib/sprockets/cache.rb#176
Sprockets::Cache::PEEK_SIZE = T.let(T.unsafe(nil), Integer)

class Sprockets::Cache::ReadWriteWrapper < ::Sprockets::Cache::Wrapper
  # source://sprockets//lib/sprockets/cache.rb#265
  def clear(options = T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/cache.rb#257
  def get(key); end

  # source://sprockets//lib/sprockets/cache.rb#261
  def set(key, value); end
end

# Internal: Cache key version for this class. Rarely should have to change
# unless the cache format radically changes. Will be bump on major version
# releases though.
#
# source://sprockets//lib/sprockets/cache.rb#54
Sprockets::Cache::VERSION = T.let(T.unsafe(nil), String)

class Sprockets::Cache::Wrapper < ::Struct; end

# `CachedEnvironment` is a special cached version of `Environment`.
#
# The exception is that all of its file system methods are cached
# for the instances lifetime. This makes `CachedEnvironment` much faster. This
# behavior is ideal in production environments where the file system
# is immutable.
#
# `CachedEnvironment` should not be initialized directly. Instead use
# `Environment#cached`.
class Sprockets::CachedEnvironment < ::Sprockets::Base
  # @return [CachedEnvironment] a new instance of CachedEnvironment
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#15
  def initialize(environment); end

  # No-op return self as cached environment.
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#27
  def cached; end

  # Internal: Cache Environment#entries
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#33
  def entries(path); end

  # No-op return self as cached environment.
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#27
  def index; end

  # Internal: Cache Environment#load
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#43
  def load(uri); end

  # Internal: Cache Environment#processor_cache_key
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#48
  def processor_cache_key(str); end

  # Internal: Cache Environment#resolve_dependency
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#53
  def resolve_dependency(str); end

  # Internal: Cache Environment#stat
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#38
  def stat(path); end

  private

  # Cache is immutable, any methods that try to change the runtime config
  # should bomb.
  #
  # @raise [RuntimeError]
  #
  # source://sprockets//lib/sprockets/cached_environment.rb#60
  def config=(config); end
end

# Public: Closure Compiler minifier.
#
# To accept the default options
#
#     environment.register_bundle_processor 'application/javascript',
#       Sprockets::ClosureCompressor
#
# Or to pass options to the Closure::Compiler class.
#
#     environment.register_bundle_processor 'application/javascript',
#       Sprockets::ClosureCompressor.new({ ... })
class Sprockets::ClosureCompressor
  # @return [ClosureCompressor] a new instance of ClosureCompressor
  #
  # source://sprockets//lib/sprockets/closure_compressor.rb#38
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/closure_compressor.rb#36
  def cache_key; end

  # source://sprockets//lib/sprockets/closure_compressor.rb#43
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/closure_compressor.rb#32
    def cache_key; end

    # source://sprockets//lib/sprockets/closure_compressor.rb#28
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns ClosureCompressor object.
    #
    # source://sprockets//lib/sprockets/closure_compressor.rb#24
    def instance; end
  end
end

# source://sprockets//lib/sprockets/closure_compressor.rb#19
Sprockets::ClosureCompressor::VERSION = T.let(T.unsafe(nil), String)

# Processor engine class for the CoffeeScript compiler.
# Depends on the `coffee-script` and `coffee-script-source` gems.
#
# For more information see:
#
#   https://github.com/rails/ruby-coffee-script
module Sprockets::CoffeeScriptProcessor
  class << self
    # source://sprockets//lib/sprockets/coffee_script_processor.rb#16
    def cache_key; end

    # source://sprockets//lib/sprockets/coffee_script_processor.rb#20
    def call(input); end
  end
end

# source://sprockets//lib/sprockets/coffee_script_processor.rb#14
Sprockets::CoffeeScriptProcessor::VERSION = T.let(T.unsafe(nil), String)

# `Compressing` is an internal mixin whose public methods are exposed on
# the `Environment` and `CachedEnvironment` classes.
module Sprockets::Compressing
  include ::Sprockets::Utils

  # source://sprockets//lib/sprockets/compressing.rb#10
  def compressors; end

  # Return CSS compressor or nil if none is set
  #
  # source://sprockets//lib/sprockets/compressing.rb#40
  def css_compressor; end

  # Assign a compressor to run on `text/css` assets.
  #
  # The compressor object must respond to `compress`.
  #
  # source://sprockets//lib/sprockets/compressing.rb#49
  def css_compressor=(compressor); end

  # Public: Enable or disable the creation of Gzip files.
  #
  # To disable gzip generation set to a falsey value:
  #
  #     environment.gzip = false
  #
  # To enable set to a truthy value. By default zlib wil
  # be used to gzip assets. If you have the Zopfli gem
  # installed you can specify the zopfli algorithm to be used
  # instead:
  #
  #     environment.gzip = :zopfli
  #
  # source://sprockets//lib/sprockets/compressing.rb#116
  def gzip=(gzip); end

  # Public: Checks if Gzip is enabled.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/compressing.rb#94
  def gzip?; end

  # Return JS compressor or nil if none is set
  #
  # source://sprockets//lib/sprockets/compressing.rb#67
  def js_compressor; end

  # Assign a compressor to run on `application/javascript` assets.
  #
  # The compressor object must respond to `compress`.
  #
  # source://sprockets//lib/sprockets/compressing.rb#76
  def js_compressor=(compressor); end

  # Public: Register a new compressor `klass` at `sym` for `mime_type`.
  #
  # Registering a processor allows it to be looked up by `sym` later when
  # assigning a JavaScript or CSS compressor.
  #
  # Compressors only operate on JavaScript and CSS. If you want to compress a
  # different type of asset, use a processor instead.
  #
  # Examples
  #
  #     register_compressor 'text/css', :my_sass, MySassCompressor
  #     css_compressor = :my_sass
  #
  # mime_type - String MIME Type (one of: 'test/css' or 'application/javascript').
  # sym       - Symbol registration address.
  # klass     - The compressor class.
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/compressing.rb#32
  def register_compressor(mime_type, sym, klass); end

  # Public: Checks if Gzip is disabled.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/compressing.rb#99
  def skip_gzip?; end
end

module Sprockets::Configuration
  include ::Sprockets::Utils
  include ::Sprockets::URIUtils
  include ::Sprockets::PathUtils
  include ::Sprockets::DigestUtils
  include ::Sprockets::PathDigestUtils
  include ::Sprockets::Dependencies
  include ::Sprockets::Compressing
  include ::Sprockets::Exporting
  include ::Sprockets::ProcessorUtils
  include ::Sprockets::Processing
  include ::Sprockets::HTTPUtils
  include ::Sprockets::Transformers
  include ::Sprockets::Mime
  include ::Sprockets::Paths

  # Returns the value of attribute config.
  #
  # source://sprockets//lib/sprockets/configuration.rb#21
  def config; end

  # @raise [TypeError]
  #
  # source://sprockets//lib/sprockets/configuration.rb#23
  def config=(config); end

  # This class maybe mutated and mixed in with custom helpers.
  #
  #     environment.context_class.instance_eval do
  #       include MyHelpers
  #       def asset_url; end
  #     end
  #
  # source://sprockets//lib/sprockets/configuration.rb#77
  def context_class; end

  # Public: Returns a `Digest` implementation class.
  #
  # Defaults to `Digest::SHA256`.
  #
  # source://sprockets//lib/sprockets/configuration.rb#56
  def digest_class; end

  # Deprecated: Assign a `Digest` implementation class. This maybe any Ruby
  # `Digest::` implementation such as `Digest::SHA256` or
  # `Digest::SHA512`.
  #
  #     environment.digest_class = Digest::SHA512
  #
  # source://sprockets//lib/sprockets/configuration.rb#66
  def digest_class=(klass); end

  # source://sprockets//lib/sprockets/configuration.rb#15
  def initialize_configuration(parent); end

  # Get and set `Logger` instance.
  #
  # source://sprockets//lib/sprockets/configuration.rb#29
  def logger; end

  # Get and set `Logger` instance.
  #
  # source://sprockets//lib/sprockets/configuration.rb#29
  def logger=(_arg0); end

  # The `Environment#version` is a custom value used for manually
  # expiring all asset caches.
  #
  # Sprockets is able to track most file and directory changes and
  # will take care of expiring the cache for you. However, its
  # impossible to know when any custom helpers change that you mix
  # into the `Context`.
  #
  # It would be wise to increment this value anytime you make a
  # configuration change to the `Environment` object.
  #
  # source://sprockets//lib/sprockets/configuration.rb#41
  def version; end

  # Assign an environment version.
  #
  #     environment.version = '2.0'
  #
  # source://sprockets//lib/sprockets/configuration.rb#49
  def version=(version); end
end

class Sprockets::ContentTypeMismatch < ::Sprockets::Error; end

# They are typically accessed by ERB templates. You can mix in custom helpers
# by injecting them into `Environment#context_class`. Do not mix them into
# `Context` directly.
#
#     environment.context_class.class_eval do
#       include MyHelper
#       def asset_url; end
#     end
#
#     <%= asset_url "foo.png" %>
#
# The `Context` also collects dependencies declared by
# assets. See `DirectiveProcessor` for an example of this.
class Sprockets::Context
  # @return [Context] a new instance of Context
  #
  # source://sprockets//lib/sprockets/context.rb#42
  def initialize(input); end

  # Returns a `data:` URI with the contents of the asset at the specified
  # path, and marks that path as a dependency of the current file.
  #
  # Uses URI encoding for SVG files, base64 encoding for all the other files.
  #
  # Use `asset_data_uri` from ERB with CSS or JavaScript assets:
  #
  #     #logo { background: url(<%= asset_data_uri 'logo.png' %>) }
  #
  #     $('<img>').attr('src', '<%= asset_data_uri 'avatar.jpg' %>')
  #
  # source://sprockets//lib/sprockets/context.rb#201
  def asset_data_uri(path); end

  # Expands logical path to full url to asset.
  #
  # NOTE: This helper is currently not implemented and should be
  # customized by the application. Though, in the future, some
  # basic implementation may be provided with different methods that
  # are required to be overridden.
  #
  # @raise [NotImplementedError]
  #
  # source://sprockets//lib/sprockets/context.rb#216
  def asset_path(path, options = T.unsafe(nil)); end

  # Expand logical audio asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#241
  def audio_path(path); end

  # Returns content type of file
  #
  #     'application/javascript'
  #     'text/css'
  #
  # source://sprockets//lib/sprockets/context.rb#88
  def content_type; end

  # `depend_on` allows you to state a dependency on a file without
  # including it.
  #
  # This is used for caching purposes. Any changes made to
  # the dependency file will invalidate the cache of the
  # source file.
  #
  # source://sprockets//lib/sprockets/context.rb#128
  def depend_on(path); end

  # `depend_on_asset` allows you to state an asset dependency
  # without including it.
  #
  # This is used for caching purposes. Any changes that would
  # invalidate the dependency asset will invalidate the source
  # file. Unlike `depend_on`, this will recursively include
  # the target asset's dependencies.
  #
  # source://sprockets//lib/sprockets/context.rb#144
  def depend_on_asset(path); end

  # `depend_on_env` allows you to state a dependency on an environment
  # variable.
  #
  # This is used for caching purposes. Any changes in the value of the
  # environment variable will invalidate the cache of the source file.
  #
  # source://sprockets//lib/sprockets/context.rb#153
  def depend_on_env(key); end

  # source://sprockets//lib/sprockets/context.rb#64
  def env_proxy; end

  # Returns the value of attribute environment.
  #
  # source://sprockets//lib/sprockets/context.rb#40
  def environment; end

  # Returns the value of attribute filename.
  #
  # source://sprockets//lib/sprockets/context.rb#40
  def filename; end

  # Expand logical font asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#246
  def font_path(path); end

  # Expand logical image asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#231
  def image_path(path); end

  # Expand logical javascript asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#251
  def javascript_path(path); end

  # `link_asset` declares an external dependency on an asset without directly
  # including it. The target asset is returned from this function making it
  # easy to construct a link to it.
  #
  # Returns an Asset or nil.
  #
  # source://sprockets//lib/sprockets/context.rb#184
  def link_asset(path); end

  # Public: Load Asset by AssetURI and track it as a dependency.
  #
  # uri - AssetURI
  #
  # Returns Asset.
  #
  # source://sprockets//lib/sprockets/context.rb#116
  def load(uri); end

  # Returns the environment path that contains the file.
  #
  # If `app/javascripts` and `app/stylesheets` are in your path, and
  # current file is `app/javascripts/foo/bar.js`, `load_path` would
  # return `app/javascripts`.
  #
  # source://sprockets//lib/sprockets/context.rb#73
  def load_path; end

  # Returns logical path without any file extensions.
  #
  #     'app/javascripts/application.js'
  #     # => 'application'
  #
  # source://sprockets//lib/sprockets/context.rb#81
  def logical_path; end

  # source://sprockets//lib/sprockets/context.rb#57
  def metadata; end

  # `require_asset` declares `path` as a dependency of the file. The
  # dependency will be inserted before the file and will only be
  # included once.
  #
  # If ERB processing is enabled, you can use it to dynamically
  # require assets.
  #
  #     <%= require_asset "#{framework}.js" %>
  #
  # source://sprockets//lib/sprockets/context.rb#166
  def require_asset(path); end

  # Public: Given a logical path, `resolve` will find and return an Asset URI.
  # Relative paths will also be resolved. An accept type maybe given to
  # restrict the search.
  #
  #     resolve("foo.js")
  #     # => "file:///path/to/app/javascripts/foo.js?type=application/javascript"
  #
  #     resolve("./bar.js")
  #     # => "file:///path/to/app/javascripts/bar.js?type=application/javascript"
  #
  # path   - String logical or absolute path
  # accept - String content accept type
  #
  # Returns an Asset URI String.
  #
  # source://sprockets//lib/sprockets/context.rb#104
  def resolve(path, **kargs); end

  # Returns the environment path that contains the file.
  #
  # If `app/javascripts` and `app/stylesheets` are in your path, and
  # current file is `app/javascripts/foo/bar.js`, `load_path` would
  # return `app/javascripts`.
  #
  # source://sprockets//lib/sprockets/context.rb#73
  def root_path; end

  # `stub_asset` blacklists `path` from being included in the bundle.
  # `path` must be an asset which may or may not already be included
  # in the bundle.
  #
  # source://sprockets//lib/sprockets/context.rb#174
  def stub_asset(path); end

  # Expand logical stylesheet asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#256
  def stylesheet_path(path); end

  # Expand logical video asset path.
  #
  # source://sprockets//lib/sprockets/context.rb#236
  def video_path(path); end

  protected

  # Returns a Base64-encoded data URI.
  #
  # source://sprockets//lib/sprockets/context.rb#272
  def base64_asset_data_uri(asset); end

  # Un-escapes characters in the given URI-escaped string that do not need
  # escaping in "-quoted data URIs.
  #
  # source://sprockets//lib/sprockets/context.rb#297
  def optimize_quoted_uri_escapes!(escaped); end

  # Optimizes an SVG for being URI-escaped.
  #
  # This method only performs these basic but crucial optimizations:
  # * Replaces " with ', because ' does not need escaping.
  # * Removes comments, meta, doctype, and newlines.
  # * Collapses whitespace.
  #
  # source://sprockets//lib/sprockets/context.rb#283
  def optimize_svg_for_uri_escaping!(svg); end

  # Returns a URI-encoded data URI (always "-quoted).
  #
  # source://sprockets//lib/sprockets/context.rb#263
  def svg_asset_data_uri(asset); end
end

# Internal: Proxy for ENV that keeps track of the environment variables used
class Sprockets::Context::ENVProxy < ::SimpleDelegator
  # @return [ENVProxy] a new instance of ENVProxy
  #
  # source://sprockets//lib/sprockets/context.rb#24
  def initialize(context); end

  # source://sprockets//lib/sprockets/context.rb#29
  def [](key); end

  # source://sprockets//lib/sprockets/context.rb#34
  def fetch(key, *_arg1); end
end

class Sprockets::ConversionError < ::Sprockets::NotFound; end

# `Dependencies` is an internal mixin whose public methods are exposed on the
# `Environment` and `CachedEnvironment` classes.
module Sprockets::Dependencies
  include ::Sprockets::URIUtils
  include ::Sprockets::PathUtils
  include ::Sprockets::DigestUtils
  include ::Sprockets::PathDigestUtils

  # Public: Add environmental dependency inherited by all assets.
  #
  # uri - String dependency URI
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#48
  def add_dependency(uri); end

  # Public: Add environmental dependency inherited by all assets.
  #
  # uri - String dependency URI
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#48
  def depend_on(uri); end

  # Public: Default set of dependency URIs for assets.
  #
  # Returns Set of String URIs.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#25
  def dependencies; end

  # Public: Mapping dependency schemes to resolver functions.
  #
  # key   - String scheme
  # value - Proc.call(Environment, String)
  #
  # Returns Hash.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#18
  def dependency_resolvers; end

  # Public: Register new dependency URI resolver.
  #
  # scheme - String scheme
  # block  -
  #   environment - Environment
  #   uri - String dependency URI
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#37
  def register_dependency_resolver(scheme, &block); end

  # Internal: Resolve dependency URIs.
  #
  # Returns resolved Object.
  #
  # source://sprockets//lib/sprockets/dependencies.rb#58
  def resolve_dependency(str); end
end

# Internal: Hash functions and digest related utilities. Mixed into
# Environment.
module Sprockets::DigestUtils
  extend ::Sprockets::DigestUtils

  # Internal: Checks an asset name for a valid digest
  #
  # name - The name of the asset
  #
  # Returns true if the name contains a digest like string and .digested before the extension
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#185
  def already_digested?(name); end

  # Internal: Detect digest class hash algorithm for digest bytes.
  #
  # While not elegant, all the supported digests have a unique bytesize.
  #
  # Returns Digest::Base or nil.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#32
  def detect_digest_class(bytes); end

  # Internal: Generate a hexdigest for a nested JSON serializable object.
  #
  # This is used for generating cache keys, so its pretty important its
  # wicked fast. Microbenchmarks away!
  #
  # obj - A JSON serializable object.
  #
  # Returns a String digest of the object.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#87
  def digest(obj); end

  # Internal: Default digest class.
  #
  # Returns a Digest::Base subclass.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#15
  def digest_class; end

  # Internal: Generate a hexdigest for a nested JSON serializable object.
  #
  # The same as `pack_hexdigest(digest(obj))`.
  #
  # obj - A JSON serializable object.
  #
  # Returns a String digest of the object.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#98
  def hexdigest(obj); end

  # Public: Generate hash for use in the `integrity` attribute of an asset tag
  # as per the subresource integrity specification.
  #
  # digest - The String hexbyte digest of the asset content.
  #
  # Returns a String or nil if hash algorithm is incompatible.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#176
  def hexdigest_integrity_uri(hexdigest); end

  # Public: Generate hash for use in the `integrity` attribute of an asset tag
  # as per the subresource integrity specification.
  #
  # digest - The String byte digest of the asset content.
  #
  # Returns a String or nil if hash algorithm is incompatible.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#154
  def integrity_uri(digest); end

  # Internal: Pack a binary digest to a base64 encoded string.
  #
  # bin - String bytes
  #
  # Returns base64 String.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#125
  def pack_base64digest(bin); end

  # Internal: Pack a binary digest to a hex encoded string.
  #
  # bin - String bytes
  #
  # Returns hex String.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#107
  def pack_hexdigest(bin); end

  # Internal: Pack a binary digest to a urlsafe base64 encoded string.
  #
  # bin - String bytes
  #
  # Returns urlsafe base64 String.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#134
  def pack_urlsafe_base64digest(bin); end

  # Internal: Unpack a hex encoded digest string into binary bytes.
  #
  # hex - String hex
  #
  # Returns binary String.
  #
  # source://sprockets//lib/sprockets/digest_utils.rb#116
  def unpack_hexdigest(hex); end

  private

  # source://sprockets//lib/sprockets/digest_utils.rb#190
  def build_digest(obj); end
end

# source://sprockets//lib/sprockets/digest_utils.rb#36
Sprockets::DigestUtils::ADD_VALUE_TO_DIGEST = T.let(T.unsafe(nil), Hash)

# Internal: Maps digest bytesize to the digest class.
#
# source://sprockets//lib/sprockets/digest_utils.rb#20
Sprockets::DigestUtils::DIGEST_SIZES = T.let(T.unsafe(nil), Hash)

# Internal: Maps digest class to the CSP hash algorithm name.
#
# source://sprockets//lib/sprockets/digest_utils.rb#142
Sprockets::DigestUtils::HASH_ALGORITHMS = T.let(T.unsafe(nil), Hash)

# The `DirectiveProcessor` is responsible for parsing and evaluating
# directive comments in a source file.
#
# A directive comment starts with a comment prefix, followed by an "=",
# then the directive name, then any arguments.
#
#     // JavaScript
#     //= require "foo"
#
#     # CoffeeScript
#     #= require "bar"
#
#     /* CSS
#      *= require "baz"
#      */
#
# This makes it possible to disable or modify the processor to do whatever
# you'd like. You could add your own custom directives or invent your own
# directive syntax.
#
# `Environment#processors` includes `DirectiveProcessor` by default.
#
# To remove the processor entirely:
#
#     env.unregister_processor('text/css', Sprockets::DirectiveProcessor)
#     env.unregister_processor('application/javascript', Sprockets::DirectiveProcessor)
#
# Then inject your own preprocessor:
#
#     env.register_processor('text/css', MyProcessor)
class Sprockets::DirectiveProcessor
  # @return [DirectiveProcessor] a new instance of DirectiveProcessor
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#60
  def initialize(comments: T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/directive_processor.rb#68
  def _call(input); end

  # source://sprockets//lib/sprockets/directive_processor.rb#64
  def call(input); end

  protected

  # Directives will only be picked up if they are in the header
  # of the source file. C style (/* */), JavaScript (//), and
  # Ruby (#) comments are supported.
  #
  # Directives in comments after the first non-whitespace line
  # of code will not be processed.
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#104
  def compile_header_pattern(comments); end

  # Returns an Array of directive structures. Each structure
  # is an Array with the line number as the first element, the
  # directive name as the second element, followed by any
  # arguments.
  #
  #     [[1, "require", "foo"], [2, "require", "bar"]]
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#141
  def extract_directives(header); end

  # Allows you to state a dependency on an asset without including
  # it.
  #
  # This is used for caching purposes. Any changes that would
  # invalidate the asset dependency will invalidate the cache of
  # the source file.
  #
  # Unlike `depend_on`, the path must be a requirable asset.
  #
  #     //= depend_on_asset "bar.js"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#284
  def process_depend_on_asset_directive(path); end

  # Allows you to state a dependency on a file without
  # including it.
  #
  # This is used for caching purposes. Any changes made to
  # the dependency file will invalidate the cache of the
  # source file.
  #
  # This is useful if you are using ERB and File.read to pull
  # in contents from another file.
  #
  #     //= depend_on "foo.png"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#269
  def process_depend_on_directive(path); end

  # Allows you to state a dependency on a relative directory
  # without including it.
  #
  # This is used for caching purposes. Any changes made to
  # the dependency directory will invalidate the cache of the
  # source file.
  #
  # This is useful if you are using ERB and File.read to pull
  # in contents from multiple files in a directory.
  #
  #     //= depend_on_directory ./data
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#300
  def process_depend_on_directory_directive(path = T.unsafe(nil), accept = T.unsafe(nil)); end

  # Gathers comment directives in the source and processes them.
  # Any directive method matching `process_*_directive` will
  # automatically be available. This makes it easy to extend the
  # processor.
  #
  # To implement a custom directive called `require_glob`, subclass
  # `Sprockets::DirectiveProcessor`, then add a method called
  # `process_require_glob_directive`.
  #
  #     class DirectiveProcessor < Sprockets::DirectiveProcessor
  #       def process_require_glob_directive(glob)
  #         Dir["#{dirname}/#{glob}"].sort.each do |filename|
  #           require(filename)
  #         end
  #       end
  #     end
  #
  # Replace the current processor on the environment with your own:
  #
  #     env.unregister_processor('text/css', Sprockets::DirectiveProcessor)
  #     env.register_processor('text/css', DirectiveProcessor)
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#186
  def process_directives(directives); end

  # Declares a linked dependency on the target asset.
  #
  # The `path` must be a valid asset and should not already be part of the
  # bundle. Any linked assets will automatically be compiled along with the
  # current.
  #
  #   /*= link "logo.png" */
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#326
  def process_link_directive(path); end

  # `link_directory` links all the files inside a single
  # directory. It's similar to `path/*` since it does not follow
  # nested directories.
  #
  #     //= link_directory "./fonts"
  #
  # Use caution when linking against JS or CSS assets. Include an explicit
  # extension or content type in these cases.
  #
  #     //= link_directory "./scripts" .js
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#342
  def process_link_directory_directive(path = T.unsafe(nil), accept = T.unsafe(nil)); end

  # `link_tree` links all the nested files in a directory.
  # Its glob equivalent is `path/**/*`.
  #
  #     //= link_tree "./images"
  #
  # Use caution when linking against JS or CSS assets. Include an explicit
  # extension or content type in these cases.
  #
  #     //= link_tree "./styles" .css
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#358
  def process_link_tree_directive(path = T.unsafe(nil), accept = T.unsafe(nil)); end

  # The `require` directive functions similar to Ruby's own `require`.
  # It provides a way to declare a dependency on a file in your path
  # and ensures it's only loaded once before the source file.
  #
  # `require` works with files in the environment path:
  #
  #     //= require "foo.js"
  #
  # Extensions are optional. If your source file is ".js", it
  # assumes you are requiring another ".js".
  #
  #     //= require "foo"
  #
  # Relative paths work too. Use a leading `./` to denote a relative
  # path:
  #
  #     //= require "./bar"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#215
  def process_require_directive(path); end

  # `require_directory` requires all the files inside a single
  # directory. It's similar to `path/*` since it does not follow
  # nested directories.
  #
  #     //= require_directory "./javascripts"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#242
  def process_require_directory_directive(path = T.unsafe(nil)); end

  # `require_self` causes the body of the current file to be inserted
  # before any subsequent `require` directives. Useful in CSS files, where
  # it's common for the index file to contain global styles that need to
  # be defined before other dependencies are loaded.
  #
  #     /*= require "reset"
  #      *= require_self
  #      *= require_tree .
  #      */
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#229
  def process_require_self_directive; end

  # `require_tree` requires all the nested files in a directory.
  # Its glob equivalent is `path/**/*`.
  #
  #     //= require_tree "./public"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#252
  def process_require_tree_directive(path = T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/directive_processor.rb#118
  def process_source(source); end

  # Allows dependency to be excluded from the asset bundle.
  #
  # The `path` must be a valid asset and may or may not already
  # be part of the bundle. Once stubbed, it is blacklisted and
  # can't be brought back by any other `require`.
  #
  #     //= stub "jquery"
  #
  # source://sprockets//lib/sprockets/directive_processor.rb#314
  def process_stub_directive(path); end

  private

  # source://sprockets//lib/sprockets/directive_processor.rb#365
  def expand_accept_shorthand(accept); end

  # source://sprockets//lib/sprockets/directive_processor.rb#399
  def expand_relative_dirname(directive, path); end

  # source://sprockets//lib/sprockets/directive_processor.rb#383
  def link_paths(paths, deps, accept); end

  # source://sprockets//lib/sprockets/directive_processor.rb#377
  def require_paths(paths, deps); end

  # source://sprockets//lib/sprockets/directive_processor.rb#420
  def resolve(path, **kargs); end

  # source://sprockets//lib/sprockets/directive_processor.rb#389
  def resolve_paths(paths, deps, **kargs); end

  # source://sprockets//lib/sprockets/directive_processor.rb#415
  def to_load(uri); end

  class << self
    # source://sprockets//lib/sprockets/directive_processor.rb#56
    def call(input); end

    # source://sprockets//lib/sprockets/directive_processor.rb#51
    def instance; end
  end
end

# Directives are denoted by a `=` followed by the name, then
# argument list.
#
# A few different styles are allowed:
#
#     // =require foo
#     //= require foo
#     //= require "foo"
#
# source://sprockets//lib/sprockets/directive_processor.rb#47
Sprockets::DirectiveProcessor::DIRECTIVE_PATTERN = T.let(T.unsafe(nil), Regexp)

class Sprockets::DoubleLinkError < ::Sprockets::Error
  # @return [DoubleLinkError] a new instance of DoubleLinkError
  #
  # source://sprockets//lib/sprockets/base.rb#21
  def initialize(parent_filename:, logical_path:, last_filename:, filename:); end
end

class Sprockets::ERBProcessor
  # @return [ERBProcessor] a new instance of ERBProcessor
  #
  # source://sprockets//lib/sprockets/erb_processor.rb#16
  def initialize(&block); end

  # source://sprockets//lib/sprockets/erb_processor.rb#20
  def call(input); end

  private

  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/erb_processor.rb#39
  def keyword_constructor?; end

  class << self
    # source://sprockets//lib/sprockets/erb_processor.rb#12
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns ERBProcessor object.
    #
    # source://sprockets//lib/sprockets/erb_processor.rb#8
    def instance; end
  end
end

# Processor engine class for the Eco compiler. Depends on the `eco` gem.
#
# For more information see:
#
#   https://github.com/sstephenson/ruby-eco
#   https://github.com/sstephenson/eco
module Sprockets::EcoProcessor
  class << self
    # source://sprockets//lib/sprockets/eco_processor.rb#15
    def cache_key; end

    # Compile template data with Eco compiler.
    #
    # Returns a JS function definition String. The result should be
    # assigned to a JS variable.
    #
    #     # => "function(...) {...}"
    #
    # source://sprockets//lib/sprockets/eco_processor.rb#26
    def call(input); end
  end
end

# source://sprockets//lib/sprockets/eco_processor.rb#13
Sprockets::EcoProcessor::VERSION = T.let(T.unsafe(nil), String)

# Processor engine class for the EJS compiler. Depends on the `ejs` gem.
#
# For more information see:
#
#   https://github.com/sstephenson/ruby-ejs
module Sprockets::EjsProcessor
  class << self
    # source://sprockets//lib/sprockets/ejs_processor.rb#14
    def cache_key; end

    # Compile template data with EJS compiler.
    #
    # Returns a JS function definition String. The result should be
    # assigned to a JS variable.
    #
    #     # => "function(obj){...}"
    #
    # source://sprockets//lib/sprockets/ejs_processor.rb#25
    def call(input); end
  end
end

# source://sprockets//lib/sprockets/ejs_processor.rb#12
Sprockets::EjsProcessor::VERSION = T.let(T.unsafe(nil), String)

# Internal: HTTP transport encoding and charset detecting related functions.
# Mixed into Environment.
module Sprockets::EncodingUtils
  extend ::Sprockets::EncodingUtils

  # Public: Use base64 to encode data.
  #
  # str - String data
  #
  # Returns a encoded String
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#73
  def base64(str); end

  # Internal: Use Charlock Holmes to detect encoding.
  #
  # To enable this code path, require 'charlock_holmes'
  #
  # Returns encoded String.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#122
  def charlock_detect(str); end

  # Public: Use deflate to compress data.
  #
  # str - String data
  #
  # Returns a compressed String
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#19
  def deflate(str); end

  # Public: Basic string detecter.
  #
  # Attempts to parse any Unicode BOM otherwise falls back to the
  # environment's external encoding.
  #
  # str - ASCII-8BIT encoded String
  #
  # Returns encoded String.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#100
  def detect(str); end

  # Public: Detect and strip @charset from CSS style sheet.
  #
  # str - String.
  #
  # Returns a encoded String.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#178
  def detect_css(str); end

  # Public: Detect charset from HTML document.
  #
  # Attempts to parse any Unicode BOM otherwise attempt Charlock detection
  # and finally falls back to the environment's external encoding.
  #
  # str - String.
  #
  # Returns a encoded String.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#245
  def detect_html(str); end

  # Public: Detect Unicode string.
  #
  # Attempts to parse Unicode BOM and falls back to UTF-8.
  #
  # str - ASCII-8BIT encoded String
  #
  # Returns encoded String.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#139
  def detect_unicode(str); end

  # Public: Detect and strip BOM from possible unicode string.
  #
  # str - ASCII-8BIT encoded String
  #
  # Returns UTF 8/16/32 encoded String without BOM or the original String if
  # no BOM was present.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#157
  def detect_unicode_bom(str); end

  # Public: Use gzip to compress data.
  #
  # str - String data
  #
  # Returns a compressed String
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#59
  def gzip(str); end

  # Internal: Scan binary CSS string for @charset encoding name.
  #
  # str - ASCII-8BIT encoded String
  #
  # Returns encoding String name or nil.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#208
  def scan_css_charset(str); end

  # Internal: Unmarshal optionally deflated data.
  #
  # Checks leading marshal header to see if the bytes are uncompressed
  # otherwise inflate the data an unmarshal.
  #
  # str - Marshaled String
  # window_bits - Integer deflate window size. See ZLib::Inflate.new()
  #
  # Returns unmarshaled Object or raises an Exception.
  #
  # source://sprockets//lib/sprockets/encoding_utils.rb#39
  def unmarshaled_deflated(str, window_bits = T.unsafe(nil)); end
end

# Internal: Mapping unicode encodings to byte order markers.
#
# source://sprockets//lib/sprockets/encoding_utils.rb#84
Sprockets::EncodingUtils::BOM = T.let(T.unsafe(nil), Hash)

# Internal: Shorthand aliases for detecter functions.
#
# source://sprockets//lib/sprockets/encoding_utils.rb#81
Sprockets::EncodingUtils::CHARSET_DETECT = T.let(T.unsafe(nil), Hash)

# source://sprockets//lib/sprockets/encoding_utils.rb#201
Sprockets::EncodingUtils::CHARSET_SIZE = T.let(T.unsafe(nil), Integer)

# Internal: @charset bytes
#
# source://sprockets//lib/sprockets/encoding_utils.rb#200
Sprockets::EncodingUtils::CHARSET_START = T.let(T.unsafe(nil), Array)

class Sprockets::Environment < ::Sprockets::Base
  # `Environment` should be initialized with your application's root
  # directory. This should be the same as your Rails or Rack root.
  #
  #     env = Environment.new(Rails.root)
  #
  # @return [Environment] a new instance of Environment
  # @yield [_self]
  # @yieldparam _self [Sprockets::Environment] the object that the method was called on
  #
  # source://sprockets//lib/sprockets/environment.rb#13
  def initialize(root = T.unsafe(nil)); end

  # Returns a cached version of the environment.
  #
  # All of its file system calls are cached which makes `cached` much
  # faster. This behavior is ideal in production since the file
  # system only changes between deploys.
  #
  # source://sprockets//lib/sprockets/environment.rb#25
  def cached; end

  # source://sprockets//lib/sprockets/environment.rb#38
  def find_all_linked_assets(*args, &block); end

  # source://sprockets//lib/sprockets/environment.rb#30
  def find_asset(*args, **options); end

  # source://sprockets//lib/sprockets/environment.rb#34
  def find_asset!(*args); end

  # Returns a cached version of the environment.
  #
  # All of its file system calls are cached which makes `cached` much
  # faster. This behavior is ideal in production since the file
  # system only changes between deploys.
  #
  # source://sprockets//lib/sprockets/environment.rb#25
  def index; end

  # source://sprockets//lib/sprockets/environment.rb#42
  def load(*args); end
end

class Sprockets::Error < ::StandardError; end
module Sprockets::Exporters; end

# Convenience class for all exporters to inherit from
#
# An exporter is responsible for exporting a Sprockets::Asset
# to a file system. For example the Exporters::File class
# writes the asset to it's destination. The Exporters::Zlib class
# writes a gzip copy of the asset to disk.
class Sprockets::Exporters::Base
  # Public: Creates new instance
  #
  # Initialize will be called with
  # keyword arguments:
  #
  # - asset: An instance of Sprockets::Asset.
  # - environment: An instance of Sprockets::Environment.
  # - directory: String representing the target directory to write to.
  #
  # These will all be stored as accessible values. In addition a
  # +target+ will be available which is the target directory and
  # the asset's digest path combined.
  #
  # @return [Base] a new instance of Base
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#24
  def initialize(asset: T.unsafe(nil), environment: T.unsafe(nil), directory: T.unsafe(nil)); end

  # Returns the value of attribute asset.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#10
  def asset; end

  # Public: Contains logic for writing "exporting" asset to disk
  #
  # If the exporter is not skipped it then Sprockets will execute it's
  # `call` method. This method takes no arguments and should only use
  # elements passed in via initialize or stored in `setup`.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#55
  def call; end

  # Returns the value of attribute directory.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#10
  def directory; end

  # Returns the value of attribute environment.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#10
  def environment; end

  # Public: Callback that is executed after initialization
  #
  # Any setup that needs to be done can be performed in the +setup+
  # method. It will be called immediately after initialization.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#36
  def setup; end

  # Public: Handles logic for skipping exporter and notifying logger
  #
  # The `skip?` will be called before anything will be written.
  # If `skip?` returns truthy it will not continue. This method
  # takes a `logger` that responds to +debug+ and +info+.  The `skip?`
  # method is the only place expected to write to a logger, any other
  # messages may produce jumbled logs.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#46
  def skip?(logger); end

  # Returns the value of attribute target.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#10
  def target; end

  # Public: Yields a file that can be written to with the input
  #
  # `filename`. Defaults to the `target`. Method
  # is safe to use in forked or threaded environments.
  #
  # source://sprockets//lib/sprockets/exporters/base.rb#63
  def write(filename = T.unsafe(nil)); end
end

# Writes a an asset file to disk
class Sprockets::Exporters::FileExporter < ::Sprockets::Exporters::Base
  # source://sprockets//lib/sprockets/exporters/file_exporter.rb#17
  def call; end

  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/exporters/file_exporter.rb#7
  def skip?(logger); end
end

# Generates a `.gz` file using the zlib algorithm built into
# Ruby's standard library.
class Sprockets::Exporters::ZlibExporter < ::Sprockets::Exporters::Base
  # source://sprockets//lib/sprockets/exporters/zlib_exporter.rb#26
  def call; end

  # source://sprockets//lib/sprockets/exporters/zlib_exporter.rb#9
  def setup; end

  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/exporters/zlib_exporter.rb#14
  def skip?(logger); end
end

# Generates a `.gz` file using the zopfli algorithm from the
# Zopfli gem.
class Sprockets::Exporters::ZopfliExporter < ::Sprockets::Exporters::ZlibExporter
  # source://sprockets//lib/sprockets/exporters/zopfli_exporter.rb#8
  def setup; end
end

# `Exporting` is an internal mixin whose public methods are exposed on
# the `Environment` and `CachedEnvironment` classes.
module Sprockets::Exporting
  # Public: Checks if concurrent exporting is allowed
  #
  # source://sprockets//lib/sprockets/exporting.rb#59
  def export_concurrent; end

  # Public: Enable or disable the concurrently exporting files
  #
  # Defaults to true.
  #
  #     environment.export_concurrent = false
  #
  # source://sprockets//lib/sprockets/exporting.rb#69
  def export_concurrent=(export_concurrent); end

  # Exporters are ran on the assets:precompile task
  #
  # source://sprockets//lib/sprockets/exporting.rb#6
  def exporters; end

  # Public: Registers a new Exporter `klass` for `mime_type`.
  #
  # If your exporter depends on one or more other exporters you can
  # specify this via the `depend_on` keyword.
  #
  #     register_exporter '*/*', Sprockets::Exporters::ZlibExporter
  #
  # This ensures that `Sprockets::Exporters::File` will always execute before
  # `Sprockets::Exporters::Zlib`
  #
  # source://sprockets//lib/sprockets/exporting.rb#19
  def register_exporter(mime_types, klass = T.unsafe(nil)); end

  # Public: Remove Exporting processor `klass` for `mime_type`.
  #
  #     environment.unregister_exporter '*/*', Sprockets::Exporters::ZlibExporter
  #
  # Can be called without a mime type
  #
  #     environment.unregister_exporter Sprockets::Exporters::ZlibExporter
  #
  # Does not remove any exporters that depend on `klass`.
  #
  # source://sprockets//lib/sprockets/exporting.rb#38
  def unregister_exporter(mime_types, exporter = T.unsafe(nil)); end
end

class Sprockets::FileNotFound < ::Sprockets::NotFound; end
class Sprockets::FileOutsidePaths < ::Sprockets::NotFound; end

# Internal: The first processor in the pipeline that reads the file into
# memory and passes it along as `input[:data]`.
class Sprockets::FileReader
  class << self
    # source://sprockets//lib/sprockets/file_reader.rb#8
    def call(input); end
  end
end

# Internal: HTTP URI utilities. Many adapted from Rack::Utils. Mixed into
# Environment.
module Sprockets::HTTPUtils
  extend ::Sprockets::HTTPUtils

  # Internal: Find the best qvalue match from an Array of available mime type
  # options.
  #
  # Adapted from Rack::Utils#q_values.
  #
  # Returns the matched mime type String from available Array or nil.
  #
  # source://sprockets//lib/sprockets/http_utils.rb#129
  def find_best_mime_type_match(q_value_header, available); end

  # Internal: Find the best qvalue match from an Array of available options.
  #
  # Adapted from Rack::Utils#q_values.
  #
  # Returns the matched String from available Array or nil.
  #
  # source://sprockets//lib/sprockets/http_utils.rb#107
  def find_best_q_match(q_values, available, &matcher); end

  # Internal: Find the all qvalue match from an Array of available mime type
  # options.
  #
  # Adapted from Rack::Utils#q_values.
  #
  # Returns Array of matched mime type Strings from available Array or [].
  #
  # source://sprockets//lib/sprockets/http_utils.rb#117
  def find_mime_type_matches(q_value_header, available); end

  # Internal: Find all qvalue matches from an Array of available options.
  #
  # Adapted from Rack::Utils#q_values.
  #
  # Returns Array of matched Strings from available Array or [].
  #
  # source://sprockets//lib/sprockets/http_utils.rb#74
  def find_q_matches(q_values, available, &matcher); end

  # Public: Test mime type against mime range.
  #
  #    match_mime_type?('text/html', 'text/*') => true
  #    match_mime_type?('text/plain', '*') => true
  #    match_mime_type?('text/html', 'application/json') => false
  #
  # Returns true if the given value is a mime match for the given mime match
  # specification, false otherwise.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/http_utils.rb#16
  def match_mime_type?(value, matcher); end

  # Public: Return values from Hash where the key matches the mime type.
  #
  # hash      - Hash of String matcher keys to Object values
  # mime_type - String mime type
  #
  # Returns Array of Object values.
  #
  # source://sprockets//lib/sprockets/http_utils.rb#28
  def match_mime_type_keys(hash, mime_type); end

  # Internal: Parse Accept header quality values.
  #
  # values - String e.g. "application/javascript"
  #
  # Adapted from Rack::Utils#q_values. Quality values are
  # described in http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
  #
  #    parse_q_values("application/javascript")
  #      # => [["application/javascript", 1.0]]
  #
  #    parse_q_values("*/*")
  #      # => [["*/*", 1.0]]
  #
  #    parse_q_values("text/plain; q=0.5, image/*")
  #      # => [["text/plain", 0.5], ["image/*", 1.0]]
  #
  #    parse_q_values("application/javascript, text/css")
  #      # => [["application/javascript", 1.0], ["text/css", 1.0]]
  #
  # Returns an Array of [String, Float].
  #
  # source://sprockets//lib/sprockets/http_utils.rb#58
  def parse_q_values(values); end
end

class Sprockets::JSMincCompressor
  # @return [JSMincCompressor] a new instance of JSMincCompressor
  #
  # source://sprockets//lib/sprockets/jsminc_compressor.rb#23
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/jsminc_compressor.rb#21
  def cache_key; end

  # source://sprockets//lib/sprockets/jsminc_compressor.rb#28
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/jsminc_compressor.rb#17
    def cache_key; end

    # source://sprockets//lib/sprockets/jsminc_compressor.rb#13
    def call(input); end

    # source://sprockets//lib/sprockets/jsminc_compressor.rb#9
    def instance; end
  end
end

# source://sprockets//lib/sprockets/jsminc_compressor.rb#7
Sprockets::JSMincCompressor::VERSION = T.let(T.unsafe(nil), String)

# Public: JST transformer.
#
# Exports server side compiled templates to an object.
#
# Name your template "users/show.ejs", "users/new.eco", etc.
#
# To accept the default options
#
#     environment.register_transformer
#       'application/javascript+function',
#       'application/javascript', JstProcessor
#
# Change the default namespace.
#
#     environment.register_transformer
#       'application/javascript+function',
#       'application/javascript', JstProcessor.new(namespace: 'App.templates')
class Sprockets::JstProcessor
  # @return [JstProcessor] a new instance of JstProcessor
  #
  # source://sprockets//lib/sprockets/jst_processor.rb#37
  def initialize(namespace: T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/jst_processor.rb#41
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/jst_processor.rb#33
    def call(input); end

    # source://sprockets//lib/sprockets/jst_processor.rb#22
    def default_namespace; end

    # Public: Return singleton instance with default options.
    #
    # Returns JstProcessor object.
    #
    # source://sprockets//lib/sprockets/jst_processor.rb#29
    def instance; end
  end
end

# The loader phase takes a asset URI location and returns a constructed Asset
# object.
module Sprockets::Loader
  include ::Sprockets::URIUtils
  include ::Sprockets::Utils
  include ::Sprockets::ProcessorUtils
  include ::Sprockets::PathUtils
  include ::Sprockets::DigestUtils
  include ::Sprockets::PathDependencyUtils
  include ::Sprockets::HTTPUtils
  include ::Sprockets::Transformers
  include ::Sprockets::Resolve
  include ::Sprockets::Processing
  include ::Sprockets::Mime

  # Public: Load Asset by Asset URI.
  #
  # uri - A String containing complete URI to a file including schema
  #       and full path such as:
  #       "file:///Path/app/assets/js/app.js?type=application/javascript"
  #
  # Returns Asset.
  #
  # source://sprockets//lib/sprockets/loader.rb#31
  def load(uri); end

  private

  # Internal: Load asset hash from cache
  #
  # key - A String containing lookup information for an asset
  #
  # This method converts all "compressed" paths to absolute paths.
  # Returns a hash of values representing an asset
  #
  # source://sprockets//lib/sprockets/loader.rb#111
  def asset_from_cache(key); end

  # source://sprockets//lib/sprockets/loader.rb#67
  def compress_key_from_hash(hash, key); end

  # source://sprockets//lib/sprockets/loader.rb#87
  def expand_key_from_hash(hash, key); end

  # Internal: Retrieves an asset based on its digest
  #
  # unloaded - An UnloadedAsset
  # limit    - An Integer which sets the maximum number of versions of "histories"
  #            stored in the cache
  #
  # This method attempts to retrieve the last `limit` number of histories of an asset
  # from the cache a "history" which is an array of unresolved "dependencies" that the asset needs
  # to compile. In this case a dependency can refer to either an asset e.g. index.js
  # may rely on jquery.js (so jquery.js is a dependency), or other factors that may affect
  # compilation, such as the VERSION of Sprockets (i.e. the environment) and what "processors"
  # are used.
  #
  # For example a history array may look something like this
  #
  #   [["environment-version", "environment-paths", "processors:type=text/css&file_type=text/css",
  #     "file-digest:///Full/path/app/assets/stylesheets/application.css",
  #     "processors:type=text/css&file_digesttype=text/css&pipeline=self",
  #     "file-digest:///Full/path/app/assets/stylesheets"]]
  #
  # Where the first entry is a Set of dependencies for last generated version of that asset.
  # Multiple versions are stored since Sprockets keeps the last `limit` number of assets
  # generated present in the system.
  #
  # If a "history" of dependencies is present in the cache, each version of "history" will be
  # yielded to the passed block which is responsible for loading the asset. If found, the existing
  # history will be saved with the dependency that found a valid asset moved to the front.
  #
  # If no history is present, or if none of the histories could be resolved to a valid asset then,
  # the block is yielded to and expected to return a valid asset.
  # When this happens the dependencies for the returned asset are added to the "history", and older
  # entries are removed if the "history" is above `limit`.
  #
  # source://sprockets//lib/sprockets/loader.rb#323
  def fetch_asset_from_dependency_cache(unloaded, limit = T.unsafe(nil)); end

  # Internal: Loads an asset and saves it to cache
  #
  # unloaded - An UnloadedAsset
  #
  # This method is only called when the given unloaded asset could not be
  # successfully pulled from cache.
  #
  # source://sprockets//lib/sprockets/loader.rb#139
  def load_from_unloaded(unloaded); end

  # Internal: Resolve set of dependency URIs.
  #
  # uris - An Array of "dependencies" for example:
  #        ["environment-version", "environment-paths", "processors:type=text/css&file_type=text/css",
  #           "file-digest:///Full/path/app/assets/stylesheets/application.css",
  #           "processors:type=text/css&file_type=text/css&pipeline=self",
  #           "file-digest:///Full/path/app/assets/stylesheets"]
  #
  # Returns back array of things that the given uri depends on
  # For example the environment version, if you're using a different version of sprockets
  # then the dependencies should be different, this is used only for generating cache key
  # for example the "environment-version" may be resolved to "environment-1.0-3.2.0" for
  # version "3.2.0" of sprockets.
  #
  # Any paths that are returned are converted to relative paths
  #
  # Returns array of resolved dependencies
  #
  # source://sprockets//lib/sprockets/loader.rb#287
  def resolve_dependencies(uris); end

  # Internal: Save a given asset to the cache
  #
  # asset - A hash containing values of loaded asset
  # unloaded - The UnloadedAsset used to lookup the `asset`
  #
  # This method converts all absolute paths to "compressed" paths
  # which are relative if they're in the root.
  #
  # source://sprockets//lib/sprockets/loader.rb#237
  def store_asset(asset, unloaded); end
end

# The Manifest logs the contents of assets compiled to a single directory. It
# records basic attributes about the asset for fast lookup without having to
# compile. A pointer from each logical path indicates which fingerprinted
# asset is the current one.
#
# The JSON is part of the public API and should be considered stable. This
# should make it easy to read from other programming languages and processes
# that don't have sprockets loaded. See `#assets` and `#files` for more
# information about the structure.
class Sprockets::Manifest
  include ::Sprockets::ManifestUtils

  # Create new Manifest associated with an `environment`. `filename` is a full
  # path to the manifest json file. The file may or may not already exist. The
  # dirname of the `filename` will be used to write compiled assets to.
  # Otherwise, if the path is a directory, the filename will default a random
  # ".sprockets-manifest-*.json" file in that directory.
  #
  #   Manifest.new(environment, "./public/assets/manifest.json")
  #
  # @return [Manifest] a new instance of Manifest
  #
  # source://sprockets//lib/sprockets/manifest.rb#32
  def initialize(*args); end

  # Returns internal assets mapping. Keys are logical paths which
  # map to the latest fingerprinted filename.
  #
  #   Logical path (String): Fingerprint path (String)
  #
  #   { "application.js" => "application-2e8e9a7c6b0aafa0c9bdeec90ea30213.js",
  #     "jquery.js"      => "jquery-ae0908555a245f8266f77df5a8edca2e.js" }
  #
  # source://sprockets//lib/sprockets/manifest.rb#91
  def assets; end

  # Cleanup old assets in the compile directory. By default it will
  # keep the latest version, 2 backups and any created within the past hour.
  #
  # Examples
  #
  #   To force only 1 backup to be kept, set count=1 and age=0.
  #
  #   To only keep files created within the last 10 minutes, set count=0 and
  #   age=600.
  #
  # source://sprockets//lib/sprockets/manifest.rb#246
  def clean(count = T.unsafe(nil), age = T.unsafe(nil)); end

  # Wipe directive
  #
  # source://sprockets//lib/sprockets/manifest.rb#269
  def clobber; end

  # Compile asset to directory. The asset is written to a
  # fingerprinted filename like
  # `application-2e8e9a7c6b0aafa0c9bdeec90ea30213.js`. An entry is
  # also inserted into the manifest file.
  #
  #   compile("application.js")
  #
  # source://sprockets//lib/sprockets/manifest.rb#161
  def compile(*args); end

  # Returns the value of attribute directory.
  #
  # source://sprockets//lib/sprockets/manifest.rb#80
  def dir; end

  # Returns the value of attribute directory.
  #
  # source://sprockets//lib/sprockets/manifest.rb#80
  def directory; end

  # Returns the value of attribute environment.
  #
  # source://sprockets//lib/sprockets/manifest.rb#22
  def environment; end

  # Returns String path to manifest.json file.
  #
  # source://sprockets//lib/sprockets/manifest.rb#77
  def filename; end

  # Returns internal file directory listing. Keys are filenames
  # which map to an attributes array.
  #
  #   Fingerprint path (String):
  #     logical_path: Logical path (String)
  #     mtime: ISO8601 mtime (String)
  #     digest: Base64 hex digest (String)
  #
  #  { "application-2e8e9a7c6b0aafa0c9bdeec90ea30213.js" =>
  #      { 'logical_path' => "application.js",
  #        'mtime' => "2011-12-13T21:47:08-06:00",
  #        'digest' => "2e8e9a7c6b0aafa0c9bdeec90ea30213" } }
  #
  # source://sprockets//lib/sprockets/manifest.rb#108
  def files; end

  # Public: Find all assets matching pattern set in environment.
  #
  # Returns Enumerator of Assets.
  #
  # source://sprockets//lib/sprockets/manifest.rb#115
  def find(*args, &block); end

  # Public: Find the source of assets by paths.
  #
  # Returns Enumerator of assets file content.
  #
  # source://sprockets//lib/sprockets/manifest.rb#139
  def find_sources(*args); end

  # Returns String path to manifest.json file.
  #
  # source://sprockets//lib/sprockets/manifest.rb#77
  def path; end

  # Removes file from directory and from manifest. `filename` must
  # be the name with any directory path.
  #
  #   manifest.remove("application-2e8e9a7c6b0aafa0c9bdeec90ea30213.js")
  #
  # source://sprockets//lib/sprockets/manifest.rb#216
  def remove(filename); end

  # Persist manifest back to FS
  #
  # source://sprockets//lib/sprockets/manifest.rb#278
  def save; end

  private

  # source://sprockets//lib/sprockets/manifest.rb#335
  def executor; end

  # Given an asset, finds all exporters that
  # match its mime-type.
  #
  # Will yield each expoter to the passed in block.
  #
  #     array = []
  #     puts asset.content_type # => "application/javascript"
  #     exporters_for_asset(asset) do |exporter|
  #       array << exporter
  #     end
  #     # puts array => [Exporters::FileExporter, Exporters::ZlibExporter]
  #
  # source://sprockets//lib/sprockets/manifest.rb#299
  def exporters_for_asset(asset); end

  # source://sprockets//lib/sprockets/manifest.rb#317
  def json_decode(obj); end

  # source://sprockets//lib/sprockets/manifest.rb#321
  def json_encode(obj); end

  # source://sprockets//lib/sprockets/manifest.rb#325
  def logger; end
end

# Public: Manifest utilities.
module Sprockets::ManifestUtils
  extend ::Sprockets::ManifestUtils

  # Public: Find or pick a new manifest filename for target build directory.
  #
  # dirname - String dirname
  #
  # Examples
  #
  #     find_directory_manifest("/app/public/assets")
  #     # => "/app/public/assets/.sprockets-manifest-abc123.json"
  #
  # Returns String filename.
  #
  # source://sprockets//lib/sprockets/manifest_utils.rb#37
  def find_directory_manifest(dirname, logger = T.unsafe(nil)); end

  # Public: Generate a new random manifest path.
  #
  # Manifests are not intended to be accessed publicly, but typically live
  # alongside public assets for convenience. To avoid being served, the
  # filename is prefixed with a "." which is usually hidden by web servers
  # like Apache. To help in other environments that may not control this,
  # a random hex string is appended to the filename to prevent people from
  # guessing the location. If directory indexes are enabled on the server,
  # all bets are off.
  #
  # Return String path.
  #
  # source://sprockets//lib/sprockets/manifest_utils.rb#23
  def generate_manifest_path; end
end

# source://sprockets//lib/sprockets/manifest_utils.rb#10
Sprockets::ManifestUtils::MANIFEST_RE = T.let(T.unsafe(nil), Regexp)

module Sprockets::Mime
  include ::Sprockets::Utils
  include ::Sprockets::HTTPUtils

  # Internal: Mapping of MIME extension Strings to MIME type Strings.
  #
  # Used for internal fast lookup purposes.
  #
  # Examples:
  #
  #   mime_exts['.js'] #=> 'application/javascript'
  #
  # key   - MIME extension String
  # value - MIME Type String
  #
  # Returns Hash.
  #
  # source://sprockets//lib/sprockets/mime.rb#34
  def mime_exts; end

  # Internal: Get detecter function for MIME type.
  #
  # mime_type - String MIME type
  #
  # Returns Proc detector or nil if none is available.
  #
  # source://sprockets//lib/sprockets/mime.rb#71
  def mime_type_charset_detecter(mime_type); end

  # Public: Mapping of MIME type Strings to properties Hash.
  #
  # key   - MIME Type String
  # value - Hash
  #   extensions - Array of extnames
  #   charset    - Default Encoding or function to detect encoding
  #
  # Returns Hash.
  #
  # source://sprockets//lib/sprockets/mime.rb#18
  def mime_types; end

  # Public: Read file on disk with MIME type specific encoding.
  #
  # filename     - String path
  # content_type - String MIME type
  #
  # Returns String file contents transcoded to UTF-8 or in its external
  # encoding.
  #
  # source://sprockets//lib/sprockets/mime.rb#86
  def read_file(filename, content_type = T.unsafe(nil)); end

  # Public: Register a new mime type.
  #
  # mime_type  - String MIME Type
  # extensions - Array of String extnames
  # charset    - Proc/Method that detects the charset of a file.
  #              See EncodingUtils.
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/mime.rb#46
  def register_mime_type(mime_type, extensions: T.unsafe(nil), charset: T.unsafe(nil)); end
end

class Sprockets::NotFound < ::Sprockets::Error; end
class Sprockets::NotImplementedError < ::Sprockets::Error; end

module Sprockets::Npm
  # Internal: Read package.json's main and style directives.
  #
  # dirname  - String path to component directory.
  # filename - String path to package.json.
  #
  # Returns nothing.
  #
  # @yield [File.expand_path(package['style'], dirname)]
  #
  # source://sprockets//lib/sprockets/npm.rb#39
  def read_package_directives(dirname, filename); end

  # Internal: Override resolve_alternates to install package.json behavior.
  #
  # load_path    - String environment path
  # logical_path - String path relative to base
  #
  # Returns candidate filenames.
  #
  # source://sprockets//lib/sprockets/npm.rb#12
  def resolve_alternates(load_path, logical_path); end
end

# Internal: Related PathUtils helpers that also track all the file system
# calls they make for caching purposes. All functions return a standard
# return value and a Set of cache dependency URIs that can be used in the
# future to see if the returned value should be invalidated from cache.
#
#     entries_with_dependencies("app/assets/javascripts")
#     # => [
#     #   ["application.js", "projects.js", "users.js", ...]
#     #    #<Set: {"file-digest:/path/to/app/assets/javascripts"}>
#     # ]
#
# The returned dependency set can be passed to resolve_dependencies(deps)
# to check if the returned result is still fresh. In this case, entry always
# returns a single path, but multiple calls should accumulate dependencies
# into a single set thats saved off and checked later.
#
#     resolve_dependencies(deps)
#     # => "\x01\x02\x03"
#
# Later, resolving the same set again will produce a different hash if
# something on the file system has changed.
#
#     resolve_dependencies(deps)
#     # => "\x03\x04\x05"
module Sprockets::PathDependencyUtils
  include ::Sprockets::PathUtils
  include ::Sprockets::URIUtils

  # Internal: List directory entries and return a set of dependencies that
  # would invalid the cached return result.
  #
  # See PathUtils#entries
  #
  # path - String directory path
  #
  # Returns an Array of entry names and a Set of dependency URIs.
  #
  # source://sprockets//lib/sprockets/path_dependency_utils.rb#44
  def entries_with_dependencies(path); end

  # Internal: List directory filenames and associated Stats under a
  # directory.
  #
  # See PathUtils#stat_directory
  #
  # dir - A String directory
  #
  # Returns an Array of filenames and a Set of dependency URIs.
  #
  # source://sprockets//lib/sprockets/path_dependency_utils.rb#56
  def stat_directory_with_dependencies(dir); end

  # Internal: List directory filenames and associated Stats under an entire
  # directory tree.
  #
  # See PathUtils#stat_sorted_tree
  #
  # dir - A String directory
  #
  # Returns an Array of filenames and a Set of dependency URIs.
  #
  # source://sprockets//lib/sprockets/path_dependency_utils.rb#68
  def stat_sorted_tree_with_dependencies(dir); end
end

# Internal: Crossover of path and digest utilities functions.
module Sprockets::PathDigestUtils
  include ::Sprockets::PathUtils
  include ::Sprockets::DigestUtils

  # Internal: Compute digest for path.
  #
  # path - String filename or directory path.
  #
  # Returns String digest bytes or nil.
  #
  # source://sprockets//lib/sprockets/path_digest_utils.rb#33
  def file_digest(path); end

  # Internal: Compute digest for a set of paths.
  #
  # paths - Array of filename or directory paths.
  #
  # Returns String digest bytes.
  #
  # source://sprockets//lib/sprockets/path_digest_utils.rb#44
  def files_digest(paths); end

  # Internal: Compute digest for file stat.
  #
  # path - String filename
  # stat - File::Stat
  #
  # Returns String digest bytes.
  #
  # source://sprockets//lib/sprockets/path_digest_utils.rb#16
  def stat_digest(path, stat); end
end

# Internal: File and path related utilities. Mixed into Environment.
#
# Probably would be called FileUtils, but that causes namespace annoyances
# when code actually wants to reference ::FileUtils.
module Sprockets::PathUtils
  extend ::Sprockets::PathUtils

  # On Windows, ALT_SEPARATOR is \
  # Delegate to Pathname since the logic gets complex.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/path_utils.rb#83
  def absolute_path?(path); end

  # Public: Write to a file atomically. Useful for situations where you
  # don't want other processes or threads to see half-written files.
  #
  #   Utils.atomic_write('important.file') do |file|
  #     file.write('hello')
  #   end
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#348
  def atomic_write(filename); end

  # Public: Like `File.directory?`.
  #
  # path - String file path.
  #
  # Returns true path exists and is a directory.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/path_utils.rb#42
  def directory?(path); end

  # Public: A version of `Dir.entries` that filters out `.` files and `~`
  # swap files.
  #
  # path - String directory path
  #
  # Returns an empty `Array` if the directory does not exist.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#56
  def entries(path); end

  # Public: Like `File.file?`.
  #
  # path - String file path.
  #
  # Returns true path exists and is a file.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/path_utils.rb#29
  def file?(path); end

  # Internal: Match paths in a directory against available extensions.
  #
  # path       - String directory
  # basename   - String basename of target file
  # extensions - Hash of String extnames to values
  #
  # Examples
  #
  #     exts = { ".js" => "application/javascript" }
  #     find_matching_path_for_extensions("app/assets", "application", exts)
  #     # => ["app/assets/application.js", "application/javascript"]
  #
  # Returns an Array of [String path, Object value] matches.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#231
  def find_matching_path_for_extensions(path, basename, extensions); end

  # Internal: Find target basename checking upwards from path.
  #
  # basename - String filename: ".sprocketsrc"
  # path     - String path to start search: "app/assets/javascripts/app.js"
  # root     - String path to stop at (default: system root)
  #
  # Returns String filename or nil.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#273
  def find_upwards(basename, path, root = T.unsafe(nil)); end

  # Public: Joins path to base path.
  #
  # base - Root path
  # path - Extending path
  #
  # Example
  #
  #     join('base/path/', '../file.js')
  #     # => 'base/file.js'
  #
  # Returns string path starting from base and ending at path
  #
  # source://sprockets//lib/sprockets/path_utils.rb#127
  def join(base, path); end

  # Internal: Match path extnames against available extensions.
  #
  # path       - String
  # extensions - Hash of String extnames to values
  #
  # Returns [String extname, Object value] or nil nothing matched.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#202
  def match_path_extname(path, extensions); end

  # Internal: Get path's extensions.
  #
  # path - String
  #
  # Returns an Array of String extnames.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#192
  def path_extnames(path); end

  # Internal: Returns all parents for path
  #
  # path - String absolute filename or directory
  # root - String path to stop at (default: system root)
  #
  # Returns an Array of String paths.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#252
  def path_parents(path, root = T.unsafe(nil)); end

  # Internal: Detect root path and base for file in a set of paths.
  #
  # paths    - Array of String paths
  # filename - String path of file expected to be in one of the paths.
  #
  # Returns [String root, String path]
  #
  # source://sprockets//lib/sprockets/path_utils.rb#178
  def paths_split(paths, filename); end

  # Public: Check if path is explicitly relative.
  # Starts with "./" or "../".
  #
  # path - String path.
  #
  # Returns true if path is relative, otherwise false.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/path_utils.rb#100
  def relative_path?(path); end

  # Public: Get relative path from `start` to `dest`.
  #
  # start - String start path (file or dir)
  # dest  - String destination path
  #
  # Returns relative String path from `start` to `dest`
  #
  # source://sprockets//lib/sprockets/path_utils.rb#110
  def relative_path_from(start, dest); end

  # Public: Sets pipeline for path
  #
  # path       - String path
  # extensions - List of file extensions
  # pipeline   - Pipeline
  #
  # Examples
  #
  #     set_pipeline('path/file.js.erb', config[:mime_exts], config[:pipeline_exts], :source)
  #     # => 'path/file.source.js.erb'
  #
  #     set_pipeline('path/some.file.source.js.erb', config[:mime_exts], config[:pipeline_exts], :debug)
  #     # => 'path/some.file.debug.js.erb'
  #
  # Returns string path with pipeline parsed in
  #
  # source://sprockets//lib/sprockets/path_utils.rb#146
  def set_pipeline(path, mime_exts, pipeline_exts, pipeline); end

  # Internal: Get relative path for root path and subpath.
  #
  # path    - String path
  # subpath - String subpath of path
  #
  # Returns relative String path if subpath is a subpath of path, or nil if
  # subpath is outside of path.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#162
  def split_subpath(path, subpath); end

  # Public: Like `File.stat`.
  #
  # path - String file or directory path
  #
  # Returns nil if the file does not exist.
  #
  # source://sprockets//lib/sprockets/path_utils.rb#16
  def stat(path); end

  # Public: Stat all the files under a directory.
  #
  # dir - A String directory
  #
  # Returns an Enumerator of [path, stat].
  #
  # source://sprockets//lib/sprockets/path_utils.rb#286
  def stat_directory(dir); end

  # Public: Recursive stat all the files under a directory in alphabetical
  # order.
  #
  # dir - A String directory
  #
  # Returns an Enumerator of [path, stat].
  #
  # source://sprockets//lib/sprockets/path_utils.rb#324
  def stat_sorted_tree(dir, &block); end

  # Public: Recursive stat all the files under a directory.
  #
  # dir - A String directory
  #
  # Returns an Enumerator of [path, stat].
  #
  # source://sprockets//lib/sprockets/path_utils.rb#304
  def stat_tree(dir, &block); end
end

# source://sprockets//lib/sprockets/path_utils.rb#91
Sprockets::PathUtils::SEPARATOR_PATTERN = T.let(T.unsafe(nil), String)

module Sprockets::Paths
  include ::Sprockets::Utils
  include ::Sprockets::PathUtils

  # Append a `path` to the `paths` list.
  #
  # Paths at the beginning of the `Array` have a higher priority.
  #
  # source://sprockets//lib/sprockets/paths.rb#47
  def append_path(path); end

  # Clear all paths and start fresh.
  #
  # There is no mechanism for reordering paths, so its best to
  # completely wipe the paths list and reappend them in the order
  # you want.
  #
  # source://sprockets//lib/sprockets/paths.rb#59
  def clear_paths; end

  # Public: Iterate over every file under all load paths.
  #
  # Returns Enumerator if no block is given.
  #
  # source://sprockets//lib/sprockets/paths.rb#68
  def each_file; end

  # Returns an `Array` of path `String`s.
  #
  # These paths will be used for asset logical path lookups.
  #
  # source://sprockets//lib/sprockets/paths.rb#30
  def paths; end

  # Prepend a `path` to the `paths` list.
  #
  # Paths at the end of the `Array` have the least priority.
  #
  # source://sprockets//lib/sprockets/paths.rb#37
  def prepend_path(path); end

  # Returns `Environment` root.
  #
  # All relative paths are expanded with root as its base. To be
  # useful set this to your applications root directory. (`Rails.root`)
  #
  # source://sprockets//lib/sprockets/paths.rb#13
  def root; end

  private

  # Internal: Change Environment root.
  #
  # Only the initializer should change the root.
  #
  # source://sprockets//lib/sprockets/paths.rb#20
  def root=(path); end
end

module Sprockets::Preprocessors; end

# Private: Adds a default map to assets when one is not present
#
# If the input file already has a source map, it effectively returns the original
# result. Otherwise it maps 1 for 1 lines original to generated. This is needed
# Because other generators run after might depend on having a valid source map
# available.
class Sprockets::Preprocessors::DefaultSourceMap
  # source://sprockets//lib/sprockets/preprocessors/default_source_map.rb#11
  def call(input); end

  private

  # source://sprockets//lib/sprockets/preprocessors/default_source_map.rb#38
  def default_mappings(lines); end
end

# `Processing` is an internal mixin whose public methods are exposed on
# the `Environment` and `CachedEnvironment` classes.
module Sprockets::Processing
  include ::Sprockets::Utils
  include ::Sprockets::URIUtils
  include ::Sprockets::ProcessorUtils

  # Bundle Processors are ran on concatenated assets rather than
  # individual files.
  #
  # source://sprockets//lib/sprockets/processing.rb#95
  def bundle_processors; end

  # source://sprockets//lib/sprockets/processing.rb#14
  def pipelines; end

  # Postprocessors are ran after Preprocessors and Engine processors.
  #
  # source://sprockets//lib/sprockets/processing.rb#39
  def postprocessors; end

  # Preprocessors are ran before Postprocessors and Engine
  # processors.
  #
  # source://sprockets//lib/sprockets/processing.rb#33
  def preprocessors; end

  # Preprocessors are ran before Postprocessors and Engine
  # processors.
  #
  # source://sprockets//lib/sprockets/processing.rb#33
  def processors; end

  # Public: Register bundle metadata reducer function.
  #
  # Examples
  #
  #   Sprockets.register_bundle_metadata_reducer 'application/javascript', :jshint_errors, [], :+
  #
  #   Sprockets.register_bundle_metadata_reducer 'text/css', :selector_count, 0 { |total, count|
  #     total + count
  #   }
  #
  # mime_type - String MIME Type. Use '*/*' applies to all types.
  # key       - Symbol metadata key
  # initial   - Initial memo to pass to the reduce function (default: nil)
  # block     - Proc accepting the memo accumulator and current value
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/processing.rb#137
  def register_bundle_metadata_reducer(mime_type, key, *args, &block); end

  # Registers a new Bundle Processor `klass` for `mime_type`.
  #
  #     register_bundle_processor  'application/javascript', Sprockets::DirectiveProcessor
  #
  # A block can be passed for to create a shorthand processor.
  #
  #     register_bundle_processor 'application/javascript' do |input|
  #       input[:data].gsub(...)
  #     end
  #
  # source://sprockets//lib/sprockets/processing.rb#109
  def register_bundle_processor(*args, &block); end

  # Registers a pipeline that will be called by `call_processor` method.
  #
  # source://sprockets//lib/sprockets/processing.rb#19
  def register_pipeline(name, proc = T.unsafe(nil), &block); end

  # Registers a new Postprocessor `klass` for `mime_type`.
  #
  #     register_postprocessor 'application/javascript', Sprockets::DirectiveProcessor
  #
  # A block can be passed for to create a shorthand processor.
  #
  #     register_postprocessor 'application/javascript' do |input|
  #       input[:data].gsub(...)
  #     end
  #
  # source://sprockets//lib/sprockets/processing.rb#69
  def register_postprocessor(*args, &block); end

  # Registers a new Preprocessor `klass` for `mime_type`.
  #
  #     register_preprocessor 'text/css', Sprockets::DirectiveProcessor
  #
  # A block can be passed for to create a shorthand processor.
  #
  #     register_preprocessor 'text/css' do |input|
  #       input[:data].gsub(...)
  #     end
  #
  # source://sprockets//lib/sprockets/processing.rb#53
  def register_preprocessor(*args, &block); end

  # Registers a new Preprocessor `klass` for `mime_type`.
  #
  #     register_preprocessor 'text/css', Sprockets::DirectiveProcessor
  #
  # A block can be passed for to create a shorthand processor.
  #
  #     register_preprocessor 'text/css' do |input|
  #       input[:data].gsub(...)
  #     end
  #
  # source://sprockets//lib/sprockets/processing.rb#53
  def register_processor(*args, &block); end

  # Remove Bundle Processor `klass` for `mime_type`.
  #
  #     unregister_bundle_processor 'application/javascript', Sprockets::DirectiveProcessor
  #
  # source://sprockets//lib/sprockets/processing.rb#117
  def unregister_bundle_processor(*args); end

  # Remove Postprocessor `klass` for `mime_type`.
  #
  #     unregister_postprocessor 'text/css', Sprockets::DirectiveProcessor
  #
  # source://sprockets//lib/sprockets/processing.rb#88
  def unregister_postprocessor(*args); end

  # Remove Preprocessor `klass` for `mime_type`.
  #
  #     unregister_preprocessor 'text/css', Sprockets::DirectiveProcessor
  #
  # source://sprockets//lib/sprockets/processing.rb#78
  def unregister_preprocessor(*args); end

  # Remove Preprocessor `klass` for `mime_type`.
  #
  #     unregister_preprocessor 'text/css', Sprockets::DirectiveProcessor
  #
  # source://sprockets//lib/sprockets/processing.rb#78
  def unregister_processor(*args); end

  protected

  # source://sprockets//lib/sprockets/processing.rb#168
  def build_processors_uri(type, file_type, pipeline); end

  # source://sprockets//lib/sprockets/processing.rb#186
  def default_processors_for(type, file_type); end

  # source://sprockets//lib/sprockets/processing.rb#177
  def processors_for(type, file_type, pipeline); end

  # source://sprockets//lib/sprockets/processing.rb#162
  def resolve_processors_cache_key_uri(uri); end

  # source://sprockets//lib/sprockets/processing.rb#195
  def self_processors_for(type, file_type); end

  private

  # source://sprockets//lib/sprockets/processing.rb#212
  def register_config_processor(type, mime_type, processor = T.unsafe(nil), &block); end

  # source://sprockets//lib/sprockets/processing.rb#221
  def unregister_config_processor(type, mime_type, processor); end
end

# Functional utilities for dealing with Processor functions.
#
# A Processor is a general function that may modify or transform an asset as
# part of the pipeline. CoffeeScript to JavaScript conversion, Minification
# or Concatenation are all implemented as separate Processor steps.
#
# Processors maybe any object that responds to call. So procs or a class that
# defines a self.call method.
#
# For ergonomics, processors may return a number of shorthand values.
# Unfortunately, this means that processors can not compose via ordinary
# function composition. The composition helpers here can help.
module Sprockets::ProcessorUtils
  extend ::Sprockets::ProcessorUtils

  # Public: Invoke processor.
  #
  # processor - Processor callables
  # input - Hash of input data to pass to processor
  #
  # Returns a Hash with :data and other processor metadata key/values.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#80
  def call_processor(processor, input); end

  # Public: Invoke list of processors in right to left order.
  #
  # The right to left order processing mirrors standard function composition.
  # Think about:
  #
  #   bundle.call(uglify.call(coffee.call(input)))
  #
  # processors - Array of processor callables
  # input - Hash of input data to pass to each processor
  #
  # Returns a Hash with :data and other processor metadata key/values.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#61
  def call_processors(processors, input); end

  # Public: Compose processors in right to left order.
  #
  # processors - Array of processors callables
  #
  # Returns a composed Proc.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#46
  def compose_processors(*processors); end

  # Internal: Get processor defined cached key.
  #
  # processor - Processor function
  #
  # Returns JSON serializable key or nil.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#101
  def processor_cache_key(processor); end

  # Internal: Get combined cache keys for set of processors.
  #
  # processors - Array of processor functions
  #
  # Returns Array of JSON serializable keys.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#110
  def processors_cache_keys(processors); end

  # Internal: Validate returned result of calling a processor pipeline and
  # raise a friendly user error message.
  #
  # result - Metadata Hash returned from call_processors
  #
  # Returns result or raises a TypeError.
  #
  # source://sprockets//lib/sprockets/processor_utils.rb#152
  def validate_processor_result!(result); end
end

class Sprockets::ProcessorUtils::CompositeProcessor < ::Struct
  # source://sprockets//lib/sprockets/processor_utils.rb#36
  def cache_key; end

  # source://sprockets//lib/sprockets/processor_utils.rb#32
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/processor_utils.rb#24
    def create(processors); end
  end
end

# source://sprockets//lib/sprockets/processor_utils.rb#22
Sprockets::ProcessorUtils::CompositeProcessor::PLURAL = T.let(T.unsafe(nil), Proc)

# source://sprockets//lib/sprockets/processor_utils.rb#21
Sprockets::ProcessorUtils::CompositeProcessor::SINGULAR = T.let(T.unsafe(nil), Proc)

# Internal: Set of all nested compound metadata types that can nest values.
#
# source://sprockets//lib/sprockets/processor_utils.rb#126
Sprockets::ProcessorUtils::VALID_METADATA_COMPOUND_TYPES = T.let(T.unsafe(nil), Set)

# Internal: Hash of all nested compound metadata types that can nest values.
#
# source://sprockets//lib/sprockets/processor_utils.rb#139
Sprockets::ProcessorUtils::VALID_METADATA_COMPOUND_TYPES_HASH = T.let(T.unsafe(nil), Hash)

# Internal: Set of all allowed metadata types.
#
# source://sprockets//lib/sprockets/processor_utils.rb#144
Sprockets::ProcessorUtils::VALID_METADATA_TYPES = T.let(T.unsafe(nil), Set)

# Internal: Set of all "simple" value types allowed to be returned in
# processor metadata.
#
# source://sprockets//lib/sprockets/processor_utils.rb#116
Sprockets::ProcessorUtils::VALID_METADATA_VALUE_TYPES = T.let(T.unsafe(nil), Set)

# Internal: Hash of all "simple" value types allowed to be returned in
# processor metadata.
#
# source://sprockets//lib/sprockets/processor_utils.rb#134
Sprockets::ProcessorUtils::VALID_METADATA_VALUE_TYPES_HASH = T.let(T.unsafe(nil), Hash)

module Sprockets::Resolve
  include ::Sprockets::PathUtils
  include ::Sprockets::URIUtils
  include ::Sprockets::PathDependencyUtils
  include ::Sprockets::HTTPUtils

  # Public: Find Asset URI for given a logical path by searching the
  # environment's load paths.
  #
  #     resolve("application.js")
  #     # => "file:///path/to/app/javascripts/application.js?type=application/javascript"
  #
  # An accept content type can be given if the logical path doesn't have a
  # format extension.
  #
  #     resolve("application", accept: "application/javascript")
  #     # => "file:///path/to/app/javascripts/application.coffee?type=application/javascript"
  #
  # The String Asset URI is returned or nil if no results are found.
  #
  # source://sprockets//lib/sprockets/resolve.rb#24
  def resolve(path, load_paths: T.unsafe(nil), accept: T.unsafe(nil), pipeline: T.unsafe(nil), base_path: T.unsafe(nil)); end

  # Public: Same as resolve() but raises a FileNotFound exception instead of
  # nil if no assets are found.
  #
  # source://sprockets//lib/sprockets/resolve.rb#46
  def resolve!(path, **kargs); end

  protected

  # Internal: Converts mimetype into accept Array
  #
  # - mime_type     - String, optional. e.g. "text/html"
  # - explicit_type - String, optional. e.g. "application/javascript"
  #
  # When called with an explicit_type and a mime_type, only a mime_type
  # that matches the given explicit_type will be accepted.
  #
  # Returns Array of Array
  #
  #     [["application/javascript", 1.0]]
  #     [["*/*", 1.0]]
  #     []
  #
  # source://sprockets//lib/sprockets/resolve.rb#279
  def parse_accept_options(mime_type, explicit_type); end

  # Internal: Finds a file in a set of given paths
  #
  # paths    - Array of Strings.
  # filename - String containing absolute path to a file including extension.
  #            e.g. "/Users/schneems/sprockets/test/fixtures/asset/application.js"
  # accept   - String. A Quality value incoded set of
  #            mime types that we are looking for. Can be nil.
  #            e.g. "application/javascript" or "text/css, */*"
  #
  # Returns Array. Filename, type, path_pipeline, deps, index_alias
  #
  # source://sprockets//lib/sprockets/resolve.rb#92
  def resolve_absolute_path(paths, filename, accept); end

  # source://sprockets//lib/sprockets/resolve.rb#291
  def resolve_alternates(load_path, logical_name); end

  # source://sprockets//lib/sprockets/resolve.rb#257
  def resolve_alts_under_path(load_path, logical_name, mime_exts); end

  # Internal: Finds an asset given a URI
  #
  # uri - String. Contains file:// scheme, absolute path to
  #       file.
  #       e.g. "file:///Users/schneems/sprockets/test/fixtures/default/gallery.js?type=application/javascript"
  #
  # Returns Array. Contains a String uri and Set of dependencies
  #
  # source://sprockets//lib/sprockets/resolve.rb#77
  def resolve_asset_uri(uri); end

  # Internal: Finds candidate index files in a given path
  #
  # load_path    - String. An absolute path to a directory
  # logical_name - String. A filename without extension
  #                e.g. "application" or "coffee/foo"
  # mime_exts    - Hash of file extensions and their mime types
  #                e.g. {".xml.builder"=>"application/xml+builder"}
  #
  # Looking in the given `load_path` this method will find all files under the `logical_name` directory
  # that are named `index` and have a matching mime type in `mime_exts`.
  #
  # Returns Array. First element is an Array of hashes or empty, second is a String
  #
  # source://sprockets//lib/sprockets/resolve.rb#239
  def resolve_index_under_path(load_path, logical_name, mime_exts); end

  # Internal: Finds a file in a set of given paths
  #
  # paths        - Array of Strings.
  # logical_path - String. A filename with extension
  #                e.g. "coffee/foo.js" or "foo.js"
  # accept       - String. A Quality value incoded set of
  #                mime types that we are looking for. Can be nil.
  #                e.g. "application/javascript" or "text/css, */*"
  #
  # Finds a file on the given paths.
  #
  # Returns Array. Filename, type, path_pipeline, deps, index_alias
  #
  # source://sprockets//lib/sprockets/resolve.rb#142
  def resolve_logical_path(paths, logical_path, accept); end

  # Internal: Finds candidate files on a given path
  #
  # load_path    - String. An absolute path to a directory
  # logical_name - String. A filename without extension
  #                e.g. "application" or "coffee/foo"
  # mime_exts    - Hash of file extensions and their mime types
  #                e.g. {".xml.builder"=>"application/xml+builder"}
  #
  # Finds files that match a given `logical_name` with an acceptable
  # mime type that is included in `mime_exts` on the `load_path`.
  #
  # Returns Array. First element is an Array of hashes or empty, second is a String
  #
  # source://sprockets//lib/sprockets/resolve.rb#217
  def resolve_main_under_path(load_path, logical_name, mime_exts); end

  # Internal: Finds a relative file in a set of given paths
  #
  # paths   - Array of Strings.
  # path    - String. A relative filename with or without extension
  #           e.g. "./jquery" or "../foo.js"
  # dirname - String. Base path where we start looking for the given file.
  # accept  - String. A Quality value incoded set of
  #           mime types that we are looking for. Can be nil.
  #           e.g. "application/javascript" or "text/css, */*"
  #
  # Returns Array. Filename, type, path_pipeline, deps, index_alias
  #
  # source://sprockets//lib/sprockets/resolve.rb#120
  def resolve_relative_path(paths, path, dirname, accept); end

  # Internal: Finds a file in a set of given paths
  #
  # paths        - Array of Strings.
  # logical_name - String. A filename without extension
  #                e.g. "application" or "coffee/foo"
  # accepts      - Array of array containing mime/version pairs
  #                e.g. [["application/javascript", 1.0]]
  #
  # Finds a file with the same name as `logical_name` or "index" inside
  # of the `logical_name` directory that matches a valid mime-type/version from
  # `accepts`.
  #
  # Returns Array. Filename, type, dependencies, and index_alias
  #
  # source://sprockets//lib/sprockets/resolve.rb#176
  def resolve_under_paths(paths, logical_name, accepts); end
end

# Public: Sass CSS minifier.
#
# To accept the default options
#
#     environment.register_bundle_processor 'text/css',
#       Sprockets::SassCompressor
#
# Or to pass options to the Sass::Engine class.
#
#     environment.register_bundle_processor 'text/css',
#       Sprockets::SassCompressor.new({ ... })
class Sprockets::SassCompressor
  # @return [SassCompressor] a new instance of SassCompressor
  #
  # source://sassc-rails/2.1.2/lib/sassc/rails/compressor.rb#7
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/sass_compressor.rb#37
  def cache_key; end

  # source://sassc-rails/2.1.2/lib/sassc/rails/compressor.rb#17
  def call(*args); end

  # sprockets 2.x
  #
  # source://sassc-rails/2.1.2/lib/sassc/rails/compressor.rb#17
  def evaluate(*args); end

  class << self
    # source://sprockets//lib/sprockets/sass_compressor.rb#33
    def cache_key; end

    # source://sprockets//lib/sprockets/sass_compressor.rb#29
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns SassCompressor object.
    #
    # source://sprockets//lib/sprockets/sass_compressor.rb#25
    def instance; end
  end
end

# source://sprockets//lib/sprockets/sass_compressor.rb#20
Sprockets::SassCompressor::VERSION = T.let(T.unsafe(nil), String)

# source://sprockets//lib/sprockets/sass_processor.rb#312
Sprockets::SassFunctions = Sprockets::SassProcessor::Functions

# Processor engine class for the SASS/SCSS compiler. Depends on the `sass` gem.
#
# For more information see:
#
#   https://github.com/sass/sass
#   https://github.com/rails/sass-rails
class Sprockets::SassProcessor
  # Public: Initialize template with custom options.
  #
  # options - Hash
  # cache_version - String custom cache version. Used to force a cache
  #                 change after code changes are made to Sass Functions.
  #
  # @return [SassProcessor] a new instance of SassProcessor
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#47
  def initialize(options = T.unsafe(nil), &block); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#39
  def cache_key; end

  # source://sprockets//lib/sprockets/sass_processor.rb#59
  def call(input); end

  private

  # Public: Build the cache store to be used by the Sass engine.
  #
  # input - the input hash.
  # version - the cache version.
  #
  # Override this method if you need to use a different cache than the
  # Sprockets cache.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#105
  def build_cache_store(input, version); end

  # source://sprockets//lib/sprockets/sass_processor.rb#109
  def merge_options(options); end

  class << self
    # source://sprockets//lib/sprockets/sass_processor.rb#35
    def cache_key; end

    # source://sprockets//lib/sprockets/sass_processor.rb#31
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns SassProcessor object.
    #
    # source://sprockets//lib/sprockets/sass_processor.rb#27
    def instance; end

    # Internal: Defines default sass syntax to use. Exposed so the ScssProcessor
    # may override it.
    #
    # source://sprockets//lib/sprockets/sass_processor.rb#20
    def syntax; end
  end
end

# Public: Functions injected into Sass context during Sprockets evaluation.
#
# This module may be extended to add global functionality to all Sprockets
# Sass environments. Though, scoping your functions to just your environment
# is preferred.
#
# module Sprockets::SassProcessor::Functions
#   def asset_path(path, options = {})
#   end
# end
module Sprockets::SassProcessor::Functions
  # Public: Generate a data URI for asset path.
  #
  # path - Sass::Script::String logical asset path
  #
  # Returns a Sass::Script::String.
  #
  # source://sassc-rails/2.1.2/lib/sassc/rails/functions.rb#7
  def asset_data_url(path); end

  # Public: Generate a url for asset path.
  #
  # Default implementation is deprecated. Currently defaults to
  # Context#asset_path.
  #
  # Will raise NotImplementedError in the future. Users should provide their
  # own base implementation.
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#141
  def asset_path(path, options = T.unsafe(nil)); end

  # Public: Generate a asset url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#157
  def asset_url(path, options = T.unsafe(nil)); end

  # Public: Generate url for audio path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#202
  def audio_path(path); end

  # Public: Generate a audio url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#211
  def audio_url(path); end

  # Public: Generate url for font path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#220
  def font_path(path); end

  # Public: Generate a font url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#229
  def font_url(path); end

  # Public: Generate url for image path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#166
  def image_path(path); end

  # Public: Generate a image url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#175
  def image_url(path); end

  # Public: Generate url for javascript path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#238
  def javascript_path(path); end

  # Public: Generate a javascript url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#247
  def javascript_url(path); end

  # Public: Generate url for stylesheet path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#256
  def stylesheet_path(path); end

  # Public: Generate a stylesheet url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#265
  def stylesheet_url(path); end

  # Public: Generate url for video path.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#184
  def video_path(path); end

  # Public: Generate a video url() link.
  #
  # path - Sass::Script::String URL path
  #
  # Returns a Sass::Script::String.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#193
  def video_url(path); end

  protected

  # Deprecated: Get the Context instance. Use APIs on
  # sprockets_environment or sprockets_dependencies directly.
  #
  # Returns a Context instance.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#298
  def sprockets_context; end

  # Public: Mutatable set of dependencies.
  #
  # Returns a Set.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#290
  def sprockets_dependencies; end

  # Public: The Environment.
  #
  # Returns Sprockets::Environment.
  #
  # source://sprockets//lib/sprockets/sass_processor.rb#283
  def sprockets_environment; end
end

# Public: Sass CSS minifier.
#
# To accept the default options
#
#     environment.register_bundle_processor 'text/css',
#       Sprockets::SasscCompressor
#
# Or to pass options to the Sass::Engine class.
#
#     environment.register_bundle_processor 'text/css',
#       Sprockets::SasscCompressor.new({ ... })
class Sprockets::SasscCompressor
  # @return [SasscCompressor] a new instance of SasscCompressor
  #
  # source://sprockets//lib/sprockets/sassc_compressor.rb#30
  def initialize(options = T.unsafe(nil)); end

  # source://sprockets//lib/sprockets/sassc_compressor.rb#39
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/sassc_compressor.rb#26
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns SasscCompressor object.
    #
    # source://sprockets//lib/sprockets/sassc_compressor.rb#22
    def instance; end
  end
end

# Processor engine class for the SASS/SCSS compiler. Depends on the `sassc` gem.
#
# For more information see:
#
#   https://github.com/sass/sassc-ruby
#   https://github.com/sass/sassc-rails
class Sprockets::SasscProcessor
  # @return [SasscProcessor] a new instance of SasscProcessor
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#40
  def initialize(options = T.unsafe(nil), &block); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#38
  def cache_key; end

  # source://sprockets//lib/sprockets/sassc_processor.rb#52
  def call(input); end

  private

  # source://sprockets//lib/sprockets/sassc_processor.rb#273
  def engine_options(input, context); end

  # source://sprockets//lib/sprockets/sassc_processor.rb#78
  def merge_options(options); end

  class << self
    # source://sprockets//lib/sprockets/sassc_processor.rb#34
    def cache_key; end

    # source://sprockets//lib/sprockets/sassc_processor.rb#30
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns SasscProcessor object.
    #
    # source://sprockets//lib/sprockets/sassc_processor.rb#26
    def instance; end

    # Internal: Defines default sass syntax to use. Exposed so the ScsscProcessor
    # may override it.
    #
    # source://sprockets//lib/sprockets/sassc_processor.rb#19
    def syntax; end
  end
end

# Public: Functions injected into Sass context during Sprockets evaluation.
#
# This module may be extended to add global functionality to all Sprockets
# Sass environments. Though, scoping your functions to just your environment
# is preferred.
#
# module Sprockets::SasscProcessor::Functions
#   def asset_path(path, options = {})
#   end
# end
module Sprockets::SasscProcessor::Functions
  # Public: Generate a data URI for asset path.
  #
  # path - SassC::Script::Value::String logical asset path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#243
  def asset_data_url(path); end

  # Public: Generate a url for asset path.
  #
  # Default implementation is deprecated. Currently defaults to
  # Context#asset_path.
  #
  # Will raise NotImplementedError in the future. Users should provide their
  # own base implementation.
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#110
  def asset_path(path, options = T.unsafe(nil)); end

  # Public: Generate a asset url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#126
  def asset_url(path, options = T.unsafe(nil)); end

  # Public: Generate url for audio path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#171
  def audio_path(path); end

  # Public: Generate a audio url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#180
  def audio_url(path); end

  # Public: Generate url for font path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#189
  def font_path(path); end

  # Public: Generate a font url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#198
  def font_url(path); end

  # Public: Generate url for image path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#135
  def image_path(path); end

  # Public: Generate a image url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#144
  def image_url(path); end

  # Public: Generate url for javascript path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#207
  def javascript_path(path); end

  # Public: Generate a javascript url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#216
  def javascript_url(path); end

  # Public: Generate url for stylesheet path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#225
  def stylesheet_path(path); end

  # Public: Generate a stylesheet url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#234
  def stylesheet_url(path); end

  # Public: Generate url for video path.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#153
  def video_path(path); end

  # Public: Generate a video url() link.
  #
  # path - SassC::Script::Value::String URL path
  #
  # Returns a SassC::Script::Value::String.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#162
  def video_url(path); end

  protected

  # Deprecated: Get the Context instance. Use APIs on
  # sprockets_environment or sprockets_dependencies directly.
  #
  # Returns a Context instance.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#267
  def sprockets_context; end

  # Public: Mutatable set of dependencies.
  #
  # Returns a Set.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#259
  def sprockets_dependencies; end

  # Public: The Environment.
  #
  # Returns Sprockets::Environment.
  #
  # source://sprockets//lib/sprockets/sassc_processor.rb#252
  def sprockets_environment; end
end

class Sprockets::ScssProcessor < ::Sprockets::SassProcessor
  class << self
    # source://sprockets//lib/sprockets/sass_processor.rb#306
    def syntax; end
  end
end

class Sprockets::ScsscProcessor < ::Sprockets::SasscProcessor
  class << self
    # source://sprockets//lib/sprockets/sassc_processor.rb#293
    def syntax; end
  end
end

# `Server` is a concern mixed into `Environment` and
# `CachedEnvironment` that provides a Rack compatible `call`
# interface and url generation helpers.
module Sprockets::Server
  # `call` implements the Rack 1.x specification which accepts an
  # `env` Hash and returns a three item tuple with the status code,
  # headers, and body.
  #
  # Mapping your environment at a url prefix will serve all assets
  # in the path.
  #
  #     map "/assets" do
  #       run Sprockets::Environment.new
  #     end
  #
  # A request for `"/assets/foo/bar.js"` will search your
  # environment for `"foo/bar.js"`.
  #
  # source://sprockets//lib/sprockets/server.rb#27
  def call(env); end

  private

  # Returns a 400 Forbidden response tuple
  #
  # source://sprockets//lib/sprockets/server.rb#149
  def bad_request_response(env); end

  # source://sprockets//lib/sprockets/server.rb#257
  def cache_headers(env, etag); end

  # Returns a CSS response that hides all elements on the page and
  # displays the exception
  #
  # source://sprockets//lib/sprockets/server.rb#197
  def css_exception_response(exception); end

  # Escape special characters for use inside a CSS content("...") string
  #
  # source://sprockets//lib/sprockets/server.rb#249
  def escape_css_content(content); end

  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/server.rb#122
  def forbidden_request?(path); end

  # Returns a 403 Forbidden response tuple
  #
  # source://sprockets//lib/sprockets/server.rb#158
  def forbidden_response(env); end

  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/server.rb#130
  def head_request?(env); end

  # source://sprockets//lib/sprockets/server.rb#278
  def headers(env, asset, length); end

  # Returns a JavaScript response that re-throws a Ruby exception
  # in the browser
  #
  # source://sprockets//lib/sprockets/server.rb#189
  def javascript_exception_response(exception); end

  # source://sprockets//lib/sprockets/server.rb#175
  def method_not_allowed_response; end

  # Returns a 404 Not Found response tuple
  #
  # source://sprockets//lib/sprockets/server.rb#167
  def not_found_response(env); end

  # Returns a 304 Not Modified response tuple
  #
  # source://sprockets//lib/sprockets/server.rb#144
  def not_modified_response(env, etag); end

  # Returns a 200 OK response tuple
  #
  # source://sprockets//lib/sprockets/server.rb#135
  def ok_response(asset, env); end

  # Gets ETag fingerprint.
  #
  #     "foo-0aa2105d29558f3eb790d411d7d8fb66.js"
  #     # => "0aa2105d29558f3eb790d411d7d8fb66"
  #
  # source://sprockets//lib/sprockets/server.rb#301
  def path_fingerprint(path); end

  # source://sprockets//lib/sprockets/server.rb#179
  def precondition_failed_response(env); end
end

# Supported HTTP request methods.
#
# source://sprockets//lib/sprockets/server.rb#12
Sprockets::Server::ALLOWED_REQUEST_METHODS = T.let(T.unsafe(nil), Set)

# The purpose of this class is to generate a source map file
# that can be read and understood by browsers.
#
# When a file is passed in it will have a `application/js-sourcemap+json`
# or `application/css-sourcemap+json` mime type. The filename will be
# match the original asset. The original asset is loaded. As it
# gets processed by Sprockets it will acquire all information
# needed to build a source map file in the `asset.to_hash[:metadata][:map]`
# key.
#
# The output is an asset with a properly formatted source map file:
#
#   {
#     "version": 3,
#     "sources": ["foo.js"],
#     "names":   [ ],
#     "mappings": "AAAA,GAAIA"
#   }
class Sprockets::SourceMapProcessor
  class << self
    # source://sprockets//lib/sprockets/source_map_processor.rb#26
    def call(input); end

    # source://sprockets//lib/sprockets/source_map_processor.rb#54
    def original_content_type(source_map_content_type, error_when_not_found: T.unsafe(nil)); end
  end
end

module Sprockets::SourceMapUtils
  extend ::Sprockets::SourceMapUtils

  # Public: Search Array of mappings for closest offset.
  #
  # mappings - Array of mapping Hash objects
  # offset  - Array [line, column]
  #
  # Returns mapping Hash object.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#273
  def bsearch_mappings(mappings, offset, from = T.unsafe(nil), to = T.unsafe(nil)); end

  # Public: Combine two separate source map transformations into a single
  # mapping.
  #
  # Source transformations may happen in discrete steps producing separate
  # source maps. These steps can be combined into a single mapping back to
  # the source.
  #
  # For an example, CoffeeScript may transform a file producing a map. Then
  # Uglifier processes the result and produces another map. The CoffeeScript
  # map can be combined with the Uglifier map so the source lines of the
  # minified output can be traced back to the original CoffeeScript file.
  #
  # Returns a source map hash.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#156
  def combine_source_maps(first, second); end

  # Public: Compare two source map offsets.
  #
  # Compatible with Array#sort.
  #
  # a - Array [line, column]
  # b - Array [line, column]
  #
  # Returns -1 if a < b, 0 if a == b and 1 if a > b.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#254
  def compare_source_offsets(a, b); end

  # Public: Concatenate two source maps.
  #
  # For an example, if two js scripts are concatenated, the individual source
  # maps for those files can be concatenated to map back to the originals.
  #
  # Examples
  #
  #     script3 = "#{script1}#{script2}"
  #     map3    = concat_source_maps(map1, map2)
  #
  # a - Source map hash
  # b - Source map hash
  #
  # Returns a new source map hash.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#73
  def concat_source_maps(a, b); end

  # Public: Decompress source map
  #
  # Example:
  #
  #     decode_source_map(map)
  #     # => {
  #       version:  3,
  #       file:     "..",
  #       mappings: [
  #         { source: "..", generated: [0, 0], original: [0, 0], name: ".."}, ..
  #       ],
  #       sources:  [..],
  #       names:    [..]
  #     }
  #
  # map - Source map hash (v3 spec)
  #
  # Returns an uncompressed source map hash
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#192
  def decode_source_map(map); end

  # Public: Decode VLQ mappings and match up sources and symbol names.
  #
  # str     - VLQ string from 'mappings' attribute
  # sources - Array of Strings from 'sources' attribute
  # names   - Array of Strings from 'names' attribute
  #
  # Returns an Array of Mappings.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#297
  def decode_vlq_mappings(str, sources: T.unsafe(nil), names: T.unsafe(nil)); end

  # Public: Compress source map
  #
  # Example:
  #
  #     encode_source_map(map)
  #     # => {
  #       "version"  => 3,
  #       "file"     => "..",
  #       "mappings" => "AAAA;AACA;..;AACA",
  #       "sources"  => [..],
  #       "names"    => [..]
  #     }
  #
  # map - Source map hash (uncompressed)
  #
  # Returns a compressed source map hash according to source map spec v3
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#235
  def encode_source_map(map); end

  # Public: Encode mappings Hash into a VLQ encoded String.
  #
  # mappings - Array of Hash mapping objects
  # sources  - Array of String sources (default: mappings source order)
  # names    - Array of String names (default: mappings name order)
  #
  # Returns a VLQ encoded String.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#346
  def encode_vlq_mappings(mappings, sources: T.unsafe(nil), names: T.unsafe(nil)); end

  # Public: Transpose source maps into a standard format
  #
  # NOTE: Does not support index maps
  #
  # version => 3
  # file    => logical path
  # sources => relative from filename
  #
  #   Unnecessary attributes are removed
  #
  # Example
  #
  #     map
  #     #=> {
  #     #  "version"        => 3,
  #     #  "file"           => "stdin",
  #     #  "sourceRoot"     => "",
  #     #  "sourceContents" => "blah blah blah",
  #     #  "sources"        => [/root/logical/path.js],
  #     #  "names"          => [..],
  #     #}
  #     format_source_map(map, input)
  #     #=> {
  #     #  "version"        => 3,
  #     #  "file"           => "logical/path.js",
  #     #  "sources"        => ["path.js"],
  #     #  "names"          => [..],
  #     #}
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#37
  def format_source_map(map, input); end

  # Public: Converts source map to index map
  #
  # Example:
  #
  #     map
  #     # => {
  #       "version"  => 3,
  #       "file"     => "..",
  #       "mappings" => "AAAA;AACA;..;AACA",
  #       "sources"  => [..],
  #       "names"    => [..]
  #     }
  #     make_index_map(map)
  #     # => {
  #       "version"  => 3,
  #       "file"     => "..",
  #       "sections" => [
  #         {
  #           "offset" => { "line" => 0, "column" => 0 },
  #           "map"    => {
  #             "version"  => 3,
  #             "file"     => "..",
  #             "mappings" => "AAAA;AACA;..;AACA",
  #             "sources"  => [..],
  #             "names"    => [..]
  #           }
  #         }
  #       ]
  #     }
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#129
  def make_index_map(map); end

  # Public: Decode a VLQ string.
  #
  # str - VLQ encoded String
  #
  # Returns an Array of Integers.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#429
  def vlq_decode(str); end

  # Public: Decode a VLQ string into mapping numbers.
  #
  # str - VLQ encoded String
  #
  # Returns an two dimensional Array of Integers.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#470
  def vlq_decode_mappings(str); end

  # Public: Encode a list of numbers into a compact VLQ string.
  #
  # ary - An Array of Integers
  #
  # Returns a VLQ String.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#408
  def vlq_encode(ary); end

  # Public: Encode a mapping array into a compact VLQ string.
  #
  # ary - Two dimensional Array of Integers.
  #
  # Returns a VLQ encoded String separated by , and ;.
  #
  # source://sprockets//lib/sprockets/source_map_utils.rb#457
  def vlq_encode_mappings(ary); end
end

# source://sprockets//lib/sprockets/source_map_utils.rb#400
Sprockets::SourceMapUtils::BASE64_DIGITS = T.let(T.unsafe(nil), Array)

# source://sprockets//lib/sprockets/source_map_utils.rb#401
Sprockets::SourceMapUtils::BASE64_VALUES = T.let(T.unsafe(nil), Hash)

# source://sprockets//lib/sprockets/source_map_utils.rb#396
Sprockets::SourceMapUtils::VLQ_BASE = T.let(T.unsafe(nil), Integer)

# source://sprockets//lib/sprockets/source_map_utils.rb#397
Sprockets::SourceMapUtils::VLQ_BASE_MASK = T.let(T.unsafe(nil), Integer)

# Public: Base64 VLQ encoding
#
# Adopted from ConradIrwin/ruby-source_map
#   https://github.com/ConradIrwin/ruby-source_map/blob/master/lib/source_map/vlq.rb
#
# Resources
#
#   http://en.wikipedia.org/wiki/Variable-length_quantity
#   https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit
#   https://github.com/mozilla/source-map/blob/master/lib/source-map/base64-vlq.js
#
# source://sprockets//lib/sprockets/source_map_utils.rb#395
Sprockets::SourceMapUtils::VLQ_BASE_SHIFT = T.let(T.unsafe(nil), Integer)

# source://sprockets//lib/sprockets/source_map_utils.rb#398
Sprockets::SourceMapUtils::VLQ_CONTINUATION_BIT = T.let(T.unsafe(nil), Integer)

module Sprockets::Transformers
  include ::Sprockets::Utils
  include ::Sprockets::ProcessorUtils
  include ::Sprockets::HTTPUtils

  # Internal: Compose multiple transformer steps into a single processor
  # function.
  #
  # transformers - Two level Hash of a source mime type to a target mime type
  # types - Array of mime type steps
  #
  # Returns Processor.
  #
  # source://sprockets//lib/sprockets/transformers.rb#115
  def compose_transformers(transformers, types, preprocessors, postprocessors); end

  # Internal: Expand accept type list to include possible transformed types.
  #
  # parsed_accepts - Array of accept q values
  #
  # Examples
  #
  #   expand_transform_accepts([['application/javascript', 1.0]])
  #   # => [['application/javascript', 1.0], ['text/coffeescript', 0.8]]
  #
  # Returns an expanded Array of q values.
  #
  # source://sprockets//lib/sprockets/transformers.rb#97
  def expand_transform_accepts(parsed_accepts); end

  # Public: Register a transformer from and to a mime type.
  #
  # from - String mime type
  # to   - String mime type
  # proc - Callable block that accepts an input Hash.
  #
  # Examples
  #
  #   register_transformer 'text/coffeescript', 'application/javascript',
  #     ConvertCoffeeScriptToJavaScript
  #
  #   register_transformer 'image/svg+xml', 'image/png', ConvertSvgToPng
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/transformers.rb#38
  def register_transformer(from, to, proc); end

  # Internal: Register transformer for existing type adding a suffix.
  #
  # types       - Array of existing mime type Strings
  # type_format - String suffix formatting string
  # extname     - String extension to append
  # processor   - Callable block that accepts an input Hash.
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/transformers.rb#53
  def register_transformer_suffix(types, type_format, extname, processor); end

  # Internal: Resolve target mime type that the source type should be
  # transformed to.
  #
  # type   - String from mime type
  # accept - String accept type list (default: '*/*')
  #
  # Examples
  #
  #   resolve_transform_type('text/plain', 'text/plain')
  #   # => 'text/plain'
  #
  #   resolve_transform_type('image/svg+xml', 'image/png, image/*')
  #   # => 'image/png'
  #
  #   resolve_transform_type('text/css', 'image/png')
  #   # => nil
  #
  # Returns String mime type or nil is no type satisfied the accept value.
  #
  # source://sprockets//lib/sprockets/transformers.rb#83
  def resolve_transform_type(type, accept); end

  # Public: Two level mapping of a source mime type to a target mime type.
  #
  #   environment.transformers
  #   # => { 'text/coffeescript' => {
  #            'application/javascript' => ConvertCoffeeScriptToJavaScript
  #          }
  #        }
  #
  # source://sprockets//lib/sprockets/transformers.rb#18
  def transformers; end

  private

  # source://sprockets//lib/sprockets/transformers.rb#131
  def compose_transformer_list(transformers, preprocessors, postprocessors); end

  # source://sprockets//lib/sprockets/transformers.rb#147
  def compute_transformers!(registered_transformers); end
end

class Sprockets::Transformers::Transformer < ::Struct
  # Returns the value of attribute from
  #
  # @return [Object] the current value of from
  def from; end

  # Sets the attribute from
  #
  # @param value [Object] the value to set the attribute from to.
  # @return [Object] the newly set value
  def from=(_); end

  # Returns the value of attribute proc
  #
  # @return [Object] the current value of proc
  def proc; end

  # Sets the attribute proc
  #
  # @param value [Object] the value to set the attribute proc to.
  # @return [Object] the newly set value
  def proc=(_); end

  # Returns the value of attribute to
  #
  # @return [Object] the current value of to
  def to; end

  # Sets the attribute to
  #
  # @param value [Object] the value to set the attribute to to.
  # @return [Object] the newly set value
  def to=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Internal: used to "expand" and "compress" values for storage
class Sprockets::URITar
  # Internal: Initialize object for compression or expansion
  #
  # uri - A String containing URI that may or may not contain the scheme
  # env - The current "environment" that assets are being loaded into.
  #
  # @return [URITar] a new instance of URITar
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#13
  def initialize(uri, env); end

  # Internal: Tells us if we are using an absolute path
  #
  # Nix* systems start with a `/` like /Users/schneems.
  # Windows systems start with a drive letter than colon and slash
  # like C:/Schneems.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#44
  def absolute_path?; end

  # Internal: Converts full uri to a "compressed" uri
  #
  # If a uri is inside of an environment's root it will
  # be shortened to be a relative path.
  #
  # If a uri is outside of the environment's root the original
  # uri will be returned.
  #
  # Returns String
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#35
  def compress; end

  # Internal: Returns "compressed" path
  #
  # If the input uri is relative to the environment root
  # it will return a path relative to the environment root.
  # Otherwise an absolute path will be returned.
  #
  # Only path information is returned, and not scheme.
  #
  # Returns String
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#84
  def compressed_path; end

  # Internal: Convert a "compressed" uri to an absolute path
  #
  # If a uri is inside of the environment's root it will not
  # start with a slash for example:
  #
  #   file://this/is/a/relative/path
  #
  # If a uri is outside the root, it will start with a slash:
  #
  #   file:///This/is/an/absolute/path
  #
  # Returns String
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#60
  def expand; end

  # Returns the value of attribute path.
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#7
  def path; end

  # Returns the value of attribute root.
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#7
  def root; end

  # Returns the value of attribute scheme.
  #
  # source://sprockets//lib/sprockets/uri_tar.rb#7
  def scheme; end
end

# Internal: Asset URI related parsing utilities. Mixed into Environment.
#
# An Asset URI identifies the compiled Asset result. It shares the file:
# scheme and requires an absolute path.
#
# Other query parameters
#
# type - String output content type. Otherwise assumed from file extension.
#        This maybe different than the extension if the asset is transformed
#        from one content type to another. For an example .coffee -> .js.
#
# id - Unique fingerprint of the entire asset and all its metadata. Assets
#      will only have the same id if they serialize to an identical value.
#
# pipeline - String name of pipeline.
module Sprockets::URIUtils
  extend ::Sprockets::URIUtils

  # Internal: Build Asset URI.
  #
  # Examples
  #
  #   build("/tmp/js/application.coffee", type: "application/javascript")
  #   # => "file:///tmp/js/application.coffee?type=application/javascript"
  #
  # path   - String file path
  # params - Hash of optional parameters
  #
  # Returns String URI.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#114
  def build_asset_uri(path, params = T.unsafe(nil)); end

  # Internal: Build file-digest dependency URI.
  #
  # Examples
  #
  #   build("/tmp/js/application.js")
  #   # => "file-digest:/tmp/js/application.js"
  #
  # path - String file path
  #
  # Returns String URI.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#148
  def build_file_digest_uri(path); end

  # Internal: Serialize hash of params into query string.
  #
  # params - Hash of params to serialize
  #
  # Returns String query or nil if empty.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#157
  def encode_uri_query_params(params); end

  # Internal: Join file: URI component parts into String.
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#62
  def join_file_uri(scheme, host, path, query); end

  # Internal: Join URI component parts into String.
  #
  # Returns String.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#36
  def join_uri(scheme, userinfo, host, port, registry, path, opaque, query, fragment); end

  # Internal: Parse Asset URI.
  #
  # Examples
  #
  #   parse("file:///tmp/js/application.coffee?type=application/javascript")
  #   # => "/tmp/js/application.coffee", {type: "application/javascript"}
  #
  # uri - String asset URI
  #
  # Returns String path and Hash of symbolized parameters.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#93
  def parse_asset_uri(uri); end

  # Internal: Parse file-digest dependency URI.
  #
  # Examples
  #
  #   parse("file-digest:/tmp/js/application.js")
  #   # => "/tmp/js/application.js"
  #
  # uri - String file-digest URI
  #
  # Returns String path.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#128
  def parse_file_digest_uri(uri); end

  # Internal: Parse query string into hash of params
  #
  # query - String query string
  #
  # Return Hash of params.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#182
  def parse_uri_query_params(query); end

  # Internal: Parse file: URI into component parts.
  #
  # uri - String uri
  #
  # Returns [scheme, host, path, query].
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#45
  def split_file_uri(uri); end

  # Internal: Parse URI into component parts.
  #
  # uri - String uri
  #
  # Returns Array of components.
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#29
  def split_uri(uri); end

  # Internal: Check if String is a valid Asset URI.
  #
  # str - Possible String asset URI.
  #
  # Returns true or false.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/uri_utils.rb#76
  def valid_asset_uri?(str); end
end

class Sprockets::UglifierCompressor
  # @return [UglifierCompressor] a new instance of UglifierCompressor
  #
  # source://sprockets//lib/sprockets/uglifier_compressor.rb#39
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/uglifier_compressor.rb#37
  def cache_key; end

  # source://sprockets//lib/sprockets/uglifier_compressor.rb#46
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/uglifier_compressor.rb#33
    def cache_key; end

    # source://sprockets//lib/sprockets/uglifier_compressor.rb#29
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns UglifierCompressor object.
    #
    # source://sprockets//lib/sprockets/uglifier_compressor.rb#25
    def instance; end
  end
end

# source://sprockets//lib/sprockets/uglifier_compressor.rb#20
Sprockets::UglifierCompressor::VERSION = T.let(T.unsafe(nil), String)

# Internal: Used to parse and store the URI to an unloaded asset
# Generates keys used to store and retrieve items from cache
class Sprockets::UnloadedAsset
  # Internal: Initialize object for generating cache keys
  #
  # uri - A String containing complete URI to a file including scheme
  #       and full path such as
  #       "file:///Path/app/assets/js/app.js?type=application/javascript"
  # env - The current "environment" that assets are being loaded into.
  #       We need it so we know where the +root+ (directory where Sprockets
  #       is being invoked). We also need it for the `file_digest` method,
  #       since, for some strange reason, memoization is provided by
  #       overriding methods such as `stat` in the `PathUtils` module.
  #
  # Returns UnloadedAsset.
  #
  # @return [UnloadedAsset] a new instance of UnloadedAsset
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#22
  def initialize(uri, env); end

  # Internal: Key of asset
  #
  # Used to retrieve an asset from the cache based on "compressed" path to asset.
  # A "compressed" path can either be relative to the root of the project or an
  # absolute path.
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#77
  def asset_key; end

  # Returns the value of attribute compressed_path.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#29
  def compressed_path; end

  # Public: Dependency History key
  #
  # Used to retrieve an array of "histories" each of which contains a set of stored dependencies
  # for a given asset path and filename digest.
  #
  # A dependency can refer to either an asset e.g. index.js
  # may rely on jquery.js (so jquery.js is a dependency), or other factors that may affect
  # compilation, such as the VERSION of Sprockets (i.e. the environment) and what "processors"
  # are used.
  #
  # For example a history array with one Set of dependencies may look like:
  #
  # [["environment-version", "environment-paths", "processors:type=text/css&file_type=text/css",
  #   "file-digest:///Full/path/app/assets/stylesheets/application.css",
  #   "processors:type=text/css&file_type=text/css&pipeline=self",
  #   "file-digest:///Full/path/app/assets/stylesheets"]]
  #
  # This method of asset lookup is used to ensure that none of the dependencies have been modified
  # since last lookup. If one of them has, the key will be different and a new entry must be stored.
  #
  # URI dependencies are later converted to "compressed" paths
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#104
  def dependency_history_key; end

  # Internal: Digest key
  #
  # Used to retrieve a string containing the "compressed" path to an asset based on
  # a digest. The digest is generated from dependencies stored via information stored in
  # the `dependency_history_key` after each of the "dependencies" is "resolved".
  # For example "environment-version" may be resolved to "environment-1.0-3.2.0"
  # for version "3.2.0" of Sprockets
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#117
  def digest_key(digest); end

  # Internal: File digest key
  #
  # The digest for a given file won't change if the path and the stat time hasn't changed
  # We can save time by not re-computing this information and storing it in the cache
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#127
  def file_digest_key(stat); end

  # Internal: Full file path without schema
  #
  # This returns a string containing the full path to the asset without the schema.
  # Information is loaded lazily since we want `UnloadedAsset.new(dep, self).relative_path`
  # to be fast. Calling this method the first time allocates an array and a hash.
  #
  # Example
  #
  # If the URI is `file:///Full/path/app/assets/javascripts/application.js"` then the
  # filename would be `"/Full/path/app/assets/javascripts/application.js"`
  #
  # Returns a String.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#43
  def filename; end

  # Internal: Hash of param values
  #
  # This information is generated and used internally by Sprockets.
  # Known keys include `:type` which stores the asset's mime-type, `:id` which is a fully resolved
  # digest for the asset (includes dependency digest as opposed to a digest of only file contents)
  # and `:pipeline`. Hash may be empty.
  #
  # Example
  #
  # If the URI is `file:///Full/path/app/assets/javascripts/application.js"type=application/javascript`
  # Then the params would be `{type: "application/javascript"}`
  #
  # Returns a Hash.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#63
  def params; end

  # Returns the value of attribute uri.
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#29
  def uri; end

  private

  # Internal: Parses uri into filename and params hash
  #
  # Returns Array with filename and params hash
  #
  # source://sprockets//lib/sprockets/unloaded_asset.rb#135
  def load_file_params; end
end

# Internal: Utils, we didn't know where else to put it! Functions may
# eventually be shuffled into more specific drawers.
module Sprockets::Utils
  extend ::Sprockets::Utils

  # Internal: Accumulate asset source to buffer and append a trailing
  # semicolon if necessary.
  #
  # buf    - String buffer to append to
  # source - String source to append
  #
  # Returns buf String.
  #
  # source://sprockets//lib/sprockets/utils.rb#100
  def concat_javascript_sources(buf, source); end

  # Internal: Post-order Depth-First search algorithm.
  #
  # Used for resolving asset dependencies.
  #
  # initial - Initial Array of nodes to traverse.
  # block   -
  #   node  - Current node to get children of
  #
  # Returns a Set of nodes.
  #
  # source://sprockets//lib/sprockets/utils.rb#165
  def dfs(initial); end

  # Internal: Post-order Depth-First search algorithm that gathers all paths
  # along the way.
  #
  # TODO: Rename function.
  #
  # path   - Initial Array node path
  # block  -
  #   node - Current node to get children of
  #
  # Returns an Array of node Arrays.
  #
  # source://sprockets//lib/sprockets/utils.rb#192
  def dfs_paths(path); end

  # Internal: Check if object can safely be .dup'd.
  #
  # Similar to ActiveSupport #duplicable? check.
  #
  # obj - Any Object
  #
  # Returns false if .dup would raise a TypeError, otherwise true.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/utils.rb#17
  def duplicable?(obj); end

  # Internal: Duplicate and store key/value on new frozen hash.
  #
  # Similar to Hash#store for nested frozen hashes.
  #
  # hash  - Hash
  # key_a - Object key. Use multiple keys for nested hashes.
  # key_b - Object key. Use multiple keys for nested hashes.
  # block - Receives current value at key.
  #
  # Examples
  #
  #     config = {paths: ["/bin", "/sbin"]}.freeze
  #     new_config = hash_reassoc(config, :paths) do |paths|
  #       paths << "/usr/local/bin"
  #     end
  #
  # Returns duplicated frozen Hash.
  #
  # source://sprockets//lib/sprockets/utils.rb#61
  def hash_reassoc(hash, key_a, key_b = T.unsafe(nil), &block); end

  # Internal: Duplicate and store key/value on new frozen hash.
  #
  # Separated for recursive calls, always use hash_reassoc(hash, *keys).
  #
  # hash - Hash
  # key  - Object key
  #
  # Returns Hash.
  #
  # source://sprockets//lib/sprockets/utils.rb#34
  def hash_reassoc1(hash, key); end

  # Internal: Inject into target module for the duration of the block.
  #
  # mod - Module
  #
  # Returns result of block.
  #
  # source://sprockets//lib/sprockets/utils.rb#129
  def module_include(base, mod); end

  # Internal: Check if string has a trailing semicolon.
  #
  # str - String
  #
  # Returns true or false.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/utils.rb#79
  def string_end_with_semicolon?(str); end
end

class Sprockets::Utils::Gzip
  # Private: Generates a gzipped file based off of reference file.
  #
  # @return [Gzip] a new instance of Gzip
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#43
  def initialize(asset, archiver: T.unsafe(nil)); end

  # Returns the value of attribute archiver.
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#40
  def archiver; end

  # Private: Returns whether or not an asset can be compressed.
  #
  # We want to compress any file that is text based.
  # You do not want to compress binary
  # files as they may already be compressed and running them
  # through a compression algorithm would make them larger.
  #
  # Return Boolean.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#68
  def can_compress?; end

  # Private: Opposite of `can_compress?`.
  #
  # Returns Boolean.
  #
  # @return [Boolean]
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#80
  def cannot_compress?; end

  # Returns the value of attribute charset.
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#40
  def charset; end

  # Private: Generates a gzipped file based off of reference asset.
  #
  # Compresses the target asset's contents and puts it into a file with
  # the same name plus a `.gz` extension in the same folder as the original.
  # Does not modify the target asset.
  #
  # Returns nothing.
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#91
  def compress(file, target); end

  # Returns the value of attribute content_type.
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#40
  def content_type; end

  # Returns the value of attribute source.
  #
  # source://sprockets//lib/sprockets/utils/gzip.rb#40
  def source; end
end

# What non-text mime types should we compress? This list comes from:
# https://www.fastly.com/blog/new-gzip-settings-and-deciding-what-compress
#
# source://sprockets//lib/sprockets/utils/gzip.rb#52
Sprockets::Utils::Gzip::COMPRESSABLE_MIME_TYPES = T.let(T.unsafe(nil), Hash)

# Private: Generates a gzipped file based off of reference asset.
#
#     ZlibArchiver.call(file, source, mtime)
#
# Compresses a given `source` using stdlib Zlib algorithm
# writes contents to the `file` passed in. Sets `mtime` of
# written file to passed in `mtime`
module Sprockets::Utils::Gzip::ZlibArchiver
  class << self
    # source://sprockets//lib/sprockets/utils/gzip.rb#13
    def call(file, source, mtime); end
  end
end

# Private: Generates a gzipped file based off of reference asset.
#
#     ZopfliArchiver.call(file, source, mtime)
#
# Compresses a given `source` using the zopfli gem
# writes contents to the `file` passed in. Sets `mtime` of
# written file to passed in `mtime`
module Sprockets::Utils::Gzip::ZopfliArchiver
  class << self
    # source://sprockets//lib/sprockets/utils/gzip.rb#31
    def call(file, source, mtime); end
  end
end

# source://sprockets//lib/sprockets/utils.rb#121
Sprockets::Utils::MODULE_INCLUDE_MUTEX = T.let(T.unsafe(nil), Thread::Mutex)

# source://sprockets//lib/sprockets/utils.rb#71
Sprockets::Utils::WHITESPACE_ORDINALS = T.let(T.unsafe(nil), Hash)

# source://sprockets//lib/sprockets/version.rb#3
Sprockets::VERSION = T.let(T.unsafe(nil), String)

# Public: YUI compressor.
#
# To accept the default options
#
#     environment.register_bundle_processor 'application/javascript',
#       Sprockets::YUICompressor
#
# Or to pass options to the YUI::JavaScriptCompressor class.
#
#     environment.register_bundle_processor 'application/javascript',
#       Sprockets::YUICompressor.new(munge: true)
class Sprockets::YUICompressor
  # @return [YUICompressor] a new instance of YUICompressor
  #
  # source://sprockets//lib/sprockets/yui_compressor.rb#38
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute cache_key.
  #
  # source://sprockets//lib/sprockets/yui_compressor.rb#36
  def cache_key; end

  # source://sprockets//lib/sprockets/yui_compressor.rb#43
  def call(input); end

  class << self
    # source://sprockets//lib/sprockets/yui_compressor.rb#32
    def cache_key; end

    # source://sprockets//lib/sprockets/yui_compressor.rb#28
    def call(input); end

    # Public: Return singleton instance with default options.
    #
    # Returns YUICompressor object.
    #
    # source://sprockets//lib/sprockets/yui_compressor.rb#24
    def instance; end
  end
end

# source://sprockets//lib/sprockets/yui_compressor.rb#19
Sprockets::YUICompressor::VERSION = T.let(T.unsafe(nil), String)
