# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `solargraph` gem.
# Please instead update this file by running `bin/tapioca gem solargraph`.

class RubyVM::AbstractSyntaxTree::Node
  # source://solargraph//lib/solargraph/parser/rubyvm.rb#18
  def ==(other); end

  # source://solargraph//lib/solargraph/parser/rubyvm.rb#14
  def to_sexp; end

  private

  # source://solargraph//lib/solargraph/parser/rubyvm.rb#27
  def sexp(node, depth = T.unsafe(nil)); end
end

# The top-level namespace for the Solargraph code mapping, documentation,
# static analysis, and language server libraries.
module Solargraph
  class << self
    # A convenience method for Solargraph::Logging.logger.
    #
    # @return [Logger]
    #
    # source://solargraph//lib/solargraph.rb#53
    def logger; end

    # A helper method that runs Bundler.with_unbundled_env or falls back to
    # Bundler.with_clean_env for earlier versions of Bundler.
    #
    # @return [void]
    #
    # source://solargraph//lib/solargraph.rb#61
    def with_clean_env(&block); end
  end
end

# An aggregate provider for information about workspaces, sources, gems, and
# the Ruby core.
class Solargraph::ApiMap
  include ::Solargraph::ApiMap::SourceToYard

  # @param pins [Array<Solargraph::Pin::Base>]
  # @return [ApiMap] a new instance of ApiMap
  #
  # source://solargraph//lib/solargraph/api_map.rb#28
  def initialize(pins: T.unsafe(nil)); end

  # True if the specified file was included in a bundle, i.e., it's either
  # included in a workspace or open in a library.
  #
  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map.rb#438
  def bundled?(filename); end

  # Catalog a bench.
  #
  # @param bench [Bench]
  #
  # source://solargraph//lib/solargraph/api_map.rb#60
  def catalog(bench); end

  # @param cursor [Source::Cursor]
  # @raise [FileNotFoundError] if the cursor's file is not in the ApiMap
  # @return [SourceMap::Clip]
  #
  # source://solargraph//lib/solargraph/api_map.rb#406
  def clip(cursor); end

  # Get a clip by filename and position.
  #
  # @param filename [String]
  # @param position [Position, Array(Integer, Integer)]
  # @return [SourceMap::Clip]
  #
  # source://solargraph//lib/solargraph/api_map.rb#109
  def clip_at(filename, position); end

  # @param filename [String]
  # @param position [Position, Array(Integer, Integer)]
  # @raise [FileNotFoundError]
  # @return [Source::Cursor]
  #
  # source://solargraph//lib/solargraph/api_map.rb#98
  def cursor_at(filename, position); end

  # Get YARD documentation for the specified path.
  #
  # @example
  #   api_map.document('String#split')
  # @param path [String] The path to find
  # @return [Array<YARD::CodeObjects::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#378
  def document(path); end

  # Get an array of document symbols from a file.
  #
  # @param filename [String]
  # @return [Array<Pin::Symbol>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#415
  def document_symbols(filename); end

  # Get an array of class variable pins for a namespace.
  #
  # @param namespace [String] A fully qualified namespace
  # @return [Array<Solargraph::Pin::ClassVariable>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#231
  def get_class_variable_pins(namespace); end

  # Get an array of method pins for a complex type.
  #
  # The type's namespace and the context should be fully qualified. If the
  # context matches the namespace type or is a subclass of the type,
  # protected methods are included in the results. If protected methods are
  # included and internal is true, private methods are also included.
  #
  # @example
  #   api_map = Solargraph::ApiMap.new
  #   type = Solargraph::ComplexType.parse('String')
  #   api_map.get_complex_type_methods(type)
  # @param complex_type [Solargraph::ComplexType] The complex type of the namespace
  # @param context [String] The context from which the type is referenced
  # @param internal [Boolean] True to include private methods
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#292
  def get_complex_type_methods(complex_type, context = T.unsafe(nil), internal = T.unsafe(nil)); end

  # Get suggestions for constants in the specified namespace. The result
  # may contain both constant and namespace pins.
  #
  # @param namespace [String] The namespace
  # @param contexts [Array<String>] The contexts
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#172
  def get_constants(namespace, *contexts); end

  # @return [Array<Solargraph::Pin::GlobalVariable>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#241
  def get_global_variable_pins; end

  # Get an array of instance variable pins defined in specified namespace
  # and scope.
  #
  # @param namespace [String] A fully qualified namespace
  # @param scope [Symbol] :instance or :class
  # @return [Array<Solargraph::Pin::InstanceVariable>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#214
  def get_instance_variable_pins(namespace, scope = T.unsafe(nil)); end

  # Get a stack of method pins for a method name in a namespace. The order
  # of the pins corresponds to the ancestry chain, with highest precedence
  # first.
  #
  # @example
  #   api_map.get_method_stack('Subclass', 'method_name')
  #   #=> [ <Subclass#method_name pin>, <Superclass#method_name pin> ]
  # @param fqns [String]
  # @param name [String]
  # @param scope [Symbol] :instance or :class
  # @return [Array<Solargraph::Pin::Method>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#329
  def get_method_stack(fqns, name, scope: T.unsafe(nil)); end

  # Get an array of methods available in a particular context.
  #
  # @param fqns [String] The fully qualified namespace to search for methods
  # @param scope [Symbol] :class or :instance
  # @param visibility [Array<Symbol>] :public, :protected, and/or :private
  # @param deep [Boolean] True to include superclasses, mixins, etc.
  # @return [Array<Solargraph::Pin::Method>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#252
  def get_methods(fqns, scope: T.unsafe(nil), visibility: T.unsafe(nil), deep: T.unsafe(nil)); end

  # Get an array of pins that match the specified path.
  #
  # @param path [String]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#348
  def get_path_pins(path); end

  # Get an array of all suggestions that match the specified path.
  #
  # @deprecated Use #get_path_pins instead.
  # @param path [String] The path to find
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#339
  def get_path_suggestions(path); end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#236
  def get_symbols; end

  # @return [Environ]
  #
  # source://solargraph//lib/solargraph/api_map.rb#91
  def implicit; end

  # @param pins [Array<Pin::Base>]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/api_map.rb#37
  def index(pins); end

  # An array of pins based on Ruby keywords (`if`, `end`, etc.).
  #
  # @return [Enumerable<Solargraph::Pin::Keyword>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#146
  def keyword_pins; end

  # @param location [Solargraph::Location]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#398
  def locate_pins(location); end

  # Map a single source.
  #
  # @param source [Source]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/api_map.rb#51
  def map(source); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#25
  def missing_docs; end

  # @param name [String]
  # @return [YARD::Tags::MacroDirective, nil]
  #
  # source://solargraph//lib/solargraph/api_map.rb#82
  def named_macro(name); end

  # True if the namespace exists.
  #
  # @param name [String] The namespace to match
  # @param context [String] The context to search
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map.rb#162
  def namespace_exists?(name, context = T.unsafe(nil)); end

  # An array of namespace names defined in the ApiMap.
  #
  # @return [Set<String>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#153
  def namespaces; end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#129
  def pins; end

  # Get a fully qualified namespace name. This method will start the search
  # in the specified context until it finds a match for the name.
  #
  # @param namespace [String, nil] The namespace to match
  # @param context [String] The context to search
  # @return [String]
  #
  # source://solargraph//lib/solargraph/api_map.rb#195
  def qualify(namespace, context = T.unsafe(nil)); end

  # Get an array of all symbols in the workspace that match the query.
  #
  # @param query [String]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#389
  def query_symbols(query); end

  # source://solargraph//lib/solargraph/api_map.rb#133
  def rebindable_method_names; end

  # source://solargraph//lib/solargraph/api_map.rb#86
  def required; end

  # Get a list of documented paths that match the query.
  #
  # @example
  #   api_map.query('str') # Results will include `String` and `Struct`
  # @param query [String] The text to match
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#359
  def search(query); end

  # Get a source map by filename.
  #
  # @param filename [String]
  # @raise [FileNotFoundError]
  # @return [SourceMap]
  #
  # source://solargraph//lib/solargraph/api_map.rb#429
  def source_map(filename); end

  # @return [Array<SourceMap>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#421
  def source_maps; end

  # Check if a class is a superclass of another class.
  #
  # @param sup [String] The superclass
  # @param sub [String] The subclass
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map.rb#447
  def super_and_sub?(sup, sub); end

  # Check if the host class includes the specified module.
  #
  # @param host [String] The class
  # @param mod [String] The module
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map.rb#467
  def type_include?(host, mod); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#22
  def unresolved_requires; end

  # @return [YardMap]
  #
  # source://solargraph//lib/solargraph/api_map.rb#458
  def yard_map; end

  private

  # @return [Solargraph::ApiMap::Cache]
  #
  # source://solargraph//lib/solargraph/api_map.rb#484
  def cache; end

  # Get the namespace's type (Class or Module).
  #
  # @param fqns [String] A fully qualified namespace
  # @return [Symbol, nil] :class, :module, or nil
  #
  # source://solargraph//lib/solargraph/api_map.rb#627
  def get_namespace_type(fqns); end

  # @param fqns [String]
  # @param visibility [Array<Symbol>]
  # @param skip [Set<String>]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#543
  def inner_get_constants(fqns, visibility, skip); end

  # @param fqns [String] A fully qualified namespace
  # @param scope [Symbol] :class or :instance
  # @param visibility [Array<Symbol>] :public, :protected, and/or :private
  # @param deep [Boolean]
  # @param skip [Set<String>]
  # @param no_core [Boolean] Skip core classes if true
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#493
  def inner_get_methods(fqns, scope, visibility, deep, skip, no_core = T.unsafe(nil)); end

  # @param name [String]
  # @param root [String]
  # @param skip [Set<String>]
  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/api_map.rb#587
  def inner_qualify(name, root, skip); end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/api_map.rb#563
  def path_macros; end

  # Sort an array of pins to put nil or undefined variables last.
  #
  # @param pins [Array<Solargraph::Pin::Base>]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#639
  def prefer_non_nil_variables(pins); end

  # @param namespace [String]
  # @param context [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/api_map.rb#570
  def qualify_lower(namespace, context); end

  # source://solargraph//lib/solargraph/api_map.rb#574
  def qualify_superclass(fqsub); end

  # @param pin [Pin::MethodAlias, Pin::Base]
  # @return [Pin::Method]
  #
  # source://solargraph//lib/solargraph/api_map.rb#667
  def resolve_method_alias(pin); end

  # @param pins [Array<Pin::Base>]
  # @param visibility [Array<Symbol>]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map.rb#655
  def resolve_method_aliases(pins, visibility = T.unsafe(nil)); end

  # A hash of source maps with filename keys.
  #
  # @return [Hash{String => SourceMap}]
  #
  # source://solargraph//lib/solargraph/api_map.rb#476
  def source_map_hash; end

  # @return [ApiMap::Store]
  #
  # source://solargraph//lib/solargraph/api_map.rb#479
  def store; end

  class << self
    # Create an ApiMap with a workspace in the specified directory.
    #
    # @param directory [String]
    # @return [ApiMap]
    #
    # source://solargraph//lib/solargraph/api_map.rb#118
    def load(directory); end
  end
end

module Solargraph::ApiMap::BundlerMethods
  private

  # @param directory [String]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/api_map/bundler_methods.rb#11
  def require_from_bundle(directory); end

  class << self
    # @param directory [String]
    # @return [Hash]
    #
    # source://solargraph//lib/solargraph/api_map/bundler_methods.rb#11
    def require_from_bundle(directory); end
  end
end

class Solargraph::ApiMap::Cache
  # @return [Cache] a new instance of Cache
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#6
  def initialize; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#54
  def clear; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#62
  def empty?; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#23
  def get_constants(namespace, context); end

  # @return [Array<Pin::Method>]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#14
  def get_methods(fqns, scope, visibility, deep); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#32
  def get_qualified_namespace(name, context); end

  # @return [Pin::Method]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#45
  def get_receiver_definition(path); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map/cache.rb#40
  def receiver_defined?(path); end

  # source://solargraph//lib/solargraph/api_map/cache.rb#27
  def set_constants(namespace, context, value); end

  # source://solargraph//lib/solargraph/api_map/cache.rb#18
  def set_methods(fqns, scope, visibility, deep, value); end

  # source://solargraph//lib/solargraph/api_map/cache.rb#36
  def set_qualified_namespace(name, context, value); end

  # source://solargraph//lib/solargraph/api_map/cache.rb#49
  def set_receiver_definition(path, pin); end
end

module Solargraph::ApiMap::SourceToYard
  # Get the YARD CodeObject at the specified path.
  #
  # @param path [String]
  # @return [YARD::CodeObjects::Base]
  #
  # source://solargraph//lib/solargraph/api_map/source_to_yard.rb#11
  def code_object_at(path); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map/source_to_yard.rb#16
  def code_object_paths; end

  # @param store [ApiMap::Store] ApiMap pin store
  # @return [void]
  #
  # source://solargraph//lib/solargraph/api_map/source_to_yard.rb#22
  def rake_yard(store); end

  private

  # @return [Hash{String => YARD::CodeObjects::Base}]
  #
  # source://solargraph//lib/solargraph/api_map/source_to_yard.rb#71
  def code_object_map; end

  # @return [YARD::CodeObjects::RootObject]
  #
  # source://solargraph//lib/solargraph/api_map/source_to_yard.rb#76
  def root_code_object; end
end

class Solargraph::ApiMap::Store
  # @param pins [Enumerable<Solargraph::Pin::Base>]
  # @return [Store] a new instance of Store
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#12
  def initialize(pins = T.unsafe(nil)); end

  # @return [Enumerable<Pin::Block>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#135
  def block_pins; end

  # @param fqns [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#112
  def domains(fqns); end

  # @param fqns [String]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#80
  def get_class_variables(fqns); end

  # @param fqns [String]
  # @param visibility [Array<Symbol>]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#20
  def get_constants(fqns, visibility = T.unsafe(nil)); end

  # @param fqns [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#59
  def get_extends(fqns); end

  # @param fqns [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#47
  def get_includes(fqns); end

  # @param fqns [String]
  # @param scope [Symbol] :class or :instance
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#72
  def get_instance_variables(fqns, scope = T.unsafe(nil)); end

  # @param fqns [String]
  # @param scope [Symbol]
  # @param visibility [Array<Symbol>]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#30
  def get_methods(fqns, scope: T.unsafe(nil), visibility: T.unsafe(nil)); end

  # @param path [String]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#65
  def get_path_pins(path); end

  # @param fqns [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#53
  def get_prepends(fqns); end

  # @param fqns [String]
  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#38
  def get_superclass(fqns); end

  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#85
  def get_symbols; end

  # source://solargraph//lib/solargraph/api_map/store.rb#139
  def inspect; end

  # @return [Enumerable<Solargraph::Pin::Method>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#106
  def method_pins; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#121
  def named_macros; end

  # @param fqns [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#91
  def namespace_exists?(fqns); end

  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#101
  def namespace_pins; end

  # @return [Set<String>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#96
  def namespaces; end

  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#9
  def pins; end

  # @param klass [Class]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#146
  def pins_by_class(klass); end

  private

  # source://solargraph//lib/solargraph/api_map/store.rb#206
  def all_instance_variables; end

  # source://solargraph//lib/solargraph/api_map/store.rb#191
  def extend_references; end

  # @param fqns [String]
  # @return [Array<Solargraph::Pin::Namespace>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#154
  def fqns_pins(fqns); end

  # source://solargraph//lib/solargraph/api_map/store.rb#167
  def fqns_pins_map; end

  # source://solargraph//lib/solargraph/api_map/store.rb#183
  def include_references; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#215
  def index; end

  # @param name [String]
  # @return [Enumerable<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#197
  def namespace_children(name); end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#202
  def namespace_map; end

  # source://solargraph//lib/solargraph/api_map/store.rb#210
  def path_pin_hash; end

  # source://solargraph//lib/solargraph/api_map/store.rb#187
  def prepend_references; end

  # source://solargraph//lib/solargraph/api_map/store.rb#179
  def superclass_references; end

  # @return [Enumerable<Solargraph::Pin::Symbol>]
  #
  # source://solargraph//lib/solargraph/api_map/store.rb#175
  def symbols; end
end

# A container of source maps and workspace data to be cataloged in an ApiMap.
class Solargraph::Bench
  # @param source_maps [Array<SourceMap>, Set<SourceMap>]
  # @param workspace [Workspace]
  # @param external_requires [Array<String>, Set<String>]
  # @return [Bench] a new instance of Bench
  #
  # source://solargraph//lib/solargraph/bench.rb#21
  def initialize(source_maps: T.unsafe(nil), workspace: T.unsafe(nil), external_requires: T.unsafe(nil)); end

  # @return [Set<String>]
  #
  # source://solargraph//lib/solargraph/bench.rb#16
  def external_requires; end

  # @return [Set<SourceMap>]
  #
  # source://solargraph//lib/solargraph/bench.rb#10
  def source_maps; end

  # @return [Workspace]
  #
  # source://solargraph//lib/solargraph/bench.rb#13
  def workspace; end
end

class Solargraph::BundleNotFoundError < ::StandardError; end

# A container for type data based on YARD type tags.
class Solargraph::ComplexType
  # @param types [Array<UniqueType>]
  # @return [ComplexType] a new instance of ComplexType
  #
  # source://solargraph//lib/solargraph/complex_type.rb#14
  def initialize(types = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/complex_type.rb#57
  def [](index); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#83
  def all?(&block); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#87
  def any?(&block); end

  # @return [Array]
  # @yieldparam [UniqueType]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#39
  def each(&block); end

  # @return [Enumerator<UniqueType>]
  # @yieldparam [UniqueType]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#45
  def each_unique_type(&block); end

  # source://solargraph//lib/solargraph/complex_type.rb#29
  def first; end

  # source://solargraph//lib/solargraph/complex_type.rb#53
  def length; end

  # source://solargraph//lib/solargraph/complex_type.rb#33
  def map(&block); end

  # source://solargraph//lib/solargraph/complex_type.rb#69
  def method_missing(name, *args, &block); end

  # source://solargraph//lib/solargraph/complex_type.rb#64
  def namespace; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#104
  def nullable?; end

  # @param api_map [ApiMap]
  # @param context [String]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#21
  def qualify(api_map, context = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/complex_type.rb#61
  def select(&block); end

  # @param dst [String]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#97
  def self_to(dst); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#91
  def selfy?; end

  # source://solargraph//lib/solargraph/complex_type.rb#79
  def to_s; end

  private

  # @param dst [String]
  # @return [String]
  # @todo This is a quick and dirty hack that forces `self` keywords
  #   to reference an instance of their class and never the class itself.
  #   This behavior may change depending on which result is expected
  #   from YARD conventions. See https://github.com/lsegal/yard/issues/1257
  #
  # source://solargraph//lib/solargraph/complex_type.rb#116
  def reduce_class(dst); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type.rb#75
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end

  class << self
    # Parse type strings into a ComplexType.
    #
    # @example
    #   ComplexType.parse 'String', 'Foo', 'nil' #=> [String, Foo, nil]
    # @note The `partial` parameter is used to indicate that the method is
    #   receiving a string that will be used inside another ComplexType.
    #   It returns arrays of ComplexTypes instead of a single cohesive one.
    #   Consumers should not need to use this parameter; it should only be
    #   used internally.
    # @param *strings [Array<String>] The type definitions to parse
    # @param partial [Boolean] True if the string is part of a another type
    # @return [ComplexType, Array, nil]
    #
    # source://solargraph//lib/solargraph/complex_type.rb#139
    def parse(*strings, partial: T.unsafe(nil)); end

    # @param strings [Array<String>]
    # @return [ComplexType]
    #
    # source://solargraph//lib/solargraph/complex_type.rb#219
    def try_parse(*strings); end
  end
end

# source://solargraph//lib/solargraph/complex_type.rb#233
Solargraph::ComplexType::BOOLEAN = T.let(T.unsafe(nil), Solargraph::ComplexType)

# source://solargraph//lib/solargraph/complex_type.rb#231
Solargraph::ComplexType::NIL = T.let(T.unsafe(nil), Solargraph::ComplexType)

# source://solargraph//lib/solargraph/complex_type.rb#230
Solargraph::ComplexType::ROOT = T.let(T.unsafe(nil), Solargraph::ComplexType)

# source://solargraph//lib/solargraph/complex_type.rb#232
Solargraph::ComplexType::SELF = T.let(T.unsafe(nil), Solargraph::ComplexType)

# source://solargraph//lib/solargraph/complex_type.rb#229
Solargraph::ComplexType::SYMBOL = T.let(T.unsafe(nil), Solargraph::ComplexType)

# Methods for accessing type data.
module Solargraph::ComplexType::TypeMethods
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#89
  def ==(other); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#40
  def defined?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#21
  def duck_type?; end

  # @return [Enumerator<UniqueType>]
  # @yieldparam [UniqueType]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#131
  def each_unique_type(&block); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#54
  def fixed_parameters?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#59
  def hash_parameters?; end

  # @return [Array<ComplexType>]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#69
  def key_types; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#49
  def list_parameters?; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#9
  def name; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#74
  def namespace; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#26
  def nil_type?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#32
  def parameters?; end

  # Generate a ComplexType that fully qualifies this type's namespaces.
  #
  # @param api_map [ApiMap] The ApiMap that performs qualification
  # @param context [String] The namespace from which to resolve names
  # @return [ComplexType] The generated ComplexType
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#103
  def qualify(api_map, context = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#94
  def rooted?; end

  # @return [Symbol] :class or :instance
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#84
  def scope; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#12
  def substring; end

  # @return [Array<ComplexType>]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#18
  def subtypes; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#15
  def tag; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#44
  def undefined?; end

  # @return [Array<ComplexType>]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#64
  def value_types; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/type_methods.rb#36
  def void?; end
end

# source://solargraph//lib/solargraph/complex_type.rb#228
Solargraph::ComplexType::UNDEFINED = T.let(T.unsafe(nil), Solargraph::ComplexType)

# An individual type signature. A complex type can consist of multiple
# unique types.
class Solargraph::ComplexType::UniqueType
  include ::Solargraph::ComplexType::TypeMethods

  # Create a UniqueType with the specified name and an optional substring.
  # The substring is the parameter section of a parametrized type, e.g.,
  # for the type `Array<String>`, the name is `Array` and the substring is
  # `<String>`.
  #
  # @param name [String] The name of the type
  # @param substring [String] The substring of the type
  # @return [UniqueType] a new instance of UniqueType
  #
  # source://solargraph//lib/solargraph/complex_type/unique_type.rb#18
  def initialize(name, substring = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/complex_type/unique_type.rb#49
  def self_to(dst); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/complex_type/unique_type.rb#67
  def selfy?; end

  # source://solargraph//lib/solargraph/complex_type/unique_type.rb#45
  def to_s; end
end

# source://solargraph//lib/solargraph/complex_type/unique_type.rb#72
Solargraph::ComplexType::UniqueType::BOOLEAN = T.let(T.unsafe(nil), Solargraph::ComplexType::UniqueType)

# source://solargraph//lib/solargraph/complex_type/unique_type.rb#71
Solargraph::ComplexType::UniqueType::UNDEFINED = T.let(T.unsafe(nil), Solargraph::ComplexType::UniqueType)

# source://solargraph//lib/solargraph/complex_type.rb#227
Solargraph::ComplexType::VOID = T.let(T.unsafe(nil), Solargraph::ComplexType)

class Solargraph::ComplexTypeError < ::StandardError; end

# Conventions provide a way to modify an ApiMap based on expectations about
# one of its sources.
module Solargraph::Convention
  class << self
    # @param yard_map [YardMap]
    # @return [Environ]
    #
    # source://solargraph//lib/solargraph/convention.rb#35
    def for_global(yard_map); end

    # @param source_map [SourceMap]
    # @return [Environ]
    #
    # source://solargraph//lib/solargraph/convention.rb#25
    def for_local(source_map); end

    # @param convention [Class<Convention::Base>]
    # @return [void]
    #
    # source://solargraph//lib/solargraph/convention.rb#19
    def register(convention); end
  end
end

# The base class for Conventions.
#
# A Convention provides Environs that customize ApiMaps with additional
# pins and other information. Subclasses should implement the `local` and
# `global` methods as necessary.
class Solargraph::Convention::Base
  # The Environ for a YARD map.
  # Subclasses can override this method.
  #
  # @param yard_map [YardMap]
  # @return [Environ]
  #
  # source://solargraph//lib/solargraph/convention/base.rb#28
  def global(yard_map); end

  # The Environ for a source map.
  # Subclasses can override this method.
  #
  # @param source_map [SourceMap]
  # @return [Environ]
  #
  # source://solargraph//lib/solargraph/convention/base.rb#19
  def local(source_map); end
end

# source://solargraph//lib/solargraph/convention/base.rb#12
Solargraph::Convention::Base::EMPTY_ENVIRON = T.let(T.unsafe(nil), Solargraph::Environ)

class Solargraph::Convention::Gemfile < ::Solargraph::Convention::Base
  # source://solargraph//lib/solargraph/convention/gemfile.rb#6
  def local(source_map); end
end

class Solargraph::Convention::Gemspec < ::Solargraph::Convention::Base
  # source://solargraph//lib/solargraph/convention/gemspec.rb#6
  def local(source_map); end
end

class Solargraph::Convention::Rspec < ::Solargraph::Convention::Base
  # source://solargraph//lib/solargraph/convention/rspec.rb#6
  def local(source_map); end

  private

  # source://solargraph//lib/solargraph/convention/rspec.rb#22
  def extras; end
end

# The Diagnostics library provides reporters for analyzing problems in code
# and providing the results to language server clients.
module Solargraph::Diagnostics
  class << self
    # Add a reporter with a name to identify it in .solargraph.yml files.
    #
    # @param name [String] The name
    # @param klass [Class<Solargraph::Diagnostics::Base>] The class implementation
    # @return [void]
    #
    # source://solargraph//lib/solargraph/diagnostics.rb#22
    def register(name, klass); end

    # Find a reporter by name.
    #
    # @param name [String] The name with which the reporter was registered
    # @return [Class<Solargraph::Diagnostics::Base>]
    #
    # source://solargraph//lib/solargraph/diagnostics.rb#37
    def reporter(name); end

    # Get an array of reporter names.
    #
    # @return [Array<String>]
    #
    # source://solargraph//lib/solargraph/diagnostics.rb#29
    def reporters; end

    private

    # @return [Hash]
    #
    # source://solargraph//lib/solargraph/diagnostics.rb#44
    def reporter_hash; end
  end
end

# The base class for diagnostics reporters.
class Solargraph::Diagnostics::Base
  # @return [Base] a new instance of Base
  #
  # source://solargraph//lib/solargraph/diagnostics/base.rb#11
  def initialize(*args); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/diagnostics/base.rb#9
  def args; end

  # Perform a diagnosis on a Source within the context of an ApiMap.
  # The result is an array of hash objects that conform to the LSP's
  # Diagnostic specification.
  #
  # Subclasses should override this method.
  #
  # @param source [Solargraph::Source]
  # @param api_map [Solargraph::ApiMap]
  # @return [Array<Hash>]
  #
  # source://solargraph//lib/solargraph/diagnostics/base.rb#24
  def diagnose(source, api_map); end
end

# RequireNotFound reports required paths that could not be resolved to
# either a file in the workspace or a gem.
class Solargraph::Diagnostics::RequireNotFound < ::Solargraph::Diagnostics::Base
  # source://solargraph//lib/solargraph/diagnostics/require_not_found.rb#9
  def diagnose(source, api_map); end

  private

  # @param path [String]
  # @param location [Location]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/diagnostics/require_not_found.rb#31
  def docs_error(path, location); end

  # @param path [String]
  # @param location [Location]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/diagnostics/require_not_found.rb#43
  def require_error(path, location); end
end

# This reporter provides linting through RuboCop.
class Solargraph::Diagnostics::Rubocop < ::Solargraph::Diagnostics::Base
  include ::Solargraph::Diagnostics::RubocopHelpers

  # @param source [Solargraph::Source]
  # @param _api_map [Solargraph::ApiMap]
  # @return [Array<Hash>]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#25
  def diagnose(source, _api_map); end

  private

  # @param resp [Hash]
  # @return [Array<Hash>]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#49
  def make_array(resp); end

  # @param off [Hash]
  # @return [Position]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#88
  def offense_ending_position(off); end

  # @param off [Hash]
  # @return [Range]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#76
  def offense_range(off); end

  # @param off [Hash]
  # @return [Position]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#82
  def offense_start_position(off); end

  # Convert a RuboCop offense to an LSP diagnostic
  #
  # @param off [Hash] Offense received from Rubocop
  # @return [Hash] LSP diagnostic
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#63
  def offense_to_diagnostic(off); end

  # Extracts the rubocop version from _args_
  #
  # @return [String]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop.rb#43
  def rubocop_version; end
end

# Conversion of RuboCop severity names to LSP constants
#
# source://solargraph//lib/solargraph/diagnostics/rubocop.rb#13
Solargraph::Diagnostics::Rubocop::SEVERITIES = T.let(T.unsafe(nil), Hash)

# Utility methods for the RuboCop diagnostics reporter.
module Solargraph::Diagnostics::RubocopHelpers
  private

  # RuboCop internally uses capitalized drive letters for Windows paths,
  # so we need to convert the paths provided to the command.
  #
  # @param path [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#46
  def fix_drive_letter(path); end

  # Generate command-line options for the specified filename and code.
  #
  # @param filename [String]
  # @param code [String]
  # @return [Array(Array<String>, Array<String>)]
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#33
  def generate_options(filename, code); end

  # @return [String]
  # @todo This is a smelly way to redirect output, but the RuboCop specs do
  #   the same thing.
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#54
  def redirect_stdout; end

  # Requires a specific version of rubocop, or the latest installed version
  # if _version_ is `nil`.
  #
  # @param version [String]
  # @raise [InvalidRubocopVersionError] if _version_ is not installed
  #
  # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#15
  def require_rubocop(version = T.unsafe(nil)); end

  class << self
    # RuboCop internally uses capitalized drive letters for Windows paths,
    # so we need to convert the paths provided to the command.
    #
    # @param path [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#46
    def fix_drive_letter(path); end

    # Generate command-line options for the specified filename and code.
    #
    # @param filename [String]
    # @param code [String]
    # @return [Array(Array<String>, Array<String>)]
    #
    # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#33
    def generate_options(filename, code); end

    # @return [String]
    # @todo This is a smelly way to redirect output, but the RuboCop specs do
    #   the same thing.
    #
    # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#54
    def redirect_stdout; end

    # Requires a specific version of rubocop, or the latest installed version
    # if _version_ is `nil`.
    #
    # @param version [String]
    # @raise [InvalidRubocopVersionError] if _version_ is not installed
    #
    # source://solargraph//lib/solargraph/diagnostics/rubocop_helpers.rb#15
    def require_rubocop(version = T.unsafe(nil)); end
  end
end

# These severity constants match the DiagnosticSeverity constants in the
# language server protocol.
module Solargraph::Diagnostics::Severities; end

# source://solargraph//lib/solargraph/diagnostics/severities.rb#9
Solargraph::Diagnostics::Severities::ERROR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/diagnostics/severities.rb#12
Solargraph::Diagnostics::Severities::HINT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/diagnostics/severities.rb#11
Solargraph::Diagnostics::Severities::INFORMATION = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/diagnostics/severities.rb#10
Solargraph::Diagnostics::Severities::WARNING = T.let(T.unsafe(nil), Integer)

# TypeCheck reports methods with undefined return types, untagged
# parameters, and invalid param tags.
class Solargraph::Diagnostics::TypeCheck < ::Solargraph::Diagnostics::Base
  # source://solargraph//lib/solargraph/diagnostics/type_check.rb#9
  def diagnose(source, api_map); end

  private

  # @param location [Location]
  # @param source [Source]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/diagnostics/type_check.rb#31
  def extract_first_line(location, source); end

  # @param position [Solargraph::Position]
  # @param source [Solargraph::Source]
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/diagnostics/type_check.rb#48
  def last_character(position, source); end
end

class Solargraph::Diagnostics::UpdateErrors < ::Solargraph::Diagnostics::Base
  # source://solargraph//lib/solargraph/diagnostics/update_errors.rb#6
  def diagnose(source, api_map); end

  private

  # Combine an array of ranges by their starting lines.
  #
  # @param code [String]
  # @param ranges [Array<Range>]
  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/diagnostics/update_errors.rb#26
  def combine_ranges(code, ranges); end
end

class Solargraph::DiagnosticsError < ::RuntimeError; end

class Solargraph::Documentor
  # @return [Documentor] a new instance of Documentor
  #
  # source://solargraph//lib/solargraph/documentor.rb#17
  def initialize(directory, rebuild: T.unsafe(nil), out: T.unsafe(nil)); end

  # @return [Boolean] True if all specs were found and documented.
  #
  # source://solargraph//lib/solargraph/documentor.rb#24
  def document; end

  class << self
    # @param directory [String]
    # @return [Hash]
    #
    # source://solargraph//lib/solargraph/documentor.rb#60
    def specs_from_bundle(directory); end
  end
end

# source://solargraph//lib/solargraph/documentor.rb#12
Solargraph::Documentor::RDOC_GEMS = T.let(T.unsafe(nil), Array)

# A placeholder for the @!domain directive. It doesn't need to do anything
# for yardocs. It's only used for Solargraph API maps.
class Solargraph::DomainDirective < ::YARD::Tags::Directive
  # source://solargraph//lib/yard-solargraph.rb#12
  def call; end
end

# A collection of additional data, such as map pins and required paths, that
# can be added to an ApiMap.
#
# Conventions are used to add Environs.
class Solargraph::Environ
  # @param requires [Array<String>]
  # @param domains [Array<String>]
  # @param pins [Array<Pin::Base>]
  # @return [Environ] a new instance of Environ
  #
  # source://solargraph//lib/solargraph/environ.rb#22
  def initialize(requires: T.unsafe(nil), domains: T.unsafe(nil), pins: T.unsafe(nil)); end

  # @return [self]
  #
  # source://solargraph//lib/solargraph/environ.rb#29
  def clear; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/environ.rb#14
  def domains; end

  # @param other [Environ]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/environ.rb#38
  def merge(other); end

  # @return [Array<Pin::Reference::Override>]
  #
  # source://solargraph//lib/solargraph/environ.rb#17
  def pins; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/environ.rb#11
  def requires; end
end

class Solargraph::FileNotFoundError < ::RuntimeError; end
class Solargraph::InvalidOffsetError < ::RangeError; end
class Solargraph::InvalidRubocopVersionError < ::RuntimeError; end

# The LanguageServer namespace contains the classes and modules that compose
# concrete implementations of language servers.
module Solargraph::LanguageServer; end

# The CompletionItemKind constants for the language server protocol.
module Solargraph::LanguageServer::CompletionItemKinds; end

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#14
Solargraph::LanguageServer::CompletionItemKinds::CLASS = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#23
Solargraph::LanguageServer::CompletionItemKinds::COLOR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#28
Solargraph::LanguageServer::CompletionItemKinds::CONSTANT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#11
Solargraph::LanguageServer::CompletionItemKinds::CONSTRUCTOR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#20
Solargraph::LanguageServer::CompletionItemKinds::ENUM = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#27
Solargraph::LanguageServer::CompletionItemKinds::ENUM_MEMBER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#30
Solargraph::LanguageServer::CompletionItemKinds::EVENT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#12
Solargraph::LanguageServer::CompletionItemKinds::FIELD = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#24
Solargraph::LanguageServer::CompletionItemKinds::FILE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#26
Solargraph::LanguageServer::CompletionItemKinds::FOLDER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#10
Solargraph::LanguageServer::CompletionItemKinds::FUNCTION = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#15
Solargraph::LanguageServer::CompletionItemKinds::INTERFACE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#21
Solargraph::LanguageServer::CompletionItemKinds::KEYWORD = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#9
Solargraph::LanguageServer::CompletionItemKinds::METHOD = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#16
Solargraph::LanguageServer::CompletionItemKinds::MODULE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#31
Solargraph::LanguageServer::CompletionItemKinds::OPERATOR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#17
Solargraph::LanguageServer::CompletionItemKinds::PROPERTY = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#25
Solargraph::LanguageServer::CompletionItemKinds::REFERENCE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#22
Solargraph::LanguageServer::CompletionItemKinds::SNIPPET = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#29
Solargraph::LanguageServer::CompletionItemKinds::STRUCT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#8
Solargraph::LanguageServer::CompletionItemKinds::TEXT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#32
Solargraph::LanguageServer::CompletionItemKinds::TYPE_PARAMETER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#18
Solargraph::LanguageServer::CompletionItemKinds::UNIT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#19
Solargraph::LanguageServer::CompletionItemKinds::VALUE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/completion_item_kinds.rb#13
Solargraph::LanguageServer::CompletionItemKinds::VARIABLE = T.let(T.unsafe(nil), Integer)

# The ErrorCode constants for the language server protocol.
module Solargraph::LanguageServer::ErrorCodes; end

# source://solargraph//lib/solargraph/language_server/error_codes.rb#12
Solargraph::LanguageServer::ErrorCodes::INTERNAL_ERROR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#11
Solargraph::LanguageServer::ErrorCodes::INVALID_PARAMS = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#9
Solargraph::LanguageServer::ErrorCodes::INVALID_REQUEST = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#10
Solargraph::LanguageServer::ErrorCodes::METHOD_NOT_FOUND = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#8
Solargraph::LanguageServer::ErrorCodes::PARSE_ERROR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#17
Solargraph::LanguageServer::ErrorCodes::REQUEST_CANCELLED = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#14
Solargraph::LanguageServer::ErrorCodes::SERVER_ERROR_END = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#13
Solargraph::LanguageServer::ErrorCodes::SERVER_ERROR_START = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#15
Solargraph::LanguageServer::ErrorCodes::SERVER_NOT_INITIALIZED = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/error_codes.rb#16
Solargraph::LanguageServer::ErrorCodes::UNKNOWN_ERROR_CODE = T.let(T.unsafe(nil), Integer)

# The language server protocol's data provider. Hosts are responsible for
# querying the library and processing messages. They also provide thread
# safety for multi-threaded transports.
class Solargraph::LanguageServer::Host
  include ::Solargraph::LanguageServer::UriHelpers
  include ::Solargraph::Logging
  include ::Solargraph::LanguageServer::Host::Dispatch
  include ::Observable

  # @return [Host] a new instance of Host
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#28
  def initialize; end

  # Flag a method as available for dynamic registration.
  #
  # @param method [String] The method name, e.g., 'textDocument/completion'
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#427
  def allow_registration(method); end

  # True if the specified LSP method can be dynamically registered.
  #
  # @param method [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#435
  def can_register?(method); end

  # Cancel the method with the specified ID.
  #
  # @param id [Integer]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#71
  def cancel(id); end

  # True if the host received a request to cancel the method with the
  # specified ID.
  #
  # @param id [Integer]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#80
  def cancel?(id); end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#647
  def catalog; end

  # Update a document from the parameters of a textDocument/didChange
  # method.
  #
  # @param params [Hash]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#250
  def change(params); end

  # Delete the specified ID from the list of cancelled IDs if it exists.
  #
  # @param id [Integer]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#90
  def clear(id); end

  # source://solargraph//lib/solargraph/language_server/host.rb#652
  def client_capabilities; end

  # Sets the attribute client_capabilities
  #
  # @param value the value to set the attribute client_capabilities to.
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#26
  def client_capabilities=(_arg0); end

  # Close the file specified by the URI.
  #
  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#197
  def close(uri); end

  # @param uri [String]
  # @param line [Integer]
  # @param column [Integer]
  # @return [Solargraph::SourceMap::Completion]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#513
  def completions_at(uri, line, column); end

  # Update the configuration options with the provided hash.
  #
  # @param update [Hash]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#56
  def configure(update); end

  # Respond to a notification that a file was created in the workspace.
  # The libraries will determine whether the file should be merged; see
  # Solargraph::Library#create_from_disk.
  #
  # @param uri [String] The file uri.
  # @return [Boolean] True if a library accepted the file.
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#139
  def create(uri); end

  # @return [Hash{String => Object}]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#623
  def default_configuration; end

  # @param uri [String]
  # @param line [Integer]
  # @param column [Integer]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#527
  def definitions_at(uri, line, column); end

  # Delete the specified file from the library.
  #
  # @param uri [String] The file uri.
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#153
  def delete(uri); end

  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#205
  def diagnose(uri); end

  # @param query [String]
  # @return [Array]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#570
  def document(query); end

  # @param uri [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#578
  def document_symbols(uri); end

  # Clear the message buffer and return the most recent data.
  #
  # @return [String] The most recent data or an empty string.
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#269
  def flush; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#335
  def folders; end

  # @param uri [String]
  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#642
  def folding_ranges(uri); end

  # source://solargraph//lib/solargraph/language_server/host.rb#504
  def formatter_config(uri); end

  # @return [Bool] if has pending completion request
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#519
  def has_pending_completions?; end

  # Locate multiple pins that match a completion item. The first match is
  # based on the corresponding location in a library source if available.
  # Subsequent matches are based on path.
  #
  # @param params [Hash] A hash representation of a completion item
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#473
  def locate_pins(params); end

  # Open the specified file in the library.
  #
  # @param uri [String] The file uri.
  # @param text [String] The contents of the file.
  # @param version [Integer] A version number.
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#170
  def open(uri, text, version); end

  # True if the specified file is currently open in the library.
  #
  # @param uri [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#189
  def open?(uri); end

  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#180
  def open_from_disk(uri); end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#63
  def options; end

  # Get a list of IDs for server requests that are waiting for responses
  # from the client.
  #
  # @return [Array<Integer>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#618
  def pending_requests; end

  # Prepare a library for the specified directory.
  #
  # @param directory [String]
  # @param name [String, nil]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#283
  def prepare(directory, name = T.unsafe(nil)); end

  # Prepare multiple folders.
  #
  # @param array [Array<Hash{String => String}>]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#306
  def prepare_folders(array); end

  # Called by adapter, to handle the request
  #
  # @param request [Hash]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#97
  def process(request); end

  # @param query [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#554
  def query_symbols(query); end

  # Queue a message to be sent to the client.
  #
  # @param message [String] The message to send.
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#260
  def queue(message); end

  # @param uri [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#498
  def read_text(uri); end

  # Start processing a request from the client. After the message is
  # processed, caller is responsible for sending the response.
  #
  # @param request [Hash] The contents of the message.
  # @return [Solargraph::LanguageServer::Message::Base] The message handler.
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#106
  def receive(request); end

  # @param uri [String]
  # @param line [Integer]
  # @param column [Integer]
  # @param strip [Boolean] Strip special characters from variable names
  # @param only [Boolean] If true, search current file only
  # @return [Array<Solargraph::Range>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#547
  def references_from(uri, line, column, strip: T.unsafe(nil), only: T.unsafe(nil)); end

  # Register the methods as capabilities with the client.
  # This method will avoid duplicating registrations and ignore methods
  # that were not flagged for dynamic registration by the client.
  #
  # @param methods [Array<String>] The methods to register
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#390
  def register_capabilities(methods); end

  # True if the specified method has been registered.
  #
  # @param method [String] The method name, e.g., 'textDocument/completion'
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#443
  def registered?(method); end

  # Remove a directory.
  #
  # @param directory [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#317
  def remove(directory); end

  # @param array [Array<Hash>]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#328
  def remove_folders(array); end

  # @param query [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#562
  def search(query); end

  # Send a notification to the client.
  #
  # @param method [String] The message method
  # @param params [Hash] The method parameters
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#344
  def send_notification(method, params); end

  # Send a request to the client and execute the provided block to process
  # the response. If an ID is not provided, the host will use an auto-
  # incrementing integer.
  #
  # @param method [String] The message method
  # @param params [Hash] The method parameters
  # @param block [Proc] The block that processes the response
  # @return [void]
  # @yieldparam The [Hash] result sent by the client
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#366
  def send_request(method, params, &block); end

  # Send a notification to the client.
  #
  # @param text [String]
  # @param type [Integer] A MessageType constant
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#591
  def show_message(text, type = T.unsafe(nil)); end

  # Send a notification with optional responses.
  #
  # @param text [String]
  # @param type [Integer] A MessageType constant
  # @param actions [Array<String>] Response options for the client
  # @param block The block that processes the response
  # @return [void]
  # @yieldparam The [String] action received from the client
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#606
  def show_message_request(text, type, actions, &block); end

  # @param uri [String]
  # @param line [Integer]
  # @param column [Integer]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#536
  def signatures_at(uri, line, column); end

  # Start asynchronous process handling.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#43
  def start; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#452
  def stop; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#463
  def stopped?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#447
  def synchronizing?; end

  # Unregister the methods with the client.
  # This method will avoid duplicating unregistrations and ignore methods
  # that were not flagged for dynamic registration by the client.
  #
  # @param methods [Array<String>] The methods to unregister
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#410
  def unregister_capabilities(methods); end

  private

  # @param library [Library]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#805
  def async_library_map(library); end

  # @return [Cataloger]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#669
  def cataloger; end

  # @param uri [String]
  # @param change [Hash]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#712
  def check_diff(uri, change); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#799
  def client_supports_progress?; end

  # @return [Diagnoser]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#664
  def diagnoser; end

  # source://solargraph//lib/solargraph/language_server/host.rb#821
  def do_async_library_map(library, uuid = T.unsafe(nil)); end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#740
  def dynamic_capability_options; end

  # @param params [Hash]
  # @return [Source::Updater]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#690
  def generate_updater(params); end

  # @return [MessageWorker]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#659
  def message_worker; end

  # @param path [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#683
  def normalize_separators(path); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#795
  def prepare_rename?; end

  # A hash of client requests by ID. The host uses this to keep track of
  # pending responses.
  #
  # @return [Hash{Integer => Hash}]
  #
  # source://solargraph//lib/solargraph/language_server/host.rb#677
  def requests; end
end

# An asynchronous library cataloging handler.
class Solargraph::LanguageServer::Host::Cataloger
  # @return [Cataloger] a new instance of Cataloger
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#9
  def initialize(host); end

  # Start the catalog thread.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#31
  def start; end

  # Stop the catalog thread.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#17
  def stop; end

  # True if the cataloger is stopped.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#24
  def stopped?; end

  # Perform cataloging.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#45
  def tick; end

  private

  # @return [Host]
  #
  # source://solargraph//lib/solargraph/language_server/host/cataloger.rb#52
  def host; end
end

# An asynchronous diagnosis reporter.
class Solargraph::LanguageServer::Host::Diagnoser
  # @param host [Host]
  # @return [Diagnoser] a new instance of Diagnoser
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#10
  def initialize(host); end

  # Schedule a file to be diagnosed.
  #
  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#21
  def schedule(uri); end

  # Start the diagnosis thread.
  #
  # @return [self]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#42
  def start; end

  # Stop the diagnosis thread.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#28
  def stop; end

  # True is the diagnoser is stopped.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#35
  def stopped?; end

  # Perform diagnoses.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#57
  def tick; end

  private

  # @return [Host]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#79
  def host; end

  # @return [Mutex]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#82
  def mutex; end

  # @return [Array]
  #
  # source://solargraph//lib/solargraph/language_server/host/diagnoser.rb#85
  def queue; end
end

# Methods for associating sources with libraries via URIs.
module Solargraph::LanguageServer::Host::Dispatch
  # Find an explicit library match for the given URI. An explicit match
  # means the libary's workspace includes the file.
  #
  # If a matching library is found, the source corresponding to the URI
  # gets attached to it.
  #
  # @param uri [String]
  # @raise [FileNotFoundError] if the source could not be attached.
  # @return [Library, nil]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#59
  def explicit_library_for(uri); end

  # @return [Library]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#105
  def generic_library; end

  # Get a generic library for the given URI and attach the corresponding
  # source.
  #
  # @param uri [String]
  # @raise [FileNotFoundError] if the source could not be attached.
  # @return [Library]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#99
  def generic_library_for(uri); end

  # Find an implicit library match for the given URI. An implicit match
  # means the file is located inside the library's workspace directory,
  # regardless of whether the workspace is configured to include it.
  #
  # If a matching library is found, the source corresponding to the URI
  # gets attached to it.
  #
  # @param uri [String]
  # @raise [FileNotFoundError] if the source could not be attached.
  # @return [Library, nil]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#81
  def implicit_library_for(uri); end

  # @return [Array<Library>]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#19
  def libraries; end

  # Find the best libary match for the given URI.
  #
  # @param uri [String]
  # @return [Library]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#40
  def library_for(uri); end

  # @return [Sources]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#10
  def sources; end

  # The Sources observer callback that merges a source into the host's
  # libraries when it gets updated.
  #
  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/dispatch.rb#28
  def update_libraries(uri); end
end

# A serial worker Thread to handle message.
#
# this make check pending message possible, and maybe cancelled to speedup process
class Solargraph::LanguageServer::Host::MessageWorker
  # @param host [Host]
  # @return [MessageWorker] a new instance of MessageWorker
  #
  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#11
  def initialize(host); end

  # pending handle messages
  #
  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#19
  def messages; end

  # @param message [Hash] The message should be handle. will pass back to Host#receive
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#33
  def queue(message); end

  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#40
  def start; end

  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#27
  def stop; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#23
  def stopped?; end

  # source://solargraph//lib/solargraph/language_server/host/message_worker.rb#48
  def tick; end
end

# A Host class for managing sources.
class Solargraph::LanguageServer::Host::Sources
  include ::Observable
  include ::Solargraph::LanguageServer::UriHelpers

  # @return [Sources] a new instance of Sources
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#14
  def initialize; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#47
  def add_uri(uri); end

  # @param uri [String]
  # @param updater [Source::Updater]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#97
  def async_update(uri, updater); end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#133
  def clear; end

  # Close the source with the given URI.
  #
  # @param uri [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#121
  def close(uri); end

  # Find the source with the given URI.
  #
  # @param uri [String]
  # @raise [FileNotFoundError] if the URI does not match an open source.
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#113
  def find(uri); end

  # True if a source with given URI is currently open.
  #
  # @param uri [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#128
  def include?(uri); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#53
  def next_uri; end

  # Open a source.
  #
  # @param uri [String]
  # @param text [String]
  # @param version [Integer]
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#69
  def open(uri, text, version); end

  # source://solargraph//lib/solargraph/language_server/host/sources.rb#75
  def open_from_disk(uri); end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#25
  def start; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#59
  def stop; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#20
  def stopped?; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#34
  def tick; end

  # Update an existing source.
  #
  # @param uri [String]
  # @param updater [Source::Updater]
  # @raise [FileNotFoundError] if the URI does not match an open source.
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#87
  def update(uri, updater); end

  private

  # @return [Mutex]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#145
  def mutex; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#140
  def open_source_hash; end

  # An array of source URIs that are waiting to finish synchronizing.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/language_server/host/sources.rb#150
  def queue; end
end

# The Message namespace contains classes that implement language server
# protocol methods.
module Solargraph::LanguageServer::Message
  class << self
    # Register a method name and message for handling by the language
    # server.
    #
    # @example
    #   Message.register 'initialize', Solargraph::Message::Initialize
    # @param path [String] The method name
    # @param message_class [Class<Message::Base>] The message class
    # @return [void]
    #
    # source://solargraph//lib/solargraph/language_server/message.rb#34
    def register(path, message_class); end

    # @param path [String]
    # @return [Class<Solargraph::LanguageServer::Message::Base>]
    #
    # source://solargraph//lib/solargraph/language_server/message.rb#40
    def select(path); end

    private

    # @return [Hash{String => Class<Message::Base>}]
    #
    # source://solargraph//lib/solargraph/language_server/message.rb#53
    def method_map; end
  end
end

class Solargraph::LanguageServer::Message::Base
  # @param host [Solargraph::LanguageServer::Host]
  # @param request [Hash]
  # @return [Base] a new instance of Base
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#30
  def initialize(host, request); end

  # @return [Hash, nil]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#26
  def error; end

  # @return [Solargraph::LanguageServer::Host]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#8
  def host; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#11
  def id; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#17
  def method; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#20
  def params; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#40
  def post_initialize; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#43
  def process; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#14
  def request; end

  # @return [Hash, Array, nil]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#23
  def result; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#62
  def send_response; end

  # @param code [Integer] See Solargraph::LanguageServer::ErrorCodes
  # @param message [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#54
  def set_error(code, message); end

  # @param data [Hash, Array, nil]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/base.rb#47
  def set_result(data); end
end

class Solargraph::LanguageServer::Message::CancelRequest < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/cancel_request.rb#7
  def process; end
end

module Solargraph::LanguageServer::Message::CompletionItem; end

# completionItem/resolve message handler
class Solargraph::LanguageServer::Message::CompletionItem::Resolve < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/completion_item/resolve.rb#10
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/completion_item/resolve.rb#41
  def join_docs(pins); end

  # @param text [String]
  # @return [Hash{Symbol => String}]
  #
  # source://solargraph//lib/solargraph/language_server/message/completion_item/resolve.rb#33
  def markup_content(text); end

  # @param pins [Array<Pin::Base>]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/message/completion_item/resolve.rb#19
  def merge(pins); end
end

class Solargraph::LanguageServer::Message::ExitNotification < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/exit_notification.rb#7
  def process; end
end

# Messages in the Extended module are custom to the Solargraph
# implementation of the language server. In the protocol, the method
# names should start with "$/" so clients that don't recognize them can
# ignore them, as per the LSP specification.
module Solargraph::LanguageServer::Message::Extended; end

# Check if a more recent version of the Solargraph gem is available.
# Notify the client when an update exists. If the `verbose` parameter
# is true, notify the client when the gem is up to date.
class Solargraph::LanguageServer::Message::Extended::CheckGemVersion < ::Solargraph::LanguageServer::Message::Base
  # @return [CheckGemVersion] a new instance of CheckGemVersion
  #
  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#24
  def initialize(host, request, current: T.unsafe(nil), available: T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#30
  def process; end

  private

  # @return [Gem::Version]
  #
  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#69
  def available; end

  # @return [Gem::Version]
  #
  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#66
  def current; end

  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#95
  def error; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#90
  def fetched?; end

  class << self
    # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#14
    def fetcher; end

    # source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#18
    def fetcher=(obj); end
  end
end

# source://solargraph//lib/solargraph/language_server/message/extended/check_gem_version.rb#22
Solargraph::LanguageServer::Message::Extended::CheckGemVersion::GEM_ZERO = T.let(T.unsafe(nil), Gem::Version)

class Solargraph::LanguageServer::Message::Extended::Document < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/extended/document.rb#8
  def process; end
end

# Update YARD documentation for installed gems. If the `rebuild`
# parameter is true, rebuild existing yardocs.
class Solargraph::LanguageServer::Message::Extended::DocumentGems < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/extended/document_gems.rb#13
  def process; end
end

# Update core Ruby documentation.
class Solargraph::LanguageServer::Message::Extended::DownloadCore < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/extended/download_core.rb#12
  def process; end
end

# Update YARD documentation for installed gems. If the `rebuild`
# parameter is true, rebuild existing yardocs.
class Solargraph::LanguageServer::Message::Extended::Environment < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/extended/environment.rb#11
  def process; end
end

class Solargraph::LanguageServer::Message::Extended::Search < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/extended/search.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::Initialize < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#7
  def process; end

  private

  # @param section [String]
  # @param capability [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#151
  def dynamic_registration_for?(section, capability); end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#64
  def static_code_action; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#54
  def static_completion; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#115
  def static_definitions; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#95
  def static_document_formatting; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#102
  def static_document_symbols; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#135
  def static_folding_range; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#142
  def static_highlights; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#88
  def static_hover; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#79
  def static_on_type_formatting; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#128
  def static_references; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#122
  def static_rename; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#71
  def static_signature_help; end

  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#109
  def static_workspace_symbols; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/language_server/message/initialize.rb#47
  def support_workspace_folders?; end
end

class Solargraph::LanguageServer::Message::Initialized < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/initialized.rb#7
  def process; end
end

class Solargraph::LanguageServer::Message::MethodNotFound < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/method_not_found.rb#7
  def process; end
end

class Solargraph::LanguageServer::Message::MethodNotImplemented < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/method_not_implemented.rb#7
  def process; end
end

class Solargraph::LanguageServer::Message::Shutdown < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/shutdown.rb#7
  def process; end
end

module Solargraph::LanguageServer::Message::TextDocument; end

class Solargraph::LanguageServer::Message::TextDocument::Base < ::Solargraph::LanguageServer::Message::Base
  include ::Solargraph::LanguageServer::UriHelpers

  # Returns the value of attribute filename.
  #
  # source://solargraph//lib/solargraph/language_server/message/text_document/base.rb#10
  def filename; end

  # source://solargraph//lib/solargraph/language_server/message/text_document/base.rb#12
  def post_initialize; end
end

class Solargraph::LanguageServer::Message::TextDocument::Completion < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # @param incomplete [Boolean]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/language_server/message/text_document/completion.rb#49
  def empty_result(incomplete = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/language_server/message/text_document/completion.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::Definition < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/definition.rb#5
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/text_document/definition.rb#13
  def code_location; end

  # source://solargraph//lib/solargraph/language_server/message/text_document/definition.rb#24
  def require_location; end
end

class Solargraph::LanguageServer::Message::TextDocument::DidChange < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/did_change.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::DidClose < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/did_close.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::DidOpen < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/did_open.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::DidSave < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/did_save.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::DocumentHighlight < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/document_highlight.rb#5
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::DocumentSymbol < ::Solargraph::LanguageServer::Message::Base
  include ::Solargraph::LanguageServer::UriHelpers

  # source://solargraph//lib/solargraph/language_server/message/text_document/document_symbol.rb#6
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::FoldingRange < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/folding_range.rb#10
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::Formatting < ::Solargraph::LanguageServer::Message::TextDocument::Base
  include ::Solargraph::Diagnostics::RubocopHelpers

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#13
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#54
  def cli_args(file_uri, config); end

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#47
  def config_for(file_uri); end

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#81
  def cop_list(value); end

  # @param original [String]
  # @param result [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#90
  def format(original, result); end

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#71
  def formatter_class(config); end

  # source://solargraph//lib/solargraph/language_server/message/text_document/formatting.rb#36
  def log_corrections(corrections); end
end

class Solargraph::LanguageServer::Message::TextDocument::Hover < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/hover.rb#8
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/text_document/hover.rb#40
  def contents_or_nil(contents); end
end

class Solargraph::LanguageServer::Message::TextDocument::OnTypeFormatting < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/on_type_formatting.rb#8
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::PrepareRename < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/prepare_rename.rb#5
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::References < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/references.rb#5
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::Rename < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/rename.rb#5
  def process; end
end

class Solargraph::LanguageServer::Message::TextDocument::SignatureHelp < ::Solargraph::LanguageServer::Message::TextDocument::Base
  # source://solargraph//lib/solargraph/language_server/message/text_document/signature_help.rb#8
  def process; end
end

module Solargraph::LanguageServer::Message::Workspace; end

class Solargraph::LanguageServer::Message::Workspace::DidChangeConfiguration < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_configuration.rb#5
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_configuration.rb#14
  def register_from_options; end
end

class Solargraph::LanguageServer::Message::Workspace::DidChangeWatchedFiles < ::Solargraph::LanguageServer::Message::Base
  include ::Solargraph::LanguageServer::UriHelpers

  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_watched_files.rb#11
  def process; end
end

# source://solargraph//lib/solargraph/language_server/message/workspace/did_change_watched_files.rb#6
Solargraph::LanguageServer::Message::Workspace::DidChangeWatchedFiles::CHANGED = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/message/workspace/did_change_watched_files.rb#5
Solargraph::LanguageServer::Message::Workspace::DidChangeWatchedFiles::CREATED = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/message/workspace/did_change_watched_files.rb#7
Solargraph::LanguageServer::Message::Workspace::DidChangeWatchedFiles::DELETED = T.let(T.unsafe(nil), Integer)

class Solargraph::LanguageServer::Message::Workspace::DidChangeWorkspaceFolders < ::Solargraph::LanguageServer::Message::Base
  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_workspace_folders.rb#5
  def process; end

  private

  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_workspace_folders.rb#12
  def add_folders; end

  # source://solargraph//lib/solargraph/language_server/message/workspace/did_change_workspace_folders.rb#17
  def remove_folders; end
end

class Solargraph::LanguageServer::Message::Workspace::WorkspaceSymbol < ::Solargraph::LanguageServer::Message::Base
  include ::Solargraph::LanguageServer::UriHelpers

  # source://solargraph//lib/solargraph/language_server/message/workspace/workspace_symbol.rb#6
  def process; end
end

# The MessageType constants from the language server specification.
module Solargraph::LanguageServer::MessageTypes; end

# source://solargraph//lib/solargraph/language_server/message_types.rb#8
Solargraph::LanguageServer::MessageTypes::ERROR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/message_types.rb#10
Solargraph::LanguageServer::MessageTypes::INFO = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/message_types.rb#11
Solargraph::LanguageServer::MessageTypes::LOG = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/message_types.rb#9
Solargraph::LanguageServer::MessageTypes::WARNING = T.let(T.unsafe(nil), Integer)

class Solargraph::LanguageServer::Request
  # @param id [Integer]
  # @param &block The block that processes the client's response
  # @return [Request] a new instance of Request
  #
  # source://solargraph//lib/solargraph/language_server/request.rb#8
  def initialize(id, &block); end

  # @param result [Object]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/request.rb#15
  def process(result); end

  # source://solargraph//lib/solargraph/language_server/request.rb#19
  def send_response; end
end

# The SymbolKind constants for the language server protocol.
module Solargraph::LanguageServer::SymbolKinds; end

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#25
Solargraph::LanguageServer::SymbolKinds::ARRAY = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#24
Solargraph::LanguageServer::SymbolKinds::BOOLEAN = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#12
Solargraph::LanguageServer::SymbolKinds::CLASS = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#21
Solargraph::LanguageServer::SymbolKinds::CONSTANT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#16
Solargraph::LanguageServer::SymbolKinds::CONSTRUCTOR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#17
Solargraph::LanguageServer::SymbolKinds::ENUM = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#29
Solargraph::LanguageServer::SymbolKinds::ENUM_MEMBER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#31
Solargraph::LanguageServer::SymbolKinds::EVENT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#15
Solargraph::LanguageServer::SymbolKinds::FIELD = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#8
Solargraph::LanguageServer::SymbolKinds::FILE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#19
Solargraph::LanguageServer::SymbolKinds::FUNCTION = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#18
Solargraph::LanguageServer::SymbolKinds::INTERFACE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#27
Solargraph::LanguageServer::SymbolKinds::KEY = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#13
Solargraph::LanguageServer::SymbolKinds::METHOD = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#9
Solargraph::LanguageServer::SymbolKinds::MODULE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#10
Solargraph::LanguageServer::SymbolKinds::NAMESPACE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#28
Solargraph::LanguageServer::SymbolKinds::NULL = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#23
Solargraph::LanguageServer::SymbolKinds::NUMBER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#26
Solargraph::LanguageServer::SymbolKinds::OBJECT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#32
Solargraph::LanguageServer::SymbolKinds::OPERATOR = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#11
Solargraph::LanguageServer::SymbolKinds::PACKAGE = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#14
Solargraph::LanguageServer::SymbolKinds::PROPERTY = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#22
Solargraph::LanguageServer::SymbolKinds::STRING = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#30
Solargraph::LanguageServer::SymbolKinds::STRUCT = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#33
Solargraph::LanguageServer::SymbolKinds::TYPE_PARAMETER = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/language_server/symbol_kinds.rb#20
Solargraph::LanguageServer::SymbolKinds::VARIABLE = T.let(T.unsafe(nil), Integer)

# The Transport namespace contains concrete implementations of
# communication protocols for language servers.
module Solargraph::LanguageServer::Transport; end

# A common module for running language servers in Backport.
module Solargraph::LanguageServer::Transport::Adapter
  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#21
  def closing; end

  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#11
  def opening; end

  # @param data [String]
  #
  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#26
  def receiving(data); end

  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#30
  def update; end

  private

  # @param request [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#43
  def process(request); end

  # source://solargraph//lib/solargraph/language_server/transport/adapter.rb#47
  def shutdown; end
end

class Solargraph::LanguageServer::Transport::DataReader
  # @return [DataReader] a new instance of DataReader
  #
  # source://solargraph//lib/solargraph/language_server/transport/data_reader.rb#9
  def initialize; end

  # Process raw data received from the client. The data will be parsed
  # into messages based on the JSON-RPC protocol. Each message will be
  # passed to the block declared via set_message_handler. Incomplete data
  # will be buffered and subsequent data will be appended to the buffer.
  #
  # @param data [String]
  #
  # source://solargraph//lib/solargraph/language_server/transport/data_reader.rb#29
  def receive(data); end

  # Declare a block to be executed for each message received from the
  # client.
  #
  # @yieldparam The [Hash] message received from the client
  #
  # source://solargraph//lib/solargraph/language_server/transport/data_reader.rb#19
  def set_message_handler(&block); end

  private

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/transport/data_reader.rb#56
  def parse_message_from_buffer; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/language_server/transport/data_reader.rb#43
  def prepare_to_parse_message; end
end

# Methods to handle conversions between file URIs and paths.
module Solargraph::LanguageServer::UriHelpers
  private

  # Decode text from a URI path component in LSP.
  #
  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#44
  def decode(text); end

  # Encode text to be used as a URI path component in LSP.
  #
  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#32
  def encode(text); end

  # Convert a file path to a URI.
  #
  # @param file [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#24
  def file_to_uri(file); end

  # Convert a file URI to a path.
  #
  # @param uri [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#16
  def uri_to_file(uri); end

  class << self
    # Decode text from a URI path component in LSP.
    #
    # @param text [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#44
    def decode(text); end

    # Encode text to be used as a URI path component in LSP.
    #
    # @param text [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#32
    def encode(text); end

    # Convert a file path to a URI.
    #
    # @param file [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#24
    def file_to_uri(file); end

    # Convert a file URI to a path.
    #
    # @param uri [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/language_server/uri_helpers.rb#16
    def uri_to_file(uri); end
  end
end

# A Library handles coordination between a Workspace and an ApiMap.
class Solargraph::Library
  include ::Solargraph::Logging

  # @param workspace [Solargraph::Workspace]
  # @param name [String, nil]
  # @return [Library] a new instance of Library
  #
  # source://solargraph//lib/solargraph/library.rb#22
  def initialize(workspace = T.unsafe(nil), name = T.unsafe(nil)); end

  # Attach a source to the library.
  #
  # The attached source does not need to be a part of the workspace. The
  # library will include it in the ApiMap while it's attached. Only one
  # source can be attached to the library at a time.
  #
  # @param source [Source, nil]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/library.rb#49
  def attach(source); end

  # True if the specified file is currently attached.
  #
  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/library.rb#67
  def attached?(filename); end

  # source://solargraph//lib/solargraph/library.rb#385
  def bench; end

  # Update the ApiMap from the library's workspace and open files.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/library.rb#371
  def catalog; end

  # Close a file in the library. Closing a file will make it unavailable for
  # checkout although it may still exist in the workspace.
  #
  # @param filename [String]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/library.rb#148
  def close(filename); end

  # Get completion suggestions at the specified file and location.
  #
  # @param filename [String] The file to analyze
  # @param line [Integer] The zero-based line number
  # @param column [Integer] The zero-based column number
  # @return [SourceMap::Completion]
  # @todo Take a Location instead of filename/line/column
  #
  # source://solargraph//lib/solargraph/library.rb#163
  def completions_at(filename, line, column); end

  # True if the specified file is included in the workspace (but not
  # necessarily open).
  #
  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/library.rb#87
  def contain?(filename); end

  # Create a source to be added to the workspace. The file is ignored if it is
  # neither open in the library nor included in the workspace.
  #
  # @param filename [String]
  # @param text [String] The contents of the file
  # @return [Boolean] True if the file was added to the workspace.
  #
  # source://solargraph//lib/solargraph/library.rb#97
  def create(filename, text); end

  # Create a file source from a file on disk. The file is ignored if it is
  # neither open in the library nor included in the workspace.
  #
  # @param filename [String]
  # @return [Boolean] True if the file was added to the workspace.
  #
  # source://solargraph//lib/solargraph/library.rb#114
  def create_from_disk(filename); end

  # @return [Source, nil]
  #
  # source://solargraph//lib/solargraph/library.rb#18
  def current; end

  # Get definition suggestions for the expression at the specified file and
  # location.
  #
  # @param filename [String] The file to analyze
  # @param line [Integer] The zero-based line number
  # @param column [Integer] The zero-based column number
  # @return [Array<Solargraph::Pin::Base>]
  # @todo Take filename/position instead of filename/line/column
  #
  # source://solargraph//lib/solargraph/library.rb#179
  def definitions_at(filename, line, column); end

  # Delete a file from the library. Deleting a file will make it unavailable
  # for checkout and optionally remove it from the workspace unless the
  # workspace configuration determines that it should still exist.
  #
  # @param filename [String]
  # @return [Boolean] True if the file was deleted
  #
  # source://solargraph//lib/solargraph/library.rb#133
  def delete(filename); end

  # Detach the specified file if it is currently attached to the library.
  #
  # @param filename [String]
  # @return [Boolean] True if the specified file was detached
  #
  # source://solargraph//lib/solargraph/library.rb#76
  def detach(filename); end

  # Get diagnostics about a file.
  #
  # @param filename [String]
  # @return [Array<Hash>]
  #
  # source://solargraph//lib/solargraph/library.rb#338
  def diagnose(filename); end

  # @param query [String]
  # @return [Array<YARD::CodeObjects::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#285
  def document(query); end

  # Get an array of document symbols.
  #
  # Document symbols are composed of namespace, method, and constant pins.
  # The results of this query are appropriate for building the response to a
  # textDocument/documentSymbol message in the language server protocol.
  #
  # @param filename [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#311
  def document_symbols(filename); end

  # source://solargraph//lib/solargraph/library.rb#465
  def external_requires; end

  # Get an array of foldable ranges for the specified file.
  #
  # @deprecated The library should not need to handle folding ranges. The
  #   source itself has all the information it needs.
  # @param filename [String]
  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/library.rb#400
  def folding_ranges(filename); end

  # Get an array of pins that match a path.
  #
  # @param path [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#279
  def get_path_pins(path); end

  # source://solargraph//lib/solargraph/library.rb#28
  def inspect; end

  # Get the pins at the specified location or nil if the pin does not exist.
  #
  # @param location [Location]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#256
  def locate_pins(location); end

  # source://solargraph//lib/solargraph/library.rb#260
  def locate_ref(location); end

  # source://solargraph//lib/solargraph/library.rb#453
  def map!; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/library.rb#433
  def mapped?; end

  # Try to merge a source into the library's workspace. If the workspace is
  # not configured to include the source, it gets ignored.
  #
  # @param source [Source]
  # @return [Boolean] True if the source was merged into the workspace.
  #
  # source://solargraph//lib/solargraph/library.rb#418
  def merge(source); end

  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/library.rb#15
  def name; end

  # source://solargraph//lib/solargraph/library.rb#437
  def next_map; end

  # True if the specified file is currently attached.
  #
  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/library.rb#67
  def open?(filename); end

  # @param path [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#317
  def path_pins(path); end

  # source://solargraph//lib/solargraph/library.rb#461
  def pins; end

  # Get an array of all symbols in the workspace that match the query.
  #
  # @param query [String]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/library.rb#299
  def query_symbols(query); end

  # Get the current text of a file in the library.
  #
  # @param filename [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/library.rb#329
  def read_text(filename); end

  # @param filename [String]
  # @param line [Integer]
  # @param column [Integer]
  # @param strip [Boolean] Strip special characters from variable names
  # @param only [Boolean] Search for references in the current file only
  # @return [Array<Solargraph::Range>]
  # @todo Take a Location instead of filename/line/column
  #
  # source://solargraph//lib/solargraph/library.rb#222
  def references_from(filename, line, column, strip: T.unsafe(nil), only: T.unsafe(nil)); end

  # @param query [String]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/library.rb#291
  def search(query); end

  # Get signature suggestions for the method at the specified file and
  # location.
  #
  # @param filename [String] The file to analyze
  # @param line [Integer] The zero-based line number
  # @param column [Integer] The zero-based column number
  # @return [Array<Solargraph::Pin::Base>]
  # @todo Take filename/position instead of filename/line/column
  #
  # source://solargraph//lib/solargraph/library.rb#209
  def signatures_at(filename, line, column); end

  # source://solargraph//lib/solargraph/library.rb#429
  def source_map_hash; end

  # source://solargraph//lib/solargraph/library.rb#321
  def source_maps; end

  # True if the ApiMap is up to date with the library's workspace and open
  # files.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/library.rb#37
  def synchronized?; end

  # @return [Solargraph::Workspace]
  #
  # source://solargraph//lib/solargraph/library.rb#12
  def workspace; end

  private

  # @return [ApiMap]
  #
  # source://solargraph//lib/solargraph/library.rb#494
  def api_map; end

  # source://solargraph//lib/solargraph/library.rb#377
  def catalog_inlock; end

  # @param source_map [SourceMap]
  #
  # source://solargraph//lib/solargraph/library.rb#476
  def find_external_requires(source_map); end

  # source://solargraph//lib/solargraph/library.rb#512
  def handle_file_not_found(filename, error); end

  # source://solargraph//lib/solargraph/library.rb#521
  def maybe_map(source); end

  # @return [Mutex]
  #
  # source://solargraph//lib/solargraph/library.rb#489
  def mutex; end

  # Get the source for an open file or create a new source if the file
  # exists on disk. Sources created from disk are not added to the open
  # workspace files, i.e., the version on disk remains the authoritative
  # version.
  #
  # @param filename [String]
  # @raise [FileNotFoundError] if the file does not exist
  # @return [Solargraph::Source]
  #
  # source://solargraph//lib/solargraph/library.rb#506
  def read(filename); end

  # source://solargraph//lib/solargraph/library.rb#471
  def source_map_external_require_hash; end

  class << self
    # Create a library from a directory.
    #
    # @param directory [String] The path to be used for the workspace
    # @param name [String, nil]
    # @return [Solargraph::Library]
    #
    # source://solargraph//lib/solargraph/library.rb#409
    def load(directory = T.unsafe(nil), name = T.unsafe(nil)); end
  end
end

# A section of text identified by its filename and range.
class Solargraph::Location
  # @param filename [String]
  # @param range [Solargraph::Range]
  # @return [Location] a new instance of Location
  #
  # source://solargraph//lib/solargraph/location.rb#15
  def initialize(filename, range); end

  # source://solargraph//lib/solargraph/location.rb#28
  def ==(other); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/location.rb#8
  def filename; end

  # source://solargraph//lib/solargraph/location.rb#33
  def inspect; end

  # @return [Solargraph::Range]
  #
  # source://solargraph//lib/solargraph/location.rb#11
  def range; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/location.rb#21
  def to_hash; end
end

module Solargraph::Logging
  private

  # @return [Logger]
  #
  # source://solargraph//lib/solargraph/logging.rb#23
  def logger; end

  class << self
    # @return [Logger]
    #
    # source://solargraph//lib/solargraph/logging.rb#23
    def logger; end
  end
end

# source://solargraph//lib/solargraph/logging.rb#7
Solargraph::Logging::DEFAULT_LOG_LEVEL = T.let(T.unsafe(nil), Integer)

# source://solargraph//lib/solargraph/logging.rb#9
Solargraph::Logging::LOG_LEVELS = T.let(T.unsafe(nil), Hash)

class Solargraph::Page
  # @param directory [String]
  # @return [Page] a new instance of Page
  #
  # source://solargraph//lib/solargraph/page.rb#44
  def initialize(directory = T.unsafe(nil)); end

  # @param template [String]
  # @param layout [Boolean]
  # @param locals [Hash]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/page.rb#68
  def render(template, layout: T.unsafe(nil), locals: T.unsafe(nil)); end

  class << self
    # @param directories [Array<String>]
    # @param name [String]
    # @raise [FileNotFoundError]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/page.rb#75
    def select_template(directories, name); end
  end
end

class Solargraph::Page::Binder < ::OpenStruct
  # @param locals [Hash]
  # @param render_method [Proc]
  # @return [Binder] a new instance of Binder
  #
  # source://solargraph//lib/solargraph/page.rb#13
  def initialize(locals, render_method); end

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/page.rb#31
  def escape(text); end

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/page.rb#25
  def htmlify(text); end

  # @param code [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/page.rb#37
  def ruby_to_html(code); end
end

module Solargraph::Parser
  extend ::Solargraph::Parser::Rubyvm::ClassMethods

  class << self
    # True if the parser can use RubyVM.
    #
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser.rb#15
    def rubyvm?; end
  end
end

class Solargraph::Parser::CommentRipper < ::Ripper::SexpBuilderPP
  # @return [CommentRipper] a new instance of CommentRipper
  #
  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#6
  def initialize(src, filename = T.unsafe(nil), lineno = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#12
  def on_comment(*args); end

  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#31
  def on_embdoc(*args); end

  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#24
  def on_embdoc_beg(*args); end

  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#38
  def on_embdoc_end(*args); end

  # source://solargraph//lib/solargraph/parser/comment_ripper.rb#45
  def parse; end
end

module Solargraph::Parser::Legacy; end

module Solargraph::Parser::Legacy::ClassMethods
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#83
  def chain(*args); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#87
  def chain_string(*args); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#95
  def infer_literal_node_type(node); end

  # @param name [String]
  # @param top [AST::Node]
  # @return [Array<AST::Node>]
  #
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#74
  def inner_node_references(name, top); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#103
  def is_ast_node?(node); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#42
  def map(source); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#107
  def node_range(node); end

  # @param code [String]
  # @param filename [String, nil]
  # @param line [Integer]
  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#24
  def parse(code, filename = T.unsafe(nil), line = T.unsafe(nil)); end

  # @param code [String]
  # @param filename [String]
  # @return [Array(Parser::AST::Node, Array<Parser::Source::Comment>)]
  #
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#10
  def parse_with_comments(code, filename = T.unsafe(nil)); end

  # @return [Parser::Base]
  #
  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#33
  def parser; end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#91
  def process_node(*args); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#50
  def references(source, name); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#46
  def returns_from(node); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#113
  def string_ranges(node); end

  # source://solargraph//lib/solargraph/parser/legacy/class_methods.rb#99
  def version; end
end

# A custom builder for source parsers that ignores character encoding
# issues in literal strings.
class Solargraph::Parser::Legacy::FlawedBuilder < ::Parser::Builders::Default
  # source://solargraph//lib/solargraph/parser/legacy/flawed_builder.rb#10
  def string_value(token); end
end

# A factory for generating chains from nodes.
class Solargraph::Parser::Legacy::NodeChainer
  include ::Solargraph::Parser::Legacy::NodeMethods

  # @param node [Parser::AST::Node]
  # @param filename [String]
  # @return [NodeChainer] a new instance of NodeChainer
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#14
  def initialize(node, filename = T.unsafe(nil), in_block = T.unsafe(nil)); end

  # @return [Source::Chain]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#21
  def chain; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#142
  def block_passed?(node); end

  # @param n [Parser::AST::Node]
  # @return [Array<Chain::Link>]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#48
  def generate_links(n); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#135
  def hash_is_splatted?(node); end

  class << self
    # @param node [Parser::AST::Node]
    # @param filename [String]
    # @return [Source::Chain]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#30
    def chain(node, filename = T.unsafe(nil), in_block = T.unsafe(nil)); end

    # @param code [String]
    # @return [Source::Chain]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#36
    def load_string(code); end
  end
end

# source://solargraph//lib/solargraph/parser/legacy/node_chainer.rb#10
Solargraph::Parser::Legacy::NodeChainer::Chain = Solargraph::Source::Chain

module Solargraph::Parser::Legacy::NodeMethods
  private

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#133
  def any_splatted_call?(nodes); end

  # @todo Temporarily here for testing. Move to Solargraph::Parser.
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#138
  def call_nodes_from(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#113
  def const_nodes_from(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#99
  def convert_hash(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#78
  def drill_signature(node, signature); end

  # @param cursor [Solargraph::Source::Cursor]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#180
  def find_recipient_node(cursor); end

  # @param node [Parser::AST::Node]
  # @return [Position]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#74
  def get_node_end_position(node); end

  # @param node [Parser::AST::Node]
  # @return [Position]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#68
  def get_node_start_position(node); end

  # @param node [Parser::AST::Node]
  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#39
  def infer_literal_node_type(node); end

  # @param node [Parser::AST::Node]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#19
  def pack_name(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#214
  def repaired_find_recipient_node(cursor); end

  # Find all the nodes within the provided node that potentially return a
  # value.
  #
  # The node parameter typically represents a method's logic, e.g., the
  # second child (after the :args node) of a :def node. A simple one-line
  # method would typically return itself, while a node with conditions
  # would return the resulting node from each conditional branch. Nodes
  # that follow a :return node are assumed to be unreachable. Nil values
  # are converted to nil node types.
  #
  # @param node [Parser::AST::Node]
  # @return [Array<Parser::AST::Node>]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#175
  def returns_from(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#128
  def splatted_call?(node); end

  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#124
  def splatted_hash?(node); end

  # @param node [Parser::AST::Node]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#13
  def unpack_name(node); end

  class << self
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#133
    def any_splatted_call?(nodes); end

    # @todo Temporarily here for testing. Move to Solargraph::Parser.
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#138
    def call_nodes_from(node); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#113
    def const_nodes_from(node); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#99
    def convert_hash(node); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#78
    def drill_signature(node, signature); end

    # @param cursor [Solargraph::Source::Cursor]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#180
    def find_recipient_node(cursor); end

    # @param node [Parser::AST::Node]
    # @return [Position]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#74
    def get_node_end_position(node); end

    # @param node [Parser::AST::Node]
    # @return [Position]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#68
    def get_node_start_position(node); end

    # @param node [Parser::AST::Node]
    # @return [String, nil]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#39
    def infer_literal_node_type(node); end

    # @param node [Parser::AST::Node]
    # @return [Array<String>]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#19
    def pack_name(node); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#214
    def repaired_find_recipient_node(cursor); end

    # Find all the nodes within the provided node that potentially return a
    # value.
    #
    # The node parameter typically represents a method's logic, e.g., the
    # second child (after the :args node) of a :def node. A simple one-line
    # method would typically return itself, while a node with conditions
    # would return the resulting node from each conditional branch. Nodes
    # that follow a :return node are assumed to be unreachable. Nil values
    # are converted to nil node types.
    #
    # @param node [Parser::AST::Node]
    # @return [Array<Parser::AST::Node>]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#175
    def returns_from(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#128
    def splatted_call?(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#124
    def splatted_hash?(node); end

    # @param node [Parser::AST::Node]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#13
    def unpack_name(node); end
  end
end

module Solargraph::Parser::Legacy::NodeMethods::DeepInference
  class << self
    # @param node [Parser::AST::Node]
    # @return [Array<Parser::AST::Node>]
    #
    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#228
    def get_return_nodes(node); end

    private

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#260
    def get_return_nodes_from_children(parent); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#281
    def get_return_nodes_only(parent); end

    # source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#299
    def reduce_to_value_nodes(nodes); end
  end
end

# source://solargraph//lib/solargraph/parser/legacy/node_methods.rb#111
Solargraph::Parser::Legacy::NodeMethods::NIL_NODE = T.let(T.unsafe(nil), Parser::AST::Node)

module Solargraph::Parser::Legacy::NodeProcessors; end

class Solargraph::Parser::Legacy::NodeProcessors::AliasNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/alias_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::ArgsNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/args_node.rb#8
  def process; end

  private

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/args_node.rb#28
  def get_decl(node); end
end

class Solargraph::Parser::Legacy::NodeProcessors::BeginNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/begin_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::BlockNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/block_node.rb#10
  def process; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/block_node.rb#33
  def other_class_eval?; end
end

class Solargraph::Parser::Legacy::NodeProcessors::CasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/casgn_node.rb#10
  def process; end

  private

  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/casgn_node.rb#24
  def const_name; end
end

class Solargraph::Parser::Legacy::NodeProcessors::CvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/cvasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::DefNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/def_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::DefsNode < ::Solargraph::Parser::Legacy::NodeProcessors::DefNode
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/defs_node.rb#10
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::GvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/gvasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::IvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/ivasgn_node.rb#10
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::LvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/lvasgn_node.rb#10
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::NamespaceNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/namespace_node.rb#10
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::OrasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/orasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::ResbodyNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/resbody_node.rb#10
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::SclassNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/sclass_node.rb#8
  def process; end
end

class Solargraph::Parser::Legacy::NodeProcessors::SendNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Legacy::NodeMethods

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#10
  def process; end

  private

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#230
  def process_alias_method; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#66
  def process_attribute; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#157
  def process_autoload; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#129
  def process_extend; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#101
  def process_include; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#165
  def process_module_function; end

  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#115
  def process_prepend; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#242
  def process_private_class_method; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#220
  def process_private_constant; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#149
  def process_require; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/send_node.rb#45
  def process_visibility; end
end

class Solargraph::Parser::Legacy::NodeProcessors::SymNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/legacy/node_processors/sym_node.rb#8
  def process; end
end

# source://solargraph//lib/solargraph/parser.rb#24
Solargraph::Parser::NodeMethods = Solargraph::Parser::Rubyvm::NodeMethods

# The processor classes used by SourceMap::Mapper to generate pins from
# parser nodes.
module Solargraph::Parser::NodeProcessor
  class << self
    # @param node [Parser::AST::Node]
    # @param region [Region]
    # @param pins [Array<Pin::Base>]
    # @return [Array(Array<Pin::Base>, Array<Pin::Base>)]
    #
    # source://solargraph//lib/solargraph/parser/node_processor.rb#28
    def process(node, region = T.unsafe(nil), pins = T.unsafe(nil), locals = T.unsafe(nil)); end

    # Register a processor for a node type.
    #
    # @param type [Symbol]
    # @param cls [Class<NodeProcessor::Base>]
    # @return [Class<NodeProcessor::Base>]
    #
    # source://solargraph//lib/solargraph/parser/node_processor.rb#19
    def register(type, cls); end
  end
end

class Solargraph::Parser::NodeProcessor::Base
  # @param node [Parser::AST::Node]
  # @param region [Region]
  # @param pins [Array<Pin::Base>]
  # @return [Base] a new instance of Base
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#22
  def initialize(node, region, pins, locals); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#17
  def locals; end

  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#8
  def node; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#14
  def pins; end

  # Subclasses should override this method to generate new pins.
  #
  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#33
  def process; end

  # @return [Region]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#11
  def region; end

  private

  # @todo Candidate for deprecation
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#66
  def block_pin(position); end

  # @todo Candidate for deprecation
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#71
  def closure_pin(position); end

  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#57
  def comments_for(node); end

  # @param node [Parser::AST::Node]
  # @return [Solargraph::Location]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#52
  def get_node_location(node); end

  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#61
  def named_path_pin(position); end

  # @param subregion [Region]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/node_processor/base.rb#41
  def process_children(subregion = T.unsafe(nil)); end
end

# Data used by the parser to track context at various locations in a
# source.
class Solargraph::Parser::Region
  # @param source [Source]
  # @param namespace [String]
  # @param scope [Symbol]
  # @param visibility [Symbol]
  # @return [Region] a new instance of Region
  #
  # source://solargraph//lib/solargraph/parser/region.rb#28
  def initialize(source: T.unsafe(nil), closure: T.unsafe(nil), scope: T.unsafe(nil), visibility: T.unsafe(nil), lvars: T.unsafe(nil)); end

  # @return [Pin::Closure]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#10
  def closure; end

  # @param node [Parser::AST::Node]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#61
  def code_for(node); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#39
  def filename; end

  # @return [Array<Symbol>]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#22
  def lvars; end

  # @return [Symbol]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#13
  def scope; end

  # @return [Solargraph::Source]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#19
  def source; end

  # Generate a new Region with the provided attribute changes.
  #
  # @param closure [Pin::Closure, nil]
  # @param scope [Symbol, nil]
  # @param visibility [Symbol, nil]
  # @return [Region]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#49
  def update(closure: T.unsafe(nil), scope: T.unsafe(nil), visibility: T.unsafe(nil), lvars: T.unsafe(nil)); end

  # @return [Symbol]
  #
  # source://solargraph//lib/solargraph/parser/region.rb#16
  def visibility; end
end

module Solargraph::Parser::Rubyvm; end

module Solargraph::Parser::Rubyvm::ClassMethods
  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#77
  def chain(*args); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#81
  def chain_string(*args); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#89
  def infer_literal_node_type(node); end

  # @param name [String]
  # @param top [AST::Node]
  # @return [Array<AST::Node>]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#56
  def inner_node_references(name, top); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#97
  def is_ast_node?(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#28
  def map(source); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#72
  def match_rubyvm_node_to_ref(top, name); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#105
  def node_range(node); end

  # @param code [String]
  # @param filename [String, nil]
  # @param line [Integer]
  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#22
  def parse(code, filename = T.unsafe(nil), line = T.unsafe(nil)); end

  # @param code [String]
  # @param filename [String]
  # @return [Array(Parser::AST::Node, Array<Parser::Source::Comment>)]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#10
  def parse_with_comments(code, filename = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#85
  def process_node(*args); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#111
  def recipient_node(tree); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#32
  def references(source, name); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#118
  def string_ranges(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/class_methods.rb#93
  def version; end
end

# A factory for generating chains from nodes.
class Solargraph::Parser::Rubyvm::NodeChainer
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # @param node [Parser::AST::Node]
  # @param filename [String]
  # @return [NodeChainer] a new instance of NodeChainer
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#15
  def initialize(node, filename = T.unsafe(nil), in_block = T.unsafe(nil)); end

  # @return [Source::Chain]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#22
  def chain; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#130
  def block_passed?(node); end

  # @param n [Parser::AST::Node]
  # @return [Array<Chain::Link>]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#49
  def generate_links(n); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#123
  def hash_is_splatted?(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#134
  def node_to_argchains(node); end

  class << self
    # @param node [Parser::AST::Node]
    # @param filename [String]
    # @return [Source::Chain]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#31
    def chain(node, filename = T.unsafe(nil), in_block = T.unsafe(nil)); end

    # @param code [String]
    # @return [Source::Chain]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#37
    def load_string(code); end
  end
end

# source://solargraph//lib/solargraph/parser/rubyvm/node_chainer.rb#11
Solargraph::Parser::Rubyvm::NodeChainer::Chain = Solargraph::Source::Chain

module Solargraph::Parser::Rubyvm::NodeMethods
  private

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#124
  def any_splatted_call?(nodes); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#73
  def call_nodes_from(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#62
  def const_nodes_from(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#92
  def convert_hash(node); end

  # @param cursor [Solargraph::Source::Cursor]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#133
  def find_recipient_node(cursor); end

  # @param node [RubyVM::AbstractSyntaxTree::Node]
  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#32
  def infer_literal_node_type(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#128
  def node?(node); end

  # @param node [RubyVM::AbstractSyntaxTree::Node]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#15
  def pack_name(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#52
  def returns_from(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#119
  def splatted_call?(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#108
  def splatted_hash?(node); end

  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#112
  def splatted_node?(node); end

  # @param node [RubyVM::AbstractSyntaxTree::Node]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#9
  def unpack_name(node); end

  class << self
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#124
    def any_splatted_call?(nodes); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#73
    def call_nodes_from(node); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#62
    def const_nodes_from(node); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#92
    def convert_hash(node); end

    # @param cursor [Solargraph::Source::Cursor]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#133
    def find_recipient_node(cursor); end

    # @param node [RubyVM::AbstractSyntaxTree::Node]
    # @return [String, nil]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#32
    def infer_literal_node_type(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#128
    def node?(node); end

    # @param node [RubyVM::AbstractSyntaxTree::Node]
    # @return [Array<String>]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#15
    def pack_name(node); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#52
    def returns_from(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#119
    def splatted_call?(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#108
    def splatted_hash?(node); end

    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#112
    def splatted_node?(node); end

    # @param node [RubyVM::AbstractSyntaxTree::Node]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#9
    def unpack_name(node); end

    protected

    # @param cursor [Source::Cursor]
    # @return [Source::Cursor]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#173
    def maybe_adjust_cursor(cursor); end

    # @param cursor [Source::Cursor]
    # @return [RubyVM::AbstractSyntaxTree::Node, nil]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#146
    def synchronized_find_recipient_node(cursor); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#178
    def unsynchronized_find_recipient_node(cursor); end
  end
end

module Solargraph::Parser::Rubyvm::NodeMethods::DeepInference
  class << self
    # @param node [Parser::AST::Node]
    # @return [Array<Parser::AST::Node>]
    #
    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#213
    def get_return_nodes(node); end

    private

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#242
    def get_return_nodes_from_children(parent); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#265
    def get_return_nodes_only(parent); end

    # source://solargraph//lib/solargraph/parser/rubyvm/node_methods.rb#283
    def reduce_to_value_nodes(nodes); end
  end
end

module Solargraph::Parser::Rubyvm::NodeProcessors; end

class Solargraph::Parser::Rubyvm::NodeProcessors::AliasNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/alias_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::ArgsNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/args_node.rb#8
  def process; end

  private

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/args_node.rb#74
  def extract_name(var); end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::BeginNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/begin_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::BlockNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/block_node.rb#10
  def process; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/block_node.rb#33
  def other_class_eval?; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::CasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/casgn_node.rb#8
  def process; end

  private

  # @return [String]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/casgn_node.rb#22
  def const_name; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::CvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/cvasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::DefNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/def_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::DefsNode < ::Solargraph::Parser::Rubyvm::NodeProcessors::DefNode
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/defs_node.rb#10
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::GvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/gvasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::IvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/ivasgn_node.rb#10
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::KwArgNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/kw_arg_node.rb#8
  def process; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/kw_arg_node.rb#30
  def require_keyword?(node); end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::LitNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/lit_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::LvasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/lvasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::NamespaceNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/namespace_node.rb#10
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::OptArgNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/opt_arg_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::OrasgnNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/orasgn_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::ResbodyNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/resbody_node.rb#10
  def process; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/resbody_node.rb#36
  def exception_variable?; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::SclassNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/sclass_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::ScopeNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/scope_node.rb#8
  def process; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::SendNode < ::Solargraph::Parser::NodeProcessor::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#10
  def process; end

  private

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#241
  def process_alias_method; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#64
  def process_attribute; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#161
  def process_autoload; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#128
  def process_extend; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#101
  def process_include; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#170
  def process_module_function; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#115
  def process_prepend; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#258
  def process_private_class_method; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#228
  def process_private_constant; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#150
  def process_require; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/send_node.rb#42
  def process_visibility; end
end

class Solargraph::Parser::Rubyvm::NodeProcessors::SymNode < ::Solargraph::Parser::NodeProcessor::Base
  # source://solargraph//lib/solargraph/parser/rubyvm/node_processors/sym_node.rb#8
  def process; end
end

class Solargraph::Parser::Snippet
  # @return [Snippet] a new instance of Snippet
  #
  # source://solargraph//lib/solargraph/parser/snippet.rb#7
  def initialize(range, text); end

  # Returns the value of attribute range.
  #
  # source://solargraph//lib/solargraph/parser/snippet.rb#4
  def range; end

  # Returns the value of attribute text.
  #
  # source://solargraph//lib/solargraph/parser/snippet.rb#5
  def text; end
end

class Solargraph::Parser::SyntaxError < ::StandardError; end

# The namespace for pins used in maps.
module Solargraph::Pin; end

# The base class for map pins.
class Solargraph::Pin::Base
  include ::Solargraph::Pin::Common
  include ::Solargraph::Pin::Conversions
  include ::Solargraph::Pin::Documenting

  # @param location [Solargraph::Location]
  # @param kind [Integer]
  # @param closure [Solargraph::Pin::Closure]
  # @param name [String]
  # @param comments [String]
  # @return [Base] a new instance of Base
  #
  # source://solargraph//lib/solargraph/pin/base.rb#29
  def initialize(location: T.unsafe(nil), closure: T.unsafe(nil), name: T.unsafe(nil), comments: T.unsafe(nil)); end

  # Pin equality is determined using the #nearly? method and also
  # requiring both pins to have the same location.
  #
  # source://solargraph//lib/solargraph/pin/base.rb#69
  def ==(other); end

  # @return [YARD::CodeObjects::Base]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#13
  def code_object; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#37
  def comments; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#48
  def completion_item_kind; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#128
  def deprecated?; end

  # @return [Array<YARD::Tags::Directive>]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#104
  def directives; end

  # @return [YARD::Docstring]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#98
  def docstring; end

  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#42
  def filename; end

  # source://solargraph//lib/solargraph/pin/base.rb#216
  def identity; end

  # @deprecated Use #typify and/or #probe instead
  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#155
  def infer(api_map); end

  # source://solargraph//lib/solargraph/pin/base.rb#220
  def inspect; end

  # @return [Solargraph::Location]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#16
  def location; end

  # @return [Array<YARD::Tags::MacroDirective>]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#110
  def macros; end

  # Perform a quick check to see if this pin possibly includes YARD
  # directives. This method does not require parsing the comments.
  #
  # After the comments have been parsed, this method will return false if
  # no directives were found, regardless of whether it previously appeared
  # possible.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#122
  def maybe_directives?; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#19
  def name; end

  # True if the specified pin is a near match to this one. A near match
  # indicates that the pins contain mostly the same data. Any differences
  # between them should not have an impact on the API surface.
  #
  # @param other [Solargraph::Pin::Base, Object]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#80
  def nearly?(other); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#22
  def path; end

  # Infer the pin's return type via static code analysis.
  #
  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#148
  def probe(api_map); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#186
  def probed?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#182
  def proxied?; end

  # Return a proxy for this pin with the specified return type. Other than
  # the return type and the #proxied? setting, the proxy should be a clone
  # of the original.
  #
  # @param return_type [ComplexType]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#209
  def proxy(return_type); end

  # @param api_map [ApiMap]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#192
  def realize(api_map); end

  # The pin's return type.
  #
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#93
  def return_type; end

  # @return [Integer, nil]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#53
  def symbol_kind; end

  # source://solargraph//lib/solargraph/pin/base.rb#57
  def to_s; end

  # Try to merge data from another pin. Merges are only possible if the
  # pins are near matches (see the #nearly? method). The changes should
  # not have any side effects on the API surface.
  #
  # @param pin [Pin::Base] The pin to merge into this one
  # @return [Boolean] True if the pins were merged
  #
  # source://solargraph//lib/solargraph/pin/base.rb#168
  def try_merge!(pin); end

  # Get a fully qualified type from the pin's return type.
  #
  # The relative type is determined from YARD documentation (@return,
  # @param, @type, etc.) and its namespaces are fully qualified using the
  # provided ApiMap.
  #
  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#140
  def typify(api_map); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#62
  def variable?; end

  protected

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#227
  def probed=(_arg0); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#230
  def proxied=(_arg0); end

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#233
  def return_type=(_arg0); end

  private

  # @return [Array<YARD::Tags::Handlers::Directive>]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#289
  def collect_macros; end

  # @param dir1 [Array<YARD::Tags::Directive>]
  # @param dir2 [Array<YARD::Tags::Directive>]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#269
  def compare_directives(dir1, dir2); end

  # True if two docstrings have the same tags, regardless of any other
  # differences.
  #
  # @param d1 [YARD::Docstring]
  # @param d2 [YARD::Docstring]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#258
  def compare_docstring_tags(d1, d2); end

  # @param tag1 [YARD::Tags::Tag]
  # @param tag2 [YARD::Tags::Tag]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#280
  def compare_tags(tag1, tag2); end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/pin/base.rb#238
  def parse_comments; end
end

class Solargraph::Pin::BaseVariable < ::Solargraph::Pin::Base
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # @param assignment [Parser::AST::Node, nil]
  # @return [BaseVariable] a new instance of BaseVariable
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#13
  def initialize(assignment: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/base_variable.rb#62
  def ==(other); end

  # @return [Parser::AST::Node, nil]
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#10
  def assignment; end

  # source://solargraph//lib/solargraph/pin/base_variable.rb#18
  def completion_item_kind; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#31
  def nil_assignment?; end

  # source://solargraph//lib/solargraph/pin/base_variable.rb#39
  def probe(api_map); end

  # source://solargraph//lib/solargraph/pin/base_variable.rb#27
  def return_type; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#23
  def symbol_kind; end

  # source://solargraph//lib/solargraph/pin/base_variable.rb#67
  def try_merge!(pin); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#35
  def variable?; end

  private

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/base_variable.rb#77
  def generate_complex_type; end
end

class Solargraph::Pin::Block < ::Solargraph::Pin::Closure
  # @param args [Array<Parameter>]
  # @return [Block] a new instance of Block
  #
  # source://solargraph//lib/solargraph/pin/block.rb#12
  def initialize(receiver: T.unsafe(nil), args: T.unsafe(nil), context: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/block.rb#25
  def binder; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/pin/block.rb#35
  def parameter_names; end

  # @return [Array<Parameter>]
  #
  # source://solargraph//lib/solargraph/pin/block.rb#30
  def parameters; end

  # @param api_map [ApiMap]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/pin/block.rb#21
  def rebind(api_map); end

  # The signature of the method that receives this block.
  #
  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/pin/block.rb#9
  def receiver; end

  private

  # @param api_map [ApiMap]
  # @return [ComplexType, nil]
  #
  # source://solargraph//lib/solargraph/pin/block.rb#43
  def binder_or_nil(api_map); end
end

class Solargraph::Pin::ClassVariable < ::Solargraph::Pin::BaseVariable; end

class Solargraph::Pin::Closure < ::Solargraph::Pin::Base
  # @return [Closure] a new instance of Closure
  #
  # source://solargraph//lib/solargraph/pin/closure.rb#9
  def initialize(scope: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/closure.rb#25
  def binder; end

  # source://solargraph//lib/solargraph/pin/closure.rb#14
  def context; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/pin/closure.rb#30
  def gates; end

  # @return [::Symbol] :class or :instance
  #
  # source://solargraph//lib/solargraph/pin/closure.rb#7
  def scope; end
end

module Solargraph::Pin::Common
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#35
  def binder; end

  # @return [Pin::Base, nil]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#10
  def closure; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#40
  def comments; end

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#23
  def context; end

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#23
  def full_context; end

  # @return [Location]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#7
  def location; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#13
  def name; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#30
  def namespace; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#45
  def path; end

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#18
  def return_type; end

  private

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/common.rb#52
  def find_context; end
end

class Solargraph::Pin::Constant < ::Solargraph::Pin::BaseVariable
  # @return [Constant] a new instance of Constant
  #
  # source://solargraph//lib/solargraph/pin/constant.rb#8
  def initialize(visibility: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/constant.rb#17
  def completion_item_kind; end

  # source://solargraph//lib/solargraph/pin/constant.rb#26
  def path; end

  # source://solargraph//lib/solargraph/pin/constant.rb#13
  def return_type; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/pin/constant.rb#22
  def symbol_kind; end

  # Returns the value of attribute visibility.
  #
  # source://solargraph//lib/solargraph/pin/constant.rb#6
  def visibility; end

  private

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/constant.rb#33
  def generate_complex_type; end
end

# @todo Move this stuff. It should be the responsibility of the language server.
module Solargraph::Pin::Conversions
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#10
  def completion_item; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#46
  def detail; end

  # Get a markdown-flavored link to a documentation page.
  #
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#60
  def link_documentation; end

  # source://solargraph//lib/solargraph/pin/conversions.rb#70
  def reset_conversions; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#25
  def resolve_completion_item; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#38
  def signature_help; end

  # source://solargraph//lib/solargraph/pin/conversions.rb#64
  def text_documentation; end

  private

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#90
  def escape_brackets(text); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/conversions.rb#81
  def generate_link; end
end

# A module to add the Pin::Base#documentation method.
module Solargraph::Pin::Documenting
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#62
  def documentation; end

  private

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#91
  def normalize_indentation(text); end

  # @param line [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#97
  def remove_odd_spaces(line); end
end

# A documentation formatter that either performs Markdown conversion for
# text, or applies backticks for code blocks.
class Solargraph::Pin::Documenting::DocSection
  # @param code [Boolean] True if this section is a code block
  # @return [DocSection] a new instance of DocSection
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#25
  def initialize(code); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#30
  def code?; end

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#36
  def concat(text); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#22
  def plaintext; end

  # source://solargraph//lib/solargraph/pin/documenting.rb#40
  def to_s; end

  private

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#49
  def escape_brackets(text); end

  # @param text [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/documenting.rb#56
  def unescape_brackets(text); end
end

# DuckMethod pins are used to add completion items for type tags that
# use duck typing, e.g., `@param file [#read]`.
class Solargraph::Pin::DuckMethod < ::Solargraph::Pin::Method; end

class Solargraph::Pin::GlobalVariable < ::Solargraph::Pin::BaseVariable; end

class Solargraph::Pin::InstanceVariable < ::Solargraph::Pin::BaseVariable
  # source://solargraph//lib/solargraph/pin/instance_variable.rb#6
  def binder; end

  # source://solargraph//lib/solargraph/pin/instance_variable.rb#14
  def context; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/instance_variable.rb#25
  def nearly?(other); end

  # source://solargraph//lib/solargraph/pin/instance_variable.rb#10
  def scope; end
end

class Solargraph::Pin::Keyword < ::Solargraph::Pin::Base
  # @return [Keyword] a new instance of Keyword
  #
  # source://solargraph//lib/solargraph/pin/keyword.rb#6
  def initialize(name); end

  # source://solargraph//lib/solargraph/pin/keyword.rb#10
  def name; end
end

class Solargraph::Pin::KeywordParam < ::Solargraph::Pin::Symbol; end

class Solargraph::Pin::LocalVariable < ::Solargraph::Pin::BaseVariable
  # @return [LocalVariable] a new instance of LocalVariable
  #
  # source://solargraph//lib/solargraph/pin/local_variable.rb#9
  def initialize(assignment: T.unsafe(nil), presence: T.unsafe(nil), **splat); end

  # @return [Range]
  #
  # source://solargraph//lib/solargraph/pin/local_variable.rb#7
  def presence; end

  # source://solargraph//lib/solargraph/pin/local_variable.rb#15
  def try_merge!(pin); end

  # @param other_closure [Pin::Closure]
  # @param other_loc [Location]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/local_variable.rb#23
  def visible_at?(other_closure, other_loc); end

  private

  # source://solargraph//lib/solargraph/pin/local_variable.rb#43
  def match_named_closure(needle, haystack); end

  # @param tag1 [String]
  # @param tag2 [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/local_variable.rb#34
  def match_tags(tag1, tag2); end
end

# The base class for method and attribute pins.
class Solargraph::Pin::Method < ::Solargraph::Pin::Closure
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # @param visibility [::Symbol] :public, :protected, or :private
  # @param explicit [Boolean]
  # @return [Method] a new instance of Method
  #
  # source://solargraph//lib/solargraph/pin/method.rb#21
  def initialize(visibility: T.unsafe(nil), explicit: T.unsafe(nil), parameters: T.unsafe(nil), node: T.unsafe(nil), attribute: T.unsafe(nil), **splat); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#98
  def attribute?; end

  # source://solargraph//lib/solargraph/pin/method.rb#35
  def completion_item_kind; end

  # source://solargraph//lib/solargraph/pin/method.rb#59
  def documentation; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#94
  def explicit?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#102
  def nearly?(other); end

  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#17
  def node; end

  # @return [Array<Pin::Method>]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#120
  def overloads; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#31
  def parameter_names; end

  # @return [Array<Pin::Parameter>]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#11
  def parameters; end

  # source://solargraph//lib/solargraph/pin/method.rb#47
  def path; end

  # source://solargraph//lib/solargraph/pin/method.rb#109
  def probe(api_map); end

  # source://solargraph//lib/solargraph/pin/method.rb#43
  def return_type; end

  # source://solargraph//lib/solargraph/pin/method.rb#39
  def symbol_kind; end

  # source://solargraph//lib/solargraph/pin/method.rb#113
  def try_merge!(pin); end

  # source://solargraph//lib/solargraph/pin/method.rb#51
  def typify(api_map); end

  # @return [::Symbol] :public, :private, or :protected
  #
  # source://solargraph//lib/solargraph/pin/method.rb#14
  def visibility; end

  private

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#145
  def generate_complex_type; end

  # source://solargraph//lib/solargraph/pin/method.rb#232
  def infer_from_iv(api_map); end

  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#207
  def infer_from_return_nodes(api_map); end

  # @return [Parser::AST::Node, nil]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#196
  def method_body_node; end

  # When YARD parses an overload tag, it includes rest modifiers in the parameters names.
  #
  # @param arg [String]
  # @return [Array(String, Symbol)]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#249
  def parse_overload_param(name); end

  # @param ref [String]
  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#178
  def resolve_reference(ref, api_map); end

  # @param api_map [ApiMap]
  # @return [ComplexType, nil]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#153
  def see_reference(api_map); end

  # @param api_map [ApiMap]
  # @return [ComplexType, nil]
  #
  # source://solargraph//lib/solargraph/pin/method.rb#166
  def typify_from_super(api_map); end
end

# Use this class to track method aliases for later remapping. Common
# examples that defer mapping are aliases for superclass methods or
# methods from included modules.
class Solargraph::Pin::MethodAlias < ::Solargraph::Pin::Method
  # @return [MethodAlias] a new instance of MethodAlias
  #
  # source://solargraph//lib/solargraph/pin/method_alias.rb#16
  def initialize(scope: T.unsafe(nil), original: T.unsafe(nil), **splat); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/method_alias.rb#14
  def original; end

  # source://solargraph//lib/solargraph/pin/method_alias.rb#26
  def path; end

  # @return [::Symbol]
  #
  # source://solargraph//lib/solargraph/pin/method_alias.rb#11
  def scope; end

  # source://solargraph//lib/solargraph/pin/method_alias.rb#22
  def visibility; end
end

class Solargraph::Pin::Namespace < ::Solargraph::Pin::Closure
  # @param type [::Symbol] :class or :module
  # @param visibility [::Symbol] :public or :private
  # @param gates [Array<String>]
  # @return [Namespace] a new instance of Namespace
  #
  # source://solargraph//lib/solargraph/pin/namespace.rb#15
  def initialize(type: T.unsafe(nil), visibility: T.unsafe(nil), gates: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/namespace.rb#49
  def binder; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#57
  def completion_item_kind; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#74
  def domains; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#45
  def full_context; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#82
  def gates; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#41
  def namespace; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#66
  def path; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#70
  def return_type; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#53
  def scope; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/pin/namespace.rb#62
  def symbol_kind; end

  # @return [::Symbol] :class or :module
  #
  # source://solargraph//lib/solargraph/pin/namespace.rb#10
  def type; end

  # source://solargraph//lib/solargraph/pin/namespace.rb#78
  def typify(api_map); end

  # @return [::Symbol] :public or :private
  #
  # source://solargraph//lib/solargraph/pin/namespace.rb#7
  def visibility; end
end

class Solargraph::Pin::Parameter < ::Solargraph::Pin::LocalVariable
  # @return [Parameter] a new instance of Parameter
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#12
  def initialize(decl: T.unsafe(nil), asgn_code: T.unsafe(nil), **splat); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#10
  def asgn_code; end

  # @return [Symbol]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#7
  def decl; end

  # source://solargraph//lib/solargraph/pin/parameter.rb#85
  def documentation; end

  # source://solargraph//lib/solargraph/pin/parameter.rb#34
  def full; end

  # The parameter's zero-based location in the block's signature.
  #
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#75
  def index; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#18
  def keyword?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#22
  def kwrestarg?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#30
  def rest?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#26
  def restarg?; end

  # source://solargraph//lib/solargraph/pin/parameter.rb#53
  def return_type; end

  # source://solargraph//lib/solargraph/pin/parameter.rb#91
  def try_merge!(pin); end

  # @param api_map [ApiMap]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#80
  def typify(api_map); end

  private

  # @return [YARD::Tags::Tag]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#99
  def param_tag; end

  # @param ref [String]
  # @param api_map [ApiMap]
  # @param skip [Array]
  # @return [Array<YARD::Tags::Tag>, nil]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#177
  def resolve_reference(ref, api_map, skip); end

  # @param heredoc [YARD::Docstring]
  # @param api_map [ApiMap]
  # @param skip [Array]
  # @return [Array<YARD::Tags::Tag>]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#164
  def see_reference(heredoc, api_map, skip = T.unsafe(nil)); end

  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#115
  def typify_block_param(api_map); end

  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/pin/parameter.rb#141
  def typify_method_param(api_map); end
end

class Solargraph::Pin::ProxyType < ::Solargraph::Pin::Base
  # @param return_type [ComplexType]
  # @return [ProxyType] a new instance of ProxyType
  #
  # source://solargraph//lib/solargraph/pin/proxy_type.rb#7
  def initialize(return_type: T.unsafe(nil), **splat); end

  # source://solargraph//lib/solargraph/pin/proxy_type.rb#12
  def context; end

  class << self
    # @param return_type [ComplexType]
    # @return [ProxyType]
    #
    # source://solargraph//lib/solargraph/pin/proxy_type.rb#18
    def anonymous(return_type); end
  end
end

# source://solargraph//lib/solargraph/pin.rb#35
Solargraph::Pin::ROOT_PIN = T.let(T.unsafe(nil), Solargraph::Pin::Namespace)

class Solargraph::Pin::Reference < ::Solargraph::Pin::Base; end
class Solargraph::Pin::Reference::Extend < ::Solargraph::Pin::Reference; end
class Solargraph::Pin::Reference::Include < ::Solargraph::Pin::Reference; end

class Solargraph::Pin::Reference::Override < ::Solargraph::Pin::Reference
  # @return [Override] a new instance of Override
  #
  # source://solargraph//lib/solargraph/pin/reference/override.rb#13
  def initialize(location, name, tags, delete = T.unsafe(nil)); end

  # @return [Array<Symbol>]
  #
  # source://solargraph//lib/solargraph/pin/reference/override.rb#11
  def delete; end

  # @return [Array<YARD::Tags::Tag>]
  #
  # source://solargraph//lib/solargraph/pin/reference/override.rb#8
  def tags; end

  class << self
    # source://solargraph//lib/solargraph/pin/reference/override.rb#23
    def from_comment(name, comment); end

    # source://solargraph//lib/solargraph/pin/reference/override.rb#19
    def method_return(name, *tags, delete: T.unsafe(nil)); end
  end
end

class Solargraph::Pin::Reference::Prepend < ::Solargraph::Pin::Reference; end

class Solargraph::Pin::Reference::Require < ::Solargraph::Pin::Reference
  # @return [Require] a new instance of Require
  #
  # source://solargraph//lib/solargraph/pin/reference/require.rb#7
  def initialize(location, name); end
end

class Solargraph::Pin::Reference::Superclass < ::Solargraph::Pin::Reference; end

class Solargraph::Pin::Search
  # @param pins [Array<Pin::Base>]
  # @param query [String]
  # @return [Search] a new instance of Search
  #
  # source://solargraph//lib/solargraph/pin/search.rb#23
  def initialize(pins, query); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/pin/search.rb#29
  def results; end

  private

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/pin/search.rb#36
  def do_query; end

  # @param str1 [String]
  # @param str2 [String]
  # @return [Float]
  #
  # source://solargraph//lib/solargraph/pin/search.rb#50
  def fuzzy_string_match(str1, str2); end
end

class Solargraph::Pin::Search::Result
  # @return [Result] a new instance of Result
  #
  # source://solargraph//lib/solargraph/pin/search.rb#15
  def initialize(match, pin); end

  # @return [Float]
  #
  # source://solargraph//lib/solargraph/pin/search.rb#10
  def match; end

  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/pin/search.rb#13
  def pin; end
end

class Solargraph::Pin::Singleton < ::Solargraph::Pin::Closure
  # @return [Singleton] a new instance of Singleton
  #
  # source://solargraph//lib/solargraph/pin/singleton.rb#6
  def initialize(name: T.unsafe(nil), location: T.unsafe(nil), closure: T.unsafe(nil)); end
end

class Solargraph::Pin::Symbol < ::Solargraph::Pin::Base
  # @param location [Solargraph::Location]
  # @param name [String]
  # @return [Symbol] a new instance of Symbol
  #
  # source://solargraph//lib/solargraph/pin/symbol.rb#8
  def initialize(location, name); end

  # source://solargraph//lib/solargraph/pin/symbol.rb#26
  def comments; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#22
  def completion_item_kind; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/pin/symbol.rb#42
  def deprecated?; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#34
  def directives; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#14
  def namespace; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#18
  def path; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#30
  def return_type; end

  # source://solargraph//lib/solargraph/pin/symbol.rb#38
  def visibility; end
end

# The zero-based line and column numbers of a position in a string.
class Solargraph::Position
  # @param line [Integer]
  # @param character [Integer]
  # @return [Position] a new instance of Position
  #
  # source://solargraph//lib/solargraph/position.rb#17
  def initialize(line, character); end

  # source://solargraph//lib/solargraph/position.rb#95
  def ==(other); end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/position.rb#11
  def character; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/position.rb#11
  def column; end

  # source://solargraph//lib/solargraph/position.rb#33
  def inspect; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/position.rb#8
  def line; end

  # Get a hash of the position. This representation is suitable for use in
  # the language server protocol.
  #
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/position.rb#26
  def to_hash; end

  class << self
    # Get a position for the specified text and offset.
    #
    # @param text [String]
    # @param offset [Integer]
    # @raise [InvalidOffsetError]
    # @return [Position]
    #
    # source://solargraph//lib/solargraph/position.rb#63
    def from_offset(text, offset); end

    # Get a numeric offset for the specified text and a position identified
    # by its line and character.
    #
    # @param text [String]
    # @param line [Integer]
    # @param character [Integer]
    # @return [Integer]
    #
    # source://solargraph//lib/solargraph/position.rb#54
    def line_char_to_offset(text, line, character); end

    # A helper method for generating positions from arrays of integers. The
    # original parameter is returned if it is already a position.
    #
    # @param object [Position, Array(Integer, Integer)]
    # @raise [ArgumentError] if the object cannot be converted to a position.
    # @return [Position]
    #
    # source://solargraph//lib/solargraph/position.rb#89
    def normalize(object); end

    # Get a numeric offset for the specified text and position.
    #
    # @param text [String]
    # @param position [Position]
    # @return [Integer]
    #
    # source://solargraph//lib/solargraph/position.rb#42
    def to_offset(text, position); end
  end
end

# A pair of positions that compose a section of text.
class Solargraph::Range
  # @param start [Position]
  # @param ending [Position]
  # @return [Range] a new instance of Range
  #
  # source://solargraph//lib/solargraph/range.rb#15
  def initialize(start, ending); end

  # source://solargraph//lib/solargraph/range.rb#86
  def ==(other); end

  # True if the specified position is inside the range.
  #
  # @param position [Position, Array(Integer, Integer)]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/range.rb#35
  def contain?(position); end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/range.rb#11
  def ending; end

  # True if the range contains the specified position and the position does not precede it.
  #
  # @param position [Position, Array(Integer, Integer)]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/range.rb#47
  def include?(position); end

  # source://solargraph//lib/solargraph/range.rb#91
  def inspect; end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/range.rb#8
  def start; end

  # Get a hash of the range. This representation is suitable for use in
  # the language server protocol.
  #
  # @return [Hash<Symbol, Position>]
  #
  # source://solargraph//lib/solargraph/range.rb#24
  def to_hash; end

  class << self
    # Get a range from a Parser range, usually found in
    # Parser::AST::Node#location#expression.
    #
    # @param expr [Parser::Source::Range]
    # @return [Range]
    #
    # source://solargraph//lib/solargraph/range.rb#82
    def from_expr(expr); end

    # Get a range from a node.
    #
    # @param node [RubyVM::AbstractSyntaxTree::Node, Parser::AST::Node]
    # @return [Range]
    #
    # source://solargraph//lib/solargraph/range.rb#67
    def from_node(node); end

    # Create a range from a pair of lines and characters.
    #
    # @param l1 [Integer] Starting line
    # @param c1 [Integer] Starting character
    # @param l2 [Integer] Ending line
    # @param c2 [Integer] Ending character
    # @return [Range]
    #
    # source://solargraph//lib/solargraph/range.rb#59
    def from_to(l1, c1, l2, c2); end
  end
end

module Solargraph::ServerMethods
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/server_methods.rb#8
  def available_port; end
end

class Solargraph::Shell < ::Thor
  include ::Solargraph::ServerMethods

  # source://solargraph//lib/solargraph/shell.rb#97
  def available_cores; end

  # source://solargraph//lib/solargraph/shell.rb#197
  def bundle; end

  # source://solargraph//lib/solargraph/shell.rb#108
  def clear; end

  # source://solargraph//lib/solargraph/shell.rb#52
  def config(directory = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/shell.rb#75
  def download_core(version = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/shell.rb#92
  def list_cores; end

  # source://solargraph//lib/solargraph/shell.rb#202
  def rdoc(gem, version = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/shell.rb#127
  def reporters; end

  # source://solargraph//lib/solargraph/shell.rb#172
  def scan; end

  # source://solargraph//lib/solargraph/shell.rb#19
  def socket; end

  # source://solargraph//lib/solargraph/shell.rb#36
  def stdio; end

  # source://solargraph//lib/solargraph/shell.rb#140
  def typecheck(*files); end

  # @raise [ArgumentError]
  #
  # source://solargraph//lib/solargraph/shell.rb#116
  def uncache(*gems); end

  # source://solargraph//lib/solargraph/shell.rb#12
  def version; end

  private

  # @param pin [Solargraph::Pin::Base]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/shell.rb#212
  def pin_description(pin); end
end

# A Ruby file that has been parsed into an AST.
class Solargraph::Source
  include ::Solargraph::Source::EncodingFixes

  # @param code [String]
  # @param filename [String]
  # @param version [Integer]
  # @return [Source] a new instance of Source
  #
  # source://solargraph//lib/solargraph/source.rb#38
  def initialize(code, filename = T.unsafe(nil), version = T.unsafe(nil)); end

  # Get a hash of comments grouped by the line numbers of the associated code.
  #
  # @return [Hash{Integer => Array<Parser::Source::Comment>}]
  #
  # source://solargraph//lib/solargraph/source.rb#305
  def associated_comments; end

  # @param range [Solargraph::Range]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#58
  def at(range); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#23
  def code; end

  # @param node [Parser::AST::Node]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#244
  def code_for(node); end

  # @param position [Position]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#222
  def comment_at?(position); end

  # @return [Hash{Integer => Array<String>}]
  #
  # source://solargraph//lib/solargraph/source.rb#29
  def comments; end

  # @param node [Parser::AST::Node]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#254
  def comments_for(node); end

  # @param position [Position, Array(Integer, Integer)]
  # @return [Source::Cursor]
  #
  # source://solargraph//lib/solargraph/source.rb#167
  def cursor_at(position); end

  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/source.rb#238
  def error_ranges; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#20
  def filename; end

  # Finish synchronizing a source that was updated via #start_synchronize.
  # This method returns self if the source is already synchronized. Otherwise
  # it parses the AST and returns a new synchronized Source.
  #
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/source.rb#125
  def finish_synchronize; end

  # Get an array of ranges that can be folded, e.g., the range of a class
  # definition or an if condition.
  #
  # See FOLDING_NODE_TYPES for the list of node types that can be folded.
  #
  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/source.rb#288
  def folding_ranges; end

  # @param l1 [Integer]
  # @param c1 [Integer]
  # @param l2 [Integer]
  # @param c2 [Integer]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#67
  def from_to(l1, c1, l2, c2); end

  # A location representing the file in its entirety.
  #
  # @return [Location]
  #
  # source://solargraph//lib/solargraph/source.rb#265
  def location; end

  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/source.rb#26
  def node; end

  # Get the nearest node that contains the specified index.
  #
  # @param line [Integer]
  # @param column [Integer]
  # @return [AST::Node]
  #
  # source://solargraph//lib/solargraph/source.rb#78
  def node_at(line, column); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#172
  def parsed?; end

  # @param name [String]
  # @return [Array<Location>]
  #
  # source://solargraph//lib/solargraph/source.rb#233
  def references(name); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#176
  def repaired?; end

  # Start synchronizing the source. This method updates the code without
  # parsing a new AST. The resulting Source object will be marked not
  # synchronized (#synchronized? == false).
  #
  # @param updater [Source::Updater]
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/source.rb#102
  def start_synchronize(updater); end

  # @param position [Position]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#182
  def string_at?(position); end

  # source://solargraph//lib/solargraph/source.rb#216
  def string_ranges; end

  # Synchronize the Source with an update. This method applies changes to the
  # code, parses the new code's AST, and returns the resulting Source object.
  #
  # @param updater [Source::Updater]
  # @return [Source]
  #
  # source://solargraph//lib/solargraph/source.rb#145
  def synchronize(updater); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#297
  def synchronized?; end

  # Get an array of nodes containing the specified index, starting with the
  # nearest node and ending with the root.
  #
  # @param line [Integer]
  # @param column [Integer]
  # @return [Array<AST::Node>]
  #
  # source://solargraph//lib/solargraph/source.rb#88
  def tree_at(line, column); end

  # @return [Integer]
  # @todo Deprecate?
  #
  # source://solargraph//lib/solargraph/source.rb#33
  def version; end

  protected

  # @param val [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#462
  def code=(val); end

  # @return [Array<Parser::Source::Comment>]
  #
  # source://solargraph//lib/solargraph/source.rb#480
  def comments=(_arg0); end

  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/source.rb#471
  def error_ranges=(_arg0); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#455
  def filename=(_arg0); end

  # @return [Source::Updater]
  #
  # source://solargraph//lib/solargraph/source.rb#486
  def last_updater; end

  # @return [Source::Updater]
  #
  # source://solargraph//lib/solargraph/source.rb#486
  def last_updater=(_arg0); end

  # @return [Parser::AST::Node]
  #
  # source://solargraph//lib/solargraph/source.rb#468
  def node=(_arg0); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#477
  def parsed=(_arg0); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#474
  def repaired; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#474
  def repaired=(_arg0); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source.rb#483
  def synchronized=(_arg0); end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source.rb#458
  def version=(_arg0); end

  private

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/source.rb#491
  def code_lines; end

  # source://solargraph//lib/solargraph/source.rb#445
  def colonized(range, position, node); end

  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/source.rb#390
  def comment_ranges; end

  # source://solargraph//lib/solargraph/source.rb#326
  def first_not_empty_from(line); end

  # Get an array of foldable comment block ranges. Blocks are excluded if
  # they are less than 3 lines long.
  #
  # @return [Array<Range>]
  #
  # source://solargraph//lib/solargraph/source.rb#398
  def foldable_comment_block_ranges; end

  # @param top [Parser::AST::Node]
  # @param result [Array<Range>]
  # @param parent [Symbol]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/source.rb#337
  def inner_folding_ranges(top, result = T.unsafe(nil), parent = T.unsafe(nil)); end

  # @param node [Parser::AST::Node]
  # @param position [Position]
  # @param stack [Array<Parser::AST::Node>]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/source.rb#432
  def inner_tree_at(node, position, stack); end

  # @return [Array<Parser::AST::Node>]
  #
  # source://solargraph//lib/solargraph/source.rb#385
  def string_nodes; end

  # @param n [Parser::AST::Node]
  # @return [Array<Parser::AST::Node>]
  #
  # source://solargraph//lib/solargraph/source.rb#416
  def string_nodes_in(n); end

  # A hash of line numbers and their associated comments.
  #
  # @return [Hash{Integer => Array<String>}]
  #
  # source://solargraph//lib/solargraph/source.rb#380
  def stringified_comments; end

  # Get a string representation of an array of comments.
  #
  # @param comments [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source.rb#357
  def stringify_comment_array(comments); end

  class << self
    # @param filename [String]
    # @return [Solargraph::Source]
    #
    # source://solargraph//lib/solargraph/source.rb#498
    def load(filename); end

    # @param code [String]
    # @param filename [String]
    # @param version [Integer]
    # @return [Solargraph::Source]
    #
    # source://solargraph//lib/solargraph/source.rb#509
    def load_string(code, filename = T.unsafe(nil), version = T.unsafe(nil)); end

    # @param comments [String]
    # @return [YARD::DocstringParser]
    #
    # source://solargraph//lib/solargraph/source.rb#515
    def parse_docstring(comments); end
  end
end

# A chain of constants, variables, and method calls for inferring types of
# values.
class Solargraph::Source::Chain
  # @param links [Array<Chain::Link>]
  # @return [Chain] a new instance of Chain
  #
  # source://solargraph//lib/solargraph/source/chain.rb#39
  def initialize(links, node = T.unsafe(nil), splat = T.unsafe(nil)); end

  # @return [Chain]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#53
  def base; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#98
  def constant?; end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @param locals [Array<Pin::Base>]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#61
  def define(api_map, name_pin, locals); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#93
  def defined?; end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @param locals [Array<Pin::Base>]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#78
  def infer(api_map, name_pin, locals); end

  # @return [Array<Source::Chain::Link>]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#34
  def links; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#85
  def literal?; end

  # Returns the value of attribute node.
  #
  # source://solargraph//lib/solargraph/source/chain.rb#36
  def node; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#106
  def nullable?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#102
  def splat?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#89
  def undefined?; end

  private

  # @param pins [Array<Pin::Base>]
  # @param api_map [ApiMap]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#115
  def infer_first_defined(pins, context, api_map); end

  # @param type [ComplexType]
  #
  # source://solargraph//lib/solargraph/source/chain.rb#157
  def maybe_nil(type); end
end

class Solargraph::Source::Chain::BlockVariable < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/block_variable.rb#7
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::Call < ::Solargraph::Source::Chain::Link
  # @param word [String]
  # @param arguments [Array<Chain>]
  # @param with_block [Boolean] True if the chain is inside a block
  # @param head [Boolean] True if the call is the start of its chain
  # @return [Call] a new instance of Call
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#17
  def initialize(word, arguments = T.unsafe(nil), with_block = T.unsafe(nil)); end

  # @return [Array<Chain>]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#11
  def arguments; end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @param locals [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#30
  def resolve(api_map, name_pin, locals); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#23
  def with_block?; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#8
  def word; end

  private

  # @param arguments [Array<Chain>]
  # @param parameters [Array<String>]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#188
  def arguments_match(arguments, parameters); end

  # @param docstring [YARD::Docstring]
  # @param context [ComplexType]
  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#176
  def extra_return_type(docstring, context); end

  # @param pins [Array<Pin::Base>]
  # @param api_map [ApiMap]
  # @param context [ComplexType]
  # @param locals [Pin::LocalVariable]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#53
  def inferred_pins(pins, api_map, context, locals); end

  # @param pin [Pin]
  # @param macro [YARD::Tags::MacroDirective]
  # @param api_map [ApiMap]
  # @param context [ComplexType]
  # @param locals [Array<Pin::Base>]
  # @return [Pin::ProxyType]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#153
  def inner_process_macro(pin, macro, api_map, context, locals); end

  # @param pin [Pin::Method]
  # @param api_map [ApiMap]
  # @param context [ComplexType]
  # @param locals [Pin::Base]
  # @return [Pin::ProxyType]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#137
  def process_directive(pin, api_map, context, locals); end

  # @param pin [Pin::Method]
  # @param api_map [ApiMap]
  # @param context [ComplexType]
  # @param locals [Pin::Base]
  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#124
  def process_macro(pin, api_map, context, locals); end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain/call.rb#200
  def super_pins(api_map, name_pin); end
end

class Solargraph::Source::Chain::ClassVariable < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/class_variable.rb#7
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::Constant < ::Solargraph::Source::Chain::Link
  # @return [Constant] a new instance of Constant
  #
  # source://solargraph//lib/solargraph/source/chain/constant.rb#7
  def initialize(word); end

  # source://solargraph//lib/solargraph/source/chain/constant.rb#11
  def resolve(api_map, name_pin, locals); end

  private

  # source://solargraph//lib/solargraph/source/chain/constant.rb#38
  def crawl_gates(pin); end

  # source://solargraph//lib/solargraph/source/chain/constant.rb#62
  def deep_constant_type(gate, api_map); end

  # source://solargraph//lib/solargraph/source/chain/constant.rb#51
  def first_pin_type(pins, api_map); end
end

class Solargraph::Source::Chain::GlobalVariable < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/global_variable.rb#7
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::Hash < ::Solargraph::Source::Chain::Literal
  # @param type [String]
  # @param splatted [Boolean]
  # @return [Hash] a new instance of Hash
  #
  # source://solargraph//lib/solargraph/source/chain/hash.rb#9
  def initialize(type, splatted = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/source/chain/hash.rb#18
  def resolve(api_map, name_pin, locals); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/hash.rb#22
  def splatted?; end

  # source://solargraph//lib/solargraph/source/chain/hash.rb#14
  def word; end
end

# Chain::Head is a link for ambiguous words, e.g.; `String` can refer to
# either a class (`String`) or a function (`Kernel#String`).
#
# @note Chain::Head is only intended to handle `self` and `super`.
class Solargraph::Source::Chain::Head < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/head.rb#11
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::InstanceVariable < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/instance_variable.rb#7
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::Link
  # @return [Link] a new instance of Link
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#12
  def initialize(word = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/source/chain/link.rb#36
  def ==(other); end

  # Make a copy of this link unmarked as the head of a chain
  #
  # @return [self]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#50
  def clone_body; end

  # Make a copy of this link marked as the head of a chain
  #
  # @return [self]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#43
  def clone_head; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#20
  def constant?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#32
  def head?; end

  # Returns the value of attribute last_context.
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#10
  def last_context; end

  # Sets the attribute last_context
  #
  # @param value the value to set the attribute last_context to.
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#10
  def last_context=(_arg0); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#54
  def nullable?; end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @param locals [Array<Pin::Base>]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#28
  def resolve(api_map, name_pin, locals); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#16
  def undefined?; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#8
  def word; end

  protected

  # Mark whether this link is the head of a chain
  #
  # @param bool [Boolean]
  # @return [self]
  #
  # source://solargraph//lib/solargraph/source/chain/link.rb#64
  def mark_head(bool); end
end

class Solargraph::Source::Chain::Literal < ::Solargraph::Source::Chain::Link
  # @param type [String]
  # @return [Literal] a new instance of Literal
  #
  # source://solargraph//lib/solargraph/source/chain/literal.rb#12
  def initialize(type); end

  # source://solargraph//lib/solargraph/source/chain/literal.rb#17
  def resolve(api_map, name_pin, locals); end

  # source://solargraph//lib/solargraph/source/chain/literal.rb#7
  def word; end
end

class Solargraph::Source::Chain::Or < ::Solargraph::Source::Chain::Link
  # @param type [String]
  # @return [Or] a new instance of Or
  #
  # source://solargraph//lib/solargraph/source/chain/or.rb#12
  def initialize(links); end

  # source://solargraph//lib/solargraph/source/chain/or.rb#16
  def resolve(api_map, name_pin, locals); end

  # source://solargraph//lib/solargraph/source/chain/or.rb#7
  def word; end
end

class Solargraph::Source::Chain::QCall < ::Solargraph::Source::Chain::Call
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/chain/q_call.rb#5
  def nullable?; end
end

# source://solargraph//lib/solargraph/source/chain.rb#30
Solargraph::Source::Chain::UNDEFINED_CALL = T.let(T.unsafe(nil), Solargraph::Source::Chain::Call)

# source://solargraph//lib/solargraph/source/chain.rb#31
Solargraph::Source::Chain::UNDEFINED_CONSTANT = T.let(T.unsafe(nil), Solargraph::Source::Chain::Constant)

class Solargraph::Source::Chain::Variable < ::Solargraph::Source::Chain::Link
  # source://solargraph//lib/solargraph/source/chain/variable.rb#7
  def resolve(api_map, name_pin, locals); end
end

class Solargraph::Source::Chain::ZSuper < ::Solargraph::Source::Chain::Call
  # @param word [String]
  # @param arguments [Array<Chain>]
  # @param with_block [Boolean] True if the chain is inside a block
  # @param head [Boolean] True if the call is the start of its chain
  # @return [ZSuper] a new instance of ZSuper
  #
  # source://solargraph//lib/solargraph/source/chain/z_super.rb#17
  def initialize(word, with_block = T.unsafe(nil)); end

  # @return [Array<Chain>]
  #
  # source://solargraph//lib/solargraph/source/chain/z_super.rb#11
  def arguments; end

  # @param api_map [ApiMap]
  # @param name_pin [Pin::Base]
  # @param locals [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source/chain/z_super.rb#24
  def resolve(api_map, name_pin, locals); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/chain/z_super.rb#8
  def word; end
end

# A change to be applied to text.
class Solargraph::Source::Change
  include ::Solargraph::Source::EncodingFixes

  # @param range [Range] The starting and ending positions of the change.
  #   If nil, the original text will be overwritten.
  # @param new_text [String] The text to be changed.
  # @return [Change] a new instance of Change
  #
  # source://solargraph//lib/solargraph/source/change.rb#19
  def initialize(range, new_text); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/change.rb#14
  def new_text; end

  # @return [Range]
  #
  # source://solargraph//lib/solargraph/source/change.rb#11
  def range; end

  # Repair an update by replacing the new text with similarly formatted
  # whitespace.
  #
  # @param text [String] The text to be changed.
  # @return [String] The updated text.
  #
  # source://solargraph//lib/solargraph/source/change.rb#55
  def repair(text); end

  # Write the change to the specified text.
  #
  # @param text [String] The text to be changed.
  # @param nullable [Boolean] If true, minor changes that could generate
  #   syntax errors will be repaired.
  # @return [String] The updated text.
  #
  # source://solargraph//lib/solargraph/source/change.rb#30
  def write(text, nullable = T.unsafe(nil)); end

  private

  # source://solargraph//lib/solargraph/source/change.rb#72
  def commit(text, insert); end
end

# Information about a position in a source, including the word located
# there.
class Solargraph::Source::Cursor
  # @param source [Source]
  # @param position [Position, Array(Integer, Integer)]
  # @return [Cursor] a new instance of Cursor
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#17
  def initialize(source, position); end

  # True if the statement at the cursor is an argument to a previous
  # method.
  #
  # Given the code `process(foo)`, a cursor pointing at `foo` would
  # identify it as an argument being passed to the `process` method.
  #
  # If #argument? is true, the #recipient method will return a cursor that
  # points to the method receiving the argument.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#91
  def argument?; end

  # @return [Chain]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#77
  def chain; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#97
  def comment?; end

  # The part of the word after the current position. Given the text
  # `foo.bar`, the end_of_word at position (0,6) is `r`.
  #
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#53
  def end_of_word; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#23
  def filename; end

  # source://solargraph//lib/solargraph/source/cursor.rb#118
  def node; end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#123
  def node_position; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#143
  def offset; end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#10
  def position; end

  # The range of the word at the current position.
  #
  # @return [Range]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#68
  def range; end

  # Get a cursor pointing to the method that receives the current statement
  # as an argument.
  #
  # @return [Cursor, nil]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#110
  def receiver; end

  # Get a cursor pointing to the method that receives the current statement
  # as an argument.
  #
  # @return [Cursor, nil]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#110
  def recipient; end

  # source://solargraph//lib/solargraph/source/cursor.rb#138
  def recipient_node; end

  # @return [Source]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#13
  def source; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#61
  def start_of_constant?; end

  # The part of the word before the current position. Given the text
  # `foo.bar`, the start_of_word at position(0, 6) is `ba`.
  #
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#39
  def start_of_word; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#102
  def string?; end

  # The whole word at the current position. Given the text `foo.bar`, the
  # word at position(0,6) is `bar`.
  #
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#31
  def word; end

  private

  # A regular expression to find the end of a word from an offset.
  #
  # @return [Regexp]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#159
  def end_word_pattern; end

  # A regular expression to find the start of a word from an offset.
  #
  # @return [Regexp]
  #
  # source://solargraph//lib/solargraph/source/cursor.rb#152
  def start_word_pattern; end
end

module Solargraph::Source::EncodingFixes
  private

  # Convert strings to normalized UTF-8.
  #
  # @param string [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/encoding_fixes.rb#12
  def normalize(string); end

  class << self
    # Convert strings to normalized UTF-8.
    #
    # @param string [String]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/source/encoding_fixes.rb#12
    def normalize(string); end
  end
end

# source://solargraph//lib/solargraph/source.rb#272
Solargraph::Source::FOLDING_NODE_TYPES = T.let(T.unsafe(nil), Array)

# Information about a location in a source, including the location's word
# and signature, literal values at the base of signatures, and whether the
# location is inside a string or comment. ApiMaps use Fragments to provide
# results for completion and definition queries.
class Solargraph::Source::SourceChainer
  # @param source [Source]
  # @param position [Position]
  # @return [SourceChainer] a new instance of SourceChainer
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#26
  def initialize(source, position); end

  # @return [Source::Chain]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#33
  def chain; end

  private

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#98
  def end_of_phrase; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#88
  def fixed_phrase; end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#93
  def fixed_position; end

  # @param line [Integer]
  # @param column [Integer]
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#125
  def get_offset(line, column); end

  # source://solargraph//lib/solargraph/source/source_chainer.rb#133
  def get_signature_data_at(index); end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#118
  def offset; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#83
  def phrase; end

  # @return [Position]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#77
  def position; end

  # source://solargraph//lib/solargraph/source/source_chainer.rb#129
  def signature_data; end

  # @return [Solargraph::Source]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#80
  def source; end

  # True if the current offset is inside a string.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source/source_chainer.rb#112
  def string?; end

  class << self
    # @param source [Source]
    # @param position [Position]
    # @return [Source::Chain]
    #
    # source://solargraph//lib/solargraph/source/source_chainer.rb#19
    def chain(source, position); end

    private

    def new(*_arg0); end
  end
end

# Updaters contain changes to be applied to a source. The source applies
# the update via the Source#synchronize method.
class Solargraph::Source::Updater
  # @param filename [String] The file to update.
  # @param version [Integer] A version number associated with this update.
  # @param changes [Array<Solargraph::Source::Change>] The changes.
  # @return [Updater] a new instance of Updater
  #
  # source://solargraph//lib/solargraph/source/updater.rb#21
  def initialize(filename, version, changes); end

  # @return [Array<Change>]
  #
  # source://solargraph//lib/solargraph/source/updater.rb#16
  def changes; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/updater.rb#10
  def filename; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/updater.rb#46
  def repair(text); end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source/updater.rb#13
  def version; end

  # @param text [String]
  # @param nullable [Boolean]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/source/updater.rb#33
  def write(text, nullable = T.unsafe(nil)); end
end

# An index of pins and other ApiMap-related data for a Source.
class Solargraph::SourceMap
  # @param source [Source]
  # @param pins [Array<Pin::Base>]
  # @param locals [Array<Pin::Base>]
  # @return [SourceMap] a new instance of SourceMap
  #
  # source://solargraph//lib/solargraph/source_map.rb#27
  def initialize(source, pins, locals); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source_map.rb#54
  def code; end

  # @param position [Position]
  # @return [Source::Cursor]
  #
  # source://solargraph//lib/solargraph/source_map.rb#83
  def cursor_at(position); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#69
  def document_symbols; end

  # @return [Environ]
  #
  # source://solargraph//lib/solargraph/source_map.rb#64
  def environ; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/source_map.rb#49
  def filename; end

  # @param path [String]
  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/source_map.rb#89
  def first_pin(path); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#22
  def locals; end

  # @param location [Location]
  # @return [Array<Pin::LocalVariable>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#130
  def locals_at(location); end

  # source://solargraph//lib/solargraph/source_map.rb#104
  def locate_block_pin(line, character); end

  # source://solargraph//lib/solargraph/source_map.rb#100
  def locate_named_path_pin(line, character); end

  # @param location [Solargraph::Location]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#95
  def locate_pins(location); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#19
  def pins; end

  # source://solargraph//lib/solargraph/source_map.rb#37
  def pins_by_class(klass); end

  # @param query [String]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#77
  def query_symbols(query); end

  # source://solargraph//lib/solargraph/source_map.rb#41
  def rebindable_method_names; end

  # @param name [String]
  # @return [Array<Location>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#124
  def references(name); end

  # @return [Array<Pin::Reference::Require>]
  #
  # source://solargraph//lib/solargraph/source_map.rb#59
  def requires; end

  # @return [Source]
  #
  # source://solargraph//lib/solargraph/source_map.rb#16
  def source; end

  # @param other_map [SourceMap]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source_map.rb#110
  def try_merge!(other_map); end

  private

  # @param line [Integer]
  # @param character [Integer]
  # @param klasses [Array<Class>]
  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/source_map.rb#166
  def _locate_pin(line, character, *klasses); end

  class << self
    # @param filename [String]
    # @return [SourceMap]
    #
    # source://solargraph//lib/solargraph/source_map.rb#139
    def load(filename); end

    # @param code [String]
    # @param filename [String, nil]
    # @return [SourceMap]
    #
    # source://solargraph//lib/solargraph/source_map.rb#147
    def load_string(code, filename = T.unsafe(nil)); end

    # @param source [Source]
    # @return [SourceMap]
    #
    # source://solargraph//lib/solargraph/source_map.rb#154
    def map(source); end
  end
end

# A static analysis tool for obtaining definitions, completions,
# signatures, and type inferences from a cursor.
class Solargraph::SourceMap::Clip
  # @param api_map [ApiMap]
  # @param cursor [Source::Cursor]
  # @return [Clip] a new instance of Clip
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#11
  def initialize(api_map, cursor); end

  # @return [Completion]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#25
  def complete; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#17
  def define; end

  # source://solargraph//lib/solargraph/source_map/clip.rb#59
  def gates; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#63
  def in_block?; end

  # @return [ComplexType]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#44
  def infer; end

  # Get an array of all the locals that are visible from the cursors's
  # position. Locals can be local variables, method parameters, or block
  # parameters. The array starts with the nearest local pin.
  #
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#55
  def locals; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#37
  def signify; end

  # @param phrase [String]
  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#73
  def translate(phrase); end

  private

  # @return [ApiMap]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#81
  def api_map; end

  # @return [Solargraph::Pin::Base]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#96
  def block; end

  # source://solargraph//lib/solargraph/source_map/clip.rb#175
  def code_complete; end

  # @return [Array<Pin::KeywordParam]] Array<Pin::KeywordParam]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#123
  def complete_keyword_parameters; end

  # The context at the current position.
  #
  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#103
  def context_pin; end

  # @return [Source::Cursor]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#84
  def cursor; end

  # source://solargraph//lib/solargraph/source_map/clip.rb#91
  def location; end

  # @param result [Array<Pin::Base>]
  # @return [Completion]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#148
  def package_completions(result); end

  # @return [SourceMap]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#87
  def source_map; end

  # source://solargraph//lib/solargraph/source_map/clip.rb#157
  def tag_complete; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/clip.rb#108
  def yielded_self_pins; end
end

# The result of a completion request containing the pins that describe
# completion options and the range to be replaced.
class Solargraph::SourceMap::Completion
  # @param pins [Array<Solargraph::Pin::Base>]
  # @param range [Solargraph::Range]
  # @return [Completion] a new instance of Completion
  #
  # source://solargraph//lib/solargraph/source_map/completion.rb#17
  def initialize(pins, range); end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/completion.rb#10
  def pins; end

  # @return [Solargraph::Range]
  #
  # source://solargraph//lib/solargraph/source_map/completion.rb#13
  def range; end
end

# The Mapper generates pins and other data for SourceMaps.
#
# This class is used internally by the SourceMap class. Users should not
# normally need to call it directly.
class Solargraph::SourceMap::Mapper
  # @param position [Solargraph::Position]
  # @return [Solargraph::Pin::Closure]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#61
  def closure_at(position); end

  # @param comment [String]
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#81
  def find_directive_line_number(comment, tag, start); end

  # Generate the data.
  #
  # @param source [Source]
  # @return [Array]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#21
  def map(source); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#202
  def no_empty_lines?(line1, line2); end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#55
  def pins; end

  # source://solargraph//lib/solargraph/source_map/mapper.rb#65
  def process_comment(source_position, comment_position, comment); end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#226
  def process_comment_directives; end

  # @param source_position [Position]
  # @param comment_position [Position]
  # @param directive [YARD::Tags::Directive]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#96
  def process_directive(source_position, comment_position, directive); end

  # source://solargraph//lib/solargraph/source_map/mapper.rb#206
  def remove_inline_comment_hashes(comment); end

  # @param filename [String]
  # @param code [String]
  # @return [Array]
  #
  # source://solargraph//lib/solargraph/source_map/mapper.rb#38
  def unmap(filename, code); end

  class << self
    # @param source [Source]
    # @return [Array]
    #
    # source://solargraph//lib/solargraph/source_map/mapper.rb#48
    def map(source); end

    private

    def new(*_arg0); end
  end
end

# source://solargraph//lib/solargraph/source_map/mapper.rb#15
Solargraph::SourceMap::Mapper::MACRO_REGEXP = T.let(T.unsafe(nil), Regexp)

class Solargraph::SourceNotAvailableError < ::StandardError; end

# A static analysis tool for validating data types.
class Solargraph::TypeChecker
  include ::Solargraph::TypeChecker::Checks
  include ::Solargraph::Parser::Rubyvm::NodeMethods

  # @param filename [String]
  # @param api_map [ApiMap]
  # @param level [Symbol]
  # @return [TypeChecker] a new instance of TypeChecker
  #
  # source://solargraph//lib/solargraph/type_checker.rb#27
  def initialize(filename, api_map: T.unsafe(nil), level: T.unsafe(nil)); end

  # @return [ApiMap]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#22
  def api_map; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#16
  def filename; end

  # @return [Array<Problem>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#41
  def problems; end

  # @return [Rules]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#19
  def rules; end

  # @return [SourceMap]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#36
  def source_map; end

  private

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#511
  def abstract?(pin); end

  # @return [Array<Pin::BaseVariable>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#201
  def all_variables; end

  # source://solargraph//lib/solargraph/type_checker.rb#257
  def argument_problems_for(chain, api_map, block_pin, locals, location); end

  # @param pin [Pin::Method]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#421
  def arity_problems_for(pin, arguments, location); end

  # source://solargraph//lib/solargraph/type_checker.rb#223
  def call_problems; end

  # source://solargraph//lib/solargraph/type_checker.rb#205
  def const_problems; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#393
  def declared_externally?(pin); end

  # @param pin [Pin::Base]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#389
  def external?(pin); end

  # source://solargraph//lib/solargraph/type_checker.rb#516
  def fake_args_for(pin); end

  # @param [Array<Pin::Method>]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#370
  def first_param_hash(pins); end

  # source://solargraph//lib/solargraph/type_checker.rb#158
  def ignored_pins; end

  # @param pin [Pin::Base]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#379
  def internal?(pin); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#384
  def internal_or_core?(pin); end

  # source://solargraph//lib/solargraph/type_checker.rb#310
  def kwarg_problems_for(argchain, api_map, block_pin, locals, location, pin, params, first); end

  # source://solargraph//lib/solargraph/type_checker.rb#339
  def kwrestarg_problems_for(api_map, block_pin, locals, location, pin, params, kwargs); end

  # @param pin [Pin::Method]
  # @return [Array<Problem>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#137
  def method_param_type_problems_for(pin); end

  # @param pin [Pin::Method]
  # @return [Array<Problem>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#88
  def method_return_type_problems_for(pin); end

  # @return [Array<Problem>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#76
  def method_tag_problems; end

  # @param pin [Pin::Method]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#502
  def optional_param_count(pin); end

  # @param [Pin::Method]
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#354
  def param_hash(pin); end

  # @param pin [Pin::Method]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#430
  def pin_arity_problems_for(pin, arguments, location); end

  # @param pin [Pin::Method]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#497
  def required_param_count(pin); end

  # @param pin [Pin::Base]
  # @return [Boolean]
  # @todo This is not optimal. A better solution would probably be to mix
  #   namespace alias into types at the ApiMap level.
  #
  # source://solargraph//lib/solargraph/type_checker.rb#122
  def resolved_constant?(pin); end

  # @return [Array<Problem>]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#163
  def variable_type_tag_problems; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker.rb#131
  def virtual_pin?(pin); end

  # source://solargraph//lib/solargraph/type_checker.rb#536
  def without_ignored(problems); end

  class << self
    # @param filename [String]
    # @return [self]
    #
    # source://solargraph//lib/solargraph/type_checker.rb#55
    def load(filename, level = T.unsafe(nil)); end

    # @param code [String]
    # @param filename [String, nil]
    # @return [self]
    #
    # source://solargraph//lib/solargraph/type_checker.rb#65
    def load_string(code, filename = T.unsafe(nil), level = T.unsafe(nil)); end
  end
end

# Helper methods for performing type checks
module Solargraph::TypeChecker::Checks
  private

  # @param api_map [ApiMap]
  # @param inferred [ComplexType]
  # @param expected [ComplexType]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#68
  def all_types_match?(api_map, inferred, expected); end

  # @param api_map [ApiMap]
  # @param expected [ComplexType]
  # @param inferred [ComplexType]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#52
  def any_types_match?(api_map, expected, inferred); end

  # @param api_map [ApiMap]
  # @param expected [ComplexType]
  # @param inferred [ComplexType]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#81
  def duck_types_match?(api_map, expected, inferred); end

  # @param api_map [ApiMap]
  # @param cls1 [ComplexType::UniqueType]
  # @param cls2 [ComplexType::UniqueType]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#105
  def either_way?(api_map, cls1, cls2); end

  # @param type [ComplexType::UniqueType]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#93
  def fuzz(type); end

  # Compare an expected type with an inferred type. Common usage is to
  # check if the type declared in a method's @return tag matches the type
  # inferred from static analysis of the code.
  #
  # @param api_map [ApiMap]
  # @param expected [ComplexType]
  # @param inferred [ComplexType]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/checks.rb#18
  def types_match?(api_map, expected, inferred); end

  class << self
    # @param api_map [ApiMap]
    # @param inferred [ComplexType]
    # @param expected [ComplexType]
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#68
    def all_types_match?(api_map, inferred, expected); end

    # @param api_map [ApiMap]
    # @param expected [ComplexType]
    # @param inferred [ComplexType]
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#52
    def any_types_match?(api_map, expected, inferred); end

    # @param api_map [ApiMap]
    # @param expected [ComplexType]
    # @param inferred [ComplexType]
    # @raise [ArgumentError]
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#81
    def duck_types_match?(api_map, expected, inferred); end

    # @param api_map [ApiMap]
    # @param cls1 [ComplexType::UniqueType]
    # @param cls2 [ComplexType::UniqueType]
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#105
    def either_way?(api_map, cls1, cls2); end

    # @param type [ComplexType::UniqueType]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#93
    def fuzz(type); end

    # Compare an expected type with an inferred type. Common usage is to
    # check if the type declared in a method's @return tag matches the type
    # inferred from static analysis of the code.
    #
    # @param api_map [ApiMap]
    # @param expected [ComplexType]
    # @param inferred [ComplexType]
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/type_checker/checks.rb#18
    def types_match?(api_map, expected, inferred); end
  end
end

# Data about a method parameter definition. This is the information from
# the args list in the def call, not the `@param` tags.
class Solargraph::TypeChecker::ParamDef
  # @return [ParamDef] a new instance of ParamDef
  #
  # source://solargraph//lib/solargraph/type_checker/param_def.rb#15
  def initialize(name, type); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/type_checker/param_def.rb#10
  def name; end

  # @return [Symbol]
  #
  # source://solargraph//lib/solargraph/type_checker/param_def.rb#13
  def type; end

  class << self
    # Get an array of ParamDefs from a method pin.
    #
    # @param pin [Solargraph::Pin::Method]
    # @return [Array<ParamDef>]
    #
    # source://solargraph//lib/solargraph/type_checker/param_def.rb#25
    def from(pin); end
  end
end

# A problem reported by TypeChecker.
class Solargraph::TypeChecker::Problem
  # @param location [Solargraph::Location]
  # @param message [String]
  # @param pin [Solargraph::Pin::Base, nil]
  # @param suggestion [String, nil]
  # @return [Problem] a new instance of Problem
  #
  # source://solargraph//lib/solargraph/type_checker/problem.rb#24
  def initialize(location, message, pin: T.unsafe(nil), suggestion: T.unsafe(nil)); end

  # @return [Solargraph::Location]
  #
  # source://solargraph//lib/solargraph/type_checker/problem.rb#9
  def location; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/type_checker/problem.rb#12
  def message; end

  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/type_checker/problem.rb#15
  def pin; end

  # @return [String, nil]
  #
  # source://solargraph//lib/solargraph/type_checker/problem.rb#18
  def suggestion; end
end

# Definitions of type checking rules to be performed at various levels
class Solargraph::TypeChecker::Rules
  # @param level [Symbol]
  # @return [Rules] a new instance of Rules
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#22
  def initialize(level); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#32
  def ignore_all_undefined?; end

  # @return [Symbol]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#16
  def level; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#48
  def must_tag_or_infer?; end

  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#19
  def rank; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#44
  def require_type_tags?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#40
  def validate_calls?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#36
  def validate_consts?; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/type_checker/rules.rb#52
  def validate_tags?; end
end

# source://solargraph//lib/solargraph/type_checker/rules.rb#8
Solargraph::TypeChecker::Rules::LEVELS = T.let(T.unsafe(nil), Hash)

# source://solargraph//lib/solargraph/version.rb#4
Solargraph::VERSION = T.let(T.unsafe(nil), String)

# source://solargraph//lib/solargraph.rb#48
Solargraph::VIEWS_PATH = T.let(T.unsafe(nil), String)

# A workspace consists of the files in a project's directory and the
# project's configuration. It provides a Source for each file to be used
# in an associated Library or ApiMap.
class Solargraph::Workspace
  # @param directory [String]
  # @param config [Config, nil]
  # @return [Workspace] a new instance of Workspace
  #
  # source://solargraph//lib/solargraph/workspace.rb#29
  def initialize(directory = T.unsafe(nil), config = T.unsafe(nil)); end

  # @return [Solargraph::Workspace::Config]
  #
  # source://solargraph//lib/solargraph/workspace.rb#39
  def config; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/workspace.rb#16
  def directory; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#81
  def filenames; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#24
  def gemnames; end

  # True if the workspace contains at least one gemspec file.
  #
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace.rb#118
  def gemspec?; end

  # Get an array of all gemspec files in the workspace.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#125
  def gemspecs; end

  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace.rb#92
  def has_file?(filename); end

  # Merge the source. A merge will update the existing source for the file
  # or add it to the sources if the workspace is configured to include it.
  # The source is ignored if the configuration excludes it.
  #
  # @param source [Solargraph::Source]
  # @return [Boolean] True if the source was added to the workspace
  #
  # source://solargraph//lib/solargraph/workspace.rb#49
  def merge(source); end

  # Remove a source from the workspace. The source will not be removed if
  # its file exists and the workspace is configured to include it.
  #
  # @param filename [String]
  # @return [Boolean] True if the source was removed from the workspace
  #
  # source://solargraph//lib/solargraph/workspace.rb#74
  def remove(filename); end

  # The require paths associated with the workspace.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#21
  def require_paths; end

  # Get a source by its filename.
  #
  # @param filename [String]
  # @return [Solargraph::Source]
  #
  # source://solargraph//lib/solargraph/workspace.rb#100
  def source(filename); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#24
  def source_gems; end

  # @return [Array<Solargraph::Source>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#86
  def sources; end

  # Synchronize the workspace from the provided updater.
  #
  # @param updater [Source::Updater]
  # @return [void]
  #
  # source://solargraph//lib/solargraph/workspace.rb#136
  def synchronize!(updater); end

  # Determine whether a file would be merged into the workspace.
  #
  # @param filename [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace.rb#63
  def would_merge?(filename); end

  # True if the path resolves to a file in the workspace's require paths.
  #
  # @param path [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace.rb#108
  def would_require?(path); end

  private

  # Get additional require paths defined in the configuration.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#199
  def configured_require_paths; end

  # Generate require paths from gemspecs if they exist or assume the default
  # lib directory.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace.rb#167
  def generate_require_paths; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/workspace.rb#148
  def load_sources; end

  # source://solargraph//lib/solargraph/workspace.rb#205
  def require_plugins; end

  # @return [Hash{String => Solargraph::Source}]
  #
  # source://solargraph//lib/solargraph/workspace.rb#143
  def source_hash; end
end

# Configuration data for a workspace.
class Solargraph::Workspace::Config
  # @param directory [String]
  # @return [Config] a new instance of Config
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#21
  def initialize(directory = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#44
  def allow?(filename); end

  # The calculated array of (included - excluded) files in the workspace.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#53
  def calculated; end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#15
  def directory; end

  # An array of domains configured for the workspace.
  # A domain is a namespace that the ApiMap should include in the global
  # namespace. It's typically used to identify available DSLs.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#63
  def domains; end

  # An array of files excluded from the workspace.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#39
  def excluded; end

  # A hash of options supported by the formatter
  #
  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#91
  def formatter; end

  # An array of files included in the workspace (before calculating excluded files).
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#31
  def included; end

  # The maximum number of files to parse from the workspace.
  #
  # @return [Integer]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#105
  def max_files; end

  # An array of plugins to require.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#98
  def plugins; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#18
  def raw_data; end

  # An array of reporters to use for diagnostics.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#84
  def reporters; end

  # An array of load paths for required paths.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#77
  def require_paths; end

  # An array of required paths to add to the workspace.
  #
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#70
  def required; end

  private

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#124
  def config_data; end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#147
  def default_config; end

  # source://solargraph//lib/solargraph/workspace/config.rb#224
  def excluded_directories; end

  # True if the glob translates to a whole directory.
  #
  # @example
  #   glob_is_directory?('path/to/dir')       # => true
  #   glob_is_directory?('path/to/dir/**/*)   # => true
  #   glob_is_directory?('path/to/file.txt')  # => false
  #   glob_is_directory?('path/to/*.txt')     # => false
  # @param glob [String]
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#209
  def glob_is_directory?(glob); end

  # Translate a glob to a base directory if applicable
  #
  # @example
  #   glob_to_directory('path/to/dir/**/*') # => 'path/to/dir'
  # @param glob [String]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#220
  def glob_to_directory(glob); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#112
  def global_config_path; end

  # Modify the included files based on excluded directories and get an
  # array of additional files to exclude.
  #
  # @param globs [Array<String>]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#186
  def process_exclusions(globs); end

  # Get an array of files from the provided globs.
  #
  # @param globs [Array<String>]
  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#172
  def process_globs(globs); end

  # Read a .solargraph yaml config
  #
  # @param directory [String]
  # @return [Hash, nil]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#140
  def read_config(config_path = T.unsafe(nil)); end

  # @return [String]
  #
  # source://solargraph//lib/solargraph/workspace/config.rb#118
  def workspace_config_path; end
end

# The maximum number of files that can be added to a workspace.
# The workspace's .solargraph.yml can override this value.
#
# source://solargraph//lib/solargraph/workspace/config.rb#12
Solargraph::Workspace::Config::MAX_FILES = T.let(T.unsafe(nil), Integer)

class Solargraph::WorkspaceTooLargeError < ::RuntimeError; end

# source://solargraph//lib/solargraph.rb#46
Solargraph::YARDOC_PATH = T.let(T.unsafe(nil), String)

# source://solargraph//lib/solargraph.rb#47
Solargraph::YARD_EXTENSION_FILE = T.let(T.unsafe(nil), String)

# The YardMap provides access to YARD documentation for the Ruby core, the
# stdlib, and gems.
class Solargraph::YardMap
  include ::Solargraph::ApiMap::BundlerMethods

  # @param required [Array<String>, Set<String>]
  # @param directory [String]
  # @param source_gems [Array<String>, Set<String>]
  # @param with_dependencies [Boolean]
  # @return [YardMap] a new instance of YardMap
  #
  # source://solargraph//lib/solargraph/yard_map.rb#51
  def initialize(required: T.unsafe(nil), directory: T.unsafe(nil), source_gems: T.unsafe(nil), with_dependencies: T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/yard_map.rb#162
  def base_required; end

  # @param new_requires [Set<String>] Required paths to use for loading gems
  # @param new_directory [String] The workspace directory
  # @param new_source_gems [Set<String>] Gems under local development (i.e., part of the workspace)
  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#70
  def change(new_requires, new_directory, new_source_gems); end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#130
  def core_pins; end

  # source://solargraph//lib/solargraph/yard_map.rb#166
  def directory; end

  # @param y [String]
  # @return [YARD::Registry]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#117
  def load_yardoc(y); end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#111
  def missing_docs; end

  # @param path [String]
  # @return [Pin::Base]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#137
  def path_pin(path); end

  # @return [Array<Solargraph::Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#57
  def pins; end

  # @return [Set<String>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#87
  def rebindable_method_names; end

  # Get the location of a file referenced by a require path.
  #
  # @param path [String]
  # @return [Location]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#145
  def require_reference(path); end

  # @return [Set<String>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#101
  def required; end

  # source://solargraph//lib/solargraph/yard_map.rb#29
  def stdlib_paths; end

  # source://solargraph//lib/solargraph/yard_map.rb#158
  def stdlib_pins; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#106
  def unresolved_requires; end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#45
  def with_dependencies=(_arg0); end

  # @return [Boolean]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#61
  def with_dependencies?; end

  # @return [Array<String>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#96
  def yardocs; end

  private

  # @return [YardMap::Cache]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#173
  def cache; end

  # source://solargraph//lib/solargraph/yard_map.rb#359
  def load_core_pins; end

  # source://solargraph//lib/solargraph/yard_map.rb#401
  def load_stdlib_pins(base); end

  # @return [Hash]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#178
  def pin_class_hash; end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#183
  def pins_by_class(klass); end

  # @param r [String]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#254
  def pins_for_require(r, already_errored); end

  # source://solargraph//lib/solargraph/yard_map.rb#233
  def process_error(req, result, already_errored, yd = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/yard_map.rb#248
  def process_gemsets; end

  # @return [void]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#199
  def process_requires; end

  # @param y [String, nil]
  # @param spec [Gem::Specification, nil]
  # @raise [NoYardocError]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#288
  def process_yardoc(y, spec = T.unsafe(nil)); end

  # source://solargraph//lib/solargraph/yard_map.rb#379
  def read_core_and_save_cache(yd, ser); end

  # source://solargraph//lib/solargraph/yard_map.rb#425
  def read_stdlib_and_save_cache(base, ser); end

  # @param ns [YARD::CodeObjects::NamespaceObject]
  # @return [Array<YARD::CodeObjects::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#189
  def recurse_namespace_object(ns); end

  # @param path [String]
  # @return [Gem::Specification]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#342
  def spec_for_require(path); end

  # @param spec [Gem::Specification]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/yard_map.rb#330
  def yardoc_file_for_spec(spec); end
end

class Solargraph::YardMap::Cache
  # @return [Cache] a new instance of Cache
  #
  # source://solargraph//lib/solargraph/yard_map/cache.rb#6
  def initialize; end

  # source://solargraph//lib/solargraph/yard_map/cache.rb#14
  def get_path_pins(path); end

  # source://solargraph//lib/solargraph/yard_map/cache.rb#10
  def set_path_pins(path, pins); end
end

# Tools for managing core documentation.
module Solargraph::YardMap::CoreDocs
  class << self
    # Get a list of core documentation versions that are available for
    # download.
    #
    # @raise [SourceNotAvailableError]
    # @return [Array<String>] The version numbers
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#80
    def available; end

    # Get the version number of core documentation available for download
    # that is the closest match for the current Ruby version.
    #
    # @param current [String] The version to compare
    # @return [String] The version number of the best match
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#93
    def best_download(current = T.unsafe(nil)); end

    # Get the version number of the installed core documentation that is
    # the closest match for the current Ruby version.
    #
    # @return [String] The closest match
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#67
    def best_match; end

    # The directory where core documentation is installed.
    #
    # @return [String]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#23
    def cache_dir; end

    # Reset the core documentation cache to the minimum requirement.
    #
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#141
    def clear; end

    # Download the specified version of core documentation.
    #
    # @param version [String]
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#124
    def download(version); end

    # Ensure installation of minimum documentation.
    #
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#32
    def require_minimum; end

    # True if core documentation is installed for the specified version
    # number.
    #
    # @param ver [String] The version number to check
    # @return [Boolean]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#44
    def valid?(ver); end

    # Get a list of version numbers for currently installed core
    # documentation.
    #
    # @return [Array<String>] The installed version numbers
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#56
    def versions; end

    # Get the path to a yardoc file for Ruby core documentation.
    #
    # @param ver [String] The version number (best match is default)
    # @raise [ArgumentError]
    # @return [String] The path to the yardoc
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#106
    def yardoc_file(ver = T.unsafe(nil)); end

    # Get the path to a yardoc file for Ruby stdlib documentation.
    #
    # @param ver [String] The version number (best match is default)
    # @raise [ArgumentError]
    # @return [String] The path to the yardoc
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#115
    def yardoc_stdlib_file(ver = T.unsafe(nil)); end

    private

    # Extract the specified archive to the core cache directory.
    #
    # @param filename [String]
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_docs.rb#152
    def install_archive(filename); end
  end
end

# The default core documentation version
#
# source://solargraph//lib/solargraph/yard_map/core_docs.rb#17
Solargraph::YardMap::CoreDocs::DEFAULT = T.let(T.unsafe(nil), String)

# The URL for downloading core documentation
#
# source://solargraph//lib/solargraph/yard_map/core_docs.rb#14
Solargraph::YardMap::CoreDocs::SOURCE = T.let(T.unsafe(nil), String)

module Solargraph::YardMap::CoreFills; end

# source://solargraph//lib/solargraph/yard_map/core_fills.rb#205
Solargraph::YardMap::CoreFills::ALL = T.let(T.unsafe(nil), Array)

# source://solargraph//lib/solargraph/yard_map/core_fills.rb#6
Solargraph::YardMap::CoreFills::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://solargraph//lib/solargraph/yard_map/core_fills.rb#22
Solargraph::YardMap::CoreFills::OVERRIDES = T.let(T.unsafe(nil), Array)

# source://solargraph//lib/solargraph/yard_map/core_fills.rb#4
Solargraph::YardMap::CoreFills::Override = Solargraph::Pin::Reference::Override

# source://solargraph//lib/solargraph/yard_map/core_fills.rb#185
Solargraph::YardMap::CoreFills::PINS = T.let(T.unsafe(nil), Array)

# Tools for generating core documentation.
module Solargraph::YardMap::CoreGen
  class << self
    # Generate documentation from the specified Ruby source directory.
    #
    # @param ruby_dir [String] The Ruby source directory
    # @param dest_dir [String] The destination directory for the yardocs
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_gen.rb#20
    def generate_docs(ruby_dir, dest_dir); end

    # Generate a gzip of documentation from the specified Ruby source
    # directory.
    #
    # This method is designed to generate the directory architecture that
    # YardMap core docs expect.
    #
    # @param ruby_dir [String] The Ruby source directory
    # @param ver_name [String, nil] The version name
    # @param dest_dir [String] The destination directory
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/core_gen.rb#41
    def generate_gzip(ruby_dir, ver_name = T.unsafe(nil), dest_dir = T.unsafe(nil)); end

    private

    # @param dir [String] The directory to compress
    # @param dst [String] The destination file
    #
    # source://solargraph//lib/solargraph/yard_map/core_gen.rb#58
    def gzip(dir, dst); end
  end
end

module Solargraph::YardMap::Helpers
  private

  # @param code_object [YARD::CodeObjects::Base]
  # @param spec [Gem::Specification]
  # @return [Solargraph::Location, nil]
  #
  # source://solargraph//lib/solargraph/yard_map/helpers.rb#9
  def object_location(code_object, spec); end

  class << self
    # @param code_object [YARD::CodeObjects::Base]
    # @param spec [Gem::Specification]
    # @return [Solargraph::Location, nil]
    #
    # source://solargraph//lib/solargraph/yard_map/helpers.rb#9
    def object_location(code_object, spec); end
  end
end

class Solargraph::YardMap::Mapper
  # @param code_objects [Array<YARD::CodeObjects::Base>]
  # @param spec [Gem::Specification]
  # @return [Mapper] a new instance of Mapper
  #
  # source://solargraph//lib/solargraph/yard_map/mapper.rb#12
  def initialize(code_objects, spec = T.unsafe(nil)); end

  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map/mapper.rb#20
  def map; end

  private

  # @param code_object [YARD::CodeObjects::Base]
  # @return [Array<Pin::Base>]
  #
  # source://solargraph//lib/solargraph/yard_map/mapper.rb#34
  def generate_pins(code_object); end
end

module Solargraph::YardMap::Mapper::ToConstant
  extend ::Solargraph::YardMap::Helpers

  class << self
    # source://solargraph//lib/solargraph/yard_map/mapper/to_constant.rb#9
    def make(code_object, closure = T.unsafe(nil), spec = T.unsafe(nil)); end
  end
end

module Solargraph::YardMap::Mapper::ToMethod
  extend ::Solargraph::YardMap::Helpers

  class << self
    # source://solargraph//lib/solargraph/yard_map/mapper/to_method.rb#9
    def make(code_object, name = T.unsafe(nil), scope = T.unsafe(nil), visibility = T.unsafe(nil), closure = T.unsafe(nil), spec = T.unsafe(nil)); end

    private

    # @param a [Array]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/yard_map/mapper/to_method.rb#53
    def arg_name(a); end

    # @param a [Array]
    # @return [::Symbol]
    #
    # source://solargraph//lib/solargraph/yard_map/mapper/to_method.rb#59
    def arg_type(a); end

    # @param code_object [YARD::CodeObjects::Base]
    # @return [Array<Solargraph::Pin::Parameter>]
    #
    # source://solargraph//lib/solargraph/yard_map/mapper/to_method.rb#33
    def get_parameters(code_object, location, comments); end
  end
end

module Solargraph::YardMap::Mapper::ToNamespace
  extend ::Solargraph::YardMap::Helpers

  class << self
    # source://solargraph//lib/solargraph/yard_map/mapper/to_namespace.rb#9
    def make(code_object, spec, closure = T.unsafe(nil)); end
  end
end

class Solargraph::YardMap::NoYardocError < ::StandardError; end

module Solargraph::YardMap::RdocToYard
  extend ::Solargraph::ApiMap::SourceToYard

  class << self
    # source://solargraph//lib/solargraph/yard_map/rdoc_to_yard.rb#104
    def base_name(mod); end

    # @param cmnt [RDoc::Comment]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/yard_map/rdoc_to_yard.rb#110
    def commentary(cmnt); end

    # source://solargraph//lib/solargraph/yard_map/rdoc_to_yard.rb#131
    def find_file(obj); end

    # @param obj [RDoc::Context]
    #
    # source://solargraph//lib/solargraph/yard_map/rdoc_to_yard.rb#121
    def locate(obj); end

    # @param spec [Gem::Specification]
    # @param cache_dir [String]
    # @return [void]
    #
    # source://solargraph//lib/solargraph/yard_map/rdoc_to_yard.rb#16
    def run(spec, cache_dir: T.unsafe(nil)); end
  end
end

module Solargraph::YardMap::StdlibFills
  class << self
    # @param path [String]
    # @return [Array<Pin::Reference::Override>]
    #
    # source://solargraph//lib/solargraph/yard_map/stdlib_fills.rb#38
    def get(path); end
  end
end

# source://solargraph//lib/solargraph/yard_map/stdlib_fills.rb#6
Solargraph::YardMap::StdlibFills::LIBS = T.let(T.unsafe(nil), Hash)

# source://solargraph//lib/solargraph/yard_map/stdlib_fills.rb#4
Solargraph::YardMap::StdlibFills::Override = Solargraph::Pin::Reference::Override

class Solargraph::YardMap::ToMethod
  extend ::Solargraph::YardMap::Helpers

  # source://solargraph//lib/solargraph/yard_map/to_method.rb#59
  def make(code_object, name = T.unsafe(nil), scope = T.unsafe(nil), visibility = T.unsafe(nil), closure = T.unsafe(nil), spec = T.unsafe(nil)); end
end

module Solargraph::YardMap::ToMethod::InnerMethods
  private

  # @param a [Array]
  # @return [String]
  #
  # source://solargraph//lib/solargraph/yard_map/to_method.rb#31
  def arg_name(a); end

  # @param a [Array]
  # @return [::Symbol]
  #
  # source://solargraph//lib/solargraph/yard_map/to_method.rb#37
  def arg_type(a); end

  # @param code_object [YARD::CodeObjects::Base]
  # @return [Array<Solargraph::Pin::Parameter>]
  #
  # source://solargraph//lib/solargraph/yard_map/to_method.rb#11
  def get_parameters(code_object, location, comments); end

  class << self
    # @param a [Array]
    # @return [String]
    #
    # source://solargraph//lib/solargraph/yard_map/to_method.rb#31
    def arg_name(a); end

    # @param a [Array]
    # @return [::Symbol]
    #
    # source://solargraph//lib/solargraph/yard_map/to_method.rb#37
    def arg_type(a); end

    # @param code_object [YARD::CodeObjects::Base]
    # @return [Array<Solargraph::Pin::Parameter>]
    #
    # source://solargraph//lib/solargraph/yard_map/to_method.rb#11
    def get_parameters(code_object, location, comments); end
  end
end
