# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `slim_lint` gem.
# Please instead update this file by running `bin/tapioca gem slim_lint`.

# Defines the gem version.
module SlimLint; end

# source://slim_lint//lib/slim_lint/constants.rb#6
SlimLint::APP_NAME = T.let(T.unsafe(nil), String)

# Represents an atomic, childless, literal value within an S-expression.
#
# This creates a light wrapper around literal values of S-expressions so we
# can make an {Atom} quack like a {Sexp} without being an {Sexp}.
class SlimLint::Atom
  # Creates an atom from the specified value.
  #
  # @param value [Object]
  # @return [Atom] a new instance of Atom
  #
  # source://slim_lint//lib/slim_lint/atom.rb#16
  def initialize(value); end

  # Returns whether this atom is equivalent to another object.
  #
  # This defines a helper which unwraps the inner value of the atom to compare
  # against a literal value, saving us having to do it ourselves everywhere
  # else.
  #
  # @param other [Object]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#28
  def ==(other); end

  # Displays a string representation of this {Atom} suitable for debugging.
  #
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#58
  def inspect; end

  # Stores the line number of the code in the original document that this Atom
  # came from.
  #
  # source://slim_lint//lib/slim_lint/atom.rb#11
  def line; end

  # Stores the line number of the code in the original document that this Atom
  # came from.
  #
  # source://slim_lint//lib/slim_lint/atom.rb#11
  def line=(_arg0); end

  # Returns whether this atom matches the given Sexp pattern.
  #
  # This exists solely to make an {Atom} quack like a {Sexp}, so we don't have
  # to manually check the type when doing comparisons elsewhere.
  #
  # @param [Array, Object]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#39
  def match?(pattern); end

  # Redirect methods to the value this {Atom} wraps.
  #
  # Again, this is for convenience so we don't need to manually unwrap the
  # value ourselves. It's pretty magical, but results in much DRYer code.
  #
  # @param method_sym [Symbol] method that was called
  # @param args [Array]
  # @yield block that was passed to the method
  #
  # source://slim_lint//lib/slim_lint/atom.rb#70
  def method_missing(method_sym, *args, &block); end

  # Return whether this {Atom} or the value it wraps responds to the given
  # message.
  #
  # @param method_sym [Symbol]
  # @param include_private [Boolean]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#90
  def respond_to?(method_sym, include_private = T.unsafe(nil)); end

  # Displays the string representation the value this {Atom} wraps.
  #
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#51
  def to_s; end

  private

  # @param method_name [String, Symbol] method name
  # @param args [Array]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/atom.rb#80
  def respond_to_missing?(method_name, *args); end
end

# source://slim_lint//lib/slim_lint/constants.rb#9
SlimLint::BUG_REPORT_URL = T.let(T.unsafe(nil), String)

# Holds the list of captures, providing a convenient interface for accessing
# the values and unwrapping them on your behalf.
class SlimLint::CaptureMap < ::Hash
  # Returns the captured value with the specified name.
  #
  # @param capture_name [Symbol]
  # @return [Object]
  #
  # source://slim_lint//lib/slim_lint/capture_map.rb#11
  def [](capture_name); end
end

# Stores runtime configuration for the application.
#
# The purpose of this class is to validate and ensure all configurations
# satisfy some basic pre-conditions so other parts of the application don't
# have to check the configuration for errors. It should have no knowledge of
# how these configuration values are ultimately used.
class SlimLint::Configuration
  # Creates a configuration from the given options hash.
  #
  # @param options [Hash]
  # @return [Configuration] a new instance of Configuration
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#17
  def initialize(options); end

  # Compares this configuration with another.
  #
  # @param other [SlimLint::Configuration]
  # @return [true, false] whether the given configuration is equivalent
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#34
  def ==(other); end

  # Access the configuration as if it were a hash.
  #
  # @param key [String]
  # @return [Array, Hash, Number, String]
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#26
  def [](key); end

  # Returns a non-modifiable configuration for the specified linter.
  #
  # @param linter [SlimLint::Linter, Class]
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#41
  def for_linter(linter); end

  # Internal hash storing the configuration.
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#12
  def hash; end

  # Merges the given configuration with this one, returning a new
  # {Configuration}. The provided configuration will either add to or replace
  # any options defined in this configuration.
  #
  # @param config [SlimLint::Configuration]
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#58
  def merge(config); end

  private

  # Ensures the `exclude` global option is an array.
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#89
  def ensure_exclude_option_array_exists; end

  # Ensure `include` and `exclude` options for linters are arrays
  # (since users can specify a single string glob pattern for convenience)
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#100
  def ensure_linter_include_exclude_arrays_exist; end

  # Ensures the `linters` configuration section exists.
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#94
  def ensure_linter_section_exists; end

  # Merge two hashes such that nested hashes are merged rather than replaced.
  #
  # @param parent [Hash]
  # @param child [Hash]
  # @return [Hash]
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#69
  def smart_merge(parent, child); end

  # Validates the configuration for any invalid options, normalizing it where
  # possible.
  #
  # source://slim_lint//lib/slim_lint/configuration.rb#82
  def validate; end
end

# Manages configuration file loading.
class SlimLint::ConfigurationLoader
  class << self
    # Loads the built-in default configuration.
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#27
    def default_configuration; end

    # Load configuration file given the current working directory the
    # application is running within.
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#15
    def load_applicable_config; end

    # Loads a configuration, ensuring it extends the default configuration.
    #
    # @param file [String]
    # @return [SlimLint::Configuration]
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#35
    def load_file(file); end

    # Creates a configuration from the specified hash, ensuring it extends the
    # default configuration.
    #
    # @param hash [Hash]
    # @return [SlimLint::Configuration]
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#50
    def load_hash(hash); end

    private

    # Parses and loads a configuration from the given file.
    #
    # @param file [String]
    # @return [SlimLint::Configuration]
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#62
    def load_from_file(file); end

    # Returns a list of possible configuration files given the context of the
    # specified directory.
    #
    # @param directory [String]
    # @return [Array<Pathname>]
    #
    # source://slim_lint//lib/slim_lint/configuration_loader.rb#78
    def possible_config_files(directory); end
  end
end

# source://slim_lint//lib/slim_lint/configuration_loader.rb#10
SlimLint::ConfigurationLoader::CONFIG_FILE_NAME = T.let(T.unsafe(nil), String)

# source://slim_lint//lib/slim_lint/configuration_loader.rb#9
SlimLint::ConfigurationLoader::DEFAULT_CONFIG_PATH = T.let(T.unsafe(nil), String)

# Represents a parsed Slim document and its associated metadata.
class SlimLint::Document
  # Parses the specified Slim code into a {Document}.
  #
  # @option options
  # @param source [String] Slim code to parse
  # @param options [Hash]
  # @raise [Slim::Parser::Error] if there was a problem parsing the document
  # @return [Document] a new instance of Document
  #
  # source://slim_lint//lib/slim_lint/document.rb#27
  def initialize(source, options); end

  # @return [SlimLint::Configuration] Configuration used to parse template
  #
  # source://slim_lint//lib/slim_lint/document.rb#7
  def config; end

  # @return [String] Slim template file path
  #
  # source://slim_lint//lib/slim_lint/document.rb#10
  def file; end

  # @return [SlimLint::Sexp] Sexpression representing the parsed document
  #
  # source://slim_lint//lib/slim_lint/document.rb#13
  def sexp; end

  # @return [String] original source code
  #
  # source://slim_lint//lib/slim_lint/document.rb#16
  def source; end

  # @return [Array<String>] original source code as an array of lines
  #
  # source://slim_lint//lib/slim_lint/document.rb#19
  def source_lines; end

  private

  # Ensure the string's encoding is valid.
  #
  # @param source [String]
  # @return [String] source encoded in a valid encoding
  #
  # source://slim_lint//lib/slim_lint/document.rb#51
  def process_encoding(source); end

  # @param source [String] Slim code to parse
  # @raise [SlimLint::Exceptions::ParseError] if there was a problem parsing the document
  #
  # source://slim_lint//lib/slim_lint/document.rb#38
  def process_source(source); end

  # Removes YAML frontmatter
  #
  # source://slim_lint//lib/slim_lint/document.rb#56
  def strip_frontmatter(source); end
end

# Temple engine used to generate a {Sexp} parse tree for use by linters.
#
# We omit a lot of the filters that are in {Slim::Engine} because they result
# in information potentially being removed from the parse tree (since some
# Sexp abstractions are optimized/removed or otherwise transformed). In order
# for linters to be useful, they need to operate on the original parse tree.
#
# The other key task this engine accomplishes is converting the Array-based
# S-expressions into {SlimLint::Sexp} objects, which have a number of helper
# methods that makes working with them easier. It also annotates these
# {SlimLint::Sexp} objects with line numbers so it's easy to cross reference
# with the original source code.
class SlimLint::Engine < ::Temple::Engine
  # Parses the given source code into a Sexp.
  #
  # @param source [String] source code to parse
  # @return [SlimLint::Sexp] parsed Sexp
  #
  # source://slim_lint//lib/slim_lint/engine.rb#33
  def parse(source); end
end

# Collection of exceptions that can be raised by the application.
module SlimLint::Exceptions; end

# Raised when a {Configuration} could not be loaded from a file.
class SlimLint::Exceptions::ConfigurationError < ::StandardError; end

# Raised when invalid/incompatible command line options are provided.
class SlimLint::Exceptions::InvalidCLIOption < ::StandardError; end

# Raised when an invalid file path is specified
class SlimLint::Exceptions::InvalidFilePath < ::StandardError; end

# Raised when attempting to execute `Runner` with options that would result in
# no linters being enabled.
class SlimLint::Exceptions::NoLintersError < ::StandardError; end

# Raised when the Slim parser is unable to parse a template.
class SlimLint::Exceptions::ParseError < ::Slim::Parser::SyntaxError; end

# Finds Slim files that should be linted given a specified list of paths, glob
# patterns, and configuration.
class SlimLint::FileFinder
  # Create a file finder using the specified configuration.
  #
  # @param config [SlimLint::Configuration]
  # @return [FileFinder] a new instance of FileFinder
  #
  # source://slim_lint//lib/slim_lint/file_finder.rb#16
  def initialize(config); end

  # Return list of files to lint given the specified set of paths and glob
  # patterns.
  #
  # @param patterns [Array<String>]
  # @param excluded_patterns [Array<String>]
  # @raise [SlimLint::Exceptions::InvalidFilePath]
  # @return [Array<String>] list of actual files
  #
  # source://slim_lint//lib/slim_lint/file_finder.rb#26
  def find(patterns, excluded_patterns); end

  private

  # Extract the list of matching files given the list of glob patterns, file
  # paths, and directories.
  #
  # @param patterns [Array<String>]
  # @return [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/file_finder.rb#41
  def extract_files_from(patterns); end

  # Trim "./" from the front of relative paths.
  #
  # @param path [String]
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/file_finder.rb#74
  def normalize_path(path); end

  # Whether the given file should be treated as a Slim file.
  #
  # @param file [String]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/file_finder.rb#82
  def slim_file?(file); end
end

# List of extensions of files to include under a directory when a directory
# is specified instead of a file.
#
# source://slim_lint//lib/slim_lint/file_finder.rb#11
SlimLint::FileFinder::VALID_EXTENSIONS = T.let(T.unsafe(nil), Array)

module SlimLint::Filters; end

# A dumbed-down version of {Slim::CodeAttributes} which doesn't introduce any
# temporary variables or other cruft.
class SlimLint::Filters::AttributeProcessor < ::Slim::Filter
  # Handle attribute expression `[:html, :attr, name, value]`
  #
  # @param name [String] name of the attribute
  # @param value [Array] Sexp representing the value
  #
  # source://slim_lint//lib/slim_lint/filters/attribute_processor.rb#21
  def on_html_attr(name, value); end

  # Handle attributes expression `[:html, :attrs, *attrs]`
  #
  # @param attrs [Array]
  # @return [Array]
  #
  # source://slim_lint//lib/slim_lint/filters/attribute_processor.rb#13
  def on_html_attrs(*attrs); end
end

# A dumbed-down version of {Slim::Controls} which doesn't introduce temporary
# variables and other cruft (which in the context of extracting Ruby code,
# results in a lot of weird cops reported by RuboCop).
class SlimLint::Filters::ControlProcessor < ::Slim::Filter
  # Handle control expression `[:slim, :control, code, content]`
  #
  # @param code [String]
  # @param content [Array]
  #
  # source://slim_lint//lib/slim_lint/filters/control_processor.rb#14
  def on_slim_control(code, content); end

  # Handle output expression `[:slim, :output, escape, code, content]`
  #
  # @param _escape [Boolean]
  # @param code [String]
  # @param content [Array]
  # @return [Array] Array
  #
  # source://slim_lint//lib/slim_lint/filters/control_processor.rb#26
  def on_slim_output(_escape, code, content); end

  # Handle text expression `[:slim, :text, type, content]`
  #
  # @param _type [Symbol]
  # @param content [Array]
  # @return [Array]
  #
  # source://slim_lint//lib/slim_lint/filters/control_processor.rb#41
  def on_slim_text(_type, content); end
end

# source://slim_lint//lib/slim_lint/filters/control_processor.rb#8
SlimLint::Filters::ControlProcessor::BLOCK_RE = T.let(T.unsafe(nil), Regexp)

# Traverses a Temple S-expression (that has already been converted to
# {SlimLint::Sexp} instances) and annotates them with line numbers.
#
# This is a hack that allows us to access line information directly from the
# S-expressions, which makes a lot of other tasks easier.
class SlimLint::Filters::InjectLineNumbers < ::Temple::Filter
  # Annotates the given {SlimLint::Sexp} with line number information.
  #
  # @param sexp [SlimLint::Sexp]
  # @return [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/filters/inject_line_numbers.rb#17
  def call(sexp); end

  private

  # Traverses an {Sexp}, annotating it with line numbers.
  #
  # @param sexp [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/filters/inject_line_numbers.rb#28
  def traverse(sexp); end
end

# {Sexp} representing a newline.
#
# source://slim_lint//lib/slim_lint/filters/inject_line_numbers.rb#11
SlimLint::Filters::InjectLineNumbers::NEWLINE_SEXP = T.let(T.unsafe(nil), SlimLint::Sexp)

# Converts a Temple S-expression comprised of {Array}s into {SlimLint::Sexp}s.
#
# These {SlimLint::Sexp}s include additional helpers that makes working with
# them more pleasant.
class SlimLint::Filters::SexpConverter < ::Temple::Filter
  # Converts the given {Array} to a {SlimLint::Sexp}.
  #
  # @param array_sexp [Array]
  # @return [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/filters/sexp_converter.rb#13
  def call(array_sexp); end
end

# A dumbed-down version of {Slim::Splat::Filter} which doesn't introduced
# temporary variables or other cruft.
class SlimLint::Filters::SplatProcessor < ::Slim::Filter
  # Handle slim splat expressions `[:slim, :splat, code]`
  #
  # @param code [String]
  # @return [Array]
  #
  # source://slim_lint//lib/slim_lint/filters/splat_processor.rb#11
  def on_slim_splat(code); end
end

# source://slim_lint//lib/slim_lint/constants.rb#5
SlimLint::HOME = T.let(T.unsafe(nil), String)

# Contains information about a problem or issue with a Slim document.
class SlimLint::Lint
  # Creates a new lint.
  #
  # @param linter [SlimLint::Linter]
  # @param filename [String]
  # @param line [Fixnum]
  # @param message [String]
  # @param severity [Symbol]
  # @return [Lint] a new instance of Lint
  #
  # source://slim_lint//lib/slim_lint/lint.rb#28
  def initialize(linter, filename, line, message, severity = T.unsafe(nil)); end

  # Return whether this lint has a severity of error.
  #
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/lint.rb#39
  def error?; end

  # @return [String] file path to which the lint applies
  #
  # source://slim_lint//lib/slim_lint/lint.rb#7
  def filename; end

  # @return [String] line number of the file the lint corresponds to
  #
  # source://slim_lint//lib/slim_lint/lint.rb#10
  def line; end

  # @return [SlimLint::Linter] linter that reported the lint
  #
  # source://slim_lint//lib/slim_lint/lint.rb#13
  def linter; end

  # @return [String] error/warning message to display to user
  #
  # source://slim_lint//lib/slim_lint/lint.rb#16
  def message; end

  # @return [Symbol] whether this lint is a warning or an error
  #
  # source://slim_lint//lib/slim_lint/lint.rb#19
  def severity; end
end

# Base implementation for all lint checks.
#
# @abstract
class SlimLint::Linter
  include ::SlimLint::SexpVisitor
  extend ::SlimLint::SexpVisitor::DSL

  # Initializes a linter with the specified configuration.
  #
  # @param config [Hash] configuration for this linter
  # @return [Linter] a new instance of Linter
  #
  # source://slim_lint//lib/slim_lint/linter.rb#21
  def initialize(config); end

  # List of lints reported by this linter.
  #
  # @todo Remove once spec/support/shared_linter_context returns an array of
  #   lints for the subject instead of the linter itself.
  #
  # source://slim_lint//lib/slim_lint/linter.rb#16
  def lints; end

  # Returns the simple name for this linter.
  #
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/linter.rb#40
  def name; end

  # Runs the linter against the given Slim document.
  #
  # @param document [SlimLint::Document]
  #
  # source://slim_lint//lib/slim_lint/linter.rb#29
  def run(document); end

  private

  # Returns the value of attribute config.
  #
  # source://slim_lint//lib/slim_lint/linter.rb#46
  def config; end

  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/linter.rb#67
  def disabled_for_line?(line); end

  # source://slim_lint//lib/slim_lint/linter.rb#71
  def disabled_lines; end

  # Returns the value of attribute document.
  #
  # source://slim_lint//lib/slim_lint/linter.rb#46
  def document; end

  # source://slim_lint//lib/slim_lint/linter.rb#90
  def linter_name; end

  # Parse Ruby code into an abstract syntax tree.
  #
  # @param source [String] Ruby code to parse
  # @return [AST::Node]
  #
  # source://slim_lint//lib/slim_lint/linter.rb#62
  def parse_ruby(source); end

  # Record a lint for reporting back to the user.
  #
  # @param node [#line] node to extract the line number from
  # @param message [String] error/warning to display to the user
  #
  # source://slim_lint//lib/slim_lint/linter.rb#52
  def report_lint(node, message); end
end

class SlimLint::Linter::CommentControlStatement < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/comment_control_statement.rb#8
  def on_pattern_1(sexp); end
end

class SlimLint::Linter::ConsecutiveControlStatements < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/consecutive_control_statements.rb#9
  def on_pattern_1(sexp); end

  private

  # source://slim_lint//lib/slim_lint/linter/consecutive_control_statements.rb#21
  def flat_control_statement?(sexp); end
end

class SlimLint::Linter::ControlStatementSpacing < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/control_statement_spacing.rb#10
  def on_pattern_1(sexp); end
end

# source://slim_lint//lib/slim_lint/linter/control_statement_spacing.rb#8
SlimLint::Linter::ControlStatementSpacing::MESSAGE = T.let(T.unsafe(nil), String)

class SlimLint::Linter::EmbeddedEngines < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/embedded_engines.rb#10
  def on_start(_sexp); end
end

# source://slim_lint//lib/slim_lint/linter/embedded_engines.rb#8
SlimLint::Linter::EmbeddedEngines::MESSAGE = T.let(T.unsafe(nil), String)

class SlimLint::Linter::EmptyControlStatement < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/empty_control_statement.rb#8
  def on_pattern_1(sexp); end
end

class SlimLint::Linter::EmptyLines < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/empty_lines.rb#9
  def on_start(_sexp); end
end

class SlimLint::Linter::FileLength < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/file_length.rb#10
  def on_start(_sexp); end
end

# source://slim_lint//lib/slim_lint/linter/file_length.rb#8
SlimLint::Linter::FileLength::MSG = T.let(T.unsafe(nil), String)

class SlimLint::Linter::LineLength < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/line_length.rb#10
  def on_start(_sexp); end
end

# source://slim_lint//lib/slim_lint/linter/line_length.rb#8
SlimLint::Linter::LineLength::MSG = T.let(T.unsafe(nil), String)

class SlimLint::Linter::RedundantDiv < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/redundant_div.rb#11
  def on_pattern_1(sexp); end
end

# source://slim_lint//lib/slim_lint/linter/redundant_div.rb#9
SlimLint::Linter::RedundantDiv::MESSAGE = T.let(T.unsafe(nil), String)

class SlimLint::Linter::RuboCop < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#12
  def on_start(_sexp); end

  private

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#56
  def extract_lints_from_offenses(offenses, source_map); end

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#31
  def find_lints(ruby, source_map); end

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#46
  def lint_file(rubocop, file); end

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#69
  def rubocop_flags; end

  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#81
  def with_ruby_from_stdin(ruby, &_block); end
end

class SlimLint::Linter::Tab < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/tab.rb#10
  def on_start(_sexp); end
end

# source://slim_lint//lib/slim_lint/linter/tab.rb#8
SlimLint::Linter::Tab::MSG = T.let(T.unsafe(nil), String)

class SlimLint::Linter::TagCase < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/tag_case.rb#8
  def on_pattern_1(sexp); end
end

class SlimLint::Linter::TrailingBlankLines < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/trailing_blank_lines.rb#8
  def on_start(_sexp); end
end

class SlimLint::Linter::TrailingWhitespace < ::SlimLint::Linter
  include ::SlimLint::LinterRegistry

  # source://slim_lint//lib/slim_lint/linter/trailing_whitespace.rb#8
  def on_start(_sexp); end
end

# Stores all defined linters.
module SlimLint::LinterRegistry
  class << self
    # Return a list of {SlimLint::Linter} {Class}es corresponding to the
    # specified list of names.
    #
    # @param linter_names [Array<String>]
    # @return [Array<Class>]
    #
    # source://slim_lint//lib/slim_lint/linter_registry.rb#28
    def extract_linters_from(linter_names); end

    # Executed when a linter includes the {LinterRegistry} module.
    #
    # This results in the linter being registered with the registry.
    #
    # @param subclass [Class]
    #
    # source://slim_lint//lib/slim_lint/linter_registry.rb#19
    def included(subclass); end

    # List of all registered linters.
    #
    # source://slim_lint//lib/slim_lint/linter_registry.rb#12
    def linters; end
  end
end

# Chooses the appropriate linters to run given the specified configuration.
class SlimLint::LinterSelector
  # Creates a selector using the given configuration and additional options.
  #
  # @param config [SlimLint::Configuration]
  # @param options [Hash]
  # @return [LinterSelector] a new instance of LinterSelector
  #
  # source://slim_lint//lib/slim_lint/linter_selector.rb#10
  def initialize(config, options); end

  # Returns the set of linters to run against the given file.
  #
  # @param file [String]
  # @raise [SlimLint::Exceptions::NoLintersError] when no linters are enabled
  # @return [Array<SlimLint::Linter>]
  #
  # source://slim_lint//lib/slim_lint/linter_selector.rb#20
  def linters_for_file(file); end

  private

  # Returns a list of linters that are enabled given the specified
  # configuration and additional options.
  #
  # @param config [SlimLint::Configuration]
  # @param options [Hash]
  # @return [Array<SlimLint::Linter>]
  #
  # source://slim_lint//lib/slim_lint/linter_selector.rb#33
  def extract_enabled_linters(config, options); end

  # Whether to run the given linter against the specified file.
  #
  # @param config [SlimLint::Configuration]
  # @param linter [SlimLint::Linter]
  # @param file [String]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/linter_selector.rb#64
  def run_linter_on_file?(config, linter, file); end
end

# Encapsulates all communication to an output source.
class SlimLint::Logger
  # Creates a new {SlimLint::Logger} instance.
  #
  # @param out [IO] the output destination.
  # @return [Logger] a new instance of Logger
  #
  # source://slim_lint//lib/slim_lint/logger.rb#19
  def initialize(out); end

  # Print the specified output in bold face.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#36
  def bold(*args); end

  # Print the specified output in a bold face and color indicative of error.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#52
  def bold_error(*args); end

  # Whether colored output via ANSI escape sequences is enabled.
  #
  # @return [true, false]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#8
  def color_enabled; end

  # Whether colored output via ANSI escape sequences is enabled.
  #
  # @return [true, false]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#8
  def color_enabled=(_arg0); end

  # Print the specified output in a color indicative of error.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#44
  def error(*args); end

  # Print the specified output in a color indicating information.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#76
  def info(*args); end

  # Print the specified output.
  #
  # @param output [String] the output to send
  # @param newline [true, false] whether to append a newline
  #
  # source://slim_lint//lib/slim_lint/logger.rb#27
  def log(output, newline = T.unsafe(nil)); end

  # Print a blank line.
  #
  # source://slim_lint//lib/slim_lint/logger.rb#81
  def newline; end

  # Print the specified output in a color indicative of success.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#60
  def success(*args); end

  # Whether this logger is outputting to a TTY.
  #
  # @return [true, false]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#88
  def tty?; end

  # Print the specified output in a color indicative of a warning.
  # If output destination is not a TTY, behaves the same as {#log}.
  #
  # @param args [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/logger.rb#68
  def warning(*args); end

  private

  # Print output in the specified color.
  #
  # @param code [Integer, String] ANSI color code
  # @param output [String] output to print
  # @param newline [Boolean] whether to append a newline
  #
  # source://slim_lint//lib/slim_lint/logger.rb#99
  def color(code, output, newline = T.unsafe(nil)); end

  class << self
    # Creates a logger which outputs nothing.
    #
    # @return [SlimLint::Logger]
    #
    # source://slim_lint//lib/slim_lint/logger.rb#12
    def silent; end
  end
end

module SlimLint::Matcher; end

# Will match anything, acting as a wildcard.
class SlimLint::Matcher::Anything < ::SlimLint::Matcher::Base
  # @return [Boolean]
  # @see {SlimLint::Matcher::Base#match?}
  #
  # source://slim_lint//lib/slim_lint/matcher/anything.rb#7
  def match?(*_arg0); end
end

# Represents a Sexp pattern implementing complex matching logic.
#
# Subclasses can implement custom logic to create complex matches that can be
# reused across linters, DRYing up matching code.
#
# @abstract
class SlimLint::Matcher::Base
  # Whether this matcher matches the specified object.
  #
  # This must be implemented by subclasses.
  #
  # @param other [Object]
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/matcher/base.rb#17
  def match?(*_arg0); end
end

# Wraps a matcher, taking on the behavior of the wrapped matcher but storing
# the value that matched so it can be referred to later.
class SlimLint::Matcher::Capture < ::SlimLint::Matcher::Base
  # @return [Boolean]
  # @see {SlimLint::Matcher::Base#match?}
  #
  # source://slim_lint//lib/slim_lint/matcher/capture.rb#24
  def match?(object); end

  # @return [SlimLint::Matcher::Base] matcher that this capture wraps
  #
  # source://slim_lint//lib/slim_lint/matcher/capture.rb#8
  def matcher; end

  # @return [SlimLint::Matcher::Base] matcher that this capture wraps
  #
  # source://slim_lint//lib/slim_lint/matcher/capture.rb#8
  def matcher=(_arg0); end

  # @return [Object] value that was captured
  #
  # source://slim_lint//lib/slim_lint/matcher/capture.rb#11
  def value; end

  # @return [Object] value that was captured
  #
  # source://slim_lint//lib/slim_lint/matcher/capture.rb#11
  def value=(_arg0); end

  class << self
    # Creates a capture that wraps that given matcher.
    #
    # @param matcher [SlimLint::Matcher::Base]
    # @return [SlimLint::Matcher::Capture]
    #
    # source://slim_lint//lib/slim_lint/matcher/capture.rb#17
    def from_matcher(matcher); end
  end
end

# Does not match anything.
#
# This is used in specs.
class SlimLint::Matcher::Nothing < ::SlimLint::Matcher::Base
  # @return [Boolean]
  # @see {SlimLint::Matcher::Base#match?}
  #
  # source://slim_lint//lib/slim_lint/matcher/nothing.rb#9
  def match?(*_arg0); end
end

class SlimLint::NoSuchLinter < ::StandardError; end

# Collects offenses detected by RuboCop.
class SlimLint::OffenseCollector < ::RuboCop::Formatter::BaseFormatter
  # Executed when a file has been scanned by RuboCop, adding the reported
  # offenses to our collection.
  #
  # @param _file [String]
  # @param offenses [Array<RuboCop::Cop::Offense>]
  #
  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#112
  def file_finished(_file, offenses); end

  # Executed when RuboCop begins linting.
  #
  # @param _target_files [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/linter/rubocop.rb#103
  def started(_target_files); end

  class << self
    # List of offenses reported by RuboCop.
    #
    # source://slim_lint//lib/slim_lint/linter/rubocop.rb#97
    def offenses; end

    # List of offenses reported by RuboCop.
    #
    # source://slim_lint//lib/slim_lint/linter/rubocop.rb#97
    def offenses=(_arg0); end
  end
end

# source://slim_lint//lib/slim_lint/constants.rb#8
SlimLint::REPO_URL = T.let(T.unsafe(nil), String)

# Contains information about all lints detected during a scan.
class SlimLint::Report
  # Creates a report.
  #
  # @param lints [Array<SlimLint::Lint>] lints that were found
  # @param files [Array<String>] files that were linted
  # @return [Report] a new instance of Report
  #
  # source://slim_lint//lib/slim_lint/report.rb#16
  def initialize(lints, files); end

  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/report.rb#21
  def failed?; end

  # List of files that were linted.
  #
  # source://slim_lint//lib/slim_lint/report.rb#10
  def files; end

  # List of lints that were found.
  #
  # source://slim_lint//lib/slim_lint/report.rb#7
  def lints; end

  # List of lints that were found.
  #
  # source://slim_lint//lib/slim_lint/report.rb#7
  def lints=(_arg0); end
end

# Abstract lint reporter. Subclass and override {#display_report} to
# implement a custom lint reporter.
#
# @abstract
class SlimLint::Reporter
  # Creates the reporter that will display the given report.
  #
  # @param logger [SlimLint::Logger]
  # @return [Reporter] a new instance of Reporter
  #
  # source://slim_lint//lib/slim_lint/reporter.rb#12
  def initialize(logger); end

  # Implemented by subclasses to display lints from a {SlimLint::Report}.
  #
  # @param report [SlimLint::Report]
  # @raise [NotImplementedError]
  #
  # source://slim_lint//lib/slim_lint/reporter.rb#19
  def display_report(report); end

  private

  # @return [SlimLint::Logger] logger to send output to
  #
  # source://slim_lint//lib/slim_lint/reporter.rb#42
  def log; end

  class << self
    # Keep tracking all the descendants of this class for the list of available
    # reporters.
    #
    # @return [Array<Class>]
    #
    # source://slim_lint//lib/slim_lint/reporter.rb#28
    def descendants; end

    # Executed when this class is subclassed.
    #
    # @param descendant [Class]
    #
    # source://slim_lint//lib/slim_lint/reporter.rb#35
    def inherited(descendant); end
  end
end

class SlimLint::Reporter::CheckstyleReporter < ::SlimLint::Reporter
  # source://slim_lint//lib/slim_lint/reporter/checkstyle_reporter.rb#8
  def display_report(report); end

  private

  # source://slim_lint//lib/slim_lint/reporter/checkstyle_reporter.rb#23
  def map_file(file, checkstyle); end

  # source://slim_lint//lib/slim_lint/reporter/checkstyle_reporter.rb#33
  def map_offense(offence, parent); end
end

class SlimLint::Reporter::DefaultReporter < ::SlimLint::Reporter
  # source://slim_lint//lib/slim_lint/reporter/default_reporter.rb#7
  def display_report(report); end

  private

  # source://slim_lint//lib/slim_lint/reporter/default_reporter.rb#19
  def print_location(lint); end

  # source://slim_lint//lib/slim_lint/reporter/default_reporter.rb#33
  def print_message(lint); end

  # source://slim_lint//lib/slim_lint/reporter/default_reporter.rb#25
  def print_type(lint); end
end

class SlimLint::Reporter::EmacsReporter < ::SlimLint::Reporter
  # source://slim_lint//lib/slim_lint/reporter/emacs_reporter.rb#6
  def display_report(report); end

  private

  # source://slim_lint//lib/slim_lint/reporter/emacs_reporter.rb#18
  def print_location(lint); end

  # source://slim_lint//lib/slim_lint/reporter/emacs_reporter.rb#36
  def print_message(lint); end

  # source://slim_lint//lib/slim_lint/reporter/emacs_reporter.rb#28
  def print_type(lint); end
end

class SlimLint::Reporter::JsonReporter < ::SlimLint::Reporter
  # source://slim_lint//lib/slim_lint/reporter/json_reporter.rb#6
  def display_report(report); end

  private

  # source://slim_lint//lib/slim_lint/reporter/json_reporter.rb#34
  def map_file(file); end

  # source://slim_lint//lib/slim_lint/reporter/json_reporter.rb#41
  def map_offense(offense); end

  # source://slim_lint//lib/slim_lint/reporter/json_reporter.rb#25
  def metadata; end
end

# Generates a {SlimLint::Sexp} suitable for consumption by the
# {RubyExtractor}.
#
# This is mostly copied from Slim::Engine, with some filters and generators
# omitted.
class SlimLint::RubyExtractEngine < ::Temple::Engine; end

# Utility class for extracting Ruby script from a Slim template that can then
# be linted with a Ruby linter (i.e. is "legal" Ruby).
#
# The goal is to turn this:
#
#    - if items.any?
#      table#items
#      - for item in items
#        tr
#          td.name = item.name
#          td.price = item.price
#    - else
#       p No items found.
#
# into (something like) this:
#
#    if items.any?
#      for item in items
#        puts item.name
#        puts item.price
#    else
#      puts 'No items found'
#    end
#
# The translation won't be perfect, and won't make any real sense, but the
# relationship between variable declarations/uses and the flow control graph
# will remain intact.
class SlimLint::RubyExtractor
  include ::SlimLint::SexpVisitor
  extend ::SlimLint::SexpVisitor::DSL

  # Extracts Ruby code from Sexp representing a Slim document.
  #
  # @param sexp [SlimLint::Sexp]
  # @return [SlimLint::RubyExtractor::RubySource]
  #
  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#47
  def extract(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#59
  def on_pattern_1(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#63
  def on_pattern_2(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#67
  def on_pattern_3(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#71
  def on_pattern_4(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#76
  def on_pattern_5(sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#52
  def on_start(_sexp); end

  private

  # Append code to the buffer.
  #
  # @param code [String]
  # @param sexp [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#87
  def append(code, sexp); end

  # source://slim_lint//lib/slim_lint/ruby_extractor.rb#101
  def append_dummy_puts(sexp); end
end

# Stores the extracted source and a map of lines of generated source to the
# original source that created them.
#
# @attr_reader source [String] generated source code
# @attr_reader source_map [Hash] map of line numbers from generated source
#   to original source line number
class SlimLint::RubyExtractor::RubySource < ::Struct
  # generated source code
  #
  # @return [String] the current value of source
  def source; end

  def source=(_); end

  # map of line numbers from generated source
  # to original source line number
  #
  # @return [Hash] the current value of source_map
  def source_map; end

  def source_map=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Parser for the Ruby language.
#
# This provides a convenient wrapper around the `parser` gem and the
# `astrolabe` integration to go with it. It is intended to be used for linter
# checks that require deep inspection of Ruby code.
class SlimLint::RubyParser
  # Creates a reusable parser.
  #
  # @return [RubyParser] a new instance of RubyParser
  #
  # source://slim_lint//lib/slim_lint/ruby_parser.rb#15
  def initialize; end

  # Parse the given Ruby source into an abstract syntax tree.
  #
  # @param source [String] Ruby source code
  # @return [Array] syntax tree in the form returned by Parser gem
  #
  # source://slim_lint//lib/slim_lint/ruby_parser.rb#24
  def parse(source); end
end

# Responsible for running the applicable linters against the desired files.
class SlimLint::Runner
  # Runs the appropriate linters against the desired files given the specified
  # options.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [SlimLint::Report] a summary of all lints found
  #
  # source://slim_lint//lib/slim_lint/runner.rb#16
  def run(options = T.unsafe(nil)); end

  private

  # Runs all provided linters using the specified config against the given
  # file.
  #
  # @param file [String] path to file to lint
  # @param linter_selector [SlimLint::LinterSelector]
  # @param config [SlimLint::Configuration]
  #
  # source://slim_lint//lib/slim_lint/runner.rb#56
  def collect_lints(file_content, file_name, linter_selector, config); end

  # Returns the list of files that should be linted given the specified
  # configuration and options.
  #
  # @param config [SlimLint::Configuration]
  # @param options [Hash]
  # @return [Array<String>]
  #
  # source://slim_lint//lib/slim_lint/runner.rb#74
  def extract_applicable_files(config, options); end

  # Returns the {SlimLint::Configuration} that should be used given the
  # specified options.
  #
  # @param options [Hash]
  # @return [SlimLint::Configuration]
  #
  # source://slim_lint//lib/slim_lint/runner.rb#40
  def load_applicable_config(options); end
end

# Symbolic expression which represents tree-structured data.
#
# The main use of this particular implementation is to provide a single
# location for defining convenience helpers when operating on Sexps.
class SlimLint::Sexp < ::Array
  # Creates an {Sexp} from the given {Array}-based Sexp.
  #
  # This provides a convenient way to convert between literal arrays of
  # {Symbol}s and {Sexp}s containing {Atom}s and nested {Sexp}s. These objects
  # all expose a similar API that conveniently allows the two objects to be
  # treated similarly due to duck typing.
  #
  # @param array_sexp [Array]
  # @return [Sexp] a new instance of Sexp
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#21
  def initialize(array_sexp); end

  # Returns pretty-printed representation of this S-expression.
  #
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#71
  def inspect; end

  # Stores the line number of the code in the original document that
  # corresponds to this Sexp.
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#11
  def line; end

  # Stores the line number of the code in the original document that
  # corresponds to this Sexp.
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#11
  def line=(_arg0); end

  # Returns whether this {Sexp} matches the given Sexp pattern.
  #
  # A Sexp pattern is simply an incomplete Sexp prefix.
  #
  # Note that nested Sexps will also be matched, so be careful about the cost
  # of matching against a complicated pattern.
  #
  # @example
  #   The following Sexp:
  #
  #   [:html, :doctype, "html5"]
  #
  #   ...will match the given patterns:
  #
  #   [:html]
  #   [:html, :doctype]
  #   [:html, :doctype, "html5"]
  # @param sexp_pattern [Object, Array]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#52
  def match?(sexp_pattern); end

  protected

  # Pretty-prints this Sexp in a form that is more readable.
  #
  # @param depth [Integer] indentation level to display Sexp at
  # @return [String]
  #
  # source://slim_lint//lib/slim_lint/sexp.rb#81
  def display(depth = T.unsafe(nil)); end
end

# Provides an interface which when included allows a class to visit nodes in
# the Sexp of a Slim document.
module SlimLint::SexpVisitor
  # Returns the map of capture names to captured values.
  #
  # @return [Hash, CaptureMap]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#49
  def captures; end

  # Executed before searching for any pattern matches.
  #
  # @param sexp [SlimLint::Sexp] see {SexpVisitor::DSL.on_start}
  # @return [Symbol] see {SexpVisitor::DSL.on_start}
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#64
  def on_start(*_arg0); end

  # Returns the list of registered Sexp patterns.
  #
  # @return [Array<SlimLint::SexpVisitor::SexpPattern>]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#56
  def patterns; end

  # Traverse the given Sexp, firing callbacks if they are defined.
  #
  # @param sexp [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#20
  def traverse(sexp); end

  # Traverse the children of this {Sexp}.
  #
  # @param sexp [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#40
  def traverse_children(sexp); end

  # Traverse the Sexp looking for matches with registered patterns, firing
  # callbacks for all matches.
  #
  # @param sexp [SlimLint::Sexp]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#11
  def trigger_pattern_callbacks(sexp); end
end

# Exposes a convenient Domain-specific Language (DSL) that makes declaring
# Sexp match patterns very easy.
#
# Include them with `extend SlimLint::SexpVisitor::DSL`
module SlimLint::SexpVisitor::DSL
  # Represents a pattern that matches anything.
  #
  # @return [SlimLint::Matcher::Anything]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#128
  def anything; end

  # Represents a pattern that matches the specified matcher, storing the
  # matched value in the captures list under the given name.
  #
  # @param capture_name [Symbol]
  # @param matcher [SlimLint::Matcher::Base]
  # @return [SlimLint::Matcher::Capture]
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#138
  def capture(capture_name, matcher); end

  # @return [Hash] map of capture names to captured values
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#86
  def captures; end

  # DSL helper that defines a sexp pattern and block that will be executed if
  # the given pattern is found.
  #
  # @param sexp_pattern [Sexp]
  # @yield block to execute when the specified pattern is matched
  # @yieldparam sexp [SlimLint::Sexp] Sexp that matched the pattern
  # @yieldreturn [SlimLint::Sexp, Symbol, void] If a Sexp is returned, indicates that traversal should jump directly
  #   to that Sexp.
  #   If `:stop` is returned, halts further traversal down this branch
  #   (i.e. stops recursing, but traversal at higher levels will continue).
  #   Otherwise traversal will continue as normal.
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#100
  def on(sexp_pattern, &block); end

  # Define a block of code to run before checking for any pattern matches.
  #
  # @yield block to execute
  # @yieldparam sexp [SlimLint::Sexp] the root Sexp
  # @yieldreturn [Symbol] if `:stop`, indicates that no further processing
  #   should occur
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#121
  def on_start(&block); end

  # Registered patterns that this visitor will look for when traversing the
  # {SlimLint::Sexp}.
  #
  # source://slim_lint//lib/slim_lint/sexp_visitor.rb#83
  def patterns; end
end

# Mapping of Sexp pattern to callback method name.
#
# @attr_reader sexp [Array] S-expression pattern that when matched triggers the
#   callback
# @attr_reader callback_method_name [Symbol] name of the method to call when pattern is matched
class SlimLint::SexpVisitor::SexpPattern < ::Struct
  # name of the method to call when pattern is matched
  #
  # @return [Symbol] the current value of callback_method_name
  def callback_method_name; end

  def callback_method_name=(_); end

  # S-expression pattern that when matched triggers the
  # callback
  #
  # @return [Array] the current value of sexp
  def sexp; end

  def sexp=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Miscellaneus collection of helper functions.
module SlimLint::Utils
  private

  # Returns whether a glob pattern (or any of a list of patterns) matches the
  # specified file.
  #
  # This is defined here so our file globbing options are consistent
  # everywhere we perform globbing.
  #
  # @param glob [String, Array]
  # @param file [String]
  # @return [Boolean]
  #
  # source://slim_lint//lib/slim_lint/utils.rb#17
  def any_glob_matches?(globs_or_glob, file); end

  # Count the number of consecutive items satisfying the given {Proc}.
  #
  # @param items [Array]
  # @param offset [Fixnum] index to start searching from
  # @return [Integer]
  # @yield [item] Passes item to the provided block.
  # @yieldparam item [Object] Item to evaluate as matching criteria for
  #   inclusion
  # @yieldreturn [Boolean] whether to include the item
  #
  # source://slim_lint//lib/slim_lint/utils.rb#63
  def count_consecutive(items, offset = T.unsafe(nil)); end

  # Find all consecutive items satisfying the given block of a minimum size,
  # yielding each group of consecutive items to the provided block.
  #
  # @param items [Array]
  # @param satisfies [Proc] function that takes an item and returns true/false
  # @param min_consecutive [Fixnum] minimum number of consecutive items before
  #   yielding the group
  # @yield Passes list of consecutive items all matching the criteria defined
  #   by the `satisfies` {Proc} to the provided block
  # @yieldparam group [Array] List of consecutive items
  # @yieldreturn [Boolean] block should return whether item matches criteria
  #   for inclusion
  #
  # source://slim_lint//lib/slim_lint/utils.rb#38
  def for_consecutive_items(items, satisfies, min_consecutive = T.unsafe(nil)); end

  # Calls a block of code with a modified set of environment variables,
  # restoring them once the code has executed.
  #
  # @param env [Hash] environment variables to set
  #
  # source://slim_lint//lib/slim_lint/utils.rb#73
  def with_environment(env); end

  class << self
    # Returns whether a glob pattern (or any of a list of patterns) matches the
    # specified file.
    #
    # This is defined here so our file globbing options are consistent
    # everywhere we perform globbing.
    #
    # @param glob [String, Array]
    # @param file [String]
    # @return [Boolean]
    #
    # source://slim_lint//lib/slim_lint/utils.rb#17
    def any_glob_matches?(globs_or_glob, file); end

    # Count the number of consecutive items satisfying the given {Proc}.
    #
    # @param items [Array]
    # @param offset [Fixnum] index to start searching from
    # @return [Integer]
    # @yield [item] Passes item to the provided block.
    # @yieldparam item [Object] Item to evaluate as matching criteria for
    #   inclusion
    # @yieldreturn [Boolean] whether to include the item
    #
    # source://slim_lint//lib/slim_lint/utils.rb#63
    def count_consecutive(items, offset = T.unsafe(nil)); end

    # Find all consecutive items satisfying the given block of a minimum size,
    # yielding each group of consecutive items to the provided block.
    #
    # @param items [Array]
    # @param satisfies [Proc] function that takes an item and returns true/false
    # @param min_consecutive [Fixnum] minimum number of consecutive items before
    #   yielding the group
    # @yield Passes list of consecutive items all matching the criteria defined
    #   by the `satisfies` {Proc} to the provided block
    # @yieldparam group [Array] List of consecutive items
    # @yieldreturn [Boolean] block should return whether item matches criteria
    #   for inclusion
    #
    # source://slim_lint//lib/slim_lint/utils.rb#38
    def for_consecutive_items(items, satisfies, min_consecutive = T.unsafe(nil)); end

    # Calls a block of code with a modified set of environment variables,
    # restoring them once the code has executed.
    #
    # @param env [Hash] environment variables to set
    #
    # source://slim_lint//lib/slim_lint/utils.rb#73
    def with_environment(env); end
  end
end

# source://slim_lint//lib/slim_lint/version.rb#5
SlimLint::VERSION = T.let(T.unsafe(nil), String)

class Temple::Filter
  include ::Temple::Utils
  include ::Temple::Mixins::CompiledDispatcher
  include ::Temple::Mixins::CoreDispatcher
  include ::Temple::Mixins::EscapeDispatcher
  include ::Temple::Mixins::ControlFlowDispatcher
  include ::Temple::Mixins::Dispatcher
  include ::Temple::Mixins::Options
  extend ::Temple::Mixins::ClassOptions
  extend ::Temple::Mixins::ThreadOptions
end

module Temple::Mixins::Dispatcher
  include ::Temple::Mixins::CompiledDispatcher
  include ::Temple::Mixins::CoreDispatcher
  include ::Temple::Mixins::EscapeDispatcher
  include ::Temple::Mixins::ControlFlowDispatcher
end
