# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sitemap_generator` gem.
# Please instead update this file by running `bin/tapioca gem sitemap_generator`.

# A LinkSet provisions a bunch of links to sitemap files.  It also writes the index file
# which lists all the sitemap files written.
module SitemapGenerator
  class << self
    # Returns the value of attribute app.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def app; end

    # Sets the attribute app
    #
    # @param value the value to set the attribute app to.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def app=(_arg0); end

    # Returns the value of attribute root.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def root; end

    # Sets the attribute root
    #
    # @param value the value to set the attribute root to.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def root=(_arg0); end

    # Returns the value of attribute templates.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def templates; end

    # Sets the attribute templates
    #
    # @param value the value to set the attribute templates to.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#57
    def templates=(_arg0); end

    # Global default for the verbose setting.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#63
    def verbose; end

    # Sets the attribute verbose
    #
    # @param value the value to set the attribute verbose to.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#58
    def verbose=(_arg0); end

    # Sets the attribute yield_sitemap
    #
    # @param value the value to set the attribute yield_sitemap to.
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#58
    def yield_sitemap=(_arg0); end

    # Returns true if we should yield the sitemap instance to the block, false otherwise.
    #
    # @return [Boolean]
    #
    # source://sitemap_generator//lib/sitemap_generator.rb#78
    def yield_sitemap?; end
  end
end

class SitemapGenerator::Application
  # Returns a boolean indicating whether this environment is Rails 3
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/application.rb#12
  def is_at_least_rails3?; end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/application.rb#5
  def is_rails?; end

  # source://sitemap_generator//lib/sitemap_generator/application.rb#18
  def root; end

  protected

  # Returns the environment of the Rails application,
  # if this is running in a Rails context.
  # Returns `nil` if no such environment is defined.
  #
  # @return [String, nil]
  #
  # source://sitemap_generator//lib/sitemap_generator/application.rb#40
  def rails_env; end

  # Returns the root of the Rails application,
  # if this is running in a Rails context.
  # Returns `nil` if no such root is defined.
  #
  # @return [String, nil]
  #
  # source://sitemap_generator//lib/sitemap_generator/application.rb#29
  def rails_root; end
end

# Class for uploading sitemaps to an S3 bucket using the AWS SDK gem.
class SitemapGenerator::AwsSdkAdapter
  # Specify your AWS bucket name, credentials, and/or region.  By default
  # the AWS SDK will auto-detect your credentials and region, but you can use
  # the options to configure them manually.
  #
  # Requires Aws::S3::Resource and Aws::Credentials to be defined.
  #
  # Options:
  #   **Deprecated, use :endpoint instead** :aws_endpoint [String] The object storage endpoint,
  #                                                                if not AWS, e.g. 'https://sfo2.digitaloceanspaces.com'
  #   **Deprecated, use :access_key_id instead** :aws_access_key_id [String] Your AWS access key id
  #   **Deprecated, use :secret_access_key instead** :aws_secret_access_key [String] Your AWS secret access key
  #   **Deprecated, use :region instead** :aws_region [String] Your AWS region
  #   :acl [String] The ACL to apply to the uploaded files.  Defaults to 'public-read'.
  #   :cache_control [String] The cache control headder to apply to the uploaded files.  Defaults to 'private, max-age=0, no-cache'.
  #
  #   All other options you provide are passed directly to the AWS client.
  #   See https://docs.aws.amazon.com/sdk-for-ruby/v2/api/Aws/S3/Client.html#initialize-instance_method
  #   for a full list of supported options.
  #
  # @param bucket [String] Name of the S3 bucket
  # @param options [Hash] Options passed directly to AWS to control the Resource created.  See Options below.
  # @return [AwsSdkAdapter] a new instance of AwsSdkAdapter
  #
  # source://sitemap_generator//lib/sitemap_generator/adapters/aws_sdk_adapter.rb#30
  def initialize(bucket, aws_access_key_id: T.unsafe(nil), aws_secret_access_key: T.unsafe(nil), aws_region: T.unsafe(nil), aws_endpoint: T.unsafe(nil), acl: T.unsafe(nil), cache_control: T.unsafe(nil), **options); end

  # Call with a SitemapLocation and string data
  #
  # source://sitemap_generator//lib/sitemap_generator/adapters/aws_sdk_adapter.rb#43
  def write(location, raw_data); end

  private

  # source://sitemap_generator//lib/sitemap_generator/adapters/aws_sdk_adapter.rb#59
  def s3_resource; end

  # source://sitemap_generator//lib/sitemap_generator/adapters/aws_sdk_adapter.rb#55
  def set_option_unless_set(key, value); end
end

# Define our own class rather than modify the global class
class SitemapGenerator::BigDecimal
  # @return [BigDecimal] a new instance of BigDecimal
  #
  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#17
  def initialize(num); end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#21
  def *(other); end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#25
  def /(other); end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#42
  def encode_with(coder); end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#47
  def to_d; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#52
  def to_s(format = T.unsafe(nil)); end

  # This emits the number without any scientific notation.
  # This is better than self.to_f.to_s since it doesn't lose precision.
  #
  # Note that reconstituting YAML floats to native floats may lose precision.
  #
  # source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#33
  def to_yaml(opts = T.unsafe(nil)); end
end

# source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#51
SitemapGenerator::BigDecimal::DEFAULT_STRING_FORMAT = T.let(T.unsafe(nil), String)

# source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#13
SitemapGenerator::BigDecimal::YAML_MAPPING = T.let(T.unsafe(nil), Hash)

# source://sitemap_generator//lib/sitemap_generator/core_ext/big_decimal.rb#12
SitemapGenerator::BigDecimal::YAML_TAG = T.let(T.unsafe(nil), String)

module SitemapGenerator::Builder; end

class SitemapGenerator::Builder::LinkHolder < ::Struct
  # Returns the value of attribute link
  #
  # @return [Object] the current value of link
  def link; end

  # Sets the attribute link
  #
  # @param value [Object] the value to set the attribute link to.
  # @return [Object] the newly set value
  def link=(_); end

  # Returns the value of attribute options
  #
  # @return [Object] the current value of options
  def options; end

  # Sets the attribute options
  #
  # @param value [Object] the value to set the attribute options to.
  # @return [Object] the newly set value
  def options=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# General Usage:
#
#   sitemap = SitemapFile.new(:location => SitemapLocation.new(...))
#   sitemap.add('/', { ... })    <- add a link to the sitemap
#   sitemap.finalize!            <- write the sitemap file and freeze the object to protect it from further modification
class SitemapGenerator::Builder::SitemapFile
  include ::SitemapGenerator::Helpers::NumberHelper

  # === Options
  #
  # * <tt>location</tt> - a SitemapGenerator::SitemapLocation instance or a Hash of options
  #   from which a SitemapLocation will be created for you.  See `SitemapGenerator::SitemapLocation` for
  #   the supported list of options.
  #
  # @return [SitemapFile] a new instance of SitemapFile
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#23
  def initialize(opts = T.unsafe(nil)); end

  # Add a link to the sitemap file.
  #
  # If a link cannot be added, for example if the file is too large or the link
  # limit has been reached, a SitemapGenerator::SitemapFullError exception is raised
  # and the sitemap is finalized.
  #
  # If the Sitemap has already been finalized a SitemapGenerator::SitemapFinalizedError
  # exception is raised.
  #
  # Return the new link count.
  #
  # Call with:
  #   sitemap_url - a SitemapUrl instance
  #   sitemap, options - a Sitemap instance and options hash
  #   path, options - a path for the URL and options hash.  For supported options
  #                   see the SitemapGenerator::Builder::SitemapUrl class.
  #
  # The link added to the sitemap will use the host from its location object
  # if no host has been specified.
  #
  # @raise [SitemapGenerator::SitemapFinalizedError]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#92
  def add(link, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#61
  def empty?; end

  # Return a boolean indicating whether the sitemap file can fit another link
  # of <tt>bytes</tt> bytes in size.  You can also pass a string and the
  # bytesize will be calculated for you.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#68
  def file_can_fit?(bytes); end

  # Returns the value of attribute filesize.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#16
  def filesize; end

  # "Freeze" this object.  Actually just flags it as frozen.
  #
  # A SitemapGenerator::SitemapFinalizedError exception is raised if the Sitemap
  # has already been finalized.
  #
  # @raise [SitemapGenerator::SitemapFinalizedError]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#119
  def finalize!; end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#124
  def finalized?; end

  # If a name has been reserved, use the last modified time from the file.
  # Otherwise return nil.  We don't want to prematurely assign a name
  # for this sitemap if one has not yet been reserved, because we may
  # mess up the name-assignment sequence.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#55
  def lastmod; end

  # Returns the value of attribute link_count.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#16
  def link_count; end

  # Returns the value of attribute location.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#16
  def location; end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#168
  def max_sitemap_links; end

  # Return a new instance of the sitemap file with the same options,
  # and the next name in the sequence.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#162
  def new; end

  # Returns the value of attribute news_count.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#16
  def news_count; end

  # Reserve a name from the namer unless one has already been reserved.
  # Safe to call more than once.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#151
  def reserve_name; end

  # Return a boolean indicating whether a name has been reserved
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#156
  def reserved_name?; end

  # Write out the sitemap and free up memory.
  #
  # All the xml content in the instance is cleared, but attributes like
  # <tt>filesize</tt> are still available.
  #
  # A SitemapGenerator::SitemapError exception is raised if the file has
  # already been written.
  #
  # @raise [SitemapGenerator::SitemapError]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#135
  def write; end

  # Return true if this file has been written out to disk
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#145
  def written?; end
end

class SitemapGenerator::Builder::SitemapIndexFile < ::SitemapGenerator::Builder::SitemapFile
  # === Options
  #
  # * <tt>location</tt> - a SitemapGenerator::SitemapIndexLocation instance or a Hash of options
  #   from which a SitemapLocation will be created for you.
  #
  # @return [SitemapIndexFile] a new instance of SitemapIndexFile
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#9
  def initialize(opts = T.unsafe(nil)); end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#48
  def add(link, options = T.unsafe(nil)); end

  # Whether or not we need to create an index file.  True if create_index is true
  # or if create_index is :auto and we have more than one link in the index.
  # If a link is added manually and create_index is not false, we force index
  # creation because they obviously intend for there to be an index.  False otherwise.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#118
  def create_index?; end

  # Return a boolean indicating whether the sitemap file can fit another link
  # of <tt>bytes</tt> bytes in size.  You can also pass a string and the
  # bytesize will be calculated for you.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#87
  def file_can_fit?(bytes); end

  # @raise [SitemapGenerator::SitemapFinalizedError]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#102
  def finalize!; end

  # Return the index file URL.  If create_index is true, this is the URL
  # of the actual index file.  If create_index is false, this is the URL
  # of the first sitemap that was written out.  Only call this method
  # *after* the files have been finalized.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#126
  def index_url; end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#97
  def stats_summary(opts = T.unsafe(nil)); end

  # Finalize sitemaps as they are added to the index.
  # If it's the first sitemap, finalize it but don't
  # write it out, because we don't yet know if we need an index.  If it's
  # the second sitemap, we know we need an index, so reserve a name for the
  # index, and go and write out the first sitemap.  If it's the third or
  # greater sitemap, just finalize and write it out as usual, nothing more
  # needs to be done.
  #
  # If a link is being added to the index manually as a string, then we
  # can assume that the index is required (unless create_index is false of course).
  # This seems like the logical thing to do.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_file.rb#92
  def super_add(link, options = T.unsafe(nil)); end

  # Return the total number of links in all sitemaps reference by this index file
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#93
  def total_link_count; end

  # Write out the index if an index is needed
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#110
  def write; end

  protected

  # Make sure the first sitemap has been written out and added to the index
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_file.rb#137
  def write_first_sitemap; end
end

class SitemapGenerator::Builder::SitemapIndexUrl < ::SitemapGenerator::Builder::SitemapUrl
  # @return [SitemapIndexUrl] a new instance of SitemapIndexUrl
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_url.rb#7
  def initialize(path, options = T.unsafe(nil)); end

  # Return the URL as XML
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_index_url.rb#18
  def to_xml(builder = T.unsafe(nil)); end
end

# A Hash-like class for holding information about a sitemap URL and
# generating an XML <url> element suitable for sitemaps.
class SitemapGenerator::Builder::SitemapUrl < ::Hash
  # Return a new instance with options configured on it.
  #
  # == Arguments
  # * sitemap - a Sitemap instance, or
  # * path, options - a path string and options hash
  #
  # == Options
  # Requires a host to be set.  If passing a sitemap, the sitemap must have a +default_host+
  # configured.  If calling with a path and options, you must include the <tt>:host</tt> option.
  #
  # * +host+
  # * +priority+
  # * +changefreq+
  # * +lastmod+
  # * +images+
  # * +video+/+videos+
  # * +news+
  # * +mobile+
  # * +alternate+/+alternates+
  # * +pagemap+
  #
  # @return [SitemapUrl] a new instance of SitemapUrl
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#32
  def initialize(path, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#179
  def news?; end

  # Return the URL as XML
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#86
  def to_xml(builder = T.unsafe(nil)); end

  protected

  # Format a float to to one decimal precision.
  # TODO: Use rounding with precision once merged with framework_agnostic.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#254
  def format_float(value); end

  # Return an Array of image option Hashes suitable to be parsed by SitemapGenerator::Builder::SitemapFile
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#199
  def prepare_images(images, host); end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#193
  def prepare_news(news); end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#185
  def prepare_video_price_attribs(video); end

  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#208
  def w3c_date(date); end

  # Accept a string or boolean and return 'yes' or 'no'.  If a string, the
  # value must be 'yes' or 'no'.  Pass the default value as a boolean using `default`.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#237
  def yes_or_no(value); end

  # If the value is nil, return `default` converted to either 'yes' or 'no'.
  # If the value is set, return its value converted to 'yes' or 'no'.
  #
  # source://sitemap_generator//lib/sitemap_generator/builder/sitemap_url.rb#248
  def yes_or_no_with_default(value, default); end
end

# Class for writing out data to a file.
class SitemapGenerator::FileAdapter
  # Write `data` to a stream, passing the data through a GzipWriter
  # to compress it.
  #
  # source://sitemap_generator//lib/sitemap_generator/adapters/file_adapter.rb#30
  def gzip(stream, data); end

  # Write `data` to a stream as is.
  #
  # source://sitemap_generator//lib/sitemap_generator/adapters/file_adapter.rb#37
  def plain(stream, data); end

  # Write data to a file.
  #
  # @param location - File object giving the full path and file name of the file.
  #   If the location specifies a directory(ies) which does not exist, the directory(ies)
  #   will be created for you.  If the location path ends with `.gz` the data will be
  #   compressed prior to being written out.  Otherwise the data will be written out
  #   unchanged.
  # @param raw_data - data to write to the file.
  #
  # source://sitemap_generator//lib/sitemap_generator/adapters/file_adapter.rb#11
  def write(location, raw_data); end
end

# = SitemapGenerator Number Helpers
module SitemapGenerator::Helpers; end

# Provides methods for converting numbers into formatted strings.
# Methods are provided for precision, positional notation and file size
# and pretty printing.
#
# Most methods expect a +number+ argument, and will return it
# unchanged if can't be converted into a valid number.
module SitemapGenerator::Helpers::NumberHelper
  # Formats the bytes in +number+ into a more understandable representation
  # (e.g., giving it 1500 yields 1.5 KB). This method is useful for
  # reporting file sizes to users. You can customize the
  # format in the +options+ hash.
  #
  # See <tt>number_to_human</tt> if you want to pretty-print a generic number.
  #
  # ==== Options
  # * <tt>:locale</tt>     - Sets the locale to be used for formatting (defaults to current locale).
  # * <tt>:precision</tt>  - Sets the precision of the number (defaults to 3).
  # * <tt>:significant</tt>  - If +true+, precision will be the # of significant_digits. If +false+, the # of fractional digits (defaults to +true+)
  # * <tt>:separator</tt>  - Sets the separator between the fractional and integer digits (defaults to ".").
  # * <tt>:delimiter</tt>  - Sets the thousands delimiter (defaults to "").
  # * <tt>:strip_insignificant_zeros</tt>  - If +true+ removes insignificant zeros after the decimal separator (defaults to +true+)
  # ==== Examples
  #  number_to_human_size(123)                                          # => 123 Bytes
  #  number_to_human_size(1234)                                         # => 1.21 KB
  #  number_to_human_size(12345)                                        # => 12.1 KB
  #  number_to_human_size(1234567)                                      # => 1.18 MB
  #  number_to_human_size(1234567890)                                   # => 1.15 GB
  #  number_to_human_size(1234567890123)                                # => 1.12 TB
  #  number_to_human_size(1234567, :precision => 2)                     # => 1.2 MB
  #  number_to_human_size(483989, :precision => 2)                      # => 470 KB
  #  number_to_human_size(1234567, :precision => 2, :separator => ',')  # => 1,2 MB
  #
  # Non-significant zeros after the fractional separator are stripped out by default (set
  # <tt>:strip_insignificant_zeros</tt> to +false+ to change that):
  #  number_to_human_size(1234567890123, :precision => 5)        # => "1.1229 TB"
  #  number_to_human_size(524288000, :precision=>5)              # => "500 MB"
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#180
  def number_to_human_size(number, options = T.unsafe(nil)); end

  # Formats a +number+ with grouped thousands using +delimiter+ (e.g., 12,324). You can
  # customize the format in the +options+ hash.
  #
  # ==== Options
  # * <tt>:locale</tt>     - Sets the locale to be used for formatting (defaults to current locale).
  # * <tt>:delimiter</tt>  - Sets the thousands delimiter (defaults to ",").
  # * <tt>:separator</tt>  - Sets the separator between the fractional and integer digits (defaults to ".").
  #
  # ==== Examples
  #  number_with_delimiter(12345678)                        # => 12,345,678
  #  number_with_delimiter(12345678.05)                     # => 12,345,678.05
  #  number_with_delimiter(12345678, :delimiter => ".")     # => 12.345.678
  #  number_with_delimiter(12345678, :separator => ",")     # => 12,345,678
  #  number_with_delimiter(12345678.05, :locale => :fr)     # => 12 345 678,05
  #  number_with_delimiter(98765432.98, :delimiter => " ", :separator => ",")
  #  # => 98 765 432,98
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#41
  def number_with_delimiter(number, options = T.unsafe(nil)); end

  # Formats a +number+ with the specified level of <tt>:precision</tt> (e.g., 112.32 has a precision
  # of 2 if +:significant+ is +false+, and 5 if +:significant+ is +true+).
  # You can customize the format in the +options+ hash.
  #
  # ==== Options
  # * <tt>:locale</tt>     - Sets the locale to be used for formatting (defaults to current locale).
  # * <tt>:precision</tt>  - Sets the precision of the number (defaults to 3).
  # * <tt>:significant</tt>  - If +true+, precision will be the # of significant_digits. If +false+, the # of fractional digits (defaults to +false+)
  # * <tt>:separator</tt>  - Sets the separator between the fractional and integer digits (defaults to ".").
  # * <tt>:delimiter</tt>  - Sets the thousands delimiter (defaults to "").
  # * <tt>:strip_insignificant_zeros</tt>  - If +true+ removes insignificant zeros after the decimal separator (defaults to +false+)
  #
  # ==== Examples
  #  number_with_precision(111.2345)                                            # => 111.235
  #  number_with_precision(111.2345, :precision => 2)                           # => 111.23
  #  number_with_precision(13, :precision => 5)                                 # => 13.00000
  #  number_with_precision(389.32314, :precision => 0)                          # => 389
  #  number_with_precision(111.2345, :significant => true)                      # => 111
  #  number_with_precision(111.2345, :precision => 1, :significant => true)     # => 100
  #  number_with_precision(13, :precision => 5, :significant => true)           # => 13.000
  #  number_with_precision(111.234, :locale => :fr)                             # => 111,234
  #  number_with_precision(13, :precision => 5, :significant => true, strip_insignificant_zeros => true)
  #  # => 13
  #  number_with_precision(389.32314, :precision => 4, :significant => true)    # => 389.3
  #  number_with_precision(1111.2345, :precision => 2, :separator => ',', :delimiter => '.')
  #  # => 1.111,23
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#94
  def number_with_precision(number, options = T.unsafe(nil)); end
end

# source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#148
SitemapGenerator::Helpers::NumberHelper::DECIMAL_UNITS = T.let(T.unsafe(nil), Hash)

# Raised when argument +number+ param given to the helpers is invalid and
# the option :raise is set to  +true+.
class SitemapGenerator::Helpers::NumberHelper::InvalidNumberError < ::StandardError
  # @return [InvalidNumberError] a new instance of InvalidNumberError
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#20
  def initialize(number); end

  # Returns the value of attribute number.
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#19
  def number; end

  # Sets the attribute number
  #
  # @param value the value to set the attribute number to.
  #
  # source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#19
  def number=(_arg0); end
end

# source://sitemap_generator//lib/sitemap_generator/helpers/number_helper.rb#147
SitemapGenerator::Helpers::NumberHelper::STORAGE_UNITS = T.let(T.unsafe(nil), Array)

# Provide a class for evaluating blocks, making the URL helpers from the framework
# and API methods available to it.
class SitemapGenerator::Interpreter
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor

  # Call with a block to evaluate a dynamic config.  The only method exposed for you is
  # `add` to add a link to the sitemap object attached to this interpreter.
  #
  # === Options
  # * <tt>link_set</tt> - a LinkSet instance to use.  Default is SitemapGenerator::Sitemap.
  #
  # All other options are passed to the LinkSet by setting them using accessor methods.
  #
  # @return [Interpreter] a new instance of Interpreter
  #
  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#25
  def initialize(opts = T.unsafe(nil), &block); end

  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#32
  def add(*args); end

  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#36
  def add_to_index(*args); end

  # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
  def default_url_options; end

  # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
  def default_url_options=(_arg0); end

  # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
  def default_url_options?; end

  # Evaluate the block in the interpreter.  Pass :yield_sitemap => true to
  # yield the Interpreter instance to the block...for old-style calling.
  #
  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#56
  def eval(opts = T.unsafe(nil), &block); end

  # Start a new group of sitemaps.  Any of the options to SitemapGenerator.new may
  # be passed.  Pass a block with calls to +add+ to add links to the sitemaps.
  #
  # All groups use the same sitemap index.
  #
  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#44
  def group(*args, &block); end

  # Return the LinkSet instance so that you can access it from within the `create` block
  # without having to use the yield_sitemap option.
  #
  # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#50
  def sitemap; end

  class << self
    # source://actionpack/7.0.4/lib/action_dispatch/routing/route_set.rb#564
    def _routes; end

    # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
    def default_url_options; end

    # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
    def default_url_options=(value); end

    # source://actionpack/7.0.4/lib/action_dispatch/routing/url_for.rb#95
    def default_url_options?; end

    # Run the interpreter on a config file using
    # the default <tt>SitemapGenerator::Sitemap</tt> sitemap object.
    #
    # === Options
    # * <tt>:config_file</tt> - full path to the config file to evaluate.
    #   Default is config/sitemap.rb in your application's root directory.
    # All other options are passed to +new+.
    #
    # source://sitemap_generator//lib/sitemap_generator/interpreter.rb#73
    def run(opts = T.unsafe(nil), &block); end
  end
end

class SitemapGenerator::LinkSet
  include ::SitemapGenerator::LinkSet::LocationHelpers

  # Constructor
  #
  # == Options:
  # * <tt>:adapter</tt> - instance of a class with a write method which takes a SitemapGenerator::Location
  #   and raw XML data and persists it.  The default adapter is a SitemapGenerator::FileAdapter
  #   which simply writes files to the filesystem.  You can use a SitemapGenerator::WaveAdapter
  #   for uploading sitemaps to remote servers - useful for read-only hosts such as Heroku.  Or
  #   you can provide an instance of your own class to provide custom behavior.
  #
  # * <tt>:default_host</tt> - host including protocol to use in all sitemap links
  #   e.g. http://en.google.ca
  #
  # * <tt>:public_path</tt> - Full or relative path to the directory to write sitemaps into.
  #   Defaults to the <tt>public/</tt> directory in your application root directory or
  #   the current working directory.
  #
  # * <tt>:sitemaps_host</tt> - String.  <b>Host including protocol</b> to use when generating
  #   a link to a sitemap file i.e. the hostname of the server where the sitemaps are hosted.
  #   The value will differ from the hostname in your sitemap links.
  #   For example: `'http://amazon.aws.com/'`.
  #
  #   Note that `include_index` is automatically turned off when the `sitemaps_host` does
  #   not match `default_host`.  Because the link to the sitemap index file that would
  #   otherwise be added would point to a different host than the rest of the links in
  #   the sitemap.  Something that the sitemap rules forbid.
  #
  # * <tt>:sitemaps_path</tt> - path fragment within public to write sitemaps
  #   to e.g. 'en/'.  Sitemaps are written to <tt>public_path</tt> + <tt>sitemaps_path</tt>
  #
  # * <tt>:filename</tt> - symbol giving the base name for files (default <tt>:sitemap</tt>).
  #   The names are generated like "#{filename}.xml.gz", "#{filename}1.xml.gz", "#{filename}2.xml.gz"
  #   with the first file being the index if you have more than one sitemap file.
  #
  # * <tt>:include_index</tt> - Boolean.  Whether to <b>add a link pointing to the sitemap index<b>
  #   to the current sitemap.  This points search engines to your Sitemap Index to
  #   include it in the indexing of your site.  Default is `false`.  Turned off when
  #  `sitemaps_host` is set or within a `group()` block.  Turned off because Google can complain
  #   about nested indexing and because if a robot is already reading your sitemap, they
  #   probably know about the index.
  #
  # * <tt>:include_root</tt> - Boolean.  Whether to **add the root** url i.e. '/' to the
  #   current sitemap.  Default is `true`.  Turned off within a `group()` block.
  #
  # * <tt>:search_engines</tt> - Hash.  A hash of search engine names mapped to
  #   ping URLs.  See ping_search_engines.
  #
  # * <tt>:verbose</tt> - If +true+, output a summary line for each sitemap and sitemap
  #   index that is created.  Default is +false+.
  #
  # * <tt>:create_index</tt> - Supported values: `true`, `false`, `:auto`.  Default: `:auto`.
  #   Whether to create a sitemap index file.  If `true` an index file is always created,
  #   regardless of how many links are in your sitemap.  If `false` an index file is never
  #   created.  If `:auto` an index file is created only if your sitemap has more than
  #   one sitemap file.
  #
  # * <tt>:namer</tt> - A <tt>SitemapGenerator::SimpleNamer</tt> instance for generating the sitemap
  #   and index file names.  See <tt>:filename</tt> if you don't need to do anything fancy, and can
  #   accept the default naming conventions.
  #
  # * <tt>:compress</tt> - Specifies which files to compress with gzip.  Default is `true`. Accepted values:
  #     * `true` - Boolean; compress all files.
  #     * `false` - Boolean; write out only uncompressed files.
  #     * `:all_but_first` - Symbol; leave the first file uncompressed but compress any remaining files.
  #
  #   The compression setting applies to groups too.  So :all_but_first will have the same effect (the first
  #   file in the group will not be compressed, the rest will).  So if you require different behaviour for your
  #   groups, pass in a `:compress` option e.g. <tt>group(:compress => false) { add('/link') }</tt>
  #
  # * <tt>:max_sitemap_links</tt> - The maximum number of links to put in each sitemap.
  #   Default is `SitemapGenerator::MAX_SITEMAPS_LINKS`, or 50,000.
  #
  # Note: When adding a new option be sure to include it in `options_for_group()` if
  # the option should be inherited by groups.
  #
  # @return [LinkSet] a new instance of LinkSet
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#120
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute adapter.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def adapter; end

  # Sets the attribute adapter
  #
  # @param value the value to set the attribute adapter to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def adapter=(_arg0); end

  # Add a link to a Sitemap.  If a new Sitemap is required, one will be created for
  # you.
  #
  # link - string link e.g. '/merchant', '/article/1' or whatever.
  # options - see README.
  #   host - host for the link, defaults to your <tt>default_host</tt>.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#149
  def add(link, options = T.unsafe(nil)); end

  # Add a link to the Sitemap Index.
  # * link - A string link e.g. '/sitemaps/sitemap1.xml.gz' or a SitemapFile instance.
  # * options - A hash of options including `:lastmod`, ':priority`, ':changefreq` and `:host`
  #
  # The `:host` option defaults to the value of `sitemaps_host` which is the host where your
  # sitemaps reside.  If no `sitemaps_host` is set, the `default_host` is used.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#166
  def add_to_index(link, options = T.unsafe(nil)); end

  # Create a new sitemap index and sitemap files.  Pass a block with calls to the following
  # methods:
  # * +add+   - Add a link to the current sitemap
  # * +group+ - Start a new group of sitemaps
  #
  # == Options
  #
  # Any option supported by +new+ can be passed.  The options will be
  # set on the instance using the accessor methods.  This is provided mostly
  # as a convenience.
  #
  # In addition to the options to +new+, the following options are supported:
  # * <tt>:finalize</tt> - The sitemaps are written as they get full and at the end
  # of the block.  Pass +false+ as the value to prevent the sitemap or sitemap index
  # from being finalized.  Default is +true+.
  #
  # If you are calling +create+ more than once in your sitemap configuration file,
  # make sure that you set a different +sitemaps_path+ or +filename+ for each call otherwise
  # the sitemaps may be overwritten.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#33
  def create(opts = T.unsafe(nil), &block); end

  # Returns the value of attribute create_index.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#10
  def create_index; end

  # Returns the value of attribute default_host.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#10
  def default_host; end

  # Returns the value of attribute filename.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#10
  def filename; end

  # All done.  Write out remaining files.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#342
  def finalize!; end

  # Create a new group of sitemap files.
  #
  # Returns a new LinkSet instance with the options passed in set on it.  All groups
  # share the sitemap index, which is not affected by any of the options passed here.
  #
  # === Options
  # Any of the options to LinkSet.new.  Except for <tt>:public_path</tt> which is shared
  # by all groups.
  #
  # The current options are inherited by the new group of sitemaps.  The only exceptions
  # being <tt>:include_index</tt> and <tt>:include_root</tt> which default to +false+.
  #
  # Pass a block to add links to the new LinkSet.  If you pass a block the sitemaps will
  # be finalized when the block returns.
  #
  # If you are not changing any of the location settings like <tt>filename<tt>,
  # <tt>sitemaps_path</tt>, <tt>sitemaps_host</tt> or <tt>namer</tt>,
  # links you add within the group will be added to the current sitemap.
  # Otherwise the current sitemap file is finalized and a new sitemap file started,
  # using the options you specified.
  #
  # Most commonly, you'll want to give the group's files a distinct name using
  # the <tt>filename</tt> option.
  #
  # Options like <tt>:default_host</tt> can be used and it will only affect the links
  # within the group.  Links added outside of the group will revert to the previous
  # +default_host+.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#197
  def group(opts = T.unsafe(nil), &block); end

  # Returns the value of attribute include_index.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def include_index; end

  # Sets the attribute include_index
  #
  # @param value the value to set the attribute include_index to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def include_index=(_arg0); end

  # Return a boolean indicating hether to add a link to the sitemap index file
  # to the current sitemap.  This points search engines to your Sitemap Index so
  # they include it in the indexing of your site, but is not strictly neccessary.
  # Default is `true`.  Turned off when `sitemaps_host` is set or within a `group()` block.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#351
  def include_index?; end

  # Returns the value of attribute include_root.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def include_root; end

  # Sets the attribute include_root
  #
  # @param value the value to set the attribute include_root to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def include_root=(_arg0); end

  # Return a boolean indicating whether to automatically add the root url i.e. '/' to the
  # current sitemap.  Default is `true`.  Turned off within a `group()` block.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#361
  def include_root?; end

  # Return a count of the total number of links in all sitemaps
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#311
  def link_count; end

  # Returns the value of attribute max_sitemap_links.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def max_sitemap_links; end

  # Sets the attribute max_sitemap_links
  #
  # @param value the value to set the attribute max_sitemap_links to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def max_sitemap_links=(_arg0); end

  # Ping search engines to notify them of updated sitemaps.
  #
  # Search engines are already notified for you if you run `rake sitemap:refresh`.
  # If you want to ping search engines separately to your sitemap generation, run
  # `rake sitemap:refresh:no_ping` and then run a rake task or script
  # which calls this method as in the example below.
  #
  # == Arguments
  # * sitemap_index_url - The full URL to your sitemap index file.
  #   If not provided the location is based on the `host` you have
  #   set and any other options like your `sitemaps_path`.  The URL
  #   will be CGI escaped for you when included as part of the
  #   search engine ping URL.
  #
  # == Options
  # A hash of one or more search engines to ping in addition to the
  # default search engines.  The key is the name of the search engine
  # as a string or symbol and the value is the full URL to ping with
  # a string interpolation that will be replaced by the CGI escaped sitemap
  # index URL.  If you have any literal percent characters in your URL you
  # need to escape them with `%%`.  For example if your sitemap index URL
  # is `http://example.com/sitemap.xml.gz` and your
  # ping url is `http://example.com/100%%/ping?url=%s`
  # then the final URL that is pinged will be `http://example.com/100%/ping?url=http%3A%2F%2Fexample.com%2Fsitemap.xml.gz`
  #
  # == Examples
  #
  # Both of these examples will ping the default search engines in addition to `http://superengine.com/ping?url=http%3A%2F%2Fexample.com%2Fsitemap.xml.gz`
  #
  #   SitemapGenerator::Sitemap.host('http://example.com/')
  #   SitemapGenerator::Sitemap.ping_search_engines(:super_engine => 'http://superengine.com/ping?url=%s')
  #
  # Is equivalent to:
  #
  #   SitemapGenerator::Sitemap.ping_search_engines('http://example.com/sitemap.xml.gz', :super_engine => 'http://superengine.com/ping?url=%s')
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#281
  def ping_search_engines(*args); end

  # Lazy-initialize a sitemap instance and return it.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#322
  def sitemap; end

  # Lazy-initialize a sitemap index instance and return it.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#327
  def sitemap_index; end

  # Return the full url to the sitemap index file.  When `create_index` is `false`
  # the first sitemap is technically the index, so this will be its URL.  It's important
  # to use this method to get the index url because `sitemap_index.location.url`  will
  # not be correct in such situations.
  #
  # KJV: This is somewhat confusing.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#337
  def sitemap_index_url; end

  # Return the host to use in links to the sitemap files.  This defaults to your
  # +default_host+.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#317
  def sitemaps_host; end

  # Returns the value of attribute sitemaps_path.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#10
  def sitemaps_path; end

  # Set verbose on the instance or by setting ENV['VERBOSE'] to true or false.
  # By default verbose is true.  When running rake tasks, pass the <tt>-s</tt>
  # option to rake to turn verbose off.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#368
  def verbose; end

  # Sets the attribute verbose
  #
  # @param value the value to set the attribute verbose to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#12
  def verbose=(_arg0); end

  # Returns the value of attribute yield_sitemap.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def yield_sitemap; end

  # Sets the attribute yield_sitemap
  #
  # @param value the value to set the attribute yield_sitemap to.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#11
  def yield_sitemap=(_arg0); end

  # Return a boolean indicating whether or not to yield the sitemap.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#376
  def yield_sitemap?; end

  protected

  # Add default links if those options are turned on.  Record the fact that we have done so
  # in an instance variable.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#438
  def add_default_links; end

  # Finalize a sitemap by including it in the index and outputting a summary line.
  # Do nothing if it has already been finalized.
  #
  # Don't finalize if the sitemap is empty.
  #
  # Add the default links if they have not been added yet and no groups have been created.
  # If the default links haven't been added we know that the sitemap is empty,
  # because they are added on the first call to add().  This ensure that if the
  # block passed to create() is empty the default links are still included in the
  # sitemap.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#459
  def finalize_sitemap!; end

  # Finalize a sitemap index and output a summary line.  Do nothing if it has already
  # been finalized.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#471
  def finalize_sitemap_index!; end

  # Return the interpreter linked to this instance.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#478
  def interpreter; end

  # Given +opts+, modify it and return it prepped for creating a new group from this LinkSet.
  # If <tt>:public_path</tt> is present in +opts+ it is removed because groups cannot
  # change the public path.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#402
  def options_for_group(opts); end

  # Write the given string to STDOUT.  Used so that the sitemap config can be
  # evaluated and some info output to STDOUT in a lazy fasion.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#494
  def output(string); end

  # Reset this instance.  Keep the same options, but return to the same state
  # as before any sitemaps were created.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#485
  def reset!; end

  # Set each option on this instance using accessor methods.  This will affect
  # both the sitemap and the sitemap index.
  #
  # If both `filename` and `namer` are passed, set filename first so it
  # doesn't override the latter.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#387
  def set_options(opts = T.unsafe(nil)); end
end

module SitemapGenerator::LinkSet::LocationHelpers
  # Return the current compression setting.  Its value determines which files will be gzip'ed.
  # See the setter for documentation of its values.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#653
  def compress; end

  # Set the value of the compress setting.
  #
  # Values:
  #   * `true` - Boolean; compress all files
  #   * `false` - Boolean; write out only uncompressed files
  #   * `:all_but_first` - Symbol; leave the first file uncompressed but compress any remaining files.
  #
  # The compression setting applies to groups too.  So :all_but_first will have the same effect (the first
  # file in the group will not be compressed, the rest will).  So if you require different behaviour for your
  # groups, pass in a `:compress` option e.g. <tt>group(:compress => false) { add('/link') }</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#645
  def compress=(value); end

  # Set the value of +create_index+ on the SitemapIndexLocation object of the
  # SitemapIndexFile.
  #
  # Whether to create a sitemap index file.  Supported values: `true`, `false`, `:auto`.
  # If `true` an index file is always created, regardless of how many links
  # are in your sitemap.  If `false` an index file is never created.
  # If `:auto` an index file is created only if your sitemap has more than
  # one sitemap file.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#612
  def create_index=(value, force = T.unsafe(nil)); end

  # Set the host name, including protocol, that will be used by default on each
  # of your sitemap links.  You can pass a different host in your options to `add`
  # if you need to change it on a per-link basis.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#505
  def default_host=(value); end

  # Set the filename base to use when generating sitemaps (and the sitemap index).
  #
  # === Example
  # <tt>filename = :sitemap</tt>
  #
  # === Generates
  # <tt>sitemap.xml.gz, sitemap1.xml.gz, sitemap2.xml.gz, ...</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#557
  def filename=(value); end

  # Return the namer object.  If it is not set, looks for it on
  # the current sitemap and if there is no sitemap, creates a new one using
  # the current filename.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#631
  def namer; end

  # Set the namer to use to generate the sitemap (and index) file names.
  # This should be an instance of <tt>SitemapGenerator::SimpleNamer</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#622
  def namer=(value); end

  # Return a Pathname with the full path to the public directory
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#527
  def public_path; end

  # Set the public_path.  This path gives the location of your public directory.
  # The default is the public/ directory in your Rails root.  Or if Rails is not
  # found, it defaults to public/ in the current directory (of the process).
  #
  # Example: 'tmp/' if you don't want to generate in public for some reason.
  #
  # Set to nil to use the current directory.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#517
  def public_path=(value); end

  # Return the hash of search engines.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#572
  def search_engines; end

  # Set the search engines hash to a new hash of search engine names mapped to
  # ping URLs (see ping_search_engines).  If the value is nil it is converted
  # to an empty hash.
  # === Example
  # <tt>search_engines = { :google => "http://www.google.com/webmasters/sitemaps/ping?sitemap=%s" }</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#567
  def search_engines=(value); end

  # Return a new +SitemapIndexLocation+ instance with the current options included
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#591
  def sitemap_index_location; end

  # Return a new +SitemapLocation+ instance with the current options included
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#577
  def sitemap_location; end

  # Set the host name, including protocol, that will be used on all links to your sitemap
  # files.  Useful when the server that hosts the sitemaps is not on the same host as
  # the links in the sitemap.
  #
  # Note that `include_index` will be turned off to avoid adding a link to a sitemap with
  # a different host than the other links.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#545
  def sitemaps_host=(value); end

  # Set the sitemaps_path.  This path gives the location to write sitemaps to
  # relative to your public_path.
  # Example: 'sitemaps/' to generate your sitemaps in 'public/sitemaps/'.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#534
  def sitemaps_path=(value); end

  protected

  # Update the given attribute on the current sitemap index and sitemap file location objects.
  # But don't create the index or sitemap files yet if they are not already created.
  #
  # source://sitemap_generator//lib/sitemap_generator/link_set.rb#661
  def update_location_info(attribute, value, opts = T.unsafe(nil)); end
end

# source://sitemap_generator//lib/sitemap_generator.rb#26
SitemapGenerator::MAX_SITEMAP_FILES = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator.rb#30
SitemapGenerator::MAX_SITEMAP_FILESIZE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator.rb#28
SitemapGenerator::MAX_SITEMAP_IMAGES = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator.rb#27
SitemapGenerator::MAX_SITEMAP_LINKS = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator.rb#29
SitemapGenerator::MAX_SITEMAP_NEWS = T.let(T.unsafe(nil), Integer)

class SitemapGenerator::Numeric
  # @return [Numeric] a new instance of Numeric
  #
  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#9
  def initialize(number); end

  # Enables the use of byte calculations and declarations, like 45.bytes + 2.6.megabytes
  #
  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#14
  def byte; end

  # Enables the use of byte calculations and declarations, like 45.bytes + 2.6.megabytes
  #
  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#14
  def bytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#44
  def exabyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#44
  def exabytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#29
  def gigabyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#29
  def gigabytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#19
  def kilobyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#19
  def kilobytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#24
  def megabyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#24
  def megabytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#39
  def petabyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#39
  def petabytes; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#34
  def terabyte; end

  # source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#34
  def terabytes; end
end

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#7
SitemapGenerator::Numeric::EXABYTE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#4
SitemapGenerator::Numeric::GIGABYTE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#2
SitemapGenerator::Numeric::KILOBYTE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#3
SitemapGenerator::Numeric::MEGABYTE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#6
SitemapGenerator::Numeric::PETABYTE = T.let(T.unsafe(nil), Integer)

# source://sitemap_generator//lib/sitemap_generator/core_ext/numeric.rb#5
SitemapGenerator::Numeric::TERABYTE = T.let(T.unsafe(nil), Integer)

class SitemapGenerator::Railtie < ::Rails::Railtie; end

# source://sitemap_generator//lib/sitemap_generator.rb#31
SitemapGenerator::SCHEMAS = T.let(T.unsafe(nil), Hash)

# A class for generating sitemap filenames.
#
# The SimpleNamer uses the same namer instance for the sitemap index and the sitemaps.
# If no index is needed, the first sitemap gets the first name.  However, if
# an index is needed, the index gets the first name.
#
# A typical sequence would looks like this:
#   * sitemap.xml.gz
#   * sitemap1.xml.gz
#   * sitemap2.xml.gz
#   * sitemap3.xml.gz
#   * ...
#
# Arguments:
#   base - string or symbol that forms the base of the generated filename e.g.
#          if `:geo`, files are generated like `geo.xml.gz`, `geo1.xml.gz`, `geo2.xml.gz` etc.
#
# Options:
#   :extension - Default: '.xml.gz'. File extension to append.
#   :start     - Default: 1. Numerical index at which to start counting.
#   :zero      - Default: nil.  A string or number that is appended to +base+
#                to create the first name in the sequence.  So setting this
#                to '_index' would produce 'sitemap_index.xml.gz' as
#                the first name.  Thereafter, the numerical index defined by +start+
#                is used, and subsequent names would be 'sitemap1.xml.gz', 'sitemap2.xml.gz', etc.
#                In these examples the `base` string is assumed to be 'sitemap'.
class SitemapGenerator::SimpleNamer
  # @return [SimpleNamer] a new instance of SimpleNamer
  #
  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#29
  def initialize(base, options = T.unsafe(nil)); end

  # Return this instance set to the next name
  #
  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#55
  def next; end

  # Return this instance set to the previous name
  #
  # @raise [NameError]
  #
  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#65
  def previous; end

  # Reset to the first name
  #
  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#45
  def reset; end

  # True if on the first name
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#50
  def start?; end

  # source://sitemap_generator//lib/sitemap_generator/simple_namer.rb#39
  def to_s; end
end

# source://sitemap_generator//lib/sitemap_generator.rb#40
SitemapGenerator::Sitemap = T.let(T.unsafe(nil), T.untyped)

class SitemapGenerator::SitemapError < ::StandardError; end
class SitemapGenerator::SitemapFinalizedError < ::SitemapGenerator::SitemapError; end
class SitemapGenerator::SitemapFullError < ::SitemapGenerator::SitemapError; end

class SitemapGenerator::SitemapIndexLocation < ::SitemapGenerator::SitemapLocation
  # @return [SitemapIndexLocation] a new instance of SitemapIndexLocation
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#180
  def initialize(opts = T.unsafe(nil)); end

  # Whether to create a sitemap index.  Default `:auto`.  See <tt>LinkSet::create_index=</tt>
  # for possible values.
  #
  # A placeholder for an option which should really go into some
  # kind of options class.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#192
  def create_index; end

  # Return a summary string
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#197
  def summary(link_count); end
end

# A class for determining the exact location at which to write sitemap data.
# Handles reserving filenames from namers, constructing paths and sending
# data to the adapter to be written out.
class SitemapGenerator::SitemapLocation < ::Hash
  include ::SitemapGenerator::Helpers::NumberHelper

  # If no +filename+ or +namer+ is provided, the default namer is used, which
  # generates names like <tt>sitemap.xml.gz</tt>, <tt>sitemap1.xml.gz</tt>, <tt>sitemap2.xml.gz</tt> and so on.
  #
  # === Options
  # * <tt>:adapter</tt> - SitemapGenerator::Adapter subclass
  # * <tt>:filename</tt> - full name of the file e.g. <tt>'sitemap1.xml.gz'<tt>
  # * <tt>:host</tt> - host name for URLs.  The full URL to the file is then constructed from
  #   the <tt>host</tt>, <tt>sitemaps_path</tt> and <tt>filename</tt>
  # * <tt>:namer</tt> - a SitemapGenerator::SimpleNamer instance for generating file names.
  #   Should be passed if no +filename+ is provided.
  # * <tt>:public_path</tt> - path to the "public" directory, or the directory you want to
  #   write sitemaps in.  Default is a directory <tt>public/</tt>
  #   in the current working directory, or relative to the Rails root
  #   directory if running under Rails.
  # * <tt>:sitemaps_path</tt> - gives the path relative to the <tt>public_path</tt> in which to
  #   write sitemaps e.g. <tt>sitemaps/</tt>.
  # * <tt>:verbose</tt> - whether to output summary into to STDOUT.  Default +false+.
  # * <tt>:create_index</tt> - whether to create a sitemap index.  Default `:auto`.  See <tt>LinkSet::create_index=</tt>
  #   for possible values. Only applies to the SitemapIndexLocation object.
  # * <tt>compress</tt> - The LinkSet compress setting.  Default: +true+.  If `false` any `.gz` extension is
  #   stripped from the filename.  If `:all_but_first`, only the `.gz` extension of the first
  #   filename is stripped off.  If `true` the extensions are left unchanged.
  # * <tt>max_sitemap_links</tt> - The maximum number of links to put in each sitemap.
  #
  # @return [SitemapLocation] a new instance of SitemapLocation
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#48
  def initialize(opts = T.unsafe(nil)); end

  # If you set the filename, clear the namer and vice versa.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#151
  def []=(key, value, opts = T.unsafe(nil)); end

  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#13
  def adapter; end

  # Full path to the directory of the file.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#81
  def directory; end

  # Return the filename.  Raises an exception if no filename or namer is set.
  # If using a namer once the filename has been retrieved from the namer its
  # value is locked so that it is unaffected by further changes to the namer.
  #
  # @raise [SitemapGenerator::SitemapError]
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#108
  def filename; end

  # Return the size of the file at <tt>path</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#101
  def filesize; end

  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#13
  def host; end

  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#142
  def namer; end

  # Full path of the file including the filename.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#86
  def path; end

  # Relative path of the file (including the filename) relative to <tt>public_path</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#91
  def path_in_public; end

  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#20
  def public_path; end

  # If a namer is set, reserve the filename and increment the namer.
  # Returns the reserved name.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#128
  def reserve_name; end

  # Return true if this location has a fixed filename.  If no name has been
  # reserved from the namer, for instance, returns false.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#138
  def reserved_name?; end

  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#20
  def sitemaps_path; end

  # Return a summary string
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#171
  def summary(link_count); end

  # Full URL of the file.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#96
  def url; end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#146
  def verbose?; end

  # Return a new Location instance with the given options merged in
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#76
  def with(opts = T.unsafe(nil)); end

  # Write `data` out to a file.
  # Output a summary line if verbose is true.
  #
  # source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#165
  def write(data, link_count); end
end

# Character width of the path in the summary lines
#
# source://sitemap_generator//lib/sitemap_generator/sitemap_location.rb#10
SitemapGenerator::SitemapLocation::PATH_OUTPUT_WIDTH = T.let(T.unsafe(nil), Integer)

# Provide convenient access to template files.  E.g.
#
#   SitemapGenerator.templates.sitemap_index
#
# Lazy-load and cache for efficient access.
# Define an accessor method for each template file.
class SitemapGenerator::Templates
  # @return [Templates] a new instance of Templates
  #
  # source://sitemap_generator//lib/sitemap_generator/templates.rb#23
  def initialize(root = T.unsafe(nil)); end

  def sitemap_sample; end

  # source://sitemap_generator//lib/sitemap_generator/templates.rb#14
  def sitemap_sample=(_arg0); end

  # Return the full path to a template.
  #
  # <tt>file</tt> template symbol e.g. <tt>:sitemap_sample</tt>
  #
  # source://sitemap_generator//lib/sitemap_generator/templates.rb#30
  def template_path(template); end

  protected

  # Read the template file and return its contents.
  #
  # source://sitemap_generator//lib/sitemap_generator/templates.rb#37
  def read_template(template); end
end

# source://sitemap_generator//lib/sitemap_generator/templates.rb#9
SitemapGenerator::Templates::FILES = T.let(T.unsafe(nil), Hash)

module SitemapGenerator::Utilities
  extend ::SitemapGenerator::Utilities

  # Append a slash to `path` if it does not already end in a slash.
  # Returns a string.  Expects a string or Pathname object.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#157
  def append_slash(path); end

  # Make a list of `value` if it is not a list already.  If `value` is
  # nil, an empty list is returned.  If `value` is already a list, return it unchanged.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#54
  def as_array(value); end

  # Validate all keys in a hash match *valid keys, raising ArgumentError on a
  # mismatch. Note that keys are NOT treated indifferently, meaning if you use
  # strings for keys but assert symbols as keys, this will fail.
  #
  # @raise [ArgumentError]
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#32
  def assert_valid_keys(hash, *valid_keys); end

  # An object is blank if it's false, empty, or a whitespace string.
  # For example, "", "   ", +nil+, [], and {} are blank.
  #
  # This simplifies:
  #
  #   if !address.nil? && !address.empty?
  #
  # ...to:
  #
  #   if !address.blank?
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#114
  def blank?(object); end

  # Return the bytesize length of the string.  Ruby 1.8.6 compatible.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#177
  def bytesize(string); end

  # Clean sitemap files in output directory.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#25
  def clean_files; end

  # Replace the last 3 characters of string with ... if the string is as big
  # or bigger than max.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#168
  def ellipsis(string, max); end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#151
  def falsy?(value); end

  # Copy templates/sitemap.rb to config if not there yet.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#6
  def install_sitemap_rb(verbose = T.unsafe(nil)); end

  # An object is present if it's not blank.
  #
  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#130
  def present?(object); end

  # Allows for reverse merging two hashes where the keys in the calling hash take precedence over those
  # in the <tt>other_hash</tt>. This is particularly useful for initializing an option hash with default values:
  #
  #   def setup(options = {})
  #     options.reverse_merge! :size => 25, :velocity => 10
  #   end
  #
  # Using <tt>merge</tt>, the above example would look as follows:
  #
  #   def setup(options = {})
  #     { :size => 25, :velocity => 10 }.merge(options)
  #   end
  #
  # The default <tt>:size</tt> and <tt>:velocity</tt> are only set if the +options+ hash passed in doesn't already
  # have the respective key.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#94
  def reverse_merge(hash, other_hash); end

  # Performs the opposite of <tt>merge</tt>, with the keys and values from the first hash taking precedence over the second.
  # Modifies the receiver in place.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#100
  def reverse_merge!(hash, other_hash); end

  # Rounds the float with the specified precision.
  #
  #   x = 1.337
  #   x.round    # => 1
  #   x.round(1) # => 1.3
  #   x.round(2) # => 1.34
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#70
  def round(float, precision = T.unsafe(nil)); end

  # Return a new hash with all keys converted to symbols, as long as
  # they respond to +to_sym+.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#39
  def symbolize_keys(hash); end

  # Destructively convert all keys to symbols, as long as they respond
  # to +to_sym+.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#45
  def symbolize_keys!(hash); end

  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#142
  def titleize(string); end

  # @return [Boolean]
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#147
  def truthy?(value); end

  # Remove config/sitemap.rb if exists.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#18
  def uninstall_sitemap_rb; end

  # Sets $VERBOSE for the duration of the block and back to its original value afterwards.
  #
  # source://sitemap_generator//lib/sitemap_generator/utilities.rb#135
  def with_warnings(flag); end
end

# source://sitemap_generator//lib/sitemap_generator.rb#25
SitemapGenerator::VERSION = T.let(T.unsafe(nil), String)
