# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sentry-sidekiq` gem.
# Please instead update this file by running `bin/tapioca gem sentry-sidekiq`.

class Sentry::Configuration
  include ::Sentry::CustomInspection
  include ::Sentry::LoggingHelper

  # @return [Configuration] a new instance of Configuration
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#250
  def initialize; end

  # Directories to be recognized as part of your app. e.g. if you
  # have an `engines` dir at the root of your project, you may want
  # to set this to something like /(app|config|engines|lib)/
  #
  # @return [Regexp, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#22
  def app_dirs_pattern; end

  # Directories to be recognized as part of your app. e.g. if you
  # have an `engines` dir at the root of your project, you may want
  # to set this to something like /(app|config|engines|lib)/
  #
  # @return [Regexp, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#22
  def app_dirs_pattern=(_arg0); end

  # Provide an object that responds to `call` to send events asynchronously.
  # E.g.: lambda { |event| Thread.new { Sentry.send_event(event) } }
  #
  # @deprecated It will be removed in the next major release. Please read https://github.com/getsentry/sentry-ruby/issues/1522 for more information
  # @return [Proc, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#29
  def async; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#297
  def async=(value); end

  # Track sessions in request/response cycles automatically
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#212
  def auto_session_tracking; end

  # Track sessions in request/response cycles automatically
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#212
  def auto_session_tracking=(_arg0); end

  # to send events in a non-blocking way, sentry-ruby has its own background worker
  # by default, the worker holds a thread pool that has [the number of processors] threads
  # but you can configure it with this configuration option
  # E.g.: config.background_worker_threads = 5
  #
  # if you want to send events synchronously, set the value to 0
  # E.g.: config.background_worker_threads = 0
  #
  # @return [Integer]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#39
  def background_worker_threads; end

  # to send events in a non-blocking way, sentry-ruby has its own background worker
  # by default, the worker holds a thread pool that has [the number of processors] threads
  # but you can configure it with this configuration option
  # E.g.: config.background_worker_threads = 5
  #
  # if you want to send events synchronously, set the value to 0
  # E.g.: config.background_worker_threads = 0
  #
  # @return [Integer]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#39
  def background_worker_threads=(_arg0); end

  # a proc/lambda that takes an array of stack traces
  # it'll be used to silence (reduce) backtrace of the exception
  #
  # @example
  #   config.backtrace_cleanup_callback = lambda do |backtrace|
  #   Rails.backtrace_cleaner.clean(backtrace)
  #   end
  # @return [Proc, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#50
  def backtrace_cleanup_callback; end

  # a proc/lambda that takes an array of stack traces
  # it'll be used to silence (reduce) backtrace of the exception
  #
  # @example
  #   config.backtrace_cleanup_callback = lambda do |backtrace|
  #   Rails.backtrace_cleaner.clean(backtrace)
  #   end
  # @return [Proc, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#50
  def backtrace_cleanup_callback=(_arg0); end

  # Optional Proc, called before adding the breadcrumb to the current scope
  #
  # @example
  #   config.before = lambda do |breadcrumb, hint|
  #   breadcrumb.message = 'a'
  #   breadcrumb
  #   end
  # @return [Proc]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#59
  def before_breadcrumb; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#332
  def before_breadcrumb=(value); end

  # Optional Proc, called before sending an event to the server
  #
  # @example
  #   config.before_send = lambda do |event, hint|
  #   # skip ZeroDivisionError exceptions
  #   # note: hint[:exception] would be a String if you use async callback
  #   if hint[:exception].is_a?(ZeroDivisionError)
  #   nil
  #   else
  #   event
  #   end
  #   end
  # @return [Proc]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#73
  def before_send; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#326
  def before_send=(value); end

  # An array of breadcrumbs loggers to be used. Available options are:
  # - :sentry_logger
  # - :http_logger
  # - :redis_logger
  #
  # And if you also use sentry-rails:
  # - :active_support_logger
  # - :monotonic_active_support_logger
  #
  # @return [Array<Symbol>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#85
  def breadcrumbs_logger; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#313
  def breadcrumbs_logger=(logger); end

  # Whether to capture local variables from the raised exception's frame. Default is false.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#89
  def capture_exception_frame_locals; end

  # Whether to capture local variables from the raised exception's frame. Default is false.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#89
  def capture_exception_frame_locals=(_arg0); end

  # Number of lines of code context to capture, or nil for none
  #
  # @return [Integer, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#97
  def context_lines; end

  # Number of lines of code context to capture, or nil for none
  #
  # @return [Integer, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#97
  def context_lines=(_arg0); end

  # @return [String, nil]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#380
  def csp_report_uri; end

  # Whether the SDK should run in the debugging mode. Default is false.
  # If set to true, SDK errors will be logged with backtrace
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#106
  def debug; end

  # Whether the SDK should run in the debugging mode. Default is false.
  # If set to true, SDK errors will be logged with backtrace
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#106
  def debug=(_arg0); end

  # @api private
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#401
  def detect_release; end

  # the dsn value, whether it's set via `config.dsn=` or `ENV["SENTRY_DSN"]`
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#110
  def dsn; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#291
  def dsn=(value); end

  # Whitelist of enabled_environments that will send notifications to Sentry. Array of Strings.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#114
  def enabled_environments; end

  # Whitelist of enabled_environments that will send notifications to Sentry. Array of Strings.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#114
  def enabled_environments=(_arg0); end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#371
  def enabled_in_current_env?; end

  # RACK_ENV by default.
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#101
  def environment; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#338
  def environment=(environment); end

  # @api private
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#414
  def error_messages; end

  # these are not config options
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#220
  def errors; end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#358
  def exception_class_allowed?(exc); end

  # Logger 'progname's to exclude from breadcrumbs
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#118
  def exclude_loggers; end

  # Logger 'progname's to exclude from breadcrumbs
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#118
  def exclude_loggers=(_arg0); end

  # Array of exception classes that should never be sent. See IGNORE_DEFAULT.
  # You should probably append to this rather than overwrite it.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#123
  def excluded_exceptions; end

  # Array of exception classes that should never be sent. See IGNORE_DEFAULT.
  # You should probably append to this rather than overwrite it.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#123
  def excluded_exceptions=(_arg0); end

  # these are not config options
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#220
  def gem_specs; end

  # Boolean to check nested exceptions when deciding if to exclude. Defaults to true
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#127
  def inspect_exception_causes_for_exclusion; end

  # Boolean to check nested exceptions when deciding if to exclude. Defaults to true
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#127
  def inspect_exception_causes_for_exclusion=(_arg0); end

  # Boolean to check nested exceptions when deciding if to exclude. Defaults to true
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#127
  def inspect_exception_causes_for_exclusion?; end

  # The instrumenter to use, :sentry or :otel
  #
  # @return [Symbol]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#216
  def instrumenter; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#342
  def instrumenter=(instrumenter); end

  # You may provide your own LineCache for matching paths with source files.
  # This may be useful if you need to get source code from places other than the disk.
  #
  # @return [LineCache]
  # @see LineCache
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#134
  def linecache; end

  # You may provide your own LineCache for matching paths with source files.
  # This may be useful if you need to get source code from places other than the disk.
  #
  # @return [LineCache]
  # @see LineCache
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#134
  def linecache=(_arg0); end

  # Logger used by Sentry. In Rails, this is the Rails logger, otherwise
  # Sentry provides its own Sentry::Logger.
  #
  # @return [Logger]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#139
  def logger; end

  # Logger used by Sentry. In Rails, this is the Rails logger, otherwise
  # Sentry provides its own Sentry::Logger.
  #
  # @return [Logger]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#139
  def logger=(_arg0); end

  # Max number of breadcrumbs a breadcrumb buffer can hold
  #
  # @return [Integer]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#93
  def max_breadcrumbs; end

  # Max number of breadcrumbs a breadcrumb buffer can hold
  #
  # @return [Integer]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#93
  def max_breadcrumbs=(_arg0); end

  # Project directory root for in_app detection. Could be Rails root, etc.
  # Set automatically for Rails.
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#144
  def project_root; end

  # Project directory root for in_app detection. Could be Rails root, etc.
  # Set automatically for Rails.
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#144
  def project_root=(_arg0); end

  # Insert sentry-trace to outgoing requests' headers
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#148
  def propagate_traces; end

  # Insert sentry-trace to outgoing requests' headers
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#148
  def propagate_traces=(_arg0); end

  # Array of rack env parameters to be included in the event sent to sentry.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#152
  def rack_env_whitelist; end

  # Array of rack env parameters to be included in the event sent to sentry.
  #
  # @return [Array<String>]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#152
  def rack_env_whitelist=(_arg0); end

  # Returns the value of attribute rails.
  #
  # source://sentry-rails/5.7.0/lib/sentry/rails/configuration.rb#8
  def rails; end

  # Release tag to be passed with every event sent to Sentry.
  # We automatically try to set this to a git SHA or Capistrano release.
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#157
  def release; end

  # Release tag to be passed with every event sent to Sentry.
  # We automatically try to set this to a git SHA or Capistrano release.
  #
  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#157
  def release=(_arg0); end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#352
  def sample_allowed?; end

  # The sampling factor to apply to events. A value of 0.0 will not send
  # any events, and a value of 1.0 will send 100% of events.
  #
  # @return [Float]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#162
  def sample_rate; end

  # The sampling factor to apply to events. A value of 0.0 will not send
  # any events, and a value of 1.0 will send 100% of events.
  #
  # @return [Float]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#162
  def sample_rate=(_arg0); end

  # Send diagnostic client reports about dropped events, true by default
  # tries to attach to an existing envelope max once every 30s
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#208
  def send_client_reports; end

  # Send diagnostic client reports about dropped events, true by default
  # tries to attach to an existing envelope max once every 30s
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#208
  def send_client_reports=(_arg0); end

  # When send_default_pii's value is false (default), sensitive information like
  # - user ip
  # - user cookie
  # - request body
  # - query string
  # will not be sent to Sentry.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#175
  def send_default_pii; end

  # When send_default_pii's value is false (default), sensitive information like
  # - user ip
  # - user cookie
  # - request body
  # - query string
  # will not be sent to Sentry.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#175
  def send_default_pii=(_arg0); end

  # Include module versions in reports - boolean.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#166
  def send_modules; end

  # Include module versions in reports - boolean.
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#166
  def send_modules=(_arg0); end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#346
  def sending_allowed?; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#291
  def server=(value); end

  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#185
  def server_name; end

  # @return [String]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#185
  def server_name=(_arg0); end

  # Returns the value of attribute sidekiq.
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/configuration.rb#3
  def sidekiq; end

  # Allow to skip Sentry emails within rake tasks
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#179
  def skip_rake_integration; end

  # Allow to skip Sentry emails within rake tasks
  #
  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#179
  def skip_rake_integration=(_arg0); end

  # @api private
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#390
  def stacktrace_builder; end

  # Take a float between 0.0 and 1.0 as the sample rate for tracing events (transactions).
  #
  # @return [Float]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#193
  def traces_sample_rate; end

  # Take a float between 0.0 and 1.0 as the sample rate for tracing events (transactions).
  #
  # @return [Float]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#193
  def traces_sample_rate=(_arg0); end

  # Take a Proc that controls the sample rate for every tracing event, e.g.
  #
  # @example
  #   config.traces_sampler =  lambda do |tracing_context|
  #   # tracing_context[:transaction_context] contains the information about the transaction
  #   # tracing_context[:parent_sampled] contains the transaction's parent's sample decision
  #   true # return value can be a boolean or a float between 0.0 and 1.0
  #   end
  # @return [Proc]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#203
  def traces_sampler; end

  # Take a Proc that controls the sample rate for every tracing event, e.g.
  #
  # @example
  #   config.traces_sampler =  lambda do |tracing_context|
  #   # tracing_context[:transaction_context] contains the information about the transaction
  #   # tracing_context[:parent_sampled] contains the transaction's parent's sample decision
  #   true # return value can be a boolean or a float between 0.0 and 1.0
  #   end
  # @return [Proc]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#203
  def traces_sampler=(_arg0); end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#375
  def tracing_enabled?; end

  # Return a Transport::Configuration object for transport-related configurations.
  #
  # @return [Transport]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#189
  def transport; end

  # IP ranges for trusted proxies that will be skipped when calculating IP address.
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#182
  def trusted_proxies; end

  # IP ranges for trusted proxies that will be skipped when calculating IP address.
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#182
  def trusted_proxies=(_arg0); end

  private

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#462
  def capture_in_environment?; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#421
  def check_callable!(name, value); end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#478
  def environment_from_env; end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#433
  def excluded_exception?(incoming_exception); end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#439
  def excluded_exception_classes; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#443
  def get_exception_class(x); end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#427
  def init_dsn(dsn_string); end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#447
  def matches_exception?(excluded_exception_class, incoming_exception); end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#496
  def run_post_initialization_callbacks; end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#492
  def running_on_heroku?; end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#455
  def safe_const_get(x); end

  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#482
  def server_name_from_env; end

  # @return [Boolean]
  #
  # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#469
  def valid?; end

  class << self
    # allow extensions to add their hooks to the Configuration class
    #
    # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#503
    def add_post_initialization_callback(&block); end

    # source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#509
    def post_initialization_callbacks; end
  end
end

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#237
Sentry::Configuration::HEROKU_DYNO_METADATA_MESSAGE = T.let(T.unsafe(nil), String)

# Most of these errors generate 4XX responses. In general, Sentry clients
# only automatically report 5xx responses.
#
# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#224
Sentry::Configuration::IGNORE_DEFAULT = T.let(T.unsafe(nil), Array)

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#244
Sentry::Configuration::INSTRUMENTERS = T.let(T.unsafe(nil), Array)

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#240
Sentry::Configuration::LOG_PREFIX = T.let(T.unsafe(nil), String)

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#241
Sentry::Configuration::MODULE_SEPARATOR = T.let(T.unsafe(nil), String)

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#231
Sentry::Configuration::RACK_ENV_WHITELIST_DEFAULT = T.let(T.unsafe(nil), Array)

# source://sentry-ruby/5.7.0/lib/sentry/configuration.rb#242
Sentry::Configuration::SKIP_INSPECTION_ATTRIBUTES = T.let(T.unsafe(nil), Array)

module Sentry::Sidekiq
  extend ::Sentry::Integrable
end

class Sentry::Sidekiq::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/configuration.rb#19
  def initialize; end

  # Set this option to true if you want Sentry to only capture the last job
  # retry if it fails.
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/configuration.rb#17
  def report_after_job_retries; end

  # Set this option to true if you want Sentry to only capture the last job
  # retry if it fails.
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/configuration.rb#17
  def report_after_job_retries=(_arg0); end
end

class Sentry::Sidekiq::ContextFilter
  # @return [ContextFilter] a new instance of ContextFilter
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#9
  def initialize(context); end

  # Returns the value of attribute context.
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#7
  def context; end

  # Once an ActiveJob is queued, ActiveRecord references get serialized into
  # some internal reserved keys, such as _aj_globalid.
  #
  # The problem is, if this job in turn gets queued back into ActiveJob with
  # these magic reserved keys, ActiveJob will throw up and error. We want to
  # capture these and mutate the keys so we can sanely report it.
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#20
  def filtered; end

  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#32
  def transaction_name; end

  private

  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#48
  def filter_context(hash); end

  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#63
  def filter_context_hash(key, value); end

  # @return [Boolean]
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#68
  def has_global_id?; end
end

# source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#4
Sentry::Sidekiq::ContextFilter::ACTIVEJOB_RESERVED_PREFIX_REGEX = T.let(T.unsafe(nil), Regexp)

# source://sentry-sidekiq//lib/sentry/sidekiq/context_filter.rb#5
Sentry::Sidekiq::ContextFilter::SIDEKIQ_NAME = T.let(T.unsafe(nil), String)

class Sentry::Sidekiq::ErrorHandler
  # source://sentry-sidekiq//lib/sentry/sidekiq/error_handler.rb#8
  def call(ex, context); end

  private

  # source://sentry-sidekiq//lib/sentry/sidekiq/error_handler.rb#38
  def retry_limit(context); end

  # @return [Boolean]
  #
  # source://sentry-sidekiq//lib/sentry/sidekiq/error_handler.rb#32
  def retryable?(context); end
end

# source://sentry-sidekiq//lib/sentry/sidekiq/error_handler.rb#6
Sentry::Sidekiq::ErrorHandler::WITH_SIDEKIQ_7 = T.let(T.unsafe(nil), FalseClass)

# source://sentry-sidekiq//lib/sentry/sidekiq/configuration.rb#12
Sentry::Sidekiq::IGNORE_DEFAULT = T.let(T.unsafe(nil), Array)

class Sentry::Sidekiq::Railtie < ::Rails::Railtie; end

class Sentry::Sidekiq::SentryContextClientMiddleware
  # source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#57
  def call(_worker_class, job, _queue, _redis_pool); end
end

class Sentry::Sidekiq::SentryContextServerMiddleware
  # source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#38
  def build_tags(tags); end

  # source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#8
  def call(_worker, job, queue); end

  # source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#48
  def finish_transaction(transaction, status); end

  # source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#42
  def start_transaction(scope, sentry_trace); end
end

# source://sentry-sidekiq//lib/sentry/sidekiq/sentry_context_middleware.rb#6
Sentry::Sidekiq::SentryContextServerMiddleware::OP_NAME = T.let(T.unsafe(nil), String)

# source://sentry-sidekiq//lib/sentry/sidekiq/version.rb#3
Sentry::Sidekiq::VERSION = T.let(T.unsafe(nil), String)
