# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `selenium-webdriver` gem.
# Please instead update this file by running `bin/tapioca gem selenium-webdriver`.

module Selenium; end

module Selenium::WebDriver
  class << self
    # Create a new Driver instance with the correct bridge for the given browser
    #
    # One special argument is not passed on to the bridges, :listener.
    # You can pass a listener for this option to get notified of WebDriver events.
    # The passed object must respond to #call or implement the methods from AbstractEventListener.
    #
    # @example
    #
    #   WebDriver.for :firefox, profile: 'some-profile'
    #   WebDriver.for :firefox, profile: Profile.new
    #   WebDriver.for :remote,  url: "http://localhost:4444/wd/hub", capabilities: caps
    # @overload for
    # @overload for
    # @return [Driver]
    # @see Selenium::WebDriver::Remote::Driver
    # @see Selenium::WebDriver::Firefox::Driver
    # @see Selenium::WebDriver::IE::Driver
    # @see Selenium::WebDriver::Edge::Driver
    # @see Selenium::WebDriver::Chrome::Driver
    # @see Selenium::WebDriver::Safari::Driver
    # @see Selenium::WebDriver::Support::AbstractEventListener
    #
    # source://selenium-webdriver//lib/selenium/webdriver.rb#87
    def for(*args); end

    # Returns logger instance that can be used across the whole Selenium.
    #
    # @return [Logger]
    #
    # source://selenium-webdriver//lib/selenium/webdriver.rb#97
    def logger; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver.rb#50
    def root; end
  end
end

class Selenium::WebDriver::ActionBuilder
  include ::Selenium::WebDriver::KeyActions
  include ::Selenium::WebDriver::PointerActions
  include ::Selenium::WebDriver::WheelActions

  # Initialize a W3C Action Builder. Differs from previous by requiring a bridge and allowing asynchronous actions.
  # The W3C implementation allows asynchronous actions per device. e.g. A key can be pressed at the same time that
  # the mouse is moving. Keep in mind that pauses must be added for other devices in order to line up the actions
  # correctly when using asynchronous.
  #
  # @param bridge [Selenium::WebDriver::Remote::Bridge] the bridge for the current driver instance.
  # @param deprecated_mouse [Selenium::WebDriver::Interactions::PointerInput] PointerInput for the mouse.
  # @param deprecated_keyboard [Selenium::WebDriver::Interactions::KeyInput] KeyInput for the keyboard.
  # @param deprecated_async [Boolean] Whether to perform the actions asynchronously per device.
  #   Defaults to false for backwards compatibility.
  # @param devices [Array<Selenium::WebDriver::Interactions::InputDevices>] list of valid sources of input.
  # @param async [Boolean] Whether to perform the actions asynchronously per device.
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#45
  def initialize(bridge, deprecated_mouse = T.unsafe(nil), deprecated_keyboard = T.unsafe(nil), deprecated_async = T.unsafe(nil), devices: T.unsafe(nil), async: T.unsafe(nil), duration: T.unsafe(nil)); end

  # Adds a KeyInput device
  #
  # @example Add a key input device
  #
  #   builder = device.action
  #   builder.add_key_input('keyboard2')
  # @param name [String] name for the device
  # @return [Interactions::KeyInput] The key input added
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#101
  def add_key_input(name); end

  # Adds a PointerInput device of the given kind
  #
  # @example Add a touch pointer input device
  #
  #   builder = device.action
  #   builder.add_pointer_input('touch', :touch)
  # @param name [String] name for the device
  # @param kind [Symbol] kind of pointer device to create
  # @return [Interactions::PointerInput] The pointer input added
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#85
  def add_pointer_input(kind, name); end

  # Adds a WheelInput device
  #
  # @example Add a wheel input device
  #
  #   builder = device.action
  #   builder.add_wheel_input('wheel2')
  # @param name [String] name for the device
  # @return [Interactions::WheelInput] The wheel input added
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#117
  def add_wheel_input(name); end

  # Clears all actions from the builder.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#247
  def clear_all_actions; end

  # Retrieves the input device for the given name or type
  #
  # @param name [String] name of the input device
  # @param type [String] name of the input device
  # @raise [ArgumentError]
  # @return [Selenium::WebDriver::Interactions::InputDevice] input device with given name or type
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#143
  def device(name: T.unsafe(nil), type: T.unsafe(nil)); end

  # Returns the value of attribute devices.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#27
  def devices; end

  # Retrieves the input device for the given name
  #
  # @param name [String] name of the input device
  # @return [Selenium::WebDriver::Interactions::InputDevice] input device with given name
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#128
  def get_device(name); end

  # Retrieves the current KeyInput device
  #
  # @return [Selenium::WebDriver::Interactions::InputDevice] current KeyInput device
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#167
  def key_inputs; end

  # Creates a pause for the given device of the given duration. If no duration is given, the pause will only wait
  # for all actions to complete in that tick.
  #
  # @example Send keys to an element
  #
  #   action_builder = driver.action
  #   keyboard = action_builder.key_input
  #   el = driver.find_element(id: "some_id")
  #   driver.action.click(el).pause(keyboard).pause(keyboard).pause(keyboard).send_keys('keys').perform
  # @param device [InputDevice] Input device to pause
  # @param duration [Float] Duration to pause
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#197
  def pause(deprecated_device = T.unsafe(nil), deprecated_duration = T.unsafe(nil), device: T.unsafe(nil), duration: T.unsafe(nil)); end

  # Creates multiple pauses for the given device of the given duration.
  #
  # @example Send keys to an element
  #
  #   action_builder = driver.action
  #   keyboard = action_builder.key_input
  #   el = driver.find_element(id: "some_id")
  #   driver.action.click(el).pauses(keyboard, 3).send_keys('keys').perform
  # @param device [InputDevice] Input device to pause
  # @param number [Integer] of pauses to add for the device
  # @param duration [Float] Duration to pause
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#221
  def pauses(deprecated_device = T.unsafe(nil), deprecated_number = T.unsafe(nil), deprecated_duration = T.unsafe(nil), device: T.unsafe(nil), number: T.unsafe(nil), duration: T.unsafe(nil)); end

  # Executes the actions added to the builder.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#237
  def perform; end

  # Retrieves the current PointerInput devices
  #
  # @return [Array] array of current PointerInput devices
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#157
  def pointer_inputs; end

  # Releases all action states from the browser.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#255
  def release_actions; end

  # Retrieves the current WheelInput device
  #
  # @return [Selenium::WebDriver::Interactions::InputDevice] current WheelInput devices
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#177
  def wheel_inputs; end

  private

  # Adds an InputDevice
  #
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#277
  def add_input(device); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#290
  def deprecate_method(device = T.unsafe(nil), duration = T.unsafe(nil), number = T.unsafe(nil), method: T.unsafe(nil)); end

  # Adds pauses for all devices but the given devices
  #
  # @param action_devices [Array[InputDevice]] Array of Input Devices performing an action in this tick.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/action_builder.rb#267
  def tick(*action_devices); end
end

class Selenium::WebDriver::Alert
  # @return [Alert] a new instance of Alert
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/alert.rb#23
  def initialize(bridge); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/alert.rb#30
  def accept; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/alert.rb#34
  def dismiss; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/alert.rb#38
  def send_keys(keys); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/alert.rb#42
  def text; end
end

module Selenium::WebDriver::Atoms
  private

  # source://selenium-webdriver//lib/selenium/webdriver/atoms.rb#30
  def execute_atom(function_name, *arguments); end

  # source://selenium-webdriver//lib/selenium/webdriver/atoms.rb#26
  def read_atom(function); end
end

class Selenium::WebDriver::BiDi
  # @return [BiDi] a new instance of BiDi
  #
  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#25
  def initialize(url:); end

  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#33
  def callbacks; end

  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#29
  def close; end

  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#49
  def error_message(message); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#41
  def send_cmd(method, **params); end

  # source://selenium-webdriver//lib/selenium/webdriver/bidi.rb#37
  def session; end
end

class Selenium::WebDriver::BiDi::Session
  # @return [Session] a new instance of Session
  #
  # source://selenium-webdriver//lib/selenium/webdriver/bidi/session.rb#26
  def initialize(bidi); end

  # source://selenium-webdriver//lib/selenium/webdriver/bidi/session.rb#30
  def status; end
end

class Selenium::WebDriver::BiDi::Session::Status < ::Struct
  # Returns the value of attribute message
  #
  # @return [Object] the current value of message
  def message; end

  # Sets the attribute message
  #
  # @param value [Object] the value to set the attribute message to.
  # @return [Object] the newly set value
  def message=(_); end

  # Returns the value of attribute ready
  #
  # @return [Object] the current value of ready
  def ready; end

  # Sets the attribute ready
  #
  # @param value [Object] the value to set the attribute ready to.
  # @return [Object] the newly set value
  def ready=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @api private
class Selenium::WebDriver::ChildProcess
  # @api private
  # @return [ChildProcess] a new instance of ChildProcess
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#42
  def initialize(*command); end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#80
  def alive?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#35
  def detach; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#35
  def detach=(_arg0); end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#84
  def exited?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#49
  def io; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#36
  def io=(_arg0); end

  # @api private
  # @raise [TimeoutError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#97
  def poll_for_exit(timeout); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#53
  def start; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#64
  def stop(timeout = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#106
  def wait; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#118
  def kill(pid); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#114
  def terminate(pid); end

  class << self
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#38
    def build(*command); end
  end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#33
Selenium::WebDriver::ChildProcess::POLL_INTERVAL = T.let(T.unsafe(nil), Float)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#31
Selenium::WebDriver::ChildProcess::SIGKILL = T.let(T.unsafe(nil), String)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/child_process.rb#30
Selenium::WebDriver::ChildProcess::SIGTERM = T.let(T.unsafe(nil), String)

# @api private
class Selenium::WebDriver::ChildProcess::TimeoutError < ::StandardError; end

module Selenium::WebDriver::Chrome
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/chrome.rb#36
    def path; end

    # source://selenium-webdriver//lib/selenium/webdriver/chrome.rb#31
    def path=(path); end
  end
end

# Driver implementation for Chrome.
#
# @api private
class Selenium::WebDriver::Chrome::Driver < ::Selenium::WebDriver::Driver
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/driver.rb#47
  def browser; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/driver.rb#64
  def devtools_address; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/driver.rb#53
  def devtools_url; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/driver.rb#60
  def devtools_version; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/chrome/driver.rb#30
Selenium::WebDriver::Chrome::Driver::EXTENSIONS = T.let(T.unsafe(nil), Array)

module Selenium::WebDriver::Chrome::Features
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#94
  def available_log_types; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#58
  def cast_issue_message; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#54
  def cast_sink_to_use=(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#50
  def cast_sinks; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#42
  def commands(command); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#86
  def delete_network_conditions; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#46
  def launch_app(id); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#99
  def log(type); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#78
  def network_conditions; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#82
  def network_conditions=(conditions); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#90
  def send_command(command_params); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#74
  def set_permission(name, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#66
  def start_cast_desktop_mirroring(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#62
  def start_cast_tab_mirroring(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#70
  def stop_casting(name); end
end

# source://selenium-webdriver//lib/selenium/webdriver/chrome/features.rb#25
Selenium::WebDriver::Chrome::Features::CHROME_COMMANDS = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Chrome::Options < ::Selenium::WebDriver::Options
  # Create a new Options instance.
  #
  # @example
  #   options = Selenium::WebDriver::Chrome::Options.new(args: ['start-maximized', 'user-data-dir=/tmp/temp_profile'])
  #   driver = Selenium::WebDriver.for(:chrome, capabilities: options)
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param profile [Profile] An instance of a Chrome::Profile Class
  # @param opts [Hash] the pre-defined options to create the Chrome::Options with
  # @return [Options] a new instance of Options
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#73
  def initialize(profile: T.unsafe(nil), **opts); end

  # Add a command-line argument to use when starting Chrome.
  #
  # @example Start Chrome maximized
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_argument('start-maximized')
  # @param arg [String] The command-line argument to add
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#146
  def add_argument(arg); end

  # Add emulation device information
  #
  # see: http://chromedriver.chromium.org/mobile-emulation
  #
  # @example Start Chrome in mobile emulation mode by device name
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_emulation(device_name: 'iPhone 6')
  # @example Start Chrome in mobile emulation mode by device metrics
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_emulation(device_metrics: {width: 400, height: 800, pixelRatio: 1, touch: true})
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] the pre-defined options for adding mobile emulation values
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#196
  def add_emulation(**opts); end

  # Add an extension by Base64-encoded string.
  #
  # @example
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_encoded_extension(encoded_string)
  # @param encoded [String] The Base64-encoded string of the .crx file
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#132
  def add_encoded_extension(encoded); end

  # Add an extension by local path.
  #
  # @example
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_extension('/path/to/extension.crx')
  # @param path [String] The local path to the .crx file
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#103
  def add_extension(path); end

  # Add a preference that is only applied to the user profile in use.
  #
  # @example Set the default homepage
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_preference('homepage', 'http://www.seleniumhq.com/')
  # @param name [String] Key of the preference
  # @param value [Boolean, String, Integer] Value of the preference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#161
  def add_preference(name, value); end

  # Enables mobile browser use on Android.
  #
  # @param package [String] The package name of the Chrome or WebView app.
  # @param serial_number [String] The device serial number on which to launch the Chrome or WebView app.
  # @param use_running_app [String] When true uses an already-running Chrome or WebView app,
  #   instead of launching the app with a clear data directory.
  # @param activity [String] Name of the Activity hosting the WebView (Not available on Chrome Apps).
  # @see https://chromedriver.chromium.org/getting-started/getting-started---android
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#212
  def enable_android(package: T.unsafe(nil), serial_number: T.unsafe(nil), use_running_app: T.unsafe(nil), activity: T.unsafe(nil)); end

  # NOTE: special handling of 'extensions' to validate when set instead of when used
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#47
  def extensions; end

  # Add an extension by local path.
  #
  # @example
  #   extensions = ['/path/to/extension.crx', '/path/to/other.crx']
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.extensions = extensions
  # @param extensions [Array<String>] A list of paths to (.crx) Chrome extensions to install on startup
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#118
  def extensions=(extensions); end

  # Run Chrome in headless mode.
  #
  # @example Enable headless mode
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.headless!
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#173
  def headless!; end

  # Returns the value of attribute logging_prefs.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#24
  def logging_prefs; end

  # Sets the attribute logging_prefs
  #
  # @param value the value to set the attribute logging_prefs to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#24
  def logging_prefs=(_arg0); end

  # Returns the value of attribute profile.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#24
  def profile; end

  # Sets the attribute profile
  #
  # @param value the value to set the attribute profile to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#24
  def profile=(_arg0); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#254
  def binary_path; end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#269
  def camelize?(key); end

  # @raise [Error::InvalidArgumentError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#243
  def check_w3c(w3c); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#221
  def enable_logging(browser_options); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#258
  def encode_extension(path); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#225
  def process_browser_options(browser_options); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#262
  def validate_extension(path); end
end

# source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#27
Selenium::WebDriver::Chrome::Options::BROWSER = T.let(T.unsafe(nil), String)

# see: http://chromedriver.chromium.org/capabilities
#
# source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#30
Selenium::WebDriver::Chrome::Options::CAPABILITIES = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/chrome/options.rb#26
Selenium::WebDriver::Chrome::Options::KEY = T.let(T.unsafe(nil), String)

# @private
class Selenium::WebDriver::Chrome::Profile
  include ::Selenium::WebDriver::ProfileHelper
  extend ::Selenium::WebDriver::ProfileHelper::ClassMethods

  # @return [Profile] a new instance of Profile
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#30
  def initialize(model = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#62
  def [](key); end

  # Set a preference in the profile.
  #
  # See https://src.chromium.org/viewvc/chrome/trunk/src/chrome/common/pref_names.cc
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#57
  def []=(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#43
  def add_encoded_extension(encoded); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#37
  def add_extension(path); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#76
  def as_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#47
  def directory; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#67
  def layout_on_disk; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#97
  def prefs; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#107
  def prefs_file_for(dir); end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#101
  def read_model_prefs; end

  # source://selenium-webdriver//lib/selenium/webdriver/chrome/profile.rb#90
  def write_prefs_to(dir); end
end

class Selenium::WebDriver::Chrome::Service < ::Selenium::WebDriver::Service
  private

  # NOTE: This processing is deprecated
  #
  # source://selenium-webdriver//lib/selenium/webdriver/chrome/service.rb#36
  def extract_service_args(driver_opts); end
end

# source://selenium-webdriver//lib/selenium/webdriver/chrome/service.rb#24
Selenium::WebDriver::Chrome::Service::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/chrome/service.rb#25
Selenium::WebDriver::Chrome::Service::EXECUTABLE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/chrome/service.rb#26
Selenium::WebDriver::Chrome::Service::MISSING_TEXT = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/chrome/service.rb#31
Selenium::WebDriver::Chrome::Service::SHUTDOWN_SUPPORTED = T.let(T.unsafe(nil), TrueClass)

class Selenium::WebDriver::Credential
  # @return [Credential] a new instance of Credential
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#59
  def initialize(id:, resident_credential:, rp_id:, private_key:, user_handle: T.unsafe(nil), sign_count: T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#72
  def as_json(*_arg0); end

  # Returns the value of attribute id.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def id; end

  # Returns the value of attribute private_key.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def private_key; end

  # Returns the value of attribute resident_credential.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def resident_credential; end

  # Returns the value of attribute resident_credential.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def resident_credential?; end

  # Returns the value of attribute rp_id.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def rp_id; end

  # Returns the value of attribute sign_count.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def sign_count; end

  # Returns the value of attribute user_handle.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#56
  def user_handle; end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#41
    def decode(base64); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#37
    def encode(byte_array); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#45
    def from_json(opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#33
    def non_resident(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/credential.rb#29
    def resident(**opts); end
  end
end

class Selenium::WebDriver::DevTools
  # @return [DevTools] a new instance of DevTools
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#31
  def initialize(url:); end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#41
  def callbacks; end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#37
  def close; end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#54
  def method_missing(method, *_args); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#45
  def send_cmd(method, **params); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#81
  def error_message(error); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#67
  def respond_to_missing?(method, *_args); end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools.rb#74
  def start_session; end
end

class Selenium::WebDriver::DevTools::ConsoleEvent
  # @return [ConsoleEvent] a new instance of ConsoleEvent
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#27
  def initialize(type:, timestamp:, args:); end

  # Returns the value of attribute args.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def args; end

  # Sets the attribute args
  #
  # @param value the value to set the attribute args to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def args=(_arg0); end

  # Returns the value of attribute timestamp.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def timestamp; end

  # Sets the attribute timestamp
  #
  # @param value the value to set the attribute timestamp to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def timestamp=(_arg0); end

  # Returns the value of attribute type.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/console_event.rb#25
  def type=(_arg0); end
end

class Selenium::WebDriver::DevTools::ExceptionEvent
  # @return [ExceptionEvent] a new instance of ExceptionEvent
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#27
  def initialize(description:, timestamp:, stacktrace:); end

  # Returns the value of attribute description.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def description; end

  # Sets the attribute description
  #
  # @param value the value to set the attribute description to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def description=(_arg0); end

  # Returns the value of attribute stacktrace.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def stacktrace; end

  # Sets the attribute stacktrace
  #
  # @param value the value to set the attribute stacktrace to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def stacktrace=(_arg0); end

  # Returns the value of attribute timestamp.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def timestamp; end

  # Sets the attribute timestamp
  #
  # @param value the value to set the attribute timestamp to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/exception_event.rb#25
  def timestamp=(_arg0); end
end

class Selenium::WebDriver::DevTools::MutationEvent
  # @return [MutationEvent] a new instance of MutationEvent
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#27
  def initialize(element:, attribute_name:, current_value:, old_value:); end

  # Returns the value of attribute attribute_name.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def attribute_name; end

  # Sets the attribute attribute_name
  #
  # @param value the value to set the attribute attribute_name to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def attribute_name=(_arg0); end

  # Returns the value of attribute current_value.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def current_value; end

  # Sets the attribute current_value
  #
  # @param value the value to set the attribute current_value to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def current_value=(_arg0); end

  # Returns the value of attribute element.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def element; end

  # Sets the attribute element
  #
  # @param value the value to set the attribute element to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def element=(_arg0); end

  # Returns the value of attribute old_value.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def old_value; end

  # Sets the attribute old_value
  #
  # @param value the value to set the attribute old_value to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/mutation_event.rb#25
  def old_value=(_arg0); end
end

# Wraps the network request/response interception, providing
# thread-safety guarantees and handling special cases such as browser
# canceling requests midst interception.
#
# You should not be using this class directly, use Driver#intercept instead.
#
# @api private
class Selenium::WebDriver::DevTools::NetworkInterceptor
  # @api private
  # @return [NetworkInterceptor] a new instance of NetworkInterceptor
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#43
  def initialize(devtools); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#48
  def intercept(&block); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#169
  def cancelled?(network_id); end

  # Ensure usage of cancelled_requests is thread-safe via synchronization!
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#69
  def cancelled_requests; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#129
  def continue_request(id); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#129
  def continue_response(id); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#59
  def devtools; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#59
  def devtools=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#157
  def fetch_response_body(id); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#99
  def intercept_request(id, params, &block); end

  # @api private
  # @yield [mutable]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#114
  def intercept_response(id, params); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#59
  def lock; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#59
  def lock=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#134
  def mutate_request(request); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#146
  def mutate_response(response); end

  # We should be thread-safe to use the hash without synchronization
  # because its keys are interception job identifiers and they should be
  # unique within a devtools session.
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#64
  def pending_response_requests; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#79
  def request_paused(data, &block); end

  # The presence of any of these fields indicate we're at the response stage.
  #
  # @api private
  # @return [Boolean]
  # @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#event-requestPaused
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#95
  def response?(params); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#73
  def track_cancelled_request(data); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#163
  def with_cancellable_request(network_id); end
end

# CDP fails to get body on certain responses (301) and raises:
# "Can only get response body on requests captured after headers received."
#
# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#37
Selenium::WebDriver::DevTools::NetworkInterceptor::CANNOT_GET_BODY_ON_REDIRECT_ERROR_CODE = T.let(T.unsafe(nil), String)

# CDP fails to operate with intercepted requests.
# Typical reason is browser cancelling intercepted requests/responses.
#
# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/devtools/network_interceptor.rb#41
Selenium::WebDriver::DevTools::NetworkInterceptor::INVALID_INTERCEPTION_ID_ERROR_CODE = T.let(T.unsafe(nil), String)

class Selenium::WebDriver::DevTools::PinnedScript
  # @return [PinnedScript] a new instance of PinnedScript
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#27
  def initialize(script); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#36
  def callable; end

  # Returns the value of attribute devtools_identifier.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def devtools_identifier; end

  # Sets the attribute devtools_identifier
  #
  # @param value the value to set the attribute devtools_identifier to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def devtools_identifier=(_arg0); end

  # Returns the value of attribute key.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def key; end

  # Sets the attribute key
  #
  # @param value the value to set the attribute key to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def key=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#52
  def remove; end

  # Returns the value of attribute script.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def script; end

  # Sets the attribute script
  #
  # @param value the value to set the attribute script to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#25
  def script=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/pinned_script.rb#44
  def to_json(*_arg0); end
end

class Selenium::WebDriver::DevTools::Request
  # @return [Request] a new instance of Request
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#43
  def initialize(id:, url:, method:, headers:, post_data:); end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#51
  def ==(other); end

  # Returns the value of attribute headers.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def headers; end

  # Sets the attribute headers
  #
  # @param value the value to set the attribute headers to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def headers=(_arg0); end

  # Returns the value of attribute id.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#26
  def id; end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#60
  def inspect; end

  # Returns the value of attribute method.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def method; end

  # Sets the attribute method
  #
  # @param value the value to set the attribute method to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def method=(_arg0); end

  # Returns the value of attribute post_data.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def post_data; end

  # Sets the attribute post_data
  #
  # @param value the value to set the attribute post_data to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def post_data=(_arg0); end

  # Returns the value of attribute url.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def url; end

  # Sets the attribute url
  #
  # @param value the value to set the attribute url to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#25
  def url=(_arg0); end

  class << self
    # Creates request from DevTools message.
    #
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/devtools/request.rb#33
    def from(id, params); end
  end
end

class Selenium::WebDriver::DevTools::Response
  # @return [Response] a new instance of Response
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#44
  def initialize(id:, code:, body:, headers:); end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#51
  def ==(other); end

  # Returns the value of attribute body.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def body; end

  # Sets the attribute body
  #
  # @param value the value to set the attribute body to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def body=(_arg0); end

  # Returns the value of attribute code.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def code; end

  # Sets the attribute code
  #
  # @param value the value to set the attribute code to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def code=(_arg0); end

  # Returns the value of attribute headers.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def headers; end

  # Sets the attribute headers
  #
  # @param value the value to set the attribute headers to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#25
  def headers=(_arg0); end

  # Returns the value of attribute id.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#26
  def id; end

  # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#59
  def inspect; end

  class << self
    # Creates response from DevTools message.
    #
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/devtools/response.rb#33
    def from(id, encoded_body, params); end
  end
end

class Selenium::WebDriver::Dimension < ::Struct
  # Returns the value of attribute height
  #
  # @return [Object] the current value of height
  def height; end

  # Sets the attribute height
  #
  # @param value [Object] the value to set the attribute height to.
  # @return [Object] the newly set value
  def height=(_); end

  # Returns the value of attribute width
  #
  # @return [Object] the current value of width
  def width; end

  # Sets the attribute width
  #
  # @param value [Object] the value to set the attribute width to.
  # @return [Object] the newly set value
  def width=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# The main class through which you control the browser.
#
# @see SearchContext
# @see Navigation
# @see TargetLocator
# @see Options
class Selenium::WebDriver::Driver
  include ::Selenium::WebDriver::SearchContext
  include ::Selenium::WebDriver::TakesScreenshot

  # A new Driver instance with the given bridge.
  # End users should use Selenium::WebDriver.for instead of using this directly.
  #
  # @api private
  # @return [Driver] a new instance of Driver
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#71
  def initialize(bridge: T.unsafe(nil), listener: T.unsafe(nil), **opts); end

  # Get the first element matching the given selector. If given a
  # String or Symbol, it will be used as the id of the element.
  #
  # Examples:
  #
  #   driver['someElementId']    #=> #<WebDriver::Element:0x1011c3b88>
  #   driver[:tag_name => 'div'] #=> #<WebDriver::Element:0x1011c3b88>
  #
  # @param sel [String, Hash] id or selector
  # @return [WebDriver::Element]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#292
  def [](sel); end

  # @return [ActionBuilder]
  # @see ActionBuilder
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#126
  def action(**opts); end

  # @return [VirtualAuthenticator]
  # @see VirtualAuthenticator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#256
  def add_virtual_authenticator(options); end

  # driver.all(class: 'bar') #=> [#<WebDriver::Element:0x1011c3b88, ...]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#72
  def all(*args); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#298
  def browser; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#302
  def capabilities; end

  # Close the current window, or the browser if no windows are left.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#191
  def close; end

  # Get the URL of the current page
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#152
  def current_url; end

  # Execute an asynchronous piece of JavaScript in the context of the
  # currently selected frame or window. Unlike executing
  # execute_script (synchronous JavaScript), scripts
  # executed with this method must explicitly signal they are finished by
  # invoking the provided callback. This callback is always injected into the
  # executed function as the last argument.
  #
  # @param script [String] JavaScript source to execute
  # @param args [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array] Arguments to the script. May be empty.
  # @return [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#247
  def execute_async_script(script, *args); end

  # Execute the given JavaScript
  #
  # @param script [String] JavaScript source to execute
  # @param args [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array] Arguments will be available in the given script in the 'arguments' pseudo-array.
  # @return [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array] The value returned from the script.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#228
  def execute_script(script, *args); end

  # driver.first(id: 'foo')
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#57
  def first(*args); end

  # Opens the specified URL in the browser.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#142
  def get(url); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#79
  def inspect; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#134
  def keyboard; end

  # @return [Manager]
  # @see Manager
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#117
  def manage; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#130
  def mouse; end

  # @return [Navigation]
  # @see Navigation
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#99
  def navigate; end

  # Get the source of the current page
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#172
  def page_source; end

  # Quit the browser
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#180
  def quit; end

  # @api private
  # @see SearchContext
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#311
  def ref; end

  # Execute the given JavaScript
  #
  # @param script [String] JavaScript source to execute
  # @param args [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array] Arguments will be available in the given script in the 'arguments' pseudo-array.
  # @return [WebDriver::Element, Integer, Float, Boolean, NilClass, String, Array] The value returned from the script.
  #
  #   driver.script('function() { ... };')
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#228
  def script(script, *args); end

  # information about whether a remote end is in a state in which it can create new sessions,
  # and may include additional meta information.
  #
  # @return [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#90
  def status; end

  # @return [TargetLocator]
  # @see TargetLocator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#108
  def switch_to; end

  # Get the title of the current page
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#162
  def title; end

  # Get the current window handle
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#212
  def window_handle; end

  # Get the window handles of open browser windows.
  #
  # @return [Array]
  # @see TargetLocator#window
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#202
  def window_handles; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#349
  def add_extensions(browser); end

  # Returns the value of attribute bridge.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#317
  def bridge; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#319
  def create_bridge(capabilities: T.unsafe(nil), options: T.unsafe(nil), url: T.unsafe(nil), service: T.unsafe(nil), http_client: T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#327
  def generate_capabilities(capabilities); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#345
  def screenshot; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#339
  def service_url(service); end

  class << self
    # @api private
    # @return [Driver]
    # @see Selenium::WebDriver.for
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/driver.rb#44
    def for(browser, opts = T.unsafe(nil)); end
  end
end

# @api private
module Selenium::WebDriver::DriverExtensions; end

module Selenium::WebDriver::DriverExtensions::DownloadsFiles
  # Sets download path for Chromium.
  #
  # @param path [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/downloads_files.rb#31
  def download_path=(path); end
end

module Selenium::WebDriver::DriverExtensions::FullPageScreenshot
  # Save a PNG screenshot of the full page to the given path
  #
  # @api public
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/full_page_screenshot.rb#30
  def save_full_page_screenshot(path); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/full_page_screenshot.rb#36
  def full_screenshot; end
end

module Selenium::WebDriver::DriverExtensions::HasAddons
  # Installs addon.
  #
  # @param path [String] Full path to addon file
  # @param temporary [Boolean]
  # @return [String] identifier of installed addon
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_addons.rb#33
  def install_addon(path, temporary = T.unsafe(nil)); end

  # Uninstalls addon.
  #
  # @param id [String] Identifier of installed addon
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_addons.rb#43
  def uninstall_addon(id); end
end

module Selenium::WebDriver::DriverExtensions::HasApplePermissions
  # Returns permissions.
  #
  # @return [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_apple_permissions.rb#31
  def permissions; end

  # Sets permissions.
  #
  # @example
  #   driver.permissions = {'getUserMedia' => true}
  # @param permissions [Hash<Symbol, Boolean>]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_apple_permissions.rb#44
  def permissions=(permissions); end
end

module Selenium::WebDriver::DriverExtensions::HasAuthentication
  # Registers basic authentication handler which is automatically
  # used whenever browser gets an authentication required response.
  # This currently relies on DevTools so is only supported in
  # Chromium browsers.
  #
  # @example Authenticate any request
  #   driver.register(username: 'admin', password: '123456')
  # @example Authenticate based on URL
  #   driver.register(username: 'admin1', password: '123456', uri: /mysite1\.com/)
  #   driver.register(username: 'admin2', password: '123456', uri: /mysite2\.com/)
  # @param username [String]
  # @param password [String]
  # @param uri [Regexp] to associate the credentials with
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_authentication.rb#43
  def register(username:, password:, uri: T.unsafe(nil)); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_authentication.rb#58
  def auth_handlers; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_authentication.rb#62
  def authenticate(request_id, url); end
end

module Selenium::WebDriver::DriverExtensions::HasBiDi
  # Retrieves WebDriver BiDi connection.
  #
  # @return [BiDi]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_bidi.rb#31
  def bidi; end
end

module Selenium::WebDriver::DriverExtensions::HasCDP
  # Returns network conditions.
  #
  # @return [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_cdp.rb#31
  def execute_cdp(cmd, **params); end
end

module Selenium::WebDriver::DriverExtensions::HasCasting
  # Gets error messages when there is any issue in a Cast session.
  #
  # @return [String] the error message
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#71
  def cast_issue_message; end

  # Sets a specific sink, using its name, as a Cast session receiver target.
  #
  # @param name [String] the sink to use as the target
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#41
  def cast_sink_to_use=(name); end

  # What devices ("sinks") are available to be cast to.
  #
  # @return [Array] list of sinks available for casting with id and name values
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#31
  def cast_sinks; end

  # Starts a tab mirroring session on a specific receiver target.
  #
  # @param name [String] the sink to use as the target
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#61
  def start_cast_desktop_mirroring(name); end

  # Starts a tab mirroring session on a specific receiver target.
  #
  # @param name [String] the sink to use as the target
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#51
  def start_cast_tab_mirroring(name); end

  # Stops the existing Cast session on a specific receiver target.
  #
  # @param name [String] the sink to stop the Cast session
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_casting.rb#81
  def stop_casting(name); end
end

module Selenium::WebDriver::DriverExtensions::HasContext
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_context.rb#37
  def context; end

  # Sets the context that Selenium commands are running in using
  #         a `with` statement. The state of the context on the server is
  #         saved before entering the block, and restored upon exiting it.
  #
  # @param value [String] which context gets set (either 'chrome' or 'content')
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_context.rb#33
  def context=(value); end
end

module Selenium::WebDriver::DriverExtensions::HasDebugger
  # Attaches debugger to session.
  #
  # @example
  #   driver.attach_debugger
  #   driver.execute_script('debugger')
  # @return [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_debugger.rb#35
  def attach_debugger; end
end

module Selenium::WebDriver::DriverExtensions::HasDevTools
  # Retrieves connection to DevTools.
  #
  # @return [DevTools]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_devtools.rb#31
  def devtools; end
end

module Selenium::WebDriver::DriverExtensions::HasLaunching
  # Launches Chromium app specified by id.
  #
  # @param id [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_launching.rb#31
  def launch_app(id); end
end

module Selenium::WebDriver::DriverExtensions::HasLocation
  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_location.rb#25
  def location; end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_location.rb#29
  def location=(*_arg0); end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_location.rb#25
  def set_location; end
end

module Selenium::WebDriver::DriverExtensions::HasLogEvents
  include ::Selenium::WebDriver::Atoms

  # Registers listener to be called whenever browser receives
  # a new Console API message such as console.log() or an unhandled
  # exception.
  #
  # This currently relies on DevTools so is only supported in
  # Chromium browsers.
  #
  # @example Collect console messages
  #   logs = []
  #   driver.on_log_event(:console) do |event|
  #   logs.push(event)
  #   end
  # @example Collect JavaScript exceptions
  #   exceptions = []
  #   driver.on_log_event(:exception) do |event|
  #   exceptions.push(event)
  #   end
  # @example Collect DOM mutations
  #   mutations = []
  #   driver.on_log_event(:mutation) do |event|
  #   mutations.push(event)
  #   end
  # @param kind [Symbol] :console, :exception or :mutation
  # @param block [#call] which is called when event happens
  # @raise [Error::WebDriverError]
  # @yieldparam [DevTools::ConsoleEvent, DevTools::ExceptionEvent, DevTools::MutationEvent]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#59
  def on_log_event(kind, &block); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#76
  def log_console_events; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#90
  def log_exception_events; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#72
  def log_listeners; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#120
  def log_mutation_event(params); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#110
  def log_mutation_events; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#137
  def mutation_listener; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_log_events.rb#26
Selenium::WebDriver::DriverExtensions::HasLogEvents::KINDS = T.let(T.unsafe(nil), Array)

module Selenium::WebDriver::DriverExtensions::HasLogs
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_logs.rb#24
  def logs; end
end

module Selenium::WebDriver::DriverExtensions::HasNetworkConditions
  # Resets Chromium network emulation settings.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_conditions.rb#61
  def delete_network_conditions; end

  # Returns network conditions.
  #
  # @return [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_conditions.rb#31
  def network_conditions; end

  # Sets network conditions
  #
  # @option conditions
  # @option conditions
  # @option conditions
  # @option conditions
  # @option conditions
  # @param conditions [Hash]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_conditions.rb#46
  def network_conditions=(conditions); end
end

module Selenium::WebDriver::DriverExtensions::HasNetworkConnection
  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_connection.rb#25
  def network_connection_type; end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_connection.rb#30
  def network_connection_type=(*_arg0); end
end

module Selenium::WebDriver::DriverExtensions::HasNetworkInterception
  # Intercepts requests coming from browser allowing
  # to either pass them through like proxy or provide
  # a stubbed response instead.
  #
  # @example Log requests and pass through
  #   driver.intercept do |request, &continue|
  #   puts "#{request.method} #{request.url}"
  #   continue.call(request)
  #   end
  # @example Stub requests for images
  #   driver.intercept do |request, &continue|
  #   if request.url.match?(/\.png$/)
  #   request.url = 'https://upload.wikimedia.org/wikipedia/commons/d/d5/Selenium_Logo.png'
  #   end
  #   continue.call(request)
  #   end
  # @example Log responses and pass through
  #   driver.intercept do |request, &continue|
  #   continue.call(request) do |response|
  #   puts "#{response.code} #{response.body}"
  #   end
  #   end
  # @example Mutate specific response
  #   driver.intercept do |request, &continue|
  #   continue.call(request) do |response|
  #   response.body << 'Added by Selenium!' if request.url.include?('/myurl')
  #   end
  #   end
  # @param block [Proc] which is called when request is intercepted
  # @yieldparam request [DevTools::Request]
  # @yieldparam continue [Proc] block which proceeds with the request and optionally yields response
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_network_interception.rb#63
  def intercept(&block); end
end

module Selenium::WebDriver::DriverExtensions::HasPermissions
  # Set one permission.
  #
  # @param name [String] which permission to set
  # @param value [String] what to set the permission to
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_permissions.rb#32
  def add_permission(name, value); end

  # Set multiple permissions.
  #
  # @param opt [Hash] key/value pairs to set permissions
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_permissions.rb#42
  def add_permissions(opt); end
end

module Selenium::WebDriver::DriverExtensions::HasPinnedScripts
  # Pins JavaScript snippet that is available during the whole
  # session on every page. This allows to store and call
  # scripts without sending them over the wire every time.
  #
  # @example
  #   script = driver.pin_script('return window.location.href')
  #   driver.execute_script(script)
  #   # navigate to a new page
  #   driver.execute_script(script)
  # @param script [String]
  # @return [DevTools::PinnedScript]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_pinned_scripts.rb#50
  def pin_script(script); end

  # Returns the list of all pinned scripts.
  #
  # @return [Array<DevTools::PinnedScript>]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_pinned_scripts.rb#31
  def pinned_scripts; end

  # Unpins script making it undefined for the subsequent calls.
  #
  # @param script [DevTools::PinnedScript]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_pinned_scripts.rb#68
  def unpin_script(script); end
end

# @api private
module Selenium::WebDriver::DriverExtensions::HasSessionId
  # @api public
  # @return [String] the session id
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_session_id.rb#33
  def session_id; end
end

# @api private
module Selenium::WebDriver::DriverExtensions::HasWebStorage
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_web_storage.rb#28
  def local_storage; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/has_web_storage.rb#32
  def session_storage; end
end

# @api private
module Selenium::WebDriver::DriverExtensions::PrintsPage
  # Return a Base64 encoded Print Page as a string
  #
  # @api public
  # @see https://w3c.github.io/webdriver/#print-page
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/prints_page.rb#50
  def print_page(**options); end

  # Save a page as a PDF to the given path
  #
  # @api public
  # @example Save Printed Page
  #   driver.save_print_page('../printed_page.pdf')
  # @param path [String] to where the pdf should be saved
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/prints_page.rb#35
  def save_print_page(path, **options); end
end

# @api private
module Selenium::WebDriver::DriverExtensions::UploadsFiles
  # Set the file detector to pass local files to a remote WebDriver.
  #
  # The detector is an object that responds to #call, and when called
  # will determine if the given string represents a file. If it does,
  # the path to the file on the local file system should be returned,
  # otherwise nil or false.
  #
  # Example:
  #
  #     driver = Selenium::WebDriver.for :remote
  #     driver.file_detector = lambda do |args|
  #        # args => ["/path/to/file"]
  #        str = args.first.to_s
  #        str if File.exist?(str)
  #     end
  #
  #     driver.find_element(:id => "upload").send_keys "/path/to/file"
  #
  # By default, no file detection is performed.
  #
  # @api public
  # @raise [ArgumentError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/driver_extensions/uploads_files.rb#52
  def file_detector=(detector); end
end

module Selenium::WebDriver::Edge
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/edge.rb#36
    def path; end

    # source://selenium-webdriver//lib/selenium/webdriver/edge.rb#31
    def path=(path); end
  end
end

# Driver implementation for Microsoft Edge.
#
# @api private
class Selenium::WebDriver::Edge::Driver < ::Selenium::WebDriver::Chrome::Driver
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/edge/driver.rb#32
  def browser; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/edge/driver.rb#38
  def devtools_address; end
end

module Selenium::WebDriver::Edge::Features
  include ::Selenium::WebDriver::Chrome::Features

  # source://selenium-webdriver//lib/selenium/webdriver/edge/features.rb#39
  def commands(command); end
end

# source://selenium-webdriver//lib/selenium/webdriver/edge/features.rb#29
Selenium::WebDriver::Edge::Features::EDGE_COMMANDS = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Edge::Options < ::Selenium::WebDriver::Chrome::Options
  protected

  # source://selenium-webdriver//lib/selenium/webdriver/edge/options.rb#31
  def enable_logging(browser_options); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/edge/options.rb#37
  def binary_path; end
end

# source://selenium-webdriver//lib/selenium/webdriver/edge/options.rb#27
Selenium::WebDriver::Edge::Options::BROWSER = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/edge/options.rb#26
Selenium::WebDriver::Edge::Options::KEY = T.let(T.unsafe(nil), String)

# @private
class Selenium::WebDriver::Edge::Profile < ::Selenium::WebDriver::Chrome::Profile; end

class Selenium::WebDriver::Edge::Service < ::Selenium::WebDriver::Chrome::Service; end

# source://selenium-webdriver//lib/selenium/webdriver/edge/service.rb#26
Selenium::WebDriver::Edge::Service::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/edge/service.rb#27
Selenium::WebDriver::Edge::Service::EXECUTABLE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/edge/service.rb#28
Selenium::WebDriver::Edge::Service::MISSING_TEXT = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/edge/service.rb#32
Selenium::WebDriver::Edge::Service::SHUTDOWN_SUPPORTED = T.let(T.unsafe(nil), TrueClass)

class Selenium::WebDriver::Element
  include ::Selenium::WebDriver::SearchContext
  include ::Selenium::WebDriver::TakesScreenshot

  # Creates a new Element
  #
  # @api private
  # @return [Element] a new instance of Element
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#34
  def initialize(bridge, id); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#43
  def ==(other); end

  # This method attempts to provide the most likely desired current value for the attribute
  # of the element, even when that desired value is actually a JavaScript property.
  # It is implemented with a custom JavaScript atom. To obtain the exact value of the attribute or property,
  # use #dom_attribute or #property methods respectively.
  #
  # More exactly, this method will return the value of the property with the given name,
  # if it exists. If it does not, then the value of the attribute with the given name is returned.
  # If neither exists, null is returned.
  #
  # The "style" attribute is converted as best can be to a text representation with a trailing semicolon.
  #
  # The following are deemed to be "boolean" attributes, and will return either "true" or "false":
  #
  # async, autofocus, autoplay, checked, compact, complete, controls, declare, defaultchecked,
  # defaultselected, defer, disabled, draggable, ended, formnovalidate, hidden, indeterminate,
  # iscontenteditable, ismap, itemscope, loop, multiple, muted, nohref, noresize, noshade, novalidate,
  # nowrap, open, paused, pubdate, readonly, required, reversed, scoped, seamless, seeking,
  # selected, spellcheck, truespeed, willvalidate
  #
  # Finally, the following commonly mis-capitalized attribute/property names are evaluated as expected:
  #
  # When the value of "class" is requested, the "className" property is returned.
  # When the value of "readonly" is requested, the "readOnly" property is returned.
  #
  # @param name [String] attribute name
  # @return [String, nil] attribute value
  # @see #dom_attribute
  # @see #property element['class'] or element[:class] #=> "someclass"
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#126
  def [](name); end

  # Gets the computed WAI-ARIA label of element.
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#179
  def accessible_name; end

  # element.all(class: 'bar')
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#72
  def all(*args); end

  # Gets the computed WAI-ARIA role of element
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#169
  def aria_role; end

  # For Rails 3 - http://jonathanjulian.com/2010/04/rails-to_json-or-as_json/
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#375
  def as_json(*_arg0); end

  # This method attempts to provide the most likely desired current value for the attribute
  # of the element, even when that desired value is actually a JavaScript property.
  # It is implemented with a custom JavaScript atom. To obtain the exact value of the attribute or property,
  # use #dom_attribute or #property methods respectively.
  #
  # More exactly, this method will return the value of the property with the given name,
  # if it exists. If it does not, then the value of the attribute with the given name is returned.
  # If neither exists, null is returned.
  #
  # The "style" attribute is converted as best can be to a text representation with a trailing semicolon.
  #
  # The following are deemed to be "boolean" attributes, and will return either "true" or "false":
  #
  # async, autofocus, autoplay, checked, compact, complete, controls, declare, defaultchecked,
  # defaultselected, defer, disabled, draggable, ended, formnovalidate, hidden, indeterminate,
  # iscontenteditable, ismap, itemscope, loop, multiple, muted, nohref, noresize, noshade, novalidate,
  # nowrap, open, paused, pubdate, readonly, required, reversed, scoped, seamless, seeking,
  # selected, spellcheck, truespeed, willvalidate
  #
  # Finally, the following commonly mis-capitalized attribute/property names are evaluated as expected:
  #
  # When the value of "class" is requested, the "className" property is returned.
  # When the value of "readonly" is requested, the "readOnly" property is returned.
  #
  # @param name [String] attribute name
  # @return [String, nil] attribute value
  # @see #dom_attribute
  # @see #property
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#126
  def attribute(name); end

  # If this element is a text entry element, this will clear the value. Has no effect on other
  # elements. Text entry elements are INPUT and TEXTAREA elements.
  #
  # Note that the events fired by this event may not be as you'd expect.  In particular, we don't
  # fire any keyboard or mouse events.  If you want to ensure keyboard events are
  # fired, consider using #send_keys with the backspace key. To ensure you get a change event,
  # consider following with a call to #send_keys with the tab key.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#222
  def clear; end

  # Click this element. If this causes a new page to load, this method will
  # attempt to block until the page has loaded.  At this point, you should
  # discard all references to this element and any further operations
  # performed on this element will raise a StaleElementReferenceError
  # unless you know that the element and the page will still be present. If
  # click() causes a new page to be loaded via an event or is done by
  # sending a native event then the method will *not* wait for it to be
  # loaded and the caller should verify that a new page has been loaded.
  #
  # There are some preconditions for an element to be clicked.  The element
  # must be visible and it must have a height and width greater then 0.
  #
  # Equivalent to:
  #   driver.action.click(element)
  #
  # @example Click on a button
  #
  #   driver.find_element(tag_name: "button").click
  # @raise [StaleElementReferenceError] if the element no longer exists as
  #   defined
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#76
  def click; end

  # Get the value of the given CSS property
  #
  # Note that shorthand CSS properties (e.g. background, font, border, border-top, margin,
  # margin-top, padding, padding-top, list-style, outline, pause, cue) are not returned,
  # in accordance with the DOM CSS2 specification - you should directly access the longhand
  # properties (e.g. background-color) to access the desired values.
  #
  # @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#275
  def css_value(prop); end

  # Is the element displayed?
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#252
  def displayed?; end

  # Gets the value of a declared HTML attribute of this element.
  #
  # As opposed to the #attribute method, this method
  # only returns attributes declared in the element's HTML markup.
  #
  # If the attribute is not set, nil is returned.
  #
  # @param name [String] attribute name
  # @return [String, nil] attribute value
  # @see #attribute
  # @see #property
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#145
  def dom_attribute(name); end

  # Is the element enabled?
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#232
  def enabled?; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#43
  def eql?(other); end

  # element.first(id: 'foo')
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#57
  def first(*args); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#48
  def hash; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#39
  def inspect; end

  # Get the location of this element.
  #
  # @return [WebDriver::Point]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#286
  def location; end

  # Determine an element's location on the screen once it has been scrolled into view.
  #
  # @return [WebDriver::Point]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#306
  def location_once_scrolled_into_view; end

  # Gets the value of a JavaScript property of this element
  # This will return the current value,
  # even if this has been modified after the page has been loaded.
  # If the value is not set, nil is returned.
  #
  # @param name [String] property name
  # @return [String, nil] property value
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#159
  def property(name); end

  # Get the dimensions and coordinates of this element.
  #
  # @return [WebDriver::Rectangle]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#296
  def rect; end

  # @api private
  # @see SearchContext
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#354
  def ref; end

  # Is the element selected?
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#242
  def selected?; end

  # Send keystrokes to this element
  #
  # Examples:
  #
  #     element.send_keys "foo"                     #=> value: 'foo'
  #     element.send_keys "tet", :arrow_left, "s"   #=> value: 'test'
  #     element.send_keys [:control, 'a'], :space   #=> value: ' '
  #
  # @param args [String, Symbol, Array] keystrokes to send
  # @see Keys::KEYS
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#207
  def send_key(*args); end

  # Send keystrokes to this element
  #
  # Examples:
  #
  #     element.send_keys "foo"                     #=> value: 'foo'
  #     element.send_keys "tet", :arrow_left, "s"   #=> value: 'test'
  #     element.send_keys [:control, 'a'], :space   #=> value: ' '
  #
  # @param args [String, Symbol, Array] keystrokes to send
  # @see Keys::KEYS
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#207
  def send_keys(*args); end

  # Returns the shadow root of an element.
  #
  # @return [WebDriver::ShadowRoot]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#326
  def shadow_root; end

  # Get the size of this element
  #
  # @return [WebDriver::Dimension]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#316
  def size; end

  # Get the value of the given CSS property
  #
  # Note that shorthand CSS properties (e.g. background, font, border, border-top, margin,
  # margin-top, padding, padding-top, list-style, outline, pause, cue) are not returned,
  # in accordance with the DOM CSS2 specification - you should directly access the longhand
  # properties (e.g. background-color) to access the desired values.
  #
  # @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSStyleDeclaration
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#275
  def style(prop); end

  # Submit this element
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#260
  def submit; end

  # Get the tag name of the element.
  #
  # @example Get the tagname of an INPUT element(returns "input")
  #
  #   driver.find_element(xpath: "//input").tag_name
  # @return [String] The tag name of this element.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#90
  def tag_name; end

  # Get the text content of this element
  #
  # @return [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#189
  def text; end

  # Convert to a WebElement JSON Object for transmission over the wire.
  #
  # @api private
  # @see https://github.com/SeleniumHQ/selenium/wiki/JsonWireProtocol#basic-terms-and-concepts
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#365
  def to_json(*_arg0); end

  private

  # Returns the value of attribute bridge.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#381
  def bridge; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#390
  def screenshot; end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#383
  def selectable?; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/element.rb#23
Selenium::WebDriver::Element::ELEMENT_KEY = T.let(T.unsafe(nil), String)

module Selenium::WebDriver::Error
  class << self
    # Returns exception from its string representation.
    #
    # @param error [String, nil]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/error.rb#29
    def for_error(error); end
  end
end

# A command failed because the referenced shadow root is no longer attached to the DOM.
class Selenium::WebDriver::Error::DetachedShadowRootError < ::Selenium::WebDriver::Error::WebDriverError; end

# The Element Click command could not be completed because the element receiving the events
# is obscuring the element that was requested clicked.
class Selenium::WebDriver::Error::ElementClickInterceptedError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command could not be completed because the element is not pointer or keyboard
# interactable.
class Selenium::WebDriver::Error::ElementNotInteractableError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command could not be completed because TLS certificate is expired
# or invalid.
class Selenium::WebDriver::Error::InsecureCertificateError < ::Selenium::WebDriver::Error::WebDriverError; end

# The arguments passed to a command are either invalid or malformed.
class Selenium::WebDriver::Error::InvalidArgumentError < ::Selenium::WebDriver::Error::WebDriverError; end

# An illegal attempt was made to set a cookie under a different domain than the current page.
class Selenium::WebDriver::Error::InvalidCookieDomainError < ::Selenium::WebDriver::Error::WebDriverError; end

# The target element is in an invalid state, rendering it impossible to interact with, for
# example if you click a disabled element.
class Selenium::WebDriver::Error::InvalidElementStateError < ::Selenium::WebDriver::Error::WebDriverError; end

# Argument was an invalid selector.
class Selenium::WebDriver::Error::InvalidSelectorError < ::Selenium::WebDriver::Error::WebDriverError; end

# Occurs if the given session id is not in the list of active sessions, meaning the session
# either does not exist or that it's not active.
class Selenium::WebDriver::Error::InvalidSessionIdError < ::Selenium::WebDriver::Error::WebDriverError; end

# An error occurred while executing JavaScript supplied by the user.
class Selenium::WebDriver::Error::JavascriptError < ::Selenium::WebDriver::Error::WebDriverError; end

# The target for mouse interaction is not in the browser's viewport and cannot be brought
# into that viewport.
class Selenium::WebDriver::Error::MoveTargetOutOfBoundsError < ::Selenium::WebDriver::Error::WebDriverError; end

# An attempt was made to operate on a modal dialog when one was not open:
class Selenium::WebDriver::Error::NoSuchAlertError < ::Selenium::WebDriver::Error::WebDriverError; end

# No cookie matching the given path name was found amongst the associated cookies of the
# current browsing context's active document.
class Selenium::WebDriver::Error::NoSuchCookieError < ::Selenium::WebDriver::Error::WebDriverError; end

# An element could not be located on the page using the given search parameters.
class Selenium::WebDriver::Error::NoSuchElementError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command to switch to a frame could not be satisfied because the frame could not be found.
class Selenium::WebDriver::Error::NoSuchFrameError < ::Selenium::WebDriver::Error::WebDriverError; end

# The element does not have a shadow root.
class Selenium::WebDriver::Error::NoSuchShadowRootError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command to switch to a window could not be satisfied because
# the window could not be found.
class Selenium::WebDriver::Error::NoSuchWindowError < ::Selenium::WebDriver::Error::WebDriverError; end

# A script did not complete before its timeout expired.
class Selenium::WebDriver::Error::ScriptTimeoutError < ::Selenium::WebDriver::Error::WebDriverError; end

class Selenium::WebDriver::Error::ServerError < ::StandardError
  # @return [ServerError] a new instance of ServerError
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/server_error.rb#24
  def initialize(response); end
end

# A new session could not be created.
class Selenium::WebDriver::Error::SessionNotCreatedError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command failed because the referenced element is no longer attached to the DOM.
class Selenium::WebDriver::Error::StaleElementReferenceError < ::Selenium::WebDriver::Error::WebDriverError; end

# An operation did not complete before its timeout expired.
class Selenium::WebDriver::Error::TimeoutError < ::Selenium::WebDriver::Error::WebDriverError; end

# A screen capture was made impossible.
class Selenium::WebDriver::Error::UnableToCaptureScreenError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command to set a cookie's value could not be satisfied.
class Selenium::WebDriver::Error::UnableToSetCookieError < ::Selenium::WebDriver::Error::WebDriverError; end

# A modal dialog was open, blocking this operation.
class Selenium::WebDriver::Error::UnexpectedAlertOpenError < ::Selenium::WebDriver::Error::WebDriverError; end

# A command could not be executed because the remote end is not aware of it.
class Selenium::WebDriver::Error::UnknownCommandError < ::Selenium::WebDriver::Error::WebDriverError; end

# An unknown error occurred in the remote end while processing the command.
class Selenium::WebDriver::Error::UnknownError < ::Selenium::WebDriver::Error::WebDriverError; end

# The requested command matched a known URL but did not match an method for that URL.
class Selenium::WebDriver::Error::UnknownMethodError < ::Selenium::WebDriver::Error::WebDriverError; end

# Indicates that a command that should have executed properly cannot be supported for some
# reason.
class Selenium::WebDriver::Error::UnsupportedOperationError < ::Selenium::WebDriver::Error::WebDriverError; end

class Selenium::WebDriver::Error::WebDriverError < ::StandardError; end

# @api private
module Selenium::WebDriver::FileReaper
  class << self
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#39
    def <<(file); end

    # @api private
    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#43
    def reap(file); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#51
    def reap!; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#28
    def reap=(_arg0); end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#30
    def reap?; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/file_reaper.rb#34
    def tmp_files; end
  end
end

module Selenium::WebDriver::Firefox
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#50
    def path; end

    # source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#45
    def path=(path); end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#38
Selenium::WebDriver::Firefox::DEFAULT_ASSUME_UNTRUSTED_ISSUER = T.let(T.unsafe(nil), TrueClass)

# source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#39
Selenium::WebDriver::Firefox::DEFAULT_LOAD_NO_FOCUS_LIB = T.let(T.unsafe(nil), FalseClass)

# source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#36
Selenium::WebDriver::Firefox::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#37
Selenium::WebDriver::Firefox::DEFAULT_SECURE_SSL = T.let(T.unsafe(nil), FalseClass)

# Mozilla Automation Team asked to only support 85
# until WebDriver Bidi is available.
#
# source://selenium-webdriver//lib/selenium/webdriver/firefox.rb#43
Selenium::WebDriver::Firefox::DEVTOOLS_VERSION = T.let(T.unsafe(nil), Integer)

# Driver implementation for Firefox using GeckoDriver.
#
# @api private
class Selenium::WebDriver::Firefox::Driver < ::Selenium::WebDriver::Driver
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/driver.rb#40
  def browser; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/driver.rb#46
  def devtools_url; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/driver.rb#57
  def devtools_version; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/firefox/driver.rb#30
Selenium::WebDriver::Firefox::Driver::EXTENSIONS = T.let(T.unsafe(nil), Array)

# @api private
class Selenium::WebDriver::Firefox::Extension
  # @api private
  # @raise [Error::WebDriverError]
  # @return [Extension] a new instance of Extension
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#30
  def initialize(path); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#37
  def write_to(extensions_dir); end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#93
  def applications_gecko_id(manifest); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#50
  def create_root; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#97
  def name_and_version(manifest); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#63
  def read_id(directory); end

  # @api private
  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#67
  def read_id_from_install_rdf(directory); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#85
  def read_id_from_manifest_json(directory); end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/firefox/extension.rb#28
Selenium::WebDriver::Firefox::Extension::NAMESPACE = T.let(T.unsafe(nil), String)

module Selenium::WebDriver::Firefox::Features
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#33
  def commands(command); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#61
  def context; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#57
  def context=(context); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#53
  def full_screenshot; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#37
  def install_addon(path, temporary); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#49
  def uninstall_addon(id); end
end

# source://selenium-webdriver//lib/selenium/webdriver/firefox/features.rb#25
Selenium::WebDriver::Firefox::Features::FIREFOX_COMMANDS = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Firefox::Options < ::Selenium::WebDriver::Options
  # Create a new Options instance, only for W3C-capable versions of Firefox.
  #
  # @example
  #   options = Selenium::WebDriver::Firefox::Options.new(args: ['--host=127.0.0.1'])
  #   driver = Selenium::WebDriver.for :firefox, capabilities: options
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] the pre-defined options to create the Firefox::Options with
  # @return [Options] a new instance of Options
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#59
  def initialize(log_level: T.unsafe(nil), **opts); end

  # Add a command-line argument to use when starting Firefox.
  #
  # @example Start geckodriver on a specific host
  #   options = Selenium::WebDriver::Firefox::Options.new
  #   options.add_argument('--host=127.0.0.1')
  # @param arg [String] The command-line argument to add
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#83
  def add_argument(arg); end

  # Add a preference that is only applied to the user profile in use.
  #
  # @example Set the default homepage
  #   options = Selenium::WebDriver::Firefox::Options.new
  #   options.add_preference('browser.startup.homepage', 'http://www.seleniumhq.com/')
  # @param name [String] Key of the preference
  # @param value [Boolean, String, Integer] Value of the preference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#98
  def add_preference(name, value); end

  # Returns the value of attribute debugger_address.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#24
  def debugger_address; end

  # Sets the attribute debugger_address
  #
  # @param value the value to set the attribute debugger_address to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#24
  def debugger_address=(_arg0); end

  # Enables mobile browser use on Android.
  #
  # @param package [String] The package name of the Chrome or WebView app.
  # @param serial_number [String] The serial number of the device on which to launch the application.
  #   If not specified and multiple devices are attached, an error will be returned.
  # @param activity [String] The fully qualified class name of the activity to be launched.
  # @param intent_arguments [Array] Arguments to launch the intent with.
  # @see https://developer.mozilla.org/en-US/docs/Web/WebDriver/Capabilities/firefoxOptions#android
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#153
  def enable_android(package: T.unsafe(nil), serial_number: T.unsafe(nil), activity: T.unsafe(nil), intent_arguments: T.unsafe(nil)); end

  # Run Firefox in headless mode.
  #
  # @example Enable headless mode
  #   options = Selenium::WebDriver::Firefox::Options.new
  #   options.headless!
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#110
  def headless!; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#133
  def log_level; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#137
  def log_level=(level); end

  # NOTE: special handling of 'profile' to validate when set instead of when used
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#41
  def profile; end

  # Sets Firefox profile.
  #
  # @example Set the custom profile
  #   profile = Selenium::WebDriver::Firefox::Profile.new
  #   options = Selenium::WebDriver::Firefox::Options.new
  #   options.profile = profile
  # @example Use existing profile
  #   options = Selenium::WebDriver::Firefox::Options.new
  #   options.profile = 'myprofile'
  # @param profile [Profile, String] Profile to be used
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#129
  def profile=(profile); end

  private

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#180
  def camelize?(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#162
  def process_browser_options(browser_options); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#169
  def process_profile(profile); end
end

# source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#38
Selenium::WebDriver::Firefox::Options::BROWSER = T.let(T.unsafe(nil), String)

# see: https://developer.mozilla.org/en-US/docs/Web/WebDriver/Capabilities/firefoxOptions
#
# source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#29
Selenium::WebDriver::Firefox::Options::CAPABILITIES = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/firefox/options.rb#26
Selenium::WebDriver::Firefox::Options::KEY = T.let(T.unsafe(nil), String)

class Selenium::WebDriver::Firefox::Profile
  include ::Selenium::WebDriver::ProfileHelper
  extend ::Selenium::WebDriver::ProfileHelper::ClassMethods

  # Create a new Profile instance
  #
  # @example User configured profile
  #
  #   profile = Selenium::WebDriver::Firefox::Profile.new
  #   profile['network.proxy.http'] = 'localhost'
  #   profile['network.proxy.http_port'] = 9090
  #
  #   driver = Selenium::WebDriver.for :firefox, :profile => profile
  # @return [Profile] a new instance of Profile
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#68
  def initialize(model = T.unsafe(nil)); end

  # Set a preference for this particular profile.
  #
  # @see http://kb.mozillazine.org/About:config_entries
  # @see http://preferential.mozdev.org/preferences.html
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#94
  def []=(key, value); end

  # Add the extension (directory, .zip or .xpi) at the given path to the profile.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#119
  def add_extension(path, name = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#38
  def as_json; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#75
  def layout_on_disk; end

  # Sets the attribute load_no_focus_lib
  #
  # @param value the value to set the attribute load_no_focus_lib to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#37
  def load_no_focus_lib=(_arg0); end

  # Returns the value of attribute log_file.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#36
  def log_file; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#110
  def log_file=(file); end

  # Returns the value of attribute name.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#36
  def name; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#106
  def port=(port); end

  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#123
  def proxy=(proxy); end

  # Sets the attribute secure_ssl
  #
  # @param value the value to set the attribute secure_ssl to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#37
  def secure_ssl=(_arg0); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#174
  def delete_extensions_cache(directory); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#178
  def delete_lock_files(directory); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#184
  def extension_name_for(path); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#159
  def install_extensions(directory); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#168
  def read_model_prefs; end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#200
  def read_user_prefs(path); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#150
  def set_manual_proxy_preference(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#188
  def update_user_prefs_in(directory); end

  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#217
  def write_prefs(prefs, path); end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#51
    def decoded(json); end

    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#44
    def from_name(name); end

    # source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#40
    def ini; end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#28
Selenium::WebDriver::Firefox::Profile::DEFAULT_PREFERENCES = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/firefox/profile.rb#26
Selenium::WebDriver::Firefox::Profile::VALID_PREFERENCE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
class Selenium::WebDriver::Firefox::ProfilesIni
  # @api private
  # @return [ProfilesIni] a new instance of ProfilesIni
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profiles_ini.rb#25
  def initialize; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profiles_ini.rb#32
  def [](name); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profiles_ini.rb#37
  def refresh; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profiles_ini.rb#44
  def parse; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/profiles_ini.rb#66
  def path_for(name, is_relative, path); end
end

class Selenium::WebDriver::Firefox::Service < ::Selenium::WebDriver::Service
  private

  # NOTE: This processing is deprecated
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/service.rb#36
  def extract_service_args(driver_opts); end
end

# source://selenium-webdriver//lib/selenium/webdriver/firefox/service.rb#24
Selenium::WebDriver::Firefox::Service::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/firefox/service.rb#25
Selenium::WebDriver::Firefox::Service::EXECUTABLE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/firefox/service.rb#26
Selenium::WebDriver::Firefox::Service::MISSING_TEXT = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/firefox/service.rb#31
Selenium::WebDriver::Firefox::Service::SHUTDOWN_SUPPORTED = T.let(T.unsafe(nil), FalseClass)

# @api private
module Selenium::WebDriver::Firefox::Util
  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/util.rb#27
  def app_data_path; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/firefox/util.rb#40
  def stringified?(str); end

  class << self
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/firefox/util.rb#27
    def app_data_path; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/firefox/util.rb#40
    def stringified?(str); end
  end
end

module Selenium::WebDriver::HTML5; end

class Selenium::WebDriver::HTML5::LocalStorage
  include ::Enumerable
  include ::Selenium::WebDriver::HTML5::SharedWebStorage

  # @api private
  # @return [LocalStorage] a new instance of LocalStorage
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#29
  def initialize(bridge); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#33
  def [](key); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#37
  def []=(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#45
  def clear; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#41
  def delete(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#53
  def keys; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/local_storage.rb#49
  def size; end
end

class Selenium::WebDriver::HTML5::SessionStorage
  include ::Enumerable
  include ::Selenium::WebDriver::HTML5::SharedWebStorage

  # @api private
  # @return [SessionStorage] a new instance of SessionStorage
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#55
  def initialize(bridge); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#27
  def [](key); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#31
  def []=(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#39
  def clear; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#35
  def delete(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#47
  def keys; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/session_storage.rb#43
  def size; end
end

module Selenium::WebDriver::HTML5::SharedWebStorage
  include ::Enumerable

  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#43
  def each; end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#39
  def empty?; end

  # @raise [KeyError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#32
  def fetch(key); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#26
  def has_key?(key); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#26
  def key?(key); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/html5/shared_web_storage.rb#26
  def member?(key); end
end

module Selenium::WebDriver::IE; end

# Driver implementation for Internet Explorer supporting
# both OSS and W3C dialects of JSON wire protocol.
#
# @api private
class Selenium::WebDriver::IE::Driver < ::Selenium::WebDriver::Driver
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/ie/driver.rb#33
  def browser; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/ie/driver.rb#31
Selenium::WebDriver::IE::Driver::EXTENSIONS = T.let(T.unsafe(nil), Array)

class Selenium::WebDriver::IE::Options < ::Selenium::WebDriver::Options
  # Create a new Options instance
  #
  # @example
  #   options = Selenium::WebDriver::IE::Options.new(args: ['--host=127.0.0.1'])
  #   driver = Selenium::WebDriver.for(:ie, capabilities: options)
  # @example
  #   options = Selenium::WebDriver::IE::Options.new
  #   options.element_scroll_behavior = Selenium::WebDriver::IE::Options::SCROLL_BOTTOM
  #   driver = Selenium::WebDriver.for(:ie, capabilities: options)
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] the pre-defined options
  # @return [Options] a new instance of Options
  #
  # source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#81
  def initialize(**opts); end

  # Add a command-line argument to use when starting Internet Explorer.
  #
  # @param arg [String] The command-line argument to add
  #
  # source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#94
  def add_argument(arg); end

  # Returns the value of attribute args.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#48
  def args; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#100
  def process_browser_options(browser_options); end
end

# source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#46
Selenium::WebDriver::IE::Options::BROWSER = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#27
Selenium::WebDriver::IE::Options::CAPABILITIES = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#24
Selenium::WebDriver::IE::Options::KEY = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#26
Selenium::WebDriver::IE::Options::SCROLL_BOTTOM = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/ie/options.rb#25
Selenium::WebDriver::IE::Options::SCROLL_TOP = T.let(T.unsafe(nil), Integer)

class Selenium::WebDriver::IE::Service < ::Selenium::WebDriver::Service
  private

  # NOTE: This processing is deprecated
  #
  # source://selenium-webdriver//lib/selenium/webdriver/ie/service.rb#36
  def extract_service_args(driver_opts); end
end

# source://selenium-webdriver//lib/selenium/webdriver/ie/service.rb#24
Selenium::WebDriver::IE::Service::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/ie/service.rb#25
Selenium::WebDriver::IE::Service::EXECUTABLE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/ie/service.rb#26
Selenium::WebDriver::IE::Service::MISSING_TEXT = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/ie/service.rb#31
Selenium::WebDriver::IE::Service::SHUTDOWN_SUPPORTED = T.let(T.unsafe(nil), TrueClass)

module Selenium::WebDriver::Interactions
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#33
    def key(name = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#41
    def mouse(name: T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#53
    def none(name = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#45
    def pen(name: T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#37
    def pointer(kind = T.unsafe(nil), name: T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#49
    def touch(name: T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#57
    def wheel(name = T.unsafe(nil)); end
  end
end

# Superclass for the input device sources
# Manages Array of Interaction instances for the device
#
# @api private
class Selenium::WebDriver::Interactions::InputDevice
  # @api private
  # @return [InputDevice] a new instance of InputDevice
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#35
  def initialize(name = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#33
  def actions; end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#40
  def add_action(action); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#46
  def clear_actions; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#50
  def create_pause(duration = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#54
  def encode; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#33
  def name; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/input_device.rb#33
  def type; end
end

# Superclass for classes defining actions
# Do not initialize directly, only use subclass
#
# @api private
class Selenium::WebDriver::Interactions::Interaction
  # @api private
  # @return [Interaction] a new instance of Interaction
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interaction.rb#33
  def initialize(source); end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interaction.rb#37
  def assert_source(_source); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interaction.rb#31
  def type; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#23
Selenium::WebDriver::Interactions::KEY = T.let(T.unsafe(nil), Symbol)

# Creates actions specific to Key Input devices
#
# @api private
class Selenium::WebDriver::Interactions::KeyInput < ::Selenium::WebDriver::Interactions::InputDevice
  # @api private
  # @return [KeyInput] a new instance of KeyInput
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_input.rb#32
  def initialize(name = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_input.rb#37
  def create_key_down(key); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_input.rb#41
  def create_key_up(key); end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_input.rb#30
Selenium::WebDriver::Interactions::KeyInput::SUBTYPES = T.let(T.unsafe(nil), Hash)

# Backward compatibility in case anyone called this directly
#
# @api private
class Selenium::WebDriver::Interactions::KeyInput::TypingInteraction < ::Selenium::WebDriver::Interactions::TypingInteraction; end

# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#25
Selenium::WebDriver::Interactions::NONE = T.let(T.unsafe(nil), Symbol)

# Creates actions specific to null input source
# This is primarily used for adding pauses
#
# @api private
class Selenium::WebDriver::Interactions::NoneInput < ::Selenium::WebDriver::Interactions::InputDevice
  # @api private
  # @return [NoneInput] a new instance of NoneInput
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/none_input.rb#31
  def initialize(name = T.unsafe(nil)); end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#24
Selenium::WebDriver::Interactions::POINTER = T.let(T.unsafe(nil), Symbol)

# Action to create a waiting period between actions
# Also used for synchronizing actions across devices
#
# @api private
class Selenium::WebDriver::Interactions::Pause < ::Selenium::WebDriver::Interactions::Interaction
  # @api private
  # @return [Pause] a new instance of Pause
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pause.rb#31
  def initialize(source, duration = T.unsafe(nil)); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pause.rb#37
  def assert_source(source); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pause.rb#41
  def encode; end
end

# Action to cancel any other Pointer Action.
#
# @api private
class Selenium::WebDriver::Interactions::PointerCancel < ::Selenium::WebDriver::Interactions::Interaction
  # @api private
  # @return [PointerCancel] a new instance of PointerCancel
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_cancel.rb#30
  def initialize(source); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_cancel.rb#35
  def assert_source(source); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_cancel.rb#39
  def encode; end
end

module Selenium::WebDriver::Interactions::PointerEventProperties
  # @raise [ArgumentError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_event_properties.rb#34
  def process_opts; end

  private

  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_event_properties.rb#48
  def assert_number(num, min, max = T.unsafe(nil)); end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_event_properties.rb#24
Selenium::WebDriver::Interactions::PointerEventProperties::VALID = T.let(T.unsafe(nil), Hash)

# Creates actions specific to Pointer Input devices
#
# @api private
class Selenium::WebDriver::Interactions::PointerInput < ::Selenium::WebDriver::Interactions::InputDevice
  # @api private
  # @return [PointerInput] a new instance of PointerInput
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#34
  def initialize(kind, name: T.unsafe(nil)); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#46
  def assert_kind(pointer); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#64
  def create_pointer_cancel; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#56
  def create_pointer_down(button, **opts); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#52
  def create_pointer_move(duration: T.unsafe(nil), x: T.unsafe(nil), y: T.unsafe(nil), origin: T.unsafe(nil), **opts); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#60
  def create_pointer_up(button, **opts); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#40
  def encode; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#32
  def kind; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_input.rb#30
Selenium::WebDriver::Interactions::PointerInput::KIND = T.let(T.unsafe(nil), Hash)

# Action related to moving the pointer.
#
# @api private
class Selenium::WebDriver::Interactions::PointerMove < ::Selenium::WebDriver::Interactions::Interaction
  include ::Selenium::WebDriver::Interactions::PointerEventProperties

  # @api private
  # @return [PointerMove] a new instance of PointerMove
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#36
  def initialize(source, duration, x, y, element: T.unsafe(nil), origin: T.unsafe(nil), **opts); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#46
  def assert_source(source); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#50
  def encode; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#34
Selenium::WebDriver::Interactions::PointerMove::ORIGINS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#33
Selenium::WebDriver::Interactions::PointerMove::POINTER = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_move.rb#32
Selenium::WebDriver::Interactions::PointerMove::VIEWPORT = T.let(T.unsafe(nil), Symbol)

# Actions related to clicking, tapping or pressing the pointer.
#
# @api private
class Selenium::WebDriver::Interactions::PointerPress < ::Selenium::WebDriver::Interactions::Interaction
  include ::Selenium::WebDriver::Interactions::PointerEventProperties

  # @api private
  # @return [PointerPress] a new instance of PointerPress
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#44
  def initialize(source, direction, button, **opts); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#52
  def encode; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#62
  def assert_button(button); end

  # @api private
  # @raise [ArgumentError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#77
  def assert_direction(direction); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#58
  def assert_source(source); end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#32
Selenium::WebDriver::Interactions::PointerPress::BUTTONS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_press.rb#42
Selenium::WebDriver::Interactions::PointerPress::DIRECTIONS = T.let(T.unsafe(nil), Hash)

# Action related to scrolling a wheel.
#
# @api private
class Selenium::WebDriver::Interactions::Scroll < ::Selenium::WebDriver::Interactions::Interaction
  # @api private
  # @return [Scroll] a new instance of Scroll
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll.rb#30
  def initialize(source:, x: T.unsafe(nil), y: T.unsafe(nil), delta_x: T.unsafe(nil), delta_y: T.unsafe(nil), origin: T.unsafe(nil), duration: T.unsafe(nil)); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll.rb#41
  def assert_source(source); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll.rb#45
  def encode; end
end

# Actions related to pressing keys.
#
# @api private
class Selenium::WebDriver::Interactions::TypingInteraction < ::Selenium::WebDriver::Interactions::Interaction
  # @api private
  # @return [TypingInteraction] a new instance of TypingInteraction
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/typing_interaction.rb#32
  def initialize(source, type, key); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/typing_interaction.rb#38
  def assert_source(source); end

  # @api private
  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/typing_interaction.rb#42
  def assert_type(type); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/typing_interaction.rb#48
  def encode; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/typing_interaction.rb#30
  def type; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/interactions/interactions.rb#26
Selenium::WebDriver::Interactions::WHEEL = T.let(T.unsafe(nil), Symbol)

# Creates actions specific to Pointer Input devices
#
# @api private
class Selenium::WebDriver::Interactions::WheelInput < ::Selenium::WebDriver::Interactions::InputDevice
  # @api private
  # @return [WheelInput] a new instance of WheelInput
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_input.rb#30
  def initialize(name = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_input.rb#35
  def create_scroll(**opts); end
end

module Selenium::WebDriver::KeyActions
  # Performs a key press. Does not release the key - subsequent interactions may assume it's kept pressed.
  # Note that the key is never released implicitly - either ActionBuilder#key_up(key) or ActionBuilder#release_actions
  # must be called to release the key.
  #
  # @example Press a key
  #
  #   driver.action.key_down(:control).perform
  # @example Press a key on an element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.key_down(el, :shift).perform
  # @overload key_down
  # @overload key_down
  # @return [ActionBuilder] A self reference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_actions.rb#47
  def key_down(*args, device: T.unsafe(nil)); end

  # Performs a key release.
  # Releasing a non-depressed key will yield undefined behaviour.
  #
  # @example Release a key
  #
  #   driver.action.key_up(:shift).perform
  # @example Release a key from an element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.key_up(el, :alt).perform
  # @overload key_up
  # @overload key_up
  # @return [ActionBuilder] A self reference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_actions.rb#74
  def key_up(*args, device: T.unsafe(nil)); end

  # Sends keys to the active element. This differs from calling
  # Element#send_keys(keys) on the active element in two ways:
  #
  # * The modifier keys included in this call are not released.
  # * There is no attempt to re-focus the element - so send_keys(:tab) for switching elements should work.
  #
  # @example Send the text "help" to an element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.send_keys(el, "help").perform
  # @example Send the text "help" to the currently focused element
  #
  #   driver.action.send_keys("help").perform
  # @overload send_keys
  # @overload send_keys
  # @return [ActionBuilder] A self reference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_actions.rb#104
  def send_keys(*args, device: T.unsafe(nil)); end

  private

  # @api private
  # @option args
  # @option args
  # @overload key_down
  # @overload key_down
  # @param args [Array]
  # @param action [Symbol] The name of the key action to perform
  # @param device [Symbol, String] optional name of the KeyInput device to press the key on
  # @return [ActionBuilder] A self reference
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_actions.rb#136
  def key_action(*args, action: T.unsafe(nil), device: T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/key_actions.rb#144
  def key_input(name = T.unsafe(nil)); end
end

module Selenium::WebDriver::Keys
  class << self
    # @api private
    # @raise [Error::UnsupportedOperationError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/keys.rb#114
    def [](key); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/keys.rb#124
    def encode(keys); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/keys.rb#132
    def encode_key(key); end
  end
end

# @see Element#send_keys
# @see http://www.google.com.au/search?&q=unicode+pua&btnK=Search
#
# source://selenium-webdriver//lib/selenium/webdriver/common/keys.rb#28
Selenium::WebDriver::Keys::KEYS = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Location < ::Struct
  # Returns the value of attribute altitude
  #
  # @return [Object] the current value of altitude
  def altitude; end

  # Sets the attribute altitude
  #
  # @param value [Object] the value to set the attribute altitude to.
  # @return [Object] the newly set value
  def altitude=(_); end

  # Returns the value of attribute latitude
  #
  # @return [Object] the current value of latitude
  def latitude; end

  # Sets the attribute latitude
  #
  # @param value [Object] the value to set the attribute latitude to.
  # @return [Object] the newly set value
  def latitude=(_); end

  # Returns the value of attribute longitude
  #
  # @return [Object] the current value of longitude
  def longitude; end

  # Sets the attribute longitude
  #
  # @param value [Object] the value to set the attribute longitude to.
  # @return [Object] the newly set value
  def longitude=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Selenium::WebDriver::LogEntry
  # @return [LogEntry] a new instance of LogEntry
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#25
  def initialize(level, timestamp, message); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#31
  def as_json(*_arg0); end

  # Returns the value of attribute level.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#23
  def level; end

  # Returns the value of attribute message.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#23
  def message; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#43
  def time; end

  # Returns the value of attribute timestamp.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#23
  def timestamp; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/log_entry.rb#39
  def to_s; end
end

# @example Enable full logging
#   Selenium::WebDriver.logger.level = :debug
# @example Log to file
#   Selenium::WebDriver.logger.output = 'selenium.log'
# @example Use logger manually
#   Selenium::WebDriver.logger.info('This is info message')
#   Selenium::WebDriver.logger.warn('This is warning message')
class Selenium::WebDriver::Logger
  extend ::Forwardable

  # @param progname [String] Allow child projects to use Selenium's Logger pattern
  # @return [Logger] a new instance of Logger
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#51
  def initialize(progname = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def close(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def debug(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def debug?(*args, **_arg1, &block); end

  # Marks code as deprecated with/without replacement.
  #
  # @param old [String]
  # @param new [String, nil]
  # @param id [Symbol, Array<Symbol>]
  # @param reference [String]
  # @yield appends additional message to end of provided template
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#115
  def deprecate(old, new = T.unsafe(nil), id: T.unsafe(nil), reference: T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def error(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def error?(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def fatal(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def fatal?(*args, **_arg1, &block); end

  # Will not log the provided ID.
  #
  # @param id [Array, Symbol]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#85
  def ignore(id); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def info(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def info?(*args, **_arg1, &block); end

  # Returns IO object used by logger internally.
  #
  # Normally, we would have never needed it, but we want to
  # use it as IO object for all child processes to ensure their
  # output is redirected there.
  #
  # It is only used in debug level, in other cases output is suppressed.
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#76
  def io; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def level(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def level=(*args, **_arg1, &block); end

  # Changes logger output to a new IO.
  #
  # @param io [String]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#61
  def output=(io); end

  # Overrides default #warn to skip ignored messages by provided id
  #
  # @param message [String]
  # @param id [Symbol, Array<Sybmol>]
  # @yield see #deprecate
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#96
  def warn(message, id: T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def warn?(*args, **_arg1, &block); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#134
  def create_logger(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/logger.rb#145
  def default_level; end
end

class Selenium::WebDriver::Logs
  # @api private
  # @return [Logs] a new instance of Logs
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/logs.rb#27
  def initialize(bridge); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/logs.rb#35
  def available_types; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/logs.rb#31
  def get(type); end
end

class Selenium::WebDriver::Manager
  # @api private
  # @return [Manager] a new instance of Manager
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#27
  def initialize(bridge); end

  # Add a cookie to the browser
  #
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] the options to create a cookie with.
  # @raise [ArgumentError] if :name or :value is not specified
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#45
  def add_cookie(opts = T.unsafe(nil)); end

  # Get all cookies
  #
  # @return [Array<Hash>] list of cookies
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#99
  def all_cookies; end

  # Get the cookie with the given name
  #
  # @param name [String] the name of the cookie
  # @return [Hash, nil] the cookie, or nil if it wasn't found.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#71
  def cookie_named(name); end

  # Delete all cookies
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#89
  def delete_all_cookies; end

  # Delete the cookie with the given name
  #
  # @param name [String] the name of the cookie to delete
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#81
  def delete_cookie(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#103
  def timeouts; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#107
  def window; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#136
  def convert_cookie(cookie); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#115
  def datetime_at(int); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#119
  def seconds_from(obj); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#132
  def strip_port(str); end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/manager.rb#113
Selenium::WebDriver::Manager::SECONDS_PER_DAY = T.let(T.unsafe(nil), Float)

class Selenium::WebDriver::Navigation
  # @return [Navigation] a new instance of Navigation
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/navigation.rb#23
  def initialize(bridge); end

  # Move back a single entry in the browser's history.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/navigation.rb#39
  def back; end

  # Move forward a single entry in the browser's history.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/navigation.rb#47
  def forward; end

  # Refresh the current page.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/navigation.rb#55
  def refresh; end

  # Navigate to the given URL
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/navigation.rb#31
  def to(url); end
end

class Selenium::WebDriver::Options
  # @return [Options] a new instance of Options
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#69
  def initialize(**opts); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#92
  def ==(other); end

  # Add a new option not yet handled by bindings.
  #
  # @example Leave Chrome open when chromedriver is killed
  #   options = Selenium::WebDriver::Chrome::Options.new
  #   options.add_option(:detach, true)
  # @param name [String, Symbol] Name of the option
  # @param value [Boolean, String, Integer] Value of the option
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#87
  def add_option(name, value = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#104
  def as_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#92
  def eql?(other); end

  # Returns the value of attribute options.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#67
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#67
  def options=(_arg0); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#172
  def camel_case(str); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#136
  def camelize?(_key); end

  # @raise [TypeError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#164
  def convert_json_key(key, camelize: T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#140
  def generate_as_json(value, camelize_keys: T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#132
  def process_browser_options(_browser_options); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#154
  def process_json_hash(value, camelize_keys); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#125
  def process_w3c_options(options); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#121
  def w3c?(key); end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#30
    def chrome(**opts); end

    # Returns the value of attribute driver_path.
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#28
    def driver_path; end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#43
    def edge(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#34
    def firefox(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#38
    def ie(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#38
    def internet_explorer(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#43
    def microsoftedge(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#48
    def safari(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#52
    def set_capabilities; end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/options.rb#23
Selenium::WebDriver::Options::W3C_OPTIONS = T.let(T.unsafe(nil), Array)

# @api private
module Selenium::WebDriver::Platform
  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#147
  def assert_executable(path); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#141
  def assert_file(path); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#65
  def bitsize; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#53
  def ci; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#110
  def cygwin?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#122
  def cygwin_path(path, **opts); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#33
  def engine; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#155
  def exit_hook; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#161
  def find_binary(*binary_names); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#181
  def find_in_program_files(*binary_names); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#29
  def home; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#222
  def interfaces; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#206
  def ip; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#77
  def jruby?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#97
  def linux?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#198
  def localhost; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#93
  def mac?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#137
  def make_writable(file); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#114
  def null_device; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#37
  def os; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#85
  def ruby_version; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#81
  def truffleruby?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#129
  def unix_path(path); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#89
  def windows?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#133
  def windows_path(path); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#118
  def wrap_in_quotes_if_necessary(str); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#101
  def wsl?; end

  class << self
    # @api private
    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#147
    def assert_executable(path); end

    # @api private
    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#141
    def assert_file(path); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#65
    def bitsize; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#53
    def ci; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#110
    def cygwin?; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#122
    def cygwin_path(path, **opts); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#33
    def engine; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#155
    def exit_hook; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#161
    def find_binary(*binary_names); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#181
    def find_in_program_files(*binary_names); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#29
    def home; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#222
    def interfaces; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#206
    def ip; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#77
    def jruby?; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#97
    def linux?; end

    # @api private
    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#198
    def localhost; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#93
    def mac?; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#137
    def make_writable(file); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#114
    def null_device; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#37
    def os; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#85
    def ruby_version; end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#81
    def truffleruby?; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#129
    def unix_path(path); end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#89
    def windows?; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#133
    def windows_path(path); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#118
    def wrap_in_quotes_if_necessary(str); end

    # @api private
    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/platform.rb#101
    def wsl?; end
  end
end

class Selenium::WebDriver::Point < ::Struct
  # Returns the value of attribute x
  #
  # @return [Object] the current value of x
  def x; end

  # Sets the attribute x
  #
  # @param value [Object] the value to set the attribute x to.
  # @return [Object] the newly set value
  def x=(_); end

  # Returns the value of attribute y
  #
  # @return [Object] the current value of y
  def y; end

  # Sets the attribute y
  #
  # @param value [Object] the value to set the attribute y to.
  # @return [Object] the newly set value
  def y=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

module Selenium::WebDriver::PointerActions
  # Clicks in the middle of the given element. Equivalent to:
  #
  #   driver.action.move_to(element).click
  #
  # When no element is passed, the current mouse position will be clicked.
  #
  # @example Clicking on an element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.click(el).perform
  # @example Clicking at the current mouse position
  #
  #   driver.action.click.perform
  # @param element [Selenium::WebDriver::Element] An optional element to click.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will be clicked
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#227
  def click(element = T.unsafe(nil), button: T.unsafe(nil), device: T.unsafe(nil)); end

  # Clicks (without releasing) in the middle of the given element. This is
  # equivalent to:
  #
  #   driver.action.move_to(element).click_and_hold
  #
  # @example Clicking and holding on some element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.click_and_hold(el).perform
  # @param element [Selenium::WebDriver::Element] the element to move to and click.
  # @param device [Symbol || String] optional name of the PointerInput device to click with
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#181
  def click_and_hold(element = T.unsafe(nil), button: T.unsafe(nil), device: T.unsafe(nil)); end

  # Performs a context-click at middle of the given element. First performs
  # a move_to to the location of the element.
  #
  # When no element is passed, the current mouse position will be context-clicked.
  #
  # @example Context-click at middle of given element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.context_click(el).perform
  # @example Context-clicking at the current mouse position
  #
  #   driver.action.context_click.perform
  # @param element [Selenium::WebDriver::Element] An element to context click.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will be context-clicked
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#284
  def context_click(element = T.unsafe(nil), device: T.unsafe(nil)); end

  # By default this is set to 250ms in the ActionBuilder constructor
  # It can be overridden with default_move_duration=
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#30
  def default_move_duration; end

  # Sets the attribute default_move_duration
  #
  # @param value the value to set the attribute default_move_duration to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#23
  def default_move_duration=(_arg0); end

  # Performs a double-click at middle of the given element. Equivalent to:
  #
  #   driver.action.move_to(element).double_click
  #
  # When no element is passed, the current mouse position will be double-clicked.
  #
  # @example Double-click an element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.double_click(el).perform
  # @example Double-clicking at the current mouse position
  #
  #   driver.action.double_click.perform
  # @param element [Selenium::WebDriver::Element] An optional element to move to.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will be double-clicked
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#256
  def double_click(element = T.unsafe(nil), device: T.unsafe(nil)); end

  # A convenience method that performs click-and-hold at the location of the
  # source element, moves to the location of the target element, then
  # releases the mouse.
  #
  # @example Drag and drop one element onto another
  #
  #   el1 = driver.find_element(id: "some_id1")
  #   el2 = driver.find_element(id: "some_id2")
  #   driver.action.drag_and_drop(el1, el2).perform
  # @param source [Selenium::WebDriver::Element] element to emulate button down at.
  # @param target [Selenium::WebDriver::Element] element to move to and release the
  #   mouse at.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will perform the drag and drop
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#307
  def drag_and_drop(source, target, device: T.unsafe(nil)); end

  # A convenience method that performs click-and-hold at the location of
  # the source element, moves by a given offset, then releases the mouse.
  #
  # @example Drag and drop an element by offset
  #
  #   el = driver.find_element(id: "some_id1")
  #   driver.action.drag_and_drop_by(el, 100, 100).perform
  # @param source [Selenium::WebDriver::Element] Element to emulate button down at.
  # @param right_by [Integer] horizontal move offset.
  # @param down_by [Integer] vertical move offset.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will perform the drag and drop
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#331
  def drag_and_drop_by(source, right_by, down_by, device: T.unsafe(nil)); end

  # Moves the pointer from its current position by the given offset.
  #
  # The viewport is not scrolled if the coordinates provided are outside the viewport.
  # MoveTargetOutOfBoundsError will be raised if the offsets are outside the viewport
  #
  # @example Move the pointer to a certain offset from its current position
  #
  #   driver.action.move_by(100, 100).perform
  # @param right_by [Integer] horizontal offset. A negative value means moving the pointer left.
  # @param down_by [Integer] vertical offset. A negative value means moving the pointer up.
  # @param device [Symbol || String] optional name of the PointerInput device to move
  # @raise [MoveTargetOutOfBoundsError] if the provided offset is outside the document's boundaries.
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#126
  def move_by(right_by, down_by, device: T.unsafe(nil), duration: T.unsafe(nil), **opts); end

  # Moves the pointer to the in-view center point of the given element.
  # Then the pointer is moved to optional offset coordinates.
  #
  # The element is not scrolled into view.
  # MoveTargetOutOfBoundsError will be raised if element with offset is outside the viewport
  #
  # When using offsets, both coordinates need to be passed.
  #
  # @example Move the pointer to element
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.move_to(el).perform
  # @example
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.move_to(el, 100, 100).perform
  # @param element [Selenium::WebDriver::Element] to move to.
  # @param right_by [Integer] Optional offset from the in-view center of the
  #   element. A negative value means coordinates to the left of the center.
  # @param down_by [Integer] Optional offset from the in-view center of the
  #   element. A negative value means coordinates to the top of the center.
  # @param device [Symbol || String] optional name of the PointerInput device to move.
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#98
  def move_to(element, right_by = T.unsafe(nil), down_by = T.unsafe(nil), device: T.unsafe(nil), duration: T.unsafe(nil), **opts); end

  # Moves the pointer to a given location in the viewport.
  #
  # The viewport is not scrolled if the coordinates provided are outside the viewport.
  # MoveTargetOutOfBoundsError will be raised if the offsets are outside the viewport
  #
  # @example Move the pointer to a certain position in the viewport
  #
  #   driver.action.move_to_location(100, 100).perform
  # @param x [Integer] horizontal position. Equivalent to a css 'left' value.
  # @param y [Integer] vertical position. Equivalent to a css 'top' value.
  # @param device [Symbol || String] optional name of the PointerInput device to move
  # @raise [MoveTargetOutOfBoundsError] if the provided x or y value is outside the document's boundaries.
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#154
  def move_to_location(x, y, device: T.unsafe(nil), duration: T.unsafe(nil), **opts); end

  # Presses (without releasing) at the current location of the PointerInput device. This is equivalent to:
  #
  #   driver.action.click_and_hold(nil)
  #
  # @example Clicking and holding at the current location
  #
  #   driver.action.pointer_down(:left).perform
  # @param button [Selenium::WebDriver::Interactions::PointerPress::BUTTONS] the button to press.
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will be pressed
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#49
  def pointer_down(button = T.unsafe(nil), device: T.unsafe(nil), **opts); end

  # Releases the pressed mouse button at the current mouse location of the PointerInput device.
  #
  # @example Releasing a button after clicking and holding
  #
  #   driver.action.pointer_down(:left).pointer_up(:left).perform
  # @param button [Selenium::WebDriver::Interactions::PointerPress::BUTTONS] the button to release.
  # @param device [Symbol || String] optional name of the PointerInput device with the button that will
  #   be released
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#66
  def pointer_up(button = T.unsafe(nil), device: T.unsafe(nil), **opts); end

  # Releases the depressed left mouse button at the current mouse location.
  #
  # @example Releasing an element after clicking and holding it
  #
  #   el = driver.find_element(id: "some_id")
  #   driver.action.click_and_hold(el).release.perform
  # @param device [Symbol || String] optional name of the PointerInput device with the button
  #   that will be released
  # @return [ActionBuilder] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#200
  def release(button: T.unsafe(nil), device: T.unsafe(nil)); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#340
  def button_action(button, action, device: T.unsafe(nil), **opts); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/pointer_actions.rb#347
  def pointer_input(name = T.unsafe(nil)); end
end

class Selenium::WebDriver::PortProber
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/port_prober.rb#23
    def above(port); end

    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/port_prober.rb#33
    def free?(port); end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/port_prober.rb#28
Selenium::WebDriver::PortProber::IGNORED_ERRORS = T.let(T.unsafe(nil), Array)

# Common methods for Chrome::Profile and Firefox::Profile
# Includers must implement #layout_on_disk
#
# @api private
module Selenium::WebDriver::ProfileHelper
  mixes_in_class_methods ::Selenium::WebDriver::ProfileHelper::ClassMethods

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#42
  def as_json(*_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#38
  def encoded; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#46
  def to_json(*_arg0); end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#52
  def create_tmp_copy(directory); end

  # @api private
  # @raise [Errno::ENOENT]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#63
  def verify_model(model); end

  class << self
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#34
    def decoded(json); end

    # @api private
    # @private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#30
    def included(base); end
  end
end

# @api private
module Selenium::WebDriver::ProfileHelper::ClassMethods
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/profile_helper.rb#73
  def from_json(json); end
end

class Selenium::WebDriver::Proxy
  # @raise [ArgumentError]
  # @return [Proxy] a new instance of Proxy
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#58
  def initialize(opts = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#74
  def ==(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#142
  def as_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def auto_detect; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#104
  def auto_detect=(bool); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#74
  def eql?(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def ftp; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#79
  def ftp=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def http; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#84
  def http=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def no_proxy; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#89
  def no_proxy=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def pac; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#99
  def pac=(url); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def socks; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#109
  def socks=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def socks_password; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#119
  def socks_password=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def socks_username; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#114
  def socks_username=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def socks_version; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#124
  def socks_version=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def ssl; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#94
  def ssl=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#160
  def to_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#43
  def type; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#129
  def type=(type); end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#45
    def json_create(data); end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#31
Selenium::WebDriver::Proxy::ALLOWED = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/common/proxy.rb#23
Selenium::WebDriver::Proxy::TYPES = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Rectangle < ::Struct
  # Returns the value of attribute height
  #
  # @return [Object] the current value of height
  def height; end

  # Sets the attribute height
  #
  # @param value [Object] the value to set the attribute height to.
  # @return [Object] the newly set value
  def height=(_); end

  # Returns the value of attribute width
  #
  # @return [Object] the current value of width
  def width; end

  # Sets the attribute width
  #
  # @param value [Object] the value to set the attribute width to.
  # @return [Object] the newly set value
  def width=(_); end

  # Returns the value of attribute x
  #
  # @return [Object] the current value of x
  def x; end

  # Sets the attribute x
  #
  # @param value [Object] the value to set the attribute x to.
  # @return [Object] the newly set value
  def x=(_); end

  # Returns the value of attribute y
  #
  # @return [Object] the current value of y
  def y; end

  # Sets the attribute y
  #
  # @param value [Object] the value to set the attribute y to.
  # @return [Object] the newly set value
  def y=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

module Selenium::WebDriver::Remote; end

# https://w3c.github.io/webdriver/#endpoints
#
# @api private
class Selenium::WebDriver::Remote::Bridge
  include ::Selenium::WebDriver::Atoms

  # Initializes the bridge with the given server URL
  #
  # @api private
  # @param url [String, URI] url for the remote server
  # @param http_client [Object] an HTTP client instance that implements the same protocol as Http::Default
  # @return [Bridge] a new instance of Bridge
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#38
  def initialize(url:, http_client: T.unsafe(nil)); end

  # alerts
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#112
  def accept_alert; end

  # actions
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#370
  def action(deprecated_async = T.unsafe(nil), async: T.unsafe(nil), devices: T.unsafe(nil), duration: T.unsafe(nil)); end

  # actions
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#370
  def actions(deprecated_async = T.unsafe(nil), async: T.unsafe(nil), devices: T.unsafe(nil), duration: T.unsafe(nil)); end

  # finding elements
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#524
  def active_element; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#346
  def add_cookie(cookie); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#584
  def add_credential(credential, id); end

  # virtual-authenticator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#575
  def add_virtual_authenticator(options); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#120
  def alert=(keys); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#124
  def alert_text; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#81
  def browser; end

  # Returns the value of attribute capabilities.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#29
  def capabilities; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#423
  def clear_element(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#292
  def clear_local_storage; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#316
  def clear_session_storage; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#395
  def click_element(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#191
  def close; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#354
  def cookie(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#358
  def cookies; end

  # Creates session.
  #
  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#51
  def create_session(capabilities); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#588
  def credentials(authenticator_id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#362
  def delete_all_cookies; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#350
  def delete_cookie(name); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#116
  def dismiss_alert; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#468
  def element_aria_label(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#464
  def element_aria_role(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#451
  def element_attribute(element, name); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#511
  def element_displayed?(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#456
  def element_dom_attribute(element, name); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#503
  def element_enabled?(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#480
  def element_location(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#492
  def element_location_once_scrolled_into_view(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#460
  def element_property(element, name); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#486
  def element_rect(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#268
  def element_screenshot(element); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#507
  def element_selected?(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#497
  def element_size(element); end

  # element properties
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#447
  def element_tag_name(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#476
  def element_text(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#472
  def element_value(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#516
  def element_value_of_css_property(element, prop); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#333
  def execute_async_script(script, *args); end

  # javascript execution
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#328
  def execute_script(script, *args); end

  # Returns the value of attribute file_detector.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#28
  def file_detector; end

  # Sets the attribute file_detector
  #
  # @param value the value to set the attribute file_detector to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#28
  def file_detector=(_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#530
  def find_element_by(how, what, parent_ref = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#548
  def find_elements_by(how, what, parent_ref = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#240
  def full_screen_window; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#92
  def get(url); end

  # navigation
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#132
  def go_back; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#136
  def go_forward; end

  # Returns the value of attribute http.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#28
  def http; end

  # Sets the attribute http
  #
  # @param value the value to set the attribute http to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#28
  def http=(_arg0); end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#379
  def keyboard; end

  # HTML 5
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#276
  def local_storage_item(key, value = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#288
  def local_storage_keys; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#296
  def local_storage_size; end

  # cookies
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#342
  def manage; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#231
  def maximize_window(handle = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#227
  def minimize_window; end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#375
  def mouse; end

  # Create a new top-level browsing context
  # https://w3c.github.io/webdriver/#new-window
  #
  # @param type [String] Supports two values: 'tab' and 'window'.
  #   Use 'tab' if you'd like the new window to share an OS-level window
  #   with the current browsing context.
  #   Use 'window' otherwise
  # @return [Hash] Containing 'handle' with the value of the window handle
  #   and 'type' with the value of the created window type
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#162
  def new_window(type); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#148
  def page_source; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#391
  def print_page(options = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#185
  def quit; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#195
  def refresh; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#387
  def release_actions; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#596
  def remove_all_credentials(authenticator_id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#592
  def remove_credential(credential_id, authenticator_id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#284
  def remove_local_storage_item(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#308
  def remove_session_storage_item(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#580
  def remove_virtual_authenticator(id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#244
  def reposition_window(x, y); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#211
  def resize_window(width, height, handle = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#264
  def screenshot; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#383
  def send_actions(data); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#399
  def send_keys_to_element(element, keys); end

  # Returns the current session ID.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#77
  def session_id; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#300
  def session_storage_item(key, value = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#312
  def session_storage_keys; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#320
  def session_storage_size; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#253
  def set_window_rect(x: T.unsafe(nil), y: T.unsafe(nil), width: T.unsafe(nil), height: T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#566
  def shadow_root(element); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#88
  def status; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#427
  def submit_element(element); end

  # finding elements
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#524
  def switch_to_active_element; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#179
  def switch_to_default_content; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#170
  def switch_to_frame(id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#175
  def switch_to_parent_frame; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#166
  def switch_to_window(name); end

  # timeouts
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#100
  def timeouts; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#104
  def timeouts=(timeouts); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#144
  def title; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#414
  def upload(local_file); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#140
  def url; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#600
  def user_verified(verified, authenticator_id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#207
  def window_handle; end

  # window handling
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#203
  def window_handles; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#248
  def window_position; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#259
  def window_rect; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#217
  def window_size(handle = T.unsafe(nil)); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#632
  def commands(command); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#666
  def convert_locator(how, what); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#653
  def element_id_from(id); end

  # Escapes invalid characters in CSS selector.
  #
  # @see https://mathiasbynens.be/notes/css-escapes
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#696
  def escape_css(string); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#628
  def escaper; end

  # executes a command on the remote server.
  #
  # @return [WebDriver::Remote::Response]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#612
  def execute(command, opts = T.unsafe(nil), command_hash = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#661
  def prepare_capabilities_payload(capabilities); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#657
  def shadow_root_id_from(id); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#636
  def unwrap_script_result(arg); end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/remote/commands.rb#30
Selenium::WebDriver::Remote::Bridge::COMMANDS = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#691
Selenium::WebDriver::Remote::Bridge::ESCAPE_CSS_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#26
Selenium::WebDriver::Remote::Bridge::PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#183
Selenium::WebDriver::Remote::Bridge::QUIT_ERRORS = T.let(T.unsafe(nil), Array)

# source://selenium-webdriver//lib/selenium/webdriver/remote/bridge.rb#692
Selenium::WebDriver::Remote::Bridge::UNICODE_CODE_POINT = T.let(T.unsafe(nil), Integer)

# Specification of the desired and/or actual capabilities of the browser that the
# server is being asked to create.
class Selenium::WebDriver::Remote::Capabilities
  # @api public
  # @option :browser_name
  # @option :browser_version
  # @option :platform_name
  # @option :accept_insecure_certs
  # @option :proxy
  # @param opts [Hash]
  # @param :browser_name [Hash] a customizable set of options
  # @param :browser_version [Hash] a customizable set of options
  # @param :platform_name [Hash] a customizable set of options
  # @param :accept_insecure_certs [Hash] a customizable set of options
  # @param :proxy [Hash] a customizable set of options
  # @return [Capabilities] a new instance of Capabilities
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#177
  def initialize(opts = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#266
  def ==(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#191
  def [](key); end

  # Allows setting arbitrary capabilities.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#187
  def []=(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def accept_insecure_certs; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def accept_insecure_certs=(value); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#256
  def as_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def browser_name; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def browser_name=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def browser_version; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def browser_version=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#266
  def eql?(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#228
  def implicit_timeout; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#232
  def implicit_timeout=(timeout); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#195
  def merge!(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def page_load_strategy; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def page_load_strategy=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#236
  def page_load_timeout; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#240
  def page_load_timeout=(timeout); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def platform; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def platform=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def platform_name; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def platform_name=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#205
  def proxy; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#209
  def proxy=(proxy); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def remote_session_id; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def remote_session_id=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#244
  def script_timeout; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#248
  def script_timeout=(timeout); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def set_window_rect; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def set_window_rect=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def strict_file_interactability; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def strict_file_interactability=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#220
  def timeouts; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#224
  def timeouts=(timeouts); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#262
  def to_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def unhandled_prompt_behavior; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def unhandled_prompt_behavior=(value); end

  # Backward compatibility
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def version; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def version=(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#49
  def web_socket_url; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#53
  def web_socket_url=(value); end

  protected

  # Returns the value of attribute capabilities.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#276
  def capabilities; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#295
  def convert_key(key); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#306
  def convert_value(key, value); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#280
  def process_capabilities(key, value, hash); end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#112
    def always_match(capabilities); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#151
    def camel_case(str_or_sym); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#72
    def chrome(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#78
    def edge(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#85
    def ff(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#85
    def firefox(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#116
    def first_match(*capabilities); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#98
    def htmlunit(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#104
    def ie(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#104
    def internet_explorer(opts = T.unsafe(nil)); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#124
    def json_create(data); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#78
    def microsoftedge(opts = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#92
    def safari(opts = T.unsafe(nil)); end

    private

    # source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#157
    def process_timeouts(caps, timeouts); end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/remote/capabilities.rb#31
Selenium::WebDriver::Remote::Capabilities::KNOWN = T.let(T.unsafe(nil), Array)

# Driver implementation for remote server.
#
# @api private
class Selenium::WebDriver::Remote::Driver < ::Selenium::WebDriver::Driver
  include ::Selenium::WebDriver::DriverExtensions::UploadsFiles
  include ::Selenium::WebDriver::DriverExtensions::HasSessionId

  # @api private
  # @return [Driver] a new instance of Driver
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/driver.rb#33
  def initialize(bridge: T.unsafe(nil), listener: T.unsafe(nil), **opts); end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/driver.rb#49
  def devtools_url; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/driver.rb#53
  def devtools_version; end
end

module Selenium::WebDriver::Remote::Http; end

class Selenium::WebDriver::Remote::Http::Common
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#43
  def call(verb, url, command_hash); end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#39
  def close; end

  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#35
  def quit_errors; end

  # Sets the attribute server_url
  #
  # @param value the value to set the attribute server_url to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#33
  def server_url=(_arg0); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#74
  def create_response(code, body, content_type); end

  # @raise [NotImplementedError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#70
  def request(*_arg0); end

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#64
  def server_url; end
end

# source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#26
Selenium::WebDriver::Remote::Http::Common::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#27
Selenium::WebDriver::Remote::Http::Common::DEFAULT_HEADERS = T.let(T.unsafe(nil), Hash)

# same as chromium/gecko
#
# source://selenium-webdriver//lib/selenium/webdriver/remote/http/common.rb#25
Selenium::WebDriver::Remote::Http::Common::MAX_REDIRECTS = T.let(T.unsafe(nil), Integer)

# @api private
class Selenium::WebDriver::Remote::Http::Default < ::Selenium::WebDriver::Remote::Http::Common
  # Initializes object.
  # Warning: Setting {#open_timeout} to non-nil values will cause a separate thread to spawn.
  # Debuggers that freeze the process will not be able to evaluate any operations if that happens.
  #
  # @api private
  # @param open_timeout [Numeric] - Open timeout to apply to HTTP client.
  # @param read_timeout [Numeric] - Read timeout (seconds) to apply to HTTP client.
  # @return [Default] a new instance of Default
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#38
  def initialize(open_timeout: T.unsafe(nil), read_timeout: T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#44
  def close; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#31
  def open_timeout; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#31
  def open_timeout=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#29
  def proxy=(_arg0); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#31
  def read_timeout; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#31
  def read_timeout=(_arg0); end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#50
  def http; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#121
  def new_http_client; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#107
  def new_request_for(verb, url, headers, payload); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#137
  def proxy; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#72
  def request(verb, url, headers, payload, redirects = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#117
  def response_for(request); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#66
  def start(http); end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#149
  def use_proxy?; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/remote/http/default.rb#70
Selenium::WebDriver::Remote::Http::Default::MAX_RETRIES = T.let(T.unsafe(nil), Integer)

# @api private
class Selenium::WebDriver::Remote::Response
  # @api private
  # @return [Response] a new instance of Response
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#31
  def initialize(code, payload = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#49
  def [](key); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#29
  def code; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#38
  def error; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#29
  def payload; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#63
  def add_backtrace(ex, server_trace); end

  # @api private
  # @raise [Error::ServerError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#55
  def assert_ok; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#76
  def backtrace_from_remote(server_trace); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/remote/response.rb#93
  def process_error; end
end

module Selenium::WebDriver::Safari
  class << self
    # @raise [Error::WebDriverError]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#49
    def path; end

    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#44
    def path=(path); end

    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#31
    def technology_preview; end

    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#35
    def technology_preview!; end

    # @return [Boolean]
    #
    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#40
    def technology_preview?; end

    # Returns the value of attribute use_technology_preview.
    #
    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#29
    def use_technology_preview; end

    # Sets the attribute use_technology_preview
    #
    # @param value the value to set the attribute use_technology_preview to.
    #
    # source://selenium-webdriver//lib/selenium/webdriver/safari.rb#29
    def use_technology_preview=(_arg0); end
  end
end

# Driver implementation for Safari.
#
# @api private
class Selenium::WebDriver::Safari::Driver < ::Selenium::WebDriver::Driver
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/safari/driver.rb#34
  def browser; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/safari/driver.rb#30
Selenium::WebDriver::Safari::Driver::EXTENSIONS = T.let(T.unsafe(nil), Array)

module Selenium::WebDriver::Safari::Features
  # source://selenium-webdriver//lib/selenium/webdriver/safari/features.rb#44
  def attach_debugger; end

  # source://selenium-webdriver//lib/selenium/webdriver/safari/features.rb#32
  def commands(command); end

  # source://selenium-webdriver//lib/selenium/webdriver/safari/features.rb#36
  def permissions; end

  # source://selenium-webdriver//lib/selenium/webdriver/safari/features.rb#40
  def permissions=(permissions); end
end

# https://developer.apple.com/library/content/documentation/NetworkingInternetWeb/Conceptual/WebDriverEndpointDoc/Commands/Commands.html
#
# source://selenium-webdriver//lib/selenium/webdriver/safari/features.rb#26
Selenium::WebDriver::Safari::Features::SAFARI_COMMANDS = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Safari::Options < ::Selenium::WebDriver::Options
  # @raise [ArgumentError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/safari/options.rb#31
  def add_option(name, value = T.unsafe(nil)); end

  # Returns the value of attribute options.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/safari/options.rb#24
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/safari/options.rb#24
  def options=(_arg0); end
end

# source://selenium-webdriver//lib/selenium/webdriver/safari/options.rb#29
Selenium::WebDriver::Safari::Options::BROWSER = T.let(T.unsafe(nil), String)

# @see https://developer.apple.com/documentation/webkit/about_webdriver_for_safari
#
# source://selenium-webdriver//lib/selenium/webdriver/safari/options.rb#27
Selenium::WebDriver::Safari::Options::CAPABILITIES = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Safari::Service < ::Selenium::WebDriver::Service; end

# source://selenium-webdriver//lib/selenium/webdriver/safari/service.rb#24
Selenium::WebDriver::Safari::Service::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/safari/service.rb#25
Selenium::WebDriver::Safari::Service::EXECUTABLE = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/safari/service.rb#26
Selenium::WebDriver::Safari::Service::MISSING_TEXT = T.let(T.unsafe(nil), String)

# source://selenium-webdriver//lib/selenium/webdriver/safari/service.rb#30
Selenium::WebDriver::Safari::Service::SHUTDOWN_SUPPORTED = T.let(T.unsafe(nil), FalseClass)

module Selenium::WebDriver::SearchContext
  # Find the first element matching the given arguments
  #
  # When using Element#find_element with :xpath, be aware that webdriver
  # follows standard conventions: a search prefixed with "//" will search
  # the entire document, not just the children of this current node. Use
  # ".//" to limit your search to the children of the receiving Element.
  #
  # @overload find_element
  # @overload find_element
  # @raise [Error::NoSuchElementError] if the element doesn't exist
  # @return [Element]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#57
  def find_element(*args); end

  # Find all elements matching the given arguments
  #
  # @raise [ArgumentError]
  # @see SearchContext#find_element
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#72
  def find_elements(*args); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#83
  def extract_args(args); end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/search_context.rb#24
Selenium::WebDriver::SearchContext::FINDERS = T.let(T.unsafe(nil), Hash)

# Wrapper for getting information from the Selenium Manager binaries.
# This implementation is still in beta, and may change.
#
# @api private
class Selenium::WebDriver::SeleniumManager
  class << self
    # @api private
    # @param driver_name [String] which driver to use.
    # @return [String] the path to the correct driver.
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/selenium_manager.rb#35
    def driver_path(driver_name); end

    private

    # @api private
    # @return [String] the path to the correct selenium manager
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/selenium_manager.rb#53
    def binary; end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/selenium_manager.rb#73
    def run(command); end
  end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/selenium_manager.rb#30
Selenium::WebDriver::SeleniumManager::BIN_PATH = T.let(T.unsafe(nil), String)

# Base class implementing default behavior of service object,
# responsible for storing a service manager configuration.
class Selenium::WebDriver::Service
  # End users should use a class method for the desired driver, rather than using this directly.
  #
  # @api private
  # @raise [Error::WebDriverError]
  # @return [Service] a new instance of Service
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#68
  def initialize(path: T.unsafe(nil), port: T.unsafe(nil), args: T.unsafe(nil)); end

  # Returns the value of attribute executable_path.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#60
  def executable_path; end

  # Returns the value of attribute extra_args.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#60
  def extra_args; end

  # Returns the value of attribute host.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#59
  def host; end

  # Sets the attribute host
  #
  # @param value the value to set the attribute host to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#59
  def host=(_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#82
  def launch; end

  # Returns the value of attribute port.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#60
  def port; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#86
  def shutdown_supported; end

  protected

  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#92
  def extract_service_args(driver_opts); end

  private

  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#98
  def binary_path(path = T.unsafe(nil)); end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#31
    def chrome(**opts); end

    # Returns the value of attribute driver_path.
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#29
    def driver_path; end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#53
    def driver_path=(path); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#44
    def edge(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#35
    def firefox(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#39
    def ie(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#39
    def internet_explorer(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#44
    def microsoftedge(**opts); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/service.rb#49
    def safari(**opts); end
  end
end

# Base class implementing default behavior of service_manager object,
# responsible for starting and stopping driver implementations.
#
# @api private
class Selenium::WebDriver::ServiceManager
  # End users should use a class method for the desired driver, rather than using this directly.
  #
  # @api private
  # @raise [Error::WebDriverError]
  # @return [ServiceManager] a new instance of ServiceManager
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#39
  def initialize(config); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#49
  def start; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#61
  def stop; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#73
  def uri; end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#79
  def build_process(*command); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#133
  def cannot_connect_error_text; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#87
  def connect_to_server; end

  # @api private
  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#126
  def connect_until_stable; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#96
  def find_free_port; end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#122
  def process_exited?; end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#118
  def process_running?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#137
  def socket_lock; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#100
  def start_process; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#105
  def stop_process; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#111
  def stop_server; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#30
Selenium::WebDriver::ServiceManager::SOCKET_LOCK_TIMEOUT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#29
Selenium::WebDriver::ServiceManager::START_TIMEOUT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/service_manager.rb#31
Selenium::WebDriver::ServiceManager::STOP_TIMEOUT = T.let(T.unsafe(nil), Integer)

class Selenium::WebDriver::ShadowRoot
  include ::Selenium::WebDriver::SearchContext

  # Creates a new shadow root
  #
  # @api private
  # @return [ShadowRoot] a new instance of ShadowRoot
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#33
  def initialize(bridge, id); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#42
  def ==(other); end

  # For Rails 3 - http://jonathanjulian.com/2010/04/rails-to_json-or-as_json/
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#77
  def as_json(*_arg0); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#42
  def eql?(other); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#47
  def hash; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#38
  def inspect; end

  # @api private
  # @see SearchContext
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#56
  def ref; end

  # Convert to a ShadowRoot JSON Object for transmission over the wire.
  #
  # @api private
  # @see https://github.com/SeleniumHQ/selenium/wiki/JsonWireProtocol#basic-terms-and-concepts
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#67
  def to_json(*_arg0); end

  private

  # Returns the value of attribute bridge.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#83
  def bridge; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/shadow_root.rb#23
Selenium::WebDriver::ShadowRoot::ROOT_KEY = T.let(T.unsafe(nil), String)

# @api private
class Selenium::WebDriver::SocketLock
  # @api private
  # @return [SocketLock] a new instance of SocketLock
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#27
  def initialize(port, timeout); end

  # Attempt to acquire a lock on the given port. Control is yielded to an
  # execution block if the lock could be successfully obtained.
  #
  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#37
  def locked; end

  private

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#67
  def can_lock?; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#59
  def current_time; end

  # @api private
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#76
  def did_lock?; end

  # @api private
  # @raise [Error::WebDriverError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#49
  def lock; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_lock.rb#63
  def release; end
end

class Selenium::WebDriver::SocketPoller
  # @return [SocketPoller] a new instance of SocketPoller
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#26
  def initialize(host, port, timeout = T.unsafe(nil), interval = T.unsafe(nil)); end

  # Returns true if the server has stopped listening within the given timeout,
  # false otherwise.
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#51
  def closed?; end

  # Returns true if the server is listening within the given timeout,
  # false otherwise.
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#40
  def connected?; end

  private

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#105
  def conn_completed?(sock); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#121
  def current_time; end

  # we use a plain TCPSocket here since JRuby has issues closing socket
  # see https://github.com/jruby/jruby/issues/5709
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#78
  def listening?; end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#101
  def socket_writable?(sock); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#109
  def with_timeout; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#63
Selenium::WebDriver::SocketPoller::CONNECTED_ERRORS = T.let(T.unsafe(nil), Array)

# source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#57
Selenium::WebDriver::SocketPoller::CONNECT_TIMEOUT = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/common/socket_poller.rb#59
Selenium::WebDriver::SocketPoller::NOT_CONNECTED_ERRORS = T.let(T.unsafe(nil), Array)

module Selenium::WebDriver::Support; end

# Subclass and override methods from this class
# to implement your own event listener.
#
# @example
#
#   class NavigationListener < Selenium::WebDriver::Support::AbstractEventListener
#   def initialize(log)
#   @log = log
#   end
#
#   def before_navigate_to(url, driver)
#   @log.info "navigating to #{url}"
#   end
#
#   def after_navigate_to(url, driver)
#   @log.info "done navigating to #{url}"
#   end
#   end
#
#   listener = NavigationListener.new(logger)
#   driver = Selenium::WebDriver.for :firefox, :listener => listener
class Selenium::WebDriver::Support::AbstractEventListener
  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#71
  def after_change_value_of(element, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#67
  def after_click(element, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#83
  def after_close(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#75
  def after_execute_script(script, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#63
  def after_find(by, what, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#55
  def after_navigate_back(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#59
  def after_navigate_forward(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#51
  def after_navigate_to(url, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#79
  def after_quit(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#69
  def before_change_value_of(element, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#65
  def before_click(element, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#81
  def before_close(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#73
  def before_execute_script(script, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#61
  def before_find(by, what, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#53
  def before_navigate_back(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#57
  def before_navigate_forward(driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#49
  def before_navigate_to(url, driver); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/abstract_event_listener.rb#77
  def before_quit(driver); end
end

class Selenium::WebDriver::Support::BlockEventListener
  # @return [BlockEventListener] a new instance of BlockEventListener
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/block_event_listener.rb#24
  def initialize(callback); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/block_event_listener.rb#28
  def method_missing(meth, *args); end
end

class Selenium::WebDriver::Support::Color
  # @return [Color] a new instance of Color
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#112
  def initialize(red, green, blue, alpha = T.unsafe(nil)); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#119
  def ==(other); end

  # Returns the value of attribute alpha.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#48
  def alpha; end

  # Returns the value of attribute blue.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#48
  def blue; end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#119
  def eql?(other); end

  # Returns the value of attribute green.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#48
  def green; end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#127
  def hash; end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#140
  def hex; end

  # Returns the value of attribute red.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#48
  def red; end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#131
  def rgb; end

  # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#135
  def rgba; end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#75
    def from_hsl(h, s, l, a); end

    # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#50
    def from_string(str); end

    # source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#97
    def hue_to_rgb(lum1, lum2, hue); end
  end
end

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#39
Selenium::WebDriver::Support::Color::HEX3_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#38
Selenium::WebDriver::Support::Color::HEX_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#43
Selenium::WebDriver::Support::Color::HSLA_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#40
Selenium::WebDriver::Support::Color::HSL_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#30
Selenium::WebDriver::Support::Color::RGBA_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#34
Selenium::WebDriver::Support::Color::RGBA_PCT_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#24
Selenium::WebDriver::Support::Color::RGB_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://selenium-webdriver//lib/selenium/webdriver/support/color.rb#27
Selenium::WebDriver::Support::Color::RGB_PCT_PATTERN = T.let(T.unsafe(nil), Regexp)

module Selenium::WebDriver::Support::Escaper
  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/support/escaper.rb#24
    def escape(str); end
  end
end

# @api private
class Selenium::WebDriver::Support::EventFiringBridge
  # @api private
  # @return [EventFiringBridge] a new instance of EventFiringBridge
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#28
  def initialize(delegate, listener); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#62
  def clear_element(ref); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#56
  def click_element(ref); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#100
  def close; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#90
  def execute_script(script, *args); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#74
  def find_element_by(how, what, parent = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#82
  def find_elements_by(how, what, parent = T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#38
  def get(url); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#50
  def go_back; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#44
  def go_forward; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#96
  def quit; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#68
  def send_keys_to_element(ref, keys); end

  private

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#106
  def create_element(ref); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#115
  def dispatch(name, *args); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#111
  def driver; end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/event_firing_bridge.rb#123
  def method_missing(meth, *args, &blk); end
end

# @api private
class Selenium::WebDriver::Support::RelativeLocator
  # @api private
  # @return [RelativeLocator] a new instance of RelativeLocator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/relative_locator.rb#31
  def initialize(locator); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/relative_locator.rb#35
  def as_json; end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/support/relative_locator.rb#29
Selenium::WebDriver::Support::RelativeLocator::KEYS = T.let(T.unsafe(nil), Array)

class Selenium::WebDriver::Support::Select
  # @param element [Element] The select element to use
  # @raise [ArgumentError]
  # @return [Select] a new instance of Select
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#28
  def initialize(element); end

  # Deselect all selected options. Only valid if the element supports multiple selections.
  #
  # @raise [Error::UnsupportedOperationError] if the element does not support multiple selections.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#155
  def deselect_all; end

  # Deselect options by visible text, index or value.
  #
  # @param how [:text, :index, :value] How to find the option
  # @param what [String] What value to find the option by.
  # @raise [Error::UnsupportedOperationError] if the element does not support multiple selections.
  # @see Select#select_by
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#124
  def deselect_by(how, what); end

  # Get the first selected option in this select element
  #
  # @raise [Error::NoSuchElementError] if no options are selected
  # @return [Element]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#74
  def first_selected_option; end

  # Does this select element support selecting multiple options?
  #
  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#43
  def multiple?; end

  # Get all options for this select element
  #
  # @return [Array<Element>]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#53
  def options; end

  # Select all unselected options. Only valid if the element supports multiple selections.
  #
  # @raise [Error::UnsupportedOperationError] if the element does not support multiple selections.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#143
  def select_all; end

  # Select options by visible text, index or value.
  #
  # When selecting by :text, selects options that display text matching the argument. That is, when given "Bar" this
  # would select an option like:
  #
  #     <option value="foo">Bar</option>
  #
  # When selecting by :value, selects all options that have a value matching the argument. That is, when given "foo" this
  # would select an option like:
  #
  #     <option value="foo">Bar</option>
  #
  # When selecting by :index, selects the option at the given index. This is done by examining the "index" attribute of an
  # element, and not merely by counting.
  #
  # @param how [:text, :index, :value] How to find the option
  # @param what [String] What value to find the option by.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#101
  def select_by(how, what); end

  # Get all selected options for this select element
  #
  # @return [Array<Element>]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#63
  def selected_options; end

  private

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#207
  def deselect_by_index(index); end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#187
  def deselect_by_text(text); end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#197
  def deselect_by_value(value); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#223
  def deselect_option(option); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#235
  def deselect_options(opts); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#262
  def find_by_index(index); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#243
  def find_by_text(text); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#266
  def find_by_value(value); end

  # @raise [Error::NoSuchElementError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#171
  def select_by_index(index); end

  # @raise [Error::NoSuchElementError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#163
  def select_by_text(text); end

  # @raise [Error::NoSuchElementError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#179
  def select_by_value(value); end

  # @raise [Error::UnsupportedOperationError]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#217
  def select_option(option); end

  # source://selenium-webdriver//lib/selenium/webdriver/support/select.rb#227
  def select_options(opts); end
end

# @api private
module Selenium::WebDriver::TakesScreenshot
  # Save a PNG screenshot of the viewport to the given path
  #
  # @api public
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/takes_screenshot.rb#32
  def save_screenshot(png_path, full_page: T.unsafe(nil)); end

  # Return a PNG screenshot in the given format as a string
  #
  # @api public
  # @param format [:base64, :png]
  # @param full_page [Boolean] allows taking full page screenshots if supported
  # @return String screenshot
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/takes_screenshot.rb#51
  def screenshot_as(format, full_page: T.unsafe(nil)); end
end

class Selenium::WebDriver::TargetLocator
  # @api private
  # @return [TargetLocator] a new instance of TargetLocator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#27
  def initialize(bridge); end

  # get the active element
  #
  # @return [WebDriver::Element]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#118
  def active_element; end

  # switches to the currently active modal dialog for this particular driver instance
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#134
  def alert; end

  # selects either the first frame on the page, or the main document when a page contains iframes.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#126
  def default_content; end

  # switch to the frame with the given id
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#35
  def frame(id); end

  # Switch to a new top-level browsing context
  #
  # @param type either :tab or :window
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#53
  def new_window(type = T.unsafe(nil)); end

  # switch to the parent frame
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#43
  def parent_frame; end

  # switch to the given window handle
  #
  # If given a block, this method will switch back to the original window after
  # block execution.
  #
  # @param id A window handle, obtained through Driver#window_handles
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/target_locator.rb#85
  def window(id); end
end

class Selenium::WebDriver::Timeouts
  # @return [Timeouts] a new instance of Timeouts
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#23
  def initialize(bridge); end

  # Gets the amount of time the driver should wait when searching for elements.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#31
  def implicit_wait; end

  # Set the amount of time the driver should wait when searching for elements.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#39
  def implicit_wait=(seconds); end

  # Gets the amount of time to wait for a page load to complete before throwing an error.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#68
  def page_load; end

  # Sets the amount of time to wait for a page load to complete before throwing an error.
  # If the timeout is negative, page loads can be indefinite.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#77
  def page_load=(seconds); end

  # Gets the amount of time to wait for an asynchronous script to finish
  # execution before throwing an error.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#48
  def script; end

  # Sets the amount of time to wait for an asynchronous script to finish
  # execution before throwing an error. If the timeout is negative, then the
  # script will be allowed to run indefinitely.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#59
  def script=(seconds); end

  # Gets the amount of time to wait for an asynchronous script to finish
  # execution before throwing an error.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#48
  def script_timeout; end

  # Sets the amount of time to wait for an asynchronous script to finish
  # execution before throwing an error. If the timeout is negative, then the
  # script will be allowed to run indefinitely.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/timeouts.rb#59
  def script_timeout=(seconds); end
end

# source://selenium-webdriver//lib/selenium/webdriver/version.rb#22
Selenium::WebDriver::VERSION = T.let(T.unsafe(nil), String)

class Selenium::WebDriver::VirtualAuthenticator
  # api private
  # Use `Driver#add_virtual_authenticator`
  #
  # @return [VirtualAuthenticator] a new instance of VirtualAuthenticator
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#31
  def initialize(bridge, authenticator_id, options); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#38
  def add_credential(credential); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#43
  def credentials; end

  # Returns the value of attribute options.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#24
  def options; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#63
  def remove!; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#55
  def remove_all_credentials; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#50
  def remove_credential(credential_id); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#59
  def user_verified=(verified); end

  # @return [Boolean]
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator.rb#68
  def valid?; end
end

class Selenium::WebDriver::VirtualAuthenticatorOptions
  # @return [VirtualAuthenticatorOptions] a new instance of VirtualAuthenticatorOptions
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#38
  def initialize(protocol: T.unsafe(nil), transport: T.unsafe(nil), resident_key: T.unsafe(nil), user_verification: T.unsafe(nil), user_consenting: T.unsafe(nil), user_verified: T.unsafe(nil)); end

  # @api private
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#52
  def as_json(*_arg0); end

  # Returns the value of attribute protocol.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def protocol; end

  # Sets the attribute protocol
  #
  # @param value the value to set the attribute protocol to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def protocol=(_arg0); end

  # Returns the value of attribute resident_key.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def resident_key; end

  # Sets the attribute resident_key
  #
  # @param value the value to set the attribute resident_key to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def resident_key=(_arg0); end

  # Returns the value of attribute resident_key.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def resident_key?; end

  # Returns the value of attribute transport.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def transport; end

  # Sets the attribute transport
  #
  # @param value the value to set the attribute transport to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def transport=(_arg0); end

  # Returns the value of attribute user_consenting.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_consenting; end

  # Sets the attribute user_consenting
  #
  # @param value the value to set the attribute user_consenting to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_consenting=(_arg0); end

  # Returns the value of attribute user_consenting.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_consenting?; end

  # Returns the value of attribute user_verification.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verification; end

  # Sets the attribute user_verification
  #
  # @param value the value to set the attribute user_verification to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verification=(_arg0); end

  # Returns the value of attribute user_verification.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verification?; end

  # Returns the value of attribute user_verified.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verified; end

  # Sets the attribute user_verified
  #
  # @param value the value to set the attribute user_verified to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verified=(_arg0); end

  # Returns the value of attribute user_verified.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#32
  def user_verified?; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#29
Selenium::WebDriver::VirtualAuthenticatorOptions::PROTOCOL = T.let(T.unsafe(nil), Hash)

# source://selenium-webdriver//lib/selenium/webdriver/common/virtual_authenticator/virtual_authenticator_options.rb#30
Selenium::WebDriver::VirtualAuthenticatorOptions::TRANSPORT = T.let(T.unsafe(nil), Hash)

class Selenium::WebDriver::Wait
  # Create a new Wait instance
  #
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] Options for this instance
  # @return [Wait] a new instance of Wait
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/wait.rb#36
  def initialize(opts = T.unsafe(nil)); end

  # Wait until the given block returns a true value.
  #
  # @raise [Error::TimeoutError]
  # @return [Object] the result of the block
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/wait.rb#50
  def until; end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/wait.rb#78
  def current_time; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/wait.rb#24
Selenium::WebDriver::Wait::DEFAULT_INTERVAL = T.let(T.unsafe(nil), Float)

# source://selenium-webdriver//lib/selenium/webdriver/common/wait.rb#23
Selenium::WebDriver::Wait::DEFAULT_TIMEOUT = T.let(T.unsafe(nil), Integer)

class Selenium::WebDriver::WebSocketConnection
  # @return [WebSocketConnection] a new instance of WebSocketConnection
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#35
  def initialize(url:); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#51
  def callbacks; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#45
  def close; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#55
  def send_cmd(**payload); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#80
  def attach_socket_listener; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#120
  def callback_thread(params); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#103
  def incoming_frame; end

  # We should be thread-safe to use the hash without synchronization
  # because its keys are WebSocket message identifiers and they should be
  # unique within a devtools session.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#71
  def messages; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#158
  def next_id; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#107
  def process_frame(frame); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#75
  def process_handshake; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#141
  def socket; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#137
  def wait; end

  # source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#154
  def ws; end
end

# source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#25
Selenium::WebDriver::WebSocketConnection::CONNECTION_ERRORS = T.let(T.unsafe(nil), Array)

# source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#33
Selenium::WebDriver::WebSocketConnection::MAX_LOG_MESSAGE_SIZE = T.let(T.unsafe(nil), Integer)

# source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#31
Selenium::WebDriver::WebSocketConnection::RESPONSE_WAIT_INTERVAL = T.let(T.unsafe(nil), Float)

# source://selenium-webdriver//lib/selenium/webdriver/common/websocket_connection.rb#30
Selenium::WebDriver::WebSocketConnection::RESPONSE_WAIT_TIMEOUT = T.let(T.unsafe(nil), Integer)

module Selenium::WebDriver::WheelActions
  # By default this is set to 250ms in the ActionBuilder constructor
  # It can be overridden with default_scroll_duration=
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#30
  def default_scroll_duration; end

  # Sets the attribute default_scroll_duration
  #
  # @param value the value to set the attribute default_scroll_duration to.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#23
  def default_scroll_duration=(_arg0); end

  # Scrolls by provided amounts with the origin in the top left corner of the viewport.
  #
  # @example Scroll viewport by a specified amount
  #   el = driver.find_element(id: "some_id")
  #   driver.action.scroll_by(100, 200).perform
  # @param delta_x [Integer] Distance along X axis to scroll using the wheel. A negative value scrolls left.
  # @param delta_y [Integer] Distance along Y axis to scroll using the wheel. A negative value scrolls up.
  # @return [Selenium::WebDriver::WheelActions] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#57
  def scroll_by(delta_x, delta_y, device: T.unsafe(nil)); end

  # Scrolls by provided amount based on a provided origin.
  #
  # The scroll origin is either the center of an element or the upper left of the viewport plus any offsets.
  # If the origin is an element, and the element is not in the viewport, the bottom of the element will first
  #   be scrolled to the bottom of the viewport.
  #
  # @example Scroll from element by a specified amount
  #   el = driver.find_element(id: "some_id")
  #   origin = WheelActions::ScrollOrigin.element(el)
  #   driver.action.scroll_from(origin, 0, 200).perform
  # @example Scroll from element by a specified amount with an offset
  #   el = driver.find_element(id: "some_id")
  #   origin = WheelActions::ScrollOrigin.element(el, 10, 10)
  #   driver.action.scroll_from(origin, 100, 200).perform
  # @example Scroll viewport by a specified amount with an offset
  #   origin = WheelActions::ScrollOrigin.viewport(10, 10)
  #   driver.action.scroll_from(origin, 0, 200).perform
  # @param scroll_origin [ScrollOrigin] Where scroll originates (viewport or element center) plus provided offsets.
  # @param delta_x [Integer] Distance along X axis to scroll using the wheel. A negative value scrolls left.
  # @param delta_y [Integer] Distance along Y axis to scroll using the wheel. A negative value scrolls up.
  # @raise [Error::MoveTargetOutOfBoundsError] If the origin with offset is outside the viewport.
  # @return [Selenium::WebDriver::WheelActions] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#87
  def scroll_from(scroll_origin, delta_x, delta_y, device: T.unsafe(nil)); end

  # If the element is outside the viewport, scrolls the bottom of the element to the bottom of the viewport.
  #
  # @example Scroll to element
  #   el = driver.find_element(id: "some_id")
  #   driver.action.scroll_to(element).perform
  # @param Which [Object] element to scroll into the viewport.
  # @return [Selenium::WebDriver::WheelActions] A self reference.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#43
  def scroll_to(element, device: T.unsafe(nil)); end

  private

  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#100
  def scroll(**opts); end

  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/wheel_actions.rb#108
  def wheel_input(name = T.unsafe(nil)); end
end

class Selenium::WebDriver::WheelActions::ScrollOrigin
  # Use a static method to access
  #
  # @api private
  # @return [ScrollOrigin] a new instance of ScrollOrigin
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#40
  def initialize(origin, x_offset, y_offset); end

  # Returns the value of attribute origin.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#34
  def origin; end

  # Returns the value of attribute x_offset.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#34
  def x_offset; end

  # Returns the value of attribute y_offset.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#34
  def y_offset; end

  class << self
    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#25
    def element(element, x_offset = T.unsafe(nil), y_offset = T.unsafe(nil)); end

    # source://selenium-webdriver//lib/selenium/webdriver/common/interactions/scroll_origin.rb#29
    def viewport(x_offset = T.unsafe(nil), y_offset = T.unsafe(nil)); end
  end
end

class Selenium::WebDriver::Window
  # @api private
  # @return [Window] a new instance of Window
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#27
  def initialize(bridge); end

  # Make current window full screen
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#154
  def full_screen; end

  # Maximize the current window
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#138
  def maximize; end

  # Minimize the current window
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#146
  def minimize; end

  # Equivalent to #position=, but accepts x and y arguments.
  #
  # @example
  #
  #   driver.manage.window.move_to(300, 400)
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#130
  def move_to(x, y); end

  # Get the position of the current window.
  #
  # @return [Selenium::WebDriver::Point] The position.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#77
  def position; end

  # Move the current window to the given position.
  #
  # @param point [Selenium::WebDriver::Point, #x and #y] The new position.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#62
  def position=(point); end

  # Get the rect of the current window.
  #
  # @return [Selenium::WebDriver::Rectangle] The rectangle.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#105
  def rect; end

  # Sets the current window rect to the given point and position.
  #
  # @param rectangle [Selenium::WebDriver::Rectangle, #x, #y, #width, #height] The new rect.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#87
  def rect=(rectangle); end

  # Equivalent to #size=, but accepts width and height arguments.
  #
  # @example Maximize the window.
  #
  #   max_width, max_height = driver.execute_script("return [window.screen.availWidth, window.screen.availHeight];")
  #   driver.manage.window.resize_to(max_width, max_height)
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#118
  def resize_to(width, height); end

  # Get the size of the current window.
  #
  # @return [Selenium::WebDriver::Dimension] The size.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#52
  def size; end

  # Resize the current window to the given dimension.
  #
  # @param dimension [Selenium::WebDriver::Dimension, #width and #height] The new size.
  #
  # source://selenium-webdriver//lib/selenium/webdriver/common/window.rb#37
  def size=(dimension); end
end

# @api private
module Selenium::WebDriver::Zipper
  class << self
    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#35
    def unzip(path); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#52
    def zip(path); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#63
    def zip_file(path); end

    private

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#82
    def add_zip_entry(zip, file, entry_name); end

    # @api private
    #
    # source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#74
    def with_tmp_zip(&blk); end
  end
end

# @api private
#
# source://selenium-webdriver//lib/selenium/webdriver/common/zipper.rb#32
Selenium::WebDriver::Zipper::EXTENSIONS = T.let(T.unsafe(nil), Array)
