# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `ruby-statistics` gem.
# Please instead update this file by running `bin/tapioca gem ruby-statistics`.

# TODO: Avoid monkey-patching.
module Enumerable
  extend ::ActiveSupport::EnumerableCoreExt::Constants

  # source://ruby-statistics//lib/enumerable.rb#3
  def mean; end

  # source://ruby-statistics//lib/enumerable.rb#12
  def standard_deviation; end

  # source://ruby-statistics//lib/enumerable.rb#7
  def variance; end
end

module Math
  class << self
    # source://ruby-statistics//lib/math.rb#57
    def beta_function(x, y); end

    # source://ruby-statistics//lib/math.rb#11
    def combination(n, r); end

    # source://ruby-statistics//lib/math.rb#2
    def factorial(n); end

    # source://ruby-statistics//lib/math.rb#66
    def incomplete_beta_function(x, alp, bet); end

    # source://ruby-statistics//lib/math.rb#47
    def lower_incomplete_gamma_function(s, x); end

    # source://ruby-statistics//lib/math.rb#15
    def permutation(n, k); end

    # Function adapted from the python implementation that exists in https://en.wikipedia.org/wiki/Simpson%27s_rule#Sample_implementation
    # Finite integral in the interval [a, b] split up in n-intervals
    #
    # source://ruby-statistics//lib/math.rb#21
    def simpson_rule(a, b, n, &block); end
  end
end

# source://ruby-statistics//lib/statistics/statistical_test.rb#10
StatisticalTest = Statistics::StatisticalTest

module Statistics; end
module Statistics::Distribution; end

class Statistics::Distribution::Bernoulli
  class << self
    # source://ruby-statistics//lib/statistics/distribution/bernoulli.rb#13
    def cumulative_function(n, p); end

    # source://ruby-statistics//lib/statistics/distribution/bernoulli.rb#4
    def density_function(n, p); end

    # source://ruby-statistics//lib/statistics/distribution/bernoulli.rb#30
    def kurtosis(p); end

    # source://ruby-statistics//lib/statistics/distribution/bernoulli.rb#26
    def skewness(p); end

    # source://ruby-statistics//lib/statistics/distribution/bernoulli.rb#22
    def variance(p); end
  end
end

class Statistics::Distribution::Beta
  # @return [Beta] a new instance of Beta
  #
  # source://ruby-statistics//lib/statistics/distribution/beta.rb#6
  def initialize(alp, bet); end

  # Returns the value of attribute alpha.
  #
  # source://ruby-statistics//lib/statistics/distribution/beta.rb#4
  def alpha; end

  # Sets the attribute alpha
  #
  # @param value the value to set the attribute alpha to.
  #
  # source://ruby-statistics//lib/statistics/distribution/beta.rb#4
  def alpha=(_arg0); end

  # Returns the value of attribute beta.
  #
  # source://ruby-statistics//lib/statistics/distribution/beta.rb#4
  def beta; end

  # Sets the attribute beta
  #
  # @param value the value to set the attribute beta to.
  #
  # source://ruby-statistics//lib/statistics/distribution/beta.rb#4
  def beta=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/beta.rb#11
  def cumulative_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/beta.rb#15
  def density_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/beta.rb#30
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/beta.rb#24
  def mode; end
end

class Statistics::Distribution::Binomial
  # @return [Binomial] a new instance of Binomial
  #
  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#5
  def initialize(n, p); end

  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#18
  def cumulative_function(k); end

  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#26
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#34
  def mode; end

  # Returns the value of attribute number_of_trials.
  #
  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#4
  def number_of_trials; end

  # Sets the attribute number_of_trials
  #
  # @param value the value to set the attribute number_of_trials to.
  #
  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#4
  def number_of_trials=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#10
  def probability_mass_function(k); end

  # Returns the value of attribute probability_per_trial.
  #
  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#4
  def probability_per_trial; end

  # Sets the attribute probability_per_trial
  #
  # @param value the value to set the attribute probability_per_trial to.
  #
  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#4
  def probability_per_trial=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/binomial.rb#30
  def variance; end
end

class Statistics::Distribution::ChiSquared
  # @return [ChiSquared] a new instance of ChiSquared
  #
  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#8
  def initialize(k); end

  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#12
  def cumulative_function(value); end

  # Returns the value of attribute degrees_of_freedom.
  #
  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#4
  def degrees_of_freedom; end

  # Sets the attribute degrees_of_freedom
  #
  # @param value the value to set the attribute degrees_of_freedom to.
  #
  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#4
  def degrees_of_freedom=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#17
  def density_function(value); end

  # Returns the value of attribute degrees_of_freedom.
  #
  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#4
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#28
  def mode; end

  # source://ruby-statistics//lib/statistics/distribution/chi_squared.rb#32
  def variance; end
end

class Statistics::Distribution::Empirical
  # @return [Empirical] a new instance of Empirical
  #
  # source://ruby-statistics//lib/statistics/distribution/empirical.rb#6
  def initialize(samples:); end

  # Formula grabbed from here: https://statlect.com/asymptotic-theory/empirical-distribution
  #
  # source://ruby-statistics//lib/statistics/distribution/empirical.rb#11
  def cumulative_function(x:); end

  # Returns the value of attribute samples.
  #
  # source://ruby-statistics//lib/statistics/distribution/empirical.rb#4
  def samples; end

  # Sets the attribute samples
  #
  # @param value the value to set the attribute samples to.
  #
  # source://ruby-statistics//lib/statistics/distribution/empirical.rb#4
  def samples=(_arg0); end
end

class Statistics::Distribution::F
  # @return [F] a new instance of F
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#6
  def initialize(k, j); end

  # Formula extracted from http://www.itl.nist.gov/div898/handbook/eda/section3/eda3665.htm#CDF
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#12
  def cumulative_function(value); end

  # Degrees of freedom #1 and #2
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#4
  def d1; end

  # Degrees of freedom #1 and #2
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#4
  def d1=(_arg0); end

  # Degrees of freedom #1 and #2
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#4
  def d2; end

  # Degrees of freedom #1 and #2
  #
  # source://ruby-statistics//lib/statistics/distribution/f.rb#4
  def d2=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/f.rb#18
  def density_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/f.rb#30
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/f.rb#36
  def mode; end
end

class Statistics::Distribution::Geometric
  # @return [Geometric] a new instance of Geometric
  #
  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#6
  def initialize(p, always_success: T.unsafe(nil)); end

  # Returns the value of attribute always_success_allowed.
  #
  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#4
  def always_success_allowed; end

  # Sets the attribute always_success_allowed
  #
  # @param value the value to set the attribute always_success_allowed to.
  #
  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#4
  def always_success_allowed=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#25
  def cumulative_function(k); end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#11
  def density_function(k); end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#71
  def kurtosis; end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#39
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#47
  def median; end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#55
  def mode; end

  # Returns the value of attribute probability_of_success.
  #
  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#4
  def probability_of_success; end

  # Sets the attribute probability_of_success
  #
  # @param value the value to set the attribute probability_of_success to.
  #
  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#4
  def probability_of_success=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#67
  def skewness; end

  # source://ruby-statistics//lib/statistics/distribution/geometric.rb#63
  def variance; end
end

# Inverse Standard Normal distribution:
# References:
# https://en.wikipedia.org/wiki/Inverse_distribution
# http://www.source-code.biz/snippets/vbasic/9.htm
class Statistics::Distribution::InverseStandardNormal < ::Statistics::Distribution::StandardNormal
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#120
  def cumulative_function(value); end

  # @raise [NotImplementedError]
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#112
  def density_function(_); end

  # @raise [NotImplementedError]
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#116
  def random(elements: T.unsafe(nil), seed: T.unsafe(nil)); end
end

# source://ruby-statistics//lib/statistics/distribution/normal.rb#88
Statistics::Distribution::InverseStandardNormal::A1 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#89
Statistics::Distribution::InverseStandardNormal::A2 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#90
Statistics::Distribution::InverseStandardNormal::A3 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#91
Statistics::Distribution::InverseStandardNormal::A4 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#92
Statistics::Distribution::InverseStandardNormal::A5 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#93
Statistics::Distribution::InverseStandardNormal::A6 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#94
Statistics::Distribution::InverseStandardNormal::B1 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#95
Statistics::Distribution::InverseStandardNormal::B2 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#96
Statistics::Distribution::InverseStandardNormal::B3 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#97
Statistics::Distribution::InverseStandardNormal::B4 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#98
Statistics::Distribution::InverseStandardNormal::B5 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#99
Statistics::Distribution::InverseStandardNormal::C1 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#100
Statistics::Distribution::InverseStandardNormal::C2 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#101
Statistics::Distribution::InverseStandardNormal::C3 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#102
Statistics::Distribution::InverseStandardNormal::C4 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#103
Statistics::Distribution::InverseStandardNormal::C5 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#104
Statistics::Distribution::InverseStandardNormal::C6 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#105
Statistics::Distribution::InverseStandardNormal::D1 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#106
Statistics::Distribution::InverseStandardNormal::D2 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#107
Statistics::Distribution::InverseStandardNormal::D3 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#108
Statistics::Distribution::InverseStandardNormal::D4 = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#110
Statistics::Distribution::InverseStandardNormal::P_HIGH = T.let(T.unsafe(nil), Float)

# source://ruby-statistics//lib/statistics/distribution/normal.rb#109
Statistics::Distribution::InverseStandardNormal::P_LOW = T.let(T.unsafe(nil), Float)

class Statistics::Distribution::LogSeries
  class << self
    # source://ruby-statistics//lib/statistics/distribution/logseries.rb#14
    def cumulative_function(k, p); end

    # source://ruby-statistics//lib/statistics/distribution/logseries.rb#4
    def density_function(k, p); end

    # source://ruby-statistics//lib/statistics/distribution/logseries.rb#39
    def mean(p); end

    # source://ruby-statistics//lib/statistics/distribution/logseries.rb#35
    def mode; end

    # source://ruby-statistics//lib/statistics/distribution/logseries.rb#43
    def variance(p); end
  end
end

class Statistics::Distribution::NegativeBinomial
  # @return [NegativeBinomial] a new instance of NegativeBinomial
  #
  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#6
  def initialize(r, p); end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#20
  def cumulative_function(k); end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#27
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#39
  def mode; end

  # Returns the value of attribute number_of_failures.
  #
  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#4
  def number_of_failures; end

  # Sets the attribute number_of_failures
  #
  # @param value the value to set the attribute number_of_failures to.
  #
  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#4
  def number_of_failures=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#11
  def probability_mass_function(k); end

  # Returns the value of attribute probability_per_trial.
  #
  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#4
  def probability_per_trial; end

  # Sets the attribute probability_per_trial
  #
  # @param value the value to set the attribute probability_per_trial to.
  #
  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#4
  def probability_per_trial=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#35
  def skewness; end

  # source://ruby-statistics//lib/statistics/distribution/negative_binomial.rb#31
  def variance; end
end

class Statistics::Distribution::Normal
  # @return [Normal] a new instance of Normal
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#7
  def initialize(avg, std); end

  # source://ruby-statistics//lib/statistics/distribution/normal.rb#13
  def cumulative_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/normal.rb#17
  def density_function(value); end

  # Returns the value of attribute mean.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def mean; end

  # Sets the attribute mean
  #
  # @param value the value to set the attribute mean to.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def mean=(_arg0); end

  # Returns the value of attribute mean.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def mode; end

  # Marsaglia polar method implementation for random gaussian (normal) number generation.
  # References:
  # https://en.wikipedia.org/wiki/Marsaglia_polar_method
  # https://math.stackexchange.com/questions/69245/transform-uniform-distribution-to-normal-distribution-using-lindeberg-l%C3%A9vy-clt
  # https://www.projectrhea.org/rhea/index.php/The_principles_for_how_to_generate_random_samples_from_a_Gaussian_distribution
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#35
  def random(elements: T.unsafe(nil), seed: T.unsafe(nil)); end

  # Returns the value of attribute standard_deviation.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def standard_deviation; end

  # Sets the attribute standard_deviation
  #
  # @param value the value to set the attribute standard_deviation to.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def standard_deviation=(_arg0); end

  # Returns the value of attribute variance.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def variance; end

  # Sets the attribute variance
  #
  # @param value the value to set the attribute variance to.
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#4
  def variance=(_arg0); end
end

class Statistics::Distribution::Poisson
  # @return [Poisson] a new instance of Poisson
  #
  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#9
  def initialize(l); end

  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#24
  def cumulative_function(k); end

  # Returns the value of attribute expected_number_of_occurrences.
  #
  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#4
  def expected_number_of_occurrences; end

  # Sets the attribute expected_number_of_occurrences
  #
  # @param value the value to set the attribute expected_number_of_occurrences to.
  #
  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#4
  def expected_number_of_occurrences=(_arg0); end

  # Returns the value of attribute expected_number_of_occurrences.
  #
  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#4
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#13
  def probability_mass_function(k); end

  # Returns the value of attribute expected_number_of_occurrences.
  #
  # source://ruby-statistics//lib/statistics/distribution/poisson.rb#4
  def variance; end
end

class Statistics::Distribution::StandardNormal < ::Statistics::Distribution::Normal
  # @return [StandardNormal] a new instance of StandardNormal
  #
  # source://ruby-statistics//lib/statistics/distribution/normal.rb#71
  def initialize; end

  # source://ruby-statistics//lib/statistics/distribution/normal.rb#75
  def density_function(value); end
end

class Statistics::Distribution::TStudent
  # @return [TStudent] a new instance of TStudent
  #
  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#7
  def initialize(v); end

  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#14
  def cumulative_function(value); end

  # Returns the value of attribute degrees_of_freedom.
  #
  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#4
  def degrees_of_freedom; end

  # Sets the attribute degrees_of_freedom
  #
  # @param value the value to set the attribute degrees_of_freedom to.
  #
  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#4
  def degrees_of_freedom=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#26
  def density_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#37
  def mean; end

  # Returns the value of attribute mode.
  #
  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#5
  def mode; end

  # Quantile function extracted from http://www.jennessent.com/arcview/idf.htm
  # TODO: Make it truly Student's T sample.
  #
  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#51
  def random(elements: T.unsafe(nil), seed: T.unsafe(nil)); end

  # source://ruby-statistics//lib/statistics/distribution/t_student.rb#41
  def variance; end
end

class Statistics::Distribution::Uniform
  # @return [Uniform] a new instance of Uniform
  #
  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#6
  def initialize(a, b); end

  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#19
  def cumulative_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#11
  def density_function(value); end

  # Returns the value of attribute left.
  #
  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#4
  def left; end

  # Sets the attribute left
  #
  # @param value the value to set the attribute left to.
  #
  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#4
  def left=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#29
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#29
  def median; end

  # Returns the value of attribute right.
  #
  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#4
  def right; end

  # Sets the attribute right
  #
  # @param value the value to set the attribute right to.
  #
  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#4
  def right=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/uniform.rb#35
  def variance; end
end

class Statistics::Distribution::Weibull
  # @return [Weibull] a new instance of Weibull
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#6
  def initialize(k, lamb); end

  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#11
  def cumulative_function(random_value); end

  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#17
  def density_function(value); end

  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#28
  def mean; end

  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#32
  def mode; end

  # Using the inverse CDF function, also called quantile, we can calculate
  # a random sample that follows a weibull distribution.
  #
  # Formula extracted from https://www.taygeta.com/random/weibull.html
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#49
  def random(elements: T.unsafe(nil), seed: T.unsafe(nil)); end

  # k and lambda
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#4
  def scale; end

  # k and lambda
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#4
  def scale=(_arg0); end

  # k and lambda
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#4
  def shape; end

  # k and lambda
  #
  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#4
  def shape=(_arg0); end

  # source://ruby-statistics//lib/statistics/distribution/weibull.rb#38
  def variance; end
end

class Statistics::SpearmanRankCoefficient
  class << self
    # Formulas extracted from: https://statistics.laerd.com/statistical-guides/spearmans-rank-order-correlation-statistical-guide.php
    #
    # source://ruby-statistics//lib/statistics/spearman_rank_coefficient.rb#33
    def coefficient(set_one, set_two); end

    # source://ruby-statistics//lib/statistics/spearman_rank_coefficient.rb#3
    def rank(data:, return_ranks_only: T.unsafe(nil)); end
  end
end

module Statistics::StatisticalTest; end

class Statistics::StatisticalTest::ChiSquaredTest
  class << self
    # source://ruby-statistics//lib/statistics/statistical_test/chi_squared_test.rb#4
    def chi_statistic(expected, observed); end

    # source://ruby-statistics//lib/statistics/statistical_test/chi_squared_test.rb#23
    def goodness_of_fit(alpha, expected, observed); end
  end
end

class Statistics::StatisticalTest::FTest
  class << self
    # This method calculates the one-way ANOVA F-test statistic.
    # We assume that all specified arguments are arrays.
    # It returns an array with three elements:
    #   [F-statistic or F-score, degrees of freedom numerator, degrees of freedom denominator].
    #
    # Formulas extracted from:
    # https://courses.lumenlearning.com/boundless-statistics/chapter/one-way-anova/
    # http://sphweb.bumc.bu.edu/otlt/MPH-Modules/BS/BS704_HypothesisTesting-ANOVA/BS704_HypothesisTesting-Anova_print.html
    #
    # source://ruby-statistics//lib/statistics/statistical_test/f_test.rb#12
    def anova_f_score(*args); end

    # This method expects the alpha value and the groups to calculate the one-way ANOVA test.
    # It returns a hash with multiple information and the test result (if reject the null hypotesis or not).
    # Keep in mind that the values for the alternative key (true/false) does not imply that the alternative hypothesis
    # is TRUE or FALSE. It's a minor notation advantage to decide if reject the null hypothesis or not.
    #
    # source://ruby-statistics//lib/statistics/statistical_test/f_test.rb#64
    def one_way_anova(alpha, *args); end
  end
end

# Alias
#
# source://ruby-statistics//lib/statistics/statistical_test/kolmogorov_smirnov_test.rb#68
Statistics::StatisticalTest::KSTest = Statistics::StatisticalTest::KolmogorovSmirnovTest

class Statistics::StatisticalTest::KolmogorovSmirnovTest
  class << self
    # Common alpha, and critical D are calculated following formulas from: https://en.wikipedia.org/wiki/Kolmogorov%E2%80%93Smirnov_test#Two-sample_Kolmogorov%E2%80%93Smirnov_test
    #
    # source://ruby-statistics//lib/statistics/statistical_test/kolmogorov_smirnov_test.rb#5
    def two_samples(group_one:, group_two:, alpha: T.unsafe(nil)); end
  end
end

# Both test are the same. To keep the selected name, we just alias the class
# with the implementation.
#
# source://ruby-statistics//lib/statistics/statistical_test/wilcoxon_rank_sum_test.rb#93
Statistics::StatisticalTest::MannWhitneyU = Statistics::StatisticalTest::WilcoxonRankSumTest

class Statistics::StatisticalTest::TTest
  class << self
    # @raise [StandardError]
    #
    # source://ruby-statistics//lib/statistics/statistical_test/t_test.rb#62
    def paired_test(alpha, tails, left_group, right_group); end

    # Perform a T-Test for one or two samples.
    # For the tails param, we need a symbol: :one_tail or :two_tail
    #
    # source://ruby-statistics//lib/statistics/statistical_test/t_test.rb#11
    def perform(alpha, tails, *args); end
  end
end

# Errors for Zero std
class Statistics::StatisticalTest::TTest::ZeroStdError < ::StandardError; end

# source://ruby-statistics//lib/statistics/statistical_test/t_test.rb#6
Statistics::StatisticalTest::TTest::ZeroStdError::STD_ERROR_MSG = T.let(T.unsafe(nil), String)

class Statistics::StatisticalTest::WilcoxonRankSumTest
  # Steps to perform the calculation are based on http://www.mit.edu/~6.s085/notes/lecture5.pdf
  #
  # source://ruby-statistics//lib/statistics/statistical_test/wilcoxon_rank_sum_test.rb#22
  def perform(alpha, tails, group_one, group_two); end

  # source://ruby-statistics//lib/statistics/statistical_test/wilcoxon_rank_sum_test.rb#4
  def rank(elements); end

  private

  # Formula extracted from http://www.statstutor.ac.uk/resources/uploaded/mannwhitney.pdf
  #
  # source://ruby-statistics//lib/statistics/statistical_test/wilcoxon_rank_sum_test.rb#69
  def corrected_sigma(ties, total_group_one, total_group_two); end

  # source://ruby-statistics//lib/statistics/statistical_test/wilcoxon_rank_sum_test.rb#82
  def ranked_sum_for(total, group); end
end

# source://ruby-statistics//lib/statistics/version.rb#2
Statistics::VERSION = T.let(T.unsafe(nil), String)
