# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop-performance` gem.
# Please instead update this file by running `bin/tapioca gem rubocop-performance`.

module RuboCop; end
class RuboCop::ConfigNotFoundError < ::RuboCop::Error; end
module RuboCop::Cop; end

module RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

# source://rubocop/1.41.1/lib/rubocop/cop/mixin/configurable_naming.rb#10
RuboCop::Cop::ConfigurableNaming::FORMATS = T.let(T.unsafe(nil), Hash)

module RuboCop::Cop::ConfigurableNumbering
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

# source://rubocop/1.41.1/lib/rubocop/cop/mixin/configurable_numbering.rb#11
RuboCop::Cop::ConfigurableNumbering::FORMATS = T.let(T.unsafe(nil), Hash)

# source://rubocop/1.41.1/lib/rubocop/cop/mixin/allowed_methods.rb#38
RuboCop::Cop::IgnoredMethods = RuboCop::Cop::AllowedMethods

# source://rubocop/1.41.1/lib/rubocop/cop/mixin/allowed_pattern.rb#54
RuboCop::Cop::IgnoredPattern = RuboCop::Cop::AllowedPattern

module RuboCop::Cop::Performance; end

# Identifies usages of `ancestors.include?` and change them to use `<=` instead.
#
# @example
#   # bad
#   A.ancestors.include?(B)
#
#   # good
#   A <= B
class RuboCop::Cop::Performance::AncestorsInclude < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/ancestors_include.rb#26
  def ancestors_include_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/ancestors_include.rb#30
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/ancestors_include.rb#43
  def range(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/ancestors_include.rb#23
RuboCop::Cop::Performance::AncestorsInclude::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/ancestors_include.rb#24
RuboCop::Cop::Performance::AncestorsInclude::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where slicing arrays with semi-infinite ranges
# can be replaced by `Array#take` and `Array#drop`.
# This cop was created due to a mistake in microbenchmark and hence is disabled by default.
# Refer https://github.com/rubocop/rubocop-performance/pull/175#issuecomment-731892717
#
# @example
#   # bad
#   array[..2]
#   array[...2]
#   array[2..]
#   array[2...]
#   array.slice(..2)
#
#   # good
#   array.take(3)
#   array.take(2)
#   array.drop(2)
#   array.drop(2)
#   array.take(3)
class RuboCop::Cop::Performance::ArraySemiInfiniteRangeSlice < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#45
  def endless_range?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#41
  def endless_range_slice?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#52
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#65
  def correction(receiver, range_node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#36
RuboCop::Cop::Performance::ArraySemiInfiniteRangeSlice::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#39
RuboCop::Cop::Performance::ArraySemiInfiniteRangeSlice::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/array_semi_infinite_range_slice.rb#38
RuboCop::Cop::Performance::ArraySemiInfiniteRangeSlice::SLICE_METHODS = T.let(T.unsafe(nil), Set)

# Identifies places where numeric argument to BigDecimal should be
# converted to string. Initializing from String is faster
# than from Numeric for BigDecimal.
#
# @example
#   # bad
#   BigDecimal(1, 2)
#   4.to_d(6)
#   BigDecimal(1.2, 3, exception: true)
#   4.5.to_d(6, exception: true)
#
#   # good
#   BigDecimal('1', 2)
#   BigDecimal('4', 6)
#   BigDecimal('1.2', 3, exception: true)
#   BigDecimal('4.5', 6, exception: true)
class RuboCop::Cop::Performance::BigDecimalWithNumericArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/big_decimal_with_numeric_argument.rb#29
  def big_decimal_with_numeric_argument?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/big_decimal_with_numeric_argument.rb#37
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/big_decimal_with_numeric_argument.rb#33
  def to_d?(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/big_decimal_with_numeric_argument.rb#26
RuboCop::Cop::Performance::BigDecimalWithNumericArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/big_decimal_with_numeric_argument.rb#27
RuboCop::Cop::Performance::BigDecimalWithNumericArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.7, `UnboundMethod#bind_call` has been added.
#
# This cop identifies places where `bind(obj).call(args, ...)`
# can be replaced by `bind_call(obj, args, ...)`.
#
# The `bind_call(obj, args, ...)` method is faster than
# `bind(obj).call(args, ...)`.
#
# @example
#   # bad
#   umethod.bind(obj).call(foo, bar)
#   umethod.bind(obj).(foo, bar)
#
#   # good
#   umethod.bind_call(obj, foo, bar)
class RuboCop::Cop::Performance::BindCall < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#32
  def bind_with_call_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#40
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#71
  def build_call_args(call_args_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#64
  def correction_range(receiver, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#58
  def message(bind_arg, call_args); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#29
RuboCop::Cop::Performance::BindCall::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/bind_call.rb#30
RuboCop::Cop::Performance::BindCall::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies unnecessary use of a `block_given?` where explicit check
# of block argument would suffice.
#
# @example
#   # bad
#   def method(&block)
#   do_something if block_given?
#   end
#
#   # good
#   def method(&block)
#   do_something if block
#   end
#
#   # good - block is reassigned
#   def method(&block)
#   block ||= -> { do_something }
#   warn "Using default ..." unless block_given?
#   # ...
#   end
class RuboCop::Cop::Performance::BlockGivenWithExplicitBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/block_given_with_explicit_block.rb#35
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/block_given_with_explicit_block.rb#33
  def reassigns_block_arg?(param0 = T.unsafe(nil), param1); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/block_given_with_explicit_block.rb#31
RuboCop::Cop::Performance::BlockGivenWithExplicitBlock::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/block_given_with_explicit_block.rb#30
RuboCop::Cop::Performance::BlockGivenWithExplicitBlock::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `caller[n]` can be replaced by `caller(n..n).first`.
#
# @example
#   # bad
#   caller[1]
#   caller.first
#   caller_locations[1]
#   caller_locations.first
#
#   # good
#   caller(2..2).first
#   caller(1..1).first
#   caller_locations(2..2).first
#   caller_locations(1..1).first
class RuboCop::Cop::Performance::Caller < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#33
  def caller_with_scope_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#40
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#26
  def slow_caller?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#61
  def int_value(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#23
RuboCop::Cop::Performance::Caller::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/caller.rb#24
RuboCop::Cop::Performance::Caller::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Reordering `when` conditions with a splat to the end
# of the `when` branches can improve performance.
#
# Ruby has to allocate memory for the splat expansion every time
# that the `case` `when` statement is run. Since Ruby does not support
# fall through inside of `case` `when`, like some other languages do,
# the order of the `when` branches should not matter. By placing any
# splat expansions at the end of the list of `when` branches we will
# reduce the number of times that memory has to be allocated for
# the expansion. The exception to this is if multiple of your `when`
# conditions can be true for any given condition. A likely scenario for
# this defining a higher level when condition to override a condition
# that is inside of the splat expansion.
#
# @example
#   # bad
#   case foo
#   when *condition
#   bar
#   when baz
#   foobar
#   end
#
#   case foo
#   when *[1, 2, 3, 4]
#   bar
#   when 5
#   baz
#   end
#
#   # good
#   case foo
#   when baz
#   foobar
#   when *condition
#   bar
#   end
#
#   case foo
#   when 1, 2, 3, 4
#   bar
#   when 5
#   baz
#   end
class RuboCop::Cop::Performance::CaseWhenSplat < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#66
  def on_case(case_node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#83
  def autocorrect(corrector, when_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#140
  def indent_for(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#100
  def inline_fix_branch(corrector, when_node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#164
  def needs_reorder?(when_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#136
  def new_branch_without_then(node, new_condition); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#132
  def new_condition_with_then(node, new_condition); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#158
  def non_splat?(condition); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#91
  def range(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#107
  def reorder_condition(corrector, when_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#116
  def reordering_correction(when_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#95
  def replacement(conditions); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#144
  def splat_offenses(when_conditions); end

  # source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#126
  def when_branch_range(when_node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#64
RuboCop::Cop::Performance::CaseWhenSplat::ARRAY_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/case_when_splat.rb#63
RuboCop::Cop::Performance::CaseWhenSplat::MSG = T.let(T.unsafe(nil), String)

# Identifies places where a case-insensitive string comparison
# can better be implemented using `casecmp`.
#
# @example
#   # bad
#   str.downcase == 'abc'
#   str.upcase.eql? 'ABC'
#   'abc' == str.downcase
#   'ABC'.eql? str.upcase
#   str.downcase == str.downcase
#
#   # good
#   str.casecmp('ABC').zero?
#   'abc'.casecmp(str).zero?
class RuboCop::Cop::Performance::Casecmp < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#45
  def downcase_downcase(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#31
  def downcase_eq(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#38
  def eq_downcase(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#52
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#84
  def autocorrect(corrector, node, replacement); end

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#88
  def build_good_method(method, arg, variable); end

  # source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#67
  def take_method_apart(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#29
RuboCop::Cop::Performance::Casecmp::CASE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#27
RuboCop::Cop::Performance::Casecmp::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/casecmp.rb#28
RuboCop::Cop::Performance::Casecmp::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `array.compact.flatten.map { |x| x.downcase }`.
# Each of these methods (`compact`, `flatten`, `map`) will generate a new intermediate array
# that is promptly thrown away. Instead it is faster to mutate when we know it's safe.
#
# @example
#   # bad
#   array = ["a", "b", "c"]
#   array.compact.flatten.map { |x| x.downcase }
#
#   # good
#   array = ["a", "b", "c"]
#   array.compact!
#   array.flatten!
#   array.map! { |x| x.downcase }
#   array
class RuboCop::Cop::Performance::ChainArrayAllocation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#54
  def chain_array_allocation?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#62
  def on_send(node); end
end

# These methods ALWAYS return a new array
# after they're called it's safe to mutate the the resulting array
#
# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#37
RuboCop::Cop::Performance::ChainArrayAllocation::ALWAYS_RETURNS_NEW_ARRAY = T.let(T.unsafe(nil), Set)

# These methods have a mutation alternative. For example :collect
# can be called as :collect!
#
# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#45
RuboCop::Cop::Performance::ChainArrayAllocation::HAS_MUTATION_ALTERNATIVE = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#50
RuboCop::Cop::Performance::ChainArrayAllocation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#48
RuboCop::Cop::Performance::ChainArrayAllocation::RETURNS_NEW_ARRAY = T.let(T.unsafe(nil), Set)

# These methods return a new array only when called without a block.
#
# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#33
RuboCop::Cop::Performance::ChainArrayAllocation::RETURNS_NEW_ARRAY_WHEN_NO_BLOCK = T.let(T.unsafe(nil), Set)

# These methods return a new array but only sometimes. They must be
# called with an argument. For example:
#
#   [1,2].first    # => 1
#   [1,2].first(1) # => [1]
#
# source://rubocop-performance//lib/rubocop/cop/performance/chain_array_allocation.rb#30
RuboCop::Cop::Performance::ChainArrayAllocation::RETURN_NEW_ARRAY_WHEN_ARGS = T.let(T.unsafe(nil), Set)

# Identifies places where Array and Hash literals are used within loops.
# It is better to extract them into a local variable or constant
# to avoid unnecessary allocations on each iteration.
#
# You can set the minimum number of elements to consider
# an offense with `MinSize`.
#
# @example
#   # bad
#   users.select do |user|
#   %i[superadmin admin].include?(user.role)
#   end
#
#   # good
#   admin_roles = %i[superadmin admin]
#   users.select do |user|
#   admin_roles.include?(user.role)
#   end
#
#   # good
#   ADMIN_ROLES = %i[superadmin admin]
#   ...
#   users.select do |user|
#   ADMIN_ROLES.include?(user.role)
#   end
class RuboCop::Cop::Performance::CollectionLiteralInLoop < ::RuboCop::Cop::Base
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#74
  def enumerable_loop?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#68
  def kernel_loop?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#80
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#90
  def check_literal?(node, method); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#128
  def enumerable_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#110
  def keyword_loop?(type); end

  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#120
  def literal_class(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#106
  def loop?(ancestor, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#132
  def min_size; end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#114
  def node_within_enumerable_loop?(node, ancestor); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#97
  def nonmutable_method_of_array_or_hash?(node, method); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#102
  def parent_is_loop?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#56
RuboCop::Cop::Performance::CollectionLiteralInLoop::ARRAY_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#41
RuboCop::Cop::Performance::CollectionLiteralInLoop::ENUMERABLE_METHOD_NAMES = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#66
RuboCop::Cop::Performance::CollectionLiteralInLoop::HASH_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#39
RuboCop::Cop::Performance::CollectionLiteralInLoop::LOOP_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#35
RuboCop::Cop::Performance::CollectionLiteralInLoop::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#42
RuboCop::Cop::Performance::CollectionLiteralInLoop::NONMUTATING_ARRAY_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#58
RuboCop::Cop::Performance::CollectionLiteralInLoop::NONMUTATING_HASH_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/collection_literal_in_loop.rb#38
RuboCop::Cop::Performance::CollectionLiteralInLoop::POST_CONDITION_LOOP_TYPES = T.let(T.unsafe(nil), Array)

# Identifies places where `sort { |a, b| a.foo <=> b.foo }`
# can be replaced by `sort_by(&:foo)`.
# This cop also checks `max` and `min` methods.
#
# @example
#   # bad
#   array.sort { |a, b| a.foo <=> b.foo }
#   array.max { |a, b| a.foo <=> b.foo }
#   array.min { |a, b| a.foo <=> b.foo }
#   array.sort { |a, b| a[:foo] <=> b[:foo] }
#
#   # good
#   array.sort_by(&:foo)
#   array.sort_by { |v| v.foo }
#   array.sort_by do |var|
#   var.foo
#   end
#   array.max_by(&:foo)
#   array.min_by(&:foo)
#   array.sort_by { |a| a[:foo] }
class RuboCop::Cop::Performance::CompareWithBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#34
  def compare?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#48
  def on_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#41
  def replaceable_body?(param0 = T.unsafe(nil), param1, param2); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#105
  def compare_range(send, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#84
  def message(send, method, var_a, var_b, args); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#69
  def slow_compare?(method, args_a, args_b); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/compare_with_block.rb#30
RuboCop::Cop::Performance::CompareWithBlock::MSG = T.let(T.unsafe(nil), String)

# Identifies places where `Concurrent.monotonic_time`
# can be replaced by `Process.clock_gettime(Process::CLOCK_MONOTONIC)`.
#
# @example
#
#   # bad
#   Concurrent.monotonic_time
#
#   # good
#   Process.clock_gettime(Process::CLOCK_MONOTONIC)
class RuboCop::Cop::Performance::ConcurrentMonotonicTime < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/concurrent_monotonic_time.rb#23
  def concurrent_monotonic_time?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/concurrent_monotonic_time.rb#28
  def on_send(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/concurrent_monotonic_time.rb#20
RuboCop::Cop::Performance::ConcurrentMonotonicTime::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/concurrent_monotonic_time.rb#21
RuboCop::Cop::Performance::ConcurrentMonotonicTime::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Finds regular expressions with dynamic components that are all constants.
#
# Ruby allocates a new Regexp object every time it executes a code containing such
# a regular expression. It is more efficient to extract it into a constant,
# memoize it, or add an `/o` option to perform `#{}` interpolation only once and
# reuse that Regexp object.
#
# @example
#
#   # bad
#   def tokens(pattern)
#   pattern.scan(TOKEN).reject { |token| token.match?(/\A#{SEPARATORS}\Z/) }
#   end
#
#   # good
#   ALL_SEPARATORS = /\A#{SEPARATORS}\Z/
#   def tokens(pattern)
#   pattern.scan(TOKEN).reject { |token| token.match?(ALL_SEPARATORS) }
#   end
#
#   # good
#   def tokens(pattern)
#   pattern.scan(TOKEN).reject { |token| token.match?(/\A#{SEPARATORS}\Z/o) }
#   end
#
#   # good
#   def separators
#   @separators ||= /\A#{SEPARATORS}\Z/
#   end
class RuboCop::Cop::Performance::ConstantRegexp < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/constant_regexp.rb#41
  def on_regexp(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/constant_regexp.rb#55
  def regexp_escape?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/constant_regexp.rb#60
  def include_interpolated_const?(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/constant_regexp.rb#51
  def within_allowed_assignment?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/constant_regexp.rb#39
RuboCop::Cop::Performance::ConstantRegexp::MSG = T.let(T.unsafe(nil), String)

# Identifies usages of `count` on an `Enumerable` that
# follow calls to `select`, `find_all`, `filter` or `reject`. Querying logic can instead be
# passed to the `count` call.
#
# @example
#   # bad
#   [1, 2, 3].select { |e| e > 2 }.size
#   [1, 2, 3].reject { |e| e > 2 }.size
#   [1, 2, 3].select { |e| e > 2 }.length
#   [1, 2, 3].reject { |e| e > 2 }.length
#   [1, 2, 3].select { |e| e > 2 }.count { |e| e.odd? }
#   [1, 2, 3].reject { |e| e > 2 }.count { |e| e.even? }
#   array.select(&:value).count
#
#   # good
#   [1, 2, 3].count { |e| e > 2 }
#   [1, 2, 3].count { |e| e < 2 }
#   [1, 2, 3].count { |e| e > 2 && e.odd? }
#   [1, 2, 3].count { |e| e < 2 && e.even? }
#   Model.select('field AS field_one').count
#   Model.select(:value).count
class RuboCop::Cop::Performance::Count < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#56
  def count_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#63
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#79
  def autocorrect(corrector, node, selector_node, selector); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#89
  def eligible_node?(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#132
  def negate_block_pass_as_inline_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#111
  def negate_block_pass_reject(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#118
  def negate_block_reject(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#128
  def negate_expression(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#103
  def negate_reject(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/count.rb#93
  def source_starting_at(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/count.rb#53
RuboCop::Cop::Performance::Count::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/count.rb#54
RuboCop::Cop::Performance::Count::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.5, `String#delete_prefix` has been added.
#
# This cop identifies places where `gsub(/\Aprefix/, '')` and `sub(/\Aprefix/, '')`
# can be replaced by `delete_prefix('prefix')`.
#
# This cop has `SafeMultiline` configuration option that `true` by default because
# `^prefix` is unsafe as it will behave incompatible with `delete_prefix`
# for receiver is multiline string.
#
# The `delete_prefix('prefix')` method is faster than `gsub(/\Aprefix/, '')`.
#
# @example
#
#   # bad
#   str.gsub(/\Aprefix/, '')
#   str.gsub!(/\Aprefix/, '')
#
#   str.sub(/\Aprefix/, '')
#   str.sub!(/\Aprefix/, '')
#
#   # good
#   str.delete_prefix('prefix')
#   str.delete_prefix!('prefix')
# @example SafeMultiline: true (default)
#
#   # good
#   str.gsub(/^prefix/, '')
#   str.gsub!(/^prefix/, '')
#   str.sub(/^prefix/, '')
#   str.sub!(/^prefix/, '')
# @example SafeMultiline: false
#
#   # bad
#   str.gsub(/^prefix/, '')
#   str.gsub!(/^prefix/, '')
#   str.sub(/^prefix/, '')
#   str.sub!(/^prefix/, '')
class RuboCop::Cop::Performance::DeletePrefix < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RegexpMetacharacter
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/delete_prefix.rb#66
  def delete_prefix_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/delete_prefix.rb#70
  def on_send(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/delete_prefix.rb#56
RuboCop::Cop::Performance::DeletePrefix::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/delete_prefix.rb#59
RuboCop::Cop::Performance::DeletePrefix::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-performance//lib/rubocop/cop/performance/delete_prefix.rb#57
RuboCop::Cop::Performance::DeletePrefix::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.5, `String#delete_suffix` has been added.
#
# This cop identifies places where `gsub(/suffix\z/, '')` and `sub(/suffix\z/, '')`
# can be replaced by `delete_suffix('suffix')`.
#
# This cop has `SafeMultiline` configuration option that `true` by default because
# `suffix$` is unsafe as it will behave incompatible with `delete_suffix?`
# for receiver is multiline string.
#
# The `delete_suffix('suffix')` method is faster than `gsub(/suffix\z/, '')`.
#
# @example
#
#   # bad
#   str.gsub(/suffix\z/, '')
#   str.gsub!(/suffix\z/, '')
#
#   str.sub(/suffix\z/, '')
#   str.sub!(/suffix\z/, '')
#
#   # good
#   str.delete_suffix('suffix')
#   str.delete_suffix!('suffix')
# @example SafeMultiline: true (default)
#
#   # good
#   str.gsub(/suffix$/, '')
#   str.gsub!(/suffix$/, '')
#   str.sub(/suffix$/, '')
#   str.sub!(/suffix$/, '')
# @example SafeMultiline: false
#
#   # bad
#   str.gsub(/suffix$/, '')
#   str.gsub!(/suffix$/, '')
#   str.sub(/suffix$/, '')
#   str.sub!(/suffix$/, '')
class RuboCop::Cop::Performance::DeleteSuffix < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RegexpMetacharacter
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/delete_suffix.rb#66
  def delete_suffix_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/delete_suffix.rb#70
  def on_send(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/delete_suffix.rb#56
RuboCop::Cop::Performance::DeleteSuffix::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/delete_suffix.rb#59
RuboCop::Cop::Performance::DeleteSuffix::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-performance//lib/rubocop/cop/performance/delete_suffix.rb#57
RuboCop::Cop::Performance::DeleteSuffix::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `first`, `last`, `[0]` or `[-1]`
# chained to `select`, `find_all` or `filter` and change them to use
# `detect` instead.
#
# @example
#   # bad
#   [].select { |item| true }.first
#   [].select { |item| true }.last
#   [].find_all { |item| true }.first
#   [].find_all { |item| true }.last
#   [].filter { |item| true }.first
#   [].filter { |item| true }.last
#   [].filter { |item| true }[0]
#   [].filter { |item| true }[-1]
#
#   # good
#   [].detect { |item| true }
#   [].reverse.detect { |item| true }
class RuboCop::Cop::Performance::Detect < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#41
  def detect_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#50
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#69
  def accept_first_call?(receiver, body); end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#101
  def autocorrect(corrector, node, replacement); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#127
  def lazy?(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#112
  def message_for_method(method, index); end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#123
  def preferred_method; end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#78
  def register_offense(node, receiver, second_method, index); end

  # source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#93
  def replacement(method, index); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#33
RuboCop::Cop::Performance::Detect::CANDIDATE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#37
RuboCop::Cop::Performance::Detect::INDEX_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#38
RuboCop::Cop::Performance::Detect::INDEX_REVERSE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#35
RuboCop::Cop::Performance::Detect::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#39
RuboCop::Cop::Performance::Detect::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/detect.rb#36
RuboCop::Cop::Performance::Detect::REVERSE_MSG = T.let(T.unsafe(nil), String)

# Checks for double `#start_with?` or `#end_with?` calls
# separated by `||`. In some cases such calls can be replaced
# with an single `#start_with?`/`#end_with?` call.
#
# `IncludeActiveSupportAliases` configuration option is used to check for
# `starts_with?` and `ends_with?`. These methods are defined by Active Support.
#
# @example
#   # bad
#   str.start_with?("a") || str.start_with?(Some::CONST)
#   str.start_with?("a", "b") || str.start_with?("c")
#   str.end_with?(var1) || str.end_with?(var2)
#
#   # good
#   str.start_with?("a", Some::CONST)
#   str.start_with?("a", "b", "c")
#   str.end_with?(var1, var2)
# @example IncludeActiveSupportAliases: false (default)
#   # good
#   str.starts_with?("a", "b") || str.starts_with?("c")
#   str.ends_with?(var1) || str.ends_with?(var2)
#
#   str.starts_with?("a", "b", "c")
#   str.ends_with?(var1, var2)
# @example IncludeActiveSupportAliases: true
#   # bad
#   str.starts_with?("a", "b") || str.starts_with?("c")
#   str.ends_with?(var1) || str.ends_with?(var2)
#
#   # good
#   str.starts_with?("a", "b", "c")
#   str.ends_with?(var1, var2)
class RuboCop::Cop::Performance::DoubleStartEndWith < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#96
  def check_with_active_support_aliases(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#46
  def on_or(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#90
  def two_start_end_with_calls(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#60
  def autocorrect(corrector, first_call_args, second_call_args, combined_args); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#86
  def check_for_active_support_aliases?; end

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#82
  def combine_args(first_call_args, second_call_args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#76
  def message(node, receiver, method, combined_args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#68
  def process_source(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/double_start_end_with.rb#44
RuboCop::Cop::Performance::DoubleStartEndWith::MSG = T.let(T.unsafe(nil), String)

# Identifies unnecessary use of a regex where `String#end_with?` would suffice.
#
# This cop has `SafeMultiline` configuration option that `true` by default because
# `end$` is unsafe as it will behave incompatible with `end_with?`
# for receiver is multiline string.
#
# @example
#   # bad
#   'abc'.match?(/bc\Z/)
#   /bc\Z/.match?('abc')
#   'abc' =~ /bc\Z/
#   /bc\Z/ =~ 'abc'
#   'abc'.match(/bc\Z/)
#   /bc\Z/.match('abc')
#
#   # good
#   'abc'.end_with?('bc')
# @example SafeMultiline: true (default)
#
#   # good
#   'abc'.match?(/bc$/)
#   /bc$/.match?('abc')
#   'abc' =~ /bc$/
#   /bc$/ =~ 'abc'
#   'abc'.match(/bc$/)
#   /bc$/.match('abc')
# @example SafeMultiline: false
#
#   # bad
#   'abc'.match?(/bc$/)
#   /bc$/.match?('abc')
#   'abc' =~ /bc$/
#   /bc$/ =~ 'abc'
#   'abc'.match(/bc$/)
#   /bc$/.match('abc')
class RuboCop::Cop::Performance::EndWith < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RegexpMetacharacter
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/end_with.rb#62
  def on_match_with_lvasgn(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/end_with.rb#62
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/end_with.rb#56
  def redundant_regex?(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/end_with.rb#53
RuboCop::Cop::Performance::EndWith::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/end_with.rb#54
RuboCop::Cop::Performance::EndWith::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Do not compute the size of statically sized objects.
#
# @example
#   # String methods
#   # bad
#   'foo'.size
#   %q[bar].count
#   %(qux).length
#
#   # Symbol methods
#   # bad
#   :fred.size
#   :'baz'.length
#
#   # Array methods
#   # bad
#   [1, 2, thud].count
#   %W(1, 2, bar).size
#
#   # Hash methods
#   # bad
#   { a: corge, b: grault }.length
#
#   # good
#   foo.size
#   bar.count
#   qux.length
#
#   # good
#   :"#{fred}".size
#   CONST = :baz.length
#
#   # good
#   [1, 2, *thud].count
#   garply = [1, 2, 3]
#   garply.size
#
#   # good
#   { a: corge, **grault }.length
#   waldo = { a: corge, b: grault }
#   waldo.size
class RuboCop::Cop::Performance::FixedSize < ::RuboCop::Cop::Base
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#52
  def counter(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#56
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#72
  def allowed_argument?(arg); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#76
  def allowed_parent?(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#68
  def allowed_variable?(var); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#86
  def contains_double_splat?(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#80
  def contains_splat?(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#92
  def non_string_argument?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#49
RuboCop::Cop::Performance::FixedSize::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/fixed_size.rb#50
RuboCop::Cop::Performance::FixedSize::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `map { ... }.flatten` and
# change them to use `flat_map { ... }` instead.
#
# @example
#   # bad
#   [1, 2, 3, 4].map { |e| [e, e] }.flatten(1)
#   [1, 2, 3, 4].collect { |e| [e, e] }.flatten(1)
#
#   # good
#   [1, 2, 3, 4].flat_map { |e| [e, e] }
#   [1, 2, 3, 4].map { |e| [e, e] }.flatten
#   [1, 2, 3, 4].collect { |e| [e, e] }.flatten
class RuboCop::Cop::Performance::FlatMap < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#28
  def flat_map_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#39
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#71
  def autocorrect(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#52
  def offense_for_levels(node, map_node, first_method, flatten); end

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#58
  def offense_for_method(node, map_node, first_method, flatten); end

  # source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#62
  def register_offense(node, map_node, first_method, flatten, message); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#24
RuboCop::Cop::Performance::FlatMap::FLATTEN_MULTIPLE_LEVELS = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#22
RuboCop::Cop::Performance::FlatMap::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/flat_map.rb#23
RuboCop::Cop::Performance::FlatMap::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for inefficient searching of keys and values within
# hashes.
#
# `Hash#keys.include?` is less efficient than `Hash#key?` because
# the former allocates a new array and then performs an O(n) search
# through that array, while `Hash#key?` does not allocate any array and
# performs a faster O(1) search for the key.
#
# `Hash#values.include?` is less efficient than `Hash#value?`. While they
# both perform an O(n) search through all of the values, calling `values`
# allocates a new array while using `value?` does not.
#
# @example
#   # bad
#   { a: 1, b: 2 }.keys.include?(:a)
#   { a: 1, b: 2 }.keys.include?(:z)
#   h = { a: 1, b: 2 }; h.keys.include?(100)
#
#   # good
#   { a: 1, b: 2 }.key?(:a)
#   { a: 1, b: 2 }.has_key?(:z)
#   h = { a: 1, b: 2 }; h.key?(100)
#
#   # bad
#   { a: 1, b: 2 }.values.include?(2)
#   { a: 1, b: 2 }.values.include?('garbage')
#   h = { a: 1, b: 2 }; h.values.include?(nil)
#
#   # good
#   { a: 1, b: 2 }.value?(2)
#   { a: 1, b: 2 }.has_value?('garbage')
#   h = { a: 1, b: 2 }; h.value?(nil)
class RuboCop::Cop::Performance::InefficientHashSearch < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#47
  def inefficient_include?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#51
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#89
  def autocorrect_argument(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#93
  def autocorrect_hash_expression(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#73
  def autocorrect_method(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#80
  def current_method(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#69
  def message(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#84
  def use_long_method; end
end

# source://rubocop-performance//lib/rubocop/cop/performance/inefficient_hash_search.rb#45
RuboCop::Cop::Performance::InefficientHashSearch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where inefficient `readlines` method
# can be replaced by `each_line` to avoid fully loading file content into memory.
#
# @example
#
#   # bad
#   File.readlines('testfile').each { |l| puts l }
#   IO.readlines('testfile', chomp: true).each { |l| puts l }
#
#   conn.readlines(10).map { |l| l.size }
#   file.readlines.find { |l| l.start_with?('#') }
#   file.readlines.each { |l| puts l }
#
#   # good
#   File.open('testfile', 'r').each_line { |l| puts l }
#   IO.open('testfile').each_line(chomp: true) { |l| puts l }
#
#   conn.each_line(10).map { |l| l.size }
#   file.each_line.find { |l| l.start_with?('#') }
#   file.each_line { |l| puts l }
class RuboCop::Cop::Performance::IoReadlines < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#42
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#34
  def readlines_on_class?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#38
  def readlines_on_instance?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#58
  def autocorrect(corrector, enumerable_call, readlines_call, receiver); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#90
  def build_bad_method(enumerable_call); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#106
  def build_call_args(call_args_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#82
  def build_good_method(enumerable_call); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#94
  def correction_range(enumerable_call, readlines_call); end

  # source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#76
  def offense_range(enumerable_call, readlines_call); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#31
RuboCop::Cop::Performance::IoReadlines::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/io_readlines.rb#32
RuboCop::Cop::Performance::IoReadlines::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.7, `Enumerable#filter_map` has been added.
#
# This cop identifies places where `map { ... }.compact` can be replaced by `filter_map`.
#
# [source,ruby]
# ----
# [true, false, nil].compact              #=> [true, false]
# [true, false, nil].filter_map(&:itself) #=> [true]
# ----
#
# @example
#   # bad
#   ary.map(&:foo).compact
#   ary.collect(&:foo).compact
#
#   # good
#   ary.filter_map(&:foo)
#   ary.map(&:foo).compact!
#   ary.compact.map(&:foo)
class RuboCop::Cop::Performance::MapCompact < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#40
  def map_compact(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#53
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#93
  def compact_method_with_final_newline_range(compact_method_range); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#89
  def invoke_method_after_map_compact_on_same_line?(compact_node, chained_method); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#85
  def map_method_and_compact_method_on_same_line?(map_node, compact_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#67
  def remove_compact_method(corrector, map_node, compact_node, chained_method); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#81
  def use_dot?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#35
RuboCop::Cop::Performance::MapCompact::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/map_compact.rb#36
RuboCop::Cop::Performance::MapCompact::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where methods are converted to blocks, with the
# use of `&method`, and passed as arguments to method calls.
# It is faster to replace those with explicit blocks, calling those methods inside.
#
# @example
#   # bad
#   array.map(&method(:do_something))
#   [1, 2, 3].each(&out.method(:puts))
#
#   # good
#   array.map { |x| do_something(x) }
#   [1, 2, 3].each { |x| out.puts(x) }
class RuboCop::Cop::Performance::MethodObjectAsBlock < ::RuboCop::Cop::Base
  # source://rubocop-performance//lib/rubocop/cop/performance/method_object_as_block.rb#22
  def method_object_as_argument?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/method_object_as_block.rb#26
  def on_block_pass(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/method_object_as_block.rb#20
RuboCop::Cop::Performance::MethodObjectAsBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for `OpenStruct.new` calls.
# Instantiation of an `OpenStruct` invalidates
# Ruby global method cache as it causes dynamic method
# definition during program runtime.
# This could have an effect on performance,
# especially in case of single-threaded
# applications with multiple `OpenStruct` instantiations.
#
# @example
#   # bad
#   class MyClass
#   def my_method
#   OpenStruct.new(my_key1: 'my_value1', my_key2: 'my_value2')
#   end
#   end
#
#   # good
#   class MyClass
#   MyStruct = Struct.new(:my_key1, :my_key2)
#   def my_method
#   MyStruct.new('my_value1', 'my_value2')
#   end
#   end
class RuboCop::Cop::Performance::OpenStruct < ::RuboCop::Cop::Base
  # source://rubocop-performance//lib/rubocop/cop/performance/open_struct.rb#42
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/open_struct.rb#38
  def open_struct(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/open_struct.rb#35
RuboCop::Cop::Performance::OpenStruct::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/open_struct.rb#36
RuboCop::Cop::Performance::OpenStruct::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies uses of `Range#include?` and `Range#member?`, which iterates over each
# item in a `Range` to see if a specified item is there. In contrast,
# `Range#cover?` simply compares the target item with the beginning and
# end points of the `Range`. In a great majority of cases, this is what
# is wanted.
#
# @example
#   # bad
#   ('a'..'z').include?('b') # => true
#   ('a'..'z').member?('b')  # => true
#
#   # good
#   ('a'..'z').cover?('b') # => true
#
#   # Example of a case where `Range#cover?` may not provide
#   # the desired result:
#
#   ('a'..'z').cover?('yellow') # => true
class RuboCop::Cop::Performance::RangeInclude < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/range_include.rb#43
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/range_include.rb#39
  def range_include(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/range_include.rb#31
RuboCop::Cop::Performance::RangeInclude::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/range_include.rb#32
RuboCop::Cop::Performance::RangeInclude::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies the use of a `&block` parameter and `block.call`
# where `yield` would do just as well.
#
# @example
#   # bad
#   def method(&block)
#   block.call
#   end
#   def another(&func)
#   func.call 1, 2, 3
#   end
#
#   # good
#   def method
#   yield
#   end
#   def another
#   yield 1, 2, 3
#   end
class RuboCop::Cop::Performance::RedundantBlockCall < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#43
  def blockarg_assigned?(param0, param1); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#39
  def blockarg_calls(param0, param1); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#34
  def blockarg_def(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#47
  def on_def(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#47
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#97
  def args_include_block_pass?(blockcall); end

  # offenses are registered on the `block.call` nodes
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#63
  def autocorrect(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#81
  def calls_to_report(argname, body); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#91
  def shadowed_block_argument?(body, block_argument_of_method_signature); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#31
RuboCop::Cop::Performance::RedundantBlockCall::CLOSE_PAREN = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#28
RuboCop::Cop::Performance::RedundantBlockCall::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#30
RuboCop::Cop::Performance::RedundantBlockCall::OPEN_PAREN = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#32
RuboCop::Cop::Performance::RedundantBlockCall::SPACE = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_block_call.rb#29
RuboCop::Cop::Performance::RedundantBlockCall::YIELD = T.let(T.unsafe(nil), String)

# Checks for uses `Enumerable#all?`, `Enumerable#any?`, `Enumerable#one?`,
# and `Enumerable#none?` are compared with `===` or similar methods in block.
#
# By default, `Object#===` behaves the same as `Object#==`, but this
# behavior is appropriately overridden in subclass. For example,
# `Range#===` returns `true` when argument is within the range.
#
# @example
#   # bad
#   items.all? { |item| pattern === item }
#   items.all? { |item| item == other }
#   items.all? { |item| item.is_a?(Klass) }
#   items.all? { |item| item.kind_of?(Klass) }
#
#   # good
#   items.all?(pattern)
class RuboCop::Cop::Performance::RedundantEqualityComparisonBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#38
  def on_block(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#76
  def new_argument(block_argument, block_body); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#99
  def offense_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#58
  def one_block_argument?(block_arguments); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#66
  def same_block_argument_and_is_a_argument?(block_body, block_argument); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#90
  def use_block_argument_in_method_argument_of_operand?(block_argument, operand); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#62
  def use_equality_comparison_block?(block_body); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#35
RuboCop::Cop::Performance::RedundantEqualityComparisonBlock::COMPARISON_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#36
RuboCop::Cop::Performance::RedundantEqualityComparisonBlock::IS_A_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#32
RuboCop::Cop::Performance::RedundantEqualityComparisonBlock::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_equality_comparison_block.rb#34
RuboCop::Cop::Performance::RedundantEqualityComparisonBlock::TARGET_METHODS = T.let(T.unsafe(nil), Array)

# Identifies the use of `Regexp#match` or `String#match`, which
# returns `#<MatchData>`/`nil`. The return value of `=~` is an integral
# index/`nil` and is more performant.
#
# @example
#   # bad
#   do_something if str.match(/regex/)
#   while regex.match('str')
#   do_something
#   end
#
#   # good
#   method(str =~ /regex/)
#   return value unless regex =~ 'str'
class RuboCop::Cop::Performance::RedundantMatch < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#28
  def match_call?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#37
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#33
  def only_truthiness_matters?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#49
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#55
  def autocorrectable?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#23
RuboCop::Cop::Performance::RedundantMatch::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_match.rb#24
RuboCop::Cop::Performance::RedundantMatch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `Hash#merge!` can be replaced by `Hash#[]=`.
# You can set the maximum number of key-value pairs to consider
# an offense with `MaxKeyValuePairs`.
#
# @example
#   # bad
#   hash.merge!(a: 1)
#   hash.merge!({'key' => 'value'})
#
#   # good
#   hash[:a] = 1
#   hash['key'] = 'value'
# @example MaxKeyValuePairs: 2 (default)
#   # bad
#   hash.merge!(a: 1, b: 2)
#
#   # good
#   hash[:a] = 1
#   hash[:b] = 2
class RuboCop::Cop::Performance::RedundantMerge < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#47
  def modifier_flow_control?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#51
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#43
  def redundant_merge_candidate(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#105
  def correct_multiple_elements(corrector, node, parent, new_source); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#117
  def correct_single_element(corrector, node, new_source); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#78
  def each_redundant_merge(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#147
  def indent_width; end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#97
  def kwsplat_used?(pairs); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#143
  def leading_spaces(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#151
  def max_key_value_pairs; end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#70
  def message(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#86
  def non_redundant_merge?(node, receiver, pairs); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#93
  def non_redundant_pairs?(receiver, pairs); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#101
  def non_redundant_value_used?(receiver, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#131
  def rewrite_with_modifier(node, parent, new_source); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#121
  def to_assignments(receiver, pairs); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#33
RuboCop::Cop::Performance::RedundantMerge::AREF_ASGN = T.let(T.unsafe(nil), String)

# A utility class for checking the use of values within an
# `each_with_object` call.
class RuboCop::Cop::Performance::RedundantMerge::EachWithObjectInspector
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [EachWithObjectInspector] a new instance of EachWithObjectInspector
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#160
  def initialize(node, receiver); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#191
  def each_with_object_node(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#165
  def value_used?; end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#175
  def eligible_receiver?; end

  # Returns the value of attribute node.
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#173
  def node; end

  # Returns the value of attribute receiver.
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#173
  def receiver; end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#179
  def second_argument; end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#186
  def unwind(receiver); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#34
RuboCop::Cop::Performance::RedundantMerge::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#35
RuboCop::Cop::Performance::RedundantMerge::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_merge.rb#37
RuboCop::Cop::Performance::RedundantMerge::WITH_MODIFIER_CORRECTION = T.let(T.unsafe(nil), String)

# Identifies places where `sort { |a, b| a <=> b }` can be replaced with `sort`.
#
# @example
#   # bad
#   array.sort { |a, b| a <=> b }
#
#   # good
#   array.sort
class RuboCop::Cop::Performance::RedundantSortBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SortBlock
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_sort_block.rb#21
  def on_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_sort_block.rb#29
  def on_numblock(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_sort_block.rb#40
  def register_offense(send, node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_sort_block.rb#19
RuboCop::Cop::Performance::RedundantSortBlock::MSG = T.let(T.unsafe(nil), String)

# Identifies places where `split` argument can be replaced from
# a deterministic regexp to a string.
#
# @example
#   # bad
#   'a,b,c'.split(/,/)
#
#   # good
#   'a,b,c'.split(',')
class RuboCop::Cop::Performance::RedundantSplitRegexpArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#27
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#23
  def split_call_with_regexp?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#41
  def determinist_regexp?(regexp_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#45
  def replacement(regexp_node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#20
RuboCop::Cop::Performance::RedundantSplitRegexpArgument::DETERMINISTIC_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#18
RuboCop::Cop::Performance::RedundantSplitRegexpArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#19
RuboCop::Cop::Performance::RedundantSplitRegexpArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_split_regexp_argument.rb#21
RuboCop::Cop::Performance::RedundantSplitRegexpArgument::STR_SPECIAL_CHARS = T.let(T.unsafe(nil), Array)

# Checks for redundant `String#chars`.
#
# @example
#   # bad
#   str.chars[0..2]
#   str.chars.slice(0..2)
#   str.chars.last
#
#   # good
#   str[0..2].chars
#
#   # bad
#   str.chars.first
#   str.chars.first(2)
#
#   # good
#   str[0]
#   str[0...2].chars
#   str[-1]
#
#   # bad
#   str.chars.take(2)
#   str.chars.length
#   str.chars.size
#   str.chars.empty?
#
#   # good
#   str[0...2].chars
#   str.length
#   str.size
#   str.empty?
#
#   # For example, if the receiver is an empty string, it will be incompatible.
#   # If a negative value is specified for the receiver, `nil` is returned.
#   str.chars.last(2) # Incompatible with `str[-2..-1].chars`.
#   str.chars.drop(2) # Incompatible with `str[2..-1].chars`.
class RuboCop::Cop::Performance::RedundantStringChars < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#54
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#50
  def redundant_chars_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#112
  def build_bad_method(method, args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#125
  def build_call_args(call_args_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#85
  def build_good_method(method, args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#100
  def build_good_method_for_brackets_or_first_method(method, args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#79
  def build_message(method, args); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#75
  def correction_range(receiver, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#71
  def offense_range(receiver, node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#47
RuboCop::Cop::Performance::RedundantStringChars::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/redundant_string_chars.rb#48
RuboCop::Cop::Performance::RedundantStringChars::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.4, `String#match?`, `Regexp#match?`, and `Symbol#match?`
# have been added. The methods are faster than `match`.
# Because the methods avoid creating a `MatchData` object or saving
# backref.
# So, when `MatchData` is not used, use `match?` instead of `match`.
#
# @example
#   # bad
#   def foo
#   if x =~ /re/
#   do_something
#   end
#   end
#
#   # bad
#   def foo
#   if x !~ /re/
#   do_something
#   end
#   end
#
#   # bad
#   def foo
#   if x.match(/re/)
#   do_something
#   end
#   end
#
#   # bad
#   def foo
#   if /re/ === x
#   do_something
#   end
#   end
#
#   # good
#   def foo
#   if x.match?(/re/)
#   do_something
#   end
#   end
#
#   # good
#   def foo
#   if !x.match?(/re/)
#   do_something
#   end
#   end
#
#   # good
#   def foo
#   if x =~ /re/
#   do_something(Regexp.last_match)
#   end
#   end
#
#   # good
#   def foo
#   if x.match(/re/)
#   do_something($~)
#   end
#   end
#
#   # good
#   def foo
#   if /re/ === x
#   do_something($~)
#   end
#   end
class RuboCop::Cop::Performance::RegexpMatch < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#125
  def last_matches(param0); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#86
  def match_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#122
  def match_node?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#97
  def match_operator?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#101
  def match_threequals?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#93
  def match_with_int_arg_method?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#105
  def match_with_lvasgn?(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#138
  def on_case(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#134
  def on_if(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#123
  def search_match_nodes(param0); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#161
  def autocorrect(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#150
  def check_condition(cond); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#246
  def correct_operator(corrector, recv, arg, oper = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#271
  def correction_range(recv, arg); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#217
  def find_last_match(body, range, scope_root); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#177
  def last_match_used?(match_node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#242
  def match_gvar?(sym); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#173
  def message(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#213
  def modifier_form?(match_node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#199
  def next_match_pos(body, match_node_pos, scope_root); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#186
  def range_to_search_for_last_matches(match_node, body, scope_root); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#255
  def replace_with_match_predicate_method(corrector, recv, arg, op_range); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#224
  def scope_body(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#236
  def scope_root(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#266
  def swap_receiver_and_arg(corrector, recv, arg); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#112
RuboCop::Cop::Performance::RegexpMatch::MATCH_NODE_PATTERN = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#84
RuboCop::Cop::Performance::RegexpMatch::MSG = T.let(T.unsafe(nil), String)

# Constants are included in this list because it is unlikely that
# someone will store `nil` as a constant and then use it for comparison
#
# source://rubocop-performance//lib/rubocop/cop/performance/regexp_match.rb#83
RuboCop::Cop::Performance::RegexpMatch::TYPES_IMPLEMENTING_MATCH = T.let(T.unsafe(nil), Array)

# Identifies usages of `reverse.each` and change them to use `reverse_each` instead.
#
# If the return value is used, it will not be detected because the result will be different.
#
# [source,ruby]
# ----
# [1, 2, 3].reverse.each {} #=> [3, 2, 1]
# [1, 2, 3].reverse_each {} #=> [1, 2, 3]
# ----
#
# @example
#   # bad
#   items.reverse.each
#
#   # good
#   items.reverse_each
class RuboCop::Cop::Performance::ReverseEach < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#33
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#29
  def reverse_each?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#53
  def offense_range(node); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#47
  def use_return_value?(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#26
RuboCop::Cop::Performance::ReverseEach::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/reverse_each.rb#27
RuboCop::Cop::Performance::ReverseEach::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `reverse.first(n)` and `reverse.first`
# can be replaced by `last(n).reverse` and `last`.
#
# @example
#
#   # bad
#   array.reverse.first(5)
#   array.reverse.first
#
#   # good
#   array.last(5).reverse
#   array.last
class RuboCop::Cop::Performance::ReverseFirst < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#30
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#26
  def reverse_first_candidate?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#63
  def build_bad_method(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#55
  def build_good_method(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#49
  def build_message(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#45
  def correction_range(receiver, node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#23
RuboCop::Cop::Performance::ReverseFirst::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/reverse_first.rb#24
RuboCop::Cop::Performance::ReverseFirst::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.7, `Enumerable#filter_map` has been added.
#
# This cop identifies places where `select.map` can be replaced by `filter_map`.
#
# @example
#   # bad
#   ary.select(&:foo).map(&:bar)
#   ary.filter(&:foo).map(&:bar)
#
#   # good
#   ary.filter_map { |o| o.bar if o.foo }
class RuboCop::Cop::Performance::SelectMap < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#27
  def bad_method?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#31
  def on_send(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#44
  def map_method_candidate(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#54
  def offense_range(node, map_method); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#24
RuboCop::Cop::Performance::SelectMap::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/select_map.rb#25
RuboCop::Cop::Performance::SelectMap::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies usages of `count` on an `Array` and `Hash` and change them to `size`.
#
# TODO: Add advanced detection of variables that could
# have been assigned to an array or a hash.
#
# @example
#   # bad
#   [1, 2, 3].count
#   (1..3).to_a.count
#   Array[*1..3].count
#   Array(1..3).count
#
#   # bad
#   {a: 1, b: 2, c: 3}.count
#   [[:foo, :bar], [1, 2]].to_h.count
#   Hash[*('a'..'z')].count
#   Hash(key: :value).count
#
#   # good
#   [1, 2, 3].size
#   (1..3).to_a.size
#   Array[*1..3].size
#   Array(1..3).size
#
#   # good
#   {a: 1, b: 2, c: 3}.size
#   [[:foo, :bar], [1, 2]].to_h.size
#   Hash[*('a'..'z')].size
#   Hash(key: :value).size
#
#   # good
#   [1, 2, 3].count { |e| e > 2 }
class RuboCop::Cop::Performance::Size < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/size.rb#43
  def array?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/size.rb#61
  def count?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/size.rb#52
  def hash?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/size.rb#65
  def on_send(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/size.rb#40
RuboCop::Cop::Performance::Size::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/size.rb#41
RuboCop::Cop::Performance::Size::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `sort { |a, b| b <=> a }`
# can be replaced by a faster `sort.reverse`.
#
# @example
#   # bad
#   array.sort { |a, b| b <=> a }
#
#   # good
#   array.sort.reverse
class RuboCop::Cop::Performance::SortReverse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SortBlock
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/sort_reverse.rb#22
  def on_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sort_reverse.rb#30
  def on_numblock(node); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/sort_reverse.rb#42
  def register_offense(send, node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/sort_reverse.rb#20
RuboCop::Cop::Performance::SortReverse::MSG = T.let(T.unsafe(nil), String)

# Identifies places where `gsub(/a+/, 'a')` and `gsub!(/a+/, 'a')`
# can be replaced by `squeeze('a')` and `squeeze!('a')`.
#
# The `squeeze('a')` method is faster than `gsub(/a+/, 'a')`.
#
# @example
#
#   # bad
#   str.gsub(/a+/, 'a')
#   str.gsub!(/a+/, 'a')
#
#   # good
#   str.squeeze('a')
#   str.squeeze!('a')
class RuboCop::Cop::Performance::Squeeze < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#38
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#29
  def squeeze_candidate?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#58
  def repeating_literal?(regex_str); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#24
RuboCop::Cop::Performance::Squeeze::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#27
RuboCop::Cop::Performance::Squeeze::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop-performance//lib/rubocop/cop/performance/squeeze.rb#25
RuboCop::Cop::Performance::Squeeze::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies unnecessary use of a regex where `String#start_with?` would suffice.
#
# This cop has `SafeMultiline` configuration option that `true` by default because
# `^start` is unsafe as it will behave incompatible with `start_with?`
# for receiver is multiline string.
#
# @example
#   # bad
#   'abc'.match?(/\Aab/)
#   /\Aab/.match?('abc')
#   'abc' =~ /\Aab/
#   /\Aab/ =~ 'abc'
#   'abc'.match(/\Aab/)
#   /\Aab/.match('abc')
#
#   # good
#   'abc'.start_with?('ab')
# @example SafeMultiline: true (default)
#
#   # good
#   'abc'.match?(/^ab/)
#   /^ab/.match?('abc')
#   'abc' =~ /^ab/
#   /^ab/ =~ 'abc'
#   'abc'.match(/^ab/)
#   /^ab/.match('abc')
# @example SafeMultiline: false
#
#   # bad
#   'abc'.match?(/^ab/)
#   /^ab/.match?('abc')
#   'abc' =~ /^ab/
#   /^ab/ =~ 'abc'
#   'abc'.match(/^ab/)
#   /^ab/.match('abc')
class RuboCop::Cop::Performance::StartWith < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RegexpMetacharacter
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/start_with.rb#62
  def on_match_with_lvasgn(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/start_with.rb#62
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/start_with.rb#56
  def redundant_regex?(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/start_with.rb#53
RuboCop::Cop::Performance::StartWith::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/start_with.rb#54
RuboCop::Cop::Performance::StartWith::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where string identifier argument can be replaced
# by symbol identifier argument.
# It prevents the redundancy of the internal string-to-symbol conversion.
#
# This cop targets methods that take identifier (e.g. method name) argument
# and the following examples are parts of it.
#
# @example
#
#   # bad
#   send('do_something')
#   attr_accessor 'do_something'
#   instance_variable_get('@ivar')
#
#   # good
#   send(:do_something)
#   attr_accessor :do_something
#   instance_variable_get(:@ivar)
class RuboCop::Cop::Performance::StringIdentifierArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/string_identifier_argument.rb#46
  def on_send(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/string_identifier_argument.rb#28
RuboCop::Cop::Performance::StringIdentifierArgument::MSG = T.let(T.unsafe(nil), String)

# NOTE: `attr` method is not included in this list as it can cause false positives in Nokogiri API.
# And `attr` may not be used because `Style/Attr` registers an offense.
# https://github.com/rubocop/rubocop-performance/issues/278
#
# source://rubocop-performance//lib/rubocop/cop/performance/string_identifier_argument.rb#33
RuboCop::Cop::Performance::StringIdentifierArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies unnecessary use of a regex where `String#include?` would suffice.
#
# @example
#   # bad
#   'abc'.match?(/ab/)
#   /ab/.match?('abc')
#   'abc' =~ /ab/
#   /ab/ =~ 'abc'
#   'abc'.match(/ab/)
#   /ab/.match('abc')
#
#   # good
#   'abc'.include?('ab')
class RuboCop::Cop::Performance::StringInclude < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#34
  def on_match_with_lvasgn(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#34
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#28
  def redundant_regex?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#53
  def literal?(regex_str); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#25
RuboCop::Cop::Performance::StringInclude::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/string_include.rb#26
RuboCop::Cop::Performance::StringInclude::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `gsub` can be replaced by `tr` or `delete`.
#
# @example
#   # bad
#   'abc'.gsub('b', 'd')
#   'abc'.gsub('a', '')
#   'abc'.gsub(/a/, 'd')
#   'abc'.gsub!('a', 'd')
#
#   # good
#   'abc'.gsub(/.*/, 'a')
#   'abc'.gsub(/a+/, 'd')
#   'abc'.tr('b', 'd')
#   'a b c'.delete(' ')
class RuboCop::Cop::Performance::StringReplacement < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#37
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#31
  def string_replacement?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#83
  def accept_first_param?(first_param); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#78
  def accept_second_param?(second_param); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#59
  def autocorrect(corrector, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#99
  def first_source(first_param); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#142
  def message(node, first_source, second_source); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#148
  def method_suffix(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#48
  def offense(node, first_param, second_param); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#128
  def range(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#152
  def remove_second_param(corrector, node, first_param); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#69
  def replace_method(corrector, node, first_source, second_source, first_param); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#132
  def replacement_method(node, first_source, second_source); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#117
  def source_from_regex_constructor(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#110
  def source_from_regex_literal(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#29
RuboCop::Cop::Performance::StringReplacement::BANG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#27
RuboCop::Cop::Performance::StringReplacement::DELETE = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#26
RuboCop::Cop::Performance::StringReplacement::DETERMINISTIC_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#24
RuboCop::Cop::Performance::StringReplacement::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#25
RuboCop::Cop::Performance::StringReplacement::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-performance//lib/rubocop/cop/performance/string_replacement.rb#28
RuboCop::Cop::Performance::StringReplacement::TR = T.let(T.unsafe(nil), String)

# Identifies places where custom code finding the sum of elements
# in some Enumerable object can be replaced by `Enumerable#sum` method.
#
# @example OnlySumOrWithInitialValue: false (default)
#   # bad
#   [1, 2, 3].inject(:+)                        # Autocorrections for cases without initial value are unsafe
#   [1, 2, 3].inject(&:+)                       # and will only be performed when using the `-A` option.
#   [1, 2, 3].reduce { |acc, elem| acc + elem } # They can be prohibited completely using `SafeAutoCorrect: true`.
#   [1, 2, 3].reduce(10, :+)
#   [1, 2, 3].map { |elem| elem ** 2 }.sum
#   [1, 2, 3].collect(&:count).sum(10)
#
#   # good
#   [1, 2, 3].sum
#   [1, 2, 3].sum(10)
#   [1, 2, 3].sum { |elem| elem ** 2 }
#   [1, 2, 3].sum(10, &:count)
# @example OnlySumOrWithInitialValue: true
#   # bad
#   [1, 2, 3].reduce(10, :+)
#   [1, 2, 3].map { |elem| elem ** 2 }.sum
#   [1, 2, 3].collect(&:count).sum(10)
#
#   # good
#   [1, 2, 3].sum(10)
#   [1, 2, 3].sum { |elem| elem ** 2 }
#   [1, 2, 3].sum(10, &:count)
class RuboCop::Cop::Performance::Sum < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#102
  def acc_plus_elem?(param0 = T.unsafe(nil), param1, param2); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#102
  def elem_plus_acc?(param0 = T.unsafe(nil), param1, param2); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#114
  def on_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#107
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#82
  def sum_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#86
  def sum_map_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#95
  def sum_with_block_candidate?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#159
  def array_literal?(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#164
  def autocorrect(corrector, init, range); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#172
  def autocorrect_sum_map(corrector, sum, map, init); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#248
  def build_block_bad_method(method, init, var_acc, var_elem, body); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#215
  def build_block_message(send, init, var_acc, var_elem, body); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#221
  def build_good_method(init, block_pass = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#234
  def build_method_bad_method(init, method, operation); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#197
  def build_method_message(node, method, init, operation); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#208
  def build_sum_map_message(method, init); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#154
  def empty_array_literal?(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#129
  def handle_sum_candidate(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#142
  def handle_sum_map_candidate(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#259
  def method_call_with_args_range(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#193
  def sum_block_range(send, node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#189
  def sum_map_range(map, sum); end

  # source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#185
  def sum_method_range(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#77
RuboCop::Cop::Performance::Sum::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#78
RuboCop::Cop::Performance::Sum::MSG_IF_NO_INIT_VALUE = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/sum.rb#80
RuboCop::Cop::Performance::Sum::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for .times.map calls.
# In most cases such calls can be replaced
# with an explicit array creation.
#
# @example
#   # bad
#   9.times.map do |i|
#   i.to_s
#   end
#
#   # good
#   Array.new(9) do |i|
#   i.to_s
#   end
class RuboCop::Cop::Performance::TimesMap < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#43
  def on_block(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#43
  def on_numblock(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#39
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#69
  def times_map_call(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#50
  def check(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#60
  def message(map_or_collect, count); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#35
RuboCop::Cop::Performance::TimesMap::MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#36
RuboCop::Cop::Performance::TimesMap::MESSAGE_ONLY_IF = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/times_map.rb#37
RuboCop::Cop::Performance::TimesMap::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 2.3 or later, use unary plus operator to unfreeze a string
# literal instead of `String#dup` and `String.new`.
# Unary plus operator is faster than `String#dup`.
#
# @example
#   # bad
#   ''.dup
#   "something".dup
#   String.new
#   String.new('')
#   String.new('something')
#
#   # good
#   +'something'
#   +''
class RuboCop::Cop::Performance::UnfreezeString < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#33
  def dup_string?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#44
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#37
  def string_new?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#57
  def string_value(node); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#30
RuboCop::Cop::Performance::UnfreezeString::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/unfreeze_string.rb#31
RuboCop::Cop::Performance::UnfreezeString::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `URI::Parser.new` can be replaced by `URI::DEFAULT_PARSER`.
#
# @example
#   # bad
#   URI::Parser.new
#
#   # good
#   URI::DEFAULT_PARSER
class RuboCop::Cop::Performance::UriDefaultParser < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-performance//lib/rubocop/cop/performance/uri_default_parser.rb#27
  def on_send(node); end

  # source://rubocop-performance//lib/rubocop/cop/performance/uri_default_parser.rb#21
  def uri_parser_new?(param0 = T.unsafe(nil)); end
end

# source://rubocop-performance//lib/rubocop/cop/performance/uri_default_parser.rb#18
RuboCop::Cop::Performance::UriDefaultParser::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-performance//lib/rubocop/cop/performance/uri_default_parser.rb#19
RuboCop::Cop::Performance::UriDefaultParser::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Common functionality for handling regexp metacharacters.
module RuboCop::Cop::RegexpMetacharacter
  private

  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#63
  def drop_end_metacharacter(regexp_string); end

  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#55
  def drop_start_metacharacter(regexp_string); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#15
  def literal_at_end?(regexp); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#41
  def literal_at_end_with_backslash_z?(regex_str); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#48
  def literal_at_end_with_dollar?(regex_str); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#9
  def literal_at_start?(regexp); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#21
  def literal_at_start_with_backslash_a?(regex_str); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#31
  def literal_at_start_with_caret?(regex_str); end

  # @return [Boolean]
  #
  # source://rubocop-performance//lib/rubocop/cop/mixin/regexp_metacharacter.rb#71
  def safe_multiline?; end
end

# Common functionality for cops checking `Enumerable#sort` blocks.
module RuboCop::Cop::SortBlock
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop-performance//lib/rubocop/cop/mixin/sort_block.rb#24
  def replaceable_body?(param0 = T.unsafe(nil), param1, param2); end

  # source://rubocop-performance//lib/rubocop/cop/mixin/sort_block.rb#10
  def sort_with_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-performance//lib/rubocop/cop/mixin/sort_block.rb#17
  def sort_with_numblock?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-performance//lib/rubocop/cop/mixin/sort_block.rb#30
  def sort_range(send, node); end
end

class RuboCop::Error < ::StandardError; end
class RuboCop::IncorrectCopNameError < ::StandardError; end

# source://rubocop/1.41.1/lib/rubocop/ast_aliases.rb#5
RuboCop::NodePattern = RuboCop::AST::NodePattern

class RuboCop::OptionArgumentError < ::StandardError; end
module RuboCop::OptionsHelp; end

# source://rubocop/1.41.1/lib/rubocop/options.rb#470
RuboCop::OptionsHelp::FORMATTER_OPTION_LIST = T.let(T.unsafe(nil), Array)

# source://rubocop/1.41.1/lib/rubocop/options.rb#469
RuboCop::OptionsHelp::MAX_EXCL = T.let(T.unsafe(nil), String)

# source://rubocop/1.41.1/lib/rubocop/options.rb#472
RuboCop::OptionsHelp::TEXT = T.let(T.unsafe(nil), Hash)

# RuboCop Performance project namespace
module RuboCop::Performance; end

# source://rubocop-performance//lib/rubocop/performance.rb#8
RuboCop::Performance::CONFIG = T.let(T.unsafe(nil), Hash)

# source://rubocop-performance//lib/rubocop/performance.rb#7
RuboCop::Performance::CONFIG_DEFAULT = T.let(T.unsafe(nil), Pathname)

# Because RuboCop doesn't yet support plugins, we have to monkey patch in a
# bit of our configuration.
module RuboCop::Performance::Inject
  class << self
    # source://rubocop-performance//lib/rubocop/performance/inject.rb#8
    def defaults!; end
  end
end

# source://rubocop-performance//lib/rubocop/performance.rb#6
RuboCop::Performance::PROJECT_ROOT = T.let(T.unsafe(nil), Pathname)

# This module holds the RuboCop Performance version information.
module RuboCop::Performance::Version
  class << self
    # source://rubocop-performance//lib/rubocop/performance/version.rb#9
    def document_version; end
  end
end

# source://rubocop-performance//lib/rubocop/performance/version.rb#7
RuboCop::Performance::Version::STRING = T.let(T.unsafe(nil), String)

# source://rubocop/1.41.1/lib/rubocop/ast_aliases.rb#6
RuboCop::ProcessedSource = RuboCop::AST::ProcessedSource

# source://rubocop/1.41.1/lib/rubocop/ast_aliases.rb#7
RuboCop::Token = RuboCop::AST::Token

class RuboCop::ValidationError < ::RuboCop::Error; end
class RuboCop::Warning < ::StandardError; end
