# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `redis` gem.
# Please instead update this file by running `bin/tapioca gem redis`.

class Redis
  include ::Redis::Commands::Bitmaps
  include ::Redis::Commands::Cluster
  include ::Redis::Commands::Connection
  include ::Redis::Commands::Geo
  include ::Redis::Commands::Hashes
  include ::Redis::Commands::HyperLogLog
  include ::Redis::Commands::Keys
  include ::Redis::Commands::Lists
  include ::Redis::Commands::Pubsub
  include ::Redis::Commands::Scripting
  include ::Redis::Commands::Server
  include ::Redis::Commands::Sets
  include ::Redis::Commands::SortedSets
  include ::Redis::Commands::Streams
  include ::Redis::Commands::Strings
  include ::Redis::Commands::Transactions
  include ::Redis::Commands

  # Create a new client instance
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [Redis] a new client instance
  #
  # source://redis//lib/redis.rb#83
  def initialize(options = T.unsafe(nil)); end

  # source://redis//lib/redis.rb#160
  def _client; end

  # Disconnect the client as quickly and silently as possible.
  #
  # source://redis//lib/redis.rb#110
  def close; end

  # See http://redis.io/topics/pipelining for more details.
  #
  # @deprecated Sends all commands in the queue.
  #
  # source://redis//lib/redis.rb#140
  def commit; end

  # Test whether or not the client is connected
  #
  # @return [Boolean]
  #
  # source://redis//lib/redis.rb#105
  def connected?; end

  # source://redis//lib/redis.rb#250
  def connection; end

  # Disconnect the client as quickly and silently as possible.
  #
  # source://redis//lib/redis.rb#110
  def disconnect!; end

  # source://redis//lib/redis.rb#246
  def dup; end

  # source://redis//lib/redis.rb#238
  def id; end

  # source://redis//lib/redis.rb#242
  def inspect; end

  # Mark the start of a transaction block.
  #
  # Passing a block is optional.
  #
  # @example With a block
  #   redis.multi do |multi|
  #   multi.set("key", "value")
  #   multi.incr("counter")
  #   end # => ["OK", 6]
  # @example Without a block
  #   redis.multi
  #   # => "OK"
  #   redis.set("key", "value")
  #   # => "QUEUED"
  #   redis.incr("counter")
  #   # => "QUEUED"
  #   redis.exec
  #   # => ["OK", 6]
  # @return [String, Array<...>] - when a block is not given, `OK`
  #   - when a block is given, an array with replies
  # @see #watch
  # @see #unwatch
  # @yield [multi] the commands that are called inside this block are cached
  #   and written to the server upon returning from it
  # @yieldparam multi [Redis] `self`
  #
  # source://redis//lib/redis.rb#214
  def multi(&block); end

  # source://redis//lib/redis.rb#164
  def pipelined(&block); end

  # Commands in the queue are executed with the Redis#commit method.
  #
  # See http://redis.io/topics/pipelining for more details.
  #
  # @deprecated Queues a command for pipelining.
  #
  # source://redis//lib/redis.rb#125
  def queue(*command); end

  # @yield [_self]
  # @yieldparam _self [Redis] the object that the method was called on
  #
  # source://redis//lib/redis.rb#115
  def with; end

  # Run code with the client reconnecting
  #
  # source://redis//lib/redis.rb#93
  def with_reconnect(val = T.unsafe(nil), &blk); end

  # Run code without the client reconnecting
  #
  # source://redis//lib/redis.rb#100
  def without_reconnect(&blk); end

  private

  # source://redis//lib/redis.rb#280
  def _subscription(method, timeout, channels, block); end

  # source://redis//lib/redis.rb#274
  def send_blocking_command(command, timeout, &block); end

  # source://redis//lib/redis.rb#268
  def send_command(command, &block); end

  # source://redis//lib/redis.rb#264
  def synchronize; end

  class << self
    # source://redis//lib/redis.rb#40
    def current; end

    # source://redis//lib/redis.rb#45
    def current=(redis); end

    # source://redis//lib/redis.rb#30
    def deprecate!(message); end

    # Returns the value of attribute exists_returns_integer.
    #
    # source://redis//lib/redis.rb#15
    def exists_returns_integer; end

    # source://redis//lib/redis.rb#18
    def exists_returns_integer=(value); end

    # Returns the value of attribute raise_deprecations.
    #
    # source://redis//lib/redis.rb#16
    def raise_deprecations; end

    # Sets the attribute raise_deprecations
    #
    # @param value the value to set the attribute raise_deprecations to.
    #
    # source://redis//lib/redis.rb#16
    def raise_deprecations=(_arg0); end

    # Returns the value of attribute sadd_returns_boolean.
    #
    # source://redis//lib/redis.rb#16
    def sadd_returns_boolean; end

    # Sets the attribute sadd_returns_boolean
    #
    # @param value the value to set the attribute sadd_returns_boolean to.
    #
    # source://redis//lib/redis.rb#16
    def sadd_returns_boolean=(_arg0); end

    # Returns the value of attribute silence_deprecations.
    #
    # source://redis//lib/redis.rb#16
    def silence_deprecations; end

    # Sets the attribute silence_deprecations
    #
    # @param value the value to set the attribute silence_deprecations to.
    #
    # source://redis//lib/redis.rb#16
    def silence_deprecations=(_arg0); end
  end
end

# source://redis//lib/redis.rb#8
Redis::BASE_PATH = T.let(T.unsafe(nil), String)

# Base error for connection related errors.
class Redis::BaseConnectionError < ::Redis::BaseError; end

# Base error for all redis-rb errors.
class Redis::BaseError < ::RuntimeError; end

# Raised when connection to a Redis server cannot be made.
class Redis::CannotConnectError < ::Redis::BaseConnectionError; end

class Redis::Client
  # @return [Client] a new instance of Client
  #
  # source://redis//lib/redis/client.rb#91
  def initialize(options = T.unsafe(nil)); end

  # source://redis//lib/redis/client.rb#160
  def call(command); end

  # source://redis//lib/redis/client.rb#171
  def call_loop(command, timeout = T.unsafe(nil)); end

  # source://redis//lib/redis/client.rb#195
  def call_pipeline(pipeline); end

  # source://redis//lib/redis/client.rb#214
  def call_pipelined(pipeline); end

  # source://redis//lib/redis/client.rb#254
  def call_with_timeout(command, extra_timeout, &blk); end

  # source://redis//lib/redis/client.rb#263
  def call_without_timeout(command, &blk); end

  # source://redis//lib/redis/client.rb#288
  def close; end

  # Returns the value of attribute command_map.
  #
  # source://redis//lib/redis/client.rb#35
  def command_map; end

  # source://redis//lib/redis/client.rb#110
  def connect; end

  # source://redis//lib/redis/client.rb#57
  def connect_timeout; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/client.rb#284
  def connected?; end

  # Returns the value of attribute connection.
  #
  # source://redis//lib/redis/client.rb#35
  def connection; end

  # source://redis//lib/redis/client.rb#73
  def db; end

  # source://redis//lib/redis/client.rb#77
  def db=(db); end

  # source://redis//lib/redis/client.rb#288
  def disconnect; end

  # source://redis//lib/redis/client.rb#81
  def driver; end

  # source://redis//lib/redis/client.rb#41
  def host; end

  # source://redis//lib/redis/client.rb#152
  def id; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/client.rb#85
  def inherit_socket?; end

  # source://redis//lib/redis/client.rb#298
  def io; end

  # source://redis//lib/redis/client.rb#156
  def location; end

  # Returns the value of attribute logger.
  #
  # source://redis//lib/redis/client.rb#89
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://redis//lib/redis/client.rb#89
  def logger=(_arg0); end

  # Returns the value of attribute options.
  #
  # source://redis//lib/redis/client.rb#35
  def options; end

  # source://redis//lib/redis/client.rb#69
  def password; end

  # source://redis//lib/redis/client.rb#49
  def path; end

  # source://redis//lib/redis/client.rb#45
  def port; end

  # source://redis//lib/redis/client.rb#267
  def process(commands); end

  # source://redis//lib/redis/client.rb#309
  def read; end

  # source://redis//lib/redis/client.rb#53
  def read_timeout; end

  # source://redis//lib/redis/client.rb#293
  def reconnect; end

  # source://redis//lib/redis/client.rb#37
  def scheme; end

  # source://redis//lib/redis/client.rb#61
  def timeout; end

  # source://redis//lib/redis/client.rb#65
  def username; end

  # source://redis//lib/redis/client.rb#342
  def with_reconnect(val = T.unsafe(nil)); end

  # source://redis//lib/redis/client.rb#324
  def with_socket_timeout(timeout); end

  # source://redis//lib/redis/client.rb#349
  def without_reconnect(&blk); end

  # source://redis//lib/redis/client.rb#338
  def without_socket_timeout(&blk); end

  # source://redis//lib/redis/client.rb#317
  def write(command); end

  protected

  # source://redis//lib/redis/client.rb#538
  def _parse_driver(driver); end

  # source://redis//lib/redis/client.rb#439
  def _parse_options(options); end

  # source://redis//lib/redis/client.rb#401
  def ensure_connected; end

  # source://redis//lib/redis/client.rb#379
  def establish_connection; end

  # source://redis//lib/redis/client.rb#355
  def logging(commands); end
end

class Redis::Client::Connector
  # @return [Connector] a new instance of Connector
  #
  # source://redis//lib/redis/client.rb#559
  def initialize(options); end

  # source://redis//lib/redis/client.rb#567
  def check(client); end

  # source://redis//lib/redis/client.rb#563
  def resolve; end
end

class Redis::Client::Connector::Sentinel < ::Redis::Client::Connector
  # @return [Sentinel] a new instance of Sentinel
  #
  # source://redis//lib/redis/client.rb#570
  def initialize(options); end

  # source://redis//lib/redis/client.rb#580
  def check(client); end

  # source://redis//lib/redis/client.rb#597
  def resolve; end

  # source://redis//lib/redis/client.rb#637
  def resolve_master; end

  # source://redis//lib/redis/client.rb#645
  def resolve_slave; end

  # @raise [CannotConnectError]
  #
  # source://redis//lib/redis/client.rb#610
  def sentinel_detect; end
end

# Defaults are also used for converting string keys to symbols.
#
# source://redis//lib/redis/client.rb#10
Redis::Client::DEFAULTS = T.let(T.unsafe(nil), Hash)

class Redis::Cluster
  # @return [Cluster] a new instance of Cluster
  #
  # source://redis//lib/redis/cluster.rb#24
  def initialize(options = T.unsafe(nil)); end

  # source://redis//lib/redis/cluster.rb#71
  def call(command, &block); end

  # source://redis//lib/redis/cluster.rb#75
  def call_loop(command, timeout = T.unsafe(nil), &block); end

  # source://redis//lib/redis/cluster.rb#80
  def call_pipeline(pipeline); end

  # source://redis//lib/redis/cluster.rb#90
  def call_with_timeout(command, timeout, &block); end

  # source://redis//lib/redis/cluster.rb#95
  def call_without_timeout(command, &block); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster.rb#46
  def connected?; end

  # source://redis//lib/redis/cluster.rb#55
  def connection_info; end

  # db feature is disabled in cluster mode
  #
  # source://redis//lib/redis/cluster.rb#35
  def db; end

  # db feature is disabled in cluster mode
  #
  # source://redis//lib/redis/cluster.rb#40
  def db=(_db); end

  # source://redis//lib/redis/cluster.rb#50
  def disconnect; end

  # source://redis//lib/redis/cluster.rb#30
  def id; end

  # source://redis//lib/redis/cluster.rb#99
  def process(commands, &block); end

  # source://redis//lib/redis/cluster.rb#42
  def timeout; end

  # source://redis//lib/redis/cluster.rb#67
  def with_reconnect(val = T.unsafe(nil), &block); end

  private

  # source://redis//lib/redis/cluster.rb#242
  def _scan(command, &block); end

  # source://redis//lib/redis/cluster.rb#272
  def assign_asking_node(err_msg); end

  # source://redis//lib/redis/cluster.rb#277
  def assign_node(command); end

  # source://redis//lib/redis/cluster.rb#265
  def assign_redirection_node(err_msg); end

  # source://redis//lib/redis/cluster.rb#114
  def fetch_cluster_info!(option); end

  # source://redis//lib/redis/cluster.rb#125
  def fetch_command_details(nodes); end

  # source://redis//lib/redis/cluster.rb#296
  def find_node(node_key); end

  # source://redis//lib/redis/cluster.rb#282
  def find_node_key(command, primary_only: T.unsafe(nil)); end

  # source://redis//lib/redis/cluster.rb#175
  def send_client_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#184
  def send_cluster_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#130
  def send_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#159
  def send_config_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#167
  def send_memory_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#205
  def send_pubsub_command(command, &block); end

  # source://redis//lib/redis/cluster.rb#195
  def send_script_command(command, &block); end

  # @see https://redis.io/topics/cluster-spec#redirection-and-resharding Redirection and resharding
  #
  # source://redis//lib/redis/cluster.rb#218
  def try_send(node, method_name, *args, retry_count: T.unsafe(nil), &block); end

  # source://redis//lib/redis/cluster.rb#305
  def update_cluster_info!(node_key = T.unsafe(nil)); end
end

# Raised when cluster client can't select node.
class Redis::Cluster::AmbiguousNodeError < ::Redis::BaseError
  # @return [AmbiguousNodeError] a new instance of AmbiguousNodeError
  #
  # source://redis//lib/redis/errors.rb#84
  def initialize(command); end
end

# Keep details about Redis commands for Redis Cluster Client.
#
# @see https://redis.io/commands/command
class Redis::Cluster::Command
  # @return [Command] a new instance of Command
  #
  # source://redis//lib/redis/cluster/command.rb#10
  def initialize(details); end

  # source://redis//lib/redis/cluster/command.rb#14
  def extract_first_key(command); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/command.rb#23
  def should_send_to_master?(command); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/command.rb#27
  def should_send_to_slave?(command); end

  private

  # source://redis//lib/redis/cluster/command.rb#50
  def determine_first_key_position(command); end

  # source://redis//lib/redis/cluster/command.rb#63
  def determine_optional_key_position(command, option_name); end

  # source://redis//lib/redis/cluster/command.rb#43
  def dig_details(command, key); end

  # @see https://redis.io/topics/cluster-spec#keys-hash-tags Keys hash tags
  #
  # source://redis//lib/redis/cluster/command.rb#69
  def extract_hash_tag(key); end

  # source://redis//lib/redis/cluster/command.rb#33
  def pick_details(details); end
end

# Raised when error occurs on any node of cluster.
class Redis::Cluster::CommandErrorCollection < ::Redis::BaseError
  # @param errors [Hash{String => Redis::CommandError}]
  # @param error_message [String]
  # @return [CommandErrorCollection] a new instance of CommandErrorCollection
  #
  # source://redis//lib/redis/errors.rb#76
  def initialize(errors, error_message = T.unsafe(nil)); end

  # Returns the value of attribute errors.
  #
  # source://redis//lib/redis/errors.rb#72
  def errors; end
end

# Load details about Redis commands for Redis Cluster Client
#
# @see https://redis.io/commands/command
module Redis::Cluster::CommandLoader
  private

  # source://redis//lib/redis/cluster/command_loader.rb#24
  def fetch_command_details(node); end

  # source://redis//lib/redis/cluster/command_loader.rb#12
  def load(nodes); end

  class << self
    # @raise [InitialSetupError]
    #
    # source://redis//lib/redis/cluster/command_loader.rb#12
    def load(nodes); end

    private

    # source://redis//lib/redis/cluster/command_loader.rb#24
    def fetch_command_details(node); end
  end
end

# Raised when commands in pipelining include cross slot keys.
class Redis::Cluster::CrossSlotPipeliningError < ::Redis::BaseError
  # @return [CrossSlotPipeliningError] a new instance of CrossSlotPipeliningError
  #
  # source://redis//lib/redis/errors.rb#91
  def initialize(keys); end
end

# Raised when client connected to redis as cluster mode
# and failed to fetch cluster state information by commands.
class Redis::Cluster::InitialSetupError < ::Redis::BaseError
  # @param errors [Array<Redis::BaseError>]
  # @return [InitialSetupError] a new instance of InitialSetupError
  #
  # source://redis//lib/redis/errors.rb#52
  def initialize(errors); end
end

module Redis::Cluster::KeySlotConverter
  private

  # Convert key into slot.
  #
  # @param key [String] the key of the redis command
  # @return [Integer] slot number
  #
  # source://redis//lib/redis/cluster/key_slot_converter.rb#62
  def convert(key); end

  class << self
    # Convert key into slot.
    #
    # @param key [String] the key of the redis command
    # @return [Integer] slot number
    #
    # source://redis//lib/redis/cluster/key_slot_converter.rb#62
    def convert(key); end
  end
end

# source://redis//lib/redis/cluster/key_slot_converter.rb#53
Redis::Cluster::KeySlotConverter::HASH_SLOTS = T.let(T.unsafe(nil), Integer)

# source://redis//lib/redis/cluster/key_slot_converter.rb#18
Redis::Cluster::KeySlotConverter::XMODEM_CRC16_LOOKUP = T.let(T.unsafe(nil), Array)

# Keep client list of node for Redis Cluster Client
class Redis::Cluster::Node
  include ::Enumerable

  # @return [Node] a new instance of Node
  #
  # source://redis//lib/redis/cluster/node.rb#15
  def initialize(options, node_flags = T.unsafe(nil), with_replica = T.unsafe(nil)); end

  # source://redis//lib/redis/cluster/node.rb#35
  def call_all(command, &block); end

  # source://redis//lib/redis/cluster/node.rb#39
  def call_master(command, &block); end

  # source://redis//lib/redis/cluster/node.rb#47
  def call_slave(command, &block); end

  # source://redis//lib/redis/cluster/node.rb#21
  def each(&block); end

  # source://redis//lib/redis/cluster/node.rb#29
  def find_by(node_key); end

  # source://redis//lib/redis/cluster/node.rb#57
  def process_all(commands, &block); end

  # source://redis//lib/redis/cluster/node.rb#25
  def sample; end

  # source://redis//lib/redis/cluster/node.rb#61
  def scale_reading_clients; end

  private

  # source://redis//lib/redis/cluster/node.rb#87
  def build_clients(options); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/node.rb#79
  def master?(node_key); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/node.rb#75
  def replica_disabled?; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/node.rb#83
  def slave?(node_key); end

  # @raise [CommandErrorCollection]
  #
  # source://redis//lib/redis/cluster/node.rb#100
  def try_map; end
end

# source://redis//lib/redis/cluster/node.rb#13
Redis::Cluster::Node::ROLE_SLAVE = T.let(T.unsafe(nil), String)

class Redis::Cluster::Node::ReloadNeeded < ::StandardError; end

# Node key's format is `<ip>:<port>`.
# It is different from node id.
# Node id is internal identifying code in Redis Cluster.
module Redis::Cluster::NodeKey
  private

  # source://redis//lib/redis/cluster/node_key.rb#26
  def build_from_host_port(host, port); end

  # source://redis//lib/redis/cluster/node_key.rb#22
  def build_from_uri(uri); end

  # source://redis//lib/redis/cluster/node_key.rb#13
  def optionize(node_key); end

  # source://redis//lib/redis/cluster/node_key.rb#18
  def split(node_key); end

  class << self
    # source://redis//lib/redis/cluster/node_key.rb#26
    def build_from_host_port(host, port); end

    # source://redis//lib/redis/cluster/node_key.rb#22
    def build_from_uri(uri); end

    # source://redis//lib/redis/cluster/node_key.rb#13
    def optionize(node_key); end

    # source://redis//lib/redis/cluster/node_key.rb#18
    def split(node_key); end
  end
end

# source://redis//lib/redis/cluster/node_key.rb#9
Redis::Cluster::NodeKey::DELIMITER = T.let(T.unsafe(nil), String)

# Load and hashify node info for Redis Cluster Client
module Redis::Cluster::NodeLoader
  private

  # source://redis//lib/redis/cluster/node_loader.rb#23
  def fetch_node_info(node); end

  # source://redis//lib/redis/cluster/node_loader.rb#11
  def load_flags(nodes); end

  class << self
    # @raise [InitialSetupError]
    #
    # source://redis//lib/redis/cluster/node_loader.rb#11
    def load_flags(nodes); end

    private

    # source://redis//lib/redis/cluster/node_loader.rb#23
    def fetch_node_info(node); end
  end
end

# Keep options for Redis Cluster Client
class Redis::Cluster::Option
  # @return [Option] a new instance of Option
  #
  # source://redis//lib/redis/cluster/option.rb#15
  def initialize(options); end

  # source://redis//lib/redis/cluster/option.rb#44
  def add_node(host, port); end

  # source://redis//lib/redis/cluster/option.rb#27
  def per_node_key; end

  # source://redis//lib/redis/cluster/option.rb#40
  def update_node(addrs); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/option.rb#36
  def use_replica?; end

  private

  # Redis cluster node returns only host and port information.
  # So we should complement additional information such as:
  #   scheme, username, password and so on.
  #
  # source://redis//lib/redis/cluster/option.rb#93
  def add_common_node_option_if_needed(options, node_opts, key); end

  # @raise [InvalidClientOptionError]
  #
  # source://redis//lib/redis/cluster/option.rb#50
  def build_node_options(addrs); end

  # source://redis//lib/redis/cluster/option.rb#56
  def parse_node_addr(addr); end

  # source://redis//lib/redis/cluster/option.rb#81
  def parse_node_option(addr); end

  # source://redis//lib/redis/cluster/option.rb#67
  def parse_node_url(addr); end
end

# source://redis//lib/redis/cluster/option.rb#11
Redis::Cluster::Option::DEFAULT_SCHEME = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/cluster/option.rb#12
Redis::Cluster::Option::SECURE_SCHEME = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/cluster/option.rb#13
Redis::Cluster::Option::VALID_SCHEMES = T.let(T.unsafe(nil), Array)

# Raised when client connected to redis as cluster mode
# and some cluster subcommands were called.
class Redis::Cluster::OrchestrationCommandNotSupported < ::Redis::BaseError
  # @return [OrchestrationCommandNotSupported] a new instance of OrchestrationCommandNotSupported
  #
  # source://redis//lib/redis/errors.rb#60
  def initialize(command, subcommand = T.unsafe(nil)); end
end

# Keep slot and node key map for Redis Cluster Client
class Redis::Cluster::Slot
  # @return [Slot] a new instance of Slot
  #
  # source://redis//lib/redis/cluster/slot.rb#9
  def initialize(available_slots, node_flags = T.unsafe(nil), with_replica = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/slot.rb#15
  def exists?(slot); end

  # source://redis//lib/redis/cluster/slot.rb#19
  def find_node_key_of_master(slot); end

  # source://redis//lib/redis/cluster/slot.rb#25
  def find_node_key_of_slave(slot); end

  # source://redis//lib/redis/cluster/slot.rb#32
  def put(slot, node_key); end

  private

  # available_slots is mapping of node_key to list of slot ranges
  #
  # source://redis//lib/redis/cluster/slot.rb#61
  def build_slot_node_key_map(available_slots); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/slot.rb#52
  def master?(node_key); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/slot.rb#48
  def replica_disabled?; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/cluster/slot.rb#56
  def slave?(node_key); end
end

# source://redis//lib/redis/cluster/slot.rb#7
Redis::Cluster::Slot::ROLE_SLAVE = T.let(T.unsafe(nil), String)

# Load and hashify slot info for Redis Cluster Client
module Redis::Cluster::SlotLoader
  private

  # source://redis//lib/redis/cluster/slot_loader.rb#24
  def fetch_slot_info(node); end

  # source://redis//lib/redis/cluster/slot_loader.rb#12
  def load(nodes); end

  # source://redis//lib/redis/cluster/slot_loader.rb#31
  def parse_slot_info(arr, default_ip:); end

  # source://redis//lib/redis/cluster/slot_loader.rb#37
  def stringify_node_key(arr, default_ip); end

  class << self
    # @raise [InitialSetupError]
    #
    # source://redis//lib/redis/cluster/slot_loader.rb#12
    def load(nodes); end

    private

    # source://redis//lib/redis/cluster/slot_loader.rb#24
    def fetch_slot_info(node); end

    # source://redis//lib/redis/cluster/slot_loader.rb#31
    def parse_slot_info(arr, default_ip:); end

    # source://redis//lib/redis/cluster/slot_loader.rb#37
    def stringify_node_key(arr, default_ip); end
  end
end

# Raised by the client when command execution returns an error reply.
class Redis::CommandError < ::Redis::BaseError; end

module Redis::Commands
  include ::Redis::Commands::Bitmaps
  include ::Redis::Commands::Cluster
  include ::Redis::Commands::Connection
  include ::Redis::Commands::Geo
  include ::Redis::Commands::Hashes
  include ::Redis::Commands::HyperLogLog
  include ::Redis::Commands::Keys
  include ::Redis::Commands::Lists
  include ::Redis::Commands::Pubsub
  include ::Redis::Commands::Scripting
  include ::Redis::Commands::Server
  include ::Redis::Commands::Sets
  include ::Redis::Commands::SortedSets
  include ::Redis::Commands::Streams
  include ::Redis::Commands::Strings
  include ::Redis::Commands::Transactions

  # Sends a command to Redis and returns its reply.
  #
  # Replies are converted to Ruby objects according to the RESP protocol, so
  # you can expect a Ruby array, integer or nil when Redis sends one. Higher
  # level transformations, such as converting an array of pairs into a Ruby
  # hash, are up to consumers.
  #
  # Redis error replies are raised as Ruby exceptions.
  #
  # source://redis//lib/redis/commands.rb#205
  def call(*command); end

  # Interact with the sentinel command (masters, master, slaves, failover)
  #
  # @param subcommand [String] e.g. `masters`, `master`, `slaves`
  # @param args [Array<String>] depends on subcommand
  # @return [Array<String>, Hash<String, String>, String] depends on subcommand
  #
  # source://redis//lib/redis/commands.rb#214
  def sentinel(subcommand, *args); end

  private

  # source://redis//lib/redis/commands.rb#236
  def method_missing(*command); end
end

module Redis::Commands::Bitmaps
  # Count the number of set bits in a range of the string value stored at key.
  #
  # @param key [String]
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @return [Integer] the number of bits set to 1
  #
  # source://redis//lib/redis/commands/bitmaps.rb#31
  def bitcount(key, start = T.unsafe(nil), stop = T.unsafe(nil)); end

  # Perform a bitwise operation between strings and store the resulting string in a key.
  #
  # @param operation [String] e.g. `and`, `or`, `xor`, `not`
  # @param destkey [String] destination key
  # @param keys [String, Array<String>] one or more source keys to perform `operation`
  # @return [Integer] the length of the string stored in `destkey`
  #
  # source://redis//lib/redis/commands/bitmaps.rb#41
  def bitop(operation, destkey, *keys); end

  # Return the position of the first bit set to 1 or 0 in a string.
  #
  # @param key [String]
  # @param bit [Integer] whether to look for the first 1 or 0 bit
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @raise [ArgumentError]
  # @return [Integer] the position of the first 1/0 bit.
  #   -1 if looking for 1 and it is not found or start and stop are given.
  #
  # source://redis//lib/redis/commands/bitmaps.rb#53
  def bitpos(key, bit, start = T.unsafe(nil), stop = T.unsafe(nil)); end

  # Returns the bit value at offset in the string value stored at key.
  #
  # @param key [String]
  # @param offset [Integer] bit offset
  # @return [Integer] `0` or `1`
  #
  # source://redis//lib/redis/commands/bitmaps.rb#21
  def getbit(key, offset); end

  # Sets or clears the bit at offset in the string value stored at key.
  #
  # @param key [String]
  # @param offset [Integer] bit offset
  # @param value [Integer] bit value `0` or `1`
  # @return [Integer] the original bit value stored at `offset`
  #
  # source://redis//lib/redis/commands/bitmaps.rb#12
  def setbit(key, offset, value); end
end

# Commands returning 1 for true and 0 for false may be executed in a pipeline
# where the method call will return nil. Propagate the nil instead of falsely
# returning false.
#
# source://redis//lib/redis/commands.rb#42
Redis::Commands::Boolify = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#51
Redis::Commands::BoolifySet = T.let(T.unsafe(nil), Proc)

module Redis::Commands::Cluster
  # Sends `ASKING` command to random node and returns its reply.
  #
  # @return [String] `'OK'`
  # @see https://redis.io/topics/cluster-spec#ask-redirection ASK redirection
  #
  # source://redis//lib/redis/commands/cluster.rb#40
  def asking; end

  # Sends `CLUSTER *` command to random node and returns its reply.
  #
  # @param subcommand [String, Symbol] the subcommand of cluster command
  #   e.g. `:slots`, `:nodes`, `:slaves`, `:info`
  # @return [Object] depends on the subcommand
  # @see https://redis.io/commands#cluster Reference of cluster command
  #
  # source://redis//lib/redis/commands/cluster.rb#14
  def cluster(subcommand, *args); end
end

module Redis::Commands::Connection
  # Authenticate to the server.
  #
  # @param args [Array<String>] includes both username and password
  #   or only password
  # @return [String] `OK`
  # @see https://redis.io/commands/auth AUTH command
  #
  # source://redis//lib/redis/commands/connection.rb#12
  def auth(*args); end

  # Echo the given string.
  #
  # @param value [String]
  # @return [String]
  #
  # source://redis//lib/redis/commands/connection.rb#28
  def echo(value); end

  # Ping the server.
  #
  # @param message [optional, String]
  # @return [String] `PONG`
  #
  # source://redis//lib/redis/commands/connection.rb#20
  def ping(message = T.unsafe(nil)); end

  # Close the connection.
  #
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/connection.rb#46
  def quit; end

  # Change the selected database for the current connection.
  #
  # @param db [Integer] zero-based index of the DB to use (0 to 15)
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/connection.rb#36
  def select(db); end
end

# source://redis//lib/redis/commands.rb#115
Redis::Commands::EMPTY_STREAM_RESPONSE = T.let(T.unsafe(nil), Array)

# source://redis//lib/redis/commands.rb#78
Redis::Commands::Floatify = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#91
Redis::Commands::FloatifyPairs = T.let(T.unsafe(nil), Proc)

module Redis::Commands::Geo
  # Adds the specified geospatial items (latitude, longitude, name) to the specified key
  #
  # @param key [String]
  # @param member [Array] arguemnts for member or members: longitude, latitude, name
  # @return [Integer] number of elements added to the sorted set
  #
  # source://redis//lib/redis/commands/geo.rb#11
  def geoadd(key, *member); end

  # Returns the distance between two members of a geospatial index
  #
  # @param key [String]
  # @param members [Array<String>]
  # @param unit ['m', 'km', 'mi', 'ft']
  # @return [String, nil] returns distance in spefied unit if both members present, nil otherwise.
  #
  # source://redis//lib/redis/commands/geo.rb#70
  def geodist(key, member1, member2, unit = T.unsafe(nil)); end

  # Returns geohash string representing position for specified members of the specified key.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member or array of members
  # @return [Array<String, nil>] returns array containg geohash string if member is present, nil otherwise
  #
  # source://redis//lib/redis/commands/geo.rb#20
  def geohash(key, member); end

  # Returns longitude and latitude of members of a geospatial index
  #
  # @param key [String]
  # @param member [String, Array<String>] one member or array of members
  # @return [Array<Array<String>, nil>] returns array of elements, where each
  #   element is either array of longitude and latitude or nil
  #
  # source://redis//lib/redis/commands/geo.rb#60
  def geopos(key, member); end

  # Query a sorted set representing a geospatial index to fetch members matching a
  # given maximum distance from a point
  #
  # @param args [Array] key, longitude, latitude, radius, unit(m|km|ft|mi)
  # @param sort ['asc', 'desc'] sort returned items from the nearest to the farthest
  #   or the farthest to the nearest relative to the center
  # @param count [Integer] limit the results to the first N matching items
  # @param options ['WITHDIST', 'WITHCOORD', 'WITHHASH'] to return additional information
  # @return [Array<String>] may be changed with `options`
  #
  # source://redis//lib/redis/commands/geo.rb#33
  def georadius(*args, **geoptions); end

  # Query a sorted set representing a geospatial index to fetch members matching a
  # given maximum distance from an already existing member
  #
  # @param args [Array] key, member, radius, unit(m|km|ft|mi)
  # @param sort ['asc', 'desc'] sort returned items from the nearest to the farthest or the farthest
  #   to the nearest relative to the center
  # @param count [Integer] limit the results to the first N matching items
  # @param options ['WITHDIST', 'WITHCOORD', 'WITHHASH'] to return additional information
  # @return [Array<String>] may be changed with `options`
  #
  # source://redis//lib/redis/commands/geo.rb#48
  def georadiusbymember(*args, **geoptions); end

  private

  # source://redis//lib/redis/commands/geo.rb#76
  def _geoarguments(*args, options: T.unsafe(nil), sort: T.unsafe(nil), count: T.unsafe(nil)); end
end

module Redis::Commands::Hashes
  # Delete one or more hash fields.
  #
  # @param key [String]
  # @param field [String, Array<String>]
  # @return [Integer] the number of fields that were removed from the hash
  #
  # source://redis//lib/redis/commands/hashes.rb#154
  def hdel(key, *fields); end

  # Determine if a hash field exists.
  #
  # @param key [String]
  # @param field [String]
  # @return [Boolean] whether or not the field exists in the hash
  #
  # source://redis//lib/redis/commands/hashes.rb#163
  def hexists(key, field); end

  # Get the value of a hash field.
  #
  # @param key [String]
  # @param field [String]
  # @return [String]
  #
  # source://redis//lib/redis/commands/hashes.rb#74
  def hget(key, field); end

  # Get all the fields and values in a hash.
  #
  # @param key [String]
  # @return [Hash<String, String>]
  #
  # source://redis//lib/redis/commands/hashes.rb#207
  def hgetall(key); end

  # Increment the integer value of a hash field by the given integer number.
  #
  # @param key [String]
  # @param field [String]
  # @param increment [Integer]
  # @return [Integer] value of the field after incrementing it
  #
  # source://redis//lib/redis/commands/hashes.rb#173
  def hincrby(key, field, increment); end

  # Increment the numeric value of a hash field by the given float number.
  #
  # @param key [String]
  # @param field [String]
  # @param increment [Float]
  # @return [Float] value of the field after incrementing it
  #
  # source://redis//lib/redis/commands/hashes.rb#183
  def hincrbyfloat(key, field, increment); end

  # Get all the fields in a hash.
  #
  # @param key [String]
  # @return [Array<String>]
  #
  # source://redis//lib/redis/commands/hashes.rb#191
  def hkeys(key); end

  # Get the number of fields in a hash.
  #
  # @param key [String]
  # @return [Integer] number of fields in the hash
  #
  # source://redis//lib/redis/commands/hashes.rb#10
  def hlen(key); end

  # Get the values of all the given hash fields.
  #
  # @example
  #   redis.hmget("hash", "f1", "f2")
  #   # => ["v1", "v2"]
  # @param key [String]
  # @param fields [Array<String>] array of fields
  # @return [Array<String>] an array of values for the specified fields
  # @see #mapped_hmget
  #
  # source://redis//lib/redis/commands/hashes.rb#89
  def hmget(key, *fields, &blk); end

  # Set one or more hash values.
  #
  # @example
  #   redis.hmset("hash", "f1", "v1", "f2", "v2")
  #   # => "OK"
  # @param key [String]
  # @param attrs [Array<String>] array of fields and values
  # @return [String] `"OK"`
  # @see #mapped_hmset
  #
  # source://redis//lib/redis/commands/hashes.rb#50
  def hmset(key, *attrs); end

  # Get one or more random fields from a hash.
  #
  # @example Get one random field
  #   redis.hrandfield("hash")
  #   # => "f1"
  # @example Get multiple random fields
  #   redis.hrandfield("hash", 2)
  #   # => ["f1, "f2"]
  # @example Get multiple random fields with values
  #   redis.hrandfield("hash", 2, with_values: true)
  #   # => [["f1", "s1"], ["f2", "s2"]]
  # @param key [String]
  # @param count [Integer]
  # @param options [Hash] - `:with_values => true`: include values in output
  # @return [nil, String, Array<String>, Array<[String, Float]>] - when `key` does not exist, `nil`
  #   - when `count` is not specified, a field name
  #   - when `count` is specified and `:with_values` is not specified, an array of field names
  #   - when `:with_values` is specified, an array with `[field, value]` pairs
  #
  # source://redis//lib/redis/commands/hashes.rb#136
  def hrandfield(key, count = T.unsafe(nil), withvalues: T.unsafe(nil), with_values: T.unsafe(nil)); end

  # Scan a hash
  #
  # @example Retrieve the first batch of key/value pairs in a hash
  #   redis.hscan("hash", 0)
  # @param cursor [String, Integer] the cursor of the iteration
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [String, Array<[String, String]>] the next cursor and all found keys
  #
  # source://redis//lib/redis/commands/hashes.rb#222
  def hscan(key, cursor, **options); end

  # Scan a hash
  #
  # @example Retrieve all of the key/value pairs in a hash
  #   redis.hscan_each("hash").to_a
  #   # => [["key70", "70"], ["key80", "80"]]
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [Enumerator] an enumerator for all found keys
  #
  # source://redis//lib/redis/commands/hashes.rb#239
  def hscan_each(key, **options, &block); end

  # Set one or more hash values.
  #
  # @example
  #   redis.hset("hash", "f1", "v1", "f2", "v2") # => 2
  #   redis.hset("hash", { "f1" => "v1", "f2" => "v2" }) # => 2
  # @param key [String]
  # @param attrs [Array<String> | Hash<String, String>] array or hash of fields and values
  # @return [Integer] The number of fields that were added to the hash
  #
  # source://redis//lib/redis/commands/hashes.rb#23
  def hset(key, *attrs); end

  # Set the value of a hash field, only if the field does not exist.
  #
  # @param key [String]
  # @param field [String]
  # @param value [String]
  # @return [Boolean] whether or not the field was **added** to the hash
  #
  # source://redis//lib/redis/commands/hashes.rb#35
  def hsetnx(key, field, value); end

  # Get all the values in a hash.
  #
  # @param key [String]
  # @return [Array<String>]
  #
  # source://redis//lib/redis/commands/hashes.rb#199
  def hvals(key); end

  # Get the values of all the given hash fields.
  #
  # @example
  #   redis.mapped_hmget("hash", "f1", "f2")
  #   # => { "f1" => "v1", "f2" => "v2" }
  # @param key [String]
  # @param fields [Array<String>] array of fields
  # @return [Hash] a hash mapping the specified fields to their values
  # @see #hmget
  #
  # source://redis//lib/redis/commands/hashes.rb#104
  def mapped_hmget(key, *fields); end

  # Set one or more hash values.
  #
  # @example
  #   redis.mapped_hmset("hash", { "f1" => "v1", "f2" => "v2" })
  #   # => "OK"
  # @param key [String]
  # @param hash [Hash] a non-empty hash with fields mapping to values
  # @return [String] `"OK"`
  # @see #hmset
  #
  # source://redis//lib/redis/commands/hashes.rb#65
  def mapped_hmset(key, hash); end
end

# source://redis//lib/redis/commands.rb#62
Redis::Commands::Hashify = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#158
Redis::Commands::HashifyClusterNodeInfo = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#187
Redis::Commands::HashifyClusterNodes = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#191
Redis::Commands::HashifyClusterSlaves = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#173
Redis::Commands::HashifyClusterSlots = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#99
Redis::Commands::HashifyInfo = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#124
Redis::Commands::HashifyStreamAutoclaim = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#131
Redis::Commands::HashifyStreamAutoclaimJustId = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#118
Redis::Commands::HashifyStreamEntries = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#147
Redis::Commands::HashifyStreamPendingDetails = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#138
Redis::Commands::HashifyStreamPendings = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#106
Redis::Commands::HashifyStreams = T.let(T.unsafe(nil), Proc)

module Redis::Commands::HyperLogLog
  # Add one or more members to a HyperLogLog structure.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member, or array of members
  # @return [Boolean] true if at least 1 HyperLogLog internal register was altered. false otherwise.
  #
  # source://redis//lib/redis/commands/hyper_log_log.rb#11
  def pfadd(key, member); end

  # Get the approximate cardinality of members added to HyperLogLog structure.
  #
  # If called with multiple keys, returns the approximate cardinality of the
  # union of the HyperLogLogs contained in the keys.
  #
  # @param keys [String, Array<String>]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/hyper_log_log.rb#22
  def pfcount(*keys); end

  # Merge multiple HyperLogLog values into an unique value that will approximate the cardinality of the union of
  # the observed Sets of the source HyperLogLog structures.
  #
  # @param dest_key [String] destination key
  # @param source_key [String, Array<String>] source key, or array of keys
  # @return [Boolean]
  #
  # source://redis//lib/redis/commands/hyper_log_log.rb#32
  def pfmerge(dest_key, *source_key); end
end

module Redis::Commands::Keys
  # source://redis//lib/redis/commands/keys.rb#269
  def _exists(*keys); end

  # Copy a value from one key to another.
  #
  # @example Copy a value to another key
  #   redis.set "foo", "value"
  #   # => "OK"
  #   redis.copy "foo", "bar"
  #   # => true
  #   redis.get "bar"
  #   # => "value"
  # @example Copy a value to a key in another database
  #   redis.set "foo", "value"
  #   # => "OK"
  #   redis.copy "foo", "bar", db: 2
  #   # => true
  #   redis.select 2
  #   # => "OK"
  #   redis.get "bar"
  #   # => "value"
  # @param source [String]
  # @param destination [String]
  # @param db [Integer]
  # @param replace [Boolean] removes the `destination` key before copying value to it
  # @return [Boolean] whether the key was copied or not
  #
  # source://redis//lib/redis/commands/keys.rb#345
  def copy(source, destination, db: T.unsafe(nil), replace: T.unsafe(nil)); end

  # Delete one or more keys.
  #
  # @param keys [String, Array<String>]
  # @return [Integer] number of keys that were deleted
  #
  # source://redis//lib/redis/commands/keys.rb#232
  def del(*keys); end

  # Return a serialized version of the value stored at a key.
  #
  # @param key [String]
  # @return [String] serialized_value
  #
  # source://redis//lib/redis/commands/keys.rb#183
  def dump(key); end

  # Determine how many of the keys exists.
  #
  # @param keys [String, Array<String>]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/keys.rb#251
  def exists(*keys); end

  # Determine if any of the keys exists.
  #
  # @param keys [String, Array<String>]
  # @return [Boolean]
  #
  # source://redis//lib/redis/commands/keys.rb#277
  def exists?(*keys); end

  # Set a key's time to live in seconds.
  #
  # @param key [String]
  # @param seconds [Integer] time to live
  # @param options [Hash] - `:nx => true`: Set expiry only when the key has no expiry.
  #   - `:xx => true`: Set expiry only when the key has an existing expiry.
  #   - `:gt => true`: Set expiry only when the new expiry is greater than current one.
  #   - `:lt => true`: Set expiry only when the new expiry is less than current one.
  # @return [Boolean] whether the timeout was set or not
  #
  # source://redis//lib/redis/commands/keys.rb#78
  def expire(key, seconds, nx: T.unsafe(nil), xx: T.unsafe(nil), gt: T.unsafe(nil), lt: T.unsafe(nil)); end

  # Set the expiration for a key as a UNIX timestamp.
  #
  # @param key [String]
  # @param unix_time [Integer] expiry time specified as a UNIX timestamp
  # @param options [Hash] - `:nx => true`: Set expiry only when the key has no expiry.
  #   - `:xx => true`: Set expiry only when the key has an existing expiry.
  #   - `:gt => true`: Set expiry only when the new expiry is greater than current one.
  #   - `:lt => true`: Set expiry only when the new expiry is less than current one.
  # @return [Boolean] whether the timeout was set or not
  #
  # source://redis//lib/redis/commands/keys.rb#98
  def expireat(key, unix_time, nx: T.unsafe(nil), xx: T.unsafe(nil), gt: T.unsafe(nil), lt: T.unsafe(nil)); end

  # Find all keys matching the given pattern.
  #
  # @param pattern [String]
  # @return [Array<String>]
  #
  # source://redis//lib/redis/commands/keys.rb#287
  def keys(pattern = T.unsafe(nil)); end

  # Transfer a key from the connected instance to another instance.
  #
  # @param key [String, Array<String>]
  # @param options [Hash] - `:host => String`: host of instance to migrate to
  #   - `:port => Integer`: port of instance to migrate to
  #   - `:db => Integer`: database to migrate to (default: same as source)
  #   - `:timeout => Integer`: timeout (default: same as connection timeout)
  #   - `:copy => Boolean`: Do not remove the key from the local instance.
  #   - `:replace => Boolean`: Replace existing key on the remote instance.
  # @return [String] `"OK"`
  #
  # source://redis//lib/redis/commands/keys.rb#214
  def migrate(key, options); end

  # Move a key to another database.
  #
  # @example Move a key to another database
  #   redis.set "foo", "bar"
  #   # => "OK"
  #   redis.move "foo", 2
  #   # => true
  #   redis.exists "foo"
  #   # => false
  #   redis.select 2
  #   # => "OK"
  #   redis.exists "foo"
  #   # => true
  #   redis.get "foo"
  #   # => "bar"
  # @param key [String]
  # @param db [Integer]
  # @return [Boolean] whether the key was moved or not
  #
  # source://redis//lib/redis/commands/keys.rb#316
  def move(key, db); end

  # source://redis//lib/redis/commands/keys.rb#353
  def object(*args); end

  # Remove the expiration from a key.
  #
  # @param key [String]
  # @return [Boolean] whether the timeout was removed or not
  #
  # source://redis//lib/redis/commands/keys.rb#64
  def persist(key); end

  # Set a key's time to live in milliseconds.
  #
  # @param key [String]
  # @param milliseconds [Integer] time to live
  # @param options [Hash] - `:nx => true`: Set expiry only when the key has no expiry.
  #   - `:xx => true`: Set expiry only when the key has an existing expiry.
  #   - `:gt => true`: Set expiry only when the new expiry is greater than current one.
  #   - `:lt => true`: Set expiry only when the new expiry is less than current one.
  # @return [Boolean] whether the timeout was set or not
  #
  # source://redis//lib/redis/commands/keys.rb#134
  def pexpire(key, milliseconds, nx: T.unsafe(nil), xx: T.unsafe(nil), gt: T.unsafe(nil), lt: T.unsafe(nil)); end

  # Set the expiration for a key as number of milliseconds from UNIX Epoch.
  #
  # @param key [String]
  # @param ms_unix_time [Integer] expiry time specified as number of milliseconds from UNIX Epoch.
  # @param options [Hash] - `:nx => true`: Set expiry only when the key has no expiry.
  #   - `:xx => true`: Set expiry only when the key has an existing expiry.
  #   - `:gt => true`: Set expiry only when the new expiry is greater than current one.
  #   - `:lt => true`: Set expiry only when the new expiry is less than current one.
  # @return [Boolean] whether the timeout was set or not
  #
  # source://redis//lib/redis/commands/keys.rb#154
  def pexpireat(key, ms_unix_time, nx: T.unsafe(nil), xx: T.unsafe(nil), gt: T.unsafe(nil), lt: T.unsafe(nil)); end

  # Get the time to live (in milliseconds) for a key.
  #
  # In Redis 2.6 or older the command returns -1 if the key does not exist or if
  # the key exist but has no associated expire.
  #
  # Starting with Redis 2.8 the return value in case of error changed:
  #
  #     - The command returns -2 if the key does not exist.
  #     - The command returns -1 if the key exists but has no associated expire.
  #
  # @param key [String]
  # @return [Integer] remaining time to live in milliseconds
  #
  # source://redis//lib/redis/commands/keys.rb#175
  def pttl(key); end

  # Return a random key from the keyspace.
  #
  # @return [String]
  #
  # source://redis//lib/redis/commands/keys.rb#360
  def randomkey; end

  # Rename a key. If the new key already exists it is overwritten.
  #
  # @param old_name [String]
  # @param new_name [String]
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/keys.rb#369
  def rename(old_name, new_name); end

  # Rename a key, only if the new key does not exist.
  #
  # @param old_name [String]
  # @param new_name [String]
  # @return [Boolean] whether the key was renamed or not
  #
  # source://redis//lib/redis/commands/keys.rb#378
  def renamenx(old_name, new_name); end

  # Create a key using the serialized value, previously obtained using DUMP.
  #
  # @param key [String]
  # @param ttl [String]
  # @param serialized_value [String]
  # @param options [Hash] - `:replace => Boolean`: if false, raises an error if key already exists
  # @raise [Redis::CommandError]
  # @return [String] `"OK"`
  #
  # source://redis//lib/redis/commands/keys.rb#196
  def restore(key, ttl, serialized_value, replace: T.unsafe(nil)); end

  # Scan the keyspace
  #
  # @example Retrieve the first batch of keys
  #   redis.scan(0)
  #   # => ["4", ["key:21", "key:47", "key:42"]]
  # @example Retrieve a batch of keys matching a pattern
  #   redis.scan(4, :match => "key:1?")
  #   # => ["92", ["key:13", "key:18"]]
  # @example Retrieve a batch of keys of a certain type
  #   redis.scan(92, :type => "zset")
  #   # => ["173", ["sortedset:14", "sortedset:78"]]
  # @param cursor [String, Integer] the cursor of the iteration
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  #   - `:type => String`: return keys only of the given type
  # @return [String, Array<String>] the next cursor and all found keys
  #
  # source://redis//lib/redis/commands/keys.rb#25
  def scan(cursor, **options); end

  # Scan the keyspace
  #
  # @example Retrieve all of the keys (with possible duplicates)
  #   redis.scan_each.to_a
  #   # => ["key:21", "key:47", "key:42"]
  # @example Execute block for each key matching a pattern
  #   redis.scan_each(:match => "key:1?") {|key| puts key}
  #   # => key:13
  #   # => key:18
  # @example Execute block for each key of a type
  #   redis.scan_each(:type => "hash") {|key| puts redis.type(key)}
  #   # => "hash"
  #   # => "hash"
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  #   - `:type => String`: return keys only of the given type
  # @return [Enumerator] an enumerator for all found keys
  #
  # source://redis//lib/redis/commands/keys.rb#49
  def scan_each(**options, &block); end

  # Sort the elements in a list, set or sorted set.
  #
  # @example Retrieve the first 2 elements from an alphabetically sorted "list"
  #   redis.sort("list", :order => "alpha", :limit => [0, 2])
  #   # => ["a", "b"]
  # @example Store an alphabetically descending list in "target"
  #   redis.sort("list", :order => "desc alpha", :store => "target")
  #   # => 26
  # @param key [String]
  # @param options [Hash] - `:by => String`: use external key to sort elements by
  #   - `:limit => [offset, count]`: skip `offset` elements, return a maximum
  #   of `count` elements
  #   - `:get => [String, Array<String>]`: single key or array of keys to
  #   retrieve per element in the result
  #   - `:order => String`: combination of `ASC`, `DESC` and optionally `ALPHA`
  #   - `:store => String`: key to store the result at
  # @return [Array<String>, Array<Array<String>>, Integer] - when `:get` is not specified, or holds a single element, an array of elements
  #   - when `:get` is specified, and holds more than one element, an array of
  #   elements where every element is an array with the result for every
  #   element specified in `:get`
  #   - when `:store` is specified, the number of elements in the stored result
  #
  # source://redis//lib/redis/commands/keys.rb#407
  def sort(key, by: T.unsafe(nil), limit: T.unsafe(nil), get: T.unsafe(nil), order: T.unsafe(nil), store: T.unsafe(nil)); end

  # Get the time to live (in seconds) for a key.
  #
  # In Redis 2.6 or older the command returns -1 if the key does not exist or if
  # the key exist but has no associated expire.
  #
  # Starting with Redis 2.8 the return value in case of error changed:
  #
  #     - The command returns -2 if the key does not exist.
  #     - The command returns -1 if the key exists but has no associated expire.
  #
  # @param key [String]
  # @return [Integer] remaining time to live in seconds.
  #
  # source://redis//lib/redis/commands/keys.rb#120
  def ttl(key); end

  # Determine the type stored at key.
  #
  # @param key [String]
  # @return [String] `string`, `list`, `set`, `zset`, `hash` or `none`
  #
  # source://redis//lib/redis/commands/keys.rb#437
  def type(key); end

  # Unlink one or more keys.
  #
  # @param keys [String, Array<String>]
  # @return [Integer] number of keys that were unlinked
  #
  # source://redis//lib/redis/commands/keys.rb#243
  def unlink(*keys); end

  private

  # source://redis//lib/redis/commands/keys.rb#443
  def _scan(command, cursor, args, match: T.unsafe(nil), count: T.unsafe(nil), type: T.unsafe(nil), &block); end
end

module Redis::Commands::Lists
  # Remove the first/last element in a list and append/prepend it
  # to another list and return it, or block until one is available.
  #
  # @example With timeout
  #   element = redis.blmove("foo", "bar", "LEFT", "RIGHT", timeout: 5)
  #   # => nil on timeout
  #   # => "element" on success
  # @example Without timeout
  #   element = redis.blmove("foo", "bar", "LEFT", "RIGHT")
  #   # => "element"
  # @param source [String] source key
  # @param destination [String] destination key
  # @param where_source [String, Symbol] from where to remove the element from the source list
  #   e.g. 'LEFT' - from head, 'RIGHT' - from tail
  # @param where_destination [String, Symbol] where to push the element to the source list
  #   e.g. 'LEFT' - to head, 'RIGHT' - to tail
  # @param options [Hash] - `:timeout => Numeric`: timeout in seconds, defaults to no timeout
  # @return [nil, String] the element, or nil when the source key does not exist or the timeout expired
  #
  # source://redis//lib/redis/commands/lists.rb#55
  def blmove(source, destination, where_source, where_destination, timeout: T.unsafe(nil)); end

  # Remove and get the first element in a list, or block until one is available.
  #
  # @example With timeout
  #   list, element = redis.blpop("list", :timeout => 5)
  #   # => nil on timeout
  #   # => ["list", "element"] on success
  # @example Without timeout
  #   list, element = redis.blpop("list")
  #   # => ["list", "element"]
  # @example Blocking pop on multiple lists
  #   list, element = redis.blpop(["list", "another_list"])
  #   # => ["list", "element"]
  # @param keys [String, Array<String>] one or more keys to perform the
  #   blocking pop on
  # @param options [Hash] - `:timeout => Integer`: timeout in seconds, defaults to no timeout
  # @return [nil, [String, String]] - `nil` when the operation timed out
  #   - tuple of the list that was popped from and element was popped otherwise
  #
  # source://redis//lib/redis/commands/lists.rb#150
  def blpop(*args); end

  # Remove and get the last element in a list, or block until one is available.
  #
  # @param keys [String, Array<String>] one or more keys to perform the
  #   blocking pop on
  # @param options [Hash] - `:timeout => Integer`: timeout in seconds, defaults to no timeout
  # @return [nil, [String, String]] - `nil` when the operation timed out
  #   - tuple of the list that was popped from and element was popped otherwise
  # @see #blpop
  #
  # source://redis//lib/redis/commands/lists.rb#166
  def brpop(*args); end

  # Pop a value from a list, push it to another list and return it; or block
  # until one is available.
  #
  # @param source [String] source key
  # @param destination [String] destination key
  # @param options [Hash] - `:timeout => Integer`: timeout in seconds, defaults to no timeout
  # @return [nil, String] - `nil` when the operation timed out
  #   - the element was popped and pushed otherwise
  #
  # source://redis//lib/redis/commands/lists.rb#181
  def brpoplpush(source, destination, deprecated_timeout = T.unsafe(nil), timeout: T.unsafe(nil)); end

  # Get an element from a list by its index.
  #
  # @param key [String]
  # @param index [Integer]
  # @return [String]
  #
  # source://redis//lib/redis/commands/lists.rb#191
  def lindex(key, index); end

  # Insert an element before or after another element in a list.
  #
  # @param key [String]
  # @param where [String, Symbol] `BEFORE` or `AFTER`
  # @param pivot [String] reference element
  # @param value [String]
  # @return [Integer] length of the list after the insert operation, or `-1`
  #   when the element `pivot` was not found
  #
  # source://redis//lib/redis/commands/lists.rb#203
  def linsert(key, where, pivot, value); end

  # Get the length of a list.
  #
  # @param key [String]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/lists.rb#10
  def llen(key); end

  # Remove the first/last element in a list, append/prepend it to another list and return it.
  #
  # @note This command comes in place of the now deprecated RPOPLPUSH.
  #   Doing LMOVE RIGHT LEFT is equivalent.
  # @param source [String] source key
  # @param destination [String] destination key
  # @param where_source [String, Symbol] from where to remove the element from the source list
  #   e.g. 'LEFT' - from head, 'RIGHT' - from tail
  # @param where_destination [String, Symbol] where to push the element to the source list
  #   e.g. 'LEFT' - to head, 'RIGHT' - to tail
  # @return [nil, String] the element, or nil when the source key does not exist
  #
  # source://redis//lib/redis/commands/lists.rb#27
  def lmove(source, destination, where_source, where_destination); end

  # Remove and get the first elements in a list.
  #
  # @param key [String]
  # @param count [Integer] number of elements to remove
  # @return [String, Array<String>] the values of the first elements
  #
  # source://redis//lib/redis/commands/lists.rb#103
  def lpop(key, count = T.unsafe(nil)); end

  # Prepend one or more values to a list, creating the list if it doesn't exist
  #
  # @param key [String]
  # @param value [String, Array<String>] string value, or array of string values to push
  # @return [Integer] the length of the list after the push operation
  #
  # source://redis//lib/redis/commands/lists.rb#67
  def lpush(key, value); end

  # Prepend a value to a list, only if the list exists.
  #
  # @param key [String]
  # @param value [String]
  # @return [Integer] the length of the list after the push operation
  #
  # source://redis//lib/redis/commands/lists.rb#76
  def lpushx(key, value); end

  # Get a range of elements from a list.
  #
  # @param key [String]
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @return [Array<String>]
  #
  # source://redis//lib/redis/commands/lists.rb#213
  def lrange(key, start, stop); end

  # Remove elements from a list.
  #
  # @param key [String]
  # @param count [Integer] number of elements to remove. Use a positive
  #   value to remove the first `count` occurrences of `value`. A negative
  #   value to remove the last `count` occurrences of `value`. Or zero, to
  #   remove all occurrences of `value` from the list.
  # @param value [String]
  # @return [Integer] the number of removed elements
  #
  # source://redis//lib/redis/commands/lists.rb#226
  def lrem(key, count, value); end

  # Set the value of an element in a list by its index.
  #
  # @param key [String]
  # @param index [Integer]
  # @param value [String]
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/lists.rb#236
  def lset(key, index, value); end

  # Trim a list to the specified range.
  #
  # @param key [String]
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/lists.rb#246
  def ltrim(key, start, stop); end

  # Remove and get the last elements in a list.
  #
  # @param key [String]
  # @param count [Integer] number of elements to remove
  # @return [String, Array<String>] the values of the last elements
  #
  # source://redis//lib/redis/commands/lists.rb#114
  def rpop(key, count = T.unsafe(nil)); end

  # Remove the last element in a list, append it to another list and return it.
  #
  # @param source [String] source key
  # @param destination [String] destination key
  # @return [nil, String] the element, or nil when the source key does not exist
  #
  # source://redis//lib/redis/commands/lists.rb#125
  def rpoplpush(source, destination); end

  # Append one or more values to a list, creating the list if it doesn't exist
  #
  # @param key [String]
  # @param value [String, Array<String>] string value, or array of string values to push
  # @return [Integer] the length of the list after the push operation
  #
  # source://redis//lib/redis/commands/lists.rb#85
  def rpush(key, value); end

  # Append a value to a list, only if the list exists.
  #
  # @param key [String]
  # @param value [String]
  # @return [Integer] the length of the list after the push operation
  #
  # source://redis//lib/redis/commands/lists.rb#94
  def rpushx(key, value); end

  private

  # source://redis//lib/redis/commands/lists.rb#252
  def _bpop(cmd, args, &blk); end

  # source://redis//lib/redis/commands/lists.rb#274
  def _normalize_move_wheres(where_source, where_destination); end
end

# source://redis//lib/redis/commands.rb#195
Redis::Commands::Noop = T.let(T.unsafe(nil), Proc)

# source://redis//lib/redis/commands.rb#70
Redis::Commands::Pairify = T.let(T.unsafe(nil), Proc)

module Redis::Commands::Pubsub
  # Listen for messages published to channels matching the given patterns.
  #
  # source://redis//lib/redis/commands/pubsub.rb#42
  def psubscribe(*channels, &block); end

  # Listen for messages published to channels matching the given patterns.
  # Throw a timeout error if there is no messages for a timeout period.
  #
  # source://redis//lib/redis/commands/pubsub.rb#50
  def psubscribe_with_timeout(timeout, *channels, &block); end

  # Post a message to a channel.
  #
  # source://redis//lib/redis/commands/pubsub.rb#7
  def publish(channel, message); end

  # Inspect the state of the Pub/Sub subsystem.
  # Possible subcommands: channels, numsub, numpat.
  #
  # source://redis//lib/redis/commands/pubsub.rb#67
  def pubsub(subcommand, *args); end

  # Stop listening for messages posted to channels matching the given patterns.
  #
  # source://redis//lib/redis/commands/pubsub.rb#57
  def punsubscribe(*channels); end

  # Listen for messages published to the given channels.
  #
  # source://redis//lib/redis/commands/pubsub.rb#18
  def subscribe(*channels, &block); end

  # Listen for messages published to the given channels. Throw a timeout error
  # if there is no messages for a timeout period.
  #
  # source://redis//lib/redis/commands/pubsub.rb#26
  def subscribe_with_timeout(timeout, *channels, &block); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/commands/pubsub.rb#11
  def subscribed?; end

  # Stop listening for messages posted to the given channels.
  #
  # source://redis//lib/redis/commands/pubsub.rb#33
  def unsubscribe(*channels); end
end

module Redis::Commands::Scripting
  # Evaluate Lua script.
  #
  # @example EVAL without KEYS nor ARGV
  #   redis.eval("return 1")
  #   # => 1
  # @example EVAL with KEYS and ARGV as array arguments
  #   redis.eval("return { KEYS, ARGV }", ["k1", "k2"], ["a1", "a2"])
  #   # => [["k1", "k2"], ["a1", "a2"]]
  # @example EVAL with KEYS and ARGV in a hash argument
  #   redis.eval("return { KEYS, ARGV }", :keys => ["k1", "k2"], :argv => ["a1", "a2"])
  #   # => [["k1", "k2"], ["a1", "a2"]]
  # @param keys [Array<String>] optional array with keys to pass to the script
  # @param argv [Array<String>] optional array with arguments to pass to the script
  # @param options [Hash] - `:keys => Array<String>`: optional array with keys to pass to the script
  #   - `:argv => Array<String>`: optional array with arguments to pass to the script
  # @return depends on the script
  # @see #script
  # @see #evalsha
  #
  # source://redis//lib/redis/commands/scripting.rb#71
  def eval(*args); end

  # Evaluate Lua script by its SHA.
  #
  # @example EVALSHA without KEYS nor ARGV
  #   redis.evalsha(sha)
  #   # => <depends on script>
  # @example EVALSHA with KEYS and ARGV as array arguments
  #   redis.evalsha(sha, ["k1", "k2"], ["a1", "a2"])
  #   # => <depends on script>
  # @example EVALSHA with KEYS and ARGV in a hash argument
  #   redis.evalsha(sha, :keys => ["k1", "k2"], :argv => ["a1", "a2"])
  #   # => <depends on script>
  # @param keys [Array<String>] optional array with keys to pass to the script
  # @param argv [Array<String>] optional array with arguments to pass to the script
  # @param options [Hash] - `:keys => Array<String>`: optional array with keys to pass to the script
  #   - `:argv => Array<String>`: optional array with arguments to pass to the script
  # @return depends on the script
  # @see #script
  # @see #eval
  #
  # source://redis//lib/redis/commands/scripting.rb#96
  def evalsha(*args); end

  # Control remote script registry.
  #
  # @example Load a script
  #   sha = redis.script(:load, "return 1")
  #   # => <sha of this script>
  # @example Check if a script exists
  #   redis.script(:exists, sha)
  #   # => true
  # @example Check if multiple scripts exist
  #   redis.script(:exists, [sha, other_sha])
  #   # => [true, false]
  # @example Flush the script registry
  #   redis.script(:flush)
  #   # => "OK"
  # @example Kill a running script
  #   redis.script(:kill)
  #   # => "OK"
  # @param subcommand [String] e.g. `exists`, `flush`, `load`, `kill`
  # @param args [Array<String>] depends on subcommand
  # @return [String, Boolean, Array<Boolean>, ...] depends on subcommand
  # @see #eval
  # @see #evalsha
  #
  # source://redis//lib/redis/commands/scripting.rb#30
  def script(subcommand, *args); end

  private

  # source://redis//lib/redis/commands/scripting.rb#102
  def _eval(cmd, args); end
end

module Redis::Commands::Server
  # Asynchronously rewrite the append-only file.
  #
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/server.rb#9
  def bgrewriteaof; end

  # Asynchronously save the dataset to disk.
  #
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/server.rb#16
  def bgsave; end

  # Manage client connections.
  #
  # @param subcommand [String, Symbol] e.g. `kill`, `list`, `getname`, `setname`
  # @return [String, Hash] depends on subcommand
  #
  # source://redis//lib/redis/commands/server.rb#39
  def client(subcommand = T.unsafe(nil), *args); end

  # Get or set server configuration parameters.
  #
  # @param action [Symbol] e.g. `:get`, `:set`, `:resetstat`
  # @return [String, Hash] string reply, or hash when retrieving more than one
  #   property with `CONFIG GET`
  #
  # source://redis//lib/redis/commands/server.rb#25
  def config(action, *args); end

  # Return the number of keys in the selected database.
  #
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/server.rb#55
  def dbsize; end

  # source://redis//lib/redis/commands/server.rb#183
  def debug(*args); end

  # Remove all keys from all databases.
  #
  # @param options [Hash] - `:async => Boolean`: async flush (default: false)
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/server.rb#64
  def flushall(options = T.unsafe(nil)); end

  # Remove all keys from the current database.
  #
  # @param options [Hash] - `:async => Boolean`: async flush (default: false)
  # @return [String] `OK`
  #
  # source://redis//lib/redis/commands/server.rb#77
  def flushdb(options = T.unsafe(nil)); end

  # Get information and statistics about the server.
  #
  # @param cmd [String, Symbol] e.g. "commandstats"
  # @return [Hash<String, String>]
  #
  # source://redis//lib/redis/commands/server.rb#89
  def info(cmd = T.unsafe(nil)); end

  # Get the UNIX time stamp of the last successful save to disk.
  #
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/server.rb#110
  def lastsave; end

  # Listen for all requests received by the server in real time.
  #
  # There is no way to interrupt this command.
  #
  # @yield a block to be called for every line of output
  # @yieldparam line [String] timestamp and command that was executed
  #
  # source://redis//lib/redis/commands/server.rb#120
  def monitor(&block); end

  # Synchronously save the dataset to disk.
  #
  # @return [String]
  #
  # source://redis//lib/redis/commands/server.rb#129
  def save; end

  # Synchronously save the dataset to disk and then shut down the server.
  #
  # source://redis//lib/redis/commands/server.rb#134
  def shutdown; end

  # Make the server a slave of another instance, or promote it as master.
  #
  # source://redis//lib/redis/commands/server.rb#148
  def slaveof(host, port); end

  # Interact with the slowlog (get, len, reset)
  #
  # @param subcommand [String] e.g. `get`, `len`, `reset`
  # @param length [Integer] maximum number of entries to return
  # @return [Array<String>, Integer, String] depends on subcommand
  #
  # source://redis//lib/redis/commands/server.rb#157
  def slowlog(subcommand, length = T.unsafe(nil)); end

  # Internal command used for replication.
  #
  # source://redis//lib/redis/commands/server.rb#166
  def sync; end

  # Return the server time.
  #
  # @example
  #   r.time # => [ 1333093196, 606806 ]
  # @return [Array<Integer>] tuple of seconds since UNIX epoch and
  #   microseconds in the current second
  #
  # source://redis//lib/redis/commands/server.rb#177
  def time; end
end

module Redis::Commands::Sets
  # Add one or more members to a set.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member, or array of members
  # @return [Boolean, Integer] `Boolean` when a single member is specified,
  #   holding whether or not adding the member succeeded, or `Integer` when an
  #   array of members is specified, holding the number of members that were
  #   successfully added
  #
  # source://redis//lib/redis/commands/sets.rb#22
  def sadd(key, member); end

  # Add one or more members to a set.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member, or array of members
  # @return [Boolean] Whether or not at least one member was added.
  #
  # source://redis//lib/redis/commands/sets.rb#38
  def sadd?(key, member); end

  # Get the number of members in a set.
  #
  # @param key [String]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/sets.rb#10
  def scard(key); end

  # Subtract multiple sets.
  #
  # @param keys [String, Array<String>] keys pointing to sets to subtract
  # @return [Array<String>] members in the difference
  #
  # source://redis//lib/redis/commands/sets.rb#138
  def sdiff(*keys); end

  # Subtract multiple sets and store the resulting set in a key.
  #
  # @param destination [String] destination key
  # @param keys [String, Array<String>] keys pointing to sets to subtract
  # @return [Integer] number of elements in the resulting set
  #
  # source://redis//lib/redis/commands/sets.rb#147
  def sdiffstore(destination, *keys); end

  # Intersect multiple sets.
  #
  # @param keys [String, Array<String>] keys pointing to sets to intersect
  # @return [Array<String>] members in the intersection
  #
  # source://redis//lib/redis/commands/sets.rb#155
  def sinter(*keys); end

  # Intersect multiple sets and store the resulting set in a key.
  #
  # @param destination [String] destination key
  # @param keys [String, Array<String>] keys pointing to sets to intersect
  # @return [Integer] number of elements in the resulting set
  #
  # source://redis//lib/redis/commands/sets.rb#164
  def sinterstore(destination, *keys); end

  # Determine if a given value is a member of a set.
  #
  # @param key [String]
  # @param member [String]
  # @return [Boolean]
  #
  # source://redis//lib/redis/commands/sets.rb#111
  def sismember(key, member); end

  # Get all the members in a set.
  #
  # @param key [String]
  # @return [Array<String>]
  #
  # source://redis//lib/redis/commands/sets.rb#130
  def smembers(key); end

  # Determine if multiple values are members of a set.
  #
  # @param key [String]
  # @param members [String, Array<String>]
  # @return [Array<Boolean>]
  #
  # source://redis//lib/redis/commands/sets.rb#120
  def smismember(key, *members); end

  # Move a member from one set to another.
  #
  # @param source [String] source key
  # @param destination [String] destination key
  # @param member [String] member to move from `source` to `destination`
  # @return [Boolean]
  #
  # source://redis//lib/redis/commands/sets.rb#102
  def smove(source, destination, member); end

  # Remove and return one or more random member from a set.
  #
  # @param key [String]
  # @param count [Integer]
  # @return [String]
  #
  # source://redis//lib/redis/commands/sets.rb#75
  def spop(key, count = T.unsafe(nil)); end

  # Get one or more random members from a set.
  #
  # @param key [String]
  # @param count [Integer]
  # @return [String]
  #
  # source://redis//lib/redis/commands/sets.rb#88
  def srandmember(key, count = T.unsafe(nil)); end

  # Remove one or more members from a set.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member, or array of members
  # @return [Boolean, Integer] `Boolean` when a single member is specified,
  #   holding whether or not removing the member succeeded, or `Integer` when an
  #   array of members is specified, holding the number of members that were
  #   successfully removed
  #
  # source://redis//lib/redis/commands/sets.rb#50
  def srem(key, member); end

  # Remove one or more members from a set.
  #
  # @param key [String]
  # @param member [String, Array<String>] one member, or array of members
  # @return [Boolean] `Boolean` Whether or not a member was removed.
  #
  # source://redis//lib/redis/commands/sets.rb#66
  def srem?(key, member); end

  # Scan a set
  #
  # @example Retrieve the first batch of keys in a set
  #   redis.sscan("set", 0)
  # @param cursor [String, Integer] the cursor of the iteration
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [String, Array<String>] the next cursor and all found members
  #
  # source://redis//lib/redis/commands/sets.rb#196
  def sscan(key, cursor, **options); end

  # Scan a set
  #
  # @example Retrieve all of the keys in a set
  #   redis.sscan_each("set").to_a
  #   # => ["key1", "key2", "key3"]
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [Enumerator] an enumerator for all keys in the set
  #
  # source://redis//lib/redis/commands/sets.rb#211
  def sscan_each(key, **options, &block); end

  # Add multiple sets.
  #
  # @param keys [String, Array<String>] keys pointing to sets to unify
  # @return [Array<String>] members in the union
  #
  # source://redis//lib/redis/commands/sets.rb#172
  def sunion(*keys); end

  # Add multiple sets and store the resulting set in a key.
  #
  # @param destination [String] destination key
  # @param keys [String, Array<String>] keys pointing to sets to unify
  # @return [Integer] number of elements in the resulting set
  #
  # source://redis//lib/redis/commands/sets.rb#181
  def sunionstore(destination, *keys); end
end

module Redis::Commands::SortedSets
  # Removes and returns up to count members with the highest scores in the sorted set stored at keys,
  #   or block until one is available.
  #
  # @example Popping a member from a sorted set
  #   redis.bzpopmax('zset', 1)
  #   #=> ['zset', 'b', 2.0]
  # @example Popping a member from multiple sorted sets
  #   redis.bzpopmax('zset1', 'zset2', 1)
  #   #=> ['zset1', 'b', 2.0]
  # @return [Array<String, String, Float>] a touple of key, member and score
  # @return [nil] when no element could be popped and the timeout expired
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#181
  def bzpopmax(*args); end

  # Removes and returns up to count members with the lowest scores in the sorted set stored at keys,
  #   or block until one is available.
  #
  # @example Popping a member from a sorted set
  #   redis.bzpopmin('zset', 1)
  #   #=> ['zset', 'a', 1.0]
  # @example Popping a member from multiple sorted sets
  #   redis.bzpopmin('zset1', 'zset2', 1)
  #   #=> ['zset1', 'a', 1.0]
  # @return [Array<String, String, Float>] a touple of key, member and score
  # @return [nil] when no element could be popped and the timeout expired
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#202
  def bzpopmin(*args); end

  # Add one or more members to a sorted set, or update the score for members
  # that already exist.
  #
  # @example Add a single `[score, member]` pair to a sorted set
  #   redis.zadd("zset", 32.0, "member")
  # @example Add an array of `[score, member]` pairs to a sorted set
  #   redis.zadd("zset", [[32.0, "a"], [64.0, "b"]])
  # @param key [String]
  # @param args [[Float, String], Array<[Float, String]>] - a single `[score, member]` pair
  #   - an array of `[score, member]` pairs
  # @param options [Hash] - `:xx => true`: Only update elements that already exist (never
  #   add elements)
  #   - `:nx => true`: Don't update already existing elements (always
  #   add new elements)
  #   - `:lt => true`: Only update existing elements if the new score
  #   is less than the current score
  #   - `:gt => true`: Only update existing elements if the new score
  #   is greater than the current score
  #   - `:ch => true`: Modify the return value from the number of new
  #   elements added, to the total number of elements changed (CH is an
  #   abbreviation of changed); changed elements are new elements added
  #   and elements already existing for which the score was updated
  #   - `:incr => true`: When this option is specified ZADD acts like
  #   ZINCRBY; only one score-element pair can be specified in this mode
  # @return [Boolean, Integer, Float] - `Boolean` when a single pair is specified, holding whether or not it was
  #   **added** to the sorted set.
  #   - `Integer` when an array of pairs is specified, holding the number of
  #   pairs that were **added** to the sorted set.
  #   - `Float` when option :incr is specified, holding the score of the member
  #   after incrementing it.
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#53
  def zadd(key, *args, nx: T.unsafe(nil), xx: T.unsafe(nil), lt: T.unsafe(nil), gt: T.unsafe(nil), ch: T.unsafe(nil), incr: T.unsafe(nil)); end

  # Get the number of members in a sorted set.
  #
  # @example
  #   redis.zcard("zset")
  #   # => 4
  # @param key [String]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#14
  def zcard(key); end

  # Count the members in a sorted set with scores within the given values.
  #
  # @example Count members with score `>= 5` and `< 100`
  #   redis.zcount("zset", "5", "(100")
  #   # => 2
  # @example Count members with scores `> 5`
  #   redis.zcount("zset", "(5", "+inf")
  #   # => 2
  # @param key [String]
  # @param min [String] - inclusive minimum score is specified verbatim
  #   - exclusive minimum score is specified by prefixing `(`
  # @param max [String] - inclusive maximum score is specified verbatim
  #   - exclusive maximum score is specified by prefixing `(`
  # @return [Integer] number of members in within the specified range
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#608
  def zcount(key, min, max); end

  # Return the difference between the first and all successive input sorted sets
  #
  # @example
  #   redis.zadd("zsetA", [[1.0, "v1"], [2.0, "v2"]])
  #   redis.zadd("zsetB", [[3.0, "v2"], [2.0, "v3"]])
  #   redis.zdiff("zsetA", "zsetB")
  #   => ["v1"]
  # @example With scores
  #   redis.zadd("zsetA", [[1.0, "v1"], [2.0, "v2"]])
  #   redis.zadd("zsetB", [[3.0, "v2"], [2.0, "v3"]])
  #   redis.zdiff("zsetA", "zsetB", :with_scores => true)
  #   => [["v1", 1.0]]
  # @param keys [String, Array<String>] one or more keys to compute the difference
  # @param options [Hash] - `:with_scores => true`: include scores in output
  # @return [Array<String>, Array<[String, Float]>] - when `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#717
  def zdiff(*keys, with_scores: T.unsafe(nil)); end

  # Compute the difference between the first and all successive input sorted sets
  # and store the resulting sorted set in a new key
  #
  # @example
  #   redis.zadd("zsetA", [[1.0, "v1"], [2.0, "v2"]])
  #   redis.zadd("zsetB", [[3.0, "v2"], [2.0, "v3"]])
  #   redis.zdiffstore("zsetA", "zsetB")
  #   # => 1
  # @param destination [String] destination key
  # @param keys [Array<String>] source keys
  # @return [Integer] number of elements in the resulting sorted set
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#733
  def zdiffstore(*args, **_arg1); end

  # Increment the score of a member in a sorted set.
  #
  # @example
  #   redis.zincrby("zset", 32.0, "a")
  #   # => 64.0
  # @param key [String]
  # @param increment [Float]
  # @param member [String]
  # @return [Float] score of the member after incrementing it
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#86
  def zincrby(key, increment, member); end

  # Return the intersection of multiple sorted sets
  #
  # @example Retrieve the intersection of `2*zsetA` and `1*zsetB`
  #   redis.zinter("zsetA", "zsetB", :weights => [2.0, 1.0])
  #   # => ["v1", "v2"]
  # @example Retrieve the intersection of `2*zsetA` and `1*zsetB`, and their scores
  #   redis.zinter("zsetA", "zsetB", :weights => [2.0, 1.0], :with_scores => true)
  #   # => [["v1", 3.0], ["v2", 6.0]]
  # @param keys [String, Array<String>] one or more keys to intersect
  # @param options [Hash] - `:weights => [Float, Float, ...]`: weights to associate with source
  #   sorted sets
  #   - `:aggregate => String`: aggregate function to use (sum, min, max, ...)
  #   - `:with_scores => true`: include scores in output
  # @return [Array<String>, Array<[String, Float]>] - when `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#631
  def zinter(*args, **_arg1); end

  # Intersect multiple sorted sets and store the resulting sorted set in a new
  # key.
  #
  # @example Compute the intersection of `2*zsetA` with `1*zsetB`, summing their scores
  #   redis.zinterstore("zsetC", ["zsetA", "zsetB"], :weights => [2.0, 1.0], :aggregate => "sum")
  #   # => 4
  # @param destination [String] destination key
  # @param keys [Array<String>] source keys
  # @param options [Hash] - `:weights => [Array<Float>]`: weights to associate with source
  #   sorted sets
  #   - `:aggregate => String`: aggregate function to use (sum, min, max)
  # @return [Integer] number of elements in the resulting sorted set
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#650
  def zinterstore(*args, **_arg1); end

  # Count the members, with the same score in a sorted set, within the given lexicographical range.
  #
  # @example Count members matching a
  #   redis.zlexcount("zset", "[a", "[a\xff")
  #   # => 1
  # @example Count members matching a-z
  #   redis.zlexcount("zset", "[a", "[z\xff")
  #   # => 26
  # @param key [String]
  # @param min [String] - inclusive minimum is specified by prefixing `(`
  #   - exclusive minimum is specified by prefixing `[`
  # @param max [String] - inclusive maximum is specified by prefixing `(`
  #   - exclusive maximum is specified by prefixing `[`
  # @return [Integer] number of members within the specified lexicographical range
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#439
  def zlexcount(key, min, max); end

  # Get the scores associated with the given members in a sorted set.
  #
  # @example Get the scores for members "a" and "b"
  #   redis.zmscore("zset", "a", "b")
  #   # => [32.0, 48.0]
  # @param key [String]
  # @param members [String, Array<String>]
  # @return [Array<Float>] scores of the members
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#230
  def zmscore(key, *members); end

  # Removes and returns up to count members with the highest scores in the sorted set stored at key.
  #
  # @example Popping a member
  #   redis.zpopmax('zset')
  #   #=> ['b', 2.0]
  # @example With count option
  #   redis.zpopmax('zset', 2)
  #   #=> [['b', 2.0], ['a', 1.0]]
  # @return [Array<String, Float>] element and score pair if count is not specified
  # @return [Array<Array<String, Float>>] list of popped elements and scores
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#138
  def zpopmax(key, count = T.unsafe(nil)); end

  # Removes and returns up to count members with the lowest scores in the sorted set stored at key.
  #
  # @example Popping a member
  #   redis.zpopmin('zset')
  #   #=> ['a', 1.0]
  # @example With count option
  #   redis.zpopmin('zset', 2)
  #   #=> [['a', 1.0], ['b', 2.0]]
  # @return [Array<String, Float>] element and score pair if count is not specified
  # @return [Array<Array<String, Float>>] list of popped elements and scores
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#159
  def zpopmin(key, count = T.unsafe(nil)); end

  # Get one or more random members from a sorted set.
  #
  # @example Get one random member
  #   redis.zrandmember("zset")
  #   # => "a"
  # @example Get multiple random members
  #   redis.zrandmember("zset", 2)
  #   # => ["a", "b"]
  # @example Get multiple random members with scores
  #   redis.zrandmember("zset", 2, with_scores: true)
  #   # => [["a", 2.0], ["b", 3.0]]
  # @param key [String]
  # @param count [Integer]
  # @param options [Hash] - `:with_scores => true`: include scores in output
  # @return [nil, String, Array<String>, Array<[String, Float]>] - when `key` does not exist or set is empty, `nil`
  #   - when `count` is not specified, a member
  #   - when `count` is specified and `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#258
  def zrandmember(key, count = T.unsafe(nil), withscores: T.unsafe(nil), with_scores: T.unsafe(nil)); end

  # Return a range of members in a sorted set, by index, score or lexicographical ordering.
  #
  # @example Retrieve all members from a sorted set, by index
  #   redis.zrange("zset", 0, -1)
  #   # => ["a", "b"]
  # @example Retrieve all members and their scores from a sorted set
  #   redis.zrange("zset", 0, -1, :with_scores => true)
  #   # => [["a", 32.0], ["b", 64.0]]
  # @param key [String]
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @param options [Hash] - `:by_score => false`: return members by score
  #   - `:by_lex => false`: return members by lexicographical ordering
  #   - `:rev => false`: reverse the ordering, from highest to lowest
  #   - `:limit => [offset, count]`: skip `offset` members, return a maximum of
  #   `count` members
  #   - `:with_scores => true`: include scores in output
  # @return [Array<String>, Array<[String, Float]>] - when `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#297
  def zrange(key, start, stop, byscore: T.unsafe(nil), by_score: T.unsafe(nil), bylex: T.unsafe(nil), by_lex: T.unsafe(nil), rev: T.unsafe(nil), limit: T.unsafe(nil), withscores: T.unsafe(nil), with_scores: T.unsafe(nil)); end

  # Return a range of members with the same score in a sorted set, by lexicographical ordering
  #
  # @example Retrieve members matching a
  #   redis.zrangebylex("zset", "[a", "[a\xff")
  #   # => ["aaren", "aarika", "abagael", "abby"]
  # @example Retrieve the first 2 members matching a
  #   redis.zrangebylex("zset", "[a", "[a\xff", :limit => [0, 2])
  #   # => ["aaren", "aarika"]
  # @param key [String]
  # @param min [String] - inclusive minimum is specified by prefixing `(`
  #   - exclusive minimum is specified by prefixing `[`
  # @param max [String] - inclusive maximum is specified by prefixing `(`
  #   - exclusive maximum is specified by prefixing `[`
  # @param options [Hash] - `:limit => [offset, count]`: skip `offset` members, return a maximum of
  #   `count` members
  # @return [Array<String>, Array<[String, Float]>]
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#464
  def zrangebylex(key, min, max, limit: T.unsafe(nil)); end

  # Return a range of members in a sorted set, by score.
  #
  # @example Retrieve members with score `>= 5` and `< 100`
  #   redis.zrangebyscore("zset", "5", "(100")
  #   # => ["a", "b"]
  # @example Retrieve the first 2 members with score `>= 0`
  #   redis.zrangebyscore("zset", "0", "+inf", :limit => [0, 2])
  #   # => ["a", "b"]
  # @example Retrieve members and their scores with scores `> 5`
  #   redis.zrangebyscore("zset", "(5", "+inf", :with_scores => true)
  #   # => [["a", 32.0], ["b", 64.0]]
  # @param key [String]
  # @param min [String] - inclusive minimum score is specified verbatim
  #   - exclusive minimum score is specified by prefixing `(`
  # @param max [String] - inclusive maximum score is specified verbatim
  #   - exclusive maximum score is specified by prefixing `(`
  # @param options [Hash] - `:with_scores => true`: include scores in output
  #   - `:limit => [offset, count]`: skip `offset` members, return a maximum of
  #   `count` members
  # @return [Array<String>, Array<[String, Float]>] - when `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#524
  def zrangebyscore(key, min, max, withscores: T.unsafe(nil), with_scores: T.unsafe(nil), limit: T.unsafe(nil)); end

  # Select a range of members in a sorted set, by index, score or lexicographical ordering
  # and store the resulting sorted set in a new key.
  #
  # @example
  #   redis.zadd("foo", [[1.0, "s1"], [2.0, "s2"], [3.0, "s3"]])
  #   redis.zrangestore("bar", "foo", 0, 1)
  #   # => 2
  #   redis.zrange("bar", 0, -1)
  #   # => ["s1", "s2"]
  # @return [Integer] the number of elements in the resulting sorted set
  # @see #zrange
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#339
  def zrangestore(dest_key, src_key, start, stop, byscore: T.unsafe(nil), by_score: T.unsafe(nil), bylex: T.unsafe(nil), by_lex: T.unsafe(nil), rev: T.unsafe(nil), limit: T.unsafe(nil)); end

  # Determine the index of a member in a sorted set.
  #
  # @param key [String]
  # @param member [String]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#390
  def zrank(key, member); end

  # Remove one or more members from a sorted set.
  #
  # @example Remove a single member from a sorted set
  #   redis.zrem("zset", "a")
  # @example Remove an array of members from a sorted set
  #   redis.zrem("zset", ["a", "b"])
  # @param key [String]
  # @param member [String, Array<String>] - a single member
  #   - an array of members
  # @return [Boolean, Integer] - `Boolean` when a single member is specified, holding whether or not it
  #   was removed from the sorted set
  #   - `Integer` when an array of pairs is specified, holding the number of
  #   members that were removed to the sorted set
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#107
  def zrem(key, member); end

  # Remove all members in a sorted set within the given indexes.
  #
  # @example Remove first 5 members
  #   redis.zremrangebyrank("zset", 0, 4)
  #   # => 5
  # @example Remove last 5 members
  #   redis.zremrangebyrank("zset", -5, -1)
  #   # => 5
  # @param key [String]
  # @param start [Integer] start index
  # @param stop [Integer] stop index
  # @return [Integer] number of members that were removed
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#417
  def zremrangebyrank(key, start, stop); end

  # Remove all members in a sorted set within the given scores.
  #
  # @example Remove members with score `>= 5` and `< 100`
  #   redis.zremrangebyscore("zset", "5", "(100")
  #   # => 2
  # @example Remove members with scores `> 5`
  #   redis.zremrangebyscore("zset", "(5", "+inf")
  #   # => 2
  # @param key [String]
  # @param min [String] - inclusive minimum score is specified verbatim
  #   - exclusive minimum score is specified by prefixing `(`
  # @param max [String] - inclusive maximum score is specified verbatim
  #   - exclusive maximum score is specified by prefixing `(`
  # @return [Integer] number of members that were removed
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#587
  def zremrangebyscore(key, min, max); end

  # Return a range of members in a sorted set, by index, with scores ordered
  # from high to low.
  #
  # @example Retrieve all members from a sorted set
  #   redis.zrevrange("zset", 0, -1)
  #   # => ["b", "a"]
  # @example Retrieve all members and their scores from a sorted set
  #   redis.zrevrange("zset", 0, -1, :with_scores => true)
  #   # => [["b", 64.0], ["a", 32.0]]
  # @see #zrange
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#374
  def zrevrange(key, start, stop, withscores: T.unsafe(nil), with_scores: T.unsafe(nil)); end

  # Return a range of members with the same score in a sorted set, by reversed lexicographical ordering.
  # Apart from the reversed ordering, #zrevrangebylex is similar to #zrangebylex.
  #
  # @example Retrieve members matching a
  #   redis.zrevrangebylex("zset", "[a", "[a\xff")
  #   # => ["abbygail", "abby", "abagael", "aaren"]
  # @example Retrieve the last 2 members matching a
  #   redis.zrevrangebylex("zset", "[a", "[a\xff", :limit => [0, 2])
  #   # => ["abbygail", "abby"]
  # @see #zrangebylex
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#486
  def zrevrangebylex(key, max, min, limit: T.unsafe(nil)); end

  # Return a range of members in a sorted set, by score, with scores ordered
  # from high to low.
  #
  # @example Retrieve members with score `< 100` and `>= 5`
  #   redis.zrevrangebyscore("zset", "(100", "5")
  #   # => ["b", "a"]
  # @example Retrieve the first 2 members with score `<= 0`
  #   redis.zrevrangebyscore("zset", "0", "-inf", :limit => [0, 2])
  #   # => ["b", "a"]
  # @example Retrieve members and their scores with scores `> 5`
  #   redis.zrevrangebyscore("zset", "+inf", "(5", :with_scores => true)
  #   # => [["b", 64.0], ["a", 32.0]]
  # @see #zrangebyscore
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#554
  def zrevrangebyscore(key, max, min, withscores: T.unsafe(nil), with_scores: T.unsafe(nil), limit: T.unsafe(nil)); end

  # Determine the index of a member in a sorted set, with scores ordered from
  # high to low.
  #
  # @param key [String]
  # @param member [String]
  # @return [Integer]
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#400
  def zrevrank(key, member); end

  # Scan a sorted set
  #
  # @example Retrieve the first batch of key/value pairs in a hash
  #   redis.zscan("zset", 0)
  # @param cursor [String, Integer] the cursor of the iteration
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [String, Array<[String, Float]>] the next cursor and all found
  #   members and scores
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#750
  def zscan(key, cursor, **options); end

  # Scan a sorted set
  #
  # @example Retrieve all of the members/scores in a sorted set
  #   redis.zscan_each("zset").to_a
  #   # => [["key70", "70"], ["key80", "80"]]
  # @param options [Hash] - `:match => String`: only return keys matching the pattern
  #   - `:count => Integer`: return count keys at most per iteration
  # @return [Enumerator] an enumerator for all found scores and members
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#767
  def zscan_each(key, **options, &block); end

  # Get the score associated with the given member in a sorted set.
  #
  # @example Get the score for member "a"
  #   redis.zscore("zset", "a")
  #   # => 32.0
  # @param key [String]
  # @param member [String]
  # @return [Float] score of the member
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#217
  def zscore(key, member); end

  # Return the union of multiple sorted sets
  #
  # @example Retrieve the union of `2*zsetA` and `1*zsetB`
  #   redis.zunion("zsetA", "zsetB", :weights => [2.0, 1.0])
  #   # => ["v1", "v2"]
  # @example Retrieve the union of `2*zsetA` and `1*zsetB`, and their scores
  #   redis.zunion("zsetA", "zsetB", :weights => [2.0, 1.0], :with_scores => true)
  #   # => [["v1", 3.0], ["v2", 6.0]]
  # @param keys [String, Array<String>] one or more keys to union
  # @param options [Hash] - `:weights => [Array<Float>]`: weights to associate with source
  #   sorted sets
  #   - `:aggregate => String`: aggregate function to use (sum, min, max)
  #   - `:with_scores => true`: include scores in output
  # @return [Array<String>, Array<[String, Float]>] - when `:with_scores` is not specified, an array of members
  #   - when `:with_scores` is specified, an array with `[member, score]` pairs
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#674
  def zunion(*args, **_arg1); end

  # Add multiple sorted sets and store the resulting sorted set in a new key.
  #
  # @example Compute the union of `2*zsetA` with `1*zsetB`, summing their scores
  #   redis.zunionstore("zsetC", ["zsetA", "zsetB"], :weights => [2.0, 1.0], :aggregate => "sum")
  #   # => 8
  # @param destination [String] destination key
  # @param keys [Array<String>] source keys
  # @param options [Hash] - `:weights => [Float, Float, ...]`: weights to associate with source
  #   sorted sets
  #   - `:aggregate => String`: aggregate function to use (sum, min, max, ...)
  # @return [Integer] number of elements in the resulting sorted set
  #
  # source://redis//lib/redis/commands/sorted_sets.rb#692
  def zunionstore(*args, **_arg1); end

  private

  # source://redis//lib/redis/commands/sorted_sets.rb#780
  def _zsets_operation(cmd, *keys, weights: T.unsafe(nil), aggregate: T.unsafe(nil), with_scores: T.unsafe(nil)); end

  # source://redis//lib/redis/commands/sorted_sets.rb#798
  def _zsets_operation_store(cmd, destination, keys, weights: T.unsafe(nil), aggregate: T.unsafe(nil)); end
end

module Redis::Commands::Streams
  # Removes one or multiple entries from the pending entries list of a stream consumer group.
  #
  # @example With a entry id
  #   redis.xack('mystream', 'mygroup', '1526569495631-0')
  # @example With splatted entry ids
  #   redis.xack('mystream', 'mygroup', '0-1', '0-2')
  # @example With arrayed entry ids
  #   redis.xack('mystream', 'mygroup', %w[0-1 0-2])
  # @param key [String] the stream key
  # @param group [String] the consumer group name
  # @param ids [Array<String>] one or multiple entry ids
  # @return [Integer] the number of entries successfully acknowledged
  #
  # source://redis//lib/redis/commands/streams.rb#251
  def xack(key, group, *ids); end

  # Add new entry to the stream.
  #
  # @example Without options
  #   redis.xadd('mystream', f1: 'v1', f2: 'v2')
  # @example With options
  #   redis.xadd('mystream', { f1: 'v1', f2: 'v2' }, id: '0-0', maxlen: 1000, approximate: true)
  # @option opts
  # @option opts
  # @option opts
  # @param key [String] the stream key
  # @param entry [Hash] one or multiple field-value pairs
  # @param opts [Hash] several options for `XADD` command
  # @return [String] the entry id
  #
  # source://redis//lib/redis/commands/streams.rb#51
  def xadd(key, entry, approximate: T.unsafe(nil), maxlen: T.unsafe(nil), id: T.unsafe(nil)); end

  # Transfers ownership of pending stream entries that match the specified criteria.
  #
  # @example Claim next pending message stuck > 5 minutes and mark as retry
  #   redis.xautoclaim('mystream', 'mygroup', 'consumer1', 3600000, '0-0')
  # @example Claim 50 next pending messages stuck > 5 minutes and mark as retry
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, '0-0', count: 50)
  # @example Claim next pending message stuck > 5 minutes and don't mark as retry
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, '0-0', justid: true)
  # @example Claim next pending message after this id stuck > 5 minutes and mark as retry
  #   redis.xautoclaim('mystream', 'mygroup', 'consumer1', 3600000, '1641321233-0')
  # @param key [String] the stream key
  # @param group [String] the consumer group name
  # @param consumer [String] the consumer name
  # @param min_idle_time [Integer] the number of milliseconds
  # @param start [String] entry id to start scanning from or 0-0 for everything
  # @param count [Integer] number of messages to claim (default 1)
  # @param justid [Boolean] whether to fetch just an array of entry ids or not.
  #   Does not increment retry count when true
  # @return [Hash{String => Hash}] the entries successfully claimed
  # @return [Array<String>] the entry ids successfully claimed if justid option is `true`
  #
  # source://redis//lib/redis/commands/streams.rb#321
  def xautoclaim(key, group, consumer, min_idle_time, start, count: T.unsafe(nil), justid: T.unsafe(nil)); end

  # Changes the ownership of a pending entry
  #
  # @example With splatted entry ids
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, '0-1', '0-2')
  # @example With arrayed entry ids
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2])
  # @example With idle option
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2], idle: 1000)
  # @example With time option
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2], time: 1542866959000)
  # @example With retrycount option
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2], retrycount: 10)
  # @example With force option
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2], force: true)
  # @example With justid option
  #   redis.xclaim('mystream', 'mygroup', 'consumer1', 3600000, %w[0-1 0-2], justid: true)
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param key [String] the stream key
  # @param group [String] the consumer group name
  # @param consumer [String] the consumer name
  # @param min_idle_time [Integer] the number of milliseconds
  # @param ids [Array<String>] one or multiple entry ids
  # @param opts [Hash] several options for `XCLAIM` command
  # @return [Hash{String => Hash}] the entries successfully claimed
  # @return [Array<String>] the entry ids successfully claimed if justid option is `true`
  #
  # source://redis//lib/redis/commands/streams.rb#288
  def xclaim(key, group, consumer, min_idle_time, *ids, **opts); end

  # Delete entries by entry ids.
  #
  # @example With splatted entry ids
  #   redis.xdel('mystream', '0-1', '0-2')
  # @example With arrayed entry ids
  #   redis.xdel('mystream', ['0-1', '0-2'])
  # @param key [String] the stream key
  # @param ids [Array<String>] one or multiple entry ids
  # @return [Integer] the number of entries actually deleted
  #
  # source://redis//lib/redis/commands/streams.rb#91
  def xdel(key, *ids); end

  # Manages the consumer group of the stream.
  #
  # @example With `create` subcommand
  #   redis.xgroup(:create, 'mystream', 'mygroup', '$')
  # @example With `setid` subcommand
  #   redis.xgroup(:setid, 'mystream', 'mygroup', '$')
  # @example With `destroy` subcommand
  #   redis.xgroup(:destroy, 'mystream', 'mygroup')
  # @example With `delconsumer` subcommand
  #   redis.xgroup(:delconsumer, 'mystream', 'mygroup', 'consumer1')
  # @param subcommand [String] `create` `setid` `destroy` `delconsumer`
  # @param key [String] the stream key
  # @param group [String] the consumer group name
  # @param id_or_consumer [String] * the entry id or `$`, required if subcommand is `create` or `setid`
  #   * the consumer name, required if subcommand is `delconsumer`
  # @param mkstream [Boolean] whether to create an empty stream automatically or not
  # @return [String] `OK` if subcommand is `create` or `setid`
  # @return [Integer] effected count if subcommand is `destroy` or `delconsumer`
  #
  # source://redis//lib/redis/commands/streams.rb#199
  def xgroup(subcommand, key, group, id_or_consumer = T.unsafe(nil), mkstream: T.unsafe(nil)); end

  # Returns the stream information each subcommand.
  #
  # @example stream
  #   redis.xinfo(:stream, 'mystream')
  # @example groups
  #   redis.xinfo(:groups, 'mystream')
  # @example consumers
  #   redis.xinfo(:consumers, 'mystream', 'mygroup')
  # @param subcommand [String] e.g. `stream` `groups` `consumers`
  # @param key [String] the stream key
  # @param group [String] the consumer group name, required if subcommand is `consumers`
  # @return [Hash] information of the stream if subcommand is `stream`
  # @return [Array<Hash>] information of the consumer groups if subcommand is `groups`
  # @return [Array<Hash>] information of the consumers if subcommand is `consumers`
  #
  # source://redis//lib/redis/commands/streams.rb#22
  def xinfo(subcommand, key, group = T.unsafe(nil)); end

  # Returns the number of entries inside a stream.
  #
  # @example With key
  #   redis.xlen('mystream')
  # @param key [String] the stream key
  # @return [Integer] the number of entries
  #
  # source://redis//lib/redis/commands/streams.rb#150
  def xlen(key); end

  # Fetches not acknowledging pending entries
  #
  # @example With key and group
  #   redis.xpending('mystream', 'mygroup')
  # @example With range options
  #   redis.xpending('mystream', 'mygroup', '-', '+', 10)
  # @example With range and consumer options
  #   redis.xpending('mystream', 'mygroup', '-', '+', 10, 'consumer1')
  # @param key [String] the stream key
  # @param group [String] the consumer group name
  # @param start [String] start first entry id of range
  # @param end [String] end   last entry id of range
  # @param count [Integer] count the number of entries as limit
  # @param consumer [String] the consumer name
  # @return [Hash] the summary of pending entries
  # @return [Array<Hash>] the pending entries details if options were specified
  #
  # source://redis//lib/redis/commands/streams.rb#349
  def xpending(key, group, *args); end

  # Fetches entries of the stream in ascending order.
  #
  # @example Without options
  #   redis.xrange('mystream')
  # @example With a specific start
  #   redis.xrange('mystream', '0-1')
  # @example With a specific start and end
  #   redis.xrange('mystream', '0-1', '0-3')
  # @example With count options
  #   redis.xrange('mystream', count: 10)
  # @param key [String] the stream key
  # @param start [String] first entry id of range, default value is `-`
  # @param end [String] last entry id of range, default value is `+`
  # @param count [Integer] the number of entries as limit
  # @return [Array<Array<String, Hash>>] the ids and entries pairs
  #
  # source://redis//lib/redis/commands/streams.rb#113
  def xrange(key, start = T.unsafe(nil), range_end = T.unsafe(nil), count: T.unsafe(nil)); end

  # Fetches entries from one or multiple streams. Optionally blocking.
  #
  # @example With a key
  #   redis.xread('mystream', '0-0')
  # @example With multiple keys
  #   redis.xread(%w[mystream1 mystream2], %w[0-0 0-0])
  # @example With count option
  #   redis.xread('mystream', '0-0', count: 2)
  # @example With block option
  #   redis.xread('mystream', '$', block: 1000)
  # @param keys [Array<String>] one or multiple stream keys
  # @param ids [Array<String>] one or multiple entry ids
  # @param count [Integer] the number of entries as limit per stream
  # @param block [Integer] the number of milliseconds as blocking timeout
  # @return [Hash{String => Hash{String => Hash}}] the entries
  #
  # source://redis//lib/redis/commands/streams.rb#171
  def xread(keys, ids, count: T.unsafe(nil), block: T.unsafe(nil)); end

  # Fetches a subset of the entries from one or multiple streams related with the consumer group.
  # Optionally blocking.
  #
  # @example With a key
  #   redis.xreadgroup('mygroup', 'consumer1', 'mystream', '>')
  # @example With multiple keys
  #   redis.xreadgroup('mygroup', 'consumer1', %w[mystream1 mystream2], %w[> >])
  # @example With count option
  #   redis.xreadgroup('mygroup', 'consumer1', 'mystream', '>', count: 2)
  # @example With block option
  #   redis.xreadgroup('mygroup', 'consumer1', 'mystream', '>', block: 1000)
  # @example With noack option
  #   redis.xreadgroup('mygroup', 'consumer1', 'mystream', '>', noack: true)
  # @option opts
  # @option opts
  # @option opts
  # @param group [String] the consumer group name
  # @param consumer [String] the consumer name
  # @param keys [Array<String>] one or multiple stream keys
  # @param ids [Array<String>] one or multiple entry ids
  # @param opts [Hash] several options for `XREADGROUP` command
  # @return [Hash{String => Hash{String => Hash}}] the entries
  #
  # source://redis//lib/redis/commands/streams.rb#229
  def xreadgroup(group, consumer, keys, ids, count: T.unsafe(nil), block: T.unsafe(nil), noack: T.unsafe(nil)); end

  # Fetches entries of the stream in descending order.
  #
  # @example Without options
  #   redis.xrevrange('mystream')
  # @example With a specific end
  #   redis.xrevrange('mystream', '0-3')
  # @example With a specific end and start
  #   redis.xrevrange('mystream', '0-3', '0-1')
  # @example With count options
  #   redis.xrevrange('mystream', count: 10)
  # @param key [String] the stream key
  # @param end [String] first entry id of range, default value is `+`
  # @param start [String] last entry id of range, default value is `-`
  # @return [Array<Array<String, Hash>>] the ids and entries pairs
  #
  # source://redis//lib/redis/commands/streams.rb#136
  def xrevrange(key, range_end = T.unsafe(nil), start = T.unsafe(nil), count: T.unsafe(nil)); end

  # Trims older entries of the stream if needed.
  #
  # @example Without options
  #   redis.xtrim('mystream', 1000)
  # @example With options
  #   redis.xtrim('mystream', 1000, approximate: true)
  # @param key [String] the stream key
  # @param mexlen [Integer] max length of entries
  # @param approximate [Boolean] whether to add `~` modifier of maxlen or not
  # @return [Integer] the number of entries actually deleted
  #
  # source://redis//lib/redis/commands/streams.rb#75
  def xtrim(key, maxlen, approximate: T.unsafe(nil)); end

  private

  # source://redis//lib/redis/commands/streams.rb#365
  def _xread(args, keys, ids, blocking_timeout_msec); end
end

module Redis::Commands::Strings
  # Append a value to a key.
  #
  # @param key [String]
  # @param value [String] value to append
  # @return [Integer] length of the string after appending
  #
  # source://redis//lib/redis/commands/strings.rb#254
  def append(key, value); end

  # Decrement the integer value of a key by one.
  #
  # @example
  #   redis.decr("value")
  #   # => 4
  # @param key [String]
  # @return [Integer] value after decrementing it
  #
  # source://redis//lib/redis/commands/strings.rb#14
  def decr(key); end

  # Decrement the integer value of a key by the given number.
  #
  # @example
  #   redis.decrby("value", 5)
  #   # => 0
  # @param key [String]
  # @param decrement [Integer]
  # @return [Integer] value after decrementing it
  #
  # source://redis//lib/redis/commands/strings.rb#27
  def decrby(key, decrement); end

  # Get the value of a key.
  #
  # @param key [String]
  # @return [String]
  #
  # source://redis//lib/redis/commands/strings.rb#190
  def get(key); end

  # Get the value of key and delete the key. This command is similar to GET,
  # except for the fact that it also deletes the key on success.
  #
  # @param key [String]
  # @return [String] the old value stored in the key, or `nil` if the key
  #   did not exist
  #
  # source://redis//lib/redis/commands/strings.rb#274
  def getdel(key); end

  # Get the value of key and optionally set its expiration. GETEX is similar to
  # GET, but is a write command with additional options. When no options are
  # provided, GETEX behaves like GET.
  #
  # @param key [String]
  # @param options [Hash] - `:ex => Integer`: Set the specified expire time, in seconds.
  #   - `:px => Integer`: Set the specified expire time, in milliseconds.
  #   - `:exat => true`: Set the specified Unix time at which the key will
  #   expire, in seconds.
  #   - `:pxat => true`: Set the specified Unix time at which the key will
  #   expire, in milliseconds.
  #   - `:persist => true`: Remove the time to live associated with the key.
  # @return [String] The value of key, or nil when key does not exist.
  #
  # source://redis//lib/redis/commands/strings.rb#292
  def getex(key, ex: T.unsafe(nil), px: T.unsafe(nil), exat: T.unsafe(nil), pxat: T.unsafe(nil), persist: T.unsafe(nil)); end

  # Get a substring of the string stored at a key.
  #
  # @param key [String]
  # @param start [Integer] zero-based start offset
  # @param stop [Integer] zero-based end offset. Use -1 for representing
  #   the end of the string
  # @return [Integer] `0` or `1`
  #
  # source://redis//lib/redis/commands/strings.rb#245
  def getrange(key, start, stop); end

  # Set the string value of a key and return its old value.
  #
  # @param key [String]
  # @param value [String] value to replace the current value with
  # @return [String] the old value stored in the key, or `nil` if the key
  #   did not exist
  #
  # source://redis//lib/redis/commands/strings.rb#264
  def getset(key, value); end

  # Increment the integer value of a key by one.
  #
  # @example
  #   redis.incr("value")
  #   # => 6
  # @param key [String]
  # @return [Integer] value after incrementing it
  #
  # source://redis//lib/redis/commands/strings.rb#39
  def incr(key); end

  # Increment the integer value of a key by the given integer number.
  #
  # @example
  #   redis.incrby("value", 5)
  #   # => 10
  # @param key [String]
  # @param increment [Integer]
  # @return [Integer] value after incrementing it
  #
  # source://redis//lib/redis/commands/strings.rb#52
  def incrby(key, increment); end

  # Increment the numeric value of a key by the given float number.
  #
  # @example
  #   redis.incrbyfloat("value", 1.23)
  #   # => 1.23
  # @param key [String]
  # @param increment [Float]
  # @return [Float] value after incrementing it
  #
  # source://redis//lib/redis/commands/strings.rb#65
  def incrbyfloat(key, increment); end

  # Get the values of all the given keys.
  #
  # @example
  #   redis.mapped_mget("key1", "key2")
  #   # => { "key1" => "v1", "key2" => "v2" }
  # @param keys [Array<String>] array of keys
  # @return [Hash] a hash mapping the specified keys to their values
  # @see #mget
  #
  # source://redis//lib/redis/commands/strings.rb#218
  def mapped_mget(*keys); end

  # Set one or more values.
  #
  # @example
  #   redis.mapped_mset({ "f1" => "v1", "f2" => "v2" })
  #   # => "OK"
  # @param hash [Hash] keys mapping to values
  # @return [String] `"OK"`
  # @see #mset
  #
  # source://redis//lib/redis/commands/strings.rb#154
  def mapped_mset(hash); end

  # Set one or more values, only if none of the keys exist.
  #
  # @example
  #   redis.mapped_msetnx({ "key1" => "v1", "key2" => "v2" })
  #   # => true
  # @param hash [Hash] keys mapping to values
  # @return [Boolean] whether or not all values were set
  # @see #msetnx
  #
  # source://redis//lib/redis/commands/strings.rb#182
  def mapped_msetnx(hash); end

  # Get the values of all the given keys.
  #
  # @example
  #   redis.mget("key1", "key2")
  #   # => ["v1", "v2"]
  # @param keys [Array<String>]
  # @return [Array<String>] an array of values for the specified keys
  # @see #mapped_mget
  #
  # source://redis//lib/redis/commands/strings.rb#204
  def mget(*keys, &blk); end

  # Set one or more values.
  #
  # @example
  #   redis.mset("key1", "v1", "key2", "v2")
  #   # => "OK"
  # @param args [Array<String>] array of keys and values
  # @return [String] `"OK"`
  # @see #mapped_mset
  #
  # source://redis//lib/redis/commands/strings.rb#140
  def mset(*args); end

  # Set one or more values, only if none of the keys exist.
  #
  # @example
  #   redis.msetnx("key1", "v1", "key2", "v2")
  #   # => true
  # @param args [Array<String>] array of keys and values
  # @return [Boolean] whether or not all values were set
  # @see #mapped_msetnx
  #
  # source://redis//lib/redis/commands/strings.rb#168
  def msetnx(*args); end

  # Set the time to live in milliseconds of a key.
  #
  # @param key [String]
  # @param ttl [Integer]
  # @param value [String]
  # @return [String] `"OK"`
  #
  # source://redis//lib/redis/commands/strings.rb#117
  def psetex(key, ttl, value); end

  # Set the string value of a key.
  #
  # @param key [String]
  # @param value [String]
  # @param options [Hash] - `:ex => Integer`: Set the specified expire time, in seconds.
  #   - `:px => Integer`: Set the specified expire time, in milliseconds.
  #   - `:exat => Integer` : Set the specified Unix time at which the key will expire, in seconds.
  #   - `:pxat => Integer` : Set the specified Unix time at which the key will expire, in milliseconds.
  #   - `:nx => true`: Only set the key if it does not already exist.
  #   - `:xx => true`: Only set the key if it already exist.
  #   - `:keepttl => true`: Retain the time to live associated with the key.
  #   - `:get => true`: Return the old string stored at key, or nil if key did not exist.
  # @return [String, Boolean] `"OK"` or true, false if `:nx => true` or `:xx => true`
  #
  # source://redis//lib/redis/commands/strings.rb#83
  def set(key, value, ex: T.unsafe(nil), px: T.unsafe(nil), exat: T.unsafe(nil), pxat: T.unsafe(nil), nx: T.unsafe(nil), xx: T.unsafe(nil), keepttl: T.unsafe(nil), get: T.unsafe(nil)); end

  # Set the time to live in seconds of a key.
  #
  # @param key [String]
  # @param ttl [Integer]
  # @param value [String]
  # @return [String] `"OK"`
  #
  # source://redis//lib/redis/commands/strings.rb#107
  def setex(key, ttl, value); end

  # Set the value of a key, only if the key does not exist.
  #
  # @param key [String]
  # @param value [String]
  # @return [Boolean] whether the key was set or not
  #
  # source://redis//lib/redis/commands/strings.rb#126
  def setnx(key, value); end

  # Overwrite part of a string at key starting at the specified offset.
  #
  # @param key [String]
  # @param offset [Integer] byte offset
  # @param value [String]
  # @return [Integer] length of the string after it was modified
  #
  # source://redis//lib/redis/commands/strings.rb#234
  def setrange(key, offset, value); end

  # Get the length of the value stored in a key.
  #
  # @param key [String]
  # @return [Integer] the length of the value stored in the key, or 0
  #   if the key does not exist
  #
  # source://redis//lib/redis/commands/strings.rb#308
  def strlen(key); end
end

module Redis::Commands::Transactions
  # Discard all commands issued after MULTI.
  #
  # Only call this method when `#multi` was called **without** a block.
  #
  # @return [String] `"OK"`
  # @see #multi
  # @see #exec
  #
  # source://redis//lib/redis/commands/transactions.rb#134
  def discard; end

  # Execute all commands issued after MULTI.
  #
  # Only call this method when `#multi` was called **without** a block.
  #
  # @return [nil, Array<...>] - when commands were not executed, `nil`
  #   - when commands were executed, an array with their replies
  # @see #multi
  # @see #discard
  #
  # source://redis//lib/redis/commands/transactions.rb#122
  def exec; end

  # Mark the start of a transaction block.
  #
  # Passing a block is optional.
  #
  # @example With a block
  #   redis.multi do |multi|
  #   multi.set("key", "value")
  #   multi.incr("counter")
  #   end # => ["OK", 6]
  # @example Without a block
  #   redis.multi
  #   # => "OK"
  #   redis.set("key", "value")
  #   # => "QUEUED"
  #   redis.incr("counter")
  #   # => "QUEUED"
  #   redis.exec
  #   # => ["OK", 6]
  # @return [String, Array<...>] - when a block is not given, `OK`
  #   - when a block is given, an array with replies
  # @see #watch
  # @see #unwatch
  # @yield [multi] the commands that are called inside this block are cached
  #   and written to the server upon returning from it
  # @yieldparam multi [Redis] `self`
  #
  # source://redis//lib/redis/commands/transactions.rb#36
  def multi(&block); end

  # Forget about all watched keys.
  #
  # @return [String] `OK`
  # @see #watch
  # @see #multi
  #
  # source://redis//lib/redis/commands/transactions.rb#108
  def unwatch; end

  # Watch the given keys to determine execution of the MULTI/EXEC block.
  #
  # Using a block is optional, but is necessary for thread-safety.
  #
  # An `#unwatch` is automatically issued if an exception is raised within the
  # block that is a subclass of StandardError and is not a ConnectionError.
  #
  # @example With a block
  #   redis.watch("key") do
  #   if redis.get("key") == "some value"
  #   redis.multi do |multi|
  #   multi.set("key", "other value")
  #   multi.incr("counter")
  #   end
  #   else
  #   redis.unwatch
  #   end
  #   end
  #   # => ["OK", 6]
  # @example Without a block
  #   redis.watch("key")
  #   # => "OK"
  # @param keys [String, Array<String>] one or more keys to watch
  # @return [Object] if using a block, returns the return value of the block
  # @return [String] if not using a block, returns `OK`
  # @see #unwatch
  # @see #multi
  #
  # source://redis//lib/redis/commands/transactions.rb#83
  def watch(*keys); end
end

module Redis::Connection
  class << self
    # Store a list of loaded connection drivers in the Connection module.
    # Redis::Client uses the last required driver by default, and will be aware
    # of the loaded connection drivers if the user chooses to override the
    # default connection driver.
    #
    # source://redis//lib/redis/connection/registry.rb#9
    def drivers; end
  end
end

module Redis::Connection::CommandHelper
  # source://redis//lib/redis/connection/command_helper.rb#8
  def build_command(args); end

  protected

  # source://redis//lib/redis/connection/command_helper.rb#36
  def encode(string); end
end

# source://redis//lib/redis/connection/command_helper.rb#6
Redis::Connection::CommandHelper::COMMAND_DELIMITER = T.let(T.unsafe(nil), String)

class Redis::Connection::Ruby
  include ::Redis::Connection::CommandHelper

  # @return [Ruby] a new instance of Ruby
  #
  # source://redis//lib/redis/connection/ruby.rb#354
  def initialize(sock); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/connection/ruby.rb#358
  def connected?; end

  # source://redis//lib/redis/connection/ruby.rb#362
  def disconnect; end

  # source://redis//lib/redis/connection/ruby.rb#418
  def format_bulk_reply(line); end

  # source://redis//lib/redis/connection/ruby.rb#406
  def format_error_reply(line); end

  # source://redis//lib/redis/connection/ruby.rb#414
  def format_integer_reply(line); end

  # source://redis//lib/redis/connection/ruby.rb#427
  def format_multi_bulk_reply(line); end

  # source://redis//lib/redis/connection/ruby.rb#395
  def format_reply(reply_type, line); end

  # source://redis//lib/redis/connection/ruby.rb#410
  def format_status_reply(line); end

  # source://redis//lib/redis/connection/ruby.rb#329
  def get_tcp_keepalive; end

  # source://redis//lib/redis/connection/ruby.rb#381
  def read; end

  # source://redis//lib/redis/connection/ruby.rb#320
  def set_tcp_keepalive(keepalive); end

  # source://redis//lib/redis/connection/ruby.rb#347
  def set_tcp_nodelay; end

  # source://redis//lib/redis/connection/ruby.rb#369
  def timeout=(timeout); end

  # source://redis//lib/redis/connection/ruby.rb#377
  def write(command); end

  # source://redis//lib/redis/connection/ruby.rb#373
  def write_timeout=(timeout); end

  class << self
    # source://redis//lib/redis/connection/ruby.rb#300
    def connect(config); end
  end
end

# source://redis//lib/redis/connection/ruby.rb#298
Redis::Connection::Ruby::ASTERISK = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/connection/ruby.rb#296
Redis::Connection::Ruby::COLON = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/connection/ruby.rb#297
Redis::Connection::Ruby::DOLLAR = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/connection/ruby.rb#294
Redis::Connection::Ruby::MINUS = T.let(T.unsafe(nil), String)

# source://redis//lib/redis/connection/ruby.rb#295
Redis::Connection::Ruby::PLUS = T.let(T.unsafe(nil), String)

class Redis::Connection::SSLSocket < ::OpenSSL::SSL::SSLSocket
  include ::Redis::Connection::SocketMixin

  # source://redis//lib/redis/connection/ruby.rb#234
  def wait_readable(timeout = T.unsafe(nil)); end

  # source://redis//lib/redis/connection/ruby.rb#240
  def wait_writable(timeout = T.unsafe(nil)); end

  class << self
    # source://redis//lib/redis/connection/ruby.rb#245
    def connect(host, port, timeout, ssl_params); end
  end
end

module Redis::Connection::SocketMixin
  # source://redis//lib/redis/connection/ruby.rb#21
  def initialize(*args); end

  # source://redis//lib/redis/connection/ruby.rb#53
  def _read_from_socket(nbytes, buffer = T.unsafe(nil)); end

  # source://redis//lib/redis/connection/ruby.rb#45
  def gets; end

  # source://redis//lib/redis/connection/ruby.rb#36
  def read(nbytes); end

  # source://redis//lib/redis/connection/ruby.rb#28
  def timeout=(timeout); end

  # source://redis//lib/redis/connection/ruby.rb#72
  def write(buffer); end

  # source://redis//lib/redis/connection/ruby.rb#32
  def write_timeout=(timeout); end
end

# source://redis//lib/redis/connection/ruby.rb#19
Redis::Connection::SocketMixin::CRLF = T.let(T.unsafe(nil), String)

class Redis::Connection::TCPSocket < ::Socket
  include ::Redis::Connection::SocketMixin

  class << self
    # source://redis//lib/redis/connection/ruby.rb#171
    def connect(host, port, timeout); end

    # source://redis//lib/redis/connection/ruby.rb#153
    def connect_addrinfo(addrinfo, port, timeout); end
  end
end

class Redis::Connection::UNIXSocket < ::Socket
  include ::Redis::Connection::SocketMixin

  class << self
    # source://redis//lib/redis/connection/ruby.rb#208
    def connect(path, timeout); end
  end
end

# Raised when connection to a Redis server is lost.
class Redis::ConnectionError < ::Redis::BaseConnectionError; end

class Redis::Deprecated < ::StandardError; end

class Redis::DeprecatedMulti
  # @return [DeprecatedMulti] a new instance of DeprecatedMulti
  #
  # source://redis//lib/redis/pipeline.rb#224
  def initialize(pipeline); end

  # source://redis//lib/redis/pipeline.rb#229
  def __getobj__; end
end

class Redis::DeprecatedPipeline
  # @return [DeprecatedPipeline] a new instance of DeprecatedPipeline
  #
  # source://redis//lib/redis/pipeline.rb#209
  def initialize(pipeline); end

  # source://redis//lib/redis/pipeline.rb#214
  def __getobj__; end
end

class Redis::Future < ::BasicObject
  # @return [Future] a new instance of Future
  #
  # source://redis//lib/redis/pipeline.rb#249
  def initialize(command, transformation, timeout); end

  # source://redis//lib/redis/pipeline.rb#256
  def ==(_other); end

  # source://redis//lib/redis/pipeline.rb#275
  def _command; end

  # source://redis//lib/redis/pipeline.rb#270
  def _set(object); end

  # source://redis//lib/redis/pipeline.rb#288
  def class; end

  # source://redis//lib/redis/pipeline.rb#266
  def inspect; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/pipeline.rb#284
  def is_a?(other); end

  # Returns the value of attribute timeout.
  #
  # source://redis//lib/redis/pipeline.rb#247
  def timeout; end

  # source://redis//lib/redis/pipeline.rb#279
  def value; end
end

# source://redis//lib/redis/pipeline.rb#245
Redis::Future::FutureNotReady = T.let(T.unsafe(nil), Redis::FutureNotReady)

class Redis::FutureNotReady < ::RuntimeError
  # @return [FutureNotReady] a new instance of FutureNotReady
  #
  # source://redis//lib/redis/pipeline.rb#239
  def initialize; end
end

# Raised when the connection was inherited by a child process.
class Redis::InheritedError < ::Redis::BaseConnectionError; end

# Raised when client options are invalid.
class Redis::InvalidClientOptionError < ::Redis::BaseError; end

class Redis::MultiFuture < ::Redis::Future
  # @return [MultiFuture] a new instance of MultiFuture
  #
  # source://redis//lib/redis/pipeline.rb#294
  def initialize(futures); end

  # source://redis//lib/redis/pipeline.rb#299
  def _set(replies); end
end

class Redis::Pipeline
  # @return [Pipeline] a new instance of Pipeline
  #
  # source://redis//lib/redis/pipeline.rb#79
  def initialize(client); end

  # source://redis//lib/redis/pipeline.rb#106
  def call(command, timeout: T.unsafe(nil), &block); end

  # source://redis//lib/redis/pipeline.rb#119
  def call_pipeline(pipeline); end

  # source://redis//lib/redis/pipeline.rb#115
  def call_with_timeout(command, timeout, &block); end

  # Returns the value of attribute client.
  #
  # source://redis//lib/redis/pipeline.rb#74
  def client; end

  # source://redis//lib/redis/pipeline.rb#126
  def commands; end

  # Returns the value of attribute db.
  #
  # source://redis//lib/redis/pipeline.rb#73
  def db; end

  # Sets the attribute db
  #
  # @param value the value to set the attribute db to.
  #
  # source://redis//lib/redis/pipeline.rb#73
  def db=(_arg0); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/pipeline.rb#102
  def empty?; end

  # source://redis//lib/redis/pipeline.rb#143
  def finish(replies, &blk); end

  # Returns the value of attribute futures.
  #
  # source://redis//lib/redis/pipeline.rb#76
  def futures; end

  # Returns the value of attribute futures.
  #
  # source://redis//lib/redis/pipeline.rb#76
  def materialized_futures; end

  # @return [Boolean]
  #
  # source://redis//lib/redis/pipeline.rb#98
  def shutdown?; end

  # source://redis//lib/redis/pipeline.rb#86
  def timeout; end

  # source://redis//lib/redis/pipeline.rb#130
  def timeouts; end

  # source://redis//lib/redis/pipeline.rb#134
  def with_reconnect(val = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/pipeline.rb#90
  def with_reconnect?; end

  # source://redis//lib/redis/pipeline.rb#139
  def without_reconnect(&blk); end

  # @return [Boolean]
  #
  # source://redis//lib/redis/pipeline.rb#94
  def without_reconnect?; end

  class << self
    # source://redis//lib/redis/pipeline.rb#52
    def deprecation_warning(method, caller_locations); end
  end
end

class Redis::Pipeline::Multi < ::Redis::Pipeline
  # source://redis//lib/redis/pipeline.rb#198
  def commands; end

  # source://redis//lib/redis/pipeline.rb#156
  def finish(replies); end

  # source://redis//lib/redis/pipeline.rb#178
  def materialized_futures; end

  # source://redis//lib/redis/pipeline.rb#190
  def timeouts; end
end

# source://redis//lib/redis/pipeline.rb#46
Redis::Pipeline::REDIS_INTERNAL_PATH = T.let(T.unsafe(nil), String)

# Redis use MonitorMixin#synchronize and this class use DelegateClass which we want to filter out.
# Both are in the stdlib so we can simply filter the entire stdlib out.
#
# source://redis//lib/redis/pipeline.rb#49
Redis::Pipeline::STDLIB_PATH = T.let(T.unsafe(nil), String)

class Redis::PipelinedConnection
  include ::Redis::Commands::Bitmaps
  include ::Redis::Commands::Cluster
  include ::Redis::Commands::Connection
  include ::Redis::Commands::Geo
  include ::Redis::Commands::Hashes
  include ::Redis::Commands::HyperLogLog
  include ::Redis::Commands::Keys
  include ::Redis::Commands::Lists
  include ::Redis::Commands::Pubsub
  include ::Redis::Commands::Scripting
  include ::Redis::Commands::Server
  include ::Redis::Commands::Sets
  include ::Redis::Commands::SortedSets
  include ::Redis::Commands::Streams
  include ::Redis::Commands::Strings
  include ::Redis::Commands::Transactions
  include ::Redis::Commands

  # @return [PipelinedConnection] a new instance of PipelinedConnection
  #
  # source://redis//lib/redis/pipeline.rb#7
  def initialize(pipeline); end

  # source://redis//lib/redis/pipeline.rb#25
  def call_pipeline(pipeline); end

  # source://redis//lib/redis/pipeline.rb#13
  def db; end

  # source://redis//lib/redis/pipeline.rb#17
  def db=(db); end

  # @yield [_self]
  # @yieldparam _self [Redis::PipelinedConnection] the object that the method was called on
  #
  # source://redis//lib/redis/pipeline.rb#21
  def pipelined; end

  private

  # source://redis//lib/redis/pipeline.rb#40
  def send_blocking_command(command, timeout, &block); end

  # source://redis//lib/redis/pipeline.rb#36
  def send_command(command, &block); end

  # @yield [_self]
  # @yieldparam _self [Redis::PipelinedConnection] the object that the method was called on
  #
  # source://redis//lib/redis/pipeline.rb#32
  def synchronize; end
end

# Raised by the connection when a protocol error occurs.
class Redis::ProtocolError < ::Redis::BaseError
  # @return [ProtocolError] a new instance of ProtocolError
  #
  # source://redis//lib/redis/errors.rb#10
  def initialize(reply_type); end
end

class Redis::SubscribedClient
  # @return [SubscribedClient] a new instance of SubscribedClient
  #
  # source://redis//lib/redis/subscribe.rb#5
  def initialize(client); end

  # source://redis//lib/redis/subscribe.rb#9
  def call(command); end

  # source://redis//lib/redis/subscribe.rb#21
  def psubscribe(*channels, &block); end

  # source://redis//lib/redis/subscribe.rb#25
  def psubscribe_with_timeout(timeout, *channels, &block); end

  # source://redis//lib/redis/subscribe.rb#33
  def punsubscribe(*channels); end

  # source://redis//lib/redis/subscribe.rb#13
  def subscribe(*channels, &block); end

  # source://redis//lib/redis/subscribe.rb#17
  def subscribe_with_timeout(timeout, *channels, &block); end

  # source://redis//lib/redis/subscribe.rb#29
  def unsubscribe(*channels); end

  protected

  # source://redis//lib/redis/subscribe.rb#39
  def subscription(start, stop, channels, block, timeout = T.unsafe(nil)); end
end

class Redis::Subscription
  # @return [Subscription] a new instance of Subscription
  # @yield [_self]
  # @yieldparam _self [Redis::Subscription] the object that the method was called on
  #
  # source://redis//lib/redis/subscribe.rb#58
  def initialize; end

  # Returns the value of attribute callbacks.
  #
  # source://redis//lib/redis/subscribe.rb#56
  def callbacks; end

  # source://redis//lib/redis/subscribe.rb#74
  def message(&block); end

  # source://redis//lib/redis/subscribe.rb#86
  def pmessage(&block); end

  # source://redis//lib/redis/subscribe.rb#78
  def psubscribe(&block); end

  # source://redis//lib/redis/subscribe.rb#82
  def punsubscribe(&block); end

  # source://redis//lib/redis/subscribe.rb#66
  def subscribe(&block); end

  # source://redis//lib/redis/subscribe.rb#70
  def unsubscribe(&block); end
end

# Raised when performing I/O times out.
class Redis::TimeoutError < ::Redis::BaseConnectionError; end

# source://redis//lib/redis/version.rb#4
Redis::VERSION = T.let(T.unsafe(nil), String)
