# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rack-protection` gem.
# Please instead update this file by running `bin/tapioca gem rack-protection`.

module Rack::Protection
  class << self
    # source://rack-protection//lib/rack/protection.rb#28
    def new(app, options = T.unsafe(nil)); end
  end
end

# Prevented attack::   CSRF
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Cross-site_request_forgery
#
# This middleware only accepts requests other than <tt>GET</tt>,
# <tt>HEAD</tt>, <tt>OPTIONS</tt>, <tt>TRACE</tt> if their given access
# token matches the token included in the session.
#
# It checks the <tt>X-CSRF-Token</tt> header and the <tt>POST</tt> form
# data.
#
# It is not OOTB-compatible with the {rack-csrf}[https://rubygems.org/gems/rack_csrf] gem.
# For that, the following patch needs to be applied:
#
#   Rack::Protection::AuthenticityToken.default_options(key: "csrf.token", authenticity_param: "_csrf")
#
# == Options
#
# [<tt>:authenticity_param</tt>] the name of the param that should contain
#                                the token on a request. Default value:
#                                <tt>"authenticity_token"</tt>
#
# [<tt>:key</tt>] the name of the param that should contain
#                                the token in the session. Default value:
#                                <tt>:csrf</tt>
#
# [<tt>:allow_if</tt>] a proc for custom allow/deny logic. Default value:
#                                <tt>nil</tt>
#
# == Example: Forms application
#
# To show what the AuthenticityToken does, this section includes a sample
# program which shows two forms. One with, and one without a CSRF token
# The one without CSRF token field will get a 403 Forbidden response.
#
# Install the gem, then run the program:
#
#   gem install 'rack-protection'
#   ruby server.rb
#
# Here is <tt>server.rb</tt>:
#
#   require 'rack/protection'
#
#   app = Rack::Builder.app do
#     use Rack::Session::Cookie, secret: 'secret'
#     use Rack::Protection::AuthenticityToken
#
#     run -> (env) do
#       [200, {}, [
#         <<~EOS
#           <!DOCTYPE html>
#           <html lang="en">
#           <head>
#             <meta charset="UTF-8" />
#             <title>rack-protection minimal example</title>
#           </head>
#           <body>
#             <h1>Without Authenticity Token</h1>
#             <p>This takes you to <tt>Forbidden</tt></p>
#             <form action="" method="post">
#               <input type="text" name="foo" />
#               <input type="submit" />
#             </form>
#
#             <h1>With Authenticity Token</h1>
#             <p>This successfully takes you to back to this form.</p>
#             <form action="" method="post">
#               <input type="hidden" name="authenticity_token" value="#{Rack::Protection::AuthenticityToken.token(env['rack.session'])}" />
#               <input type="text" name="foo" />
#               <input type="submit" />
#             </form>
#           </body>
#           </html>
#         EOS
#       ]]
#     end
#   end
#
#   Rack::Handler::WEBrick.run app
#
# == Example: Customize which POST parameter holds the token
#
# To customize the authenticity parameter for form data, use the
# <tt>:authenticity_param</tt> option:
#   use Rack::Protection::AuthenticityToken, authenticity_param: 'your_token_param_name'
class Rack::Protection::AuthenticityToken < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#112
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#124
  def mask_authenticity_token(session, path: T.unsafe(nil), method: T.unsafe(nil)); end

  private

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#206
  def compare_with_global_token(token, session); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#210
  def compare_with_per_form_token(token, session, request); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#202
  def compare_with_real_token(token, session); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#231
  def decode_token(token); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#227
  def encode_token(token); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#219
  def global_token(session); end

  # Creates a masked version of the authenticity token that varies
  # on each request. The masking is used to mitigate SSL attacks
  # like BREACH.
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#177
  def mask_token(token); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#198
  def masked_token?(token); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#223
  def per_form_token(session, path, method); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#215
  def real_token(session); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#141
  def set_token(session); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#235
  def token_hmac(session, identifier); end

  # Essentially the inverse of +mask_token+.
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#185
  def unmask_token(masked_token); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#194
  def unmasked_token?(token); end

  # Checks the client's masked token to see if it matches the
  # session token.
  #
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/authenticity_token.rb#147
  def valid_token?(env, token); end

  # source://rack-protection//lib/rack/protection/authenticity_token.rb#243
  def xor_byte_strings(s1, s2); end

  class << self
    # source://rack-protection//lib/rack/protection/authenticity_token.rb#108
    def random_token; end

    # source://rack-protection//lib/rack/protection/authenticity_token.rb#104
    def token(session, path: T.unsafe(nil), method: T.unsafe(nil)); end
  end
end

# source://rack-protection//lib/rack/protection/authenticity_token.rb#136
Rack::Protection::AuthenticityToken::GLOBAL_TOKEN_IDENTIFIER = T.let(T.unsafe(nil), String)

# source://rack-protection//lib/rack/protection/authenticity_token.rb#98
Rack::Protection::AuthenticityToken::TOKEN_LENGTH = T.let(T.unsafe(nil), Integer)

class Rack::Protection::Base
  # @return [Base] a new instance of Base
  #
  # source://rack-protection//lib/rack/protection/base.rb#35
  def initialize(app, options = T.unsafe(nil)); end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/base.rb#44
  def accepts?(env); end

  # Returns the value of attribute app.
  #
  # source://rack-protection//lib/rack/protection/base.rb#21
  def app; end

  # source://rack-protection//lib/rack/protection/base.rb#48
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#31
  def default_options; end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def deny(env); end

  # source://rack-protection//lib/rack/protection/base.rb#95
  def drop_session(env); end

  # source://rack-protection//lib/rack/protection/base.rb#117
  def encrypt(value); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/base.rb#127
  def html?(headers); end

  # source://rack-protection//lib/rack/protection/base.rb#68
  def instrument(env); end

  # Returns the value of attribute options.
  #
  # source://rack-protection//lib/rack/protection/base.rb#21
  def options; end

  # source://rack-protection//lib/rack/protection/base.rb#107
  def origin(env); end

  # source://rack-protection//lib/rack/protection/base.rb#111
  def random_string(secure = T.unsafe(nil)); end

  # source://rack-protection//lib/rack/protection/base.rb#56
  def react(env); end

  # source://rack-protection//lib/rack/protection/base.rb#99
  def referrer(env); end

  # source://rack-protection//lib/rack/protection/base.rb#80
  def report(env); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/base.rb#40
  def safe?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#121
  def secure_compare(a, b); end

  # source://rack-protection//lib/rack/protection/base.rb#89
  def session(env); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/base.rb#85
  def session?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#61
  def warn(env, message); end

  class << self
    # source://rack-protection//lib/rack/protection/base.rb#23
    def default_options(options); end

    # source://rack-protection//lib/rack/protection/base.rb#27
    def default_reaction(reaction); end
  end
end

# source://rack-protection//lib/rack/protection/base.rb#12
Rack::Protection::Base::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# Prevented attack::   XSS and others
# Supported browsers:: Firefox 23+, Safari 7+, Chrome 25+, Opera 15+
#
# Description:: Content Security Policy, a mechanism web applications
#               can use to mitigate a broad class of content injection
#               vulnerabilities, such as cross-site scripting (XSS).
#               Content Security Policy is a declarative policy that lets
#               the authors (or server administrators) of a web application
#               inform the client about the sources from which the
#               application expects to load resources.
#
# More info::   W3C CSP Level 1 : https://www.w3.org/TR/CSP1/ (deprecated)
#               W3C CSP Level 2 : https://www.w3.org/TR/CSP2/ (current)
#               W3C CSP Level 3 : https://www.w3.org/TR/CSP3/ (draft)
#               https://developer.mozilla.org/en-US/docs/Web/Security/CSP
#               http://caniuse.com/#search=ContentSecurityPolicy
#               http://content-security-policy.com/
#               https://securityheaders.io
#               https://scotthelme.co.uk/csp-cheat-sheet/
#               http://www.html5rocks.com/en/tutorials/security/content-security-policy/
#
# Sets the 'Content-Security-Policy[-Report-Only]' header.
#
# Options: ContentSecurityPolicy configuration is a complex topic with
#          several levels of support that has evolved over time.
#          See the W3C documentation and the links in the more info
#          section for CSP usage examples and best practices. The
#          CSP3 directives in the 'NO_ARG_DIRECTIVES' constant need to be
#          presented in the options hash with a boolean 'true' in order
#          to be used in a policy.
class Rack::Protection::ContentSecurityPolicy < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/content_security_policy.rb#72
  def call(env); end

  # source://rack-protection//lib/rack/protection/content_security_policy.rb#53
  def csp_policy; end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end
end

# source://rack-protection//lib/rack/protection/content_security_policy.rb#42
Rack::Protection::ContentSecurityPolicy::DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://rack-protection//lib/rack/protection/content_security_policy.rb#50
Rack::Protection::ContentSecurityPolicy::NO_ARG_DIRECTIVES = T.let(T.unsafe(nil), Array)

# Prevented attack::   Cookie Tossing
# Supported browsers:: all
# More infos::         https://github.com/blog/1466-yummy-cookies-across-domains
#
# Does not accept HTTP requests if the HTTP_COOKIE header contains more than one
# session cookie. This does not protect against a cookie overflow attack.
#
# Options:
#
# session_key:: The name of the session cookie (default: 'rack.session')
class Rack::Protection::CookieTossing < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#30
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#57
  def bad_cookies; end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#22
  def call(env); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#61
  def cookie_paths(path); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#68
  def empty_cookie(host, path); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#51
  def redirect(env); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#42
  def remove_bad_cookies(request, response); end

  # source://rack-protection//lib/rack/protection/cookie_tossing.rb#72
  def session_key; end
end

# Rack::Protection::EncryptedCookie provides simple cookie based session management.
# By default, the session is a Ruby Hash stored as base64 encoded marshalled
# data set to :key (default: rack.session).  The object that encodes the
# session data is configurable and must respond to +encode+ and +decode+.
# Both methods must take a string and return a string.
#
# When the secret key is set, cookie data is checked for data integrity.
# The old_secret key is also accepted and allows graceful secret rotation.
# A legacy_hmac_secret is also accepted and is used to upgrade existing
# sessions to the new encryption scheme.
#
# There is also a legacy_hmac_coder option which can be set if a non-default
# coder was used for legacy session cookies.
#
# Example:
#
#     use Rack::Protection::EncryptedCookie,
#                                :key => 'rack.session',
#                                :domain => 'foo.com',
#                                :path => '/',
#                                :expire_after => 2592000,
#                                :secret => 'change_me',
#                                :old_secret => 'old_secret'
#
#     All parameters are optional.
#
# Example using legacy HMAC options
#
#   Rack::Protection:EncryptedCookie.new(application, {
#     # The secret used for legacy HMAC cookies
#     legacy_hmac_secret: 'legacy secret',
#     # legacy_hmac_coder will default to Rack::Protection::EncryptedCookie::Base64::Marshal
#     legacy_hmac_coder: Rack::Protection::EncryptedCookie::Identity.new,
#     # legacy_hmac will default to OpenSSL::Digest::SHA1
#     legacy_hmac: OpenSSL::Digest::SHA256
#   })
#
#
#   Rack::Protection::EncryptedCookie.new(application, {
#     :coder => Rack::Protection::EncryptedCookie::Identity.new
#   })
#
#
#   Rack::Protection::EncryptedCookie.new(application, {
#     :coder => Class.new {
#       def encode(str); str.reverse; end
#       def decode(str); str.reverse; end
#     }.new
#   })
class Rack::Protection::EncryptedCookie < ::Rack::Session::Abstract::Persisted
  # @return [EncryptedCookie] a new instance of EncryptedCookie
  #
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#143
  def initialize(app, options = T.unsafe(nil)); end

  # Returns the value of attribute coder.
  #
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#141
  def coder; end

  private

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#252
  def delete_session(_req, _session_id, options); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#257
  def digest_match?(data, digest); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#200
  def extract_session_id(request); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#194
  def find_session(req, _sid); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#263
  def generate_hmac(data); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#230
  def persistent_session_id!(data, sid = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#267
  def secure?(options); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#204
  def unpacked_cookie_data(request); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#236
  def write_session(req, session_id, session, _options); end
end

# Encode session cookies as Base64
class Rack::Protection::EncryptedCookie::Base64
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#71
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#67
  def encode(str); end
end

# N.B. Unlike other encoding methods, the contained objects must be a
# valid JSON composite type, either a Hash or an Array.
class Rack::Protection::EncryptedCookie::Base64::JSON < ::Rack::Protection::EncryptedCookie::Base64
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#99
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#95
  def encode(obj); end
end

# Encode session cookies as Marshaled Base64 data
class Rack::Protection::EncryptedCookie::Base64::Marshal < ::Rack::Protection::EncryptedCookie::Base64
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#81
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#77
  def encode(str); end
end

class Rack::Protection::EncryptedCookie::Base64::ZipJSON < ::Rack::Protection::EncryptedCookie::Base64
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#115
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#111
  def encode(obj); end
end

# Use no encoding for session cookies
class Rack::Protection::EncryptedCookie::Identity
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#128
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#127
  def encode(str); end
end

class Rack::Protection::EncryptedCookie::Marshal
  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#136
  def decode(str); end

  # source://rack-protection//lib/rack/protection/encrypted_cookie.rb#132
  def encode(str); end
end

module Rack::Protection::Encryptor
  class << self
    # source://rack-protection//lib/rack/protection/encryptor.rb#15
    def base64_decode(str); end

    # source://rack-protection//lib/rack/protection/encryptor.rb#11
    def base64_encode(str); end

    # source://rack-protection//lib/rack/protection/encryptor.rb#38
    def decrypt_message(data, secret); end

    # @raise [ArgumentError]
    #
    # source://rack-protection//lib/rack/protection/encryptor.rb#19
    def encrypt_message(data, secret, auth_data = T.unsafe(nil)); end
  end
end

# source://rack-protection//lib/rack/protection/encryptor.rb#8
Rack::Protection::Encryptor::CIPHER = T.let(T.unsafe(nil), String)

# source://rack-protection//lib/rack/protection/encryptor.rb#9
Rack::Protection::Encryptor::DELIMITER = T.let(T.unsafe(nil), String)

# Prevented attack::   XSS
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Cross-site_scripting
#
# Automatically escapes Rack::Request#params so they can be embedded in HTML
# or JavaScript without any further issues.
#
# Options:
# escape:: What escaping modes to use, should be Symbol or Array of Symbols.
#          Available: :html (default), :javascript, :url
class Rack::Protection::EscapedParams < ::Rack::Protection::Base
  extend ::Rack::Utils

  # @return [EscapedParams] a new instance of EscapedParams
  #
  # source://rack-protection//lib/rack/protection/escaped_params.rb#36
  def initialize(*_arg0); end

  # source://rack-protection//lib/rack/protection/escaped_params.rb#50
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/escaped_params.rb#70
  def escape(object); end

  # source://rack-protection//lib/rack/protection/escaped_params.rb#79
  def escape_hash(hash); end

  # source://rack-protection//lib/rack/protection/escaped_params.rb#85
  def escape_string(str); end

  # source://rack-protection//lib/rack/protection/escaped_params.rb#64
  def handle(hash); end

  class << self
    # source://rack/2.2.5/lib/rack/utils.rb#173
    def escape_html(string); end

    private

    # source://rack/2.2.5/lib/rack/utils.rb#38
    def escape_url(s); end
  end
end

# Prevented attack::   CSRF
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Cross-site_request_forgery
#
# Only accepts submitted forms if a given access token matches the token
# included in the session. Does not expect such a token from Ajax request.
#
# This middleware is not used when using the Rack::Protection collection,
# since it might be a security issue, depending on your application
#
# Compatible with rack-csrf.
class Rack::Protection::FormToken < ::Rack::Protection::AuthenticityToken
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/form_token.rb#20
  def accepts?(env); end
end

# Prevented attack::   Clickjacking
# Supported browsers:: Internet Explorer 8, Firefox 3.6.9, Opera 10.50,
#                      Safari 4.0, Chrome 4.1.249.1042 and later
# More infos::         https://developer.mozilla.org/en/The_X-FRAME-OPTIONS_response_header
#
# Sets X-Frame-Options header to tell the browser avoid embedding the page
# in a frame.
#
# Options:
#
# frame_options:: Defines who should be allowed to embed the page in a
#                 frame. Use :deny to forbid any embedding, :sameorigin
#                 to allow embedding from the same origin (default).
class Rack::Protection::FrameOptions < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/frame_options.rb#32
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/frame_options.rb#24
  def frame_options; end
end

# Prevented attack::   CSRF
# Supported browsers:: Google Chrome 2, Safari 4 and later
# More infos::         http://en.wikipedia.org/wiki/Cross-site_request_forgery
#                      http://tools.ietf.org/html/draft-abarth-origin
#
# Does not accept unsafe HTTP requests when value of Origin HTTP request header
# does not match default or permitted URIs.
#
# If you want to permit a specific domain, you can pass in as the `:permitted_origins` option:
#
#     use Rack::Protection, permitted_origins: ["http://localhost:3000", "http://127.0.01:3000"]
#
# The `:allow_if` option can also be set to a proc to use custom allow/deny logic.
class Rack::Protection::HttpOrigin < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/http_origin.rb#32
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/http_origin.rb#26
  def base_url(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end
end

# source://rack-protection//lib/rack/protection/http_origin.rb#22
Rack::Protection::HttpOrigin::DEFAULT_PORTS = T.let(T.unsafe(nil), Hash)

# Prevented attack::   IP spoofing
# Supported browsers:: all
# More infos::         http://blog.c22.cc/2011/04/22/surveymonkey-ip-spoofing/
#
# Detect (some) IP spoofing attacks.
class Rack::Protection::IPSpoofing < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/ip_spoofing.rb#16
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end
end

# Prevented attack::   CSRF
# Supported browsers:: all
# More infos::         http://flask.pocoo.org/docs/0.10/security/#json-security
#                      http://haacked.com/archive/2008/11/20/anatomy-of-a-subtle-json-vulnerability.aspx
#
# JSON GET APIs are vulnerable to being embedded as JavaScript when the
# Array prototype has been patched to track data. Checks the referrer
# even on GET requests if the content type is JSON.
#
# If request includes Origin HTTP header, defers to HttpOrigin to determine
# if the request is safe. Please refer to the documentation for more info.
#
# The `:allow_if` option can be set to a proc to use custom allow/deny logic.
class Rack::Protection::JsonCsrf < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/json_csrf.rb#26
  def call(env); end

  # source://rack-protection//lib/rack/protection/json_csrf.rb#55
  def close_body(body); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/json_csrf.rb#39
  def has_vector?(request, headers); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def react(env); end

  # source://rack-protection//lib/rack/protection/json_csrf.rb#47
  def react_and_close(env, body); end
end

# Prevented attack::   Directory traversal
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Directory_traversal
#
# Unescapes '/' and '.', expands +path_info+.
# Thus <tt>GET /foo/%2e%2e%2fbar</tt> becomes <tt>GET /bar</tt>.
class Rack::Protection::PathTraversal < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/path_traversal.rb#15
  def call(env); end

  # source://rack-protection//lib/rack/protection/path_traversal.rb#23
  def cleanup(path); end
end

# Prevented attack::   Secret leakage, third party tracking
# Supported browsers:: mixed support
# More infos::         https://www.w3.org/TR/referrer-policy/
#                      https://caniuse.com/#search=referrer-policy
#
# Sets Referrer-Policy header to tell the browser to limit the Referer header.
#
# Options:
# referrer_policy:: The policy to use (default: 'strict-origin-when-cross-origin')
class Rack::Protection::ReferrerPolicy < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/referrer_policy.rb#20
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end
end

# Prevented attack::   CSRF
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Cross-site_request_forgery
#
# Does not accept unsafe HTTP requests if the Referer [sic] header is set to
# a different host.
class Rack::Protection::RemoteReferrer < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/remote_referrer.rb#17
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end
end

# Prevented attack::   CSRF
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Cross-site_request_forgery
#
# Only accepts unsafe HTTP requests if a given access token matches the token
# included in the session *or* the request comes from the same origin.
#
# Compatible with rack-csrf.
class Rack::Protection::RemoteToken < ::Rack::Protection::AuthenticityToken
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/remote_token.rb#19
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#75
  def default_reaction(env); end
end

# Prevented attack::   Session Hijacking
# Supported browsers:: all
# More infos::         http://en.wikipedia.org/wiki/Session_hijacking
#
# Tracks request properties like the user agent in the session and empties
# the session if those properties change. This essentially prevents attacks
# from Firesheep. Since all headers taken into consideration can be
# spoofed, too, this will not prevent determined hijacking attempts.
class Rack::Protection::SessionHijacking < ::Rack::Protection::Base
  # @return [Boolean]
  #
  # source://rack-protection//lib/rack/protection/session_hijacking.rb#21
  def accepts?(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/base.rb#95
  def default_reaction(env); end

  # source://rack-protection//lib/rack/protection/session_hijacking.rb#32
  def encode(value); end
end

# Prevented attack::   Protects against against protocol downgrade attacks and cookie hijacking.
# Supported browsers:: all
# More infos::         https://en.wikipedia.org/wiki/HTTP_Strict_Transport_Security
#
# browser will prevent any communications from being sent over HTTP
# to the specified domain and will instead send all communications over HTTPS.
# It also prevents HTTPS click through prompts on browsers.
#
# Options:
#
# max_age:: How long future requests to the domain should go over HTTPS; specified in seconds
# include_subdomains:: If all present and future subdomains will be HTTPS
# preload:: Allow this domain to be included in browsers HSTS preload list. See https://hstspreload.appspot.com/
class Rack::Protection::StrictTransport < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/strict_transport.rb#34
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end

  # source://rack-protection//lib/rack/protection/strict_transport.rb#25
  def strict_transport; end
end

# source://rack-protection//lib/rack/protection/version.rb#5
Rack::Protection::VERSION = T.let(T.unsafe(nil), String)

# Prevented attack::   Non-permanent XSS
# Supported browsers:: Internet Explorer 8+ and Chrome
# More infos::         http://blogs.msdn.com/b/ie/archive/2008/07/01/ie8-security-part-iv-the-xss-filter.aspx
#
# Sets X-XSS-Protection header to tell the browser to block attacks.
#
# Options:
# xss_mode:: How the browser should prevent the attack (default: :block)
class Rack::Protection::XSSHeader < ::Rack::Protection::Base
  # source://rack-protection//lib/rack/protection/xss_header.rb#19
  def call(env); end

  # source://rack-protection//lib/rack/protection/base.rb#24
  def default_options; end
end
