# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `puma` gem.
# Please instead update this file by running `bin/tapioca gem puma`.

# note that dsl is loaded at end of file, requires ConfigDefault constants
module Puma
  class << self
    # @return [Boolean]
    #
    # source://puma//lib/puma.rb#47
    def abstract_unix_socket?; end

    # @return [Boolean]
    # @version 5.0.0
    #
    # source://puma//lib/puma/detect.rb#41
    def forkable?; end

    # @return [Boolean]
    #
    # source://puma//lib/puma/detect.rb#23
    def jruby?; end

    # @return [Boolean]
    # @version 5.0.0
    #
    # source://puma//lib/puma/detect.rb#36
    def mri?; end

    # @return [Boolean]
    #
    # source://puma//lib/puma/detect.rb#27
    def osx?; end

    # source://puma//lib/puma.rb#77
    def set_thread_name(name); end

    # @return [Boolean]
    #
    # source://puma//lib/puma.rb#43
    def ssl?; end

    # source://puma//lib/puma.rb#67
    def stats; end

    # @version 5.0.0
    #
    # source://puma//lib/puma.rb#73
    def stats_hash; end

    # source://puma//lib/puma.rb#62
    def stats_object=(val); end

    # @return [Boolean]
    #
    # source://puma//lib/puma/detect.rb#31
    def windows?; end
  end
end

class Puma::Binder
  include ::Puma::Const

  # @return [Binder] a new instance of Binder
  #
  # source://puma//lib/puma/binder.rb#22
  def initialize(log_writer, conf = T.unsafe(nil)); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def activated_sockets; end

  # source://puma//lib/puma/binder.rb#353
  def add_ssl_listener(host, port, ctx, optimize_for_latency = T.unsafe(nil), backlog = T.unsafe(nil)); end

  # Tell the server to listen on host +host+, port +port+.
  # If +optimize_for_latency+ is true (the default) then clients connecting
  # will be optimized for latency over throughput.
  #
  # +backlog+ indicates how many unaccepted connections the kernel should
  # allow to accumulate before returning connection refused.
  #
  # source://puma//lib/puma/binder.rb#325
  def add_tcp_listener(host, port, optimize_for_latency = T.unsafe(nil), backlog = T.unsafe(nil)); end

  # Tell the server to listen on +path+ as a UNIX domain socket.
  #
  # source://puma//lib/puma/binder.rb#404
  def add_unix_listener(path, umask = T.unsafe(nil), mode = T.unsafe(nil), backlog = T.unsafe(nil)); end

  # source://puma//lib/puma/binder.rb#66
  def close; end

  # source://puma//lib/puma/binder.rb#451
  def close_listeners; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#72
  def connected_ports; end

  # systemd socket activation.
  # LISTEN_FDS = number of listening sockets. e.g. 2 means accept on 2 sockets w/descriptors 3 and 4.
  # LISTEN_PID = PID of the service process, aka us
  #
  # @see https://www.freedesktop.org/software/systemd/man/systemd-socket-activate.html
  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#90
  def create_activated_fds(env_hash); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#77
  def create_inherited_fds(env_hash); end

  # source://puma//lib/puma/binder.rb#62
  def env(sock); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def envs; end

  # source://puma//lib/puma/binder.rb#384
  def inherit_ssl_listener(fd, ctx); end

  # source://puma//lib/puma/binder.rb#346
  def inherit_tcp_listener(host, port, fd); end

  # source://puma//lib/puma/binder.rb#439
  def inherit_unix_listener(path, fd); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def inherited_fds; end

  # Returns the value of attribute ios.
  #
  # source://puma//lib/puma/binder.rb#54
  def ios; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#60
  def ios=(_arg0); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def listeners; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#60
  def listeners=(_arg0); end

  # source://puma//lib/puma/binder.rb#302
  def localhost_authority; end

  # source://puma//lib/puma/binder.rb#306
  def localhost_authority_context; end

  # source://puma//lib/puma/binder.rb#145
  def parse(binds, log_writer = T.unsafe(nil), log_msg = T.unsafe(nil)); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def proto_env; end

  # source://puma//lib/puma/binder.rb#461
  def redirects_for_restart; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#468
  def redirects_for_restart_env; end

  # Synthesize binds from systemd socket activation
  #
  # When systemd socket activation is enabled, it can be tedious to keep the
  # binds in sync. This method can synthesize any binds based on the received
  # activated sockets. Any existing matching binds will be respected.
  #
  # When only_matching is true in, all binds that do not match an activated
  # socket is removed in place.
  #
  # It's a noop if no activated sockets were received.
  #
  # source://puma//lib/puma/binder.rb#118
  def synthesize_binds_from_activated_fs(binds, only_matching); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#57
  def unix_paths; end

  private

  # source://puma//lib/puma/binder.rb#484
  def loc_addr_str(io); end

  # source://puma//lib/puma/binder.rb#477
  def loopback_addresses; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/binder.rb#494
  def socket_activation_fd(int); end
end

# source://puma//lib/puma/binder.rb#20
Puma::Binder::RACK_VERSION = T.let(T.unsafe(nil), Array)

# An instance of this class represents a unique request from a client.
# For example, this could be a web request from a browser or from CURL.
#
# An instance of `Puma::Client` can be used as if it were an IO object
# by the reactor. The reactor is expected to call `#to_io`
# on any non-IO objects it polls. For example, nio4r internally calls
# `IO::try_convert` (which may call `#to_io`) when a new socket is
# registered.
#
# Instances of this class are responsible for knowing if
# the header and body are fully buffered via the `try_to_finish` method.
# They can be used to "time out" a response via the `timeout_at` reader.
class Puma::Client
  include ::Puma::Const
  extend ::Forwardable

  # @return [Client] a new instance of Client
  #
  # source://puma//lib/puma/client.rb#66
  def initialize(io, env = T.unsafe(nil)); end

  # Returns the value of attribute body.
  #
  # source://puma//lib/puma/client.rb#100
  def body; end

  # For the hijack protocol (allows us to just put the Client object
  # into the env)
  #
  # source://puma//lib/puma/client.rb#122
  def call; end

  # Returns true if the persistent connection can be closed immediately
  # without waiting for the configured idle/shutdown timeout.
  #
  # @return [Boolean]
  # @version 5.0.0
  #
  # source://puma//lib/puma/client.rb#301
  def can_close?; end

  # source://puma//lib/puma/client.rb#180
  def close; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def closed?(*args, **_arg1, &block); end

  # source://puma//lib/puma/client.rb#252
  def eagerly_finish; end

  # Returns the value of attribute env.
  #
  # source://puma//lib/puma/client.rb#100
  def env; end

  # source://puma//lib/puma/client.rb#306
  def expect_proxy_proto=(val); end

  # source://puma//lib/puma/client.rb#258
  def finish(timeout); end

  # Returns the value of attribute hijacked.
  #
  # source://puma//lib/puma/client.rb#100
  def hijacked; end

  # source://puma//lib/puma/client.rb#128
  def in_data_phase; end

  # source://puma//lib/puma/client.rb#116
  def inspect; end

  # Returns the value of attribute io.
  #
  # source://puma//lib/puma/client.rb#100
  def io; end

  # Returns the value of attribute io_buffer.
  #
  # source://puma//lib/puma/client.rb#100
  def io_buffer; end

  # Test to see if io meets a bare minimum of functioning, @to_io needs to be
  # used for MiniSSL::Socket
  #
  # @return [Boolean]
  #
  # source://puma//lib/puma/client.rb#111
  def io_ok?; end

  # Returns the value of attribute listener.
  #
  # source://puma//lib/puma/client.rb#105
  def listener; end

  # Sets the attribute listener
  #
  # @param value the value to set the attribute listener to.
  #
  # source://puma//lib/puma/client.rb#105
  def listener=(_arg0); end

  # source://puma//lib/puma/client.rb#287
  def peer_family; end

  # source://puma//lib/puma/client.rb#275
  def peerip; end

  # Sets the attribute peerip
  #
  # @param value the value to set the attribute peerip to.
  #
  # source://puma//lib/puma/client.rb#103
  def peerip=(_arg0); end

  # Returns the value of attribute ready.
  #
  # source://puma//lib/puma/client.rb#100
  def ready; end

  # Returns the value of attribute remote_addr_header.
  #
  # source://puma//lib/puma/client.rb#105
  def remote_addr_header; end

  # Sets the attribute remote_addr_header
  #
  # @param value the value to set the attribute remote_addr_header to.
  #
  # source://puma//lib/puma/client.rb#105
  def remote_addr_header=(_arg0); end

  # source://puma//lib/puma/client.rb#141
  def reset(fast_check = T.unsafe(nil)); end

  # source://puma//lib/puma/client.rb#132
  def set_timeout(val); end

  # Returns the value of attribute tempfile.
  #
  # source://puma//lib/puma/client.rb#100
  def tempfile; end

  # Number of seconds until the timeout elapses.
  #
  # source://puma//lib/puma/client.rb#137
  def timeout; end

  # @raise [ConnectionError]
  #
  # source://puma//lib/puma/client.rb#263
  def timeout!; end

  # Returns the value of attribute timeout_at.
  #
  # source://puma//lib/puma/client.rb#100
  def timeout_at; end

  # Returns the value of attribute to_io.
  #
  # source://puma//lib/puma/client.rb#100
  def to_io; end

  # source://puma//lib/puma/client.rb#212
  def try_to_finish; end

  # If necessary, read the PROXY protocol from the buffer. Returns
  # false if more data is needed.
  #
  # source://puma//lib/puma/client.rb#190
  def try_to_parse_proxy_protocol; end

  # source://puma//lib/puma/client.rb#268
  def write_error(status_code); end

  private

  # source://puma//lib/puma/client.rb#493
  def decode_chunk(chunk); end

  # source://puma//lib/puma/client.rb#401
  def read_body; end

  # source://puma//lib/puma/client.rb#446
  def read_chunked_body; end

  # source://puma//lib/puma/client.rb#590
  def set_ready; end

  # source://puma//lib/puma/client.rb#319
  def setup_body; end

  # source://puma//lib/puma/client.rb#471
  def setup_chunked_body(body); end

  # @version 5.0.0
  #
  # source://puma//lib/puma/client.rb#489
  def write_chunk(str); end
end

# this tests all values but the last, which must be chunked
#
# source://puma//lib/puma/client.rb#48
Puma::Client::ALLOWED_TRANSFER_ENCODING = T.let(T.unsafe(nil), Array)

# chunked body validation
#
# source://puma//lib/puma/client.rb#51
Puma::Client::CHUNK_SIZE_INVALID = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/client.rb#52
Puma::Client::CHUNK_VALID_ENDING = T.let(T.unsafe(nil), String)

# Content-Length header value validation
#
# source://puma//lib/puma/client.rb#55
Puma::Client::CONTENT_LENGTH_VALUE_INVALID = T.let(T.unsafe(nil), Regexp)

# The object used for a request with no body. All requests with
# no body share this one object since it has no state.
#
# source://puma//lib/puma/client.rb#61
Puma::Client::EmptyBody = T.let(T.unsafe(nil), Puma::NullIO)

# source://puma//lib/puma/client.rb#57
Puma::Client::TE_ERR_MSG = T.let(T.unsafe(nil), String)

# This class is instantiated by the `Puma::Launcher` and used
# to boot and serve a Ruby application when puma "workers" are needed
# i.e. when using multi-processes. For example `$ puma -w 5`
#
# An instance of this class will spawn the number of processes passed in
# via the `spawn_workers` method call. Each worker will have it's own
# instance of a `Puma::Server`.
class Puma::Cluster < ::Puma::Runner
  # @return [Cluster] a new instance of Cluster
  #
  # source://puma//lib/puma/cluster.rb#20
  def initialize(launcher); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/cluster.rb#153
  def all_workers_booted?; end

  # source://puma//lib/puma/cluster.rb#157
  def check_workers; end

  # source://puma//lib/puma/cluster.rb#136
  def cull_start_index(diff); end

  # source://puma//lib/puma/cluster.rb#112
  def cull_workers; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster.rb#280
  def fork_worker!; end

  # source://puma//lib/puma/cluster.rb#237
  def halt; end

  # source://puma//lib/puma/cluster.rb#146
  def next_worker_index; end

  # source://puma//lib/puma/cluster.rb#216
  def phased_restart(refork = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/cluster.rb#275
  def preload?; end

  # source://puma//lib/puma/cluster.rb#61
  def redirect_io; end

  # source://puma//lib/puma/cluster.rb#242
  def reload_worker_directory; end

  # source://puma//lib/puma/cluster.rb#211
  def restart; end

  # source://puma//lib/puma/cluster.rb#340
  def run; end

  # We do this in a separate method to keep the lambda scope
  # of the signals handlers as small as possible.
  #
  # source://puma//lib/puma/cluster.rb#289
  def setup_signals; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster.rb#98
  def spawn_worker(idx, master); end

  # source://puma//lib/puma/cluster.rb#67
  def spawn_workers; end

  # source://puma//lib/puma/cluster.rb#49
  def start_phased_restart; end

  # Inside of a child process, this will return all zeroes, as @workers is only populated in
  # the master process.
  #
  # source://puma//lib/puma/cluster.rb#251
  def stats; end

  # source://puma//lib/puma/cluster.rb#225
  def stop; end

  # source://puma//lib/puma/cluster.rb#230
  def stop_blocked; end

  # source://puma//lib/puma/cluster.rb#34
  def stop_workers; end

  # source://puma//lib/puma/cluster.rb#189
  def worker(index, master); end

  # Returns the list of cluster worker handles.
  #
  # @return [Array<Puma::Cluster::WorkerHandle>]
  #
  # source://puma//lib/puma/cluster.rb#32
  def workers; end

  # source://puma//lib/puma/cluster.rb#126
  def workers_to_cull(diff); end

  private

  # source://puma//lib/puma/cluster.rb#500
  def single_worker_warning; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster.rb#535
  def timeout_workers; end

  # loops thru @workers, removing workers that exited, and calling
  # `#term` if needed
  #
  # source://puma//lib/puma/cluster.rb#511
  def wait_workers; end
end

# This class is instantiated by the `Puma::Cluster` and represents a single
# worker process.
#
# At the core of this class is running an instance of `Puma::Server` which
# gets created via the `start_server` method from the `Puma::Runner` class
# that this inherits from.
class Puma::Cluster::Worker < ::Puma::Runner
  # @return [Worker] a new instance of Worker
  #
  # source://puma//lib/puma/cluster/worker.rb#17
  def initialize(index:, master:, launcher:, pipes:, server: T.unsafe(nil)); end

  # source://puma//lib/puma/cluster/worker.rb#15
  def index; end

  # source://puma//lib/puma/cluster/worker.rb#15
  def master; end

  # source://puma//lib/puma/cluster/worker.rb#30
  def run; end

  private

  # source://puma//lib/puma/cluster/worker.rb#151
  def spawn_worker(idx); end
end

# This class represents a worker process from the perspective of the puma
# master process. It contains information about the process and its health
# and it exposes methods to control the process via IPC. It does not
# include the actual logic executed by the worker process itself. For that,
# see Puma::Cluster::Worker.
class Puma::Cluster::WorkerHandle
  # @return [WorkerHandle] a new instance of WorkerHandle
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#14
  def initialize(idx, pid, phase, options); end

  # source://puma//lib/puma/cluster/worker_handle.rb#41
  def boot!; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#33
  def booted?; end

  # source://puma//lib/puma/cluster/worker_handle.rb#91
  def hup; end

  # Returns the value of attribute index.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def index; end

  # source://puma//lib/puma/cluster/worker_handle.rb#86
  def kill; end

  # Returns the value of attribute last_checkin.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def last_checkin; end

  # Returns the value of attribute last_status.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def last_status; end

  # Returns the value of attribute phase.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def phase; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#31
  def phase=(_arg0); end

  # Returns the value of attribute pid.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def pid; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#31
  def pid=(_arg0); end

  # source://puma//lib/puma/cluster/worker_handle.rb#54
  def ping!(status); end

  # @see Puma::Cluster#check_workers
  # @version 5.0.0
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#65
  def ping_timeout; end

  # Returns the value of attribute signal.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def signal; end

  # Returns the value of attribute started_at.
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#28
  def started_at; end

  # source://puma//lib/puma/cluster/worker_handle.rb#73
  def term; end

  # source://puma//lib/puma/cluster/worker_handle.rb#46
  def term!; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/cluster/worker_handle.rb#50
  def term?; end

  # source://puma//lib/puma/cluster/worker_handle.rb#37
  def uptime; end
end

# The main configuration class of Puma.
#
# It can be initialized with a set of "user" options and "default" options.
# Defaults will be merged with `Configuration.puma_default_options`.
#
# This class works together with 2 main other classes the `UserFileDefaultOptions`
# which stores configuration options in order so the precedence is that user
# set configuration wins over "file" based configuration wins over "default"
# configuration. These configurations are set via the `DSL` class. This
# class powers the Puma config file syntax and does double duty as a configuration
# DSL used by the `Puma::CLI` and Puma rack handler.
#
# It also handles loading plugins.
#
# [Note:]
#   `:port` and `:host` are not valid keys. By the time they make it to the
#   configuration options they are expected to be incorporated into a `:binds` key.
#   Under the hood the DSL maps `port` and `host` calls to `:binds`
#
#     config = Configuration.new({}) do |user_config, file_config, default_config|
#       user_config.port 3003
#     end
#     config.load
#     puts config.options[:port]
#     # => 3003
#
# It is expected that `load` is called on the configuration instance after setting
# config. This method expands any values in `config_file` and puts them into the
# correct configuration option hash.
#
# Once all configuration is complete it is expected that `clamp` will be called
# on the instance. This will expand any procs stored under "default" values. This
# is done because an environment variable may have been modified while loading
# configuration files.
class Puma::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://puma//lib/puma/configuration.rb#172
  def initialize(user_options = T.unsafe(nil), default_options = T.unsafe(nil), &block); end

  # Load the specified rackup file, pull options from
  # the rackup file, and set @app.
  #
  # source://puma//lib/puma/configuration.rb#285
  def app; end

  # Indicate if there is a properly configured app
  #
  # @return [Boolean]
  #
  # source://puma//lib/puma/configuration.rb#274
  def app_configured?; end

  # Call once all configuration (included from rackup files)
  # is loaded to flesh out any defaults
  #
  # source://puma//lib/puma/configuration.rb#255
  def clamp; end

  # source://puma//lib/puma/configuration.rb#240
  def config_files; end

  # source://puma//lib/puma/configuration.rb#192
  def configure; end

  # Return which environment we're running in
  #
  # source://puma//lib/puma/configuration.rb#298
  def environment; end

  # source://puma//lib/puma/configuration.rb#325
  def final_options; end

  # source://puma//lib/puma/configuration.rb#206
  def flatten; end

  # source://puma//lib/puma/configuration.rb#210
  def flatten!; end

  # source://puma//lib/puma/configuration.rb#234
  def load; end

  # source://puma//lib/puma/configuration.rb#302
  def load_plugin(name); end

  # Returns the value of attribute options.
  #
  # source://puma//lib/puma/configuration.rb#190
  def options; end

  # Returns the value of attribute plugins.
  #
  # source://puma//lib/puma/configuration.rb#190
  def plugins; end

  # source://puma//lib/puma/configuration.rb#215
  def puma_default_options; end

  # source://puma//lib/puma/configuration.rb#221
  def puma_options_from_env; end

  # source://puma//lib/puma/configuration.rb#278
  def rackup; end

  # @param key [:Symbol] hook to run
  # @param arg [Launcher, Int] `:on_restart` passes Launcher
  #
  # source://puma//lib/puma/configuration.rb#309
  def run_hooks(key, arg, log_writer, hook_data = T.unsafe(nil)); end

  private

  # source://puma//lib/puma/configuration.rb#200
  def initialize_copy(other); end

  # source://puma//lib/puma/configuration.rb#361
  def load_rackup; end

  # Load and use the normal Rack builder if we can, otherwise
  # fallback to our minimal version.
  #
  # source://puma//lib/puma/configuration.rb#340
  def rack_builder; end

  class << self
    # source://puma//lib/puma/configuration.rb#379
    def random_token; end

    # source://puma//lib/puma/configuration.rb#329
    def temp_path; end
  end
end

# Injects the Configuration object into the env
class Puma::Configuration::ConfigMiddleware
  # @return [ConfigMiddleware] a new instance of ConfigMiddleware
  #
  # source://puma//lib/puma/configuration.rb#261
  def initialize(config, app); end

  # source://puma//lib/puma/configuration.rb#266
  def call(env); end
end

# source://puma//lib/puma/configuration.rb#129
Puma::Configuration::DEFAULTS = T.let(T.unsafe(nil), Hash)

class Puma::ConnectionError < ::RuntimeError; end

# Frequently used constants when constructing requests or responses.  Many times
# the constant just refers to a string with the same contents.  Using these constants
# gave about a 3% to 10% performance improvement over using the strings directly.
#
# The constants are frozen because Hash#[]= when called with a String key dups
# the String UNLESS the String is frozen. This saves us therefore 2 object
# allocations when creating the env hash later.
#
# While Puma does try to emulate the CGI/1.2 protocol, it does not use the REMOTE_IDENT,
# REMOTE_USER, or REMOTE_HOST parameters since those are either a security problem or
# too taxing on performance.
module Puma::Const; end

# Banned keys of response header
#
# source://puma//lib/puma/const.rb#244
Puma::Const::BANNED_HEADER_KEY = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/const.rb#183
Puma::Const::CGI_VER = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#224
Puma::Const::CHUNKED = T.let(T.unsafe(nil), String)

# The basic max request size we'll try to read.
#
# source://puma//lib/puma/const.rb#140
Puma::Const::CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/const.rb#210
Puma::Const::CLOSE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#222
Puma::Const::CLOSE_CHUNKED = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#104
Puma::Const::CODE_NAME = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#226
Puma::Const::COLON = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#218
Puma::Const::CONNECTION_CLOSE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#219
Puma::Const::CONNECTION_KEEP_ALIVE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#118
Puma::Const::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#213
Puma::Const::CONTENT_LENGTH2 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#214
Puma::Const::CONTENT_LENGTH_S = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#204
Puma::Const::CONTINUE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#154
Puma::Const::DELETE = T.let(T.unsafe(nil), String)

# Illegal character in the key or value of response header
#
# source://puma//lib/puma/const.rb#237
Puma::Const::DQUOTE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#234
Puma::Const::EARLY_HINTS = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#124
Puma::Const::ERROR_RESPONSE = T.let(T.unsafe(nil), Hash)

# source://puma//lib/puma/const.rb#108
Puma::Const::FAST_TRACK_KA_TIMEOUT = T.let(T.unsafe(nil), Float)

# source://puma//lib/puma/const.rb#182
Puma::Const::GATEWAY_INTERFACE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#151
Puma::Const::GET = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#186
Puma::Const::HALT_COMMAND = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#150
Puma::Const::HEAD = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#231
Puma::Const::HIJACK = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#232
Puma::Const::HIJACK_IO = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#230
Puma::Const::HIJACK_P = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#196
Puma::Const::HTTP = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#197
Puma::Const::HTTPS = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#199
Puma::Const::HTTPS_KEY = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#208
Puma::Const::HTTP_10_200 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#179
Puma::Const::HTTP_11 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#206
Puma::Const::HTTP_11_100 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#207
Puma::Const::HTTP_11_200 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#202
Puma::Const::HTTP_CONNECTION = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#203
Puma::Const::HTTP_EXPECT = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#238
Puma::Const::HTTP_HEADER_DELIMITER = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#169
Puma::Const::HTTP_HOST = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#201
Puma::Const::HTTP_VERSION = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#162
Puma::Const::HTTP_X_FORWARDED_FOR = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#165
Puma::Const::HTTP_X_FORWARDED_PROTO = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#164
Puma::Const::HTTP_X_FORWARDED_SCHEME = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#163
Puma::Const::HTTP_X_FORWARDED_SSL = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#239
Puma::Const::ILLEGAL_HEADER_KEY_REGEX = T.let(T.unsafe(nil), Regexp)

# header values can contain HTAB?
#
# source://puma//lib/puma/const.rb#241
Puma::Const::ILLEGAL_HEADER_VALUE_REGEX = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/const.rb#211
Puma::Const::KEEP_ALIVE = T.let(T.unsafe(nil), String)

# ETag is based on the apache standard of hex mtime-size-inode (inode is 0 on win32)
#
# source://puma//lib/puma/const.rb#160
Puma::Const::LINE_END = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#172
Puma::Const::LOCALHOST = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#173
Puma::Const::LOCALHOST_IPV4 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#174
Puma::Const::LOCALHOST_IPV6 = T.let(T.unsafe(nil), String)

# Maximum request body size before it is moved out of memory and into a tempfile for reading.
#
# source://puma//lib/puma/const.rb#147
Puma::Const::MAX_BODY = T.let(T.unsafe(nil), Integer)

# This is the maximum header that is allowed before a client is booted.  The parser detects
# this, but we'd also like to do this as well.
#
# source://puma//lib/puma/const.rb#144
Puma::Const::MAX_HEADER = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/const.rb#228
Puma::Const::NEWLINE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#155
Puma::Const::OPTIONS = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#157
Puma::Const::PATCH = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#120
Puma::Const::PATH_INFO = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#171
Puma::Const::PORT_443 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#170
Puma::Const::PORT_80 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#152
Puma::Const::POST = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#246
Puma::Const::PROXY_PROTOCOL_V1_REGEX = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/const.rb#193
Puma::Const::PUMA_CONFIG = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#194
Puma::Const::PUMA_PEERCERT = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#106
Puma::Const::PUMA_SERVER_STRING = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#192
Puma::Const::PUMA_SOCKET = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#122
Puma::Const::PUMA_TMP_BASE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#103
Puma::Const::PUMA_VERSION = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#153
Puma::Const::PUT = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#117
Puma::Const::QUERY_STRING = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#191
Puma::Const::RACK_AFTER_REPLY = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#189
Puma::Const::RACK_INPUT = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#190
Puma::Const::RACK_URL_SCHEME = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#161
Puma::Const::REMOTE_ADDR = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#149
Puma::Const::REQUEST_METHOD = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#116
Puma::Const::REQUEST_PATH = T.let(T.unsafe(nil), String)

# The original URI requested by the client.
#
# source://puma//lib/puma/const.rb#115
Puma::Const::REQUEST_URI = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#187
Puma::Const::RESTART_COMMAND = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#167
Puma::Const::SERVER_NAME = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#168
Puma::Const::SERVER_PORT = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#178
Puma::Const::SERVER_PROTOCOL = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#181
Puma::Const::SERVER_SOFTWARE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#185
Puma::Const::STOP_COMMAND = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#158
Puma::Const::SUPPORTED_HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://puma//lib/puma/const.rb#156
Puma::Const::TRACE = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#215
Puma::Const::TRANSFER_ENCODING = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#216
Puma::Const::TRANSFER_ENCODING2 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#221
Puma::Const::TRANSFER_ENCODING_CHUNKED = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#175
Puma::Const::UNSPECIFIED_IPV4 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#176
Puma::Const::UNSPECIFIED_IPV6 = T.let(T.unsafe(nil), String)

# source://puma//lib/puma/const.rb#103
Puma::Const::VERSION = T.let(T.unsafe(nil), String)

# How long to wait when getting some write blocking on the socket when
# sending data back
#
# source://puma//lib/puma/const.rb#112
Puma::Const::WRITE_TIMEOUT = T.let(T.unsafe(nil), Integer)

# The methods that are available for use inside the configuration file.
# These same methods are used in Puma cli and the rack handler
# internally.
#
# Used manually (via CLI class):
#
#   config = Configuration.new({}) do |user_config|
#     user_config.port 3001
#   end
#   config.load
#
#   puts config.options[:binds] # => "tcp://127.0.0.1:3001"
#
# Used to load file:
#
#   $ cat puma_config.rb
#   port 3002
#
# Resulting configuration:
#
#   config = Configuration.new(config_file: "puma_config.rb")
#   config.load
#
#   puts config.options[:binds] # => "tcp://127.0.0.1:3002"
#
# You can also find many examples being used by the test suite in
# +test/config+.
#
# Puma v6 adds the option to specify a key name (String or Symbol) to the
# hooks that run inside the forked workers.  All the hooks run inside the
# {Puma::Cluster::Worker#run} method.
#
# Previously, the worker index and the LogWriter instance were passed to the
# hook blocks/procs.  If a key name is specified, a hash is passed as the last
# parameter.  This allows storage of data, typically objects that are created
# before the worker that need to be passed to the hook when the worker is shutdown.
#
# The following hooks have been updated:
#
#     | DSL Method         |  Options Key            | Fork Block Location |
#     | on_worker_boot     | :before_worker_boot     | inside, before      |
#     | on_worker_shutdown | :before_worker_shutdown | inside, after       |
#     | on_refork          | :before_refork          | inside              |
class Puma::DSL
  # @return [DSL] a new instance of DSL
  #
  # source://puma//lib/puma/dsl.rb#121
  def initialize(options, config); end

  # source://puma//lib/puma/dsl.rb#128
  def _load_from(path); end

  # source://puma//lib/puma/dsl.rb#137
  def _offer_plugins; end

  # Start the Puma control rack application on +url+. This application can
  # be communicated with to control the main server. Additionally, you can
  # provide an authentication token, so all requests to the control server
  # will need to include that token as a query parameter. This allows for
  # simple authentication.
  #
  # Check out {Puma::App::Status} to see what the app has available.
  #
  # @example
  #   activate_control_app 'unix:///var/run/pumactl.sock'
  # @example
  #   activate_control_app 'unix:///var/run/pumactl.sock', { auth_token: '12345' }
  # @example
  #   activate_control_app 'unix:///var/run/pumactl.sock', { no_token: true }
  #
  # source://puma//lib/puma/dsl.rb#211
  def activate_control_app(url = T.unsafe(nil), opts = T.unsafe(nil)); end

  # Code to run in the master after a worker has been started. The worker's
  # index is passed as an argument.
  #
  # This is called everytime a worker is to be started.
  #
  # @example
  #   after_worker_fork do
  #   puts 'After worker fork...'
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#660
  def after_worker_boot(&block); end

  # Code to run in the master after a worker has been started. The worker's
  # index is passed as an argument.
  #
  # This is called everytime a worker is to be started.
  #
  # @example
  #   after_worker_fork do
  #   puts 'After worker fork...'
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#660
  def after_worker_fork(&block); end

  # Use an object or block as the rack application. This allows the
  # configuration file to be the application itself.
  #
  # @example
  #   app do |env|
  #   body = 'Hello, World!'
  #
  #   [
  #   200,
  #   {
  #   'Content-Type' => 'text/plain',
  #   'Content-Length' => body.length.to_s
  #   },
  #   [body]
  #   ]
  #   end
  # @see Puma::Configuration#app
  #
  # source://puma//lib/puma/dsl.rb#189
  def app(obj = T.unsafe(nil), &block); end

  # Code to run immediately before master process
  # forks workers (once on boot). These hooks can block if necessary
  # to wait for background operations unknown to Puma to finish before
  # the process terminates.
  # This can be used to close any connections to remote servers (database,
  # Redis, ...) that were opened when preloading the code.
  #
  # This can be called multiple times to add several hooks.
  #
  # @example
  #   before_fork do
  #   puts "Starting workers..."
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#601
  def before_fork(&block); end

  # Bind the server to +url+. "tcp://", "unix://" and "ssl://" are the only
  # accepted protocols. Multiple urls can be bound to, calling +bind+ does
  # not overwrite previous bindings.
  #
  # The default is "tcp://0.0.0.0:9292".
  #
  # You can use query parameters within the url to specify options:
  #
  # * Set the socket backlog depth with +backlog+, default is 1024.
  # * Set up an SSL certificate with +key+ & +cert+.
  # * Set up an SSL certificate for mTLS with +key+, +cert+, +ca+ and +verify_mode+.
  # * Set whether to optimize for low latency instead of throughput with
  #   +low_latency+, default is to not optimize for low latency. This is done
  #   via +Socket::TCP_NODELAY+.
  # * Set socket permissions with +umask+.
  #
  # @example Backlog depth
  #   bind 'unix:///var/run/puma.sock?backlog=512'
  # @example SSL cert
  #   bind 'ssl://127.0.0.1:9292?key=key.key&cert=cert.pem'
  # @example SSL cert for mutual TLS (mTLS)
  #   bind 'ssl://127.0.0.1:9292?key=key.key&cert=cert.pem&ca=ca.pem&verify_mode=force_peer'
  # @example Disable optimization for low latency
  #   bind 'tcp://0.0.0.0:9292?low_latency=false'
  # @example Socket permissions
  #   bind 'unix:///var/run/puma.sock?umask=0111'
  # @see Puma::Runner#load_and_bind
  # @see Puma::Cluster#run
  #
  # source://puma//lib/puma/dsl.rb#272
  def bind(url); end

  # Bind to (systemd) activated sockets, regardless of configured binds.
  #
  # Systemd can present sockets as file descriptors that are already opened.
  # By default Puma will use these but only if it was explicitly told to bind
  # to the socket. If not, it will close the activated sockets. This means
  # all configuration is duplicated.
  #
  # Binds can contain additional configuration, but only SSL config is really
  # relevant since the unix and TCP socket options are ignored.
  #
  # This means there is a lot of duplicated configuration for no additional
  # value in most setups. This method tells the launcher to bind to all
  # activated sockets, regardless of existing bind.
  #
  # To clear configured binds, the value only can be passed. This will clear
  # out any binds that may have been configured.
  #
  # @example Use any systemd activated sockets as well as configured binds
  #   bind_to_activated_sockets
  # @example Only bind to systemd activated sockets, ignoring other binds
  #   bind_to_activated_sockets 'only'
  #
  # source://puma//lib/puma/dsl.rb#303
  def bind_to_activated_sockets(bind = T.unsafe(nil)); end

  # Work around leaky apps that leave garbage in Thread locals
  # across requests.
  #
  # source://puma//lib/puma/dsl.rb#330
  def clean_thread_locals(which = T.unsafe(nil)); end

  # source://puma//lib/puma/dsl.rb#277
  def clear_binds!; end

  # Show debugging info
  #
  # source://puma//lib/puma/dsl.rb#423
  def debug; end

  # source://puma//lib/puma/dsl.rb#152
  def default_host; end

  # The directory to operate out of.
  #
  # The default is the current directory.
  #
  # @example
  #   directory '/u/apps/lolcat'
  #
  # source://puma//lib/puma/dsl.rb#707
  def directory(dir); end

  # When shutting down, drain the accept socket of pending connections and
  # process them. This loops over the accept socket until there are no more
  # read events and then stops looking and waits for the requests to finish.
  #
  # @see Puma::Server#graceful_shutdown
  #
  # source://puma//lib/puma/dsl.rb#339
  def drain_on_shutdown(which = T.unsafe(nil)); end

  # source://puma//lib/puma/dsl.rb#444
  def early_hints(answer = T.unsafe(nil)); end

  # Set the environment in which the rack's app will run. The value must be
  # a string.
  #
  # The default is "development".
  #
  # @example
  #   environment 'production'
  #
  # source://puma//lib/puma/dsl.rb#350
  def environment(environment); end

  # When using prune_bundler, if extra runtime dependencies need to be loaded to
  # initialize your app, then this setting can be used. This includes any Puma plugins.
  #
  # Before bundler is pruned, the gem names supplied will be looked up in the bundler
  # context and then loaded again after bundler is pruned.
  # Only applies if prune_bundler is used.
  #
  # @example
  #   extra_runtime_dependencies ['gem_name_1', 'gem_name_2']
  # @example
  #   extra_runtime_dependencies ['puma_worker_killer', 'puma-heroku']
  # @see Puma::Launcher#extra_runtime_deps_directories
  #
  # source://puma//lib/puma/dsl.rb#784
  def extra_runtime_dependencies(answer = T.unsafe(nil)); end

  # Define how long the tcp socket stays open, if no data has been received.
  #
  # @see Puma::Server.new
  #
  # source://puma//lib/puma/dsl.rb#324
  def first_data_timeout(seconds); end

  # How long to wait for threads to stop when shutting them
  # down. Defaults to :forever. Specifying :immediately will cause
  # Puma to kill the threads immediately.  Otherwise the value
  # is the number of seconds to wait.
  #
  # Puma always waits a few seconds after killing a thread for it to try
  # to finish up it's work, even in :immediately mode.
  #
  # @see Puma::Server#graceful_shutdown
  #
  # source://puma//lib/puma/dsl.rb#362
  def force_shutdown_after(val = T.unsafe(nil)); end

  # When enabled, workers will be forked from worker 0 instead of from the master process.
  # This option is similar to `preload_app` because the app is preloaded before forking,
  # but it is compatible with phased restart.
  #
  # This option also enables the `refork` command (SIGURG), which optimizes copy-on-write performance
  # in a running app.
  #
  # A refork will automatically trigger once after the specified number of requests
  # (default 1000), or pass 0 to disable auto refork.
  #
  # @note Cluster mode only.
  # @version 5.0.0
  #
  # source://puma//lib/puma/dsl.rb#991
  def fork_worker(after_requests = T.unsafe(nil)); end

  # source://puma//lib/puma/dsl.rb#160
  def get(key, default = T.unsafe(nil)); end

  # source://puma//lib/puma/dsl.rb#156
  def inject(&blk); end

  # Specify the backend for the IO selector.
  #
  # Provided values will be passed directly to +NIO::Selector.new+, with the
  # exception of +:auto+ which will let nio4r choose the backend.
  #
  # Check the documentation of +NIO::Selector.backends+ for the list of valid
  # options. Note that the available options on your system will depend on the
  # operating system. If you want to use the pure Ruby backend (not
  # recommended due to its comparatively low performance), set environment
  # variable +NIO4R_PURE+ to +true+.
  #
  # The default is +:auto+.
  #
  # @see https://github.com/socketry/nio4r/blob/master/lib/nio/selector.rb
  #
  # source://puma//lib/puma/dsl.rb#1017
  def io_selector_backend(backend); end

  # Load additional configuration from a file
  # Files get loaded later via Configuration#load
  #
  # source://puma//lib/puma/dsl.rb#238
  def load(file); end

  # source://puma//lib/puma/dsl.rb#461
  def log_formatter(&block); end

  # Enable request logging
  #
  # source://puma//lib/puma/dsl.rb#417
  def log_requests(which = T.unsafe(nil)); end

  # Use +obj+ or +block+ as the low level error handler. This allows the
  # configuration file to change the default error on the server.
  #
  # @example
  #   lowlevel_error_handler do |err|
  #   [200, {}, ["error page"]]
  #   end
  #
  # source://puma//lib/puma/dsl.rb#728
  def lowlevel_error_handler(obj = T.unsafe(nil), &block); end

  # The number of requests to attempt inline before sending a client back to
  # the reactor to be subject to normal ordering.
  #
  # source://puma//lib/puma/dsl.rb#998
  def max_fast_inline(num_of_requests); end

  # source://puma//lib/puma/dsl.rb#1021
  def mutate_stdout_and_stderr_to_sync_on_write(enabled = T.unsafe(nil)); end

  # When `fork_worker` is enabled, code to run in Worker 0
  # before all other workers are re-forked from this process,
  # after the server has temporarily stopped serving requests
  # (once per complete refork cycle).
  #
  # This can be used to trigger extra garbage-collection to maximize
  # copy-on-write efficiency, or close any connections to remote servers
  # (database, Redis, ...) that were opened while the server was running.
  #
  # This can be called multiple times to add several hooks.
  #
  # @example
  #   on_refork do
  #   3.times {GC.start}
  #   end
  # @note Cluster mode with `fork_worker` enabled only.
  # @version 5.0.0
  #
  # source://puma//lib/puma/dsl.rb#684
  def on_refork(key = T.unsafe(nil), &block); end

  # Code to run before doing a restart. This code should
  # close log files, database connections, etc.
  #
  # This can be called multiple times to add code each time.
  #
  # @example
  #   on_restart do
  #   puts 'On restart...'
  #   end
  #
  # source://puma//lib/puma/dsl.rb#384
  def on_restart(&block); end

  # Code to run in a worker when it boots to setup
  # the process before booting the app.
  #
  # This can be called multiple times to add several hooks.
  #
  # @example
  #   on_worker_boot do
  #   puts 'Before worker boot...'
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#616
  def on_worker_boot(key = T.unsafe(nil), &block); end

  # Code to run in the master right before a worker is started. The worker's
  # index is passed as an argument.
  #
  # This can be called multiple times to add several hooks.
  #
  # @example
  #   on_worker_fork do
  #   puts 'Before worker fork...'
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#646
  def on_worker_fork(&block); end

  # Code to run immediately before a worker shuts
  # down (after it has finished processing HTTP requests). These hooks
  # can block if necessary to wait for background operations unknown
  # to Puma to finish before the process terminates.
  #
  # This can be called multiple times to add several hooks.
  #
  # @example
  #   on_worker_shutdown do
  #   puts 'On worker shutdown...'
  #   end
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#632
  def on_worker_shutdown(key = T.unsafe(nil), &block); end

  # Code to run out-of-band when the worker is idle.
  # These hooks run immediately after a request has finished
  # processing and there are no busy threads on the worker.
  # The worker doesn't accept new requests until this code finishes.
  #
  # This hook is useful for running out-of-band garbage collection
  # or scheduling asynchronous tasks to execute after a response.
  #
  # This can be called multiple times to add several hooks.
  #
  # source://puma//lib/puma/dsl.rb#697
  def out_of_band(&block); end

  # Define how long persistent connections can be idle before Puma closes them.
  #
  # @see Puma::Server.new
  #
  # source://puma//lib/puma/dsl.rb#318
  def persistent_timeout(seconds); end

  # Store the pid of the server in the file at "path".
  #
  # @example
  #   pidfile '/u/apps/lolcat/tmp/pids/puma.pid'
  #
  # source://puma//lib/puma/dsl.rb#403
  def pidfile(path); end

  # Load the named plugin for use by this configuration
  #
  # source://puma//lib/puma/dsl.rb#166
  def plugin(name); end

  # Define the TCP port to bind to. Use +bind+ for more advanced options.
  #
  # @example
  #   port 9292
  #
  # source://puma//lib/puma/dsl.rb#311
  def port(port, host = T.unsafe(nil)); end

  # Preload the application before starting the workers; this conflicts with
  # phased restart feature. On by default if your app uses more than 1 worker.
  #
  # @example
  #   preload_app!
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#717
  def preload_app!(answer = T.unsafe(nil)); end

  # This option is used to allow your app and its gems to be
  # properly reloaded when not using preload.
  #
  # When set, if Puma detects that it's been invoked in the
  # context of Bundler, it will cleanup the environment and
  # re-run itself outside the Bundler environment, but directly
  # using the files that Bundler has setup.
  #
  # This means that Puma is now decoupled from your Bundler
  # context and when each worker loads, it will be loading a
  # new Bundler context and thus can float around as the release
  # dictates.
  #
  # @note This is incompatible with +preload_app!+.
  # @note This is only supported for RubyGems 2.2+
  # @see extra_runtime_dependencies
  #
  # source://puma//lib/puma/dsl.rb#751
  def prune_bundler(answer = T.unsafe(nil)); end

  # When set to true (the default), workers accept all requests
  # and queue them before passing them to the handlers.
  # When set to false, each worker process accepts exactly as
  # many requests as it is configured to simultaneously handle.
  #
  # Queueing requests generally improves performance. In some
  # cases, such as a single threaded application, it may be
  # better to ensure requests get balanced across workers.
  #
  # Note that setting this to false disables HTTP keepalive and
  # slow clients will occupy a handler thread while the request
  # is being sent. A reverse proxy, such as nginx, can handle
  # slow clients and queue requests before they reach Puma.
  #
  # @see Puma::Server
  #
  # source://puma//lib/puma/dsl.rb#898
  def queue_requests(answer = T.unsafe(nil)); end

  # Disable request logging, if this isn't used it'll be enabled by default.
  #
  # @example
  #   quiet
  #
  # source://puma//lib/puma/dsl.rb#411
  def quiet(which = T.unsafe(nil)); end

  # Allows setting `env['rack.url_scheme']`.
  # Only necessary if X-Forwarded-Proto is not being set by your proxy
  # Normal values are 'http' or 'https'.
  #
  # source://puma//lib/puma/dsl.rb#440
  def rack_url_scheme(scheme = T.unsafe(nil)); end

  # Load +path+ as a rackup file.
  #
  # The default is "config.ru".
  #
  # @example
  #   rackup '/u/apps/lolcat/config.ru'
  #
  # source://puma//lib/puma/dsl.rb#433
  def rackup(path); end

  # By default, Puma will raise SignalException when SIGTERM is received. In
  # environments where SIGTERM is something expected, you can suppress these
  # with this option.
  #
  # This can be useful for example in Kubernetes, where rolling restart is
  # guaranteed usually on infrastructure level.
  #
  # @example
  #   raise_exception_on_sigterm false
  # @see Puma::Launcher#setup_signals
  # @see Puma::Cluster#setup_signals
  #
  # source://puma//lib/puma/dsl.rb#767
  def raise_exception_on_sigterm(answer = T.unsafe(nil)); end

  # Command to use to restart Puma. This should be just how to
  # load Puma itself (ie. 'ruby -Ilib bin/puma'), not the arguments
  # to Puma, as those are the same as the original process.
  #
  # @example
  #   restart_command '/u/app/lolcat/bin/restart_puma'
  #
  # source://puma//lib/puma/dsl.rb#395
  def restart_command(cmd); end

  # source://puma//lib/puma/dsl.rb#148
  def set_default_host(host); end

  # Control how the remote address of the connection is set. This
  # is configurable because to calculate the true socket peer address
  # a kernel syscall is required which for very fast rack handlers
  # slows down the handling significantly.
  #
  # There are 5 possible values:
  #
  # 1. **:socket** (the default) - read the peername from the socket using the
  #    syscall. This is the normal behavior. If this fails for any reason (e.g.,
  #    if the peer disconnects between the connection being accepted and the getpeername
  #    system call), Puma will return "0.0.0.0"
  # 2. **:localhost** - set the remote address to "127.0.0.1"
  # 3. **header: <http_header>**- set the remote address to the value of the
  #    provided http header. For instance:
  #    `set_remote_address header: "X-Real-IP"`.
  #    Only the first word (as separated by spaces or comma) is used, allowing
  #    headers such as X-Forwarded-For to be used as well. If this header is absent,
  #    Puma will fall back to the behavior of :socket
  # 4. **proxy_protocol: :v1**- set the remote address to the value read from the
  #    HAproxy PROXY protocol, version 1. If the request does not have the PROXY
  #    protocol attached to it, will fall back to :socket
  # 5. **\<Any string\>** - this allows you to hardcode remote address to any value
  #    you wish. Because Puma never uses this field anyway, it's format is
  #    entirely in your hands.
  #
  # source://puma//lib/puma/dsl.rb#949
  def set_remote_address(val = T.unsafe(nil)); end

  # When a shutdown is requested, the backtraces of all the
  # threads will be written to $stdout. This can help figure
  # out why shutdown is hanging.
  #
  # source://puma//lib/puma/dsl.rb#906
  def shutdown_debug(val = T.unsafe(nil)); end

  # Disable warning message when running in cluster mode with a single worker.
  #
  # Cluster mode has some overhead of running an additional 'control' process
  # in order to manage the cluster. If only running a single worker it is
  # likely not worth paying that overhead vs running in single mode with
  # additional threads instead.
  #
  # There are some scenarios where running cluster mode with a single worker
  # may still be warranted and valid under certain deployment scenarios, see
  # https://github.com/puma/puma/issues/2534
  #
  # Moving from workers = 1 to workers = 0 will save 10-30% of memory use.
  #
  # @note Cluster mode only.
  #
  # source://puma//lib/puma/dsl.rb#583
  def silence_single_worker_warning; end

  # Instead of using +bind+ and manually constructing a URI like:
  #
  #    bind 'ssl://127.0.0.1:9292?key=key_path&cert=cert_path'
  #
  # you can use the this method.
  #
  # When binding on localhost you don't need to specify +cert+ and +key+,
  # Puma will assume you are using the +localhost+ gem and try to load the
  # appropriate files.
  #
  # When using the options hash parameter, the `reuse:` value is either
  # `true`, which sets reuse 'on' with default values, or a hash, with `:size`
  # and/or `:timeout` keys, each with integer values.
  #
  # @example
  #   ssl_bind '127.0.0.1', '9292', {
  #   cert: path_to_cert,
  #   key: path_to_key,
  #   ssl_cipher_filter: cipher_filter, # optional
  #   verify_mode: verify_mode,         # default 'none'
  #   verification_flags: flags,        # optional, not supported by JRuby
  #   reuse: true                       # optional
  #   }
  # @example Using self-signed certificate with the +localhost+ gem:
  #   ssl_bind '127.0.0.1', '9292'
  # @example Alternatively, you can provide +cert_pem+ and +key_pem+:
  #   ssl_bind '127.0.0.1', '9292', {
  #   cert_pem: File.read(path_to_cert),
  #   key_pem: File.read(path_to_key),
  #   reuse: {size: 2_000, timeout: 20} # optional
  #   }
  # @example For JRuby, two keys are required: +keystore+ & +keystore_pass+
  #   ssl_bind '127.0.0.1', '9292', {
  #   keystore: path_to_keystore,
  #   keystore_pass: password,
  #   ssl_cipher_list: cipher_list,     # optional
  #   verify_mode: verify_mode          # default 'none'
  #   }
  #
  # source://puma//lib/puma/dsl.rb#533
  def ssl_bind(host, port, opts = T.unsafe(nil)); end

  # Use +path+ as the file to store the server info state. This is
  # used by +pumactl+ to query and control the server.
  #
  # @example
  #   state_path '/u/apps/lolcat/tmp/pids/puma.state'
  #
  # source://puma//lib/puma/dsl.rb#543
  def state_path(path); end

  # Use +permission+ to restrict permissions for the state file.
  #
  # @example
  #   state_permission 0600
  # @version 5.0.0
  #
  # source://puma//lib/puma/dsl.rb#553
  def state_permission(permission); end

  # Redirect +STDOUT+ and +STDERR+ to files specified. The +append+ parameter
  # specifies whether the output is appended, the default is +false+.
  #
  # @example
  #   stdout_redirect '/app/lolcat/log/stdout', '/app/lolcat/log/stderr'
  # @example
  #   stdout_redirect '/app/lolcat/log/stdout', '/app/lolcat/log/stderr', true
  #
  # source://puma//lib/puma/dsl.rb#455
  def stdout_redirect(stdout = T.unsafe(nil), stderr = T.unsafe(nil), append = T.unsafe(nil)); end

  # Additional text to display in process listing.
  #
  # If you do not specify a tag, Puma will infer it. If you do not want Puma
  # to add a tag, use an empty string.
  #
  # @example
  #   tag 'app name'
  # @example
  #   tag ''
  #
  # source://puma//lib/puma/dsl.rb#797
  def tag(string); end

  # Configure +min+ to be the minimum number of threads to use to answer
  # requests and +max+ the maximum.
  #
  # The default is the environment variables +PUMA_MIN_THREADS+ / +PUMA_MAX_THREADS+
  # (or +MIN_THREADS+ / +MAX_THREADS+ if the +PUMA_+ variables aren't set).
  #
  # If these environment variables aren't set, the default is "0, 5" in MRI or "0, 16" for other interpreters.
  #
  # @example
  #   threads 0, 16
  # @example
  #   threads 5, 5
  #
  # source://puma//lib/puma/dsl.rb#477
  def threads(min, max); end

  # Attempts to route traffic to less-busy workers by causing them to delay
  # listening on the socket, allowing workers which are not processing any
  # requests to pick up new requests first.
  #
  # Only works on MRI. For all other interpreters, this setting does nothing.
  #
  # @see Puma::Server#handle_servers
  # @see Puma::ThreadPool#wait_for_less_busy_worker
  # @version 5.0.0
  #
  # source://puma//lib/puma/dsl.rb#920
  def wait_for_less_busy_worker(val = T.unsafe(nil)); end

  # Change the default worker timeout for booting.
  #
  # If unspecified, this defaults to the value of worker_timeout.
  #
  # @example
  #   worker_boot_timeout 60
  # @note Cluster mode only.
  # @see Puma::Cluster::Worker#ping_timeout
  #
  # source://puma//lib/puma/dsl.rb#847
  def worker_boot_timeout(timeout); end

  # Change the default interval for checking workers.
  #
  # The default value is 5 seconds.
  #
  # @example
  #   worker_check_interval 5
  # @note Cluster mode only.
  # @see Puma::Cluster#check_workers
  #
  # source://puma//lib/puma/dsl.rb#810
  def worker_check_interval(interval); end

  # Set the strategy for worker culling.
  #
  # There are two possible values:
  #
  # 1. **:youngest** - the youngest workers (i.e. the workers that were
  #    the most recently started) will be culled.
  # 2. **:oldest** - the oldest workers (i.e. the workers that were started
  #    the longest time ago) will be culled.
  #
  # @example
  #   worker_culling_strategy :oldest
  # @note Cluster mode only.
  # @see Puma::Cluster#cull_workers
  #
  # source://puma//lib/puma/dsl.rb#874
  def worker_culling_strategy(strategy); end

  # Set the timeout for worker shutdown.
  #
  # @note Cluster mode only.
  # @see Puma::Cluster::Worker#term
  #
  # source://puma//lib/puma/dsl.rb#856
  def worker_shutdown_timeout(timeout); end

  # Verifies that all workers have checked in to the master process within
  # the given timeout. If not the worker process will be restarted. This is
  # not a request timeout, it is to protect against a hung or dead process.
  # Setting this value will not protect against slow requests.
  #
  # The minimum value is 6 seconds, the default value is 60 seconds.
  #
  # @example
  #   worker_timeout 60
  # @note Cluster mode only.
  # @see Puma::Cluster::Worker#ping_timeout
  #
  # source://puma//lib/puma/dsl.rb#826
  def worker_timeout(timeout); end

  # How many worker processes to run.  Typically this is set to
  # the number of available cores.
  #
  # The default is the value of the environment variable +WEB_CONCURRENCY+ if
  # set, otherwise 0.
  #
  # @note Cluster mode only.
  # @see Puma::Cluster
  #
  # source://puma//lib/puma/dsl.rb#565
  def workers(count); end

  private

  # To avoid adding cert_pem and key_pem as URI params, we store them on the
  # options[:store] from where Puma binder knows how to find and extract them.
  #
  # source://puma//lib/puma/dsl.rb#1029
  def add_pem_values_to_options_store(opts); end

  # source://puma//lib/puma/dsl.rb#1045
  def process_hook(options_key, key, block, meth); end

  class << self
    # convenience method so logic can be used in CI
    #
    # @see ssl_bind
    #
    # source://puma//lib/puma/dsl.rb#57
    def ssl_bind_str(host, port, opts); end
  end
end

# source://puma//lib/puma/dsl.rb#52
Puma::DSL::ON_WORKER_KEY = T.let(T.unsafe(nil), Array)

# The implementation of a detailed error logging.
#
# @version 5.0.0
class Puma::ErrorLogger
  include ::Puma::Const

  # @return [ErrorLogger] a new instance of ErrorLogger
  #
  # source://puma//lib/puma/error_logger.rb#18
  def initialize(ioerr); end

  # Print occurred error details only if
  # environment variable PUMA_DEBUG is defined.
  # +options+ hash with additional options:
  # - +error+ is an exception object
  # - +req+ the http request
  # - +text+ (default nil) custom string to print in title
  #   and before all remaining info.
  #
  # source://puma//lib/puma/error_logger.rb#47
  def debug(options = T.unsafe(nil)); end

  # Print occurred error details.
  # +options+ hash with additional options:
  # - +error+ is an exception object
  # - +req+ the http request
  # - +text+ (default nil) custom string to print in title
  #   and before all remaining info.
  #
  # source://puma//lib/puma/error_logger.rb#35
  def info(options = T.unsafe(nil)); end

  # Returns the value of attribute ioerr.
  #
  # source://puma//lib/puma/error_logger.rb#12
  def ioerr; end

  # source://puma//lib/puma/error_logger.rb#73
  def request_dump(req); end

  # source://puma//lib/puma/error_logger.rb#89
  def request_headers(req); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/error_logger.rb#94
  def request_parsed?(req); end

  # source://puma//lib/puma/error_logger.rb#78
  def request_title(req); end

  # source://puma//lib/puma/error_logger.rb#61
  def title(options = T.unsafe(nil)); end

  private

  # source://puma//lib/puma/error_logger.rb#98
  def internal_write(str); end

  class << self
    # source://puma//lib/puma/error_logger.rb#24
    def stdio; end
  end
end

# source://puma//lib/puma/error_logger.rb#16
Puma::ErrorLogger::LOG_QUEUE = T.let(T.unsafe(nil), Thread::Queue)

# source://puma//lib/puma/error_logger.rb#14
Puma::ErrorLogger::REQUEST_FORMAT = T.let(T.unsafe(nil), String)

# This is an event sink used by `Puma::Server` to handle
# lifecycle events such as :on_booted, :on_restart, and :on_stopped.
# Using `Puma::DSL` it is possible to register callback hooks
# for each event type.
class Puma::Events
  # @return [Events] a new instance of Events
  #
  # source://puma//lib/puma/events.rb#11
  def initialize; end

  # Fire callbacks for the named hook
  #
  # source://puma//lib/puma/events.rb#16
  def fire(hook, *args); end

  # source://puma//lib/puma/events.rb#45
  def fire_on_booted!; end

  # source://puma//lib/puma/events.rb#49
  def fire_on_restart!; end

  # source://puma//lib/puma/events.rb#53
  def fire_on_stopped!; end

  # source://puma//lib/puma/events.rb#33
  def on_booted(&block); end

  # source://puma//lib/puma/events.rb#37
  def on_restart(&block); end

  # source://puma//lib/puma/events.rb#41
  def on_stopped(&block); end

  # Register a callback for a given hook
  #
  # source://puma//lib/puma/events.rb#21
  def register(hook, obj = T.unsafe(nil), &blk); end
end

# @version 5.2.1
#
# source://puma//lib/puma/detect.rb#9
Puma::HAS_FORK = T.let(T.unsafe(nil), TrueClass)

# source://puma//lib/puma/detect.rb#11
Puma::HAS_NATIVE_IO_WAIT = T.let(T.unsafe(nil), TrueClass)

# at present, MiniSSL::Engine is only defined in extension code (puma_http11),
# not in minissl.rb
#
# source://puma//lib/puma.rb#29
Puma::HAS_SSL = T.let(T.unsafe(nil), TrueClass)

# source://puma//lib/puma.rb#31
Puma::HAS_UNIX_SOCKET = T.let(T.unsafe(nil), TrueClass)

# Every standard HTTP code mapped to the appropriate message.
# Generated with:
# curl -s https://www.iana.org/assignments/http-status-codes/http-status-codes-1.csv | \
#   ruby -ne 'm = /^(\d{3}),(?!Unassigned|\(Unused\))([^,]+)/.match($_) and \
#             puts "#{m[1]} => \x27#{m[2].strip}\x27,"'
#
# source://puma//lib/puma/const.rb#18
Puma::HTTP_STATUS_CODES = T.let(T.unsafe(nil), Hash)

class Puma::HttpParser
  def initialize; end

  def body; end
  def error?; end
  def execute(_arg0, _arg1, _arg2); end
  def finish; end
  def finished?; end
  def nread; end
  def reset; end
end

class Puma::HttpParserError < ::IOError; end
class Puma::HttpParserError501 < ::IOError; end

class Puma::IOBuffer < ::StringIO
  # @return [IOBuffer] a new instance of IOBuffer
  #
  # source://puma//lib/puma/io_buffer.rb#7
  def initialize; end

  def append(*_arg0); end

  # source://puma//lib/puma/io_buffer.rb#15
  def clear; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/io_buffer.rb#11
  def empty?; end

  # Read & Reset - returns contents and resets
  #
  # @return [String] StringIO contents
  #
  # source://puma//lib/puma/io_buffer.rb#27
  def read_and_reset; end

  # source://puma//lib/puma/io_buffer.rb#15
  def reset; end

  # source://puma//lib/puma/io_buffer.rb#20
  def to_s; end
end

# source://puma//lib/puma/detect.rb#13
Puma::IS_JRUBY = T.let(T.unsafe(nil), FalseClass)

# @version 5.2.0
#
# source://puma//lib/puma/detect.rb#21
Puma::IS_MRI = T.let(T.unsafe(nil), TrueClass)

# source://puma//lib/puma/detect.rb#15
Puma::IS_OSX = T.let(T.unsafe(nil), FalseClass)

# source://puma//lib/puma/detect.rb#17
Puma::IS_WINDOWS = T.let(T.unsafe(nil), FalseClass)

# Puma deliberately avoids the use of the json gem and instead performs JSON
# serialization without any external dependencies. In a puma cluster, loading
# any gem into the puma master process means that operators cannot use a
# phased restart to upgrade their application if the new version of that
# application uses a different version of that gem. The json gem in
# particular is additionally problematic because it leverages native
# extensions. If the puma master process relies on a gem with native
# extensions and operators remove gems from disk related to old releases,
# subsequent phased restarts can fail.
#
# The implementation of JSON serialization in this module is not designed to
# be particularly full-featured or fast. It just has to handle the few places
# where Puma relies on JSON serialization internally.
module Puma::JSONSerialization
  class << self
    # source://puma//lib/puma/json_serialization.rb#29
    def generate(value); end

    private

    # source://puma//lib/puma/json_serialization.rb#86
    def serialize_object_key(output, value); end

    # source://puma//lib/puma/json_serialization.rb#71
    def serialize_string(output, value); end

    # source://puma//lib/puma/json_serialization.rb#38
    def serialize_value(output, value); end
  end
end

# source://puma//lib/puma/json_serialization.rb#22
Puma::JSONSerialization::BACKSLASH = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/json_serialization.rb#24
Puma::JSONSerialization::CHAR_TO_ESCAPE = T.let(T.unsafe(nil), Regexp)

# As required by ECMA-404
#
# source://puma//lib/puma/json_serialization.rb#23
Puma::JSONSerialization::CONTROL_CHAR_TO_ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://puma//lib/puma/json_serialization.rb#21
Puma::JSONSerialization::QUOTE = T.let(T.unsafe(nil), Regexp)

class Puma::JSONSerialization::SerializationError < ::StandardError; end

# Puma::Launcher is the single entry point for starting a Puma server based on user
# configuration. It is responsible for taking user supplied arguments and resolving them
# with configuration in `config/puma.rb` or `config/puma/<env>.rb`.
#
# It is responsible for either launching a cluster of Puma workers or a single
# puma server.
class Puma::Launcher
  # Returns an instance of Launcher
  #
  # +conf+ A Puma::Configuration object indicating how to run the server.
  #
  # +launcher_args+ A Hash that currently has one required key `:events`,
  # this is expected to hold an object similar to an `Puma::LogWriter.stdio`,
  # this object will be responsible for broadcasting Puma's internal state
  # to a logging destination. An optional key `:argv` can be supplied,
  # this should be an array of strings, these arguments are re-used when
  # restarting the puma server.
  #
  # Examples:
  #
  #   conf = Puma::Configuration.new do |user_config|
  #     user_config.threads 1, 10
  #     user_config.app do |env|
  #       [200, {}, ["hello world"]]
  #     end
  #   end
  #   Puma::Launcher.new(conf, log_writer: Puma::LogWriter.stdio).run
  #
  # @return [Launcher] a new instance of Launcher
  #
  # source://puma//lib/puma/launcher.rb#41
  def initialize(conf, launcher_args = T.unsafe(nil)); end

  # Returns the value of attribute binder.
  #
  # source://puma//lib/puma/launcher.rb#102
  def binder; end

  # source://puma//lib/puma/launcher.rb#208
  def close_binder_listeners; end

  # Returns the value of attribute config.
  #
  # source://puma//lib/puma/launcher.rb#102
  def config; end

  # Return all tcp ports the launcher may be using, TCP or SSL
  #
  # @version 5.0.0
  #
  # source://puma//lib/puma/launcher.rb#194
  def connected_ports; end

  # Delete the configured pidfile
  #
  # source://puma//lib/puma/launcher.rb#130
  def delete_pidfile; end

  # Returns the value of attribute events.
  #
  # source://puma//lib/puma/launcher.rb#102
  def events; end

  # Begin async shutdown of the server
  #
  # source://puma//lib/puma/launcher.rb#136
  def halt; end

  # Returns the value of attribute log_writer.
  #
  # source://puma//lib/puma/launcher.rb#102
  def log_writer; end

  # Returns the value of attribute options.
  #
  # source://puma//lib/puma/launcher.rb#102
  def options; end

  # Begin a phased restart if supported
  #
  # source://puma//lib/puma/launcher.rb#154
  def phased_restart; end

  # Begin a refork if supported
  #
  # source://puma//lib/puma/launcher.rb#163
  def refork; end

  # Begin async restart of the server
  #
  # source://puma//lib/puma/launcher.rb#148
  def restart; end

  # source://puma//lib/puma/launcher.rb#199
  def restart_args; end

  # Returns the value of attribute restart_dir.
  #
  # source://puma//lib/puma/launcher.rb#102
  def restart_dir; end

  # Run the server. This blocks until the server is stopped
  #
  # source://puma//lib/puma/launcher.rb#174
  def run; end

  # Return stats about the server
  #
  # source://puma//lib/puma/launcher.rb#105
  def stats; end

  # Begin async shutdown of the server gracefully
  #
  # source://puma//lib/puma/launcher.rb#142
  def stop; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/launcher.rb#219
  def thread_status; end

  # Write a state file that can be used by pumactl to control
  # the server
  #
  # source://puma//lib/puma/launcher.rb#111
  def write_state; end

  private

  # @return [Boolean]
  #
  # source://puma//lib/puma/launcher.rb#339
  def clustered?; end

  # source://puma//lib/puma/launcher.rb#257
  def do_forceful_stop; end

  # source://puma//lib/puma/launcher.rb#262
  def do_graceful_stop; end

  # source://puma//lib/puma/launcher.rb#267
  def do_restart(previous_env); end

  # source://puma//lib/puma/launcher.rb#244
  def do_run_finished(previous_env); end

  # source://puma//lib/puma/launcher.rb#365
  def environment; end

  # source://puma//lib/puma/launcher.rb#378
  def generate_restart_data; end

  # source://puma//lib/puma/launcher.rb#232
  def get_env; end

  # Puma's systemd integration allows Puma to inform systemd:
  #  1. when it has successfully started
  #  2. when it is starting shutdown
  #  3. periodically for a liveness check with a watchdog thread
  #
  # source://puma//lib/puma/launcher.rb#318
  def integrate_with_systemd; end

  # source://puma//lib/puma/launcher.rb#335
  def log(str); end

  # source://puma//lib/puma/launcher.rb#488
  def log_config; end

  # source://puma//lib/puma/launcher.rb#373
  def prune_bundler!; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/launcher.rb#369
  def prune_bundler?; end

  # source://puma//lib/puma/launcher.rb#310
  def reload_worker_directory; end

  # source://puma//lib/puma/launcher.rb#274
  def restart!; end

  # source://puma//lib/puma/launcher.rb#348
  def set_process_title; end

  # source://puma//lib/puma/launcher.rb#359
  def set_rack_environment; end

  # source://puma//lib/puma/launcher.rb#423
  def setup_signals; end

  # source://puma//lib/puma/launcher.rb#353
  def title; end

  # @raise [UnsupportedOption]
  #
  # source://puma//lib/puma/launcher.rb#343
  def unsupported(str); end

  # If configured, write the pid of the current process out
  # to a file.
  #
  # source://puma//lib/puma/launcher.rb#300
  def write_pid; end
end

# This class is used to pickup Gemfile changes during
# application restarts.
class Puma::Launcher::BundlePruner
  # @return [BundlePruner] a new instance of BundlePruner
  #
  # source://puma//lib/puma/launcher/bundle_pruner.rb#10
  def initialize(original_argv, extra_runtime_dependencies, log_writer); end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#16
  def prune; end

  private

  # source://puma//lib/puma/launcher/bundle_pruner.rb#75
  def extra_runtime_deps_paths; end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#99
  def log(str); end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#71
  def paths_to_require_after_prune; end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#87
  def puma_require_paths; end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#57
  def puma_wild_path; end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#95
  def require_paths_for_gem(gem_spec); end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#48
  def require_rubygems_min_version!; end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#91
  def spec_for_gem(gem_name); end

  # source://puma//lib/puma/launcher/bundle_pruner.rb#62
  def with_unbundled_env; end
end

# Handles logging concerns for both standard messages
# (+stdout+) and errors (+stderr+).
class Puma::LogWriter
  # Create a LogWriter that prints to +stdout+ and +stderr+.
  #
  # @return [LogWriter] a new instance of LogWriter
  #
  # source://puma//lib/puma/log_writer.rb#34
  def initialize(stdout, stderr); end

  # An HTTP connection error has occurred.
  # +error+ a connection exception, +req+ the request,
  # and +text+ additional info
  #
  # @version 5.0.0
  #
  # source://puma//lib/puma/log_writer.rb#101
  def connection_error(error, req, text = T.unsafe(nil)); end

  # source://puma//lib/puma/log_writer.rb#83
  def debug(str); end

  # Log occurred error debug dump.
  # +error+ an exception object, +req+ the request,
  # and +text+ additional info
  #
  # @version 5.0.0
  #
  # source://puma//lib/puma/log_writer.rb#133
  def debug_error(error, req = T.unsafe(nil), text = T.unsafe(nil)); end

  # Write +str+ to +@stderr+
  #
  # source://puma//lib/puma/log_writer.rb#88
  def error(str); end

  # source://puma//lib/puma/log_writer.rb#93
  def format(str); end

  # Returns the value of attribute formatter.
  #
  # source://puma//lib/puma/log_writer.rb#31
  def formatter; end

  # Sets the attribute formatter
  #
  # @param value the value to set the attribute formatter to.
  #
  # source://puma//lib/puma/log_writer.rb#31
  def formatter=(_arg0); end

  # Write +str+ to +@stdout+
  #
  # source://puma//lib/puma/log_writer.rb#61
  def log(str); end

  # An HTTP parse error has occurred.
  # +error+ a parsing exception,
  # and +req+ the request.
  #
  # source://puma//lib/puma/log_writer.rb#108
  def parse_error(error, req); end

  # An SSL error has occurred.
  #
  # @param error [Puma::MiniSSL::SSLError]
  # @param ssl_socket [Puma::MiniSSL::Socket]
  #
  # source://puma//lib/puma/log_writer.rb#115
  def ssl_error(error, ssl_socket); end

  # Returns the value of attribute stderr.
  #
  # source://puma//lib/puma/log_writer.rb#28
  def stderr; end

  # Returns the value of attribute stdout.
  #
  # source://puma//lib/puma/log_writer.rb#28
  def stdout; end

  # An unknown error has occurred.
  # +error+ an exception object, +req+ the request,
  # and +text+ additional info
  #
  # source://puma//lib/puma/log_writer.rb#125
  def unknown_error(error, req = T.unsafe(nil), text = T.unsafe(nil)); end

  # source://puma//lib/puma/log_writer.rb#65
  def write(str); end

  private

  # source://puma//lib/puma/log_writer.rb#69
  def internal_write(str); end

  class << self
    # source://puma//lib/puma/log_writer.rb#55
    def null; end

    # source://puma//lib/puma/log_writer.rb#51
    def stdio; end

    # Returns an LogWriter object which writes its status to
    # two StringIO objects.
    #
    # source://puma//lib/puma/log_writer.rb#47
    def strings; end
  end
end

# source://puma//lib/puma/log_writer.rb#43
Puma::LogWriter::DEFAULT = T.let(T.unsafe(nil), Puma::LogWriter)

class Puma::LogWriter::DefaultFormatter
  # source://puma//lib/puma/log_writer.rb#15
  def call(str); end
end

# source://puma//lib/puma/log_writer.rb#26
Puma::LogWriter::LOG_QUEUE = T.let(T.unsafe(nil), Thread::Queue)

class Puma::LogWriter::PidFormatter
  # source://puma//lib/puma/log_writer.rb#21
  def call(str); end
end

module Puma::MiniSSL
  class << self
    def check; end
  end
end

class Puma::MiniSSL::Context
  # @return [Context] a new instance of Context
  #
  # source://puma//lib/puma/minissl.rb#206
  def initialize; end

  # Returns the value of attribute ca.
  #
  # source://puma//lib/puma/minissl.rb#281
  def ca; end

  # source://puma//lib/puma/minissl.rb#299
  def ca=(ca); end

  # Returns the value of attribute cert.
  #
  # source://puma//lib/puma/minissl.rb#280
  def cert; end

  # source://puma//lib/puma/minissl.rb#294
  def cert=(cert); end

  # Returns the value of attribute cert_pem.
  #
  # source://puma//lib/puma/minissl.rb#282
  def cert_pem; end

  # @raise [ArgumentError]
  #
  # source://puma//lib/puma/minissl.rb#304
  def cert_pem=(cert_pem); end

  # source://puma//lib/puma/minissl.rb#314
  def check; end

  # @raise [ArgumentError]
  #
  # source://puma//lib/puma/minissl.rb#218
  def check_file(file, desc); end

  # non-jruby Context properties
  #
  # source://puma//lib/puma/minissl.rb#279
  def key; end

  # source://puma//lib/puma/minissl.rb#289
  def key=(key); end

  # Returns the value of attribute key_pem.
  #
  # source://puma//lib/puma/minissl.rb#283
  def key_pem; end

  # @raise [ArgumentError]
  #
  # source://puma//lib/puma/minissl.rb#309
  def key_pem=(key_pem); end

  # Returns the value of attribute no_tlsv1.
  #
  # source://puma//lib/puma/minissl.rb#204
  def no_tlsv1; end

  # disables TLSv1
  #
  # @raise [ArgumentError]
  #
  # source://puma//lib/puma/minissl.rb#351
  def no_tlsv1=(tlsv1); end

  # Returns the value of attribute no_tlsv1_1.
  #
  # source://puma//lib/puma/minissl.rb#204
  def no_tlsv1_1; end

  # disables TLSv1 and TLSv1.1.  Overrides `#no_tlsv1=`
  #
  # @raise [ArgumentError]
  #
  # source://puma//lib/puma/minissl.rb#358
  def no_tlsv1_1=(tlsv1_1); end

  # Returns the value of attribute reuse.
  #
  # source://puma//lib/puma/minissl.rb#287
  def reuse; end

  # Controls session reuse.  Allowed values are as follows:
  # * 'off' - matches the behavior of Puma 5.6 and earlier.  This is included
  #   in case reuse 'on' is made the default in future Puma versions.
  # * 'dflt' - sets session reuse on, with OpenSSL default cache size of
  #   20k and default timeout of 300 seconds.
  # * 's,t' - where s and t are integer strings, for size and timeout.
  # * 's' - where s is an integer strings for size.
  # * ',t' - where t is an integer strings for timeout.
  #
  # source://puma//lib/puma/minissl.rb#328
  def reuse=(reuse_str); end

  # Returns the value of attribute reuse_cache_size.
  #
  # source://puma//lib/puma/minissl.rb#287
  def reuse_cache_size; end

  # Returns the value of attribute reuse_timeout.
  #
  # source://puma//lib/puma/minissl.rb#287
  def reuse_timeout; end

  # Returns the value of attribute ssl_cipher_filter.
  #
  # source://puma//lib/puma/minissl.rb#284
  def ssl_cipher_filter; end

  # Sets the attribute ssl_cipher_filter
  #
  # @param value the value to set the attribute ssl_cipher_filter to.
  #
  # source://puma//lib/puma/minissl.rb#284
  def ssl_cipher_filter=(_arg0); end

  # Returns the value of attribute verification_flags.
  #
  # source://puma//lib/puma/minissl.rb#285
  def verification_flags; end

  # Sets the attribute verification_flags
  #
  # @param value the value to set the attribute verification_flags to.
  #
  # source://puma//lib/puma/minissl.rb#285
  def verification_flags=(_arg0); end

  # Returns the value of attribute verify_mode.
  #
  # source://puma//lib/puma/minissl.rb#203
  def verify_mode; end

  # Sets the attribute verify_mode
  #
  # @param value the value to set the attribute verify_mode to.
  #
  # source://puma//lib/puma/minissl.rb#203
  def verify_mode=(_arg0); end
end

class Puma::MiniSSL::ContextBuilder
  # @return [ContextBuilder] a new instance of ContextBuilder
  #
  # source://puma//lib/puma/minissl/context_builder.rb#4
  def initialize(params, log_writer); end

  # source://puma//lib/puma/minissl/context_builder.rb#9
  def context; end

  private

  # Returns the value of attribute log_writer.
  #
  # source://puma//lib/puma/minissl/context_builder.rb#89
  def log_writer; end

  # Returns the value of attribute params.
  #
  # source://puma//lib/puma/minissl/context_builder.rb#89
  def params; end
end

class Puma::MiniSSL::Engine
  def extract; end
  def init?; end
  def inject(_arg0); end
  def peercert; end
  def read; end
  def shutdown; end
  def ssl_vers_st; end
  def write(_arg0); end

  class << self
    def client; end
    def server(_arg0); end
  end
end

# Define constant at runtime, as it's easy to determine at built time,
# but Puma could (it shouldn't) be loaded with an older OpenSSL version
#
# @version 5.0.0
#
# source://puma//lib/puma/minissl.rb#17
Puma::MiniSSL::HAS_TLS1_3 = T.let(T.unsafe(nil), TrueClass)

Puma::MiniSSL::OPENSSL_LIBRARY_VERSION = T.let(T.unsafe(nil), String)
Puma::MiniSSL::OPENSSL_NO_SSL3 = T.let(T.unsafe(nil), TrueClass)
Puma::MiniSSL::OPENSSL_NO_TLS1 = T.let(T.unsafe(nil), FalseClass)
Puma::MiniSSL::OPENSSL_NO_TLS1_1 = T.let(T.unsafe(nil), FalseClass)
Puma::MiniSSL::OPENSSL_VERSION = T.let(T.unsafe(nil), String)

class Puma::MiniSSL::SSLContext
  def initialize(_arg0); end
end

# this class is defined so that it exists when Puma is compiled
# without ssl support, as Server and Reactor use it in rescue statements.
class Puma::MiniSSL::SSLError < ::StandardError; end

class Puma::MiniSSL::Server
  # @return [Server] a new instance of Server
  #
  # source://puma//lib/puma/minissl.rb#396
  def initialize(socket, ctx); end

  # source://puma//lib/puma/minissl.rb#402
  def accept; end

  # source://puma//lib/puma/minissl.rb#409
  def accept_nonblock; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/minissl.rb#423
  def addr; end

  # source://puma//lib/puma/minissl.rb#427
  def close; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/minissl.rb#431
  def closed?; end

  # source://puma//lib/puma/minissl.rb#417
  def to_io; end
end

class Puma::MiniSSL::Socket
  # @return [Socket] a new instance of Socket
  #
  # source://puma//lib/puma/minissl.rb#22
  def initialize(socket, engine); end

  # source://puma//lib/puma/minissl.rb#119
  def <<(data); end

  # source://puma//lib/puma/minissl.rb#166
  def close; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/minissl.rb#34
  def closed?; end

  # source://puma//lib/puma/minissl.rb#76
  def engine_read_all; end

  # source://puma//lib/puma/minissl.rb#162
  def flush; end

  # source://puma//lib/puma/minissl.rb#182
  def peeraddr; end

  # source://puma//lib/puma/minissl.rb#187
  def peercert; end

  # source://puma//lib/puma/minissl.rb#84
  def read_nonblock(size, *_); end

  # source://puma//lib/puma/minissl.rb#59
  def readpartial(size); end

  # Returns a two element array,
  # first is protocol version (SSL_get_version),
  # second is 'handshake' state (SSL_state_string)
  #
  # Used for dropping tcp connections to ssl.
  # See OpenSSL ssl/ssl_stat.c SSL_state_string for info
  #
  # @version 5.0.0
  #
  # source://puma//lib/puma/minissl.rb#47
  def ssl_version_state; end

  # source://puma//lib/puma/minissl.rb#119
  def syswrite(data); end

  # source://puma//lib/puma/minissl.rb#30
  def to_io; end

  # source://puma//lib/puma/minissl.rb#119
  def write(data); end

  # The problem with implementing it properly
  # is that it means we'd have to have the ability to rewind
  # an engine because after we write+extract, the socket
  # write_nonblock call might raise an exception and later
  # code would pass the same data in, but the engine would think
  # it had already written the data in.
  #
  # So for the time being (and since write blocking is quite rare),
  # go ahead and actually block in write_nonblock.
  #
  # source://puma//lib/puma/minissl.rb#158
  def write_nonblock(data, *_); end

  private

  # Used to check the handshake status, in particular when a TCP connection
  # is made with TLSv1.3 as an available protocol
  #
  # @return [Boolean]
  # @version 5.0.0
  #
  # source://puma//lib/puma/minissl.rb#54
  def bad_tlsv1_3?; end
end

# https://github.com/openssl/openssl/blob/master/include/openssl/x509_vfy.h.in
# /* Certificate verify flags */
#
# source://puma//lib/puma/minissl.rb#371
Puma::MiniSSL::VERIFICATION_FLAGS = T.let(T.unsafe(nil), Hash)

# source://puma//lib/puma/minissl.rb#367
Puma::MiniSSL::VERIFY_FAIL_IF_NO_PEER_CERT = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/minissl.rb#365
Puma::MiniSSL::VERIFY_NONE = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/minissl.rb#366
Puma::MiniSSL::VERIFY_PEER = T.let(T.unsafe(nil), Integer)

# Provides an IO-like object that always appears to contain no data.
# Used as the value for rack.input when the request has no body.
class Puma::NullIO
  # source://puma//lib/puma/null_io.rb#28
  def close; end

  # This is used as singleton class, so can't have state.
  #
  # @return [Boolean]
  #
  # source://puma//lib/puma/null_io.rb#57
  def closed?; end

  # source://puma//lib/puma/null_io.rb#16
  def each; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/null_io.rb#35
  def eof?; end

  # source://puma//lib/puma/null_io.rb#52
  def flush; end

  # source://puma//lib/puma/null_io.rb#8
  def gets; end

  # source://puma//lib/puma/null_io.rb#46
  def puts(*ary); end

  # Mimics IO#read with no data.
  #
  # source://puma//lib/puma/null_io.rb#21
  def read(count = T.unsafe(nil), _buffer = T.unsafe(nil)); end

  # source://puma//lib/puma/null_io.rb#25
  def rewind; end

  # source://puma//lib/puma/null_io.rb#31
  def size; end

  # source://puma//lib/puma/null_io.rb#12
  def string; end

  # source://puma//lib/puma/null_io.rb#39
  def sync; end

  # source://puma//lib/puma/null_io.rb#43
  def sync=(v); end

  # source://puma//lib/puma/null_io.rb#49
  def write(*ary); end
end

class Puma::Plugin
  # source://puma//lib/puma/plugin.rb#107
  def in_background(&blk); end

  class << self
    # source://puma//lib/puma/plugin.rb#97
    def create(&blk); end

    # source://puma//lib/puma/plugin.rb#90
    def extract_name(ary); end
  end
end

# Matches
#  "C:/Ruby22/lib/ruby/gems/2.2.0/gems/puma-3.0.1/lib/puma/plugin/tmp_restart.rb:3:in `<top (required)>'"
#  AS
#  C:/Ruby22/lib/ruby/gems/2.2.0/gems/puma-3.0.1/lib/puma/plugin/tmp_restart.rb
#
# source://puma//lib/puma/plugin.rb#81
Puma::Plugin::CALLER_FILE = T.let(T.unsafe(nil), Regexp)

class Puma::PluginLoader
  # @return [PluginLoader] a new instance of PluginLoader
  #
  # source://puma//lib/puma/plugin.rb#7
  def initialize; end

  # @raise [UnknownPlugin]
  #
  # source://puma//lib/puma/plugin.rb#11
  def create(name); end

  # source://puma//lib/puma/plugin.rb#21
  def fire_starts(launcher); end
end

class Puma::PluginRegistry
  # @return [PluginRegistry] a new instance of PluginRegistry
  #
  # source://puma//lib/puma/plugin.rb#31
  def initialize; end

  # source://puma//lib/puma/plugin.rb#60
  def add_background(blk); end

  # @raise [UnknownPlugin]
  #
  # source://puma//lib/puma/plugin.rb#40
  def find(name); end

  # source://puma//lib/puma/plugin.rb#64
  def fire_background; end

  # source://puma//lib/puma/plugin.rb#36
  def register(name, cls); end
end

# source://puma//lib/puma/plugin.rb#74
Puma::Plugins = T.let(T.unsafe(nil), Puma::PluginRegistry)

module Puma::Rack; end

# Rack::Builder implements a small DSL to iteratively construct Rack
# applications.
#
# Example:
#
#  require 'rack/lobster'
#  app = Rack::Builder.new do
#    use Rack::CommonLogger
#    use Rack::ShowExceptions
#    map "/lobster" do
#      use Rack::Lint
#      run Rack::Lobster.new
#    end
#  end
#
#  run app
#
# Or
#
#  app = Rack::Builder.app do
#    use Rack::CommonLogger
#    run lambda { |env| [200, {'Content-Type' => 'text/plain'}, ['OK']] }
#  end
#
#  run app
#
# +use+ adds middleware to the stack, +run+ dispatches to an application.
# You can use +map+ to construct a Rack::URLMap in a convenient way.
class Puma::Rack::Builder
  # @return [Builder] a new instance of Builder
  #
  # source://puma//lib/puma/rack/builder.rb#176
  def initialize(default_app = T.unsafe(nil), &block); end

  # source://puma//lib/puma/rack/builder.rb#283
  def call(env); end

  # Creates a route within the application.
  #
  #   Rack::Builder.app do
  #     map '/' do
  #       run Heartbeat
  #     end
  #   end
  #
  # The +use+ method can also be used here to specify middleware to run under a specific path:
  #
  #   Rack::Builder.app do
  #     map '/' do
  #       use Middleware
  #       run Heartbeat
  #     end
  #   end
  #
  # This example includes a piece of middleware which will run before requests hit +Heartbeat+.
  #
  # source://puma//lib/puma/rack/builder.rb#270
  def map(path, &block); end

  # Takes an argument that is an object that responds to #call and returns a Rack response.
  # The simplest form of this is a lambda object:
  #
  #   run lambda { |env| [200, { "Content-Type" => "text/plain" }, ["OK"]] }
  #
  # However this could also be a class:
  #
  #   class Heartbeat
  #     def self.call(env)
  #      [200, { "Content-Type" => "text/plain" }, ["OK"]]
  #    end
  #   end
  #
  #   run Heartbeat
  #
  # source://puma//lib/puma/rack/builder.rb#234
  def run(app); end

  # source://puma//lib/puma/rack/builder.rb#275
  def to_app; end

  # Specifies middleware to use in a stack.
  #
  #   class Middleware
  #     def initialize(app)
  #       @app = app
  #     end
  #
  #     def call(env)
  #       env["rack.some_header"] = "setting an example"
  #       @app.call(env)
  #     end
  #   end
  #
  #   use Middleware
  #   run lambda { |env| [200, { "Content-Type" => "text/plain" }, ["OK"]] }
  #
  # All requests through to this application will first be processed by the middleware class.
  # The +call+ method in this example sets an additional environment key which then can be
  # referenced in the application if required.
  #
  # source://puma//lib/puma/rack/builder.rb#212
  def use(middleware, *args, &block); end

  # Takes a lambda or block that is used to warm-up the application.
  #
  #   warmup do |app|
  #     client = Rack::MockRequest.new(app)
  #     client.get('/')
  #   end
  #
  #   use SomeMiddleware
  #   run MyApp
  #
  # source://puma//lib/puma/rack/builder.rb#247
  def warmup(prc = T.unsafe(nil), &block); end

  private

  # source://puma//lib/puma/rack/builder.rb#289
  def generate_map(default_app, mapping); end

  class << self
    # source://puma//lib/puma/rack/builder.rb#189
    def app(default_app = T.unsafe(nil), &block); end

    # source://puma//lib/puma/rack/builder.rb#171
    def new_from_string(builder_script, file = T.unsafe(nil)); end

    # source://puma//lib/puma/rack/builder.rb#155
    def parse_file(config, opts = T.unsafe(nil)); end
  end
end

class Puma::Rack::Options
  # source://puma//lib/puma/rack/builder.rb#101
  def handler_opts(options); end

  # source://puma//lib/puma/rack/builder.rb#8
  def parse!(args); end
end

# Monitors a collection of IO objects, calling a block whenever
# any monitored object either receives data or times out, or when the Reactor shuts down.
#
# The waiting/wake up is performed with nio4r, which will use the appropriate backend (libev,
# Java NIO or just plain IO#select). The call to `NIO::Selector#select` will
# 'wakeup' any IO object that receives data.
#
# This class additionally tracks a timeout for every added object,
# and wakes up any object when its timeout elapses.
#
# The implementation uses a Queue to synchronize adding new objects from the internal select loop.
class Puma::Reactor
  # Create a new Reactor to monitor IO objects added by #add.
  # The provided block will be invoked when an IO has data available to read,
  # its timeout elapses, or when the Reactor shuts down.
  #
  # @return [Reactor] a new instance of Reactor
  #
  # source://puma//lib/puma/reactor.rb#23
  def initialize(backend, &block); end

  # Add a new client to monitor.
  # The object must respond to #timeout and #timeout_at.
  # Returns false if the reactor is already shut down.
  #
  # source://puma//lib/puma/reactor.rb#49
  def add(client); end

  # Run the internal select loop, using a background thread by default.
  #
  # source://puma//lib/puma/reactor.rb#35
  def run(background = T.unsafe(nil)); end

  # Shutdown the reactor, blocking until the background thread is finished.
  #
  # source://puma//lib/puma/reactor.rb#58
  def shutdown; end

  private

  # Start monitoring the object.
  #
  # source://puma//lib/puma/reactor.rb#100
  def register(client); end

  # source://puma//lib/puma/reactor.rb#69
  def select_loop; end

  # 'Wake up' a monitored object by calling the provided block.
  # Stop monitoring the object if the block returns `true`.
  #
  # source://puma//lib/puma/reactor.rb#109
  def wakeup!(client); end
end

# The methods here are included in Server, but are separated into this file.
# All the methods here pertain to passing the request to the app, then
# writing the response back to the client.
#
# None of the methods here are called externally, with the exception of
# #handle_request, which is called in Server#process_client.
#
# @version 5.0.3
module Puma::Request
  include ::Puma::Const

  # @param env [Hash] see Puma::Client#env, from request
  # @return [Puma::Const::PORT_443, Puma::Const::PORT_80]
  #
  # source://puma//lib/puma/request.rb#251
  def default_server_port(env); end

  # Takes the request contained in +client+, invokes the Rack application to construct
  # the response and writes it back to +client.io+.
  #
  # It'll return +false+ when the connection is closed, this doesn't mean
  # that the response wasn't successful.
  #
  # It'll return +:async+ if the connection remains open but will be handled
  # elsewhere, i.e. the connection has been hijacked by the Rack application.
  #
  # Finally, it'll return +true+ on keep-alive connections.
  #
  # @param client [Puma::Client]
  # @param requests [Integer]
  # @return [Boolean, :async]
  #
  # source://puma//lib/puma/request.rb#50
  def handle_request(client, requests); end

  # Assembles the headers and prepares the body for actually sending the
  # response via `#fast_write_response`.
  #
  # @param status [Integer] the status returned by the Rack application
  # @param headers [Hash] the headers returned by the Rack application
  # @param res_body [Array] the body returned by the Rack application or
  #   a call to `Server#lowlevel_error`
  # @param requests [Integer] number of inline requests handled
  # @param client [Puma::Client]
  # @return [Boolean, :async] keep-alive status or `:async`
  #
  # source://puma//lib/puma/request.rb#149
  def prepare_response(status, headers, res_body, requests, client); end

  private

  # Used to write headers and body.
  # Writes to a socket (normally `Client#io`) using `#fast_write_str`.
  # Accumulates `body` items into `io_buffer`, then writes to socket.
  #
  # @param socket [#write] the response socket
  # @param body [Enumerable, File] the body object
  # @param io_buffer [Puma::IOBuffer] contains headers
  # @param chunked [Boolean]
  # @raise [ConnectionError]
  #
  # source://puma//lib/puma/request.rb#295
  def fast_write_response(socket, body, io_buffer, chunked, content_length); end

  # Used to write 'early hints', 'no body' responses, 'hijacked' responses,
  # and body segments (called by `fast_write_response`).
  # Writes a string to a socket (normally `Client#io`) using `write_nonblock`.
  # Large strings may not be written in one pass, especially if `io` is a
  # `MiniSSL::Socket`.
  #
  # @param socket [#write_nonblock] the request/response socket
  # @param str [String] the string written to the io
  # @raise [ConnectionError]
  #
  # source://puma//lib/puma/request.rb#268
  def fast_write_str(socket, str); end

  # @param status [Integer] status from the app
  # @return [String] the text description from Puma::HTTP_STATUS_CODES
  #
  # source://puma//lib/puma/request.rb#527
  def fetch_status_code(status); end

  # @param header_key [#to_s]
  # @return [Boolean]
  #
  # source://puma//lib/puma/request.rb#453
  def illegal_header_key?(header_key); end

  # @param header_value [#to_s]
  # @return [Boolean]
  #
  # source://puma//lib/puma/request.rb#460
  def illegal_header_value?(header_value); end

  # Given a Hash +env+ for the request read from +client+, add
  # and fixup keys to comply with Rack's env guidelines.
  #
  # @param env [Hash] see Puma::Client#env, from request
  # @param client [Puma::Client] only needed for Client#peerip
  #
  # source://puma//lib/puma/request.rb#380
  def normalize_env(env, client); end

  # Fixup any headers with `,` in the name to have `_` now. We emit
  # headers with `,` in them during the parse phase to avoid ambiguity
  # with the `-` to `_` conversion for critical headers. But here for
  # compatibility, we'll convert them back. This code is written to
  # avoid allocation in the common case (ie there are no headers
  # with `,` in their names), that's why it has the extra conditionals.
  #
  # @param env [Hash] see Puma::Client#env, from request, modifies in place
  # @version 5.0.3
  #
  # source://puma//lib/puma/request.rb#474
  def req_env_post_parse(env); end

  # Used in the lambda for env[ `Puma::Const::EARLY_HINTS` ]
  #
  # @param headers [Hash] the headers returned by the Rack application
  # @return [String]
  # @version 5.0.3
  #
  # source://puma//lib/puma/request.rb#506
  def str_early_hints(headers); end

  # Processes and write headers to the IOBuffer.
  #
  # @param env [Hash] see Puma::Client#env, from request
  # @param status [Integer] the status returned by the Rack application
  # @param headers [Hash] the headers returned by the Rack application
  # @param content_length [Integer, nil] content length if it can be determined from the
  #   response body
  # @param io_buffer [Puma::IOBuffer] modified inn place
  # @param force_keep_alive [Boolean] 'anded' with keep_alive, based on system
  #   status and `@max_fast_inline`
  # @return [Hash] resp_info
  # @version 5.0.3
  #
  # source://puma//lib/puma/request.rb#544
  def str_headers(env, status, headers, res_body, io_buffer, force_keep_alive); end
end

# Single element array body: smaller bodies are written to io_buffer first,
# then a single write from io_buffer. Larger sizes are written separately.
# Also fixes max size of chunked file body read.
#
# source://puma//lib/puma/request.rb#20
Puma::Request::BODY_LEN_MAX = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/request.rb#32
Puma::Request::CUSTOM_STAT = T.let(T.unsafe(nil), String)

# File body: smaller bodies are combined with io_buffer, then written to
# socket.  Larger bodies are written separately using `copy_stream`
#
# source://puma//lib/puma/request.rb#24
Puma::Request::IO_BODY_MAX = T.let(T.unsafe(nil), Integer)

# Array body: elements are collected in io_buffer.  When io_buffer's size
# exceeds value, they are written to the socket.
#
# source://puma//lib/puma/request.rb#28
Puma::Request::IO_BUFFER_LEN_MAX = T.let(T.unsafe(nil), Integer)

# source://puma//lib/puma/request.rb#30
Puma::Request::SOCKET_WRITE_ERR_MSG = T.let(T.unsafe(nil), String)

# Generic class that is used by `Puma::Cluster` and `Puma::Single` to
# serve requests. This class spawns a new instance of `Puma::Server` via
# a call to `start_server`.
class Puma::Runner
  # @return [Runner] a new instance of Runner
  #
  # source://puma//lib/puma/runner.rb#11
  def initialize(launcher); end

  # source://puma//lib/puma/runner.rb#168
  def app; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/runner.rb#85
  def close_control_listeners; end

  # source://puma//lib/puma/runner.rb#57
  def debug(str); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/runner.rb#36
  def development?; end

  # source://puma//lib/puma/runner.rb#53
  def error(str); end

  # source://puma//lib/puma/runner.rb#151
  def load_and_bind; end

  # source://puma//lib/puma/runner.rb#44
  def log(str); end

  # Returns the hash of configuration options.
  #
  # @return [Puma::UserFileDefaultOptions]
  #
  # source://puma//lib/puma/runner.rb#25
  def options; end

  # source://puma//lib/puma/runner.rb#102
  def output_header(mode); end

  # source://puma//lib/puma/runner.rb#124
  def redirect_io; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/runner.rb#120
  def redirected_io?; end

  # source://puma//lib/puma/runner.rb#90
  def ruby_engine; end

  # source://puma//lib/puma/runner.rb#61
  def start_control; end

  # source://puma//lib/puma/runner.rb#172
  def start_server; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/runner.rb#49
  def stop_control; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/runner.rb#40
  def test?; end

  # source://puma//lib/puma/runner.rb#27
  def wakeup!; end

  private

  # source://puma//lib/puma/runner.rb#179
  def ensure_output_directory_exists(path, io_name); end

  # source://puma//lib/puma/runner.rb#185
  def stats; end
end

# For some HTTP status codes the client only expects headers.
#
# source://puma//lib/puma/const.rb#84
Puma::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

# The HTTP Server itself. Serves out a single Rack app.
#
# This class is used by the `Puma::Single` and `Puma::Cluster` classes
# to generate one or more `Puma::Server` instances capable of handling requests.
# Each Puma process will contain one `Puma::Server` instance.
#
# The `Puma::Server` instance pulls requests from the socket, adds them to a
# `Puma::Reactor` where they get eventually passed to a `Puma::ThreadPool`.
#
# Each `Puma::Server` will have one reactor and one thread pool.
class Puma::Server
  include ::Puma::Const
  include ::Puma::Request
  extend ::Forwardable

  # Create a server for the rack app +app+.
  #
  # +log_writer+ is a Puma::LogWriter object used to log info and error messages.
  #
  # +events+ is a Puma::Events object used to notify application status events.
  #
  # Server#run returns a thread that you can join on to wait for the server
  # to do its work.
  #
  # @note Several instance variables exist so they are available for testing,
  #   and have default values set via +fetch+.  Normally the values are set via
  #   `::Puma::Configuration.puma_default_options`.
  # @note The `events` parameter is set to nil, and set to `Events.new` in code.
  #   Often `options` needs to be passed, but `events` does not.  Using nil allows
  #   calling code to not require events.rb.
  # @return [Server] a new instance of Server
  #
  # source://puma//lib/puma/server.rb#73
  def initialize(app, events = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def add_ssl_listener(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def add_tcp_listener(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def add_unix_listener(*args, **_arg1, &block); end

  # Returns the value of attribute app.
  #
  # source://puma//lib/puma/server.rb#48
  def app; end

  # Sets the attribute app
  #
  # @param value the value to set the attribute app to.
  #
  # source://puma//lib/puma/server.rb#48
  def app=(_arg0); end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def auto_trim_time; end

  # source://puma//lib/puma/server.rb#197
  def backlog; end

  # source://puma//lib/puma/server.rb#593
  def begin_restart(sync = T.unsafe(nil)); end

  # Returns the value of attribute binder.
  #
  # source://puma//lib/puma/server.rb#49
  def binder; end

  # Sets the attribute binder
  #
  # @param value the value to set the attribute binder to.
  #
  # source://puma//lib/puma/server.rb#49
  def binder=(_arg0); end

  # Handle various error types thrown by Client I/O operations.
  #
  # source://puma//lib/puma/server.rb#493
  def client_error(e, client); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/server.rb#174
  def closed_socket?(socket); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def connected_ports(*args, **_arg1, &block); end

  # 6 == Socket::IPPROTO_TCP
  # 3 == TCP_CORK
  # 1/0 == turn on/off
  #
  # source://puma//lib/puma/server.rb#146
  def cork_socket(socket); end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def early_hints; end

  # Returns the value of attribute events.
  #
  # source://puma//lib/puma/server.rb#39
  def events; end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def first_data_timeout; end

  # Wait for all outstanding requests to finish.
  #
  # source://puma//lib/puma/server.rb#536
  def graceful_shutdown; end

  # source://puma//lib/puma/server.rb#588
  def halt(sync = T.unsafe(nil)); end

  # source://puma//lib/puma/server.rb#375
  def handle_check; end

  # source://puma//lib/puma/server.rb#299
  def handle_servers; end

  # source://puma//lib/puma/server.rb#113
  def inherit_binder(bind); end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def leak_stack_on_error; end

  # Returns the value of attribute log_writer.
  #
  # source://puma//lib/puma/server.rb#38
  def log_writer; end

  # A fallback rack response if +@app+ raises as exception.
  #
  # source://puma//lib/puma/server.rb#515
  def lowlevel_error(e, env, status = T.unsafe(nil)); end

  # for #stats
  #
  # source://puma//lib/puma/server.rb#40
  def max_threads; end

  # for #stats
  #
  # source://puma//lib/puma/server.rb#40
  def min_threads; end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def persistent_timeout; end

  # This number represents the number of requests that
  # the server is capable of taking right now.
  #
  # For example if the number is 5 then it means
  # there are 5 threads sitting idle ready to take
  # a request. If one request comes in, then the
  # value would be 4 until it finishes processing.
  #
  # source://puma//lib/puma/server.rb#215
  def pool_capacity; end

  # Given a connection on +client+, handle the incoming requests,
  # or queue the connection in the Reactor if no request is available.
  #
  # This method is called from a ThreadPool worker thread.
  #
  # This method supports HTTP Keep-Alive so it may, depending on if the client
  # indicates that it supports keep alive, wait for another request before
  # returning.
  #
  # Return true if one or more requests were processed.
  #
  # source://puma//lib/puma/server.rb#403
  def process_client(client); end

  # This method is called from the Reactor thread when a queued Client receives data,
  # times out, or when the Reactor is shutting down.
  #
  # It is responsible for ensuring that a request has been completely received
  # before it starts to be processed by the ThreadPool. This may be known as read buffering.
  # If read buffering is not done, and no other read buffering is performed (such as by an application server
  # such as nginx) then the application would be subject to a slow client attack.
  #
  # For a graphical representation of how the request buffer works see [architecture.md](https://github.com/puma/puma/blob/master/docs/architecture.md#connection-pipeline).
  #
  # The method checks to see if it has the full header and body with
  # the `Puma::Client#try_to_finish` method. If the full request has been sent,
  # then the request is passed to the ThreadPool (`@thread_pool << client`)
  # so that a "worker thread" can pick up the request and begin to execute application logic.
  # The Client is then removed from the reactor (return `true`).
  #
  # If a client object times out, a 408 response is written, its connection is closed,
  # and the object is removed from the reactor (return `true`).
  #
  # If the Reactor is shutting down, all Clients are either timed out or passed to the
  # ThreadPool, depending on their current state (#can_close?).
  #
  # Otherwise, if the full request is not ready then the client will remain in the reactor
  # (return `false`). When the client sends more data to the socket the `Puma::Client` object
  # will wake up and again be checked to see if it's ready to be passed to the thread pool.
  #
  # source://puma//lib/puma/server.rb#283
  def reactor_wakeup(client); end

  # @todo the following may be deprecated in the future
  #
  # source://puma//lib/puma/server.rb#44
  def reaping_time; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/server.rb#41
  def requests_count; end

  # Runs the server.
  #
  # If +background+ is true (the default) then a thread is spun
  # up in the background to handle requests. Otherwise requests
  # are handled synchronously.
  #
  # source://puma//lib/puma/server.rb#225
  def run(background = T.unsafe(nil), thread_name: T.unsafe(nil)); end

  # source://puma//lib/puma/server.rb#202
  def running; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/server.rb#598
  def shutting_down?; end

  # Returns a hash of stats about the running server for reporting purposes.
  #
  # @version 5.0.0
  #
  # source://puma//lib/puma/server.rb#609
  def stats; end

  # Stops the acceptor thread and then causes the worker threads to finish
  # off the request queue before finally exiting.
  #
  # source://puma//lib/puma/server.rb#583
  def stop(sync = T.unsafe(nil)); end

  # Returns the value of attribute thread.
  #
  # source://puma//lib/puma/server.rb#37
  def thread; end

  # source://puma//lib/puma/server.rb#155
  def uncork_socket(socket); end

  # Triggers a client timeout if the thread-pool shuts down
  # during execution of the provided block.
  #
  # source://puma//lib/puma/server.rb#484
  def with_force_shutdown(client, &block); end

  private

  # source://puma//lib/puma/server.rb#565
  def notify_safely(message); end

  class << self
    # source://puma//lib/puma/server.rb#119
    def current; end

    private

    # @return [Boolean]
    # @version 5.0.0
    #
    # source://puma//lib/puma/server.rb#131
    def closed_socket_supported?; end

    # @return [Boolean]
    # @version 5.0.0
    #
    # source://puma//lib/puma/server.rb#125
    def tcp_cork_supported?; end
  end
end

# List of methods invoked by #stats.
#
# @version 5.0.0
#
# source://puma//lib/puma/server.rb#604
Puma::Server::STAT_METHODS = T.let(T.unsafe(nil), Array)

# source://puma//lib/puma/server.rb#54
Puma::Server::ThreadLocalKey = T.let(T.unsafe(nil), Symbol)

# source://puma//lib/puma/server.rb#172
Puma::Server::UNPACK_TCP_STATE_FROM_TCP_INFO = T.let(T.unsafe(nil), String)

# This class is instantiated by the `Puma::Launcher` and used
# to boot and serve a Ruby application when no puma "workers" are needed
# i.e. only using "threaded" mode. For example `$ puma -t 1:5`
#
# At the core of this class is running an instance of `Puma::Server` which
# gets created via the `start_server` method from the `Puma::Runner` class
# that this inherits from.
class Puma::Single < ::Puma::Runner
  # source://puma//lib/puma/single.rb#31
  def halt; end

  # source://puma//lib/puma/single.rb#23
  def restart; end

  # source://puma//lib/puma/single.rb#41
  def run; end

  # source://puma//lib/puma/single.rb#17
  def stats; end

  # source://puma//lib/puma/single.rb#27
  def stop; end

  # source://puma//lib/puma/single.rb#35
  def stop_blocked; end
end

# Internal Docs for A simple thread pool management object.
#
# Each Puma "worker" has a thread pool to process requests.
#
# First a connection to a client is made in `Puma::Server`. It is wrapped in a
# `Puma::Client` instance and then passed to the `Puma::Reactor` to ensure
# the whole request is buffered into memory. Once the request is ready, it is passed into
# a thread pool via the `Puma::ThreadPool#<<` operator where it is stored in a `@todo` array.
#
# Each thread in the pool has an internal loop where it pulls a request from the `@todo` array
# and processes it.
class Puma::ThreadPool
  # Maintain a minimum of +min+ and maximum of +max+ threads
  # in the pool.
  #
  # The block passed is the work that will be performed in each
  # thread.
  #
  # @return [ThreadPool] a new instance of ThreadPool
  #
  # source://puma//lib/puma/thread_pool.rb#34
  def initialize(name, options = T.unsafe(nil), &block); end

  # Add +work+ to the todo list for a Thread to pickup and process.
  #
  # source://puma//lib/puma/thread_pool.rb#185
  def <<(work); end

  # source://puma//lib/puma/thread_pool.rb#327
  def auto_reap!(timeout = T.unsafe(nil)); end

  # source://puma//lib/puma/thread_pool.rb#322
  def auto_trim!(timeout = T.unsafe(nil)); end

  # How many objects have yet to be processed by the pool?
  #
  # source://puma//lib/puma/thread_pool.rb#84
  def backlog; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/thread_pool.rb#95
  def busy_threads; end

  # source://puma//lib/puma/thread_pool.rb#89
  def pool_capacity; end

  # If there are dead threads in the pool make them go away while decreasing
  # spawned counter so that new healthy threads could be created again.
  #
  # source://puma//lib/puma/thread_pool.rb#280
  def reap; end

  # Tell all threads in the pool to exit and wait for them to finish.
  # Wait +timeout+ seconds then raise +ForceShutdown+ in remaining threads.
  # Next, wait an extra +grace+ seconds then force-kill remaining threads.
  # Finally, wait +kill_grace+ seconds for remaining threads to exit.
  #
  # source://puma//lib/puma/thread_pool.rb#350
  def shutdown(timeout = T.unsafe(nil)); end

  # Returns the value of attribute spawned.
  #
  # source://puma//lib/puma/thread_pool.rb#74
  def spawned; end

  # If there are any free threads in the pool, tell one to go ahead
  # and exit. If +force+ is true, then a trim request is requested
  # even if all threads are being utilized.
  #
  # source://puma//lib/puma/thread_pool.rb#268
  def trim(force = T.unsafe(nil)); end

  # Returns the value of attribute trim_requested.
  #
  # source://puma//lib/puma/thread_pool.rb#74
  def trim_requested; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/thread_pool.rb#244
  def wait_for_less_busy_worker(delay_s); end

  # This method is used by `Puma::Server` to let the server know when
  # the thread pool can pull more requests from the socket and
  # pass to the reactor.
  #
  # The general idea is that the thread pool can only work on a fixed
  # number of requests at the same time. If it is already processing that
  # number of requests then it is at capacity. If another Puma process has
  # spare capacity, then the request can be left on the socket so the other
  # worker can pick it up and process it.
  #
  # For example: if there are 5 threads, but only 4 working on
  # requests, this method will not wait and the `Puma::Server`
  # can pull a request right away.
  #
  # If there are 5 threads and all 5 of them are busy, then it will
  # pause here, and wait until the `not_full` condition variable is
  # signaled, usually this indicates that a request has been processed.
  #
  # It's important to note that even though the server might accept another
  # request, it might not be added to the `@todo` array right away.
  # For example if a slow client has only sent a header, but not a body
  # then the `@todo` array would stay the same size as the reactor works
  # to try to buffer the request. In that scenario the next call to this
  # method would not block and another request would be added into the reactor
  # by the server. This would continue until a fully buffered request
  # makes it through the reactor and can then be processed by the thread pool.
  #
  # source://puma//lib/puma/thread_pool.rb#227
  def wait_until_not_full; end

  # Returns the value of attribute waiting.
  #
  # source://puma//lib/puma/thread_pool.rb#74
  def waiting; end

  # Allows ThreadPool::ForceShutdown to be raised within the
  # provided block if the thread is forced to shutdown during execution.
  #
  # source://puma//lib/puma/thread_pool.rb#334
  def with_force_shutdown; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/thread_pool.rb#178
  def with_mutex(&block); end

  private

  #
  # Must be called with @mutex held!
  #
  # source://puma//lib/puma/thread_pool.rb#103
  def spawn_thread; end

  # @version 5.0.0
  #
  # source://puma//lib/puma/thread_pool.rb#162
  def trigger_out_of_band_hook; end

  class << self
    # source://puma//lib/puma/thread_pool.rb#76
    def clean_thread_locals; end
  end
end

class Puma::ThreadPool::Automaton
  # @return [Automaton] a new instance of Automaton
  #
  # source://puma//lib/puma/thread_pool.rb#296
  def initialize(pool, timeout, thread_name, message); end

  # source://puma//lib/puma/thread_pool.rb#304
  def start!; end

  # source://puma//lib/puma/thread_pool.rb#316
  def stop; end
end

class Puma::ThreadPool::ForceShutdown < ::RuntimeError; end

# How long, after raising the ForceShutdown of a thread during
# forced shutdown mode, to wait for the thread to try and finish
# up its work before leaving the thread to die on the vine.
#
# source://puma//lib/puma/thread_pool.rb#26
Puma::ThreadPool::SHUTDOWN_GRACE_TIME = T.let(T.unsafe(nil), Integer)

class Puma::UnknownPlugin < ::RuntimeError; end
class Puma::UnsupportedBackend < ::StandardError; end
class Puma::UnsupportedOption < ::RuntimeError; end

# A class used for storing "leveled" configuration options.
#
# In this class any "user" specified options take precedence over any
# "file" specified options, take precedence over any "default" options.
#
# User input is preferred over "defaults":
#   user_options    = { foo: "bar" }
#   default_options = { foo: "zoo" }
#   options = UserFileDefaultOptions.new(user_options, default_options)
#   puts options[:foo]
#   # => "bar"
#
# All values can be accessed via `all_of`
#
#   puts options.all_of(:foo)
#   # => ["bar", "zoo"]
#
# A "file" option can be set. This config will be preferred over "default" options
# but will defer to any available "user" specified options.
#
#   user_options    = { foo: "bar" }
#   default_options = { rackup: "zoo.rb" }
#   options = UserFileDefaultOptions.new(user_options, default_options)
#   options.file_options[:rackup] = "sup.rb"
#   puts options[:rackup]
#   # => "sup.rb"
#
# The "default" options can be set via procs. These are resolved during runtime
# via calls to `finalize_values`
class Puma::UserFileDefaultOptions
  # @return [UserFileDefaultOptions] a new instance of UserFileDefaultOptions
  #
  # source://puma//lib/puma/configuration.rb#39
  def initialize(user_options, default_options); end

  # source://puma//lib/puma/configuration.rb#47
  def [](key); end

  # source://puma//lib/puma/configuration.rb#51
  def []=(key, value); end

  # source://puma//lib/puma/configuration.rb#63
  def all_of(key); end

  # Returns the value of attribute default_options.
  #
  # source://puma//lib/puma/configuration.rb#45
  def default_options; end

  # source://puma//lib/puma/configuration.rb#55
  def fetch(key, default_value = T.unsafe(nil)); end

  # Returns the value of attribute file_options.
  #
  # source://puma//lib/puma/configuration.rb#45
  def file_options; end

  # source://puma//lib/puma/configuration.rb#87
  def final_options; end

  # source://puma//lib/puma/configuration.rb#79
  def finalize_values; end

  # Returns the value of attribute user_options.
  #
  # source://puma//lib/puma/configuration.rb#45
  def user_options; end
end

module Puma::Util
  private

  # source://puma//lib/puma/util.rb#24
  def escape(s, encoding = T.unsafe(nil)); end

  # Stolen from Mongrel, with some small modifications:
  # Parses a query string by breaking it up at the '&'
  # and ';' characters.  You can also use this to parse
  # cookies by changing the characters used in the second
  # parameter (which defaults to '&;').
  #
  # source://puma//lib/puma/util.rb#49
  def parse_query(qs, d = T.unsafe(nil), &unescaper); end

  # source://puma//lib/puma/util.rb#9
  def pipe; end

  # An instance method on Thread has been provided to address https://bugs.ruby-lang.org/issues/13632,
  # which currently effects some older versions of Ruby: 2.2.7 2.2.8 2.2.9 2.2.10 2.3.4 2.4.1
  # Additional context: https://github.com/puma/puma/pull/1345
  #
  # source://puma//lib/puma/util.rb#16
  def purge_interrupt_queue; end

  # source://puma//lib/puma/util.rb#28
  def unescape(s, encoding = T.unsafe(nil)); end

  class << self
    # source://puma//lib/puma/util.rb#24
    def escape(s, encoding = T.unsafe(nil)); end

    # Stolen from Mongrel, with some small modifications:
    # Parses a query string by breaking it up at the '&'
    # and ';' characters.  You can also use this to parse
    # cookies by changing the characters used in the second
    # parameter (which defaults to '&;').
    #
    # source://puma//lib/puma/util.rb#49
    def parse_query(qs, d = T.unsafe(nil), &unescaper); end

    # source://puma//lib/puma/util.rb#9
    def pipe; end

    # An instance method on Thread has been provided to address https://bugs.ruby-lang.org/issues/13632,
    # which currently effects some older versions of Ruby: 2.2.7 2.2.8 2.2.9 2.2.10 2.3.4 2.4.1
    # Additional context: https://github.com/puma/puma/pull/1345
    #
    # source://puma//lib/puma/util.rb#16
    def purge_interrupt_queue; end

    # source://puma//lib/puma/util.rb#28
    def unescape(s, encoding = T.unsafe(nil)); end
  end
end

# source://puma//lib/puma/util.rb#42
Puma::Util::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# A case-insensitive Hash that preserves the original case of a
# header when set.
class Puma::Util::HeaderHash < ::Hash
  # @return [HeaderHash] a new instance of HeaderHash
  #
  # source://puma//lib/puma/util.rb#79
  def initialize(hash = T.unsafe(nil)); end

  # source://puma//lib/puma/util.rb#98
  def [](k); end

  # source://puma//lib/puma/util.rb#102
  def []=(k, v); end

  # source://puma//lib/puma/util.rb#109
  def delete(k); end

  # source://puma//lib/puma/util.rb#85
  def each; end

  # @return [Boolean]
  #
  # source://puma//lib/puma/util.rb#116
  def has_key?(k); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/util.rb#116
  def include?(k); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/util.rb#116
  def key?(k); end

  # @return [Boolean]
  #
  # source://puma//lib/puma/util.rb#116
  def member?(k); end

  # source://puma//lib/puma/util.rb#129
  def merge(other); end

  # source://puma//lib/puma/util.rb#124
  def merge!(other); end

  # source://puma//lib/puma/util.rb#134
  def replace(other); end

  # source://puma//lib/puma/util.rb#92
  def to_hash; end

  class << self
    # source://puma//lib/puma/util.rb#75
    def new(hash = T.unsafe(nil)); end
  end
end
