# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `pg` gem.
# Please instead update this file by running `bin/tapioca gem pg`.

# The top-level PG namespace.
module PG
  include ::PG::Constants

  class << self
    # Convenience alias for PG::Connection.new.
    #
    # source://pg//lib/pg.rb#68
    def connect(*args, &block); end

    def init_openssl(_arg0, _arg1); end
    def init_ssl(_arg0); end
    def is_threadsafe?; end
    def isthreadsafe; end
    def library_version; end
    def threadsafe?; end

    # Get the PG library version.
    #
    # +include_buildnum+ is no longer used and any value passed will be ignored.
    #
    # source://pg//lib/pg.rb#62
    def version_string(include_buildnum = T.unsafe(nil)); end
  end
end

class PG::ActiveSqlTransaction < ::PG::InvalidTransactionState; end
class PG::AdminShutdown < ::PG::OperatorIntervention; end
class PG::AmbiguousAlias < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::AmbiguousColumn < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::AmbiguousFunction < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::AmbiguousParameter < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::ArraySubscriptError < ::PG::DataException; end
class PG::AssertFailure < ::PG::PlpgsqlError; end
class PG::BadCopyFileFormat < ::PG::DataException; end

# Simple set of rules for type casting common PostgreSQL types from Ruby
# to PostgreSQL.
#
# OIDs of supported type casts are not hard-coded in the sources, but are retrieved from the
# PostgreSQL's +pg_type+ table in PG::BasicTypeMapBasedOnResult.new .
#
# This class works equal to PG::BasicTypeMapForResults, but does not define decoders for
# the given result OIDs, but encoders. So it can be used to type cast field values based on
# the type OID retrieved by a separate SQL query.
#
# PG::TypeMapByOid#build_column_map(result) can be used to generate a result independent
# PG::TypeMapByColumn type map, which can subsequently be used to cast query bind parameters
# or #put_copy_data fields.
#
# Example:
#   conn.exec( "CREATE TEMP TABLE copytable (t TEXT, i INT, ai INT[])" )
#
#   # Retrieve table OIDs per empty result set.
#   res = conn.exec( "SELECT * FROM copytable LIMIT 0" )
#   # Build a type map for common ruby to database type encoders.
#   btm = PG::BasicTypeMapBasedOnResult.new(conn)
#   # Build a PG::TypeMapByColumn with encoders suitable for copytable.
#   tm = btm.build_column_map( res )
#   row_encoder = PG::TextEncoder::CopyRow.new type_map: tm
#
#   conn.copy_data( "COPY copytable FROM STDIN", row_encoder ) do |res|
#     conn.put_copy_data ['a', 123, [5,4,3]]
#   end
# This inserts a single row into copytable with type casts from ruby to
# database types.
class PG::BasicTypeMapBasedOnResult < ::PG::TypeMapByOid
  include ::PG::BasicTypeRegistry::Checker

  # @return [BasicTypeMapBasedOnResult] a new instance of BasicTypeMapBasedOnResult
  #
  # source://pg//lib/pg/basic_type_map_based_on_result.rb#39
  def initialize(connection_or_coder_maps, registry: T.unsafe(nil)); end
end

# Simple set of rules for type casting common Ruby types to PostgreSQL.
#
# OIDs of supported type casts are not hard-coded in the sources, but are retrieved from the
# PostgreSQL's pg_type table in PG::BasicTypeMapForQueries.new .
#
# Query params are type casted based on the class of the given value.
#
# Higher level libraries will most likely not make use of this class, but use their
# own derivation of PG::TypeMapByClass or another set of rules to choose suitable
# encoders and decoders for the values to be sent.
#
# Example:
#   conn = PG::Connection.new
#   # Assign a default ruleset for type casts of input and output values.
#   conn.type_map_for_queries = PG::BasicTypeMapForQueries.new(conn)
#   # Execute a query. The Integer param value is typecasted internally by PG::BinaryEncoder::Int8.
#   # The format of the parameter is set to 0 (text) and the OID of this parameter is set to 20 (int8).
#   res = conn.exec_params( "SELECT $1", [5] )
class PG::BasicTypeMapForQueries < ::PG::TypeMapByClass
  include ::PG::BasicTypeRegistry::Checker

  # Create a new type map for query submission
  #
  # Options:
  # * +registry+: Custom type registry, nil for default global registry
  # * +if_undefined+: Optional +Proc+ object which is called, if no type for an parameter class is not defined in the registry.
  #
  # @return [BasicTypeMapForQueries] a new instance of BasicTypeMapForQueries
  #
  # source://pg//lib/pg/basic_type_map_for_queries.rb#50
  def initialize(connection_or_coder_maps, registry: T.unsafe(nil), if_undefined: T.unsafe(nil)); end

  # Returns the value of attribute encode_array_as.
  #
  # source://pg//lib/pg/basic_type_map_for_queries.rb#86
  def encode_array_as; end

  # Change the mechanism that is used to encode ruby array values
  #
  # Possible values:
  # * +:array+ : Encode the ruby array as a PostgreSQL array.
  #   The array element type is inferred from the class of the first array element. This is the default.
  # * +:json+ : Encode the ruby array as a JSON document.
  # * +:record+ : Encode the ruby array as a composite type row.
  # * <code>"_type"</code> : Encode the ruby array as a particular PostgreSQL type.
  #   All PostgreSQL array types are supported.
  #   If there's an encoder registered for the elements +type+, it will be used.
  #   Otherwise a string conversion (by +value.to_s+) is done.
  #
  # source://pg//lib/pg/basic_type_map_for_queries.rb#71
  def encode_array_as=(pg_type); end

  private

  # source://pg//lib/pg/basic_type_map_for_queries.rb#148
  def array_encoders_by_klass; end

  # source://pg//lib/pg/basic_type_map_for_queries.rb#96
  def coder_by_name(format, direction, name); end

  # source://pg//lib/pg/basic_type_map_for_queries.rb#155
  def get_array_type(value); end

  # source://pg//lib/pg/basic_type_map_for_queries.rb#90
  def init_encoders; end

  # source://pg//lib/pg/basic_type_map_for_queries.rb#105
  def populate_encoder_list; end

  # source://pg//lib/pg/basic_type_map_for_queries.rb#101
  def undefined(name, format); end
end

# Helper class for submission of binary strings into bytea columns.
#
# Since PG::BasicTypeMapForQueries chooses the encoder to be used by the class of the submitted value,
# it's necessary to send binary strings as BinaryData.
# That way they're distinct from text strings.
# Please note however that PG::BasicTypeMapForResults delivers bytea columns as plain String
# with binary encoding.
#
#   conn.type_map_for_queries = PG::BasicTypeMapForQueries.new(conn)
#   conn.exec("CREATE TEMP TABLE test (data bytea)")
#   bd = PG::BasicTypeMapForQueries::BinaryData.new("ab\xff\0cd")
#   conn.exec_params("INSERT INTO test (data) VALUES ($1)", [bd])
class PG::BasicTypeMapForQueries::BinaryData < ::String; end

# source://pg//lib/pg/basic_type_map_for_queries.rb#182
PG::BasicTypeMapForQueries::DEFAULT_ARRAY_TYPE_MAP = T.let(T.unsafe(nil), Hash)

# source://pg//lib/pg/basic_type_map_for_queries.rb#165
PG::BasicTypeMapForQueries::DEFAULT_TYPE_MAP = T.let(T.unsafe(nil), Hash)

class PG::BasicTypeMapForQueries::UndefinedEncoder < ::RuntimeError; end

# Simple set of rules for type casting common PostgreSQL types to Ruby.
#
# OIDs of supported type casts are not hard-coded in the sources, but are retrieved from the
# PostgreSQL's +pg_type+ table in PG::BasicTypeMapForResults.new .
#
# Result values are type casted based on the type OID of the given result column.
#
# Higher level libraries will most likely not make use of this class, but use their
# own set of rules to choose suitable encoders and decoders.
#
# Example:
#   conn = PG::Connection.new
#   # Assign a default ruleset for type casts of output values.
#   conn.type_map_for_results = PG::BasicTypeMapForResults.new(conn)
#   # Execute a query.
#   res = conn.exec_params( "SELECT $1::INT", ['5'] )
#   # Retrieve and cast the result value. Value format is 0 (text) and OID is 20. Therefore typecasting
#   # is done by PG::TextDecoder::Integer internally for all value retrieval methods.
#   res.values  # => [[5]]
#
# PG::TypeMapByOid#build_column_map(result) can be used to generate
# a result independent PG::TypeMapByColumn type map, which can subsequently be used
# to cast #get_copy_data fields:
#
# For the following table:
#   conn.exec( "CREATE TABLE copytable AS VALUES('a', 123, '{5,4,3}'::INT[])" )
#
#   # Retrieve table OIDs per empty result set.
#   res = conn.exec( "SELECT * FROM copytable LIMIT 0" )
#   # Build a type map for common database to ruby type decoders.
#   btm = PG::BasicTypeMapForResults.new(conn)
#   # Build a PG::TypeMapByColumn with decoders suitable for copytable.
#   tm = btm.build_column_map( res )
#   row_decoder = PG::TextDecoder::CopyRow.new type_map: tm
#
#   conn.copy_data( "COPY copytable TO STDOUT", row_decoder ) do |res|
#     while row=conn.get_copy_data
#       p row
#     end
#   end
# This prints the rows with type casted columns:
#   ["a", 123, [5, 4, 3]]
#
# See also PG::BasicTypeMapBasedOnResult for the encoder direction and PG::BasicTypeRegistry for the definition of additional types.
class PG::BasicTypeMapForResults < ::PG::TypeMapByOid
  include ::PG::BasicTypeRegistry::Checker

  # @return [BasicTypeMapForResults] a new instance of BasicTypeMapForResults
  #
  # source://pg//lib/pg/basic_type_map_for_results.rb#70
  def initialize(connection_or_coder_maps, registry: T.unsafe(nil)); end
end

class PG::BasicTypeMapForResults::WarningTypeMap < ::PG::TypeMapInRuby
  # @return [WarningTypeMap] a new instance of WarningTypeMap
  #
  # source://pg//lib/pg/basic_type_map_for_results.rb#54
  def initialize(typenames); end

  # source://pg//lib/pg/basic_type_map_for_results.rb#59
  def typecast_result_value(result, _tuple, field); end
end

# This class defines the mapping between PostgreSQL types and encoder/decoder classes for PG::BasicTypeMapForResults, PG::BasicTypeMapForQueries and PG::BasicTypeMapBasedOnResult.
#
# Additional types can be added like so:
#
#   require 'pg'
#   require 'ipaddr'
#
#   class InetDecoder < PG::SimpleDecoder
#     def decode(string, tuple=nil, field=nil)
#       IPAddr.new(string)
#     end
#   end
#   class InetEncoder < PG::SimpleEncoder
#     def encode(ip_addr)
#       ip_addr.to_s
#     end
#   end
#
#   conn = PG.connect
#   regi = PG::BasicTypeRegistry.new.register_default_types
#   regi.register_type(0, 'inet', InetEncoder, InetDecoder)
#   conn.type_map_for_results = PG::BasicTypeMapForResults.new(conn, registry: regi)
class PG::BasicTypeRegistry
  include ::PG::BasicTypeRegistry::Checker

  # @return [BasicTypeRegistry] a new instance of BasicTypeRegistry
  #
  # source://pg//lib/pg/basic_type_registry.rb#165
  def initialize; end

  # Alias the +old+ type to the +new+ type.
  #
  # source://pg//lib/pg/basic_type_registry.rb#201
  def alias_type(format, new, old); end

  # Retrieve a Hash of all en- or decoders for a given wire format.
  # The hash key is the name as defined in table +pg_type+.
  # The hash value is the registered coder object.
  #
  # source://pg//lib/pg/basic_type_registry.rb#173
  def coders_for(format, direction); end

  # Populate the registry with all builtin types of ruby-pg
  #
  # source://pg//lib/pg/basic_type_registry.rb#214
  def define_default_types; end

  # Register an encoder or decoder instance for casting a PostgreSQL type.
  #
  # Coder#name must correspond to the +typname+ column in the +pg_type+ table.
  # Coder#format can be 0 for text format and 1 for binary.
  #
  # source://pg//lib/pg/basic_type_registry.rb#182
  def register_coder(coder); end

  # Populate the registry with all builtin types of ruby-pg
  #
  # source://pg//lib/pg/basic_type_registry.rb#214
  def register_default_types; end

  # Register the given +encoder_class+ and/or +decoder_class+ for casting a PostgreSQL type.
  #
  # +name+ must correspond to the +typname+ column in the +pg_type+ table.
  # +format+ can be 0 for text format and 1 for binary.
  #
  # source://pg//lib/pg/basic_type_registry.rb#194
  def register_type(format, name, encoder_class, decoder_class); end

  class << self
    # source://pg//lib/pg/basic_type_registry.rb#295
    def alias_type(*args); end

    # source://pg//lib/pg/basic_type_registry.rb#295
    def register_coder(*args); end

    # source://pg//lib/pg/basic_type_registry.rb#295
    def register_type(*args); end
  end
end

module PG::BasicTypeRegistry::Checker
  protected

  # source://pg//lib/pg/basic_type_registry.rb#153
  def build_coder_maps(conn_or_maps, registry: T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://pg//lib/pg/basic_type_registry.rb#148
  def check_format_and_direction(format, direction); end
end

# source://pg//lib/pg/basic_type_registry.rb#146
PG::BasicTypeRegistry::Checker::ValidDirections = T.let(T.unsafe(nil), Hash)

# source://pg//lib/pg/basic_type_registry.rb#145
PG::BasicTypeRegistry::Checker::ValidFormats = T.let(T.unsafe(nil), Hash)

# An instance of this class stores the coders that should be used for a particular wire format (text or binary)
# and type cast direction (encoder or decoder).
#
# Each coder object is filled with the PostgreSQL type name, OID, wire format and array coders are filled with the base elements_type.
class PG::BasicTypeRegistry::CoderMap
  # @return [CoderMap] a new instance of CoderMap
  #
  # source://pg//lib/pg/basic_type_registry.rb#44
  def initialize(result, coders_by_name, format, arraycoder); end

  # source://pg//lib/pg/basic_type_registry.rb#83
  def coder_by_name(name); end

  # source://pg//lib/pg/basic_type_registry.rb#87
  def coder_by_oid(oid); end

  # Returns the value of attribute coders.
  #
  # source://pg//lib/pg/basic_type_registry.rb#79
  def coders; end

  # Returns the value of attribute coders_by_name.
  #
  # source://pg//lib/pg/basic_type_registry.rb#81
  def coders_by_name; end

  # Returns the value of attribute coders_by_oid.
  #
  # source://pg//lib/pg/basic_type_registry.rb#80
  def coders_by_oid; end
end

# Hash of text types that don't require quotation, when used within composite types.
#   type.name => true
#
# source://pg//lib/pg/basic_type_registry.rb#36
PG::BasicTypeRegistry::CoderMap::DONT_QUOTE_TYPES = T.let(T.unsafe(nil), Hash)

# An instance of this class stores CoderMap instances to be used for text and binary wire formats
# as well as encoder and decoder directions.
#
# A PG::BasicTypeRegistry::CoderMapsBundle instance retrieves all type definitions from the PostgreSQL server and matches them with the coder definitions of the global PG::BasicTypeRegistry .
# It provides 4 separate CoderMap instances for the combinations of the two formats and directions.
#
# A PG::BasicTypeRegistry::CoderMapsBundle instance can be used to initialize an instance of
# * PG::BasicTypeMapForResults
# * PG::BasicTypeMapForQueries
# * PG::BasicTypeMapBasedOnResult
# by passing it instead of the connection object like so:
#
#   conn = PG::Connection.new
#   maps = PG::BasicTypeRegistry::CoderMapsBundle.new(conn)
#   conn.type_map_for_results = PG::BasicTypeMapForResults.new(maps)
class PG::BasicTypeRegistry::CoderMapsBundle
  # @return [CoderMapsBundle] a new instance of CoderMapsBundle
  #
  # source://pg//lib/pg/basic_type_registry.rb#111
  def initialize(connection, registry: T.unsafe(nil)); end

  # source://pg//lib/pg/basic_type_registry.rb#135
  def each_format(direction); end

  # source://pg//lib/pg/basic_type_registry.rb#139
  def map_for(format, direction); end

  # Returns the value of attribute typenames_by_oid.
  #
  # source://pg//lib/pg/basic_type_registry.rb#109
  def typenames_by_oid; end
end

# @private
#
# source://pg//lib/pg/basic_type_registry.rb#290
PG::BasicTypeRegistry::DEFAULT_TYPE_REGISTRY = T.let(T.unsafe(nil), PG::BasicTypeRegistry)

module PG::BinaryDecoder; end

class PG::BinaryDecoder::Boolean < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::Boolean::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::Bytea < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::Bytea::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::Float < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::Float::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::Integer < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::Integer::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::String < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::String::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::Timestamp < ::PG::SimpleDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::Timestamp::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryDecoder::TimestampLocal < ::PG::BinaryDecoder::Timestamp
  # @return [TimestampLocal] a new instance of TimestampLocal
  #
  # source://pg//lib/pg/binary_decoder.rb#18
  def initialize(params = T.unsafe(nil)); end
end

# Convenience classes for timezone options
class PG::BinaryDecoder::TimestampUtc < ::PG::BinaryDecoder::Timestamp
  # @return [TimestampUtc] a new instance of TimestampUtc
  #
  # source://pg//lib/pg/binary_decoder.rb#8
  def initialize(params = T.unsafe(nil)); end
end

class PG::BinaryDecoder::TimestampUtcToLocal < ::PG::BinaryDecoder::Timestamp
  # @return [TimestampUtcToLocal] a new instance of TimestampUtcToLocal
  #
  # source://pg//lib/pg/binary_decoder.rb#13
  def initialize(params = T.unsafe(nil)); end
end

class PG::BinaryDecoder::ToBase64 < ::PG::CompositeDecoder
  include ::PG::Coder::BinaryFormatting

  def decode(*_arg0); end
end

PG::BinaryDecoder::ToBase64::CFUNC = T.let(T.unsafe(nil), Object)
module PG::BinaryEncoder; end

class PG::BinaryEncoder::Boolean < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::Boolean::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::Bytea < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::Bytea::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::FromBase64 < ::PG::CompositeEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::FromBase64::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::Int2 < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::Int2::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::Int4 < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::Int4::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::Int8 < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::Int8::CFUNC = T.let(T.unsafe(nil), Object)

class PG::BinaryEncoder::String < ::PG::SimpleEncoder
  include ::PG::Coder::BinaryFormatting

  def encode(*_arg0); end
end

PG::BinaryEncoder::String::CFUNC = T.let(T.unsafe(nil), Object)
class PG::BranchTransactionAlreadyActive < ::PG::InvalidTransactionState; end
class PG::CannotCoerce < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::CannotConnectNow < ::PG::OperatorIntervention; end
class PG::CantChangeRuntimeParam < ::PG::ObjectNotInPrerequisiteState; end
class PG::CardinalityViolation < ::PG::ServerError; end
class PG::CaseNotFound < ::PG::ServerError; end
class PG::CharacterNotInRepertoire < ::PG::DataException; end
class PG::CheckViolation < ::PG::IntegrityConstraintViolation; end

class PG::Coder
  # Create a new coder object based on the attribute Hash.
  #
  # @return [Coder] a new instance of Coder
  #
  # source://pg//lib/pg/coder.rb#17
  def initialize(params = T.unsafe(nil)); end

  # source://pg//lib/pg/coder.rb#37
  def ==(v); end

  # source://pg//lib/pg/coder.rb#23
  def dup; end

  def flags; end
  def flags=(_arg0); end
  def format; end
  def format=(_arg0); end

  # source://pg//lib/pg/coder.rb#49
  def inspect; end

  # source://pg//lib/pg/coder.rb#58
  def inspect_short; end

  # source://pg//lib/pg/coder.rb#41
  def marshal_dump; end

  # source://pg//lib/pg/coder.rb#45
  def marshal_load(str); end

  def name; end
  def name=(_arg0); end
  def oid; end
  def oid=(_arg0); end

  # Returns coder attributes as Hash.
  #
  # source://pg//lib/pg/coder.rb#28
  def to_h; end
end

module PG::Coder::BinaryFormatting
  # source://pg//lib/pg/coder.rb#10
  def initialize(params = T.unsafe(nil)); end
end

# source://pg//lib/pg/coder.rb#9
PG::Coder::BinaryFormatting::Params = T.let(T.unsafe(nil), Hash)

PG::Coder::FORMAT_ERROR_MASK = T.let(T.unsafe(nil), Integer)
PG::Coder::FORMAT_ERROR_TO_PARTIAL = T.let(T.unsafe(nil), Integer)
PG::Coder::FORMAT_ERROR_TO_RAISE = T.let(T.unsafe(nil), Integer)
PG::Coder::FORMAT_ERROR_TO_STRING = T.let(T.unsafe(nil), Integer)
PG::Coder::TIMESTAMP_APP_LOCAL = T.let(T.unsafe(nil), Integer)
PG::Coder::TIMESTAMP_APP_UTC = T.let(T.unsafe(nil), Integer)
PG::Coder::TIMESTAMP_DB_LOCAL = T.let(T.unsafe(nil), Integer)
PG::Coder::TIMESTAMP_DB_UTC = T.let(T.unsafe(nil), Integer)
class PG::CollationMismatch < ::PG::SyntaxErrorOrAccessRuleViolation; end

class PG::CompositeCoder < ::PG::Coder
  def delimiter; end
  def delimiter=(_arg0); end
  def elements_type; end
  def elements_type=(_arg0); end

  # source://pg//lib/pg/coder.rb#80
  def inspect; end

  def needs_quotation=(_arg0); end
  def needs_quotation?; end

  # source://pg//lib/pg/coder.rb#72
  def to_h; end
end

class PG::CompositeDecoder < ::PG::CompositeCoder; end
class PG::CompositeEncoder < ::PG::CompositeCoder; end
class PG::ConfigFileError < ::PG::ServerError; end
class PG::ConfigurationLimitExceeded < ::PG::InsufficientResources; end

# The PostgreSQL connection class. The interface for this class is based on
# {libpq}[http://www.postgresql.org/docs/current/libpq.html], the C
# application programmer's interface to PostgreSQL. Some familiarity with libpq
# is recommended, but not necessary.
#
# For example, to send query to the database on the localhost:
#
#    require 'pg'
#    conn = PG::Connection.open(:dbname => 'test')
#    res = conn.exec_params('SELECT $1 AS a, $2 AS b, $3 AS c', [1, 2, nil])
#    # Equivalent to:
#    #  res  = conn.exec('SELECT 1 AS a, 2 AS b, NULL AS c')
#
# See the PG::Result class for information on working with the results of a query.
#
# Many methods of this class have three variants kind of:
# 1. #exec - the base method which is an alias to #async_exec .
#    This is the method that should be used in general.
# 2. #async_exec - the async aware version of the method, implemented by libpq's async API.
# 3. #sync_exec - the method version that is implemented by blocking function(s) of libpq.
#
# Sync and async version of the method can be switched by Connection.async_api= , however it is not recommended to change the default.
class PG::Connection
  include ::PG::Constants

  # call-seq:
  #    conn.cancel() -> String
  #
  # Requests cancellation of the command currently being
  # processed.
  #
  # Returns +nil+ on success, or a string containing the
  # error message if a failure occurs.
  #
  # source://pg//lib/pg/connection.rb#518
  def async_cancel; end

  def async_describe_portal(_arg0); end
  def async_describe_prepared(_arg0); end

  # call-seq:
  #    conn.encrypt_password( password, username, algorithm=nil ) -> String
  #
  # This function is intended to be used by client applications that wish to send commands like <tt>ALTER USER joe PASSWORD 'pwd'</tt>.
  # It is good practice not to send the original cleartext password in such a command, because it might be exposed in command logs, activity displays, and so on.
  # Instead, use this function to convert the password to encrypted form before it is sent.
  #
  # The +password+ and +username+ arguments are the cleartext password, and the SQL name of the user it is for.
  # +algorithm+ specifies the encryption algorithm to use to encrypt the password.
  # Currently supported algorithms are +md5+ and +scram-sha-256+ (+on+ and +off+ are also accepted as aliases for +md5+, for compatibility with older server versions).
  # Note that support for +scram-sha-256+ was introduced in PostgreSQL version 10, and will not work correctly with older server versions.
  # If algorithm is omitted or +nil+, this function will query the server for the current value of the +password_encryption+ setting.
  # That can block, and will fail if the current transaction is aborted, or if the connection is busy executing another query.
  # If you wish to use the default algorithm for the server but want to avoid blocking, query +password_encryption+ yourself before calling #encrypt_password, and pass that value as the algorithm.
  #
  # Return value is the encrypted password.
  # The caller can assume the string doesn't contain any special characters that would require escaping.
  #
  # Available since PostgreSQL-10.
  # See also corresponding {libpq function}[https://www.postgresql.org/docs/current/libpq-misc.html#LIBPQ-PQENCRYPTPASSWORDCONN].
  #
  # source://pg//lib/pg/connection.rb#491
  def async_encrypt_password(password, username, algorithm = T.unsafe(nil)); end

  def async_exec(*_arg0); end
  def async_exec_params(*_arg0); end
  def async_exec_prepared(*_arg0); end
  def async_flush; end

  # call-seq:
  #    conn.get_copy_data( [ nonblock = false [, decoder = nil ]] ) -> Object
  #
  # Return one row of data, +nil+
  # if the copy is done, or +false+ if the call would
  # block (only possible if _nonblock_ is true).
  #
  # If _decoder_ is not set or +nil+, data is returned as binary string.
  #
  # If _decoder_ is set to a PG::Coder derivation, the return type depends on this decoder.
  # PG::TextDecoder::CopyRow decodes the received data fields from one row of PostgreSQL's
  # COPY text format to an Array of Strings.
  # Optionally the decoder can type cast the single fields to various Ruby types in one step,
  # if PG::TextDecoder::CopyRow#type_map is set accordingly.
  #
  # See also #copy_data.
  #
  # source://pg//lib/pg/connection.rb#359
  def async_get_copy_data(async = T.unsafe(nil), decoder = T.unsafe(nil)); end

  def async_get_last_result; end

  # call-seq:
  #    conn.get_result() -> PG::Result
  #    conn.get_result() {|pg_result| block }
  #
  # Blocks waiting for the next result from a call to
  # #send_query (or another asynchronous command), and returns
  # it. Returns +nil+ if no more results are available.
  #
  # Note: call this function repeatedly until it returns +nil+, or else
  # you will not be able to issue further commands.
  #
  # If the optional code block is given, it will be passed <i>result</i> as an argument,
  # and the PG::Result object will  automatically be cleared when the block terminates.
  # In this instance, <code>conn.exec</code> returns the value of the block.
  #
  # source://pg//lib/pg/connection.rb#336
  def async_get_result; end

  # call-seq:
  #    conn.isnonblocking() -> Boolean
  #
  # Returns the blocking status of the database connection.
  # Returns +true+ if the connection is set to nonblocking mode and +false+ if blocking.
  #
  # source://pg//lib/pg/connection.rb#407
  def async_isnonblocking; end

  def async_prepare(*_arg0); end

  # call-seq:
  #    conn.put_copy_data( buffer [, encoder] ) -> Boolean
  #
  # Transmits _buffer_ as copy data to the server.
  # Returns true if the data was sent, false if it was
  # not sent (false is only possible if the connection
  # is in nonblocking mode, and this command would block).
  #
  # _encoder_ can be a PG::Coder derivation (typically PG::TextEncoder::CopyRow).
  # This encodes the data fields given as _buffer_ from an Array of Strings to
  # PostgreSQL's COPY text format inclusive proper escaping. Optionally
  # the encoder can type cast the fields from various Ruby types in one step,
  # if PG::TextEncoder::CopyRow#type_map is set accordingly.
  #
  # Raises an exception if an error occurs.
  #
  # See also #copy_data.
  #
  # source://pg//lib/pg/connection.rb#431
  def async_put_copy_data(buffer, encoder = T.unsafe(nil)); end

  # call-seq:
  #    conn.put_copy_end( [ error_message ] ) -> Boolean
  #
  # Sends end-of-data indication to the server.
  #
  # _error_message_ is an optional parameter, and if set,
  # forces the COPY command to fail with the string
  # _error_message_.
  #
  # Returns true if the end-of-data was sent, #false* if it was
  # not sent (*false* is only possible if the connection
  # is in nonblocking mode, and this command would block).
  #
  # source://pg//lib/pg/connection.rb#461
  def async_put_copy_end(*args); end

  def async_query(*_arg0); end

  # call-seq:
  #   conn.reset()
  #
  # Resets the backend connection. This method closes the
  # backend connection and tries to re-connect.
  #
  # source://pg//lib/pg/connection.rb#503
  def async_reset; end

  def async_set_client_encoding(_arg0); end

  # call-seq:
  #    conn.setnonblocking(Boolean) -> nil
  #
  # Sets the nonblocking status of the connection.
  # In the blocking state, calls to #send_query
  # will block until the message is sent to the server,
  # but will not wait for the query results.
  # In the nonblocking state, calls to #send_query
  # will return an error if the socket is not ready for
  # writing.
  # Note: This function does not affect #exec, because
  # that function doesn't return until the server has
  # processed the query and returned the results.
  #
  # Returns +nil+.
  #
  # source://pg//lib/pg/connection.rb#393
  def async_setnonblocking(enabled); end

  def backend_key; end
  def backend_pid; end
  def block(*_arg0); end

  # call-seq:
  #    conn.cancel() -> String
  #
  # Requests cancellation of the command currently being
  # processed.
  #
  # Returns +nil+ on success, or a string containing the
  # error message if a failure occurs.
  #
  # source://pg//lib/pg/connection.rb#518
  def cancel; end

  def client_encoding=(_arg0); end
  def close; end

  # Returns an array of Hashes with connection defaults. See ::conndefaults
  # for details.
  #
  # source://pg//lib/pg/connection.rb#274
  def conndefaults; end

  # Returns a Hash with connection defaults. See ::conndefaults_hash
  # for details.
  #
  # source://pg//lib/pg/connection.rb#290
  def conndefaults_hash; end

  def connect_poll; end
  def connection_needs_password; end
  def connection_used_password; end
  def conninfo; end

  # Return the Postgres connection info structure as a Hash keyed by option
  # keyword (as a Symbol).
  #
  # See also #conninfo
  #
  # source://pg//lib/pg/connection.rb#298
  def conninfo_hash; end

  def consume_input; end

  # call-seq:
  #     conn.copy_data( sql [, coder] ) {|sql_result| ... } -> PG::Result
  #
  # Execute a copy process for transferring data to or from the server.
  #
  # This issues the SQL COPY command via #exec. The response to this
  # (if there is no error in the command) is a PG::Result object that
  # is passed to the block, bearing a status code of PGRES_COPY_OUT or
  # PGRES_COPY_IN (depending on the specified copy direction).
  # The application should then use #put_copy_data or #get_copy_data
  # to receive or transmit data rows and should return from the block
  # when finished.
  #
  # #copy_data returns another PG::Result object when the data transfer
  # is complete. An exception is raised if some problem was encountered,
  # so it isn't required to make use of any of them.
  # At this point further SQL commands can be issued via #exec.
  # (It is not possible to execute other SQL commands using the same
  # connection while the COPY operation is in progress.)
  #
  # This method ensures, that the copy process is properly terminated
  # in case of client side or server side failures. Therefore, in case
  # of blocking mode of operation, #copy_data is preferred to raw calls
  # of #put_copy_data, #get_copy_data and #put_copy_end.
  #
  # _coder_ can be a PG::Coder derivation
  # (typically PG::TextEncoder::CopyRow or PG::TextDecoder::CopyRow).
  # This enables encoding of data fields given to #put_copy_data
  # or decoding of fields received by #get_copy_data.
  #
  # Example with CSV input format:
  #   conn.exec "create table my_table (a text,b text,c text,d text)"
  #   conn.copy_data "COPY my_table FROM STDIN CSV" do
  #     conn.put_copy_data "some,data,to,copy\n"
  #     conn.put_copy_data "more,data,to,copy\n"
  #   end
  # This creates +my_table+ and inserts two CSV rows.
  #
  # The same with text format encoder PG::TextEncoder::CopyRow
  # and Array input:
  #   enco = PG::TextEncoder::CopyRow.new
  #   conn.copy_data "COPY my_table FROM STDIN", enco do
  #     conn.put_copy_data ['some', 'data', 'to', 'copy']
  #     conn.put_copy_data ['more', 'data', 'to', 'copy']
  #   end
  #
  # Example with CSV output format:
  #   conn.copy_data "COPY my_table TO STDOUT CSV" do
  #     while row=conn.get_copy_data
  #       p row
  #     end
  #   end
  # This prints all rows of +my_table+ to stdout:
  #   "some,data,to,copy\n"
  #   "more,data,to,copy\n"
  #
  # The same with text format decoder PG::TextDecoder::CopyRow
  # and Array output:
  #   deco = PG::TextDecoder::CopyRow.new
  #   conn.copy_data "COPY my_table TO STDOUT", deco do
  #     while row=conn.get_copy_data
  #       p row
  #     end
  #   end
  # This receives all rows of +my_table+ as ruby array:
  #   ["some", "data", "to", "copy"]
  #   ["more", "data", "to", "copy"]
  #
  # @raise [PG::NotInBlockingMode]
  #
  # source://pg//lib/pg/connection.rb#185
  def copy_data(sql, coder = T.unsafe(nil)); end

  def db; end
  def decoder_for_get_copy_data; end
  def decoder_for_get_copy_data=(_arg0); end
  def describe_portal(_arg0); end
  def describe_prepared(_arg0); end
  def discard_results; end
  def encoder_for_put_copy_data; end
  def encoder_for_put_copy_data=(_arg0); end

  # call-seq:
  #    conn.encrypt_password( password, username, algorithm=nil ) -> String
  #
  # This function is intended to be used by client applications that wish to send commands like <tt>ALTER USER joe PASSWORD 'pwd'</tt>.
  # It is good practice not to send the original cleartext password in such a command, because it might be exposed in command logs, activity displays, and so on.
  # Instead, use this function to convert the password to encrypted form before it is sent.
  #
  # The +password+ and +username+ arguments are the cleartext password, and the SQL name of the user it is for.
  # +algorithm+ specifies the encryption algorithm to use to encrypt the password.
  # Currently supported algorithms are +md5+ and +scram-sha-256+ (+on+ and +off+ are also accepted as aliases for +md5+, for compatibility with older server versions).
  # Note that support for +scram-sha-256+ was introduced in PostgreSQL version 10, and will not work correctly with older server versions.
  # If algorithm is omitted or +nil+, this function will query the server for the current value of the +password_encryption+ setting.
  # That can block, and will fail if the current transaction is aborted, or if the connection is busy executing another query.
  # If you wish to use the default algorithm for the server but want to avoid blocking, query +password_encryption+ yourself before calling #encrypt_password, and pass that value as the algorithm.
  #
  # Return value is the encrypted password.
  # The caller can assume the string doesn't contain any special characters that would require escaping.
  #
  # Available since PostgreSQL-10.
  # See also corresponding {libpq function}[https://www.postgresql.org/docs/current/libpq-misc.html#LIBPQ-PQENCRYPTPASSWORDCONN].
  #
  # source://pg//lib/pg/connection.rb#491
  def encrypt_password(password, username, algorithm = T.unsafe(nil)); end

  def error_message; end
  def escape(_arg0); end
  def escape_bytea(_arg0); end
  def escape_identifier(_arg0); end
  def escape_literal(_arg0); end
  def escape_string(_arg0); end
  def exec(*_arg0); end
  def exec_params(*_arg0); end
  def exec_prepared(*_arg0); end
  def external_encoding; end
  def field_name_type; end
  def field_name_type=(_arg0); end
  def finish; end
  def finished?; end
  def flush; end
  def get_client_encoding; end

  # call-seq:
  #    conn.get_copy_data( [ nonblock = false [, decoder = nil ]] ) -> Object
  #
  # Return one row of data, +nil+
  # if the copy is done, or +false+ if the call would
  # block (only possible if _nonblock_ is true).
  #
  # If _decoder_ is not set or +nil+, data is returned as binary string.
  #
  # If _decoder_ is set to a PG::Coder derivation, the return type depends on this decoder.
  # PG::TextDecoder::CopyRow decodes the received data fields from one row of PostgreSQL's
  # COPY text format to an Array of Strings.
  # Optionally the decoder can type cast the single fields to various Ruby types in one step,
  # if PG::TextDecoder::CopyRow#type_map is set accordingly.
  #
  # See also #copy_data.
  #
  # source://pg//lib/pg/connection.rb#359
  def get_copy_data(async = T.unsafe(nil), decoder = T.unsafe(nil)); end

  def get_last_result; end

  # call-seq:
  #    conn.get_result() -> PG::Result
  #    conn.get_result() {|pg_result| block }
  #
  # Blocks waiting for the next result from a call to
  # #send_query (or another asynchronous command), and returns
  # it. Returns +nil+ if no more results are available.
  #
  # Note: call this function repeatedly until it returns +nil+, or else
  # you will not be able to issue further commands.
  #
  # If the optional code block is given, it will be passed <i>result</i> as an argument,
  # and the PG::Result object will  automatically be cleared when the block terminates.
  # In this instance, <code>conn.exec</code> returns the value of the block.
  #
  # source://pg//lib/pg/connection.rb#336
  def get_result; end

  def host; end
  def hostaddr; end

  # Return a String representation of the object suitable for debugging.
  #
  # source://pg//lib/pg/connection.rb#97
  def inspect; end

  def internal_encoding; end
  def internal_encoding=(_arg0); end
  def is_busy; end

  # call-seq:
  #    conn.isnonblocking() -> Boolean
  #
  # Returns the blocking status of the database connection.
  # Returns +true+ if the connection is set to nonblocking mode and +false+ if blocking.
  #
  # source://pg//lib/pg/connection.rb#407
  def isnonblocking; end

  def lo_close(_arg0); end
  def lo_creat(*_arg0); end
  def lo_create(_arg0); end
  def lo_export(_arg0, _arg1); end
  def lo_import(_arg0); end
  def lo_lseek(_arg0, _arg1, _arg2); end
  def lo_open(*_arg0); end
  def lo_read(_arg0, _arg1); end
  def lo_seek(_arg0, _arg1, _arg2); end
  def lo_tell(_arg0); end
  def lo_truncate(_arg0, _arg1); end
  def lo_unlink(_arg0); end
  def lo_write(_arg0, _arg1); end
  def loclose(_arg0); end
  def locreat(*_arg0); end
  def locreate(_arg0); end
  def loexport(_arg0, _arg1); end
  def loimport(_arg0); end
  def lolseek(_arg0, _arg1, _arg2); end
  def loopen(*_arg0); end
  def loread(_arg0, _arg1); end
  def loseek(_arg0, _arg1, _arg2); end
  def lotell(_arg0); end
  def lotruncate(_arg0, _arg1); end
  def lounlink(_arg0); end
  def lowrite(_arg0, _arg1); end
  def make_empty_pgresult(_arg0); end

  # call-seq:
  #    conn.isnonblocking() -> Boolean
  #
  # Returns the blocking status of the database connection.
  # Returns +true+ if the connection is set to nonblocking mode and +false+ if blocking.
  #
  # source://pg//lib/pg/connection.rb#407
  def nonblocking?; end

  def notifies; end
  def notifies_wait(*_arg0); end
  def options; end
  def parameter_status(_arg0); end
  def pass; end
  def port; end
  def prepare(*_arg0); end
  def protocol_version; end

  # call-seq:
  #    conn.put_copy_data( buffer [, encoder] ) -> Boolean
  #
  # Transmits _buffer_ as copy data to the server.
  # Returns true if the data was sent, false if it was
  # not sent (false is only possible if the connection
  # is in nonblocking mode, and this command would block).
  #
  # _encoder_ can be a PG::Coder derivation (typically PG::TextEncoder::CopyRow).
  # This encodes the data fields given as _buffer_ from an Array of Strings to
  # PostgreSQL's COPY text format inclusive proper escaping. Optionally
  # the encoder can type cast the fields from various Ruby types in one step,
  # if PG::TextEncoder::CopyRow#type_map is set accordingly.
  #
  # Raises an exception if an error occurs.
  #
  # See also #copy_data.
  #
  # source://pg//lib/pg/connection.rb#431
  def put_copy_data(buffer, encoder = T.unsafe(nil)); end

  # call-seq:
  #    conn.put_copy_end( [ error_message ] ) -> Boolean
  #
  # Sends end-of-data indication to the server.
  #
  # _error_message_ is an optional parameter, and if set,
  # forces the COPY command to fail with the string
  # _error_message_.
  #
  # Returns true if the end-of-data was sent, #false* if it was
  # not sent (*false* is only possible if the connection
  # is in nonblocking mode, and this command would block).
  #
  # source://pg//lib/pg/connection.rb#461
  def put_copy_end(*args); end

  def query(*_arg0); end
  def quote_ident(_arg0); end

  # call-seq:
  #   conn.reset()
  #
  # Resets the backend connection. This method closes the
  # backend connection and tries to re-connect.
  #
  # source://pg//lib/pg/connection.rb#503
  def reset; end

  def reset_poll; end
  def reset_start; end
  def send_describe_portal(_arg0); end
  def send_describe_prepared(_arg0); end
  def send_prepare(*_arg0); end
  def send_query(*_arg0); end
  def send_query_params(*_arg0); end
  def send_query_prepared(*_arg0); end
  def server_version; end
  def set_client_encoding(_arg0); end
  def set_default_encoding; end
  def set_error_context_visibility(_arg0); end
  def set_error_verbosity(_arg0); end
  def set_notice_processor; end
  def set_notice_receiver; end
  def set_single_row_mode; end

  # call-seq:
  #    conn.setnonblocking(Boolean) -> nil
  #
  # Sets the nonblocking status of the connection.
  # In the blocking state, calls to #send_query
  # will block until the message is sent to the server,
  # but will not wait for the query results.
  # In the nonblocking state, calls to #send_query
  # will return an error if the socket is not ready for
  # writing.
  # Note: This function does not affect #exec, because
  # that function doesn't return until the server has
  # processed the query and returned the results.
  #
  # Returns +nil+.
  #
  # source://pg//lib/pg/connection.rb#393
  def setnonblocking(enabled); end

  def socket; end
  def socket_io; end
  def ssl_attribute(_arg0); end
  def ssl_attribute_names; end

  # call-seq:
  #   conn.ssl_attributes -> Hash<String,String>
  #
  # Returns SSL-related information about the connection as key/value pairs
  #
  # The available attributes varies depending on the SSL library being used,
  # and the type of connection.
  #
  # See also #ssl_attribute
  #
  # source://pg//lib/pg/connection.rb#315
  def ssl_attributes; end

  def ssl_in_use?; end
  def status; end
  def sync_cancel; end
  def sync_describe_portal(_arg0); end
  def sync_describe_prepared(_arg0); end
  def sync_encrypt_password(*_arg0); end
  def sync_exec(*_arg0); end
  def sync_exec_params(*_arg0); end
  def sync_exec_prepared(*_arg0); end
  def sync_flush; end
  def sync_get_copy_data(*_arg0); end
  def sync_get_last_result; end
  def sync_get_result; end
  def sync_isnonblocking; end
  def sync_prepare(*_arg0); end
  def sync_put_copy_data(*_arg0); end
  def sync_put_copy_end(*_arg0); end
  def sync_reset; end
  def sync_set_client_encoding(_arg0); end
  def sync_setnonblocking(_arg0); end
  def trace(_arg0); end

  # call-seq:
  #    conn.transaction { |conn| ... } -> result of the block
  #
  # Executes a +BEGIN+ at the start of the block,
  # and a +COMMIT+ at the end of the block, or
  # +ROLLBACK+ if any exception occurs.
  #
  # source://pg//lib/pg/connection.rb#258
  def transaction; end

  def transaction_status; end
  def tty; end
  def type_map_for_queries; end
  def type_map_for_queries=(_arg0); end
  def type_map_for_results; end
  def type_map_for_results=(_arg0); end
  def unescape_bytea(_arg0); end
  def untrace; end
  def user; end
  def wait_for_notify(*_arg0); end

  private

  # source://pg//lib/pg/connection.rb#573
  def async_connect_or_reset(poll_meth); end

  def flush_data=(_arg0); end

  class << self
    # Switch between sync and async libpq API.
    #
    #   PG::Connection.async_api = true
    # this is the default.
    # It sets an alias from #exec to #async_exec, #reset to #async_reset and so on.
    #
    #   PG::Connection.async_api = false
    # sets an alias from #exec to #sync_exec, #reset to #sync_reset and so on.
    #
    # pg-1.1.0+ defaults to libpq's async API for query related blocking methods.
    # pg-1.3.0+ defaults to libpq's async API for all possibly blocking methods.
    #
    # _PLEASE_ _NOTE_: This method is not part of the public API and is for debug and development use only.
    # Do not use this method in production code.
    # Any issues with the default setting of <tt>async_api=true</tt> should be reported to the maintainers instead.
    #
    # source://pg//lib/pg/connection.rb#864
    def async_api=(enable); end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def async_connect(*args); end

    # call-seq:
    #    PG::Connection.ping(connection_hash)       -> Integer
    #    PG::Connection.ping(connection_string)     -> Integer
    #    PG::Connection.ping(host, port, options, tty, dbname, login, password) ->  Integer
    #
    # Check server status.
    #
    # See PG::Connection.new for a description of the parameters.
    #
    # Returns one of:
    # [+PQPING_OK+]
    #   server is accepting connections
    # [+PQPING_REJECT+]
    #   server is alive but rejecting connections
    # [+PQPING_NO_RESPONSE+]
    #   could not establish connection
    # [+PQPING_NO_ATTEMPT+]
    #   connection not attempted (bad params)
    #
    # source://pg//lib/pg/connection.rb#789
    def async_ping(*args); end

    # source://pg//lib/pg/connection.rb#841
    def async_send_api=(enable); end

    def conndefaults; end

    # Return the Postgres connection defaults structure as a Hash keyed by option
    # keyword (as a Symbol).
    #
    # See also #conndefaults
    #
    # source://pg//lib/pg/connection.rb#282
    def conndefaults_hash; end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def connect(*args); end

    # Convert Hash options to connection String
    #
    # Values are properly quoted and escaped.
    #
    # source://pg//lib/pg/connection.rb#45
    def connect_hash_to_string(hash); end

    def connect_start(*_arg0); end
    def conninfo_parse(_arg0); end
    def encrypt_password(_arg0, _arg1); end
    def escape(_arg0); end
    def escape_bytea(_arg0); end
    def escape_string(_arg0); end
    def isthreadsafe; end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def new(*args); end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def open(*args); end

    # Parse the connection +args+ into a connection-parameter string.
    # See PG::Connection.new for valid arguments.
    #
    # It accepts:
    # * an option String kind of "host=name port=5432"
    # * an option Hash kind of {host: "name", port: 5432}
    # * URI string
    # * URI object
    # * positional arguments
    #
    # The method adds the option "fallback_application_name" if it isn't already set.
    # It returns a connection string with "key=value" pairs.
    #
    # source://pg//lib/pg/connection.rb#61
    def parse_connect_args(*args); end

    # call-seq:
    #    PG::Connection.ping(connection_hash)       -> Integer
    #    PG::Connection.ping(connection_string)     -> Integer
    #    PG::Connection.ping(host, port, options, tty, dbname, login, password) ->  Integer
    #
    # Check server status.
    #
    # See PG::Connection.new for a description of the parameters.
    #
    # Returns one of:
    # [+PQPING_OK+]
    #   server is accepting connections
    # [+PQPING_REJECT+]
    #   server is alive but rejecting connections
    # [+PQPING_NO_RESPONSE+]
    #   could not establish connection
    # [+PQPING_NO_ATTEMPT+]
    #   connection not attempted (bad params)
    #
    # source://pg//lib/pg/connection.rb#789
    def ping(*args); end

    # Quote a single +value+ for use in a connection-parameter string.
    #
    # source://pg//lib/pg/connection.rb#38
    def quote_connstr(value); end

    def quote_ident(_arg0); end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def setdb(*args); end

    # call-seq:
    #    PG::Connection.new -> conn
    #    PG::Connection.new(connection_hash) -> conn
    #    PG::Connection.new(connection_string) -> conn
    #    PG::Connection.new(host, port, options, tty, dbname, user, password) ->  conn
    #
    # Create a connection to the specified server.
    #
    # +connection_hash+ must be a ruby Hash with connection parameters.
    # See the {list of valid parameters}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS] in the PostgreSQL documentation.
    #
    # There are two accepted formats for +connection_string+: plain <code>keyword = value</code> strings and URIs.
    # See the documentation of {connection strings}[https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING].
    #
    # The positional parameter form has the same functionality except that the missing parameters will always take on default values. The parameters are:
    # [+host+]
    #   server hostname
    # [+port+]
    #   server port number
    # [+options+]
    #   backend options
    # [+tty+]
    #   (ignored in all versions of PostgreSQL)
    # [+dbname+]
    #   connecting database name
    # [+user+]
    #   login user name
    # [+password+]
    #   login password
    #
    # Examples:
    #
    #   # Connect using all defaults
    #   PG::Connection.new
    #
    #   # As a Hash
    #   PG::Connection.new( dbname: 'test', port: 5432 )
    #
    #   # As a String
    #   PG::Connection.new( "dbname=test port=5432" )
    #
    #   # As an Array
    #   PG::Connection.new( nil, 5432, nil, nil, 'test', nil, nil )
    #
    #   # As an URI
    #   PG::Connection.new( "postgresql://user:pass@pgsql.example.com:5432/testdb?sslmode=require" )
    #
    # If the Ruby default internal encoding is set (i.e., <code>Encoding.default_internal != nil</code>), the
    # connection will have its +client_encoding+ set accordingly.
    #
    # Raises a PG::Error if the connection fails.
    #
    # source://pg//lib/pg/connection.rb#694
    def setdblogin(*args); end

    def sync_connect(*_arg0); end
    def sync_ping(*_arg0); end
    def unescape_bytea(_arg0); end

    private

    # source://pg//lib/pg/connection.rb#712
    def connect_to_hosts(*args); end

    # source://pg//lib/pg/connection.rb#764
    def host_is_named_pipe?(host_string); end
  end
end

# The order the options are passed to the ::connect method.
#
# source://pg//lib/pg/connection.rb#34
PG::Connection::CONNECT_ARGUMENT_ORDER = T.let(T.unsafe(nil), Array)

class PG::ConnectionBad < ::PG::Error; end
class PG::ConnectionDoesNotExist < ::PG::ConnectionException; end
class PG::ConnectionException < ::PG::ServerError; end
class PG::ConnectionFailure < ::PG::ConnectionException; end
module PG::Constants; end
PG::Constants::CONNECTION_AUTH_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_AWAITING_RESPONSE = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_BAD = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_CHECK_TARGET = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_CHECK_WRITABLE = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_CONSUME = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_GSS_STARTUP = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_MADE = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_NEEDED = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_SETENV = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_SSL_STARTUP = T.let(T.unsafe(nil), Integer)
PG::Constants::CONNECTION_STARTED = T.let(T.unsafe(nil), Integer)
PG::Constants::DEF_PGPORT = T.let(T.unsafe(nil), Integer)
PG::Constants::INVALID_OID = T.let(T.unsafe(nil), Integer)
PG::Constants::INV_READ = T.let(T.unsafe(nil), Integer)
PG::Constants::INV_WRITE = T.let(T.unsafe(nil), Integer)
PG::Constants::InvalidOid = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_BAD_RESPONSE = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_COMMAND_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_COPY_BOTH = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_COPY_IN = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_COPY_OUT = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_EMPTY_QUERY = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_FATAL_ERROR = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_NONFATAL_ERROR = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_POLLING_FAILED = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_POLLING_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_POLLING_READING = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_POLLING_WRITING = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_SINGLE_TUPLE = T.let(T.unsafe(nil), Integer)
PG::Constants::PGRES_TUPLES_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_COLUMN_NAME = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_CONSTRAINT_NAME = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_CONTEXT = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_DATATYPE_NAME = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_INTERNAL_POSITION = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_INTERNAL_QUERY = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_MESSAGE_DETAIL = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_MESSAGE_HINT = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_MESSAGE_PRIMARY = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SCHEMA_NAME = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SEVERITY = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SEVERITY_NONLOCALIZED = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SOURCE_FILE = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SOURCE_FUNCTION = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SOURCE_LINE = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_SQLSTATE = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_STATEMENT_POSITION = T.let(T.unsafe(nil), Integer)
PG::Constants::PG_DIAG_TABLE_NAME = T.let(T.unsafe(nil), Integer)
PG::Constants::PQERRORS_DEFAULT = T.let(T.unsafe(nil), Integer)
PG::Constants::PQERRORS_SQLSTATE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQERRORS_TERSE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQERRORS_VERBOSE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQPING_NO_ATTEMPT = T.let(T.unsafe(nil), Integer)
PG::Constants::PQPING_NO_RESPONSE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQPING_OK = T.let(T.unsafe(nil), Integer)
PG::Constants::PQPING_REJECT = T.let(T.unsafe(nil), Integer)
PG::Constants::PQSHOW_CONTEXT_ALWAYS = T.let(T.unsafe(nil), Integer)
PG::Constants::PQSHOW_CONTEXT_ERRORS = T.let(T.unsafe(nil), Integer)
PG::Constants::PQSHOW_CONTEXT_NEVER = T.let(T.unsafe(nil), Integer)
PG::Constants::PQTRANS_ACTIVE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQTRANS_IDLE = T.let(T.unsafe(nil), Integer)
PG::Constants::PQTRANS_INERROR = T.let(T.unsafe(nil), Integer)
PG::Constants::PQTRANS_INTRANS = T.let(T.unsafe(nil), Integer)
PG::Constants::PQTRANS_UNKNOWN = T.let(T.unsafe(nil), Integer)
PG::Constants::SEEK_CUR = T.let(T.unsafe(nil), Integer)
PG::Constants::SEEK_END = T.let(T.unsafe(nil), Integer)
PG::Constants::SEEK_SET = T.let(T.unsafe(nil), Integer)

class PG::CopyCoder < ::PG::Coder
  def delimiter; end
  def delimiter=(_arg0); end
  def null_string; end
  def null_string=(_arg0); end

  # source://pg//lib/pg/coder.rb#88
  def to_h; end

  def type_map; end
  def type_map=(_arg0); end
end

class PG::CopyDecoder < ::PG::CopyCoder
  include ::PG::Coder::BinaryFormatting
end

class PG::CopyEncoder < ::PG::CopyCoder
  include ::PG::Coder::BinaryFormatting
end

class PG::CrashShutdown < ::PG::OperatorIntervention; end
class PG::DataCorrupted < ::PG::InternalError; end
class PG::DataException < ::PG::ServerError; end
class PG::DatabaseDropped < ::PG::OperatorIntervention; end
class PG::DatatypeMismatch < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DatetimeFieldOverflow < ::PG::DataException; end
class PG::DependentObjectsStillExist < ::PG::DependentPrivilegeDescriptorsStillExist; end
class PG::DependentPrivilegeDescriptorsStillExist < ::PG::ServerError; end
class PG::DiagnosticsException < ::PG::ServerError; end
class PG::DiskFull < ::PG::InsufficientResources; end
class PG::DivisionByZero < ::PG::DataException; end
class PG::DuplicateAlias < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateColumn < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateCursor < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateDatabase < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateFile < ::PG::SystemError; end
class PG::DuplicateFunction < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateJsonObjectKeyValue < ::PG::DataException; end
class PG::DuplicateObject < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicatePstatement < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateSchema < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::DuplicateTable < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::EREContainingSqlNotPermitted < ::PG::ExternalRoutineException; end
class PG::EREModifyingSqlDataNotPermitted < ::PG::ExternalRoutineException; end
class PG::EREProhibitedSqlStatementAttempted < ::PG::ExternalRoutineException; end
class PG::EREReadingSqlDataNotPermitted < ::PG::ExternalRoutineException; end
class PG::ERIEEventTriggerProtocolViolated < ::PG::ExternalRoutineInvocationException; end
class PG::ERIEInvalidSqlstateReturned < ::PG::ExternalRoutineInvocationException; end
class PG::ERIENullValueNotAllowed < ::PG::ExternalRoutineInvocationException; end
class PG::ERIESrfProtocolViolated < ::PG::ExternalRoutineInvocationException; end
class PG::ERIETriggerProtocolViolated < ::PG::ExternalRoutineInvocationException; end
PG::ERROR_CLASSES = T.let(T.unsafe(nil), Hash)

class PG::Error < ::StandardError
  # @return [Error] a new instance of Error
  #
  # source://pg//lib/pg/exceptions.rb#10
  def initialize(msg = T.unsafe(nil), connection: T.unsafe(nil), result: T.unsafe(nil)); end

  def connection; end
  def error; end
  def result; end
end

class PG::ErrorInAssignment < ::PG::DataException; end
class PG::EscapeCharacterConflict < ::PG::DataException; end
class PG::ExclusionViolation < ::PG::IntegrityConstraintViolation; end
class PG::ExternalRoutineException < ::PG::ServerError; end
class PG::ExternalRoutineInvocationException < ::PG::ServerError; end
class PG::FdwColumnNameNotFound < ::PG::FdwError; end
class PG::FdwDynamicParameterValueNeeded < ::PG::FdwError; end
class PG::FdwError < ::PG::ServerError; end
class PG::FdwFunctionSequenceError < ::PG::FdwError; end
class PG::FdwInconsistentDescriptorInformation < ::PG::FdwError; end
class PG::FdwInvalidAttributeValue < ::PG::FdwError; end
class PG::FdwInvalidColumnName < ::PG::FdwError; end
class PG::FdwInvalidColumnNumber < ::PG::FdwError; end
class PG::FdwInvalidDataType < ::PG::FdwError; end
class PG::FdwInvalidDataTypeDescriptors < ::PG::FdwError; end
class PG::FdwInvalidDescriptorFieldIdentifier < ::PG::FdwError; end
class PG::FdwInvalidHandle < ::PG::FdwError; end
class PG::FdwInvalidOptionIndex < ::PG::FdwError; end
class PG::FdwInvalidOptionName < ::PG::FdwError; end
class PG::FdwInvalidStringFormat < ::PG::FdwError; end
class PG::FdwInvalidStringLengthOrBufferLength < ::PG::FdwError; end
class PG::FdwInvalidUseOfNullPointer < ::PG::FdwError; end
class PG::FdwNoSchemas < ::PG::FdwError; end
class PG::FdwOptionNameNotFound < ::PG::FdwError; end
class PG::FdwOutOfMemory < ::PG::FdwError; end
class PG::FdwReplyHandle < ::PG::FdwError; end
class PG::FdwSchemaNotFound < ::PG::FdwError; end
class PG::FdwTableNotFound < ::PG::FdwError; end
class PG::FdwTooManyHandles < ::PG::FdwError; end
class PG::FdwUnableToCreateExecution < ::PG::FdwError; end
class PG::FdwUnableToCreateReply < ::PG::FdwError; end
class PG::FdwUnableToEstablishConnection < ::PG::FdwError; end
class PG::FeatureNotSupported < ::PG::ServerError; end
class PG::FloatingPointException < ::PG::DataException; end
class PG::ForeignKeyViolation < ::PG::IntegrityConstraintViolation; end
class PG::GeneratedAlways < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::GroupingError < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::HeldCursorRequiresSameIsolationLevel < ::PG::InvalidTransactionState; end
class PG::IdleInTransactionSessionTimeout < ::PG::InvalidTransactionState; end
class PG::IdleSessionTimeout < ::PG::OperatorIntervention; end
class PG::InFailedSqlTransaction < ::PG::InvalidTransactionState; end
class PG::InappropriateAccessModeForBranchTransaction < ::PG::InvalidTransactionState; end
class PG::InappropriateIsolationLevelForBranchTransaction < ::PG::InvalidTransactionState; end
class PG::IndeterminateCollation < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::IndeterminateDatatype < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::IndexCorrupted < ::PG::InternalError; end
class PG::IndicatorOverflow < ::PG::DataException; end
class PG::InsufficientPrivilege < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InsufficientResources < ::PG::ServerError; end
class PG::IntegrityConstraintViolation < ::PG::ServerError; end
class PG::InternalError < ::PG::ServerError; end
class PG::IntervalFieldOverflow < ::PG::DataException; end
class PG::InvalidArgumentForLog < ::PG::DataException; end
class PG::InvalidArgumentForNthValue < ::PG::DataException; end
class PG::InvalidArgumentForNtile < ::PG::DataException; end
class PG::InvalidArgumentForPowerFunction < ::PG::DataException; end
class PG::InvalidArgumentForSqlJsonDatetimeFunction < ::PG::DataException; end
class PG::InvalidArgumentForWidthBucketFunction < ::PG::DataException; end
class PG::InvalidAuthorizationSpecification < ::PG::ServerError; end
class PG::InvalidBinaryRepresentation < ::PG::DataException; end
class PG::InvalidCatalogName < ::PG::ServerError; end
class PG::InvalidChangeOfResultFields < ::PG::Error; end
class PG::InvalidCharacterValueForCast < ::PG::DataException; end
class PG::InvalidColumnDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidColumnReference < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidCursorDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidCursorName < ::PG::ServerError; end
class PG::InvalidCursorState < ::PG::ServerError; end
class PG::InvalidDatabaseDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidDatetimeFormat < ::PG::DataException; end
class PG::InvalidEscapeCharacter < ::PG::DataException; end
class PG::InvalidEscapeOctet < ::PG::DataException; end
class PG::InvalidEscapeSequence < ::PG::DataException; end
class PG::InvalidForeignKey < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidFunctionDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidGrantOperation < ::PG::InvalidGrantor; end
class PG::InvalidGrantor < ::PG::ServerError; end
class PG::InvalidIndicatorParameterValue < ::PG::DataException; end
class PG::InvalidJsonText < ::PG::DataException; end
class PG::InvalidName < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidObjectDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidParameterValue < ::PG::DataException; end
class PG::InvalidPassword < ::PG::InvalidAuthorizationSpecification; end
class PG::InvalidPrecedingOrFollowingSize < ::PG::DataException; end
class PG::InvalidPstatementDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidRecursion < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidRegularExpression < ::PG::DataException; end
class PG::InvalidResultStatus < ::PG::Error; end
class PG::InvalidRoleSpecification < ::PG::ServerError; end
class PG::InvalidRowCountInLimitClause < ::PG::DataException; end
class PG::InvalidRowCountInResultOffsetClause < ::PG::DataException; end
class PG::InvalidSchemaDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidSchemaName < ::PG::ServerError; end
class PG::InvalidSqlJsonSubscript < ::PG::DataException; end
class PG::InvalidSqlStatementName < ::PG::ServerError; end
class PG::InvalidTableDefinition < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::InvalidTablesampleArgument < ::PG::DataException; end
class PG::InvalidTablesampleRepeat < ::PG::DataException; end
class PG::InvalidTextRepresentation < ::PG::DataException; end
class PG::InvalidTimeZoneDisplacementValue < ::PG::DataException; end
class PG::InvalidTransactionInitiation < ::PG::ServerError; end
class PG::InvalidTransactionState < ::PG::ServerError; end
class PG::InvalidTransactionTermination < ::PG::ServerError; end
class PG::InvalidUseOfEscapeCharacter < ::PG::DataException; end
class PG::InvalidXmlComment < ::PG::DataException; end
class PG::InvalidXmlContent < ::PG::DataException; end
class PG::InvalidXmlDocument < ::PG::DataException; end
class PG::InvalidXmlProcessingInstruction < ::PG::DataException; end
class PG::IoError < ::PG::SystemError; end
class PG::LEInvalidSpecification < ::PG::LocatorException; end
class PG::LocatorException < ::PG::ServerError; end
class PG::LockFileExists < ::PG::ConfigFileError; end
class PG::LockNotAvailable < ::PG::ObjectNotInPrerequisiteState; end
class PG::MoreThanOneSqlJsonItem < ::PG::DataException; end
class PG::MostSpecificTypeMismatch < ::PG::DataException; end
class PG::NameTooLong < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::NoActiveSqlTransaction < ::PG::InvalidTransactionState; end
class PG::NoActiveSqlTransactionForBranchTransaction < ::PG::InvalidTransactionState; end
class PG::NoDataFound < ::PG::PlpgsqlError; end
class PG::NoResultError < ::PG::Error; end
class PG::NoSqlJsonItem < ::PG::DataException; end
class PG::NonNumericSqlJsonItem < ::PG::DataException; end
class PG::NonUniqueKeysInAJsonObject < ::PG::DataException; end
class PG::NonstandardUseOfEscapeCharacter < ::PG::DataException; end
class PG::NotAllCopyDataRetrieved < ::PG::Error; end
class PG::NotAnXmlDocument < ::PG::DataException; end
class PG::NotInBlockingMode < ::PG::Error; end
class PG::NotNullViolation < ::PG::IntegrityConstraintViolation; end
class PG::NullValueNoIndicatorParameter < ::PG::DataException; end
class PG::NullValueNotAllowed < ::PG::DataException; end
class PG::NumericValueOutOfRange < ::PG::DataException; end
class PG::ObjectInUse < ::PG::ObjectNotInPrerequisiteState; end
class PG::ObjectNotInPrerequisiteState < ::PG::ServerError; end
class PG::OperatorIntervention < ::PG::ServerError; end
class PG::OutOfMemory < ::PG::InsufficientResources; end

# source://pg//lib/pg/postgresql_lib_path.rb#2
PG::POSTGRESQL_LIB_PATH = T.let(T.unsafe(nil), String)

class PG::PlpgsqlError < ::PG::ServerError; end
class PG::ProgramLimitExceeded < ::PG::ServerError; end
class PG::ProtocolViolation < ::PG::ConnectionException; end
class PG::QueryCanceled < ::PG::OperatorIntervention; end
class PG::RaiseException < ::PG::PlpgsqlError; end
class PG::ReadOnlySqlTransaction < ::PG::InvalidTransactionState; end

class PG::RecordCoder < ::PG::Coder
  # source://pg//lib/pg/coder.rb#98
  def to_h; end

  def type_map; end
  def type_map=(_arg0); end
end

class PG::RecordDecoder < ::PG::RecordCoder; end
class PG::RecordEncoder < ::PG::RecordCoder; end
class PG::ReservedName < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::RestrictViolation < ::PG::IntegrityConstraintViolation; end

class PG::Result
  include ::Enumerable
  include ::PG::Constants

  def [](_arg0); end
  def autoclear?; end
  def check; end
  def check_result; end
  def clear; end
  def cleared?; end
  def cmd_status; end
  def cmd_tuples; end
  def cmdtuples; end
  def column_values(_arg0); end
  def each; end
  def each_row; end
  def error_field(_arg0); end
  def error_message; end
  def fformat(_arg0); end
  def field_name_type; end
  def field_name_type=(_arg0); end

  # Set the data type for all field name returning methods.
  #
  # +type+: a Symbol defining the field name type.
  #
  # This method is equal to #field_name_type= , but returns self, so that calls can be chained.
  #
  # source://pg//lib/pg/result.rb#26
  def field_names_as(type); end

  def field_values(_arg0); end
  def fields; end
  def fmod(_arg0); end
  def fname(_arg0); end
  def fnumber(_arg0); end
  def fsize(_arg0); end
  def ftable(_arg0); end
  def ftablecol(_arg0); end
  def ftype(_arg0); end
  def getisnull(_arg0, _arg1); end
  def getlength(_arg0, _arg1); end
  def getvalue(_arg0, _arg1); end

  # Return a String representation of the object suitable for debugging.
  #
  # source://pg//lib/pg/result.rb#32
  def inspect; end

  # Apply a type map for all value retrieving methods.
  #
  # +type_map+: a PG::TypeMap instance.
  #
  # This method is equal to #type_map= , but returns self, so that calls can be chained.
  #
  # See also PG::BasicTypeMapForResults
  #
  # source://pg//lib/pg/result.rb#16
  def map_types!(type_map); end

  def nfields; end
  def nparams; end
  def ntuples; end
  def num_fields; end
  def num_tuples; end
  def oid_value; end
  def paramtype(_arg0); end
  def res_status(_arg0); end
  def result_error_field(_arg0); end
  def result_error_message; end
  def result_status; end
  def result_verbose_error_message(_arg0, _arg1); end
  def stream_each; end
  def stream_each_row; end
  def stream_each_tuple; end
  def tuple(_arg0); end
  def tuple_values(_arg0); end
  def type_map; end
  def type_map=(_arg0); end
  def values; end
  def verbose_error_message(_arg0, _arg1); end
end

class PG::SEInvalidSpecification < ::PG::SavepointException; end
class PG::SREFunctionExecutedNoReturnStatement < ::PG::SqlRoutineException; end
class PG::SREModifyingSqlDataNotPermitted < ::PG::SqlRoutineException; end
class PG::SREProhibitedSqlStatementAttempted < ::PG::SqlRoutineException; end
class PG::SREReadingSqlDataNotPermitted < ::PG::SqlRoutineException; end
class PG::SavepointException < ::PG::ServerError; end
class PG::SchemaAndDataStatementMixingNotSupported < ::PG::InvalidTransactionState; end
class PG::SequenceGeneratorLimitExceeded < ::PG::DataException; end
class PG::ServerError < ::PG::Error; end
class PG::SimpleCoder < ::PG::Coder; end
class PG::SimpleDecoder < ::PG::SimpleCoder; end
class PG::SimpleEncoder < ::PG::SimpleCoder; end
class PG::SingletonSqlJsonItemRequired < ::PG::DataException; end
class PG::SnapshotTooOld < ::PG::ServerError; end
class PG::SqlJsonArrayNotFound < ::PG::DataException; end
class PG::SqlJsonItemCannotBeCastToTargetType < ::PG::DataException; end
class PG::SqlJsonMemberNotFound < ::PG::DataException; end
class PG::SqlJsonNumberNotFound < ::PG::DataException; end
class PG::SqlJsonObjectNotFound < ::PG::DataException; end
class PG::SqlJsonScalarRequired < ::PG::DataException; end
class PG::SqlRoutineException < ::PG::ServerError; end
class PG::SqlStatementNotYetComplete < ::PG::ServerError; end
class PG::SqlclientUnableToEstablishSqlconnection < ::PG::ConnectionException; end
class PG::SqlserverRejectedEstablishmentOfSqlconnection < ::PG::ConnectionException; end
class PG::StackedDiagnosticsAccessedWithoutActiveHandler < ::PG::DiagnosticsException; end
class PG::StatementTooComplex < ::PG::ProgramLimitExceeded; end
class PG::StringDataLengthMismatch < ::PG::DataException; end
class PG::StringDataRightTruncation < ::PG::DataException; end
class PG::SubstringError < ::PG::DataException; end
class PG::SyntaxError < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::SyntaxErrorOrAccessRuleViolation < ::PG::ServerError; end
class PG::SystemError < ::PG::ServerError; end
class PG::TRDeadlockDetected < ::PG::TransactionRollback; end
class PG::TRIntegrityConstraintViolation < ::PG::TransactionRollback; end
class PG::TRSerializationFailure < ::PG::TransactionRollback; end
class PG::TRStatementCompletionUnknown < ::PG::TransactionRollback; end
module PG::TextDecoder; end

class PG::TextDecoder::Array < ::PG::CompositeDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Array::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Boolean < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Boolean::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Bytea < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Bytea::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::CopyRow < ::PG::CopyDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::CopyRow::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Date < ::PG::SimpleDecoder
  # source://pg//lib/pg/text_decoder.rb#10
  def decode(string, tuple = T.unsafe(nil), field = T.unsafe(nil)); end
end

class PG::TextDecoder::Float < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Float::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::FromBase64 < ::PG::CompositeDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::FromBase64::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Identifier < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Identifier::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Inet < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Inet::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Integer < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Integer::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::JSON < ::PG::SimpleDecoder
  # source://pg//lib/pg/text_decoder.rb#20
  def decode(string, tuple = T.unsafe(nil), field = T.unsafe(nil)); end
end

class PG::TextDecoder::Numeric < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Numeric::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Record < ::PG::RecordDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Record::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::String < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::String::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::Timestamp < ::PG::SimpleDecoder
  def decode(*_arg0); end
end

PG::TextDecoder::Timestamp::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextDecoder::TimestampLocal < ::PG::TextDecoder::Timestamp
  # @return [TimestampLocal] a new instance of TimestampLocal
  #
  # source://pg//lib/pg/text_decoder.rb#37
  def initialize(params = T.unsafe(nil)); end
end

# Convenience classes for timezone options
class PG::TextDecoder::TimestampUtc < ::PG::TextDecoder::Timestamp
  # @return [TimestampUtc] a new instance of TimestampUtc
  #
  # source://pg//lib/pg/text_decoder.rb#27
  def initialize(params = T.unsafe(nil)); end
end

class PG::TextDecoder::TimestampUtcToLocal < ::PG::TextDecoder::Timestamp
  # @return [TimestampUtcToLocal] a new instance of TimestampUtcToLocal
  #
  # source://pg//lib/pg/text_decoder.rb#32
  def initialize(params = T.unsafe(nil)); end
end

# source://pg//lib/pg/text_decoder.rb#44
PG::TextDecoder::TimestampWithTimeZone = PG::TextDecoder::Timestamp

# For backward compatibility:
#
# source://pg//lib/pg/text_decoder.rb#43
PG::TextDecoder::TimestampWithoutTimeZone = PG::TextDecoder::TimestampLocal

module PG::TextEncoder; end

class PG::TextEncoder::Array < ::PG::CompositeEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Array::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Boolean < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Boolean::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Bytea < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Bytea::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::CopyRow < ::PG::CopyEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::CopyRow::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Date < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#10
  def encode(value); end
end

class PG::TextEncoder::Float < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Float::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Identifier < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Identifier::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Inet < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#40
  def encode(value); end
end

class PG::TextEncoder::Integer < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Integer::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::JSON < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#34
  def encode(value); end
end

class PG::TextEncoder::Numeric < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Numeric::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::QuotedLiteral < ::PG::CompositeEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::QuotedLiteral::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::Record < ::PG::RecordEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::Record::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::String < ::PG::SimpleEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::String::CFUNC = T.let(T.unsafe(nil), Object)

class PG::TextEncoder::TimestampUtc < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#22
  def encode(value); end
end

class PG::TextEncoder::TimestampWithTimeZone < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#28
  def encode(value); end
end

class PG::TextEncoder::TimestampWithoutTimeZone < ::PG::SimpleEncoder
  # source://pg//lib/pg/text_encoder.rb#16
  def encode(value); end
end

class PG::TextEncoder::ToBase64 < ::PG::CompositeEncoder
  def encode(*_arg0); end
end

PG::TextEncoder::ToBase64::CFUNC = T.let(T.unsafe(nil), Object)
class PG::TooManyArguments < ::PG::ProgramLimitExceeded; end
class PG::TooManyColumns < ::PG::ProgramLimitExceeded; end
class PG::TooManyConnections < ::PG::InsufficientResources; end
class PG::TooManyJsonArrayElements < ::PG::DataException; end
class PG::TooManyJsonObjectMembers < ::PG::DataException; end
class PG::TooManyRows < ::PG::PlpgsqlError; end
class PG::TransactionResolutionUnknown < ::PG::ConnectionException; end
class PG::TransactionRollback < ::PG::ServerError; end
class PG::TriggeredActionException < ::PG::ServerError; end
class PG::TriggeredDataChangeViolation < ::PG::ServerError; end
class PG::TrimError < ::PG::DataException; end

class PG::Tuple
  include ::Enumerable

  def [](_arg0); end
  def each; end

  # source://pg//lib/pg/tuple.rb#23
  def each_key(&block); end

  def each_value; end
  def fetch(*_arg0); end

  # @return [Boolean]
  #
  # source://pg//lib/pg/tuple.rb#14
  def has_key?(key); end

  def index(_arg0); end

  # Return a String representation of the object suitable for debugging.
  #
  # source://pg//lib/pg/tuple.rb#10
  def inspect; end

  # @return [Boolean]
  #
  # source://pg//lib/pg/tuple.rb#14
  def key?(key); end

  # source://pg//lib/pg/tuple.rb#19
  def keys; end

  def length; end
  def size; end
  def values; end

  private

  def field_map; end
  def field_names; end
  def marshal_dump; end
  def marshal_load(_arg0); end
end

class PG::TypeMap; end

module PG::TypeMap::DefaultTypeMappable
  def default_type_map; end
  def default_type_map=(_arg0); end
  def with_default_type_map(_arg0); end
end

class PG::TypeMapAllStrings < ::PG::TypeMap; end

class PG::TypeMapByClass < ::PG::TypeMap
  include ::PG::TypeMap::DefaultTypeMappable

  def [](_arg0); end
  def []=(_arg0, _arg1); end
  def coders; end
end

class PG::TypeMapByColumn < ::PG::TypeMap
  include ::PG::TypeMap::DefaultTypeMappable

  def initialize(_arg0); end

  def coders; end

  # source://pg//lib/pg/type_map_by_column.rb#12
  def inspect; end

  # Returns the type oids of the assigned coders.
  #
  # source://pg//lib/pg/type_map_by_column.rb#8
  def oids; end
end

class PG::TypeMapByMriType < ::PG::TypeMap
  include ::PG::TypeMap::DefaultTypeMappable

  def [](_arg0); end
  def []=(_arg0, _arg1); end
  def coders; end
end

class PG::TypeMapByOid < ::PG::TypeMap
  include ::PG::TypeMap::DefaultTypeMappable

  def add_coder(_arg0); end
  def build_column_map(_arg0); end
  def coders; end
  def max_rows_for_online_lookup; end
  def max_rows_for_online_lookup=(_arg0); end
  def rm_coder(_arg0, _arg1); end
end

class PG::TypeMapInRuby < ::PG::TypeMap
  include ::PG::TypeMap::DefaultTypeMappable

  def typecast_copy_get(_arg0, _arg1, _arg2, _arg3); end
  def typecast_query_param(_arg0, _arg1); end
  def typecast_result_value(_arg0, _arg1, _arg2); end
end

class PG::UnableToSend < ::PG::Error; end
class PG::UndefinedColumn < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::UndefinedFile < ::PG::SystemError; end
class PG::UndefinedFunction < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::UndefinedObject < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::UndefinedParameter < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::UndefinedTable < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::UniqueViolation < ::PG::IntegrityConstraintViolation; end
class PG::UnsafeNewEnumValueUsage < ::PG::ObjectNotInPrerequisiteState; end
class PG::UnterminatedCString < ::PG::DataException; end
class PG::UntranslatableCharacter < ::PG::DataException; end

# Library version
#
# source://pg//lib/pg/version.rb#3
PG::VERSION = T.let(T.unsafe(nil), String)

class PG::WindowingError < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::WithCheckOptionViolation < ::PG::ServerError; end
class PG::WrongObjectType < ::PG::SyntaxErrorOrAccessRuleViolation; end
class PG::ZeroLengthCharacterString < ::PG::DataException; end
