# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `nokogiri` gem.
# Please instead update this file by running `bin/tapioca gem nokogiri`.

# source://autoprefixer-rails/10.4.7.0/lib/autoprefixer-rails/processor.rb#7
::IS_SECTION = T.let(T.unsafe(nil), Regexp)

# source://ransack/3.2.1/lib/ransack/helpers/form_builder.rb#21
::RANSACK_FORM_BUILDER = T.let(T.unsafe(nil), String)

# source://yard/0.9.28/lib/yard.rb#61
::RUBY18 = T.let(T.unsafe(nil), FalseClass)

# source://yard/0.9.28/lib/yard.rb#62
::RUBY19 = T.let(T.unsafe(nil), TrueClass)

# Nokogiri parses and searches XML/HTML very quickly, and also has
# correctly implemented CSS3 selector support as well as XPath 1.0
# support.
#
# Parsing a document returns either a Nokogiri::XML::Document, or a
# Nokogiri::HTML4::Document depending on the kind of document you parse.
#
# Here is an example:
#
#     require 'nokogiri'
#     require 'open-uri'
#
#     # Get a Nokogiri::HTML4::Document for the page we’re interested in...
#
#     doc = Nokogiri::HTML4(URI.open('http://www.google.com/search?q=tenderlove'))
#
#     # Do funky things with it using Nokogiri::XML::Node methods...
#
#     ####
#     # Search for nodes by css
#     doc.css('h3.r a.l').each do |link|
#       puts link.content
#     end
#
# See also:
#
# - Nokogiri::XML::Searchable#css for more information about CSS searching
# - Nokogiri::XML::Searchable#xpath for more information about XPath searching
module Nokogiri
  class << self
    # source://nokogiri//lib/nokogiri/html4.rb#10
    def HTML(input, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # :call-seq:
    #   HTML4(input, url = nil, encoding = nil, options = XML::ParseOptions::DEFAULT_HTML, &block) → Nokogiri::HTML4::Document
    #
    # Parse HTML. Convenience method for Nokogiri::HTML4::Document.parse
    #
    # source://nokogiri//lib/nokogiri/html4.rb#10
    def HTML4(input, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # Since v1.12.0
    #
    # ⚠ HTML5 functionality is not available when running JRuby.
    #
    # Parse an HTML5 document. Convenience method for {Nokogiri::HTML5::Document.parse}
    #
    # source://nokogiri//lib/nokogiri/html5.rb#30
    def HTML5(input, url = T.unsafe(nil), encoding = T.unsafe(nil), **options, &block); end

    # Parse a document and add the Slop decorator.  The Slop decorator
    # implements method_missing such that methods may be used instead of CSS
    # or XPath.  For example:
    #
    #   doc = Nokogiri::Slop(<<-eohtml)
    #     <html>
    #       <body>
    #         <p>first</p>
    #         <p>second</p>
    #       </body>
    #     </html>
    #   eohtml
    #   assert_equal('second', doc.html.body.p[1].text)
    #
    # source://nokogiri//lib/nokogiri.rb#85
    def Slop(*args, &block); end

    # Parse XML.  Convenience method for Nokogiri::XML::Document.parse
    #
    # source://nokogiri//lib/nokogiri/xml.rb#7
    def XML(thing, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # Create a Nokogiri::XSLT::Stylesheet with +stylesheet+.
    #
    # Example:
    #
    #   xslt = Nokogiri::XSLT(File.read(ARGV[0]))
    #
    # source://nokogiri//lib/nokogiri/xslt.rb#13
    def XSLT(stylesheet, modules = T.unsafe(nil)); end

    # source://nokogiri//lib/nokogiri.rb#90
    def install_default_aliases; end

    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/version/info.rb#204
    def jruby?; end

    # source://nokogiri//lib/nokogiri/version/info.rb#209
    def libxml2_patches; end

    # Create a new Nokogiri::XML::DocumentFragment
    #
    # source://nokogiri//lib/nokogiri.rb#62
    def make(input = T.unsafe(nil), opts = T.unsafe(nil), &blk); end

    # Parse an HTML or XML document.  +string+ contains the document.
    #
    # source://nokogiri//lib/nokogiri.rb#44
    def parse(string, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/version/info.rb#199
    def uses_gumbo?; end

    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/version/info.rb#191
    def uses_libxml?(requirement = T.unsafe(nil)); end
  end
end

# Translate a CSS selector into an XPath 1.0 query
module Nokogiri::CSS
  class << self
    # TODO: Deprecate this method ahead of 2.0 and delete it in 2.0.
    # It is not used by Nokogiri and shouldn't be part of the public API.
    #
    # source://nokogiri//lib/nokogiri/css.rb#10
    def parse(selector); end

    # :call-seq:
    #   xpath_for(selector) → String
    #   xpath_for(selector [, prefix:] [, visitor:] [, ns:]) → String
    #
    # Translate a CSS selector to the equivalent XPath query.
    #
    # [Parameters]
    # - +selector+ (String) The CSS selector to be translated into XPath
    #
    # - +prefix:+ (String)
    #
    #   The XPath prefix for the query, see Nokogiri::XML::XPath for some options. Default is
    #   +XML::XPath::GLOBAL_SEARCH_PREFIX+.
    #
    # - +visitor:+ (Nokogiri::CSS::XPathVisitor)
    #
    #   The visitor class to use to transform the AST into XPath. Default is
    #   +Nokogiri::CSS::XPathVisitor.new+.
    #
    # - +ns:+ (Hash<String ⇒ String>)
    #
    #   The namespaces that are referenced in the query, if any. This is a hash where the keys are
    #   the namespace prefix and the values are the namespace URIs. Default is an empty Hash.
    #
    # [Returns] (String) The equivalent XPath query for +selector+
    #
    # 💡 Note that translated queries are cached for performance concerns.
    #
    # source://nokogiri//lib/nokogiri/css.rb#42
    def xpath_for(selector, options = T.unsafe(nil)); end
  end
end

class Nokogiri::CSS::Node
  # Create a new Node with +type+ and +value+
  #
  # @return [Node] a new instance of Node
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#14
  def initialize(type, value); end

  # Accept +visitor+
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#20
  def accept(visitor); end

  # Find a node by type using +types+
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#32
  def find_by_type(types); end

  # Convert to array
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#49
  def to_a; end

  # Convert to_type
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#42
  def to_type; end

  # Convert this CSS node to xpath with +prefix+ using +visitor+
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#26
  def to_xpath(prefix, visitor); end

  # Get the type of this node
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#9
  def type; end

  # Get the type of this node
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#9
  def type=(_arg0); end

  # Get the value of this node
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#11
  def value; end

  # Get the value of this node
  #
  # source://nokogiri//lib/nokogiri/css/node.rb#11
  def value=(_arg0); end
end

# source://nokogiri//lib/nokogiri/css/node.rb#6
Nokogiri::CSS::Node::ALLOW_COMBINATOR_ON_SELF = T.let(T.unsafe(nil), Array)

class Nokogiri::CSS::Parser < ::Racc::Parser
  # Create a new CSS parser with respect to +namespaces+
  #
  # @return [Parser] a new instance of Parser
  #
  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#60
  def initialize(namespaces = T.unsafe(nil)); end

  # reduce 0 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#361
  def _reduce_1(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#407
  def _reduce_10(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#412
  def _reduce_11(val, _values, result); end

  # reduce 12 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#424
  def _reduce_13(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#429
  def _reduce_14(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#434
  def _reduce_15(val, _values, result); end

  # reduce 16 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#441
  def _reduce_17(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#446
  def _reduce_18(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#451
  def _reduce_19(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#367
  def _reduce_2(val, _values, result); end

  # reduce 20 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#458
  def _reduce_21(val, _values, result); end

  # reduce 22 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#465
  def _reduce_23(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#470
  def _reduce_24(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#475
  def _reduce_25(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#482
  def _reduce_26(val, _values, result); end

  # reduce 27 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#489
  def _reduce_28(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#495
  def _reduce_29(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#372
  def _reduce_3(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#501
  def _reduce_30(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#507
  def _reduce_31(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#512
  def _reduce_32(val, _values, result); end

  # reduce 33 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#519
  def _reduce_34(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#525
  def _reduce_35(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#531
  def _reduce_36(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#537
  def _reduce_37(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#543
  def _reduce_38(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#549
  def _reduce_39(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#377
  def _reduce_4(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#554
  def _reduce_40(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#559
  def _reduce_41(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#564
  def _reduce_42(val, _values, result); end

  # reduce 44 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#573
  def _reduce_45(val, _values, result); end

  # reduce 46 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#590
  def _reduce_47(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#600
  def _reduce_48(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#616
  def _reduce_49(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#382
  def _reduce_5(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#636
  def _reduce_50(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#642
  def _reduce_51(val, _values, result); end

  # reduce 53 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#651
  def _reduce_54(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#657
  def _reduce_55(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#663
  def _reduce_56(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#669
  def _reduce_57(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#675
  def _reduce_58(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#387
  def _reduce_6(val, _values, result); end

  # reduce 63 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#691
  def _reduce_64(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#696
  def _reduce_65(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#701
  def _reduce_66(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#706
  def _reduce_67(val, _values, result); end

  # reduce 68 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#713
  def _reduce_69(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#392
  def _reduce_7(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#718
  def _reduce_70(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#723
  def _reduce_71(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#728
  def _reduce_72(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#733
  def _reduce_73(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#738
  def _reduce_74(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#743
  def _reduce_75(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#748
  def _reduce_76(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#397
  def _reduce_8(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#402
  def _reduce_9(val, _values, result); end

  # reduce 81 omitted
  #
  # source://nokogiri//lib/nokogiri/css/parser.rb#764
  def _reduce_none(val, _values, result); end

  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#89
  def cache_key(query, prefix, visitor); end

  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#71
  def next_token; end

  # On CSS parser error, raise an exception
  #
  # @raise [SyntaxError]
  #
  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#84
  def on_error(error_token_id, error_value, value_stack); end

  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#66
  def parse(string); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#26
  def unescape_css_identifier(identifier); end

  # source://nokogiri//lib/nokogiri/css/parser.rb#30
  def unescape_css_string(str); end

  # Get the xpath for +string+ using +options+
  #
  # source://nokogiri//lib/nokogiri/css/parser_extras.rb#76
  def xpath_for(string, prefix, visitor); end

  class << self
    # Get the css selector in +string+ from the cache
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#25
    def [](string); end

    # Set the css selector in +string+ in the cache to +value+
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#32
    def []=(string, value); end

    # Return a thread-local boolean indicating whether the CSS-to-XPath cache is active. (Default is `true`.)
    #
    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#15
    def cache_on?; end

    # Clear the cache
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#39
    def clear_cache(create_new_object = T.unsafe(nil)); end

    # Set a thread-local boolean to turn cacheing on and off. Truthy values turn the cache on, falsey values turn the cache off.
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#20
    def set_cache(value); end

    # Execute +block+ without cache
    #
    # source://nokogiri//lib/nokogiri/css/parser_extras.rb#50
    def without_cache(&block); end
  end
end

# source://nokogiri//lib/nokogiri/css/parser_extras.rb#8
Nokogiri::CSS::Parser::CACHE_SWITCH_NAME = T.let(T.unsafe(nil), Symbol)

# source://nokogiri//lib/nokogiri/css/parser.rb#279
Nokogiri::CSS::Parser::Racc_arg = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/css/parser.rb#355
Nokogiri::CSS::Parser::Racc_debug_parser = T.let(T.unsafe(nil), FalseClass)

# source://nokogiri//lib/nokogiri/css/parser.rb#295
Nokogiri::CSS::Parser::Racc_token_to_s_table = T.let(T.unsafe(nil), Array)

class Nokogiri::CSS::SyntaxError < ::Nokogiri::SyntaxError; end

class Nokogiri::CSS::Tokenizer
  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#57
  def _next_token; end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#26
  def action; end

  # Returns the value of attribute filename.
  #
  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#17
  def filename; end

  # Returns the value of attribute lineno.
  #
  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#16
  def lineno; end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#36
  def load_file(filename); end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#49
  def next_token; end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#30
  def scan(str); end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#43
  def scan_file(filename); end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#20
  def scan_setup(str); end

  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#30
  def scan_str(str); end

  # Returns the value of attribute state.
  #
  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#18
  def state; end

  # Sets the attribute state
  #
  # @param value the value to set the attribute state to.
  #
  # source://nokogiri//lib/nokogiri/css/tokenizer.rb#18
  def state=(_arg0); end
end

class Nokogiri::CSS::Tokenizer::ScanError < ::StandardError; end

# When translating CSS selectors to XPath queries with Nokogiri::CSS.xpath_for, the XPathVisitor
# class allows for changing some of the behaviors related to builtin xpath functions and quirks
# of HTML5.
class Nokogiri::CSS::XPathVisitor
  # :call-seq:
  #   new() → XPathVisitor
  #   new(builtins:, doctype:) → XPathVisitor
  #
  # [Parameters]
  # - +builtins:+ (BuiltinsConfig) Determine when to use Nokogiri's built-in xpath functions for performance improvements.
  # - +doctype:+ (DoctypeConfig) Make document-type-specific accommodations for CSS queries.
  #
  # [Returns] XPathVisitor
  #
  # @return [XPathVisitor] a new instance of XPathVisitor
  #
  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#57
  def initialize(builtins: T.unsafe(nil), doctype: T.unsafe(nil)); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#267
  def accept(node); end

  # :call-seq: config() → Hash
  #
  # [Returns]
  #   a Hash representing the configuration of the XPathVisitor, suitable for use as
  #   part of the CSS cache key.
  #
  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#74
  def config; end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#263
  def visit_attrib_name(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#154
  def visit_attribute_condition(node); end

  def visit_child_selector(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#215
  def visit_class_condition(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#219
  def visit_combinator(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#240
  def visit_conditional_selector(node); end

  def visit_descendant_selector(node); end
  def visit_direct_adjacent_selector(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#245
  def visit_element_name(node); end

  def visit_following_selector(node); end

  # :stopdoc:
  #
  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#79
  def visit_function(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#149
  def visit_id(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#140
  def visit_not(node); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#190
  def visit_pseudo_class(node); end

  private

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#326
  def css_class(hay, needle); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#273
  def html5_element_name_needs_namespace_handling(node); end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#316
  def is_of_type_pseudo_class?(node); end

  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#280
  def nth(node, options = T.unsafe(nil)); end

  # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#302
  def read_a_and_positive_b(values); end
end

# Enum to direct XPathVisitor when to use Nokogiri builtin XPath functions.
module Nokogiri::CSS::XPathVisitor::BuiltinsConfig; end

# Always use Nokogiri builtin functions whenever possible. This is probably only useful for testing.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#19
Nokogiri::CSS::XPathVisitor::BuiltinsConfig::ALWAYS = T.let(T.unsafe(nil), Symbol)

# Never use Nokogiri builtin functions, always generate vanilla XPath 1.0 queries. This is
# the default when calling Nokogiri::CSS.xpath_for directly.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#16
Nokogiri::CSS::XPathVisitor::BuiltinsConfig::NEVER = T.let(T.unsafe(nil), Symbol)

# Only use Nokogiri builtin functions when they will be faster than vanilla XPath. This is
# the behavior chosen when searching for CSS selectors on a Nokogiri document, fragment, or
# node.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#24
Nokogiri::CSS::XPathVisitor::BuiltinsConfig::OPTIMAL = T.let(T.unsafe(nil), Symbol)

# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#27
Nokogiri::CSS::XPathVisitor::BuiltinsConfig::VALUES = T.let(T.unsafe(nil), Array)

# Enum to direct XPathVisitor when to tweak the XPath query to suit the nature of the document
# being searched. Note that searches for CSS selectors from a Nokogiri document, fragment, or
# node will choose the correct option automatically.
module Nokogiri::CSS::XPathVisitor::DoctypeConfig; end

# The document being searched is an HTML4 document.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#38
Nokogiri::CSS::XPathVisitor::DoctypeConfig::HTML4 = T.let(T.unsafe(nil), Symbol)

# The document being searched is an HTML5 document.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#41
Nokogiri::CSS::XPathVisitor::DoctypeConfig::HTML5 = T.let(T.unsafe(nil), Symbol)

# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#44
Nokogiri::CSS::XPathVisitor::DoctypeConfig::VALUES = T.let(T.unsafe(nil), Array)

# The document being searched is an XML document. This is the default.
#
# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#35
Nokogiri::CSS::XPathVisitor::DoctypeConfig::XML = T.let(T.unsafe(nil), Symbol)

# source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#10
Nokogiri::CSS::XPathVisitor::WILDCARD_NAMESPACES = T.let(T.unsafe(nil), TrueClass)

module Nokogiri::CSS::XPathVisitorAlwaysUseBuiltins
  class << self
    # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#338
    def new; end
  end
end

module Nokogiri::CSS::XPathVisitorOptimallyUseBuiltins
  class << self
    # source://nokogiri//lib/nokogiri/css/xpath_visitor.rb#348
    def new; end
  end
end

# Some classes in Nokogiri are namespaced as a group, for example
# Document, DocumentFragment, and Builder.
#
# It's sometimes necessary to look up the related class, e.g.:
#
#   XML::Builder → XML::Document
#   HTML4::Builder → HTML4::Document
#   HTML5::Document → HTML5::DocumentFragment
#
# This module is included into those key classes who need to do this.
module Nokogiri::ClassResolver
  # :call-seq:
  #   related_class(class_name) → Class
  #
  # Find a class constant within the
  #
  # Some examples:
  #
  #   Nokogiri::XML::Document.new.related_class("DocumentFragment")
  #   # => Nokogiri::XML::DocumentFragment
  #   Nokogiri::HTML4::Document.new.related_class("DocumentFragment")
  #   # => Nokogiri::HTML4::DocumentFragment
  #
  # Note this will also work for subclasses that follow the same convention, e.g.:
  #
  #   Loofah::HTML::Document.new.related_class("DocumentFragment")
  #   # => Loofah::HTML::DocumentFragment
  #
  # And even if it's a subclass, this will iterate through the superclasses:
  #
  #   class ThisIsATopLevelClass < Nokogiri::HTML4::Builder ; end
  #   ThisIsATopLevelClass.new.related_class("Document")
  #   # => Nokogiri::HTML4::Document
  #
  # source://nokogiri//lib/nokogiri/class_resolver.rb#46
  def related_class(class_name); end
end

# #related_class restricts matching namespaces to those matching this set.
#
# source://nokogiri//lib/nokogiri/class_resolver.rb#21
Nokogiri::ClassResolver::VALID_NAMESPACES = T.let(T.unsafe(nil), Set)

module Nokogiri::Decorators; end

# The Slop decorator implements method missing such that a methods may be
# used instead of XPath or CSS.  See Nokogiri.Slop
module Nokogiri::Decorators::Slop
  # look for node with +name+.  See Nokogiri.Slop
  #
  # source://nokogiri//lib/nokogiri/decorators/slop.rb#14
  def method_missing(name, *args, &block); end

  private

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/decorators/slop.rb#37
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# The default XPath search context for Slop
#
# source://nokogiri//lib/nokogiri/decorators/slop.rb#10
Nokogiri::Decorators::Slop::XPATH_PREFIX = T.let(T.unsafe(nil), String)

class Nokogiri::EncodingHandler
  def name; end

  class << self
    def [](_arg0); end
    def alias(_arg0, _arg1); end
    def clear_aliases!; end
    def delete(_arg0); end
  end
end

module Nokogiri::Gumbo
  class << self
    def fragment(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5); end
    def parse(_arg0, _arg1, _arg2, _arg3, _arg4); end
  end
end

# The default maximum number of attributes per element.
#
# source://nokogiri//lib/nokogiri/gumbo.rb#6
Nokogiri::Gumbo::DEFAULT_MAX_ATTRIBUTES = T.let(T.unsafe(nil), Integer)

# The default maximum number of errors for parsing a document or a fragment.
#
# source://nokogiri//lib/nokogiri/gumbo.rb#9
Nokogiri::Gumbo::DEFAULT_MAX_ERRORS = T.let(T.unsafe(nil), Integer)

# The default maximum depth of the DOM tree produced by parsing a document
# or fragment.
#
# source://nokogiri//lib/nokogiri/gumbo.rb#13
Nokogiri::Gumbo::DEFAULT_MAX_TREE_DEPTH = T.let(T.unsafe(nil), Integer)

# 💡 This module/namespace is an alias for Nokogiri::HTML4 as of v1.12.0. Before v1.12.0,
#   Nokogiri::HTML4 did not exist, and this was the module/namespace for all HTML-related
#   classes.
#
# source://nokogiri//lib/nokogiri/html.rb#8
Nokogiri::HTML = Nokogiri::HTML4

# Since v1.12.0
#
# 💡 Before v1.12.0, Nokogiri::HTML4 did not exist, and Nokogiri::HTML was the module/namespace
# for parsing HTML.
module Nokogiri::HTML4
  class << self
    # Parse a fragment from +string+ in to a NodeSet.
    #
    # source://nokogiri//lib/nokogiri/html4.rb#29
    def fragment(string, encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # Parse HTML. Convenience method for Nokogiri::HTML4::Document.parse
    #
    # source://nokogiri//lib/nokogiri/html4.rb#23
    def parse(input, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end
  end
end

# Nokogiri HTML builder is used for building HTML documents.  It is very
# similar to the Nokogiri::XML::Builder.  In fact, you should go read the
# documentation for Nokogiri::XML::Builder before reading this
# documentation.
#
# == Synopsis:
#
# Create an HTML document with a body that has an onload attribute, and a
# span tag with a class of "bold" that has content of "Hello world".
#
#   builder = Nokogiri::HTML4::Builder.new do |doc|
#     doc.html {
#       doc.body(:onload => 'some_func();') {
#         doc.span.bold {
#           doc.text "Hello world"
#         }
#       }
#     }
#   end
#   puts builder.to_html
#
# The HTML builder inherits from the XML builder, so make sure to read the
# Nokogiri::XML::Builder documentation.
class Nokogiri::HTML4::Builder < ::Nokogiri::XML::Builder
  # Convert the builder to HTML
  #
  # source://nokogiri//lib/nokogiri/html4/builder.rb#32
  def to_html; end
end

class Nokogiri::HTML4::Document < ::Nokogiri::XML::Document
  # Create a Nokogiri::XML::DocumentFragment from +tags+
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#149
  def fragment(tags = T.unsafe(nil)); end

  # Get the meta tag encoding for this document.  If there is no meta tag,
  # then nil is returned.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#12
  def meta_encoding; end

  # Set the meta tag encoding for this document.
  #
  # If an meta encoding tag is already present, its content is
  # replaced with the given text.
  #
  # Otherwise, this method tries to create one at an appropriate
  # place supplying head and/or html elements as necessary, which
  # is inside a head element if any, and before any text node or
  # content element (typically <body>) if any.
  #
  # The result when trying to set an encoding that is different
  # from the document encoding is undefined.
  #
  # Beware in CRuby, that libxml2 automatically inserts a meta tag
  # into a head element.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#36
  def meta_encoding=(encoding); end

  # Serialize Node using +options+. Save options can also be set using a block.
  #
  # See also Nokogiri::XML::Node::SaveOptions and Node@Serialization+and+Generating+Output.
  #
  # These two statements are equivalent:
  #
  #  node.serialize(:encoding => 'UTF-8', :save_with => FORMAT | AS_XML)
  #
  # or
  #
  #   node.serialize(:encoding => 'UTF-8') do |config|
  #     config.format.as_xml
  #   end
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#142
  def serialize(options = T.unsafe(nil)); end

  # Get the title string of this document.  Return nil if there is
  # no title tag.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#70
  def title; end

  # Set the title string of this document.
  #
  # If a title element is already present, its content is replaced
  # with the given text.
  #
  # Otherwise, this method tries to create one at an appropriate
  # place supplying head and/or html elements as necessary, which
  # is inside a head element if any, right after a meta
  # encoding/charset tag if any, and before any text node or
  # content element (typically <body>) if any.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#85
  def title=(text); end

  def type; end

  # :call-seq:
  #   xpath_doctype() → Nokogiri::CSS::XPathVisitor::DoctypeConfig
  #
  # [Returns] The document type which determines CSS-to-XPath translation.
  #
  # See XPathVisitor for more information.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#159
  def xpath_doctype; end

  private

  # source://nokogiri//lib/nokogiri/html4/document.rb#60
  def meta_content_type; end

  # source://nokogiri//lib/nokogiri/html4/document.rb#103
  def set_metadata_element(element); end

  class << self
    def new(*_arg0); end

    # Parse HTML.  +string_or_io+ may be a String, or any object that
    # responds to _read_ and _close_ such as an IO, or StringIO.
    # +url+ is resource where this document is located.  +encoding+ is the
    # encoding that should be used when processing the document. +options+
    # is a number that sets options in the parser, such as
    # Nokogiri::XML::ParseOptions::RECOVER.  See the constants in
    # Nokogiri::XML::ParseOptions.
    #
    # @yield [options]
    #
    # source://nokogiri//lib/nokogiri/html4/document.rb#172
    def parse(string_or_io, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil)); end

    def read_io(_arg0, _arg1, _arg2, _arg3); end
    def read_memory(_arg0, _arg1, _arg2, _arg3); end
  end
end

class Nokogiri::HTML4::Document::EncodingFound < ::StandardError
  # @return [EncodingFound] a new instance of EncodingFound
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#227
  def initialize(encoding); end

  # Returns the value of attribute found_encoding.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#225
  def found_encoding; end
end

class Nokogiri::HTML4::Document::EncodingReader
  # @return [EncodingReader] a new instance of EncodingReader
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#293
  def initialize(io); end

  # This method is used by the C extension so that
  # Nokogiri::HTML4::Document#read_io() does not leak memory when
  # EncodingFound is raised.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#302
  def encoding_found; end

  # source://nokogiri//lib/nokogiri/html4/document.rb#304
  def read(len); end

  class << self
    # source://nokogiri//lib/nokogiri/html4/document.rb#270
    def detect_encoding(chunk); end
  end
end

class Nokogiri::HTML4::Document::EncodingReader::JumpSAXHandler < ::Nokogiri::HTML4::Document::EncodingReader::SAXHandler
  # @return [JumpSAXHandler] a new instance of JumpSAXHandler
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#258
  def initialize(jumptag); end

  # source://nokogiri//lib/nokogiri/html4/document.rb#263
  def start_element(name, attrs = T.unsafe(nil)); end
end

class Nokogiri::HTML4::Document::EncodingReader::SAXHandler < ::Nokogiri::XML::SAX::Document
  # @return [SAXHandler] a new instance of SAXHandler
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#238
  def initialize; end

  # Returns the value of attribute encoding.
  #
  # source://nokogiri//lib/nokogiri/html4/document.rb#236
  def encoding; end

  # source://nokogiri//lib/nokogiri/html4/document.rb#243
  def start_element(name, attrs = T.unsafe(nil)); end
end

class Nokogiri::HTML4::DocumentFragment < ::Nokogiri::XML::DocumentFragment
  # @return [DocumentFragment] a new instance of DocumentFragment
  # @yield [options]
  #
  # source://nokogiri//lib/nokogiri/html4/document_fragment.rb#27
  def initialize(document, tags = T.unsafe(nil), ctx = T.unsafe(nil), options = T.unsafe(nil)); end

  class << self
    # Create a Nokogiri::XML::DocumentFragment from +tags+, using +encoding+
    #
    # source://nokogiri//lib/nokogiri/html4/document_fragment.rb#8
    def parse(tags, encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end
  end
end

class Nokogiri::HTML4::ElementDescription
  # Is this element a block element?
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/html4/element_description.rb#8
  def block?; end

  def default_sub_element; end

  # @return [Boolean]
  def deprecated?; end

  def deprecated_attributes; end
  def description; end
  def empty?; end

  # @return [Boolean]
  def implied_end_tag?; end

  # @return [Boolean]
  def implied_start_tag?; end

  def inline?; end

  # Inspection information
  #
  # source://nokogiri//lib/nokogiri/html4/element_description.rb#20
  def inspect; end

  def name; end
  def optional_attributes; end
  def required_attributes; end

  # @return [Boolean]
  def save_end_tag?; end

  def sub_elements; end

  # Convert this description to a string
  #
  # source://nokogiri//lib/nokogiri/html4/element_description.rb#14
  def to_s; end

  private

  # source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#21
  def default_desc; end

  class << self
    def [](_arg0); end
  end
end

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#239
Nokogiri::HTML4::ElementDescription::ACTION_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#234
Nokogiri::HTML4::ElementDescription::ALIGN_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#173
Nokogiri::HTML4::ElementDescription::ALT_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#180
Nokogiri::HTML4::ElementDescription::APPLET_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#183
Nokogiri::HTML4::ElementDescription::AREA_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#159
Nokogiri::HTML4::ElementDescription::ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#168
Nokogiri::HTML4::ElementDescription::A_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#185
Nokogiri::HTML4::ElementDescription::BASEFONT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#278
Nokogiri::HTML4::ElementDescription::BGCOLOR_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#141
Nokogiri::HTML4::ElementDescription::BLOCK = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#240
Nokogiri::HTML4::ElementDescription::BLOCKLI_ELT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#188
Nokogiri::HTML4::ElementDescription::BODY_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#187
Nokogiri::HTML4::ElementDescription::BODY_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#189
Nokogiri::HTML4::ElementDescription::BODY_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#191
Nokogiri::HTML4::ElementDescription::BUTTON_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#160
Nokogiri::HTML4::ElementDescription::CELLHALIGN = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#161
Nokogiri::HTML4::ElementDescription::CELLVALIGN = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#176
Nokogiri::HTML4::ElementDescription::CLEAR_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#194
Nokogiri::HTML4::ElementDescription::COL_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#195
Nokogiri::HTML4::ElementDescription::COL_ELT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#199
Nokogiri::HTML4::ElementDescription::COMPACT_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#197
Nokogiri::HTML4::ElementDescription::COMPACT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#242
Nokogiri::HTML4::ElementDescription::CONTENT_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#154
Nokogiri::HTML4::ElementDescription::COREATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#165
Nokogiri::HTML4::ElementDescription::CORE_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#164
Nokogiri::HTML4::ElementDescription::CORE_I18N_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#281
Nokogiri::HTML4::ElementDescription::DIR_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#198
Nokogiri::HTML4::ElementDescription::DL_CONTENTS = T.let(T.unsafe(nil), Array)

# This is filled in down below.
#
# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#19
Nokogiri::HTML4::ElementDescription::DefaultDescriptions = T.let(T.unsafe(nil), Hash)

# Methods are defined protected by method_defined? because at
# this point the C-library or Java library is already loaded,
# and we don't want to clobber any methods that have been
# defined there.
#
# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#11
Nokogiri::HTML4::ElementDescription::Desc = Struct

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#196
Nokogiri::HTML4::ElementDescription::EDIT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#223
Nokogiri::HTML4::ElementDescription::EMBED_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#147
Nokogiri::HTML4::ElementDescription::EMPTY = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#156
Nokogiri::HTML4::ElementDescription::EVENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#201
Nokogiri::HTML4::ElementDescription::FIELDSET_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#145
Nokogiri::HTML4::ElementDescription::FLOW = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#179
Nokogiri::HTML4::ElementDescription::FLOW_PARAM = T.let(T.unsafe(nil), Array)

# Attributes defined and categorized
#
# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#131
Nokogiri::HTML4::ElementDescription::FONTSTYLE = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#202
Nokogiri::HTML4::ElementDescription::FONT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#140
Nokogiri::HTML4::ElementDescription::FORMCTRL = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#206
Nokogiri::HTML4::ElementDescription::FORM_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#203
Nokogiri::HTML4::ElementDescription::FORM_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#210
Nokogiri::HTML4::ElementDescription::FRAMESET_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#211
Nokogiri::HTML4::ElementDescription::FRAMESET_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#208
Nokogiri::HTML4::ElementDescription::FRAME_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#138
Nokogiri::HTML4::ElementDescription::HEADING = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#212
Nokogiri::HTML4::ElementDescription::HEAD_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#213
Nokogiri::HTML4::ElementDescription::HEAD_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#175
Nokogiri::HTML4::ElementDescription::HREF_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#215
Nokogiri::HTML4::ElementDescription::HR_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#163
Nokogiri::HTML4::ElementDescription::HTML_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#152
Nokogiri::HTML4::ElementDescription::HTML_CDATA = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#217
Nokogiri::HTML4::ElementDescription::HTML_CONTENT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#149
Nokogiri::HTML4::ElementDescription::HTML_FLOW = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#150
Nokogiri::HTML4::ElementDescription::HTML_INLINE = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#151
Nokogiri::HTML4::ElementDescription::HTML_PCDATA = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#155
Nokogiri::HTML4::ElementDescription::I18N = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#166
Nokogiri::HTML4::ElementDescription::I18N_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#218
Nokogiri::HTML4::ElementDescription::IFRAME_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#221
Nokogiri::HTML4::ElementDescription::IMG_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#144
Nokogiri::HTML4::ElementDescription::INLINE = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#177
Nokogiri::HTML4::ElementDescription::INLINE_P = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#227
Nokogiri::HTML4::ElementDescription::INPUT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#200
Nokogiri::HTML4::ElementDescription::LABEL_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#232
Nokogiri::HTML4::ElementDescription::LABEL_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#259
Nokogiri::HTML4::ElementDescription::LANGUAGE_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#233
Nokogiri::HTML4::ElementDescription::LEGEND_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#235
Nokogiri::HTML4::ElementDescription::LINK_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#139
Nokogiri::HTML4::ElementDescription::LIST = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#279
Nokogiri::HTML4::ElementDescription::LI_ELT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#237
Nokogiri::HTML4::ElementDescription::MAP_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#241
Nokogiri::HTML4::ElementDescription::META_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#146
Nokogiri::HTML4::ElementDescription::MODIFIER = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#238
Nokogiri::HTML4::ElementDescription::NAME_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#244
Nokogiri::HTML4::ElementDescription::NOFRAMES_CONTENT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#246
Nokogiri::HTML4::ElementDescription::OBJECT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#245
Nokogiri::HTML4::ElementDescription::OBJECT_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#249
Nokogiri::HTML4::ElementDescription::OBJECT_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#250
Nokogiri::HTML4::ElementDescription::OL_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#252
Nokogiri::HTML4::ElementDescription::OPTGROUP_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#253
Nokogiri::HTML4::ElementDescription::OPTION_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#251
Nokogiri::HTML4::ElementDescription::OPTION_ELT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#254
Nokogiri::HTML4::ElementDescription::PARAM_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#137
Nokogiri::HTML4::ElementDescription::PCDATA = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#132
Nokogiri::HTML4::ElementDescription::PHRASE = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#256
Nokogiri::HTML4::ElementDescription::PRE_CONTENT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#231
Nokogiri::HTML4::ElementDescription::PROMPT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#186
Nokogiri::HTML4::ElementDescription::QUOTE_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#172
Nokogiri::HTML4::ElementDescription::ROWS_COLS_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#258
Nokogiri::HTML4::ElementDescription::SCRIPT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#261
Nokogiri::HTML4::ElementDescription::SELECT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#260
Nokogiri::HTML4::ElementDescription::SELECT_CONTENT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#134
Nokogiri::HTML4::ElementDescription::SPECIAL = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#174
Nokogiri::HTML4::ElementDescription::SRC_ALT_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#263
Nokogiri::HTML4::ElementDescription::STYLE_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#264
Nokogiri::HTML4::ElementDescription::TABLE_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#267
Nokogiri::HTML4::ElementDescription::TABLE_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#266
Nokogiri::HTML4::ElementDescription::TABLE_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#270
Nokogiri::HTML4::ElementDescription::TALIGN_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#171
Nokogiri::HTML4::ElementDescription::TARGET_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#274
Nokogiri::HTML4::ElementDescription::TEXTAREA_ATTRS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#272
Nokogiri::HTML4::ElementDescription::TH_TD_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#271
Nokogiri::HTML4::ElementDescription::TH_TD_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#277
Nokogiri::HTML4::ElementDescription::TR_CONTENTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#269
Nokogiri::HTML4::ElementDescription::TR_ELT = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#243
Nokogiri::HTML4::ElementDescription::TYPE_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#280
Nokogiri::HTML4::ElementDescription::UL_DEPR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#216
Nokogiri::HTML4::ElementDescription::VERSION_ATTR = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/html4/element_description_defaults.rb#255
Nokogiri::HTML4::ElementDescription::WIDTH_ATTR = T.let(T.unsafe(nil), Array)

class Nokogiri::HTML4::EntityDescription < ::Struct; end

class Nokogiri::HTML4::EntityLookup
  # Look up entity with +name+
  #
  # source://nokogiri//lib/nokogiri/html4/entity_lookup.rb#10
  def [](name); end

  def get(_arg0); end
end

# Instance of Nokogiri::HTML4::EntityLookup
#
# source://nokogiri//lib/nokogiri/html4.rb#35
Nokogiri::HTML4::NamedCharacters = T.let(T.unsafe(nil), Nokogiri::HTML4::EntityLookup)

# Nokogiri lets you write a SAX parser to process HTML but get HTML correction features.
#
# See Nokogiri::HTML4::SAX::Parser for a basic example of using a SAX parser with HTML.
#
# For more information on SAX parsers, see Nokogiri::XML::SAX
module Nokogiri::HTML4::SAX; end

# This class lets you perform SAX style parsing on HTML with HTML error correction.
#
# Here is a basic usage example:
#
#   class MyDoc < Nokogiri::XML::SAX::Document
#     def start_element name, attributes = []
#       puts "found a #{name}"
#     end
#   end
#
#   parser = Nokogiri::HTML4::SAX::Parser.new(MyDoc.new)
#   parser.parse(File.read(ARGV[0], mode: 'rb'))
#
# For more information on SAX parsers, see Nokogiri::XML::SAX
class Nokogiri::HTML4::SAX::Parser < ::Nokogiri::XML::SAX::Parser
  # Parse a file with +filename+
  #
  # @raise [ArgumentError]
  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/html4/sax/parser.rb#51
  def parse_file(filename, encoding = T.unsafe(nil)); end

  # Parse given +io+
  #
  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/html4/sax/parser.rb#41
  def parse_io(io, encoding = T.unsafe(nil)); end

  # Parse html stored in +data+ using +encoding+
  #
  # @raise [TypeError]
  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/html4/sax/parser.rb#30
  def parse_memory(data, encoding = T.unsafe(nil)); end
end

# Context for HTML SAX parsers. This class is usually not instantiated by the user. Instead,
# you should be looking at Nokogiri::HTML4::SAX::Parser
class Nokogiri::HTML4::SAX::ParserContext < ::Nokogiri::XML::SAX::ParserContext
  def parse_with(_arg0); end

  class << self
    def file(_arg0, _arg1); end
    def memory(_arg0, _arg1); end

    # source://nokogiri//lib/nokogiri/html4/sax/parser_context.rb#10
    def new(thing, encoding = T.unsafe(nil)); end
  end
end

class Nokogiri::HTML4::SAX::PushParser < ::Nokogiri::XML::SAX::PushParser
  # @return [PushParser] a new instance of PushParser
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#11
  def initialize(doc = T.unsafe(nil), file_name = T.unsafe(nil), encoding = T.unsafe(nil)); end

  # Write a +chunk+ of HTML to the PushParser.  Any callback methods
  # that can be called will be called immediately.
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#23
  def <<(chunk, last_chunk = T.unsafe(nil)); end

  # The Nokogiri::HTML4::SAX::Document on which the PushParser will be
  # operating
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#9
  def document; end

  # The Nokogiri::HTML4::SAX::Document on which the PushParser will be
  # operating
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#9
  def document=(_arg0); end

  # Finish the parsing.  This method is only necessary for
  # Nokogiri::HTML4::SAX::Document#end_document to be called.
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#31
  def finish; end

  # Write a +chunk+ of HTML to the PushParser.  Any callback methods
  # that can be called will be called immediately.
  #
  # source://nokogiri//lib/nokogiri/html4/sax/push_parser.rb#23
  def write(chunk, last_chunk = T.unsafe(nil)); end

  private

  def initialize_native(_arg0, _arg1, _arg2); end
  def native_write(_arg0, _arg1); end
end

# == Usage
#
# ⚠ HTML5 functionality is not available when running JRuby.
#
# Parse an HTML5 document:
#
#   doc = Nokogiri.HTML5(string)
#
# Parse an HTML5 fragment:
#
#   fragment = Nokogiri::HTML5.fragment(string)
#
# == Parsing options
#
# The document and fragment parsing methods support options that are different from Nokogiri's.
#
# - <tt>Nokogiri.HTML5(html, url = nil, encoding = nil, options = {})</tt>
# - <tt>Nokogiri::HTML5.parse(html, url = nil, encoding = nil, options = {})</tt>
# - <tt>Nokogiri::HTML5::Document.parse(html, url = nil, encoding = nil, options = {})</tt>
# - <tt>Nokogiri::HTML5.fragment(html, encoding = nil, options = {})</tt>
# - <tt>Nokogiri::HTML5::DocumentFragment.parse(html, encoding = nil, options = {})</tt>
#
# The three currently supported options are +:max_errors+, +:max_tree_depth+ and
# +:max_attributes+, described below.
#
# === Error reporting
#
# Nokogiri contains an experimental HTML5 parse error reporting facility. By default, no parse
# errors are reported but this can be configured by passing the +:max_errors+ option to
# {HTML5.parse} or {HTML5.fragment}.
#
# For example, this script:
#
#   doc = Nokogiri::HTML5.parse('<span/>Hi there!</span foo=bar />', max_errors: 10)
#   doc.errors.each do |err|
#     puts(err)
#   end
#
# Emits:
#
#   1:1: ERROR: Expected a doctype token
#   <span/>Hi there!</span foo=bar />
#   ^
#   1:1: ERROR: Start tag of nonvoid HTML element ends with '/>', use '>'.
#   <span/>Hi there!</span foo=bar />
#   ^
#   1:17: ERROR: End tag ends with '/>', use '>'.
#   <span/>Hi there!</span foo=bar />
#                   ^
#   1:17: ERROR: End tag contains attributes.
#   <span/>Hi there!</span foo=bar />
#                   ^
#
# Using <tt>max_errors: -1</tt> results in an unlimited number of errors being returned.
#
# The errors returned by {HTML5::Document#errors} are instances of {Nokogiri::XML::SyntaxError}.
#
# The {https://html.spec.whatwg.org/multipage/parsing.html#parse-errors HTML standard} defines a
# number of standard parse error codes. These error codes only cover the "tokenization" stage of
# parsing HTML. The parse errors in the "tree construction" stage do not have standardized error
# codes (yet).
#
# As a convenience to Nokogiri users, the defined error codes are available via
# {Nokogiri::XML::SyntaxError#str1} method.
#
#   doc = Nokogiri::HTML5.parse('<span/>Hi there!</span foo=bar />', max_errors: 10)
#   doc.errors.each do |err|
#     puts("#{err.line}:#{err.column}: #{err.str1}")
#   end
#   # => 1:1: generic-parser
#   #    1:1: non-void-html-element-start-tag-with-trailing-solidus
#   #    1:17: end-tag-with-trailing-solidus
#   #    1:17: end-tag-with-attributes
#
# Note that the first error is +generic-parser+ because it's an error from the tree construction
# stage and doesn't have a standardized error code.
#
# For the purposes of semantic versioning, the error messages, error locations, and error codes
# are not part of Nokogiri's public API. That is, these are subject to change without Nokogiri's
# major version number changing. These may be stabilized in the future.
#
# === Maximum tree depth
#
# The maximum depth of the DOM tree parsed by the various parsing methods is configurable by the
# +:max_tree_depth+ option. If the depth of the tree would exceed this limit, then an
# {::ArgumentError} is thrown.
#
# This limit (which defaults to <tt>Nokogiri::Gumbo::DEFAULT_MAX_TREE_DEPTH = 400</tt>) can be
# removed by giving the option <tt>max_tree_depth: -1</tt>.
#
#   html = '<!DOCTYPE html>' + '<div>' * 1000
#   doc = Nokogiri.HTML5(html)
#   # raises ArgumentError: Document tree depth limit exceeded
#   doc = Nokogiri.HTML5(html, max_tree_depth: -1)
#
# === Attribute limit per element
#
# The maximum number of attributes per DOM element is configurable by the +:max_attributes+
# option. If a given element would exceed this limit, then an {::ArgumentError} is thrown.
#
# This limit (which defaults to <tt>Nokogiri::Gumbo::DEFAULT_MAX_ATTRIBUTES = 400</tt>) can be
# removed by giving the option <tt>max_attributes: -1</tt>.
#
#   html = '<!DOCTYPE html><div ' + (1..1000).map { |x| "attr-#{x}" }.join(' ') + '>'
#   # "<!DOCTYPE html><div attr-1 attr-2 attr-3 ... attr-1000>"
#   doc = Nokogiri.HTML5(html)
#   # raises ArgumentError: Attributes per element limit exceeded
#   doc = Nokogiri.HTML5(html, max_attributes: -1)
#
# == HTML Serialization
#
# After parsing HTML, it may be serialized using any of the {Nokogiri::XML::Node} serialization
# methods. In particular, {XML::Node#serialize}, {XML::Node#to_html}, and {XML::Node#to_s} will
# serialize a given node and its children. (This is the equivalent of JavaScript's
# +Element.outerHTML+.) Similarly, {XML::Node#inner_html} will serialize the children of a given
# node. (This is the equivalent of JavaScript's +Element.innerHTML+.)
#
#   doc = Nokogiri::HTML5("<!DOCTYPE html><span>Hello world!</span>")
#   puts doc.serialize
#   # => <!DOCTYPE html><html><head></head><body><span>Hello world!</span></body></html>
#
# Due to quirks in how HTML is parsed and serialized, it's possible for a DOM tree to be
# serialized and then re-parsed, resulting in a different DOM.  Mostly, this happens with DOMs
# produced from invalid HTML. Unfortunately, even valid HTML may not survive serialization and
# re-parsing.
#
# In particular, a newline at the start of +pre+, +listing+, and +textarea+ elements is ignored by
# the parser.
#
#   doc = Nokogiri::HTML5(<<-EOF)
#   <!DOCTYPE html>
#   <pre>
#   Content</pre>
#   EOF
#   puts doc.at('/html/body/pre').serialize
#   # => <pre>Content</pre>
#
# In this case, the original HTML is semantically equivalent to the serialized version. If the
# +pre+, +listing+, or +textarea+ content starts with two newlines, the first newline will be
# stripped on the first parse and the second newline will be stripped on the second, leading to
# semantically different DOMs. Passing the parameter <tt>preserve_newline: true</tt> will cause
# two or more newlines to be preserved. (A single leading newline will still be removed.)
#
#   doc = Nokogiri::HTML5(<<-EOF)
#   <!DOCTYPE html>
#   <listing>
#
#   Content</listing>
#   EOF
#   puts doc.at('/html/body/listing').serialize(preserve_newline: true)
#   # => <listing>
#   #
#   #    Content</listing>
#
# == Encodings
#
# Nokogiri always parses HTML5 using {https://en.wikipedia.org/wiki/UTF-8 UTF-8}; however, the
# encoding of the input can be explicitly selected via the optional +encoding+ parameter. This is
# most useful when the input comes not from a string but from an IO object.
#
# When serializing a document or node, the encoding of the output string can be specified via the
# +:encoding+ options. Characters that cannot be encoded in the selected encoding will be encoded
# as {https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references HTML numeric
# entities}.
#
#   frag = Nokogiri::HTML5.fragment('<span>아는 길도 물어가라</span>')
#   puts html
#   # => <span>&#xc544;&#xb294; &#xae38;&#xb3c4; &#xbb3c;&#xc5b4;&#xac00;&#xb77c;</span>
#   frag = Nokogiri::HTML5.fragment(html)
#   puts frag.serialize
#   # => <span>아는 길도 물어가라</span>
#
# (There's a {https://bugs.ruby-lang.org/issues/15033 bug} in all current versions of Ruby that
# can cause the entity encoding to fail. Of the mandated supported encodings for HTML, the only
# encoding I'm aware of that has this bug is <tt>'ISO-2022-JP'</tt>. We recommend avoiding this
# encoding.)
#
# == Notes
#
# * The {Nokogiri::HTML5.fragment} function takes a string and parses it
#   as a HTML5 document.  The +<html>+, +<head>+, and +<body>+ elements are
#   removed from this document, and any children of these elements that remain
#   are returned as a {Nokogiri::HTML5::DocumentFragment}.
#
# * The {Nokogiri::HTML5.parse} function takes a string and passes it to the
#   <code>gumbo_parse_with_options</code> method, using the default options.
#   The resulting Gumbo parse tree is then walked.
#
# * Instead of uppercase element names, lowercase element names are produced.
#
# * Instead of returning +unknown+ as the element name for unknown tags, the
#   original tag name is returned verbatim.
#
# Since v1.12.0
module Nokogiri::HTML5
  class << self
    # source://nokogiri//lib/nokogiri/html5.rb#457
    def escape_text(text, encoding, attribute_mode); end

    # Parse a fragment from +string+. Convenience method for
    # {Nokogiri::HTML5::DocumentFragment.parse}.
    #
    # source://nokogiri//lib/nokogiri/html5.rb#245
    def fragment(string, encoding = T.unsafe(nil), **options); end

    # Fetch and parse a HTML document from the web, following redirects,
    # handling https, and determining the character encoding using HTML5
    # rules.  +uri+ may be a +String+ or a +URI+.  +options+ contains
    # http headers and special options.  Everything which is not a
    # special option is considered a header.  Special options include:
    #  * :follow_limit => number of redirects which are followed
    #  * :basic_auth => [username, password]
    #
    # source://nokogiri//lib/nokogiri/html5.rb#256
    def get(uri, options = T.unsafe(nil)); end

    # source://nokogiri//lib/nokogiri/html5.rb#265
    def get_impl(uri, options = T.unsafe(nil)); end

    # Parse an HTML 5 document. Convenience method for {Nokogiri::HTML5::Document.parse}
    #
    # source://nokogiri//lib/nokogiri/html5.rb#239
    def parse(string, url = T.unsafe(nil), encoding = T.unsafe(nil), **options, &block); end

    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/html5.rb#469
    def prepend_newline?(node); end

    # source://nokogiri//lib/nokogiri/html5.rb#314
    def read_and_encode(string, encoding); end

    # Charset sniffing is a complex and controversial topic that understandably isn't done _by
    # default_ by the Ruby Net::HTTP library.  This being said, it is a very real problem for
    # consumers of HTML as the default for HTML is iso-8859-1, most "good" producers use utf-8, and
    # the Gumbo parser *only* supports utf-8.
    #
    # Accordingly, Nokogiri::HTML4::Document.parse provides limited encoding detection.  Following
    # this lead, Nokogiri::HTML5 attempts to do likewise, while attempting to more closely follow
    # the HTML5 standard.
    #
    # http://bugs.ruby-lang.org/issues/2567
    # http://www.w3.org/TR/html5/syntax.html#determining-the-character-encoding
    #
    # source://nokogiri//lib/nokogiri/html5.rb#350
    def reencode(body, content_type = T.unsafe(nil)); end

    # source://nokogiri//lib/nokogiri/html5.rb#392
    def serialize_node_internal(current_node, io, encoding, options); end
  end
end

# Since v1.12.0
#
# 💡 HTML5 functionality is not available when running JRuby.
class Nokogiri::HTML5::Document < ::Nokogiri::HTML4::Document
  # source://nokogiri//lib/nokogiri/html5/document.rb#58
  def fragment(tags = T.unsafe(nil)); end

  # source://nokogiri//lib/nokogiri/html5/document.rb#62
  def to_xml(options = T.unsafe(nil), &block); end

  # :call-seq:
  #   xpath_doctype() → Nokogiri::CSS::XPathVisitor::DoctypeConfig
  #
  # [Returns] The document type which determines CSS-to-XPath translation.
  #
  # See XPathVisitor for more information.
  #
  # source://nokogiri//lib/nokogiri/html5/document.rb#74
  def xpath_doctype; end

  class << self
    # source://nokogiri//lib/nokogiri/html5/document.rb#80
    def do_parse(string_or_io, url, encoding, options); end

    # @yield [options]
    #
    # source://nokogiri//lib/nokogiri/html5/document.rb#28
    def parse(string_or_io, url = T.unsafe(nil), encoding = T.unsafe(nil), **options, &block); end

    # @raise [ArgumentError]
    #
    # source://nokogiri//lib/nokogiri/html5/document.rb#46
    def read_io(io, url = T.unsafe(nil), encoding = T.unsafe(nil), **options); end

    # @raise [ArgumentError]
    #
    # source://nokogiri//lib/nokogiri/html5/document.rb#52
    def read_memory(string, url = T.unsafe(nil), encoding = T.unsafe(nil), **options); end
  end
end

# Since v1.12.0
#
# 💡 HTML5 functionality is not available when running JRuby.
class Nokogiri::HTML5::DocumentFragment < ::Nokogiri::HTML4::DocumentFragment
  # Create a document fragment.
  #
  # @return [DocumentFragment] a new instance of DocumentFragment
  #
  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#32
  def initialize(doc, tags = T.unsafe(nil), ctx = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute document.
  #
  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#28
  def document; end

  # Sets the attribute document
  #
  # @param value the value to set the attribute document to.
  #
  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#28
  def document=(_arg0); end

  # Returns the value of attribute errors.
  #
  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#29
  def errors; end

  # Sets the attribute errors
  #
  # @param value the value to set the attribute errors to.
  #
  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#29
  def errors=(_arg0); end

  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#58
  def extract_params(params); end

  # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#44
  def serialize(options = T.unsafe(nil), &block); end

  class << self
    # Parse a document fragment from +tags+, returning a Nodeset.
    #
    # source://nokogiri//lib/nokogiri/html5/document_fragment.rb#51
    def parse(tags, encoding = T.unsafe(nil), options = T.unsafe(nil)); end
  end
end

# HTML uses the XHTML namespace.
#
# source://nokogiri//lib/nokogiri/html5.rb#231
Nokogiri::HTML5::HTML_NAMESPACE = T.let(T.unsafe(nil), String)

# source://nokogiri//lib/nokogiri/html5.rb#232
Nokogiri::HTML5::MATHML_NAMESPACE = T.let(T.unsafe(nil), String)

# Since v1.12.0
#
# 💡 HTML5 functionality is not available when running JRuby.
module Nokogiri::HTML5::Node
  # source://nokogiri//lib/nokogiri/html5/node.rb#67
  def fragment(tags); end

  # source://nokogiri//lib/nokogiri/html5/node.rb#28
  def inner_html(options = T.unsafe(nil)); end

  # @yield [config]
  #
  # source://nokogiri//lib/nokogiri/html5/node.rb#36
  def write_to(io, *options); end

  private

  # HTML elements can have attributes that contain colons.
  # Nokogiri::XML::Node#[]= treats names with colons as a prefixed QName
  # and tries to create an attribute in a namespace. This is especially
  # annoying with attribute names like xml:lang since libxml2 will
  # actually create the xml namespace if it doesn't exist already.
  #
  # source://nokogiri//lib/nokogiri/html5/node.rb#80
  def add_child_node_and_reparent_attrs(node); end
end

# source://nokogiri//lib/nokogiri/html5.rb#233
Nokogiri::HTML5::SVG_NAMESPACE = T.let(T.unsafe(nil), String)

# source://nokogiri//lib/nokogiri/html5.rb#234
Nokogiri::HTML5::XLINK_NAMESPACE = T.let(T.unsafe(nil), String)

# source://nokogiri//lib/nokogiri/html5.rb#236
Nokogiri::HTML5::XMLNS_NAMESPACE = T.let(T.unsafe(nil), String)

# source://nokogiri//lib/nokogiri/html5.rb#235
Nokogiri::HTML5::XML_NAMESPACE = T.let(T.unsafe(nil), String)

Nokogiri::LIBXML2_PATCHES = T.let(T.unsafe(nil), Array)
Nokogiri::LIBXML_COMPILED_VERSION = T.let(T.unsafe(nil), String)
Nokogiri::LIBXML_ICONV_ENABLED = T.let(T.unsafe(nil), TrueClass)
Nokogiri::LIBXML_LOADED_VERSION = T.let(T.unsafe(nil), String)
Nokogiri::LIBXML_MEMORY_MANAGEMENT = T.let(T.unsafe(nil), String)
Nokogiri::LIBXSLT_COMPILED_VERSION = T.let(T.unsafe(nil), String)
Nokogiri::LIBXSLT_DATETIME_ENABLED = T.let(T.unsafe(nil), TrueClass)
Nokogiri::LIBXSLT_LOADED_VERSION = T.let(T.unsafe(nil), String)
Nokogiri::LIBXSLT_PATCHES = T.let(T.unsafe(nil), Array)
Nokogiri::OTHER_LIBRARY_VERSIONS = T.let(T.unsafe(nil), String)
Nokogiri::PACKAGED_LIBRARIES = T.let(T.unsafe(nil), TrueClass)
Nokogiri::PRECOMPILED_LIBRARIES = T.let(T.unsafe(nil), TrueClass)
class Nokogiri::SyntaxError < ::StandardError; end

module Nokogiri::Test
  class << self
    def __foreign_error_handler; end
  end
end

# The version of Nokogiri you are using
#
# source://nokogiri//lib/nokogiri/version/constant.rb#5
Nokogiri::VERSION = T.let(T.unsafe(nil), String)

# Detailed version info about Nokogiri and the installed extension dependencies.
#
# source://nokogiri//lib/nokogiri/version/info.rb#221
Nokogiri::VERSION_INFO = T.let(T.unsafe(nil), Hash)

class Nokogiri::VersionInfo
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # source://nokogiri//lib/nokogiri/version/info.rb#33
  def compiled_libxml_version; end

  # source://nokogiri//lib/nokogiri/version/info.rb#44
  def compiled_libxslt_version; end

  # source://nokogiri//lib/nokogiri/version/info.rb#22
  def engine; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#10
  def jruby?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#48
  def libxml2?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#52
  def libxml2_has_iconv?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#68
  def libxml2_precompiled?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#60
  def libxml2_using_packaged?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#64
  def libxml2_using_system?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#56
  def libxslt_has_datetime?; end

  # source://nokogiri//lib/nokogiri/version/info.rb#26
  def loaded_libxml_version; end

  # source://nokogiri//lib/nokogiri/version/info.rb#37
  def loaded_libxslt_version; end

  # source://nokogiri//lib/nokogiri/version/info.rb#18
  def ruby_minor; end

  # source://nokogiri//lib/nokogiri/version/info.rb#88
  def to_hash; end

  # source://nokogiri//lib/nokogiri/version/info.rb#179
  def to_markdown; end

  # source://nokogiri//lib/nokogiri/version/info.rb#72
  def warnings; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/version/info.rb#14
  def windows?; end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

module Nokogiri::XML
  class << self
    # Parse an XML document using the Nokogiri::XML::Reader API.  See
    # Nokogiri::XML::Reader for mor information
    #
    # @yield [options]
    #
    # source://nokogiri//lib/nokogiri/xml.rb#23
    def Reader(string_or_io, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil)); end

    # Create a new Nokogiri::XML::RelaxNG document from +string_or_io+.
    # See Nokogiri::XML::RelaxNG for an example.
    #
    # source://nokogiri//lib/nokogiri/xml/relax_ng.rb#9
    def RelaxNG(string_or_io, options = T.unsafe(nil)); end

    # Create a new Nokogiri::XML::Schema object using a +string_or_io+
    # object.
    #
    # source://nokogiri//lib/nokogiri/xml/schema.rb#9
    def Schema(string_or_io, options = T.unsafe(nil)); end

    # Parse a fragment from +string+ in to a NodeSet.
    #
    # source://nokogiri//lib/nokogiri/xml.rb#42
    def fragment(string, options = T.unsafe(nil), &block); end

    # Parse XML.  Convenience method for Nokogiri::XML::Document.parse
    #
    # source://nokogiri//lib/nokogiri/xml.rb#36
    def parse(thing, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil), &block); end
  end
end

class Nokogiri::XML::Attr < ::Nokogiri::XML::Node
  def content=(_arg0); end
  def to_s; end
  def value; end
  def value=(_arg0); end

  private

  # source://nokogiri//lib/nokogiri/xml/attr.rb#12
  def inspect_attributes; end

  class << self
    def new(*_arg0); end
  end
end

# Represents an attribute declaration in a DTD
class Nokogiri::XML::AttributeDecl < ::Nokogiri::XML::Node
  def attribute_type; end
  def default; end
  def enumeration; end

  # source://nokogiri//lib/nokogiri/xml/attribute_decl.rb#15
  def inspect; end
end

# Nokogiri builder can be used for building XML and HTML documents.
#
# == Synopsis:
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.root {
#       xml.products {
#         xml.widget {
#           xml.id_ "10"
#           xml.name "Awesome widget"
#         }
#       }
#     }
#   end
#   puts builder.to_xml
#
# Will output:
#
#   <?xml version="1.0"?>
#   <root>
#     <products>
#       <widget>
#         <id>10</id>
#         <name>Awesome widget</name>
#       </widget>
#     </products>
#   </root>
#
#
# === Builder scope
#
# The builder allows two forms.  When the builder is supplied with a block
# that has a parameter, the outside scope is maintained.  This means you
# can access variables that are outside your builder.  If you don't need
# outside scope, you can use the builder without the "xml" prefix like
# this:
#
#   builder = Nokogiri::XML::Builder.new do
#     root {
#       products {
#         widget {
#           id_ "10"
#           name "Awesome widget"
#         }
#       }
#     }
#   end
#
# == Special Tags
#
# The builder works by taking advantage of method_missing.  Unfortunately
# some methods are defined in ruby that are difficult or dangerous to
# remove.  You may want to create tags with the name "type", "class", and
# "id" for example.  In that case, you can use an underscore to
# disambiguate your tag name from the method call.
#
# Here is an example of using the underscore to disambiguate tag names from
# ruby methods:
#
#   @objects = [Object.new, Object.new, Object.new]
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.root {
#       xml.objects {
#         @objects.each do |o|
#           xml.object {
#             xml.type_   o.type
#             xml.class_  o.class.name
#             xml.id_     o.id
#           }
#         end
#       }
#     }
#   end
#   puts builder.to_xml
#
# The underscore may be used with any tag name, and the last underscore
# will just be removed.  This code will output the following XML:
#
#   <?xml version="1.0"?>
#   <root>
#     <objects>
#       <object>
#         <type>Object</type>
#         <class>Object</class>
#         <id>48390</id>
#       </object>
#       <object>
#         <type>Object</type>
#         <class>Object</class>
#         <id>48380</id>
#       </object>
#       <object>
#         <type>Object</type>
#         <class>Object</class>
#         <id>48370</id>
#       </object>
#     </objects>
#   </root>
#
# == Tag Attributes
#
# Tag attributes may be supplied as method arguments.  Here is our
# previous example, but using attributes rather than tags:
#
#   @objects = [Object.new, Object.new, Object.new]
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.root {
#       xml.objects {
#         @objects.each do |o|
#           xml.object(:type => o.type, :class => o.class, :id => o.id)
#         end
#       }
#     }
#   end
#   puts builder.to_xml
#
# === Tag Attribute Short Cuts
#
# A couple attribute short cuts are available when building tags.  The
# short cuts are available by special method calls when building a tag.
#
# This example builds an "object" tag with the class attribute "classy"
# and the id of "thing":
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.root {
#       xml.objects {
#         xml.object.classy.thing!
#       }
#     }
#   end
#   puts builder.to_xml
#
# Which will output:
#
#   <?xml version="1.0"?>
#   <root>
#     <objects>
#       <object class="classy" id="thing"/>
#     </objects>
#   </root>
#
# All other options are still supported with this syntax, including
# blocks and extra tag attributes.
#
# == Namespaces
#
# Namespaces are added similarly to attributes.  Nokogiri::XML::Builder
# assumes that when an attribute starts with "xmlns", it is meant to be
# a namespace:
#
#   builder = Nokogiri::XML::Builder.new { |xml|
#     xml.root('xmlns' => 'default', 'xmlns:foo' => 'bar') do
#       xml.tenderlove
#     end
#   }
#   puts builder.to_xml
#
# Will output XML like this:
#
#   <?xml version="1.0"?>
#   <root xmlns:foo="bar" xmlns="default">
#     <tenderlove/>
#   </root>
#
# === Referencing declared namespaces
#
# Tags that reference non-default namespaces (i.e. a tag "foo:bar") can be
# built by using the Nokogiri::XML::Builder#[] method.
#
# For example:
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.root('xmlns:foo' => 'bar') {
#       xml.objects {
#         xml['foo'].object.classy.thing!
#       }
#     }
#   end
#   puts builder.to_xml
#
# Will output this XML:
#
#   <?xml version="1.0"?>
#   <root xmlns:foo="bar">
#     <objects>
#       <foo:object class="classy" id="thing"/>
#     </objects>
#   </root>
#
# Note the "foo:object" tag.
#
# === Namespace inheritance
#
# In the Builder context, children will inherit their parent's namespace. This is the same
# behavior as if the underlying {XML::Document} set +namespace_inheritance+ to +true+:
#
#   result = Nokogiri::XML::Builder.new do |xml|
#     xml["soapenv"].Envelope("xmlns:soapenv" => "http://schemas.xmlsoap.org/soap/envelope/") do
#       xml.Header
#     end
#   end
#   result.doc.to_xml
#   # => <?xml version="1.0" encoding="utf-8"?>
#   #    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
#   #      <soapenv:Header/>
#   #    </soapenv:Envelope>
#
# Users may turn this behavior off by passing a keyword argument +namespace_inheritance:false+
# to the initializer:
#
#   result = Nokogiri::XML::Builder.new(namespace_inheritance: false) do |xml|
#     xml["soapenv"].Envelope("xmlns:soapenv" => "http://schemas.xmlsoap.org/soap/envelope/") do
#       xml.Header
#       xml["soapenv"].Body # users may explicitly opt into the namespace
#     end
#   end
#   result.doc.to_xml
#   # => <?xml version="1.0" encoding="utf-8"?>
#   #    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
#   #      <Header/>
#   #      <soapenv:Body/>
#   #    </soapenv:Envelope>
#
# For more information on namespace inheritance, please see {XML::Document#namespace_inheritance}
#
#
# == Document Types
#
# To create a document type (DTD), access use the Builder#doc method to get
# the current context document.  Then call Node#create_internal_subset to
# create the DTD node.
#
# For example, this Ruby:
#
#   builder = Nokogiri::XML::Builder.new do |xml|
#     xml.doc.create_internal_subset(
#       'html',
#       "-//W3C//DTD HTML 4.01 Transitional//EN",
#       "http://www.w3.org/TR/html4/loose.dtd"
#     )
#     xml.root do
#       xml.foo
#     end
#   end
#
#   puts builder.to_xml
#
# Will output this xml:
#
#   <?xml version="1.0"?>
#   <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
#   <root>
#     <foo/>
#   </root>
class Nokogiri::XML::Builder
  include ::Nokogiri::ClassResolver

  # Create a new Builder object.  +options+ are sent to the top level
  # Document that is being built.
  #
  # Building a document with a particular encoding for example:
  #
  #   Nokogiri::XML::Builder.new(:encoding => 'UTF-8') do |xml|
  #     ...
  #   end
  #
  # @return [Builder] a new instance of Builder
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#307
  def initialize(options = T.unsafe(nil), root = T.unsafe(nil), &block); end

  # Append the given raw XML +string+ to the document
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#390
  def <<(string); end

  # Build a tag that is associated with namespace +ns+.  Raises an
  # ArgumentError if +ns+ has not been defined higher in the tree.
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#358
  def [](ns); end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#278
  def arity; end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#278
  def arity=(_arg0); end

  # Create a CDATA Node with content of +string+
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#345
  def cdata(string); end

  # Create a Comment Node with content of +string+
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#351
  def comment(string); end

  # A context object for use when the block has no arguments
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#276
  def context; end

  # A context object for use when the block has no arguments
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#276
  def context=(_arg0); end

  # The current Document object being built
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#270
  def doc; end

  # The current Document object being built
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#270
  def doc=(_arg0); end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#394
  def method_missing(method, *args, &block); end

  # The parent of the current node being built
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#273
  def parent; end

  # The parent of the current node being built
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#273
  def parent=(_arg0); end

  # Create a Text Node with content of +string+
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#339
  def text(string); end

  # Convert this Builder object to XML
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#377
  def to_xml(*args); end

  private

  # Insert +node+ as a child of the current Node
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#423
  def insert(node, &block); end

  class << self
    # Create a builder with an existing root object.  This is for use when
    # you have an existing document that you would like to augment with
    # builder methods.  The builder context created will start with the
    # given +root+ node.
    #
    # For example:
    #
    #   doc = Nokogiri::XML(File.read('somedoc.xml'))
    #   Nokogiri::XML::Builder.with(doc.at_css('some_tag')) do |xml|
    #     # ... Use normal builder methods here ...
    #     xml.awesome # add the "awesome" tag below "some_tag"
    #   end
    #
    # source://nokogiri//lib/nokogiri/xml/builder.rb#294
    def with(root, &block); end
  end
end

# source://nokogiri//lib/nokogiri/xml/builder.rb#267
Nokogiri::XML::Builder::DEFAULT_DOCUMENT_OPTIONS = T.let(T.unsafe(nil), Hash)

class Nokogiri::XML::Builder::NodeBuilder
  # @return [NodeBuilder] a new instance of NodeBuilder
  #
  # source://nokogiri//lib/nokogiri/xml/builder.rb#443
  def initialize(node, doc_builder); end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#452
  def [](k); end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#448
  def []=(k, v); end

  # source://nokogiri//lib/nokogiri/xml/builder.rb#456
  def method_missing(method, *args, &block); end
end

class Nokogiri::XML::CDATA < ::Nokogiri::XML::Text
  # Get the name of this CDATA node
  #
  # source://nokogiri//lib/nokogiri/xml/cdata.rb#8
  def name; end

  class << self
    def new(*_arg0); end
  end
end

class Nokogiri::XML::CharacterData < ::Nokogiri::XML::Node
  include ::Nokogiri::XML::PP::CharacterData
end

class Nokogiri::XML::Comment < ::Nokogiri::XML::CharacterData
  class << self
    def new(*_arg0); end
  end
end

class Nokogiri::XML::DTD < ::Nokogiri::XML::Node
  def attributes; end

  # source://nokogiri//lib/nokogiri/xml/dtd.rb#17
  def each; end

  def elements; end
  def entities; end
  def external_id; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/dtd.rb#27
  def html5_dtd?; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/dtd.rb#23
  def html_dtd?; end

  # source://nokogiri//lib/nokogiri/xml/dtd.rb#13
  def keys; end

  def notations; end
  def system_id; end
  def validate(_arg0); end
end

# Nokogiri::XML::Document is the main entry point for dealing with XML documents.  The Document
# is created by parsing an XML document.  See Nokogiri::XML::Document.parse for more information
# on parsing.
#
# For searching a Document, see Nokogiri::XML::Searchable#css and
# Nokogiri::XML::Searchable#xpath
class Nokogiri::XML::Document < ::Nokogiri::XML::Node
  # @return [Document] a new instance of Document
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#168
  def initialize(*args); end

  # source://nokogiri//lib/nokogiri/xml/document.rb#384
  def <<(node_or_tags); end

  # source://nokogiri//lib/nokogiri/xml/document.rb#384
  def add_child(node_or_tags); end

  def canonicalize(*_arg0); end
  def clone(*_arg0); end

  # :call-seq:
  #   collect_namespaces() → Hash<String(Namespace#prefix) ⇒ String(Namespace#href)>
  #
  # Recursively get all namespaces from this node and its subtree and return them as a
  # hash.
  #
  # ⚠ This method will not handle duplicate namespace prefixes, since the return value is a hash.
  #
  # Note that this method does an xpath lookup for nodes with namespaces, and as a result the
  # order (and which duplicate prefix "wins") may be dependent on the implementation of the
  # underlying XML library.
  #
  # *Example:* Basic usage
  #
  # Given this document:
  #
  #   <root xmlns="default" xmlns:foo="bar">
  #     <bar xmlns:hello="world" />
  #   </root>
  #
  # This method will return:
  #
  #   {"xmlns:foo"=>"bar", "xmlns"=>"default", "xmlns:hello"=>"world"}
  #
  # *Example:* Duplicate prefixes
  #
  # Given this document:
  #
  #   <root xmlns:foo="bar">
  #     <bar xmlns:foo="baz" />
  #   </root>
  #
  # The hash returned will be something like:
  #
  #   {"xmlns:foo" => "baz"}
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#307
  def collect_namespaces; end

  # Create a CDATA Node containing +string+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#252
  def create_cdata(string, &block); end

  # Create a Comment Node containing +string+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#257
  def create_comment(string, &block); end

  # :call-seq:
  #   create_element(name, *contents_or_attrs, &block) → Nokogiri::XML::Element
  #
  # Create a new Element with `name` belonging to this document, optionally setting contents or
  # attributes.
  #
  # This method is _not_ the most user-friendly option if your intention is to add a node to the
  # document tree. Prefer one of the Nokogiri::XML::Node methods like Node#add_child,
  # Node#add_next_sibling, Node#replace, etc. which will both create an element (or subtree) and
  # place it in the document tree.
  #
  # Arguments may be passed to initialize the element:
  #
  # - a Hash argument will be used to set attributes
  # - a non-Hash object that responds to \#to_s will be used to set the new node's contents
  #
  # A block may be passed to mutate the node.
  #
  # [Parameters]
  # - `name` (String)
  # - `contents_or_attrs` (\#to_s, Hash)
  # [Yields] `node` (Nokogiri::XML::Element)
  # [Returns] Nokogiri::XML::Element
  #
  # *Example:* An empty element without attributes
  #
  #   doc.create_element("div")
  #   # => <div></div>
  #
  # *Example:* An element with contents
  #
  #   doc.create_element("div", "contents")
  #   # => <div>contents</div>
  #
  # *Example:* An element with attributes
  #
  #   doc.create_element("div", {"class" => "container"})
  #   # => <div class='container'></div>
  #
  # *Example:* An element with contents and attributes
  #
  #   doc.create_element("div", "contents", {"class" => "container"})
  #   # => <div class='container'>contents</div>
  #
  # *Example:* Passing a block to mutate the element
  #
  #   doc.create_element("div") { |node| node["class"] = "blue" if before_noon? }
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#222
  def create_element(name, *contents_or_attrs, &block); end

  def create_entity(*_arg0); end

  # Create a Text Node with +string+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#247
  def create_text_node(string, &block); end

  # Apply any decorators to +node+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#355
  def decorate(node); end

  # Get the list of decorators given +key+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#314
  def decorators(key); end

  # A reference to +self+
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#267
  def document; end

  def dup(*_arg0); end
  def encoding; end
  def encoding=(_arg0); end

  # The errors found while parsing a document.
  #
  # [Returns] Array<Nokogiri::XML::SyntaxError>
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#119
  def errors; end

  # The errors found while parsing a document.
  #
  # [Returns] Array<Nokogiri::XML::SyntaxError>
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#119
  def errors=(_arg0); end

  # Create a Nokogiri::XML::DocumentFragment from +tags+
  # Returns an empty fragment if +tags+ is nil.
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#376
  def fragment(tags = T.unsafe(nil)); end

  # The name of this document.  Always returns "document"
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#262
  def name; end

  # When `true`, reparented elements without a namespace will inherit their new parent's
  # namespace (if one exists). Defaults to `false`.
  #
  # [Returns] Boolean
  #
  # *Example:* Default behavior of namespace inheritance
  #
  #   xml = <<~EOF
  #           <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #             <foo:parent>
  #             </foo:parent>
  #           </root>
  #         EOF
  #   doc = Nokogiri::XML(xml)
  #   parent = doc.at_xpath("//foo:parent", "foo" => "http://nokogiri.org/default_ns/test/foo")
  #   parent.add_child("<child></child>")
  #   doc.to_xml
  #   # => <?xml version="1.0"?>
  #   #    <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #   #      <foo:parent>
  #   #        <child/>
  #   #      </foo:parent>
  #   #    </root>
  #
  # *Example:* Setting namespace inheritance to `true`
  #
  #   xml = <<~EOF
  #           <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #             <foo:parent>
  #             </foo:parent>
  #           </root>
  #         EOF
  #   doc = Nokogiri::XML(xml)
  #   doc.namespace_inheritance = true
  #   parent = doc.at_xpath("//foo:parent", "foo" => "http://nokogiri.org/default_ns/test/foo")
  #   parent.add_child("<child></child>")
  #   doc.to_xml
  #   # => <?xml version="1.0"?>
  #   #    <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #   #      <foo:parent>
  #   #        <foo:child/>
  #   #      </foo:parent>
  #   #    </root>
  #
  # Since v1.12.4
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#166
  def namespace_inheritance; end

  # When `true`, reparented elements without a namespace will inherit their new parent's
  # namespace (if one exists). Defaults to `false`.
  #
  # [Returns] Boolean
  #
  # *Example:* Default behavior of namespace inheritance
  #
  #   xml = <<~EOF
  #           <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #             <foo:parent>
  #             </foo:parent>
  #           </root>
  #         EOF
  #   doc = Nokogiri::XML(xml)
  #   parent = doc.at_xpath("//foo:parent", "foo" => "http://nokogiri.org/default_ns/test/foo")
  #   parent.add_child("<child></child>")
  #   doc.to_xml
  #   # => <?xml version="1.0"?>
  #   #    <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #   #      <foo:parent>
  #   #        <child/>
  #   #      </foo:parent>
  #   #    </root>
  #
  # *Example:* Setting namespace inheritance to `true`
  #
  #   xml = <<~EOF
  #           <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #             <foo:parent>
  #             </foo:parent>
  #           </root>
  #         EOF
  #   doc = Nokogiri::XML(xml)
  #   doc.namespace_inheritance = true
  #   parent = doc.at_xpath("//foo:parent", "foo" => "http://nokogiri.org/default_ns/test/foo")
  #   parent.add_child("<child></child>")
  #   doc.to_xml
  #   # => <?xml version="1.0"?>
  #   #    <root xmlns:foo="http://nokogiri.org/default_ns/test/foo">
  #   #      <foo:parent>
  #   #        <foo:child/>
  #   #      </foo:parent>
  #   #    </root>
  #
  # Since v1.12.4
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#166
  def namespace_inheritance=(_arg0); end

  # Get the hash of namespaces on the root Nokogiri::XML::Node
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#369
  def namespaces; end

  def remove_namespaces!; end
  def root; end
  def root=(_arg0); end

  # Explore a document with shortcut methods. See Nokogiri::Slop for details.
  #
  # Note that any nodes that have been instantiated before #slop!
  # is called will not be decorated with sloppy behavior. So, if you're in
  # irb, the preferred idiom is:
  #
  #   irb> doc = Nokogiri::Slop my_markup
  #
  # and not
  #
  #   irb> doc = Nokogiri::HTML my_markup
  #   ... followed by irb's implicit inspect (and therefore instantiation of every node) ...
  #   irb> doc.slop!
  #   ... which does absolutely nothing.
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#344
  def slop!; end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1187
  def to_xml(*args, &block); end

  def url; end

  # Validate this Document against it's DTD.  Returns a list of errors on
  # the document or +nil+ when there is no DTD.
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#322
  def validate; end

  def version; end

  # :call-seq:
  #   xpath_doctype() → Nokogiri::CSS::XPathVisitor::DoctypeConfig
  #
  # [Returns] The document type which determines CSS-to-XPath translation.
  #
  # See XPathVisitor for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/document.rb#404
  def xpath_doctype; end

  private

  # source://nokogiri//lib/nokogiri/xml/document.rb#418
  def inspect_attributes; end

  class << self
    # @return [Boolean]
    #
    # source://nokogiri//lib/nokogiri/xml/document.rb#410
    def empty_doc?(string_or_io); end

    def new(*_arg0); end

    # Parse an XML file.
    #
    # +string_or_io+ may be a String, or any object that responds to
    # _read_ and _close_ such as an IO, or StringIO.
    #
    # +url+ (optional) is the URI where this document is located.
    #
    # +encoding+ (optional) is the encoding that should be used when processing
    # the document.
    #
    # +options+ (optional) is a configuration object that sets options during
    # parsing, such as Nokogiri::XML::ParseOptions::RECOVER. See the
    # Nokogiri::XML::ParseOptions for more information.
    #
    # +block+ (optional) is passed a configuration object on which
    # parse options may be set.
    #
    # By default, Nokogiri treats documents as untrusted, and so
    # does not attempt to load DTDs or access the network. See
    # Nokogiri::XML::ParseOptions for a complete list of options;
    # and that module's DEFAULT_XML constant for what's set (and not
    # set) by default.
    #
    # Nokogiri.XML() is a convenience method which will call this method.
    #
    # @yield [options]
    #
    # source://nokogiri//lib/nokogiri/xml/document.rb#48
    def parse(string_or_io, url = T.unsafe(nil), encoding = T.unsafe(nil), options = T.unsafe(nil)); end

    def read_io(_arg0, _arg1, _arg2, _arg3); end
    def read_memory(_arg0, _arg1, _arg2, _arg3); end
  end
end

# source://nokogiri//lib/nokogiri/xml/document.rb#416
Nokogiri::XML::Document::IMPLIED_XPATH_CONTEXTS = T.let(T.unsafe(nil), Array)

# source://nokogiri//lib/nokogiri/xml/document.rb#19
Nokogiri::XML::Document::NCNAME_CHAR = T.let(T.unsafe(nil), String)

# source://nokogiri//lib/nokogiri/xml/document.rb#20
Nokogiri::XML::Document::NCNAME_RE = T.let(T.unsafe(nil), Regexp)

# See http://www.w3.org/TR/REC-xml-names/#ns-decl for more details. Note that we're not
# attempting to handle unicode characters partly because libxml2 doesn't handle unicode
# characters in NCNAMEs.
#
# source://nokogiri//lib/nokogiri/xml/document.rb#18
Nokogiri::XML::Document::NCNAME_START_CHAR = T.let(T.unsafe(nil), String)

class Nokogiri::XML::DocumentFragment < ::Nokogiri::XML::Node
  # Create a new DocumentFragment from +tags+.
  #
  #  If +ctx+ is present, it is used as a context node for the
  #  subtree created, e.g., namespaces will be resolved relative
  #  to +ctx+.
  #
  # @return [DocumentFragment] a new instance of DocumentFragment
  # @yield [options]
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#18
  def initialize(document, tags = T.unsafe(nil), ctx = T.unsafe(nil), options = T.unsafe(nil)); end

  # call-seq: css *rules, [namespace-bindings, custom-pseudo-class]
  #
  # Search this fragment for CSS +rules+. +rules+ must be one or more CSS
  # selectors. For example:
  #
  # For more information see Nokogiri::XML::Searchable#css
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#105
  def css(*args); end

  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#41
  def dup; end

  # A list of Nokogiri::XML::SyntaxError found when parsing a document
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#139
  def errors; end

  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#143
  def errors=(things); end

  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#147
  def fragment(data); end

  # return the name for DocumentFragment
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#53
  def name; end

  # call-seq: search *paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class]
  #
  # Search this fragment for +paths+. +paths+ must be one or more XPath or CSS queries.
  #
  # For more information see Nokogiri::XML::Searchable#search
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#124
  def search(*rules); end

  # Convert this DocumentFragment to a string
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#59
  def serialize; end

  # Convert this DocumentFragment to html
  # See Nokogiri::XML::NodeSet#to_html
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#66
  def to_html(*args); end

  # Convert this DocumentFragment to a string
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#59
  def to_s; end

  # Convert this DocumentFragment to xhtml
  # See Nokogiri::XML::NodeSet#to_xhtml
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#80
  def to_xhtml(*args); end

  # Convert this DocumentFragment to xml
  # See Nokogiri::XML::NodeSet#to_xml
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#94
  def to_xml(*args); end

  private

  # fix for issue 770
  #
  # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#154
  def namespace_declarations(ctx); end

  class << self
    def new(*_arg0); end

    # Create a Nokogiri::XML::DocumentFragment from +tags+
    #
    # source://nokogiri//lib/nokogiri/xml/document_fragment.rb#8
    def parse(tags, options = T.unsafe(nil), &block); end
  end
end

class Nokogiri::XML::Element < ::Nokogiri::XML::Node; end

# Represents the allowed content in an Element Declaration inside a DTD:
#
#   <?xml version="1.0"?><?TEST-STYLE PIDATA?>
#   <!DOCTYPE staff SYSTEM "staff.dtd" [
#      <!ELEMENT div1 (head, (p | list | note)*, div2*)>
#   ]>
#   </root>
#
# ElementContent represents the tree inside the <!ELEMENT> tag shown above
# that lists the possible content for the div1 tag.
class Nokogiri::XML::ElementContent
  # Get the children of this ElementContent node
  #
  # source://nokogiri//lib/nokogiri/xml/element_content.rb#33
  def children; end

  # Returns the value of attribute document.
  #
  # source://nokogiri//lib/nokogiri/xml/element_content.rb#29
  def document; end

  def name; end
  def occur; end
  def prefix; end
  def type; end

  private

  def c1; end
  def c2; end
end

# source://nokogiri//lib/nokogiri/xml/element_content.rb#19
Nokogiri::XML::ElementContent::ELEMENT = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/element_content.rb#26
Nokogiri::XML::ElementContent::MULT = T.let(T.unsafe(nil), Integer)

# Possible content occurrences
#
# source://nokogiri//lib/nokogiri/xml/element_content.rb#24
Nokogiri::XML::ElementContent::ONCE = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/element_content.rb#25
Nokogiri::XML::ElementContent::OPT = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/element_content.rb#21
Nokogiri::XML::ElementContent::OR = T.let(T.unsafe(nil), Integer)

# Possible definitions of type
#
# source://nokogiri//lib/nokogiri/xml/element_content.rb#18
Nokogiri::XML::ElementContent::PCDATA = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/element_content.rb#27
Nokogiri::XML::ElementContent::PLUS = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/element_content.rb#20
Nokogiri::XML::ElementContent::SEQ = T.let(T.unsafe(nil), Integer)

class Nokogiri::XML::ElementDecl < ::Nokogiri::XML::Node
  def content; end
  def element_type; end

  # source://nokogiri//lib/nokogiri/xml/element_decl.rb#10
  def inspect; end

  def prefix; end
end

class Nokogiri::XML::EntityDecl < ::Nokogiri::XML::Node
  def content; end
  def entity_type; end
  def external_id; end

  # source://nokogiri//lib/nokogiri/xml/entity_decl.rb#16
  def inspect; end

  def original_content; end
  def system_id; end

  class << self
    # source://nokogiri//lib/nokogiri/xml/entity_decl.rb#12
    def new(name, doc, *args); end
  end
end

Nokogiri::XML::EntityDecl::EXTERNAL_GENERAL_PARSED = T.let(T.unsafe(nil), Integer)
Nokogiri::XML::EntityDecl::EXTERNAL_GENERAL_UNPARSED = T.let(T.unsafe(nil), Integer)
Nokogiri::XML::EntityDecl::EXTERNAL_PARAMETER = T.let(T.unsafe(nil), Integer)
Nokogiri::XML::EntityDecl::INTERNAL_GENERAL = T.let(T.unsafe(nil), Integer)
Nokogiri::XML::EntityDecl::INTERNAL_PARAMETER = T.let(T.unsafe(nil), Integer)
Nokogiri::XML::EntityDecl::INTERNAL_PREDEFINED = T.let(T.unsafe(nil), Integer)

class Nokogiri::XML::EntityReference < ::Nokogiri::XML::Node
  # source://nokogiri//lib/nokogiri/xml/entity_reference.rb#6
  def children; end

  # source://nokogiri//lib/nokogiri/xml/entity_reference.rb#15
  def inspect_attributes; end

  class << self
    def new(*_arg0); end
  end
end

class Nokogiri::XML::Namespace
  include ::Nokogiri::XML::PP::Node

  # Returns the value of attribute document.
  #
  # source://nokogiri//lib/nokogiri/xml/namespace.rb#7
  def document; end

  def href; end
  def prefix; end

  private

  # source://nokogiri//lib/nokogiri/xml/namespace.rb#11
  def inspect_attributes; end
end

# Nokogiri::XML::Node is the primary API you'll use to interact with your Document.
#
# == Attributes
#
# A Nokogiri::XML::Node may be treated similarly to a hash with regard to attributes. For
# example:
#
#   node = Nokogiri::XML::DocumentFragment.parse("<a href='#foo' id='link'>link</a>").at_css("a")
#   node.to_html # => "<a href=\"#foo\" id=\"link\">link</a>"
#   node['href'] # => "#foo"
#   node.keys # => ["href", "id"]
#   node.values # => ["#foo", "link"]
#   node['class'] = 'green' # => "green"
#   node.to_html # => "<a href=\"#foo\" id=\"link\" class=\"green\">link</a>"
#
# See the method group entitled Node@Working+With+Node+Attributes for the full set of methods.
#
# == Navigation
#
# Nokogiri::XML::Node also has methods that let you move around your tree:
#
# [#parent, #children, #next, #previous]
#   Navigate up, down, or through siblings.
#
# See the method group entitled Node@Traversing+Document+Structure for the full set of methods.
#
# == Serialization
#
# When printing or otherwise emitting a document or a node (and its subtree), there are a few
# methods you might want to use:
#
# [#content, #text, #inner_text, #to_str]
#   These methods will all **emit plaintext**,
#   meaning that entities will be replaced (e.g., +&lt;+ will be replaced with +<+), meaning
#   that any sanitizing will likely be un-done in the output.
#
# [#to_s, #to_xml, #to_html, #inner_html]
#   These methods will all **emit properly-escaped markup**, meaning that it's suitable for
#   consumption by browsers, parsers, etc.
#
# See the method group entitled Node@Serialization+and+Generating+Output for the full set of methods.
#
# == Searching
#
# You may search this node's subtree using methods like #xpath and #css.
#
# See the method group entitled Node@Searching+via+XPath+or+CSS+Queries for the full set of methods.
class Nokogiri::XML::Node
  include ::Nokogiri::HTML5::Node
  include ::Nokogiri::XML::PP::Node
  include ::Nokogiri::XML::Searchable
  include ::Nokogiri::ClassResolver
  include ::Enumerable

  # :call-seq:
  #   new(name, document) -> Nokogiri::XML::Node
  #   new(name, document) { |node| ... } -> Nokogiri::XML::Node
  #
  # Create a new node with +name+ that belongs to +document+.
  #
  # If you intend to add a node to a document tree, it's likely that you will prefer one of the
  # Nokogiri::XML::Node methods like #add_child, #add_next_sibling, #replace, etc. which will
  # both create an element (or subtree) and place it in the document tree.
  #
  # Another alternative, if you are concerned about performance, is
  # Nokogiri::XML::Document#create_element which accepts additional arguments for contents or
  # attributes but (like this method) avoids parsing markup.
  #
  # [Parameters]
  # - +name+ (String)
  # - +document+ (Nokogiri::XML::Document) The document to which the the returned node will belong.
  # [Yields] Nokogiri::XML::Node
  # [Returns] Nokogiri::XML::Node
  #
  # @return [Node] a new instance of Node
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#126
  def initialize(name, document); end

  # Add +node_or_tags+ as a child of this Node.
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns self, to support chaining of calls (e.g., root << child1 << child2)
  #
  # Also see related method +add_child+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#191
  def <<(node_or_tags); end

  # Compare two Node objects with respect to their Document.  Nodes from
  # different documents cannot be compared.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1163
  def <=>(other); end

  # Test to see if this Node is equal to +other+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1153
  def ==(other); end

  # :call-seq: [](name) → (String, nil)
  #
  # Fetch an attribute from this node.
  #
  # ⚠ Note that attributes with namespaces cannot be accessed with this method. To access
  # namespaced attributes, use #attribute_with_ns.
  #
  # [Returns] (String, nil) value of the attribute +name+, or +nil+ if no matching attribute exists
  #
  # *Example*
  #
  #   doc = Nokogiri::XML("<root><child size='large' class='big wide tall'/></root>")
  #   child = doc.at_css("child")
  #   child["size"] # => "large"
  #   child["class"] # => "big wide tall"
  #
  # *Example:* Namespaced attributes will not be returned.
  #
  # ⚠ Note namespaced attributes may be accessed with #attribute or #attribute_with_ns
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'>
  #       <child width:size='broad'/>
  #     </root>
  #   EOF
  #   doc.at_css("child")["size"] # => nil
  #   doc.at_css("child").attribute("size").value # => "broad"
  #   doc.at_css("child").attribute_with_ns("size", "http://example.com/widths").value
  #   # => "broad"
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#419
  def [](name); end

  # :call-seq: []=(name, value) → value
  #
  # Update the attribute +name+ to +value+, or create the attribute if it does not exist.
  #
  # ⚠ Note that attributes with namespaces cannot be accessed with this method. To access
  # namespaced attributes for update, use #attribute_with_ns. To add a namespaced attribute,
  # see the example below.
  #
  # [Returns] +value+
  #
  # *Example*
  #
  #   doc = Nokogiri::XML("<root><child/></root>")
  #   child = doc.at_css("child")
  #   child["size"] = "broad"
  #   child.to_html
  #   # => "<child size=\"broad\"></child>"
  #
  # *Example:* Add a namespaced attribute.
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'>
  #       <child/>
  #     </root>
  #   EOF
  #   child = doc.at_css("child")
  #   child["size"] = "broad"
  #   ns = doc.root.namespace_definitions.find { |ns| ns.prefix == "width" }
  #   child.attribute("size").namespace = ns
  #   doc.to_html
  #   # => "<root xmlns:width=\"http://example.com/widths\">\n" +
  #   #    "  <child width:size=\"broad\"></child>\n" +
  #   #    "</root>\n"
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#457
  def []=(name, value); end

  # Accept a visitor.  This method calls "visit" on +visitor+ with self.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1147
  def accept(visitor); end

  # Add +node_or_tags+ as a child of this Node.
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +<<+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#145
  def add_child(node_or_tags); end

  # :call-seq: add_class(names) → self
  #
  # Ensure HTML CSS classes are present on +self+. Any CSS classes in +names+ that already exist
  # in the "class" attribute are _not_ added. Note that any existing duplicates in the
  # "class" attribute are not removed. Compare with #append_class.
  #
  # This is a convenience function and is equivalent to:
  #
  #   node.kwattr_add("class", names)
  #
  # See related: #kwattr_add, #classes, #append_class, #remove_class
  #
  # [Parameters]
  # - +names+ (String, Array<String>)
  #
  #   CSS class names to be added to the Node's "class" attribute. May be a string containing
  #   whitespace-delimited names, or an Array of String names. Any class names already present
  #   will not be added. Any class names not present will be added. If no "class" attribute
  #   exists, one is created.
  #
  # [Returns] +self+ (Node) for ease of chaining method calls.
  #
  # *Example:* Ensure that the node has CSS class "section"
  #
  #   node                      # => <div></div>
  #   node.add_class("section") # => <div class="section"></div>
  #   node.add_class("section") # => <div class="section"></div> # duplicate not added
  #
  # *Example:* Ensure that the node has CSS classes "section" and "header", via a String argument
  #
  # Note that the CSS class "section" is not added because it is already present.
  # Note also that the pre-existing duplicate CSS class "section" is not removed.
  #
  #   node                             # => <div class="section section"></div>
  #   node.add_class("section header") # => <div class="section section header"></div>
  #
  # *Example:* Ensure that the node has CSS classes "section" and "header", via an Array argument
  #
  #   node                                  # => <div></div>
  #   node.add_class(["section", "header"]) # => <div class="section header"></div>
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#622
  def add_class(names); end

  def add_namespace(_arg0, _arg1); end
  def add_namespace_definition(_arg0, _arg1); end

  # Insert +node_or_tags+ after this Node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +after+.
  #
  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#217
  def add_next_sibling(node_or_tags); end

  # Insert +node_or_tags+ before this Node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +before+.
  #
  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#203
  def add_previous_sibling(node_or_tags); end

  # Insert +node_or_tags+ after this node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a Nokogiri::XML::DocumentFragment, or a string containing markup.
  #
  # Returns self, to support chaining of calls.
  #
  # Also see related method +add_next_sibling+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#243
  def after(node_or_tags); end

  # Get a list of ancestor Node for this Node.  If +selector+ is given,
  # the ancestors must match +selector+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1116
  def ancestors(selector = T.unsafe(nil)); end

  # :call-seq: append_class(names) → self
  #
  # Add HTML CSS classes to +self+, regardless of duplication. Compare with #add_class.
  #
  # This is a convenience function and is equivalent to:
  #
  #   node.kwattr_append("class", names)
  #
  # See related: #kwattr_append, #classes, #add_class, #remove_class
  #
  # [Parameters]
  # - +names+ (String, Array<String>)
  #
  #   CSS class names to be appended to the Node's "class" attribute. May be a string containing
  #   whitespace-delimited names, or an Array of String names. All class names passed in will be
  #   appended to the "class" attribute even if they are already present in the attribute
  #   value. If no "class" attribute exists, one is created.
  #
  # [Returns] +self+ (Node) for ease of chaining method calls.
  #
  # *Example:* Append "section" to the node's CSS "class" attribute
  #
  #   node                         # => <div></div>
  #   node.append_class("section") # => <div class="section"></div>
  #   node.append_class("section") # => <div class="section section"></div> # duplicate added!
  #
  # *Example:* Append "section" and "header" to the noded's CSS "class" attribute, via a String argument
  #
  # Note that the CSS class "section" is appended even though it is already present
  #
  #   node                                # => <div class="section section"></div>
  #   node.append_class("section header") # => <div class="section section section header"></div>
  #
  # *Example:* Append "section" and "header" to the node's CSS "class" attribute, via an Array argument
  #
  #   node                                     # => <div></div>
  #   node.append_class(["section", "header"]) # => <div class="section header"></div>
  #   node.append_class(["section", "header"]) # => <div class="section header section header"></div>
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#666
  def append_class(names); end

  # :call-seq: [](name) → (String, nil)
  #
  # Fetch an attribute from this node.
  #
  # ⚠ Note that attributes with namespaces cannot be accessed with this method. To access
  # namespaced attributes, use #attribute_with_ns.
  #
  # [Returns] (String, nil) value of the attribute +name+, or +nil+ if no matching attribute exists
  #
  # *Example*
  #
  #   doc = Nokogiri::XML("<root><child size='large' class='big wide tall'/></root>")
  #   child = doc.at_css("child")
  #   child["size"] # => "large"
  #   child["class"] # => "big wide tall"
  #
  # *Example:* Namespaced attributes will not be returned.
  #
  # ⚠ Note namespaced attributes may be accessed with #attribute or #attribute_with_ns
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'>
  #       <child width:size='broad'/>
  #     </root>
  #   EOF
  #   doc.at_css("child")["size"] # => nil
  #   doc.at_css("child").attribute("size").value # => "broad"
  #   doc.at_css("child").attribute_with_ns("size", "http://example.com/widths").value
  #   # => "broad"
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#419
  def attr(name); end

  def attribute(_arg0); end
  def attribute_nodes; end
  def attribute_with_ns(_arg0, _arg1); end

  # :call-seq: attributes() → Hash<String ⇒ Nokogiri::XML::Attr>
  #
  # Fetch this node's attributes.
  #
  # ⚠ Because the keys do not include any namespace information for the attribute, in case of a
  # simple name collision, not all attributes will be returned. In this case, you will need to
  # use #attribute_nodes.
  #
  # [Returns]
  #   Hash containing attributes belonging to +self+. The hash keys are String attribute
  #   names (without the namespace), and the hash values are Nokogiri::XML::Attr.
  #
  # *Example* with no namespaces:
  #
  #   doc = Nokogiri::XML("<root><child size='large' class='big wide tall'/></root>")
  #   doc.at_css("child").attributes
  #   # => {"size"=>#(Attr:0x550 { name = "size", value = "large" }),
  #   #     "class"=>#(Attr:0x564 { name = "class", value = "big wide tall" })}
  #
  # *Example* with a namespace:
  #
  #   doc = Nokogiri::XML("<root xmlns:desc='http://example.com/sizes'><child desc:size='large'/></root>")
  #   doc.at_css("child").attributes
  #   # => {"size"=>
  #   #      #(Attr:0x550 {
  #   #        name = "size",
  #   #        namespace = #(Namespace:0x564 {
  #   #          prefix = "desc",
  #   #          href = "http://example.com/sizes"
  #   #          }),
  #   #        value = "large"
  #   #        })}
  #
  # *Example* with an attribute name collision:
  #
  # ⚠ Note that only one of the attributes is returned in the Hash.
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'
  #           xmlns:height='http://example.com/heights'>
  #       <child width:size='broad' height:size='tall'/>
  #     </root>
  #   EOF
  #   doc.at_css("child").attributes
  #   # => {"size"=>
  #   #      #(Attr:0x550 {
  #   #        name = "size",
  #   #        namespace = #(Namespace:0x564 {
  #   #          prefix = "height",
  #   #          href = "http://example.com/heights"
  #   #          }),
  #   #        value = "tall"
  #   #        })}
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#516
  def attributes; end

  # Insert +node_or_tags+ before this node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns self, to support chaining of calls.
  #
  # Also see related method +add_previous_sibling+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#231
  def before(node_or_tags); end

  def blank?; end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1306
  def canonicalize(mode = T.unsafe(nil), inclusive_namespaces = T.unsafe(nil), with_comments = T.unsafe(nil)); end

  # Returns true if this is a CDATA
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1037
  def cdata?; end

  def child; end
  def children; end

  # Set the inner html for this Node +node_or_tags+
  # +node_or_tags+ can be a Nokogiri::XML::Node, a Nokogiri::XML::DocumentFragment, or a string containing markup.
  #
  # Also see related method +inner_html=+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#262
  def children=(node_or_tags); end

  # :call-seq: classes() → Array<String>
  #
  # Fetch CSS class names of a Node.
  #
  # This is a convenience function and is equivalent to:
  #
  #   node.kwattr_values("class")
  #
  # See related: #kwattr_values, #add_class, #append_class, #remove_class
  #
  # [Returns]
  #   The CSS classes (Array of String) present in the Node's "class" attribute. If the
  #   attribute is empty or non-existent, the return value is an empty array.
  #
  # *Example*
  #
  #   node         # => <div class="section title header"></div>
  #   node.classes # => ["section", "title", "header"]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#576
  def classes; end

  def clone(*_arg0); end

  # Returns true if this is a Comment
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1032
  def comment?; end

  def content; end

  # Set the Node's content to a Text node containing +string+. The string gets XML escaped, not interpreted as markup.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#318
  def content=(string); end

  def create_external_subset(_arg0, _arg1, _arg2); end
  def create_internal_subset(_arg0, _arg1, _arg2); end

  # Get the path to this node as a CSS expression
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1107
  def css_path; end

  # Decorate this node with the decorators set up in this node's Document
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#132
  def decorate!; end

  # Adds a default namespace supplied as a string +url+ href, to self.
  # The consequence is as an xmlns attribute with supplied argument were
  # present in parsed XML.  A default namespace set with this method will
  # now show up in #attributes, but when this node is serialized to XML an
  # "xmlns" attribute will appear. See also #namespace and #namespace=
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#334
  def default_namespace=(url); end

  # Remove the attribute named +name+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#550
  def delete(name); end

  # Fetch the Nokogiri::HTML4::ElementDescription for this node.  Returns
  # nil on XML documents and on unknown tags.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1074
  def description; end

  # Do xinclude substitution on the subtree below node. If given a block, a
  # Nokogiri::XML::ParseOptions object initialized from +options+, will be
  # passed to it, allowing more convenient modification of the parser options.
  #
  # @yield [options]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#361
  def do_xinclude(options = T.unsafe(nil)); end

  def document; end

  # Returns true if this is a Document
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1052
  def document?; end

  def dup(*_arg0); end

  # Iterate over each attribute name and value pair for this Node.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#542
  def each; end

  # Returns true if this is an Element node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1088
  def elem?; end

  # Returns true if this is an Element node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1088
  def element?; end

  def element_children; end
  def elements; end
  def encode_special_chars(_arg0); end
  def external_subset; end
  def first_element_child; end

  # Create a DocumentFragment containing +tags+ that is relative to _this_
  # context node.
  #
  # source://nokogiri//lib/nokogiri/html5/node.rb#67
  def fragment(tags); end

  # Returns true if this is a DocumentFragment
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1067
  def fragment?; end

  # :call-seq: [](name) → (String, nil)
  #
  # Fetch an attribute from this node.
  #
  # ⚠ Note that attributes with namespaces cannot be accessed with this method. To access
  # namespaced attributes, use #attribute_with_ns.
  #
  # [Returns] (String, nil) value of the attribute +name+, or +nil+ if no matching attribute exists
  #
  # *Example*
  #
  #   doc = Nokogiri::XML("<root><child size='large' class='big wide tall'/></root>")
  #   child = doc.at_css("child")
  #   child["size"] # => "large"
  #   child["class"] # => "big wide tall"
  #
  # *Example:* Namespaced attributes will not be returned.
  #
  # ⚠ Note namespaced attributes may be accessed with #attribute or #attribute_with_ns
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'>
  #       <child width:size='broad'/>
  #     </root>
  #   EOF
  #   doc.at_css("child")["size"] # => nil
  #   doc.at_css("child").attribute("size").value # => "broad"
  #   doc.at_css("child").attribute_with_ns("size", "http://example.com/widths").value
  #   # => "broad"
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#419
  def get_attribute(name); end

  def has_attribute?(_arg0); end

  # Returns true if this is an HTML4::Document or HTML5::Document node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1047
  def html?; end

  # Get the inner_html for this node's Node#children
  #
  # source://nokogiri//lib/nokogiri/html5/node.rb#28
  def inner_html(options = T.unsafe(nil)); end

  # Set the inner html for this Node to +node_or_tags+
  # +node_or_tags+ can be a Nokogiri::XML::Node, a Nokogiri::XML::DocumentFragment, or a string containing markup.
  #
  # Also see related method +children=+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#253
  def inner_html=(node_or_tags); end

  # :section:
  def inner_text; end

  def internal_subset; end
  def key?(_arg0); end

  # Get the attribute names for this Node.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#536
  def keys; end

  # :call-seq:
  #   kwattr_add(attribute_name, keywords) → self
  #
  # Ensure that values are present in a keyword attribute.
  #
  # Any values in +keywords+ that already exist in the Node's attribute values are _not_
  # added. Note that any existing duplicates in the attribute values are not removed. Compare
  # with #kwattr_append.
  #
  # A "keyword attribute" is a node attribute that contains a set of space-delimited
  # values. Perhaps the most familiar example of this is the HTML "class" attribute used to
  # contain CSS classes. But other keyword attributes exist, for instance
  # {the "rel" attribute}[https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/rel].
  #
  # See also #add_class, #kwattr_values, #kwattr_append, #kwattr_remove
  #
  # [Parameters]
  # - +attribute_name+ (String) The name of the keyword attribute to be modified.
  # - +keywords+ (String, Array<String>)
  #   Keywords to be added to the attribute named +attribute_name+. May be a string containing
  #   whitespace-delimited values, or an Array of String values. Any values already present will
  #   not be added. Any values not present will be added. If the named attribute does not exist,
  #   it is created.
  #
  # [Returns] +self+ (Nokogiri::XML::Node) for ease of chaining method calls.
  #
  # *Example:* Ensure that a +Node+ has "nofollow" in its +rel+ attribute.
  #
  # Note that duplicates are not added.
  #
  #   node                               # => <a></a>
  #   node.kwattr_add("rel", "nofollow") # => <a rel="nofollow"></a>
  #   node.kwattr_add("rel", "nofollow") # => <a rel="nofollow"></a>
  #
  # *Example:* Ensure that a +Node+ has "nofollow" and "noreferrer" in its +rel+ attribute, via a
  # String argument.
  #
  #  Note that "nofollow" is not added because it is already present. Note also that the
  #  pre-existing duplicate "nofollow" is not removed.
  #
  #   node                                          # => <a rel="nofollow nofollow"></a>
  #   node.kwattr_add("rel", "nofollow noreferrer") # => <a rel="nofollow nofollow noreferrer"></a>
  #
  # *Example:* Ensure that a +Node+ has "nofollow" and "noreferrer" in its +rel+ attribute, via
  # an Array argument.
  #
  #   node                                               # => <a></a>
  #   node.kwattr_add("rel", ["nofollow", "noreferrer"]) # => <a rel="nofollow noreferrer"></a>
  #
  # Since v1.11.0
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#799
  def kwattr_add(attribute_name, keywords); end

  # :call-seq:
  #   kwattr_append(attribute_name, keywords) → self
  #
  # Add keywords to a Node's keyword attribute, regardless of duplication. Compare with
  # #kwattr_add.
  #
  # A "keyword attribute" is a node attribute that contains a set of space-delimited
  # values. Perhaps the most familiar example of this is the HTML "class" attribute used to
  # contain CSS classes. But other keyword attributes exist, for instance
  # {the "rel" attribute}[https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/rel].
  #
  # See also #append_class, #kwattr_values, #kwattr_add, #kwattr_remove
  #
  # [Parameters]
  # - +attribute_name+ (String) The name of the keyword attribute to be modified.
  # - +keywords+ (String, Array<String>)
  #   Keywords to be added to the attribute named +attribute_name+. May be a string containing
  #   whitespace-delimited values, or an Array of String values. All values passed in will be
  #   appended to the named attribute even if they are already present in the attribute. If the
  #   named attribute does not exist, it is created.
  #
  # [Returns] +self+ (Node) for ease of chaining method calls.
  #
  # *Example:* Append "nofollow" to the +rel+ attribute.
  #
  # Note that duplicates are added.
  #
  #   node                                  # => <a></a>
  #   node.kwattr_append("rel", "nofollow") # => <a rel="nofollow"></a>
  #   node.kwattr_append("rel", "nofollow") # => <a rel="nofollow nofollow"></a>
  #
  # *Example:* Append "nofollow" and "noreferrer" to the +rel+ attribute, via a String argument.
  #
  # Note that "nofollow" is appended even though it is already present.
  #
  #   node                                             # => <a rel="nofollow"></a>
  #   node.kwattr_append("rel", "nofollow noreferrer") # => <a rel="nofollow nofollow noreferrer"></a>
  #
  #
  # *Example:* Append "nofollow" and "noreferrer" to the +rel+ attribute, via an Array argument.
  #
  #   node                                                  # => <a></a>
  #   node.kwattr_append("rel", ["nofollow", "noreferrer"]) # => <a rel="nofollow noreferrer"></a>
  #
  # Since v1.11.0
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#852
  def kwattr_append(attribute_name, keywords); end

  # :call-seq:
  #   kwattr_remove(attribute_name, keywords) → self
  #
  # Remove keywords from a keyword attribute. Any matching keywords that exist in the named
  # attribute are removed, including any multiple entries.
  #
  # If no keywords remain after this operation, or if +keywords+ is +nil+, the attribute is
  # deleted from the node.
  #
  # A "keyword attribute" is a node attribute that contains a set of space-delimited
  # values. Perhaps the most familiar example of this is the HTML "class" attribute used to
  # contain CSS classes. But other keyword attributes exist, for instance
  # {the "rel" attribute}[https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/rel].
  #
  # See also #remove_class, #kwattr_values, #kwattr_add, #kwattr_append
  #
  # [Parameters]
  # - +attribute_name+ (String) The name of the keyword attribute to be modified.
  # - +keywords+ (String, Array<String>)
  #   Keywords to be removed from the attribute named +attribute_name+. May be a string
  #   containing whitespace-delimited values, or an Array of String values. Any keywords present
  #   in the named attribute will be removed. If no keywords remain, or if +keywords+ is nil,
  #   the attribute is deleted.
  #
  # [Returns] +self+ (Node) for ease of chaining method calls.
  #
  # *Example:*
  #
  # Note that the +rel+ attribute is deleted when empty.
  #
  #   node                                    # => <a rel="nofollow noreferrer">link</a>
  #   node.kwattr_remove("rel", "nofollow")   # => <a rel="noreferrer">link</a>
  #   node.kwattr_remove("rel", "noreferrer") # => <a>link</a>
  #
  # Since v1.11.0
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#895
  def kwattr_remove(attribute_name, keywords); end

  # :call-seq:
  #   kwattr_values(attribute_name) → Array<String>
  #
  # Fetch values from a keyword attribute of a Node.
  #
  # A "keyword attribute" is a node attribute that contains a set of space-delimited
  # values. Perhaps the most familiar example of this is the HTML "class" attribute used to
  # contain CSS classes. But other keyword attributes exist, for instance
  # {the "rel" attribute}[https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/rel].
  #
  # See also #classes, #kwattr_add, #kwattr_append, #kwattr_remove
  #
  # [Parameters]
  # - +attribute_name+ (String) The name of the keyword attribute to be inspected.
  #
  # [Returns]
  #   (Array<String>) The values present in the Node's +attribute_name+ attribute. If the
  #   attribute is empty or non-existent, the return value is an empty array.
  #
  # *Example:*
  #
  #   node                      # => <a rel="nofollow noopener external">link</a>
  #   node.kwattr_values("rel") # => ["nofollow", "noopener", "external"]
  #
  # Since v1.11.0
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#745
  def kwattr_values(attribute_name); end

  def lang; end
  def lang=(_arg0); end
  def last_element_child; end
  def line; end
  def line=(_arg0); end

  # Returns true if this Node matches +selector+
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#922
  def matches?(selector); end

  def name; end
  def name=(_arg0); end
  def namespace; end

  # Set the default namespace on this node (as would be defined with an
  # "xmlns=" attribute in XML source), as a Namespace object +ns+. Note that
  # a Namespace added this way will NOT be serialized as an xmlns attribute
  # for this node. You probably want #default_namespace= instead, or perhaps
  # #add_namespace_definition with a nil prefix argument.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#344
  def namespace=(ns); end

  def namespace_definitions; end
  def namespace_scopes; end
  def namespaced_key?(_arg0, _arg1); end

  # :call-seq:
  #   namespaces() → Hash<String(Namespace#prefix) ⇒ String(Namespace#href)>
  #
  # Fetch all the namespaces on this node and its ancestors.
  #
  # Note that the keys in this hash XML attributes that would be used to define this namespace,
  # such as "xmlns:prefix", not just the prefix.
  #
  # The default namespace for this node will be included with key "xmlns".
  #
  # See also #namespace_scopes
  #
  # [Returns]
  #   Hash containing all the namespaces on this node and its ancestors. The hash keys are the
  #   namespace prefix, and the hash value for each key is the namespace URI.
  #
  # *Example:*
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns="http://example.com/root" xmlns:in_scope="http://example.com/in_scope">
  #       <first/>
  #       <second xmlns="http://example.com/child"/>
  #       <third xmlns:foo="http://example.com/foo"/>
  #     </root>
  #   EOF
  #   doc.at_xpath("//root:first", "root" => "http://example.com/root").namespaces
  #   # => {"xmlns"=>"http://example.com/root",
  #   #     "xmlns:in_scope"=>"http://example.com/in_scope"}
  #   doc.at_xpath("//child:second", "child" => "http://example.com/child").namespaces
  #   # => {"xmlns"=>"http://example.com/child",
  #   #     "xmlns:in_scope"=>"http://example.com/in_scope"}
  #   doc.at_xpath("//root:third", "root" => "http://example.com/root").namespaces
  #   # => {"xmlns:foo"=>"http://example.com/foo",
  #   #     "xmlns"=>"http://example.com/root",
  #   #     "xmlns:in_scope"=>"http://example.com/in_scope"}
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1023
  def namespaces; end

  def native_content=(_arg0); end
  def next; end

  # Insert +node_or_tags+ after this Node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +after+.
  #
  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#217
  def next=(node_or_tags); end

  def next_element; end
  def next_sibling; end
  def node_name; end
  def node_name=(_arg0); end
  def node_type; end
  def parent; end

  # Set the parent Node for this Node
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#324
  def parent=(parent_node); end

  # Parse +string_or_io+ as a document fragment within the context of
  # *this* node.  Returns a XML::NodeSet containing the nodes parsed from
  # +string_or_io+.
  #
  # @yield [options]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#937
  def parse(string_or_io, options = T.unsafe(nil)); end

  def path; end
  def pointer_id; end

  # Add +node_or_tags+ as the first child of this Node.
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +add_child+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#162
  def prepend_child(node_or_tags); end

  def previous; end

  # Insert +node_or_tags+ before this Node (as a sibling).
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +before+.
  #
  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#203
  def previous=(node_or_tags); end

  def previous_element; end
  def previous_sibling; end

  # Returns true if this is a ProcessingInstruction node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1057
  def processing_instruction?; end

  # Is this a read only node?
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1082
  def read_only?; end

  def remove; end

  # Remove the attribute named +name+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#550
  def remove_attribute(name); end

  # :call-seq:
  #   remove_class(css_classes) → self
  #
  # Remove HTML CSS classes from this node. Any CSS class names in +css_classes+ that exist in
  # this node's "class" attribute are removed, including any multiple entries.
  #
  # If no CSS classes remain after this operation, or if +css_classes+ is +nil+, the "class"
  # attribute is deleted from the node.
  #
  # This is a convenience function and is equivalent to:
  #
  #   node.kwattr_remove("class", css_classes)
  #
  # Also see #kwattr_remove, #classes, #add_class, #append_class
  #
  # [Parameters]
  # - +css_classes+ (String, Array<String>)
  #
  #   CSS class names to be removed from the Node's
  #   "class" attribute. May be a string containing whitespace-delimited names, or an Array of
  #   String names. Any class names already present will be removed. If no CSS classes remain,
  #   the "class" attribute is deleted.
  #
  # [Returns] +self+ (Nokogiri::XML::Node) for ease of chaining method calls.
  #
  # *Example*: Deleting a CSS class
  #
  # Note that all instances of the class "section" are removed from the "class" attribute.
  #
  #   node                         # => <div class="section header section"></div>
  #   node.remove_class("section") # => <div class="header"></div>
  #
  # *Example*: Deleting the only remaining CSS class
  #
  # Note that the attribute is removed once there are no remaining classes.
  #
  #   node                         # => <div class="section"></div>
  #   node.remove_class("section") # => <div></div>
  #
  # *Example*: Deleting multiple CSS classes
  #
  # Note that the "class" attribute is deleted once it's empty.
  #
  #   node                                    # => <div class="section header float"></div>
  #   node.remove_class(["section", "float"]) # => <div class="header"></div>
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#716
  def remove_class(names = T.unsafe(nil)); end

  # Replace this Node with +node_or_tags+.
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns the reparented node (if +node_or_tags+ is a Node), or NodeSet (if +node_or_tags+ is a DocumentFragment, NodeSet, or string).
  #
  # Also see related method +swap+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#279
  def replace(node_or_tags); end

  # Serialize Node using +options+. Save options can also be set using a block.
  #
  # See also Nokogiri::XML::Node::SaveOptions and Node@Serialization+and+Generating+Output.
  #
  # These two statements are equivalent:
  #
  #  node.serialize(:encoding => 'UTF-8', :save_with => FORMAT | AS_XML)
  #
  # or
  #
  #   node.serialize(:encoding => 'UTF-8') do |config|
  #     config.format.as_xml
  #   end
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1187
  def serialize(*args, &block); end

  # :call-seq: []=(name, value) → value
  #
  # Update the attribute +name+ to +value+, or create the attribute if it does not exist.
  #
  # ⚠ Note that attributes with namespaces cannot be accessed with this method. To access
  # namespaced attributes for update, use #attribute_with_ns. To add a namespaced attribute,
  # see the example below.
  #
  # [Returns] +value+
  #
  # *Example*
  #
  #   doc = Nokogiri::XML("<root><child/></root>")
  #   child = doc.at_css("child")
  #   child["size"] = "broad"
  #   child.to_html
  #   # => "<child size=\"broad\"></child>"
  #
  # *Example:* Add a namespaced attribute.
  #
  #   doc = Nokogiri::XML(<<~EOF)
  #     <root xmlns:width='http://example.com/widths'>
  #       <child/>
  #     </root>
  #   EOF
  #   child = doc.at_css("child")
  #   child["size"] = "broad"
  #   ns = doc.root.namespace_definitions.find { |ns| ns.prefix == "width" }
  #   child.attribute("size").namespace = ns
  #   doc.to_html
  #   # => "<root xmlns:width=\"http://example.com/widths\">\n" +
  #   #    "  <child width:size=\"broad\"></child>\n" +
  #   #    "</root>\n"
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#457
  def set_attribute(name, value); end

  # Swap this Node for +node_or_tags+
  # +node_or_tags+ can be a Nokogiri::XML::Node, a ::DocumentFragment, a ::NodeSet, or a string containing markup.
  #
  # Returns self, to support chaining of calls.
  #
  # Also see related method +replace+.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#311
  def swap(node_or_tags); end

  def text; end

  # Returns true if this is a Text node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1062
  def text?; end

  # Serialize this Node to HTML
  #
  #   doc.to_html
  #
  # See Node#write_to for a list of +options+.  For formatted output,
  # use Node#to_xhtml instead.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1214
  def to_html(options = T.unsafe(nil)); end

  # Turn this node in to a string.  If the document is HTML, this method
  # returns html.  If the document is XML, this method returns XML.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1097
  def to_s; end

  def to_str; end

  # Serialize this Node to XHTML using +options+
  #
  #   doc.to_xhtml(:indent => 5, :encoding => 'UTF-8')
  #
  # See Node#write_to for a list of +options+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1235
  def to_xhtml(options = T.unsafe(nil)); end

  # Serialize this Node to XML using +options+
  #
  #   doc.to_xml(:indent => 5, :encoding => 'UTF-8')
  #
  # See Node#write_to for a list of +options+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1224
  def to_xml(options = T.unsafe(nil)); end

  # Yields self and all children to +block+ recursively.
  #
  # @yield [_self]
  # @yieldparam _self [Nokogiri::XML::Node] the object that the method was called on
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1140
  def traverse(&block); end

  def type; end
  def unlink; end

  # Does this Node's attributes include <value>
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#530
  def value?(value); end

  # Get the attribute values for this Node.
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#524
  def values; end

  # Add html around this node
  #
  # Returns self
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#177
  def wrap(html); end

  # Write Node as HTML to +io+ with +options+
  #
  # See Node#write_to for a list of +options+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1283
  def write_html_to(io, options = T.unsafe(nil)); end

  # Write Node to +io+ with +options+. +options+ modify the output of
  # this method.  Valid options are:
  #
  # * +:encoding+ for changing the encoding
  # * +:indent_text+ the indentation text, defaults to one space
  # * +:indent+ the number of +:indent_text+ to use, defaults to 2
  # * +:save_with+ a combination of SaveOptions constants.
  #
  # To save with UTF-8 indented twice:
  #
  #   node.write_to(io, :encoding => 'UTF-8', :indent => 2)
  #
  # To save indented with two dashes:
  #
  #   node.write_to(io, :indent_text => '-', :indent => 2)
  #
  # @yield [config]
  #
  # source://nokogiri//lib/nokogiri/html5/node.rb#36
  def write_to(io, *options); end

  # Write Node as XHTML to +io+ with +options+
  #
  # See Node#write_to for a list of +options+
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1291
  def write_xhtml_to(io, options = T.unsafe(nil)); end

  # Write Node as XML to +io+ with +options+
  #
  #   doc.write_xml_to io, :encoding => 'UTF-8'
  #
  # See Node#write_to for a list of options
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1301
  def write_xml_to(io, options = T.unsafe(nil)); end

  # Returns true if this is an XML::Document node
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1042
  def xml?; end

  protected

  # @raise [ArgumentError]
  #
  # source://nokogiri//lib/nokogiri/xml/node.rb#1318
  def coerce(data); end

  private

  def add_child_node(_arg0); end

  # source://nokogiri//lib/nokogiri/html5/node.rb#80
  def add_child_node_and_reparent_attrs(node); end

  def add_next_sibling_node(_arg0); end
  def add_previous_sibling_node(_arg0); end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1352
  def add_sibling(next_or_previous, node_or_tags); end

  def compare(_arg0); end
  def dump_html; end
  def get(_arg0); end
  def in_context(_arg0, _arg1); end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1391
  def inspect_attributes; end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1340
  def keywordify(keywords); end

  def native_write_to(_arg0, _arg1, _arg2, _arg3); end
  def process_xincludes(_arg0); end
  def replace_node(_arg0); end
  def set(_arg0, _arg1); end
  def set_namespace(_arg0); end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1377
  def to_format(save_option, options); end

  # source://nokogiri//lib/nokogiri/xml/node.rb#1384
  def write_format_to(save_option, io, options); end

  class << self
    def new(*_arg0); end
  end
end

# Attribute declaration type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#93
Nokogiri::XML::Node::ATTRIBUTE_DECL = T.let(T.unsafe(nil), Integer)

# Attribute node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#65
Nokogiri::XML::Node::ATTRIBUTE_NODE = T.let(T.unsafe(nil), Integer)

# CDATA node type, see Nokogiri::XML::Node#cdata?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#69
Nokogiri::XML::Node::CDATA_SECTION_NODE = T.let(T.unsafe(nil), Integer)

# Comment node type, see Nokogiri::XML::Node#comment?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#77
Nokogiri::XML::Node::COMMENT_NODE = T.let(T.unsafe(nil), Integer)

# DOCB document node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#103
Nokogiri::XML::Node::DOCB_DOCUMENT_NODE = T.let(T.unsafe(nil), Integer)

# Document fragment node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#83
Nokogiri::XML::Node::DOCUMENT_FRAG_NODE = T.let(T.unsafe(nil), Integer)

# Document node type, see Nokogiri::XML::Node#xml?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#79
Nokogiri::XML::Node::DOCUMENT_NODE = T.let(T.unsafe(nil), Integer)

# Document type node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#81
Nokogiri::XML::Node::DOCUMENT_TYPE_NODE = T.let(T.unsafe(nil), Integer)

# DTD node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#89
Nokogiri::XML::Node::DTD_NODE = T.let(T.unsafe(nil), Integer)

# Element declaration type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#91
Nokogiri::XML::Node::ELEMENT_DECL = T.let(T.unsafe(nil), Integer)

# Element node type, see Nokogiri::XML::Node#element?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#63
Nokogiri::XML::Node::ELEMENT_NODE = T.let(T.unsafe(nil), Integer)

# Entity declaration type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#95
Nokogiri::XML::Node::ENTITY_DECL = T.let(T.unsafe(nil), Integer)

# Entity node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#73
Nokogiri::XML::Node::ENTITY_NODE = T.let(T.unsafe(nil), Integer)

# Entity reference node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#71
Nokogiri::XML::Node::ENTITY_REF_NODE = T.let(T.unsafe(nil), Integer)

# HTML document node type, see Nokogiri::XML::Node#html?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#87
Nokogiri::XML::Node::HTML_DOCUMENT_NODE = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/node.rb#1395
Nokogiri::XML::Node::IMPLIED_XPATH_CONTEXTS = T.let(T.unsafe(nil), Array)

# Namespace declaration type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#97
Nokogiri::XML::Node::NAMESPACE_DECL = T.let(T.unsafe(nil), Integer)

# Notation node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#85
Nokogiri::XML::Node::NOTATION_NODE = T.let(T.unsafe(nil), Integer)

# PI node type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#75
Nokogiri::XML::Node::PI_NODE = T.let(T.unsafe(nil), Integer)

# Save options for serializing nodes.
# See the method group entitled Node@Serialization+and+Generating+Output for usage.
class Nokogiri::XML::Node::SaveOptions
  # Create a new SaveOptions object with +options+
  #
  # @return [SaveOptions] a new instance of SaveOptions
  #
  # source://nokogiri//lib/nokogiri/xml/node/save_options.rb#45
  def initialize(options = T.unsafe(nil)); end

  def as_html; end
  def as_html?; end
  def as_xhtml; end
  def as_xhtml?; end
  def as_xml; end
  def as_xml?; end
  def default_html; end
  def default_html?; end
  def default_xhtml; end
  def default_xhtml?; end
  def default_xml; end
  def default_xml?; end
  def format; end
  def format?; end
  def no_declaration; end
  def no_declaration?; end
  def no_empty_tags; end
  def no_empty_tags?; end
  def no_xhtml; end
  def no_xhtml?; end

  # Integer representation of the SaveOptions
  #
  # source://nokogiri//lib/nokogiri/xml/node/save_options.rb#42
  def options; end

  # Integer representation of the SaveOptions
  #
  # source://nokogiri//lib/nokogiri/xml/node/save_options.rb#42
  def to_i; end
end

# Save as HTML
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#23
Nokogiri::XML::Node::SaveOptions::AS_HTML = T.let(T.unsafe(nil), Integer)

# Save as XHTML
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#19
Nokogiri::XML::Node::SaveOptions::AS_XHTML = T.let(T.unsafe(nil), Integer)

# Save as XML
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#21
Nokogiri::XML::Node::SaveOptions::AS_XML = T.let(T.unsafe(nil), Integer)

# the default for HTML document
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#36
Nokogiri::XML::Node::SaveOptions::DEFAULT_HTML = T.let(T.unsafe(nil), Integer)

# the default for XHTML document
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#39
Nokogiri::XML::Node::SaveOptions::DEFAULT_XHTML = T.let(T.unsafe(nil), Integer)

# the default for XML documents
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#34
Nokogiri::XML::Node::SaveOptions::DEFAULT_XML = T.let(T.unsafe(nil), Integer)

# Format serialized xml
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#11
Nokogiri::XML::Node::SaveOptions::FORMAT = T.let(T.unsafe(nil), Integer)

# Do not include declarations
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#13
Nokogiri::XML::Node::SaveOptions::NO_DECLARATION = T.let(T.unsafe(nil), Integer)

# Do not include empty tags
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#15
Nokogiri::XML::Node::SaveOptions::NO_EMPTY_TAGS = T.let(T.unsafe(nil), Integer)

# Do not save XHTML
#
# source://nokogiri//lib/nokogiri/xml/node/save_options.rb#17
Nokogiri::XML::Node::SaveOptions::NO_XHTML = T.let(T.unsafe(nil), Integer)

# Text node type, see Nokogiri::XML::Node#text?
#
# source://nokogiri//lib/nokogiri/xml/node.rb#67
Nokogiri::XML::Node::TEXT_NODE = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/node.rb#1374
Nokogiri::XML::Node::USING_LIBXML_WITH_BROKEN_SERIALIZATION = T.let(T.unsafe(nil), FalseClass)

# XInclude end type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#101
Nokogiri::XML::Node::XINCLUDE_END = T.let(T.unsafe(nil), Integer)

# XInclude start type
#
# source://nokogiri//lib/nokogiri/xml/node.rb#99
Nokogiri::XML::Node::XINCLUDE_START = T.let(T.unsafe(nil), Integer)

# A NodeSet contains a list of Nokogiri::XML::Node objects.  Typically
# a NodeSet is return as a result of searching a Document via
# Nokogiri::XML::Searchable#css or Nokogiri::XML::Searchable#xpath
class Nokogiri::XML::NodeSet
  include ::Nokogiri::XML::Searchable
  include ::Enumerable

  # Create a NodeSet with +document+ defaulting to +list+
  #
  # @return [NodeSet] a new instance of NodeSet
  # @yield [_self]
  # @yieldparam _self [Nokogiri::XML::NodeSet] the object that the method was called on
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#19
  def initialize(document, list = T.unsafe(nil)); end

  # call-seq: search *paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class]
  #
  # Search this object for +paths+, and return only the first
  # result. +paths+ must be one or more XPath or CSS queries.
  #
  # See Searchable#search for more information.
  #
  # Or, if passed an integer, index into the NodeSet:
  #
  #   node_set.at(3) # same as node_set[3]
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#118
  def %(*args); end

  def &(_arg0); end
  def +(_arg0); end
  def -(_arg0); end
  def <<(_arg0); end

  # Equality -- Two NodeSets are equal if the contain the same number
  # of elements and if each element is equal to the corresponding
  # element in the other NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#325
  def ==(other); end

  def [](*_arg0); end

  # Add the class attribute +name+ to all Node objects in the
  # NodeSet.
  #
  # See Nokogiri::XML::Node#add_class for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#138
  def add_class(name); end

  # Insert +datum+ after the last Node in this NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#68
  def after(datum); end

  # Append the class attribute +name+ to all Node objects in the
  # NodeSet.
  #
  # See Nokogiri::XML::Node#append_class for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#150
  def append_class(name); end

  # call-seq: search *paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class]
  #
  # Search this object for +paths+, and return only the first
  # result. +paths+ must be one or more XPath or CSS queries.
  #
  # See Searchable#search for more information.
  #
  # Or, if passed an integer, index into the NodeSet:
  #
  #   node_set.at(3) # same as node_set[3]
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#118
  def at(*args); end

  # Set attributes on each Node in the NodeSet, or get an
  # attribute from the first Node in the NodeSet.
  #
  # To get an attribute from the first Node in a NodeSet:
  #
  #   node_set.attr("href") # => "https://www.nokogiri.org"
  #
  # Note that an empty NodeSet will return nil when +#attr+ is called as a getter.
  #
  # To set an attribute on each node, +key+ can either be an
  # attribute name, or a Hash of attribute names and values. When
  # called as a setter, +#attr+ returns the NodeSet.
  #
  # If +key+ is an attribute name, then either +value+ or +block+
  # must be passed.
  #
  # If +key+ is a Hash then attributes will be set for each
  # key/value pair:
  #
  #   node_set.attr("href" => "https://www.nokogiri.org", "class" => "member")
  #
  # If +value+ is passed, it will be used as the attribute value
  # for all nodes:
  #
  #   node_set.attr("href", "https://www.nokogiri.org")
  #
  # If +block+ is passed, it will be called on each Node object in
  # the NodeSet and the return value used as the attribute value
  # for that node:
  #
  #   node_set.attr("class") { |node| node.name }
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#202
  def attr(key, value = T.unsafe(nil), &block); end

  # Set attributes on each Node in the NodeSet, or get an
  # attribute from the first Node in the NodeSet.
  #
  # To get an attribute from the first Node in a NodeSet:
  #
  #   node_set.attr("href") # => "https://www.nokogiri.org"
  #
  # Note that an empty NodeSet will return nil when +#attr+ is called as a getter.
  #
  # To set an attribute on each node, +key+ can either be an
  # attribute name, or a Hash of attribute names and values. When
  # called as a setter, +#attr+ returns the NodeSet.
  #
  # If +key+ is an attribute name, then either +value+ or +block+
  # must be passed.
  #
  # If +key+ is a Hash then attributes will be set for each
  # key/value pair:
  #
  #   node_set.attr("href" => "https://www.nokogiri.org", "class" => "member")
  #
  # If +value+ is passed, it will be used as the attribute value
  # for all nodes:
  #
  #   node_set.attr("href", "https://www.nokogiri.org")
  #
  # If +block+ is passed, it will be called on each Node object in
  # the NodeSet and the return value used as the attribute value
  # for that node:
  #
  #   node_set.attr("class") { |node| node.name }
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#202
  def attribute(key, value = T.unsafe(nil), &block); end

  # Insert +datum+ before the first Node in this NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#62
  def before(datum); end

  # Returns a new NodeSet containing all the children of all the nodes in
  # the NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#338
  def children; end

  def clone; end

  # call-seq: css *rules, [namespace-bindings, custom-pseudo-class]
  #
  # Search this node set for CSS +rules+. +rules+ must be one or more CSS
  # selectors. For example:
  #
  # For more information see Nokogiri::XML::Searchable#css
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#82
  def css(*args); end

  def delete(_arg0); end

  # The Document this NodeSet is associated with
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#14
  def document; end

  # The Document this NodeSet is associated with
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#14
  def document=(_arg0); end

  def dup; end

  # Iterate over each node, yielding  to +block+
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#230
  def each; end

  # Is this NodeSet empty?
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#44
  def empty?; end

  # Filter this list for nodes that match +expr+
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#129
  def filter(expr); end

  # Get the first element of the NodeSet.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#28
  def first(n = T.unsafe(nil)); end

  def include?(_arg0); end

  # Returns the index of the first node in self that is == to +node+ or meets the given block. Returns nil if no match is found.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#50
  def index(node = T.unsafe(nil)); end

  # Get the inner html of all contained Node objects
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#259
  def inner_html(*args); end

  # Get the inner text of all contained Node objects
  #
  # Note: This joins the text of all Node objects in the NodeSet:
  #
  #    doc = Nokogiri::XML('<xml><a><d>foo</d><d>bar</d></a></xml>')
  #    doc.css('d').text # => "foobar"
  #
  # Instead, if you want to return the text of all nodes in the NodeSet:
  #
  #    doc.css('d').map(&:text) # => ["foo", "bar"]
  #
  # See Nokogiri::XML::Node#content for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#252
  def inner_text; end

  # Return a nicely formated string representation
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#359
  def inspect; end

  # Get the last element of the NodeSet.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#38
  def last; end

  def length; end

  # Removes the last element from set and returns it, or +nil+ if
  # the set is empty
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#306
  def pop; end

  def push(_arg0); end
  def remove; end

  # Remove the attributed named +name+ from all Node objects in the NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#222
  def remove_attr(name); end

  # Remove the attributed named +name+ from all Node objects in the NodeSet
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#222
  def remove_attribute(name); end

  # Remove the class attribute +name+ from all Node objects in the
  # NodeSet.
  #
  # See Nokogiri::XML::Node#remove_class for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#162
  def remove_class(name = T.unsafe(nil)); end

  # Returns a new NodeSet containing all the nodes in the NodeSet
  # in reverse order
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#349
  def reverse; end

  # Set attributes on each Node in the NodeSet, or get an
  # attribute from the first Node in the NodeSet.
  #
  # To get an attribute from the first Node in a NodeSet:
  #
  #   node_set.attr("href") # => "https://www.nokogiri.org"
  #
  # Note that an empty NodeSet will return nil when +#attr+ is called as a getter.
  #
  # To set an attribute on each node, +key+ can either be an
  # attribute name, or a Hash of attribute names and values. When
  # called as a setter, +#attr+ returns the NodeSet.
  #
  # If +key+ is an attribute name, then either +value+ or +block+
  # must be passed.
  #
  # If +key+ is a Hash then attributes will be set for each
  # key/value pair:
  #
  #   node_set.attr("href" => "https://www.nokogiri.org", "class" => "member")
  #
  # If +value+ is passed, it will be used as the attribute value
  # for all nodes:
  #
  #   node_set.attr("href", "https://www.nokogiri.org")
  #
  # If +block+ is passed, it will be called on each Node object in
  # the NodeSet and the return value used as the attribute value
  # for that node:
  #
  #   node_set.attr("class") { |node| node.name }
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#202
  def set(key, value = T.unsafe(nil), &block); end

  # Returns the first element of the NodeSet and removes it.  Returns
  # +nil+ if the set is empty.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#315
  def shift; end

  def size; end
  def slice(*_arg0); end

  # Get the inner text of all contained Node objects
  #
  # Note: This joins the text of all Node objects in the NodeSet:
  #
  #    doc = Nokogiri::XML('<xml><a><d>foo</d><d>bar</d></a></xml>')
  #    doc.css('d').text # => "foobar"
  #
  # Instead, if you want to return the text of all nodes in the NodeSet:
  #
  #    doc.css('d').map(&:text) # => ["foo", "bar"]
  #
  # See Nokogiri::XML::Node#content for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#252
  def text; end

  def to_a; end
  def to_ary; end

  # Convert this NodeSet to HTML
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#277
  def to_html(*args); end

  # Convert this NodeSet to a string.
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#271
  def to_s; end

  # Convert this NodeSet to XHTML
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#290
  def to_xhtml(*args); end

  # Convert this NodeSet to XML
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#296
  def to_xml(*args); end

  def unlink; end

  # Wrap this NodeSet with +html+
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#265
  def wrap(html); end

  # call-seq: xpath *paths, [namespace-bindings, variable-bindings, custom-handler-class]
  #
  # Search this node set for XPath +paths+. +paths+ must be one or more XPath
  # queries.
  #
  # For more information see Nokogiri::XML::Searchable#xpath
  #
  # source://nokogiri//lib/nokogiri/xml/node_set.rb#98
  def xpath(*args); end

  def |(_arg0); end
end

# source://nokogiri//lib/nokogiri/xml/node_set.rb#365
Nokogiri::XML::NodeSet::IMPLIED_XPATH_CONTEXTS = T.let(T.unsafe(nil), Array)

# Struct representing an {XML Schema Notation}[https://www.w3.org/TR/xml/#Notations]
class Nokogiri::XML::Notation < ::Struct; end

module Nokogiri::XML::PP; end

module Nokogiri::XML::PP::CharacterData
  # source://nokogiri//lib/nokogiri/xml/pp/character_data.rb#15
  def inspect; end

  # source://nokogiri//lib/nokogiri/xml/pp/character_data.rb#8
  def pretty_print(pp); end
end

module Nokogiri::XML::PP::Node
  # source://nokogiri//lib/nokogiri/xml/pp/node.rb#8
  def inspect; end

  # source://nokogiri//lib/nokogiri/xml/pp/node.rb#20
  def pretty_print(pp); end
end

# Parse options for passing to Nokogiri.XML or Nokogiri.HTML
#
# == Building combinations of parse options
# You can build your own combinations of these parse options by using any of the following methods:
# *Note*: All examples attempt to set the +RECOVER+ & +NOENT+ options.
# [Ruby's bitwise operators] You can use the Ruby bitwise operators to set various combinations.
#   Nokogiri.XML('<content>Chapter 1</content', nil, nil, Nokogiri::XML::ParseOptions.new((1 << 0) | (1 << 1)))
# [Method chaining] Every option has an equivalent method in lowercase. You can chain these methods together to set various combinations.
#   Nokogiri.XML('<content>Chapter 1</content', nil, nil, Nokogiri::XML::ParseOptions.new.recover.noent)
# [Using Ruby Blocks] You can also setup parse combinations in the block passed to Nokogiri.XML or Nokogiri.HTML
#   Nokogiri.XML('<content>Chapter 1</content') {|config| config.recover.noent}
#
# == Removing particular parse options
# You can also remove options from an instance of +ParseOptions+ dynamically.
# Every option has an equivalent <code>no{option}</code> method in lowercase. You can call these methods on an instance of +ParseOptions+ to remove the option.
# Note that this is not available for +STRICT+.
#
#   # Setting the RECOVER & NOENT options...
#   options = Nokogiri::XML::ParseOptions.new.recover.noent
#   # later...
#   options.norecover # Removes the Nokogiri::XML::ParseOptions::RECOVER option
#   options.nonoent # Removes the Nokogiri::XML::ParseOptions::NOENT option
class Nokogiri::XML::ParseOptions
  # @return [ParseOptions] a new instance of ParseOptions
  #
  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#86
  def initialize(options = T.unsafe(nil)); end

  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#119
  def ==(other); end

  def big_lines; end
  def big_lines?; end
  def compact; end
  def compact?; end
  def default_html; end
  def default_html?; end
  def default_schema; end
  def default_schema?; end
  def default_xml; end
  def default_xml?; end
  def default_xslt; end
  def default_xslt?; end
  def dtdattr; end
  def dtdattr?; end
  def dtdload; end
  def dtdload?; end
  def dtdvalid; end
  def dtdvalid?; end
  def huge; end
  def huge?; end

  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#125
  def inspect; end

  def nobasefix; end
  def nobasefix?; end
  def nobig_lines; end
  def noblanks; end
  def noblanks?; end
  def nocdata; end
  def nocdata?; end
  def nocompact; end
  def nodefault_html; end
  def nodefault_schema; end
  def nodefault_xml; end
  def nodefault_xslt; end
  def nodict; end
  def nodict?; end
  def nodtdattr; end
  def nodtdload; end
  def nodtdvalid; end
  def noent; end
  def noent?; end
  def noerror; end
  def noerror?; end
  def nohuge; end
  def nonet; end
  def nonet?; end
  def nonobasefix; end
  def nonoblanks; end
  def nonocdata; end
  def nonodict; end
  def nonoent; end
  def nonoerror; end
  def nononet; end
  def nonowarning; end
  def nonoxincnode; end
  def nonsclean; end
  def noold10; end
  def nopedantic; end
  def norecover; end
  def nosax1; end
  def nowarning; end
  def nowarning?; end
  def noxinclude; end
  def noxincnode; end
  def noxincnode?; end
  def nsclean; end
  def nsclean?; end
  def old10; end
  def old10?; end

  # Returns the value of attribute options.
  #
  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#84
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#84
  def options=(_arg0); end

  def pedantic; end
  def pedantic?; end
  def recover; end
  def recover?; end
  def sax1; end
  def sax1?; end

  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#110
  def strict; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#115
  def strict?; end

  # Returns the value of attribute options.
  #
  # source://nokogiri//lib/nokogiri/xml/parse_options.rb#84
  def to_i; end

  def xinclude; end
  def xinclude?; end
end

# line numbers stored as long int (instead of a short int)
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#73
Nokogiri::XML::ParseOptions::BIG_LINES = T.let(T.unsafe(nil), Integer)

# compact small text nodes; no modification of the tree allowed afterwards (will possibly crash if you try to modify the tree)
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#65
Nokogiri::XML::ParseOptions::COMPACT = T.let(T.unsafe(nil), Integer)

# the default options used for parsing HTML documents
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#80
Nokogiri::XML::ParseOptions::DEFAULT_HTML = T.let(T.unsafe(nil), Integer)

# the default options used for parsing XML schemas
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#82
Nokogiri::XML::ParseOptions::DEFAULT_SCHEMA = T.let(T.unsafe(nil), Integer)

# the default options used for parsing XML documents
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#76
Nokogiri::XML::ParseOptions::DEFAULT_XML = T.let(T.unsafe(nil), Integer)

# the default options used for parsing XSLT stylesheets
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#78
Nokogiri::XML::ParseOptions::DEFAULT_XSLT = T.let(T.unsafe(nil), Integer)

# Default DTD attributes
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#39
Nokogiri::XML::ParseOptions::DTDATTR = T.let(T.unsafe(nil), Integer)

# Load external subsets
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#37
Nokogiri::XML::ParseOptions::DTDLOAD = T.let(T.unsafe(nil), Integer)

# validate with the DTD
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#41
Nokogiri::XML::ParseOptions::DTDVALID = T.let(T.unsafe(nil), Integer)

# relax any hardcoded limit from the parser
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#71
Nokogiri::XML::ParseOptions::HUGE = T.let(T.unsafe(nil), Integer)

# do not fixup XINCLUDE xml:base uris
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#69
Nokogiri::XML::ParseOptions::NOBASEFIX = T.let(T.unsafe(nil), Integer)

# remove blank nodes
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#49
Nokogiri::XML::ParseOptions::NOBLANKS = T.let(T.unsafe(nil), Integer)

# merge CDATA as text nodes
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#61
Nokogiri::XML::ParseOptions::NOCDATA = T.let(T.unsafe(nil), Integer)

# Do not reuse the context dictionary
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#57
Nokogiri::XML::ParseOptions::NODICT = T.let(T.unsafe(nil), Integer)

# Substitute entities
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#35
Nokogiri::XML::ParseOptions::NOENT = T.let(T.unsafe(nil), Integer)

# suppress error reports
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#43
Nokogiri::XML::ParseOptions::NOERROR = T.let(T.unsafe(nil), Integer)

# Forbid network access. Recommended for dealing with untrusted documents.
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#55
Nokogiri::XML::ParseOptions::NONET = T.let(T.unsafe(nil), Integer)

# suppress warning reports
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#45
Nokogiri::XML::ParseOptions::NOWARNING = T.let(T.unsafe(nil), Integer)

# do not generate XINCLUDE START/END nodes
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#63
Nokogiri::XML::ParseOptions::NOXINCNODE = T.let(T.unsafe(nil), Integer)

# remove redundant namespaces declarations
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#59
Nokogiri::XML::ParseOptions::NSCLEAN = T.let(T.unsafe(nil), Integer)

# parse using XML-1.0 before update 5
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#67
Nokogiri::XML::ParseOptions::OLD10 = T.let(T.unsafe(nil), Integer)

# pedantic error reporting
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#47
Nokogiri::XML::ParseOptions::PEDANTIC = T.let(T.unsafe(nil), Integer)

# Recover from errors
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#33
Nokogiri::XML::ParseOptions::RECOVER = T.let(T.unsafe(nil), Integer)

# use the SAX1 interface internally
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#51
Nokogiri::XML::ParseOptions::SAX1 = T.let(T.unsafe(nil), Integer)

# Strict parsing
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#31
Nokogiri::XML::ParseOptions::STRICT = T.let(T.unsafe(nil), Integer)

# Implement XInclude substitution
#
# source://nokogiri//lib/nokogiri/xml/parse_options.rb#53
Nokogiri::XML::ParseOptions::XINCLUDE = T.let(T.unsafe(nil), Integer)

class Nokogiri::XML::ProcessingInstruction < ::Nokogiri::XML::Node
  # @return [ProcessingInstruction] a new instance of ProcessingInstruction
  #
  # source://nokogiri//lib/nokogiri/xml/processing_instruction.rb#6
  def initialize(document, name, content); end

  class << self
    def new(*_arg0); end
  end
end

# Nokogiri::XML::Reader parses an XML document similar to the way a cursor
# would move.  The Reader is given an XML document, and yields nodes
# to an each block.
#
# Here is an example of usage:
#
#     reader = Nokogiri::XML::Reader(<<-eoxml)
#       <x xmlns:tenderlove='http://tenderlovemaking.com/'>
#         <tenderlove:foo awesome='true'>snuggles!</tenderlove:foo>
#       </x>
#     eoxml
#
#     reader.each do |node|
#
#       # node is an instance of Nokogiri::XML::Reader
#       puts node.name
#
#     end
#
# Note that Nokogiri::XML::Reader#each can only be called once!!  Once
# the cursor moves through the entire document, you must parse the
# document again.  So make sure that you capture any information you
# need during the first iteration.
#
# The Reader parser is good for when you need the speed of a SAX parser,
# but do not want to write a Document handler.
class Nokogiri::XML::Reader
  include ::Enumerable

  # @return [Reader] a new instance of Reader
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#79
  def initialize(source, url = T.unsafe(nil), encoding = T.unsafe(nil)); end

  def attribute(_arg0); end
  def attribute_at(_arg0); end
  def attribute_count; end
  def attribute_hash; end
  def attribute_nodes; end

  # Get the attributes and namespaces of the current node as a Hash.
  #
  # This is the union of Reader#attribute_hash and Reader#namespaces
  #
  # [Returns]
  #   (Hash<String, String>) Attribute names and values, and namespace prefixes and hrefs.
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#92
  def attributes; end

  def attributes?; end
  def base_uri; end
  def default?; end
  def depth; end

  # Move the cursor through the document yielding the cursor to the block
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#98
  def each; end

  def empty_element?; end
  def encoding; end

  # A list of errors encountered while parsing
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#72
  def errors; end

  # A list of errors encountered while parsing
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#72
  def errors=(_arg0); end

  def inner_xml; end
  def lang; end
  def local_name; end
  def name; end
  def namespace_uri; end
  def namespaces; end
  def node_type; end
  def outer_xml; end
  def prefix; end
  def read; end
  def self_closing?; end

  # The XML source
  #
  # source://nokogiri//lib/nokogiri/xml/reader.rb#75
  def source; end

  def state; end
  def value; end
  def value?; end
  def xml_version; end

  class << self
    def from_io(*_arg0); end
    def from_memory(*_arg0); end
  end
end

# Attribute node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#39
Nokogiri::XML::Reader::TYPE_ATTRIBUTE = T.let(T.unsafe(nil), Integer)

# CDATA node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#43
Nokogiri::XML::Reader::TYPE_CDATA = T.let(T.unsafe(nil), Integer)

# Comment node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#51
Nokogiri::XML::Reader::TYPE_COMMENT = T.let(T.unsafe(nil), Integer)

# Document node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#53
Nokogiri::XML::Reader::TYPE_DOCUMENT = T.let(T.unsafe(nil), Integer)

# Document Fragment node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#57
Nokogiri::XML::Reader::TYPE_DOCUMENT_FRAGMENT = T.let(T.unsafe(nil), Integer)

# Document Type node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#55
Nokogiri::XML::Reader::TYPE_DOCUMENT_TYPE = T.let(T.unsafe(nil), Integer)

# Element node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#37
Nokogiri::XML::Reader::TYPE_ELEMENT = T.let(T.unsafe(nil), Integer)

# Element end node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#65
Nokogiri::XML::Reader::TYPE_END_ELEMENT = T.let(T.unsafe(nil), Integer)

# Entity end node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#67
Nokogiri::XML::Reader::TYPE_END_ENTITY = T.let(T.unsafe(nil), Integer)

# Entity node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#47
Nokogiri::XML::Reader::TYPE_ENTITY = T.let(T.unsafe(nil), Integer)

# Entity Reference node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#45
Nokogiri::XML::Reader::TYPE_ENTITY_REFERENCE = T.let(T.unsafe(nil), Integer)

# source://nokogiri//lib/nokogiri/xml/reader.rb#35
Nokogiri::XML::Reader::TYPE_NONE = T.let(T.unsafe(nil), Integer)

# Notation node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#59
Nokogiri::XML::Reader::TYPE_NOTATION = T.let(T.unsafe(nil), Integer)

# PI node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#49
Nokogiri::XML::Reader::TYPE_PROCESSING_INSTRUCTION = T.let(T.unsafe(nil), Integer)

# Significant Whitespace node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#63
Nokogiri::XML::Reader::TYPE_SIGNIFICANT_WHITESPACE = T.let(T.unsafe(nil), Integer)

# Text node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#41
Nokogiri::XML::Reader::TYPE_TEXT = T.let(T.unsafe(nil), Integer)

# Whitespace node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#61
Nokogiri::XML::Reader::TYPE_WHITESPACE = T.let(T.unsafe(nil), Integer)

# XML Declaration node type
#
# source://nokogiri//lib/nokogiri/xml/reader.rb#69
Nokogiri::XML::Reader::TYPE_XML_DECLARATION = T.let(T.unsafe(nil), Integer)

# Nokogiri::XML::RelaxNG is used for validating XML against a
# RelaxNG schema.
#
# == Synopsis
#
# Validate an XML document against a RelaxNG schema.  Loop over the errors
# that are returned and print them out:
#
#   schema  = Nokogiri::XML::RelaxNG(File.open(ADDRESS_SCHEMA_FILE))
#   doc     = Nokogiri::XML(File.open(ADDRESS_XML_FILE))
#
#   schema.validate(doc).each do |error|
#     puts error.message
#   end
#
# The list of errors are Nokogiri::XML::SyntaxError objects.
#
# NOTE: RelaxNG input is always treated as TRUSTED documents, meaning that they will cause the
# underlying parsing libraries to access network resources. This is counter to Nokogiri's
# "untrusted by default" security policy, but is a limitation of the underlying libraries.
class Nokogiri::XML::RelaxNG < ::Nokogiri::XML::Schema
  private

  def validate_document(_arg0); end

  class << self
    def from_document(*_arg0); end
    def read_memory(*_arg0); end
  end
end

# SAX Parsers are event driven parsers. Nokogiri provides two different event based parsers when
# dealing with XML. If you want to do SAX style parsing using HTML, check out
# Nokogiri::HTML4::SAX.
#
# The basic way a SAX style parser works is by creating a parser, telling the parser about the
# events we're interested in, then giving the parser some XML to process. The parser will notify
# you when it encounters events you said you would like to know about.
#
# To register for events, you simply subclass Nokogiri::XML::SAX::Document, and implement the
# methods for which you would like notification.
#
# For example, if I want to be notified when a document ends, and when an element starts, I
# would write a class like this:
#
#   class MyDocument < Nokogiri::XML::SAX::Document
#     def end_document
#       puts "the document has ended"
#     end
#
#     def start_element name, attributes = []
#       puts "#{name} started"
#     end
#   end
#
# Then I would instantiate a SAX parser with this document, and feed the parser some XML
#
#   # Create a new parser
#   parser = Nokogiri::XML::SAX::Parser.new(MyDocument.new)
#
#   # Feed the parser some XML
#   parser.parse(File.open(ARGV[0]))
#
# Now my document handler will be called when each node starts, and when then document ends. To
# see what kinds of events are available, take a look at Nokogiri::XML::SAX::Document.
#
# Two SAX parsers for XML are available, a parser that reads from a string or IO object as it
# feels necessary, and a parser that lets you spoon feed it XML. If you want to let Nokogiri
# deal with reading your XML, use the Nokogiri::XML::SAX::Parser. If you want to have fine grain
# control over the XML input, use the Nokogiri::XML::SAX::PushParser.
module Nokogiri::XML::SAX; end

# This class is used for registering types of events you are interested in handling. All of
# the methods on this class are available as possible events while parsing an XML document. To
# register for any particular event, just subclass this class and implement the methods you
# are interested in knowing about.
#
# To only be notified about start and end element events, write a class like this:
#
#   class MyDocument < Nokogiri::XML::SAX::Document
#     def start_element name, attrs = []
#       puts "#{name} started!"
#     end
#
#     def end_element name
#       puts "#{name} ended"
#     end
#   end
#
# You can use this event handler for any SAX style parser included with Nokogiri. See
# Nokogiri::XML::SAX, and Nokogiri::HTML4::SAX.
class Nokogiri::XML::SAX::Document
  # Called when cdata blocks are found
  # +string+ contains the cdata content
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#155
  def cdata_block(string); end

  # Characters read between a tag. This method might be called multiple
  # times given one contiguous string of characters.
  #
  # +string+ contains the character data
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#131
  def characters(string); end

  # Called when comments are encountered
  # +string+ contains the comment data
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#137
  def comment(string); end

  # Called when document ends parsing
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#79
  def end_document; end

  # Called at the end of an element
  # +name+ is the tag name
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#93
  def end_element(name); end

  # Called at the end of an element
  # +name+ is the element's name
  # +prefix+ is the namespace prefix associated with the element
  # +uri+ is the associated namespace URI
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#120
  def end_element_namespace(name, prefix = T.unsafe(nil), uri = T.unsafe(nil)); end

  # Called on document errors
  # +string+ contains the error
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#149
  def error(string); end

  # Called when processing instructions are found
  # +name+ is the target of the instruction
  # +content+ is the value of the instruction
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#162
  def processing_instruction(name, content); end

  # Called when document starts parsing
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#74
  def start_document; end

  # Called at the beginning of an element
  # * +name+ is the name of the tag
  # * +attrs+ are an assoc list of namespaces and attributes, e.g.:
  #     [ ["xmlns:foo", "http://sample.net"], ["size", "large"] ]
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#87
  def start_element(name, attrs = T.unsafe(nil)); end

  # Called at the beginning of an element
  # +name+ is the element name
  # +attrs+ is a list of attributes
  # +prefix+ is the namespace prefix for the element
  # +uri+ is the associated namespace URI
  # +ns+ is a hash of namespace prefix:urls associated with the element
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#103
  def start_element_namespace(name, attrs = T.unsafe(nil), prefix = T.unsafe(nil), uri = T.unsafe(nil), ns = T.unsafe(nil)); end

  # Called on document warnings
  # +string+ contains the warning
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#143
  def warning(string); end

  # Called when an XML declaration is parsed
  #
  # source://nokogiri//lib/nokogiri/xml/sax/document.rb#69
  def xmldecl(version, encoding, standalone); end
end

# This parser is a SAX style parser that reads it's input as it
# deems necessary.  The parser takes a Nokogiri::XML::SAX::Document,
# an optional encoding, then given an XML input, sends messages to
# the Nokogiri::XML::SAX::Document.
#
# Here is an example of using this parser:
#
#   # Create a subclass of Nokogiri::XML::SAX::Document and implement
#   # the events we care about:
#   class MyDoc < Nokogiri::XML::SAX::Document
#     def start_element name, attrs = []
#       puts "starting: #{name}"
#     end
#
#     def end_element name
#       puts "ending: #{name}"
#     end
#   end
#
#   # Create our parser
#   parser = Nokogiri::XML::SAX::Parser.new(MyDoc.new)
#
#   # Send some XML to the parser
#   parser.parse(File.open(ARGV[0]))
#
# For more information about SAX parsers, see Nokogiri::XML::SAX.  Also
# see Nokogiri::XML::SAX::Document for the available events.
class Nokogiri::XML::SAX::Parser
  # Create a new Parser with +doc+ and +encoding+
  #
  # @return [Parser] a new instance of Parser
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#72
  def initialize(doc = T.unsafe(nil), encoding = T.unsafe(nil)); end

  # The Nokogiri::XML::SAX::Document where events will be sent.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#66
  def document; end

  # The Nokogiri::XML::SAX::Document where events will be sent.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#66
  def document=(_arg0); end

  # The encoding beings used for this document.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#69
  def encoding; end

  # The encoding beings used for this document.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#69
  def encoding=(_arg0); end

  # Parse given +thing+ which may be a string containing xml, or an
  # IO object.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#81
  def parse(thing, &block); end

  # Parse a file with +filename+
  #
  # @raise [ArgumentError]
  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#100
  def parse_file(filename); end

  # Parse given +io+
  #
  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#91
  def parse_io(io, encoding = T.unsafe(nil)); end

  # @yield [ctx]
  #
  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#110
  def parse_memory(data); end

  private

  # source://nokogiri//lib/nokogiri/xml/sax/parser.rb#118
  def check_encoding(encoding); end
end

class Nokogiri::XML::SAX::Parser::Attribute < ::Struct; end

# Encodinds this parser supports
#
# source://nokogiri//lib/nokogiri/xml/sax/parser.rb#39
Nokogiri::XML::SAX::Parser::ENCODINGS = T.let(T.unsafe(nil), Hash)

# Context for XML SAX parsers.  This class is usually not instantiated
# by the user.  Instead, you should be looking at
# Nokogiri::XML::SAX::Parser
class Nokogiri::XML::SAX::ParserContext
  def column; end
  def line; end
  def parse_with(_arg0); end
  def recovery; end
  def recovery=(_arg0); end
  def replace_entities; end
  def replace_entities=(_arg0); end

  class << self
    def file(_arg0); end
    def io(_arg0, _arg1); end
    def memory(_arg0); end

    # source://nokogiri//lib/nokogiri/xml/sax/parser_context.rb#11
    def new(thing, encoding = T.unsafe(nil)); end
  end
end

# PushParser can parse a document that is fed to it manually.  It
# must be given a SAX::Document object which will be called with
# SAX events as the document is being parsed.
#
# Calling PushParser#<< writes XML to the parser, calling any SAX
# callbacks it can.
#
# PushParser#finish tells the parser that the document is finished
# and calls the end_document SAX method.
#
# Example:
#
#   parser = PushParser.new(Class.new(XML::SAX::Document) {
#     def start_document
#       puts "start document called"
#     end
#   }.new)
#   parser << "<div>hello<"
#   parser << "/div>"
#   parser.finish
class Nokogiri::XML::SAX::PushParser
  # Create a new PushParser with +doc+ as the SAX Document, providing
  # an optional +file_name+ and +encoding+
  #
  # @return [PushParser] a new instance of PushParser
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#35
  def initialize(doc = T.unsafe(nil), file_name = T.unsafe(nil), encoding = T.unsafe(nil)); end

  # Write a +chunk+ of XML to the PushParser.  Any callback methods
  # that can be called will be called immediately.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#47
  def <<(chunk, last_chunk = T.unsafe(nil)); end

  # The Nokogiri::XML::SAX::Document on which the PushParser will be
  # operating
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#30
  def document; end

  # The Nokogiri::XML::SAX::Document on which the PushParser will be
  # operating
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#30
  def document=(_arg0); end

  # Finish the parsing.  This method is only necessary for
  # Nokogiri::XML::SAX::Document#end_document to be called.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#55
  def finish; end

  def options; end
  def options=(_arg0); end
  def replace_entities; end
  def replace_entities=(_arg0); end

  # Write a +chunk+ of XML to the PushParser.  Any callback methods
  # that can be called will be called immediately.
  #
  # source://nokogiri//lib/nokogiri/xml/sax/push_parser.rb#47
  def write(chunk, last_chunk = T.unsafe(nil)); end

  private

  def initialize_native(_arg0, _arg1); end
  def native_write(_arg0, _arg1); end
end

# Nokogiri::XML::Schema is used for validating XML against a schema
# (usually from an xsd file).
#
# == Synopsis
#
# Validate an XML document against a Schema.  Loop over the errors that
# are returned and print them out:
#
#   xsd = Nokogiri::XML::Schema(File.read(PO_SCHEMA_FILE))
#   doc = Nokogiri::XML(File.read(PO_XML_FILE))
#
#   xsd.validate(doc).each do |error|
#     puts error.message
#   end
#
# The list of errors are Nokogiri::XML::SyntaxError objects.
#
# NOTE: As of v1.11.0, Schema treats inputs as UNTRUSTED by default, and so external entities
# are not resolved from the network (`http://` or `ftp://`). Previously, parsing treated
# documents as "trusted" by default which was counter to Nokogiri's "untrusted by default"
# security policy. If a document is trusted, then the caller may turn off the NONET option via
# the ParseOptions to re-enable external entity resolution over a network connection.
class Nokogiri::XML::Schema
  # Errors while parsing the schema file
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#39
  def errors; end

  # Errors while parsing the schema file
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#39
  def errors=(_arg0); end

  # The Nokogiri::XML::ParseOptions used to parse the schema
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#41
  def parse_options; end

  # The Nokogiri::XML::ParseOptions used to parse the schema
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#41
  def parse_options=(_arg0); end

  # Returns true if +thing+ is a valid Nokogiri::XML::Document or
  # file.
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#68
  def valid?(thing); end

  # Validate +thing+ against this schema.  +thing+ can be a
  # Nokogiri::XML::Document object, or a filename.  An Array of
  # Nokogiri::XML::SyntaxError objects found while validating the
  # +thing+ is returned.
  #
  # source://nokogiri//lib/nokogiri/xml/schema.rb#55
  def validate(thing); end

  private

  def validate_document(_arg0); end
  def validate_file(_arg0); end

  class << self
    def from_document(*_arg0); end

    # Create a new Nokogiri::XML::Schema object using a +string_or_io+
    # object.
    #
    # source://nokogiri//lib/nokogiri/xml/schema.rb#46
    def new(string_or_io, options = T.unsafe(nil)); end

    def read_memory(*_arg0); end
  end
end

# The Searchable module declares the interface used for searching your DOM.
#
#  It implements the public methods #search, #css, and #xpath,
#  as well as allowing specific implementations to specialize some
#  of the important behaviors.
module Nokogiri::XML::Searchable
  # call-seq:
  #   at(*paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class])
  #
  # Search this object for +paths+, and return only the first
  # result. +paths+ must be one or more XPath or CSS queries.
  #
  # See Searchable#search for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#71
  def %(*args); end

  # call-seq:
  #   search(*paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class])
  #
  # Search this object for +paths+. +paths+ must be one or more XPath or CSS queries:
  #
  #   node.search("div.employee", ".//title")
  #
  # A hash of namespace bindings may be appended:
  #
  #   node.search('.//bike:tire', {'bike' => 'http://schwinn.com/'})
  #   node.search('bike|tire', {'bike' => 'http://schwinn.com/'})
  #
  # For XPath queries, a hash of variable bindings may also be appended to the namespace
  # bindings. For example:
  #
  #   node.search('.//address[@domestic=$value]', nil, {:value => 'Yes'})
  #
  # 💡 Custom XPath functions and CSS pseudo-selectors may also be defined. To define custom
  # functions create a class and implement the function you want to define. The first argument
  # to the method will be the current matching NodeSet. Any other arguments are ones that you
  # pass in. Note that this class may appear anywhere in the argument list. For example:
  #
  #   handler = Class.new {
  #     def regex node_set, regex
  #       node_set.find_all { |node| node['some_attribute'] =~ /#{regex}/ }
  #     end
  #   }.new
  #   node.search('.//title[regex(., "\w+")]', 'div.employee:regex("[0-9]+")', handler)
  #
  # See Searchable#xpath and Searchable#css for further usage help.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#51
  def /(*args); end

  # :call-seq:
  #   >(selector) → NodeSet
  #
  # Search this node's immediate children using CSS selector +selector+
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#196
  def >(selector); end

  # call-seq:
  #   at(*paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class])
  #
  # Search this object for +paths+, and return only the first
  # result. +paths+ must be one or more XPath or CSS queries.
  #
  # See Searchable#search for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#71
  def at(*args); end

  # call-seq:
  #   at_css(*rules, [namespace-bindings, custom-pseudo-class])
  #
  # Search this object for CSS +rules+, and return only the first
  # match. +rules+ must be one or more CSS selectors.
  #
  # See Searchable#css for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#140
  def at_css(*args); end

  # call-seq:
  #   at_xpath(*paths, [namespace-bindings, variable-bindings, custom-handler-class])
  #
  # Search this node for XPath +paths+, and return only the first
  # match. +paths+ must be one or more XPath queries.
  #
  # See Searchable#xpath for more information.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#188
  def at_xpath(*args); end

  # call-seq:
  #   css(*rules, [namespace-bindings, custom-pseudo-class])
  #
  # Search this object for CSS +rules+. +rules+ must be one or more CSS
  # selectors. For example:
  #
  #   node.css('title')
  #   node.css('body h1.bold')
  #   node.css('div + p.green', 'div#one')
  #
  # A hash of namespace bindings may be appended. For example:
  #
  #   node.css('bike|tire', {'bike' => 'http://schwinn.com/'})
  #
  # 💡 Custom CSS pseudo classes may also be defined which are mapped to a custom XPath
  # function.  To define custom pseudo classes, create a class and implement the custom pseudo
  # class you want defined. The first argument to the method will be the matching context
  # NodeSet. Any other arguments are ones that you pass in. For example:
  #
  #   handler = Class.new {
  #     def regex(node_set, regex)
  #       node_set.find_all { |node| node['some_attribute'] =~ /#{regex}/ }
  #     end
  #   }.new
  #   node.css('title:regex("\w+")', handler)
  #
  # 💡 Some XPath syntax is supported in CSS queries. For example, to query for an attribute:
  #
  #   node.css('img > @href') # returns all +href+ attributes on an +img+ element
  #   node.css('img / @href') # same
  #
  #   # ⚠ this returns +class+ attributes from all +div+ elements AND THEIR CHILDREN!
  #   node.css('div @class')
  #
  #   node.css
  #
  # 💡 Array-like syntax is supported in CSS queries as an alternative to using +:nth-child()+.
  #
  # ⚠ NOTE that indices are 1-based like +:nth-child+ and not 0-based like Ruby Arrays. For
  # example:
  #
  #   # equivalent to 'li:nth-child(2)'
  #   node.css('li[2]') # retrieve the second li element in a list
  #
  # ⚠ NOTE that the CSS query string is case-sensitive with regards to your document type. HTML
  # tags will match only lowercase CSS queries, so if you search for "H1" in an HTML document,
  # you'll never find anything. However, "H1" might be found in an XML document, where tags
  # names are case-sensitive (e.g., "H1" is distinct from "h1").
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#126
  def css(*args); end

  # call-seq:
  #   search(*paths, [namespace-bindings, xpath-variable-bindings, custom-handler-class])
  #
  # Search this object for +paths+. +paths+ must be one or more XPath or CSS queries:
  #
  #   node.search("div.employee", ".//title")
  #
  # A hash of namespace bindings may be appended:
  #
  #   node.search('.//bike:tire', {'bike' => 'http://schwinn.com/'})
  #   node.search('bike|tire', {'bike' => 'http://schwinn.com/'})
  #
  # For XPath queries, a hash of variable bindings may also be appended to the namespace
  # bindings. For example:
  #
  #   node.search('.//address[@domestic=$value]', nil, {:value => 'Yes'})
  #
  # 💡 Custom XPath functions and CSS pseudo-selectors may also be defined. To define custom
  # functions create a class and implement the function you want to define. The first argument
  # to the method will be the current matching NodeSet. Any other arguments are ones that you
  # pass in. Note that this class may appear anywhere in the argument list. For example:
  #
  #   handler = Class.new {
  #     def regex node_set, regex
  #       node_set.find_all { |node| node['some_attribute'] =~ /#{regex}/ }
  #     end
  #   }.new
  #   node.search('.//title[regex(., "\w+")]', 'div.employee:regex("[0-9]+")', handler)
  #
  # See Searchable#xpath and Searchable#css for further usage help.
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#51
  def search(*args); end

  # call-seq:
  #   xpath(*paths, [namespace-bindings, variable-bindings, custom-handler-class])
  #
  # Search this node for XPath +paths+. +paths+ must be one or more XPath
  # queries.
  #
  #   node.xpath('.//title')
  #
  # A hash of namespace bindings may be appended. For example:
  #
  #   node.xpath('.//foo:name', {'foo' => 'http://example.org/'})
  #   node.xpath('.//xmlns:name', node.root.namespaces)
  #
  # A hash of variable bindings may also be appended to the namespace bindings. For example:
  #
  #   node.xpath('.//address[@domestic=$value]', nil, {:value => 'Yes'})
  #
  # 💡 Custom XPath functions may also be defined. To define custom functions create a class and
  # implement the function you want to define. The first argument to the method will be the
  # current matching NodeSet. Any other arguments are ones that you pass in. Note that this
  # class may appear anywhere in the argument list. For example:
  #
  #   handler = Class.new {
  #     def regex(node_set, regex)
  #       node_set.find_all { |node| node['some_attribute'] =~ /#{regex}/ }
  #     end
  #   }.new
  #   node.xpath('.//title[regex(., "\w+")]', handler)
  #
  # source://nokogiri//lib/nokogiri/xml/searchable.rb#174
  def xpath(*args); end

  private

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#205
  def css_internal(node, rules, handler, ns); end

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#236
  def css_rules_to_xpath(rules, ns); end

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#251
  def extract_params(params); end

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#224
  def xpath_impl(node, path, handler, ns, binds); end

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#209
  def xpath_internal(node, paths, handler, ns, binds); end

  # source://nokogiri//lib/nokogiri/xml/searchable.rb#240
  def xpath_query_from_css_rule(rule, ns); end
end

# Regular expression used by Searchable#search to determine if a query
# string is CSS or XPath
#
# source://nokogiri//lib/nokogiri/xml/searchable.rb#16
Nokogiri::XML::Searchable::LOOKS_LIKE_XPATH = T.let(T.unsafe(nil), Regexp)

# This class provides information about XML SyntaxErrors.  These
# exceptions are typically stored on Nokogiri::XML::Document#errors.
class Nokogiri::XML::SyntaxError < ::Nokogiri::SyntaxError
  # Returns the value of attribute code.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#10
  def code; end

  # Returns the value of attribute column.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#18
  def column; end

  # Returns the value of attribute domain.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#9
  def domain; end

  # return true if this is an error
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#34
  def error?; end

  # return true if this error is fatal
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#40
  def fatal?; end

  # Returns the value of attribute file.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#12
  def file; end

  # Returns the value of attribute int1.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#17
  def int1; end

  # Returns the value of attribute level.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#11
  def level; end

  # Returns the value of attribute line.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#13
  def line; end

  # return true if this is a non error
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#22
  def none?; end

  # Returns the value of attribute str1.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#14
  def str1; end

  # Returns the value of attribute str2.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#15
  def str2; end

  # Returns the value of attribute str3.
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#16
  def str3; end

  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#44
  def to_s; end

  # return true if this is a warning
  #
  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#28
  def warning?; end

  private

  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#53
  def level_to_s; end

  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#65
  def location_to_s; end

  # @return [Boolean]
  #
  # source://nokogiri//lib/nokogiri/xml/syntax_error.rb#61
  def nil_or_zero?(attribute); end
end

class Nokogiri::XML::Text < ::Nokogiri::XML::CharacterData
  # source://nokogiri//lib/nokogiri/xml/text.rb#6
  def content=(string); end

  class << self
    def new(*_arg0); end
  end
end

# Original C14N 1.0 spec canonicalization
#
# source://nokogiri//lib/nokogiri/xml.rb#14
Nokogiri::XML::XML_C14N_1_0 = T.let(T.unsafe(nil), Integer)

# C14N 1.1 spec canonicalization
#
# source://nokogiri//lib/nokogiri/xml.rb#18
Nokogiri::XML::XML_C14N_1_1 = T.let(T.unsafe(nil), Integer)

# Exclusive C14N 1.0 spec canonicalization
#
# source://nokogiri//lib/nokogiri/xml.rb#16
Nokogiri::XML::XML_C14N_EXCLUSIVE_1_0 = T.let(T.unsafe(nil), Integer)

module Nokogiri::XML::XPath; end

# The XPath search prefix to search direct descendants of the current element, +./+
#
# source://nokogiri//lib/nokogiri/xml/xpath.rb#13
Nokogiri::XML::XPath::CURRENT_SEARCH_PREFIX = T.let(T.unsafe(nil), String)

# The XPath search prefix to search globally, +//+
#
# source://nokogiri//lib/nokogiri/xml/xpath.rb#7
Nokogiri::XML::XPath::GLOBAL_SEARCH_PREFIX = T.let(T.unsafe(nil), String)

# The XPath search prefix to search direct descendants of the root element, +/+
#
# source://nokogiri//lib/nokogiri/xml/xpath.rb#10
Nokogiri::XML::XPath::ROOT_SEARCH_PREFIX = T.let(T.unsafe(nil), String)

# The XPath search prefix to search anywhere in the current element's subtree, +.//+
#
# source://nokogiri//lib/nokogiri/xml/xpath.rb#16
Nokogiri::XML::XPath::SUBTREE_SEARCH_PREFIX = T.let(T.unsafe(nil), String)

class Nokogiri::XML::XPath::SyntaxError < ::Nokogiri::XML::SyntaxError
  # source://nokogiri//lib/nokogiri/xml/xpath/syntax_error.rb#7
  def to_s; end
end

class Nokogiri::XML::XPathContext
  def evaluate(*_arg0); end

  # Register namespaces in +namespaces+
  #
  # source://nokogiri//lib/nokogiri/xml/xpath_context.rb#8
  def register_namespaces(namespaces); end

  def register_ns(_arg0, _arg1); end
  def register_variable(_arg0, _arg1); end

  class << self
    def new(_arg0); end
  end
end

# See Nokogiri::XSLT::Stylesheet for creating and manipulating
# Stylesheet object.
module Nokogiri::XSLT
  class << self
    # Parse the stylesheet in +string+, register any +modules+
    #
    # source://nokogiri//lib/nokogiri/xslt.rb#25
    def parse(string, modules = T.unsafe(nil)); end

    # :call-seq:
    #   quote_params(params) → Array
    #
    # Quote parameters in +params+ for stylesheet safety.
    # See Nokogiri::XSLT::Stylesheet.transform for example usage.
    #
    # [Parameters]
    # - +params+ (Hash, Array) XSLT parameters (key->value, or tuples of [key, value])
    #
    # [Returns] Array of string parameters, with quotes correctly escaped for use with XSLT::Stylesheet.transform
    #
    # source://nokogiri//lib/nokogiri/xslt.rb#49
    def quote_params(params); end

    def register(_arg0, _arg1); end
  end
end

# A Stylesheet represents an XSLT Stylesheet object.  Stylesheet creation
# is done through Nokogiri.XSLT.  Here is an example of transforming
# an XML::Document with a Stylesheet:
#
#   doc   = Nokogiri::XML(File.read('some_file.xml'))
#   xslt  = Nokogiri::XSLT(File.read('some_transformer.xslt'))
#
#   puts xslt.transform(doc)
#
# See Nokogiri::XSLT::Stylesheet#transform for more transformation
# information.
class Nokogiri::XSLT::Stylesheet
  # Apply an XSLT stylesheet to an XML::Document.
  # +params+ is an array of strings used as XSLT parameters.
  # returns serialized document
  #
  # source://nokogiri//lib/nokogiri/xslt/stylesheet.rb#22
  def apply_to(document, params = T.unsafe(nil)); end

  def serialize(_arg0); end
  def transform(*_arg0); end

  class << self
    def parse_stylesheet_doc(_arg0); end
  end
end

class Object < ::BasicObject
  include ::ActiveSupport::ToJsonWithActiveSupportEncoder
  include ::ActiveSupport::Dependencies::RequireDependency
  include ::Kernel
  include ::PP::ObjectMixin
  include ::ActiveSupport::Tryable
  include ::Tins::Full

  private

  # source://nokogiri//lib/nokogiri.rb#109
  def Nokogiri(*args, &block); end
end
