# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `multi_xml` gem.
# Please instead update this file by running `bin/tapioca gem multi_xml`.

module MultiXml
  class << self
    # The default parser based on what you currently
    # have loaded and installed. First checks to see
    # if any parsers are already loaded, then checks
    # to see which are installed if none are loaded.
    #
    # @raise [NoParserError]
    #
    # source://multi_xml//lib/multi_xml.rb#87
    def default_parser; end

    # Parse an XML string or IO into Ruby.
    #
    # <b>Options</b>
    #
    # <tt>:symbolize_keys</tt> :: If true, will use symbols instead of strings for the keys.
    #
    # <tt>:disallowed_types</tt> :: Types to disallow from being typecasted. Defaults to `['yaml', 'symbol']`. Use `[]` to allow all types.
    #
    # <tt>:typecast_xml_value</tt> :: If true, won't typecast values for parsed document
    #
    # source://multi_xml//lib/multi_xml.rb#133
    def parse(xml, options = T.unsafe(nil)); end

    # Get the current parser class.
    #
    # source://multi_xml//lib/multi_xml.rb#77
    def parser; end

    # Set the XML parser utilizing a symbol, string, or class.
    # Supported by default are:
    #
    # * <tt>:libxml</tt>
    # * <tt>:nokogiri</tt>
    # * <tt>:ox</tt>
    # * <tt>:rexml</tt>
    # * <tt>:oga</tt>
    #
    # source://multi_xml//lib/multi_xml.rb#112
    def parser=(new_parser); end

    private

    # TODO: Add support for other encodings
    #
    # source://multi_xml//lib/multi_xml.rb#174
    def parse_binary(binary, entity); end

    # source://multi_xml//lib/multi_xml.rb#183
    def parse_file(file, entity); end

    # source://multi_xml//lib/multi_xml.rb#191
    def symbolize_keys(params); end

    # source://multi_xml//lib/multi_xml.rb#218
    def typecast_xml_value(value, disallowed_types = T.unsafe(nil)); end

    # source://multi_xml//lib/multi_xml.rb#204
    def undasherize_keys(params); end
  end
end

# source://multi_xml//lib/multi_xml.rb#27
MultiXml::CONTENT_ROOT = T.let(T.unsafe(nil), String)

# source://multi_xml//lib/multi_xml.rb#69
MultiXml::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://multi_xml//lib/multi_xml.rb#67
MultiXml::DISALLOWED_XML_TYPES = T.let(T.unsafe(nil), Array)

class MultiXml::DisallowedTypeError < ::StandardError
  # @return [DisallowedTypeError] a new instance of DisallowedTypeError
  #
  # source://multi_xml//lib/multi_xml.rb#12
  def initialize(type); end
end

class MultiXml::NoParserError < ::StandardError; end

# source://multi_xml//lib/multi_xml.rb#33
MultiXml::PARSING = T.let(T.unsafe(nil), Hash)

class MultiXml::ParseError < ::StandardError; end

# source://multi_xml//lib/multi_xml.rb#18
MultiXml::REQUIREMENT_MAP = T.let(T.unsafe(nil), Array)

# source://multi_xml//lib/multi_xml.rb#52
MultiXml::TYPE_NAMES = T.let(T.unsafe(nil), Hash)
