# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `matrix` gem.
# Please instead update this file by running `bin/tapioca gem matrix`.

module ExceptionForMatrix; end

class ExceptionForMatrix::ErrDimensionMismatch < ::StandardError
  # @return [ErrDimensionMismatch] a new instance of ErrDimensionMismatch
  #
  # source://matrix//lib/matrix.rb#19
  def initialize(val = T.unsafe(nil)); end
end

class ExceptionForMatrix::ErrNotRegular < ::StandardError
  # @return [ErrNotRegular] a new instance of ErrNotRegular
  #
  # source://matrix//lib/matrix.rb#29
  def initialize(val = T.unsafe(nil)); end
end

class ExceptionForMatrix::ErrOperationNotDefined < ::StandardError
  # @return [ErrOperationNotDefined] a new instance of ErrOperationNotDefined
  #
  # source://matrix//lib/matrix.rb#39
  def initialize(vals); end
end

class ExceptionForMatrix::ErrOperationNotImplemented < ::StandardError
  # @return [ErrOperationNotImplemented] a new instance of ErrOperationNotImplemented
  #
  # source://matrix//lib/matrix.rb#49
  def initialize(vals); end
end

# The +Matrix+ class represents a mathematical matrix. It provides methods for creating
# matrices, operating on them arithmetically and algebraically,
# and determining their mathematical properties such as trace, rank, inverse, determinant,
# or eigensystem.
class Matrix
  include ::Enumerable
  include ::ExceptionForMatrix
  include ::Matrix::CoercionHelper
  extend ::Matrix::ConversionHelper

  # Matrix.new is private; use ::rows, ::columns, ::[], etc... to create.
  #
  # @return [Matrix] a new instance of Matrix
  #
  # source://matrix//lib/matrix.rb#322
  def initialize(rows, column_count = T.unsafe(nil)); end

  # Matrix multiplication.
  #   Matrix[[2,4], [6,8]] * Matrix.identity(2)
  #   #  => 2 4
  #   #     6 8
  #
  # source://matrix//lib/matrix.rb#1058
  def *(m); end

  # Matrix exponentiation.
  # Equivalent to multiplying the matrix by itself N times.
  # Non integer exponents will be handled by diagonalizing the matrix.
  #
  #   Matrix[[7,6], [3,9]] ** 2
  #   #  => 67 96
  #   #     48 99
  #
  # source://matrix//lib/matrix.rb#1237
  def **(exp); end

  # Matrix addition.
  #   Matrix.scalar(2,5) + Matrix[[1,0], [-4,7]]
  #   #  =>  6  0
  #   #     -4 12
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1093
  def +(m); end

  # source://matrix//lib/matrix.rb#1283
  def +@; end

  # Matrix subtraction.
  #   Matrix[[1,5], [4,2]] - Matrix[[9,3], [-4,1]]
  #   #  => -8  2
  #   #      8  1
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1120
  def -(m); end

  # Unary matrix negation.
  #
  #   -Matrix[[1,5], [4,2]]
  #   # => -1 -5
  #   #    -4 -2
  #
  # source://matrix//lib/matrix.rb#1292
  def -@; end

  # Matrix division (multiplication by the inverse).
  #   Matrix[[7,6], [3,9]] / Matrix[[2,9], [3,1]]
  #   #  => -7  1
  #   #     -3 -6
  #
  # source://matrix//lib/matrix.rb#1147
  def /(other); end

  # Returns whether the two matrices contain equal elements.
  #
  # source://matrix//lib/matrix.rb#1021
  def ==(other); end

  # Returns element (+i+,+j+) of the matrix.  That is: row +i+, column +j+.
  #
  # source://matrix//lib/matrix.rb#337
  def [](i, j); end

  # :call-seq:
  #   matrix[range, range] = matrix/element
  #   matrix[range, integer] = vector/column_matrix/element
  #   matrix[integer, range] = vector/row_matrix/element
  #   matrix[integer, integer] = element
  #
  # Set element or elements of matrix.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#351
  def []=(i, j, v); end

  # Returns the absolute value elementwise
  #
  # source://matrix//lib/matrix.rb#1299
  def abs; end

  # Returns the adjoint of the matrix.
  #
  #   Matrix[ [i,1],[2,-i] ].adjoint
  #   #  => -i 2
  #   #      1 i
  #
  # source://matrix//lib/matrix.rb#1595
  def adjoint; end

  # Returns the adjugate of the matrix.
  #
  #   Matrix[ [7,6],[3,9] ].adjugate
  #   #  => 9 -6
  #   #     -3 7
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#793
  def adjugate; end

  # Returns +true+ if this is an antisymmetric matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#973
  def antisymmetric?; end

  # The coerce method provides support for Ruby type coercion.
  # This coercion mechanism is used by Ruby to handle mixed-type
  # numeric operations: it is intended to find a compatible common
  # type between the two operands of the operator.
  # See also Numeric#coerce.
  #
  # source://matrix//lib/matrix.rb#1648
  def coerce(other); end

  # Returns the (row, column) cofactor which is obtained by multiplying
  # the first minor by (-1)**(row + column).
  #
  #   Matrix.diagonal(9, 5, -3, 4).cofactor(1, 1)
  #   #  => -108
  #
  # @raise [RuntimeError]
  #
  # source://matrix//lib/matrix.rb#778
  def cofactor(row, column); end

  # Returns the Laplace expansion along given row or column.
  #
  #    Matrix[[7,6], [3,9]].laplace_expansion(column: 1)
  #    # => 45
  #
  #    Matrix[[Vector[1, 0], Vector[0, 1]], [2, 3]].laplace_expansion(row: 0)
  #    # => Vector[3, -2]
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#810
  def cofactor_expansion(row: T.unsafe(nil), column: T.unsafe(nil)); end

  # Returns a matrix that is the result of iteration of the given block over all
  # elements of the matrix.
  # Elements can be restricted by passing an argument:
  # * :all (default): yields all elements
  # * :diagonal: yields only elements on the diagonal
  # * :off_diagonal: yields all elements except on the diagonal
  # * :lower: yields only elements on or below the diagonal
  # * :strict_lower: yields only elements below the diagonal
  # * :strict_upper: yields only elements above the diagonal
  # * :upper: yields only elements on or above the diagonal
  #   Matrix[ [1,2], [3,4] ].collect { |e| e**2 }
  #   #  => 1  4
  #   #     9 16
  #
  # source://matrix//lib/matrix.rb#508
  def collect(which = T.unsafe(nil), &block); end

  # Invokes the given block for each element of matrix, replacing the element with the value
  # returned by the block.
  # Elements can be restricted by passing an argument:
  # * :all (default): yields all elements
  # * :diagonal: yields only elements on the diagonal
  # * :off_diagonal: yields all elements except on the diagonal
  # * :lower: yields only elements on or below the diagonal
  # * :strict_lower: yields only elements below the diagonal
  # * :strict_upper: yields only elements above the diagonal
  # * :upper: yields only elements on or above the diagonal
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#526
  def collect!(which = T.unsafe(nil)); end

  # Returns column vector number +j+ of the matrix as a Vector (starting at 0
  # like an array).  When a block is given, the elements of that vector are
  # iterated.
  #
  # source://matrix//lib/matrix.rb#477
  def column(j); end

  # Returns the number of columns.
  #
  # source://matrix//lib/matrix.rb#456
  def column_count; end

  # Returns the number of columns.
  #
  # source://matrix//lib/matrix.rb#456
  def column_size; end

  # Returns an array of the column vectors of the matrix.  See Vector.
  #
  # source://matrix//lib/matrix.rb#1669
  def column_vectors; end

  # :call-seq:
  #   combine(*other_matrices) { |*elements| ... }
  #
  # Creates new matrix by combining with <i>other_matrices</i> entrywise,
  # using the given block.
  #
  #   x = Matrix[[6, 6], [4, 4]]
  #   y = Matrix[[1, 2], [3, 4]]
  #   x.combine(y) {|a, b| a - b} # => Matrix[[5, 4], [1, 0]]
  #
  # source://matrix//lib/matrix.rb#315
  def combine(*matrices, &block); end

  # Returns element (+i+,+j+) of the matrix.  That is: row +i+, column +j+.
  #
  # source://matrix//lib/matrix.rb#337
  def component(i, j); end

  # Returns the conjugate of the matrix.
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]]
  #   #  => 1+2i   i  0
  #   #        1   2  3
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]].conjugate
  #   #  => 1-2i  -i  0
  #   #        1   2  3
  #
  # source://matrix//lib/matrix.rb#1583
  def conj; end

  # Returns the conjugate of the matrix.
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]]
  #   #  => 1+2i   i  0
  #   #        1   2  3
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]].conjugate
  #   #  => 1-2i  -i  0
  #   #        1   2  3
  #
  # source://matrix//lib/matrix.rb#1583
  def conjugate; end

  # Returns the determinant of the matrix.
  #
  # Beware that using Float values can yield erroneous results
  # because of their lack of precision.
  # Consider using exact types like Rational or BigDecimal instead.
  #
  #   Matrix[[7,6], [3,9]].determinant
  #   #  => 45
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1317
  def det; end

  # deprecated; use Matrix#determinant
  #
  # source://matrix//lib/matrix.rb#1398
  def det_e; end

  # Returns the determinant of the matrix.
  #
  # Beware that using Float values can yield erroneous results
  # because of their lack of precision.
  # Consider using exact types like Rational or BigDecimal instead.
  #
  #   Matrix[[7,6], [3,9]].determinant
  #   #  => 45
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1317
  def determinant; end

  # deprecated; use Matrix#determinant
  #
  # source://matrix//lib/matrix.rb#1398
  def determinant_e; end

  # Returns +true+ if this is a diagonal matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#839
  def diagonal?; end

  # Yields all elements of the matrix, starting with those of the first row,
  # or returns an Enumerator if no block given.
  # Elements can be restricted by passing an argument:
  # * :all (default): yields all elements
  # * :diagonal: yields only elements on the diagonal
  # * :off_diagonal: yields all elements except on the diagonal
  # * :lower: yields only elements on or below the diagonal
  # * :strict_lower: yields only elements below the diagonal
  # * :strict_upper: yields only elements above the diagonal
  # * :upper: yields only elements on or above the diagonal
  #
  #     Matrix[ [1,2], [3,4] ].each { |e| puts e }
  #       # => prints the numbers 1 to 4
  #     Matrix[ [1,2], [3,4] ].each(:strict_lower).to_a # => [3]
  #
  # source://matrix//lib/matrix.rb#556
  def each(which = T.unsafe(nil), &block); end

  # Same as #each, but the row index and column index in addition to the element
  #
  #   Matrix[ [1,2], [3,4] ].each_with_index do |e, row, col|
  #     puts "#{e} at #{row}, #{col}"
  #   end
  #     # => Prints:
  #     #    1 at 0, 0
  #     #    2 at 0, 1
  #     #    3 at 1, 0
  #     #    4 at 1, 1
  #
  # source://matrix//lib/matrix.rb#616
  def each_with_index(which = T.unsafe(nil)); end

  # Returns the Eigensystem of the matrix; see +EigenvalueDecomposition+.
  #   m = Matrix[[1, 2], [3, 4]]
  #   v, d, v_inv = m.eigensystem
  #   d.diagonal? # => true
  #   v.inv == v_inv # => true
  #   (v * d * v_inv).round(5) == m # => true
  #
  # source://matrix//lib/matrix.rb#1550
  def eigen; end

  # Returns the Eigensystem of the matrix; see +EigenvalueDecomposition+.
  #   m = Matrix[[1, 2], [3, 4]]
  #   v, d, v_inv = m.eigensystem
  #   d.diagonal? # => true
  #   v.inv == v_inv # => true
  #   (v * d * v_inv).round(5) == m # => true
  #
  # source://matrix//lib/matrix.rb#1550
  def eigensystem; end

  # Returns element (+i+,+j+) of the matrix.  That is: row +i+, column +j+.
  #
  # source://matrix//lib/matrix.rb#337
  def element(i, j); end

  # Deprecated.
  #
  # Use <code>map(&:to_f)</code>
  #
  # source://matrix//lib/matrix.rb#1692
  def elements_to_f; end

  # Deprecated.
  #
  # Use <code>map(&:to_i)</code>
  #
  # source://matrix//lib/matrix.rb#1700
  def elements_to_i; end

  # Deprecated.
  #
  # Use <code>map(&:to_r)</code>
  #
  # source://matrix//lib/matrix.rb#1708
  def elements_to_r; end

  # Returns +true+ if this is an empty matrix, i.e. if the number of rows
  # or the number of columns is 0.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#848
  def empty?; end

  # Hadamard product
  #    Matrix[[1,2], [3,4]].hadamard_product(Matrix[[1,2], [3,2]])
  #    #  => 1  4
  #    #     9  8
  #
  # source://matrix//lib/matrix.rb#1167
  def entrywise_product(m); end

  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#1027
  def eql?(other); end

  # :call-seq:
  #   index(value, selector = :all) -> [row, column]
  #   index(selector = :all){ block } -> [row, column]
  #   index(selector = :all) -> an_enumerator
  #
  # The index method is specialized to return the index as [row, column]
  # It also accepts an optional +selector+ argument, see #each for details.
  #
  #   Matrix[ [1,2], [3,4] ].index(&:even?) # => [0, 1]
  #   Matrix[ [1,1], [1,1] ].index(1, :strict_lower) # => [1, 0]
  #
  # @raise [ArgumentError]
  #
  # source://matrix//lib/matrix.rb#679
  def find_index(*args); end

  # Returns the submatrix obtained by deleting the specified row and column.
  #
  #   Matrix.diagonal(9, 5, -3, 4).first_minor(1, 2)
  #   #  => 9 0 0
  #   #     0 0 0
  #   #     0 0 4
  #
  # @raise [RuntimeError]
  #
  # source://matrix//lib/matrix.rb#751
  def first_minor(row, column); end

  # source://matrix//lib/matrix.rb#534
  def freeze; end

  # Hadamard product
  #    Matrix[[1,2], [3,4]].hadamard_product(Matrix[[1,2], [3,2]])
  #    #  => 1  4
  #    #     9  8
  #
  # source://matrix//lib/matrix.rb#1167
  def hadamard_product(m); end

  # Returns a hash-code for the matrix.
  #
  # source://matrix//lib/matrix.rb#1044
  def hash; end

  # Returns +true+ if this is an hermitian matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#856
  def hermitian?; end

  # Returns a new matrix resulting by stacking horizontally
  # the receiver with the given matrices
  #
  #   x = Matrix[[1, 2], [3, 4]]
  #   y = Matrix[[5, 6], [7, 8]]
  #   x.hstack(y) # => Matrix[[1, 2, 5, 6], [3, 4, 7, 8]]
  #
  # source://matrix//lib/matrix.rb#1412
  def hstack(*matrices); end

  # Returns the imaginary part of the matrix.
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]]
  #   #  => 1+2i  i  0
  #   #        1  2  3
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]].imaginary
  #   #  =>   2i  i  0
  #   #        0  0  0
  #
  # source://matrix//lib/matrix.rb#1608
  def imag; end

  # Returns the imaginary part of the matrix.
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]]
  #   #  => 1+2i  i  0
  #   #        1  2  3
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]].imaginary
  #   #  =>   2i  i  0
  #   #        0  0  0
  #
  # source://matrix//lib/matrix.rb#1608
  def imaginary; end

  # :call-seq:
  #   index(value, selector = :all) -> [row, column]
  #   index(selector = :all){ block } -> [row, column]
  #   index(selector = :all) -> an_enumerator
  #
  # The index method is specialized to return the index as [row, column]
  # It also accepts an optional +selector+ argument, see #each for details.
  #
  #   Matrix[ [1,2], [3,4] ].index(&:even?) # => [0, 1]
  #   Matrix[ [1,1], [1,1] ].index(1, :strict_lower) # => [1, 0]
  #
  # @raise [ArgumentError]
  #
  # source://matrix//lib/matrix.rb#679
  def index(*args); end

  # Overrides Object#inspect
  #
  # source://matrix//lib/matrix.rb#1733
  def inspect; end

  # Returns the inverse of the matrix.
  #   Matrix[[-1, -1], [0, -1]].inverse
  #   #  => -1  1
  #   #      0 -1
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1178
  def inv; end

  # Returns the inverse of the matrix.
  #   Matrix[[-1, -1], [0, -1]].inverse
  #   #  => -1  1
  #   #      0 -1
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1178
  def inverse; end

  # Returns the Laplace expansion along given row or column.
  #
  #    Matrix[[7,6], [3,9]].laplace_expansion(column: 1)
  #    # => 45
  #
  #    Matrix[[Vector[1, 0], Vector[0, 1]], [2, 3]].laplace_expansion(row: 0)
  #    # => Vector[3, -2]
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#810
  def laplace_expansion(row: T.unsafe(nil), column: T.unsafe(nil)); end

  # Returns +true+ if this is a lower triangular matrix.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#866
  def lower_triangular?; end

  # Returns the LUP decomposition of the matrix; see +LUPDecomposition+.
  #   a = Matrix[[1, 2], [3, 4]]
  #   l, u, p = a.lup
  #   l.lower_triangular? # => true
  #   u.upper_triangular? # => true
  #   p.permutation?      # => true
  #   l * u == p * a      # => true
  #   a.lup.solve([2, 5]) # => Vector[(1/1), (1/2)]
  #
  # source://matrix//lib/matrix.rb#1565
  def lup; end

  # Returns the LUP decomposition of the matrix; see +LUPDecomposition+.
  #   a = Matrix[[1, 2], [3, 4]]
  #   l, u, p = a.lup
  #   l.lower_triangular? # => true
  #   u.upper_triangular? # => true
  #   p.permutation?      # => true
  #   l * u == p * a      # => true
  #   a.lup.solve([2, 5]) # => Vector[(1/1), (1/2)]
  #
  # source://matrix//lib/matrix.rb#1565
  def lup_decomposition; end

  # Returns a matrix that is the result of iteration of the given block over all
  # elements of the matrix.
  # Elements can be restricted by passing an argument:
  # * :all (default): yields all elements
  # * :diagonal: yields only elements on the diagonal
  # * :off_diagonal: yields all elements except on the diagonal
  # * :lower: yields only elements on or below the diagonal
  # * :strict_lower: yields only elements below the diagonal
  # * :strict_upper: yields only elements above the diagonal
  # * :upper: yields only elements on or above the diagonal
  #   Matrix[ [1,2], [3,4] ].collect { |e| e**2 }
  #   #  => 1  4
  #   #     9 16
  #
  # source://matrix//lib/matrix.rb#508
  def map(which = T.unsafe(nil), &block); end

  # Invokes the given block for each element of matrix, replacing the element with the value
  # returned by the block.
  # Elements can be restricted by passing an argument:
  # * :all (default): yields all elements
  # * :diagonal: yields only elements on the diagonal
  # * :off_diagonal: yields all elements except on the diagonal
  # * :lower: yields only elements on or below the diagonal
  # * :strict_lower: yields only elements below the diagonal
  # * :strict_upper: yields only elements above the diagonal
  # * :upper: yields only elements on or above the diagonal
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#526
  def map!(which = T.unsafe(nil)); end

  # Returns a section of the matrix.  The parameters are either:
  # *  start_row, nrows, start_col, ncols; OR
  # *  row_range, col_range
  #
  #   Matrix.diagonal(9, 5, -3).minor(0..1, 0..2)
  #   #  => 9 0 0
  #   #     0 5 0
  #
  # Like Array#[], negative indices count backward from the end of the
  # row or column (-1 is the last element). Returns nil if the starting
  # row or column is greater than row_count or column_count respectively.
  #
  # source://matrix//lib/matrix.rb#710
  def minor(*param); end

  # Returns +true+ if this is a normal matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#874
  def normal?; end

  # Returns +true+ if this is an orthogonal matrix
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#892
  def orthogonal?; end

  # Returns +true+ if this is a permutation matrix
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#911
  def permutation?; end

  # Returns the rank of the matrix.
  # Beware that using Float values can yield erroneous results
  # because of their lack of precision.
  # Consider using exact types like Rational or BigDecimal instead.
  #
  #   Matrix[[7,6], [3,9]].rank
  #   #  => 2
  #
  # source://matrix//lib/matrix.rb#1425
  def rank; end

  # deprecated; use Matrix#rank
  #
  # source://matrix//lib/matrix.rb#1456
  def rank_e; end

  # Returns the real part of the matrix.
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]]
  #   #  => 1+2i  i  0
  #   #        1  2  3
  #   Matrix[[Complex(1,2), Complex(0,1), 0], [1, 2, 3]].real
  #   #  =>    1  0  0
  #   #        1  2  3
  #
  # source://matrix//lib/matrix.rb#1622
  def real; end

  # Returns +true+ if all entries of the matrix are real.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#932
  def real?; end

  # Returns an array containing matrices corresponding to the real and imaginary
  # parts of the matrix
  #
  #   m.rect == [m.real, m.imag]  # ==> true for all matrices m
  #
  # source://matrix//lib/matrix.rb#1632
  def rect; end

  # Returns an array containing matrices corresponding to the real and imaginary
  # parts of the matrix
  #
  #   m.rect == [m.real, m.imag]  # ==> true for all matrices m
  #
  # source://matrix//lib/matrix.rb#1632
  def rectangular; end

  # Returns +true+ if this is a regular (i.e. non-singular) matrix.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#939
  def regular?; end

  # Returns a new matrix with rotated elements.
  # The argument specifies the rotation (defaults to `:clockwise`):
  # * :clockwise, 1, -3, etc.: "turn right" - first row becomes last column
  # * :half_turn, 2, -2, etc.: first row becomes last row, elements in reverse order
  # * :counter_clockwise, -1, 3: "turn left" - first row becomes first column
  #   (but with elements in reverse order)
  #
  #   m = Matrix[ [1, 2], [3, 4] ]
  #   r = m.rotate_entries(:clockwise)
  #   #  => Matrix[[3, 1], [4, 2]]
  #
  # source://matrix//lib/matrix.rb#1473
  def rotate_entries(rotation = T.unsafe(nil)); end

  # Returns a matrix with entries rounded to the given precision
  # (see Float#round)
  #
  # source://matrix//lib/matrix.rb#1493
  def round(ndigits = T.unsafe(nil)); end

  # Returns row vector number +i+ of the matrix as a Vector (starting at 0 like
  # an array).  When a block is given, the elements of that vector are iterated.
  #
  # source://matrix//lib/matrix.rb#463
  def row(i, &block); end

  # Returns the number of rows.
  #
  # source://matrix//lib/matrix.rb#448
  def row_count; end

  # Returns the number of rows.
  #
  # source://matrix//lib/matrix.rb#448
  def row_size; end

  # Returns an array of the row vectors of the matrix.  See Vector.
  #
  # source://matrix//lib/matrix.rb#1660
  def row_vectors; end

  # Returns +true+ if this is a singular matrix.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#946
  def singular?; end

  # Returns +true+ if this is an antisymmetric matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#973
  def skew_symmetric?; end

  # Returns +true+ if this is a square matrix.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#953
  def square?; end

  # Returns +true+ if this is a symmetric matrix.
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#961
  def symmetric?; end

  # Returns the transpose of the matrix.
  #   Matrix[[1,2], [3,4], [5,6]]
  #   #  => 1 2
  #   #     3 4
  #   #     5 6
  #   Matrix[[1,2], [3,4], [5,6]].transpose
  #   #  => 1 3 5
  #   #     2 4 6
  #
  # source://matrix//lib/matrix.rb#1520
  def t; end

  # Returns an array of arrays that describe the rows of the matrix.
  #
  # source://matrix//lib/matrix.rb#1685
  def to_a; end

  # Explicit conversion to a Matrix. Returns self
  #
  # source://matrix//lib/matrix.rb#1678
  def to_matrix; end

  # Overrides Object#to_s
  #
  # source://matrix//lib/matrix.rb#1720
  def to_s; end

  # Returns the trace (sum of diagonal elements) of the matrix.
  #   Matrix[[7,6], [3,9]].trace
  #   #  => 16
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1502
  def tr; end

  # Returns the trace (sum of diagonal elements) of the matrix.
  #   Matrix[[7,6], [3,9]].trace
  #   #  => 16
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#1502
  def trace; end

  # Returns the transpose of the matrix.
  #   Matrix[[1,2], [3,4], [5,6]]
  #   #  => 1 2
  #   #     3 4
  #   #     5 6
  #   Matrix[[1,2], [3,4], [5,6]].transpose
  #   #  => 1 3 5
  #   #     2 4 6
  #
  # source://matrix//lib/matrix.rb#1520
  def transpose; end

  # Returns +true+ if this is a unitary matrix
  # Raises an error if matrix is not square.
  #
  # @raise [ErrDimensionMismatch]
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#986
  def unitary?; end

  # Returns +true+ if this is an upper triangular matrix.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#1003
  def upper_triangular?; end

  # Returns a new matrix resulting by stacking vertically
  # the receiver with the given matrices
  #
  #   x = Matrix[[1, 2], [3, 4]]
  #   y = Matrix[[5, 6], [7, 8]]
  #   x.vstack(y) # => Matrix[[1, 2], [3, 4], [5, 6], [7, 8]]
  #
  # source://matrix//lib/matrix.rb#1534
  def vstack(*matrices); end

  # Returns +true+ if this is a matrix with only zero elements
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#1010
  def zero?; end

  protected

  # source://matrix//lib/matrix.rb#1257
  def power_int(exp); end

  # Returns the value of attribute rows.
  #
  # source://matrix//lib/matrix.rb#69
  def rows; end

  private

  # source://matrix//lib/matrix.rb#376
  def check_int(val, direction); end

  # Returns range or nil
  #
  # source://matrix//lib/matrix.rb#370
  def check_range(val, direction); end

  # Private. Use Matrix#determinant
  #
  # Returns the determinant of the matrix, using
  # Bareiss' multistep integer-preserving gaussian elimination.
  # It has the same computational cost order O(n^3) as standard Gaussian elimination.
  # Intermediate results are fraction free and of lower complexity.
  # A matrix of Integers will have thus intermediate results that are also Integers,
  # with smaller bignums (if any), while a matrix of Float will usually have
  # intermediate results with better precision.
  #
  # source://matrix//lib/matrix.rb#1368
  def determinant_bareiss; end

  # Called for dup & clone.
  #
  # source://matrix//lib/matrix.rb#1036
  def initialize_copy(m); end

  # source://matrix//lib/matrix.rb#1184
  def inverse_from(src); end

  # source://matrix//lib/matrix.rb#330
  def new_matrix(rows, column_count = T.unsafe(nil)); end

  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#432
  def set_col_range(row, col_range, value); end

  # source://matrix//lib/matrix.rb#425
  def set_column_vector(row_range, col, value); end

  # :call-seq:
  #   matrix[range, range] = matrix/element
  #   matrix[range, integer] = vector/column_matrix/element
  #   matrix[integer, range] = vector/row_matrix/element
  #   matrix[integer, integer] = element
  #
  # Set element or elements of matrix.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#351
  def set_component(i, j, v); end

  # :call-seq:
  #   matrix[range, range] = matrix/element
  #   matrix[range, integer] = vector/column_matrix/element
  #   matrix[integer, range] = vector/row_matrix/element
  #   matrix[integer, integer] = element
  #
  # Set element or elements of matrix.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#351
  def set_element(i, j, v); end

  # source://matrix//lib/matrix.rb#387
  def set_row_and_col_range(row_range, col_range, value); end

  # source://matrix//lib/matrix.rb#411
  def set_row_range(row_range, col, value); end

  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#381
  def set_value(row, col, value); end

  class << self
    # Creates an +n+ by +n+ identity matrix.
    #   Matrix.identity(2)
    #   #  => 1 0
    #   #     0 1
    #
    # source://matrix//lib/matrix.rb#171
    def I(n); end

    # Creates a matrix where each argument is a row.
    #   Matrix[ [25, 93], [-1, 66] ]
    #   #   =>  25 93
    #   #       -1 66
    #
    # source://matrix//lib/matrix.rb#78
    def [](*rows); end

    # Creates a matrix of size +row_count+ x +column_count+.
    # It fills the values by calling the given block,
    # passing the current row and column.
    # Returns an enumerator if no block is given.
    #
    #   m = Matrix.build(2, 4) {|row, col| col - row }
    #   #  => Matrix[[0, 1, 2, 3], [-1, 0, 1, 2]]
    #   m = Matrix.build(3) { rand }
    #   #  => a 3x3 matrix with random elements
    #
    # @raise [ArgumentError]
    #
    # source://matrix//lib/matrix.rb#123
    def build(row_count, column_count = T.unsafe(nil)); end

    # Creates a single-column matrix where the values of that column are as given
    # in +column+.
    #   Matrix.column_vector([4,5,6])
    #   #  => 4
    #   #     5
    #   #     6
    #
    # source://matrix//lib/matrix.rb#209
    def column_vector(column); end

    # Creates a matrix using +columns+ as an array of column vectors.
    #   Matrix.columns([[25, 93], [-1, 66]])
    #   #   =>  25 -1
    #   #       93 66
    #
    # source://matrix//lib/matrix.rb#108
    def columns(columns); end

    # :call-seq:
    #   Matrix.combine(*matrices) { |*elements| ... }
    #
    # Create a matrix by combining matrices entrywise, using the given block
    #
    #   x = Matrix[[6, 6], [4, 4]]
    #   y = Matrix[[1, 2], [3, 4]]
    #   Matrix.combine(x, y) {|a, b| a - b} # => Matrix[[5, 4], [1, 0]]
    #
    # source://matrix//lib/matrix.rb#288
    def combine(*matrices); end

    # Creates a matrix where the diagonal elements are composed of +values+.
    #   Matrix.diagonal(9, 5, -3)
    #   #  =>  9  0  0
    #   #      0  5  0
    #   #      0  0 -3
    #
    # source://matrix//lib/matrix.rb#143
    def diagonal(*values); end

    # Creates a empty matrix of +row_count+ x +column_count+.
    # At least one of +row_count+ or +column_count+ must be 0.
    #
    #   m = Matrix.empty(2, 0)
    #   m == Matrix[ [], [] ]
    #   #  => true
    #   n = Matrix.empty(0, 3)
    #   n == Matrix.columns([ [], [], [] ])
    #   #  => true
    #   m * n
    #   #  => Matrix[[0, 0, 0], [0, 0, 0]]
    #
    # @raise [ArgumentError]
    #
    # source://matrix//lib/matrix.rb#227
    def empty(row_count = T.unsafe(nil), column_count = T.unsafe(nil)); end

    # Create a matrix by stacking matrices horizontally
    #
    #   x = Matrix[[1, 2], [3, 4]]
    #   y = Matrix[[5, 6], [7, 8]]
    #   Matrix.hstack(x, y) # => Matrix[[1, 2, 5, 6], [3, 4, 7, 8]]
    #
    # source://matrix//lib/matrix.rb#262
    def hstack(x, *matrices); end

    # Creates an +n+ by +n+ identity matrix.
    #   Matrix.identity(2)
    #   #  => 1 0
    #   #     0 1
    #
    # source://matrix//lib/matrix.rb#171
    def identity(n); end

    # Creates a single-row matrix where the values of that row are as given in
    # +row+.
    #   Matrix.row_vector([4,5,6])
    #   #  => 4 5 6
    #
    # source://matrix//lib/matrix.rb#196
    def row_vector(row); end

    # Creates a matrix where +rows+ is an array of arrays, each of which is a row
    # of the matrix.  If the optional argument +copy+ is false, use the given
    # arrays as the internal structure of the matrix without copying.
    #   Matrix.rows([[25, 93], [-1, 66]])
    #   #   =>  25 93
    #   #       -1 66
    #
    # source://matrix//lib/matrix.rb#90
    def rows(rows, copy = T.unsafe(nil)); end

    # Creates an +n+ by +n+ diagonal matrix where each diagonal element is
    # +value+.
    #   Matrix.scalar(2, 5)
    #   #  => 5 0
    #   #     0 5
    #
    # source://matrix//lib/matrix.rb#161
    def scalar(n, value); end

    # Creates an +n+ by +n+ identity matrix.
    #   Matrix.identity(2)
    #   #  => 1 0
    #   #     0 1
    #
    # source://matrix//lib/matrix.rb#171
    def unit(n); end

    # Create a matrix by stacking matrices vertically
    #
    #   x = Matrix[[1, 2], [3, 4]]
    #   y = Matrix[[5, 6], [7, 8]]
    #   Matrix.vstack(x, y) # => Matrix[[1, 2], [3, 4], [5, 6], [7, 8]]
    #
    # source://matrix//lib/matrix.rb#241
    def vstack(x, *matrices); end

    # Creates a zero matrix.
    #   Matrix.zero(2)
    #   #  => 0 0
    #   #     0 0
    #
    # source://matrix//lib/matrix.rb#185
    def zero(row_count, column_count = T.unsafe(nil)); end
  end
end

module Matrix::CoercionHelper
  private

  # Applies the operator +oper+ with argument +obj+
  # through coercion of +obj+
  #
  # source://matrix//lib/matrix.rb#1773
  def apply_through_coercion(obj, oper); end

  class << self
    # source://matrix//lib/matrix.rb#1820
    def check_int(val, count, kind); end

    # Returns `nil` for non Ranges
    # Checks range validity, return canonical range with 0 <= begin <= end < count
    #
    # source://matrix//lib/matrix.rb#1810
    def check_range(val, count, kind); end

    # Helper method to coerce a value into a specific class.
    # Raises a TypeError if the coercion fails or the returned value
    # is not of the right class.
    # (from Rubinius)
    #
    # @raise [TypeError]
    #
    # source://matrix//lib/matrix.rb#1787
    def coerce_to(obj, cls, meth); end

    # source://matrix//lib/matrix.rb#1800
    def coerce_to_int(obj); end

    # source://matrix//lib/matrix.rb#1804
    def coerce_to_matrix(obj); end
  end
end

# Private helper modules
module Matrix::ConversionHelper
  private

  # source://matrix//lib/matrix.rb#1748
  def convert_to_array(obj, copy = T.unsafe(nil)); end
end

# Eigenvalues and eigenvectors of a real matrix.
#
# Computes the eigenvalues and eigenvectors of a matrix A.
#
# If A is diagonalizable, this provides matrices V and D
# such that A = V*D*V.inv, where D is the diagonal matrix with entries
# equal to the eigenvalues and V is formed by the eigenvectors.
#
# If A is symmetric, then V is orthogonal and thus A = V*D*V.t
class Matrix::EigenvalueDecomposition
  # Constructs the eigenvalue decomposition for a square matrix +A+
  #
  # @raise [TypeError]
  # @return [EigenvalueDecomposition] a new instance of EigenvalueDecomposition
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#19
  def initialize(a); end

  # Returns the block diagonal eigenvalue matrix +D+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#73
  def d; end

  # Returns the block diagonal eigenvalue matrix +D+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#73
  def eigenvalue_matrix; end

  # Returns the eigenvalues in an array
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#59
  def eigenvalues; end

  # Returns the eigenvector matrix +V+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#43
  def eigenvector_matrix; end

  # Returns the inverse of the eigenvector matrix +V+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#50
  def eigenvector_matrix_inv; end

  # Returns an array of the eigenvectors
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#67
  def eigenvectors; end

  # Returns [eigenvector_matrix, eigenvalue_matrix, eigenvector_matrix_inv]
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#80
  def to_a; end

  # Returns [eigenvector_matrix, eigenvalue_matrix, eigenvector_matrix_inv]
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#80
  def to_ary; end

  # Returns the eigenvector matrix +V+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#43
  def v; end

  # Returns the inverse of the eigenvector matrix +V+
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#50
  def v_inv; end

  private

  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#86
  def build_eigenvectors; end

  # Complex scalar division.
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#102
  def cdiv(xr, xi, yr, yi); end

  # Symmetric tridiagonal QL algorithm.
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#235
  def diagonalize; end

  # Nonsymmetric reduction from Hessenberg to real Schur form.
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#446
  def hessenberg_to_real_schur; end

  # Nonsymmetric reduction to Hessenberg form.
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#354
  def reduce_to_hessenberg; end

  # Symmetric Householder reduction to tridiagonal form.
  #
  # source://matrix//lib/matrix/eigenvalue_decomposition.rb#117
  def tridiagonalize; end
end

# For an m-by-n matrix A with m >= n, the LU decomposition is an m-by-n
# unit lower triangular matrix L, an n-by-n upper triangular matrix U,
# and a m-by-m permutation matrix P so that L*U = P*A.
# If m < n, then L is m-by-m and U is m-by-n.
#
# The LUP decomposition with pivoting always exists, even if the matrix is
# singular, so the constructor will never fail.  The primary use of the
# LU decomposition is in the solution of square systems of simultaneous
# linear equations.  This will fail if singular? returns true.
class Matrix::LUPDecomposition
  include ::Matrix::ConversionHelper

  # @raise [TypeError]
  # @return [LUPDecomposition] a new instance of LUPDecomposition
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#154
  def initialize(a); end

  # Returns the determinant of +A+, calculated efficiently
  # from the factorization.
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#79
  def det; end

  # Returns the determinant of +A+, calculated efficiently
  # from the factorization.
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#79
  def determinant; end

  # source://matrix//lib/matrix/lup_decomposition.rb#22
  def l; end

  # Returns the permutation matrix +P+
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#48
  def p; end

  # Returns the pivoting indices
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#63
  def pivots; end

  # Returns +true+ if +U+, and hence +A+, is singular.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#67
  def singular?; end

  # Returns +m+ so that <tt>A*m = b</tt>,
  # or equivalently so that <tt>L*U*m = P*b</tt>
  # +b+ can be a Matrix or a Vector
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#95
  def solve(b); end

  # Returns +L+, +U+, +P+ in an array
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#56
  def to_a; end

  # Returns +L+, +U+, +P+ in an array
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#56
  def to_ary; end

  # Returns the upper triangular factor +U+
  #
  # source://matrix//lib/matrix/lup_decomposition.rb#36
  def u; end
end

# source://matrix//lib/matrix.rb#666
Matrix::SELECTORS = T.let(T.unsafe(nil), Hash)

# Private CLASS
class Matrix::Scalar < ::Numeric
  include ::ExceptionForMatrix
  include ::Matrix::CoercionHelper

  # @return [Scalar] a new instance of Scalar
  #
  # source://matrix//lib/matrix.rb#1837
  def initialize(value); end

  # source://matrix//lib/matrix.rb#1864
  def *(other); end

  # source://matrix//lib/matrix.rb#1888
  def **(other); end

  # ARITHMETIC
  #
  # source://matrix//lib/matrix.rb#1842
  def +(other); end

  # source://matrix//lib/matrix.rb#1853
  def -(other); end

  # source://matrix//lib/matrix.rb#1875
  def /(other); end
end

# source://matrix//lib/matrix/version.rb#4
Matrix::VERSION = T.let(T.unsafe(nil), String)

# The +Vector+ class represents a mathematical vector, which is useful in its own right, and
# also constitutes a row or column of a Matrix.
#
# == Method Catalogue
#
# To create a Vector:
# * Vector.[](*array)
# * Vector.elements(array, copy = true)
# * Vector.basis(size: n, index: k)
# * Vector.zero(n)
#
# To access elements:
# * #[](i)
#
# To set elements:
# * #[]=(i, v)
#
# To enumerate the elements:
# * #each2(v)
# * #collect2(v)
#
# Properties of vectors:
# * #angle_with(v)
# * Vector.independent?(*vs)
# * #independent?(*vs)
# * #zero?
#
# Vector arithmetic:
# * #*(x) "is matrix or number"
# * #+(v)
# * #-(v)
# * #/(v)
# * #+@
# * #-@
#
# Vector functions:
# * #inner_product(v), #dot(v)
# * #cross_product(v), #cross(v)
# * #collect
# * #collect!
# * #magnitude
# * #map
# * #map!
# * #map2(v)
# * #norm
# * #normalize
# * #r
# * #round
# * #size
#
# Conversion to other data types:
# * #covector
# * #to_a
# * #coerce(other)
#
# String representations:
# * #to_s
# * #inspect
class Vector
  include ::ExceptionForMatrix
  include ::Enumerable
  include ::Matrix::CoercionHelper
  extend ::Matrix::ConversionHelper

  # Vector.new is private; use Vector[] or Vector.elements to create.
  #
  # @return [Vector] a new instance of Vector
  #
  # source://matrix//lib/matrix.rb#2020
  def initialize(array); end

  # Multiplies the vector by +x+, where +x+ is a number or a matrix.
  #
  # source://matrix//lib/matrix.rb#2222
  def *(x); end

  # Vector addition.
  #
  # source://matrix//lib/matrix.rb#2239
  def +(v); end

  # source://matrix//lib/matrix.rb#2287
  def +@; end

  # Vector subtraction.
  #
  # source://matrix//lib/matrix.rb#2257
  def -(v); end

  # source://matrix//lib/matrix.rb#2291
  def -@; end

  # Vector division.
  #
  # source://matrix//lib/matrix.rb#2275
  def /(x); end

  # Returns whether the two vectors have the same elements in the same order.
  #
  # source://matrix//lib/matrix.rb#2198
  def ==(other); end

  # :call-seq:
  #   vector[range]
  #   vector[integer]
  #
  # Returns element or elements of the vector.
  #
  # source://matrix//lib/matrix.rb#2034
  def [](i); end

  # :call-seq:
  #   vector[range] = new_vector
  #   vector[range] = row_matrix
  #   vector[range] = new_element
  #   vector[integer] = new_element
  #
  # Set element or elements of vector.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#2049
  def []=(i, v); end

  # Returns an angle with another vector. Result is within the [0..Math::PI].
  #   Vector[1,0].angle_with(Vector[0,1])
  #   # => Math::PI / 2
  #
  # @raise [TypeError]
  #
  # source://matrix//lib/matrix.rb#2407
  def angle_with(v); end

  # The coerce method provides support for Ruby type coercion.
  # This coercion mechanism is used by Ruby to handle mixed-type
  # numeric operations: it is intended to find a compatible common
  # type between the two operands of the operator.
  # See also Numeric#coerce.
  #
  # source://matrix//lib/matrix.rb#2467
  def coerce(other); end

  # Like Array#collect.
  #
  # source://matrix//lib/matrix.rb#2351
  def collect(&block); end

  # Like Array#collect!
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#2361
  def collect!(&block); end

  # Collects (as in Enumerable#collect) over the elements of this vector and +v+
  # in conjunction.
  #
  # @raise [TypeError]
  #
  # source://matrix//lib/matrix.rb#2123
  def collect2(v); end

  # :call-seq:
  #   vector[range]
  #   vector[integer]
  #
  # Returns element or elements of the vector.
  #
  # source://matrix//lib/matrix.rb#2034
  def component(i); end

  # Creates a single-row matrix from this vector.
  #
  # source://matrix//lib/matrix.rb#2427
  def covector; end

  # Returns the cross product of this vector with the others.
  #   Vector[1, 0, 0].cross_product Vector[0, 1, 0]  # => Vector[0, 0, 1]
  #
  # It is generalized to other dimensions to return a vector perpendicular
  # to the arguments.
  #   Vector[1, 2].cross_product # => Vector[-2, 1]
  #   Vector[1, 0, 0, 0].cross_product(
  #      Vector[0, 1, 0, 0],
  #      Vector[0, 0, 1, 0]
  #   )  #=> Vector[0, 0, 0, 1]
  #
  # @raise [ErrOperationNotDefined]
  #
  # source://matrix//lib/matrix.rb#2326
  def cross(*vs); end

  # Returns the cross product of this vector with the others.
  #   Vector[1, 0, 0].cross_product Vector[0, 1, 0]  # => Vector[0, 0, 1]
  #
  # It is generalized to other dimensions to return a vector perpendicular
  # to the arguments.
  #   Vector[1, 2].cross_product # => Vector[-2, 1]
  #   Vector[1, 0, 0, 0].cross_product(
  #      Vector[0, 1, 0, 0],
  #      Vector[0, 0, 1, 0]
  #   )  #=> Vector[0, 0, 0, 1]
  #
  # @raise [ErrOperationNotDefined]
  #
  # source://matrix//lib/matrix.rb#2326
  def cross_product(*vs); end

  # Returns the inner product of this vector with the other.
  #   Vector[4,7].inner_product Vector[10,1] # => 47
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#2303
  def dot(v); end

  # Iterate over the elements of this vector
  #
  # source://matrix//lib/matrix.rb#2100
  def each(&block); end

  # Iterate over the elements of this vector and +v+ in conjunction.
  #
  # @raise [TypeError]
  #
  # source://matrix//lib/matrix.rb#2109
  def each2(v); end

  # :call-seq:
  #   vector[range]
  #   vector[integer]
  #
  # Returns element or elements of the vector.
  #
  # source://matrix//lib/matrix.rb#2034
  def element(i); end

  # source://matrix//lib/matrix.rb#2445
  def elements_to_f; end

  # source://matrix//lib/matrix.rb#2450
  def elements_to_i; end

  # source://matrix//lib/matrix.rb#2455
  def elements_to_r; end

  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#2203
  def eql?(other); end

  # Makes the matrix frozen and Ractor-shareable
  #
  # source://matrix//lib/matrix.rb#2177
  def freeze; end

  # Returns a hash-code for the vector.
  #
  # source://matrix//lib/matrix.rb#2211
  def hash; end

  # Returns whether all of vectors are linearly independent.
  #
  #   Vector[1,0].independent?(Vector[0,1])
  #   # => true
  #
  #   Vector[1,2].independent?(Vector[2,4])
  #   # => false
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#2163
  def independent?(*vs); end

  # Returns the inner product of this vector with the other.
  #   Vector[4,7].inner_product Vector[10,1] # => 47
  #
  # @raise [ErrDimensionMismatch]
  #
  # source://matrix//lib/matrix.rb#2303
  def inner_product(v); end

  # Overrides Object#inspect
  #
  # source://matrix//lib/matrix.rb#2490
  def inspect; end

  # Returns the modulus (Pythagorean distance) of the vector.
  #   Vector[5,8,2].r # => 9.643650761
  #
  # source://matrix//lib/matrix.rb#2373
  def magnitude; end

  # Like Array#collect.
  #
  # source://matrix//lib/matrix.rb#2351
  def map(&block); end

  # Like Array#collect!
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#2361
  def map!(&block); end

  # Like Vector#collect2, but returns a Vector instead of an Array.
  #
  # source://matrix//lib/matrix.rb#2382
  def map2(v, &block); end

  # Returns the modulus (Pythagorean distance) of the vector.
  #   Vector[5,8,2].r # => 9.643650761
  #
  # source://matrix//lib/matrix.rb#2373
  def norm; end

  # Returns a new vector with the same direction but with norm 1.
  #   v = Vector[5,8,2].normalize
  #   # => Vector[0.5184758473652127, 0.8295613557843402, 0.20739033894608505]
  #   v.norm # => 1.0
  #
  # @raise [ZeroVectorError]
  #
  # source://matrix//lib/matrix.rb#2396
  def normalize; end

  # Returns the modulus (Pythagorean distance) of the vector.
  #   Vector[5,8,2].r # => 9.643650761
  #
  # source://matrix//lib/matrix.rb#2373
  def r; end

  # Returns a vector with entries rounded to the given precision
  # (see Float#round)
  #
  # source://matrix//lib/matrix.rb#2082
  def round(ndigits = T.unsafe(nil)); end

  # Returns the number of elements in the vector.
  #
  # source://matrix//lib/matrix.rb#2089
  def size; end

  # Returns the elements of the vector in an array.
  #
  # source://matrix//lib/matrix.rb#2434
  def to_a; end

  # Return a single-column matrix from this vector
  #
  # source://matrix//lib/matrix.rb#2441
  def to_matrix; end

  # Overrides Object#to_s
  #
  # source://matrix//lib/matrix.rb#2483
  def to_s; end

  # Returns whether all elements are zero.
  #
  # @return [Boolean]
  #
  # source://matrix//lib/matrix.rb#2170
  def zero?; end

  protected

  # Returns the value of attribute elements.
  #
  # source://matrix//lib/matrix.rb#1974
  def elements; end

  private

  # Called for dup & clone.
  #
  # source://matrix//lib/matrix.rb#2185
  def initialize_copy(v); end

  # :call-seq:
  #   vector[range] = new_vector
  #   vector[range] = row_matrix
  #   vector[range] = new_element
  #   vector[integer] = new_element
  #
  # Set element or elements of vector.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#2049
  def set_component(i, v); end

  # :call-seq:
  #   vector[range] = new_vector
  #   vector[range] = row_matrix
  #   vector[range] = new_element
  #   vector[integer] = new_element
  #
  # Set element or elements of vector.
  #
  # @raise [FrozenError]
  #
  # source://matrix//lib/matrix.rb#2049
  def set_element(i, v); end

  # source://matrix//lib/matrix.rb#2067
  def set_range(range, value); end

  # source://matrix//lib/matrix.rb#2063
  def set_value(index, value); end

  class << self
    # Creates a Vector from a list of elements.
    #   Vector[7, 4, ...]
    #
    # source://matrix//lib/matrix.rb#1981
    def [](*array); end

    # Returns a standard basis +n+-vector, where k is the index.
    #
    #    Vector.basis(size:, index:) # => Vector[0, 1, 0]
    #
    # @raise [ArgumentError]
    #
    # source://matrix//lib/matrix.rb#1998
    def basis(size:, index:); end

    # Creates a vector from an Array.  The optional second argument specifies
    # whether the array itself or a copy is used internally.
    #
    # source://matrix//lib/matrix.rb#1989
    def elements(array, copy = T.unsafe(nil)); end

    # Returns whether all of vectors are linearly independent.
    #
    #   Vector.independent?(Vector[1,0], Vector[0,1])
    #   #  => true
    #
    #   Vector.independent?(Vector[1,2], Vector[2,4])
    #   #  => false
    #
    # @return [Boolean]
    #
    # source://matrix//lib/matrix.rb#2145
    def independent?(*vs); end

    # Return a zero vector.
    #
    #    Vector.zero(3) # => Vector[0, 0, 0]
    #
    # @raise [ArgumentError]
    #
    # source://matrix//lib/matrix.rb#2011
    def zero(size); end
  end
end

class Vector::ZeroVectorError < ::StandardError; end
