# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `jmespath` gem.
# Please instead update this file by running `bin/tapioca gem jmespath`.

module JMESPath
  class << self
    # @api private
    #
    # source://jmespath//lib/jmespath.rb#35
    def load_json(path); end

    # @param expression [String] A valid
    #   [JMESPath](https://github.com/boto/jmespath) expression.
    # @param data [Hash]
    # @return [Mixed, nil] Returns the matched values. Returns `nil` if the
    #   expression does not resolve inside `data`.
    #
    # source://jmespath//lib/jmespath.rb#24
    def search(expression, data, runtime_options = T.unsafe(nil)); end
  end
end

class JMESPath::CachingParser
  # @return [CachingParser] a new instance of CachingParser
  #
  # source://jmespath//lib/jmespath/caching_parser.rb#6
  def initialize(options = T.unsafe(nil)); end

  # source://jmespath//lib/jmespath/caching_parser.rb#12
  def parse(expression); end

  private

  # source://jmespath//lib/jmespath/caching_parser.rb#22
  def cache_expression(expression); end
end

module JMESPath::Errors; end
class JMESPath::Errors::Error < ::StandardError; end
class JMESPath::Errors::InvalidArityError < ::JMESPath::Errors::Error; end
class JMESPath::Errors::InvalidTypeError < ::JMESPath::Errors::Error; end
class JMESPath::Errors::InvalidValueError < ::JMESPath::Errors::Error; end
class JMESPath::Errors::RuntimeError < ::JMESPath::Errors::Error; end
class JMESPath::Errors::SyntaxError < ::JMESPath::Errors::Error; end
class JMESPath::Errors::UnknownFunctionError < ::JMESPath::Errors::Error; end

# @api private
class JMESPath::Lexer
  # @api private
  # @param expression [String<JMESPath>]
  # @return [Array<Hash>]
  #
  # source://jmespath//lib/jmespath/lexer.rb#163
  def tokenize(expression); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#277
  def inside(chars, delim, type); end

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#268
  def match_or(chars, current, expected, type, or_type); end

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#346
  def parse_json(token, quoted = T.unsafe(nil)); end

  class << self
    # Certain versions of Ruby and of the pure_json gem not support loading
    # scalar JSON values, such a numbers, booleans, strings, etc. These
    # simple values must be first wrapped inside a JSON object before calling
    # `JSON.parse`.
    #
    #    # works in most JSON versions, raises in some versions
    #    JSON.parse("true")
    #    JSON.parse("123")
    #    JSON.parse("\"abc\"")
    #
    # This is an known issue for:
    #
    # * Ruby 1.9.3 bundled v1.5.5 of json; Ruby 1.9.3 defaults to bundled
    #   version despite newer versions being available.
    #
    # * json_pure v2.0.0+
    #
    # It is not possible to change the version of JSON loaded in the
    # user's application. Adding an explicit dependency on json gem
    # causes issues in environments that cannot compile the gem. We previously
    # had a direct dependency on `json_pure`, but this broke with the v2 update.
    #
    # This method allows us to detect how the `JSON.parse` behaves so we know
    # if we have to wrap scalar JSON values to parse them or not.
    #
    # @api private
    # @return [Boolean]
    #
    # source://jmespath//lib/jmespath/lexer.rb#322
    def requires_wrapping?; end
  end
end

# @api private
class JMESPath::Lexer::CharacterStream
  # @api private
  # @return [CharacterStream] a new instance of CharacterStream
  #
  # source://jmespath//lib/jmespath/lexer.rb#365
  def initialize(chars); end

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#370
  def current; end

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#374
  def next; end

  # @api private
  #
  # source://jmespath//lib/jmespath/lexer.rb#379
  def position; end
end

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#146
JMESPath::Lexer::NUMBERS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#148
JMESPath::Lexer::SIMPLE_TOKENS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#47
JMESPath::Lexer::STATE_AND = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#45
JMESPath::Lexer::STATE_EQ = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#44
JMESPath::Lexer::STATE_GT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#34
JMESPath::Lexer::STATE_IDENTIFIER = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#40
JMESPath::Lexer::STATE_JSON_LITERAL = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#41
JMESPath::Lexer::STATE_LBRACKET = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#43
JMESPath::Lexer::STATE_LT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#46
JMESPath::Lexer::STATE_NOT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#35
JMESPath::Lexer::STATE_NUMBER = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#42
JMESPath::Lexer::STATE_PIPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#39
JMESPath::Lexer::STATE_QUOTED_STRING = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#36
JMESPath::Lexer::STATE_SINGLE_CHAR = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#38
JMESPath::Lexer::STATE_STRING_LITERAL = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#37
JMESPath::Lexer::STATE_WHITESPACE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#49
JMESPath::Lexer::TRANSLATION_TABLE = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#27
JMESPath::Lexer::T_AND = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#11
JMESPath::Lexer::T_COLON = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#10
JMESPath::Lexer::T_COMMA = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#32
JMESPath::Lexer::T_COMPARATOR = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#12
JMESPath::Lexer::T_CURRENT = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#8
JMESPath::Lexer::T_DOT = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#31
JMESPath::Lexer::T_EOF = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#13
JMESPath::Lexer::T_EXPREF = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#29
JMESPath::Lexer::T_FILTER = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#20
JMESPath::Lexer::T_FLATTEN = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#21
JMESPath::Lexer::T_IDENTIFIER = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#16
JMESPath::Lexer::T_LBRACE = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#18
JMESPath::Lexer::T_LBRACKET = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#30
JMESPath::Lexer::T_LITERAL = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#14
JMESPath::Lexer::T_LPAREN = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#28
JMESPath::Lexer::T_NOT = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#22
JMESPath::Lexer::T_NUMBER = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#26
JMESPath::Lexer::T_OR = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#25
JMESPath::Lexer::T_PIPE = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#23
JMESPath::Lexer::T_QUOTED_IDENTIFIER = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#17
JMESPath::Lexer::T_RBRACE = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#19
JMESPath::Lexer::T_RBRACKET = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#15
JMESPath::Lexer::T_RPAREN = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#9
JMESPath::Lexer::T_STAR = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#24
JMESPath::Lexer::T_UNKNOWN = T.let(T.unsafe(nil), Symbol)

# @api private
#
# source://jmespath//lib/jmespath/lexer.rb#140
JMESPath::Lexer::VALID_IDENTIFIERS = T.let(T.unsafe(nil), Set)

# @api private
module JMESPath::Nodes; end

# @api private
class JMESPath::Nodes::AbsFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#90
  def call(args); end
end

class JMESPath::Nodes::And < ::JMESPath::Nodes::Node
  # @return [And] a new instance of And
  #
  # source://jmespath//lib/jmespath/nodes/and.rb#5
  def initialize(left, right); end

  # source://jmespath//lib/jmespath/nodes/and.rb#19
  def optimize; end

  # source://jmespath//lib/jmespath/nodes/and.rb#10
  def visit(value); end
end

# @api private
class JMESPath::Nodes::ArrayProjection < ::JMESPath::Nodes::Projection
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#46
  def extract_targets(target); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#50
  def fast_instance; end
end

# @api private
class JMESPath::Nodes::AvgFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#107
  def call(args); end
end

# @api private
class JMESPath::Nodes::CeilFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#132
  def call(args); end
end

# @api private
class JMESPath::Nodes::Chain
  # @api private
  # @return [Chain] a new instance of Chain
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#39
  def initialize(children); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#49
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#43
  def visit(value); end
end

# @api private
class JMESPath::Nodes::ChainedField < ::JMESPath::Nodes::Field
  # @api private
  # @return [ChainedField] a new instance of ChainedField
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#42
  def initialize(keys); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#66
  def chain(other); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#49
  def visit(obj); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#72
  def keys; end
end

# @api private
class JMESPath::Nodes::Comparator < ::JMESPath::Nodes::Node
  # @api private
  # @return [Comparator] a new instance of Comparator
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#10
  def initialize(left, right); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#8
  def left; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#33
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#8
  def right; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#29
  def visit(value); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#39
  def check(_left_value, _right_value); end

  # @api private
  # @return [Boolean]
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#43
  def comparable?(left_value, right_value); end

  class << self
    # @api private
    #
    # source://jmespath//lib/jmespath/nodes/comparator.rb#15
    def create(relation, left, right); end
  end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/comparator.rb#6
JMESPath::Nodes::Comparator::COMPARABLE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
class JMESPath::Nodes::ComparatorCondition < ::JMESPath::Nodes::Node
  # @api private
  # @return [ComparatorCondition] a new instance of ComparatorCondition
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#33
  def initialize(left, right, child); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#39
  def visit(_value); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#45
  def comparable?(left_value, right_value); end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/condition.rb#31
JMESPath::Nodes::ComparatorCondition::COMPARABLE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
#
# source://jmespath//lib/jmespath/nodes/condition.rb#30
JMESPath::Nodes::ComparatorCondition::COMPARATOR_TO_CONDITION = T.let(T.unsafe(nil), Hash)

# @api private
module JMESPath::Nodes::Comparators; end

# @api private
class JMESPath::Nodes::Comparators::Eq < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#52
  def check(left_value, right_value); end
end

# @api private
class JMESPath::Nodes::Comparators::Gt < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#64
  def check(left_value, right_value); end
end

# @api private
class JMESPath::Nodes::Comparators::Gte < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#70
  def check(left_value, right_value); end
end

# @api private
class JMESPath::Nodes::Comparators::Lt < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#76
  def check(left_value, right_value); end
end

# @api private
class JMESPath::Nodes::Comparators::Lte < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#82
  def check(left_value, right_value); end
end

# @api private
class JMESPath::Nodes::Comparators::Neq < ::JMESPath::Nodes::Comparator
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/comparator.rb#58
  def check(left_value, right_value); end
end

# @api private
module JMESPath::Nodes::CompareBy
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#506
  def compare_by(mode, *args); end
end

# @api private
class JMESPath::Nodes::Condition < ::JMESPath::Nodes::Node
  # @api private
  # @return [Condition] a new instance of Condition
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#6
  def initialize(test, child); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#19
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#11
  def visit(value); end
end

# @api private
class JMESPath::Nodes::ContainsFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#149
  def call(args); end
end

# @api private
class JMESPath::Nodes::Current < ::JMESPath::Nodes::Node
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/current.rb#6
  def visit(value); end
end

# @api private
class JMESPath::Nodes::EndsWithFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#563
  def call(args); end
end

# @api private
class JMESPath::Nodes::EqCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#59
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#55
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Expression < ::JMESPath::Nodes::Node
  # @api private
  # @return [Expression] a new instance of Expression
  #
  # source://jmespath//lib/jmespath/nodes/expression.rb#8
  def initialize(expression); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/expression.rb#16
  def eval(value); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/expression.rb#6
  def expression; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/expression.rb#20
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/expression.rb#12
  def visit(_value); end
end

# @api private
class JMESPath::Nodes::FastArrayProjection < ::JMESPath::Nodes::ArrayProjection
  include ::JMESPath::Nodes::FastProjector
end

# @api private
class JMESPath::Nodes::FastObjectProjection < ::JMESPath::Nodes::ObjectProjection
  include ::JMESPath::Nodes::FastProjector
end

# @api private
module JMESPath::Nodes::FastProjector
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#38
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Field < ::JMESPath::Nodes::Node
  # @api private
  # @return [Field] a new instance of Field
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#6
  def initialize(key); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#30
  def chain(other); end

  # @api private
  # @return [Boolean]
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#26
  def chains_with?(other); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#11
  def visit(value); end

  protected

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/field.rb#36
  def keys; end
end

# @api private
class JMESPath::Nodes::Flatten < ::JMESPath::Nodes::Node
  # @api private
  # @return [Flatten] a new instance of Flatten
  #
  # source://jmespath//lib/jmespath/nodes/flatten.rb#6
  def initialize(child); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/flatten.rb#23
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/flatten.rb#10
  def visit(value); end
end

# @api private
class JMESPath::Nodes::FloorFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#169
  def call(args); end
end

# @api private
class JMESPath::Nodes::Function < ::JMESPath::Nodes::Node
  # @api private
  # @return [Function] a new instance of Function
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#8
  def initialize(children, options = T.unsafe(nil)); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#26
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#22
  def visit(value); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#44
  def call(_args); end

  # @api private
  # @raise [error_type]
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#40
  def maybe_raise(error_type, message); end

  class << self
    # @api private
    #
    # source://jmespath//lib/jmespath/nodes/function.rb#14
    def create(name, children, options = T.unsafe(nil)); end
  end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#6
JMESPath::Nodes::Function::FUNCTIONS = T.let(T.unsafe(nil), Hash)

# @api private
class JMESPath::Nodes::Function::FunctionName
  # @api private
  # @return [FunctionName] a new instance of FunctionName
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#33
  def initialize(name); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#31
  def name; end
end

# @api private
class JMESPath::Nodes::GtCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#109
  def visit(value); end
end

# @api private
class JMESPath::Nodes::GteCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#119
  def visit(value); end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/index.rb#5
JMESPath::Nodes::Index = JMESPath::Nodes::Field

# @api private
class JMESPath::Nodes::JoinFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#354
  def call(args); end
end

# @api private
class JMESPath::Nodes::KeysFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#314
  def call(args); end
end

# @api private
class JMESPath::Nodes::LengthFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#186
  def call(args); end
end

# @api private
class JMESPath::Nodes::Literal < ::JMESPath::Nodes::Node
  # @api private
  # @return [Literal] a new instance of Literal
  #
  # source://jmespath//lib/jmespath/nodes/literal.rb#8
  def initialize(value); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/literal.rb#6
  def value; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/literal.rb#12
  def visit(_value); end
end

# @api private
class JMESPath::Nodes::LiteralRightEqCondition < ::JMESPath::Nodes::EqCondition
  # @api private
  # @return [LiteralRightEqCondition] a new instance of LiteralRightEqCondition
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#69
  def initialize(left, right, child); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#74
  def visit(value); end
end

# @api private
class JMESPath::Nodes::LiteralRightNeqCondition < ::JMESPath::Nodes::NeqCondition
  # @api private
  # @return [LiteralRightNeqCondition] a new instance of LiteralRightNeqCondition
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#96
  def initialize(left, right, child); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#101
  def visit(value); end
end

# @api private
class JMESPath::Nodes::LtCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#129
  def visit(value); end
end

# @api private
class JMESPath::Nodes::LteCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#139
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Map < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#207
  def call(args); end
end

# @api private
class JMESPath::Nodes::MaxByFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker
  include ::JMESPath::Nodes::CompareBy

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#543
  def call(args); end
end

# @api private
class JMESPath::Nodes::MaxFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#230
  def call(args); end
end

# @api private
class JMESPath::Nodes::MergeFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#613
  def call(args); end
end

# @api private
class JMESPath::Nodes::MinByFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker
  include ::JMESPath::Nodes::CompareBy

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#553
  def call(args); end
end

# @api private
class JMESPath::Nodes::MinFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#266
  def call(args); end
end

# @api private
class JMESPath::Nodes::MultiSelectHash < ::JMESPath::Nodes::Node
  # @api private
  # @return [MultiSelectHash] a new instance of MultiSelectHash
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#6
  def initialize(kv_pairs); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#20
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#10
  def visit(value); end
end

# @api private
class JMESPath::Nodes::MultiSelectHash::KeyValuePair
  # @api private
  # @return [KeyValuePair] a new instance of KeyValuePair
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#27
  def initialize(key, value); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#25
  def key; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#32
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_hash.rb#25
  def value; end
end

# @api private
class JMESPath::Nodes::MultiSelectList < ::JMESPath::Nodes::Node
  # @api private
  # @return [MultiSelectList] a new instance of MultiSelectList
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_list.rb#6
  def initialize(children); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_list.rb#18
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/multi_select_list.rb#10
  def visit(value); end
end

# @api private
class JMESPath::Nodes::NeqCondition < ::JMESPath::Nodes::ComparatorCondition
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#86
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/condition.rb#82
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Node
  # @api private
  # @return [Boolean]
  #
  # source://jmespath//lib/jmespath/nodes.rb#13
  def chains_with?(_other); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes.rb#9
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes.rb#6
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Not < ::JMESPath::Nodes::Node
  # @api private
  # @return [Not] a new instance of Not
  #
  # source://jmespath//lib/jmespath/nodes/not.rb#5
  def initialize(expression); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/not.rb#13
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/not.rb#9
  def visit(value); end
end

# @api private
class JMESPath::Nodes::NotNullFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#422
  def call(args); end
end

# @api private
class JMESPath::Nodes::ObjectProjection < ::JMESPath::Nodes::Projection
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#60
  def extract_targets(target); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#68
  def fast_instance; end
end

# @api private
class JMESPath::Nodes::Or < ::JMESPath::Nodes::Node
  # @api private
  # @return [Or] a new instance of Or
  #
  # source://jmespath//lib/jmespath/nodes/or.rb#6
  def initialize(left, right); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/or.rb#20
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/or.rb#11
  def visit(value); end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/pipe.rb#5
JMESPath::Nodes::Pipe = JMESPath::Nodes::Subexpression

# @api private
class JMESPath::Nodes::Projection < ::JMESPath::Nodes::Node
  # @api private
  # @return [Projection] a new instance of Projection
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#6
  def initialize(target, projection); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#22
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#11
  def visit(value); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/projection.rb#32
  def extract_targets(_left_value); end
end

# @api private
class JMESPath::Nodes::ReverseFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#627
  def call(args); end
end

# @api private
class JMESPath::Nodes::SimpleSlice < ::JMESPath::Nodes::Slice
  # @api private
  # @return [SimpleSlice] a new instance of SimpleSlice
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#75
  def initialize(start, stop); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#79
  def visit(value); end
end

# @api private
class JMESPath::Nodes::Slice < ::JMESPath::Nodes::Node
  # @api private
  # @raise [Errors::InvalidValueError]
  # @return [Slice] a new instance of Slice
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#6
  def initialize(start, stop, step); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#34
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#13
  def visit(value); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#61
  def adjust_endpoint(length, endpoint, step); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/slice.rb#44
  def adjust_slice(length, start, stop, step); end
end

# @api private
class JMESPath::Nodes::SortByFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#472
  def call(args); end
end

# @api private
class JMESPath::Nodes::SortFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#436
  def call(args); end
end

# @api private
class JMESPath::Nodes::StartsWithFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#589
  def call(args); end
end

# @api private
class JMESPath::Nodes::Subexpression < ::JMESPath::Nodes::Node
  # @api private
  # @return [Subexpression] a new instance of Subexpression
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#6
  def initialize(left, right); end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#15
  def optimize; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#11
  def visit(value); end

  protected

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#23
  def flatten; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#21
  def left; end

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/subexpression.rb#21
  def right; end
end

# @api private
class JMESPath::Nodes::SumFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#404
  def call(args); end
end

# @api private
class JMESPath::Nodes::ToArrayFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#647
  def call(args); end
end

# @api private
class JMESPath::Nodes::ToNumberFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#387
  def call(args); end
end

# @api private
class JMESPath::Nodes::ToStringFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#374
  def call(args); end
end

# @api private
module JMESPath::Nodes::TypeChecker
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#50
  def get_type(value); end
end

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#68
JMESPath::Nodes::TypeChecker::ARRAY_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#69
JMESPath::Nodes::TypeChecker::BOOLEAN_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#70
JMESPath::Nodes::TypeChecker::EXPRESSION_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#71
JMESPath::Nodes::TypeChecker::NULL_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#72
JMESPath::Nodes::TypeChecker::NUMBER_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#73
JMESPath::Nodes::TypeChecker::OBJECT_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#74
JMESPath::Nodes::TypeChecker::STRING_TYPE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://jmespath//lib/jmespath/nodes/function.rb#76
JMESPath::Nodes::TypeChecker::TYPE_NAMES = T.let(T.unsafe(nil), Hash)

# @api private
class JMESPath::Nodes::TypeFunction < ::JMESPath::Nodes::Function
  include ::JMESPath::Nodes::TypeChecker

  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#302
  def call(args); end
end

# @api private
class JMESPath::Nodes::ValuesFunction < ::JMESPath::Nodes::Function
  # @api private
  #
  # source://jmespath//lib/jmespath/nodes/function.rb#333
  def call(args); end
end

# @api private
class JMESPath::Parser
  # @api private
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Parser] a new instance of Parser
  #
  # source://jmespath//lib/jmespath/parser.rb#30
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#48
  def method_missing(method_name, *args); end

  # @api private
  # @param expression [String<JMESPath>]
  #
  # source://jmespath//lib/jmespath/parser.rb#36
  def parse(expression); end

  private

  # @api private
  # @param stream [TokenStream]
  # @param rbp [Integer] Right binding power
  #
  # source://jmespath//lib/jmespath/parser.rb#60
  def expr(stream, rbp = T.unsafe(nil)); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#230
  def led_and(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#160
  def led_comparator(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#167
  def led_dot(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#177
  def led_filter(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#190
  def led_flatten(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#197
  def led_lbracket(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#208
  def led_lparen(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#224
  def led_or(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#236
  def led_pipe(stream, left); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#68
  def nud_current(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#73
  def nud_expref(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#93
  def nud_filter(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#97
  def nud_flatten(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#101
  def nud_identifier(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#111
  def nud_lbrace(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#123
  def nud_lbracket(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#135
  def nud_literal(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#83
  def nud_lparen(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#78
  def nud_not(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#141
  def nud_quoted_identifier(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#152
  def nud_star(stream); end

  # @api private
  # @raise [Errors::SyntaxError]
  #
  # source://jmespath//lib/jmespath/parser.rb#156
  def nud_unknown(stream); end

  # parse array index expressions, for example [0], [1:2:3], etc.
  #
  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#243
  def parse_array_index_expression(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#274
  def parse_dot(stream, binding_power); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#283
  def parse_key_value_pair(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#290
  def parse_multi_select_list(stream); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#305
  def parse_projection(stream, binding_power); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#319
  def parse_wildcard_array(stream, left = T.unsafe(nil)); end

  # @api private
  #
  # source://jmespath//lib/jmespath/parser.rb#327
  def parse_wildcard_object(stream, left = T.unsafe(nil)); end
end

# @api private
#
# source://jmespath//lib/jmespath/parser.rb#7
JMESPath::Parser::AFTER_DOT = T.let(T.unsafe(nil), Set)

# @api private
#
# source://jmespath//lib/jmespath/parser.rb#22
JMESPath::Parser::COLON_RBRACKET = T.let(T.unsafe(nil), Set)

# @api private
#
# source://jmespath//lib/jmespath/parser.rb#27
JMESPath::Parser::CURRENT_NODE = T.let(T.unsafe(nil), JMESPath::Nodes::Current)

# @api private
#
# source://jmespath//lib/jmespath/parser.rb#16
JMESPath::Parser::NUM_COLON_RBRACKET = T.let(T.unsafe(nil), Set)

# @api private
class JMESPath::Runtime
  # Constructs a new runtime object for evaluating JMESPath expressions.
  #
  #     runtime = JMESPath::Runtime.new
  #     runtime.search(expression, data)
  #     #=> ...
  #
  # ## Caching
  #
  # When constructing a {Runtime}, the default parser caches expressions.
  # This significantly speeds up calls to {#search} multiple times
  # with the same expression but different data. To disable caching, pass
  # `:cache_expressions => false` to the constructor or pass a custom
  # `:parser`.
  #
  # @api private
  # @example Re-use a Runtime, caching enabled by default
  #
  #   runtime = JMESPath::Runtime.new
  #   runtime.parser
  #   #=> #<JMESPath::CachingParser ...>
  # @example Disable caching
  #
  #   runtime = JMESPath::Runtime.new(cache_expressions: false)
  #   runtime.parser
  #   #=> #<JMESPath::Parser ...>
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Runtime] a new instance of Runtime
  #
  # source://jmespath//lib/jmespath/runtime.rb#45
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Parser, CachingParser]
  #
  # source://jmespath//lib/jmespath/runtime.rb#50
  def parser; end

  # @api private
  # @param expression [String<JMESPath>]
  # @param data [Hash]
  # @return [Mixed, nil]
  #
  # source://jmespath//lib/jmespath/runtime.rb#55
  def search(expression, data); end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/runtime.rb#62
  def default_parser(options); end
end

# @api private
#
# source://jmespath//lib/jmespath/runtime.rb#6
JMESPath::Runtime::DEFAULT_PARSER = JMESPath::CachingParser

# @api private
class JMESPath::Token < ::Struct
  # @api private
  # @param type [Symbol]
  # @param value [Mixed]
  # @param position [Integer]
  # @return [Token] a new instance of Token
  #
  # source://jmespath//lib/jmespath/token.rb#37
  def initialize(type, value, position); end
end

# @api private
#
# source://jmespath//lib/jmespath/token.rb#7
JMESPath::Token::BINDING_POWER = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://jmespath//lib/jmespath/token.rb#5
JMESPath::Token::NULL_TOKEN = T.let(T.unsafe(nil), JMESPath::Token)

# @api private
class JMESPath::TokenStream
  # @api private
  # @param expression [String<JMESPath>]
  # @param tokens [Array<Token>]
  # @return [TokenStream] a new instance of TokenStream
  #
  # source://jmespath//lib/jmespath/token_stream.rb#7
  def initialize(expression, tokens); end

  # @api private
  # @return [String<JMESPath>]
  #
  # source://jmespath//lib/jmespath/token_stream.rb#16
  def expression; end

  # @api private
  #
  # source://jmespath//lib/jmespath/token_stream.rb#35
  def inspect; end

  # @api private
  #
  # source://jmespath//lib/jmespath/token_stream.rb#30
  def lookahead(count); end

  # @api private
  # @option options
  # @param options [Hash] a customizable set of options
  #
  # source://jmespath//lib/jmespath/token_stream.rb#26
  def next(options = T.unsafe(nil)); end

  # @api private
  # @return [Integer]
  #
  # source://jmespath//lib/jmespath/token_stream.rb#22
  def position; end

  # @api private
  # @return [Token]
  #
  # source://jmespath//lib/jmespath/token_stream.rb#19
  def token; end

  private

  # @api private
  #
  # source://jmespath//lib/jmespath/token_stream.rb#46
  def _next; end

  # @api private
  #
  # source://jmespath//lib/jmespath/token_stream.rb#51
  def validate_match(token, match); end
end

# @api private
module JMESPath::Util
  class << self
    # @api private
    #
    # source://jmespath//lib/jmespath/util.rb#19
    def as_json(value); end

    # Determines if a value is false as defined by JMESPath:
    #
    #   https://github.com/jmespath/jmespath.site/blob/master/docs/proposals/improved-filters.rst#and-expressions-1
    #
    # @api private
    # @return [Boolean]
    #
    # source://jmespath//lib/jmespath/util.rb#10
    def falsey?(value); end
  end
end

# source://jmespath//lib/jmespath/version.rb#3
JMESPath::VERSION = T.let(T.unsafe(nil), String)
