# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `i18n` gem.
# Please instead update this file by running `bin/tapioca gem i18n`.

# Simple Locale tag implementation that computes subtags by simply splitting
# the locale tag at '-' occurrences.
module I18n
  extend ::I18n::Base

  class << self
    # source://i18n//lib/i18n/backend/cache.rb#64
    def cache_key_digest; end

    # source://i18n//lib/i18n/backend/cache.rb#68
    def cache_key_digest=(key_digest); end

    # source://i18n//lib/i18n/backend/cache.rb#56
    def cache_namespace; end

    # source://i18n//lib/i18n/backend/cache.rb#60
    def cache_namespace=(namespace); end

    # source://i18n//lib/i18n/backend/cache.rb#48
    def cache_store; end

    # source://i18n//lib/i18n/backend/cache.rb#52
    def cache_store=(store); end

    # Returns the current fallbacks implementation. Defaults to +I18n::Locale::Fallbacks+.
    #
    # source://i18n//lib/i18n/backend/fallbacks.rb#17
    def fallbacks; end

    # Sets the current fallbacks implementation. Use this to set a different fallbacks implementation.
    #
    # source://i18n//lib/i18n/backend/fallbacks.rb#23
    def fallbacks=(fallbacks); end

    # Return String or raises MissingInterpolationArgument exception.
    # Missing argument's logic is handled by I18n.config.missing_interpolation_argument_handler.
    #
    # @raise [ReservedInterpolationKey]
    #
    # source://i18n//lib/i18n/interpolate/ruby.rb#16
    def interpolate(string, values); end

    # source://i18n//lib/i18n/interpolate/ruby.rb#22
    def interpolate_hash(string, values); end

    # source://i18n//lib/i18n.rb#37
    def new_double_nested_cache; end

    # @return [Boolean]
    #
    # source://i18n//lib/i18n/backend/cache.rb#72
    def perform_caching?; end

    # Marks a key as reserved. Reserved keys are used internally,
    # and can't also be used for interpolation. If you are using any
    # extra keys as I18n options, you should call I18n.reserve_key
    # before any I18n.translate (etc) calls are made.
    #
    # source://i18n//lib/i18n.rb#45
    def reserve_key(key); end

    # source://i18n//lib/i18n.rb#50
    def reserved_keys_pattern; end
  end
end

class I18n::ArgumentError < ::ArgumentError; end
module I18n::Backend; end

module I18n::Backend::Base
  include ::I18n::Backend::Transliterator

  # Returns an array of locales for which translations are available
  # ignoring the reserved translation meta data key :i18n.
  #
  # @raise [NotImplementedError]
  #
  # source://i18n//lib/i18n/backend/base.rb#94
  def available_locales; end

  # source://i18n//lib/i18n/backend/base.rb#102
  def eager_load!; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/base.rb#68
  def exists?(locale, key, options = T.unsafe(nil)); end

  # Accepts a list of paths to translation files. Loads translations from
  # plain Ruby (*.rb), YAML files (*.yml), or JSON files (*.json). See #load_rb, #load_yml, and #load_json
  # for details.
  #
  # source://i18n//lib/i18n/backend/base.rb#14
  def load_translations(*filenames); end

  # Acts the same as +strftime+, but uses a localized version of the
  # format string. Takes a key from the date/time formats translations as
  # a format argument (<em>e.g.</em>, <tt>:short</tt> in <tt>:'date.formats'</tt>).
  #
  # @raise [ArgumentError]
  #
  # source://i18n//lib/i18n/backend/base.rb#75
  def localize(locale, object, format = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/base.rb#98
  def reload!; end

  # This method receives a locale, a data hash and options for storing translations.
  # Should be implemented
  #
  # @raise [NotImplementedError]
  #
  # source://i18n//lib/i18n/backend/base.rb#24
  def store_translations(locale, data, options = T.unsafe(nil)); end

  # @raise [I18n::ArgumentError]
  #
  # source://i18n//lib/i18n/backend/base.rb#28
  def translate(locale, key, options = T.unsafe(nil)); end

  protected

  # Deep interpolation
  #
  #   deep_interpolate { people: { ann: "Ann is %{ann}", john: "John is %{john}" } },
  #                    ann: 'good', john: 'big'
  #   #=> { people: { ann: "Ann is good", john: "John is big" } }
  #
  # source://i18n//lib/i18n/backend/base.rb#202
  def deep_interpolate(locale, data, values = T.unsafe(nil)); end

  # Evaluates defaults.
  # If given subject is an Array, it walks the array and returns the
  # first translation that can be resolved. Otherwise it tries to resolve
  # the translation directly.
  #
  # source://i18n//lib/i18n/backend/base.rb#125
  def default(locale, object, subject, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/base.rb#108
  def eager_loaded?; end

  # Interpolates values into a given subject.
  #
  #   if the given subject is a string then:
  #   method interpolates "file %{file} opened by %%{user}", :file => 'test.txt', :user => 'Mr. X'
  #   # => "file test.txt opened by %{user}"
  #
  #   if the given subject is an array then:
  #   each element of the array is recursively interpolated (until it finds a string)
  #   method interpolates ["yes, %{user}", ["maybe no, %{user}, "no, %{user}"]], :user => "bartuz"
  #   # => "["yes, bartuz",["maybe no, bartuz", "no, bartuz"]]"
  #
  # source://i18n//lib/i18n/backend/base.rb#186
  def interpolate(locale, subject, values = T.unsafe(nil)); end

  # Loads a single translations file by delegating to #load_rb or
  # #load_yml depending on the file extension and directly merges the
  # data to the existing translations. Raises I18n::UnknownFileType
  # for all other file extensions.
  #
  # @raise [UnknownFileType]
  #
  # source://i18n//lib/i18n/backend/base.rb#225
  def load_file(filename); end

  # Loads a JSON translations file. The data must have locales as
  # toplevel keys.
  #
  # source://i18n//lib/i18n/backend/base.rb#261
  def load_json(filename); end

  # Loads a plain Ruby translations file. eval'ing the file must yield
  # a Hash containing translation data with locales as toplevel keys.
  #
  # source://i18n//lib/i18n/backend/base.rb#239
  def load_rb(filename); end

  # Loads a YAML translations file. The data must have locales as
  # toplevel keys.
  #
  # source://i18n//lib/i18n/backend/base.rb#246
  def load_yaml(filename); end

  # Loads a YAML translations file. The data must have locales as
  # toplevel keys.
  #
  # source://i18n//lib/i18n/backend/base.rb#246
  def load_yml(filename); end

  # The method which actually looks up for the translation in the store.
  #
  # @raise [NotImplementedError]
  #
  # source://i18n//lib/i18n/backend/base.rb#113
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/base.rb#293
  def pluralization_key(entry, count); end

  # Picks a translation from a pluralized mnemonic subkey according to English
  # pluralization rules :
  # - It will pick the :one subkey if count is equal to 1.
  # - It will pick the :other subkey otherwise.
  # - It will pick the :zero subkey in the special case where count is
  #   equal to 0 and there is a :zero subkey present. This behaviour is
  #   not standard with regards to the CLDR pluralization rules.
  # Other backends can implement more flexible or complex pluralization rules.
  #
  # @raise [InvalidPluralizationData]
  #
  # source://i18n//lib/i18n/backend/base.rb#167
  def pluralize(locale, entry, count); end

  # Resolves a translation.
  # If the given subject is a Symbol, it will be translated with the
  # given options. If it is a Proc then it will be evaluated. All other
  # subjects will be returned directly.
  #
  # source://i18n//lib/i18n/backend/base.rb#142
  def resolve(locale, object, subject, options = T.unsafe(nil)); end

  # Resolves a translation.
  # If the given subject is a Symbol, it will be translated with the
  # given options. If it is a Proc then it will be evaluated. All other
  # subjects will be returned directly.
  #
  # source://i18n//lib/i18n/backend/base.rb#142
  def resolve_entry(locale, object, subject, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/base.rb#117
  def subtrees?; end

  # source://i18n//lib/i18n/backend/base.rb#274
  def translate_localization_format(locale, object, format, options); end
end

# TODO Should the cache be cleared if new translations are stored?
module I18n::Backend::Cache
  # source://i18n//lib/i18n/backend/cache.rb#80
  def translate(locale, key, options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/cache.rb#93
  def _fetch(cache_key, &block); end

  # source://i18n//lib/i18n/backend/cache.rb#101
  def cache_key(locale, key, options); end

  # source://i18n//lib/i18n/backend/cache.rb#86
  def fetch(cache_key, &block); end

  private

  # source://i18n//lib/i18n/backend/cache.rb#108
  def digest_item(key); end
end

# Overwrites the Base load_file method to cache loaded file contents.
module I18n::Backend::CacheFile
  # Optionally provide path_roots array to normalize filename paths,
  # to make the cached i18n data portable across environments.
  #
  # source://i18n//lib/i18n/backend/cache_file.rb#11
  def path_roots; end

  # Optionally provide path_roots array to normalize filename paths,
  # to make the cached i18n data portable across environments.
  #
  # source://i18n//lib/i18n/backend/cache_file.rb#11
  def path_roots=(_arg0); end

  protected

  # Track loaded translation files in the `i18n.load_file` scope,
  # and skip loading the file if its contents are still up-to-date.
  #
  # source://i18n//lib/i18n/backend/cache_file.rb#17
  def load_file(filename); end

  # Translate absolute filename to relative path for i18n key.
  #
  # source://i18n//lib/i18n/backend/cache_file.rb#28
  def normalized_path(file); end
end

module I18n::Backend::Cascade
  # source://i18n//lib/i18n/backend/cascade.rb#36
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end
end

# Backend that chains multiple other backends and checks each of them when
# a translation needs to be looked up. This is useful when you want to use
# standard translations with a Simple backend but store custom application
# translations in a database or other backends.
#
# To use the Chain backend instantiate it and set it to the I18n module.
# You can add chained backends through the initializer or backends
# accessor:
#
#   # preserves the existing Simple backend set to I18n.backend
#   I18n.backend = I18n::Backend::Chain.new(I18n::Backend::ActiveRecord.new, I18n.backend)
#
# The implementation assumes that all backends added to the Chain implement
# a lookup method with the same API as Simple backend does.
class I18n::Backend::Chain
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base
  include ::I18n::Backend::Chain::Implementation
end

module I18n::Backend::Chain::Implementation
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base

  # source://i18n//lib/i18n/backend/chain.rb#25
  def initialize(*backends); end

  # source://i18n//lib/i18n/backend/chain.rb#50
  def available_locales; end

  # Returns the value of attribute backends.
  #
  # source://i18n//lib/i18n/backend/chain.rb#23
  def backends; end

  # Sets the attribute backends
  #
  # @param value the value to set the attribute backends to.
  #
  # source://i18n//lib/i18n/backend/chain.rb#23
  def backends=(_arg0); end

  # source://i18n//lib/i18n/backend/chain.rb#42
  def eager_load!; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/chain.rb#74
  def exists?(locale, key, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/chain.rb#29
  def initialized?; end

  # source://i18n//lib/i18n/backend/chain.rb#80
  def localize(locale, object, format = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/chain.rb#38
  def reload!; end

  # source://i18n//lib/i18n/backend/chain.rb#46
  def store_translations(locale, data, options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/chain.rb#54
  def translate(locale, key, default_options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/chain.rb#90
  def init_translations; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/chain.rb#106
  def namespace_lookup?(result, options); end

  # source://i18n//lib/i18n/backend/chain.rb#96
  def translations; end

  private

  # This is approximately what gets used in ActiveSupport.
  # However since we are not guaranteed to run in an ActiveSupport context
  # it is wise to have our own copy. We underscore it
  # to not pollute the namespace of the including class.
  #
  # source://i18n//lib/i18n/backend/chain.rb#115
  def _deep_merge(hash, other_hash); end
end

module I18n::Backend::Fallbacks
  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/fallbacks.rb#94
  def exists?(locale, key, options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/fallbacks.rb#85
  def extract_non_symbol_default!(options); end

  # source://i18n//lib/i18n/backend/fallbacks.rb#67
  def resolve_entry(locale, object, subject, options = T.unsafe(nil)); end

  # Overwrites the Base backend translate method so that it will try each
  # locale given by I18n.fallbacks for the given locale. E.g. for the
  # locale :"de-DE" it might try the locales :"de-DE", :de and :en
  # (depends on the fallbacks implementation) until it finds a result with
  # the given options. If it does not find any result for any of the
  # locales it will then throw MissingTranslation as usual.
  #
  # The default option takes precedence over fallback locales only when
  # it's a Symbol. When the default contains a String, Proc or Hash
  # it is evaluated last after all the fallback locales have been tried.
  #
  # source://i18n//lib/i18n/backend/fallbacks.rb#41
  def translate(locale, key, options = T.unsafe(nil)); end

  private

  # Overwrite on_fallback to add specified logic when the fallback succeeds.
  #
  # source://i18n//lib/i18n/backend/fallbacks.rb#110
  def on_fallback(_original_locale, _fallback_locale, _key, _options); end
end

# This module contains several helpers to assist flattening translations.
# You may want to flatten translations for:
#
#   1) speed up lookups, as in the Memoize backend;
#   2) In case you want to store translations in a data store, as in ActiveRecord backend;
#
# You can check both backends above for some examples.
# This module also keeps all links in a hash so they can be properly resolved when flattened.
module I18n::Backend::Flatten
  # Flatten keys for nested Hashes by chaining up keys:
  #
  #   >> { "a" => { "b" => { "c" => "d", "e" => "f" }, "g" => "h" }, "i" => "j"}.wind
  #   => { "a.b.c" => "d", "a.b.e" => "f", "a.g" => "h", "i" => "j" }
  #
  # source://i18n//lib/i18n/backend/flatten.rb#59
  def flatten_keys(hash, escape, prev_key = T.unsafe(nil), &block); end

  # Receives a hash of translations (where the key is a locale and
  # the value is another hash) and return a hash with all
  # translations flattened.
  #
  # Nested hashes are included in the flattened hash just if subtree
  # is true and Symbols are automatically stored as links.
  #
  # source://i18n//lib/i18n/backend/flatten.rb#74
  def flatten_translations(locale, data, escape, subtree); end

  # Store flattened links.
  #
  # source://i18n//lib/i18n/backend/flatten.rb#50
  def links; end

  # Shortcut to I18n::Backend::Flatten.normalize_flat_keys
  # and then resolve_links.
  #
  # source://i18n//lib/i18n/backend/flatten.rb#44
  def normalize_flat_keys(locale, key, scope, separator); end

  protected

  # source://i18n//lib/i18n/backend/flatten.rb#112
  def escape_default_separator(key); end

  # source://i18n//lib/i18n/backend/flatten.rb#106
  def find_link(locale, key); end

  # source://i18n//lib/i18n/backend/flatten.rb#93
  def resolve_link(locale, key); end

  # source://i18n//lib/i18n/backend/flatten.rb#89
  def store_link(locale, key, link); end

  class << self
    # Receives a string and escape the default separator.
    #
    # source://i18n//lib/i18n/backend/flatten.rb#38
    def escape_default_separator(key); end

    # normalize_keys the flatten way. This method is significantly faster
    # and creates way less objects than the one at I18n.normalize_keys.
    # It also handles escaping the translation keys.
    #
    # source://i18n//lib/i18n/backend/flatten.rb#20
    def normalize_flat_keys(locale, key, scope, separator); end
  end
end

# source://i18n//lib/i18n/backend/flatten.rb#15
I18n::Backend::Flatten::FLATTEN_SEPARATOR = T.let(T.unsafe(nil), String)

# source://i18n//lib/i18n/backend/flatten.rb#14
I18n::Backend::Flatten::SEPARATOR_ESCAPE_CHAR = T.let(T.unsafe(nil), String)

# Experimental support for using Gettext po files to store translations.
#
# To use this you can simply include the module to the Simple backend - or
# whatever other backend you are using.
#
#  I18n::Backend::Simple.include(I18n::Backend::Gettext)
#
# Now you should be able to include your Gettext translation (*.po) files to
# the +I18n.load_path+ so they're loaded to the backend and you can use them as
# usual:
#
#  I18n.load_path += Dir["path/to/locales/*.po"]
#
# Following the Gettext convention this implementation expects that your
# translation files are named by their locales. E.g. the file en.po would
# contain the translations for the English locale.
#
# To translate text <b>you must use</b> one of the translate methods provided by
# I18n::Gettext::Helpers.
#
#  include I18n::Gettext::Helpers
#  puts _("some string")
#
# Without it strings containing periods (".") will not be translated.
module I18n::Backend::Gettext
  protected

  # source://i18n//lib/i18n/backend/gettext.rb#41
  def load_po(filename); end

  # source://i18n//lib/i18n/backend/gettext.rb#51
  def normalize(locale, data); end

  # source://i18n//lib/i18n/backend/gettext.rb#68
  def normalize_pluralization(locale, key, value); end

  # source://i18n//lib/i18n/backend/gettext.rb#47
  def parse(filename); end
end

class I18n::Backend::Gettext::PoData < ::Hash
  # source://i18n//lib/i18n/backend/gettext.rb#35
  def set_comment(msgid_or_sym, comment); end
end

module I18n::Backend::InterpolationCompiler
  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#99
  def interpolate(locale, string, values); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#109
  def store_translations(locale, data, options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#115
  def compile_all_strings_in(data); end
end

module I18n::Backend::InterpolationCompiler::Compiler
  extend ::I18n::Backend::InterpolationCompiler::Compiler

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#27
  def compile_if_an_interpolation(string); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#39
  def interpolated_str?(str); end

  protected

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#60
  def compile_interpolation_token(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#49
  def compiled_interpolation_body(str); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#73
  def direct_key(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#93
  def escape_key_sym(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#89
  def escape_plain_str(str); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#55
  def handle_interpolation_token(interpolation, matchdata); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#69
  def interpolate_key(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#64
  def interpolate_or_raise_missing(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#81
  def missing_key(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#77
  def nil_key(key); end

  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#85
  def reserved_key(key); end

  # tokenize("foo %{bar} baz %%{buz}") # => ["foo ", "%{bar}", " baz ", "%%{buz}"]
  #
  # source://i18n//lib/i18n/backend/interpolation_compiler.rb#45
  def tokenize(str); end
end

# source://i18n//lib/i18n/backend/interpolation_compiler.rb#25
I18n::Backend::InterpolationCompiler::Compiler::INTERPOLATION_SYNTAX_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://i18n//lib/i18n/backend/interpolation_compiler.rb#24
I18n::Backend::InterpolationCompiler::Compiler::TOKENIZER = T.let(T.unsafe(nil), Regexp)

# This is a basic backend for key value stores. It receives on
# initialization the store, which should respond to three methods:
#
# * store#[](key)         - Used to get a value
# * store#[]=(key, value) - Used to set a value
# * store#keys            - Used to get all keys
#
# Since these stores only supports string, all values are converted
# to JSON before being stored, allowing it to also store booleans,
# hashes and arrays. However, this store does not support Procs.
#
# As the ActiveRecord backend, Symbols are just supported when loading
# translations from the filesystem or through explicit store translations.
#
# Also, avoid calling I18n.available_locales since it's a somehow
# expensive operation in most stores.
#
# == Example
#
# To setup I18n to use TokyoCabinet in memory is quite straightforward:
#
#   require 'rufus/tokyo/cabinet' # gem install rufus-tokyo
#   I18n.backend = I18n::Backend::KeyValue.new(Rufus::Tokyo::Cabinet.new('*'))
#
# == Performance
#
# You may make this backend even faster by including the Memoize module.
# However, notice that you should properly clear the cache if you change
# values directly in the key-store.
#
# == Subtrees
#
# In most backends, you are allowed to retrieve part of a translation tree:
#
#   I18n.backend.store_translations :en, :foo => { :bar => :baz }
#   I18n.t "foo" #=> { :bar => :baz }
#
# This backend supports this feature by default, but it slows down the storage
# of new data considerably and makes hard to delete entries. That said, you are
# allowed to disable the storage of subtrees on initialization:
#
#   I18n::Backend::KeyValue.new(@store, false)
#
# This is useful if you are using a KeyValue backend chained to a Simple backend.
class I18n::Backend::KeyValue
  include ::I18n::Backend::Flatten
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base
  include ::I18n::Backend::KeyValue::Implementation
end

module I18n::Backend::KeyValue::Implementation
  include ::I18n::Backend::Flatten
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base

  # source://i18n//lib/i18n/backend/key_value.rb#75
  def initialize(store, subtrees = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/key_value.rb#102
  def available_locales; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#79
  def initialized?; end

  # Returns the value of attribute store.
  #
  # source://i18n//lib/i18n/backend/key_value.rb#71
  def store; end

  # Sets the attribute store
  #
  # @param value the value to set the attribute store to.
  #
  # source://i18n//lib/i18n/backend/key_value.rb#71
  def store=(_arg0); end

  # source://i18n//lib/i18n/backend/key_value.rb#83
  def store_translations(locale, data, options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/key_value.rb#124
  def init_translations; end

  # source://i18n//lib/i18n/backend/key_value.rb#136
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/key_value.rb#150
  def pluralize(locale, entry, count); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#132
  def subtrees?; end

  # Queries the translations from the key-value store and converts
  # them into a hash such as the one returned from loading the
  # haml files
  #
  # source://i18n//lib/i18n/backend/key_value.rb#115
  def translations; end
end

class I18n::Backend::KeyValue::SubtreeProxy
  # @return [SubtreeProxy] a new instance of SubtreeProxy
  #
  # source://i18n//lib/i18n/backend/key_value.rb#162
  def initialize(master_key, store); end

  # source://i18n//lib/i18n/backend/key_value.rb#172
  def [](key); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#168
  def has_key?(key); end

  # source://i18n//lib/i18n/backend/key_value.rb#196
  def inspect; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#188
  def instance_of?(klass); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#183
  def is_a?(klass); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#183
  def kind_of?(klass); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/key_value.rb#192
  def nil?; end
end

class I18n::Backend::LazyLoadable < ::I18n::Backend::Simple
  # @return [LazyLoadable] a new instance of LazyLoadable
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#66
  def initialize(lazy_load: T.unsafe(nil)); end

  # Parse the load path and extract all locales.
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#99
  def available_locales; end

  # Eager loading is not supported in the lazy context.
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#90
  def eager_load!; end

  # Returns whether the current locale is initialized.
  #
  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#71
  def initialized?; end

  # source://i18n//lib/i18n/backend/lazy_loadable.rb#107
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end

  # Clean up translations and uninitialize all locales.
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#80
  def reload!; end

  protected

  # Load translations from files that belong to the current locale.
  #
  # @raise [InvalidFilenames]
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#121
  def init_translations; end

  # source://i18n//lib/i18n/backend/lazy_loadable.rb#133
  def initialized_locales; end

  private

  # Checks if a filename is named in correspondence to the translations it loaded.
  # The locale extracted from the path must be the single locale loaded in the translations.
  #
  # @raise [FilenameIncorrect]
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#175
  def assert_file_named_correctly!(file, translations); end

  # Select all files from I18n load path that belong to current locale.
  # These files must start with the locale identifier (ie. "en", "pt-BR"),
  # followed by an "_" demarcation to separate proceeding text.
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#167
  def filenames_for_current_locale; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#139
  def lazy_load?; end

  # Loads each file supplied and asserts that the file only loads
  # translations as expected by the name. The method returns a list of
  # errors corresponding to offending files.
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#152
  def load_translations_and_collect_file_errors(files); end
end

class I18n::Backend::LazyLoadable::FilenameIncorrect < ::StandardError
  # @return [FilenameIncorrect] a new instance of FilenameIncorrect
  #
  # source://i18n//lib/i18n/backend/lazy_loadable.rb#144
  def initialize(file, expected_locale, unexpected_locales); end
end

# Backend that lazy loads translations based on the current locale. This
# implementation avoids loading all translations up front. Instead, it only
# loads the translations that belong to the current locale. This offers a
# performance incentive in local development and test environments for
# applications with many translations for many different locales. It's
# particularly useful when the application only refers to a single locales'
# translations at a time (ex. A Rails workload).  The implementation
# identifies which translation files from the load path belong to the
# current locale by pattern matching against their path name.
#
# Specifically, a translation file is considered to belong to a locale if:
# a) the filename is in the I18n load path
# b) the filename ends in a supported extension (ie. .yml, .json, .po, .rb)
# c) the filename starts with the locale identifier
# d) the locale identifier and optional proceeding text is separated by an underscore, ie. "_".
#
# Examples:
# Valid files that will be selected by this backend:
#
# "files/locales/en_translation.yml" (Selected for locale "en")
# "files/locales/fr.po"  (Selected for locale "fr")
#
# Invalid files that won't be selected by this backend:
#
# "files/locales/translation-file"
# "files/locales/en-translation.unsupported"
# "files/locales/french/translation.yml"
# "files/locales/fr/translation.yml"
#
# The implementation uses this assumption to defer the loading of
# translation files until the current locale actually requires them.
#
# The backend has two working modes: lazy_load and eager_load.
#
# Note: This backend should only be enabled in test environments!
# When the mode is set to false, the backend behaves exactly like the
# Simple backend, with an additional check that the paths being loaded
# abide by the format. If paths can't be matched to the format, an error is raised.
#
# You can configure lazy loaded backends through the initializer or backends
# accessor:
#
#   # In test environments
#
#   I18n.backend = I18n::Backend::LazyLoadable.new(lazy_load: true)
#
#   # In other environments, such as production and CI
#
#   I18n.backend = I18n::Backend::LazyLoadable.new(lazy_load: false) # default
class I18n::Backend::LocaleExtractor
  class << self
    # source://i18n//lib/i18n/backend/lazy_loadable.rb#57
    def locale_from_path(path); end
  end
end

module I18n::Backend::Memoize
  # source://i18n//lib/i18n/backend/memoize.rb#15
  def available_locales; end

  # source://i18n//lib/i18n/backend/memoize.rb#29
  def eager_load!; end

  # source://i18n//lib/i18n/backend/memoize.rb#24
  def reload!; end

  # source://i18n//lib/i18n/backend/memoize.rb#19
  def store_translations(locale, data, options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/memoize.rb#37
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/memoize.rb#44
  def memoized_lookup; end

  # source://i18n//lib/i18n/backend/memoize.rb#48
  def reset_memoizations!(locale = T.unsafe(nil)); end
end

module I18n::Backend::Metadata
  # source://i18n//lib/i18n/backend/metadata.rb#52
  def interpolate(locale, entry, values = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/metadata.rb#57
  def pluralize(locale, entry, count); end

  # source://i18n//lib/i18n/backend/metadata.rb#40
  def translate(locale, key, options = T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/metadata.rb#63
  def with_metadata(metadata, &block); end

  class << self
    # @private
    #
    # source://i18n//lib/i18n/backend/metadata.rb#23
    def included(base); end
  end
end

module I18n::Backend::Pluralization
  # Overwrites the Base backend translate method so that it will check the
  # translation meta data space (:i18n) for a locale specific pluralization
  # rule and use it to pluralize the given entry. I.e. the library expects
  # pluralization rules to be stored at I18n.t(:'i18n.plural.rule')
  #
  # Pluralization rules are expected to respond to #call(count) and
  # return a pluralization key. Valid keys depend on the translation data
  # hash (entry) but it is generally recommended to follow CLDR's style,
  # i.e., return one of the keys :zero, :one, :few, :many, :other.
  #
  # The :zero key is always picked directly when count equals 0 AND the
  # translation data has the key :zero. This way translators are free to
  # either pick a special :zero translation even for languages where the
  # pluralizer does not return a :zero key.
  #
  # source://i18n//lib/i18n/backend/pluralization.rb#31
  def pluralize(locale, entry, count); end

  protected

  # source://i18n//lib/i18n/backend/pluralization.rb#50
  def pluralizer(locale); end

  # source://i18n//lib/i18n/backend/pluralization.rb#46
  def pluralizers; end
end

# A simple backend that reads translations from YAML files and stores them in
# an in-memory hash. Relies on the Base backend.
#
# The implementation is provided by a Implementation module allowing to easily
# extend Simple backend's behavior by including modules. E.g.:
#
# module I18n::Backend::Pluralization
#   def pluralize(*args)
#     # extended pluralization logic
#     super
#   end
# end
#
# I18n::Backend::Simple.include(I18n::Backend::Pluralization)
class I18n::Backend::Simple
  include ::I18n::Debug::Hook
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base
  include ::I18n::Backend::Simple::Implementation
end

module I18n::Backend::Simple::Implementation
  include ::I18n::Backend::Transliterator
  include ::I18n::Backend::Base

  # Get available locales from the translations hash
  #
  # source://i18n//lib/i18n/backend/simple.rb#46
  def available_locales; end

  # source://i18n//lib/i18n/backend/simple.rb#61
  def eager_load!; end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n/backend/simple.rb#25
  def initialized?; end

  # Clean up translations hash and set initialized to false on reload!
  #
  # source://i18n//lib/i18n/backend/simple.rb#55
  def reload!; end

  # Stores translations for the given locale in memory.
  # This uses a deep merge for the translations hash, so existing
  # translations will be overwritten by new ones only at the deepest
  # level of the hash.
  #
  # source://i18n//lib/i18n/backend/simple.rb#33
  def store_translations(locale, data, options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/simple.rb#66
  def translations(do_init: T.unsafe(nil)); end

  protected

  # source://i18n//lib/i18n/backend/simple.rb#76
  def init_translations; end

  # Looks up a translation from the translations hash. Returns nil if
  # either key is nil, or locale, scope or key do not exist as a key in the
  # nested translations hash. Splits keys or scopes containing dots
  # into multiple keys, i.e. <tt>currency.format</tt> is regarded the same as
  # <tt>%w(currency format)</tt>.
  #
  # source://i18n//lib/i18n/backend/simple.rb#86
  def lookup(locale, key, scope = T.unsafe(nil), options = T.unsafe(nil)); end
end

module I18n::Backend::Transliterator
  # Given a locale and a UTF-8 string, return the locale's ASCII
  # approximation for the string.
  #
  # source://i18n//lib/i18n/backend/transliterator.rb#11
  def transliterate(locale, string, replacement = T.unsafe(nil)); end

  class << self
    # Get a transliterator instance.
    #
    # source://i18n//lib/i18n/backend/transliterator.rb#19
    def get(rule = T.unsafe(nil)); end
  end
end

# source://i18n//lib/i18n/backend/transliterator.rb#7
I18n::Backend::Transliterator::DEFAULT_REPLACEMENT_CHAR = T.let(T.unsafe(nil), String)

# A transliterator which accepts a Hash of characters as its translation
# rule.
class I18n::Backend::Transliterator::HashTransliterator
  # @return [HashTransliterator] a new instance of HashTransliterator
  #
  # source://i18n//lib/i18n/backend/transliterator.rb#74
  def initialize(rule = T.unsafe(nil)); end

  # source://i18n//lib/i18n/backend/transliterator.rb#80
  def transliterate(string, replacement = T.unsafe(nil)); end

  private

  # Add transliteration rules to the approximations hash.
  #
  # source://i18n//lib/i18n/backend/transliterator.rb#100
  def add(hash); end

  # source://i18n//lib/i18n/backend/transliterator.rb#93
  def add_default_approximations; end

  # source://i18n//lib/i18n/backend/transliterator.rb#89
  def approximations; end
end

# source://i18n//lib/i18n/backend/transliterator.rb#43
I18n::Backend::Transliterator::HashTransliterator::DEFAULT_APPROXIMATIONS = T.let(T.unsafe(nil), Hash)

# A transliterator which accepts a Proc as its transliteration rule.
class I18n::Backend::Transliterator::ProcTransliterator
  # @return [ProcTransliterator] a new instance of ProcTransliterator
  #
  # source://i18n//lib/i18n/backend/transliterator.rb#31
  def initialize(rule); end

  # source://i18n//lib/i18n/backend/transliterator.rb#35
  def transliterate(string, replacement = T.unsafe(nil)); end
end

module I18n::Base
  # source://i18n//lib/i18n.rb#69
  def available_locales; end

  # source://i18n//lib/i18n.rb#73
  def available_locales=(value); end

  # @return [Boolean]
  #
  # source://i18n//lib/i18n.rb#355
  def available_locales_initialized?; end

  # source://i18n//lib/i18n.rb#69
  def backend; end

  # source://i18n//lib/i18n.rb#73
  def backend=(value); end

  # Gets I18n configuration object.
  #
  # source://i18n//lib/i18n.rb#56
  def config; end

  # Sets I18n configuration object.
  #
  # source://i18n//lib/i18n.rb#61
  def config=(value); end

  # source://i18n//lib/i18n.rb#69
  def default_locale; end

  # source://i18n//lib/i18n.rb#73
  def default_locale=(value); end

  # source://i18n//lib/i18n.rb#69
  def default_separator; end

  # source://i18n//lib/i18n.rb#73
  def default_separator=(value); end

  # Tells the backend to load translations now. Used in situations like the
  # Rails production environment. Backends can implement whatever strategy
  # is useful.
  #
  # source://i18n//lib/i18n.rb#90
  def eager_load!; end

  # source://i18n//lib/i18n.rb#69
  def enforce_available_locales; end

  # Raises an InvalidLocale exception when the passed locale is not available.
  #
  # source://i18n//lib/i18n.rb#349
  def enforce_available_locales!(locale); end

  # source://i18n//lib/i18n.rb#73
  def enforce_available_locales=(value); end

  # source://i18n//lib/i18n.rb#69
  def exception_handler; end

  # source://i18n//lib/i18n.rb#73
  def exception_handler=(value); end

  # Returns true if a translation exists for a given key, otherwise returns false.
  #
  # @raise [Disabled]
  # @return [Boolean]
  #
  # source://i18n//lib/i18n.rb#235
  def exists?(key, _locale = T.unsafe(nil), locale: T.unsafe(nil), **options); end

  # Localizes certain objects, such as dates and numbers to local formatting.
  #
  # @raise [Disabled]
  #
  # source://i18n//lib/i18n.rb#304
  def l(object, locale: T.unsafe(nil), format: T.unsafe(nil), **options); end

  # source://i18n//lib/i18n.rb#69
  def load_path; end

  # source://i18n//lib/i18n.rb#73
  def load_path=(value); end

  # source://i18n//lib/i18n.rb#69
  def locale; end

  # source://i18n//lib/i18n.rb#73
  def locale=(value); end

  # Returns true when the passed locale, which can be either a String or a
  # Symbol, is in the list of available locales. Returns false otherwise.
  #
  # @return [Boolean]
  #
  # source://i18n//lib/i18n.rb#344
  def locale_available?(locale); end

  # Localizes certain objects, such as dates and numbers to local formatting.
  #
  # @raise [Disabled]
  #
  # source://i18n//lib/i18n.rb#304
  def localize(object, locale: T.unsafe(nil), format: T.unsafe(nil), **options); end

  # Merges the given locale, key and scope into a single array of keys.
  # Splits keys that contain dots into multiple keys. Makes sure all
  # keys are Symbols.
  #
  # source://i18n//lib/i18n.rb#332
  def normalize_keys(locale, key, scope, separator = T.unsafe(nil)); end

  # Tells the backend to reload translations. Used in situations like the
  # Rails development environment. Backends can implement whatever strategy
  # is useful.
  #
  # source://i18n//lib/i18n.rb#82
  def reload!; end

  # Translates, pluralizes and interpolates a given key using a given locale,
  # scope, and default, as well as interpolation values.
  #
  # *LOOKUP*
  #
  # Translation data is organized as a nested hash using the upper-level keys
  # as namespaces. <em>E.g.</em>, ActionView ships with the translation:
  # <tt>:date => {:formats => {:short => "%b %d"}}</tt>.
  #
  # Translations can be looked up at any level of this hash using the key argument
  # and the scope option. <em>E.g.</em>, in this example <tt>I18n.t :date</tt>
  # returns the whole translations hash <tt>{:formats => {:short => "%b %d"}}</tt>.
  #
  # Key can be either a single key or a dot-separated key (both Strings and Symbols
  # work). <em>E.g.</em>, the short format can be looked up using both:
  #   I18n.t 'date.formats.short'
  #   I18n.t :'date.formats.short'
  #
  # Scope can be either a single key, a dot-separated key or an array of keys
  # or dot-separated keys. Keys and scopes can be combined freely. So these
  # examples will all look up the same short date format:
  #   I18n.t 'date.formats.short'
  #   I18n.t 'formats.short', :scope => 'date'
  #   I18n.t 'short', :scope => 'date.formats'
  #   I18n.t 'short', :scope => %w(date formats)
  #
  # *INTERPOLATION*
  #
  # Translations can contain interpolation variables which will be replaced by
  # values passed to #translate as part of the options hash, with the keys matching
  # the interpolation variable names.
  #
  # <em>E.g.</em>, with a translation <tt>:foo => "foo %{bar}"</tt> the option
  # value for the key +bar+ will be interpolated into the translation:
  #   I18n.t :foo, :bar => 'baz' # => 'foo baz'
  #
  # *PLURALIZATION*
  #
  # Translation data can contain pluralized translations. Pluralized translations
  # are arrays of singular/plural versions of translations like <tt>['Foo', 'Foos']</tt>.
  #
  # Note that <tt>I18n::Backend::Simple</tt> only supports an algorithm for English
  # pluralization rules. Other algorithms can be supported by custom backends.
  #
  # This returns the singular version of a pluralized translation:
  #   I18n.t :foo, :count => 1 # => 'Foo'
  #
  # These both return the plural version of a pluralized translation:
  #   I18n.t :foo, :count => 0 # => 'Foos'
  #   I18n.t :foo, :count => 2 # => 'Foos'
  #
  # The <tt>:count</tt> option can be used both for pluralization and interpolation.
  # <em>E.g.</em>, with the translation
  # <tt>:foo => ['%{count} foo', '%{count} foos']</tt>, count will
  # be interpolated to the pluralized translation:
  #   I18n.t :foo, :count => 1 # => '1 foo'
  #
  # *DEFAULTS*
  #
  # This returns the translation for <tt>:foo</tt> or <tt>default</tt> if no translation was found:
  #   I18n.t :foo, :default => 'default'
  #
  # This returns the translation for <tt>:foo</tt> or the translation for <tt>:bar</tt> if no
  # translation for <tt>:foo</tt> was found:
  #   I18n.t :foo, :default => :bar
  #
  # Returns the translation for <tt>:foo</tt> or the translation for <tt>:bar</tt>
  # or <tt>default</tt> if no translations for <tt>:foo</tt> and <tt>:bar</tt> were found.
  #   I18n.t :foo, :default => [:bar, 'default']
  #
  # *BULK LOOKUP*
  #
  # This returns an array with the translations for <tt>:foo</tt> and <tt>:bar</tt>.
  #   I18n.t [:foo, :bar]
  #
  # Can be used with dot-separated nested keys:
  #   I18n.t [:'baz.foo', :'baz.bar']
  #
  # Which is the same as using a scope option:
  #   I18n.t [:foo, :bar], :scope => :baz
  #
  # *LAMBDAS*
  #
  # Both translations and defaults can be given as Ruby lambdas. Lambdas will be
  # called and passed the key and options.
  #
  # E.g. assuming the key <tt>:salutation</tt> resolves to:
  #   lambda { |key, options| options[:gender] == 'm' ? "Mr. #{options[:name]}" : "Mrs. #{options[:name]}" }
  #
  # Then <tt>I18n.t(:salutation, :gender => 'w', :name => 'Smith') will result in "Mrs. Smith".
  #
  # Note that the string returned by lambda will go through string interpolation too,
  # so the following lambda would give the same result:
  #   lambda { |key, options| options[:gender] == 'm' ? "Mr. %{name}" : "Mrs. %{name}" }
  #
  # It is recommended to use/implement lambdas in an "idempotent" way. E.g. when
  # a cache layer is put in front of I18n.translate it will generate a cache key
  # from the argument values passed to #translate. Therefore your lambdas should
  # always return the same translations/values per unique combination of argument
  # values.
  #
  # *Ruby 2.7+ keyword arguments warning*
  #
  # This method uses keyword arguments.
  # There is a breaking change in ruby that produces warning with ruby 2.7 and won't work as expected with ruby 3.0
  # The "hash" parameter must be passed as keyword argument.
  #
  # Good:
  #  I18n.t(:salutation, :gender => 'w', :name => 'Smith')
  #  I18n.t(:salutation, **{ :gender => 'w', :name => 'Smith' })
  #  I18n.t(:salutation, **any_hash)
  #
  # Bad:
  #  I18n.t(:salutation, { :gender => 'w', :name => 'Smith' })
  #  I18n.t(:salutation, any_hash)
  #
  # @raise [Disabled]
  #
  # source://i18n//lib/i18n.rb#210
  def t(key = T.unsafe(nil), throw: T.unsafe(nil), raise: T.unsafe(nil), locale: T.unsafe(nil), **options); end

  # Wrapper for <tt>translate</tt> that adds <tt>:raise => true</tt>. With
  # this option, if no translation is found, it will raise <tt>I18n::MissingTranslationData</tt>
  #
  # source://i18n//lib/i18n.rb#229
  def t!(key, **options); end

  # Translates, pluralizes and interpolates a given key using a given locale,
  # scope, and default, as well as interpolation values.
  #
  # *LOOKUP*
  #
  # Translation data is organized as a nested hash using the upper-level keys
  # as namespaces. <em>E.g.</em>, ActionView ships with the translation:
  # <tt>:date => {:formats => {:short => "%b %d"}}</tt>.
  #
  # Translations can be looked up at any level of this hash using the key argument
  # and the scope option. <em>E.g.</em>, in this example <tt>I18n.t :date</tt>
  # returns the whole translations hash <tt>{:formats => {:short => "%b %d"}}</tt>.
  #
  # Key can be either a single key or a dot-separated key (both Strings and Symbols
  # work). <em>E.g.</em>, the short format can be looked up using both:
  #   I18n.t 'date.formats.short'
  #   I18n.t :'date.formats.short'
  #
  # Scope can be either a single key, a dot-separated key or an array of keys
  # or dot-separated keys. Keys and scopes can be combined freely. So these
  # examples will all look up the same short date format:
  #   I18n.t 'date.formats.short'
  #   I18n.t 'formats.short', :scope => 'date'
  #   I18n.t 'short', :scope => 'date.formats'
  #   I18n.t 'short', :scope => %w(date formats)
  #
  # *INTERPOLATION*
  #
  # Translations can contain interpolation variables which will be replaced by
  # values passed to #translate as part of the options hash, with the keys matching
  # the interpolation variable names.
  #
  # <em>E.g.</em>, with a translation <tt>:foo => "foo %{bar}"</tt> the option
  # value for the key +bar+ will be interpolated into the translation:
  #   I18n.t :foo, :bar => 'baz' # => 'foo baz'
  #
  # *PLURALIZATION*
  #
  # Translation data can contain pluralized translations. Pluralized translations
  # are arrays of singular/plural versions of translations like <tt>['Foo', 'Foos']</tt>.
  #
  # Note that <tt>I18n::Backend::Simple</tt> only supports an algorithm for English
  # pluralization rules. Other algorithms can be supported by custom backends.
  #
  # This returns the singular version of a pluralized translation:
  #   I18n.t :foo, :count => 1 # => 'Foo'
  #
  # These both return the plural version of a pluralized translation:
  #   I18n.t :foo, :count => 0 # => 'Foos'
  #   I18n.t :foo, :count => 2 # => 'Foos'
  #
  # The <tt>:count</tt> option can be used both for pluralization and interpolation.
  # <em>E.g.</em>, with the translation
  # <tt>:foo => ['%{count} foo', '%{count} foos']</tt>, count will
  # be interpolated to the pluralized translation:
  #   I18n.t :foo, :count => 1 # => '1 foo'
  #
  # *DEFAULTS*
  #
  # This returns the translation for <tt>:foo</tt> or <tt>default</tt> if no translation was found:
  #   I18n.t :foo, :default => 'default'
  #
  # This returns the translation for <tt>:foo</tt> or the translation for <tt>:bar</tt> if no
  # translation for <tt>:foo</tt> was found:
  #   I18n.t :foo, :default => :bar
  #
  # Returns the translation for <tt>:foo</tt> or the translation for <tt>:bar</tt>
  # or <tt>default</tt> if no translations for <tt>:foo</tt> and <tt>:bar</tt> were found.
  #   I18n.t :foo, :default => [:bar, 'default']
  #
  # *BULK LOOKUP*
  #
  # This returns an array with the translations for <tt>:foo</tt> and <tt>:bar</tt>.
  #   I18n.t [:foo, :bar]
  #
  # Can be used with dot-separated nested keys:
  #   I18n.t [:'baz.foo', :'baz.bar']
  #
  # Which is the same as using a scope option:
  #   I18n.t [:foo, :bar], :scope => :baz
  #
  # *LAMBDAS*
  #
  # Both translations and defaults can be given as Ruby lambdas. Lambdas will be
  # called and passed the key and options.
  #
  # E.g. assuming the key <tt>:salutation</tt> resolves to:
  #   lambda { |key, options| options[:gender] == 'm' ? "Mr. #{options[:name]}" : "Mrs. #{options[:name]}" }
  #
  # Then <tt>I18n.t(:salutation, :gender => 'w', :name => 'Smith') will result in "Mrs. Smith".
  #
  # Note that the string returned by lambda will go through string interpolation too,
  # so the following lambda would give the same result:
  #   lambda { |key, options| options[:gender] == 'm' ? "Mr. %{name}" : "Mrs. %{name}" }
  #
  # It is recommended to use/implement lambdas in an "idempotent" way. E.g. when
  # a cache layer is put in front of I18n.translate it will generate a cache key
  # from the argument values passed to #translate. Therefore your lambdas should
  # always return the same translations/values per unique combination of argument
  # values.
  #
  # *Ruby 2.7+ keyword arguments warning*
  #
  # This method uses keyword arguments.
  # There is a breaking change in ruby that produces warning with ruby 2.7 and won't work as expected with ruby 3.0
  # The "hash" parameter must be passed as keyword argument.
  #
  # Good:
  #  I18n.t(:salutation, :gender => 'w', :name => 'Smith')
  #  I18n.t(:salutation, **{ :gender => 'w', :name => 'Smith' })
  #  I18n.t(:salutation, **any_hash)
  #
  # Bad:
  #  I18n.t(:salutation, { :gender => 'w', :name => 'Smith' })
  #  I18n.t(:salutation, any_hash)
  #
  # @raise [Disabled]
  #
  # source://i18n//lib/i18n.rb#210
  def translate(key = T.unsafe(nil), throw: T.unsafe(nil), raise: T.unsafe(nil), locale: T.unsafe(nil), **options); end

  # Wrapper for <tt>translate</tt> that adds <tt>:raise => true</tt>. With
  # this option, if no translation is found, it will raise <tt>I18n::MissingTranslationData</tt>
  #
  # source://i18n//lib/i18n.rb#229
  def translate!(key, **options); end

  # Transliterates UTF-8 characters to ASCII. By default this method will
  # transliterate only Latin strings to an ASCII approximation:
  #
  #    I18n.transliterate("Ærøskøbing")
  #    # => "AEroskobing"
  #
  #    I18n.transliterate("日本語")
  #    # => "???"
  #
  # It's also possible to add support for per-locale transliterations. I18n
  # expects transliteration rules to be stored at
  # <tt>i18n.transliterate.rule</tt>.
  #
  # Transliteration rules can either be a Hash or a Proc. Procs must accept a
  # single string argument. Hash rules inherit the default transliteration
  # rules, while Procs do not.
  #
  # *Examples*
  #
  # Setting a Hash in <locale>.yml:
  #
  #    i18n:
  #      transliterate:
  #        rule:
  #          ü: "ue"
  #          ö: "oe"
  #
  # Setting a Hash using Ruby:
  #
  #     store_translations(:de, i18n: {
  #                          transliterate: {
  #                            rule: {
  #                              'ü' => 'ue',
  #                              'ö' => 'oe'
  #                            }
  #                          }
  #                        })
  #
  # Setting a Proc:
  #
  #     translit = lambda {|string| MyTransliterator.transliterate(string) }
  #     store_translations(:xx, :i18n => {:transliterate => {:rule => translit})
  #
  # Transliterating strings:
  #
  #     I18n.locale = :en
  #     I18n.transliterate("Jürgen") # => "Jurgen"
  #     I18n.locale = :de
  #     I18n.transliterate("Jürgen") # => "Juergen"
  #     I18n.transliterate("Jürgen", :locale => :en) # => "Jurgen"
  #     I18n.transliterate("Jürgen", :locale => :de) # => "Juergen"
  #
  # source://i18n//lib/i18n.rb#293
  def transliterate(key, throw: T.unsafe(nil), raise: T.unsafe(nil), locale: T.unsafe(nil), replacement: T.unsafe(nil), **options); end

  # Executes block with given I18n.locale set.
  #
  # source://i18n//lib/i18n.rb#315
  def with_locale(tmp_locale = T.unsafe(nil)); end

  private

  # Any exceptions thrown in translate will be sent to the @@exception_handler
  # which can be a Symbol, a Proc or any other Object unless they're forced to
  # be raised or thrown (MissingTranslation).
  #
  # If exception_handler is a Symbol then it will simply be sent to I18n as
  # a method call. A Proc will simply be called. In any other case the
  # method #call will be called on the exception_handler object.
  #
  # Examples:
  #
  #   I18n.exception_handler = :custom_exception_handler              # this is the default
  #   I18n.custom_exception_handler(exception, locale, key, options)  # will be called like this
  #
  #   I18n.exception_handler = lambda { |*args| ... }                 # a lambda
  #   I18n.exception_handler.call(exception, locale, key, options)    # will be called like this
  #
  #   I18n.exception_handler = I18nExceptionHandler.new               # an object
  #   I18n.exception_handler.call(exception, locale, key, options)    # will be called like this
  #
  # source://i18n//lib/i18n.rb#391
  def handle_exception(handling, exception, locale, key, options); end

  # source://i18n//lib/i18n.rb#409
  def normalize_key(key, separator); end

  # source://i18n//lib/i18n.rb#361
  def translate_key(key, throw, raise, locale, backend, options); end
end

class I18n::Config
  # Returns an array of locales for which translations are available.
  # Unless you explicitly set these through I18n.available_locales=
  # the call will be delegated to the backend.
  #
  # source://i18n//lib/i18n/config.rb#43
  def available_locales; end

  # Sets the available locales.
  #
  # source://i18n//lib/i18n/config.rb#57
  def available_locales=(locales); end

  # Returns true if the available_locales have been initialized
  #
  # @return [Boolean]
  #
  # source://i18n//lib/i18n/config.rb#64
  def available_locales_initialized?; end

  # Caches the available locales list as both strings and symbols in a Set, so
  # that we can have faster lookups to do the available locales enforce check.
  #
  # source://i18n//lib/i18n/config.rb#50
  def available_locales_set; end

  # Returns the current backend. Defaults to +Backend::Simple+.
  #
  # source://i18n//lib/i18n/config.rb#20
  def backend; end

  # Sets the current backend. Used to set a custom backend.
  #
  # source://i18n//lib/i18n/config.rb#25
  def backend=(backend); end

  # Clears the available locales set so it can be recomputed again after I18n
  # gets reloaded.
  #
  # source://i18n//lib/i18n/config.rb#70
  def clear_available_locales_set; end

  # Returns the current default locale. Defaults to :'en'
  #
  # source://i18n//lib/i18n/config.rb#30
  def default_locale; end

  # Sets the current default locale. Used to set a custom default locale.
  #
  # source://i18n//lib/i18n/config.rb#35
  def default_locale=(locale); end

  # Returns the current default scope separator. Defaults to '.'
  #
  # source://i18n//lib/i18n/config.rb#75
  def default_separator; end

  # Sets the current default scope separator.
  #
  # source://i18n//lib/i18n/config.rb#80
  def default_separator=(separator); end

  # source://i18n//lib/i18n/config.rb#141
  def enforce_available_locales; end

  # source://i18n//lib/i18n/config.rb#145
  def enforce_available_locales=(enforce_available_locales); end

  # Returns the current exception handler. Defaults to an instance of
  # I18n::ExceptionHandler.
  #
  # source://i18n//lib/i18n/config.rb#86
  def exception_handler; end

  # Sets the exception handler.
  #
  # source://i18n//lib/i18n/config.rb#91
  def exception_handler=(exception_handler); end

  # Returns the current interpolation patterns. Defaults to
  # I18n::DEFAULT_INTERPOLATION_PATTERNS.
  #
  # source://i18n//lib/i18n/config.rb#151
  def interpolation_patterns; end

  # Sets the current interpolation patterns. Used to set a interpolation
  # patterns.
  #
  # E.g. using {{}} as a placeholder like "{{hello}}, world!":
  #
  #   I18n.config.interpolation_patterns << /\{\{(\w+)\}\}/
  #
  # source://i18n//lib/i18n/config.rb#161
  def interpolation_patterns=(interpolation_patterns); end

  # Allow clients to register paths providing translation data sources. The
  # backend defines acceptable sources.
  #
  # E.g. the provided SimpleBackend accepts a list of paths to translation
  # files which are either named *.rb and contain plain Ruby Hashes or are
  # named *.yml and contain YAML data. So for the SimpleBackend clients may
  # register translation files like this:
  #   I18n.load_path << 'path/to/locale/en.yml'
  #
  # source://i18n//lib/i18n/config.rb#126
  def load_path; end

  # Sets the load path instance. Custom implementations are expected to
  # behave like a Ruby Array.
  #
  # source://i18n//lib/i18n/config.rb#132
  def load_path=(load_path); end

  # The only configuration value that is not global and scoped to thread is :locale.
  # It defaults to the default_locale.
  #
  # source://i18n//lib/i18n/config.rb#9
  def locale; end

  # Sets the current locale pseudo-globally, i.e. in the Thread.current hash.
  #
  # source://i18n//lib/i18n/config.rb#14
  def locale=(locale); end

  # Returns the current handler for situations when interpolation argument
  # is missing. MissingInterpolationArgument will be raised by default.
  #
  # source://i18n//lib/i18n/config.rb#97
  def missing_interpolation_argument_handler; end

  # Sets the missing interpolation argument handler. It can be any
  # object that responds to #call. The arguments that will be passed to #call
  # are the same as for MissingInterpolationArgument initializer. Use +Proc.new+
  # if you don't care about arity.
  #
  # == Example:
  # You can suppress raising an exception and return string instead:
  #
  #   I18n.config.missing_interpolation_argument_handler = Proc.new do |key|
  #     "#{key} is missing"
  #   end
  #
  # source://i18n//lib/i18n/config.rb#114
  def missing_interpolation_argument_handler=(exception_handler); end
end

# source://i18n//lib/i18n/interpolate/ruby.rb#5
I18n::DEFAULT_INTERPOLATION_PATTERNS = T.let(T.unsafe(nil), Array)

class I18n::Disabled < ::I18n::ArgumentError
  # @return [Disabled] a new instance of Disabled
  #
  # source://i18n//lib/i18n/exceptions.rb#19
  def initialize(method); end
end

# source://i18n//lib/i18n.rb#35
I18n::EMPTY_HASH = T.let(T.unsafe(nil), Hash)

class I18n::ExceptionHandler
  # source://i18n//lib/i18n/exceptions.rb#7
  def call(exception, _locale, _key, _options); end
end

module I18n::Gettext
  class << self
    # source://i18n//lib/i18n/gettext.rb#21
    def extract_scope(msgid, separator); end

    # returns an array of plural keys for the given locale or the whole hash
    # of locale mappings to plural keys so that we can convert from gettext's
    # integer-index based style
    # TODO move this information to the pluralization module
    #
    # source://i18n//lib/i18n/gettext.rb#17
    def plural_keys(*args); end
  end
end

# source://i18n//lib/i18n/gettext.rb#6
I18n::Gettext::CONTEXT_SEPARATOR = T.let(T.unsafe(nil), String)

# Implements classical Gettext style accessors. To use this include the
# module to the global namespace or wherever you want to use it.
#
#   include I18n::Gettext::Helpers
module I18n::Gettext::Helpers
  # Makes dynamic translation messages readable for the gettext parser.
  # <tt>_(fruit)</tt> cannot be understood by the gettext parser. To help the parser find all your translations,
  # you can add <tt>fruit = N_("Apple")</tt> which does not translate, but tells the parser: "Apple" needs translation.
  # * msgid: the message id.
  # * Returns: msgid.
  #
  # source://i18n//lib/i18n/gettext/helpers.rb#17
  def N_(msgsid); end

  # source://i18n//lib/i18n/gettext/helpers.rb#21
  def _(msgid, options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/gettext/helpers.rb#21
  def gettext(msgid, options = T.unsafe(nil)); end

  # source://i18n//lib/i18n/gettext/helpers.rb#38
  def n_(msgid, msgid_plural, n = T.unsafe(nil)); end

  # source://i18n//lib/i18n/gettext/helpers.rb#38
  def ngettext(msgid, msgid_plural, n = T.unsafe(nil)); end

  # Method signatures:
  #   npgettext('Fruits', 'apple', 'apples', 2)
  #   npgettext('Fruits', ['apple', 'apples'], 2)
  #
  # source://i18n//lib/i18n/gettext/helpers.rb#61
  def np_(msgctxt, msgid, msgid_plural, n = T.unsafe(nil)); end

  # Method signatures:
  #   npgettext('Fruits', 'apple', 'apples', 2)
  #   npgettext('Fruits', ['apple', 'apples'], 2)
  #
  # source://i18n//lib/i18n/gettext/helpers.rb#61
  def npgettext(msgctxt, msgid, msgid_plural, n = T.unsafe(nil)); end

  # Method signatures:
  #   nsgettext('Fruits|apple', 'apples', 2)
  #   nsgettext(['Fruits|apple', 'apples'], 2)
  #
  # source://i18n//lib/i18n/gettext/helpers.rb#46
  def ns_(msgid, msgid_plural, n = T.unsafe(nil), separator = T.unsafe(nil)); end

  # Method signatures:
  #   nsgettext('Fruits|apple', 'apples', 2)
  #   nsgettext(['Fruits|apple', 'apples'], 2)
  #
  # source://i18n//lib/i18n/gettext/helpers.rb#46
  def nsgettext(msgid, msgid_plural, n = T.unsafe(nil), separator = T.unsafe(nil)); end

  # source://i18n//lib/i18n/gettext/helpers.rb#32
  def p_(msgctxt, msgid); end

  # source://i18n//lib/i18n/gettext/helpers.rb#32
  def pgettext(msgctxt, msgid); end

  # source://i18n//lib/i18n/gettext/helpers.rb#26
  def s_(msgid, separator = T.unsafe(nil)); end

  # source://i18n//lib/i18n/gettext/helpers.rb#26
  def sgettext(msgid, separator = T.unsafe(nil)); end
end

# source://i18n//lib/i18n/gettext.rb#5
I18n::Gettext::PLURAL_SEPARATOR = T.let(T.unsafe(nil), String)

# source://i18n//lib/i18n/interpolate/ruby.rb#10
I18n::INTERPOLATION_PATTERN = T.let(T.unsafe(nil), Regexp)

class I18n::InvalidFilenames < ::I18n::ArgumentError
  # @return [InvalidFilenames] a new instance of InvalidFilenames
  #
  # source://i18n//lib/i18n/exceptions.rb#126
  def initialize(file_errors); end
end

# source://i18n//lib/i18n/exceptions.rb#125
I18n::InvalidFilenames::NUMBER_OF_ERRORS_SHOWN = T.let(T.unsafe(nil), Integer)

class I18n::InvalidLocale < ::I18n::ArgumentError
  # @return [InvalidLocale] a new instance of InvalidLocale
  #
  # source://i18n//lib/i18n/exceptions.rb#34
  def initialize(locale); end

  # Returns the value of attribute locale.
  #
  # source://i18n//lib/i18n/exceptions.rb#33
  def locale; end
end

class I18n::InvalidLocaleData < ::I18n::ArgumentError
  # @return [InvalidLocaleData] a new instance of InvalidLocaleData
  #
  # source://i18n//lib/i18n/exceptions.rb#42
  def initialize(filename, exception_message); end

  # Returns the value of attribute filename.
  #
  # source://i18n//lib/i18n/exceptions.rb#41
  def filename; end
end

class I18n::InvalidPluralizationData < ::I18n::ArgumentError
  # @return [InvalidPluralizationData] a new instance of InvalidPluralizationData
  #
  # source://i18n//lib/i18n/exceptions.rb#84
  def initialize(entry, count, key); end

  # Returns the value of attribute count.
  #
  # source://i18n//lib/i18n/exceptions.rb#83
  def count; end

  # Returns the value of attribute entry.
  #
  # source://i18n//lib/i18n/exceptions.rb#83
  def entry; end

  # Returns the value of attribute key.
  #
  # source://i18n//lib/i18n/exceptions.rb#83
  def key; end
end

# source://i18n//lib/i18n/backend/key_value.rb#21
I18n::JSON = ActiveSupport::JSON

module I18n::Locale; end

class I18n::Locale::Fallbacks < ::Hash
  # @return [Fallbacks] a new instance of Fallbacks
  #
  # source://i18n//lib/i18n/locale/fallbacks.rb#49
  def initialize(*mappings); end

  # @raise [InvalidLocale]
  #
  # source://i18n//lib/i18n/locale/fallbacks.rb#60
  def [](locale); end

  # Returns the value of attribute defaults.
  #
  # source://i18n//lib/i18n/locale/fallbacks.rb#58
  def defaults; end

  # source://i18n//lib/i18n/locale/fallbacks.rb#55
  def defaults=(defaults); end

  # source://i18n//lib/i18n/locale/fallbacks.rb#67
  def map(*args, &block); end

  protected

  # source://i18n//lib/i18n/locale/fallbacks.rb#84
  def compute(tags, include_defaults = T.unsafe(nil), exclude = T.unsafe(nil)); end
end

module I18n::Locale::Tag
  class << self
    # Returns the current locale tag implementation. Defaults to +I18n::Locale::Tag::Simple+.
    #
    # source://i18n//lib/i18n/locale/tag.rb#12
    def implementation; end

    # Sets the current locale tag implementation. Use this to set a different locale tag implementation.
    #
    # source://i18n//lib/i18n/locale/tag.rb#17
    def implementation=(implementation); end

    # Factory method for locale tags. Delegates to the current locale tag implementation.
    #
    # source://i18n//lib/i18n/locale/tag.rb#22
    def tag(tag); end
  end
end

module I18n::Locale::Tag::Parents
  # source://i18n//lib/i18n/locale/tag/parents.rb#5
  def parent; end

  # source://i18n//lib/i18n/locale/tag/parents.rb#18
  def parents; end

  # source://i18n//lib/i18n/locale/tag/parents.rb#14
  def self_and_parents; end
end

# source://i18n//lib/i18n/locale/tag/rfc4646.rb#12
I18n::Locale::Tag::RFC4646_FORMATS = T.let(T.unsafe(nil), Hash)

# source://i18n//lib/i18n/locale/tag/rfc4646.rb#11
I18n::Locale::Tag::RFC4646_SUBTAGS = T.let(T.unsafe(nil), Array)

class I18n::Locale::Tag::Rfc4646 < ::Struct
  include ::I18n::Locale::Tag::Parents

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#35
  def language; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#35
  def region; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#35
  def script; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#46
  def to_a; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#42
  def to_s; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#38
  def to_sym; end

  # source://i18n//lib/i18n/locale/tag/rfc4646.rb#35
  def variant; end

  class << self
    # source://i18n//lib/i18n/locale/tag/rfc4646.rb#23
    def parser; end

    # source://i18n//lib/i18n/locale/tag/rfc4646.rb#27
    def parser=(parser); end

    # Parses the given tag and returns a Tag instance if it is valid.
    # Returns false if the given tag is not valid according to RFC 4646.
    #
    # source://i18n//lib/i18n/locale/tag/rfc4646.rb#18
    def tag(tag); end
  end
end

module I18n::Locale::Tag::Rfc4646::Parser
  class << self
    # source://i18n//lib/i18n/locale/tag/rfc4646.rb#63
    def match(tag); end
  end
end

# source://i18n//lib/i18n/locale/tag/rfc4646.rb#51
I18n::Locale::Tag::Rfc4646::Parser::PATTERN = T.let(T.unsafe(nil), Regexp)

class I18n::Locale::Tag::Simple
  include ::I18n::Locale::Tag::Parents

  # @return [Simple] a new instance of Simple
  #
  # source://i18n//lib/i18n/locale/tag/simple.rb#17
  def initialize(*tag); end

  # source://i18n//lib/i18n/locale/tag/simple.rb#21
  def subtags; end

  # Returns the value of attribute tag.
  #
  # source://i18n//lib/i18n/locale/tag/simple.rb#15
  def tag; end

  # source://i18n//lib/i18n/locale/tag/simple.rb#33
  def to_a; end

  # source://i18n//lib/i18n/locale/tag/simple.rb#29
  def to_s; end

  # source://i18n//lib/i18n/locale/tag/simple.rb#25
  def to_sym; end

  class << self
    # source://i18n//lib/i18n/locale/tag/simple.rb#8
    def tag(tag); end
  end
end

class I18n::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://i18n//lib/i18n/middleware.rb#6
  def initialize(app); end

  # source://i18n//lib/i18n/middleware.rb#10
  def call(env); end
end

class I18n::MissingInterpolationArgument < ::I18n::ArgumentError
  # @return [MissingInterpolationArgument] a new instance of MissingInterpolationArgument
  #
  # source://i18n//lib/i18n/exceptions.rb#92
  def initialize(key, values, string); end

  # Returns the value of attribute key.
  #
  # source://i18n//lib/i18n/exceptions.rb#91
  def key; end

  # Returns the value of attribute string.
  #
  # source://i18n//lib/i18n/exceptions.rb#91
  def string; end

  # Returns the value of attribute values.
  #
  # source://i18n//lib/i18n/exceptions.rb#91
  def values; end
end

class I18n::MissingTranslation < ::I18n::ArgumentError
  include ::I18n::MissingTranslation::Base
end

module I18n::MissingTranslation::Base
  # source://i18n//lib/i18n/exceptions.rb#54
  def initialize(locale, key, options = T.unsafe(nil)); end

  # Returns the value of attribute key.
  #
  # source://i18n//lib/i18n/exceptions.rb#52
  def key; end

  # source://i18n//lib/i18n/exceptions.rb#59
  def keys; end

  # Returns the value of attribute locale.
  #
  # source://i18n//lib/i18n/exceptions.rb#52
  def locale; end

  # source://i18n//lib/i18n/exceptions.rb#65
  def message; end

  # Returns the value of attribute options.
  #
  # source://i18n//lib/i18n/exceptions.rb#52
  def options; end

  # source://i18n//lib/i18n/exceptions.rb#70
  def to_exception; end

  # source://i18n//lib/i18n/exceptions.rb#65
  def to_s; end
end

# source://i18n//lib/i18n/exceptions.rb#50
I18n::MissingTranslation::Base::PERMITTED_KEYS = T.let(T.unsafe(nil), Array)

class I18n::MissingTranslationData < ::I18n::ArgumentError
  include ::I18n::MissingTranslation::Base
end

# source://i18n//lib/i18n.rb#19
I18n::RESERVED_KEYS = T.let(T.unsafe(nil), Array)

class I18n::ReservedInterpolationKey < ::I18n::ArgumentError
  # @return [ReservedInterpolationKey] a new instance of ReservedInterpolationKey
  #
  # source://i18n//lib/i18n/exceptions.rb#100
  def initialize(key, string); end

  # Returns the value of attribute key.
  #
  # source://i18n//lib/i18n/exceptions.rb#99
  def key; end

  # Returns the value of attribute string.
  #
  # source://i18n//lib/i18n/exceptions.rb#99
  def string; end
end

module I18n::Tests; end

module I18n::Tests::Localization
  class << self
    # @private
    #
    # source://i18n//lib/i18n/tests/localization.rb#9
    def included(base); end
  end
end

class I18n::UnknownFileType < ::I18n::ArgumentError
  # @return [UnknownFileType] a new instance of UnknownFileType
  #
  # source://i18n//lib/i18n/exceptions.rb#108
  def initialize(type, filename); end

  # Returns the value of attribute filename.
  #
  # source://i18n//lib/i18n/exceptions.rb#107
  def filename; end

  # Returns the value of attribute type.
  #
  # source://i18n//lib/i18n/exceptions.rb#107
  def type; end
end

class I18n::UnsupportedMethod < ::I18n::ArgumentError
  # @return [UnsupportedMethod] a new instance of UnsupportedMethod
  #
  # source://i18n//lib/i18n/exceptions.rb#116
  def initialize(method, backend_klass, msg); end

  # Returns the value of attribute backend_klass.
  #
  # source://i18n//lib/i18n/exceptions.rb#115
  def backend_klass; end

  # Returns the value of attribute method.
  #
  # source://i18n//lib/i18n/exceptions.rb#115
  def method; end

  # Returns the value of attribute msg.
  #
  # source://i18n//lib/i18n/exceptions.rb#115
  def msg; end
end

module I18n::Utils
  class << self
    # source://i18n//lib/i18n/utils.rb#18
    def deep_merge(hash, other_hash, &block); end

    # source://i18n//lib/i18n/utils.rb#22
    def deep_merge!(hash, other_hash, &block); end

    # source://i18n//lib/i18n/utils.rb#34
    def deep_symbolize_keys(hash); end

    # source://i18n//lib/i18n/utils.rb#7
    def except(hash, *keys); end

    private

    # source://i18n//lib/i18n/utils.rb#43
    def deep_symbolize_keys_in_object(value); end
  end
end

# source://i18n//lib/i18n/version.rb#4
I18n::VERSION = T.let(T.unsafe(nil), String)
