# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `hashie` gem.
# Please instead update this file by running `bin/tapioca gem hashie`.

module Hashie
  extend ::Hashie::Extensions::StringifyKeys::ClassMethods
  extend ::Hashie::Extensions::SymbolizeKeys::ClassMethods

  class << self
    # The logger that Hashie uses for reporting errors.
    #
    # @return [Logger]
    #
    # source://hashie//lib/hashie/logger.rb#7
    def logger; end

    # Sets the logger that Hashie uses for reporting errors.
    #
    # @param logger [Logger] The logger to set as Hashie's logger.
    # @return [void]
    #
    # source://hashie//lib/hashie/logger.rb#15
    def logger=(logger); end
  end
end

class Hashie::Array < ::Array
  include ::Hashie::Extensions::Array::PrettyInspect
  include ::Hashie::Extensions::RubyVersionCheck
  extend ::Hashie::Extensions::RubyVersionCheck::ClassMethods

  def array_inspect; end

  # source://hashie//lib/hashie/array.rb#9
  def dig(*indexes); end

  # source://hashie//lib/hashie/extensions/array/pretty_inspect.rb#10
  def inspect; end
end

# A Clash is a "Chainable Lazy Hash". Inspired by libraries such as Arel,
# a Clash allows you to chain together method arguments to build a
# hash, something that's especially useful if you're doing something
# like constructing a complex options hash. Here's a basic example:
#
#     c = Hashie::Clash.new.conditions(:foo => 'bar').order(:created_at)
#     c # => {:conditions => {:foo => 'bar'}, :order => :created_at}
#
# Clash provides another way to create sub-hashes by using bang notation.
# You can dive into a sub-hash by providing a key with a bang and dive
# back out again with the _end! method. Example:
#
#     c = Hashie::Clash.new.conditions!.foo('bar').baz(123)._end!.order(:created_at)
#     c # => { conditions: { foo: 'bar', baz: 123 }, order: :created_at}
#
# Because the primary functionality of Clash is to build options objects,
# all keys are converted to symbols since many libraries expect symbols explicitly
# for keys.
class Hashie::Clash < ::Hash
  # Initialize a new clash by passing in a Hash to
  # convert and, optionally, the parent to which this
  # Clash is chained.
  #
  # @return [Clash] a new instance of Clash
  #
  # source://hashie//lib/hashie/clash.rb#32
  def initialize(other_hash = T.unsafe(nil), parent = T.unsafe(nil)); end

  # Jump back up a level if you are using bang method
  # chaining. For example:
  #
  # c = Hashie::Clash.new.foo('bar')
  # c.baz!.foo(123) # => c[:baz]
  # c.baz!._end! # => c
  #
  # source://hashie//lib/hashie/clash.rb#45
  def _end!; end

  # The parent Clash if this Clash was created via chaining.
  #
  # source://hashie//lib/hashie/clash.rb#27
  def _parent; end

  # source://hashie//lib/hashie/clash.rb#49
  def id(*args); end

  # source://hashie//lib/hashie/clash.rb#53
  def merge_store(key, *args); end

  # source://hashie//lib/hashie/clash.rb#66
  def method_missing(name, *args); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/clash.rb#87
  def respond_to_missing?(method_name, _include_private = T.unsafe(nil)); end
end

class Hashie::Clash::ChainError < ::StandardError; end

class Hashie::CoercionError < ::StandardError
  # @return [CoercionError] a new instance of CoercionError
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#3
  def initialize(key, value, into, message); end
end

# A Dash is a 'defined' or 'discrete' Hash, that is, a Hash
# that has a set of defined keys that are accessible (with
# optional defaults) and only those keys may be set or read.
#
# Dashes are useful when you need to create a very simple
# lightweight data object that needs even fewer options and
# resources than something like a DataMapper resource.
#
# It is preferrable to a Struct because of the in-class
# API for defining properties as well as per-property defaults.
class Hashie::Dash < ::Hashie::Hash
  # You may initialize a Dash with an attributes hash
  # just like you would many other kinds of data objects.
  #
  # @return [Dash] a new instance of Dash
  #
  # source://hashie//lib/hashie/dash.rb#104
  def initialize(attributes = T.unsafe(nil), &block); end

  # Retrieve a value from the Dash (will return the
  # property's default value if it hasn't been set).
  #
  # source://hashie//lib/hashie/dash.rb#117
  def [](property); end

  # Set a value on the Dash in a Hash-like way. Only works
  # on pre-existing properties.
  #
  # source://hashie//lib/hashie/dash.rb#131
  def []=(property, value); end

  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def hash_inspect; end

  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def inspect; end

  # source://hashie//lib/hashie/dash.rb#137
  def merge(other_hash); end

  # source://hashie//lib/hashie/dash.rb#145
  def merge!(other_hash); end

  # source://hashie//lib/hashie/dash.rb#152
  def replace(other_hash); end

  # source://hashie//lib/hashie/dash.rb#159
  def to_h; end

  # source://hashie//lib/hashie/dash.rb#159
  def to_hash; end

  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def to_s; end

  # source://hashie//lib/hashie/dash.rb#166
  def update_attributes!(attributes); end

  private

  def _regular_reader(_arg0); end
  def _regular_writer(_arg0, _arg1); end

  # source://hashie//lib/hashie/dash.rb#203
  def assert_property_exists!(property); end

  # source://hashie//lib/hashie/dash.rb#217
  def assert_property_required!(property, value); end

  # source://hashie//lib/hashie/dash.rb#213
  def assert_property_set!(property); end

  # source://hashie//lib/hashie/dash.rb#207
  def assert_required_attributes_set!; end

  # @raise [NoMethodError]
  #
  # source://hashie//lib/hashie/dash.rb#226
  def fail_no_property_error!(property); end

  # @raise [ArgumentError]
  #
  # source://hashie//lib/hashie/dash.rb#221
  def fail_property_required_error!(property); end

  # source://hashie//lib/hashie/dash.rb#188
  def initialize_attributes(attributes); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/dash.rb#230
  def required?(property); end

  # source://hashie//lib/hashie/dash.rb#195
  def update_attributes(attributes); end

  class << self
    # Returns the value of attribute defaults.
    #
    # source://hashie//lib/hashie/dash.rb#60
    def defaults; end

    # Returns the value of attribute getters.
    #
    # source://hashie//lib/hashie/dash.rb#61
    def getters; end

    # @private
    #
    # source://hashie//lib/hashie/dash.rb#69
    def inherited(klass); end

    # Returns the value of attribute properties.
    #
    # source://hashie//lib/hashie/dash.rb#60
    def properties; end

    # Defines a property on the Dash. Options are
    # as follows:
    #
    # * <tt>:default</tt> - Specify a default value for this property,
    #   to be returned before a value is set on the property in a new
    #   Dash.
    #
    # * <tt>:required</tt> - Specify the value as required for this
    #   property, to raise an error if a value is unset in a new or
    #   existing Dash. If a Proc is provided, it will be run in the
    #   context of the Dash instance. If a Symbol is provided, the
    #   property it represents must not be nil. The property is only
    #   required if the value is truthy.
    #
    # * <tt>:message</tt> - Specify custom error message for required property
    #
    # source://hashie//lib/hashie/dash.rb#36
    def property(property_name, options = T.unsafe(nil)); end

    # Check to see if the specified property has already been
    # defined.
    #
    # @return [Boolean]
    #
    # source://hashie//lib/hashie/dash.rb#80
    def property?(name); end

    # Check to see if the specified property is
    # required.
    #
    # @return [Boolean]
    #
    # source://hashie//lib/hashie/dash.rb#86
    def required?(name); end

    # Returns the value of attribute required_properties.
    #
    # source://hashie//lib/hashie/dash.rb#62
    def required_properties; end

    private

    # source://hashie//lib/hashie/dash.rb#90
    def define_getter_for(property_name); end

    # source://hashie//lib/hashie/dash.rb#96
    def define_setter_for(property_name); end
  end
end

module Hashie::Extensions; end
module Hashie::Extensions::Array; end

module Hashie::Extensions::Array::PrettyInspect
  # source://hashie//lib/hashie/extensions/array/pretty_inspect.rb#10
  def hashie_inspect; end

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/array/pretty_inspect.rb#5
    def included(base); end
  end
end

module Hashie::Extensions::Coercion
  include ::Hashie::Extensions::Coercion::InstanceMethods

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/coercion.rb#29
    def included(base); end
  end
end

# source://hashie//lib/hashie/extensions/coercion.rb#19
Hashie::Extensions::Coercion::ABSTRACT_CORE_TYPES = T.let(T.unsafe(nil), Hash)

# source://hashie//lib/hashie/extensions/coercion.rb#10
Hashie::Extensions::Coercion::CORE_TYPES = T.let(T.unsafe(nil), Hash)

module Hashie::Extensions::Coercion::ClassMethods
  # source://hashie//lib/hashie/extensions/coercion.rb#167
  def build_coercion(type); end

  # source://hashie//lib/hashie/extensions/coercion.rb#202
  def build_container_coercion(type, value_type); end

  # source://hashie//lib/hashie/extensions/coercion.rb#209
  def build_core_type_coercion(type); end

  # source://hashie//lib/hashie/extensions/coercion.rb#194
  def build_hash_coercion(type, key_type, value_type); end

  # Set up a coercion rule such that any time the specified
  # key is set it will be coerced into the specified class.
  # Coercion will occur by first attempting to call Class.coerce
  # and then by calling Class.new with the value as an argument
  # in either case.
  #
  # @example Coerce a "user" subhash into a User object
  #   class Tweet < Hash
  #   include Hashie::Extensions::Coercion
  #   coerce_key :user, User
  #   end
  # @param key [Object] the key or array of keys you would like to be coerced.
  # @param into [Class] the class into which you want the key(s) coerced.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#82
  def coerce_key(*attrs); end

  # Set up a coercion rule such that any time the specified
  # key is set it will be coerced into the specified class.
  # Coercion will occur by first attempting to call Class.coerce
  # and then by calling Class.new with the value as an argument
  # in either case.
  #
  # @example Coerce a "user" subhash into a User object
  #   class Tweet < Hash
  #   include Hashie::Extensions::Coercion
  #   coerce_key :user, User
  #   end
  # @param key [Object] the key or array of keys you would like to be coerced.
  # @param into [Class] the class into which you want the key(s) coerced.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#82
  def coerce_keys(*attrs); end

  # Set up a coercion rule such that any time a value of the
  # specified type is set it will be coerced into the specified
  # class.
  #
  # @example Coerce all hashes into this special type of hash
  #   class SpecialHash < Hash
  #   include Hashie::Extensions::Coercion
  #   coerce_value Hash, SpecialHash
  #
  #   def initialize(hash = {})
  #   super
  #   hash.each_pair do |k,v|
  #   self[k] = v
  #   end
  #   end
  #   end
  # @option options
  # @param from [Class] the type you would like coerced.
  # @param into [Class] the class into which you would like the value coerced.
  # @param options [Hash] a customizable set of options
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#121
  def coerce_value(from, into, options = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/coercion.rb#161
  def coercion_cache; end

  # source://hashie//lib/hashie/extensions/coercion.rb#156
  def fetch_coercion(type); end

  # source://hashie//lib/hashie/extensions/coercion.rb#217
  def inherited(klass); end

  # Returns the specific key coercion for the specified key,
  # if one exists.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#96
  def key_coercion(key); end

  # Returns a hash of any existing key coercions.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#90
  def key_coercions; end

  # Return all value coercions that have the :strict rule as false.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#146
  def lenient_value_coercions; end

  # Return all value coercions that have the :strict rule as true.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#141
  def strict_value_coercions; end

  # Fetch the value coercion, if any, for the specified object.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#151
  def value_coercion(value); end

  protected

  # Sets the attribute key_coercions
  #
  # @param value the value to set the attribute key_coercions to.
  #
  # source://hashie//lib/hashie/extensions/coercion.rb#65
  def key_coercions=(_arg0); end
end

module Hashie::Extensions::Coercion::InstanceMethods
  # source://hashie//lib/hashie/extensions/coercion.rb#53
  def custom_writer(key, value, _convert = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/coercion.rb#57
  def replace(other_hash); end

  # source://hashie//lib/hashie/extensions/coercion.rb#39
  def set_value_with_coercion(key, value); end
end

module Hashie::Extensions::Dash; end

module Hashie::Extensions::Dash::Coercion
  include ::Hashie::Extensions::Coercion::InstanceMethods

  mixes_in_class_methods ::Hashie::Extensions::Coercion::ClassMethods
  mixes_in_class_methods ::Hashie::Extensions::Dash::Coercion::ClassMethods

  class << self
    # Extends a Dash with the ability to define coercion for properties.
    #
    # source://hashie//lib/hashie/extensions/dash/coercion.rb#7
    def included(base); end
  end
end

module Hashie::Extensions::Dash::Coercion::ClassMethods
  # Defines a property on the Dash. Options are the standard
  # <tt>Hashie::Dash#property</tt> options plus:
  #
  # * <tt>:coerce</tt> - The class into which you want the property coerced.
  #
  # source://hashie//lib/hashie/extensions/dash/coercion.rb#17
  def property(property_name, options = T.unsafe(nil)); end
end

module Hashie::Extensions::Dash::IndifferentAccess
  mixes_in_class_methods ::Hashie::Extensions::Dash::IndifferentAccess::ClassMethods

  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#22
  def to_h; end

  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#22
  def to_hash; end

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#5
    def included(base); end

    # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#10
    def maybe_extend(base); end

    private

    # @return [Boolean]
    #
    # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#16
    def requires_class_methods?(klass); end
  end
end

module Hashie::Extensions::Dash::IndifferentAccess::ClassMethods
  # Check to see if the specified property has already been
  # defined.
  #
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#34
  def property?(name); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#50
  def transformation_exists?(name); end

  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#45
  def transformed_property(property_name, value); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#40
  def translation_exists?(name); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/indifferent_access.rb#57
  def translation_for?(name); end
end

# Extends a Dash with the ability to accept only predefined values on a property.
#
# == Example
#
#   class PersonHash < Hashie::Dash
#     include Hashie::Extensions::Dash::PredefinedValues
#
#     property :gender, values: [:male, :female, :prefer_not_to_say]
#     property :age, values: (0..150) # a Range
#   end
#
#   person = PersonHash.new(gender: :male, age: -1)
#   # => ArgumentError: The value '-1' is not accepted for property 'age'
module Hashie::Extensions::Dash::PredefinedValues
  include ::Hashie::Extensions::Dash::PredefinedValues::InstanceMethods

  mixes_in_class_methods ::Hashie::Extensions::Dash::PredefinedValues::ClassMethods

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#18
    def included(base); end
  end
end

module Hashie::Extensions::Dash::PredefinedValues::ClassMethods
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#27
  def inherited(klass); end

  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#32
  def property(property_name, options = T.unsafe(nil)); end

  # Returns the value of attribute values_for_properties.
  #
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#25
  def values_for_properties; end

  private

  # @raise [ArgumentError]
  #
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#43
  def assert_predefined_values!(predefined_values); end

  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#53
  def set_predefined_values(property_name, predefined_values); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#49
  def supported_type?(predefined_values); end
end

module Hashie::Extensions::Dash::PredefinedValues::InstanceMethods
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#59
  def initialize(*_arg0); end

  private

  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#67
  def assert_property_values!; end

  # @raise [ArgumentError]
  #
  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#77
  def fail_property_value_error!(property); end

  # source://hashie//lib/hashie/extensions/dash/predefined_values.rb#81
  def values_for_properties(property); end
end

# Extends a Dash with the ability to remap keys from a source hash.
#
# Property translation is useful when you need to read data from another
# application -- such as a Java API -- where the keys are named
# differently from Ruby conventions.
#
# == Example from inconsistent APIs
#
#   class PersonHash < Hashie::Dash
#     include Hashie::Extensions::Dash::PropertyTranslation
#
#     property :first_name, from :firstName
#     property :last_name, from: :lastName
#     property :first_name, from: :f_name
#     property :last_name, from: :l_name
#   end
#
#   person = PersonHash.new(firstName: 'Michael', l_name: 'Bleigh')
#   person[:first_name]  #=> 'Michael'
#   person[:last_name]   #=> 'Bleigh'
#
# You can also use a lambda to translate the value. This is particularly
# useful when you want to ensure the type of data you're wrapping.
#
# == Example using translation lambdas
#
#   class DataModelHash < Hashie::Dash
#     include Hashie::Extensions::Dash::PropertyTranslation
#
#     property :id, transform_with: ->(value) { value.to_i }
#     property :created_at, from: :created, with: ->(value) { Time.parse(value) }
#   end
#
#   model = DataModelHash.new(id: '123', created: '2014-04-25 22:35:28')
#   model.id.class          #=> Integer (Fixnum if you are using Ruby 2.3 or lower)
#   model.created_at.class  #=> Time
module Hashie::Extensions::Dash::PropertyTranslation
  include ::Hashie::Extensions::Dash::PropertyTranslation::InstanceMethods

  mixes_in_class_methods ::Hashie::Extensions::Dash::PropertyTranslation::ClassMethods

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/dash/property_translation.rb#41
    def included(base); end
  end
end

module Hashie::Extensions::Dash::PropertyTranslation::ClassMethods
  # Ensures that any inheriting classes maintain their translations.
  #
  # * <tt>:default</tt> - The class inheriting the translations.
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#54
  def inherited(klass); end

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#115
  def inverse_translations; end

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#60
  def permitted_input_keys; end

  # Defines a property on the Trash. Options are as follows:
  #
  # * <tt>:default</tt> - Specify a default value for this property, to be
  # returned before a value is set on the property in a new Dash.
  # * <tt>:from</tt> - Specify the original key name that will be write only.
  # * <tt>:with</tt> - Specify a lambda to be used to convert value.
  # * <tt>:transform_with</tt> - Specify a lambda to be used to convert value
  # without using the :from option. It transform the property itself.
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#74
  def property(property_name, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#94
  def transformation_exists?(name); end

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#90
  def transformed_property(property_name, value); end

  # Returns the value of attribute transforms.
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#49
  def transforms; end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#98
  def translation_exists?(name); end

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#102
  def translations; end

  # Returns the value of attribute translations_hash.
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#49
  def translations_hash; end

  private

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#127
  def define_translation(from, property_name, translator); end

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#131
  def define_writer_for_source_property(property); end

  # @raise [ArgumentError]
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#139
  def fail_self_transformation_error!(property_name); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#144
  def valid_transformer?(transformer); end
end

module Hashie::Extensions::Dash::PropertyTranslation::InstanceMethods
  # Sets a value on the Dash in a Hash-like way.
  #
  # Note: Only works on pre-existing properties.
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#153
  def []=(property, value); end

  # Deletes any keys that have a translation
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#170
  def initialize_attributes(attributes); end

  # Raises an NoMethodError if the property doesn't exist
  #
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#182
  def property_exists?(property); end

  private

  # source://hashie//lib/hashie/extensions/dash/property_translation.rb#189
  def __translations; end
end

# Searches a deeply nested datastructure for a key path, and returns the associated value.
#
#  options = { user: { location: { address: '123 Street' } } }
#  options.deep_fetch :user, :location, :address #=> '123 Street'
#
# If a block is provided its value will be returned if the key does not exist.
#
#  options.deep_fetch(:user, :non_existent_key) { 'a value' } #=> 'a value'
#
# This is particularly useful for fetching values from deeply nested api responses
#   or params hashes.
module Hashie::Extensions::DeepFetch
  # source://hashie//lib/hashie/extensions/deep_fetch.rb#17
  def deep_fetch(*args, &block); end
end

class Hashie::Extensions::DeepFetch::UndefinedPathError < ::StandardError; end

module Hashie::Extensions::DeepFind
  # Performs a depth-first search on deeply nested data structures for
  # a key and returns the first occurrence of the key.
  #
  #  options = {user: {location: {address: '123 Street'}}}
  #  options.extend(Hashie::Extensions::DeepFind)
  #  options.deep_find(:address) # => '123 Street'
  #
  #  class MyHash < Hash
  #    include Hashie::Extensions::DeepFind
  #  end
  #
  #  my_hash = MyHash.new
  #  my_hash[:user] = {location: {address: '123 Street'}}
  #  my_hash.deep_find(:address) # => '123 Street'
  #
  # source://hashie//lib/hashie/extensions/deep_find.rb#19
  def deep_detect(key); end

  # Performs a depth-first search on deeply nested data structures for
  # a key and returns the first occurrence of the key.
  #
  #  options = {user: {location: {address: '123 Street'}}}
  #  options.extend(Hashie::Extensions::DeepFind)
  #  options.deep_find(:address) # => '123 Street'
  #
  #  class MyHash < Hash
  #    include Hashie::Extensions::DeepFind
  #  end
  #
  #  my_hash = MyHash.new
  #  my_hash[:user] = {location: {address: '123 Street'}}
  #  my_hash.deep_find(:address) # => '123 Street'
  #
  # source://hashie//lib/hashie/extensions/deep_find.rb#19
  def deep_find(key); end

  # Performs a depth-first search on deeply nested data structures for
  # a key and returns all occurrences of the key.
  #
  #  options = {
  #    users: [
  #      { location: {address: '123 Street'} },
  #      { location: {address: '234 Street'}}
  #    ]
  #  }
  #  options.extend(Hashie::Extensions::DeepFind)
  #  options.deep_find_all(:address) # => ['123 Street', '234 Street']
  #
  #  class MyHash < Hash
  #    include Hashie::Extensions::DeepFind
  #  end
  #
  #  my_hash = MyHash.new
  #  my_hash[:users] = [
  #    {location: {address: '123 Street'}},
  #    {location: {address: '234 Street'}}
  #  ]
  #  my_hash.deep_find_all(:address) # => ['123 Street', '234 Street']
  #
  # source://hashie//lib/hashie/extensions/deep_find.rb#47
  def deep_find_all(key); end

  # Performs a depth-first search on deeply nested data structures for
  # a key and returns all occurrences of the key.
  #
  #  options = {
  #    users: [
  #      { location: {address: '123 Street'} },
  #      { location: {address: '234 Street'}}
  #    ]
  #  }
  #  options.extend(Hashie::Extensions::DeepFind)
  #  options.deep_find_all(:address) # => ['123 Street', '234 Street']
  #
  #  class MyHash < Hash
  #    include Hashie::Extensions::DeepFind
  #  end
  #
  #  my_hash = MyHash.new
  #  my_hash[:users] = [
  #    {location: {address: '123 Street'}},
  #    {location: {address: '234 Street'}}
  #  ]
  #  my_hash.deep_find_all(:address) # => ['123 Street', '234 Street']
  #
  # source://hashie//lib/hashie/extensions/deep_find.rb#47
  def deep_select(key); end

  private

  # source://hashie//lib/hashie/extensions/deep_find.rb#56
  def _deep_find(key, object = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/deep_find.rb#60
  def _deep_find_all(key, object = T.unsafe(nil), matches = T.unsafe(nil)); end
end

module Hashie::Extensions::DeepLocate
  # Performs a depth-first search on deeply nested data structures for a
  # given comparator callable and returns each Enumerable, for which the
  # callable returns true for at least one the its elements.
  #
  # @example
  #   books = [
  #   {
  #   title: "Ruby for beginners",
  #   pages: 120
  #   },
  #   {
  #   title: "CSS for intermediates",
  #   pages: 80
  #   },
  #   {
  #   title: "Collection of ruby books",
  #   books: [
  #   {
  #   title: "Ruby for the rest of us",
  #   pages: 576
  #   }
  #   ]
  #   }
  #   ]
  #
  #   books.extend(Hashie::Extensions::DeepLocate)
  #
  #   # for ruby 1.9 leave *no* space between the lambda rocket and the braces
  #   # http://ruby-journal.com/becareful-with-space-in-lambda-hash-rocket-syntax-between-ruby-1-dot-9-and-2-dot-0/
  #
  #   books.deep_locate -> (key, value, object) { key == :title && value.include?("Ruby") }
  #   # => [{:title=>"Ruby for beginners", :pages=>120},
  #   #     {:title=>"Ruby for the rest of us", :pages=>576}]
  #
  #   books.deep_locate -> (key, value, object) { key == :pages && value <= 120 }
  #   # => [{:title=>"Ruby for beginners", :pages=>120},
  #   #     {:title=>"CSS for intermediates", :pages=>80}]
  #
  # source://hashie//lib/hashie/extensions/deep_locate.rb#64
  def deep_locate(comparator); end

  class << self
    # The module level implementation of #deep_locate, incase you do not want
    # to include/extend the base datastructure. For further examples please
    # see #deep_locate.
    #
    # @example
    #   books = [
    #   {
    #   title: "Ruby for beginners",
    #   pages: 120
    #   },
    #   ...
    #   ]
    #
    #   DeepLocate.deep_locate -> (key, value, object) { key == :title }, books
    #   # => [{:title=>"Ruby for beginners", :pages=>120}, ...]
    #
    # source://hashie//lib/hashie/extensions/deep_locate.rb#19
    def deep_locate(comparator, object); end

    private

    # source://hashie//lib/hashie/extensions/deep_locate.rb#68
    def _construct_key_comparator(search_key, object); end

    # source://hashie//lib/hashie/extensions/deep_locate.rb#80
    def _deep_locate(comparator, object, result = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://hashie//lib/hashie/extensions/deep_locate.rb#95
    def _match_comparator?(value, comparator, object); end

    # @return [Boolean]
    #
    # source://hashie//lib/hashie/extensions/deep_locate.rb#106
    def activesupport_indifferent?(object); end
  end
end

module Hashie::Extensions::DeepMerge
  # Returns a new hash with +self+ and +other_hash+ merged recursively.
  #
  # source://hashie//lib/hashie/extensions/deep_merge.rb#5
  def deep_merge(other_hash, &block); end

  # Returns a new hash with +self+ and +other_hash+ merged recursively.
  # Modifies the receiver in place.
  #
  # source://hashie//lib/hashie/extensions/deep_merge.rb#13
  def deep_merge!(other_hash, &block); end

  private

  # source://hashie//lib/hashie/extensions/deep_merge.rb#21
  def _deep_dup(hash); end

  # source://hashie//lib/hashie/extensions/deep_merge.rb#36
  def _recursive_merge(hash, other_hash, &block); end
end

# IgnoreUndeclared is a simple mixin that silently ignores
# undeclared properties on initialization instead of
# raising an error. This is useful when using a Trash to
# capture a subset of a larger hash.
#
# Note that attempting to retrieve or set an undeclared property
# will still raise a NoMethodError, even if a value for
# that property was provided at initialization.
#
# @example
#   class Person < Trash
#   include Hashie::Extensions::IgnoreUndeclared
#
#   property :first_name
#   property :last_name
#   end
#
#   user_data = {
#   :first_name => 'Freddy',
#   :last_name => 'Nostrils',
#   :email => 'freddy@example.com'
#   }
#
#   p = Person.new(user_data) # 'email' is silently ignored
#
#   p.first_name # => 'Freddy'
#   p.last_name  # => 'Nostrils'
#   p.email      # => NoMethodError
module Hashie::Extensions::IgnoreUndeclared
  # source://hashie//lib/hashie/extensions/ignore_undeclared.rb#32
  def initialize_attributes(attributes); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/ignore_undeclared.rb#41
  def property_exists?(property); end
end

# IndifferentAccess gives you the ability to not care
# whether your hash has string or symbol keys. Made famous
# in Rails for accessing query and POST parameters, this
# is a handy tool for making sure your hash has maximum
# utility.
#
# One unique feature of this mixin is that it will recursively
# inject itself into sub-hash instances without modifying
# the actual class of the sub-hash.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MergeInitializer
#   include Hashie::Extensions::IndifferentAccess
#   end
#
#   h = MyHash.new(:foo => 'bar', 'baz' => 'blip')
#   h['foo'] # => 'bar'
#   h[:foo]  # => 'bar'
#   h[:baz]  # => 'blip'
#   h['baz'] # => 'blip'
module Hashie::Extensions::IndifferentAccess
  include ::Hashie::Extensions::RubyVersionCheck
  extend ::Hashie::Extensions::RubyVersionCheck::ClassMethods

  # Iterates through the keys and values, reconverting them to
  # their proper indifferent state. Used when IndifferentAccess
  # is injecting itself into member hashes.
  #
  # source://hashie//lib/hashie/extensions/indifferent_access.rb#82
  def convert!; end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#75
  def convert_key(key); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#171
  def except(*keys); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/indifferent_access.rb#131
  def indifferent_access?; end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#99
  def indifferent_default(key = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#119
  def indifferent_delete(key); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#115
  def indifferent_fetch(key, *args, &block); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/indifferent_access.rb#123
  def indifferent_key?(key); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#135
  def indifferent_replace(other_hash); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#104
  def indifferent_update(other_hash); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#89
  def indifferent_value(value); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#127
  def indifferent_values_at(*indices); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#111
  def indifferent_writer(key, value); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#141
  def merge(*args); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#147
  def merge!(*_arg0); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#164
  def slice(*keys); end

  # source://hashie//lib/hashie/extensions/indifferent_access.rb#151
  def to_hash; end

  protected

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/indifferent_access.rb#179
  def hash_lacking_indifference?(other); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/indifferent_access.rb#185
  def hash_with_indifference?(other); end

  class << self
    # @api private
    #
    # source://hashie//lib/hashie/extensions/indifferent_access.rb#29
    def convert_key(key); end

    # @private
    #
    # source://hashie//lib/hashie/extensions/indifferent_access.rb#33
    def included(base); end

    # Injects indifferent access into a duplicate of the hash
    # provided. See #inject!
    #
    # source://hashie//lib/hashie/extensions/indifferent_access.rb#71
    def inject(hash); end

    # This will inject indifferent access into an instance of
    # a hash without modifying the actual class. This is what
    # allows IndifferentAccess to spread to sub-hashes.
    #
    # source://hashie//lib/hashie/extensions/indifferent_access.rb#64
    def inject!(hash); end
  end
end

module Hashie::Extensions::KeyConflictWarning
  # Disable the logging of warnings based on keys conflicting keys/methods
  #
  # @api semipublic
  # @raise [CannotDisableMashWarnings]
  # @return [void]
  #
  # source://hashie//lib/hashie/extensions/key_conflict_warning.rb#17
  def disable_warnings(*method_keys); end

  # Checks whether this class disables warnings for conflicting keys/methods
  #
  # @api semipublic
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/key_conflict_warning.rb#32
  def disable_warnings?(method_key = T.unsafe(nil)); end

  # Returns an array of methods that this class disables warnings for.
  #
  # @api semipublic
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/key_conflict_warning.rb#41
  def disabled_warnings; end

  # Inheritance hook that sets class configuration when inherited.
  #
  # @api semipublic
  # @return [void]
  #
  # source://hashie//lib/hashie/extensions/key_conflict_warning.rb#49
  def inherited(subclass); end
end

class Hashie::Extensions::KeyConflictWarning::CannotDisableMashWarnings < ::StandardError
  # @return [CannotDisableMashWarnings] a new instance of CannotDisableMashWarnings
  #
  # source://hashie//lib/hashie/extensions/key_conflict_warning.rb#5
  def initialize; end
end

module Hashie::Extensions::KeyConversion
  include ::Hashie::Extensions::SymbolizeKeys
  include ::Hashie::Extensions::StringifyKeys

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/key_conversion.rb#4
    def included(base); end
  end
end

module Hashie::Extensions::Mash; end

module Hashie::Extensions::Mash::DefineAccessors
  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#12
    def extended(obj); end

    # @private
    #
    # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#5
    def included(klass); end
  end
end

class Hashie::Extensions::Mash::DefineAccessors::Ext < ::Module
  # @return [Ext] a new instance of Ext
  #
  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#17
  def initialize; end

  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#67
  def define_initializing_reader(key, method_name); end

  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#57
  def define_predicate(key, method_name); end

  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#37
  def define_reader(key, method_name); end

  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#77
  def define_underbang_reader(key, method_name); end

  # source://hashie//lib/hashie/extensions/mash/define_accessors.rb#47
  def define_writer(key, method_name); end
end

# Overrides the indifferent access of a Mash to keep keys in the
# original format given to the Mash.
#
# @example
#   class KeepingMash < Hashie::Mash
#   include Hashie::Extensions::Mash::KeepOriginalKeys
#   end
#
#   mash = KeepingMash.new(:symbol_key => :symbol, 'string_key' => 'string')
#   mash.to_hash  #=> { :symbol_key => :symbol, 'string_key' => 'string' }
#   mash['string_key'] == mash[:string_key]  #=> true
#   mash[:symbol_key] == mash['symbol_key']  #=> true
module Hashie::Extensions::Mash::KeepOriginalKeys
  private

  # Converts symbol/string keys to their alternative formats, but leaves
  # other keys alone.
  #
  # @param key [Object, String, Symbol] the key to convert.
  # @return [Object, String, Symbol] the converted key.
  #
  # source://hashie//lib/hashie/extensions/mash/keep_original_keys.rb#43
  def __convert(key); end

  # Converts the key when necessary to access the correct Mash key.
  #
  # @param key [Object, String, Symbol] the key to access.
  # @return [Object] the value assigned to the key.
  #
  # source://hashie//lib/hashie/extensions/mash/keep_original_keys.rb#28
  def convert_key(key); end

  class << self
    # @private
    # @raise [ArgumentError]
    #
    # source://hashie//lib/hashie/extensions/mash/keep_original_keys.rb#17
    def included(descendant); end
  end
end

# Allow a Mash to properly respond to everything
#
# By default, Mashes only say they respond to methods for keys that exist
# in their key set or any of the affix methods (e.g. setter, underbang,
# etc.). This causes issues when you try to use them within a
# SimpleDelegator or bind to a method for a key that is unset.
#
# This extension allows a Mash to properly respond to `respond_to?` and
# `method` for keys that have not yet been set. This enables full
# compatibility with SimpleDelegator and thunk-oriented programming.
#
# There is a trade-off with this extension: it will run slower than a
# regular Mash; insertions and initializations with keys run approximately
# 20% slower and cost approximately 19KB of memory per class that you
# make permissive.
#
# @api public
# @example Make a new, permissively responding Mash subclass
#   class PermissiveMash < Hashie::Mash
#   include Hashie::Extensions::Mash::PermissiveRespondTo
#   end
#
#   mash = PermissiveMash.new(a: 1)
#   mash.respond_to? :b  #=> true
module Hashie::Extensions::Mash::PermissiveRespondTo
  private

  # Override the Mash logging behavior to account for permissiveness
  #
  # @api private
  # @private
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/mash/permissive_respond_to.rb#53
  def log_collision?(method_key); end

  # The Ruby hook for determining what messages a class might respond to
  #
  # @api private
  # @private
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/mash/permissive_respond_to.rb#43
  def respond_to_missing?(_method_name, _include_private = T.unsafe(nil)); end

  class << self
    # The Ruby hook for behavior when including the module
    #
    # @api private
    # @private
    # @return void
    #
    # source://hashie//lib/hashie/extensions/mash/permissive_respond_to.rb#34
    def included(base); end
  end
end

module Hashie::Extensions::Mash::SafeAssignment
  # source://hashie//lib/hashie/extensions/mash/safe_assignment.rb#12
  def []=(*args); end

  # source://hashie//lib/hashie/extensions/mash/safe_assignment.rb#5
  def custom_writer(key, *args); end
end

# Overrides Mash's default behavior of converting keys to strings
#
# @api public
# @example
#   class LazyResponse < Hashie::Mash
#   include Hashie::Extensions::Mash::SymbolizeKeys
#   end
#
#   response = LazyResponse.new("id" => 123, "name" => "Rey").to_h
#   #=> {id: 123, name: "Rey"}
module Hashie::Extensions::Mash::SymbolizeKeys
  private

  # Converts a key to a symbol, if possible
  #
  # @api private
  # @param key [<K>] the key to attempt convert to a symbol
  # @return [Symbol, K]
  #
  # source://hashie//lib/hashie/extensions/mash/symbolize_keys.rb#32
  def convert_key(key); end

  class << self
    # Hook for being included in a class
    #
    # @api private
    # @raise [ArgumentError] when the base class isn't a Mash
    # @return [void]
    #
    # source://hashie//lib/hashie/extensions/mash/symbolize_keys.rb#21
    def included(base); end
  end
end

# The MergeInitializer is a super-simple mixin that allows
# you to initialize a subclass of Hash with another Hash
# to give you faster startup time for Hash subclasses. Note
# that you can still provide a default value as a second
# argument to the initializer.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MergeInitializer
#   end
#
#   h = MyHash.new(:abc => 'def')
#   h[:abc] # => 'def'
module Hashie::Extensions::MergeInitializer
  # source://hashie//lib/hashie/extensions/merge_initializer.rb#18
  def initialize(hash = T.unsafe(nil), default = T.unsafe(nil), &block); end
end

# A macro module that will automatically include MethodReader,
# MethodWriter, and MethodQuery, giving you the ability to read,
# write, and query keys in a hash using method call shortcuts.
module Hashie::Extensions::MethodAccess
  include ::Hashie::Extensions::MethodReader
  include ::Hashie::Extensions::MethodWriter
  include ::Hashie::Extensions::MethodQuery

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/method_access.rb#152
    def included(base); end
  end
end

# A macro module that will automatically include MethodReader,
# MethodOverridingWriter, and MethodQuery, giving you the ability
# to read, write, and query keys in a hash using method call
# shortcuts that can override object methods. Any overridden
# object method is automatically aliased with two leading
# underscores.
module Hashie::Extensions::MethodAccessWithOverride
  include ::Hashie::Extensions::MethodReader
  include ::Hashie::Extensions::MethodOverridingWriter
  include ::Hashie::Extensions::MethodQuery
  include ::Hashie::Extensions::MethodOverridingInitializer

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/method_access.rb#235
    def included(base); end
  end
end

# MethodOverridingInitializer allows you to override default hash
# methods when passing in values from an existing hash. The overriden
# methods are aliased with two leading underscores.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MethodOverridingInitializer
#   end
#
#   h = MyHash.new(zip: 'a-dee-doo-dah')
#   h.zip # => 'a-dee-doo-dah'
#   h.__zip # => [[['zip', 'a-dee-doo-dah']]]
module Hashie::Extensions::MethodOverridingInitializer
  include ::Hashie::Extensions::RedefineMethod

  # source://hashie//lib/hashie/extensions/method_access.rb#258
  def initialize(hash = T.unsafe(nil)); end
end

# MethodOverridingWriter gives you #key_name= shortcuts for
# writing to your hash. It allows methods to be overridden by
# #key_name= shortcuts and aliases those methods with two
# leading underscores.
#
# Keys are written as strings. Override #convert_key if you
# would like to have symbols or something else.
#
# Note that MethodOverridingWriter also overrides
# #respond_to_missing? such that any #method_name= will respond
# appropriately as true.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MethodOverridingWriter
#   end
#
#   h = MyHash.new
#   h.awesome = 'sauce'
#   h['awesome'] # => 'sauce'
#   h.zip = 'a-dee-doo-dah'
#   h.zip # => 'a-dee-doo-dah'
#   h.__zip # => [[['awesome', 'sauce'], ['zip', 'a-dee-doo-dah']]]
module Hashie::Extensions::MethodOverridingWriter
  include ::Hashie::Extensions::RedefineMethod

  # source://hashie//lib/hashie/extensions/method_access.rb#202
  def convert_key(key); end

  # source://hashie//lib/hashie/extensions/method_access.rb#206
  def method_missing(name, *args); end

  protected

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#223
  def already_overridden?(name); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#216
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# MethodQuery gives you the ability to check for the truthiness
# of a key via method calls. Note that it will return false if
# the key is set to a non-truthful value, not if the key isn't
# set at all. Use #key? for checking if a key has been set.
#
# MethodQuery will check against both string and symbol names
# of the method for existing keys. It also patches #respond_to
# to appropriately detect the query methods.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MethodQuery
#   end
#
#   h = MyHash.new
#   h['abc'] = 123
#   h.abc? # => true
#   h['def'] = nil
#   h.def? # => false
#   h.hji? # => NoMethodError
module Hashie::Extensions::MethodQuery
  # source://hashie//lib/hashie/extensions/method_access.rb#117
  def method_missing(name, *args); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#134
  def indifferent_key?(name); end

  # source://hashie//lib/hashie/extensions/method_access.rb#139
  def key_from_query_method(query_method); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#143
  def query_method?(name); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#109
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# MethodReader allows you to access keys of the hash
# via method calls. This gives you an OStruct like way
# to access your hash's keys. It will recognize keys
# either as strings or symbols.
#
# Note that while nil keys will be returned as nil,
# undefined keys will raise NoMethodErrors. Also note that
# #respond_to? has been patched to appropriately recognize
# key methods.
#
# @example
#   class User < Hash
#   include Hashie::Extensions::MethodReader
#   end
#
#   user = User.new
#   user['first_name'] = 'Michael'
#   user.first_name # => 'Michael'
#
#   user[:last_name] = 'Bleigh'
#   user.last_name # => 'Bleigh'
#
#   user[:birthday] = nil
#   user.birthday # => nil
#
#   user.not_declared # => NoMethodError
module Hashie::Extensions::MethodReader
  # source://hashie//lib/hashie/extensions/method_access.rb#35
  def method_missing(name, *args); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#30
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# MethodWriter gives you #key_name= shortcuts for
# writing to your hash. Keys are written as strings,
# override #convert_key if you would like to have symbols
# or something else.
#
# Note that MethodWriter also overrides #respond_to such
# that any #method_name= will respond appropriately as true.
#
# @example
#   class MyHash < Hash
#   include Hashie::Extensions::MethodWriter
#   end
#
#   h = MyHash.new
#   h.awesome = 'sauce'
#   h['awesome'] # => 'sauce'
module Hashie::Extensions::MethodWriter
  # source://hashie//lib/hashie/extensions/method_access.rb#83
  def convert_key(key); end

  # source://hashie//lib/hashie/extensions/method_access.rb#75
  def method_missing(name, *args); end

  private

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#70
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

module Hashie::Extensions::Parsers; end

class Hashie::Extensions::Parsers::YamlErbParser
  # @return [YamlErbParser] a new instance of YamlErbParser
  #
  # source://hashie//lib/hashie/extensions/parsers/yaml_erb_parser.rb#9
  def initialize(file_path, options = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/parsers/yaml_erb_parser.rb#15
  def perform; end

  private

  # source://hashie//lib/hashie/extensions/parsers/yaml_erb_parser.rb#32
  def yaml_safe_load(template, permitted_classes, permitted_symbols, aliases); end

  class << self
    # source://hashie//lib/hashie/extensions/parsers/yaml_erb_parser.rb#25
    def perform(file_path, options = T.unsafe(nil)); end
  end
end

module Hashie::Extensions::PrettyInspect
  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def hashie_inspect; end

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/pretty_inspect.rb#4
    def included(base); end
  end
end

# A module shared between MethodOverridingWriter and MethodOverridingInitializer
# to contained shared logic. This module aids in redefining existing hash methods.
module Hashie::Extensions::RedefineMethod
  protected

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/method_access.rb#164
  def method?(name); end

  # source://hashie//lib/hashie/extensions/method_access.rb#168
  def redefine_method(method_name); end
end

class Hashie::Extensions::RubyVersion
  include ::Comparable

  # @return [RubyVersion] a new instance of RubyVersion
  #
  # source://hashie//lib/hashie/extensions/ruby_version.rb#22
  def initialize(version); end

  # source://hashie//lib/hashie/extensions/ruby_version.rb#26
  def <=>(other); end

  # Returns the value of attribute segments.
  #
  # source://hashie//lib/hashie/extensions/ruby_version.rb#20
  def segments; end

  # Sets the attribute segments
  #
  # @param value the value to set the attribute segments to.
  #
  # source://hashie//lib/hashie/extensions/ruby_version.rb#20
  def segments=(_arg0); end

  private

  # source://hashie//lib/hashie/extensions/ruby_version.rb#53
  def split_to_segments(version); end
end

module Hashie::Extensions::RubyVersionCheck
  mixes_in_class_methods ::Hashie::Extensions::RubyVersionCheck::ClassMethods

  class << self
    # @private
    #
    # source://hashie//lib/hashie/extensions/ruby_version_check.rb#6
    def included(base); end
  end
end

module Hashie::Extensions::RubyVersionCheck::ClassMethods
  # source://hashie//lib/hashie/extensions/ruby_version_check.rb#11
  def with_minimum_ruby(version); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/extensions/ruby_version_check.rb#15
  def with_minimum_ruby?(version); end
end

# SRP: This extension will fail an error whenever a key is accessed
#   that does not exist in the hash.
#
#   EXAMPLE:
#
#     class StrictKeyAccessHash < Hash
#       include Hashie::Extensions::StrictKeyAccess
#     end
#
#     >> hash = StrictKeyAccessHash[foo: "bar"]
#     => {:foo=>"bar"}
#     >> hash[:foo]
#     => "bar"
#     >> hash[:cow]
#       KeyError: key not found: :cow
#
# NOTE: For googlers coming from Python to Ruby, this extension makes a Hash
# behave more like a "Dictionary".
module Hashie::Extensions::StrictKeyAccess
  # NOTE: Defaults don't make any sense with a StrictKeyAccess.
  # NOTE: When key lookup fails a KeyError is raised.
  #
  # Normal:
  #
  #     >> a = Hash.new(123)
  #     => {}
  #     >> a["noes"]
  #     => 123
  #
  # With StrictKeyAccess:
  #
  #     >> a = StrictKeyAccessHash.new(123)
  #     => {}
  #     >> a["noes"]
  #       KeyError: key not found: "noes"
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#48
  def [](key); end

  # @raise [DefaultError]
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#52
  def default(_ = T.unsafe(nil)); end

  # @raise [DefaultError]
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#56
  def default=(_); end

  # @raise [DefaultError]
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#60
  def default_proc; end

  # @raise [DefaultError]
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#64
  def default_proc=(_); end

  # source://hashie//lib/hashie/extensions/strict_key_access.rb#68
  def key(value); end
end

class Hashie::Extensions::StrictKeyAccess::DefaultError < ::StandardError
  # @return [DefaultError] a new instance of DefaultError
  #
  # source://hashie//lib/hashie/extensions/strict_key_access.rb#24
  def initialize; end
end

module Hashie::Extensions::StringifyKeys
  extend ::Hashie::Extensions::StringifyKeys::ClassMethods

  # Return a new hash with all keys converted
  # to strings.
  #
  # source://hashie//lib/hashie/extensions/stringify_keys.rb#17
  def stringify_keys; end

  # Convert all keys in the hash to strings.
  #
  # @example
  #   test = {:abc => 'def'}
  #   test.stringify_keys!
  #   test # => {'abc' => 'def'}
  #
  # source://hashie//lib/hashie/extensions/stringify_keys.rb#10
  def stringify_keys!; end
end

module Hashie::Extensions::StringifyKeys::ClassMethods
  # Return a copy of hash with all keys converted
  # to strings.
  #
  # @param hash [::Hash]
  #
  # source://hashie//lib/hashie/extensions/stringify_keys.rb#57
  def stringify_keys(hash); end

  # Convert all keys in the hash to strings.
  #
  # @example
  #   test = {:abc => 'def'}
  #   test.stringify_keys!
  #   test # => {'abc' => 'def'}
  # @param hash [::Hash]
  #
  # source://hashie//lib/hashie/extensions/stringify_keys.rb#45
  def stringify_keys!(hash); end

  # Stringify all keys recursively within nested
  # hashes and arrays.
  #
  # @api private
  #
  # source://hashie//lib/hashie/extensions/stringify_keys.rb#25
  def stringify_keys_recursively!(object); end
end

module Hashie::Extensions::SymbolizeKeys
  extend ::Hashie::Extensions::SymbolizeKeys::ClassMethods

  # Return a new hash with all keys converted
  # to symbols.
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#17
  def symbolize_keys; end

  # Convert all keys in the hash to symbols.
  #
  # @example
  #   test = {'abc' => 'def'}
  #   test.symbolize_keys!
  #   test # => {:abc => 'def'}
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#10
  def symbolize_keys!; end
end

module Hashie::Extensions::SymbolizeKeys::ClassMethods
  # Return a copy of hash with all keys converted
  # to symbols.
  #
  # @param hash [::Hash]
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#57
  def symbolize_keys(hash); end

  # Convert all keys in hash to symbols.
  #
  # @example
  #   test = {'abc' => 'def'}
  #   Hashie.symbolize_keys! test
  #   test # => {:abc => 'def'}
  # @param hash [Hash]
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#45
  def symbolize_keys!(hash); end

  # Symbolize all keys recursively within nested
  # hashes and arrays.
  #
  # @api private
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#25
  def symbolize_keys_recursively!(object); end

  private

  # Converts a key to a symbol, if possible
  #
  # @api private
  # @param key [<K>] the key to attempt convert to a symbol
  # @return [Symbol, K]
  #
  # source://hashie//lib/hashie/extensions/symbolize_keys.rb#72
  def convert_key(key); end
end

# A Hashie Hash is simply a Hash that has convenience
# functions baked in such as stringify_keys that may
# not be available in all libraries.
class Hashie::Hash < ::Hash
  include ::Hashie::Extensions::PrettyInspect
  include ::Hashie::Extensions::StringifyKeys

  def hash_inspect; end

  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def inspect; end

  # Converts a mash back to a hash (with stringified or symbolized keys)
  #
  # source://hashie//lib/hashie/hash.rb#18
  def to_hash(options = T.unsafe(nil)); end

  # The C generator for the json gem doesn't like mashies
  #
  # source://hashie//lib/hashie/hash.rb#42
  def to_json(*args); end

  # Convert this hash into a Mash
  #
  # source://hashie//lib/hashie/hash.rb#13
  def to_mash; end

  private

  # source://hashie//lib/hashie/hash.rb#54
  def flexibly_convert_to_hash(object, options = T.unsafe(nil)); end

  # source://hashie//lib/hashie/hash.rb#48
  def maybe_convert_to_hash(object, options); end
end

# Mash allows you to create pseudo-objects that have method-like
# accessors for hash keys. This is useful for such implementations
# as an API-accessing library that wants to fake robust objects
# without the overhead of actually doing so. Think of it as OpenStruct
# with some additional goodies.
#
# A Mash will look at the methods you pass it and perform operations
# based on the following rules:
#
# * No punctuation: Returns the value of the hash for that key, or nil if none exists.
# * Assignment (<tt>=</tt>): Sets the attribute of the given method name.
# * Truthiness (<tt>?</tt>): Returns true or false depending on the truthiness of
#   the attribute, or false if the key is not set.
# * Bang (<tt>!</tt>): Forces the existence of this key, used for deep Mashes. Think of it
#   as "touch" for mashes.
# * Under Bang (<tt>_</tt>): Like Bang, but returns a new Mash rather than creating a key.
#   Used to test existance in deep Mashes.
#
# == Basic Example
#
#   mash = Mash.new
#   mash.name? # => false
#   mash.name = "Bob"
#   mash.name # => "Bob"
#   mash.name? # => true
#
# == Hash Conversion  Example
#
#   hash = {:a => {:b => 23, :d => {:e => "abc"}}, :f => [{:g => 44, :h => 29}, 12]}
#   mash = Mash.new(hash)
#   mash.a.b # => 23
#   mash.a.d.e # => "abc"
#   mash.f.first.g # => 44
#   mash.f.last # => 12
#
# == Bang Example
#
#   mash = Mash.new
#   mash.author # => nil
#   mash.author! # => <Mash>
#
#   mash = Mash.new
#   mash.author!.name = "Michael Bleigh"
#   mash.author # => <Mash name="Michael Bleigh">
#
# == Under Bang Example
#
#   mash = Mash.new
#   mash.author # => nil
#   mash.author_ # => <Mash>
#   mash.author_.name # => nil
#
#   mash = Mash.new
#   mash.author_.name = "Michael Bleigh"  (assigned to temp object)
#   mash.author # => <Mash>
class Hashie::Mash < ::Hashie::Hash
  include ::Hashie::Extensions::RubyVersionCheck
  extend ::Hashie::Extensions::RubyVersionCheck::ClassMethods
  extend ::Hashie::Extensions::KeyConflictWarning

  # If you pass in an existing hash, it will
  # convert it to a Mash including recursively
  # descending into arrays and hashes, converting
  # them as well.
  #
  # @return [Mash] a new instance of Mash
  #
  # source://hashie//lib/hashie/mash.rb#100
  def initialize(source_hash = T.unsafe(nil), default = T.unsafe(nil), &blk); end

  # Retrieves an attribute set in the Mash. Will convert a key passed in
  # as a symbol to a string before retrieving.
  #
  # @yield [value]
  #
  # source://hashie//lib/hashie/mash.rb#125
  def [](key); end

  # Sets an attribute in the Mash. Symbol keys will be converted to
  # strings before being set, and Hashes will be converted into Mashes
  # for nesting purposes.
  #
  # source://hashie//lib/hashie/mash.rb#135
  def []=(key, value, convert = T.unsafe(nil)); end

  # Assigns a value to a key
  #
  # source://hashie//lib/hashie/mash.rb#259
  def assign_property(name, value); end

  # source://hashie//lib/hashie/mash.rb#338
  def compact; end

  # Retrieves an attribute set in the Mash. Will convert a key passed in
  # as a symbol to a string before retrieving.
  #
  # @yield [value]
  #
  # source://hashie//lib/hashie/mash.rb#125
  def custom_reader(key); end

  # Sets an attribute in the Mash. Symbol keys will be converted to
  # strings before being set, and Hashes will be converted into Mashes
  # for nesting purposes.
  #
  # source://hashie//lib/hashie/mash.rb#135
  def custom_writer(key, value, convert = T.unsafe(nil)); end

  # Performs a deep_update on a duplicate of the
  # current mash.
  #
  # source://hashie//lib/hashie/mash.rb#210
  def deep_merge(*other_hashes, &blk); end

  # Recursively merges this mash with the passed
  # in hash, merging each hash in the hierarchy.
  #
  # source://hashie//lib/hashie/mash.rb#216
  def deep_merge!(*other_hashes, &blk); end

  # Recursively merges this mash with the passed
  # in hash, merging each hash in the hierarchy.
  #
  # source://hashie//lib/hashie/mash.rb#216
  def deep_update(*other_hashes, &blk); end

  # source://hashie//lib/hashie/mash.rb#166
  def delete(key); end

  # source://hashie//lib/hashie/mash.rb#326
  def dig(*keys); end

  # Duplicates the current mash as a new mash.
  #
  # source://hashie//lib/hashie/mash.rb#195
  def dup; end

  # source://hashie//lib/hashie/mash.rb#355
  def except(*keys); end

  # play nice with ActiveSupport Array#extract_options!
  #
  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#316
  def extractable_options?; end

  # source://hashie//lib/hashie/mash.rb#162
  def fetch(key, *args); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#200
  def has_key?(key); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#200
  def include?(key); end

  # This is the bang method reader, it will return a new Mash
  # if there isn't a value already assigned to the key requested.
  #
  # source://hashie//lib/hashie/mash.rb#145
  def initializing_reader(key); end

  # Returns a new instance of the class it was called on, using its keys as
  # values, and its values as keys. The new values and keys will always be
  # strings.
  #
  # source://hashie//lib/hashie/mash.rb#177
  def invert; end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#200
  def key?(key); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#200
  def member?(key); end

  # Performs a deep_update on a duplicate of the
  # current mash.
  # Alias these lexically so they get the correctly defined
  # #deep_merge and #deep_update based on ruby version.
  #
  # source://hashie//lib/hashie/mash.rb#210
  def merge(*other_hashes, &blk); end

  # Recursively merges this mash with the passed
  # in hash, merging each hash in the hierarchy.
  #
  # source://hashie//lib/hashie/mash.rb#216
  def merge!(*other_hashes, &blk); end

  # source://hashie//lib/hashie/mash.rb#298
  def method_missing(method_name, *args, &blk); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#293
  def prefix_method?(method_name); end

  def regular_dup; end
  def regular_key?(_arg0); end
  def regular_reader(_arg0); end
  def regular_writer(_arg0, _arg1); end

  # Returns a new instance of the class it was called on, containing elements
  # for which the given block returns false.
  #
  # source://hashie//lib/hashie/mash.rb#183
  def reject(&blk); end

  # source://hashie//lib/hashie/mash.rb#277
  def replace(other_hash); end

  # another ActiveSupport method, see issue #270
  #
  # source://hashie//lib/hashie/mash.rb#321
  def reverse_merge(other_hash); end

  # Returns a new instance of the class it was called on, containing elements
  # for which the given block returns true.
  #
  # source://hashie//lib/hashie/mash.rb#189
  def select(&blk); end

  # Performs a shallow_update on a duplicate of the current mash
  #
  # source://hashie//lib/hashie/mash.rb#264
  def shallow_merge(other_hash); end

  # Merges (non-recursively) the hash from the argument,
  # changing the receiving hash
  #
  # source://hashie//lib/hashie/mash.rb#270
  def shallow_update(other_hash); end

  # source://hashie//lib/hashie/mash.rb#344
  def slice(*keys); end

  # source://hashie//lib/hashie/mash.rb#81
  def to_module(mash_method_name = T.unsafe(nil)); end

  # source://hashie//lib/hashie/extensions/pretty_inspect.rb#9
  def to_s; end

  # source://hashie//lib/hashie/mash.rb#349
  def transform_keys(&blk); end

  # source://hashie//lib/hashie/mash.rb#332
  def transform_values(&blk); end

  # This is the under bang method reader, it will return a temporary new Mash
  # if there isn't a value already assigned to the key requested.
  #
  # source://hashie//lib/hashie/mash.rb#153
  def underbang_reader(key); end

  # Recursively merges this mash with the passed
  # in hash, merging each hash in the hierarchy.
  #
  # source://hashie//lib/hashie/mash.rb#216
  def update(*other_hashes, &blk); end

  # source://hashie//lib/hashie/mash.rb#170
  def values_at(*keys); end

  # source://hashie//lib/hashie/mash.rb#90
  def with_accessors!; end

  protected

  # source://hashie//lib/hashie/mash.rb#377
  def convert_key(key); end

  # source://hashie//lib/hashie/mash.rb#381
  def convert_value(val, duping = T.unsafe(nil)); end

  # source://hashie//lib/hashie/mash.rb#363
  def method_name_and_suffix(method_name); end

  # source://hashie//lib/hashie/mash.rb#372
  def method_suffix(method_name); end

  private

  # source://hashie//lib/hashie/mash.rb#244
  def _deep_update(other_hash, &blk); end

  # source://hashie//lib/hashie/mash.rb#399
  def log_built_in_message(method_key); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#412
  def log_collision?(method_key); end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/mash.rb#283
  def respond_to_missing?(method_name, *args); end

  class << self
    def [](*_arg0); end

    # @raise [ArgumentError]
    #
    # source://hashie//lib/hashie/mash.rb#70
    def load(path, options = T.unsafe(nil)); end

    # Creates a new anonymous subclass with key conflict
    # warnings disabled. You may pass an array of method
    # symbols to restrict the disabled warnings to.
    # Hashie::Mash.quiet.new(hash) all warnings disabled.
    # Hashie::Mash.quiet(:zip).new(hash) only zip warning
    # is disabled.
    #
    # source://hashie//lib/hashie/mash.rb#111
    def quiet(*method_keys); end
  end
end

# source://hashie//lib/hashie/mash.rb#68
Hashie::Mash::ALLOWED_SUFFIXES = T.let(T.unsafe(nil), Array)

class Hashie::Railtie < ::Rails::Railtie; end

# Rash is a Hash whose keys can be Regexps, or Ranges, which will
# match many input keys.
#
# A good use case for this class is routing URLs in a web framework.
# The Rash's keys match URL patterns, and the values specify actions
# which can handle the URL. When the Rash's value is proc, the proc
# will be automatically called with the regexp's matched groups as
# block arguments.
#
# Usage example:
#
#     greeting = Hashie::Rash.new( /^Mr./ => "Hello sir!", /^Mrs./ => "Evening, madame." )
#     greeting["Mr. Steve Austin"] #=> "Hello sir!"
#     greeting["Mrs. Steve Austin"] #=> "Evening, madame."
#
# Note: The Rash is automatically optimized every 500 accesses
#       (Regexps get sorted by how often they get matched).
#       If this is too low or too high, you can tune it by
#       setting: `rash.optimize_every = n`
class Hashie::Rash
  # @return [Rash] a new instance of Rash
  #
  # source://hashie//lib/hashie/rash.rb#26
  def initialize(initial = T.unsafe(nil)); end

  # Return the first thing that matches the key.
  #
  # source://hashie//lib/hashie/rash.rb#59
  def [](key); end

  # source://hashie//lib/hashie/rash.rb#45
  def []=(key, value); end

  # Return everything that matches the query.
  #
  # source://hashie//lib/hashie/rash.rb#88
  def all(query); end

  # Raise (or yield) unless something matches the key.
  #
  # @raise [ArgumentError]
  #
  # source://hashie//lib/hashie/rash.rb#66
  def fetch(*args); end

  # source://hashie//lib/hashie/rash.rb#127
  def method_missing(*args, &block); end

  # Returns the value of attribute optimize_every.
  #
  # source://hashie//lib/hashie/rash.rb#24
  def optimize_every; end

  # Sets the attribute optimize_every
  #
  # @param value the value to set the attribute optimize_every to.
  #
  # source://hashie//lib/hashie/rash.rb#24
  def optimize_every=(_arg0); end

  # source://hashie//lib/hashie/rash.rb#37
  def update(other); end

  private

  # source://hashie//lib/hashie/rash.rb#137
  def optimize_if_necessary!; end

  # @return [Boolean]
  #
  # source://hashie//lib/hashie/rash.rb#131
  def respond_to_missing?(method_name, _include_private = T.unsafe(nil)); end
end

# A Trash is a 'translated' Dash where the keys can be remapped from a source
# hash.
#
# Trashes are useful when you need to read data from another application,
# such as a Java api, where the keys are named differently from how we would
# in Ruby.
class Hashie::Trash < ::Hashie::Dash
  include ::Hashie::Extensions::Dash::PropertyTranslation
  include ::Hashie::Extensions::Dash::PropertyTranslation::InstanceMethods
  extend ::Hashie::Extensions::Dash::PropertyTranslation::ClassMethods
end

# A collection of helper methods that can be used throughout the gem.
module Hashie::Utils
  class << self
    # Lists the classes Ruby uses for integers
    #
    # @api private
    # @return [Array<Class>]
    #
    # source://hashie//lib/hashie/utils.rb#35
    def integer_classes; end

    # Describes a method by where it was defined.
    #
    # @param bound_method [Method] The method to describe.
    # @return [String]
    #
    # source://hashie//lib/hashie/utils.rb#8
    def method_information(bound_method); end

    # Duplicates a value or returns the value when it is not duplicable
    #
    # @api public
    # @param value [Object] the value to safely duplicate
    # @return [Object] the duplicated value
    #
    # source://hashie//lib/hashie/utils.rb#22
    def safe_dup(value); end
  end
end

# source://hashie//lib/hashie/version.rb#2
Hashie::VERSION = T.let(T.unsafe(nil), String)
