# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `get_process_mem` gem.
# Please instead update this file by running `bin/tapioca gem get_process_mem`.

# Cribbed from Unicorn Worker Killer, thanks!
class GetProcessMem
  # @return [GetProcessMem] a new instance of GetProcessMem
  #
  # source://get_process_mem//lib/get_process_mem.rb#48
  def initialize(pid = T.unsafe(nil)); end

  # source://get_process_mem//lib/get_process_mem.rb#59
  def bytes; end

  # source://get_process_mem//lib/get_process_mem.rb#121
  def darwin_memory; end

  # source://get_process_mem//lib/get_process_mem.rb#73
  def gb(b = T.unsafe(nil)); end

  # source://get_process_mem//lib/get_process_mem.rb#77
  def inspect; end

  # source://get_process_mem//lib/get_process_mem.rb#65
  def kb(b = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://get_process_mem//lib/get_process_mem.rb#55
  def linux?; end

  # linux stores detailed memory info in a file "/proc/#{pid}/smaps"
  #
  # source://get_process_mem//lib/get_process_mem.rb#94
  def linux_memory(file = T.unsafe(nil)); end

  # linux stores memory info in a file "/proc/#{pid}/status"
  # If it's available it uses less resources than shelling out to ps
  #
  # source://get_process_mem//lib/get_process_mem.rb#84
  def linux_status_memory(file = T.unsafe(nil)); end

  # source://get_process_mem//lib/get_process_mem.rb#69
  def mb(b = T.unsafe(nil)); end

  # Returns the value of attribute pid.
  #
  # source://get_process_mem//lib/get_process_mem.rb#19
  def pid; end

  # Pull memory from `ps` command, takes more resources and can freeze
  # in low memory situations
  #
  # source://get_process_mem//lib/get_process_mem.rb#111
  def ps_memory; end

  private

  # source://get_process_mem//lib/get_process_mem.rb#10
  def number_to_bigdecimal(value); end

  class << self
    private

    # source://get_process_mem//lib/get_process_mem.rb#6
    def number_to_bigdecimal(value); end
  end
end

# source://get_process_mem//lib/get_process_mem.rb#17
GetProcessMem::CONVERSION = T.let(T.unsafe(nil), Hash)

# 1024**3 = 1_073_741_824
#
# source://get_process_mem//lib/get_process_mem.rb#16
GetProcessMem::GB_TO_BYTE = T.let(T.unsafe(nil), BigDecimal)

# 2**10   = 1024
#
# source://get_process_mem//lib/get_process_mem.rb#14
GetProcessMem::KB_TO_BYTE = T.let(T.unsafe(nil), BigDecimal)

# 1024**2 = 1_048_576
#
# source://get_process_mem//lib/get_process_mem.rb#15
GetProcessMem::MB_TO_BYTE = T.let(T.unsafe(nil), BigDecimal)

# source://get_process_mem//lib/get_process_mem.rb#18
GetProcessMem::ROUND_UP = T.let(T.unsafe(nil), BigDecimal)

# source://get_process_mem//lib/get_process_mem.rb#34
GetProcessMem::RUNS_ON_DARWIN = T.let(T.unsafe(nil), T.untyped)

# source://get_process_mem//lib/get_process_mem.rb#21
GetProcessMem::RUNS_ON_WINDOWS = T.let(T.unsafe(nil), FalseClass)
