# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `geocoder` gem.
# Please instead update this file by running `bin/tapioca gem geocoder`.

module Geocoder
  class << self
    # Look up the address of the given coordinates ([lat,lon])
    # or IP address (string).
    #
    # source://geocoder//lib/geocoder.rb#38
    def address(query, options = T.unsafe(nil)); end

    # Read-only access to the singleton's config data.
    #
    # source://geocoder//lib/geocoder/configuration.rb#26
    def config; end

    # Read-only access to lookup-specific config data.
    #
    # source://geocoder//lib/geocoder/configuration.rb#33
    def config_for_lookup(lookup_name); end

    # Configuration options should be set by passing a hash:
    #
    #   Geocoder.configure(
    #     :timeout  => 5,
    #     :lookup   => :yandex,
    #     :api_key  => "2a9fsa983jaslfj982fjasd",
    #     :units    => :km
    #   )
    #
    # source://geocoder//lib/geocoder/configuration.rb#17
    def configure(options = T.unsafe(nil), &block); end

    # Look up the coordinates of the given street or IP address.
    #
    # source://geocoder//lib/geocoder.rb#28
    def coordinates(address, options = T.unsafe(nil)); end

    # source://geocoder//lib/geocoder/logger.rb#5
    def log(level, message); end

    # Merge the given hash into a lookup's existing configuration.
    #
    # source://geocoder//lib/geocoder/configuration.rb#45
    def merge_into_lookup_config(lookup_name, options); end

    # Search for information about an address or a set of coordinates.
    #
    # source://geocoder//lib/geocoder.rb#20
    def search(query, options = T.unsafe(nil)); end
  end
end

class Geocoder::Cache
  # @return [Cache] a new instance of Cache
  #
  # source://geocoder//lib/geocoder/cache.rb#6
  def initialize(store, config); end

  # Read from the Cache.
  #
  # source://geocoder//lib/geocoder/cache.rb#14
  def [](url); end

  # Write to the Cache.
  #
  # source://geocoder//lib/geocoder/cache.rb#23
  def []=(url, value); end

  # Delete cache entry for given URL,
  # or pass <tt>:all</tt> to clear all URLs.
  #
  # source://geocoder//lib/geocoder/cache.rb#33
  def expire(url); end

  private

  # source://geocoder//lib/geocoder/cache.rb#73
  def expire_single_url(url); end

  # Clean up value before returning. Namely, convert empty string to nil.
  # (Some key/value stores return empty string instead of nil.)
  #
  # source://geocoder//lib/geocoder/cache.rb#69
  def interpret(value); end

  # Array of keys with the currently configured prefix
  # that have non-nil values.
  #
  # source://geocoder//lib/geocoder/cache.rb#54
  def keys; end

  # source://geocoder//lib/geocoder/cache.rb#48
  def store_service; end

  # Array of cached URLs.
  #
  # source://geocoder//lib/geocoder/cache.rb#61
  def urls; end
end

module Geocoder::CacheStore; end

class Geocoder::CacheStore::Base
  # @return [Base] a new instance of Base
  #
  # source://geocoder//lib/geocoder/cache_stores/base.rb#3
  def initialize(store, options); end

  # Array of keys with the currently configured prefix
  # that have non-nil values.
  #
  # source://geocoder//lib/geocoder/cache_stores/base.rb#12
  def keys; end

  # Array of cached URLs.
  #
  # source://geocoder//lib/geocoder/cache_stores/base.rb#19
  def urls; end

  protected

  # source://geocoder//lib/geocoder/cache_stores/base.rb#27
  def config; end

  # Cache key for a given URL.
  #
  # source://geocoder//lib/geocoder/cache_stores/base.rb#32
  def key_for(url); end

  # source://geocoder//lib/geocoder/cache_stores/base.rb#25
  def prefix; end

  # source://geocoder//lib/geocoder/cache_stores/base.rb#26
  def store; end
end

class Geocoder::CacheStore::Generic < ::Geocoder::CacheStore::Base
  # source://geocoder//lib/geocoder/cache_stores/generic.rb#27
  def keys; end

  # source://geocoder//lib/geocoder/cache_stores/generic.rb#16
  def read(url); end

  # source://geocoder//lib/geocoder/cache_stores/generic.rb#31
  def remove(key); end

  # source://geocoder//lib/geocoder/cache_stores/generic.rb#5
  def write(url, value); end
end

class Geocoder::CacheStore::Redis < ::Geocoder::CacheStore::Base
  # @return [Redis] a new instance of Redis
  #
  # source://geocoder//lib/geocoder/cache_stores/redis.rb#5
  def initialize(store, options); end

  # source://geocoder//lib/geocoder/cache_stores/redis.rb#22
  def keys; end

  # source://geocoder//lib/geocoder/cache_stores/redis.rb#18
  def read(url); end

  # source://geocoder//lib/geocoder/cache_stores/redis.rb#26
  def remove(key); end

  # source://geocoder//lib/geocoder/cache_stores/redis.rb#10
  def write(url, value, expire = T.unsafe(nil)); end

  private

  # source://geocoder//lib/geocoder/cache_stores/redis.rb#32
  def expire; end
end

module Geocoder::Calculations
  extend ::Geocoder::Calculations

  # Bearing between two points on Earth.
  # Returns a number of degrees from due north (clockwise).
  #
  # See Geocoder::Calculations.distance_between for
  # ways of specifying the points. Also accepts an options hash:
  #
  # * <tt>:method</tt> - <tt>:linear</tt> or <tt>:spherical</tt>;
  #   the spherical method is "correct" in that it returns the shortest path
  #   (one along a great circle) but the linear method is less confusing
  #   (returns due east or west when given two points with the same latitude).
  #   Use Geocoder.configure(:distances => ...) to configure calculation method.
  #
  # Based on: http://www.movable-type.co.uk/scripts/latlong.html
  #
  # source://geocoder//lib/geocoder/calculations.rb#118
  def bearing_between(point1, point2, options = T.unsafe(nil)); end

  # Returns coordinates of the southwest and northeast corners of a box
  # with the given point at its center. The radius is the shortest distance
  # from the center point to any side of the box (the length of each side
  # is twice the radius).
  #
  # This is useful for finding corner points of a map viewport, or for
  # roughly limiting the possible solutions in a geo-spatial search
  # (ActiveRecord queries use it thusly).
  #
  # See Geocoder::Calculations.distance_between for
  # ways of specifying the point. Also accepts an options hash:
  #
  # * <tt>:units</tt> - <tt>:mi</tt> or <tt>:km</tt>.
  #   Use Geocoder.configure(:units => ...) to configure default units.
  #
  # source://geocoder//lib/geocoder/calculations.rb#210
  def bounding_box(point, radius, options = T.unsafe(nil)); end

  # Translate a bearing (float) into a compass direction (string, eg "North").
  #
  # source://geocoder//lib/geocoder/calculations.rb#156
  def compass_point(bearing, points = T.unsafe(nil)); end

  # Returns true if all given arguments are valid latitude/longitude values.
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/calculations.rb#44
  def coordinates_present?(*args); end

  # Distance between two points on Earth (Haversine formula).
  # Takes two points and an options hash.
  # The points are given in the same way that points are given to all
  # Geocoder methods that accept points as arguments. They can be:
  #
  # * an array of coordinates ([lat,lon])
  # * a geocodable address (string)
  # * a geocoded object (one which implements a +to_coordinates+ method
  #   which returns a [lat,lon] array
  #
  # The options hash supports:
  #
  # * <tt>:units</tt> - <tt>:mi</tt> or <tt>:km</tt>
  #   Use Geocoder.configure(:units => ...) to configure default units.
  #
  # source://geocoder//lib/geocoder/calculations.rb#84
  def distance_between(point1, point2, options = T.unsafe(nil)); end

  # source://geocoder//lib/geocoder/calculations.rb#319
  def distance_to_radians(distance, units = T.unsafe(nil)); end

  # Radius of the Earth in the given units (:mi or :km).
  # Use Geocoder.configure(:units => ...) to configure default units.
  #
  # source://geocoder//lib/geocoder/calculations.rb#355
  def earth_radius(units = T.unsafe(nil)); end

  # Given a start point, heading (in degrees), and distance, provides
  # an endpoint.
  # The starting point is given in the same way that points are given to all
  # Geocoder methods that accept points as arguments. It can be:
  #
  # * an array of coordinates ([lat,lon])
  # * a geocodable address (string)
  # * a geocoded object (one which implements a +to_coordinates+ method
  #   which returns a [lat,lon] array
  #
  # source://geocoder//lib/geocoder/calculations.rb#269
  def endpoint(start, heading, distance, options = T.unsafe(nil)); end

  # Takes an object which is a [lat,lon] array, a geocodable string,
  # or an object that implements +to_coordinates+ and returns a
  # [lat,lon] array. Note that if a string is passed this may be a slow-
  # running method and may return nil.
  #
  # source://geocoder//lib/geocoder/calculations.rb#397
  def extract_coordinates(point); end

  # Compute the geographic center (aka geographic midpoint, center of
  # gravity) for an array of geocoded objects and/or [lat,lon] arrays
  # (can be mixed). Any objects missing coordinates are ignored. Follows
  # the procedure documented at http://www.geomidpoint.com/calculation.html.
  #
  # source://geocoder//lib/geocoder/calculations.rb#167
  def geographic_center(points); end

  # Conversion factor: km to mi.
  #
  # source://geocoder//lib/geocoder/calculations.rb#362
  def km_in_mi; end

  # Conversion factor: km to nm.
  #
  # source://geocoder//lib/geocoder/calculations.rb#370
  def km_in_nm; end

  # Distance spanned by one degree of latitude in the given units.
  #
  # source://geocoder//lib/geocoder/calculations.rb#56
  def latitude_degree_distance(units = T.unsafe(nil)); end

  # Distance spanned by one degree of longitude at the given latitude.
  # This ranges from around 69 miles at the equator to zero at the poles.
  #
  # source://geocoder//lib/geocoder/calculations.rb#64
  def longitude_degree_distance(latitude, units = T.unsafe(nil)); end

  # Conversion factor: mi to km.
  #
  # source://geocoder//lib/geocoder/calculations.rb#378
  def mi_in_km; end

  # Conversion factor: nm to km.
  #
  # source://geocoder//lib/geocoder/calculations.rb#386
  def nm_in_km; end

  # source://geocoder//lib/geocoder/calculations.rb#323
  def radians_to_distance(radians, units = T.unsafe(nil)); end

  # Random point within a circle of provided radius centered
  # around the provided point
  # Takes one point, one radius, and an options hash.
  # The points are given in the same way that points are given to all
  # Geocoder methods that accept points as arguments. They can be:
  #
  # * an array of coordinates ([lat,lon])
  # * a geocodable address (string)
  # * a geocoded object (one which implements a +to_coordinates+ method
  #   which returns a [lat,lon] array
  #
  # The options hash supports:
  #
  # * <tt>:units</tt> - <tt>:mi</tt> or <tt>:km</tt>
  #   Use Geocoder.configure(:units => ...) to configure default units.
  # * <tt>:seed</tt> - The seed for the random number generator
  #
  # source://geocoder//lib/geocoder/calculations.rb#238
  def random_point_near(center, radius, options = T.unsafe(nil)); end

  # Convert radians to degrees.
  # If an array (or multiple arguments) is passed,
  # converts each value and returns array.
  #
  # source://geocoder//lib/geocoder/calculations.rb#310
  def to_degrees(*args); end

  # Convert miles to kilometers.
  #
  # source://geocoder//lib/geocoder/calculations.rb#330
  def to_kilometers(mi); end

  # Convert kilometers to miles.
  #
  # source://geocoder//lib/geocoder/calculations.rb#338
  def to_miles(km); end

  # Convert kilometers to nautical miles.
  #
  # source://geocoder//lib/geocoder/calculations.rb#346
  def to_nautical_miles(km); end

  # Convert degrees to radians.
  # If an array (or multiple arguments) is passed,
  # converts each value and returns array.
  #
  # source://geocoder//lib/geocoder/calculations.rb#296
  def to_radians(*args); end
end

# Compass point names, listed clockwise starting at North.
#
# If you want bearings named using more, fewer, or different points
# override Geocoder::Calculations.COMPASS_POINTS with your own array.
#
# source://geocoder//lib/geocoder/calculations.rb#11
Geocoder::Calculations::COMPASS_POINTS = T.let(T.unsafe(nil), Array)

# Conversion factor: multiply by radians to get degrees.
#
# source://geocoder//lib/geocoder/calculations.rb#26
Geocoder::Calculations::DEGREES_PER_RADIAN = T.let(T.unsafe(nil), Float)

# Radius of the Earth, in kilometers.
# Value taken from: http://en.wikipedia.org/wiki/Earth_radius
#
# source://geocoder//lib/geocoder/calculations.rb#32
Geocoder::Calculations::EARTH_RADII = T.let(T.unsafe(nil), Hash)

# TODO: deprecate this constant (use `EARTH_RADII[:km]`)
#
# source://geocoder//lib/geocoder/calculations.rb#36
Geocoder::Calculations::EARTH_RADIUS = T.let(T.unsafe(nil), Float)

# Conversion factor: multiply by kilometers to get miles.
#
# source://geocoder//lib/geocoder/calculations.rb#16
Geocoder::Calculations::KM_IN_MI = T.let(T.unsafe(nil), Float)

# Conversion factor: multiply by nautical miles to get miles.
#
# source://geocoder//lib/geocoder/calculations.rb#21
Geocoder::Calculations::KM_IN_NM = T.let(T.unsafe(nil), Float)

# Not a number constant
#
# source://geocoder//lib/geocoder/calculations.rb#39
Geocoder::Calculations::NAN = T.let(T.unsafe(nil), Float)

class Geocoder::Configuration
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # :nodoc
  #
  # @return [Configuration] a new instance of Configuration
  #
  # source://geocoder//lib/geocoder/configuration.rb#97
  def initialize; end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def always_raise; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def always_raise=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def api_key; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def api_key=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def basic_auth; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def basic_auth=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def cache; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def cache=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def cache_options; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def cache_options=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#93
  def configure(options); end

  # Returns the value of attribute data.
  #
  # source://geocoder//lib/geocoder/configuration.rb#74
  def data; end

  # Sets the attribute data
  #
  # @param value the value to set the attribute data to.
  #
  # source://geocoder//lib/geocoder/configuration.rb#74
  def data=(_arg0); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def distances; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def distances=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def host; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def host=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def http_headers; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def http_headers=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def http_proxy; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def http_proxy=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def https_proxy; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def https_proxy=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def ip_lookup; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def ip_lookup=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def kernel_logger_level; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def kernel_logger_level=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def language; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def language=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def logger; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def logger=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def lookup; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def lookup=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#102
  def set_defaults; end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def timeout; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def timeout=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def units; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def units=(value); end

  # source://geocoder//lib/geocoder/configuration.rb#85
  def use_https; end

  # source://geocoder//lib/geocoder/configuration.rb#88
  def use_https=(value); end

  class << self
    def always_raise; end
    def always_raise=(value); end
    def api_key; end
    def api_key=(value); end
    def basic_auth; end
    def basic_auth=(value); end
    def cache; end
    def cache=(value); end
    def cache_options; end
    def cache_options=(value); end
    def distances; end
    def distances=(value); end
    def host; end
    def host=(value); end
    def http_headers; end
    def http_headers=(value); end
    def http_proxy; end
    def http_proxy=(value); end
    def https_proxy; end
    def https_proxy=(value); end
    def ip_lookup; end
    def ip_lookup=(value); end
    def kernel_logger_level; end
    def kernel_logger_level=(value); end
    def language; end
    def language=(value); end
    def logger; end
    def logger=(value); end
    def lookup; end
    def lookup=(value); end

    # source://geocoder//lib/geocoder/configuration.rb#76
    def set_defaults; end

    def timeout; end
    def timeout=(value); end
    def units; end
    def units=(value); end
    def use_https; end
    def use_https=(value); end

    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://geocoder//lib/geocoder/configuration.rb#53
Geocoder::Configuration::OPTIONS = T.let(T.unsafe(nil), Array)

class Geocoder::ConfigurationError < ::Geocoder::Error; end

class Geocoder::ConfigurationHash < ::Hash
  # source://geocoder//lib/geocoder/configuration_hash.rb#3
  def method_missing(meth, *args, &block); end

  private

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/configuration_hash.rb#7
  def respond_to_missing?(meth, include_private = T.unsafe(nil)); end
end

class Geocoder::Error < ::StandardError; end
class Geocoder::InvalidApiKey < ::Geocoder::Error; end
class Geocoder::InvalidRequest < ::Geocoder::Error; end

class Geocoder::IpAddress < ::String
  # @return [IpAddress] a new instance of IpAddress
  #
  # source://geocoder//lib/geocoder/ip_address.rb#10
  def initialize(ip); end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/ip_address.rb#16
  def internal?; end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/ip_address.rb#20
  def loopback?; end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/ip_address.rb#24
  def private?; end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/ip_address.rb#28
  def valid?; end
end

# source://geocoder//lib/geocoder/ip_address.rb#4
Geocoder::IpAddress::PRIVATE_IPS = T.let(T.unsafe(nil), Array)

class Geocoder::KernelLogger
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # source://geocoder//lib/geocoder/kernel_logger.rb#5
  def add(level, message); end

  private

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/kernel_logger.rb#21
  def log_message_at_level?(level); end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

class Geocoder::Logger
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # source://geocoder//lib/geocoder/logger.rb#20
  def log(level, message); end

  private

  # source://geocoder//lib/geocoder/logger.rb#35
  def current_logger; end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/logger.rb#43
  def valid_level?(level); end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://geocoder//lib/geocoder/logger.rb#12
Geocoder::Logger::SEVERITY = T.let(T.unsafe(nil), Hash)

module Geocoder::Lookup
  extend ::Geocoder::Lookup

  # Array of valid Lookup service names.
  #
  # source://geocoder//lib/geocoder/lookup.rb#10
  def all_services; end

  # Array of valid Lookup service names, excluding :test.
  #
  # source://geocoder//lib/geocoder/lookup.rb#17
  def all_services_except_test; end

  # Array of valid Lookup service names, excluding any that do not build their own HTTP requests.
  # For example, Amazon Location Service uses the AWS gem, not HTTP REST requests, to fetch data.
  #
  # source://geocoder//lib/geocoder/lookup.rb#25
  def all_services_with_http_requests; end

  # Retrieve a Lookup object from the store.
  # Use this instead of Geocoder::Lookup::X.new to get an
  # already-configured Lookup object.
  #
  # source://geocoder//lib/geocoder/lookup.rb#107
  def get(name); end

  # All IP address lookup services, default first.
  #
  # source://geocoder//lib/geocoder/lookup.rb#76
  def ip_services; end

  # Sets the attribute ip_services
  #
  # @param value the value to set the attribute ip_services to.
  #
  # source://geocoder//lib/geocoder/lookup.rb#100
  def ip_services=(_arg0); end

  # All street address lookup services, default first.
  #
  # source://geocoder//lib/geocoder/lookup.rb#32
  def street_services; end

  # Sets the attribute street_services
  #
  # @param value the value to set the attribute street_services to.
  #
  # source://geocoder//lib/geocoder/lookup.rb#100
  def street_services=(_arg0); end

  private

  # Convert an "underscore" version of a name into a "class" version.
  #
  # source://geocoder//lib/geocoder/lookup.rb#133
  def classify_name(filename); end

  # Safely instantiate Lookup
  #
  # source://geocoder//lib/geocoder/lookup.rb#140
  def instantiate_lookup(name); end

  # Spawn a Lookup of the given name.
  #
  # source://geocoder//lib/geocoder/lookup.rb#119
  def spawn(name); end
end

class Geocoder::Lookup::Base
  # @return [Base] a new instance of Base
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#17
  def initialize; end

  # The working Cache object.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#85
  def cache; end

  # Symbol which is used in configuration to refer to this Lookup.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#31
  def handle; end

  # Return the URL for a map of the given coordinates.
  #
  # Not necessarily implemented by all subclasses as only some lookups
  # also provide maps.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#59
  def map_link_url(coordinates); end

  # Human-readable name of the geocoding API.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#24
  def name; end

  # URL to use for querying the geocoding engine.
  #
  # Subclasses should not modify this method. Instead they should define
  # base_query_url and url_query_string. If absolutely necessary to
  # subclss this method, they must also subclass #cache_key.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#78
  def query_url(query); end

  # Array containing string descriptions of keys required by the API.
  # Empty array if keys are optional or not required.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#67
  def required_api_key_parts; end

  # Query the geocoding API and return a Geocoder::Result object.
  # Returns +nil+ on timeout or error.
  #
  # Takes a search string (eg: "Mississippi Coast Coliseumf, Biloxi, MS",
  # "205.128.54.202") for geocoding, or coordinates (latitude, longitude)
  # for reverse geocoding. Returns an array of <tt>Geocoder::Result</tt>s.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#44
  def search(query, options = T.unsafe(nil)); end

  # Array containing the protocols supported by the api.
  # Should be set to [:http] if only HTTP is supported
  # or [:https] if only HTTPS is supported.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#98
  def supported_protocols; end

  private

  # String which, when concatenated with url_query_string(query)
  # produces the full query URL. Should include the "?" a the end.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#108
  def base_query_url(query); end

  # Key to use for caching a geocoding result. Usually this will be the
  # request URL, but in cases where OAuth is used and the nonce,
  # timestamp, etc varies from one request to another, we need to use
  # something else (like the URL before OAuth encoding).
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#161
  def cache_key(query); end

  # source://geocoder//lib/geocoder/lookups/base.rb#165
  def cache_key_params(query); end

  # source://geocoder//lib/geocoder/lookups/base.rb#329
  def check_api_key_configuration!(query); end

  # source://geocoder//lib/geocoder/lookups/base.rb#274
  def check_response_for_errors!(response); end

  # An object with configuration data for this particular lookup.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#115
  def configuration; end

  # source://geocoder//lib/geocoder/lookups/base.rb#327
  def configure_ssl!(client); end

  # Returns a parsed search result (Ruby hash).
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#195
  def fetch_data(query); end

  # Fetch a raw geocoding result (JSON string).
  # The result might or might not be cached.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#244
  def fetch_raw_data(query); end

  # Simulate ActiveSupport's Object#to_query.
  # Removes any keys with nil value.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#343
  def hash_to_query(hash); end

  # Object used to make HTTP requests.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#122
  def http_client; end

  # Make an HTTP(S) request to a geocoding API and
  # return the response object.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#297
  def make_api_request(query); end

  # source://geocoder//lib/geocoder/lookups/base.rb#208
  def parse_json(data); end

  # Parses a raw search result (returns hash or array).
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#224
  def parse_raw_data(raw_data); end

  # Protocol to use for communication with geocoding services.
  # Set in configuration but not available for every service.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#232
  def protocol; end

  # source://geocoder//lib/geocoder/lookups/base.rb#145
  def query_url_params(query); end

  # Raise exception if configuration specifies it should be raised.
  # Return false if exception not raised.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#183
  def raise_error(error, message = T.unsafe(nil)); end

  # Class of the result objects
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#175
  def result_class; end

  # Geocoder::Result object or nil on timeout or other error.
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#141
  def results(query); end

  # source://geocoder//lib/geocoder/lookups/base.rb#149
  def url_query_string(query); end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#317
  def use_ssl?; end

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/lookups/base.rb#236
  def valid_response?(response); end
end

class Geocoder::Lookup::Test < ::Geocoder::Lookup::Base
  # source://geocoder//lib/geocoder/lookups/test.rb#8
  def name; end

  private

  # source://geocoder//lib/geocoder/lookups/test.rb#43
  def results(query); end

  class << self
    # source://geocoder//lib/geocoder/lookups/test.rb#12
    def add_stub(query_text, results); end

    # source://geocoder//lib/geocoder/lookups/test.rb#32
    def delete_stub(query_text); end

    # source://geocoder//lib/geocoder/lookups/test.rb#20
    def read_stub(query_text); end

    # source://geocoder//lib/geocoder/lookups/test.rb#36
    def reset; end

    # source://geocoder//lib/geocoder/lookups/test.rb#16
    def set_default_stub(results); end

    # source://geocoder//lib/geocoder/lookups/test.rb#28
    def stubs; end
  end
end

class Geocoder::LookupTimeout < ::Timeout::Error; end

# Methods for invoking Geocoder in a model.
module Geocoder::Model; end

module Geocoder::Model::ActiveRecord
  include ::Geocoder::Model::Base

  # Set attribute names and include the Geocoder module.
  #
  # source://geocoder//lib/geocoder/models/active_record.rb#11
  def geocoded_by(address_attr, options = T.unsafe(nil), &block); end

  # Set attribute names and include the Geocoder module.
  #
  # source://geocoder//lib/geocoder/models/active_record.rb#29
  def reverse_geocoded_by(latitude_attr, longitude_attr, options = T.unsafe(nil), &block); end

  private

  # source://geocoder//lib/geocoder/models/active_record.rb#47
  def geocoder_file_name; end

  # source://geocoder//lib/geocoder/models/active_record.rb#48
  def geocoder_module_name; end
end

module Geocoder::Model::Base
  # source://geocoder//lib/geocoder/models/base.rb#19
  def geocoded_by; end

  # source://geocoder//lib/geocoder/models/base.rb#9
  def geocoder_options; end

  # source://geocoder//lib/geocoder/models/base.rb#23
  def reverse_geocoded_by; end

  private

  # source://geocoder//lib/geocoder/models/base.rb#29
  def geocoder_init(options); end
end

class Geocoder::NetworkError < ::Geocoder::Error; end
class Geocoder::OverQueryLimitError < ::Geocoder::Error; end

class Geocoder::Query
  # @return [Query] a new instance of Query
  #
  # source://geocoder//lib/geocoder/query.rb#5
  def initialize(text, options = T.unsafe(nil)); end

  # Is the Query blank? (ie, should we not bother searching?)
  # A query is considered blank if its text is nil or empty string AND
  # no URL parameters are specified.
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#52
  def blank?; end

  # Return the latitude/longitude coordinates specified in the query,
  # or nil if none.
  #
  # source://geocoder//lib/geocoder/query.rb#104
  def coordinates; end

  # Does the given string look like latitude/longitude coordinates?
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#93
  def coordinates?; end

  # source://geocoder//lib/geocoder/query.rb#10
  def execute; end

  # Is the Query text a loopback or private IP address?
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#72
  def internal_ip_address?; end

  # Does the Query text look like an IP address?
  #
  # Does not check for actual validity, just the appearance of four
  # dot-delimited numbers.
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#65
  def ip_address?; end

  # source://geocoder//lib/geocoder/query.rb#115
  def language; end

  # Get a Lookup object (which communicates with the remote geocoding API)
  # appropriate to the Query text.
  #
  # source://geocoder//lib/geocoder/query.rb#34
  def lookup; end

  # Is the Query text a loopback IP address?
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#79
  def loopback_ip_address?; end

  # Returns the value of attribute options.
  #
  # source://geocoder//lib/geocoder/query.rb#3
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://geocoder//lib/geocoder/query.rb#3
  def options=(_arg0); end

  # Is the Query text a private IP address?
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#86
  def private_ip_address?; end

  # Should reverse geocoding be performed for this query?
  #
  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#111
  def reverse_geocode?; end

  # source://geocoder//lib/geocoder/query.rb#18
  def sanitized_text; end

  # Returns the value of attribute text.
  #
  # source://geocoder//lib/geocoder/query.rb#3
  def text; end

  # Sets the attribute text
  #
  # @param value the value to set the attribute text to.
  #
  # source://geocoder//lib/geocoder/query.rb#3
  def text=(_arg0); end

  # source://geocoder//lib/geocoder/query.rb#14
  def to_s; end

  # source://geocoder//lib/geocoder/query.rb#43
  def url; end

  private

  # @return [Boolean]
  #
  # source://geocoder//lib/geocoder/query.rb#121
  def params_given?; end
end

class Geocoder::Railtie < ::Rails::Railtie
  class << self
    # source://geocoder//lib/geocoder/railtie.rb#20
    def insert; end
  end
end

module Geocoder::Request
  # source://geocoder//lib/geocoder/request.rb#46
  def geocoder_spoofable_ip; end

  # The location() method is vulnerable to trivial IP spoofing.
  #   Don't use it in authorization/authentication code, or any
  #   other security-sensitive application.  Use safe_location
  #   instead.
  #
  # source://geocoder//lib/geocoder/request.rb#10
  def location; end

  # This safe_location() protects you from trivial IP spoofing.
  #   For requests that go through a proxy that you haven't
  #   whitelisted as trusted in your Rack config, you will get the
  #   location for the IP of the last untrusted proxy in the chain,
  #   not the original client IP.  You WILL NOT get the location
  #   corresponding to the original client IP for any request sent
  #   through a non-whitelisted proxy.
  #
  # source://geocoder//lib/geocoder/request.rb#21
  def safe_location; end

  private

  # source://geocoder//lib/geocoder/request.rb#98
  def geocoder_reject_non_ipv4_addresses(ip_addresses); end

  # use Rack's trusted_proxy?() method to filter out IPs that have
  #   been configured as trusted; includes private ranges by
  #   default.  (we don't want every lookup to return the location
  #   of our own proxy/load balancer)
  #
  # source://geocoder//lib/geocoder/request.rb#79
  def geocoder_reject_trusted_ip_addresses(ip_addresses); end

  # source://geocoder//lib/geocoder/request.rb#83
  def geocoder_remove_port_from_addresses(ip_addresses); end

  # source://geocoder//lib/geocoder/request.rb#71
  def geocoder_split_ip_addresses(ip_addresses); end
end

# There's a whole zoo of nonstandard headers added by various
#   proxy softwares to indicate original client IP.
# ANY of these can be trivially spoofed!
#   (except REMOTE_ADDR, which should by set by your server,
#    and is included at the end as a fallback.
# Order does matter: we're following the convention established in
#   ActionDispatch::RemoteIp::GetIp::calculate_ip()
#   https://github.com/rails/rails/blob/master/actionpack/lib/action_dispatch/middleware/remote_ip.rb
#   where the forwarded_for headers, possibly containing lists,
#   are arbitrarily preferred over headers expected to contain a
#   single address.
#
# source://geocoder//lib/geocoder/request.rb#36
Geocoder::Request::GEOCODER_CANDIDATE_HEADERS = T.let(T.unsafe(nil), Array)

class Geocoder::RequestDenied < ::Geocoder::Error; end

class Geocoder::ResponseParseError < ::Geocoder::Error
  # @return [ResponseParseError] a new instance of ResponseParseError
  #
  # source://geocoder//lib/geocoder/exceptions.rb#17
  def initialize(response); end

  # Returns the value of attribute response.
  #
  # source://geocoder//lib/geocoder/exceptions.rb#15
  def response; end
end

module Geocoder::Result; end

class Geocoder::Result::Base
  # Takes a hash of data from a parsed geocoding service response.
  #
  # @return [Base] a new instance of Base
  #
  # source://geocoder//lib/geocoder/results/base.rb#15
  def initialize(data); end

  # A string in the given format.
  #
  # This default implementation dumbly follows the United States address
  # format and will return incorrect results for most countries. Some APIs
  # return properly formatted addresses and those should be funneled
  # through this method.
  #
  # source://geocoder//lib/geocoder/results/base.rb#28
  def address(format = T.unsafe(nil)); end

  # true if result came from cache, false if from request to geocoding
  # service; nil if cache is not configured
  #
  # source://geocoder//lib/geocoder/results/base.rb#10
  def cache_hit; end

  # true if result came from cache, false if from request to geocoding
  # service; nil if cache is not configured
  #
  # source://geocoder//lib/geocoder/results/base.rb#10
  def cache_hit=(_arg0); end

  # A two-element array: [lat, lon].
  #
  # source://geocoder//lib/geocoder/results/base.rb#42
  def coordinates; end

  # source://geocoder//lib/geocoder/results/base.rb#70
  def country; end

  # source://geocoder//lib/geocoder/results/base.rb#74
  def country_code; end

  # data (hash) fetched from geocoding service
  #
  # source://geocoder//lib/geocoder/results/base.rb#6
  def data; end

  # data (hash) fetched from geocoding service
  #
  # source://geocoder//lib/geocoder/results/base.rb#6
  def data=(_arg0); end

  # source://geocoder//lib/geocoder/results/base.rb#46
  def latitude; end

  # source://geocoder//lib/geocoder/results/base.rb#50
  def longitude; end

  # source://geocoder//lib/geocoder/results/base.rb#58
  def province; end

  # source://geocoder//lib/geocoder/results/base.rb#66
  def province_code; end

  # source://geocoder//lib/geocoder/results/base.rb#54
  def state; end

  # source://geocoder//lib/geocoder/results/base.rb#62
  def state_code; end
end

class Geocoder::Result::Test < ::Geocoder::Result::Base
  # @return [Test] a new instance of Test
  #
  # source://geocoder//lib/geocoder/results/test.rb#24
  def initialize(data); end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def address; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def city; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def coordinates; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def country; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def country_code; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def geometry; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def neighborhood; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def postal_code; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def province; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def province_code; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def route; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def state; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def state_code; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def street_address; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def street_number; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def sub_state; end

  # source://geocoder//lib/geocoder/results/test.rb#13
  def sub_state_code; end

  class << self
    # source://geocoder//lib/geocoder/results/test.rb#7
    def add_result_attribute(attr); end
  end
end

class Geocoder::ServiceUnavailable < ::Geocoder::Error; end

module Geocoder::Util
  class << self
    # Recursive version of Hash#merge!
    #
    # Adds the contents of +h2+ to +h1+,
    # merging entries in +h1+ with duplicate keys with those from +h2+.
    #
    # Compared with Hash#merge!, this method supports nested hashes.
    # When both +h1+ and +h2+ contains an entry with the same key,
    # it merges and returns the values from both hashes.
    #
    #    h1 = {"a" => 100, "b" => 200, "c" => {"c1" => 12, "c2" => 14}}
    #    h2 = {"b" => 254, "c" => {"c1" => 16, "c3" => 94}}
    #    recursive_hash_merge(h1, h2)   #=> {"a" => 100, "b" => 254, "c" => {"c1" => 16, "c2" => 14, "c3" => 94}}
    #
    # Simply using Hash#merge! would return
    #
    #    h1.merge!(h2)    #=> {"a" => 100, "b" = >254, "c" => {"c1" => 16, "c3" => 94}}
    #
    # source://geocoder//lib/geocoder/util.rb#23
    def recursive_hash_merge(h1, h2); end
  end
end
