# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `faraday` gem.
# Please instead update this file by running `bin/tapioca gem faraday`.

# conn.get '/'
module Faraday
  class << self
    # @overload default_adapter
    # @overload default_adapter=
    #
    # source://faraday//lib/faraday.rb#55
    def default_adapter; end

    # Documented elsewhere, see default_adapter reader
    #
    # source://faraday//lib/faraday.rb#102
    def default_adapter=(adapter); end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    #
    # source://faraday//lib/faraday.rb#59
    def default_adapter_options; end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    #
    # source://faraday//lib/faraday.rb#59
    def default_adapter_options=(_arg0); end

    # @overload default_connection
    # @overload default_connection=
    #
    # source://faraday//lib/faraday.rb#120
    def default_connection; end

    # Documented below, see default_connection
    #
    # source://faraday//lib/faraday.rb#62
    def default_connection=(_arg0); end

    # Gets the default connection options used when calling {Faraday#new}.
    #
    # @return [Faraday::ConnectionOptions]
    #
    # source://faraday//lib/faraday.rb#127
    def default_connection_options; end

    # Sets the default options used when calling {Faraday#new}.
    #
    # @param options [Hash, Faraday::ConnectionOptions]
    #
    # source://faraday//lib/faraday.rb#134
    def default_connection_options=(options); end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    #
    # source://faraday//lib/faraday.rb#67
    def ignore_env_proxy; end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    #
    # source://faraday//lib/faraday.rb#67
    def ignore_env_proxy=(_arg0); end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    #
    # source://faraday//lib/faraday.rb#46
    def lib_path; end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    #
    # source://faraday//lib/faraday.rb#46
    def lib_path=(_arg0); end

    # Initializes a new {Connection}.
    #
    # @example With an URL argument
    #   Faraday.new 'http://faraday.com'
    #   # => Faraday::Connection to http://faraday.com
    # @example With an URL argument and an options hash
    #   Faraday.new 'http://faraday.com', params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @example With everything in an options hash
    #   Faraday.new url: 'http://faraday.com',
    #   params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @param url [String, Hash] The optional String base URL to use as a prefix
    #   for all requests.  Can also be the options Hash. Any of these
    #   values will be set on every request made, unless overridden
    #   for a specific request.
    # @param options [Hash]
    # @return [Faraday::Connection]
    #
    # source://faraday//lib/faraday.rb#96
    def new(url = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # @return [Boolean]
    #
    # source://faraday//lib/faraday.rb#107
    def respond_to_missing?(symbol, include_private = T.unsafe(nil)); end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    #
    # source://faraday//lib/faraday.rb#42
    def root_path; end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    #
    # source://faraday//lib/faraday.rb#42
    def root_path=(_arg0); end

    private

    # Internal: Proxies method calls on the Faraday constant to
    # .default_connection.
    #
    # source://faraday//lib/faraday.rb#143
    def method_missing(name, *args, &block); end
  end
end

# Base class for all Faraday adapters. Adapters are
# responsible for fulfilling a Faraday request.
class Faraday::Adapter
  extend ::Faraday::MiddlewareRegistry
  extend ::Faraday::Adapter::Parallelism

  # @return [Adapter] a new instance of Adapter
  #
  # source://faraday//lib/faraday/adapter.rb#28
  def initialize(_app = T.unsafe(nil), opts = T.unsafe(nil), &block); end

  # source://faraday//lib/faraday/adapter.rb#55
  def call(env); end

  # Close any persistent connections. The adapter should still be usable
  # after calling close.
  #
  # source://faraday//lib/faraday/adapter.rb#50
  def close; end

  # Yields or returns an adapter's configured connection. Depends on
  # #build_connection being defined on this adapter.
  #
  # @param env [Faraday::Env, Hash] The env object for a faraday request.
  # @return The return value of the given block, or the HTTP connection object
  #   if no block is given.
  # @yield [conn]
  #
  # source://faraday//lib/faraday/adapter.rb#41
  def connection(env); end

  private

  # Fetches either a read, write, or open timeout setting. Defaults to the
  # :timeout value if a more specific one is not given.
  #
  # @param type [Symbol] Describes which timeout setting to get: :read,
  #   :write, or :open.
  # @param options [Hash] Hash containing Symbol keys like :timeout,
  #   :read_timeout, :write_timeout, or :open_timeout
  # @return [Integer, nil] Timeout duration in seconds, or nil if no timeout
  #   has been set.
  #
  # source://faraday//lib/faraday/adapter.rb#85
  def request_timeout(type, options); end

  # source://faraday//lib/faraday/adapter.rb#62
  def save_response(env, status, body, headers = T.unsafe(nil), reason_phrase = T.unsafe(nil), finished: T.unsafe(nil)); end
end

# source://faraday//lib/faraday/adapter.rb#9
Faraday::Adapter::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# This module marks an Adapter as supporting parallel requests.
module Faraday::Adapter::Parallelism
  # source://faraday//lib/faraday/adapter.rb#19
  def inherited(subclass); end

  # Sets the attribute supports_parallel
  #
  # @param value the value to set the attribute supports_parallel to.
  #
  # source://faraday//lib/faraday/adapter.rb#13
  def supports_parallel=(_arg0); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter.rb#15
  def supports_parallel?; end
end

# source://faraday//lib/faraday/adapter.rb#93
Faraday::Adapter::TIMEOUT_KEYS = T.let(T.unsafe(nil), Hash)

# @example
#   test = Faraday::Connection.new do
#   use Faraday::Adapter::Test do |stub|
#   # Define matcher to match the request
#   stub.get '/resource.json' do
#   # return static content
#   [200, {'Content-Type' => 'application/json'}, 'hi world']
#   end
#
#   # response with content generated based on request
#   stub.get '/showget' do |env|
#   [200, {'Content-Type' => 'text/plain'}, env[:method].to_s]
#   end
#
#   # A regular expression can be used as matching filter
#   stub.get /\A\/items\/(\d+)\z/ do |env, meta|
#   # in case regular expression is used, an instance of MatchData
#   # can be received
#   [200,
#   {'Content-Type' => 'text/plain'},
#   "showing item: #{meta[:match_data][1]}"
#   ]
#   end
#
#   # Test the request body is the same as the stubbed body
#   stub.post('/bar', 'name=YK&word=call') { [200, {}, ''] }
#
#   # You can pass a proc as a stubbed body and check the request body in your way.
#   # In this case, the proc should return true or false.
#   stub.post('/foo', ->(request_body) do
#   JSON.parse(request_body).slice('name') == { 'name' => 'YK' } }) { [200, {}, '']
#   end
#
#   # You can set strict_mode to exactly match the stubbed requests.
#   stub.strict_mode = true
#   end
#   end
#
#   resp = test.get '/resource.json'
#   resp.body # => 'hi world'
#
#   resp = test.get '/showget'
#   resp.body # => 'get'
#
#   resp = test.get '/items/1'
#   resp.body # => 'showing item: 1'
#
#   resp = test.get '/items/2'
#   resp.body # => 'showing item: 2'
#
#   resp = test.post '/bar', 'name=YK&word=call'
#   resp.status # => 200
#
#   resp = test.post '/foo', JSON.dump(name: 'YK', created_at: Time.now)
#   resp.status # => 200
class Faraday::Adapter::Test < ::Faraday::Adapter
  # @return [Test] a new instance of Test
  #
  # source://faraday//lib/faraday/adapter/test.rb#258
  def initialize(app, stubs = T.unsafe(nil), &block); end

  # @param env [Faraday::Env]
  #
  # source://faraday//lib/faraday/adapter/test.rb#269
  def call(env); end

  # @yield [stubs]
  #
  # source://faraday//lib/faraday/adapter/test.rb#264
  def configure; end

  # Returns the value of attribute stubs.
  #
  # source://faraday//lib/faraday/adapter/test.rb#63
  def stubs; end

  # Sets the attribute stubs
  #
  # @param value the value to set the attribute stubs to.
  #
  # source://faraday//lib/faraday/adapter/test.rb#63
  def stubs=(_arg0); end
end

# Stub request
class Faraday::Adapter::Test::Stub < ::Struct
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#242
  def body_match?(request_body); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#227
  def headers_match?(request_headers); end

  # @param env [Faraday::Env]
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#189
  def matches?(env); end

  # @param env [Faraday::Env]
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#214
  def params_match?(env); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#205
  def path_match?(request_path, meta); end

  # source://faraday//lib/faraday/adapter/test.rb#253
  def to_s; end
end

# A stack of Stubs
class Faraday::Adapter::Test::Stubs
  # @return [Stubs] a new instance of Stubs
  # @yield [_self]
  # @yieldparam _self [Faraday::Adapter::Test::Stubs] the object that the method was called on
  #
  # source://faraday//lib/faraday/adapter/test.rb#70
  def initialize(strict_mode: T.unsafe(nil)); end

  # source://faraday//lib/faraday/adapter/test.rb#122
  def delete(path, headers = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#79
  def empty?; end

  # source://faraday//lib/faraday/adapter/test.rb#102
  def get(path, headers = T.unsafe(nil), &block); end

  # source://faraday//lib/faraday/adapter/test.rb#106
  def head(path, headers = T.unsafe(nil), &block); end

  # @param env [Faraday::Env]
  #
  # source://faraday//lib/faraday/adapter/test.rb#84
  def match(env); end

  # source://faraday//lib/faraday/adapter/test.rb#126
  def options(path, headers = T.unsafe(nil), &block); end

  # source://faraday//lib/faraday/adapter/test.rb#118
  def patch(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # source://faraday//lib/faraday/adapter/test.rb#110
  def post(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # source://faraday//lib/faraday/adapter/test.rb#114
  def put(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # Set strict_mode. If the value is true, this adapter tries to find matched requests strictly,
  # which means that all of a path, parameters, and headers must be the same as an actual request.
  #
  # source://faraday//lib/faraday/adapter/test.rb#147
  def strict_mode=(value); end

  # Raises an error if any of the stubbed calls have not been made.
  #
  # source://faraday//lib/faraday/adapter/test.rb#131
  def verify_stubbed_calls; end

  protected

  # @param stack [Hash]
  # @param env [Faraday::Env]
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/adapter/test.rb#177
  def matches?(stack, env); end

  # source://faraday//lib/faraday/adapter/test.rb#158
  def new_stub(request_method, path, headers = T.unsafe(nil), body = T.unsafe(nil), &block); end
end

class Faraday::Adapter::Test::Stubs::NotFound < ::StandardError; end

# AdapterRegistry registers adapter class names so they can be looked up by a
# String or Symbol name.
class Faraday::AdapterRegistry
  # @return [AdapterRegistry] a new instance of AdapterRegistry
  #
  # source://faraday//lib/faraday/adapter_registry.rb#9
  def initialize; end

  # source://faraday//lib/faraday/adapter_registry.rb#14
  def get(name); end

  # source://faraday//lib/faraday/adapter_registry.rb#23
  def set(klass, name = T.unsafe(nil)); end
end

# Raised by Faraday::Response::RaiseError in case of a 400 response.
class Faraday::BadRequestError < ::Faraday::ClientError; end

# source://faraday//lib/faraday.rb#34
Faraday::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# Faraday client error class. Represents 4xx status responses.
class Faraday::ClientError < ::Faraday::Error; end

# Raised by Faraday::Response::RaiseError in case of a 409 response.
class Faraday::ConflictError < ::Faraday::ClientError; end

# Connection objects manage the default properties and the middleware
# stack for fulfilling an HTTP request.
#
# @example
#
#   conn = Faraday::Connection.new 'http://httpbingo.org'
#
#   # GET http://httpbingo.org/nigiri
#   conn.get 'nigiri'
#   # => #<Faraday::Response>
class Faraday::Connection
  extend ::Forwardable

  # Initializes a new Faraday::Connection.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param url [URI, String] URI or String base URL to use as a prefix for all
  #   requests (optional).
  # @param options [Hash, Faraday::ConnectionOptions]
  # @return [Connection] a new instance of Connection
  # @yield [self] after all setup has been done
  #
  # source://faraday//lib/faraday/connection.rb#63
  def initialize(url = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def adapter(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def app(*args, **_arg1, &block); end

  # Build an absolute URL based on url_prefix.
  #
  #          of the resulting url (default: nil).
  #
  # @param url [String, URI, nil]
  # @param params [Faraday::Utils::ParamsHash] A Faraday::Utils::ParamsHash to
  #   replace the query values
  # @return [URI]
  #
  # source://faraday//lib/faraday/connection.rb#471
  def build_exclusive_url(url = T.unsafe(nil), params = T.unsafe(nil), params_encoder = T.unsafe(nil)); end

  # Creates and configures the request object.
  #
  # @param method [Symbol]
  # @return [Faraday::Request]
  # @yield [Faraday::Request] if block given
  #
  # source://faraday//lib/faraday/connection.rb#454
  def build_request(method); end

  # Takes a relative url for a request and combines it with the defaults
  # set on the connection instance.
  #
  # @example
  #   conn = Faraday::Connection.new { ... }
  #   conn.url_prefix = "https://httpbingo.org/api?token=abc"
  #   conn.scheme      # => https
  #   conn.path_prefix # => "/api"
  #
  #   conn.build_url("nigiri?page=2")
  #   # => https://httpbingo.org/api/nigiri?token=abc&page=2
  #
  #   conn.build_url("nigiri", page: 2)
  #   # => https://httpbingo.org/api/nigiri?token=abc&page=2
  # @param url [String, URI, nil]
  # @param extra_params [Hash]
  #
  # source://faraday//lib/faraday/connection.rb#408
  def build_url(url = T.unsafe(nil), extra_params = T.unsafe(nil)); end

  # @return [Faraday::RackBuilder] Builder for this Connection.
  #
  # source://faraday//lib/faraday/connection.rb#31
  def builder; end

  # Closes the underlying resources and/or connections. In the case of
  # persistent connections, this closes all currently open connections
  # but does not prevent new connections from being made.
  #
  # source://faraday//lib/faraday/connection.rb#125
  def close; end

  # Check if the adapter is parallel-capable.
  #
  # @api private
  # @return [Object, nil] a parallel manager or nil if yielded
  # @yield if the adapter isn't parallel-capable, or if no adapter is set yet.
  #
  # source://faraday//lib/faraday/connection.rb#292
  def default_parallel_manager; end

  # Sets the default parallel manager for this connection.
  #
  # source://faraday//lib/faraday/connection.rb#40
  def default_parallel_manager=(_arg0); end

  # source://faraday//lib/faraday/connection.rb#199
  def delete(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # Creates a duplicate of this Faraday::Connection.
  #
  # @api private
  # @return [Faraday::Connection]
  #
  # source://faraday//lib/faraday/connection.rb#491
  def dup; end

  # source://faraday//lib/faraday/connection.rb#539
  def find_default_proxy; end

  # source://faraday//lib/faraday/connection.rb#199
  def get(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # source://faraday//lib/faraday/connection.rb#199
  def head(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # @return [Hash] unencoded HTTP header key/value pairs.
  #
  # source://faraday//lib/faraday/connection.rb#24
  def headers; end

  # Sets the Hash of unencoded HTTP header key/value pairs.
  #
  # @param hash [Hash]
  #
  # source://faraday//lib/faraday/connection.rb#114
  def headers=(hash); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def host=(*args, **_arg1, &block); end

  # Sets up the parallel manager to make a set of requests.
  #
  # @param manager [Object] The parallel manager that this Connection's
  #   Adapter uses.
  # @return [void]
  # @yield a block to execute multiple requests.
  #
  # source://faraday//lib/faraday/connection.rb#318
  def in_parallel(manager = T.unsafe(nil)); end

  # Determine if this Faraday::Connection can make parallel requests.
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/connection.rb#307
  def in_parallel?; end

  # source://faraday//lib/faraday/connection.rb#96
  def initialize_proxy(url, options); end

  # @example
  #   conn.options '/items/1'
  # @overload options
  # @overload options
  # @return [Faraday::Response]
  # @yield [Faraday::Request] for further request customizations
  #
  # source://faraday//lib/faraday/connection.rb#222
  def options(*args); end

  # @return [Object] the parallel manager for this Connection.
  #
  # source://faraday//lib/faraday/connection.rb#37
  def parallel_manager; end

  # @return [Hash] URI query unencoded key/value pairs.
  #
  # source://faraday//lib/faraday/connection.rb#21
  def params; end

  # Sets the Hash of URI query unencoded key/value pairs.
  #
  # @param hash [Hash]
  #
  # source://faraday//lib/faraday/connection.rb#108
  def params=(hash); end

  # source://faraday//lib/faraday/connection.rb#280
  def patch(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def path_prefix(*args, **_arg1, &block); end

  # Sets the path prefix and ensures that it always has a leading
  # slash.
  #
  # @param value [String]
  # @return [String] the new path prefix
  #
  # source://faraday//lib/faraday/connection.rb#383
  def path_prefix=(value); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def port(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def port=(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/connection.rb#280
  def post(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # @return [Hash] proxy options.
  #
  # source://faraday//lib/faraday/connection.rb#43
  def proxy; end

  # Sets the Hash proxy options.
  #
  # @param new_value [Object]
  #
  # source://faraday//lib/faraday/connection.rb#334
  def proxy=(new_value); end

  # source://faraday//lib/faraday/connection.rb#547
  def proxy_for_request(url); end

  # source://faraday//lib/faraday/connection.rb#514
  def proxy_from_env(url); end

  # source://faraday//lib/faraday/connection.rb#280
  def put(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def request(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def response(*args, **_arg1, &block); end

  # Builds and runs the Faraday::Request.
  #
  # @param method [Symbol] HTTP method.
  # @param url [String, URI, nil] String or URI to access.
  # @param body [String, nil] The request body that will eventually be converted to
  #   a string.
  # @param headers [Hash, nil] unencoded HTTP header key/value pairs.
  # @return [Faraday::Response]
  #
  # source://faraday//lib/faraday/connection.rb#432
  def run_request(method, url, body, headers); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def scheme(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def scheme=(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/connection.rb#372
  def set_basic_auth(user, password); end

  # @return [Hash] SSL options.
  #
  # source://faraday//lib/faraday/connection.rb#34
  def ssl; end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/connection.rb#557
  def support_parallel?(adapter); end

  # source://faraday//lib/faraday/connection.rb#199
  def trace(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # @return [String] a URI with the prefix used for all requests from this
  #   Connection. This includes a default host name, scheme, port, and path.
  #
  # source://faraday//lib/faraday/connection.rb#28
  def url_prefix; end

  # Parses the given URL with URI and stores the individual
  # components in this connection. These components serve as defaults for
  # requests made by this connection.
  #
  # @example
  #
  #   conn = Faraday::Connection.new { ... }
  #   conn.url_prefix = "https://httpbingo.org/api"
  #   conn.scheme      # => https
  #   conn.path_prefix # => "/api"
  #
  #   conn.get("nigiri?page=2") # accesses https://httpbingo.org/api/nigiri
  # @param url [String, URI]
  # @param encoder [Object]
  #
  # source://faraday//lib/faraday/connection.rb#357
  def url_prefix=(url, encoder = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def use(*args, **_arg1, &block); end

  # Yields username and password extracted from a URI if they both exist.
  #
  # @api private
  # @param uri [URI]
  # @return [void]
  # @yield [username, password] any username and password
  # @yieldparam username [String] any username from URI
  # @yieldparam password [String] any password from URI
  #
  # source://faraday//lib/faraday/connection.rb#508
  def with_uri_credentials(uri); end
end

# A Set of allowed HTTP verbs.
#
# source://faraday//lib/faraday/connection.rb#17
Faraday::Connection::METHODS = T.let(T.unsafe(nil), Set)

# source://faraday//lib/faraday/connection.rb#18
Faraday::Connection::USER_AGENT = T.let(T.unsafe(nil), String)

# A unified error for failed connections.
class Faraday::ConnectionFailed < ::Faraday::Error; end

# ConnectionOptions contains the configurable properties for a Faraday
# connection object.
class Faraday::ConnectionOptions < ::Faraday::Options
  # source://faraday//lib/faraday/options.rb#177
  def builder_class; end

  # source://faraday//lib/faraday/options/connection_options.rb#18
  def new_builder(block); end

  # source://faraday//lib/faraday/options.rb#177
  def request; end

  # source://faraday//lib/faraday/options.rb#177
  def ssl; end
end

# Sub-module for decoding query-string into parameters.
module Faraday::DecodeMethods
  # @param query [nil, String]
  # @raise [TypeError] if the nesting is incorrect
  # @return [Array<Array, String>] the decoded params
  #
  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#87
  def decode(query); end

  protected

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#144
  def add_to_context(is_array, context, value, subkey); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#107
  def decode_pair(key, value, context); end

  # Internal: convert a nested hash with purely numeric keys into an array.
  # FIXME: this is not compatible with Rack::Utils.parse_nested_query
  #
  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#151
  def dehash(hash, depth); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#139
  def match_context(context, subkey); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#129
  def new_context(subkey, is_array, context); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#119
  def prepare_context(context, subkey, is_array, last_subkey); end
end

# source://faraday//lib/faraday/encoders/nested_params_encoder.rb#105
Faraday::DecodeMethods::SUBKEYS_REGEX = T.let(T.unsafe(nil), Regexp)

# Sub-module for encoding parameters into query-string.
module Faraday::EncodeMethods
  # @param params [nil, Array, #to_hash] parameters to be encoded
  # @raise [TypeError] if params can not be converted to a Hash
  # @return [String] the encoded params
  #
  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#11
  def encode(params); end

  protected

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#64
  def encode_array(parent, value); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#53
  def encode_hash(parent, value); end

  # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#40
  def encode_pair(parent, value); end
end

class Faraday::Env < ::Faraday::Options
  extend ::Forwardable

  # @param key [Object]
  #
  # source://faraday//lib/faraday/options/env.rb#84
  def [](key); end

  # @param key [Object]
  # @param value [Object]
  #
  # source://faraday//lib/faraday/options/env.rb#96
  def []=(key, value); end

  # string.
  #
  # @return [String] The request body that will eventually be converted to a
  #
  # source://faraday//lib/faraday/options/env.rb#113
  def body; end

  # string.
  #
  # @return [String] The request body that will eventually be converted to a
  #
  # source://faraday//lib/faraday/options/env.rb#117
  def body=(value); end

  # Sets content length to zero and the body to the empty string.
  #
  # source://faraday//lib/faraday/options/env.rb#133
  def clear_body; end

  # source://faraday//lib/faraday/options/env.rb#109
  def current_body; end

  # @private
  #
  # source://faraday//lib/faraday/options/env.rb#179
  def custom_members; end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options/env.rb#185
  def in_member_set?(key); end

  # source://faraday//lib/faraday/options/env.rb#149
  def inspect; end

  # set of {MethodsWithBodies}.
  #
  # @return [Boolean] true if there's no body yet, and the method is in the
  #
  # source://faraday//lib/faraday/options/env.rb#128
  def needs_body?; end

  # @return [Boolean] true if there is a parallel_manager
  #
  # source://faraday//lib/faraday/options/env.rb#145
  def parallel?; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def params_encoder(*args, **_arg1, &block); end

  # {StatusesWithoutBody}.
  #
  # @return [Boolean] true if the status isn't in the set of
  #
  # source://faraday//lib/faraday/options/env.rb#140
  def parse_body?; end

  # source://faraday//lib/faraday/options/env.rb#164
  def stream_response(&block); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options/env.rb#160
  def stream_response?; end

  # @return [Boolean] true if status is in the set of {SuccessfulStatuses}.
  #
  # source://faraday//lib/faraday/options/env.rb#122
  def success?; end

  class << self
    # Build a new Env from given value. Respects and updates `custom_members`.
    #
    # @param value [Object] a value fitting Option.from(v).
    # @return [Env] from given value
    #
    # source://faraday//lib/faraday/options/env.rb#75
    def from(value); end

    # @private
    #
    # source://faraday//lib/faraday/options/env.rb#195
    def member_set; end
  end
end

# source://faraday//lib/faraday/options/env.rb#55
Faraday::Env::ContentLength = T.let(T.unsafe(nil), String)

# A Set of HTTP verbs that typically send a body.  If no body is set for
# these requests, the Content-Length header is set to 0.
#
# source://faraday//lib/faraday/options/env.rb#62
Faraday::Env::MethodsWithBodies = T.let(T.unsafe(nil), Set)

# source://faraday//lib/faraday/options/env.rb#56
Faraday::Env::StatusesWithoutBody = T.let(T.unsafe(nil), Set)

# source://faraday//lib/faraday/options/env.rb#57
Faraday::Env::SuccessfulStatuses = T.let(T.unsafe(nil), Range)

# Faraday error base class.
class Faraday::Error < ::StandardError
  # @return [Error] a new instance of Error
  #
  # source://faraday//lib/faraday/error.rb#9
  def initialize(exc = T.unsafe(nil), response = T.unsafe(nil)); end

  # source://faraday//lib/faraday/error.rb#15
  def backtrace; end

  # source://faraday//lib/faraday/error.rb#23
  def inspect; end

  # Returns the value of attribute response.
  #
  # source://faraday//lib/faraday/error.rb#7
  def response; end

  # source://faraday//lib/faraday/error.rb#39
  def response_body; end

  # source://faraday//lib/faraday/error.rb#35
  def response_headers; end

  # source://faraday//lib/faraday/error.rb#31
  def response_status; end

  # Returns the value of attribute wrapped_exception.
  #
  # source://faraday//lib/faraday/error.rb#7
  def wrapped_exception; end

  protected

  # Pulls out potential parent exception and response hash.
  #
  # source://faraday//lib/faraday/error.rb#75
  def exc_msg_and_response(exc, response = T.unsafe(nil)); end

  # Pulls out potential parent exception and response hash, storing them in
  # instance variables.
  # exc      - Either an Exception, a string message, or a response hash.
  # response - Hash
  #              :status  - Optional integer HTTP response status
  #              :headers - String key/value hash of HTTP response header
  #                         values.
  #              :body    - Optional string HTTP response body.
  #              :request - Hash
  #                           :method   - Symbol with the request HTTP method.
  #                           :url      - URI object with the url requested.
  #                           :url_path - String with the url path requested.
  #                           :params   - String key/value hash of query params
  #                                     present in the request.
  #                           :headers  - String key/value hash of HTTP request
  #                                     header values.
  #                           :body     - String HTTP request body.
  #
  # If a subclass has to call this, then it should pass a string message
  # to `super`. See NilStatusError.
  #
  # source://faraday//lib/faraday/error.rb#65
  def exc_msg_and_response!(exc, response = T.unsafe(nil)); end
end

# FlatParamsEncoder manages URI params as a flat hash. Any Array values repeat
# the parameter multiple times.
module Faraday::FlatParamsEncoder
  class << self
    # Decode converts the given URI querystring into a hash.
    #
    # @example
    #
    #   decode('a=one&a=two&a=three&b=true&c=C')
    #   # => {"a"=>["one", "two", "three"], "b"=>"true", "c"=>"C"}
    # @param query [String] query arguments to parse.
    # @return [Hash] parsed keys and value strings from the querystring.
    #
    # source://faraday//lib/faraday/encoders/flat_params_encoder.rb#74
    def decode(query); end

    # Encode converts the given param into a URI querystring. Keys and values
    # will converted to strings and appropriately escaped for the URI.
    #
    # @example
    #
    #   encode({a: %w[one two three], b: true, c: "C"})
    #   # => 'a=one&a=two&a=three&b=true&c=C'
    # @param params [Hash] query arguments to convert.
    # @return [String] the URI querystring (without the leading '?')
    #
    # source://faraday//lib/faraday/encoders/flat_params_encoder.rb#23
    def encode(params); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def escape(*args, **_arg1, &block); end

    # Returns the value of attribute sort_params.
    #
    # source://faraday//lib/faraday/encoders/flat_params_encoder.rb#99
    def sort_params; end

    # Sets the attribute sort_params
    #
    # @param value the value to set the attribute sort_params to.
    #
    # source://faraday//lib/faraday/encoders/flat_params_encoder.rb#99
    def sort_params=(_arg0); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def unescape(*args, **_arg1, &block); end
  end
end

# Raised by Faraday::Response::RaiseError in case of a 403 response.
class Faraday::ForbiddenError < ::Faraday::ClientError; end

module Faraday::Logging; end

# Serves as an integration point to customize logging
class Faraday::Logging::Formatter
  extend ::Forwardable

  # @return [Formatter] a new instance of Formatter
  #
  # source://faraday//lib/faraday/logging/formatter.rb#14
  def initialize(logger:, options:); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def debug(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def error(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/logging/formatter.rb#40
  def exception(exc); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def fatal(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/logging/formatter.rb#52
  def filter(filter_word, filter_replacement); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def info(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/logging/formatter.rb#22
  def request(env); end

  # source://faraday//lib/faraday/logging/formatter.rb#32
  def response(env); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def warn(*args, **_arg1, &block); end

  private

  # source://faraday//lib/faraday/logging/formatter.rb#96
  def apply_filters(output); end

  # source://faraday//lib/faraday/logging/formatter.rb#62
  def dump_body(body); end

  # source://faraday//lib/faraday/logging/formatter.rb#58
  def dump_headers(headers); end

  # source://faraday//lib/faraday/logging/formatter.rb#116
  def log_body(type, body); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/logging/formatter.rb#83
  def log_body?(type); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/logging/formatter.rb#92
  def log_errors?; end

  # source://faraday//lib/faraday/logging/formatter.rb#111
  def log_headers(type, headers); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/logging/formatter.rb#74
  def log_headers?(type); end

  # source://faraday//lib/faraday/logging/formatter.rb#103
  def log_level; end

  # source://faraday//lib/faraday/logging/formatter.rb#70
  def pretty_inspect(body); end
end

# source://faraday//lib/faraday/logging/formatter.rb#11
Faraday::Logging::Formatter::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://faraday//lib/faraday/methods.rb#5
Faraday::METHODS_WITH_BODY = T.let(T.unsafe(nil), Array)

# source://faraday//lib/faraday/methods.rb#4
Faraday::METHODS_WITH_QUERY = T.let(T.unsafe(nil), Array)

# Middleware is the basic base class of any Faraday middleware.
class Faraday::Middleware
  extend ::Faraday::MiddlewareRegistry

  # @return [Middleware] a new instance of Middleware
  #
  # source://faraday//lib/faraday/middleware.rb#10
  def initialize(app = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute app.
  #
  # source://faraday//lib/faraday/middleware.rb#8
  def app; end

  # source://faraday//lib/faraday/middleware.rb#15
  def call(env); end

  # source://faraday//lib/faraday/middleware.rb#25
  def close; end

  # Returns the value of attribute options.
  #
  # source://faraday//lib/faraday/middleware.rb#8
  def options; end
end

# Adds the ability for other modules to register and lookup
# middleware classes.
module Faraday::MiddlewareRegistry
  # Lookup middleware class with a registered Symbol shortcut.
  #
  # @example
  #
  #   module Faraday
  #   class Whatever < Middleware
  #   register_middleware(foo: Whatever)
  #   end
  #   end
  #
  #   Faraday::Middleware.lookup_middleware(:foo)
  #   # => Faraday::Whatever
  # @param key [Symbol] key for the registered middleware.
  # @raise [Faraday::Error] if given key is not registered
  # @return [Class] a middleware Class.
  #
  # source://faraday//lib/faraday/middleware_registry.rb#55
  def lookup_middleware(key); end

  # Register middleware class(es) on the current module.
  #
  # @example Lookup by a constant
  #
  #   module Faraday
  #   class Whatever < Middleware
  #   # Middleware looked up by :foo returns Faraday::Whatever::Foo.
  #   register_middleware(foo: Whatever)
  #   end
  #   end
  # @param mappings [Hash] Middleware mappings from a lookup symbol to a middleware class.
  # @return [void]
  #
  # source://faraday//lib/faraday/middleware_registry.rb#26
  def register_middleware(**mappings); end

  # source://faraday//lib/faraday/middleware_registry.rb#9
  def registered_middleware; end

  # Unregister a previously registered middleware class.
  #
  # @param key [Symbol] key for the registered middleware.
  #
  # source://faraday//lib/faraday/middleware_registry.rb#35
  def unregister_middleware(key); end

  private

  # source://faraday//lib/faraday/middleware_registry.rb#67
  def load_middleware(key); end

  # source://faraday//lib/faraday/middleware_registry.rb#62
  def middleware_mutex(&block); end
end

# This is the default encoder for Faraday requests.
# Using this encoder, parameters will be encoded respecting their structure,
# so you can send objects such as Arrays or Hashes as parameters
# for your requests.
module Faraday::NestedParamsEncoder
  extend ::Faraday::EncodeMethods
  extend ::Faraday::DecodeMethods

  class << self
    # Returns the value of attribute array_indices.
    #
    # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#170
    def array_indices; end

    # Sets the attribute array_indices
    #
    # @param value the value to set the attribute array_indices to.
    #
    # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#170
    def array_indices=(_arg0); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def escape(*args, **_arg1, &block); end

    # Returns the value of attribute sort_params.
    #
    # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#170
    def sort_params; end

    # Sets the attribute sort_params
    #
    # @param value the value to set the attribute sort_params to.
    #
    # source://faraday//lib/faraday/encoders/nested_params_encoder.rb#170
    def sort_params=(_arg0); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def unescape(*args, **_arg1, &block); end
  end
end

module Faraday::NetHttp; end

# source://faraday-net_http/3.0.2/lib/faraday/net_http/version.rb#5
Faraday::NetHttp::VERSION = T.let(T.unsafe(nil), String)

# Raised by Faraday::Response::RaiseError in case of a nil status in response.
class Faraday::NilStatusError < ::Faraday::ServerError
  # @return [NilStatusError] a new instance of NilStatusError
  #
  # source://faraday//lib/faraday/error.rb#130
  def initialize(exc, response = T.unsafe(nil)); end
end

# Subclasses Struct with some special helpers for converting from a Hash to
# a Struct.
class Faraday::Options < ::Struct
  # source://faraday//lib/faraday/options.rb#185
  def [](key); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#46
  def clear; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#71
  def deep_dup; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#39
  def delete(key); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#13
  def each; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#106
  def each_key(&block); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#120
  def each_value(&block); end

  # Public
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options.rb#101
  def empty?; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#76
  def fetch(key, *args); end

  # Public
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options.rb#113
  def has_key?(key); end

  # Public
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options.rb#127
  def has_value?(value); end

  # Internal
  #
  # source://faraday//lib/faraday/options.rb#144
  def inspect; end

  # Public
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options.rb#113
  def key?(key); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#96
  def keys; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#66
  def merge(other); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#51
  def merge!(other); end

  # source://faraday//lib/faraday/options.rb#194
  def symbolized_key_set; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#134
  def to_hash; end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#22
  def update(obj); end

  # Public
  #
  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options.rb#127
  def value?(value); end

  # Public
  #
  # source://faraday//lib/faraday/options.rb#91
  def values_at(*keys); end

  class << self
    # Internal
    #
    # source://faraday//lib/faraday/options.rb#166
    def attribute_options; end

    # source://faraday//lib/faraday/options.rb#204
    def fetch_error_class; end

    # Public
    #
    # source://faraday//lib/faraday/options.rb#8
    def from(value); end

    # @private
    #
    # source://faraday//lib/faraday/options.rb#198
    def inherited(subclass); end

    # source://faraday//lib/faraday/options.rb#170
    def memoized(key, &block); end

    # source://faraday//lib/faraday/options.rb#181
    def memoized_attributes; end

    # Internal
    #
    # source://faraday//lib/faraday/options.rb#156
    def options(mapping); end

    # Internal
    #
    # source://faraday//lib/faraday/options.rb#161
    def options_for(key); end
  end
end

# Raised by middlewares that parse the response, like the JSON response middleware.
class Faraday::ParsingError < ::Faraday::Error; end

# Raised by Faraday::Response::RaiseError in case of a 407 response.
class Faraday::ProxyAuthError < ::Faraday::ClientError; end

# ProxyOptions contains the configurable properties for the proxy
# configuration used when making an HTTP request.
class Faraday::ProxyOptions < ::Faraday::Options
  extend ::Forwardable

  # source://forwardable/1.3.2/forwardable.rb#229
  def host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def host=(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/options.rb#177
  def password; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def path(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def path=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def port(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def port=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def scheme(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def scheme=(*args, **_arg1, &block); end

  # source://faraday//lib/faraday/options.rb#177
  def user; end

  class << self
    # source://faraday//lib/faraday/options/proxy_options.rb#11
    def from(value); end
  end
end

# A Builder that processes requests into responses by passing through an inner
# middleware stack (heavily inspired by Rack).
#
# @example
#   Faraday::Connection.new(url: 'http://httpbingo.org') do |builder|
#   builder.request  :url_encoded  # Faraday::Request::UrlEncoded
#   builder.adapter  :net_http     # Faraday::Adapter::NetHttp
#   end
class Faraday::RackBuilder
  # @return [RackBuilder] a new instance of RackBuilder
  #
  # source://faraday//lib/faraday/rack_builder.rb#61
  def initialize(&block); end

  # source://faraday//lib/faraday/rack_builder.rb#179
  def ==(other); end

  # source://faraday//lib/faraday/rack_builder.rb#79
  def [](idx); end

  # source://faraday//lib/faraday/rack_builder.rb#110
  def adapter(klass = T.unsafe(nil), *args, **_arg2, &block); end

  # The "rack app" wrapped in middleware. All requests are sent here.
  #
  # The builder is responsible for creating the app object. After this,
  # the builder gets locked to ensure no further modifications are made
  # to the middleware stack.
  #
  # Returns an object that responds to `call` and returns a Response.
  #
  # source://faraday//lib/faraday/rack_builder.rb#163
  def app; end

  # source://faraday//lib/faraday/rack_builder.rb#73
  def build; end

  # ENV Keys
  # :http_method - a symbolized request HTTP method (:get, :post)
  # :body   - the request body that will eventually be converted to a string.
  # :url    - URI instance for the current request.
  # :status           - HTTP response status code
  # :request_headers  - hash of HTTP Headers to be sent to the server
  # :response_headers - Hash of HTTP headers from the server
  # :parallel_manager - sent if the connection is in parallel mode
  # :request - Hash of options for configuring the request.
  #   :timeout      - open/read timeout Integer in seconds
  #   :open_timeout - read timeout Integer in seconds
  #   :proxy        - Hash of proxy options
  #     :uri        - Proxy Server URI
  #     :user       - Proxy server username
  #     :password   - Proxy server password
  # :ssl - Hash of options for configuring SSL requests.
  #
  # source://faraday//lib/faraday/rack_builder.rb#201
  def build_env(connection, request); end

  # Processes a Request into a Response by passing it through this Builder's
  # middleware stack.
  #
  # @param connection [Faraday::Connection]
  # @param request [Faraday::Request]
  # @return [Faraday::Response]
  #
  # source://faraday//lib/faraday/rack_builder.rb#152
  def build_response(connection, request); end

  # source://faraday//lib/faraday/rack_builder.rb#140
  def delete(handler); end

  # Returns the value of attribute handlers.
  #
  # source://faraday//lib/faraday/rack_builder.rb#19
  def handlers; end

  # Sets the attribute handlers
  #
  # @param value the value to set the attribute handlers to.
  #
  # source://faraday//lib/faraday/rack_builder.rb#19
  def handlers=(_arg0); end

  # methods to push onto the various positions in the stack:
  #
  # source://faraday//lib/faraday/rack_builder.rb#119
  def insert(index, *args, **_arg2, &block); end

  # source://faraday//lib/faraday/rack_builder.rb#128
  def insert_after(index, *args, **_arg2, &block); end

  # methods to push onto the various positions in the stack:
  #
  # source://faraday//lib/faraday/rack_builder.rb#119
  def insert_before(index, *args, **_arg2, &block); end

  # Locks the middleware stack to ensure no further modifications are made.
  #
  # source://faraday//lib/faraday/rack_builder.rb#84
  def lock!; end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/rack_builder.rb#88
  def locked?; end

  # source://faraday//lib/faraday/rack_builder.rb#102
  def request(key, *args, **_arg2, &block); end

  # source://faraday//lib/faraday/rack_builder.rb#106
  def response(key, *args, **_arg2, &block); end

  # source://faraday//lib/faraday/rack_builder.rb#133
  def swap(index, *args, **_arg2, &block); end

  # source://faraday//lib/faraday/rack_builder.rb#171
  def to_app; end

  # source://faraday//lib/faraday/rack_builder.rb#92
  def use(klass, *args, **_arg2, &block); end

  private

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/rack_builder.rb#233
  def adapter_set?; end

  # source://faraday//lib/faraday/rack_builder.rb#245
  def assert_index(index); end

  # @raise [MISSING_ADAPTER_ERROR]
  #
  # source://faraday//lib/faraday/rack_builder.rb#229
  def ensure_adapter!; end

  # source://faraday//lib/faraday/rack_builder.rb#67
  def initialize_dup(original); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/rack_builder.rb#237
  def is_adapter?(klass); end

  # source://faraday//lib/faraday/rack_builder.rb#223
  def raise_if_adapter(klass); end

  # @raise [StackLocked]
  #
  # source://faraday//lib/faraday/rack_builder.rb#219
  def raise_if_locked; end

  # source://faraday//lib/faraday/rack_builder.rb#241
  def use_symbol(mod, key, *args, **_arg3, &block); end
end

# borrowed from ActiveSupport::Dependencies::Reference &
# ActionDispatch::MiddlewareStack::Middleware
class Faraday::RackBuilder::Handler
  # source://faraday//lib/faraday/rack_builder.rb#31
  def initialize(klass, *args, **_arg2, &block); end

  # source://faraday//lib/faraday/rack_builder.rb#46
  def ==(other); end

  # source://faraday//lib/faraday/rack_builder.rb#56
  def build(app = T.unsafe(nil)); end

  # source://faraday//lib/faraday/rack_builder.rb#42
  def inspect; end

  # source://faraday//lib/faraday/rack_builder.rb#38
  def klass; end

  # Returns the value of attribute name.
  #
  # source://faraday//lib/faraday/rack_builder.rb#29
  def name; end
end

# source://faraday//lib/faraday/rack_builder.rb#27
Faraday::RackBuilder::Handler::REGISTRY = T.let(T.unsafe(nil), Faraday::AdapterRegistry)

# source://faraday//lib/faraday/rack_builder.rb#214
Faraday::RackBuilder::LOCK_ERR = T.let(T.unsafe(nil), String)

# source://faraday//lib/faraday/rack_builder.rb#215
Faraday::RackBuilder::MISSING_ADAPTER_ERROR = T.let(T.unsafe(nil), String)

# Used to detect missing arguments
#
# source://faraday//lib/faraday/rack_builder.rb#17
Faraday::RackBuilder::NO_ARGUMENT = T.let(T.unsafe(nil), Object)

# Error raised when trying to modify the stack after calling `lock!`
class Faraday::RackBuilder::StackLocked < ::RuntimeError; end

# Used to setup URLs, params, headers, and the request body in a sane manner.
#
#
# @example
#   @connection.post do |req|
#   req.url 'http://localhost', 'a' => '1' # 'http://localhost?a=1'
#   req.headers['b'] = '2' # Header
#   req.params['c']  = '3' # GET Param
#   req['b']         = '2' # also Header
#   req.body = 'abc'
#   end
class Faraday::Request < ::Struct
  extend ::Faraday::MiddlewareRegistry

  # @param key [Object] key to look up in headers
  # @return [Object] value of the given header name
  #
  # source://faraday//lib/faraday/request.rb#89
  def [](key); end

  # @param key [Object] key of header to write
  # @param value [Object] value of header
  #
  # source://faraday//lib/faraday/request.rb#95
  def []=(key, value); end

  # Replace request headers, preserving the existing hash type.
  #
  # @param hash [Hash] new headers
  #
  # source://faraday//lib/faraday/request.rb#58
  def headers=(hash); end

  # Marshal serialization support.
  #
  # @return [Hash] the hash ready to be serialized in Marshal.
  #
  # source://faraday//lib/faraday/request.rb#102
  def marshal_dump; end

  # Marshal serialization support.
  # Restores the instance variables according to the +serialised+.
  #
  # @param serialised [Hash] the serialised object.
  #
  # source://faraday//lib/faraday/request.rb#116
  def marshal_load(serialised); end

  # Replace params, preserving the existing hash type.
  #
  # @param hash [Hash] new params
  #
  # source://faraday//lib/faraday/request.rb#47
  def params=(hash); end

  # @return [Env] the Env for this Request
  #
  # source://faraday//lib/faraday/request.rb#126
  def to_env(connection); end

  # Update path and params.
  #
  # @param path [URI, String]
  # @param params [Hash, nil]
  # @return [void]
  #
  # source://faraday//lib/faraday/request.rb#71
  def url(path, params = T.unsafe(nil)); end

  class << self
    # @param request_method [String]
    # @return [Request]
    # @yield [request] for block customization, if block given
    # @yieldparam request [Request]
    #
    # source://faraday//lib/faraday/request.rb#38
    def create(request_method); end
  end
end

# Request middleware for the Authorization HTTP header
class Faraday::Request::Authorization < ::Faraday::Middleware
  # @param app [#call]
  # @param type [String, Symbol] Type of Authorization
  # @param params [Array<String, Proc, #call>] parameters to build the Authorization header.
  #   If the type is `:basic`, then these can be a login and password pair.
  #   Otherwise, a single value is expected that will be appended after the type.
  #   This value can be a proc or an object responding to `.call`, in which case
  #   it will be invoked on each request.
  # @return [Authorization] a new instance of Authorization
  #
  # source://faraday//lib/faraday/request/authorization.rb#16
  def initialize(app, type, *params); end

  # @param env [Faraday::Env]
  #
  # source://faraday//lib/faraday/request/authorization.rb#23
  def on_request(env); end

  private

  # @param type [String, Symbol]
  # @param env [Faraday::Env]
  # @param params [Array]
  # @return [String] a header value
  #
  # source://faraday//lib/faraday/request/authorization.rb#35
  def header_from(type, env, *params); end
end

# source://faraday//lib/faraday/request/authorization.rb#7
Faraday::Request::Authorization::KEY = T.let(T.unsafe(nil), String)

# Middleware for instrumenting Requests.
class Faraday::Request::Instrumentation < ::Faraday::Middleware
  # Instruments requests using Active Support.
  #
  # Measures time spent only for synchronous requests.
  #
  # @example Using ActiveSupport::Notifications to measure time spent
  #   for Faraday requests.
  #   ActiveSupport::Notifications
  #   .subscribe('request.faraday') do |name, starts, ends, _, env|
  #   url = env[:url]
  #   http_method = env[:method].to_s.upcase
  #   duration = ends - starts
  #   $stderr.puts '[%s] %s %s (%.3f s)' %
  #   [url.host, http_method, url.request_uri, duration]
  #   end
  # @option options
  # @option options
  # @param app [#call]
  # @param options [nil, Hash] Options hash
  # @return [Instrumentation] a new instance of Instrumentation
  #
  # source://faraday//lib/faraday/request/instrumentation.rb#40
  def initialize(app, options = T.unsafe(nil)); end

  # @param env [Faraday::Env]
  #
  # source://faraday//lib/faraday/request/instrumentation.rb#47
  def call(env); end
end

# Options class used in Request::Instrumentation class.
class Faraday::Request::Instrumentation::Options < ::Faraday::Options
  # @return [Class]
  #
  # source://faraday//lib/faraday/request/instrumentation.rb#15
  def instrumenter; end

  # @return [String]
  #
  # source://faraday//lib/faraday/request/instrumentation.rb#10
  def name; end
end

# Request middleware that encodes the body as JSON.
#
# Processes only requests with matching Content-type or those without a type.
# If a request doesn't have a type but has a body, it sets the Content-type
# to JSON MIME-type.
#
# Doesn't try to encode bodies that already are in string form.
class Faraday::Request::Json < ::Faraday::Middleware
  # source://faraday//lib/faraday/request/json.rb#18
  def on_request(env); end

  private

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/request/json.rb#42
  def body?(env); end

  # source://faraday//lib/faraday/request/json.rb#26
  def encode(data); end

  # @yield []
  #
  # source://faraday//lib/faraday/request/json.rb#30
  def match_content_type(env); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/request/json.rb#37
  def process_request?(env); end

  # source://faraday//lib/faraday/request/json.rb#46
  def request_type(env); end
end

# source://faraday//lib/faraday/request/json.rb#15
Faraday::Request::Json::MIME_TYPE = T.let(T.unsafe(nil), String)

# source://faraday//lib/faraday/request/json.rb#16
Faraday::Request::Json::MIME_TYPE_REGEX = T.let(T.unsafe(nil), Regexp)

# Middleware for supporting urlencoded requests.
class Faraday::Request::UrlEncoded < ::Faraday::Middleware
  # Encodes as "application/x-www-form-urlencoded" if not already encoded or
  # of another type.
  #
  # @param env [Faraday::Env]
  #
  # source://faraday//lib/faraday/request/url_encoded.rb#20
  def call(env); end

  # @param env [Faraday::Env]
  # @yield [request_body] Body of the request
  #
  # source://faraday//lib/faraday/request/url_encoded.rb#30
  def match_content_type(env); end

  # @param env [Faraday::Env]
  # @return [Boolean] True if the request has a body and its Content-Type is
  #   urlencoded.
  #
  # source://faraday//lib/faraday/request/url_encoded.rb#43
  def process_request?(env); end

  # @param env [Faraday::Env]
  # @return [String]
  #
  # source://faraday//lib/faraday/request/url_encoded.rb#51
  def request_type(env); end

  class << self
    # Returns the value of attribute mime_type.
    #
    # source://faraday//lib/faraday/request/url_encoded.rb#12
    def mime_type; end

    # Sets the attribute mime_type
    #
    # @param value the value to set the attribute mime_type to.
    #
    # source://faraday//lib/faraday/request/url_encoded.rb#12
    def mime_type=(_arg0); end
  end
end

# source://faraday//lib/faraday/request/url_encoded.rb#8
Faraday::Request::UrlEncoded::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# RequestOptions contains the configurable properties for a Faraday request.
class Faraday::RequestOptions < ::Faraday::Options
  # source://faraday//lib/faraday/options/request_options.rb#10
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/options/request_options.rb#18
  def stream_response?; end
end

# Raised by Faraday::Response::RaiseError in case of a 404 response.
class Faraday::ResourceNotFound < ::Faraday::ClientError; end

# Response represents an HTTP response from making an HTTP request.
class Faraday::Response
  extend ::Forwardable
  extend ::Faraday::MiddlewareRegistry

  # @return [Response] a new instance of Response
  #
  # source://faraday//lib/faraday/response.rb#11
  def initialize(env = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def [](*args, **_arg1, &block); end

  # Expand the env with more properties, without overriding existing ones.
  # Useful for applying request params after restoring a marshalled Response.
  #
  # source://faraday//lib/faraday/response.rb#79
  def apply_request(request_env); end

  # source://faraday//lib/faraday/response.rb#32
  def body; end

  # Returns the value of attribute env.
  #
  # source://faraday//lib/faraday/response.rb#16
  def env; end

  # source://faraday//lib/faraday/response.rb#49
  def finish(env); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/response.rb#36
  def finished?; end

  # source://faraday//lib/faraday/response.rb#26
  def headers; end

  # because @on_complete_callbacks cannot be marshalled
  #
  # source://faraday//lib/faraday/response.rb#69
  def marshal_dump; end

  # source://faraday//lib/faraday/response.rb#73
  def marshal_load(env); end

  # source://faraday//lib/faraday/response.rb#40
  def on_complete(&block); end

  # source://faraday//lib/faraday/response.rb#22
  def reason_phrase; end

  # source://faraday//lib/faraday/response.rb#18
  def status; end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/response.rb#57
  def success?; end

  # source://faraday//lib/faraday/response.rb#61
  def to_hash; end
end

# Parse response bodies as JSON.
class Faraday::Response::Json < ::Faraday::Middleware
  # @return [Json] a new instance of Json
  #
  # source://faraday//lib/faraday/response/json.rb#9
  def initialize(app = T.unsafe(nil), parser_options: T.unsafe(nil), content_type: T.unsafe(nil), preserve_raw: T.unsafe(nil)); end

  # source://faraday//lib/faraday/response/json.rb#16
  def on_complete(env); end

  private

  # source://faraday//lib/faraday/response/json.rb#29
  def parse(body); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/response/json.rb#33
  def parse_response?(env); end

  # source://faraday//lib/faraday/response/json.rb#22
  def process_response(env); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/response/json.rb#38
  def process_response_type?(env); end

  # source://faraday//lib/faraday/response/json.rb#45
  def response_type(env); end
end

# Logger is a middleware that logs internal events in the HTTP request
# lifecycle to a given Logger object. By default, this logs to STDOUT. See
# Faraday::Logging::Formatter to see specifically what is logged.
class Faraday::Response::Logger < ::Faraday::Middleware
  # @return [Logger] a new instance of Logger
  # @yield [@formatter]
  #
  # source://faraday//lib/faraday/response/logger.rb#13
  def initialize(app, logger = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://faraday//lib/faraday/response/logger.rb#21
  def call(env); end

  # source://faraday//lib/faraday/response/logger.rb#26
  def on_complete(env); end

  # source://faraday//lib/faraday/response/logger.rb#30
  def on_error(exc); end
end

# RaiseError is a Faraday middleware that raises exceptions on common HTTP
# client or server error responses.
class Faraday::Response::RaiseError < ::Faraday::Middleware
  # source://faraday//lib/faraday/response/raise_error.rb#13
  def on_complete(env); end

  # source://faraday//lib/faraday/response/raise_error.rb#56
  def query_params(env); end

  # source://faraday//lib/faraday/response/raise_error.rb#40
  def response_values(env); end
end

# source://faraday//lib/faraday/response/raise_error.rb#9
Faraday::Response::RaiseError::ClientErrorStatuses = T.let(T.unsafe(nil), Range)

# source://faraday//lib/faraday/response/raise_error.rb#10
Faraday::Response::RaiseError::ServerErrorStatuses = T.let(T.unsafe(nil), Range)

# A unified client error for SSL errors.
class Faraday::SSLError < ::Faraday::Error; end

# SSL-related options.
class Faraday::SSLOptions < ::Faraday::Options
  # @return [Boolean] true if should not verify
  #
  # source://faraday//lib/faraday/options/ssl_options.rb#60
  def disable?; end

  # @return [Boolean] true if should verify
  #
  # source://faraday//lib/faraday/options/ssl_options.rb#55
  def verify?; end

  # @return [Boolean] true if should verify_hostname
  #
  # source://faraday//lib/faraday/options/ssl_options.rb#65
  def verify_hostname?; end
end

# Faraday server error class. Represents 5xx status responses.
class Faraday::ServerError < ::Faraday::Error; end

# A unified client error for timeouts.
class Faraday::TimeoutError < ::Faraday::ServerError
  # @return [TimeoutError] a new instance of TimeoutError
  #
  # source://faraday//lib/faraday/error.rb#123
  def initialize(exc = T.unsafe(nil), response = T.unsafe(nil)); end
end

# Raised by Faraday::Response::RaiseError in case of a 401 response.
class Faraday::UnauthorizedError < ::Faraday::ClientError; end

# Raised by Faraday::Response::RaiseError in case of a 422 response.
class Faraday::UnprocessableEntityError < ::Faraday::ClientError; end

# Utils contains various static helper methods.
module Faraday::Utils
  private

  # Normalize URI() behavior across Ruby versions
  #
  # url - A String or URI.
  #
  # Returns a parsed URI.
  #
  # source://faraday//lib/faraday/utils.rb#71
  def URI(url); end

  # source://faraday//lib/faraday/utils.rb#56
  def basic_header_from(login, pass); end

  # source://faraday//lib/faraday/utils.rb#17
  def build_nested_query(params); end

  # source://faraday//lib/faraday/utils.rb#13
  def build_query(params); end

  # Recursive hash merge
  #
  # source://faraday//lib/faraday/utils.rb#114
  def deep_merge(source, hash); end

  # Recursive hash update
  #
  # source://faraday//lib/faraday/utils.rb#102
  def deep_merge!(target, hash); end

  # source://faraday//lib/faraday/utils.rb#52
  def default_params_encoder; end

  # source://faraday//lib/faraday/utils.rb#21
  def default_space_encoding; end

  # source://faraday//lib/faraday/utils.rb#81
  def default_uri_parser; end

  # source://faraday//lib/faraday/utils.rb#85
  def default_uri_parser=(parser); end

  # source://faraday//lib/faraday/utils.rb#31
  def escape(str); end

  # Receives a String or URI and returns just
  # the path with the query string sorted.
  #
  # source://faraday//lib/faraday/utils.rb#95
  def normalize_path(url); end

  # source://faraday//lib/faraday/utils.rb#48
  def parse_nested_query(query); end

  # Adapted from Rack
  #
  # source://faraday//lib/faraday/utils.rb#44
  def parse_query(query); end

  # source://faraday//lib/faraday/utils.rb#118
  def sort_query_params(query); end

  # source://faraday//lib/faraday/utils.rb#37
  def unescape(str); end

  class << self
    # Normalize URI() behavior across Ruby versions
    #
    # url - A String or URI.
    #
    # Returns a parsed URI.
    #
    # source://faraday//lib/faraday/utils.rb#71
    def URI(url); end

    # source://faraday//lib/faraday/utils.rb#56
    def basic_header_from(login, pass); end

    # source://faraday//lib/faraday/utils.rb#17
    def build_nested_query(params); end

    # source://faraday//lib/faraday/utils.rb#13
    def build_query(params); end

    # Recursive hash merge
    #
    # source://faraday//lib/faraday/utils.rb#114
    def deep_merge(source, hash); end

    # Recursive hash update
    #
    # source://faraday//lib/faraday/utils.rb#102
    def deep_merge!(target, hash); end

    # source://faraday//lib/faraday/utils.rb#52
    def default_params_encoder; end

    # Sets the attribute default_params_encoder
    #
    # @param value the value to set the attribute default_params_encoder to.
    #
    # source://faraday//lib/faraday/utils.rb#63
    def default_params_encoder=(_arg0); end

    # source://faraday//lib/faraday/utils.rb#21
    def default_space_encoding; end

    # Sets the attribute default_space_encoding
    #
    # @param value the value to set the attribute default_space_encoding to.
    #
    # source://faraday//lib/faraday/utils.rb#26
    def default_space_encoding=(_arg0); end

    # source://faraday//lib/faraday/utils.rb#81
    def default_uri_parser; end

    # source://faraday//lib/faraday/utils.rb#85
    def default_uri_parser=(parser); end

    # source://faraday//lib/faraday/utils.rb#31
    def escape(str); end

    # Receives a String or URI and returns just
    # the path with the query string sorted.
    #
    # source://faraday//lib/faraday/utils.rb#95
    def normalize_path(url); end

    # source://faraday//lib/faraday/utils.rb#48
    def parse_nested_query(query); end

    # Adapted from Rack
    #
    # source://faraday//lib/faraday/utils.rb#44
    def parse_query(query); end

    # source://faraday//lib/faraday/utils.rb#118
    def sort_query_params(query); end

    # source://faraday//lib/faraday/utils.rb#37
    def unescape(str); end
  end
end

# source://faraday//lib/faraday/utils.rb#41
Faraday::Utils::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# source://faraday//lib/faraday/utils.rb#29
Faraday::Utils::ESCAPE_RE = T.let(T.unsafe(nil), Regexp)

# A case-insensitive Hash that preserves the original case of a header
# when set.
#
# Adapted from Rack::Utils::HeaderHash
class Faraday::Utils::Headers < ::Hash
  # @return [Headers] a new instance of Headers
  #
  # source://faraday//lib/faraday/utils/headers.rb#20
  def initialize(hash = T.unsafe(nil)); end

  # source://faraday//lib/faraday/utils/headers.rb#52
  def [](key); end

  # source://faraday//lib/faraday/utils/headers.rb#57
  def []=(key, val); end

  # source://faraday//lib/faraday/utils/headers.rb#71
  def delete(key); end

  # source://faraday//lib/faraday/utils/headers.rb#65
  def fetch(key, *args, &block); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/headers.rb#80
  def has_key?(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/headers.rb#80
  def include?(key); end

  # source://faraday//lib/faraday/utils/headers.rb#26
  def initialize_names; end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/headers.rb#80
  def key?(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/headers.rb#80
  def member?(key); end

  # source://faraday//lib/faraday/utils/headers.rb#95
  def merge(other); end

  # source://faraday//lib/faraday/utils/headers.rb#88
  def merge!(other); end

  # source://faraday//lib/faraday/utils/headers.rb#111
  def parse(header_string); end

  # source://faraday//lib/faraday/utils/headers.rb#100
  def replace(other); end

  # source://faraday//lib/faraday/utils/headers.rb#107
  def to_hash; end

  # source://faraday//lib/faraday/utils/headers.rb#88
  def update(other); end

  protected

  # Returns the value of attribute names.
  #
  # source://faraday//lib/faraday/utils/headers.rb#129
  def names; end

  private

  # Join multiple values with a comma.
  #
  # source://faraday//lib/faraday/utils/headers.rb#134
  def add_parsed(key, value); end

  # on dup/clone, we need to duplicate @names hash
  #
  # source://faraday//lib/faraday/utils/headers.rb#31
  def initialize_copy(other); end

  class << self
    # source://faraday//lib/faraday/utils/headers.rb#14
    def allocate; end

    # source://faraday//lib/faraday/utils/headers.rb#10
    def from(value); end
  end
end

# symbol -> string mapper + cache
#
# source://faraday//lib/faraday/utils/headers.rb#40
Faraday::Utils::Headers::KeyMap = T.let(T.unsafe(nil), Hash)

# A hash with stringified keys.
class Faraday::Utils::ParamsHash < ::Hash
  # source://faraday//lib/faraday/utils/params_hash.rb#7
  def [](key); end

  # source://faraday//lib/faraday/utils/params_hash.rb#11
  def []=(key, value); end

  # source://faraday//lib/faraday/utils/params_hash.rb#15
  def delete(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/params_hash.rb#19
  def has_key?(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/params_hash.rb#19
  def include?(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/params_hash.rb#19
  def key?(key); end

  # @return [Boolean]
  #
  # source://faraday//lib/faraday/utils/params_hash.rb#19
  def member?(key); end

  # source://faraday//lib/faraday/utils/params_hash.rb#35
  def merge(params); end

  # source://faraday//lib/faraday/utils/params_hash.rb#27
  def merge!(params); end

  # source://faraday//lib/faraday/utils/params_hash.rb#44
  def merge_query(query, encoder = T.unsafe(nil)); end

  # source://faraday//lib/faraday/utils/params_hash.rb#39
  def replace(other); end

  # source://faraday//lib/faraday/utils/params_hash.rb#50
  def to_query(encoder = T.unsafe(nil)); end

  # source://faraday//lib/faraday/utils/params_hash.rb#27
  def update(params); end

  private

  # source://faraday//lib/faraday/utils/params_hash.rb#56
  def convert_key(key); end
end

# source://faraday//lib/faraday/version.rb#4
Faraday::VERSION = T.let(T.unsafe(nil), String)
