# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `faker` gem.
# Please instead update this file by running `bin/tapioca gem faker`.

module Faker; end

class Faker::Address < ::Faker::Base
  class << self
    # Produces a building number.
    #
    # @example
    #   Faker::Address.building_number #=> "7304"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#74
    def building_number; end

    # Produces the name of a city.
    #
    # @example
    #   Faker::Address.city #=> "Imogeneborough"
    #   Faker::Address.city(options: { with_state: true })
    #   #=> "Northfort, California"
    # @option with_state
    # @param options [Hash]
    # @param with_state [Hash] a customizable set of options
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#21
    def city(options: T.unsafe(nil)); end

    # Produces a city prefix.
    #
    # @example
    #   Faker::Address.city_prefix #=> "Lake"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#178
    def city_prefix; end

    # Produces a city suffix.
    #
    # @example
    #   Faker::Address.city_suffix #=> "fort"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#165
    def city_suffix; end

    # Produces the name of a community.
    #
    # @example
    #   Faker::Address.community #=> "University Crossing"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#87
    def community; end

    # Produces the name of a country.
    #
    # @example
    #   Faker::Address.country #=> "French Guiana"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#217
    def country; end

    # Produces a country by ISO country code. See the
    # [List of ISO 3166 country codes](https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes)
    # on Wikipedia for a full list.
    #
    # @example
    #   Faker::Address.country_by_code(code: 'NL') #=> "Netherlands"
    # @param code [String] An ISO country code.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#233
    def country_by_code(code: T.unsafe(nil)); end

    # Produces an ISO 3166 country code.
    #
    # @example
    #   Faker::Address.country_code #=> "IT"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#260
    def country_code; end

    # Produces a long (alpha-3) ISO 3166 country code.
    #
    # @example
    #   Faker::Address.country_code_long #=> "ITA"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#273
    def country_code_long; end

    # Produces an ISO 3166 country code when given a country name.
    #
    # @example
    #   Faker::Address.country_name_to_code(name: 'united_states') #=> "US"
    # @param name [String] Country name in snake_case format.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#247
    def country_name_to_code(name: T.unsafe(nil)); end

    # Produces a full address.
    #
    # @example
    #   Faker::Address.full_address
    #   #=> "282 Kevin Brook, Imogeneborough, CA 58517"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#313
    def full_address; end

    # Produces Address hash of required fields
    #
    #  Faker::Address.full_address_as_hash(:full_address)
    #     #=> {:full_address=>"87635 Rice Street, Lake Brentonton, OR 61896-5968"}
    #
    #  Faker::Address.full_address_as_hash(:city, :time_zone)
    #     #=> {:city=>"East Faustina", :time_zone=>"America/Mexico_City"}
    #
    #  Faker::Address.full_address_as_hash(:street_address, street_address: {include_secondary: true})
    #     #=> {:street_address=>"29423 Kenneth Causeway Suite 563"}
    #
    # @example
    #   Faker::Address.full_address_as_hash(:longitude,
    #   :latitude,
    #   :country_name_to_code,
    #   country_name_to_code: {name: 'united_states'})
    #   #=> {:longitude=>-101.74428917174603, :latitude=>-37.40056749089944, :country_name_to_code=>"US"}
    # @return [Hash]
    #
    # source://faker//lib/faker/default/address.rb#339
    def full_address_as_hash(*attrs, **attrs_params); end

    # Produces a latitude.
    #
    # @example
    #   Faker::Address.latitude #=> -58.17256227443719
    # @return [Float]
    #
    # source://faker//lib/faker/default/address.rb#286
    def latitude; end

    # Produces a longitude.
    #
    # @example
    #   Faker::Address.longitude #=> -156.65548382095133
    # @return [Float]
    #
    # source://faker//lib/faker/default/address.rb#299
    def longitude; end

    # Produces a mail box number.
    #
    # @example
    #   Faker::Address.mail_box #=> "PO Box 123"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#100
    def mail_box; end

    # Produces a Zip Code.
    #
    # @example
    #   Faker::Address.zip_code #=> "58517"
    #   Faker::Address.zip_code #=> "23285-4905"
    #   Faker::Address.zip_code(state_abbreviation: 'CO') #=> "80011"
    # @param state_abbreviation [String] an abbreviation for a state where the zip code should be located.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#116
    def postcode(state_abbreviation: T.unsafe(nil)); end

    # Produces a secondary address.
    #
    # @example
    #   Faker::Address.secondary_address #=> "Apt. 672"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#61
    def secondary_address; end

    # Produces the name of a state.
    #
    # @example
    #   Faker::Address.state #=> "California"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#204
    def state; end

    # Produces a state abbreviation.
    #
    # @example
    #   Faker::Address.state_abbr #=> "AP"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#191
    def state_abbr; end

    # Produces a street address.
    #
    # @example
    #   Faker::Address.street_address #=> "282 Kevin Brook"
    # @param include_secondary [Boolean] Whether or not to include the secondary address.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#48
    def street_address(include_secondary: T.unsafe(nil)); end

    # Produces a street name.
    #
    # @example
    #   Faker::Address.street_name #=> "Larkin Fork"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#34
    def street_name; end

    # Produces a street suffix.
    #
    # @example
    #   Faker::Address.street_suffix #=> "Street"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#152
    def street_suffix; end

    # Produces the name of a time zone.
    #
    # @example
    #   Faker::Address.time_zone #=> "Asia/Yakutsk"
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#136
    def time_zone; end

    # Produces a Zip Code.
    #
    # @example
    #   Faker::Address.zip_code #=> "58517"
    #   Faker::Address.zip_code #=> "23285-4905"
    #   Faker::Address.zip_code(state_abbreviation: 'CO') #=> "80011"
    # @param state_abbreviation [String] an abbreviation for a state where the zip code should be located.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#116
    def zip(state_abbreviation: T.unsafe(nil)); end

    # Produces a Zip Code.
    #
    # @example
    #   Faker::Address.zip_code #=> "58517"
    #   Faker::Address.zip_code #=> "23285-4905"
    #   Faker::Address.zip_code(state_abbreviation: 'CO') #=> "80011"
    # @param state_abbreviation [String] an abbreviation for a state where the zip code should be located.
    # @return [String]
    #
    # source://faker//lib/faker/default/address.rb#116
    def zip_code(state_abbreviation: T.unsafe(nil)); end
  end
end

class Faker::Adjective < ::Faker::Base
  class << self
    # Produces a negative adjective.
    #
    # @example
    #   Faker::Adjective.negative #=> "Creepy"
    # @return [String]
    #
    # source://faker//lib/faker/default/adjective.rb#30
    def negative; end

    # Produces a positive adjective.
    #
    # @example
    #   Faker::Adjective.positive #=> "Kind"
    # @return [String]
    #
    # source://faker//lib/faker/default/adjective.rb#17
    def positive; end
  end
end

class Faker::Alphanumeric < ::Faker::Base
  class << self
    # Produces a random string of alphabetic characters (no digits)
    #
    # @example
    #   Faker::Alphanumeric.alpha(number: 10) #=> "zlvubkrwga"
    # @param number [Integer] The length of the string to generate
    # @return [String]
    #
    # source://faker//lib/faker/default/alphanumeric.rb#22
    def alpha(number: T.unsafe(nil)); end

    # Produces a random string of alphanumeric characters
    #
    # @example
    #   Faker::Alphanumeric.alphanumeric(number: 10) #=> "3yfq2phxtb"
    # @example
    #   Faker::Alphanumeric.alphanumeric(number: 10, min_alpha: 3) #=> "3yfq2phxtb"
    # @example
    #   Faker::Alphanumeric.alphanumeric(number: 10, min_alpha: 3, min_numeric: 3) #=> "3yfq2phx8b"
    # @param number [Integer] The number of characters to generate
    # @param min_alpha [Integer] The minimum number of alphabetic to add to the string
    # @param min_numeric [Integer] The minimum number of numbers to add to the string
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/alphanumeric.rb#46
    def alphanumeric(number: T.unsafe(nil), min_alpha: T.unsafe(nil), min_numeric: T.unsafe(nil)); end
  end
end

# List of characters allowed for alphanumeric strings
#
# @private
#
# source://faker//lib/faker/default/alphanumeric.rb#8
Faker::Alphanumeric::ALPHANUMS = T.let(T.unsafe(nil), Array)

class Faker::Ancient < ::Faker::Base
  class << self
    # Produces a god from ancient mythology.
    #
    # @example
    #   Faker::Ancient.god #=> "Zeus"
    # @return [String]
    #
    # source://faker//lib/faker/default/ancient.rb#15
    def god; end

    # Produces a hero from ancient mythology.
    #
    # @example
    #   Faker::Ancient.hero #=> "Achilles"
    # @return [String]
    #
    # source://faker//lib/faker/default/ancient.rb#54
    def hero; end

    # Produces a primordial from ancient mythology.
    #
    # @example
    #   Faker::Ancient.primordial #=> "Gaia"
    # @return [String]
    #
    # source://faker//lib/faker/default/ancient.rb#28
    def primordial; end

    # Produces a titan from ancient mythology.
    #
    # @example
    #   Faker::Ancient.titan #=> "Atlas"
    # @return [String]
    #
    # source://faker//lib/faker/default/ancient.rb#41
    def titan; end
  end
end

class Faker::App < ::Faker::Base
  class << self
    # Produces the name of an app's author.
    #
    # @example
    #   Faker::App.author #=> "Daphne Swift"
    # @return [String]
    #
    # source://faker//lib/faker/default/app.rb#41
    def author; end

    # Produces an app name.
    #
    # @example
    #   Faker::App.name #=> "Treeflex"
    # @return [String]
    #
    # source://faker//lib/faker/default/app.rb#15
    def name; end

    # Produces a String representing a semantic version identifier.
    #
    # @example
    #   Faker::App.semantic_version #=> "3.2.5"
    # @example
    #   Faker::App.semantic_version(major: 42) #=> "42.5.2"
    # @example
    #   Faker::App.semantic_version(minor: 100..101) #=> "42.100.4"
    # @example
    #   Faker::App.semantic_version(patch: 5..6) #=> "7.2.6"
    # @param major [Integer, Range] An integer to use or a range to pick the integer from.
    # @param minor [Integer, Range] An integer to use or a range to pick the integer from.
    # @param patch [Integer, Range] An integer to use or a range to pick the integer from.
    # @return [String]
    #
    # source://faker//lib/faker/default/app.rb#63
    def semantic_version(major: T.unsafe(nil), minor: T.unsafe(nil), patch: T.unsafe(nil)); end

    # Produces a version string.
    #
    # @example
    #   Faker::App.version #=> "1.85"
    # @return [String]
    #
    # source://faker//lib/faker/default/app.rb#28
    def version; end
  end
end

class Faker::Appliance < ::Faker::Base
  class << self
    # Produces the name of an appliance brand.
    #
    # @example
    #   Faker::Appliance.brand #=> "Bosch"
    # @return [String]
    #
    # source://faker//lib/faker/default/appliance.rb#15
    def brand; end

    # Produces the name of a type of appliance equipment.
    #
    # @example
    #   Faker::Appliance.equipment #=> "Appliance plug"
    # @return [String]
    #
    # source://faker//lib/faker/default/appliance.rb#28
    def equipment; end
  end
end

class Faker::Artist < ::Faker::Base
  class << self
    # Produces the name of an artist.
    #
    # @example
    #   Faker::Artist.name #=> "Michelangelo"
    # @return [String]
    #
    # source://faker//lib/faker/default/artist.rb#15
    def name; end
  end
end

class Faker::Australia < ::Faker::Base
  class << self
    # Produces an Australian animal
    #
    # @example
    #   Faker::Australia.animal
    #   #=> "Dingo"
    # @return [String]
    #
    # source://faker//lib/faker/locations/australia.rb#29
    def animal; end

    # Produces a location in Australia
    #
    # @example
    #   Faker::Australia.location
    #   #=> "Sydney"
    # @return [String]
    #
    # source://faker//lib/faker/locations/australia.rb#16
    def location; end

    # Produces an Australian State or Territory
    #
    # @example
    #   Faker::Australia.state
    #   #=> "New South Wales"
    # @return [String]
    #
    # source://faker//lib/faker/locations/australia.rb#42
    def state; end
  end
end

class Faker::Avatar < ::Faker::Base
  class << self
    # Produces a URL for an avatar from robohash.org
    #
    # @example
    #   Faker::Avatar.image
    #   #=> "https://robohash.org/sitsequiquia.png?size=300x300&set=set1"
    # @example
    #   Faker::Avatar.image(slug: "my-own-slug")
    #   #=> "https://robohash.org/my-own-slug.png?size=300x300&set=set1"
    # @example
    #   Faker::Avatar.image(slug: "my-own-slug", size: "50x50")
    #   #=> "https://robohash.org/my-own-slug.png?size=50x50&set=set1"
    # @example
    #   Faker::Avatar.image(slug: "my-own-slug", size: "50x50", format: "jpg")
    #   #=> "https://robohash.org/my-own-slug.jpg?size=50x50&set=set1"
    # @example
    #   Faker::Avatar.image(slug: "my-own-slug", size: "50x50", format: "bmp")
    #   #=> "https://robohash.org/my-own-slug.bmp?size=50x50&set=set1"
    # @example
    #   Faker::Avatar.image(slug: "my-own-slug", size: "50x50", format: "bmp", set: "set1", bgset: "bg1")
    #   #=> "https://robohash.org/my-own-slug.bmp?size=50x50&set=set1&bgset=bg1"
    # @param slug [String, nil]
    # @param size [String] image size in pixels, in the format of 'AxB'
    # @param format [String] The image file format
    # @param set [String] The avatar set to use
    # @param bgset [String, nil] The background set to use
    # @raise [ArgumentError]
    # @return [String] A robohash.org URL
    #
    # source://faker//lib/faker/default/avatar.rb#39
    def image(slug: T.unsafe(nil), size: T.unsafe(nil), format: T.unsafe(nil), set: T.unsafe(nil), bgset: T.unsafe(nil)); end
  end
end

class Faker::Bank < ::Faker::Base
  class << self
    # Produces a bank account number.
    #
    # @example
    #   Faker::Bank.account_number #=> 6738582379
    #   Faker::Bank.account_number(digits: 13) #=> 673858237902
    # @param digits [Integer] Number of digits that the generated account number should have.
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#19
    def account_number(digits: T.unsafe(nil)); end

    # Produces an Australian BSB (Bank-State-Branch) number
    #
    # @example
    #   Faker::Bank.bsb_number
    #   #=> "036616"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#133
    def bsb_number; end

    # Produces a bank iban number.
    #
    # @example
    #   Faker::Bank.iban #=> "GB76DZJM33188515981979"
    #   Faker::Bank.iban(country_code: "be") #=> "BE6375388567752043"
    #   Faker::Bank.iban(country_code: nil) #=> "DE45186738071857270067"
    # @param country_code [String, nil] Specifies what country prefix is used to generate the iban code. Providing `nil` will use a random country.
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#39
    def iban(country_code: T.unsafe(nil)); end

    # Produces the ISO 3166 code of a country that uses the IBAN system.
    #
    # @example
    #   Faker::Bank.iban_country_code #=> "CH"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#67
    def iban_country_code; end

    # Produces a bank name.
    #
    # @example
    #   Faker::Bank.name #=> "ABN AMRO CORPORATE FINANCE LIMITED"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#80
    def name; end

    # Produces a routing number.
    #
    # @example
    #   Faker::Bank.routing_number #=> "729343831"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#93
    def routing_number; end

    # Produces a valid routing number.
    #
    # @example
    #   Faker::Bank.routing_number #=> "729343831"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#106
    def routing_number_with_format; end

    # Produces a swift / bic number.
    #
    # @example
    #   Faker::Bank.swift_bic #=> "AAFMGB21"
    # @return [String]
    #
    # source://faker//lib/faker/default/bank.rb#119
    def swift_bic; end

    private

    # source://faker//lib/faker/default/bank.rb#139
    def checksum(num_string); end

    # source://faker//lib/faker/default/bank.rb#154
    def compile_bsb_number; end

    # source://faker//lib/faker/default/bank.rb#187
    def compile_fraction(routing_num); end

    # source://faker//lib/faker/default/bank.rb#148
    def compile_routing_number; end

    # Calculates the mandatory checksum in 3rd and 4th characters in IBAN format
    # source: https://en.wikipedia.org/wiki/International_Bank_Account_Number#Generating_IBAN_check_digits
    #
    # source://faker//lib/faker/default/bank.rb#162
    def iban_checksum(country_code, account); end

    # source://faker//lib/faker/default/bank.rb#194
    def rand_numstring; end

    # @return [Boolean]
    #
    # source://faker//lib/faker/default/bank.rb#183
    def valid_checksum?(routing_number, checksum); end

    # source://faker//lib/faker/default/bank.rb#175
    def valid_routing_number; end
  end
end

class Faker::Barcode < ::Faker::Base
  class << self
    # Returns a EAN 8 or 13 digit format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.ean      => "85657526"
    #     Faker::Barcode.ean(8)   => "30152700"
    #     Faker::Barcode.ean(13)  => "2115190480285"
    #
    # source://faker//lib/faker/default/barcode.rb#16
    def ean(length = T.unsafe(nil)); end

    # Returns a EAN 8 or 13 digit format barcode number with composite string attached with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.ean_with_composite_sumbology      => "41007624|JHOC6649"
    #     Faker::Barcode.ean_with_composite_sumbology(8)   => "38357961|XUYJ3266"
    #     Faker::Barcode.ean_with_composite_sumbology(13)  => "9530722443911|CKHWQHID"
    #
    # source://faker//lib/faker/default/barcode.rb#30
    def ean_with_composite_symbology(length = T.unsafe(nil)); end

    # Returns a ISBN format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.isbn      => "9798363807732"
    #
    # source://faker//lib/faker/default/barcode.rb#90
    def isbn; end

    # Returns a ISMN format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.ismn      => "9790527672897"
    #
    # source://faker//lib/faker/default/barcode.rb#102
    def ismn; end

    # Returns a ISSN format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.issn      => "9775541703338"
    #
    # source://faker//lib/faker/default/barcode.rb#114
    def issn; end

    # Returns a UPC_A format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.upc_a      => "766807541831"
    #
    # source://faker//lib/faker/default/barcode.rb#42
    def upc_a; end

    # Returns a UPC_A format barcode number with composite string attached with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.upc_a_with_composite_symbology      => "790670155765|JOVG6208"
    #
    # source://faker//lib/faker/default/barcode.rb#66
    def upc_a_with_composite_symbology; end

    # Returns a UPC_E format barcode number with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.upc_e      => "03746820"
    #
    # source://faker//lib/faker/default/barcode.rb#54
    def upc_e; end

    # Returns a UPC_E format barcode number with composite string attached with check digit
    #  @return [String]
    #
    #  @example
    #     Faker::Barcode.upc_e_with_composite_symbology      => "05149247|BKZX9722"
    #
    # source://faker//lib/faker/default/barcode.rb#78
    def upc_e_with_composite_symbology; end

    private

    # source://faker//lib/faker/default/barcode.rb#120
    def generate_barcode(key); end

    # Generates the check digits from sum passed
    #
    # @example
    #   Faker::Barcode.send(:generate_check_digit, 12, 4)   => 0
    #   Faker::Barcode.send(:generate_check_digit, 23, 5)   => 6
    # @return [Integer]
    #
    # source://faker//lib/faker/default/barcode.rb#160
    def generate_check_digit(odd_sum, even_sum); end

    # Returns the sum of even and odd numbers from value passed
    #
    # @example
    #   Faker::Barcode.send(:sum_even_odd, 12345)   => [9, 5]
    #   Faker::Barcode.send(:sum_even_odd, 87465)   => [17, 13]
    # @return [Array]
    #
    # source://faker//lib/faker/default/barcode.rb#136
    def sum_even_odd(fake_num); end
  end
end

class Faker::Base
  class << self
    # source://faker//lib/faker.rb#61
    def bothify(string); end

    # source://faker//lib/faker.rb#255
    def disable_enforce_available_locales; end

    # Helper for the common approach of grabbing a translation
    # with an array of values and selecting one of them.
    #
    # source://faker//lib/faker.rb#101
    def fetch(key); end

    # Helper for the common approach of grabbing a translation
    # with an array of values and returning all of them.
    #
    # source://faker//lib/faker.rb#112
    def fetch_all(key); end

    # source://faker//lib/faker.rb#182
    def flexible(key); end

    # Returns the value of attribute flexible_key.
    #
    # source://faker//lib/faker.rb#46
    def flexible_key; end

    # source://faker//lib/faker.rb#57
    def letterify(letter_string); end

    # You can add whatever you want to the locale file, and it will get caught here.
    # E.g., in your locale file, create a
    #   name:
    #     girls_name: ["Alice", "Cheryl", "Tatiana"]
    # Then you can call Faker::Name.girls_name and it will act like #first_name
    #
    # source://faker//lib/faker.rb#191
    def method_missing(mth, *args, &block); end

    # by default numerify results do not start with a zero
    #
    # source://faker//lib/faker.rb#51
    def numerify(number_string, leading_zero: T.unsafe(nil)); end

    # Load formatted strings from the locale, "parsing" them
    # into method calls that can be used to generate a
    # formatted translation: e.g., "#{first_name} #{last_name}".
    #
    # source://faker//lib/faker.rb#125
    def parse(key); end

    # source://faker//lib/faker.rb#245
    def rand(max = T.unsafe(nil)); end

    # Generates a random value between the interval
    #
    # source://faker//lib/faker.rb#206
    def rand_in_range(from, to); end

    # Given a regular expression, attempt to generate a string
    # that would match it.  This is a rather simple implementation,
    # so don't be shocked if it blows up on you in a spectacular fashion.
    #
    # It does not handle ., *, unbounded ranges such as {1,},
    # extensions such as (?=), character classes, some abbreviations
    # for character classes, and nested parentheses.
    #
    # I told you it was simple. :) It's also probably dog-slow,
    # so you shouldn't use it.
    #
    # It will take a regex like this:
    #
    # /^[A-PR-UWYZ0-9][A-HK-Y0-9][AEHMNPRTVXY0-9]?[ABEHMNPRVWXY0-9]? {1,2}[0-9][ABD-HJLN-UW-Z]{2}$/
    #
    # and generate a string like this:
    #
    # "U3V  3TP"
    #
    # source://faker//lib/faker.rb#84
    def regexify(reg); end

    # If an array or range is passed, a random value will be selected.
    # All other values are simply returned.
    #
    # source://faker//lib/faker.rb#213
    def resolve(value); end

    # @return [Boolean]
    #
    # source://faker//lib/faker.rb#201
    def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end

    # source://faker//lib/faker.rb#229
    def sample(list, num = T.unsafe(nil)); end

    # source://faker//lib/faker.rb#241
    def shuffle(list); end

    # Call I18n.translate with our configured locale if no
    # locale is specified
    #
    # source://faker//lib/faker.rb#155
    def translate(*args, **opts); end

    # Return unique values from the generator every time.
    #
    # @param max_retries [Integer] The max number of retries that should be done before giving up.
    # @return [self]
    #
    # source://faker//lib/faker.rb#225
    def unique(max_retries = T.unsafe(nil)); end

    # Executes block with given locale set.
    #
    # source://faker//lib/faker.rb#171
    def with_locale(tmp_locale = T.unsafe(nil), &block); end
  end
end

module Faker::Base58
  class << self
    # source://faker//lib/helpers/base58.rb#5
    def encode(str); end
  end
end

# source://faker//lib/faker.rb#42
Faker::Base::LLetters = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker.rb#43
Faker::Base::Letters = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker.rb#40
Faker::Base::Numbers = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker.rb#41
Faker::Base::ULetters = T.let(T.unsafe(nil), Array)

class Faker::Beer < ::Faker::Base
  class << self
    # Produces a random beer alcohol percentage.
    #
    # @example
    #   Faker::Beer.alcohol #=> "5.4%"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#95
    def alcohol; end

    # Produces a random beer blg level.
    #
    # @example
    #   Faker::Beer.blg #=> "5.1Blg"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#108
    def blg; end

    # Produces a random beer hops.
    #
    # @example
    #   Faker::Beer.hop #=> "Sterling"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#43
    def hop; end

    # Produces a random beer IBU.
    #
    # @example
    #   Faker::Beer.ibu #=> "87 IBU"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#82
    def ibu; end

    # Produces a random beer malt.
    #
    # @example
    #   Faker::Beer.malts #=> "Munich"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#69
    def malts; end

    # Produces a random beer name.
    #
    # @example
    #   Faker::Beer.name #=> "Pliny The Elder"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#17
    def name; end

    # Produces a random beer style.
    #
    # @example
    #   Faker::Beer.style #=> "Wood-aged Beer"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#30
    def style; end

    # Produces a random beer yeast.
    #
    # @example
    #   Faker::Beer.yeast #=> "5335 - Lactobacillus"
    # @return [String]
    #
    # source://faker//lib/faker/default/beer.rb#56
    def yeast; end
  end
end

class Faker::Blockchain; end

class Faker::Blockchain::Aeternity < ::Faker::Base
  class << self
    # Produces a random Aeternity wallet address
    #
    # @example
    #   Faker::Blockchain::Aeternity.address
    #   #=> "ak_zvU8YQLagjcfng7Tg8yCdiZ1rpiWNp1PBn3vtUs44utSvbJVR"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/aeternity.rb#16
    def address; end

    # Produces a random Aeternity contract
    #
    # @example
    #   Faker::Blockchain::Aeternity.contract
    #   #=> "ct_Hk2JsNeWGEYQEHHQCfcBeGrwbhtYSwFTPdDhW2SvjFYVojyhW"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/aeternity.rb#42
    def contract; end

    # Produces a random Aeternity oracle
    #
    # @example
    #   Faker::Blockchain::Aeternity.oracle
    #   #=> "ok_28QDg7fkF5qiKueSdUvUBtCYPJdmMEoS73CztzXCRAwMGKHKZh"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/aeternity.rb#55
    def oracle; end

    # Produces a random Aeternity transaction
    #
    # @example
    #   Faker::Blockchain::Aeternity.transaction
    #   #=> "th_147nDP22h3pHrLt2qykTH4txUwQh1ccaXp"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/aeternity.rb#29
    def transaction; end

    protected

    # source://faker//lib/faker/blockchain/aeternity.rb#61
    def rand_strings(length = T.unsafe(nil)); end
  end
end

class Faker::Blockchain::Bitcoin < ::Faker::Base
  class << self
    # Produces a Bitcoin wallet address
    #
    # @example
    #   Faker::Blockchain::Bitcoin.address
    #   #=> "147nDP22h3pHrLt2qykTH4txUwQh1ccaXp"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/bitcoin.rb#26
    def address; end

    # Produces a Bitcoin testnet address
    #
    # @example
    #   Faker::Blockchain::Bitcoin.testnet_address
    #   #=> "n4YjRyYD6V6zREpk6opqESDqD3KYnMdVEB"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/bitcoin.rb#40
    def testnet_address; end

    protected

    # Generates a random Bitcoin address for the given network
    #
    # @param network [Symbol] The name of network protocol to generate an address for
    # @return [String] A Bitcoin address
    #
    # source://faker//lib/faker/blockchain/bitcoin.rb#51
    def address_for(network); end
  end
end

class Faker::Blockchain::Ethereum < ::Faker::Base
  class << self
    # Produces a random Ethereum wallet address
    #
    # @example
    #   Faker::Blockchain::Ethereum.address
    #   #=> "0xd392b0c0500700d02d27ab30805ec80ddd3320ff"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/ethereum.rb#17
    def address; end
  end
end

class Faker::Blockchain::Tezos < ::Faker::Base
  class << self
    # Produces a random Tezos account address
    #
    # @example
    #   Faker::Blockchain::Tezos.account
    #   #=> "tz1eUsgK6aj752Fbxwk5sAoEFvSDnPjZ4qvk"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#31
    def account; end

    # Produces a random Tezos block
    #
    # @example
    #   Faker::Blockchain::Tezos.block
    #   #=> "BMbhs2rkY1dvAkAyRytvPsjFQ2RiPrBhYkxvWpY65dzkdSuw58a"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#73
    def block; end

    # Produces a random Tezos contract
    #
    # @example
    #   Faker::Blockchain::Tezos.contract
    #   #=> "KT1MroqeP15nnitB4CnNfkqHYa2NErhPPLWF"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#45
    def contract; end

    # Produces a random Tezos operation
    #
    # @example
    #   Faker::Blockchain::Tezos.operation
    #   #=> "onygWYXJX3xNstFLv9PcCrhQdCkENC795xwSinmTEc1jsDN4VDa"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#59
    def operation; end

    # Produces a random Tezos public key
    #
    # @example
    #   Faker::Blockchain::Tezos.public_key
    #   #=> "edpkuib9x8QXRc5nWwHUg7U1dXsVmaUrUNU5sX9pVEEvwbMVdfMCeq"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#101
    def public_key; end

    # Produces a random Tezos public key
    #
    # @example
    #   Faker::Blockchain::Tezos.secret_key
    #   #=> "edsk3HZCAGEGpzQPnQUwQeFY4ESanFhQCgLpKriQw8GHyhKCrjHawv"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#115
    def secret_key; end

    # Produces a random Tezos signature
    #
    # @example
    #   Faker::Blockchain::Tezos.signature
    #   #=> "edsigu165B7VFf3Dpw2QABVzEtCxJY2gsNBNcE3Ti7rRxtDUjqTFRpg67EdAQmY6YWPE5tKJDMnSTJDFu65gic8uLjbW2YwGvAZ"
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#87
    def signature; end

    protected

    # @param prefix [Symbol]
    # @param payload_size [Integer] The size of the payload
    # @return [String]
    #
    # source://faker//lib/faker/blockchain/tezos.rb#126
    def encode_tz(prefix, payload_size); end
  end
end

class Faker::Blood < ::Faker::Base
  class << self
    # Produces a random blood group name.
    #
    # @example
    #   Faker::Blood.group #=> "AB-"
    # @return [String]
    #
    # source://faker//lib/faker/default/blood.rb#43
    def group; end

    # Produces a random blood RH-Factor.
    #
    # @example
    #   Faker::Blood.rh_factor #=> "-"
    # @return [String]
    #
    # source://faker//lib/faker/default/blood.rb#30
    def rh_factor; end

    # Produces a random blood type.
    #
    # @example
    #   Faker::Blood.type #=> "AB"
    # @return [String]
    #
    # source://faker//lib/faker/default/blood.rb#17
    def type; end
  end
end

class Faker::Book < ::Faker::Base
  class << self
    # Produces a random book author
    #
    # @example
    #   Faker::Book.author #=> "Alysha Olsen"
    # @return [String]
    #
    # source://faker//lib/faker/books/book.rb#30
    def author; end

    # Produces a random genre
    #
    # @example
    #   Faker::Book.genre #=> "Mystery"
    # @return [String]
    #
    # source://faker//lib/faker/books/book.rb#56
    def genre; end

    # Produces a random book publisher
    #
    # @example
    #   Faker::Book.publisher #=> "Opus Reader"
    # @return [String]
    #
    # source://faker//lib/faker/books/book.rb#43
    def publisher; end

    # Produces a random book title
    #
    # @example
    #   Faker::Book.title #=> "The Odd Sister"
    # @return [String]
    #
    # source://faker//lib/faker/books/book.rb#17
    def title; end
  end
end

class Faker::Books; end

class Faker::Books::CultureSeries < ::Faker::Base
  class << self
    # @example
    #   Faker::Books::CultureSeries.book
    #   #=> "The Player of Games"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#17
    def book; end

    # @example
    #   Faker::Books::CultureSeries.civ
    #   #=> "Culture"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#65
    def civ; end

    # @example
    #   Faker::Books::CultureSeries.culture_ship
    #   #=> "Fate Amenable To Change"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#29
    def culture_ship; end

    # @example
    #   Faker::Books::CultureSeries.culture_ship_class
    #   #=> "General Systems Vehicle"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#41
    def culture_ship_class; end

    # @example
    #   Faker::Books::CultureSeries.culture_ship_class_abv
    #   #=> "The Odd Sister"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#53
    def culture_ship_class_abv; end

    # @example
    #   Faker::Books::CultureSeries.planet
    #   #=> "Xinth"
    # @return [String]
    #
    # source://faker//lib/faker/books/culture_series.rb#77
    def planet; end
  end
end

# A Faker module beyond your dreams, test data beyond your imagination.
class Faker::Books::Dune < ::Faker::Base
  class << self
    # Produces the name of a character from Dune
    #
    # @example
    #   Faker::Books::Dune.character #=> "Leto Atreides"
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#18
    def character; end

    # Produces the name of a city from Dune
    #
    # @example
    #   Faker::Books::Dune.city #=> "Arrakeen"
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#42
    def city; end

    # Produces the name of a planet from Dune
    #
    # @example
    #   Faker::Books::Dune.planet #=> "Caladan"
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#55
    def planet; end

    # Produces a quote from Dune
    #
    # @example
    #   Faker::Books::Dune.quote
    #   #=> "A dead man, surely, no longer requires that water."
    # @example
    #   Faker::Books::Dune.quote(character: "baron_harkonnen")
    #   #=> "He who controls the spice, controls the universe!"
    # @param character [String] The name of the character that the quote should be from
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#74
    def quote(character: T.unsafe(nil)); end

    # Produces a saying from Dune
    #
    # @example
    #   Faker::Books::Dune.saying #=> "You do not beg the sun for mercy."
    # @example
    #   Faker::Books::Dune.saying(source: "fremen")
    #   #=> "May thy knife chip and shatter."
    # @param source [String]
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#105
    def saying(source: T.unsafe(nil)); end

    # @example
    #   Faker::Books::Dune.title #=> "Duke"
    # @return [String]
    #
    # source://faker//lib/faker/books/dune.rb#29
    def title; end
  end
end

class Faker::Books::Lovecraft < ::Faker::Base
  class << self
    # Produces the name of a deity
    #
    # @example
    #   Faker::Books::Lovecraft.deity #=> "Shub-Niggurath"
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#45
    def deity; end

    # @example
    #   Faker::Books::Lovecraft.fhtagn
    #   #=> "Ph'nglui mglw'nafh Cthulhu R'lyeh wgah'nagl fhtagn"
    # @example
    #   Faker::Books::Lovecraft.fhtagn(number: 3)
    #   #=> "Ph'nglui mglw'nafh Cthulhu R'lyeh wgah'nagl fht...
    # @param number [Integer] The number of times to repeat the chant
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#32
    def fhtagn(number: T.unsafe(nil)); end

    # Produces the name of a location
    #
    # @example
    #   Faker::Books::Lovecraft.location #=> "Kingsport"
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#16
    def location; end

    # Produces a random paragraph
    #
    # @example
    #   Faker::Books::Lovecraft.paragraph
    #   #=> "Squamous nameless daemoniac fungus ululate. Cyclopean stygian decadent loathsome manuscript tenebrous. Foetid abnormal stench. Dank non-euclidean comprehension eldritch. Charnel singular shunned lurk effulgence fungus."
    # @example
    #   Faker::Books::Lovecraft.paragraph(sentence_count: 2)
    #   #=> "Decadent lurk tenebrous loathsome furtive spectral amorphous gibbous. Gambrel eldritch daemoniac cat madness comprehension stygian effulgence."
    # @example
    #   Faker::Books::Lovecraft.paragraph(sentence_count: 1, random_sentences_to_add: 1)
    #   #=> "Stench cyclopean fainted antiquarian nameless. Antiquarian ululate tenebrous non-euclidean effulgence."
    # @param sentence_count [Integer] Number of sentences to generate
    # @param random_sentences_to_add [Integer]
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#192
    def paragraph(sentence_count: T.unsafe(nil), random_sentences_to_add: T.unsafe(nil)); end

    # @example
    #   Faker::Books::Lovecraft.paragraph_by_chars
    #   #=> "Truffaut stumptown trust fund 8-bit messenger bag portland. Meh kombucha selvage swag biodiesel. Lomo kinfolk jean shorts asymmetrical diy. Wayfarers portland twee stumptown. Wes anderson biodiesel retro 90's pabst. Diy echo 90's mixtape semiotics. Cornho."
    # @example
    #   Faker::Books::Lovecraft.paragraph_by_chars(characters: 128)
    #   #=> "Effulgence madness noisome. Fungus stygian mortal madness amorphous dank. Decadent noisome hideous effulgence. Tentacles charne."
    # @param characters [Integer] Number of characters to generate in the paragraph
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#239
    def paragraph_by_chars(characters: T.unsafe(nil)); end

    # Produces a array of random paragraphs
    #
    # @example
    #   Faker::Books::Lovecraft.paragraphs
    #   #=> [
    #   #     "Noisome daemoniac gibbous abnormal antediluvian. Unutterable fung...
    #   #     "Non-euclidean immemorial indescribable accursed furtive. Dank unn...
    #   #     "Charnel antediluvian unnamable cat blasphemous comprehension tene...
    #   #   ]
    # @example
    #   Faker::Books::Lovecraft.paragraphs(number: 2)
    #   #=> [
    #   #     "Hideous amorphous manuscript antediluvian non-euclidean cat eldri...
    #   #     "Tenebrous unnamable comprehension antediluvian lurk. Lurk spectra...
    #   #   ]
    # @param number [Integer] Number of paragraphs to generate
    # @return [Array<String>]
    #
    # source://faker//lib/faker/books/lovecraft.rb#218
    def paragraphs(number: T.unsafe(nil)); end

    # Produces a random sentence
    #
    # @example
    #   Faker::Books::Lovecraft.sentence
    #   #=> "Furtive antiquarian squamous dank cat loathsome amorphous lurk."
    # @example
    #   Faker::Books::Lovecraft.sentence(word_count: 3)
    #   #=> "Daemoniac antediluvian fainted squamous comprehension gambrel nameless singular."
    # @example
    #   Faker::Books::Lovecraft.sentence(word_count: 3, random_words_to_add: 1)
    #   #=> "Amorphous indescribable tenebrous."
    # @example
    #   Faker::Books::Lovecraft.sentence(word_count: 3, random_words_to_add: 0, open_compounds_allowed: true)
    #   #=> "Effulgence unmentionable gambrel."
    # @param word_count [Integer] The number of words to have in the sentence
    # @param random_words_to_add [Integer]
    # @param open_compounds_allowed [Boolean] If true, generated sentence can contain words having additional spaces
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#85
    def sentence(word_count: T.unsafe(nil), random_words_to_add: T.unsafe(nil), open_compounds_allowed: T.unsafe(nil)); end

    # Produces a array of random sentences
    #
    # @example
    #   Faker::Books::Lovecraft.sentences
    #   #=> [
    #   #     "Nameless loathsome decadent gambrel.",
    #   #     "Ululate swarthy immemorial cat madness gibbous unmentionable unnamable.",
    #   #     "Decadent antediluvian non-euclidean tentacles amorphous tenebrous.",
    #   #   ]
    # @example
    #   Faker::Books::Lovecraft.sentences(number: 2)
    #   #=> [
    #   #     "Antediluvian amorphous unmentionable singular accursed squamous immemorial.",
    #   #     "Gambrel daemoniac gibbous stygian shunned ululate iridescence abnormal.",
    #   #   ]
    # @param number [Integer] Number of sentences to generate
    # @return [Array<String>]
    #
    # source://faker//lib/faker/books/lovecraft.rb#165
    def sentences(number: T.unsafe(nil)); end

    # Produces the name of a tome
    #
    # @example
    #   Faker::Books::Lovecraft.tome #=> "Book of Eibon"
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#58
    def tome; end

    # Produces a random word
    #
    # @example
    #   Faker::Books::Lovecraft.word #=> "furtive"
    # @return [String]
    #
    # source://faker//lib/faker/books/lovecraft.rb#98
    def word; end

    # Produces a array of random words
    #
    # @example
    #   Faker::Books::Lovecraft.words
    #   #=> [
    #   #     "manuscript",
    #   #     "abnormal",
    #   #     "singular",
    #   #   ]
    # @example
    #   Faker::Books::Lovecraft.words(number: 2)
    #   #=> [
    #   #     "daemoniac",
    #   #     "cat",
    #   #   ]
    # @example
    #   Faker::Books::Lovecraft.words(number: 2, spaces_allowed: 1)
    #   #=> [
    #   #     "lurk",
    #   #     "charnel",
    #   #   ]
    # @param number [Integer] Number of words to generate
    # @param spaces_allowed [Boolean] If true, generated words can contain spaces
    # @return [Array<String>]
    #
    # source://faker//lib/faker/books/lovecraft.rb#132
    def words(number: T.unsafe(nil), spaces_allowed: T.unsafe(nil)); end
  end
end

class Faker::Books::TheKingkillerChronicle < ::Faker::Base
  class << self
    # Produces the name of a The Kingkiller Chronicle book.
    #
    # @example
    #   Faker::Books::TheKingkillerChronicle.book #=> "The Name of the Wind"
    # @return [String]
    #
    # source://faker//lib/faker/books/the_kingkiller_chronicle.rb#16
    def book; end

    # Produces the name of a The Kingkiller Chronicle character.
    #
    # @example
    #   Faker::Books::TheKingkillerChronicle.character #=> "Kvothe"
    # @return [String]
    #
    # source://faker//lib/faker/books/the_kingkiller_chronicle.rb#29
    def character; end

    # Produces the name of a The Kingkiller Chronicle creature.
    #
    # @example
    #   Faker::Books::TheKingkillerChronicle.creature #=> "Scrael"
    # @return [String]
    #
    # source://faker//lib/faker/books/the_kingkiller_chronicle.rb#42
    def creature; end

    # Produces the name of a The Kingkiller Chronicle location.
    #
    # @example
    #   Faker::Books::TheKingkillerChronicle.location #=> "Tarbean"
    # @return [String]
    #
    # source://faker//lib/faker/books/the_kingkiller_chronicle.rb#55
    def location; end
  end
end

class Faker::Boolean < ::Faker::Base
  class << self
    # Produces a boolean
    #
    # @example
    #   Faker::Boolean.boolean #=> true
    # @example
    #   Faker::Boolean.boolean(true_ratio: 0.2) #=> false
    # @param true_ratio [Float] The likelihood (as a float, out of 1.0) for the method to return `true`.
    # @return [Boolean]
    #
    # source://faker//lib/faker/default/boolean.rb#18
    def boolean(true_ratio: T.unsafe(nil)); end
  end
end

class Faker::BossaNova < ::Faker::Base
  class << self
    # Produces the name of a bossa nova artist.
    #
    # @example
    #   Faker::BossaNova.artist #=> "Tom Jobin"
    # @return [String]
    #
    # source://faker//lib/faker/default/bossa_nova.rb#15
    def artist; end

    # Produces a bossa nova song.
    #
    # @example
    #   Faker::BossaNova.song #=> "Chega de Saudade"
    # @return [String]
    #
    # source://faker//lib/faker/default/bossa_nova.rb#28
    def song; end
  end
end

class Faker::Business < ::Faker::Base
  class << self
    # Produces a credit card expiration date.
    #
    # @example
    #   Faker::Business.credit_card_expiry_date #=> <Date: 2015-11-11 ((2457338j,0s,0n),+0s,2299161j)>
    # @return [Date]
    #
    # source://faker//lib/faker/default/business.rb#32
    def credit_card_expiry_date; end

    # Produces a credit card number.
    #
    # @example
    #   Faker::Business.credit_card_number #=> "1228-1221-1221-1431"
    # @return [String]
    #
    # source://faker//lib/faker/default/business.rb#19
    def credit_card_number; end

    # Produces a type of credit card.
    #
    # @example
    #   Faker::Business.credit_card_type #=> "visa"
    # @return [String]
    #
    # source://faker//lib/faker/default/business.rb#45
    def credit_card_type; end
  end
end

class Faker::Camera < ::Faker::Base
  class << self
    # Produces a brand of a camera
    #
    # @example
    #   Faker::Camera.brand #=> "Canon"
    # @return [String]
    #
    # source://faker//lib/faker/default/camera.rb#15
    def brand; end

    # Produces a brand with model
    #
    # @example
    #   Faker::Camera.brand_with_model #=> "Canon 450D"
    # @return [String]
    #
    # source://faker//lib/faker/default/camera.rb#41
    def brand_with_model; end

    # Produces a model of camera
    #
    # @example
    #   Faker::Camera.model #=> "450D"
    # @return [String]
    #
    # source://faker//lib/faker/default/camera.rb#28
    def model; end
  end
end

class Faker::Cannabis < ::Faker::Base
  class << self
    # Produces a random brand.
    #
    # @example
    #   Faker::Cannabis.brand #=> "Cannavore Confections"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#131
    def brand; end

    # Produces a random buzzword.
    #
    # @example
    #   Faker::Cannabis.buzzword #=> "high"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#118
    def buzzword; end

    # Produces a random cannabinoid type.
    #
    # @example
    #   Faker::Cannabis.cannabinoid #=> "Cannabinolic Acid"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#40
    def cannabinoid; end

    # Produces a random abbreviation.
    #
    # @example
    #   Faker::Cannabis.cannabinoid_abbreviation #=> "CBGa"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#27
    def cannabinoid_abbreviation; end

    # Produces a random category.
    #
    # @example
    #   Faker::Cannabis.category #=> "crystalline"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#92
    def category; end

    # Produces a random health benefit.
    #
    # @example
    #   Faker::Cannabis.health_benefit #=> "prevents infection"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#79
    def health_benefit; end

    # Produces a random kind of medical use.
    #
    # @example
    #   Faker::Cannabis.medical_use #=> "anti-cancer"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#66
    def medical_use; end

    # Produces a random strain.
    #
    # @example
    #   Faker::Cannabis.strain #=> "Super Glue"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#14
    def strain; end

    # Produces a random terpene type.
    #
    # @example
    #   Faker::Cannabis.terpene #=> "Terpinene"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#53
    def terpene; end

    # Produces a random type.
    #
    # @example
    #   Faker::Cannabis.type #=> "indica"
    # @return [String]
    #
    # source://faker//lib/faker/default/cannabis.rb#105
    def type; end
  end
end

module Faker::Char
  class << self
    # source://faker//lib/helpers/char.rb#11
    def fix_umlauts(string); end

    # source://faker//lib/helpers/char.rb#5
    def prepare(string); end

    # source://faker//lib/helpers/char.rb#23
    def romanize_cyrillic(string); end
  end
end

class Faker::ChileRut < ::Faker::Base
  class << self
    # Produces a random Chilean digito verificador (check-digit).
    # Alias for english speaking devs.
    #
    # @example
    #   Faker::ChileRut.check_digit #=> "5"
    # @return [String]
    #
    # source://faker//lib/faker/default/chile_rut.rb#64
    def check_digit; end

    # Produces a random Chilean digito verificador (check-digit).
    #
    # @example
    #   Faker::ChileRut.dv #=> "k"
    # @return [String]
    #
    # source://faker//lib/faker/default/chile_rut.rb#34
    def dv; end

    # Produces a random Chilean RUT (Rol Unico Tributario, ID with 8 digits) with a dv (digito verificador, check-digit).
    #
    # @example
    #   Faker::ChileRut.full_rut #=> "30686957-4"
    #   Faker::ChileRut.full_rut(min_rut: 20890156) #=> "30686957-4"
    #   Faker::ChileRut.full_rut(min_rut: 30686957, fixed: true) #=> "30686957-4"
    # @param min_rut [Integer] Specifies the minimum value of the rut.
    # @param fixed [Boolean] Determines if the rut is fixed (returns the min_rut value).
    # @return [String]
    #
    # source://faker//lib/faker/default/chile_rut.rb#81
    def full_rut(min_rut: T.unsafe(nil), fixed: T.unsafe(nil), formatted: T.unsafe(nil)); end

    # Returns the value of attribute last_rut.
    #
    # source://faker//lib/faker/default/chile_rut.rb#89
    def last_rut; end

    # Produces a random Chilean RUT (Rol Unico Tributario, ID with 8 digits).
    #
    # @example
    #   Faker::ChileRut.rut #=> 11235813
    #   Faker::ChileRut.rut(min_rut: 20890156) #=> 31853211
    #   Faker::ChileRut.rut(min_rut: 20890156, fixed: true) #=> 20890156
    # @param min_rut [Integer] Specifies the minimum value of the rut.
    # @param fixed [Boolean] Determines if the rut is fixed (returns the min_rut value).
    # @return [Number]
    #
    # source://faker//lib/faker/default/chile_rut.rb#21
    def rut(min_rut: T.unsafe(nil), fixed: T.unsafe(nil)); end
  end
end

class Faker::ChuckNorris < ::Faker::Base
  class << self
    # Produces a Chuck Norris Fact.
    # Original list of facts:
    # https://github.com/jenkinsci/chucknorris-plugin/blob/master/src/main/java/hudson/plugins/chucknorris/FactGenerator.java
    #
    # @example
    #   Faker::ChuckNorris.fact
    #   #=> "Chuck Norris can solve the Towers of Hanoi in one move."
    # @return [String]
    #
    # source://faker//lib/faker/default/chuck_norris.rb#20
    def fact; end
  end
end

class Faker::Code < ::Faker::Base
  class << self
    # Retrieves a real Amazon ASIN code from https://archive.org/details/asin_listing
    #
    # @example
    #   Faker::Code.asin #=> "B000MZW1GE"
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#125
    def asin; end

    # Produces a random EAN (European Article Number) code.
    #
    # @example
    #   Faker::Code.ean(base: 8) #=> "36941070"
    # @example
    #   Faker::Code.ean #=> "9941880131907"
    # @param base [Integer] the length of the code to generate (either 8 or 13)
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#52
    def ean(base: T.unsafe(nil)); end

    # Produces a random IMEI (International Mobile Equipment Number) code.
    #
    # @example
    #   Faker::Code.imei #=> "492033129092256"
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#112
    def imei; end

    # Produces a random ISBN (International Standard Book Number) code.
    #
    # @example
    #   Faker::Code.isbn(base: 13) #=> "896579606969-8"
    # @example
    #   Faker::Code.isbn #=> "170366802-2"
    # @param base [Integer] the length of the code to generate (either 10 or 13)
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#32
    def isbn(base: T.unsafe(nil)); end

    # Produces a random NPI (National Provider Identifier) code.
    #
    # @example
    #   Faker::Code.npi #=> "9804062802"
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#16
    def npi; end

    # Produces a random NRIC (National Registry Identity Card) code.
    # By default generates a Singaporean NRIC ID for someone
    # who is born between the age of 18 and 65.
    #
    # @example
    #   Faker::Code.nric(min_age: 25, max_age: 50) #=> "S9347283G"
    # @example
    #   Faker::Code.nric(max_age: 55) #=> "S7876903C"
    # @example
    #   Faker::Code.nric(min_age: 25) #=> "S6281697Z"
    # @example
    #   Faker::Code.nric #=> "S6372958B"
    # @param min_age [Integer] the min age of the person in years
    # @param max_age [Integer] the max age of the person in years
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#94
    def nric(min_age: T.unsafe(nil), max_age: T.unsafe(nil)); end

    # Produces a random RUT (Rol Unico Nacional) code.
    #
    # @example
    #   Faker::Code.rut #=> "91611842-2"
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#69
    def rut; end

    # Produces a random SIN (Social Insurance Number for Canada) code.
    #
    # @example
    #   Faker::Code.sin #=> "996586962"
    # @return [String]
    #
    # source://faker//lib/faker/default/code.rb#138
    def sin; end

    private

    # source://faker//lib/faker/default/code.rb#199
    def generate_base10_isbn; end

    # source://faker//lib/faker/default/code.rb#223
    def generate_base13_ean; end

    # source://faker//lib/faker/default/code.rb#205
    def generate_base13_isbn; end

    # source://faker//lib/faker/default/code.rb#217
    def generate_base8_ean; end

    # source://faker//lib/faker/default/code.rb#160
    def generate_imei; end

    # source://faker//lib/faker/default/code.rb#237
    def generate_nric_check_alphabet(values, prefix); end

    # source://faker//lib/faker/default/code.rb#244
    def generate_sin_check_digit(digits); end

    # source://faker//lib/faker/default/code.rb#232
    def rut_verificator_digit(rut); end

    # source://faker//lib/faker/default/code.rb#211
    def sum(values); end
  end
end

class Faker::Coffee < ::Faker::Base
  class << self
    # Produces a random blend name.
    #
    # @example
    #   Faker::Coffee.blend_name #=> "Major Java"
    # @return [String]
    #
    # source://faker//lib/faker/default/coffee.rb#17
    def blend_name; end

    # Produces a random coffee taste intensity.
    #
    # @example
    #   Faker::Coffee.intensifier #=> "mild"
    # @return [String]
    #
    # source://faker//lib/faker/default/coffee.rb#71
    def intensifier; end

    # Produces a string containing a random description of a coffee's taste.
    #
    # @example
    #   Faker::Coffee.notes #=> "dull, tea-like, cantaloupe, soy sauce, marshmallow"
    # @return [String]
    #
    # source://faker//lib/faker/default/coffee.rb#58
    def notes; end

    # Produces a random coffee origin place.
    #
    # @example
    #   Faker::Coffee.origin #=> "Oaxaca, Mexico"
    # @return [String]
    #
    # source://faker//lib/faker/default/coffee.rb#30
    def origin; end

    # Produces a random coffee variety.
    #
    # @example
    #   Faker::Coffee.variety #=> "Red Bourbon"
    # @return [String]
    #
    # source://faker//lib/faker/default/coffee.rb#45
    def variety; end

    private

    # source://faker//lib/faker/default/coffee.rb#77
    def search_format(key); end
  end
end

class Faker::Coin < ::Faker::Base
  class << self
    # Retrieves a face to a flipped coin
    #
    # @example
    #   Faker::Coin.flip #=> "Heads"
    # @return [String]
    #
    # source://faker//lib/faker/default/coin.rb#28
    def flip; end

    # Retrieves a random coin from any country.
    #
    # @example
    #   Faker::Coin.name #=> "Brazilian Real"
    # @return [String]
    #
    # source://faker//lib/faker/default/coin.rb#15
    def name; end
  end
end

class Faker::Color < ::Faker::Base
  class << self
    # Produces the name of a color.
    #
    # @example
    #   Faker::Color.color_name #=> "yellow"
    # @return [String]
    #
    # source://faker//lib/faker/default/color.rb#45
    def color_name; end

    # Produces a hex color code.
    # Clients are able to specify the hue, saturation, or lightness of the required color.
    # Alternatively a client can simply specify that they need a light or dark color.
    #
    # @example
    #   Faker::Color.hex_color #=> "#31a785"
    # @example
    #   Faker::Color.hex_color(hue: 118, saturation: 1, lightness: 0.53) #=> "#048700"
    # @example
    #   Faker::Color.hex_color(:light) #=> "#FFEE99"
    # @example
    #   Faker::Color.hex_color(:dark) #=> "#665500"
    # @param args [Hash, Symbol] Allows the client to specify what color should be return
    # @return [String]
    #
    # source://faker//lib/faker/default/color.rb#29
    def hex_color(args = T.unsafe(nil)); end

    # Produces an array of floats representing an HSL color.
    # The array is in the form of `[hue, saturation, lightness]`.
    #
    # @example
    #   Faker::Color.hsl_color #=> [69.87, 0.66, 0.3]
    # @example
    #   Faker::Color.hsl_color(hue: 70, saturation: 0.5, lightness: 0.8) #=> [70, 0.5, 0.8]
    # @example
    #   Faker::Color.hsl_color(hue: 70) #=> [70, 0.66, 0.6]
    # @example
    #   Faker::Color.hsl_color(saturation: 0.2) #=> [54, 0.2, 0.3]
    # @example
    #   Faker::Color.hsl_color(lightness: 0.6) #=> [69.87, 0.66, 0.6]
    # @param hue [FLoat] Optional value to use for hue
    # @param saturation [Float] Optional value to use for saturation
    # @param lightness [Float] Optional value to use for lightness
    # @return [Array(Float, Float, Float)]
    #
    # source://faker//lib/faker/default/color.rb#88
    def hsl_color(hue: T.unsafe(nil), saturation: T.unsafe(nil), lightness: T.unsafe(nil)); end

    # Produces an array of floats representing an HSLA color.
    # The array is in the form of `[hue, saturation, lightness, alpha]`.
    #
    # @example
    #   Faker::Color.hsla_color #=> [154.77, 0.36, 0.9, 0.2]
    # @return [Array(Float, Float, Float, Float)]
    #
    # source://faker//lib/faker/default/color.rb#105
    def hsla_color; end

    # Produces an array of integers representing an RGB color.
    #
    # @example
    #   Faker::Color.rgb_color #=> [54, 233, 67]
    # @return [Array(Integer, Integer, Integer)]
    #
    # source://faker//lib/faker/default/color.rb#63
    def rgb_color; end

    # @private
    #
    # source://faker//lib/faker/default/color.rb#50
    def single_rgb_color; end

    private

    # Produces a hex code representation of an HSL color
    #
    # @example
    #   hsl_to_hex([50, 100,80]) #=> #FFEE99
    # @param a_hsl_color [Array(Float, Float, Float)] The array that represents the HSL color
    # @return [String]
    # @see https://en.wikipedia.org/wiki/HSL_and_HSV#HSL_to_RGB
    # @see https://github.com/jpmckinney/color-generator/blob/master/lib/color-generator.rb
    #
    # source://faker//lib/faker/default/color.rb#124
    def hsl_to_hex(a_hsl_color); end
  end
end

class Faker::Commerce < ::Faker::Base
  class << self
    # Produces a randomized string of a brand name
    #
    # @example
    #   Faker::Commerce.brand #=> 'Apple'
    # @return [string]
    #
    # source://faker//lib/faker/default/commerce.rb#125
    def brand; end

    # Produces a random color.
    #
    # @example
    #   Faker::Commerce.color #=> "lavender"
    # @return [String]
    #
    # source://faker//lib/faker/default/commerce.rb#15
    def color; end

    # Produces a random department.
    #
    # @example
    #   Faker::Commerce.department #=> "Grocery, Health & Beauty"
    #   Faker::Commerce.department(max: 5) #=> "Grocery, Books, Health & Beauty"
    #   Faker::Commerce.department(max: 2, fixed_amount: true) #=> "Books & Tools"
    # @param max [Integer] Updates the maximum number of names used to generate the department name.
    # @param fixed_amount [Boolean] Fixes the amount of departments to use instead of using a range.
    # @return [String]
    #
    # source://faker//lib/faker/default/commerce.rb#51
    def department(max: T.unsafe(nil), fixed_amount: T.unsafe(nil)); end

    # Produces a random material.
    #
    # @example
    #   Faker::Commerce.material #=> "Plastic"
    # @return [String]
    #
    # source://faker//lib/faker/default/commerce.rb#90
    def material; end

    # Produces a random product price.
    #
    # @example
    #   Faker::Commerce.price #=> 44.6
    #   Faker::Commerce.price(range: 0..10.0, as_string: true) #=> "2.18"
    # @param range [Range] A range to generate the random number within.
    # @param as_string [Boolean] Changes the return value to [String].
    # @return [Float]
    #
    # source://faker//lib/faker/default/commerce.rb#106
    def price(range: T.unsafe(nil), as_string: T.unsafe(nil)); end

    # Produces a random product name.
    #
    # @example
    #   Faker::Commerce.product_name #=> "Practical Granite Shirt"
    # @return [String]
    #
    # source://faker//lib/faker/default/commerce.rb#77
    def product_name; end

    # Produces a random promotion code.
    #
    # @example
    #   Faker::Commerce.promotion_code #=> "AmazingDeal829102"
    #   Faker::Commerce.promotion_code(digits: 2) #=> "AmazingPrice57"
    # @param digits [Integer] Updates the number of numerical digits used to generate the promotion code.
    # @return [String]
    #
    # source://faker//lib/faker/default/commerce.rb#30
    def promotion_code(digits: T.unsafe(nil)); end

    # Produces a randomized string of a vendor name
    #
    # @example
    #   Faker::Commerce.vendor #=> 'Dollar General'
    # @return [string]
    #
    # source://faker//lib/faker/default/commerce.rb#139
    def vendor; end

    private

    # source://faker//lib/faker/default/commerce.rb#145
    def categories(num); end

    # source://faker//lib/faker/default/commerce.rb#149
    def merge_categories(categories); end
  end
end

class Faker::Company < ::Faker::Base
  class << self
    # Produces a company australian business number.
    #
    # @example
    #   Faker::Company.australian_business_number #=> "93579396170"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#275
    def australian_business_number; end

    # Produces a company brazilian company number.
    #
    # @example
    #   Faker::Company.brazilian_company_number #=> "37205322000500"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#384
    def brazilian_company_number(formatted: T.unsafe(nil)); end

    # Produces some company BS.
    #
    # When a straight answer won't do, BS to the rescue!
    #
    # @example
    #   Faker::Company.bs #=> "empower customized functionalities"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#83
    def bs; end

    # Produces a company buzzword.
    #
    # @example
    #   Faker::Company.buzzword #=> "flexibility"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#69
    def buzzword; end

    # Produces a company catch phrase.
    #
    # @example
    #   Faker::Company.catch_phrase #=> "Grass-roots grid-enabled portal"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#56
    def catch_phrase; end

    # Produces a company czech organisation number.
    #
    # @example
    #   Faker::Company.czech_organisation_number #=> "90642741"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#205
    def czech_organisation_number; end

    # Produces a company duns number.
    #
    # @example
    #   Faker::Company.duns_number #=> "70-655-5105"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#109
    def duns_number; end

    # Produces a company EIN (Employer Identification Number).
    #
    # @example
    #   Faker::Company.ein #=> "07-4009024"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#96
    def ein; end

    # Produces a company french siren number.
    #
    # Get a random French SIREN number. See more here https://fr.wikipedia.org/wiki/Syst%C3%A8me_d%27identification_du_r%C3%A9pertoire_des_entreprises
    #
    # @example
    #   Faker::Company.french_siren_number #=> "163417827"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#226
    def french_siren_number; end

    # Produces a company french siret number.
    #
    # @example
    #   Faker::Company.french_siret_number #=> "76430067900496"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#240
    def french_siret_number; end

    # Produces a company industry.
    #
    # @example
    #   Faker::Company.industry #=> "Food & Beverages"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#43
    def industry; end

    # Produces a company logo.
    #
    # Get a random company logo url in PNG format.
    #
    # @example
    #   Faker::Company.logo #=> "https://pigment.github.io/fake-logos/logos/medium/color/12.png"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#123
    def logo; end

    # Produces a company name.
    #
    # @example
    #   Faker::Company.name #=> "Roberts Inc"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#17
    def name; end

    # Produces a company norwegian organisation number.
    #
    # Get a random Norwegian organization number. Info: https://www.brreg.no/om-oss/samfunnsoppdraget-vart/registera-vare/einingsregisteret/organisasjonsnummeret/
    #
    # @example
    #   Faker::Company.norwegian_organisation_number #=> "842457173"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#256
    def norwegian_organisation_number; end

    # Produces a company polish register of national economy.
    #
    # Get a random Polish register of national economy number. More info https://pl.wikipedia.org/wiki/REGON
    #
    # @example
    #   Faker::Company.polish_register_of_national_economy #=> "788435970"
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#312
    def polish_register_of_national_economy(length: T.unsafe(nil)); end

    # Produces a company polish taxpayer identification_number.
    #
    # Get a random Polish taxpayer identification number More info https://pl.wikipedia.org/wiki/NIP
    #
    # @example
    #   Faker::Company.polish_taxpayer_identification_number #=> "2767549463"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#292
    def polish_taxpayer_identification_number; end

    # Produces a company profession.
    #
    # @example
    #   Faker::Company.profession #=> "factory worker"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#150
    def profession; end

    # Get a random Russian tax number.
    #
    # @example
    #   Faker::Company.russian_tax_number                             #=> "0415584064"
    #   Faker::Company.russian_tax_number(region: 'AZ')               #=> "AZ50124562"
    #   Faker::Company.russian_tax_number(region: 'AZ', type: false)  #=> "AZ8802315465"
    # @param region [String] Any region string
    # @param type [Symbol] Legeal or not, defaults to :legal
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#411
    def russian_tax_number(region: T.unsafe(nil), type: T.unsafe(nil)); end

    # Produces a company sic code.
    #
    # @example
    #   Faker::Company.sic_code #=> "7383"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#424
    def sic_code; end

    # Produces a company south african close corporation registration number.
    #
    # @example
    #   Faker::Company.south_african_close_corporation_registration_number #=> "CK38/5739937418/23"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#345
    def south_african_close_corporation_registration_number; end

    # Produces a company south african listed company registration number.
    #
    # @example
    #   Faker::Company.south_african_listed_company_registration_number #=> "2512/87676/06"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#358
    def south_african_listed_company_registration_number; end

    # Produces a company south african pty ltd registration number.
    #
    # @example
    #   Faker::Company.south_african_pty_ltd_registration_number #=> "7043/2400717902/07"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#332
    def south_african_pty_ltd_registration_number; end

    # Produces a company south african trust registration number.
    #
    # @example
    #   Faker::Company.south_african_trust_registration_number #=> "IT5673/937519896"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#371
    def south_african_trust_registration_number; end

    # Produces a company spanish organisation number.
    #
    # Get a random Spanish organization number. See more here https://es.wikipedia.org/wiki/N%C3%BAmero_de_identificaci%C3%B3n_fiscal
    #
    # @example
    #   Faker::Company.spanish_organisation_number #=> "D6819358"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#165
    def spanish_organisation_number(organization_type: T.unsafe(nil)); end

    # Produces a company suffix.
    #
    # @example
    #   Faker::Company.suffix #=> "LLC"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#30
    def suffix; end

    # Produces a company swedish organisation number.
    #
    # Get a random Swedish organization number. See more here https://sv.wikipedia.org/wiki/Organisationsnummer
    #
    # @example
    #   Faker::Company.swedish_organisation_number #=> "3866029808"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#188
    def swedish_organisation_number; end

    # Produces a company type.
    #
    # @example
    #   Faker::Company.type #=> "Partnership"
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#137
    def type; end

    private

    # source://faker//lib/faker/default/company.rb#477
    def abn_checksum(abn); end

    # source://faker//lib/faker/default/company.rb#488
    def collect_regon_sum(array); end

    # source://faker//lib/faker/default/company.rb#537
    def inn_checksum(factor, number); end

    # For more on Russian tax number algorithm here:
    # https://ru.wikipedia.org/wiki/Идентификационный_номер_налогоплательщика#Вычисление_контрольных_цифр
    #
    # Range of regions:
    # https://ru.wikipedia.org/wiki/Коды_субъектов_Российской_Федерации
    # region [String] Any region string
    #
    # @example
    #   Faker::Comnpany.russian_tax_number
    #   Faker::Comnpany.russian_tax_number(region: 'AZ')
    #   Faker::Comnpany.russian_tax_number(region: 'AZ', type: false)
    # @param type [Symbol] Legeal or not, defaults to :legal
    # @return [String]
    #
    # source://faker//lib/faker/default/company.rb#520
    def inn_number(region, type); end

    # source://faker//lib/faker/default/company.rb#451
    def luhn_algorithm(number); end

    # Mod11 functionality from https://github.com/badmanski/mod11/blob/master/lib/mod11.rb
    #
    # source://faker//lib/faker/default/company.rb#431
    def mod11(number); end

    # source://faker//lib/faker/default/company.rb#562
    def spanish_b_algorithm(value); end

    # source://faker//lib/faker/default/company.rb#545
    def spanish_cif_control_digit(organization_type, code); end

    # source://faker//lib/faker/default/company.rb#498
    def weight_sum(array, weights); end
  end
end

class Faker::Compass < ::Faker::Base
  class << self
    # Produces a random abbreviation.
    #
    # @example
    #   Faker::Compass.abbreviation #=> "NEbN"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#80
    def abbreviation; end

    # Produces a random azimuth.
    #
    # @example
    #   Faker::Compass.azimuth #=> "168.75"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#93
    def azimuth; end

    # Produces a random cardinal.
    #
    # @example
    #   Faker::Compass.cardinal #=> "north"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#15
    def cardinal; end

    # Produces a random cardinal abbreviation.
    #
    # @example
    #   Faker::Compass.cardinal_abbreviation #=> "N"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#106
    def cardinal_abbreviation; end

    # Produces a random cardinal azimuth.
    #
    # @example
    #   Faker::Compass.cardinal_azimuth #=> "90"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#158
    def cardinal_azimuth; end

    # Produces a random direction.
    #
    # @example
    #   Faker::Compass.direction #=> "southeast"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#67
    def direction; end

    # Produces a random half wind.
    #
    # @example
    #   Faker::Compass.half_wind #=> "north-northwest"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#41
    def half_wind; end

    # Produces a random half wind abbreviation.
    #
    # @example
    #   Faker::Compass.half_wind_abbreviation #=> "NNE"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#132
    def half_wind_abbreviation; end

    # Produces a random half wind azimuth.
    #
    # @example
    #   Faker::Compass.half_wind_azimuth #=> "292.5"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#184
    def half_wind_azimuth; end

    # Produces a random ordinal.
    #
    # @example
    #   Faker::Compass.ordinal #=> "northwest"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#28
    def ordinal; end

    # Produces a random ordinal abbreviation.
    #
    # @example
    #   Faker::Compass.ordinal_abbreviation #=> "SW"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#119
    def ordinal_abbreviation; end

    # Produces a random ordinal azimuth.
    #
    # @example
    #   Faker::Compass.ordinal_azimuth #=> "135"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#171
    def ordinal_azimuth; end

    # Produces a random quarter wind.
    #
    # @example
    #   Faker::Compass.quarter_wind #=> "north by west"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#54
    def quarter_wind; end

    # Produces a random quarter wind abbreviation.
    #
    # @example
    #   Faker::Compass.quarter_wind_abbreviation #=> "SWbS"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#145
    def quarter_wind_abbreviation; end

    # Produces a random quarter wind azimuth
    #
    # @example
    #   Faker::Compass.quarter_wind_azimuth #=> "56.25"
    # @return [String]
    #
    # source://faker//lib/faker/default/compass.rb#197
    def quarter_wind_azimuth; end
  end
end

class Faker::Computer < ::Faker::Base
  class << self
    # Produces the name of a computer os.
    #
    # @example
    #   Faker::Computer.os #=> "RHEL 6.10"
    # @param platform [String] optionally specify the platform `linux`, `macos`, or `windows`.
    # @return [String]
    #
    # source://faker//lib/faker/default/computer.rb#42
    def os(platform: T.unsafe(nil)); end

    # Produces the name of a computer platform.
    #
    # @example
    #   Faker::Computer.platform #=> "Linux"
    # @return [String]
    #
    # source://faker//lib/faker/default/computer.rb#15
    def platform; end

    # Produces a string with computer platform and os
    #
    # @example
    #   Faker::Computer.stack #=> "Linux, RHEL 6.10"
    # @return [String]
    #
    # source://faker//lib/faker/default/computer.rb#56
    def stack; end

    # Produces the name of a computer type.
    #
    # @example
    #   Faker::Computer.type #=> "server"
    # @return [String]
    #
    # source://faker//lib/faker/default/computer.rb#28
    def type; end
  end
end

module Faker::Config
  class << self
    # source://faker//lib/faker.rb#20
    def locale; end

    # source://faker//lib/faker.rb#16
    def locale=(new_locale); end

    # source://faker//lib/faker.rb#25
    def own_locale; end

    # source://faker//lib/faker.rb#33
    def random; end

    # source://faker//lib/faker.rb#29
    def random=(new_random); end
  end
end

class Faker::Construction < ::Faker::Base
  class << self
    # Produces a random heavy equipment.
    #
    # @example
    #   Faker::Construction.heavy_equipment #=> "Excavator"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#27
    def heavy_equipment; end

    # Produces a random material.
    #
    # @example
    #   Faker::Construction.material #=> "Wood"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#14
    def material; end

    # Produces a random role.
    #
    # @example
    #   Faker::Construction.role #=> "Engineer"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#79
    def role; end

    # Produces a random standard cost code.
    #
    # @example
    #   Faker::Construction.standard_cost_code #=> "1-000 - Purpose"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#66
    def standard_cost_code; end

    # Produces a random subcontract category.
    #
    # @example
    #   Faker::Construction.subcontract_category #=> "Curb & Gutter"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#53
    def subcontract_category; end

    # Produces a random trade.
    #
    # @example
    #   Faker::Construction.trade #=> "Carpenter"
    # @return [String]
    #
    # source://faker//lib/faker/default/construction.rb#40
    def trade; end
  end
end

class Faker::Cosmere < ::Faker::Base
  class << self
    # Produces a random allomancer.
    #
    # @example
    #   Faker::Cosmere.allomancer #=> "Coinshot"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#94
    def allomancer; end

    # Produces a random aon.
    #
    # @example
    #   Faker::Cosmere.aon #=> "Rao"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#16
    def aon; end

    # Produces a random feruchemist.
    #
    # @example
    #   Faker::Cosmere.feruchemist #=> "Archivist"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#107
    def feruchemist; end

    # Produces a random herald.
    #
    # @example
    #   Faker::Cosmere.herald #=> "Ishar"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#120
    def herald; end

    # Produces a random knight radiant.
    #
    # @example
    #   Faker::Cosmere.knight_radiant #=> "Truthwatcher"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#68
    def knight_radiant; end

    # Produces a random metal.
    #
    # @example
    #   Faker::Cosmere.metal #=> "Brass"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#81
    def metal; end

    # Produces a random shard.
    #
    # @example
    #   Faker::Cosmere.shard #=> "Ambition"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#42
    def shard; end

    # Produces a random shard world.
    #
    # @example
    #   Faker::Cosmere.shard_world #=> "Yolen"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#29
    def shard_world; end

    # Produces a random spren.
    #
    # @example
    #   Faker::Cosmere.spren #=> "Flamespren"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#133
    def spren; end

    # Produces a random surge.
    #
    # @example
    #   Faker::Cosmere.surge #=> "Progression"
    # @return [String]
    #
    # source://faker//lib/faker/default/cosmere.rb#55
    def surge; end
  end
end

class Faker::Creature; end

class Faker::Creature::Animal < ::Faker::Base
  class << self
    # Produces a random animal name
    #
    # @example
    #   Faker::Creature::Animal.name #=> "fly"
    # @return [String]
    #
    # source://faker//lib/faker/creature/animal.rb#16
    def name; end
  end
end

class Faker::Creature::Bird < ::Faker::Base
  class << self
    # Produces a random adjective used to described birds
    #
    # @example
    #   Faker::Creature::Bird.adjective #=> 'common'
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#97
    def adjective; end

    # Produces a random bird anatomy word
    #
    # @example
    #   Faker::Creature::Bird.anatomy #=> "rump"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#45
    def anatomy; end

    # Produces a random, past tensed bird anatomy word
    #
    # @example
    #   Faker::Creature::Bird.anatomy #=> "breasted"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#58
    def anatomy_past_tense; end

    # Produces a random color word used in describing birds
    #
    # @example
    #   Faker::Creature::Bird.color #=> "ferruginous"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#84
    def color; end

    # Produces a random common family name of a bird.
    #
    # @example
    #   Faker::Creature::Bird.common_family_name #=> "Owls"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#18
    def common_family_name; end

    # Produces a random common name for a bird
    #
    # @example
    #   Faker::Creature::Bird.common_name #=> 'wren'
    # @param tax_order [String | Symbol | nil] Tax
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#141
    def common_name(tax_order = T.unsafe(nil)); end

    # Produces a random emotional adjective NOT used to described birds
    # ...but could be
    #
    # @example
    #   Faker::Creature::Bird.emotional_adjective #=> 'cantankerous'
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#111
    def emotional_adjective; end

    # Produces a random geographical word used in describing birds
    #
    # @example
    #   Faker::Creature::Bird.geo #=> "Eurasian"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#71
    def geo; end

    # Produces a random and IMplausible common name for a bird
    #
    # @example
    #   Faker::Creature::Bird.implausible_common_name #=> 'Hellinger's Cantankerous Chickadee'
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#178
    def implausible_common_name; end

    # Produces a random common taxonomic order from the class Aves
    #
    # @example
    #   Faker::Creature::Bird.order #=> "Passeriformes"
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#31
    def order; end

    # Produces a hash entry with a random order and a random common name
    # that is of that order
    #
    # }
    #
    # @example
    #   Faker::Creature::Bird.order_with_common_name #=> {
    #   order: ''Accipitriformes',
    #   common_name: 'Osprey'
    # @return [Hash<order,common_name>]
    #
    # source://faker//lib/faker/creature/bird.rb#195
    def order_with_common_name(tax_order = T.unsafe(nil)); end

    # Produces a random and plausible common name for a bird
    #
    # @example
    #   Faker::Creature::Bird.plausible_common_name #=> 'Hellinger's Wren'
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#165
    def plausible_common_name; end

    # Produces a random adjective NOT used to described birds
    # ...but probably shouldn't
    #
    # @example
    #   Faker::Creature::Bird.silly_adjective #=> 'drunk'
    # @return [String]
    #
    # source://faker//lib/faker/creature/bird.rb#125
    def silly_adjective; end
  end
end

class Faker::Creature::Cat < ::Faker::Base
  class << self
    # Produces a random cat breed
    #
    # @example
    #   Faker::Creature::Cat.breed #=> "Scottish Fold"
    # @return [String]
    #
    # source://faker//lib/faker/creature/cat.rb#31
    def breed; end

    # Produces a random name for a cat
    #
    # @example
    #   Faker::Creature::Cat.name #=> "Felix"
    # @return [String]
    #
    # source://faker//lib/faker/creature/cat.rb#18
    def name; end

    # Produces a random cat breed registry
    #
    # @example
    #   Faker::Creature::Cat.registry #=> "Fancy Southern Africa Cat Council"
    # @return [String]
    #
    # source://faker//lib/faker/creature/cat.rb#44
    def registry; end
  end
end

class Faker::Creature::Dog < ::Faker::Base
  class << self
    # Produces a random dog age
    #
    # @example
    #   Faker::Creature::Dog.age #=> "puppy"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#70
    def age; end

    # Produces a random dog breed
    #
    # @example
    #   Faker::Creature::Dog.breed #=> "Yorkshire Terrier"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#31
    def breed; end

    # Produces a random coat length
    #
    # @example
    #   Faker::Creature::Dog.coat_length #=> "short"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#96
    def coat_length; end

    # Produces a random gender
    #
    # @example
    #   Faker::Creature::Dog.gender #=> "Female"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#83
    def gender; end

    # Produces a random dog meme phrase
    #
    # @example
    #   Faker::Creature::Dog.meme_phrase #=> "smol pupperino"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#57
    def meme_phrase; end

    # Produces a random name for a dog
    #
    # @example
    #   Faker::Creature::Dog.name #=> "Spike"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#18
    def name; end

    # Produces a random size of a dog
    #
    # @example
    #   Faker::Creature::Dog.size #=> "small"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#109
    def size; end

    # Produces a random sound made by a dog
    #
    # @example
    #   Faker::Creature::Dog.sound #=> "woof woof"
    # @return [String]
    #
    # source://faker//lib/faker/creature/dog.rb#44
    def sound; end
  end
end

class Faker::Creature::Horse < ::Faker::Base
  class << self
    # Produces a random horse breed
    #
    # @example
    #   Faker::Creature::Horse.breed #=> "Spanish Barb see Barb Horse"
    # @return [String]
    #
    # source://faker//lib/faker/creature/horse.rb#31
    def breed; end

    # Produces a random name for a horse
    #
    # @example
    #   Faker::Creature::Horse.name #=> "Noir"
    # @return [String]
    #
    # source://faker//lib/faker/creature/horse.rb#18
    def name; end
  end
end

class Faker::Crypto < ::Faker::Base
  class << self
    # Produces an MD5 hash.
    #
    # @example
    #   Faker::Crypto.md5 #=> "6b5ed240042e8a65c55ddb826c3408e6"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto.rb#17
    def md5; end

    # Produces a SHA1 hash.
    #
    # @example
    #   Faker::Crypto.sha1 #=> "4e99e31c51eef8b2d290e709f757f92e558a503f"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto.rb#30
    def sha1; end

    # Produces a SHA256 hash.
    #
    # @example
    #   Faker::Crypto.sha256 #=> "51e4dbb424cd9db1ec5fb989514f2a35652ececef33f21c8dd1fd61bb8e3929d"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto.rb#43
    def sha256; end

    # Produces a SHA512 hash.
    #
    # @example
    #   Faker::Crypto.sha512 #=> "7b9fc82a6642874833d01b74a7b4fae3d15373193b55cfba47327f8f0afdc8d0ea155b58639a03a887009ef997dab8dd8d36767620d430f6e787e5996e26da80"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto.rb#56
    def sha512; end
  end
end

class Faker::CryptoCoin < ::Faker::Base
  class << self
    # Produces a random crypto coin acronym.
    #
    # @example
    #   Faker::CryptoCoin.acronym #=> "BTC"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto_coin.rb#32
    def acronym(coin: T.unsafe(nil)); end

    # Produces a random crypto coin's name, acronym and logo in an array.
    #
    # @example
    #   Faker::CryptoCoin.coin_array #=> ["Dash", "DASH", "https://i.imgur.com/2uX91cb.png"]
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/crypto_coin.rb#58
    def coin_array; end

    # Produces a random crypto coin's name, acronym and logo in a hash.
    #
    # @example
    #   Faker::CryptoCoin.coin_hash {:name=>"Ethereum", :acronym=>"ETH", :url_logo=>"https://i.imgur.com/uOPFCXj.png"}
    # @return [Hash]
    #
    # source://faker//lib/faker/default/crypto_coin.rb#71
    def coin_hash; end

    # Produces a random crypto coin name.
    #
    # @example
    #   Faker::CryptoCoin.coin_name #=> "Bitcoin"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto_coin.rb#19
    def coin_name(coin: T.unsafe(nil)); end

    # Produces a random crypto coin logo url.
    #
    # @example
    #   Faker::CryptoCoin.url_logo #=> "https://i.imgur.com/EFz61Ei.png"
    # @return [String]
    #
    # source://faker//lib/faker/default/crypto_coin.rb#45
    def url_logo(coin: T.unsafe(nil)); end
  end
end

class Faker::Currency < ::Faker::Base
  class << self
    # Produces a currency code.
    #
    # @example
    #   Faker::Currency.code #=> "USD"
    # @return [String]
    #
    # source://faker//lib/faker/default/currency.rb#28
    def code; end

    # Produces the name of a currency.
    #
    # @example
    #   Faker::Currency.name #=> "Swedish Krona"
    # @return [String]
    #
    # source://faker//lib/faker/default/currency.rb#15
    def name; end

    # Produces a currency symbol.
    #
    # @example
    #   Faker::Currency.symbol #=> "$"
    # @return [String]
    #
    # source://faker//lib/faker/default/currency.rb#41
    def symbol; end
  end
end

class Faker::Date < ::Faker::Base
  class << self
    # Produce a random date in the past (up to N days).
    #
    # @example
    #   Faker::Date.backward(days: 14) #=> #<Date: 2019-09-12>
    # @param days [Integer] The maximum number of days to go into the past.
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#80
    def backward(days: T.unsafe(nil)); end

    # Produce a random date between two dates.
    #
    # @example if used with or without Rails (Active Support)
    #   Faker::Date.between(from: '2014-09-23', to: '2014-09-25') #=> #<Date: 2014-09-24>
    # @example if used with Rails (Active Support)
    #   Faker::Date.between(from: 2.days.ago, to: Date.today) #=> #<Date: 2014-09-24>
    # @param from [Date, String] The start of the usable date range.
    # @param to [Date, String] The end of the usable date range.
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#20
    def between(from:, to:); end

    # Produce a random date between two dates.
    #
    # @example if used with or without Rails (Active Support)
    #   Faker::Date.between_except(from: '2014-09-23', to: '2015-09-25', excepted: '2015-01-24') #=> #<Date: 2014-10-03>
    # @example if used with Rails (Active Support)
    #   Faker::Date.between_except(from: 1.year.ago, to: 1.year.from_now, excepted: Date.today) #=> #<Date: 2014-10-03>
    # @param from [Date, String] The start of the usable date range.
    # @param to [Date, String] The end of the usable date range.
    # @param excepted [Date, String] A date to exclude.
    # @raise [ArgumentError]
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#42
    def between_except(from:, to:, excepted:); end

    # Produce a random date in the past (up to N days).
    #
    # @example
    #   Faker::Date.birthday(min_age: 18, max_age: 65) #=> #<Date: 1986-03-28>
    # @param min_age [Integer] The minimum age that the birthday would imply.
    # @param max_age [Integer] The maximum age that the birthday would imply.
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#98
    def birthday(min_age: T.unsafe(nil), max_age: T.unsafe(nil)); end

    # Produce a random date in the future (up to N days).
    #
    # @example
    #   Faker::Date.forward(days: 23) #=> #<Date: 2014-10-03>
    # @param days [Integer] The maximum number of days to go into the future.
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#63
    def forward(days: T.unsafe(nil)); end

    # Produces a date in the year and/or month specified.
    #
    # @example
    #   Faker::Date.in_date_period #=> #<Date: 2019-09-01>
    # @example
    #   Faker::Date.in_date_period(year: 2018, month: 2) #=> #<Date: 2018-02-26>
    # @example
    #   Faker::Date.in_date_period(month: 2) #=> #<Date: 2019-02-26>
    # @param month [Integer] represents the month of the date
    # @param year [Integer] represents the year of the date
    # @return [Date]
    #
    # source://faker//lib/faker/default/date.rb#124
    def in_date_period(month: T.unsafe(nil), year: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/date.rb#133
    def birthday_date(date, age); end

    # source://faker//lib/faker/default/date.rb#146
    def get_date_object(date); end
  end
end

class Faker::DcComics < ::Faker::Base
  class << self
    # Produces a hero name from DC Comics
    #
    # @example
    #   Faker::DcComics.hero #=> "Batman"
    # @return [String]
    #
    # source://faker//lib/faker/default/dc_comics.rb#14
    def hero; end

    # Produces a heroine name from DC Comics
    #
    # @example
    #   Faker::DcComics.heroine #=> "Supergirl"
    # @return [String]
    #
    # source://faker//lib/faker/default/dc_comics.rb#27
    def heroine; end

    # Produces a character name from DC Comics
    #
    # @example
    #   Faker::DcComics.name #=> "Clark Kent"
    # @return [String]
    #
    # source://faker//lib/faker/default/dc_comics.rb#53
    def name; end

    # Produces a comic book title from DC Comics
    #
    # @example
    #   Faker::DcComics.title #=> "Batman: The Long Halloween"
    # @return [String]
    #
    # source://faker//lib/faker/default/dc_comics.rb#66
    def title; end

    # Produces a villain name from DC Comics
    #
    # @example
    #   Faker::DcComics.villain #=> "The Joker"
    # @return [String]
    #
    # source://faker//lib/faker/default/dc_comics.rb#40
    def villain; end
  end
end

class Faker::Demographic < ::Faker::Base
  class << self
    # Produces a denonym.
    #
    # @example
    #   Faker::Demographic.denonym #=> "Panamanian"
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#41
    def demonym; end

    # Produces a level of educational attainment.
    #
    # @example
    #   Faker::Demographic.educational_attainment #=> "GED or alternative credential"
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#28
    def educational_attainment; end

    # Produces a height as a string.
    #
    # @example
    #   Faker::Demographic.height #=> "1.61"
    # @example
    #   Faker::Demographic.height(unit: :imperial) #=> "6 ft, 2 in"
    # @param unit [Symbol] either `:metric` or `imperial`.
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#83
    def height(unit: T.unsafe(nil)); end

    # Produces a marital status.
    #
    # @example
    #   Faker::Demographic.marital_status #=> "Widowed"
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#54
    def marital_status; end

    # Produces the name of a race.
    #
    # @example
    #   Faker::Demographic.race #=> "Native Hawaiian or Other Pacific Islander"
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#15
    def race; end

    # Produces a sex for demographic purposes.
    #
    # @example
    #   Faker::Demographic.sex #=> "Female"
    # @return [String]
    #
    # source://faker//lib/faker/default/demographic.rb#67
    def sex; end
  end
end

class Faker::Dessert < ::Faker::Base
  class << self
    # Produces the name of a dessert flavor.
    #
    # @example
    #   Faker::Dessert.flavor #=> "Salted Caramel"
    # @return [String]
    #
    # source://faker//lib/faker/default/dessert.rb#43
    def flavor; end

    # Produces the name of a dessert topping.
    #
    # @example
    #   Faker::Dessert.topping #=> "Gummy Bears"
    # @return [String]
    #
    # source://faker//lib/faker/default/dessert.rb#30
    def topping; end

    # Produces the name of a dessert variety.
    #
    # @example
    #   Faker::Dessert.variety #=> "Cake"
    # @return [String]
    #
    # source://faker//lib/faker/default/dessert.rb#17
    def variety; end
  end
end

class Faker::Device < ::Faker::Base
  class << self
    # Produces a build number between 1 and 500.
    #
    # @example
    #   Faker::Device.build_number #=> 5
    # @return [Integer]
    #
    # source://faker//lib/faker/default/device.rb#15
    def build_number; end

    # Produces the name of a manufacturer for a device.
    #
    # @example
    #   Faker::Device.manufacturer #=> "Apple"
    # @return [String]
    #
    # source://faker//lib/faker/default/device.rb#28
    def manufacturer; end

    # Produces a model name for a device.
    #
    # @example
    #   Faker::Device.model_name #=> "iPhone 4"
    # @return [String]
    #
    # source://faker//lib/faker/default/device.rb#41
    def model_name; end

    # Produces the name of a platform for a device.
    #
    # @example
    #   Faker::Device.platform #=> "webOS"
    # @return [String]
    #
    # source://faker//lib/faker/default/device.rb#54
    def platform; end

    # Produces a serial code for a device.
    #
    # @example
    #   Faker::Device.serial #=> "ejfjnRNInxh0363JC2WM"
    # @return [String]
    #
    # source://faker//lib/faker/default/device.rb#67
    def serial; end

    # Produces a version number between 1 and 1000.
    #
    # @example
    #   Faker::Device.version #=> 42
    # @return [Integer]
    #
    # source://faker//lib/faker/default/device.rb#80
    def version; end
  end
end

class Faker::DrivingLicence < ::Faker::Base
  class << self
    # Produces a random British driving licence number.
    #
    # @example
    #   Faker::DrivingLicence.british_driving_licence        #=> "MCDER712081VF7EK"
    #   Faker::DrivingLicence.british_driving_licence(last_name: "O'Carroll",
    #   initials: "J",
    #   gender: :female,
    #   date_of_birth: Date.parse("1986-10-24")) #=> "OCARR815246J91HT"
    # @param last_name [String] The last name of the driving licence's owner.
    # @param initials [String] The initials of the driving licence's owner.
    # @param gender [String] The gender of the driving licence's owner.
    # @param date_of_birth [String] The date of birth of the driving licence's owner.
    # @return [String]
    #
    # source://faker//lib/faker/default/driving_licence.rb#26
    def british_driving_licence(last_name: T.unsafe(nil), initials: T.unsafe(nil), gender: T.unsafe(nil), date_of_birth: T.unsafe(nil)); end

    # Produces a random Northern Irish licence number.
    #
    # @example
    #   Faker::DrivingLicence.northern_irish_driving_licence #=> "70702548"
    # @return [String]
    #
    # source://faker//lib/faker/default/driving_licence.rb#44
    def northern_irish_driving_licence; end

    # Produces a random UK driving licence number in either GB or NI format, at a rate consistent with their relative populations
    #
    # @example
    #   Faker::DrivingLicence.uk_driving_licence             #=> "OCARR815246J91HT"
    #   Faker::DrivingLicence.uk_driving_licence             #=> "70702548"
    # @overload uk_driving_licence
    # @overload uk_driving_licence
    # @return [String]
    #
    # source://faker//lib/faker/default/driving_licence.rb#64
    def uk_driving_licence(*args); end

    # Produces a random USA driving licence number by state code passed.
    #
    # @example
    #   Faker::DrivingLicence.usa_driving_licence                 #=> "V5598249"
    #   Faker::DrivingLicence.usa_driving_licence('new mexico')   #=> "270692028"
    #   Faker::DrivingLicence.usa_driving_licence('New Mexico')   #=> "68178637"
    # @return [String]
    #
    # source://faker//lib/faker/default/driving_licence.rb#83
    def usa_driving_licence(state = T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/driving_licence.rb#110
    def gb_licence_checksum; end

    # source://faker//lib/faker/default/driving_licence.rb#95
    def gb_licence_padding(str, num_chars); end

    # source://faker//lib/faker/default/driving_licence.rb#100
    def gb_licence_year(dob, gender); end

    # source://faker//lib/faker/default/driving_licence.rb#91
    def random_gender; end
  end
end

# source://faker//lib/faker/default/driving_licence.rb#5
Faker::DrivingLicence::GB_PADDING = T.let(T.unsafe(nil), String)

# NI Pop is about 3% of total UK population
#
# source://faker//lib/faker/default/driving_licence.rb#6
Faker::DrivingLicence::NI_CHANCE = T.let(T.unsafe(nil), Float)

class Faker::Drone < ::Faker::Base
  class << self
    # Returns the drone battery capacity
    #
    # @example
    #   Faker::Drone.battery_capacity #=> "3500 mAh"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#171
    def battery_capacity; end

    # Returns the battery type
    #
    # @example
    #   Faker::Drone.battery_type #=> "LiPo 4S"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#197
    def battery_type; end

    # Returns battery voltage
    #
    # @example
    #   Faker::Drone.battery_voltage #=> "13.2V"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#184
    def battery_voltage; end

    # Returns total battery weight in grams
    #
    # @example
    #   Faker::Drone.battery_weight #=> "198 g"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#210
    def battery_weight; end

    # Returns charging temperature for battery in Fahrenheit
    #
    # @example
    #   Faker::Drone.charging_temperature #=> "41-104F"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#223
    def charging_temperature; end

    # Returns max flight time for drone in optimal conditions
    #
    # @example
    #   Faker::Drone.flight_time #=> "34 min"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#67
    def flight_time; end

    # Returns camera ISO range for drone
    #
    # @example
    #   Faker::Drone.iso #=> "100-3200"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#249
    def iso; end

    # Returns max altitude drone can go above sea level in meters
    #
    # @example
    #   Faker::Drone.max_altitude #=> "5000 m"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#80
    def max_altitude; end

    # Returns max angular velocity of drone in degrees/s
    #
    # @example
    #   Faker::Drone.max_angular_velocity #=> "250 degree/s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#132
    def max_angular_velocity; end

    # Returns maximum ascent speed for drone in m/s
    #
    # @example
    #   Faker::Drone.max_ascent_speed #=> "4 m/s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#41
    def max_ascent_speed; end

    # Returns max chargin power required for battery
    #
    # @example
    #   Faker::Drone.max_charging_power #=> "38W"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#236
    def max_charging_power; end

    # Returns maximum descent speed for drone in m/s
    #
    # @example
    #   Faker::Drone.max_descent_speed #=> "4 m/s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#54
    def max_descent_speed; end

    # Returns how far drone can go in optimal condition when full charged in meters
    #
    # @example
    #   Faker::Drone.max_flight_distance #=> "18500 m"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#93
    def max_flight_distance; end

    # Returns max camera resolution in MP"
    #
    # @example
    #   Faker::Drone.max_resolution #=> "48MP"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#262
    def max_resolution; end

    # Returns max shutter speed for camera
    #
    # @example
    #   Faker::Drone.max_shutter_speed #=> "60s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#314
    def max_shutter_speed; end

    # Returns max horizontal speed by drone in m/s
    #
    # @example
    #   Faker::Drone.max_speed #=> "19 m/s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#106
    def max_speed; end

    # Returns max tilt angle drone can go in degrees
    #
    # @example
    #   Faker::Drone.max_tilt_angle #=> "35 degrees"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#145
    def max_tilt_angle; end

    # Returns max wind resistance by drone in m/s
    #
    # @example
    #   Faker::Drone.max_wind_resistance #=> "10.5 m/s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#119
    def max_wind_resistance; end

    # Returns min shutter speed for camera
    #
    # @example
    #   Faker::Drone.min_shutter_speed #=> "1/8000s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#327
    def min_shutter_speed; end

    # Returns random drone name with company
    #
    # @example
    #   Faker::Drone.name #=> "DJI Mavic Air 2"
    # @return [string]
    #
    # source://faker//lib/faker/default/drone.rb#15
    def name; end

    # Returns operating temperature for drone in Fahrenheit
    #
    # @example
    #   Faker::Drone.operating_temperature #=> "14-104F"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#158
    def operating_temperature; end

    # Returns photo format for drone
    #
    # @example
    #   Faker::Drone.photo_format #=> "JPEG"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#275
    def photo_format; end

    # Returns max and min shutter speed for camera
    #
    # @example
    #   Faker::Drone.shutter_speed_range #=> "8-1/8000s"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#301
    def shutter_speed_range; end

    # Returns video format
    #
    # @example
    #   Faker::Drone.video_format #=> "MP4"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#288
    def video_format; end

    # Returns total drone weight in grams
    #
    # @example
    #   Faker::Drone.weight #=> "570 g"
    # @return [String]
    #
    # source://faker//lib/faker/default/drone.rb#28
    def weight; end
  end
end

class Faker::Educator < ::Faker::Base
  class << self
    # Produces a campus name.
    #
    # @example
    #   Faker::Educator.campus #=> "Vertapple Campus"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#97
    def campus; end

    # Produces a university degree.
    #
    # @example
    #   Faker::Educator.degree #=> "Associate Degree in Criminology"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#30
    def course; end

    # Produces a course name.
    #
    # @example
    #   Faker::Educator.course_name #=> "Criminology 101"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#58
    def course_name; end

    # Produces a university degree.
    #
    # @example
    #   Faker::Educator.degree #=> "Associate Degree in Criminology"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#30
    def degree; end

    # Produces a primary school.
    #
    # @example
    #   Faker::Educator.primary_school #=> "Brighthurst Elementary School"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#84
    def primary_school; end

    # Produces a secondary school.
    #
    # @example
    #   Faker::Educator.secondary_school #=> "Iceborough Secondary College"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#71
    def secondary_school; end

    # Produces a university subject.
    #
    # @example
    #   Faker::Educator.subject #=> "Criminology"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#45
    def subject; end

    # Produces a university name.
    #
    # @example
    #   Faker::Educator.university #=> "Mallowtown Technical College"
    # @return [String]
    #
    # source://faker//lib/faker/default/educator.rb#17
    def university; end
  end
end

class Faker::ElectricalComponents < ::Faker::Base
  class << self
    # Produces an active electrical component.
    #
    # @example
    #   Faker::ElectricalComponents.active #=> "Transistor"
    # @return [String]
    #
    # source://faker//lib/faker/default/electrical_components.rb#17
    def active; end

    # Produces an electromechanical electrical component.
    #
    # @example
    #   Faker::ElectricalComponents.electromechanical #=> "Toggle Switch"
    # @return [String]
    #
    # source://faker//lib/faker/default/electrical_components.rb#43
    def electromechanical; end

    # Produces a passive electrical component.
    #
    # @example
    #   Faker::ElectricalComponents.passive #=> "Resistor"
    # @return [String]
    #
    # source://faker//lib/faker/default/electrical_components.rb#30
    def passive; end
  end
end

class Faker::Emotion < ::Faker::Base
  class << self
    # Produces an emotion adjective.
    #
    # @example
    #   Faker::Emotion.adjective # => "nonplussed"
    # @return [String]
    #
    # source://faker//lib/faker/default/emotion.rb#28
    def adjective; end

    # Produces an emotion noun.
    #
    # @example
    #   Faker::Emotion.noun #=> "amazement"
    # @return [String]
    #
    # source://faker//lib/faker/default/emotion.rb#15
    def noun; end
  end
end

class Faker::Esport < ::Faker::Base
  class << self
    # Produces the name of an eSports event.
    #
    # @example
    #   Faker::Esport.event #=> "ESL Cologne"
    # @return [String]
    #
    # source://faker//lib/faker/default/esport.rb#54
    def event; end

    # Produces the name of a game played as an eSport.
    #
    # @example
    #   Faker::Esport.game #=> "Dota 2"
    # @return [String]
    #
    # source://faker//lib/faker/default/esport.rb#67
    def game; end

    # Produces the name of an eSports league.
    #
    # @example
    #   Faker::Esport.league #=> "IEM"
    # @return [String]
    #
    # source://faker//lib/faker/default/esport.rb#41
    def league; end

    # Produces the name of a professional eSports player.
    #
    # @example
    #   Faker::Esport.player #=> "Crimsix"
    # @return [String]
    #
    # source://faker//lib/faker/default/esport.rb#15
    def player; end

    # Produces the name of an eSports team.
    #
    # @example
    #   Faker::Esport.team #=> "CLG"
    # @return [String]
    #
    # source://faker//lib/faker/default/esport.rb#28
    def team; end
  end
end

class Faker::Fantasy; end

class Faker::Fantasy::Tolkien < ::Faker::Base
  class << self
    # Produces a character from Tolkien's legendarium
    #
    # @example
    #   Faker::Fantasy::Tolkien.character
    #   #=> "Goldberry"
    # @return [String]
    #
    # source://faker//lib/faker/fantasy/tolkien.rb#19
    def character; end

    # Produces a location from Tolkien's legendarium
    #
    # @example
    #   Faker::Fantasy::Tolkien.location
    #   #=> "Helm's Deep"
    # @return [String]
    #
    # source://faker//lib/faker/fantasy/tolkien.rb#33
    def location; end

    # Produces the name of a poem from Tolkien's legendarium
    #
    # @example
    #   Faker::Fantasy::Tolkien.poem
    #   #=> "Chip the glasses and crack the plates"
    # @return [String]
    #
    # source://faker//lib/faker/fantasy/tolkien.rb#61
    def poem; end

    # Produces a race from Tolkien's legendarium
    #
    # @example
    #   Faker::Fantasy::Tolkien.race
    #   #=> "Uruk-hai"
    # @return [String]
    #
    # source://faker//lib/faker/fantasy/tolkien.rb#47
    def race; end
  end
end

class Faker::File < ::Faker::Base
  class << self
    # Produces a random directory name.
    #
    # @example
    #   Faker::File.dir #=> "et_error/sint_voluptas/quas_veritatis"
    #   Faker::File.dir(segment_count: 2) #=> "ea-suscipit/ut-deleniti"
    #   Faker::File.dir(segment_count: 3, root: nil, directory_separator: '/') #=> "est_porro/fugit_eveniet/incidunt-autem"
    #   Faker::File.dir(segment_count: 3, root: nil, directory_separator: '\\') #=> "aut-ullam\\quia_quisquam\\ut-eos"
    # @param segment_count [Integer] Specifies the number of nested folders in the generated string.
    # @param root [String] Specifies the root of the generated string.
    # @param directory_separator [String] Specifies the separator between the segments.
    # @return [String]
    #
    # source://faker//lib/faker/default/file.rb#21
    def dir(segment_count: T.unsafe(nil), root: T.unsafe(nil), directory_separator: T.unsafe(nil)); end

    # Produces a random file extension.
    #
    # @example
    #   Faker::File.extension #=> "mp3"
    # @return [String]
    #
    # source://faker//lib/faker/default/file.rb#39
    def extension; end

    # Produces a random file name.
    #
    # @example
    #   Faker::File.file_name(dir: 'path/to') #=> "path/to/something_random.jpg"
    #   Faker::File.file_name(dir: 'foo/bar', name: 'baz') #=> "foo/bar/baz.zip"
    #   Faker::File.file_name(dir: 'foo/bar', name: 'baz', ext: 'doc') #=> "foo/bar/baz.doc"
    #   Faker::File.file_name(dir: 'foo/bar', name: 'baz', ext: 'mp3', directory_separator: '\\') #=> "foo/bar\\baz.mp3"
    # @param dir [String] Specifies the path used for the generated file.
    # @param name [String] Specifies the filename used for the generated file.
    # @param ext [String] Specifies the extension used the generated file.
    # @param directory_separator [String] Specifies the separator between the directory and name elements.
    # @return [String]
    #
    # source://faker//lib/faker/default/file.rb#72
    def file_name(dir: T.unsafe(nil), name: T.unsafe(nil), ext: T.unsafe(nil), directory_separator: T.unsafe(nil)); end

    # Produces a random mime type.
    #
    # @example
    #   Faker::File.mime_type #=> "application/pdf"
    # @return [String]
    #
    # source://faker//lib/faker/default/file.rb#52
    def mime_type(media_type: T.unsafe(nil)); end
  end
end

class Faker::Fillmurray < ::Faker::Base
  class << self
    # Produces the URL of an image from Fill Murray, a site which hosts
    # exclusively photographs of actor Bill Murray.
    #
    # @example
    #   Faker::Fillmurray.image #=> "https://www.fillmurray.com/300/300"
    # @example
    #   Faker::Fillmurray.image(grayscale: true)
    #   #=> "https://fillmurray.com/g/300/300"
    # @example
    #   Faker::Fillmurray.image(grayscale: false, width: 200, height: 400)
    #   #=> "https://fillmurray.com/200/400"
    # @param grayscale [Boolean] Whether to return a grayscale image.
    # @param width [Integer] The iamage width.
    # @param height [Integer] The image height.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/fillmurray.rb#27
    def image(grayscale: T.unsafe(nil), width: T.unsafe(nil), height: T.unsafe(nil)); end
  end
end

class Faker::Finance < ::Faker::Base
  class << self
    # Returns a random condominium fiscal code.
    #
    # @example
    #   Faker::Finance.condominium_fiscal_code #=> "012345678"
    # @param country [String] Two capital letter country code to use for the vat number.
    # @return [String]
    #
    # source://faker//lib/faker/default/finance.rb#107
    def condominium_fiscal_code(country: T.unsafe(nil)); end

    # Produces a random credit card number.
    #
    # @example
    #   Faker::Finance.credit_card #=> "3018-348979-1853"
    #   Faker::Finance.credit_card(:mastercard) #=> "6771-8921-2291-6236"
    #   Faker::Finance.credit_card(:mastercard, :visa) #=> "4448-8934-1277-7195"
    # @param types [String] Specific credit card type.
    # @return [String]
    #
    # source://faker//lib/faker/default/finance.rb#24
    def credit_card(*types); end

    # Returns a randomly-selected stock market.
    #
    # @example
    #   Faker::Finance.stock_market #=> 'NASDAQ'
    # @return [String]
    #
    # source://faker//lib/faker/default/finance.rb#93
    def stock_market; end

    # Returns a randomly-selected stock ticker from a specified market.
    #
    # @example
    #   Faker::Finance.ticker #=> 'AMZN'
    #   Faker::Finance.vat_number('NASDAQ') #=> 'GOOG'
    # @param markets [String] The name of the market to choose the ticker from (e.g. NYSE, NASDAQ)
    # @return [String]
    #
    # source://faker//lib/faker/default/finance.rb#76
    def ticker(*markets); end

    # Produces a random vat number.
    #
    # @example
    #   Faker::Finance.vat_number #=> "BR38.395.329/2471-83"
    #   Faker::Finance.vat_number('DE') #=> "DE593306671"
    #   Faker::Finance.vat_number('ZA') #=> "ZA79494416181"
    # @param country [String] Two capital letter country code to use for the vat number.
    # @return [String]
    #
    # source://faker//lib/faker/default/finance.rb#55
    def vat_number(country: T.unsafe(nil)); end

    # source://faker//lib/faker/default/finance.rb#61
    def vat_number_keys; end
  end
end

# source://faker//lib/faker/default/finance.rb#5
Faker::Finance::CREDIT_CARD_TYPES = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/finance.rb#9
Faker::Finance::MARKET_LIST = T.let(T.unsafe(nil), Array)

class Faker::Food < ::Faker::Base
  class << self
    # Retrieves a description about some dish
    #
    # @example
    #   Faker::Food.description #=> "Breaded fried chicken with waffles. Served with maple syrup."
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#30
    def description; end

    # Retrieves a typical dish from each country.
    #
    # @example
    #   Faker::Food.dish #=> "Feijoada"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#17
    def dish; end

    # Retrieves ethnic category
    #
    # @example
    #   Faker::Food.ethnic_category #=> "Indian cuisine"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#121
    def ethnic_category; end

    # Retrieves a fruit
    #
    # @example
    #   Faker::Food.fruits #=> "Papaya"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#56
    def fruits; end

    # Retrieves an ingredient
    #
    # @example
    #   Faker::Food.ingredient #=> "Olives"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#43
    def ingredient; end

    # Retrieves cooking measures
    #
    # @example
    #   Faker::Food.measurement #=> "1/3"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#95
    def measurement; end

    # Retrieves metric measurements
    #
    # @example
    #   Faker::Food.metric_measurement #=> "centiliter"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#108
    def metric_measurement; end

    # Retrieves some random spice
    #
    # @example
    #   Faker::Food.spice #=> "Garlic Chips"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#82
    def spice; end

    # Retrieves a vegetable
    #
    # @example
    #   Faker::Food.vegetables #=> "Broccolini"
    # @return [String]
    #
    # source://faker//lib/faker/default/food.rb#69
    def vegetables; end
  end
end

class Faker::FunnyName < ::Faker::Base
  class << self
    # Retrieves a funny four word name.
    #
    # @example
    #   Faker::FunnyName.four_word_name #=> "Maude L. T. Ford"
    # @return [String]
    #
    # source://faker//lib/faker/default/funny_name.rb#64
    def four_word_name; end

    # Retrieves a funny name.
    #
    # @example
    #   Faker::FunnyName.name #=> "Sam Pull"
    # @return [String]
    #
    # source://faker//lib/faker/default/funny_name.rb#17
    def name; end

    # Retrieves a funny name with an initial.
    #
    # @example
    #   Faker::FunnyName.name_with_initial #=> "Heather N. Yonn"
    # @return [String]
    #
    # source://faker//lib/faker/default/funny_name.rb#81
    def name_with_initial; end

    # Retrieves a funny three word name.
    #
    # @example
    #   Faker::FunnyName.three_word_name #=> "Carson O. Gin"
    # @return [String]
    #
    # source://faker//lib/faker/default/funny_name.rb#47
    def three_word_name; end

    # Retrieves a funny two word name.
    #
    # @example
    #   Faker::FunnyName.two_word_name #=> "Shirley Knot"
    # @return [String]
    #
    # source://faker//lib/faker/default/funny_name.rb#30
    def two_word_name; end
  end
end

class Faker::Game < ::Faker::Base
  class << self
    # Produces the name of a video game genre.
    #
    # @example
    #   Faker::Game.genre #=> "Real-time strategy"
    # @return [String]
    #
    # source://faker//lib/faker/games/game.rb#30
    def genre; end

    # Produces the name of a video game console or platform.
    #
    # @example
    #   Faker::Game.platform #=> "Nintendo Switch"
    # @return [String]
    #
    # source://faker//lib/faker/games/game.rb#43
    def platform; end

    # Produces the name of a video game.
    #
    # @example
    #   Faker::Game.title #=> "Half-Life 2"
    # @return [String]
    #
    # source://faker//lib/faker/games/game.rb#17
    def title; end
  end
end

class Faker::Games; end

class Faker::Games::ClashOfClans < ::Faker::Base
  class << self
    # Produces the name of a defensive building from Clash Of Clans.
    #
    # @example
    #   Faker::Games::ClashOfClans.defensive_building #=> "Cannon"
    # @return [String]
    #
    # source://faker//lib/faker/games/clash_of_clans.rb#42
    def defensive_building; end

    # Produces the name of a rank from Clash Of Clans.
    #
    # @example
    #   Faker::Games::ClashOfClans.rank #=> "Legend"
    # @return [String]
    #
    # source://faker//lib/faker/games/clash_of_clans.rb#29
    def rank; end

    # Produces the name of a troop from Clash of Clans.
    #
    # @example
    #   Faker::Games::ClashOfClans.troop #=> "Barbarian"
    # @return [String]
    #
    # source://faker//lib/faker/games/clash_of_clans.rb#16
    def troop; end
  end
end

class Faker::Games::Control < ::Faker::Base
  class << self
    # Produces the name of an Altered Item
    #
    # @example
    #   Faker::Games::Control.altered_item #=> "Rubber Duck"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#55
    def altered_item; end

    # Produces the location of an Altered World Event (AWE)
    #
    # @example
    #   Faker::Games::Control.altered_world_event #=> "Ordinary, Wisconsin"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#68
    def altered_world_event; end

    # Produces the name of a character from Control.
    #
    # @example
    #   Faker::Games::Control.character #=> "Jesse Faden"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#16
    def character; end

    # Produces a line from the Hiss incantation
    #
    # @example
    #   Faker::Games::Control.hiss #=> "Push the fingers through the surface into the wet."
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#81
    def hiss; end

    # Produces the name of a location from Control.
    #
    # @example
    #   Faker::Games::Control.location #=> "Dimensional Research"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#29
    def location; end

    # Produces the name of an Object of Power (OoP)
    #
    # @example
    #   Faker::Games::Control.object_of_power #=> "Hotline"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#42
    def object_of_power; end

    # Produces a quote from Control
    #
    # @example
    #   Faker::Games::Control.quote #=> "He never liked fridge duty"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#107
    def quote; end

    # < Produces a line/quote/message from The Board >
    #
    # @example
    #   Faker::Games::Control.the_board #=> "< You/We wield the Gun/You. The Board appoints you. Congratulations, Director. >"
    # @return [String]
    #
    # source://faker//lib/faker/games/control.rb#94
    def the_board; end
  end
end

class Faker::Games::DnD < ::Faker::Base
  class << self
    # Produces the name of an alignment from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.alignment #=> "Lawful Neutral"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#16
    def alignment; end

    # Produces the name of a background from Dungeons and Dragons (PHB).
    #
    # @example
    #   Faker::Games::DnD.background #=> "Urchin"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#29
    def background; end

    # Produces the name of a city from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.city #=> "Earthfast"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#42
    def city; end

    # Produces the name of a class from Dungeons and Dragons (PHB).
    #
    # @example
    #   Faker::Games::DnD.klass #=> "Warlock"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#55
    def klass; end

    # Produces the name of a language from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.language #=> "Gnomish"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#68
    def language; end

    # Produces the name of a melee weapon from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.melee_weapon #=> "Handaxe"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#81
    def melee_weapon; end

    # Produces the name of a monster from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.monster #=> "Manticore"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#94
    def monster; end

    # Produces the name of a race from Dungeons and Dragons (PHB).
    #
    # @example
    #   Faker::Games::DnD.races #=> "Dwarf"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#107
    def race; end

    # Produces the name of a ranged weapon from Dungeons and Dragons.
    #
    # @example
    #   Faker::Games::DnD.ranged_weapon #=> "Shortbow"
    # @return [String]
    #
    # source://faker//lib/faker/games/dnd.rb#120
    def ranged_weapon; end

    # This method is deprecated. The implementation will be removed in a near future release.
    # Use `DnD.race` instead.
    #
    # @deprecated Use {#race} instead.
    #
    # source://faker//lib/faker/games/dnd.rb#128
    def species; end
  end
end

class Faker::Games::Dota < ::Faker::Base
  class << self
    # Produces the name of a building from Dota.
    #
    # @example
    #   Faker::Games::Dota.building #=> "Tower"
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#16
    def building; end

    # Produces the name of a hero from Dota.
    #
    # @example
    #   Faker::Games::Dota.hero #=> "Abaddon"
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#29
    def hero; end

    # Produces the name of an item from Dota.
    #
    # @example
    #   Faker::Games::Dota.item #=> "Armlet of Mordiggian"
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#42
    def item; end

    # Produces the name of a professional Dota player.
    #
    # @example
    #   Faker::Games::Dota.player #=> "Dendi"
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#68
    def player; end

    # Produces the name of a hero from Dota.
    #
    # @example
    #   Faker::Games::Dota.quote #=> "You have called death upon yourself."
    #   Faker::Games::Dota.quote(hero: 'alchemist') #=> "Better living through alchemy!"
    # @param hero [String] The name of a Dota hero.
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#83
    def quote(hero: T.unsafe(nil)); end

    # Produces the name of a professional Dota team.
    #
    # @example
    #   Faker::Games::Dota.team #=> "Evil Geniuses"
    # @return [String]
    #
    # source://faker//lib/faker/games/dota.rb#55
    def team; end
  end
end

class Faker::Games::ElderScrolls < ::Faker::Base
  class << self
    # Produces the name of a city from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.city #=> "Whiterun"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#29
    def city; end

    # Produces the name of a creature from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.creature #=> "Frost Troll"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#42
    def creature; end

    # Produces the name of a dragon from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.dragon #=> "Blood Dragon"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#68
    def dragon; end

    # Produces a first name from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.first_name #=> "Balgruuf"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#94
    def first_name; end

    # Produces a weapon from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.jewelry #=> "Silver Ruby Ring"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#133
    def jewelry; end

    # Produces a last name from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.last_name #=> "The Old"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#107
    def last_name; end

    # Produces a randomly generated name from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.name #=> "Balgruuf The Old"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#81
    def name; end

    # Produces the name of a race from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.race #=> "Argonian"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#16
    def race; end

    # Produces the name of a region from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.region #=> "Cyrodiil"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#55
    def region; end

    # Produces a weapon from the Elder Scrolls universe.
    #
    # @example
    #   Faker::Games::ElderScrolls.weapon #=> "Elven Bow"
    # @return [String]
    #
    # source://faker//lib/faker/games/elder_scrolls.rb#120
    def weapon; end
  end
end

class Faker::Games::Fallout < ::Faker::Base
  class << self
    # Produces the name of a character from the Fallout games.
    #
    # @example
    #   Faker::Games::Fallout.character #=> "Liberty Prime"
    # @return [String]
    #
    # source://faker//lib/faker/games/fallout.rb#16
    def character; end

    # Produces the name of a faction from the Fallout games.
    #
    # @example
    #   Faker::Games::Fallout.faction #=> "Brotherhood of Steel"
    # @return [String]
    #
    # source://faker//lib/faker/games/fallout.rb#29
    def faction; end

    # Produces the name of a location from the Fallout games.
    #
    # @example
    #   Faker::Games::Fallout.location #=> "New Vegas"
    # @return [String]
    #
    # source://faker//lib/faker/games/fallout.rb#42
    def location; end

    # Produces a quote from the Fallout games.
    #
    # @example
    #   Faker::Games::Fallout.quote
    #   #=> "Democracy is non-negotiable"
    # @return [String]
    #
    # source://faker//lib/faker/games/fallout.rb#56
    def quote; end
  end
end

class Faker::Games::HalfLife < ::Faker::Base
  class << self
    # Produces the name of a character from the Half-Life games.
    #
    # @example
    #   Faker::Games::HalfLife.character #=> "Gordon Freeman"
    # @return [String]
    #
    # source://faker//lib/faker/games/half_life.rb#16
    def character; end

    # Produces the name of an enemy from the Half-Life games.
    #
    # @example
    #   Faker::Games::HalfLife.enemy #=> "Headcrab"
    # @return [String]
    #
    # source://faker//lib/faker/games/half_life.rb#29
    def enemy; end

    # Produces the name of a location from the Half-Life games.
    #
    # @example
    #   Faker::Games::HalfLife.location #=> "Black Mesa Research Facility"
    # @return [String]
    #
    # source://faker//lib/faker/games/half_life.rb#42
    def location; end
  end
end

class Faker::Games::Heroes < ::Faker::Base
  class << self
    # Produces the name of an artifact from Heroes 3.
    #
    # @example
    #   Faker::Games::Heroes.artifact #=> "Armageddon's Blade"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes.rb#55
    def artifact; end

    # Produces the name of a class from Heroes 3.
    #
    # @example
    #   Faker::Games::Heroes.klass #=> "Knight"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes.rb#42
    def klass; end

    # Produces the name of a hero from Heroes 3.
    #
    # @example
    #   Faker::Games::Heroes.name #=> "Christian"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes.rb#16
    def name; end

    # Produces the name of a specialty from Heroes 3.
    #
    # @example
    #   Faker::Games::Heroes.specialty #=> "Ballista"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes.rb#29
    def specialty; end
  end
end

class Faker::Games::HeroesOfTheStorm < ::Faker::Base
  class << self
    # Produces a battleground from Heroes of the Storm.
    #
    # @example
    #   Faker::Games::HeroesOfTheStorm.battleground #=> "Towers of Doom"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes_of_the_storm.rb#16
    def battleground; end

    # This method is deprecated. The implementation will be removed in a near future release.
    # Use `HeroesOfTheStorm.class_name` instead.
    #
    # @deprecated Use {#class_name} instead.
    #
    # source://faker//lib/faker/games/heroes_of_the_storm.rb#25
    def class; end

    # Produces a class name from Heroes of the Storm.
    #
    # @example
    #   Faker::Games::HeroesOfTheStorm.class_name #=> "Support"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes_of_the_storm.rb#40
    def class_name; end

    # Produces a hero from Heroes of the Storm.
    #
    # @example
    #   Faker::Games::HeroesOfTheStorm.hero #=> "Illidan"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes_of_the_storm.rb#53
    def hero; end

    # Produces a quote from Heroes of the Storm.
    #
    # @example
    #   Faker::Games::HeroesOfTheStorm.quote #=> "MEAT!!!"
    # @return [String]
    #
    # source://faker//lib/faker/games/heroes_of_the_storm.rb#66
    def quote; end
  end
end

class Faker::Games::LeagueOfLegends < ::Faker::Base
  class << self
    # Produces the name of a champion from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.champion #=> "Jarvan IV"
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#16
    def champion; end

    # Produces a location from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.location #=> "Demacia"
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#29
    def location; end

    # Produces a mastery from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.masteries #=> "Double Edged Sword"
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#68
    def masteries; end

    # Produces a quote from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.quote #=> "Purge the unjust."
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#42
    def quote; end

    # Produces a rank from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.rank #=> "Bronze V"
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#81
    def rank; end

    # Produces a summoner spell from League of Legends.
    #
    # @example
    #   Faker::Games::LeagueOfLegends.summoner_spell #=> "Flash"
    # @return [String]
    #
    # source://faker//lib/faker/games/league_of_legends.rb#55
    def summoner_spell; end
  end
end

class Faker::Games::Minecraft < ::Faker::Base
  class << self
    # Produces the name of an achievement from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.achievement #=> "Time to Mine!"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#16
    def achievement; end

    # Produces the name of a biome from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.biome #=> "Jungle"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#29
    def biome; end

    # Produces the name of a block from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.block #=> "Stone"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#42
    def block; end

    # Produces the name of a enchantment from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.enchantment #=> "Fire Protection"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#55
    def enchantment; end

    # Produces the name of a game mode from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.game_mode #=> "Survival"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#68
    def game_mode; end

    # Produces the name of an item from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.item #=> "Iron Shovel"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#81
    def item; end

    # Produces the name of a mob from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.mob #=> "Sheep"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#94
    def mob; end

    # Produces the name of a status effect from Minecraft.
    #
    # @example
    #   Faker::Games::Minecraft.status_effect #=> "Weakness"
    # @return [String]
    #
    # source://faker//lib/faker/games/minecraft.rb#107
    def status_effect; end
  end
end

class Faker::Games::Myst < ::Faker::Base
  class << self
    # Produces the name of an age from Myst.
    #
    # @example
    #   Faker::Games::Myst.age #=> "Relto"
    # @return [String]
    #
    # source://faker//lib/faker/games/myst.rb#42
    def age; end

    # Produces the name of a character from Myst.
    #
    # @example
    #   Faker::Games::Myst.character #=> "Gehn"
    # @return [String]
    #
    # source://faker//lib/faker/games/myst.rb#55
    def character; end

    # Produces the name of a creature from Myst.
    #
    # @example
    #   Faker::Games::Myst.creature #=> "squee"
    # @return [String]
    #
    # source://faker//lib/faker/games/myst.rb#29
    def creature; end

    # Produces the name of a game from the Myst series.
    #
    # @example
    #   Faker::Games::Myst.game #=> "Myst III: Exile"
    # @return [String]
    #
    # source://faker//lib/faker/games/myst.rb#16
    def game; end

    # Produces a quote from Myst.
    #
    # @example
    #   Faker::Games::Myst.quote #=> "I realized, the moment I fell into the fissure, that the Book would not be destroyed as I had planned."
    # @return [String]
    #
    # source://faker//lib/faker/games/myst.rb#68
    def quote; end
  end
end

class Faker::Games::Overwatch < ::Faker::Base
  class << self
    # Produces the name of a hero from Overwatch.
    #
    # @example
    #   Faker::Games::Overwatch.hero #=> "Tracer"
    # @return [String]
    #
    # source://faker//lib/faker/games/overwatch.rb#16
    def hero; end

    # Produces the name of a location from Overwatch.
    #
    # @example
    #   Faker::Games::Overwatch.location #=> "Numbani"
    # @return [String]
    #
    # source://faker//lib/faker/games/overwatch.rb#29
    def location; end

    # Produces a quote from Overwatch.
    #
    # @example
    #   Faker::Games::Overwatch.quote #=> "It's high noon"
    # @return [String]
    #
    # source://faker//lib/faker/games/overwatch.rb#42
    def quote; end
  end
end

class Faker::Games::Pokemon < ::Faker::Base
  class << self
    # Produces a location from Pokemon.
    #
    # @example
    #   Faker::Games::Pokemon.location #=> "Pallet Town"
    # @return [String]
    #
    # source://faker//lib/faker/games/pokemon.rb#29
    def location; end

    # Produces a move from Pokemon.
    #
    # @example
    #   Faker::Games::Pokemon.move #=> "Thunder Shock"
    # @return [String]
    #
    # source://faker//lib/faker/games/pokemon.rb#42
    def move; end

    # Produces the name of a Pokemon.
    #
    # @example
    #   Faker::Games::Pokemon.name #=> "Pikachu"
    # @return [String]
    #
    # source://faker//lib/faker/games/pokemon.rb#16
    def name; end
  end
end

class Faker::Games::SonicTheHedgehog < ::Faker::Base
  class << self
    # Produces the name of a character from Sonic the Hedgehog.
    #
    # @example
    #   Faker::Games::SonicTheHedgehog.character #=> "Sonic the Hedgehog"
    # @return [String]
    #
    # source://faker//lib/faker/games/sonic_the_hedgehog.rb#16
    def character; end

    # Produces the name of a game from the Sonic the Hedgehog series.
    #
    # @example
    #   Faker::Games::SonicTheHedgehog.game #=> "Waku Waku Sonic Patrol Car"
    # @return [String]
    #
    # source://faker//lib/faker/games/sonic_the_hedgehog.rb#42
    def game; end

    # Produces the name of a zone from Sonic the Hedgehog.
    #
    # @example
    #   Faker::Games::SonicTheHedgehog.zone #=> "Green Hill Zone"
    # @return [String]
    #
    # source://faker//lib/faker/games/sonic_the_hedgehog.rb#29
    def zone; end
  end
end

class Faker::Games::StreetFighter < ::Faker::Base
  class << self
    # Produces the name of a playable character from Street Fighter.
    #
    # @example
    #   Faker::Games::StreetFighter.character #=> "Ryu"
    # @return [String]
    #
    # source://faker//lib/faker/games/street_fighter.rb#16
    def character; end

    # Produces the name of a move from Street Fighter.
    #
    # @example
    #   Faker::Games::StreetFighter.move #=> "Shoryuken"
    # @return [String]
    #
    # source://faker//lib/faker/games/street_fighter.rb#55
    def move; end

    # Produces a quote from Street Fighter.
    #
    # @example
    #   Faker::Games::StreetFighter.quote #=> "Go home and be a family man."
    # @return [String]
    #
    # source://faker//lib/faker/games/street_fighter.rb#42
    def quote; end

    # Produces the name of a stage from Street Fighter.
    #
    # @example
    #   Faker::Games::StreetFighter.stage #=> "Volcanic Rim"
    # @return [String]
    #
    # source://faker//lib/faker/games/street_fighter.rb#29
    def stage; end
  end
end

class Faker::Games::SuperMario < ::Faker::Base
  class << self
    # Produces the name of a Super Mario character.
    #
    # @example
    #   Faker::Games::SuperMario.character #=> "Luigi"
    # @return [String]
    #
    # source://faker//lib/faker/games/super_mario.rb#16
    def character; end

    # Produces the name of a Super Mario game.
    #
    # @example
    #   Faker::Games::SuperMario.game #=> "Super Mario Odyssey"
    # @return [String]
    #
    # source://faker//lib/faker/games/super_mario.rb#29
    def game; end

    # Produces the name of a Super Mario location.
    #
    # @example
    #   Faker::Games::SuperMario.location #=> "Kong City"
    # @return [String]
    #
    # source://faker//lib/faker/games/super_mario.rb#42
    def location; end
  end
end

class Faker::Games::SuperSmashBros < ::Faker::Base
  class << self
    # Produces the name of a fighter from the Smash Bros games.
    #
    # @example
    #   Faker::Games::SuperSmashBros.fighter #=> "Mario"
    # @return [String]
    #
    # source://faker//lib/faker/games/super_smash_bros.rb#16
    def fighter; end

    # Produces the name of a stage from the Smash Bros games.
    #
    # @example
    #   Faker::Games::SuperSmashBros.stage #=> "Final Destination"
    # @return [String]
    #
    # source://faker//lib/faker/games/super_smash_bros.rb#29
    def stage; end
  end
end

class Faker::Games::Tarkov < ::Faker::Base
  class << self
    # Produces a random boss from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.boss #=> "Tagilla"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#68
    def boss; end

    # Produces a random faction from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.faction #=> "USEC"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#81
    def faction; end

    # Produces a random quest from Fence from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.fence_quest #=> "Compensation for Damage - Wager"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#199
    def fence_quest; end

    # Produces a random item from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.item #=> "Diary"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#42
    def item; end

    # Produces a random quest from Jaeger from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.jaeger_quest #=> "The Tarkov Shooter - Part 1"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#186
    def jaeger_quest; end

    # Produces a random location from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.location #=> "Customs"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#16
    def location; end

    # Produces a random quest from Mechanic from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.mechanic_quest #=> "Signal - Part 4"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#160
    def mechanic_quest; end

    # Produces a random quest from Peacekeeper from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.peacekeeper_quest #=> "Overpopulation"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#147
    def peacekeeper_quest; end

    # Produces a random quest from Prapor from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.prapor_quest #=> "Easy Job - Part 2
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#108
    def prapor_quest; end

    # Produces a random quest from a random trader from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.quest #=> "The Key to Success"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#94
    def quest; end

    # Produces a random quest from Ragman from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.ragman_quest #=> "Hot Delivery"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#173
    def ragman_quest; end

    # Produces a random quest from Skier from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.skier_quest #=> "Safe Corridor"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#134
    def skier_quest; end

    # Produces a random quest from Therapist from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.therapist_quest #=> "Supply Plans"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#121
    def therapist_quest; end

    # Produces a random trader from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.trader #=> "Prapor"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#29
    def trader; end

    # Produces a random weapon from Escape from Tarkov.
    #
    # @example
    #   Faker::Games::Tarkov.weapon #=> "AK-74N"
    # @return [String]
    #
    # source://faker//lib/faker/games/tarkov.rb#55
    def weapon; end
  end
end

class Faker::Games::Touhou < ::Faker::Base
  class << self
    # Produces the name of a character from the Touhou games.
    #
    # @example
    #   Faker::Games::Touhou.character #=> "Sanae Kochiya"
    # @return [String]
    #
    # source://faker//lib/faker/games/touhou.rb#30
    def character; end

    # Produces the name of a Touhou game.
    #
    # @example
    #   Faker::Games::Touhou.game #=> "Mountain of Faith"
    # @return [String]
    #
    # source://faker//lib/faker/games/touhou.rb#17
    def game; end

    # Produces the name of a location from the Touhou games.
    #
    # @example
    #   Faker::Games::Touhou.location #=> "Moriya Shrine"
    # @return [String]
    #
    # source://faker//lib/faker/games/touhou.rb#43
    def location; end

    # Produces the name of a song from the Touhou games.
    #
    # @example
    #   Faker::Games::Touhou.song #=> "Faith Is for the Transient People"
    # @return [String]
    #
    # source://faker//lib/faker/games/touhou.rb#69
    def song; end

    # Produces the name of a spell card from the Touhou games.
    #
    # @example
    #   Faker::Games::Touhou.spell_card #=> 'Esoterica "Gray Thaumaturgy"'
    # @return [String]
    #
    # source://faker//lib/faker/games/touhou.rb#56
    def spell_card; end
  end
end

class Faker::Games::WarhammerFantasy < ::Faker::Base
  class << self
    # Produces a creature from the Warhammer Fantasy setting.
    #
    # @example
    #   Faker::Games::WarhammerFantasy.creature #=> "Hydra"
    # @return [String]
    #
    # source://faker//lib/faker/games/warhammer_fantasy.rb#68
    def creature; end

    # Produces a faction from the Warhammer Fantasy setting.
    #
    # @example
    #   Faker::Games::WarhammerFantasy.faction #=> "Bretonnia"
    # @return [String]
    #
    # source://faker//lib/faker/games/warhammer_fantasy.rb#55
    def faction; end

    # Produces the name of a hero from the Warhammer Fantasy setting.
    #
    # @example
    #   Faker::Games::WarhammerFantasy.hero #=> "Sigmar Heldenhammer"
    # @return [String]
    #
    # source://faker//lib/faker/games/warhammer_fantasy.rb#16
    def hero; end

    # Produces a location from the Warhammer Fantasy setting.
    #
    # @example
    #   Faker::Games::WarhammerFantasy.location #=> "Lustria"
    # @return [String]
    #
    # source://faker//lib/faker/games/warhammer_fantasy.rb#42
    def location; end

    # Produces a quote from the Warhammer Fantasy setting.
    #
    # @example
    #   Faker::Games::WarhammerFantasy.quote #=> "The softest part of a castle is the belly of the man inside."
    # @return [String]
    #
    # source://faker//lib/faker/games/warhammer_fantasy.rb#29
    def quote; end
  end
end

class Faker::Games::Witcher < ::Faker::Base
  class << self
    # Produces the name of a book from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.book #=> "Sword of Destiny"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#120
    def book; end

    # Produces the name of a character from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.character #=> "Triss Merigold"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#16
    def character; end

    # Produces the name of a location from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.location #=> "Novigrad"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#55
    def location; end

    # Produces the name of a monster from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.monster #=> "Katakan"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#81
    def monster; end

    # Produces the name of a potion from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.potion #=> "Gadwall"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#107
    def potion; end

    # Produces a quote from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.quote #=> "No Lollygagin'!"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#68
    def quote; end

    # Produces the name of a school from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.school #=> "Wolf"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#42
    def school; end

    # Produces the name of a sign from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.sign #=> "Igni"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#94
    def sign; end

    # Produces the name of a witcher from The Witcher.
    #
    # @example
    #   Faker::Games::Witcher.witcher #=> "Geralt of Rivia"
    # @return [String]
    #
    # source://faker//lib/faker/games/witcher.rb#29
    def witcher; end
  end
end

class Faker::Games::WorldOfWarcraft < ::Faker::Base
  class << self
    # Produces a class name from World of Warcraft.
    #
    # @example
    #   Faker::Games::WorldOfWarcraft.class_name #=> "Druid"
    # @return [String]
    #
    # source://faker//lib/faker/games/world_of_warcraft.rb#29
    def class_name; end

    # Produces the name of a hero from World of Warcraft.
    #
    # @example
    #   Faker::Games::WorldOfWarcraft.hero #=> "Uther the Lightbringer"
    # @return [String]
    #
    # source://faker//lib/faker/games/world_of_warcraft.rb#16
    def hero; end

    # Produces a quote from World of Warcraft.
    #
    # @example
    #   Faker::Games::WorldOfWarcraft.quote #=> "These are dark times indeed."
    # @return [String]
    #
    # source://faker//lib/faker/games/world_of_warcraft.rb#54
    def quote; end

    # Produces the name of a race from World of Warcraft.
    #
    # @example
    #   Faker::Games::WorldOfWarcraft.race #=> "Druid"
    # @return [String]
    #
    # source://faker//lib/faker/games/world_of_warcraft.rb#41
    def race; end
  end
end

class Faker::Games::Zelda < ::Faker::Base
  class << self
    # Produces the name of a character from the Legend of Zelda games.
    #
    # @example
    #   Faker::Games::Zelda.character #=> "Link"
    # @return [String]
    #
    # source://faker//lib/faker/games/zelda.rb#30
    def character; end

    # Produces the name of a Legend of Zelda game.
    #
    # @example
    #   Faker::Games::Zelda.game #=> "Breath of the Wild"
    # @return [String]
    #
    # source://faker//lib/faker/games/zelda.rb#17
    def game; end

    # Produces the name of an item from the Legend of Zelda games.
    #
    # @example
    #   Faker::Games::Zelda.item #=> "Boomerang"
    # @return [String]
    #
    # source://faker//lib/faker/games/zelda.rb#56
    def item; end

    # Produces the name of a character from the Legend of Zelda games.
    #
    # @example
    #   Faker::Games::Zelda.location #=> "Hyrule Castle"
    # @return [String]
    #
    # source://faker//lib/faker/games/zelda.rb#43
    def location; end
  end
end

class Faker::Gender < ::Faker::Base
  class << self
    # Produces either 'Male' or 'Female'.
    #
    # @example
    #   Faker::Gender.binary_type #=> "Female"
    # @return [String]
    #
    # source://faker//lib/faker/default/gender.rb#28
    def binary_type; end

    # Produces either 'f' or 'm'.
    #
    # @example
    #   Faker::Gender.short_binary_type #=> "f"
    # @return [String]
    #
    # source://faker//lib/faker/default/gender.rb#41
    def short_binary_type; end

    # Produces the name of a gender identity.
    #
    # @example
    #   Faker::Gender.type #=> "Non-binary"
    # @return [String]
    #
    # source://faker//lib/faker/default/gender.rb#15
    def type; end
  end
end

class Faker::GreekPhilosophers < ::Faker::Base
  class << self
    # Produces the name of a Greek philosopher.
    #
    # @example
    #   Faker::GreekPhilosophers.name #=> "Socrates"
    # @return [String]
    #
    # source://faker//lib/faker/default/greek_philosophers.rb#15
    def name; end

    # Produces a quote from a Greek philosopher.
    #
    # @example
    #   Faker::GreekPhilosophers.quote #=> "Only the educated are free."
    # @return [String]
    #
    # source://faker//lib/faker/default/greek_philosophers.rb#28
    def quote; end
  end
end

# Port of http://shinytoylabs.com/jargon/
# Are you having trouble writing tech-savvy dialogue for your latest screenplay?
# Worry not! Hollywood-grade technical talk is ready to fill out any form where you need to look smart.
class Faker::Hacker < ::Faker::Base
  class << self
    # Short technical abbreviations.
    #
    # @example
    #   Faker::Hacker.abbreviation #=> "RAM"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#34
    def abbreviation; end

    # Hacker-centric adjectives.
    #
    # @example
    #   Faker::Hacker.adjective #=> "open-source"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#47
    def adjective; end

    # Produces a verb that ends with '-ing'.
    #
    # @example
    #   Faker::Hacker.ingverb #=> "synthesizing"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#86
    def ingverb; end

    # Only the best hacker-related nouns.
    #
    # @example
    #   Faker::Hacker.noun #=> "bandwidth"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#60
    def noun; end

    # @private
    #
    # source://faker//lib/faker/default/hacker.rb#91
    def phrases; end

    # Produces something smart.
    #
    # @example
    #   Faker::Hacker.say_something_smart
    #   #=> "Try to compress the SQL interface, maybe it will program the back-end hard drive!"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#21
    def say_something_smart; end

    # Actions that hackers take.
    #
    # @example
    #   Faker::Hacker.verb #=> "bypass"
    # @return [String]
    #
    # source://faker//lib/faker/default/hacker.rb#73
    def verb; end
  end
end

class Faker::Hipster < ::Faker::Base
  class << self
    # Produces a random hipster paragraph.
    #
    # @example
    #   Faker::Hipster.paragraph #=> "Migas fingerstache pbr&b tofu. Polaroid distillery typewriter echo tofu actually. Slow-carb fanny pack pickled direct trade scenester mlkshk plaid. Banjo venmo chambray cold-pressed typewriter. Fap skateboard intelligentsia."
    #   Faker::Hipster.paragraph(sentence_count: 2) #=> "Yolo tilde farm-to-table hashtag. Lomo kitsch disrupt forage +1."
    #   Faker::Hipster.paragraph(sentence_count: 2, supplemental: true) #=> "Typewriter iste ut viral kombucha voluptatem. Sint voluptates saepe. Direct trade irony chia excepturi yuccie. Biodiesel esse listicle et quam suscipit."
    #   Faker::Hipster.paragraph(sentence_count: 2, supplemental: false, random_sentences_to_add: 4) #=> "Selvage vhs chartreuse narwhal vinegar. Authentic vinyl truffaut carry vhs pop-up. Hammock everyday iphone locavore thundercats bitters vegan goth. Fashion axe banh mi shoreditch whatever artisan."
    #   Faker::Hipster.paragraph(sentence_count: 2, supplemental: true, random_sentences_to_add: 4) #=> "Deep v gluten-free unde waistcoat aperiam migas voluptas dolorum. Aut drinking illo sustainable sapiente. Direct trade fanny pack kale chips ennui semiotics."
    # @param sentence_count [Integer] Specifies the number of sentences in the paragraph
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @param random_sentences_to_add [Boolean] Specifies the number of random sentences to add
    # @return [String]
    #
    # source://faker//lib/faker/default/hipster.rb#109
    def paragraph(sentence_count: T.unsafe(nil), supplemental: T.unsafe(nil), random_sentences_to_add: T.unsafe(nil)); end

    # Produces a random hipster paragraph by characters.
    #
    # @example
    #   Faker::Hipster.paragraph_by_chars #=> "Truffaut stumptown trust fund 8-bit messenger bag portland. Meh kombucha selvage swag biodiesel. Lomo kinfolk jean shorts asymmetrical diy. Wayfarers portland twee stumptown. Wes anderson biodiesel retro 90's pabst. Diy echo 90's mixtape semiotics. Cornho."
    #   Faker::Hipster.paragraph_by_chars(characters: 256, supplemental: false) #=> "Hella kogi blog narwhal sartorial selfies mustache schlitz. Bespoke normcore kitsch cred hella fixie. Park aesthetic fixie migas twee. Cliche mustache brunch tumblr fixie godard. Drinking pop-up synth hoodie dreamcatcher typewriter. Kitsch biodiesel green."
    # @param characters [Integer] Specifies the number of characters in the paragraph
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @return [String]
    #
    # source://faker//lib/faker/default/hipster.rb#146
    def paragraph_by_chars(characters: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Produces random hipster paragraphs.
    #
    # @example
    #   Faker::Hipster.paragraphs #=> ["Tilde microdosing blog cliche meggings. Intelligentsia five dollar toast forage yuccie. Master kitsch knausgaard. Try-hard everyday trust fund mumblecore.", "Normcore viral pickled. Listicle humblebrag swag tote bag. Taxidermy street hammock neutra butcher cred kale chips. Blog portland humblebrag trust fund irony.", "Single-origin coffee fixie cleanse tofu xoxo. Post-ironic tote bag ramps gluten-free locavore mumblecore hammock. Umami loko twee. Ugh kitsch before they sold out."]
    #   Faker::Hipster.paragraphs(number: 1) #=> ["Skateboard cronut synth +1 fashion axe. Pop-up polaroid skateboard asymmetrical. Ennui fingerstache shoreditch before they sold out. Tattooed pitchfork ramps. Photo booth yr messenger bag raw denim bespoke locavore lomo synth."]
    #   Faker::Hipster.paragraphs(number: 1, supplemental: true) #=> ["Quae direct trade pbr&b quo taxidermy autem loko. Umami quas ratione migas cardigan sriracha minima. Tenetur perspiciatis pickled sed eum doloribus truffaut. Excepturi dreamcatcher meditation."]
    # @param number [Integer] Specifies the number of paragraphs
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/hipster.rb#126
    def paragraphs(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Produces a random hipster sentence.
    #
    # @example
    #   Faker::Hipster.sentence #=> "Park iphone leggings put a bird on it."
    #   Faker::Hipster.sentence(word_count: 3) #=> "Pour-over swag godard."
    #   Faker::Hipster.sentence(word_count: 3, supplemental: true) #=> "Beard laboriosam sequi celiac."
    #   Faker::Hipster.sentence(word_count: 3, supplemental: false, random_words_to_add: 4) #=> "Bitters retro mustache aesthetic biodiesel 8-bit."
    #   Faker::Hipster.sentence(word_count: 3, supplemental: true, random_words_to_add: 4) #=> "Occaecati deleniti messenger bag meh crucifix autem."
    #   Faker::Hipster.sentence(word_count: 3, supplemental: true, random_words_to_add: 0, open_compounds_allowed: true) #=> "Kale chips nihil eos."
    #   Faker::Hipster.sentence(word_count: 3, supplemental: true, random_words_to_add: 0, open_compounds_allowed: false) #=> "Dreamcatcher umami fixie."
    # @param word_count [Integer] Specifies the number of words in the sentence
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @param random_words_to_add [Integer] Specifies the number of random words to add
    # @param open_compounds_allowed [Boolean] Specifies if the generated sentence can contain words having additional spaces
    # @return [String]
    #
    # source://faker//lib/faker/default/hipster.rb#68
    def sentence(word_count: T.unsafe(nil), supplemental: T.unsafe(nil), random_words_to_add: T.unsafe(nil), open_compounds_allowed: T.unsafe(nil)); end

    # Produces random hipster sentences.
    #
    # @example
    #   Faker::Hipster.sentences #=> ["Godard pitchfork vinegar chillwave everyday 90's whatever.", "Pour-over artisan distillery street waistcoat.", "Salvia yr leggings franzen blue bottle."]
    #   Faker::Hipster.sentences(number: 1) #=> ["Before they sold out pinterest venmo umami try-hard ugh hoodie artisan."]
    #   Faker::Hipster.sentences(number: 1, supplemental: true) #=> ["Et sustainable optio aesthetic et."]
    # @param number [Integer] Specifies the number of sentences returned
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/hipster.rb#85
    def sentences(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Produces a random hipster word.
    #
    # @example
    #   Faker::Hipster.word #=> "irony"
    # @return [String]
    #
    # source://faker//lib/faker/default/hipster.rb#15
    def word; end

    # Produces a random hipster word.
    #
    # @example
    #   Faker::Hipster.words #=> ["pug", "pitchfork", "chia"]
    #   Faker::Hipster.words(number: 4) #=> ["ugh", "cardigan", "poutine", "stumptown"]
    #   Faker::Hipster.words(number: 4, supplemental: true) #=> ["iste", "seitan", "normcore", "provident"]
    #   Faker::Hipster.words(number: 4, supplemental: true, spaces_allowed: true) #=> ["qui", "magni", "craft beer", "est"]
    # @param number [Integer] Specifies the number of words returned
    # @param supplemental [Boolean] Specifies if the words are supplemental
    # @param spaces_allowed [Boolean] Specifies if the words may contain spaces
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/hipster.rb#35
    def words(number: T.unsafe(nil), supplemental: T.unsafe(nil), spaces_allowed: T.unsafe(nil)); end
  end
end

class Faker::Hobby < ::Faker::Base
  class << self
    # Retrieves a typical hobby activity.
    #
    # @example
    #   Faker::Hobby.activity #=> "Cooking"
    # @return [String]
    #
    # source://faker//lib/faker/default/hobby.rb#17
    def activity; end
  end
end

class Faker::House < ::Faker::Base
  class << self
    # Produces the name of a piece of furniture.
    #
    # @example
    #   Faker::House.furniture #=> "chair"
    # @return [String]
    #
    # source://faker//lib/faker/default/house.rb#15
    def furniture; end

    # Produces the name of a room in a house.
    #
    # @example
    #   Faker::House.room #=> "kitchen"
    # @return [String]
    #
    # source://faker//lib/faker/default/house.rb#28
    def room; end
  end
end

class Faker::IDNumber < ::Faker::Base
  class << self
    # Produces a random Brazilian Citizen Number (CPF).
    #
    # @example
    #   Faker::IDNumber.brazilian_citizen_number #=> "53540542221"
    #   Faker::IDNumber.brazilian_citizen_number(formatted: true) #=> "535.405.422-21"
    # @param formatted [Boolean] Specifies if the number is formatted with dividers.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#149
    def brazilian_citizen_number(formatted: T.unsafe(nil)); end

    # Produces a random Brazilian Citizen Number (CPF).
    #
    # @example
    #   Faker::IDNumber.brazilian_citizen_number #=> "53540542221"
    #   Faker::IDNumber.brazilian_citizen_number(formatted: true) #=> "535.405.422-21"
    # @param formatted [Boolean] Specifies if the number is formatted with dividers.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#149
    def brazilian_cpf(formatted: T.unsafe(nil)); end

    # Produces a random Brazilian ID Number (RG).
    #
    # @example
    #   Faker::IDNumber.brazilian_id #=> "493054029"
    #   Faker::IDNumber.brazilian_id(formatted: true) #=> "49.305.402-9"
    # @param formatted [Boolean] Specifies if the number is formatted with dividers.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#170
    def brazilian_id(formatted: T.unsafe(nil)); end

    # Produces a random Brazilian ID Number (RG).
    #
    # @example
    #   Faker::IDNumber.brazilian_id #=> "493054029"
    #   Faker::IDNumber.brazilian_id(formatted: true) #=> "49.305.402-9"
    # @param formatted [Boolean] Specifies if the number is formatted with dividers.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#170
    def brazilian_rg(formatted: T.unsafe(nil)); end

    # Produces a random Chilean ID (Rut with 8 digits).
    #
    # @example
    #   Faker::IDNumber.chilean_id #=> "15620613-K"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#188
    def chilean_id; end

    # Produces a random Croatian ID number (OIB).
    #
    # @example
    #   Faker::IDNumber.croatian_id #=> "88467617508"
    #   Faker::IDNumber.croatian_id(international: true) #=> "HR88467617508"
    # @param international [Boolean] Specifies whether to add international prefix.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#206
    def croatian_id(international: T.unsafe(nil)); end

    # Produces a random Danish ID Number (CPR number).
    # CPR number is 10 digits. Digit 1-6 is the birthdate (format "DDMMYY").
    # Digit 7-10 is a sequence number.
    # Digit 7 digit is a control digit that determines the century of birth.
    # Digit 10 reveals the gender: # even is female, odd is male.
    #
    # @example
    #   Faker::IDNumber.danish_id_number #=> "0503909980"
    #   Faker::IDNumber.danish_id_number(formatted: true) #=> "050390-9980"
    #   Faker::IDNumber.danish_id_number(birthday: Date.new(1990, 3, 5)) #=> "0503909980"
    #   Faker::IDNumber.danish_id_number(gender: :female) #=> "0503909980"
    # @param formatted [Boolean] Specifies if the number is formatted with dividers.
    # @param birthday [Date] Specifies the birthday for the id number.
    # @param gender [Symbol] Specifies the gender for the id number. Must be one :male or :female if present.
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#233
    def danish_id_number(formatted: T.unsafe(nil), birthday: T.unsafe(nil), gender: T.unsafe(nil)); end

    # Produces a random French social security number (INSEE number).
    #
    # @example
    #   Faker::IDNumber.french_insee_number #=> "53290236-H"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#267
    def french_insee_number; end

    # Produces a random invalid US Social Security number.
    #
    # @example
    #   Faker::IDNumber.invalid #=> "311-72-0000"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#44
    def invalid; end

    # Produces a random invalid South African ID Number.
    #
    # @example
    #   Faker::IDNumber.invalid_south_african_id_number #=> "1642972065088"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#121
    def invalid_south_african_id_number; end

    # Produces a random valid South African ID Number.
    #
    # @example
    #   Faker::IDNumber.south_african_id_number #=> "8105128870184"
    #   Faker::IDNumber.valid_south_african_id_number #=> "8105128870184"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#99
    def south_african_id_number; end

    # Produces a random Spanish citizen identifier (DNI).
    #
    # @example
    #   Faker::IDNumber.spanish_citizen_number #=> "53290236-H"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#63
    def spanish_citizen_number; end

    # Produces a random Spanish foreign born citizen identifier (NIE).
    #
    # @example
    #   Faker::IDNumber.spanish_foreign_citizen_number #=> "Z-1600870-Y"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#79
    def spanish_foreign_citizen_number; end

    # source://faker//lib/faker/default/id_number.rb#48
    def ssn_valid; end

    # Produces a random valid US Social Security number.
    #
    # @example
    #   Faker::IDNumber.valid #=> "552-56-3593"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#31
    def valid; end

    # Produces a random valid South African ID Number.
    #
    # @example
    #   Faker::IDNumber.south_african_id_number #=> "8105128870184"
    #   Faker::IDNumber.valid_south_african_id_number #=> "8105128870184"
    # @return [String]
    #
    # source://faker//lib/faker/default/id_number.rb#99
    def valid_south_african_id_number; end

    private

    # source://faker//lib/faker/default/id_number.rb#405
    def _translate(key); end

    # source://faker//lib/faker/default/id_number.rb#335
    def brazilian_citizen_number_checksum_digit(digits); end

    # source://faker//lib/faker/default/id_number.rb#356
    def brazilian_citizen_number_digit(remainder); end

    # source://faker//lib/faker/default/id_number.rb#345
    def brazilian_document_checksum(digits); end

    # source://faker//lib/faker/default/id_number.rb#351
    def brazilian_document_digit(checksum, id: T.unsafe(nil)); end

    # source://faker//lib/faker/default/id_number.rb#340
    def brazilian_id_checksum_digit(digits); end

    # source://faker//lib/faker/default/id_number.rb#360
    def brazilian_id_digit(remainder); end

    # source://faker//lib/faker/default/id_number.rb#297
    def chilean_verification_code(digits); end

    # source://faker//lib/faker/default/id_number.rb#282
    def croatian_id_checksum_digit(digits); end

    # source://faker//lib/faker/default/id_number.rb#366
    def danish_control_digits(birthday); end

    # source://faker//lib/faker/default/id_number.rb#317
    def south_african_id_checksum_digit(id_number); end
  end
end

# source://faker//lib/faker/default/id_number.rb#15
Faker::IDNumber::BRAZILIAN_ID_FORMAT = T.let(T.unsafe(nil), Regexp)

# source://faker//lib/faker/default/id_number.rb#16
Faker::IDNumber::BRAZILIAN_ID_FROM = T.let(T.unsafe(nil), Integer)

# source://faker//lib/faker/default/id_number.rb#17
Faker::IDNumber::BRAZILIAN_ID_TO = T.let(T.unsafe(nil), Integer)

# source://faker//lib/faker/default/id_number.rb#5
Faker::IDNumber::CHECKS = T.let(T.unsafe(nil), String)

# source://faker//lib/faker/default/id_number.rb#19
Faker::IDNumber::CHILEAN_MODULO = T.let(T.unsafe(nil), Integer)

# source://faker//lib/faker/default/id_number.rb#6
Faker::IDNumber::INVALID_SSN = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/id_number.rb#14
Faker::IDNumber::ZA_CITIZENSHIP_DIGITS = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/id_number.rb#13
Faker::IDNumber::ZA_RACE_DIGIT = T.let(T.unsafe(nil), String)

class Faker::IndustrySegments < ::Faker::Base
  class << self
    # Produces the name of an industry.
    #
    # @example
    #   Faker::IndustrySegments.industry #=> "Basic Materials"
    # @return [String]
    #
    # source://faker//lib/faker/default/industry_segments.rb#17
    def industry; end

    # Produces the name of a sector of an industry.
    #
    # @example
    #   Faker::IndustrySegments.sector #=> "Industrial Metals & Mining"
    # @return [String]
    #
    # source://faker//lib/faker/default/industry_segments.rb#43
    def sector; end

    # Produces the name of a subsector of an industry.
    #
    # @example
    #   Faker::IndustrySegments.industry #=> "Basic Materials"
    # @return [String]
    #
    # source://faker//lib/faker/default/industry_segments.rb#56
    def sub_sector; end

    # Produces the name of a super-sector of an industry.
    #
    # @example
    #   Faker::IndustrySegments.super_sector #=> "Basic Resources"
    # @return [String]
    #
    # source://faker//lib/faker/default/industry_segments.rb#30
    def super_sector; end
  end
end

class Faker::Internet < ::Faker::Base
  class << self
    # Produces a random string of alphabetic characters, (no digits)
    #
    # @example
    #   Faker::Internet.base64
    #   #=> "r_hbZ2DSD-ZACzZT"
    # @example
    #   Faker::Internet.base64(length: 4, padding: true, urlsafe: false)
    #   #=> "x1/R="
    # @param length [Integer] The length of the string to generate
    # @param padding [Boolean] Toggles if a final equal '=' will be added.
    # @param urlsafe [Boolean] Toggles charset to '-' and '_' instead of '+' and '/'.
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#530
    def base64(length: T.unsafe(nil), padding: T.unsafe(nil), urlsafe: T.unsafe(nil)); end

    # Generate Web Crawler's user agents
    #
    # @example
    #   Faker::Internet.bot_user_agent                        #=> "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
    #   Faker::Internet.bot_user_agent(vendor: 'googlebot')   #=> "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; Googlebot/2.1; +http://www.google.com/bot.html) Chrome/99.0.4844.84 Safari/537.36"
    #   Faker::Internet.bot_user_agent(vendor: 'bingbot')     #=> "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/86.0.4240.68 Safari/537.36 Edg/86.0.622.31"
    # @param vendor [String] Name of vendor, supported vendors are googlebot, bingbot, duckduckbot, baiduspider, yandexbot
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#492
    def bot_user_agent(vendor: T.unsafe(nil)); end

    # Generates random token
    #
    # @return[String]
    #
    # @example
    #   Faker::Internet.device_token  #=> "749f535671cf6b34d8e794d212d00c703b96274e07161b18b082d0d70ef1052f"
    #
    # source://faker//lib/faker/default/internet.rb#459
    def device_token; end

    # Returns the domain name
    #
    # @example
    #   Faker::Internet.domain_name                                       #=> "test.net"
    #   Faker::Internet.domain_name(subdomain: true)                      #=> "test.faker.io"
    #   Faker::Internet.domain_name(subdomain: true, domain: 'example')   #=> "faker.example.com"
    #   Faker::Internet.domain_name(domain: 'faker')                      #=> "faker.org"
    # @param subdomain [Bool] If true passed adds a subdomain in response
    # @param domain [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#207
    def domain_name(subdomain: T.unsafe(nil), domain: T.unsafe(nil)); end

    # Returns the domain suffix e.g. com, org, co, biz, info etc.
    #
    # @example
    #   Faker::Internet.domain_suffix   #=> "com"
    #   Faker::Internet.domain_suffix   #=> "biz"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#258
    def domain_suffix; end

    # Returns the domain word for internet
    #
    # @example
    #   Faker::Internet.domain_word   #=> "senger"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#247
    def domain_word; end

    # Returns the email address
    #
    # @example
    #   Faker::Internet.email                                                           #=> "samsmith@faker.com"
    #   Faker::Internet.email(name: 'smith')                                            #=> "smith@faker.com"
    #   Faker::Internet.email(name: 'sam smith', separators: ['-'])                     #=> "sam-smith@faker.com"
    #   Faker::Internet.email(name: 'sam smith', separators: ['-'], domain: 'gmail')    #=> "sam-smith@gmail.com"
    # @param name [String]
    # @param separators [Array]
    # @param domain [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#32
    def email(name: T.unsafe(nil), separators: T.unsafe(nil), domain: T.unsafe(nil)); end

    # Fixes ä, ö, ü, ß characters in string passed with ae, oe, ue, ss resp.
    #
    # @example
    #   Faker::Internet.fix_umlauts                     #=> ""
    #   Faker::Internet.fix_umlauts(string: 'faker')    #=> "faker"
    #   Faker::Internet.fix_umlauts(string: 'faküer')   #=> "fakueer"
    # @param string [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#236
    def fix_umlauts(string: T.unsafe(nil)); end

    # Returns the email address with domain either gmail.com, yahoo.com or hotmail.com
    #
    # @example
    #   Faker::Internet.free_email                                                           #=> "samsmith@gmail.com"
    #   Faker::Internet.free_email(name: 'smith')                                            #=> "smith@yahoo.com"
    # @param name [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#53
    def free_email(name: T.unsafe(nil)); end

    # Returns the IPv4 address
    #
    # @example
    #   Faker::Internet.ip_v4_address   #=> "97.117.128.93"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#285
    def ip_v4_address; end

    # Returns Ipv4 address with CIDR, range from 1 to 31
    #
    # @example
    #   Faker::Internet.ip_v4_cidr  #=> "129.162.99.74/16"
    #   Faker::Internet.ip_v4_cidr  #=> "129.162.99.74/24"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#388
    def ip_v4_cidr; end

    # Returns Ipv6 address
    #
    # @example
    #   Faker::Internet.ip_v6_address   #=> "7754:76d4:c7aa:7646:ea68:1abb:4055:4343"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#399
    def ip_v6_address; end

    # Returns Ipv6 address with CIDR, range between 1 to 127
    #
    # @example
    #   Faker::Internet.ip_v6_cidr  #=> "beca:9b99:4bb6:9712:af2f:516f:8507:96e1/99"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#410
    def ip_v6_cidr; end

    # Returns the MAC address
    #
    # @example
    #   Faker::Internet.mac_address                   #=> "74:d0:c9:22:95:12"
    #   Faker::Internet.mac_address(prefix: 'a')      #=> "0a:91:ce:24:89:3b"
    #   Faker::Internet.mac_address(prefix: 'aa')     #=> "aa:38:a0:3e:e8:41"
    #   Faker::Internet.mac_address(prefix: 'aa:44')  #=> "aa:44:30:88:6e:95"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#272
    def mac_address(prefix: T.unsafe(nil)); end

    # Produces a randomized string of characters suitable for passwords
    #
    # @example
    #   Faker::Internet.password #=> "Vg5mSvY1UeRg7"
    # @example
    #   Faker::Internet.password(min_length: 8) #=> "YfGjIk0hGzDqS0"
    # @example
    #   Faker::Internet.password(min_length: 10, max_length: 20) #=> "EoC9ShWd1hWq4vBgFw"
    # @example
    #   Faker::Internet.password(min_length: 10, max_length: 20, mix_case: true) #=> "3k5qS15aNmG"
    # @example
    #   Faker::Internet.password(min_length: 10, max_length: 20, mix_case: true, special_characters: true) #=> "*%NkOnJsH4"
    # @param min_length [Integer] The minimum length of the password
    # @param max_length [Integer] The maximum length of the password
    # @param mix_case [Boolean] Toggles if uppercased letters are allowed. If true, at least one will be added.
    # @param special_characters [Boolean] Toggles if special characters are allowed. If true, at least one will be added.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#149
    def password(min_length: T.unsafe(nil), max_length: T.unsafe(nil), mix_case: T.unsafe(nil), special_characters: T.unsafe(nil)); end

    # Returns the private IPv4 address
    #
    # @example
    #   Faker::Internet.private_ip_v4_address   #=> "127.120.80.42"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#297
    def private_ip_v4_address; end

    # Returns lambda to check if address passed is private or not
    #
    # @example
    #   Faker::Internet.private_net_checker.call("127.120.80.42")   #=> true
    #   Faker::Internet.private_net_checker.call("148.120.80.42")   #=> false
    # @return [Lambda]
    #
    # source://faker//lib/faker/default/internet.rb#345
    def private_net_checker; end

    # Returns the private network regular expressions
    #
    # @example
    #   Faker::Internet.private_nets_regex  #=> [/^10\./, /^100\.(6[4-9]|[7-9]\d|1[0-1]\d|12[0-7])\./, /^127\./, /^169\.254\./, /^172\.(1[6-9]|2\d|3[0-1])\./, /^192\.0\.0\./, /^192\.168\./, /^198\.(1[8-9])\./]
    # @return [Array]
    #
    # source://faker//lib/faker/default/internet.rb#324
    def private_nets_regex; end

    # Returns the public IPv4 address
    #
    # @example
    #   Faker::Internet.public_ip_v4_address   #=> "127.120.80.42"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#308
    def public_ip_v4_address; end

    # Returns lambda function to check address passed is reserved or not
    #
    # @example
    #   Faker::Internet.reserved_net_checker.call('192.88.99.255')   #=> true
    #   Faker::Internet.reserved_net_checker.call('192.88.199.255')  #=> false
    # @return [Lambda]
    #
    # source://faker//lib/faker/default/internet.rb#376
    def reserved_net_checker; end

    # Returns the reserved network regular expressions
    #
    # @example
    #   Faker::Internet.reserved_nets_regex   #=> [/^0\./, /^192\.0\.2\./, /^192\.88\.99\./, /^198\.51\.100\./, /^203\.0\.113\./, /^(22[4-9]|23\d)\./, /^(24\d|25[0-5])\./]
    # @return [Array]
    #
    # source://faker//lib/faker/default/internet.rb#356
    def reserved_nets_regex; end

    # Returns the email address with fixed domain name as 'example'
    #
    # @example
    #   Faker::Internet.safe_email                                                           #=> "samsmith@example.com"
    #   Faker::Internet.safe_email(name: 'smith')                                            #=> "smith@example.net"
    # @param name [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#70
    def safe_email(name: T.unsafe(nil)); end

    # Returns unique string in URL
    #
    # @example
    #   Faker::Internet.slug                                    #=> "repudiandae-sed"
    #   Faker::Internet.slug(words: 'test, faker')              #=> "test-faker"
    #   Faker::Internet.slug(words: 'test. faker')              #=> "test-faker"
    #   Faker::Internet.slug(words: 'test. faker', glue: '$')   #=> "test$faker"
    # @param words [String] Comma or period separated words list
    # @param glue [String] Separator to add between words passed, default used are '-' or '_'
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#445
    def slug(words: T.unsafe(nil), glue: T.unsafe(nil)); end

    # Returns URL
    #
    # @example
    #   Faker::Internet.url                                                           #=> "http://sipes-okon.com/hung.macejkovic"
    #   Faker::Internet.url(host: 'faker')                                            #=> "http://faker/shad"
    #   Faker::Internet.url(host: 'faker', path: '/fake_test_path')                   #=> "http://faker/fake_test_path"
    #   Faker::Internet.url(host: 'faker', path: '/fake_test_path', scheme: 'https')  #=> "https://faker/fake_test_path"
    # @param host [String]
    # @param path [String]
    # @param scheme [String]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#428
    def url(host: T.unsafe(nil), path: T.unsafe(nil), scheme: T.unsafe(nil)); end

    # Produces a randomized hash of internet user details
    #
    # @example
    #   Faker::Internet.user #=> { username: 'alexie', email: 'alexie@example.net' }
    # @example
    #   Faker::Internet.user('username', 'email', 'password') #=> { username: 'alexie', email: 'alexie@example.net', password: 'DtEf9P8wS31iMyC' }
    # @return [hash]
    #
    # source://faker//lib/faker/default/internet.rb#553
    def user(*args); end

    # Generates the random browser identifier
    #
    # @example
    #   Faker::Internet.user_agent                    #=> "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36"
    #   Faker::Internet.user_agent(vendor: 'chrome')  #=> "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36"
    #   Faker::Internet.user_agent(vendor: 'safari')  #=> "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/7046A194A"
    #   Faker::Internet.user_agent(vendor: 'faker')   #=> "Mozilla/5.0 (Windows; U; Win 9x 4.90; SG; rv:1.9.2.4) Gecko/20101104 Netscape/9.1.0285"
    # @param vendor [String] Name of vendor, supported vendors are aol, chrome, firefox, internet_explorer, netscape, opera, safari
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#475
    def user_agent(vendor: T.unsafe(nil)); end

    # Returns the username
    #
    # @example
    #   Faker::Internet.username(specifier: 10)                     #=> "lulu.goodwin"
    #   Faker::Internet.username(specifier: 5..10)                  #=> "morris"
    #   Faker::Internet.username(specifier: 5..10)                  #=> "berryberry"
    #   Faker::Internet.username(specifier: 20, separators: ['-'])  #=> "nikki_sawaynnikki_saway"
    # @param specifier [Integer, Range, String] When int value passed it returns the username longer than specifier. Max value can be 10^6
    # @param separators [Array]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#90
    def user_name(specifier: T.unsafe(nil), separators: T.unsafe(nil)); end

    # Returns the username
    #
    # @example
    #   Faker::Internet.username(specifier: 10)                     #=> "lulu.goodwin"
    #   Faker::Internet.username(specifier: 5..10)                  #=> "morris"
    #   Faker::Internet.username(specifier: 5..10)                  #=> "berryberry"
    #   Faker::Internet.username(specifier: 20, separators: ['-'])  #=> "nikki_sawaynnikki_saway"
    # @param specifier [Integer, Range, String] When int value passed it returns the username longer than specifier. Max value can be 10^6
    # @param separators [Array]
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#90
    def username(specifier: T.unsafe(nil), separators: T.unsafe(nil)); end

    # Generated universally unique identifier
    #
    # @example
    #   Faker::Internet.uuid  #=> "8a6cdd40-6d78-4fdb-912b-190e3057197f"
    # @return [String]
    #
    # source://faker//lib/faker/default/internet.rb#505
    def uuid; end

    private

    # source://faker//lib/faker/default/internet.rb#577
    def construct_email(local_part, domain_name); end

    # source://faker//lib/faker/default/internet.rb#564
    def sanitize_email_local_part(local_part); end
  end
end

class Faker::Internet::HTTP < ::Faker::Base
  class << self
    # Produces an HTTP status code
    #
    # @example
    #   Faker::Internet::HTTP.status_code #=> 418
    # @example
    #   Faker::Internet::HTTP.status_code(group: :information) #=> 102
    # @example
    #   Faker::Internet::HTTP.status_code(group: :successful) #=> 200
    # @example
    #   Faker::Internet::HTTP.status_code(group: :redirect) #=> 306
    # @example
    #   Faker::Internet::HTTP.status_code(group: :client_error) #=> 451
    # @example
    #   Faker::Internet::HTTP.status_code(group: :server_error) #=> 502
    # @raise [ArgumentError]
    # @return [Integer]
    #
    # source://faker//lib/faker/default/internet_http.rb#38
    def status_code(group: T.unsafe(nil)); end
  end
end

# source://faker//lib/faker/default/internet_http.rb#6
Faker::Internet::HTTP::STATUS_CODES = T.let(T.unsafe(nil), Hash)

# source://faker//lib/faker/default/internet_http.rb#16
Faker::Internet::HTTP::STATUS_CODES_GROUPS = T.let(T.unsafe(nil), Array)

# Private, Host, and Link-Local network address blocks as defined in https://en.wikipedia.org/wiki/IPv4#Special-use_addresses
#
# source://faker//lib/faker/default/internet.rb#6
Faker::Internet::PRIVATE_IPV4_ADDRESS_RANGES = T.let(T.unsafe(nil), Array)

class Faker::InvalidStatePassed < ::StandardError
  # @return [InvalidStatePassed] a new instance of InvalidStatePassed
  #
  # source://faker//lib/faker/default/driving_licence.rb#117
  def initialize(msg = T.unsafe(nil)); end
end

class Faker::Invoice < ::Faker::Base
  class << self
    # Produces a random amount between values with 2 decimals
    #
    # @example
    #   Faker::Finance.amount_between #=> 0
    #   Faker::Finance.amount_between(0, 10) #=> 4.33
    # @param from [Integer] Specifies lower limit.
    # @param to [Integer] Specifies upper limit.
    # @return [Integer]
    #
    # source://faker//lib/faker/default/invoice.rb#20
    def amount_between(from: T.unsafe(nil), to: T.unsafe(nil)); end

    # Produces a random valid reference accoring to the International bank slip reference https://en.wikipedia.org/wiki/Creditor_Reference
    #
    # @example
    #   Faker::Invoice.creditor_reference #=> "RF34118592570724925498"
    # @param ref [String] Specifies reference base.
    # @return [String]
    #
    # source://faker//lib/faker/default/invoice.rb#34
    def creditor_reference(ref: T.unsafe(nil)); end

    # Produces a random valid reference.
    #
    # @example
    #   Faker::Invoice.reference #=> "45656646957845"
    # @param ref [String] Specifies reference base.
    # @return [String]
    #
    # source://faker//lib/faker/default/invoice.rb#50
    def reference(ref: T.unsafe(nil)); end

    private

    # Calculates weighted sum
    #
    # For example with 12345678, [1,2]
    # Ref.num. 1 2 3 4 5 6 7 8
    # Multipl. 1 2 1 2 1 2 1 2
    # Total 1+ 4+ 3+ 8+ 5+1+2+ 7+1+6 = 38
    #
    # source://faker//lib/faker/default/invoice.rb#111
    def calculate_weighted_sum(base, weight_factors); end

    # Calculates the mandatory checksum in 3rd and 4th characters in IBAN format
    # source: https://en.wikipedia.org/wiki/International_Bank_Account_Number#Validating_the_IBAN
    #
    # source://faker//lib/faker/default/invoice.rb#79
    def iban_checksum(country_code, account); end

    # Norsk Modulus 10 - KIDMOD10
    #
    # source://faker//lib/faker/default/invoice.rb#100
    def kidmod10(base); end

    # 731 Method
    # Source: https://wiki.xmldation.com/support/fk/finnish_reference_number
    #
    # source://faker//lib/faker/default/invoice.rb#94
    def method_731(base); end

    # MOD-10 - remainder
    #
    # source://faker//lib/faker/default/invoice.rb#118
    def mod10_remainder(number); end
  end
end

class Faker::JapaneseMedia; end

class Faker::JapaneseMedia::Conan < ::Faker::Base
  class << self
    # Produces a character from Conan.
    #
    # @example
    #   Faker::JapaneseMedia::Conan.character #=> "Conan Edogawa"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/conan.rb#16
    def character; end

    # Produces a gadget from Conan.
    #
    # @example
    #   Faker::JapaneseMedia::Conan.gadget #=> "Voice-Changing Bowtie"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/conan.rb#29
    def gadget; end

    # Produces a vehicle from Conan.
    #
    # @example
    #   Faker::JapaneseMedia::Conan.vehicle #=> "Agasa's Volkswagen Beetle"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/conan.rb#42
    def vehicle; end
  end
end

class Faker::JapaneseMedia::CowboyBebop < ::Faker::Base
  class << self
    # Produces a character from Cowboy Bebop.
    #
    # @example
    #   Faker::JapaneseMedia::CowboyBebop.character #=> "Spike Spiegel"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/cowboy_bebop.rb#16
    def character; end

    # Produces an episode from Cowboy Bebop.
    #
    # @example
    #   Faker::JapaneseMedia::CowboyBebop.episode #=> "Honky Tonk Women"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/cowboy_bebop.rb#29
    def episode; end

    # Produces a quote from Cowboy Bebop.
    #
    # @example
    #   Faker::JapaneseMedia::CowboyBebop.quote #=> "Bang!!!"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/cowboy_bebop.rb#55
    def quote; end

    # Produces a song title from Cowboy Bebop.
    #
    # @example
    #   Faker::JapaneseMedia::CowboyBebop.songs #=> "Live in Baghdad"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/cowboy_bebop.rb#42
    def song; end
  end
end

class Faker::JapaneseMedia::Doraemon < ::Faker::Base
  class << self
    # Produces a character from Doraemon.
    #
    # @example
    #   Faker::JapaneseMedia::Doraemon.character #=> "Nobita"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/doraemon.rb#16
    def character; end

    # Produces a gadget from Doraemon.
    #
    # @example
    #   Faker::JapaneseMedia::Doraemon.gadget #=> "Anywhere Door"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/doraemon.rb#29
    def gadget; end

    # Produces a location from Doraemon.
    #
    # @example
    #   Faker::JapaneseMedia::Doraemon.location #=> "Tokyo"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/doraemon.rb#42
    def location; end
  end
end

class Faker::JapaneseMedia::DragonBall < ::Faker::Base
  class << self
    # Produces the name of a character from Dragon Ball.
    #
    # @example
    #   Faker::Games::DragonBall.character #=> "Goku"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/dragon_ball.rb#16
    def character; end

    # Produces the name of a planet from Dragon Ball.
    #
    # @example
    #   Faker::Games::DragonBall.planet #=> "Namek"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/dragon_ball.rb#42
    def planet; end

    # Produces the name of a race from Dragon Ball.
    #
    # @example
    #   Faker::Games::DragonBall.race #=> "Saiyan"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/dragon_ball.rb#29
    def race; end
  end
end

class Faker::JapaneseMedia::FmaBrotherhood < ::Faker::Base
  class << self
    # Produces a character from FmaBrotherhood.
    #
    # @example
    #   Faker::JapaneseMedia::FmaBrotherhood.character #=> "Edward Elric"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/fullmetal_alchemist_brotherhood.rb#16
    def character; end

    # Produces a cities from FmaBrotherhood.
    #
    # @example
    #   Faker::JapaneseMedia::FmaBrotherhood.city #=> "Central City"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/fullmetal_alchemist_brotherhood.rb#29
    def city; end

    # Produces a country from FmaBrotherhood.
    #
    # @example
    #   Faker::JapaneseMedia::FmaBrotherhood.country #=> "Xing"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/fullmetal_alchemist_brotherhood.rb#42
    def country; end
  end
end

class Faker::JapaneseMedia::KamenRider < ::Faker::Base
  class << self
    # Produces the name of a collectible device from a Kamen Rider series.
    #
    # @example
    #   Faker::JapaneseMedia::KamenRider.collectible_device #=> "Vistamp"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#62
    def collectible_device(*eras); end

    # source://faker//lib/faker/japanese_media/kamen_rider.rb#9
    def eras=(new_eras); end

    # Produces the name of a Kamen Rider from a series in the given era.
    #
    # @example
    #   Faker::JapaneseMedia::KamenRider.kamen_rider #=> "Kamen Rider Revice"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#23
    def kamen_rider(*eras); end

    # Produces the name of a Kamen Rider series.
    #
    # @example
    #   Faker::JapaneseMedia::KamenRider.series #=> "Kamen Rider Revice"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#49
    def series(*eras); end

    # Produces the name of a transformation device used by a Kamen Rider
    # from the given eras.
    #
    # "Revice Driver"
    #
    # @example Faker::JapaneseMedia::KamenRider.transformation_device #=>
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#75
    def transformation_device(*eras); end

    # Produces the name of a main user of Kamen Rider.
    #
    # @example
    #   Faker::JapaneseMedia::KamenRider.user #=> "Ikki Igarashi"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#36
    def user(*eras); end

    private

    # source://faker//lib/faker/japanese_media/kamen_rider.rb#81
    def eras; end

    # @raise [UnavailableInEra]
    # @yield [selected_eras]
    #
    # source://faker//lib/faker/japanese_media/kamen_rider.rb#85
    def from_eras(*input_eras, field:); end
  end
end

class Faker::JapaneseMedia::Naruto < ::Faker::Base
  class << self
    # Produces a character from Naruto.
    #
    # @example
    #   Faker::JapaneseMedia::Naruto.character #=> "Naruto Uzumaki"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/naruto.rb#16
    def character; end

    # Produces a demon from Naruto.
    #
    # @example
    #   Faker::JapaneseMedia::Naruto.demon #=> "Nine-Tails (Kurama)"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/naruto.rb#55
    def demon; end

    # Produces a eye from Naruto.
    #
    # @example
    #   Faker::JapaneseMedia::Naruto.eye #=> "Konohagakure (Byakugan)"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/naruto.rb#42
    def eye; end

    # Produces a village from Naruto.
    #
    # @example
    #   Faker::JapaneseMedia::Naruto.village #=> "Konohagakure (Leaf Village)"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/naruto.rb#29
    def village; end
  end
end

class Faker::JapaneseMedia::OnePiece < ::Faker::Base
  class << self
    # Produces an akuma no mi from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.akuma_no_mi #=> "Gomu Gomu no Mi"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#81
    def akuma_no_mi; end

    # Produces a character from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.character #=> "Monkey D. Luffy"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#16
    def character; end

    # Produces an island from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.island #=> "Laftel"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#42
    def island; end

    # Produces a location from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.location #=> "Foosha Village"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#55
    def location; end

    # Produces a quote from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.quote #=> "ONE PIECE IS REAL!"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#68
    def quote; end

    # Produces a sea from One Piece.
    #
    # @example
    #   Faker::JapaneseMedia::OnePiece.sea #=> "East Blue"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/one_piece.rb#29
    def sea; end
  end
end

class Faker::JapaneseMedia::StudioGhibli < ::Faker::Base
  class << self
    # Produces a character from the Studio Ghibli.
    #
    # @example
    #   Faker::JapaneseMedia::StudioGhibli.character #=> "Chihiro"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/studio_ghibli.rb#16
    def character; end

    # Produces a movie from Studio Ghibli.
    #
    # @example
    #   Faker::JapaneseMedia::StudioGhibli.movie #=> "Kiki's Delivery Service"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/studio_ghibli.rb#42
    def movie; end

    # Produces a quote from Studio Ghibli's movies.
    #
    # @example
    #   Faker::JapaneseMedia::StudioGhibli.quote #=> "One thing you can always count on is that hearts change."
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/studio_ghibli.rb#29
    def quote; end
  end
end

class Faker::JapaneseMedia::SwordArtOnline < ::Faker::Base
  class << self
    # Produces the in-game name of a character from Sword Art Online.
    #
    # @example
    #   Faker::JapaneseMedia::SwordArtOnline.game_name #=> "Silica"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/sword_art_online.rb#29
    def game_name; end

    # Produces the name of an item from Sword Art Online.
    #
    # @example
    #   Faker::JapaneseMedia::SwordArtOnline.item #=> "Blackwyrm Coat"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/sword_art_online.rb#55
    def item; end

    # Produces the name of a location from Sword Art Online.
    #
    # @example
    #   Faker::JapaneseMedia::SwordArtOnline.location #=> "Ruby Palace"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/sword_art_online.rb#42
    def location; end

    # Produces the real name of a character from Sword Art Online.
    #
    # @example
    #   Faker::JapaneseMedia::SwordArtOnline.real_name #=> "Kirigaya Kazuto"
    # @return [String]
    #
    # source://faker//lib/faker/japanese_media/sword_art_online.rb#16
    def real_name; end
  end
end

class Faker::Job < ::Faker::Base
  class << self
    # Produces a random job field.
    #
    # @example
    #   Faker::Job.field #=> "Banking"
    # @return [String]
    #
    # source://faker//lib/faker/default/job.rb#43
    def field; end

    # Produces a random job skill.
    #
    # @example
    #   Faker::Job.key_skill #=> "Leadership"
    # @return [String]
    #
    # source://faker//lib/faker/default/job.rb#56
    def key_skill; end

    # Produces a random job position.
    #
    # @example
    #   Faker::Job.position #=> "Strategist"
    # @return [String]
    #
    # source://faker//lib/faker/default/job.rb#30
    def position; end

    # Produces a random job title.
    #
    # @example
    #   Faker::Job.title #=> "Construction Manager"
    # @return [String]
    #
    # source://faker//lib/faker/default/job.rb#17
    def title; end
  end
end

class Faker::Json < ::Faker::Base
  class << self
    # Produces a random nested JSON formatted string that can take JSON as an additional argument.
    #
    # @example
    #   json = Faker::Json.shallow_json(width: 3, options: { key: 'Name.first_name', value: 'Name.last_name' })
    #   puts json # =>
    #   {"Alisha":"Olson","Everardo":"DuBuque","Bridgette":"Turner"}
    #
    #   json2 = Faker::Json.add_depth_to_json(json: json, width: 2, options: { key: 'Name.first_name', value: 'Name.last_name' })
    #   puts json2 # =>
    #   {"Alisha":{"Daisy":"Trantow","Oda":"Haag"},
    #   "Everardo":{"Javier":"Marvin","Eliseo":"Schuppe"},
    #   "Bridgette":{"Jorge":"Kertzmann","Lelah":"MacGyver"}}
    #
    #   json3 = Faker::Json.add_depth_to_json(json: json2, width: 4, options: { key: 'Name.first_name', value: 'Name.last_name' })
    #   puts json3 # =>
    #   {"Alisha":
    #   {"Daisy":
    #   {"Bulah":"Wunsch","Cristian":"Champlin","Lester":"Bartoletti","Greg":"Jacobson"},
    #   "Oda":
    #   {"Salvatore":"Kuhlman","Aubree":"Okuneva","Larry":"Schmitt","Velva":"Gibson"}},
    #   "Everardo":
    #   {"Javier":
    #   {"Eduardo":"Orn","Laila":"Kub","Thad":"Legros","Dion":"Wilderman"},
    #   "Eliseo":
    #   {"Olin":"Hilpert","Marisa":"Greenfelder","Karlee":"Schmitt","Judd":"Larkin"}},
    #   "Bridgette":
    #   {"Jorge":
    #   {"Eloy":"Pfeffer","Kody":"Hansen","Paxton":"Lubowitz","Abe":"Lesch"},
    #   "Lelah":
    #   {"Rick":"Wiza","Bonita":"Bayer","Gardner":"Auer","Felicity":"Abbott"}}}
    # @param json [Hash{String => String}] Specifies a Json.shallow_json and uses its keys as keys of the nested JSON.
    # @param width [Integer] Specifies the number of nested key-value pairs.
    # @param options [Hash] Specifies a Faker gem class to use for nested keys and for values, respectably. options_hash = {key: Class.method, value: Class.method}
    # @return [Hash{String => String}]
    #
    # source://faker//lib/faker/default/json.rb#69
    def add_depth_to_json(json: T.unsafe(nil), width: T.unsafe(nil), options: T.unsafe(nil)); end

    # Produces a random simple JSON formatted string.
    #
    # @example
    #   Faker::Json.shallow_json(width: 3, options: { key: 'RockBand.name', value: 'Seinfeld.quote' }) # =>
    #   {"Parliament Funkadelic":"They're real, and they're spectacular.",
    #   "Fleetwood Mac":"I'm not a lesbian. I hate men, but I'm not a lesbian.",
    #   "The Roots":"It became very clear to me sitting out there today that every decision
    #   I've made in my entire life has been wrong. My life is the complete opposite of everything
    #   I want it to be. Every instinct I have, in every aspect of life, be it something to wear,
    #   something to eat - it's all been wrong."}
    # @param width [Integer] Specifies the number of key-value pairs.
    # @param options [Hash] Specifies a Faker gem class to use for keys and for values, respectably. options_hash = {key: Class.method, value: Class.method}
    # @return [Hash{String => String}]
    #
    # source://faker//lib/faker/default/json.rb#23
    def shallow_json(width: T.unsafe(nil), options: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/json.rb#106
    def add_hash(key_array, hash, width, options); end

    # source://faker//lib/faker/default/json.rb#93
    def add_hash_to_bottom(hash, key_array, width, options); end

    # source://faker//lib/faker/default/json.rb#116
    def build_keys_from_array(key_array); end

    # source://faker//lib/faker/default/json.rb#82
    def build_shallow_hash(width, options); end
  end
end

class Faker::Kpop < ::Faker::Base
  class << self
    # Produces the name of a K-Pop boy band.
    #
    # @example
    #   Faker::Kpop.boy_bands #=> "Exo"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#67
    def boy_bands; end

    # Produces the name of a K-Pop girl group.
    #
    # @example
    #   Faker::Kpop.girl_groups #=> "2NE1"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#54
    def girl_groups; end

    # Produces the name of a 1990's 'OG' K-Pop group.
    #
    # @example
    #   Faker::Kpop.i_groups #=> "Seo Taiji and Boys"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#15
    def i_groups; end

    # Produces the name of a 2000's K-Pop group.
    #
    # @example
    #   Faker::Kpop.ii_groups #=> "Girls' Generation"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#28
    def ii_groups; end

    # Produces the name of a 2010's K-Pop group.
    #
    # @example
    #   Faker::Kpop.iii_groups #=> "Trouble Maker"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#41
    def iii_groups; end

    # Produces the name of a solo K-Pop artist.
    #
    # @example
    #   Faker::Kpop.solo #=> "T.O.P"
    # @return [String]
    #
    # source://faker//lib/faker/default/kpop.rb#80
    def solo; end
  end
end

# Based on Perl's Text::Lorem
class Faker::Lorem < ::Faker::Base
  class << self
    # Generates single character
    #
    # @example
    #   Faker::Lorem.character    #=> "e"
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#52
    def character; end

    # Produces a random string of alphanumeric characters
    #
    # @example
    #   Faker::Lorem.characters #=> "uw1ep04lhs0c4d931n1jmrspprf5w..."
    #   Faker::Lorem.characters(number: 10) #=> "ang9cbhoa8"
    #   Faker::Lorem.characters(number: 10, min_alpha: 4) #=> "ang9cbhoa8"
    #   Faker::Lorem.characters(number: 10, min_alpha: 4, min_numeric: 1) #=> "ang9cbhoa8"
    # @param number [Integer] The number of characters to generate
    # @param min_alpha [Integer] The minimum number of alphabetic to add to the string
    # @param min_numeric [Integer] The minimum number of numbers to add to the string
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#72
    def characters(number: T.unsafe(nil), min_alpha: T.unsafe(nil), min_numeric: T.unsafe(nil)); end

    # Generates the emoji
    #
    # @example
    #   Faker::Lorem.multibyte  #=> "😀"
    #   Faker::Lorem.multibyte  #=> "❤"
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#86
    def multibyte; end

    # Generates three sentence paragraph
    #
    # @example
    #   Faker::Lorem.paragraph
    #   #=> "Impedit et est. Aliquid deleniti necessitatibus. Et aspernatur minima."
    #   Faker::Lorem.paragraph(sentence_count: 2)
    #   #=> "Rerum fugit vitae. Et atque autem."
    #   Faker::Lorem.paragraph(sentence_count: 2, supplemental: true)
    #   #=> "Terreo coerceo utor. Vester sunt cogito."
    #   Faker::Lorem.paragraph(sentence_count: 2, supplemental: true, random_sentences_to_add: 2)
    #   #=> "Texo tantillus tamisium. Tribuo amissio tamisium. Facere aut canis."
    # @param sentence_count [Integer] Number of sentences in the paragraph
    # @param supplemental [Boolean]
    # @param random_sentences_to_add [Integer]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#148
    def paragraph(sentence_count: T.unsafe(nil), supplemental: T.unsafe(nil), random_sentences_to_add: T.unsafe(nil)); end

    # Generates paragraph with 256 characters
    #
    # @example
    #   Faker::Lorem.paragraph_by_chars
    #   Faker::Lorem.paragraph_by_chars(number: 20)                       #=> "Sit modi alias. Imp."
    #   Faker::Lorem.paragraph_by_chars(number: 20, supplemental: true)   #=> "Certus aveho admove."
    # @param number [Integer]
    # @param supplemental [Boolean]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#184
    def paragraph_by_chars(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Generates three paragraphs
    #
    # @example
    #   Faker::Lorem.paragraphs
    #   Faker::Lorem.paragraphs(number:2)
    #   Faker::Lorem.paragraphs(number:2, supplemental: true)
    # @param number [Integer]
    # @param supplemental [Boolean]
    # @return [Array]
    #
    # source://faker//lib/faker/default/lorem.rb#166
    def paragraphs(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Returns the question with 4 words
    #
    # @example
    #   Faker::Lorem.question                                                               #=> "Natus deleniti sequi laudantium?"
    #   Faker::Lorem.question(word_count: 2)                                                #=> "Quo ut?"
    #   Faker::Lorem.question(word_count: 2, supplemental: true)                            #=> "Terga consequatur?"
    #   Faker::Lorem.question(word_count: 2, supplemental: true, random_words_to_add: 2)    #=> "Depulso uter ut?"
    # @param word_count [Integer]
    # @param supplemental [Boolean]
    # @param random_words_to_add [Integer]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#208
    def question(word_count: T.unsafe(nil), supplemental: T.unsafe(nil), random_words_to_add: T.unsafe(nil)); end

    # Generates array of three questions
    #
    # @example
    #   Faker::Lorem.questions                                  #=> ["Amet culpa enim?", "Voluptatem deleniti numquam?", "Veniam non cum?"]
    #   Faker::Lorem.questions(number: 2)                       #=> ["Minus occaecati nobis?", "Veniam et alias?"]
    #   Faker::Lorem.questions(number: 2, supplemental: true)   #=> ["Acceptus subito cetera?", "Aro sulum cubicularis?"]
    # @param number [Integer]
    # @param supplemental [Boolean]
    # @return [Array]
    #
    # source://faker//lib/faker/default/lorem.rb#226
    def questions(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Generates sentence
    #
    # @example
    #   Faker::Lorem.sentence                                                             #=> "Magnam qui aut quidem."
    #   Faker::Lorem.sentence(word_count: 5)                                              #=> "Voluptas rerum aut aliquam velit."
    #   Faker::Lorem.sentence(word_count: 5, supplemental: true)                          #=> "Aut viscus curtus votum iusto."
    #   Faker::Lorem.sentence(word_count: 5, supplemental: true, random_words_to_add:2)   #=> "Crinis quo cruentus velit animi vomer."
    # @param word_count [Integer] How many words should be there in a sentence, default to 4
    # @param supplemental [Boolean] Add supplemental words, default to false
    # @param random_words_to_add [Integer] Add any random words, default to 0
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#106
    def sentence(word_count: T.unsafe(nil), supplemental: T.unsafe(nil), random_words_to_add: T.unsafe(nil)); end

    # Generates three sentences
    #
    # @example
    #   Faker::Lorem.sentences                                  #=> ["Possimus non tenetur.", "Nulla non excepturi.", "Quisquam rerum facilis."]
    #   Faker::Lorem.sentences(number: 2)                       #=> ["Nulla est natus.", "Perferendis autem cum."]
    #   Faker::Lorem.sentences(number: 2, supplemental: true)   #=> ["Cito cena ad.", "Solvo animus allatus."]
    # @param number [Integer] How many sentences to be generated, default to 3
    # @param supplemental [Boolean] Should add supplemental words, defaults to false
    # @return [Array] Returns array for sentences.
    #
    # source://faker//lib/faker/default/lorem.rb#124
    def sentences(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    # Returs the random word
    #
    # @example
    #   Faker::Lorem.word   #=> "soluto"
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem.rb#15
    def word; end

    # Generates random 3 words
    #
    # @example
    #   Faker::Lorem.words                                    #=> ["hic", "quia", "nihil"]
    #   Faker::Lorem.words(number: 4)                         #=> ["est", "temporibus", "et", "quaerat"]
    #   Faker::Lorem.words(number: 4, supplemental: true)    #=> ["nisi", "sit", "allatus", "consequatur"]
    # @param number [Integer] Number of words to be generated
    # @param supplemental [Boolean] Whether to attach supplemental words at the end, default is false
    # @return [Array] Array for words
    #
    # source://faker//lib/faker/default/lorem.rb#33
    def words(number: T.unsafe(nil), supplemental: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/lorem.rb#232
    def locale_period; end

    # source://faker//lib/faker/default/lorem.rb#240
    def locale_question_mark; end

    # source://faker//lib/faker/default/lorem.rb#236
    def locale_space; end
  end
end

class Faker::LoremFlickr < ::Faker::Base
  class << self
    # Produces a random colorized image URL from loremflickr.com.
    #
    # @example
    #   Faker::LoremFlickr.image #=> "https://loremflickr.com/red/300/300/all"
    #   Faker::LoremFlickr.image(size: "50x60", color: 'blue') #=> "https://loremflickr.com/blue/50/60/all"
    #   Faker::LoremFlickr.image(size: "50x60", color: 'blue', search_terms: ['sports']) #=> "https://loremflickr.com/blue/50/60/sports"
    #   Faker::LoremFlickr.image(size: "50x60", color: 'blue', search_terms: ['sports', 'fitness']) #=> "https://loremflickr.com/blue/50/60/sports,fitness"
    #   Faker::LoremFlickr.image(size: "50x60", color: 'blue', search_terms: ['sports', 'fitness'], match_all: true) #=> "https://loremflickr.com/blue/50/60/sports,fitness/all"
    # @param size [String] Specifies the size of image to generate.
    # @param color [String] Specifies the color of image to generate.
    # @param search_terms [Array<String>] Adds search terms to the image URL.
    # @param match_all [Boolean] Add "all" as part of the URL.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem_flickr.rb#89
    def colorized_image(size: T.unsafe(nil), color: T.unsafe(nil), search_terms: T.unsafe(nil), match_all: T.unsafe(nil)); end

    # Produces a random grayscale image URL from loremflickr.com.
    #
    # @example
    #   Faker::LoremFlickr.grayscale_image #=> "https://loremflickr.com/g/300/300/all"
    #   Faker::LoremFlickr.grayscale_image(size: "50x60") #=> "https://loremflickr.com/g/50/60/all"
    #   Faker::LoremFlickr.grayscale_image(size: "50x60", search_terms: ['sports']) #=> "https://loremflickr.com/g/50/60/sports"
    #   Faker::LoremFlickr.grayscale_image(size: "50x60", search_terms: ['sports', 'fitness']) #=> "https://loremflickr.com/50/60/g/sports,fitness"
    #   Faker::LoremFlickr.grayscale_image(size: "50x60", search_terms: ['sports', 'fitness'], match_all: true) #=> "https://loremflickr.com/g/50/60/sports,fitness/all"
    # @param size [String] Specifies the size of image to generate.
    # @param search_terms [Array<String>] Adds search terms to the image URL.
    # @param match_all [Boolean] Add "all" as part of the URL.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem_flickr.rb#44
    def grayscale_image(size: T.unsafe(nil), search_terms: T.unsafe(nil), match_all: T.unsafe(nil)); end

    # Produces a random image URL from loremflickr.com.
    #
    # @example
    #   Faker::LoremFlickr.image #=> "https://loremflickr.com/300/300"
    #   Faker::LoremFlickr.image(size: "50x60") #=> "https://loremflickr.com/50/60"
    #   Faker::LoremFlickr.image(size: "50x60", search_terms: ['sports']) #=> "https://loremflickr.com/50/60/sports"
    #   Faker::LoremFlickr.image(size: "50x60", search_terms: ['sports', 'fitness']) #=> "https://loremflickr.com/50/60/sports,fitness"
    #   Faker::LoremFlickr.image(size: "50x60", search_terms: ['sports', 'fitness'], match_all: true) #=> "https://loremflickr.com/50/60/sports,fitness/all"
    # @param size [String] Specifies the size of image to generate.
    # @param search_terms [Array<String>] Adds search terms to the image URL.
    # @param match_all [Boolean] Add "all" as part of the URL.
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem_flickr.rb#24
    def image(size: T.unsafe(nil), search_terms: T.unsafe(nil), match_all: T.unsafe(nil)); end

    # Produces a random pixelated image URL from loremflickr.com.
    #
    # @example
    #   Faker::LoremFlickr.pixelated_image #=> "https://loremflickr.com/p/300/300/all"
    #   Faker::LoremFlickr.pixelated_image(size: "50x60") #=> "https://loremflickr.com/p/50/60/all"
    #   Faker::LoremFlickr.pixelated_image(size: "50x60", search_terms: ['sports']) #=> "https://loremflickr.com/p/50/60/sports"
    #   Faker::LoremFlickr.pixelated_image(size: "50x60", search_terms: ['sports', 'fitness']) #=> "https://loremflickr.com/p/50/60/sports,fitness"
    #   Faker::LoremFlickr.pixelated_image(size: "50x60", search_terms: ['sports', 'fitness'], match_all: true) #=> "https://loremflickr.com/p/50/60/sports,fitness/all"
    # @param size [String] Specifies the size of image to generate.
    # @param search_terms [Array<String>] Adds search terms to the image URL.
    # @param match_all [Boolean] Add "all" as part of the URL.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/lorem_flickr.rb#66
    def pixelated_image(size: T.unsafe(nil), search_terms: T.unsafe(nil), match_all: T.unsafe(nil)); end

    private

    # @raise [ArgumentError]
    #
    # source://faker//lib/faker/default/lorem_flickr.rb#98
    def build_url(size, format, search_terms, match_all); end
  end
end

class Faker::Markdown < ::Faker::Base
  class << self
    # Produces a random code block formatted in Ruby.
    #
    # @example
    #   Faker::Markdown.block_code #=> "```ruby\nEos quasi qui.\n```"
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#97
    def block_code; end

    # Produces a random emphasis formatting on a random word in two sentences.
    #
    # @example
    #   Faker::Markdown.emphasis #=> "_Incidunt atque quis repellat id impedit.  Quas numquam quod incidunt dicta non. Blanditiis delectus laudantium atque reiciendis qui._"
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#28
    def emphasis; end

    # Produces a random header format.
    #
    # @example
    #   Faker::Markdown.headers #=> "##### Autem"
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#15
    def headers; end

    # Produces a random inline code snippet between two sentences.
    #
    # @example
    #   Faker::Markdown.inline_code #=> "Aut eos quis suscipit. `Dignissimos voluptatem expedita qui.` Quo doloremque veritatis tempora aut."
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#84
    def inline_code; end

    # Produces a random ordered list of items between 1 and 10 randomly.
    #
    # @example
    #   Faker::Markdown.ordered_list #=> "1. Qui reiciendis non consequatur atque.\n2. Quo doloremque veritatis tempora aut.\n3. Aspernatur.\n4. Ea ab.\n5. Qui.\n6. Sit pariatur nemo eveniet.\n7. Molestiae aut.\n8. Nihil molestias iure placeat.\n9. Dolore autem quisquam."
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#46
    def ordered_list; end

    # Produces a random method from the methods above, excluding the methods listed in the arguments.
    #
    # @example
    #   Faker::Markdown.random #=> returns output from a single method outlined above
    #   Faker::Markdown.random("table") #=> returns output from any single method outlined above except for "table"
    #   Faker::Markdown.random("ordered_list", "unordered_list") #=> returns output from any single method outlined above except for either ordered_list and unordered_list
    # @overload random
    # @return [String, Array<String>]
    #
    # source://faker//lib/faker/default/markdown.rb#133
    def random(*args); end

    # Produces a simulated blog-esque text-heavy block in markdown
    #
    # Keyword arguments: sentences, repeat
    #
    # @example
    #   Faker::Markdown.sandwich #=> returns newline separated content of 1 header, 1 default lorem paragraph, and 1 random markdown element
    #   Faker::Markdown.sandwich(sentences: 5) #=> returns newline separated content of 1 header, 1 5-sentence lorem paragraph, and 1 random markdown element
    #   Faker::Markdown.sandwich(sentences: 6, repeat: 3) #=> returns newline separated content of 1 header, and then 3 sections consisting of, here, 1 6-sentence lorem paragraph and 1 random markdown element. The random markdown element is chosen at random in each iteration of the paragraph-markdown pairing.
    # @param sentences [Integer] Specifies how many sentences make a text block.
    # @param repeat [Integer] Specifies how many times the text block repeats.
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#153
    def sandwich(sentences: T.unsafe(nil), repeat: T.unsafe(nil)); end

    # Produces a random 3x4 table with a row of headings, a row of hyphens and two rows of data
    #
    # @example
    #   Faker::Markdown.table #=> "ad | similique | voluptatem\n---- | ---- | ----\ncorrupti | est | rerum\nmolestiae | quidem | et"
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#110
    def table; end

    # Produces a random unordered list of items between 1 and 10 randomly.
    #
    # @example
    #   Faker::Markdown.unordered_list #=> "* Voluptatum aliquid tempora molestiae facilis non sed.\n* Nostrum omnis iste impedit voluptatum dolor.\n* Esse quidem et facere."
    # @return [String]
    #
    # source://faker//lib/faker/default/markdown.rb#65
    def unordered_list; end

    private

    # source://faker//lib/faker/default/markdown.rb#165
    def available_methods; end
  end
end

class Faker::Marketing < ::Faker::Base
  class << self
    # Produces the name of a video game console or platform.
    #
    # @example
    #   Faker::Marketing.buzzwords #=> "rubber meets the road"
    # @return [String]
    #
    # source://faker//lib/faker/default/marketing.rb#17
    def buzzwords; end
  end
end

class Faker::Measurement < ::Faker::Base
  class << self
    # Produces a random height measurement.
    #
    # @example
    #   Faker::Measurement.height #=> "6 inches"
    #   Faker::Measurement.height(amount: 1.4) #=> "1.4 inches"
    #   Faker::Measurement.height(amount: "none") #=> "inch"
    #   Faker::Measurement.height(amount: "all") #=> "inches"
    # @param amount [Integer] Specifies the random height value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#22
    def height(amount: T.unsafe(nil)); end

    # Produces a random length measurement.
    #
    # @example
    #   Faker::Measurement.length #=> "1 yard"
    #   Faker::Measurement.length(amount: 1.4) #=> "1.4 yards"
    # @param amount [Integer] Specifies the random length value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#37
    def length(amount: T.unsafe(nil)); end

    # Produces a random metric height measurement.
    #
    # @example
    #   Faker::Measurement.metric_height #=> "2 meters"
    #   Faker::Measurement.metric_height(amount: 1.4) #=> "1.4 meters"
    # @param amount [Integer] Specifies the random height value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#82
    def metric_height(amount: T.unsafe(nil)); end

    # Produces a random metric length measurement.
    #
    # @example
    #   Faker::Measurement.metric_length #=> "0 decimeters"
    #   Faker::Measurement.metric_length(amount: 1.4) #=> "1.4 decimeters"
    # @param amount [Integer] Specifies the random length value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#97
    def metric_length(amount: T.unsafe(nil)); end

    # Produces a random metric volume measurement.
    #
    # @example
    #   Faker::Measurement.metric_volume #=> "1 liter"
    #   Faker::Measurement.metric_volume(amount: 1.4) #=> "1.4 liters"
    # @param amount [Integer] Specifies the random volume value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#112
    def metric_volume(amount: T.unsafe(nil)); end

    # Produces a random metric weight measurement.
    #
    # @example
    #   Faker::Measurement.metric_weight #=> "8 grams"
    #   Faker::Measurement.metric_weight(amount: 1.4) #=> "1.4 grams"
    # @param amount [Integer] Specifies the random weight value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#127
    def metric_weight(amount: T.unsafe(nil)); end

    # Produces a random volume measurement.
    #
    # @example
    #   Faker::Measurement.volume #=> "10 cups"
    #   Faker::Measurement.volume(amount: 1.4) #=> "1.4 cups"
    # @param amount [Integer] Specifies the random volume value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#52
    def volume(amount: T.unsafe(nil)); end

    # Produces a random weight measurement.
    #
    # @example
    #   Faker::Measurement.weight #=> "3 pounds"
    #   Faker::Measurement.weight(amount: 1.4) #=> "1.4 pounds"
    # @param amount [Integer] Specifies the random weight value.
    # @return [String]
    #
    # source://faker//lib/faker/default/measurement.rb#67
    def weight(amount: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/measurement.rb#133
    def check_for_plural(text, number); end

    # source://faker//lib/faker/default/measurement.rb#141
    def define_measurement_locale(amount, locale); end

    # @raise [ArgumentError]
    #
    # source://faker//lib/faker/default/measurement.rb#155
    def ensure_valid_amount(amount); end

    # source://faker//lib/faker/default/measurement.rb#159
    def make_plural(text); end
  end
end

class Faker::Military < ::Faker::Base
  class << self
    # Produces a rank in the U.S. Air Force.
    #
    # @example
    #   Faker::Military.air_force_rank #=> "Captain"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#54
    def air_force_rank; end

    # Produces a rank in the U.S. Army.
    #
    # @example
    #   Faker::Military.army_rank #=> "Staff Sergeant"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#15
    def army_rank; end

    # Produces a rank in the U.S. Coast Guard
    #
    # @example
    #   Faker::Military.coast_guard_rank #=> "Master Chief Petty Officer of the Coast Guard"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#80
    def coast_guard_rank; end

    # Produces a U.S. Department of Defense Paygrade.
    #
    # @example
    #   Faker::Military.dod_paygrade #=> "E-6"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#93
    def dod_paygrade; end

    # Produces a rank in the U.S. Marines.
    #
    # @example
    #   Faker::Military.marines_rank #=> "Gunnery Sergeant"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#28
    def marines_rank; end

    # Produces a rank in the U.S. Navy.
    #
    # @example
    #   Faker::Military.navy_rank #=> "Seaman"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#41
    def navy_rank; end

    # Produces a rank in the U.S. Space Force.
    #
    # @example
    #   Faker::Military.space_force_rank #=> "Senior Enlisted Advisor of the Space Force"
    # @return [String]
    #
    # source://faker//lib/faker/default/military.rb#67
    def space_force_rank; end
  end
end

class Faker::Mountain < ::Faker::Base
  class << self
    # Produces a name of a mountain
    #
    #  @faker.version next
    #
    # @example
    #   Faker::Mountain.name #=> "Mount Everest"
    # @return [String]
    #
    # source://faker//lib/faker/default/mountain.rb#15
    def name; end

    # Produces a name of a range
    #
    # @example
    #   Faker::Mountain.range #=> "Dhaulagiri Himalaya"
    # @return [String]
    #
    # source://faker//lib/faker/default/mountain.rb#28
    def range; end
  end
end

class Faker::Movie < ::Faker::Base
  class << self
    # Produces a quote from a movie.
    #
    # @example
    #   Faker::Movie.quote #=> "Bumble bee tuna"
    # @return [String]
    #
    # source://faker//lib/faker/movies/movie.rb#28
    def quote; end

    # Produces a title from a movie.
    #
    # @example
    #   Faker::Movie.title #=> "The Lord of the Rings: The Two Towers"
    # @return [String]
    #
    # source://faker//lib/faker/movies/movie.rb#15
    def title; end
  end
end

class Faker::Movies; end

class Faker::Movies::BackToTheFuture < ::Faker::Base
  class << self
    # Produces a character from Back to the Future.
    #
    # @example
    #   Faker::Movies::BackToTheFuture.character #=> "Marty McFly"
    # @return [String]
    #
    # source://faker//lib/faker/movies/back_to_the_future.rb#16
    def character; end

    # Produces a date from Back to the Future.
    #
    # @example
    #   Faker::Movies::BackToTheFuture.date #=> "November 5, 1955"
    # @return [String]
    #
    # source://faker//lib/faker/movies/back_to_the_future.rb#29
    def date; end

    # Produces a quote from Back to the Future.
    #
    # @example
    #   Faker::Movies::BackToTheFuture.quote
    #   #=> "Roads? Where we're going, we don't need roads."
    # @return [String]
    #
    # source://faker//lib/faker/movies/back_to_the_future.rb#43
    def quote; end
  end
end

class Faker::Movies::Departed < ::Faker::Base
  class << self
    # Produces an actor from The Departed.
    #
    # @example
    #   Faker::Movies::Departed.actor #=> "Matt Damon"
    # @return [String]
    #
    # source://faker//lib/faker/movies/departed.rb#16
    def actor; end

    # Produces a character from The Departed.
    #
    # @example
    #   Faker::Movies::Departed.character #=> "Frank Costello"
    # @return [String]
    #
    # source://faker//lib/faker/movies/departed.rb#29
    def character; end

    # Produces a quote from The Departed.
    #
    # @example
    #   Faker::Movies::Departed.quote
    #   #=> "I'm the guy who does his job. You must be the other guy"
    # @return [String]
    #
    # source://faker//lib/faker/movies/departed.rb#43
    def quote; end
  end
end

class Faker::Movies::Ghostbusters < ::Faker::Base
  class << self
    # Produces an actor from Ghostbusters.
    #
    # @example
    #   Faker::Movies::Ghostbusters.actor #=> "Bill Murray"
    # @return [String]
    #
    # source://faker//lib/faker/movies/ghostbusters.rb#16
    def actor; end

    # Produces a character from Ghostbusters.
    #
    # @example
    #   Faker::Movies::Ghostbusters.character #=> "Dr. Egon Spengler"
    # @return [String]
    #
    # source://faker//lib/faker/movies/ghostbusters.rb#29
    def character; end

    # Produces a quote from Ghostbusters.
    #
    # @example
    #   Faker::Movies::Ghostbusters.quote
    #   #=> "I tried to think of the most harmless thing. Something I loved from my childhood. Something that could never ever possibly destroy us. Mr. Stay Puft!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/ghostbusters.rb#43
    def quote; end
  end
end

class Faker::Movies::Hackers < ::Faker::Base
  class << self
    # Produces a real character name from Hackers.
    #
    # @example
    #   Faker::Movies::Hackers.character #=> "Dade Murphy"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hackers.rb#16
    def character; end

    # Produces a character hacker "handle" from Hackers.
    #
    # @example
    #   Faker::Movies::Hackers.handle #=> "Zero Cool"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hackers.rb#29
    def handle; end

    # Produces a quote from Hackers.
    #
    # @example
    #   Faker::Movies::Hackers.quote #=> "Hack the Planet!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hackers.rb#42
    def quote; end
  end
end

class Faker::Movies::HarryPotter < ::Faker::Base
  class << self
    # Produces a book from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.book #=> "Harry Potter and the Chamber of Secrets"
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#55
    def book; end

    # Produces a character from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.character #=> "Harry Potter"
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#16
    def character; end

    # Produces a house from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.house #=> "Gryffindor"
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#68
    def house; end

    # Produces a location from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.location #=> "Hogwarts"
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#29
    def location; end

    # Produces a quote from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.quote #=> "I solemnly swear that I am up to good."
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#42
    def quote; end

    # Produces a spell from Harry Potter.
    #
    # @example
    #   Faker::Movies::HarryPotter.spell #=> "Reparo"
    # @return [String]
    #
    # source://faker//lib/faker/movies/harry_potter.rb#81
    def spell; end
  end
end

class Faker::Movies::HitchhikersGuideToTheGalaxy < ::Faker::Base
  class << self
    # Produces a character from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.character #=> "Marvin"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#16
    def character; end

    # Produces a location from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.location
    #   #=> "Arthur Dent's house"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#30
    def location; end

    # Produces a Marvin quote from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.marvin_quote
    #   #=> "Life? Don't talk to me about life."
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#44
    def marvin_quote; end

    # Produces a planet from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.planet
    #   #=> "Magrathea"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#58
    def planet; end

    # Produces a quote from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.quote
    #   #=> "In the beginning, the Universe was created. This has made a lot of people very angry and been widely regarded as a bad move."
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#72
    def quote; end

    # Produces a species from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.specie
    #   #=> "Perfectly Normal Beast"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#86
    def specie; end

    # Produces a starship from The Hitchhiker's Guide to the Galaxy.
    #
    # @example
    #   Faker::Movies::HitchhikersGuideToTheGalaxy.starship
    #   #=> "Vogon Constructor Fleet"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hitchhikers_guide_to_the_galaxy.rb#100
    def starship; end
  end
end

class Faker::Movies::Hobbit < ::Faker::Base
  class << self
    # Produces the name of a character from The Hobbit.
    #
    # @example
    #   Faker::Movies::Hobbit.character #=> "Gandalf the Grey"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hobbit.rb#16
    def character; end

    # Produces the name of a location from The Hobbit.
    #
    # @example
    #   Faker::Movies::Hobbit.location #=> "The Shire"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hobbit.rb#56
    def location; end

    # Produces a quote from The Hobbit.
    #
    # @example
    #   Faker::Movies::Hobbit.quote
    #   #=> "Never laugh at live dragons, Bilbo you fool!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hobbit.rb#43
    def quote; end

    # Produces the name of one of the 13 dwarves from the Company, or Gandalf or Bilbo.
    #
    # @example
    #   Faker::Movies::Hobbit.thorins_company #=> "Thorin Oakenshield"
    # @return [String]
    #
    # source://faker//lib/faker/movies/hobbit.rb#29
    def thorins_company; end
  end
end

class Faker::Movies::HowToTrainYourDragon < ::Faker::Base
  class << self
    # Produces a character from How To Train Your Dragon.
    #
    # @example
    #   Faker::Movies::HowToTrainYourDragon.character #=> "Hiccup"
    # @return [String]
    #
    # source://faker//lib/faker/movies/how_to_train_your_dragon.rb#16
    def character; end

    # Produces a dragon from How To Train Your Dragon.
    #
    # @example
    #   Faker::Movies::HowToTrainYourDragon.dragons #=> "Toothless"
    # @return [String]
    #
    # source://faker//lib/faker/movies/how_to_train_your_dragon.rb#42
    def dragon; end

    # Produces a location from How To Train Your Dragon.
    #
    # @example
    #   Faker::Movies::HowToTrainYourDragon.location #=> "Berk"
    # @return [String]
    #
    # source://faker//lib/faker/movies/how_to_train_your_dragon.rb#29
    def location; end
  end
end

class Faker::Movies::Lebowski < ::Faker::Base
  class << self
    # Produces an actor from The Big Lebowski.
    #
    # @example
    #   Faker::Movies::Lebowski.actor #=> "John Goodman"
    # @return [String]
    #
    # source://faker//lib/faker/movies/lebowski.rb#16
    def actor; end

    # Produces a character from The Big Lebowski.
    #
    # @example
    #   Faker::Movies::Lebowski.character #=> "Jackie Treehorn"
    # @return [String]
    #
    # source://faker//lib/faker/movies/lebowski.rb#29
    def character; end

    # Produces a quote from The Big Lebowski.
    #
    # @example
    #   Faker::Movies::Lebowski.quote #=> "Forget it, Donny, you're out of your element!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/lebowski.rb#42
    def quote; end
  end
end

class Faker::Movies::LordOfTheRings < ::Faker::Base
  class << self
    # Produces a character from Lord of the Rings.
    #
    # @example
    #   Faker::Movies::LordOfTheRings.character #=> "Legolas"
    # @return [String]
    #
    # source://faker//lib/faker/movies/lord_of_the_rings.rb#16
    def character; end

    # Produces a location from Lord of the Rings.
    #
    # @example
    #   Faker::Movies::LordOfTheRings.location #=> "Helm's Deep"
    # @return [String]
    #
    # source://faker//lib/faker/movies/lord_of_the_rings.rb#29
    def location; end

    # Produces a quote from Lord of the Rings.
    #
    # @example
    #   Faker::Movies::LordOfTheRings.quote
    #   #=> "I wish the Ring had never come to me. I wish none of this had happened."
    # @return [String]
    #
    # source://faker//lib/faker/movies/lord_of_the_rings.rb#43
    def quote; end
  end
end

class Faker::Movies::PrincessBride < ::Faker::Base
  class << self
    # Produces a character from The Princess Bride.
    #
    # @example
    #   Faker::Movies::PrincessBride.character #=> "Dread Pirate Roberts"
    # @return [String]
    #
    # source://faker//lib/faker/movies/princess_bride.rb#16
    def character; end

    # Produces a quote from The Princess Bride.
    #
    # @example
    #   Faker::Movies::PrincessBride.quote
    #   #=> "Hello. My name is Inigo Montoya. You killed my father. Prepare to die!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/princess_bride.rb#30
    def quote; end
  end
end

class Faker::Movies::StarWars < ::Faker::Base
  class << self
    # Produces a call number from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.call_number #=> "Leader"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#42
    def call_number; end

    # Generates numbers array
    #
    # @example
    #   Faker::Movies::StarWars.call_numbers  #=> ["Leader", "#"]
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#169
    def call_numbers; end

    # Produces a call sign from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.call_sign #=> "Grey 5"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#29
    def call_sign; end

    # Produces a call squadron from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.call_squadron #=> "Green"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#16
    def call_squadron; end

    # Returns squadrons array
    #
    # @example
    #   Faker::Movies::StarWars.call_squadrons  #=> ["Rogue", "Red", "Gray", "Green", "Blue", "Gold", "Black", "Yellow", "Phoenix"]
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#182
    def call_squadrons; end

    # Produces a character from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.character #=> "Anakin Skywalker"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#55
    def character; end

    # Returns all character names in movie
    #
    # @example
    #   Faker::Movies::StarWars.characters
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#195
    def characters; end

    # Produces a droid from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.droid #=> "C-3PO"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#68
    def droid; end

    # Returns droid list
    #
    # @example
    #   Faker::Movies::StarWars.droids
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#208
    def droids; end

    # Produces a planet from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.planet #=> "Tatooine"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#81
    def planet; end

    # Lists out all planet names
    #
    # @example
    #   Faker::Movies::StarWars.planets
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#221
    def planets; end

    # Produces a quote from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.quote #=> "Aren't you a little short for a Stormtrooper?"
    # @example
    #   Faker::Movies::StarWars.quote(character: "leia_organa")
    #   #=> "Aren't you a little short for a Stormtrooper?"
    # @param character [String] The name of a character to derive a quote from.
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#141
    def quote(character: T.unsafe(nil)); end

    # Produces a species from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.specie #=> "Gungan"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#94
    def specie; end

    # Returns name of all species
    #
    # @example
    #   Faker::Movies::StarWars.species
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#234
    def species; end

    # Produces a vehicle from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.vehicle #=> "Sandcrawler"
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#107
    def vehicle; end

    # Lists out all vehicles
    #
    # @example
    #   Faker::Movies::StarWars.vehicles
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#247
    def vehicles; end

    # Produces a wookiee sentence from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.wookiee_sentence #=> "Yrroonn ru ooma roo ahuma ur roooarrgh hnn-rowr."
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#119
    def wookie_sentence; end

    # All wookiee words
    #
    # @example
    #   Faker::Movies::StarWars.wookiee_words
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#260
    def wookie_words; end

    # Produces a wookiee sentence from Star Wars.
    #
    # @example
    #   Faker::Movies::StarWars.wookiee_sentence #=> "Yrroonn ru ooma roo ahuma ur roooarrgh hnn-rowr."
    # @return [String]
    #
    # source://faker//lib/faker/movies/star_wars.rb#119
    def wookiee_sentence; end

    # All wookiee words
    #
    # @example
    #   Faker::Movies::StarWars.wookiee_words
    # @return [Array]
    #
    # source://faker//lib/faker/movies/star_wars.rb#260
    def wookiee_words; end
  end
end

class Faker::Movies::TheRoom < ::Faker::Base
  class << self
    # Produces an actor from The Room (2003).
    #
    # @example
    #   Faker::Movies::Room.actor #=> "Tommy Wiseau"
    # @return [String]
    #
    # source://faker//lib/faker/movies/room.rb#16
    def actor; end

    # Produces a character from The Room (2003).
    #
    # @example
    #   Faker::Movies::Room.character #=> "Johnny"
    # @return [String]
    #
    # source://faker//lib/faker/movies/room.rb#29
    def character; end

    # Produces a location from The Room (2003).
    #
    # @example
    #   Faker::Movies::Room.location #=> "Johnny's Apartment"
    # @return [String]
    #
    # source://faker//lib/faker/movies/room.rb#42
    def location; end

    # Produces a quote from The Room (2003).
    #
    # @example
    #   Faker::Movies::Room.quote
    #   #=> "You're lying, I never hit you. You are tearing me apart, Lisa!"
    # @return [String]
    #
    # source://faker//lib/faker/movies/room.rb#57
    def quote; end
  end
end

class Faker::Movies::Tron < ::Faker::Base
  class << self
    # Produces a character from Tron.
    #
    # @example
    #   Faker::Movies::Tron.character #=> "Bit"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#16
    def character; end

    # source://faker//lib/faker/movies/tron.rb#131
    def characters; end

    # Produces a game from Tron.
    #
    # @example
    #   Faker::Movies::Tron.game #=> "Space Paranoids"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#29
    def game; end

    # source://faker//lib/faker/movies/tron.rb#135
    def games; end

    # Produces a location from Tron.
    #
    # @example
    #   Faker::Movies::Tron.location #=> "Flynn's Arcade"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#42
    def location; end

    # source://faker//lib/faker/movies/tron.rb#139
    def locations; end

    # Produces a program from Tron.
    #
    # @example
    #   Faker::Movies::Tron.program #=> "Clu"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#55
    def program; end

    # source://faker//lib/faker/movies/tron.rb#143
    def programs; end

    # Produces a quote from Tron.
    #
    # @example
    #   Faker::Movies::Tron.quote #=> "Greetings, Programs!"
    # @example
    #   Faker::Movies::Tron.quote(character: "mcp")
    #   #=> "End of Line."
    # @param character [String] The name of a character to derive a quote from.
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#73
    def quote(character: T.unsafe(nil)); end

    # Produces a tagline from Tron.
    #
    # @example
    #   Faker::Movies::Tron.tagline #=> "The Electronic Gladiator"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#101
    def tagline; end

    # source://faker//lib/faker/movies/tron.rb#147
    def taglines; end

    # Produces a user from Tron.
    #
    # @example
    #   Faker::Movies::Tron.user #=> "Light Cycle"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#114
    def user; end

    # source://faker//lib/faker/movies/tron.rb#151
    def users; end

    # Produces a vehicle from Tron.
    #
    # @example
    #   Faker::Movies::Tron.vehicle #=> "Light Cycle"
    # @return [String]
    #
    # source://faker//lib/faker/movies/tron.rb#127
    def vehicle; end

    # source://faker//lib/faker/movies/tron.rb#155
    def vehicles; end
  end
end

class Faker::Movies::VForVendetta < ::Faker::Base
  class << self
    # Produces a character from V For Vendetta.
    #
    # @example
    #   Faker::Movies::VForVendetta.character #=> "V"
    # @return [String]
    #
    # source://faker//lib/faker/movies/v_for_vendetta.rb#16
    def character; end

    # Produces a quote from V For Vendetta.
    #
    # @example
    #   Faker::Movies::VForVendetta.quote
    #   #=> "People should not be afraid of their governments. Governments should be afraid of their people."
    # @return [String]
    #
    # source://faker//lib/faker/movies/v_for_vendetta.rb#44
    def quote; end

    # Produces a speech from V For Vendetta.
    #
    # @example
    #   Faker::Movies::VForVendetta.speech
    #   #=> "Remember, remember, the Fifth of November, the Gunpowder Treason and Plot. I know of no reason why the Gunpowder Treason should ever be forgot..."
    # @return [String]
    #
    # source://faker//lib/faker/movies/v_for_vendetta.rb#30
    def speech; end
  end
end

# A generator of titles of operas by various composers
class Faker::Music < ::Faker::Base
  class << self
    # Produces the name of an album.
    #
    # @example
    #   Faker::Music.album #=> "Sgt. Pepper's Lonely Hearts Club"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#115
    def album; end

    # Produces the name of a band.
    #
    # @example
    #   Faker::Music.band #=> "The Beatles"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#102
    def band; end

    # Produces the name of a chord, using letter notation.
    #
    # @example
    #   Faker::Music.chord #=> "Adim7"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#33
    def chord; end

    # Produces an array of types of chords.
    #
    # @return [Array<String>]
    #
    # source://faker//lib/faker/music/music.rb#89
    def chord_types; end

    # Produces the name of a musical genre.
    #
    # @example
    #   Faker::Music.genre #=> "Rock"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#128
    def genre; end

    # Produces the name of an instrument.
    #
    # @example
    #   Faker::Music.instrument #=> "Acoustic Guitar"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#46
    def instrument; end

    # Produces the name of a key/note, using letter notation.
    #
    # @example
    #   Faker::Music.key #=> "A#"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#20
    def key; end

    # Produces an array of key types (with "major" denoted as an empty string).
    #
    # @example
    #   Faker::Music.key_types #=> ['', 'm']
    # @return [Array<String>]
    #
    # source://faker//lib/faker/music/music.rb#79
    def key_types; end

    # Produces an array of accidentals (with "natural" denoted as an empty string).
    #
    # @return [Array<String>]
    #
    # source://faker//lib/faker/music/music.rb#66
    def key_variants; end

    # Produces an array of the letter names of musical notes, without accidentals.
    #
    # @return [Array<String>]
    #
    # source://faker//lib/faker/music/music.rb#56
    def keys; end

    # Produces a name from Lou Bega's Mambo #5
    #
    # @example
    #   Faker::Music.mambo #=> "Monica"
    # @return [String]
    #
    # source://faker//lib/faker/music/music.rb#140
    def mambo_no_5; end
  end
end

class Faker::Music::GratefulDead < ::Faker::Base
  class << self
    # Produces the name of a member of The Grateful Dead.
    #
    # @example
    #   Faker::Music::GratefulDead.player #=> "Jerry Garcia"
    # @return [String]
    #
    # source://faker//lib/faker/music/grateful_dead.rb#18
    def player; end

    # Produces the name of a song by The Grateful Dead.
    #
    # @example
    #   Faker::Music::GratefulDead.song #=> "Cassidy"
    # @return [String]
    #
    # source://faker//lib/faker/music/grateful_dead.rb#31
    def song; end
  end
end

class Faker::Music::Hiphop < ::Faker::Base
  class << self
    # Produces the name of a Hip Hop Artist
    #
    # @example
    #   Faker::Music::Hiphop.artist #=> "Lil Wayne"
    # @return [String]
    #
    # source://faker//lib/faker/music/hiphop.rb#16
    def artist; end

    # Produces the name of a Hip Hop Group
    #
    # @example
    #   Faker::Music::Hiphop.groups #=> "OVO"
    # @return [String]
    #
    # source://faker//lib/faker/music/hiphop.rb#29
    def groups; end

    # Produces the name of a Hip Hop Subgenre
    #
    # @example
    #   Faker::Music::Hiphop.subgeneres #=> "Alternative"
    # @return [String]
    #
    # source://faker//lib/faker/music/hiphop.rb#42
    def subgenres; end
  end
end

class Faker::Music::Opera < ::Faker::Base
  class << self
    # Produces the title of an opera by Ludwig van Beethoven.
    #
    # @example
    #   Faker::Music::Opera.beethoven #=> "Fidelio"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#149
    def beethoven; end

    # Produces the title of an opera by Vincenzo Bellini.
    #
    # @example
    #   Faker::Music::Opera.bellini #=> "Norma"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#56
    def bellini; end

    # Produces the title of an opera by Alban Berg.
    #
    # @example
    #   Faker::Music::Opera.berg #=> "Wozzeck"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#227
    def berg; end

    # Produces the title of an opera by Hector Berlioz.
    #
    # @example
    #   Faker::Music::Opera.berlioz #=> "Les Troyens"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#253
    def berlioz; end

    # Produces the title of an opera by Georges Bizet.
    #
    # @example
    #   Faker::Music::Opera.bizet #=> "Carmen"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#266
    def bizet; end

    # Produces the title of an opera by Gaetano Donizetti.
    #
    # @example
    #   Faker::Music::Opera.donizetti #=> "Lucia di Lammermoor"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#43
    def donizetti; end

    # Produces the title of an opera by Christoph Willibald Gluck.
    #
    # @example
    #   Faker::Music::Opera.gluck #=> "Orfeo ed Euridice"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#109
    def gluck; end

    # Produces the title of a French opera by Christoph Willibald Gluck.
    #
    # @example
    #   Faker::Music::Opera.gluck_fr #=> "Orphee et Euridice"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#136
    def gluck_french; end

    # Produces the title of an Italian opera by Christoph Willibald Gluck.
    #
    # @example
    #   Faker::Music::Opera.gluck_it #=> "Orfeo ed Euridice"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#123
    def gluck_italian; end

    # Produces the title of an opera by Charles Gounod.
    #
    # @example
    #   Faker::Music::Opera.gounod #=> "Faust"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#279
    def gounod; end

    # Produces the title of an opera by Wolfgang Amadeus Mozart.
    #
    # @example
    #   Faker::Music::Opera.mozart #=> "Die Zauberfloete"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#69
    def mozart; end

    # Produces the title of a German opera by Wolfgang Amadeus Mozart.
    #
    # @example
    #   Faker::Music::Opera.mozart_ger #=> "Die Zauberfloete"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#96
    def mozart_german; end

    # Produces the title of an Italian opera by Wolfgang Amadeus Mozart.
    #
    # @example
    #   Faker::Music::Opera.mozart_it #=> "Cosi fan tutte"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#83
    def mozart_italian; end

    # Produces the title of an opera by Maurice Ravel.
    #
    # @example
    #   Faker::Music::Opera.ravel #=> "L'enfant et les sortileges"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#240
    def ravel; end

    # Produces the title of an opera by Gioacchino Rossini.
    #
    # @example
    #   Faker::Music::Opera.rossini #=> "Il Barbiere di Siviglia"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#30
    def rossini; end

    # Produces the title of an opera by Camille Saint-Saens.
    #
    # @example
    #   Faker::Music::Opera.saint_saens #=> "Samson and Delilah"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#292
    def saint_saens; end

    # Produces the title of an opera by Franz Schubert.
    #
    # @example
    #   Faker::Music::Opera.schubert #=> "Alfonso und Estrella"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#214
    def schubert; end

    # Produces the title of an opera by Robert Schumann.
    #
    # @example
    #   Faker::Music::Opera.schumann #=> "Genoveva"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#201
    def schumann; end

    # Produces the title of an opera by Richard Strauss.
    #
    # @example
    #   Faker::Music::Opera.strauss #=> "Elektra"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#175
    def strauss; end

    # Produces the title of an opera by Giuseppe Verdi.
    #
    # @example
    #   Faker::Music::Opera.verdi #=> "Il Trovatore"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#17
    def verdi; end

    # Produces the title of an opera by Richard Wagner.
    #
    # @example
    #   Faker::Music::Opera.wagner #=> "Tristan und Isolde"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#188
    def wagner; end

    # Produces the title of an opera by Carl Maria von Weber.
    #
    # @example
    #   Faker::Music::Opera.weber #=> "Der Freischuetz"
    # @return [String]
    #
    # source://faker//lib/faker/music/opera.rb#162
    def weber; end
  end
end

class Faker::Music::PearlJam < ::Faker::Base
  class << self
    # Produces the name of an album by Pearl Jam.
    #
    # @example
    #   Faker::Music::PearlJam.album #=> "Ten"
    # @return [String]
    #
    # source://faker//lib/faker/music/pearl_jam.rb#31
    def album; end

    # Produces the name of a member of Pearl Jam (current and former)
    #
    # @example
    #   Faker::Music::PearlJam.musician #=> "Eddie Vedder"
    # @return [String]
    #
    # source://faker//lib/faker/music/pearl_jam.rb#18
    def musician; end

    # Produces the name of a song by Pearl Jam.
    #
    # @example
    #   Faker::Music::PearlJam.song #=> "Even Flow"
    # @return [String]
    #
    # source://faker//lib/faker/music/pearl_jam.rb#44
    def song; end
  end
end

class Faker::Music::Phish < ::Faker::Base
  class << self
    # Produces the name of a album by Phish.
    #
    # @example
    #   Faker::Music::Phish.album #=> "Fuego"
    # @return [String]
    #
    # source://faker//lib/faker/music/phish.rb#16
    def album; end

    # Produces the name of a musician in Phish.
    #
    # @example
    #   Faker::Music::Phish.musician #=> "Trey Anastasio"
    # @return [String]
    #
    # source://faker//lib/faker/music/phish.rb#29
    def musician; end

    # Produces the name of a song by Phish.
    #
    # @example
    #   Faker::Music::Phish.song #=> "Tweezer"
    # @return [String]
    #
    # source://faker//lib/faker/music/phish.rb#42
    def song; end
  end
end

class Faker::Music::Prince < ::Faker::Base
  class << self
    # Produces a random Prince album.
    #
    # @example
    #   Faker::Music::Prince.album #=> "The Gold Experience"
    #   Faker::Music::Prince.album #=> "Purple Rain"
    # @return [String]
    #
    # source://faker//lib/faker/music/prince.rb#45
    def album; end

    # Produces a random Prince-associated band.
    #
    # @example
    #   Faker::Music::Prince.band #=> "The New Power Generation"
    # @return [String]
    #
    # source://faker//lib/faker/music/prince.rb#58
    def band; end

    # Produces a random Prince song lyric.
    #
    # @example
    #   Faker::Music::Prince.lyric #=> "Dearly beloved, we are gathered here today to get through this thing called life."
    #   Faker::Music::Prince.lyric #=> "You were so hard to find, the beautiful ones, they hurt you every time."
    # @return [String]
    #
    # source://faker//lib/faker/music/prince.rb#31
    def lyric; end

    # Produces a random Prince song.
    #
    # @example
    #   Faker::Music::Prince.song #=> "Raspberry Beret"
    #   Faker::Music::Prince.song #=> "Starfish And Coffee"
    # @return [String]
    #
    # source://faker//lib/faker/music/prince.rb#17
    def song; end
  end
end

class Faker::Music::RockBand < ::Faker::Base
  class << self
    # Produces the name of a rock band.
    #
    # @example
    #   Faker::Music::RockBand.name #=> "Led Zeppelin"
    # @return [String]
    #
    # source://faker//lib/faker/music/rock_band.rb#16
    def name; end

    # Produces a rock song.
    #
    # @example
    #   Faker::Music::RockBand.song #=> "Dani California"
    # @return [String]
    #
    # source://faker//lib/faker/music/rock_band.rb#28
    def song; end
  end
end

class Faker::Music::Rush < ::Faker::Base
  class << self
    # Produces the name of an album by Rush
    #
    # @example
    #   Faker::Music::Rush.album #=> "Hold Your Fire"
    # @return [String]
    #
    # source://faker//lib/faker/music/rush.rb#31
    def album; end

    # Produces the name of a member of Rush
    #
    # @example
    #   Faker::Music::Rush.player #=> "Geddy Lee"
    # @return [String]
    #
    # source://faker//lib/faker/music/rush.rb#18
    def player; end
  end
end

class Faker::Music::UmphreysMcgee < ::Faker::Base
  class << self
    # Produces the name of a song by Umphrey's McGee.
    #
    # @example
    #   Faker::Music::UmphreysMcgee.song #=> "Dump City"
    # @return [String]
    #
    # source://faker//lib/faker/music/umphreys_mcgee.rb#16
    def song; end
  end
end

class Faker::Name < ::Faker::Base
  class << self
    # Produces a random female first name.
    #
    # @example
    #   Faker::Name.female_first_name #=> "Natasha"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#75
    def female_first_name; end

    # Produces a random female first name.
    #
    # @example
    #   Faker::Name.female_first_name #=> "Natasha"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#75
    def feminine_name; end

    # Produces a random first name.
    #
    # @example
    #   Faker::Name.first_name #=> "Kaci"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#43
    def first_name; end

    # Produces a random male first name.
    #
    # @example
    #   Faker::Name.male_first_name #=> "Edward"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#60
    def first_name_men; end

    # Produces a random gender neutral first name.
    #
    # @example
    #   Faker::Name.neutral_first_name #=> "Casey"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#90
    def first_name_neutral; end

    # Produces a random female first name.
    #
    # @example
    #   Faker::Name.female_first_name #=> "Natasha"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#75
    def first_name_women; end

    # Produces a random gender neutral first name.
    #
    # @example
    #   Faker::Name.neutral_first_name #=> "Casey"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#90
    def gender_neutral_first_name; end

    # Produces random initials.
    #
    # @example
    #   Faker::Name.initials            #=> "NJM"
    #   Faker::Name.initials(number: 2) #=> "NM"
    # @param number [Integer] Number of digits that the generated initials should have.
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#147
    def initials(number: T.unsafe(nil)); end

    # Produces a random last name.
    #
    # @example
    #   Faker::Name.last_name #=> "Ernser"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#105
    def last_name; end

    # Produces a random male first name.
    #
    # @example
    #   Faker::Name.male_first_name #=> "Edward"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#60
    def male_first_name; end

    # Produces a random male first name.
    #
    # @example
    #   Faker::Name.male_first_name #=> "Edward"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#60
    def masculine_name; end

    # Produces a random last name.
    #
    # @example
    #   Faker::Name.last_name #=> "Ernser"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#105
    def middle_name; end

    # Produces a random name.
    #
    # @example
    #   Faker::Name.name #=> "Tyshawn Johns Sr."
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#17
    def name; end

    # Produces a random name with middle name.
    #
    # @example
    #   Faker::Name.name_with_middle #=> "Aditya Elton Douglas"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#30
    def name_with_middle; end

    # Produces a random gender neutral first name.
    #
    # @example
    #   Faker::Name.neutral_first_name #=> "Casey"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#90
    def neutral_first_name; end

    # Produces a random name prefix.
    #
    # @example
    #   Faker::Name.prefix #=> "Mr."
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#119
    def prefix; end

    # Produces a random name suffix.
    #
    # @example
    #   Faker::Name.suffix #=> "IV"
    # @return [String]
    #
    # source://faker//lib/faker/default/name.rb#132
    def suffix; end
  end
end

class Faker::Nation < ::Faker::Base
  class << self
    # Produces a random capital city.
    #
    # @example
    #   Faker::Nation.capital_city #=> "Kathmandu"
    # @return [String]
    #
    # source://faker//lib/faker/default/nation.rb#55
    def capital_city; end

    # Produces a random national flag emoji.
    #
    # @example
    #   Faker::Nation.flag #=> "🇫🇮"
    # @return [String]
    #
    # source://faker//lib/faker/default/nation.rb#29
    def flag; end

    # Produces a random national language.
    #
    # @example
    #   Faker::Nation.language #=> "Nepali"
    # @return [String]
    #
    # source://faker//lib/faker/default/nation.rb#42
    def language; end

    # Produces a random national sport.
    #
    # @example
    #   Faker::Nation.national_sport #=> "dandi biyo"
    # @return [String]
    #
    # source://faker//lib/faker/default/nation.rb#68
    def national_sport; end

    # Produces a random nationality.
    #
    # @example
    #   Faker::Nation.nationality #=> "Nepalese"
    # @return [String]
    #
    # source://faker//lib/faker/default/nation.rb#16
    def nationality; end
  end
end

class Faker::NationalHealthService < ::Faker::Base
  class << self
    # Produces a random British NHS number.
    #
    # @example
    #   Faker::NationalHealthService.british_number #=> "403 958 5577"
    # @return [String]
    #
    # source://faker//lib/faker/default/nhs.rb#15
    def british_number; end

    # Produces a random British NHS number's check digit.
    #
    # @example
    #   Faker::NationalHealthService.check_digit(number: 400_012_114) #=> 6
    # @param number [Integer] Specifies the NHS number the check digit belongs to.
    # @return [Integer]
    #
    # source://faker//lib/faker/default/nhs.rb#37
    def check_digit(number: T.unsafe(nil)); end
  end
end

class Faker::NatoPhoneticAlphabet < ::Faker::Base
  class << self
    # Produces a code word from the NATO phonetic alphabet.
    #
    # @example
    #   Faker::NatoPhoneticAlphabet.code_word #=> "Hotel"
    # @return [String]
    #
    # source://faker//lib/faker/default/nato_phonetic_alphabet.rb#15
    def code_word; end
  end
end

class Faker::Number < ::Faker::Base
  class << self
    # Produces a number between two provided values. Boundaries are inclusive.
    #
    # @example
    #   Faker::Number.between(from: 1, to: 10) #=> 7
    #   Faker::Number.between(from: 0.0, to: 1.0) #=> 0.7844640543957383
    # @param from [Numeric] The lowest number to include.
    # @param to [Numeric] The highest number to include.
    # @return [Numeric]
    #
    # source://faker//lib/faker/default/number.rb#166
    def between(from: T.unsafe(nil), to: T.unsafe(nil)); end

    # Produces a number in binary format.
    #
    # @example
    #   Faker::Number.binary(digits: 4) #=> "1001"
    # @param digits [Integer] Number of digits to generate the binary as string
    # @return [String]
    #
    # source://faker//lib/faker/default/number.rb#130
    def binary(digits: T.unsafe(nil)); end

    # Produces a float.
    #
    # @example
    #   Faker::Number.decimal(l_digits: 2) #=> 11.88
    #   Faker::Number.decimal(l_digits: 3, r_digits: 3) #=> 181.843
    # @param l_digits [Integer] Number of digits that the generated decimal should have to the left of the decimal point.
    # @param r_digits [Integer] Number of digits that the generated decimal should have to the right of the decimal point.
    # @return [Float]
    #
    # source://faker//lib/faker/default/number.rb#69
    def decimal(l_digits: T.unsafe(nil), r_digits: T.unsafe(nil)); end

    # Produce a number with a number of digits, preserves leading zeroes.
    #
    # @example
    #   Faker::Number.decimal_part(digits: 2) #=> "09"
    # @param digits [Integer] Number of digits that the generated number should have.
    # @return [String]
    #
    # source://faker//lib/faker/default/number.rb#48
    def decimal_part(digits: T.unsafe(nil)); end

    # Produces a single-digit integer.
    #
    # @example
    #   Faker::Number.digit #=> 1
    # @return [Integer]
    #
    # source://faker//lib/faker/default/number.rb#101
    def digit; end

    # Produces a number in hexadecimal format.
    #
    # @example
    #   Faker::Number.hexadecimal(digits: 3) #=> "e74"
    # @param digits [Integer] Number of digits in the he
    # @return [String]
    #
    # source://faker//lib/faker/default/number.rb#115
    def hexadecimal(digits: T.unsafe(nil)); end

    # Produce a random number with a leading zero.
    #
    # @example
    #   Faker::Number.leading_zero_number(digits: 10) #=> "0669336915"
    # @param digits [Integer] Number of digits that the generated number should have.
    # @return [String]
    #
    # source://faker//lib/faker/default/number.rb#34
    def leading_zero_number(digits: T.unsafe(nil)); end

    # Produces a negative float.
    #
    # @example
    #   Faker::Number.negative #=> -4480.042585669558
    # @param from [Integer] The lower boundary.
    # @param to [Integer] The higher boundary.
    # @return [Float]
    #
    # source://faker//lib/faker/default/number.rb#213
    def negative(from: T.unsafe(nil), to: T.unsafe(nil)); end

    # Produces a non-zero single-digit integer.
    #
    # @example
    #   Faker::Number.non_zero_digit #=> 8
    # @return [Integer]
    #
    # source://faker//lib/faker/default/number.rb#88
    def non_zero_digit; end

    # Produces a float given a mean and standard deviation.
    #
    # @example
    #   Faker::Number.normal(mean: 50, standard_deviation: 3.5) #=> 47.14669604069156
    # @param mean [Integer]
    # @param standard_deviation [Numeric]
    # @return [Float]
    #
    # source://faker//lib/faker/default/number.rb#147
    def normal(mean: T.unsafe(nil), standard_deviation: T.unsafe(nil)); end

    # Produce a random number.
    #
    # @example
    #   Faker::Number.number(digits: 10) #=> 1968353479
    # @param digits [Integer] Number of digits that the generated number should have.
    # @return [Integer]
    #
    # source://faker//lib/faker/default/number.rb#16
    def number(digits: T.unsafe(nil)); end

    # Produces a positive float.
    #
    # @example
    #   Faker::Number.positive #=> 235.59238499107653
    # @param from [Integer] The lower boundary.
    # @param to [Integer] The higher boundary.
    # @return [Float]
    #
    # source://faker//lib/faker/default/number.rb#196
    def positive(from: T.unsafe(nil), to: T.unsafe(nil)); end

    # Produces a number within two provided values. Boundaries are inclusive or exclusive depending on the range passed.
    #
    # @example
    #   Faker::Number.within(range: 1..10) #=> 7
    #   Faker::Number.within(range: 0.0..1.0) #=> 0.7844640543957383
    # @param range [Range] The range from which to generate a number.
    # @return [Numeric]
    #
    # source://faker//lib/faker/default/number.rb#181
    def within(range: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/number.rb#221
    def generate(count); end

    # source://faker//lib/faker/default/number.rb#227
    def greater_than_zero(number); end

    # source://faker//lib/faker/default/number.rb#231
    def less_than_zero(number); end

    # source://faker//lib/faker/default/number.rb#235
    def should_be(number, method_to_compare); end
  end
end

class Faker::Omniauth < ::Faker::Base
  # @return [Omniauth] a new instance of Omniauth
  #
  # source://faker//lib/faker/default/omniauth.rb#11
  def initialize(name: T.unsafe(nil), email: T.unsafe(nil)); end

  # Returns the value of attribute email.
  #
  # source://faker//lib/faker/default/omniauth.rb#6
  def email; end

  # Returns the value of attribute first_name.
  #
  # source://faker//lib/faker/default/omniauth.rb#6
  def first_name; end

  # Returns the value of attribute last_name.
  #
  # source://faker//lib/faker/default/omniauth.rb#6
  def last_name; end

  # Returns the value of attribute name.
  #
  # source://faker//lib/faker/default/omniauth.rb#6
  def name; end

  class << self
    # Generate a mock Omniauth response from Apple.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-apple.
    #
    # source://faker//lib/faker/default/omniauth.rb#366
    def apple(name: T.unsafe(nil), email: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from Auth0.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-auth0.
    #
    # source://faker//lib/faker/default/omniauth.rb#410
    def auth0(name: T.unsafe(nil), email: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from Facebook.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param username [String] A specific username to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-facebook.
    #
    # source://faker//lib/faker/default/omniauth.rb#90
    def facebook(name: T.unsafe(nil), email: T.unsafe(nil), username: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from Github.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-github.
    #
    # source://faker//lib/faker/default/omniauth.rb#298
    def github(name: T.unsafe(nil), email: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from Google.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-google.
    #
    # source://faker//lib/faker/default/omniauth.rb#30
    def google(name: T.unsafe(nil), email: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from LinkedIn.
    #
    # @param name [String] A specific name to return in the response.
    # @param email [String] A specific email to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-linkedin.
    #
    # source://faker//lib/faker/default/omniauth.rb#225
    def linkedin(name: T.unsafe(nil), email: T.unsafe(nil), uid: T.unsafe(nil)); end

    # Generate a mock Omniauth response from Twitter.
    #
    # @param name [String] A specific name to return in the response.
    # @param nickname [String] A specific nickname to return in the response.
    # @param uid [String] A specific UID to return in the response.
    # @return [Hash] An auth hash in the format provided by omniauth-twitter.
    #
    # source://faker//lib/faker/default/omniauth.rb#142
    def twitter(name: T.unsafe(nil), nickname: T.unsafe(nil), uid: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/omniauth.rb#458
    def city_state; end

    # source://faker//lib/faker/default/omniauth.rb#446
    def gender; end

    # source://faker//lib/faker/default/omniauth.rb#454
    def image; end

    # source://faker//lib/faker/default/omniauth.rb#466
    def random_boolean; end

    # source://faker//lib/faker/default/omniauth.rb#462
    def random_number_from_range(range); end

    # source://faker//lib/faker/default/omniauth.rb#450
    def timezone; end
  end
end

class Faker::PhoneNumber < ::Faker::Base
  class << self
    # Produces a random US or Canada-based area code.
    #
    # @example
    #   Faker::PhoneNumber.area_code #=> "201"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#93
    def area_code; end

    # Produces a random cell phone number in a random format (may or may not have a country code and can have different dividers).
    #
    # @example
    #   Faker::PhoneNumber.cell_phone #=> "(186)285-7925"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#28
    def cell_phone; end

    # Produces a random phone number in e164 format.
    #
    # @example
    #   Faker::PhoneNumber.cell_phone_in_e164 #=> "+944937040625"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#80
    def cell_phone_in_e164; end

    # Produces a random cell phone number with country code.
    #
    # @example
    #   Faker::PhoneNumber.cell_phone_with_country_code #=> "+974 (190) 987-9034"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#67
    def cell_phone_with_country_code; end

    # Produces a random country code.
    #
    # @example
    #   Faker::PhoneNumber.country_code #=> "+20"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#41
    def country_code; end

    # Produces a random US or Canada-based exchange code.
    #
    # @example
    #   Faker::PhoneNumber.exchange_code #=> "208"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#108
    def exchange_code; end

    # Produces a random US or Canada-based extension / subscriber number. Can be used for both extensions and last four digits of phone number.
    #
    # @example
    #   Faker::PhoneNumber.subscriber_number #=> "3873"
    #   Faker::PhoneNumber.subscriber_number(length: 2) #=> "39"
    #   Faker::PhoneNumber.extension #=> "3764"
    # @param length [Integer] Specifies the length of the return value.
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#126
    def extension(length: T.unsafe(nil)); end

    # Produces a random phone number in a random format (may or may not have a country code, extension and can have different dividers).
    #
    # @example
    #   Faker::PhoneNumber.phone_number #=> "397.693.1309 x4321"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#15
    def phone_number; end

    # Produces a random phone number with country code.
    #
    # @example
    #   Faker::PhoneNumber.phone_number_with_country_code #=> "+95 1-672-173-8153"
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#54
    def phone_number_with_country_code; end

    # Produces a random US or Canada-based extension / subscriber number. Can be used for both extensions and last four digits of phone number.
    #
    # @example
    #   Faker::PhoneNumber.subscriber_number #=> "3873"
    #   Faker::PhoneNumber.subscriber_number(length: 2) #=> "39"
    #   Faker::PhoneNumber.extension #=> "3764"
    # @param length [Integer] Specifies the length of the return value.
    # @return [String]
    #
    # source://faker//lib/faker/default/phone_number.rb#126
    def subscriber_number(length: T.unsafe(nil)); end
  end
end

class Faker::Placeholdit < ::Faker::Base
  class << self
    # Produces a random placeholder image from https://via.placeholder.com.
    #
    #   Faker::Placeholdit.image #=> "https://via.placeholder.com/300x300.png"
    #   Faker::Placeholdit.image(size: '50x50') #=> "https://via.placeholder.com/50x50.png"
    #   Faker::Placeholdit.image(size: '50x50', format: 'jpg') #=> "https://via.placeholder.com/50x50.jpg"
    #   Faker::Placeholdit.image(size: '50x50', format: 'gif', background_color: 'ffffff') #=> "https://via.placeholder.com/50x50.gif/ffffff"
    #   Faker::Placeholdit.image(size: '50x50', format: 'jpeg', background_color: :random) #=> "https://via.placeholder.com/50x50.jpeg/39eba7"
    #   Faker::Placeholdit.image(size: '50x50', format: 'jpeg', background_color: 'ffffff', text_color: '000') #=> "https://via.placeholder.com/50x50.jpeg/ffffff/000"
    #   Faker::Placeholdit.image(size: '50x50', format: 'jpg', background_color: 'ffffff', text_color: '000', text: 'Some Custom Text') #=> "https://via.placeholder.com/50x50.jpg/ffffff/000?text=Some Custom Text"
    #
    # @example
    #   # Keyword arguments: size, format, background_color, text_color, text
    # @param size [String] Specifies the image's size, dimensions separated by 'x'.
    # @param format [String] Specifies the image's extension.
    # @param background_color [String, Symbol] Specifies the background color, either in hexadecimal format (without #) or as :random.
    # @param text_color [String, Symbol] Specifies the text color, either in hexadecimal format (without #) or as :random.
    # @param text [String] Specifies a custom text to be used.
    # @raise [ArgumentError]
    # @return [String]
    #
    # source://faker//lib/faker/default/placeholdit.rb#29
    def image(size: T.unsafe(nil), format: T.unsafe(nil), background_color: T.unsafe(nil), text_color: T.unsafe(nil), text: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/placeholdit.rb#47
    def generate_color; end
  end
end

class Faker::ProgrammingLanguage < ::Faker::Base
  class << self
    # Produces the name of a programming language's creator.
    #
    # @example
    #   Faker::ProgrammingLanguage.creator #=> "Yukihiro Matsumoto"
    # @return [String]
    #
    # source://faker//lib/faker/default/programming_language.rb#28
    def creator; end

    # Produces the name of a programming language.
    #
    # @example
    #   Faker::ProgrammingLanguage.name #=> "Ruby"
    # @return [String]
    #
    # source://faker//lib/faker/default/programming_language.rb#15
    def name; end
  end
end

class Faker::Quote < ::Faker::Base
  class << self
    # Produces a famous last words quote.
    #
    # @example
    #   Faker::Quote.famous_last_words #=> "My vocabulary did this to me. Your love will let you go on..."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#15
    def famous_last_words; end

    # Produces a quote from a fortune cookie.
    #
    # @example
    #   Faker::Quote.fortune_cookie #=> "This cookie senses that you are superstitious; it is an inclination that is bad for your mental health."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#106
    def fortune_cookie; end

    # Produces a quote from Deep Thoughts by Jack Handey.
    #
    # @example
    #   Faker::Quote.jack_handey # => "I hope life isn't a big joke, because I don't get it."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#28
    def jack_handey; end

    # Produces a quote from Matz.
    #
    # @example
    #   Faker::Quote.matz #=> "You want to enjoy life, don't you? If you get your job done quickly and your job is fun, that's good isn't it? That's the purpose of life, partly. Your life is better."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#41
    def matz; end

    # Produces a quote about the most interesting man in the world.
    #
    # @example
    #   Faker::Quote.most_interesting_man_in_the_world #=> "He can speak Russian... in French"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#54
    def most_interesting_man_in_the_world; end

    # Produces a Robin quote.
    #
    # @example
    #   Faker::Quote.robin #=> "Holy Razors Edge"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#67
    def robin; end

    # Produces a singular siegler quote.
    #
    # @example
    #   Faker::Quote.singular_siegler #=> "Texas!"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#80
    def singular_siegler; end

    # Produces a quote from Yoda.
    #
    # @example
    #   Faker::Quote.yoda #=> "Use your feelings, Obi-Wan, and find him you will."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/quote.rb#93
    def yoda; end
  end
end

class Faker::Quotes; end

class Faker::Quotes::Chiquito < ::Faker::Base
  class << self
    # Produces an Expression from Chiquito
    #
    # @example
    #   Faker::Quotes::Chiquito.expression # => "Ereh un torpedo!"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/chiquito.rb#16
    def expression; end

    # Produces a joke from Chiquito
    #
    # @example
    #   Faker::Quotes::Chiquito.joke # => "- Papar papar llevame al circo!
    #   - Noorl! El que quiera verte que venga a la casa"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/chiquito.rb#43
    def joke; end

    # Produces a sentence from Chiquito
    #
    # @example
    #   Faker::Quotes::Chiquito.sentence # => "Te llamo trigo por no llamarte Rodrigo"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/chiquito.rb#56
    def sentence; end

    # Produces a concept from Chiquito
    #
    # @example
    #   Faker::Quotes::Chiquito.term # => "Fistro"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/chiquito.rb#29
    def term; end

    private

    # source://faker//lib/faker/quotes/chiquito.rb#62
    def expressions; end

    # source://faker//lib/faker/quotes/chiquito.rb#70
    def jokes; end

    # source://faker//lib/faker/quotes/chiquito.rb#74
    def sentences; end

    # source://faker//lib/faker/quotes/chiquito.rb#66
    def terms; end
  end
end

class Faker::Quotes::Rajnikanth < ::Faker::Base
  class << self
    # Produces a Rajnikanth.
    # Original list of jokes:
    # http://www.rajinikanthjokes.com/
    #
    # @example
    #   Faker::Rajnikanth.joke
    #   #=> "Rajinikanth is so fast that he always comes yesterday."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/rajnikanth.rb#21
    def joke; end
  end
end

class Faker::Quotes::Shakespeare < ::Faker::Base
  class << self
    # Generates quote from 'As you like it!'
    #
    # @example
    #   Faker::Quotes::Shakespeare.as_you_like_it   #=> "How bitter a thing it is to look into happiness through another man's eyes!"
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#81
    def as_you_like_it; end

    # Produces a Shakespeare quote from As You Like It.
    #
    # @example
    #   Faker::Quotes::Shakespeare.as_you_like_it_quote # => "Can one desire too much of a good thing?."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#29
    def as_you_like_it_quote; end

    # Generates quote from Hamlet
    #
    # @example
    #   Faker::Quotes::Shakespeare.hamlet   #=> "A little more than kin, and less than kind."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#68
    def hamlet; end

    # Produces a Shakespeare quote from Hamlet.
    #
    # @example
    #   Faker::Quotes::Shakespeare.hamlet_quote # => "To be, or not to be: that is the question."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#16
    def hamlet_quote; end

    # Returns quote from 'King Rechard III'
    #
    # @example
    #   Faker::Quotes::Shakespeare  #=> "The king's name is a tower of strength."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#92
    def king_richard_iii; end

    # Produces a Shakespeare quote from King Richard III.
    #
    # @example
    #   Faker::Quotes::Shakespeare.king_richard_iii_quote # => "Now is the winter of our discontent."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#42
    def king_richard_iii_quote; end

    # Quote from 'Romeo and Juliet'
    #
    # @example
    #   Faker::Quotes::Shakespeare.romeo_and_juliet  #=> "Wisely and slow; they stumble that run fast."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#105
    def romeo_and_juliet; end

    # Produces a Shakespeare quote from Romeo And Juliet.
    #
    # @example
    #   Faker::Quotes::Shakespeare.romeo_and_juliet_quote # => "O Romeo, Romeo! wherefore art thou Romeo?."
    # @return [String]
    #
    # source://faker//lib/faker/quotes/shakespeare.rb#55
    def romeo_and_juliet_quote; end
  end
end

class Faker::Relationship < ::Faker::Base
  class << self
    # Produces a random family relationship.
    #
    # @example
    #   Faker::Relationship.familial #=> "Grandfather"
    # @return [String]
    #
    # source://faker//lib/faker/default/relationship.rb#17
    def familial(connection: T.unsafe(nil)); end

    # Produces a random in-law relationship.
    #
    # @example
    #   Faker::Relationship.in_law #=> "Brother-in-law"
    # @return [String]
    #
    # source://faker//lib/faker/default/relationship.rb#43
    def in_law; end

    # Produces a random parent relationship.
    #
    # @example
    #   Faker::Relationship.parent #=> "Father"
    # @return [String]
    #
    # source://faker//lib/faker/default/relationship.rb#69
    def parent; end

    # Produces a random sibling relationship.
    #
    # @example
    #   Faker::Relationship.sibling #=> "Sister"
    # @return [String]
    #
    # source://faker//lib/faker/default/relationship.rb#82
    def sibling; end

    # Produces a random spouse relationship.
    #
    # @example
    #   Faker::Relationship.spouse #=> "Husband"
    # @return [String]
    #
    # source://faker//lib/faker/default/relationship.rb#56
    def spouse; end
  end
end

module Faker::Religion; end

class Faker::Religion::Bible < ::Faker::Base
  class << self
    # Returns a random bible character.
    #
    # Faker::Religion::Bible.character #=> "Jesus"
    #
    # @return [String]
    #
    # source://faker//lib/faker/religion/bible.rb#18
    def character; end

    # Returns a random location(city or town) from the bible
    #
    # Faker::Religion::Bible.location #=> "Nasareth"
    #
    # @return [String]
    #
    # source://faker//lib/faker/religion/bible.rb#31
    def location; end

    # Returns a random quote from the location.
    #
    # Faker::Religion::Bible.quote #=> "Seek first the kingdom of God "
    #
    # @return [String]
    #
    # source://faker//lib/faker/religion/bible.rb#44
    def quote; end
  end
end

class Faker::Restaurant < ::Faker::Base
  class << self
    # Produces a description of a restaurant.
    #
    # @example
    #   Faker::Restaurant.description
    #   #=> "We are committed to using the finest ingredients in our recipes. No food leaves our kitchen that we ourselves would not eat."
    # @return [String]
    #
    # source://faker//lib/faker/default/restaurant.rb#44
    def description; end

    # Produces the name of a restaurant.
    #
    # @example
    #   Faker::Restaurant.name #=> "Curry King"
    # @return [String]
    #
    # source://faker//lib/faker/default/restaurant.rb#17
    def name; end

    # Produces a review for a restaurant.
    #
    # @example
    #   Faker::Restaurant.review
    #   #=> "Brand new. Great design. Odd to hear pop music in a Mexican establishment. Music is a bit loud. It should be background."
    # @return [String]
    #
    # source://faker//lib/faker/default/restaurant.rb#58
    def review; end

    # Produces a type of restaurant.
    #
    # @example
    #   Faker::Restaurant.type #=> "Comfort Food"
    # @return [String]
    #
    # source://faker//lib/faker/default/restaurant.rb#30
    def type; end
  end
end

class Faker::Science < ::Faker::Base
  class << self
    # Produces the name of a element.
    #
    # @example
    #   Faker::Science.element #=> "Carbon"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#56
    def element; end

    # Produces the state of an element.
    #
    # @example
    #   Faker::Science.element_state #=> "Liquid"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#82
    def element_state; end

    # Produces the subcategory of an element.
    #
    # @example
    #   Faker::Science.element_subcategory #=> "Reactive nonmetal"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#95
    def element_subcategory; end

    # Produces the symbol of an element.
    #
    # @example
    #   Faker::Science.element_symbol #=> "Pb"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#69
    def element_symbol; end

    # Produces a scientifically sounding word
    #
    # @example
    #   Faker::Science.modifier #=> "Quantum"
    #   Faker::Science.modifier #=> "Superconductive"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#122
    def modifier; end

    # Produces a name of a science
    # You can optionally filter by specifying one or more of the following:
    # `:empirical, :formal, :natural, :social, :basic, :applied`
    #
    # @example
    #   Faker::Science.science #=> "Space science"
    #   Faker::Science.science(:natural, :applied) #=> "Engineering"
    #   Faker::Science.science(:formal, :applied) #=> "Computer Science"
    # @param branches [Array<Symbol>]
    # @raise [ArgumentError]
    # @return [String]
    # @see https://en.wikipedia.org/wiki/Science#Branches_of_science
    # @see Faker::Educator.subject
    #
    # source://faker//lib/faker/default/science.rb#31
    def science(*branches); end

    # Produces the name of a scientist.
    #
    # @example
    #   Faker::Science.scientist #=> "Isaac Newton"
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#108
    def scientist; end

    # Produces the name of a scientific tool.
    # By default it uses a science word modifier to generate more diverse data, which can be disabled.
    #
    # @example
    #   Faker::Science.tool #=> "Superconductive Microcentrifuge"
    #   Faker::Science.tool #=> "Portable Cryostat"
    #   Faker::Science.tool #=> "Quantum Spectrophotometer"
    #   Faker::Science.tool(simple: true) #=> "Microcentrifuge"
    # @param simple [Boolean] Whether to generate simple realistic tool names, (no Q-word).
    # @return [String]
    #
    # source://faker//lib/faker/default/science.rb#140
    def tool(simple: T.unsafe(nil)); end
  end
end

class Faker::Show < ::Faker::Base
  class << self
    # Produces the name of a musical for an older audience
    #
    # @example
    #   Faker::Alphanumeric.alpha
    #   #=> "West Side Story"
    # @return [String]
    #
    # source://faker//lib/faker/music/show.rb#16
    def adult_musical; end

    # Produces the name of a musical for a younger audience
    #
    # @example
    #   Faker::Alphanumeric.alpha
    #   #=> "Into the Woods JR."
    # @return [String]
    #
    # source://faker//lib/faker/music/show.rb#30
    def kids_musical; end

    # Produces the name of a play
    #
    # @example
    #   Faker::Alphanumeric.alpha
    #   #=> "Death of a Salesman"
    # @return [String]
    #
    # source://faker//lib/faker/music/show.rb#44
    def play; end
  end
end

class Faker::SlackEmoji < ::Faker::Base
  class << self
    # Produces a random slack emoji from activity category.
    #
    # @example
    #   Faker::SlackEmoji.activity #=> ":soccer:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#67
    def activity; end

    # Produces a random slack emoji from celebration category.
    #
    # @example
    #   Faker::SlackEmoji.celebration #=> ":tada:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#54
    def celebration; end

    # Produces a random slack emoji from custom category.
    #
    # @example
    #   Faker::SlackEmoji.custom #=> ":slack:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#106
    def custom; end

    # Produces a random slack emoji from any category.
    #
    # @example
    #   Faker::SlackEmoji.emoji #=> ":pizza:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#119
    def emoji; end

    # Produces a random slack emoji from food and drink category.
    #
    # @example
    #   Faker::SlackEmoji.food_and_drink #=> ":beers:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#41
    def food_and_drink; end

    # Produces a random slack emoji from nature category.
    #
    # @example
    #   Faker::SlackEmoji.nature #=> ":mount_fuji:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#28
    def nature; end

    # Produces a random slack emoji from objects and symbols category.
    #
    # @example
    #   Faker::SlackEmoji.objects_and_symbols #=> ":id:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#93
    def objects_and_symbols; end

    # Produces a random slack emoji from people category.
    #
    # @example
    #   Faker::SlackEmoji.people #=> ":sleepy:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#15
    def people; end

    # Produces a random slack emoji from travel and places category.
    #
    # @example
    #   Faker::SlackEmoji.travel_and_places #=> ":metro:"
    # @return [String]
    #
    # source://faker//lib/faker/default/slack_emoji.rb#80
    def travel_and_places; end
  end
end

class Faker::Source < ::Faker::Base
  class << self
    # Produces source code for Hello World in a given language.
    #
    # @example
    #   Faker::Source.hello_world #=> "puts 'Hello World!'"
    # @example
    #   Faker::Source.hello_world(lang: :javascript)
    #   #=> "alert('Hello World!');"
    # @param lang [Symbol] The programming language to use
    # @return [String]
    #
    # source://faker//lib/faker/default/source.rb#20
    def hello_world(lang: T.unsafe(nil)); end

    # Produces source code for printing a string in a given language.
    #
    # @example
    #   Faker::Source.print #=> "puts 'faker_string_to_print'"
    # @example
    #   Faker::Source.print(str: 'foo bar', lang: :javascript)
    #   #=> "console.log('foo bar');"
    # @param str [String] The string to print
    # @param lang [Symbol] The programming language to use
    # @return [String]
    #
    # source://faker//lib/faker/default/source.rb#38
    def print(str: T.unsafe(nil), lang: T.unsafe(nil)); end

    # Produces source code for printing 1 through 10 in a given language.
    #
    # @example
    #   Faker::Source.print_1_to_10 #=> "(1..10).each { |i| puts i }"
    # @example
    #   Faker::Source.print_1_to_10(lang: :javascript)
    #   # => "for (let i=0; i<10; i++) {
    #   #       console.log(i);
    #   #    }"
    # @param lang [Symbol] The programming language to use
    # @return [String]
    #
    # source://faker//lib/faker/default/source.rb#58
    def print_1_to_10(lang: T.unsafe(nil)); end
  end
end

class Faker::SouthAfrica < ::Faker::Base
  class << self
    # Produces a South African cell phone number.
    #
    # @example
    #   Faker::SouthAfrica.cell_phone #=> "082 946 7470"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#69
    def cell_phone; end

    # Produces a South African close corporation registration number.
    #
    # @example
    #   Faker::SouthAfrica.close_corporation_registration_number #=> "CK74/7585/23"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#97
    def close_corporation_registration_number; end

    # Produces a South African ID number.
    #
    # @example
    #   Faker::SouthAfrica.id_number #=> "6110311856083"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#15
    def id_number; end

    # Produces an invalid South African ID number
    #
    # @example
    #   Faker::SouthAfrica.invalid_id_number #=> "7018356904081"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#41
    def invalid_id_number; end

    # Produces a South African listed company registration number.
    #
    # @example
    #   Faker::SouthAfrica.listed_company_registration_number #=> "7039/3135/06"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#110
    def listed_company_registration_number; end

    # Produces a South African phone number.
    #
    # @example
    #   Faker::SouthAfrica.phone_number #=> "010 788 5009"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#54
    def phone_number; end

    # Produces a South African private company registration number.
    #
    # @example
    #   Faker::SouthAfrica.pty_ltd_registration_number #=> "5301/714689/07"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#84
    def pty_ltd_registration_number; end

    # Produces a South African trust registration number.
    #
    # @example
    #   Faker::SouthAfrica.trust_registration_number #=> "IT38/6489900"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#123
    def trust_registration_number; end

    # Produces a valid South African ID number
    #
    # @example
    #   Faker::SouthAfrica.valid_id_number #=> "6110311856083"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#28
    def valid_id_number; end

    # Produces a South African VAT number.
    #
    # @example
    #   Faker::SouthAfrica.vat_number #=> "ZA79494416181"
    # @return [String]
    #
    # source://faker//lib/faker/default/south_africa.rb#136
    def vat_number; end
  end
end

class Faker::Space < ::Faker::Base
  class << self
    # Produces the name of a space agency.
    #
    # @example
    #   Faker::Space.agency #=> "Japan Aerospace Exploration Agency"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#108
    def agency; end

    # Produces a space agency abbreviation.
    #
    # @example
    #   Faker::Space.agency_abv #=> "NASA"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#121
    def agency_abv; end

    # Produces the name of a space company.
    #
    # @example
    #   Faker::Space.company #=> "SpaceX"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#147
    def company; end

    # Produces the name of a constellation.
    #
    # @example
    #   Faker::Space.constellation #=> "Orion"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#82
    def constellation; end

    # Produces a distance measurement.
    #
    # @example
    #   Faker::Space.distance_measurement #=> "15 parsecs"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#160
    def distance_measurement; end

    # Produces the name of a galaxy.
    #
    # @example
    #   Faker::Space.galaxy #=> "Andromeda"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#43
    def galaxy; end

    # Produces the name of a launch vehicle.
    #
    # @example
    #   Faker::Space.launch_vehicle #=> "Saturn IV"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#186
    def launch_vehicle; end

    # Produces the name of a meteorite.
    #
    # @example
    #   Faker::Space.meteorite #=> "Ensisheim"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#173
    def meteorite; end

    # Produces the name of a moon.
    #
    # @example
    #   Faker::Space.moon #=> "Europa"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#30
    def moon; end

    # Produces the name of a NASA spacecraft.
    #
    # @example
    #   Faker::Space.nasa_space_craft #=> "Endeavour"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#134
    def nasa_space_craft; end

    # Produces the name of a nebula.
    #
    # @example
    #   Faker::Space.nebula #=> "Triffid Nebula"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#56
    def nebula; end

    # Produces the name of a planet.
    #
    # @example
    #   Faker::Space.planet #=> "Venus"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#17
    def planet; end

    # Produces the name of a star.
    #
    # @example
    #   Faker::Space.star #=> "Proxima Centauri"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#95
    def star; end

    # Produces the name of a star cluster.
    #
    # @example
    #   Faker::Space.star_cluster #=> "Messier 70"
    # @return [String]
    #
    # source://faker//lib/faker/default/space.rb#69
    def star_cluster; end
  end
end

class Faker::Sport < ::Faker::Base
  class << self
    # Produces a sport from the ancient olympics.
    #
    # @example
    #   Faker::Sport.ancient_olympics_sport #=> "Pankration"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#111
    def ancient_olympics_sport; end

    # Produces a sport from the modern olympics or paralympics, summer or winter.
    #
    # @example
    #   Faker::Sport.sport #=> "Football"
    # @example
    #   Faker::Sport.sport(include_ancient: true) #=> "Chariot racing"
    # @example
    #   Faker::Sport.sport(include_unsual: true) #=> "Flugtag/Birdman"
    # @example
    #   Faker::Sport.sport(include_ancient:true, include_unusual: true) #=> "Water polo"
    # @param include_ancient [Boolean] If true, may produce a sport from the ancient olympics
    # @param include_unusual [Boolean] If true, may produce an unusual (definitely not olympic) sport
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#24
    def sport(include_ancient: T.unsafe(nil), include_unusual: T.unsafe(nil)); end

    # Produces a sport from the summer olympics.
    #
    # @example
    #   Faker::Sport.summer_olympics_sport #=> "Archery"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#46
    def summer_olympics_sport; end

    # Produces a sport from the summer paralympics.
    #
    # @example
    #   Faker::Sport.summer_paralympics_sport #=> "Wheelchair Basketball"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#72
    def summer_paralympics_sport; end

    # Produces an unusual sport.
    #
    # @example
    #   Faker::Sport.unusual_sport #=> "Camel Jumping"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#98
    def unusual_sport; end

    # Produces a sport from the winter olympics.
    #
    # @example
    #   Faker::Sport.winter_olympics_sport #=> "Bobsleigh"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#59
    def winter_olympics_sport; end

    # Produces a sport from the winter paralympics.
    #
    # @example
    #   Faker::Sport.winter_paralympics_sport #=> "Para Ice Hockey"
    # @return [String]
    #
    # source://faker//lib/faker/sports/sport.rb#85
    def winter_paralympics_sport; end
  end
end

class Faker::Sports; end

class Faker::Sports::Basketball < ::Faker::Base
  class << self
    # Produces the name of a basketball coach.
    #
    # @example
    #   Faker::Sports::Basketball.coach #=> "Gregg Popovich"
    # @return [String]
    #
    # source://faker//lib/faker/sports/basketball.rb#42
    def coach; end

    # Produces the name of a basketball player.
    #
    # @example
    #   Faker::Sports::Basketball.player #=> "LeBron James"
    # @return [String]
    #
    # source://faker//lib/faker/sports/basketball.rb#29
    def player; end

    # Produces a position in basketball.
    #
    # @example
    #   Faker::Sports::Basketball.position #=> "Point Guard"
    # @return [String]
    #
    # source://faker//lib/faker/sports/basketball.rb#55
    def position; end

    # Produces the name of a basketball team.
    #
    # @example
    #   Faker::Sports::Basketball.team #=> "Golden State Warriors"
    # @return [String]
    #
    # source://faker//lib/faker/sports/basketball.rb#16
    def team; end
  end
end

class Faker::Sports::Football < ::Faker::Base
  class << self
    # Produces the name of a football coach.
    #
    # @example
    #   Faker::Sports::Football.coach #=> "Jose Mourinho"
    # @return [String]
    #
    # source://faker//lib/faker/sports/football.rb#42
    def coach; end

    # Produces a football competition.
    #
    # @example
    #   Faker::Sports::Football.competition #=> "FIFA World Cup"
    # @return [String]
    #
    # source://faker//lib/faker/sports/football.rb#55
    def competition; end

    # Produces the name of a football player.
    #
    # @example
    #   Faker::Sports::Football.player #=> "Lionel Messi"
    # @return [String]
    #
    # source://faker//lib/faker/sports/football.rb#29
    def player; end

    # Produces a position in football.
    #
    # @example
    #   Faker::Sports::Football.position #=> "Defensive Midfielder"
    # @return [String]
    #
    # source://faker//lib/faker/sports/football.rb#68
    def position; end

    # Produces the name of a football team.
    #
    # @example
    #   Faker::Sports::Football.team #=> "Manchester United"
    # @return [String]
    #
    # source://faker//lib/faker/sports/football.rb#16
    def team; end
  end
end

class Faker::Sports::Mountaineering < ::Faker::Base
  class << self
    # Produces the name of a Mountaineer.
    #
    # @example
    #   Faker::Sports::Mountaineering.mountaineer #=> "Junko Tabei"
    # @return [String]
    #
    # source://faker//lib/faker/sports/mountaineering.rb#16
    def mountaineer; end
  end
end

class Faker::Sports::Volleyball < ::Faker::Base
  class << self
    # Produces the name of a volleyball coach.
    #
    # @example
    #   Faker::Sports::Volleyball.coach #=> "Russ Rose"
    # @return [String]
    #
    # source://faker//lib/faker/sports/volleyball.rb#42
    def coach; end

    # Produces a formation in volleyball.
    #
    # @example
    #   Faker::Sports::Volleyball.formation #=> "4-2"
    # @return [String]
    #
    # source://faker//lib/faker/sports/volleyball.rb#68
    def formation; end

    # Produces the name of a volleyball player.
    #
    # @example
    #   Faker::Sports::Volleyball.player #=> "Saeid Marouf"
    # @return [String]
    #
    # source://faker//lib/faker/sports/volleyball.rb#29
    def player; end

    # Produces a position in volleyball.
    #
    # @example
    #   Faker::Sports::Volleyball.position #=> "Middle blocker"
    # @return [String]
    #
    # source://faker//lib/faker/sports/volleyball.rb#55
    def position; end

    # Produces the name of a volleyball team.
    #
    # @example
    #   Faker::Sports::Volleyball.team #=> "Leo Shoes Modena"
    # @return [String]
    #
    # source://faker//lib/faker/sports/volleyball.rb#16
    def team; end
  end
end

class Faker::String < ::Faker::Base
  class << self
    # Produces a random UTF-8 string with optional nested length selectors.
    #
    # @example
    #   Faker::String.random #=> "3 뇦\u0017&y\u{3A109}$8^4* 녹豿4좘툢ꔾ쉙6ɉ\uA6 8TN畀챵|\"3쇤Ŵ"
    #   Faker::String.random(length: 4) #=> "⼨%0*"
    #   Faker::String.random(length: 3..12) #=> "\u{69FDC};秨툫"
    #   Faker::String.random(length: [0, 6]) #=> "I轤𣴒P溟L"
    #   Faker::String.random(length: [1, (2..5), [3, 6], nil]) #=> "葓L#ћ"
    # @param length [Integer, Range, Array<Integer, Range, nil>] The length of produced string and/or specific UTF-8 characters to use.
    # @return [String]
    #
    # source://faker//lib/faker/default/string.rb#20
    def random(length: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/string.rb#45
    def char_space_ratio; end

    # source://faker//lib/faker/default/string.rb#26
    def select_a(length); end

    # source://faker//lib/faker/default/string.rb#41
    def space_or_utf8_char(ratio); end

    # source://faker//lib/faker/default/string.rb#49
    def utf8character; end

    # source://faker//lib/faker/default/string.rb#34
    def utf8string(length); end
  end
end

class Faker::Stripe < ::Faker::Base
  class << self
    # Produces a random ccv number.
    #
    # @example
    #   Faker::Stripe.ccv #=> "123"
    #   Faker::Stripe.ccv(card_type: "amex") #=> "1234"
    # @param card_type [String] Specific valid card type.
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#121
    def ccv(card_type: T.unsafe(nil)); end

    # Produces a random invalid card number.
    #
    # @example
    #   Faker::Stripe.invalid_card #=> "4000000000000002"
    #   Faker::Stripe.invalid_card(card_error: "addressZipFail") #=> "4000000000000010"
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#68
    def invalid_card(card_error: T.unsafe(nil)); end

    # Produces a random month in two digits format.
    #
    # @example
    #   Faker::Stripe.month #=> "10"
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#92
    def month; end

    # Produces a random valid card number.
    #
    # @example
    #   Faker::Stripe.valid_card #=> "4242424242424242"
    #   Faker::Stripe.valid_card(card_type: "visa_debit") #=> "4000056655665556"
    # @param card_type [String] Specific valid card type.
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#17
    def valid_card(card_type: T.unsafe(nil)); end

    # Produces a random valid Stripe token.
    #
    # @example
    #   Faker::Stripe.valid_token #=> "tok_visa"
    #   Faker::Stripe.valid_token(card_type: "mc_debit") #=> "tok_mastercard_debit"
    # @param card_type [String] Specific valid card type.
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#43
    def valid_token(card_type: T.unsafe(nil)); end

    # Produces a random year that is always in the future.
    #
    # @example
    #   Faker::Stripe.year #=> "2018" # This will always be a year in the future
    # @return [String]
    #
    # source://faker//lib/faker/default/stripe.rb#105
    def year; end
  end
end

class Faker::Subscription < ::Faker::Base
  class << self
    # Produces the name of a payment method.
    #
    # @example
    #   Faker::Subscription.payment_method #=> "PayPal"
    # @return [String]
    #
    # source://faker//lib/faker/default/subscription.rb#40
    def payment_method; end

    # Produces the name of a payment term.
    #
    # @example
    #   Faker::Subscription.payment_term #=> "Monthly"
    # @return [String]
    #
    # source://faker//lib/faker/default/subscription.rb#66
    def payment_term; end

    # Produces the name of a subscription plan.
    #
    # @example
    #   Faker::Subscription.plan #=> "Platinum"
    # @return [String]
    #
    # source://faker//lib/faker/default/subscription.rb#14
    def plan; end

    # Produces a subscription status.
    #
    # @example
    #   Faker::Subscription.status #=> "Active"
    # @return [String]
    #
    # source://faker//lib/faker/default/subscription.rb#27
    def status; end

    # Produces the name of a subscription term.
    #
    # @example
    #   Faker::Subscription.subscription_term #=> "Annual"
    # @return [String]
    #
    # source://faker//lib/faker/default/subscription.rb#53
    def subscription_term; end
  end
end

class Faker::Superhero < ::Faker::Base
  class << self
    # Produces a superhero descriptor.
    #
    # @example
    #   Faker::Superhero.descriptor #=> "Bizarro"
    # @return [String]
    #
    # source://faker//lib/faker/default/superhero.rb#54
    def descriptor; end

    # Produces a random superhero name.
    #
    # @example
    #   Faker::Superhero.name #=> "Magnificent Shatterstar"
    # @return [String]
    #
    # source://faker//lib/faker/default/superhero.rb#67
    def name; end

    # Produces a superpower.
    #
    # @example
    #   Faker::Superhero.power #=> "Photokinesis"
    # @return [String]
    #
    # source://faker//lib/faker/default/superhero.rb#15
    def power; end

    # Produces a superhero name prefix.
    #
    # @example
    #   Faker::Superhero.prefix #=> "the Fated"
    # @return [String]
    #
    # source://faker//lib/faker/default/superhero.rb#28
    def prefix; end

    # Produces a superhero name suffix.
    #
    # @example
    #   Faker::Superhero.suffix #=> "Captain"
    # @return [String]
    #
    # source://faker//lib/faker/default/superhero.rb#41
    def suffix; end
  end
end

class Faker::Tea < ::Faker::Base
  class << self
    # Produces a random type of tea.
    #
    # @example
    #   Faker::Tea.type
    #   #=> "Green"
    # @return [String] a type of tea
    #
    # source://faker//lib/faker/default/tea.rb#36
    def type; end

    # Produces a random variety or blend of tea.
    #
    # @example
    #   Faker::Tea.variety
    #   #=> "Earl Grey"
    # @example
    #   Faker::Tea.variety(type: 'Green')
    #   #=> "Jasmine"
    # @param type [String, nil] the type of tea to query for (valid types: 'Black', 'Green', 'Oolong', 'White', and 'Herbal')
    # @return [String] a variety of tea
    #
    # source://faker//lib/faker/default/tea.rb#22
    def variety(type: T.unsafe(nil)); end
  end
end

class Faker::Team < ::Faker::Base
  class << self
    # Produces a team creature.
    #
    # @example
    #   Faker::Team.creature #=> "geese"
    # @return [String]
    #
    # source://faker//lib/faker/default/team.rb#30
    def creature; end

    # Produces the name of a team mascot.
    #
    # @example
    #   Faker::Team.mascot #=> "Hugo"
    # @return [String]
    #
    # source://faker//lib/faker/default/team.rb#69
    def mascot; end

    # Produces a team name from a state and a creature.
    #
    # @example
    #   Faker::Team.name #=> "Oregon vixens"
    # @return [String]
    #
    # source://faker//lib/faker/default/team.rb#17
    def name; end

    # Produces a team sport.
    #
    # @example
    #   Faker::Team.sport #=> "Lacrosse"
    # @return [String]
    #
    # source://faker//lib/faker/default/team.rb#56
    def sport; end

    # Produces a team state.
    #
    # @example
    #   Faker::Team.state #=> "Oregon"
    # @return [String]
    #
    # source://faker//lib/faker/default/team.rb#43
    def state; end
  end
end

class Faker::Time < ::Faker::Base
  class << self
    # Produce a random time in the past (up to N days).
    #
    # @example
    #   Faker::Time.backward(days: 14, period: :evening)
    #   #=> "2014-09-17 19:56:33 -0700"
    #   Faker::Time.backward(days: 5, period: :morning, format: :short)
    #   #=> "14 Oct 07:44"
    # @param days [Integer] The maximum number of days to go into the past.
    # @param period [Symbol] The time of day, if any. See {TIME_RANGES}.
    # @param format [Symbol] The name of a DateTime format to use.
    # @return [Time]
    #
    # source://faker//lib/faker/default/time.rb#114
    def backward(days: T.unsafe(nil), period: T.unsafe(nil), format: T.unsafe(nil)); end

    # Produce a random time between two times.
    #
    # @example
    #   # Random Stringified time between two times, formatted to the specified I18n format
    #   # (Examples are from a Rails console with rails-i18n 5.1.1 defaults loaded)
    #   I18n.locale = 'en-US'
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :default) #=> "Tue, 16 Oct 2018 10:48:27 AM -05:00"
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :short) #=> "15 Oct 10:48 AM"
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :long) #=> "October 15, 2018 10:48 AM"
    #
    #   I18n.locale = 'ja'
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :default) #=> "2018/10/15 10:48:27"
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :short) #=> "18/10/15 10:48"
    #   Faker::Time.between(from: DateTime.now - 1, to: DateTime.now, format: :long) #=> "2018年10月16日(火) 10時48分27秒 -0500"
    # @param from [Time, Date, DateTime] The start of the usable time range.
    # @param to [Time, Date, DateTime] The end of the usable time range.
    # @param format [Symbol] The name of a DateTime format to use.
    # @return [Time]
    #
    # source://faker//lib/faker/default/time.rb#38
    def between(from:, to:, format: T.unsafe(nil)); end

    # Produce a random time between two dates.
    #
    # @example
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :all)
    #   #=> "2014-09-19 07:03:30 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :day)
    #   #=> "2014-09-18 16:28:13 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :night)
    #   #=> "2014-09-20 19:39:38 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :morning)
    #   #=> "2014-09-19 08:07:52 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :afternoon)
    #   #=> "2014-09-18 12:10:34 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :evening)
    #   #=> "2014-09-19 20:21:03 -0700"
    #   Faker::Time.between_dates(from: Date.today - 1, to: Date.today, period: :midnight)
    #   #=> "2014-09-20 00:40:14 -0700"
    #   Faker::Time.between_dates(from: Date.today - 5, to: Date.today + 5, period: :afternoon, format: :default)
    #   #=> "Fri, 19 Oct 2018 15:17:46 -0500"
    # @param from [Date] The start of the usable time range.
    # @param to [Date] The end of the usable time range.
    # @param period [Symbol] The time of day, if any. See {TIME_RANGES}.
    # @param format [Symbol] The name of a DateTime format to use.
    # @return [Time]
    #
    # source://faker//lib/faker/default/time.rb#74
    def between_dates(from:, to:, period: T.unsafe(nil), format: T.unsafe(nil)); end

    # Produce a random time in the future (up to N days).
    #
    # @example
    #   Faker::Time.forward(days: 23, period: :morning)
    #   # => "2014-09-26 06:54:47 -0700"
    #   Faker::Time.forward(days: 5,  period: :evening, format: :long)
    #   #=> "October 21, 2018 20:47"
    # @param days [Integer] The maximum number of days to go into the future.
    # @param period [Symbol] The time of day, if any. See {TIME_RANGES}.
    # @param format [Symbol] The name of a DateTime format to use.
    # @return [Time]
    #
    # source://faker//lib/faker/default/time.rb#95
    def forward(days: T.unsafe(nil), period: T.unsafe(nil), format: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/time.rb#120
    def date_with_random_time(date, period); end

    # source://faker//lib/faker/default/time.rb#142
    def get_time_object(time); end

    # @raise [ArgumentError]
    #
    # source://faker//lib/faker/default/time.rb#128
    def hours(period); end

    # source://faker//lib/faker/default/time.rb#134
    def minutes; end

    # source://faker//lib/faker/default/time.rb#138
    def seconds; end

    # source://faker//lib/faker/default/time.rb#124
    def time_with_format(time, format); end
  end
end

# source://faker//lib/faker/default/time.rb#5
Faker::Time::TIME_RANGES = T.let(T.unsafe(nil), Hash)

class Faker::TvShows; end

class Faker::TvShows::AquaTeenHungerForce < ::Faker::Base
  class << self
    # Produces a character from Aqua Teen Hunger Force.
    #
    # @example
    #   Faker::TvShows::AquaTeenHungerForce.character #=> "Master Shake"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/aqua_teen_hunger_force.rb#18
    def character; end

    # Produces a perl of great ATHF wisdom
    #
    # @example
    #   Faker::TvShows::AquaTeenHungerForce.quote #=> "Friendship ain't about trust. Friendship's about nunchucks."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/aqua_teen_hunger_force.rb#31
    def quote; end
  end
end

class Faker::TvShows::BigBangTheory < ::Faker::Base
  class << self
    # Produces a character from Big Bang Theory
    #
    # @example
    #   Faker::TvShows::BigBangTheory.character #=> "Sheldon Cooper"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/big_bang_theory.rb#18
    def character; end

    # Produces a quote from Bing Bang Theory
    #
    # @example
    #   Faker::TvShows::BigBangTheory.quote #=> "I'm not crazy. My mother had me tested."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/big_bang_theory.rb#31
    def quote; end
  end
end

class Faker::TvShows::BojackHorseman < ::Faker::Base
  class << self
    # Produces a character from BoJack Horseman.
    #
    # @example
    #   Faker::TvShows::BojackHorseman.character #=> "BoJack Horseman"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/bojack_horseman.rb#18
    def character; end

    # Produces a quote from BoJack Horseman.
    #
    # @example
    #   Faker::TvShows::BojackHorseman.quote
    #   #=> "Not understanding that you're a horrible person doesn't make you less of a horrible person."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/bojack_horseman.rb#45
    def quote; end

    # Produces a tongue twister from BoJack Horseman.
    #
    # @example
    #   Faker::TvShows::BojackHorseman.tongue_twister #=> "Did you steal a meal from Neal McBeal the Navy Seal?"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/bojack_horseman.rb#31
    def tongue_twister; end
  end
end

class Faker::TvShows::BreakingBad < ::Faker::Base
  class << self
    # Produces the name of a character from Breaking Bad.
    #
    # @example
    #   Faker::TvShows::BreakingBad.character #=> "Walter White"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/breaking_bad.rb#18
    def character; end

    # Produces the name of an episode from Breaking Bad.
    #
    # @example
    #   Faker::TvShows::BreakingBad.episode #=> "Fly"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/breaking_bad.rb#31
    def episode; end
  end
end

class Faker::TvShows::BrooklynNineNine < ::Faker::Base
  class << self
    # Produces a character from Brooklyn Nine Nine.
    #
    # @example
    #   Faker::TvShows::BrooklynNineNine.character #=> "Jake Peralta"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/brooklyn_nine_nine.rb#18
    def character; end

    # Produces a quote from Brooklyn Nine Nine.
    #
    # @example
    #   Faker::TvShows::BrooklynNineNine.quote
    #   #=> "Cool, cool, cool, cool, cool. No doubt, no doubt, no doubt."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/brooklyn_nine_nine.rb#32
    def quote; end
  end
end

class Faker::TvShows::Buffy < ::Faker::Base
  class << self
    # Produces a actor from Buffy the Vampire Slayer.
    #
    # @example
    #   Faker::TvShows::Buffy.actor #=> "John Ritter"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#44
    def actor; end

    # Produces a big bad from Buffy the Vampire Slayer.
    #
    # @example
    #   Faker::TvShows::Buffy.big_bad #=> "Glory"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#70
    def big_bad; end

    # Produces a actor from Buffy the Vampire Slayer.
    # Produces a actor from Buffy the Vampire Slayer.
    #
    # @deprecated Use the `actor` method instead.
    # @example
    #   Faker::TvShows::Buffy.actor #=> "John Ritter"
    # @example
    #   Faker::TvShows::Buffy.celebrity #=> "John Ritter"
    # @return [String]
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#44
    def celebrity; end

    # Produces a character from Buffy the Vampire Slayer.
    #
    # @example
    #   Faker::TvShows::Buffy.character #=> "Buffy Summers"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#18
    def character; end

    # Produces an episode from Buffy the Vampire Slayer.
    #
    # @example
    #   Faker::TvShows::Buffy.episode #=> "Once More, with Feeling"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#83
    def episode; end

    # Produces a quote from Buffy the Vampire Slayer.
    #
    # @example
    #   Faker::TvShows::Buffy.quote #=> "If the apocalypse comes, beep me."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/buffy.rb#31
    def quote; end
  end
end

class Faker::TvShows::Community < ::Faker::Base
  class << self
    # Produces a character from Community.
    #
    # @example
    #   Faker::TvShows::Community.characters #=> "Jeff Winger"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/community.rb#18
    def characters; end

    # Produces a quote from Community.
    #
    # @example
    #   Faker::TvShows::Community.quotes
    #   #=> "I fear a political career could shine a negative light on my drug dealing."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/community.rb#32
    def quotes; end
  end
end

class Faker::TvShows::DrWho < ::Faker::Base
  class << self
    # Produces an actor from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.actor #=> "Matt Smith"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#44
    def actor; end

    # Produces a catch phrase from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.catch_phrase #=> "Fantastic!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#57
    def catch_phrase; end

    # Produces a character from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.character #=> "Captain Jack Harkness"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#18
    def character; end

    # Produces a quote from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.quote #=> "Lots of planets have a north!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#70
    def quote; end

    # Produces a species from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.specie #=> "Dalek"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#109
    def specie; end

    # Produces an iteration of The Doctor from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.the_doctor #=> "Ninth Doctor"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#31
    def the_doctor; end

    # Produces a villain from Doctor Who.
    #
    # @example
    #   Faker::TvShows::DrWho.villain #=> "The Master"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#83
    def villain; end

    # Produces a villain from Doctor Who.
    # Produces a villain from Doctor Who.
    #
    # @deprecated Use the correctly-spelled `villain` method instead.
    # @example
    #   Faker::TvShows::DrWho.villain #=> "The Master"
    # @example
    #   Faker::TvShows::DrWho.villian #=> "The Master"
    # @return [String]
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dr_who.rb#83
    def villian; end
  end
end

class Faker::TvShows::DumbAndDumber < ::Faker::Base
  class << self
    # Produces an actor from Dumb and Dumber.
    #
    # @example
    #   Faker::TvShows::DumbAndDumber.actor #=> "Jim Carrey"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dumb_and_dumber.rb#18
    def actor; end

    # Produces a character from Dumb and Dumber.
    #
    # @example
    #   Faker::TvShows::DumbAndDumber.character #=> "Harry Dunne"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dumb_and_dumber.rb#31
    def character; end

    # Produces a quote from Dumb and Dumber.
    #
    # @example
    #   Faker::TvShows::DumbAndDumber.quote
    #   #=> "Why you going to the airport? Flying somewhere?"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/dumb_and_dumber.rb#45
    def quote; end
  end
end

class Faker::TvShows::FamilyGuy < ::Faker::Base
  class << self
    # Produces a character from Family Guy.
    #
    # @example
    #   Faker::TvShows::FamilyGuy.character #=> "Peter Griffin"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/family_guy.rb#18
    def character; end

    # Produces a location from Family Guy.
    #
    # @example
    #   Faker::TvShows::FamilyGuy.location #=> "James Woods High"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/family_guy.rb#31
    def location; end

    # Produces a quote from Family Guy.
    #
    # @example
    #   Faker::TvShows::FamilyGuy.quote
    #   #=> "It's Peanut Butter Jelly Time."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/family_guy.rb#45
    def quote; end
  end
end

class Faker::TvShows::FinalSpace < ::Faker::Base
  class << self
    # Produces a character from Final Space.
    #
    # @example
    #   Faker::TvShows::FinalSpace.character #=> "Gary Goodspeed"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/final_space.rb#18
    def character; end

    # Produces a quote from Final Space.
    #
    # @example
    #   Faker::TvShows::FinalSpace.quote
    #   #=> "It's an alien on my face! It's an alien on my...It's a space alien!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/final_space.rb#45
    def quote; end

    # Produces a vehicle from Final Space.
    #
    # @example
    #   Faker::TvShows::FinalSpace.vehicle #=> "Imperium Cruiser"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/final_space.rb#31
    def vehicle; end
  end
end

class Faker::TvShows::Friends < ::Faker::Base
  class << self
    # Produces a character from Friends.
    #
    # @example
    #   Faker::TvShows::Friends.character #=> "Rachel Green"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/friends.rb#18
    def character; end

    # Produces a location from Friends.
    #
    # @example
    #   Faker::TvShows::Friends.location #=> "Central Perk"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/friends.rb#31
    def location; end

    # Produces a quote from Friends.
    #
    # @example
    #   Faker::TvShows::Friends.quote #=> "We were on a break!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/friends.rb#44
    def quote; end
  end
end

class Faker::TvShows::Futurama < ::Faker::Base
  class << self
    # Produces a character from Futurama.
    #
    # @example
    #   Faker::TvShows::Futurama.character #=> "Amy Wong"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/futurama.rb#18
    def character; end

    # Produces a catchphrase from Hermes Conrad.
    #
    # @example
    #   Faker::TvShows::Futurama.hermes_catchphrase
    #   #=> "Great foo of bar!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/futurama.rb#59
    def hermes_catchphrase; end

    # Produces a location from Futurama.
    #
    # @example
    #   Faker::TvShows::Futurama.location #=> "Wormulon"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/futurama.rb#31
    def location; end

    # Produces a quote from Futurama.
    #
    # @example
    #   Faker::TvShows::Futurama.quote
    #   #=> "Ugh, it's like a party in my mouth & everyone's throwing up."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/futurama.rb#45
    def quote; end
  end
end

class Faker::TvShows::GameOfThrones < ::Faker::Base
  class << self
    # Produces a character from Game of Thrones.
    #
    # @example
    #   Faker::TvShows::GameOfThrones.character #=> "Tyrion Lannister"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/game_of_thrones.rb#18
    def character; end

    # Produces a city from Game of Thrones.
    #
    # @example
    #   Faker::TvShows::GameOfThrones.city #=> "Lannisport"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/game_of_thrones.rb#44
    def city; end

    # Produces a dragon from Game of Thrones.
    #
    # @example
    #   Faker::TvShows::GameOfThrones.dragon #=> "Drogon"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/game_of_thrones.rb#71
    def dragon; end

    # Produces a house from Game of Thrones.
    #
    # @example
    #   Faker::TvShows::GameOfThrones.house #=> "Stark"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/game_of_thrones.rb#31
    def house; end

    # Produces a quote from Game of Thrones.
    #
    # @example
    #   Faker::TvShows::GameOfThrones.quote
    #   #=> "Never forget who you are. The rest of the world won't. Wear it like an armor and it can never be used against you."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/game_of_thrones.rb#58
    def quote; end
  end
end

class Faker::TvShows::HeyArnold < ::Faker::Base
  class << self
    # Produces a character from Hey Arnold!
    #
    # @example
    #   Faker::TvShows::HeyArnold.character #=> "Arnold"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/hey_arnold.rb#18
    def character; end

    # Produces a location from Hey Arnold!
    #
    # @example
    #   Faker::TvShows::HeyArnold.location #=> "Big Bob's Beeper Emporium"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/hey_arnold.rb#31
    def location; end

    # Produces a quote from Hey Arnold!
    #
    # @example
    #   Faker::TvShows::HeyArnold.quote #=> "Stoop Kid's afraid to leave his stoop!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/hey_arnold.rb#44
    def quote; end
  end
end

class Faker::TvShows::HowIMetYourMother < ::Faker::Base
  class << self
    # Produces a catch phrase from How I Met Your Mother.
    #
    # @example
    #   Faker::TvShows::HowIMetYourMother.catch_phrase #=> "Legendary"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/how_i_met_your_mother.rb#31
    def catch_phrase; end

    # Produces a character from How I Met Your Mother.
    #
    # @example
    #   Faker::TvShows::HowIMetYourMother.character #=> "Barney Stinson"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/how_i_met_your_mother.rb#18
    def character; end

    # Produces a high five from How I Met Your Mother.
    #
    # @example
    #   Faker::TvShows::HowIMetYourMother.high_five #=> "Relapse Five"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/how_i_met_your_mother.rb#44
    def high_five; end

    # Produces a quote from How I Met Your Mother.
    #
    # @example
    #   Faker::TvShows::HowIMetYourMother.quote
    #   #=> "Whenever I'm sad, I stop being sad and be awesome instead."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/how_i_met_your_mother.rb#58
    def quote; end
  end
end

class Faker::TvShows::MichaelScott < ::Faker::Base
  class << self
    # Produces a quote from Michael Scott.
    #
    # @example
    #   Faker::TvShows::MichaelScott.quote
    #   #=> "I am Beyoncé, always."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/michael_scott.rb#17
    def quote; end
  end
end

class Faker::TvShows::NewGirl < ::Faker::Base
  class << self
    # Produces a character from New Girl.
    #
    # @example
    #   Faker::TvShows::NewGirl.character #=> "Jessica Day"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/new_girl.rb#18
    def character; end

    # Produces a quote from New Girl.
    #
    # @example
    #   Faker::TvShows::NewGirl.quote
    #   #=> "Are you cooking a frittata in a sauce pan? What is this - prison?"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/new_girl.rb#32
    def quote; end
  end
end

class Faker::TvShows::ParksAndRec < ::Faker::Base
  class << self
    # Produces a character from Parks and Recreation.
    #
    # @example
    #   Faker::TvShows::ParksAndRec.character #=> "Leslie Knope"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/parks_and_rec.rb#18
    def character; end

    # Produces a city from Parks and Recreation.
    #
    # @example
    #   Faker::TvShows::ParksAndRec.city #=> "Pawnee"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/parks_and_rec.rb#31
    def city; end
  end
end

class Faker::TvShows::RickAndMorty < ::Faker::Base
  class << self
    # Produces a character from Rick and Morty.
    #
    # @example
    #   Faker::TvShows::RickAndMorty.character #=> "Rick Sanchez"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/rick_and_morty.rb#18
    def character; end

    # Produces a location from Rick and Morty.
    #
    # @example
    #   Faker::TvShows::RickAndMorty.location #=> "Dimension C-132"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/rick_and_morty.rb#31
    def location; end

    # Produces a quote from Rick and Morty.
    #
    # @example
    #   Faker::TvShows::RickAndMorty.quote
    #   #=> "Ohh yea, you gotta get schwifty."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/rick_and_morty.rb#45
    def quote; end
  end
end

class Faker::TvShows::RuPaul < ::Faker::Base
  class << self
    # Produces a queen from RuPaul's Drag Race.
    #
    # @example
    #   Faker::TvShows::RuPaul.queen #=> "Latrice Royale"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/ru_paul.rb#31
    def queen; end

    # Produces a quote from RuPaul's Drag Race.
    #
    # @example
    #   Faker::TvShows::RuPaul.quote #=> "That's Funny, Tell Another One."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/ru_paul.rb#18
    def quote; end
  end
end

class Faker::TvShows::Seinfeld < ::Faker::Base
  class << self
    # Produces a business from Seinfeld.
    #
    # @example
    #   Faker::TvShows::Seinfeld.business #=> "Kruger Industrial Smoothing"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/seinfeld.rb#18
    def business; end

    # Produces a character from Seinfeld.
    #
    # @example
    #   Faker::TvShows::Seinfeld.character #=> "George Costanza"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/seinfeld.rb#31
    def character; end

    # Produces a quote from Seinfeld.
    #
    # @example
    #   Faker::TvShows::Seinfeld.quote
    #   #=> "I'm not a lesbian. I hate men, but I'm not a lesbian."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/seinfeld.rb#45
    def quote; end
  end
end

class Faker::TvShows::SiliconValley < ::Faker::Base
  class << self
    # Produces an app from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.app #=> "Nip Alert"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#58
    def app; end

    # Produces a character from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.character #=> "Jian Yang"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#18
    def character; end

    # Produces a company from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.company #=> "Bachmanity"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#31
    def company; end

    # Produces an email address from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.email #=> "richard@piedpiper.test"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#112
    def email; end

    # Produces an invention from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.invention
    #   #=> "Tres Comas Tequila"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#72
    def invention; end

    # Produces a motto from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.motto
    #   #=> "Our products are products, producing unrivaled results"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#86
    def motto; end

    # Produces a quote from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.quote
    #   #=> "I don't want to live in a world where someone else is making the world a better place better than we are."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#45
    def quote; end

    # Produces a URL from Silicon Valley.
    #
    # @example
    #   Faker::TvShows::SiliconValley.url #=> "http://www.piedpiper.com"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/silicon_valley.rb#99
    def url; end
  end
end

class Faker::TvShows::Simpsons < ::Faker::Base
  class << self
    # Produces a character from The Simpsons.
    #
    # @example
    #   Faker::TvShows::Simpsons.character #=> "Charles Montgomery Burns"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/simpsons.rb#18
    def character; end

    # Produces an episode title from The Simpsons.
    #
    # @example
    #   Faker::TvShows::Simpsons.episode_title
    #   #=> "Two Cars in Every Garage and Three Eyes on Every Fish"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/simpsons.rb#59
    def episode_title; end

    # Produces a location from The Simpsons.
    #
    # @example
    #   Faker::TvShows::Simpsons.location #=> "Moe's Tavern"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/simpsons.rb#31
    def location; end

    # Produces a quote from The Simpsons.
    #
    # @example
    #   Faker::TvShows::Simpsons.quote
    #   #=> "It takes two to lie: one to lie and one to listen."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/simpsons.rb#45
    def quote; end
  end
end

class Faker::TvShows::SouthPark < ::Faker::Base
  class << self
    # Produces a character from South Park.
    #
    # @example
    #   Faker::TvShows::SouthPark.character #=> "Mr. Garrison"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/south_park.rb#18
    def character; end

    # Produces a quote from South Park.
    #
    # @example
    #   Faker::TvShows::SouthPark.quote
    #   #=> "I'm just getting a little cancer Stan."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/south_park.rb#32
    def quote; end
  end
end

class Faker::TvShows::Spongebob < ::Faker::Base
  class << self
    # Produces a character from Spongebob.
    #
    # @example
    #   Faker::TvShows::Spongebob.character #=> "Patrick"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/spongebob.rb#18
    def character; end

    # Produces an episode from Spongebob.
    #
    # @example
    #   Faker::TvShows::Spongebob.episode #=> "Reef Blower"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/spongebob.rb#44
    def episode; end

    # Produces a quote from Spongebob.
    #
    # @example
    #   Faker::TvShows::Spongebob.quote #=> "I'm ready! I'm ready!"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/spongebob.rb#31
    def quote; end
  end
end

class Faker::TvShows::StarTrek < ::Faker::Base
  class << self
    # Produces a character from Star Trek.
    #
    # @example
    #   Faker::TvShows::StarTrek.character #=> "Spock"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/star_trek.rb#18
    def character; end

    # Produces a location from Star Trek.
    #
    # @example
    #   Faker::TvShows::StarTrek.location #=> "Cardassia"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/star_trek.rb#31
    def location; end

    # Produces a species from Star Trek.
    #
    # @example
    #   Faker::TvShows::StarTrek.specie #=> "Ferengi"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/star_trek.rb#44
    def specie; end

    # Produces a villain from Star Trek.
    #
    # @example
    #   Faker::TvShows::StarTrek.villain #=> "Khan Noonien Singh"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/star_trek.rb#57
    def villain; end
  end
end

class Faker::TvShows::Stargate < ::Faker::Base
  class << self
    # Produces a character from Stargate.
    #
    # @example
    #   Faker::TvShows::Stargate.character #=> "Jack O'Neill"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/stargate.rb#18
    def character; end

    # Produces a planet from Stargate.
    #
    # @example
    #   Faker::TvShows::Stargate.planet #=> "Abydos"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/stargate.rb#31
    def planet; end

    # Produces a quote from Stargate.
    #
    # @example
    #   Faker::TvShows::Stargate.quote
    #   #=> "General, request permission to beat the crap out of this man."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/stargate.rb#45
    def quote; end
  end
end

class Faker::TvShows::StrangerThings < ::Faker::Base
  class << self
    # Produces a quote from Stranger Things.
    #
    # @example
    #   Faker::TvShows::StrangerThings.quote
    #   #=> "Friends don't lie."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/stranger_things.rb#32
    def character; end

    # Produces a character from Stranger Things.
    #
    # @example
    #   Faker::TvShows::StrangerThings.character #=> "six"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/stranger_things.rb#18
    def quote; end
  end
end

class Faker::TvShows::Suits < ::Faker::Base
  class << self
    # Produces a character from Suits.
    #
    # @example
    #   Faker::TvShows::Suits.character #=> "Harvey Specter"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/suits.rb#18
    def character; end

    # Produces a quote from Suits.
    #
    # @example
    #   Faker::TvShows::Suits.quote #=> "Don't play the odds, play the man."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/suits.rb#31
    def quote; end
  end
end

class Faker::TvShows::Supernatural < ::Faker::Base
  class << self
    # Produces the name of a character from Supernatural.
    #
    # @example
    #   Faker::TvShows::Supernatural.character #=> "Dean Winchester"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/supernatural.rb#16
    def character; end

    # Produces the name of a hunted creature.
    #
    # @example
    #   Faker::TvShows::Supernatural.creature #=> "Demon"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/supernatural.rb#29
    def creature; end

    # Produces the name of a weapon used by the hunters.
    #
    # @example
    #   Faker::TvShows::Supernatural.weapon #=> "Colt"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/supernatural.rb#42
    def weapon; end
  end
end

class Faker::TvShows::TheExpanse < ::Faker::Base
  class << self
    # Produces a character from The Expanse.
    #
    # @example
    #   Faker::TvShows::TheExpanse.character #=> "Jim Holden"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_expanse.rb#18
    def character; end

    # Produces a location from The Expanse.
    #
    # @example
    #   Faker::TvShows::TheExpanse.location #=> "Ganymede"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_expanse.rb#44
    def location; end

    # Produces a quote from The Expanse.
    #
    # @example
    #   Faker::TvShows::TheExpanse.quote #=> "I am that guy."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_expanse.rb#31
    def quote; end

    # Produces a ship from The Expanse.
    #
    # @example
    #   Faker::TvShows::TheExpanse.ship #=> "Nauvoo"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_expanse.rb#57
    def ship; end
  end
end

class Faker::TvShows::TheFreshPrinceOfBelAir < ::Faker::Base
  class << self
    # Produces a actor from The Fresh Prince of Bel-Air.
    #
    # @example
    #   Faker::TvShows::TheFreshPrinceOfBelAir.actor #=> "Quincy Jones"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_fresh_prince_of_bel_air.rb#31
    def actor; end

    # Produces a actor from The Fresh Prince of Bel-Air.
    # Produces a actor from The Fresh Prince of Bel-Air.
    #
    # @deprecated Use the `actor` method instead.
    # @example
    #   Faker::TvShows::TheFreshPrinceOfBelAir.actor #=> "Quincy Jones"
    # @example
    #   Faker::TvShows::TheFreshPrinceOfBelAir.celebrity #=> "Quincy Jones"
    # @return [String]
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_fresh_prince_of_bel_air.rb#31
    def celebrity; end

    # Produces a character from The Fresh Prince of Bel-Air.
    #
    # @example
    #   Faker::TvShows::TheFreshPrinceOfBelAir.character #=> "Will Smith"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_fresh_prince_of_bel_air.rb#18
    def character; end

    # Produces a quote from The Fresh Prince of Bel-Air.
    #
    # @example
    #   Faker::TvShows::TheFreshPrinceOfBelAir.quote
    #   #=> "Girl, you look so good, I would marry your brother just to get in your family."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_fresh_prince_of_bel_air.rb#58
    def quote; end
  end
end

class Faker::TvShows::TheITCrowd < ::Faker::Base
  class << self
    # Produces an actor from The IT Crowd.
    #
    # @example
    #   Faker::TvShows::TheITCrowd.actor #=> "Chris O'Dowd"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_it_crowd.rb#18
    def actor; end

    # Produces a character from The IT Crowd.
    #
    # @example
    #   Faker::TvShows::TheITCrowd.character #=> "Roy Trenneman"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_it_crowd.rb#31
    def character; end

    # Produces an email from The IT Crowd.
    #
    # @example
    #   Faker::TvShows::TheITCrowd.email #=> "roy.trenneman@reynholm.test"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_it_crowd.rb#44
    def email; end

    # Produces a quote from The IT Crowd.
    #
    # @example
    #   Faker::TvShows::TheITCrowd.quote
    #   #=> "Hello, IT. Have you tried turning it off and on again?"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_it_crowd.rb#58
    def quote; end
  end
end

class Faker::TvShows::TheOffice < ::Faker::Base
  class << self
    # Produces a character from The Office.
    #
    # @example
    #   Faker::TvShows::TheOffice.character #=> "Michael Scott"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_office.rb#18
    def character; end

    # Produces a quote from The Office.
    #
    # @example
    #   Faker::TvShows::TheOffice.quote #=> "Identity theft is not a joke, Jim! Millions of families suffer every year."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_office.rb#31
    def quote; end
  end
end

class Faker::TvShows::TheThickOfIt < ::Faker::Base
  class << self
    # Produces a character from The Thick of It.
    #
    # @example
    #   Faker::TvShows::TheThickOfIt.character #=> "Nicola Murray"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_thick_of_it.rb#18
    def character; end

    # Produces a department from The Thick of It.
    #
    # @example
    #   Faker::TvShows::TheThickOfIt.department #=> "Shadow Cabinet"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_thick_of_it.rb#31
    def department; end

    # Produces a position from The Thick of It.
    #
    # @example
    #   Faker::TvShows::TheThickOfIt.position
    #   #=> "Director of Communications"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/the_thick_of_it.rb#45
    def position; end
  end
end

class Faker::TvShows::TwinPeaks < ::Faker::Base
  class << self
    # Produces a character from Twin Peaks.
    #
    # @example
    #   Faker::TvShows::TwinPeaks.character #=> "Dale Cooper"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/twin_peaks.rb#18
    def character; end

    # Produces a location from Twin Peaks.
    #
    # @example
    #   Faker::TvShows::TwinPeaks.location #=> "Black Lodge"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/twin_peaks.rb#31
    def location; end

    # Produces a quote from Twin Peaks.
    #
    # @example
    #   Faker::TvShows::TwinPeaks.quote
    #   #=> "The owls are not what they seem."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/twin_peaks.rb#45
    def quote; end
  end
end

class Faker::TvShows::VentureBros < ::Faker::Base
  class << self
    # Produces a character from The Venture Bros.
    #
    # @example
    #   Faker::TvShows::VentureBros.character #=> "Scaramantula"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/venture_bros.rb#18
    def character; end

    # Produces an organization from The Venture Bros.
    #
    # @example
    #   Faker::TvShows::VentureBros.organization
    #   #=> "Guild of Calamitous Intent"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/venture_bros.rb#32
    def organization; end

    # Produces a quote from The Venture Bros.
    #
    # @example
    #   Faker::TvShows::VentureBros.quote
    #   #=> "Revenge, like gazpacho soup, is best served cold, precise, and merciless."
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/venture_bros.rb#59
    def quote; end

    # Produces a vehicle from The Venture Bros.
    #
    # @example
    #   Faker::TvShows::VentureBros.vehicle #=> "Monarchmobile"
    # @return [String]
    #
    # source://faker//lib/faker/tv_shows/venture_bros.rb#45
    def vehicle; end
  end
end

class Faker::Twitter < ::Faker::Base
  class << self
    # Produces a random screen name.
    #
    # @example
    #   Faker::Twitter.screen_name #=> "audreanne_hackett"
    # @return [String]
    #
    # source://faker//lib/faker/default/twitter.rb#125
    def screen_name; end

    # Produces a random Twitter user.
    #
    # @example
    #   Faker::Twitter.status #=> {:id=>8821452687517076614, :text=>"Ea et laboriosam vel non."...
    #   Faker::Twitter.status(include_user: false) # Just get a status object with no embed user
    #   Faker::Twitter.status(include_photo: true) # Includes entities for an attached image
    # @param include_user [Boolean] Include or exclude user details
    # @param include_photo [Boolean] Include or exclude user photo
    # @return [Hash]
    #
    # source://faker//lib/faker/default/twitter.rb#83
    def status(include_user: T.unsafe(nil), include_photo: T.unsafe(nil)); end

    # Produces a random Twitter user.
    #
    # @example
    #   Faker::Twitter.user #=>  {:id=>8821452687517076614, :name=>"Lincoln Paucek", :screen_name=>"cody"...
    #   Faker::Twitter.user(include_status: false) # Just get a user object with no embed status
    #   Faker::Twitter.user(include_email: true) # Simulate an authenticated user with the email permission
    # @param include_status [Boolean] Include or exclude user status details
    # @param include_email [Boolean] Include or exclude user email details
    # @return [Hash]
    #
    # source://faker//lib/faker/default/twitter.rb#19
    def user(include_status: T.unsafe(nil), include_email: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/twitter.rb#135
    def created_at; end

    # source://faker//lib/faker/default/twitter.rb#131
    def id; end

    # source://faker//lib/faker/default/twitter.rb#165
    def photo_entity; end

    # source://faker//lib/faker/default/twitter.rb#154
    def status_entities(include_photo: T.unsafe(nil)); end

    # source://faker//lib/faker/default/twitter.rb#143
    def user_entities; end

    # source://faker//lib/faker/default/twitter.rb#139
    def utc_offset; end
  end
end

class Faker::Types < ::Faker::Base
  class << self
    # Produces a random character from the a-z, 0-9 ranges.
    #
    # @example
    #   Faker::Types.character #=> "n"
    # @return [String]
    #
    # source://faker//lib/faker/default/types.rb#37
    def character; end

    # Produces a random complex hash with random keys and values where the values may include other hashes and arrays.
    #
    # @example
    #   Faker::Types.complex_rb_hash #=> {user: {first: "bob", last: "marley"}}
    #   Faker::Types.complex_rb_hash(number: 1) #=> {user: {first: "bob", last: "marley"}}
    #   Faker::Types.complex_rb_hash(number: 2) #=> {user: {first: "bob", last: "marley"}, son: ["damien", "marley"]}
    # @param number [Integer] Specifies the number of key-value pairs.
    # @return [Hash]
    #
    # source://faker//lib/faker/default/types.rb#87
    def complex_rb_hash(number: T.unsafe(nil)); end

    # Produces a random complex type that's either a String, an Integer, an array or a hash.
    #
    # @example
    #   Faker::Types.random_complex_type #=> 1 or "a" or "bob" or {foo: "bar"}
    # @return [String, Integer]
    #
    # source://faker//lib/faker/default/types.rb#138
    def random_complex_type; end

    # Produces a random type that's either a String or an Integer.
    #
    # @example
    #   Faker::Types.random_type #=> 1 or "a" or "bob"
    # @return [String, Integer]
    #
    # source://faker//lib/faker/default/types.rb#119
    def random_type; end

    # Produces a random array.
    #
    # @example
    #   Faker::Types.rb_array #=> ["a"]
    #   Faker::Types.rb_array(len: 4) #=> ["a", 1, 2, "bob"]
    # @param len [Integer] Specifies the number of elements in the array.
    # @return [Array]
    #
    # source://faker//lib/faker/default/types.rb#102
    def rb_array(len: T.unsafe(nil)); end

    # Produces a random hash with random keys and values.
    #
    # @example
    #   Faker::Types.rb_hash #=> {name: "bob"}
    #   Faker::Types.rb_hash(number: 1) #=> {name: "bob"}
    #   Faker::Types.rb_hash(number: 2) #=> {name: "bob", last: "marley"}
    # @param number [Integer] Specifies the number of key-value pairs.
    # @return [Hash]
    #
    # source://faker//lib/faker/default/types.rb#66
    def rb_hash(number: T.unsafe(nil), type: T.unsafe(nil)); end

    # Produces a random integer.
    #
    # @example
    #   Faker::Types.rb_integer #=> 1
    # @return [Integer]
    #
    # source://faker//lib/faker/default/types.rb#50
    def rb_integer(from: T.unsafe(nil), to: T.unsafe(nil)); end

    # Produces a random String created from word (Faker::Lorem.word)
    #
    # @example
    #   Faker::Types.rb_string #=> "foobar"
    # @return [String]
    #
    # source://faker//lib/faker/default/types.rb#19
    def rb_string(words: T.unsafe(nil)); end

    private

    # source://faker//lib/faker/default/types.rb#155
    def titleize(word); end
  end
end

# source://faker//lib/faker/default/types.rb#5
Faker::Types::CHARACTERS = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/types.rb#7
Faker::Types::COMPLEX_TYPES = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/types.rb#6
Faker::Types::SIMPLE_TYPES = T.let(T.unsafe(nil), Array)

class Faker::UniqueGenerator
  # @return [UniqueGenerator] a new instance of UniqueGenerator
  #
  # source://faker//lib/helpers/unique_generator.rb#5
  def initialize(generator, max_retries); end

  # source://faker//lib/helpers/unique_generator.rb#40
  def clear; end

  # source://faker//lib/helpers/unique_generator.rb#53
  def exclude(name, arguments, values); end

  # @raise [RetryLimitExceeded]
  #
  # source://faker//lib/helpers/unique_generator.rb#10
  def method_missing(name, *arguments, **_arg2); end

  # source://faker//lib/helpers/unique_generator.rb#35
  def previous_results; end

  private

  # @return [Boolean]
  #
  # source://faker//lib/helpers/unique_generator.rb#29
  def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end

  class << self
    # source://faker//lib/helpers/unique_generator.rb#48
    def clear; end

    # source://faker//lib/helpers/unique_generator.rb#44
    def marked_unique; end
  end
end

class Faker::UniqueGenerator::RetryLimitExceeded < ::StandardError; end

class Faker::University < ::Faker::Base
  class << self
    # Produces a greek alphabet.
    #
    # @example
    #   Faker::University.greek_alphabet #=> ["Α", "B", "Γ", "Δ", ...]
    # @return [Array]
    #
    # source://faker//lib/faker/default/university.rb#69
    def greek_alphabet; end

    # Produces a random greek organization.
    #
    # @example
    #   Faker::University.greek_organization #=> "BEX"
    # @return [String]
    #
    # source://faker//lib/faker/default/university.rb#56
    def greek_organization; end

    # Produces a random university name.
    #
    # @example
    #   Faker::University.name #=> "Eastern Mississippi Academy"
    # @return [String]
    #
    # source://faker//lib/faker/default/university.rb#17
    def name; end

    # Produces a random university prefix.
    #
    # @example
    #   Faker::University.prefix #=> "Western"
    # @return [String]
    #
    # source://faker//lib/faker/default/university.rb#30
    def prefix; end

    # Produces a random university suffix.
    #
    # @example
    #   Faker::University.suffix #=> "Academy"
    # @return [String]
    #
    # source://faker//lib/faker/default/university.rb#43
    def suffix; end
  end
end

# source://faker//lib/faker/version.rb#4
Faker::VERSION = T.let(T.unsafe(nil), String)

class Faker::Vehicle < ::Faker::Base
  class << self
    # Produces a random list of car options.
    #
    # @example
    #   Faker::Vehicle.car_options #=> ["DVD System", "MP3 (Single Disc)", "Tow Package", "CD (Multi Disc)", "Cassette Player", "Bucket Seats", "Cassette Player", "Leather Interior", "AM/FM Stereo", "Third Row Seats"]
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/vehicle.rb#196
    def car_options; end

    # Produces a random car type.
    #
    # @example
    #   Faker::Vehicle.car_type #=> "Sedan"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#167
    def car_type; end

    # Produces a random vehicle color.
    #
    # @example
    #   Faker::Vehicle.color #=> "Red"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#115
    def color; end

    # Produces a random vehicle door count.
    #
    # @example
    #   Faker::Vehicle.doors #=> 1
    #   Faker::Vehicle.door_count #=> 3
    # @return [Integer]
    #
    # source://faker//lib/faker/default/vehicle.rb#223
    def door_count; end

    # Produces a random vehicle door count.
    #
    # @example
    #   Faker::Vehicle.doors #=> 1
    #   Faker::Vehicle.door_count #=> 3
    # @return [Integer]
    #
    # source://faker//lib/faker/default/vehicle.rb#223
    def doors; end

    # Produces a random vehicle drive type.
    #
    # @example
    #   Faker::Vehicle.drive_type #=> "4x2/2-wheel drive"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#141
    def drive_type; end

    # Produces a random engine cylinder count.
    #
    # @example
    #   Faker::Vehicle.engine_size #=> 6
    #   Faker::Vehicle.engine #=> 4
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#181
    def engine; end

    # Produces a random engine cylinder count.
    #
    # @example
    #   Faker::Vehicle.engine_size #=> 6
    #   Faker::Vehicle.engine #=> 4
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#181
    def engine_size; end

    # Produces a random vehicle fuel type.
    #
    # @example
    #   Faker::Vehicle.fuel_type #=> "Diesel"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#154
    def fuel_type; end

    # Produces a random mileage/kilometrage for a vehicle.
    #
    # @example
    #   Faker::Vehicle.mileage #=> 26961
    #   Faker::Vehicle.mileage(min: 50_000) #=> 81557
    #   Faker::Vehicle.mileage(min: 50_000, max: 250_000) #=> 117503
    #   Faker::Vehicle.kilometrage #=> 35378
    # @param min [Integer] Specific minimum limit for mileage generation.
    # @param max [Integer] Specific maximum limit for mileage generation.
    # @return [Integer]
    #
    # source://faker//lib/faker/default/vehicle.rb#255
    def kilometrage(min: T.unsafe(nil), max: T.unsafe(nil)); end

    # source://faker//lib/faker/default/vehicle.rb#272
    def license_plate(state_abbreviation: T.unsafe(nil)); end

    # Produces a random vehicle make.
    #
    # @example
    #   Faker::Vehicle.make #=> "Honda"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#57
    def make; end

    # Produces a random vehicle make and model.
    #
    # @example
    #   Faker::Vehicle.make_and_model #=> "Dodge Charger"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#87
    def make_and_model; end

    # Produces a random vehicle manufacturer.
    #
    # @example
    #   Faker::Vehicle.manufacture #=> "Lamborghini"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#44
    def manufacture; end

    # Produces a random mileage/kilometrage for a vehicle.
    #
    # @example
    #   Faker::Vehicle.mileage #=> 26961
    #   Faker::Vehicle.mileage(min: 50_000) #=> 81557
    #   Faker::Vehicle.mileage(min: 50_000, max: 250_000) #=> 117503
    #   Faker::Vehicle.kilometrage #=> 35378
    # @param min [Integer] Specific minimum limit for mileage generation.
    # @param max [Integer] Specific maximum limit for mileage generation.
    # @return [Integer]
    #
    # source://faker//lib/faker/default/vehicle.rb#255
    def mileage(min: T.unsafe(nil), max: T.unsafe(nil)); end

    # Produces a random vehicle model.
    #
    # @example
    #   Faker::Vehicle.model #=> "A8"
    #   Faker::Vehicle.model(make_of_model: 'Toyota') #=> "Prius"
    # @param make_of_model [String] Specific valid vehicle make.
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#72
    def model(make_of_model: T.unsafe(nil)); end

    # source://faker//lib/faker/default/vehicle.rb#288
    def singapore_license_plate; end

    # Produces a random list of standard specs.
    #
    # @example
    #   Faker::Vehicle.standard_specs #=> ["Full-size spare tire w/aluminum alloy wheel", "Back-up camera", "Carpeted cargo area", "Silver accent IP trim finisher -inc: silver shifter finisher", "Back-up camera", "Water-repellent windshield & front door glass", "Floor carpeting"]
    # @return [Array<String>]
    #
    # source://faker//lib/faker/default/vehicle.rb#209
    def standard_specs; end

    # Produces a random vehicle style.
    #
    # @example
    #   Faker::Vehicle.style #=> "ESi"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#102
    def style; end

    # Produces a random vehicle transmission.
    #
    # @example
    #   Faker::Vehicle.transmission #=> "Automanual"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#128
    def transmission; end

    # Produces a car version
    #
    # @example
    #   Faker::Vehicle.version #=> "40 TFSI Premium"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#303
    def version; end

    # Produces a random vehicle VIN number.
    #
    # @example
    #   Faker::Vehicle.vin #=> "LLDWXZLG77VK2LUUF"
    # @return [String]
    #
    # source://faker//lib/faker/default/vehicle.rb#25
    def vin; end

    # Produces a random car year between 1 and 15 years ago.
    #
    # @example
    #   Faker::Vehicle.year #=> 2008
    # @return [Integer]
    #
    # source://faker//lib/faker/default/vehicle.rb#237
    def year; end

    private

    # source://faker//lib/faker/default/vehicle.rb#309
    def singapore_checksum(plate_number); end
  end
end

# source://faker//lib/faker/default/vehicle.rb#8
Faker::Vehicle::MILEAGE_MAX = T.let(T.unsafe(nil), Integer)

# source://faker//lib/faker/default/vehicle.rb#7
Faker::Vehicle::MILEAGE_MIN = T.let(T.unsafe(nil), Integer)

# source://faker//lib/faker/default/vehicle.rb#14
Faker::Vehicle::SG_CHECKSUM_CHARS = T.let(T.unsafe(nil), String)

# source://faker//lib/faker/default/vehicle.rb#13
Faker::Vehicle::SG_CHECKSUM_WEIGHTS = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/vehicle.rb#9
Faker::Vehicle::VIN_KEYSPACE = T.let(T.unsafe(nil), Array)

# source://faker//lib/faker/default/vehicle.rb#12
Faker::Vehicle::VIN_REGEX = T.let(T.unsafe(nil), Regexp)

# source://faker//lib/faker/default/vehicle.rb#10
Faker::Vehicle::VIN_TRANSLITERATION = T.let(T.unsafe(nil), Hash)

# source://faker//lib/faker/default/vehicle.rb#11
Faker::Vehicle::VIN_WEIGHT = T.let(T.unsafe(nil), Array)

class Faker::Verb < ::Faker::Base
  class << self
    # Produces the base form of a random verb.
    #
    # @example
    #   Faker::Verb.base #=> "hurt"
    # @return [String]
    #
    # source://faker//lib/faker/default/verb.rb#15
    def base; end

    # Produces a random verb in the .ing form.
    #
    # @example
    #   Faker::Verb.ing_form #=> "causing"
    # @return [String]
    #
    # source://faker//lib/faker/default/verb.rb#67
    def ing_form; end

    # Produces a random verb in past tense.
    #
    # @example
    #   Faker::Verb.past #=> "completed"
    # @return [String]
    #
    # source://faker//lib/faker/default/verb.rb#28
    def past; end

    # Produces a random verb in past participle.
    #
    # @example
    #   Faker::Verb.past_participle #=> "digested"
    # @return [String]
    #
    # source://faker//lib/faker/default/verb.rb#41
    def past_participle; end

    # Produces a random verb in simple present.
    #
    # @example
    #   Faker::Verb.simple_present #=> "climbs"
    # @return [String]
    #
    # source://faker//lib/faker/default/verb.rb#54
    def simple_present; end
  end
end

class Faker::VulnerabilityIdentifier < ::Faker::Base
  class << self
    # Produces a Common Vulnerabilities and Exposures (CVE) identifier.
    #
    # @example
    #   Faker::VulnerabilityIdentifier.cve #=> "CVE-2021-1337"
    #   Faker::VulnerabilityIdentifier.cve(year: 1999) #=> "CVE-1999-0523"
    # @param year [Integer] The year-part of the CVE identifier (defaults to the current year)
    # @return [String]
    #
    # source://faker//lib/faker/default/vulnerability_identifier.rb#17
    def cve(year: T.unsafe(nil)); end
  end
end

class Faker::WorldCup < ::Faker::Base
  class << self
    # Produces a city name hosting the World Cup match.
    #
    # @example
    #   Faker::WorldCup.city #=> "Moscow"
    # @return [String]
    #
    # source://faker//lib/faker/default/world_cup.rb#28
    def city; end

    # Produces a random national team name from a group.
    #
    # @example
    #   Faker::WorldCup.group(group: 'group_B') #=> "Spain"
    # @example
    #   Faker::WorldCup.group #=> "Russia"
    # @return [String]
    #
    # source://faker//lib/faker/default/world_cup.rb#56
    def group(group: T.unsafe(nil)); end

    # Produces a random name from national team roster.
    #
    # @example
    #   Faker::WorldCup.roster #=> "Hector Cuper"
    # @example
    #   Faker::WorldCup.roster(country: 'Spain', type: 'forwards') #=> "Diego Costa"
    # @return [String]
    #
    # source://faker//lib/faker/default/world_cup.rb#72
    def roster(country: T.unsafe(nil), type: T.unsafe(nil)); end

    # Produces the name of a stadium that has hosted a World Cup match.
    #
    # @example
    #   Faker::WorldCup.stadium #=> "Rostov Arena"
    # @return [String]
    #
    # source://faker//lib/faker/default/world_cup.rb#41
    def stadium; end

    # Produces a national team name.
    #
    # @example
    #   Faker::WorldCup.team #=> "Iran"
    # @return [String]
    #
    # source://faker//lib/faker/default/world_cup.rb#15
    def team; end
  end
end
