# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `dry-container` gem.
# Please instead update this file by running `bin/tapioca gem dry-container`.

# Inversion of Control (IoC) container
#
# @api public
# @example
#
#   container = Dry::Container.new
#   container.register(:item, 'item')
#   container.resolve(:item)
#   => 'item'
#
#   container.register(:item1, -> { 'item' })
#   container.resolve(:item1)
#   => 'item'
#
#   container.register(:item2, -> { 'item' }, call: false)
#   container.resolve(:item2)
#   => #<Proc:0x007f33b169e998@(irb):10 (lambda)>
class Dry::Container
  include ::Dry::Container::Mixin::Initializer
  include ::Dry::Container::Mixin
  extend ::Dry::Container::Configuration

  # source://dry-container//lib/dry/container/mixin.rb#126
  def config; end
end

# @api public
class Dry::Container::Config
  # @api private
  # @return [Config] a new instance of Config
  #
  # source://dry-container//lib/dry/container/mixin.rb#23
  def initialize(namespace_separator: T.unsafe(nil), resolver: T.unsafe(nil), registry: T.unsafe(nil)); end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#14
  def namespace_separator; end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#14
  def namespace_separator=(_arg0); end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#20
  def registry; end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#20
  def registry=(_arg0); end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#17
  def resolver; end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#17
  def resolver=(_arg0); end
end

# @api public
#
# source://dry-container//lib/dry/container/mixin.rb#9
Dry::Container::Config::DEFAULT_NAMESPACE_SEPARATOR = T.let(T.unsafe(nil), String)

# @api public
#
# source://dry-container//lib/dry/container/mixin.rb#11
Dry::Container::Config::DEFAULT_REGISTRY = T.let(T.unsafe(nil), Dry::Container::Registry)

# @api public
#
# source://dry-container//lib/dry/container/mixin.rb#10
Dry::Container::Config::DEFAULT_RESOLVER = T.let(T.unsafe(nil), Dry::Container::Resolver)

# @api public
module Dry::Container::Configuration
  # source://dry-container//lib/dry/container/mixin.rb#53
  def config; end

  # @api private
  # @yield [config]
  #
  # source://dry-container//lib/dry/container/mixin.rb#59
  def configure; end
end

# source://dry-container//lib/dry/container/mixin.rb#68
Dry::Container::EMPTY_HASH = T.let(T.unsafe(nil), Hash)

# @api public
class Dry::Container::Error < ::StandardError; end

# Base class to abstract Memoizable and Callable implementations
#
# @api abstract
class Dry::Container::Item
  # @api abstract
  # @return [Item] a new instance of Item
  #
  # source://dry-container//lib/dry/container/item.rb#17
  def initialize(item, options = T.unsafe(nil)); end

  # @api abstract
  # @raise [NotImplementedError]
  #
  # source://dry-container//lib/dry/container/item.rb#25
  def call; end

  # @api abstract
  # @private
  # @return [Boolean]
  #
  # source://dry-container//lib/dry/container/item.rb#35
  def callable?; end

  # @api abstract
  # @return [Mixed] the item to be solved later
  #
  # source://dry-container//lib/dry/container/item.rb#11
  def item; end

  # Build a new item with transformation applied
  #
  # @api abstract
  # @private
  #
  # source://dry-container//lib/dry/container/item.rb#42
  def map(func); end

  # @api abstract
  # @return [Hash] the options to memoize, call or no.
  #
  # source://dry-container//lib/dry/container/item.rb#14
  def options; end

  # @api abstract
  # @private
  # @return [Boolean]
  #
  # source://dry-container//lib/dry/container/item.rb#30
  def value?; end
end

# Callable class to returns a item call
#
# @api public
class Dry::Container::Item::Callable < ::Dry::Container::Item
  # Returns the result of item call or item
  #
  # @api public
  # @return [Mixed]
  #
  # source://dry-container//lib/dry/container/item/callable.rb#16
  def call; end
end

# Factory for create an Item to register inside of container
#
# @api public
class Dry::Container::Item::Factory
  # Creates an Item Memoizable or Callable
  #
  # @api public
  # @param item [Mixed]
  # @param options [Hash]
  # @raise [Dry::Container::Error]
  # @return [Dry::Container::Item::Base]
  #
  # source://dry-container//lib/dry/container/item/factory.rb#20
  def call(item, options = T.unsafe(nil)); end
end

# Memoizable class to store and execute item calls
#
# @api public
class Dry::Container::Item::Memoizable < ::Dry::Container::Item
  # Returns a new Memoizable instance
  #
  # @api public
  # @param item [Mixed]
  # @param options [Hash]
  # @raise [Dry::Container::Error]
  # @return [Dry::Container::Item::Base]
  #
  # source://dry-container//lib/dry/container/item/memoizable.rb#24
  def initialize(item, options = T.unsafe(nil)); end

  # Returns the result of item call using a syncronized mutex
  #
  # @api public
  # @return [Dry::Container::Item::Base]
  #
  # source://dry-container//lib/dry/container/item/memoizable.rb#34
  def call; end

  # @api public
  # @return [Mutex] the stored mutex
  #
  # source://dry-container//lib/dry/container/item/memoizable.rb#14
  def memoize_mutex; end

  private

  # @api public
  # @private
  # @raise [::Dry::Container::Error]
  #
  # source://dry-container//lib/dry/container/item/memoizable.rb#43
  def raise_not_supported_error; end
end

class Dry::Container::KeyError < ::KeyError; end

# Mixin to expose Inversion of Control (IoC) container behaviour
#
#
# @api public
# @example
#
#   class MyClass
#   extend Dry::Container::Mixin
#   end
#
#   MyClass.register(:item, 'item')
#   MyClass.resolve(:item)
#   => 'item'
#
#   class MyObject
#   include Dry::Container::Mixin
#   end
#
#   container = MyObject.new
#   container.register(:item, 'item')
#   container.resolve(:item)
#   => 'item'
module Dry::Container::Mixin
  mixes_in_class_methods ::Dry::Container::Configuration

  # Resolve an item from the container
  #
  # @api public
  # @param key [Mixed] The key for the item you wish to resolve
  # @return [Mixed]
  # @see Dry::Container::Mixin#resolve
  #
  # source://dry-container//lib/dry/container/mixin.rb#187
  def [](key); end

  # @api public
  # @private no, really
  #
  # source://dry-container//lib/dry/container/mixin.rb#331
  def _container; end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#343
  def clone; end

  # Decorates an item from the container with specified decorator
  #
  # @api public
  # @return [Dry::Container::Mixin] self
  #
  # source://dry-container//lib/dry/container/mixin.rb#270
  def decorate(key, with: T.unsafe(nil), &block); end

  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#336
  def dup; end

  # Calls block once for each key/value pair in the container, passing the key and
  # the registered item parameters.
  #
  # If no block is given, an enumerator is returned instead.
  #
  # @api public
  # @note In discussions with other developers, it was felt that being able to iterate
  #   over not just the registered keys, but to see what was registered would be
  #   very helpful. This is a step toward doing that.
  # @return [Enumerator]
  #
  # source://dry-container//lib/dry/container/mixin.rb#261
  def each(&block); end

  # Calls block once for each key in container, passing the key as a parameter.
  #
  # If no block is given, an enumerator is returned instead.
  #
  # @api public
  # @return [Dry::Container::Mixin] self
  #
  # source://dry-container//lib/dry/container/mixin.rb#244
  def each_key(&block); end

  # Freeze the container. Nothing can be registered after freezing
  #
  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#324
  def freeze; end

  # Import a namespace
  #
  # @api public
  # @param namespace [Dry::Container::Namespace] The namespace to import
  # @return [Dry::Container::Mixin] self
  #
  # source://dry-container//lib/dry/container/mixin.rb#315
  def import(namespace); end

  # Check whether an item is registered under the given key
  #
  # @api public
  # @param key [Mixed] The key you wish to check for registration with
  # @return [Bool]
  #
  # source://dry-container//lib/dry/container/mixin.rb#224
  def key?(key); end

  # An array of registered names for the container
  #
  # @api public
  # @return [Array<String>]
  #
  # source://dry-container//lib/dry/container/mixin.rb#233
  def keys; end

  # Merge in the items of the other container
  #
  # @api public
  # @param other [Dry::Container] The other container to merge in
  # @param namespace [Symbol, nil] Namespace to prefix other container items with, defaults to nil
  # @return [Dry::Container::Mixin] self
  #
  # source://dry-container//lib/dry/container/mixin.rb#201
  def merge(other, namespace: T.unsafe(nil), &block); end

  # Evaluate block and register items in namespace
  #
  # @api public
  # @param namespace [Mixed] The namespace to register items in
  # @return [Dry::Container::Mixin] self
  #
  # source://dry-container//lib/dry/container/mixin.rb#296
  def namespace(namespace, &block); end

  # Register an item with the container to be resolved later
  #
  # @api public
  # @param key [Mixed] The key to register the container item with (used to resolve)
  # @param contents [Mixed] The item to register with the container (if no block given)
  # @param options [Hash] Options to pass to the registry when registering the item
  # @return [Dry::Container::Mixin] self
  # @yield If a block is given, contents will be ignored and the block
  #   will be registered instead
  #
  # source://dry-container//lib/dry/container/mixin.rb#147
  def register(key, contents = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Resolve an item from the container
  #
  # @api public
  # @param key [Mixed] The key for the item you wish to resolve
  # @return [Mixed]
  # @yield Fallback block to call when a key is missing. Its result will be returned
  # @yieldparam key [Mixed] Missing key
  #
  # source://dry-container//lib/dry/container/mixin.rb#174
  def resolve(key, &block); end

  class << self
    # @api public
    # @private
    # @private
    #
    # source://dry-container//lib/dry/container/mixin.rb#96
    def extended(base); end

    # @api public
    # @private
    # @private
    #
    # source://dry-container//lib/dry/container/mixin.rb#121
    def included(base); end
  end
end

# @api public
# @private
module Dry::Container::Mixin::Initializer
  # @api public
  #
  # source://dry-container//lib/dry/container/mixin.rb#114
  def initialize(*args, &block); end
end

# Create a namespace to be imported
#
# @api public
# @example
#
#   ns = Dry::Container::Namespace.new('name') do
#   register('item', 'item')
#   end
#
#   container = Dry::Container.new
#
#   container.import(ns)
#
#   container.resolve('name.item')
#   => 'item'
class Dry::Container::Namespace
  # Create a new namespace
  #
  # @api public
  # @param name [Mixed] The name of the namespace
  # @return [Dry::Container::Namespace]
  # @yield The block to evaluate when the namespace is imported
  #
  # source://dry-container//lib/dry/container/namespace.rb#38
  def initialize(name, &block); end

  # @api public
  # @return [Proc] The block to be executed when the namespace is imported
  #
  # source://dry-container//lib/dry/container/namespace.rb#26
  def block; end

  # @api public
  # @return [Mixed] The namespace (name)
  #
  # source://dry-container//lib/dry/container/namespace.rb#24
  def name; end
end

# @api private
class Dry::Container::NamespaceDSL < ::SimpleDelegator
  # DSL for defining namespaces
  #
  # @api private
  # @param container [Dry::Container::Mixin] The container
  # @param namespace [String] The namespace (name)
  # @param namespace_separator [String] The namespace separator
  # @return [Mixed]
  # @yield The block to evaluate to define the namespace
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#23
  def initialize(container, namespace, namespace_separator, &block); end

  # @api private
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#44
  def import(namespace); end

  # @api private
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#40
  def namespace(namespace, &block); end

  # @api private
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#36
  def register(key, *args, &block); end

  # @api private
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#50
  def resolve(key); end

  private

  # @api private
  #
  # source://dry-container//lib/dry/container/namespace_dsl.rb#56
  def namespaced(key); end
end

# source://dry-container//lib/dry/container/mixin.rb#64
Dry::Container::PREFIX_NAMESPACE = T.let(T.unsafe(nil), Proc)

# Default registry for registering items with the container
#
# @api public
class Dry::Container::Registry
  # @api public
  # @private
  # @return [Registry] a new instance of Registry
  #
  # source://dry-container//lib/dry/container/registry.rb#12
  def initialize; end

  # Register an item with the container to be resolved later
  #
  # @api public
  # @option options
  # @param container [Concurrent::Hash] The container
  # @param key [Mixed] The key to register the container item with (used to resolve)
  # @param item [Mixed] The item to register with the container
  # @param options [Hash]
  # @raise [Dry::Container::Error] If an item is already registered with the given key
  # @return [Mixed]
  #
  # source://dry-container//lib/dry/container/registry.rb#34
  def call(container, key, item, options); end

  # @api public
  #
  # source://dry-container//lib/dry/container/registry.rb#45
  def factory; end
end

# Default resolver for resolving items from container
#
# @api public
class Dry::Container::Resolver
  # Resolve an item from the container
  #
  # @api public
  # @param container [Concurrent::Hash] The container
  # @param key [Mixed] The key for the item you wish to resolve
  # @raise [KeyError] If the given key is not registered with the container (and no block provided)
  # @return [Mixed]
  # @yield Fallback block to call when a key is missing. Its result will be returned
  # @yieldparam key [Mixed] Missing key
  #
  # source://dry-container//lib/dry/container/resolver.rb#26
  def call(container, key); end

  # Calls block once for each key in container, passing the key and
  # the registered item parameters.
  #
  # If no block is given, an enumerator is returned instead.
  #
  # @api public
  # @note In discussions with other developers, it was felt that being able
  #   to iterate over not just the registered keys, but to see what was
  #   registered would be very helpful. This is a step toward doing that.
  # @return Key, Value
  #
  # source://dry-container//lib/dry/container/resolver.rb#83
  def each(container, &block); end

  # Calls block once for each key in container, passing the key as a parameter.
  #
  # If no block is given, an enumerator is returned instead.
  #
  # @api public
  # @return Hash
  #
  # source://dry-container//lib/dry/container/resolver.rb#68
  def each_key(container, &block); end

  # Check whether an items is registered under the given key
  #
  # @api public
  # @param container [Concurrent::Hash] The container
  # @param key [Mixed] The key you wish to check for registration with
  # @return [Bool]
  #
  # source://dry-container//lib/dry/container/resolver.rb#48
  def key?(container, key); end

  # An array of registered names for the container
  #
  # @api public
  # @return [Array]
  #
  # source://dry-container//lib/dry/container/resolver.rb#57
  def keys(container); end
end

# @api public
#
# source://dry-container//lib/dry/container/version.rb#6
Dry::Container::VERSION = T.let(T.unsafe(nil), String)
