# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `derailed_benchmarks` gem.
# Please instead update this file by running `bin/tapioca gem derailed_benchmarks`.

# Tree structure used to store and sort require memory costs
# RequireTree.new('get_process_mem')
module DerailedBenchmarks
  class << self
    # source://derailed_benchmarks//lib/derailed_benchmarks.rb#34
    def add_auth(app); end

    # Returns the value of attribute auth.
    #
    # source://derailed_benchmarks//lib/derailed_benchmarks.rb#16
    def auth; end

    # Sets the attribute auth
    #
    # @param value the value to set the attribute auth to.
    #
    # source://derailed_benchmarks//lib/derailed_benchmarks.rb#16
    def auth=(_arg0); end

    # @return [Boolean]
    #
    # source://derailed_benchmarks//lib/derailed_benchmarks.rb#10
    def gem_is_bundled?(name); end

    # source://derailed_benchmarks//lib/derailed_benchmarks.rb#19
    def rails_path_on_disk; end
  end
end

# Base helper class. Can be used to authenticate different strategies
# The root app will be wrapped by an authentication action
class DerailedBenchmarks::AuthHelper
  # Returns self and sets the target app
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helper.rb#25
  def add_app(app); end

  # Returns the value of attribute app.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helper.rb#9
  def app; end

  # Gets called for every request. Place all auth logic here.
  # Return value is expected to be an valid Rack response array.
  # If you do not manually `app.call(env)` here, the client app
  # will never be called.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helper.rb#20
  def call(env); end

  # Put any coded needed to set up or initialize your authentication module here
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helper.rb#12
  def setup; end
end

class DerailedBenchmarks::AuthHelpers; end

# Devise helper for authenticating requests
# Setup adds necessarry test methods, user provides a sample user.
# The authenticate method is called on every request when authentication is enabled
class DerailedBenchmarks::AuthHelpers::Devise < ::DerailedBenchmarks::AuthHelper
  # Logs the user in, then call the parent app
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helpers/devise.rb#34
  def call(env); end

  # Include devise test helpers and turn on test mode
  # We need to do this on the class level
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helpers/devise.rb#13
  def setup; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helpers/devise.rb#23
  def user; end

  # Sets the attribute user
  #
  # @param value the value to set the attribute user to.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/auth_helpers/devise.rb#9
  def user=(_arg0); end
end

class DerailedBenchmarks::Git; end

class DerailedBenchmarks::Git::Commit
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#12
  def initialize(path:, ref:, log_dir: T.unsafe(nil)); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#28
  def checkout!; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def desc; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def description; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def file; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def log; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def ref; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def short_sha; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#10
  def time; end

  private

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/commit.rb#32
  def file_safe_ref; end
end

class DerailedBenchmarks::Git::InPath
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#15
  def initialize(path); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#31
  def branch; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#36
  def checkout!(ref); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#19
  def description; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#13
  def path; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#44
  def run(cmd); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#53
  def run!(cmd); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#23
  def short_sha; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#40
  def time; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/in_path.rb#27
  def time_stamp_string; end
end

# Wraps two or more git commits in a specific location
#
# Returns an array of GitCommit objects that can be used to manipulate
# and checkout the repo
#
# Example:
#
#   `git clone https://sharpstone/default_ruby tmp/default_ruby`
#
#   project = GitSwitchProject.new(path: "tmp/default_ruby")
#
# By default it will represent the last two commits:
#
#   project.commits.length # => 2
#
# You can pass in explicit REFs in an array:
#
#   ref_array = ["da748a59340be8b950e7bbbfb32077eb67d70c3c", "9b19275a592f148e2a53b87ead4ccd8c747539c9"]
#   project = GitSwitchProject.new(path: "tmp/default_ruby", ref_array: ref_array)
#
#   puts project.commits.map(&:ref) == ref_array # => true
#
#
# It knows the current branch or sha:
#
#    `cd tmp/ruby && git checkout -b mybranch`
#    project.current_branch_or_sha #=> "mybranch"
#
# It can be used for safely wrapping checkouts to ensure the project returns to it's original branch:
#
#    project.restore_branch_on_return do
#      project.commits.first.checkout!
#      project.current_branch_or_sha # => "da748a593"
#    end
#
#    project.current_branch_or_sha # => "mybranch"
class DerailedBenchmarks::Git::SwitchProject
  # @return [SwitchProject] a new instance of SwitchProject
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#48
  def initialize(path:, ref_array: T.unsafe(nil), io: T.unsafe(nil), log_dir: T.unsafe(nil)); end

  # https://stackoverflow.com/a/3879077/147390
  #
  # @return [Boolean]
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#80
  def clean?; end

  # Returns the value of attribute commits.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#46
  def commits; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#69
  def current_branch_or_sha; end

  # @return [Boolean]
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#75
  def dirty?; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#88
  def restore_branch_on_return(quiet: T.unsafe(nil)); end

  private

  # case ref_array.length
  # when >= 2
  #   returns original array
  # when 1
  #   returns the given ref plus the one before it
  # when 0
  #   returns the most recent 2 refs
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#118
  def expand_refs(ref_array); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/git/switch_project.rb#84
  def status(pattern: T.unsafe(nil)); end
end

class DerailedBenchmarks::RequireTree
  # @return [RequireTree] a new instance of RequireTree
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#13
  def initialize(name); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#28
  def <<(tree); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#34
  def [](name); end

  # Returns array of child nodes
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#39
  def children; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#43
  def cost; end

  # Sets the attribute cost
  #
  # @param value the value to set the attribute cost to.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#10
  def cost=(_arg0); end

  # Returns the value of attribute name.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#9
  def name; end

  # Returns the value of attribute parent.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#11
  def parent; end

  # Sets the attribute parent
  #
  # @param value the value to set the attribute parent to.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#11
  def parent=(_arg0); end

  # Recursively prints all child nodes
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#66
  def print_sorted_children(level = T.unsafe(nil), out = T.unsafe(nil)); end

  # Returns sorted array of child nodes from Largest to Smallest
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#48
  def sorted_children; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#52
  def to_string; end

  class << self
    # source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#19
    def reset!; end
  end
end

# source://derailed_benchmarks//lib/derailed_benchmarks/require_tree.rb#7
DerailedBenchmarks::RequireTree::REQUIRED_BY = T.let(T.unsafe(nil), Hash)

# A class for reading in benchmark results
# and converting them to numbers for comparison
#
# Example:
#
#  puts `cat muhfile.bench.txt`
#
#    9.590142   0.831269  10.457801 ( 10.0)
#    9.836019   0.837319  10.728024 ( 11.0)
#
#  x = StatsForFile.new(name: "muhcommit", file: "muhfile.bench.txt", desc: "I made it faster", time: Time.now)
#  x.values  #=> [11.437769, 11.792425]
#  x.average # => 10.5
#  x.name    # => "muhfile"
class DerailedBenchmarks::StatsForFile
  # @return [StatsForFile] a new instance of StatsForFile
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#21
  def initialize(file:, name:, time:, desc: T.unsafe(nil), short_sha: T.unsafe(nil)); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#47
  def average; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#31
  def call; end

  # Returns the value of attribute desc.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#19
  def desc; end

  # @return [Boolean]
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#39
  def empty?; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#43
  def median; end

  # Returns the value of attribute name.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#19
  def name; end

  # Returns the value of attribute short_sha.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#19
  def short_sha; end

  # Returns the value of attribute time.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#19
  def time; end

  # Returns the value of attribute values.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#19
  def values; end

  private

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_for_file.rb#51
  def load_file!; end
end

# A class used to read several benchmark files
# it will parse each file, then sort by average
# time of benchmarks. It can be used to find
# the fastest and slowest examples and give information
# about them such as what the percent difference is
# and if the results are statistically significant
#
# Example:
#
#   branch_info = {}
#   branch_info["loser"]  = { desc: "Old commit", time: Time.now, file: dir.join("loser.bench.txt"), name: "loser" }
#   branch_info["winner"] = { desc: "I am the new commit", time: Time.now + 1, file: dir.join("winner.bench.txt"), name: "winner" }
#   stats = DerailedBenchmarks::StatsFromDir.new(branch_info)
#
#   stats.newest.average  # => 10.5
#   stats.oldest.average  # => 11.0
#   stats.significant?    # => true
#   stats.x_faster        # => "1.0476"
class DerailedBenchmarks::StatsFromDir
  # @return [StatsFromDir] a new instance of StatsFromDir
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#32
  def initialize(input); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#118
  def align; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#142
  def banner(io = T.unsafe(nil)); end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#60
  def call; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#110
  def change_direction; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#94
  def d_critical; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#90
  def d_max; end

  # @return [Boolean]
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#102
  def faster?; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#122
  def histogram(io = T.unsafe(nil)); end

  # Returns the value of attribute newest.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#30
  def newest; end

  # Returns the value of attribute oldest.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#30
  def oldest; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#106
  def percent_faster; end

  # @return [Boolean]
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#86
  def significant?; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#78
  def statistical_test(series_1 = T.unsafe(nil), series_2 = T.unsafe(nil), confidence: T.unsafe(nil)); end

  # Returns the value of attribute stats.
  #
  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#30
  def stats; end

  # source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#98
  def x_faster; end
end

# source://derailed_benchmarks//lib/derailed_benchmarks/stats_from_dir.rb#29
DerailedBenchmarks::StatsFromDir::FORMAT = T.let(T.unsafe(nil), String)
