# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `dead_end` gem.
# Please instead update this file by running `bin/tapioca gem dead_end`.

module DeadEnd
  class << self
    # DeadEnd.call [Private]
    #
    # Main private interface
    #
    # source://dead_end//lib/dead_end/api.rb#66
    def call(source:, filename: T.unsafe(nil), terminal: T.unsafe(nil), record_dir: T.unsafe(nil), timeout: T.unsafe(nil), io: T.unsafe(nil)); end

    # DeadEnd.handle_error [Public]
    #
    # Takes a `SyntaxError` exception, uses the
    # error message to locate the file. Then the file
    # will be analyzed to find the location of the syntax
    # error and emit that location to stderr.
    #
    # Example:
    #
    #   begin
    #     require 'bad_file'
    #   rescue => e
    #     DeadEnd.handle_error(e)
    #   end
    #
    # By default it will re-raise the exception unless
    # `re_raise: false`. The message output location
    # can be configured using the `io: $stderr` input.
    #
    # If a valid filename cannot be determined, the original
    # exception will be re-raised (even with
    # `re_raise: false`).
    #
    # source://dead_end//lib/dead_end/api.rb#43
    def handle_error(e, re_raise: T.unsafe(nil), io: T.unsafe(nil)); end

    # DeadEnd.invalid? [Private]
    #
    # Opposite of `DeadEnd.valid?`
    #
    # @return [Boolean]
    #
    # source://dead_end//lib/dead_end/api.rb#133
    def invalid?(source); end

    # DeadEnd.record_dir [Private]
    #
    # Used to generate a unique directory to record
    # search steps for debugging
    #
    # source://dead_end//lib/dead_end/api.rb#91
    def record_dir(dir); end

    # DeadEnd.valid? [Private]
    #
    # Returns truthy if a given input source is valid syntax
    #
    #   DeadEnd.valid?(<<~EOM) # => true
    #     def foo
    #     end
    #   EOM
    #
    #   DeadEnd.valid?(<<~EOM) # => false
    #     def foo
    #       def bar # Syntax error here
    #     end
    #   EOM
    #
    # You can also pass in an array of lines and they'll be
    # joined before evaluating
    #
    #   DeadEnd.valid?(
    #     [
    #       "def foo\n",
    #       "end\n"
    #     ]
    #   ) # => true
    #
    #   DeadEnd.valid?(
    #     [
    #       "def foo\n",
    #       "  def bar\n", # Syntax error here
    #       "end\n"
    #     ]
    #   ) # => false
    #
    # As an FYI the CodeLine class instances respond to `to_s`
    # so passing a CodeLine in as an object or as an array
    # will convert it to it's code representation.
    #
    # @return [Boolean]
    #
    # source://dead_end//lib/dead_end/api.rb#176
    def valid?(source); end

    # DeadEnd.valid_without? [Private]
    #
    # This will tell you if the `code_lines` would be valid
    # if you removed the `without_lines`. In short it's a
    # way to detect if we've found the lines with syntax errors
    # in our document yet.
    #
    #   code_lines = [
    #     CodeLine.new(line: "def foo\n",   index: 0)
    #     CodeLine.new(line: "  def bar\n", index: 1)
    #     CodeLine.new(line: "end\n",       index: 2)
    #   ]
    #
    #   DeadEnd.valid_without?(
    #     without_lines: code_lines[1],
    #     code_lines: code_lines
    #   )                                    # => true
    #
    #   DeadEnd.valid?(code_lines) # => false
    #
    # @return [Boolean]
    #
    # source://dead_end//lib/dead_end/api.rb#120
    def valid_without?(without_lines:, code_lines:); end
  end
end

# This class is useful for exploring contents before and after
# a block
#
# It searches above and below the passed in block to match for
# whatever criteria you give it:
#
# Example:
#
#   def dog         # 1
#     puts "bark"   # 2
#     puts "bark"   # 3
#   end             # 4
#
#   scan = AroundBlockScan.new(
#     code_lines: code_lines
#     block: CodeBlock.new(lines: code_lines[1])
#   )
#
#   scan.scan_while { true }
#
#   puts scan.before_index # => 0
#   puts scan.after_index  # => 3
#
# Contents can also be filtered using AroundBlockScan#skip
#
# To grab the next surrounding indentation use AroundBlockScan#scan_adjacent_indent
class DeadEnd::AroundBlockScan
  # @return [AroundBlockScan] a new instance of AroundBlockScan
  #
  # source://dead_end//lib/dead_end/around_block_scan.rb#31
  def initialize(code_lines:, block:); end

  # source://dead_end//lib/dead_end/around_block_scan.rb#212
  def after_index; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#208
  def before_index; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#108
  def capture_neighbor_context; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#200
  def code_block; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#204
  def lines; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#177
  def next_down; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#173
  def next_up; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#149
  def on_falling_indent; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#181
  def scan_adjacent_indent; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#169
  def scan_neighbors; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#62
  def scan_while; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#45
  def skip(name); end

  # source://dead_end//lib/dead_end/around_block_scan.rb#192
  def start_at_next_line; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#57
  def stop_after_kw; end

  private

  # source://dead_end//lib/dead_end/around_block_scan.rb#220
  def after_lines; end

  # source://dead_end//lib/dead_end/around_block_scan.rb#216
  def before_lines; end
end

# This class is responsible for taking a code block that exists
# at a far indentaion and then iteratively increasing the block
# so that it captures everything within the same indentation block.
#
#   def dog
#     puts "bow"
#     puts "wow"
#   end
#
# block = BlockExpand.new(code_lines: code_lines)
#   .call(CodeBlock.new(lines: code_lines[1]))
#
# puts block.to_s
# # => puts "bow"
#      puts "wow"
#
#
# Once a code block has captured everything at a given indentation level
# then it will expand to capture surrounding indentation.
#
# block = BlockExpand.new(code_lines: code_lines)
#   .call(block)
#
# block.to_s
# # => def dog
#        puts "bow"
#        puts "wow"
#      end
class DeadEnd::BlockExpand
  # @return [BlockExpand] a new instance of BlockExpand
  #
  # source://dead_end//lib/dead_end/block_expand.rb#34
  def initialize(code_lines:); end

  # source://dead_end//lib/dead_end/block_expand.rb#38
  def call(block); end

  # source://dead_end//lib/dead_end/block_expand.rb#46
  def expand_indent(block); end

  # source://dead_end//lib/dead_end/block_expand.rb#54
  def expand_neighbors(block); end

  # Managable rspec errors
  #
  # source://dead_end//lib/dead_end/block_expand.rb#70
  def inspect; end
end

# Turns a "invalid block(s)" into useful context
#
# There are three main phases in the algorithm:
#
# 1. Sanitize/format input source
# 2. Search for invalid blocks
# 3. Format invalid blocks into something meaninful
#
# This class handles the third part.
#
# The algorithm is very good at capturing all of a syntax
# error in a single block in number 2, however the results
# can contain ambiguities. Humans are good at pattern matching
# and filtering and can mentally remove extraneous data, but
# they can't add extra data that's not present.
#
# In the case of known ambiguious cases, this class adds context
# back to the ambiguitiy so the programmer has full information.
#
# Beyond handling these ambiguities, it also captures surrounding
# code context information:
#
#   puts block.to_s # => "def bark"
#
#   context = CaptureCodeContext.new(
#     blocks: block,
#     code_lines: code_lines
#   )
#
#   lines = context.call.map(&:original)
#   puts lines.join
#   # =>
#     class Dog
#       def bark
#     end
class DeadEnd::CaptureCodeContext
  # @return [CaptureCodeContext] a new instance of CaptureCodeContext
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#43
  def initialize(blocks:, code_lines:); end

  # source://dead_end//lib/dead_end/capture_code_context.rb#50
  def call; end

  # Shows surrounding kw/end pairs
  #
  # The purpose of showing these extra pairs is due to cases
  # of ambiguity when only one visible line is matched.
  #
  # For example:
  #
  #     1  class Dog
  #     2    def bark
  #     4    def eat
  #     5    end
  #     6  end
  #
  # In this case either line 2 could be missing an `end` or
  # line 4 was an extra line added by mistake (it happens).
  #
  # When we detect the above problem it shows the issue
  # as only being on line 2
  #
  #     2    def bark
  #
  # Showing "neighbor" keyword pairs gives extra context:
  #
  #     2    def bark
  #     4    def eat
  #     5    end
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#116
  def capture_before_after_kws(block); end

  # Shows the context around code provided by "falling" indentation
  #
  # Converts:
  #
  #       it "foo" do
  #
  # into:
  #
  #   class OH
  #     def hello
  #       it "foo" do
  #     end
  #   end
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#80
  def capture_falling_indent(block); end

  # The logical inverse of `capture_last_end_same_indent`
  #
  # When there is an invalid block with an `end`
  # missing a keyword right after another `end`,
  # it is unclear where which end is missing the
  # keyword.
  #
  # Take this example:
  #
  #   class Dog       # 1
  #       puts "woof" # 2
  #     end           # 3
  #   end             # 4
  #
  # the problem line will be identified as:
  #
  #  ❯ end            # 4
  #
  # This happens because lines 1, 2, and 3 are technically valid code and are expanded
  # first, deemed valid, and hidden. We need to un-hide the matching keyword on
  # line 1. Also work backwards and if there's a mis-matched end, show it
  # too
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#209
  def capture_first_kw_end_same_indent(block); end

  # When there is an invalid block with a keyword
  # missing an end right before another end,
  # it is unclear where which keyword is missing the
  # end
  #
  # Take this example:
  #
  #   class Dog       # 1
  #     def bark      # 2
  #       puts "woof" # 3
  #   end             # 4
  #
  # However due to https://github.com/zombocom/dead_end/issues/32
  # the problem line will be identified as:
  #
  #  ❯ class Dog       # 1
  #
  # Because lines 2, 3, and 4 are technically valid code and are expanded
  # first, deemed valid, and hidden. We need to un-hide the matching end
  # line 4. Also work backwards and if there's a mis-matched keyword, show it
  # too
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#149
  def capture_last_end_same_indent(block); end

  # Returns the value of attribute code_lines.
  #
  # source://dead_end//lib/dead_end/capture_code_context.rb#41
  def code_lines; end
end

# Parses and sanitizes source into a lexically aware document
#
# Internally the document is represented by an array with each
# index containing a CodeLine correlating to a line from the source code.
#
# There are three main phases in the algorithm:
#
# 1. Sanitize/format input source
# 2. Search for invalid blocks
# 3. Format invalid blocks into something meaninful
#
# This class handles the first part.
#
# The reason this class exists is to format input source
# for better/easier/cleaner exploration.
#
# The CodeSearch class operates at the line level so
# we must be careful to not introduce lines that look
# valid by themselves, but when removed will trigger syntax errors
# or strange behavior.
#
# ## Join Trailing slashes
#
# Code with a trailing slash is logically treated as a single line:
#
#     1 it "code can be split" \
#     2    "across multiple lines" do
#
# In this case removing line 2 would add a syntax error. We get around
# this by internally joining the two lines into a single "line" object
#
# ## Logically Consecutive lines
#
# Code that can be broken over multiple
# lines such as method calls are on different lines:
#
#     1 User.
#     2   where(name: "schneems").
#     3   first
#
# Removing line 2 can introduce a syntax error. To fix this, all lines
# are joined into one.
#
# ## Heredocs
#
# A heredoc is an way of defining a multi-line string. They can cause many
# problems. If left as a single line, Ripper would try to parse the contents
# as ruby code rather than as a string. Even without this problem, we still
# hit an issue with indentation
#
#    1 foo = <<~HEREDOC
#    2  "Be yourself; everyone else is already taken.""
#    3    ― Oscar Wilde
#    4      puts "I look like ruby code" # but i'm still a heredoc
#    5 HEREDOC
#
# If we didn't join these lines then our algorithm would think that line 4
# is separate from the rest, has a higher indentation, then look at it first
# and remove it.
#
# If the code evaluates line 5 by itself it will think line 5 is a constant,
# remove it, and introduce a syntax errror.
#
# All of these problems are fixed by joining the whole heredoc into a single
# line.
#
# ## Comments and whitespace
#
# Comments can throw off the way the lexer tells us that the line
# logically belongs with the next line. This is valid ruby but
# results in a different lex output than before:
#
#     1 User.
#     2   where(name: "schneems").
#     3   # Comment here
#     4   first
#
# To handle this we can replace comment lines with empty lines
# and then re-lex the source. This removal and re-lexing preserves
# line index and document size, but generates an easier to work with
# document.
class DeadEnd::CleanDocument
  # @return [CleanDocument] a new instance of CleanDocument
  #
  # source://dead_end//lib/dead_end/clean_document.rb#87
  def initialize(source:); end

  # Call all of the document "cleaners"
  # and return self
  #
  # source://dead_end//lib/dead_end/clean_document.rb#94
  def call; end

  # Remove comments and whitespace only lines
  #
  # replace with empty newlines
  #
  #     source = <<~'EOM'
  #       # Comment 1
  #       puts "hello"
  #       # Comment 2
  #       puts "world"
  #     EOM
  #
  #     lines = CleanDocument.new(source: source).lines
  #     expect(lines[0].to_s).to eq("\n")
  #     expect(lines[1].to_s).to eq("puts "hello")
  #     expect(lines[2].to_s).to eq("\n")
  #     expect(lines[3].to_s).to eq("puts "world")
  #
  # Important: This must be done before lexing.
  #
  # After this change is made, we lex the document because
  # removing comments can change how the doc is parsed.
  #
  # For example:
  #
  #     values = LexAll.new(source: <<~EOM))
  #       User.
  #         # comment
  #         where(name: 'schneems')
  #     EOM
  #     expect(
  #       values.count {|v| v.type == :on_ignored_nl}
  #     ).to eq(1)
  #
  # After the comment is removed:
  #
  #     values = LexAll.new(source: <<~EOM))
  #       User.
  #
  #         where(name: 'schneems')
  #     EOM
  #     expect(
  #      values.count {|v| v.type == :on_ignored_nl}
  #    ).to eq(2)
  #
  # source://dead_end//lib/dead_end/clean_document.rb#157
  def clean_sweep(source:); end

  # Smushes logically "consecutive" lines
  #
  #     source = <<~'EOM'
  #       User.
  #         where(name: 'schneems').
  #         first
  #     EOM
  #
  #     lines = CleanDocument.new(source: source).join_consecutive!.lines
  #     expect(lines[0].to_s).to eq(source)
  #     expect(lines[1].to_s).to eq("")
  #
  # The one known case this doesn't handle is:
  #
  #     Ripper.lex <<~EOM
  #       a &&
  #        b ||
  #        c
  #     EOM
  #
  # For some reason this introduces `on_ignore_newline` but with BEG type
  #
  # source://dead_end//lib/dead_end/clean_document.rb#223
  def join_consecutive!; end

  # Helper method for joining "groups" of lines
  #
  # Input is expected to be type Array<Array<CodeLine>>
  #
  # The outer array holds the various "groups" while the
  # inner array holds code lines.
  #
  # All code lines are "joined" into the first line in
  # their group.
  #
  # To preserve document size, empty lines are placed
  # in the place of the lines that were "joined"
  #
  # source://dead_end//lib/dead_end/clean_document.rb#264
  def join_groups(groups); end

  # Smushes all heredoc lines into one line
  #
  #     source = <<~'EOM'
  #       foo = <<~HEREDOC
  #          lol
  #          hehehe
  #       HEREDOC
  #     EOM
  #
  #     lines = CleanDocument.new(source: source).join_heredoc!.lines
  #     expect(lines[0].to_s).to eq(source)
  #     expect(lines[1].to_s).to eq("")
  #
  # source://dead_end//lib/dead_end/clean_document.rb#179
  def join_heredoc!; end

  # Join lines with a trailing slash
  #
  #     source = <<~'EOM'
  #       it "code can be split" \
  #          "across multiple lines" do
  #     EOM
  #
  #     lines = CleanDocument.new(source: source).join_consecutive!.lines
  #     expect(lines[0].to_s).to eq(source)
  #     expect(lines[1].to_s).to eq("")
  #
  # source://dead_end//lib/dead_end/clean_document.rb#244
  def join_trailing_slash!; end

  # Return an array of CodeLines in the
  # document
  #
  # source://dead_end//lib/dead_end/clean_document.rb#104
  def lines; end

  # Helper method for grabbing elements from document
  #
  # Like `take_while` except when it stops
  # iterating, it also returns the line
  # that caused it to stop
  #
  # source://dead_end//lib/dead_end/clean_document.rb#294
  def take_while_including(range = T.unsafe(nil)); end

  # Renders the document back to a string
  #
  # source://dead_end//lib/dead_end/clean_document.rb#109
  def to_s; end
end

# All the logic of the exe/dead_end CLI in one handy spot
#
#   Cli.new(argv: ["--help"]).call
#   Cli.new(argv: ["<path/to/file>.rb"]).call
#   Cli.new(argv: ["<path/to/file>.rb", "--record=tmp"]).call
#   Cli.new(argv: ["<path/to/file>.rb", "--terminal"]).call
class DeadEnd::Cli
  # ARGV is Everything passed to the executable, does not include executable name
  #
  # All other intputs are dependency injection for testing
  #
  # @return [Cli] a new instance of Cli
  #
  # source://dead_end//lib/dead_end/cli.rb#20
  def initialize(argv:, exit_obj: T.unsafe(nil), io: T.unsafe(nil), env: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/cli.rb#32
  def call; end

  # Returns the value of attribute options.
  #
  # source://dead_end//lib/dead_end/cli.rb#15
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://dead_end//lib/dead_end/cli.rb#15
  def options=(_arg0); end

  # source://dead_end//lib/dead_end/cli.rb#74
  def parse; end

  # source://dead_end//lib/dead_end/cli.rb#80
  def parser; end
end

# Multiple lines form a singular CodeBlock
#
# Source code is made of multiple CodeBlocks.
#
# Example:
#
#   code_block.to_s # =>
#     #   def foo
#     #     puts "foo"
#     #   end
#
#   code_block.valid? # => true
#   code_block.in_valid? # => false
class DeadEnd::CodeBlock
  # @return [CodeBlock] a new instance of CodeBlock
  #
  # source://dead_end//lib/dead_end/code_block.rb#23
  def initialize(lines: T.unsafe(nil)); end

  # This is used for frontier ordering, we are searching from
  # the largest indentation to the smallest. This allows us to
  # populate an array with multiple code blocks then call `sort!`
  # on it without having to specify the sorting criteria
  #
  # source://dead_end//lib/dead_end/code_block.rb#59
  def <=>(other); end

  # source://dead_end//lib/dead_end/code_block.rb#67
  def current_indent; end

  # source://dead_end//lib/dead_end/code_block.rb#31
  def delete; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_block.rb#35
  def deleted?; end

  # Returns the value of attribute ends_at.
  #
  # source://dead_end//lib/dead_end/code_block.rb#21
  def ends_at; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_block.rb#51
  def hidden?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_block.rb#71
  def invalid?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_block.rb#47
  def is_end?; end

  # Returns the value of attribute lines.
  #
  # source://dead_end//lib/dead_end/code_block.rb#21
  def lines; end

  # source://dead_end//lib/dead_end/code_block.rb#43
  def mark_invisible; end

  # Returns the value of attribute starts_at.
  #
  # source://dead_end//lib/dead_end/code_block.rb#21
  def starts_at; end

  # source://dead_end//lib/dead_end/code_block.rb#96
  def to_s; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_block.rb#75
  def valid?; end

  # source://dead_end//lib/dead_end/code_block.rb#39
  def visible_lines; end
end

# source://dead_end//lib/dead_end/code_block.rb#20
DeadEnd::CodeBlock::UNSET = T.let(T.unsafe(nil), Object)

# There are three main phases in the algorithm:
#
# 1. Sanitize/format input source
# 2. Search for invalid blocks
# 3. Format invalid blocks into something meaninful
#
# The Code frontier is a critical part of the second step
#
# ## Knowing where we've been
#
# Once a code block is generated it is added onto the frontier. Then it will be
# sorted by indentation and frontier can be filtered. Large blocks that fully enclose a
# smaller block will cause the smaller block to be evicted.
#
#   CodeFrontier#<<(block) # Adds block to frontier
#   CodeFrontier#pop # Removes block from frontier
#
# ## Knowing where we can go
#
# Internally the frontier keeps track of "unvisited" lines which are exposed via `next_indent_line`
# when called, this method returns, a line of code with the highest indentation.
#
# The returned line of code can be used to build a CodeBlock and then that code block
# is added back to the frontier. Then, the lines are removed from the
# "unvisited" so we don't double-create the same block.
#
#   CodeFrontier#next_indent_line # Shows next line
#   CodeFrontier#register_indent_block(block) # Removes lines from unvisited
#
# ## Knowing when to stop
#
# The frontier knows how to check the entire document for a syntax error. When blocks
# are added onto the frontier, they're removed from the document. When all code containing
# syntax errors has been added to the frontier, the document will be parsable without a
# syntax error and the search can stop.
#
#   CodeFrontier#holds_all_syntax_errors? # Returns true when frontier holds all syntax errors
#
# ## Filtering false positives
#
# Once the search is completed, the frontier may have multiple blocks that do not contain
# the syntax error. To limit the result to the smallest subset of "invalid blocks" call:
#
#   CodeFrontier#detect_invalid_blocks
class DeadEnd::CodeFrontier
  # @return [CodeFrontier] a new instance of CodeFrontier
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#53
  def initialize(code_lines:, unvisited: T.unsafe(nil)); end

  # Add a block to the frontier
  #
  # This method ensures the frontier always remains sorted (in indentation order)
  # and that each code block's lines are removed from the indentation hash so we
  # don't re-evaluate the same line multiple times.
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#148
  def <<(block); end

  # source://dead_end//lib/dead_end/code_frontier.rb#61
  def count; end

  # Given that we know our syntax error exists somewhere in our frontier, we want to find
  # the smallest possible set of blocks that contain all the syntax errors
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#172
  def detect_invalid_blocks; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#111
  def expand?; end

  # Returns true if the document is valid with all lines
  # removed. By default it checks all blocks in present in
  # the frontier array, but can be used for arbitrary arrays
  # of codeblocks as well
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#89
  def holds_all_syntax_errors?(block_array = T.unsafe(nil), can_cache: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/code_frontier.rb#107
  def next_indent_line; end

  # Returns a code block with the largest indentation possible
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#103
  def pop; end

  # When one element fully encapsulates another we remove the smaller
  # block from the frontier. This prevents double expansions and all-around
  # weird behavior. However this guarantee is quite expensive to maintain
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#140
  def register_engulf_block(block); end

  # Keeps track of what lines have been added to blocks and which are not yet
  # visited.
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#132
  def register_indent_block(block); end

  private

  # Performance optimization
  #
  # Parsing with ripper is expensive
  # If we know we don't have any blocks with invalid
  # syntax, then we know we cannot have found
  # the incorrect syntax yet.
  #
  # When an invalid block is added onto the frontier
  # check document state
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_frontier.rb#74
  def can_skip_check?; end

  class << self
    # Example:
    #
    #   combination([:a, :b, :c, :d])
    #   # => [[:a], [:b], [:c], [:d], [:a, :b], [:a, :c], [:a, :d], [:b, :c], [:b, :d], [:c, :d], [:a, :b, :c], [:a, :b, :d], [:a, :c, :d], [:b, :c, :d], [:a, :b, :c, :d]]
    #
    # source://dead_end//lib/dead_end/code_frontier.rb#162
    def combination(array); end
  end
end

# Represents a single line of code of a given source file
#
# This object contains metadata about the line such as
# amount of indentation, if it is empty or not, and
# lexical data, such as if it has an `end` or a keyword
# in it.
#
# Visibility of lines can be toggled off. Marking a line as invisible
# indicates that it should not be used for syntax checks.
# It's functionally the same as commenting it out.
#
# Example:
#
#   line = CodeLine.from_source("def foo\n").first
#   line.number => 1
#   line.empty? # => false
#   line.visible? # => true
#   line.mark_invisible
#   line.visible? # => false
class DeadEnd::CodeLine
  # @return [CodeLine] a new instance of CodeLine
  #
  # source://dead_end//lib/dead_end/code_line.rb#42
  def initialize(line:, index:, lex:); end

  # Comparison operator, needed for equality
  # and sorting
  #
  # source://dead_end//lib/dead_end/code_line.rb#152
  def <=>(other); end

  # An `empty?` line is one that was originally left
  # empty in the source code, while a "hidden" line
  # is one that we've since marked as "invisible"
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#117
  def empty?; end

  # Opposite or `visible?` (note: different than `empty?`)
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#110
  def hidden?; end

  # [Not stable API]
  #
  # Lines that have a `on_ignored_nl` type token and NOT
  # a `BEG` type seem to be a good proxy for the ability
  # to join multiple lines into one.
  #
  # This predicate method is used to determine when those
  # two criteria have been met.
  #
  # The one known case this doesn't handle is:
  #
  #     Ripper.lex <<~EOM
  #       a &&
  #        b ||
  #        c
  #     EOM
  #
  # For some reason this introduces `on_ignore_newline` but with BEG type
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#174
  def ignore_newline_not_beg?; end

  # Returns the value of attribute indent.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def indent; end

  # Used for stable sort via indentation level
  #
  # Ruby's sort is not "stable" meaning that when
  # multiple elements have the same value, they are
  # not guaranteed to return in the same order they
  # were put in.
  #
  # So when multiple code lines have the same indentation
  # level, they're sorted by their index value which is unique
  # and consistent.
  #
  # This is mostly needed for consistency of the test suite
  #
  # source://dead_end//lib/dead_end/code_line.rb#74
  def indent_index; end

  # Returns the value of attribute index.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def index; end

  # Returns true if the code line is determined
  # to contain an `end` keyword
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#89
  def is_end?; end

  # Returns true if the code line is determined
  # to contain a keyword that matches with an `end`
  #
  # For example: `def`, `do`, `begin`, `ensure`, etc.
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#83
  def is_kw?; end

  # Returns the value of attribute lex.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def lex; end

  # Returns the value of attribute line.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def line; end

  # Returns the value of attribute line_number.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def line_number; end

  # Used to hide lines
  #
  # The search alorithm will group lines into blocks
  # then if those blocks are determined to represent
  # valid code they will be hidden
  #
  # source://dead_end//lib/dead_end/code_line.rb#98
  def mark_invisible; end

  # Opposite of `empty?` (note: different than `visible?`)
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#122
  def not_empty?; end

  # Returns the value of attribute line_number.
  #
  # source://dead_end//lib/dead_end/code_line.rb#41
  def number; end

  # When the code line is marked invisible
  # we retain the original value of it's line
  # this is useful for debugging and for
  # showing extra context
  #
  # DisplayCodeWithLineNumbers will render
  # all lines given to it, not just visible
  # lines, it uses the original method to
  # obtain them.
  #
  # source://dead_end//lib/dead_end/code_line.rb#148
  def original; end

  # Renders the given line
  #
  # Also allows us to represent source code as
  # an array of code lines.
  #
  # When we have an array of code line elements
  # calling `join` on the array will call `to_s`
  # on each element, which essentially converts
  # it back into it's original source string.
  #
  # source://dead_end//lib/dead_end/code_line.rb#135
  def to_s; end

  # Determines if the given line has a trailing slash
  #
  #     lines = CodeLine.from_source(<<~EOM)
  #       it "foo" \
  #     EOM
  #     expect(lines.first.trailing_slash?).to eq(true)
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#185
  def trailing_slash?; end

  # Means the line was marked as "invisible"
  # Confusingly, "empty" lines are visible...they
  # just don't contain any source code other than a newline ("\n").
  #
  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/code_line.rb#105
  def visible?; end

  private

  # Endless method detection
  #
  # From https://github.com/ruby/irb/commit/826ae909c9c93a2ddca6f9cfcd9c94dbf53d44ab
  # Detecting a "oneliner" seems to need a state machine.
  # This can be done by looking mostly at the "state" (last value):
  #
  #   ENDFN -> BEG (token = '=' ) -> END
  #
  # source://dead_end//lib/dead_end/code_line.rb#201
  def set_kw_end; end

  class << self
    # Returns an array of CodeLine objects
    # from the source string
    #
    # source://dead_end//lib/dead_end/code_line.rb#29
    def from_source(source, lines: T.unsafe(nil)); end
  end
end

# source://dead_end//lib/dead_end/code_line.rb#25
DeadEnd::CodeLine::TRAILING_SLASH = T.let(T.unsafe(nil), String)

# Searches code for a syntax error
#
# There are three main phases in the algorithm:
#
# 1. Sanitize/format input source
# 2. Search for invalid blocks
# 3. Format invalid blocks into something meaninful
#
# This class handles the part.
#
# The bulk of the heavy lifting is done in:
#
#  - CodeFrontier (Holds information for generating blocks and determining if we can stop searching)
#  - ParseBlocksFromLine (Creates blocks into the frontier)
#  - BlockExpand (Expands existing blocks to search more code)
#
# ## Syntax error detection
#
# When the frontier holds the syntax error, we can stop searching
#
#   search = CodeSearch.new(<<~EOM)
#     def dog
#       def lol
#     end
#   EOM
#
#   search.call
#
#   search.invalid_blocks.map(&:to_s) # =>
#   # => ["def lol\n"]
class DeadEnd::CodeSearch
  # @return [CodeSearch] a new instance of CodeSearch
  #
  # source://dead_end//lib/dead_end/code_search.rb#44
  def initialize(source, record_dir: T.unsafe(nil)); end

  # Main search loop
  #
  # source://dead_end//lib/dead_end/code_search.rb#123
  def call; end

  # Returns the value of attribute code_lines.
  #
  # source://dead_end//lib/dead_end/code_search.rb#42
  def code_lines; end

  # Parses the most indented lines into blocks that are marked
  # and added to the frontier
  #
  # source://dead_end//lib/dead_end/code_search.rb#100
  def create_blocks_from_untracked_lines; end

  # Given an already existing block in the frontier, expand it to see
  # if it contains our invalid syntax
  #
  # source://dead_end//lib/dead_end/code_search.rb#112
  def expand_existing; end

  # Returns the value of attribute invalid_blocks.
  #
  # source://dead_end//lib/dead_end/code_search.rb#42
  def invalid_blocks; end

  # source://dead_end//lib/dead_end/code_search.rb#91
  def push(block, name:); end

  # Used for debugging
  #
  # source://dead_end//lib/dead_end/code_search.rb#69
  def record(block:, name: T.unsafe(nil)); end

  # Returns the value of attribute record_dir.
  #
  # source://dead_end//lib/dead_end/code_search.rb#42
  def record_dir; end

  private

  # Returns the value of attribute frontier.
  #
  # source://dead_end//lib/dead_end/code_search.rb#38
  def frontier; end
end

# Used to indicate a default value that cannot
# be confused with another input.
#
# source://dead_end//lib/dead_end/api.rb#16
DeadEnd::DEFAULT_VALUE = T.let(T.unsafe(nil), Object)

# Outputs code with highlighted lines
#
# Whatever is passed to this class will be rendered
# even if it is "marked invisible" any filtering of
# output should be done before calling this class.
#
#   DisplayCodeWithLineNumbers.new(
#     lines: lines,
#     highlight_lines: [lines[2], lines[3]]
#   ).call
#   # =>
#       1
#       2  def cat
#     ❯ 3    Dir.chdir
#     ❯ 4    end
#       5  end
#       6
class DeadEnd::DisplayCodeWithLineNumbers
  # @return [DisplayCodeWithLineNumbers] a new instance of DisplayCodeWithLineNumbers
  #
  # source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#25
  def initialize(lines:, highlight_lines: T.unsafe(nil), terminal: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#32
  def call; end

  private

  # source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#50
  def format(contents:, number:, empty:, highlight: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#38
  def format_line(code_line); end
end

# source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#23
DeadEnd::DisplayCodeWithLineNumbers::TERMINAL_END = T.let(T.unsafe(nil), String)

# Bold, italics
#
# source://dead_end//lib/dead_end/display_code_with_line_numbers.rb#22
DeadEnd::DisplayCodeWithLineNumbers::TERMINAL_HIGHLIGHT = T.let(T.unsafe(nil), String)

# Used for formatting invalid blocks
class DeadEnd::DisplayInvalidBlocks
  # @return [DisplayInvalidBlocks] a new instance of DisplayInvalidBlocks
  #
  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#11
  def initialize(code_lines:, blocks:, io: T.unsafe(nil), filename: T.unsafe(nil), terminal: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#24
  def call; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#20
  def document_ok?; end

  # Returns the value of attribute filename.
  #
  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#9
  def filename; end

  private

  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#71
  def code_with_context; end

  # source://dead_end//lib/dead_end/display_invalid_blocks.rb#41
  def display_block(block); end
end

class DeadEnd::Error < ::StandardError; end

# Explains syntax errors based on their source
#
# example:
#
#   source = "def foo; puts 'lol'" # Note missing end
#   explain ExplainSyntax.new(
#     code_lines: CodeLine.from_source(source)
#   ).call
#   explain.errors.first
#   # => "Unmatched keyword, missing `end' ?"
#
# When the error cannot be determined by lexical counting
# then ripper is run against the input and the raw ripper
# errors returned.
#
# Example:
#
#   source = "1 * " # Note missing a second number
#   explain ExplainSyntax.new(
#     code_lines: CodeLine.from_source(source)
#   ).call
#   explain.errors.first
#   # => "syntax error, unexpected end-of-input"
class DeadEnd::ExplainSyntax
  # @return [ExplainSyntax] a new instance of ExplainSyntax
  #
  # source://dead_end//lib/dead_end/explain_syntax.rb#40
  def initialize(code_lines:); end

  # source://dead_end//lib/dead_end/explain_syntax.rb#46
  def call; end

  # Returns an array of syntax error messages
  #
  # If no missing pairs are found it falls back
  # on the original ripper error messages
  #
  # source://dead_end//lib/dead_end/explain_syntax.rb#95
  def errors; end

  # Returns an array of missing elements
  #
  # For example this:
  #
  #   ExplainSyntax.new(code_lines: lines).missing
  #   # => ["}"]
  #
  # Would indicate that the source is missing
  # a `}` character in the source code
  #
  # source://dead_end//lib/dead_end/explain_syntax.rb#65
  def missing; end

  # Converts a missing string to
  # an human understandable explanation.
  #
  # Example:
  #
  #   explain.why("}")
  #   # => "Unmatched `{', missing `}' ?"
  #
  # source://dead_end//lib/dead_end/explain_syntax.rb#77
  def why(miss); end
end

# source://dead_end//lib/dead_end/explain_syntax.rb#30
DeadEnd::ExplainSyntax::INVERSE = T.let(T.unsafe(nil), Hash)

# Find mis-matched syntax based on lexical count
#
# Used for detecting missing pairs of elements
# each keyword needs an end, each '{' needs a '}'
# etc.
#
# Example:
#
#   left_right = LeftRightLexCount.new
#   left_right.count_kw
#   left_right.missing.first
#   # => "end"
#
#   left_right = LeftRightLexCount.new
#   source = "{ a: b, c: d" # Note missing '}'
#   LexAll.new(source: source).each do |lex|
#     left_right.count_lex(lex)
#   end
#   left_right.missing.first
#   # => "}"
class DeadEnd::LeftRightLexCount
  # @return [LeftRightLexCount] a new instance of LeftRightLexCount
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#25
  def initialize; end

  # source://dead_end//lib/dead_end/left_right_lex_count.rb#44
  def count_end; end

  # source://dead_end//lib/dead_end/left_right_lex_count.rb#101
  def count_for_char(char); end

  # source://dead_end//lib/dead_end/left_right_lex_count.rb#40
  def count_kw; end

  # Count source code characters
  #
  # Example:
  #
  #   left_right = LeftRightLexCount.new
  #   left_right.count_lex(LexValue.new(1, :on_lbrace, "{", Ripper::EXPR_BEG))
  #   left_right.count_for_char("{")
  #   # => 1
  #   left_right.count_for_char("}")
  #   # => 0
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#58
  def count_lex(lex); end

  # Returns an array of missing syntax characters
  # or `"end"` or `"keyword"`
  #
  #   left_right.missing
  #   # => ["}"]
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#110
  def missing; end

  private

  # Keywords need ends and ends need keywords
  #
  # If we have more keywords, there's a missing `end`
  # if we have more `end`-s, there's a missing keyword
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#148
  def missing_keyword_end; end

  # Opening characters like `{` need closing characters # like `}`.
  #
  # When a mis-match count is detected, suggest the
  # missing member.
  #
  # For example if there are 3 `}` and only two `{`
  # return `"{"`
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#131
  def missing_pairs; end

  # Pipes come in pairs.
  # If there's an odd number of pipes then we
  # are missing one
  #
  # source://dead_end//lib/dead_end/left_right_lex_count.rb#162
  def missing_pipe; end
end

# source://dead_end//lib/dead_end/left_right_lex_count.rb#118
DeadEnd::LeftRightLexCount::PAIRS = T.let(T.unsafe(nil), Hash)

# Ripper.lex is not guaranteed to lex the entire source document
#
# lex = LexAll.new(source: source)
# lex.each do |value|
#   puts value.line
# end
class DeadEnd::LexAll
  include ::Enumerable

  # @return [LexAll] a new instance of LexAll
  #
  # source://dead_end//lib/dead_end/lex_all.rb#13
  def initialize(source:, source_lines: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/lex_all.rb#45
  def [](index); end

  # source://dead_end//lib/dead_end/lex_all.rb#38
  def each; end

  # source://dead_end//lib/dead_end/lex_all.rb#49
  def last; end

  # source://dead_end//lib/dead_end/lex_all.rb#34
  def to_a; end
end

# Value object for accessing lex values
#
# This lex:
#
#   [1, 0], :on_ident, "describe", CMDARG
#
# Would translate into:
#
#  lex.line # => 1
#  lex.type # => :on_indent
#  lex.token # => "describe"
class DeadEnd::LexValue
  # @return [LexValue] a new instance of LexValue
  #
  # source://dead_end//lib/dead_end/lex_value.rb#18
  def initialize(line, type, token, state, last_lex = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#62
  def expr_beg?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#66
  def expr_label?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#46
  def fname?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#50
  def ignore_newline?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#54
  def is_end?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/lex_value.rb#58
  def is_kw?; end

  # Returns the value of attribute line.
  #
  # source://dead_end//lib/dead_end/lex_value.rb#16
  def line; end

  # Returns the value of attribute state.
  #
  # source://dead_end//lib/dead_end/lex_value.rb#16
  def state; end

  # Returns the value of attribute token.
  #
  # source://dead_end//lib/dead_end/lex_value.rb#16
  def token; end

  # Returns the value of attribute type.
  #
  # source://dead_end//lib/dead_end/lex_value.rb#16
  def type; end

  private

  # source://dead_end//lib/dead_end/lex_value.rb#27
  def set_kw_end(last_lex); end
end

# This class is responsible for generating initial code blocks
# that will then later be expanded.
#
# The biggest concern when guessing code blocks, is accidentally
# grabbing one that contains only an "end". In this example:
#
#   def dog
#     begonn # mispelled `begin`
#     puts "bark"
#     end
#   end
#
# The following lines would be matched (from bottom to top):
#
#   1) end
#
#   2) puts "bark"
#      end
#
#   3) begonn
#      puts "bark"
#      end
#
# At this point it has no where else to expand, and it will yield this inner
# code as a block
class DeadEnd::ParseBlocksFromIndentLine
  # @return [ParseBlocksFromIndentLine] a new instance of ParseBlocksFromIndentLine
  #
  # source://dead_end//lib/dead_end/parse_blocks_from_indent_line.rb#32
  def initialize(code_lines:); end

  # Returns the value of attribute code_lines.
  #
  # source://dead_end//lib/dead_end/parse_blocks_from_indent_line.rb#30
  def code_lines; end

  # Builds blocks from bottom up
  #
  # source://dead_end//lib/dead_end/parse_blocks_from_indent_line.rb#37
  def each_neighbor_block(target_line); end
end

# Converts a SyntaxError message to a path
#
# Handles the case where the filename has a colon in it
# such as on a windows file system: https://github.com/zombocom/dead_end/issues/111
#
# Example:
#
#    message = "/tmp/scratch:2:in `require_relative': /private/tmp/bad.rb:1: syntax error, unexpected `end' (SyntaxError)"
#    puts PathnameFromMessage.new(message).call.name
#    # => "/tmp/scratch.rb"
class DeadEnd::PathnameFromMessage
  # @return [PathnameFromMessage] a new instance of PathnameFromMessage
  #
  # source://dead_end//lib/dead_end/pathname_from_message.rb#20
  def initialize(message, io: T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/pathname_from_message.rb#28
  def call; end

  # Returns the value of attribute name.
  #
  # source://dead_end//lib/dead_end/pathname_from_message.rb#18
  def name; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/pathname_from_message.rb#55
  def skip_missing_file_name?; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/pathname_from_message.rb#48
  def stop?; end
end

# source://dead_end//lib/dead_end/pathname_from_message.rb#16
DeadEnd::PathnameFromMessage::EVAL_RE = T.let(T.unsafe(nil), Regexp)

# source://dead_end//lib/dead_end/pathname_from_message.rb#17
DeadEnd::PathnameFromMessage::STREAMING_RE = T.let(T.unsafe(nil), Regexp)

# Keeps track of what elements are in the queue in
# priority and also ensures that when one element
# engulfs/covers/eats another that the larger element
# evicts the smaller element
class DeadEnd::PriorityEngulfQueue
  # @return [PriorityEngulfQueue] a new instance of PriorityEngulfQueue
  #
  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#9
  def initialize; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#17
  def empty?; end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#21
  def length; end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#25
  def peek; end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#29
  def pop; end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#33
  def push(block); end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#13
  def to_a; end

  private

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#41
  def flush_deleted; end

  # source://dead_end//lib/dead_end/priority_engulf_queue.rb#47
  def prune_engulf(block); end
end

# Holds elements in a priority heap on insert
#
# Instead of constantly calling `sort!`, put
# the element where it belongs the first time
# around
#
# Example:
#
#   queue = PriorityQueue.new
#   queue << 33
#   queue << 44
#   queue << 1
#
#   puts queue.peek # => 44
class DeadEnd::PriorityQueue
  # @return [PriorityQueue] a new instance of PriorityQueue
  #
  # source://dead_end//lib/dead_end/priority_queue.rb#22
  def initialize; end

  # source://dead_end//lib/dead_end/priority_queue.rb#26
  def <<(element); end

  # Returns the value of attribute elements.
  #
  # source://dead_end//lib/dead_end/priority_queue.rb#20
  def elements; end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/priority_queue.rb#42
  def empty?; end

  # source://dead_end//lib/dead_end/priority_queue.rb#98
  def exchange(source, target); end

  # source://dead_end//lib/dead_end/priority_queue.rb#38
  def length; end

  # source://dead_end//lib/dead_end/priority_queue.rb#46
  def peek; end

  # source://dead_end//lib/dead_end/priority_queue.rb#31
  def pop; end

  # Used for testing, extremely not performant
  #
  # source://dead_end//lib/dead_end/priority_queue.rb#55
  def sorted; end

  # source://dead_end//lib/dead_end/priority_queue.rb#50
  def to_a; end

  private

  # source://dead_end//lib/dead_end/priority_queue.rb#81
  def bubble_down(index); end

  # source://dead_end//lib/dead_end/priority_queue.rb#69
  def bubble_up(index, element); end

  # source://dead_end//lib/dead_end/priority_queue.rb#65
  def last_index; end
end

# Capture parse errors from ripper
#
# Example:
#
#   puts RipperErrors.new(" def foo").call.errors
#   # => ["syntax error, unexpected end-of-input, expecting ';' or '\\n'"]
class DeadEnd::RipperErrors < ::Ripper
  # source://dead_end//lib/dead_end/ripper_errors.rb#27
  def call; end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def compile_error(msg); end

  # Returns the value of attribute errors.
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#11
  def errors; end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def on_alias_error(msg); end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def on_assign_error(msg); end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def on_class_name_error(msg); end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def on_param_error(msg); end

  # Comes from ripper, called
  # on every parse error, msg
  # is a string
  #
  # source://dead_end//lib/dead_end/ripper_errors.rb#16
  def on_parse_error(msg); end
end

# source://dead_end//lib/dead_end/api.rb#19
DeadEnd::TIMEOUT_DEFAULT = T.let(T.unsafe(nil), Integer)

# Tracks which lines various code blocks have expanded to
# and which are still unexplored
class DeadEnd::UnvisitedLines
  # @return [UnvisitedLines] a new instance of UnvisitedLines
  #
  # source://dead_end//lib/dead_end/unvisited_lines.rb#7
  def initialize(code_lines:); end

  # @return [Boolean]
  #
  # source://dead_end//lib/dead_end/unvisited_lines.rb#13
  def empty?; end

  # source://dead_end//lib/dead_end/unvisited_lines.rb#17
  def peek; end

  # source://dead_end//lib/dead_end/unvisited_lines.rb#21
  def pop; end

  # source://dead_end//lib/dead_end/unvisited_lines.rb#25
  def visit_block(block); end
end

# source://dead_end//lib/dead_end/api.rb#12
DeadEnd::VERSION = T.let(T.unsafe(nil), String)

# Monkey patch kernel to ensure that all `require` calls call the same
# method
module Kernel
  private

  # source://dead_end//lib/dead_end/core_ext.rb#64
  def load(file, wrap = T.unsafe(nil)); end

  # source://dead_end//lib/dead_end/core_ext.rb#76
  def require_relative(file); end

  # source://dead_end//lib/dead_end/core_ext.rb#70
  def zeitwerk_original_require(file); end

  class << self
    # source://dead_end//lib/dead_end/core_ext.rb#64
    def load(file, wrap = T.unsafe(nil)); end

    # source://dead_end//lib/dead_end/core_ext.rb#76
    def require_relative(file); end

    # source://dead_end//lib/dead_end/core_ext.rb#70
    def zeitwerk_original_require(file); end
  end
end

# Calling `DeadEnd::VERSION` forces an eager load due to
# an `autoload` on the `DeadEnd` constant.
#
# This is used for gemspec access in tests
module UnloadedDeadEnd; end

# source://dead_end//lib/dead_end/version.rb#8
UnloadedDeadEnd::VERSION = T.let(T.unsafe(nil), String)
