# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `country_select` gem.
# Please instead update this file by running `bin/tapioca gem country_select`.

# A +FormBuilder+ object is associated with a particular model object and
# allows you to generate fields associated with the model object. The
# +FormBuilder+ object is yielded when using +form_for+ or +fields_for+.
# For example:
#
#   <%= form_for @person do |person_form| %>
#     Name: <%= person_form.text_field :name %>
#     Admin: <%= person_form.check_box :admin %>
#   <% end %>
#
# In the above block, a +FormBuilder+ object is yielded as the
# +person_form+ variable. This allows you to generate the +text_field+
# and +check_box+ fields by specifying their eponymous methods, which
# modify the underlying template and associates the <tt>@person</tt> model object
# with the form.
#
# The +FormBuilder+ object can be thought of as serving as a proxy for the
# methods in the +FormHelper+ module. This class, however, allows you to
# call methods with the model object you are building the form for.
#
# You can create your own custom FormBuilder templates by subclassing this
# class. For example:
#
#   class MyFormBuilder < ActionView::Helpers::FormBuilder
#     def div_radio_button(method, tag_value, options = {})
#       @template.content_tag(:div,
#         @template.radio_button(
#           @object_name, method, tag_value, objectify_options(options)
#         )
#       )
#     end
#   end
#
# The above code creates a new method +div_radio_button+ which wraps a div
# around the new radio button. Note that when options are passed in, you
# must call +objectify_options+ in order for the model object to get
# correctly passed to the method. If +objectify_options+ is not called,
# then the newly created helper will not be linked back to the model.
#
# The +div_radio_button+ code from above can now be used as follows:
#
#   <%= form_for @person, :builder => MyFormBuilder do |f| %>
#     I am a child: <%= f.div_radio_button(:admin, "child") %>
#     I am an adult: <%= f.div_radio_button(:admin, "adult") %>
#   <% end -%>
#
# The standard set of helper methods for form building are located in the
# +field_helpers+ class attribute.
class ActionView::Helpers::FormBuilder
  include ::ActionView::ModelNaming
  include ::SimpleForm::ActionViewExtensions::Builder

  # @return [FormBuilder] a new instance of FormBuilder
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1700
  def initialize(object_name, object, template, options); end

  # Add the submit button for the given form. When no value is given, it checks
  # if the object is a new resource or not to create the proper label:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.button %>
  #   <% end %>
  #
  # In the example above, if <tt>@post</tt> is a new record, it will use "Create Post" as
  # button label; otherwise, it uses "Update Post".
  #
  # Those labels can be customized using I18n under the +helpers.submit+ key
  # (the same as submit helper) and using <tt>%{model}</tt> for translation interpolation:
  #
  #   en:
  #     helpers:
  #       submit:
  #         create: "Create a %{model}"
  #         update: "Confirm changes to %{model}"
  #
  # It also searches for a key specific to the given object:
  #
  #   en:
  #     helpers:
  #       submit:
  #         post:
  #           create: "Add %{model}"
  #
  # ==== Examples
  #   button("Create post")
  #   # => <button name='button' type='submit'>Create post</button>
  #
  #   button(:draft, value: true)
  #   # => <button id="post_draft" name="post[draft]" value="true" type="submit">Create post</button>
  #
  #   button do
  #     content_tag(:strong, 'Ask me!')
  #   end
  #   # => <button name='button' type='submit'>
  #   #      <strong>Ask me!</strong>
  #   #    </button>
  #
  #   button do |text|
  #     content_tag(:strong, text)
  #   end
  #   # => <button name='button' type='submit'>
  #   #      <strong>Create post</strong>
  #   #    </button>
  #
  #   button(:draft, value: true) do
  #     content_tag(:strong, "Save as draft")
  #   end
  #   # =>  <button id="post_draft" name="post[draft]" value="true" type="submit">
  #   #       <strong>Save as draft</strong>
  #   #     </button>
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2614
  def button(value = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Returns a checkbox tag tailored for accessing a specified attribute (identified by +method+) on an object
  # assigned to the template (identified by +object+). This object must be an instance object (@object) and not a local object.
  # It's intended that +method+ returns an integer and if that integer is above zero, then the checkbox is checked.
  # Additional options on the input tag can be passed as a hash with +options+. The +checked_value+ defaults to 1
  # while the default +unchecked_value+ is set to 0 which is convenient for boolean values.
  #
  # ==== Options
  #
  # * Any standard HTML attributes for the tag can be passed in, for example +:class+.
  # * <tt>:checked</tt> - +true+ or +false+ forces the state of the checkbox to be checked or not.
  # * <tt>:include_hidden</tt> - If set to false, the auxiliary hidden field described below will not be generated.
  #
  # ==== Gotcha
  #
  # The HTML specification says unchecked check boxes are not successful, and
  # thus web browsers do not send them. Unfortunately this introduces a gotcha:
  # if an +Invoice+ model has a +paid+ flag, and in the form that edits a paid
  # invoice the user unchecks its check box, no +paid+ parameter is sent. So,
  # any mass-assignment idiom like
  #
  #   @invoice.update(params[:invoice])
  #
  # wouldn't update the flag.
  #
  # To prevent this the helper generates an auxiliary hidden field before
  # every check box. The hidden field has the same name and its
  # attributes mimic an unchecked check box.
  #
  # This way, the client either sends only the hidden field (representing
  # the check box is unchecked), or both fields. Since the HTML specification
  # says key/value pairs have to be sent in the same order they appear in the
  # form, and parameters extraction gets the last occurrence of any repeated
  # key in the query string, that works for ordinary forms.
  #
  # Unfortunately that workaround does not work when the check box goes
  # within an array-like parameter, as in
  #
  #   <%= fields_for "project[invoice_attributes][]", invoice, index: nil do |form| %>
  #     <%= form.check_box :paid %>
  #     ...
  #   <% end %>
  #
  # because parameter name repetition is precisely what Rails seeks to distinguish
  # the elements of the array. For each item with a checked check box you
  # get an extra ghost item with only that attribute, assigned to "0".
  #
  # In that case it is preferable to either use +check_box_tag+ or to use
  # hashes instead of arrays.
  #
  # ==== Examples
  #
  #   # Let's say that @post.validated? is 1:
  #   check_box("validated")
  #   # => <input name="post[validated]" type="hidden" value="0" />
  #   #    <input checked="checked" type="checkbox" id="post_validated" name="post[validated]" value="1" />
  #
  #   # Let's say that @puppy.gooddog is "no":
  #   check_box("gooddog", {}, "yes", "no")
  #   # => <input name="puppy[gooddog]" type="hidden" value="no" />
  #   #    <input type="checkbox" id="puppy_gooddog" name="puppy[gooddog]" value="yes" />
  #
  #   # Let's say that @eula.accepted is "no":
  #   check_box("accepted", { class: 'eula_check' }, "yes", "no")
  #   # => <input name="eula[accepted]" type="hidden" value="no" />
  #   #    <input type="checkbox" class="eula_check" id="eula_accepted" name="eula[accepted]" value="yes" />
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2438
  def check_box(method, options = T.unsafe(nil), checked_value = T.unsafe(nil), unchecked_value = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::FormOptionsHelper#collection_check_boxes for form builders:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.collection_check_boxes :author_ids, Author.all, :id, :name_with_initial %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#905
  def collection_check_boxes(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Wraps ActionView::Helpers::FormOptionsHelper#collection_radio_buttons for form builders:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.collection_radio_buttons :author_id, Author.all, :id, :name_with_initial %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#917
  def collection_radio_buttons(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Wraps ActionView::Helpers::FormOptionsHelper#collection_select for form builders:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.collection_select :person_id, Author.all, :id, :name_with_initial, prompt: true %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#857
  def collection_select(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def color_field(method, options = T.unsafe(nil)); end

  # source://country_select//lib/country_select/country_select_helper.rb#4
  def country_select(method, priority_or_options = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def date_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::DateHelper#date_select for form builders:
  #
  #   <%= form_for @person do |f| %>
  #     <%= f.date_select :birth_date %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/date_helper.rb#1229
  def date_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def datetime_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def datetime_local_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::DateHelper#datetime_select for form builders:
  #
  #   <%= form_for @person do |f| %>
  #     <%= f.datetime_select :last_request_at %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/date_helper.rb#1253
  def datetime_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def email_field(method, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2635
  def emitted_hidden_id?; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
  def field_helpers; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
  def field_helpers=(_arg0); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
  def field_helpers?; end

  # Generate an HTML <tt>id</tt> attribute value for the given field
  #
  # Return the value generated by the <tt>FormBuilder</tt> for the given
  # attribute name.
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.label :title %>
  #     <%= f.text_field :title, aria: { describedby: f.field_id(:title, :error) } %>
  #     <%= tag.span("is blank", id: f.field_id(:title, :error) %>
  #   <% end %>
  #
  # In the example above, the <tt><input type="text"></tt> element built by
  # the call to <tt>FormBuilder#text_field</tt> declares an
  # <tt>aria-describedby</tt> attribute referencing the <tt><span></tt>
  # element, sharing a common <tt>id</tt> root (<tt>post_title</tt>, in this
  # case).
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1757
  def field_id(method, *suffixes, namespace: T.unsafe(nil), index: T.unsafe(nil)); end

  # Generate an HTML <tt>name</tt> attribute value for the given name and
  # field combination
  #
  # Return the value generated by the <tt>FormBuilder</tt> for the given
  # attribute name.
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.text_field :title, name: f.field_name(:title, :subtitle) %>
  #     <%# => <input type="text" name="post[title][subtitle]">
  #   <% end %>
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.field_tag :tag, name: f.field_name(:tag, multiple: true) %>
  #     <%# => <input type="text" name="post[tag][]">
  #   <% end %>
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1777
  def field_name(method, *methods, multiple: T.unsafe(nil), index: T.unsafe(nil)); end

  # See the docs for the ActionView::Helpers::FormHelper#fields helper method.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2294
  def fields(scope = T.unsafe(nil), model: T.unsafe(nil), **options, &block); end

  # Creates a scope around a specific model object like form_for, but
  # doesn't create the form tags themselves. This makes fields_for suitable
  # for specifying additional model objects in the same form.
  #
  # Although the usage and purpose of +fields_for+ is similar to +form_for+'s,
  # its method signature is slightly different. Like +form_for+, it yields
  # a FormBuilder object associated with a particular model object to a block,
  # and within the block allows methods to be called on the builder to
  # generate fields associated with the model object. Fields may reflect
  # a model object in two ways - how they are named (hence how submitted
  # values appear within the +params+ hash in the controller) and what
  # default values are shown when the form the fields appear in is first
  # displayed. In order for both of these features to be specified independently,
  # both an object name (represented by either a symbol or string) and the
  # object itself can be passed to the method separately -
  #
  #   <%= form_for @person do |person_form| %>
  #     First name: <%= person_form.text_field :first_name %>
  #     Last name : <%= person_form.text_field :last_name %>
  #
  #     <%= fields_for :permission, @person.permission do |permission_fields| %>
  #       Admin?  : <%= permission_fields.check_box :admin %>
  #     <% end %>
  #
  #     <%= person_form.submit %>
  #   <% end %>
  #
  # In this case, the checkbox field will be represented by an HTML +input+
  # tag with the +name+ attribute <tt>permission[admin]</tt>, and the submitted
  # value will appear in the controller as <tt>params[:permission][:admin]</tt>.
  # If <tt>@person.permission</tt> is an existing record with an attribute
  # +admin+, the initial state of the checkbox when first displayed will
  # reflect the value of <tt>@person.permission.admin</tt>.
  #
  # Often this can be simplified by passing just the name of the model
  # object to +fields_for+ -
  #
  #   <%= fields_for :permission do |permission_fields| %>
  #     Admin?: <%= permission_fields.check_box :admin %>
  #   <% end %>
  #
  # ...in which case, if <tt>:permission</tt> also happens to be the name of an
  # instance variable <tt>@permission</tt>, the initial state of the input
  # field will reflect the value of that variable's attribute <tt>@permission.admin</tt>.
  #
  # Alternatively, you can pass just the model object itself (if the first
  # argument isn't a string or symbol +fields_for+ will realize that the
  # name has been omitted) -
  #
  #   <%= fields_for @person.permission do |permission_fields| %>
  #     Admin?: <%= permission_fields.check_box :admin %>
  #   <% end %>
  #
  # and +fields_for+ will derive the required name of the field from the
  # _class_ of the model object, e.g. if <tt>@person.permission</tt>, is
  # of class +Permission+, the field will still be named <tt>permission[admin]</tt>.
  #
  # Note: This also works for the methods in FormOptionsHelper and
  # DateHelper that are designed to work with an object as base, like
  # FormOptionsHelper#collection_select and DateHelper#datetime_select.
  #
  # === Nested Attributes Examples
  #
  # When the object belonging to the current scope has a nested attribute
  # writer for a certain attribute, fields_for will yield a new scope
  # for that attribute. This allows you to create forms that set or change
  # the attributes of a parent object and its associations in one go.
  #
  # Nested attribute writers are normal setter methods named after an
  # association. The most common way of defining these writers is either
  # with +accepts_nested_attributes_for+ in a model definition or by
  # defining a method with the proper name. For example: the attribute
  # writer for the association <tt>:address</tt> is called
  # <tt>address_attributes=</tt>.
  #
  # Whether a one-to-one or one-to-many style form builder will be yielded
  # depends on whether the normal reader method returns a _single_ object
  # or an _array_ of objects.
  #
  # ==== One-to-one
  #
  # Consider a Person class which returns a _single_ Address from the
  # <tt>address</tt> reader method and responds to the
  # <tt>address_attributes=</tt> writer method:
  #
  #   class Person
  #     def address
  #       @address
  #     end
  #
  #     def address_attributes=(attributes)
  #       # Process the attributes hash
  #     end
  #   end
  #
  # This model can now be used with a nested fields_for, like so:
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :address do |address_fields| %>
  #       Street  : <%= address_fields.text_field :street %>
  #       Zip code: <%= address_fields.text_field :zip_code %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # When address is already an association on a Person you can use
  # +accepts_nested_attributes_for+ to define the writer method for you:
  #
  #   class Person < ActiveRecord::Base
  #     has_one :address
  #     accepts_nested_attributes_for :address
  #   end
  #
  # If you want to destroy the associated model through the form, you have
  # to enable it first using the <tt>:allow_destroy</tt> option for
  # +accepts_nested_attributes_for+:
  #
  #   class Person < ActiveRecord::Base
  #     has_one :address
  #     accepts_nested_attributes_for :address, allow_destroy: true
  #   end
  #
  # Now, when you use a form element with the <tt>_destroy</tt> parameter,
  # with a value that evaluates to +true+, you will destroy the associated
  # model (e.g. 1, '1', true, or 'true'):
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :address do |address_fields| %>
  #       ...
  #       Delete: <%= address_fields.check_box :_destroy %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # ==== One-to-many
  #
  # Consider a Person class which returns an _array_ of Project instances
  # from the <tt>projects</tt> reader method and responds to the
  # <tt>projects_attributes=</tt> writer method:
  #
  #   class Person
  #     def projects
  #       [@project1, @project2]
  #     end
  #
  #     def projects_attributes=(attributes)
  #       # Process the attributes hash
  #     end
  #   end
  #
  # Note that the <tt>projects_attributes=</tt> writer method is in fact
  # required for fields_for to correctly identify <tt>:projects</tt> as a
  # collection, and the correct indices to be set in the form markup.
  #
  # When projects is already an association on Person you can use
  # +accepts_nested_attributes_for+ to define the writer method for you:
  #
  #   class Person < ActiveRecord::Base
  #     has_many :projects
  #     accepts_nested_attributes_for :projects
  #   end
  #
  # This model can now be used with a nested fields_for. The block given to
  # the nested fields_for call will be repeated for each instance in the
  # collection:
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :projects do |project_fields| %>
  #       <% if project_fields.object.active? %>
  #         Name: <%= project_fields.text_field :name %>
  #       <% end %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # It's also possible to specify the instance to be used:
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <% @person.projects.each do |project| %>
  #       <% if project.active? %>
  #         <%= person_form.fields_for :projects, project do |project_fields| %>
  #           Name: <%= project_fields.text_field :name %>
  #         <% end %>
  #       <% end %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # Or a collection to be used:
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :projects, @active_projects do |project_fields| %>
  #       Name: <%= project_fields.text_field :name %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # If you want to destroy any of the associated models through the
  # form, you have to enable it first using the <tt>:allow_destroy</tt>
  # option for +accepts_nested_attributes_for+:
  #
  #   class Person < ActiveRecord::Base
  #     has_many :projects
  #     accepts_nested_attributes_for :projects, allow_destroy: true
  #   end
  #
  # This will allow you to specify which models to destroy in the
  # attributes hash by adding a form element for the <tt>_destroy</tt>
  # parameter with a value that evaluates to +true+
  # (e.g. 1, '1', true, or 'true'):
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :projects do |project_fields| %>
  #       Delete: <%= project_fields.check_box :_destroy %>
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # When a collection is used you might want to know the index of each
  # object into the array. For this purpose, the <tt>index</tt> method
  # is available in the FormBuilder object.
  #
  #   <%= form_for @person do |person_form| %>
  #     ...
  #     <%= person_form.fields_for :projects do |project_fields| %>
  #       Project #<%= project_fields.index %>
  #       ...
  #     <% end %>
  #     ...
  #   <% end %>
  #
  # Note that fields_for will automatically generate a hidden field
  # to store the ID of the record. There are circumstances where this
  # hidden field is not needed and you can pass <tt>include_id: false</tt>
  # to prevent fields_for from rendering it automatically.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2257
  def fields_for(record_name, record_object = T.unsafe(nil), fields_options = T.unsafe(nil), &block); end

  # Returns a file upload input tag tailored for accessing a specified attribute (identified by +method+) on an object
  # assigned to the template (identified by +object+). Additional options on the input tag can be passed as a
  # hash with +options+. These options will be tagged onto the HTML as an HTML element attribute as in the example
  # shown.
  #
  # Using this method inside a +form_with+ block will set the enclosing form's encoding to <tt>multipart/form-data</tt>.
  #
  # ==== Options
  # * Creates standard HTML attributes for the tag.
  # * <tt>:disabled</tt> - If set to true, the user will not be able to use this input.
  # * <tt>:multiple</tt> - If set to true, *in most updated browsers* the user will be allowed to select multiple files.
  # * <tt>:include_hidden</tt> - When <tt>multiple: true</tt> and <tt>include_hidden: true</tt>, the field will be prefixed with an <tt><input type="hidden"></tt> field with an empty value to support submitting an empty collection of files.
  # * <tt>:accept</tt> - If set to one or multiple mime-types, the user will be suggested a filter when choosing a file. You still need to set up model validations.
  #
  # ==== Examples
  #   # Let's say that @user has avatar:
  #   file_field(:avatar)
  #   # => <input type="file" id="user_avatar" name="user[avatar]" />
  #
  #   # Let's say that @post has image:
  #   file_field(:image, :multiple => true)
  #   # => <input type="file" id="post_image" name="post[image][]" multiple="multiple" />
  #
  #   # Let's say that @post has attached:
  #   file_field(:attached, accept: 'text/html')
  #   # => <input accept="text/html" type="file" id="post_attached" name="post[attached]" />
  #
  #   # Let's say that @post has image:
  #   file_field(:image, accept: 'image/png,image/gif,image/jpeg')
  #   # => <input type="file" id="post_image" name="post[image]" accept="image/png,image/gif,image/jpeg" />
  #
  #   # Let's say that @attachment has file:
  #   file_field(:file, class: 'file_input')
  #   # => <input type="file" id="attachment_file" name="attachment[file]" class="file_input" />
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2521
  def file_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::FormOptionsHelper#grouped_collection_select for form builders:
  #
  #   <%= form_for @city do |f| %>
  #     <%= f.grouped_collection_select :country_id, @continents, :countries, :name, :id, :name %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#869
  def grouped_collection_select(method, collection, group_method, group_label_method, option_key_method, option_value_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # Returns a hidden input tag tailored for accessing a specified attribute (identified by +method+) on an object
  # assigned to the template (identified by +object+). Additional options on the input tag can be passed as a
  # hash with +options+. These options will be tagged onto the HTML as an HTML element attribute as in the example
  # shown.
  #
  # ==== Examples
  #   # Let's say that @signup.pass_confirm returns true:
  #   hidden_field(:pass_confirm)
  #   # => <input type="hidden" id="signup_pass_confirm" name="signup[pass_confirm]" value="true" />
  #
  #   # Let's say that @post.tag_list returns "blog, ruby":
  #   hidden_field(:tag_list)
  #   # => <input type="hidden" id="post_tag_list" name="post[tag_list]" value="blog, ruby" />
  #
  #   # Let's say that @user.token returns "abcde":
  #   hidden_field(:token)
  #   # => <input type="hidden" id="user_token" name="user[token]" value="abcde" />
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2482
  def hidden_field(method, options = T.unsafe(nil)); end

  # Generate an HTML <tt>id</tt> attribute value.
  #
  # return the <tt><form></tt> element's <tt>id</tt> attribute.
  #
  #   <%= form_for @post do |f| %>
  #     <%# ... %>
  #
  #     <% content_for :sticky_footer do %>
  #       <%= form.button(form: f.id) %>
  #     <% end %>
  #   <% end %>
  #
  # In the example above, the <tt>:sticky_footer</tt> content area will
  # exist outside of the <tt><form></tt> element. By declaring the
  # <tt>form</tt> HTML attribute, we hint to the browser that the generated
  # <tt><button></tt> element should be treated as the <tt><form></tt>
  # element's submit button, regardless of where it exists in the DOM.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1737
  def id; end

  # Returns the value of attribute index.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1677
  def index; end

  # Returns a label tag tailored for labelling an input field for a specified attribute (identified by +method+) on an object
  # assigned to the template (identified by +object+). The text of label will default to the attribute name unless a translation
  # is found in the current I18n locale (through <tt>helpers.label.<modelname>.<attribute></tt>) or you specify it explicitly.
  # Additional options on the label tag can be passed as a hash with +options+. These options will be tagged
  # onto the HTML as an HTML element attribute as in the example shown, except for the <tt>:value</tt> option, which is designed to
  # target labels for radio_button tags (where the value is used in the ID of the input tag).
  #
  # ==== Examples
  #   label(:title)
  #   # => <label for="post_title">Title</label>
  #
  # You can localize your labels based on model and attribute names.
  # For example you can define the following in your locale (e.g. en.yml)
  #
  #   helpers:
  #     label:
  #       post:
  #         body: "Write your entire text here"
  #
  # Which then will result in
  #
  #   label(:body)
  #   # => <label for="post_body">Write your entire text here</label>
  #
  # Localization can also be based purely on the translation of the attribute-name
  # (if you are using ActiveRecord):
  #
  #   activerecord:
  #     attributes:
  #       post:
  #         cost: "Total cost"
  #
  #   label(:cost)
  #   # => <label for="post_cost">Total cost</label>
  #
  #   label(:title, "A short title")
  #   # => <label for="post_title">A short title</label>
  #
  #   label(:title, "A short title", class: "title_label")
  #   # => <label for="post_title" class="title_label">A short title</label>
  #
  #   label(:privacy, "Public Post", value: "public")
  #   # => <label for="post_privacy_public">Public Post</label>
  #
  #   label(:cost) do |translation|
  #     content_tag(:span, translation, class: "cost_label")
  #   end
  #   # => <label for="post_cost"><span class="cost_label">Total cost</span></label>
  #
  #   label(:cost) do |builder|
  #     content_tag(:span, builder.translation, class: "cost_label")
  #   end
  #   # => <label for="post_cost"><span class="cost_label">Total cost</span></label>
  #
  #   label(:cost) do |builder|
  #     content_tag(:span, builder.translation, class: [
  #       "cost_label",
  #       ("error_label" if builder.object.errors.include?(:cost))
  #     ])
  #   end
  #   # => <label for="post_cost"><span class="cost_label error_label">Total cost</span></label>
  #
  #   label(:terms) do
  #     raw('Accept <a href="/terms">Terms</a>.')
  #   end
  #   # => <label for="post_terms">Accept <a href="/terms">Terms</a>.</label>
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2369
  def label(method, text = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def month_field(method, options = T.unsafe(nil)); end

  # Returns the value of attribute multipart.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1677
  def multipart; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1680
  def multipart=(multipart); end

  # Returns the value of attribute multipart.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1677
  def multipart?; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def number_field(method, options = T.unsafe(nil)); end

  # Returns the value of attribute object.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def object; end

  # Sets the attribute object
  #
  # @param value the value to set the attribute object to.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def object=(_arg0); end

  # Returns the value of attribute object_name.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def object_name; end

  # Sets the attribute object_name
  #
  # @param value the value to set the attribute object_name to.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def object_name=(_arg0); end

  # Returns the value of attribute options.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1675
  def options=(_arg0); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def password_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def phone_field(method, options = T.unsafe(nil)); end

  # Returns a radio button tag for accessing a specified attribute (identified by +method+) on an object
  # assigned to the template (identified by +object+). If the current value of +method+ is +tag_value+ the
  # radio button will be checked.
  #
  # To force the radio button to be checked pass <tt>checked: true</tt> in the
  # +options+ hash. You may pass HTML options there as well.
  #
  #   # Let's say that @post.category returns "rails":
  #   radio_button("category", "rails")
  #   radio_button("category", "java")
  #   # => <input type="radio" id="post_category_rails" name="post[category]" value="rails" checked="checked" />
  #   #    <input type="radio" id="post_category_java" name="post[category]" value="java" />
  #
  #   # Let's say that @user.receive_newsletter returns "no":
  #   radio_button("receive_newsletter", "yes")
  #   radio_button("receive_newsletter", "no")
  #   # => <input type="radio" id="user_receive_newsletter_yes" name="user[receive_newsletter]" value="yes" />
  #   #    <input type="radio" id="user_receive_newsletter_no" name="user[receive_newsletter]" value="no" checked="checked" />
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2460
  def radio_button(method, tag_value, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def range_field(method, options = T.unsafe(nil)); end

  def rich_text_area(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def search_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::FormOptionsHelper#select for form builders:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.select :person_id, Person.all.collect { |p| [ p.name, p.id ] }, include_blank: true %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#845
  def select(method, choices = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Add the submit button for the given form. When no value is given, it checks
  # if the object is a new resource or not to create the proper label:
  #
  #   <%= form_for @post do |f| %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # In the example above, if <tt>@post</tt> is a new record, it will use "Create Post" as
  # submit button label; otherwise, it uses "Update Post".
  #
  # Those labels can be customized using I18n under the +helpers.submit+ key and using
  # <tt>%{model}</tt> for translation interpolation:
  #
  #   en:
  #     helpers:
  #       submit:
  #         create: "Create a %{model}"
  #         update: "Confirm changes to %{model}"
  #
  # It also searches for a key specific to the given object:
  #
  #   en:
  #     helpers:
  #       submit:
  #         post:
  #           create: "Add %{model}"
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2553
  def submit(value = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def telephone_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def text_area(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def text_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def time_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::DateHelper#time_select for form builders:
  #
  #   <%= form_for @race do |f| %>
  #     <%= f.time_select :average_lap %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/date_helper.rb#1241
  def time_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::FormOptionsHelper#time_zone_select for form builders:
  #
  #   <%= form_for @user do |f| %>
  #     <%= f.time_zone_select :time_zone, nil, include_blank: true %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#881
  def time_zone_select(method, priority_zones = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1696
  def to_model; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1692
  def to_partial_path; end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def url_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2006
  def week_field(method, options = T.unsafe(nil)); end

  # Wraps ActionView::Helpers::FormOptionsHelper#weekday_select for form builders:
  #
  #   <%= form_for @user do |f| %>
  #     <%= f.weekday_select :weekday, include_blank: true %>
  #     <%= f.submit %>
  #   <% end %>
  #
  # Please refer to the documentation of the base helper for details.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#893
  def weekday_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  private

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2720
  def convert_to_legacy_options(options); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2702
  def fields_for_nested_model(name, object, fields_options, block); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2673
  def fields_for_with_nested_attributes(association_name, association, options, block); end

  # @return [Boolean]
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2669
  def nested_attributes_association?(association_name); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2715
  def nested_child_index(name); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2640
  def objectify_options(options); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#2646
  def submit_default_value; end

  class << self
    # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1688
    def _to_partial_path; end

    # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
    def field_helpers; end

    # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
    def field_helpers=(value); end

    # source://actionview/7.0.4/lib/action_view/helpers/form_helper.rb#1665
    def field_helpers?; end
  end
end

# Provides a number of methods for turning different kinds of containers into a set of option tags.
#
# The <tt>collection_select</tt>, <tt>select</tt> and <tt>time_zone_select</tt> methods take an <tt>options</tt> parameter, a hash:
#
# * <tt>:include_blank</tt> - set to true or a prompt string if the first option element of the select element is a blank. Useful if there is not a default value required for the select element.
#
#     select(:post, :category, Post::CATEGORIES, { include_blank: true })
#
#   could become:
#
#     <select name="post[category]" id="post_category">
#       <option value="" label=" "></option>
#       <option value="joke">joke</option>
#       <option value="poem">poem</option>
#     </select>
#
#   Another common case is a select tag for a <tt>belongs_to</tt>-associated object.
#
#   Example with <tt>@post.person_id => 2</tt>:
#
#     select(:post, :person_id, Person.all.collect { |p| [ p.name, p.id ] }, { include_blank: "None" })
#
#   could become:
#
#     <select name="post[person_id]" id="post_person_id">
#       <option value="">None</option>
#       <option value="1">David</option>
#       <option value="2" selected="selected">Eileen</option>
#       <option value="3">Rafael</option>
#     </select>
#
# * <tt>:prompt</tt> - set to true or a prompt string. When the select element doesn't have a value yet, this prepends an option with a generic prompt -- "Please select" -- or the given prompt string.
#
#     select(:post, :person_id, Person.all.collect { |p| [ p.name, p.id ] }, { prompt: "Select Person" })
#
#   could become:
#
#     <select name="post[person_id]" id="post_person_id">
#       <option value="">Select Person</option>
#       <option value="1">David</option>
#       <option value="2">Eileen</option>
#       <option value="3">Rafael</option>
#     </select>
#
# * <tt>:index</tt> - like the other form helpers, <tt>select</tt> can accept an <tt>:index</tt> option to manually set the ID used in the resulting output. Unlike other helpers, <tt>select</tt> expects this
#   option to be in the +html_options+ parameter.
#
#     select("album[]", :genre, %w[ rap rock country ], {}, { index: nil })
#
#   becomes:
#
#     <select name="album[][genre]" id="album__genre">
#       <option value="rap">rap</option>
#       <option value="rock">rock</option>
#       <option value="country">country</option>
#     </select>
#
# * <tt>:disabled</tt> - can be a single value or an array of values that will be disabled options in the final output.
#
#     select(:post, :category, Post::CATEGORIES, { disabled: "restricted" })
#
#   could become:
#
#     <select name="post[category]" id="post_category">
#       <option value="joke">joke</option>
#       <option value="poem">poem</option>
#       <option disabled="disabled" value="restricted">restricted</option>
#     </select>
#
#   When used with the <tt>collection_select</tt> helper, <tt>:disabled</tt> can also be a Proc that identifies those options that should be disabled.
#
#     collection_select(:post, :category_id, Category.all, :id, :name, { disabled: -> (category) { category.archived? } })
#
#   If the categories "2008 stuff" and "Christmas" return true when the method <tt>archived?</tt> is called, this would return:
#     <select name="post[category_id]" id="post_category_id">
#       <option value="1" disabled="disabled">2008 stuff</option>
#       <option value="2" disabled="disabled">Christmas</option>
#       <option value="3">Jokes</option>
#       <option value="4">Poems</option>
#     </select>
module ActionView::Helpers::FormOptionsHelper
  include ::ActionView::Helpers::SanitizeHelper
  include ::ActionView::Helpers::CaptureHelper
  include ::ActionView::Helpers::OutputSafetyHelper
  include ::ActionView::Helpers::TagHelper
  include ::ActionView::Helpers::TextHelper
  extend ::ActionView::Helpers::SanitizeHelper::ClassMethods

  # Returns check box tags for the collection of existing return values of
  # +method+ for +object+'s class. The value returned from calling +method+
  # on the instance +object+ will be selected. If calling +method+ returns
  # +nil+, no selection is made.
  #
  # The <tt>:value_method</tt> and <tt>:text_method</tt> parameters are
  # methods to be called on each member of +collection+. The return values
  # are used as the +value+ attribute and contents of each check box tag,
  # respectively. They can also be any object that responds to +call+, such
  # as a +proc+, that will be called for each member of the +collection+ to
  # retrieve the value/text.
  #
  # Example object structure for use with this method:
  #   class Post < ActiveRecord::Base
  #     has_and_belongs_to_many :authors
  #   end
  #   class Author < ActiveRecord::Base
  #     has_and_belongs_to_many :posts
  #     def name_with_initial
  #       "#{first_name.first}. #{last_name}"
  #     end
  #   end
  #
  # Sample usage (selecting the associated Author for an instance of Post, <tt>@post</tt>):
  #   collection_check_boxes(:post, :author_ids, Author.all, :id, :name_with_initial)
  #
  # If <tt>@post.author_ids</tt> is already <tt>[1]</tt>, this would return:
  #   <input id="post_author_ids_1" name="post[author_ids][]" type="checkbox" value="1" checked="checked" />
  #   <label for="post_author_ids_1">D. Heinemeier Hansson</label>
  #   <input id="post_author_ids_2" name="post[author_ids][]" type="checkbox" value="2" />
  #   <label for="post_author_ids_2">D. Thomas</label>
  #   <input id="post_author_ids_3" name="post[author_ids][]" type="checkbox" value="3" />
  #   <label for="post_author_ids_3">M. Clark</label>
  #   <input name="post[author_ids][]" type="hidden" value="" />
  #
  # It is also possible to customize the way the elements will be shown by
  # giving a block to the method:
  #   collection_check_boxes(:post, :author_ids, Author.all, :id, :name_with_initial) do |b|
  #     b.label { b.check_box }
  #   end
  #
  # The argument passed to the block is a special kind of builder for this
  # collection, which has the ability to generate the label and check box
  # for the current item in the collection, with proper text and value.
  # Using it, you can change the label and check box display order or even
  # use the label as wrapper, as in the example above.
  #
  # The builder methods <tt>label</tt> and <tt>check_box</tt> also accept
  # extra HTML options:
  #   collection_check_boxes(:post, :author_ids, Author.all, :id, :name_with_initial) do |b|
  #     b.label(class: "check_box") { b.check_box(class: "check_box") }
  #   end
  #
  # There are also three special methods available: <tt>object</tt>, <tt>text</tt> and
  # <tt>value</tt>, which are the current item being rendered, its text and value methods,
  # respectively. You can use them like this:
  #   collection_check_boxes(:post, :author_ids, Author.all, :id, :name_with_initial) do |b|
  #      b.label(:"data-value" => b.value) { b.check_box + b.text }
  #   end
  #
  # ==== Gotcha
  #
  # When no selection is made for a collection of checkboxes most
  # web browsers will not send any value.
  #
  # For example, if we have a +User+ model with +category_ids+ field and we
  # have the following code in our update action:
  #
  #   @user.update(params[:user])
  #
  # If no +category_ids+ are selected then we can safely assume this field
  # will not be updated.
  #
  # This is possible thanks to a hidden field generated by the helper method
  # for every collection of checkboxes.
  # This hidden field is given the same field name as the checkboxes with a
  # blank value.
  #
  # In the rare case you don't want this hidden field, you can pass the
  # <tt>include_hidden: false</tt> option to the helper method.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#779
  def collection_check_boxes(object, method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Returns radio button tags for the collection of existing return values
  # of +method+ for +object+'s class. The value returned from calling
  # +method+ on the instance +object+ will be selected. If calling +method+
  # returns +nil+, no selection is made.
  #
  # The <tt>:value_method</tt> and <tt>:text_method</tt> parameters are
  # methods to be called on each member of +collection+. The return values
  # are used as the +value+ attribute and contents of each radio button tag,
  # respectively. They can also be any object that responds to +call+, such
  # as a +proc+, that will be called for each member of the +collection+ to
  # retrieve the value/text.
  #
  # Example object structure for use with this method:
  #
  #   class Post < ActiveRecord::Base
  #     belongs_to :author
  #   end
  #
  #   class Author < ActiveRecord::Base
  #     has_many :posts
  #
  #     def name_with_initial
  #       "#{first_name.first}. #{last_name}"
  #     end
  #   end
  #
  # Sample usage (selecting the associated Author for an instance of Post, <tt>@post</tt>):
  #   collection_radio_buttons(:post, :author_id, Author.all, :id, :name_with_initial)
  #
  # If <tt>@post.author_id</tt> is already <tt>1</tt>, this would return:
  #   <input id="post_author_id_1" name="post[author_id]" type="radio" value="1" checked="checked" />
  #   <label for="post_author_id_1">D. Heinemeier Hansson</label>
  #   <input id="post_author_id_2" name="post[author_id]" type="radio" value="2" />
  #   <label for="post_author_id_2">D. Thomas</label>
  #   <input id="post_author_id_3" name="post[author_id]" type="radio" value="3" />
  #   <label for="post_author_id_3">M. Clark</label>
  #
  # It is also possible to customize the way the elements will be shown by
  # giving a block to the method:
  #   collection_radio_buttons(:post, :author_id, Author.all, :id, :name_with_initial) do |b|
  #     b.label { b.radio_button }
  #   end
  #
  # The argument passed to the block is a special kind of builder for this
  # collection, which has the ability to generate the label and radio button
  # for the current item in the collection, with proper text and value.
  # Using it, you can change the label and radio button display order or
  # even use the label as wrapper, as in the example above.
  #
  # The builder methods <tt>label</tt> and <tt>radio_button</tt> also accept
  # extra HTML options:
  #   collection_radio_buttons(:post, :author_id, Author.all, :id, :name_with_initial) do |b|
  #     b.label(class: "radio_button") { b.radio_button(class: "radio_button") }
  #   end
  #
  # There are also three special methods available: <tt>object</tt>, <tt>text</tt> and
  # <tt>value</tt>, which are the current item being rendered, its text and value methods,
  # respectively. You can use them like this:
  #   collection_radio_buttons(:post, :author_id, Author.all, :id, :name_with_initial) do |b|
  #      b.label(:"data-value" => b.value) { b.radio_button + b.text }
  #   end
  #
  # ==== Gotcha
  #
  # The HTML specification says when nothing is selected on a collection of radio buttons
  # web browsers do not send any value to server.
  # Unfortunately this introduces a gotcha:
  # if a +User+ model has a +category_id+ field and in the form no category is selected, no +category_id+ parameter is sent. So,
  # any strong parameters idiom like:
  #
  #   params.require(:user).permit(...)
  #
  # will raise an error since no <tt>{user: ...}</tt> will be present.
  #
  # To prevent this the helper generates an auxiliary hidden field before
  # every collection of radio buttons. The hidden field has the same name as collection radio button and blank value.
  #
  # In case if you don't want the helper to generate this hidden field you can specify
  # <tt>include_hidden: false</tt> option.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#695
  def collection_radio_buttons(object, method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Returns <tt><select></tt> and <tt><option></tt> tags for the collection of existing return values of
  # +method+ for +object+'s class. The value returned from calling +method+ on the instance +object+ will
  # be selected. If calling +method+ returns +nil+, no selection is made without including <tt>:prompt</tt>
  # or <tt>:include_blank</tt> in the +options+ hash.
  #
  # The <tt>:value_method</tt> and <tt>:text_method</tt> parameters are methods to be called on each member
  # of +collection+. The return values are used as the +value+ attribute and contents of each
  # <tt><option></tt> tag, respectively. They can also be any object that responds to +call+, such
  # as a +proc+, that will be called for each member of the +collection+ to
  # retrieve the value/text.
  #
  # Example object structure for use with this method:
  #
  #   class Post < ActiveRecord::Base
  #     belongs_to :author
  #   end
  #
  #   class Author < ActiveRecord::Base
  #     has_many :posts
  #
  #     def name_with_initial
  #       "#{first_name.first}. #{last_name}"
  #     end
  #   end
  #
  # Sample usage (selecting the associated Author for an instance of Post, <tt>@post</tt>):
  #
  #   collection_select(:post, :author_id, Author.all, :id, :name_with_initial, prompt: true)
  #
  # If <tt>@post.author_id</tt> is already <tt>1</tt>, this would return:
  #   <select name="post[author_id]" id="post_author_id">
  #     <option value="">Please select</option>
  #     <option value="1" selected="selected">D. Heinemeier Hansson</option>
  #     <option value="2">D. Thomas</option>
  #     <option value="3">M. Clark</option>
  #   </select>
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#198
  def collection_select(object, method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://country_select//lib/country_select/country_select_helper.rb#22
  def country_select(object, method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # Returns <tt><select></tt>, <tt><optgroup></tt> and <tt><option></tt> tags for the collection of existing return values of
  # +method+ for +object+'s class. The value returned from calling +method+ on the instance +object+ will
  # be selected. If calling +method+ returns +nil+, no selection is made without including <tt>:prompt</tt>
  # or <tt>:include_blank</tt> in the +options+ hash.
  #
  # Parameters:
  # * +object+ - The instance of the class to be used for the select tag
  # * +method+ - The attribute of +object+ corresponding to the select tag
  # * +collection+ - An array of objects representing the <tt><optgroup></tt> tags.
  # * +group_method+ - The name of a method which, when called on a member of +collection+, returns an
  #   array of child objects representing the <tt><option></tt> tags. It can also be any object that responds
  #   to +call+, such as a +proc+, that will be called for each member of the +collection+ to retrieve the
  #   value.
  # * +group_label_method+ - The name of a method which, when called on a member of +collection+, returns a
  #   string to be used as the +label+ attribute for its <tt><optgroup></tt> tag. It can also be any object
  #   that responds to +call+, such as a +proc+, that will be called for each member of the +collection+ to
  #   retrieve the label.
  # * +option_key_method+ - The name of a method which, when called on a child object of a member of
  #   +collection+, returns a value to be used as the +value+ attribute for its <tt><option></tt> tag.
  # * +option_value_method+ - The name of a method which, when called on a child object of a member of
  #   +collection+, returns a value to be used as the contents of its <tt><option></tt> tag.
  #
  # Example object structure for use with this method:
  #
  #   # attributes: id, name
  #   class Continent < ActiveRecord::Base
  #     has_many :countries
  #   end
  #
  #   # attributes: id, name, continent_id
  #   class Country < ActiveRecord::Base
  #     belongs_to :continent
  #   end
  #
  #   # attributes: id, name, country_id
  #   class City < ActiveRecord::Base
  #     belongs_to :country
  #   end
  #
  # Sample usage:
  #
  #   grouped_collection_select(:city, :country_id, @continents, :countries, :name, :id, :name)
  #
  # Possible output:
  #
  #   <select name="city[country_id]" id="city_country_id">
  #     <optgroup label="Africa">
  #       <option value="1">South Africa</option>
  #       <option value="3">Somalia</option>
  #     </optgroup>
  #     <optgroup label="Europe">
  #       <option value="7" selected="selected">Denmark</option>
  #       <option value="2">Ireland</option>
  #     </optgroup>
  #   </select>
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#257
  def grouped_collection_select(object, method, collection, group_method, group_label_method, option_key_method, option_value_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # Returns a string of <tt><option></tt> tags, like <tt>options_for_select</tt>, but
  # wraps them with <tt><optgroup></tt> tags:
  #
  #   grouped_options = [
  #    ['North America',
  #      [['United States','US'],'Canada']],
  #    ['Europe',
  #      ['Denmark','Germany','France']]
  #   ]
  #   grouped_options_for_select(grouped_options)
  #
  #   grouped_options = {
  #     'North America' => [['United States','US'], 'Canada'],
  #     'Europe' => ['Denmark','Germany','France']
  #   }
  #   grouped_options_for_select(grouped_options)
  #
  # Possible output:
  #   <optgroup label="North America">
  #     <option value="US">United States</option>
  #     <option value="Canada">Canada</option>
  #   </optgroup>
  #   <optgroup label="Europe">
  #     <option value="Denmark">Denmark</option>
  #     <option value="Germany">Germany</option>
  #     <option value="France">France</option>
  #   </optgroup>
  #
  # Parameters:
  # * +grouped_options+ - Accepts a nested array or hash of strings. The first value serves as the
  #   <tt><optgroup></tt> label while the second value must be an array of options. The second value can be a
  #   nested array of text-value pairs. See <tt>options_for_select</tt> for more info.
  #    Ex. ["North America",[["United States","US"],["Canada","CA"]]]
  # * +selected_key+ - A value equal to the +value+ attribute for one of the <tt><option></tt> tags,
  #   which will have the +selected+ attribute set. Note: It is possible for this value to match multiple options
  #   as you might have the same option in multiple groups. Each will then get <tt>selected="selected"</tt>.
  #
  # Options:
  # * <tt>:prompt</tt> - set to true or a prompt string. When the select element doesn't have a value yet, this
  #   prepends an option with a generic prompt - "Please select" - or the given prompt string.
  # * <tt>:divider</tt> - the divider for the options groups.
  #
  #     grouped_options = [
  #       [['United States','US'], 'Canada'],
  #       ['Denmark','Germany','France']
  #     ]
  #     grouped_options_for_select(grouped_options, nil, divider: '---------')
  #
  #   Possible output:
  #     <optgroup label="---------">
  #       <option value="US">United States</option>
  #       <option value="Canada">Canada</option>
  #     </optgroup>
  #     <optgroup label="---------">
  #       <option value="Denmark">Denmark</option>
  #       <option value="Germany">Germany</option>
  #       <option value="France">France</option>
  #     </optgroup>
  #
  # <b>Note:</b> Only the <tt><optgroup></tt> and <tt><option></tt> tags are returned, so you still have to
  # wrap the output in an appropriate <tt><select></tt> tag.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#531
  def grouped_options_for_select(grouped_options, selected_key = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a string of <tt><option></tt> tags, like <tt>options_from_collection_for_select</tt>, but
  # groups them by <tt><optgroup></tt> tags based on the object relationships of the arguments.
  #
  # Parameters:
  # * +collection+ - An array of objects representing the <tt><optgroup></tt> tags.
  # * +group_method+ - The name of a method which, when called on a member of +collection+, returns an
  #   array of child objects representing the <tt><option></tt> tags.
  # * +group_label_method+ - The name of a method which, when called on a member of +collection+, returns a
  #   string to be used as the +label+ attribute for its <tt><optgroup></tt> tag.
  # * +option_key_method+ - The name of a method which, when called on a child object of a member of
  #   +collection+, returns a value to be used as the +value+ attribute for its <tt><option></tt> tag.
  # * +option_value_method+ - The name of a method which, when called on a child object of a member of
  #   +collection+, returns a value to be used as the contents of its <tt><option></tt> tag.
  # * +selected_key+ - A value equal to the +value+ attribute for one of the <tt><option></tt> tags,
  #   which will have the +selected+ attribute set. Corresponds to the return value of one of the calls
  #   to +option_key_method+. If +nil+, no selection is made. Can also be a hash if disabled values are
  #   to be specified.
  #
  # Example object structure for use with this method:
  #
  #   class Continent < ActiveRecord::Base
  #     has_many :countries
  #     # attribs: id, name
  #   end
  #
  #   class Country < ActiveRecord::Base
  #     belongs_to :continent
  #     # attribs: id, name, continent_id
  #   end
  #
  # Sample usage:
  #   option_groups_from_collection_for_select(@continents, :countries, :name, :id, :name, 3)
  #
  # Possible output:
  #   <optgroup label="Africa">
  #     <option value="1">Egypt</option>
  #     <option value="4">Rwanda</option>
  #     ...
  #   </optgroup>
  #   <optgroup label="Asia">
  #     <option value="3" selected="selected">China</option>
  #     <option value="12">India</option>
  #     <option value="5">Japan</option>
  #     ...
  #   </optgroup>
  #
  # <b>Note:</b> Only the <tt><optgroup></tt> and <tt><option></tt> tags are returned, so you still have to
  # wrap the output in an appropriate <tt><select></tt> tag.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#461
  def option_groups_from_collection_for_select(collection, group_method, group_label_method, option_key_method, option_value_method, selected_key = T.unsafe(nil)); end

  # Accepts a container (hash, array, enumerable, your type) and returns a string of option tags. Given a container
  # where the elements respond to first and last (such as a two-element array), the "lasts" serve as option values and
  # the "firsts" as option text. Hashes are turned into this form automatically, so the keys become "firsts" and values
  # become lasts. If +selected+ is specified, the matching "last" or element will get the selected option-tag. +selected+
  # may also be an array of values to be selected when using a multiple select.
  #
  #   options_for_select([["Dollar", "$"], ["Kroner", "DKK"]])
  #   # => <option value="$">Dollar</option>
  #   # => <option value="DKK">Kroner</option>
  #
  #   options_for_select([ "VISA", "MasterCard" ], "MasterCard")
  #   # => <option value="VISA">VISA</option>
  #   # => <option selected="selected" value="MasterCard">MasterCard</option>
  #
  #   options_for_select({ "Basic" => "$20", "Plus" => "$40" }, "$40")
  #   # => <option value="$20">Basic</option>
  #   # => <option value="$40" selected="selected">Plus</option>
  #
  #   options_for_select([ "VISA", "MasterCard", "Discover" ], ["VISA", "Discover"])
  #   # => <option selected="selected" value="VISA">VISA</option>
  #   # => <option value="MasterCard">MasterCard</option>
  #   # => <option selected="selected" value="Discover">Discover</option>
  #
  # You can optionally provide HTML attributes as the last element of the array.
  #
  #   options_for_select([ "Denmark", ["USA", { class: 'bold' }], "Sweden" ], ["USA", "Sweden"])
  #   # => <option value="Denmark">Denmark</option>
  #   # => <option value="USA" class="bold" selected="selected">USA</option>
  #   # => <option value="Sweden" selected="selected">Sweden</option>
  #
  #   options_for_select([["Dollar", "$", { class: "bold" }], ["Kroner", "DKK", { onclick: "alert('HI');" }]])
  #   # => <option value="$" class="bold">Dollar</option>
  #   # => <option value="DKK" onclick="alert('HI');">Kroner</option>
  #
  # If you wish to specify disabled option tags, set +selected+ to be a hash, with <tt>:disabled</tt> being either a value
  # or array of values to be disabled. In this case, you can use <tt>:selected</tt> to specify selected option tags.
  #
  #   options_for_select(["Free", "Basic", "Advanced", "Super Platinum"], disabled: "Super Platinum")
  #   # => <option value="Free">Free</option>
  #   # => <option value="Basic">Basic</option>
  #   # => <option value="Advanced">Advanced</option>
  #   # => <option value="Super Platinum" disabled="disabled">Super Platinum</option>
  #
  #   options_for_select(["Free", "Basic", "Advanced", "Super Platinum"], disabled: ["Advanced", "Super Platinum"])
  #   # => <option value="Free">Free</option>
  #   # => <option value="Basic">Basic</option>
  #   # => <option value="Advanced" disabled="disabled">Advanced</option>
  #   # => <option value="Super Platinum" disabled="disabled">Super Platinum</option>
  #
  #   options_for_select(["Free", "Basic", "Advanced", "Super Platinum"], selected: "Free", disabled: "Super Platinum")
  #   # => <option value="Free" selected="selected">Free</option>
  #   # => <option value="Basic">Basic</option>
  #   # => <option value="Advanced">Advanced</option>
  #   # => <option value="Super Platinum" disabled="disabled">Super Platinum</option>
  #
  # NOTE: Only the option tags are returned, you have to wrap this call in a regular HTML select tag.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#357
  def options_for_select(container, selected = T.unsafe(nil)); end

  # Returns a string of option tags that have been compiled by iterating over the +collection+ and assigning
  # the result of a call to the +value_method+ as the option value and the +text_method+ as the option text.
  #
  #   options_from_collection_for_select(@people, 'id', 'name')
  #   # => <option value="#{person.id}">#{person.name}</option>
  #
  # This is more often than not used inside a #select_tag like this example:
  #
  #   select_tag 'person', options_from_collection_for_select(@people, 'id', 'name')
  #
  # If +selected+ is specified as a value or array of values, the element(s) returning a match on +value_method+
  # will be selected option tag(s).
  #
  # If +selected+ is specified as a Proc, those members of the collection that return true for the anonymous
  # function are the selected values.
  #
  # +selected+ can also be a hash, specifying both <tt>:selected</tt> and/or <tt>:disabled</tt> values as required.
  #
  # Be sure to specify the same class as the +value_method+ when specifying selected or disabled options.
  # Failure to do this will produce undesired results. Example:
  #   options_from_collection_for_select(@people, 'id', 'name', '1')
  # Will not select a person with the id of 1 because 1 (an Integer) is not the same as '1' (a string)
  #   options_from_collection_for_select(@people, 'id', 'name', 1)
  # should produce the desired results.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#400
  def options_from_collection_for_select(collection, value_method, text_method, selected = T.unsafe(nil)); end

  # Create a select tag and a series of contained option tags for the provided object and method.
  # The option currently held by the object will be selected, provided that the object is available.
  #
  # There are two possible formats for the +choices+ parameter, corresponding to other helpers' output:
  #
  # * A flat collection (see <tt>options_for_select</tt>).
  # * A nested collection (see <tt>grouped_options_for_select</tt>).
  #
  # Example with <tt>@post.person_id => 2</tt>:
  #
  #   select :post, :person_id, Person.all.collect { |p| [ p.name, p.id ] }, { include_blank: true })
  #
  # would become:
  #
  #   <select name="post[person_id]" id="post_person_id">
  #     <option value="" label=" "></option>
  #     <option value="1">David</option>
  #     <option value="2" selected="selected">Eileen</option>
  #     <option value="3">Rafael</option>
  #   </select>
  #
  # This can be used to provide a default set of options in the standard way: before rendering the create form, a
  # new model instance is assigned the default options and bound to @model_name. Usually this model is not saved
  # to the database. Instead, a second model object is created when the create request is received.
  # This allows the user to submit a form page more than once with the expected results of creating multiple records.
  # In addition, this allows a single partial to be used to generate form inputs for both edit and create forms.
  #
  # By default, <tt>post.person_id</tt> is the selected option. Specify <tt>selected: value</tt> to use a different selection
  # or <tt>selected: nil</tt> to leave all options unselected. Similarly, you can specify values to be disabled in the option
  # tags by specifying the <tt>:disabled</tt> option. This can either be a single value or an array of values to be disabled.
  #
  # A block can be passed to +select+ to customize how the options tags will be rendered. This
  # is useful when the options tag has complex attributes.
  #
  #   select(report, :campaign_ids) do
  #     available_campaigns.each do |c|
  #       tag.option(c.name, value: c.id, data: { tags: c.tags.to_json })
  #     end
  #   end
  #
  # ==== Gotcha
  #
  # The HTML specification says when +multiple+ parameter passed to select and all options got deselected
  # web browsers do not send any value to server. Unfortunately this introduces a gotcha:
  # if a +User+ model has many +roles+ and have +role_ids+ accessor, and in the form that edits roles of the user
  # the user deselects all roles from +role_ids+ multiple select box, no +role_ids+ parameter is sent. So,
  # any mass-assignment idiom like
  #
  #   @user.update(params[:user])
  #
  # wouldn't update roles.
  #
  # To prevent this the helper generates an auxiliary hidden field before
  # every multiple select. The hidden field has the same name as multiple select and blank value.
  #
  # <b>Note:</b> The client either sends only the hidden field (representing
  # the deselected multiple select box), or both fields. This means that the resulting array
  # always contains a blank string.
  #
  # In case if you don't want the helper to generate this hidden field you can specify
  # <tt>include_hidden: false</tt> option.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#158
  def select(object, method, choices = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # Returns a string of option tags for pretty much any time zone in the
  # world. Supply an ActiveSupport::TimeZone name as +selected+ to have it
  # marked as the selected option tag. You can also supply an array of
  # ActiveSupport::TimeZone objects as +priority_zones+, so that they will
  # be listed above the rest of the (long) list. (You can use
  # ActiveSupport::TimeZone.us_zones as a convenience for obtaining a list
  # of the US time zones, or a Regexp to select the zones of your choice)
  #
  # The +selected+ parameter must be either +nil+, or a string that names
  # an ActiveSupport::TimeZone.
  #
  # By default, +model+ is the ActiveSupport::TimeZone constant (which can
  # be obtained in Active Record as a value object). The +model+ parameter
  # must respond to +all+ and return an array of objects that represent time
  # zones; each object must respond to +name+. If a Regexp is given it will
  # attempt to match the zones using <code>match?</code> method.
  #
  # NOTE: Only the option tags are returned, you have to wrap this call in
  # a regular HTML select tag.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#576
  def time_zone_options_for_select(selected = T.unsafe(nil), priority_zones = T.unsafe(nil), model = T.unsafe(nil)); end

  # Returns select and option tags for the given object and method, using
  # #time_zone_options_for_select to generate the list of option tags.
  #
  # In addition to the <tt>:include_blank</tt> option documented above,
  # this method also supports a <tt>:model</tt> option, which defaults
  # to ActiveSupport::TimeZone. This may be used by users to specify a
  # different time zone model object. (See +time_zone_options_for_select+
  # for more information.)
  #
  # You can also supply an array of ActiveSupport::TimeZone objects
  # as +priority_zones+ so that they will be listed above the rest of the
  # (long) list. You can use ActiveSupport::TimeZone.us_zones for a list
  # of US time zones, ActiveSupport::TimeZone.country_zones(country_code)
  # for another country's time zones, or a Regexp to select the zones of
  # your choice.
  #
  # Finally, this method supports a <tt>:default</tt> option, which selects
  # a default ActiveSupport::TimeZone if the object's time zone is +nil+.
  #
  #   time_zone_select(:user, :time_zone, nil, include_blank: true)
  #
  #   time_zone_select(:user, :time_zone, nil, default: "Pacific Time (US & Canada)")
  #
  #   time_zone_select(:user, :time_zone, ActiveSupport::TimeZone.us_zones, default: "Pacific Time (US & Canada)")
  #
  #   time_zone_select(:user, :time_zone, [ ActiveSupport::TimeZone["Alaska"], ActiveSupport::TimeZone["Hawaii"] ])
  #
  #   time_zone_select(:user, :time_zone, /Australia/)
  #
  #   time_zone_select(:user, :time_zone, ActiveSupport::TimeZone.all.sort, model: ActiveSupport::TimeZone)
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#291
  def time_zone_select(object, method, priority_zones = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # Returns a string of option tags for the days of the week.
  #
  # Options:
  # * <tt>:index_as_value</tt> - Defaults to false, set to true to use the indexes from
  #   <tt>I18n.translate("date.day_names")</tt> as the values. By default, Sunday is always 0.
  # * <tt>:day_format</tt> - The I18n key of the array to use for the weekday options.
  #   Defaults to +:day_names+, set to +:abbr_day_names+ for abbreviations.
  # * <tt>:beginning_of_week</tt> - Defaults to Date.beginning_of_week.
  #
  # NOTE: Only the option tags are returned, you have to wrap this call in
  # a regular HTML select tag.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#608
  def weekday_options_for_select(selected = T.unsafe(nil), index_as_value: T.unsafe(nil), day_format: T.unsafe(nil), beginning_of_week: T.unsafe(nil)); end

  # Returns select and option tags for the given object and method, using
  # <tt>weekday_options_for_select</tt> to generate the list of option tags.
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#297
  def weekday_select(object, method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  private

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#806
  def extract_selected_and_disabled(selected); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#817
  def extract_values_from_collection(collection, value_method, selected); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#784
  def option_html_attributes(element); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#792
  def option_text_and_value(option); end

  # @return [Boolean]
  #
  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#802
  def option_value_selected?(value, selected); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#831
  def prompt_text(prompt); end

  # source://actionview/7.0.4/lib/action_view/helpers/form_options_helper.rb#827
  def value_for_collection(item, value); end
end

module ActionView::Helpers::Tags
  extend ::ActiveSupport::Autoload
end

class ActionView::Helpers::Tags::CountrySelect < ::ActionView::Helpers::Tags::Base
  include ::CountrySelect::TagHelper

  # @return [CountrySelect] a new instance of CountrySelect
  #
  # source://country_select//lib/country_select/country_select_helper.rb#31
  def initialize(object_name, method_name, template_object, options, html_options); end

  # source://country_select//lib/country_select/country_select_helper.rb#37
  def render; end
end

class ActionView::Helpers::Tags::DatetimeSelect < ::ActionView::Helpers::Tags::DateSelect; end
class ActionView::Helpers::Tags::EmailField < ::ActionView::Helpers::Tags::TextField; end
class ActionView::Helpers::Tags::RangeField < ::ActionView::Helpers::Tags::NumberField; end
class ActionView::Helpers::Tags::TelField < ::ActionView::Helpers::Tags::TextField; end
class ActionView::Helpers::Tags::TimeSelect < ::ActionView::Helpers::Tags::DateSelect; end
class ActionView::Helpers::Tags::UrlField < ::ActionView::Helpers::Tags::TextField; end
module CountrySelect; end
class CountrySelect::CountryNotFoundError < ::StandardError; end

# source://country_select//lib/country_select/defaults.rb#2
CountrySelect::DEFAULTS = T.let(T.unsafe(nil), Hash)

# source://country_select//lib/country_select/formats.rb#2
CountrySelect::FORMATS = T.let(T.unsafe(nil), Hash)

module CountrySelect::TagHelper
  # source://country_select//lib/country_select/tag_helper.rb#4
  def country_option_tags; end

  private

  # source://country_select//lib/country_select/tag_helper.rb#65
  def all_country_codes; end

  # source://country_select//lib/country_select/tag_helper.rb#61
  def country_options; end

  # source://country_select//lib/country_select/tag_helper.rb#77
  def country_options_for(country_codes, sorted = T.unsafe(nil)); end

  # source://country_select//lib/country_select/tag_helper.rb#53
  def except_country_codes; end

  # source://country_select//lib/country_select/tag_helper.rb#57
  def format; end

  # source://country_select//lib/country_select/tag_helper.rb#109
  def html_safe_newline; end

  # source://country_select//lib/country_select/tag_helper.rb#37
  def locale; end

  # source://country_select//lib/country_select/tag_helper.rb#49
  def only_country_codes; end

  # source://country_select//lib/country_select/tag_helper.rb#41
  def priority_countries; end

  # source://country_select//lib/country_select/tag_helper.rb#45
  def priority_countries_divider; end
end

# source://country_select//lib/country_select/version.rb#2
CountrySelect::VERSION = T.let(T.unsafe(nil), String)
