# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `countries` gem.
# Please instead update this file by running `bin/tapioca gem countries`.

module Countries; end

# source://countries//lib/countries/version.rb#4
Countries::VERSION = T.let(T.unsafe(nil), String)

module ISO3166
  class << self
    # source://countries//lib/countries/country/class_methods.rb#8
    def Country(country_data_or_country); end

    # source://countries//lib/countries/configuration.rb#8
    def configuration; end

    # Sets the attribute configuration
    #
    # @param value the value to set the attribute configuration to.
    #
    # source://countries//lib/countries/configuration.rb#5
    def configuration=(_arg0); end

    # @yield [configuration]
    #
    # source://countries//lib/countries/configuration.rb#17
    def configure; end

    # source://countries//lib/countries/configuration.rb#12
    def reset; end
  end
end

class ISO3166::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://countries//lib/countries/configuration.rb#24
  def initialize; end

  # Enables the integration with the {Money}[https://github.com/RubyMoney/money] gem
  #
  # Please note that it requires you to add "money" gem to your gemfile.
  #
  #   gem "money", "~> 6.9"
  #
  # *WARNING* if you have a top level class named +Money+ you will conflict with this gem.
  #
  # @example
  #   c = ISO3166::Country['us']
  #   c.currency.iso_code # => 'USD'
  #   c.currency.name # => 'United States Dollar'
  #   c.currency.symbol # => '$'
  #
  # source://countries//lib/countries/configuration.rb#42
  def enable_currency_extension!; end

  # Returns the value of attribute loaded_locales.
  #
  # source://countries//lib/countries/configuration.rb#22
  def loaded_locales; end

  # Sets the attribute loaded_locales
  #
  # @param value the value to set the attribute loaded_locales to.
  #
  # source://countries//lib/countries/configuration.rb#22
  def loaded_locales=(_arg0); end

  # Returns the value of attribute locales.
  #
  # source://countries//lib/countries/configuration.rb#22
  def locales; end

  # Sets the attribute locales
  #
  # @param value the value to set the attribute locales to.
  #
  # source://countries//lib/countries/configuration.rb#22
  def locales=(_arg0); end

  private

  # source://countries//lib/countries/configuration.rb#49
  def default_locales; end
end

class ISO3166::Country
  include ::ISO3166::Emoji
  include ::ISO3166::TimezoneExtensions
  extend ::ISO3166::CountryClassMethods
  extend ::ISO3166::CountryFinderMethods

  # @return [Country] a new instance of Country
  #
  # source://countries//lib/countries/country.rb#22
  def initialize(country_data); end

  # source://countries//lib/countries/country.rb#49
  def <=>(other); end

  # source://countries//lib/countries/country.rb#37
  def ==(other); end

  # source://countries//lib/countries/country.rb#11
  def address_format; end

  # source://countries//lib/countries/country.rb#11
  def alpha2; end

  # source://countries//lib/countries/country.rb#11
  def alpha3; end

  # source://countries//lib/countries/country.rb#17
  def bounds; end

  # @return [String] the “common name” of this Country in English.
  #
  # source://countries//lib/countries/country.rb#134
  def common_name; end

  # source://countries//lib/countries/country.rb#11
  def continent; end

  # source://countries//lib/countries/country.rb#11
  def country_code; end

  # source://countries//lib/countries/country.rb#11
  def currency_code; end

  # Returns the value of attribute data.
  #
  # source://countries//lib/countries/country.rb#8
  def data; end

  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#41
  def eql?(other); end

  # source://countries//lib/countries/country.rb#11
  def gec; end

  # source://countries//lib/countries/country.rb#11
  def geo; end

  # source://countries//lib/countries/country.rb#45
  def hash; end

  # @return [Array<String>] the list of humanized subdivision types for this country. Uses ActiveSupport's `#humanize` if available
  #
  # source://countries//lib/countries/country.rb#79
  def humanized_subdivision_types; end

  # +true+ if this country is a member of the European Economic Area.
  #
  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#109
  def in_eea?; end

  # +true+ if this country is a member of the European Single Market.
  #
  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#114
  def in_esm?; end

  # +true+ if this country is a member of the European Union.
  #
  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#104
  def in_eu?; end

  # source://countries//lib/countries/country.rb#11
  def international_prefix; end

  # source://countries//lib/countries/country.rb#11
  def ioc; end

  # source://countries//lib/countries/country.rb#11
  def iso_long_name; end

  # source://countries//lib/countries/country.rb#11
  def iso_short_name; end

  # source://countries//lib/countries/country.rb#11
  def languages; end

  # source://countries//lib/countries/country.rb#11
  def languages_official; end

  # source://countries//lib/countries/country.rb#11
  def languages_spoken; end

  # source://countries//lib/countries/country.rb#17
  def latitude; end

  # @return [String] The name for this Country, in this Country's locale.
  #
  # source://countries//lib/countries/country.rb#148
  def local_name; end

  # @return [Array<String>] TThe list of names for this Country, in this Country's locales.
  #
  # source://countries//lib/countries/country.rb#140
  def local_names; end

  # source://countries//lib/countries/country.rb#17
  def longitude; end

  # source://countries//lib/countries/country.rb#17
  def max_latitude; end

  # source://countries//lib/countries/country.rb#17
  def max_longitude; end

  # source://countries//lib/countries/country.rb#17
  def min_latitude; end

  # source://countries//lib/countries/country.rb#17
  def min_longitude; end

  # source://countries//lib/countries/country.rb#11
  def nanp_prefix; end

  # source://countries//lib/countries/country.rb#11
  def national_destination_code_lengths; end

  # source://countries//lib/countries/country.rb#11
  def national_number_lengths; end

  # source://countries//lib/countries/country.rb#11
  def national_prefix; end

  # source://countries//lib/countries/country.rb#11
  def nationality; end

  # source://countries//lib/countries/country.rb#11
  def number; end

  # source://countries//lib/countries/country.rb#11
  def postal_code; end

  # source://countries//lib/countries/country.rb#11
  def postal_code?; end

  # source://countries//lib/countries/country.rb#11
  def postal_code_format; end

  # source://countries//lib/countries/country.rb#11
  def region; end

  # source://countries//lib/countries/country.rb#11
  def start_of_week; end

  # source://countries//lib/countries/country.rb#93
  def states; end

  # @param locale [String] The locale to use for translations.
  # @return [Array<Array>] This Country's subdivision pairs of names and codes.
  #
  # source://countries//lib/countries/country.rb#89
  def subdivision_names_with_codes(locale = T.unsafe(nil)); end

  # @return [Array<String>] the list of subdivision types for this country
  #
  # source://countries//lib/countries/country.rb#74
  def subdivision_types; end

  # @return [Array<ISO3166::Subdivision>] the list of subdivisions for this Country.
  #
  # source://countries//lib/countries/country.rb#59
  def subdivisions; end

  # +true+ if this Country has any Subdivisions.
  #
  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#54
  def subdivisions?; end

  # @param types [Array<String>] The locale to use for translations.
  # @return [Array<ISO3166::Subdivision>] the list of subdivisions of the given type(s) for this Country.
  #
  # source://countries//lib/countries/country.rb#69
  def subdivisions_of_types(types); end

  # source://countries//lib/countries/country.rb#11
  def subregion; end

  # source://countries//lib/countries/country.rb#118
  def to_s; end

  # @return [Array<String>] the list of names for this Country in all loaded locales.
  #
  # source://countries//lib/countries/country.rb#123
  def translated_names; end

  # @param locale [String] The locale to use for translations.
  # @return [String] the name of this Country in the selected locale.
  #
  # source://countries//lib/countries/country.rb#129
  def translation(locale = T.unsafe(nil)); end

  # source://countries//lib/countries/country.rb#11
  def translations; end

  # source://countries//lib/countries/country.rb#11
  def un_locode; end

  # source://countries//lib/countries/country.rb#11
  def unofficial_names; end

  # @return [Boolean]
  #
  # source://countries//lib/countries/country.rb#27
  def valid?; end

  # source://countries//lib/countries/country.rb#11
  def vat_rates; end

  # source://countries//lib/countries/country.rb#11
  def world_region; end

  # source://countries//lib/countries/country.rb#11
  def zip; end

  # source://countries//lib/countries/country.rb#11
  def zip?; end

  # source://countries//lib/countries/country.rb#11
  def zip_format; end

  private

  # source://countries//lib/countries/country.rb#238
  def reload; end
end

module ISO3166::CountryClassMethods
  # source://countries//lib/countries/country/class_methods.rb#28
  def all(&blk); end

  # source://countries//lib/countries/country/class_methods.rb#35
  def all_names_with_codes(locale = T.unsafe(nil)); end

  # source://countries//lib/countries/country/class_methods.rb#48
  def all_translated(locale = T.unsafe(nil)); end

  # source://countries//lib/countries/country/class_methods.rb#24
  def codes; end

  # source://countries//lib/countries/country/class_methods.rb#28
  def countries(&blk); end

  # source://countries//lib/countries/country/class_methods.rb#20
  def new(country_data); end

  # source://countries//lib/countries/country/class_methods.rb#42
  def pluck(*attributes); end

  # source://countries//lib/countries/country/class_methods.rb#52
  def translations(locale = T.unsafe(nil)); end

  protected

  # Some methods like parse_value are expensive in that they
  # create a large number of objects internally. In order to reduce the
  # object creations and save the GC, we can cache them in an class instance
  # variable. This will make subsequent parses O(1) and will stop the
  # creation of new String object instances.
  #
  # NB: We only want to use this cache for values coming from the JSON
  # file or our own code, caching user-generated data could be dangerous
  # since the cache would continually grow.
  #
  # source://countries//lib/countries/country/class_methods.rb#86
  def cached(value); end

  # source://countries//lib/countries/country/class_methods.rb#69
  def strip_accents(string); end
end

module ISO3166::CountryFinderMethods
  # source://countries//lib/countries/country/finder_methods.rb#13
  def [](query); end

  # source://countries//lib/countries/country/finder_methods.rb#17
  def find_all_by(attribute, val); end

  # source://countries//lib/countries/country/finder_methods.rb#30
  def method_missing(method_name, *arguments); end

  # source://countries//lib/countries/country/finder_methods.rb#8
  def search(query); end

  protected

  # source://countries//lib/countries/country/finder_methods.rb#50
  def find_by(attribute, value, obj = T.unsafe(nil)); end

  # source://countries//lib/countries/country/finder_methods.rb#56
  def parse_attributes(attribute, val); end

  # source://countries//lib/countries/country/finder_methods.rb#67
  def parse_value(value); end

  # @return [Boolean]
  #
  # source://countries//lib/countries/country/finder_methods.rb#72
  def searchable_attribute?(attribute); end

  # source://countries//lib/countries/country/finder_methods.rb#76
  def searchable_attributes; end

  private

  # @return [Boolean]
  #
  # source://countries//lib/countries/country/finder_methods.rb#39
  def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end
end

# source://countries//lib/countries/country/finder_methods.rb#5
ISO3166::CountryFinderMethods::FIND_BY_REGEX = T.let(T.unsafe(nil), Regexp)

# source://countries//lib/countries/country/finder_methods.rb#6
ISO3166::CountryFinderMethods::SEARCH_TERM_FILTER_REGEX = T.let(T.unsafe(nil), Regexp)

# source://countries//lib/countries/structure.rb#4
ISO3166::DEFAULT_COUNTRY_HASH = T.let(T.unsafe(nil), Hash)

# source://countries//lib/countries/structure.rb#59
ISO3166::DEFAULT_SUBDIVISION_HASH = T.let(T.unsafe(nil), Hash)

# Handles building the in memory store of countries data
class ISO3166::Data
  # @return [Data] a new instance of Data
  #
  # source://countries//lib/countries/data.rb#13
  def initialize(alpha2); end

  # source://countries//lib/countries/data.rb#17
  def call; end

  class << self
    # source://countries//lib/countries/data.rb#41
    def cache; end

    # source://countries//lib/countries/data.rb#53
    def codes; end

    # source://countries//lib/countries/data.rb#87
    def create_subdivisions(subdivision_data); end

    # source://countries//lib/countries/data.rb#69
    def datafile_path(file_array); end

    # source://countries//lib/countries/data.rb#64
    def loaded_codes; end

    # Registers a new Country with custom data.
    # If you are overriding an existing country, this does not perform a deep merge so you will need to __bring in all data you wish to be available__.
    # Overriding an existing country will also remove it from the internal management of translations.
    #
    # source://countries//lib/countries/data.rb#26
    def register(data); end

    # Resets the loaded data and cache
    #
    # source://countries//lib/countries/data.rb#46
    def reset; end

    # source://countries//lib/countries/data.rb#73
    def subdivision_data(alpha2); end

    # source://countries//lib/countries/data.rb#82
    def subdivisions(alpha2); end

    # Removes a country from the loaded data
    #
    # source://countries//lib/countries/data.rb#35
    def unregister(alpha2); end

    # source://countries//lib/countries/data.rb#58
    def update_cache; end

    private

    # @return [Boolean]
    #
    # source://countries//lib/countries/data.rb#146
    def cache_flush_required?; end

    # source://countries//lib/countries/data.rb#137
    def cached_codes; end

    # source://countries//lib/countries/data.rb#193
    def deep_stringify_keys(data); end

    # Codes that we have translations for in dataset
    #
    # source://countries//lib/countries/data.rb#142
    def internal_codes; end

    # source://countries//lib/countries/data.rb#188
    def load_cache(file_array); end

    # source://countries//lib/countries/data.rb#95
    def load_data!; end

    # @return [Boolean]
    #
    # source://countries//lib/countries/data.rb#131
    def load_required?; end

    # source://countries//lib/countries/data.rb#166
    def load_translations(locale); end

    # source://countries//lib/countries/data.rb#162
    def loaded_locales; end

    # source://countries//lib/countries/data.rb#150
    def locales_to_load; end

    # source://countries//lib/countries/data.rb#154
    def locales_to_remove; end

    # source://countries//lib/countries/data.rb#158
    def requested_locales; end

    # source://countries//lib/countries/data.rb#202
    def subdivision_file_path(alpha2); end

    # source://countries//lib/countries/data.rb#106
    def sync_translations!; end

    # source://countries//lib/countries/data.rb#118
    def synchronized(&block); end

    # source://countries//lib/countries/data.rb#178
    def unload_translations(locale); end

    # @return [Boolean]
    #
    # source://countries//lib/countries/data.rb#126
    def use_mutex?; end
  end
end

module ISO3166::Emoji
  # The emoji flag for this country, using Unicode Regional Indicator characters. e.g: "U+1F1FA U+1F1F8" for 🇺🇸
  #
  # @return [String] the emoji flag for this country
  #
  # source://countries//lib/countries/country/emoji.rb#37
  def emoji_flag; end
end

# source://countries//lib/countries/country/emoji.rb#5
ISO3166::Emoji::CODE_POINTS = T.let(T.unsafe(nil), Hash)

class ISO3166::KwargStruct < ::Struct
  # Override the initialize to handle hashes of named parameters
  #
  # @return [KwargStruct] a new instance of KwargStruct
  #
  # source://countries//lib/countries/kwarg_struct.rb#6
  def initialize(*args); end
end

class ISO3166::Subdivision
  # @return [Subdivision] a new instance of Subdivision
  #
  # source://countries//lib/countries/subdivision.rb#13
  def initialize(attrs); end

  # source://countries//lib/countries/subdivision.rb#19
  def [](attr_name); end

  # Returns the value of attribute code.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def code; end

  # Sets the attribute code
  #
  # @param value the value to set the attribute code to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def code=(_arg0); end

  # Returns the value of attribute comments.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def comments; end

  # Sets the attribute comments
  #
  # @param value the value to set the attribute comments to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def comments=(_arg0); end

  # Returns the value of attribute geo.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def geo; end

  # Sets the attribute geo
  #
  # @param value the value to set the attribute geo to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def geo=(_arg0); end

  # Returns the value of attribute name.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def name=(_arg0); end

  # Returns the value of attribute translations.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def translations; end

  # Sets the attribute translations
  #
  # @param value the value to set the attribute translations to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def translations=(_arg0); end

  # Returns the value of attribute type.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def type=(_arg0); end

  # Returns the value of attribute unofficial_names.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def unofficial_names; end

  # Sets the attribute unofficial_names
  #
  # @param value the value to set the attribute unofficial_names to.
  #
  # source://countries//lib/countries/subdivision.rb#5
  def unofficial_names=(_arg0); end
end

# Extend Country class with support for timezones. Requires the  {tzinfo}[https://github.com/tzinfo/tzinfo] gem
#
#   gem 'tzinfo'
module ISO3166::TimezoneExtensions
  # TODO: rename method to tz_country or something similar
  #
  # source://countries//lib/countries/timezones.rb#10
  def timezones; end
end

# Extend the hash class to allow locale lookup fall back behavior
#
# E.g. if a country has translations for +pt+, and the user looks up +pt-br+ fallback
# to +pt+ to prevent from showing nil values
class ISO3166::Translations < ::Hash
  # source://countries//lib/countries/translations.rb#9
  def [](locale); end
end

# source://countries//lib/countries/country/class_methods.rb#6
ISO3166::UNSEARCHABLE_METHODS = T.let(T.unsafe(nil), Array)
