# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `counter_culture` gem.
# Please instead update this file by running `bin/tapioca gem counter_culture`.

module CounterCulture
  # source://counter_culture//lib/counter_culture.rb#10
  def batch_size; end

  # source://counter_culture//lib/counter_culture.rb#10
  def batch_size=(val); end

  class << self
    # source://counter_culture//lib/counter_culture.rb#10
    def batch_size; end

    # source://counter_culture//lib/counter_culture.rb#10
    def batch_size=(val); end

    # @yield [_self]
    # @yieldparam _self [CounterCulture] the object that the method was called on
    #
    # source://counter_culture//lib/counter_culture.rb#13
    def config; end
  end
end

class CounterCulture::Counter
  # @return [Counter] a new instance of Counter
  #
  # source://counter_culture//lib/counter_culture/counter.rb#8
  def initialize(model, relation, options); end

  # @return [Boolean]
  #
  # source://counter_culture//lib/counter_culture/counter.rb#248
  def attribute_changed?(obj, attr); end

  # increments or decrements a counter cache
  #
  # options:
  #   :increment => true to increment, false to decrement
  #   :relation => which relation to increment the count on,
  #   :counter_cache_name => the column name of the counter cache
  #   :counter_column => overrides :counter_cache_name
  #   :delta_column => override the default count delta (1) with the value of this column in the counted record
  #   :was => whether to get the current value or the old value of the
  #      first part of the relation
  #   :with_papertrail => update the column via Papertrail touch_with_version method
  #
  # source://counter_culture//lib/counter_culture/counter.rb#44
  def change_counter_cache(obj, options); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def column_names; end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def counter_cache_name; end

  # Gets the name of the counter cache for a specific object
  #
  # obj: object to calculate the counter cache name for
  # cache_name_finder: object used to calculate the cache name
  #
  # source://counter_culture//lib/counter_culture/counter.rb#142
  def counter_cache_name_for(obj); end

  # Gets the delta magnitude of the counter cache for a specific object
  #
  # obj: object to calculate the counter cache name for
  #
  # source://counter_culture//lib/counter_culture/counter.rb#130
  def counter_delta_magnitude_for(obj); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def delta_column; end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def delta_magnitude; end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def execute_after_commit; end

  # source://counter_culture//lib/counter_culture/counter.rb#321
  def execute_now_or_after_commit(obj, &block); end

  # @return [Boolean]
  #
  # source://counter_culture//lib/counter_culture/counter.rb#240
  def first_level_relation_changed?(instance); end

  # gets the foreign key name of the relation. will look at the first
  # level only -- i.e., if passed an array will consider only its
  # first element
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  #
  # source://counter_culture//lib/counter_culture/counter.rb#298
  def first_level_relation_foreign_key; end

  # source://counter_culture//lib/counter_culture/counter.rb#303
  def first_level_relation_foreign_type; end

  # gets the value of the foreign key on the given relation
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  # was: whether to get the current or past value from ActiveRecord;
  #   pass true to get the past value, false or nothing to get the
  #   current value
  #
  # source://counter_culture//lib/counter_culture/counter.rb#165
  def foreign_key_value(obj, relation, was = T.unsafe(nil)); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def foreign_key_values; end

  # the string to pass to order() in order to sort by primary key
  #
  # source://counter_culture//lib/counter_culture/counter.rb#154
  def full_primary_key(klass); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def model; end

  # @return [Boolean]
  #
  # source://counter_culture//lib/counter_culture/counter.rb#256
  def polymorphic?; end

  # source://counter_culture//lib/counter_culture/counter.rb#309
  def previous_model(obj); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def relation; end

  # gets the foreign key name of the given relation
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  #
  # source://counter_culture//lib/counter_culture/counter.rb#268
  def relation_foreign_key(relation); end

  # gets the class of the given relation
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  # source [optional]: the source object,
  #   only needed for polymorphic associations,
  #   probably only works with a single relation (symbol, or array of 1 symbol)
  # was: boolean
  #   we're actually looking for the old value -- only can change for polymorphic relations
  #
  # source://counter_culture//lib/counter_culture/counter.rb#222
  def relation_klass(relation, source: T.unsafe(nil), was: T.unsafe(nil)); end

  # gets the primary key name of the given relation
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  # source[optional]: the model instance that the relationship is linked from,
  #   only needed for polymorphic associations,
  #   probably only works with a single relation (symbol, or array of 1 symbol)
  # was: boolean
  #   we're actually looking for the old value -- only can change for polymorphic relations
  #
  # source://counter_culture//lib/counter_culture/counter.rb#281
  def relation_primary_key(relation, source: T.unsafe(nil), was: T.unsafe(nil)); end

  # gets the reflect object on the given relation
  #
  # relation: a symbol or array of symbols; specifies the relation
  #   that has the counter cache column
  #
  # source://counter_culture//lib/counter_culture/counter.rb#192
  def relation_reflect(relation); end

  # source://counter_culture//lib/counter_culture/counter.rb#6
  def touch; end

  private

  # source://counter_culture//lib/counter_culture/counter.rb#332
  def attribute_was(obj, attr); end
end

# source://counter_culture//lib/counter_culture/counter.rb#4
CounterCulture::Counter::ACTIVE_RECORD_VERSION = T.let(T.unsafe(nil), Gem::Version)

# source://counter_culture//lib/counter_culture/counter.rb#3
CounterCulture::Counter::CONFIG_OPTIONS = T.let(T.unsafe(nil), Array)

module CounterCulture::Extensions
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::CounterCulture::Extensions::ClassMethods

  private

  # called by after_create callback
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#98
  def _update_counts_after_create; end

  # called by after_destroy callback
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#106
  def _update_counts_after_destroy; end

  # called by after_update callback
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#116
  def _update_counts_after_update; end

  # check if record is soft-deleted
  #
  # @return [Boolean]
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#136
  def destroyed_for_counter_culture?; end
end

module CounterCulture::Extensions::ClassMethods
  # this holds all configuration data
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#7
  def after_commit_counter_cache; end

  # called to configure counter caches
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#16
  def counter_culture(relation, options = T.unsafe(nil)); end

  # checks all of the declared counter caches on this class for correctnes based
  # on original data; if the counter cache is incorrect, sets it to the correct
  # count
  #
  # options:
  #   { :exclude => list of relations to skip when fixing counts,
  #     :only => only these relations will have their counts fixed,
  #     :column_name => only this column will have its count fixed
  #     :polymorphic_classes => specify the class(es) to update in polymorphic associations }
  # returns: a list of fixed record as an array of hashes of the form:
  #   { :entity => which model the count was fixed on,
  #     :id => the id of the model that had the incorrect count,
  #     :what => which column contained the incorrect count,
  #     :wrong => the previously saved, incorrect count,
  #     :right => the newly fixed, correct count }
  #
  # source://counter_culture//lib/counter_culture/extensions.rb#75
  def counter_culture_fix_counts(options = T.unsafe(nil)); end
end

class CounterCulture::Reconciler
  # @return [Reconciler] a new instance of Reconciler
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#13
  def initialize(counter, options = T.unsafe(nil)); end

  # Returns the value of attribute changes.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#8
  def changes; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def column_names(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute counter.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#8
  def counter; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def counter_cache_name(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def delta_column(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def delta_magnitude(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def execute_after_commit(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def foreign_key_values(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#10
  def full_primary_key(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#10
  def model(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute options.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#8
  def options; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#10
  def polymorphic?(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#20
  def reconcile!; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#10
  def relation(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#10
  def relation_reflect(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#11
  def touch(*_arg0, **_arg1, &_arg2); end

  private

  # source://counter_culture//lib/counter_culture/reconciler.rb#53
  def associated_model_class; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#40
  def associated_model_classes; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#48
  def polymorphic_associated_model_classes; end
end

# source://counter_culture//lib/counter_culture/reconciler.rb#6
CounterCulture::Reconciler::ACTIVE_RECORD_VERSION = T.let(T.unsafe(nil), Gem::Version)

class CounterCulture::Reconciler::Reconciliation
  # @return [Reconciliation] a new instance of Reconciliation
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#63
  def initialize(counter, changes_holder, options, relation_class); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def column_names(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute counter.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#58
  def counter; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def counter_cache_name(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def delta_column(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def delta_magnitude(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def execute_after_commit(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def foreign_key_values(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#60
  def full_primary_key(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#60
  def model(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute options.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#58
  def options; end

  # @raise [ArgumentError]
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#69
  def perform; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#60
  def polymorphic?(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#60
  def relation(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute relation_class.
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#58
  def relation_class; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#60
  def relation_reflect(*_arg0, **_arg1, &_arg2); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#61
  def touch(*_arg0, **_arg1, &_arg2); end

  private

  # source://counter_culture//lib/counter_culture/reconciler.rb#202
  def count_select; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#228
  def join_clauses(where); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#175
  def log(message); end

  # @return [Boolean]
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#187
  def log?; end

  # source://counter_culture//lib/counter_culture/reconciler.rb#181
  def log_without_newline(message); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#314
  def parameterize(string); end

  # This is only needed in relatively unusal cases, for example if you are
  # using Postgres with schema-namespaced tables. But then it's required,
  # and otherwise it's just a no-op, so why not do it?
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#310
  def quote_table_name(table_name); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#217
  def self_table_name; end

  # keep track of what we fixed, e.g. for a notification email
  #
  # source://counter_culture//lib/counter_culture/reconciler.rb#192
  def track_change(record, column_name, count); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#143
  def update_count_for_batch(column_name, records); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#322
  def with_reading_db_connection(&block); end

  # source://counter_culture//lib/counter_culture/reconciler.rb#330
  def with_writing_db_connection(&block); end
end

# source://counter_culture//lib/counter_culture/version.rb#2
CounterCulture::VERSION = T.let(T.unsafe(nil), String)
