# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `cgi` gem.
# Please instead update this file by running `bin/tapioca gem cgi`.

# == Overview
#
# The Common Gateway Interface (CGI) is a simple protocol for passing an HTTP
# request from a web server to a standalone program, and returning the output
# to the web browser.  Basically, a CGI program is called with the parameters
# of the request passed in either in the environment (GET) or via $stdin
# (POST), and everything it prints to $stdout is returned to the client.
#
# This file holds the CGI class.  This class provides functionality for
# retrieving HTTP request parameters, managing cookies, and generating HTML
# output.
#
# The file CGI::Session provides session management functionality; see that
# class for more details.
#
# See http://www.w3.org/CGI/ for more information on the CGI protocol.
#
# == Introduction
#
# CGI is a large class, providing several categories of methods, many of which
# are mixed in from other modules.  Some of the documentation is in this class,
# some in the modules CGI::QueryExtension and CGI::HtmlExtension.  See
# CGI::Cookie for specific information on handling cookies, and cgi/session.rb
# (CGI::Session) for information on sessions.
#
# For queries, CGI provides methods to get at environmental variables,
# parameters, cookies, and multipart request data.  For responses, CGI provides
# methods for writing output and generating HTML.
#
# Read on for more details.  Examples are provided at the bottom.
#
# == Queries
#
# The CGI class dynamically mixes in parameter and cookie-parsing
# functionality,  environmental variable access, and support for
# parsing multipart requests (including uploaded files) from the
# CGI::QueryExtension module.
#
# === Environmental Variables
#
# The standard CGI environmental variables are available as read-only
# attributes of a CGI object.  The following is a list of these variables:
#
#
#   AUTH_TYPE               HTTP_HOST          REMOTE_IDENT
#   CONTENT_LENGTH          HTTP_NEGOTIATE     REMOTE_USER
#   CONTENT_TYPE            HTTP_PRAGMA        REQUEST_METHOD
#   GATEWAY_INTERFACE       HTTP_REFERER       SCRIPT_NAME
#   HTTP_ACCEPT             HTTP_USER_AGENT    SERVER_NAME
#   HTTP_ACCEPT_CHARSET     PATH_INFO          SERVER_PORT
#   HTTP_ACCEPT_ENCODING    PATH_TRANSLATED    SERVER_PROTOCOL
#   HTTP_ACCEPT_LANGUAGE    QUERY_STRING       SERVER_SOFTWARE
#   HTTP_CACHE_CONTROL      REMOTE_ADDR
#   HTTP_FROM               REMOTE_HOST
#
#
# For each of these variables, there is a corresponding attribute with the
# same name, except all lower case and without a preceding HTTP_.
# +content_length+ and +server_port+ are integers; the rest are strings.
#
# === Parameters
#
# The method #params() returns a hash of all parameters in the request as
# name/value-list pairs, where the value-list is an Array of one or more
# values.  The CGI object itself also behaves as a hash of parameter names
# to values, but only returns a single value (as a String) for each
# parameter name.
#
# For instance, suppose the request contains the parameter
# "favourite_colours" with the multiple values "blue" and "green".  The
# following behavior would occur:
#
#   cgi.params["favourite_colours"]  # => ["blue", "green"]
#   cgi["favourite_colours"]         # => "blue"
#
# If a parameter does not exist, the former method will return an empty
# array, the latter an empty string.  The simplest way to test for existence
# of a parameter is by the #has_key? method.
#
# === Cookies
#
# HTTP Cookies are automatically parsed from the request.  They are available
# from the #cookies() accessor, which returns a hash from cookie name to
# CGI::Cookie object.
#
# === Multipart requests
#
# If a request's method is POST and its content type is multipart/form-data,
# then it may contain uploaded files.  These are stored by the QueryExtension
# module in the parameters of the request.  The parameter name is the name
# attribute of the file input field, as usual.  However, the value is not
# a string, but an IO object, either an IOString for small files, or a
# Tempfile for larger ones.  This object also has the additional singleton
# methods:
#
# #local_path():: the path of the uploaded file on the local filesystem
# #original_filename():: the name of the file on the client computer
# #content_type():: the content type of the file
#
# == Responses
#
# The CGI class provides methods for sending header and content output to
# the HTTP client, and mixes in methods for programmatic HTML generation
# from CGI::HtmlExtension and CGI::TagMaker modules.  The precise version of HTML
# to use for HTML generation is specified at object creation time.
#
# === Writing output
#
# The simplest way to send output to the HTTP client is using the #out() method.
# This takes the HTTP headers as a hash parameter, and the body content
# via a block.  The headers can be generated as a string using the #http_header()
# method.  The output stream can be written directly to using the #print()
# method.
#
# === Generating HTML
#
# Each HTML element has a corresponding method for generating that
# element as a String.  The name of this method is the same as that
# of the element, all lowercase.  The attributes of the element are
# passed in as a hash, and the body as a no-argument block that evaluates
# to a String.  The HTML generation module knows which elements are
# always empty, and silently drops any passed-in body.  It also knows
# which elements require matching closing tags and which don't.  However,
# it does not know what attributes are legal for which elements.
#
# There are also some additional HTML generation methods mixed in from
# the CGI::HtmlExtension module.  These include individual methods for the
# different types of form inputs, and methods for elements that commonly
# take particular attributes where the attributes can be directly specified
# as arguments, rather than via a hash.
#
# === Utility HTML escape and other methods like a function.
#
# There are some utility tool defined in cgi/util.rb .
# And when include, you can use utility methods like a function.
#
# == Examples of use
#
# === Get form values
#
#   require "cgi"
#   cgi = CGI.new
#   value = cgi['field_name']   # <== value string for 'field_name'
#     # if not 'field_name' included, then return "".
#   fields = cgi.keys            # <== array of field names
#
#   # returns true if form has 'field_name'
#   cgi.has_key?('field_name')
#   cgi.has_key?('field_name')
#   cgi.include?('field_name')
#
# CAUTION! <code>cgi['field_name']</code> returned an Array with the old
# cgi.rb(included in Ruby 1.6)
#
# === Get form values as hash
#
#   require "cgi"
#   cgi = CGI.new
#   params = cgi.params
#
# cgi.params is a hash.
#
#   cgi.params['new_field_name'] = ["value"]  # add new param
#   cgi.params['field_name'] = ["new_value"]  # change value
#   cgi.params.delete('field_name')           # delete param
#   cgi.params.clear                          # delete all params
#
#
# === Save form values to file
#
#   require "pstore"
#   db = PStore.new("query.db")
#   db.transaction do
#     db["params"] = cgi.params
#   end
#
#
# === Restore form values from file
#
#   require "pstore"
#   db = PStore.new("query.db")
#   db.transaction do
#     cgi.params = db["params"]
#   end
#
#
# === Get multipart form values
#
#   require "cgi"
#   cgi = CGI.new
#   value = cgi['field_name']   # <== value string for 'field_name'
#   value.read                  # <== body of value
#   value.local_path            # <== path to local file of value
#   value.original_filename     # <== original filename of value
#   value.content_type          # <== content_type of value
#
# and value has StringIO or Tempfile class methods.
#
# === Get cookie values
#
#   require "cgi"
#   cgi = CGI.new
#   values = cgi.cookies['name']  # <== array of 'name'
#     # if not 'name' included, then return [].
#   names = cgi.cookies.keys      # <== array of cookie names
#
# and cgi.cookies is a hash.
#
# === Get cookie objects
#
#   require "cgi"
#   cgi = CGI.new
#   for name, cookie in cgi.cookies
#     cookie.expires = Time.now + 30
#   end
#   cgi.out("cookie" => cgi.cookies) {"string"}
#
#   cgi.cookies # { "name1" => cookie1, "name2" => cookie2, ... }
#
#   require "cgi"
#   cgi = CGI.new
#   cgi.cookies['name'].expires = Time.now + 30
#   cgi.out("cookie" => cgi.cookies['name']) {"string"}
#
# === Print http header and html string to $DEFAULT_OUTPUT ($>)
#
#   require "cgi"
#   cgi = CGI.new("html4")  # add HTML generation methods
#   cgi.out do
#     cgi.html do
#       cgi.head do
#         cgi.title { "TITLE" }
#       end +
#       cgi.body do
#         cgi.form("ACTION" => "uri") do
#           cgi.p do
#             cgi.textarea("get_text") +
#             cgi.br +
#             cgi.submit
#           end
#         end +
#         cgi.pre do
#           CGI.escapeHTML(
#             "params: #{cgi.params.inspect}\n" +
#             "cookies: #{cgi.cookies.inspect}\n" +
#             ENV.collect do |key, value|
#               "#{key} --> #{value}\n"
#             end.join("")
#           )
#         end
#       end
#     end
#   end
#
#   # add HTML generation methods
#   CGI.new("html3")    # html3.2
#   CGI.new("html4")    # html4.01 (Strict)
#   CGI.new("html4Tr")  # html4.01 Transitional
#   CGI.new("html4Fr")  # html4.01 Frameset
#   CGI.new("html5")    # html5
#
# === Some utility methods
#
#   require 'cgi/util'
#   CGI.escapeHTML('Usage: foo "bar" <baz>')
#
#
# === Some utility methods like a function
#
#   require 'cgi/util'
#   include CGI::Util
#   escapeHTML('Usage: foo "bar" <baz>')
#   h('Usage: foo "bar" <baz>') # alias
#
# source://cgi//lib/cgi/util.rb#2
class CGI
  include ::CGI::Util
  include ::CGI::Escape
  extend ::CGI::Util
  extend ::CGI::Escape

  # Create a new CGI instance.
  #
  # :call-seq:
  #   CGI.new(tag_maker) { block }
  #   CGI.new(options_hash = {}) { block }
  #
  #
  # <tt>tag_maker</tt>::
  #   This is the same as using the +options_hash+ form with the value <tt>{
  #   :tag_maker => tag_maker }</tt> Note that it is recommended to use the
  #   +options_hash+ form, since it also allows you specify the charset you
  #   will accept.
  # <tt>options_hash</tt>::
  #   A Hash that recognizes three options:
  #
  #   <tt>:accept_charset</tt>::
  #     specifies encoding of received query string.  If omitted,
  #     <tt>@@accept_charset</tt> is used.  If the encoding is not valid, a
  #     CGI::InvalidEncoding will be raised.
  #
  #     Example. Suppose <tt>@@accept_charset</tt> is "UTF-8"
  #
  #     when not specified:
  #
  #         cgi=CGI.new      # @accept_charset # => "UTF-8"
  #
  #     when specified as "EUC-JP":
  #
  #         cgi=CGI.new(:accept_charset => "EUC-JP") # => "EUC-JP"
  #
  #   <tt>:tag_maker</tt>::
  #     String that specifies which version of the HTML generation methods to
  #     use.  If not specified, no HTML generation methods will be loaded.
  #
  #     The following values are supported:
  #
  #     "html3":: HTML 3.x
  #     "html4":: HTML 4.0
  #     "html4Tr":: HTML 4.0 Transitional
  #     "html4Fr":: HTML 4.0 with Framesets
  #     "html5":: HTML 5
  #
  #   <tt>:max_multipart_length</tt>::
  #     Specifies maximum length of multipart data. Can be an Integer scalar or
  #     a lambda, that will be evaluated when the request is parsed. This
  #     allows more complex logic to be set when determining whether to accept
  #     multipart data (e.g. consult a registered users upload allowance)
  #
  #     Default is 128 * 1024 * 1024 bytes
  #
  #         cgi=CGI.new(:max_multipart_length => 268435456) # simple scalar
  #
  #         cgi=CGI.new(:max_multipart_length => -> {check_filesystem}) # lambda
  #
  # <tt>block</tt>::
  #   If provided, the block is called when an invalid encoding is
  #   encountered. For example:
  #
  #     encoding_errors={}
  #     cgi=CGI.new(:accept_charset=>"EUC-JP") do |name,value|
  #       encoding_errors[name] = value
  #     end
  #
  # Finally, if the CGI object is not created in a standard CGI call
  # environment (that is, it can't locate REQUEST_METHOD in its environment),
  # then it will run in "offline" mode.  In this mode, it reads its parameters
  # from the command line or (failing that) from standard input.  Otherwise,
  # cookies and other parameters are parsed automatically from the standard
  # CGI locations, which varies according to the REQUEST_METHOD.
  #
  # @return [CGI] a new instance of CGI
  #
  # source://cgi//lib/cgi/core.rb#850
  def initialize(options = T.unsafe(nil), &block); end

  # Return the accept character set for this CGI instance.
  #
  # source://cgi//lib/cgi/core.rb#769
  def accept_charset; end

  # Create an HTTP header block as a string.
  #
  # :call-seq:
  #   http_header(content_type_string="text/html")
  #   http_header(headers_hash)
  #
  # Includes the empty line that ends the header block.
  #
  # +content_type_string+::
  #   If this form is used, this string is the <tt>Content-Type</tt>
  # +headers_hash+::
  #   A Hash of header values. The following header keys are recognized:
  #
  #   type:: The Content-Type header.  Defaults to "text/html"
  #   charset:: The charset of the body, appended to the Content-Type header.
  #   nph:: A boolean value.  If true, prepend protocol string and status
  #         code, and date; and sets default values for "server" and
  #         "connection" if not explicitly set.
  #   status::
  #     The HTTP status code as a String, returned as the Status header.  The
  #     values are:
  #
  #     OK:: 200 OK
  #     PARTIAL_CONTENT:: 206 Partial Content
  #     MULTIPLE_CHOICES:: 300 Multiple Choices
  #     MOVED:: 301 Moved Permanently
  #     REDIRECT:: 302 Found
  #     NOT_MODIFIED:: 304 Not Modified
  #     BAD_REQUEST:: 400 Bad Request
  #     AUTH_REQUIRED:: 401 Authorization Required
  #     FORBIDDEN:: 403 Forbidden
  #     NOT_FOUND:: 404 Not Found
  #     METHOD_NOT_ALLOWED:: 405 Method Not Allowed
  #     NOT_ACCEPTABLE:: 406 Not Acceptable
  #     LENGTH_REQUIRED:: 411 Length Required
  #     PRECONDITION_FAILED:: 412 Precondition Failed
  #     SERVER_ERROR:: 500 Internal Server Error
  #     NOT_IMPLEMENTED:: 501 Method Not Implemented
  #     BAD_GATEWAY:: 502 Bad Gateway
  #     VARIANT_ALSO_VARIES:: 506 Variant Also Negotiates
  #
  #   server:: The server software, returned as the Server header.
  #   connection:: The connection type, returned as the Connection header (for
  #                instance, "close".
  #   length:: The length of the content that will be sent, returned as the
  #            Content-Length header.
  #   language:: The language of the content, returned as the Content-Language
  #              header.
  #   expires:: The time on which the current content expires, as a +Time+
  #             object, returned as the Expires header.
  #   cookie::
  #     A cookie or cookies, returned as one or more Set-Cookie headers.  The
  #     value can be the literal string of the cookie; a CGI::Cookie object;
  #     an Array of literal cookie strings or Cookie objects; or a hash all of
  #     whose values are literal cookie strings or Cookie objects.
  #
  #     These cookies are in addition to the cookies held in the
  #     @output_cookies field.
  #
  #   Other headers can also be set; they are appended as key: value.
  #
  # Examples:
  #
  #   http_header
  #     # Content-Type: text/html
  #
  #   http_header("text/plain")
  #     # Content-Type: text/plain
  #
  #   http_header("nph"        => true,
  #               "status"     => "OK",  # == "200 OK"
  #                 # "status"     => "200 GOOD",
  #               "server"     => ENV['SERVER_SOFTWARE'],
  #               "connection" => "close",
  #               "type"       => "text/html",
  #               "charset"    => "iso-2022-jp",
  #                 # Content-Type: text/html; charset=iso-2022-jp
  #               "length"     => 103,
  #               "language"   => "ja",
  #               "expires"    => Time.now + 30,
  #               "cookie"     => [cookie1, cookie2],
  #               "my_header1" => "my_value",
  #               "my_header2" => "my_value")
  #
  # This method does not perform charset conversion.
  # This method is an alias for #http_header, when HTML5 tag maker is inactive.
  #
  # NOTE: use #http_header to create HTTP header blocks, this alias is only
  # provided for backwards compatibility.
  #
  # Using #header with the HTML5 tag maker will create a <header> element.
  #
  # source://cgi//lib/cgi/core.rb#160
  def header(options = T.unsafe(nil)); end

  # Create an HTTP header block as a string.
  #
  # :call-seq:
  #   http_header(content_type_string="text/html")
  #   http_header(headers_hash)
  #
  # Includes the empty line that ends the header block.
  #
  # +content_type_string+::
  #   If this form is used, this string is the <tt>Content-Type</tt>
  # +headers_hash+::
  #   A Hash of header values. The following header keys are recognized:
  #
  #   type:: The Content-Type header.  Defaults to "text/html"
  #   charset:: The charset of the body, appended to the Content-Type header.
  #   nph:: A boolean value.  If true, prepend protocol string and status
  #         code, and date; and sets default values for "server" and
  #         "connection" if not explicitly set.
  #   status::
  #     The HTTP status code as a String, returned as the Status header.  The
  #     values are:
  #
  #     OK:: 200 OK
  #     PARTIAL_CONTENT:: 206 Partial Content
  #     MULTIPLE_CHOICES:: 300 Multiple Choices
  #     MOVED:: 301 Moved Permanently
  #     REDIRECT:: 302 Found
  #     NOT_MODIFIED:: 304 Not Modified
  #     BAD_REQUEST:: 400 Bad Request
  #     AUTH_REQUIRED:: 401 Authorization Required
  #     FORBIDDEN:: 403 Forbidden
  #     NOT_FOUND:: 404 Not Found
  #     METHOD_NOT_ALLOWED:: 405 Method Not Allowed
  #     NOT_ACCEPTABLE:: 406 Not Acceptable
  #     LENGTH_REQUIRED:: 411 Length Required
  #     PRECONDITION_FAILED:: 412 Precondition Failed
  #     SERVER_ERROR:: 500 Internal Server Error
  #     NOT_IMPLEMENTED:: 501 Method Not Implemented
  #     BAD_GATEWAY:: 502 Bad Gateway
  #     VARIANT_ALSO_VARIES:: 506 Variant Also Negotiates
  #
  #   server:: The server software, returned as the Server header.
  #   connection:: The connection type, returned as the Connection header (for
  #                instance, "close".
  #   length:: The length of the content that will be sent, returned as the
  #            Content-Length header.
  #   language:: The language of the content, returned as the Content-Language
  #              header.
  #   expires:: The time on which the current content expires, as a +Time+
  #             object, returned as the Expires header.
  #   cookie::
  #     A cookie or cookies, returned as one or more Set-Cookie headers.  The
  #     value can be the literal string of the cookie; a CGI::Cookie object;
  #     an Array of literal cookie strings or Cookie objects; or a hash all of
  #     whose values are literal cookie strings or Cookie objects.
  #
  #     These cookies are in addition to the cookies held in the
  #     @output_cookies field.
  #
  #   Other headers can also be set; they are appended as key: value.
  #
  # Examples:
  #
  #   http_header
  #     # Content-Type: text/html
  #
  #   http_header("text/plain")
  #     # Content-Type: text/plain
  #
  #   http_header("nph"        => true,
  #               "status"     => "OK",  # == "200 OK"
  #                 # "status"     => "200 GOOD",
  #               "server"     => ENV['SERVER_SOFTWARE'],
  #               "connection" => "close",
  #               "type"       => "text/html",
  #               "charset"    => "iso-2022-jp",
  #                 # Content-Type: text/html; charset=iso-2022-jp
  #               "length"     => 103,
  #               "language"   => "ja",
  #               "expires"    => Time.now + 30,
  #               "cookie"     => [cookie1, cookie2],
  #               "my_header1" => "my_value",
  #               "my_header2" => "my_value")
  #
  # This method does not perform charset conversion.
  #
  # source://cgi//lib/cgi/core.rb#160
  def http_header(options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#274
  def nph?; end

  # Print an HTTP header and body to $DEFAULT_OUTPUT ($>)
  #
  # :call-seq:
  #   cgi.out(content_type_string='text/html')
  #   cgi.out(headers_hash)
  #
  # +content_type_string+::
  #   If a string is passed, it is assumed to be the content type.
  # +headers_hash+::
  #   This is a Hash of headers, similar to that used by #http_header.
  # +block+::
  #   A block is required and should evaluate to the body of the response.
  #
  # <tt>Content-Length</tt> is automatically calculated from the size of
  # the String returned by the content block.
  #
  # If <tt>ENV['REQUEST_METHOD'] == "HEAD"</tt>, then only the header
  # is output (the content block is still required, but it is ignored).
  #
  # If the charset is "iso-2022-jp" or "euc-jp" or "shift_jis" then the
  # content is converted to this charset, and the language is set to "ja".
  #
  # Example:
  #
  #   cgi = CGI.new
  #   cgi.out{ "string" }
  #     # Content-Type: text/html
  #     # Content-Length: 6
  #     #
  #     # string
  #
  #   cgi.out("text/plain") { "string" }
  #     # Content-Type: text/plain
  #     # Content-Length: 6
  #     #
  #     # string
  #
  #   cgi.out("nph"        => true,
  #           "status"     => "OK",  # == "200 OK"
  #           "server"     => ENV['SERVER_SOFTWARE'],
  #           "connection" => "close",
  #           "type"       => "text/html",
  #           "charset"    => "iso-2022-jp",
  #             # Content-Type: text/html; charset=iso-2022-jp
  #           "language"   => "ja",
  #           "expires"    => Time.now + (3600 * 24 * 30),
  #           "cookie"     => [cookie1, cookie2],
  #           "my_header1" => "my_value",
  #           "my_header2" => "my_value") { "string" }
  #      # HTTP/1.1 200 OK
  #      # Date: Sun, 15 May 2011 17:35:54 GMT
  #      # Server: Apache 2.2.0
  #      # Connection: close
  #      # Content-Type: text/html; charset=iso-2022-jp
  #      # Content-Length: 6
  #      # Content-Language: ja
  #      # Expires: Tue, 14 Jun 2011 17:35:54 GMT
  #      # Set-Cookie: foo
  #      # Set-Cookie: bar
  #      # my_header1: my_value
  #      # my_header2: my_value
  #      #
  #      # string
  #
  # source://cgi//lib/cgi/core.rb#367
  def out(options = T.unsafe(nil)); end

  # Print an argument or list of arguments to the default output stream
  #
  #   cgi = CGI.new
  #   cgi.print    # default:  cgi.print == $DEFAULT_OUTPUT.print
  #
  # source://cgi//lib/cgi/core.rb#383
  def print(*options); end

  private

  # source://cgi//lib/cgi/core.rb#218
  def _header_for_hash(options); end

  # source://cgi//lib/cgi/core.rb#278
  def _header_for_modruby(buf); end

  # source://cgi//lib/cgi/core.rb#202
  def _header_for_string(content_type); end

  # source://cgi//lib/cgi/core.rb#191
  def _no_crlf_check(str); end

  # Synonym for ENV.
  #
  # source://cgi//lib/cgi/core.rb#59
  def env_table; end

  # Synonym for $stdin.
  #
  # source://cgi//lib/cgi/core.rb#64
  def stdinput; end

  # Synonym for $stdout.
  #
  # source://cgi//lib/cgi/core.rb#69
  def stdoutput; end

  class << self
    # Return the accept character set for all new CGI instances.
    #
    # source://cgi//lib/cgi/core.rb#759
    def accept_charset; end

    # Set the accept character set for all new CGI instances.
    #
    # source://cgi//lib/cgi/core.rb#764
    def accept_charset=(accept_charset); end

    # Parse an HTTP query string into a hash of key=>value pairs.
    #
    #   params = CGI.parse("query_string")
    #     # {"name1" => ["value1", "value2", ...],
    #     #  "name2" => ["value1", "value2", ...], ... }
    #
    # source://cgi//lib/cgi/core.rb#393
    def parse(query); end
  end
end

# Class representing an HTTP cookie.
#
# In addition to its specific fields and methods, a Cookie instance
# is a delegator to the array of its values.
#
# See RFC 2965.
#
# == Examples of use
#   cookie1 = CGI::Cookie.new("name", "value1", "value2", ...)
#   cookie1 = CGI::Cookie.new("name" => "name", "value" => "value")
#   cookie1 = CGI::Cookie.new('name'     => 'name',
#                             'value'    => ['value1', 'value2', ...],
#                             'path'     => 'path',   # optional
#                             'domain'   => 'domain', # optional
#                             'expires'  => Time.now, # optional
#                             'secure'   => true,     # optional
#                             'httponly' => true      # optional
#                             )
#
#   cgi.out("cookie" => [cookie1, cookie2]) { "string" }
#
#   name     = cookie1.name
#   values   = cookie1.value
#   path     = cookie1.path
#   domain   = cookie1.domain
#   expires  = cookie1.expires
#   secure   = cookie1.secure
#   httponly = cookie1.httponly
#
#   cookie1.name     = 'name'
#   cookie1.value    = ['value1', 'value2', ...]
#   cookie1.path     = 'path'
#   cookie1.domain   = 'domain'
#   cookie1.expires  = Time.now + 30
#   cookie1.secure   = true
#   cookie1.httponly = true
class CGI::Cookie < ::Array
  # Create a new CGI::Cookie object.
  #
  # :call-seq:
  #   Cookie.new(name_string,*value)
  #   Cookie.new(options_hash)
  #
  # +name_string+::
  #   The name of the cookie; in this form, there is no #domain or
  #   #expiration.  The #path is gleaned from the +SCRIPT_NAME+ environment
  #   variable, and #secure is false.
  # <tt>*value</tt>::
  #   value or list of values of the cookie
  # +options_hash+::
  #   A Hash of options to initialize this Cookie.  Possible options are:
  #
  #   name:: the name of the cookie.  Required.
  #   value:: the cookie's value or list of values.
  #   path:: the path for which this cookie applies.  Defaults to
  #          the value of the +SCRIPT_NAME+ environment variable.
  #   domain:: the domain for which this cookie applies.
  #   expires:: the time at which this cookie expires, as a +Time+ object.
  #   secure:: whether this cookie is a secure cookie or not (default to
  #            false).  Secure cookies are only transmitted to HTTPS
  #            servers.
  #   httponly:: whether this cookie is a HttpOnly cookie or not (default to
  #            false).  HttpOnly cookies are not available to javascript.
  #
  #   These keywords correspond to attributes of the cookie object.
  #
  # @return [Cookie] a new instance of Cookie
  #
  # source://cgi//lib/cgi/cookie.rb#75
  def initialize(name = T.unsafe(nil), *value); end

  # Domain for which this cookie applies, as a +String+
  #
  # source://cgi//lib/cgi/cookie.rb#124
  def domain; end

  # Set domain for which this cookie applies
  #
  # source://cgi//lib/cgi/cookie.rb#126
  def domain=(str); end

  # Time at which this cookie expires, as a +Time+
  #
  # source://cgi//lib/cgi/cookie.rb#134
  def expires; end

  # Time at which this cookie expires, as a +Time+
  #
  # source://cgi//lib/cgi/cookie.rb#134
  def expires=(_arg0); end

  # True if this cookie is httponly; false otherwise
  #
  # source://cgi//lib/cgi/cookie.rb#138
  def httponly; end

  # Set whether the Cookie is a httponly cookie or not.
  #
  # +val+ must be a boolean.
  #
  # source://cgi//lib/cgi/cookie.rb#161
  def httponly=(val); end

  # A summary of cookie string.
  #
  # source://cgi//lib/cgi/cookie.rb#202
  def inspect; end

  # Name of this cookie, as a +String+
  #
  # source://cgi//lib/cgi/cookie.rb#104
  def name; end

  # Set name of this cookie
  #
  # source://cgi//lib/cgi/cookie.rb#106
  def name=(str); end

  # Path for which this cookie applies, as a +String+
  #
  # source://cgi//lib/cgi/cookie.rb#114
  def path; end

  # Set path for which this cookie applies
  #
  # source://cgi//lib/cgi/cookie.rb#116
  def path=(str); end

  # True if this cookie is secure; false otherwise
  #
  # source://cgi//lib/cgi/cookie.rb#136
  def secure; end

  # Set whether the Cookie is a secure cookie or not.
  #
  # +val+ must be a boolean.
  #
  # source://cgi//lib/cgi/cookie.rb#153
  def secure=(val); end

  # Convert the Cookie to its string representation.
  #
  # source://cgi//lib/cgi/cookie.rb#166
  def to_s; end

  # Returns the value or list of values for this cookie.
  #
  # source://cgi//lib/cgi/cookie.rb#141
  def value; end

  # Replaces the value of this cookie with a new value or list of values.
  #
  # source://cgi//lib/cgi/cookie.rb#146
  def value=(val); end

  class << self
    # Parse a raw cookie string into a hash of cookie-name=>Cookie
    # pairs.
    #
    #   cookies = CGI::Cookie.parse("raw_cookie_string")
    #     # { "name1" => cookie1, "name2" => cookie2, ... }
    #
    # source://cgi//lib/cgi/cookie.rb#183
    def parse(raw_cookie); end
  end
end

# source://cgi//lib/cgi/cookie.rb#45
CGI::Cookie::DOMAIN_VALUE_RE = T.let(T.unsafe(nil), Regexp)

# source://cgi//lib/cgi/cookie.rb#44
CGI::Cookie::PATH_VALUE_RE = T.let(T.unsafe(nil), Regexp)

# source://cgi//lib/cgi/cookie.rb#43
CGI::Cookie::TOKEN_RE = T.let(T.unsafe(nil), Regexp)

# Html5
class CGI::HTML3
  include ::CGI::TagMaker
  include ::CGI::Html3
  include ::CGI::HtmlExtension
end

class CGI::HTML4
  include ::CGI::TagMaker
  include ::CGI::Html4
  include ::CGI::HtmlExtension
end

class CGI::HTML4Fr
  include ::CGI::TagMaker
  include ::CGI::Html4Tr
  include ::CGI::Html4Fr
  include ::CGI::HtmlExtension
end

class CGI::HTML4Tr
  include ::CGI::TagMaker
  include ::CGI::Html4Tr
  include ::CGI::HtmlExtension
end

class CGI::HTML5
  include ::CGI::TagMaker
  include ::CGI::Html5
  include ::CGI::HtmlExtension
end

# Mixin module for HTML version 3 generation methods.
module CGI::Html3
  include ::CGI::TagMaker

  # source://cgi//lib/cgi/html.rb#20
  def a(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def address(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def applet(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def area(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def b(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def base(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def basefont(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def big(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def blockquote(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def body(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def br(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def caption(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def center(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def cite(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def code(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def dd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dfn(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dir(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def div(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dl(attributes = T.unsafe(nil), &block); end

  # The DOCTYPE declaration for this version of HTML
  #
  # source://cgi//lib/cgi/html.rb#826
  def doctype; end

  # source://cgi//lib/cgi/html.rb#61
  def dt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def em(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def font(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def form(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h1(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h2(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h3(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h4(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h5(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h6(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def head(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def hr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def html(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def i(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def img(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def input(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def isindex(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def kbd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def li(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def link(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def listing(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def map(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def menu(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def meta(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ol(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def option(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def p(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def param(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def plaintext(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def pre(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def samp(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def script(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def select(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def small(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strike(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strong(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def style(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sub(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def table(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def td(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def textarea(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def th(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def title(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def tt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def u(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ul(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def var(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def xmp(attributes = T.unsafe(nil), &block); end
end

# Mixin module for HTML version 4 generation methods.
module CGI::Html4
  include ::CGI::TagMaker

  # source://cgi//lib/cgi/html.rb#20
  def a(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def abbr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def acronym(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def address(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def area(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def b(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def base(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def bdo(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def big(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def blockquote(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def body(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def br(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def button(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def caption(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def cite(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def code(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def col(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def colgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def dd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def del(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dfn(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def div(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dl(attributes = T.unsafe(nil), &block); end

  # The DOCTYPE declaration for this version of HTML
  #
  # source://cgi//lib/cgi/html.rb#865
  def doctype; end

  # source://cgi//lib/cgi/html.rb#61
  def dt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def em(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def fieldset(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def form(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h1(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h2(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h3(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h4(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h5(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h6(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def head(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def hr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def html(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def i(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def img(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def input(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ins(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def kbd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def label(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def legend(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def li(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def link(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def map(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def meta(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def noscript(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def object(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ol(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def optgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def option(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def p(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def param(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def pre(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def q(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def samp(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def script(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def select(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def small(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def span(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strong(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def style(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sub(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def table(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tbody(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def td(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def textarea(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tfoot(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def th(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def thead(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def title(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def tt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ul(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def var(attributes = T.unsafe(nil), &block); end
end

# Mixin module for generating HTML version 4 with framesets.
module CGI::Html4Fr
  include ::CGI::TagMaker

  # The DOCTYPE declaration for this version of HTML
  #
  # source://cgi//lib/cgi/html.rb#945
  def doctype; end

  # source://cgi//lib/cgi/html.rb#43
  def frame(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def frameset(attributes = T.unsafe(nil), &block); end
end

# Mixin module for HTML version 4 transitional generation methods.
module CGI::Html4Tr
  include ::CGI::TagMaker

  # source://cgi//lib/cgi/html.rb#20
  def a(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def abbr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def acronym(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def address(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def applet(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def area(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def b(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def base(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def basefont(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def bdo(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def big(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def blockquote(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def body(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def br(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def button(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def caption(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def center(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def cite(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def code(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def col(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def colgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def dd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def del(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dfn(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dir(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def div(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dl(attributes = T.unsafe(nil), &block); end

  # The DOCTYPE declaration for this version of HTML
  #
  # source://cgi//lib/cgi/html.rb#904
  def doctype; end

  # source://cgi//lib/cgi/html.rb#61
  def dt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def em(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def fieldset(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def font(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def form(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h1(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h2(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h3(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h4(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h5(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h6(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def head(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def hr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def html(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def i(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def iframe(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def img(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def input(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ins(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def isindex(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def kbd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def label(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def legend(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def li(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def link(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def map(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def menu(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def meta(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def noframes(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def noscript(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def object(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ol(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def optgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def option(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def p(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def param(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def pre(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def q(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def s(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def samp(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def script(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def select(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def small(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def span(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strike(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strong(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def style(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sub(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def table(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tbody(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def td(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def textarea(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tfoot(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def th(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def thead(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def title(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def tt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def u(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ul(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def var(attributes = T.unsafe(nil), &block); end
end

# Mixin module for HTML version 5 generation methods.
module CGI::Html5
  include ::CGI::TagMaker

  # source://cgi//lib/cgi/html.rb#20
  def a(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def abbr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def address(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def area(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def article(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def aside(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def audio(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def b(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def base(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def bdi(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def bdo(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def blockquote(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def body(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def br(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def button(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def canvas(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def caption(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def cite(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def code(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def col(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def colgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def command(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def datalist(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def dd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def del(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def details(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dfn(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dialog(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def div(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def dl(attributes = T.unsafe(nil), &block); end

  # The DOCTYPE declaration for this version of HTML
  #
  # source://cgi//lib/cgi/html.rb#972
  def doctype; end

  # source://cgi//lib/cgi/html.rb#61
  def dt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def em(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def embed(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def fieldset(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def figcaption(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def figure(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def footer(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def form(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h1(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h2(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h3(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h4(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h5(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def h6(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def head(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def header(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def hgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def hr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def html(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def i(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def iframe(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def img(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def input(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ins(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def kbd(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def keygen(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def label(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def legend(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def li(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def link(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def map(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def mark(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def menu(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def meta(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def meter(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def nav(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def noscript(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def object(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ol(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def optgroup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def option(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def output(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def p(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def param(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def pre(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def progress(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def q(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def rp(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def rt(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ruby(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def s(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def samp(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def script(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def section(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def select(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def small(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def source(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def span(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def strong(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def style(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sub(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def summary(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def sup(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def table(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tbody(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def td(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def textarea(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tfoot(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def th(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def thead(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def time(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def title(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#61
  def tr(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def track(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def u(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def ul(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def var(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#20
  def video(attributes = T.unsafe(nil), &block); end

  # source://cgi//lib/cgi/html.rb#43
  def wbr(attributes = T.unsafe(nil), &block); end
end

# Mixin module providing HTML generation methods.
#
# For example,
#   cgi.a("http://www.example.com") { "Example" }
#     # => "<A HREF=\"http://www.example.com\">Example</A>"
#
# Modules Html3, Html4, etc., contain more basic HTML-generation methods
# (+#title+, +#h1+, etc.).
#
# See class CGI for a detailed example.
module CGI::HtmlExtension
  # Generate an Anchor element as a string.
  #
  # +href+ can either be a string, giving the URL
  # for the HREF attribute, or it can be a hash of
  # the element's attributes.
  #
  # The body of the element is the string returned by the no-argument
  # block passed in.
  #
  #   a("http://www.example.com") { "Example" }
  #     # => "<A HREF=\"http://www.example.com\">Example</A>"
  #
  #   a("HREF" => "http://www.example.com", "TARGET" => "_top") { "Example" }
  #     # => "<A HREF=\"http://www.example.com\" TARGET=\"_top\">Example</A>"
  #
  # source://cgi//lib/cgi/html.rb#97
  def a(href = T.unsafe(nil)); end

  # Generate a Document Base URI element as a String.
  #
  # +href+ can either by a string, giving the base URL for the HREF
  # attribute, or it can be a has of the element's attributes.
  #
  # The passed-in no-argument block is ignored.
  #
  #   base("http://www.example.com/cgi")
  #     # => "<BASE HREF=\"http://www.example.com/cgi\">"
  #
  # source://cgi//lib/cgi/html.rb#115
  def base(href = T.unsafe(nil)); end

  # Generate a BlockQuote element as a string.
  #
  # +cite+ can either be a string, give the URI for the source of
  # the quoted text, or a hash, giving all attributes of the element,
  # or it can be omitted, in which case the element has no attributes.
  #
  # The body is provided by the passed-in no-argument block
  #
  #   blockquote("http://www.example.com/quotes/foo.html") { "Foo!" }
  #     #=> "<BLOCKQUOTE CITE=\"http://www.example.com/quotes/foo.html\">Foo!</BLOCKQUOTE>
  #
  # source://cgi//lib/cgi/html.rb#134
  def blockquote(cite = T.unsafe(nil)); end

  # Generate a Table Caption element as a string.
  #
  # +align+ can be a string, giving the alignment of the caption
  # (one of top, bottom, left, or right).  It can be a hash of
  # all the attributes of the element.  Or it can be omitted.
  #
  # The body of the element is provided by the passed-in no-argument block.
  #
  #   caption("left") { "Capital Cities" }
  #     # => <CAPTION ALIGN=\"left\">Capital Cities</CAPTION>
  #
  # source://cgi//lib/cgi/html.rb#154
  def caption(align = T.unsafe(nil)); end

  # Generate a Checkbox Input element as a string.
  #
  # The attributes of the element can be specified as three arguments,
  # +name+, +value+, and +checked+.  +checked+ is a boolean value;
  # if true, the CHECKED attribute will be included in the element.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   checkbox("name")
  #     # = checkbox("NAME" => "name")
  #
  #   checkbox("name", "value")
  #     # = checkbox("NAME" => "name", "VALUE" => "value")
  #
  #   checkbox("name", "value", true)
  #     # = checkbox("NAME" => "name", "VALUE" => "value", "CHECKED" => true)
  #
  # source://cgi//lib/cgi/html.rb#180
  def checkbox(name = T.unsafe(nil), value = T.unsafe(nil), checked = T.unsafe(nil)); end

  # Generate a sequence of checkbox elements, as a String.
  #
  # The checkboxes will all have the same +name+ attribute.
  # Each checkbox is followed by a label.
  # There will be one checkbox for each value.  Each value
  # can be specified as a String, which will be used both
  # as the value of the VALUE attribute and as the label
  # for that checkbox.  A single-element array has the
  # same effect.
  #
  # Each value can also be specified as a three-element array.
  # The first element is the VALUE attribute; the second is the
  # label; and the third is a boolean specifying whether this
  # checkbox is CHECKED.
  #
  # Each value can also be specified as a two-element
  # array, by omitting either the value element (defaults
  # to the same as the label), or the boolean checked element
  # (defaults to false).
  #
  #   checkbox_group("name", "foo", "bar", "baz")
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="foo">foo
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="bar">bar
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="baz">baz
  #
  #   checkbox_group("name", ["foo"], ["bar", true], "baz")
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="foo">foo
  #     # <INPUT TYPE="checkbox" CHECKED NAME="name" VALUE="bar">bar
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="baz">baz
  #
  #   checkbox_group("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="1">Foo
  #     # <INPUT TYPE="checkbox" CHECKED NAME="name" VALUE="2">Bar
  #     # <INPUT TYPE="checkbox" NAME="name" VALUE="Baz">Baz
  #
  #   checkbox_group("NAME" => "name",
  #                    "VALUES" => ["foo", "bar", "baz"])
  #
  #   checkbox_group("NAME" => "name",
  #                    "VALUES" => [["foo"], ["bar", true], "baz"])
  #
  #   checkbox_group("NAME" => "name",
  #                    "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"])
  #
  # source://cgi//lib/cgi/html.rb#234
  def checkbox_group(name = T.unsafe(nil), *values); end

  # Generate an File Upload Input element as a string.
  #
  # The attributes of the element can be specified as three arguments,
  # +name+, +size+, and +maxlength+.  +maxlength+ is the maximum length
  # of the file's _name_, not of the file's _contents_.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  # See #multipart_form() for forms that include file uploads.
  #
  #   file_field("name")
  #     # <INPUT TYPE="file" NAME="name" SIZE="20">
  #
  #   file_field("name", 40)
  #     # <INPUT TYPE="file" NAME="name" SIZE="40">
  #
  #   file_field("name", 40, 100)
  #     # <INPUT TYPE="file" NAME="name" SIZE="40" MAXLENGTH="100">
  #
  #   file_field("NAME" => "name", "SIZE" => 40)
  #     # <INPUT TYPE="file" NAME="name" SIZE="40">
  #
  # source://cgi//lib/cgi/html.rb#276
  def file_field(name = T.unsafe(nil), size = T.unsafe(nil), maxlength = T.unsafe(nil)); end

  # Generate a Form element as a string.
  #
  # +method+ should be either "get" or "post", and defaults to the latter.
  # +action+ defaults to the current CGI script name.  +enctype+
  # defaults to "application/x-www-form-urlencoded".
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  # See also #multipart_form() for forms that include file uploads.
  #
  #   form{ "string" }
  #     # <FORM METHOD="post" ENCTYPE="application/x-www-form-urlencoded">string</FORM>
  #
  #   form("get") { "string" }
  #     # <FORM METHOD="get" ENCTYPE="application/x-www-form-urlencoded">string</FORM>
  #
  #   form("get", "url") { "string" }
  #     # <FORM METHOD="get" ACTION="url" ENCTYPE="application/x-www-form-urlencoded">string</FORM>
  #
  #   form("METHOD" => "post", "ENCTYPE" => "enctype") { "string" }
  #     # <FORM METHOD="post" ENCTYPE="enctype">string</FORM>
  #
  # source://cgi//lib/cgi/html.rb#310
  def form(method = T.unsafe(nil), action = T.unsafe(nil), enctype = T.unsafe(nil)); end

  # Generate a Hidden Input element as a string.
  #
  # The attributes of the element can be specified as two arguments,
  # +name+ and +value+.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   hidden("name")
  #     # <INPUT TYPE="hidden" NAME="name">
  #
  #   hidden("name", "value")
  #     # <INPUT TYPE="hidden" NAME="name" VALUE="value">
  #
  #   hidden("NAME" => "name", "VALUE" => "reset", "ID" => "foo")
  #     # <INPUT TYPE="hidden" NAME="name" VALUE="value" ID="foo">
  #
  # source://cgi//lib/cgi/html.rb#351
  def hidden(name = T.unsafe(nil), value = T.unsafe(nil)); end

  # Generate a top-level HTML element as a string.
  #
  # The attributes of the element are specified as a hash.  The
  # pseudo-attribute "PRETTY" can be used to specify that the generated
  # HTML string should be indented.  "PRETTY" can also be specified as
  # a string as the sole argument to this method.  The pseudo-attribute
  # "DOCTYPE", if given, is used as the leading DOCTYPE SGML tag; it
  # should include the entire text of this tag, including angle brackets.
  #
  # The body of the html element is supplied as a block.
  #
  #   html{ "string" }
  #     # <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN"><HTML>string</HTML>
  #
  #   html("LANG" => "ja") { "string" }
  #     # <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN"><HTML LANG="ja">string</HTML>
  #
  #   html("DOCTYPE" => false) { "string" }
  #     # <HTML>string</HTML>
  #
  #   html("DOCTYPE" => '<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">') { "string" }
  #     # <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN"><HTML>string</HTML>
  #
  #   html("PRETTY" => "  ") { "<BODY></BODY>" }
  #     # <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
  #     # <HTML>
  #     #   <BODY>
  #     #   </BODY>
  #     # </HTML>
  #
  #   html("PRETTY" => "\t") { "<BODY></BODY>" }
  #     # <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
  #     # <HTML>
  #     #         <BODY>
  #     #         </BODY>
  #     # </HTML>
  #
  #   html("PRETTY") { "<BODY></BODY>" }
  #     # = html("PRETTY" => "  ") { "<BODY></BODY>" }
  #
  #   html(if $VERBOSE then "PRETTY" end) { "HTML string" }
  #
  # source://cgi//lib/cgi/html.rb#403
  def html(attributes = T.unsafe(nil)); end

  # Generate an Image Button Input element as a string.
  #
  # +src+ is the URL of the image to use for the button.  +name+
  # is the input name.  +alt+ is the alternative text for the image.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   image_button("url")
  #     # <INPUT TYPE="image" SRC="url">
  #
  #   image_button("url", "name", "string")
  #     # <INPUT TYPE="image" SRC="url" NAME="name" ALT="string">
  #
  #   image_button("SRC" => "url", "ALT" => "string")
  #     # <INPUT TYPE="image" SRC="url" ALT="string">
  #
  # source://cgi//lib/cgi/html.rb#448
  def image_button(src = T.unsafe(nil), name = T.unsafe(nil), alt = T.unsafe(nil)); end

  # Generate an Image element as a string.
  #
  # +src+ is the URL of the image.  +alt+ is the alternative text for
  # the image.  +width+ is the width of the image, and +height+ is
  # its height.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   img("src", "alt", 100, 50)
  #     # <IMG SRC="src" ALT="alt" WIDTH="100" HEIGHT="50">
  #
  #   img("SRC" => "src", "ALT" => "alt", "WIDTH" => 100, "HEIGHT" => 50)
  #     # <IMG SRC="src" ALT="alt" WIDTH="100" HEIGHT="50">
  #
  # source://cgi//lib/cgi/html.rb#474
  def img(src = T.unsafe(nil), alt = T.unsafe(nil), width = T.unsafe(nil), height = T.unsafe(nil)); end

  # Generate a Form element with multipart encoding as a String.
  #
  # Multipart encoding is used for forms that include file uploads.
  #
  # +action+ is the action to perform.  +enctype+ is the encoding
  # type, which defaults to "multipart/form-data".
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   multipart_form{ "string" }
  #     # <FORM METHOD="post" ENCTYPE="multipart/form-data">string</FORM>
  #
  #   multipart_form("url") { "string" }
  #     # <FORM METHOD="post" ACTION="url" ENCTYPE="multipart/form-data">string</FORM>
  #
  # source://cgi//lib/cgi/html.rb#500
  def multipart_form(action = T.unsafe(nil), enctype = T.unsafe(nil)); end

  # Generate a Password Input element as a string.
  #
  # +name+ is the name of the input field.  +value+ is its default
  # value.  +size+ is the size of the input field display.  +maxlength+
  # is the maximum length of the inputted password.
  #
  # Alternatively, attributes can be specified as a hash.
  #
  #   password_field("name")
  #     # <INPUT TYPE="password" NAME="name" SIZE="40">
  #
  #   password_field("name", "value")
  #     # <INPUT TYPE="password" NAME="name" VALUE="value" SIZE="40">
  #
  #   password_field("password", "value", 80, 200)
  #     # <INPUT TYPE="password" NAME="name" VALUE="value" SIZE="80" MAXLENGTH="200">
  #
  #   password_field("NAME" => "name", "VALUE" => "value")
  #     # <INPUT TYPE="password" NAME="name" VALUE="value">
  #
  # source://cgi//lib/cgi/html.rb#542
  def password_field(name = T.unsafe(nil), value = T.unsafe(nil), size = T.unsafe(nil), maxlength = T.unsafe(nil)); end

  # Generate a Select element as a string.
  #
  # +name+ is the name of the element.  The +values+ are the options that
  # can be selected from the Select menu.  Each value can be a String or
  # a one, two, or three-element Array.  If a String or a one-element
  # Array, this is both the value of that option and the text displayed for
  # it.  If a three-element Array, the elements are the option value, displayed
  # text, and a boolean value specifying whether this option starts as selected.
  # The two-element version omits either the option value (defaults to the same
  # as the display text) or the boolean selected specifier (defaults to false).
  #
  # The attributes and options can also be specified as a hash.  In this
  # case, options are specified as an array of values as described above,
  # with the hash key of "VALUES".
  #
  #   popup_menu("name", "foo", "bar", "baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="foo">foo</OPTION>
  #     #   <OPTION VALUE="bar">bar</OPTION>
  #     #   <OPTION VALUE="baz">baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("name", ["foo"], ["bar", true], "baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="foo">foo</OPTION>
  #     #   <OPTION VALUE="bar" SELECTED>bar</OPTION>
  #     #   <OPTION VALUE="baz">baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="1">Foo</OPTION>
  #     #   <OPTION SELECTED VALUE="2">Bar</OPTION>
  #     #   <OPTION VALUE="Baz">Baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("NAME" => "name", "SIZE" => 2, "MULTIPLE" => true,
  #               "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"])
  #     # <SELECT NAME="name" MULTIPLE SIZE="2">
  #     #   <OPTION VALUE="1">Foo</OPTION>
  #     #   <OPTION SELECTED VALUE="2">Bar</OPTION>
  #     #   <OPTION VALUE="Baz">Baz</OPTION>
  #     # </SELECT>
  #
  # source://cgi//lib/cgi/html.rb#597
  def popup_menu(name = T.unsafe(nil), *values); end

  # Generates a radio-button Input element.
  #
  # +name+ is the name of the input field.  +value+ is the value of
  # the field if checked.  +checked+ specifies whether the field
  # starts off checked.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   radio_button("name", "value")
  #     # <INPUT TYPE="radio" NAME="name" VALUE="value">
  #
  #   radio_button("name", "value", true)
  #     # <INPUT TYPE="radio" NAME="name" VALUE="value" CHECKED>
  #
  #   radio_button("NAME" => "name", "VALUE" => "value", "ID" => "foo")
  #     # <INPUT TYPE="radio" NAME="name" VALUE="value" ID="foo">
  #
  # source://cgi//lib/cgi/html.rb#646
  def radio_button(name = T.unsafe(nil), value = T.unsafe(nil), checked = T.unsafe(nil)); end

  # Generate a sequence of radio button Input elements, as a String.
  #
  # This works the same as #checkbox_group().  However, it is not valid
  # to have more than one radiobutton in a group checked.
  #
  #   radio_group("name", "foo", "bar", "baz")
  #     # <INPUT TYPE="radio" NAME="name" VALUE="foo">foo
  #     # <INPUT TYPE="radio" NAME="name" VALUE="bar">bar
  #     # <INPUT TYPE="radio" NAME="name" VALUE="baz">baz
  #
  #   radio_group("name", ["foo"], ["bar", true], "baz")
  #     # <INPUT TYPE="radio" NAME="name" VALUE="foo">foo
  #     # <INPUT TYPE="radio" CHECKED NAME="name" VALUE="bar">bar
  #     # <INPUT TYPE="radio" NAME="name" VALUE="baz">baz
  #
  #   radio_group("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
  #     # <INPUT TYPE="radio" NAME="name" VALUE="1">Foo
  #     # <INPUT TYPE="radio" CHECKED NAME="name" VALUE="2">Bar
  #     # <INPUT TYPE="radio" NAME="name" VALUE="Baz">Baz
  #
  #   radio_group("NAME" => "name",
  #                 "VALUES" => ["foo", "bar", "baz"])
  #
  #   radio_group("NAME" => "name",
  #                 "VALUES" => [["foo"], ["bar", true], "baz"])
  #
  #   radio_group("NAME" => "name",
  #                 "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"])
  #
  # source://cgi//lib/cgi/html.rb#685
  def radio_group(name = T.unsafe(nil), *values); end

  # Generate a reset button Input element, as a String.
  #
  # This resets the values on a form to their initial values.  +value+
  # is the text displayed on the button. +name+ is the name of this button.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   reset
  #     # <INPUT TYPE="reset">
  #
  #   reset("reset")
  #     # <INPUT TYPE="reset" VALUE="reset">
  #
  #   reset("VALUE" => "reset", "ID" => "foo")
  #     # <INPUT TYPE="reset" VALUE="reset" ID="foo">
  #
  # source://cgi//lib/cgi/html.rb#720
  def reset(value = T.unsafe(nil), name = T.unsafe(nil)); end

  # Generate a Select element as a string.
  #
  # +name+ is the name of the element.  The +values+ are the options that
  # can be selected from the Select menu.  Each value can be a String or
  # a one, two, or three-element Array.  If a String or a one-element
  # Array, this is both the value of that option and the text displayed for
  # it.  If a three-element Array, the elements are the option value, displayed
  # text, and a boolean value specifying whether this option starts as selected.
  # The two-element version omits either the option value (defaults to the same
  # as the display text) or the boolean selected specifier (defaults to false).
  #
  # The attributes and options can also be specified as a hash.  In this
  # case, options are specified as an array of values as described above,
  # with the hash key of "VALUES".
  #
  #   popup_menu("name", "foo", "bar", "baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="foo">foo</OPTION>
  #     #   <OPTION VALUE="bar">bar</OPTION>
  #     #   <OPTION VALUE="baz">baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("name", ["foo"], ["bar", true], "baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="foo">foo</OPTION>
  #     #   <OPTION VALUE="bar" SELECTED>bar</OPTION>
  #     #   <OPTION VALUE="baz">baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
  #     # <SELECT NAME="name">
  #     #   <OPTION VALUE="1">Foo</OPTION>
  #     #   <OPTION SELECTED VALUE="2">Bar</OPTION>
  #     #   <OPTION VALUE="Baz">Baz</OPTION>
  #     # </SELECT>
  #
  #   popup_menu("NAME" => "name", "SIZE" => 2, "MULTIPLE" => true,
  #               "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"])
  #     # <SELECT NAME="name" MULTIPLE SIZE="2">
  #     #   <OPTION VALUE="1">Foo</OPTION>
  #     #   <OPTION SELECTED VALUE="2">Bar</OPTION>
  #     #   <OPTION VALUE="Baz">Baz</OPTION>
  #     # </SELECT>
  #
  # source://cgi//lib/cgi/html.rb#597
  def scrolling_list(name = T.unsafe(nil), *values); end

  # Generate a submit button Input element, as a String.
  #
  # +value+ is the text to display on the button.  +name+ is the name
  # of the input.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   submit
  #     # <INPUT TYPE="submit">
  #
  #   submit("ok")
  #     # <INPUT TYPE="submit" VALUE="ok">
  #
  #   submit("ok", "button1")
  #     # <INPUT TYPE="submit" VALUE="ok" NAME="button1">
  #
  #   submit("VALUE" => "ok", "NAME" => "button1", "ID" => "foo")
  #     # <INPUT TYPE="submit" VALUE="ok" NAME="button1" ID="foo">
  #
  # source://cgi//lib/cgi/html.rb#750
  def submit(value = T.unsafe(nil), name = T.unsafe(nil)); end

  # Generate a text field Input element, as a String.
  #
  # +name+ is the name of the input field.  +value+ is its initial
  # value.  +size+ is the size of the input area.  +maxlength+
  # is the maximum length of input accepted.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  #   text_field("name")
  #     # <INPUT TYPE="text" NAME="name" SIZE="40">
  #
  #   text_field("name", "value")
  #     # <INPUT TYPE="text" NAME="name" VALUE="value" SIZE="40">
  #
  #   text_field("name", "value", 80)
  #     # <INPUT TYPE="text" NAME="name" VALUE="value" SIZE="80">
  #
  #   text_field("name", "value", 80, 200)
  #     # <INPUT TYPE="text" NAME="name" VALUE="value" SIZE="80" MAXLENGTH="200">
  #
  #   text_field("NAME" => "name", "VALUE" => "value")
  #     # <INPUT TYPE="text" NAME="name" VALUE="value">
  #
  # source://cgi//lib/cgi/html.rb#782
  def text_field(name = T.unsafe(nil), value = T.unsafe(nil), size = T.unsafe(nil), maxlength = T.unsafe(nil)); end

  # Generate a TextArea element, as a String.
  #
  # +name+ is the name of the textarea.  +cols+ is the number of
  # columns and +rows+ is the number of rows in the display.
  #
  # Alternatively, the attributes can be specified as a hash.
  #
  # The body is provided by the passed-in no-argument block
  #
  #   textarea("name")
  #      # = textarea("NAME" => "name", "COLS" => 70, "ROWS" => 10)
  #
  #   textarea("name", 40, 5)
  #      # = textarea("NAME" => "name", "COLS" => 40, "ROWS" => 5)
  #
  # source://cgi//lib/cgi/html.rb#808
  def textarea(name = T.unsafe(nil), cols = T.unsafe(nil), rows = T.unsafe(nil)); end
end

# Mixin module that provides the following:
#
# 1. Access to the CGI environment variables as methods.  See
#    documentation to the CGI class for a list of these variables.  The
#    methods are exposed by removing the leading +HTTP_+ (if it exists) and
#    downcasing the name.  For example, +auth_type+ will return the
#    environment variable +AUTH_TYPE+, and +accept+ will return the value
#    for +HTTP_ACCEPT+.
#
# 2. Access to cookies, including the cookies attribute.
#
# 3. Access to parameters, including the params attribute, and overloading
#    #[] to perform parameter value lookup by key.
#
# 4. The initialize_query method, for initializing the above
#    mechanisms, handling multipart forms, and allowing the
#    class to be used in "offline" mode.
module CGI::QueryExtension
  # Get the value for the parameter with a given key.
  #
  # If the parameter has multiple values, only the first will be
  # retrieved; use #params to get the array of values.
  #
  # source://cgi//lib/cgi/core.rb#714
  def [](key); end

  # source://cgi//lib/cgi/core.rb#448
  def accept; end

  # source://cgi//lib/cgi/core.rb#448
  def accept_charset; end

  # source://cgi//lib/cgi/core.rb#448
  def accept_encoding; end

  # source://cgi//lib/cgi/core.rb#448
  def accept_language; end

  # source://cgi//lib/cgi/core.rb#448
  def auth_type; end

  # source://cgi//lib/cgi/core.rb#448
  def cache_control; end

  # source://cgi//lib/cgi/core.rb#435
  def content_length; end

  # source://cgi//lib/cgi/core.rb#448
  def content_type; end

  # Get the cookies as a hash of cookie-name=>Cookie pairs.
  #
  # source://cgi//lib/cgi/core.rb#464
  def cookies; end

  # Get the cookies as a hash of cookie-name=>Cookie pairs.
  #
  # source://cgi//lib/cgi/core.rb#464
  def cookies=(_arg0); end

  # source://cgi//lib/cgi/core.rb#603
  def create_body(is_large); end

  # Get the uploaded files as a hash of name=>values pairs
  #
  # source://cgi//lib/cgi/core.rb#471
  def files; end

  # source://cgi//lib/cgi/core.rb#448
  def from; end

  # source://cgi//lib/cgi/core.rb#448
  def gateway_interface; end

  # Returns true if a given query string parameter exists.
  #
  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#738
  def has_key?(*args); end

  # source://cgi//lib/cgi/core.rb#448
  def host; end

  # Returns true if a given query string parameter exists.
  #
  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#738
  def include?(*args); end

  # Returns true if a given query string parameter exists.
  #
  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#738
  def key?(*args); end

  # Return all query parameter names as an array of String.
  #
  # source://cgi//lib/cgi/core.rb#733
  def keys(*args); end

  # Returns whether the form contained multipart/form-data
  #
  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#706
  def multipart?; end

  # source://cgi//lib/cgi/core.rb#448
  def negotiate; end

  # Get the parameters as a hash of name=>values pairs, where
  # values is an Array.
  #
  # source://cgi//lib/cgi/core.rb#468
  def params; end

  # Set all the parameters.
  #
  # source://cgi//lib/cgi/core.rb#474
  def params=(hash); end

  # source://cgi//lib/cgi/core.rb#448
  def path_info; end

  # source://cgi//lib/cgi/core.rb#448
  def path_translated; end

  # source://cgi//lib/cgi/core.rb#448
  def pragma; end

  # source://cgi//lib/cgi/core.rb#448
  def query_string; end

  # Get the raw cookies as a string.
  #
  # source://cgi//lib/cgi/core.rb#454
  def raw_cookie; end

  # Get the raw RFC2965 cookies as a string.
  #
  # source://cgi//lib/cgi/core.rb#459
  def raw_cookie2; end

  # source://cgi//lib/cgi/core.rb#448
  def referer; end

  # source://cgi//lib/cgi/core.rb#448
  def remote_addr; end

  # source://cgi//lib/cgi/core.rb#448
  def remote_host; end

  # source://cgi//lib/cgi/core.rb#448
  def remote_ident; end

  # source://cgi//lib/cgi/core.rb#448
  def remote_user; end

  # source://cgi//lib/cgi/core.rb#448
  def request_method; end

  # source://cgi//lib/cgi/core.rb#448
  def script_name; end

  # source://cgi//lib/cgi/core.rb#448
  def server_name; end

  # source://cgi//lib/cgi/core.rb#435
  def server_port; end

  # source://cgi//lib/cgi/core.rb#448
  def server_protocol; end

  # source://cgi//lib/cgi/core.rb#448
  def server_software; end

  # @return [Boolean]
  #
  # source://cgi//lib/cgi/core.rb#619
  def unescape_filename?; end

  # source://cgi//lib/cgi/core.rb#448
  def user_agent; end

  private

  # A wrapper class to use a StringIO object as the body and switch
  # to a TempFile when the passed threshold is passed.
  # Initialize the data from the query.
  #
  # Handles multipart forms (in particular, forms that involve file uploads).
  # Reads query parameters in the @params field, and cookies into @cookies.
  #
  # source://cgi//lib/cgi/core.rb#661
  def initialize_query; end

  # offline mode. read name=value pairs on standard input.
  #
  # source://cgi//lib/cgi/core.rb#626
  def read_from_cmdline; end

  # Parses multipart form elements according to
  #   http://www.w3.org/TR/html401/interact/forms.html#h-17.13.4.2
  #
  # Returns a hash of multipart form parameters with bodies of type StringIO or
  # Tempfile depending on whether the multipart form element exceeds 10 KB
  #
  #   params[name => body]
  #
  # source://cgi//lib/cgi/core.rb#488
  def read_multipart(boundary, content_length); end
end

# Base module for HTML-generation mixins.
#
# Provides methods for code generation for tags following
# the various DTD element types.
module CGI::TagMaker
  # Generate code for an empty element.
  #
  #   - O EMPTY
  #
  # source://cgi//lib/cgi/html.rb#27
  def nOE_element(element, attributes = T.unsafe(nil)); end

  # source://cgi//lib/cgi/html.rb#43
  def nOE_element_def(attributes = T.unsafe(nil), &block); end

  # Generate code for an element for which the end (and possibly the
  # start) tag is optional.
  #
  #   O O or - O
  #
  # source://cgi//lib/cgi/html.rb#52
  def nO_element(element, attributes = T.unsafe(nil)); end

  # source://cgi//lib/cgi/html.rb#61
  def nO_element_def(attributes = T.unsafe(nil), &block); end

  # Generate code for an element with required start and end tags.
  #
  #   - -
  #
  # source://cgi//lib/cgi/html.rb#12
  def nn_element(element, attributes = T.unsafe(nil)); end

  # source://cgi//lib/cgi/html.rb#20
  def nn_element_def(attributes = T.unsafe(nil), &block); end
end

# source://cgi//lib/cgi/util.rb#3
module CGI::Util
  include ::CGI::Escape

  # Escape only the tags of certain HTML elements in +string+.
  #
  # Takes an element or elements or array of elements.  Each element
  # is specified by the name of the element, without angle brackets.
  # This matches both the start and the end tag of that element.
  # The attribute list of the open tag will also be escaped (for
  # instance, the double-quotes surrounding attribute values).
  #
  #   print CGI.escapeElement('<BR><A HREF="url"></A>', "A", "IMG")
  #     # "<BR>&lt;A HREF=&quot;url&quot;&gt;&lt;/A&gt"
  #
  #   print CGI.escapeElement('<BR><A HREF="url"></A>', ["A", "IMG"])
  #     # "<BR>&lt;A HREF=&quot;url&quot;&gt;&lt;/A&gt"
  #
  # source://cgi//lib/cgi/util.rb#178
  def escapeElement(string, *elements); end

  # Escape only the tags of certain HTML elements in +string+.
  #
  # Takes an element or elements or array of elements.  Each element
  # is specified by the name of the element, without angle brackets.
  # This matches both the start and the end tag of that element.
  # The attribute list of the open tag will also be escaped (for
  # instance, the double-quotes surrounding attribute values).
  #
  #   print CGI.escapeElement('<BR><A HREF="url"></A>', "A", "IMG")
  #     # "<BR>&lt;A HREF=&quot;url&quot;&gt;&lt;/A&gt"
  #
  #   print CGI.escapeElement('<BR><A HREF="url"></A>', ["A", "IMG"])
  #     # "<BR>&lt;A HREF=&quot;url&quot;&gt;&lt;/A&gt"
  # Synonym for CGI.escapeElement(str)
  #
  # source://cgi//lib/cgi/util.rb#178
  def escape_element(string, *elements); end

  # Prettify (indent) an HTML string.
  #
  # +string+ is the HTML string to indent.  +shift+ is the indentation
  # unit to use; it defaults to two spaces.
  #
  #   print CGI.pretty("<HTML><BODY></BODY></HTML>")
  #     # <HTML>
  #     #   <BODY>
  #     #   </BODY>
  #     # </HTML>
  #
  #   print CGI.pretty("<HTML><BODY></BODY></HTML>", "\t")
  #     # <HTML>
  #     #         <BODY>
  #     #         </BODY>
  #     # </HTML>
  #
  # source://cgi//lib/cgi/util.rb#240
  def pretty(string, shift = T.unsafe(nil)); end

  # Format a +Time+ object as a String using the format specified by RFC 1123.
  #
  #   CGI.rfc1123_date(Time.now)
  #     # Sat, 01 Jan 2000 00:00:00 GMT
  #
  # source://cgi//lib/cgi/util.rb#219
  def rfc1123_date(time); end

  # Undo escaping such as that done by CGI.escapeElement()
  #
  #   print CGI.unescapeElement(
  #           CGI.escapeHTML('<BR><A HREF="url"></A>'), "A", "IMG")
  #     # "&lt;BR&gt;<A HREF="url"></A>"
  #
  #   print CGI.unescapeElement(
  #           CGI.escapeHTML('<BR><A HREF="url"></A>'), ["A", "IMG"])
  #     # "&lt;BR&gt;<A HREF="url"></A>"
  #
  # source://cgi//lib/cgi/util.rb#198
  def unescapeElement(string, *elements); end

  # Undo escaping such as that done by CGI.escapeElement()
  #
  #   print CGI.unescapeElement(
  #           CGI.escapeHTML('<BR><A HREF="url"></A>'), "A", "IMG")
  #     # "&lt;BR&gt;<A HREF="url"></A>"
  #
  #   print CGI.unescapeElement(
  #           CGI.escapeHTML('<BR><A HREF="url"></A>'), ["A", "IMG"])
  #     # "&lt;BR&gt;<A HREF="url"></A>"
  # Synonym for CGI.unescapeElement(str)
  #
  # source://cgi//lib/cgi/util.rb#198
  def unescape_element(string, *elements); end
end

# source://cgi//lib/cgi.rb#291
CGI::VERSION = T.let(T.unsafe(nil), String)
