# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `capybara` gem.
# Please instead update this file by running `bin/tapioca gem capybara`.

module Capybara
  class << self
    # Parse raw html into a document using Nokogiri, and adjust textarea contents as defined by the spec.
    #
    # @param html [String] The raw html
    # @return [Nokogiri::HTML::Document] HTML document
    #
    # source://capybara//lib/capybara.rb#389
    def HTML(html); end

    # Add a new selector to Capybara. Selectors can be used by various methods in Capybara
    # to find certain elements on the page in a more convenient way. For example adding a
    # selector to find certain table rows might look like this:
    #
    #     Capybara.add_selector(:row) do
    #       xpath { |num| ".//tbody/tr[#{num}]" }
    #     end
    #
    # This makes it possible to use this selector in a variety of ways:
    #
    #     find(:row, 3)
    #     page.find('table#myTable').find(:row, 3).text
    #     page.find('table#myTable').has_selector?(:row, 3)
    #     within(:row, 3) { expect(page).to have_content('$100.000') }
    #
    # Here is another example:
    #
    #     Capybara.add_selector(:id) do
    #       xpath { |id| XPath.descendant[XPath.attr(:id) == id.to_s] }
    #     end
    #
    # Note that this particular selector already ships with Capybara.
    #
    # @param name [Symbol] The name of the selector to add
    # @yield A block executed in the context of the new {Capybara::Selector}
    #
    # source://capybara//lib/capybara.rb#182
    def add_selector(name, **options, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def allow_gumbo(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def allow_gumbo=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def always_include_port(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def always_include_port=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def app(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def app=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def app_host(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def app_host=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def asset_host(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def asset_host=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def automatic_label_click(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def automatic_label_click=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def automatic_reload(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def automatic_reload=(*args, **_arg1, &block); end

    # Configure Capybara to suit your needs.
    #
    #     Capybara.configure do |config|
    #       config.run_server = false
    #       config.app_host   = 'http://www.google.com'
    #     end
    #
    # #### Configurable options
    #
    # - **use_html5_parsing** (Boolean = `false`) - When Nokogiri >= 1.12.0 or `nokogumbo` is installed, whether HTML5 parsing will be used for HTML strings.
    # - **always_include_port** (Boolean = `false`) - Whether the Rack server's port should automatically be inserted into every visited URL
    #   unless another port is explicitly specified.
    # - **app_host** (String, `nil`) - The default host to use when giving a relative URL to visit, must be a valid URL e.g. `http://www.example.com`.
    # - **asset_host** (String = `nil`) - Where dynamic assets are hosted - will be prepended to relative asset locations if present.
    # - **automatic_label_click** (Boolean = `false`) - Whether {Capybara::Node::Element#choose Element#choose}, {Capybara::Node::Element#check Element#check},
    #   {Capybara::Node::Element#uncheck Element#uncheck} will attempt to click the associated `<label>` element if the checkbox/radio button are non-visible.
    # - **automatic_reload** (Boolean = `true`) - Whether to automatically reload elements as Capybara is waiting.
    # - **default_max_wait_time** (Numeric = `2`) - The maximum number of seconds to wait for asynchronous processes to finish.
    # - **default_normalize_ws** (Boolean = `false`) - Whether text predicates and matchers use normalize whitespace behavior.
    # - **default_retry_interval** (Numeric = `0.01`) - The number of seconds to delay the next check in asynchronous processes.
    # - **default_selector** (`:css`, `:xpath` = `:css`) - Methods which take a selector use the given type by default. See also {Capybara::Selector}.
    # - **default_set_options** (Hash = `{}`) - The default options passed to {Capybara::Node::Element#set Element#set}.
    # - **enable_aria_label** (Boolean = `false`) - Whether fields, links, and buttons will match against `aria-label` attribute.
    # - **enable_aria_role** (Boolean = `false`) - Selectors will check for relevant aria role (currently only `button`).
    # - **exact** (Boolean = `false`) - Whether locators are matched exactly or with substrings. Only affects selector conditions
    #   written using the `XPath#is` method.
    # - **exact_text** (Boolean = `false`) - Whether the text matchers and `:text` filter match exactly or on substrings.
    # - **ignore_hidden_elements** (Boolean = `true`) - Whether to ignore hidden elements on the page.
    # - **match** (`:one`, `:first`, `:prefer_exact`, `:smart` = `:smart`) - The matching strategy to find nodes.
    # - **predicates_wait** (Boolean = `true`) - Whether Capybara's predicate matchers use waiting behavior by default.
    # - **raise_server_errors** (Boolean = `true`) - Should errors raised in the server be raised in the tests?
    # - **reuse_server** (Boolean = `true`) - Whether to reuse the server thread between multiple sessions using the same app object.
    # - **run_server** (Boolean = `true`) - Whether to start a Rack server for the given Rack app.
    # - **save_path** (String = `Dir.pwd`) - Where to put pages saved through {Capybara::Session#save_page save_page}, {Capybara::Session#save_screenshot save_screenshot},
    #   {Capybara::Session#save_and_open_page save_and_open_page}, or {Capybara::Session#save_and_open_screenshot save_and_open_screenshot}.
    # - **server** (Symbol = `:default` (which uses puma)) - The name of the registered server to use when running the app under test.
    # - **server_port** (Integer) - The port Capybara will run the application server on, if not specified a random port will be used.
    # - **server_host** (String = "127.0.0.1") - The IP address Capybara will bind the application server to. If the test application is to be accessed from an external host, you will want to change this to "0.0.0.0" or to a more specific IP address that your test client can reach.
    # - **server_errors** (Array\<Class> = `[Exception]`) - Error classes that should be raised in the tests if they are raised in the server
    #   and {configure raise_server_errors} is `true`.
    # - **test_id** (Symbol, String, `nil` = `nil`) - Optional attribute to match locator against with built-in selectors along with id.
    # - **threadsafe** (Boolean = `false`) - Whether sessions can be configured individually.
    # - **w3c_click_offset** (Boolean = 'true') - Whether click offsets should be from element center (true) or top left (false)
    #
    # #### DSL Options
    #
    # When using `capybara/dsl`, the following options are also available:
    #
    # - **default_driver** (Symbol = `:rack_test`) - The name of the driver to use by default.
    # - **javascript_driver** (Symbol = `:selenium`) - The name of a driver to use for JavaScript enabled tests.
    #
    # @yield [config]
    #
    # source://capybara//lib/capybara.rb#114
    def configure; end

    # @return [Symbol] The name of the driver currently in use
    #
    # source://capybara//lib/capybara.rb#261
    def current_driver; end

    # source://capybara//lib/capybara.rb#270
    def current_driver=(name); end

    # The current {Capybara::Session} based on what is set as {app} and {current_driver}.
    #
    # @return [Capybara::Session] The currently used session
    #
    # source://capybara//lib/capybara.rb#316
    def current_session; end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def default_driver(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_driver=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_host(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_host=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def default_max_wait_time(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_max_wait_time=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_normalize_ws(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_normalize_ws=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_retry_interval(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_retry_interval=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def default_selector(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_selector=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_set_options(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def default_set_options=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def disable_animation(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def disable_animation=(*args, **_arg1, &block); end

    # source://capybara//lib/capybara.rb#204
    def drivers; end

    # source://forwardable/1.3.2/forwardable.rb#229
    def enable_aria_label(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def enable_aria_label=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def enable_aria_role(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def enable_aria_role=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def exact(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def exact=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def exact_text(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def exact_text=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def ignore_hidden_elements(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def ignore_hidden_elements=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def javascript_driver(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def javascript_driver=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def match(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def match=(*args, **_arg1, &block); end

    # @return [Symbol] The name of the driver currently in use
    #
    # source://capybara//lib/capybara.rb#261
    def mode; end

    # Modify a selector previously created by {Capybara.add_selector}.
    # For example, adding a new filter to the :button selector to filter based on
    # button style (a class) might look like this
    #
    #     Capybara.modify_selector(:button) do
    #       filter (:btn_style, valid_values: [:primary, :secondary]) { |node, style| node[:class].split.include? "btn-#{style}" }
    #     end
    #
    # @param name [Symbol] The name of the selector to modify
    # @yield A block executed in the context of the existing {Capybara::Selector}
    #
    # source://capybara//lib/capybara.rb#200
    def modify_selector(name, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def predicates_wait(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def predicates_wait=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def raise_server_errors(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def raise_server_errors=(*args, **_arg1, &block); end

    # Register a new driver for Capybara.
    #
    #     Capybara.register_driver :rack_test do |app|
    #       Capybara::RackTest::Driver.new(app)
    #     end
    #
    # @param name [Symbol] The name of the new driver
    # @yield [app] This block takes a rack app and returns a Capybara driver
    # @yieldparam app [<Rack>] The rack application that this driver runs against. May be nil.
    # @yieldreturn [Capybara::Driver::Base] A Capybara driver instance
    #
    # source://capybara//lib/capybara.rb#131
    def register_driver(name, &block); end

    # Register a new server for Capybara.
    #
    #     Capybara.register_server :webrick do |app, port, host|
    #       require 'rack/handler/webrick'
    #       Rack::Handler::WEBrick.run(app, ...)
    #     end
    #
    # @param name [Symbol] The name of the new driver
    # @yield [app, port, host] This block takes a rack app and a port and returns a rack server listening on that port
    # @yieldparam app [<Rack>] The rack application that this server will contain.
    # @yieldparam port The port number the server should listen on
    # @yieldparam host The host/ip to bind to
    #
    # source://capybara//lib/capybara.rb#150
    def register_server(name, &block); end

    # Reset sessions, cleaning out the pool of sessions. This will remove any session information such
    # as cookies.
    #
    # source://capybara//lib/capybara.rb#325
    def reset!; end

    # Reset sessions, cleaning out the pool of sessions. This will remove any session information such
    # as cookies.
    #
    # source://capybara//lib/capybara.rb#325
    def reset_sessions!; end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def reuse_server(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def reuse_server=(*args, **_arg1, &block); end

    # Runs Capybara's default server for the given application and port
    # under most circumstances you should not have to call this method
    # manually.
    #
    # @param app [Rack Application] The rack application to run
    # @param port [Integer] The port to run the application on
    #
    # source://capybara//lib/capybara.rb#253
    def run_default_server(app, port); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def run_server(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def run_server=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def save_path(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def save_path=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def server(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_errors(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_errors=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_host(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_host=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_port(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def server_port=(*args, **_arg1, &block); end

    # source://capybara//lib/capybara.rb#208
    def servers; end

    # The current session name.
    #
    # @return [Symbol] The name of the currently used session.
    #
    # source://capybara//lib/capybara.rb#337
    def session_name; end

    # source://capybara//lib/capybara.rb#345
    def session_name=(name); end

    # source://capybara//lib/capybara.rb#409
    def session_options; end

    # Wraps the given string, which should contain an HTML document or fragment
    # in a {Capybara::Node::Simple} which exposes all {Capybara::Node::Matchers},
    # {Capybara::Node::Finders} and {Capybara::Node::DocumentMatchers}. This allows you to query
    # any string containing HTML in the exact same way you would query the current document in a Capybara
    # session.
    #
    # @example A single element
    #   node = Capybara.string('<a href="foo">bar</a>')
    #   anchor = node.first('a')
    #   anchor[:href] #=> 'foo'
    #   anchor.text #=> 'bar'
    # @example Multiple elements
    #   node = Capybara.string <<-HTML
    #   <ul>
    #   <li id="home">Home</li>
    #   <li id="projects">Projects</li>
    #   </ul>
    #   HTML
    #
    #   node.find('#projects').text # => 'Projects'
    #   node.has_selector?('li#home', text: 'Home')
    #   node.has_selector?('#projects')
    #   node.find('ul').find('li:first-child').text # => 'Home'
    # @param html [String] An html fragment or document
    # @return [Capybara::Node::Simple] A node which has Capybara's finders and matchers
    #
    # source://capybara//lib/capybara.rb#240
    def string(html); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def test_id(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def test_id=(*args, **_arg1, &block); end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def threadsafe(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def threadsafe=(*args, **_arg1, &block); end

    # Use the default driver as the current driver
    #
    # source://capybara//lib/capybara.rb#282
    def use_default_driver; end

    # See {Capybara.configure}
    #
    # source://forwardable/1.3.2/forwardable.rb#229
    def use_html5_parsing(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def use_html5_parsing=(*args, **_arg1, &block); end

    # Yield a block using a specific driver
    #
    # source://capybara//lib/capybara.rb#290
    def using_driver(driver); end

    # Yield a block using a specific session name or {Capybara::Session} instance.
    #
    # source://capybara//lib/capybara.rb#357
    def using_session(name_or_session, &block); end

    # Yield a block using a specific wait time
    #
    # source://capybara//lib/capybara.rb#302
    def using_wait_time(seconds); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def visible_text_only(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def visible_text_only=(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def w3c_click_offset(*args, **_arg1, &block); end

    # source://forwardable/1.3.2/forwardable.rb#229
    def w3c_click_offset=(*args, **_arg1, &block); end

    private

    # source://capybara//lib/capybara.rb#415
    def config; end

    # source://capybara//lib/capybara.rb#419
    def session_pool; end

    # source://capybara//lib/capybara.rb#425
    def specified_session; end

    # source://capybara//lib/capybara.rb#433
    def specified_session=(session); end
  end
end

class Capybara::Ambiguous < ::Capybara::ElementNotFound; end
class Capybara::CapybaraError < ::StandardError; end

class Capybara::Config
  extend ::Forwardable

  # @return [Config] a new instance of Config
  #
  # source://capybara//lib/capybara/config.rb#22
  def initialize; end

  # source://capybara//lib/capybara/config.rb#99
  def allow_gumbo; end

  # source://capybara//lib/capybara/config.rb#94
  def allow_gumbo=(val); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def always_include_port(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def always_include_port=(*args, **_arg1, &block); end

  # Returns the value of attribute app.
  #
  # source://capybara//lib/capybara/config.rb#14
  def app; end

  # Sets the attribute app
  #
  # @param value the value to set the attribute app to.
  #
  # source://capybara//lib/capybara/config.rb#14
  def app=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def app_host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def app_host=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def asset_host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def asset_host=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def automatic_label_click(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def automatic_label_click=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def automatic_reload(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def automatic_reload=(*args, **_arg1, &block); end

  # @return [Symbol] The name of the driver to use by default
  #
  # source://capybara//lib/capybara/config.rb#74
  def default_driver; end

  # Sets the attribute default_driver
  #
  # @param value the value to set the attribute default_driver to.
  #
  # source://capybara//lib/capybara/config.rb#16
  def default_driver=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_host=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_max_wait_time(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_max_wait_time=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_normalize_ws(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_normalize_ws=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_retry_interval(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_retry_interval=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_selector(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_selector=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_set_options(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def default_set_options=(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/config.rb#86
  def deprecate(method, alternate_method, once: T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def disable_animation(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def disable_animation=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def enable_aria_label(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def enable_aria_label=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def enable_aria_role(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def enable_aria_role=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def exact(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def exact=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def exact_text(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def exact_text=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def ignore_hidden_elements(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def ignore_hidden_elements=(*args, **_arg1, &block); end

  # @return [Symbol] The name of the driver used when JavaScript is needed
  #
  # source://capybara//lib/capybara/config.rb#82
  def javascript_driver; end

  # Sets the attribute javascript_driver
  #
  # @param value the value to set the attribute javascript_driver to.
  #
  # source://capybara//lib/capybara/config.rb#16
  def javascript_driver=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def match(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def match=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def predicates_wait(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def predicates_wait=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def raise_server_errors(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def raise_server_errors=(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/config.rb#15
  def reuse_server; end

  # source://capybara//lib/capybara/config.rb#27
  def reuse_server=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def run_server(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def run_server=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def save_path(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def save_path=(*args, **_arg1, &block); end

  # Return the proc that Capybara will call to run the Rack application.
  # The block returned receives a rack app, port, and host/ip and should run a Rack handler
  # By default, Capybara will try to use puma.
  #
  # source://capybara//lib/capybara/config.rb#43
  def server; end

  # Set the server to use.
  #
  #     Capybara.server = :webrick
  #     Capybara.server = :puma, { Silent: true }
  #
  # @overload server=
  # @overload server=
  # @see register_server
  #
  # source://capybara//lib/capybara/config.rb#59
  def server=(name); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_errors(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_errors=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_host(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_host=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_port(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def server_port=(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/config.rb#15
  def session_options; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def test_id(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def test_id=(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/config.rb#15
  def threadsafe; end

  # source://capybara//lib/capybara/config.rb#29
  def threadsafe=(bool); end

  # Returns the value of attribute use_html5_parsing.
  #
  # source://capybara//lib/capybara/config.rb#14
  def use_html5_parsing; end

  # Sets the attribute use_html5_parsing
  #
  # @param value the value to set the attribute use_html5_parsing to.
  #
  # source://capybara//lib/capybara/config.rb#14
  def use_html5_parsing=(_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def visible_text_only(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def visible_text_only=(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def w3c_click_offset(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def w3c_click_offset=(*args, **_arg1, &block); end
end

# source://capybara//lib/capybara/config.rb#10
Capybara::Config::OPTIONS = T.let(T.unsafe(nil), Array)

module Capybara::Driver; end

class Capybara::Driver::Base
  # Execute the block, and then accept the modal opened.
  #
  # @option options
  # @option options
  # @option options
  # @param type [:alert, :confirm, :prompt]
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/driver/base.rb#138
  def accept_modal(type, **options, &blk); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#66
  def active_element; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#108
  def close_window(handle); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#6
  def current_url; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#88
  def current_window_handle; end

  # Execute the block, and then dismiss the modal opened.
  #
  # @option options
  # @option options
  # @param type [:alert, :confirm, :prompt]
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/driver/base.rb#151
  def dismiss_modal(type, **options, &blk); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#46
  def evaluate_async_script(script, *args); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#42
  def evaluate_script(script, *args); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#38
  def execute_script(script, *args); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#22
  def find_css(query, **options); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#18
  def find_xpath(query, **options); end

  # source://capybara//lib/capybara/driver/base.rb#78
  def frame_title; end

  # source://capybara//lib/capybara/driver/base.rb#82
  def frame_url; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#104
  def fullscreen_window(handle); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#30
  def go_back; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#34
  def go_forward; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#26
  def html; end

  # source://capybara//lib/capybara/driver/base.rb#155
  def invalid_element_errors; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#100
  def maximize_window(handle); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/base.rb#165
  def needs_server?; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#124
  def no_such_window_error; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#116
  def open_new_window; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#14
  def refresh; end

  # source://capybara//lib/capybara/driver/base.rb#163
  def reset!; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#96
  def resize_window_to(handle, width, height); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#54
  def response_headers; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#50
  def save_screenshot(path, **options); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#62
  def send_keys(*_arg0); end

  # Sets the attribute session
  #
  # @param value the value to set the attribute session to.
  #
  # source://capybara//lib/capybara/driver/base.rb#4
  def session=(_arg0); end

  # source://capybara//lib/capybara/driver/base.rb#169
  def session_options; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#58
  def status_code; end

  # @param frame [Capybara::Node::Element, :parent, :top] The iframe element to switch to
  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#74
  def switch_to_frame(frame); end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#120
  def switch_to_window(handle); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/base.rb#10
  def visit(path); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/base.rb#159
  def wait?; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#112
  def window_handles; end

  # @raise [Capybara::NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/base.rb#92
  def window_size(handle); end

  private

  # source://capybara//lib/capybara/driver/base.rb#175
  def session; end
end

class Capybara::Driver::Node
  # @return [Node] a new instance of Node
  #
  # source://capybara//lib/capybara/driver/node.rb#8
  def initialize(driver, native, initial_cache = T.unsafe(nil)); end

  # source://capybara//lib/capybara/driver/node.rb#138
  def ==(other); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#22
  def [](name); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#14
  def all_text; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#96
  def checked?; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#48
  def click(keys = T.unsafe(nil), **options); end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#104
  def disabled?; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#56
  def double_click(keys = T.unsafe(nil), **options); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#68
  def drag_to(element, **options); end

  # Returns the value of attribute driver.
  #
  # source://capybara//lib/capybara/driver/node.rb#6
  def driver; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#72
  def drop(*args); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#64
  def hover; end

  # Returns the value of attribute initial_cache.
  #
  # source://capybara//lib/capybara/driver/node.rb#6
  def initial_cache; end

  # source://capybara//lib/capybara/driver/node.rb#132
  def inspect; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#112
  def multiple?; end

  # Returns the value of attribute native.
  #
  # source://capybara//lib/capybara/driver/node.rb#6
  def native; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#92
  def obscured?; end

  # @raise [NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/node.rb#120
  def path; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#108
  def readonly?; end

  # @raise [NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/node.rb#116
  def rect; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#52
  def right_click(keys = T.unsafe(nil), **options); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#76
  def scroll_by(x, y); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#80
  def scroll_to(element, alignment, position = T.unsafe(nil)); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#40
  def select_option; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#100
  def selected?; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#60
  def send_keys(*args); end

  # @param value [String, Array] Array is only allowed if node has 'multiple' attribute
  # @param options [Hash] Driver specific options for how to set a value on a node
  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#36
  def set(value, **options); end

  # @raise [NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/node.rb#128
  def shadow_root; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#30
  def style(styles); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#84
  def tag_name; end

  # @raise [NotSupportedByDriverError]
  #
  # source://capybara//lib/capybara/driver/node.rb#124
  def trigger(event); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#44
  def unselect_option; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#26
  def value; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/driver/node.rb#88
  def visible?; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/driver/node.rb#18
  def visible_text; end
end

class Capybara::DriverNotFoundError < ::Capybara::CapybaraError; end
class Capybara::ElementNotFound < ::Capybara::CapybaraError; end
class Capybara::ExpectationNotMet < ::Capybara::ElementNotFound; end
class Capybara::FileNotFound < ::Capybara::CapybaraError; end
class Capybara::FrozenInTime < ::Capybara::CapybaraError; end

# @api private
module Capybara::Helpers
  private

  # A poor man's `pluralize`. Given two declensions, one singular and one
  # plural, as well as a count, this will pick the correct declension. This
  # way we can generate grammatically correct error message.
  #
  # @api private
  # @param singular [String] The singular form of the word
  # @param plural [String] The plural form of the word
  # @param count [Integer] The number of items
  #
  # source://capybara//lib/capybara/helpers.rb#69
  def declension(singular, plural, count); end

  # @api private
  #
  # source://capybara//lib/capybara/helpers.rb#73
  def filter_backtrace(trace); end

  # Injects a `<base>` tag into the given HTML code, pointing to
  # {Capybara.configure asset_host}.
  #
  # @api private
  # @param html [String] HTML code to inject into
  # @param host [URL] (Capybara.asset_host) The host from which assets should be loaded
  # @return [String] The modified HTML code
  #
  # source://capybara//lib/capybara/helpers.rb#50
  def inject_asset_host(html, host: T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/helpers.rb#89
  def monotonic_time; end

  # Normalizes whitespace space by stripping leading and trailing
  # whitespace and replacing sequences of whitespace characters
  # with a single space.
  #
  # @api private
  # @deprecated
  # @param text [String] Text to normalize
  # @return [String] Normalized text
  #
  # source://capybara//lib/capybara/helpers.rb#17
  def normalize_whitespace(text); end

  # @api private
  #
  # source://capybara//lib/capybara/helpers.rb#98
  def timer(expire_in:); end

  # Escapes any characters that would have special meaning in a regexp
  # if text is not a regexp
  #
  # @api private
  # @param text [String] Text to escape
  # @param exact [Boolean] (false) Whether or not this should be an exact text match
  # @param options [Fixnum, Boolean, nil] Options passed to Regexp.new when creating the Regexp
  # @return [Regexp] Regexp to match the passed in text and options
  #
  # source://capybara//lib/capybara/helpers.rb#32
  def to_regexp(text, exact: T.unsafe(nil), all_whitespace: T.unsafe(nil), options: T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/helpers.rb#84
  def warn(message, uplevel: T.unsafe(nil)); end

  class << self
    # A poor man's `pluralize`. Given two declensions, one singular and one
    # plural, as well as a count, this will pick the correct declension. This
    # way we can generate grammatically correct error message.
    #
    # @api private
    # @param singular [String] The singular form of the word
    # @param plural [String] The plural form of the word
    # @param count [Integer] The number of items
    #
    # source://capybara//lib/capybara/helpers.rb#69
    def declension(singular, plural, count); end

    # @api private
    #
    # source://capybara//lib/capybara/helpers.rb#73
    def filter_backtrace(trace); end

    # Injects a `<base>` tag into the given HTML code, pointing to
    # {Capybara.configure asset_host}.
    #
    # @api private
    # @param html [String] HTML code to inject into
    # @param host [URL] (Capybara.asset_host) The host from which assets should be loaded
    # @return [String] The modified HTML code
    #
    # source://capybara//lib/capybara/helpers.rb#50
    def inject_asset_host(html, host: T.unsafe(nil)); end

    # source://capybara//lib/capybara/helpers.rb#89
    def monotonic_time; end

    # Normalizes whitespace space by stripping leading and trailing
    # whitespace and replacing sequences of whitespace characters
    # with a single space.
    #
    # @api private
    # @deprecated
    # @param text [String] Text to normalize
    # @return [String] Normalized text
    #
    # source://capybara//lib/capybara/helpers.rb#17
    def normalize_whitespace(text); end

    # @api private
    #
    # source://capybara//lib/capybara/helpers.rb#98
    def timer(expire_in:); end

    # Escapes any characters that would have special meaning in a regexp
    # if text is not a regexp
    #
    # @api private
    # @param text [String] Text to escape
    # @param exact [Boolean] (false) Whether or not this should be an exact text match
    # @param options [Fixnum, Boolean, nil] Options passed to Regexp.new when creating the Regexp
    # @return [Regexp] Regexp to match the passed in text and options
    #
    # source://capybara//lib/capybara/helpers.rb#32
    def to_regexp(text, exact: T.unsafe(nil), all_whitespace: T.unsafe(nil), options: T.unsafe(nil)); end

    # @api private
    #
    # source://capybara//lib/capybara/helpers.rb#84
    def warn(message, uplevel: T.unsafe(nil)); end
  end
end

# @api private
class Capybara::Helpers::Timer
  # @api private
  # @return [Timer] a new instance of Timer
  #
  # source://capybara//lib/capybara/helpers.rb#103
  def initialize(expire_in); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/helpers.rb#108
  def expired?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/helpers.rb#116
  def stalled?; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/helpers.rb#122
  def current; end
end

class Capybara::InfiniteRedirectError < ::Capybara::CapybaraError; end
class Capybara::ModalNotFound < ::Capybara::CapybaraError; end
module Capybara::Node; end

module Capybara::Node::Actions
  # Find a descendant file field on the page and attach a file given its path. There are two ways to use
  # {#attach_file}, in the first method the file field can be found via its name, id,
  # {Capybara.configure test_id} attribute, or label text. In the case of the file field being hidden for
  # styling reasons the `make_visible` option can be used to temporarily change the CSS of
  # the file field, attach the file, and then revert the CSS back to original. If no locator is
  # passed this will match self or a descendant.
  # The second method, which is currently in beta and may be changed/removed, involves passing a block
  # which performs whatever actions would trigger the file chooser to appear.
  #
  #     # will attach file to a descendant file input element that has a name, id, or label_text matching 'My File'
  #     page.attach_file('My File', '/path/to/file.png')
  #
  #     # will attach file to el if it's a file input element
  #     el.attach_file('/path/to/file.png')
  #
  #     # will attach file to whatever file input is triggered by the block
  #     page.attach_file('/path/to/file.png') do
  #       page.find('#upload_button').click
  #     end
  #
  # @overload attach_file
  # @overload attach_file
  # @return [Capybara::Node::Element] The file field element
  #
  # source://capybara//lib/capybara/node/actions.rb#279
  def attach_file(locator = T.unsafe(nil), paths, make_visible: T.unsafe(nil), **options); end

  # Find a descendant check box and mark it as checked. The check box can be found
  # via name, id, {Capybara.configure test_id} attribute, or label text. If no locator
  # is provided this will match against self or a descendant.
  #
  #     # will check a descendant checkbox with a name, id, or label text matching 'German'
  #     page.check('German')
  #
  #     # will check `el` if it's a checkbox element
  #     el.check()
  #
  # @overload check
  # @return [Capybara::Node::Element] The element checked or the label clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#150
  def check(locator = T.unsafe(nil), **options); end

  # Find a descendant radio button and mark it as checked. The radio button can be found
  # via name, id, {Capybara.configure test_id} attribute or label text. If no locator is
  # provided this will match against self or a descendant.
  #
  #     # will choose a descendant radio button with a name, id, or label text matching 'Male'
  #     page.choose('Male')
  #
  #     # will choose `el` if it's a radio button element
  #     el.choose()
  #
  # @overload choose
  # @return [Capybara::Node::Element] The element chosen or the label clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#122
  def choose(locator = T.unsafe(nil), **options); end

  # Finds a button on the page and clicks it.
  # This can be any `<input>` element of type submit, reset, image, button or it can be a
  # `<button>` element. All buttons can be found by their id, name, {Capybara.configure test_id} attribute, value, or title. `<button>` elements can also be found
  # by their text content, and image `<input>` elements by their alt attribute.
  #
  # @overload click_button
  # @return [Capybara::Node::Element] The element clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#57
  def click_button(locator = T.unsafe(nil), **options); end

  # Finds a link by id, {Capybara.configure test_id} attribute, text or title and clicks it. Also looks at image
  # alt text inside the link.
  #
  # @overload click_link
  # @return [Capybara::Node::Element] The element clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#41
  def click_link(locator = T.unsafe(nil), **options); end

  # Finds a button or link and clicks it. See {#click_button} and
  # {#click_link} for what locator will match against for each type of element.
  #
  # @overload click_link_or_button
  # @return [Capybara::Node::Element] The element clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#25
  def click_link_or_button(locator = T.unsafe(nil), **options); end

  # Finds a button or link and clicks it. See {#click_button} and
  # {#click_link} for what locator will match against for each type of element.
  #
  # @overload click_link_or_button
  # @return [Capybara::Node::Element] The element clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#25
  def click_on(locator = T.unsafe(nil), **options); end

  # Locate a text field or text area and fill it in with the given text.
  # The field can be found via its name, id, {Capybara.configure test_id} attribute, placeholder, or label text.
  # If no locator is provided this will operate on self or a descendant.
  #
  #     # will fill in a descendant fillable field with name, id, or label text matching 'Name'
  #     page.fill_in 'Name', with: 'Bob'
  #
  #     # will fill in `el` if it's a fillable field
  #     el.fill_in with: 'Tom'
  #
  # @overload fill_in
  # @return [Capybara::Node::Element] The element filled in
  #
  # source://capybara//lib/capybara/node/actions.rb#88
  def fill_in(locator = T.unsafe(nil), with:, currently_with: T.unsafe(nil), fill_options: T.unsafe(nil), **find_options); end

  # If `from` option is present, {#select} finds a select box, or text input with associated datalist,
  # on the page and selects a particular option from it.
  # Otherwise it finds an option inside current scope and selects it.
  # If the select box is a multiple select, {#select} can be called multiple times to select more than
  # one option.
  # The select box can be found via its name, id, {Capybara.configure test_id} attribute, or label text.
  # The option can be found by its text.
  #
  #     page.select 'March', from: 'Month'
  #
  # @overload select
  # @raise [ArgumentError]
  # @return [Capybara::Node::Element] The option element selected
  #
  # source://capybara//lib/capybara/node/actions.rb#201
  def select(value = T.unsafe(nil), from: T.unsafe(nil), **options); end

  # Find a descendant check box and uncheck it. The check box can be found
  # via name, id, {Capybara.configure test_id} attribute, or label text. If
  # no locator is provided this will match against self or a descendant.
  #
  #     # will uncheck a descendant checkbox with a name, id, or label text matching 'German'
  #     page.uncheck('German')
  #
  #     # will uncheck `el` if it's a checkbox element
  #     el.uncheck()
  #
  # @overload uncheck
  # @return [Capybara::Node::Element] The element unchecked or the label clicked
  #
  # source://capybara//lib/capybara/node/actions.rb#178
  def uncheck(locator = T.unsafe(nil), **options); end

  # Find a select box on the page and unselect a particular option from it. If the select
  # box is a multiple select, {#unselect} can be called multiple times to unselect more than
  # one option. The select box can be found via its name, id, {Capybara.configure test_id} attribute,
  # or label text.
  #
  #     page.unselect 'March', from: 'Month'
  #
  # @overload unselect
  # @raise [ArgumentError]
  # @return [Capybara::Node::Element] The option element unselected
  #
  # source://capybara//lib/capybara/node/actions.rb#230
  def unselect(value = T.unsafe(nil), from: T.unsafe(nil), **options); end

  private

  # source://capybara//lib/capybara/node/actions.rb#364
  def _check_with_label(selector, checked, locator, allow_label_click: T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/node/actions.rb#359
  def _reset_style(element); end

  # source://capybara//lib/capybara/node/actions.rb#353
  def _update_style(element, style); end

  # source://capybara//lib/capybara/node/actions.rb#310
  def find_select_or_datalist_input(from, options); end

  # source://capybara//lib/capybara/node/actions.rb#324
  def select_datalist_option(input, value); end

  # source://capybara//lib/capybara/node/actions.rb#337
  def while_visible(element, visible_css); end
end

# source://capybara//lib/capybara/node/actions.rb#409
Capybara::Node::Actions::CAPTURE_FILE_ELEMENT_SCRIPT = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/node/actions.rb#403
Capybara::Node::Actions::DATALIST_OPTIONS_SCRIPT = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/node/actions.rb#396
Capybara::Node::Actions::RESET_STYLE_SCRIPT = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/node/actions.rb#386
Capybara::Node::Actions::UPDATE_STYLE_SCRIPT = T.let(T.unsafe(nil), String)

# A {Capybara::Node::Base} represents either an element on a page through the subclass
# {Capybara::Node::Element} or a document through {Capybara::Node::Document}.
#
# Both types of Node share the same methods, used for interacting with the
# elements on the page. These methods are divided into three categories,
# finders, actions and matchers. These are found in the modules
# {Capybara::Node::Finders}, {Capybara::Node::Actions} and {Capybara::Node::Matchers}
# respectively.
#
# A {Capybara::Session} exposes all methods from {Capybara::Node::Document} directly:
#
#     session = Capybara::Session.new(:rack_test, my_app)
#     session.visit('/')
#     session.fill_in('Foo', with: 'Bar')    # from Capybara::Node::Actions
#     bar = session.find('#bar')                # from Capybara::Node::Finders
#     bar.select('Baz', from: 'Quox')        # from Capybara::Node::Actions
#     session.has_css?('#foobar')               # from Capybara::Node::Matchers
class Capybara::Node::Base
  include ::Capybara::Node::Finders
  include ::Capybara::Node::Actions
  include ::Capybara::Node::Matchers

  # @return [Base] a new instance of Base
  #
  # source://capybara//lib/capybara/node/base.rb#32
  def initialize(session, base); end

  # Returns the value of attribute base.
  #
  # source://capybara//lib/capybara/node/base.rb#26
  def base; end

  # @api private
  #
  # source://capybara//lib/capybara/node/base.rb#106
  def find_css(css, **options); end

  # @api private
  #
  # source://capybara//lib/capybara/node/base.rb#115
  def find_xpath(xpath, **options); end

  # Returns the value of attribute query_scope.
  #
  # source://capybara//lib/capybara/node/base.rb#26
  def query_scope; end

  # overridden in subclasses, e.g. Capybara::Node::Element
  #
  # source://capybara//lib/capybara/node/base.rb#38
  def reload; end

  # Returns the value of attribute session.
  #
  # source://capybara//lib/capybara/node/base.rb#26
  def session; end

  # @api private
  #
  # source://capybara//lib/capybara/node/base.rb#124
  def session_options; end

  # This method is Capybara's primary defence against asynchronicity
  # problems. It works by attempting to run a given block of code until it
  # succeeds. The exact behaviour of this method depends on a number of
  # factors. Basically there are certain exceptions which, when raised
  # from the block, instead of bubbling up, are caught, and the block is
  # re-run.
  #
  # Certain drivers, such as RackTest, have no support for asynchronous
  # processes, these drivers run the block, and any error raised bubbles up
  # immediately. This allows faster turn around in the case where an
  # expectation fails.
  #
  # Only exceptions that are {Capybara::ElementNotFound} or any subclass
  # thereof cause the block to be rerun. Drivers may specify additional
  # exceptions which also cause reruns. This usually occurs when a node is
  # manipulated which no longer exists on the page. For example, the
  # Selenium driver specifies
  # `Selenium::WebDriver::Error::ObsoleteElementError`.
  #
  # As long as any of these exceptions are thrown, the block is re-run,
  # until a certain amount of time passes. The amount of time defaults to
  # {Capybara.default_max_wait_time} and can be overridden through the `seconds`
  # argument. This time is compared with the system time to see how much
  # time has passed. On rubies/platforms which don't support access to a monotonic process clock
  # if the return value of `Time.now` is stubbed out, Capybara will raise `Capybara::FrozenInTime`.
  #
  # @param seconds [Integer] (current sessions default_max_wait_time) Maximum number of seconds to retry this block
  # @param errors [Array<Exception>] (driver.invalid_element_errors +
  #   [Capybara::ElementNotFound]) exception types that cause the block to be rerun
  # @raise [Capybara::FrozenInTime] If the return value of `Time.now` appears stuck
  # @return [Object] The result of the given block
  #
  # source://capybara//lib/capybara/node/base.rb#76
  def synchronize(seconds = T.unsafe(nil), errors: T.unsafe(nil)); end

  # source://capybara//lib/capybara/node/base.rb#128
  def to_capybara_node; end

  protected

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/base.rb#134
  def catch_error?(error, errors = T.unsafe(nil)); end

  # source://capybara//lib/capybara/node/base.rb#139
  def driver; end
end

# A {Capybara::Document} represents an HTML document. Any operation
# performed on it will be performed on the entire document.
#
# @see Capybara::Node
class Capybara::Node::Document < ::Capybara::Node::Base
  include ::Capybara::Node::DocumentMatchers

  # source://capybara//lib/capybara/node/document.rb#39
  def evaluate_script(*args); end

  # source://capybara//lib/capybara/node/document.rb#35
  def execute_script(*args); end

  # source://capybara//lib/capybara/node/document.rb#15
  def inspect; end

  # source://capybara//lib/capybara/node/document.rb#43
  def scroll_to(*args, quirks: T.unsafe(nil), **options); end

  # @return [String] The text of the document
  #
  # source://capybara//lib/capybara/node/document.rb#23
  def text(type = T.unsafe(nil), normalize_ws: T.unsafe(nil)); end

  # @return [String] The title of the document
  #
  # source://capybara//lib/capybara/node/document.rb#31
  def title; end
end

module Capybara::Node::DocumentMatchers
  # Asserts that the page doesn't have the given title.
  #
  # @option options
  # @option options
  # @overload assert_no_title
  # @overload assert_no_title
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/node/document_matchers.rb#32
  def assert_no_title(title, **options); end

  # Asserts that the page has the given title.
  #
  # @option options
  # @option options
  # @overload assert_title
  # @overload assert_title
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/node/document_matchers.rb#19
  def assert_title(title, **options); end

  # Checks if the page doesn't have the given title.
  #
  # @option options
  # @option options
  # @overload has_no_title?
  # @overload has_no_title?
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/document_matchers.rb#54
  def has_no_title?(title, **options); end

  # Checks if the page has the given title.
  #
  # @option options
  # @option options
  # @overload has_title?
  # @overload has_title?
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/document_matchers.rb#44
  def has_title?(title, **options); end

  private

  # source://capybara//lib/capybara/node/document_matchers.rb#60
  def _verify_title(title, options); end
end

# A {Capybara::Node::Element} represents a single element on the page. It is possible
# to interact with the contents of this element the same as with a document:
#
#     session = Capybara::Session.new(:rack_test, my_app)
#
#     bar = session.find('#bar')              # from Capybara::Node::Finders
#     bar.select('Baz', from: 'Quox')      # from Capybara::Node::Actions
#
# {Capybara::Node::Element} also has access to HTML attributes and other properties of the
# element:
#
#      bar.value
#      bar.text
#      bar[:title]
#
# @see Capybara::Node
class Capybara::Node::Element < ::Capybara::Node::Base
  # @return [Element] a new instance of Element
  #
  # source://capybara//lib/capybara/node/element.rb#25
  def initialize(session, base, query_scope, query); end

  # Retrieve the given attribute.
  #
  #     element[:title] # => HTML title attribute
  #
  # @param attribute [Symbol] The attribute to retrieve
  # @return [String] The value of the attribute
  #
  # source://capybara//lib/capybara/node/element.rb#73
  def [](attribute); end

  # source://capybara//lib/capybara/node/element.rb#33
  def allow_reload!(idx = T.unsafe(nil)); end

  # Whether or not the element is checked.
  #
  # @return [Boolean] Whether the element is checked
  #
  # source://capybara//lib/capybara/node/element.rb#326
  def checked?; end

  # Click the Element.
  #
  # If the driver dynamic pages (JS) and the element is currently non-interactable, this method will
  # continuously retry the action until either the element becomes interactable or the maximum
  # wait time expires.
  #
  # Both x: and y: must be specified if an offset is wanted, if not specified the click will occur at the middle of the element.
  #
  # @option options
  # @overload click
  # @param wait [false, Numeric] Maximum time to wait for the action to succeed. Defaults to {Capybara.configure default_max_wait_time}.
  # @param options [Hash] a customizable set of options
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#170
  def click(*keys, **options); end

  # Whether or not the element is disabled.
  #
  # @return [Boolean] Whether the element is disabled
  #
  # source://capybara//lib/capybara/node/element.rb#346
  def disabled?; end

  # Double Click the Element.
  #
  # If the driver dynamic pages (JS) and the element is currently non-interactable, this method will
  # continuously retry the action until either the element becomes interactable or the maximum
  # wait time expires.
  #
  # Both x: and y: must be specified if an offset is wanted, if not specified the click will occur at the middle of the element.
  #
  # @overload double_click
  # @param wait [false, Numeric] Maximum time to wait for the action to succeed. Defaults to {Capybara.configure default_max_wait_time}.
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#197
  def double_click(*keys, **options); end

  # Drag the element to the given other element.
  #
  #     source = page.find('#foo')
  #     target = page.find('#bar')
  #     source.drag_to(target)
  #
  # @option options
  # @option options
  # @option options
  # @param node [Capybara::Node::Element] The element to drag to
  # @param options [Hash] Driver specific options for dragging. May not be supported by all drivers.
  # @return [Capybara::Node::Element] The dragged element
  #
  # source://capybara//lib/capybara/node/element.rb#418
  def drag_to(node, **options); end

  # Drop items on the current element.
  #
  #     target = page.find('#foo')
  #     target.drop('/some/path/file.csv')
  #
  # @overload drop
  # @overload drop
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#437
  def drop(*args); end

  # Evaluate the given JavaScript in the context of the element and obtain the result from a
  # callback function which will be passed as the last argument to the script. `this` in the
  # script will refer to the element this is called on.
  #
  # @param script [String] A string of JavaScript to evaluate
  # @return [Object] The result of the evaluated JavaScript (may be driver specific)
  #
  # source://capybara//lib/capybara/node/element.rb#529
  def evaluate_async_script(script, *args); end

  # Evaluate the given JS in the context of the element and return the result. Be careful when using this with
  # scripts that return complex objects, such as jQuery statements. {#execute_script} might
  # be a better alternative. `this` in the script will refer to the element this is called on.
  #
  # @param script [String] A string of JavaScript to evaluate
  # @return [Object] The result of the evaluated JavaScript (may be driver specific)
  #
  # source://capybara//lib/capybara/node/element.rb#512
  def evaluate_script(script, *args); end

  # Execute the given JS in the context of the element not returning a result. This is useful for scripts that return
  # complex objects, such as jQuery statements. {#execute_script} should be used over
  # {#evaluate_script} whenever a result is not expected or needed. `this` in the script will refer to the element this is called on.
  #
  # @param script [String] A string of JavaScript to execute
  # @param args Optional arguments that will be passed to the script. Driver support for this is optional and types of objects supported may differ between drivers
  #
  # source://capybara//lib/capybara/node/element.rb#495
  def execute_script(script, *args); end

  # Toggle the elements background color between white and black for a period of time.
  #
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#542
  def flash; end

  # Hover on the Element.
  #
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#284
  def hover; end

  # @api private
  #
  # source://capybara//lib/capybara/node/element.rb#586
  def initial_cache; end

  # A human-readable representation of the element.
  #
  # @return [String] A string representation
  #
  # source://capybara//lib/capybara/node/element.rb#577
  def inspect; end

  # Whether or not the element supports multiple results.
  #
  # @return [Boolean] Whether the element supports multiple results.
  #
  # source://capybara//lib/capybara/node/element.rb#366
  def multiple?; end

  # @return [Object] The native element from the driver, this allows access to driver specific methods
  #
  # source://capybara//lib/capybara/node/element.rb#42
  def native; end

  # Whether or not the element is currently in the viewport and it (or descendants)
  # would be considered clickable at the elements center point.
  #
  # @return [Boolean] Whether the elements center is obscured.
  #
  # source://capybara//lib/capybara/node/element.rb#316
  def obscured?; end

  # An XPath expression describing where on the page the element can be found.
  #
  # @return [String] An XPath expression
  #
  # source://capybara//lib/capybara/node/element.rb#376
  def path; end

  # Whether or not the element is readonly.
  #
  # @return [Boolean] Whether the element is readonly
  #
  # source://capybara//lib/capybara/node/element.rb#356
  def readonly?; end

  # source://capybara//lib/capybara/node/element.rb#380
  def rect; end

  # @api private
  #
  # source://capybara//lib/capybara/node/element.rb#560
  def reload; end

  # Right Click the Element.
  #
  # If the driver dynamic pages (JS) and the element is currently non-interactable, this method will
  # continuously retry the action until either the element becomes interactable or the maximum
  # wait time expires.
  #
  # Both x: and y: must be specified if an offset is wanted, if not specified the click will occur at the middle of the element.
  #
  # @option options
  # @overload right_click
  # @param wait [false, Numeric] Maximum time to wait for the action to succeed. Defaults to {Capybara.configure default_max_wait_time}.
  # @param options [Hash] a customizable set of options
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#184
  def right_click(*keys, **options); end

  # Scroll the page or element.
  #
  # @overload scroll_to
  # @overload scroll_to
  # @overload scroll_to
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#462
  def scroll_to(pos_or_el_or_x, y = T.unsafe(nil), align: T.unsafe(nil), offset: T.unsafe(nil)); end

  # Select this node if it is an option element inside a select tag.
  #
  # If the driver dynamic pages (JS) and the element is currently non-interactable, this method will
  # continuously retry the action until either the element becomes interactable or the maximum
  # wait time expires.
  #
  # @param wait [false, Numeric] Maximum time to wait for the action to succeed. Defaults to {Capybara.configure default_max_wait_time}.
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#139
  def select_option(wait: T.unsafe(nil)); end

  # Whether or not the element is selected.
  #
  # @return [Boolean] Whether the element is selected
  #
  # source://capybara//lib/capybara/node/element.rb#336
  def selected?; end

  # Send Keystrokes to the Element.
  #
  # Examples:
  #
  #     element.send_keys "foo"                     #=> value: 'foo'
  #     element.send_keys "tet", :left, "s"         #=> value: 'test'
  #     element.send_keys [:control, 'a'], :space   #=> value: ' ' - assuming ctrl-a selects all contents
  #
  # Symbols supported for keys:
  # * :cancel
  # * :help
  # * :backspace
  # * :tab
  # * :clear
  # * :return
  # * :enter
  # * :shift
  # * :control
  # * :alt
  # * :pause
  # * :escape
  # * :space
  # * :page_up
  # * :page_down
  # * :end
  # * :home
  # * :left
  # * :up
  # * :right
  # * :down
  # * :insert
  # * :delete
  # * :semicolon
  # * :equals
  # * :numpad0
  # * :numpad1
  # * :numpad2
  # * :numpad3
  # * :numpad4
  # * :numpad5
  # * :numpad6
  # * :numpad7
  # * :numpad8
  # * :numpad9
  # * :multiply      - numeric keypad *
  # * :add           - numeric keypad +
  # * :separator     - numeric keypad 'separator' key ??
  # * :subtract      - numeric keypad -
  # * :decimal       - numeric keypad .
  # * :divide        - numeric keypad /
  # * :f1
  # * :f2
  # * :f3
  # * :f4
  # * :f5
  # * :f6
  # * :f7
  # * :f8
  # * :f9
  # * :f10
  # * :f11
  # * :f12
  # * :meta
  # * :command      - alias of :meta
  #
  # @overload send_keys
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#274
  def send_keys(*args); end

  # Set the value of the form element to the given value.
  #
  # @param value [String] The new value
  # @param options [Hash] Driver specific options for how to set the value. Take default values from {Capybara.configure default_set_options}.
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#117
  def set(value, **options); end

  # Return the shadow_root for the current element
  #
  # @return [Capybara::Node::Element] The shadow root
  #
  # source://capybara//lib/capybara/node/element.rb#481
  def shadow_root; end

  # Retrieve the given CSS styles.
  #
  #     element.style('color', 'font-size') # => Computed values of CSS 'color' and 'font-size' styles
  #
  # @param styles [Array<String>] Names of the desired CSS properties
  # @raise [ArgumentError]
  # @return [Hash] Hash of the CSS property names to computed values
  #
  # source://capybara//lib/capybara/node/element.rb#86
  def style(*styles); end

  # @return [String] The tag name of the element
  #
  # source://capybara//lib/capybara/node/element.rb#293
  def tag_name; end

  # Retrieve the text of the element. If {Capybara.configure ignore_hidden_elements}
  # is `true`, which it is by default, then this will return only text
  # which is visible. The exact semantics of this may differ between
  # drivers, but generally any text within elements with `display:none` is
  # ignored. This behaviour can be overridden by passing `:all` to this
  # method.
  #
  # @param type [:all, :visible] Whether to return only visible or all text
  # @return [String] The text of the element
  #
  # source://capybara//lib/capybara/node/element.rb#58
  def text(type = T.unsafe(nil), normalize_ws: T.unsafe(nil)); end

  # Trigger any event on the current element, for example mouseover or focus
  # events. Not supported with the Selenium driver, and SHOULDN'T BE USED IN TESTING unless you
  # fully understand why you're using it, that it can allow actions a user could never
  # perform, and that it may completely invalidate your test.
  #
  # @param event [String] The name of the event to trigger
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#394
  def trigger(event); end

  # Unselect this node if it is an option element inside a multiple select tag.
  #
  # If the driver dynamic pages (JS) and the element is currently non-interactable, this method will
  # continuously retry the action until either the element becomes interactable or the maximum
  # wait time expires.
  #
  # @param wait [false, Numeric] Maximum time to wait for the action to succeed. Defaults to {Capybara.configure default_max_wait_time}.
  # @return [Capybara::Node::Element] The element
  #
  # source://capybara//lib/capybara/node/element.rb#150
  def unselect_option(wait: T.unsafe(nil)); end

  # @return [String] The value of the form element
  #
  # source://capybara//lib/capybara/node/element.rb#105
  def value; end

  # Whether or not the element is visible. Not all drivers support CSS, so
  # the result may be inaccurate.
  #
  # @return [Boolean] Whether the element is visible
  #
  # source://capybara//lib/capybara/node/element.rb#305
  def visible?; end

  private

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/node/element.rb#604
  def perform_click_action(keys, wait: T.unsafe(nil), **options); end
end

# source://capybara//lib/capybara/node/element.rb#590
Capybara::Node::Element::STYLE_SCRIPT = T.let(T.unsafe(nil), String)

module Capybara::Node::Finders
  # Find all elements on the page matching the given selector
  # and options.
  #
  # Both XPath and CSS expressions are supported, but Capybara
  # does not try to automatically distinguish between them. The
  # following statements are equivalent:
  #
  #     page.all(:css, 'a#person_123')
  #     page.all(:xpath, './/a[@id="person_123"]')
  #
  # If the type of selector is left out, Capybara uses
  # {Capybara.configure default_selector}. It's set to `:css` by default.
  #
  #     page.all("a#person_123")
  #
  #     Capybara.default_selector = :xpath
  #     page.all('.//a[@id="person_123"]')
  #
  # The set of found elements can further be restricted by specifying
  # options. It's possible to select elements by their text or visibility:
  #
  #     page.all('a', text: 'Home')
  #     page.all('#menu li', visible: true)
  #
  # By default Capybara's waiting behavior will wait up to {Capybara.configure default_max_wait_time}
  # seconds for matching elements to be available and then return an empty result if none
  # are available. It is possible to set expectations on the number of results located and
  # Capybara will raise an exception if the number of elements located don't satisfy the
  # specified conditions. The expectations can be set using:
  #
  #     page.assert_selector('p#foo', count: 4)
  #     page.assert_selector('p#foo', maximum: 10)
  #     page.assert_selector('p#foo', minimum: 1)
  #     page.assert_selector('p#foo', between: 1..10)
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @overload all
  # @overload all
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] The number of elements found doesn't match the specified conditions
  # @return [Capybara::Result] A collection of found elements
  #
  # source://capybara//lib/capybara/node/finders.rb#255
  def all(*args, allow_reload: T.unsafe(nil), **options, &optional_filter_block); end

  # Find an {Capybara::Node::Element} based on the given arguments that is also an ancestor of the element called on.
  # {#ancestor} will raise an error if the element is not found.
  #
  # {#ancestor} takes the same options as {#find}.
  #
  #     element.ancestor('#foo').find('.bar')
  #     element.ancestor(:xpath, './/div[contains(., "bar")]')
  #     element.ancestor('ul', text: 'Quox').click_link('Delete')
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @param options [Hash] a customizable set of options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ElementNotFound] If the element can't be found before time expires
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#81
  def ancestor(*args, **options, &optional_filter_block); end

  # Find an {Capybara::Node::Element} based on the given arguments. {#find} will raise an error if the element
  # is not found.
  #
  #     page.find('#foo').find('.bar')
  #     page.find(:xpath, './/div[contains(., "bar")]')
  #     page.find('li', text: 'Quox').click_link('Delete')
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ElementNotFound] If the element can't be found before time expires
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#51
  def find(*args, **options, &optional_filter_block); end

  # Find all elements on the page matching the given selector
  # and options.
  #
  # Both XPath and CSS expressions are supported, but Capybara
  # does not try to automatically distinguish between them. The
  # following statements are equivalent:
  #
  #     page.all(:css, 'a#person_123')
  #     page.all(:xpath, './/a[@id="person_123"]')
  #
  # If the type of selector is left out, Capybara uses
  # {Capybara.configure default_selector}. It's set to `:css` by default.
  #
  #     page.all("a#person_123")
  #
  #     Capybara.default_selector = :xpath
  #     page.all('.//a[@id="person_123"]')
  #
  # The set of found elements can further be restricted by specifying
  # options. It's possible to select elements by their text or visibility:
  #
  #     page.all('a', text: 'Home')
  #     page.all('#menu li', visible: true)
  #
  # By default Capybara's waiting behavior will wait up to {Capybara.configure default_max_wait_time}
  # seconds for matching elements to be available and then return an empty result if none
  # are available. It is possible to set expectations on the number of results located and
  # Capybara will raise an exception if the number of elements located don't satisfy the
  # specified conditions. The expectations can be set using:
  #
  #     page.assert_selector('p#foo', count: 4)
  #     page.assert_selector('p#foo', maximum: 10)
  #     page.assert_selector('p#foo', minimum: 1)
  #     page.assert_selector('p#foo', between: 1..10)
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @overload all
  # @overload all
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] The number of elements found doesn't match the specified conditions
  # @return [Capybara::Result] A collection of found elements
  #
  # source://capybara//lib/capybara/node/finders.rb#255
  def find_all(*args, allow_reload: T.unsafe(nil), **options, &optional_filter_block); end

  # Find a button on the page.
  # This can be any `<input>` element of type submit, reset, image, button or it can be a
  # `<button>` element. All buttons can be found by their id, name, {Capybara.configure test_id} attribute, value, or title.
  # `<button>` elements can also be found by their text content, and image `<input>` elements by their alt attribute.
  #
  # @overload find_button
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#182
  def find_button(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Find a element on the page, given its id.
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @param id [String] id of element
  # @param options [Hash] a customizable set of options
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#196
  def find_by_id(id, **options, &optional_filter_block); end

  # Find a form field on the page. The field can be found by its name, id or label text.
  #
  # @overload find_field
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#135
  def find_field(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Find a link on the page. The link can be found by its id or text.
  #
  # @overload find_link
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#155
  def find_link(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Find the first element on the page matching the given selector
  # and options. By default {#first} will wait up to {Capybara.configure default_max_wait_time}
  # seconds for matching elements to appear and then raise an error if no matching
  # element is found, or `nil` if the provided count options allow for empty results.
  #
  # @overload first
  # @raise [Capybara::ElementNotFound] If element(s) matching the provided options can't be found before time expires
  # @return [Capybara::Node::Element] The found element or nil
  #
  # source://capybara//lib/capybara/node/finders.rb#291
  def first(*args, **options, &optional_filter_block); end

  # Find an {Capybara::Node::Element} based on the given arguments that is also a sibling of the element called on.
  # {#sibling} will raise an error if the element is not found.
  #
  # {#sibling} takes the same options as {#find}.
  #
  #     element.sibling('#foo').find('.bar')
  #     element.sibling(:xpath, './/div[contains(., "bar")]')
  #     element.sibling('ul', text: 'Quox').click_link('Delete')
  #
  # If the driver is capable of executing JavaScript, this method will wait for a set amount of time
  # and continuously retry finding the element until either the element is found or the time
  # expires. The length of time this method will wait is controlled through {Capybara.configure default_max_wait_time}.
  #
  # @option options
  # @param options [Hash] a customizable set of options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ElementNotFound] If the element can't be found before time expires
  # @return [Capybara::Node::Element] The found element
  #
  # source://capybara//lib/capybara/node/finders.rb#104
  def sibling(*args, **options, &optional_filter_block); end

  private

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/finders.rb#316
  def ambiguous?(query, result); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/finders.rb#324
  def options_include_minimum?(opts); end

  # source://capybara//lib/capybara/node/finders.rb#328
  def parent; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/finders.rb#320
  def prefer_exact?(query); end

  # source://capybara//lib/capybara/node/finders.rb#298
  def synced_resolve(query); end
end

module Capybara::Node::Matchers
  # source://capybara//lib/capybara/node/matchers.rb#816
  def ==(other); end

  # Asserts that all of the provided selectors are present on the given page
  # or descendants of the current node.  If options are provided, the assertion
  # will check that each locator is present with those options as well (other than `:wait`).
  #
  #     page.assert_all_of_selectors(:custom, 'Tom', 'Joe', visible: all)
  #     page.assert_all_of_selectors(:css, '#my_div', 'a.not_clicked')
  #
  # It accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  # The `:wait` option applies to all of the selectors as a group, so all of the locators must be present
  # within `:wait` (defaults to {Capybara.configure default_max_wait_time}) seconds.
  #
  # @overload assert_all_of_selectors
  #
  # source://capybara//lib/capybara/node/matchers.rb#159
  def assert_all_of_selectors(*args, **options, &optional_filter_block); end

  # Asserts that a given selector matches an ancestor of the current node.
  #
  #     element.assert_ancestor('p#foo')
  #
  # Accepts the same options as {#assert_selector}
  #
  # @param options [Hash] a customizable set of options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector does not exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#741
  def assert_ancestor(*args, &optional_filter_block); end

  # Asserts that any of the provided selectors are present on the given page
  # or descendants of the current node. If options are provided, the assertion
  # will check that each locator is present with those options as well (other than `:wait`).
  #
  #     page.assert_any_of_selectors(:custom, 'Tom', 'Joe', visible: all)
  #     page.assert_any_of_selectors(:css, '#my_div', 'a.not_clicked')
  #
  # It accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  # The `:wait` option applies to all of the selectors as a group, so any of the locators must be present
  # within `:wait` (defaults to {Capybara.configure default_max_wait_time}) seconds.
  #
  # @overload assert_any_of_selectors
  #
  # source://capybara//lib/capybara/node/matchers.rb#201
  def assert_any_of_selectors(*args, wait: T.unsafe(nil), **options, &optional_filter_block); end

  # Asserts that the current node matches a given selector.
  #
  #     node.assert_matches_selector('p#foo')
  #     node.assert_matches_selector(:xpath, '//p[@id="foo"]')
  #     node.assert_matches_selector(:foo)
  #
  # It also accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  #     node.assert_matches_selector('li', text: 'Horse', visible: true)
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector does not match
  #
  # source://capybara//lib/capybara/node/matchers.rb#561
  def assert_matches_selector(*args, &optional_filter_block); end

  # Asserts that an element has the specified CSS styles.
  #
  #     element.assert_matches_style( 'color' => 'rgb(0,0,255)', 'font-size' => /px/ )
  #
  # @param styles [Hash]
  # @raise [Capybara::ExpectationNotMet] If the element doesn't have the specified styles
  #
  # source://capybara//lib/capybara/node/matchers.rb#126
  def assert_matches_style(styles = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/node/matchers.rb#749
  def assert_no_ancestor(*args, &optional_filter_block); end

  # Asserts that a given selector is not on the page or a descendant of the current node.
  # Usage is identical to {#assert_selector}.
  #
  # Query options such as `:count`, `:minimum`, `:maximum`, and `:between` are
  # considered to be an integral part of the selector. This will return
  # `true`, for example, if a page contains 4 anchors but the query expects 5:
  #
  #     page.assert_no_selector('a', minimum: 1) # Found, raises Capybara::ExpectationNotMet
  #     page.assert_no_selector('a', count: 4)   # Found, raises Capybara::ExpectationNotMet
  #     page.assert_no_selector('a', count: 5)   # Not Found, returns true
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#233
  def assert_no_selector(*args, &optional_filter_block); end

  # source://capybara//lib/capybara/node/matchers.rb#792
  def assert_no_sibling(*args, &optional_filter_block); end

  # Asserts that the page or current node doesn't have the given text content,
  # ignoring any HTML tags.
  #
  # @overload assert_no_text
  # @overload assert_no_text
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/node/matchers.rb#691
  def assert_no_text(type_or_text, *args, **opts); end

  # Asserts that none of the provided selectors are present on the given page
  # or descendants of the current node. If options are provided, the assertion
  # will check that each locator is not present with those options as well (other than `:wait`).
  #
  #     page.assert_none_of_selectors(:custom, 'Tom', 'Joe', visible: all)
  #     page.assert_none_of_selectors(:css, '#my_div', 'a.not_clicked')
  #
  # It accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  # The `:wait` option applies to all of the selectors as a group, so none of the locators must be present
  # within `:wait` (defaults to {Capybara.configure default_max_wait_time}) seconds.
  #
  # @overload assert_none_of_selectors
  #
  # source://capybara//lib/capybara/node/matchers.rb#180
  def assert_none_of_selectors(*args, **options, &optional_filter_block); end

  # Asserts that the current node does not match a given selector.
  # Usage is identical to {#assert_matches_selector}.
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector matches
  #
  # source://capybara//lib/capybara/node/matchers.rb#575
  def assert_not_matches_selector(*args, &optional_filter_block); end

  # Asserts that a given selector is on the page or a descendant of the current node.
  #
  #     page.assert_selector('p#foo')
  #     page.assert_selector(:xpath, './/p[@id="foo"]')
  #     page.assert_selector(:foo)
  #
  # By default it will check if the expression occurs at least once,
  # but a different number can be specified.
  #
  #     page.assert_selector('p#foo', count: 4)
  #
  # This will check if the expression occurs exactly 4 times. See
  # {Capybara::Node::Finders#all} for other available result size options.
  #
  # If a `:count` of 0 is specified, it will behave like {#assert_no_selector};
  # however, use of that method is preferred over this one.
  #
  # It also accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  #     page.assert_selector('li', text: 'Horse', visible: true)
  #
  # {#assert_selector} can also accept XPath expressions generated by the
  # XPath gem:
  #
  #     page.assert_selector(:xpath, XPath.descendant(:p))
  #
  # @option options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector does not exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#109
  def assert_selector(*args, &optional_filter_block); end

  # Asserts that a given selector matches a sibling of the current node.
  #
  #     element.assert_sibling('p#foo')
  #
  # Accepts the same options as {#assert_selector}
  #
  # @param options [Hash] a customizable set of options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] If the selector does not exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#784
  def assert_sibling(*args, &optional_filter_block); end

  # @deprecated Use {#assert_matches_style} instead.
  #
  # source://capybara//lib/capybara/node/matchers.rb#139
  def assert_style(styles = T.unsafe(nil), **options); end

  # Asserts that the page or current node has the given text content,
  # ignoring any HTML tags.
  #
  # @overload assert_text
  # @overload assert_text
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/node/matchers.rb#675
  def assert_text(type_or_text, *args, **opts); end

  # Predicate version of {#assert_ancestor}
  #
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#761
  def has_ancestor?(*args, **options, &optional_filter_block); end

  # Checks if the page or current node has a button with the given
  # text, value or id.
  #
  # @param locator [String] The text, value or id of a button to check for
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#358
  def has_button?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has a radio button or
  # checkbox with the given label, value, id, or {Capybara.configure test_id} attribute that is currently
  # checked.
  #
  # @param locator [String] The label, name or id of a checked field
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#423
  def has_checked_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has the given text content,
  # ignoring any HTML tags.
  #
  # By default it will check if the text occurs at least once,
  # but a different number can be specified.
  #
  #     page.has_text?('lorem ipsum', between: 2..4)
  #
  # This will check if the text occurs from 2 to 4 times.
  #
  # @overload has_text?
  # @overload has_text?
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#713
  def has_content?(*args, **options); end

  # Checks if a given CSS selector is on the page or a descendant of the current node.
  #
  #     page.has_css?('p#foo')
  #
  # By default it will check if the selector occurs at least once,
  # but a different number can be specified.
  #
  #     page.has_css?('p#foo', count: 4)
  #
  # This will check if the selector occurs exactly 4 times.
  #
  # It also accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  #     page.has_css?('li', text: 'Horse', visible: true)
  #
  # @option options
  # @param path [String] A CSS selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean] If the selector exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#309
  def has_css?(path, **options, &optional_filter_block); end

  # Checks if the page or current node has a form field with the given
  # label, name or id.
  #
  # For text fields and other textual fields, such as textareas and
  # HTML5 email/url/etc. fields, it's possible to specify a `:with`
  # option to specify the text the field should contain:
  #
  #     page.has_field?('Name', with: 'Jonas')
  #
  # It is also possible to filter by the field type attribute:
  #
  #     page.has_field?('Email', type: 'email')
  #
  # NOTE: 'textarea' and 'select' are valid type values, matching the associated tag names.
  #
  # @option options
  # @option options
  # @param locator [String] The label, name or id of a field to check for
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#396
  def has_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has a link with the given
  # text or id.
  #
  # @option options
  # @param locator [String] The text or id of a link to check for
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#334
  def has_link?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Predicate version of {#assert_no_ancestor}
  #
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#769
  def has_no_ancestor?(*args, **options, &optional_filter_block); end

  # Checks if the page or current node has no button with the given
  # text, value or id.
  #
  # @param locator [String] The text, value or id of a button to check for
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#370
  def has_no_button?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has no radio button or
  # checkbox with the given label, value or id, or {Capybara.configure test_id} attribute that is currently
  # checked.
  #
  # @param locator [String] The label, name or id of a checked field
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#436
  def has_no_checked_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node does not have the given text
  # content, ignoring any HTML tags and normalizing whitespace.
  #
  # @overload has_no_text?
  # @overload has_no_text?
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#725
  def has_no_content?(*args, **options); end

  # Checks if a given CSS selector is not on the page or a descendant of the current node.
  # Usage is identical to {#has_css?}.
  #
  # @param path [String] A CSS selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#321
  def has_no_css?(path, **options, &optional_filter_block); end

  # Checks if the page or current node has no form field with the given
  # label, name or id. See {#has_field?}.
  #
  # @option options
  # @option options
  # @param locator [String] The label, name or id of a field to check for
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#410
  def has_no_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has no link with the given
  # text or id.
  #
  # @param locator [String] The text or id of a link to check for
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#346
  def has_no_link?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has no select field with the
  # given label, name or id. See {#has_select?}.
  #
  # @param locator [String] The label, name or id of a select box
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#507
  def has_no_select?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if a given selector is not on the page or a descendant of the current node.
  # Usage is identical to {#has_selector?}.
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#50
  def has_no_selector?(*args, **options, &optional_filter_block); end

  # Predicate version of {#assert_no_sibling}
  #
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#812
  def has_no_sibling?(*args, **options, &optional_filter_block); end

  # Checks if the page or current node has no table with the given id
  # or caption. See {#has_table?}.
  #
  # @param locator [String] The id or caption of a table
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#541
  def has_no_table?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node does not have the given text
  # content, ignoring any HTML tags and normalizing whitespace.
  #
  # @overload has_no_text?
  # @overload has_no_text?
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#725
  def has_no_text?(*args, **options); end

  # Checks if the page or current node has no radio button or
  # checkbox with the given label, value or id, or {Capybara.configure test_id} attribute that is currently
  # unchecked.
  #
  # @param locator [String] The label, name or id of an unchecked field
  # @return [Boolean] Whether it doesn't exist
  #
  # source://capybara//lib/capybara/node/matchers.rb#462
  def has_no_unchecked_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if a given XPath expression is not on the page or a descendant of the current node.
  # Usage is identical to {#has_xpath?}.
  #
  # @param path [String] An XPath expression
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#282
  def has_no_xpath?(path, **options, &optional_filter_block); end

  # Checks if the page or current node has a select field with the
  # given label, name or id.
  #
  # It can be specified which option should currently be selected:
  #
  #     page.has_select?('Language', selected: 'German')
  #
  # For multiple select boxes, several options may be specified:
  #
  #     page.has_select?('Language', selected: ['English', 'German'])
  #
  # It's also possible to check if the exact set of options exists for
  # this select box:
  #
  #     page.has_select?('Language', options: ['English', 'German', 'Spanish'])
  #
  # You can also check for a partial set of options:
  #
  #     page.has_select?('Language', with_options: ['English', 'German'])
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param locator [String] The label, name or id of a select box
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#495
  def has_select?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if a given selector is on the page or a descendant of the current node.
  #
  #     page.has_selector?('p#foo')
  #     page.has_selector?(:xpath, './/p[@id="foo"]')
  #     page.has_selector?(:foo)
  #
  # By default it will check if the expression occurs at least once,
  # but a different number can be specified.
  #
  #     page.has_selector?('p.foo', count: 4)
  #
  # This will check if the expression occurs exactly 4 times.
  #
  # It also accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  #     page.has_selector?('li', text: 'Horse', visible: true)
  #
  # {#has_selector?} can also accept XPath expressions generated by the
  # XPath gem:
  #
  #     page.has_selector?(:xpath, XPath.descendant(:p))
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean] If the expression exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#38
  def has_selector?(*args, **options, &optional_filter_block); end

  # Predicate version of {#assert_sibling}
  #
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#804
  def has_sibling?(*args, **options, &optional_filter_block); end

  # @deprecated Use {#matches_style?} instead.
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#71
  def has_style?(styles = T.unsafe(nil), **options); end

  # Checks if the page or current node has a table with the given id
  # or caption:
  #
  #    page.has_table?('People')
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param locator [String] The id or caption of a table
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#529
  def has_table?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if the page or current node has the given text content,
  # ignoring any HTML tags.
  #
  # By default it will check if the text occurs at least once,
  # but a different number can be specified.
  #
  #     page.has_text?('lorem ipsum', between: 2..4)
  #
  # This will check if the text occurs from 2 to 4 times.
  #
  # @overload has_text?
  # @overload has_text?
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#713
  def has_text?(*args, **options); end

  # Checks if the page or current node has a radio button or
  # checkbox with the given label, value or id, or {Capybara.configure test_id} attribute that is currently
  # unchecked.
  #
  # @param locator [String] The label, name or id of an unchecked field
  # @return [Boolean] Whether it exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#449
  def has_unchecked_field?(locator = T.unsafe(nil), **options, &optional_filter_block); end

  # Checks if a given XPath expression is on the page or a descendant of the current node.
  #
  #     page.has_xpath?('.//p[@id="foo"]')
  #
  # By default it will check if the expression occurs at least once,
  # but a different number can be specified.
  #
  #     page.has_xpath?('.//p[@id="foo"]', count: 4)
  #
  # This will check if the expression occurs exactly 4 times.
  #
  # It also accepts all options that {Capybara::Node::Finders#all} accepts,
  # such as `:text` and `:visible`.
  #
  #     page.has_xpath?('.//li', text: 'Horse', visible: true)
  #
  # {#has_xpath?} can also accept XPath expressions generated by the
  # XPath gem:
  #
  #     xpath = XPath.generate { |x| x.descendant(:p) }
  #     page.has_xpath?(xpath)
  #
  # @option options
  # @param path [String] An XPath expression
  # @param options [Hash] a customizable set of options
  # @return [Boolean] If the expression exists
  #
  # source://capybara//lib/capybara/node/matchers.rb#270
  def has_xpath?(path, **options, &optional_filter_block); end

  # Checks if the current node matches given CSS selector.
  #
  # @param css [String] The CSS selector to match against the current code
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#610
  def matches_css?(css, **options, &optional_filter_block); end

  # Checks if the current node matches given selector.
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#588
  def matches_selector?(*args, **options, &optional_filter_block); end

  # Checks if a an element has the specified CSS styles.
  #
  #     element.matches_style?( 'color' => 'rgb(0,0,255)', 'font-size' => /px/ )
  #
  # @param styles [Hash]
  # @return [Boolean] If the styles match
  #
  # source://capybara//lib/capybara/node/matchers.rb#63
  def matches_style?(styles = T.unsafe(nil), **options); end

  # Checks if the current node matches given XPath expression.
  #
  # @param xpath [String, XPath::Expression] The XPath expression to match against the current code
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#599
  def matches_xpath?(xpath, **options, &optional_filter_block); end

  # Checks if the current node does not match given CSS selector.
  #
  # @param css [String] The CSS selector to match against the current code
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#644
  def not_matches_css?(css, **options, &optional_filter_block); end

  # Checks if the current node does not match given selector.
  # Usage is identical to {#has_selector?}.
  #
  # @param kind [Symbol] Optional selector type (:css, :xpath, :field, etc.). Defaults to {Capybara.configure default_selector}.
  # @param locator [String] The locator for the specified selector
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#622
  def not_matches_selector?(*args, **options, &optional_filter_block); end

  # Checks if the current node does not match given XPath expression.
  #
  # @param xpath [String, XPath::Expression] The XPath expression to match against the current code
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/matchers.rb#633
  def not_matches_xpath?(xpath, **options, &optional_filter_block); end

  private

  # source://capybara//lib/capybara/node/matchers.rb#867
  def _set_query_session_options(*query_args); end

  # source://capybara//lib/capybara/node/matchers.rb#849
  def _verify_match_result(query_args, optional_filter_block); end

  # source://capybara//lib/capybara/node/matchers.rb#826
  def _verify_multiple(*args, wait: T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/node/matchers.rb#834
  def _verify_selector_result(query_args, optional_filter_block, query_type = T.unsafe(nil)); end

  # source://capybara//lib/capybara/node/matchers.rb#858
  def _verify_text(type = T.unsafe(nil), expected_text, **query_options); end

  # source://capybara//lib/capybara/node/matchers.rb#822
  def extract_selector(args); end

  # source://capybara//lib/capybara/node/matchers.rb#875
  def make_predicate(options); end
end

# A {Capybara::Node::Simple} is a simpler version of {Capybara::Node::Base} which
# includes only {Capybara::Node::Finders} and {Capybara::Node::Matchers} and does
# not include {Capybara::Node::Actions}. This type of node is returned when
# using {Capybara.string}.
#
# It is useful in that it does not require a session, an application or a driver,
# but can still use Capybara's finders and matchers on any string that contains HTML.
class Capybara::Node::Simple
  include ::Capybara::Node::Finders
  include ::Capybara::Node::Matchers
  include ::Capybara::Node::DocumentMatchers

  # @return [Simple] a new instance of Simple
  #
  # source://capybara//lib/capybara/node/simple.rb#22
  def initialize(native); end

  # source://capybara//lib/capybara/node/simple.rb#194
  def ==(other); end

  # Retrieve the given attribute
  #
  #     element[:title] # => HTML title attribute
  #
  # @param name [Symbol] The attribute name to retrieve
  # @return [String] The value of the attribute
  #
  # source://capybara//lib/capybara/node/simple.rb#45
  def [](name); end

  # source://capybara//lib/capybara/node/simple.rb#159
  def allow_reload!(*_arg0); end

  # Whether or not the element is checked.
  #
  # @return [Boolean] Whether the element is checked
  #
  # source://capybara//lib/capybara/node/simple.rb#123
  def checked?; end

  # Whether or not the element is disabled.
  #
  # @return [Boolean] Whether the element is disabled
  #
  # source://capybara//lib/capybara/node/simple.rb#132
  def disabled?; end

  # @api private
  #
  # source://capybara//lib/capybara/node/simple.rb#175
  def find_css(css, **_options); end

  # @api private
  #
  # source://capybara//lib/capybara/node/simple.rb#180
  def find_xpath(xpath, **_options); end

  # @api private
  #
  # source://capybara//lib/capybara/node/simple.rb#190
  def initial_cache; end

  # source://capybara//lib/capybara/node/simple.rb#170
  def inspect; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/simple.rb#147
  def multiple?; end

  # Returns the value of attribute native.
  #
  # source://capybara//lib/capybara/node/simple.rb#20
  def native; end

  # An XPath expression describing where on the page the element can be found
  #
  # @return [String] An XPath expression
  #
  # source://capybara//lib/capybara/node/simple.rb#70
  def path; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/node/simple.rb#151
  def readonly?; end

  # Whether or not the element is selected.
  #
  # @return [Boolean] Whether the element is selected
  #
  # source://capybara//lib/capybara/node/simple.rb#143
  def selected?; end

  # @api private
  #
  # source://capybara//lib/capybara/node/simple.rb#185
  def session_options; end

  # source://capybara//lib/capybara/node/simple.rb#155
  def synchronize(_seconds = T.unsafe(nil)); end

  # @return [String] The tag name of the element
  #
  # source://capybara//lib/capybara/node/simple.rb#60
  def tag_name; end

  # @return [String] The text of the element
  #
  # source://capybara//lib/capybara/node/simple.rb#31
  def text(_type = T.unsafe(nil), normalize_ws: T.unsafe(nil)); end

  # @return [String] The title of the document
  #
  # source://capybara//lib/capybara/node/simple.rb#166
  def title; end

  # @return [String] The value of the form element
  #
  # source://capybara//lib/capybara/node/simple.rb#78
  def value; end

  # Whether or not the element is visible. Does not support CSS, so
  # the result may be inaccurate.
  #
  # @param check_ancestors [Boolean] Whether to inherit visibility from ancestors
  # @return [Boolean] Whether the element is visible
  #
  # source://capybara//lib/capybara/node/simple.rb#103
  def visible?(check_ancestors = T.unsafe(nil)); end

  private

  # source://capybara//lib/capybara/node/simple.rb#200
  def option_value(option); end
end

# source://capybara//lib/capybara/node/simple.rb#206
Capybara::Node::Simple::VISIBILITY_XPATH = T.let(T.unsafe(nil), String)

class Capybara::NotSupportedByDriverError < ::Capybara::CapybaraError; end

# @api private
module Capybara::Queries; end

# @api private
class Capybara::Queries::ActiveElementQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @return [ActiveElementQuery] a new instance of ActiveElementQuery
  #
  # source://capybara//lib/capybara/queries/active_element_query.rb#7
  def initialize(**options); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/active_element_query.rb#12
  def resolve_for(session); end
end

# @api private
class Capybara::Queries::AncestorQuery < ::Capybara::Queries::SelectorQuery
  # @api private
  #
  # source://capybara//lib/capybara/queries/ancestor_query.rb#20
  def description(applied = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/ancestor_query.rb#7
  def resolve_for(node, exact = T.unsafe(nil)); end
end

# @api private
class Capybara::Queries::BaseQuery
  # @api private
  # @return [BaseQuery] a new instance of BaseQuery
  #
  # source://capybara//lib/capybara/queries/base_query.rb#12
  def initialize(options); end

  # Checks if a count of 0 is valid for the query
  # Returns false if query does not have any count options specified.
  #
  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/base_query.rb#36
  def expects_none?; end

  # Generates a failure message from the query description and count options.
  #
  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#62
  def failure_message; end

  # Checks if the given count matches the query count options.
  # Defaults to true if no count options are specified. If multiple
  # count options exist, it tests that all conditions are met;
  # however, if :count is specified, all other options are ignored.
  #
  # @api private
  # @param count [Integer] The actual number. Should be coercible via Integer()
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/base_query.rb#49
  def matches_count?(count); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#66
  def negative_failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#9
  def options; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#16
  def session_options; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#10
  def session_options=(_arg0); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#20
  def wait; end

  private

  # @api private
  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/queries/base_query.rb#96
  def assert_valid_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#76
  def count_message; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/base_query.rb#72
  def count_specified?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/base_query.rb#92
  def occurrences(count); end

  class << self
    # @api private
    #
    # source://capybara//lib/capybara/queries/base_query.rb#24
    def wait(options, default = T.unsafe(nil)); end
  end
end

# @api private
#
# source://capybara//lib/capybara/queries/base_query.rb#7
Capybara::Queries::BaseQuery::COUNT_KEYS = T.let(T.unsafe(nil), Array)

# @api private
class Capybara::Queries::CurrentPathQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @return [CurrentPathQuery] a new instance of CurrentPathQuery
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#9
  def initialize(expected_path, **options, &optional_filter_block); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#35
  def failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#39
  def negative_failure_message; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#20
  def resolves_for?(session); end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#51
  def failure_message_helper(negated = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#45
  def matches_filter_block?(url); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/current_path_query.rb#56
  def valid_keys; end
end

# @api private
class Capybara::Queries::MatchQuery < ::Capybara::Queries::SelectorQuery
  # @api private
  #
  # source://capybara//lib/capybara/queries/match_query.rb#6
  def visible; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/match_query.rb#12
  def assert_valid_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/match_query.rb#21
  def valid_keys; end
end

# @api private
class Capybara::Queries::SelectorQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @raise [ArgumentError]
  # @return [SelectorQuery] a new instance of SelectorQuery
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#15
  def initialize(*args, session_options:, enable_aria_label: T.unsafe(nil), enable_aria_role: T.unsafe(nil), test_id: T.unsafe(nil), selector_format: T.unsafe(nil), order: T.unsafe(nil), **options, &filter_block); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#113
  def applied_description; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#154
  def css; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#64
  def description(only_applied = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#137
  def exact?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#8
  def expression; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#178
  def failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#62
  def label; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#8
  def locator; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#141
  def match; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#117
  def matches_filters?(node, node_filter_errors = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#61
  def name; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#182
  def negative_failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#8
  def options; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#159
  def resolve_for(node, exact = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#8
  def selector; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#172
  def supports_exact?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#129
  def visible; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#145
  def xpath(exact = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#230
  def applied_filters; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#390
  def apply_expression_filters(expression); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#433
  def apply_filter?(filter); end

  # @api private
  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#344
  def assert_valid_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#613
  def builder(expr); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#340
  def custom_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#609
  def default_visibility; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#421
  def describe_within?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#425
  def document?(node); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#417
  def exact_text; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#325
  def expression_filters; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#313
  def filter_set(name); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#362
  def filtered_expression(expr); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#241
  def find_nodes_by_selector_format(node, exact); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#234
  def find_selector(locator); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#220
  def first_try?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#497
  def matches_class_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#556
  def matches_exact_text_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#303
  def matches_filter_block?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#510
  def matches_focused_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#491
  def matches_id_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#437
  def matches_locator_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#278
  def matches_node_filters?(node, errors); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#455
  def matches_spatial_filters?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#536
  def matches_style?(node, styles); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#525
  def matches_style_filter?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#443
  def matches_system_filters?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#590
  def matches_text_exactly?(node, value); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#547
  def matches_text_filter?(node); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#599
  def matches_text_regexp(node, regexp); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#605
  def matches_text_regexp?(node, regexp); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#565
  def matches_visibility_filters?(node); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#192
  def matching_text; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#516
  def need_to_process_classes?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#317
  def node_filters; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#595
  def normalize_ws; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#331
  def ordered_results(results); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#617
  def position_cache(key); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#621
  def rect_cache(key); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#188
  def selector_format; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#224
  def show_for_stage(only_applied); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#429
  def simple_root?(node); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#196
  def text_fragments; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#266
  def to_element(node); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#213
  def try_text_match_in_expression?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#374
  def use_default_class_filter?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#382
  def use_default_focused_filter?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#370
  def use_default_id_filter?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#378
  def use_default_style_filter?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#386
  def use_spatial_filter?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#274
  def valid_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#411
  def warn_exact_usage; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#200
  def xpath_text_conditions; end
end

# @api private
class Capybara::Queries::SelectorQuery::Rectangle
  # @api private
  # @return [Rectangle] a new instance of Rectangle
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#628
  def initialize(position); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#652
  def above?(other); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#656
  def below?(other); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#626
  def bottom; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#637
  def distance(other); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#626
  def left; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#660
  def left_of?(other); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#668
  def near?(other); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#626
  def right; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#664
  def right_of?(other); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#626
  def top; end

  protected

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#674
  def line_segments; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/selector_query.rb#685
  def distance_segment_segment(l1p1, l1p2, l2p1, l2p2); end
end

# @api private
#
# source://capybara//lib/capybara/queries/selector_query.rb#10
Capybara::Queries::SelectorQuery::SPATIAL_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://capybara//lib/capybara/queries/selector_query.rb#11
Capybara::Queries::SelectorQuery::VALID_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://capybara//lib/capybara/queries/selector_query.rb#13
Capybara::Queries::SelectorQuery::VALID_MATCH = T.let(T.unsafe(nil), Array)

# @api private
class Capybara::Queries::SiblingQuery < ::Capybara::Queries::SelectorQuery
  # @api private
  #
  # source://capybara//lib/capybara/queries/sibling_query.rb#19
  def description(applied = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/sibling_query.rb#7
  def resolve_for(node, exact = T.unsafe(nil)); end
end

# @api private
class Capybara::Queries::StyleQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @return [StyleQuery] a new instance of StyleQuery
  #
  # source://capybara//lib/capybara/queries/style_query.rb#7
  def initialize(expected_styles, session_options:, **options); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/style_query.rb#29
  def failure_message; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/style_query.rb#17
  def resolves_for?(node); end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/style_query.rb#36
  def stringify_keys(hsh); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/style_query.rb#40
  def valid_keys; end
end

# @api private
class Capybara::Queries::TextQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @raise [ArgumentError]
  # @return [TextQuery] a new instance of TextQuery
  #
  # source://capybara//lib/capybara/queries/text_query.rb#7
  def initialize(type = T.unsafe(nil), expected_text, session_options:, **options); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#41
  def description; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#33
  def failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#37
  def negative_failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#27
  def resolve_for(node); end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#55
  def build_message(report_on_invisible); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#71
  def case_insensitive_message; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/text_query.rb#102
  def check_case_insensitive?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/text_query.rb#98
  def check_visible_text?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#111
  def default_type; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/text_query.rb#51
  def exact?; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#79
  def invisible_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#106
  def text(node: T.unsafe(nil), query_type: T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#90
  def valid_keys; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/text_query.rb#94
  def valid_types; end
end

# @api private
class Capybara::Queries::TitleQuery < ::Capybara::Queries::BaseQuery
  # @api private
  # @return [TitleQuery] a new instance of TitleQuery
  #
  # source://capybara//lib/capybara/queries/title_query.rb#7
  def initialize(expected_title, **options); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/title_query.rb#19
  def failure_message; end

  # @api private
  #
  # source://capybara//lib/capybara/queries/title_query.rb#23
  def negative_failure_message; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/queries/title_query.rb#15
  def resolves_for?(node); end

  private

  # @api private
  #
  # source://capybara//lib/capybara/queries/title_query.rb#29
  def failure_message_helper(negated = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/queries/title_query.rb#34
  def valid_keys; end
end

module Capybara::RackTest; end

class Capybara::RackTest::Browser
  include ::Rack::Test::Methods

  # @return [Browser] a new instance of Browser
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#9
  def initialize(driver); end

  # source://capybara//lib/capybara/rack_test/browser.rb#14
  def app; end

  # source://capybara//lib/capybara/rack_test/browser.rb#83
  def build_uri(path); end

  # Returns the value of attribute current_host.
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#7
  def current_host; end

  # Sets the attribute current_host
  #
  # @param value the value to set the attribute current_host to.
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#7
  def current_host=(_arg0); end

  # source://capybara//lib/capybara/rack_test/browser.rb#99
  def current_url; end

  # source://capybara//lib/capybara/rack_test/browser.rb#116
  def dom; end

  # Returns the value of attribute driver.
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#6
  def driver; end

  # source://capybara//lib/capybara/rack_test/browser.rb#120
  def find(format, selector); end

  # source://capybara//lib/capybara/rack_test/browser.rb#47
  def follow(method, path, **attributes); end

  # source://capybara//lib/capybara/rack_test/browser.rb#128
  def html; end

  # @raise [Rack::Test::Error]
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#138
  def last_request; end

  # @raise [Rack::Test::Error]
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#144
  def last_response; end

  # source://capybara//lib/capybara/rack_test/browser.rb#18
  def options; end

  # source://capybara//lib/capybara/rack_test/browser.rb#73
  def process(method, path, attributes = T.unsafe(nil), env = T.unsafe(nil)); end

  # source://capybara//lib/capybara/rack_test/browser.rb#53
  def process_and_follow_redirects(method, path, attributes = T.unsafe(nil), env = T.unsafe(nil)); end

  # source://capybara//lib/capybara/rack_test/browser.rb#29
  def refresh; end

  # source://capybara//lib/capybara/rack_test/browser.rb#112
  def reset_cache!; end

  # source://capybara//lib/capybara/rack_test/browser.rb#107
  def reset_host!; end

  # source://capybara//lib/capybara/rack_test/browser.rb#34
  def submit(method, path, attributes, content_type: T.unsafe(nil)); end

  # source://capybara//lib/capybara/rack_test/browser.rb#134
  def title; end

  # source://capybara//lib/capybara/rack_test/browser.rb#22
  def visit(path, **attributes); end

  protected

  # source://capybara//lib/capybara/rack_test/browser.rb#152
  def base_href; end

  # source://capybara//lib/capybara/rack_test/browser.rb#156
  def base_relative_uri_for(uri); end

  # source://capybara//lib/capybara/rack_test/browser.rb#171
  def build_rack_mock_session; end

  # source://capybara//lib/capybara/rack_test/browser.rb#176
  def request_path; end

  # source://capybara//lib/capybara/rack_test/browser.rb#182
  def safe_last_request; end

  private

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/browser.rb#190
  def fragment_or_script?(path); end

  # source://capybara//lib/capybara/rack_test/browser.rb#194
  def referer_url; end
end

class Capybara::RackTest::CSSHandlers < ::BasicObject
  include ::Kernel

  # source://capybara//lib/capybara/rack_test/css_handlers.rb#6
  def disabled(list); end

  # source://capybara//lib/capybara/rack_test/css_handlers.rb#10
  def enabled(list); end
end

class Capybara::RackTest::Driver < ::Capybara::Driver::Base
  # @raise [ArgumentError]
  # @return [Driver] a new instance of Driver
  #
  # source://capybara//lib/capybara/rack_test/driver.rb#17
  def initialize(app, **options); end

  # Returns the value of attribute app.
  #
  # source://capybara//lib/capybara/rack_test/driver.rb#15
  def app; end

  # source://capybara//lib/capybara/rack_test/driver.rb#25
  def browser; end

  # source://capybara//lib/capybara/rack_test/driver.rb#61
  def current_url; end

  # source://capybara//lib/capybara/rack_test/driver.rb#104
  def delete(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/driver.rb#89
  def dom; end

  # source://capybara//lib/capybara/rack_test/driver.rb#77
  def find_css(selector); end

  # source://capybara//lib/capybara/rack_test/driver.rb#73
  def find_xpath(selector); end

  # source://capybara//lib/capybara/rack_test/driver.rb#57
  def follow(method, path, **attributes); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/driver.rb#29
  def follow_redirects?; end

  # source://capybara//lib/capybara/rack_test/driver.rb#101
  def get(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/driver.rb#105
  def header(key, value); end

  # source://capybara//lib/capybara/rack_test/driver.rb#85
  def html; end

  # source://capybara//lib/capybara/rack_test/driver.rb#107
  def invalid_element_errors; end

  # Returns the value of attribute options.
  #
  # source://capybara//lib/capybara/rack_test/driver.rb#15
  def options; end

  # source://capybara//lib/capybara/rack_test/driver.rb#102
  def post(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/driver.rb#103
  def put(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/driver.rb#33
  def redirect_limit; end

  # source://capybara//lib/capybara/rack_test/driver.rb#49
  def refresh; end

  # source://capybara//lib/capybara/rack_test/driver.rb#41
  def request; end

  # source://capybara//lib/capybara/rack_test/driver.rb#97
  def reset!; end

  # source://capybara//lib/capybara/rack_test/driver.rb#37
  def response; end

  # source://capybara//lib/capybara/rack_test/driver.rb#65
  def response_headers; end

  # source://capybara//lib/capybara/rack_test/driver.rb#69
  def status_code; end

  # source://capybara//lib/capybara/rack_test/driver.rb#53
  def submit(method, path, attributes); end

  # source://capybara//lib/capybara/rack_test/driver.rb#93
  def title; end

  # source://capybara//lib/capybara/rack_test/driver.rb#45
  def visit(path, **attributes); end
end

# source://capybara//lib/capybara/rack_test/driver.rb#10
Capybara::RackTest::Driver::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

module Capybara::RackTest::Errors; end
class Capybara::RackTest::Errors::StaleElementReferenceError < ::StandardError; end

class Capybara::RackTest::Form < ::Capybara::RackTest::Node
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/form.rb#60
  def multipart?; end

  # source://capybara//lib/capybara/rack_test/form.rb#23
  def params(button); end

  # source://capybara//lib/capybara/rack_test/form.rb#54
  def submit(button); end

  private

  # source://capybara//lib/capybara/rack_test/form.rb#93
  def add_input_param(field, params); end

  # source://capybara//lib/capybara/rack_test/form.rb#126
  def add_select_param(field, params); end

  # source://capybara//lib/capybara/rack_test/form.rb#141
  def add_textarea_param(field, params); end

  # source://capybara//lib/capybara/rack_test/form.rb#117
  def file_to_upload(filename); end

  # source://capybara//lib/capybara/rack_test/form.rb#85
  def make_params; end

  # source://capybara//lib/capybara/rack_test/form.rb#76
  def merge_param!(params, key, value); end

  # source://capybara//lib/capybara/rack_test/form.rb#72
  def request_method; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/form.rb#146
  def submitter?(el); end
end

# This only needs to inherit from Rack::Test::UploadedFile because Rack::Test checks for
# the class specifically when determining whether to construct the request as multipart.
# That check should be based solely on the form element's 'enctype' attribute value,
# which should probably be provided to Rack::Test in its non-GET request methods.
class Capybara::RackTest::Form::NilUploadedFile < ::Rack::Test::UploadedFile
  # @return [NilUploadedFile] a new instance of NilUploadedFile
  #
  # source://capybara//lib/capybara/rack_test/form.rb#9
  def initialize; end

  # source://capybara//lib/capybara/rack_test/form.rb#19
  def append_to(_); end

  # source://capybara//lib/capybara/rack_test/form.rb#15
  def content_type; end

  # source://capybara//lib/capybara/rack_test/form.rb#14
  def original_filename; end

  # source://capybara//lib/capybara/rack_test/form.rb#16
  def path; end

  # source://capybara//lib/capybara/rack_test/form.rb#18
  def read; end

  # source://capybara//lib/capybara/rack_test/form.rb#20
  def set_encoding(_); end

  # source://capybara//lib/capybara/rack_test/form.rb#17
  def size; end
end

class Capybara::RackTest::Form::ParamsHash < ::Hash
  # source://capybara//lib/capybara/rack_test/form.rb#67
  def to_params_hash; end
end

class Capybara::RackTest::Node < ::Capybara::Driver::Node
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def [](*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def all_text(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def checked?(*_arg0, **_arg1, &_arg2); end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def click(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def disabled?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def find_css(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def find_xpath(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def path(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def readonly?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def select_option(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def selected?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def set(*_arg0, **_arg1, &_arg2); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def style(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def tag_name(*_arg0, **_arg1, &_arg2); end

  # @raise [Capybara::UnselectNotAllowed]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def unselect_option(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def value(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#136
  def visible?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/rack_test/node.rb#136
  def visible_text(*_arg0, **_arg1, &_arg2); end

  protected

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#291
  def checkbox?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#287
  def checkbox_or_radio?(field = T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/rack_test/node.rb#152
  def displayed_text(check_ancestor: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#303
  def input_field?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#295
  def radio?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#311
  def range?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#299
  def text_or_password?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#307
  def textarea?; end

  private

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#242
  def attribute_is_not_blank?(attribute); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#281
  def checkable?; end

  # source://capybara//lib/capybara/rack_test/node.rb#252
  def click_label; end

  # source://capybara//lib/capybara/rack_test/node.rb#176
  def deselect_options; end

  # source://capybara//lib/capybara/rack_test/node.rb#246
  def follow_link; end

  # source://capybara//lib/capybara/rack_test/node.rb#193
  def form; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#273
  def link?; end

  # a reference to the select node if this is an option node
  #
  # source://capybara//lib/capybara/rack_test/node.rb#185
  def select_node; end

  # source://capybara//lib/capybara/rack_test/node.rb#207
  def set_checkbox(value); end

  # source://capybara//lib/capybara/rack_test/node.rb#223
  def set_input(value); end

  # source://capybara//lib/capybara/rack_test/node.rb#201
  def set_radio(_value); end

  # source://capybara//lib/capybara/rack_test/node.rb#215
  def set_range(value); end

  # @raise [Capybara::RackTest::Errors::StaleElementReferenceError]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#172
  def stale_check; end

  # source://capybara//lib/capybara/rack_test/node.rb#180
  def string_node; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/rack_test/node.rb#277
  def submits?; end

  # source://capybara//lib/capybara/rack_test/node.rb#262
  def toggle_details(details = T.unsafe(nil)); end

  # source://capybara//lib/capybara/rack_test/node.rb#189
  def type; end

  # source://capybara//lib/capybara/rack_test/node.rb#8
  def unchecked_all_text; end

  # source://capybara//lib/capybara/rack_test/node.rb#93
  def unchecked_checked?; end

  # source://capybara//lib/capybara/rack_test/node.rb#67
  def unchecked_click(keys = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/rack_test/node.rb#101
  def unchecked_disabled?; end

  # source://capybara//lib/capybara/rack_test/node.rb#126
  def unchecked_find_css(locator, **_hints); end

  # source://capybara//lib/capybara/rack_test/node.rb#122
  def unchecked_find_xpath(locator, **_hints); end

  # source://capybara//lib/capybara/rack_test/node.rb#118
  def unchecked_path; end

  # source://capybara//lib/capybara/rack_test/node.rb#111
  def unchecked_readonly?; end

  # source://capybara//lib/capybara/rack_test/node.rb#54
  def unchecked_select_option; end

  # source://capybara//lib/capybara/rack_test/node.rb#97
  def unchecked_selected?; end

  # source://capybara//lib/capybara/rack_test/node.rb#37
  def unchecked_set(value, **options); end

  # source://capybara//lib/capybara/rack_test/node.rb#29
  def unchecked_style(_styles); end

  # source://capybara//lib/capybara/rack_test/node.rb#85
  def unchecked_tag_name; end

  # source://capybara//lib/capybara/rack_test/node.rb#61
  def unchecked_unselect_option; end

  # source://capybara//lib/capybara/rack_test/node.rb#33
  def unchecked_value; end

  # source://capybara//lib/capybara/rack_test/node.rb#89
  def unchecked_visible?; end

  # source://capybara//lib/capybara/rack_test/node.rb#17
  def unchecked_visible_text; end
end

# source://capybara//lib/capybara/rack_test/node.rb#6
Capybara::RackTest::Node::BLOCK_ELEMENTS = T.let(T.unsafe(nil), Array)

# source://capybara//lib/capybara/rack_test/node.rb#316
Capybara::RackTest::Node::DISABLED_BY_FIELDSET_XPATH = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/rack_test/node.rb#315
Capybara::RackTest::Node::OPTION_OWNER_XPATH = T.let(T.unsafe(nil), String)

class Capybara::ReadOnlyElementError < ::Capybara::CapybaraError; end

class Capybara::ReadOnlySessionConfig < ::SimpleDelegator
  # source://capybara//lib/capybara/session/config.rb#123
  def always_include_port=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def app_host=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def asset_host=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def automatic_label_click=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def automatic_reload=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_host=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_max_wait_time=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_normalize_ws=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_retry_interval=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_selector=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def default_set_options=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def disable_animation=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def enable_aria_label=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def enable_aria_role=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def exact=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def exact_text=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def ignore_hidden_elements=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def match=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def predicates_wait=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def raise_server_errors=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def run_server=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def save_path=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def server_errors=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def server_host=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def server_port=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def test_id=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def visible_text_only=(_); end

  # source://capybara//lib/capybara/session/config.rb#123
  def w3c_click_offset=(_); end
end

# @api private
class Capybara::RegistrationContainer
  # @api private
  # @return [RegistrationContainer] a new instance of RegistrationContainer
  #
  # source://capybara//lib/capybara/registration_container.rb#33
  def initialize; end

  # @api private
  #
  # source://capybara//lib/capybara/registration_container.rb#10
  def [](name); end

  # @api private
  #
  # source://capybara//lib/capybara/registration_container.rb#14
  def []=(name, value); end

  # @api private
  #
  # source://capybara//lib/capybara/registration_container.rb#19
  def method_missing(method_name, *args, **options, &block); end

  # @api private
  #
  # source://capybara//lib/capybara/registration_container.rb#6
  def names; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/registration_container.rb#37
  def register(name, block); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/registration_container.rb#27
  def respond_to_missing?(method_name, include_all); end
end

# A {Capybara::Result} represents a collection of {Capybara::Node::Element} on the page. It is possible to interact with this
# collection similar to an Array because it implements Enumerable and offers the following Array methods through delegation:
#
# * \[\]
# * each()
# * at()
# * size()
# * count()
# * length()
# * first()
# * last()
# * empty?()
# * values_at()
# * sample()
#
# @see Capybara::Node::Element
class Capybara::Result
  include ::Enumerable
  extend ::Forwardable

  # @return [Result] a new instance of Result
  #
  # source://capybara//lib/capybara/result.rb#28
  def initialize(elements, query); end

  # source://capybara//lib/capybara/result.rb#53
  def [](*args); end

  # @api private
  #
  # source://capybara//lib/capybara/result.rb#140
  def allow_reload!; end

  # source://capybara//lib/capybara/result.rb#53
  def at(*args); end

  # source://capybara//lib/capybara/result.rb#84
  def compare_count; end

  # source://capybara//lib/capybara/result.rb#41
  def each(&block); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/result.rb#80
  def empty?; end

  # source://capybara//lib/capybara/result.rb#113
  def failure_message; end

  def index(*_arg0); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def inspect(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def last(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def length(*args, **_arg1, &block); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/result.rb#109
  def matches_count?; end

  # source://capybara//lib/capybara/result.rb#129
  def negative_failure_message; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def sample(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def size(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/result.rb#133
  def unfiltered_size; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def values_at(*args, **_arg1, &block); end

  private

  # source://capybara//lib/capybara/result.rb#147
  def add_to_cache(elem); end

  # source://capybara//lib/capybara/result.rb#161
  def full_results; end

  # JRuby < 9.2.8.0 has an issue with lazy enumerators which
  # causes a concurrency issue with network requests here
  # https://github.com/jruby/jruby/issues/4212
  # while JRuby >= 9.2.8.0 leaks threads when using lazy enumerators
  # https://github.com/teamcapybara/capybara/issues/2349
  # so disable the use and JRuby users will need to pay a performance penalty
  #
  # source://capybara//lib/capybara/result.rb#181
  def lazy_select_elements(&block); end

  # source://capybara//lib/capybara/result.rb#152
  def load_up_to(num); end

  # source://capybara//lib/capybara/result.rb#166
  def rest; end
end

class Capybara::ScopeError < ::Capybara::CapybaraError; end

# All Selectors below support the listed selector specific filters in addition to the following system-wide filters
#   * :id (String, Regexp, XPath::Expression) - Matches the id attribute
#   * :class (String, Array<String | Regexp>, Regexp, XPath::Expression) - Matches the class(es) provided
#   * :style (String, Regexp, Hash<String, String>) - Match on elements style
#   * :above (Element) - Match elements above the passed element on the page
#   * :below (Element) - Match elements below the passed element on the page
#   * :left_of (Element) - Match elements left of the passed element on the page
#   * :right_of (Element) - Match elements right of the passed element on the page
#   * :near (Element) - Match elements near (within 50px) the passed element on the page
#   * :focused (Boolean) - Match elements with focus (requires driver support)
#
# ### Built-in Selectors
#
# * **:xpath** - Select elements by XPath expression
#   * Locator: An XPath expression
#
# * **:css** - Select elements by CSS selector
#   * Locator: A CSS selector
#
# * **:id** - Select element by id
#   * Locator: (String, Regexp, XPath::Expression) The id of the element to match
#
# * **:field** - Select field elements (input [not of type submit, image, or hidden], textarea, select)
#   * Locator: Matches against the id, {Capybara.configure test_id} attribute, name, placeholder, or
#     associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :placeholder (String, Regexp) - Matches the placeholder attribute
#       * :type (String) - Matches the type attribute of the field or element type for 'textarea' and 'select'
#       * :readonly (Boolean) - Match on the element being readonly
#       * :with (String, Regexp) - Matches the current value of the field
#       * :checked (Boolean) - Match checked fields?
#       * :unchecked (Boolean) - Match unchecked fields?
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :multiple (Boolean) - Match fields that accept multiple values
#       * :valid (Boolean) - Match fields that are valid/invalid according to HTML5 form validation
#       * :validation_message (String, Regexp) - Matches the elements current validationMessage
#
# * **:fieldset** - Select fieldset elements
#   * Locator: Matches id, {Capybara.configure test_id}, or contents of wrapped legend
#   * Filters:
#       * :legend (String) - Matches contents of wrapped legend
#       * :disabled (Boolean) - Match disabled fieldset?
#
# * **:link** - Find links (`<a>` elements with an href attribute)
#   * Locator: Matches the id, {Capybara.configure test_id}, or title attributes, or the string content of the link,
#     or the alt attribute of a contained img element. By default this selector requires a link to have an href attribute.
#   * Filters:
#       * :title (String) - Matches the title attribute
#       * :alt (String) - Matches the alt attribute of a contained img element
#       * :href (String, Regexp, nil, false) - Matches the normalized href of the link, if nil will find `<a>` elements with no href attribute, if false ignores href presence
#
# * **:button** - Find buttons ( input [of type submit, reset, image, button] or button elements )
#   * Locator: Matches the id, {Capybara.configure test_id} attribute, name, value, or title attributes, string content of a button, or the alt attribute of an image type button or of a descendant image of a button
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :title (String) - Matches the title attribute
#       * :value (String) - Matches the value of an input button
#       * :type (String) - Matches the type attribute
#       * :disabled (Boolean, :all) - Match disabled buttons (Default: false)
#
# * **:link_or_button** - Find links or buttons
#   * Locator: See :link and :button selectors
#   * Filters:
#       * :disabled (Boolean, :all) - Match disabled buttons? (Default: false)
#
# * **:fillable_field** - Find text fillable fields ( textarea, input [not of type submit, image, radio, checkbox, hidden, file] )
#   * Locator: Matches against the id, {Capybara.configure test_id} attribute, name, placeholder, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :placeholder (String, Regexp) - Matches the placeholder attribute
#       * :with (String, Regexp) - Matches the current value of the field
#       * :type (String) - Matches the type attribute of the field or element type for 'textarea'
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :multiple (Boolean) - Match fields that accept multiple values
#       * :valid (Boolean) - Match fields that are valid/invalid according to HTML5 form validation
#       * :validation_message (String, Regexp) - Matches the elements current validationMessage
#
# * **:radio_button** - Find radio buttons
#   * Locator: Match id, {Capybara.configure test_id} attribute, name, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :checked (Boolean) - Match checked fields?
#       * :unchecked (Boolean) - Match unchecked fields?
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :option (String, Regexp) - Match the current value
#       * :with - Alias of :option
#
# * **:checkbox** - Find checkboxes
#   * Locator: Match id, {Capybara.configure test_id} attribute, name, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :checked (Boolean) - Match checked fields?
#       * :unchecked (Boolean) - Match unchecked fields?
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :with (String, Regexp) - Match the current value
#       * :option - Alias of :with
#
# * **:select** - Find select elements
#   * Locator: Match id, {Capybara.configure test_id} attribute, name, placeholder, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :placeholder (String, Placeholder) - Matches the placeholder attribute
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :multiple (Boolean) - Match fields that accept multiple values
#       * :options (Array<String>) - Exact match options
#       * :enabled_options (Array<String>) - Exact match enabled options
#       * :disabled_options (Array<String>) - Exact match disabled options
#       * :with_options (Array<String>) - Partial match options
#       * :selected (String, Array<String>) - Match the selection(s)
#       * :with_selected (String, Array<String>) - Partial match the selection(s)
#
# * **:option** - Find option elements
#   * Locator: Match text of option
#   * Filters:
#       * :disabled (Boolean) - Match disabled option
#       * :selected (Boolean) - Match selected option
#
# * **:datalist_input** - Find input field with datalist completion
#   * Locator: Matches against the id, {Capybara.configure test_id} attribute, name,
#     placeholder, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :placeholder (String, Regexp) - Matches the placeholder attribute
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :options (Array<String>) - Exact match options
#       * :with_options (Array<String>) - Partial match options
#
# * **:datalist_option** - Find datalist option
#   * Locator: Match text or value of option
#   * Filters:
#       * :disabled (Boolean) - Match disabled option
#
# * **:file_field** - Find file input elements
#   * Locator: Match id, {Capybara.configure test_id} attribute, name, or associated label text
#   * Filters:
#       * :name (String, Regexp) - Matches the name attribute
#       * :disabled (Boolean, :all) - Match disabled field? (Default: false)
#       * :multiple (Boolean) - Match field that accepts multiple values
#
# * **:label** - Find label elements
#   * Locator: Match id, {Capybara.configure test_id}, or text contents
#   * Filters:
#       * :for (Element, String, Regexp) - The element or id of the element associated with the label
#
# * **:table** - Find table elements
#   * Locator: id, {Capybara.configure test_id}, or caption text of table
#   * Filters:
#       * :caption (String) - Match text of associated caption
#       * :with_rows (Array<Array<String>>, Array<Hash<String, String>>) - Partial match `<td>` data - visibility of `<td>` elements is not considered
#       * :rows (Array<Array<String>>) - Match all `<td>`s - visibility of `<td>` elements is not considered
#       * :with_cols (Array<Array<String>>, Array<Hash<String, String>>) - Partial match `<td>` data - visibility of `<td>` elements is not considered
#       * :cols (Array<Array<String>>) - Match all `<td>`s - visibility of `<td>` elements is not considered
#
# * **:table_row** - Find table row
#   * Locator: Array<String>, Hash<String, String> table row `<td>` contents - visibility of `<td>` elements is not considered
#
# * **:frame** - Find frame/iframe elements
#   * Locator: Match id, {Capybara.configure test_id} attribute, or name
#   * Filters:
#       * :name (String) - Match name attribute
#
# * **:element**
#   * Locator: Type of element ('div', 'a', etc) - if not specified defaults to '*'
#   * Filters:
#       * :\<any> (String, Regexp) - Match on any specified element attribute
class Capybara::Selector < ::SimpleDelegator
  # @return [Selector] a new instance of Selector
  #
  # source://capybara//lib/capybara/selector/selector.rb#33
  def initialize(definition, config:, format:); end

  # source://capybara//lib/capybara/selector/selector.rb#77
  def add_error(error_msg); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/selector.rb#95
  def builder(expr = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selector/selector.rb#59
  def call(locator, **options); end

  # source://capybara//lib/capybara/selector/selector.rb#42
  def current_format; end

  # source://capybara//lib/capybara/selector/selector.rb#47
  def enable_aria_label; end

  # source://capybara//lib/capybara/selector/selector.rb#51
  def enable_aria_role; end

  # Returns the value of attribute errors.
  #
  # source://capybara//lib/capybara/selector/selector.rb#31
  def errors; end

  # source://capybara//lib/capybara/selector/selector.rb#81
  def expression_for(name, locator, config: T.unsafe(nil), format: T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/selector/selector.rb#42
  def format; end

  # source://capybara//lib/capybara/selector/selector.rb#55
  def test_id; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/selector.rb#86
  def with_filter_errors(errors); end

  private

  # source://capybara//lib/capybara/selector/selector.rb#146
  def find_by_attr(attribute, value); end

  # source://capybara//lib/capybara/selector/selector.rb#155
  def find_by_class_attr(classes); end

  # source://capybara//lib/capybara/selector/selector.rb#126
  def locate_field(xpath, locator, **_options); end

  # source://capybara//lib/capybara/selector/selector.rb#142
  def locate_label(locator); end

  # source://capybara//lib/capybara/selector/selector.rb#108
  def locator_description; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/selector.rb#118
  def locator_valid?(locator); end

  class << self
    # source://capybara//lib/capybara/selector/selector.rb#10
    def [](name); end

    # source://capybara//lib/capybara/selector/selector.rb#14
    def add(name, **options, &block); end

    # source://capybara//lib/capybara/selector/selector.rb#6
    def all; end

    # source://capybara//lib/capybara/selector/selector.rb#26
    def for(locator); end

    # source://capybara//lib/capybara/selector/selector.rb#22
    def remove(name); end

    # source://capybara//lib/capybara/selector/selector.rb#18
    def update(name, &block); end
  end
end

class Capybara::Selector::CSS
  class << self
    # source://capybara//lib/capybara/selector/css.rb#8
    def escape(str); end

    # source://capybara//lib/capybara/selector/css.rb#17
    def escape_char(char); end

    # source://capybara//lib/capybara/selector/css.rb#21
    def split(css); end
  end
end

# source://capybara//lib/capybara/selector/css.rb#29
Capybara::Selector::CSS::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://capybara//lib/capybara/selector/css.rb#26
Capybara::Selector::CSS::H = T.let(T.unsafe(nil), Regexp)

# source://capybara//lib/capybara/selector/css.rb#30
Capybara::Selector::CSS::NMSTART = T.let(T.unsafe(nil), Regexp)

# source://capybara//lib/capybara/selector/css.rb#28
Capybara::Selector::CSS::NONASCII = T.let(T.unsafe(nil), Regexp)

# source://capybara//lib/capybara/selector/css.rb#25
Capybara::Selector::CSS::S = T.let(T.unsafe(nil), String)

class Capybara::Selector::CSS::Splitter
  # source://capybara//lib/capybara/selector/css.rb#33
  def split(css); end

  private

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selector/css.rb#69
  def parse_block(start, final, strio); end

  # source://capybara//lib/capybara/selector/css.rb#65
  def parse_paren(strio); end

  # source://capybara//lib/capybara/selector/css.rb#61
  def parse_square(strio); end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selector/css.rb#86
  def parse_string(quote, strio); end
end

# source://capybara//lib/capybara/selector/css.rb#27
Capybara::Selector::CSS::UNICODE = T.let(T.unsafe(nil), Regexp)

# @api private
class Capybara::Selector::CSSBuilder
  # @api private
  # @return [CSSBuilder] a new instance of CSSBuilder
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#9
  def initialize(expression); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#15
  def add_attribute_conditions(**attributes); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#13
  def expression; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#43
  def attribute_conditions(attributes); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#66
  def class_conditions(classes); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/css_builder.rb#35
  def regexp_conditions(name, value); end
end

class Capybara::Selector::Definition
  extend ::Forwardable

  # @return [Definition] a new instance of Definition
  #
  # source://capybara//lib/capybara/selector/definition.rb#16
  def initialize(name, locator_type: T.unsafe(nil), raw_locator: T.unsafe(nil), supports_exact: T.unsafe(nil), &block); end

  # Define a selector by a CSS selector
  #
  # @overload css
  # @overload css
  # @return [#call] The block that will be called to generate the CSS selector
  #
  # source://capybara//lib/capybara/selector/definition.rb#77
  def css(*allowed_filters, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#32
  def custom_filters; end

  # source://capybara//lib/capybara/selector/definition.rb#236
  def default_format; end

  # source://capybara//lib/capybara/selector/definition.rb#217
  def default_visibility(fallback = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def describe(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#190
  def describe_all_expression_filters(**opts); end

  # source://capybara//lib/capybara/selector/definition.rb#180
  def describe_expression_filters(&block); end

  # source://capybara//lib/capybara/selector/definition.rb#200
  def describe_node_filters(&block); end

  # @param options [Hash] The options of the query used to generate the description
  # @return [String] Description of the selector when used with the options passed
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def description(*args, **_arg1, &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [Symbol, Regexp] The filter name
  # @param matcher [Regexp] (nil)   A Regexp used to check whether a specific option is handled by this filter
  # @param types [Array<Symbol>] The types of the filter - currently valid types are [:boolean]
  # @param options [Hash] ({})      Options of the filter
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def expression_filter(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#41
  def expression_filters; end

  # Returns the value of attribute expressions.
  #
  # source://capybara//lib/capybara/selector/definition.rb#12
  def expressions; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def filter(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#174
  def filter_set(name, filters_to_use = T.unsafe(nil)); end

  # Set/get a descriptive label for the selector
  #
  # @overload label
  # @overload label
  # @return [String] The currently set label
  #
  # source://capybara//lib/capybara/selector/definition.rb#104
  def label(label = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selector/definition.rb#168
  def locator_filter(*types, **options, &block); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/definition.rb#247
  def locator_types; end

  # Automatic selector detection
  #
  # @return [#call] The block that will be used to detect selector match
  # @yield [locator] This block takes the passed in locator string and returns whether or not it matches the selector
  # @yieldparam , [String] locator      The locator string used to determine if it matches the selector
  # @yieldreturn [Boolean] Whether this selector matches the locator string
  #
  # source://capybara//lib/capybara/selector/definition.rb#90
  def match(&block); end

  # Should this selector be used for the passed in locator
  #
  #  This is used by the automatic selector selection mechanism when no selector type is passed to a selector query
  #
  # @param locator [String] The locator passed to the query
  # @return [Boolean] Whether or not to use this selector
  #
  # source://capybara//lib/capybara/selector/definition.rb#127
  def match?(locator); end

  # Returns the value of attribute name.
  #
  # source://capybara//lib/capybara/selector/definition.rb#12
  def name; end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [Symbol, Regexp] The filter name
  # @param types [Array<Symbol>] The types of the filter - currently valid types are [:boolean]
  # @param options [Hash] ({})      Options of the filter
  #
  # source://forwardable/1.3.2/forwardable.rb#229
  def node_filter(*args, **_arg1, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#37
  def node_filters; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/definition.rb#227
  def raw_locator?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/definition.rb#232
  def supports_exact?; end

  # Set the default visibility mode that should be used if no visible option is passed when using the selector.
  # If not specified will default to the behavior indicated by Capybara.ignore_hidden_elements
  #
  # @param default_visibility [Symbol] Only find elements with the specified visibility:
  #   * :all - finds visible and invisible elements.
  #   * :hidden - only finds invisible elements.
  #   * :visible - only finds visible elements.
  #
  # source://capybara//lib/capybara/selector/definition.rb#213
  def visible(default_visibility = T.unsafe(nil), &block); end

  # Define a selector by an xpath expression
  #
  # @overload xpath
  # @overload xpath
  # @return [#call] The block that will be called to generate the XPath expression
  #
  # source://capybara//lib/capybara/selector/definition.rb#59
  def xpath(*allowed_filters, &block); end

  private

  # source://capybara//lib/capybara/selector/definition.rb#268
  def expression(type, allowed_filters, &block); end

  # source://capybara//lib/capybara/selector/definition.rb#255
  def handled_custom_options(filter, options); end

  # source://capybara//lib/capybara/selector/definition.rb#261
  def parameter_names(block); end
end

class Capybara::Selector::FilterSet
  # @return [FilterSet] a new instance of FilterSet
  #
  # source://capybara//lib/capybara/selector/filter_set.rb#10
  def initialize(name, &block); end

  # source://capybara//lib/capybara/selector/filter_set.rb#29
  def describe(what = T.unsafe(nil), &block); end

  # source://capybara//lib/capybara/selector/filter_set.rb#42
  def description(node_filters: T.unsafe(nil), expression_filters: T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/selector/filter_set.rb#51
  def descriptions; end

  # source://capybara//lib/capybara/selector/filter_set.rb#25
  def expression_filter(name, *types, **options, &block); end

  # Returns the value of attribute expression_filters.
  #
  # source://capybara//lib/capybara/selector/filter_set.rb#8
  def expression_filters; end

  # source://capybara//lib/capybara/selector/filter_set.rb#18
  def filter(names, *types, **options, &block); end

  # source://capybara//lib/capybara/selector/filter_set.rb#56
  def import(name, filters = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selector/filter_set.rb#18
  def node_filter(names, *types, **options, &block); end

  # Returns the value of attribute node_filters.
  #
  # source://capybara//lib/capybara/selector/filter_set.rb#8
  def node_filters; end

  protected

  # source://capybara//lib/capybara/selector/filter_set.rb#97
  def expression_filter_descriptions; end

  # source://capybara//lib/capybara/selector/filter_set.rb#93
  def node_filter_descriptions; end

  # source://capybara//lib/capybara/selector/filter_set.rb#89
  def undeclared_descriptions; end

  private

  # source://capybara//lib/capybara/selector/filter_set.rb#110
  def add_filter(name, filter_class, *types, matcher: T.unsafe(nil), **options, &block); end

  # source://capybara//lib/capybara/selector/filter_set.rb#103
  def options_with_defaults(options); end

  class << self
    # source://capybara//lib/capybara/selector/filter_set.rb#74
    def [](name); end

    # source://capybara//lib/capybara/selector/filter_set.rb#78
    def add(name, &block); end

    # source://capybara//lib/capybara/selector/filter_set.rb#70
    def all; end

    # source://capybara//lib/capybara/selector/filter_set.rb#82
    def remove(name); end
  end
end

module Capybara::Selector::Filters; end

class Capybara::Selector::Filters::Base
  # @return [Base] a new instance of Base
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#7
  def initialize(name, matcher, block, **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#35
  def boolean?; end

  # source://capybara//lib/capybara/selector/filters/base.rb#19
  def default; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#15
  def default?; end

  # source://capybara//lib/capybara/selector/filters/base.rb#27
  def format; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#39
  def handles_option?(option_name); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#31
  def matcher?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#23
  def skip?(value); end

  private

  # source://capybara//lib/capybara/selector/filters/base.rb#49
  def apply(subject, name, value, skip_value, ctx); end

  # source://capybara//lib/capybara/selector/filters/base.rb#65
  def filter_context(context); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/base.rb#69
  def valid_value?(value); end
end

class Capybara::Selector::Filters::ExpressionFilter < ::Capybara::Selector::Filters::Base
  # source://capybara//lib/capybara/selector/filters/expression_filter.rb#9
  def apply_filter(expr, name, value, selector); end
end

class Capybara::Selector::Filters::IdentityExpressionFilter < ::Capybara::Selector::Filters::ExpressionFilter
  # @return [IdentityExpressionFilter] a new instance of IdentityExpressionFilter
  #
  # source://capybara//lib/capybara/selector/filters/expression_filter.rb#15
  def initialize(name); end

  # source://capybara//lib/capybara/selector/filters/expression_filter.rb#18
  def apply_filter(expr, _name, _value, _ctx); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/expression_filter.rb#16
  def default?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/expression_filter.rb#17
  def matcher?; end
end

class Capybara::Selector::Filters::LocatorFilter < ::Capybara::Selector::Filters::NodeFilter
  # @return [LocatorFilter] a new instance of LocatorFilter
  #
  # source://capybara//lib/capybara/selector/filters/locator_filter.rb#9
  def initialize(block, **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/locator_filter.rb#13
  def matches?(node, value, context = T.unsafe(nil), exact:); end

  private

  # source://capybara//lib/capybara/selector/filters/locator_filter.rb#21
  def apply(subject, value, skip_value, ctx, **options); end
end

class Capybara::Selector::Filters::NodeFilter < ::Capybara::Selector::Filters::Base
  # @return [NodeFilter] a new instance of NodeFilter
  #
  # source://capybara//lib/capybara/selector/filters/node_filter.rb#9
  def initialize(name, matcher, block, **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/filters/node_filter.rb#23
  def matches?(node, name, value, context = T.unsafe(nil)); end
end

# @api private
class Capybara::Selector::RegexpDisassembler
  # @api private
  # @return [RegexpDisassembler] a new instance of RegexpDisassembler
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#9
  def initialize(regexp); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#13
  def alternated_substrings; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#21
  def substrings; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#81
  def collapse(strs); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#68
  def combine(strs); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#87
  def extract_strings(expression, alternation: T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#61
  def process(alternation:); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#30
  def remove_and_covered(strings); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#45
  def remove_or_covered(or_series); end
end

# @api private
class Capybara::Selector::RegexpDisassembler::Expression
  # @api private
  # @return [Expression] a new instance of Expression
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#93
  def initialize(exp); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#97
  def extract_strings(process_alternatives); end

  protected

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#113
  def alternation?; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#156
  def alternative_strings; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#161
  def ignore?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#117
  def optional?; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#148
  def optional_strings; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#152
  def repeated_strings(process_alternatives); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#125
  def strings(process_alternatives); end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#121
  def terminal?; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#137
  def terminal_strings; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#200
  def alternatives; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#204
  def each; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#180
  def fixed_repeat?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#168
  def indeterminate?; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#176
  def max_repeat; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#172
  def min_repeat; end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#194
  def options_set(strs); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#188
  def repeat_set(str); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/regexp_disassembler.rb#184
  def type; end
end

# @api private
class Capybara::Selector::XPathBuilder
  # @api private
  # @return [XPathBuilder] a new instance of XPathBuilder
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#9
  def initialize(expression); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#15
  def add_attribute_conditions(**conditions); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#13
  def expression; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#30
  def attribute_conditions(attributes); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#47
  def class_conditions(classes); end

  # @api private
  #
  # source://capybara//lib/capybara/selector/builders/xpath_builder.rb#62
  def regexp_to_xpath_conditions(regexp); end
end

module Capybara::Selenium; end

module Capybara::Selenium::ChromeLogs
  # source://capybara//lib/capybara/selenium/patches/logs.rb#21
  def available_log_types; end

  # source://capybara//lib/capybara/selenium/patches/logs.rb#17
  def commands(command); end

  # source://capybara//lib/capybara/selenium/patches/logs.rb#28
  def log(type); end
end

# source://capybara//lib/capybara/selenium/patches/logs.rb#11
Capybara::Selenium::ChromeLogs::COMMANDS = T.let(T.unsafe(nil), Hash)

# source://capybara//lib/capybara/selenium/patches/logs.rb#6
Capybara::Selenium::ChromeLogs::LOG_MSG = T.let(T.unsafe(nil), String)

class Capybara::Selenium::ChromeNode < ::Capybara::Selenium::Node
  include ::Capybara::Selenium::Node::Html5Drag
  include ::Capybara::Selenium::Node::FileInputClickEmulation

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#39
  def click(*_arg0, **_arg1); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#52
  def disabled?; end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#35
  def drop(*args); end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#56
  def select_option; end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#76
  def send_keys(*args); end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#17
  def set_file(value); end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#10
  def set_text(value, clear: T.unsafe(nil), **_unused); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#64
  def visible?; end

  private

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#113
  def browser_version(to_float: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#120
  def chromedriver_fixed_actions_key_state?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#124
  def chromedriver_supports_displayed_endpoint?; end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#128
  def chromedriver_version; end

  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#107
  def file_errors; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#132
  def native_displayed?; end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selenium/nodes/chrome_node.rb#96
  def perform_legacy_drag(element, drop_modifiers); end
end

class Capybara::Selenium::Driver < ::Capybara::Driver::Base
  include ::Capybara::Selenium::Find

  # @return [Driver] a new instance of Driver
  #
  # source://capybara//lib/capybara/selenium/driver.rb#92
  def initialize(app, **options); end

  # source://capybara//lib/capybara/selenium/driver.rb#273
  def accept_modal(_type, **options); end

  # source://capybara//lib/capybara/selenium/driver.rb#151
  def active_element; end

  # Returns the value of attribute app.
  #
  # source://capybara//lib/capybara/selenium/driver.rb#17
  def app; end

  # source://capybara//lib/capybara/selenium/driver.rb#65
  def browser; end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#244
  def close_window(handle); end

  # source://capybara//lib/capybara/selenium/driver.rb#129
  def current_url; end

  # source://capybara//lib/capybara/selenium/driver.rb#214
  def current_window_handle; end

  # source://capybara//lib/capybara/selenium/driver.rb#284
  def dismiss_modal(_type, **options); end

  # source://capybara//lib/capybara/selenium/driver.rb#145
  def evaluate_async_script(script, *args); end

  # source://capybara//lib/capybara/selenium/driver.rb#140
  def evaluate_script(script, *args); end

  # source://capybara//lib/capybara/selenium/driver.rb#136
  def execute_script(script, *args); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#187
  def frame_obscured_at?(x:, y:); end

  # source://capybara//lib/capybara/selenium/driver.rb#238
  def fullscreen_window(handle); end

  # source://capybara//lib/capybara/selenium/driver.rb#111
  def go_back; end

  # source://capybara//lib/capybara/selenium/driver.rb#115
  def go_forward; end

  # source://capybara//lib/capybara/selenium/driver.rb#119
  def html; end

  # source://capybara//lib/capybara/selenium/driver.rb#306
  def invalid_element_errors; end

  # source://capybara//lib/capybara/selenium/driver.rb#231
  def maximize_window(handle); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#134
  def needs_server?; end

  # source://capybara//lib/capybara/selenium/driver.rb#332
  def no_such_window_error; end

  # source://capybara//lib/capybara/selenium/driver.rb#256
  def open_new_window(kind = T.unsafe(nil)); end

  # Returns the value of attribute options.
  #
  # source://capybara//lib/capybara/selenium/driver.rb#17
  def options; end

  # source://capybara//lib/capybara/selenium/driver.rb#292
  def quit; end

  # source://capybara//lib/capybara/selenium/driver.rb#107
  def refresh; end

  # source://capybara//lib/capybara/selenium/driver.rb#164
  def reset!; end

  # source://capybara//lib/capybara/selenium/driver.rb#225
  def resize_window_to(handle, width, height); end

  # source://capybara//lib/capybara/selenium/driver.rb#160
  def save_screenshot(path, **_options); end

  # source://capybara//lib/capybara/selenium/driver.rb#155
  def send_keys(*args); end

  # source://capybara//lib/capybara/selenium/driver.rb#199
  def switch_to_frame(frame); end

  # source://capybara//lib/capybara/selenium/driver.rb#269
  def switch_to_window(handle); end

  # source://capybara//lib/capybara/selenium/driver.rb#125
  def title; end

  # source://capybara//lib/capybara/selenium/driver.rb#103
  def visit(path); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#133
  def wait?; end

  # source://capybara//lib/capybara/selenium/driver.rb#252
  def window_handles; end

  # source://capybara//lib/capybara/selenium/driver.rb#218
  def window_size(handle); end

  private

  # source://capybara//lib/capybara/selenium/driver.rb#542
  def accept_unhandled_reset_alert; end

  # source://capybara//lib/capybara/selenium/driver.rb#503
  def bridge; end

  # source://capybara//lib/capybara/selenium/driver.rb#499
  def build_node(native_node, initial_cache = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/driver.rb#350
  def clear_browser_state; end

  # source://capybara//lib/capybara/selenium/driver.rb#359
  def clear_browser_state_errors; end

  # source://capybara//lib/capybara/selenium/driver.rb#395
  def clear_local_storage; end

  # source://capybara//lib/capybara/selenium/driver.rb#381
  def clear_session_storage; end

  # source://capybara//lib/capybara/selenium/driver.rb#374
  def clear_storage; end

  # source://capybara//lib/capybara/selenium/driver.rb#370
  def delete_all_cookies; end

  # source://capybara//lib/capybara/selenium/driver.rb#495
  def find_context; end

  # source://capybara//lib/capybara/selenium/driver.rb#433
  def find_modal(text: T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/selenium/driver.rb#456
  def find_modal_errors; end

  # source://capybara//lib/capybara/selenium/driver.rb#417
  def modal_error; end

  # source://capybara//lib/capybara/selenium/driver.rb#346
  def native_active_element; end

  # source://capybara//lib/capybara/selenium/driver.rb#342
  def native_args(args); end

  # source://capybara//lib/capybara/selenium/driver.rb#409
  def navigate_with_accept(url); end

  # source://capybara//lib/capybara/selenium/driver.rb#524
  def reset_browser_state; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#338
  def selenium_4?; end

  # source://capybara//lib/capybara/selenium/driver.rb#514
  def setup_exit_handler; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver.rb#470
  def silenced_unknown_error_message?(msg); end

  # source://capybara//lib/capybara/selenium/driver.rb#474
  def silenced_unknown_error_messages; end

  # source://capybara//lib/capybara/selenium/driver.rb#507
  def specialize_driver; end

  # source://capybara//lib/capybara/selenium/driver.rb#363
  def unhandled_alert_errors; end

  # source://capybara//lib/capybara/selenium/driver.rb#478
  def unwrap_script_result(arg); end

  # source://capybara//lib/capybara/selenium/driver.rb#529
  def wait_for_empty_page(timer); end

  # source://capybara//lib/capybara/selenium/driver.rb#460
  def with_legacy_error(errors, legacy_error); end

  # source://capybara//lib/capybara/selenium/driver.rb#421
  def within_given_window(handle); end

  class << self
    # source://capybara//lib/capybara/selenium/driver.rb#22
    def load_selenium; end

    # source://capybara//lib/capybara/selenium/driver.rb#59
    def register_specialization(browser_name, specialization); end

    # Returns the value of attribute selenium_webdriver_version.
    #
    # source://capybara//lib/capybara/selenium/driver.rb#20
    def selenium_webdriver_version; end

    # Returns the value of attribute specializations.
    #
    # source://capybara//lib/capybara/selenium/driver.rb#57
    def specializations; end
  end
end

# source://capybara//lib/capybara/selenium/driver.rb#15
Capybara::Selenium::Driver::CAPS_VERSION = T.let(T.unsafe(nil), Gem::Requirement)

module Capybara::Selenium::Driver::ChromeDriver
  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#14
  def fullscreen_window(handle); end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#36
  def reset!; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#25
  def resize_window_to(handle, width, height); end

  private

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#105
  def build_node(native_node, initial_cache = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#91
  def cdp_unsupported_errors; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#109
  def chromedriver_version; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#65
  def clear_all_storage?; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#77
  def clear_storage; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#84
  def delete_all_cookies; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#95
  def execute_cdp(cmd, params = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#73
  def storage_clears; end

  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#59
  def storage_types_to_clear; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#69
  def uniform_storage_clear?; end

  class << self
    # @private
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/chrome_driver.rb#7
    def extended(base); end
  end
end

# source://capybara//lib/capybara/selenium/driver.rb#9
Capybara::Selenium::Driver::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

module Capybara::Selenium::Driver::EdgeDriver
  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#57
  def download_path=(path); end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#12
  def fullscreen_window(handle); end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#36
  def reset!; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#25
  def resize_window_to(handle, width, height); end

  private

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#111
  def build_node(native_node, initial_cache = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#101
  def cdp_unsupported_errors; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#74
  def clear_all_storage?; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#86
  def clear_storage; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#92
  def delete_all_cookies; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#115
  def edgedriver_version; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#105
  def execute_cdp(cmd, params = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#82
  def storage_clears; end

  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#68
  def storage_types_to_clear; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#78
  def uniform_storage_clear?; end

  class << self
    # @private
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/edge_driver.rb#6
    def extended(base); end
  end
end

module Capybara::Selenium::Driver::FirefoxDriver
  class << self
    # @private
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#6
    def extended(driver); end

    # @return [Boolean]
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#12
    def w3c?(driver); end
  end
end

module Capybara::Selenium::Driver::InternetExplorerDriver
  # source://capybara//lib/capybara/selenium/driver_specializations/internet_explorer_driver.rb#6
  def switch_to_frame(frame); end

  private

  # source://capybara//lib/capybara/selenium/driver_specializations/internet_explorer_driver.rb#18
  def build_node(native_node, initial_cache = T.unsafe(nil)); end
end

# source://capybara//lib/capybara/selenium/driver.rb#14
Capybara::Selenium::Driver::SPECIAL_OPTIONS = T.let(T.unsafe(nil), Array)

module Capybara::Selenium::Driver::SafariDriver
  # source://capybara//lib/capybara/selenium/driver_specializations/safari_driver.rb#6
  def switch_to_frame(frame); end

  private

  # source://capybara//lib/capybara/selenium/driver_specializations/safari_driver.rb#18
  def build_node(native_node, initial_cache = T.unsafe(nil)); end
end

module Capybara::Selenium::Driver::W3CFirefoxDriver
  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#59
  def refresh; end

  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#41
  def reset!; end

  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#30
  def resize_window_to(handle, width, height); end

  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#68
  def switch_to_frame(frame); end

  private

  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#84
  def browser_version; end

  # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#80
  def build_node(native_node, initial_cache = T.unsafe(nil)); end

  class << self
    # @private
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#20
    def extended(driver); end

    # @return [Boolean]
    #
    # source://capybara//lib/capybara/selenium/driver_specializations/firefox_driver.rb#25
    def pause_broken?(sel_driver); end
  end
end

class Capybara::Selenium::EdgeNode < ::Capybara::Selenium::Node
  include ::Capybara::Selenium::Node::Html5Drag

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#41
  def click(*_arg0); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#52
  def disabled?; end

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#35
  def drop(*args); end

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#58
  def select_option; end

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#17
  def set_file(value); end

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#8
  def set_text(value, clear: T.unsafe(nil), **_unused); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#68
  def visible?; end

  private

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#88
  def browser_version; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#95
  def chrome_edge?; end

  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#82
  def file_errors; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/edge_node.rb#99
  def native_displayed?; end
end

module Capybara::Selenium::Find
  # source://capybara//lib/capybara/selenium/extensions/find.rb#10
  def find_css(selector, uses_visibility: T.unsafe(nil), texts: T.unsafe(nil), styles: T.unsafe(nil), position: T.unsafe(nil), **_options); end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#6
  def find_xpath(selector, uses_visibility: T.unsafe(nil), styles: T.unsafe(nil), position: T.unsafe(nil), **_options); end

  private

  # source://capybara//lib/capybara/selenium/extensions/find.rb#54
  def build_hints_js(uses_visibility, styles, position); end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#96
  def es_context; end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#44
  def filter_by_text(elements, texts); end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#16
  def find_by(format, selector, uses_visibility:, texts:, styles:, position:); end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#27
  def gather_hints(elements, uses_visibility:, styles:, position:); end

  # source://capybara//lib/capybara/selenium/extensions/find.rb#100
  def is_displayed_atom; end
end

class Capybara::Selenium::FirefoxNode < ::Capybara::Selenium::Node
  include ::Capybara::Selenium::Node::Html5Drag
  include ::Capybara::Selenium::Node::FileInputClickEmulation

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#10
  def click(keys = T.unsafe(nil), **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#22
  def disabled?; end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#56
  def drop(*args); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#43
  def focused?; end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#60
  def hover; end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#67
  def select_option; end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#47
  def send_keys(*args); end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#26
  def set_file(value); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#75
  def visible?; end

  private

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#100
  def _send_keys(keys, actions = T.unsafe(nil), down_keys = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#133
  def browser_version; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#89
  def native_displayed?; end

  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#93
  def perform_with_options(click_options); end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selenium/nodes/firefox_node.rb#125
  def upload(local_file); end
end

class Capybara::Selenium::IENode < ::Capybara::Selenium::Node
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/ie_node.rb#6
  def disabled?; end
end

class Capybara::Selenium::Node < ::Capybara::Driver::Node
  include ::Capybara::Selenium::Find
  include ::Capybara::Selenium::Scroll

  # source://capybara//lib/capybara/selenium/node.rb#27
  def [](name); end

  # source://capybara//lib/capybara/selenium/node.rb#18
  def all_text; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#194
  def checked?; end

  # source://capybara//lib/capybara/selenium/node.rb#108
  def click(keys = T.unsafe(nil), **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#204
  def content_editable?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#197
  def disabled?; end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selenium/node.rb#148
  def double_click(keys = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/selenium/node.rb#165
  def drag_to(element, drop_modifiers: T.unsafe(nil), **_arg2); end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/selenium/node.rb#178
  def drop(*_); end

  # source://capybara//lib/capybara/selenium/node.rb#161
  def hover; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#193
  def multiple?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#212
  def obscured?(x: T.unsafe(nil), y: T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/node.rb#208
  def path; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#192
  def readonly?; end

  # source://capybara//lib/capybara/selenium/node.rb#219
  def rect; end

  # source://capybara//lib/capybara/selenium/node.rb#131
  def right_click(keys = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/selenium/node.rb#98
  def select_option; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#194
  def selected?; end

  # source://capybara//lib/capybara/selenium/node.rb#157
  def send_keys(*args); end

  # Set the value of the form element to the given value.
  #
  # @option options
  # @option options
  # @param value [String] The new value
  # @param options [Hash{}] Driver specific options for how to set the value
  #
  # source://capybara//lib/capybara/selenium/node.rb#61
  def set(value, **options); end

  # source://capybara//lib/capybara/selenium/node.rb#223
  def shadow_root; end

  # source://capybara//lib/capybara/selenium/node.rb#41
  def style(styles); end

  # source://capybara//lib/capybara/selenium/node.rb#182
  def tag_name; end

  # @raise [Capybara::UnselectNotAllowed]
  #
  # source://capybara//lib/capybara/selenium/node.rb#102
  def unselect_option; end

  # source://capybara//lib/capybara/selenium/node.rb#33
  def value; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#191
  def visible?; end

  # @raise [NotImplementedError]
  #
  # source://capybara//lib/capybara/selenium/node.rb#12
  def visible_text; end

  protected

  # source://capybara//lib/capybara/selenium/node.rb#232
  def scroll_if_needed; end

  # source://capybara//lib/capybara/selenium/node.rb#239
  def scroll_to_center; end

  private

  # source://capybara//lib/capybara/selenium/node.rb#485
  def action_pause(action, duration); end

  # source://capybara//lib/capybara/selenium/node.rb#417
  def action_with_modifiers(click_options); end

  # source://capybara//lib/capybara/selenium/node.rb#520
  def attrs(*attr_names); end

  # source://capybara//lib/capybara/selenium/node.rb#301
  def auto_rapid_set_length; end

  # source://capybara//lib/capybara/selenium/node.rb#270
  def boolean_attr(val); end

  # source://capybara//lib/capybara/selenium/node.rb#468
  def bridge; end

  # source://capybara//lib/capybara/selenium/node.rb#464
  def browser; end

  # source://capybara//lib/capybara/selenium/node.rb#472
  def browser_action; end

  # source://capybara//lib/capybara/selenium/node.rb#516
  def build_node(native_node, initial_cache = T.unsafe(nil)); end

  # source://capybara//lib/capybara/selenium/node.rb#476
  def capabilities; end

  # source://capybara//lib/capybara/selenium/node.rb#508
  def each_key(keys, &block); end

  # source://capybara//lib/capybara/selenium/node.rb#512
  def find_context; end

  # source://capybara//lib/capybara/selenium/node.rb#454
  def modifiers_down(actions, keys); end

  # source://capybara//lib/capybara/selenium/node.rb#459
  def modifiers_up(actions, keys); end

  # source://capybara//lib/capybara/selenium/node.rb#532
  def native_id; end

  # source://capybara//lib/capybara/selenium/node.rb#497
  def normalize_keys(keys); end

  # @raise [ArgumentError]
  #
  # source://capybara//lib/capybara/selenium/node.rb#305
  def perform_with_options(click_options, &block); end

  # a reference to the select node if this is an option node
  #
  # source://capybara//lib/capybara/selenium/node.rb#275
  def select_node; end

  # source://capybara//lib/capybara/selenium/node.rb#343
  def set_color(value); end

  # source://capybara//lib/capybara/selenium/node.rb#393
  def set_content_editable(value); end

  # source://capybara//lib/capybara/selenium/node.rb#319
  def set_date(value); end

  # source://capybara//lib/capybara/selenium/node.rb#335
  def set_datetime_local(value); end

  # source://capybara//lib/capybara/selenium/node.rb#365
  def set_file(value); end

  # source://capybara//lib/capybara/selenium/node.rb#347
  def set_range(value); end

  # source://capybara//lib/capybara/selenium/node.rb#279
  def set_text(value, clear: T.unsafe(nil), rapid: T.unsafe(nil), **_unused); end

  # source://capybara//lib/capybara/selenium/node.rb#327
  def set_time(value); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#538
  def shadow_root?; end

  # source://capybara//lib/capybara/selenium/node.rb#256
  def sibling_index(parent, node, selector); end

  # source://capybara//lib/capybara/selenium/node.rb#351
  def update_value_js(value); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#480
  def w3c?; end

  # source://capybara//lib/capybara/selenium/node.rb#375
  def with_file_detector; end
end

# ClickOptions encapsulates click option logic
class Capybara::Selenium::Node::ClickOptions
  # @return [ClickOptions] a new instance of ClickOptions
  #
  # source://capybara//lib/capybara/selenium/node.rb#639
  def initialize(keys, options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#652
  def center_offset?; end

  # source://capybara//lib/capybara/selenium/node.rb#648
  def coords; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#644
  def coords?; end

  # source://capybara//lib/capybara/selenium/node.rb#660
  def delay; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#656
  def empty?; end

  # Returns the value of attribute keys.
  #
  # source://capybara//lib/capybara/selenium/node.rb#637
  def keys; end

  # Returns the value of attribute options.
  #
  # source://capybara//lib/capybara/selenium/node.rb#637
  def options; end
end

module Capybara::Selenium::Node::FileInputClickEmulation
  # source://capybara//lib/capybara/selenium/extensions/file_input_click_emulation.rb#5
  def click(keys = T.unsafe(nil), **options); end

  private

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/extensions/file_input_click_emulation.rb#19
  def attaching_file?; end

  # source://capybara//lib/capybara/selenium/extensions/file_input_click_emulation.rb#23
  def emulate_click; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/extensions/file_input_click_emulation.rb#15
  def visible_file_field?; end
end

# source://capybara//lib/capybara/selenium/node.rb#542
Capybara::Selenium::Node::GET_XPATH_SCRIPT = T.let(T.unsafe(nil), String)

module Capybara::Selenium::Node::Html5Drag
  # Implement methods to emulate HTML5 drag and drop
  #
  # source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#7
  def drag_to(element, html5: T.unsafe(nil), delay: T.unsafe(nil), drop_modifiers: T.unsafe(nil)); end

  private

  # source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#36
  def html5_drop(*args); end

  # source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#31
  def perform_html5_drag(element, delay, drop_modifiers); end

  # source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#22
  def perform_legacy_drag(element, drop_modifiers); end
end

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#86
Capybara::Selenium::Node::Html5Drag::ATTACH_FILE = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#65
Capybara::Selenium::Node::Html5Drag::DROP_FILE = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#49
Capybara::Selenium::Node::Html5Drag::DROP_STRING = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#117
Capybara::Selenium::Node::Html5Drag::HTML5_DRAG_DROP_SCRIPT = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#104
Capybara::Selenium::Node::Html5Drag::LEGACY_DRAG_CHECK = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/extensions/html5_drag.rb#97
Capybara::Selenium::Node::Html5Drag::MOUSEDOWN_TRACKER = T.let(T.unsafe(nil), String)

# @api private
class Capybara::Selenium::Node::ModifierKeysStack
  # @api private
  # @return [ModifierKeysStack] a new instance of ModifierKeysStack
  #
  # source://capybara//lib/capybara/selenium/extensions/modifier_keys_stack.rb#8
  def initialize; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/extensions/modifier_keys_stack.rb#12
  def include?(key); end

  # @api private
  #
  # source://capybara//lib/capybara/selenium/extensions/modifier_keys_stack.rb#24
  def pop; end

  # @api private
  #
  # source://capybara//lib/capybara/selenium/extensions/modifier_keys_stack.rb#16
  def press(key); end

  # @api private
  #
  # source://capybara//lib/capybara/selenium/extensions/modifier_keys_stack.rb#20
  def push; end
end

# source://capybara//lib/capybara/selenium/node.rb#574
Capybara::Selenium::Node::OBSCURED_OR_OFFSET_SCRIPT = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/selenium/node.rb#591
Capybara::Selenium::Node::RAPID_APPEND_TEXT = T.let(T.unsafe(nil), String)

# SettableValue encapsulates time/date field formatting
class Capybara::Selenium::Node::SettableValue
  # @return [SettableValue] a new instance of SettableValue
  #
  # source://capybara//lib/capybara/selenium/node.rb#605
  def initialize(value); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#613
  def dateable?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/node.rb#621
  def timeable?; end

  # source://capybara//lib/capybara/selenium/node.rb#617
  def to_date_str; end

  # source://capybara//lib/capybara/selenium/node.rb#629
  def to_datetime_str; end

  # source://capybara//lib/capybara/selenium/node.rb#609
  def to_s; end

  # source://capybara//lib/capybara/selenium/node.rb#625
  def to_time_str; end

  # Returns the value of attribute value.
  #
  # source://capybara//lib/capybara/selenium/node.rb#603
  def value; end
end

class Capybara::Selenium::SafariNode < ::Capybara::Selenium::Node
  # include Html5Drag
  #
  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#9
  def click(keys = T.unsafe(nil), **options); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#53
  def disabled?; end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#86
  def hover; end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#28
  def select_option; end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#63
  def send_keys(*args); end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#57
  def set_file(value); end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#72
  def set_text(value, clear: T.unsafe(nil), **_unused); end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#37
  def unselect_option; end

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#42
  def visible_text; end

  private

  # source://capybara//lib/capybara/selenium/nodes/safari_node.rb#93
  def _send_keys(keys, actions = T.unsafe(nil), down_keys = T.unsafe(nil)); end
end

# source://capybara//lib/capybara/selenium/nodes/safari_node.rb#113
Capybara::Selenium::SafariNode::MODIFIER_KEYS = T.let(T.unsafe(nil), Array)

module Capybara::Selenium::Scroll
  # source://capybara//lib/capybara/selenium/extensions/scroll.rb#6
  def scroll_by(x, y); end

  # source://capybara//lib/capybara/selenium/extensions/scroll.rb#18
  def scroll_to(element, location, position = T.unsafe(nil)); end

  private

  # source://capybara//lib/capybara/selenium/extensions/scroll.rb#32
  def scroll_element_to_location(element, location); end

  # source://capybara//lib/capybara/selenium/extensions/scroll.rb#64
  def scroll_to_coords(x, y); end

  # source://capybara//lib/capybara/selenium/extensions/scroll.rb#54
  def scroll_to_location(location); end
end

# source://capybara//lib/capybara/selenium/extensions/scroll.rb#48
Capybara::Selenium::Scroll::SCROLL_POSITIONS = T.let(T.unsafe(nil), Hash)

# @api private
class Capybara::Server
  # @api private
  # @return [Server] a new instance of Server
  #
  # source://capybara//lib/capybara/server.rb#21
  def initialize(app, *deprecated_options, port: T.unsafe(nil), host: T.unsafe(nil), reportable_errors: T.unsafe(nil), extra_middleware: T.unsafe(nil)); end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#19
  def app; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#91
  def base_url; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#72
  def boot; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#45
  def error; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#19
  def host; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#19
  def port; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#41
  def reset_error!; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server.rb#53
  def responsive?; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server.rb#49
  def using_ssl?; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#63
  def wait_for_pending_requests; end

  private

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#109
  def find_available_port(host); end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#97
  def middleware; end

  # @api private
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server.rb#105
  def pending_requests?; end

  # @api private
  #
  # source://capybara//lib/capybara/server.rb#101
  def port_key; end

  class << self
    # @api private
    #
    # source://capybara//lib/capybara/server.rb#14
    def ports; end
  end
end

class Capybara::Server::AnimationDisabler
  # @return [AnimationDisabler] a new instance of AnimationDisabler
  #
  # source://capybara//lib/capybara/server/animation_disabler.rb#17
  def initialize(app); end

  # source://capybara//lib/capybara/server/animation_disabler.rb#25
  def call(env); end

  private

  # source://capybara//lib/capybara/server/animation_disabler.rb#51
  def directive_nonces(headers); end

  # Returns the value of attribute disable_css_markup.
  #
  # source://capybara//lib/capybara/server/animation_disabler.rb#40
  def disable_css_markup; end

  # Returns the value of attribute disable_js_markup.
  #
  # source://capybara//lib/capybara/server/animation_disabler.rb#40
  def disable_js_markup; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server/animation_disabler.rb#42
  def html_content?(headers); end

  # source://capybara//lib/capybara/server/animation_disabler.rb#46
  def insert_disable(html, nonces); end

  class << self
    # source://capybara//lib/capybara/server/animation_disabler.rb#6
    def selector_for(css_or_bool); end
  end
end

# source://capybara//lib/capybara/server/animation_disabler.rb#65
Capybara::Server::AnimationDisabler::DISABLE_CSS_MARKUP_TEMPLATE = T.let(T.unsafe(nil), String)

# source://capybara//lib/capybara/server/animation_disabler.rb#74
Capybara::Server::AnimationDisabler::DISABLE_JS_MARKUP_TEMPLATE = T.let(T.unsafe(nil), String)

class Capybara::Server::Checker
  # @return [Checker] a new instance of Checker
  #
  # source://capybara//lib/capybara/server/checker.rb#8
  def initialize(host, port); end

  # source://capybara//lib/capybara/server/checker.rb#13
  def request(&block); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server/checker.rb#21
  def ssl?; end

  private

  # source://capybara//lib/capybara/server/checker.rb#27
  def http_request(&block); end

  # source://capybara//lib/capybara/server/checker.rb#31
  def https_request(&block); end

  # source://capybara//lib/capybara/server/checker.rb#35
  def make_request(**options, &block); end

  # source://capybara//lib/capybara/server/checker.rb#39
  def ssl_options; end
end

# source://capybara//lib/capybara/server/checker.rb#6
Capybara::Server::Checker::TRY_HTTPS_ERRORS = T.let(T.unsafe(nil), Array)

class Capybara::Server::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://capybara//lib/capybara/server/middleware.rb#31
  def initialize(app, server_errors, extra_middleware = T.unsafe(nil)); end

  # source://capybara//lib/capybara/server/middleware.rb#52
  def call(env); end

  # source://capybara//lib/capybara/server/middleware.rb#48
  def clear_error; end

  # Returns the value of attribute error.
  #
  # source://capybara//lib/capybara/server/middleware.rb#29
  def error; end

  # source://capybara//lib/capybara/server/middleware.rb#40
  def pending_requests; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server/middleware.rb#44
  def pending_requests?; end
end

class Capybara::Server::Middleware::Counter
  # @return [Counter] a new instance of Counter
  #
  # source://capybara//lib/capybara/server/middleware.rb#7
  def initialize; end

  # source://capybara//lib/capybara/server/middleware.rb#16
  def decrement(uri); end

  # source://capybara//lib/capybara/server/middleware.rb#12
  def increment(uri); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/server/middleware.rb#20
  def positive?; end

  # source://capybara//lib/capybara/server/middleware.rb#24
  def value; end
end

# The {Session} class represents a single user's interaction with the system. The {Session} can use
# any of the underlying drivers. A session can be initialized manually like this:
#
#     session = Capybara::Session.new(:culerity, MyRackApp)
#
# The application given as the second argument is optional. When running Capybara against an external
# page, you might want to leave it out:
#
#     session = Capybara::Session.new(:culerity)
#     session.visit('http://www.google.com')
#
# When {Capybara.configure threadsafe} is `true` the sessions options will be initially set to the
# current values of the global options and a configuration block can be passed to the session initializer.
# For available options see {Capybara::SessionConfig::OPTIONS}:
#
#     session = Capybara::Session.new(:driver, MyRackApp) do |config|
#       config.app_host = "http://my_host.dev"
#     end
#
# The {Session} provides a number of methods for controlling the navigation of the page, such as {#visit},
# {#current_path}, and so on. It also delegates a number of methods to a {Capybara::Document}, representing
# the current HTML document. This allows interaction:
#
#     session.fill_in('q', with: 'Capybara')
#     session.click_button('Search')
#     expect(session).to have_content('Capybara')
#
# When using `capybara/dsl`, the {Session} is initialized automatically for you.
class Capybara::Session
  include ::Capybara::SessionMatchers

  # @return [Session] a new instance of Session
  #
  # source://capybara//lib/capybara/session.rb#78
  def initialize(mode, app = T.unsafe(nil)); end

  # Execute the block, accepting a alert.
  #
  # Expects a block whose actions will trigger the display modal to appear.
  #
  # @example
  #   accept_alert do
  #   click_link('link that triggers appearance of system modal')
  #   end
  # @overload accept_alert
  # @overload accept_alert
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/session.rb#658
  def accept_alert(text = T.unsafe(nil), **options, &blk); end

  # Execute the block, accepting a confirm.
  #
  # Expects a block whose actions will trigger the display modal to appear.
  #
  # @example
  #   accept_confirm do
  #   click_link('link that triggers appearance of system modal')
  #   end
  # @overload accept_confirm
  # @overload accept_confirm
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/session.rb#668
  def accept_confirm(text = T.unsafe(nil), **options, &blk); end

  # Execute the block, accepting a prompt, optionally responding to the prompt.
  #
  # Expects a block whose actions will trigger the display modal to appear.
  #
  # @example
  #   accept_prompt do
  #   click_link('link that triggers appearance of system modal')
  #   end
  # @option options
  # @overload accept_prompt
  # @overload accept_prompt
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/session.rb#689
  def accept_prompt(text = T.unsafe(nil), **options, &blk); end

  # Returns the element with focus.
  #
  # Not supported by Rack Test
  #
  # source://capybara//lib/capybara/session.rb#322
  def active_element; end

  # source://capybara//lib/capybara/session.rb#771
  def all(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute app.
  #
  # source://capybara//lib/capybara/session.rb#75
  def app; end

  # source://capybara//lib/capybara/session.rb#771
  def assert_all_of_selectors(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_any_of_selectors(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_no_selector(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_no_text(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#780
  def assert_no_title(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_none_of_selectors(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_selector(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def assert_text(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#780
  def assert_title(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def attach_file(*_arg0, **_arg1, &_arg2); end

  # @return [String] A snapshot of the DOM of the current document, as it looks right now (potentially modified by JavaScript).
  #
  # source://capybara//lib/capybara/session.rb#196
  def body; end

  # source://capybara//lib/capybara/session.rb#771
  def check(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def choose(*_arg0, **_arg1, &_arg2); end

  # Reset the session (i.e. remove cookies and navigate to blank page).
  #
  # This method does not:
  #
  # * accept modal dialogs if they are present (Selenium driver now does, others may not)
  # * clear browser cache/HTML 5 local storage/IndexedDB/Web SQL database/etc.
  # * modify state of the driver/underlying browser in any other way
  #
  # as doing so will result in performance downsides and it's not needed to do everything from the list above for most apps.
  #
  # If you want to do anything from the list above on a general basis you can:
  #
  # * write RSpec/Cucumber/etc. after hook
  # * monkeypatch this method
  # * use Ruby's `prepend` method
  #
  # source://capybara//lib/capybara/session.rb#129
  def cleanup!; end

  # source://capybara//lib/capybara/session.rb#771
  def click(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def click_button(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def click_link(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def click_link_or_button(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def click_on(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#828
  def config; end

  # Accepts a block to set the configuration options if {Capybara.configure threadsafe} is `true`. Note that some options only have an effect
  # if set at initialization time, so look at the configuration block that can be passed to the initializer too.
  #
  # @yield [config]
  #
  # source://capybara//lib/capybara/session.rb#818
  def configure; end

  # @return [String] Host of the current page
  #
  # source://capybara//lib/capybara/session.rb#221
  def current_host; end

  # @return [String] Path of the current page, without any domain information
  #
  # source://capybara//lib/capybara/session.rb#206
  def current_path; end

  # source://capybara//lib/capybara/session.rb#790
  def current_scope; end

  # @return [String] Fully qualified URL of the current page
  #
  # source://capybara//lib/capybara/session.rb#230
  def current_url; end

  # @return [Capybara::Window] current window
  #
  # source://capybara//lib/capybara/session.rb#459
  def current_window; end

  # Execute the block, dismissing a confirm.
  #
  # Expects a block whose actions will trigger the display modal to appear.
  #
  # @example
  #   dismiss_confirm do
  #   click_link('link that triggers appearance of system modal')
  #   end
  # @overload dismiss_confirm
  # @overload dismiss_confirm
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/session.rb#678
  def dismiss_confirm(text = T.unsafe(nil), **options, &blk); end

  # Execute the block, dismissing a prompt.
  #
  # Expects a block whose actions will trigger the display modal to appear.
  #
  # @example
  #   dismiss_prompt do
  #   click_link('link that triggers appearance of system modal')
  #   end
  # @overload dismiss_prompt
  # @overload dismiss_prompt
  # @raise [Capybara::ModalNotFound] if modal dialog hasn't been found
  # @return [String] the message shown in the modal
  #
  # source://capybara//lib/capybara/session.rb#699
  def dismiss_prompt(text = T.unsafe(nil), **options, &blk); end

  # source://capybara//lib/capybara/session.rb#765
  def document; end

  # source://capybara//lib/capybara/session.rb#771
  def double_click(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#99
  def driver; end

  # Evaluate the given JavaScript and obtain the result from a callback function which will be passed as the last argument to the script.
  #
  # @param script [String] A string of JavaScript to evaluate
  # @param args Optional arguments that will be passed to the script
  # @return [Object] The result of the evaluated JavaScript (may be driver specific)
  #
  # source://capybara//lib/capybara/session.rb#632
  def evaluate_async_script(script, *args); end

  # Evaluate the given JavaScript and return the result. Be careful when using this with
  # scripts that return complex objects, such as jQuery statements. {#execute_script} might
  # be a better alternative.
  #
  # @param script [String] A string of JavaScript to evaluate
  # @param args Optional arguments that will be passed to the script
  # @return [Object] The result of the evaluated JavaScript (may be driver specific)
  #
  # source://capybara//lib/capybara/session.rb#618
  def evaluate_script(script, *args); end

  # Execute the given script, not returning a result. This is useful for scripts that return
  # complex objects, such as jQuery statements. {#execute_script} should be used over
  # {#evaluate_script} whenever possible.
  #
  # @param script [String] A string of JavaScript to execute
  # @param args Optional arguments that will be passed to the script. Driver support for this is optional and types of objects supported may differ between drivers
  #
  # source://capybara//lib/capybara/session.rb#603
  def execute_script(script, *args); end

  # source://capybara//lib/capybara/session.rb#771
  def fill_in(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find_all(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find_button(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find_by_id(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find_field(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def find_link(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def first(*_arg0, **_arg1, &_arg2); end

  # Move back a single entry in the browser's history.
  #
  # source://capybara//lib/capybara/session.rb#296
  def go_back; end

  # Move forward a single entry in the browser's history.
  #
  # source://capybara//lib/capybara/session.rb#304
  def go_forward; end

  # source://capybara//lib/capybara/session.rb#771
  def has_button?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_checked_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_content?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_css?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_link?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_button?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_checked_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_content?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_css?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_link?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_select?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_selector?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_table?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_text?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#780
  def has_no_title?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_unchecked_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_no_xpath?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_select?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_selector?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_table?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_text?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#780
  def has_title?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_unchecked_field?(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def has_xpath?(*_arg0, **_arg1, &_arg2); end

  # @return [String] A snapshot of the DOM of the current document, as it looks right now (potentially modified by JavaScript).
  #
  # source://capybara//lib/capybara/session.rb#196
  def html; end

  # source://capybara//lib/capybara/session.rb#786
  def inspect; end

  # Returns the value of attribute mode.
  #
  # source://capybara//lib/capybara/session.rb#75
  def mode; end

  # Open a new window.
  # The current window doesn't change as the result of this call.
  # It should be switched to explicitly.
  #
  # @return [Capybara::Window] window that has been opened
  #
  # source://capybara//lib/capybara/session.rb#483
  def open_new_window(kind = T.unsafe(nil)); end

  # source://capybara//lib/capybara/session.rb#771
  def query(*_arg0, **_arg1, &_arg2); end

  # Disconnect from the current driver. A new driver will be instantiated on the next interaction.
  #
  # source://capybara//lib/capybara/session.rb#146
  def quit; end

  # Raise errors encountered in the server.
  #
  # source://capybara//lib/capybara/session.rb#157
  def raise_server_error!; end

  # Refresh the page.
  #
  # source://capybara//lib/capybara/session.rb#287
  def refresh; end

  # source://capybara//lib/capybara/session.rb#771
  def refute_selector(*_arg0, **_arg1, &_arg2); end

  # Reset the session (i.e. remove cookies and navigate to blank page).
  #
  # This method does not:
  #
  # * accept modal dialogs if they are present (Selenium driver now does, others may not)
  # * clear browser cache/HTML 5 local storage/IndexedDB/Web SQL database/etc.
  # * modify state of the driver/underlying browser in any other way
  #
  # as doing so will result in performance downsides and it's not needed to do everything from the list above for most apps.
  #
  # If you want to do anything from the list above on a general basis you can:
  #
  # * write RSpec/Cucumber/etc. after hook
  # * monkeypatch this method
  # * use Ruby's `prepend` method
  #
  # source://capybara//lib/capybara/session.rb#129
  def reset!; end

  # Reset the session (i.e. remove cookies and navigate to blank page).
  #
  # This method does not:
  #
  # * accept modal dialogs if they are present (Selenium driver now does, others may not)
  # * clear browser cache/HTML 5 local storage/IndexedDB/Web SQL database/etc.
  # * modify state of the driver/underlying browser in any other way
  #
  # as doing so will result in performance downsides and it's not needed to do everything from the list above for most apps.
  #
  # If you want to do anything from the list above on a general basis you can:
  #
  # * write RSpec/Cucumber/etc. after hook
  # * monkeypatch this method
  # * use Ruby's `prepend` method
  #
  # source://capybara//lib/capybara/session.rb#129
  def reset_session!; end

  # Returns a hash of response headers. Not supported by all drivers (e.g. Selenium).
  #
  # @return [Hash<String, String>] A hash of response headers.
  #
  # source://capybara//lib/capybara/session.rb#178
  def response_headers; end

  # source://capybara//lib/capybara/session.rb#771
  def right_click(*_arg0, **_arg1, &_arg2); end

  # Save a snapshot of the page and open it in a browser for inspection.
  #
  # If invoked without arguments it will save file to {Capybara.configure save_path}
  # and file will be given randomly generated filename. If invoked with a relative path
  # the path will be relative to {Capybara.configure save_path}.
  #
  # @param path [String] the path to where it should be saved
  #
  # source://capybara//lib/capybara/session.rb#731
  def save_and_open_page(path = T.unsafe(nil)); end

  # Save a screenshot of the page and open it for inspection.
  #
  # If invoked without arguments it will save file to {Capybara.configure save_path}
  # and file will be given randomly generated filename. If invoked with a relative path
  # the path will be relative to {Capybara.configure save_path}.
  #
  # @param path [String] the path to where it should be saved
  # @param options [Hash] a customizable set of options
  #
  # source://capybara//lib/capybara/session.rb#761
  def save_and_open_screenshot(path = T.unsafe(nil), **options); end

  # Save a snapshot of the page. If {Capybara.configure asset_host} is set it will inject `base` tag
  # pointing to {Capybara.configure asset_host}.
  #
  # If invoked without arguments it will save file to {Capybara.configure save_path}
  # and file will be given randomly generated filename. If invoked with a relative path
  # the path will be relative to {Capybara.configure save_path}.
  #
  # @param path [String] the path to where it should be saved
  # @return [String] the path to which the file was saved
  #
  # source://capybara//lib/capybara/session.rb#715
  def save_page(path = T.unsafe(nil)); end

  # Save a screenshot of page.
  #
  # If invoked without arguments it will save file to {Capybara.configure save_path}
  # and file will be given randomly generated filename. If invoked with a relative path
  # the path will be relative to {Capybara.configure save_path}.
  #
  # @param path [String] the path to where it should be saved
  # @param options [Hash] a customizable set of options
  # @return [String] the path to which the file was saved
  #
  # source://capybara//lib/capybara/session.rb#746
  def save_screenshot(path = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/session.rb#771
  def scroll_by(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def scroll_to(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def select(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#312
  def send_keys(*args, **kw_args); end

  # Returns the value of attribute server.
  #
  # source://capybara//lib/capybara/session.rb#75
  def server; end

  # source://capybara//lib/capybara/session.rb#836
  def server_url; end

  # @return [String] A snapshot of the DOM of the current document, as it looks right now (potentially modified by JavaScript).
  #
  # source://capybara//lib/capybara/session.rb#196
  def source; end

  # Returns the current HTTP status code as an integer. Not supported by all drivers (e.g. Selenium).
  #
  # @return [Integer] Current HTTP status code
  #
  # source://capybara//lib/capybara/session.rb#188
  def status_code; end

  # Switch to the given frame.
  #
  # If you use this method you are responsible for making sure you switch back to the parent frame when done in the frame changed to.
  # {#within_frame} is preferred over this method and should be used when possible.
  # May not be supported by all drivers.
  #
  # @overload switch_to_frame
  # @overload switch_to_frame
  #
  # source://capybara//lib/capybara/session.rb#407
  def switch_to_frame(frame); end

  # Switch to the given window.
  #
  # @overload switch_to_window
  # @overload switch_to_window
  # @raise [Capybara::ScopeError] if this method is invoked inside {#within} or
  #   {#within_frame} methods
  # @raise [ArgumentError] if both or neither arguments were provided
  # @return [Capybara::Window] window that has been switched to
  #
  # source://capybara//lib/capybara/session.rb#511
  def switch_to_window(window = T.unsafe(nil), **options, &window_locator); end

  # Returns the value of attribute synchronized.
  #
  # source://capybara//lib/capybara/session.rb#76
  def synchronized; end

  # Sets the attribute synchronized
  #
  # @param value the value to set the attribute synchronized to.
  #
  # source://capybara//lib/capybara/session.rb#76
  def synchronized=(_arg0); end

  # source://capybara//lib/capybara/session.rb#771
  def text(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#780
  def title(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def uncheck(*_arg0, **_arg1, &_arg2); end

  # source://capybara//lib/capybara/session.rb#771
  def unselect(*_arg0, **_arg1, &_arg2); end

  # Yield a block using a specific maximum wait time.
  #
  # source://capybara//lib/capybara/session.rb#799
  def using_wait_time(seconds, &block); end

  # Navigate to the given URL. The URL can either be a relative URL or an absolute URL
  # The behaviour of either depends on the driver.
  #
  #     session.visit('/foo')
  #     session.visit('http://google.com')
  #
  # For drivers which can run against an external application, such as the selenium driver
  # giving an absolute URL will navigate to that page. This allows testing applications
  # running on remote servers. For these drivers, setting {Capybara.configure app_host} will make the
  # remote server the default. For example:
  #
  #     Capybara.app_host = 'http://google.com'
  #     session.visit('/') # visits the google homepage
  #
  # If {Capybara.configure always_include_port} is set to `true` and this session is running against
  # a rack application, then the port that the rack application is running on will automatically
  # be inserted into the URL. Supposing the app is running on port `4567`, doing something like:
  #
  #     visit("http://google.com/test")
  #
  # Will actually navigate to `http://google.com:4567/test`.
  #
  # @param visit_uri [#to_s] The URL to navigate to. The parameter will be cast to a String.
  #
  # source://capybara//lib/capybara/session.rb#260
  def visit(visit_uri); end

  # Get the window that has been opened by the passed block.
  # It will wait for it to be opened (in the same way as other Capybara methods wait).
  # It's better to use this method than `windows.last`
  # {https://dvcs.w3.org/hg/webdriver/raw-file/default/webdriver-spec.html#h_note_10 as order of windows isn't defined in some drivers}.
  #
  # @overload window_opened_by
  #
  # source://capybara//lib/capybara/session.rb#580
  def window_opened_by(**options); end

  # Get all opened windows.
  # The order of windows in returned array is not defined.
  # The driver may sort windows by their creation time but it's not required.
  #
  # @return [Array<Capybara::Window>] an array of all windows
  #
  # source://capybara//lib/capybara/session.rb#470
  def windows; end

  # Executes the given block within the context of a node. {#within} takes the
  # same options as {Capybara::Node::Finders#find #find}, as well as a block. For the duration of the
  # block, any command to Capybara will be handled as though it were scoped
  # to the given element.
  #
  #     within(:xpath, './/div[@id="delivery-address"]') do
  #       fill_in('Street', with: '12 Main Street')
  #     end
  #
  # Just as with `#find`, if multiple elements match the selector given to
  # {#within}, an error will be raised, and just as with `#find`, this
  # behaviour can be controlled through the `:match` and `:exact` options.
  #
  # It is possible to omit the first parameter, in that case, the selector is
  # assumed to be of the type set in {Capybara.configure default_selector}.
  #
  #     within('div#delivery-address') do
  #       fill_in('Street', with: '12 Main Street')
  #     end
  #
  # Note that a lot of uses of {#within} can be replaced more succinctly with
  # chaining:
  #
  #     find('div#delivery-address').fill_in('Street', with: '12 Main Street')
  #
  # @overload within
  # @overload within
  # @raise [Capybara::ElementNotFound] If the scope can't be found before time expires
  #
  # source://capybara//lib/capybara/session.rb#361
  def within(*args, **kw_args); end

  # Executes the given block within the context of a node. {#within} takes the
  # same options as {Capybara::Node::Finders#find #find}, as well as a block. For the duration of the
  # block, any command to Capybara will be handled as though it were scoped
  # to the given element.
  #
  #     within(:xpath, './/div[@id="delivery-address"]') do
  #       fill_in('Street', with: '12 Main Street')
  #     end
  #
  # Just as with `#find`, if multiple elements match the selector given to
  # {#within}, an error will be raised, and just as with `#find`, this
  # behaviour can be controlled through the `:match` and `:exact` options.
  #
  # It is possible to omit the first parameter, in that case, the selector is
  # assumed to be of the type set in {Capybara.configure default_selector}.
  #
  #     within('div#delivery-address') do
  #       fill_in('Street', with: '12 Main Street')
  #     end
  #
  # Note that a lot of uses of {#within} can be replaced more succinctly with
  # chaining:
  #
  #     find('div#delivery-address').fill_in('Street', with: '12 Main Street')
  #
  # @overload within
  # @overload within
  # @raise [Capybara::ElementNotFound] If the scope can't be found before time expires
  #
  # source://capybara//lib/capybara/session.rb#361
  def within_element(*args, **kw_args); end

  # Execute the given block within the a specific fieldset given the id or legend of that fieldset.
  #
  # @param locator [String] Id or legend of the fieldset
  #
  # source://capybara//lib/capybara/session.rb#378
  def within_fieldset(locator, &block); end

  # Execute the given block within the given iframe using given frame, frame name/id or index.
  # May not be supported by all drivers.
  #
  # @overload within_frame
  # @overload within_frame
  # @overload within_frame
  #
  # source://capybara//lib/capybara/session.rb#447
  def within_frame(*args, **kw_args); end

  # Execute the given block within the a specific table given the id or caption of that table.
  #
  # @param locator [String] Id or caption of the table
  #
  # source://capybara//lib/capybara/session.rb#388
  def within_table(locator, &block); end

  # This method does the following:
  #
  # 1. Switches to the given window (it can be located by window instance/lambda/string).
  # 2. Executes the given block (within window located at previous step).
  # 3. Switches back (this step will be invoked even if an exception occurs at the second step).
  #
  # @overload within_window
  # @overload within_window
  # @raise [Capybara::ScopeError] if this method is invoked inside {#within_frame} method
  # @return value returned by the block
  #
  # source://capybara//lib/capybara/session.rb#544
  def within_window(window_or_proc); end

  private

  # source://capybara//lib/capybara/session.rb#901
  def _find_frame(*args, **kw_args); end

  # @raise [Capybara::ScopeError]
  #
  # source://capybara//lib/capybara/session.rb#917
  def _switch_to_window(window = T.unsafe(nil), **options, &window_locator); end

  # @raise [Capybara::WindowError]
  #
  # source://capybara//lib/capybara/session.rb#937
  def _switch_to_window_by_locator; end

  # source://capybara//lib/capybara/session.rb#848
  def accept_modal(type, text_or_options, options, &blk); end

  # source://capybara//lib/capybara/session.rb#897
  def adjust_server_port(uri); end

  # source://capybara//lib/capybara/session.rb#875
  def default_fn(extension); end

  # source://capybara//lib/capybara/session.rb#852
  def dismiss_modal(type, text_or_options, options, &blk); end

  # source://capybara//lib/capybara/session.rb#844
  def driver_args(args); end

  # source://capybara//lib/capybara/session.rb#884
  def element_script_result(arg); end

  # source://capybara//lib/capybara/session.rb#856
  def modal_options(text = T.unsafe(nil), **options); end

  # source://capybara//lib/capybara/session.rb#862
  def open_file(path); end

  # source://capybara//lib/capybara/session.rb#869
  def prepare_path(path, extension); end

  # source://capybara//lib/capybara/session.rb#880
  def scopes; end

  # source://capybara//lib/capybara/session.rb#945
  def synchronize_windows(options, &block); end

  class << self
    # @return [Boolean]
    #
    # source://capybara//lib/capybara/session.rb#824
    def instance_created?; end
  end
end

# @api private
#
# source://capybara//lib/capybara/session.rb#57
Capybara::Session::DOCUMENT_METHODS = T.let(T.unsafe(nil), Array)

# source://capybara//lib/capybara/session.rb#73
Capybara::Session::DSL_METHODS = T.let(T.unsafe(nil), Array)

# source://capybara//lib/capybara/session.rb#70
Capybara::Session::MODAL_METHODS = T.let(T.unsafe(nil), Array)

# source://capybara//lib/capybara/session.rb#41
Capybara::Session::NODE_METHODS = T.let(T.unsafe(nil), Array)

# source://capybara//lib/capybara/session.rb#60
Capybara::Session::SESSION_METHODS = T.let(T.unsafe(nil), Array)

class Capybara::SessionConfig
  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def always_include_port; end

  # source://capybara//lib/capybara/session/config.rb#13
  def always_include_port=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def app_host; end

  # source://capybara//lib/capybara/session/config.rb#85
  def app_host=(url); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def asset_host; end

  # source://capybara//lib/capybara/session/config.rb#13
  def asset_host=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def automatic_label_click; end

  # source://capybara//lib/capybara/session/config.rb#13
  def automatic_label_click=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def automatic_reload; end

  # source://capybara//lib/capybara/session/config.rb#13
  def automatic_reload=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_host; end

  # source://capybara//lib/capybara/session/config.rb#94
  def default_host=(url); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_max_wait_time; end

  # source://capybara//lib/capybara/session/config.rb#13
  def default_max_wait_time=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_normalize_ws; end

  # source://capybara//lib/capybara/session/config.rb#13
  def default_normalize_ws=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_retry_interval; end

  # source://capybara//lib/capybara/session/config.rb#13
  def default_retry_interval=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_selector; end

  # source://capybara//lib/capybara/session/config.rb#13
  def default_selector=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def default_set_options; end

  # source://capybara//lib/capybara/session/config.rb#13
  def default_set_options=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def disable_animation; end

  # source://capybara//lib/capybara/session/config.rb#13
  def disable_animation=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def enable_aria_label; end

  # source://capybara//lib/capybara/session/config.rb#13
  def enable_aria_label=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def enable_aria_role; end

  # source://capybara//lib/capybara/session/config.rb#13
  def enable_aria_role=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def exact; end

  # source://capybara//lib/capybara/session/config.rb#13
  def exact=(_arg0); end

  # source://capybara//lib/capybara/session/config.rb#13
  def exact_text; end

  # source://capybara//lib/capybara/session/config.rb#13
  def exact_text=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def ignore_hidden_elements; end

  # source://capybara//lib/capybara/session/config.rb#13
  def ignore_hidden_elements=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def match; end

  # source://capybara//lib/capybara/session/config.rb#13
  def match=(_arg0); end

  # source://capybara//lib/capybara/session/config.rb#13
  def predicates_wait; end

  # source://capybara//lib/capybara/session/config.rb#13
  def predicates_wait=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def raise_server_errors; end

  # source://capybara//lib/capybara/session/config.rb#13
  def raise_server_errors=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def run_server; end

  # source://capybara//lib/capybara/session/config.rb#13
  def run_server=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def save_path; end

  # source://capybara//lib/capybara/session/config.rb#13
  def save_path=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def server_errors; end

  # source://capybara//lib/capybara/session/config.rb#80
  def server_errors=(errors); end

  # @return [String] The IP address bound by default server
  #
  # source://capybara//lib/capybara/session/config.rb#75
  def server_host; end

  # source://capybara//lib/capybara/session/config.rb#13
  def server_host=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def server_port; end

  # source://capybara//lib/capybara/session/config.rb#13
  def server_port=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def test_id; end

  # Set an attribute to be optionally matched against the locator for builtin selector types.
  # This attribute will be checked by builtin selector types whenever id would normally be checked.
  # If `nil` then it will be ignored.
  #
  # @param id [String, Symbol, nil] Name of the attribute to use as the test id
  #
  # source://capybara//lib/capybara/session/config.rb#111
  def test_id=(id); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def visible_text_only; end

  # source://capybara//lib/capybara/session/config.rb#13
  def visible_text_only=(_arg0); end

  # See {Capybara.configure}
  #
  # source://capybara//lib/capybara/session/config.rb#13
  def w3c_click_offset; end

  # source://capybara//lib/capybara/session/config.rb#13
  def w3c_click_offset=(_arg0); end

  private

  # source://capybara//lib/capybara/session/config.rb#115
  def initialize_copy(other); end
end

# source://capybara//lib/capybara/session/config.rb#7
Capybara::SessionConfig::OPTIONS = T.let(T.unsafe(nil), Array)

module Capybara::SessionMatchers
  # Asserts that the page has the given path.
  # By default, if passed a full url this will compare against the full url,
  # if passed a path only the path+query portion will be compared, if passed a regexp
  # the comparison will depend on the :url option (path+query by default)
  #
  # @option options
  # @option options
  # @option options
  # @overload assert_current_path
  # @overload assert_current_path
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/session/matchers.rb#22
  def assert_current_path(path, **options, &optional_filter_block); end

  # Asserts that the page doesn't have the given path.
  # By default, if passed a full url this will compare against the full url,
  # if passed a path only the path+query portion will be compared, if passed a regexp
  # the comparison will depend on the :url option
  #
  # @option options
  # @option options
  # @option options
  # @overload assert_no_current_path
  # @overload assert_no_current_path
  # @param options [Hash] a customizable set of options
  # @raise [Capybara::ExpectationNotMet] if the assertion hasn't succeeded during wait time
  # @return [true]
  #
  # source://capybara//lib/capybara/session/matchers.rb#38
  def assert_no_current_path(path, **options, &optional_filter_block); end

  # Checks if the page has the given path.
  # By default, if passed a full url this will compare against the full url,
  # if passed a path only the path+query portion will be compared, if passed a regexp
  # the comparison will depend on the :url option
  #
  # @option options
  # @option options
  # @option options
  # @overload has_current_path?
  # @overload has_current_path?
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/session/matchers.rb#53
  def has_current_path?(path, **options, &optional_filter_block); end

  # Checks if the page doesn't have the given path.
  # By default, if passed a full url this will compare against the full url,
  # if passed a path only the path+query portion will be compared, if passed a regexp
  # the comparison will depend on the :url option
  #
  # @option options
  # @option options
  # @option options
  # @overload has_no_current_path?
  # @overload has_no_current_path?
  # @param options [Hash] a customizable set of options
  # @return [Boolean]
  #
  # source://capybara//lib/capybara/session/matchers.rb#66
  def has_no_current_path?(path, **options, &optional_filter_block); end

  private

  # source://capybara//lib/capybara/session/matchers.rb#72
  def _verify_current_path(path, filter_block, **options); end

  # source://capybara//lib/capybara/session/matchers.rb#80
  def make_predicate(options); end
end

class Capybara::UnselectNotAllowed < ::Capybara::CapybaraError; end

# source://capybara//lib/capybara/version.rb#4
Capybara::VERSION = T.let(T.unsafe(nil), String)

# The {Window} class represents a browser window.
#
# You can get an instance of the class by calling any of:
#
# * {Capybara::Session#windows}
# * {Capybara::Session#current_window}
# * {Capybara::Session#window_opened_by}
# * {Capybara::Session#switch_to_window}
#
# Note that some drivers (e.g. Selenium) support getting size of/resizing/closing only
# current window. So if you invoke such method for:
#
# * window that is current, Capybara will make 2 Selenium method invocations
#   (get handle of current window + get size/resize/close).
# * window that is not current, Capybara will make 4 Selenium method invocations
#   (get handle of current window + switch to given handle + get size/resize/close + switch to original handle)
class Capybara::Window
  # @api private
  # @return [Window] a new instance of Window
  #
  # source://capybara//lib/capybara/window.rb#30
  def initialize(session, handle); end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/window.rb#115
  def ==(other); end

  # Close window.
  #
  # If this method was called for window that is current, then after calling this method
  # future invocations of other Capybara methods should raise
  # {Capybara::Driver::Base#no_such_window_error session.driver.no_such_window_error} until another window will be switched to.
  #
  # If this method was called for window that is not current, then after calling this method
  # current window should remain the same as it was before calling this method.
  #
  # source://capybara//lib/capybara/window.rb#67
  def close; end

  # @return [Boolean] whether the window is closed
  #
  # source://capybara//lib/capybara/window.rb#44
  def closed?; end

  # @return [Boolean] whether this window is the window in which commands are being executed
  #
  # source://capybara//lib/capybara/window.rb#50
  def current?; end

  # @return [Boolean]
  #
  # source://capybara//lib/capybara/window.rb#115
  def eql?(other); end

  # @return [Boolean] whether the window is not closed
  #
  # source://capybara//lib/capybara/window.rb#38
  def exists?; end

  # Fullscreen window.
  #
  # If a particular driver doesn't have concept of fullscreen it may not support this method.
  #
  # If this method was called for window that is not current, then after calling this method
  # current window should remain the same as it was before calling this method.
  #
  # source://capybara//lib/capybara/window.rb#111
  def fullscreen; end

  # @return [String] a string that uniquely identifies window within session
  #
  # source://capybara//lib/capybara/window.rb#24
  def handle; end

  # source://capybara//lib/capybara/window.rb#120
  def hash; end

  # source://capybara//lib/capybara/window.rb#124
  def inspect; end

  # Maximize window.
  #
  # If a particular driver (e.g. headless driver) doesn't have concept of maximizing it
  # may not support this method.
  #
  # If this method was called for window that is not current, then after calling this method
  # current window should remain the same as it was before calling this method.
  #
  # source://capybara//lib/capybara/window.rb#100
  def maximize; end

  # Resize window.
  #
  # If this method was called for window that is not current, then after calling this method
  # current window should remain the same as it was before calling this method.
  #
  # @param width [Integer] the new window width in pixels
  # @param height [Integer] the new window height in pixels
  #
  # source://capybara//lib/capybara/window.rb#88
  def resize_to(width, height); end

  # @return [Capybara::Session] session that this window belongs to
  #
  # source://capybara//lib/capybara/window.rb#27
  def session; end

  # Get window size.
  #
  # If this method was called for window that is not current, then after calling this method
  # current window should remain the same as it was before calling this method.
  #
  # @return [Array<(Integer, Integer)>] an array with width and height
  #
  # source://capybara//lib/capybara/window.rb#77
  def size; end

  private

  # @raise [Capybara::WindowError]
  #
  # source://capybara//lib/capybara/window.rb#130
  def wait_for_stable_size(seconds = T.unsafe(nil)); end
end

class Capybara::WindowError < ::Capybara::CapybaraError; end

module XPath::DSL
  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def !(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def !=(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def %(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def &(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def *(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#62
  def +(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def /(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def <(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def <=(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def ==(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def >(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def >=(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#45
  def [](expression); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def ancestor(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def ancestor_or_self(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def and(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#21
  def anywhere(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#25
  def attr(expression); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def attribute(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#17
  def axis(name, *element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#58
  def binary_operator(name, rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def boolean(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def ceiling(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#13
  def child(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def concat(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def contains(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#147
  def contains_word(word); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def count(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#33
  def css(selector); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#5
  def current; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#9
  def descendant(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def descendant_or_self(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def divide(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#143
  def ends_with(suffix); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def equals(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def false(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def floor(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def following(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def following_sibling(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#37
  def function(name, *arguments); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def gt(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def gte(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def id(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def inverse(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#54
  def is(expression); end

  # source://capybara//lib/capybara/selector/xpath_extensions.rb#13
  def join(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def lang(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#67
  def last; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def local_name(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#154
  def lowercase; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def lt(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def lte(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#41
  def method(name, *arguments); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def minus(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def mod(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def multiply(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def n(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def namespace(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def namespace_uri(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#166
  def next_sibling(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def normalize(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def normalize_space(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def not(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def not_equals(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def number(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#162
  def one_of(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def or(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def parent(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def plus(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#71
  def position; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def preceding(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def preceding_sibling(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#170
  def previous_sibling(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#95
  def qname; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def round(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def self(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#136
  def self_axis(*element_names); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def starts_with(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def string(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def string_length(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def substring(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def substring_after(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def substring_before(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def sum(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#29
  def text; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def translate(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def true(*args); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#62
  def union(*expressions); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#158
  def uppercase; end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#45
  def where(expression); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#122
  def |(rhs); end

  # source://xpath/3.2.0/lib/xpath/dsl.rb#90
  def ~(*args); end
end

# source://xpath/3.2.0/lib/xpath/dsl.rb#128
XPath::DSL::AXES = T.let(T.unsafe(nil), Array)

# source://xpath/3.2.0/lib/xpath/dsl.rb#152
XPath::DSL::LOWERCASE_LETTERS = T.let(T.unsafe(nil), String)

# source://xpath/3.2.0/lib/xpath/dsl.rb#75
XPath::DSL::METHODS = T.let(T.unsafe(nil), Array)

# source://xpath/3.2.0/lib/xpath/dsl.rb#105
XPath::DSL::OPERATORS = T.let(T.unsafe(nil), Array)

# source://xpath/3.2.0/lib/xpath/dsl.rb#151
XPath::DSL::UPPERCASE_LETTERS = T.let(T.unsafe(nil), String)

class XPath::Renderer
  # source://xpath/3.2.0/lib/xpath/renderer.rb#9
  def initialize(type); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#55
  def anywhere(element_names); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#63
  def attribute(current, name); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#51
  def axis(current, name, element_names); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#71
  def binary_operator(name, left, right); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#47
  def child(current, element_names); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#18
  def convert_argument(argument); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#95
  def css(current, selector); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#43
  def descendant(current, element_names); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#106
  def function(name, *arguments); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#75
  def is(one, two); end

  # source://capybara//lib/capybara/selector/xpath_extensions.rb#5
  def join(*expressions); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#91
  def literal(node); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#13
  def render(node); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#28
  def string_literal(string); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#87
  def text(current); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#39
  def this_node; end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#102
  def union(*expressions); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#83
  def variable(name); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#59
  def where(on, condition); end

  private

  # source://xpath/3.2.0/lib/xpath/renderer.rb#122
  def valid_xml_name?(name); end

  # source://xpath/3.2.0/lib/xpath/renderer.rb#112
  def with_element_conditions(expression, element_names); end

  class << self
    # source://xpath/3.2.0/lib/xpath/renderer.rb#5
    def render(node, type); end
  end
end
