# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `browserslist_useragent` gem.
# Please instead update this file by running `bin/tapioca gem browserslist_useragent`.

module BrowserslistUseragent; end

# Checks matching of browserslist queies array to the user agent string
class BrowserslistUseragent::Match
  # @return [Match] a new instance of Match
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#10
  def initialize(queries, user_agent_string); end

  # @return [Boolean]
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#30
  def browser?; end

  # Returns the value of attribute queries.
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#8
  def queries; end

  # Returns the value of attribute user_agent_string.
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#8
  def user_agent_string; end

  # @return [Boolean]
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#20
  def version?(allow_higher: T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#60
  def match_higher_version?(semantic, query_version); end

  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#41
  def match_semantic_version(semantic, allow_higher:); end

  # @return [Boolean]
  #
  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#51
  def match_version?(semantic, query_version); end

  # source://browserslist_useragent//lib/browserslist_useragent/match.rb#37
  def user_agent; end
end

# Normalizes browserslist query to existing browser family names
class BrowserslistUseragent::QueryNormalizer
  # @return [QueryNormalizer] a new instance of QueryNormalizer
  #
  # source://browserslist_useragent//lib/browserslist_useragent/query_normalizer.rb#24
  def initialize(query); end

  # source://browserslist_useragent//lib/browserslist_useragent/query_normalizer.rb#28
  def call; end

  # Returns the value of attribute query.
  #
  # source://browserslist_useragent//lib/browserslist_useragent/query_normalizer.rb#22
  def query; end
end

# source://browserslist_useragent//lib/browserslist_useragent/query_normalizer.rb#6
BrowserslistUseragent::QueryNormalizer::NORMALIZED_NAMES = T.let(T.unsafe(nil), Hash)

# Resolves uaser agent string to {family, version} hash
class BrowserslistUseragent::Resolver
  # @return [Resolver] a new instance of Resolver
  #
  # source://browserslist_useragent//lib/browserslist_useragent/resolver.rb#10
  def initialize(user_agent_string); end

  # source://browserslist_useragent//lib/browserslist_useragent/resolver.rb#14
  def call; end

  # Returns the value of attribute user_agent_string.
  #
  # source://browserslist_useragent//lib/browserslist_useragent/resolver.rb#8
  def user_agent_string; end

  class << self
    # source://browserslist_useragent//lib/browserslist_useragent/resolver.rb#52
    def user_agent_parser; end
  end
end

# source://browserslist_useragent//lib/browserslist_useragent/version.rb#4
BrowserslistUseragent::VERSION = T.let(T.unsafe(nil), String)

# Normalizes user agent version to semantically valid state
class BrowserslistUseragent::VersionNormalizer
  # @return [VersionNormalizer] a new instance of VersionNormalizer
  #
  # source://browserslist_useragent//lib/browserslist_useragent/version_normalizer.rb#10
  def initialize(version); end

  # source://browserslist_useragent//lib/browserslist_useragent/version_normalizer.rb#14
  def call; end

  # Returns the value of attribute version.
  #
  # source://browserslist_useragent//lib/browserslist_useragent/version_normalizer.rb#8
  def version; end
end
