# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `browser` gem.
# Please instead update this file by running `bin/tapioca gem browser`.

module Browser
  class << self
    # Returns the value of attribute accept_language_size_limit.
    #
    # source://browser//lib/browser/browser.rb#61
    def accept_language_size_limit; end

    # Sets the attribute accept_language_size_limit
    #
    # @param value the value to set the attribute accept_language_size_limit to.
    #
    # source://browser//lib/browser/browser.rb#61
    def accept_language_size_limit=(_arg0); end

    # Hold the list of browser matchers.
    # Order is important.
    #
    # source://browser//lib/browser/browser.rb#69
    def matchers; end

    # source://browser//lib/browser/browser.rb#103
    def new(user_agent, **kwargs); end

    # source://browser//lib/browser/browser.rb#56
    def root; end

    # Returns the value of attribute user_agent_size_limit.
    #
    # source://browser//lib/browser/browser.rb#61
    def user_agent_size_limit; end

    # Sets the attribute user_agent_size_limit
    #
    # @param value the value to set the attribute user_agent_size_limit to.
    #
    # source://browser//lib/browser/browser.rb#61
    def user_agent_size_limit=(_arg0); end
  end
end

class Browser::AcceptLanguage
  # @return [AcceptLanguage] a new instance of AcceptLanguage
  #
  # source://browser//lib/browser/accept_language.rb#22
  def initialize(part); end

  # source://browser//lib/browser/accept_language.rb#34
  def code; end

  # source://browser//lib/browser/accept_language.rb#26
  def full; end

  # source://browser//lib/browser/accept_language.rb#30
  def name; end

  # Returns the value of attribute part.
  #
  # source://browser//lib/browser/accept_language.rb#20
  def part; end

  # source://browser//lib/browser/accept_language.rb#48
  def quality; end

  # source://browser//lib/browser/accept_language.rb#41
  def region; end

  private

  # source://browser//lib/browser/accept_language.rb#56
  def quality_value; end

  class << self
    # source://browser//lib/browser/accept_language.rb#5
    def languages; end

    # source://browser//lib/browser/accept_language.rb#9
    def parse(accept_language); end
  end
end

module Browser::ActionController
  extend ::ActiveSupport::Concern

  private

  # source://browser//lib/browser/action_controller.rb#13
  def browser; end
end

class Browser::Alipay < ::Browser::Base
  # source://browser//lib/browser/alipay.rb#13
  def full_version; end

  # source://browser//lib/browser/alipay.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/alipay.rb#17
  def match?; end

  # source://browser//lib/browser/alipay.rb#9
  def name; end
end

class Browser::Base
  include ::Browser::DetectVersion

  # @return [Base] a new instance of Base
  #
  # source://browser//lib/browser/base.rb#9
  def initialize(ua, accept_language: T.unsafe(nil)); end

  # Return an array with all preferred languages that this browser accepts.
  #
  # source://browser//lib/browser/base.rb#22
  def accept_language; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#189
  def alipay?(expected_version = T.unsafe(nil)); end

  # Return the bot info.
  #
  # source://browser//lib/browser/base.rb#46
  def bot; end

  # Detect if current user agent is from a bot.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#51
  def bot?; end

  # Detect if browser is Chrome.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#146
  def chrome?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#71
  def compatibility_view?; end

  # Detect if browser is Apple CoreMedia.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#120
  def core_media?(expected_version = T.unsafe(nil)); end

  # Return the device info.
  #
  # source://browser//lib/browser/base.rb#56
  def device; end

  # Detect if browser is DuckDuckGo.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#200
  def duck_duck_go?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Microsoft Edge.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#67
  def edge?(expected_version = T.unsafe(nil)); end

  # Detect if the browser is Electron.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#262
  def electron?(expected_version = T.unsafe(nil)); end

  # Detect if browser if Facebook.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#96
  def facebook?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Firefox.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#141
  def firefox?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Google Search App
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#240
  def google_search_app?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Huawei.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#212
  def huawei_browser?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Microsoft Internet Explorer.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#61
  def ie?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Instagram.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#84
  def instagram?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#248
  def known?; end

  # Detect if browser is Maxthon.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#224
  def maxthon?(expected_version = T.unsafe(nil)); end

  # Return a meta info about this browser.
  #
  # source://browser//lib/browser/base.rb#17
  def meta; end

  # Detect if browser is MicroMessenger.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#178
  def micro_messenger?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Xiaomi Miui.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#218
  def miui_browser?(expected_version = T.unsafe(nil)); end

  # source://browser//lib/browser/base.rb#75
  def msie_full_version; end

  # source://browser//lib/browser/base.rb#79
  def msie_version; end

  # Detect if browser is Nokia S40 Ovi Browser.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#173
  def nokia?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Opera.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#151
  def opera?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Opera Mini.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#194
  def opera_mini?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Otter.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#102
  def otter?(expected_version = T.unsafe(nil)); end

  # Detect if browser is PhantomJS
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#126
  def phantom_js?(expected_version = T.unsafe(nil)); end

  # Return the platform.
  #
  # source://browser//lib/browser/base.rb#41
  def platform; end

  # Detect if browser is a proxy browser.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#257
  def proxy?; end

  # Detect if browser is QQ.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#229
  def qq?(expected_version = T.unsafe(nil)); end

  # Detect if browser is QuickTime
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#115
  def quicktime?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Safari.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#132
  def safari?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#136
  def safari_webapp_mode?; end

  # Detect if browser is Samsung.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#206
  def samsung_browser?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Snapchat.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#90
  def snapchat?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Sougou.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#234
  def sougou_browser?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Sputnik.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#156
  def sputnik?(expected_version = T.unsafe(nil)); end

  # Return a meta info about this browser.
  #
  # source://browser//lib/browser/base.rb#17
  def to_a; end

  # Return meta representation as string.
  #
  # source://browser//lib/browser/base.rb#32
  def to_s; end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/base.rb#7
  def ua; end

  # Detect if browser is UCBrowser.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#167
  def uc_browser?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#252
  def unknown?; end

  # source://browser//lib/browser/base.rb#36
  def version; end

  # Detect if browser is WebKit-based.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#108
  def webkit?(expected_version = T.unsafe(nil)); end

  # source://browser//lib/browser/base.rb#244
  def webkit_full_version; end

  # Detect if browser is MicroMessenger.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#178
  def wechat?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#185
  def weibo?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Yandex.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#161
  def yandex?(expected_version = T.unsafe(nil)); end

  # Detect if browser is Yandex.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/base.rb#161
  def yandex_browser?(expected_version = T.unsafe(nil)); end

  private

  # @raise [Error]
  #
  # source://browser//lib/browser/base.rb#266
  def validate_size(subject, input); end
end

class Browser::BlackBerry < ::Browser::Base
  # source://browser//lib/browser/blackberry.rb#13
  def full_version; end

  # source://browser//lib/browser/blackberry.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/blackberry.rb#19
  def match?; end

  # source://browser//lib/browser/blackberry.rb#9
  def name; end
end

class Browser::Bot
  # @return [Bot] a new instance of Bot
  #
  # source://browser//lib/browser/bot.rb#43
  def initialize(ua); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/bot.rb#48
  def bot?; end

  # source://browser//lib/browser/bot.rb#60
  def name; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/bot.rb#56
  def search_engine?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/bot.rb#52
  def why?; end

  private

  # @return [Boolean]
  #
  # source://browser//lib/browser/bot.rb#66
  def bot_exception?; end

  # Returns the value of attribute browser.
  #
  # source://browser//lib/browser/bot.rb#41
  def browser; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/bot.rb#70
  def detect_bot?; end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/bot.rb#41
  def ua; end

  class << self
    # source://browser//lib/browser/bot.rb#27
    def bot_exceptions; end

    # source://browser//lib/browser/bot.rb#23
    def bots; end

    # source://browser//lib/browser/bot.rb#11
    def default_matchers; end

    # source://browser//lib/browser/bot.rb#19
    def load_yaml(path); end

    # source://browser//lib/browser/bot.rb#7
    def matchers; end

    # source://browser//lib/browser/bot.rb#31
    def search_engines; end

    # @return [Boolean]
    #
    # source://browser//lib/browser/bot.rb#35
    def why?(ua); end
  end
end

class Browser::Bot::EmptyUserAgentMatcher
  class << self
    # source://browser//lib/browser/bot/empty_user_agent_matcher.rb#6
    def call(ua, _browser); end
  end
end

# source://browser//lib/browser/bot.rb#5
Browser::Bot::GENERIC_NAME = T.let(T.unsafe(nil), String)

class Browser::Bot::KeywordMatcher
  class << self
    # source://browser//lib/browser/bot/keyword_matcher.rb#6
    def call(ua, _browser); end
  end
end

class Browser::Bot::KnownBotsMatcher
  class << self
    # source://browser//lib/browser/bot/known_bots_matcher.rb#6
    def call(ua, _browser); end
  end
end

class Browser::Chrome < ::Browser::Base
  # source://browser//lib/browser/chrome.rb#13
  def full_version; end

  # source://browser//lib/browser/chrome.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/chrome.rb#22
  def match?; end

  # source://browser//lib/browser/chrome.rb#9
  def name; end
end

module Browser::DetectVersion
  private

  # @return [Boolean]
  #
  # source://browser//lib/browser/detect_version.rb#5
  def detect_version?(actual_version, expected_version); end

  # source://browser//lib/browser/detect_version.rb#18
  def parse_version(version); end
end

class Browser::Device
  # @return [Device] a new instance of Device
  #
  # source://browser//lib/browser/device.rb#56
  def initialize(ua); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#148
  def blackberry_playbook?; end

  # Detect if browser is console (currently Xbox, PlayStation, or Nintendo).
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#192
  def console?; end

  # source://browser//lib/browser/device.rb#66
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#88
  def ipad?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#101
  def iphone?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#96
  def ipod?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#96
  def ipod_touch?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#125
  def kindle?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#129
  def kindle_fire?; end

  # Detect if browser is mobile.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#84
  def mobile?; end

  # source://browser//lib/browser/device.rb#70
  def name; end

  # Detect if browser is Nintendo.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#187
  def nintendo?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#143
  def nintendo_switch?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#133
  def nintendo_wii?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#138
  def nintendo_wiiu?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#148
  def playbook?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#105
  def playstation3?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#110
  def playstation4?; end

  # Detect if browser is running under PlayStation.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#182
  def playstation?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#119
  def playstation_vita?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#105
  def ps3?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#110
  def ps4?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#115
  def psp?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#119
  def psp_vita?; end

  # Detect if device is a Samsung.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#197
  def samsung?; end

  # Detect if browser is Silk.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#162
  def silk?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#153
  def surface?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#143
  def switch?; end

  # Detect if browser is tablet (currently iPad, Android, Surface or
  # Playbook).
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#76
  def tablet?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#157
  def tv?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#92
  def unknown?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#119
  def vita?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#133
  def wii?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#138
  def wiiu?; end

  # Detect if browser is running under Xbox.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#167
  def xbox?; end

  # Detect if browser is running under Xbox 360.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#172
  def xbox_360?; end

  # Detect if browser is running under Xbox One.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#177
  def xbox_one?; end

  private

  # Regex taken from http://detectmobilebrowsers.com
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/device.rb#203
  def detect_mobile?; end

  # source://browser//lib/browser/device.rb#211
  def platform; end

  # source://browser//lib/browser/device.rb#60
  def subject; end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/device.rb#27
  def ua; end

  class << self
    # Hold the list of device matchers.
    # Order is important.
    #
    # source://browser//lib/browser/device.rb#31
    def matchers; end
  end
end

class Browser::Device::Android < ::Browser::Device::Base
  # source://browser//lib/browser/device/android.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/android.rb#15
  def match?; end

  # source://browser//lib/browser/device/android.rb#10
  def name; end
end

class Browser::Device::Base
  # @return [Base] a new instance of Base
  #
  # source://browser//lib/browser/device/base.rb#8
  def initialize(ua); end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/device/base.rb#6
  def ua; end
end

class Browser::Device::BlackBerryPlaybook < ::Browser::Device::Base
  # source://browser//lib/browser/device/blackberry_playbook.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/blackberry_playbook.rb#14
  def match?; end

  # source://browser//lib/browser/device/blackberry_playbook.rb#10
  def name; end
end

class Browser::Device::Ipad < ::Browser::Device::Base
  # source://browser//lib/browser/device/ipad.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/ipad.rb#14
  def match?; end

  # source://browser//lib/browser/device/ipad.rb#10
  def name; end
end

class Browser::Device::Iphone < ::Browser::Device::Base
  # source://browser//lib/browser/device/iphone.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/iphone.rb#14
  def match?; end

  # source://browser//lib/browser/device/iphone.rb#10
  def name; end
end

class Browser::Device::IpodTouch < ::Browser::Device::Base
  # source://browser//lib/browser/device/ipod_touch.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/ipod_touch.rb#14
  def match?; end

  # source://browser//lib/browser/device/ipod_touch.rb#10
  def name; end
end

class Browser::Device::Kindle < ::Browser::Device::Base
  # source://browser//lib/browser/device/kindle.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/kindle.rb#14
  def match?; end

  # source://browser//lib/browser/device/kindle.rb#10
  def name; end
end

class Browser::Device::KindleFire < ::Browser::Device::Base
  # source://browser//lib/browser/device/kindle_fire.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/kindle_fire.rb#14
  def match?; end

  # source://browser//lib/browser/device/kindle_fire.rb#10
  def name; end
end

class Browser::Device::PSP < ::Browser::Device::Base
  # source://browser//lib/browser/device/psp.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/psp.rb#14
  def match?; end

  # source://browser//lib/browser/device/psp.rb#10
  def name; end
end

class Browser::Device::PSVita < ::Browser::Device::Base
  # source://browser//lib/browser/device/psvita.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/psvita.rb#14
  def match?; end

  # source://browser//lib/browser/device/psvita.rb#10
  def name; end
end

class Browser::Device::PlayStation3 < ::Browser::Device::Base
  # source://browser//lib/browser/device/playstation3.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/playstation3.rb#14
  def match?; end

  # source://browser//lib/browser/device/playstation3.rb#10
  def name; end
end

class Browser::Device::PlayStation4 < ::Browser::Device::Base
  # source://browser//lib/browser/device/playstation4.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/playstation4.rb#14
  def match?; end

  # source://browser//lib/browser/device/playstation4.rb#10
  def name; end
end

class Browser::Device::Samsung < ::Browser::Device::Base
  # source://browser//lib/browser/device/samsung.rb#20
  def code; end

  # source://browser//lib/browser/device/samsung.rb#12
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/samsung.rb#28
  def match?; end

  # source://browser//lib/browser/device/samsung.rb#24
  def matches; end

  # source://browser//lib/browser/device/samsung.rb#16
  def name; end

  class << self
    # source://browser//lib/browser/device/samsung.rb#8
    def names; end
  end
end

# source://browser//lib/browser/device/samsung.rb#6
Browser::Device::Samsung::REGEX = T.let(T.unsafe(nil), Regexp)

class Browser::Device::Surface < ::Browser::Device::Base
  # source://browser//lib/browser/device/surface.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/surface.rb#14
  def match?; end

  # source://browser//lib/browser/device/surface.rb#10
  def name; end

  private

  # source://browser//lib/browser/device/surface.rb#18
  def platform; end
end

class Browser::Device::Switch < ::Browser::Device::Base
  # source://browser//lib/browser/device/switch.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/switch.rb#14
  def match?; end

  # source://browser//lib/browser/device/switch.rb#10
  def name; end
end

class Browser::Device::TV < ::Browser::Device::Base
  # source://browser//lib/browser/device/tv.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/tv.rb#14
  def match?; end

  # source://browser//lib/browser/device/tv.rb#10
  def name; end
end

class Browser::Device::Unknown < ::Browser::Device::Base
  # source://browser//lib/browser/device/unknown.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/unknown.rb#14
  def match?; end

  # source://browser//lib/browser/device/unknown.rb#10
  def name; end
end

class Browser::Device::Wii < ::Browser::Device::Base
  # source://browser//lib/browser/device/wii.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/wii.rb#14
  def match?; end

  # source://browser//lib/browser/device/wii.rb#10
  def name; end
end

class Browser::Device::WiiU < ::Browser::Device::Base
  # source://browser//lib/browser/device/wiiu.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/wiiu.rb#14
  def match?; end

  # source://browser//lib/browser/device/wiiu.rb#10
  def name; end
end

class Browser::Device::Xbox360 < ::Browser::Device::Base
  # source://browser//lib/browser/device/xbox_360.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/xbox_360.rb#14
  def match?; end

  # source://browser//lib/browser/device/xbox_360.rb#10
  def name; end
end

class Browser::Device::XboxOne < ::Browser::Device::Base
  # source://browser//lib/browser/device/xbox_one.rb#6
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/device/xbox_one.rb#14
  def match?; end

  # source://browser//lib/browser/device/xbox_one.rb#10
  def name; end
end

class Browser::DuckDuckGo < ::Browser::Base
  # source://browser//lib/browser/duck_duck_go.rb#13
  def full_version; end

  # source://browser//lib/browser/duck_duck_go.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/duck_duck_go.rb#18
  def match?; end

  # source://browser//lib/browser/duck_duck_go.rb#9
  def name; end
end

# source://browser//lib/browser/browser.rb#52
Browser::EMPTY_STRING = T.let(T.unsafe(nil), String)

class Browser::Edge < ::Browser::InternetExplorer
  # @return [Boolean]
  #
  # source://browser//lib/browser/edge.rb#21
  def chrome_based?; end

  # source://browser//lib/browser/edge.rb#13
  def full_version; end

  # source://browser//lib/browser/edge.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/edge.rb#17
  def match?; end

  # source://browser//lib/browser/edge.rb#9
  def name; end
end

class Browser::Electron < ::Browser::Base
  # source://browser//lib/browser/electron.rb#13
  def full_version; end

  # source://browser//lib/browser/electron.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/electron.rb#18
  def match?; end

  # source://browser//lib/browser/electron.rb#9
  def name; end
end

class Browser::Error < ::StandardError; end

class Browser::Facebook < ::Browser::Base
  # source://browser//lib/browser/facebook.rb#13
  def full_version; end

  # source://browser//lib/browser/facebook.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/facebook.rb#19
  def match?; end

  # source://browser//lib/browser/facebook.rb#9
  def name; end
end

class Browser::Firefox < ::Browser::Base
  # source://browser//lib/browser/firefox.rb#13
  def full_version; end

  # source://browser//lib/browser/firefox.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/firefox.rb#17
  def match?; end

  # source://browser//lib/browser/firefox.rb#9
  def name; end
end

class Browser::GoogleSearchApp < ::Browser::Chrome
  # source://browser//lib/browser/google_search_app.rb#13
  def full_version; end

  # source://browser//lib/browser/google_search_app.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/google_search_app.rb#17
  def match?; end

  # source://browser//lib/browser/google_search_app.rb#9
  def name; end
end

class Browser::HuaweiBrowser < ::Browser::Base
  # source://browser//lib/browser/huawei_browser.rb#13
  def full_version; end

  # source://browser//lib/browser/huawei_browser.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/huawei_browser.rb#17
  def match?; end

  # source://browser//lib/browser/huawei_browser.rb#9
  def name; end
end

class Browser::Instagram < ::Browser::Base
  # source://browser//lib/browser/instagram.rb#13
  def full_version; end

  # source://browser//lib/browser/instagram.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/instagram.rb#17
  def match?; end

  # source://browser//lib/browser/instagram.rb#9
  def name; end
end

class Browser::InternetExplorer < ::Browser::Base
  # Detect if IE is running in compatibility mode.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/internet_explorer.rb#41
  def compatibility_view?; end

  # source://browser//lib/browser/internet_explorer.rb#22
  def full_version; end

  # source://browser//lib/browser/internet_explorer.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/internet_explorer.rb#36
  def match?; end

  # source://browser//lib/browser/internet_explorer.rb#26
  def msie_full_version; end

  # source://browser//lib/browser/internet_explorer.rb#32
  def msie_version; end

  # source://browser//lib/browser/internet_explorer.rb#18
  def name; end

  private

  # source://browser//lib/browser/internet_explorer.rb#45
  def ie_version; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/internet_explorer.rb#58
  def modern_ie?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/internet_explorer.rb#54
  def msie?; end

  # Return the trident version.
  #
  # source://browser//lib/browser/internet_explorer.rb#50
  def trident_version; end
end

# https://msdn.microsoft.com/en-us/library/ms537503(v=vs.85).aspx#TriToken
#
# source://browser//lib/browser/internet_explorer.rb#6
Browser::InternetExplorer::TRIDENT_MAPPING = T.let(T.unsafe(nil), Hash)

class Browser::Maxthon < ::Browser::Base
  # source://browser//lib/browser/maxthon.rb#13
  def full_version; end

  # source://browser//lib/browser/maxthon.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/maxthon.rb#17
  def match?; end

  # source://browser//lib/browser/maxthon.rb#9
  def name; end
end

module Browser::Meta
  class << self
    # source://browser//lib/browser/meta/base.rb#21
    def get(browser); end

    # source://browser//lib/browser/meta/base.rb#5
    def rules; end
  end
end

class Browser::Meta::Base
  # @return [Base] a new instance of Base
  #
  # source://browser//lib/browser/meta/base.rb#31
  def initialize(browser); end

  # Set the browser instance.
  #
  # source://browser//lib/browser/meta/base.rb#29
  def browser; end

  # source://browser//lib/browser/meta/base.rb#35
  def meta; end

  # source://browser//lib/browser/meta/base.rb#39
  def to_a; end
end

class Browser::Meta::Device < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/device.rb#6
  def meta; end
end

class Browser::Meta::GenericBrowser < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/generic_browser.rb#6
  def meta; end

  private

  # @return [Boolean]
  #
  # source://browser//lib/browser/meta/generic_browser.rb#10
  def generic?; end
end

class Browser::Meta::IE < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/ie.rb#10
  def meta; end

  # source://browser//lib/browser/meta/ie.rb#6
  def version; end
end

class Browser::Meta::IOS < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/ios.rb#6
  def meta; end
end

class Browser::Meta::Id < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/id.rb#6
  def meta; end
end

class Browser::Meta::Mobile < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/mobile.rb#6
  def meta; end
end

class Browser::Meta::Platform < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/platform.rb#6
  def meta; end
end

class Browser::Meta::Proxy < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/proxy.rb#6
  def meta; end
end

class Browser::Meta::Safari < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/safari.rb#6
  def meta; end
end

class Browser::Meta::Tablet < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/tablet.rb#6
  def meta; end
end

class Browser::Meta::Webkit < ::Browser::Meta::Base
  # source://browser//lib/browser/meta/webkit.rb#6
  def meta; end
end

class Browser::MicroMessenger < ::Browser::Base
  # source://browser//lib/browser/micro_messenger.rb#13
  def full_version; end

  # source://browser//lib/browser/micro_messenger.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/micro_messenger.rb#17
  def match?; end

  # source://browser//lib/browser/micro_messenger.rb#9
  def name; end
end

class Browser::Middleware
  # @raise [ArgumentError]
  # @return [Middleware] a new instance of Middleware
  #
  # source://browser//lib/browser/middleware.rb#15
  def initialize(app, &block); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/middleware.rb#66
  def assets?(request); end

  # source://browser//lib/browser/middleware.rb#22
  def call(env); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/middleware.rb#62
  def html?(request); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/middleware.rb#58
  def process?(request); end

  # source://browser//lib/browser/middleware.rb#50
  def redirect(path); end

  # source://browser//lib/browser/middleware.rb#40
  def resolve_redirection(env, current_path, path); end

  # source://browser//lib/browser/middleware.rb#54
  def run_app(env); end
end

# Detect the ACCEPT header. IE8 send */*.
#
# source://browser//lib/browser/middleware.rb#13
Browser::Middleware::ACCEPT_REGEX = T.let(T.unsafe(nil), Regexp)

# Detect the most common assets.
#
# source://browser//lib/browser/middleware.rb#9
Browser::Middleware::ASSETS_REGEX = T.let(T.unsafe(nil), Regexp)

class Browser::Middleware::Context
  # @return [Context] a new instance of Context
  #
  # source://browser//lib/browser/middleware/context.rb#8
  def initialize(request); end

  # Returns the value of attribute browser.
  #
  # source://browser//lib/browser/middleware/context.rb#6
  def browser; end

  # source://browser//lib/browser/middleware/context.rb#17
  def redirect_to(path); end

  # Returns the value of attribute request.
  #
  # source://browser//lib/browser/middleware/context.rb#6
  def request; end
end

module Browser::Middleware::Context::Additions
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionDispatch::Routing::UrlFor
  include ::Browser::Middleware::Context::UrlMethods

  mixes_in_class_methods GeneratedClassMethods

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

module Browser::Middleware::Context::UrlMethods
  # source://browser//lib/browser/middleware/context/url_methods.rb#7
  def default_url_options; end
end

class Browser::MiuiBrowser < ::Browser::Base
  # source://browser//lib/browser/miui_browser.rb#13
  def full_version; end

  # source://browser//lib/browser/miui_browser.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/miui_browser.rb#17
  def match?; end

  # source://browser//lib/browser/miui_browser.rb#9
  def name; end
end

class Browser::Nokia < ::Browser::Base
  # source://browser//lib/browser/nokia.rb#13
  def full_version; end

  # source://browser//lib/browser/nokia.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/nokia.rb#17
  def match?; end

  # source://browser//lib/browser/nokia.rb#9
  def name; end
end

class Browser::Opera < ::Browser::Base
  # source://browser//lib/browser/opera.rb#13
  def full_version; end

  # source://browser//lib/browser/opera.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/opera.rb#17
  def match?; end

  # source://browser//lib/browser/opera.rb#9
  def name; end
end

class Browser::Otter < ::Browser::Base
  # source://browser//lib/browser/otter.rb#13
  def full_version; end

  # source://browser//lib/browser/otter.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/otter.rb#17
  def match?; end

  # source://browser//lib/browser/otter.rb#9
  def name; end
end

class Browser::PhantomJS < ::Browser::Base
  # source://browser//lib/browser/phantom_js.rb#13
  def full_version; end

  # source://browser//lib/browser/phantom_js.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/phantom_js.rb#17
  def match?; end

  # source://browser//lib/browser/phantom_js.rb#9
  def name; end
end

class Browser::Platform
  include ::Browser::DetectVersion

  # @return [Platform] a new instance of Platform
  #
  # source://browser//lib/browser/platform.rb#44
  def initialize(ua); end

  # source://browser//lib/browser/platform.rb#122
  def ==(other); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#54
  def adobe_air?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#62
  def android?(expected_version = T.unsafe(nil)); end

  # Detect if in an Android app webview (Lollipop and newer)
  # https://developer.chrome.com/multidevice/user-agent#webview_user_agent
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#138
  def android_app?; end

  # Detect if in an Android app webview (Lollipop and newer)
  # https://developer.chrome.com/multidevice/user-agent#webview_user_agent
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#138
  def android_webview?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#94
  def blackberry?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#58
  def chrome_os?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#82
  def firefox_os?; end

  # source://browser//lib/browser/platform.rb#106
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#90
  def ios?(expected_version = T.unsafe(nil)); end

  # Detect if running on iOS app webview.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#127
  def ios_app?; end

  # Detect if is iOS webview.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#132
  def ios_webview?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#86
  def kai_os?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#70
  def linux?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#74
  def mac?(expected_version = T.unsafe(nil)); end

  # source://browser//lib/browser/platform.rb#114
  def name; end

  # source://browser//lib/browser/platform.rb#118
  def to_s; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#66
  def unknown?; end

  # source://browser//lib/browser/platform.rb#110
  def version; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#164
  def windows10?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#152
  def windows7?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#156
  def windows8?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#160
  def windows8_1?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#78
  def windows?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#102
  def windows_mobile?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#98
  def windows_phone?(expected_version = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#168
  def windows_rt?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#185
  def windows_touchscreen_desktop?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#148
  def windows_vista?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#177
  def windows_wow64?; end

  # Detect if current platform is Windows in 64-bit architecture.
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#173
  def windows_x64?; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#181
  def windows_x64_inclusive?; end

  # http://msdn.microsoft.com/fr-FR/library/ms537503.aspx#PltToken
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/platform.rb#144
  def windows_xp?; end

  private

  # source://browser//lib/browser/platform.rb#48
  def subject; end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/platform.rb#22
  def ua; end

  class << self
    # Hold the list of platform matchers.
    # Order is important.
    #
    # source://browser//lib/browser/platform.rb#26
    def matchers; end
  end
end

class Browser::Platform::AdobeAir < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/adobe_air.rb#18
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/adobe_air.rb#6
  def match?; end

  # source://browser//lib/browser/platform/adobe_air.rb#14
  def name; end

  # source://browser//lib/browser/platform/adobe_air.rb#10
  def version; end
end

class Browser::Platform::Android < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/android.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/android.rb#6
  def match?; end

  # source://browser//lib/browser/platform/android.rb#10
  def name; end

  # source://browser//lib/browser/platform/android.rb#18
  def version; end
end

class Browser::Platform::Base
  # @return [Base] a new instance of Base
  #
  # source://browser//lib/browser/platform/base.rb#8
  def initialize(ua, platform = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/base.rb#13
  def match?; end

  # Returns the value of attribute platform.
  #
  # source://browser//lib/browser/platform/base.rb#6
  def platform; end

  # Returns the value of attribute ua.
  #
  # source://browser//lib/browser/platform/base.rb#6
  def ua; end
end

class Browser::Platform::BlackBerry < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/blackberry.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/blackberry.rb#6
  def match?; end

  # source://browser//lib/browser/platform/blackberry.rb#10
  def name; end

  # source://browser//lib/browser/platform/blackberry.rb#18
  def version; end
end

class Browser::Platform::ChromeOS < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/chrome_os.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/chrome_os.rb#6
  def match?; end

  # source://browser//lib/browser/platform/chrome_os.rb#10
  def name; end

  # source://browser//lib/browser/platform/chrome_os.rb#18
  def version; end
end

class Browser::Platform::FirefoxOS < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/firefox_os.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/firefox_os.rb#18
  def match?; end

  # source://browser//lib/browser/platform/firefox_os.rb#10
  def name; end

  # source://browser//lib/browser/platform/firefox_os.rb#6
  def version; end
end

class Browser::Platform::IOS < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/ios.rb#38
  def device; end

  # source://browser//lib/browser/platform/ios.rb#30
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/ios.rb#34
  def match?; end

  # source://browser//lib/browser/platform/ios.rb#26
  def name; end

  # source://browser//lib/browser/platform/ios.rb#10
  def version; end
end

# source://browser//lib/browser/platform/ios.rb#6
Browser::Platform::IOS::MATCHER = T.let(T.unsafe(nil), Regexp)

# source://browser//lib/browser/platform/ios.rb#7
Browser::Platform::IOS::VERSION_MATCHER = T.let(T.unsafe(nil), Regexp)

class Browser::Platform::KaiOS < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/kai_os.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/kai_os.rb#18
  def match?; end

  # source://browser//lib/browser/platform/kai_os.rb#10
  def name; end

  # source://browser//lib/browser/platform/kai_os.rb#6
  def version; end
end

class Browser::Platform::Linux < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/linux.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/linux.rb#18
  def match?; end

  # source://browser//lib/browser/platform/linux.rb#10
  def name; end

  # source://browser//lib/browser/platform/linux.rb#6
  def version; end
end

class Browser::Platform::Mac < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/mac.rb#16
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/mac.rb#20
  def match?; end

  # source://browser//lib/browser/platform/mac.rb#10
  def name; end

  # source://browser//lib/browser/platform/mac.rb#6
  def version; end
end

class Browser::Platform::Unknown < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/unknown.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/unknown.rb#18
  def match?; end

  # source://browser//lib/browser/platform/unknown.rb#10
  def name; end

  # source://browser//lib/browser/platform/unknown.rb#6
  def version; end
end

class Browser::Platform::Windows < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/windows.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/windows.rb#18
  def match?; end

  # source://browser//lib/browser/platform/windows.rb#10
  def name; end

  # source://browser//lib/browser/platform/windows.rb#6
  def version; end
end

class Browser::Platform::WindowsMobile < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/windows_mobile.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/windows_mobile.rb#18
  def match?; end

  # source://browser//lib/browser/platform/windows_mobile.rb#10
  def name; end

  # source://browser//lib/browser/platform/windows_mobile.rb#6
  def version; end
end

class Browser::Platform::WindowsPhone < ::Browser::Platform::Base
  # source://browser//lib/browser/platform/windows_phone.rb#14
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/platform/windows_phone.rb#18
  def match?; end

  # source://browser//lib/browser/platform/windows_phone.rb#10
  def name; end

  # source://browser//lib/browser/platform/windows_phone.rb#6
  def version; end
end

class Browser::QQ < ::Browser::Base
  # source://browser//lib/browser/qq.rb#13
  def full_version; end

  # source://browser//lib/browser/qq.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/qq.rb#21
  def match?; end

  # source://browser//lib/browser/qq.rb#9
  def name; end
end

class Browser::Railtie < ::Rails::Railtie; end

class Browser::Safari < ::Browser::Base
  # source://browser//lib/browser/safari.rb#13
  def full_version; end

  # source://browser//lib/browser/safari.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/safari.rb#20
  def match?; end

  # source://browser//lib/browser/safari.rb#9
  def name; end
end

class Browser::SamsungBrowser < ::Browser::Chrome
  # source://browser//lib/browser/samsung_browser.rb#13
  def full_version; end

  # source://browser//lib/browser/samsung_browser.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/samsung_browser.rb#17
  def match?; end

  # source://browser//lib/browser/samsung_browser.rb#9
  def name; end
end

class Browser::Snapchat < ::Browser::Base
  # source://browser//lib/browser/snapchat.rb#13
  def full_version; end

  # source://browser//lib/browser/snapchat.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/snapchat.rb#17
  def match?; end

  # source://browser//lib/browser/snapchat.rb#9
  def name; end
end

class Browser::SougouBrowser < ::Browser::Base
  # We can't get the real version on desktop device from the ua string
  #
  # source://browser//lib/browser/sougou_browser.rb#14
  def full_version; end

  # source://browser//lib/browser/sougou_browser.rb#5
  def id; end

  # SogouMobileBrowser for mobile device
  # SE for desktop device
  #
  # @return [Boolean]
  #
  # source://browser//lib/browser/sougou_browser.rb#20
  def match?; end

  # source://browser//lib/browser/sougou_browser.rb#9
  def name; end
end

class Browser::Sputnik < ::Browser::Base
  # source://browser//lib/browser/sputnik.rb#13
  def full_version; end

  # source://browser//lib/browser/sputnik.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/sputnik.rb#17
  def match?; end

  # source://browser//lib/browser/sputnik.rb#9
  def name; end
end

class Browser::UCBrowser < ::Browser::Base
  # source://browser//lib/browser/uc_browser.rb#13
  def full_version; end

  # source://browser//lib/browser/uc_browser.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/uc_browser.rb#17
  def match?; end

  # source://browser//lib/browser/uc_browser.rb#9
  def name; end
end

class Browser::Unknown < ::Browser::Base
  # source://browser//lib/browser/unknown.rb#18
  def full_version; end

  # source://browser//lib/browser/unknown.rb#10
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/unknown.rb#24
  def match?; end

  # source://browser//lib/browser/unknown.rb#14
  def name; end

  private

  # source://browser//lib/browser/unknown.rb#28
  def infer_name; end
end

# source://browser//lib/browser/unknown.rb#5
Browser::Unknown::NAMES = T.let(T.unsafe(nil), Hash)

# source://browser//lib/browser/version.rb#4
Browser::VERSION = T.let(T.unsafe(nil), String)

class Browser::Weibo < ::Browser::Base
  # source://browser//lib/browser/weibo.rb#13
  def full_version; end

  # source://browser//lib/browser/weibo.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/weibo.rb#17
  def match?; end

  # source://browser//lib/browser/weibo.rb#9
  def name; end
end

class Browser::Yandex < ::Browser::Base
  # source://browser//lib/browser/yandex.rb#13
  def full_version; end

  # source://browser//lib/browser/yandex.rb#5
  def id; end

  # @return [Boolean]
  #
  # source://browser//lib/browser/yandex.rb#17
  def match?; end

  # source://browser//lib/browser/yandex.rb#9
  def name; end
end
