# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `aws-sdk-s3` gem.
# Please instead update this file by running `bin/tapioca gem aws-sdk-s3`.

class Aws::EmptyStructure < ::Struct
  include ::Aws::Structure
end

# This module provides support for Amazon Simple Storage Service. This module is available in the
# `aws-sdk-s3` gem.
#
# # Client
#
# The {Client} class provides one method for each API operation. Operation
# methods each accept a hash of request parameters and return a response
# structure.
#
#     s3 = Aws::S3::Client.new
#     resp = s3.abort_multipart_upload(params)
#
# See {Client} for more information.
#
# # Errors
#
# Errors returned from Amazon Simple Storage Service are defined in the
# {Errors} module and all extend {Errors::ServiceError}.
#
#     begin
#       # do stuff
#     rescue Aws::S3::Errors::ServiceError
#       # rescues all Amazon Simple Storage Service API errors
#     end
#
# See {Errors} for more information.
module Aws::S3; end

# source://aws-sdk-s3//lib/aws-sdk-s3/encryption.rb#20
Aws::S3::AES_GCM_TAG_LEN_BYTES = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#78
Aws::S3::BUCKET_REGIONS = T.let(T.unsafe(nil), Aws::S3::BucketRegionCache)

class Aws::S3::Bucket
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [Bucket] a new instance of Bucket
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#22
  def initialize(*args); end

  # @return [BucketAcl]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#678
  def acl; end

  # Deletes all objects and versioned objects from this bucket
  #
  # @example
  #
  #   bucket.clear!
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/bucket.rb#15
  def clear!; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#47
  def client; end

  # @return [BucketCors]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#686
  def cors; end

  # @example Request syntax with placeholder values
  #
  #   bucket.create({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read
  #   create_bucket_configuration: {
  #   location_constraint: "af-south-1", # accepts af-south-1, ap-east-1, ap-northeast-1, ap-northeast-2, ap-northeast-3, ap-south-1, ap-southeast-1, ap-southeast-2, ap-southeast-3, ca-central-1, cn-north-1, cn-northwest-1, EU, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2, eu-west-3, me-south-1, sa-east-1, us-east-2, us-gov-east-1, us-gov-west-1, us-west-1, us-west-2
  #   },
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   object_lock_enabled_for_bucket: false,
  #   object_ownership: "BucketOwnerPreferred", # accepts BucketOwnerPreferred, ObjectWriter, BucketOwnerEnforced
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::CreateBucketOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#276
  def create(options = T.unsafe(nil)); end

  # Date the bucket was created. This date can change when making changes
  # to your bucket, such as editing its bucket policy.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#40
  def creation_date; end

  # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
  # @return [Types::Bucket] Returns the data for this {Bucket}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#62
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#70
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#293
  def delete(options = T.unsafe(nil)); end

  # Deletes all objects and versioned objects from this bucket and
  # then deletes the bucket.
  #
  # @example
  #
  #   bucket.delete!
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/bucket.rb#35
  def delete!(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   bucket.delete_objects({
  #   delete: { # required
  #   objects: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   },
  #   ],
  #   quiet: false,
  #   },
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::DeleteObjectsOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#362
  def delete_objects(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#971
  def deprecated_identifiers; end

  # @param options [Hash] ({})
  # @return [Boolean] Returns `true` if the Bucket exists.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#77
  def exists?(options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # @return [BucketLifecycle]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#694
  def lifecycle; end

  # @return [BucketLifecycleConfiguration]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#702
  def lifecycle_configuration; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/bucket.rb#136
  def load; end

  # @return [BucketLogging]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#710
  def logging; end

  # @example Request syntax with placeholder values
  #
  #   multipart_uploads = bucket.multipart_uploads({
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   key_marker: "KeyMarker",
  #   prefix: "Prefix",
  #   upload_id_marker: "UploadIdMarker",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [MultipartUpload::Collection]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#773
  def multipart_uploads(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#33
  def name; end

  # @return [BucketNotification]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#795
  def notification; end

  # @param key [String]
  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#804
  def object(key); end

  # @example Request syntax with placeholder values
  #
  #   object_versions = bucket.object_versions({
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   key_marker: "KeyMarker",
  #   prefix: "Prefix",
  #   version_id_marker: "VersionIdMarker",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [ObjectVersion::Collection]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#853
  def object_versions(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   objects = bucket.objects({
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   prefix: "Prefix",
  #   fetch_owner: false,
  #   start_after: "StartAfter",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [ObjectSummary::Collection]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#909
  def objects(options = T.unsafe(nil)); end

  # @return [BucketPolicy]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#930
  def policy; end

  # Creates a {PresignedPost} that makes it easy to upload a file from
  # a web browser direct to Amazon S3 using an HTML post form with
  # a file field.
  #
  # See the {PresignedPost} documentation for more information.
  #
  # @note You must specify `:key` or `:key_starts_with`. All other options
  #   are optional.
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @return [PresignedPost]
  # @see PresignedPost
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/bucket.rb#126
  def presigned_post(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   object = bucket.put_object({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   body: source_file,
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   content_type: "ContentType",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   key: "ObjectKey", # required
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#665
  def put_object(options = T.unsafe(nil)); end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#53
  def reload; end

  # @return [BucketRequestPayment]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#938
  def request_payment; end

  # @return [BucketTagging]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#946
  def tagging; end

  # Returns a public URL for this bucket.
  #
  # It will also work when provided an Access Point ARN.
  #
  # You can pass `virtual_host: true` to use the bucket name as the
  # host name.
  #
  #     bucket = s3.bucket('my-bucket.com')
  #     bucket.url(virtual_host: true)
  #     #=> "http://my-bucket.com"
  #
  # @example
  #
  #   bucket = s3.bucket('bucket-name')
  #   bucket.url
  #   #=> "https://bucket-name.s3.amazonaws.com"
  # @example
  #
  #   bucket = s3.bucket(
  #   'arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint'
  #   )
  #   bucket.url
  #   #=> "https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [String] the URL for this bucket.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/bucket.rb#88
  def url(options = T.unsafe(nil)); end

  # @return [BucketVersioning]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#954
  def versioning; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#202
  def wait_until(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#94
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#111
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  # @return [BucketWebsite]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#962
  def website; end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#978
  def extract_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#999
  def separate_params_and_options(options); end

  # @yield [waiter.waiter]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket.rb#989
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::Bucket::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketAcl
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketAcl] a new instance of BucketAcl
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#275
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#52
  def client; end

  # @return [Types::GetBucketAclOutput] Returns the data for this {BucketAcl}. Calls
  #   {Client#get_bucket_acl} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#72
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#80
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#284
  def deprecated_identifiers; end

  # A list of grants.
  #
  # @return [Array<Types::Grant>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#45
  def grants; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketAcl}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_acl.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#62
  def load; end

  # Container for the bucket owner's display name and ID.
  #
  # @return [Types::Owner]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#39
  def owner; end

  # @example Request syntax with placeholder values
  #
  #   bucket_acl.put({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read
  #   access_control_policy: {
  #   grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   owner: {
  #   display_name: "DisplayName",
  #   id: "ID",
  #   },
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#266
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketAcl}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_acl.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#62
  def reload; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#164
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_acl.rb#291
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketAcl::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketCors
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketCors] a new instance of BucketCors
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#264
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#47
  def client; end

  # A set of origins and methods (cross-origin access that you want to
  # allow). You can add up to 100 rules to the configuration.
  #
  # @return [Array<Types::CORSRule>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#40
  def cors_rules; end

  # @return [Types::GetBucketCorsOutput] Returns the data for this {BucketCors}. Calls
  #   {Client#get_bucket_cors} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#67
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#75
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_cors.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#189
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#273
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketCors}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_cors.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#57
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_cors.put({
  #   cors_configuration: { # required
  #   cors_rules: [ # required
  #   {
  #   id: "ID",
  #   allowed_headers: ["AllowedHeader"],
  #   allowed_methods: ["AllowedMethod"], # required
  #   allowed_origins: ["AllowedOrigin"], # required
  #   expose_headers: ["ExposeHeader"],
  #   max_age_seconds: 1,
  #   },
  #   ],
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#255
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketCors}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_cors.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#57
  def reload; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#159
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_cors.rb#280
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketCors::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLifecycle
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketLifecycle] a new instance of BucketLifecycle
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#267
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#46
  def client; end

  # @return [Types::GetBucketLifecycleOutput] Returns the data for this {BucketLifecycle}. Calls
  #   {Client#get_bucket_lifecycle} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#66
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#74
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_lifecycle.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#276
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketLifecycle}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_lifecycle.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#56
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_lifecycle.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   lifecycle_configuration: {
  #   rules: [ # required
  #   {
  #   expiration: {
  #   date: Time.now,
  #   days: 1,
  #   expired_object_delete_marker: false,
  #   },
  #   id: "ID",
  #   prefix: "Prefix", # required
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   transition: {
  #   date: Time.now,
  #   days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   },
  #   noncurrent_version_transition: {
  #   noncurrent_days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   newer_noncurrent_versions: 1,
  #   },
  #   noncurrent_version_expiration: {
  #   noncurrent_days: 1,
  #   newer_noncurrent_versions: 1,
  #   },
  #   abort_incomplete_multipart_upload: {
  #   days_after_initiation: 1,
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#258
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketLifecycle}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_lifecycle.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#56
  def reload; end

  # Container for a lifecycle rule.
  #
  # @return [Array<Types::Rule>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#39
  def rules; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle.rb#283
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLifecycle::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLifecycleConfiguration
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketLifecycleConfiguration] a new instance of BucketLifecycleConfiguration
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#287
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#46
  def client; end

  # @return [Types::GetBucketLifecycleConfigurationOutput] Returns the data for this {BucketLifecycleConfiguration}. Calls
  #   {Client#get_bucket_lifecycle_configuration} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#66
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#74
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_lifecycle_configuration.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#296
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketLifecycleConfiguration}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_lifecycle_configuration.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#56
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_lifecycle_configuration.put({
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   lifecycle_configuration: {
  #   rules: [ # required
  #   {
  #   expiration: {
  #   date: Time.now,
  #   days: 1,
  #   expired_object_delete_marker: false,
  #   },
  #   id: "ID",
  #   prefix: "Prefix",
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   object_size_greater_than: 1,
  #   object_size_less_than: 1,
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   object_size_greater_than: 1,
  #   object_size_less_than: 1,
  #   },
  #   },
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   transitions: [
  #   {
  #   date: Time.now,
  #   days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   },
  #   ],
  #   noncurrent_version_transitions: [
  #   {
  #   noncurrent_days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   newer_noncurrent_versions: 1,
  #   },
  #   ],
  #   noncurrent_version_expiration: {
  #   noncurrent_days: 1,
  #   newer_noncurrent_versions: 1,
  #   },
  #   abort_incomplete_multipart_upload: {
  #   days_after_initiation: 1,
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#278
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketLifecycleConfiguration}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_lifecycle_configuration.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#56
  def reload; end

  # Container for a lifecycle rule.
  #
  # @return [Array<Types::LifecycleRule>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#39
  def rules; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#303
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLifecycleConfiguration::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLogging
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketLogging] a new instance of BucketLogging
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#246
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#52
  def client; end

  # @return [Types::GetBucketLoggingOutput] Returns the data for this {BucketLogging}. Calls
  #   {Client#get_bucket_logging} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#72
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#80
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#255
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketLogging}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_logging.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#62
  def load; end

  # Describes where logs are stored and the prefix that Amazon S3 assigns
  # to all log object keys for a bucket. For more information, see [PUT
  # Bucket logging][1] in the *Amazon S3 API Reference*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html
  #
  # @return [Types::LoggingEnabled]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#45
  def logging_enabled; end

  # @example Request syntax with placeholder values
  #
  #   bucket_logging.put({
  #   bucket_logging_status: { # required
  #   logging_enabled: {
  #   target_bucket: "TargetBucket", # required
  #   target_grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, READ, WRITE
  #   },
  #   ],
  #   target_prefix: "TargetPrefix", # required
  #   },
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#237
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketLogging}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_logging.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#62
  def reload; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#164
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_logging.rb#262
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLogging::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketNotification
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketNotification] a new instance of BucketNotification
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#281
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#67
  def client; end

  # @return [Types::NotificationConfiguration] Returns the data for this {BucketNotification}. Calls
  #   {Client#get_bucket_notification_configuration} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#87
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#95
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#290
  def deprecated_identifiers; end

  # Enables delivery of events to Amazon EventBridge.
  #
  # @return [Types::EventBridgeConfiguration]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#60
  def event_bridge_configuration; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Describes the Lambda functions to invoke and the events for which to
  # invoke them.
  #
  # @return [Array<Types::LambdaFunctionConfiguration>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#54
  def lambda_function_configurations; end

  # Loads, or reloads {#data} for the current {BucketNotification}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_notification.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#77
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_notification.put({
  #   notification_configuration: { # required
  #   topic_configurations: [
  #   {
  #   id: "NotificationId",
  #   topic_arn: "TopicArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   queue_configurations: [
  #   {
  #   id: "NotificationId",
  #   queue_arn: "QueueArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   lambda_function_configurations: [
  #   {
  #   id: "NotificationId",
  #   lambda_function_arn: "LambdaFunctionArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   event_bridge_configuration: {
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   skip_destination_validation: false,
  #   })
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#272
  def put(options = T.unsafe(nil)); end

  # The Amazon Simple Queue Service queues to publish messages to and the
  # events for which to publish messages.
  #
  # @return [Array<Types::QueueConfiguration>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#47
  def queue_configurations; end

  # Loads, or reloads {#data} for the current {BucketNotification}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_notification.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#77
  def reload; end

  # The topic to which notifications are sent and the events for which
  # notifications are generated.
  #
  # @return [Array<Types::TopicConfiguration>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#40
  def topic_configurations; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#179
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_notification.rb#297
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketNotification::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketPolicy
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketPolicy] a new instance of BucketPolicy
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#244
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#46
  def client; end

  # @return [Types::GetBucketPolicyOutput] Returns the data for this {BucketPolicy}. Calls
  #   {Client#get_bucket_policy} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#66
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#74
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_policy.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#253
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketPolicy}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_policy.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#56
  def load; end

  # The bucket policy as a JSON document.
  #
  # @return [IO]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#39
  def policy; end

  # @example Request syntax with placeholder values
  #
  #   bucket_policy.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   confirm_remove_self_bucket_access: false,
  #   policy: "Policy", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#235
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketPolicy}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_policy.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#56
  def reload; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_policy.rb#260
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketPolicy::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketRegionCache
  # @return [BucketRegionCache] a new instance of BucketRegionCache
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#9
  def initialize; end

  # @api private
  # @param bucket_name [String]
  # @return [String, nil] Returns the cached region for the named bucket.
  #   Returns `nil` if the bucket is not in the cache.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#45
  def [](bucket_name); end

  # Caches a bucket's region. Calling this method will trigger each
  # of the {#bucket_added} listener callbacks.
  #
  # @api private
  # @param bucket_name [String]
  # @param region_name [String]
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#55
  def []=(bucket_name, region_name); end

  # Registers a block as a callback. This listener is called when a
  # new bucket/region pair is added to the cache.
  #
  #     S3::BUCKET_REGIONS.bucket_added do |bucket_name, region_name|
  #       # ...
  #     end
  #
  # This happens when a request is made against the classic endpoint,
  # "s3.amazonaws.com" and an error is returned requiring the request
  # to be resent with Signature Version 4. At this point, multiple
  # requests are made to discover the bucket region so that a v4
  # signature can be generated.
  #
  # An application can register listeners here to avoid these extra
  # requests in the future. By constructing an {S3::Client} with
  # the proper region, a proper signature can be generated and redirects
  # avoided.
  #
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#33
  def bucket_added(&block); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#63
  def clear; end

  # @return [Hash] Returns a hash of cached bucket names and region names.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#68
  def to_h; end

  # @return [Hash] Returns a hash of cached bucket names and region names.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_region_cache.rb#68
  def to_hash; end
end

class Aws::S3::BucketRequestPayment
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketRequestPayment] a new instance of BucketRequestPayment
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#231
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#46
  def client; end

  # @return [Types::GetBucketRequestPaymentOutput] Returns the data for this {BucketRequestPayment}. Calls
  #   {Client#get_bucket_request_payment} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#66
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#240
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketRequestPayment}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_request_payment.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#56
  def load; end

  # Specifies who pays for the download and request fees.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#39
  def payer; end

  # @example Request syntax with placeholder values
  #
  #   bucket_request_payment.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   request_payment_configuration: { # required
  #   payer: "Requester", # required, accepts Requester, BucketOwner
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#222
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketRequestPayment}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_request_payment.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#56
  def reload; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_request_payment.rb#247
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketRequestPayment::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketTagging
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketTagging] a new instance of BucketTagging
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#253
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#46
  def client; end

  # @return [Types::GetBucketTaggingOutput] Returns the data for this {BucketTagging}. Calls
  #   {Client#get_bucket_tagging} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#66
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#74
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_tagging.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#262
  def deprecated_identifiers; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketTagging}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_tagging.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#56
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_tagging.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   tagging: { # required
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#244
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketTagging}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_tagging.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#56
  def reload; end

  # Contains the tag set.
  #
  # @return [Array<Types::Tag>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#39
  def tag_set; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_tagging.rb#269
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketTagging::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketVersioning
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketVersioning] a new instance of BucketVersioning
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#358
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#55
  def client; end

  # @return [Types::GetBucketVersioningOutput] Returns the data for this {BucketVersioning}. Calls
  #   {Client#get_bucket_versioning} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#75
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#83
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#367
  def deprecated_identifiers; end

  # @example Request syntax with placeholder values
  #
  #   bucket_versioning.enable({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   mfa: "MFA",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#231
  def enable(options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {BucketVersioning}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_versioning.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#65
  def load; end

  # Specifies whether MFA delete is enabled in the bucket versioning
  # configuration. This element is only returned if the bucket has been
  # configured with MFA delete. If the bucket has never been so
  # configured, this element is not returned.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#48
  def mfa_delete; end

  # @example Request syntax with placeholder values
  #
  #   bucket_versioning.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   mfa: "MFA",
  #   versioning_configuration: { # required
  #   mfa_delete: "Enabled", # accepts Enabled, Disabled
  #   status: "Enabled", # accepts Enabled, Suspended
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#293
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {BucketVersioning}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_versioning.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#65
  def reload; end

  # The versioning state of the bucket.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#39
  def status; end

  # @example Request syntax with placeholder values
  #
  #   bucket_versioning.suspend({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   mfa: "MFA",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#344
  def suspend(options = T.unsafe(nil)); end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#167
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_versioning.rb#374
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketVersioning::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketWebsite
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [BucketWebsite] a new instance of BucketWebsite
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#22
  def initialize(*args); end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#294
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#33
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#68
  def client; end

  # @return [Types::GetBucketWebsiteOutput] Returns the data for this {BucketWebsite}. Calls
  #   {Client#get_bucket_website} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#88
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#96
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   bucket_website.delete({
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#210
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#303
  def deprecated_identifiers; end

  # The object key name of the website error document to use for 4XX class
  # errors.
  #
  # @return [Types::ErrorDocument]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#54
  def error_document; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # The name of the index document for the website (for example
  # `index.html`).
  #
  # @return [Types::IndexDocument]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#47
  def index_document; end

  # Loads, or reloads {#data} for the current {BucketWebsite}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_website.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#78
  def load; end

  # @example Request syntax with placeholder values
  #
  #   bucket_website.put({
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   website_configuration: { # required
  #   error_document: {
  #   key: "ObjectKey", # required
  #   },
  #   index_document: {
  #   suffix: "Suffix", # required
  #   },
  #   redirect_all_requests_to: {
  #   host_name: "HostName", # required
  #   protocol: "http", # accepts http, https
  #   },
  #   routing_rules: [
  #   {
  #   condition: {
  #   http_error_code_returned_equals: "HttpErrorCodeReturnedEquals",
  #   key_prefix_equals: "KeyPrefixEquals",
  #   },
  #   redirect: { # required
  #   host_name: "HostName",
  #   http_redirect_code: "HttpRedirectCode",
  #   protocol: "http", # accepts http, https
  #   replace_key_prefix_with: "ReplaceKeyPrefixWith",
  #   replace_key_with: "ReplaceKeyWith",
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [EmptyStructure]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#285
  def put(options = T.unsafe(nil)); end

  # Specifies the redirect behavior of all requests to a website endpoint
  # of an Amazon S3 bucket.
  #
  # @return [Types::RedirectAllRequestsTo]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#40
  def redirect_all_requests_to; end

  # Loads, or reloads {#data} for the current {BucketWebsite}.
  # Returns `self` making it possible to chain methods.
  #
  #     bucket_website.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#78
  def reload; end

  # Rules that define when a redirect is applied and the redirect
  # behavior.
  #
  # @return [Array<Types::RoutingRule>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#61
  def routing_rules; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#180
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/bucket_website.rb#310
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketWebsite::Collection < ::Aws::Resources::Collection; end

# An API client for S3.  To construct a client, you need to configure a `:region` and `:credentials`.
#
#     client = Aws::S3::Client.new(
#       region: region_name,
#       credentials: credentials,
#       # ...
#     )
#
# For details on configuring region and credentials see
# the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
#
# See {#initialize} for a full list of supported configuration options.
class Aws::S3::Client < ::Seahorse::Client::Base
  include ::Aws::ClientStubs

  # @overload initialize
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#451
  def initialize(*args); end

  # This action aborts a multipart upload. After a multipart upload is
  # aborted, no additional parts can be uploaded using that upload ID. The
  # storage consumed by any previously uploaded parts will be freed.
  # However, if any part uploads are currently in progress, those part
  # uploads might or might not succeed. As a result, it might be necessary
  # to abort a given multipart upload multiple times in order to
  # completely free all storage consumed by all parts.
  #
  # To verify that all parts have been removed, so you don't get charged
  # for the part storage, you should call the [ListParts][1] action and
  # ensure that the parts list is empty.
  #
  # For information about permissions required to use the multipart
  # upload, see [Multipart Upload and Permissions][2].
  #
  # The following operations are related to `AbortMultipartUpload`\:
  #
  # * [CreateMultipartUpload][3]
  #
  # * [UploadPart][4]
  #
  # * [CompleteMultipartUpload][5]
  #
  # * [ListParts][1]
  #
  # * [ListMultipartUploads][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # @example Example: To abort a multipart upload
  #
  #   # The following example aborts a multipart upload.
  #
  #   resp = client.abort_multipart_upload({
  #   bucket: "examplebucket",
  #   key: "bigobject",
  #   upload_id: "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CEg--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.abort_multipart_upload({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   upload_id: "MultipartUploadId", # required
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload abort_multipart_upload
  # @param params [Hash] ({})
  # @return [Types::AbortMultipartUploadOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::AbortMultipartUploadOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#577
  def abort_multipart_upload(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @param params [{}]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15348
  def build_request(operation_name, params = T.unsafe(nil)); end

  # Completes a multipart upload by assembling previously uploaded parts.
  #
  # You first initiate the multipart upload and then upload all parts
  # using the [UploadPart][1] operation. After successfully uploading all
  # relevant parts of an upload, you call this action to complete the
  # upload. Upon receiving this request, Amazon S3 concatenates all the
  # parts in ascending order by part number to create a new object. In the
  # Complete Multipart Upload request, you must provide the parts list.
  # You must ensure that the parts list is complete. This action
  # concatenates the parts that you provide in the list. For each part in
  # the list, you must provide the part number and the `ETag` value,
  # returned after that part was uploaded.
  #
  # Processing of a Complete Multipart Upload request could take several
  # minutes to complete. After Amazon S3 begins processing the request, it
  # sends an HTTP response header that specifies a 200 OK response. While
  # processing is in progress, Amazon S3 periodically sends white space
  # characters to keep the connection from timing out. Because a request
  # could fail after the initial 200 OK response has been sent, it is
  # important that you check the response body to determine whether the
  # request succeeded.
  #
  # Note that if `CompleteMultipartUpload` fails, applications should be
  # prepared to retry the failed requests. For more information, see
  # [Amazon S3 Error Best Practices][2].
  #
  # You cannot use `Content-Type: application/x-www-form-urlencoded` with
  # Complete Multipart Upload requests. Also, if you do not provide a
  # `Content-Type` header, `CompleteMultipartUpload` returns a 200 OK
  # response.
  #
  # For more information about multipart uploads, see [Uploading Objects
  # Using Multipart Upload][3].
  #
  # For information about permissions required to use the multipart upload
  # API, see [Multipart Upload and Permissions][4].
  #
  # `CompleteMultipartUpload` has the following special errors:
  #
  # * Error code: `EntityTooSmall`
  #
  #   * Description: Your proposed upload is smaller than the minimum
  #     allowed object size. Each part must be at least 5 MB in size,
  #     except the last part.
  #
  #   * 400 Bad Request
  #
  # * Error code: `InvalidPart`
  #
  #   * Description: One or more of the specified parts could not be
  #     found. The part might not have been uploaded, or the specified
  #     entity tag might not have matched the part's entity tag.
  #
  #   * 400 Bad Request
  #
  # * Error code: `InvalidPartOrder`
  #
  #   * Description: The list of parts was not in ascending order. The
  #     parts list must be specified in order by part number.
  #
  #   * 400 Bad Request
  #
  # * Error code: `NoSuchUpload`
  #
  #   * Description: The specified multipart upload does not exist. The
  #     upload ID might be invalid, or the multipart upload might have
  #     been aborted or completed.
  #
  #   * 404 Not Found
  #
  # The following operations are related to `CompleteMultipartUpload`\:
  #
  # * [CreateMultipartUpload][5]
  #
  # * [UploadPart][1]
  #
  # * [AbortMultipartUpload][6]
  #
  # * [ListParts][7]
  #
  # * [ListMultipartUploads][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # @example Example: To complete multipart upload
  #
  #   # The following example completes a multipart upload.
  #
  #   resp = client.complete_multipart_upload({
  #   bucket: "examplebucket",
  #   key: "bigobject",
  #   multipart_upload: {
  #   parts: [
  #   {
  #   etag: "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
  #   part_number: 1,
  #   },
  #   {
  #   etag: "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
  #   part_number: 2,
  #   },
  #   ],
  #   },
  #   upload_id: "7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CEg--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   bucket: "acexamplebucket",
  #   etag: "\"4d9031c7644d8081c2829f4ea23c55f7-2\"",
  #   key: "bigobject",
  #   location: "https://examplebucket.s3.<Region>.amazonaws.com/bigobject",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.complete_multipart_upload({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   multipart_upload: {
  #   parts: [
  #   {
  #   etag: "ETag",
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   part_number: 1,
  #   },
  #   ],
  #   },
  #   upload_id: "MultipartUploadId", # required
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   })
  # @example Response structure
  #
  #   resp.location #=> String
  #   resp.bucket #=> String
  #   resp.key #=> String
  #   resp.expiration #=> String
  #   resp.etag #=> String
  #   resp.checksum_crc32 #=> String
  #   resp.checksum_crc32c #=> String
  #   resp.checksum_sha1 #=> String
  #   resp.checksum_sha256 #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.version_id #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload complete_multipart_upload
  # @param params [Hash] ({})
  # @return [Types::CompleteMultipartUploadOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CompleteMultipartUploadOutput#location #location} => String
  #   * {Types::CompleteMultipartUploadOutput#bucket #bucket} => String
  #   * {Types::CompleteMultipartUploadOutput#key #key} => String
  #   * {Types::CompleteMultipartUploadOutput#expiration #expiration} => String
  #   * {Types::CompleteMultipartUploadOutput#etag #etag} => String
  #   * {Types::CompleteMultipartUploadOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::CompleteMultipartUploadOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::CompleteMultipartUploadOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::CompleteMultipartUploadOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::CompleteMultipartUploadOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::CompleteMultipartUploadOutput#version_id #version_id} => String
  #   * {Types::CompleteMultipartUploadOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::CompleteMultipartUploadOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::CompleteMultipartUploadOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#897
  def complete_multipart_upload(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a copy of an object that is already stored in Amazon S3.
  #
  # <note markdown="1"> You can store individual objects of up to 5 TB in Amazon S3. You
  # create a copy of your object up to 5 GB in size in a single atomic
  # action using this API. However, to copy an object greater than 5 GB,
  # you must use the multipart upload Upload Part - Copy (UploadPartCopy)
  # API. For more information, see [Copy Object Using the REST Multipart
  # Upload API][1].
  #
  #  </note>
  #
  # All copy requests must be authenticated. Additionally, you must have
  # *read* access to the source object and *write* access to the
  # destination bucket. For more information, see [REST
  # Authentication][2]. Both the Region that you want to copy the object
  # from and the Region that you want to copy the object to must be
  # enabled for your account.
  #
  # A copy request might return an error when Amazon S3 receives the copy
  # request or while Amazon S3 is copying the files. If the error occurs
  # before the copy action starts, you receive a standard Amazon S3 error.
  # If the error occurs during the copy operation, the error response is
  # embedded in the `200 OK` response. This means that a `200 OK` response
  # can contain either a success or an error. Design your application to
  # parse the contents of the response and handle it appropriately.
  #
  # If the copy is successful, you receive a response with information
  # about the copied object.
  #
  # <note markdown="1"> If the request is an HTTP 1.1 request, the response is chunk encoded.
  # If it were not, it would not contain the content-length, and you would
  # need to read the entire body.
  #
  #  </note>
  #
  # The copy request charge is based on the storage class and Region that
  # you specify for the destination object. For pricing information, see
  # [Amazon S3 pricing][3].
  #
  # Amazon S3 transfer acceleration does not support cross-Region copies.
  # If you request a cross-Region copy using a transfer acceleration
  # endpoint, you get a 400 `Bad Request` error. For more information, see
  # [Transfer Acceleration][4].
  #
  # **Metadata**
  #
  # When copying an object, you can preserve all metadata (default) or
  # specify new metadata. However, the ACL is not preserved and is set to
  # private for the user making the request. To override the default ACL
  # setting, specify a new ACL when generating a copy request. For more
  # information, see [Using ACLs][5].
  #
  # To specify whether you want the object metadata copied from the source
  # object or replaced with metadata provided in the request, you can
  # optionally add the `x-amz-metadata-directive` header. When you grant
  # permissions, you can use the `s3:x-amz-metadata-directive` condition
  # key to enforce certain metadata behavior when objects are uploaded.
  # For more information, see [Specifying Conditions in a Policy][6] in
  # the *Amazon S3 User Guide*. For a complete list of Amazon S3-specific
  # condition keys, see [Actions, Resources, and Condition Keys for Amazon
  # S3][7].
  #
  # **x-amz-copy-source-if Headers**
  #
  # To only copy an object under certain conditions, such as whether the
  # `Etag` matches or whether the object was modified before or after a
  # specified date, use the following request parameters:
  #
  # * `x-amz-copy-source-if-match`
  #
  # * `x-amz-copy-source-if-none-match`
  #
  # * `x-amz-copy-source-if-unmodified-since`
  #
  # * `x-amz-copy-source-if-modified-since`
  #
  # If both the `x-amz-copy-source-if-match` and
  # `x-amz-copy-source-if-unmodified-since` headers are present in the
  # request and evaluate as follows, Amazon S3 returns `200 OK` and copies
  # the data:
  #
  # * `x-amz-copy-source-if-match` condition evaluates to true
  #
  # * `x-amz-copy-source-if-unmodified-since` condition evaluates to false
  #
  # If both the `x-amz-copy-source-if-none-match` and
  # `x-amz-copy-source-if-modified-since` headers are present in the
  # request and evaluate as follows, Amazon S3 returns the `412
  # Precondition Failed` response code:
  #
  # * `x-amz-copy-source-if-none-match` condition evaluates to false
  #
  # * `x-amz-copy-source-if-modified-since` condition evaluates to true
  #
  # <note markdown="1"> All headers with the `x-amz-` prefix, including `x-amz-copy-source`,
  # must be signed.
  #
  #  </note>
  #
  # **Server-side encryption**
  #
  # When you perform a CopyObject operation, you can optionally use the
  # appropriate encryption-related headers to encrypt the object using
  # server-side encryption with Amazon Web Services managed encryption
  # keys (SSE-S3 or SSE-KMS) or a customer-provided encryption key. With
  # server-side encryption, Amazon S3 encrypts your data as it writes it
  # to disks in its data centers and decrypts the data when you access it.
  # For more information about server-side encryption, see [Using
  # Server-Side Encryption][8].
  #
  # If a target object uses SSE-KMS, you can enable an S3 Bucket Key for
  # the object. For more information, see [Amazon S3 Bucket Keys][9] in
  # the *Amazon S3 User Guide*.
  #
  # **Access Control List (ACL)-Specific Request Headers**
  #
  # When copying an object, you can optionally use headers to grant
  # ACL-based permissions. By default, all objects are private. Only the
  # owner has full access control. When adding a new object, you can grant
  # permissions to individual Amazon Web Services accounts or to
  # predefined groups defined by Amazon S3. These permissions are then
  # added to the ACL on the object. For more information, see [Access
  # Control List (ACL) Overview][10] and [Managing ACLs Using the REST
  # API][11].
  #
  # If the bucket that you're copying objects to uses the bucket owner
  # enforced setting for S3 Object Ownership, ACLs are disabled and no
  # longer affect permissions. Buckets that use this setting only accept
  # PUT requests that don't specify an ACL or PUT requests that specify
  # bucket owner full control ACLs, such as the
  # `bucket-owner-full-control` canned ACL or an equivalent form of this
  # ACL expressed in the XML format.
  #
  # For more information, see [ Controlling ownership of objects and
  # disabling ACLs][12] in the *Amazon S3 User Guide*.
  #
  # <note markdown="1"> If your bucket uses the bucket owner enforced setting for Object
  # Ownership, all objects written to the bucket by any account will be
  # owned by the bucket owner.
  #
  #  </note>
  #
  # **Checksums**
  #
  # When copying an object, if it has a checksum, that checksum will be
  # copied to the new object by default. When you copy the object over,
  # you may optionally specify a different checksum algorithm to use with
  # the `x-amz-checksum-algorithm` header.
  #
  # **Storage Class Options**
  #
  # You can use the `CopyObject` action to change the storage class of an
  # object that is already stored in Amazon S3 using the `StorageClass`
  # parameter. For more information, see [Storage Classes][13] in the
  # *Amazon S3 User Guide*.
  #
  # **Versioning**
  #
  # By default, `x-amz-copy-source` identifies the current version of an
  # object to copy. If the current version is a delete marker, Amazon S3
  # behaves as if the object was deleted. To copy a different version, use
  # the `versionId` subresource.
  #
  # If you enable versioning on the target bucket, Amazon S3 generates a
  # unique version ID for the object being copied. This version ID is
  # different from the version ID of the source object. Amazon S3 returns
  # the version ID of the copied object in the `x-amz-version-id` response
  # header in the response.
  #
  # If you do not enable versioning or suspend it on the target bucket,
  # the version ID that Amazon S3 generates is always null.
  #
  # If the source object's storage class is GLACIER, you must restore a
  # copy of this object before you can use it as a source object for the
  # copy operation. For more information, see [RestoreObject][14].
  #
  # The following operations are related to `CopyObject`\:
  #
  # * [PutObject][15]
  #
  # * [GetObject][16]
  #
  # For more information, see [Copying Objects][17].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html
  # [3]: http://aws.amazon.com/s3/pricing/
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html
  # [12]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [13]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html
  # [14]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html
  # [15]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [16]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [17]: https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html
  #
  # @example Example: To copy an object
  #
  #   # The following example copies an object from one bucket to another.
  #
  #   resp = client.copy_object({
  #   bucket: "destinationbucket",
  #   copy_source: "/sourcebucket/HappyFacejpg",
  #   key: "HappyFaceCopyjpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   copy_object_result: {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   last_modified: Time.parse("2016-12-15T17:38:53.000Z"),
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.copy_object({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   bucket: "BucketName", # required
  #   cache_control: "CacheControl",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   copy_source: "CopySource", # required
  #   copy_source_if_match: "CopySourceIfMatch",
  #   copy_source_if_modified_since: Time.now,
  #   copy_source_if_none_match: "CopySourceIfNoneMatch",
  #   copy_source_if_unmodified_since: Time.now,
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   key: "ObjectKey", # required
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   metadata_directive: "COPY", # accepts COPY, REPLACE
  #   tagging_directive: "COPY", # accepts COPY, REPLACE
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   copy_source_sse_customer_algorithm: "CopySourceSSECustomerAlgorithm",
  #   copy_source_sse_customer_key: "CopySourceSSECustomerKey",
  #   copy_source_sse_customer_key_md5: "CopySourceSSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   expected_source_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.copy_object_result.etag #=> String
  #   resp.copy_object_result.last_modified #=> Time
  #   resp.copy_object_result.checksum_crc32 #=> String
  #   resp.copy_object_result.checksum_crc32c #=> String
  #   resp.copy_object_result.checksum_sha1 #=> String
  #   resp.copy_object_result.checksum_sha256 #=> String
  #   resp.expiration #=> String
  #   resp.copy_source_version_id #=> String
  #   resp.version_id #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.ssekms_encryption_context #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload copy_object
  # @param params [Hash] ({})
  # @return [Types::CopyObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CopyObjectOutput#copy_object_result #copy_object_result} => Types::CopyObjectResult
  #   * {Types::CopyObjectOutput#expiration #expiration} => String
  #   * {Types::CopyObjectOutput#copy_source_version_id #copy_source_version_id} => String
  #   * {Types::CopyObjectOutput#version_id #version_id} => String
  #   * {Types::CopyObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::CopyObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::CopyObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::CopyObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::CopyObjectOutput#ssekms_encryption_context #ssekms_encryption_context} => String
  #   * {Types::CopyObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::CopyObjectOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#1479
  def copy_object(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a new S3 bucket. To create a bucket, you must register with
  # Amazon S3 and have a valid Amazon Web Services Access Key ID to
  # authenticate requests. Anonymous requests are never allowed to create
  # buckets. By creating the bucket, you become the bucket owner.
  #
  # Not every string is an acceptable bucket name. For information about
  # bucket naming restrictions, see [Bucket naming rules][1].
  #
  # If you want to create an Amazon S3 on Outposts bucket, see [Create
  # Bucket][2].
  #
  # By default, the bucket is created in the US East (N. Virginia) Region.
  # You can optionally specify a Region in the request body. You might
  # choose a Region to optimize latency, minimize costs, or address
  # regulatory requirements. For example, if you reside in Europe, you
  # will probably find it advantageous to create buckets in the Europe
  # (Ireland) Region. For more information, see [Accessing a bucket][3].
  #
  # <note markdown="1"> If you send your create bucket request to the `s3.amazonaws.com`
  # endpoint, the request goes to the us-east-1 Region. Accordingly, the
  # signature calculations in Signature Version 4 must use us-east-1 as
  # the Region, even if the location constraint in the request specifies
  # another Region where the bucket is to be created. If you create a
  # bucket in a Region other than US East (N. Virginia), your application
  # must be able to handle 307 redirect. For more information, see
  # [Virtual hosting of buckets][4].
  #
  #  </note>
  #
  # **Access control lists (ACLs)**
  #
  # When creating a bucket using this operation, you can optionally
  # configure the bucket ACL to specify the accounts or groups that should
  # be granted specific permissions on the bucket.
  #
  # If your CreateBucket request sets bucket owner enforced for S3 Object
  # Ownership and specifies a bucket ACL that provides access to an
  # external Amazon Web Services account, your request fails with a `400`
  # error and returns the `InvalidBucketAclWithObjectOwnership` error
  # code. For more information, see [Controlling object ownership][5] in
  # the *Amazon S3 User Guide*.
  #
  # There are two ways to grant the appropriate permissions using the
  # request headers.
  #
  # * Specify a canned ACL using the `x-amz-acl` request header. Amazon S3
  #   supports a set of predefined ACLs, known as *canned ACLs*. Each
  #   canned ACL has a predefined set of grantees and permissions. For
  #   more information, see [Canned ACL][6].
  #
  # * Specify access permissions explicitly using the `x-amz-grant-read`,
  #   `x-amz-grant-write`, `x-amz-grant-read-acp`,
  #   `x-amz-grant-write-acp`, and `x-amz-grant-full-control` headers.
  #   These headers map to the set of permissions Amazon S3 supports in an
  #   ACL. For more information, see [Access control list (ACL)
  #   overview][7].
  #
  #   You specify each grantee as a type=value pair, where the type is one
  #   of the following:
  #
  #   * `id` – if the value specified is the canonical user ID of an
  #     Amazon Web Services account
  #
  #   * `uri` – if you are granting permissions to a predefined group
  #
  #   * `emailAddress` – if the value specified is the email address of an
  #     Amazon Web Services account
  #
  #     <note markdown="1"> Using email addresses to specify a grantee is only supported in
  #     the following Amazon Web Services Regions:
  #
  #      * US East (N. Virginia)
  #
  #     * US West (N. California)
  #
  #     * US West (Oregon)
  #
  #     * Asia Pacific (Singapore)
  #
  #     * Asia Pacific (Sydney)
  #
  #     * Asia Pacific (Tokyo)
  #
  #     * Europe (Ireland)
  #
  #     * South America (São Paulo)
  #
  #      For a list of all the Amazon S3 supported Regions and endpoints,
  #     see [Regions and Endpoints][8] in the Amazon Web Services General
  #     Reference.
  #
  #      </note>
  #
  #   For example, the following `x-amz-grant-read` header grants the
  #   Amazon Web Services accounts identified by account IDs permissions
  #   to read object data and its metadata:
  #
  #   `x-amz-grant-read: id="11112222333", id="444455556666" `
  #
  # <note markdown="1"> You can use either a canned ACL or specify access permissions
  # explicitly. You cannot do both.
  #
  #  </note>
  #
  # **Permissions**
  #
  # In addition to `s3:CreateBucket`, the following permissions are
  # required when your CreateBucket includes specific headers:
  #
  # * **ACLs** - If your `CreateBucket` request specifies ACL permissions
  #   and the ACL is public-read, public-read-write, authenticated-read,
  #   or if you specify access permissions explicitly through any other
  #   ACL, both `s3:CreateBucket` and `s3:PutBucketAcl` permissions are
  #   needed. If the ACL the `CreateBucket` request is private or doesn't
  #   specify any ACLs, only `s3:CreateBucket` permission is needed.
  #
  # * **Object Lock** - If `ObjectLockEnabledForBucket` is set to true in
  #   your `CreateBucket` request, `s3:PutBucketObjectLockConfiguration`
  #   and `s3:PutBucketVersioning` permissions are required.
  #
  # * **S3 Object Ownership** - If your CreateBucket request includes the
  #   the `x-amz-object-ownership` header, `s3:PutBucketOwnershipControls`
  #   permission is required.
  #
  # The following operations are related to `CreateBucket`\:
  #
  # * [PutObject][9]
  #
  # * [DeleteBucket][10]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html
  # [8]: https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html
  #
  # @example Example: To create a bucket in a specific region
  #
  #   # The following example creates a bucket. The request specifies an AWS region where to create the bucket.
  #
  #   resp = client.create_bucket({
  #   bucket: "examplebucket",
  #   create_bucket_configuration: {
  #   location_constraint: "eu-west-1",
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   location: "http://examplebucket.<Region>.s3.amazonaws.com/",
  #   }
  # @example Example: To create a bucket
  #
  #   # The following example creates a bucket.
  #
  #   resp = client.create_bucket({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   location: "/examplebucket",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_bucket({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read
  #   bucket: "BucketName", # required
  #   create_bucket_configuration: {
  #   location_constraint: "af-south-1", # accepts af-south-1, ap-east-1, ap-northeast-1, ap-northeast-2, ap-northeast-3, ap-south-1, ap-southeast-1, ap-southeast-2, ap-southeast-3, ca-central-1, cn-north-1, cn-northwest-1, EU, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2, eu-west-3, me-south-1, sa-east-1, us-east-2, us-gov-east-1, us-gov-west-1, us-west-1, us-west-2
  #   },
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   object_lock_enabled_for_bucket: false,
  #   object_ownership: "BucketOwnerPreferred", # accepts BucketOwnerPreferred, ObjectWriter, BucketOwnerEnforced
  #   })
  # @example Response structure
  #
  #   resp.location #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_bucket
  # @param params [Hash] ({})
  # @return [Types::CreateBucketOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateBucketOutput#location #location} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#1736
  def create_bucket(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action initiates a multipart upload and returns an upload ID.
  # This upload ID is used to associate all of the parts in the specific
  # multipart upload. You specify this upload ID in each of your
  # subsequent upload part requests (see [UploadPart][1]). You also
  # include this upload ID in the final request to either complete or
  # abort the multipart upload request.
  #
  # For more information about multipart uploads, see [Multipart Upload
  # Overview][2].
  #
  # If you have configured a lifecycle rule to abort incomplete multipart
  # uploads, the upload must complete within the number of days specified
  # in the bucket lifecycle configuration. Otherwise, the incomplete
  # multipart upload becomes eligible for an abort action and Amazon S3
  # aborts the multipart upload. For more information, see [Aborting
  # Incomplete Multipart Uploads Using a Bucket Lifecycle Policy][3].
  #
  # For information about the permissions required to use the multipart
  # upload API, see [Multipart Upload and Permissions][4].
  #
  # For request signing, multipart upload is just a series of regular
  # requests. You initiate a multipart upload, send one or more requests
  # to upload parts, and then complete the multipart upload process. You
  # sign each request individually. There is nothing special about signing
  # multipart upload requests. For more information about signing, see
  # [Authenticating Requests (Amazon Web Services Signature Version
  # 4)][5].
  #
  # <note markdown="1"> After you initiate a multipart upload and upload one or more parts, to
  # stop being charged for storing the uploaded parts, you must either
  # complete or abort the multipart upload. Amazon S3 frees up the space
  # used to store the parts and stop charging you for storing them only
  # after you either complete or abort a multipart upload.
  #
  #  </note>
  #
  # You can optionally request server-side encryption. For server-side
  # encryption, Amazon S3 encrypts your data as it writes it to disks in
  # its data centers and decrypts it when you access it. You can provide
  # your own encryption key, or use Amazon Web Services KMS keys or Amazon
  # S3-managed encryption keys. If you choose to provide your own
  # encryption key, the request headers you provide in [UploadPart][1] and
  # [UploadPartCopy][6] requests must match the headers you used in the
  # request to initiate the upload by using `CreateMultipartUpload`.
  #
  # To perform a multipart upload with encryption using an Amazon Web
  # Services KMS key, the requester must have permission to the
  # `kms:Decrypt` and `kms:GenerateDataKey*` actions on the key. These
  # permissions are required because Amazon S3 must decrypt and read data
  # from the encrypted file parts before it completes the multipart
  # upload. For more information, see [Multipart upload API and
  # permissions][7] in the *Amazon S3 User Guide*.
  #
  # If your Identity and Access Management (IAM) user or role is in the
  # same Amazon Web Services account as the KMS key, then you must have
  # these permissions on the key policy. If your IAM user or role belongs
  # to a different account than the key, then you must have the
  # permissions on both the key policy and your IAM user or role.
  #
  # For more information, see [Protecting Data Using Server-Side
  # Encryption][8].
  #
  # Access Permissions
  #
  # : When copying an object, you can optionally specify the accounts or
  #   groups that should be granted specific permissions on the new
  #   object. There are two ways to grant the permissions using the
  #   request headers:
  #
  #   * Specify a canned ACL with the `x-amz-acl` request header. For more
  #     information, see [Canned ACL][9].
  #
  #   * Specify access permissions explicitly with the `x-amz-grant-read`,
  #     `x-amz-grant-read-acp`, `x-amz-grant-write-acp`, and
  #     `x-amz-grant-full-control` headers. These parameters map to the
  #     set of permissions that Amazon S3 supports in an ACL. For more
  #     information, see [Access Control List (ACL) Overview][10].
  #
  #   You can use either a canned ACL or specify access permissions
  #   explicitly. You cannot do both.
  #
  # Server-Side- Encryption-Specific Request Headers
  #
  # : You can optionally tell Amazon S3 to encrypt data at rest using
  #   server-side encryption. Server-side encryption is for data
  #   encryption at rest. Amazon S3 encrypts your data as it writes it to
  #   disks in its data centers and decrypts it when you access it. The
  #   option you use depends on whether you want to use Amazon Web
  #   Services managed encryption keys or provide your own encryption key.
  #
  #   * Use encryption keys managed by Amazon S3 or customer managed key
  #     stored in Amazon Web Services Key Management Service (Amazon Web
  #     Services KMS) – If you want Amazon Web Services to manage the keys
  #     used to encrypt data, specify the following headers in the
  #     request.
  #
  #     * `x-amz-server-side-encryption`
  #
  #     * `x-amz-server-side-encryption-aws-kms-key-id`
  #
  #     * `x-amz-server-side-encryption-context`
  #
  #     <note markdown="1"> If you specify `x-amz-server-side-encryption:aws:kms`, but don't
  #     provide `x-amz-server-side-encryption-aws-kms-key-id`, Amazon S3
  #     uses the Amazon Web Services managed key in Amazon Web Services
  #     KMS to protect the data.
  #
  #      </note>
  #
  #     All GET and PUT requests for an object protected by Amazon Web
  #     Services KMS fail if you don't make them with SSL or by using
  #     SigV4.
  #
  #     For more information about server-side encryption with KMS key
  #     (SSE-KMS), see [Protecting Data Using Server-Side Encryption with
  #     KMS keys][11].
  #
  #   * Use customer-provided encryption keys – If you want to manage your
  #     own encryption keys, provide all the following headers in the
  #     request.
  #
  #     * `x-amz-server-side-encryption-customer-algorithm`
  #
  #     * `x-amz-server-side-encryption-customer-key`
  #
  #     * `x-amz-server-side-encryption-customer-key-MD5`
  #
  #     For more information about server-side encryption with KMS keys
  #     (SSE-KMS), see [Protecting Data Using Server-Side Encryption with
  #     KMS keys][11].
  #
  # Access-Control-List (ACL)-Specific Request Headers
  #
  # : You also can use the following access control–related headers with
  #   this operation. By default, all objects are private. Only the owner
  #   has full access control. When adding a new object, you can grant
  #   permissions to individual Amazon Web Services accounts or to
  #   predefined groups defined by Amazon S3. These permissions are then
  #   added to the access control list (ACL) on the object. For more
  #   information, see [Using ACLs][12]. With this operation, you can
  #   grant access permissions using one of the following two methods:
  #
  #   * Specify a canned ACL (`x-amz-acl`) — Amazon S3 supports a set of
  #     predefined ACLs, known as *canned ACLs*. Each canned ACL has a
  #     predefined set of grantees and permissions. For more information,
  #     see [Canned ACL][9].
  #
  #   * Specify access permissions explicitly — To explicitly grant access
  #     permissions to specific Amazon Web Services accounts or groups,
  #     use the following headers. Each header maps to specific
  #     permissions that Amazon S3 supports in an ACL. For more
  #     information, see [Access Control List (ACL) Overview][10]. In the
  #     header, you specify a list of grantees who get the specific
  #     permission. To grant permissions explicitly, use:
  #
  #     * `x-amz-grant-read`
  #
  #     * `x-amz-grant-write`
  #
  #     * `x-amz-grant-read-acp`
  #
  #     * `x-amz-grant-write-acp`
  #
  #     * `x-amz-grant-full-control`
  #
  #     You specify each grantee as a type=value pair, where the type is
  #     one of the following:
  #
  #     * `id` – if the value specified is the canonical user ID of an
  #       Amazon Web Services account
  #
  #     * `uri` – if you are granting permissions to a predefined group
  #
  #     * `emailAddress` – if the value specified is the email address of
  #       an Amazon Web Services account
  #
  #       <note markdown="1"> Using email addresses to specify a grantee is only supported in
  #       the following Amazon Web Services Regions:
  #
  #        * US East (N. Virginia)
  #
  #       * US West (N. California)
  #
  #       * US West (Oregon)
  #
  #       * Asia Pacific (Singapore)
  #
  #       * Asia Pacific (Sydney)
  #
  #       * Asia Pacific (Tokyo)
  #
  #       * Europe (Ireland)
  #
  #       * South America (São Paulo)
  #
  #        For a list of all the Amazon S3 supported Regions and endpoints,
  #       see [Regions and Endpoints][13] in the Amazon Web Services
  #       General Reference.
  #
  #        </note>
  #
  #     For example, the following `x-amz-grant-read` header grants the
  #     Amazon Web Services accounts identified by account IDs permissions
  #     to read object data and its metadata:
  #
  #     `x-amz-grant-read: id="11112222333", id="444455556666" `
  #
  # The following operations are related to `CreateMultipartUpload`\:
  #
  # * [UploadPart][1]
  #
  # * [CompleteMultipartUpload][14]
  #
  # * [AbortMultipartUpload][15]
  #
  # * [ListParts][16]
  #
  # * [ListMultipartUploads][17]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
  # [12]: https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html
  # [13]: https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region
  # [14]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [15]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  # [16]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [17]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # @example Example: To initiate a multipart upload
  #
  #   # The following example initiates a multipart upload.
  #
  #   resp = client.create_multipart_upload({
  #   bucket: "examplebucket",
  #   key: "largeobject",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   bucket: "examplebucket",
  #   key: "largeobject",
  #   upload_id: "ibZBv_75gd9r8lH_gqXatLdxMVpAlj6ZQjEs.OwyF3953YdwbcQnMA2BLGn8Lx12fQNICtMw5KyteFeHw.Sjng--",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_multipart_upload({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   bucket: "BucketName", # required
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   key: "ObjectKey", # required
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @example Response structure
  #
  #   resp.abort_date #=> Time
  #   resp.abort_rule_id #=> String
  #   resp.bucket #=> String
  #   resp.key #=> String
  #   resp.upload_id #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.ssekms_encryption_context #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  #   resp.checksum_algorithm #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_multipart_upload
  # @param params [Hash] ({})
  # @return [Types::CreateMultipartUploadOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateMultipartUploadOutput#abort_date #abort_date} => Time
  #   * {Types::CreateMultipartUploadOutput#abort_rule_id #abort_rule_id} => String
  #   * {Types::CreateMultipartUploadOutput#bucket #bucket} => String
  #   * {Types::CreateMultipartUploadOutput#key #key} => String
  #   * {Types::CreateMultipartUploadOutput#upload_id #upload_id} => String
  #   * {Types::CreateMultipartUploadOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::CreateMultipartUploadOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::CreateMultipartUploadOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::CreateMultipartUploadOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::CreateMultipartUploadOutput#ssekms_encryption_context #ssekms_encryption_context} => String
  #   * {Types::CreateMultipartUploadOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::CreateMultipartUploadOutput#request_charged #request_charged} => String
  #   * {Types::CreateMultipartUploadOutput#checksum_algorithm #checksum_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2251
  def create_multipart_upload(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the S3 bucket. All objects (including all object versions and
  # delete markers) in the bucket must be deleted before the bucket itself
  # can be deleted.
  #
  # **Related Resources**
  #
  # * [CreateBucket][1]
  #
  # * [DeleteObject][2]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  #
  # @example Example: To delete a bucket
  #
  #   # The following example deletes the specified bucket.
  #
  #   resp = client.delete_bucket({
  #   bucket: "forrandall2",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2301
  def delete_bucket(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes an analytics configuration for the bucket (specified by the
  # analytics configuration ID).
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutAnalyticsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about the Amazon S3 analytics feature, see [Amazon S3
  # Analytics – Storage Class Analysis][3].
  #
  # The following operations are related to
  # `DeleteBucketAnalyticsConfiguration`\:
  #
  # * [GetBucketAnalyticsConfiguration][4]
  #
  # * [ListBucketAnalyticsConfigurations][5]
  #
  # * [PutBucketAnalyticsConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_analytics_configuration({
  #   bucket: "BucketName", # required
  #   id: "AnalyticsId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @overload delete_bucket_analytics_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2363
  def delete_bucket_analytics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the `cors` configuration information set for the bucket.
  #
  # To use this operation, you must have permission to perform the
  # `s3:PutBucketCORS` action. The bucket owner has this permission by
  # default and can grant this permission to others.
  #
  # For information about `cors`, see [Enabling Cross-Origin Resource
  # Sharing][1] in the *Amazon S3 User Guide*.
  #
  # **Related Resources:**
  #
  # * [PutBucketCors][2]
  #
  # * [RESTOPTIONSobject][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html
  #
  # @example Example: To delete cors configuration on a bucket.
  #
  #   # The following example deletes CORS configuration on a bucket.
  #
  #   resp = client.delete_bucket_cors({
  #   bucket: "examplebucket",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_cors({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_cors
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2419
  def delete_bucket_cors(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the DELETE action removes default encryption
  # from the bucket. For information about the Amazon S3 default
  # encryption feature, see [Amazon S3 Default Bucket Encryption][1] in
  # the *Amazon S3 User Guide*.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutEncryptionConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][2] and [Managing Access
  # Permissions to your Amazon S3 Resources][3] in the *Amazon S3 User
  # Guide*.
  #
  # **Related Resources**
  #
  # * [PutBucketEncryption][4]
  #
  # * [GetBucketEncryption][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_encryption({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_encryption
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2473
  def delete_bucket_encryption(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the S3 Intelligent-Tiering configuration from the specified
  # bucket.
  #
  # The S3 Intelligent-Tiering storage class is designed to optimize
  # storage costs by automatically moving data to the most cost-effective
  # storage access tier, without performance impact or operational
  # overhead. S3 Intelligent-Tiering delivers automatic cost savings in
  # three low latency and high throughput access tiers. To get the lowest
  # storage cost on data that can be accessed in minutes to hours, you can
  # choose to activate additional archiving capabilities.
  #
  # The S3 Intelligent-Tiering storage class is the ideal storage class
  # for data with unknown, changing, or unpredictable access patterns,
  # independent of object size or retention period. If the size of an
  # object is less than 128 KB, it is not monitored and not eligible for
  # auto-tiering. Smaller objects can be stored, but they are always
  # charged at the Frequent Access tier rates in the S3
  # Intelligent-Tiering storage class.
  #
  # For more information, see [Storage class for automatically optimizing
  # frequently and infrequently accessed objects][1].
  #
  # Operations related to `DeleteBucketIntelligentTieringConfiguration`
  # include:
  #
  # * [GetBucketIntelligentTieringConfiguration][2]
  #
  # * [PutBucketIntelligentTieringConfiguration][3]
  #
  # * [ListBucketIntelligentTieringConfigurations][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_intelligent_tiering_configuration({
  #   bucket: "BucketName", # required
  #   id: "IntelligentTieringId", # required
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_intelligent_tiering_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketIntelligentTieringConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2536
  def delete_bucket_intelligent_tiering_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes an inventory configuration (identified by the inventory ID)
  # from the bucket.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutInventoryConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about the Amazon S3 inventory feature, see [Amazon S3
  # Inventory][3].
  #
  # Operations related to `DeleteBucketInventoryConfiguration` include:
  #
  # * [GetBucketInventoryConfiguration][4]
  #
  # * [PutBucketInventoryConfiguration][5]
  #
  # * [ListBucketInventoryConfigurations][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_inventory_configuration({
  #   bucket: "BucketName", # required
  #   id: "InventoryId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @overload delete_bucket_inventory_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2597
  def delete_bucket_inventory_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the lifecycle configuration from the specified bucket. Amazon
  # S3 removes all the lifecycle configuration rules in the lifecycle
  # subresource associated with the bucket. Your objects never expire, and
  # Amazon S3 no longer automatically deletes any objects on the basis of
  # rules contained in the deleted lifecycle configuration.
  #
  # To use this operation, you must have permission to perform the
  # `s3:PutLifecycleConfiguration` action. By default, the bucket owner
  # has this permission and the bucket owner can grant this permission to
  # others.
  #
  # There is usually some time lag before lifecycle configuration deletion
  # is fully propagated to all the Amazon S3 systems.
  #
  # For more information about the object expiration, see [Elements to
  # Describe Lifecycle Actions][1].
  #
  # Related actions include:
  #
  # * [PutBucketLifecycleConfiguration][2]
  #
  # * [GetBucketLifecycleConfiguration][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html
  #
  # @example Example: To delete lifecycle configuration on a bucket.
  #
  #   # The following example deletes lifecycle configuration on a bucket.
  #
  #   resp = client.delete_bucket_lifecycle({
  #   bucket: "examplebucket",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_lifecycle({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_lifecycle
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2661
  def delete_bucket_lifecycle(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes a metrics configuration for the Amazon CloudWatch request
  # metrics (specified by the metrics configuration ID) from the bucket.
  # Note that this doesn't include the daily storage metrics.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutMetricsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about CloudWatch request metrics for Amazon S3, see
  # [Monitoring Metrics with Amazon CloudWatch][3].
  #
  # The following operations are related to
  # `DeleteBucketMetricsConfiguration`\:
  #
  # * [GetBucketMetricsConfiguration][4]
  #
  # * [PutBucketMetricsConfiguration][5]
  #
  # * [ListBucketMetricsConfigurations][6]
  #
  # * [Monitoring Metrics with Amazon CloudWatch][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_metrics_configuration({
  #   bucket: "BucketName", # required
  #   id: "MetricsId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @overload delete_bucket_metrics_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2725
  def delete_bucket_metrics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Removes `OwnershipControls` for an Amazon S3 bucket. To use this
  # operation, you must have the `s3:PutBucketOwnershipControls`
  # permission. For more information about Amazon S3 permissions, see
  # [Specifying Permissions in a Policy][1].
  #
  # For information about Amazon S3 Object Ownership, see [Using Object
  # Ownership][2].
  #
  # The following operations are related to
  # `DeleteBucketOwnershipControls`\:
  #
  # * GetBucketOwnershipControls
  #
  # * PutBucketOwnershipControls
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_ownership_controls({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_ownership_controls
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOwnershipControls AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2771
  def delete_bucket_ownership_controls(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the DELETE action uses the policy subresource
  # to delete the policy of a specified bucket. If you are using an
  # identity other than the root user of the Amazon Web Services account
  # that owns the bucket, the calling identity must have the
  # `DeleteBucketPolicy` permissions on the specified bucket and belong to
  # the bucket owner's account to use this operation.
  #
  # If you don't have `DeleteBucketPolicy` permissions, Amazon S3 returns
  # a `403 Access Denied` error. If you have the correct permissions, but
  # you're not using an identity that belongs to the bucket owner's
  # account, Amazon S3 returns a `405 Method Not Allowed` error.
  #
  # As a security precaution, the root user of the Amazon Web Services
  # account that owns a bucket can always use this operation, even if the
  # policy explicitly denies the root user the ability to perform this
  # action.
  #
  # For more information about bucket policies, see [Using Bucket Policies
  # and UserPolicies][1].
  #
  # The following operations are related to `DeleteBucketPolicy`
  #
  # * [CreateBucket][2]
  #
  # * [DeleteObject][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  #
  # @example Example: To delete bucket policy
  #
  #   # The following example deletes bucket policy on the specified bucket.
  #
  #   resp = client.delete_bucket_policy({
  #   bucket: "examplebucket",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_policy({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_policy
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2838
  def delete_bucket_policy(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the replication configuration from the bucket.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutReplicationConfiguration` action. The bucket owner has these
  # permissions by default and can grant it to others. For more
  # information about permissions, see [Permissions Related to Bucket
  # Subresource Operations][1] and [Managing Access Permissions to Your
  # Amazon S3 Resources][2].
  #
  # <note markdown="1"> It can take a while for the deletion of a replication configuration to
  # fully propagate.
  #
  #  </note>
  #
  # For information about replication configuration, see [Replication][3]
  # in the *Amazon S3 User Guide*.
  #
  # The following operations are related to `DeleteBucketReplication`\:
  #
  # * [PutBucketReplication][4]
  #
  # * [GetBucketReplication][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html
  #
  # @example Example: To delete bucket replication configuration
  #
  #   # The following example deletes replication configuration set on bucket.
  #
  #   resp = client.delete_bucket_replication({
  #   bucket: "example",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_replication({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_replication
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2904
  def delete_bucket_replication(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the tags from the bucket.
  #
  # To use this operation, you must have permission to perform the
  # `s3:PutBucketTagging` action. By default, the bucket owner has this
  # permission and can grant this permission to others.
  #
  # The following operations are related to `DeleteBucketTagging`\:
  #
  # * [GetBucketTagging][1]
  #
  # * [PutBucketTagging][2]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html
  #
  # @example Example: To delete bucket tags
  #
  #   # The following example deletes bucket tags.
  #
  #   resp = client.delete_bucket_tagging({
  #   bucket: "examplebucket",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_tagging({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_tagging
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#2956
  def delete_bucket_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action removes the website configuration for a bucket. Amazon S3
  # returns a `200 OK` response upon successfully deleting a website
  # configuration on the specified bucket. You will get a `200 OK`
  # response if the website configuration you are trying to delete does
  # not exist on the bucket. Amazon S3 returns a `404` response if the
  # bucket specified in the request does not exist.
  #
  # This DELETE action requires the `S3:DeleteBucketWebsite` permission.
  # By default, only the bucket owner can delete the website configuration
  # attached to a bucket. However, bucket owners can grant other users
  # permission to delete the website configuration by writing a bucket
  # policy granting them the `S3:DeleteBucketWebsite` permission.
  #
  # For more information about hosting websites, see [Hosting Websites on
  # Amazon S3][1].
  #
  # The following operations are related to `DeleteBucketWebsite`\:
  #
  # * [GetBucketWebsite][2]
  #
  # * [PutBucketWebsite][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html
  #
  # @example Example: To delete bucket website configuration
  #
  #   # The following example deletes bucket website configuration.
  #
  #   resp = client.delete_bucket_website({
  #   bucket: "examplebucket",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_bucket_website({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_bucket_website
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3020
  def delete_bucket_website(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Removes the null version (if there is one) of an object and inserts a
  # delete marker, which becomes the latest version of the object. If
  # there isn't a null version, Amazon S3 does not remove any objects but
  # will still respond that the command was successful.
  #
  # To remove a specific version, you must be the bucket owner and you
  # must use the version Id subresource. Using this subresource
  # permanently deletes the version. If the object deleted is a delete
  # marker, Amazon S3 sets the response header, `x-amz-delete-marker`, to
  # true.
  #
  # If the object you want to delete is in a bucket where the bucket
  # versioning configuration is MFA Delete enabled, you must include the
  # `x-amz-mfa` request header in the DELETE `versionId` request. Requests
  # that include `x-amz-mfa` must use HTTPS.
  #
  # For more information about MFA Delete, see [Using MFA Delete][1]. To
  # see sample requests that use versioning, see [Sample Request][2].
  #
  # You can delete objects by explicitly calling DELETE Object or
  # configure its lifecycle ([PutBucketLifecycle][3]) to enable Amazon S3
  # to remove them for you. If you want to block users or accounts from
  # removing or deleting objects from your bucket, you must deny them the
  # `s3:DeleteObject`, `s3:DeleteObjectVersion`, and
  # `s3:PutLifeCycleConfiguration` actions.
  #
  # The following action is related to `DeleteObject`\:
  #
  # * [PutObject][4]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  #
  # @example Example: To delete an object
  #
  #   # The following example deletes an object from an S3 bucket.
  #
  #   resp = client.delete_object({
  #   bucket: "examplebucket",
  #   key: "objectkey.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To delete an object (from a non-versioned bucket)
  #
  #   # The following example deletes an object from a non-versioned bucket.
  #
  #   resp = client.delete_object({
  #   bucket: "ExampleBucket",
  #   key: "HappyFace.jpg",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_object({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   mfa: "MFA",
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.delete_marker #=> Boolean
  #   resp.version_id #=> String
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload delete_object
  # @param params [Hash] ({})
  # @return [Types::DeleteObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DeleteObjectOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::DeleteObjectOutput#version_id #version_id} => String
  #   * {Types::DeleteObjectOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3173
  def delete_object(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Removes the entire tag set from the specified object. For more
  # information about managing object tags, see [ Object Tagging][1].
  #
  # To use this operation, you must have permission to perform the
  # `s3:DeleteObjectTagging` action.
  #
  # To delete tags of a specific object version, add the `versionId` query
  # parameter in the request. You will need permission for the
  # `s3:DeleteObjectVersionTagging` action.
  #
  # The following operations are related to
  # `DeleteBucketMetricsConfiguration`\:
  #
  # * [PutObjectTagging][2]
  #
  # * [GetObjectTagging][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html
  #
  # @example Example: To remove tag set from an object version
  #
  #   # The following example removes tag set associated with the specified object version. The request specifies both the
  #   # object key and object version.
  #
  #   resp = client.delete_object_tagging({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   version_id: "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   version_id: "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI",
  #   }
  # @example Example: To remove tag set from an object
  #
  #   # The following example removes tag set associated with the specified object. If the bucket is versioning enabled, the
  #   # operation removes tag set from the latest object version.
  #
  #   resp = client.delete_object_tagging({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   version_id: "null",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_object_tagging({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.version_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload delete_object_tagging
  # @param params [Hash] ({})
  # @return [Types::DeleteObjectTaggingOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DeleteObjectTaggingOutput#version_id #version_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3291
  def delete_object_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action enables you to delete multiple objects from a bucket using
  # a single HTTP request. If you know the object keys that you want to
  # delete, then this action provides a suitable alternative to sending
  # individual delete requests, reducing per-request overhead.
  #
  # The request contains a list of up to 1000 keys that you want to
  # delete. In the XML, you provide the object key names, and optionally,
  # version IDs if you want to delete a specific version of the object
  # from a versioning-enabled bucket. For each key, Amazon S3 performs a
  # delete action and returns the result of that delete, success, or
  # failure, in the response. Note that if the object specified in the
  # request is not found, Amazon S3 returns the result as deleted.
  #
  # The action supports two modes for the response: verbose and quiet. By
  # default, the action uses verbose mode in which the response includes
  # the result of deletion of each key in your request. In quiet mode the
  # response includes only keys where the delete action encountered an
  # error. For a successful deletion, the action does not return any
  # information about the delete in the response body.
  #
  # When performing this action on an MFA Delete enabled bucket, that
  # attempts to delete any versioned objects, you must include an MFA
  # token. If you do not provide one, the entire request will fail, even
  # if there are non-versioned objects you are trying to delete. If you
  # provide an invalid token, whether there are versioned keys in the
  # request or not, the entire Multi-Object Delete request will fail. For
  # information about MFA Delete, see [ MFA Delete][1].
  #
  # Finally, the Content-MD5 header is required for all Multi-Object
  # Delete requests. Amazon S3 uses the header value to ensure that your
  # request body has not been altered in transit.
  #
  # The following operations are related to `DeleteObjects`\:
  #
  # * [CreateMultipartUpload][2]
  #
  # * [UploadPart][3]
  #
  # * [CompleteMultipartUpload][4]
  #
  # * [ListParts][5]
  #
  # * [AbortMultipartUpload][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  #
  # @example Example: To delete multiple object versions from a versioned bucket
  #
  #   # The following example deletes objects from a bucket. The request specifies object versions. S3 deletes specific object
  #   # versions and returns the key and versions of deleted objects in the response.
  #
  #   resp = client.delete_objects({
  #   bucket: "examplebucket",
  #   delete: {
  #   objects: [
  #   {
  #   key: "HappyFace.jpg",
  #   version_id: "2LWg7lQLnY41.maGB5Z6SWW.dcq0vx7b",
  #   },
  #   {
  #   key: "HappyFace.jpg",
  #   version_id: "yoz3HB.ZhCS_tKVEmIOr7qYyyAaZSKVd",
  #   },
  #   ],
  #   quiet: false,
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   deleted: [
  #   {
  #   key: "HappyFace.jpg",
  #   version_id: "yoz3HB.ZhCS_tKVEmIOr7qYyyAaZSKVd",
  #   },
  #   {
  #   key: "HappyFace.jpg",
  #   version_id: "2LWg7lQLnY41.maGB5Z6SWW.dcq0vx7b",
  #   },
  #   ],
  #   }
  # @example Example: To delete multiple objects from a versioned bucket
  #
  #   # The following example deletes objects from a bucket. The bucket is versioned, and the request does not specify the
  #   # object version to delete. In this case, all versions remain in the bucket and S3 adds a delete marker.
  #
  #   resp = client.delete_objects({
  #   bucket: "examplebucket",
  #   delete: {
  #   objects: [
  #   {
  #   key: "objectkey1",
  #   },
  #   {
  #   key: "objectkey2",
  #   },
  #   ],
  #   quiet: false,
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   deleted: [
  #   {
  #   delete_marker: true,
  #   delete_marker_version_id: "A._w1z6EFiCF5uhtQMDal9JDkID9tQ7F",
  #   key: "objectkey1",
  #   },
  #   {
  #   delete_marker: true,
  #   delete_marker_version_id: "iOd_ORxhkKe_e8G8_oSGxt2PjsCZKlkt",
  #   key: "objectkey2",
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_objects({
  #   bucket: "BucketName", # required
  #   delete: { # required
  #   objects: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   },
  #   ],
  #   quiet: false,
  #   },
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @example Response structure
  #
  #   resp.deleted #=> Array
  #   resp.deleted[0].key #=> String
  #   resp.deleted[0].version_id #=> String
  #   resp.deleted[0].delete_marker #=> Boolean
  #   resp.deleted[0].delete_marker_version_id #=> String
  #   resp.request_charged #=> String, one of "requester"
  #   resp.errors #=> Array
  #   resp.errors[0].key #=> String
  #   resp.errors[0].version_id #=> String
  #   resp.errors[0].code #=> String
  #   resp.errors[0].message #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload delete_objects
  # @param params [Hash] ({})
  # @return [Types::DeleteObjectsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DeleteObjectsOutput#deleted #deleted} => Array&lt;Types::DeletedObject&gt;
  #   * {Types::DeleteObjectsOutput#request_charged #request_charged} => String
  #   * {Types::DeleteObjectsOutput#errors #errors} => Array&lt;Types::Error&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3540
  def delete_objects(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Removes the `PublicAccessBlock` configuration for an Amazon S3 bucket.
  # To use this operation, you must have the
  # `s3:PutBucketPublicAccessBlock` permission. For more information about
  # permissions, see [Permissions Related to Bucket Subresource
  # Operations][1] and [Managing Access Permissions to Your Amazon S3
  # Resources][2].
  #
  # The following operations are related to `DeletePublicAccessBlock`\:
  #
  # * [Using Amazon S3 Block Public Access][3]
  #
  # * [GetPublicAccessBlock][4]
  #
  # * [PutPublicAccessBlock][5]
  #
  # * [GetBucketPolicyStatus][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_public_access_block({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload delete_public_access_block
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlock AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3593
  def delete_public_access_block(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the GET action uses the `accelerate`
  # subresource to return the Transfer Acceleration state of a bucket,
  # which is either `Enabled` or `Suspended`. Amazon S3 Transfer
  # Acceleration is a bucket-level feature that enables you to perform
  # faster data transfers to and from Amazon S3.
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetAccelerateConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to your Amazon S3 Resources][2] in the *Amazon S3 User
  # Guide*.
  #
  # You set the Transfer Acceleration state of an existing bucket to
  # `Enabled` or `Suspended` by using the
  # [PutBucketAccelerateConfiguration][3] operation.
  #
  # A GET `accelerate` request does not return a state value for a bucket
  # that has no transfer acceleration state. A bucket has no Transfer
  # Acceleration state if a state has never been set on the bucket.
  #
  # For more information about transfer acceleration, see [Transfer
  # Acceleration][4] in the Amazon S3 User Guide.
  #
  # **Related Resources**
  #
  # * [PutBucketAccelerateConfiguration][3]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_accelerate_configuration({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.status #=> String, one of "Enabled", "Suspended"
  # @option params
  # @option params
  # @overload get_bucket_accelerate_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketAccelerateConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketAccelerateConfigurationOutput#status #status} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3664
  def get_bucket_accelerate_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the `GET` action uses the `acl` subresource to
  # return the access control list (ACL) of a bucket. To use `GET` to
  # return the ACL of the bucket, you must have `READ_ACP` access to the
  # bucket. If `READ_ACP` permission is granted to the anonymous user, you
  # can return the ACL of the bucket without using an authorization
  # header.
  #
  # <note markdown="1"> If your bucket uses the bucket owner enforced setting for S3 Object
  # Ownership, requests to read ACLs are still supported and return the
  # `bucket-owner-full-control` ACL with the owner being the account that
  # created the bucket. For more information, see [ Controlling object
  # ownership and disabling ACLs][1] in the *Amazon S3 User Guide*.
  #
  #  </note>
  #
  # **Related Resources**
  #
  # * [ListObjects][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_acl({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.owner.display_name #=> String
  #   resp.owner.id #=> String
  #   resp.grants #=> Array
  #   resp.grants[0].grantee.display_name #=> String
  #   resp.grants[0].grantee.email_address #=> String
  #   resp.grants[0].grantee.id #=> String
  #   resp.grants[0].grantee.type #=> String, one of "CanonicalUser", "AmazonCustomerByEmail", "Group"
  #   resp.grants[0].grantee.uri #=> String
  #   resp.grants[0].permission #=> String, one of "FULL_CONTROL", "WRITE", "WRITE_ACP", "READ", "READ_ACP"
  # @option params
  # @option params
  # @overload get_bucket_acl
  # @param params [Hash] ({})
  # @return [Types::GetBucketAclOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketAclOutput#owner #owner} => Types::Owner
  #   * {Types::GetBucketAclOutput#grants #grants} => Array&lt;Types::Grant&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3731
  def get_bucket_acl(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the GET action returns an analytics
  # configuration (identified by the analytics configuration ID) from the
  # bucket.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetAnalyticsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [ Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2] in the *Amazon S3 User
  # Guide*.
  #
  # For information about Amazon S3 analytics feature, see [Amazon S3
  # Analytics – Storage Class Analysis][3] in the *Amazon S3 User Guide*.
  #
  # **Related Resources**
  #
  # * [DeleteBucketAnalyticsConfiguration][4]
  #
  # * [ListBucketAnalyticsConfigurations][5]
  #
  # * [PutBucketAnalyticsConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_analytics_configuration({
  #   bucket: "BucketName", # required
  #   id: "AnalyticsId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.analytics_configuration.id #=> String
  #   resp.analytics_configuration.filter.prefix #=> String
  #   resp.analytics_configuration.filter.tag.key #=> String
  #   resp.analytics_configuration.filter.tag.value #=> String
  #   resp.analytics_configuration.filter.and.prefix #=> String
  #   resp.analytics_configuration.filter.and.tags #=> Array
  #   resp.analytics_configuration.filter.and.tags[0].key #=> String
  #   resp.analytics_configuration.filter.and.tags[0].value #=> String
  #   resp.analytics_configuration.storage_class_analysis.data_export.output_schema_version #=> String, one of "V_1"
  #   resp.analytics_configuration.storage_class_analysis.data_export.destination.s3_bucket_destination.format #=> String, one of "CSV"
  #   resp.analytics_configuration.storage_class_analysis.data_export.destination.s3_bucket_destination.bucket_account_id #=> String
  #   resp.analytics_configuration.storage_class_analysis.data_export.destination.s3_bucket_destination.bucket #=> String
  #   resp.analytics_configuration.storage_class_analysis.data_export.destination.s3_bucket_destination.prefix #=> String
  # @option params
  # @option params
  # @option params
  # @overload get_bucket_analytics_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketAnalyticsConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketAnalyticsConfigurationOutput#analytics_configuration #analytics_configuration} => Types::AnalyticsConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3812
  def get_bucket_analytics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the Cross-Origin Resource Sharing (CORS) configuration
  # information set for the bucket.
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetBucketCORS` action. By default, the bucket owner has this
  # permission and can grant it to others.
  #
  # For more information about CORS, see [ Enabling Cross-Origin Resource
  # Sharing][1].
  #
  # The following operations are related to `GetBucketCors`\:
  #
  # * [PutBucketCors][2]
  #
  # * [DeleteBucketCors][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html
  #
  # @example Example: To get cors configuration set on a bucket
  #
  #   # The following example returns cross-origin resource sharing (CORS) configuration set on a bucket.
  #
  #   resp = client.get_bucket_cors({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   cors_rules: [
  #   {
  #   allowed_headers: [
  #   "Authorization",
  #   ],
  #   allowed_methods: [
  #   "GET",
  #   ],
  #   allowed_origins: [
  #   "*",
  #   ],
  #   max_age_seconds: 3000,
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_cors({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.cors_rules #=> Array
  #   resp.cors_rules[0].id #=> String
  #   resp.cors_rules[0].allowed_headers #=> Array
  #   resp.cors_rules[0].allowed_headers[0] #=> String
  #   resp.cors_rules[0].allowed_methods #=> Array
  #   resp.cors_rules[0].allowed_methods[0] #=> String
  #   resp.cors_rules[0].allowed_origins #=> Array
  #   resp.cors_rules[0].allowed_origins[0] #=> String
  #   resp.cors_rules[0].expose_headers #=> Array
  #   resp.cors_rules[0].expose_headers[0] #=> String
  #   resp.cors_rules[0].max_age_seconds #=> Integer
  # @option params
  # @option params
  # @overload get_bucket_cors
  # @param params [Hash] ({})
  # @return [Types::GetBucketCorsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketCorsOutput#cors_rules #cors_rules} => Array&lt;Types::CORSRule&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3903
  def get_bucket_cors(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the default encryption configuration for an Amazon S3 bucket.
  # If the bucket does not have a default encryption configuration,
  # GetBucketEncryption returns
  # `ServerSideEncryptionConfigurationNotFoundError`.
  #
  # For information about the Amazon S3 default encryption feature, see
  # [Amazon S3 Default Bucket Encryption][1].
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetEncryptionConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][2] and [Managing Access
  # Permissions to Your Amazon S3 Resources][3].
  #
  # The following operations are related to `GetBucketEncryption`\:
  #
  # * [PutBucketEncryption][4]
  #
  # * [DeleteBucketEncryption][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_encryption({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.server_side_encryption_configuration.rules #=> Array
  #   resp.server_side_encryption_configuration.rules[0].apply_server_side_encryption_by_default.sse_algorithm #=> String, one of "AES256", "aws:kms"
  #   resp.server_side_encryption_configuration.rules[0].apply_server_side_encryption_by_default.kms_master_key_id #=> String
  #   resp.server_side_encryption_configuration.rules[0].bucket_key_enabled #=> Boolean
  # @option params
  # @option params
  # @overload get_bucket_encryption
  # @param params [Hash] ({})
  # @return [Types::GetBucketEncryptionOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketEncryptionOutput#server_side_encryption_configuration #server_side_encryption_configuration} => Types::ServerSideEncryptionConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#3968
  def get_bucket_encryption(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets the S3 Intelligent-Tiering configuration from the specified
  # bucket.
  #
  # The S3 Intelligent-Tiering storage class is designed to optimize
  # storage costs by automatically moving data to the most cost-effective
  # storage access tier, without performance impact or operational
  # overhead. S3 Intelligent-Tiering delivers automatic cost savings in
  # three low latency and high throughput access tiers. To get the lowest
  # storage cost on data that can be accessed in minutes to hours, you can
  # choose to activate additional archiving capabilities.
  #
  # The S3 Intelligent-Tiering storage class is the ideal storage class
  # for data with unknown, changing, or unpredictable access patterns,
  # independent of object size or retention period. If the size of an
  # object is less than 128 KB, it is not monitored and not eligible for
  # auto-tiering. Smaller objects can be stored, but they are always
  # charged at the Frequent Access tier rates in the S3
  # Intelligent-Tiering storage class.
  #
  # For more information, see [Storage class for automatically optimizing
  # frequently and infrequently accessed objects][1].
  #
  # Operations related to `GetBucketIntelligentTieringConfiguration`
  # include:
  #
  # * [DeleteBucketIntelligentTieringConfiguration][2]
  #
  # * [PutBucketIntelligentTieringConfiguration][3]
  #
  # * [ListBucketIntelligentTieringConfigurations][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_intelligent_tiering_configuration({
  #   bucket: "BucketName", # required
  #   id: "IntelligentTieringId", # required
  #   })
  # @example Response structure
  #
  #   resp.intelligent_tiering_configuration.id #=> String
  #   resp.intelligent_tiering_configuration.filter.prefix #=> String
  #   resp.intelligent_tiering_configuration.filter.tag.key #=> String
  #   resp.intelligent_tiering_configuration.filter.tag.value #=> String
  #   resp.intelligent_tiering_configuration.filter.and.prefix #=> String
  #   resp.intelligent_tiering_configuration.filter.and.tags #=> Array
  #   resp.intelligent_tiering_configuration.filter.and.tags[0].key #=> String
  #   resp.intelligent_tiering_configuration.filter.and.tags[0].value #=> String
  #   resp.intelligent_tiering_configuration.status #=> String, one of "Enabled", "Disabled"
  #   resp.intelligent_tiering_configuration.tierings #=> Array
  #   resp.intelligent_tiering_configuration.tierings[0].days #=> Integer
  #   resp.intelligent_tiering_configuration.tierings[0].access_tier #=> String, one of "ARCHIVE_ACCESS", "DEEP_ARCHIVE_ACCESS"
  # @option params
  # @option params
  # @overload get_bucket_intelligent_tiering_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketIntelligentTieringConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketIntelligentTieringConfigurationOutput#intelligent_tiering_configuration #intelligent_tiering_configuration} => Types::IntelligentTieringConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketIntelligentTieringConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4048
  def get_bucket_intelligent_tiering_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns an inventory configuration (identified by the inventory
  # configuration ID) from the bucket.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetInventoryConfiguration` action. The bucket owner has this
  # permission by default and can grant this permission to others. For
  # more information about permissions, see [Permissions Related to Bucket
  # Subresource Operations][1] and [Managing Access Permissions to Your
  # Amazon S3 Resources][2].
  #
  # For information about the Amazon S3 inventory feature, see [Amazon S3
  # Inventory][3].
  #
  # The following operations are related to
  # `GetBucketInventoryConfiguration`\:
  #
  # * [DeleteBucketInventoryConfiguration][4]
  #
  # * [ListBucketInventoryConfigurations][5]
  #
  # * [PutBucketInventoryConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_inventory_configuration({
  #   bucket: "BucketName", # required
  #   id: "InventoryId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.inventory_configuration.destination.s3_bucket_destination.account_id #=> String
  #   resp.inventory_configuration.destination.s3_bucket_destination.bucket #=> String
  #   resp.inventory_configuration.destination.s3_bucket_destination.format #=> String, one of "CSV", "ORC", "Parquet"
  #   resp.inventory_configuration.destination.s3_bucket_destination.prefix #=> String
  #   resp.inventory_configuration.destination.s3_bucket_destination.encryption.ssekms.key_id #=> String
  #   resp.inventory_configuration.is_enabled #=> Boolean
  #   resp.inventory_configuration.filter.prefix #=> String
  #   resp.inventory_configuration.id #=> String
  #   resp.inventory_configuration.included_object_versions #=> String, one of "All", "Current"
  #   resp.inventory_configuration.optional_fields #=> Array
  #   resp.inventory_configuration.optional_fields[0] #=> String, one of "Size", "LastModifiedDate", "StorageClass", "ETag", "IsMultipartUploaded", "ReplicationStatus", "EncryptionStatus", "ObjectLockRetainUntilDate", "ObjectLockMode", "ObjectLockLegalHoldStatus", "IntelligentTieringAccessTier", "BucketKeyStatus", "ChecksumAlgorithm"
  #   resp.inventory_configuration.schedule.frequency #=> String, one of "Daily", "Weekly"
  # @option params
  # @option params
  # @option params
  # @overload get_bucket_inventory_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketInventoryConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketInventoryConfigurationOutput#inventory_configuration #inventory_configuration} => Types::InventoryConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4127
  def get_bucket_inventory_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # For an updated version of this API, see
  # [GetBucketLifecycleConfiguration][1]. If you configured a bucket
  # lifecycle using the `filter` element, you should see the updated
  # version of this topic. This topic is provided for backward
  # compatibility.
  #
  # Returns the lifecycle configuration information set on the bucket. For
  # information about lifecycle configuration, see [Object Lifecycle
  # Management][2].
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetLifecycleConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][3] and [Managing Access
  # Permissions to Your Amazon S3 Resources][4].
  #
  # `GetBucketLifecycle` has the following special error:
  #
  # * Error code: `NoSuchLifecycleConfiguration`
  #
  #   * Description: The lifecycle configuration does not exist.
  #
  #   * HTTP Status Code: 404 Not Found
  #
  #   * SOAP Fault Code Prefix: Client
  #
  # The following operations are related to `GetBucketLifecycle`\:
  #
  # * [GetBucketLifecycleConfiguration][1]
  #
  # * [PutBucketLifecycle][5]
  #
  # * [DeleteBucketLifecycle][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html
  #
  # @example Example: To get a bucket acl
  #
  #   # The following example gets ACL on the specified bucket.
  #
  #   resp = client.get_bucket_lifecycle({
  #   bucket: "acl1",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   rules: [
  #   {
  #   expiration: {
  #   days: 1,
  #   },
  #   id: "delete logs",
  #   prefix: "123/",
  #   status: "Enabled",
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_lifecycle({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.rules #=> Array
  #   resp.rules[0].expiration.date #=> Time
  #   resp.rules[0].expiration.days #=> Integer
  #   resp.rules[0].expiration.expired_object_delete_marker #=> Boolean
  #   resp.rules[0].id #=> String
  #   resp.rules[0].prefix #=> String
  #   resp.rules[0].status #=> String, one of "Enabled", "Disabled"
  #   resp.rules[0].transition.date #=> Time
  #   resp.rules[0].transition.days #=> Integer
  #   resp.rules[0].transition.storage_class #=> String, one of "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "GLACIER_IR"
  #   resp.rules[0].noncurrent_version_transition.noncurrent_days #=> Integer
  #   resp.rules[0].noncurrent_version_transition.storage_class #=> String, one of "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "GLACIER_IR"
  #   resp.rules[0].noncurrent_version_transition.newer_noncurrent_versions #=> Integer
  #   resp.rules[0].noncurrent_version_expiration.noncurrent_days #=> Integer
  #   resp.rules[0].noncurrent_version_expiration.newer_noncurrent_versions #=> Integer
  #   resp.rules[0].abort_incomplete_multipart_upload.days_after_initiation #=> Integer
  # @option params
  # @option params
  # @overload get_bucket_lifecycle
  # @param params [Hash] ({})
  # @return [Types::GetBucketLifecycleOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketLifecycleOutput#rules #rules} => Array&lt;Types::Rule&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4241
  def get_bucket_lifecycle(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # <note markdown="1"> Bucket lifecycle configuration now supports specifying a lifecycle
  # rule using an object key name prefix, one or more object tags, or a
  # combination of both. Accordingly, this section describes the latest
  # API. The response describes the new filter element that you can use to
  # specify a filter to select a subset of objects to which the rule
  # applies. If you are using a previous version of the lifecycle
  # configuration, it still works. For the earlier action, see
  # [GetBucketLifecycle][1].
  #
  #  </note>
  #
  # Returns the lifecycle configuration information set on the bucket. For
  # information about lifecycle configuration, see [Object Lifecycle
  # Management][2].
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetLifecycleConfiguration` action. The bucket owner has this
  # permission, by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][3] and [Managing Access
  # Permissions to Your Amazon S3 Resources][4].
  #
  # `GetBucketLifecycleConfiguration` has the following special error:
  #
  # * Error code: `NoSuchLifecycleConfiguration`
  #
  #   * Description: The lifecycle configuration does not exist.
  #
  #   * HTTP Status Code: 404 Not Found
  #
  #   * SOAP Fault Code Prefix: Client
  #
  # The following operations are related to
  # `GetBucketLifecycleConfiguration`\:
  #
  # * [GetBucketLifecycle][1]
  #
  # * [PutBucketLifecycle][5]
  #
  # * [DeleteBucketLifecycle][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html
  #
  # @example Example: To get lifecycle configuration on a bucket
  #
  #   # The following example retrieves lifecycle configuration on set on a bucket.
  #
  #   resp = client.get_bucket_lifecycle_configuration({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   rules: [
  #   {
  #   id: "Rule for TaxDocs/",
  #   prefix: "TaxDocs",
  #   status: "Enabled",
  #   transitions: [
  #   {
  #   days: 365,
  #   storage_class: "STANDARD_IA",
  #   },
  #   ],
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_lifecycle_configuration({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.rules #=> Array
  #   resp.rules[0].expiration.date #=> Time
  #   resp.rules[0].expiration.days #=> Integer
  #   resp.rules[0].expiration.expired_object_delete_marker #=> Boolean
  #   resp.rules[0].id #=> String
  #   resp.rules[0].prefix #=> String
  #   resp.rules[0].filter.prefix #=> String
  #   resp.rules[0].filter.tag.key #=> String
  #   resp.rules[0].filter.tag.value #=> String
  #   resp.rules[0].filter.object_size_greater_than #=> Integer
  #   resp.rules[0].filter.object_size_less_than #=> Integer
  #   resp.rules[0].filter.and.prefix #=> String
  #   resp.rules[0].filter.and.tags #=> Array
  #   resp.rules[0].filter.and.tags[0].key #=> String
  #   resp.rules[0].filter.and.tags[0].value #=> String
  #   resp.rules[0].filter.and.object_size_greater_than #=> Integer
  #   resp.rules[0].filter.and.object_size_less_than #=> Integer
  #   resp.rules[0].status #=> String, one of "Enabled", "Disabled"
  #   resp.rules[0].transitions #=> Array
  #   resp.rules[0].transitions[0].date #=> Time
  #   resp.rules[0].transitions[0].days #=> Integer
  #   resp.rules[0].transitions[0].storage_class #=> String, one of "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "GLACIER_IR"
  #   resp.rules[0].noncurrent_version_transitions #=> Array
  #   resp.rules[0].noncurrent_version_transitions[0].noncurrent_days #=> Integer
  #   resp.rules[0].noncurrent_version_transitions[0].storage_class #=> String, one of "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "GLACIER_IR"
  #   resp.rules[0].noncurrent_version_transitions[0].newer_noncurrent_versions #=> Integer
  #   resp.rules[0].noncurrent_version_expiration.noncurrent_days #=> Integer
  #   resp.rules[0].noncurrent_version_expiration.newer_noncurrent_versions #=> Integer
  #   resp.rules[0].abort_incomplete_multipart_upload.days_after_initiation #=> Integer
  # @option params
  # @option params
  # @overload get_bucket_lifecycle_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketLifecycleConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketLifecycleConfigurationOutput#rules #rules} => Array&lt;Types::LifecycleRule&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4377
  def get_bucket_lifecycle_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the Region the bucket resides in. You set the bucket's Region
  # using the `LocationConstraint` request parameter in a `CreateBucket`
  # request. For more information, see [CreateBucket][1].
  #
  # To use this implementation of the operation, you must be the bucket
  # owner.
  #
  # To use this API against an access point, provide the alias of the
  # access point in place of the bucket name.
  #
  # The following operations are related to `GetBucketLocation`\:
  #
  # * [GetObject][2]
  #
  # * [CreateBucket][1]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  #
  # @example Example: To get bucket location
  #
  #   # The following example returns bucket location.
  #
  #   resp = client.get_bucket_location({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   location_constraint: "us-west-2",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_location({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.location_constraint #=> String, one of "af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "cn-north-1", "cn-northwest-1", "EU", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"
  # @option params
  # @option params
  # @overload get_bucket_location
  # @param params [Hash] ({})
  # @return [Types::GetBucketLocationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketLocationOutput#location_constraint #location_constraint} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4444
  def get_bucket_location(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the logging status of a bucket and the permissions users have
  # to view and modify that status. To use GET, you must be the bucket
  # owner.
  #
  # The following operations are related to `GetBucketLogging`\:
  #
  # * [CreateBucket][1]
  #
  # * [PutBucketLogging][2]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_logging({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.logging_enabled.target_bucket #=> String
  #   resp.logging_enabled.target_grants #=> Array
  #   resp.logging_enabled.target_grants[0].grantee.display_name #=> String
  #   resp.logging_enabled.target_grants[0].grantee.email_address #=> String
  #   resp.logging_enabled.target_grants[0].grantee.id #=> String
  #   resp.logging_enabled.target_grants[0].grantee.type #=> String, one of "CanonicalUser", "AmazonCustomerByEmail", "Group"
  #   resp.logging_enabled.target_grants[0].grantee.uri #=> String
  #   resp.logging_enabled.target_grants[0].permission #=> String, one of "FULL_CONTROL", "READ", "WRITE"
  #   resp.logging_enabled.target_prefix #=> String
  # @option params
  # @option params
  # @overload get_bucket_logging
  # @param params [Hash] ({})
  # @return [Types::GetBucketLoggingOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketLoggingOutput#logging_enabled #logging_enabled} => Types::LoggingEnabled
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4499
  def get_bucket_logging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a metrics configuration (specified by the metrics configuration
  # ID) from the bucket. Note that this doesn't include the daily storage
  # metrics.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetMetricsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about CloudWatch request metrics for Amazon S3, see
  # [Monitoring Metrics with Amazon CloudWatch][3].
  #
  # The following operations are related to
  # `GetBucketMetricsConfiguration`\:
  #
  # * [PutBucketMetricsConfiguration][4]
  #
  # * [DeleteBucketMetricsConfiguration][5]
  #
  # * [ListBucketMetricsConfigurations][6]
  #
  # * [Monitoring Metrics with Amazon CloudWatch][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_metrics_configuration({
  #   bucket: "BucketName", # required
  #   id: "MetricsId", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.metrics_configuration.id #=> String
  #   resp.metrics_configuration.filter.prefix #=> String
  #   resp.metrics_configuration.filter.tag.key #=> String
  #   resp.metrics_configuration.filter.tag.value #=> String
  #   resp.metrics_configuration.filter.access_point_arn #=> String
  #   resp.metrics_configuration.filter.and.prefix #=> String
  #   resp.metrics_configuration.filter.and.tags #=> Array
  #   resp.metrics_configuration.filter.and.tags[0].key #=> String
  #   resp.metrics_configuration.filter.and.tags[0].value #=> String
  #   resp.metrics_configuration.filter.and.access_point_arn #=> String
  # @option params
  # @option params
  # @option params
  # @overload get_bucket_metrics_configuration
  # @param params [Hash] ({})
  # @return [Types::GetBucketMetricsConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketMetricsConfigurationOutput#metrics_configuration #metrics_configuration} => Types::MetricsConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4579
  def get_bucket_metrics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # No longer used, see [GetBucketNotificationConfiguration][1].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html
  #
  # @example Example: To get notification configuration set on a bucket
  #
  #   # The following example returns notification configuration set on a bucket.
  #
  #   resp = client.get_bucket_notification({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   queue_configuration: {
  #   event: "s3:ObjectCreated:Put",
  #   events: [
  #   "s3:ObjectCreated:Put",
  #   ],
  #   id: "MDQ2OGQ4NDEtOTBmNi00YTM4LTk0NzYtZDIwN2I3NWQ1NjIx",
  #   queue: "arn:aws:sqs:us-east-1:acct-id:S3ObjectCreatedEventQueue",
  #   },
  #   topic_configuration: {
  #   event: "s3:ObjectCreated:Copy",
  #   events: [
  #   "s3:ObjectCreated:Copy",
  #   ],
  #   id: "YTVkMWEzZGUtNTY1NS00ZmE2LWJjYjktMmRlY2QwODFkNTJi",
  #   topic: "arn:aws:sns:us-east-1:acct-id:S3ObjectCreatedEventTopic",
  #   },
  #   }
  # @example Example: To get notification configuration set on a bucket
  #
  #   # The following example returns notification configuration set on a bucket.
  #
  #   resp = client.get_bucket_notification({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   queue_configuration: {
  #   event: "s3:ObjectCreated:Put",
  #   events: [
  #   "s3:ObjectCreated:Put",
  #   ],
  #   id: "MDQ2OGQ4NDEtOTBmNi00YTM4LTk0NzYtZDIwN2I3NWQ1NjIx",
  #   queue: "arn:aws:sqs:us-east-1:acct-id:S3ObjectCreatedEventQueue",
  #   },
  #   topic_configuration: {
  #   event: "s3:ObjectCreated:Copy",
  #   events: [
  #   "s3:ObjectCreated:Copy",
  #   ],
  #   id: "YTVkMWEzZGUtNTY1NS00ZmE2LWJjYjktMmRlY2QwODFkNTJi",
  #   topic: "arn:aws:sns:us-east-1:acct-id:S3ObjectCreatedEventTopic",
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_notification({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.topic_configuration.id #=> String
  #   resp.topic_configuration.events #=> Array
  #   resp.topic_configuration.events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.topic_configuration.event #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.topic_configuration.topic #=> String
  #   resp.queue_configuration.id #=> String
  #   resp.queue_configuration.event #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.queue_configuration.events #=> Array
  #   resp.queue_configuration.events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.queue_configuration.queue #=> String
  #   resp.cloud_function_configuration.id #=> String
  #   resp.cloud_function_configuration.event #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.cloud_function_configuration.events #=> Array
  #   resp.cloud_function_configuration.events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.cloud_function_configuration.cloud_function #=> String
  #   resp.cloud_function_configuration.invocation_role #=> String
  # @option params
  # @option params
  # @overload get_bucket_notification
  # @param params [Hash] ({})
  # @return [Types::NotificationConfigurationDeprecated] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::NotificationConfigurationDeprecated#topic_configuration #topic_configuration} => Types::TopicConfigurationDeprecated
  #   * {Types::NotificationConfigurationDeprecated#queue_configuration #queue_configuration} => Types::QueueConfigurationDeprecated
  #   * {Types::NotificationConfigurationDeprecated#cloud_function_configuration #cloud_function_configuration} => Types::CloudFunctionConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4692
  def get_bucket_notification(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the notification configuration of a bucket.
  #
  # If notifications are not enabled on the bucket, the action returns an
  # empty `NotificationConfiguration` element.
  #
  # By default, you must be the bucket owner to read the notification
  # configuration of a bucket. However, the bucket owner can use a bucket
  # policy to grant permission to other users to read this configuration
  # with the `s3:GetBucketNotification` permission.
  #
  # For more information about setting and reading the notification
  # configuration on a bucket, see [Setting Up Notification of Bucket
  # Events][1]. For more information about bucket policies, see [Using
  # Bucket Policies][2].
  #
  # The following action is related to `GetBucketNotification`\:
  #
  # * [PutBucketNotification][3]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_notification_configuration({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.topic_configurations #=> Array
  #   resp.topic_configurations[0].id #=> String
  #   resp.topic_configurations[0].topic_arn #=> String
  #   resp.topic_configurations[0].events #=> Array
  #   resp.topic_configurations[0].events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.topic_configurations[0].filter.key.filter_rules #=> Array
  #   resp.topic_configurations[0].filter.key.filter_rules[0].name #=> String, one of "prefix", "suffix"
  #   resp.topic_configurations[0].filter.key.filter_rules[0].value #=> String
  #   resp.queue_configurations #=> Array
  #   resp.queue_configurations[0].id #=> String
  #   resp.queue_configurations[0].queue_arn #=> String
  #   resp.queue_configurations[0].events #=> Array
  #   resp.queue_configurations[0].events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.queue_configurations[0].filter.key.filter_rules #=> Array
  #   resp.queue_configurations[0].filter.key.filter_rules[0].name #=> String, one of "prefix", "suffix"
  #   resp.queue_configurations[0].filter.key.filter_rules[0].value #=> String
  #   resp.lambda_function_configurations #=> Array
  #   resp.lambda_function_configurations[0].id #=> String
  #   resp.lambda_function_configurations[0].lambda_function_arn #=> String
  #   resp.lambda_function_configurations[0].events #=> Array
  #   resp.lambda_function_configurations[0].events[0] #=> String, one of "s3:ReducedRedundancyLostObject", "s3:ObjectCreated:*", "s3:ObjectCreated:Put", "s3:ObjectCreated:Post", "s3:ObjectCreated:Copy", "s3:ObjectCreated:CompleteMultipartUpload", "s3:ObjectRemoved:*", "s3:ObjectRemoved:Delete", "s3:ObjectRemoved:DeleteMarkerCreated", "s3:ObjectRestore:*", "s3:ObjectRestore:Post", "s3:ObjectRestore:Completed", "s3:Replication:*", "s3:Replication:OperationFailedReplication", "s3:Replication:OperationNotTracked", "s3:Replication:OperationMissedThreshold", "s3:Replication:OperationReplicatedAfterThreshold", "s3:ObjectRestore:Delete", "s3:LifecycleTransition", "s3:IntelligentTiering", "s3:ObjectAcl:Put", "s3:LifecycleExpiration:*", "s3:LifecycleExpiration:Delete", "s3:LifecycleExpiration:DeleteMarkerCreated", "s3:ObjectTagging:*", "s3:ObjectTagging:Put", "s3:ObjectTagging:Delete"
  #   resp.lambda_function_configurations[0].filter.key.filter_rules #=> Array
  #   resp.lambda_function_configurations[0].filter.key.filter_rules[0].name #=> String, one of "prefix", "suffix"
  #   resp.lambda_function_configurations[0].filter.key.filter_rules[0].value #=> String
  # @option params
  # @option params
  # @overload get_bucket_notification_configuration
  # @param params [Hash] ({})
  # @return [Types::NotificationConfiguration] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::NotificationConfiguration#topic_configurations #topic_configurations} => Array&lt;Types::TopicConfiguration&gt;
  #   * {Types::NotificationConfiguration#queue_configurations #queue_configurations} => Array&lt;Types::QueueConfiguration&gt;
  #   * {Types::NotificationConfiguration#lambda_function_configurations #lambda_function_configurations} => Array&lt;Types::LambdaFunctionConfiguration&gt;
  #   * {Types::NotificationConfiguration#event_bridge_configuration #event_bridge_configuration} => Types::EventBridgeConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4778
  def get_bucket_notification_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Retrieves `OwnershipControls` for an Amazon S3 bucket. To use this
  # operation, you must have the `s3:GetBucketOwnershipControls`
  # permission. For more information about Amazon S3 permissions, see
  # [Specifying permissions in a policy][1].
  #
  # For information about Amazon S3 Object Ownership, see [Using Object
  # Ownership][2].
  #
  # The following operations are related to `GetBucketOwnershipControls`\:
  #
  # * PutBucketOwnershipControls
  #
  # * DeleteBucketOwnershipControls
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_ownership_controls({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.ownership_controls.rules #=> Array
  #   resp.ownership_controls.rules[0].object_ownership #=> String, one of "BucketOwnerPreferred", "ObjectWriter", "BucketOwnerEnforced"
  # @option params
  # @option params
  # @overload get_bucket_ownership_controls
  # @param params [Hash] ({})
  # @return [Types::GetBucketOwnershipControlsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketOwnershipControlsOutput#ownership_controls #ownership_controls} => Types::OwnershipControls
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketOwnershipControls AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4831
  def get_bucket_ownership_controls(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the policy of a specified bucket. If you are using an identity
  # other than the root user of the Amazon Web Services account that owns
  # the bucket, the calling identity must have the `GetBucketPolicy`
  # permissions on the specified bucket and belong to the bucket owner's
  # account in order to use this operation.
  #
  # If you don't have `GetBucketPolicy` permissions, Amazon S3 returns a
  # `403 Access Denied` error. If you have the correct permissions, but
  # you're not using an identity that belongs to the bucket owner's
  # account, Amazon S3 returns a `405 Method Not Allowed` error.
  #
  # As a security precaution, the root user of the Amazon Web Services
  # account that owns a bucket can always use this operation, even if the
  # policy explicitly denies the root user the ability to perform this
  # action.
  #
  # For more information about bucket policies, see [Using Bucket Policies
  # and User Policies][1].
  #
  # The following action is related to `GetBucketPolicy`\:
  #
  # * [GetObject][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  #
  # @example Example: To get bucket policy
  #
  #   # The following example returns bucket policy associated with a bucket.
  #
  #   resp = client.get_bucket_policy({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   policy: "{\"Version\":\"2008-10-17\",\"Id\":\"LogPolicy\",\"Statement\":[{\"Sid\":\"Enables the log delivery group to publish logs to your bucket \",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":\"111122223333\"},\"Action\":[\"s3:GetBucketAcl\",\"s3:GetObjectAcl\",\"s3:PutObject\"],\"Resource\":[\"arn:aws:s3:::policytest1/*\",\"arn:aws:s3:::policytest1\"]}]}",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_policy({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.policy #=> String
  # @option params
  # @option params
  # @overload get_bucket_policy
  # @param params [Hash] ({})
  # @return [Types::GetBucketPolicyOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketPolicyOutput#policy #policy} => IO
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4907
  def get_bucket_policy(params = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Retrieves the policy status for an Amazon S3 bucket, indicating
  # whether the bucket is public. In order to use this operation, you must
  # have the `s3:GetBucketPolicyStatus` permission. For more information
  # about Amazon S3 permissions, see [Specifying Permissions in a
  # Policy][1].
  #
  # For more information about when Amazon S3 considers a bucket public,
  # see [The Meaning of "Public"][2].
  #
  # The following operations are related to `GetBucketPolicyStatus`\:
  #
  # * [Using Amazon S3 Block Public Access][3]
  #
  # * [GetPublicAccessBlock][4]
  #
  # * [PutPublicAccessBlock][5]
  #
  # * [DeletePublicAccessBlock][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_policy_status({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.policy_status.is_public #=> Boolean
  # @option params
  # @option params
  # @overload get_bucket_policy_status
  # @param params [Hash] ({})
  # @return [Types::GetBucketPolicyStatusOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketPolicyStatusOutput#policy_status #policy_status} => Types::PolicyStatus
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyStatus AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#4968
  def get_bucket_policy_status(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the replication configuration of a bucket.
  #
  # <note markdown="1"> It can take a while to propagate the put or delete a replication
  # configuration to all Amazon S3 systems. Therefore, a get request soon
  # after put or delete can return a wrong result.
  #
  #  </note>
  #
  # For information about replication configuration, see [Replication][1]
  # in the *Amazon S3 User Guide*.
  #
  # This action requires permissions for the
  # `s3:GetReplicationConfiguration` action. For more information about
  # permissions, see [Using Bucket Policies and User Policies][2].
  #
  # If you include the `Filter` element in a replication configuration,
  # you must also include the `DeleteMarkerReplication` and `Priority`
  # elements. The response also returns those elements.
  #
  # For information about `GetBucketReplication` errors, see [List of
  # replication-related error codes][3]
  #
  # The following operations are related to `GetBucketReplication`\:
  #
  # * [PutBucketReplication][4]
  #
  # * [DeleteBucketReplication][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html
  #
  # @example Example: To get replication configuration set on a bucket
  #
  #   # The following example returns replication configuration set on a bucket.
  #
  #   resp = client.get_bucket_replication({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   replication_configuration: {
  #   role: "arn:aws:iam::acct-id:role/example-role",
  #   rules: [
  #   {
  #   destination: {
  #   bucket: "arn:aws:s3:::destination-bucket",
  #   },
  #   id: "MWIwNTkwZmItMTE3MS00ZTc3LWJkZDEtNzRmODQwYzc1OTQy",
  #   prefix: "Tax",
  #   status: "Enabled",
  #   },
  #   ],
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_replication({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.replication_configuration.role #=> String
  #   resp.replication_configuration.rules #=> Array
  #   resp.replication_configuration.rules[0].id #=> String
  #   resp.replication_configuration.rules[0].priority #=> Integer
  #   resp.replication_configuration.rules[0].prefix #=> String
  #   resp.replication_configuration.rules[0].filter.prefix #=> String
  #   resp.replication_configuration.rules[0].filter.tag.key #=> String
  #   resp.replication_configuration.rules[0].filter.tag.value #=> String
  #   resp.replication_configuration.rules[0].filter.and.prefix #=> String
  #   resp.replication_configuration.rules[0].filter.and.tags #=> Array
  #   resp.replication_configuration.rules[0].filter.and.tags[0].key #=> String
  #   resp.replication_configuration.rules[0].filter.and.tags[0].value #=> String
  #   resp.replication_configuration.rules[0].status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].source_selection_criteria.sse_kms_encrypted_objects.status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].source_selection_criteria.replica_modifications.status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].existing_object_replication.status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].destination.bucket #=> String
  #   resp.replication_configuration.rules[0].destination.account #=> String
  #   resp.replication_configuration.rules[0].destination.storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.replication_configuration.rules[0].destination.access_control_translation.owner #=> String, one of "Destination"
  #   resp.replication_configuration.rules[0].destination.encryption_configuration.replica_kms_key_id #=> String
  #   resp.replication_configuration.rules[0].destination.replication_time.status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].destination.replication_time.time.minutes #=> Integer
  #   resp.replication_configuration.rules[0].destination.metrics.status #=> String, one of "Enabled", "Disabled"
  #   resp.replication_configuration.rules[0].destination.metrics.event_threshold.minutes #=> Integer
  #   resp.replication_configuration.rules[0].delete_marker_replication.status #=> String, one of "Enabled", "Disabled"
  # @option params
  # @option params
  # @overload get_bucket_replication
  # @param params [Hash] ({})
  # @return [Types::GetBucketReplicationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketReplicationOutput#replication_configuration #replication_configuration} => Types::ReplicationConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5087
  def get_bucket_replication(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the request payment configuration of a bucket. To use this
  # version of the operation, you must be the bucket owner. For more
  # information, see [Requester Pays Buckets][1].
  #
  # The following operations are related to `GetBucketRequestPayment`\:
  #
  # * [ListObjects][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html
  #
  # @example Example: To get bucket versioning configuration
  #
  #   # The following example retrieves bucket versioning configuration.
  #
  #   resp = client.get_bucket_request_payment({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   payer: "BucketOwner",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_request_payment({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.payer #=> String, one of "Requester", "BucketOwner"
  # @option params
  # @option params
  # @overload get_bucket_request_payment
  # @param params [Hash] ({})
  # @return [Types::GetBucketRequestPaymentOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketRequestPaymentOutput#payer #payer} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5149
  def get_bucket_request_payment(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the tag set associated with the bucket.
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetBucketTagging` action. By default, the bucket owner has this
  # permission and can grant this permission to others.
  #
  # `GetBucketTagging` has the following special error:
  #
  # * Error code: `NoSuchTagSet`
  #
  #   * Description: There is no tag set associated with the bucket.
  #
  #   ^
  #
  # The following operations are related to `GetBucketTagging`\:
  #
  # * [PutBucketTagging][1]
  #
  # * [DeleteBucketTagging][2]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html
  #
  # @example Example: To get tag set associated with a bucket
  #
  #   # The following example returns tag set associated with a bucket
  #
  #   resp = client.get_bucket_tagging({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   tag_set: [
  #   {
  #   key: "key1",
  #   value: "value1",
  #   },
  #   {
  #   key: "key2",
  #   value: "value2",
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_tagging({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.tag_set #=> Array
  #   resp.tag_set[0].key #=> String
  #   resp.tag_set[0].value #=> String
  # @option params
  # @option params
  # @overload get_bucket_tagging
  # @param params [Hash] ({})
  # @return [Types::GetBucketTaggingOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketTaggingOutput#tag_set #tag_set} => Array&lt;Types::Tag&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5231
  def get_bucket_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the versioning state of a bucket.
  #
  # To retrieve the versioning state of a bucket, you must be the bucket
  # owner.
  #
  # This implementation also returns the MFA Delete status of the
  # versioning state. If the MFA Delete status is `enabled`, the bucket
  # owner must use an authentication device to change the versioning state
  # of the bucket.
  #
  # The following operations are related to `GetBucketVersioning`\:
  #
  # * [GetObject][1]
  #
  # * [PutObject][2]
  #
  # * [DeleteObject][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  #
  # @example Example: To get bucket versioning configuration
  #
  #   # The following example retrieves bucket versioning configuration.
  #
  #   resp = client.get_bucket_versioning({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   mfa_delete: "Disabled",
  #   status: "Enabled",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_versioning({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.status #=> String, one of "Enabled", "Suspended"
  #   resp.mfa_delete #=> String, one of "Enabled", "Disabled"
  # @option params
  # @option params
  # @overload get_bucket_versioning
  # @param params [Hash] ({})
  # @return [Types::GetBucketVersioningOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketVersioningOutput#status #status} => String
  #   * {Types::GetBucketVersioningOutput#mfa_delete #mfa_delete} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5304
  def get_bucket_versioning(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the website configuration for a bucket. To host website on
  # Amazon S3, you can configure a bucket as website by adding a website
  # configuration. For more information about hosting websites, see
  # [Hosting Websites on Amazon S3][1].
  #
  # This GET action requires the `S3:GetBucketWebsite` permission. By
  # default, only the bucket owner can read the bucket website
  # configuration. However, bucket owners can allow other users to read
  # the website configuration by writing a bucket policy granting them the
  # `S3:GetBucketWebsite` permission.
  #
  # The following operations are related to `DeleteBucketWebsite`\:
  #
  # * [DeleteBucketWebsite][2]
  #
  # * [PutBucketWebsite][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html
  #
  # @example Example: To get bucket website configuration
  #
  #   # The following example retrieves website configuration of a bucket.
  #
  #   resp = client.get_bucket_website({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   error_document: {
  #   key: "error.html",
  #   },
  #   index_document: {
  #   suffix: "index.html",
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_bucket_website({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.redirect_all_requests_to.host_name #=> String
  #   resp.redirect_all_requests_to.protocol #=> String, one of "http", "https"
  #   resp.index_document.suffix #=> String
  #   resp.error_document.key #=> String
  #   resp.routing_rules #=> Array
  #   resp.routing_rules[0].condition.http_error_code_returned_equals #=> String
  #   resp.routing_rules[0].condition.key_prefix_equals #=> String
  #   resp.routing_rules[0].redirect.host_name #=> String
  #   resp.routing_rules[0].redirect.http_redirect_code #=> String
  #   resp.routing_rules[0].redirect.protocol #=> String, one of "http", "https"
  #   resp.routing_rules[0].redirect.replace_key_prefix_with #=> String
  #   resp.routing_rules[0].redirect.replace_key_with #=> String
  # @option params
  # @option params
  # @overload get_bucket_website
  # @param params [Hash] ({})
  # @return [Types::GetBucketWebsiteOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetBucketWebsiteOutput#redirect_all_requests_to #redirect_all_requests_to} => Types::RedirectAllRequestsTo
  #   * {Types::GetBucketWebsiteOutput#index_document #index_document} => Types::IndexDocument
  #   * {Types::GetBucketWebsiteOutput#error_document #error_document} => Types::ErrorDocument
  #   * {Types::GetBucketWebsiteOutput#routing_rules #routing_rules} => Array&lt;Types::RoutingRule&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5392
  def get_bucket_website(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Retrieves objects from Amazon S3. To use `GET`, you must have `READ`
  # access to the object. If you grant `READ` access to the anonymous
  # user, you can return the object without using an authorization header.
  #
  # An Amazon S3 bucket has no directory hierarchy such as you would find
  # in a typical computer file system. You can, however, create a logical
  # hierarchy by using object key names that imply a folder structure. For
  # example, instead of naming an object `sample.jpg`, you can name it
  # `photos/2006/February/sample.jpg`.
  #
  # To get an object from such a logical hierarchy, specify the full key
  # name for the object in the `GET` operation. For a virtual hosted-style
  # request example, if you have the object
  # `photos/2006/February/sample.jpg`, specify the resource as
  # `/photos/2006/February/sample.jpg`. For a path-style request example,
  # if you have the object `photos/2006/February/sample.jpg` in the bucket
  # named `examplebucket`, specify the resource as
  # `/examplebucket/photos/2006/February/sample.jpg`. For more information
  # about request types, see [HTTP Host Header Bucket Specification][1].
  #
  # For more information about returning the ACL of an object, see
  # [GetObjectAcl][2].
  #
  # If the object you are retrieving is stored in the S3 Glacier or S3
  # Glacier Deep Archive storage class, or S3 Intelligent-Tiering Archive
  # or S3 Intelligent-Tiering Deep Archive tiers, before you can retrieve
  # the object you must first restore a copy using [RestoreObject][3].
  # Otherwise, this action returns an `InvalidObjectStateError` error. For
  # information about restoring archived objects, see [Restoring Archived
  # Objects][4].
  #
  # Encryption request headers, like `x-amz-server-side-encryption`,
  # should not be sent for GET requests if your object uses server-side
  # encryption with KMS keys (SSE-KMS) or server-side encryption with
  # Amazon S3–managed encryption keys (SSE-S3). If your object does use
  # these types of keys, you’ll get an HTTP 400 BadRequest error.
  #
  # If you encrypt an object by using server-side encryption with
  # customer-provided encryption keys (SSE-C) when you store the object in
  # Amazon S3, then when you GET the object, you must use the following
  # headers:
  #
  # * x-amz-server-side-encryption-customer-algorithm
  #
  # * x-amz-server-side-encryption-customer-key
  #
  # * x-amz-server-side-encryption-customer-key-MD5
  #
  # For more information about SSE-C, see [Server-Side Encryption (Using
  # Customer-Provided Encryption Keys)][5].
  #
  # Assuming you have the relevant permission to read object tags, the
  # response also returns the `x-amz-tagging-count` header that provides
  # the count of number of tags associated with the object. You can use
  # [GetObjectTagging][6] to retrieve the tag set associated with an
  # object.
  #
  # **Permissions**
  #
  # You need the relevant read object (or version) permission for this
  # operation. For more information, see [Specifying Permissions in a
  # Policy][7]. If the object you request does not exist, the error Amazon
  # S3 returns depends on whether you also have the `s3:ListBucket`
  # permission.
  #
  # * If you have the `s3:ListBucket` permission on the bucket, Amazon S3
  #   will return an HTTP status code 404 ("no such key") error.
  #
  # * If you don’t have the `s3:ListBucket` permission, Amazon S3 will
  #   return an HTTP status code 403 ("access denied") error.
  #
  # **Versioning**
  #
  # By default, the GET action returns the current version of an object.
  # To return a different version, use the `versionId` subresource.
  #
  # <note markdown="1"> * If you supply a `versionId`, you need the `s3:GetObjectVersion`
  #   permission to access a specific version of an object. If you request
  #   a specific version, you do not need to have the `s3:GetObject`
  #   permission.
  #
  # * If the current version of the object is a delete marker, Amazon S3
  #   behaves as if the object was deleted and includes
  #   `x-amz-delete-marker: true` in the response.
  #
  #  </note>
  #
  # For more information about versioning, see [PutBucketVersioning][8].
  #
  # **Overriding Response Header Values**
  #
  # There are times when you want to override certain response header
  # values in a GET response. For example, you might override the
  # `Content-Disposition` response header value in your GET request.
  #
  # You can override values for a set of response headers using the
  # following query parameters. These response header values are sent only
  # on a successful request, that is, when status code 200 OK is returned.
  # The set of headers you can override using these parameters is a subset
  # of the headers that Amazon S3 accepts when you create an object. The
  # response headers that you can override for the GET response are
  # `Content-Type`, `Content-Language`, `Expires`, `Cache-Control`,
  # `Content-Disposition`, and `Content-Encoding`. To override these
  # header values in the GET response, you use the following request
  # parameters.
  #
  # <note markdown="1"> You must sign the request, either using an Authorization header or a
  # presigned URL, when using these parameters. They cannot be used with
  # an unsigned (anonymous) request.
  #
  #  </note>
  #
  # * `response-content-type`
  #
  # * `response-content-language`
  #
  # * `response-expires`
  #
  # * `response-cache-control`
  #
  # * `response-content-disposition`
  #
  # * `response-content-encoding`
  #
  # **Additional Considerations about Request Headers**
  #
  # If both of the `If-Match` and `If-Unmodified-Since` headers are
  # present in the request as follows: `If-Match` condition evaluates to
  # `true`, and; `If-Unmodified-Since` condition evaluates to `false`;
  # then, S3 returns 200 OK and the data requested.
  #
  # If both of the `If-None-Match` and `If-Modified-Since` headers are
  # present in the request as follows:` If-None-Match` condition evaluates
  # to `false`, and; `If-Modified-Since` condition evaluates to `true`;
  # then, S3 returns 304 Not Modified response code.
  #
  # For more information about conditional requests, see [RFC 7232][9].
  #
  # The following operations are related to `GetObject`\:
  #
  # * [ListBuckets][10]
  #
  # * [GetObjectAcl][2]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html
  # [9]: https://tools.ietf.org/html/rfc7232
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html
  #
  # @example Example: To retrieve an object
  #
  #   # The following example retrieves an object for an S3 bucket.
  #
  #   resp = client.get_object({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   accept_ranges: "bytes",
  #   content_length: 3191,
  #   content_type: "image/jpeg",
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   last_modified: Time.parse("Thu, 15 Dec 2016 01:19:41 GMT"),
  #   metadata: {
  #   },
  #   tag_count: 2,
  #   version_id: "null",
  #   }
  # @example Example: To retrieve a byte range of an object
  #
  #   # The following example retrieves an object for an S3 bucket. The request specifies the range header to retrieve a
  #   # specific byte range.
  #
  #   resp = client.get_object({
  #   bucket: "examplebucket",
  #   key: "SampleFile.txt",
  #   range: "bytes=0-9",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   accept_ranges: "bytes",
  #   content_length: 10,
  #   content_range: "bytes 0-9/43",
  #   content_type: "text/plain",
  #   etag: "\"0d94420ffd0bc68cd3d152506b97a9cc\"",
  #   last_modified: Time.parse("Thu, 09 Oct 2014 22:57:28 GMT"),
  #   metadata: {
  #   },
  #   version_id: "null",
  #   }
  # @example Download an object to disk
  #   # stream object directly to disk
  #   resp = s3.get_object(
  #   response_target: '/path/to/file',
  #   bucket: 'bucket-name',
  #   key: 'object-key')
  #
  #   # you can still access other response data
  #   resp.metadata #=> { ... }
  #   resp.etag #=> "..."
  # @example Download object into memory
  #   # omit :response_target to download to a StringIO in memory
  #   resp = s3.get_object(bucket: 'bucket-name', key: 'object-key')
  #
  #   # call #read or #string on the response body
  #   resp.body.read
  #   #=> '...'
  # @example Streaming data to a block
  #   # WARNING: yielding data to a block disables retries of networking errors
  #   # However truncation of the body will be retried automatically using a range request
  #   File.open('/path/to/file', 'wb') do |file|
  #   s3.get_object(bucket: 'bucket-name', key: 'object-key') do |chunk, headers|
  #   # headers['content-length']
  #   file.write(chunk)
  #   end
  #   end
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object({
  #   bucket: "BucketName", # required
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   key: "ObjectKey", # required
  #   range: "Range",
  #   response_cache_control: "ResponseCacheControl",
  #   response_content_disposition: "ResponseContentDisposition",
  #   response_content_encoding: "ResponseContentEncoding",
  #   response_content_language: "ResponseContentLanguage",
  #   response_content_type: "ResponseContentType",
  #   response_expires: Time.now,
  #   version_id: "ObjectVersionId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @example Response structure
  #
  #   resp.body #=> IO
  #   resp.delete_marker #=> Boolean
  #   resp.accept_ranges #=> String
  #   resp.expiration #=> String
  #   resp.restore #=> String
  #   resp.last_modified #=> Time
  #   resp.content_length #=> Integer
  #   resp.etag #=> String
  #   resp.checksum_crc32 #=> String
  #   resp.checksum_crc32c #=> String
  #   resp.checksum_sha1 #=> String
  #   resp.checksum_sha256 #=> String
  #   resp.missing_meta #=> Integer
  #   resp.version_id #=> String
  #   resp.cache_control #=> String
  #   resp.content_disposition #=> String
  #   resp.content_encoding #=> String
  #   resp.content_language #=> String
  #   resp.content_range #=> String
  #   resp.content_type #=> String
  #   resp.expires #=> Time
  #   resp.expires_string #=> String
  #   resp.website_redirect_location #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.metadata #=> Hash
  #   resp.metadata["MetadataKey"] #=> String
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.request_charged #=> String, one of "requester"
  #   resp.replication_status #=> String, one of "COMPLETE", "PENDING", "FAILED", "REPLICA"
  #   resp.parts_count #=> Integer
  #   resp.tag_count #=> Integer
  #   resp.object_lock_mode #=> String, one of "GOVERNANCE", "COMPLIANCE"
  #   resp.object_lock_retain_until_date #=> Time
  #   resp.object_lock_legal_hold_status #=> String, one of "ON", "OFF"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object
  # @param params [Hash] ({})
  # @return [Types::GetObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectOutput#body #body} => IO
  #   * {Types::GetObjectOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::GetObjectOutput#accept_ranges #accept_ranges} => String
  #   * {Types::GetObjectOutput#expiration #expiration} => String
  #   * {Types::GetObjectOutput#restore #restore} => String
  #   * {Types::GetObjectOutput#last_modified #last_modified} => Time
  #   * {Types::GetObjectOutput#content_length #content_length} => Integer
  #   * {Types::GetObjectOutput#etag #etag} => String
  #   * {Types::GetObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::GetObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::GetObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::GetObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::GetObjectOutput#missing_meta #missing_meta} => Integer
  #   * {Types::GetObjectOutput#version_id #version_id} => String
  #   * {Types::GetObjectOutput#cache_control #cache_control} => String
  #   * {Types::GetObjectOutput#content_disposition #content_disposition} => String
  #   * {Types::GetObjectOutput#content_encoding #content_encoding} => String
  #   * {Types::GetObjectOutput#content_language #content_language} => String
  #   * {Types::GetObjectOutput#content_range #content_range} => String
  #   * {Types::GetObjectOutput#content_type #content_type} => String
  #   * {Types::GetObjectOutput#expires #expires} => Time
  #   * {Types::GetObjectOutput#expires_string #expires_string} => String
  #   * {Types::GetObjectOutput#website_redirect_location #website_redirect_location} => String
  #   * {Types::GetObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::GetObjectOutput#metadata #metadata} => Hash&lt;String,String&gt;
  #   * {Types::GetObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::GetObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::GetObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::GetObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::GetObjectOutput#storage_class #storage_class} => String
  #   * {Types::GetObjectOutput#request_charged #request_charged} => String
  #   * {Types::GetObjectOutput#replication_status #replication_status} => String
  #   * {Types::GetObjectOutput#parts_count #parts_count} => Integer
  #   * {Types::GetObjectOutput#tag_count #tag_count} => Integer
  #   * {Types::GetObjectOutput#object_lock_mode #object_lock_mode} => String
  #   * {Types::GetObjectOutput#object_lock_retain_until_date #object_lock_retain_until_date} => Time
  #   * {Types::GetObjectOutput#object_lock_legal_hold_status #object_lock_legal_hold_status} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#5867
  def get_object(params = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Returns the access control list (ACL) of an object. To use this
  # operation, you must have `s3:GetObjectAcl` permissions or `READ_ACP`
  # access to the object. For more information, see [Mapping of ACL
  # permissions and access policy permissions][1] in the *Amazon S3 User
  # Guide*
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # **Versioning**
  #
  # By default, GET returns ACL information about the current version of
  # an object. To return ACL information about a different version, use
  # the versionId subresource.
  #
  # <note markdown="1"> If your bucket uses the bucket owner enforced setting for S3 Object
  # Ownership, requests to read ACLs are still supported and return the
  # `bucket-owner-full-control` ACL with the owner being the account that
  # created the bucket. For more information, see [ Controlling object
  # ownership and disabling ACLs][2] in the *Amazon S3 User Guide*.
  #
  #  </note>
  #
  # The following operations are related to `GetObjectAcl`\:
  #
  # * [GetObject][3]
  #
  # * [GetObjectAttributes][4]
  #
  # * [DeleteObject][5]
  #
  # * [PutObject][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#acl-access-policy-permission-mapping
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  #
  # @example Example: To retrieve object ACL
  #
  #   # The following example retrieves access control list (ACL) of an object.
  #
  #   resp = client.get_object_acl({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   grants: [
  #   {
  #   grantee: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   type: "CanonicalUser",
  #   },
  #   permission: "WRITE",
  #   },
  #   {
  #   grantee: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   type: "CanonicalUser",
  #   },
  #   permission: "WRITE_ACP",
  #   },
  #   {
  #   grantee: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   type: "CanonicalUser",
  #   },
  #   permission: "READ",
  #   },
  #   {
  #   grantee: {
  #   display_name: "owner-display-name",
  #   id: "852b113eexamplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   type: "CanonicalUser",
  #   },
  #   permission: "READ_ACP",
  #   },
  #   ],
  #   owner: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_acl({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.owner.display_name #=> String
  #   resp.owner.id #=> String
  #   resp.grants #=> Array
  #   resp.grants[0].grantee.display_name #=> String
  #   resp.grants[0].grantee.email_address #=> String
  #   resp.grants[0].grantee.id #=> String
  #   resp.grants[0].grantee.type #=> String, one of "CanonicalUser", "AmazonCustomerByEmail", "Group"
  #   resp.grants[0].grantee.uri #=> String
  #   resp.grants[0].permission #=> String, one of "FULL_CONTROL", "WRITE", "WRITE_ACP", "READ", "READ_ACP"
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_acl
  # @param params [Hash] ({})
  # @return [Types::GetObjectAclOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectAclOutput#owner #owner} => Types::Owner
  #   * {Types::GetObjectAclOutput#grants #grants} => Array&lt;Types::Grant&gt;
  #   * {Types::GetObjectAclOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6036
  def get_object_acl(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Retrieves all the metadata from an object without returning the object
  # itself. This action is useful if you're interested only in an
  # object's metadata. To use `GetObjectAttributes`, you must have READ
  # access to the object.
  #
  # `GetObjectAttributes` combines the functionality of `GetObjectAcl`,
  # `GetObjectLegalHold`, `GetObjectLockConfiguration`,
  # `GetObjectRetention`, `GetObjectTagging`, `HeadObject`, and
  # `ListParts`. All of the data returned with each of those individual
  # calls can be returned with a single call to `GetObjectAttributes`.
  #
  # If you encrypt an object by using server-side encryption with
  # customer-provided encryption keys (SSE-C) when you store the object in
  # Amazon S3, then when you retrieve the metadata from the object, you
  # must use the following headers:
  #
  # * `x-amz-server-side-encryption-customer-algorithm`
  #
  # * `x-amz-server-side-encryption-customer-key`
  #
  # * `x-amz-server-side-encryption-customer-key-MD5`
  #
  # For more information about SSE-C, see [Server-Side Encryption (Using
  # Customer-Provided Encryption Keys)][1] in the *Amazon S3 User Guide*.
  #
  # <note markdown="1"> * Encryption request headers, such as `x-amz-server-side-encryption`,
  #   should not be sent for GET requests if your object uses server-side
  #   encryption with Amazon Web Services KMS keys stored in Amazon Web
  #   Services Key Management Service (SSE-KMS) or server-side encryption
  #   with Amazon S3 managed encryption keys (SSE-S3). If your object does
  #   use these types of keys, you'll get an HTTP `400 Bad Request`
  #   error.
  #
  # * The last modified property in this case is the creation date of the
  #   object.
  #
  #  </note>
  #
  # Consider the following when using request headers:
  #
  # * If both of the `If-Match` and `If-Unmodified-Since` headers are
  #   present in the request as follows, then Amazon S3 returns the HTTP
  #   status code `200 OK` and the data requested:
  #
  #   * `If-Match` condition evaluates to `true`.
  #
  #   * `If-Unmodified-Since` condition evaluates to `false`.
  #
  # * If both of the `If-None-Match` and `If-Modified-Since` headers are
  #   present in the request as follows, then Amazon S3 returns the HTTP
  #   status code `304 Not Modified`\:
  #
  #   * `If-None-Match` condition evaluates to `false`.
  #
  #   * `If-Modified-Since` condition evaluates to `true`.
  #
  # For more information about conditional requests, see [RFC 7232][2].
  #
  # **Permissions**
  #
  # The permissions that you need to use this operation depend on whether
  # the bucket is versioned. If the bucket is versioned, you need both the
  # `s3:GetObjectVersion` and `s3:GetObjectVersionAttributes` permissions
  # for this operation. If the bucket is not versioned, you need the
  # `s3:GetObject` and `s3:GetObjectAttributes` permissions. For more
  # information, see [Specifying Permissions in a Policy][3] in the
  # *Amazon S3 User Guide*. If the object that you request does not exist,
  # the error Amazon S3 returns depends on whether you also have the
  # `s3:ListBucket` permission.
  #
  # * If you have the `s3:ListBucket` permission on the bucket, Amazon S3
  #   returns an HTTP status code `404 Not Found` ("no such key") error.
  #
  # * If you don't have the `s3:ListBucket` permission, Amazon S3 returns
  #   an HTTP status code `403 Forbidden` ("access denied") error.
  #
  # The following actions are related to `GetObjectAttributes`\:
  #
  # * [GetObject][4]
  #
  # * [GetObjectAcl][5]
  #
  # * [GetObjectLegalHold][6]
  #
  # * [GetObjectLockConfiguration][7]
  #
  # * [GetObjectRetention][8]
  #
  # * [GetObjectTagging][9]
  #
  # * [HeadObject][10]
  #
  # * [ListParts][11]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html
  # [2]: https://tools.ietf.org/html/rfc7232
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLockConfiguration.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadObject.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_attributes({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   max_parts: 1,
  #   part_number_marker: 1,
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   object_attributes: ["ETag"], # required, accepts ETag, Checksum, ObjectParts, StorageClass, ObjectSize
  #   })
  # @example Response structure
  #
  #   resp.delete_marker #=> Boolean
  #   resp.last_modified #=> Time
  #   resp.version_id #=> String
  #   resp.request_charged #=> String, one of "requester"
  #   resp.etag #=> String
  #   resp.checksum.checksum_crc32 #=> String
  #   resp.checksum.checksum_crc32c #=> String
  #   resp.checksum.checksum_sha1 #=> String
  #   resp.checksum.checksum_sha256 #=> String
  #   resp.object_parts.total_parts_count #=> Integer
  #   resp.object_parts.part_number_marker #=> Integer
  #   resp.object_parts.next_part_number_marker #=> Integer
  #   resp.object_parts.max_parts #=> Integer
  #   resp.object_parts.is_truncated #=> Boolean
  #   resp.object_parts.parts #=> Array
  #   resp.object_parts.parts[0].part_number #=> Integer
  #   resp.object_parts.parts[0].size #=> Integer
  #   resp.object_parts.parts[0].checksum_crc32 #=> String
  #   resp.object_parts.parts[0].checksum_crc32c #=> String
  #   resp.object_parts.parts[0].checksum_sha1 #=> String
  #   resp.object_parts.parts[0].checksum_sha256 #=> String
  #   resp.storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.object_size #=> Integer
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_attributes
  # @param params [Hash] ({})
  # @return [Types::GetObjectAttributesOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectAttributesOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::GetObjectAttributesOutput#last_modified #last_modified} => Time
  #   * {Types::GetObjectAttributesOutput#version_id #version_id} => String
  #   * {Types::GetObjectAttributesOutput#request_charged #request_charged} => String
  #   * {Types::GetObjectAttributesOutput#etag #etag} => String
  #   * {Types::GetObjectAttributesOutput#checksum #checksum} => Types::Checksum
  #   * {Types::GetObjectAttributesOutput#object_parts #object_parts} => Types::GetObjectAttributesParts
  #   * {Types::GetObjectAttributesOutput#storage_class #storage_class} => String
  #   * {Types::GetObjectAttributesOutput#object_size #object_size} => Integer
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributes AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6282
  def get_object_attributes(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets an object's current legal hold status. For more information, see
  # [Locking Objects][1].
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # The following action is related to `GetObjectLegalHold`\:
  #
  # * [GetObjectAttributes][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_legal_hold({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.legal_hold.status #=> String, one of "ON", "OFF"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_legal_hold
  # @param params [Hash] ({})
  # @return [Types::GetObjectLegalHoldOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectLegalHoldOutput#legal_hold #legal_hold} => Types::ObjectLockLegalHold
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLegalHold AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6365
  def get_object_legal_hold(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets the Object Lock configuration for a bucket. The rule specified in
  # the Object Lock configuration will be applied by default to every new
  # object placed in the specified bucket. For more information, see
  # [Locking Objects][1].
  #
  # The following action is related to `GetObjectLockConfiguration`\:
  #
  # * [GetObjectAttributes][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_lock_configuration({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.object_lock_configuration.object_lock_enabled #=> String, one of "Enabled"
  #   resp.object_lock_configuration.rule.default_retention.mode #=> String, one of "GOVERNANCE", "COMPLIANCE"
  #   resp.object_lock_configuration.rule.default_retention.days #=> Integer
  #   resp.object_lock_configuration.rule.default_retention.years #=> Integer
  # @option params
  # @option params
  # @overload get_object_lock_configuration
  # @param params [Hash] ({})
  # @return [Types::GetObjectLockConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectLockConfigurationOutput#object_lock_configuration #object_lock_configuration} => Types::ObjectLockConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLockConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6428
  def get_object_lock_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Retrieves an object's retention settings. For more information, see
  # [Locking Objects][1].
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # The following action is related to `GetObjectRetention`\:
  #
  # * [GetObjectAttributes][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_retention({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.retention.mode #=> String, one of "GOVERNANCE", "COMPLIANCE"
  #   resp.retention.retain_until_date #=> Time
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_retention
  # @param params [Hash] ({})
  # @return [Types::GetObjectRetentionOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectRetentionOutput#retention #retention} => Types::ObjectLockRetention
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRetention AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6512
  def get_object_retention(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the tag-set of an object. You send the GET request against the
  # tagging subresource associated with the object.
  #
  # To use this operation, you must have permission to perform the
  # `s3:GetObjectTagging` action. By default, the GET action returns
  # information about current version of an object. For a versioned
  # bucket, you can have multiple versions of an object in your bucket. To
  # retrieve tags of any other version, use the versionId query parameter.
  # You also need permission for the `s3:GetObjectVersionTagging` action.
  #
  # By default, the bucket owner has this permission and can grant this
  # permission to others.
  #
  # For information about the Amazon S3 object tagging feature, see
  # [Object Tagging][1].
  #
  # The following actions are related to `GetObjectTagging`\:
  #
  # * [DeleteObjectTagging][2]
  #
  # * [GetObjectAttributes][3]
  #
  # * [PutObjectTagging][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html
  #
  # @example Example: To retrieve tag set of an object
  #
  #   # The following example retrieves tag set of an object.
  #
  #   resp = client.get_object_tagging({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   tag_set: [
  #   {
  #   key: "Key4",
  #   value: "Value4",
  #   },
  #   {
  #   key: "Key3",
  #   value: "Value3",
  #   },
  #   ],
  #   version_id: "null",
  #   }
  # @example Example: To retrieve tag set of a specific object version
  #
  #   # The following example retrieves tag set of an object. The request specifies object version.
  #
  #   resp = client.get_object_tagging({
  #   bucket: "examplebucket",
  #   key: "exampleobject",
  #   version_id: "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   tag_set: [
  #   {
  #   key: "Key1",
  #   value: "Value1",
  #   },
  #   ],
  #   version_id: "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_tagging({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   expected_bucket_owner: "AccountId",
  #   request_payer: "requester", # accepts requester
  #   })
  # @example Response structure
  #
  #   resp.version_id #=> String
  #   resp.tag_set #=> Array
  #   resp.tag_set[0].key #=> String
  #   resp.tag_set[0].value #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_tagging
  # @param params [Hash] ({})
  # @return [Types::GetObjectTaggingOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectTaggingOutput#version_id #version_id} => String
  #   * {Types::GetObjectTaggingOutput#tag_set #tag_set} => Array&lt;Types::Tag&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6668
  def get_object_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns torrent files from a bucket. BitTorrent can save you bandwidth
  # when you're distributing large files. For more information about
  # BitTorrent, see [Using BitTorrent with Amazon S3][1].
  #
  # <note markdown="1"> You can get torrent only for objects that are less than 5 GB in size,
  # and that are not encrypted using server-side encryption with a
  # customer-provided encryption key.
  #
  #  </note>
  #
  # To use GET, you must have READ access to the object.
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # The following action is related to `GetObjectTorrent`\:
  #
  # * [GetObject][2]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  #
  # @example Example: To retrieve torrent files for an object
  #
  #   # The following example retrieves torrent files of an object.
  #
  #   resp = client.get_object_torrent({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_object_torrent({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.body #=> IO
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_object_torrent
  # @param params [Hash] ({})
  # @return [Types::GetObjectTorrentOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectTorrentOutput#body #body} => IO
  #   * {Types::GetObjectTorrentOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6761
  def get_object_torrent(params = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Retrieves the `PublicAccessBlock` configuration for an Amazon S3
  # bucket. To use this operation, you must have the
  # `s3:GetBucketPublicAccessBlock` permission. For more information about
  # Amazon S3 permissions, see [Specifying Permissions in a Policy][1].
  #
  # When Amazon S3 evaluates the `PublicAccessBlock` configuration for a
  # bucket or an object, it checks the `PublicAccessBlock` configuration
  # for both the bucket (or the bucket that contains the object) and the
  # bucket owner's account. If the `PublicAccessBlock` settings are
  # different between the bucket and the account, Amazon S3 uses the most
  # restrictive combination of the bucket-level and account-level
  # settings.
  #
  # For more information about when Amazon S3 considers a bucket or an
  # object public, see [The Meaning of "Public"][2].
  #
  # The following operations are related to `GetPublicAccessBlock`\:
  #
  # * [Using Amazon S3 Block Public Access][3]
  #
  # * [PutPublicAccessBlock][4]
  #
  # * [GetPublicAccessBlock][5]
  #
  # * [DeletePublicAccessBlock][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_public_access_block({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.public_access_block_configuration.block_public_acls #=> Boolean
  #   resp.public_access_block_configuration.ignore_public_acls #=> Boolean
  #   resp.public_access_block_configuration.block_public_policy #=> Boolean
  #   resp.public_access_block_configuration.restrict_public_buckets #=> Boolean
  # @option params
  # @option params
  # @overload get_public_access_block
  # @param params [Hash] ({})
  # @return [Types::GetPublicAccessBlockOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetPublicAccessBlockOutput#public_access_block_configuration #public_access_block_configuration} => Types::PublicAccessBlockConfiguration
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlock AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6832
  def get_public_access_block(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action is useful to determine if a bucket exists and you have
  # permission to access it. The action returns a `200 OK` if the bucket
  # exists and you have permission to access it.
  #
  # If the bucket does not exist or you do not have permission to access
  # it, the `HEAD` request returns a generic `404 Not Found` or `403
  # Forbidden` code. A message body is not included, so you cannot
  # determine the exception beyond these error codes.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:ListBucket` action. The bucket owner has this permission by
  # default and can grant this permission to others. For more information
  # about permissions, see [Permissions Related to Bucket Subresource
  # Operations][1] and [Managing Access Permissions to Your Amazon S3
  # Resources][2].
  #
  # To use this API against an access point, you must provide the alias of
  # the access point in place of the bucket name or specify the access
  # point ARN. When using the access point ARN, you must direct requests
  # to the access point hostname. The access point hostname takes the form
  # AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When
  # using the Amazon Web Services SDKs, you provide the ARN in place of
  # the bucket name. For more information see, [Using access points][3].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html
  #
  # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
  #
  #   * bucket_exists
  #   * bucket_not_exists
  #
  # @example Example: To determine if bucket exists
  #
  #   # This operation checks to see if a bucket exists.
  #
  #   resp = client.head_bucket({
  #   bucket: "acl1",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.head_bucket({
  #   bucket: "BucketName", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @overload head_bucket
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#6925
  def head_bucket(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # The HEAD action retrieves metadata from an object without returning
  # the object itself. This action is useful if you're only interested in
  # an object's metadata. To use HEAD, you must have READ access to the
  # object.
  #
  # A `HEAD` request has the same options as a `GET` action on an object.
  # The response is identical to the `GET` response except that there is
  # no response body. Because of this, if the `HEAD` request generates an
  # error, it returns a generic `404 Not Found` or `403 Forbidden` code.
  # It is not possible to retrieve the exact exception beyond these error
  # codes.
  #
  # If you encrypt an object by using server-side encryption with
  # customer-provided encryption keys (SSE-C) when you store the object in
  # Amazon S3, then when you retrieve the metadata from the object, you
  # must use the following headers:
  #
  # * x-amz-server-side-encryption-customer-algorithm
  #
  # * x-amz-server-side-encryption-customer-key
  #
  # * x-amz-server-side-encryption-customer-key-MD5
  #
  # For more information about SSE-C, see [Server-Side Encryption (Using
  # Customer-Provided Encryption Keys)][1].
  #
  # <note markdown="1"> * Encryption request headers, like `x-amz-server-side-encryption`,
  #   should not be sent for GET requests if your object uses server-side
  #   encryption with KMS keys (SSE-KMS) or server-side encryption with
  #   Amazon S3–managed encryption keys (SSE-S3). If your object does use
  #   these types of keys, you’ll get an HTTP 400 BadRequest error.
  #
  # * The last modified property in this case is the creation date of the
  #   object.
  #
  #  </note>
  #
  # Request headers are limited to 8 KB in size. For more information, see
  # [Common Request Headers][2].
  #
  # Consider the following when using request headers:
  #
  # * Consideration 1 – If both of the `If-Match` and
  #   `If-Unmodified-Since` headers are present in the request as follows:
  #
  #   * `If-Match` condition evaluates to `true`, and;
  #
  #   * `If-Unmodified-Since` condition evaluates to `false`;
  #
  #   Then Amazon S3 returns `200 OK` and the data requested.
  #
  # * Consideration 2 – If both of the `If-None-Match` and
  #   `If-Modified-Since` headers are present in the request as follows:
  #
  #   * `If-None-Match` condition evaluates to `false`, and;
  #
  #   * `If-Modified-Since` condition evaluates to `true`;
  #
  #   Then Amazon S3 returns the `304 Not Modified` response code.
  #
  # For more information about conditional requests, see [RFC 7232][3].
  #
  # **Permissions**
  #
  # You need the relevant read object (or version) permission for this
  # operation. For more information, see [Specifying Permissions in a
  # Policy][4]. If the object you request does not exist, the error Amazon
  # S3 returns depends on whether you also have the s3:ListBucket
  # permission.
  #
  # * If you have the `s3:ListBucket` permission on the bucket, Amazon S3
  #   returns an HTTP status code 404 ("no such key") error.
  #
  # * If you don’t have the `s3:ListBucket` permission, Amazon S3 returns
  #   an HTTP status code 403 ("access denied") error.
  #
  # The following actions are related to `HeadObject`\:
  #
  # * [GetObject][5]
  #
  # * [GetObjectAttributes][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html
  # [3]: https://tools.ietf.org/html/rfc7232
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  #
  # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
  #
  #   * object_exists
  #   * object_not_exists
  #
  # @example Example: To retrieve metadata of an object without returning the object itself
  #
  #   # The following example retrieves an object metadata.
  #
  #   resp = client.head_object({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   accept_ranges: "bytes",
  #   content_length: 3191,
  #   content_type: "image/jpeg",
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   last_modified: Time.parse("Thu, 15 Dec 2016 01:19:41 GMT"),
  #   metadata: {
  #   },
  #   version_id: "null",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.head_object({
  #   bucket: "BucketName", # required
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   key: "ObjectKey", # required
  #   range: "Range",
  #   version_id: "ObjectVersionId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @example Response structure
  #
  #   resp.delete_marker #=> Boolean
  #   resp.accept_ranges #=> String
  #   resp.expiration #=> String
  #   resp.restore #=> String
  #   resp.archive_status #=> String, one of "ARCHIVE_ACCESS", "DEEP_ARCHIVE_ACCESS"
  #   resp.last_modified #=> Time
  #   resp.content_length #=> Integer
  #   resp.checksum_crc32 #=> String
  #   resp.checksum_crc32c #=> String
  #   resp.checksum_sha1 #=> String
  #   resp.checksum_sha256 #=> String
  #   resp.etag #=> String
  #   resp.missing_meta #=> Integer
  #   resp.version_id #=> String
  #   resp.cache_control #=> String
  #   resp.content_disposition #=> String
  #   resp.content_encoding #=> String
  #   resp.content_language #=> String
  #   resp.content_type #=> String
  #   resp.expires #=> Time
  #   resp.expires_string #=> String
  #   resp.website_redirect_location #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.metadata #=> Hash
  #   resp.metadata["MetadataKey"] #=> String
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.request_charged #=> String, one of "requester"
  #   resp.replication_status #=> String, one of "COMPLETE", "PENDING", "FAILED", "REPLICA"
  #   resp.parts_count #=> Integer
  #   resp.object_lock_mode #=> String, one of "GOVERNANCE", "COMPLIANCE"
  #   resp.object_lock_retain_until_date #=> Time
  #   resp.object_lock_legal_hold_status #=> String, one of "ON", "OFF"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload head_object
  # @param params [Hash] ({})
  # @return [Types::HeadObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::HeadObjectOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::HeadObjectOutput#accept_ranges #accept_ranges} => String
  #   * {Types::HeadObjectOutput#expiration #expiration} => String
  #   * {Types::HeadObjectOutput#restore #restore} => String
  #   * {Types::HeadObjectOutput#archive_status #archive_status} => String
  #   * {Types::HeadObjectOutput#last_modified #last_modified} => Time
  #   * {Types::HeadObjectOutput#content_length #content_length} => Integer
  #   * {Types::HeadObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::HeadObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::HeadObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::HeadObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::HeadObjectOutput#etag #etag} => String
  #   * {Types::HeadObjectOutput#missing_meta #missing_meta} => Integer
  #   * {Types::HeadObjectOutput#version_id #version_id} => String
  #   * {Types::HeadObjectOutput#cache_control #cache_control} => String
  #   * {Types::HeadObjectOutput#content_disposition #content_disposition} => String
  #   * {Types::HeadObjectOutput#content_encoding #content_encoding} => String
  #   * {Types::HeadObjectOutput#content_language #content_language} => String
  #   * {Types::HeadObjectOutput#content_type #content_type} => String
  #   * {Types::HeadObjectOutput#expires #expires} => Time
  #   * {Types::HeadObjectOutput#expires_string #expires_string} => String
  #   * {Types::HeadObjectOutput#website_redirect_location #website_redirect_location} => String
  #   * {Types::HeadObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::HeadObjectOutput#metadata #metadata} => Hash&lt;String,String&gt;
  #   * {Types::HeadObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::HeadObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::HeadObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::HeadObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::HeadObjectOutput#storage_class #storage_class} => String
  #   * {Types::HeadObjectOutput#request_charged #request_charged} => String
  #   * {Types::HeadObjectOutput#replication_status #replication_status} => String
  #   * {Types::HeadObjectOutput#parts_count #parts_count} => Integer
  #   * {Types::HeadObjectOutput#object_lock_mode #object_lock_mode} => String
  #   * {Types::HeadObjectOutput#object_lock_retain_until_date #object_lock_retain_until_date} => Time
  #   * {Types::HeadObjectOutput#object_lock_legal_hold_status #object_lock_legal_hold_status} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7247
  def head_object(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists the analytics configurations for the bucket. You can have up to
  # 1,000 analytics configurations per bucket.
  #
  # This action supports list pagination and does not return more than 100
  # configurations at a time. You should always check the `IsTruncated`
  # element in the response. If there are no more configurations to list,
  # `IsTruncated` is set to false. If there are more configurations to
  # list, `IsTruncated` is set to true, and there will be a value in
  # `NextContinuationToken`. You use the `NextContinuationToken` value to
  # continue the pagination of the list by passing the value in
  # continuation-token in the request to `GET` the next page.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetAnalyticsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about Amazon S3 analytics feature, see [Amazon S3
  # Analytics – Storage Class Analysis][3].
  #
  # The following operations are related to
  # `ListBucketAnalyticsConfigurations`\:
  #
  # * [GetBucketAnalyticsConfiguration][4]
  #
  # * [DeleteBucketAnalyticsConfiguration][5]
  #
  # * [PutBucketAnalyticsConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_bucket_analytics_configurations({
  #   bucket: "BucketName", # required
  #   continuation_token: "Token",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.continuation_token #=> String
  #   resp.next_continuation_token #=> String
  #   resp.analytics_configuration_list #=> Array
  #   resp.analytics_configuration_list[0].id #=> String
  #   resp.analytics_configuration_list[0].filter.prefix #=> String
  #   resp.analytics_configuration_list[0].filter.tag.key #=> String
  #   resp.analytics_configuration_list[0].filter.tag.value #=> String
  #   resp.analytics_configuration_list[0].filter.and.prefix #=> String
  #   resp.analytics_configuration_list[0].filter.and.tags #=> Array
  #   resp.analytics_configuration_list[0].filter.and.tags[0].key #=> String
  #   resp.analytics_configuration_list[0].filter.and.tags[0].value #=> String
  #   resp.analytics_configuration_list[0].storage_class_analysis.data_export.output_schema_version #=> String, one of "V_1"
  #   resp.analytics_configuration_list[0].storage_class_analysis.data_export.destination.s3_bucket_destination.format #=> String, one of "CSV"
  #   resp.analytics_configuration_list[0].storage_class_analysis.data_export.destination.s3_bucket_destination.bucket_account_id #=> String
  #   resp.analytics_configuration_list[0].storage_class_analysis.data_export.destination.s3_bucket_destination.bucket #=> String
  #   resp.analytics_configuration_list[0].storage_class_analysis.data_export.destination.s3_bucket_destination.prefix #=> String
  # @option params
  # @option params
  # @option params
  # @overload list_bucket_analytics_configurations
  # @param params [Hash] ({})
  # @return [Types::ListBucketAnalyticsConfigurationsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListBucketAnalyticsConfigurationsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListBucketAnalyticsConfigurationsOutput#continuation_token #continuation_token} => String
  #   * {Types::ListBucketAnalyticsConfigurationsOutput#next_continuation_token #next_continuation_token} => String
  #   * {Types::ListBucketAnalyticsConfigurationsOutput#analytics_configuration_list #analytics_configuration_list} => Array&lt;Types::AnalyticsConfiguration&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7344
  def list_bucket_analytics_configurations(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists the S3 Intelligent-Tiering configuration from the specified
  # bucket.
  #
  # The S3 Intelligent-Tiering storage class is designed to optimize
  # storage costs by automatically moving data to the most cost-effective
  # storage access tier, without performance impact or operational
  # overhead. S3 Intelligent-Tiering delivers automatic cost savings in
  # three low latency and high throughput access tiers. To get the lowest
  # storage cost on data that can be accessed in minutes to hours, you can
  # choose to activate additional archiving capabilities.
  #
  # The S3 Intelligent-Tiering storage class is the ideal storage class
  # for data with unknown, changing, or unpredictable access patterns,
  # independent of object size or retention period. If the size of an
  # object is less than 128 KB, it is not monitored and not eligible for
  # auto-tiering. Smaller objects can be stored, but they are always
  # charged at the Frequent Access tier rates in the S3
  # Intelligent-Tiering storage class.
  #
  # For more information, see [Storage class for automatically optimizing
  # frequently and infrequently accessed objects][1].
  #
  # Operations related to `ListBucketIntelligentTieringConfigurations`
  # include:
  #
  # * [DeleteBucketIntelligentTieringConfiguration][2]
  #
  # * [PutBucketIntelligentTieringConfiguration][3]
  #
  # * [GetBucketIntelligentTieringConfiguration][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_bucket_intelligent_tiering_configurations({
  #   bucket: "BucketName", # required
  #   continuation_token: "Token",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.continuation_token #=> String
  #   resp.next_continuation_token #=> String
  #   resp.intelligent_tiering_configuration_list #=> Array
  #   resp.intelligent_tiering_configuration_list[0].id #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.prefix #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.tag.key #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.tag.value #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.and.prefix #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.and.tags #=> Array
  #   resp.intelligent_tiering_configuration_list[0].filter.and.tags[0].key #=> String
  #   resp.intelligent_tiering_configuration_list[0].filter.and.tags[0].value #=> String
  #   resp.intelligent_tiering_configuration_list[0].status #=> String, one of "Enabled", "Disabled"
  #   resp.intelligent_tiering_configuration_list[0].tierings #=> Array
  #   resp.intelligent_tiering_configuration_list[0].tierings[0].days #=> Integer
  #   resp.intelligent_tiering_configuration_list[0].tierings[0].access_tier #=> String, one of "ARCHIVE_ACCESS", "DEEP_ARCHIVE_ACCESS"
  # @option params
  # @option params
  # @overload list_bucket_intelligent_tiering_configurations
  # @param params [Hash] ({})
  # @return [Types::ListBucketIntelligentTieringConfigurationsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListBucketIntelligentTieringConfigurationsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListBucketIntelligentTieringConfigurationsOutput#continuation_token #continuation_token} => String
  #   * {Types::ListBucketIntelligentTieringConfigurationsOutput#next_continuation_token #next_continuation_token} => String
  #   * {Types::ListBucketIntelligentTieringConfigurationsOutput#intelligent_tiering_configuration_list #intelligent_tiering_configuration_list} => Array&lt;Types::IntelligentTieringConfiguration&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketIntelligentTieringConfigurations AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7432
  def list_bucket_intelligent_tiering_configurations(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a list of inventory configurations for the bucket. You can
  # have up to 1,000 analytics configurations per bucket.
  #
  # This action supports list pagination and does not return more than 100
  # configurations at a time. Always check the `IsTruncated` element in
  # the response. If there are no more configurations to list,
  # `IsTruncated` is set to false. If there are more configurations to
  # list, `IsTruncated` is set to true, and there is a value in
  # `NextContinuationToken`. You use the `NextContinuationToken` value to
  # continue the pagination of the list by passing the value in
  # continuation-token in the request to `GET` the next page.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetInventoryConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about the Amazon S3 inventory feature, see [Amazon S3
  # Inventory][3]
  #
  # The following operations are related to
  # `ListBucketInventoryConfigurations`\:
  #
  # * [GetBucketInventoryConfiguration][4]
  #
  # * [DeleteBucketInventoryConfiguration][5]
  #
  # * [PutBucketInventoryConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_bucket_inventory_configurations({
  #   bucket: "BucketName", # required
  #   continuation_token: "Token",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.continuation_token #=> String
  #   resp.inventory_configuration_list #=> Array
  #   resp.inventory_configuration_list[0].destination.s3_bucket_destination.account_id #=> String
  #   resp.inventory_configuration_list[0].destination.s3_bucket_destination.bucket #=> String
  #   resp.inventory_configuration_list[0].destination.s3_bucket_destination.format #=> String, one of "CSV", "ORC", "Parquet"
  #   resp.inventory_configuration_list[0].destination.s3_bucket_destination.prefix #=> String
  #   resp.inventory_configuration_list[0].destination.s3_bucket_destination.encryption.ssekms.key_id #=> String
  #   resp.inventory_configuration_list[0].is_enabled #=> Boolean
  #   resp.inventory_configuration_list[0].filter.prefix #=> String
  #   resp.inventory_configuration_list[0].id #=> String
  #   resp.inventory_configuration_list[0].included_object_versions #=> String, one of "All", "Current"
  #   resp.inventory_configuration_list[0].optional_fields #=> Array
  #   resp.inventory_configuration_list[0].optional_fields[0] #=> String, one of "Size", "LastModifiedDate", "StorageClass", "ETag", "IsMultipartUploaded", "ReplicationStatus", "EncryptionStatus", "ObjectLockRetainUntilDate", "ObjectLockMode", "ObjectLockLegalHoldStatus", "IntelligentTieringAccessTier", "BucketKeyStatus", "ChecksumAlgorithm"
  #   resp.inventory_configuration_list[0].schedule.frequency #=> String, one of "Daily", "Weekly"
  #   resp.is_truncated #=> Boolean
  #   resp.next_continuation_token #=> String
  # @option params
  # @option params
  # @option params
  # @overload list_bucket_inventory_configurations
  # @param params [Hash] ({})
  # @return [Types::ListBucketInventoryConfigurationsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListBucketInventoryConfigurationsOutput#continuation_token #continuation_token} => String
  #   * {Types::ListBucketInventoryConfigurationsOutput#inventory_configuration_list #inventory_configuration_list} => Array&lt;Types::InventoryConfiguration&gt;
  #   * {Types::ListBucketInventoryConfigurationsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListBucketInventoryConfigurationsOutput#next_continuation_token #next_continuation_token} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7530
  def list_bucket_inventory_configurations(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists the metrics configurations for the bucket. The metrics
  # configurations are only for the request metrics of the bucket and do
  # not provide information on daily storage metrics. You can have up to
  # 1,000 configurations per bucket.
  #
  # This action supports list pagination and does not return more than 100
  # configurations at a time. Always check the `IsTruncated` element in
  # the response. If there are no more configurations to list,
  # `IsTruncated` is set to false. If there are more configurations to
  # list, `IsTruncated` is set to true, and there is a value in
  # `NextContinuationToken`. You use the `NextContinuationToken` value to
  # continue the pagination of the list by passing the value in
  # `continuation-token` in the request to `GET` the next page.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:GetMetricsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For more information about metrics configurations and CloudWatch
  # request metrics, see [Monitoring Metrics with Amazon CloudWatch][3].
  #
  # The following operations are related to
  # `ListBucketMetricsConfigurations`\:
  #
  # * [PutBucketMetricsConfiguration][4]
  #
  # * [GetBucketMetricsConfiguration][5]
  #
  # * [DeleteBucketMetricsConfiguration][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_bucket_metrics_configurations({
  #   bucket: "BucketName", # required
  #   continuation_token: "Token",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.continuation_token #=> String
  #   resp.next_continuation_token #=> String
  #   resp.metrics_configuration_list #=> Array
  #   resp.metrics_configuration_list[0].id #=> String
  #   resp.metrics_configuration_list[0].filter.prefix #=> String
  #   resp.metrics_configuration_list[0].filter.tag.key #=> String
  #   resp.metrics_configuration_list[0].filter.tag.value #=> String
  #   resp.metrics_configuration_list[0].filter.access_point_arn #=> String
  #   resp.metrics_configuration_list[0].filter.and.prefix #=> String
  #   resp.metrics_configuration_list[0].filter.and.tags #=> Array
  #   resp.metrics_configuration_list[0].filter.and.tags[0].key #=> String
  #   resp.metrics_configuration_list[0].filter.and.tags[0].value #=> String
  #   resp.metrics_configuration_list[0].filter.and.access_point_arn #=> String
  # @option params
  # @option params
  # @option params
  # @overload list_bucket_metrics_configurations
  # @param params [Hash] ({})
  # @return [Types::ListBucketMetricsConfigurationsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListBucketMetricsConfigurationsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListBucketMetricsConfigurationsOutput#continuation_token #continuation_token} => String
  #   * {Types::ListBucketMetricsConfigurationsOutput#next_continuation_token #next_continuation_token} => String
  #   * {Types::ListBucketMetricsConfigurationsOutput#metrics_configuration_list #metrics_configuration_list} => Array&lt;Types::MetricsConfiguration&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7628
  def list_bucket_metrics_configurations(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a list of all buckets owned by the authenticated sender of the
  # request. To use this operation, you must have the
  # `s3:ListAllMyBuckets` permission.
  #
  # @example Example: To list object versions
  #
  #   # The following example return versions of an object with specific key name prefix. The request limits the number of items
  #   # returned to two. If there are are more than two object version, S3 returns NextToken in the response. You can specify
  #   # this token value in your next request to fetch next set of object versions.
  #
  #   resp = client.list_buckets({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   buckets: [
  #   {
  #   creation_date: Time.parse("2012-02-15T21: 03: 02.000Z"),
  #   name: "examplebucket",
  #   },
  #   {
  #   creation_date: Time.parse("2011-07-24T19: 33: 50.000Z"),
  #   name: "examplebucket2",
  #   },
  #   {
  #   creation_date: Time.parse("2010-12-17T00: 56: 49.000Z"),
  #   name: "examplebucket3",
  #   },
  #   ],
  #   owner: {
  #   display_name: "own-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31",
  #   },
  #   }
  # @example Response structure
  #
  #   resp.buckets #=> Array
  #   resp.buckets[0].name #=> String
  #   resp.buckets[0].creation_date #=> Time
  #   resp.owner.display_name #=> String
  #   resp.owner.id #=> String
  # @overload list_buckets
  # @param params [Hash] ({})
  # @return [Types::ListBucketsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListBucketsOutput#buckets #buckets} => Array&lt;Types::Bucket&gt;
  #   * {Types::ListBucketsOutput#owner #owner} => Types::Owner
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7686
  def list_buckets(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action lists in-progress multipart uploads. An in-progress
  # multipart upload is a multipart upload that has been initiated using
  # the Initiate Multipart Upload request, but has not yet been completed
  # or aborted.
  #
  # This action returns at most 1,000 multipart uploads in the response.
  # 1,000 multipart uploads is the maximum number of uploads a response
  # can include, which is also the default value. You can further limit
  # the number of uploads in a response by specifying the `max-uploads`
  # parameter in the response. If additional multipart uploads satisfy the
  # list criteria, the response will contain an `IsTruncated` element with
  # the value true. To list the additional multipart uploads, use the
  # `key-marker` and `upload-id-marker` request parameters.
  #
  # In the response, the uploads are sorted by key. If your application
  # has initiated more than one multipart upload using the same object
  # key, then uploads in the response are first sorted by key.
  # Additionally, uploads are sorted in ascending order within each key by
  # the upload initiation time.
  #
  # For more information on multipart uploads, see [Uploading Objects
  # Using Multipart Upload][1].
  #
  # For information on permissions required to use the multipart upload
  # API, see [Multipart Upload and Permissions][2].
  #
  # The following operations are related to `ListMultipartUploads`\:
  #
  # * [CreateMultipartUpload][3]
  #
  # * [UploadPart][4]
  #
  # * [CompleteMultipartUpload][5]
  #
  # * [ListParts][6]
  #
  # * [AbortMultipartUpload][7]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: List next set of multipart uploads when previous result is truncated
  #
  #   # The following example specifies the upload-id-marker and key-marker from previous truncated response to retrieve next
  #   # setup of multipart uploads.
  #
  #   resp = client.list_multipart_uploads({
  #   bucket: "examplebucket",
  #   key_marker: "nextkeyfrompreviousresponse",
  #   max_uploads: 2,
  #   upload_id_marker: "valuefrompreviousresponse",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   bucket: "acl1",
  #   is_truncated: true,
  #   key_marker: "",
  #   max_uploads: 2,
  #   next_key_marker: "someobjectkey",
  #   next_upload_id_marker: "examplelo91lv1iwvWpvCiJWugw2xXLPAD7Z8cJyX9.WiIRgNrdG6Ldsn.9FtS63TCl1Uf5faTB.1U5Ckcbmdw--",
  #   upload_id_marker: "",
  #   uploads: [
  #   {
  #   initiated: Time.parse("2014-05-01T05:40:58.000Z"),
  #   initiator: {
  #   display_name: "ownder-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   key: "JavaFile",
  #   owner: {
  #   display_name: "mohanataws",
  #   id: "852b113e7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   storage_class: "STANDARD",
  #   upload_id: "gZ30jIqlUa.CInXklLQtSMJITdUnoZ1Y5GACB5UckOtspm5zbDMCkPF_qkfZzMiFZ6dksmcnqxJyIBvQMG9X9Q--",
  #   },
  #   {
  #   initiated: Time.parse("2014-05-01T05:41:27.000Z"),
  #   initiator: {
  #   display_name: "ownder-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   key: "JavaFile",
  #   owner: {
  #   display_name: "ownder-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   storage_class: "STANDARD",
  #   upload_id: "b7tZSqIlo91lv1iwvWpvCiJWugw2xXLPAD7Z8cJyX9.WiIRgNrdG6Ldsn.9FtS63TCl1Uf5faTB.1U5Ckcbmdw--",
  #   },
  #   ],
  #   }
  # @example Example: To list in-progress multipart uploads on a bucket
  #
  #   # The following example lists in-progress multipart uploads on a specific bucket.
  #
  #   resp = client.list_multipart_uploads({
  #   bucket: "examplebucket",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   uploads: [
  #   {
  #   initiated: Time.parse("2014-05-01T05:40:58.000Z"),
  #   initiator: {
  #   display_name: "display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   key: "JavaFile",
  #   owner: {
  #   display_name: "display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   storage_class: "STANDARD",
  #   upload_id: "examplelUa.CInXklLQtSMJITdUnoZ1Y5GACB5UckOtspm5zbDMCkPF_qkfZzMiFZ6dksmcnqxJyIBvQMG9X9Q--",
  #   },
  #   {
  #   initiated: Time.parse("2014-05-01T05:41:27.000Z"),
  #   initiator: {
  #   display_name: "display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   key: "JavaFile",
  #   owner: {
  #   display_name: "display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   storage_class: "STANDARD",
  #   upload_id: "examplelo91lv1iwvWpvCiJWugw2xXLPAD7Z8cJyX9.WiIRgNrdG6Ldsn.9FtS63TCl1Uf5faTB.1U5Ckcbmdw--",
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_multipart_uploads({
  #   bucket: "BucketName", # required
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   key_marker: "KeyMarker",
  #   max_uploads: 1,
  #   prefix: "Prefix",
  #   upload_id_marker: "UploadIdMarker",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.bucket #=> String
  #   resp.key_marker #=> String
  #   resp.upload_id_marker #=> String
  #   resp.next_key_marker #=> String
  #   resp.prefix #=> String
  #   resp.delimiter #=> String
  #   resp.next_upload_id_marker #=> String
  #   resp.max_uploads #=> Integer
  #   resp.is_truncated #=> Boolean
  #   resp.uploads #=> Array
  #   resp.uploads[0].upload_id #=> String
  #   resp.uploads[0].key #=> String
  #   resp.uploads[0].initiated #=> Time
  #   resp.uploads[0].storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.uploads[0].owner.display_name #=> String
  #   resp.uploads[0].owner.id #=> String
  #   resp.uploads[0].initiator.id #=> String
  #   resp.uploads[0].initiator.display_name #=> String
  #   resp.uploads[0].checksum_algorithm #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  #   resp.common_prefixes #=> Array
  #   resp.common_prefixes[0].prefix #=> String
  #   resp.encoding_type #=> String, one of "url"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_multipart_uploads
  # @param params [Hash] ({})
  # @return [Types::ListMultipartUploadsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListMultipartUploadsOutput#bucket #bucket} => String
  #   * {Types::ListMultipartUploadsOutput#key_marker #key_marker} => String
  #   * {Types::ListMultipartUploadsOutput#upload_id_marker #upload_id_marker} => String
  #   * {Types::ListMultipartUploadsOutput#next_key_marker #next_key_marker} => String
  #   * {Types::ListMultipartUploadsOutput#prefix #prefix} => String
  #   * {Types::ListMultipartUploadsOutput#delimiter #delimiter} => String
  #   * {Types::ListMultipartUploadsOutput#next_upload_id_marker #next_upload_id_marker} => String
  #   * {Types::ListMultipartUploadsOutput#max_uploads #max_uploads} => Integer
  #   * {Types::ListMultipartUploadsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListMultipartUploadsOutput#uploads #uploads} => Array&lt;Types::MultipartUpload&gt;
  #   * {Types::ListMultipartUploadsOutput#common_prefixes #common_prefixes} => Array&lt;Types::CommonPrefix&gt;
  #   * {Types::ListMultipartUploadsOutput#encoding_type #encoding_type} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#7974
  def list_multipart_uploads(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns metadata about all versions of the objects in a bucket. You
  # can also use request parameters as selection criteria to return
  # metadata about a subset of all the object versions.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:ListBucketVersions` action. Be aware of the name difference.
  #
  # <note markdown="1"> A 200 OK response can contain valid or invalid XML. Make sure to
  # design your application to parse the contents of the response and
  # handle it appropriately.
  #
  #  </note>
  #
  # To use this operation, you must have READ access to the bucket.
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # The following operations are related to `ListObjectVersions`\:
  #
  # * [ListObjectsV2][1]
  #
  # * [GetObject][2]
  #
  # * [PutObject][3]
  #
  # * [DeleteObject][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list object versions
  #
  #   # The following example return versions of an object with specific key name prefix. The request limits the number of items
  #   # returned to two. If there are are more than two object version, S3 returns NextToken in the response. You can specify
  #   # this token value in your next request to fetch next set of object versions.
  #
  #   resp = client.list_object_versions({
  #   bucket: "examplebucket",
  #   prefix: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   versions: [
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   is_latest: true,
  #   key: "HappyFace.jpg",
  #   last_modified: Time.parse("2016-12-15T01:19:41.000Z"),
  #   owner: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   size: 3191,
  #   storage_class: "STANDARD",
  #   version_id: "null",
  #   },
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   is_latest: false,
  #   key: "HappyFace.jpg",
  #   last_modified: Time.parse("2016-12-13T00:58:26.000Z"),
  #   owner: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   size: 3191,
  #   storage_class: "STANDARD",
  #   version_id: "PHtexPGjH2y.zBgT8LmB7wwLI2mpbz.k",
  #   },
  #   ],
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_object_versions({
  #   bucket: "BucketName", # required
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   key_marker: "KeyMarker",
  #   max_keys: 1,
  #   prefix: "Prefix",
  #   version_id_marker: "VersionIdMarker",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.key_marker #=> String
  #   resp.version_id_marker #=> String
  #   resp.next_key_marker #=> String
  #   resp.next_version_id_marker #=> String
  #   resp.versions #=> Array
  #   resp.versions[0].etag #=> String
  #   resp.versions[0].checksum_algorithm #=> Array
  #   resp.versions[0].checksum_algorithm[0] #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  #   resp.versions[0].size #=> Integer
  #   resp.versions[0].storage_class #=> String, one of "STANDARD"
  #   resp.versions[0].key #=> String
  #   resp.versions[0].version_id #=> String
  #   resp.versions[0].is_latest #=> Boolean
  #   resp.versions[0].last_modified #=> Time
  #   resp.versions[0].owner.display_name #=> String
  #   resp.versions[0].owner.id #=> String
  #   resp.delete_markers #=> Array
  #   resp.delete_markers[0].owner.display_name #=> String
  #   resp.delete_markers[0].owner.id #=> String
  #   resp.delete_markers[0].key #=> String
  #   resp.delete_markers[0].version_id #=> String
  #   resp.delete_markers[0].is_latest #=> Boolean
  #   resp.delete_markers[0].last_modified #=> Time
  #   resp.name #=> String
  #   resp.prefix #=> String
  #   resp.delimiter #=> String
  #   resp.max_keys #=> Integer
  #   resp.common_prefixes #=> Array
  #   resp.common_prefixes[0].prefix #=> String
  #   resp.encoding_type #=> String, one of "url"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_object_versions
  # @param params [Hash] ({})
  # @return [Types::ListObjectVersionsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListObjectVersionsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListObjectVersionsOutput#key_marker #key_marker} => String
  #   * {Types::ListObjectVersionsOutput#version_id_marker #version_id_marker} => String
  #   * {Types::ListObjectVersionsOutput#next_key_marker #next_key_marker} => String
  #   * {Types::ListObjectVersionsOutput#next_version_id_marker #next_version_id_marker} => String
  #   * {Types::ListObjectVersionsOutput#versions #versions} => Array&lt;Types::ObjectVersion&gt;
  #   * {Types::ListObjectVersionsOutput#delete_markers #delete_markers} => Array&lt;Types::DeleteMarkerEntry&gt;
  #   * {Types::ListObjectVersionsOutput#name #name} => String
  #   * {Types::ListObjectVersionsOutput#prefix #prefix} => String
  #   * {Types::ListObjectVersionsOutput#delimiter #delimiter} => String
  #   * {Types::ListObjectVersionsOutput#max_keys #max_keys} => Integer
  #   * {Types::ListObjectVersionsOutput#common_prefixes #common_prefixes} => Array&lt;Types::CommonPrefix&gt;
  #   * {Types::ListObjectVersionsOutput#encoding_type #encoding_type} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#8172
  def list_object_versions(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns some or all (up to 1,000) of the objects in a bucket. You can
  # use the request parameters as selection criteria to return a subset of
  # the objects in a bucket. A 200 OK response can contain valid or
  # invalid XML. Be sure to design your application to parse the contents
  # of the response and handle it appropriately.
  #
  # This action has been revised. We recommend that you use the newer
  # version, [ListObjectsV2][1], when developing applications. For
  # backward compatibility, Amazon S3 continues to support `ListObjects`.
  #
  # The following operations are related to `ListObjects`\:
  #
  # * [ListObjectsV2][1]
  #
  # * [GetObject][2]
  #
  # * [PutObject][3]
  #
  # * [CreateBucket][4]
  #
  # * [ListBuckets][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list objects in a bucket
  #
  #   # The following example list two objects in a bucket.
  #
  #   resp = client.list_objects({
  #   bucket: "examplebucket",
  #   max_keys: 2,
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   contents: [
  #   {
  #   etag: "\"70ee1738b6b21e2c8a43f3a5ab0eee71\"",
  #   key: "example1.jpg",
  #   last_modified: Time.parse("2014-11-21T19:40:05.000Z"),
  #   owner: {
  #   display_name: "myname",
  #   id: "12345example25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   size: 11,
  #   storage_class: "STANDARD",
  #   },
  #   {
  #   etag: "\"9c8af9a76df052144598c115ef33e511\"",
  #   key: "example2.jpg",
  #   last_modified: Time.parse("2013-11-15T01:10:49.000Z"),
  #   owner: {
  #   display_name: "myname",
  #   id: "12345example25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   size: 713193,
  #   storage_class: "STANDARD",
  #   },
  #   ],
  #   next_marker: "eyJNYXJrZXIiOiBudWxsLCAiYm90b190cnVuY2F0ZV9hbW91bnQiOiAyfQ==",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_objects({
  #   bucket: "BucketName", # required
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   marker: "Marker",
  #   max_keys: 1,
  #   prefix: "Prefix",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.marker #=> String
  #   resp.next_marker #=> String
  #   resp.contents #=> Array
  #   resp.contents[0].key #=> String
  #   resp.contents[0].last_modified #=> Time
  #   resp.contents[0].etag #=> String
  #   resp.contents[0].checksum_algorithm #=> Array
  #   resp.contents[0].checksum_algorithm[0] #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  #   resp.contents[0].size #=> Integer
  #   resp.contents[0].storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.contents[0].owner.display_name #=> String
  #   resp.contents[0].owner.id #=> String
  #   resp.name #=> String
  #   resp.prefix #=> String
  #   resp.delimiter #=> String
  #   resp.max_keys #=> Integer
  #   resp.common_prefixes #=> Array
  #   resp.common_prefixes[0].prefix #=> String
  #   resp.encoding_type #=> String, one of "url"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_objects
  # @param params [Hash] ({})
  # @return [Types::ListObjectsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListObjectsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListObjectsOutput#marker #marker} => String
  #   * {Types::ListObjectsOutput#next_marker #next_marker} => String
  #   * {Types::ListObjectsOutput#contents #contents} => Array&lt;Types::Object&gt;
  #   * {Types::ListObjectsOutput#name #name} => String
  #   * {Types::ListObjectsOutput#prefix #prefix} => String
  #   * {Types::ListObjectsOutput#delimiter #delimiter} => String
  #   * {Types::ListObjectsOutput#max_keys #max_keys} => Integer
  #   * {Types::ListObjectsOutput#common_prefixes #common_prefixes} => Array&lt;Types::CommonPrefix&gt;
  #   * {Types::ListObjectsOutput#encoding_type #encoding_type} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#8360
  def list_objects(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns some or all (up to 1,000) of the objects in a bucket with each
  # request. You can use the request parameters as selection criteria to
  # return a subset of the objects in a bucket. A `200 OK` response can
  # contain valid or invalid XML. Make sure to design your application to
  # parse the contents of the response and handle it appropriately.
  # Objects are returned sorted in an ascending order of the respective
  # key names in the list. For more information about listing objects, see
  # [Listing object keys programmatically][1]
  #
  # To use this operation, you must have READ access to the bucket.
  #
  # To use this action in an Identity and Access Management (IAM) policy,
  # you must have permissions to perform the `s3:ListBucket` action. The
  # bucket owner has this permission by default and can grant this
  # permission to others. For more information about permissions, see
  # [Permissions Related to Bucket Subresource Operations][2] and
  # [Managing Access Permissions to Your Amazon S3 Resources][3].
  #
  # This section describes the latest revision of this action. We
  # recommend that you use this revised API for application development.
  # For backward compatibility, Amazon S3 continues to support the prior
  # version of this API, [ListObjects][4].
  #
  # To get a list of your buckets, see [ListBuckets][5].
  #
  # The following operations are related to `ListObjectsV2`\:
  #
  # * [GetObject][6]
  #
  # * [PutObject][7]
  #
  # * [CreateBucket][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To get object list
  #
  #   # The following example retrieves object list. The request specifies max keys to limit response to include only 2 object
  #   # keys.
  #
  #   resp = client.list_objects_v2({
  #   bucket: "examplebucket",
  #   max_keys: 2,
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   contents: [
  #   {
  #   etag: "\"70ee1738b6b21e2c8a43f3a5ab0eee71\"",
  #   key: "happyface.jpg",
  #   last_modified: Time.parse("2014-11-21T19:40:05.000Z"),
  #   size: 11,
  #   storage_class: "STANDARD",
  #   },
  #   {
  #   etag: "\"becf17f89c30367a9a44495d62ed521a-1\"",
  #   key: "test.jpg",
  #   last_modified: Time.parse("2014-05-02T04:51:50.000Z"),
  #   size: 4192256,
  #   storage_class: "STANDARD",
  #   },
  #   ],
  #   is_truncated: true,
  #   key_count: 2,
  #   max_keys: 2,
  #   name: "examplebucket",
  #   next_continuation_token: "1w41l63U0xa8q7smH50vCxyTQqdxo69O3EmK28Bi5PcROI4wI/EyIJg==",
  #   prefix: "",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_objects_v2({
  #   bucket: "BucketName", # required
  #   delimiter: "Delimiter",
  #   encoding_type: "url", # accepts url
  #   max_keys: 1,
  #   prefix: "Prefix",
  #   continuation_token: "Token",
  #   fetch_owner: false,
  #   start_after: "StartAfter",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.is_truncated #=> Boolean
  #   resp.contents #=> Array
  #   resp.contents[0].key #=> String
  #   resp.contents[0].last_modified #=> Time
  #   resp.contents[0].etag #=> String
  #   resp.contents[0].checksum_algorithm #=> Array
  #   resp.contents[0].checksum_algorithm[0] #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  #   resp.contents[0].size #=> Integer
  #   resp.contents[0].storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "GLACIER", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.contents[0].owner.display_name #=> String
  #   resp.contents[0].owner.id #=> String
  #   resp.name #=> String
  #   resp.prefix #=> String
  #   resp.delimiter #=> String
  #   resp.max_keys #=> Integer
  #   resp.common_prefixes #=> Array
  #   resp.common_prefixes[0].prefix #=> String
  #   resp.encoding_type #=> String, one of "url"
  #   resp.key_count #=> Integer
  #   resp.continuation_token #=> String
  #   resp.next_continuation_token #=> String
  #   resp.start_after #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_objects_v2
  # @param params [Hash] ({})
  # @return [Types::ListObjectsV2Output] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListObjectsV2Output#is_truncated #is_truncated} => Boolean
  #   * {Types::ListObjectsV2Output#contents #contents} => Array&lt;Types::Object&gt;
  #   * {Types::ListObjectsV2Output#name #name} => String
  #   * {Types::ListObjectsV2Output#prefix #prefix} => String
  #   * {Types::ListObjectsV2Output#delimiter #delimiter} => String
  #   * {Types::ListObjectsV2Output#max_keys #max_keys} => Integer
  #   * {Types::ListObjectsV2Output#common_prefixes #common_prefixes} => Array&lt;Types::CommonPrefix&gt;
  #   * {Types::ListObjectsV2Output#encoding_type #encoding_type} => String
  #   * {Types::ListObjectsV2Output#key_count #key_count} => Integer
  #   * {Types::ListObjectsV2Output#continuation_token #continuation_token} => String
  #   * {Types::ListObjectsV2Output#next_continuation_token #next_continuation_token} => String
  #   * {Types::ListObjectsV2Output#start_after #start_after} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2 AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#8571
  def list_objects_v2(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists the parts that have been uploaded for a specific multipart
  # upload. This operation must include the upload ID, which you obtain by
  # sending the initiate multipart upload request (see
  # [CreateMultipartUpload][1]). This request returns a maximum of 1,000
  # uploaded parts. The default number of parts returned is 1,000 parts.
  # You can restrict the number of parts returned by specifying the
  # `max-parts` request parameter. If your multipart upload consists of
  # more than 1,000 parts, the response returns an `IsTruncated` field
  # with the value of true, and a `NextPartNumberMarker` element. In
  # subsequent `ListParts` requests you can include the part-number-marker
  # query string parameter and set its value to the `NextPartNumberMarker`
  # field value from the previous response.
  #
  # If the upload was created using a checksum algorithm, you will need to
  # have permission to the `kms:Decrypt` action for the request to
  # succeed.
  #
  # For more information on multipart uploads, see [Uploading Objects
  # Using Multipart Upload][2].
  #
  # For information on permissions required to use the multipart upload
  # API, see [Multipart Upload and Permissions][3].
  #
  # The following operations are related to `ListParts`\:
  #
  # * [CreateMultipartUpload][1]
  #
  # * [UploadPart][4]
  #
  # * [CompleteMultipartUpload][5]
  #
  # * [AbortMultipartUpload][6]
  #
  # * [GetObjectAttributes][7]
  #
  # * [ListMultipartUploads][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list parts of a multipart upload.
  #
  #   # The following example lists parts uploaded for a specific multipart upload.
  #
  #   resp = client.list_parts({
  #   bucket: "examplebucket",
  #   key: "bigobject",
  #   upload_id: "example7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CEg--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   initiator: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   owner: {
  #   display_name: "owner-display-name",
  #   id: "examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484be31bebcc",
  #   },
  #   parts: [
  #   {
  #   etag: "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
  #   last_modified: Time.parse("2016-12-16T00:11:42.000Z"),
  #   part_number: 1,
  #   size: 26246026,
  #   },
  #   {
  #   etag: "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
  #   last_modified: Time.parse("2016-12-16T00:15:01.000Z"),
  #   part_number: 2,
  #   size: 26246026,
  #   },
  #   ],
  #   storage_class: "STANDARD",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_parts({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   max_parts: 1,
  #   part_number_marker: 1,
  #   upload_id: "MultipartUploadId", # required
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   })
  # @example Response structure
  #
  #   resp.abort_date #=> Time
  #   resp.abort_rule_id #=> String
  #   resp.bucket #=> String
  #   resp.key #=> String
  #   resp.upload_id #=> String
  #   resp.part_number_marker #=> Integer
  #   resp.next_part_number_marker #=> Integer
  #   resp.max_parts #=> Integer
  #   resp.is_truncated #=> Boolean
  #   resp.parts #=> Array
  #   resp.parts[0].part_number #=> Integer
  #   resp.parts[0].last_modified #=> Time
  #   resp.parts[0].etag #=> String
  #   resp.parts[0].size #=> Integer
  #   resp.parts[0].checksum_crc32 #=> String
  #   resp.parts[0].checksum_crc32c #=> String
  #   resp.parts[0].checksum_sha1 #=> String
  #   resp.parts[0].checksum_sha256 #=> String
  #   resp.initiator.id #=> String
  #   resp.initiator.display_name #=> String
  #   resp.owner.display_name #=> String
  #   resp.owner.id #=> String
  #   resp.storage_class #=> String, one of "STANDARD", "REDUCED_REDUNDANCY", "STANDARD_IA", "ONEZONE_IA", "INTELLIGENT_TIERING", "GLACIER", "DEEP_ARCHIVE", "OUTPOSTS", "GLACIER_IR"
  #   resp.request_charged #=> String, one of "requester"
  #   resp.checksum_algorithm #=> String, one of "CRC32", "CRC32C", "SHA1", "SHA256"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_parts
  # @param params [Hash] ({})
  # @return [Types::ListPartsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListPartsOutput#abort_date #abort_date} => Time
  #   * {Types::ListPartsOutput#abort_rule_id #abort_rule_id} => String
  #   * {Types::ListPartsOutput#bucket #bucket} => String
  #   * {Types::ListPartsOutput#key #key} => String
  #   * {Types::ListPartsOutput#upload_id #upload_id} => String
  #   * {Types::ListPartsOutput#part_number_marker #part_number_marker} => Integer
  #   * {Types::ListPartsOutput#next_part_number_marker #next_part_number_marker} => Integer
  #   * {Types::ListPartsOutput#max_parts #max_parts} => Integer
  #   * {Types::ListPartsOutput#is_truncated #is_truncated} => Boolean
  #   * {Types::ListPartsOutput#parts #parts} => Array&lt;Types::Part&gt;
  #   * {Types::ListPartsOutput#initiator #initiator} => Types::Initiator
  #   * {Types::ListPartsOutput#owner #owner} => Types::Owner
  #   * {Types::ListPartsOutput#storage_class #storage_class} => String
  #   * {Types::ListPartsOutput#request_charged #request_charged} => String
  #   * {Types::ListPartsOutput#checksum_algorithm #checksum_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#8814
  def list_parts(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the accelerate configuration of an existing bucket. Amazon S3
  # Transfer Acceleration is a bucket-level feature that enables you to
  # perform faster data transfers to Amazon S3.
  #
  # To use this operation, you must have permission to perform the
  # `s3:PutAccelerateConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # The Transfer Acceleration state of a bucket can be set to one of the
  # following two values:
  #
  # * Enabled – Enables accelerated data transfers to the bucket.
  #
  # * Suspended – Disables accelerated data transfers to the bucket.
  #
  # The [GetBucketAccelerateConfiguration][3] action returns the transfer
  # acceleration state of a bucket.
  #
  # After setting the Transfer Acceleration state of a bucket to Enabled,
  # it might take up to thirty minutes before the data transfer rates to
  # the bucket increase.
  #
  # The name of the bucket used for Transfer Acceleration must be
  # DNS-compliant and must not contain periods (".").
  #
  # For more information about transfer acceleration, see [Transfer
  # Acceleration][4].
  #
  # The following operations are related to
  # `PutBucketAccelerateConfiguration`\:
  #
  # * [GetBucketAccelerateConfiguration][3]
  #
  # * [CreateBucket][5]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_accelerate_configuration({
  #   bucket: "BucketName", # required
  #   accelerate_configuration: { # required
  #   status: "Enabled", # accepts Enabled, Suspended
  #   },
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_accelerate_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#8909
  def put_bucket_accelerate_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the permissions on an existing bucket using access control lists
  # (ACL). For more information, see [Using ACLs][1]. To set the ACL of a
  # bucket, you must have `WRITE_ACP` permission.
  #
  # You can use one of the following two ways to set a bucket's
  # permissions:
  #
  # * Specify the ACL in the request body
  #
  # * Specify permissions using request headers
  #
  # <note markdown="1"> You cannot specify access permission using both the body and the
  # request headers.
  #
  #  </note>
  #
  # Depending on your application needs, you may choose to set the ACL on
  # a bucket using either the request body or the headers. For example, if
  # you have an existing application that updates a bucket ACL using the
  # request body, then you can continue to use that approach.
  #
  # If your bucket uses the bucket owner enforced setting for S3 Object
  # Ownership, ACLs are disabled and no longer affect permissions. You
  # must use policies to grant access to your bucket and the objects in
  # it. Requests to set ACLs or update ACLs fail and return the
  # `AccessControlListNotSupported` error code. Requests to read ACLs are
  # still supported. For more information, see [Controlling object
  # ownership][2] in the *Amazon S3 User Guide*.
  #
  # **Access Permissions**
  #
  # You can set access permissions using one of the following methods:
  #
  # * Specify a canned ACL with the `x-amz-acl` request header. Amazon S3
  #   supports a set of predefined ACLs, known as *canned ACLs*. Each
  #   canned ACL has a predefined set of grantees and permissions. Specify
  #   the canned ACL name as the value of `x-amz-acl`. If you use this
  #   header, you cannot use other access control-specific headers in your
  #   request. For more information, see [Canned ACL][3].
  #
  # * Specify access permissions explicitly with the `x-amz-grant-read`,
  #   `x-amz-grant-read-acp`, `x-amz-grant-write-acp`, and
  #   `x-amz-grant-full-control` headers. When using these headers, you
  #   specify explicit access permissions and grantees (Amazon Web
  #   Services accounts or Amazon S3 groups) who will receive the
  #   permission. If you use these ACL-specific headers, you cannot use
  #   the `x-amz-acl` header to set a canned ACL. These parameters map to
  #   the set of permissions that Amazon S3 supports in an ACL. For more
  #   information, see [Access Control List (ACL) Overview][4].
  #
  #   You specify each grantee as a type=value pair, where the type is one
  #   of the following:
  #
  #   * `id` – if the value specified is the canonical user ID of an
  #     Amazon Web Services account
  #
  #   * `uri` – if you are granting permissions to a predefined group
  #
  #   * `emailAddress` – if the value specified is the email address of an
  #     Amazon Web Services account
  #
  #     <note markdown="1"> Using email addresses to specify a grantee is only supported in
  #     the following Amazon Web Services Regions:
  #
  #      * US East (N. Virginia)
  #
  #     * US West (N. California)
  #
  #     * US West (Oregon)
  #
  #     * Asia Pacific (Singapore)
  #
  #     * Asia Pacific (Sydney)
  #
  #     * Asia Pacific (Tokyo)
  #
  #     * Europe (Ireland)
  #
  #     * South America (São Paulo)
  #
  #      For a list of all the Amazon S3 supported Regions and endpoints,
  #     see [Regions and Endpoints][5] in the Amazon Web Services General
  #     Reference.
  #
  #      </note>
  #
  #   For example, the following `x-amz-grant-write` header grants create,
  #   overwrite, and delete objects permission to LogDelivery group
  #   predefined by Amazon S3 and two Amazon Web Services accounts
  #   identified by their email addresses.
  #
  #   `x-amz-grant-write:
  #   uri="http://acs.amazonaws.com/groups/s3/LogDelivery",
  #   id="111122223333", id="555566667777" `
  #
  # You can use either a canned ACL or specify access permissions
  # explicitly. You cannot do both.
  #
  # **Grantee Values**
  #
  # You can specify the person (grantee) to whom you're assigning access
  # rights (using request elements) in the following ways:
  #
  # * By the person's ID:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
  #   </Grantee>`
  #
  #   DisplayName is optional and ignored in the request
  #
  # * By URI:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>`
  #
  # * By Email address:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>`
  #
  #   The grantee is resolved to the CanonicalUser and, in a response to a
  #   GET Object acl request, appears as the CanonicalUser.
  #
  #   <note markdown="1"> Using email addresses to specify a grantee is only supported in the
  #   following Amazon Web Services Regions:
  #
  #    * US East (N. Virginia)
  #
  #   * US West (N. California)
  #
  #   * US West (Oregon)
  #
  #   * Asia Pacific (Singapore)
  #
  #   * Asia Pacific (Sydney)
  #
  #   * Asia Pacific (Tokyo)
  #
  #   * Europe (Ireland)
  #
  #   * South America (São Paulo)
  #
  #    For a list of all the Amazon S3 supported Regions and endpoints, see
  #   [Regions and Endpoints][5] in the Amazon Web Services General
  #   Reference.
  #
  #    </note>
  #
  # **Related Resources**
  #
  # * [CreateBucket][6]
  #
  # * [DeleteBucket][7]
  #
  # * [GetObjectAcl][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  # [5]: https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html
  #
  # @example Example: Put bucket acl
  #
  #   # The following example replaces existing ACL on a bucket. The ACL grants the bucket owner (specified using the owner ID)
  #   # and write permission to the LogDelivery group. Because this is a replace operation, you must specify all the grants in
  #   # your request. To incrementally add or remove ACL grants, you might use the console.
  #
  #   resp = client.put_bucket_acl({
  #   bucket: "examplebucket",
  #   grant_full_control: "id=examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484",
  #   grant_write: "uri=http://acs.amazonaws.com/groups/s3/LogDelivery",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_acl({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read
  #   access_control_policy: {
  #   grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   owner: {
  #   display_name: "DisplayName",
  #   id: "ID",
  #   },
  #   },
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_acl
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9197
  def put_bucket_acl(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets an analytics configuration for the bucket (specified by the
  # analytics configuration ID). You can have up to 1,000 analytics
  # configurations per bucket.
  #
  # You can choose to have storage class analysis export analysis reports
  # sent to a comma-separated values (CSV) flat file. See the `DataExport`
  # request element. Reports are updated daily and are based on the object
  # filters that you configure. When selecting data export, you specify a
  # destination bucket and an optional destination prefix where the file
  # is written. You can export the data to a destination bucket in a
  # different account. However, the destination bucket must be in the same
  # Region as the bucket that you are making the PUT analytics
  # configuration to. For more information, see [Amazon S3 Analytics –
  # Storage Class Analysis][1].
  #
  # You must create a bucket policy on the destination bucket where the
  # exported file is written to grant permissions to Amazon S3 to write
  # objects to the bucket. For an example policy, see [Granting
  # Permissions for Amazon S3 Inventory and Storage Class Analysis][2].
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutAnalyticsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][3] and [Managing Access
  # Permissions to Your Amazon S3 Resources][4].
  #
  # **Special Errors**
  #
  # * * *HTTP Error: HTTP 400 Bad Request*
  #
  #   * *Code: InvalidArgument*
  #
  #   * *Cause: Invalid argument.*
  #
  # * * *HTTP Error: HTTP 400 Bad Request*
  #
  #   * *Code: TooManyConfigurations*
  #
  #   * *Cause: You are attempting to create a new configuration but have
  #     already reached the 1,000-configuration limit.*
  #
  # * * *HTTP Error: HTTP 403 Forbidden*
  #
  #   * *Code: AccessDenied*
  #
  #   * *Cause: You are not the owner of the specified bucket, or you do
  #     not have the s3:PutAnalyticsConfiguration bucket permission to set
  #     the configuration on the bucket.*
  #
  # **Related Resources**
  #
  # * [GetBucketAnalyticsConfiguration][5]
  #
  # * [DeleteBucketAnalyticsConfiguration][6]
  #
  # * [ListBucketAnalyticsConfigurations][7]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_analytics_configuration({
  #   bucket: "BucketName", # required
  #   id: "AnalyticsId", # required
  #   analytics_configuration: { # required
  #   id: "AnalyticsId", # required
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   },
  #   storage_class_analysis: { # required
  #   data_export: {
  #   output_schema_version: "V_1", # required, accepts V_1
  #   destination: { # required
  #   s3_bucket_destination: { # required
  #   format: "CSV", # required, accepts CSV
  #   bucket_account_id: "AccountId",
  #   bucket: "BucketName", # required
  #   prefix: "Prefix",
  #   },
  #   },
  #   },
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_analytics_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9330
  def put_bucket_analytics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the `cors` configuration for your bucket. If the configuration
  # exists, Amazon S3 replaces it.
  #
  # To use this operation, you must be allowed to perform the
  # `s3:PutBucketCORS` action. By default, the bucket owner has this
  # permission and can grant it to others.
  #
  # You set this configuration on a bucket so that the bucket can service
  # cross-origin requests. For example, you might want to enable a request
  # whose origin is `http://www.example.com` to access your Amazon S3
  # bucket at `my.example.bucket.com` by using the browser's
  # `XMLHttpRequest` capability.
  #
  # To enable cross-origin resource sharing (CORS) on a bucket, you add
  # the `cors` subresource to the bucket. The `cors` subresource is an XML
  # document in which you configure rules that identify origins and the
  # HTTP methods that can be executed on your bucket. The document is
  # limited to 64 KB in size.
  #
  # When Amazon S3 receives a cross-origin request (or a pre-flight
  # OPTIONS request) against a bucket, it evaluates the `cors`
  # configuration on the bucket and uses the first `CORSRule` rule that
  # matches the incoming browser request to enable a cross-origin request.
  # For a rule to match, the following conditions must be met:
  #
  # * The request's `Origin` header must match `AllowedOrigin` elements.
  #
  # * The request method (for example, GET, PUT, HEAD, and so on) or the
  #   `Access-Control-Request-Method` header in case of a pre-flight
  #   `OPTIONS` request must be one of the `AllowedMethod` elements.
  #
  # * Every header specified in the `Access-Control-Request-Headers`
  #   request header of a pre-flight request must match an `AllowedHeader`
  #   element.
  #
  # For more information about CORS, go to [Enabling Cross-Origin Resource
  # Sharing][1] in the *Amazon S3 User Guide*.
  #
  # **Related Resources**
  #
  # * [GetBucketCors][2]
  #
  # * [DeleteBucketCors][3]
  #
  # * [RESTOPTIONSobject][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html
  #
  # @example Example: To set cors configuration on a bucket.
  #
  #   # The following example enables PUT, POST, and DELETE requests from www.example.com, and enables GET requests from any
  #   # domain.
  #
  #   resp = client.put_bucket_cors({
  #   bucket: "",
  #   cors_configuration: {
  #   cors_rules: [
  #   {
  #   allowed_headers: [
  #   "*",
  #   ],
  #   allowed_methods: [
  #   "PUT",
  #   "POST",
  #   "DELETE",
  #   ],
  #   allowed_origins: [
  #   "http://www.example.com",
  #   ],
  #   expose_headers: [
  #   "x-amz-server-side-encryption",
  #   ],
  #   max_age_seconds: 3000,
  #   },
  #   {
  #   allowed_headers: [
  #   "Authorization",
  #   ],
  #   allowed_methods: [
  #   "GET",
  #   ],
  #   allowed_origins: [
  #   "*",
  #   ],
  #   max_age_seconds: 3000,
  #   },
  #   ],
  #   },
  #   content_md5: "",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_cors({
  #   bucket: "BucketName", # required
  #   cors_configuration: { # required
  #   cors_rules: [ # required
  #   {
  #   id: "ID",
  #   allowed_headers: ["AllowedHeader"],
  #   allowed_methods: ["AllowedMethod"], # required
  #   allowed_origins: ["AllowedOrigin"], # required
  #   expose_headers: ["ExposeHeader"],
  #   max_age_seconds: 1,
  #   },
  #   ],
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_cors
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9505
  def put_bucket_cors(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action uses the `encryption` subresource to configure default
  # encryption and Amazon S3 Bucket Key for an existing bucket.
  #
  # Default encryption for a bucket can use server-side encryption with
  # Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). If
  # you specify default encryption using SSE-KMS, you can also configure
  # Amazon S3 Bucket Key. When the default encryption is SSE-KMS, if you
  # upload an object to the bucket and do not specify the KMS key to use
  # for encryption, Amazon S3 uses the default Amazon Web Services managed
  # KMS key for your account. For information about default encryption,
  # see [Amazon S3 default bucket encryption][1] in the *Amazon S3 User
  # Guide*. For more information about S3 Bucket Keys, see [Amazon S3
  # Bucket Keys][2] in the *Amazon S3 User Guide*.
  #
  # This action requires Amazon Web Services Signature Version 4. For more
  # information, see [ Authenticating Requests (Amazon Web Services
  # Signature Version 4)][3].
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutEncryptionConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][4] and [Managing Access
  # Permissions to Your Amazon S3 Resources][5] in the Amazon S3 User
  # Guide.
  #
  # **Related Resources**
  #
  # * [GetBucketEncryption][6]
  #
  # * [DeleteBucketEncryption][7]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_encryption({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   server_side_encryption_configuration: { # required
  #   rules: [ # required
  #   {
  #   apply_server_side_encryption_by_default: {
  #   sse_algorithm: "AES256", # required, accepts AES256, aws:kms
  #   kms_master_key_id: "SSEKMSKeyId",
  #   },
  #   bucket_key_enabled: false,
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_encryption
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9621
  def put_bucket_encryption(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Puts a S3 Intelligent-Tiering configuration to the specified bucket.
  # You can have up to 1,000 S3 Intelligent-Tiering configurations per
  # bucket.
  #
  # The S3 Intelligent-Tiering storage class is designed to optimize
  # storage costs by automatically moving data to the most cost-effective
  # storage access tier, without performance impact or operational
  # overhead. S3 Intelligent-Tiering delivers automatic cost savings in
  # three low latency and high throughput access tiers. To get the lowest
  # storage cost on data that can be accessed in minutes to hours, you can
  # choose to activate additional archiving capabilities.
  #
  # The S3 Intelligent-Tiering storage class is the ideal storage class
  # for data with unknown, changing, or unpredictable access patterns,
  # independent of object size or retention period. If the size of an
  # object is less than 128 KB, it is not monitored and not eligible for
  # auto-tiering. Smaller objects can be stored, but they are always
  # charged at the Frequent Access tier rates in the S3
  # Intelligent-Tiering storage class.
  #
  # For more information, see [Storage class for automatically optimizing
  # frequently and infrequently accessed objects][1].
  #
  # Operations related to `PutBucketIntelligentTieringConfiguration`
  # include:
  #
  # * [DeleteBucketIntelligentTieringConfiguration][2]
  #
  # * [GetBucketIntelligentTieringConfiguration][3]
  #
  # * [ListBucketIntelligentTieringConfigurations][4]
  #
  # <note markdown="1"> You only need S3 Intelligent-Tiering enabled on a bucket if you want
  # to automatically move objects stored in the S3 Intelligent-Tiering
  # storage class to the Archive Access or Deep Archive Access tier.
  #
  #  </note>
  #
  # **Special Errors**
  #
  # * **HTTP 400 Bad Request Error**
  #
  #   * *Code:* InvalidArgument
  #
  #   * *Cause:* Invalid Argument
  #
  # * **HTTP 400 Bad Request Error**
  #
  #   * *Code:* TooManyConfigurations
  #
  #   * *Cause:* You are attempting to create a new configuration but have
  #     already reached the 1,000-configuration limit.
  #
  # * **HTTP 403 Forbidden Error**
  #
  #   * *Code:* AccessDenied
  #
  #   * *Cause:* You are not the owner of the specified bucket, or you do
  #     not have the `s3:PutIntelligentTieringConfiguration` bucket
  #     permission to set the configuration on the bucket.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_intelligent_tiering_configuration({
  #   bucket: "BucketName", # required
  #   id: "IntelligentTieringId", # required
  #   intelligent_tiering_configuration: { # required
  #   id: "IntelligentTieringId", # required
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   },
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   tierings: [ # required
  #   {
  #   days: 1, # required
  #   access_tier: "ARCHIVE_ACCESS", # required, accepts ARCHIVE_ACCESS, DEEP_ARCHIVE_ACCESS
  #   },
  #   ],
  #   },
  #   })
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_intelligent_tiering_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketIntelligentTieringConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9743
  def put_bucket_intelligent_tiering_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This implementation of the `PUT` action adds an inventory
  # configuration (identified by the inventory ID) to the bucket. You can
  # have up to 1,000 inventory configurations per bucket.
  #
  # Amazon S3 inventory generates inventories of the objects in the bucket
  # on a daily or weekly basis, and the results are published to a flat
  # file. The bucket that is inventoried is called the *source* bucket,
  # and the bucket where the inventory flat file is stored is called the
  # *destination* bucket. The *destination* bucket must be in the same
  # Amazon Web Services Region as the *source* bucket.
  #
  # When you configure an inventory for a *source* bucket, you specify the
  # *destination* bucket where you want the inventory to be stored, and
  # whether to generate the inventory daily or weekly. You can also
  # configure what object metadata to include and whether to inventory all
  # object versions or only current versions. For more information, see
  # [Amazon S3 Inventory][1] in the Amazon S3 User Guide.
  #
  # You must create a bucket policy on the *destination* bucket to grant
  # permissions to Amazon S3 to write objects to the bucket in the defined
  # location. For an example policy, see [ Granting Permissions for Amazon
  # S3 Inventory and Storage Class Analysis][2].
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutInventoryConfiguration` action. The bucket owner has this
  # permission by default and can grant this permission to others. For
  # more information about permissions, see [Permissions Related to Bucket
  # Subresource Operations][3] and [Managing Access Permissions to Your
  # Amazon S3 Resources][4] in the Amazon S3 User Guide.
  #
  # **Special Errors**
  #
  # * **HTTP 400 Bad Request Error**
  #
  #   * *Code:* InvalidArgument
  #
  #   * *Cause:* Invalid Argument
  #
  # * **HTTP 400 Bad Request Error**
  #
  #   * *Code:* TooManyConfigurations
  #
  #   * *Cause:* You are attempting to create a new configuration but have
  #     already reached the 1,000-configuration limit.
  #
  # * **HTTP 403 Forbidden Error**
  #
  #   * *Code:* AccessDenied
  #
  #   * *Cause:* You are not the owner of the specified bucket, or you do
  #     not have the `s3:PutInventoryConfiguration` bucket permission to
  #     set the configuration on the bucket.
  #
  # **Related Resources**
  #
  # * [GetBucketInventoryConfiguration][5]
  #
  # * [DeleteBucketInventoryConfiguration][6]
  #
  # * [ListBucketInventoryConfigurations][7]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_inventory_configuration({
  #   bucket: "BucketName", # required
  #   id: "InventoryId", # required
  #   inventory_configuration: { # required
  #   destination: { # required
  #   s3_bucket_destination: { # required
  #   account_id: "AccountId",
  #   bucket: "BucketName", # required
  #   format: "CSV", # required, accepts CSV, ORC, Parquet
  #   prefix: "Prefix",
  #   encryption: {
  #   sses3: {
  #   },
  #   ssekms: {
  #   key_id: "SSEKMSKeyId", # required
  #   },
  #   },
  #   },
  #   },
  #   is_enabled: false, # required
  #   filter: {
  #   prefix: "Prefix", # required
  #   },
  #   id: "InventoryId", # required
  #   included_object_versions: "All", # required, accepts All, Current
  #   optional_fields: ["Size"], # accepts Size, LastModifiedDate, StorageClass, ETag, IsMultipartUploaded, ReplicationStatus, EncryptionStatus, ObjectLockRetainUntilDate, ObjectLockMode, ObjectLockLegalHoldStatus, IntelligentTieringAccessTier, BucketKeyStatus, ChecksumAlgorithm
  #   schedule: { # required
  #   frequency: "Daily", # required, accepts Daily, Weekly
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_inventory_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#9875
  def put_bucket_inventory_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # For an updated version of this API, see
  # [PutBucketLifecycleConfiguration][1]. This version has been
  # deprecated. Existing lifecycle configurations will work. For new
  # lifecycle configurations, use the updated API.
  #
  # Creates a new lifecycle configuration for the bucket or replaces an
  # existing lifecycle configuration. For information about lifecycle
  # configuration, see [Object Lifecycle Management][2] in the *Amazon S3
  # User Guide*.
  #
  # By default, all Amazon S3 resources, including buckets, objects, and
  # related subresources (for example, lifecycle configuration and website
  # configuration) are private. Only the resource owner, the Amazon Web
  # Services account that created the resource, can access it. The
  # resource owner can optionally grant access permissions to others by
  # writing an access policy. For this operation, users must get the
  # `s3:PutLifecycleConfiguration` permission.
  #
  # You can also explicitly deny permissions. Explicit denial also
  # supersedes any other permissions. If you want to prevent users or
  # accounts from removing or deleting objects from your bucket, you must
  # deny them permissions for the following actions:
  #
  # * `s3:DeleteObject`
  #
  # * `s3:DeleteObjectVersion`
  #
  # * `s3:PutLifecycleConfiguration`
  #
  # For more information about permissions, see [Managing Access
  # Permissions to your Amazon S3 Resources][3] in the *Amazon S3 User
  # Guide*.
  #
  # For more examples of transitioning objects to storage classes such as
  # STANDARD\_IA or ONEZONE\_IA, see [Examples of Lifecycle
  # Configuration][4].
  #
  # **Related Resources**
  #
  # * [GetBucketLifecycle][5](Deprecated)
  #
  # * [GetBucketLifecycleConfiguration][6]
  #
  # * [RestoreObject][7]
  #
  # * By default, a resource owner—in this case, a bucket owner, which is
  #   the Amazon Web Services account that created the bucket—can perform
  #   any of the operations. A resource owner can also grant others
  #   permission to perform the operation. For more information, see the
  #   following topics in the Amazon S3 User Guide:
  #
  #   * [Specifying Permissions in a Policy][8]
  #
  #   * [Managing Access Permissions to your Amazon S3 Resources][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#lifecycle-configuration-examples
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_lifecycle({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   lifecycle_configuration: {
  #   rules: [ # required
  #   {
  #   expiration: {
  #   date: Time.now,
  #   days: 1,
  #   expired_object_delete_marker: false,
  #   },
  #   id: "ID",
  #   prefix: "Prefix", # required
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   transition: {
  #   date: Time.now,
  #   days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   },
  #   noncurrent_version_transition: {
  #   noncurrent_days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   newer_noncurrent_versions: 1,
  #   },
  #   noncurrent_version_expiration: {
  #   noncurrent_days: 1,
  #   newer_noncurrent_versions: 1,
  #   },
  #   abort_incomplete_multipart_upload: {
  #   days_after_initiation: 1,
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_lifecycle
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10022
  def put_bucket_lifecycle(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a new lifecycle configuration for the bucket or replaces an
  # existing lifecycle configuration. Keep in mind that this will
  # overwrite an existing lifecycle configuration, so if you want to
  # retain any configuration details, they must be included in the new
  # lifecycle configuration. For information about lifecycle
  # configuration, see [Managing your storage lifecycle][1].
  #
  # <note markdown="1"> Bucket lifecycle configuration now supports specifying a lifecycle
  # rule using an object key name prefix, one or more object tags, or a
  # combination of both. Accordingly, this section describes the latest
  # API. The previous version of the API supported filtering based only on
  # an object key name prefix, which is supported for backward
  # compatibility. For the related API description, see
  # [PutBucketLifecycle][2].
  #
  #  </note>
  #
  # **Rules**
  #
  # You specify the lifecycle configuration in your request body. The
  # lifecycle configuration is specified as XML consisting of one or more
  # rules. An Amazon S3 Lifecycle configuration can have up to 1,000
  # rules. This limit is not adjustable. Each rule consists of the
  # following:
  #
  # * Filter identifying a subset of objects to which the rule applies.
  #   The filter can be based on a key name prefix, object tags, or a
  #   combination of both.
  #
  # * Status whether the rule is in effect.
  #
  # * One or more lifecycle transition and expiration actions that you
  #   want Amazon S3 to perform on the objects identified by the filter.
  #   If the state of your bucket is versioning-enabled or
  #   versioning-suspended, you can have many versions of the same object
  #   (one current version and zero or more noncurrent versions). Amazon
  #   S3 provides predefined actions that you can specify for current and
  #   noncurrent object versions.
  #
  # For more information, see [Object Lifecycle Management][3] and
  # [Lifecycle Configuration Elements][4].
  #
  # **Permissions**
  #
  # By default, all Amazon S3 resources are private, including buckets,
  # objects, and related subresources (for example, lifecycle
  # configuration and website configuration). Only the resource owner
  # (that is, the Amazon Web Services account that created it) can access
  # the resource. The resource owner can optionally grant access
  # permissions to others by writing an access policy. For this operation,
  # a user must get the `s3:PutLifecycleConfiguration` permission.
  #
  # You can also explicitly deny permissions. Explicit deny also
  # supersedes any other permissions. If you want to block users or
  # accounts from removing or deleting objects from your bucket, you must
  # deny them permissions for the following actions:
  #
  # * `s3:DeleteObject`
  #
  # * `s3:DeleteObjectVersion`
  #
  # * `s3:PutLifecycleConfiguration`
  #
  # For more information about permissions, see [Managing Access
  # Permissions to Your Amazon S3 Resources][5].
  #
  # The following are related to `PutBucketLifecycleConfiguration`\:
  #
  # * [Examples of Lifecycle Configuration][6]
  #
  # * [GetBucketLifecycleConfiguration][7]
  #
  # * [DeleteBucketLifecycle][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html
  #
  # @example Example: Put bucket lifecycle
  #
  #   # The following example replaces existing lifecycle configuration, if any, on the specified bucket.
  #
  #   resp = client.put_bucket_lifecycle_configuration({
  #   bucket: "examplebucket",
  #   lifecycle_configuration: {
  #   rules: [
  #   {
  #   expiration: {
  #   days: 3650,
  #   },
  #   filter: {
  #   prefix: "documents/",
  #   },
  #   id: "TestOnly",
  #   status: "Enabled",
  #   transitions: [
  #   {
  #   days: 365,
  #   storage_class: "GLACIER",
  #   },
  #   ],
  #   },
  #   ],
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_lifecycle_configuration({
  #   bucket: "BucketName", # required
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   lifecycle_configuration: {
  #   rules: [ # required
  #   {
  #   expiration: {
  #   date: Time.now,
  #   days: 1,
  #   expired_object_delete_marker: false,
  #   },
  #   id: "ID",
  #   prefix: "Prefix",
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   object_size_greater_than: 1,
  #   object_size_less_than: 1,
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   object_size_greater_than: 1,
  #   object_size_less_than: 1,
  #   },
  #   },
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   transitions: [
  #   {
  #   date: Time.now,
  #   days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   },
  #   ],
  #   noncurrent_version_transitions: [
  #   {
  #   noncurrent_days: 1,
  #   storage_class: "GLACIER", # accepts GLACIER, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, DEEP_ARCHIVE, GLACIER_IR
  #   newer_noncurrent_versions: 1,
  #   },
  #   ],
  #   noncurrent_version_expiration: {
  #   noncurrent_days: 1,
  #   newer_noncurrent_versions: 1,
  #   },
  #   abort_incomplete_multipart_upload: {
  #   days_after_initiation: 1,
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_lifecycle_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10237
  def put_bucket_lifecycle_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Set the logging parameters for a bucket and to specify permissions for
  # who can view and modify the logging parameters. All logs are saved to
  # buckets in the same Amazon Web Services Region as the source bucket.
  # To set the logging status of a bucket, you must be the bucket owner.
  #
  # The bucket owner is automatically granted FULL\_CONTROL to all logs.
  # You use the `Grantee` request element to grant access to other people.
  # The `Permissions` request element specifies the kind of access the
  # grantee has to the logs.
  #
  # If the target bucket for log delivery uses the bucket owner enforced
  # setting for S3 Object Ownership, you can't use the `Grantee` request
  # element to grant access to others. Permissions can only be granted
  # using policies. For more information, see [Permissions for server
  # access log delivery][1] in the *Amazon S3 User Guide*.
  #
  # **Grantee Values**
  #
  # You can specify the person (grantee) to whom you're assigning access
  # rights (using request elements) in the following ways:
  #
  # * By the person's ID:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
  #   </Grantee>`
  #
  #   DisplayName is optional and ignored in the request.
  #
  # * By Email address:
  #
  #   ` <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress></Grantee>`
  #
  #   The grantee is resolved to the CanonicalUser and, in a response to a
  #   GET Object acl request, appears as the CanonicalUser.
  #
  # * By URI:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>`
  #
  # To enable logging, you use LoggingEnabled and its children request
  # elements. To disable logging, you use an empty BucketLoggingStatus
  # request element:
  #
  # `<BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01"
  # />`
  #
  # For more information about server access logging, see [Server Access
  # Logging][2] in the *Amazon S3 User Guide*.
  #
  # For more information about creating a bucket, see [CreateBucket][3].
  # For more information about returning the logging status of a bucket,
  # see [GetBucketLogging][4].
  #
  # The following operations are related to `PutBucketLogging`\:
  #
  # * [PutObject][5]
  #
  # * [DeleteBucket][6]
  #
  # * [CreateBucket][3]
  #
  # * [GetBucketLogging][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html
  #
  # @example Example: Set logging configuration for a bucket
  #
  #   # The following example sets logging policy on a bucket. For the Log Delivery group to deliver logs to the destination
  #   # bucket, it needs permission for the READ_ACP action which the policy grants.
  #
  #   resp = client.put_bucket_logging({
  #   bucket: "sourcebucket",
  #   bucket_logging_status: {
  #   logging_enabled: {
  #   target_bucket: "targetbucket",
  #   target_grants: [
  #   {
  #   grantee: {
  #   type: "Group",
  #   uri: "http://acs.amazonaws.com/groups/global/AllUsers",
  #   },
  #   permission: "READ",
  #   },
  #   ],
  #   target_prefix: "MyBucketLogs/",
  #   },
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_logging({
  #   bucket: "BucketName", # required
  #   bucket_logging_status: { # required
  #   logging_enabled: {
  #   target_bucket: "TargetBucket", # required
  #   target_grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, READ, WRITE
  #   },
  #   ],
  #   target_prefix: "TargetPrefix", # required
  #   },
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_logging
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10409
  def put_bucket_logging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets a metrics configuration (specified by the metrics configuration
  # ID) for the bucket. You can have up to 1,000 metrics configurations
  # per bucket. If you're updating an existing metrics configuration,
  # note that this is a full replacement of the existing metrics
  # configuration. If you don't include the elements you want to keep,
  # they are erased.
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutMetricsConfiguration` action. The bucket owner has this
  # permission by default. The bucket owner can grant this permission to
  # others. For more information about permissions, see [Permissions
  # Related to Bucket Subresource Operations][1] and [Managing Access
  # Permissions to Your Amazon S3 Resources][2].
  #
  # For information about CloudWatch request metrics for Amazon S3, see
  # [Monitoring Metrics with Amazon CloudWatch][3].
  #
  # The following operations are related to
  # `PutBucketMetricsConfiguration`\:
  #
  # * [DeleteBucketMetricsConfiguration][4]
  #
  # * [GetBucketMetricsConfiguration][5]
  #
  # * [ListBucketMetricsConfigurations][6]
  #
  # `GetBucketLifecycle` has the following special error:
  #
  # * Error code: `TooManyConfigurations`
  #
  #   * Description: You are attempting to create a new configuration but
  #     have already reached the 1,000-configuration limit.
  #
  #   * HTTP Status Code: HTTP 400 Bad Request
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_metrics_configuration({
  #   bucket: "BucketName", # required
  #   id: "MetricsId", # required
  #   metrics_configuration: { # required
  #   id: "MetricsId", # required
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   access_point_arn: "AccessPointArn",
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   access_point_arn: "AccessPointArn",
  #   },
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_metrics_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10507
  def put_bucket_metrics_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # No longer used, see the [PutBucketNotificationConfiguration][1]
  # operation.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotificationConfiguration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_notification({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   notification_configuration: { # required
  #   topic_configuration: {
  #   id: "NotificationId",
  #   events: ["s3:ReducedRedundancyLostObject"], # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   event: "s3:ReducedRedundancyLostObject", # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   topic: "TopicArn",
  #   },
  #   queue_configuration: {
  #   id: "NotificationId",
  #   event: "s3:ReducedRedundancyLostObject", # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   events: ["s3:ReducedRedundancyLostObject"], # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   queue: "QueueArn",
  #   },
  #   cloud_function_configuration: {
  #   id: "NotificationId",
  #   event: "s3:ReducedRedundancyLostObject", # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   events: ["s3:ReducedRedundancyLostObject"], # accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   cloud_function: "CloudFunction",
  #   invocation_role: "CloudFunctionInvocationRole",
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_notification
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10589
  def put_bucket_notification(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Enables notifications of specified events for a bucket. For more
  # information about event notifications, see [Configuring Event
  # Notifications][1].
  #
  # Using this API, you can replace an existing notification
  # configuration. The configuration is an XML file that defines the event
  # types that you want Amazon S3 to publish and the destination where you
  # want Amazon S3 to publish an event notification when it detects an
  # event of the specified type.
  #
  # By default, your bucket has no event notifications configured. That
  # is, the notification configuration will be an empty
  # `NotificationConfiguration`.
  #
  # `<NotificationConfiguration>`
  #
  # `</NotificationConfiguration>`
  #
  # This action replaces the existing notification configuration with the
  # configuration you include in the request body.
  #
  # After Amazon S3 receives this request, it first verifies that any
  # Amazon Simple Notification Service (Amazon SNS) or Amazon Simple Queue
  # Service (Amazon SQS) destination exists, and that the bucket owner has
  # permission to publish to it by sending a test notification. In the
  # case of Lambda destinations, Amazon S3 verifies that the Lambda
  # function permissions grant Amazon S3 permission to invoke the function
  # from the Amazon S3 bucket. For more information, see [Configuring
  # Notifications for Amazon S3 Events][1].
  #
  # You can disable notifications by adding the empty
  # NotificationConfiguration element.
  #
  # For more information about the number of event notification
  # configurations that you can create per bucket, see [Amazon S3 service
  # quotas][2] in *Amazon Web Services General Reference*.
  #
  # By default, only the bucket owner can configure notifications on a
  # bucket. However, bucket owners can use a bucket policy to grant
  # permission to other users to set this configuration with
  # `s3:PutBucketNotification` permission.
  #
  # <note markdown="1"> The PUT notification is an atomic operation. For example, suppose your
  # notification configuration includes SNS topic, SQS queue, and Lambda
  # function configurations. When you send a PUT request with this
  # configuration, Amazon S3 sends test messages to your SNS topic. If the
  # message fails, the entire PUT action will fail, and Amazon S3 will not
  # add the configuration to your bucket.
  #
  #  </note>
  #
  # **Responses**
  #
  # If the configuration in the request body includes only one
  # `TopicConfiguration` specifying only the
  # `s3:ReducedRedundancyLostObject` event type, the response will also
  # include the `x-amz-sns-test-message-id` header containing the message
  # ID of the test notification sent to the topic.
  #
  # The following action is related to
  # `PutBucketNotificationConfiguration`\:
  #
  # * [GetBucketNotificationConfiguration][3]
  #
  # ^
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
  # [2]: https://docs.aws.amazon.com/general/latest/gr/s3.html#limits_s3
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html
  #
  # @example Example: Set notification configuration for a bucket
  #
  #   # The following example sets notification configuration on a bucket to publish the object created events to an SNS topic.
  #
  #   resp = client.put_bucket_notification_configuration({
  #   bucket: "examplebucket",
  #   notification_configuration: {
  #   topic_configurations: [
  #   {
  #   events: [
  #   "s3:ObjectCreated:*",
  #   ],
  #   topic_arn: "arn:aws:sns:us-west-2:123456789012:s3-notification-topic",
  #   },
  #   ],
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_notification_configuration({
  #   bucket: "BucketName", # required
  #   notification_configuration: { # required
  #   topic_configurations: [
  #   {
  #   id: "NotificationId",
  #   topic_arn: "TopicArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   queue_configurations: [
  #   {
  #   id: "NotificationId",
  #   queue_arn: "QueueArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   lambda_function_configurations: [
  #   {
  #   id: "NotificationId",
  #   lambda_function_arn: "LambdaFunctionArn", # required
  #   events: ["s3:ReducedRedundancyLostObject"], # required, accepts s3:ReducedRedundancyLostObject, s3:ObjectCreated:*, s3:ObjectCreated:Put, s3:ObjectCreated:Post, s3:ObjectCreated:Copy, s3:ObjectCreated:CompleteMultipartUpload, s3:ObjectRemoved:*, s3:ObjectRemoved:Delete, s3:ObjectRemoved:DeleteMarkerCreated, s3:ObjectRestore:*, s3:ObjectRestore:Post, s3:ObjectRestore:Completed, s3:Replication:*, s3:Replication:OperationFailedReplication, s3:Replication:OperationNotTracked, s3:Replication:OperationMissedThreshold, s3:Replication:OperationReplicatedAfterThreshold, s3:ObjectRestore:Delete, s3:LifecycleTransition, s3:IntelligentTiering, s3:ObjectAcl:Put, s3:LifecycleExpiration:*, s3:LifecycleExpiration:Delete, s3:LifecycleExpiration:DeleteMarkerCreated, s3:ObjectTagging:*, s3:ObjectTagging:Put, s3:ObjectTagging:Delete
  #   filter: {
  #   key: {
  #   filter_rules: [
  #   {
  #   name: "prefix", # accepts prefix, suffix
  #   value: "FilterRuleValue",
  #   },
  #   ],
  #   },
  #   },
  #   },
  #   ],
  #   event_bridge_configuration: {
  #   },
  #   },
  #   expected_bucket_owner: "AccountId",
  #   skip_destination_validation: false,
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_notification_configuration
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10771
  def put_bucket_notification_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates or modifies `OwnershipControls` for an Amazon S3 bucket. To
  # use this operation, you must have the `s3:PutBucketOwnershipControls`
  # permission. For more information about Amazon S3 permissions, see
  # [Specifying permissions in a policy][1].
  #
  # For information about Amazon S3 Object Ownership, see [Using object
  # ownership][2].
  #
  # The following operations are related to `PutBucketOwnershipControls`\:
  #
  # * GetBucketOwnershipControls
  #
  # * DeleteBucketOwnershipControls
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/user-guide/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/user-guide/about-object-ownership.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_ownership_controls({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   expected_bucket_owner: "AccountId",
  #   ownership_controls: { # required
  #   rules: [ # required
  #   {
  #   object_ownership: "BucketOwnerPreferred", # required, accepts BucketOwnerPreferred, ObjectWriter, BucketOwnerEnforced
  #   },
  #   ],
  #   },
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_ownership_controls
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketOwnershipControls AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10836
  def put_bucket_ownership_controls(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are
  # using an identity other than the root user of the Amazon Web Services
  # account that owns the bucket, the calling identity must have the
  # `PutBucketPolicy` permissions on the specified bucket and belong to
  # the bucket owner's account in order to use this operation.
  #
  # If you don't have `PutBucketPolicy` permissions, Amazon S3 returns a
  # `403 Access Denied` error. If you have the correct permissions, but
  # you're not using an identity that belongs to the bucket owner's
  # account, Amazon S3 returns a `405 Method Not Allowed` error.
  #
  # As a security precaution, the root user of the Amazon Web Services
  # account that owns a bucket can always use this operation, even if the
  # policy explicitly denies the root user the ability to perform this
  # action.
  #
  # For more information, see [Bucket policy examples][1].
  #
  # The following operations are related to `PutBucketPolicy`\:
  #
  # * [CreateBucket][2]
  #
  # * [DeleteBucket][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html
  #
  # @example Example: Set bucket policy
  #
  #   # The following example sets a permission policy on a bucket.
  #
  #   resp = client.put_bucket_policy({
  #   bucket: "examplebucket",
  #   policy: "{\"Version\": \"2012-10-17\", \"Statement\": [{ \"Sid\": \"id-1\",\"Effect\": \"Allow\",\"Principal\": {\"AWS\": \"arn:aws:iam::123456789012:root\"}, \"Action\": [ \"s3:PutObject\",\"s3:PutObjectAcl\"], \"Resource\": [\"arn:aws:s3:::acl3/*\" ] } ]}",
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_policy({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   confirm_remove_self_bucket_access: false,
  #   policy: "Policy", # required
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_policy
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#10936
  def put_bucket_policy(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a replication configuration or replaces an existing one. For
  # more information, see [Replication][1] in the *Amazon S3 User Guide*.
  #
  # Specify the replication configuration in the request body. In the
  # replication configuration, you provide the name of the destination
  # bucket or buckets where you want Amazon S3 to replicate objects, the
  # IAM role that Amazon S3 can assume to replicate objects on your
  # behalf, and other relevant information.
  #
  # A replication configuration must include at least one rule, and can
  # contain a maximum of 1,000. Each rule identifies a subset of objects
  # to replicate by filtering the objects in the source bucket. To choose
  # additional subsets of objects to replicate, add a rule for each
  # subset.
  #
  # To specify a subset of the objects in the source bucket to apply a
  # replication rule to, add the Filter element as a child of the Rule
  # element. You can filter objects based on an object key prefix, one or
  # more object tags, or both. When you add the Filter element in the
  # configuration, you must also add the following elements:
  # `DeleteMarkerReplication`, `Status`, and `Priority`.
  #
  # <note markdown="1"> If you are using an earlier version of the replication configuration,
  # Amazon S3 handles replication of delete markers differently. For more
  # information, see [Backward Compatibility][2].
  #
  #  </note>
  #
  # For information about enabling versioning on a bucket, see [Using
  # Versioning][3].
  #
  # **Handling Replication of Encrypted Objects**
  #
  # By default, Amazon S3 doesn't replicate objects that are stored at
  # rest using server-side encryption with KMS keys. To replicate Amazon
  # Web Services KMS-encrypted objects, add the following:
  # `SourceSelectionCriteria`, `SseKmsEncryptedObjects`, `Status`,
  # `EncryptionConfiguration`, and `ReplicaKmsKeyID`. For information
  # about replication configuration, see [Replicating Objects Created with
  # SSE Using KMS keys][4].
  #
  # For information on `PutBucketReplication` errors, see [List of
  # replication-related error codes][5]
  #
  # **Permissions**
  #
  # To create a `PutBucketReplication` request, you must have
  # `s3:PutReplicationConfiguration` permissions for the bucket.
  #
  # By default, a resource owner, in this case the Amazon Web Services
  # account that created the bucket, can perform this operation. The
  # resource owner can also grant others permissions to perform the
  # operation. For more information about permissions, see [Specifying
  # Permissions in a Policy][6] and [Managing Access Permissions to Your
  # Amazon S3 Resources][7].
  #
  # <note markdown="1"> To perform this operation, the user or role performing the action must
  # have the [iam:PassRole][8] permission.
  #
  #  </note>
  #
  # The following operations are related to `PutBucketReplication`\:
  #
  # * [GetBucketReplication][9]
  #
  # * [DeleteBucketReplication][10]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [8]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html
  #
  # @example Example: Set replication configuration on a bucket
  #
  #   # The following example sets replication configuration on a bucket.
  #
  #   resp = client.put_bucket_replication({
  #   bucket: "examplebucket",
  #   replication_configuration: {
  #   role: "arn:aws:iam::123456789012:role/examplerole",
  #   rules: [
  #   {
  #   destination: {
  #   bucket: "arn:aws:s3:::destinationbucket",
  #   storage_class: "STANDARD",
  #   },
  #   prefix: "",
  #   status: "Enabled",
  #   },
  #   ],
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_replication({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   replication_configuration: { # required
  #   role: "Role", # required
  #   rules: [ # required
  #   {
  #   id: "ID",
  #   priority: 1,
  #   prefix: "Prefix",
  #   filter: {
  #   prefix: "Prefix",
  #   tag: {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   and: {
  #   prefix: "Prefix",
  #   tags: [
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   },
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   source_selection_criteria: {
  #   sse_kms_encrypted_objects: {
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   },
  #   replica_modifications: {
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   },
  #   },
  #   existing_object_replication: {
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   },
  #   destination: { # required
  #   bucket: "BucketName", # required
  #   account: "AccountId",
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   access_control_translation: {
  #   owner: "Destination", # required, accepts Destination
  #   },
  #   encryption_configuration: {
  #   replica_kms_key_id: "ReplicaKmsKeyID",
  #   },
  #   replication_time: {
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   time: { # required
  #   minutes: 1,
  #   },
  #   },
  #   metrics: {
  #   status: "Enabled", # required, accepts Enabled, Disabled
  #   event_threshold: {
  #   minutes: 1,
  #   },
  #   },
  #   },
  #   delete_marker_replication: {
  #   status: "Enabled", # accepts Enabled, Disabled
  #   },
  #   },
  #   ],
  #   },
  #   token: "ObjectLockToken",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_replication
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#11167
  def put_bucket_replication(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the request payment configuration for a bucket. By default, the
  # bucket owner pays for downloads from the bucket. This configuration
  # parameter enables the bucket owner (only) to specify that the person
  # requesting the download will be charged for the download. For more
  # information, see [Requester Pays Buckets][1].
  #
  # The following operations are related to `PutBucketRequestPayment`\:
  #
  # * [CreateBucket][2]
  #
  # * [GetBucketRequestPayment][3]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html
  #
  # @example Example: Set request payment configuration on a bucket.
  #
  #   # The following example sets request payment configuration on a bucket so that person requesting the download is charged.
  #
  #   resp = client.put_bucket_request_payment({
  #   bucket: "examplebucket",
  #   request_payment_configuration: {
  #   payer: "Requester",
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_request_payment({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   request_payment_configuration: { # required
  #   payer: "Requester", # required, accepts Requester, BucketOwner
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_request_payment
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#11260
  def put_bucket_request_payment(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the tags for a bucket.
  #
  # Use tags to organize your Amazon Web Services bill to reflect your own
  # cost structure. To do this, sign up to get your Amazon Web Services
  # account bill with tag key values included. Then, to see the cost of
  # combined resources, organize your billing information according to
  # resources with the same tag key values. For example, you can tag
  # several resources with a specific application name, and then organize
  # your billing information to see the total cost of that application
  # across several services. For more information, see [Cost Allocation
  # and Tagging][1] and [Using Cost Allocation in Amazon S3 Bucket
  # Tags][2].
  #
  # <note markdown="1"> When this operation sets the tags for a bucket, it will overwrite any
  # current tags the bucket already has. You cannot use this operation to
  # add tags to an existing list of tags.
  #
  #  </note>
  #
  # To use this operation, you must have permissions to perform the
  # `s3:PutBucketTagging` action. The bucket owner has this permission by
  # default and can grant this permission to others. For more information
  # about permissions, see [Permissions Related to Bucket Subresource
  # Operations][3] and [Managing Access Permissions to Your Amazon S3
  # Resources][4].
  #
  # `PutBucketTagging` has the following special errors:
  #
  # * Error code: `InvalidTagError`
  #
  #   * Description: The tag provided was not a valid tag. This error can
  #     occur if the tag did not pass input validation. For information
  #     about tag restrictions, see [User-Defined Tag Restrictions][5] and
  #     [Amazon Web Services-Generated Cost Allocation Tag
  #     Restrictions][6].
  #
  #   ^
  #
  # * Error code: `MalformedXMLError`
  #
  #   * Description: The XML provided does not match the schema.
  #
  #   ^
  #
  # * Error code: `OperationAbortedError `
  #
  #   * Description: A conflicting conditional action is currently in
  #     progress against this resource. Please try again.
  #
  #   ^
  #
  # * Error code: `InternalError`
  #
  #   * Description: The service was unable to apply the provided tag to
  #     the bucket.
  #
  #   ^
  #
  # The following operations are related to `PutBucketTagging`\:
  #
  # * [GetBucketTagging][7]
  #
  # * [DeleteBucketTagging][8]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/CostAllocTagging.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [5]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html
  # [6]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html
  #
  # @example Example: Set tags on a bucket
  #
  #   # The following example sets tags on a bucket. Any existing tags are replaced.
  #
  #   resp = client.put_bucket_tagging({
  #   bucket: "examplebucket",
  #   tagging: {
  #   tag_set: [
  #   {
  #   key: "Key1",
  #   value: "Value1",
  #   },
  #   {
  #   key: "Key2",
  #   value: "Value2",
  #   },
  #   ],
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_tagging({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   tagging: { # required
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_tagging
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#11424
  def put_bucket_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the versioning state of an existing bucket.
  #
  # You can set the versioning state with one of the following values:
  #
  # **Enabled**—Enables versioning for the objects in the bucket. All
  # objects added to the bucket receive a unique version ID.
  #
  # **Suspended**—Disables versioning for the objects in the bucket. All
  # objects added to the bucket receive the version ID null.
  #
  # If the versioning state has never been set on a bucket, it has no
  # versioning state; a [GetBucketVersioning][1] request does not return a
  # versioning state value.
  #
  # In order to enable MFA Delete, you must be the bucket owner. If you
  # are the bucket owner and want to enable MFA Delete in the bucket
  # versioning configuration, you must include the `x-amz-mfa request`
  # header and the `Status` and the `MfaDelete` request elements in a
  # request to set the versioning state of the bucket.
  #
  # If you have an object expiration lifecycle policy in your
  # non-versioned bucket and you want to maintain the same permanent
  # delete behavior when you enable versioning, you must add a noncurrent
  # expiration policy. The noncurrent expiration lifecycle policy will
  # manage the deletes of the noncurrent object versions in the
  # version-enabled bucket. (A version-enabled bucket maintains one
  # current and zero or more noncurrent object versions.) For more
  # information, see [Lifecycle and Versioning][2].
  #
  # **Related Resources**
  #
  # * [CreateBucket][3]
  #
  # * [DeleteBucket][4]
  #
  # * [GetBucketVersioning][1]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html
  #
  # @example Example: Set versioning configuration on a bucket
  #
  #   # The following example sets versioning configuration on bucket. The configuration enables versioning on the bucket.
  #
  #   resp = client.put_bucket_versioning({
  #   bucket: "examplebucket",
  #   versioning_configuration: {
  #   mfa_delete: "Disabled",
  #   status: "Enabled",
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_versioning({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   mfa: "MFA",
  #   versioning_configuration: { # required
  #   mfa_delete: "Enabled", # accepts Enabled, Disabled
  #   status: "Enabled", # accepts Enabled, Suspended
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_versioning
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#11551
  def put_bucket_versioning(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the configuration of the website that is specified in the
  # `website` subresource. To configure a bucket as a website, you can add
  # this subresource on the bucket with website configuration information
  # such as the file name of the index document and any redirect rules.
  # For more information, see [Hosting Websites on Amazon S3][1].
  #
  # This PUT action requires the `S3:PutBucketWebsite` permission. By
  # default, only the bucket owner can configure the website attached to a
  # bucket; however, bucket owners can allow other users to set the
  # website configuration by writing a bucket policy that grants them the
  # `S3:PutBucketWebsite` permission.
  #
  # To redirect all website requests sent to the bucket's website
  # endpoint, you add a website configuration with the following elements.
  # Because all requests are sent to another website, you don't need to
  # provide index document name for the bucket.
  #
  # * `WebsiteConfiguration`
  #
  # * `RedirectAllRequestsTo`
  #
  # * `HostName`
  #
  # * `Protocol`
  #
  # If you want granular control over redirects, you can use the following
  # elements to add routing rules that describe conditions for redirecting
  # requests and information about the redirect destination. In this case,
  # the website configuration must provide an index document for the
  # bucket, because some requests might not be redirected.
  #
  # * `WebsiteConfiguration`
  #
  # * `IndexDocument`
  #
  # * `Suffix`
  #
  # * `ErrorDocument`
  #
  # * `Key`
  #
  # * `RoutingRules`
  #
  # * `RoutingRule`
  #
  # * `Condition`
  #
  # * `HttpErrorCodeReturnedEquals`
  #
  # * `KeyPrefixEquals`
  #
  # * `Redirect`
  #
  # * `Protocol`
  #
  # * `HostName`
  #
  # * `ReplaceKeyPrefixWith`
  #
  # * `ReplaceKeyWith`
  #
  # * `HttpRedirectCode`
  #
  # Amazon S3 has a limitation of 50 routing rules per website
  # configuration. If you require more than 50 routing rules, you can use
  # object redirect. For more information, see [Configuring an Object
  # Redirect][2] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html
  #
  # @example Example: Set website configuration on a bucket
  #
  #   # The following example adds website configuration to a bucket.
  #
  #   resp = client.put_bucket_website({
  #   bucket: "examplebucket",
  #   content_md5: "",
  #   website_configuration: {
  #   error_document: {
  #   key: "error.html",
  #   },
  #   index_document: {
  #   suffix: "index.html",
  #   },
  #   },
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_bucket_website({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   website_configuration: { # required
  #   error_document: {
  #   key: "ObjectKey", # required
  #   },
  #   index_document: {
  #   suffix: "Suffix", # required
  #   },
  #   redirect_all_requests_to: {
  #   host_name: "HostName", # required
  #   protocol: "http", # accepts http, https
  #   },
  #   routing_rules: [
  #   {
  #   condition: {
  #   http_error_code_returned_equals: "HttpErrorCodeReturnedEquals",
  #   key_prefix_equals: "KeyPrefixEquals",
  #   },
  #   redirect: { # required
  #   host_name: "HostName",
  #   http_redirect_code: "HttpRedirectCode",
  #   protocol: "http", # accepts http, https
  #   replace_key_prefix_with: "ReplaceKeyPrefixWith",
  #   replace_key_with: "ReplaceKeyWith",
  #   },
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_bucket_website
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#11729
  def put_bucket_website(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds an object to a bucket. You must have WRITE permissions on a
  # bucket to add an object to it.
  #
  # Amazon S3 never adds partial objects; if you receive a success
  # response, Amazon S3 added the entire object to the bucket.
  #
  # Amazon S3 is a distributed system. If it receives multiple write
  # requests for the same object simultaneously, it overwrites all but the
  # last object written. Amazon S3 does not provide object locking; if you
  # need this, make sure to build it into your application layer or use
  # versioning instead.
  #
  # To ensure that data is not corrupted traversing the network, use the
  # `Content-MD5` header. When you use this header, Amazon S3 checks the
  # object against the provided MD5 value and, if they do not match,
  # returns an error. Additionally, you can calculate the MD5 while
  # putting an object to Amazon S3 and compare the returned ETag to the
  # calculated MD5 value.
  #
  # <note markdown="1"> * To successfully complete the `PutObject` request, you must have the
  #   `s3:PutObject` in your IAM permissions.
  #
  # * To successfully change the objects acl of your `PutObject` request,
  #   you must have the `s3:PutObjectAcl` in your IAM permissions.
  #
  # * The `Content-MD5` header is required for any request to upload an
  #   object with a retention period configured using Amazon S3 Object
  #   Lock. For more information about Amazon S3 Object Lock, see [Amazon
  #   S3 Object Lock Overview][1] in the *Amazon S3 User Guide*.
  #
  #  </note>
  #
  # **Server-side Encryption**
  #
  # You can optionally request server-side encryption. With server-side
  # encryption, Amazon S3 encrypts your data as it writes it to disks in
  # its data centers and decrypts the data when you access it. You have
  # the option to provide your own encryption key or use Amazon Web
  # Services managed encryption keys (SSE-S3 or SSE-KMS). For more
  # information, see [Using Server-Side Encryption][2].
  #
  # If you request server-side encryption using Amazon Web Services Key
  # Management Service (SSE-KMS), you can enable an S3 Bucket Key at the
  # object-level. For more information, see [Amazon S3 Bucket Keys][3] in
  # the *Amazon S3 User Guide*.
  #
  # **Access Control List (ACL)-Specific Request Headers**
  #
  # You can use headers to grant ACL- based permissions. By default, all
  # objects are private. Only the owner has full access control. When
  # adding a new object, you can grant permissions to individual Amazon
  # Web Services accounts or to predefined groups defined by Amazon S3.
  # These permissions are then added to the ACL on the object. For more
  # information, see [Access Control List (ACL) Overview][4] and [Managing
  # ACLs Using the REST API][5].
  #
  # If the bucket that you're uploading objects to uses the bucket owner
  # enforced setting for S3 Object Ownership, ACLs are disabled and no
  # longer affect permissions. Buckets that use this setting only accept
  # PUT requests that don't specify an ACL or PUT requests that specify
  # bucket owner full control ACLs, such as the
  # `bucket-owner-full-control` canned ACL or an equivalent form of this
  # ACL expressed in the XML format. PUT requests that contain other ACLs
  # (for example, custom grants to certain Amazon Web Services accounts)
  # fail and return a `400` error with the error code
  # `AccessControlListNotSupported`.
  #
  # For more information, see [ Controlling ownership of objects and
  # disabling ACLs][6] in the *Amazon S3 User Guide*.
  #
  # <note markdown="1"> If your bucket uses the bucket owner enforced setting for Object
  # Ownership, all objects written to the bucket by any account will be
  # owned by the bucket owner.
  #
  #  </note>
  #
  # **Storage Class Options**
  #
  # By default, Amazon S3 uses the STANDARD Storage Class to store newly
  # created objects. The STANDARD storage class provides high durability
  # and high availability. Depending on performance needs, you can specify
  # a different Storage Class. Amazon S3 on Outposts only uses the
  # OUTPOSTS Storage Class. For more information, see [Storage Classes][7]
  # in the *Amazon S3 User Guide*.
  #
  # **Versioning**
  #
  # If you enable versioning for a bucket, Amazon S3 automatically
  # generates a unique version ID for the object being stored. Amazon S3
  # returns this ID in the response. When you enable versioning for a
  # bucket, if Amazon S3 receives multiple write requests for the same
  # object simultaneously, it stores all of the objects.
  #
  # For more information about versioning, see [Adding Objects to
  # Versioning Enabled Buckets][8]. For information about returning the
  # versioning state of a bucket, see [GetBucketVersioning][9].
  #
  # **Related Resources**
  #
  # * [CopyObject][10]
  #
  # * [DeleteObject][11]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
  #
  # @example Example: To create an object.
  #
  #   # The following example creates an object. If the bucket is versioning enabled, S3 returns version ID in response.
  #
  #   resp = client.put_object({
  #   body: "filetoupload",
  #   bucket: "examplebucket",
  #   key: "objectkey",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   version_id: "Bvq0EDKxOcXLJXNo_Lkz37eM3R4pfzyQ",
  #   }
  # @example Example: To upload an object
  #
  #   # The following example uploads an object to a versioning-enabled bucket. The source file is specified using Windows file
  #   # syntax. S3 returns VersionId of the newly created object.
  #
  #   resp = client.put_object({
  #   body: "HappyFace.jpg",
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   version_id: "tpf3zF08nBplQK1XLOefGskR7mGDwcDk",
  #   }
  # @example Example: To upload object and specify user-defined metadata
  #
  #   # The following example creates an object. The request also specifies optional metadata. If the bucket is versioning
  #   # enabled, S3 returns version ID in response.
  #
  #   resp = client.put_object({
  #   body: "filetoupload",
  #   bucket: "examplebucket",
  #   key: "exampleobject",
  #   metadata: {
  #   "metadata1" => "value1",
  #   "metadata2" => "value2",
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   version_id: "pSKidl4pHBiNwukdbcPXAIs.sshFFOc0",
  #   }
  # @example Example: To upload an object and specify optional tags
  #
  #   # The following example uploads an object. The request specifies optional object tags. The bucket is versioned, therefore
  #   # S3 returns version ID of the newly created object.
  #
  #   resp = client.put_object({
  #   body: "c:\\HappyFace.jpg",
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   tagging: "key1=value1&key2=value2",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   version_id: "psM2sYY4.o1501dSx8wMvnkOzSBB.V4a",
  #   }
  # @example Example: To upload an object (specify optional headers)
  #
  #   # The following example uploads an object. The request specifies optional request headers to directs S3 to use specific
  #   # storage class and use server-side encryption.
  #
  #   resp = client.put_object({
  #   body: "HappyFace.jpg",
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   server_side_encryption: "AES256",
  #   storage_class: "STANDARD_IA",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   server_side_encryption: "AES256",
  #   version_id: "CG612hodqujkf8FaaNfp8U..FIhLROcp",
  #   }
  # @example Example: To upload an object and specify server-side encryption and object tags
  #
  #   # The following example uploads and object. The request specifies the optional server-side encryption option. The request
  #   # also specifies optional object tags. If the bucket is versioning enabled, S3 returns version ID in response.
  #
  #   resp = client.put_object({
  #   body: "filetoupload",
  #   bucket: "examplebucket",
  #   key: "exampleobject",
  #   server_side_encryption: "AES256",
  #   tagging: "key1=value1&key2=value2",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   server_side_encryption: "AES256",
  #   version_id: "Ri.vC6qVlA4dEnjgRV4ZHsHoFIjqEMNt",
  #   }
  # @example Example: To upload an object and specify canned ACL.
  #
  #   # The following example uploads and object. The request specifies optional canned ACL (access control list) to all READ
  #   # access to authenticated users. If the bucket is versioning enabled, S3 returns version ID in response.
  #
  #   resp = client.put_object({
  #   acl: "authenticated-read",
  #   body: "filetoupload",
  #   bucket: "examplebucket",
  #   key: "exampleobject",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"6805f2cfc46c0f04559748bb039d69ae\"",
  #   version_id: "Kirh.unyZwjQ69YxcQLA8z4F5j3kJJKr",
  #   }
  # @example Streaming a file from disk
  #   # upload file from disk in a single request, may not exceed 5GB
  #   File.open('/source/file/path', 'rb') do |file|
  #   s3.put_object(bucket: 'bucket-name', key: 'object-key', body: file)
  #   end
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   body: source_file,
  #   bucket: "BucketName", # required
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   content_type: "ContentType",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   key: "ObjectKey", # required
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.expiration #=> String
  #   resp.etag #=> String
  #   resp.checksum_crc32 #=> String
  #   resp.checksum_crc32c #=> String
  #   resp.checksum_sha1 #=> String
  #   resp.checksum_sha256 #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.version_id #=> String
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.ssekms_encryption_context #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object
  # @param params [Hash] ({})
  # @return [Types::PutObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectOutput#expiration #expiration} => String
  #   * {Types::PutObjectOutput#etag #etag} => String
  #   * {Types::PutObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::PutObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::PutObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::PutObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::PutObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::PutObjectOutput#version_id #version_id} => String
  #   * {Types::PutObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::PutObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::PutObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::PutObjectOutput#ssekms_encryption_context #ssekms_encryption_context} => String
  #   * {Types::PutObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::PutObjectOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#12384
  def put_object(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Uses the `acl` subresource to set the access control list (ACL)
  # permissions for a new or existing object in an S3 bucket. You must
  # have `WRITE_ACP` permission to set the ACL of an object. For more
  # information, see [What permissions can I grant?][1] in the *Amazon S3
  # User Guide*.
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # Depending on your application needs, you can choose to set the ACL on
  # an object using either the request body or the headers. For example,
  # if you have an existing application that updates a bucket ACL using
  # the request body, you can continue to use that approach. For more
  # information, see [Access Control List (ACL) Overview][2] in the
  # *Amazon S3 User Guide*.
  #
  # If your bucket uses the bucket owner enforced setting for S3 Object
  # Ownership, ACLs are disabled and no longer affect permissions. You
  # must use policies to grant access to your bucket and the objects in
  # it. Requests to set ACLs or update ACLs fail and return the
  # `AccessControlListNotSupported` error code. Requests to read ACLs are
  # still supported. For more information, see [Controlling object
  # ownership][3] in the *Amazon S3 User Guide*.
  #
  # **Access Permissions**
  #
  # You can set access permissions using one of the following methods:
  #
  # * Specify a canned ACL with the `x-amz-acl` request header. Amazon S3
  #   supports a set of predefined ACLs, known as canned ACLs. Each canned
  #   ACL has a predefined set of grantees and permissions. Specify the
  #   canned ACL name as the value of `x-amz-ac`l. If you use this header,
  #   you cannot use other access control-specific headers in your
  #   request. For more information, see [Canned ACL][4].
  #
  # * Specify access permissions explicitly with the `x-amz-grant-read`,
  #   `x-amz-grant-read-acp`, `x-amz-grant-write-acp`, and
  #   `x-amz-grant-full-control` headers. When using these headers, you
  #   specify explicit access permissions and grantees (Amazon Web
  #   Services accounts or Amazon S3 groups) who will receive the
  #   permission. If you use these ACL-specific headers, you cannot use
  #   `x-amz-acl` header to set a canned ACL. These parameters map to the
  #   set of permissions that Amazon S3 supports in an ACL. For more
  #   information, see [Access Control List (ACL) Overview][2].
  #
  #   You specify each grantee as a type=value pair, where the type is one
  #   of the following:
  #
  #   * `id` – if the value specified is the canonical user ID of an
  #     Amazon Web Services account
  #
  #   * `uri` – if you are granting permissions to a predefined group
  #
  #   * `emailAddress` – if the value specified is the email address of an
  #     Amazon Web Services account
  #
  #     <note markdown="1"> Using email addresses to specify a grantee is only supported in
  #     the following Amazon Web Services Regions:
  #
  #      * US East (N. Virginia)
  #
  #     * US West (N. California)
  #
  #     * US West (Oregon)
  #
  #     * Asia Pacific (Singapore)
  #
  #     * Asia Pacific (Sydney)
  #
  #     * Asia Pacific (Tokyo)
  #
  #     * Europe (Ireland)
  #
  #     * South America (São Paulo)
  #
  #      For a list of all the Amazon S3 supported Regions and endpoints,
  #     see [Regions and Endpoints][5] in the Amazon Web Services General
  #     Reference.
  #
  #      </note>
  #
  #   For example, the following `x-amz-grant-read` header grants list
  #   objects permission to the two Amazon Web Services accounts
  #   identified by their email addresses.
  #
  #   `x-amz-grant-read: emailAddress="xyz@amazon.com",
  #   emailAddress="abc@amazon.com" `
  #
  # You can use either a canned ACL or specify access permissions
  # explicitly. You cannot do both.
  #
  # **Grantee Values**
  #
  # You can specify the person (grantee) to whom you're assigning access
  # rights (using request elements) in the following ways:
  #
  # * By the person's ID:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
  #   </Grantee>`
  #
  #   DisplayName is optional and ignored in the request.
  #
  # * By URI:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>`
  #
  # * By Email address:
  #
  #   `<Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  #   xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>`
  #
  #   The grantee is resolved to the CanonicalUser and, in a response to a
  #   GET Object acl request, appears as the CanonicalUser.
  #
  #   <note markdown="1"> Using email addresses to specify a grantee is only supported in the
  #   following Amazon Web Services Regions:
  #
  #    * US East (N. Virginia)
  #
  #   * US West (N. California)
  #
  #   * US West (Oregon)
  #
  #   * Asia Pacific (Singapore)
  #
  #   * Asia Pacific (Sydney)
  #
  #   * Asia Pacific (Tokyo)
  #
  #   * Europe (Ireland)
  #
  #   * South America (São Paulo)
  #
  #    For a list of all the Amazon S3 supported Regions and endpoints, see
  #   [Regions and Endpoints][5] in the Amazon Web Services General
  #   Reference.
  #
  #    </note>
  #
  # **Versioning**
  #
  # The ACL of an object is set at the object version level. By default,
  # PUT sets the ACL of the current version of an object. To set the ACL
  # of a different version, use the `versionId` subresource.
  #
  # **Related Resources**
  #
  # * [CopyObject][6]
  #
  # * [GetObject][7]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL
  # [5]: https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  #
  # @example Example: To grant permissions using object ACL
  #
  #   # The following example adds grants to an object ACL. The first permission grants user1 and user2 FULL_CONTROL and the
  #   # AllUsers group READ permission.
  #
  #   resp = client.put_object_acl({
  #   access_control_policy: {
  #   },
  #   bucket: "examplebucket",
  #   grant_full_control: "emailaddress=user1@example.com,emailaddress=user2@example.com",
  #   grant_read: "uri=http://acs.amazonaws.com/groups/global/AllUsers",
  #   key: "HappyFace.jpg",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object_acl({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   access_control_policy: {
  #   grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   owner: {
  #   display_name: "DisplayName",
  #   id: "ID",
  #   },
  #   },
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   key: "ObjectKey", # required
  #   request_payer: "requester", # accepts requester
  #   version_id: "ObjectVersionId",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object_acl
  # @param params [Hash] ({})
  # @return [Types::PutObjectAclOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectAclOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#12748
  def put_object_acl(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Applies a legal hold configuration to the specified object. For more
  # information, see [Locking Objects][1].
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object_legal_hold({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   legal_hold: {
  #   status: "ON", # accepts ON, OFF
  #   },
  #   request_payer: "requester", # accepts requester
  #   version_id: "ObjectVersionId",
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object_legal_hold
  # @param params [Hash] ({})
  # @return [Types::PutObjectLegalHoldOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectLegalHoldOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLegalHold AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#12854
  def put_object_legal_hold(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Places an Object Lock configuration on the specified bucket. The rule
  # specified in the Object Lock configuration will be applied by default
  # to every new object placed in the specified bucket. For more
  # information, see [Locking Objects][1].
  #
  # <note markdown="1"> * The `DefaultRetention` settings require both a mode and a period.
  #
  # * The `DefaultRetention` period can be either `Days` or `Years` but
  #   you must select one. You cannot specify `Days` and `Years` at the
  #   same time.
  #
  # * You can only enable Object Lock for new buckets. If you want to turn
  #   on Object Lock for an existing bucket, contact Amazon Web Services
  #   Support.
  #
  #  </note>
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object_lock_configuration({
  #   bucket: "BucketName", # required
  #   object_lock_configuration: {
  #   object_lock_enabled: "Enabled", # accepts Enabled
  #   rule: {
  #   default_retention: {
  #   mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   days: 1,
  #   years: 1,
  #   },
  #   },
  #   },
  #   request_payer: "requester", # accepts requester
  #   token: "ObjectLockToken",
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object_lock_configuration
  # @param params [Hash] ({})
  # @return [Types::PutObjectLockConfigurationOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectLockConfigurationOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLockConfiguration AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#12963
  def put_object_lock_configuration(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Places an Object Retention configuration on an object. For more
  # information, see [Locking Objects][1]. Users or accounts require the
  # `s3:PutObjectRetention` permission in order to place an Object
  # Retention configuration on objects. Bypassing a Governance Retention
  # configuration requires the `s3:BypassGovernanceRetention` permission.
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object_retention({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   retention: {
  #   mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   retain_until_date: Time.now,
  #   },
  #   request_payer: "requester", # accepts requester
  #   version_id: "ObjectVersionId",
  #   bypass_governance_retention: false,
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object_retention
  # @param params [Hash] ({})
  # @return [Types::PutObjectRetentionOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectRetentionOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectRetention AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#13079
  def put_object_retention(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the supplied tag-set to an object that already exists in a
  # bucket.
  #
  # A tag is a key-value pair. You can associate tags with an object by
  # sending a PUT request against the tagging subresource that is
  # associated with the object. You can retrieve tags by sending a GET
  # request. For more information, see [GetObjectTagging][1].
  #
  # For tagging-related restrictions related to characters and encodings,
  # see [Tag Restrictions][2]. Note that Amazon S3 limits the maximum
  # number of tags to 10 tags per object.
  #
  # To use this operation, you must have permission to perform the
  # `s3:PutObjectTagging` action. By default, the bucket owner has this
  # permission and can grant this permission to others.
  #
  # To put tags of any other version, use the `versionId` query parameter.
  # You also need permission for the `s3:PutObjectVersionTagging` action.
  #
  # For information about the Amazon S3 object tagging feature, see
  # [Object Tagging][3].
  #
  # **Special Errors**
  #
  # * * <i>Code: InvalidTagError </i>
  #
  #   * *Cause: The tag provided was not a valid tag. This error can occur
  #     if the tag did not pass input validation. For more information,
  #     see [Object Tagging][3].*
  #
  # * * <i>Code: MalformedXMLError </i>
  #
  #   * *Cause: The XML provided does not match the schema.*
  #
  # * * <i>Code: OperationAbortedError </i>
  #
  #   * *Cause: A conflicting conditional action is currently in progress
  #     against this resource. Please try again.*
  #
  # * * *Code: InternalError*
  #
  #   * *Cause: The service was unable to apply the provided tag to the
  #     object.*
  #
  # **Related Resources**
  #
  # * [GetObjectTagging][1]
  #
  # * [DeleteObjectTagging][4]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html
  # [2]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html
  #
  # @example Example: To add tags to an existing object
  #
  #   # The following example adds tags to an existing object.
  #
  #   resp = client.put_object_tagging({
  #   bucket: "examplebucket",
  #   key: "HappyFace.jpg",
  #   tagging: {
  #   tag_set: [
  #   {
  #   key: "Key3",
  #   value: "Value3",
  #   },
  #   {
  #   key: "Key4",
  #   value: "Value4",
  #   },
  #   ],
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   version_id: "null",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_object_tagging({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   tagging: { # required
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   expected_bucket_owner: "AccountId",
  #   request_payer: "requester", # accepts requester
  #   })
  # @example Response structure
  #
  #   resp.version_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_object_tagging
  # @param params [Hash] ({})
  # @return [Types::PutObjectTaggingOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectTaggingOutput#version_id #version_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#13273
  def put_object_tagging(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates or modifies the `PublicAccessBlock` configuration for an
  # Amazon S3 bucket. To use this operation, you must have the
  # `s3:PutBucketPublicAccessBlock` permission. For more information about
  # Amazon S3 permissions, see [Specifying Permissions in a Policy][1].
  #
  # When Amazon S3 evaluates the `PublicAccessBlock` configuration for a
  # bucket or an object, it checks the `PublicAccessBlock` configuration
  # for both the bucket (or the bucket that contains the object) and the
  # bucket owner's account. If the `PublicAccessBlock` configurations are
  # different between the bucket and the account, Amazon S3 uses the most
  # restrictive combination of the bucket-level and account-level
  # settings.
  #
  # For more information about when Amazon S3 considers a bucket or an
  # object public, see [The Meaning of "Public"][2].
  #
  # **Related Resources**
  #
  # * [GetPublicAccessBlock][3]
  #
  # * [DeletePublicAccessBlock][4]
  #
  # * [GetBucketPolicyStatus][5]
  #
  # * [Using Amazon S3 Block Public Access][6]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_public_access_block({
  #   bucket: "BucketName", # required
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   public_access_block_configuration: { # required
  #   block_public_acls: false,
  #   ignore_public_acls: false,
  #   block_public_policy: false,
  #   restrict_public_buckets: false,
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_public_access_block
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutPublicAccessBlock AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#13377
  def put_public_access_block(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Restores an archived copy of an object back into Amazon S3
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # This action performs the following types of requests:
  #
  # * `select` - Perform a select query on an archived object
  #
  # * `restore an archive` - Restore an archived object
  #
  # To use this operation, you must have permissions to perform the
  # `s3:RestoreObject` action. The bucket owner has this permission by
  # default and can grant this permission to others. For more information
  # about permissions, see [Permissions Related to Bucket Subresource
  # Operations][1] and [Managing Access Permissions to Your Amazon S3
  # Resources][2] in the *Amazon S3 User Guide*.
  #
  # **Querying Archives with Select Requests**
  #
  # You use a select type of request to perform SQL queries on archived
  # objects. The archived objects that are being queried by the select
  # request must be formatted as uncompressed comma-separated values (CSV)
  # files. You can run queries and custom analytics on your archived data
  # without having to restore your data to a hotter Amazon S3 tier. For an
  # overview about select requests, see [Querying Archived Objects][3] in
  # the *Amazon S3 User Guide*.
  #
  # When making a select request, do the following:
  #
  # * Define an output location for the select query's output. This must
  #   be an Amazon S3 bucket in the same Amazon Web Services Region as the
  #   bucket that contains the archive object that is being queried. The
  #   Amazon Web Services account that initiates the job must have
  #   permissions to write to the S3 bucket. You can specify the storage
  #   class and encryption for the output objects stored in the bucket.
  #   For more information about output, see [Querying Archived
  #   Objects][3] in the *Amazon S3 User Guide*.
  #
  #   For more information about the `S3` structure in the request body,
  #   see the following:
  #
  #   * [PutObject][4]
  #
  #   * [Managing Access with ACLs][5] in the *Amazon S3 User Guide*
  #
  #   * [Protecting Data Using Server-Side Encryption][6] in the *Amazon
  #     S3 User Guide*
  #
  # * Define the SQL expression for the `SELECT` type of restoration for
  #   your query in the request body's `SelectParameters` structure. You
  #   can use expressions like the following examples.
  #
  #   * The following expression returns all records from the specified
  #     object.
  #
  #     `SELECT * FROM Object`
  #
  #   * Assuming that you are not using any headers for data stored in the
  #     object, you can specify columns with positional headers.
  #
  #     `SELECT s._1, s._2 FROM Object s WHERE s._3 > 100`
  #
  #   * If you have headers and you set the `fileHeaderInfo` in the `CSV`
  #     structure in the request body to `USE`, you can specify headers in
  #     the query. (If you set the `fileHeaderInfo` field to `IGNORE`, the
  #     first row is skipped for the query.) You cannot mix ordinal
  #     positions with header column names.
  #
  #     `SELECT s.Id, s.FirstName, s.SSN FROM S3Object s`
  #
  # For more information about using SQL with S3 Glacier Select restore,
  # see [SQL Reference for Amazon S3 Select and S3 Glacier Select][7] in
  # the *Amazon S3 User Guide*.
  #
  # When making a select request, you can also do the following:
  #
  # * To expedite your queries, specify the `Expedited` tier. For more
  #   information about tiers, see "Restoring Archives," later in this
  #   topic.
  #
  # * Specify details about the data serialization format of both the
  #   input object that is being queried and the serialization of the
  #   CSV-encoded query results.
  #
  # The following are additional important facts about the select feature:
  #
  # * The output results are new Amazon S3 objects. Unlike archive
  #   retrievals, they are stored until explicitly deleted-manually or
  #   through a lifecycle policy.
  #
  # * You can issue more than one select request on the same Amazon S3
  #   object. Amazon S3 doesn't deduplicate requests, so avoid issuing
  #   duplicate requests.
  #
  # * Amazon S3 accepts a select request even if the object has already
  #   been restored. A select request doesn’t return error response `409`.
  #
  # **Restoring objects**
  #
  # Objects that you archive to the S3 Glacier or S3 Glacier Deep Archive
  # storage class, and S3 Intelligent-Tiering Archive or S3
  # Intelligent-Tiering Deep Archive tiers are not accessible in real
  # time. For objects in Archive Access or Deep Archive Access tiers you
  # must first initiate a restore request, and then wait until the object
  # is moved into the Frequent Access tier. For objects in S3 Glacier or
  # S3 Glacier Deep Archive storage classes you must first initiate a
  # restore request, and then wait until a temporary copy of the object is
  # available. To access an archived object, you must restore the object
  # for the duration (number of days) that you specify.
  #
  # To restore a specific object version, you can provide a version ID. If
  # you don't provide a version ID, Amazon S3 restores the current
  # version.
  #
  # When restoring an archived object (or using a select request), you can
  # specify one of the following data access tier options in the `Tier`
  # element of the request body:
  #
  # * `Expedited` - Expedited retrievals allow you to quickly access your
  #   data stored in the S3 Glacier storage class or S3
  #   Intelligent-Tiering Archive tier when occasional urgent requests for
  #   a subset of archives are required. For all but the largest archived
  #   objects (250 MB+), data accessed using Expedited retrievals is
  #   typically made available within 1–5 minutes. Provisioned capacity
  #   ensures that retrieval capacity for Expedited retrievals is
  #   available when you need it. Expedited retrievals and provisioned
  #   capacity are not available for objects stored in the S3 Glacier Deep
  #   Archive storage class or S3 Intelligent-Tiering Deep Archive tier.
  #
  # * `Standard` - Standard retrievals allow you to access any of your
  #   archived objects within several hours. This is the default option
  #   for retrieval requests that do not specify the retrieval option.
  #   Standard retrievals typically finish within 3–5 hours for objects
  #   stored in the S3 Glacier storage class or S3 Intelligent-Tiering
  #   Archive tier. They typically finish within 12 hours for objects
  #   stored in the S3 Glacier Deep Archive storage class or S3
  #   Intelligent-Tiering Deep Archive tier. Standard retrievals are free
  #   for objects stored in S3 Intelligent-Tiering.
  #
  # * `Bulk` - Bulk retrievals are the lowest-cost retrieval option in S3
  #   Glacier, enabling you to retrieve large amounts, even petabytes, of
  #   data inexpensively. Bulk retrievals typically finish within 5–12
  #   hours for objects stored in the S3 Glacier storage class or S3
  #   Intelligent-Tiering Archive tier. They typically finish within 48
  #   hours for objects stored in the S3 Glacier Deep Archive storage
  #   class or S3 Intelligent-Tiering Deep Archive tier. Bulk retrievals
  #   are free for objects stored in S3 Intelligent-Tiering.
  #
  # For more information about archive retrieval options and provisioned
  # capacity for `Expedited` data access, see [Restoring Archived
  # Objects][8] in the *Amazon S3 User Guide*.
  #
  # You can use Amazon S3 restore speed upgrade to change the restore
  # speed to a faster speed while it is in progress. For more information,
  # see [ Upgrading the speed of an in-progress restore][9] in the *Amazon
  # S3 User Guide*.
  #
  # To get the status of object restoration, you can send a `HEAD`
  # request. Operations return the `x-amz-restore` header, which provides
  # information about the restoration status, in the response. You can use
  # Amazon S3 event notifications to notify you when a restore is
  # initiated or completed. For more information, see [Configuring Amazon
  # S3 Event Notifications][10] in the *Amazon S3 User Guide*.
  #
  # After restoring an archived object, you can update the restoration
  # period by reissuing the request with a new period. Amazon S3 updates
  # the restoration period relative to the current time and charges only
  # for the request-there are no data transfer charges. You cannot update
  # the restoration period when Amazon S3 is actively processing your
  # current restore request for the object.
  #
  # If your bucket has a lifecycle configuration with a rule that includes
  # an expiration action, the object expiration overrides the life span
  # that you specify in a restore request. For example, if you restore an
  # object copy for 10 days, but the object is scheduled to expire in 3
  # days, Amazon S3 deletes the object in 3 days. For more information
  # about lifecycle configuration, see
  # [PutBucketLifecycleConfiguration][11] and [Object Lifecycle
  # Management][12] in *Amazon S3 User Guide*.
  #
  # **Responses**
  #
  # A successful action returns either the `200 OK` or `202 Accepted`
  # status code.
  #
  # * If the object is not previously restored, then Amazon S3 returns
  #   `202 Accepted` in the response.
  #
  # * If the object is previously restored, Amazon S3 returns `200 OK` in
  #   the response.
  #
  # **Special Errors**
  #
  # * * *Code: RestoreAlreadyInProgress*
  #
  #   * *Cause: Object restore is already in progress. (This error does
  #     not apply to SELECT type requests.)*
  #
  #   * *HTTP Status Code: 409 Conflict*
  #
  #   * *SOAP Fault Code Prefix: Client*
  #
  # * * *Code: GlacierExpeditedRetrievalNotAvailable*
  #
  #   * *Cause: expedited retrievals are currently not available. Try
  #     again later. (Returned if there is insufficient capacity to
  #     process the Expedited request. This error applies only to
  #     Expedited retrievals and not to S3 Standard or Bulk retrievals.)*
  #
  #   * *HTTP Status Code: 503*
  #
  #   * *SOAP Fault Code Prefix: N/A*
  #
  # **Related Resources**
  #
  # * [PutBucketLifecycleConfiguration][11]
  #
  # * [GetBucketNotificationConfiguration][13]
  #
  # * [SQL Reference for Amazon S3 Select and S3 Glacier Select ][7] in
  #   the *Amazon S3 User Guide*
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html#restoring-objects-upgrade-tier.title.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html
  # [12]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
  # [13]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html
  #
  # @example Example: To restore an archived object
  #
  #   # The following example restores for one day an archived copy of an object back into Amazon S3 bucket.
  #
  #   resp = client.restore_object({
  #   bucket: "examplebucket",
  #   key: "archivedobjectkey",
  #   restore_request: {
  #   days: 1,
  #   glacier_job_parameters: {
  #   tier: "Expedited",
  #   },
  #   },
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.restore_object({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   version_id: "ObjectVersionId",
  #   restore_request: {
  #   days: 1,
  #   glacier_job_parameters: {
  #   tier: "Standard", # required, accepts Standard, Bulk, Expedited
  #   },
  #   type: "SELECT", # accepts SELECT
  #   tier: "Standard", # accepts Standard, Bulk, Expedited
  #   description: "Description",
  #   select_parameters: {
  #   input_serialization: { # required
  #   csv: {
  #   file_header_info: "USE", # accepts USE, IGNORE, NONE
  #   comments: "Comments",
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   allow_quoted_record_delimiter: false,
  #   },
  #   compression_type: "NONE", # accepts NONE, GZIP, BZIP2
  #   json: {
  #   type: "DOCUMENT", # accepts DOCUMENT, LINES
  #   },
  #   parquet: {
  #   },
  #   },
  #   expression_type: "SQL", # required, accepts SQL
  #   expression: "Expression", # required
  #   output_serialization: { # required
  #   csv: {
  #   quote_fields: "ALWAYS", # accepts ALWAYS, ASNEEDED
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   },
  #   json: {
  #   record_delimiter: "RecordDelimiter",
  #   },
  #   },
  #   },
  #   output_location: {
  #   s3: {
  #   bucket_name: "BucketName", # required
  #   prefix: "LocationPrefix", # required
  #   encryption: {
  #   encryption_type: "AES256", # required, accepts AES256, aws:kms
  #   kms_key_id: "SSEKMSKeyId",
  #   kms_context: "KMSContext",
  #   },
  #   canned_acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   access_control_list: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   tagging: {
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   user_metadata: [
  #   {
  #   name: "MetadataKey",
  #   value: "MetadataValue",
  #   },
  #   ],
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   },
  #   },
  #   },
  #   request_payer: "requester", # accepts requester
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.request_charged #=> String, one of "requester"
  #   resp.restore_output_path #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload restore_object
  # @param params [Hash] ({})
  # @return [Types::RestoreObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::RestoreObjectOutput#request_charged #request_charged} => String
  #   * {Types::RestoreObjectOutput#restore_output_path #restore_output_path} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#13812
  def restore_object(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # This action filters the contents of an Amazon S3 object based on a
  # simple structured query language (SQL) statement. In the request,
  # along with the SQL expression, you must also specify a data
  # serialization format (JSON, CSV, or Apache Parquet) of the object.
  # Amazon S3 uses this format to parse object data into records, and
  # returns only records that match the specified SQL expression. You must
  # also specify the data serialization format for the response.
  #
  # This action is not supported by Amazon S3 on Outposts.
  #
  # For more information about Amazon S3 Select, see [Selecting Content
  # from Objects][1] and [SELECT Command][2] in the *Amazon S3 User
  # Guide*.
  #
  # For more information about using SQL with Amazon S3 Select, see [ SQL
  # Reference for Amazon S3 Select and S3 Glacier Select][3] in the
  # *Amazon S3 User Guide*.
  #
  #
  #
  # **Permissions**
  #
  # You must have `s3:GetObject` permission for this operation. Amazon S3
  # Select does not support anonymous access. For more information about
  # permissions, see [Specifying Permissions in a Policy][4] in the
  # *Amazon S3 User Guide*.
  #
  #
  #
  # *Object Data Formats*
  #
  # You can use Amazon S3 Select to query objects that have the following
  # format properties:
  #
  # * *CSV, JSON, and Parquet* - Objects must be in CSV, JSON, or Parquet
  #   format.
  #
  # * *UTF-8* - UTF-8 is the only encoding type Amazon S3 Select supports.
  #
  # * *GZIP or BZIP2* - CSV and JSON files can be compressed using GZIP or
  #   BZIP2. GZIP and BZIP2 are the only compression formats that Amazon
  #   S3 Select supports for CSV and JSON files. Amazon S3 Select supports
  #   columnar compression for Parquet using GZIP or Snappy. Amazon S3
  #   Select does not support whole-object compression for Parquet
  #   objects.
  #
  # * *Server-side encryption* - Amazon S3 Select supports querying
  #   objects that are protected with server-side encryption.
  #
  #   For objects that are encrypted with customer-provided encryption
  #   keys (SSE-C), you must use HTTPS, and you must use the headers that
  #   are documented in the [GetObject][5]. For more information about
  #   SSE-C, see [Server-Side Encryption (Using Customer-Provided
  #   Encryption Keys)][6] in the *Amazon S3 User Guide*.
  #
  #   For objects that are encrypted with Amazon S3 managed encryption
  #   keys (SSE-S3) and Amazon Web Services KMS keys (SSE-KMS),
  #   server-side encryption is handled transparently, so you don't need
  #   to specify anything. For more information about server-side
  #   encryption, including SSE-S3 and SSE-KMS, see [Protecting Data Using
  #   Server-Side Encryption][7] in the *Amazon S3 User Guide*.
  #
  # **Working with the Response Body**
  #
  # Given the response size is unknown, Amazon S3 Select streams the
  # response as a series of messages and includes a `Transfer-Encoding`
  # header with `chunked` as its value in the response. For more
  # information, see [Appendix: SelectObjectContent Response][8].
  #
  #
  #
  # **GetObject Support**
  #
  # The `SelectObjectContent` action does not support the following
  # `GetObject` functionality. For more information, see [GetObject][5].
  #
  # * `Range`\: Although you can specify a scan range for an Amazon S3
  #   Select request (see [SelectObjectContentRequest - ScanRange][9] in
  #   the request parameters), you cannot specify the range of bytes of an
  #   object to return.
  #
  # * GLACIER, DEEP\_ARCHIVE and REDUCED\_REDUNDANCY storage classes: You
  #   cannot specify the GLACIER, DEEP\_ARCHIVE, or `REDUCED_REDUNDANCY`
  #   storage classes. For more information, about storage classes see
  #   [Storage Classes][10] in the *Amazon S3 User Guide*.
  #
  #
  #
  # **Special Errors**
  #
  # For a list of special errors for this operation, see [List of SELECT
  # Object Content Error Codes][11]
  #
  # **Related Resources**
  #
  # * [GetObject][5]
  #
  # * [GetBucketLifecycleConfiguration][12]
  #
  # * [PutBucketLifecycleConfiguration][13]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/selecting-content-from-objects.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-glacier-select-sql-reference-select.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTSelectObjectAppendix.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_SelectObjectContent.html#AmazonS3-SelectObjectContent-request-ScanRange
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#storage-class-intro
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#SelectObjectContentErrorCodeList
  # [12]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html
  # [13]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html
  #
  # @example EventStream Operation Example
  #
  #   You can process event once it arrives immediately, or wait until
  #   full response complete and iterate through eventstream enumerator.
  #
  #   To interact with event immediately, you need to register #select_object_content
  #   with callbacks, callbacks can be register for specifc events or for all events,
  #   callback for errors in the event stream is also available for register.
  #
  #   Callbacks can be passed in by `:event_stream_handler` option or within block
  #   statement attached to #select_object_content call directly. Hybrid pattern of both
  #   is also supported.
  #
  #   `:event_stream_handler` option takes in either Proc object or
  #   Aws::S3::EventStreams::SelectObjectContentEventStream object.
  #
  #   Usage pattern a): callbacks with a block attached to #select_object_content
  #   Example for registering callbacks for all event types and error event
  #
  #   client.select_object_content( # params input# ) do |stream|
  #   stream.on_error_event do |event|
  #   # catch unmodeled error event in the stream
  #   raise event
  #   # => Aws::Errors::EventError
  #   # event.event_type => :error
  #   # event.error_code => String
  #   # event.error_message => String
  #   end
  #
  #   stream.on_event do |event|
  #   # process all events arrive
  #   puts event.event_type
  #   ...
  #   end
  #
  #   end
  #
  #   Usage pattern b): pass in `:event_stream_handler` for #select_object_content
  #
  #   1) create a Aws::S3::EventStreams::SelectObjectContentEventStream object
  #   Example for registering callbacks with specific events
  #
  #   handler = Aws::S3::EventStreams::SelectObjectContentEventStream.new
  #   handler.on_records_event do |event|
  #   event # => Aws::S3::Types::Records
  #   end
  #   handler.on_stats_event do |event|
  #   event # => Aws::S3::Types::Stats
  #   end
  #   handler.on_progress_event do |event|
  #   event # => Aws::S3::Types::Progress
  #   end
  #   handler.on_cont_event do |event|
  #   event # => Aws::S3::Types::Cont
  #   end
  #   handler.on_end_event do |event|
  #   event # => Aws::S3::Types::End
  #   end
  #
  #   client.select_object_content( # params input #, event_stream_handler: handler)
  #
  #   2) use a Ruby Proc object
  #   Example for registering callbacks with specific events
  #
  #   handler = Proc.new do |stream|
  #   stream.on_records_event do |event|
  #   event # => Aws::S3::Types::Records
  #   end
  #   stream.on_stats_event do |event|
  #   event # => Aws::S3::Types::Stats
  #   end
  #   stream.on_progress_event do |event|
  #   event # => Aws::S3::Types::Progress
  #   end
  #   stream.on_cont_event do |event|
  #   event # => Aws::S3::Types::Cont
  #   end
  #   stream.on_end_event do |event|
  #   event # => Aws::S3::Types::End
  #   end
  #   end
  #
  #   client.select_object_content( # params input #, event_stream_handler: handler)
  #
  #   Usage pattern c): hybird pattern of a) and b)
  #
  #   handler = Aws::S3::EventStreams::SelectObjectContentEventStream.new
  #   handler.on_records_event do |event|
  #   event # => Aws::S3::Types::Records
  #   end
  #   handler.on_stats_event do |event|
  #   event # => Aws::S3::Types::Stats
  #   end
  #   handler.on_progress_event do |event|
  #   event # => Aws::S3::Types::Progress
  #   end
  #   handler.on_cont_event do |event|
  #   event # => Aws::S3::Types::Cont
  #   end
  #   handler.on_end_event do |event|
  #   event # => Aws::S3::Types::End
  #   end
  #
  #   client.select_object_content( # params input #, event_stream_handler: handler) do |stream|
  #   stream.on_error_event do |event|
  #   # catch unmodeled error event in the stream
  #   raise event
  #   # => Aws::Errors::EventError
  #   # event.event_type => :error
  #   # event.error_code => String
  #   # event.error_message => String
  #   end
  #   end
  #
  #   Besides above usage patterns for process events when they arrive immediately, you can also
  #   iterate through events after response complete.
  #
  #   Events are available at resp.payload # => Enumerator
  #   For parameter input example, please refer to following request syntax
  # @example Request syntax with placeholder values
  #
  #   resp = client.select_object_content({
  #   bucket: "BucketName", # required
  #   key: "ObjectKey", # required
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   expression: "Expression", # required
  #   expression_type: "SQL", # required, accepts SQL
  #   request_progress: {
  #   enabled: false,
  #   },
  #   input_serialization: { # required
  #   csv: {
  #   file_header_info: "USE", # accepts USE, IGNORE, NONE
  #   comments: "Comments",
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   allow_quoted_record_delimiter: false,
  #   },
  #   compression_type: "NONE", # accepts NONE, GZIP, BZIP2
  #   json: {
  #   type: "DOCUMENT", # accepts DOCUMENT, LINES
  #   },
  #   parquet: {
  #   },
  #   },
  #   output_serialization: { # required
  #   csv: {
  #   quote_fields: "ALWAYS", # accepts ALWAYS, ASNEEDED
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   },
  #   json: {
  #   record_delimiter: "RecordDelimiter",
  #   },
  #   },
  #   scan_range: {
  #   start: 1,
  #   end: 1,
  #   },
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   All events are available at resp.payload:
  #   resp.payload #=> Enumerator
  #   resp.payload.event_types #=> [:records, :stats, :progress, :cont, :end]
  #
  #   For :records event available at #on_records_event callback and response eventstream enumerator:
  #   event.payload #=> IO
  #
  #   For :stats event available at #on_stats_event callback and response eventstream enumerator:
  #   event.details.bytes_scanned #=> Integer
  #   event.details.bytes_processed #=> Integer
  #   event.details.bytes_returned #=> Integer
  #
  #   For :progress event available at #on_progress_event callback and response eventstream enumerator:
  #   event.details.bytes_scanned #=> Integer
  #   event.details.bytes_processed #=> Integer
  #   event.details.bytes_returned #=> Integer
  #
  #   For :cont event available at #on_cont_event callback and response eventstream enumerator:
  #   #=> EmptyStruct
  #   For :end event available at #on_end_event callback and response eventstream enumerator:
  #   #=> EmptyStruct
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload select_object_content
  # @param params [Hash] ({})
  # @return [Types::SelectObjectContentOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::SelectObjectContentOutput#payload #payload} => Types::SelectObjectContentEventStream
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectObjectContent AWS API Documentation
  # @yield [event_stream_handler]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#14211
  def select_object_content(params = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # Uploads a part in a multipart upload.
  #
  # <note markdown="1"> In this operation, you provide part data in your request. However, you
  # have an option to specify your existing Amazon S3 object as a data
  # source for the part you are uploading. To upload a part from an
  # existing object, you use the [UploadPartCopy][1] operation.
  #
  #  </note>
  #
  # You must initiate a multipart upload (see [CreateMultipartUpload][2])
  # before you can upload any part. In response to your initiate request,
  # Amazon S3 returns an upload ID, a unique identifier, that you must
  # include in your upload part request.
  #
  # Part numbers can be any number from 1 to 10,000, inclusive. A part
  # number uniquely identifies a part and also defines its position within
  # the object being created. If you upload a new part using the same part
  # number that was used with a previous part, the previously uploaded
  # part is overwritten.
  #
  # For information about maximum and minimum part sizes and other
  # multipart upload specifications, see [Multipart upload limits][3] in
  # the *Amazon S3 User Guide*.
  #
  # To ensure that data is not corrupted when traversing the network,
  # specify the `Content-MD5` header in the upload part request. Amazon S3
  # checks the part data against the provided MD5 value. If they do not
  # match, Amazon S3 returns an error.
  #
  # If the upload request is signed with Signature Version 4, then Amazon
  # Web Services S3 uses the `x-amz-content-sha256` header as a checksum
  # instead of `Content-MD5`. For more information see [Authenticating
  # Requests: Using the Authorization Header (Amazon Web Services
  # Signature Version 4)][4].
  #
  # **Note:** After you initiate multipart upload and upload one or more
  # parts, you must either complete or abort multipart upload in order to
  # stop getting charged for storage of the uploaded parts. Only after you
  # either complete or abort multipart upload, Amazon S3 frees up the
  # parts storage and stops charging you for the parts storage.
  #
  # For more information on multipart uploads, go to [Multipart Upload
  # Overview][5] in the <i>Amazon S3 User Guide </i>.
  #
  # For information on the permissions required to use the multipart
  # upload API, go to [Multipart Upload and Permissions][6] in the *Amazon
  # S3 User Guide*.
  #
  # You can optionally request server-side encryption where Amazon S3
  # encrypts your data as it writes it to disks in its data centers and
  # decrypts it for you when you access it. You have the option of
  # providing your own encryption key, or you can use the Amazon Web
  # Services managed encryption keys. If you choose to provide your own
  # encryption key, the request headers you provide in the request must
  # match the headers you used in the request to initiate the upload by
  # using [CreateMultipartUpload][2]. For more information, go to [Using
  # Server-Side Encryption][7] in the *Amazon S3 User Guide*.
  #
  # Server-side encryption is supported by the S3 Multipart Upload
  # actions. Unless you are using a customer-provided encryption key, you
  # don't need to specify the encryption parameters in each UploadPart
  # request. Instead, you only need to specify the server-side encryption
  # parameters in the initial Initiate Multipart request. For more
  # information, see [CreateMultipartUpload][2].
  #
  # If you requested server-side encryption using a customer-provided
  # encryption key in your initiate multipart upload request, you must
  # provide identical encryption information in each part upload using the
  # following headers.
  #
  # * x-amz-server-side-encryption-customer-algorithm
  #
  # * x-amz-server-side-encryption-customer-key
  #
  # * x-amz-server-side-encryption-customer-key-MD5
  #
  # **Special Errors**
  #
  # * * *Code: NoSuchUpload*
  #
  #   * *Cause: The specified multipart upload does not exist. The upload
  #     ID might be invalid, or the multipart upload might have been
  #     aborted or completed.*
  #
  #   * <i> HTTP Status Code: 404 Not Found </i>
  #
  #   * *SOAP Fault Code Prefix: Client*
  #
  # **Related Resources**
  #
  # * [CreateMultipartUpload][2]
  #
  # * [CompleteMultipartUpload][8]
  #
  # * [AbortMultipartUpload][9]
  #
  # * [ListParts][10]
  #
  # * [ListMultipartUploads][11]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/qfacts.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-auth-using-authorization-header.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # @example Example: To upload a part
  #
  #   # The following example uploads part 1 of a multipart upload. The example specifies a file name for the part data. The
  #   # Upload ID is same that is returned by the initiate multipart upload.
  #
  #   resp = client.upload_part({
  #   body: "fileToUpload",
  #   bucket: "examplebucket",
  #   key: "examplelargeobject",
  #   part_number: 1,
  #   upload_id: "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CEg--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   etag: "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.upload_part({
  #   body: source_file,
  #   bucket: "BucketName", # required
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   key: "ObjectKey", # required
  #   part_number: 1, # required
  #   upload_id: "MultipartUploadId", # required
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.etag #=> String
  #   resp.checksum_crc32 #=> String
  #   resp.checksum_crc32c #=> String
  #   resp.checksum_sha1 #=> String
  #   resp.checksum_sha256 #=> String
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload upload_part
  # @param params [Hash] ({})
  # @return [Types::UploadPartOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::UploadPartOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::UploadPartOutput#etag #etag} => String
  #   * {Types::UploadPartOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::UploadPartOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::UploadPartOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::UploadPartOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::UploadPartOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::UploadPartOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::UploadPartOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::UploadPartOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::UploadPartOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#14566
  def upload_part(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Uploads a part by copying data from an existing object as data source.
  # You specify the data source by adding the request header
  # `x-amz-copy-source` in your request and a byte range by adding the
  # request header `x-amz-copy-source-range` in your request.
  #
  # For information about maximum and minimum part sizes and other
  # multipart upload specifications, see [Multipart upload limits][1] in
  # the *Amazon S3 User Guide*.
  #
  # <note markdown="1"> Instead of using an existing object as part data, you might use the
  # [UploadPart][2] action and provide data in your request.
  #
  #  </note>
  #
  # You must initiate a multipart upload before you can upload any part.
  # In response to your initiate request. Amazon S3 returns a unique
  # identifier, the upload ID, that you must include in your upload part
  # request.
  #
  # For more information about using the `UploadPartCopy` operation, see
  # the following:
  #
  # * For conceptual information about multipart uploads, see [Uploading
  #   Objects Using Multipart Upload][3] in the *Amazon S3 User Guide*.
  #
  # * For information about permissions required to use the multipart
  #   upload API, see [Multipart Upload and Permissions][4] in the *Amazon
  #   S3 User Guide*.
  #
  # * For information about copying objects using a single atomic action
  #   vs. a multipart upload, see [Operations on Objects][5] in the
  #   *Amazon S3 User Guide*.
  #
  # * For information about using server-side encryption with
  #   customer-provided encryption keys with the `UploadPartCopy`
  #   operation, see [CopyObject][6] and [UploadPart][2].
  #
  # Note the following additional considerations about the request headers
  # `x-amz-copy-source-if-match`, `x-amz-copy-source-if-none-match`,
  # `x-amz-copy-source-if-unmodified-since`, and
  # `x-amz-copy-source-if-modified-since`\:
  #
  #
  #
  # * **Consideration 1** - If both of the `x-amz-copy-source-if-match`
  #   and `x-amz-copy-source-if-unmodified-since` headers are present in
  #   the request as follows:
  #
  #   `x-amz-copy-source-if-match` condition evaluates to `true`, and;
  #
  #   `x-amz-copy-source-if-unmodified-since` condition evaluates to
  #   `false`;
  #
  #   Amazon S3 returns `200 OK` and copies the data.
  #
  # * **Consideration 2** - If both of the
  #   `x-amz-copy-source-if-none-match` and
  #   `x-amz-copy-source-if-modified-since` headers are present in the
  #   request as follows:
  #
  #   `x-amz-copy-source-if-none-match` condition evaluates to `false`,
  #   and;
  #
  #   `x-amz-copy-source-if-modified-since` condition evaluates to `true`;
  #
  #   Amazon S3 returns `412 Precondition Failed` response code.
  #
  # **Versioning**
  #
  # If your bucket has versioning enabled, you could have multiple
  # versions of the same object. By default, `x-amz-copy-source`
  # identifies the current version of the object to copy. If the current
  # version is a delete marker and you don't specify a versionId in the
  # `x-amz-copy-source`, Amazon S3 returns a 404 error, because the object
  # does not exist. If you specify versionId in the `x-amz-copy-source`
  # and the versionId is a delete marker, Amazon S3 returns an HTTP 400
  # error, because you are not allowed to specify a delete marker as a
  # version for the `x-amz-copy-source`.
  #
  # You can optionally specify a specific version of the source object to
  # copy by adding the `versionId` subresource as shown in the following
  # example:
  #
  # `x-amz-copy-source: /bucket/object?versionId=version id`
  #
  # **Special Errors**
  #
  # * * *Code: NoSuchUpload*
  #
  #   * *Cause: The specified multipart upload does not exist. The upload
  #     ID might be invalid, or the multipart upload might have been
  #     aborted or completed.*
  #
  #   * *HTTP Status Code: 404 Not Found*
  #
  # * * *Code: InvalidRequest*
  #
  #   * *Cause: The specified copy source is not supported as a byte-range
  #     copy source.*
  #
  #   * *HTTP Status Code: 400 Bad Request*
  #
  # **Related Resources**
  #
  # * [CreateMultipartUpload][7]
  #
  # * [UploadPart][2]
  #
  # * [CompleteMultipartUpload][8]
  #
  # * [AbortMultipartUpload][9]
  #
  # * [ListParts][10]
  #
  # * [ListMultipartUploads][11]
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/qfacts.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html
  # [4]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectOperations.html
  # [6]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html
  # [8]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html
  # [9]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
  # [10]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
  # [11]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
  #
  # @example Example: To upload a part by copying data from an existing object as data source
  #
  #   # The following example uploads a part of a multipart upload by copying data from an existing object as data source.
  #
  #   resp = client.upload_part_copy({
  #   bucket: "examplebucket",
  #   copy_source: "/bucketname/sourceobjectkey",
  #   key: "examplelargeobject",
  #   part_number: 1,
  #   upload_id: "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP91We7Nrw--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   copy_part_result: {
  #   etag: "\"b0c6f0e7e054ab8fa2536a2677f8734d\"",
  #   last_modified: Time.parse("2016-12-29T21:24:43.000Z"),
  #   },
  #   }
  # @example Example: To upload a part by copying byte range from an existing object as data source
  #
  #   # The following example uploads a part of a multipart upload by copying a specified byte range from an existing object as
  #   # data source.
  #
  #   resp = client.upload_part_copy({
  #   bucket: "examplebucket",
  #   copy_source: "/bucketname/sourceobjectkey",
  #   copy_source_range: "bytes=1-100000",
  #   key: "examplelargeobject",
  #   part_number: 2,
  #   upload_id: "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP91We7Nrw--",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   copy_part_result: {
  #   etag: "\"65d16d19e65a7508a51f043180edcc36\"",
  #   last_modified: Time.parse("2016-12-29T21:44:28.000Z"),
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.upload_part_copy({
  #   bucket: "BucketName", # required
  #   copy_source: "CopySource", # required
  #   copy_source_if_match: "CopySourceIfMatch",
  #   copy_source_if_modified_since: Time.now,
  #   copy_source_if_none_match: "CopySourceIfNoneMatch",
  #   copy_source_if_unmodified_since: Time.now,
  #   copy_source_range: "CopySourceRange",
  #   key: "ObjectKey", # required
  #   part_number: 1, # required
  #   upload_id: "MultipartUploadId", # required
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   copy_source_sse_customer_algorithm: "CopySourceSSECustomerAlgorithm",
  #   copy_source_sse_customer_key: "CopySourceSSECustomerKey",
  #   copy_source_sse_customer_key_md5: "CopySourceSSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   expected_source_bucket_owner: "AccountId",
  #   })
  # @example Response structure
  #
  #   resp.copy_source_version_id #=> String
  #   resp.copy_part_result.etag #=> String
  #   resp.copy_part_result.last_modified #=> Time
  #   resp.copy_part_result.checksum_crc32 #=> String
  #   resp.copy_part_result.checksum_crc32c #=> String
  #   resp.copy_part_result.checksum_sha1 #=> String
  #   resp.copy_part_result.checksum_sha256 #=> String
  #   resp.server_side_encryption #=> String, one of "AES256", "aws:kms"
  #   resp.sse_customer_algorithm #=> String
  #   resp.sse_customer_key_md5 #=> String
  #   resp.ssekms_key_id #=> String
  #   resp.bucket_key_enabled #=> Boolean
  #   resp.request_charged #=> String, one of "requester"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload upload_part_copy
  # @param params [Hash] ({})
  # @return [Types::UploadPartCopyOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::UploadPartCopyOutput#copy_source_version_id #copy_source_version_id} => String
  #   * {Types::UploadPartCopyOutput#copy_part_result #copy_part_result} => Types::CopyPartResult
  #   * {Types::UploadPartCopyOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::UploadPartCopyOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::UploadPartCopyOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::UploadPartCopyOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::UploadPartCopyOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::UploadPartCopyOutput#request_charged #request_charged} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#14955
  def upload_part_copy(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Polls an API operation until a resource enters a desired state.
  #
  # ## Basic Usage
  #
  # A waiter will call an API operation until:
  #
  # * It is successful
  # * It enters a terminal state
  # * It makes the maximum number of attempts
  #
  # In between attempts, the waiter will sleep.
  #
  #     # polls in a loop, sleeping between attempts
  #     client.wait_until(waiter_name, params)
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. You can pass
  # configuration as the final arguments hash.
  #
  #     # poll for ~25 seconds
  #     client.wait_until(waiter_name, params, {
  #       max_attempts: 5,
  #       delay: 5,
  #     })
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     client.wait_until(waiter_name, params, {
  #
  #       # disable max attempts
  #       max_attempts: nil,
  #
  #       # poll for 1 hour, instead of a number of attempts
  #       before_wait: -> (attempts, response) do
  #         throw :failure if Time.now - started_at > 3600
  #       end
  #     })
  #
  # ## Handling Errors
  #
  # When a waiter is unsuccessful, it will raise an error.
  # All of the failure errors extend from
  # {Aws::Waiters::Errors::WaiterFailed}.
  #
  #     begin
  #       client.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # ## Valid Waiters
  #
  # The following table lists the valid waiter names, the operations they call,
  # and the default `:delay` and `:max_attempts` values.
  #
  # | waiter_name       | params               | :delay   | :max_attempts |
  # | ----------------- | -------------------- | -------- | ------------- |
  # | bucket_exists     | {Client#head_bucket} | 5        | 20            |
  # | bucket_not_exists | {Client#head_bucket} | 5        | 20            |
  # | object_exists     | {Client#head_object} | 5        | 20            |
  # | object_not_exists | {Client#head_object} | 5        | 20            |
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param waiter_name [Symbol]
  # @param params [Hash] ({})
  # @param options [Hash] ({})
  # @raise [Errors::FailureStateError] Raised when the waiter terminates
  #   because the waiter has entered a state that it will not transition
  #   out of, preventing success.
  # @raise [Errors::TooManyAttemptsError] Raised when the configured
  #   maximum number of attempts have been made, and the waiter is not
  #   yet successful.
  # @raise [Errors::UnexpectedError] Raised when an error is encounted
  #   while polling for a resource that is not expected.
  # @raise [Errors::NoSuchWaiterError] Raised when you request to wait
  #   for an unknown state.
  # @return [Boolean] Returns `true` if the waiter was successful.
  # @yield [w.waiter]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15452
  def wait_until(waiter_name, params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15460
  def waiter_names; end

  # Passes transformed objects to a `GetObject` operation when using
  # Object Lambda access points. For information about Object Lambda
  # access points, see [Transforming objects with Object Lambda access
  # points][1] in the *Amazon S3 User Guide*.
  #
  # This operation supports metadata that can be returned by
  # [GetObject][2], in addition to `RequestRoute`, `RequestToken`,
  # `StatusCode`, `ErrorCode`, and `ErrorMessage`. The `GetObject`
  # response metadata is supported so that the `WriteGetObjectResponse`
  # caller, typically an Lambda function, can provide the same metadata
  # when it internally invokes `GetObject`. When `WriteGetObjectResponse`
  # is called by a customer-owned Lambda function, the metadata returned
  # to the end user `GetObject` call might differ from what Amazon S3
  # would normally return.
  #
  # You can include any number of metadata headers. When including a
  # metadata header, it should be prefaced with `x-amz-meta`. For example,
  # `x-amz-meta-my-custom-header: MyCustomValue`. The primary use case for
  # this is to forward `GetObject` metadata.
  #
  # Amazon Web Services provides some prebuilt Lambda functions that you
  # can use with S3 Object Lambda to detect and redact personally
  # identifiable information (PII) and decompress S3 objects. These Lambda
  # functions are available in the Amazon Web Services Serverless
  # Application Repository, and can be selected through the Amazon Web
  # Services Management Console when you create your Object Lambda access
  # point.
  #
  # Example 1: PII Access Control - This Lambda function uses Amazon
  # Comprehend, a natural language processing (NLP) service using machine
  # learning to find insights and relationships in text. It automatically
  # detects personally identifiable information (PII) such as names,
  # addresses, dates, credit card numbers, and social security numbers
  # from documents in your Amazon S3 bucket.
  #
  # Example 2: PII Redaction - This Lambda function uses Amazon
  # Comprehend, a natural language processing (NLP) service using machine
  # learning to find insights and relationships in text. It automatically
  # redacts personally identifiable information (PII) such as names,
  # addresses, dates, credit card numbers, and social security numbers
  # from documents in your Amazon S3 bucket.
  #
  # Example 3: Decompression - The Lambda function
  # S3ObjectLambdaDecompression, is equipped to decompress objects stored
  # in S3 in one of six compressed file formats including bzip2, gzip,
  # snappy, zlib, zstandard and ZIP.
  #
  # For information on how to view and use these functions, see [Using
  # Amazon Web Services built Lambda functions][3] in the *Amazon S3 User
  # Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-examples.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.write_get_object_response({
  #   request_route: "RequestRoute", # required
  #   request_token: "RequestToken", # required
  #   body: source_file,
  #   status_code: 1,
  #   error_code: "ErrorCode",
  #   error_message: "ErrorMessage",
  #   accept_ranges: "AcceptRanges",
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_length: 1,
  #   content_range: "ContentRange",
  #   content_type: "ContentType",
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   delete_marker: false,
  #   etag: "ETag",
  #   expires: Time.now,
  #   expiration: "Expiration",
  #   last_modified: Time.now,
  #   missing_meta: 1,
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   object_lock_retain_until_date: Time.now,
  #   parts_count: 1,
  #   replication_status: "COMPLETE", # accepts COMPLETE, PENDING, FAILED, REPLICA
  #   request_charged: "requester", # accepts requester
  #   restore: "Restore",
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   tag_count: 1,
  #   version_id: "ObjectVersionId",
  #   bucket_key_enabled: false,
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload write_get_object_response
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WriteGetObjectResponse AWS API Documentation
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15339
  def write_get_object_response(params = T.unsafe(nil), options = T.unsafe(nil)); end

  private

  # @param waiter_name [Symbol]
  # @param options [Hash] ({})
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15468
  def waiter(waiter_name, options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15477
  def waiters; end

  class << self
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15492
    def errors_module; end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/client.rb#15489
    def identifier; end
  end
end

# @api private
module Aws::S3::ClientApi
  include ::Seahorse::Model
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#2661
Aws::S3::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#16
Aws::S3::ClientApi::AbortDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#17
Aws::S3::ClientApi::AbortIncompleteMultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#18
Aws::S3::ClientApi::AbortMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#19
Aws::S3::ClientApi::AbortMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#20
Aws::S3::ClientApi::AbortRuleId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#21
Aws::S3::ClientApi::AccelerateConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#22
Aws::S3::ClientApi::AcceptRanges = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#23
Aws::S3::ClientApi::AccessControlPolicy = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#24
Aws::S3::ClientApi::AccessControlTranslation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#25
Aws::S3::ClientApi::AccessPointArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#26
Aws::S3::ClientApi::AccountId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#27
Aws::S3::ClientApi::AllowQuotedRecordDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#28
Aws::S3::ClientApi::AllowedHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#29
Aws::S3::ClientApi::AllowedHeaders = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#30
Aws::S3::ClientApi::AllowedMethod = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#31
Aws::S3::ClientApi::AllowedMethods = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#32
Aws::S3::ClientApi::AllowedOrigin = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#33
Aws::S3::ClientApi::AllowedOrigins = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#34
Aws::S3::ClientApi::AnalyticsAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#35
Aws::S3::ClientApi::AnalyticsConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#36
Aws::S3::ClientApi::AnalyticsConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#37
Aws::S3::ClientApi::AnalyticsExportDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#38
Aws::S3::ClientApi::AnalyticsFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#39
Aws::S3::ClientApi::AnalyticsId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#40
Aws::S3::ClientApi::AnalyticsS3BucketDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#41
Aws::S3::ClientApi::AnalyticsS3ExportFileFormat = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#42
Aws::S3::ClientApi::ArchiveStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#43
Aws::S3::ClientApi::Body = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BlobShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#44
Aws::S3::ClientApi::Bucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#45
Aws::S3::ClientApi::BucketAccelerateStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#46
Aws::S3::ClientApi::BucketAlreadyExists = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#47
Aws::S3::ClientApi::BucketAlreadyOwnedByYou = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#48
Aws::S3::ClientApi::BucketCannedACL = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#49
Aws::S3::ClientApi::BucketKeyEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#50
Aws::S3::ClientApi::BucketLifecycleConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#51
Aws::S3::ClientApi::BucketLocationConstraint = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#52
Aws::S3::ClientApi::BucketLoggingStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#53
Aws::S3::ClientApi::BucketLogsPermission = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#54
Aws::S3::ClientApi::BucketName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#55
Aws::S3::ClientApi::BucketVersioningStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#56
Aws::S3::ClientApi::Buckets = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#57
Aws::S3::ClientApi::BypassGovernanceRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#58
Aws::S3::ClientApi::BytesProcessed = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#59
Aws::S3::ClientApi::BytesReturned = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#60
Aws::S3::ClientApi::BytesScanned = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#61
Aws::S3::ClientApi::CORSConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#62
Aws::S3::ClientApi::CORSRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#63
Aws::S3::ClientApi::CORSRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#64
Aws::S3::ClientApi::CSVInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#65
Aws::S3::ClientApi::CSVOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#66
Aws::S3::ClientApi::CacheControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#67
Aws::S3::ClientApi::Checksum = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#68
Aws::S3::ClientApi::ChecksumAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#69
Aws::S3::ClientApi::ChecksumAlgorithmList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#70
Aws::S3::ClientApi::ChecksumCRC32 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#71
Aws::S3::ClientApi::ChecksumCRC32C = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#72
Aws::S3::ClientApi::ChecksumMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#73
Aws::S3::ClientApi::ChecksumSHA1 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#74
Aws::S3::ClientApi::ChecksumSHA256 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#75
Aws::S3::ClientApi::CloudFunction = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#76
Aws::S3::ClientApi::CloudFunctionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#77
Aws::S3::ClientApi::CloudFunctionInvocationRole = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#78
Aws::S3::ClientApi::Code = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#79
Aws::S3::ClientApi::Comments = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#80
Aws::S3::ClientApi::CommonPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#81
Aws::S3::ClientApi::CommonPrefixList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#82
Aws::S3::ClientApi::CompleteMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#83
Aws::S3::ClientApi::CompleteMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#84
Aws::S3::ClientApi::CompletedMultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#85
Aws::S3::ClientApi::CompletedPart = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#86
Aws::S3::ClientApi::CompletedPartList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#87
Aws::S3::ClientApi::CompressionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#88
Aws::S3::ClientApi::Condition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#89
Aws::S3::ClientApi::ConfirmRemoveSelfBucketAccess = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#90
Aws::S3::ClientApi::ContentDisposition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#91
Aws::S3::ClientApi::ContentEncoding = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#92
Aws::S3::ClientApi::ContentLanguage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#93
Aws::S3::ClientApi::ContentLength = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#94
Aws::S3::ClientApi::ContentMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#95
Aws::S3::ClientApi::ContentRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#96
Aws::S3::ClientApi::ContentType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#97
Aws::S3::ClientApi::ContinuationEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#98
Aws::S3::ClientApi::CopyObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#99
Aws::S3::ClientApi::CopyObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#100
Aws::S3::ClientApi::CopyObjectResult = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#101
Aws::S3::ClientApi::CopyPartResult = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#102
Aws::S3::ClientApi::CopySource = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#103
Aws::S3::ClientApi::CopySourceIfMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#104
Aws::S3::ClientApi::CopySourceIfModifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#105
Aws::S3::ClientApi::CopySourceIfNoneMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#106
Aws::S3::ClientApi::CopySourceIfUnmodifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#107
Aws::S3::ClientApi::CopySourceRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#108
Aws::S3::ClientApi::CopySourceSSECustomerAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#109
Aws::S3::ClientApi::CopySourceSSECustomerKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#110
Aws::S3::ClientApi::CopySourceSSECustomerKeyMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#111
Aws::S3::ClientApi::CopySourceVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#112
Aws::S3::ClientApi::CreateBucketConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#113
Aws::S3::ClientApi::CreateBucketOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#114
Aws::S3::ClientApi::CreateBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#115
Aws::S3::ClientApi::CreateMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#116
Aws::S3::ClientApi::CreateMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#117
Aws::S3::ClientApi::CreationDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#118
Aws::S3::ClientApi::Date = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#119
Aws::S3::ClientApi::Days = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#120
Aws::S3::ClientApi::DaysAfterInitiation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#121
Aws::S3::ClientApi::DefaultRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#122
Aws::S3::ClientApi::Delete = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#123
Aws::S3::ClientApi::DeleteBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#124
Aws::S3::ClientApi::DeleteBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#125
Aws::S3::ClientApi::DeleteBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#126
Aws::S3::ClientApi::DeleteBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#127
Aws::S3::ClientApi::DeleteBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#128
Aws::S3::ClientApi::DeleteBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#129
Aws::S3::ClientApi::DeleteBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#130
Aws::S3::ClientApi::DeleteBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#131
Aws::S3::ClientApi::DeleteBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#132
Aws::S3::ClientApi::DeleteBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#133
Aws::S3::ClientApi::DeleteBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#134
Aws::S3::ClientApi::DeleteBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#135
Aws::S3::ClientApi::DeleteBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#136
Aws::S3::ClientApi::DeleteMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#137
Aws::S3::ClientApi::DeleteMarkerEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#138
Aws::S3::ClientApi::DeleteMarkerReplication = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#139
Aws::S3::ClientApi::DeleteMarkerReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#140
Aws::S3::ClientApi::DeleteMarkerVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#141
Aws::S3::ClientApi::DeleteMarkers = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#142
Aws::S3::ClientApi::DeleteObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#143
Aws::S3::ClientApi::DeleteObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#144
Aws::S3::ClientApi::DeleteObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#145
Aws::S3::ClientApi::DeleteObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#146
Aws::S3::ClientApi::DeleteObjectsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#147
Aws::S3::ClientApi::DeleteObjectsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#148
Aws::S3::ClientApi::DeletePublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#149
Aws::S3::ClientApi::DeletedObject = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#150
Aws::S3::ClientApi::DeletedObjects = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#151
Aws::S3::ClientApi::Delimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#152
Aws::S3::ClientApi::Description = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#153
Aws::S3::ClientApi::Destination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#154
Aws::S3::ClientApi::DisplayName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#155
Aws::S3::ClientApi::ETag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#156
Aws::S3::ClientApi::EmailAddress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#157
Aws::S3::ClientApi::EnableRequestProgress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#158
Aws::S3::ClientApi::EncodingType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#159
Aws::S3::ClientApi::Encryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#160
Aws::S3::ClientApi::EncryptionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#161
Aws::S3::ClientApi::End = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#162
Aws::S3::ClientApi::EndEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#163
Aws::S3::ClientApi::Error = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#164
Aws::S3::ClientApi::ErrorCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#165
Aws::S3::ClientApi::ErrorDocument = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#166
Aws::S3::ClientApi::ErrorMessage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#167
Aws::S3::ClientApi::Errors = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#168
Aws::S3::ClientApi::Event = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#169
Aws::S3::ClientApi::EventBridgeConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#170
Aws::S3::ClientApi::EventList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#171
Aws::S3::ClientApi::ExistingObjectReplication = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#172
Aws::S3::ClientApi::ExistingObjectReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#173
Aws::S3::ClientApi::Expiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#174
Aws::S3::ClientApi::ExpirationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#175
Aws::S3::ClientApi::ExpiredObjectDeleteMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#176
Aws::S3::ClientApi::Expires = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#177
Aws::S3::ClientApi::ExpiresString = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#178
Aws::S3::ClientApi::ExposeHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#179
Aws::S3::ClientApi::ExposeHeaders = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#180
Aws::S3::ClientApi::Expression = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#181
Aws::S3::ClientApi::ExpressionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#182
Aws::S3::ClientApi::FetchOwner = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#183
Aws::S3::ClientApi::FieldDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#184
Aws::S3::ClientApi::FileHeaderInfo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#185
Aws::S3::ClientApi::FilterRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#186
Aws::S3::ClientApi::FilterRuleList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#187
Aws::S3::ClientApi::FilterRuleName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#188
Aws::S3::ClientApi::FilterRuleValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#189
Aws::S3::ClientApi::GetBucketAccelerateConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#190
Aws::S3::ClientApi::GetBucketAccelerateConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#191
Aws::S3::ClientApi::GetBucketAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#192
Aws::S3::ClientApi::GetBucketAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#193
Aws::S3::ClientApi::GetBucketAnalyticsConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#194
Aws::S3::ClientApi::GetBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#195
Aws::S3::ClientApi::GetBucketCorsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#196
Aws::S3::ClientApi::GetBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#197
Aws::S3::ClientApi::GetBucketEncryptionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#198
Aws::S3::ClientApi::GetBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#199
Aws::S3::ClientApi::GetBucketIntelligentTieringConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#200
Aws::S3::ClientApi::GetBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#201
Aws::S3::ClientApi::GetBucketInventoryConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#202
Aws::S3::ClientApi::GetBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#203
Aws::S3::ClientApi::GetBucketLifecycleConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#204
Aws::S3::ClientApi::GetBucketLifecycleConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#205
Aws::S3::ClientApi::GetBucketLifecycleOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#206
Aws::S3::ClientApi::GetBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#207
Aws::S3::ClientApi::GetBucketLocationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#208
Aws::S3::ClientApi::GetBucketLocationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#209
Aws::S3::ClientApi::GetBucketLoggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#210
Aws::S3::ClientApi::GetBucketLoggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#211
Aws::S3::ClientApi::GetBucketMetricsConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#212
Aws::S3::ClientApi::GetBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#213
Aws::S3::ClientApi::GetBucketNotificationConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#214
Aws::S3::ClientApi::GetBucketOwnershipControlsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#215
Aws::S3::ClientApi::GetBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#216
Aws::S3::ClientApi::GetBucketPolicyOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#217
Aws::S3::ClientApi::GetBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#218
Aws::S3::ClientApi::GetBucketPolicyStatusOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#219
Aws::S3::ClientApi::GetBucketPolicyStatusRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#220
Aws::S3::ClientApi::GetBucketReplicationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#221
Aws::S3::ClientApi::GetBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#222
Aws::S3::ClientApi::GetBucketRequestPaymentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#223
Aws::S3::ClientApi::GetBucketRequestPaymentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#224
Aws::S3::ClientApi::GetBucketTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#225
Aws::S3::ClientApi::GetBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#226
Aws::S3::ClientApi::GetBucketVersioningOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#227
Aws::S3::ClientApi::GetBucketVersioningRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#228
Aws::S3::ClientApi::GetBucketWebsiteOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#229
Aws::S3::ClientApi::GetBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#230
Aws::S3::ClientApi::GetObjectAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#231
Aws::S3::ClientApi::GetObjectAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#232
Aws::S3::ClientApi::GetObjectAttributesOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#233
Aws::S3::ClientApi::GetObjectAttributesParts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#234
Aws::S3::ClientApi::GetObjectAttributesRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#235
Aws::S3::ClientApi::GetObjectLegalHoldOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#236
Aws::S3::ClientApi::GetObjectLegalHoldRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#237
Aws::S3::ClientApi::GetObjectLockConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#238
Aws::S3::ClientApi::GetObjectLockConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#239
Aws::S3::ClientApi::GetObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#240
Aws::S3::ClientApi::GetObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#241
Aws::S3::ClientApi::GetObjectResponseStatusCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#242
Aws::S3::ClientApi::GetObjectRetentionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#243
Aws::S3::ClientApi::GetObjectRetentionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#244
Aws::S3::ClientApi::GetObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#245
Aws::S3::ClientApi::GetObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#246
Aws::S3::ClientApi::GetObjectTorrentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#247
Aws::S3::ClientApi::GetObjectTorrentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#248
Aws::S3::ClientApi::GetPublicAccessBlockOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#249
Aws::S3::ClientApi::GetPublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#250
Aws::S3::ClientApi::GlacierJobParameters = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#251
Aws::S3::ClientApi::Grant = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#252
Aws::S3::ClientApi::GrantFullControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#253
Aws::S3::ClientApi::GrantRead = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#254
Aws::S3::ClientApi::GrantReadACP = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#255
Aws::S3::ClientApi::GrantWrite = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#256
Aws::S3::ClientApi::GrantWriteACP = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#257
Aws::S3::ClientApi::Grantee = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#258
Aws::S3::ClientApi::Grants = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#259
Aws::S3::ClientApi::HeadBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#260
Aws::S3::ClientApi::HeadObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#261
Aws::S3::ClientApi::HeadObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#262
Aws::S3::ClientApi::HostName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#263
Aws::S3::ClientApi::HttpErrorCodeReturnedEquals = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#264
Aws::S3::ClientApi::HttpRedirectCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#265
Aws::S3::ClientApi::ID = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#266
Aws::S3::ClientApi::IfMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#267
Aws::S3::ClientApi::IfModifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#268
Aws::S3::ClientApi::IfNoneMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#269
Aws::S3::ClientApi::IfUnmodifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#270
Aws::S3::ClientApi::IndexDocument = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#271
Aws::S3::ClientApi::Initiated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#272
Aws::S3::ClientApi::Initiator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#273
Aws::S3::ClientApi::InputSerialization = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#274
Aws::S3::ClientApi::IntelligentTieringAccessTier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#275
Aws::S3::ClientApi::IntelligentTieringAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#276
Aws::S3::ClientApi::IntelligentTieringConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#277
Aws::S3::ClientApi::IntelligentTieringConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#278
Aws::S3::ClientApi::IntelligentTieringDays = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#279
Aws::S3::ClientApi::IntelligentTieringFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#280
Aws::S3::ClientApi::IntelligentTieringId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#281
Aws::S3::ClientApi::IntelligentTieringStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#282
Aws::S3::ClientApi::InvalidObjectState = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#283
Aws::S3::ClientApi::InventoryConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#284
Aws::S3::ClientApi::InventoryConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#285
Aws::S3::ClientApi::InventoryDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#286
Aws::S3::ClientApi::InventoryEncryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#287
Aws::S3::ClientApi::InventoryFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#288
Aws::S3::ClientApi::InventoryFormat = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#289
Aws::S3::ClientApi::InventoryFrequency = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#290
Aws::S3::ClientApi::InventoryId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#291
Aws::S3::ClientApi::InventoryIncludedObjectVersions = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#292
Aws::S3::ClientApi::InventoryOptionalField = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#293
Aws::S3::ClientApi::InventoryOptionalFields = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#294
Aws::S3::ClientApi::InventoryS3BucketDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#295
Aws::S3::ClientApi::InventorySchedule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#296
Aws::S3::ClientApi::IsEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#297
Aws::S3::ClientApi::IsLatest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#298
Aws::S3::ClientApi::IsPublic = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#299
Aws::S3::ClientApi::IsTruncated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#300
Aws::S3::ClientApi::JSONInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#301
Aws::S3::ClientApi::JSONOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#302
Aws::S3::ClientApi::JSONType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#303
Aws::S3::ClientApi::KMSContext = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#304
Aws::S3::ClientApi::KeyCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#305
Aws::S3::ClientApi::KeyMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#306
Aws::S3::ClientApi::KeyPrefixEquals = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#307
Aws::S3::ClientApi::LambdaFunctionArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#308
Aws::S3::ClientApi::LambdaFunctionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#309
Aws::S3::ClientApi::LambdaFunctionConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#310
Aws::S3::ClientApi::LastModified = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#311
Aws::S3::ClientApi::LifecycleConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#312
Aws::S3::ClientApi::LifecycleExpiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#313
Aws::S3::ClientApi::LifecycleRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#314
Aws::S3::ClientApi::LifecycleRuleAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#315
Aws::S3::ClientApi::LifecycleRuleFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#316
Aws::S3::ClientApi::LifecycleRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#317
Aws::S3::ClientApi::ListBucketAnalyticsConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#318
Aws::S3::ClientApi::ListBucketAnalyticsConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#319
Aws::S3::ClientApi::ListBucketIntelligentTieringConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#320
Aws::S3::ClientApi::ListBucketIntelligentTieringConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#321
Aws::S3::ClientApi::ListBucketInventoryConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#322
Aws::S3::ClientApi::ListBucketInventoryConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#323
Aws::S3::ClientApi::ListBucketMetricsConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#324
Aws::S3::ClientApi::ListBucketMetricsConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#325
Aws::S3::ClientApi::ListBucketsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#326
Aws::S3::ClientApi::ListMultipartUploadsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#327
Aws::S3::ClientApi::ListMultipartUploadsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#328
Aws::S3::ClientApi::ListObjectVersionsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#329
Aws::S3::ClientApi::ListObjectVersionsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#330
Aws::S3::ClientApi::ListObjectsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#331
Aws::S3::ClientApi::ListObjectsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#332
Aws::S3::ClientApi::ListObjectsV2Output = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#333
Aws::S3::ClientApi::ListObjectsV2Request = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#334
Aws::S3::ClientApi::ListPartsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#335
Aws::S3::ClientApi::ListPartsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#336
Aws::S3::ClientApi::Location = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#337
Aws::S3::ClientApi::LocationPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#338
Aws::S3::ClientApi::LoggingEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#339
Aws::S3::ClientApi::MFA = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#340
Aws::S3::ClientApi::MFADelete = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#341
Aws::S3::ClientApi::MFADeleteStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#342
Aws::S3::ClientApi::Marker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#343
Aws::S3::ClientApi::MaxAgeSeconds = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#344
Aws::S3::ClientApi::MaxKeys = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#345
Aws::S3::ClientApi::MaxParts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#346
Aws::S3::ClientApi::MaxUploads = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#347
Aws::S3::ClientApi::Message = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#348
Aws::S3::ClientApi::Metadata = T.let(T.unsafe(nil), Seahorse::Model::Shapes::MapShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#349
Aws::S3::ClientApi::MetadataDirective = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#350
Aws::S3::ClientApi::MetadataEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#351
Aws::S3::ClientApi::MetadataKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#352
Aws::S3::ClientApi::MetadataValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#353
Aws::S3::ClientApi::Metrics = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#354
Aws::S3::ClientApi::MetricsAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#355
Aws::S3::ClientApi::MetricsConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#356
Aws::S3::ClientApi::MetricsConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#357
Aws::S3::ClientApi::MetricsFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#358
Aws::S3::ClientApi::MetricsId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#359
Aws::S3::ClientApi::MetricsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#360
Aws::S3::ClientApi::Minutes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#361
Aws::S3::ClientApi::MissingMeta = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#362
Aws::S3::ClientApi::MultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#363
Aws::S3::ClientApi::MultipartUploadId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#364
Aws::S3::ClientApi::MultipartUploadList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#365
Aws::S3::ClientApi::NextKeyMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#366
Aws::S3::ClientApi::NextMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#367
Aws::S3::ClientApi::NextPartNumberMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#368
Aws::S3::ClientApi::NextToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#369
Aws::S3::ClientApi::NextUploadIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#370
Aws::S3::ClientApi::NextVersionIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#371
Aws::S3::ClientApi::NoSuchBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#372
Aws::S3::ClientApi::NoSuchKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#373
Aws::S3::ClientApi::NoSuchUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#374
Aws::S3::ClientApi::NoncurrentVersionExpiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#375
Aws::S3::ClientApi::NoncurrentVersionTransition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#376
Aws::S3::ClientApi::NoncurrentVersionTransitionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#377
Aws::S3::ClientApi::NotificationConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#378
Aws::S3::ClientApi::NotificationConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#379
Aws::S3::ClientApi::NotificationConfigurationFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#380
Aws::S3::ClientApi::NotificationId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#381
Aws::S3::ClientApi::Object = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#382
Aws::S3::ClientApi::ObjectAlreadyInActiveTierError = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#383
Aws::S3::ClientApi::ObjectAttributes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#384
Aws::S3::ClientApi::ObjectAttributesList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#385
Aws::S3::ClientApi::ObjectCannedACL = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#386
Aws::S3::ClientApi::ObjectIdentifier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#387
Aws::S3::ClientApi::ObjectIdentifierList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#388
Aws::S3::ClientApi::ObjectKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#389
Aws::S3::ClientApi::ObjectList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#390
Aws::S3::ClientApi::ObjectLockConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#391
Aws::S3::ClientApi::ObjectLockEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#392
Aws::S3::ClientApi::ObjectLockEnabledForBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#393
Aws::S3::ClientApi::ObjectLockLegalHold = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#394
Aws::S3::ClientApi::ObjectLockLegalHoldStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#395
Aws::S3::ClientApi::ObjectLockMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#396
Aws::S3::ClientApi::ObjectLockRetainUntilDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#397
Aws::S3::ClientApi::ObjectLockRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#398
Aws::S3::ClientApi::ObjectLockRetentionMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#399
Aws::S3::ClientApi::ObjectLockRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#400
Aws::S3::ClientApi::ObjectLockToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#401
Aws::S3::ClientApi::ObjectNotInActiveTierError = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#402
Aws::S3::ClientApi::ObjectOwnership = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#403
Aws::S3::ClientApi::ObjectPart = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#404
Aws::S3::ClientApi::ObjectSize = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#405
Aws::S3::ClientApi::ObjectSizeGreaterThanBytes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#406
Aws::S3::ClientApi::ObjectSizeLessThanBytes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#407
Aws::S3::ClientApi::ObjectStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#408
Aws::S3::ClientApi::ObjectVersion = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#409
Aws::S3::ClientApi::ObjectVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#410
Aws::S3::ClientApi::ObjectVersionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#411
Aws::S3::ClientApi::ObjectVersionStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#412
Aws::S3::ClientApi::OutputLocation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#413
Aws::S3::ClientApi::OutputSerialization = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#414
Aws::S3::ClientApi::Owner = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#415
Aws::S3::ClientApi::OwnerOverride = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#416
Aws::S3::ClientApi::OwnershipControls = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#417
Aws::S3::ClientApi::OwnershipControlsRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#418
Aws::S3::ClientApi::OwnershipControlsRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#419
Aws::S3::ClientApi::ParquetInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#420
Aws::S3::ClientApi::Part = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#421
Aws::S3::ClientApi::PartNumber = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#422
Aws::S3::ClientApi::PartNumberMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#423
Aws::S3::ClientApi::Parts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#424
Aws::S3::ClientApi::PartsCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#425
Aws::S3::ClientApi::PartsList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#426
Aws::S3::ClientApi::Payer = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#427
Aws::S3::ClientApi::Permission = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#428
Aws::S3::ClientApi::Policy = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#429
Aws::S3::ClientApi::PolicyStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#430
Aws::S3::ClientApi::Prefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#431
Aws::S3::ClientApi::Priority = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#432
Aws::S3::ClientApi::Progress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#433
Aws::S3::ClientApi::ProgressEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#434
Aws::S3::ClientApi::Protocol = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#435
Aws::S3::ClientApi::PublicAccessBlockConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#436
Aws::S3::ClientApi::PutBucketAccelerateConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#437
Aws::S3::ClientApi::PutBucketAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#438
Aws::S3::ClientApi::PutBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#439
Aws::S3::ClientApi::PutBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#440
Aws::S3::ClientApi::PutBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#441
Aws::S3::ClientApi::PutBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#442
Aws::S3::ClientApi::PutBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#443
Aws::S3::ClientApi::PutBucketLifecycleConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#444
Aws::S3::ClientApi::PutBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#445
Aws::S3::ClientApi::PutBucketLoggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#446
Aws::S3::ClientApi::PutBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#447
Aws::S3::ClientApi::PutBucketNotificationConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#448
Aws::S3::ClientApi::PutBucketNotificationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#449
Aws::S3::ClientApi::PutBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#450
Aws::S3::ClientApi::PutBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#451
Aws::S3::ClientApi::PutBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#452
Aws::S3::ClientApi::PutBucketRequestPaymentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#453
Aws::S3::ClientApi::PutBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#454
Aws::S3::ClientApi::PutBucketVersioningRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#455
Aws::S3::ClientApi::PutBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#456
Aws::S3::ClientApi::PutObjectAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#457
Aws::S3::ClientApi::PutObjectAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#458
Aws::S3::ClientApi::PutObjectLegalHoldOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#459
Aws::S3::ClientApi::PutObjectLegalHoldRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#460
Aws::S3::ClientApi::PutObjectLockConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#461
Aws::S3::ClientApi::PutObjectLockConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#462
Aws::S3::ClientApi::PutObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#463
Aws::S3::ClientApi::PutObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#464
Aws::S3::ClientApi::PutObjectRetentionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#465
Aws::S3::ClientApi::PutObjectRetentionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#466
Aws::S3::ClientApi::PutObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#467
Aws::S3::ClientApi::PutObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#468
Aws::S3::ClientApi::PutPublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#469
Aws::S3::ClientApi::QueueArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#470
Aws::S3::ClientApi::QueueConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#471
Aws::S3::ClientApi::QueueConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#472
Aws::S3::ClientApi::QueueConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#473
Aws::S3::ClientApi::Quiet = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#474
Aws::S3::ClientApi::QuoteCharacter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#475
Aws::S3::ClientApi::QuoteEscapeCharacter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#476
Aws::S3::ClientApi::QuoteFields = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#477
Aws::S3::ClientApi::Range = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#478
Aws::S3::ClientApi::RecordDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#479
Aws::S3::ClientApi::RecordsEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#480
Aws::S3::ClientApi::Redirect = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#481
Aws::S3::ClientApi::RedirectAllRequestsTo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#482
Aws::S3::ClientApi::ReplaceKeyPrefixWith = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#483
Aws::S3::ClientApi::ReplaceKeyWith = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#484
Aws::S3::ClientApi::ReplicaKmsKeyID = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#485
Aws::S3::ClientApi::ReplicaModifications = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#486
Aws::S3::ClientApi::ReplicaModificationsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#487
Aws::S3::ClientApi::ReplicationConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#488
Aws::S3::ClientApi::ReplicationRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#489
Aws::S3::ClientApi::ReplicationRuleAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#490
Aws::S3::ClientApi::ReplicationRuleFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#491
Aws::S3::ClientApi::ReplicationRuleStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#492
Aws::S3::ClientApi::ReplicationRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#493
Aws::S3::ClientApi::ReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#494
Aws::S3::ClientApi::ReplicationTime = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#495
Aws::S3::ClientApi::ReplicationTimeStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#496
Aws::S3::ClientApi::ReplicationTimeValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#497
Aws::S3::ClientApi::RequestCharged = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#498
Aws::S3::ClientApi::RequestPayer = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#499
Aws::S3::ClientApi::RequestPaymentConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#500
Aws::S3::ClientApi::RequestProgress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#501
Aws::S3::ClientApi::RequestRoute = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#502
Aws::S3::ClientApi::RequestToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#503
Aws::S3::ClientApi::ResponseCacheControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#504
Aws::S3::ClientApi::ResponseContentDisposition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#505
Aws::S3::ClientApi::ResponseContentEncoding = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#506
Aws::S3::ClientApi::ResponseContentLanguage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#507
Aws::S3::ClientApi::ResponseContentType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#508
Aws::S3::ClientApi::ResponseExpires = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#509
Aws::S3::ClientApi::Restore = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#510
Aws::S3::ClientApi::RestoreObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#511
Aws::S3::ClientApi::RestoreObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#512
Aws::S3::ClientApi::RestoreOutputPath = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#513
Aws::S3::ClientApi::RestoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#514
Aws::S3::ClientApi::RestoreRequestType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#515
Aws::S3::ClientApi::Role = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#516
Aws::S3::ClientApi::RoutingRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#517
Aws::S3::ClientApi::RoutingRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#518
Aws::S3::ClientApi::Rule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#519
Aws::S3::ClientApi::Rules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#520
Aws::S3::ClientApi::S3KeyFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#521
Aws::S3::ClientApi::S3Location = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#522
Aws::S3::ClientApi::SSECustomerAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#523
Aws::S3::ClientApi::SSECustomerKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#524
Aws::S3::ClientApi::SSECustomerKeyMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#525
Aws::S3::ClientApi::SSEKMS = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#526
Aws::S3::ClientApi::SSEKMSEncryptionContext = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#527
Aws::S3::ClientApi::SSEKMSKeyId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#528
Aws::S3::ClientApi::SSES3 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#529
Aws::S3::ClientApi::ScanRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#530
Aws::S3::ClientApi::SelectObjectContentEventStream = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#531
Aws::S3::ClientApi::SelectObjectContentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#532
Aws::S3::ClientApi::SelectObjectContentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#533
Aws::S3::ClientApi::SelectParameters = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#534
Aws::S3::ClientApi::ServerSideEncryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#535
Aws::S3::ClientApi::ServerSideEncryptionByDefault = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#536
Aws::S3::ClientApi::ServerSideEncryptionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#537
Aws::S3::ClientApi::ServerSideEncryptionRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#538
Aws::S3::ClientApi::ServerSideEncryptionRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#539
Aws::S3::ClientApi::Setting = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#540
Aws::S3::ClientApi::Size = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#541
Aws::S3::ClientApi::SkipValidation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#542
Aws::S3::ClientApi::SourceSelectionCriteria = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#543
Aws::S3::ClientApi::SseKmsEncryptedObjects = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#544
Aws::S3::ClientApi::SseKmsEncryptedObjectsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#545
Aws::S3::ClientApi::Start = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#546
Aws::S3::ClientApi::StartAfter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#547
Aws::S3::ClientApi::Stats = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#548
Aws::S3::ClientApi::StatsEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#549
Aws::S3::ClientApi::StorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#550
Aws::S3::ClientApi::StorageClassAnalysis = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#551
Aws::S3::ClientApi::StorageClassAnalysisDataExport = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#552
Aws::S3::ClientApi::StorageClassAnalysisSchemaVersion = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#553
Aws::S3::ClientApi::Suffix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#554
Aws::S3::ClientApi::Tag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#555
Aws::S3::ClientApi::TagCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#556
Aws::S3::ClientApi::TagSet = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#557
Aws::S3::ClientApi::Tagging = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#558
Aws::S3::ClientApi::TaggingDirective = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#559
Aws::S3::ClientApi::TaggingHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#560
Aws::S3::ClientApi::TargetBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#561
Aws::S3::ClientApi::TargetGrant = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#562
Aws::S3::ClientApi::TargetGrants = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#563
Aws::S3::ClientApi::TargetPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#564
Aws::S3::ClientApi::Tier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#565
Aws::S3::ClientApi::Tiering = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#566
Aws::S3::ClientApi::TieringList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#567
Aws::S3::ClientApi::Token = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#568
Aws::S3::ClientApi::TopicArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#569
Aws::S3::ClientApi::TopicConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#570
Aws::S3::ClientApi::TopicConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#571
Aws::S3::ClientApi::TopicConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#572
Aws::S3::ClientApi::Transition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#573
Aws::S3::ClientApi::TransitionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#574
Aws::S3::ClientApi::TransitionStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#575
Aws::S3::ClientApi::Type = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#576
Aws::S3::ClientApi::URI = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#577
Aws::S3::ClientApi::UploadIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#578
Aws::S3::ClientApi::UploadPartCopyOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#579
Aws::S3::ClientApi::UploadPartCopyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#580
Aws::S3::ClientApi::UploadPartOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#581
Aws::S3::ClientApi::UploadPartRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#582
Aws::S3::ClientApi::UserMetadata = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#583
Aws::S3::ClientApi::Value = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#584
Aws::S3::ClientApi::VersionCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#585
Aws::S3::ClientApi::VersionIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#586
Aws::S3::ClientApi::VersioningConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#587
Aws::S3::ClientApi::WebsiteConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#588
Aws::S3::ClientApi::WebsiteRedirectLocation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#589
Aws::S3::ClientApi::WriteGetObjectResponseRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/client_api.rb#590
Aws::S3::ClientApi::Years = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3//lib/aws-sdk-s3/encryption.rb#21
Aws::S3::EC_USER_AGENT = T.let(T.unsafe(nil), String)

# [MAINTENANCE MODE] There is a new version of the Encryption Client.
# AWS strongly recommends upgrading to the {Aws::S3::EncryptionV2::Client},
# which provides updated data security best practices.
# See documentation for {Aws::S3::EncryptionV2::Client}.
# Provides an encryption client that encrypts and decrypts data client-side,
# storing the encrypted data in Amazon S3.
#
# This client uses a process called "envelope encryption". Your private
# encryption keys and your data's plain-text are **never** sent to
# Amazon S3. **If you lose you encryption keys, you will not be able to
# decrypt your data.**
#
# ## Envelope Encryption Overview
#
# The goal of envelope encryption is to combine the performance of
# fast symmetric encryption while maintaining the secure key management
# that asymmetric keys provide.
#
# A one-time-use symmetric key (envelope key) is generated client-side.
# This is used to encrypt the data client-side. This key is then
# encrypted by your master key and stored alongside your data in Amazon
# S3.
#
# When accessing your encrypted data with the encryption client,
# the encrypted envelope key is retrieved and decrypted client-side
# with your master key. The envelope key is then used to decrypt the
# data client-side.
#
# One of the benefits of envelope encryption is that if your master key
# is compromised, you have the option of just re-encrypting the stored
# envelope symmetric keys, instead of re-encrypting all of the
# data in your account.
#
# ## Basic Usage
#
# The encryption client requires an {Aws::S3::Client}. If you do not
# provide a `:client`, then a client will be constructed for you.
#
#     require 'openssl'
#     key = OpenSSL::PKey::RSA.new(1024)
#
#     # encryption client
#     s3 = Aws::S3::Encryption::Client.new(encryption_key: key)
#
#     # round-trip an object, encrypted/decrypted locally
#     s3.put_object(bucket:'aws-sdk', key:'secret', body:'handshake')
#     s3.get_object(bucket:'aws-sdk', key:'secret').body.read
#     #=> 'handshake'
#
#     # reading encrypted object without the encryption client
#     # results in the getting the cipher text
#     Aws::S3::Client.new.get_object(bucket:'aws-sdk', key:'secret').body.read
#     #=> "... cipher text ..."
#
# ## Keys
#
# For client-side encryption to work, you must provide one of the following:
#
# * An encryption key
# * A {KeyProvider}
# * A KMS encryption key id
#
# ### An Encryption Key
#
# You can pass a single encryption key. This is used as a master key
# encrypting and decrypting all object keys.
#
#     key = OpenSSL::Cipher.new("AES-256-ECB").random_key # symmetric key
#     key = OpenSSL::PKey::RSA.new(1024) # asymmetric key pair
#
#     s3 = Aws::S3::Encryption::Client.new(encryption_key: key)
#
# ### Key Provider
#
# Alternatively, you can use a {KeyProvider}. A key provider makes
# it easy to work with multiple keys and simplifies key rotation.
#
# ### KMS Encryption Key Id
#
# If you pass the id to an AWS Key Management Service (KMS) key,
# then KMS will be used to generate, encrypt and decrypt object keys.
#
#     # keep track of the kms key id
#     kms = Aws::KMS::Client.new
#     key_id = kms.create_key.key_metadata.key_id
#
#     Aws::S3::Encryption::Client.new(
#       kms_key_id: key_id,
#       kms_client: kms,
#     )
#
# ## Custom Key Providers
#
# A {KeyProvider} is any object that responds to:
#
# * `#encryption_materials`
# * `#key_for(materials_description)`
#
# Here is a trivial implementation of an in-memory key provider.
# This is provided as a demonstration of the key provider interface,
# and should not be used in production:
#
#     class KeyProvider
#
#       def initialize(default_key_name, keys)
#         @keys = keys
#         @encryption_materials = Aws::S3::Encryption::Materials.new(
#           key: @keys[default_key_name],
#           description: JSON.dump(key: default_key_name),
#         )
#       end
#
#       attr_reader :encryption_materials
#
#       def key_for(matdesc)
#         key_name = JSON.parse(matdesc)['key']
#         if key = @keys[key_name]
#           key
#         else
#           raise "encryption key not found for: #{matdesc.inspect}"
#         end
#       end
#     end
#
# Given the above key provider, you can create an encryption client that
# chooses the key to use based on the materials description stored with
# the encrypted object. This makes it possible to use multiple keys
# and simplifies key rotation.
#
#     # uses "new-key" for encrypting objects, uses either for decrypting
#     keys = KeyProvider.new('new-key', {
#       "old-key" => Base64.decode64("kM5UVbhE/4rtMZJfsadYEdm2vaKFsmV2f5+URSeUCV4="),
#       "new-key" => Base64.decode64("w1WLio3agRWRTSJK/Ouh8NHoqRQ6fn5WbSXDTHjXMSo="),
#     }),
#
#     # chooses the key based on the materials description stored
#     # with the encrypted object
#     s3 = Aws::S3::Encryption::Client.new(key_provider: keys)
#
# ## Materials Description
#
# A materials description is JSON document string that is stored
# in the metadata (or instruction file) of an encrypted object.
# The {DefaultKeyProvider} uses the empty JSON document `"{}"`.
#
# When building a key provider, you are free to store whatever
# information you need to identify the master key that was used
# to encrypt the object.
#
# ## Envelope Location
#
# By default, the encryption client store the encryption envelope
# with the object, as metadata. You can choose to have the envelope
# stored in a separate "instruction file". An instruction file
# is an object, with the key of the encrypted object, suffixed with
# `".instruction"`.
#
# Specify the `:envelope_location` option as `:instruction_file` to
# use an instruction file for storing the envelope.
#
#     # default behavior
#     s3 = Aws::S3::Encryption::Client.new(
#       key_provider: ...,
#       envelope_location: :metadata,
#     )
#
#     # store envelope in a separate object
#     s3 = Aws::S3::Encryption::Client.new(
#       key_provider: ...,
#       envelope_location: :instruction_file,
#       instruction_file_suffix: '.instruction' # default
#     )
#
# When using an instruction file, multiple requests are made when
# putting and getting the object. **This may cause issues if you are
# issuing concurrent PUT and GET requests to an encrypted object.**
module Aws::S3::Encryption; end

class Aws::S3::Encryption::Client
  extend ::Aws::Deprecations
  extend ::Forwardable

  # Creates a new encryption client. You must provide one of the following
  # options:
  #
  # * `:encryption_key`
  # * `:kms_key_id`
  # * `:key_provider`
  #
  # You may also pass any other options accepted by `Client#initialize`.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def initialize(*args, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def build_request(*args, **_arg1, &block); end

  # @return [S3::Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#245
  def client; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def config(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def delete_object(*args, **_arg1, &block); end

  # @return [Symbol<:metadata, :instruction_file>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#252
  def envelope_location; end

  # Gets an object from Amazon S3, decrypting  data locally.
  # See {S3::Client#get_object} for documentation on accepted
  # request parameters.
  #
  # @note The `:range` request parameter is not yet supported.
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param params [Hash] a customizable set of options
  # @return [Types::GetObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectOutput#body #body} => IO
  #   * {Types::GetObjectOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::GetObjectOutput#accept_ranges #accept_ranges} => String
  #   * {Types::GetObjectOutput#expiration #expiration} => String
  #   * {Types::GetObjectOutput#restore #restore} => String
  #   * {Types::GetObjectOutput#last_modified #last_modified} => Time
  #   * {Types::GetObjectOutput#content_length #content_length} => Integer
  #   * {Types::GetObjectOutput#etag #etag} => String
  #   * {Types::GetObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::GetObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::GetObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::GetObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::GetObjectOutput#missing_meta #missing_meta} => Integer
  #   * {Types::GetObjectOutput#version_id #version_id} => String
  #   * {Types::GetObjectOutput#cache_control #cache_control} => String
  #   * {Types::GetObjectOutput#content_disposition #content_disposition} => String
  #   * {Types::GetObjectOutput#content_encoding #content_encoding} => String
  #   * {Types::GetObjectOutput#content_language #content_language} => String
  #   * {Types::GetObjectOutput#content_range #content_range} => String
  #   * {Types::GetObjectOutput#content_type #content_type} => String
  #   * {Types::GetObjectOutput#expires #expires} => Time
  #   * {Types::GetObjectOutput#expires_string #expires_string} => String
  #   * {Types::GetObjectOutput#website_redirect_location #website_redirect_location} => String
  #   * {Types::GetObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::GetObjectOutput#metadata #metadata} => Hash&lt;String,String&gt;
  #   * {Types::GetObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::GetObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::GetObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::GetObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::GetObjectOutput#storage_class #storage_class} => String
  #   * {Types::GetObjectOutput#request_charged #request_charged} => String
  #   * {Types::GetObjectOutput#replication_status #replication_status} => String
  #   * {Types::GetObjectOutput#parts_count #parts_count} => Integer
  #   * {Types::GetObjectOutput#tag_count #tag_count} => Integer
  #   * {Types::GetObjectOutput#object_lock_mode #object_lock_mode} => String
  #   * {Types::GetObjectOutput#object_lock_retain_until_date #object_lock_retain_until_date} => Time
  #   * {Types::GetObjectOutput#object_lock_legal_hold_status #object_lock_legal_hold_status} => String
  # @see S3::Client#get_object
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#289
  def get_object(params = T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def head_object(*args, **_arg1, &block); end

  # @return [String] When {#envelope_location} is `:instruction_file`,
  #   the envelope is stored in the object with the object key suffixed
  #   by this string.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#257
  def instruction_file_suffix; end

  # @return [KeyProvider, nil] Returns `nil` if you are using
  #   AWS Key Management Service (KMS).
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#249
  def key_provider; end

  # Uploads an object to Amazon S3, encrypting data client-side.
  # See {S3::Client#put_object} for documentation on accepted
  # request parameters.
  #
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param params [Hash] a customizable set of options
  # @return [Types::PutObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectOutput#expiration #expiration} => String
  #   * {Types::PutObjectOutput#etag #etag} => String
  #   * {Types::PutObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::PutObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::PutObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::PutObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::PutObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::PutObjectOutput#version_id #version_id} => String
  #   * {Types::PutObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::PutObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::PutObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::PutObjectOutput#ssekms_encryption_context #ssekms_encryption_context} => String
  #   * {Types::PutObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::PutObjectOutput#request_charged #request_charged} => String
  # @see S3::Client#put_object
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#265
  def put_object(params = T.unsafe(nil)); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#328
  def cipher_provider(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#230
  def deprecated_initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#352
  def envelope_options(params); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#306
  def extract_client(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#341
  def extract_key_provider(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#362
  def extract_location(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#373
  def extract_suffix(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/client.rb#319
  def kms_client(options); end
end

# @api private
class Aws::S3::Encryption::DecryptHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#46
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#210
  def apply_cse_user_agent(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#64
  def attach_http_event_listeners(context); end

  # Determine the auth tag length from the algorithm
  # Validate it against the value provided in the x-amz-tag-len
  # Return the tag length in bytes
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#196
  def auth_tag_length(envelope); end

  # This method fetches the tag from the end of the object by
  # making a GET Object w/range request. This auth tag is used
  # to initialize the cipher, and the decrypter truncates the
  # auth tag from the body when writing the final bytes.
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#167
  def authenticated_decrypter(context, cipher, envelope); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#189
  def body_contains_auth_tag?(envelope); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#88
  def decryption_cipher(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#119
  def envelope_from_instr_file(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#109
  def envelope_from_metadata(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#130
  def extract_envelope(hash); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#101
  def get_encryption_envelope(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#140
  def v1_envelope(envelope); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#144
  def v2_envelope(envelope); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#44
Aws::S3::Encryption::DecryptHandler::AUTH_REQUIRED_CEK_ALGS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#38
Aws::S3::Encryption::DecryptHandler::POSSIBLE_ENCRYPTION_FORMATS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#28
Aws::S3::Encryption::DecryptHandler::POSSIBLE_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#31
Aws::S3::Encryption::DecryptHandler::POSSIBLE_WRAPPING_FORMATS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#12
Aws::S3::Encryption::DecryptHandler::V1_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#18
Aws::S3::Encryption::DecryptHandler::V2_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/decrypt_handler.rb#26
Aws::S3::Encryption::DecryptHandler::V2_OPTIONAL_KEYS = T.let(T.unsafe(nil), Array)

# @api private
class Aws::S3::Encryption::DefaultCipherProvider
  # @api private
  # @return [DefaultCipherProvider] a new instance of DefaultCipherProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#11
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Cipher] Given an encryption envelope, returns a
  #   decryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#29
  def decryption_cipher(envelope, options = T.unsafe(nil)); end

  # @api private
  # @return [Array<Hash,Cipher>] Creates an returns a new encryption
  #   envelope and encryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#17
  def encryption_cipher; end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#95
  def decode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#91
  def encode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#83
  def encrypt(data); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#79
  def envelope_iv(cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#75
  def envelope_key(cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_cipher_provider.rb#87
  def materials_description; end
end

# The default key provider is constructed with a single key
# that is used for both encryption and decryption, ignoring
# the possible per-object envelope encryption materials description.
#
# @api private
class Aws::S3::Encryption::DefaultKeyProvider
  include ::Aws::S3::Encryption::KeyProvider

  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [DefaultKeyProvider] a new instance of DefaultKeyProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_key_provider.rb#19
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Materials]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_key_provider.rb#27
  def encryption_materials; end

  # @api private
  # @param materials_description [String<JSON>]
  # @return Returns the key given in the constructor.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/default_key_provider.rb#33
  def key_for(materials_description); end
end

# @api private
class Aws::S3::Encryption::EncryptHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/encrypt_handler.rb#11
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/encrypt_handler.rb#50
  def apply_cse_user_agent(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/encrypt_handler.rb#36
  def apply_encryption_cipher(context, cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/encrypt_handler.rb#21
  def apply_encryption_envelope(context, envelope, cipher); end
end

module Aws::S3::Encryption::Errors; end
class Aws::S3::Encryption::Errors::DecryptionError < ::RuntimeError; end
class Aws::S3::Encryption::Errors::EncryptionError < ::RuntimeError; end

# @api private
class Aws::S3::Encryption::IOAuthDecrypter
  # @api private
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [IOAuthDecrypter] a new instance of IOAuthDecrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_auth_decrypter.rb#19
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_auth_decrypter.rb#33
  def finalize; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_auth_decrypter.rb#37
  def io; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_auth_decrypter.rb#25
  def write(chunk); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_auth_decrypter.rb#43
  def truncate_chunk(chunk); end
end

# @api private
class Aws::S3::Encryption::IODecrypter
  # @api private
  # @param cipher [OpenSSL::Cipher]
  # @param io [IO#write] An IO-like object that responds to `#write`.
  # @return [IODecrypter] a new instance of IODecrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_decrypter.rb#11
  def initialize(cipher, io); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_decrypter.rb#30
  def finalize; end

  # @api private
  # @return [#write]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_decrypter.rb#19
  def io; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_decrypter.rb#21
  def write(chunk); end
end

# Provides an IO wrapper encrpyting a stream of data.
# It is possible to use this same object for decrypting. You must
# initialize it with a decryptiion cipher in that case and the
# IO object must contain cipher text instead of plain text.
#
# @api private
class Aws::S3::Encryption::IOEncrypter
  # @api private
  # @return [IOEncrypter] a new instance of IOEncrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#20
  def initialize(cipher, io); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#43
  def close; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#30
  def read(bytes = T.unsafe(nil), output_buffer = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#38
  def rewind; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#28
  def size; end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#49
  def encrypt_to_stringio(cipher, plain_text); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#57
  def encrypt_to_tempfile(cipher, io); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/io_encrypter.rb#18
Aws::S3::Encryption::IOEncrypter::ONE_MEGABYTE = T.let(T.unsafe(nil), Integer)

# This module defines the interface required for a {Client#key_provider}.
# A key provider is any object that:
#
# * Responds to {#encryption_materials} with an {Materials} object.
#
# * Responds to {#key_for}, receiving a JSON document String,
#   returning an encryption key. The returned encryption key
#   must be one of:
#
#   * `OpenSSL::PKey::RSA` - for asymmetric encryption
#   * `String` - 32, 24, or 16 bytes long, for symmetric encryption
module Aws::S3::Encryption::KeyProvider
  # @return [Materials]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/key_provider.rb#22
  def encryption_materials; end

  # @param materials_description [String<JSON>]
  # @return [OpenSSL::PKey::RSA, String] encryption_key
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/key_provider.rb#26
  def key_for(materials_description); end
end

# @api private
class Aws::S3::Encryption::KmsCipherProvider
  # @api private
  # @return [KmsCipherProvider] a new instance of KmsCipherProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#11
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Cipher] Given an encryption envelope, returns a
  #   decryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#39
  def decryption_cipher(envelope, options = T.unsafe(nil)); end

  # @api private
  # @return [Array<Hash,Cipher>] Creates an returns a new encryption
  #   envelope and encryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#18
  def encryption_cipher; end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#85
  def build_encryption_context(cek_alg, options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#97
  def decode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/kms_cipher_provider.rb#93
  def encode64(str); end
end

class Aws::S3::Encryption::Materials
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Materials] a new instance of Materials
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/materials.rb#17
  def initialize(options = T.unsafe(nil)); end

  # @return [String<JSON>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/materials.rb#26
  def description; end

  # @return [OpenSSL::PKey::RSA, String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/materials.rb#23
  def key; end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/materials.rb#49
  def validate_desc(description); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/materials.rb#30
  def validate_key(key); end
end

# @api private
module Aws::S3::Encryption::Utils
  class << self
    # @api private
    # @param mode [String] "encrypt" or "decrypt"
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#83
    def aes_cipher(mode, block_mode, key, iv); end

    # @api private
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#75
    def aes_decryption_cipher(block_mode, key = T.unsafe(nil), iv = T.unsafe(nil)); end

    # @api private
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#68
    def aes_encryption_cipher(block_mode, key = T.unsafe(nil), iv = T.unsafe(nil)); end

    # @api private
    # @param key [String]
    # @raise ArgumentError
    # @return [Integer]
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#96
    def cipher_size(key); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#27
    def decrypt(key, data); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#43
    def decrypt_aes_gcm(key, data, auth_data); end

    # returns the decrypted data + auth_data
    #
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#56
    def decrypt_rsa(key, enc_data); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#15
    def encrypt(key, data); end
  end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryption/utils.rb#11
Aws::S3::Encryption::Utils::UNSAFE_MSG = T.let(T.unsafe(nil), String)

# Provides an encryption client that encrypts and decrypts data client-side,
# storing the encrypted data in Amazon S3.  The `EncryptionV2::Client` (V2 Client)
# provides improved security over the `Encryption::Client` (V1 Client)
# by using more modern and secure algorithms. You can use the V2 Client
# to continue decrypting objects encrypted using deprecated algorithms
# by setting security_profile: :v2_and_legacy. The latest V1 Client also
# supports reading and decrypting objects encrypted by the V2 Client.
#
# This client uses a process called "envelope encryption". Your private
# encryption keys and your data's plain-text are **never** sent to
# Amazon S3. **If you lose you encryption keys, you will not be able to
# decrypt your data.**
#
# ## Envelope Encryption Overview
#
# The goal of envelope encryption is to combine the performance of
# fast symmetric encryption while maintaining the secure key management
# that asymmetric keys provide.
#
# A one-time-use symmetric key (envelope key) is generated client-side.
# This is used to encrypt the data client-side. This key is then
# encrypted by your master key and stored alongside your data in Amazon
# S3.
#
# When accessing your encrypted data with the encryption client,
# the encrypted envelope key is retrieved and decrypted client-side
# with your master key. The envelope key is then used to decrypt the
# data client-side.
#
# One of the benefits of envelope encryption is that if your master key
# is compromised, you have the option of just re-encrypting the stored
# envelope symmetric keys, instead of re-encrypting all of the
# data in your account.
#
# ## Basic Usage
#
# The encryption client requires an {Aws::S3::Client}. If you do not
# provide a `:client`, then a client will be constructed for you.
#
#     require 'openssl'
#     key = OpenSSL::PKey::RSA.new(1024)
#
#     # encryption client
#     s3 = Aws::S3::EncryptionV2::Client.new(
#       encryption_key: key,
#       key_wrap_schema: :rsa_oaep_sha1, # the key_wrap_schema must be rsa_oaep_sha1 for asymmetric keys
#       content_encryption_schema: :aes_gcm_no_padding,
#       security_profile: :v2 # use :v2_and_legacy to allow reading/decrypting objects encrypted by the V1 encryption client
#     )
#
#     # round-trip an object, encrypted/decrypted locally
#     s3.put_object(bucket:'aws-sdk', key:'secret', body:'handshake')
#     s3.get_object(bucket:'aws-sdk', key:'secret').body.read
#     #=> 'handshake'
#
#     # reading encrypted object without the encryption client
#     # results in the getting the cipher text
#     Aws::S3::Client.new.get_object(bucket:'aws-sdk', key:'secret').body.read
#     #=> "... cipher text ..."
#
# ## Required Configuration
#
# You must configure all of the following:
#
# * a key or key provider - See the Keys section below. The key provided determines
#   the key wrapping schema(s) supported for both encryption and decryption.
# * `key_wrap_schema` - The key wrapping schema. It must match the type of key configured.
# * `content_encryption_schema` - The only supported value currently is `:aes_gcm_no_padding`.
#    More options will be added in future releases.
# * `security_profile` - Determines the support for reading objects written
#    using older key wrap or content encryption schemas. If you need to read
#    legacy objects encrypted by an existing V1 Client, then set this to `:v2_and_legacy`.
#    Otherwise, set it to `:v2`
#
# ## Keys
#
# For client-side encryption to work, you must provide one of the following:
#
# * An encryption key
# * A {KeyProvider}
# * A KMS encryption key id
#
# Additionally, the key wrapping schema must agree with the type of the key:
# * :aes_gcm: An AES encryption key or a key provider.
# * :rsa_oaep_sha1: An RSA encryption key or key provider.
# * :kms_context: A KMS encryption key id
#
# ### An Encryption Key
#
# You can pass a single encryption key. This is used as a master key
# encrypting and decrypting all object keys.
#
#     key = OpenSSL::Cipher.new("AES-256-ECB").random_key # symmetric key - used with `key_wrap_schema: :aes_gcm`
#     key = OpenSSL::PKey::RSA.new(1024) # asymmetric key pair - used with `key_wrap_schema: :rsa_oaep_sha1`
#
#     s3 = Aws::S3::EncryptionV2::Client.new(
#       encryption_key: key,
#       key_wrap_schema: :aes_gcm, # or :rsa_oaep_sha1 if using RSA
#       content_encryption_schema: :aes_gcm_no_padding,
#       security_profile: :v2
#     )
#
# ### Key Provider
#
# Alternatively, you can use a {KeyProvider}. A key provider makes
# it easy to work with multiple keys and simplifies key rotation.
#
# ### KMS Encryption Key Id
#
# If you pass the id of an AWS Key Management Service (KMS) key and
# use :kms_content for the key_wrap_schema, then KMS will be used to
# generate, encrypt and decrypt object keys.
#
#     # keep track of the kms key id
#     kms = Aws::KMS::Client.new
#     key_id = kms.create_key.key_metadata.key_id
#
#     Aws::S3::EncryptionV2::Client.new(
#       kms_key_id: key_id,
#       kms_client: kms,
#       key_wrap_schema: :kms_context,
#       content_encryption_schema: :aes_gcm_no_padding,
#       security_profile: :v2
#     )
#
# ## Custom Key Providers
#
# A {KeyProvider} is any object that responds to:
#
# * `#encryption_materials`
# * `#key_for(materials_description)`
#
# Here is a trivial implementation of an in-memory key provider.
# This is provided as a demonstration of the key provider interface,
# and should not be used in production:
#
#     class KeyProvider
#
#       def initialize(default_key_name, keys)
#         @keys = keys
#         @encryption_materials = Aws::S3::EncryptionV2::Materials.new(
#           key: @keys[default_key_name],
#           description: JSON.dump(key: default_key_name),
#         )
#       end
#
#       attr_reader :encryption_materials
#
#       def key_for(matdesc)
#         key_name = JSON.parse(matdesc)['key']
#         if key = @keys[key_name]
#           key
#         else
#           raise "encryption key not found for: #{matdesc.inspect}"
#         end
#       end
#     end
#
# Given the above key provider, you can create an encryption client that
# chooses the key to use based on the materials description stored with
# the encrypted object. This makes it possible to use multiple keys
# and simplifies key rotation.
#
#     # uses "new-key" for encrypting objects, uses either for decrypting
#     keys = KeyProvider.new('new-key', {
#       "old-key" => Base64.decode64("kM5UVbhE/4rtMZJfsadYEdm2vaKFsmV2f5+URSeUCV4="),
#       "new-key" => Base64.decode64("w1WLio3agRWRTSJK/Ouh8NHoqRQ6fn5WbSXDTHjXMSo="),
#     }),
#
#     # chooses the key based on the materials description stored
#     # with the encrypted object
#     s3 = Aws::S3::EncryptionV2::Client.new(
#       key_provider: keys,
#       key_wrap_schema: ...,
#       content_encryption_schema: :aes_gcm_no_padding,
#       security_profile: :v2
#     )
#
# ## Materials Description
#
# A materials description is JSON document string that is stored
# in the metadata (or instruction file) of an encrypted object.
# The {DefaultKeyProvider} uses the empty JSON document `"{}"`.
#
# When building a key provider, you are free to store whatever
# information you need to identify the master key that was used
# to encrypt the object.
#
# ## Envelope Location
#
# By default, the encryption client store the encryption envelope
# with the object, as metadata. You can choose to have the envelope
# stored in a separate "instruction file". An instruction file
# is an object, with the key of the encrypted object, suffixed with
# `".instruction"`.
#
# Specify the `:envelope_location` option as `:instruction_file` to
# use an instruction file for storing the envelope.
#
#     # default behavior
#     s3 = Aws::S3::EncryptionV2::Client.new(
#       key_provider: ...,
#       envelope_location: :metadata,
#     )
#
#     # store envelope in a separate object
#     s3 = Aws::S3::EncryptionV2::Client.new(
#       key_provider: ...,
#       envelope_location: :instruction_file,
#       instruction_file_suffix: '.instruction' # default
#       key_wrap_schema: ...,
#       content_encryption_schema: :aes_gcm_no_padding,
#       security_profile: :v2
#     )
#
# When using an instruction file, multiple requests are made when
# putting and getting the object. **This may cause issues if you are
# issuing concurrent PUT and GET requests to an encrypted object.**
module Aws::S3::EncryptionV2; end

# source://aws-sdk-s3//lib/aws-sdk-s3/encryption_v2.rb#18
Aws::S3::EncryptionV2::AES_GCM_TAG_LEN_BYTES = T.let(T.unsafe(nil), Integer)

class Aws::S3::EncryptionV2::Client
  extend ::Aws::Deprecations
  extend ::Forwardable

  # Creates a new encryption client. You must configure all of the following:
  #
  # * a key or key provider - The key provided also determines the key wrapping
  #   schema(s) supported for both encryption and decryption.
  # * `key_wrap_schema` - The key wrapping schema. It must match the type of key configured.
  # * `content_encryption_schema` - The only supported value currently is `:aes_gcm_no_padding`
  #    More options will be added in future releases.
  # * `security_profile` - Determines the support for reading objects written
  #    using older key wrap or content encryption schemas. If you need to read
  #    legacy objects encrypted by an existing V1 Client, then set this to `:v2_and_legacy`.
  #    Otherwise, set it to `:v2`
  #
  # To configure the key you must provide one of the following set of options:
  #
  # * `:encryption_key`
  # * `:kms_key_id`
  # * `:key_provider`
  #
  # You may also pass any other options accepted by `Client#initialize`.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#310
  def initialize(options = T.unsafe(nil)); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def build_request(*args, **_arg1, &block); end

  # @return [S3::Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#322
  def client; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def config(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def delete_object(*args, **_arg1, &block); end

  # @return [Symbol<:metadata, :instruction_file>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#337
  def envelope_location; end

  # Gets an object from Amazon S3, decrypting data locally.
  # See {S3::Client#get_object} for documentation on accepted
  # request parameters.
  # Warning: If you provide a block to get_object or set the request
  # parameter :response_target to a Proc, then read the entire object to the
  # end before you start using the decrypted data. This is to verify that
  # the object has not been modified since it was encrypted.
  #
  # @note The `:range` request parameter is not supported.
  # @option options
  # @option params
  # @option params
  # @option options
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param options [Hash] a customizable set of options
  # @param params [Hash] a customizable set of options
  # @return [Types::GetObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetObjectOutput#body #body} => IO
  #   * {Types::GetObjectOutput#delete_marker #delete_marker} => Boolean
  #   * {Types::GetObjectOutput#accept_ranges #accept_ranges} => String
  #   * {Types::GetObjectOutput#expiration #expiration} => String
  #   * {Types::GetObjectOutput#restore #restore} => String
  #   * {Types::GetObjectOutput#last_modified #last_modified} => Time
  #   * {Types::GetObjectOutput#content_length #content_length} => Integer
  #   * {Types::GetObjectOutput#etag #etag} => String
  #   * {Types::GetObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::GetObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::GetObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::GetObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::GetObjectOutput#missing_meta #missing_meta} => Integer
  #   * {Types::GetObjectOutput#version_id #version_id} => String
  #   * {Types::GetObjectOutput#cache_control #cache_control} => String
  #   * {Types::GetObjectOutput#content_disposition #content_disposition} => String
  #   * {Types::GetObjectOutput#content_encoding #content_encoding} => String
  #   * {Types::GetObjectOutput#content_language #content_language} => String
  #   * {Types::GetObjectOutput#content_range #content_range} => String
  #   * {Types::GetObjectOutput#content_type #content_type} => String
  #   * {Types::GetObjectOutput#expires #expires} => Time
  #   * {Types::GetObjectOutput#expires_string #expires_string} => String
  #   * {Types::GetObjectOutput#website_redirect_location #website_redirect_location} => String
  #   * {Types::GetObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::GetObjectOutput#metadata #metadata} => Hash&lt;String,String&gt;
  #   * {Types::GetObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::GetObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::GetObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::GetObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::GetObjectOutput#storage_class #storage_class} => String
  #   * {Types::GetObjectOutput#request_charged #request_charged} => String
  #   * {Types::GetObjectOutput#replication_status #replication_status} => String
  #   * {Types::GetObjectOutput#parts_count #parts_count} => Integer
  #   * {Types::GetObjectOutput#tag_count #tag_count} => Integer
  #   * {Types::GetObjectOutput#object_lock_mode #object_lock_mode} => String
  #   * {Types::GetObjectOutput#object_lock_retain_until_date #object_lock_retain_until_date} => Time
  #   * {Types::GetObjectOutput#object_lock_legal_hold_status #object_lock_legal_hold_status} => String
  # @see S3::Client#get_object
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#398
  def get_object(params = T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def head_object(*args, **_arg1, &block); end

  # @return [String] When {#envelope_location} is `:instruction_file`,
  #   the envelope is stored in the object with the object key suffixed
  #   by this string.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#342
  def instruction_file_suffix; end

  # @return [KeyProvider, nil] Returns `nil` if you are using
  #   AWS Key Management Service (KMS).
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#326
  def key_provider; end

  # @return [Boolean] If true the provided KMS key_id will not be used
  #   during decrypt, allowing decryption with the key_id from the object.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#334
  def kms_allow_decrypt_with_any_cmk; end

  # Uploads an object to Amazon S3, encrypting data client-side.
  # See {S3::Client#put_object} for documentation on accepted
  # request parameters.
  #
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param params [Hash] a customizable set of options
  # @return [Types::PutObjectOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::PutObjectOutput#expiration #expiration} => String
  #   * {Types::PutObjectOutput#etag #etag} => String
  #   * {Types::PutObjectOutput#checksum_crc32 #checksum_crc32} => String
  #   * {Types::PutObjectOutput#checksum_crc32c #checksum_crc32c} => String
  #   * {Types::PutObjectOutput#checksum_sha1 #checksum_sha1} => String
  #   * {Types::PutObjectOutput#checksum_sha256 #checksum_sha256} => String
  #   * {Types::PutObjectOutput#server_side_encryption #server_side_encryption} => String
  #   * {Types::PutObjectOutput#version_id #version_id} => String
  #   * {Types::PutObjectOutput#sse_customer_algorithm #sse_customer_algorithm} => String
  #   * {Types::PutObjectOutput#sse_customer_key_md5 #sse_customer_key_md5} => String
  #   * {Types::PutObjectOutput#ssekms_key_id #ssekms_key_id} => String
  #   * {Types::PutObjectOutput#ssekms_encryption_context #ssekms_encryption_context} => String
  #   * {Types::PutObjectOutput#bucket_key_enabled #bucket_key_enabled} => Boolean
  #   * {Types::PutObjectOutput#request_charged #request_charged} => String
  # @see S3::Client#put_object
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#354
  def put_object(params = T.unsafe(nil)); end

  # @return [Symbol] Determines the support for reading objects written
  #   using older key wrap or content encryption schemas.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#330
  def security_profile; end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#465
  def cipher_provider(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#494
  def envelope_options(params); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#442
  def extract_client(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#483
  def extract_key_provider(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#504
  def extract_location(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#533
  def extract_security_profile(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#515
  def extract_suffix(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#525
  def kms_any_cmk_mode(params); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#456
  def kms_client(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#537
  def security_profile_from_params(params); end

  # Validate required parameters exist and don't conflict.
  # The cek_alg and wrap_alg are passed on to the CipherProviders
  # and further validated there
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#425
  def validate_params(options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#547
  def validate_security_profile(security_profile); end
end

# @api private
class Aws::S3::EncryptionV2::DecryptHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#46
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#211
  def apply_cse_user_agent(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#65
  def attach_http_event_listeners(context); end

  # Determine the auth tag length from the algorithm
  # Validate it against the value provided in the x-amz-tag-len
  # Return the tag length in bytes
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#197
  def auth_tag_length(envelope); end

  # This method fetches the tag from the end of the object by
  # making a GET Object w/range request. This auth tag is used
  # to initialize the cipher, and the decrypter truncates the
  # auth tag from the body when writing the final bytes.
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#168
  def authenticated_decrypter(context, cipher, envelope); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#190
  def body_contains_auth_tag?(envelope); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#89
  def decryption_cipher(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#120
  def envelope_from_instr_file(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#110
  def envelope_from_metadata(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#131
  def extract_envelope(hash); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#102
  def get_encryption_envelope(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#141
  def v1_envelope(envelope); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#145
  def v2_envelope(envelope); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#44
Aws::S3::EncryptionV2::DecryptHandler::AUTH_REQUIRED_CEK_ALGS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#38
Aws::S3::EncryptionV2::DecryptHandler::POSSIBLE_ENCRYPTION_FORMATS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#28
Aws::S3::EncryptionV2::DecryptHandler::POSSIBLE_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#31
Aws::S3::EncryptionV2::DecryptHandler::POSSIBLE_WRAPPING_FORMATS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#12
Aws::S3::EncryptionV2::DecryptHandler::V1_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#18
Aws::S3::EncryptionV2::DecryptHandler::V2_ENVELOPE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/decrypt_handler.rb#26
Aws::S3::EncryptionV2::DecryptHandler::V2_OPTIONAL_KEYS = T.let(T.unsafe(nil), Array)

# @api private
class Aws::S3::EncryptionV2::DefaultCipherProvider
  # @api private
  # @return [DefaultCipherProvider] a new instance of DefaultCipherProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#11
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Cipher] Given an encryption envelope, returns a
  #   decryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#50
  def decryption_cipher(envelope, options = T.unsafe(nil)); end

  # @api private
  # @return [Array<Hash,Cipher>] Creates an returns a new encryption
  #   envelope and encryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#24
  def encryption_cipher(options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#157
  def decode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#153
  def encode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#141
  def encrypt_aes_gcm(data, auth_data); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#145
  def encrypt_rsa(data, auth_data); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#137
  def envelope_iv(cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#133
  def envelope_key(cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#149
  def materials_description; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#124
  def validate_cek(content_encryption_schema); end

  # Validate that the key_wrap_schema
  # is valid, supported and matches the provided key.
  # Returns the string version for the x-amz-key-wrap-alg
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#103
  def validate_key_wrap(key_wrap_schema, key); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_cipher_provider.rb#161
  def validate_options(options); end
end

# The default key provider is constructed with a single key
# that is used for both encryption and decryption, ignoring
# the possible per-object envelope encryption materials description.
#
# @api private
class Aws::S3::EncryptionV2::DefaultKeyProvider
  include ::Aws::S3::EncryptionV2::KeyProvider

  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [DefaultKeyProvider] a new instance of DefaultKeyProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_key_provider.rb#19
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Materials]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_key_provider.rb#27
  def encryption_materials; end

  # @api private
  # @param materials_description [String<JSON>]
  # @return Returns the key given in the constructor.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/default_key_provider.rb#33
  def key_for(materials_description); end
end

# source://aws-sdk-s3//lib/aws-sdk-s3/encryption_v2.rb#19
Aws::S3::EncryptionV2::EC_USER_AGENT = T.let(T.unsafe(nil), String)

# @api private
class Aws::S3::EncryptionV2::EncryptHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/encrypt_handler.rb#11
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/encrypt_handler.rb#54
  def apply_cse_user_agent(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/encrypt_handler.rb#39
  def apply_encryption_cipher(context, cipher); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/encrypt_handler.rb#25
  def apply_encryption_envelope(context, envelope); end
end

module Aws::S3::EncryptionV2::Errors; end

class Aws::S3::EncryptionV2::Errors::CEKAlgMismatchError < ::Aws::S3::EncryptionV2::Errors::DecryptionError
  # @return [CEKAlgMismatchError] a new instance of CEKAlgMismatchError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/errors.rb#26
  def initialize(*args); end
end

# Generic DecryptionError
class Aws::S3::EncryptionV2::Errors::DecryptionError < ::RuntimeError; end

class Aws::S3::EncryptionV2::Errors::EncryptionError < ::RuntimeError; end

# Raised when attempting to decrypt a legacy (V1) encrypted object
# when using a security_profile that does not support it.
class Aws::S3::EncryptionV2::Errors::LegacyDecryptionError < ::Aws::S3::EncryptionV2::Errors::DecryptionError
  # @return [LegacyDecryptionError] a new instance of LegacyDecryptionError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/errors.rb#16
  def initialize(*args); end
end

# @api private
class Aws::S3::EncryptionV2::IOAuthDecrypter
  # @api private
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [IOAuthDecrypter] a new instance of IOAuthDecrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_auth_decrypter.rb#19
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_auth_decrypter.rb#33
  def finalize; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_auth_decrypter.rb#37
  def io; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_auth_decrypter.rb#25
  def write(chunk); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_auth_decrypter.rb#43
  def truncate_chunk(chunk); end
end

# @api private
class Aws::S3::EncryptionV2::IODecrypter
  # @api private
  # @param cipher [OpenSSL::Cipher]
  # @param io [IO#write] An IO-like object that responds to `#write`.
  # @return [IODecrypter] a new instance of IODecrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_decrypter.rb#11
  def initialize(cipher, io); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_decrypter.rb#30
  def finalize; end

  # @api private
  # @return [#write]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_decrypter.rb#19
  def io; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_decrypter.rb#21
  def write(chunk); end
end

# Provides an IO wrapper encrypting a stream of data.
#
# @api private
class Aws::S3::EncryptionV2::IOEncrypter
  # @api private
  # @return [IOEncrypter] a new instance of IOEncrypter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#17
  def initialize(cipher, io); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#40
  def close; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#27
  def read(bytes = T.unsafe(nil), output_buffer = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#35
  def rewind; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#25
  def size; end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#46
  def encrypt_to_stringio(cipher, plain_text); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#54
  def encrypt_to_tempfile(cipher, io); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/io_encrypter.rb#15
Aws::S3::EncryptionV2::IOEncrypter::ONE_MEGABYTE = T.let(T.unsafe(nil), Integer)

# This module defines the interface required for a {Client#key_provider}.
# A key provider is any object that:
#
# * Responds to {#encryption_materials} with an {Materials} object.
#
# * Responds to {#key_for}, receiving a JSON document String,
#   returning an encryption key. The returned encryption key
#   must be one of:
#
#   * `OpenSSL::PKey::RSA` - for asymmetric encryption
#   * `String` - 32, 24, or 16 bytes long, for symmetric encryption
module Aws::S3::EncryptionV2::KeyProvider
  # @return [Materials]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/key_provider.rb#22
  def encryption_materials; end

  # @param materials_description [String<JSON>]
  # @return [OpenSSL::PKey::RSA, String] encryption_key
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/key_provider.rb#26
  def key_for(materials_description); end
end

# @api private
class Aws::S3::EncryptionV2::KmsCipherProvider
  # @api private
  # @return [KmsCipherProvider] a new instance of KmsCipherProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#11
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Cipher] Given an encryption envelope, returns a
  #   decryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#48
  def decryption_cipher(envelope, options = T.unsafe(nil)); end

  # @api private
  # @return [Array<Hash,Cipher>] Creates and returns a new encryption
  #   envelope and encryption cipher.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#24
  def encryption_cipher(options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#138
  def build_encryption_context(cek_alg, options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#155
  def decode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#151
  def encode64(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#114
  def validate_cek(content_encryption_schema); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#159
  def validate_key_for_encryption; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#106
  def validate_key_wrap(key_wrap_schema); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/kms_cipher_provider.rb#123
  def validate_kms_key(kms_key_id); end
end

class Aws::S3::EncryptionV2::Materials
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Materials] a new instance of Materials
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/materials.rb#17
  def initialize(options = T.unsafe(nil)); end

  # @return [String<JSON>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/materials.rb#26
  def description; end

  # @return [OpenSSL::PKey::RSA, String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/materials.rb#23
  def key; end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/materials.rb#49
  def validate_desc(description); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/materials.rb#30
  def validate_key(key); end
end

# @api private
module Aws::S3::EncryptionV2::Utils
  class << self
    # @api private
    # @param mode [String] "encrypt" or "decrypt"
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#82
    def aes_cipher(mode, block_mode, key, iv); end

    # @api private
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#74
    def aes_decryption_cipher(block_mode, key = T.unsafe(nil), iv = T.unsafe(nil)); end

    # @api private
    # @param block_mode [String] "CBC" or "ECB"
    # @param key [OpenSSL::PKey::RSA, String, nil]
    # @param iv [String, nil] The initialization vector
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#67
    def aes_encryption_cipher(block_mode, key = T.unsafe(nil), iv = T.unsafe(nil)); end

    # @api private
    # @param key [String]
    # @raise ArgumentError
    # @return [Integer]
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#95
    def cipher_size(key); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#27
    def decrypt(key, data); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#42
    def decrypt_aes_gcm(key, data, auth_data); end

    # returns the decrypted data + auth_data
    #
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#55
    def decrypt_rsa(key, enc_data); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#13
    def encrypt_aes_gcm(key, data, auth_data); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/utils.rb#21
    def encrypt_rsa(key, data, auth_data); end
  end
end

# Endpoint parameters used to influence endpoints per request.
class Aws::S3::EndpointParameters < ::Struct
  include ::Aws::Structure

  # @return [EndpointParameters] a new instance of EndpointParameters
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/endpoint_parameters.rb#107
  def initialize(options = T.unsafe(nil)); end

  # When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
  #
  # @return [Boolean]
  def accelerate; end

  # When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
  #
  # @return [Boolean]
  def accelerate=(_); end

  # The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
  #
  # @return [String]
  def bucket; end

  # The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
  #
  # @return [String]
  def bucket=(_); end

  # Internal parameter to disable Access Point Buckets
  #
  # @return [Boolean]
  def disable_access_points; end

  # Internal parameter to disable Access Point Buckets
  #
  # @return [Boolean]
  def disable_access_points=(_); end

  # Whether multi-region access points (MRAP) should be disabled.
  #
  # @return [Boolean]
  def disable_multi_region_access_points; end

  # Whether multi-region access points (MRAP) should be disabled.
  #
  # @return [Boolean]
  def disable_multi_region_access_points=(_); end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint; end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint=(_); end

  # When true, force a path-style endpoint to be used where the bucket name is part of the path.
  #
  # @return [Boolean]
  def force_path_style; end

  # When true, force a path-style endpoint to be used where the bucket name is part of the path.
  #
  # @return [Boolean]
  def force_path_style=(_); end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region; end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region=(_); end

  # When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN&#39;s region when constructing the endpoint instead of the client&#39;s configured region.
  #
  # @return [Boolean]
  def use_arn_region; end

  # When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN&#39;s region when constructing the endpoint instead of the client&#39;s configured region.
  #
  # @return [Boolean]
  def use_arn_region=(_); end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack; end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack=(_); end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips; end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips=(_); end

  # Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
  #
  # @return [Boolean]
  def use_global_endpoint; end

  # Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
  #
  # @return [Boolean]
  def use_global_endpoint=(_); end

  # Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
  #
  # @return [Boolean]
  def use_object_lambda_endpoint; end

  # Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
  #
  # @return [Boolean]
  def use_object_lambda_endpoint=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Aws::S3::EndpointProvider
  # @return [EndpointProvider] a new instance of EndpointProvider
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/endpoint_provider.rb#12
  def initialize(rule_set = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/endpoint_provider.rb#25
  def resolve_endpoint(parameters); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/endpoint_provider.rb#30
Aws::S3::EndpointProvider::RULES = T.let(T.unsafe(nil), String)

module Aws::S3::Endpoints; end

class Aws::S3::Endpoints::AbortMultipartUpload
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#15
    def build(context); end
  end
end

class Aws::S3::Endpoints::CompleteMultipartUpload
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#37
    def build(context); end
  end
end

class Aws::S3::Endpoints::CopyObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#59
    def build(context); end
  end
end

class Aws::S3::Endpoints::CreateBucket
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#81
    def build(context); end
  end
end

class Aws::S3::Endpoints::CreateMultipartUpload
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#103
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucket
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#125
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketAnalyticsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#147
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketCors
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#169
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketEncryption
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#191
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketIntelligentTieringConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#213
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketInventoryConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#235
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketLifecycle
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#257
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketMetricsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#279
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketOwnershipControls
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#301
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketPolicy
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#323
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketReplication
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#345
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#367
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteBucketWebsite
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#389
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#411
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteObjectTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#433
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeleteObjects
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#455
    def build(context); end
  end
end

class Aws::S3::Endpoints::DeletePublicAccessBlock
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#477
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketAccelerateConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#499
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketAcl
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#521
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketAnalyticsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#543
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketCors
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#565
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketEncryption
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#587
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketIntelligentTieringConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#609
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketInventoryConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#631
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketLifecycle
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#653
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketLifecycleConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#675
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketLocation
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#697
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketLogging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#719
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketMetricsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#741
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketNotification
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#763
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketNotificationConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#785
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketOwnershipControls
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#807
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketPolicy
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#829
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketPolicyStatus
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#851
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketReplication
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#873
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketRequestPayment
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#895
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#917
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketVersioning
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#939
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetBucketWebsite
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#961
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#983
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectAcl
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1005
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectAttributes
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1027
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectLegalHold
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1049
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectLockConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1071
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectRetention
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1093
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1115
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetObjectTorrent
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1137
    def build(context); end
  end
end

class Aws::S3::Endpoints::GetPublicAccessBlock
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1159
    def build(context); end
  end
end

class Aws::S3::Endpoints::HeadBucket
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1181
    def build(context); end
  end
end

class Aws::S3::Endpoints::HeadObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1203
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListBucketAnalyticsConfigurations
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1225
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListBucketIntelligentTieringConfigurations
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1247
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListBucketInventoryConfigurations
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1269
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListBucketMetricsConfigurations
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1291
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListBuckets
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1313
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListMultipartUploads
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1335
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListObjectVersions
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1357
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListObjects
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1379
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListObjectsV2
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1401
    def build(context); end
  end
end

class Aws::S3::Endpoints::ListParts
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1423
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketAccelerateConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1445
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketAcl
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1467
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketAnalyticsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1489
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketCors
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1511
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketEncryption
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1533
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketIntelligentTieringConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1555
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketInventoryConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1577
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketLifecycle
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1599
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketLifecycleConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1621
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketLogging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1643
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketMetricsConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1665
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketNotification
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1687
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketNotificationConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1709
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketOwnershipControls
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1731
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketPolicy
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1753
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketReplication
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1775
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketRequestPayment
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1797
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1819
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketVersioning
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1841
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutBucketWebsite
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1863
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1885
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObjectAcl
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1907
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObjectLegalHold
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1929
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObjectLockConfiguration
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1951
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObjectRetention
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1973
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutObjectTagging
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#1995
    def build(context); end
  end
end

class Aws::S3::Endpoints::PutPublicAccessBlock
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2017
    def build(context); end
  end
end

class Aws::S3::Endpoints::RestoreObject
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2039
    def build(context); end
  end
end

class Aws::S3::Endpoints::SelectObjectContent
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2061
    def build(context); end
  end
end

class Aws::S3::Endpoints::UploadPart
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2083
    def build(context); end
  end
end

class Aws::S3::Endpoints::UploadPartCopy
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2105
    def build(context); end
  end
end

class Aws::S3::Endpoints::WriteGetObjectResponse
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/endpoints.rb#2127
    def build(context); end
  end
end

# When S3 returns an error response, the Ruby SDK constructs and raises an error.
# These errors all extend Aws::S3::Errors::ServiceError < {Aws::Errors::ServiceError}
#
# You can rescue all S3 errors using ServiceError:
#
#     begin
#       # do stuff
#     rescue Aws::S3::Errors::ServiceError
#       # rescues all S3 API errors
#     end
#
#
# ## Request Context
# ServiceError objects have a {Aws::Errors::ServiceError#context #context} method that returns
# information about the request that generated the error.
# See {Seahorse::Client::RequestContext} for more information.
#
# ## Error Classes
# * {BucketAlreadyExists}
# * {BucketAlreadyOwnedByYou}
# * {InvalidObjectState}
# * {NoSuchBucket}
# * {NoSuchKey}
# * {NoSuchUpload}
# * {ObjectAlreadyInActiveTierError}
# * {ObjectNotInActiveTierError}
#
# Additionally, error classes are dynamically generated for service errors based on the error code
# if they are not defined above.
module Aws::S3::Errors
  extend ::Aws::Errors::DynamicErrors
end

class Aws::S3::Errors::BucketAlreadyExists < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::BucketAlreadyExists]
  # @return [BucketAlreadyExists] a new instance of BucketAlreadyExists
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#50
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::BucketAlreadyOwnedByYou < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::BucketAlreadyOwnedByYou]
  # @return [BucketAlreadyOwnedByYou] a new instance of BucketAlreadyOwnedByYou
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#60
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::InvalidObjectState < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::InvalidObjectState]
  # @return [InvalidObjectState] a new instance of InvalidObjectState
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#70
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#80
  def access_tier; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#75
  def storage_class; end
end

class Aws::S3::Errors::NoSuchBucket < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::NoSuchBucket]
  # @return [NoSuchBucket] a new instance of NoSuchBucket
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#90
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::NoSuchKey < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::NoSuchKey]
  # @return [NoSuchKey] a new instance of NoSuchKey
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#100
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::NoSuchUpload < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::NoSuchUpload]
  # @return [NoSuchUpload] a new instance of NoSuchUpload
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#110
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::ObjectAlreadyInActiveTierError < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::ObjectAlreadyInActiveTierError]
  # @return [ObjectAlreadyInActiveTierError] a new instance of ObjectAlreadyInActiveTierError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#120
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::ObjectNotInActiveTierError < ::Aws::S3::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::S3::Types::ObjectNotInActiveTierError]
  # @return [ObjectNotInActiveTierError] a new instance of ObjectNotInActiveTierError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/errors.rb#130
  def initialize(context, message, data = T.unsafe(nil)); end
end

class Aws::S3::Errors::ServiceError < ::Aws::Errors::ServiceError; end
module Aws::S3::EventStreams; end

class Aws::S3::EventStreams::SelectObjectContentEventStream
  # @return [SelectObjectContentEventStream] a new instance of SelectObjectContentEventStream
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#14
  def initialize; end

  # @api private
  # @return Aws::EventEmitter
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#63
  def event_emitter; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#30
  def on_cont_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#34
  def on_end_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#38
  def on_error_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#50
  def on_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#42
  def on_initial_response_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#26
  def on_progress_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#18
  def on_records_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#22
  def on_stats_event(&block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/event_streams.rb#46
  def on_unknown_event(&block); end
end

# @api private
class Aws::S3::FileDownloader
  # @api private
  # @return [FileDownloader] a new instance of FileDownloader
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#17
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#22
  def client; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#24
  def download(destination, options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#106
  def batches(chunks, mode); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#93
  def compute_chunk(file_size); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#71
  def compute_mode(file_size, count); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#81
  def construct_chunks(file_size); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#55
  def multipart_download; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#115
  def multithreaded_get_by_parts(parts); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#111
  def multithreaded_get_by_ranges(chunks); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#140
  def single_request; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#119
  def thread_batches(chunks, param); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#134
  def write(resp); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#14
Aws::S3::FileDownloader::MAX_PARTS = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#13
Aws::S3::FileDownloader::MIN_CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/file_downloader.rb#15
Aws::S3::FileDownloader::THREAD_COUNT = T.let(T.unsafe(nil), Integer)

# A utility class that provides an IO-like interface to a portion of a file
# on disk.
#
# @api private
class Aws::S3::FilePart
  # @api private
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [FilePart] a new instance of FilePart
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#19
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#52
  def close; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#31
  def first_byte; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#34
  def last_byte; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#39
  def read(bytes = T.unsafe(nil), output_buffer = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#44
  def rewind; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#37
  def size; end

  # @api private
  # @return [String, Pathname, File, Tempfile]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#28
  def source; end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#58
  def open_file; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#63
  def read_from_file(bytes, output_buffer); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_part.rb#72
  def remaining_bytes; end
end

# @api private
class Aws::S3::FileUploader
  # @api private
  # @option options
  # @option options
  # @param options [Hash]
  # @return [FileUploader] a new instance of FileUploader
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#15
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#23
  def client; end

  # @api private
  # @return [Integer] Files larger than or equal to this in bytes are uploaded
  #   using a {MultipartFileUploader}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#27
  def multipart_threshold; end

  # @api private
  # @option options
  # @option options
  # @option options
  # @option options
  # @param source [String, Pathname, File, Tempfile] The file to upload.
  # @param options [Hash] a customizable set of options
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#39
  def upload(source, options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#51
  def open_file(source); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#59
  def put_object(source, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#68
  def single_part_progress(progress_callback); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/file_uploader.rb#10
Aws::S3::FileUploader::ONE_HUNDRED_MEGABYTES = T.let(T.unsafe(nil), Integer)

# source://aws-sdk-s3//lib/aws-sdk-s3.rb#76
Aws::S3::GEM_VERSION = T.let(T.unsafe(nil), String)

# @api private
class Aws::S3::LegacySigner
  # @api private
  # @param credentials [CredentialProvider]
  # @return [LegacySigner] a new instance of LegacySigner
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#36
  def initialize(credentials, params, force_path_style); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#54
  def authorization(request); end

  # CanonicalizedAmzHeaders
  #
  # See the developer guide for more information on how this element
  # is generated.
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#106
  def canonicalized_headers(request); end

  # From the S3 developer guide
  #
  #     CanonicalizedResource =
  #       [ "/" ` Bucket ] `
  #       <HTTP-Request-URI, protocol name up to the querystring> +
  #       [ sub-resource, if present. e.g. "?acl", "?location",
  #       "?logging", or "?torrent"];
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#123
  def canonicalized_resource(endpoint); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#45
  def credentials; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#64
  def digest(secret, string_to_sign); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#68
  def hmac(key, value); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#45
  def params; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#47
  def sign(request); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#58
  def signature(request); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#152
  def signed_querystring_params(endpoint); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#91
  def signing_string_date(request); end

  # From the S3 developer guide:
  #
  #     StringToSign =
  #       HTTP-Verb ` "\n" `
  #       content-md5 ` "\n" `
  #       content-type ` "\n" `
  #       date ` "\n" `
  #       CanonicalizedAmzHeaders + CanonicalizedResource;
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#81
  def string_to_sign(request); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#158
  def uri_escape(s); end

  class << self
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#27
    def sign(context); end
  end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/legacy_signer.rb#14
Aws::S3::LegacySigner::SIGNED_QUERYSTRING_PARAMS = T.let(T.unsafe(nil), Set)

# @api private
class Aws::S3::MultipartFileUploader
  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [MultipartFileUploader] a new instance of MultipartFileUploader
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#35
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#41
  def client; end

  # @api private
  # @option options
  # @option options
  # @option options
  # @param source [String, Pathname, File, Tempfile] The file to upload.
  # @param options [Hash] a customizable set of options
  # @return [Seahorse::Client::Response] - the CompleteMultipartUploadResponse
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#50
  def upload(source, options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#86
  def abort_upload(upload_id, options, errors); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#130
  def complete_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#66
  def complete_upload(upload_id, parts, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#184
  def compute_default_part_size(source_size); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#101
  def compute_parts(upload_id, source, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#123
  def create_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#62
  def initiate_upload(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#188
  def part_size(total_size, part_size, offset); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#144
  def upload_in_threads(pending, completed, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#137
  def upload_part_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#75
  def upload_parts(upload_id, source, options); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#24
Aws::S3::MultipartFileUploader::COMPLETE_OPTIONS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#20
Aws::S3::MultipartFileUploader::CREATE_OPTIONS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#13
Aws::S3::MultipartFileUploader::FILE_TOO_SMALL = T.let(T.unsafe(nil), String)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#15
Aws::S3::MultipartFileUploader::MAX_PARTS = T.let(T.unsafe(nil), Integer)

# 5MB
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#11
Aws::S3::MultipartFileUploader::MIN_PART_SIZE = T.let(T.unsafe(nil), Integer)

# @api private
class Aws::S3::MultipartFileUploader::MultipartProgress
  # @api private
  # @return [MultipartProgress] a new instance of MultipartProgress
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#232
  def initialize(parts, progress_callback); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#238
  def call(part_number, bytes_read); end
end

# @api private
class Aws::S3::MultipartFileUploader::PartList
  # @api private
  # @return [PartList] a new instance of PartList
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#199
  def initialize(parts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#212
  def clear!; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#220
  def part_sizes; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#204
  def push(part); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#208
  def shift; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#216
  def size; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#224
  def to_a; end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#17
Aws::S3::MultipartFileUploader::THREAD_COUNT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_file_uploader.rb#29
Aws::S3::MultipartFileUploader::UPLOAD_PART_OPTIONS = T.let(T.unsafe(nil), Set)

# @api private
class Aws::S3::MultipartStreamUploader
  # @api private
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [MultipartStreamUploader] a new instance of MultipartStreamUploader
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#34
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#42
  def client; end

  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Seahorse::Client::Response] - the CompleteMultipartUploadResponse
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#47
  def upload(options = T.unsafe(nil), &block); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#96
  def abort_upload(upload_id, options, errors); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#125
  def complete_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#59
  def complete_upload(upload_id, parts, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#111
  def create_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#55
  def initiate_upload(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#132
  def read_to_part_body(read_pipe); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#149
  def upload_in_threads(read_pipe, completed, options, thread_errors); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#118
  def upload_part_opts(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#68
  def upload_parts(upload_id, options, &block); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#30
Aws::S3::MultipartStreamUploader::COMPLETE_UPLOAD_OPTIONS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#22
Aws::S3::MultipartStreamUploader::CREATE_OPTIONS = T.let(T.unsafe(nil), Set)

# api private
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#13
Aws::S3::MultipartStreamUploader::PART_SIZE = T.let(T.unsafe(nil), Integer)

# api private
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#19
Aws::S3::MultipartStreamUploader::TEMPFILE_PREIX = T.let(T.unsafe(nil), String)

# api private
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#16
Aws::S3::MultipartStreamUploader::THREAD_COUNT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/multipart_stream_uploader.rb#26
Aws::S3::MultipartStreamUploader::UPLOAD_PART_OPTIONS = T.let(T.unsafe(nil), Set)

class Aws::S3::MultipartUpload
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [MultipartUpload] a new instance of MultipartUpload
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#26
  def initialize(*args); end

  # @example Request syntax with placeholder values
  #
  #   multipart_upload.abort({
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::AbortMultipartUploadOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#247
  def abort(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#367
  def basic_complete(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#39
  def bucket_name; end

  # The algorithm that was used to create a checksum of the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#92
  def checksum_algorithm; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#99
  def client; end

  # @example Request syntax with placeholder values
  #
  #   object = multipart_upload.complete({
  #   multipart_upload: {
  #   parts: [
  #   {
  #   etag: "ETag",
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   part_number: 1,
  #   },
  #   ],
  #   },
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/multipart_upload.rb#27
  def complete(options = T.unsafe(nil)); end

  # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
  # @return [Types::MultipartUpload] Returns the data for this {MultipartUpload}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#114
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#122
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#484
  def deprecated_identifiers; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#49
  def id; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Date and time at which the multipart upload was initiated.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#67
  def initiated; end

  # Identifies who initiated the multipart upload.
  #
  # @return [Types::Initiator]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#86
  def initiator; end

  # Key of the object for which the multipart upload was initiated.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#61
  def key; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#105
  def load; end

  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#384
  def object; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#44
  def object_key; end

  # Specifies the owner of the object that is part of the multipart
  # upload.
  #
  # @return [Types::Owner]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#80
  def owner; end

  # @param part_number [String]
  # @return [MultipartUploadPart]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#394
  def part(part_number); end

  # @example Request syntax with placeholder values
  #
  #   parts = multipart_upload.parts({
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [MultipartUploadPart::Collection]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#456
  def parts(options = T.unsafe(nil)); end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#105
  def reload; end

  # The class of storage used to store the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#73
  def storage_class; end

  # Upload ID that identifies the multipart upload.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#55
  def upload_id; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#206
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/multipart_upload.rb#36
  def compute_parts; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#495
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#517
  def extract_id(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload.rb#506
  def extract_object_key(args, options); end
end

class Aws::S3::MultipartUpload::Collection < ::Aws::Resources::Collection; end

class Aws::S3::MultipartUploadError < ::StandardError
  # @return [MultipartUploadError] a new instance of MultipartUploadError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_error.rb#7
  def initialize(message, errors); end

  # @return [Array<StandardError>] The list of errors encountered
  #   when uploading or aborting the upload.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_error.rb#14
  def errors; end
end

class Aws::S3::MultipartUploadPart
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [MultipartUploadPart] a new instance of MultipartUploadPart
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#28
  def initialize(*args); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#42
  def bucket_name; end

  # This header can be used as a data integrity check to verify that the
  # data received is the same data that was originally sent. This header
  # specifies the base64-encoded, 32-bit CRC32 checksum of the object. For
  # more information, see [Checking object integrity][1] in the *Amazon S3
  # User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#89
  def checksum_crc32; end

  # The base64-encoded, 32-bit CRC32C checksum of the object. This will
  # only be present if it was uploaded with the object. With multipart
  # uploads, this may not be a checksum value of the object. For more
  # information about how checksums are calculated with multipart uploads,
  # see [ Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#103
  def checksum_crc32c; end

  # The base64-encoded, 160-bit SHA-1 digest of the object. This will only
  # be present if it was uploaded with the object. With multipart uploads,
  # this may not be a checksum value of the object. For more information
  # about how checksums are calculated with multipart uploads, see [
  # Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#117
  def checksum_sha1; end

  # This header can be used as a data integrity check to verify that the
  # data received is the same data that was originally sent. This header
  # specifies the base64-encoded, 256-bit SHA-256 digest of the object.
  # For more information, see [Checking object integrity][1] in the
  # *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#131
  def checksum_sha256; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#138
  def client; end

  # @example Request syntax with placeholder values
  #
  #   multipart_upload_part.copy_from({
  #   copy_source: "CopySource", # required
  #   copy_source_if_match: "CopySourceIfMatch",
  #   copy_source_if_modified_since: Time.now,
  #   copy_source_if_none_match: "CopySourceIfNoneMatch",
  #   copy_source_if_unmodified_since: Time.now,
  #   copy_source_range: "CopySourceRange",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   copy_source_sse_customer_algorithm: "CopySourceSSECustomerAlgorithm",
  #   copy_source_sse_customer_key: "CopySourceSSECustomerKey",
  #   copy_source_sse_customer_key_md5: "CopySourceSSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   expected_source_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::UploadPartCopyOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#391
  def copy_from(options = T.unsafe(nil)); end

  # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
  # @return [Types::Part] Returns the data for this {MultipartUploadPart}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#153
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#161
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#542
  def deprecated_identifiers; end

  # Entity tag returned when the part was uploaded.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#69
  def etag; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Date and time at which the part was uploaded.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#63
  def last_modified; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#144
  def load; end

  # @return [MultipartUpload]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#531
  def multipart_upload; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#52
  def multipart_upload_id; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#47
  def object_key; end

  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#57
  def part_number; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#144
  def reload; end

  # Size in bytes of the uploaded part data.
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#75
  def size; end

  # @example Request syntax with placeholder values
  #
  #   multipart_upload_part.upload({
  #   body: source_file,
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::UploadPartOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#517
  def upload(options = T.unsafe(nil)); end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#245
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#554
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#576
  def extract_multipart_upload_id(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#565
  def extract_object_key(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/multipart_upload_part.rb#587
  def extract_part_number(args, options); end
end

class Aws::S3::MultipartUploadPart::Collection < ::Aws::Resources::Collection; end

class Aws::S3::Object
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [Object] a new instance of Object
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#24
  def initialize(*args); end

  # Indicates that a range of bytes was specified.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#55
  def accept_ranges; end

  # @return [ObjectAcl]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1696
  def acl; end

  # The archive state of the head object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#96
  def archive_status; end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1705
  def bucket; end

  # Indicates whether the object uses an S3 Bucket Key for server-side
  # encryption with Amazon Web Services KMS (SSE-KMS).
  #
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#286
  def bucket_key_enabled; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#36
  def bucket_name; end

  # Specifies caching behavior along the request/reply chain.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#193
  def cache_control; end

  # The base64-encoded, 32-bit CRC32 checksum of the object. This will
  # only be present if it was uploaded with the object. With multipart
  # uploads, this may not be a checksum value of the object. For more
  # information about how checksums are calculated with multipart uploads,
  # see [ Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#122
  def checksum_crc32; end

  # The base64-encoded, 32-bit CRC32C checksum of the object. This will
  # only be present if it was uploaded with the object. With multipart
  # uploads, this may not be a checksum value of the object. For more
  # information about how checksums are calculated with multipart uploads,
  # see [ Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#136
  def checksum_crc32c; end

  # The base64-encoded, 160-bit SHA-1 digest of the object. This will only
  # be present if it was uploaded with the object. With multipart uploads,
  # this may not be a checksum value of the object. For more information
  # about how checksums are calculated with multipart uploads, see [
  # Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#150
  def checksum_sha1; end

  # The base64-encoded, 256-bit SHA-256 digest of the object. This will
  # only be present if it was uploaded with the object. With multipart
  # uploads, this may not be a checksum value of the object. For more
  # information about how checksums are calculated with multipart uploads,
  # see [ Checking object integrity][1] in the *Amazon S3 User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#164
  def checksum_sha256; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#402
  def client; end

  # Specifies presentational information for the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#199
  def content_disposition; end

  # Specifies what content encodings have been applied to the object and
  # thus what decoding mechanisms must be applied to obtain the media-type
  # referenced by the Content-Type header field.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#207
  def content_encoding; end

  # The language the content is in.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#213
  def content_language; end

  # Size of the body in bytes.
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#108
  def content_length; end

  # A standard MIME type describing the format of the object data.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#219
  def content_type; end

  # @example Request syntax with placeholder values
  #
  #   object.copy_from({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   cache_control: "CacheControl",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   copy_source: "CopySource", # required
  #   copy_source_if_match: "CopySourceIfMatch",
  #   copy_source_if_modified_since: Time.now,
  #   copy_source_if_none_match: "CopySourceIfNoneMatch",
  #   copy_source_if_unmodified_since: Time.now,
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   metadata_directive: "COPY", # accepts COPY, REPLACE
  #   tagging_directive: "COPY", # accepts COPY, REPLACE
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   copy_source_sse_customer_algorithm: "CopySourceSSECustomerAlgorithm",
  #   copy_source_sse_customer_key: "CopySourceSSECustomerKey",
  #   copy_source_sse_customer_key_md5: "CopySourceSSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   expected_source_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::CopyObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#67
  def copy_from(source, options = T.unsafe(nil)); end

  # Copies this object to another object. Use `multipart_copy: true`
  # for large objects. This is required for objects that exceed 5GB.
  #
  # @example Basic object copy
  #
  #   bucket = Aws::S3::Bucket.new('source-bucket')
  #   object = bucket.object('source-key')
  #
  #   # target as String
  #   object.copy_to('target-bucket/target-key')
  #
  #   # target as Hash
  #   object.copy_to(bucket: 'target-bucket', key: 'target-key')
  #
  #   # target as Aws::S3::Object
  #   object.copy_to(bucket.object('target-key'))
  # @example Managed copy of large objects
  #
  #   # uses multipart upload APIs to copy object
  #   object.copy_to('src-bucket/src-key', multipart_copy: true)
  # @note If you need to copy to a bucket in a different region, use
  #   {#copy_from}.
  # @param target [S3::Object, String, Hash] Where to copy the object
  #   data to. `target` must be one of the following:
  #
  #   * {Aws::S3::Object}
  #   * Hash - with `:bucket` and `:key`
  #   * String - formatted like `"target-bucket-name/target-key"`
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#108
  def copy_to(target, options = T.unsafe(nil)); end

  # @return [Types::HeadObjectOutput] Returns the data for this {Object}. Calls
  #   {Client#head_object} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#425
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#433
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   object.delete({
  #   mfa: "MFA",
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::DeleteObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#882
  def delete(options = T.unsafe(nil)); end

  # Specifies whether the object retrieved was (true) or was not (false) a
  # Delete Marker. If false, this response header does not appear in the
  # response.
  #
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#49
  def delete_marker; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1736
  def deprecated_identifiers; end

  # Downloads a file in S3 to a path on disk.
  #
  #     # small files (< 5MB) are downloaded in a single API call
  #     obj.download_file('/path/to/file')
  #
  # Files larger than 5MB are downloaded using multipart method
  #
  #     # large files are split into parts
  #     # and the parts are downloaded in parallel
  #     obj.download_file('/path/to/very_large_file')
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param destination [String] Where to download the file to.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Returns `true` when the file is downloaded without
  #   any errors.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#478
  def download_file(destination, options = T.unsafe(nil)); end

  # An entity tag (ETag) is an opaque identifier assigned by a web server
  # to a specific version of a resource found at a URL.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#171
  def etag; end

  # @param options [Hash] ({})
  # @return [Boolean] Returns `true` if the Object exists.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#440
  def exists?(options = T.unsafe(nil)); end

  # If the object expiration is configured (see PUT Bucket lifecycle), the
  # response includes this header. It includes the `expiry-date` and
  # `rule-id` key-value pairs providing object expiration information. The
  # value of the `rule-id` is URL-encoded.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#64
  def expiration; end

  # The date and time at which the object is no longer cacheable.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#225
  def expires; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#230
  def expires_string; end

  # @example Request syntax with placeholder values
  #
  #   object.get({
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   range: "Range",
  #   response_cache_control: "ResponseCacheControl",
  #   response_content_disposition: "ResponseContentDisposition",
  #   response_content_encoding: "ResponseContentEncoding",
  #   response_content_language: "ResponseContentLanguage",
  #   response_content_type: "ResponseContentType",
  #   response_expires: Time.now,
  #   version_id: "ObjectVersionId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::GetObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#989
  def get(options = T.unsafe(nil), &block); end

  # @example Request syntax with placeholder values
  #
  #   object.head({
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   range: "Range",
  #   version_id: "ObjectVersionId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::HeadObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1684
  def head(options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # @example Request syntax with placeholder values
  #
  #   multipartupload = object.initiate_multipart_upload({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [MultipartUpload]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1159
  def initiate_multipart_upload(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#41
  def key; end

  # Creation date of the object.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#102
  def last_modified; end

  # Loads, or reloads {#data} for the current {Object}.
  # Returns `self` making it possible to chain methods.
  #
  #     object.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#412
  def load; end

  # A map of metadata to store with the object in S3.
  #
  # @return [Hash<String,String>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#254
  def metadata; end

  # This is set to the number of metadata entries not returned in
  # `x-amz-meta` headers. This can happen if you create metadata using an
  # API like SOAP that supports more flexible metadata than the REST API.
  # For example, using SOAP, you can create metadata whose values are not
  # legal HTTP headers.
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#181
  def missing_meta; end

  # Copies and deletes the current object. The object will only be deleted
  # if the copy operation succeeds.
  #
  # @param target [S3::Object, String, Hash] Where to copy the object
  #   data to. `target` must be one of the following:
  #
  #   * {Aws::S3::Object}
  #   * Hash - with `:bucket` and `:key`
  #   * String - formatted like `"target-bucket-name/target-key"`
  # @return [void]
  # @see Object#copy_to
  # @see Object#delete
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#120
  def move_to(target, options = T.unsafe(nil)); end

  # @param id [String]
  # @return [MultipartUpload]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1714
  def multipart_upload(id); end

  # Specifies whether a legal hold is in effect for this object. This
  # header is only returned if the requester has the
  # `s3:GetObjectLegalHold` permission. This header is not returned if the
  # specified version of this object has never had a legal hold applied.
  # For more information about S3 Object Lock, see [Object Lock][1].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#395
  def object_lock_legal_hold_status; end

  # The Object Lock mode, if any, that's in effect for this object. This
  # header is only returned if the requester has the
  # `s3:GetObjectRetention` permission. For more information about S3
  # Object Lock, see [Object Lock][1].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#373
  def object_lock_mode; end

  # The date and time when the Object Lock retention period expires. This
  # header is only returned if the requester has the
  # `s3:GetObjectRetention` permission.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#381
  def object_lock_retain_until_date; end

  # The count of parts this object has. This value is only returned if you
  # specify `partNumber` in your request and the object was uploaded as a
  # multipart upload.
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#360
  def parts_count; end

  # Creates a {PresignedPost} that makes it easy to upload a file from
  # a web browser direct to Amazon S3 using an HTML post form with
  # a file field.
  #
  # See the {PresignedPost} documentation for more information.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @return [PresignedPost]
  # @see PresignedPost
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#134
  def presigned_post(options = T.unsafe(nil)); end

  # Allows you to create presigned URL requests for S3 operations. This
  # method returns a tuple containing the URL and the signed X-amz-* headers
  # to be used with the presigned url.
  #
  # @example Pre-signed GET URL, valid for one hour
  #
  #   obj.presigned_request(:get, expires_in: 3600)
  #   #=> ["https://bucket-name.s3.amazonaws.com/object-key?...", {}]
  # @example Pre-signed PUT with a canned ACL
  #
  #   # the object uploaded using this URL will be publicly accessible
  #   obj.presigned_request(:put, acl: 'public-read')
  #   #=> ["https://bucket-name.s3.amazonaws.com/object-key?...",
  #   {"x-amz-acl"=>"public-read"}]
  # @option params
  # @option params
  # @param method [Symbol] The S3 operation to generate a presigned request for. Valid values
  #   are `:get`, `:put`, `:head`, `:delete`, `:create_multipart_upload`,
  #   `:list_multipart_uploads`, `:complete_multipart_upload`,
  #   `:abort_multipart_upload`, `:list_parts`, and `:upload_part`.
  # @param params [Hash] Additional request parameters to use when generating the pre-signed
  #   request. See the related documentation in {Client} for accepted
  #   params.
  #
  #   | Method                       | Client Method                      |
  #   |------------------------------|------------------------------------|
  #   | `:get`                       | {Client#get_object}                |
  #   | `:put`                       | {Client#put_object}                |
  #   | `:head`                      | {Client#head_object}               |
  #   | `:delete`                    | {Client#delete_object}             |
  #   | `:create_multipart_upload`   | {Client#create_multipart_upload}   |
  #   | `:list_multipart_uploads`    | {Client#list_multipart_uploads}    |
  #   | `:complete_multipart_upload` | {Client#complete_multipart_upload} |
  #   | `:abort_multipart_upload`    | {Client#abort_multipart_upload}    |
  #   | `:list_parts`                | {Client#list_parts}                |
  #   | `:upload_part`               | {Client#upload_part}               |
  # @raise [ArgumentError] Raised if `:expires_in` exceeds one week
  #   (604800 seconds).
  # @return [String, Hash] A tuple with a presigned URL and headers that
  #   should be included with the request.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#278
  def presigned_request(method, params = T.unsafe(nil)); end

  # Generates a pre-signed URL for this object.
  #
  # @example Pre-signed GET URL, valid for one hour
  #
  #   obj.presigned_url(:get, expires_in: 3600)
  #   #=> "https://bucket-name.s3.amazonaws.com/object-key?..."
  # @example Pre-signed PUT with a canned ACL
  #
  #   # the object uploaded using this URL will be publicly accessible
  #   obj.presigned_url(:put, acl: 'public-read')
  #   #=> "https://bucket-name.s3.amazonaws.com/object-key?..."
  # @example Pre-signed UploadPart PUT
  #
  #   # the object uploaded using this URL will be publicly accessible
  #   obj.presigned_url(:upload_part, part_number: 1, upload_id: 'uploadIdToken')
  #   #=> "https://bucket-name.s3.amazonaws.com/object-key?..."
  # @option params
  # @option params
  # @param method [Symbol] The S3 operation to generate a presigned URL for. Valid values
  #   are `:get`, `:put`, `:head`, `:delete`, `:create_multipart_upload`,
  #   `:list_multipart_uploads`, `:complete_multipart_upload`,
  #   `:abort_multipart_upload`, `:list_parts`, and `:upload_part`.
  # @param params [Hash] Additional request parameters to use when generating the pre-signed
  #   URL. See the related documentation in {Client} for accepted
  #   params.
  #
  #   | Method                       | Client Method                      |
  #   |------------------------------|------------------------------------|
  #   | `:get`                       | {Client#get_object}                |
  #   | `:put`                       | {Client#put_object}                |
  #   | `:head`                      | {Client#head_object}               |
  #   | `:delete`                    | {Client#delete_object}             |
  #   | `:create_multipart_upload`   | {Client#create_multipart_upload}   |
  #   | `:list_multipart_uploads`    | {Client#list_multipart_uploads}    |
  #   | `:complete_multipart_upload` | {Client#complete_multipart_upload} |
  #   | `:abort_multipart_upload`    | {Client#abort_multipart_upload}    |
  #   | `:list_parts`                | {Client#list_parts}                |
  #   | `:upload_part`               | {Client#upload_part}               |
  # @raise [ArgumentError] Raised if `:expires_in` exceeds one week
  #   (604800 seconds).
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#205
  def presigned_url(method, params = T.unsafe(nil)); end

  # Returns the public (un-signed) URL for this object.
  #
  #     s3.bucket('bucket-name').object('obj-key').public_url
  #     #=> "https://bucket-name.s3.amazonaws.com/obj-key"
  #
  # To use virtual hosted bucket url.
  # Uses https unless secure: false is set.  If the bucket
  # name contains dots (.) then you will need to set secure: false.
  #
  #     s3.bucket('my-bucket.com').object('key')
  #       .public_url(virtual_host: true)
  #     #=> "https://my-bucket.com/key"
  #
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#313
  def public_url(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   object.put({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   body: source_file,
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   content_type: "ContentType",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::PutObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1467
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {Object}.
  # Returns `self` making it possible to chain methods.
  #
  #     object.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#412
  def reload; end

  # Amazon S3 can return this header if your request involves a bucket
  # that is either a source or a destination in a replication rule.
  #
  # In replication, you have a source bucket on which you configure
  # replication and destination bucket or buckets where Amazon S3 stores
  # object replicas. When you request an object (`GetObject`) or object
  # metadata (`HeadObject`) from these buckets, Amazon S3 will return the
  # `x-amz-replication-status` header in the response as follows:
  #
  # * **If requesting an object from the source bucket**, Amazon S3 will
  #   return the `x-amz-replication-status` header if the object in your
  #   request is eligible for replication.
  #
  #   For example, suppose that in your replication configuration, you
  #   specify object prefix `TaxDocs` requesting Amazon S3 to replicate
  #   objects with key prefix `TaxDocs`. Any objects you upload with this
  #   key name prefix, for example `TaxDocs/document1.pdf`, are eligible
  #   for replication. For any object request with this key name prefix,
  #   Amazon S3 will return the `x-amz-replication-status` header with
  #   value PENDING, COMPLETED or FAILED indicating object replication
  #   status.
  #
  # * **If requesting an object from a destination bucket**, Amazon S3
  #   will return the `x-amz-replication-status` header with value REPLICA
  #   if the object in your request is a replica that Amazon S3 created
  #   and there is no replica modification replication in progress.
  #
  # * **When replicating objects to multiple destination buckets**, the
  #   `x-amz-replication-status` header acts differently. The header of
  #   the source object will only return a value of COMPLETED when
  #   replication is successful to all destinations. The header will
  #   remain at value PENDING until replication has completed for all
  #   destinations. If one or more destinations fails replication the
  #   header will return FAILED.
  #
  # For more information, see [Replication][1].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#352
  def replication_status; end

  # If present, indicates that the requester was successfully charged for
  # the request.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#307
  def request_charged; end

  # If the object is an archived object (an object whose storage class is
  # GLACIER), the response includes this header if either the archive
  # restoration is in progress (see [RestoreObject][1] or an archive copy
  # is already restored.
  #
  # If an archive copy is already restored, the header value indicates
  # when Amazon S3 is scheduled to delete the object copy. For example:
  #
  # `x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012
  # 00:00:00 GMT"`
  #
  # If the object restoration is in progress, the header returns the value
  # `ongoing-request="true"`.
  #
  # For more information about archiving objects, see [Transitioning
  # Objects: General Considerations][2].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html
  # [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#90
  def restore; end

  # @example Request syntax with placeholder values
  #
  #   object.restore_object({
  #   version_id: "ObjectVersionId",
  #   restore_request: {
  #   days: 1,
  #   glacier_job_parameters: {
  #   tier: "Standard", # required, accepts Standard, Bulk, Expedited
  #   },
  #   type: "SELECT", # accepts SELECT
  #   tier: "Standard", # accepts Standard, Bulk, Expedited
  #   description: "Description",
  #   select_parameters: {
  #   input_serialization: { # required
  #   csv: {
  #   file_header_info: "USE", # accepts USE, IGNORE, NONE
  #   comments: "Comments",
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   allow_quoted_record_delimiter: false,
  #   },
  #   compression_type: "NONE", # accepts NONE, GZIP, BZIP2
  #   json: {
  #   type: "DOCUMENT", # accepts DOCUMENT, LINES
  #   },
  #   parquet: {
  #   },
  #   },
  #   expression_type: "SQL", # required, accepts SQL
  #   expression: "Expression", # required
  #   output_serialization: { # required
  #   csv: {
  #   quote_fields: "ALWAYS", # accepts ALWAYS, ASNEEDED
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   },
  #   json: {
  #   record_delimiter: "RecordDelimiter",
  #   },
  #   },
  #   },
  #   output_location: {
  #   s3: {
  #   bucket_name: "BucketName", # required
  #   prefix: "LocationPrefix", # required
  #   encryption: {
  #   encryption_type: "AES256", # required, accepts AES256, aws:kms
  #   kms_key_id: "SSEKMSKeyId",
  #   kms_context: "KMSContext",
  #   },
  #   canned_acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   access_control_list: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   tagging: {
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   user_metadata: [
  #   {
  #   name: "MetadataKey",
  #   value: "MetadataValue",
  #   },
  #   ],
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   },
  #   },
  #   },
  #   request_payer: "requester", # accepts requester
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::RestoreObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1600
  def restore_object(options = T.unsafe(nil)); end

  # If the object is stored using server-side encryption either with an
  # Amazon Web Services KMS key or an Amazon S3-managed encryption key,
  # the response includes this header with the value of the server-side
  # encryption algorithm used when storing this object in Amazon S3 (for
  # example, AES256, aws:kms).
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#248
  def server_side_encryption; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#108
  def size; end

  # If server-side encryption with a customer-provided encryption key was
  # requested, the response will include this header confirming the
  # encryption algorithm used.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#262
  def sse_customer_algorithm; end

  # If server-side encryption with a customer-provided encryption key was
  # requested, the response will include this header to provide round-trip
  # message integrity verification of the customer-provided encryption
  # key.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#271
  def sse_customer_key_md5; end

  # If present, specifies the ID of the Amazon Web Services Key Management
  # Service (Amazon Web Services KMS) symmetric customer managed key that
  # was used for the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#279
  def ssekms_key_id; end

  # Provides storage class information of the object. Amazon S3 returns
  # this header for all objects except for S3 Standard storage class
  # objects.
  #
  # For more information, see [Storage Classes][1].
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#300
  def storage_class; end

  # Uploads a file from disk to the current object in S3.
  #
  #     # small files are uploaded in a single API call
  #     obj.upload_file('/path/to/file')
  #
  # Files larger than or equal to `:multipart_threshold` are uploaded
  # using the Amazon S3 multipart upload APIs.
  #
  #     # large files are automatically split into parts
  #     # and the parts are uploaded in parallel
  #     obj.upload_file('/path/to/very_large_file')
  #
  # The response of the S3 upload API is yielded if a block given.
  #
  #     # API response will have etag value of the file
  #     obj.upload_file('/path/to/file') do |response|
  #       etag = response.etag
  #     end
  #
  # You can provide a callback to monitor progress of the upload:
  #
  #     # bytes and totals are each an array with 1 entry per part
  #     progress = Proc.new do |bytes, totals|
  #       puts bytes.map.with_index { |b, i| "Part #{i+1}: #{b} / #{totals[i]}"}.join(' ') + "Total: #{100.0 * bytes.sum / totals.sum }%" }
  #     end
  #     obj.upload_file('/path/to/file', progress_callback: progress)
  #
  # @option options
  # @option options
  # @option options
  # @param source [String, Pathname, File, Tempfile] A file on the local
  #   file system that will be uploaded as this object. This can either be
  #   a String or Pathname to the file, an open File object, or an open
  #   Tempfile object. If you pass an open File or Tempfile object, then
  #   you are responsible for closing it after the upload completes. When
  #   using an open Tempfile, rewind it before uploading or else the object
  #   will be empty.
  # @param options [Hash] a customizable set of options
  # @raise [MultipartUploadError] If an object is being uploaded in
  #   parts, and the upload can not be completed, then the upload is
  #   aborted and this error is raised.  The raised error has a `#errors`
  #   method that returns the failures that caused the upload to be
  #   aborted.
  # @return [Boolean] Returns `true` when the object is uploaded
  #   without any errors.
  # @yield [response]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#434
  def upload_file(source, options = T.unsafe(nil)); end

  # Uploads a stream in a streaming fashion to the current object in S3.
  #
  # Passed chunks automatically split into multipart upload parts and the
  # parts are uploaded in parallel. This allows for streaming uploads that
  # never touch the disk.
  #
  # Note that this is known to have issues in JRuby until jruby-9.1.15.0,
  # so avoid using this with older versions of JRuby.
  #
  # @example Streaming chunks of data
  #   obj.upload_stream do |write_stream|
  #   10.times { write_stream << 'foo' }
  #   end
  # @example Streaming chunks of data
  #   obj.upload_stream do |write_stream|
  #   IO.copy_stream(IO.popen('ls'), write_stream)
  #   end
  # @example Streaming chunks of data
  #   obj.upload_stream do |write_stream|
  #   IO.copy_stream(STDIN, write_stream)
  #   end
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [MultipartUploadError] If an object is being uploaded in
  #   parts, and the upload can not be completed, then the upload is
  #   aborted and this error is raised.  The raised error has a `#errors`
  #   method that returns the failures that caused the upload to be
  #   aborted.
  # @return [Boolean] Returns `true` when the object is uploaded
  #   without any errors.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object.rb#363
  def upload_stream(options = T.unsafe(nil), &block); end

  # @param id [String]
  # @return [ObjectVersion]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1725
  def version(id); end

  # Version of the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#187
  def version_id; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#569
  def wait_until(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#457
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#476
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  # If the bucket is configured as a website, redirects requests for this
  # object to another object in the same bucket or to an external URL.
  # Amazon S3 stores the value of this header in the object metadata.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#238
  def website_redirect_location; end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1746
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1757
  def extract_key(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1778
  def separate_params_and_options(options); end

  # @yield [waiter.waiter]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1768
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::Object::Collection < ::Aws::Resources::Collection
  # @example Request syntax with placeholder values
  #
  #   object.batch_delete!({
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [{}]
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1851
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object.rb#1851
  def deprecated_delete(options = T.unsafe(nil)); end
end

class Aws::S3::ObjectAcl
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [ObjectAcl] a new instance of ObjectAcl
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#24
  def initialize(*args); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#36
  def bucket_name; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#67
  def client; end

  # @return [Types::GetObjectAclOutput] Returns the data for this {ObjectAcl}. Calls
  #   {Client#get_object_acl} if {#data_loaded?} is `false`.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#90
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#98
  def data_loaded?; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#334
  def deprecated_identifiers; end

  # A list of grants.
  #
  # @return [Array<Types::Grant>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#53
  def grants; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Loads, or reloads {#data} for the current {ObjectAcl}.
  # Returns `self` making it possible to chain methods.
  #
  #     object_acl.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#77
  def load; end

  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#324
  def object; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#41
  def object_key; end

  # Container for the bucket owner's display name and ID.
  #
  # @return [Types::Owner]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#47
  def owner; end

  # @example Request syntax with placeholder values
  #
  #   object_acl.put({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   access_control_policy: {
  #   grants: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   owner: {
  #   display_name: "DisplayName",
  #   id: "ID",
  #   },
  #   },
  #   content_md5: "ContentMD5",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   request_payer: "requester", # accepts requester
  #   version_id: "ObjectVersionId",
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::PutObjectAclOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#312
  def put(options = T.unsafe(nil)); end

  # Loads, or reloads {#data} for the current {ObjectAcl}.
  # Returns `self` making it possible to chain methods.
  #
  #     object_acl.reload.data
  #
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#77
  def reload; end

  # If present, indicates that the requester was successfully charged for
  # the request.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#60
  def request_charged; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#182
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#344
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_acl.rb#355
  def extract_object_key(args, options); end
end

class Aws::S3::ObjectAcl::Collection < ::Aws::Resources::Collection; end

# @api private
class Aws::S3::ObjectCopier
  # @api private
  # @param object [S3::Object]
  # @return [ObjectCopier] a new instance of ObjectCopier
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#11
  def initialize(object, options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#16
  def copy_from(source, options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#20
  def copy_to(target, options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#78
  def apply_source_client(source, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#26
  def copy_object(source, target, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#39
  def copy_source(source); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#56
  def copy_target(target); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#95
  def escape(str); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_copier.rb#67
  def merge_options(source_or_target, options); end
end

# @api private
class Aws::S3::ObjectMultipartCopier
  # @api private
  # @option options
  # @option [Integer]
  # @option [Integer]
  # @param options [Hash] a customizable set of options
  # @param [Integer] [Hash] a customizable set of options
  # @return [ObjectMultipartCopier] a new instance of ObjectMultipartCopier
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#23
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#30
  def client; end

  # @api private
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param params [Hash] a customizable set of options
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#33
  def copy(options = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#89
  def abort_upload(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#113
  def byte_range(offset, default_part_size, size); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#83
  def complete_upload(parts, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#97
  def compute_parts(size, default_part_size, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#76
  def copy_part(part); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#61
  def copy_part_thread(queue); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#52
  def copy_parts(size, default_part_size, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#138
  def default_part_size(source_size); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#47
  def initiate_upload(options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#146
  def options_for(operation_name, options); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#121
  def source_size(options); end

  class << self
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#154
    def options_for(shape_name); end
  end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#158
Aws::S3::ObjectMultipartCopier::API_OPTIONS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#13
Aws::S3::ObjectMultipartCopier::FILE_TOO_SMALL = T.let(T.unsafe(nil), String)

# 5MB
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#11
Aws::S3::ObjectMultipartCopier::FIVE_MB = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#15
Aws::S3::ObjectMultipartCopier::MAX_PARTS = T.let(T.unsafe(nil), Integer)

# @api private
class Aws::S3::ObjectMultipartCopier::PartQueue
  # @api private
  # @return [PartQueue] a new instance of PartQueue
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#166
  def initialize(parts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#175
  def clear!; end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_multipart_copier.rb#171
  def shift; end
end

class Aws::S3::ObjectSummary
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [ObjectSummary] a new instance of ObjectSummary
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#24
  def initialize(*args); end

  # @return [ObjectAcl]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1306
  def acl; end

  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1315
  def bucket; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#36
  def bucket_name; end

  # The algorithm that was used to create a checksum of the object.
  #
  # @return [Array<String>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#79
  def checksum_algorithm; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#104
  def client; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#85
  def content_length; end

  # @example Request syntax with placeholder values
  #
  #   object_summary.copy_from({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   cache_control: "CacheControl",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   copy_source: "CopySource", # required
  #   copy_source_if_match: "CopySourceIfMatch",
  #   copy_source_if_modified_since: Time.now,
  #   copy_source_if_none_match: "CopySourceIfNoneMatch",
  #   copy_source_if_unmodified_since: Time.now,
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   metadata_directive: "COPY", # accepts COPY, REPLACE
  #   tagging_directive: "COPY", # accepts COPY, REPLACE
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   copy_source_sse_customer_algorithm: "CopySourceSSECustomerAlgorithm",
  #   copy_source_sse_customer_key: "CopySourceSSECustomerKey",
  #   copy_source_sse_customer_key_md5: "CopySourceSSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   expected_source_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::CopyObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#16
  def copy_from(source, options = T.unsafe(nil)); end

  # @param target [S3::Object, String, Hash] Where to copy the object
  #   data to. `target` must be one of the following:
  #
  #   * {Aws::S3::Object}
  #   * Hash - with `:bucket` and `:key`
  #   * String - formatted like `"target-bucket-name/target-key"`
  # @see Object#copy_to
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#24
  def copy_to(target, options = T.unsafe(nil)); end

  # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
  # @return [Types::Object] Returns the data for this {ObjectSummary}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#119
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#127
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   object_summary.delete({
  #   mfa: "MFA",
  #   version_id: "ObjectVersionId",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::DeleteObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#576
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1355
  def deprecated_identifiers; end

  # @param destination [String] Where to download the file to.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Returns `true` when the file is downloaded without
  #   any errors.
  # @see Object#download_file
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#79
  def download_file(destination, options = T.unsafe(nil)); end

  # The entity tag is a hash of the object. The ETag reflects changes only
  # to the contents of an object, not its metadata. The ETag may or may
  # not be an MD5 digest of the object data. Whether or not it is depends
  # on how the object was created and how it is encrypted as described
  # below:
  #
  # * Objects created by the PUT Object, POST Object, or Copy operation,
  #   or through the Amazon Web Services Management Console, and are
  #   encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest
  #   of their object data.
  #
  # * Objects created by the PUT Object, POST Object, or Copy operation,
  #   or through the Amazon Web Services Management Console, and are
  #   encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest
  #   of their object data.
  #
  # * If an object is created by either the Multipart Upload or Part Copy
  #   operation, the ETag is not an MD5 digest, regardless of the method
  #   of encryption. If an object is larger than 16 MB, the Amazon Web
  #   Services Management Console will upload or copy that object as a
  #   Multipart Upload, and therefore the ETag will not be an MD5 digest.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#73
  def etag; end

  # @param options [Hash] ({})
  # @return [Boolean] Returns `true` if the ObjectSummary exists.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#134
  def exists?(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   object_summary.get({
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   range: "Range",
  #   response_cache_control: "ResponseCacheControl",
  #   response_content_disposition: "ResponseContentDisposition",
  #   response_content_encoding: "ResponseContentEncoding",
  #   response_content_language: "ResponseContentLanguage",
  #   response_content_type: "ResponseContentType",
  #   response_expires: Time.now,
  #   version_id: "ObjectVersionId",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::GetObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#683
  def get(options = T.unsafe(nil), &block); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # @example Request syntax with placeholder values
  #
  #   multipartupload = object_summary.initiate_multipart_upload({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_type: "ContentType",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [MultipartUpload]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#853
  def initiate_multipart_upload(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#41
  def key; end

  # Creation date of the object.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#47
  def last_modified; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#110
  def load; end

  # @param target [S3::Object, String, Hash] Where to copy the object
  #   data to. `target` must be one of the following:
  #
  #   * {Aws::S3::Object}
  #   * Hash - with `:bucket` and `:key`
  #   * String - formatted like `"target-bucket-name/target-key"`
  # @return [void]
  # @see Object#move_to
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#32
  def move_to(target, options = T.unsafe(nil)); end

  # @param id [String]
  # @return [MultipartUpload]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1324
  def multipart_upload(id); end

  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1334
  def object; end

  # The owner of the object
  #
  # @return [Types::Owner]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#97
  def owner; end

  # @return [PresignedPost]
  # @see Object#presigned_post
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#40
  def presigned_post(options = T.unsafe(nil)); end

  # @param method [Symbol] The S3 operation to generate a presigned URL for. Valid values
  #   are `:get`, `:put`, `:head`, `:delete`, `:create_multipart_upload`,
  #   `:list_multipart_uploads`, `:complete_multipart_upload`,
  #   `:abort_multipart_upload`, `:list_parts`, and `:upload_part`.
  # @param params [Hash] Additional request parameters to use when generating the pre-signed
  #   URL. See the related documentation in {Client} for accepted
  #   params.
  #
  #   | Method                       | Client Method                      |
  #   |------------------------------|------------------------------------|
  #   | `:get`                       | {Client#get_object}                |
  #   | `:put`                       | {Client#put_object}                |
  #   | `:head`                      | {Client#head_object}               |
  #   | `:delete`                    | {Client#delete_object}             |
  #   | `:create_multipart_upload`   | {Client#create_multipart_upload}   |
  #   | `:list_multipart_uploads`    | {Client#list_multipart_uploads}    |
  #   | `:complete_multipart_upload` | {Client#complete_multipart_upload} |
  #   | `:abort_multipart_upload`    | {Client#abort_multipart_upload}    |
  #   | `:list_parts`                | {Client#list_parts}                |
  #   | `:upload_part`               | {Client#upload_part}               |
  # @return [String]
  # @see Object#presigned_url
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#48
  def presigned_url(http_method, params = T.unsafe(nil)); end

  # @param options [Hash] a customizable set of options
  # @return [String]
  # @see Object#public_url
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#56
  def public_url(options = T.unsafe(nil)); end

  # @example Request syntax with placeholder values
  #
  #   object_summary.put({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   body: source_file,
  #   cache_control: "CacheControl",
  #   content_disposition: "ContentDisposition",
  #   content_encoding: "ContentEncoding",
  #   content_language: "ContentLanguage",
  #   content_length: 1,
  #   content_md5: "ContentMD5",
  #   content_type: "ContentType",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   checksum_crc32: "ChecksumCRC32",
  #   checksum_crc32c: "ChecksumCRC32C",
  #   checksum_sha1: "ChecksumSHA1",
  #   checksum_sha256: "ChecksumSHA256",
  #   expires: Time.now,
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write_acp: "GrantWriteACP",
  #   metadata: {
  #   "MetadataKey" => "MetadataValue",
  #   },
  #   server_side_encryption: "AES256", # accepts AES256, aws:kms
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   website_redirect_location: "WebsiteRedirectLocation",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   ssekms_key_id: "SSEKMSKeyId",
  #   ssekms_encryption_context: "SSEKMSEncryptionContext",
  #   bucket_key_enabled: false,
  #   request_payer: "requester", # accepts requester
  #   tagging: "TaggingHeader",
  #   object_lock_mode: "GOVERNANCE", # accepts GOVERNANCE, COMPLIANCE
  #   object_lock_retain_until_date: Time.now,
  #   object_lock_legal_hold_status: "ON", # accepts ON, OFF
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::PutObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1161
  def put(options = T.unsafe(nil)); end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#110
  def reload; end

  # @example Request syntax with placeholder values
  #
  #   object_summary.restore_object({
  #   version_id: "ObjectVersionId",
  #   restore_request: {
  #   days: 1,
  #   glacier_job_parameters: {
  #   tier: "Standard", # required, accepts Standard, Bulk, Expedited
  #   },
  #   type: "SELECT", # accepts SELECT
  #   tier: "Standard", # accepts Standard, Bulk, Expedited
  #   description: "Description",
  #   select_parameters: {
  #   input_serialization: { # required
  #   csv: {
  #   file_header_info: "USE", # accepts USE, IGNORE, NONE
  #   comments: "Comments",
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   allow_quoted_record_delimiter: false,
  #   },
  #   compression_type: "NONE", # accepts NONE, GZIP, BZIP2
  #   json: {
  #   type: "DOCUMENT", # accepts DOCUMENT, LINES
  #   },
  #   parquet: {
  #   },
  #   },
  #   expression_type: "SQL", # required, accepts SQL
  #   expression: "Expression", # required
  #   output_serialization: { # required
  #   csv: {
  #   quote_fields: "ALWAYS", # accepts ALWAYS, ASNEEDED
  #   quote_escape_character: "QuoteEscapeCharacter",
  #   record_delimiter: "RecordDelimiter",
  #   field_delimiter: "FieldDelimiter",
  #   quote_character: "QuoteCharacter",
  #   },
  #   json: {
  #   record_delimiter: "RecordDelimiter",
  #   },
  #   },
  #   },
  #   output_location: {
  #   s3: {
  #   bucket_name: "BucketName", # required
  #   prefix: "LocationPrefix", # required
  #   encryption: {
  #   encryption_type: "AES256", # required, accepts AES256, aws:kms
  #   kms_key_id: "SSEKMSKeyId",
  #   kms_context: "KMSContext",
  #   },
  #   canned_acl: "private", # accepts private, public-read, public-read-write, authenticated-read, aws-exec-read, bucket-owner-read, bucket-owner-full-control
  #   access_control_list: [
  #   {
  #   grantee: {
  #   display_name: "DisplayName",
  #   email_address: "EmailAddress",
  #   id: "ID",
  #   type: "CanonicalUser", # required, accepts CanonicalUser, AmazonCustomerByEmail, Group
  #   uri: "URI",
  #   },
  #   permission: "FULL_CONTROL", # accepts FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP
  #   },
  #   ],
  #   tagging: {
  #   tag_set: [ # required
  #   {
  #   key: "ObjectKey", # required
  #   value: "Value", # required
  #   },
  #   ],
  #   },
  #   user_metadata: [
  #   {
  #   name: "MetadataKey",
  #   value: "MetadataValue",
  #   },
  #   ],
  #   storage_class: "STANDARD", # accepts STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR
  #   },
  #   },
  #   },
  #   request_payer: "requester", # accepts requester
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::RestoreObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1294
  def restore_object(options = T.unsafe(nil)); end

  # Size in bytes of the object
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#85
  def size; end

  # The class of storage used to store the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#91
  def storage_class; end

  # @param source [String, Pathname, File, Tempfile] A file on the local
  #   file system that will be uploaded as this object. This can either be
  #   a String or Pathname to the file, an open File object, or an open
  #   Tempfile object. If you pass an open File or Tempfile object, then
  #   you are responsible for closing it after the upload completes. When
  #   using an open Tempfile, rewind it before uploading or else the object
  #   will be empty.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] Returns `true` when the object is uploaded
  #   without any errors.
  # @see Object#upload_file
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#64
  def upload_file(source, options = T.unsafe(nil)); end

  # @return [Boolean] Returns `true` when the object is uploaded
  #   without any errors.
  # @see Object#upload_stream
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/object_summary.rb#71
  def upload_stream(options = T.unsafe(nil), &block); end

  # @param id [String]
  # @return [ObjectVersion]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1344
  def version(id); end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#263
  def wait_until(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [ObjectSummary]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#151
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [ObjectSummary]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#170
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1365
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1376
  def extract_key(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1397
  def separate_params_and_options(options); end

  # @yield [waiter.waiter]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1387
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::ObjectSummary::Collection < ::Aws::Resources::Collection
  # @example Request syntax with placeholder values
  #
  #   object_summary.batch_delete!({
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [{}]
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1470
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_summary.rb#1470
  def deprecated_delete(options = T.unsafe(nil)); end
end

class Aws::S3::ObjectVersion
  extend ::Aws::Deprecations

  # @overload initialize
  # @overload initialize
  # @return [ObjectVersion] a new instance of ObjectVersion
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#26
  def initialize(*args); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#39
  def bucket_name; end

  # The algorithm that was used to create a checksum of the object.
  #
  # @return [Array<String>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#61
  def checksum_algorithm; end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#111
  def client; end

  # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
  # @return [Types::ObjectVersion] Returns the data for this {ObjectVersion}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#126
  def data; end

  # @return [Boolean] Returns `true` if this resource is loaded.  Accessing attributes or
  #   {#data} on an unloaded resource will trigger a call to {#load}.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#134
  def data_loaded?; end

  # @example Request syntax with placeholder values
  #
  #   object_version.delete({
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::DeleteObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#270
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#480
  def deprecated_identifiers; end

  # The entity tag is an MD5 hash of that version of the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#55
  def etag; end

  # @example Request syntax with placeholder values
  #
  #   object_version.get({
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   range: "Range",
  #   response_cache_control: "ResponseCacheControl",
  #   response_content_disposition: "ResponseContentDisposition",
  #   response_content_encoding: "ResponseContentEncoding",
  #   response_content_language: "ResponseContentLanguage",
  #   response_content_type: "ResponseContentType",
  #   response_expires: Time.now,
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::GetObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#375
  def get(options = T.unsafe(nil), &block); end

  # @example Request syntax with placeholder values
  #
  #   object_version.head({
  #   if_match: "IfMatch",
  #   if_modified_since: Time.now,
  #   if_none_match: "IfNoneMatch",
  #   if_unmodified_since: Time.now,
  #   range: "Range",
  #   sse_customer_algorithm: "SSECustomerAlgorithm",
  #   sse_customer_key: "SSECustomerKey",
  #   sse_customer_key_md5: "SSECustomerKeyMD5",
  #   request_payer: "requester", # accepts requester
  #   part_number: 1,
  #   expected_bucket_owner: "AccountId",
  #   checksum_mode: "ENABLED", # accepts ENABLED
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Types::HeadObjectOutput]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#457
  def head(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#49
  def id; end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # Specifies whether the object is (true) or is not (false) the latest
  # version of an object.
  #
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#92
  def is_latest; end

  # The object key.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#79
  def key; end

  # Date and time the object was last modified.
  #
  # @return [Time]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#98
  def last_modified; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#117
  def load; end

  # @return [Object]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#470
  def object; end

  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#44
  def object_key; end

  # Specifies the owner of the object.
  #
  # @return [Types::Owner]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#104
  def owner; end

  # @api private
  # @raise [NotImplementedError]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#117
  def reload; end

  # Size in bytes of the object.
  #
  # @return [Integer]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#67
  def size; end

  # The class of storage used to store the object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#73
  def storage_class; end

  # Version ID of an object.
  #
  # @return [String]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#85
  def version_id; end

  # Waiter polls an API operation until a resource enters a desired
  # state.
  #
  # ## Basic Usage
  #
  # Waiter will polls until it is successful, it fails by
  # entering a terminal state, or until a maximum number of attempts
  # are made.
  #
  #     # polls in a loop until condition is true
  #     resource.wait_until(options) {|resource| condition}
  #
  # ## Example
  #
  #     instance.wait_until(max_attempts:10, delay:5) do |instance|
  #       instance.state.name == 'running'
  #     end
  #
  # ## Configuration
  #
  # You can configure the maximum number of polling attempts, and the
  # delay (in seconds) between each polling attempt. The waiting condition is
  # set by passing a block to {#wait_until}:
  #
  #     # poll for ~25 seconds
  #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
  #
  # ## Callbacks
  #
  # You can be notified before each polling attempt and before each
  # delay. If you throw `:success` or `:failure` from these callbacks,
  # it will terminate the waiter.
  #
  #     started_at = Time.now
  #     # poll for 1 hour, instead of a number of attempts
  #     proc = Proc.new do |attempts, response|
  #       throw :failure if Time.now - started_at > 3600
  #     end
  #
  #       # disable max attempts
  #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
  #
  # ## Handling Errors
  #
  # When a waiter is successful, it returns the Resource. When a waiter
  # fails, it raises an error.
  #
  #     begin
  #       resource.wait_until(...)
  #     rescue Aws::Waiters::Errors::WaiterFailed
  #       # resource did not enter the desired state in time
  #     end
  #
  # attempts
  # attempt in seconds
  # invoked before each attempt
  # invoked before each wait
  #
  # @deprecated Use [Aws::S3::Client] #wait_until instead
  # @note The waiting operation is performed on a copy. The original resource
  #   remains unchanged.
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
  #   terminates because the waiter has entered a state that it will not
  #   transition out of, preventing success.
  #
  #   yet successful.
  # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
  #   encountered while polling for a resource that is not expected.
  # @raise [NotImplementedError] Raised when the resource does not
  # @return [Resource] if the waiter was successful
  # @yieldparam resource [Resource] to be used in the waiting condition.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#218
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#491
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#513
  def extract_id(args, options); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#502
  def extract_object_key(args, options); end
end

class Aws::S3::ObjectVersion::Collection < ::Aws::Resources::Collection
  # @example Request syntax with placeholder values
  #
  #   object_version.batch_delete!({
  #   mfa: "MFA",
  #   request_payer: "requester", # accepts requester
  #   bypass_governance_retention: false,
  #   expected_bucket_owner: "AccountId",
  #   checksum_algorithm: "CRC32", # accepts CRC32, CRC32C, SHA1, SHA256
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [{}]
  # @return [void]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#580
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core/3.168.4/lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/object_version.rb#580
  def deprecated_delete(options = T.unsafe(nil)); end
end

module Aws::S3::Plugins; end

# When an accesspoint ARN is provided for :bucket in S3 operations, this
# plugin resolves the request endpoint from the ARN when possible.
#
# @api private
class Aws::S3::Plugins::ARN < ::Seahorse::Client::Plugin
  class << self
    private

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/arn.rb#52
    def resolve_s3_disable_multiregion_access_points(cfg); end

    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/arn.rb#37
    def resolve_s3_use_arn_region(cfg); end
  end
end

# Provides support for using `Aws::S3::Client` with Amazon S3 Transfer
# Acceleration.
#
# Go here for more information about transfer acceleration:
# [http://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html](http://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html)
class Aws::S3::Plugins::Accelerate < ::Seahorse::Client::Plugin
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/accelerate.rb#22
  def add_handlers(handlers, config); end
end

# @api private
class Aws::S3::Plugins::Accelerate::OptionHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/accelerate.rb#33
  def call(context); end
end

# Amazon S3 requires DNS style addressing for buckets outside of
# the classic region when possible.
class Aws::S3::Plugins::BucketDns < ::Seahorse::Client::Plugin
  class << self
    # @param bucket_name [String]
    # @param ssl [Boolean]
    # @return [Boolean]
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/bucket_dns.rb#33
    def dns_compatible?(bucket_name, ssl); end

    # @param bucket_name [String]
    # @return [Boolean]
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/bucket_dns.rb#43
    def valid_subdomain?(bucket_name); end
  end
end

# @api private
class Aws::S3::Plugins::BucketNameRestrictions < ::Seahorse::Client::Plugin; end

# @api private
class Aws::S3::Plugins::BucketNameRestrictions::Handler < ::Seahorse::Client::Handler
  # Useful because Aws::S3::Errors::SignatureDoesNotMatch is thrown
  # when passed a bucket with a forward slash. Instead provide a more
  # helpful error. Ideally should not be a plugin?
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/bucket_name_restrictions.rb#13
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/bucket_name_restrictions.rb#26
  def _bucket_member(input); end
end

# @api private
class Aws::S3::Plugins::Dualstack < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/dualstack.rb#8
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::S3::Plugins::Dualstack::OptionHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/dualstack.rb#14
  def call(context); end
end

class Aws::S3::Plugins::Endpoints < ::Seahorse::Client::Plugin
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/endpoints.rb#257
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::S3::Plugins::Endpoints::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/endpoints.rb#27
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/endpoints.rb#46
  def apply_endpoint_headers(context, headers); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/endpoints.rb#57
  def parameters_for_operation(context); end
end

class Aws::S3::Plugins::Expect100Continue < ::Seahorse::Client::Plugin
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/expect_100_continue.rb#8
  def add_handlers(handlers, config); end
end

# @api private
class Aws::S3::Plugins::Expect100Continue::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/expect_100_continue.rb#17
  def call(context); end
end

class Aws::S3::Plugins::GetBucketLocationFix < ::Seahorse::Client::Plugin; end

class Aws::S3::Plugins::GetBucketLocationFix::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/get_bucket_location_fix.rb#10
  def call(context); end
end

# A handful of Amazon S3 operations will respond with a 200 status
# code but will send an error in the response body. This plugin
# injects a handler that will parse 200 response bodies for potential
# errors, allowing them to be retried.
#
# @api private
class Aws::S3::Plugins::Http200Errors < ::Seahorse::Client::Plugin; end

# @api private
class Aws::S3::Plugins::Http200Errors::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/http_200_errors.rb#16
  def call(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/http_200_errors.rb#26
  def check_for_error(context); end
end

class Aws::S3::Plugins::IADRegionalEndpoint < ::Seahorse::Client::Plugin
  class << self
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/iad_regional_endpoint.rb#21
    def resolve_iad_regional_endpoint(cfg); end
  end
end

# When making calls to {S3::Client#create_bucket} outside the
# "classic" region, the bucket location constraint must be specified.
# This plugin auto populates the constraint to the configured region.
class Aws::S3::Plugins::LocationConstraint < ::Seahorse::Client::Plugin; end

class Aws::S3::Plugins::LocationConstraint::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/location_constraint.rb#14
  def call(context); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/location_constraint.rb#23
  def populate_location_constraint(params, region); end
end

# This plugin is effectively deprecated in favor of modeled
# httpChecksumRequired traits.
#
# @api private
class Aws::S3::Plugins::Md5s < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#72
  def add_handlers(handlers, config); end
end

# @api private
class Aws::S3::Plugins::Md5s::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#24
  def call(context); end

  private

  # @api private
  # @param value [File, Tempfile, IO#read, String]
  # @return [String<MD5>]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#38
  def md5(value); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#50
  def update_in_chunks(digest, io); end
end

# one MB
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#22
Aws::S3::Plugins::Md5s::Handler::CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# These operations allow Content MD5 but are not required by
# httpChecksumRequired. This list should not grow.
#
# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/plugins/md5s.rb#14
Aws::S3::Plugins::Md5s::OPTIONAL_OPERATIONS = T.let(T.unsafe(nil), Array)

class Aws::S3::Plugins::NonRetryableStreamingError < ::StandardError
  # @return [NonRetryableStreamingError] a new instance of NonRetryableStreamingError
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#41
  def initialize(error); end

  # Returns the value of attribute original_error.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#47
  def original_error; end
end

class Aws::S3::Plugins::Redirects < ::Seahorse::Client::Plugin
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/redirects.rb#35
  def add_handlers(handlers, config); end
end

# @api private
class Aws::S3::Plugins::Redirects::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/redirects.rb#19
  def call(context); end
end

# A wrapper around BlockIO that adds no-ops for truncate and rewind
#
# @api private
class Aws::S3::Plugins::RetryableBlockIO
  extend ::Forwardable

  # @api private
  # @return [RetryableBlockIO] a new instance of RetryableBlockIO
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#15
  def initialize(block_io); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def read(*args, **_arg1, &block); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#21
  def rewind; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def size(*args, **_arg1, &block); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#19
  def truncate(_integer); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def write(*args, **_arg1, &block); end
end

# A wrapper around ManagedFile that adds no-ops for truncate and rewind
#
# @api private
class Aws::S3::Plugins::RetryableManagedFile
  extend ::Forwardable

  # @api private
  # @return [RetryableManagedFile] a new instance of RetryableManagedFile
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#30
  def initialize(managed_file); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def close(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def open?(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def read(*args, **_arg1, &block); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#36
  def rewind; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def size(*args, **_arg1, &block); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#34
  def truncate(_integer); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def write(*args, **_arg1, &block); end
end

# Support S3 host id, more information, see:
# http://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html#sdk-request-ids
#
# This plugin adds :host_id for s3 responses when available
#
# @api private
class Aws::S3::Plugins::S3HostId < ::Seahorse::Client::Plugin; end

# @api private
class Aws::S3::Plugins::S3HostId::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_host_id.rb#16
  def call(context); end
end

# This plugin used to have a V4 signer but it was removed in favor of
# generic Sign plugin that uses endpoint auth scheme.
#
# @api private
class Aws::S3::Plugins::S3Signer < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#15
  def add_handlers(handlers, cfg); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#30
  def add_legacy_handler(handlers); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#25
  def add_v4_handlers(handlers); end

  class << self
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#163
    def new_hostname(context, region); end
  end
end

# This handler detects when a request fails because of a mismatched bucket
# region. It follows up by making a request to determine the correct
# region, then finally a version 4 signed request against the correct
# regional endpoint. This is intended for s3's global endpoint which
# will return 400 if the bucket is not in region.
#
# @api private
class Aws::S3::Plugins::S3Signer::BucketRegionErrorHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#70
  def call(context); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#109
  def custom_endpoint?(resp); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#105
  def expired_credentials?(resp); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#101
  def fips_region?(resp); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#88
  def get_region_and_retry(context); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#77
  def handle_region_errors(response); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#149
  def log_warning(context, actual_region); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#140
  def region_from_body(body); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#124
  def resign_with_new_region(context, actual_region); end

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#97
  def update_bucket_cache(context, actual_region); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#118
  def wrong_sigv4_region?(resp); end
end

# This handler will update the http endpoint when the bucket region
# is known/cached.
#
# @api private
class Aws::S3::Plugins::S3Signer::CachedBucketRegionHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#45
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#53
  def check_for_cached_region(context, bucket); end
end

# @api private
class Aws::S3::Plugins::S3Signer::LegacyHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/s3_signer.rb#36
  def call(context); end
end

# S3 GetObject results for whole Multipart Objects contain a checksum
# that cannot be validated.  These should be skipped by the
# ChecksumAlgorithm plugin.
class Aws::S3::Plugins::SkipWholeMultipartGetChecksums < ::Seahorse::Client::Plugin; end

class Aws::S3::Plugins::SkipWholeMultipartGetChecksums::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/skip_whole_multipart_get_checksums.rb#14
  def call(context); end
end

class Aws::S3::Plugins::SseCpk < ::Seahorse::Client::Plugin; end

class Aws::S3::Plugins::SseCpk::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/sse_cpk.rb#22
  def call(context); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/sse_cpk.rb#59
  def base64(str); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/sse_cpk.rb#29
  def compute_key_md5(context); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/sse_cpk.rb#55
  def md5(str); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/sse_cpk.rb#43
  def require_https(context); end
end

# This handler works with the ResponseTarget plugin to provide smart
# retries of S3 streaming operations that support the range parameter
# (currently only: get_object).  When a 200 OK with a TruncatedBodyError
# is received this handler will add a range header that excludes the
# data that has already been processed (written to file or sent to
# the target Proc).
# It is important to not write data to the custom target in the case of
# a non-success response. We do not want to write an XML error
# message to someone's file or pass it to a user's Proc.
#
# @api private
class Aws::S3::Plugins::StreamingRetry < ::Seahorse::Client::Plugin; end

# @api private
class Aws::S3::Plugins::StreamingRetry::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#64
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#76
  def add_event_listeners(context, target); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#121
  def retryable_body?(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#126
  def supported_target?(target); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/streaming_retry.rb#114
  def truncated_body?(error); end
end

# This plugin auto-populates the `:encoding_type` request parameter
# to all calls made to Amazon S3 that accept it.
#
# This enables Amazon S3 to return object keys that might contain
# invalid XML characters as URL encoded strings.  This plugin also
# automatically decodes these keys so that the key management is
# transparent to the user.
#
# If you specify the `:encoding_type` parameter, then this plugin
# will be disabled, and you will need to decode the keys yourself.
#
# The following operations are managed:
#
# * {S3::Client#list_objects}
# * {S3::Client#list_multipart_uploads}
# * {S3::Client#list_object_versions}
class Aws::S3::Plugins::UrlEncodedKeys < ::Seahorse::Client::Plugin; end

class Aws::S3::Plugins::UrlEncodedKeys::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#31
  def call(context); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#76
  def decode(member, struct); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#67
  def decode_list_multipart_uploads_keys(data); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#57
  def decode_list_object_versions_keys(data); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#48
  def decode_list_objects_keys(data); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/plugins/url_encoded_keys.rb#41
  def manage_keys(context); end
end

# ## Basic Usage
#
# To generate a presigned post, you need AWS credentials, the region
# your bucket is in, and the name of your bucket. You can apply constraints
# to the post object as options to {#initialize} or by calling
# methods such as {#key} and {#content_length_range}.
#
# The following two examples are equivalent.
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket, {
#   key: '/uploaded/object/key',
#   content_length_range: 0..1024,
#   acl: 'public-read',
#   metadata: {
#     'original-filename' => '${filename}'
#   }
# })
# post.fields
# #=> { ... }
#
# post = Aws::S3::PresignedPost.new(creds, region, bucket).
#   key('/uploaded/object/key').
#   content_length_range(0..1024).
#   acl('public-read').
#   metadata('original-filename' => '${filename}').
#   fields
# #=> { ... }
# ```
#
# ## HTML Forms
#
# You can use a {PresignedPost} object to build an HTML form. It is
# recommended to use some helper to build the form tag and input
# tags that properly escapes values.
#
# ### Form Tag
#
# To upload a file to Amazon S3 using a browser, you need to create
# a post form. The {#url} method returns the value you should use
# as the form action.
#
# ```erb
# <form action="<%= @post.url %>" method="post" enctype="multipart/form-data">
#   ...
# </form>
# ```
#
# The follow attributes must be set on the form:
#
# * `action` - This must be the {#url}.
# * `method` - This must be `post`.
# * `enctype` - This must be `multipart/form-data`.
#
# ### Form Fields
#
# The {#fields} method returns a hash of form fields to render inside
# the form. Typically these are rendered as hidden input fields.
#
# ```erb
# <% @post.fields.each do |name, value| %>
#   <input type="hidden" name="<%= name %>" value="<%= value %>"/>
# <% end %>
# ```
#
# Lastly, the form must have a file field with the name `file`.
#
# ```erb
# <input type="file" name="file"/>
# ```
#
# ## Post Policy
#
# When you construct a {PresignedPost}, you must specify every form
# field name that will be posted by the browser. If you omit a form
# field sent by the browser, Amazon S3 will reject the request.
# You can specify accepted form field values three ways:
#
# * Specify exactly what the value must be.
# * Specify what value the field starts with.
# * Specify the field may have any value.
#
# ### Field Equals
#
# You can specify that a form field must be a certain value.
# Simply pass an option like `:content_type` to the constructor,
# or call the associated method.
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket)
# post.content_type('text/plain')
# ```
#
# If any of the given values are changed by the user in the form, then
# Amazon S3 will reject the POST request.
#
# ### Field Starts With
#
# You can specify prefix values for many of the POST form fields.
# To specify a required prefix, use the `:<fieldname>_starts_with`
# option or call the associated `#<field_name>_starts_with` method.
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket, {
#   key_starts_with: '/images/',
#   content_type_starts_with: 'image/',
#   # ...
# })
# ```
#
# When using starts with, the form must contain a field where the
# user can specify the value. The {PresignedPost} will not add
# a value for these fields.
#
# ### Any Field Value
#
# To white-list a form field to send any value, you can name that
# field with `:allow_any` or {#allow_any}.
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket, {
#   key: 'object-key',
#   allow_any: ['Filename'],
#   # ...
# })
# ```
#
# ### Metadata
#
# You can add rules for metadata fields using `:metadata`, {#metadata},
# `:metadata_starts_with` and {#metadata_starts_with}. Unlike other
# form fields, you pass a hash value to these options/methods:
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket).
#   key('/fixed/key').
#   metadata(foo: 'bar')
#
# post.fields['x-amz-meta-foo']
# #=> 'bar'
# ```
#
# ### The `${filename}` Variable
#
# The string `${filename}` is automatically replaced with the name of the
# file provided by the user and is recognized by all form fields. It is
# not supported with `starts_with` conditions.
#
# If the browser or client provides a full or partial path to the file,
# only the text following the last slash (/) or backslash (\) will be used
# (e.g., "C:\Program Files\directory1\file.txt" will be interpreted
# as "file.txt"). If no file or file name is provided, the variable is
# replaced with an empty string.
#
# In the following example, we use `${filename}` to store the original
# filename in the `x-amz-meta-` hash with the uploaded object.
#
# ```ruby
# post = Aws::S3::PresignedPost.new(creds, region, bucket, {
#   key: '/fixed/key',
#   metadata: {
#     'original-filename': '${filename}'
#   }
# })
# ```
#
# @note Normally you do not need to construct a {PresignedPost} yourself.
#   See {Bucket#presigned_post} and {Object#presigned_post}.
class Aws::S3::PresignedPost
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param credentials [Credentials] Security credentials for signing
  #   the post policy.
  # @param bucket_region [String] Region of the target bucket.
  # @param bucket_name [String] Name of the target bucket.
  # @param options [Hash] a customizable set of options
  # @return [PresignedPost] a new instance of PresignedPost
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#243
  def initialize(credentials, bucket_region, bucket_name, options = T.unsafe(nil)); end

  # Specify the cannedl ACL (access control list) for the object.
  # May be one of the following values:
  #
  #   * `private`
  #   * `public-read`
  #   * `public-read-write`
  #   * `authenticated-read`
  #   * `bucket-owner-read`
  #   * `bucket-owner-full-control`
  #
  # @param canned_acl [String]
  # @return [self]
  # @see http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def acl(value); end

  # @param prefix [String]
  # @return [self]
  # @see #acl
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def acl_starts_with(value); end

  # A list of form fields to white-list with any value.
  #
  # @param field_names [Sting, Array<String>]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#286
  def allow_any(*field_names); end

  # Specify caching behavior along the request/reply chain.
  #
  # @param value [String]
  # @return [self]
  # @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def cache_control(value); end

  # @param prefix [String]
  # @return [self]
  # @see #cache_control
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def cache_control_starts_with(value); end

  # Specifies presentational information for the object.
  #
  # @param value [String]
  # @return [self]
  # @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def content_disposition(value); end

  # @param prefix [String]
  # @return [self]
  # @see #content_disposition
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def content_disposition_starts_with(value); end

  # Specifies what content encodings have been applied to the object
  # and thus what decoding mechanisms must be applied to obtain the
  # media-type referenced by the Content-Type header field.
  #
  # @param value [String]
  # @return [self]
  # @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def content_encoding(value); end

  # @param prefix [String]
  # @return [self]
  # @see #content_encoding
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def content_encoding_starts_with(value); end

  # The minimum and maximum allowable size for the uploaded content.
  #
  # @param byte_range [Range<Integer>]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#435
  def content_length_range(byte_range); end

  # A standard MIME type describing the format of the contents.
  #
  # @param value [String]
  # @return [self]
  # @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def content_type(value); end

  # @param prefix [String]
  # @return [self]
  # @see #content_type
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def content_type_starts_with(value); end

  # The date and time at which the object is no longer cacheable.
  #
  # @note This does not affect the expiration of the presigned post
  #   signature.
  # @param time [Time]
  # @return [self]
  # @see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#421
  def expires(time); end

  # @param prefix [String]
  # @return [self]
  # @see #expires
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#428
  def expires_starts_with(prefix); end

  # @return [Hash] A hash of fields to render in an HTML form
  #   as hidden input fields.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#274
  def fields; end

  # The key to use for the uploaded object. You can use `${filename}`
  # as a variable in the key. This will be replaced with the name
  # of the file as provided by the user.
  #
  # For example, if the key is given as `/user/betty/${filename}` and
  # the file uploaded is named `lolcatz.jpg`, the resultant key will
  # be `/user/betty/lolcatz.jpg`.
  #
  # @param key [String]
  # @return [self]
  # @see http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html)
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#329
  def key(key); end

  # Specify a prefix the uploaded
  #
  # @param prefix [String]
  # @return [self]
  # @see #key
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#338
  def key_starts_with(prefix); end

  # Metadata hash to store with the uploaded object. Hash keys will be
  # prefixed with "x-amz-meta-".
  #
  # @param hash [Hash<String,String>]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#514
  def metadata(hash); end

  # Specify allowable prefix for each key in the metadata hash.
  #
  # @param hash [Hash<String,String>]
  # @return [self]
  # @see #metadata
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#525
  def metadata_starts_with(hash); end

  # Specifies a server-side encryption algorithm to use when Amazon
  # S3 creates an object. Valid values include:
  #
  # * `aws:kms`
  # * `AES256`
  #
  # @param value [String]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def server_side_encryption(value); end

  # If {#server_side_encryption} is called with the value of `aws:kms`,
  # this method specifies the ID of the AWS Key Management Service
  # (KMS) master encryption key to use for the object.
  #
  # @param value [String]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def server_side_encryption_aws_kms_key_id(value); end

  # Specifies the algorithm to use to when encrypting the object.
  # Must be set to `AES256` when using customer-provided encryption
  # keys. Must also call {#server_side_encryption_customer_key}.
  #
  # @param value [String]
  # @return [self]
  # @see #server_side_encryption_customer_key
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def server_side_encryption_customer_algorithm(value); end

  # Specifies the customer-provided encryption key for Amazon S3 to use
  # in encrypting data. This value is used to store the object and then
  # it is discarded; Amazon does not store the encryption key.
  #
  # You must also call {#server_side_encryption_customer_algorithm}.
  #
  # @param value [String]
  # @return [self]
  # @see #server_side_encryption_customer_algorithm
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#583
  def server_side_encryption_customer_key(value); end

  # @param prefix [String]
  # @return [self]
  # @see #server_side_encryption_customer_key
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#592
  def server_side_encryption_customer_key_starts_with(prefix); end

  # Storage class to use for storing the object. Defaults to
  # `STANDARD`. Must be one of:
  #
  # * `STANDARD`
  # * `REDUCED_REDUNDANCY`
  #
  # You cannot specify `GLACIER` as the storage class. To transition
  # objects to the GLACIER storage class you can use lifecycle
  # configuration.
  #
  # @param value [String] Storage class to use for storing the
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def storage_class(value); end

  # The URL to which the client is redirected
  # upon successful upload. If {#success_action_redirect} is not
  # specified, Amazon S3 returns the empty document type specified
  # by {#success_action_status}.
  #
  # If Amazon S3 cannot interpret the URL, it acts as if the field
  # is not present.  If the upload fails, Amazon S3 displays an error
  # and does not redirect the user to a URL.
  #
  # @param value [String]
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def success_action_redirect(value); end

  # @param prefix [String]
  # @return [self]
  # @see #success_action_redirect
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#309
  def success_action_redirect_starts_with(value); end

  # The status code returned to the client upon
  # successful upload if {#success_action_redirect} is not
  # specified.
  #
  # Accepts the values `200`, `201`, or `204` (default).
  #
  # If the value is set to 200 or 204, Amazon S3 returns an empty
  # document with a 200 or 204 status code. If the value is set to 201,
  # Amazon S3 returns an XML document with a 201 status code.
  #
  # If the value is not set or if it is set to an invalid value, Amazon
  # S3 returns an empty document with a 204 status code.
  #
  # @param value [String] The status code returned to the client upon
  # @return [self]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def success_action_status(value); end

  # @return [String] The URL to post a file upload to.  This should be
  #   the form action.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#270
  def url; end

  # If the bucket is configured as a website,
  # redirects requests for this object to another object in the
  # same bucket or to an external URL. Amazon S3 stores this value
  # in the object metadata.
  #
  # The value must be prefixed by, "/", "http://" or "https://".
  # The length of the value is limited to 2K.
  #
  # @param value [String]
  # @return [self]
  # @see http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html
  # @see http://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
  # @see http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#303
  def website_redirect_location(value); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#693
  def base64(str); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#631
  def bucket_url; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#623
  def check_required_values!; end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#683
  def credential_scope(datetime); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#679
  def hexhmac(key, value); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#675
  def hmac(key, value); end

  # @return [Hash]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#644
  def policy(datetime); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#666
  def signature(datetime, string_to_sign); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#655
  def signature_fields(datetime); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#618
  def starts_with(field_name, value, &block); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#601
  def with(field_name, value); end

  class << self
    # @api private
    #
    # source://aws-sdk-s3//lib/aws-sdk-s3/presigned_post.rb#295
    def define_field(field, *args, &block); end
  end
end

class Aws::S3::Presigner
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Presigner] a new instance of Presigner
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#35
  def initialize(options = T.unsafe(nil)); end

  # Allows you to create presigned URL requests for S3 operations. This
  # method returns a tuple containing the URL and the signed X-amz-* headers
  # to be used with the presigned url.
  #
  # @example
  #   signer = Aws::S3::Presigner.new
  #   url, headers = signer.presigned_request(
  #   :get_object, bucket: "bucket", key: "key"
  #   )
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param method [Symbol] Symbolized method name of the operation you want
  #   to presign.
  # @param params [Hash] a customizable set of options
  # @raise [ArgumentError] Raises an ArgumentError if `:expires_in`
  #   exceeds one week.
  # @return [String, Hash] A tuple with a presigned URL and headers that
  #   should be included with the request.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#126
  def presigned_request(method, params = T.unsafe(nil)); end

  # Create presigned URLs for S3 operations.
  #
  # @example
  #   signer = Aws::S3::Presigner.new
  #   url = signer.presigned_url(:get_object, bucket: "bucket", key: "key")
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @param method [Symbol] Symbolized method name of the operation you want
  #   to presign.
  # @param params [Hash] a customizable set of options
  # @raise [ArgumentError] Raises an ArgumentError if `:expires_in`
  #   exceeds one week.
  # @return [String] a presigned url
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#77
  def presigned_url(method, params = T.unsafe(nil)); end

  private

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#132
  def _presigned_request(method, params, hoist = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#154
  def expires_in(params); end

  # Used for excluding presigned_urls from API request count.
  #
  # Store context information as early as possible, to allow
  # handlers to perform decisions based on this flag if need.
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#182
  def handle_presigned_url_context(req); end

  # @param req [Seahorse::Client::Request]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#190
  def sign_but_dont_send(req, expires_in, secure, time, unsigned_headers, hoist = T.unsafe(nil)); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#149
  def unsigned_headers(params); end

  # source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#169
  def use_bucket_as_hostname(req); end
end

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#13
Aws::S3::Presigner::BLACKLISTED_HEADERS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#10
Aws::S3::Presigner::FIFTEEN_MINUTES = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-s3//lib/aws-sdk-s3/presigner.rb#7
Aws::S3::Presigner::ONE_WEEK = T.let(T.unsafe(nil), Integer)

# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#8
Aws::S3::REQUIRED_PARAMS = T.let(T.unsafe(nil), Array)

# This class provides a resource oriented interface for S3.
# To create a resource object:
#
#     resource = Aws::S3::Resource.new(region: 'us-west-2')
#
# You can supply a client object with custom configuration that will be used for all resource operations.
# If you do not pass `:client`, a default client will be constructed.
#
#     client = Aws::S3::Client.new(region: 'us-west-2')
#     resource = Aws::S3::Resource.new(client: client)
class Aws::S3::Resource
  # @option options
  # @param options [{}]
  # @return [Resource] a new instance of Resource
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/resource.rb#27
  def initialize(options = T.unsafe(nil)); end

  # @param name [String]
  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/resource.rb#108
  def bucket(name); end

  # @example Request syntax with placeholder values
  #
  #   s3.buckets()
  # @param options [Hash] ({})
  # @return [Bucket::Collection]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/resource.rb#120
  def buckets(options = T.unsafe(nil)); end

  # @return [Client]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/resource.rb#32
  def client; end

  # @example Request syntax with placeholder values
  #
  #   bucket = s3.create_bucket({
  #   acl: "private", # accepts private, public-read, public-read-write, authenticated-read
  #   bucket: "BucketName", # required
  #   create_bucket_configuration: {
  #   location_constraint: "af-south-1", # accepts af-south-1, ap-east-1, ap-northeast-1, ap-northeast-2, ap-northeast-3, ap-south-1, ap-southeast-1, ap-southeast-2, ap-southeast-3, ca-central-1, cn-north-1, cn-northwest-1, EU, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2, eu-west-3, me-south-1, sa-east-1, us-east-2, us-gov-east-1, us-gov-west-1, us-west-1, us-west-2
  #   },
  #   grant_full_control: "GrantFullControl",
  #   grant_read: "GrantRead",
  #   grant_read_acp: "GrantReadACP",
  #   grant_write: "GrantWrite",
  #   grant_write_acp: "GrantWriteACP",
  #   object_lock_enabled_for_bucket: false,
  #   object_ownership: "BucketOwnerPreferred", # accepts BucketOwnerPreferred, ObjectWriter, BucketOwnerEnforced
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] ({})
  # @return [Bucket]
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/resource.rb#96
  def create_bucket(options = T.unsafe(nil)); end
end

# source://aws-sdk-s3//lib/aws-sdk-s3/encryptionV2/client.rb#9
Aws::S3::SUPPORTED_SECURITY_PROFILES = T.let(T.unsafe(nil), Array)

module Aws::S3::Types; end

# Specifies the days since the initiation of an incomplete multipart
# upload that Amazon S3 will wait before permanently removing all parts
# of the upload. For more information, see [ Aborting Incomplete
# Multipart Uploads Using a Bucket Lifecycle Policy][1] in the *Amazon
# S3 User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortIncompleteMultipartUpload AWS API Documentation
class Aws::S3::Types::AbortIncompleteMultipartUpload < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#32
Aws::S3::Types::AbortIncompleteMultipartUpload::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadOutput AWS API Documentation
class Aws::S3::Types::AbortMultipartUploadOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#45
Aws::S3::Types::AbortMultipartUploadOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadRequest AWS API Documentation
class Aws::S3::Types::AbortMultipartUploadRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#110
Aws::S3::Types::AbortMultipartUploadRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Configures the transfer acceleration state for an Amazon S3 bucket.
# For more information, see [Amazon S3 Transfer Acceleration][1] in the
# *Amazon S3 User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccelerateConfiguration AWS API Documentation
class Aws::S3::Types::AccelerateConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#130
Aws::S3::Types::AccelerateConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the elements that set the ACL permissions for an object per
# grantee.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlPolicy AWS API Documentation
class Aws::S3::Types::AccessControlPolicy < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#150
Aws::S3::Types::AccessControlPolicy::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for information about access control for replicas.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlTranslation AWS API Documentation
class Aws::S3::Types::AccessControlTranslation < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#169
Aws::S3::Types::AccessControlTranslation::SENSITIVE = T.let(T.unsafe(nil), Array)

# A conjunction (logical AND) of predicates, which is used in evaluating
# a metrics filter. The operator must have at least two predicates in
# any combination, and an object must match all of the predicates for
# the filter to apply.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsAndOperator AWS API Documentation
class Aws::S3::Types::AnalyticsAndOperator < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#192
Aws::S3::Types::AnalyticsAndOperator::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the configuration and any analyses for the analytics filter
# of an Amazon S3 bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsConfiguration AWS API Documentation
class Aws::S3::Types::AnalyticsConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#222
Aws::S3::Types::AnalyticsConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Where to publish the analytics results.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsExportDestination AWS API Documentation
class Aws::S3::Types::AnalyticsExportDestination < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#236
Aws::S3::Types::AnalyticsExportDestination::SENSITIVE = T.let(T.unsafe(nil), Array)

# The filter used to describe a set of objects for analyses. A filter
# must have exactly one prefix, one tag, or one conjunction
# (AnalyticsAndOperator). If no filter is provided, all objects will be
# considered in any analysis.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsFilter AWS API Documentation
class Aws::S3::Types::AnalyticsFilter < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#265
Aws::S3::Types::AnalyticsFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains information about where to publish the analytics results.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsS3BucketDestination AWS API Documentation
class Aws::S3::Types::AnalyticsS3BucketDestination < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#303
Aws::S3::Types::AnalyticsS3BucketDestination::SENSITIVE = T.let(T.unsafe(nil), Array)

# In terms of implementation, a Bucket is a resource. An Amazon S3
# bucket name is globally unique, and the namespace is shared by all
# Amazon Web Services accounts.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Bucket AWS API Documentation
class Aws::S3::Types::Bucket < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#325
Aws::S3::Types::Bucket::SENSITIVE = T.let(T.unsafe(nil), Array)

# The requested bucket name is not available. The bucket namespace is
# shared by all users of the system. Select a different name and try
# again.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketAlreadyExists AWS API Documentation
class Aws::S3::Types::BucketAlreadyExists < ::Aws::EmptyStructure; end

# The bucket you tried to create already exists, and you own it. Amazon
# S3 returns this error in all Amazon Web Services Regions except in the
# North Virginia Region. For legacy compatibility, if you re-create an
# existing bucket that you already own in the North Virginia Region,
# Amazon S3 returns 200 OK and resets the bucket access control lists
# (ACLs).
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketAlreadyOwnedByYou AWS API Documentation
class Aws::S3::Types::BucketAlreadyOwnedByYou < ::Aws::EmptyStructure; end

# Specifies the lifecycle configuration for objects in an Amazon S3
# bucket. For more information, see [Object Lifecycle Management][1] in
# the *Amazon S3 User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLifecycleConfiguration AWS API Documentation
class Aws::S3::Types::BucketLifecycleConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#364
Aws::S3::Types::BucketLifecycleConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for logging status information.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLoggingStatus AWS API Documentation
class Aws::S3::Types::BucketLoggingStatus < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#384
Aws::S3::Types::BucketLoggingStatus::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes the cross-origin access configuration for objects in an
# Amazon S3 bucket. For more information, see [Enabling Cross-Origin
# Resource Sharing][1] in the *Amazon S3 User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSConfiguration AWS API Documentation
class Aws::S3::Types::CORSConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#405
Aws::S3::Types::CORSConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies a cross-origin access rule for an Amazon S3 bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSRule AWS API Documentation
class Aws::S3::Types::CORSRule < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#453
Aws::S3::Types::CORSRule::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes how an uncompressed comma-separated values (CSV)-formatted
# input object is formatted.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVInput AWS API Documentation
class Aws::S3::Types::CSVInput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#526
Aws::S3::Types::CSVInput::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes how uncompressed comma-separated values (CSV)-formatted
# results are formatted.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVOutput AWS API Documentation
class Aws::S3::Types::CSVOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#571
Aws::S3::Types::CSVOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains all the possible checksum or digest values for an object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Checksum AWS API Documentation
class Aws::S3::Types::Checksum < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#636
Aws::S3::Types::Checksum::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for specifying the Lambda notification configuration.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CloudFunctionConfiguration AWS API Documentation
class Aws::S3::Types::CloudFunctionConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#673
Aws::S3::Types::CloudFunctionConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for all (if there are any) keys between Prefix and the next
# occurrence of the string specified by a delimiter. CommonPrefixes
# lists keys that act like subdirectories in the directory specified by
# Prefix. For example, if the prefix is notes/ and the delimiter is a
# slash (/) as in notes/summer/july, the common prefix is notes/summer/.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CommonPrefix AWS API Documentation
class Aws::S3::Types::CommonPrefix < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#691
Aws::S3::Types::CommonPrefix::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadOutput AWS API Documentation
class Aws::S3::Types::CompleteMultipartUploadOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#851
Aws::S3::Types::CompleteMultipartUploadOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadRequest AWS API Documentation
class Aws::S3::Types::CompleteMultipartUploadRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1009
Aws::S3::Types::CompleteMultipartUploadRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The container for the completed multipart upload details.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedMultipartUpload AWS API Documentation
class Aws::S3::Types::CompletedMultipartUpload < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1026
Aws::S3::Types::CompletedMultipartUpload::SENSITIVE = T.let(T.unsafe(nil), Array)

# Details of the parts that were uploaded.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedPart AWS API Documentation
class Aws::S3::Types::CompletedPart < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1102
Aws::S3::Types::CompletedPart::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for describing a condition that must be met for the
# specified redirect to apply. For example, 1. If request is for pages
# in the `/docs` folder, redirect to the `/documents` folder. 2. If
# request results in HTTP error 4xx, redirect request to another host
# where you might process the error.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Condition AWS API Documentation
class Aws::S3::Types::Condition < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1145
Aws::S3::Types::Condition::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ContinuationEvent AWS API Documentation
class Aws::S3::Types::ContinuationEvent < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1153
Aws::S3::Types::ContinuationEvent::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectOutput AWS API Documentation
class Aws::S3::Types::CopyObjectOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1229
Aws::S3::Types::CopyObjectOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectRequest AWS API Documentation
class Aws::S3::Types::CopyObjectRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1592
Aws::S3::Types::CopyObjectRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for all response elements.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectResult AWS API Documentation
class Aws::S3::Types::CopyObjectResult < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1668
Aws::S3::Types::CopyObjectResult::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for all response elements.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyPartResult AWS API Documentation
class Aws::S3::Types::CopyPartResult < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1743
Aws::S3::Types::CopyPartResult::SENSITIVE = T.let(T.unsafe(nil), Array)

# The configuration information for the bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketConfiguration AWS API Documentation
class Aws::S3::Types::CreateBucketConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1759
Aws::S3::Types::CreateBucketConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketOutput AWS API Documentation
class Aws::S3::Types::CreateBucketOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1771
Aws::S3::Types::CreateBucketOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketRequest AWS API Documentation
class Aws::S3::Types::CreateBucketRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1848
Aws::S3::Types::CreateBucketRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadOutput AWS API Documentation
class Aws::S3::Types::CreateMultipartUploadOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#1973
Aws::S3::Types::CreateMultipartUploadOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadRequest AWS API Documentation
class Aws::S3::Types::CreateMultipartUploadRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2224
Aws::S3::Types::CreateMultipartUploadRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The container element for specifying the default Object Lock retention
# settings for new objects placed in the specified bucket.
#
# <note markdown="1"> * The `DefaultRetention` settings require both a mode and a period.
#
# * The `DefaultRetention` period can be either `Days` or `Years` but
#   you must select one. You cannot specify `Days` and `Years` at the
#   same time.
#
#  </note>
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DefaultRetention AWS API Documentation
class Aws::S3::Types::DefaultRetention < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2261
Aws::S3::Types::DefaultRetention::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the objects to delete.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Delete AWS API Documentation
class Aws::S3::Types::Delete < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2281
Aws::S3::Types::Delete::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfigurationRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketAnalyticsConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2306
Aws::S3::Types::DeleteBucketAnalyticsConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCorsRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketCorsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2325
Aws::S3::Types::DeleteBucketCorsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryptionRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketEncryptionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2345
Aws::S3::Types::DeleteBucketEncryptionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketIntelligentTieringConfigurationRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketIntelligentTieringConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2363
Aws::S3::Types::DeleteBucketIntelligentTieringConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfigurationRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketInventoryConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2388
Aws::S3::Types::DeleteBucketInventoryConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketLifecycleRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2407
Aws::S3::Types::DeleteBucketLifecycleRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfigurationRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketMetricsConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2432
Aws::S3::Types::DeleteBucketMetricsConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOwnershipControlsRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketOwnershipControlsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2451
Aws::S3::Types::DeleteBucketOwnershipControlsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicyRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketPolicyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2470
Aws::S3::Types::DeleteBucketPolicyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplicationRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketReplicationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2489
Aws::S3::Types::DeleteBucketReplicationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2508
Aws::S3::Types::DeleteBucketRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTaggingRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketTaggingRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2527
Aws::S3::Types::DeleteBucketTaggingRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsiteRequest AWS API Documentation
class Aws::S3::Types::DeleteBucketWebsiteRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2547
Aws::S3::Types::DeleteBucketWebsiteRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Information about the delete marker.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerEntry AWS API Documentation
class Aws::S3::Types::DeleteMarkerEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2582
Aws::S3::Types::DeleteMarkerEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies whether Amazon S3 replicates delete markers. If you specify
# a `Filter` in your replication configuration, you must also include a
# `DeleteMarkerReplication` element. If your `Filter` includes a `Tag`
# element, the `DeleteMarkerReplication` `Status` must be set to
# Disabled, because Amazon S3 does not support replicating delete
# markers for tag-based rules. For an example configuration, see [Basic
# Rule Configuration][1].
#
# For more information about delete marker replication, see [Basic Rule
# Configuration][2].
#
# <note markdown="1"> If you are using an earlier version of the replication configuration,
# Amazon S3 handles replication of delete markers differently. For more
# information, see [Backward Compatibility][3].
#
#  </note>
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config
# [2]: https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html
# [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerReplication AWS API Documentation
class Aws::S3::Types::DeleteMarkerReplication < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2621
Aws::S3::Types::DeleteMarkerReplication::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectOutput AWS API Documentation
class Aws::S3::Types::DeleteObjectOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2646
Aws::S3::Types::DeleteObjectOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectRequest AWS API Documentation
class Aws::S3::Types::DeleteObjectRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2726
Aws::S3::Types::DeleteObjectRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingOutput AWS API Documentation
class Aws::S3::Types::DeleteObjectTaggingOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2738
Aws::S3::Types::DeleteObjectTaggingOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingRequest AWS API Documentation
class Aws::S3::Types::DeleteObjectTaggingRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2792
Aws::S3::Types::DeleteObjectTaggingRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsOutput AWS API Documentation
class Aws::S3::Types::DeleteObjectsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2817
Aws::S3::Types::DeleteObjectsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsRequest AWS API Documentation
class Aws::S3::Types::DeleteObjectsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2913
Aws::S3::Types::DeleteObjectsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlockRequest AWS API Documentation
class Aws::S3::Types::DeletePublicAccessBlockRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2933
Aws::S3::Types::DeletePublicAccessBlockRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Information about the deleted object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletedObject AWS API Documentation
class Aws::S3::Types::DeletedObject < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#2968
Aws::S3::Types::DeletedObject::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies information about where to publish analysis or configuration
# results for an Amazon S3 bucket and S3 Replication Time Control (S3
# RTC).
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Destination AWS API Documentation
class Aws::S3::Types::Destination < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3045
Aws::S3::Types::Destination::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the type of server-side encryption used.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Encryption AWS API Documentation
class Aws::S3::Types::Encryption < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3079
Aws::S3::Types::Encryption::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies encryption-related information for an Amazon S3 bucket that
# is a destination for replicated objects.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EncryptionConfiguration AWS API Documentation
class Aws::S3::Types::EncryptionConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3104
Aws::S3::Types::EncryptionConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# A message that indicates the request is complete and no more messages
# will be sent. You should not assume that the request is complete until
# the client receives an `EndEvent`.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EndEvent AWS API Documentation
class Aws::S3::Types::EndEvent < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3116
Aws::S3::Types::EndEvent::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for all error elements.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Error AWS API Documentation
class Aws::S3::Types::Error < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3952
Aws::S3::Types::Error::SENSITIVE = T.let(T.unsafe(nil), Array)

# The error information.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ErrorDocument AWS API Documentation
class Aws::S3::Types::ErrorDocument < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3974
Aws::S3::Types::ErrorDocument::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for specifying the configuration for Amazon EventBridge.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EventBridgeConfiguration AWS API Documentation
class Aws::S3::Types::EventBridgeConfiguration < ::Aws::EmptyStructure; end

# Optional configuration to replicate existing source bucket objects.
# For more information, see [Replicating Existing Objects][1] in the
# *Amazon S3 User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ExistingObjectReplication AWS API Documentation
class Aws::S3::Types::ExistingObjectReplication < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#3999
Aws::S3::Types::ExistingObjectReplication::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the Amazon S3 object key name to filter on and whether to
# filter on the suffix or prefix of the key name.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/FilterRule AWS API Documentation
class Aws::S3::Types::FilterRule < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4027
Aws::S3::Types::FilterRule::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketAccelerateConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4039
Aws::S3::Types::GetBucketAccelerateConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketAccelerateConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4059
Aws::S3::Types::GetBucketAccelerateConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclOutput AWS API Documentation
class Aws::S3::Types::GetBucketAclOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4076
Aws::S3::Types::GetBucketAclOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclRequest AWS API Documentation
class Aws::S3::Types::GetBucketAclRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4095
Aws::S3::Types::GetBucketAclRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketAnalyticsConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4107
Aws::S3::Types::GetBucketAnalyticsConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketAnalyticsConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4132
Aws::S3::Types::GetBucketAnalyticsConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsOutput AWS API Documentation
class Aws::S3::Types::GetBucketCorsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4145
Aws::S3::Types::GetBucketCorsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsRequest AWS API Documentation
class Aws::S3::Types::GetBucketCorsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4164
Aws::S3::Types::GetBucketCorsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionOutput AWS API Documentation
class Aws::S3::Types::GetBucketEncryptionOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4176
Aws::S3::Types::GetBucketEncryptionOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionRequest AWS API Documentation
class Aws::S3::Types::GetBucketEncryptionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4196
Aws::S3::Types::GetBucketEncryptionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketIntelligentTieringConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketIntelligentTieringConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4208
Aws::S3::Types::GetBucketIntelligentTieringConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketIntelligentTieringConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketIntelligentTieringConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4226
Aws::S3::Types::GetBucketIntelligentTieringConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketInventoryConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4238
Aws::S3::Types::GetBucketInventoryConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketInventoryConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4263
Aws::S3::Types::GetBucketInventoryConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketLifecycleConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4275
Aws::S3::Types::GetBucketLifecycleConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketLifecycleConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4294
Aws::S3::Types::GetBucketLifecycleConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleOutput AWS API Documentation
class Aws::S3::Types::GetBucketLifecycleOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4306
Aws::S3::Types::GetBucketLifecycleOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleRequest AWS API Documentation
class Aws::S3::Types::GetBucketLifecycleRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4325
Aws::S3::Types::GetBucketLifecycleRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationOutput AWS API Documentation
class Aws::S3::Types::GetBucketLocationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4344
Aws::S3::Types::GetBucketLocationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationRequest AWS API Documentation
class Aws::S3::Types::GetBucketLocationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4363
Aws::S3::Types::GetBucketLocationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingOutput AWS API Documentation
class Aws::S3::Types::GetBucketLoggingOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4381
Aws::S3::Types::GetBucketLoggingOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingRequest AWS API Documentation
class Aws::S3::Types::GetBucketLoggingRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4400
Aws::S3::Types::GetBucketLoggingRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetBucketMetricsConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4412
Aws::S3::Types::GetBucketMetricsConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketMetricsConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4437
Aws::S3::Types::GetBucketMetricsConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetBucketNotificationConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4457
Aws::S3::Types::GetBucketNotificationConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketOwnershipControlsOutput AWS API Documentation
class Aws::S3::Types::GetBucketOwnershipControlsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4470
Aws::S3::Types::GetBucketOwnershipControlsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketOwnershipControlsRequest AWS API Documentation
class Aws::S3::Types::GetBucketOwnershipControlsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4490
Aws::S3::Types::GetBucketOwnershipControlsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyOutput AWS API Documentation
class Aws::S3::Types::GetBucketPolicyOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4502
Aws::S3::Types::GetBucketPolicyOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyRequest AWS API Documentation
class Aws::S3::Types::GetBucketPolicyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4521
Aws::S3::Types::GetBucketPolicyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyStatusOutput AWS API Documentation
class Aws::S3::Types::GetBucketPolicyStatusOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4533
Aws::S3::Types::GetBucketPolicyStatusOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyStatusRequest AWS API Documentation
class Aws::S3::Types::GetBucketPolicyStatusRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4553
Aws::S3::Types::GetBucketPolicyStatusRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationOutput AWS API Documentation
class Aws::S3::Types::GetBucketReplicationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4566
Aws::S3::Types::GetBucketReplicationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationRequest AWS API Documentation
class Aws::S3::Types::GetBucketReplicationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4585
Aws::S3::Types::GetBucketReplicationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentOutput AWS API Documentation
class Aws::S3::Types::GetBucketRequestPaymentOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4597
Aws::S3::Types::GetBucketRequestPaymentOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentRequest AWS API Documentation
class Aws::S3::Types::GetBucketRequestPaymentRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4617
Aws::S3::Types::GetBucketRequestPaymentRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingOutput AWS API Documentation
class Aws::S3::Types::GetBucketTaggingOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4629
Aws::S3::Types::GetBucketTaggingOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingRequest AWS API Documentation
class Aws::S3::Types::GetBucketTaggingRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4648
Aws::S3::Types::GetBucketTaggingRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningOutput AWS API Documentation
class Aws::S3::Types::GetBucketVersioningOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4668
Aws::S3::Types::GetBucketVersioningOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningRequest AWS API Documentation
class Aws::S3::Types::GetBucketVersioningRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4687
Aws::S3::Types::GetBucketVersioningRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteOutput AWS API Documentation
class Aws::S3::Types::GetBucketWebsiteOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4718
Aws::S3::Types::GetBucketWebsiteOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteRequest AWS API Documentation
class Aws::S3::Types::GetBucketWebsiteRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4737
Aws::S3::Types::GetBucketWebsiteRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclOutput AWS API Documentation
class Aws::S3::Types::GetObjectAclOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4760
Aws::S3::Types::GetObjectAclOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclRequest AWS API Documentation
class Aws::S3::Types::GetObjectAclRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4816
Aws::S3::Types::GetObjectAclRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributesOutput AWS API Documentation
class Aws::S3::Types::GetObjectAttributesOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4880
Aws::S3::Types::GetObjectAttributesOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# A collection of parts associated with a multipart upload.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributesParts AWS API Documentation
class Aws::S3::Types::GetObjectAttributesParts < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#4925
Aws::S3::Types::GetObjectAttributesParts::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributesRequest AWS API Documentation
class Aws::S3::Types::GetObjectAttributesRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5030
Aws::S3::Types::GetObjectAttributesRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLegalHoldOutput AWS API Documentation
class Aws::S3::Types::GetObjectLegalHoldOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5042
Aws::S3::Types::GetObjectLegalHoldOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLegalHoldRequest AWS API Documentation
class Aws::S3::Types::GetObjectLegalHoldRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5100
Aws::S3::Types::GetObjectLegalHoldRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLockConfigurationOutput AWS API Documentation
class Aws::S3::Types::GetObjectLockConfigurationOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5112
Aws::S3::Types::GetObjectLockConfigurationOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLockConfigurationRequest AWS API Documentation
class Aws::S3::Types::GetObjectLockConfigurationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5144
Aws::S3::Types::GetObjectLockConfigurationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectOutput AWS API Documentation
class Aws::S3::Types::GetObjectOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5404
Aws::S3::Types::GetObjectOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRequest AWS API Documentation
class Aws::S3::Types::GetObjectRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5577
Aws::S3::Types::GetObjectRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRetentionOutput AWS API Documentation
class Aws::S3::Types::GetObjectRetentionOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5589
Aws::S3::Types::GetObjectRetentionOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRetentionRequest AWS API Documentation
class Aws::S3::Types::GetObjectRetentionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5647
Aws::S3::Types::GetObjectRetentionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingOutput AWS API Documentation
class Aws::S3::Types::GetObjectTaggingOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5665
Aws::S3::Types::GetObjectTaggingOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingRequest AWS API Documentation
class Aws::S3::Types::GetObjectTaggingRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5732
Aws::S3::Types::GetObjectTaggingRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentOutput AWS API Documentation
class Aws::S3::Types::GetObjectTorrentOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5750
Aws::S3::Types::GetObjectTorrentOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentRequest AWS API Documentation
class Aws::S3::Types::GetObjectTorrentRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5788
Aws::S3::Types::GetObjectTorrentRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlockOutput AWS API Documentation
class Aws::S3::Types::GetPublicAccessBlockOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5801
Aws::S3::Types::GetPublicAccessBlockOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlockRequest AWS API Documentation
class Aws::S3::Types::GetPublicAccessBlockRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5821
Aws::S3::Types::GetPublicAccessBlockRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for S3 Glacier job parameters.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GlacierJobParameters AWS API Documentation
class Aws::S3::Types::GlacierJobParameters < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5835
Aws::S3::Types::GlacierJobParameters::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for grant information.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grant AWS API Documentation
class Aws::S3::Types::Grant < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5854
Aws::S3::Types::Grant::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the person being granted permissions.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grantee AWS API Documentation
class Aws::S3::Types::Grantee < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5917
Aws::S3::Types::Grantee::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucketRequest AWS API Documentation
class Aws::S3::Types::HeadBucketRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#5959
Aws::S3::Types::HeadBucketRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectOutput AWS API Documentation
class Aws::S3::Types::HeadObjectOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6292
Aws::S3::Types::HeadObjectOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectRequest AWS API Documentation
class Aws::S3::Types::HeadObjectRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6427
Aws::S3::Types::HeadObjectRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the `Suffix` element.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IndexDocument AWS API Documentation
class Aws::S3::Types::IndexDocument < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6453
Aws::S3::Types::IndexDocument::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container element that identifies who initiated the multipart upload.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Initiator AWS API Documentation
class Aws::S3::Types::Initiator < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6474
Aws::S3::Types::Initiator::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes the serialization format of the object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InputSerialization AWS API Documentation
class Aws::S3::Types::InputSerialization < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6504
Aws::S3::Types::InputSerialization::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for specifying S3 Intelligent-Tiering filters. The filters
# determine the subset of objects to which the rule applies.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IntelligentTieringAndOperator AWS API Documentation
class Aws::S3::Types::IntelligentTieringAndOperator < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6526
Aws::S3::Types::IntelligentTieringAndOperator::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the S3 Intelligent-Tiering configuration for an Amazon S3
# bucket.
#
# For information about the S3 Intelligent-Tiering storage class, see
# [Storage class for automatically optimizing frequently and
# infrequently accessed objects][1].
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IntelligentTieringConfiguration AWS API Documentation
class Aws::S3::Types::IntelligentTieringConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6566
Aws::S3::Types::IntelligentTieringConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# The `Filter` is used to identify objects that the S3
# Intelligent-Tiering configuration applies to.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IntelligentTieringFilter AWS API Documentation
class Aws::S3::Types::IntelligentTieringFilter < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6603
Aws::S3::Types::IntelligentTieringFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# Object is archived and inaccessible until restored.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InvalidObjectState AWS API Documentation
class Aws::S3::Types::InvalidObjectState < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6620
Aws::S3::Types::InvalidObjectState::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the inventory configuration for an Amazon S3 bucket. For
# more information, see [GET Bucket inventory][1] in the *Amazon S3 API
# Reference*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryConfiguration AWS API Documentation
class Aws::S3::Types::InventoryConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6678
Aws::S3::Types::InventoryConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the inventory configuration for an Amazon S3 bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryDestination AWS API Documentation
class Aws::S3::Types::InventoryDestination < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6693
Aws::S3::Types::InventoryDestination::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the type of server-side encryption used to encrypt the
# inventory results.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryEncryption AWS API Documentation
class Aws::S3::Types::InventoryEncryption < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6713
Aws::S3::Types::InventoryEncryption::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies an inventory filter. The inventory only includes objects
# that meet the filter's criteria.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryFilter AWS API Documentation
class Aws::S3::Types::InventoryFilter < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6729
Aws::S3::Types::InventoryFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the bucket name, file format, bucket owner (optional), and
# prefix (optional) where inventory results are published.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryS3BucketDestination AWS API Documentation
class Aws::S3::Types::InventoryS3BucketDestination < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6773
Aws::S3::Types::InventoryS3BucketDestination::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies the schedule for generating inventory results.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventorySchedule AWS API Documentation
class Aws::S3::Types::InventorySchedule < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6787
Aws::S3::Types::InventorySchedule::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies JSON as object's input serialization format.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONInput AWS API Documentation
class Aws::S3::Types::JSONInput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6801
Aws::S3::Types::JSONInput::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies JSON as request's output serialization format.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/JSONOutput AWS API Documentation
class Aws::S3::Types::JSONOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6816
Aws::S3::Types::JSONOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for specifying the configuration for Lambda notifications.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LambdaFunctionConfiguration AWS API Documentation
class Aws::S3::Types::LambdaFunctionConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6860
Aws::S3::Types::LambdaFunctionConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for lifecycle rules. You can add as many as 1000 rules.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleConfiguration AWS API Documentation
class Aws::S3::Types::LifecycleConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6874
Aws::S3::Types::LifecycleConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the expiration for the lifecycle of the object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleExpiration AWS API Documentation
class Aws::S3::Types::LifecycleExpiration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6903
Aws::S3::Types::LifecycleExpiration::SENSITIVE = T.let(T.unsafe(nil), Array)

# A lifecycle rule for individual objects in an Amazon S3 bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRule AWS API Documentation
class Aws::S3::Types::LifecycleRule < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#6991
Aws::S3::Types::LifecycleRule::SENSITIVE = T.let(T.unsafe(nil), Array)

# This is used in a Lifecycle Rule Filter to apply a logical AND to two
# or more predicates. The Lifecycle Rule will apply to any object
# matching all of the predicates configured inside the And operator.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleAndOperator AWS API Documentation
class Aws::S3::Types::LifecycleRuleAndOperator < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7023
Aws::S3::Types::LifecycleRuleAndOperator::SENSITIVE = T.let(T.unsafe(nil), Array)

# The `Filter` is used to identify objects that a Lifecycle Rule applies
# to. A `Filter` must have exactly one of `Prefix`, `Tag`, or `And`
# specified.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleFilter AWS API Documentation
class Aws::S3::Types::LifecycleRuleFilter < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7070
Aws::S3::Types::LifecycleRuleFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsOutput AWS API Documentation
class Aws::S3::Types::ListBucketAnalyticsConfigurationsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7105
Aws::S3::Types::ListBucketAnalyticsConfigurationsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsRequest AWS API Documentation
class Aws::S3::Types::ListBucketAnalyticsConfigurationsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7131
Aws::S3::Types::ListBucketAnalyticsConfigurationsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketIntelligentTieringConfigurationsOutput AWS API Documentation
class Aws::S3::Types::ListBucketIntelligentTieringConfigurationsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7165
Aws::S3::Types::ListBucketIntelligentTieringConfigurationsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketIntelligentTieringConfigurationsRequest AWS API Documentation
class Aws::S3::Types::ListBucketIntelligentTieringConfigurationsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7184
Aws::S3::Types::ListBucketIntelligentTieringConfigurationsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsOutput AWS API Documentation
class Aws::S3::Types::ListBucketInventoryConfigurationsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7217
Aws::S3::Types::ListBucketInventoryConfigurationsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsRequest AWS API Documentation
class Aws::S3::Types::ListBucketInventoryConfigurationsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7245
Aws::S3::Types::ListBucketInventoryConfigurationsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsOutput AWS API Documentation
class Aws::S3::Types::ListBucketMetricsConfigurationsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7280
Aws::S3::Types::ListBucketMetricsConfigurationsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsRequest AWS API Documentation
class Aws::S3::Types::ListBucketMetricsConfigurationsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7308
Aws::S3::Types::ListBucketMetricsConfigurationsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsOutput AWS API Documentation
class Aws::S3::Types::ListBucketsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7325
Aws::S3::Types::ListBucketsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsOutput AWS API Documentation
class Aws::S3::Types::ListMultipartUploadsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7416
Aws::S3::Types::ListMultipartUploadsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsRequest AWS API Documentation
class Aws::S3::Types::ListMultipartUploadsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7521
Aws::S3::Types::ListMultipartUploadsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsOutput AWS API Documentation
class Aws::S3::Types::ListObjectVersionsOutput < ::Struct
  include ::Aws::Structure

  # TODO : Remove this customization once the resource code
  #        generator correct handles the JMESPath || expression.
  #        Only used by the Bucket#object_versions collection.
  #
  # @api private
  #
  # source://aws-sdk-s3//lib/aws-sdk-s3/customizations/types/list_object_versions_output.rb#9
  def versions_delete_markers; end
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7617
Aws::S3::Types::ListObjectVersionsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsRequest AWS API Documentation
class Aws::S3::Types::ListObjectVersionsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7687
Aws::S3::Types::ListObjectVersionsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsOutput AWS API Documentation
class Aws::S3::Types::ListObjectsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7773
Aws::S3::Types::ListObjectsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsRequest AWS API Documentation
class Aws::S3::Types::ListObjectsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7856
Aws::S3::Types::ListObjectsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Output AWS API Documentation
class Aws::S3::Types::ListObjectsV2Output < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#7985
Aws::S3::Types::ListObjectsV2Output::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Request AWS API Documentation
class Aws::S3::Types::ListObjectsV2Request < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8078
Aws::S3::Types::ListObjectsV2Request::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsOutput AWS API Documentation
class Aws::S3::Types::ListPartsOutput < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8194
Aws::S3::Types::ListPartsOutput::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsRequest AWS API Documentation
class Aws::S3::Types::ListPartsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8307
Aws::S3::Types::ListPartsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes where logs are stored and the prefix that Amazon S3 assigns
# to all log object keys for a bucket. For more information, see [PUT
# Bucket logging][1] in the *Amazon S3 API Reference*.
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LoggingEnabled AWS API Documentation
class Aws::S3::Types::LoggingEnabled < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8354
Aws::S3::Types::LoggingEnabled::SENSITIVE = T.let(T.unsafe(nil), Array)

# A metadata key-value pair to store with an object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetadataEntry AWS API Documentation
class Aws::S3::Types::MetadataEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8373
Aws::S3::Types::MetadataEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container specifying replication metrics-related settings enabling
# replication metrics and events.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Metrics AWS API Documentation
class Aws::S3::Types::Metrics < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8394
Aws::S3::Types::Metrics::SENSITIVE = T.let(T.unsafe(nil), Array)

# A conjunction (logical AND) of predicates, which is used in evaluating
# a metrics filter. The operator must have at least two predicates, and
# an object must match all of the predicates in order for the filter to
# apply.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsAndOperator AWS API Documentation
class Aws::S3::Types::MetricsAndOperator < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8421
Aws::S3::Types::MetricsAndOperator::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies a metrics configuration for the CloudWatch request metrics
# (specified by the metrics configuration ID) from an Amazon S3 bucket.
# If you're updating an existing metrics configuration, note that this
# is a full replacement of the existing metrics configuration. If you
# don't include the elements you want to keep, they are erased. For
# more information, see [PutBucketMetricsConfiguration][1].
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsConfiguration AWS API Documentation
class Aws::S3::Types::MetricsConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8452
Aws::S3::Types::MetricsConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Specifies a metrics configuration filter. The metrics configuration
# only includes objects that meet the filter's criteria. A filter must
# be a prefix, an object tag, an access point ARN, or a conjunction
# (MetricsAndOperator). For more information, see
# [PutBucketMetricsConfiguration][1].
#
#
#
# [1]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsFilter AWS API Documentation
class Aws::S3::Types::MetricsFilter < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8492
Aws::S3::Types::MetricsFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the `MultipartUpload` for the Amazon S3 object.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MultipartUpload AWS API Documentation
class Aws::S3::Types::MultipartUpload < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8537
Aws::S3::Types::MultipartUpload::SENSITIVE = T.let(T.unsafe(nil), Array)

# The specified bucket does not exist.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoSuchBucket AWS API Documentation
class Aws::S3::Types::NoSuchBucket < ::Aws::EmptyStructure; end

# The specified key does not exist.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoSuchKey AWS API Documentation
class Aws::S3::Types::NoSuchKey < ::Aws::EmptyStructure; end

# The specified multipart upload does not exist.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoSuchUpload AWS API Documentation
class Aws::S3::Types::NoSuchUpload < ::Aws::EmptyStructure; end

# Specifies when noncurrent object versions expire. Upon expiration,
# Amazon S3 permanently deletes the noncurrent object versions. You set
# this lifecycle configuration action on a bucket that has versioning
# enabled (or suspended) to request that Amazon S3 delete noncurrent
# object versions at a specific period in the object's lifetime.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionExpiration AWS API Documentation
class Aws::S3::Types::NoncurrentVersionExpiration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8594
Aws::S3::Types::NoncurrentVersionExpiration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Container for the transition rule that describes when noncurrent
# objects transition to the `STANDARD_IA`, `ONEZONE_IA`,
# `INTELLIGENT_TIERING`, `GLACIER_IR`, `GLACIER`, or `DEEP_ARCHIVE`
# storage class. If your bucket is versioning-enabled (or versioning is
# suspended), you can set this action to request that Amazon S3
# transition noncurrent object versions to the `STANDARD_IA`,
# `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER_IR`, `GLACIER`, or
# `DEEP_ARCHIVE` storage class at a specific period in the object's
# lifetime.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionTransition AWS API Documentation
class Aws::S3::Types::NoncurrentVersionTransition < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8641
Aws::S3::Types::NoncurrentVersionTransition::SENSITIVE = T.let(T.unsafe(nil), Array)

# A container for specifying the notification configuration of the
# bucket. If this element is empty, notifications are turned off for the
# bucket.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfiguration AWS API Documentation
class Aws::S3::Types::NotificationConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8675
Aws::S3::Types::NotificationConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationDeprecated AWS API Documentation
class Aws::S3::Types::NotificationConfigurationDeprecated < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-s3//lib/aws-sdk-s3/types.rb#8702
Aws::S3::Types::Notif