# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `aws-sdk-kms` gem.
# Please instead update this file by running `bin/tapioca gem aws-sdk-kms`.

class Aws::EmptyStructure < ::Struct
  include ::Aws::Structure
end

# This module provides support for AWS Key Management Service. This module is available in the
# `aws-sdk-kms` gem.
#
# # Client
#
# The {Client} class provides one method for each API operation. Operation
# methods each accept a hash of request parameters and return a response
# structure.
#
#     kms = Aws::KMS::Client.new
#     resp = kms.cancel_key_deletion(params)
#
# See {Client} for more information.
#
# # Errors
#
# Errors returned from AWS Key Management Service are defined in the
# {Errors} module and all extend {Errors::ServiceError}.
#
#     begin
#       # do stuff
#     rescue Aws::KMS::Errors::ServiceError
#       # rescues all AWS Key Management Service API errors
#     end
#
# See {Errors} for more information.
module Aws::KMS; end

# An API client for KMS.  To construct a client, you need to configure a `:region` and `:credentials`.
#
#     client = Aws::KMS::Client.new(
#       region: region_name,
#       credentials: credentials,
#       # ...
#     )
#
# For details on configuring region and credentials see
# the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
#
# See {#initialize} for a full list of supported configuration options.
class Aws::KMS::Client < ::Seahorse::Client::Base
  include ::Aws::ClientStubs

  # @overload initialize
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#375
  def initialize(*args); end

  # @api private
  # @param params [{}]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#9020
  def build_request(operation_name, params = T.unsafe(nil)); end

  # Cancels the deletion of a KMS key. When this operation succeeds, the
  # key state of the KMS key is `Disabled`. To enable the KMS key, use
  # EnableKey.
  #
  # For more information about scheduling and canceling deletion of a KMS
  # key, see [Deleting KMS keys][1] in the *Key Management Service
  # Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:CancelKeyDeletion][3] (key policy)
  #
  # **Related operations**\: ScheduleKeyDeletion
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To cancel deletion of a KMS key
  #
  #   # The following example cancels deletion of the specified KMS key.
  #
  #   resp = client.cancel_key_deletion({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose deletion you are canceling. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key whose deletion you canceled.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.cancel_key_deletion({
  #   key_id: "KeyIdType", # required
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  # @option params
  # @overload cancel_key_deletion
  # @param params [Hash] ({})
  # @return [Types::CancelKeyDeletionResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CancelKeyDeletionResponse#key_id #key_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CancelKeyDeletion AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#453
  def cancel_key_deletion(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Connects or reconnects a [custom key store][1] to its backing key
  # store. For an CloudHSM key store, `ConnectCustomKeyStore` connects the
  # key store to its associated CloudHSM cluster. For an external key
  # store, `ConnectCustomKeyStore` connects the key store to the external
  # key store proxy that communicates with your external key manager.
  #
  # The custom key store must be connected before you can create KMS keys
  # in the key store or use the KMS keys it contains. You can disconnect
  # and reconnect a custom key store at any time.
  #
  # The connection process for a custom key store can take an extended
  # amount of time to complete. This operation starts the connection
  # process, but it does not wait for it to complete. When it succeeds,
  # this operation quickly returns an HTTP 200 response and a JSON object
  # with no properties. However, this response does not indicate that the
  # custom key store is connected. To get the connection state of the
  # custom key store, use the DescribeCustomKeyStores operation.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # The `ConnectCustomKeyStore` operation might fail for various reasons.
  # To find the reason, use the DescribeCustomKeyStores operation and see
  # the `ConnectionErrorCode` in the response. For help interpreting the
  # `ConnectionErrorCode`, see CustomKeyStoresListEntry.
  #
  # To fix the failure, use the DisconnectCustomKeyStore operation to
  # disconnect the custom key store, correct the error, use the
  # UpdateCustomKeyStore operation if necessary, and then use
  # `ConnectCustomKeyStore` again.
  #
  # **CloudHSM key store**
  #
  # During the connection process for an CloudHSM key store, KMS finds the
  # CloudHSM cluster that is associated with the custom key store, creates
  # the connection infrastructure, connects to the cluster, logs into the
  # CloudHSM client as the `kmsuser` CU, and rotates its password.
  #
  # To connect an CloudHSM key store, its associated CloudHSM cluster must
  # have at least one active HSM. To get the number of active HSMs in a
  # cluster, use the [DescribeClusters][2] operation. To add HSMs to the
  # cluster, use the [CreateHsm][3] operation. Also, the [ `kmsuser`
  # crypto user][4] (CU) must not be logged into the cluster. This
  # prevents KMS from using this account to log in.
  #
  # If you are having trouble connecting or disconnecting a CloudHSM key
  # store, see [Troubleshooting an CloudHSM key store][5] in the *Key
  # Management Service Developer Guide*.
  #
  # **External key store**
  #
  # When you connect an external key store that uses public endpoint
  # connectivity, KMS tests its ability to communicate with your external
  # key manager by sending a request via the external key store proxy.
  #
  # When you connect to an external key store that uses VPC endpoint
  # service connectivity, KMS establishes the networking elements that it
  # needs to communicate with your external key manager via the external
  # key store proxy. This includes creating an interface endpoint to the
  # VPC endpoint service and a private hosted zone for traffic between KMS
  # and the VPC endpoint service.
  #
  # To connect an external key store, KMS must be able to connect to the
  # external key store proxy, the external key store proxy must be able to
  # communicate with your external key manager, and the external key
  # manager must be available for cryptographic operations.
  #
  # If you are having trouble connecting or disconnecting an external key
  # store, see [Troubleshooting an external key store][6] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:ConnectCustomKeyStore][7] (IAM policy)
  #
  # **Related operations**
  #
  # * CreateCustomKeyStore
  #
  # * DeleteCustomKeyStore
  #
  # * DescribeCustomKeyStores
  #
  # * DisconnectCustomKeyStore
  #
  # * UpdateCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html
  # [3]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To connect a custom key store
  #
  #   # This example connects an AWS KMS custom key store to its backing key store. For an AWS CloudHSM key store, it connects
  #   # the key store to its AWS CloudHSM cluster. For an external key store, it connects the key store to the external key
  #   # store proxy that communicates with your external key manager. This operation does not return any data. To verify that
  #   # the custom key store is connected, use the <code>DescribeCustomKeyStores</code> operation.
  #
  #   resp = client.connect_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the AWS KMS custom key store.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.connect_custom_key_store({
  #   custom_key_store_id: "CustomKeyStoreIdType", # required
  #   })
  # @option params
  # @overload connect_custom_key_store
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ConnectCustomKeyStore AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#590
  def connect_custom_key_store(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a friendly name for a KMS key.
  #
  # <note markdown="1"> Adding, deleting, or updating an alias can allow or deny permission to
  # the KMS key. For details, see [ABAC for KMS][1] in the *Key Management
  # Service Developer Guide*.
  #
  #  </note>
  #
  # You can use an alias to identify a KMS key in the KMS console, in the
  # DescribeKey operation and in [cryptographic operations][2], such as
  # Encrypt and GenerateDataKey. You can also change the KMS key that's
  # associated with the alias (UpdateAlias) or delete the alias
  # (DeleteAlias) at any time. These operations don't affect the
  # underlying KMS key.
  #
  # You can associate the alias with any customer managed key in the same
  # Amazon Web Services Region. Each alias is associated with only one KMS
  # key at a time, but a KMS key can have multiple aliases. A valid KMS
  # key is required. You can't create an alias without a KMS key.
  #
  # The alias must be unique in the account and Region, but you can have
  # aliases with the same name in different Regions. For detailed
  # information about aliases, see [Using aliases][3] in the *Key
  # Management Service Developer Guide*.
  #
  # This operation does not return a response. To get the alias that you
  # created, use the ListAliases operation.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on an
  # alias in a different Amazon Web Services account.
  #
  # **Required permissions**
  #
  # * [kms:CreateAlias][5] on the alias (IAM policy).
  #
  # * [kms:CreateAlias][5] on the KMS key (key policy).
  #
  # For details, see [Controlling access to aliases][6] in the *Key
  # Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * DeleteAlias
  #
  # * ListAliases
  #
  # * UpdateAlias
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/abac.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access
  #
  # @example Example: To create an alias
  #
  #   # The following example creates an alias for the specified KMS key.
  #
  #   resp = client.create_alias({
  #   alias_name: "alias/ExampleAlias", # The alias to create. Aliases must begin with 'alias/'. Do not use aliases that begin with 'alias/aws' because they are reserved for use by AWS.
  #   target_key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose alias you are creating. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_alias({
  #   alias_name: "AliasNameType", # required
  #   target_key_id: "KeyIdType", # required
  #   })
  # @option params
  # @option params
  # @overload create_alias
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAlias AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#720
  def create_alias(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a [custom key store][1] backed by a key store that you own and
  # manage. When you use a KMS key in a custom key store for a
  # cryptographic operation, the cryptographic operation is actually
  # performed in your key store using your keys. KMS supports [CloudHSM
  # key stores][2] backed by an [CloudHSM cluster][3] and [external key
  # stores][4] backed by an external key store proxy and external key
  # manager outside of Amazon Web Services.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # Before you create the custom key store, the required elements must be
  # in place and operational. We recommend that you use the test tools
  # that KMS provides to verify the configuration your external key store
  # proxy. For details about the required elements and verification tests,
  # see [Assemble the prerequisites (for CloudHSM key stores)][5] or
  # [Assemble the prerequisites (for external key stores)][6] in the *Key
  # Management Service Developer Guide*.
  #
  # To create a custom key store, use the following parameters.
  #
  # * To create an CloudHSM key store, specify the `CustomKeyStoreName`,
  #   `CloudHsmClusterId`, `KeyStorePassword`, and
  #   `TrustAnchorCertificate`. The `CustomKeyStoreType` parameter is
  #   optional for CloudHSM key stores. If you include it, set it to the
  #   default value, `AWS_CLOUDHSM`. For help with failures, see
  #   [Troubleshooting an CloudHSM key store][7] in the *Key Management
  #   Service Developer Guide*.
  #
  # * To create an external key store, specify the `CustomKeyStoreName`
  #   and a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`. Also, specify
  #   values for `XksProxyConnectivity`,
  #   `XksProxyAuthenticationCredential`, `XksProxyUriEndpoint`, and
  #   `XksProxyUriPath`. If your `XksProxyConnectivity` value is
  #   `VPC_ENDPOINT_SERVICE`, specify the `XksProxyVpcEndpointServiceName`
  #   parameter. For help with failures, see [Troubleshooting an external
  #   key store][8] in the *Key Management Service Developer Guide*.
  #
  # <note markdown="1"> For external key stores:
  #
  #  Some external key managers provide a simpler method for creating an
  # external key store. For details, see your external key manager
  # documentation.
  #
  #  When creating an external key store in the KMS console, you can upload
  # a JSON-based proxy configuration file with the desired values. You
  # cannot use a proxy configuration with the `CreateCustomKeyStore`
  # operation. However, you can use the values in the file to help you
  # determine the correct values for the `CreateCustomKeyStore`
  # parameters.
  #
  #  </note>
  #
  # When the operation completes successfully, it returns the ID of the
  # new custom key store. Before you can use your new custom key store,
  # you need to use the ConnectCustomKeyStore operation to connect a new
  # CloudHSM key store to its CloudHSM cluster, or to connect a new
  # external key store to the external key store proxy for your external
  # key manager. Even if you are not going to use your custom key store
  # immediately, you might want to connect it to verify that all settings
  # are correct and then disconnect it until you are ready to use it.
  #
  # For help with failures, see [Troubleshooting a custom key store][7] in
  # the *Key Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:CreateCustomKeyStore][9] (IAM policy).
  #
  # **Related operations:**
  #
  # * ConnectCustomKeyStore
  #
  # * DeleteCustomKeyStore
  #
  # * DescribeCustomKeyStores
  #
  # * DisconnectCustomKeyStore
  #
  # * UpdateCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/keystore-cloudhsm.html
  # [3]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To create an AWS CloudHSM key store
  #
  #   # This example creates a custom key store that is associated with an AWS CloudHSM cluster.
  #
  #   resp = client.create_custom_key_store({
  #   cloud_hsm_cluster_id: "cluster-1a23b4cdefg", # The ID of the CloudHSM cluster.
  #   custom_key_store_name: "ExampleKeyStore", # A friendly name for the custom key store.
  #   key_store_password: "kmsPswd", # The password for the kmsuser CU account in the specified cluster.
  #   trust_anchor_certificate: "<certificate-goes-here>", # The content of the customerCA.crt file that you created when you initialized the cluster.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the new custom key store.
  #   }
  # @example Example: To create an external key store with VPC endpoint service connectivity
  #
  #   # This example creates an external key store that uses an Amazon VPC endpoint service to communicate with AWS KMS.
  #
  #   resp = client.create_custom_key_store({
  #   custom_key_store_name: "ExampleVPCEndpointKeyStore", # A friendly name for the custom key store
  #   custom_key_store_type: "EXTERNAL_KEY_STORE", # For external key stores, the value must be EXTERNAL_KEY_STORE
  #   xks_proxy_authentication_credential: {
  #   access_key_id: "ABCDE12345670EXAMPLE",
  #   raw_secret_access_key: "DXjSUawnel2fr6SKC7G25CNxTyWKE5PF9XX6H/u9pSo=",
  #   }, # The access key ID and secret access key that KMS uses to authenticate to your external key store proxy
  #   xks_proxy_connectivity: "VPC_ENDPOINT_SERVICE", # Indicates how AWS KMS communicates with the external key store proxy
  #   xks_proxy_uri_endpoint: "https://myproxy-private.xks.example.com", # The URI that AWS KMS uses to connect to the external key store proxy
  #   xks_proxy_uri_path: "/example-prefix/kms/xks/v1", # The URI path to the external key store proxy APIs
  #   xks_proxy_vpc_endpoint_service_name: "com.amazonaws.vpce.us-east-1.vpce-svc-example1", # The VPC endpoint service that KMS uses to communicate with the external key store proxy
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the new custom key store.
  #   }
  # @example Example: To create an external key store with public endpoint connectivity
  #
  #   # This example creates an external key store with public endpoint connectivity.
  #
  #   resp = client.create_custom_key_store({
  #   custom_key_store_name: "ExamplePublicEndpointKeyStore", # A friendly name for the custom key store
  #   custom_key_store_type: "EXTERNAL_KEY_STORE", # For external key stores, the value must be EXTERNAL_KEY_STORE
  #   xks_proxy_authentication_credential: {
  #   access_key_id: "ABCDE12345670EXAMPLE",
  #   raw_secret_access_key: "DXjSUawnel2fr6SKC7G25CNxTyWKE5PF9XX6H/u9pSo=",
  #   }, # The access key ID and secret access key that KMS uses to authenticate to your external key store proxy
  #   xks_proxy_connectivity: "PUBLIC_ENDPOINT", # Indicates how AWS KMS communicates with the external key store proxy
  #   xks_proxy_uri_endpoint: "https://myproxy.xks.example.com", # The URI that AWS KMS uses to connect to the external key store proxy
  #   xks_proxy_uri_path: "/kms/xks/v1", # The URI path to your external key store proxy API
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_store_id: "cks-987654321abcdef0", # The ID of the new custom key store.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_custom_key_store({
  #   custom_key_store_name: "CustomKeyStoreNameType", # required
  #   cloud_hsm_cluster_id: "CloudHsmClusterIdType",
  #   trust_anchor_certificate: "TrustAnchorCertificateType",
  #   key_store_password: "KeyStorePasswordType",
  #   custom_key_store_type: "AWS_CLOUDHSM", # accepts AWS_CLOUDHSM, EXTERNAL_KEY_STORE
  #   xks_proxy_uri_endpoint: "XksProxyUriEndpointType",
  #   xks_proxy_uri_path: "XksProxyUriPathType",
  #   xks_proxy_vpc_endpoint_service_name: "XksProxyVpcEndpointServiceNameType",
  #   xks_proxy_authentication_credential: {
  #   access_key_id: "XksProxyAuthenticationAccessKeyIdType", # required
  #   raw_secret_access_key: "XksProxyAuthenticationRawSecretAccessKeyType", # required
  #   },
  #   xks_proxy_connectivity: "PUBLIC_ENDPOINT", # accepts PUBLIC_ENDPOINT, VPC_ENDPOINT_SERVICE
  #   })
  # @example Response structure
  #
  #   resp.custom_key_store_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_custom_key_store
  # @param params [Hash] ({})
  # @return [Types::CreateCustomKeyStoreResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateCustomKeyStoreResponse#custom_key_store_id #custom_key_store_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateCustomKeyStore AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#1101
  def create_custom_key_store(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds a grant to a KMS key.
  #
  # A *grant* is a policy instrument that allows Amazon Web Services
  # principals to use KMS keys in cryptographic operations. It also can
  # allow them to view a KMS key (DescribeKey) and create and manage
  # grants. When authorizing access to a KMS key, grants are considered
  # along with key policies and IAM policies. Grants are often used for
  # temporary permissions because you can create one, use its permissions,
  # and delete it without changing your key policies or IAM policies.
  #
  # For detailed information about grants, including grant terminology,
  # see [Grants in KMS][1] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>. For examples of working with grants in several
  # programming languages, see [Programming grants][2].
  #
  # The `CreateGrant` operation returns a `GrantToken` and a `GrantId`.
  #
  # * When you create, retire, or revoke a grant, there might be a brief
  #   delay, usually less than five minutes, until the grant is available
  #   throughout KMS. This state is known as *eventual consistency*. Once
  #   the grant has achieved eventual consistency, the grantee principal
  #   can use the permissions in the grant without identifying the grant.
  #
  #   However, to use the permissions in the grant immediately, use the
  #   `GrantToken` that `CreateGrant` returns. For details, see [Using a
  #   grant token][3] in the <i> <i>Key Management Service Developer
  #   Guide</i> </i>.
  #
  # * The `CreateGrant` operation also returns a `GrantId`. You can use
  #   the `GrantId` and a key identifier to identify the grant in the
  #   RetireGrant and RevokeGrant operations. To find the grant ID, use
  #   the ListGrants or ListRetirableGrants operations.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation on a KMS key in
  # a different Amazon Web Services account, specify the key ARN in the
  # value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:CreateGrant][5] (key policy)
  #
  # **Related operations:**
  #
  # * ListGrants
  #
  # * ListRetirableGrants
  #
  # * RetireGrant
  #
  # * RevokeGrant
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To create a grant
  #
  #   # The following example creates a grant that allows the specified IAM role to encrypt data with the specified KMS key.
  #
  #   resp = client.create_grant({
  #   grantee_principal: "arn:aws:iam::111122223333:role/ExampleRole", # The identity that is given permission to perform the operations specified in the grant.
  #   key_id: "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to which the grant applies. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   operations: [
  #   "Encrypt",
  #   "Decrypt",
  #   ], # A list of operations that the grant allows.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   grant_id: "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60", # The unique identifier of the grant.
  #   grant_token: "AQpAM2RhZTk1MGMyNTk2ZmZmMzEyYWVhOWViN2I1MWM4Mzc0MWFiYjc0ZDE1ODkyNGFlNTIzODZhMzgyZjBlNGY3NiKIAgEBAgB4Pa6VDCWW__MSrqnre1HIN0Grt00ViSSuUjhqOC8OT3YAAADfMIHcBgkqhkiG9w0BBwaggc4wgcsCAQAwgcUGCSqGSIb3DQEHATAeBglghkgBZQMEAS4wEQQMmqLyBTAegIn9XlK5AgEQgIGXZQjkBcl1dykDdqZBUQ6L1OfUivQy7JVYO2-ZJP7m6f1g8GzV47HX5phdtONAP7K_HQIflcgpkoCqd_fUnE114mSmiagWkbQ5sqAVV3ov-VeqgrvMe5ZFEWLMSluvBAqdjHEdMIkHMlhlj4ENZbzBfo9Wxk8b8SnwP4kc4gGivedzFXo-dwN8fxjjq_ZZ9JFOj2ijIbj5FyogDCN0drOfi8RORSEuCEmPvjFRMFAwcmwFkN2NPp89amA", # The grant token.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_grant({
  #   key_id: "KeyIdType", # required
  #   grantee_principal: "PrincipalIdType", # required
  #   retiring_principal: "PrincipalIdType",
  #   operations: ["Decrypt"], # required, accepts Decrypt, Encrypt, GenerateDataKey, GenerateDataKeyWithoutPlaintext, ReEncryptFrom, ReEncryptTo, Sign, Verify, GetPublicKey, CreateGrant, RetireGrant, DescribeKey, GenerateDataKeyPair, GenerateDataKeyPairWithoutPlaintext, GenerateMac, VerifyMac
  #   constraints: {
  #   encryption_context_subset: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   encryption_context_equals: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   },
  #   grant_tokens: ["GrantTokenType"],
  #   name: "GrantNameType",
  #   })
  # @example Response structure
  #
  #   resp.grant_token #=> String
  #   resp.grant_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_grant
  # @param params [Hash] ({})
  # @return [Types::CreateGrantResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateGrantResponse#grant_token #grant_token} => String
  #   * {Types::CreateGrantResponse#grant_id #grant_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateGrant AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#1359
  def create_grant(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a unique customer managed [KMS key][1] in your Amazon Web
  # Services account and Region. You can use a KMS key in cryptographic
  # operations, such as encryption and signing. Some Amazon Web Services
  # services let you use KMS keys that you create and manage to protect
  # your service resources.
  #
  # A KMS key is a logical representation of a cryptographic key. In
  # addition to the key material used in cryptographic operations, a KMS
  # key includes metadata, such as the key ID, key policy, creation date,
  # description, and key state. For details, see [Managing keys][2] in the
  # *Key Management Service Developer Guide*
  #
  # Use the parameters of `CreateKey` to specify the type of KMS key, the
  # source of its key material, its key policy, description, tags, and
  # other properties.
  #
  # <note markdown="1"> KMS has replaced the term *customer master key (CMK)* with *KMS key*
  # and *KMS key*. The concept has not changed. To prevent breaking
  # changes, KMS is keeping some variations of this term.
  #
  #  </note>
  #
  # To create different types of KMS keys, use the following guidance:
  #
  # Symmetric encryption KMS key
  #
  # : By default, `CreateKey` creates a symmetric encryption KMS key with
  #   key material that KMS generates. This is the basic and most widely
  #   used type of KMS key, and provides the best performance.
  #
  #   To create a symmetric encryption KMS key, you don't need to specify
  #   any parameters. The default value for `KeySpec`,
  #   `SYMMETRIC_DEFAULT`, the default value for `KeyUsage`,
  #   `ENCRYPT_DECRYPT`, and the default value for `Origin`, `AWS_KMS`,
  #   create a symmetric encryption KMS key with KMS key material.
  #
  #   If you need a key for basic encryption and decryption or you are
  #   creating a KMS key to protect your resources in an Amazon Web
  #   Services service, create a symmetric encryption KMS key. The key
  #   material in a symmetric encryption key never leaves KMS unencrypted.
  #   You can use a symmetric encryption KMS key to encrypt and decrypt
  #   data up to 4,096 bytes, but they are typically used to generate data
  #   keys and data keys pairs. For details, see GenerateDataKey and
  #   GenerateDataKeyPair.
  #
  #
  #
  # Asymmetric KMS keys
  #
  # : To create an asymmetric KMS key, use the `KeySpec` parameter to
  #   specify the type of key material in the KMS key. Then, use the
  #   `KeyUsage` parameter to determine whether the KMS key will be used
  #   to encrypt and decrypt or sign and verify. You can't change these
  #   properties after the KMS key is created.
  #
  #   Asymmetric KMS keys contain an RSA key pair, Elliptic Curve (ECC)
  #   key pair, or an SM2 key pair (China Regions only). The private key
  #   in an asymmetric KMS key never leaves KMS unencrypted. However, you
  #   can use the GetPublicKey operation to download the public key so it
  #   can be used outside of KMS. KMS keys with RSA or SM2 key pairs can
  #   be used to encrypt or decrypt data or sign and verify messages (but
  #   not both). KMS keys with ECC key pairs can be used only to sign and
  #   verify messages. For information about asymmetric KMS keys, see
  #   [Asymmetric KMS keys][3] in the *Key Management Service Developer
  #   Guide*.
  #
  #
  #
  # HMAC KMS key
  #
  # : To create an HMAC KMS key, set the `KeySpec` parameter to a key spec
  #   value for HMAC KMS keys. Then set the `KeyUsage` parameter to
  #   `GENERATE_VERIFY_MAC`. You must set the key usage even though
  #   `GENERATE_VERIFY_MAC` is the only valid key usage value for HMAC KMS
  #   keys. You can't change these properties after the KMS key is
  #   created.
  #
  #   HMAC KMS keys are symmetric keys that never leave KMS unencrypted.
  #   You can use HMAC keys to generate (GenerateMac) and verify
  #   (VerifyMac) HMAC codes for messages up to 4096 bytes.
  #
  #   HMAC KMS keys are not supported in all Amazon Web Services Regions.
  #   If you try to create an HMAC KMS key in an Amazon Web Services
  #   Region in which HMAC keys are not supported, the `CreateKey`
  #   operation returns an `UnsupportedOperationException`. For a list of
  #   Regions in which HMAC KMS keys are supported, see [HMAC keys in
  #   KMS][4] in the *Key Management Service Developer Guide*.
  #
  #
  #
  # Multi-Region primary keys
  # Imported key material
  #
  # : To create a multi-Region *primary key* in the local Amazon Web
  #   Services Region, use the `MultiRegion` parameter with a value of
  #   `True`. To create a multi-Region *replica key*, that is, a KMS key
  #   with the same key ID and key material as a primary key, but in a
  #   different Amazon Web Services Region, use the ReplicateKey
  #   operation. To change a replica key to a primary key, and its primary
  #   key to a replica key, use the UpdatePrimaryRegion operation.
  #
  #   You can create multi-Region KMS keys for all supported KMS key
  #   types: symmetric encryption KMS keys, HMAC KMS keys, asymmetric
  #   encryption KMS keys, and asymmetric signing KMS keys. You can also
  #   create multi-Region keys with imported key material. However, you
  #   can't create multi-Region keys in a custom key store.
  #
  #   This operation supports *multi-Region keys*, an KMS feature that
  #   lets you create multiple interoperable KMS keys in different Amazon
  #   Web Services Regions. Because these KMS keys have the same key ID,
  #   key material, and other metadata, you can use them interchangeably
  #   to encrypt data in one Amazon Web Services Region and decrypt it in
  #   a different Amazon Web Services Region without re-encrypting the
  #   data or making a cross-Region call. For more information about
  #   multi-Region keys, see [Multi-Region keys in KMS][5] in the *Key
  #   Management Service Developer Guide*.
  #
  #
  #
  # : To import your own key material into a KMS key, begin by creating a
  #   symmetric encryption KMS key with no key material. To do this, use
  #   the `Origin` parameter of `CreateKey` with a value of `EXTERNAL`.
  #   Next, use GetParametersForImport operation to get a public key and
  #   import token, and use the public key to encrypt your key material.
  #   Then, use ImportKeyMaterial with your import token to import the key
  #   material. For step-by-step instructions, see [Importing Key
  #   Material][6] in the <i> <i>Key Management Service Developer
  #   Guide</i> </i>.
  #
  #   This feature supports only symmetric encryption KMS keys, including
  #   multi-Region symmetric encryption KMS keys. You cannot import key
  #   material into any other type of KMS key.
  #
  #   To create a multi-Region primary key with imported key material, use
  #   the `Origin` parameter of `CreateKey` with a value of `EXTERNAL` and
  #   the `MultiRegion` parameter with a value of `True`. To create
  #   replicas of the multi-Region primary key, use the ReplicateKey
  #   operation. For instructions, see [Importing key material into
  #   multi-Region keys][7]. For more information about multi-Region keys,
  #   see [Multi-Region keys in KMS][5] in the *Key Management Service
  #   Developer Guide*.
  #
  #
  #
  # Custom key store
  #
  # : A [custom key store][8] lets you protect your Amazon Web Services
  #   resources using keys in a backing key store that you own and manage.
  #   When you request a cryptographic operation with a KMS key in a
  #   custom key store, the operation is performed in the backing key
  #   store using its cryptographic keys.
  #
  #   KMS supports [CloudHSM key stores][9] backed by an CloudHSM cluster
  #   and [external key stores][10] backed by an external key manager
  #   outside of Amazon Web Services. When you create a KMS key in an
  #   CloudHSM key store, KMS generates an encryption key in the CloudHSM
  #   cluster and associates it with the KMS key. When you create a KMS
  #   key in an external key store, you specify an existing encryption key
  #   in the external key manager.
  #
  #   <note markdown="1"> Some external key managers provide a simpler method for creating a
  #   KMS key in an external key store. For details, see your external key
  #   manager documentation.
  #
  #    </note>
  #
  #   Before you create a KMS key in a custom key store, the
  #   `ConnectionState` of the key store must be `CONNECTED`. To connect
  #   the custom key store, use the ConnectCustomKeyStore operation. To
  #   find the `ConnectionState`, use the DescribeCustomKeyStores
  #   operation.
  #
  #   To create a KMS key in a custom key store, use the
  #   `CustomKeyStoreId`. Use the default `KeySpec` value,
  #   `SYMMETRIC_DEFAULT`, and the default `KeyUsage` value,
  #   `ENCRYPT_DECRYPT` to create a symmetric encryption key. No other key
  #   type is supported in a custom key store.
  #
  #   To create a KMS key in an [CloudHSM key store][9], use the `Origin`
  #   parameter with a value of `AWS_CLOUDHSM`. The CloudHSM cluster that
  #   is associated with the custom key store must have at least two
  #   active HSMs in different Availability Zones in the Amazon Web
  #   Services Region.
  #
  #   To create a KMS key in an [external key store][10], use the `Origin`
  #   parameter with a value of `EXTERNAL_KEY_STORE` and an `XksKeyId`
  #   parameter that identifies an existing external key.
  #
  #   <note markdown="1"> Some external key managers provide a simpler method for creating a
  #   KMS key in an external key store. For details, see your external key
  #   manager documentation.
  #
  #    </note>
  #
  # **Cross-account use**\: No. You cannot use this operation to create a
  # KMS key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:CreateKey][11] (IAM policy). To use
  # the `Tags` parameter, [kms:TagResource][11] (IAM policy). For examples
  # and information about related permissions, see [Allow a user to create
  # KMS keys][12] in the *Key Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * DescribeKey
  #
  # * ListKeys
  #
  # * ScheduleKeyDeletion
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms-keys
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-import.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/keystore-cloudhsm.html
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html
  # [11]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [12]: https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policy-example-create-key
  #
  # @example Example: To create a KMS key
  #
  #   # The following example creates a symmetric KMS key for encryption and decryption. No parameters are required for this
  #   # operation.
  #
  #   resp = client.create_key({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2017-07-05T14:04:55-07:00"),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create an asymmetric RSA KMS key for encryption and decryption
  #
  #   # This example creates a KMS key that contains an asymmetric RSA key pair for encryption and decryption. The key spec and
  #   # key usage can't be changed after the key is created.
  #
  #   resp = client.create_key({
  #   key_spec: "RSA_4096", # Describes the type of key material in the KMS key.
  #   key_usage: "ENCRYPT_DECRYPT", # The cryptographic operations for which you can use the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2021-04-05T14:04:55-07:00"),
  #   customer_master_key_spec: "RSA_4096",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "RSAES_OAEP_SHA_1",
  #   "RSAES_OAEP_SHA_256",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "RSA_4096",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create an asymmetric elliptic curve KMS key for signing and verification
  #
  #   # This example creates a KMS key that contains an asymmetric elliptic curve (ECC) key pair for signing and verification.
  #   # The key usage is required even though "SIGN_VERIFY" is the only valid value for ECC KMS keys. The key spec and key usage
  #   # can't be changed after the key is created.
  #
  #   resp = client.create_key({
  #   key_spec: "ECC_NIST_P521", # Describes the type of key material in the KMS key.
  #   key_usage: "SIGN_VERIFY", # The cryptographic operations for which you can use the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2019-12-02T07:48:55-07:00"),
  #   customer_master_key_spec: "ECC_NIST_P521",
  #   description: "",
  #   enabled: true,
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "ECC_NIST_P521",
  #   key_state: "Enabled",
  #   key_usage: "SIGN_VERIFY",
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   signing_algorithms: [
  #   "ECDSA_SHA_512",
  #   ],
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create an HMAC KMS key
  #
  #   # This example creates a 384-bit symmetric HMAC KMS key. The GENERATE_VERIFY_MAC key usage value is required even though
  #   # it's the only valid value for HMAC KMS keys. The key spec and key usage can't be changed after the key is created.
  #
  #   resp = client.create_key({
  #   key_spec: "HMAC_384", # Describes the type of key material in the KMS key.
  #   key_usage: "GENERATE_VERIFY_MAC", # The cryptographic operations for which you can use the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2022-04-05T14:04:55-07:00"),
  #   customer_master_key_spec: "HMAC_384",
  #   description: "",
  #   enabled: true,
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "HMAC_384",
  #   key_state: "Enabled",
  #   key_usage: "GENERATE_VERIFY_MAC",
  #   mac_algorithms: [
  #   "HMAC_SHA_384",
  #   ],
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create a multi-Region primary KMS key
  #
  #   # This example creates a multi-Region primary symmetric encryption key. Because the default values for all parameters
  #   # create a symmetric encryption key, only the MultiRegion parameter is required for this KMS key.
  #
  #   resp = client.create_key({
  #   multi_region: true, # Indicates whether the KMS key is a multi-Region (True) or regional (False) key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/mrk-1234abcd12ab34cd56ef12345678990ab",
  #   creation_date: Time.parse("2021-09-02T016:15:21-09:00"),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "mrk-1234abcd12ab34cd56ef12345678990ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: true,
  #   multi_region_configuration: {
  #   multi_region_key_type: "PRIMARY",
  #   primary_key: {
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/mrk-1234abcd12ab34cd56ef12345678990ab",
  #   region: "us-west-2",
  #   },
  #   replica_keys: [
  #   ],
  #   },
  #   origin: "AWS_KMS",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create a KMS key for imported key material
  #
  #   # This example creates a KMS key with no key material. When the operation is complete, you can import your own key
  #   # material into the KMS key. To create this KMS key, set the Origin parameter to EXTERNAL.
  #
  #   resp = client.create_key({
  #   origin: "EXTERNAL", # The source of the key material for the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2019-12-02T07:48:55-07:00"),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: false,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "PendingImport",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "EXTERNAL",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create a KMS key in an AWS CloudHSM key store
  #
  #   # This example creates a KMS key in the specified AWS CloudHSM key store. The operation creates the KMS key and its
  #   # metadata in AWS KMS and creates the key material in the AWS CloudHSM cluster associated with the custom key store. This
  #   # example requires the CustomKeyStoreId  and Origin parameters.
  #
  #   resp = client.create_key({
  #   custom_key_store_id: "cks-1234567890abcdef0", # Identifies the custom key store that hosts the KMS key.
  #   origin: "AWS_CLOUDHSM", # Indicates the source of the key material for the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   cloud_hsm_cluster_id: "cluster-1a23b4cdefg",
  #   creation_date: Time.parse("2019-12-02T07:48:55-07:00"),
  #   custom_key_store_id: "cks-1234567890abcdef0",
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "AWS_CLOUDHSM",
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Example: To create a KMS key in an external key store
  #
  #   # This example creates a KMS key in the specified external key store. It uses the XksKeyId parameter to associate the KMS
  #   # key with an existing symmetric encryption key in your external key manager. This CustomKeyStoreId, Origin, and XksKeyId
  #   # parameters are required in this operation.
  #
  #   resp = client.create_key({
  #   custom_key_store_id: "cks-9876543210fedcba9", # Identifies the custom key store that hosts the KMS key.
  #   origin: "EXTERNAL_KEY_STORE", # Indicates the source of the key material for the KMS key.
  #   xks_key_id: "bb8562717f809024", # Identifies the encryption key in your external key manager that is associated with the KMS key
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321",
  #   creation_date: Time.parse("2022-02-02T07:48:55-07:00"),
  #   custom_key_store_id: "cks-9876543210fedcba9",
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "0987dcba-09fe-87dc-65ba-ab0987654321",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "EXTERNAL_KEY_STORE",
  #   xks_key_configuration: {
  #   id: "bb8562717f809024",
  #   },
  #   }, # Detailed information about the KMS key that this operation creates.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_key({
  #   policy: "PolicyType",
  #   description: "DescriptionType",
  #   key_usage: "SIGN_VERIFY", # accepts SIGN_VERIFY, ENCRYPT_DECRYPT, GENERATE_VERIFY_MAC
  #   customer_master_key_spec: "RSA_2048", # accepts RSA_2048, RSA_3072, RSA_4096, ECC_NIST_P256, ECC_NIST_P384, ECC_NIST_P521, ECC_SECG_P256K1, SYMMETRIC_DEFAULT, HMAC_224, HMAC_256, HMAC_384, HMAC_512, SM2
  #   key_spec: "RSA_2048", # accepts RSA_2048, RSA_3072, RSA_4096, ECC_NIST_P256, ECC_NIST_P384, ECC_NIST_P521, ECC_SECG_P256K1, SYMMETRIC_DEFAULT, HMAC_224, HMAC_256, HMAC_384, HMAC_512, SM2
  #   origin: "AWS_KMS", # accepts AWS_KMS, EXTERNAL, AWS_CLOUDHSM, EXTERNAL_KEY_STORE
  #   custom_key_store_id: "CustomKeyStoreIdType",
  #   bypass_policy_lockout_safety_check: false,
  #   tags: [
  #   {
  #   tag_key: "TagKeyType", # required
  #   tag_value: "TagValueType", # required
  #   },
  #   ],
  #   multi_region: false,
  #   xks_key_id: "XksKeyIdType",
  #   })
  # @example Response structure
  #
  #   resp.key_metadata.aws_account_id #=> String
  #   resp.key_metadata.key_id #=> String
  #   resp.key_metadata.arn #=> String
  #   resp.key_metadata.creation_date #=> Time
  #   resp.key_metadata.enabled #=> Boolean
  #   resp.key_metadata.description #=> String
  #   resp.key_metadata.key_usage #=> String, one of "SIGN_VERIFY", "ENCRYPT_DECRYPT", "GENERATE_VERIFY_MAC"
  #   resp.key_metadata.key_state #=> String, one of "Creating", "Enabled", "Disabled", "PendingDeletion", "PendingImport", "PendingReplicaDeletion", "Unavailable", "Updating"
  #   resp.key_metadata.deletion_date #=> Time
  #   resp.key_metadata.valid_to #=> Time
  #   resp.key_metadata.origin #=> String, one of "AWS_KMS", "EXTERNAL", "AWS_CLOUDHSM", "EXTERNAL_KEY_STORE"
  #   resp.key_metadata.custom_key_store_id #=> String
  #   resp.key_metadata.cloud_hsm_cluster_id #=> String
  #   resp.key_metadata.expiration_model #=> String, one of "KEY_MATERIAL_EXPIRES", "KEY_MATERIAL_DOES_NOT_EXPIRE"
  #   resp.key_metadata.key_manager #=> String, one of "AWS", "CUSTOMER"
  #   resp.key_metadata.customer_master_key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_metadata.key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_metadata.encryption_algorithms #=> Array
  #   resp.key_metadata.encryption_algorithms[0] #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  #   resp.key_metadata.signing_algorithms #=> Array
  #   resp.key_metadata.signing_algorithms[0] #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  #   resp.key_metadata.multi_region #=> Boolean
  #   resp.key_metadata.multi_region_configuration.multi_region_key_type #=> String, one of "PRIMARY", "REPLICA"
  #   resp.key_metadata.multi_region_configuration.primary_key.arn #=> String
  #   resp.key_metadata.multi_region_configuration.primary_key.region #=> String
  #   resp.key_metadata.multi_region_configuration.replica_keys #=> Array
  #   resp.key_metadata.multi_region_configuration.replica_keys[0].arn #=> String
  #   resp.key_metadata.multi_region_configuration.replica_keys[0].region #=> String
  #   resp.key_metadata.pending_deletion_window_in_days #=> Integer
  #   resp.key_metadata.mac_algorithms #=> Array
  #   resp.key_metadata.mac_algorithms[0] #=> String, one of "HMAC_SHA_224", "HMAC_SHA_256", "HMAC_SHA_384", "HMAC_SHA_512"
  #   resp.key_metadata.xks_key_configuration.id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_key
  # @param params [Hash] ({})
  # @return [Types::CreateKeyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateKeyResponse#key_metadata #key_metadata} => Types::KeyMetadata
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2254
  def create_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Decrypts ciphertext that was encrypted by a KMS key using any of the
  # following operations:
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  # * GenerateDataKeyWithoutPlaintext
  #
  # * GenerateDataKeyPairWithoutPlaintext
  #
  # You can use this operation to decrypt ciphertext that was encrypted
  # under a symmetric encryption KMS key or an asymmetric encryption KMS
  # key. When the KMS key is asymmetric, you must specify the KMS key and
  # the encryption algorithm that was used to encrypt the ciphertext. For
  # information about asymmetric KMS keys, see [Asymmetric KMS keys][1] in
  # the *Key Management Service Developer Guide*.
  #
  # The `Decrypt` operation also decrypts ciphertext that was encrypted
  # outside of KMS by the public key in an KMS asymmetric KMS key.
  # However, it cannot decrypt symmetric ciphertext produced by other
  # libraries, such as the [Amazon Web Services Encryption SDK][2] or
  # [Amazon S3 client-side encryption][3]. These libraries return a
  # ciphertext format that is incompatible with KMS.
  #
  # If the ciphertext was encrypted under a symmetric encryption KMS key,
  # the `KeyId` parameter is optional. KMS can get this information from
  # metadata that it adds to the symmetric ciphertext blob. This feature
  # adds durability to your implementation by ensuring that authorized
  # users can decrypt ciphertext decades after it was encrypted, even if
  # they've lost track of the key ID. However, specifying the KMS key is
  # always recommended as a best practice. When you use the `KeyId`
  # parameter to specify a KMS key, KMS only uses the KMS key you specify.
  # If the ciphertext was encrypted under a different KMS key, the
  # `Decrypt` operation fails. This practice ensures that you use the KMS
  # key that you intend.
  #
  # Whenever possible, use key policies to give users permission to call
  # the `Decrypt` operation on a particular KMS key, instead of using IAM
  # policies. Otherwise, you might create an IAM user policy that gives
  # the user `Decrypt` permission on all KMS keys. This user could decrypt
  # ciphertext that was encrypted by KMS keys in other accounts if the key
  # policy for the cross-account KMS key permits it. If you must use an
  # IAM policy for `Decrypt` permissions, limit the user to particular KMS
  # keys or particular trusted accounts. For details, see [Best practices
  # for IAM policies][4] in the *Key Management Service Developer Guide*.
  #
  # Applications in Amazon Web Services Nitro Enclaves can call this
  # operation by using the [Amazon Web Services Nitro Enclaves Development
  # Kit][5]. For information about the supporting parameters, see [How
  # Amazon Web Services Nitro Enclaves use KMS][6] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][7] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:Decrypt][8] (key policy)
  #
  # **Related operations:**
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  # * ReEncrypt
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [2]: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/
  # [3]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policies-best-practices
  # [5]: https://github.com/aws/aws-nitro-enclaves-sdk-c
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To decrypt data
  #
  #   # The following example decrypts data that was encrypted with a KMS key.
  #
  #   resp = client.decrypt({
  #   ciphertext_blob: "<binary data>", # The encrypted data (ciphertext).
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # A key identifier for the KMS key to use to decrypt the data.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The Amazon Resource Name (ARN) of the KMS key that was used to decrypt the data.
  #   plaintext: "<binary data>", # The decrypted (plaintext) data.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.decrypt({
  #   ciphertext_blob: "data", # required
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   grant_tokens: ["GrantTokenType"],
  #   key_id: "KeyIdType",
  #   encryption_algorithm: "SYMMETRIC_DEFAULT", # accepts SYMMETRIC_DEFAULT, RSAES_OAEP_SHA_1, RSAES_OAEP_SHA_256, SM2PKE
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.plaintext #=> String
  #   resp.encryption_algorithm #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload decrypt
  # @param params [Hash] ({})
  # @return [Types::DecryptResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DecryptResponse#key_id #key_id} => String
  #   * {Types::DecryptResponse#plaintext #plaintext} => String
  #   * {Types::DecryptResponse#encryption_algorithm #encryption_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Decrypt AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2472
  def decrypt(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the specified alias.
  #
  # <note markdown="1"> Adding, deleting, or updating an alias can allow or deny permission to
  # the KMS key. For details, see [ABAC for KMS][1] in the *Key Management
  # Service Developer Guide*.
  #
  #  </note>
  #
  # Because an alias is not a property of a KMS key, you can delete and
  # change the aliases of a KMS key without affecting the KMS key. Also,
  # aliases do not appear in the response from the DescribeKey operation.
  # To get the aliases of all KMS keys, use the ListAliases operation.
  #
  # Each KMS key can have multiple aliases. To change the alias of a KMS
  # key, use DeleteAlias to delete the current alias and CreateAlias to
  # create a new alias. To associate an existing alias with a different
  # KMS key, call UpdateAlias.
  #
  # **Cross-account use**\: No. You cannot perform this operation on an
  # alias in a different Amazon Web Services account.
  #
  # **Required permissions**
  #
  # * [kms:DeleteAlias][2] on the alias (IAM policy).
  #
  # * [kms:DeleteAlias][2] on the KMS key (key policy).
  #
  # For details, see [Controlling access to aliases][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * CreateAlias
  #
  # * ListAliases
  #
  # * UpdateAlias
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/abac.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access
  #
  # @example Example: To delete an alias
  #
  #   # The following example deletes the specified alias.
  #
  #   resp = client.delete_alias({
  #   alias_name: "alias/ExampleAlias", # The alias to delete.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_alias({
  #   alias_name: "AliasNameType", # required
  #   })
  # @option params
  # @overload delete_alias
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteAlias AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2546
  def delete_alias(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes a [custom key store][1]. This operation does not affect any
  # backing elements of the custom key store. It does not delete the
  # CloudHSM cluster that is associated with an CloudHSM key store, or
  # affect any users or keys in the cluster. For an external key store, it
  # does not affect the external key store proxy, external key manager, or
  # any external keys.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # The custom key store that you delete cannot contain any [KMS keys][2].
  # Before deleting the key store, verify that you will never need to use
  # any of the KMS keys in the key store for any [cryptographic
  # operations][3]. Then, use ScheduleKeyDeletion to delete the KMS keys
  # from the key store. After the required waiting period expires and all
  # KMS keys are deleted from the custom key store, use
  # DisconnectCustomKeyStore to disconnect the key store from KMS. Then,
  # you can delete the custom key store.
  #
  # For keys in an CloudHSM key store, the `ScheduleKeyDeletion` operation
  # makes a best effort to delete the key material from the associated
  # cluster. However, you might need to manually [delete the orphaned key
  # material][4] from the cluster and its backups. KMS never creates,
  # manages, or deletes cryptographic keys in the external key manager
  # associated with an external key store. You must manage them using your
  # external key manager tools.
  #
  # Instead of deleting the custom key store, consider using the
  # DisconnectCustomKeyStore operation to disconnect the custom key store
  # from its backing key store. While the key store is disconnected, you
  # cannot create or use the KMS keys in the key store. But, you do not
  # need to delete KMS keys and you can reconnect a disconnected custom
  # key store at any time.
  #
  # If the operation succeeds, it returns a JSON object with no
  # properties.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DeleteCustomKeyStore][5] (IAM policy)
  #
  # **Related operations:**
  #
  # * ConnectCustomKeyStore
  #
  # * CreateCustomKeyStore
  #
  # * DescribeCustomKeyStores
  #
  # * DisconnectCustomKeyStore
  #
  # * UpdateCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To delete a custom key store from AWS KMS
  #
  #   # This example deletes a custom key store from AWS KMS. This operation does not affect the backing key store, such as a
  #   # CloudHSM cluster, external key store proxy, or your external key manager. This operation doesn't return any data. To
  #   # verify that the operation was successful, use the DescribeCustomKeyStores operation.
  #
  #   resp = client.delete_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store to be deleted.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_custom_key_store({
  #   custom_key_store_id: "CustomKeyStoreIdType", # required
  #   })
  # @option params
  # @overload delete_custom_key_store
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteCustomKeyStore AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2645
  def delete_custom_key_store(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes key material that you previously imported. This operation
  # makes the specified KMS key unusable. For more information about
  # importing key material into KMS, see [Importing Key Material][1] in
  # the *Key Management Service Developer Guide*.
  #
  # When the specified KMS key is in the `PendingDeletion` state, this
  # operation does not change the KMS key's state. Otherwise, it changes
  # the KMS key's state to `PendingImport`.
  #
  # After you delete key material, you can use ImportKeyMaterial to
  # reimport the same key material into the KMS key.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DeleteImportedKeyMaterial][3] (key
  # policy)
  #
  # **Related operations:**
  #
  # * GetParametersForImport
  #
  # * ImportKeyMaterial
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To delete imported key material
  #
  #   # The following example deletes the imported key material from the specified KMS key.
  #
  #   resp = client.delete_imported_key_material({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose imported key material you are deleting. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.delete_imported_key_material({
  #   key_id: "KeyIdType", # required
  #   })
  # @option params
  # @overload delete_imported_key_material
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterial AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2721
  def delete_imported_key_material(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets information about [custom key stores][1] in the account and
  # Region.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # By default, this operation returns information about all custom key
  # stores in the account and Region. To get only information about a
  # particular custom key store, use either the `CustomKeyStoreName` or
  # `CustomKeyStoreId` parameter (but not both).
  #
  # To determine whether the custom key store is connected to its CloudHSM
  # cluster or external key store proxy, use the `ConnectionState` element
  # in the response. If an attempt to connect the custom key store failed,
  # the `ConnectionState` value is `FAILED` and the `ConnectionErrorCode`
  # element in the response indicates the cause of the failure. For help
  # interpreting the `ConnectionErrorCode`, see CustomKeyStoresListEntry.
  #
  # Custom key stores have a `DISCONNECTED` connection state if the key
  # store has never been connected or you used the
  # DisconnectCustomKeyStore operation to disconnect it. Otherwise, the
  # connection state is CONNECTED. If your custom key store connection
  # state is `CONNECTED` but you are having trouble using it, verify that
  # the backing store is active and available. For an CloudHSM key store,
  # verify that the associated CloudHSM cluster is active and contains the
  # minimum number of HSMs required for the operation, if any. For an
  # external key store, verify that the external key store proxy and its
  # associated external key manager are reachable and enabled.
  #
  # For help repairing your CloudHSM key store, see the [Troubleshooting
  # CloudHSM key stores][2]. For help repairing your external key store,
  # see the [Troubleshooting external key stores][3]. Both topics are in
  # the *Key Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DescribeCustomKeyStores][4] (IAM
  # policy)
  #
  # **Related operations:**
  #
  # * ConnectCustomKeyStore
  #
  # * CreateCustomKeyStore
  #
  # * DeleteCustomKeyStore
  #
  # * DisconnectCustomKeyStore
  #
  # * UpdateCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To get detailed information about custom key stores in the account and Region
  #
  #   # This example gets detailed information about all AWS KMS custom key stores in an AWS account and Region. To get all key
  #   # stores, do not enter a custom key store name or ID.
  #
  #   resp = client.describe_custom_key_stores({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_stores: [
  #   ], # Details about each custom key store in the account and Region.
  #   }
  # @example Example: To get detailed information about an AWS CloudHSM key store by specifying its friendly name
  #
  #   # This example gets detailed information about a particular AWS CloudHSM key store by specifying its friendly name. To
  #   # limit the output to a particular custom key store, provide either the custom key store name or ID.
  #
  #   resp = client.describe_custom_key_stores({
  #   custom_key_store_name: "ExampleKeyStore", # The friendly name of the custom key store.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_stores: [
  #   {
  #   cloud_hsm_cluster_id: "cluster-1a23b4cdefg",
  #   connection_state: "CONNECTED",
  #   creation_date: Time.parse("1.499288695918E9"),
  #   custom_key_store_id: "cks-1234567890abcdef0",
  #   custom_key_store_name: "ExampleKeyStore",
  #   custom_key_store_type: "AWS_CLOUDHSM",
  #   trust_anchor_certificate: "<certificate appears here>",
  #   },
  #   ], # Detailed information about the specified custom key store.
  #   }
  # @example Example: To get detailed information about an external key store by specifying its ID
  #
  #   # This example gets detailed information about an external key store by specifying its ID.  The example external key store
  #   # proxy uses public endpoint connectivity.
  #
  #   resp = client.describe_custom_key_stores({
  #   custom_key_store_id: "cks-9876543210fedcba9", # The ID of the custom key store.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_stores: [
  #   {
  #   connection_state: "CONNECTED",
  #   creation_date: Time.parse("1.599288695918E9"),
  #   custom_key_store_id: "cks-9876543210fedcba9",
  #   custom_key_store_name: "ExampleExternalKeyStore",
  #   custom_key_store_type: "EXTERNAL_KEY_STORE",
  #   xks_proxy_configuration: {
  #   access_key_id: "ABCDE12345670EXAMPLE",
  #   connectivity: "PUBLIC_ENDPOINT",
  #   uri_endpoint: "https://myproxy.xks.example.com",
  #   uri_path: "/kms/xks/v1",
  #   },
  #   },
  #   ], # Detailed information about the specified custom key store.
  #   }
  # @example Example: To get detailed information about an external key store VPC endpoint connectivity by specifying its friendly name
  #
  #   # This example gets detailed information about a particular external key store by specifying its friendly name. To limit
  #   # the output to a particular custom key store, provide either the custom key store name or ID. The proxy URI path for this
  #   # external key store includes an optional prefix. Also, because this example external key store uses VPC endpoint
  #   # connectivity, the response includes the associated VPC endpoint service name.
  #
  #   resp = client.describe_custom_key_stores({
  #   custom_key_store_name: "VPCExternalKeystore",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   custom_key_stores: [
  #   {
  #   connection_state: "CONNECTED",
  #   creation_date: Time.parse("1.643057863.842"),
  #   custom_key_store_id: "cks-876543210fedcba98",
  #   custom_key_store_name: "ExampleVPCExternalKeyStore",
  #   custom_key_store_type: "EXTERNAL_KEY_STORE",
  #   xks_proxy_configuration: {
  #   access_key_id: "ABCDE12345670EXAMPLE",
  #   connectivity: "VPC_ENDPOINT_SERVICE",
  #   uri_endpoint: "https://myproxy-private.xks.example.com",
  #   uri_path: "/example-prefix/kms/xks/v1",
  #   vpc_endpoint_service_name: "com.amazonaws.vpce.us-east-1.vpce-svc-example1",
  #   },
  #   },
  #   ], # Detailed information about the specified custom key store.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.describe_custom_key_stores({
  #   custom_key_store_id: "CustomKeyStoreIdType",
  #   custom_key_store_name: "CustomKeyStoreNameType",
  #   limit: 1,
  #   marker: "MarkerType",
  #   })
  # @example Response structure
  #
  #   resp.custom_key_stores #=> Array
  #   resp.custom_key_stores[0].custom_key_store_id #=> String
  #   resp.custom_key_stores[0].custom_key_store_name #=> String
  #   resp.custom_key_stores[0].cloud_hsm_cluster_id #=> String
  #   resp.custom_key_stores[0].trust_anchor_certificate #=> String
  #   resp.custom_key_stores[0].connection_state #=> String, one of "CONNECTED", "CONNECTING", "FAILED", "DISCONNECTED", "DISCONNECTING"
  #   resp.custom_key_stores[0].connection_error_code #=> String, one of "INVALID_CREDENTIALS", "CLUSTER_NOT_FOUND", "NETWORK_ERRORS", "INTERNAL_ERROR", "INSUFFICIENT_CLOUDHSM_HSMS", "USER_LOCKED_OUT", "USER_NOT_FOUND", "USER_LOGGED_IN", "SUBNET_NOT_FOUND", "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET", "XKS_PROXY_ACCESS_DENIED", "XKS_PROXY_NOT_REACHABLE", "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND", "XKS_PROXY_INVALID_RESPONSE", "XKS_PROXY_INVALID_CONFIGURATION", "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION", "XKS_PROXY_TIMED_OUT", "XKS_PROXY_INVALID_TLS_CONFIGURATION"
  #   resp.custom_key_stores[0].creation_date #=> Time
  #   resp.custom_key_stores[0].custom_key_store_type #=> String, one of "AWS_CLOUDHSM", "EXTERNAL_KEY_STORE"
  #   resp.custom_key_stores[0].xks_proxy_configuration.connectivity #=> String, one of "PUBLIC_ENDPOINT", "VPC_ENDPOINT_SERVICE"
  #   resp.custom_key_stores[0].xks_proxy_configuration.access_key_id #=> String
  #   resp.custom_key_stores[0].xks_proxy_configuration.uri_endpoint #=> String
  #   resp.custom_key_stores[0].xks_proxy_configuration.uri_path #=> String
  #   resp.custom_key_stores[0].xks_proxy_configuration.vpc_endpoint_service_name #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload describe_custom_key_stores
  # @param params [Hash] ({})
  # @return [Types::DescribeCustomKeyStoresResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DescribeCustomKeyStoresResponse#custom_key_stores #custom_key_stores} => Array&lt;Types::CustomKeyStoresListEntry&gt;
  #   * {Types::DescribeCustomKeyStoresResponse#next_marker #next_marker} => String
  #   * {Types::DescribeCustomKeyStoresResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStores AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#2952
  def describe_custom_key_stores(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Provides detailed information about a KMS key. You can run
  # `DescribeKey` on a [customer managed key][1] or an [Amazon Web
  # Services managed key][2].
  #
  # This detailed information includes the key ARN, creation date (and
  # deletion date, if applicable), the key state, and the origin and
  # expiration date (if any) of the key material. It includes fields, like
  # `KeySpec`, that help you distinguish different types of KMS keys. It
  # also displays the key usage (encryption, signing, or generating and
  # verifying MACs) and the algorithms that the KMS key supports.
  #
  # For [multi-Region
  # keys](kms/latest/developerguide/multi-region-keys-overview.html),
  # `DescribeKey` displays the primary key and all related replica keys.
  # For KMS keys in [CloudHSM key
  # stores](kms/latest/developerguide/keystore-cloudhsm.html), it includes
  # information about the key store, such as the key store ID and the
  # CloudHSM cluster ID. For KMS keys in [external key
  # stores](kms/latest/developerguide/keystore-external.html), it includes
  # the custom key store ID and the ID of the external key.
  #
  # `DescribeKey` does not return the following information:
  #
  # * Aliases associated with the KMS key. To get this information, use
  #   ListAliases.
  #
  # * Whether automatic key rotation is enabled on the KMS key. To get
  #   this information, use GetKeyRotationStatus. Also, some key states
  #   prevent a KMS key from being automatically rotated. For details, see
  #   [How Automatic Key Rotation Works][3] in the *Key Management Service
  #   Developer Guide*.
  #
  # * Tags on the KMS key. To get this information, use ListResourceTags.
  #
  # * Key policies and grants on the KMS key. To get this information, use
  #   GetKeyPolicy and ListGrants.
  #
  # In general, `DescribeKey` is a non-mutating operation. It returns data
  # about KMS keys, but doesn't change them. However, Amazon Web Services
  # services use `DescribeKey` to create [Amazon Web Services managed
  # keys][2] from a *predefined Amazon Web Services alias* with no key ID.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:DescribeKey][4] (key policy)
  #
  # **Related operations:**
  #
  # * GetKeyPolicy
  #
  # * GetKeyRotationStatus
  #
  # * ListAliases
  #
  # * ListGrants
  #
  # * ListKeys
  #
  # * ListResourceTags
  #
  # * ListRetirableGrants
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To get details about a KMS key
  #
  #   # The following example gets metadata for a symmetric encryption KMS key.
  #
  #   resp = client.describe_key({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse("2017-07-05T14:04:55-07:00"),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Example: To get details about an RSA asymmetric KMS key
  #
  #   # The following example gets metadata for an asymmetric RSA KMS key used for signing and verification.
  #
  #   resp = client.describe_key({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse(1571767572.317),
  #   customer_master_key_spec: "RSA_2048",
  #   description: "",
  #   enabled: false,
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "RSA_2048",
  #   key_state: "Disabled",
  #   key_usage: "SIGN_VERIFY",
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   signing_algorithms: [
  #   "RSASSA_PKCS1_V1_5_SHA_256",
  #   "RSASSA_PKCS1_V1_5_SHA_384",
  #   "RSASSA_PKCS1_V1_5_SHA_512",
  #   "RSASSA_PSS_SHA_256",
  #   "RSASSA_PSS_SHA_384",
  #   "RSASSA_PSS_SHA_512",
  #   ],
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Example: To get details about a multi-Region key
  #
  #   # The following example gets metadata for a multi-Region replica key. This multi-Region key is a symmetric encryption key.
  #   # DescribeKey returns information about the primary key and all of its replicas.
  #
  #   resp = client.describe_key({
  #   key_id: "arn:aws:kms:ap-northeast-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:ap-northeast-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   creation_date: Time.parse(1586329200.918),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "mrk-1234abcd12ab34cd56ef1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: true,
  #   multi_region_configuration: {
  #   multi_region_key_type: "PRIMARY",
  #   primary_key: {
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "us-west-2",
  #   },
  #   replica_keys: [
  #   {
  #   arn: "arn:aws:kms:eu-west-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "eu-west-1",
  #   },
  #   {
  #   arn: "arn:aws:kms:ap-northeast-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "ap-northeast-1",
  #   },
  #   {
  #   arn: "arn:aws:kms:sa-east-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "sa-east-1",
  #   },
  #   ],
  #   },
  #   origin: "AWS_KMS",
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Example: To get details about an HMAC KMS key
  #
  #   # The following example gets the metadata of an HMAC KMS key.
  #
  #   resp = client.describe_key({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "123456789012",
  #   arn: "arn:aws:kms:us-west-2:123456789012:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse(1566160362.664),
  #   customer_master_key_spec: "HMAC_256",
  #   description: "Development test key",
  #   enabled: true,
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_state: "Enabled",
  #   key_usage: "GENERATE_VERIFY_MAC",
  #   mac_algorithms: [
  #   "HMAC_SHA_256",
  #   ],
  #   multi_region: false,
  #   origin: "AWS_KMS",
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Example: To get details about a KMS key in an AWS CloudHSM key store
  #
  #   # The following example gets the metadata of a KMS key in an AWS CloudHSM key store.
  #
  #   resp = client.describe_key({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "123456789012",
  #   arn: "arn:aws:kms:us-west-2:123456789012:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   cloud_hsm_cluster_id: "cluster-1a23b4cdefg",
  #   creation_date: Time.parse(1646160362.664),
  #   custom_key_store_id: "cks-1234567890abcdef0",
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "CloudHSM key store test key",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "AWS_CLOUDHSM",
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Example: To get details about a KMS key in an external key store
  #
  #   # The following example gets the metadata of a KMS key in an external key store.
  #
  #   resp = client.describe_key({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # An identifier for the KMS key. You can use the key ID, key ARN, alias name, alias ARN of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_metadata: {
  #   aws_account_id: "123456789012",
  #   arn: "arn:aws:kms:us-west-2:123456789012:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   creation_date: Time.parse(1646160362.664),
  #   custom_key_store_id: "cks-1234567890abcdef0",
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "External key store test key",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_spec: "SYMMETRIC_DEFAULT",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: false,
  #   origin: "EXTERNAL_KEY_STORE",
  #   xks_key_configuration: {
  #   id: "bb8562717f809024",
  #   },
  #   }, # An object that contains information about the specified KMS key.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.describe_key({
  #   key_id: "KeyIdType", # required
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.key_metadata.aws_account_id #=> String
  #   resp.key_metadata.key_id #=> String
  #   resp.key_metadata.arn #=> String
  #   resp.key_metadata.creation_date #=> Time
  #   resp.key_metadata.enabled #=> Boolean
  #   resp.key_metadata.description #=> String
  #   resp.key_metadata.key_usage #=> String, one of "SIGN_VERIFY", "ENCRYPT_DECRYPT", "GENERATE_VERIFY_MAC"
  #   resp.key_metadata.key_state #=> String, one of "Creating", "Enabled", "Disabled", "PendingDeletion", "PendingImport", "PendingReplicaDeletion", "Unavailable", "Updating"
  #   resp.key_metadata.deletion_date #=> Time
  #   resp.key_metadata.valid_to #=> Time
  #   resp.key_metadata.origin #=> String, one of "AWS_KMS", "EXTERNAL", "AWS_CLOUDHSM", "EXTERNAL_KEY_STORE"
  #   resp.key_metadata.custom_key_store_id #=> String
  #   resp.key_metadata.cloud_hsm_cluster_id #=> String
  #   resp.key_metadata.expiration_model #=> String, one of "KEY_MATERIAL_EXPIRES", "KEY_MATERIAL_DOES_NOT_EXPIRE"
  #   resp.key_metadata.key_manager #=> String, one of "AWS", "CUSTOMER"
  #   resp.key_metadata.customer_master_key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_metadata.key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_metadata.encryption_algorithms #=> Array
  #   resp.key_metadata.encryption_algorithms[0] #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  #   resp.key_metadata.signing_algorithms #=> Array
  #   resp.key_metadata.signing_algorithms[0] #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  #   resp.key_metadata.multi_region #=> Boolean
  #   resp.key_metadata.multi_region_configuration.multi_region_key_type #=> String, one of "PRIMARY", "REPLICA"
  #   resp.key_metadata.multi_region_configuration.primary_key.arn #=> String
  #   resp.key_metadata.multi_region_configuration.primary_key.region #=> String
  #   resp.key_metadata.multi_region_configuration.replica_keys #=> Array
  #   resp.key_metadata.multi_region_configuration.replica_keys[0].arn #=> String
  #   resp.key_metadata.multi_region_configuration.replica_keys[0].region #=> String
  #   resp.key_metadata.pending_deletion_window_in_days #=> Integer
  #   resp.key_metadata.mac_algorithms #=> Array
  #   resp.key_metadata.mac_algorithms[0] #=> String, one of "HMAC_SHA_224", "HMAC_SHA_256", "HMAC_SHA_384", "HMAC_SHA_512"
  #   resp.key_metadata.xks_key_configuration.id #=> String
  # @option params
  # @option params
  # @overload describe_key
  # @param params [Hash] ({})
  # @return [Types::DescribeKeyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DescribeKeyResponse#key_metadata #key_metadata} => Types::KeyMetadata
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3334
  def describe_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the state of a KMS key to disabled. This change temporarily
  # prevents use of the KMS key for [cryptographic operations][1].
  #
  # For more information about how key state affects the use of a KMS key,
  # see [Key states of KMS keys][2] in the <i> <i>Key Management Service
  # Developer Guide</i> </i>.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DisableKey][3] (key policy)
  #
  # **Related operations**\: EnableKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To disable a KMS key
  #
  #   # The following example disables the specified KMS key.
  #
  #   resp = client.disable_key({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to disable. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.disable_key({
  #   key_id: "KeyIdType", # required
  #   })
  # @option params
  # @overload disable_key
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3399
  def disable_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Disables [automatic rotation of the key material][1] of the specified
  # symmetric encryption KMS key.
  #
  # Automatic key rotation is supported only on symmetric encryption KMS
  # keys. You cannot enable automatic rotation of [asymmetric KMS
  # keys][2], [HMAC KMS keys][3], KMS keys with [imported key
  # material][4], or KMS keys in a [custom key store][5]. To enable or
  # disable automatic rotation of a set of related [multi-Region keys][6],
  # set the property on the primary key.
  #
  # You can enable (EnableKeyRotation) and disable automatic rotation of
  # the key material in [customer managed KMS keys][7]. Key material
  # rotation of [Amazon Web Services managed KMS keys][8] is not
  # configurable. KMS always rotates the key material for every year.
  # Rotation of [Amazon Web Services owned KMS keys][9] varies.
  #
  # <note markdown="1"> In May 2022, KMS changed the rotation schedule for Amazon Web Services
  # managed keys from every three years to every year. For details, see
  # EnableKeyRotation.
  #
  #  </note>
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][10] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DisableKeyRotation][11] (key policy)
  #
  # **Related operations:**
  #
  # * EnableKeyRotation
  #
  # * GetKeyRotationStatus
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [11]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To disable automatic rotation of key material
  #
  #   # The following example disables automatic annual rotation of the key material for the specified KMS key.
  #
  #   resp = client.disable_key_rotation({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose key material will no longer be rotated. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.disable_key_rotation({
  #   key_id: "KeyIdType", # required
  #   })
  # @option params
  # @overload disable_key_rotation
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRotation AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3501
  def disable_key_rotation(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Disconnects the [custom key store][1] from its backing key store. This
  # operation disconnects an CloudHSM key store from its associated
  # CloudHSM cluster or disconnects an external key store from the
  # external key store proxy that communicates with your external key
  # manager.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # While a custom key store is disconnected, you can manage the custom
  # key store and its KMS keys, but you cannot create or use its KMS keys.
  # You can reconnect the custom key store at any time.
  #
  # <note markdown="1"> While a custom key store is disconnected, all attempts to create KMS
  # keys in the custom key store or to use existing KMS keys in
  # [cryptographic operations][2] will fail. This action can prevent users
  # from storing and accessing sensitive data.
  #
  #  </note>
  #
  # When you disconnect a custom key store, its `ConnectionState` changes
  # to `Disconnected`. To find the connection state of a custom key store,
  # use the DescribeCustomKeyStores operation. To reconnect a custom key
  # store, use the ConnectCustomKeyStore operation.
  #
  # If the operation succeeds, it returns a JSON object with no
  # properties.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:DisconnectCustomKeyStore][3] (IAM
  # policy)
  #
  # **Related operations:**
  #
  # * ConnectCustomKeyStore
  #
  # * CreateCustomKeyStore
  #
  # * DeleteCustomKeyStore
  #
  # * DescribeCustomKeyStores
  #
  # * UpdateCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To disconnect a custom key store from its CloudHSM cluster
  #
  #   # This example disconnects an AWS KMS custom key store from its backing key store. For an AWS CloudHSM key store, it
  #   # disconnects the key store from its AWS CloudHSM cluster. For an external key store, it disconnects the key store from
  #   # the external key store proxy that communicates with your external key manager. This operation doesn't return any data.
  #   # To verify that the custom key store is disconnected, use the <code>DescribeCustomKeyStores</code> operation.
  #
  #   resp = client.disconnect_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.disconnect_custom_key_store({
  #   custom_key_store_id: "CustomKeyStoreIdType", # required
  #   })
  # @option params
  # @overload disconnect_custom_key_store
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStore AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3592
  def disconnect_custom_key_store(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Sets the key state of a KMS key to enabled. This allows you to use the
  # KMS key for [cryptographic operations][1].
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:EnableKey][3] (key policy)
  #
  # **Related operations**\: DisableKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To enable a KMS key
  #
  #   # The following example enables the specified KMS key.
  #
  #   resp = client.enable_key({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to enable. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.enable_key({
  #   key_id: "KeyIdType", # required
  #   })
  # @option params
  # @overload enable_key
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3653
  def enable_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Enables [automatic rotation of the key material][1] of the specified
  # symmetric encryption KMS key.
  #
  # When you enable automatic rotation of a[customer managed KMS key][2],
  # KMS rotates the key material of the KMS key one year (approximately
  # 365 days) from the enable date and every year thereafter. You can
  # monitor rotation of the key material for your KMS keys in CloudTrail
  # and Amazon CloudWatch. To disable rotation of the key material in a
  # customer managed KMS key, use the DisableKeyRotation operation.
  #
  # Automatic key rotation is supported only on [symmetric encryption KMS
  # keys][3]. You cannot enable automatic rotation of [asymmetric KMS
  # keys][4], [HMAC KMS keys][5], KMS keys with [imported key
  # material][6], or KMS keys in a [custom key store][7]. To enable or
  # disable automatic rotation of a set of related [multi-Region keys][8],
  # set the property on the primary key.
  #
  # You cannot enable or disable automatic rotation [Amazon Web Services
  # managed KMS keys][9]. KMS always rotates the key material of Amazon
  # Web Services managed keys every year. Rotation of [Amazon Web Services
  # owned KMS keys][10] varies.
  #
  # <note markdown="1"> In May 2022, KMS changed the rotation schedule for Amazon Web Services
  # managed keys from every three years (approximately 1,095 days) to
  # every year (approximately 365 days).
  #
  #  New Amazon Web Services managed keys are automatically rotated one
  # year after they are created, and approximately every year thereafter.
  #
  #  Existing Amazon Web Services managed keys are automatically rotated
  # one year after their most recent rotation, and every year thereafter.
  #
  #  </note>
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][11] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:EnableKeyRotation][12] (key policy)
  #
  # **Related operations:**
  #
  # * DisableKeyRotation
  #
  # * GetKeyRotationStatus
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
  # [11]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [12]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To enable automatic rotation of key material
  #
  #   # The following example enables automatic annual rotation of the key material for the specified KMS key.
  #
  #   resp = client.enable_key_rotation({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose key material will be rotated annually. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.enable_key_rotation({
  #   key_id: "KeyIdType", # required
  #   })
  # @option params
  # @overload enable_key_rotation
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKeyRotation AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3770
  def enable_key_rotation(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Encrypts plaintext of up to 4,096 bytes using a KMS key. You can use a
  # symmetric or asymmetric KMS key with a `KeyUsage` of
  # `ENCRYPT_DECRYPT`.
  #
  # You can use this operation to encrypt small amounts of arbitrary data,
  # such as a personal identifier or database password, or other sensitive
  # information. You don't need to use the `Encrypt` operation to encrypt
  # a data key. The GenerateDataKey and GenerateDataKeyPair operations
  # return a plaintext data key and an encrypted copy of that data key.
  #
  # If you use a symmetric encryption KMS key, you can use an encryption
  # context to add additional security to your encryption operation. If
  # you specify an `EncryptionContext` when encrypting data, you must
  # specify the same encryption context (a case-sensitive exact match)
  # when decrypting the data. Otherwise, the request to decrypt fails with
  # an `InvalidCiphertextException`. For more information, see [Encryption
  # Context][1] in the *Key Management Service Developer Guide*.
  #
  # If you specify an asymmetric KMS key, you must also specify the
  # encryption algorithm. The algorithm must be compatible with the KMS
  # key spec.
  #
  # When you use an asymmetric KMS key to encrypt or reencrypt data, be
  # sure to record the KMS key and encryption algorithm that you choose.
  # You will be required to provide the same KMS key and encryption
  # algorithm when you decrypt the data. If the KMS key and algorithm do
  # not match the values used to encrypt the data, the decrypt operation
  # fails.
  #
  #  You are not required to supply the key ID and encryption algorithm
  # when you decrypt with symmetric encryption KMS keys because KMS stores
  # this information in the ciphertext blob. KMS cannot store metadata in
  # ciphertext generated with asymmetric keys. The standard format for
  # asymmetric key ciphertext does not include configurable fields.
  #
  # The maximum size of the data that you can encrypt varies with the type
  # of KMS key and the encryption algorithm that you choose.
  #
  # * Symmetric encryption KMS keys
  #
  #   * `SYMMETRIC_DEFAULT`\: 4096 bytes
  #
  #   ^
  #
  # * `RSA_2048`
  #
  #   * `RSAES_OAEP_SHA_1`\: 214 bytes
  #
  #   * `RSAES_OAEP_SHA_256`\: 190 bytes
  #
  # * `RSA_3072`
  #
  #   * `RSAES_OAEP_SHA_1`\: 342 bytes
  #
  #   * `RSAES_OAEP_SHA_256`\: 318 bytes
  #
  # * `RSA_4096`
  #
  #   * `RSAES_OAEP_SHA_1`\: 470 bytes
  #
  #   * `RSAES_OAEP_SHA_256`\: 446 bytes
  #
  # * `SM2PKE`\: 1024 bytes (China Regions only)
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:Encrypt][3] (key policy)
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To encrypt data
  #
  #   # The following example encrypts data with the specified KMS key.
  #
  #   resp = client.encrypt({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to use for encryption. You can use the key ID or Amazon Resource Name (ARN) of the KMS key, or the name or ARN of an alias that refers to the KMS key.
  #   plaintext: "<binary data>", # The data to encrypt.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   ciphertext_blob: "<binary data>", # The encrypted data (ciphertext).
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key that was used to encrypt the data.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.encrypt({
  #   key_id: "KeyIdType", # required
  #   plaintext: "data", # required
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   grant_tokens: ["GrantTokenType"],
  #   encryption_algorithm: "SYMMETRIC_DEFAULT", # accepts SYMMETRIC_DEFAULT, RSAES_OAEP_SHA_1, RSAES_OAEP_SHA_256, SM2PKE
  #   })
  # @example Response structure
  #
  #   resp.ciphertext_blob #=> String
  #   resp.key_id #=> String
  #   resp.encryption_algorithm #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload encrypt
  # @param params [Hash] ({})
  # @return [Types::EncryptResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::EncryptResponse#ciphertext_blob #ciphertext_blob} => String
  #   * {Types::EncryptResponse#key_id #key_id} => String
  #   * {Types::EncryptResponse#encryption_algorithm #encryption_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Encrypt AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#3982
  def encrypt(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a unique symmetric data key for use outside of KMS. This
  # operation returns a plaintext copy of the data key and a copy that is
  # encrypted under a symmetric encryption KMS key that you specify. The
  # bytes in the plaintext key are random; they are not related to the
  # caller or the KMS key. You can use the plaintext key to encrypt your
  # data outside of KMS and store the encrypted data key with the
  # encrypted data.
  #
  # To generate a data key, specify the symmetric encryption KMS key that
  # will be used to encrypt the data key. You cannot use an asymmetric KMS
  # key to encrypt data keys. To get the type of your KMS key, use the
  # DescribeKey operation.
  #
  # You must also specify the length of the data key. Use either the
  # `KeySpec` or `NumberOfBytes` parameters (but not both). For 128-bit
  # and 256-bit data keys, use the `KeySpec` parameter.
  #
  # To generate an SM4 data key (China Regions only), specify a `KeySpec`
  # value of `AES_128` or `NumberOfBytes` value of `128`. The symmetric
  # encryption key used in China Regions to encrypt your data key is an
  # SM4 encryption key.
  #
  # To get only an encrypted copy of the data key, use
  # GenerateDataKeyWithoutPlaintext. To generate an asymmetric data key
  # pair, use the GenerateDataKeyPair or
  # GenerateDataKeyPairWithoutPlaintext operation. To get a
  # cryptographically secure random byte string, use GenerateRandom.
  #
  # You can use an optional encryption context to add additional security
  # to the encryption operation. If you specify an `EncryptionContext`,
  # you must specify the same encryption context (a case-sensitive exact
  # match) when decrypting the encrypted data key. Otherwise, the request
  # to decrypt fails with an `InvalidCiphertextException`. For more
  # information, see [Encryption Context][1] in the *Key Management
  # Service Developer Guide*.
  #
  # Applications in Amazon Web Services Nitro Enclaves can call this
  # operation by using the [Amazon Web Services Nitro Enclaves Development
  # Kit][2]. For information about the supporting parameters, see [How
  # Amazon Web Services Nitro Enclaves use KMS][3] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **How to use your data key**
  #
  # We recommend that you use the following pattern to encrypt data
  # locally in your application. You can write your own code or use a
  # client-side encryption library, such as the [Amazon Web Services
  # Encryption SDK][5], the [Amazon DynamoDB Encryption Client][6], or
  # [Amazon S3 client-side encryption][7] to do these tasks for you.
  #
  # To encrypt data outside of KMS:
  #
  # 1.  Use the `GenerateDataKey` operation to get a data key.
  #
  # 2.  Use the plaintext data key (in the `Plaintext` field of the
  #     response) to encrypt your data outside of KMS. Then erase the
  #     plaintext data key from memory.
  #
  # 3.  Store the encrypted data key (in the `CiphertextBlob` field of the
  #     response) with the encrypted data.
  #
  # To decrypt data outside of KMS:
  #
  # 1.  Use the Decrypt operation to decrypt the encrypted data key. The
  #     operation returns a plaintext copy of the data key.
  #
  # 2.  Use the plaintext data key to decrypt data outside of KMS, then
  #     erase the plaintext data key from memory.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GenerateDataKey][8] (key policy)
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * Encrypt
  #
  # * GenerateDataKeyPair
  #
  # * GenerateDataKeyPairWithoutPlaintext
  #
  # * GenerateDataKeyWithoutPlaintext
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [2]: https://github.com/aws/aws-nitro-enclaves-sdk-c
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [5]: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/
  # [6]: https://docs.aws.amazon.com/dynamodb-encryption-client/latest/devguide/
  # [7]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate a data key
  #
  #   # The following example generates a 256-bit symmetric data encryption key (data key) in two formats. One is the
  #   # unencrypted (plainext) data key, and the other is the data key encrypted with the specified KMS key.
  #
  #   resp = client.generate_data_key({
  #   key_id: "alias/ExampleAlias", # The identifier of the KMS key to use to encrypt the data key. You can use the key ID or Amazon Resource Name (ARN) of the KMS key, or the name or ARN of an alias that refers to the KMS key.
  #   key_spec: "AES_256", # Specifies the type of data key to return.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   ciphertext_blob: "<binary data>", # The encrypted data key.
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key that was used to encrypt the data key.
  #   plaintext: "<binary data>", # The unencrypted (plaintext) data key.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_data_key({
  #   key_id: "KeyIdType", # required
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   number_of_bytes: 1,
  #   key_spec: "AES_256", # accepts AES_256, AES_128
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.ciphertext_blob #=> String
  #   resp.plaintext #=> String
  #   resp.key_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload generate_data_key
  # @param params [Hash] ({})
  # @return [Types::GenerateDataKeyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateDataKeyResponse#ciphertext_blob #ciphertext_blob} => String
  #   * {Types::GenerateDataKeyResponse#plaintext #plaintext} => String
  #   * {Types::GenerateDataKeyResponse#key_id #key_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#4209
  def generate_data_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a unique asymmetric data key pair for use outside of KMS. This
  # operation returns a plaintext public key, a plaintext private key, and
  # a copy of the private key that is encrypted under the symmetric
  # encryption KMS key you specify. You can use the data key pair to
  # perform asymmetric cryptography and implement digital signatures
  # outside of KMS. The bytes in the keys are random; they not related to
  # the caller or to the KMS key that is used to encrypt the private key.
  #
  # You can use the public key that `GenerateDataKeyPair` returns to
  # encrypt data or verify a signature outside of KMS. Then, store the
  # encrypted private key with the data. When you are ready to decrypt
  # data or sign a message, you can use the Decrypt operation to decrypt
  # the encrypted private key.
  #
  # To generate a data key pair, you must specify a symmetric encryption
  # KMS key to encrypt the private key in a data key pair. You cannot use
  # an asymmetric KMS key or a KMS key in a custom key store. To get the
  # type and origin of your KMS key, use the DescribeKey operation.
  #
  # Use the `KeyPairSpec` parameter to choose an RSA or Elliptic Curve
  # (ECC) data key pair. In China Regions, you can also choose an SM2 data
  # key pair. KMS recommends that you use ECC key pairs for signing, and
  # use RSA and SM2 key pairs for either encryption or signing, but not
  # both. However, KMS cannot enforce any restrictions on the use of data
  # key pairs outside of KMS.
  #
  # If you are using the data key pair to encrypt data, or for any
  # operation where you don't immediately need a private key, consider
  # using the GenerateDataKeyPairWithoutPlaintext operation.
  # `GenerateDataKeyPairWithoutPlaintext` returns a plaintext public key
  # and an encrypted private key, but omits the plaintext private key that
  # you need only to decrypt ciphertext or sign a message. Later, when you
  # need to decrypt the data or sign a message, use the Decrypt operation
  # to decrypt the encrypted private key in the data key pair.
  #
  # `GenerateDataKeyPair` returns a unique data key pair for each request.
  # The bytes in the keys are random; they are not related to the caller
  # or the KMS key that is used to encrypt the private key. The public key
  # is a DER-encoded X.509 SubjectPublicKeyInfo, as specified in [RFC
  # 5280][1]. The private key is a DER-encoded PKCS8 PrivateKeyInfo, as
  # specified in [RFC 5958][2].
  #
  # You can use an optional encryption context to add additional security
  # to the encryption operation. If you specify an `EncryptionContext`,
  # you must specify the same encryption context (a case-sensitive exact
  # match) when decrypting the encrypted data key. Otherwise, the request
  # to decrypt fails with an `InvalidCiphertextException`. For more
  # information, see [Encryption Context][3] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GenerateDataKeyPair][5] (key policy)
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPairWithoutPlaintext
  #
  # * GenerateDataKeyWithoutPlaintext
  #
  #
  #
  # [1]: https://tools.ietf.org/html/rfc5280
  # [2]: https://tools.ietf.org/html/rfc5958
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate an RSA key pair for encryption and decryption
  #
  #   # This example generates an RSA data key pair for encryption and decryption. The operation returns a plaintext public key
  #   # and private key, and a copy of the private key that is encrypted under a symmetric encryption KMS key that you specify.
  #
  #   resp = client.generate_data_key_pair({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ID of the symmetric encryption KMS key that encrypts the private RSA key in the data key pair.
  #   key_pair_spec: "RSA_3072", # The requested key spec of the RSA data key pair.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the symmetric encryption KMS key that was used to encrypt the private key.
  #   key_pair_spec: "RSA_3072", # The actual key spec of the RSA data key pair.
  #   private_key_ciphertext_blob: "<binary data>", # The encrypted private key of the RSA data key pair.
  #   private_key_plaintext: "<binary data>", # The plaintext private key of the RSA data key pair.
  #   public_key: "<binary data>", # The public key (plaintext) of the RSA data key pair.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_data_key_pair({
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   key_id: "KeyIdType", # required
  #   key_pair_spec: "RSA_2048", # required, accepts RSA_2048, RSA_3072, RSA_4096, ECC_NIST_P256, ECC_NIST_P384, ECC_NIST_P521, ECC_SECG_P256K1, SM2
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.private_key_ciphertext_blob #=> String
  #   resp.private_key_plaintext #=> String
  #   resp.public_key #=> String
  #   resp.key_id #=> String
  #   resp.key_pair_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SM2"
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload generate_data_key_pair
  # @param params [Hash] ({})
  # @return [Types::GenerateDataKeyPairResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateDataKeyPairResponse#private_key_ciphertext_blob #private_key_ciphertext_blob} => String
  #   * {Types::GenerateDataKeyPairResponse#private_key_plaintext #private_key_plaintext} => String
  #   * {Types::GenerateDataKeyPairResponse#public_key #public_key} => String
  #   * {Types::GenerateDataKeyPairResponse#key_id #key_id} => String
  #   * {Types::GenerateDataKeyPairResponse#key_pair_spec #key_pair_spec} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPair AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#4411
  def generate_data_key_pair(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a unique asymmetric data key pair for use outside of KMS. This
  # operation returns a plaintext public key and a copy of the private key
  # that is encrypted under the symmetric encryption KMS key you specify.
  # Unlike GenerateDataKeyPair, this operation does not return a plaintext
  # private key. The bytes in the keys are random; they are not related to
  # the caller or to the KMS key that is used to encrypt the private key.
  #
  # You can use the public key that `GenerateDataKeyPairWithoutPlaintext`
  # returns to encrypt data or verify a signature outside of KMS. Then,
  # store the encrypted private key with the data. When you are ready to
  # decrypt data or sign a message, you can use the Decrypt operation to
  # decrypt the encrypted private key.
  #
  # To generate a data key pair, you must specify a symmetric encryption
  # KMS key to encrypt the private key in a data key pair. You cannot use
  # an asymmetric KMS key or a KMS key in a custom key store. To get the
  # type and origin of your KMS key, use the DescribeKey operation.
  #
  # Use the `KeyPairSpec` parameter to choose an RSA or Elliptic Curve
  # (ECC) data key pair. In China Regions, you can also choose an SM2 data
  # key pair. KMS recommends that you use ECC key pairs for signing, and
  # use RSA and SM2 key pairs for either encryption or signing, but not
  # both. However, KMS cannot enforce any restrictions on the use of data
  # key pairs outside of KMS.
  #
  # `GenerateDataKeyPairWithoutPlaintext` returns a unique data key pair
  # for each request. The bytes in the key are not related to the caller
  # or KMS key that is used to encrypt the private key. The public key is
  # a DER-encoded X.509 SubjectPublicKeyInfo, as specified in [RFC
  # 5280][1].
  #
  # You can use an optional encryption context to add additional security
  # to the encryption operation. If you specify an `EncryptionContext`,
  # you must specify the same encryption context (a case-sensitive exact
  # match) when decrypting the encrypted data key. Otherwise, the request
  # to decrypt fails with an `InvalidCiphertextException`. For more
  # information, see [Encryption Context][2] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\:
  # [kms:GenerateDataKeyPairWithoutPlaintext][4] (key policy)
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  # * GenerateDataKeyWithoutPlaintext
  #
  #
  #
  # [1]: https://tools.ietf.org/html/rfc5280
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate an asymmetric data key pair without a plaintext key
  #
  #   # This example returns an asymmetric elliptic curve (ECC) data key pair. The private key is encrypted under the symmetric
  #   # encryption KMS key that you specify. This operation doesn't return a plaintext (unencrypted) private key.
  #
  #   resp = client.generate_data_key_pair_without_plaintext({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The symmetric encryption KMS key that encrypts the private key of the ECC data key pair.
  #   key_pair_spec: "ECC_NIST_P521", # The requested key spec of the ECC asymmetric data key pair.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the symmetric encryption KMS key that encrypted the private key in the ECC asymmetric data key pair.
  #   key_pair_spec: "ECC_NIST_P521", # The actual key spec of the ECC asymmetric data key pair.
  #   private_key_ciphertext_blob: "<binary data>", # The encrypted private key of the asymmetric ECC data key pair.
  #   public_key: "<binary data>", # The public key (plaintext).
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_data_key_pair_without_plaintext({
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   key_id: "KeyIdType", # required
  #   key_pair_spec: "RSA_2048", # required, accepts RSA_2048, RSA_3072, RSA_4096, ECC_NIST_P256, ECC_NIST_P384, ECC_NIST_P521, ECC_SECG_P256K1, SM2
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.private_key_ciphertext_blob #=> String
  #   resp.public_key #=> String
  #   resp.key_id #=> String
  #   resp.key_pair_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SM2"
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload generate_data_key_pair_without_plaintext
  # @param params [Hash] ({})
  # @return [Types::GenerateDataKeyPairWithoutPlaintextResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateDataKeyPairWithoutPlaintextResponse#private_key_ciphertext_blob #private_key_ciphertext_blob} => String
  #   * {Types::GenerateDataKeyPairWithoutPlaintextResponse#public_key #public_key} => String
  #   * {Types::GenerateDataKeyPairWithoutPlaintextResponse#key_id #key_id} => String
  #   * {Types::GenerateDataKeyPairWithoutPlaintextResponse#key_pair_spec #key_pair_spec} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairWithoutPlaintext AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#4599
  def generate_data_key_pair_without_plaintext(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a unique symmetric data key for use outside of KMS. This
  # operation returns a data key that is encrypted under a symmetric
  # encryption KMS key that you specify. The bytes in the key are random;
  # they are not related to the caller or to the KMS key.
  #
  # `GenerateDataKeyWithoutPlaintext` is identical to the GenerateDataKey
  # operation except that it does not return a plaintext copy of the data
  # key.
  #
  # This operation is useful for systems that need to encrypt data at some
  # point, but not immediately. When you need to encrypt the data, you
  # call the Decrypt operation on the encrypted copy of the key.
  #
  # It's also useful in distributed systems with different levels of
  # trust. For example, you might store encrypted data in containers. One
  # component of your system creates new containers and stores an
  # encrypted data key with each container. Then, a different component
  # puts the data into the containers. That component first decrypts the
  # data key, uses the plaintext data key to encrypt data, puts the
  # encrypted data into the container, and then destroys the plaintext
  # data key. In this system, the component that creates the containers
  # never sees the plaintext data key.
  #
  # To request an asymmetric data key pair, use the GenerateDataKeyPair or
  # GenerateDataKeyPairWithoutPlaintext operations.
  #
  # To generate a data key, you must specify the symmetric encryption KMS
  # key that is used to encrypt the data key. You cannot use an asymmetric
  # KMS key or a key in a custom key store to generate a data key. To get
  # the type of your KMS key, use the DescribeKey operation.
  #
  # You must also specify the length of the data key. Use either the
  # `KeySpec` or `NumberOfBytes` parameters (but not both). For 128-bit
  # and 256-bit data keys, use the `KeySpec` parameter.
  #
  # To generate an SM4 data key (China Regions only), specify a `KeySpec`
  # value of `AES_128` or `NumberOfBytes` value of `128`. The symmetric
  # encryption key used in China Regions to encrypt your data key is an
  # SM4 encryption key.
  #
  # If the operation succeeds, you will find the encrypted copy of the
  # data key in the `CiphertextBlob` field.
  #
  # You can use an optional encryption context to add additional security
  # to the encryption operation. If you specify an `EncryptionContext`,
  # you must specify the same encryption context (a case-sensitive exact
  # match) when decrypting the encrypted data key. Otherwise, the request
  # to decrypt fails with an `InvalidCiphertextException`. For more
  # information, see [Encryption Context][1] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GenerateDataKeyWithoutPlaintext][3]
  # (key policy)
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  # * GenerateDataKeyPairWithoutPlaintext
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate an encrypted data key
  #
  #   # The following example generates an encrypted copy of a 256-bit symmetric data encryption key (data key). The data key is
  #   # encrypted with the specified KMS key.
  #
  #   resp = client.generate_data_key_without_plaintext({
  #   key_id: "alias/ExampleAlias", # The identifier of the KMS key to use to encrypt the data key. You can use the key ID or Amazon Resource Name (ARN) of the KMS key, or the name or ARN of an alias that refers to the KMS key.
  #   key_spec: "AES_256", # Specifies the type of data key to return.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   ciphertext_blob: "<binary data>", # The encrypted data key.
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key that was used to encrypt the data key.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_data_key_without_plaintext({
  #   key_id: "KeyIdType", # required
  #   encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   key_spec: "AES_256", # accepts AES_256, AES_128
  #   number_of_bytes: 1,
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.ciphertext_blob #=> String
  #   resp.key_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload generate_data_key_without_plaintext
  # @param params [Hash] ({})
  # @return [Types::GenerateDataKeyWithoutPlaintextResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateDataKeyWithoutPlaintextResponse#ciphertext_blob #ciphertext_blob} => String
  #   * {Types::GenerateDataKeyWithoutPlaintextResponse#key_id #key_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyWithoutPlaintext AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#4794
  def generate_data_key_without_plaintext(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Generates a hash-based message authentication code (HMAC) for a
  # message using an HMAC KMS key and a MAC algorithm that the key
  # supports. HMAC KMS keys and the HMAC algorithms that KMS uses conform
  # to industry standards defined in [RFC 2104][1].
  #
  # You can use value that GenerateMac returns in the VerifyMac operation
  # to demonstrate that the original message has not changed. Also,
  # because a secret key is used to create the hash, you can verify that
  # the party that generated the hash has the required secret key. You can
  # also use the raw result to implement HMAC-based algorithms such as key
  # derivation functions. This operation is part of KMS support for HMAC
  # KMS keys. For details, see [HMAC keys in KMS][2] in the <i> <i>Key
  # Management Service Developer Guide</i> </i>.
  #
  # <note markdown="1"> Best practices recommend that you limit the time during which any
  # signing mechanism, including an HMAC, is effective. This deters an
  # attack where the actor uses a signed message to establish validity
  # repeatedly or long after the message is superseded. HMAC tags do not
  # include a timestamp, but you can include a timestamp in the token or
  # message to help you detect when its time to refresh the HMAC.
  #
  #  </note>
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GenerateMac][4] (key policy)
  #
  # **Related operations**\: VerifyMac
  #
  #
  #
  # [1]: https://datatracker.ietf.org/doc/html/rfc2104
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate an HMAC for a message
  #
  #   # This example generates an HMAC for a message, an HMAC KMS key, and a MAC algorithm. The algorithm must be supported by
  #   # the specified HMAC KMS key.
  #
  #   resp = client.generate_mac({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The HMAC KMS key input to the HMAC algorithm.
  #   mac_algorithm: "HMAC_SHA_384", # The HMAC algorithm requested for the operation.
  #   message: "Hello World", # The message input to the HMAC algorithm.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the HMAC KMS key used in the operation.
  #   mac: "<HMAC_TAG>", # The HMAC tag that results from this operation.
  #   mac_algorithm: "HMAC_SHA_384", # The HMAC algorithm used in the operation.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_mac({
  #   message: "data", # required
  #   key_id: "KeyIdType", # required
  #   mac_algorithm: "HMAC_SHA_224", # required, accepts HMAC_SHA_224, HMAC_SHA_256, HMAC_SHA_384, HMAC_SHA_512
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.mac #=> String
  #   resp.mac_algorithm #=> String, one of "HMAC_SHA_224", "HMAC_SHA_256", "HMAC_SHA_384", "HMAC_SHA_512"
  #   resp.key_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload generate_mac
  # @param params [Hash] ({})
  # @return [Types::GenerateMacResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateMacResponse#mac #mac} => String
  #   * {Types::GenerateMacResponse#mac_algorithm #mac_algorithm} => String
  #   * {Types::GenerateMacResponse#key_id #key_id} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateMac AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#4924
  def generate_mac(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a random byte string that is cryptographically secure.
  #
  # You must use the `NumberOfBytes` parameter to specify the length of
  # the random byte string. There is no default value for string length.
  #
  # By default, the random byte string is generated in KMS. To generate
  # the byte string in the CloudHSM cluster associated with an CloudHSM
  # key store, use the `CustomKeyStoreId` parameter.
  #
  # Applications in Amazon Web Services Nitro Enclaves can call this
  # operation by using the [Amazon Web Services Nitro Enclaves Development
  # Kit][1]. For information about the supporting parameters, see [How
  # Amazon Web Services Nitro Enclaves use KMS][2] in the *Key Management
  # Service Developer Guide*.
  #
  # For more information about entropy and random number generation, see
  # [Key Management Service Cryptographic Details][3].
  #
  # **Cross-account use**\: Not applicable. `GenerateRandom` does not use
  # any account-specific resources, such as KMS keys.
  #
  # **Required permissions**\: [kms:GenerateRandom][4] (IAM policy)
  #
  #
  #
  # [1]: https://github.com/aws/aws-nitro-enclaves-sdk-c
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html
  # [3]: https://docs.aws.amazon.com/kms/latest/cryptographic-details/
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To generate random data
  #
  #   # The following example generates 32 bytes of random data.
  #
  #   resp = client.generate_random({
  #   number_of_bytes: 32, # The length of the random data, specified in number of bytes.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   plaintext: "<binary data>", # The random data.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.generate_random({
  #   number_of_bytes: 1,
  #   custom_key_store_id: "CustomKeyStoreIdType",
  #   })
  # @example Response structure
  #
  #   resp.plaintext #=> String
  # @option params
  # @option params
  # @overload generate_random
  # @param params [Hash] ({})
  # @return [Types::GenerateRandomResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GenerateRandomResponse#plaintext #plaintext} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateRandom AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5004
  def generate_random(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a key policy attached to the specified KMS key.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:GetKeyPolicy][1] (key policy)
  #
  # **Related operations**\: PutKeyPolicy
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To retrieve a key policy
  #
  #   # The following example retrieves the key policy for the specified KMS key.
  #
  #   resp = client.get_key_policy({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose key policy you want to retrieve. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   policy_name: "default", # The name of the key policy to retrieve.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   policy: "{\n  \"Version\" : \"2012-10-17\",\n  \"Id\" : \"key-default-1\",\n  \"Statement\" : [ {\n    \"Sid\" : \"Enable IAM User Permissions\",\n    \"Effect\" : \"Allow\",\n    \"Principal\" : {\n      \"AWS\" : \"arn:aws:iam::111122223333:root\"\n    },\n    \"Action\" : \"kms:*\",\n    \"Resource\" : \"*\"\n  } ]\n}", # The key policy document.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_key_policy({
  #   key_id: "KeyIdType", # required
  #   policy_name: "PolicyNameType", # required
  #   })
  # @example Response structure
  #
  #   resp.policy #=> String
  # @option params
  # @option params
  # @overload get_key_policy
  # @param params [Hash] ({})
  # @return [Types::GetKeyPolicyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetKeyPolicyResponse#policy #policy} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyPolicy AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5075
  def get_key_policy(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a Boolean value that indicates whether [automatic rotation of the
  # key material][1] is enabled for the specified KMS key.
  #
  # When you enable automatic rotation for [customer managed KMS keys][2],
  # KMS rotates the key material of the KMS key one year (approximately
  # 365 days) from the enable date and every year thereafter. You can
  # monitor rotation of the key material for your KMS keys in CloudTrail
  # and Amazon CloudWatch.
  #
  # Automatic key rotation is supported only on [symmetric encryption KMS
  # keys][3]. You cannot enable automatic rotation of [asymmetric KMS
  # keys][4], [HMAC KMS keys][5], KMS keys with [imported key
  # material][6], or KMS keys in a [custom key store][7]. To enable or
  # disable automatic rotation of a set of related [multi-Region keys][8],
  # set the property on the primary key..
  #
  # You can enable (EnableKeyRotation) and disable automatic rotation
  # (DisableKeyRotation) of the key material in customer managed KMS keys.
  # Key material rotation of [Amazon Web Services managed KMS keys][9] is
  # not configurable. KMS always rotates the key material in Amazon Web
  # Services managed KMS keys every year. The key rotation status for
  # Amazon Web Services managed KMS keys is always `true`.
  #
  # <note markdown="1"> In May 2022, KMS changed the rotation schedule for Amazon Web Services
  # managed keys from every three years to every year. For details, see
  # EnableKeyRotation.
  #
  #  </note>
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][10] in the *Key
  # Management Service Developer Guide*.
  #
  # * Disabled: The key rotation status does not change when you disable a
  #   KMS key. However, while the KMS key is disabled, KMS does not rotate
  #   the key material. When you re-enable the KMS key, rotation resumes.
  #   If the key material in the re-enabled KMS key hasn't been rotated
  #   in one year, KMS rotates it immediately, and every year thereafter.
  #   If it's been less than a year since the key material in the
  #   re-enabled KMS key was rotated, the KMS key resumes its prior
  #   rotation schedule.
  #
  # * Pending deletion: While a KMS key is pending deletion, its key
  #   rotation status is `false` and KMS does not rotate the key material.
  #   If you cancel the deletion, the original key rotation status returns
  #   to `true`.
  #
  # **Cross-account use**\: Yes. To perform this operation on a KMS key in
  # a different Amazon Web Services account, specify the key ARN in the
  # value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GetKeyRotationStatus][11] (key policy)
  #
  # **Related operations:**
  #
  # * DisableKeyRotation
  #
  # * EnableKeyRotation
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [11]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To retrieve the rotation status for a KMS key
  #
  #   # The following example retrieves the status of automatic annual rotation of the key material for the specified KMS key.
  #
  #   resp = client.get_key_rotation_status({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose key material rotation status you want to retrieve. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_rotation_enabled: true, # A boolean that indicates the key material rotation status. Returns true when automatic annual rotation of the key material is enabled, or false when it is not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_key_rotation_status({
  #   key_id: "KeyIdType", # required
  #   })
  # @example Response structure
  #
  #   resp.key_rotation_enabled #=> Boolean
  # @option params
  # @overload get_key_rotation_status
  # @param params [Hash] ({})
  # @return [Types::GetKeyRotationStatusResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetKeyRotationStatusResponse#key_rotation_enabled #key_rotation_enabled} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatus AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5201
  def get_key_rotation_status(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the items you need to import key material into a symmetric
  # encryption KMS key. For more information about importing key material
  # into KMS, see [Importing key material][1] in the *Key Management
  # Service Developer Guide*.
  #
  # This operation returns a public key and an import token. Use the
  # public key to encrypt the symmetric key material. Store the import
  # token to send with a subsequent ImportKeyMaterial request.
  #
  # You must specify the key ID of the symmetric encryption KMS key into
  # which you will import key material. The KMS key `Origin` must be
  # `EXTERNAL`. You must also specify the wrapping algorithm and type of
  # wrapping key (public key) that you will use to encrypt the key
  # material. You cannot perform this operation on an asymmetric KMS key,
  # an HMAC KMS key, or on any KMS key in a different Amazon Web Services
  # account.
  #
  # To import key material, you must use the public key and import token
  # from the same response. These items are valid for 24 hours. The
  # expiration date and time appear in the `GetParametersForImport`
  # response. You cannot use an expired token in an ImportKeyMaterial
  # request. If your key and token expire, send another
  # `GetParametersForImport` request.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:GetParametersForImport][3] (key
  # policy)
  #
  # **Related operations:**
  #
  # * ImportKeyMaterial
  #
  # * DeleteImportedKeyMaterial
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To retrieve the public key and import token for a KMS key
  #
  #   # The following example retrieves the public key and import token for the specified KMS key.
  #
  #   resp = client.get_parameters_for_import({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key for which to retrieve the public key and import token. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   wrapping_algorithm: "RSAES_OAEP_SHA_1", # The algorithm that you will use to encrypt the key material before importing it.
  #   wrapping_key_spec: "RSA_2048", # The type of wrapping key (public key) to return in the response.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   import_token: "<binary data>", # The import token to send with a subsequent ImportKeyMaterial request.
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key for which you are retrieving the public key and import token. This is the same KMS key specified in the request.
  #   parameters_valid_to: Time.parse("2016-12-01T14:52:17-08:00"), # The time at which the import token and public key are no longer valid.
  #   public_key: "<binary data>", # The public key to use to encrypt the key material before importing it.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_parameters_for_import({
  #   key_id: "KeyIdType", # required
  #   wrapping_algorithm: "RSAES_PKCS1_V1_5", # required, accepts RSAES_PKCS1_V1_5, RSAES_OAEP_SHA_1, RSAES_OAEP_SHA_256
  #   wrapping_key_spec: "RSA_2048", # required, accepts RSA_2048
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.import_token #=> String
  #   resp.public_key #=> String
  #   resp.parameters_valid_to #=> Time
  # @option params
  # @option params
  # @option params
  # @overload get_parameters_for_import
  # @param params [Hash] ({})
  # @return [Types::GetParametersForImportResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetParametersForImportResponse#key_id #key_id} => String
  #   * {Types::GetParametersForImportResponse#import_token #import_token} => String
  #   * {Types::GetParametersForImportResponse#public_key #public_key} => String
  #   * {Types::GetParametersForImportResponse#parameters_valid_to #parameters_valid_to} => Time
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImport AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5327
  def get_parameters_for_import(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the public key of an asymmetric KMS key. Unlike the private
  # key of a asymmetric KMS key, which never leaves KMS unencrypted,
  # callers with `kms:GetPublicKey` permission can download the public key
  # of an asymmetric KMS key. You can share the public key to allow others
  # to encrypt messages and verify signatures outside of KMS. For
  # information about asymmetric KMS keys, see [Asymmetric KMS keys][1] in
  # the *Key Management Service Developer Guide*.
  #
  # You do not need to download the public key. Instead, you can use the
  # public key within KMS by calling the Encrypt, ReEncrypt, or Verify
  # operations with the identifier of an asymmetric KMS key. When you use
  # the public key within KMS, you benefit from the authentication,
  # authorization, and logging that are part of every KMS operation. You
  # also reduce of risk of encrypting data that cannot be decrypted. These
  # features are not effective outside of KMS.
  #
  # To help you use the public key safely outside of KMS, `GetPublicKey`
  # returns important information about the public key in the response,
  # including:
  #
  # * [KeySpec][2]\: The type of key material in the public key, such as
  #   `RSA_4096` or `ECC_NIST_P521`.
  #
  # * [KeyUsage][3]\: Whether the key is used for encryption or signing.
  #
  # * [EncryptionAlgorithms][4] or [SigningAlgorithms][5]\: A list of the
  #   encryption algorithms or the signing algorithms for the key.
  #
  # Although KMS cannot enforce these restrictions on external operations,
  # it is crucial that you use this information to prevent the public key
  # from being used improperly. For example, you can prevent a public
  # signing key from being used encrypt data, or prevent a public key from
  # being used with an encryption algorithm that is not supported by KMS.
  # You can also avoid errors, such as using the wrong signing algorithm
  # in a verification operation.
  #
  # To verify a signature outside of KMS with an SM2 public key (China
  # Regions only), you must specify the distinguishing ID. By default, KMS
  # uses `1234567812345678` as the distinguishing ID. For more
  # information, see [Offline verification with SM2 key pairs][6].
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][7] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:GetPublicKey][8] (key policy)
  #
  # **Related operations**\: CreateKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [2]: https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeySpec
  # [3]: https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage
  # [4]: https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms
  # [5]: https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To download the public key of an asymmetric KMS key
  #
  #   # This example gets the public key of an asymmetric RSA KMS key used for encryption and decryption. The operation returns
  #   # the key spec, key usage, and encryption or signing algorithms to help you use the public key correctly outside of AWS
  #   # KMS.
  #
  #   resp = client.get_public_key({
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321", # The key ARN of the asymmetric KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   customer_master_key_spec: "RSA_4096", # The key spec of the asymmetric KMS key from which the public key was downloaded.
  #   encryption_algorithms: [
  #   "RSAES_OAEP_SHA_1",
  #   "RSAES_OAEP_SHA_256",
  #   ], # The encryption algorithms supported by the asymmetric KMS key that was downloaded.
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321", # The key ARN of the asymmetric KMS key from which the public key was downloaded.
  #   key_usage: "ENCRYPT_DECRYPT", # The key usage of the asymmetric KMS key from which the public key was downloaded.
  #   public_key: "<binary data>", # The public key (plaintext) of the asymmetric KMS key.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_public_key({
  #   key_id: "KeyIdType", # required
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.public_key #=> String
  #   resp.customer_master_key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.key_usage #=> String, one of "SIGN_VERIFY", "ENCRYPT_DECRYPT", "GENERATE_VERIFY_MAC"
  #   resp.encryption_algorithms #=> Array
  #   resp.encryption_algorithms[0] #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  #   resp.signing_algorithms #=> Array
  #   resp.signing_algorithms[0] #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  # @option params
  # @option params
  # @overload get_public_key
  # @param params [Hash] ({})
  # @return [Types::GetPublicKeyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetPublicKeyResponse#key_id #key_id} => String
  #   * {Types::GetPublicKeyResponse#public_key #public_key} => String
  #   * {Types::GetPublicKeyResponse#customer_master_key_spec #customer_master_key_spec} => String
  #   * {Types::GetPublicKeyResponse#key_spec #key_spec} => String
  #   * {Types::GetPublicKeyResponse#key_usage #key_usage} => String
  #   * {Types::GetPublicKeyResponse#encryption_algorithms #encryption_algorithms} => Array&lt;String&gt;
  #   * {Types::GetPublicKeyResponse#signing_algorithms #signing_algorithms} => Array&lt;String&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5487
  def get_public_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Imports key material into an existing symmetric encryption KMS key
  # that was created without key material. After you successfully import
  # key material into a KMS key, you can [reimport the same key
  # material][1] into that KMS key, but you cannot import different key
  # material.
  #
  # You cannot perform this operation on an asymmetric KMS key, an HMAC
  # KMS key, or on any KMS key in a different Amazon Web Services account.
  # For more information about creating KMS keys with no key material and
  # then importing key material, see [Importing Key Material][2] in the
  # *Key Management Service Developer Guide*.
  #
  # Before using this operation, call GetParametersForImport. Its response
  # includes a public key and an import token. Use the public key to
  # encrypt the key material. Then, submit the import token from the same
  # `GetParametersForImport` response.
  #
  # When calling this operation, you must specify the following values:
  #
  # * The key ID or key ARN of a KMS key with no key material. Its
  #   `Origin` must be `EXTERNAL`.
  #
  #   To create a KMS key with no key material, call CreateKey and set the
  #   value of its `Origin` parameter to `EXTERNAL`. To get the `Origin`
  #   of a KMS key, call DescribeKey.)
  #
  # * The encrypted key material. To get the public key to encrypt the key
  #   material, call GetParametersForImport.
  #
  # * The import token that GetParametersForImport returned. You must use
  #   a public key and token from the same `GetParametersForImport`
  #   response.
  #
  # * Whether the key material expires (`ExpirationModel`) and, if so,
  #   when (`ValidTo`). If you set an expiration date, on the specified
  #   date, KMS deletes the key material from the KMS key, making the KMS
  #   key unusable. To use the KMS key in cryptographic operations again,
  #   you must reimport the same key material. The only way to change the
  #   expiration model or expiration date is by reimporting the same key
  #   material and specifying a new expiration date.
  #
  # When this operation is successful, the key state of the KMS key
  # changes from `PendingImport` to `Enabled`, and you can use the KMS
  # key.
  #
  # If this operation fails, use the exception to help determine the
  # problem. If the error is related to the key material, the import
  # token, or wrapping key, use GetParametersForImport to get a new public
  # key and import token for the KMS key and repeat the import procedure.
  # For help, see [How To Import Key Material][3] in the *Key Management
  # Service Developer Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:ImportKeyMaterial][5] (key policy)
  #
  # **Related operations:**
  #
  # * DeleteImportedKeyMaterial
  #
  # * GetParametersForImport
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#importing-keys-overview
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To import key material into a KMS key
  #
  #   # The following example imports key material into the specified KMS key.
  #
  #   resp = client.import_key_material({
  #   encrypted_key_material: "<binary data>", # The encrypted key material to import.
  #   expiration_model: "KEY_MATERIAL_DOES_NOT_EXPIRE", # A value that specifies whether the key material expires.
  #   import_token: "<binary data>", # The import token that you received in the response to a previous GetParametersForImport request.
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to import the key material into. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.import_key_material({
  #   key_id: "KeyIdType", # required
  #   import_token: "data", # required
  #   encrypted_key_material: "data", # required
  #   valid_to: Time.now,
  #   expiration_model: "KEY_MATERIAL_EXPIRES", # accepts KEY_MATERIAL_EXPIRES, KEY_MATERIAL_DOES_NOT_EXPIRE
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload import_key_material
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ImportKeyMaterial AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5658
  def import_key_material(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a list of aliases in the caller's Amazon Web Services account
  # and region. For more information about aliases, see CreateAlias.
  #
  # By default, the `ListAliases` operation returns all aliases in the
  # account and region. To get only the aliases associated with a
  # particular KMS key, use the `KeyId` parameter.
  #
  # The `ListAliases` response can include aliases that you created and
  # associated with your customer managed keys, and aliases that Amazon
  # Web Services created and associated with Amazon Web Services managed
  # keys in your account. You can recognize Amazon Web Services aliases
  # because their names have the format `aws/<service-name>`, such as
  # `aws/dynamodb`.
  #
  # The response might also include aliases that have no `TargetKeyId`
  # field. These are predefined aliases that Amazon Web Services has
  # created but has not yet associated with a KMS key. Aliases that Amazon
  # Web Services creates in your account, including predefined aliases, do
  # not count against your [KMS aliases quota][1].
  #
  # **Cross-account use**\: No. `ListAliases` does not return aliases in
  # other Amazon Web Services accounts.
  #
  # **Required permissions**\: [kms:ListAliases][2] (IAM policy)
  #
  # For details, see [Controlling access to aliases][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * CreateAlias
  #
  # * DeleteAlias
  #
  # * UpdateAlias
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list aliases
  #
  #   # The following example lists aliases.
  #
  #   resp = client.list_aliases({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   aliases: [
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/aws/acm",
  #   alias_name: "alias/aws/acm",
  #   target_key_id: "da03f6f7-d279-427a-9cae-de48d07e5b66",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/aws/ebs",
  #   alias_name: "alias/aws/ebs",
  #   target_key_id: "25a217e7-7170-4b8c-8bf6-045ea5f70e5b",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/aws/rds",
  #   alias_name: "alias/aws/rds",
  #   target_key_id: "7ec3104e-c3f2-4b5c-bf42-bfc4772c6685",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/aws/redshift",
  #   alias_name: "alias/aws/redshift",
  #   target_key_id: "08f7a25a-69e2-4fb5-8f10-393db27326fa",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/aws/s3",
  #   alias_name: "alias/aws/s3",
  #   target_key_id: "d2b0f1a3-580d-4f79-b836-bc983be8cfa5",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/example1",
  #   alias_name: "alias/example1",
  #   target_key_id: "4da1e216-62d0-46c5-a7c0-5f3a3d2f8046",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/example2",
  #   alias_name: "alias/example2",
  #   target_key_id: "f32fef59-2cc2-445b-8573-2d73328acbee",
  #   },
  #   {
  #   alias_arn: "arn:aws:kms:us-east-2:111122223333:alias/example3",
  #   alias_name: "alias/example3",
  #   target_key_id: "1374ef38-d34e-4d5f-b2c9-4e0daee38855",
  #   },
  #   ], # A list of aliases, including the key ID of the KMS key that each alias refers to.
  #   truncated: false, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_aliases({
  #   key_id: "KeyIdType",
  #   limit: 1,
  #   marker: "MarkerType",
  #   })
  # @example Response structure
  #
  #   resp.aliases #=> Array
  #   resp.aliases[0].alias_name #=> String
  #   resp.aliases[0].alias_arn #=> String
  #   resp.aliases[0].target_key_id #=> String
  #   resp.aliases[0].creation_date #=> Time
  #   resp.aliases[0].last_updated_date #=> Time
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @overload list_aliases
  # @param params [Hash] ({})
  # @return [Types::ListAliasesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListAliasesResponse#aliases #aliases} => Array&lt;Types::AliasListEntry&gt;
  #   * {Types::ListAliasesResponse#next_marker #next_marker} => String
  #   * {Types::ListAliasesResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListAliases AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#5823
  def list_aliases(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a list of all grants for the specified KMS key.
  #
  # You must specify the KMS key in all requests. You can filter the grant
  # list by grant ID or grantee principal.
  #
  # For detailed information about grants, including grant terminology,
  # see [Grants in KMS][1] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>. For examples of working with grants in several
  # programming languages, see [Programming grants][2].
  #
  # <note markdown="1"> The `GranteePrincipal` field in the `ListGrants` response usually
  # contains the user or role designated as the grantee principal in the
  # grant. However, when the grantee principal in the grant is an Amazon
  # Web Services service, the `GranteePrincipal` field contains the
  # [service principal][3], which might represent several different
  # grantee principals.
  #
  #  </note>
  #
  # **Cross-account use**\: Yes. To perform this operation on a KMS key in
  # a different Amazon Web Services account, specify the key ARN in the
  # value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:ListGrants][4] (key policy)
  #
  # **Related operations:**
  #
  # * CreateGrant
  #
  # * ListRetirableGrants
  #
  # * RetireGrant
  #
  # * RevokeGrant
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html
  # [3]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list grants for a KMS key
  #
  #   # The following example lists grants for the specified KMS key.
  #
  #   resp = client.list_grants({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose grants you want to list. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   grants: [
  #   {
  #   creation_date: Time.parse("2016-10-25T14:37:41-07:00"),
  #   grant_id: "91ad875e49b04a9d1f3bdeb84d821f9db6ea95e1098813f6d47f0c65fbe2a172",
  #   grantee_principal: "acm.us-east-2.amazonaws.com",
  #   issuing_account: "arn:aws:iam::111122223333:root",
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   operations: [
  #   "Encrypt",
  #   "ReEncryptFrom",
  #   "ReEncryptTo",
  #   ],
  #   retiring_principal: "acm.us-east-2.amazonaws.com",
  #   },
  #   {
  #   creation_date: Time.parse("2016-10-25T14:37:41-07:00"),
  #   grant_id: "a5d67d3e207a8fc1f4928749ee3e52eb0440493a8b9cf05bbfad91655b056200",
  #   grantee_principal: "acm.us-east-2.amazonaws.com",
  #   issuing_account: "arn:aws:iam::111122223333:root",
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   operations: [
  #   "ReEncryptFrom",
  #   "ReEncryptTo",
  #   ],
  #   retiring_principal: "acm.us-east-2.amazonaws.com",
  #   },
  #   {
  #   creation_date: Time.parse("2016-10-25T14:37:41-07:00"),
  #   grant_id: "c541aaf05d90cb78846a73b346fc43e65be28b7163129488c738e0c9e0628f4f",
  #   grantee_principal: "acm.us-east-2.amazonaws.com",
  #   issuing_account: "arn:aws:iam::111122223333:root",
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   operations: [
  #   "Encrypt",
  #   "ReEncryptFrom",
  #   "ReEncryptTo",
  #   ],
  #   retiring_principal: "acm.us-east-2.amazonaws.com",
  #   },
  #   {
  #   creation_date: Time.parse("2016-10-25T14:37:41-07:00"),
  #   grant_id: "dd2052c67b4c76ee45caf1dc6a1e2d24e8dc744a51b36ae2f067dc540ce0105c",
  #   grantee_principal: "acm.us-east-2.amazonaws.com",
  #   issuing_account: "arn:aws:iam::111122223333:root",
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   operations: [
  #   "Encrypt",
  #   "ReEncryptFrom",
  #   "ReEncryptTo",
  #   ],
  #   retiring_principal: "acm.us-east-2.amazonaws.com",
  #   },
  #   ], # A list of grants.
  #   truncated: true, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_grants({
  #   limit: 1,
  #   marker: "MarkerType",
  #   key_id: "KeyIdType", # required
  #   grant_id: "GrantIdType",
  #   grantee_principal: "PrincipalIdType",
  #   })
  # @example Response structure
  #
  #   resp.grants #=> Array
  #   resp.grants[0].key_id #=> String
  #   resp.grants[0].grant_id #=> String
  #   resp.grants[0].name #=> String
  #   resp.grants[0].creation_date #=> Time
  #   resp.grants[0].grantee_principal #=> String
  #   resp.grants[0].retiring_principal #=> String
  #   resp.grants[0].issuing_account #=> String
  #   resp.grants[0].operations #=> Array
  #   resp.grants[0].operations[0] #=> String, one of "Decrypt", "Encrypt", "GenerateDataKey", "GenerateDataKeyWithoutPlaintext", "ReEncryptFrom", "ReEncryptTo", "Sign", "Verify", "GetPublicKey", "CreateGrant", "RetireGrant", "DescribeKey", "GenerateDataKeyPair", "GenerateDataKeyPairWithoutPlaintext", "GenerateMac", "VerifyMac"
  #   resp.grants[0].constraints.encryption_context_subset #=> Hash
  #   resp.grants[0].constraints.encryption_context_subset["EncryptionContextKey"] #=> String
  #   resp.grants[0].constraints.encryption_context_equals #=> Hash
  #   resp.grants[0].constraints.encryption_context_equals["EncryptionContextKey"] #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_grants
  # @param params [Hash] ({})
  # @return [Types::ListGrantsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListGrantsResponse#grants #grants} => Array&lt;Types::GrantListEntry&gt;
  #   * {Types::ListGrantsResponse#next_marker #next_marker} => String
  #   * {Types::ListGrantsResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListGrants AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6016
  def list_grants(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets the names of the key policies that are attached to a KMS key.
  # This operation is designed to get policy names that you can use in a
  # GetKeyPolicy operation. However, the only valid policy name is
  # `default`.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:ListKeyPolicies][1] (key policy)
  #
  # **Related operations:**
  #
  # * GetKeyPolicy
  #
  # * PutKeyPolicy
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list key policies for a KMS key
  #
  #   # The following example lists key policies for the specified KMS key.
  #
  #   resp = client.list_key_policies({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose key policies you want to list. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   policy_names: [
  #   "default",
  #   ], # A list of key policy names.
  #   truncated: false, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_key_policies({
  #   key_id: "KeyIdType", # required
  #   limit: 1,
  #   marker: "MarkerType",
  #   })
  # @example Response structure
  #
  #   resp.policy_names #=> Array
  #   resp.policy_names[0] #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @overload list_key_policies
  # @param params [Hash] ({})
  # @return [Types::ListKeyPoliciesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListKeyPoliciesResponse#policy_names #policy_names} => Array&lt;String&gt;
  #   * {Types::ListKeyPoliciesResponse#next_marker #next_marker} => String
  #   * {Types::ListKeyPoliciesResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeyPolicies AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6116
  def list_key_policies(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Gets a list of all KMS keys in the caller's Amazon Web Services
  # account and Region.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:ListKeys][1] (IAM policy)
  #
  # **Related operations:**
  #
  # * CreateKey
  #
  # * DescribeKey
  #
  # * ListAliases
  #
  # * ListResourceTags
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list KMS keys
  #
  #   # The following example lists KMS keys.
  #
  #   resp = client.list_keys({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   keys: [
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/0d990263-018e-4e65-a703-eff731de951e",
  #   key_id: "0d990263-018e-4e65-a703-eff731de951e",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/144be297-0ae1-44ac-9c8f-93cd8c82f841",
  #   key_id: "144be297-0ae1-44ac-9c8f-93cd8c82f841",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/21184251-b765-428e-b852-2c7353e72571",
  #   key_id: "21184251-b765-428e-b852-2c7353e72571",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/214fe92f-5b03-4ae1-b350-db2a45dbe10c",
  #   key_id: "214fe92f-5b03-4ae1-b350-db2a45dbe10c",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/339963f2-e523-49d3-af24-a0fe752aa458",
  #   key_id: "339963f2-e523-49d3-af24-a0fe752aa458",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/b776a44b-df37-4438-9be4-a27494e4271a",
  #   key_id: "b776a44b-df37-4438-9be4-a27494e4271a",
  #   },
  #   {
  #   key_arn: "arn:aws:kms:us-east-2:111122223333:key/deaf6c9e-cf2c-46a6-bf6d-0b6d487cffbb",
  #   key_id: "deaf6c9e-cf2c-46a6-bf6d-0b6d487cffbb",
  #   },
  #   ], # A list of KMS keys, including the key ID and Amazon Resource Name (ARN) of each one.
  #   truncated: false, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_keys({
  #   limit: 1,
  #   marker: "MarkerType",
  #   })
  # @example Response structure
  #
  #   resp.keys #=> Array
  #   resp.keys[0].key_id #=> String
  #   resp.keys[0].key_arn #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @overload list_keys
  # @param params [Hash] ({})
  # @return [Types::ListKeysResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListKeysResponse#keys #keys} => Array&lt;Types::KeyListEntry&gt;
  #   * {Types::ListKeysResponse#next_marker #next_marker} => String
  #   * {Types::ListKeysResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeys AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6227
  def list_keys(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns all tags on the specified KMS key.
  #
  # For general information about tags, including the format and syntax,
  # see [Tagging Amazon Web Services resources][1] in the *Amazon Web
  # Services General Reference*. For information about using tags in KMS,
  # see [Tagging keys][2].
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:ListResourceTags][3] (key policy)
  #
  # **Related operations:**
  #
  # * CreateKey
  #
  # * ReplicateKey
  #
  # * TagResource
  #
  # * UntagResource
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list tags for a KMS key
  #
  #   # The following example lists tags for a KMS key.
  #
  #   resp = client.list_resource_tags({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose tags you are listing. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   tags: [
  #   {
  #   tag_key: "CostCenter",
  #   tag_value: "87654",
  #   },
  #   {
  #   tag_key: "CreatedBy",
  #   tag_value: "ExampleUser",
  #   },
  #   {
  #   tag_key: "Purpose",
  #   tag_value: "Test",
  #   },
  #   ], # A list of tags.
  #   truncated: false, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_resource_tags({
  #   key_id: "KeyIdType", # required
  #   limit: 1,
  #   marker: "MarkerType",
  #   })
  # @example Response structure
  #
  #   resp.tags #=> Array
  #   resp.tags[0].tag_key #=> String
  #   resp.tags[0].tag_value #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @overload list_resource_tags
  # @param params [Hash] ({})
  # @return [Types::ListResourceTagsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListResourceTagsResponse#tags #tags} => Array&lt;Types::Tag&gt;
  #   * {Types::ListResourceTagsResponse#next_marker #next_marker} => String
  #   * {Types::ListResourceTagsResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListResourceTags AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6347
  def list_resource_tags(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns information about all grants in the Amazon Web Services
  # account and Region that have the specified retiring principal.
  #
  # You can specify any principal in your Amazon Web Services account. The
  # grants that are returned include grants for KMS keys in your Amazon
  # Web Services account and other Amazon Web Services accounts. You might
  # use this operation to determine which grants you may retire. To retire
  # a grant, use the RetireGrant operation.
  #
  # For detailed information about grants, including grant terminology,
  # see [Grants in KMS][1] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>. For examples of working with grants in several
  # programming languages, see [Programming grants][2].
  #
  # **Cross-account use**\: You must specify a principal in your Amazon
  # Web Services account. However, this operation can return grants in any
  # Amazon Web Services account. You do not need `kms:ListRetirableGrants`
  # permission (or any other additional permission) in any Amazon Web
  # Services account other than your own.
  #
  # **Required permissions**\: [kms:ListRetirableGrants][3] (IAM policy)
  # in your Amazon Web Services account.
  #
  # **Related operations:**
  #
  # * CreateGrant
  #
  # * ListGrants
  #
  # * RetireGrant
  #
  # * RevokeGrant
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Example: To list grants that the specified principal can retire
  #
  #   # The following example lists the grants that the specified principal (identity) can retire.
  #
  #   resp = client.list_retirable_grants({
  #   retiring_principal: "arn:aws:iam::111122223333:role/ExampleRole", # The retiring principal whose grants you want to list. Use the Amazon Resource Name (ARN) of a principal such as an AWS account (root), IAM user, federated user, or assumed role user.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   grants: [
  #   {
  #   creation_date: Time.parse("2016-12-07T11:09:35-08:00"),
  #   grant_id: "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
  #   grantee_principal: "arn:aws:iam::111122223333:role/ExampleRole",
  #   issuing_account: "arn:aws:iam::444455556666:root",
  #   key_id: "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  #   operations: [
  #   "Decrypt",
  #   "Encrypt",
  #   ],
  #   retiring_principal: "arn:aws:iam::111122223333:role/ExampleRole",
  #   },
  #   ], # A list of grants that the specified principal can retire.
  #   truncated: false, # A boolean that indicates whether there are more items in the list. Returns true when there are more items, or false when there are not.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_retirable_grants({
  #   limit: 1,
  #   marker: "MarkerType",
  #   retiring_principal: "PrincipalIdType", # required
  #   })
  # @example Response structure
  #
  #   resp.grants #=> Array
  #   resp.grants[0].key_id #=> String
  #   resp.grants[0].grant_id #=> String
  #   resp.grants[0].name #=> String
  #   resp.grants[0].creation_date #=> Time
  #   resp.grants[0].grantee_principal #=> String
  #   resp.grants[0].retiring_principal #=> String
  #   resp.grants[0].issuing_account #=> String
  #   resp.grants[0].operations #=> Array
  #   resp.grants[0].operations[0] #=> String, one of "Decrypt", "Encrypt", "GenerateDataKey", "GenerateDataKeyWithoutPlaintext", "ReEncryptFrom", "ReEncryptTo", "Sign", "Verify", "GetPublicKey", "CreateGrant", "RetireGrant", "DescribeKey", "GenerateDataKeyPair", "GenerateDataKeyPairWithoutPlaintext", "GenerateMac", "VerifyMac"
  #   resp.grants[0].constraints.encryption_context_subset #=> Hash
  #   resp.grants[0].constraints.encryption_context_subset["EncryptionContextKey"] #=> String
  #   resp.grants[0].constraints.encryption_context_equals #=> Hash
  #   resp.grants[0].constraints.encryption_context_equals["EncryptionContextKey"] #=> String
  #   resp.next_marker #=> String
  #   resp.truncated #=> Boolean
  # @option params
  # @option params
  # @option params
  # @overload list_retirable_grants
  # @param params [Hash] ({})
  # @return [Types::ListGrantsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListGrantsResponse#grants #grants} => Array&lt;Types::GrantListEntry&gt;
  #   * {Types::ListGrantsResponse#next_marker #next_marker} => String
  #   * {Types::ListGrantsResponse#truncated #truncated} => Boolean
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListRetirableGrants AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6488
  def list_retirable_grants(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Attaches a key policy to the specified KMS key.
  #
  # For more information about key policies, see [Key Policies][1] in the
  # *Key Management Service Developer Guide*. For help writing and
  # formatting a JSON policy document, see the [IAM JSON Policy
  # Reference][2] in the <i> <i>Identity and Access Management User
  # Guide</i> </i>. For examples of adding a key policy in multiple
  # programming languages, see [Setting a key policy][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:PutKeyPolicy][4] (key policy)
  #
  # **Related operations**\: GetKeyPolicy
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-key-policies.html#put-policy
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To attach a key policy to a KMS key
  #
  #   # The following example attaches a key policy to the specified KMS key.
  #
  #   resp = client.put_key_policy({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to attach the key policy to. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   policy: "{\"Version\":\"2012-10-17\",\"Id\":\"custom-policy-2016-12-07\",\"Statement\":[{\"Sid\":\"EnableIAMUserPermissions\",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":\"arn:aws:iam::111122223333:root\"},\"Action\":\"kms:*\",\"Resource\":\"*\"},{\"Sid\":\"AllowaccessforKeyAdministrators\",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"arn:aws:iam::111122223333:user/ExampleAdminUser\",\"arn:aws:iam::111122223333:role/ExampleAdminRole\"]},\"Action\":[\"kms:Create*\",\"kms:Describe*\",\"kms:Enable*\",\"kms:List*\",\"kms:Put*\",\"kms:Update*\",\"kms:Revoke*\",\"kms:Disable*\",\"kms:Get*\",\"kms:Delete*\",\"kms:ScheduleKeyDeletion\",\"kms:CancelKeyDeletion\"],\"Resource\":\"*\"},{\"Sid\":\"Allowuseofthekey\",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":\"arn:aws:iam::111122223333:role/ExamplePowerUserRole\"},\"Action\":[\"kms:Encrypt\",\"kms:Decrypt\",\"kms:ReEncrypt*\",\"kms:GenerateDataKey*\",\"kms:DescribeKey\"],\"Resource\":\"*\"},{\"Sid\":\"Allowattachmentofpersistentresources\",\"Effect\":\"Allow\",\"Principal\":{\"AWS\":\"arn:aws:iam::111122223333:role/ExamplePowerUserRole\"},\"Action\":[\"kms:CreateGrant\",\"kms:ListGrants\",\"kms:RevokeGrant\"],\"Resource\":\"*\",\"Condition\":{\"Bool\":{\"kms:GrantIsForAWSResource\":\"true\"}}}]}", # The key policy document.
  #   policy_name: "default", # The name of the key policy.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.put_key_policy({
  #   key_id: "KeyIdType", # required
  #   policy_name: "PolicyNameType", # required
  #   policy: "PolicyType", # required
  #   bypass_policy_lockout_safety_check: false,
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload put_key_policy
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/PutKeyPolicy AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6627
  def put_key_policy(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Decrypts ciphertext and then reencrypts it entirely within KMS. You
  # can use this operation to change the KMS key under which data is
  # encrypted, such as when you [manually rotate][1] a KMS key or change
  # the KMS key that protects a ciphertext. You can also use it to
  # reencrypt ciphertext under the same KMS key, such as to change the
  # [encryption context][2] of a ciphertext.
  #
  # The `ReEncrypt` operation can decrypt ciphertext that was encrypted by
  # using a KMS key in an KMS operation, such as Encrypt or
  # GenerateDataKey. It can also decrypt ciphertext that was encrypted by
  # using the public key of an [asymmetric KMS key][3] outside of KMS.
  # However, it cannot decrypt ciphertext produced by other libraries,
  # such as the [Amazon Web Services Encryption SDK][4] or [Amazon S3
  # client-side encryption][5]. These libraries return a ciphertext format
  # that is incompatible with KMS.
  #
  # When you use the `ReEncrypt` operation, you need to provide
  # information for the decrypt operation and the subsequent encrypt
  # operation.
  #
  # * If your ciphertext was encrypted under an asymmetric KMS key, you
  #   must use the `SourceKeyId` parameter to identify the KMS key that
  #   encrypted the ciphertext. You must also supply the encryption
  #   algorithm that was used. This information is required to decrypt the
  #   data.
  #
  # * If your ciphertext was encrypted under a symmetric encryption KMS
  #   key, the `SourceKeyId` parameter is optional. KMS can get this
  #   information from metadata that it adds to the symmetric ciphertext
  #   blob. This feature adds durability to your implementation by
  #   ensuring that authorized users can decrypt ciphertext decades after
  #   it was encrypted, even if they've lost track of the key ID.
  #   However, specifying the source KMS key is always recommended as a
  #   best practice. When you use the `SourceKeyId` parameter to specify a
  #   KMS key, KMS uses only the KMS key you specify. If the ciphertext
  #   was encrypted under a different KMS key, the `ReEncrypt` operation
  #   fails. This practice ensures that you use the KMS key that you
  #   intend.
  #
  # * To reencrypt the data, you must use the `DestinationKeyId` parameter
  #   to specify the KMS key that re-encrypts the data after it is
  #   decrypted. If the destination KMS key is an asymmetric KMS key, you
  #   must also provide the encryption algorithm. The algorithm that you
  #   choose must be compatible with the KMS key.
  #
  #   When you use an asymmetric KMS key to encrypt or reencrypt data, be
  #   sure to record the KMS key and encryption algorithm that you choose.
  #   You will be required to provide the same KMS key and encryption
  #   algorithm when you decrypt the data. If the KMS key and algorithm do
  #   not match the values used to encrypt the data, the decrypt operation
  #   fails.
  #
  #    You are not required to supply the key ID and encryption algorithm
  #   when you decrypt with symmetric encryption KMS keys because KMS
  #   stores this information in the ciphertext blob. KMS cannot store
  #   metadata in ciphertext generated with asymmetric keys. The standard
  #   format for asymmetric key ciphertext does not include configurable
  #   fields.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][6] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. The source KMS key and destination KMS
  # key can be in different Amazon Web Services accounts. Either or both
  # KMS keys can be in a different account than the caller. To specify a
  # KMS key in a different account, you must use its key ARN or alias ARN.
  #
  # **Required permissions**\:
  #
  # * [kms:ReEncryptFrom][7] permission on the source KMS key (key policy)
  #
  # * [kms:ReEncryptTo][7] permission on the destination KMS key (key
  #   policy)
  #
  # To permit reencryption from or to a KMS key, include the
  # `"kms:ReEncrypt*"` permission in your [key policy][8]. This permission
  # is automatically included in the key policy when you use the console
  # to create a KMS key. But you must include it manually when you create
  # a KMS key programmatically or when you use the PutKeyPolicy operation
  # to set a key policy.
  #
  # **Related operations:**
  #
  # * Decrypt
  #
  # * Encrypt
  #
  # * GenerateDataKey
  #
  # * GenerateDataKeyPair
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-manually
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks
  # [4]: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/
  # [5]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
  #
  # @example Example: To reencrypt data
  #
  #   # The following example reencrypts data with the specified KMS key.
  #
  #   resp = client.re_encrypt({
  #   ciphertext_blob: "<binary data>", # The data to reencrypt.
  #   destination_key_id: "0987dcba-09fe-87dc-65ba-ab0987654321", # The identifier of the KMS key to use to reencrypt the data. You can use any valid key identifier.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   ciphertext_blob: "<binary data>", # The reencrypted data.
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321", # The ARN of the KMS key that was used to reencrypt the data.
  #   source_key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key that was originally used to encrypt the data.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.re_encrypt({
  #   ciphertext_blob: "data", # required
  #   source_encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   source_key_id: "KeyIdType",
  #   destination_key_id: "KeyIdType", # required
  #   destination_encryption_context: {
  #   "EncryptionContextKey" => "EncryptionContextValue",
  #   },
  #   source_encryption_algorithm: "SYMMETRIC_DEFAULT", # accepts SYMMETRIC_DEFAULT, RSAES_OAEP_SHA_1, RSAES_OAEP_SHA_256, SM2PKE
  #   destination_encryption_algorithm: "SYMMETRIC_DEFAULT", # accepts SYMMETRIC_DEFAULT, RSAES_OAEP_SHA_1, RSAES_OAEP_SHA_256, SM2PKE
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.ciphertext_blob #=> String
  #   resp.source_key_id #=> String
  #   resp.key_id #=> String
  #   resp.source_encryption_algorithm #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  #   resp.destination_encryption_algorithm #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload re_encrypt
  # @param params [Hash] ({})
  # @return [Types::ReEncryptResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ReEncryptResponse#ciphertext_blob #ciphertext_blob} => String
  #   * {Types::ReEncryptResponse#source_key_id #source_key_id} => String
  #   * {Types::ReEncryptResponse#key_id #key_id} => String
  #   * {Types::ReEncryptResponse#source_encryption_algorithm #source_encryption_algorithm} => String
  #   * {Types::ReEncryptResponse#destination_encryption_algorithm #destination_encryption_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReEncrypt AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#6928
  def re_encrypt(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Replicates a multi-Region key into the specified Region. This
  # operation creates a multi-Region replica key based on a multi-Region
  # primary key in a different Region of the same Amazon Web Services
  # partition. You can create multiple replicas of a primary key, but each
  # must be in a different Region. To create a multi-Region primary key,
  # use the CreateKey operation.
  #
  # This operation supports *multi-Region keys*, an KMS feature that lets
  # you create multiple interoperable KMS keys in different Amazon Web
  # Services Regions. Because these KMS keys have the same key ID, key
  # material, and other metadata, you can use them interchangeably to
  # encrypt data in one Amazon Web Services Region and decrypt it in a
  # different Amazon Web Services Region without re-encrypting the data or
  # making a cross-Region call. For more information about multi-Region
  # keys, see [Multi-Region keys in KMS][1] in the *Key Management Service
  # Developer Guide*.
  #
  # A *replica key* is a fully-functional KMS key that can be used
  # independently of its primary and peer replica keys. A primary key and
  # its replica keys share properties that make them interoperable. They
  # have the same [key ID][2] and key material. They also have the same
  # [key spec][3], [key usage][4], [key material origin][5], and
  # [automatic key rotation status][6]. KMS automatically synchronizes
  # these shared properties among related multi-Region keys. All other
  # properties of a replica key can differ, including its [key policy][7],
  # [tags][8], [aliases][9], and [Key states of KMS keys][10]. KMS pricing
  # and quotas for KMS keys apply to each primary key and replica key.
  #
  # When this operation completes, the new replica key has a transient key
  # state of `Creating`. This key state changes to `Enabled` (or
  # `PendingImport`) after a few seconds when the process of creating the
  # new replica key is complete. While the key state is `Creating`, you
  # can manage key, but you cannot yet use it in cryptographic operations.
  # If you are creating and using the replica key programmatically, retry
  # on `KMSInvalidStateException` or call `DescribeKey` to check its
  # `KeyState` value before using it. For details about the `Creating` key
  # state, see [Key states of KMS keys][10] in the *Key Management Service
  # Developer Guide*.
  #
  # You cannot create more than one replica of a primary key in any
  # Region. If the Region already includes a replica of the key you're
  # trying to replicate, `ReplicateKey` returns an
  # `AlreadyExistsException` error. If the key state of the existing
  # replica is `PendingDeletion`, you can cancel the scheduled key
  # deletion (CancelKeyDeletion) or wait for the key to be deleted. The
  # new replica key you create will have the same [shared properties][11]
  # as the original replica key.
  #
  # The CloudTrail log of a `ReplicateKey` operation records a
  # `ReplicateKey` operation in the primary key's Region and a CreateKey
  # operation in the replica key's Region.
  #
  # If you replicate a multi-Region primary key with imported key
  # material, the replica key is created with no key material. You must
  # import the same key material that you imported into the primary key.
  # For details, see [Importing key material into multi-Region
  # keys](kms/latest/developerguide/multi-region-keys-import.html) in the
  # *Key Management Service Developer Guide*.
  #
  # To convert a replica key to a primary key, use the UpdatePrimaryRegion
  # operation.
  #
  # <note markdown="1"> `ReplicateKey` uses different default values for the `KeyPolicy` and
  # `Tags` parameters than those used in the KMS console. For details, see
  # the parameter descriptions.
  #
  #  </note>
  #
  # **Cross-account use**\: No. You cannot use this operation to create a
  # replica key in a different Amazon Web Services account.
  #
  # **Required permissions**\:
  #
  # * `kms:ReplicateKey` on the primary key (in the primary key's
  #   Region). Include this permission in the primary key's key policy.
  #
  # * `kms:CreateKey` in an IAM policy in the replica Region.
  #
  # * To use the `Tags` parameter, `kms:TagResource` in an IAM policy in
  #   the replica Region.
  #
  # **Related operations**
  #
  # * CreateKey
  #
  # * UpdatePrimaryRegion
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
  # [8]: https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [11]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-sync-properties
  #
  # @example Example: To replicate a multi-Region key in a different AWS Region
  #
  #   # This example creates a multi-Region replica key in us-west-2 of a multi-Region primary key in us-east-1.
  #
  #   resp = client.replicate_key({
  #   key_id: "arn:aws:kms:us-east-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab", # The key ID or key ARN of the multi-Region primary key
  #   replica_region: "us-west-2", # The Region of the new replica.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   replica_key_metadata: {
  #   aws_account_id: "111122223333",
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   creation_date: Time.parse(1607472987.918),
  #   customer_master_key_spec: "SYMMETRIC_DEFAULT",
  #   description: "",
  #   enabled: true,
  #   encryption_algorithms: [
  #   "SYMMETRIC_DEFAULT",
  #   ],
  #   key_id: "mrk-1234abcd12ab34cd56ef1234567890ab",
  #   key_manager: "CUSTOMER",
  #   key_state: "Enabled",
  #   key_usage: "ENCRYPT_DECRYPT",
  #   multi_region: true,
  #   multi_region_configuration: {
  #   multi_region_key_type: "REPLICA",
  #   primary_key: {
  #   arn: "arn:aws:kms:us-east-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "us-east-1",
  #   },
  #   replica_keys: [
  #   {
  #   arn: "arn:aws:kms:us-west-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab",
  #   region: "us-west-2",
  #   },
  #   ],
  #   },
  #   origin: "AWS_KMS",
  #   }, # An object that displays detailed information about the replica key.
  #   replica_policy: "{\n  \"Version\" : \"2012-10-17\",\n  \"Id\" : \"key-default-1\",...}", # The key policy of the replica key. If you don't specify a key policy, the replica key gets the default key policy for a KMS key.
  #   replica_tags: [
  #   ], # The tags on the replica key, if any.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.replicate_key({
  #   key_id: "KeyIdType", # required
  #   replica_region: "RegionType", # required
  #   policy: "PolicyType",
  #   bypass_policy_lockout_safety_check: false,
  #   description: "DescriptionType",
  #   tags: [
  #   {
  #   tag_key: "TagKeyType", # required
  #   tag_value: "TagValueType", # required
  #   },
  #   ],
  #   })
  # @example Response structure
  #
  #   resp.replica_key_metadata.aws_account_id #=> String
  #   resp.replica_key_metadata.key_id #=> String
  #   resp.replica_key_metadata.arn #=> String
  #   resp.replica_key_metadata.creation_date #=> Time
  #   resp.replica_key_metadata.enabled #=> Boolean
  #   resp.replica_key_metadata.description #=> String
  #   resp.replica_key_metadata.key_usage #=> String, one of "SIGN_VERIFY", "ENCRYPT_DECRYPT", "GENERATE_VERIFY_MAC"
  #   resp.replica_key_metadata.key_state #=> String, one of "Creating", "Enabled", "Disabled", "PendingDeletion", "PendingImport", "PendingReplicaDeletion", "Unavailable", "Updating"
  #   resp.replica_key_metadata.deletion_date #=> Time
  #   resp.replica_key_metadata.valid_to #=> Time
  #   resp.replica_key_metadata.origin #=> String, one of "AWS_KMS", "EXTERNAL", "AWS_CLOUDHSM", "EXTERNAL_KEY_STORE"
  #   resp.replica_key_metadata.custom_key_store_id #=> String
  #   resp.replica_key_metadata.cloud_hsm_cluster_id #=> String
  #   resp.replica_key_metadata.expiration_model #=> String, one of "KEY_MATERIAL_EXPIRES", "KEY_MATERIAL_DOES_NOT_EXPIRE"
  #   resp.replica_key_metadata.key_manager #=> String, one of "AWS", "CUSTOMER"
  #   resp.replica_key_metadata.customer_master_key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.replica_key_metadata.key_spec #=> String, one of "RSA_2048", "RSA_3072", "RSA_4096", "ECC_NIST_P256", "ECC_NIST_P384", "ECC_NIST_P521", "ECC_SECG_P256K1", "SYMMETRIC_DEFAULT", "HMAC_224", "HMAC_256", "HMAC_384", "HMAC_512", "SM2"
  #   resp.replica_key_metadata.encryption_algorithms #=> Array
  #   resp.replica_key_metadata.encryption_algorithms[0] #=> String, one of "SYMMETRIC_DEFAULT", "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "SM2PKE"
  #   resp.replica_key_metadata.signing_algorithms #=> Array
  #   resp.replica_key_metadata.signing_algorithms[0] #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  #   resp.replica_key_metadata.multi_region #=> Boolean
  #   resp.replica_key_metadata.multi_region_configuration.multi_region_key_type #=> String, one of "PRIMARY", "REPLICA"
  #   resp.replica_key_metadata.multi_region_configuration.primary_key.arn #=> String
  #   resp.replica_key_metadata.multi_region_configuration.primary_key.region #=> String
  #   resp.replica_key_metadata.multi_region_configuration.replica_keys #=> Array
  #   resp.replica_key_metadata.multi_region_configuration.replica_keys[0].arn #=> String
  #   resp.replica_key_metadata.multi_region_configuration.replica_keys[0].region #=> String
  #   resp.replica_key_metadata.pending_deletion_window_in_days #=> Integer
  #   resp.replica_key_metadata.mac_algorithms #=> Array
  #   resp.replica_key_metadata.mac_algorithms[0] #=> String, one of "HMAC_SHA_224", "HMAC_SHA_256", "HMAC_SHA_384", "HMAC_SHA_512"
  #   resp.replica_key_metadata.xks_key_configuration.id #=> String
  #   resp.replica_policy #=> String
  #   resp.replica_tags #=> Array
  #   resp.replica_tags[0].tag_key #=> String
  #   resp.replica_tags[0].tag_value #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload replicate_key
  # @param params [Hash] ({})
  # @return [Types::ReplicateKeyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ReplicateKeyResponse#replica_key_metadata #replica_key_metadata} => Types::KeyMetadata
  #   * {Types::ReplicateKeyResponse#replica_policy #replica_policy} => String
  #   * {Types::ReplicateKeyResponse#replica_tags #replica_tags} => Array&lt;Types::Tag&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKey AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7318
  def replicate_key(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes a grant. Typically, you retire a grant when you no longer need
  # its permissions. To identify the grant to retire, use a [grant
  # token][1], or both the grant ID and a key identifier (key ID or key
  # ARN) of the KMS key. The CreateGrant operation returns both values.
  #
  # This operation can be called by the *retiring principal* for a grant,
  # by the *grantee principal* if the grant allows the `RetireGrant`
  # operation, and by the Amazon Web Services account in which the grant
  # is created. It can also be called by principals to whom permission for
  # retiring a grant is delegated. For details, see [Retiring and revoking
  # grants][2] in the *Key Management Service Developer Guide*.
  #
  # For detailed information about grants, including grant terminology,
  # see [Grants in KMS][3] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>. For examples of working with grants in several
  # programming languages, see [Programming grants][4].
  #
  # **Cross-account use**\: Yes. You can retire a grant on a KMS key in a
  # different Amazon Web Services account.
  #
  # **Required permissions:**\:Permission to retire a grant is determined
  # primarily by the grant. For details, see [Retiring and revoking
  # grants][2] in the *Key Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * CreateGrant
  #
  # * ListGrants
  #
  # * ListRetirableGrants
  #
  # * RevokeGrant
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html
  #
  # @example Example: To retire a grant
  #
  #   # The following example retires a grant.
  #
  #   resp = client.retire_grant({
  #   grant_id: "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60", # The identifier of the grant to retire.
  #   key_id: "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The Amazon Resource Name (ARN) of the KMS key associated with the grant.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.retire_grant({
  #   grant_token: "GrantTokenType",
  #   key_id: "KeyIdType",
  #   grant_id: "GrantIdType",
  #   })
  # @option params
  # @option params
  # @option params
  # @overload retire_grant
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RetireGrant AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7417
  def retire_grant(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes the specified grant. You revoke a grant to terminate the
  # permissions that the grant allows. For more information, see [Retiring
  # and revoking grants][1] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>.
  #
  # When you create, retire, or revoke a grant, there might be a brief
  # delay, usually less than five minutes, until the grant is available
  # throughout KMS. This state is known as *eventual consistency*. For
  # details, see [Eventual consistency][2] in the <i> <i>Key Management
  # Service Developer Guide</i> </i>.
  #
  # For detailed information about grants, including grant terminology,
  # see [Grants in KMS][3] in the <i> <i>Key Management Service Developer
  # Guide</i> </i>. For examples of working with grants in several
  # programming languages, see [Programming grants][4].
  #
  # **Cross-account use**\: Yes. To perform this operation on a KMS key in
  # a different Amazon Web Services account, specify the key ARN in the
  # value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:RevokeGrant][5] (key policy).
  #
  # **Related operations:**
  #
  # * CreateGrant
  #
  # * ListGrants
  #
  # * ListRetirableGrants
  #
  # * RetireGrant
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/managing-grants.html#grant-delete
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To revoke a grant
  #
  #   # The following example revokes a grant.
  #
  #   resp = client.revoke_grant({
  #   grant_id: "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60", # The identifier of the grant to revoke.
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key associated with the grant. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.revoke_grant({
  #   key_id: "KeyIdType", # required
  #   grant_id: "GrantIdType", # required
  #   })
  # @option params
  # @option params
  # @overload revoke_grant
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrant AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7506
  def revoke_grant(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Schedules the deletion of a KMS key. By default, KMS applies a waiting
  # period of 30 days, but you can specify a waiting period of 7-30 days.
  # When this operation is successful, the key state of the KMS key
  # changes to `PendingDeletion` and the key can't be used in any
  # cryptographic operations. It remains in this state for the duration of
  # the waiting period. Before the waiting period ends, you can use
  # CancelKeyDeletion to cancel the deletion of the KMS key. After the
  # waiting period ends, KMS deletes the KMS key, its key material, and
  # all KMS data associated with it, including all aliases that refer to
  # it.
  #
  # Deleting a KMS key is a destructive and potentially dangerous
  # operation. When a KMS key is deleted, all data that was encrypted
  # under the KMS key is unrecoverable. (The only exception is a
  # multi-Region replica key.) To prevent the use of a KMS key without
  # deleting it, use DisableKey.
  #
  # You can schedule the deletion of a multi-Region primary key and its
  # replica keys at any time. However, KMS will not delete a multi-Region
  # primary key with existing replica keys. If you schedule the deletion
  # of a primary key with replicas, its key state changes to
  # `PendingReplicaDeletion` and it cannot be replicated or used in
  # cryptographic operations. This status can continue indefinitely. When
  # the last of its replicas keys is deleted (not just scheduled), the key
  # state of the primary key changes to `PendingDeletion` and its waiting
  # period (`PendingWindowInDays`) begins. For details, see [Deleting
  # multi-Region keys][1] in the *Key Management Service Developer Guide*.
  #
  # When KMS [deletes a KMS key from an CloudHSM key store][2], it makes a
  # best effort to delete the associated key material from the associated
  # CloudHSM cluster. However, you might need to manually [delete the
  # orphaned key material][3] from the cluster and its backups. [Deleting
  # a KMS key from an external key store][4] has no effect on the
  # associated external key. However, for both types of custom key stores,
  # deleting a KMS key is destructive and irreversible. You cannot decrypt
  # ciphertext encrypted under the KMS key by using only its associated
  # external key or CloudHSM key. Also, you cannot recreate a KMS key in
  # an external key store by creating a new KMS key with the same key
  # material.
  #
  # For more information about scheduling a KMS key for deletion, see
  # [Deleting KMS keys][5] in the *Key Management Service Developer
  # Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][6] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: kms:ScheduleKeyDeletion (key policy)
  #
  # **Related operations**
  #
  # * CancelKeyDeletion
  #
  # * DisableKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/delete-cmk-keystore.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/delete-xks-key.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  #
  # @example Example: To schedule a KMS key for deletion
  #
  #   # The following example schedules the specified KMS key for deletion.
  #
  #   resp = client.schedule_key_deletion({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key to schedule for deletion. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   pending_window_in_days: 7, # The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   deletion_date: Time.parse("2016-12-17T16:00:00-08:00"), # The date and time after which KMS deletes the KMS key.
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The ARN of the KMS key that is scheduled for deletion.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.schedule_key_deletion({
  #   key_id: "KeyIdType", # required
  #   pending_window_in_days: 1,
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.deletion_date #=> Time
  #   resp.key_state #=> String, one of "Creating", "Enabled", "Disabled", "PendingDeletion", "PendingImport", "PendingReplicaDeletion", "Unavailable", "Updating"
  #   resp.pending_window_in_days #=> Integer
  # @option params
  # @option params
  # @overload schedule_key_deletion
  # @param params [Hash] ({})
  # @return [Types::ScheduleKeyDeletionResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ScheduleKeyDeletionResponse#key_id #key_id} => String
  #   * {Types::ScheduleKeyDeletionResponse#deletion_date #deletion_date} => Time
  #   * {Types::ScheduleKeyDeletionResponse#key_state #key_state} => String
  #   * {Types::ScheduleKeyDeletionResponse#pending_window_in_days #pending_window_in_days} => Integer
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ScheduleKeyDeletion AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7646
  def schedule_key_deletion(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Creates a [digital signature][1] for a message or message digest by
  # using the private key in an asymmetric signing KMS key. To verify the
  # signature, use the Verify operation, or use the public key in the same
  # asymmetric KMS key outside of KMS. For information about asymmetric
  # KMS keys, see [Asymmetric KMS keys][2] in the *Key Management Service
  # Developer Guide*.
  #
  # Digital signatures are generated and verified by using asymmetric key
  # pair, such as an RSA or ECC pair that is represented by an asymmetric
  # KMS key. The key owner (or an authorized user) uses their private key
  # to sign a message. Anyone with the public key can verify that the
  # message was signed with that particular private key and that the
  # message hasn't changed since it was signed.
  #
  # To use the `Sign` operation, provide the following information:
  #
  # * Use the `KeyId` parameter to identify an asymmetric KMS key with a
  #   `KeyUsage` value of `SIGN_VERIFY`. To get the `KeyUsage` value of a
  #   KMS key, use the DescribeKey operation. The caller must have
  #   `kms:Sign` permission on the KMS key.
  #
  # * Use the `Message` parameter to specify the message or message digest
  #   to sign. You can submit messages of up to 4096 bytes. To sign a
  #   larger message, generate a hash digest of the message, and then
  #   provide the hash digest in the `Message` parameter. To indicate
  #   whether the message is a full message or a digest, use the
  #   `MessageType` parameter.
  #
  # * Choose a signing algorithm that is compatible with the KMS key.
  #
  # When signing a message, be sure to record the KMS key and the signing
  # algorithm. This information is required to verify the signature.
  #
  # <note markdown="1"> Best practices recommend that you limit the time during which any
  # signature is effective. This deters an attack where the actor uses a
  # signed message to establish validity repeatedly or long after the
  # message is superseded. Signatures do not include a timestamp, but you
  # can include a timestamp in the signed message to help you detect when
  # its time to refresh the signature.
  #
  #  </note>
  #
  # To verify the signature that this operation generates, use the Verify
  # operation. Or use the GetPublicKey operation to download the public
  # key and then use the public key to verify the signature outside of
  # KMS.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:Sign][4] (key policy)
  #
  # **Related operations**\: Verify
  #
  #
  #
  # [1]: https://en.wikipedia.org/wiki/Digital_signature
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To digitally sign a message with an asymmetric KMS key.
  #
  #   # This operation uses the private key in an asymmetric elliptic curve (ECC) KMS key to generate a digital signature for a
  #   # given message.
  #
  #   resp = client.sign({
  #   key_id: "alias/ECC_signing_key", # The asymmetric KMS key to be used to generate the digital signature. This example uses an alias of the KMS key.
  #   message: "<message to be signed>", # Message to be signed. Use Base-64 for the CLI.
  #   message_type: "RAW", # Indicates whether the message is RAW or a DIGEST.
  #   signing_algorithm: "ECDSA_SHA_384", # The requested signing algorithm. This must be an algorithm that the KMS key supports.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the asymmetric KMS key that was used to sign the message.
  #   signature: "<binary data>", # The digital signature of the message.
  #   signing_algorithm: "ECDSA_SHA_384", # The actual signing algorithm that was used to generate the signature.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.sign({
  #   key_id: "KeyIdType", # required
  #   message: "data", # required
  #   message_type: "RAW", # accepts RAW, DIGEST
  #   grant_tokens: ["GrantTokenType"],
  #   signing_algorithm: "RSASSA_PSS_SHA_256", # required, accepts RSASSA_PSS_SHA_256, RSASSA_PSS_SHA_384, RSASSA_PSS_SHA_512, RSASSA_PKCS1_V1_5_SHA_256, RSASSA_PKCS1_V1_5_SHA_384, RSASSA_PKCS1_V1_5_SHA_512, ECDSA_SHA_256, ECDSA_SHA_384, ECDSA_SHA_512, SM2DSA
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.signature #=> String
  #   resp.signing_algorithm #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload sign
  # @param params [Hash] ({})
  # @return [Types::SignResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::SignResponse#key_id #key_id} => String
  #   * {Types::SignResponse#signature #signature} => String
  #   * {Types::SignResponse#signing_algorithm #signing_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Sign AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7819
  def sign(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds or edits tags on a [customer managed key][1].
  #
  # <note markdown="1"> Tagging or untagging a KMS key can allow or deny permission to the KMS
  # key. For details, see [ABAC for KMS][2] in the *Key Management Service
  # Developer Guide*.
  #
  #  </note>
  #
  # Each tag consists of a tag key and a tag value, both of which are
  # case-sensitive strings. The tag value can be an empty (null) string.
  # To add a tag, specify a new tag key and a tag value. To edit a tag,
  # specify an existing tag key and a new tag value.
  #
  # You can use this operation to tag a [customer managed key][1], but you
  # cannot tag an [Amazon Web Services managed key][3], an [Amazon Web
  # Services owned key][4], a [custom key store][5], or an [alias][6].
  #
  # You can also add tags to a KMS key while creating it (CreateKey) or
  # replicating it (ReplicateKey).
  #
  # For information about using tags in KMS, see [Tagging keys][7]. For
  # general information about tags, including the format and syntax, see
  # [Tagging Amazon Web Services resources][8] in the *Amazon Web Services
  # General Reference*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][9] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:TagResource][10] (key policy)
  #
  # **Related operations**
  #
  # * CreateKey
  #
  # * ListResourceTags
  #
  # * ReplicateKey
  #
  # * UntagResource
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/abac.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#keystore-concept
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#alias-concept
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html
  # [8]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [10]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To tag a KMS key
  #
  #   # The following example tags a KMS key.
  #
  #   resp = client.tag_resource({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key you are tagging. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   tags: [
  #   {
  #   tag_key: "Purpose",
  #   tag_value: "Test",
  #   },
  #   ], # A list of tags.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.tag_resource({
  #   key_id: "KeyIdType", # required
  #   tags: [ # required
  #   {
  #   tag_key: "TagKeyType", # required
  #   tag_value: "TagValueType", # required
  #   },
  #   ],
  #   })
  # @option params
  # @option params
  # @overload tag_resource
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/TagResource AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#7939
  def tag_resource(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deletes tags from a [customer managed key][1]. To delete a tag,
  # specify the tag key and the KMS key.
  #
  # <note markdown="1"> Tagging or untagging a KMS key can allow or deny permission to the KMS
  # key. For details, see [ABAC for KMS][2] in the *Key Management Service
  # Developer Guide*.
  #
  #  </note>
  #
  # When it succeeds, the `UntagResource` operation doesn't return any
  # output. Also, if the specified tag key isn't found on the KMS key, it
  # doesn't throw an exception or return a response. To confirm that the
  # operation worked, use the ListResourceTags operation.
  #
  # For information about using tags in KMS, see [Tagging keys][3]. For
  # general information about tags, including the format and syntax, see
  # [Tagging Amazon Web Services resources][4] in the *Amazon Web Services
  # General Reference*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][5] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:UntagResource][6] (key policy)
  #
  # **Related operations**
  #
  # * CreateKey
  #
  # * ListResourceTags
  #
  # * ReplicateKey
  #
  # * TagResource
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/abac.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html
  # [4]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To remove tags from a KMS key
  #
  #   # The following example removes tags from a KMS key.
  #
  #   resp = client.untag_resource({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose tags you are removing.
  #   tag_keys: [
  #   "Purpose",
  #   "CostCenter",
  #   ], # A list of tag keys. Provide only the tag keys, not the tag values.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.untag_resource({
  #   key_id: "KeyIdType", # required
  #   tag_keys: ["TagKeyType"], # required
  #   })
  # @option params
  # @option params
  # @overload untag_resource
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UntagResource AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8035
  def untag_resource(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Associates an existing KMS alias with a different KMS key. Each alias
  # is associated with only one KMS key at a time, although a KMS key can
  # have multiple aliases. The alias and the KMS key must be in the same
  # Amazon Web Services account and Region.
  #
  # <note markdown="1"> Adding, deleting, or updating an alias can allow or deny permission to
  # the KMS key. For details, see [ABAC for KMS][1] in the *Key Management
  # Service Developer Guide*.
  #
  #  </note>
  #
  # The current and new KMS key must be the same type (both symmetric or
  # both asymmetric or both HMAC), and they must have the same key usage.
  # This restriction prevents errors in code that uses aliases. If you
  # must assign an alias to a different type of KMS key, use DeleteAlias
  # to delete the old alias and CreateAlias to create a new alias.
  #
  # You cannot use `UpdateAlias` to change an alias name. To change an
  # alias name, use DeleteAlias to delete the old alias and CreateAlias to
  # create a new alias.
  #
  # Because an alias is not a property of a KMS key, you can create,
  # update, and delete the aliases of a KMS key without affecting the KMS
  # key. Also, aliases do not appear in the response from the DescribeKey
  # operation. To get the aliases of all KMS keys in the account, use the
  # ListAliases operation.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][2] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**
  #
  # * [kms:UpdateAlias][3] on the alias (IAM policy).
  #
  # * [kms:UpdateAlias][3] on the current KMS key (key policy).
  #
  # * [kms:UpdateAlias][3] on the new KMS key (key policy).
  #
  # For details, see [Controlling access to aliases][4] in the *Key
  # Management Service Developer Guide*.
  #
  # **Related operations:**
  #
  # * CreateAlias
  #
  # * DeleteAlias
  #
  # * ListAliases
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/abac.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access
  #
  # @example Example: To update an alias
  #
  #   # The following example updates the specified alias to refer to the specified KMS key.
  #
  #   resp = client.update_alias({
  #   alias_name: "alias/ExampleAlias", # The alias to update.
  #   target_key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key that the alias will refer to after this operation succeeds. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.update_alias({
  #   alias_name: "AliasNameType", # required
  #   target_key_id: "KeyIdType", # required
  #   })
  # @option params
  # @option params
  # @overload update_alias
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateAlias AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8159
  def update_alias(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Changes the properties of a custom key store. You can use this
  # operation to change the properties of an CloudHSM key store or an
  # external key store.
  #
  # Use the required `CustomKeyStoreId` parameter to identify the custom
  # key store. Use the remaining optional parameters to change its
  # properties. This operation does not return any property values. To
  # verify the updated property values, use the DescribeCustomKeyStores
  # operation.
  #
  # This operation is part of the [custom key stores][1] feature in KMS,
  # which combines the convenience and extensive integration of KMS with
  # the isolation and control of a key store that you own and manage.
  #
  # When updating the properties of an external key store, verify that the
  # updated settings connect your key store, via the external key store
  # proxy, to the same external key manager as the previous settings, or
  # to a backup or snapshot of the external key manager with the same
  # cryptographic keys. If the updated connection settings fail, you can
  # fix them and retry, although an extended delay might disrupt Amazon
  # Web Services services. However, if KMS permanently loses its access to
  # cryptographic keys, ciphertext encrypted under those keys is
  # unrecoverable.
  #
  # <note markdown="1"> For external key stores:
  #
  #  Some external key managers provide a simpler method for updating an
  # external key store. For details, see your external key manager
  # documentation.
  #
  #  When updating an external key store in the KMS console, you can upload
  # a JSON-based proxy configuration file with the desired values. You
  # cannot upload the proxy configuration file to the
  # `UpdateCustomKeyStore` operation. However, you can use the file to
  # help you determine the correct values for the `UpdateCustomKeyStore`
  # parameters.
  #
  #  </note>
  #
  # For an CloudHSM key store, you can use this operation to change the
  # custom key store friendly name (`NewCustomKeyStoreName`), to tell KMS
  # about a change to the `kmsuser` crypto user password
  # (`KeyStorePassword`), or to associate the custom key store with a
  # different, but related, CloudHSM cluster (`CloudHsmClusterId`). To
  # update any property of an CloudHSM key store, the `ConnectionState` of
  # the CloudHSM key store must be `DISCONNECTED`.
  #
  # For an external key store, you can use this operation to change the
  # custom key store friendly name (`NewCustomKeyStoreName`), or to tell
  # KMS about a change to the external key store proxy authentication
  # credentials (`XksProxyAuthenticationCredential`), connection method
  # (`XksProxyConnectivity`), external proxy endpoint
  # (`XksProxyUriEndpoint`) and path (`XksProxyUriPath`). For external key
  # stores with an `XksProxyConnectivity` of `VPC_ENDPOINT_SERVICE`, you
  # can also update the Amazon VPC endpoint service name
  # (`XksProxyVpcEndpointServiceName`). To update most properties of an
  # external key store, the `ConnectionState` of the external key store
  # must be `DISCONNECTED`. However, you can update the
  # `CustomKeyStoreName`, `XksProxyAuthenticationCredential`, and
  # `XksProxyUriPath` of an external key store when it is in the CONNECTED
  # or DISCONNECTED state.
  #
  # If your update requires a `DISCONNECTED` state, before using
  # `UpdateCustomKeyStore`, use the DisconnectCustomKeyStore operation to
  # disconnect the custom key store. After the `UpdateCustomKeyStore`
  # operation completes, use the ConnectCustomKeyStore to reconnect the
  # custom key store. To find the `ConnectionState` of the custom key
  # store, use the DescribeCustomKeyStores operation.
  #
  #
  #
  # Before updating the custom key store, verify that the new values allow
  # KMS to connect the custom key store to its backing key store. For
  # example, before you change the `XksProxyUriPath` value, verify that
  # the external key store proxy is reachable at the new path.
  #
  # If the operation succeeds, it returns a JSON object with no
  # properties.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a
  # custom key store in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:UpdateCustomKeyStore][2] (IAM policy)
  #
  # **Related operations:**
  #
  # * ConnectCustomKeyStore
  #
  # * CreateCustomKeyStore
  #
  # * DeleteCustomKeyStore
  #
  # * DescribeCustomKeyStores
  #
  # * DisconnectCustomKeyStore
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To edit the friendly name of a custom key store
  #
  #   # This example changes the friendly name of the AWS KMS custom key store to the name that you specify. This operation does
  #   # not return any data. To verify that the operation worked, use the DescribeCustomKeyStores operation.
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store that you are updating.
  #   new_custom_key_store_name: "DevelopmentKeys", # A new friendly name for the custom key store.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To edit the password of an AWS CloudHSM key store
  #
  #   # This example tells AWS KMS the password for the kmsuser crypto user in the AWS CloudHSM cluster that is associated with
  #   # the AWS KMS custom key store. (It does not change the password in the CloudHSM cluster.) This operation does not return
  #   # any data.
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store that you are updating.
  #   key_store_password: "ExamplePassword", # The password for the kmsuser crypto user in the CloudHSM cluster.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To associate the custom key store with a different, but related, AWS CloudHSM cluster.
  #
  #   # This example changes the AWS CloudHSM cluster that is associated with an AWS CloudHSM key store to a related cluster,
  #   # such as a different backup of the same cluster. This operation does not return any data. To verify that the operation
  #   # worked, use the DescribeCustomKeyStores operation.
  #
  #   resp = client.update_custom_key_store({
  #   cloud_hsm_cluster_id: "cluster-1a23b4cdefg", # The ID of the AWS CloudHSM cluster that you want to associate with the custom key store. This cluster must be related to the original CloudHSM cluster for this key store.
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store that you are updating.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To update the proxy authentication credential of an external key store
  #
  #   # To update the proxy authentication credential for your external key store, specify both the
  #   # <code>RawSecretAccessKey</code> and the <code>AccessKeyId</code>, even if you are changing only one of the values. You
  #   # can use this feature to fix an invalid credential or to change the credential when the external key store proxy rotates
  #   # it.
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # Identifies the custom key store
  #   xks_proxy_authentication_credential: {
  #   access_key_id: "ABCDE12345670EXAMPLE",
  #   raw_secret_access_key: "DXjSUawnel2fr6SKC7G25CNxTyWKE5PF9XX6H/u9pSo=",
  #   }, # Specifies the values in the proxy authentication credential
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To edit the proxy URI path of an external key store.
  #
  #   # This example updates the proxy URI path for an external key store
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # The ID of the custom key store that you are updating
  #   xks_proxy_uri_path: "/new-path/kms/xks/v1", # The URI path to the external key store proxy APIs
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Example: To update the proxy connectivity of an external key store to VPC_ENDPOINT_SERVICE
  #
  #   # To change the external key store proxy connectivity option from public endpoint connectivity to VPC endpoint service
  #   # connectivity, in addition to changing the <code>XksProxyConnectivity</code> value, you must change the
  #   # <code>XksProxyUriEndpoint</code> value to reflect the private DNS name associated with the VPC endpoint service. You
  #   # must also add an <code>XksProxyVpcEndpointServiceName</code> value.
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "cks-1234567890abcdef0", # Identifies the custom key store
  #   xks_proxy_connectivity: "VPC_ENDPOINT_SERVICE", # Specifies the connectivity option
  #   xks_proxy_uri_endpoint: "https://myproxy-private.xks.example.com", # Specifies the URI endpoint that AWS KMS uses when communicating with the external key store proxy
  #   xks_proxy_vpc_endpoint_service_name: "com.amazonaws.vpce.us-east-1.vpce-svc-example", # Specifies the name of the VPC endpoint service that the proxy uses for communication
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.update_custom_key_store({
  #   custom_key_store_id: "CustomKeyStoreIdType", # required
  #   new_custom_key_store_name: "CustomKeyStoreNameType",
  #   key_store_password: "KeyStorePasswordType",
  #   cloud_hsm_cluster_id: "CloudHsmClusterIdType",
  #   xks_proxy_uri_endpoint: "XksProxyUriEndpointType",
  #   xks_proxy_uri_path: "XksProxyUriPathType",
  #   xks_proxy_vpc_endpoint_service_name: "XksProxyVpcEndpointServiceNameType",
  #   xks_proxy_authentication_credential: {
  #   access_key_id: "XksProxyAuthenticationAccessKeyIdType", # required
  #   raw_secret_access_key: "XksProxyAuthenticationRawSecretAccessKeyType", # required
  #   },
  #   xks_proxy_connectivity: "PUBLIC_ENDPOINT", # accepts PUBLIC_ENDPOINT, VPC_ENDPOINT_SERVICE
  #   })
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload update_custom_key_store
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateCustomKeyStore AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8507
  def update_custom_key_store(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Updates the description of a KMS key. To see the description of a KMS
  # key, use DescribeKey.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][1] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: No. You cannot perform this operation on a KMS
  # key in a different Amazon Web Services account.
  #
  # **Required permissions**\: [kms:UpdateKeyDescription][2] (key policy)
  #
  # **Related operations**
  #
  # * CreateKey
  #
  # * DescribeKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To update the description of a KMS key
  #
  #   # The following example updates the description of the specified KMS key.
  #
  #   resp = client.update_key_description({
  #   description: "Example description that indicates the intended use of this KMS key.", # The updated description.
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The identifier of the KMS key whose description you are updating. You can use the key ID or the Amazon Resource Name (ARN) of the KMS key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.update_key_description({
  #   key_id: "KeyIdType", # required
  #   description: "DescriptionType", # required
  #   })
  # @option params
  # @option params
  # @overload update_key_description
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateKeyDescription AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8576
  def update_key_description(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Changes the primary key of a multi-Region key.
  #
  # This operation changes the replica key in the specified Region to a
  # primary key and changes the former primary key to a replica key. For
  # example, suppose you have a primary key in `us-east-1` and a replica
  # key in `eu-west-2`. If you run `UpdatePrimaryRegion` with a
  # `PrimaryRegion` value of `eu-west-2`, the primary key is now the key
  # in `eu-west-2`, and the key in `us-east-1` becomes a replica key. For
  # details, see [Updating the primary Region][1] in the *Key Management
  # Service Developer Guide*.
  #
  # This operation supports *multi-Region keys*, an KMS feature that lets
  # you create multiple interoperable KMS keys in different Amazon Web
  # Services Regions. Because these KMS keys have the same key ID, key
  # material, and other metadata, you can use them interchangeably to
  # encrypt data in one Amazon Web Services Region and decrypt it in a
  # different Amazon Web Services Region without re-encrypting the data or
  # making a cross-Region call. For more information about multi-Region
  # keys, see [Multi-Region keys in KMS][2] in the *Key Management Service
  # Developer Guide*.
  #
  # The *primary key* of a multi-Region key is the source for properties
  # that are always shared by primary and replica keys, including the key
  # material, [key ID][3], [key spec][4], [key usage][5], [key material
  # origin][6], and [automatic key rotation][7]. It's the only key that
  # can be replicated. You cannot [delete the primary key][8] until all
  # replica keys are deleted.
  #
  # The key ID and primary Region that you specify uniquely identify the
  # replica key that will become the primary key. The primary Region must
  # already have a replica key. This operation does not create a KMS key
  # in the specified Region. To find the replica keys, use the DescribeKey
  # operation on the primary key or any replica key. To create a replica
  # key, use the ReplicateKey operation.
  #
  # You can run this operation while using the affected multi-Region keys
  # in cryptographic operations. This operation should not delay,
  # interrupt, or cause failures in cryptographic operations.
  #
  # Even after this operation completes, the process of updating the
  # primary Region might still be in progress for a few more seconds.
  # Operations such as `DescribeKey` might display both the old and new
  # primary keys as replicas. The old and new primary keys have a
  # transient key state of `Updating`. The original key state is restored
  # when the update is complete. While the key state is `Updating`, you
  # can use the keys in cryptographic operations, but you cannot replicate
  # the new primary key or perform certain management operations, such as
  # enabling or disabling these keys. For details about the `Updating` key
  # state, see [Key states of KMS keys][9] in the *Key Management Service
  # Developer Guide*.
  #
  # This operation does not return any output. To verify that primary key
  # is changed, use the DescribeKey operation.
  #
  # **Cross-account use**\: No. You cannot use this operation in a
  # different Amazon Web Services account.
  #
  # **Required permissions**\:
  #
  # * `kms:UpdatePrimaryRegion` on the current primary key (in the primary
  #   key's Region). Include this permission primary key's key policy.
  #
  # * `kms:UpdatePrimaryRegion` on the current replica key (in the replica
  #   key's Region). Include this permission in the replica key's key
  #   policy.
  #
  # **Related operations**
  #
  # * CreateKey
  #
  # * ReplicateKey
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-update
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec
  # [5]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage
  # [6]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin
  # [7]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html
  # [8]: https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html
  # [9]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  #
  # @example Example: To update the primary Region of a multi-Region KMS key
  #
  #   # The following UpdatePrimaryRegion example changes the multi-Region replica key in the eu-central-1 Region to the primary
  #   # key. The current primary key in the us-west-1 Region becomes a replica key.
  #   # The KeyId parameter identifies the current primary key in the us-west-1 Region. The PrimaryRegion parameter indicates
  #   # the Region of the replica key that will become the new primary key.
  #   # This operation does not return any output. To verify that primary key is changed, use the DescribeKey operation.
  #
  #   resp = client.update_primary_region({
  #   key_id: "arn:aws:kms:us-west-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab", # The current primary key.
  #   primary_region: "eu-central-1", # The Region of the replica key that will become the primary key.
  #   })
  # @example Request syntax with placeholder values
  #
  #   resp = client.update_primary_region({
  #   key_id: "KeyIdType", # required
  #   primary_region: "RegionType", # required
  #   })
  # @option params
  # @option params
  # @overload update_primary_region
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdatePrimaryRegion AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8716
  def update_primary_region(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Verifies a digital signature that was generated by the Sign operation.
  #
  #
  #
  # Verification confirms that an authorized user signed the message with
  # the specified KMS key and signing algorithm, and the message hasn't
  # changed since it was signed. If the signature is verified, the value
  # of the `SignatureValid` field in the response is `True`. If the
  # signature verification fails, the `Verify` operation fails with an
  # `KMSInvalidSignatureException` exception.
  #
  # A digital signature is generated by using the private key in an
  # asymmetric KMS key. The signature is verified by using the public key
  # in the same asymmetric KMS key. For information about asymmetric KMS
  # keys, see [Asymmetric KMS keys][1] in the *Key Management Service
  # Developer Guide*.
  #
  # To verify a digital signature, you can use the `Verify` operation.
  # Specify the same asymmetric KMS key, message, and signing algorithm
  # that were used to produce the signature.
  #
  # You can also verify the digital signature by using the public key of
  # the KMS key outside of KMS. Use the GetPublicKey operation to download
  # the public key in the asymmetric KMS key and then use the public key
  # to verify the signature outside of KMS. The advantage of using the
  # `Verify` operation is that it is performed within KMS. As a result,
  # it's easy to call, the operation is performed within the FIPS
  # boundary, it is logged in CloudTrail, and you can use key policy and
  # IAM policy to determine who is authorized to use the KMS key to verify
  # signatures.
  #
  # To verify a signature outside of KMS with an SM2 public key (China
  # Regions only), you must specify the distinguishing ID. By default, KMS
  # uses `1234567812345678` as the distinguishing ID. For more
  # information, see [Offline verification with SM2 key pairs][2].
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:Verify][4] (key policy)
  #
  # **Related operations**\: Sign
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To use an asymmetric KMS key to verify a digital signature
  #
  #   # This operation uses the public key in an elliptic curve (ECC) asymmetric key to verify a digital signature within AWS
  #   # KMS.
  #
  #   resp = client.verify({
  #   key_id: "alias/ECC_signing_key", # The asymmetric KMS key to be used to verify the digital signature. This example uses an alias to identify the KMS key.
  #   message: "<message to be verified>", # The message that was signed.
  #   message_type: "RAW", # Indicates whether the message is RAW or a DIGEST.
  #   signature: "<binary data>", # The signature to be verified.
  #   signing_algorithm: "ECDSA_SHA_384", # The signing algorithm to be used to verify the signature.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the asymmetric KMS key that was used to verify the digital signature.
  #   signature_valid: true, # A value of 'true' Indicates that the signature was verified. If verification fails, the call to Verify fails.
  #   signing_algorithm: "ECDSA_SHA_384", # The signing algorithm that was used to verify the signature.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.verify({
  #   key_id: "KeyIdType", # required
  #   message: "data", # required
  #   message_type: "RAW", # accepts RAW, DIGEST
  #   signature: "data", # required
  #   signing_algorithm: "RSASSA_PSS_SHA_256", # required, accepts RSASSA_PSS_SHA_256, RSASSA_PSS_SHA_384, RSASSA_PSS_SHA_512, RSASSA_PKCS1_V1_5_SHA_256, RSASSA_PKCS1_V1_5_SHA_384, RSASSA_PKCS1_V1_5_SHA_512, ECDSA_SHA_256, ECDSA_SHA_384, ECDSA_SHA_512, SM2DSA
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.signature_valid #=> Boolean
  #   resp.signing_algorithm #=> String, one of "RSASSA_PSS_SHA_256", "RSASSA_PSS_SHA_384", "RSASSA_PSS_SHA_512", "RSASSA_PKCS1_V1_5_SHA_256", "RSASSA_PKCS1_V1_5_SHA_384", "RSASSA_PKCS1_V1_5_SHA_512", "ECDSA_SHA_256", "ECDSA_SHA_384", "ECDSA_SHA_512", "SM2DSA"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload verify
  # @param params [Hash] ({})
  # @return [Types::VerifyResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::VerifyResponse#key_id #key_id} => String
  #   * {Types::VerifyResponse#signature_valid #signature_valid} => Boolean
  #   * {Types::VerifyResponse#signing_algorithm #signing_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Verify AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#8887
  def verify(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Verifies the hash-based message authentication code (HMAC) for a
  # specified message, HMAC KMS key, and MAC algorithm. To verify the
  # HMAC, `VerifyMac` computes an HMAC using the message, HMAC KMS key,
  # and MAC algorithm that you specify, and compares the computed HMAC to
  # the HMAC that you specify. If the HMACs are identical, the
  # verification succeeds; otherwise, it fails. Verification indicates
  # that the message hasn't changed since the HMAC was calculated, and
  # the specified key was used to generate and verify the HMAC.
  #
  # HMAC KMS keys and the HMAC algorithms that KMS uses conform to
  # industry standards defined in [RFC 2104][1].
  #
  # This operation is part of KMS support for HMAC KMS keys. For details,
  # see [HMAC keys in KMS][2] in the *Key Management Service Developer
  # Guide*.
  #
  # The KMS key that you use for this operation must be in a compatible
  # key state. For details, see [Key states of KMS keys][3] in the *Key
  # Management Service Developer Guide*.
  #
  # **Cross-account use**\: Yes. To perform this operation with a KMS key
  # in a different Amazon Web Services account, specify the key ARN or
  # alias ARN in the value of the `KeyId` parameter.
  #
  # **Required permissions**\: [kms:VerifyMac][4] (key policy)
  #
  # **Related operations**\: GenerateMac
  #
  #
  #
  # [1]: https://datatracker.ietf.org/doc/html/rfc2104
  # [2]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
  # [3]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
  # [4]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
  #
  # @example Example: To verify an HMAC
  #
  #   # This example verifies an HMAC for a particular message, HMAC KMS keys, and MAC algorithm. A value of 'true' in the
  #   # MacValid value in the response indicates that the HMAC is valid.
  #
  #   resp = client.verify_mac({
  #   key_id: "1234abcd-12ab-34cd-56ef-1234567890ab", # The HMAC KMS key input to the HMAC algorithm.
  #   mac: "<HMAC_TAG>", # The HMAC to be verified.
  #   mac_algorithm: "HMAC_SHA_384", # The HMAC algorithm requested for the operation.
  #   message: "Hello World", # The message input to the HMAC algorithm.
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   key_id: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab", # The key ARN of the HMAC key used in the operation.
  #   mac_algorithm: "HMAC_SHA_384", # The HMAC algorithm used in the operation.
  #   mac_valid: true, # A value of 'true' indicates that verification succeeded. If verification fails, the call to VerifyMac fails.
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.verify_mac({
  #   message: "data", # required
  #   key_id: "KeyIdType", # required
  #   mac_algorithm: "HMAC_SHA_224", # required, accepts HMAC_SHA_224, HMAC_SHA_256, HMAC_SHA_384, HMAC_SHA_512
  #   mac: "data", # required
  #   grant_tokens: ["GrantTokenType"],
  #   })
  # @example Response structure
  #
  #   resp.key_id #=> String
  #   resp.mac_valid #=> Boolean
  #   resp.mac_algorithm #=> String, one of "HMAC_SHA_224", "HMAC_SHA_256", "HMAC_SHA_384", "HMAC_SHA_512"
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload verify_mac
  # @param params [Hash] ({})
  # @return [Types::VerifyMacResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::VerifyMacResponse#key_id #key_id} => String
  #   * {Types::VerifyMacResponse#mac_valid #mac_valid} => Boolean
  #   * {Types::VerifyMacResponse#mac_algorithm #mac_algorithm} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyMac AWS API Documentation
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#9011
  def verify_mac(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#9035
  def waiter_names; end

  class << self
    # @api private
    #
    # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#9045
    def errors_module; end

    # @api private
    #
    # source://aws-sdk-kms//lib/aws-sdk-kms/client.rb#9042
    def identifier; end
  end
end

# @api private
module Aws::KMS::ClientApi
  include ::Seahorse::Model
end

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#913
Aws::KMS::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#16
Aws::KMS::ClientApi::AWSAccountIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#17
Aws::KMS::ClientApi::AlgorithmSpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#18
Aws::KMS::ClientApi::AliasList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#19
Aws::KMS::ClientApi::AliasListEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#20
Aws::KMS::ClientApi::AliasNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#21
Aws::KMS::ClientApi::AlreadyExistsException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#22
Aws::KMS::ClientApi::ArnType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#23
Aws::KMS::ClientApi::BooleanType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#24
Aws::KMS::ClientApi::CancelKeyDeletionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#25
Aws::KMS::ClientApi::CancelKeyDeletionResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#26
Aws::KMS::ClientApi::CiphertextType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BlobShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#27
Aws::KMS::ClientApi::CloudHsmClusterIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#28
Aws::KMS::ClientApi::CloudHsmClusterInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#29
Aws::KMS::ClientApi::CloudHsmClusterInvalidConfigurationException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#30
Aws::KMS::ClientApi::CloudHsmClusterNotActiveException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#31
Aws::KMS::ClientApi::CloudHsmClusterNotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#32
Aws::KMS::ClientApi::CloudHsmClusterNotRelatedException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#33
Aws::KMS::ClientApi::ConnectCustomKeyStoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#34
Aws::KMS::ClientApi::ConnectCustomKeyStoreResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#35
Aws::KMS::ClientApi::ConnectionErrorCodeType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#36
Aws::KMS::ClientApi::ConnectionStateType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#37
Aws::KMS::ClientApi::CreateAliasRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#38
Aws::KMS::ClientApi::CreateCustomKeyStoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#39
Aws::KMS::ClientApi::CreateCustomKeyStoreResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#40
Aws::KMS::ClientApi::CreateGrantRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#41
Aws::KMS::ClientApi::CreateGrantResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#42
Aws::KMS::ClientApi::CreateKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#43
Aws::KMS::ClientApi::CreateKeyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#44
Aws::KMS::ClientApi::CustomKeyStoreHasCMKsException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#45
Aws::KMS::ClientApi::CustomKeyStoreIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#46
Aws::KMS::ClientApi::CustomKeyStoreInvalidStateException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#47
Aws::KMS::ClientApi::CustomKeyStoreNameInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#48
Aws::KMS::ClientApi::CustomKeyStoreNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#49
Aws::KMS::ClientApi::CustomKeyStoreNotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#50
Aws::KMS::ClientApi::CustomKeyStoreType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#51
Aws::KMS::ClientApi::CustomKeyStoresList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#52
Aws::KMS::ClientApi::CustomKeyStoresListEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#53
Aws::KMS::ClientApi::CustomerMasterKeySpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#54
Aws::KMS::ClientApi::DataKeyPairSpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#55
Aws::KMS::ClientApi::DataKeySpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#56
Aws::KMS::ClientApi::DateType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#57
Aws::KMS::ClientApi::DecryptRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#58
Aws::KMS::ClientApi::DecryptResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#59
Aws::KMS::ClientApi::DeleteAliasRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#60
Aws::KMS::ClientApi::DeleteCustomKeyStoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#61
Aws::KMS::ClientApi::DeleteCustomKeyStoreResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#62
Aws::KMS::ClientApi::DeleteImportedKeyMaterialRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#63
Aws::KMS::ClientApi::DependencyTimeoutException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#64
Aws::KMS::ClientApi::DescribeCustomKeyStoresRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#65
Aws::KMS::ClientApi::DescribeCustomKeyStoresResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#66
Aws::KMS::ClientApi::DescribeKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#67
Aws::KMS::ClientApi::DescribeKeyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#68
Aws::KMS::ClientApi::DescriptionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#69
Aws::KMS::ClientApi::DisableKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#70
Aws::KMS::ClientApi::DisableKeyRotationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#71
Aws::KMS::ClientApi::DisabledException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#72
Aws::KMS::ClientApi::DisconnectCustomKeyStoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#73
Aws::KMS::ClientApi::DisconnectCustomKeyStoreResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#74
Aws::KMS::ClientApi::EnableKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#75
Aws::KMS::ClientApi::EnableKeyRotationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#76
Aws::KMS::ClientApi::EncryptRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#77
Aws::KMS::ClientApi::EncryptResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#78
Aws::KMS::ClientApi::EncryptionAlgorithmSpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#79
Aws::KMS::ClientApi::EncryptionAlgorithmSpecList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#80
Aws::KMS::ClientApi::EncryptionContextKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#81
Aws::KMS::ClientApi::EncryptionContextType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::MapShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#82
Aws::KMS::ClientApi::EncryptionContextValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#83
Aws::KMS::ClientApi::ErrorMessageType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#84
Aws::KMS::ClientApi::ExpirationModelType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#85
Aws::KMS::ClientApi::ExpiredImportTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#86
Aws::KMS::ClientApi::GenerateDataKeyPairRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#87
Aws::KMS::ClientApi::GenerateDataKeyPairResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#88
Aws::KMS::ClientApi::GenerateDataKeyPairWithoutPlaintextRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#89
Aws::KMS::ClientApi::GenerateDataKeyPairWithoutPlaintextResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#90
Aws::KMS::ClientApi::GenerateDataKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#91
Aws::KMS::ClientApi::GenerateDataKeyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#92
Aws::KMS::ClientApi::GenerateDataKeyWithoutPlaintextRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#93
Aws::KMS::ClientApi::GenerateDataKeyWithoutPlaintextResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#94
Aws::KMS::ClientApi::GenerateMacRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#95
Aws::KMS::ClientApi::GenerateMacResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#96
Aws::KMS::ClientApi::GenerateRandomRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#97
Aws::KMS::ClientApi::GenerateRandomResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#98
Aws::KMS::ClientApi::GetKeyPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#99
Aws::KMS::ClientApi::GetKeyPolicyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#100
Aws::KMS::ClientApi::GetKeyRotationStatusRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#101
Aws::KMS::ClientApi::GetKeyRotationStatusResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#102
Aws::KMS::ClientApi::GetParametersForImportRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#103
Aws::KMS::ClientApi::GetParametersForImportResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#104
Aws::KMS::ClientApi::GetPublicKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#105
Aws::KMS::ClientApi::GetPublicKeyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#106
Aws::KMS::ClientApi::GrantConstraints = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#107
Aws::KMS::ClientApi::GrantIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#108
Aws::KMS::ClientApi::GrantList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#109
Aws::KMS::ClientApi::GrantListEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#110
Aws::KMS::ClientApi::GrantNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#111
Aws::KMS::ClientApi::GrantOperation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#112
Aws::KMS::ClientApi::GrantOperationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#113
Aws::KMS::ClientApi::GrantTokenList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#114
Aws::KMS::ClientApi::GrantTokenType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#115
Aws::KMS::ClientApi::ImportKeyMaterialRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#116
Aws::KMS::ClientApi::ImportKeyMaterialResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#117
Aws::KMS::ClientApi::IncorrectKeyException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#118
Aws::KMS::ClientApi::IncorrectKeyMaterialException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#119
Aws::KMS::ClientApi::IncorrectTrustAnchorException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#120
Aws::KMS::ClientApi::InvalidAliasNameException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#121
Aws::KMS::ClientApi::InvalidArnException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#122
Aws::KMS::ClientApi::InvalidCiphertextException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#123
Aws::KMS::ClientApi::InvalidGrantIdException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#124
Aws::KMS::ClientApi::InvalidGrantTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#125
Aws::KMS::ClientApi::InvalidImportTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#126
Aws::KMS::ClientApi::InvalidKeyUsageException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#127
Aws::KMS::ClientApi::InvalidMarkerException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#128
Aws::KMS::ClientApi::KMSInternalException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#129
Aws::KMS::ClientApi::KMSInvalidMacException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#130
Aws::KMS::ClientApi::KMSInvalidSignatureException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#131
Aws::KMS::ClientApi::KMSInvalidStateException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#132
Aws::KMS::ClientApi::KeyIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#133
Aws::KMS::ClientApi::KeyList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#134
Aws::KMS::ClientApi::KeyListEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#135
Aws::KMS::ClientApi::KeyManagerType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#136
Aws::KMS::ClientApi::KeyMetadata = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#137
Aws::KMS::ClientApi::KeySpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#138
Aws::KMS::ClientApi::KeyState = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#139
Aws::KMS::ClientApi::KeyStorePasswordType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#140
Aws::KMS::ClientApi::KeyUnavailableException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#141
Aws::KMS::ClientApi::KeyUsageType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#142
Aws::KMS::ClientApi::LimitExceededException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#143
Aws::KMS::ClientApi::LimitType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#144
Aws::KMS::ClientApi::ListAliasesRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#145
Aws::KMS::ClientApi::ListAliasesResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#146
Aws::KMS::ClientApi::ListGrantsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#147
Aws::KMS::ClientApi::ListGrantsResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#148
Aws::KMS::ClientApi::ListKeyPoliciesRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#149
Aws::KMS::ClientApi::ListKeyPoliciesResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#150
Aws::KMS::ClientApi::ListKeysRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#151
Aws::KMS::ClientApi::ListKeysResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#152
Aws::KMS::ClientApi::ListResourceTagsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#153
Aws::KMS::ClientApi::ListResourceTagsResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#154
Aws::KMS::ClientApi::ListRetirableGrantsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#155
Aws::KMS::ClientApi::MacAlgorithmSpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#156
Aws::KMS::ClientApi::MacAlgorithmSpecList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#157
Aws::KMS::ClientApi::MalformedPolicyDocumentException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#158
Aws::KMS::ClientApi::MarkerType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#159
Aws::KMS::ClientApi::MessageType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#160
Aws::KMS::ClientApi::MultiRegionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#161
Aws::KMS::ClientApi::MultiRegionKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#162
Aws::KMS::ClientApi::MultiRegionKeyList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#163
Aws::KMS::ClientApi::MultiRegionKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#164
Aws::KMS::ClientApi::NotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#165
Aws::KMS::ClientApi::NullableBooleanType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#166
Aws::KMS::ClientApi::NumberOfBytesType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#167
Aws::KMS::ClientApi::OriginType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#168
Aws::KMS::ClientApi::PendingWindowInDaysType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#169
Aws::KMS::ClientApi::PlaintextType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BlobShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#170
Aws::KMS::ClientApi::PolicyNameList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#171
Aws::KMS::ClientApi::PolicyNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#172
Aws::KMS::ClientApi::PolicyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#173
Aws::KMS::ClientApi::PrincipalIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#174
Aws::KMS::ClientApi::PublicKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BlobShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#175
Aws::KMS::ClientApi::PutKeyPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#176
Aws::KMS::ClientApi::ReEncryptRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#177
Aws::KMS::ClientApi::ReEncryptResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#178
Aws::KMS::ClientApi::RegionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#179
Aws::KMS::ClientApi::ReplicateKeyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#180
Aws::KMS::ClientApi::ReplicateKeyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#181
Aws::KMS::ClientApi::RetireGrantRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#182
Aws::KMS::ClientApi::RevokeGrantRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#183
Aws::KMS::ClientApi::ScheduleKeyDeletionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#184
Aws::KMS::ClientApi::ScheduleKeyDeletionResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#185
Aws::KMS::ClientApi::SignRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#186
Aws::KMS::ClientApi::SignResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#187
Aws::KMS::ClientApi::SigningAlgorithmSpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#188
Aws::KMS::ClientApi::SigningAlgorithmSpecList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#189
Aws::KMS::ClientApi::Tag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#190
Aws::KMS::ClientApi::TagException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#191
Aws::KMS::ClientApi::TagKeyList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#192
Aws::KMS::ClientApi::TagKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#193
Aws::KMS::ClientApi::TagList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#194
Aws::KMS::ClientApi::TagResourceRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#195
Aws::KMS::ClientApi::TagValueType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#196
Aws::KMS::ClientApi::TrustAnchorCertificateType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#197
Aws::KMS::ClientApi::UnsupportedOperationException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#198
Aws::KMS::ClientApi::UntagResourceRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#199
Aws::KMS::ClientApi::UpdateAliasRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#200
Aws::KMS::ClientApi::UpdateCustomKeyStoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#201
Aws::KMS::ClientApi::UpdateCustomKeyStoreResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#202
Aws::KMS::ClientApi::UpdateKeyDescriptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#203
Aws::KMS::ClientApi::UpdatePrimaryRegionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#204
Aws::KMS::ClientApi::VerifyMacRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#205
Aws::KMS::ClientApi::VerifyMacResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#206
Aws::KMS::ClientApi::VerifyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#207
Aws::KMS::ClientApi::VerifyResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#208
Aws::KMS::ClientApi::WrappingKeySpec = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#209
Aws::KMS::ClientApi::XksKeyAlreadyInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#210
Aws::KMS::ClientApi::XksKeyConfigurationType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#211
Aws::KMS::ClientApi::XksKeyIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#212
Aws::KMS::ClientApi::XksKeyInvalidConfigurationException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#213
Aws::KMS::ClientApi::XksKeyNotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#214
Aws::KMS::ClientApi::XksProxyAuthenticationAccessKeyIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#215
Aws::KMS::ClientApi::XksProxyAuthenticationCredentialType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#216
Aws::KMS::ClientApi::XksProxyAuthenticationRawSecretAccessKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#217
Aws::KMS::ClientApi::XksProxyConfigurationType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#218
Aws::KMS::ClientApi::XksProxyConnectivityType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#219
Aws::KMS::ClientApi::XksProxyIncorrectAuthenticationCredentialException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#220
Aws::KMS::ClientApi::XksProxyInvalidConfigurationException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#221
Aws::KMS::ClientApi::XksProxyInvalidResponseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#222
Aws::KMS::ClientApi::XksProxyUriEndpointInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#223
Aws::KMS::ClientApi::XksProxyUriEndpointType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#224
Aws::KMS::ClientApi::XksProxyUriInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#225
Aws::KMS::ClientApi::XksProxyUriPathType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#226
Aws::KMS::ClientApi::XksProxyUriUnreachableException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#227
Aws::KMS::ClientApi::XksProxyVpcEndpointServiceInUseException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#228
Aws::KMS::ClientApi::XksProxyVpcEndpointServiceInvalidConfigurationException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#229
Aws::KMS::ClientApi::XksProxyVpcEndpointServiceNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/client_api.rb#230
Aws::KMS::ClientApi::XksProxyVpcEndpointServiceNotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# Endpoint parameters used to influence endpoints per request.
class Aws::KMS::EndpointParameters < ::Struct
  include ::Aws::Structure

  # @return [EndpointParameters] a new instance of EndpointParameters
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/endpoint_parameters.rb#51
  def initialize(options = T.unsafe(nil)); end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint; end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint=(_); end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region; end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region=(_); end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack; end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack=(_); end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips; end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Aws::KMS::EndpointProvider
  # @return [EndpointProvider] a new instance of EndpointProvider
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/endpoint_provider.rb#12
  def initialize(rule_set = T.unsafe(nil)); end

  # source://aws-sdk-kms//lib/aws-sdk-kms/endpoint_provider.rb#25
  def resolve_endpoint(parameters); end
end

# @api private
#
# source://aws-sdk-kms//lib/aws-sdk-kms/endpoint_provider.rb#30
Aws::KMS::EndpointProvider::RULES = T.let(T.unsafe(nil), String)

module Aws::KMS::Endpoints; end

class Aws::KMS::Endpoints::CancelKeyDeletion
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#15
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ConnectCustomKeyStore
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#29
    def build(context); end
  end
end

class Aws::KMS::Endpoints::CreateAlias
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#43
    def build(context); end
  end
end

class Aws::KMS::Endpoints::CreateCustomKeyStore
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#57
    def build(context); end
  end
end

class Aws::KMS::Endpoints::CreateGrant
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#71
    def build(context); end
  end
end

class Aws::KMS::Endpoints::CreateKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#85
    def build(context); end
  end
end

class Aws::KMS::Endpoints::Decrypt
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#99
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DeleteAlias
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#113
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DeleteCustomKeyStore
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#127
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DeleteImportedKeyMaterial
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#141
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DescribeCustomKeyStores
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#155
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DescribeKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#169
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DisableKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#183
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DisableKeyRotation
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#197
    def build(context); end
  end
end

class Aws::KMS::Endpoints::DisconnectCustomKeyStore
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#211
    def build(context); end
  end
end

class Aws::KMS::Endpoints::EnableKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#225
    def build(context); end
  end
end

class Aws::KMS::Endpoints::EnableKeyRotation
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#239
    def build(context); end
  end
end

class Aws::KMS::Endpoints::Encrypt
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#253
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateDataKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#267
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateDataKeyPair
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#281
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateDataKeyPairWithoutPlaintext
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#295
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateDataKeyWithoutPlaintext
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#309
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateMac
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#323
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GenerateRandom
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#337
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GetKeyPolicy
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#351
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GetKeyRotationStatus
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#365
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GetParametersForImport
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#379
    def build(context); end
  end
end

class Aws::KMS::Endpoints::GetPublicKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#393
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ImportKeyMaterial
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#407
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListAliases
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#421
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListGrants
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#435
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListKeyPolicies
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#449
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListKeys
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#463
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListResourceTags
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#477
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ListRetirableGrants
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#491
    def build(context); end
  end
end

class Aws::KMS::Endpoints::PutKeyPolicy
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#505
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ReEncrypt
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#519
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ReplicateKey
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#533
    def build(context); end
  end
end

class Aws::KMS::Endpoints::RetireGrant
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#547
    def build(context); end
  end
end

class Aws::KMS::Endpoints::RevokeGrant
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#561
    def build(context); end
  end
end

class Aws::KMS::Endpoints::ScheduleKeyDeletion
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#575
    def build(context); end
  end
end

class Aws::KMS::Endpoints::Sign
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#589
    def build(context); end
  end
end

class Aws::KMS::Endpoints::TagResource
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#603
    def build(context); end
  end
end

class Aws::KMS::Endpoints::UntagResource
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#617
    def build(context); end
  end
end

class Aws::KMS::Endpoints::UpdateAlias
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#631
    def build(context); end
  end
end

class Aws::KMS::Endpoints::UpdateCustomKeyStore
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#645
    def build(context); end
  end
end

class Aws::KMS::Endpoints::UpdateKeyDescription
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#659
    def build(context); end
  end
end

class Aws::KMS::Endpoints::UpdatePrimaryRegion
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#673
    def build(context); end
  end
end

class Aws::KMS::Endpoints::Verify
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#687
    def build(context); end
  end
end

class Aws::KMS::Endpoints::VerifyMac
  class << self
    # source://aws-sdk-kms//lib/aws-sdk-kms/endpoints.rb#701
    def build(context); end
  end
end

# When KMS returns an error response, the Ruby SDK constructs and raises an error.
# These errors all extend Aws::KMS::Errors::ServiceError < {Aws::Errors::ServiceError}
#
# You can rescue all KMS errors using ServiceError:
#
#     begin
#       # do stuff
#     rescue Aws::KMS::Errors::ServiceError
#       # rescues all KMS API errors
#     end
#
#
# ## Request Context
# ServiceError objects have a {Aws::Errors::ServiceError#context #context} method that returns
# information about the request that generated the error.
# See {Seahorse::Client::RequestContext} for more information.
#
# ## Error Classes
# * {AlreadyExistsException}
# * {CloudHsmClusterInUseException}
# * {CloudHsmClusterInvalidConfigurationException}
# * {CloudHsmClusterNotActiveException}
# * {CloudHsmClusterNotFoundException}
# * {CloudHsmClusterNotRelatedException}
# * {CustomKeyStoreHasCMKsException}
# * {CustomKeyStoreInvalidStateException}
# * {CustomKeyStoreNameInUseException}
# * {CustomKeyStoreNotFoundException}
# * {DependencyTimeoutException}
# * {DisabledException}
# * {ExpiredImportTokenException}
# * {IncorrectKeyException}
# * {IncorrectKeyMaterialException}
# * {IncorrectTrustAnchorException}
# * {InvalidAliasNameException}
# * {InvalidArnException}
# * {InvalidCiphertextException}
# * {InvalidGrantIdException}
# * {InvalidGrantTokenException}
# * {InvalidImportTokenException}
# * {InvalidKeyUsageException}
# * {InvalidMarkerException}
# * {KMSInternalException}
# * {KMSInvalidMacException}
# * {KMSInvalidSignatureException}
# * {KMSInvalidStateException}
# * {KeyUnavailableException}
# * {LimitExceededException}
# * {MalformedPolicyDocumentException}
# * {NotFoundException}
# * {TagException}
# * {UnsupportedOperationException}
# * {XksKeyAlreadyInUseException}
# * {XksKeyInvalidConfigurationException}
# * {XksKeyNotFoundException}
# * {XksProxyIncorrectAuthenticationCredentialException}
# * {XksProxyInvalidConfigurationException}
# * {XksProxyInvalidResponseException}
# * {XksProxyUriEndpointInUseException}
# * {XksProxyUriInUseException}
# * {XksProxyUriUnreachableException}
# * {XksProxyVpcEndpointServiceInUseException}
# * {XksProxyVpcEndpointServiceInvalidConfigurationException}
# * {XksProxyVpcEndpointServiceNotFoundException}
#
# Additionally, error classes are dynamically generated for service errors based on the error code
# if they are not defined above.
module Aws::KMS::Errors
  extend ::Aws::Errors::DynamicErrors
end

class Aws::KMS::Errors::AlreadyExistsException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::AlreadyExistsException]
  # @return [AlreadyExistsException] a new instance of AlreadyExistsException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#88
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#93
  def message; end
end

class Aws::KMS::Errors::CloudHsmClusterInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CloudHsmClusterInUseException]
  # @return [CloudHsmClusterInUseException] a new instance of CloudHsmClusterInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#103
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#108
  def message; end
end

class Aws::KMS::Errors::CloudHsmClusterInvalidConfigurationException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CloudHsmClusterInvalidConfigurationException]
  # @return [CloudHsmClusterInvalidConfigurationException] a new instance of CloudHsmClusterInvalidConfigurationException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#118
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#123
  def message; end
end

class Aws::KMS::Errors::CloudHsmClusterNotActiveException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CloudHsmClusterNotActiveException]
  # @return [CloudHsmClusterNotActiveException] a new instance of CloudHsmClusterNotActiveException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#133
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#138
  def message; end
end

class Aws::KMS::Errors::CloudHsmClusterNotFoundException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CloudHsmClusterNotFoundException]
  # @return [CloudHsmClusterNotFoundException] a new instance of CloudHsmClusterNotFoundException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#148
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#153
  def message; end
end

class Aws::KMS::Errors::CloudHsmClusterNotRelatedException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CloudHsmClusterNotRelatedException]
  # @return [CloudHsmClusterNotRelatedException] a new instance of CloudHsmClusterNotRelatedException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#163
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#168
  def message; end
end

class Aws::KMS::Errors::CustomKeyStoreHasCMKsException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CustomKeyStoreHasCMKsException]
  # @return [CustomKeyStoreHasCMKsException] a new instance of CustomKeyStoreHasCMKsException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#178
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#183
  def message; end
end

class Aws::KMS::Errors::CustomKeyStoreInvalidStateException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CustomKeyStoreInvalidStateException]
  # @return [CustomKeyStoreInvalidStateException] a new instance of CustomKeyStoreInvalidStateException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#193
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#198
  def message; end
end

class Aws::KMS::Errors::CustomKeyStoreNameInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CustomKeyStoreNameInUseException]
  # @return [CustomKeyStoreNameInUseException] a new instance of CustomKeyStoreNameInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#208
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#213
  def message; end
end

class Aws::KMS::Errors::CustomKeyStoreNotFoundException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::CustomKeyStoreNotFoundException]
  # @return [CustomKeyStoreNotFoundException] a new instance of CustomKeyStoreNotFoundException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#223
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#228
  def message; end
end

class Aws::KMS::Errors::DependencyTimeoutException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::DependencyTimeoutException]
  # @return [DependencyTimeoutException] a new instance of DependencyTimeoutException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#238
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#243
  def message; end
end

class Aws::KMS::Errors::DisabledException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::DisabledException]
  # @return [DisabledException] a new instance of DisabledException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#253
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#258
  def message; end
end

class Aws::KMS::Errors::ExpiredImportTokenException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::ExpiredImportTokenException]
  # @return [ExpiredImportTokenException] a new instance of ExpiredImportTokenException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#268
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#273
  def message; end
end

class Aws::KMS::Errors::IncorrectKeyException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::IncorrectKeyException]
  # @return [IncorrectKeyException] a new instance of IncorrectKeyException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#283
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#288
  def message; end
end

class Aws::KMS::Errors::IncorrectKeyMaterialException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::IncorrectKeyMaterialException]
  # @return [IncorrectKeyMaterialException] a new instance of IncorrectKeyMaterialException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#298
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#303
  def message; end
end

class Aws::KMS::Errors::IncorrectTrustAnchorException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::IncorrectTrustAnchorException]
  # @return [IncorrectTrustAnchorException] a new instance of IncorrectTrustAnchorException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#313
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#318
  def message; end
end

class Aws::KMS::Errors::InvalidAliasNameException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidAliasNameException]
  # @return [InvalidAliasNameException] a new instance of InvalidAliasNameException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#328
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#333
  def message; end
end

class Aws::KMS::Errors::InvalidArnException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidArnException]
  # @return [InvalidArnException] a new instance of InvalidArnException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#343
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#348
  def message; end
end

class Aws::KMS::Errors::InvalidCiphertextException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidCiphertextException]
  # @return [InvalidCiphertextException] a new instance of InvalidCiphertextException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#358
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#363
  def message; end
end

class Aws::KMS::Errors::InvalidGrantIdException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidGrantIdException]
  # @return [InvalidGrantIdException] a new instance of InvalidGrantIdException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#373
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#378
  def message; end
end

class Aws::KMS::Errors::InvalidGrantTokenException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidGrantTokenException]
  # @return [InvalidGrantTokenException] a new instance of InvalidGrantTokenException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#388
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#393
  def message; end
end

class Aws::KMS::Errors::InvalidImportTokenException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidImportTokenException]
  # @return [InvalidImportTokenException] a new instance of InvalidImportTokenException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#403
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#408
  def message; end
end

class Aws::KMS::Errors::InvalidKeyUsageException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidKeyUsageException]
  # @return [InvalidKeyUsageException] a new instance of InvalidKeyUsageException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#418
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#423
  def message; end
end

class Aws::KMS::Errors::InvalidMarkerException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::InvalidMarkerException]
  # @return [InvalidMarkerException] a new instance of InvalidMarkerException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#433
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#438
  def message; end
end

class Aws::KMS::Errors::KMSInternalException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::KMSInternalException]
  # @return [KMSInternalException] a new instance of KMSInternalException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#448
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#453
  def message; end
end

class Aws::KMS::Errors::KMSInvalidMacException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::KMSInvalidMacException]
  # @return [KMSInvalidMacException] a new instance of KMSInvalidMacException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#463
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#468
  def message; end
end

class Aws::KMS::Errors::KMSInvalidSignatureException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::KMSInvalidSignatureException]
  # @return [KMSInvalidSignatureException] a new instance of KMSInvalidSignatureException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#478
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#483
  def message; end
end

class Aws::KMS::Errors::KMSInvalidStateException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::KMSInvalidStateException]
  # @return [KMSInvalidStateException] a new instance of KMSInvalidStateException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#493
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#498
  def message; end
end

class Aws::KMS::Errors::KeyUnavailableException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::KeyUnavailableException]
  # @return [KeyUnavailableException] a new instance of KeyUnavailableException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#508
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#513
  def message; end
end

class Aws::KMS::Errors::LimitExceededException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::LimitExceededException]
  # @return [LimitExceededException] a new instance of LimitExceededException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#523
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#528
  def message; end
end

class Aws::KMS::Errors::MalformedPolicyDocumentException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::MalformedPolicyDocumentException]
  # @return [MalformedPolicyDocumentException] a new instance of MalformedPolicyDocumentException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#538
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#543
  def message; end
end

class Aws::KMS::Errors::NotFoundException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::NotFoundException]
  # @return [NotFoundException] a new instance of NotFoundException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#553
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#558
  def message; end
end

class Aws::KMS::Errors::ServiceError < ::Aws::Errors::ServiceError; end

class Aws::KMS::Errors::TagException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::TagException]
  # @return [TagException] a new instance of TagException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#568
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#573
  def message; end
end

class Aws::KMS::Errors::UnsupportedOperationException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::UnsupportedOperationException]
  # @return [UnsupportedOperationException] a new instance of UnsupportedOperationException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#583
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#588
  def message; end
end

class Aws::KMS::Errors::XksKeyAlreadyInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksKeyAlreadyInUseException]
  # @return [XksKeyAlreadyInUseException] a new instance of XksKeyAlreadyInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#598
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#603
  def message; end
end

class Aws::KMS::Errors::XksKeyInvalidConfigurationException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksKeyInvalidConfigurationException]
  # @return [XksKeyInvalidConfigurationException] a new instance of XksKeyInvalidConfigurationException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#613
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#618
  def message; end
end

class Aws::KMS::Errors::XksKeyNotFoundException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksKeyNotFoundException]
  # @return [XksKeyNotFoundException] a new instance of XksKeyNotFoundException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#628
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#633
  def message; end
end

class Aws::KMS::Errors::XksProxyIncorrectAuthenticationCredentialException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyIncorrectAuthenticationCredentialException]
  # @return [XksProxyIncorrectAuthenticationCredentialException] a new instance of XksProxyIncorrectAuthenticationCredentialException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#643
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#648
  def message; end
end

class Aws::KMS::Errors::XksProxyInvalidConfigurationException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyInvalidConfigurationException]
  # @return [XksProxyInvalidConfigurationException] a new instance of XksProxyInvalidConfigurationException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#658
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#663
  def message; end
end

class Aws::KMS::Errors::XksProxyInvalidResponseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyInvalidResponseException]
  # @return [XksProxyInvalidResponseException] a new instance of XksProxyInvalidResponseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#673
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#678
  def message; end
end

class Aws::KMS::Errors::XksProxyUriEndpointInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyUriEndpointInUseException]
  # @return [XksProxyUriEndpointInUseException] a new instance of XksProxyUriEndpointInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#688
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#693
  def message; end
end

class Aws::KMS::Errors::XksProxyUriInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyUriInUseException]
  # @return [XksProxyUriInUseException] a new instance of XksProxyUriInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#703
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#708
  def message; end
end

class Aws::KMS::Errors::XksProxyUriUnreachableException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyUriUnreachableException]
  # @return [XksProxyUriUnreachableException] a new instance of XksProxyUriUnreachableException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#718
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#723
  def message; end
end

class Aws::KMS::Errors::XksProxyVpcEndpointServiceInUseException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyVpcEndpointServiceInUseException]
  # @return [XksProxyVpcEndpointServiceInUseException] a new instance of XksProxyVpcEndpointServiceInUseException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#733
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#738
  def message; end
end

class Aws::KMS::Errors::XksProxyVpcEndpointServiceInvalidConfigurationException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyVpcEndpointServiceInvalidConfigurationException]
  # @return [XksProxyVpcEndpointServiceInvalidConfigurationException] a new instance of XksProxyVpcEndpointServiceInvalidConfigurationException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#748
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#753
  def message; end
end

class Aws::KMS::Errors::XksProxyVpcEndpointServiceNotFoundException < ::Aws::KMS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::KMS::Types::XksProxyVpcEndpointServiceNotFoundException]
  # @return [XksProxyVpcEndpointServiceNotFoundException] a new instance of XksProxyVpcEndpointServiceNotFoundException
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#763
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/errors.rb#768
  def message; end
end

# source://aws-sdk-kms//lib/aws-sdk-kms.rb#55
Aws::KMS::GEM_VERSION = T.let(T.unsafe(nil), String)

module Aws::KMS::Plugins; end

class Aws::KMS::Plugins::Endpoints < ::Seahorse::Client::Plugin
  # source://aws-sdk-kms//lib/aws-sdk-kms/plugins/endpoints.rb#163
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::KMS::Plugins::Endpoints::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/plugins/endpoints.rb#27
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/plugins/endpoints.rb#46
  def apply_endpoint_headers(context, headers); end

  # @api private
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/plugins/endpoints.rb#57
  def parameters_for_operation(context); end
end

class Aws::KMS::Resource
  # @option options
  # @param options [{}]
  # @return [Resource] a new instance of Resource
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/resource.rb#16
  def initialize(options = T.unsafe(nil)); end

  # @return [Client]
  #
  # source://aws-sdk-kms//lib/aws-sdk-kms/resource.rb#21
  def client; end
end

module Aws::KMS::Types; end

# Contains information about an alias.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/AliasListEntry AWS API Documentation
class Aws::KMS::Types::AliasListEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#46
Aws::KMS::Types::AliasListEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because it attempted to create a resource
# that already exists.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/AlreadyExistsException AWS API Documentation
class Aws::KMS::Types::AlreadyExistsException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#60
Aws::KMS::Types::AlreadyExistsException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CancelKeyDeletionRequest AWS API Documentation
class Aws::KMS::Types::CancelKeyDeletionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#84
Aws::KMS::Types::CancelKeyDeletionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CancelKeyDeletionResponse AWS API Documentation
class Aws::KMS::Types::CancelKeyDeletionResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#101
Aws::KMS::Types::CancelKeyDeletionResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified CloudHSM cluster is
# already associated with an CloudHSM key store in the account, or it
# shares a backup history with an CloudHSM key store in the account.
# Each CloudHSM key store in the account must be associated with a
# different CloudHSM cluster.
#
# CloudHSM clusters that share a backup history have the same cluster
# certificate. To view the cluster certificate of an CloudHSM cluster,
# use the [DescribeClusters][1] operation.
#
#
#
# [1]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CloudHsmClusterInUseException AWS API Documentation
class Aws::KMS::Types::CloudHsmClusterInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#126
Aws::KMS::Types::CloudHsmClusterInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the associated CloudHSM cluster did
# not meet the configuration requirements for an CloudHSM key store.
#
# * The CloudHSM cluster must be configured with private subnets in at
#   least two different Availability Zones in the Region.
#
# * The [security group for the cluster][1]
#   (cloudhsm-cluster-*&lt;cluster-id&gt;*-sg) must include inbound
#   rules and outbound rules that allow TCP traffic on ports 2223-2225.
#   The **Source** in the inbound rules and the **Destination** in the
#   outbound rules must match the security group ID. These rules are set
#   by default when you create the CloudHSM cluster. Do not delete or
#   change them. To get information about a particular security group,
#   use the [DescribeSecurityGroups][2] operation.
#
# * The CloudHSM cluster must contain at least as many HSMs as the
#   operation requires. To add HSMs, use the CloudHSM [CreateHsm][3]
#   operation.
#
#   For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
#   operations, the CloudHSM cluster must have at least two active HSMs,
#   each in a different Availability Zone. For the ConnectCustomKeyStore
#   operation, the CloudHSM must contain at least one active HSM.
#
# For information about the requirements for an CloudHSM cluster that is
# associated with an CloudHSM key store, see [Assemble the
# Prerequisites][4] in the *Key Management Service Developer Guide*. For
# information about creating a private subnet for an CloudHSM cluster,
# see [Create a Private Subnet][5] in the *CloudHSM User Guide*. For
# information about cluster security groups, see [Configure a Default
# Security Group][1] in the <i> <i>CloudHSM User Guide</i> </i>.
#
#
#
# [1]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html
# [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html
# [3]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html
# [4]: https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore
# [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CloudHsmClusterInvalidConfigurationException AWS API Documentation
class Aws::KMS::Types::CloudHsmClusterInvalidConfigurationException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#177
Aws::KMS::Types::CloudHsmClusterInvalidConfigurationException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the CloudHSM cluster associated with
# the CloudHSM key store is not active. Initialize and activate the
# cluster and try the command again. For detailed instructions, see
# [Getting Started][1] in the *CloudHSM User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CloudHsmClusterNotActiveException AWS API Documentation
class Aws::KMS::Types::CloudHsmClusterNotActiveException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#197
Aws::KMS::Types::CloudHsmClusterNotActiveException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because KMS cannot find the CloudHSM cluster
# with the specified cluster ID. Retry the request with a different
# cluster ID.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CloudHsmClusterNotFoundException AWS API Documentation
class Aws::KMS::Types::CloudHsmClusterNotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#212
Aws::KMS::Types::CloudHsmClusterNotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified CloudHSM cluster has a
# different cluster certificate than the original cluster. You cannot
# use the operation to specify an unrelated cluster for an CloudHSM key
# store.
#
# Specify an CloudHSM cluster that shares a backup history with the
# original cluster. This includes clusters that were created from a
# backup of the current cluster, and clusters that were created from the
# same backup that produced the current cluster.
#
# CloudHSM clusters that share a backup history have the same cluster
# certificate. To view the cluster certificate of an CloudHSM cluster,
# use the [DescribeClusters][1] operation.
#
#
#
# [1]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CloudHsmClusterNotRelatedException AWS API Documentation
class Aws::KMS::Types::CloudHsmClusterNotRelatedException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#241
Aws::KMS::Types::CloudHsmClusterNotRelatedException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ConnectCustomKeyStoreRequest AWS API Documentation
class Aws::KMS::Types::ConnectCustomKeyStoreRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#255
Aws::KMS::Types::ConnectCustomKeyStoreRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ConnectCustomKeyStoreResponse AWS API Documentation
class Aws::KMS::Types::ConnectCustomKeyStoreResponse < ::Aws::EmptyStructure; end

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAliasRequest AWS API Documentation
class Aws::KMS::Types::CreateAliasRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#312
Aws::KMS::Types::CreateAliasRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateCustomKeyStoreRequest AWS API Documentation
class Aws::KMS::Types::CreateCustomKeyStoreRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#531
Aws::KMS::Types::CreateCustomKeyStoreRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateCustomKeyStoreResponse AWS API Documentation
class Aws::KMS::Types::CreateCustomKeyStoreResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#543
Aws::KMS::Types::CreateCustomKeyStoreResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateGrantRequest AWS API Documentation
class Aws::KMS::Types::CreateGrantRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#705
Aws::KMS::Types::CreateGrantRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateGrantResponse AWS API Documentation
class Aws::KMS::Types::CreateGrantResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#735
Aws::KMS::Types::CreateGrantResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKeyRequest AWS API Documentation
class Aws::KMS::Types::CreateKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1096
Aws::KMS::Types::CreateKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKeyResponse AWS API Documentation
class Aws::KMS::Types::CreateKeyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1108
Aws::KMS::Types::CreateKeyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the custom key store contains KMS
# keys. After verifying that you do not need to use the KMS keys, use
# the ScheduleKeyDeletion operation to delete the KMS keys. After they
# are deleted, you can delete the custom key store.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CustomKeyStoreHasCMKsException AWS API Documentation
class Aws::KMS::Types::CustomKeyStoreHasCMKsException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1124
Aws::KMS::Types::CustomKeyStoreHasCMKsException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because of the `ConnectionState` of the
# custom key store. To get the `ConnectionState` of a custom key store,
# use the DescribeCustomKeyStores operation.
#
# This exception is thrown under the following conditions:
#
# * You requested the ConnectCustomKeyStore operation on a custom key
#   store with a `ConnectionState` of `DISCONNECTING` or `FAILED`. This
#   operation is valid for all other `ConnectionState` values. To
#   reconnect a custom key store in a `FAILED` state, disconnect it
#   (DisconnectCustomKeyStore), then connect it
#   (`ConnectCustomKeyStore`).
#
# * You requested the CreateKey operation in a custom key store that is
#   not connected. This operations is valid only when the custom key
#   store `ConnectionState` is `CONNECTED`.
#
# * You requested the DisconnectCustomKeyStore operation on a custom key
#   store with a `ConnectionState` of `DISCONNECTING` or `DISCONNECTED`.
#   This operation is valid for all other `ConnectionState` values.
#
# * You requested the UpdateCustomKeyStore or DeleteCustomKeyStore
#   operation on a custom key store that is not disconnected. This
#   operation is valid only when the custom key store `ConnectionState`
#   is `DISCONNECTED`.
#
# * You requested the GenerateRandom operation in an CloudHSM key store
#   that is not connected. This operation is valid only when the
#   CloudHSM key store `ConnectionState` is `CONNECTED`.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CustomKeyStoreInvalidStateException AWS API Documentation
class Aws::KMS::Types::CustomKeyStoreInvalidStateException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1165
Aws::KMS::Types::CustomKeyStoreInvalidStateException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified custom key store name
# is already assigned to another custom key store in the account. Try
# again with a custom key store name that is unique in the account.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CustomKeyStoreNameInUseException AWS API Documentation
class Aws::KMS::Types::CustomKeyStoreNameInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1180
Aws::KMS::Types::CustomKeyStoreNameInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because KMS cannot find a custom key store
# with the specified key store name or ID.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CustomKeyStoreNotFoundException AWS API Documentation
class Aws::KMS::Types::CustomKeyStoreNotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1194
Aws::KMS::Types::CustomKeyStoreNotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains information about each custom key store in the custom key
# store list.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CustomKeyStoresListEntry AWS API Documentation
class Aws::KMS::Types::CustomKeyStoresListEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1458
Aws::KMS::Types::CustomKeyStoresListEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DecryptRequest AWS API Documentation
class Aws::KMS::Types::DecryptRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1559
Aws::KMS::Types::DecryptRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DecryptResponse AWS API Documentation
class Aws::KMS::Types::DecryptResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1588
Aws::KMS::Types::DecryptResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteAliasRequest AWS API Documentation
class Aws::KMS::Types::DeleteAliasRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1601
Aws::KMS::Types::DeleteAliasRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteCustomKeyStoreRequest AWS API Documentation
class Aws::KMS::Types::DeleteCustomKeyStoreRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1614
Aws::KMS::Types::DeleteCustomKeyStoreRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteCustomKeyStoreResponse AWS API Documentation
class Aws::KMS::Types::DeleteCustomKeyStoreResponse < ::Aws::EmptyStructure; end

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterialRequest AWS API Documentation
class Aws::KMS::Types::DeleteImportedKeyMaterialRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1643
Aws::KMS::Types::DeleteImportedKeyMaterialRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The system timed out while trying to fulfill the request. You can
# retry the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DependencyTimeoutException AWS API Documentation
class Aws::KMS::Types::DependencyTimeoutException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1657
Aws::KMS::Types::DependencyTimeoutException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStoresRequest AWS API Documentation
class Aws::KMS::Types::DescribeCustomKeyStoresRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1700
Aws::KMS::Types::DescribeCustomKeyStoresRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStoresResponse AWS API Documentation
class Aws::KMS::Types::DescribeCustomKeyStoresResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1726
Aws::KMS::Types::DescribeCustomKeyStoresResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKeyRequest AWS API Documentation
class Aws::KMS::Types::DescribeKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1781
Aws::KMS::Types::DescribeKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKeyResponse AWS API Documentation
class Aws::KMS::Types::DescribeKeyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1793
Aws::KMS::Types::DescribeKeyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRequest AWS API Documentation
class Aws::KMS::Types::DisableKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1817
Aws::KMS::Types::DisableKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRotationRequest AWS API Documentation
class Aws::KMS::Types::DisableKeyRotationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1851
Aws::KMS::Types::DisableKeyRotationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified KMS key is not enabled.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisabledException AWS API Documentation
class Aws::KMS::Types::DisabledException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1864
Aws::KMS::Types::DisabledException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStoreRequest AWS API Documentation
class Aws::KMS::Types::DisconnectCustomKeyStoreRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1878
Aws::KMS::Types::DisconnectCustomKeyStoreRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStoreResponse AWS API Documentation
class Aws::KMS::Types::DisconnectCustomKeyStoreResponse < ::Aws::EmptyStructure; end

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKeyRequest AWS API Documentation
class Aws::KMS::Types::EnableKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1906
Aws::KMS::Types::EnableKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKeyRotationRequest AWS API Documentation
class Aws::KMS::Types::EnableKeyRotationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#1942
Aws::KMS::Types::EnableKeyRotationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EncryptRequest AWS API Documentation
class Aws::KMS::Types::EncryptRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2035
Aws::KMS::Types::EncryptRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EncryptResponse AWS API Documentation
class Aws::KMS::Types::EncryptResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2064
Aws::KMS::Types::EncryptResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified import token is
# expired. Use GetParametersForImport to get a new import token and
# public key, use the new public key to encrypt the key material, and
# then try the request again.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ExpiredImportTokenException AWS API Documentation
class Aws::KMS::Types::ExpiredImportTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2080
Aws::KMS::Types::ExpiredImportTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairRequest AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyPairRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2162
Aws::KMS::Types::GenerateDataKeyPairRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairResponse AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyPairResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2205
Aws::KMS::Types::GenerateDataKeyPairResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairWithoutPlaintextRequest AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyPairWithoutPlaintextRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2287
Aws::KMS::Types::GenerateDataKeyPairWithoutPlaintextRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairWithoutPlaintextResponse AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyPairWithoutPlaintextResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2323
Aws::KMS::Types::GenerateDataKeyPairWithoutPlaintextResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyRequest AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2415
Aws::KMS::Types::GenerateDataKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyResponse AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2447
Aws::KMS::Types::GenerateDataKeyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyWithoutPlaintextRequest AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyWithoutPlaintextRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2532
Aws::KMS::Types::GenerateDataKeyWithoutPlaintextRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyWithoutPlaintextResponse AWS API Documentation
class Aws::KMS::Types::GenerateDataKeyWithoutPlaintextResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2556
Aws::KMS::Types::GenerateDataKeyWithoutPlaintextResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateMacRequest AWS API Documentation
class Aws::KMS::Types::GenerateMacRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2610
Aws::KMS::Types::GenerateMacRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateMacResponse AWS API Documentation
class Aws::KMS::Types::GenerateMacResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2639
Aws::KMS::Types::GenerateMacResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateRandomRequest AWS API Documentation
class Aws::KMS::Types::GenerateRandomRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2662
Aws::KMS::Types::GenerateRandomRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateRandomResponse AWS API Documentation
class Aws::KMS::Types::GenerateRandomResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2676
Aws::KMS::Types::GenerateRandomResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyPolicyRequest AWS API Documentation
class Aws::KMS::Types::GetKeyPolicyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2706
Aws::KMS::Types::GetKeyPolicyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyPolicyResponse AWS API Documentation
class Aws::KMS::Types::GetKeyPolicyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2718
Aws::KMS::Types::GetKeyPolicyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatusRequest AWS API Documentation
class Aws::KMS::Types::GetKeyRotationStatusRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2744
Aws::KMS::Types::GetKeyRotationStatusRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatusResponse AWS API Documentation
class Aws::KMS::Types::GetKeyRotationStatusResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2756
Aws::KMS::Types::GetKeyRotationStatusResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImportRequest AWS API Documentation
class Aws::KMS::Types::GetParametersForImportRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2800
Aws::KMS::Types::GetParametersForImportRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImportResponse AWS API Documentation
class Aws::KMS::Types::GetParametersForImportResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2837
Aws::KMS::Types::GetParametersForImportResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKeyRequest AWS API Documentation
class Aws::KMS::Types::GetPublicKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2883
Aws::KMS::Types::GetPublicKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKeyResponse AWS API Documentation
class Aws::KMS::Types::GetPublicKeyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#2960
Aws::KMS::Types::GetPublicKeyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# Use this structure to allow [cryptographic operations][1] in the grant
# only when the operation request includes the specified [encryption
# context][2].
#
# KMS applies the grant constraints only to cryptographic operations
# that support an encryption context, that is, all cryptographic
# operations with a [symmetric KMS key][3]. Grant constraints are not
# applied to operations that do not support an encryption context, such
# as cryptographic operations with asymmetric KMS keys and management
# operations, such as DescribeKey or RetireGrant.
#
# In a cryptographic operation, the encryption context in the decryption
# operation must be an exact, case-sensitive match for the keys and
# values in the encryption context of the encryption operation. Only the
# order of the pairs can vary.
#
#  However, in a grant constraint, the key in each key-value pair is not
# case sensitive, but the value is case sensitive.
#
#  To avoid confusion, do not use multiple encryption context pairs that
# differ only by case. To require a fully case-sensitive encryption
# context, use the `kms:EncryptionContext:` and
# `kms:EncryptionContextKeys` conditions in an IAM or key policy. For
# details, see [kms:EncryptionContext:][4] in the <i> <i>Key Management
# Service Developer Guide</i> </i>.
#
#
#
# [1]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
# [2]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
# [3]: https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#symmetric-cmks
# [4]: https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-context
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GrantConstraints AWS API Documentation
class Aws::KMS::Types::GrantConstraints < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3025
Aws::KMS::Types::GrantConstraints::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains information about a grant.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GrantListEntry AWS API Documentation
class Aws::KMS::Types::GrantListEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3093
Aws::KMS::Types::GrantListEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ImportKeyMaterialRequest AWS API Documentation
class Aws::KMS::Types::ImportKeyMaterialRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3175
Aws::KMS::Types::ImportKeyMaterialRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ImportKeyMaterialResponse AWS API Documentation
class Aws::KMS::Types::ImportKeyMaterialResponse < ::Aws::EmptyStructure; end

# The request was rejected because the specified KMS key cannot decrypt
# the data. The `KeyId` in a Decrypt request and the `SourceKeyId` in a
# ReEncrypt request must identify the same KMS key that was used to
# encrypt the ciphertext.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/IncorrectKeyException AWS API Documentation
class Aws::KMS::Types::IncorrectKeyException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3195
Aws::KMS::Types::IncorrectKeyException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the key material in the request is,
# expired, invalid, or is not the same key material that was previously
# imported into this KMS key.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/IncorrectKeyMaterialException AWS API Documentation
class Aws::KMS::Types::IncorrectKeyMaterialException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3210
Aws::KMS::Types::IncorrectKeyMaterialException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the trust anchor certificate in the
# request to create an CloudHSM key store is not the trust anchor
# certificate for the specified CloudHSM cluster.
#
# When you [initialize the CloudHSM cluster][1], you create the trust
# anchor certificate and save it in the `customerCA.crt` file.
#
#
#
# [1]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/IncorrectTrustAnchorException AWS API Documentation
class Aws::KMS::Types::IncorrectTrustAnchorException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3232
Aws::KMS::Types::IncorrectTrustAnchorException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified alias name is not
# valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidAliasNameException AWS API Documentation
class Aws::KMS::Types::InvalidAliasNameException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3246
Aws::KMS::Types::InvalidAliasNameException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because a specified ARN, or an ARN in a key
# policy, is not valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidArnException AWS API Documentation
class Aws::KMS::Types::InvalidArnException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3260
Aws::KMS::Types::InvalidArnException::SENSITIVE = T.let(T.unsafe(nil), Array)

# From the Decrypt or ReEncrypt operation, the request was rejected
# because the specified ciphertext, or additional authenticated data
# incorporated into the ciphertext, such as the encryption context, is
# corrupted, missing, or otherwise invalid.
#
# From the ImportKeyMaterial operation, the request was rejected because
# KMS could not decrypt the encrypted (wrapped) key material.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidCiphertextException AWS API Documentation
class Aws::KMS::Types::InvalidCiphertextException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3279
Aws::KMS::Types::InvalidCiphertextException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified `GrantId` is not valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidGrantIdException AWS API Documentation
class Aws::KMS::Types::InvalidGrantIdException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3292
Aws::KMS::Types::InvalidGrantIdException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified grant token is not
# valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidGrantTokenException AWS API Documentation
class Aws::KMS::Types::InvalidGrantTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3306
Aws::KMS::Types::InvalidGrantTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the provided import token is invalid
# or is associated with a different KMS key.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidImportTokenException AWS API Documentation
class Aws::KMS::Types::InvalidImportTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3320
Aws::KMS::Types::InvalidImportTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected for one of the following reasons:
#
# * The `KeyUsage` value of the KMS key is incompatible with the API
#   operation.
#
# * The encryption algorithm or signing algorithm specified for the
#   operation is incompatible with the type of key material in the KMS
#   key `(KeySpec`).
#
# For encrypting, decrypting, re-encrypting, and generating data keys,
# the `KeyUsage` must be `ENCRYPT_DECRYPT`. For signing and verifying
# messages, the `KeyUsage` must be `SIGN_VERIFY`. For generating and
# verifying message authentication codes (MACs), the `KeyUsage` must be
# `GENERATE_VERIFY_MAC`. To find the `KeyUsage` of a KMS key, use the
# DescribeKey operation.
#
# To find the encryption or signing algorithms supported for a
# particular KMS key, use the DescribeKey operation.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidKeyUsageException AWS API Documentation
class Aws::KMS::Types::InvalidKeyUsageException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3350
Aws::KMS::Types::InvalidKeyUsageException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the marker that specifies where
# pagination should next begin is not valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/InvalidMarkerException AWS API Documentation
class Aws::KMS::Types::InvalidMarkerException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3364
Aws::KMS::Types::InvalidMarkerException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because an internal exception occurred. The
# request can be retried.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KMSInternalException AWS API Documentation
class Aws::KMS::Types::KMSInternalException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3378
Aws::KMS::Types::KMSInternalException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the HMAC verification failed. HMAC
# verification fails when the HMAC computed by using the specified
# message, HMAC KMS key, and MAC algorithm does not match the HMAC
# specified in the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KMSInvalidMacException AWS API Documentation
class Aws::KMS::Types::KMSInvalidMacException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3394
Aws::KMS::Types::KMSInvalidMacException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the signature verification failed.
# Signature verification fails when it cannot confirm that signature was
# produced by signing the specified message with the specified KMS key
# and signing algorithm.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KMSInvalidSignatureException AWS API Documentation
class Aws::KMS::Types::KMSInvalidSignatureException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3410
Aws::KMS::Types::KMSInvalidSignatureException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the state of the specified resource
# is not valid for this request.
#
# This exceptions means one of the following:
#
# * The key state of the KMS key is not compatible with the operation.
#
#   To find the key state, use the DescribeKey operation. For more
#   information about which key states are compatible with each KMS
#   operation, see [Key states of KMS keys][1] in the <i> <i>Key
#   Management Service Developer Guide</i> </i>.
#
# * For cryptographic operations on KMS keys in custom key stores, this
#   exception represents a general failure with many possible causes. To
#   identify the cause, see the error message that accompanies the
#   exception.
#
#
#
# [1]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KMSInvalidStateException AWS API Documentation
class Aws::KMS::Types::KMSInvalidStateException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3442
Aws::KMS::Types::KMSInvalidStateException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains information about each entry in the key list.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KeyListEntry AWS API Documentation
class Aws::KMS::Types::KeyListEntry < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3461
Aws::KMS::Types::KeyListEntry::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains metadata about a KMS key.
#
# This data type is used as a response element for the CreateKey,
# DescribeKey, and ReplicateKey operations.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KeyMetadata AWS API Documentation
class Aws::KMS::Types::KeyMetadata < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3715
Aws::KMS::Types::KeyMetadata::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified KMS key was not
# available. You can retry the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/KeyUnavailableException AWS API Documentation
class Aws::KMS::Types::KeyUnavailableException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3729
Aws::KMS::Types::KeyUnavailableException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because a quota was exceeded. For more
# information, see [Quotas][1] in the *Key Management Service Developer
# Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/kms/latest/developerguide/limits.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/LimitExceededException AWS API Documentation
class Aws::KMS::Types::LimitExceededException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3748
Aws::KMS::Types::LimitExceededException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListAliasesRequest AWS API Documentation
class Aws::KMS::Types::ListAliasesRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3794
Aws::KMS::Types::ListAliasesRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListAliasesResponse AWS API Documentation
class Aws::KMS::Types::ListAliasesResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3820
Aws::KMS::Types::ListAliasesResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListGrantsRequest AWS API Documentation
class Aws::KMS::Types::ListGrantsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3877
Aws::KMS::Types::ListGrantsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListGrantsResponse AWS API Documentation
class Aws::KMS::Types::ListGrantsResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3903
Aws::KMS::Types::ListGrantsResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeyPoliciesRequest AWS API Documentation
class Aws::KMS::Types::ListKeyPoliciesRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3947
Aws::KMS::Types::ListKeyPoliciesRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeyPoliciesResponse AWS API Documentation
class Aws::KMS::Types::ListKeyPoliciesResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3973
Aws::KMS::Types::ListKeyPoliciesResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeysRequest AWS API Documentation
class Aws::KMS::Types::ListKeysRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#3998
Aws::KMS::Types::ListKeysRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeysResponse AWS API Documentation
class Aws::KMS::Types::ListKeysResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4024
Aws::KMS::Types::ListKeysResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListResourceTagsRequest AWS API Documentation
class Aws::KMS::Types::ListResourceTagsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4068
Aws::KMS::Types::ListResourceTagsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListResourceTagsResponse AWS API Documentation
class Aws::KMS::Types::ListResourceTagsResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4106
Aws::KMS::Types::ListResourceTagsResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListRetirableGrantsRequest AWS API Documentation
class Aws::KMS::Types::ListRetirableGrantsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4150
Aws::KMS::Types::ListRetirableGrantsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified policy is not
# syntactically or semantically correct.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/MalformedPolicyDocumentException AWS API Documentation
class Aws::KMS::Types::MalformedPolicyDocumentException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4164
Aws::KMS::Types::MalformedPolicyDocumentException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes the configuration of this multi-Region key. This field
# appears only when the KMS key is a primary or replica of a
# multi-Region key.
#
# For more information about any listed KMS key, use the DescribeKey
# operation.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/MultiRegionConfiguration AWS API Documentation
class Aws::KMS::Types::MultiRegionConfiguration < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4195
Aws::KMS::Types::MultiRegionConfiguration::SENSITIVE = T.let(T.unsafe(nil), Array)

# Describes the primary or replica key in a multi-Region key.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/MultiRegionKey AWS API Documentation
class Aws::KMS::Types::MultiRegionKey < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4216
Aws::KMS::Types::MultiRegionKey::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified entity or resource
# could not be found.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/NotFoundException AWS API Documentation
class Aws::KMS::Types::NotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4230
Aws::KMS::Types::NotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/PutKeyPolicyRequest AWS API Documentation
class Aws::KMS::Types::PutKeyPolicyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4331
Aws::KMS::Types::PutKeyPolicyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReEncryptRequest AWS API Documentation
class Aws::KMS::Types::ReEncryptRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4495
Aws::KMS::Types::ReEncryptRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReEncryptResponse AWS API Documentation
class Aws::KMS::Types::ReEncryptResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4536
Aws::KMS::Types::ReEncryptResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKeyRequest AWS API Documentation
class Aws::KMS::Types::ReplicateKeyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4729
Aws::KMS::Types::ReplicateKeyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKeyResponse AWS API Documentation
class Aws::KMS::Types::ReplicateKeyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4761
Aws::KMS::Types::ReplicateKeyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RetireGrantRequest AWS API Documentation
class Aws::KMS::Types::RetireGrantRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4804
Aws::KMS::Types::RetireGrantRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrantRequest AWS API Documentation
class Aws::KMS::Types::RevokeGrantRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4838
Aws::KMS::Types::RevokeGrantRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ScheduleKeyDeletionRequest AWS API Documentation
class Aws::KMS::Types::ScheduleKeyDeletionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4875
Aws::KMS::Types::ScheduleKeyDeletionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ScheduleKeyDeletionResponse AWS API Documentation
class Aws::KMS::Types::ScheduleKeyDeletionResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4923
Aws::KMS::Types::ScheduleKeyDeletionResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/SignRequest AWS API Documentation
class Aws::KMS::Types::SignRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#4996
Aws::KMS::Types::SignRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/SignResponse AWS API Documentation
class Aws::KMS::Types::SignResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5040
Aws::KMS::Types::SignResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# A key-value pair. A tag consists of a tag key and a tag value. Tag
# keys and tag values are both required, but tag values can be empty
# (null) strings.
#
# For information about the rules that apply to tag keys and tag values,
# see [User-Defined Tag Restrictions][1] in the *Amazon Web Services
# Billing and Cost Management User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Tag AWS API Documentation
class Aws::KMS::Types::Tag < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5069
Aws::KMS::Types::Tag::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because one or more tags are not valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/TagException AWS API Documentation
class Aws::KMS::Types::TagException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5082
Aws::KMS::Types::TagException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/TagResourceRequest AWS API Documentation
class Aws::KMS::Types::TagResourceRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5118
Aws::KMS::Types::TagResourceRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because a specified parameter is not
# supported or a specified resource is not valid for this operation.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UnsupportedOperationException AWS API Documentation
class Aws::KMS::Types::UnsupportedOperationException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5132
Aws::KMS::Types::UnsupportedOperationException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UntagResourceRequest AWS API Documentation
class Aws::KMS::Types::UntagResourceRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5161
Aws::KMS::Types::UntagResourceRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateAliasRequest AWS API Documentation
class Aws::KMS::Types::UpdateAliasRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5208
Aws::KMS::Types::UpdateAliasRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateCustomKeyStoreRequest AWS API Documentation
class Aws::KMS::Types::UpdateCustomKeyStoreRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5359
Aws::KMS::Types::UpdateCustomKeyStoreRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateCustomKeyStoreResponse AWS API Documentation
class Aws::KMS::Types::UpdateCustomKeyStoreResponse < ::Aws::EmptyStructure; end

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateKeyDescriptionRequest AWS API Documentation
class Aws::KMS::Types::UpdateKeyDescriptionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5392
Aws::KMS::Types::UpdateKeyDescriptionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdatePrimaryRegionRequest AWS API Documentation
class Aws::KMS::Types::UpdatePrimaryRegionRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5427
Aws::KMS::Types::UpdatePrimaryRegionRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyMacRequest AWS API Documentation
class Aws::KMS::Types::VerifyMacRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5482
Aws::KMS::Types::VerifyMacRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyMacResponse AWS API Documentation
class Aws::KMS::Types::VerifyMacResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5510
Aws::KMS::Types::VerifyMacResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyRequest AWS API Documentation
class Aws::KMS::Types::VerifyRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5593
Aws::KMS::Types::VerifyRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyResponse AWS API Documentation
class Aws::KMS::Types::VerifyResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5624
Aws::KMS::Types::VerifyResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the (`XksKeyId`) is already
# associated with a KMS key in this external key store. Each KMS key in
# an external key store must be associated with a different external
# key.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksKeyAlreadyInUseException AWS API Documentation
class Aws::KMS::Types::XksKeyAlreadyInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5640
Aws::KMS::Types::XksKeyAlreadyInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Information about the [external key ][1]that is associated with a KMS
# key in an external key store.
#
# This element appears in a CreateKey or DescribeKey response only for a
# KMS key in an external key store.
#
# The *external key* is a symmetric encryption key that is hosted by an
# external key manager outside of Amazon Web Services. When you use the
# KMS key in an external key store in a cryptographic operation, the
# cryptographic operation is performed in the external key manager using
# the specified external key. For more information, see [External
# key][1] in the *Key Management Service Developer Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksKeyConfigurationType AWS API Documentation
class Aws::KMS::Types::XksKeyConfigurationType < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5671
Aws::KMS::Types::XksKeyConfigurationType::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the external key specified by the
# `XksKeyId` parameter did not meet the configuration requirements for
# an external key store.
#
# The external key must be an AES-256 symmetric key that is enabled and
# performs encryption and decryption.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksKeyInvalidConfigurationException AWS API Documentation
class Aws::KMS::Types::XksKeyInvalidConfigurationException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5689
Aws::KMS::Types::XksKeyInvalidConfigurationException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the external key store proxy could
# not find the external key. This exception is thrown when the value of
# the `XksKeyId` parameter doesn't identify a key in the external key
# manager associated with the external key proxy.
#
# Verify that the `XksKeyId` represents an existing key in the external
# key manager. Use the key identifier that the external key store proxy
# uses to identify the key. For details, see the documentation provided
# with your external key store proxy or key manager.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksKeyNotFoundException AWS API Documentation
class Aws::KMS::Types::XksKeyNotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5710
Aws::KMS::Types::XksKeyNotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)

# KMS uses the authentication credential to sign requests that it sends
# to the external key store proxy (XKS proxy) on your behalf. You
# establish these credentials on your external key store proxy and
# report them to KMS.
#
# The `XksProxyAuthenticationCredential` includes two required elements.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyAuthenticationCredentialType AWS API Documentation
class Aws::KMS::Types::XksProxyAuthenticationCredentialType < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5735
Aws::KMS::Types::XksProxyAuthenticationCredentialType::SENSITIVE = T.let(T.unsafe(nil), Array)

# Detailed information about the external key store proxy (XKS proxy).
# Your external key store proxy translates KMS requests into a format
# that your external key manager can understand. These fields appear in
# a DescribeCustomKeyStores response only when the `CustomKeyStoreType`
# is `EXTERNAL_KEY_STORE`.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyConfigurationType AWS API Documentation
class Aws::KMS::Types::XksProxyConfigurationType < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5789
Aws::KMS::Types::XksProxyConfigurationType::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the proxy credentials failed to
# authenticate to the specified external key store proxy. The specified
# external key store proxy rejected a status request from KMS due to
# invalid credentials. This can indicate an error in the credentials or
# in the identification of the external key store proxy.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyIncorrectAuthenticationCredentialException AWS API Documentation
class Aws::KMS::Types::XksProxyIncorrectAuthenticationCredentialException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5806
Aws::KMS::Types::XksProxyIncorrectAuthenticationCredentialException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the Amazon VPC endpoint service
# configuration does not fulfill the requirements for an external key
# store proxy. For details, see the exception message.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyInvalidConfigurationException AWS API Documentation
class Aws::KMS::Types::XksProxyInvalidConfigurationException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5821
Aws::KMS::Types::XksProxyInvalidConfigurationException::SENSITIVE = T.let(T.unsafe(nil), Array)

# KMS cannot interpret the response it received from the external key
# store proxy. The problem might be a poorly constructed response, but
# it could also be a transient network issue. If you see this error
# repeatedly, report it to the proxy vendor.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyInvalidResponseException AWS API Documentation
class Aws::KMS::Types::XksProxyInvalidResponseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5837
Aws::KMS::Types::XksProxyInvalidResponseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the concatenation of the
# `XksProxyUriEndpoint` is already associated with an external key store
# in the Amazon Web Services account and Region. Each external key store
# in an account and Region must use a unique external key store proxy
# address.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyUriEndpointInUseException AWS API Documentation
class Aws::KMS::Types::XksProxyUriEndpointInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5854
Aws::KMS::Types::XksProxyUriEndpointInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the concatenation of the
# `XksProxyUriEndpoint` and `XksProxyUriPath` is already associated with
# an external key store in the Amazon Web Services account and Region.
# Each external key store in an account and Region must use a unique
# external key store proxy API address.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyUriInUseException AWS API Documentation
class Aws::KMS::Types::XksProxyUriInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5871
Aws::KMS::Types::XksProxyUriInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# KMS was unable to reach the specified `XksProxyUriPath`. The path must
# be reachable before you create the external key store or update its
# settings.
#
# This exception is also thrown when the external key store proxy
# response to a `GetHealthStatus` request indicates that all external
# key manager instances are unavailable.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyUriUnreachableException AWS API Documentation
class Aws::KMS::Types::XksProxyUriUnreachableException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5890
Aws::KMS::Types::XksProxyUriUnreachableException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the specified Amazon VPC endpoint
# service is already associated with an external key store in the Amazon
# Web Services account and Region. Each external key store in an Amazon
# Web Services account and Region must use a different Amazon VPC
# endpoint service.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyVpcEndpointServiceInUseException AWS API Documentation
class Aws::KMS::Types::XksProxyVpcEndpointServiceInUseException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5907
Aws::KMS::Types::XksProxyVpcEndpointServiceInUseException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the Amazon VPC endpoint service
# configuration does not fulfill the requirements for an external key
# store proxy. For details, see the exception message and [review the
# requirements](kms/latest/developerguide/vpc-connectivity.html#xks-vpc-requirements)
# for Amazon VPC endpoint service connectivity for an external key
# store.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyVpcEndpointServiceInvalidConfigurationException AWS API Documentation
class Aws::KMS::Types::XksProxyVpcEndpointServiceInvalidConfigurationException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5925
Aws::KMS::Types::XksProxyVpcEndpointServiceInvalidConfigurationException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because KMS could not find the specified VPC
# endpoint service. Use DescribeCustomKeyStores to verify the VPC
# endpoint service name for the external key store. Also, confirm that
# the `Allow principals` list for the VPC endpoint service includes the
# KMS service principal for the Region, such as
# `cks.kms.us-east-1.amazonaws.com`.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/XksProxyVpcEndpointServiceNotFoundException AWS API Documentation
class Aws::KMS::Types::XksProxyVpcEndpointServiceNotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-kms//lib/aws-sdk-kms/types.rb#5943
Aws::KMS::Types::XksProxyVpcEndpointServiceNotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)
