# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `aws-sdk-core` gem.
# Please instead update this file by running `bin/tapioca gem aws-sdk-core`.

module Aws
  class << self
    # @return [Hash] Returns a hash of default configuration options shared
    #   by all constructed clients.
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#133
    def config; end

    # @param config [Hash]
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#136
    def config=(config); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#195
    def eager_autoload!(*args); end

    # Close any long-lived connections maintained by the SDK's internal
    # connection pool.
    #
    # Applications that rely heavily on the `fork()` system call on POSIX systems
    # should call this method in the child process directly after fork to ensure
    # there are no race conditions between the parent
    # process and its children
    # for the pooled TCP connections.
    #
    # Child processes that make multi-threaded calls to the SDK should block on
    # this call before beginning work.
    #
    # @return [nil]
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#188
    def empty_connection_pools!; end

    # @see (Aws::Partitions.partition)
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#145
    def partition(partition_name); end

    # @see (Aws::Partitions.partitions)
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#150
    def partitions; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#126
    def shared_config; end

    # The SDK ships with a ca certificate bundle to use when verifying SSL
    # peer certificates. By default, this cert bundle is *NOT* used. The
    # SDK will rely on the default cert available to OpenSSL. This ensures
    # the cert provided by your OS is used.
    #
    # For cases where the default cert is unavailable, e.g. Windows, you
    # can call this method.
    #
    #     Aws.use_bundled_cert!
    #
    # @return [String] Returns the path to the bundled cert.
    #
    # source://aws-sdk-core//lib/aws-sdk-core.rb#165
    def use_bundled_cert!; end
  end
end

# Create and provide access to components of Amazon Resource Names (ARN).
#
# You can create an ARN and access it's components like the following:
#
#   arn = Aws::ARN.new(
#     partition: 'aws',
#     service: 's3',
#     region: 'us-west-2',
#     account_id: '12345678910',
#     resource: 'foo/bar'
#   )
#   # => #<Aws::ARN ...>
#
#   arn.to_s
#   # => "arn:aws:s3:us-west-2:12345678910:foo/bar"
#
#   arn.partition
#   # => 'aws'
#   arn.service
#   # => 's3'
#   arn.resource
#   # => foo/bar
#
#   # Note: parser available for parsing resource details
#   @see Aws::ARNParser#parse_resource
#
# @see https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-arns
class Aws::ARN
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [ARN] a new instance of ARN
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#39
  def initialize(options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#57
  def account_id; end

  # Return the ARN as JSON
  #
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#95
  def as_json(_options = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#48
  def partition; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#54
  def region; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#60
  def resource; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#51
  def service; end

  # Return the ARN as a hash
  #
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#82
  def to_h; end

  # Return the ARN format in string
  #
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#75
  def to_s; end

  # Validates ARN contains non-empty required components.
  # Region and account_id can be optional.
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/arn.rb#66
  def valid?; end
end

module Aws::ARNParser
  class << self
    # Checks whether a String could be a ARN or not. An ARN starts with 'arn:'
    # and has at least 6 segments separated by a colon (:).
    #
    # @param str [String]
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/arn_parser.rb#36
    def arn?(str); end

    # Parse a string with an ARN format into an {Aws::ARN} object.
    # `InvalidARNError` would be raised when encountering a parsing error or the
    # ARN object contains invalid components (nil/empty).
    #
    # @param arn_str [String]
    # @raise [Aws::Errors::InvalidARNError]
    # @return [Aws::ARN]
    # @see https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-arns
    #
    # source://aws-sdk-core//lib/aws-sdk-core/arn_parser.rb#13
    def parse(arn_str); end
  end
end

# An auto-refreshing credential provider that assumes a role via
# {Aws::STS::Client#assume_role}.
#
#     role_credentials = Aws::AssumeRoleCredentials.new(
#       client: Aws::STS::Client.new(...),
#       role_arn: "linked::account::arn",
#       role_session_name: "session-name"
#     )
#     ec2 = Aws::EC2::Client.new(credentials: role_credentials)
#
# If you omit `:client` option, a new {Aws::STS::Client} object will be
# constructed with additional options that were provided.
#
# @see Aws::STS::Client#assume_role
class Aws::AssumeRoleCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [AssumeRoleCredentials] a new instance of AssumeRoleCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_credentials.rb#41
  def initialize(options = T.unsafe(nil)); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_credentials.rb#60
  def assume_role_params; end

  # @return [STS::Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_credentials.rb#57
  def client; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_credentials.rb#64
  def refresh; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/assume_role_credentials.rb#77
    def assume_role_options; end
  end
end

# An auto-refreshing credential provider that assumes a role via
# {Aws::STS::Client#assume_role_with_web_identity}.
#
#     role_credentials = Aws::AssumeRoleWebIdentityCredentials.new(
#       client: Aws::STS::Client.new(...),
#       role_arn: "linked::account::arn",
#       web_identity_token_file: "/path/to/token/file",
#       role_session_name: "session-name"
#       ...
#     )
#     ec2 = Aws::EC2::Client.new(credentials: role_credentials)
#
# If you omit `:client` option, a new {Aws::STS::Client} object will be
# constructed with additional options that were provided.
#
# @see Aws::STS::Client#assume_role_with_web_identity
class Aws::AssumeRoleWebIdentityCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [AssumeRoleWebIdentityCredentials] a new instance of AssumeRoleWebIdentityCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#46
  def initialize(options = T.unsafe(nil)); end

  # @return [STS::Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#68
  def client; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#93
  def _session_name; end

  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#86
  def _token_from_file(path); end

  # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#72
  def refresh; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/assume_role_web_identity_credentials.rb#100
    def assume_role_web_identity_options; end
  end
end

module Aws::AsyncClientStubs
  include ::Aws::ClientStubs

  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#43
  def send_events; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#9
  def setup_stubbing; end
end

class Aws::AsyncClientStubs::StubStream
  # @return [StubStream] a new instance of StubStream
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#55
  def initialize; end

  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#77
  def close; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#73
  def closed?; end

  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#63
  def data(bytes, options = T.unsafe(nil)); end

  # Returns the value of attribute send_events.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#59
  def send_events; end

  # Sets the attribute send_events
  #
  # @param value the value to set the attribute send_events to.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#59
  def send_events=(_arg0); end

  # Returns the value of attribute state.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/async_client_stubs.rb#61
  def state; end
end

module Aws::Binary; end

# @api private
class Aws::Binary::DecodeHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/decode_handler.rb#9
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/decode_handler.rb#24
  def attach_eventstream_listeners(context, rules); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/decode_handler.rb#18
  def eventstream?(ctx); end
end

# @api private
class Aws::Binary::EncodeHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/encode_handler.rb#9
  def call(context); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/encode_handler.rb#36
  def eventstream_input?(ctx); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/encode_handler.rb#25
  def signer_for(context); end
end

# @api private
class Aws::Binary::EventBuilder
  include ::Seahorse::Model::Shapes

  # @api private
  # @param serializer_class [Class]
  # @param rules [Seahorse::Model::ShapeRef] (of eventstream member)
  # @return [EventBuilder] a new instance of EventBuilder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#12
  def initialize(serializer_class, rules); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#17
  def apply(event_type, params); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#118
  def _build_payload(streaming, ref, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#89
  def _content_type(shape); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#24
  def _event_stream_message(event_ref, params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_builder.rb#105
  def _header_value_type(shape, value); end
end

# @api private
class Aws::Binary::EventParser
  include ::Seahorse::Model::Shapes

  # @api private
  # @param parser_class [Class]
  # @param rules [Seahorse::Model::ShapeRef] (of eventstream member)
  # @param error_refs [Array] array of errors ShapeRef
  # @param output_ref [Seahorse::Model::ShapeRef]
  # @return [EventParser] a new instance of EventParser
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#14
  def initialize(parser_class, rules, error_refs, output_ref); end

  # Parse raw event message into event struct
  # based on its ShapeRef
  #
  # @api private
  # @return [Struct] Event Struct
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#25
  def apply(raw_event); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#125
  def eventpayload_streaming?(ref); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#31
  def parse(raw_event); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#60
  def parse_error_event(raw_event); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#70
  def parse_event(raw_event); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#51
  def parse_exception(raw_event); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_parser.rb#129
  def parse_payload(body, rules); end
end

# @api private
class Aws::Binary::EventStreamDecoder
  # that registered with callbacks for processing events when they arrive
  #
  # @api private
  # @param protocol [String]
  # @param rules [ShapeRef] ShapeRef of the eventstream member
  # @param output_ref [ShapeRef] ShapeRef of output shape
  # @param error_refs [Array] array of ShapeRefs for errors
  # @param event_stream_handler [EventStream|nil] A Service EventStream object
  # @return [EventStreamDecoder] a new instance of EventStreamDecoder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#16
  def initialize(protocol, rules, output_ref, error_refs, io, event_stream_handler = T.unsafe(nil)); end

  # @api private
  # @return [Array] events Array of arrived event objects
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#25
  def events; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#27
  def write(chunk); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#39
  def emit_event(raw_event); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#54
  def extract_stream_class(type_class); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_decoder.rb#45
  def parser_class(protocol); end
end

# @api private
class Aws::Binary::EventStreamEncoder
  # @api private
  # @param protocol [String]
  # @param rules [ShapeRef] ShapeRef of the eventstream member
  # @param input_ref [ShapeRef] ShapeRef of the input shape
  # @param signer [Aws::Sigv4::Signer]
  # @return [EventStreamEncoder] a new instance of EventStreamEncoder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#14
  def initialize(protocol, rules, input_ref, signer); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#27
  def encode(event_type, params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#25
  def prior_signature; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#25
  def prior_signature=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#23
  def rules; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/binary/event_stream_encoder.rb#44
  def serializer_class(protocol); end
end

# source://aws-sdk-core//lib/aws-sdk-core.rb#119
Aws::CORE_GEM_VERSION = T.let(T.unsafe(nil), String)

module Aws::ClientSideMonitoring; end

# @api private
class Aws::ClientSideMonitoring::Publisher
  # @api private
  # @return [Publisher] a new instance of Publisher
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#13
  def initialize(opts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#11
  def agent_host; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#25
  def agent_host=(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#10
  def agent_port; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#19
  def agent_port=(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#31
  def publish(request_metrics); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/publisher.rb#38
  def send_datagram(msg); end
end

# @api private
class Aws::ClientSideMonitoring::RequestMetrics
  # @api private
  # @return [RequestMetrics] a new instance of RequestMetrics
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#22
  def initialize(opts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#54
  def add_call_attempt(attempt); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#7
  def api_call; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#7
  def api_call_attempts; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#33
  def build_call_attempt(opts = T.unsafe(nil)); end
end

# @api private
class Aws::ClientSideMonitoring::RequestMetrics::ApiCall
  # @api private
  # @return [ApiCall] a new instance of ApiCall
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#65
  def initialize(service, api, client_id, version, timestamp, region); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def api; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def attempt_count; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def client_id; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#74
  def complete(opts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def final_aws_exception; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def final_aws_exception_message; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def final_http_status_code; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def final_sdk_exception; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def final_sdk_exception_message; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def latency; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def max_retries_exceeded; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def region; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def service; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def timestamp; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#91
  def to_json(*a); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def user_agent; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#59
  def version; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#115
  def _truncate(document); end
end

# @api private
class Aws::ClientSideMonitoring::RequestMetrics::ApiCallAttempt
  # @api private
  # @return [ApiCallAttempt] a new instance of ApiCallAttempt
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#133
  def initialize(service, api, client_id, version, timestamp, fqdn, region, user_agent, access_key, session_token); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def access_key; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def api; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def aws_exception; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def aws_exception=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def aws_exception_msg; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def aws_exception_msg=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def client_id; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def fqdn; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def fqdn=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def http_status_code; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def http_status_code=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def region; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def region=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def request_latency; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def request_latency=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def sdk_exception; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def sdk_exception=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def sdk_exception_msg; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def sdk_exception_msg=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def service; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def session_token; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def timestamp; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#157
  def to_json(*a); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def user_agent; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#127
  def version; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amz_id_2; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amz_id_2=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amz_request_id; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amz_request_id=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amzn_request_id; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#129
  def x_amzn_request_id=(_arg0); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#186
  def _truncate(document); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/client_side_monitoring/request_metrics.rb#9
Aws::ClientSideMonitoring::RequestMetrics::FIELD_MAX_LENGTH = T.let(T.unsafe(nil), Hash)

# This module provides the ability to specify the data and/or errors to
# return when a client is using stubbed responses. Pass
# `:stub_responses => true` to a client constructor to enable this
# behavior.
#
# Also allows you to see the requests made by the client by reading the
# api_requests instance variable
module Aws::ClientStubs
  # Allows you to access all of the requests that the stubbed client has made.
  #
  # @option options
  # @param options [Hash] The options for the api requests.
  # @raise [NotImplementedError] Raises `NotImplementedError` when the client
  #   is not stubbed.
  # @return [Array] Returns an array of the api requests made. Each request
  #   object contains the :operation_name, :params, and :context.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#195
  def api_requests(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#232
  def next_stub(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#17
  def setup_stubbing; end

  # Generates and returns stubbed response data from the named operation.
  #
  #     s3 = Aws::S3::Client.new
  #     s3.stub_data(:list_buckets)
  #     #=> #<struct Aws::S3::Types::ListBucketsOutput buckets=[], owner=#<struct Aws::S3::Types::Owner display_name="DisplayName", id="ID">>
  #
  # In addition to generating default stubs, you can provide data to
  # apply to the response stub.
  #
  #     s3.stub_data(:list_buckets, buckets:[{name:'aws-sdk'}])
  #     #=> #<struct Aws::S3::Types::ListBucketsOutput
  #       buckets=[#<struct Aws::S3::Types::Bucket name="aws-sdk", creation_date=nil>],
  #       owner=#<struct Aws::S3::Types::Owner display_name="DisplayName", id="ID">>
  #
  # @param operation_name [Symbol]
  # @param data [Hash]
  # @return [Structure] Returns a stubbed response data structure. The
  #   actual class returned will depend on the given `operation_name`.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#227
  def stub_data(operation_name, data = T.unsafe(nil)); end

  # Configures what data / errors should be returned from the named operation
  # when response stubbing is enabled.
  #
  # ## Basic usage
  #
  # When you enable response stubbing, the client will generate fake
  # responses and will not make any HTTP requests.
  #
  #     client = Aws::S3::Client.new(stub_responses: true)
  #     client.list_buckets
  #     #=> #<struct Aws::S3::Types::ListBucketsOutput buckets=[], owner=nil>
  #
  # You can provide stub data that will be returned by the client.
  #
  #     # stub data in the constructor
  #     client = Aws::S3::Client.new(stub_responses: {
  #       list_buckets: { buckets: [{name: 'my-bucket' }] },
  #       get_object: { body: 'data' },
  #     })
  #
  #     client.list_buckets.buckets.map(&:name) #=> ['my-bucket']
  #     client.get_object(bucket:'name', key:'key').body.read #=> 'data'
  #
  # You can also specify the stub data using {#stub_responses}
  #
  #     client = Aws::S3::Client.new(stub_responses: true)
  #     client.stub_responses(:list_buckets, {
  #       buckets: [{ name: 'my-bucket' }]
  #     })
  #
  #     client.list_buckets.buckets.map(&:name)
  #     #=> ['my-bucket']
  #
  # With a Resource class {#stub_responses} on the corresponding client:
  #
  #     s3 = Aws::S3::Resource.new(stub_responses: true)
  #     s3.client.stub_responses(:list_buckets, {
  #       buckets: [{ name: 'my-bucket' }]
  #     })
  #
  #     s3.buckets.map(&:name)
  #     #=> ['my-bucket']
  #
  # Lastly, default stubs can be configured via `Aws.config`:
  #
  #     Aws.config[:s3] = {
  #       stub_responses: {
  #         list_buckets: { buckets: [{name: 'my-bucket' }] }
  #       }
  #     }
  #
  #     Aws::S3::Client.new.list_buckets.buckets.map(&:name)
  #     #=> ['my-bucket']
  #
  #     Aws::S3::Resource.new.buckets.map(&:name)
  #     #=> ['my-bucket']
  #
  # ## Dynamic Stubbing
  #
  # In addition to creating static stubs, it's also possible to generate
  # stubs dynamically based on the parameters with which operations were
  # called, by passing a `Proc` object:
  #
  #     s3 = Aws::S3::Resource.new(stub_responses: true)
  #     s3.client.stub_responses(:put_object, -> (context) {
  #       s3.client.stub_responses(:get_object, content_type: context.params[:content_type])
  #     })
  #
  # The yielded object is an instance of {Seahorse::Client::RequestContext}.
  #
  # ## Stubbing Errors
  #
  # When stubbing is enabled, the SDK will default to generate
  # fake responses with placeholder values. You can override the data
  # returned. You can also specify errors it should raise.
  #
  #     # simulate service errors, give the error code
  #     client.stub_responses(:get_object, 'NotFound')
  #     client.get_object(bucket:'aws-sdk', key:'foo')
  #     #=> raises Aws::S3::Errors::NotFound
  #
  #     # to simulate other errors, give the error class, you must
  #     # be able to construct an instance with `.new`
  #     client.stub_responses(:get_object, Timeout::Error)
  #     client.get_object(bucket:'aws-sdk', key:'foo')
  #     #=> raises new Timeout::Error
  #
  #     # or you can give an instance of an error class
  #     client.stub_responses(:get_object, RuntimeError.new('custom message'))
  #     client.get_object(bucket:'aws-sdk', key:'foo')
  #     #=> raises the given runtime error object
  #
  # ## Stubbing HTTP Responses
  #
  # As an alternative to providing the response data, you can provide
  # an HTTP response.
  #
  #     client.stub_responses(:get_object, {
  #       status_code: 200,
  #       headers: { 'header-name' => 'header-value' },
  #       body: "...",
  #     })
  #
  # To stub a HTTP response, pass a Hash with all three of the following
  # keys set:
  #
  # * **`:status_code`** - <Integer> - The HTTP status code
  # * **`:headers`** - Hash<String,String> - A hash of HTTP header keys and values
  # * **`:body`** - <String,IO> - The HTTP response body.
  #
  # ## Stubbing Multiple Responses
  #
  # Calling an operation multiple times will return similar responses.
  # You can configure multiple stubs and they will be returned in sequence.
  #
  #     client.stub_responses(:head_object, [
  #       'NotFound',
  #       { content_length: 150 },
  #     ])
  #
  #     client.head_object(bucket:'aws-sdk', key:'foo')
  #     #=> raises Aws::S3::Errors::NotFound
  #
  #     resp = client.head_object(bucket:'aws-sdk', key:'foo')
  #     resp.content_length #=> 150
  #
  # @param operation_name [Symbol]
  # @param stubs [Mixed] One or more responses to return from the named
  #   operation.
  # @raise [RuntimeError] Raises a runtime error when called
  #   on a client that has not enabled response stubbing via
  #   `:stub_responses => true`.
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#176
  def stub_responses(operation_name, *stubs); end

  private

  # This method converts the given stub data and converts it to a
  # HTTP response (when possible). This enables the response stubbing
  # plugin to provide a HTTP response that triggers all normal events
  # during response handling.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#256
  def apply_stubs(operation_name, stubs); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#264
  def convert_stub(operation_name, stub); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#298
  def data_to_http_resp(operation_name, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#247
  def default_stub(operation_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#290
  def hash_to_http_resp(data); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#282
  def http_response_stub(operation_name, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#305
  def protocol_helper; end

  # source://aws-sdk-core//lib/aws-sdk-core/client_stubs.rb#278
  def service_error_stub(error_code); end
end

module Aws::CredentialProvider
  # @return [Credentials]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider.rb#7
  def credentials; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider.rb#10
  def set?; end
end

# @api private
class Aws::CredentialProviderChain
  # @api private
  # @return [CredentialProviderChain] a new instance of CredentialProviderChain
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#6
  def initialize(config = T.unsafe(nil)); end

  # @api private
  # @return [CredentialProvider, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#11
  def resolve; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#137
  def assume_role_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#143
  def assume_role_web_identity_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#171
  def assume_role_with_profile(options, profile_name); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#107
  def determine_profile_name(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#93
  def env_credentials(_options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#100
  def envar(keys); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#162
  def instance_profile_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#118
  def process_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#21
  def providers; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#111
  def shared_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#128
  def sso_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#43
  def static_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#70
  def static_profile_assume_role_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#53
  def static_profile_assume_role_web_identity_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#76
  def static_profile_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#84
  def static_profile_process_credentials(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credential_provider_chain.rb#62
  def static_profile_sso_credentials(options); end
end

class Aws::Credentials
  # @param access_key_id [String]
  # @param secret_access_key [String]
  # @param session_token [String] (nil)
  # @return [Credentials] a new instance of Credentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#9
  def initialize(access_key_id, secret_access_key, session_token = T.unsafe(nil)); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#16
  def access_key_id; end

  # @return [Credentials]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#25
  def credentials; end

  # Removing the secret access key from the default inspect string.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#40
  def inspect; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#19
  def secret_access_key; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#22
  def session_token; end

  # @return [Boolean] Returns `true` if the access key id and secret
  #   access key are both set.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/credentials.rb#31
  def set?; end
end

# @api private
class Aws::DefaultsModeConfigResolver
  # @api private
  # @return [DefaultsModeConfigResolver] a new instance of DefaultsModeConfigResolver
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#22
  def initialize(sdk_defaults, cfg); end

  # option_name should be the symbolized ruby name to resolve
  # returns the ruby appropriate value or nil if none are resolved
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#31
  def resolve(option_name); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#65
  def application_current_region; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#102
  def env_mobile?; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#52
  def resolve_auto_mode; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#88
  def resolve_for_mode(name, mode); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#44
  def resolved_mode; end
end

# mappings from Ruby SDK configuration names to the
# sdk defaults option names and (optional) scale modifiers
#
# @api private
#
# source://aws-sdk-core//lib/aws-defaults/defaults_mode_config_resolver.rb#13
Aws::DefaultsModeConfigResolver::CFG_OPTIONS = T.let(T.unsafe(nil), Hash)

# A defaults mode determines how certain default configuration options are resolved in the SDK.
#
# *Note*: For any mode other than `'legacy'` the vended default values might change as best practices may
# evolve. As a result, it is encouraged to perform testing when upgrading the SDK if you are using a mode other than
# `'legacy'`.  While the `'legacy'` defaults mode is specific to Ruby,
# other modes are standardized across all of the AWS SDKs.
#
#  The defaults mode can be configured:
#
#  * Directly on a client via `:defaults_mode`
#
#  * On a configuration profile via the "defaults_mode" profile file property.
#
#  * Globally via the "AWS_DEFAULTS_MODE" environment variable.
#
#
# The following `:default_mode` values are supported:
#
# * `'standard'` -
#   The STANDARD mode provides the latest recommended default values
#   that should be safe to run in most scenarios
#
#   Note that the default values vended from this mode might change as
#   best practices may evolve. As a result, it is encouraged to perform
#   tests when upgrading the SDK
#
# * `'in-region'` -
#   The IN\_REGION mode builds on the standard mode and includes
#   optimization tailored for applications which call AWS services from
#   within the same AWS region
#
#   Note that the default values vended from this mode might change as
#   best practices may evolve. As a result, it is encouraged to perform
#   tests when upgrading the SDK
#
# * `'cross-region'` -
#   The CROSS\_REGION mode builds on the standard mode and includes
#   optimization tailored for applications which call AWS services in a
#   different region
#
#   Note that the default values vended from this mode might change as
#   best practices may evolve. As a result, it is encouraged to perform
#   tests when upgrading the SDK
#
# * `'mobile'` -
#   The MOBILE mode builds on the standard mode and includes
#   optimization tailored for mobile applications
#
#   Note that the default values vended from this mode might change as
#   best practices may evolve. As a result, it is encouraged to perform
#   tests when upgrading the SDK
#
# * `'auto'` -
#   The AUTO mode is an experimental mode that builds on the standard
#   mode. The SDK will attempt to discover the execution environment to
#   determine the appropriate settings automatically.
#
#   Note that the auto detection is heuristics-based and does not
#   guarantee 100% accuracy. STANDARD mode will be used if the execution
#   environment cannot be determined. The auto detection might query
#   [EC2 Instance Metadata service][1], which might introduce latency.
#   Therefore we recommend choosing an explicit defaults\_mode instead
#   if startup latency is critical to your application
#
# * `'legacy'` -
#   The LEGACY mode provides default settings that vary per SDK and were
#   used prior to establishment of defaults\_mode
#
# Based on the provided mode, the SDK will vend sensible default values
# tailored to the mode for the following settings:
#
# * `:retry_mode` -
#   A retry mode specifies how the SDK attempts retries. See [Retry
#   Mode][2]
#
# * `:sts_regional_endpoints` -
#   Specifies how the SDK determines the AWS service endpoint that it
#   uses to talk to the AWS Security Token Service (AWS STS). See
#   [Setting STS Regional endpoints][3]
#
# * `:s3_us_east_1_regional_endpoint` -
#   Specifies how the SDK determines the AWS service endpoint that it
#   uses to talk to the Amazon S3 for the us-east-1 region
#
# * `:http_open_timeout` -
#   The amount of time after making an initial connection attempt on a
#   socket, where if the client does not receive a completion of the
#   connect handshake, the client gives up and fails the operation
#
# * `:ssl_timeout` -
#   The maximum amount of time that a TLS handshake is allowed to take
#   from the time the CLIENT HELLO message is sent to ethe time the
#   client and server have fully negotiated ciphers and exchanged keys
#
#  All options above can be configured by users, and the overridden value will take precedence.
#
# [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html
# [2]: https://docs.aws.amazon.com/sdkref/latest/guide/setting-global-retry_mode.html
# [3]: https://docs.aws.amazon.com/sdkref/latest/guide/setting-global-sts_regional_endpoints.html
module Aws::DefaultsModeConfiguration; end

# @api private
#
# source://aws-sdk-core//lib/aws-defaults/default_configuration.rb#112
Aws::DefaultsModeConfiguration::SDK_DEFAULT_CONFIGURATION = T.let(T.unsafe(nil), Hash)

# A utility module that provides a class method that wraps
# a method such that it generates a deprecation warning when called.
# Given the following class:
#
#     class Example
#
#       def do_something
#       end
#
#     end
#
# If you want to deprecate the `#do_something` method, you can extend
# this module and then call `deprecated` on the method (after it
# has been defined).
#
#     class Example
#
#       extend Aws::Deprecations
#
#       def do_something
#       end
#
#       def do_something_else
#       end
#
#       deprecated :do_something
#
#     end
#
# The `#do_something` method will continue to function, but will
# generate a deprecation warning when called.
#
# @api private
module Aws::Deprecations
  # @api private
  # @option options
  # @option options
  # @option options
  # @param method [Symbol] The name of the deprecated method.
  # @param options [Hash] a customizable set of options
  #
  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#50
  def deprecated(method, options = T.unsafe(nil)); end
end

# A client that can query version 2 of the EC2 Instance Metadata
class Aws::EC2Metadata
  # Creates a client that can query version 2 of the EC2 Instance Metadata
  #   service (IMDS).
  #
  # @note Customers using containers may need to increase their hop limit
  #   to access IMDSv2.
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [EC2Metadata] a new instance of EC2Metadata
  # @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html#instance-metadata-transition-to-version-2
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#57
  def initialize(options = T.unsafe(nil)); end

  # Fetches a given metadata category using a String path, and returns the
  #   result as a String. A path starts with the API version (usually
  #   "/latest/"). See the instance data categories for possible paths.
  #
  # @example Fetching the instance ID
  #
  #   ec2_metadata = Aws::EC2Metadata.new
  #   ec2_metadata.get('/latest/meta-data/instance-id')
  #   => "i-023a25f10a73a0f79"
  # @example Fetching and parsing JSON meta-data
  #
  #   require 'json'
  #   data = ec2_metadata.get('/latest/dynamic/instance-identity/document')
  #   JSON.parse(data)
  #   => {"accountId"=>"012345678912", ... }
  # @example Fetching and parsing directory listings
  #
  #   listing = ec2_metadata.get('/latest/meta-data')
  #   listing.split(10.chr)
  #   => ["ami-id", "ami-launch-index", ...]
  # @note This implementation always returns a String and will not parse any
  #   responses. Parsable responses may include JSON objects or directory
  #   listings, which are strings separated by line feeds (ASCII 10).
  # @note Unlike other services, IMDS does not have a service API model. This
  #   means that we cannot confidently generate code with methods and
  #   response structures. This implementation ensures that new IMDS features
  #   are always supported by being deployed to the instance and does not
  #   require code changes.
  # @param path [String] The full path to the metadata.
  # @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instancedata-data-categories.html
  # @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-identity-documents.html
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#110
  def get(path); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#213
  def backoff(backoff); end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#137
  def fetch_token; end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#145
  def http_get(connection, path, token); end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#163
  def http_put(connection, ttl); end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#184
  def open_connection; end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#124
  def resolve_endpoint(endpoint, endpoint_mode); end

  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#194
  def retry_errors(options = T.unsafe(nil), &_block); end
end

# Path for PUT request for token
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#11
Aws::EC2Metadata::METADATA_TOKEN_PATH = T.let(T.unsafe(nil), String)

# The requested metadata path does not exist.
#
# @api private
class Aws::EC2Metadata::MetadataNotFoundError < ::RuntimeError; end

# The request is not allowed or IMDS is turned off.
#
# @api private
class Aws::EC2Metadata::RequestForbiddenError < ::RuntimeError; end

# @api private
class Aws::EC2Metadata::Token
  # @api private
  # @return [Token] a new instance of Token
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#223
  def initialize(options = T.unsafe(nil)); end

  # [Boolean] Returns true if the token expired.
  #
  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#233
  def expired?; end

  # [String] Returns the token value.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ec2_metadata.rb#230
  def value; end
end

# Token has expired, and the request can be retried with a new token.
#
# @api private
class Aws::EC2Metadata::TokenExpiredError < ::RuntimeError; end

# Raised when the PUT request is not valid. This would be thrown if
# `token_ttl` is not an Integer.
#
# @api private
class Aws::EC2Metadata::TokenRetrievalError < ::RuntimeError; end

# An auto-refreshing credential provider that loads credentials from
# instances running in ECS.
#
#     ecs_credentials = Aws::ECSCredentials.new(retries: 3)
#     ec2 = Aws::EC2::Client.new(credentials: ecs_credentials)
class Aws::ECSCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [ECSCredentials] a new instance of ECSCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#55
  def initialize(options = T.unsafe(nil)); end

  # @return [Integer] The number of times to retry failed attempts to
  #   fetch credentials from the instance metadata service. Defaults to 0.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#76
  def retries; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#80
  def backoff(backoff); end

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#107
  def get_credentials; end

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#130
  def http_get(connection, path); end

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#121
  def open_connection; end

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#88
  def refresh; end

  # source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#139
  def retry_errors(error_classes, options = T.unsafe(nil), &block); end
end

# These are the errors we trap when attempting to talk to the
# instance metadata service.  Any of these imply the service
# is not present, no responding or some other non-recoverable
# error.
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/ecs_credentials.rb#25
Aws::ECSCredentials::NETWORK_ERRORS = T.let(T.unsafe(nil), Array)

# @api private
class Aws::ECSCredentials::Non200Response < ::RuntimeError; end

# @api private
class Aws::EagerLoader
  # @api private
  # @return [EagerLoader] a new instance of EagerLoader
  #
  # source://aws-sdk-core//lib/aws-sdk-core/eager_loader.rb#9
  def initialize; end

  # @api private
  # @param klass_or_module [Module]
  # @return [self]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/eager_loader.rb#18
  def load(klass_or_module); end

  # @api private
  # @return [Set<Module>]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/eager_loader.rb#14
  def loaded; end
end

# @api private
class Aws::EmptyStructure < ::Struct
  include ::Aws::Structure
end

# a LRU cache caching endpoints data
#
# @api private
class Aws::EndpointCache
  # @api private
  # @return [EndpointCache] a new instance of EndpointCache
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#14
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @param key [String]
  # @return [Endpoint]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#34
  def [](key); end

  # @api private
  # @param key [String]
  # @param value [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#48
  def []=(key, value); end

  # remove entry only
  #
  # @api private
  # @param key [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#82
  def delete(key); end

  # kill the old polling thread and remove it from pool
  #
  # @api private
  # @param key [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#90
  def delete_polling_thread(key); end

  # extract the key to be used in the cache from request context
  #
  # @api private
  # @param ctx [RequestContext]
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#109
  def extract_key(ctx); end

  # checking whether an unexpired endpoint key exists in cache
  #
  # @api private
  # @param key [String]
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#64
  def key?(key); end

  # @api private
  # @return [Integer] Max size limit of cache
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#24
  def max_entries; end

  # @api private
  # @return [Integer] Max count of polling threads
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#27
  def max_threads; end

  # return [Hash] Polling threads pool
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#30
  def pool; end

  # kill all polling threads
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#135
  def stop_polling!; end

  # checking whether an polling thread exist for the key
  #
  # @api private
  # @param key [String]
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#76
  def threads_key?(key); end

  # update cache with requests (using service endpoint operation)
  # to fetch endpoint list (with identifiers when available)
  #
  # @api private
  # @param key [String]
  # @param ctx [RequestContext]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#99
  def update(key, ctx); end

  # update polling threads pool
  # param [String] key
  # param [Thread] thread
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#126
  def update_polling_pool(key, thread); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#164
  def _endpoint_operation_identifier(ctx); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#142
  def _request_endpoint(ctx); end
end

# @api private
class Aws::EndpointCache::Endpoint
  # @api private
  # @return [Endpoint] a new instance of Endpoint
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#177
  def initialize(options); end

  # [String] valid URI address (with path)
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#184
  def address; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#186
  def expired?; end
end

# default endpoint cache time, 1 minute
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#175
Aws::EndpointCache::Endpoint::CACHE_PERIOD = T.let(T.unsafe(nil), Integer)

# default cache entries limit
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#9
Aws::EndpointCache::MAX_ENTRIES = T.let(T.unsafe(nil), Integer)

# default max threads pool size
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/endpoint_cache.rb#12
Aws::EndpointCache::MAX_THREADS = T.let(T.unsafe(nil), Integer)

# @api private
module Aws::Endpoints
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints.rb#21
    def resolve_auth_scheme(context, endpoint); end

    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints.rb#63
    def default_api_authtype(context); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints.rb#36
    def default_auth_scheme(context); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints.rb#51
    def merge_signing_defaults(auth_scheme, config); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints.rb#68
    def sigv4_name(config); end
  end
end

# @api private
class Aws::Endpoints::Condition
  # @api private
  # @return [Condition] a new instance of Condition
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#7
  def initialize(fn:, argv:, assign: T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#14
  def argv; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#15
  def assign; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#17
  def assigned; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#13
  def fn; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#19
  def match?(parameters, assigns); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/condition.rb#25
    def from_json(conditions_json); end
  end
end

class Aws::Endpoints::Endpoint
  # @return [Endpoint] a new instance of Endpoint
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint.rb#6
  def initialize(url:, properties: T.unsafe(nil), headers: T.unsafe(nil)); end

  # Returns the value of attribute headers.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint.rb#14
  def headers; end

  # Returns the value of attribute properties.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint.rb#13
  def properties; end

  # Returns the value of attribute url.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint.rb#12
  def url; end
end

# @api private
class Aws::Endpoints::EndpointRule < ::Aws::Endpoints::Rule
  # @api private
  # @return [EndpointRule] a new instance of EndpointRule
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#7
  def initialize(conditions:, endpoint:, type: T.unsafe(nil), documentation: T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#16
  def conditions; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#18
  def documentation; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#17
  def endpoint; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#20
  def match(parameters, assigned = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#30
  def resolved_endpoint(parameters, assigns); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#15
  def type; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#44
  def resolve_headers(parameters, assigns); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/endpoint_rule.rb#53
  def resolve_properties(obj, parameters, assigns); end
end

# @api private
class Aws::Endpoints::ErrorRule < ::Aws::Endpoints::Rule
  # @api private
  # @return [ErrorRule] a new instance of ErrorRule
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#7
  def initialize(conditions:, type: T.unsafe(nil), error: T.unsafe(nil), documentation: T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#15
  def conditions; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#17
  def documentation; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#16
  def error; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#19
  def match(parameters, assigned = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#14
  def type; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/error_rule.rb#31
  def resolved_error(parameters, assigns); end
end

# @api private
class Aws::Endpoints::Function
  # @api private
  # @return [Function] a new instance of Function
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/function.rb#7
  def initialize(fn:, argv:); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/function.rb#13
  def argv; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/function.rb#15
  def call(parameters, assigns); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/function.rb#12
  def fn; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/function.rb#62
  def build_argv(argv_json); end
end

# generic matcher functions for service endpoints
#
# @api private
module Aws::Endpoints::Matchers
  class << self
    # getAttr(value: Object | Array, path: string) Document
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#26
    def attr(value, path); end

    # aws.parseArn(value: string) Option<ARN>
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#104
    def aws_parse_arn(value); end

    # aws.partition(value: string) Option<Partition>
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#92
    def aws_partition(value); end

    # aws.isVirtualHostableS3Bucket(value: string, allowSubDomains: bool) bool
    #
    # @api private
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#116
    def aws_virtual_hostable_s3_bucket?(value, allow_sub_domains = T.unsafe(nil)); end

    # booleanEquals(value1: bool, value2: bool) bool
    #
    # @api private
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#61
    def boolean_equals?(value1, value2); end

    # not(value: bool) bool
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#21
    def not(bool); end

    # parseUrl(value: string) Option<URL>
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#71
    def parse_url(value); end

    # isSet(value: Option<T>) bool
    #
    # @api private
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#16
    def set?(value); end

    # stringEquals(value1: string, value2: string) bool
    #
    # @api private
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#56
    def string_equals?(value1, value2); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#43
    def substring(input, start, stop, reverse); end

    # uriEncode(value: string) string
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#66
    def uri_encode(value); end

    # isValidHostLabel(value: string, allowSubDomains: bool) bool
    #
    # @api private
    # @return [Boolean]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#78
    def valid_host_label?(value, allow_sub_domains = T.unsafe(nil)); end
  end
end

# Regex that extracts anything in square brackets
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/endpoints/matchers.rb#11
Aws::Endpoints::Matchers::BRACKET_REGEX = T.let(T.unsafe(nil), Regexp)

# @api private
class Aws::Endpoints::Reference
  # @api private
  # @return [Reference] a new instance of Reference
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/reference.rb#7
  def initialize(ref:); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/reference.rb#11
  def ref; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/reference.rb#13
  def resolve(parameters, assigns); end
end

# @api private
class Aws::Endpoints::Rule
  # Resolves a value that is a function, reference, or template string.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule.rb#8
  def resolve_value(value, parameters, assigns); end
end

# @api private
class Aws::Endpoints::RuleSet
  # @api private
  # @return [RuleSet] a new instance of RuleSet
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#7
  def initialize(version:, service_id:, parameters:, rules:); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#16
  def parameters; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#17
  def rules; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#15
  def service_id; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#14
  def version; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rule_set.rb#19
    def rules_from_json(rules_json); end
  end
end

# @api private
class Aws::Endpoints::RulesProvider
  # @api private
  # @return [RulesProvider] a new instance of RulesProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rules_provider.rb#5
  def initialize(rule_set); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rules_provider.rb#9
  def resolve_endpoint(parameters); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/rules_provider.rb#23
  def resolve_rules(parameters); end
end

# Does substitutions for templated endpoint strings
#
# @api private
module Aws::Endpoints::Templater
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/templater.rb#9
    def resolve(string, parameters, assigns); end

    private

    # Checks both parameters and assigns hash for the referenced value
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/templater.rb#39
    def extract_value(key, parameters, assigns); end

    # Replaces the captured value with values from parameters or assign
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/endpoints/templater.rb#21
    def replace(capture, parameters, assigns); end
  end
end

# @api private
class Aws::Endpoints::TreeRule
  # @api private
  # @return [TreeRule] a new instance of TreeRule
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#7
  def initialize(conditions:, rules:, type: T.unsafe(nil), documentation: T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#15
  def conditions; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#17
  def documentation; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#16
  def error; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#19
  def match(parameters, assigned = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#14
  def type; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/tree_rule.rb#31
  def resolve_rules(parameters, assigns); end
end

# @api private
class Aws::Endpoints::URL
  # @api private
  # @raise [ArgumentError]
  # @return [URL] a new instance of URL
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#9
  def initialize(url); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#30
  def as_json(_options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#25
  def authority; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#28
  def is_ip; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#27
  def normalized_path; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#26
  def path; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#24
  def scheme; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#42
  def _authority(url, uri); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/endpoints/url.rb#51
  def _is_ip(authority); end
end

module Aws::Errors; end

# Various plugins perform client-side checksums of responses.
# This error indicates a checksum failed.
class Aws::Errors::ChecksumError < ::RuntimeError; end

# Raised when a client is constructed with Assume Role credentials, but
# the profile has both source_profile and credential_source.
class Aws::Errors::CredentialSourceConflictError < ::RuntimeError; end

# This module is mixed into another module, providing dynamic
# error classes.  Error classes all inherit from {ServiceError}.
#
#     # creates and returns the class
#     Aws::S3::Errors::MyNewErrorClass
#
# Since the complete list of possible AWS errors returned by services
# is not known, this allows us to create them as needed.  This also
# allows users to rescue errors by class without them being concrete
# classes beforehand.
#
# @api private
module Aws::Errors::DynamicErrors
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#344
  def const_missing(constant); end

  # Given the name of a service and an error code, this method
  # returns an error class (that extends {ServiceError}.
  #
  #     Aws::S3::Errors.error_class('NoSuchBucket').new
  #     #=> #<Aws::S3::Errors::NoSuchBucket>
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#355
  def error_class(error_code); end

  private

  # Convert an error code to an error class name/constant.
  # This requires filtering non-safe characters from the constant
  # name and ensuring it begins with an uppercase letter.
  #
  # @api private
  # @param error_code [String]
  # @return [Symbol] Returns a symbolized constant name for the given
  #   `error_code`.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#376
  def error_class_constant(error_code); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#398
  def error_const_set?(constant); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#385
  def set_error_constant(constant); end

  class << self
    # @api private
    # @private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#339
    def extended(submodule); end
  end
end

# Rasied when endpoint discovery failed for operations
# that requires endpoints from endpoint discovery
class Aws::Errors::EndpointDiscoveryError < ::RuntimeError
  # @return [EndpointDiscoveryError] a new instance of EndpointDiscoveryError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#74
  def initialize(*args); end
end

# Error event in an event stream which has event_type :error
# error code and error message can be retrieved when available.
#
# example usage:
#
#   client.stream_foo(name: 'bar') do |event|
#     stream.on_error_event do |event|
#       puts "Error #{event.error_code}: #{event.error_message}"
#       raise event
#     end
#   end
class Aws::Errors::EventError < ::RuntimeError
  # @return [EventError] a new instance of EventError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#121
  def initialize(event_type, code, message); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#131
  def error_code; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#134
  def error_message; end

  # @return [Symbol]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#128
  def event_type; end
end

# Raise when EventStream Builder failed to build
# an event message with parameters provided
class Aws::Errors::EventStreamBuilderError < ::RuntimeError; end

# Raised when EventStream Parser failed to parse
# a raw event message
class Aws::Errors::EventStreamParserError < ::RuntimeError; end

# Raised when ARN string input doesn't follow the standard:
# https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-arns
class Aws::Errors::InvalidARNError < ::RuntimeError; end

# Raised when the partition of the ARN region is different than the
# partition of the :region configured on the service client.
class Aws::Errors::InvalidARNPartitionError < ::RuntimeError
  # @return [InvalidARNPartitionError] a new instance of InvalidARNPartitionError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#154
  def initialize(*args); end
end

# Raised when the region from the ARN string is different from the :region
# configured on the service client.
class Aws::Errors::InvalidARNRegionError < ::RuntimeError
  # @return [InvalidARNRegionError] a new instance of InvalidARNRegionError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#145
  def initialize(*args); end
end

# Raised when a client is constructed with Assume Role credentials using
# a credential_source, and that source type is unsupported.
class Aws::Errors::InvalidCredentialSourceError < ::RuntimeError; end

# Raised when a credentials provider process returns a JSON
# payload with either invalid version number or malformed contents
class Aws::Errors::InvalidProcessCredentialsPayload < ::RuntimeError; end

# Raised when a client is contsructed and the region is not valid.
class Aws::Errors::InvalidRegionError < ::ArgumentError
  # @return [InvalidRegionError] a new instance of InvalidRegionError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#241
  def initialize(*args); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#258
  def possible_regions; end
end

# Raised when SSO Credentials are invalid
class Aws::Errors::InvalidSSOCredentials < ::RuntimeError; end

# Raised when SSO Token is invalid
class Aws::Errors::InvalidSSOToken < ::RuntimeError; end

# Raised when InstanceProfileCredentialsProvider or
# EcsCredentialsProvider fails to parse the metadata response after retries
class Aws::Errors::MetadataParserError < ::RuntimeError
  # @return [MetadataParserError] a new instance of MetadataParserError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#56
  def initialize(*args); end
end

# Raised when a client is unable to sign a request because
# the bearer token is not configured or available
class Aws::Errors::MissingBearerTokenError < ::RuntimeError
  # @return [MissingBearerTokenError] a new instance of MissingBearerTokenError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#219
  def initialize(*args); end
end

# Raised when a `streaming` operation has `requiresLength` trait
# enabled but request payload size/length cannot be calculated
class Aws::Errors::MissingContentLength < ::RuntimeError
  # @return [MissingContentLength] a new instance of MissingContentLength
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#65
  def initialize(*args); end
end

# Raised when a client is constructed and credentials are not
# set, or the set credentials are empty.
class Aws::Errors::MissingCredentialsError < ::RuntimeError
  # @return [MissingCredentialsError] a new instance of MissingCredentialsError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#188
  def initialize(*args); end
end

# raised when hostLabel member is not provided
# at operation input when endpoint trait is available
# with 'hostPrefix' requirement
class Aws::Errors::MissingEndpointHostLabelValue < ::RuntimeError
  # @return [MissingEndpointHostLabelValue] a new instance of MissingEndpointHostLabelValue
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#86
  def initialize(name); end
end

# Raised when a client is constructed and region is not specified.
class Aws::Errors::MissingRegionError < ::ArgumentError
  # @return [MissingRegionError] a new instance of MissingRegionError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#232
  def initialize(*args); end
end

# Raised when :web_identity_token_file parameter is not
# provided or the file doesn't exist when initializing
# AssumeRoleWebIdentityCredentials credential provider
class Aws::Errors::MissingWebIdentityTokenFile < ::RuntimeError
  # @return [MissingWebIdentityTokenFile] a new instance of MissingWebIdentityTokenFile
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#198
  def initialize(*args); end
end

# Raised when a client is constructed with Assume Role credentials using
# a credential_source, and that source doesn't provide credentials.
class Aws::Errors::NoSourceCredentialsError < ::RuntimeError; end

# Raised when a client is constructed, where Assume Role credentials are
# expected, and there is no source profile specified.
class Aws::Errors::NoSourceProfileError < ::RuntimeError; end

# Raised when attempting to connect to an endpoint and a `SocketError`
# is received from the HTTP client. This error is typically the result
# of configuring an invalid `:region`.
class Aws::Errors::NoSuchEndpointError < ::RuntimeError
  # @return [NoSuchEndpointError] a new instance of NoSuchEndpointError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#272
  def initialize(options = T.unsafe(nil)); end

  # Returns the value of attribute context.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#299
  def context; end

  # Returns the value of attribute endpoint.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#301
  def endpoint; end

  # Returns the value of attribute original_error.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#303
  def original_error; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#307
  def possible_regions; end
end

# Raised when a client is constructed and the specified shared
# credentials profile does not exist.
class Aws::Errors::NoSuchProfileError < ::RuntimeError; end

class Aws::Errors::NonSupportedRubyVersionError < ::RuntimeError; end

# Raised when attempting to retry a request
# and no capacity is available to retry (See adaptive retry_mode)
class Aws::Errors::RetryCapacityNotAvailableError < ::RuntimeError
  # @return [RetryCapacityNotAvailableError] a new instance of RetryCapacityNotAvailableError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#319
  def initialize(*args); end
end

# The base class for all errors returned by an Amazon Web Service.
# All ~400 level client errors and ~500 level server errors are raised
# as service errors.  This indicates it was an error returned from the
# service and not one generated by the client.
class Aws::Errors::ServiceError < ::RuntimeError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::Structure]
  # @return [ServiceError] a new instance of ServiceError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#17
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#26
  def code; end

  # @return [Seahorse::Client::RequestContext] The context of the request
  #   that triggered the remote service to return this error.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#30
  def context; end

  # @return [Aws::Structure]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#33
  def data; end

  # @api private undocumented
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#43
  def retryable?; end

  # @api private undocumented
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#48
  def throttling?; end

  class << self
    # @return [String]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#38
    def code; end

    # @return [String]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/errors.rb#38
    def code=(_arg0); end
  end
end

# Raised when attempting to #signal an event before
# making an async request
class Aws::Errors::SignalEventError < ::RuntimeError; end

# Raised when there is a circular reference in chained
# source_profiles
class Aws::Errors::SourceProfileCircularReferenceError < ::RuntimeError; end

class Aws::EventEmitter
  # @return [EventEmitter] a new instance of EventEmitter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#6
  def initialize; end

  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#32
  def emit(type, params); end

  # Returns the value of attribute encoder.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#15
  def encoder; end

  # Sets the attribute encoder
  #
  # @param value the value to set the attribute encoder to.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#15
  def encoder=(_arg0); end

  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#21
  def on(type, callback); end

  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#25
  def signal(type, event); end

  # Returns the value of attribute signal_queue.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#19
  def signal_queue; end

  # Sets the attribute signal_queue
  #
  # @param value the value to set the attribute signal_queue to.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#19
  def signal_queue=(_arg0); end

  # Returns the value of attribute stream.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#13
  def stream; end

  # Sets the attribute stream
  #
  # @param value the value to set the attribute stream to.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#13
  def stream=(_arg0); end

  # Returns the value of attribute validate_event.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#17
  def validate_event; end

  # Sets the attribute validate_event
  #
  # @param value the value to set the attribute validate_event to.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#17
  def validate_event=(_arg0); end

  private

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/event_emitter.rb#52
  def _ready_for_events?; end
end

# @api private
class Aws::IniParser
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/ini_parser.rb#8
    def ini_parse(raw); end
  end
end

# An auto-refreshing credential provider that loads credentials from
# EC2 instances.
#
#     instance_credentials = Aws::InstanceProfileCredentials.new
#     ec2 = Aws::EC2::Client.new(credentials: instance_credentials)
class Aws::InstanceProfileCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [InstanceProfileCredentials] a new instance of InstanceProfileCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#75
  def initialize(options = T.unsafe(nil)); end

  # @return [Integer] Number of times to retry when retrieving credentials
  #   from the instance metadata service. Defaults to 0 when resolving from
  #   the default credential chain ({Aws::CredentialProviderChain}).
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#94
  def retries; end

  private

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#234
  def _metadata_disabled?; end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#126
  def backoff(backoff); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#306
  def empty_credentials?(creds); end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#183
  def get_credentials; end

  # GET request fetch profile and credentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#249
  def http_get(connection, path, token = T.unsafe(nil)); end

  # PUT request fetch token with ttl
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#265
  def http_put(connection, path, ttl); end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#238
  def open_connection; end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#134
  def refresh; end

  # Compute an offset for refresh with jitter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#311
  def refresh_offset; end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#107
  def resolve_endpoint(options, endpoint_mode); end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#98
  def resolve_endpoint_mode(options); end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#286
  def retry_errors(error_classes, options = T.unsafe(nil), &_block); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#230
  def token_set?; end

  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#300
  def warn_expired_credentials; end
end

# Path base for GET request for profile and credentials
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#42
Aws::InstanceProfileCredentials::METADATA_PATH_BASE = T.let(T.unsafe(nil), String)

# Path for PUT request for token
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#46
Aws::InstanceProfileCredentials::METADATA_TOKEN_PATH = T.let(T.unsafe(nil), String)

# These are the errors we trap when attempting to talk to the
# instance metadata service.  Any of these imply the service
# is not present, no responding or some other non-recoverable
# error.
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#30
Aws::InstanceProfileCredentials::NETWORK_ERRORS = T.let(T.unsafe(nil), Array)

# @api private
class Aws::InstanceProfileCredentials::Non200Response < ::RuntimeError; end

# Token used to fetch IMDS profile and credentials
#
# @api private
class Aws::InstanceProfileCredentials::Token
  # @api private
  # @return [Token] a new instance of Token
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#318
  def initialize(value, ttl, created_time = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#327
  def expired?; end

  # [String] token value
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/instance_profile_credentials.rb#325
  def value; end
end

# @api private
class Aws::InstanceProfileCredentials::TokenExpiredError < ::RuntimeError; end

# @api private
class Aws::InstanceProfileCredentials::TokenRetrivalError < ::RuntimeError; end

# @api private
module Aws::Json
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/json.rb#32
    def dump(value); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/json.rb#24
    def load(json); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/json.rb#28
    def load_file(path); end

    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/json.rb#38
    def select_engine; end
  end
end

class Aws::Json::Builder
  include ::Seahorse::Model::Shapes

  # @return [Builder] a new instance of Builder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#11
  def initialize(rules); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#15
  def serialize(params); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#15
  def to_json(params); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#56
  def encode(blob); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#45
  def format(ref, value); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#33
  def list(ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#38
  def map(ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#22
  def structure(ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/builder.rb#60
  def timestamp(ref, value); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/json.rb#47
Aws::Json::ENGINE = Aws::Json::JSONEngine

class Aws::Json::ErrorHandler < ::Aws::Xml::ErrorHandler
  # @param context [Seahorse::Client::RequestContext]
  # @return [Seahorse::Client::Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#9
  def call(context); end

  private

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#43
  def aws_query_error?(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#28
  def error_code(json, context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#48
  def error_message(code, json); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#18
  def extract_error(body, context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/error_handler.rb#56
  def parse_error_data(context, code); end
end

class Aws::Json::Handler < ::Seahorse::Client::Handler
  # @param context [Seahorse::Client::RequestContext]
  # @return [Seahorse::Client::Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#11
  def call(context); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#78
  def apply_request_id(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#28
  def build_body(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#21
  def build_request(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#69
  def content_type(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#40
  def parse_body(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#36
  def parse_response(response); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#82
  def simple_json?(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#73
  def target(context); end
end

# source://aws-sdk-core//lib/aws-sdk-core/json/handler.rb#7
Aws::Json::Handler::CONTENT_TYPE = T.let(T.unsafe(nil), String)

module Aws::Json::JSONEngine
  class << self
    # source://aws-sdk-core//lib/aws-sdk-core/json/json_engine.rb#13
    def dump(value); end

    # source://aws-sdk-core//lib/aws-sdk-core/json/json_engine.rb#7
    def load(json); end
  end
end

module Aws::Json::OjEngine
  class << self
    # source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#19
    def dump(value); end

    # source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#13
    def load(json); end

    private

    # Oj before 1.4.0 does not define Oj::ParseError and instead raises
    # SyntaxError on failure
    #
    # source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#27
    def detect_oj_parse_errors; end
  end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#10
Aws::Json::OjEngine::DUMP_OPTIONS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#7
Aws::Json::OjEngine::LOAD_OPTIONS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/json/oj_engine.rb#41
Aws::Json::OjEngine::PARSE_ERRORS = T.let(T.unsafe(nil), T.untyped)

# @api private
class Aws::Json::ParseError < ::StandardError
  # @api private
  # @return [ParseError] a new instance of ParseError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json.rb#15
  def initialize(error); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json.rb#20
  def error; end
end

class Aws::Json::Parser
  include ::Seahorse::Model::Shapes

  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Parser] a new instance of Parser
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#13
  def initialize(rules); end

  # @param json [String<JSON>]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#18
  def parse(json, target = T.unsafe(nil)); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#44
  def list(ref, values, target = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#52
  def map(ref, values, target = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#60
  def parse_ref(ref, value, target = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#24
  def structure(ref, values, target = T.unsafe(nil)); end

  # @param value [String, Integer]
  # @return [Time]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/json/parser.rb#78
  def time(value); end
end

module Aws::Log; end

# A log formatter generates a string for logging from a response. This
# accomplished with a log pattern string:
#
#     pattern = ':operation :http_response_status_code :time'
#     formatter = Aws::Log::Formatter.new(pattern)
#     formatter.format(response)
#     #=> 'get_bucket 200 0.0352'
#
# # Canned Formatters
#
# Instead of providing your own pattern, you can choose a canned log
# formatter.
#
# * {Formatter.default}
# * {Formatter.colored}
# * {Formatter.short}
#
# # Pattern Substitutions
#
# You can put any of these placeholders into you pattern.
#
#   * `:client_class` - The name of the client class.
#
#   * `:operation` - The name of the client request method.
#
#   * `:request_params` - The user provided request parameters. Long
#     strings are truncated/summarized if they exceed the
#     `:max_string_size`.  Other objects are inspected.
#
#   * `:time` - The total time in seconds spent on the
#     request.  This includes client side time spent building
#     the request and parsing the response.
#
#   * `:retries` - The number of times a client request was retried.
#
#   * `:http_request_method` - The http request verb, e.g., `POST`,
#     `PUT`, `GET`, etc.
#
#   * `:http_request_endpoint` - The request endpoint.  This includes
#      the scheme, host and port, but not the path.
#
#   * `:http_request_scheme` - This is replaced by `http` or `https`.
#
#   * `:http_request_host` - The host name of the http request
#     endpoint (e.g. 's3.amazon.com').
#
#   * `:http_request_port` - The port number (e.g. '443' or '80').
#
#   * `:http_request_headers` - The http request headers, inspected.
#
#   * `:http_request_body` - The http request payload.
#
#   * `:http_response_status_code` - The http response status
#     code, e.g., `200`, `404`, `500`, etc.
#
#   * `:http_response_headers` - The http response headers, inspected.
#
#   * `:http_response_body` - The http response body contents.
#
#   * `:error_class`
#
#   * `:error_message`
class Aws::Log::Formatter
  # @option options
  # @option options
  # @option options
  # @param pattern [String] The log format pattern should be a string
  #   and may contain substitutions.
  # @param options [Hash] a customizable set of options
  # @return [Formatter] a new instance of Formatter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#91
  def initialize(pattern, options = T.unsafe(nil)); end

  # Given a response, this will format a log message and return it as a
  #   string according to {#pattern}.
  #
  # @param response [Seahorse::Client::Response]
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#104
  def format(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#109
  def method_missing(method_name, *args); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#98
  def pattern; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#119
  def _client_class(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#189
  def _error_class(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#193
  def _error_message(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#167
  def _http_request_body(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#143
  def _http_request_endpoint(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#163
  def _http_request_headers(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#151
  def _http_request_host(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#159
  def _http_request_method(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#155
  def _http_request_port(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#147
  def _http_request_scheme(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#179
  def _http_response_body(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#175
  def _http_response_headers(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#171
  def _http_response_status_code(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#123
  def _operation(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#127
  def _request_params(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#139
  def _retries(response); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#133
  def _time(response); end

  class << self
    # The default log format with ANSI colors.
    #
    # @example A sample of the colored format (sans the ansi colors).
    #
    #   [ClientClass 200 0.580066 0 retries] list_objects(:bucket_name => 'bucket')
    # @option options
    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#243
    def colored(options = T.unsafe(nil)); end

    # The default log format.
    #
    # @example A sample of the default format.
    #
    #   [ClientClass 200 0.580066 0 retries] list_objects(:bucket_name => 'bucket')
    # @option options
    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#206
    def default(options = T.unsafe(nil)); end

    # The short log format.  Similar to default, but it does not
    # inspect the request params or report on retries.
    #
    # @example A sample of the short format
    #
    #   [ClientClass 200 0.494532] list_buckets
    # @option options
    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/log/formatter.rb#226
    def short(options = T.unsafe(nil)); end
  end
end

class Aws::Log::ParamFilter
  # end
  #
  # @return [ParamFilter] a new instance of ParamFilter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#22
  def initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#27
  def filter(values, type); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#64
  def filter_array(values, type); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#45
  def filter_hash(values, type); end

  # source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#38
  def filter_struct(values, type); end
end

# DEPRECATED - This must exist for backwards compatibility. Sensitive
# members are now computed for each request/response type. This can be
# removed in a new major version. This list is no longer updated.
#
# A managed list of sensitive parameters that should be filtered from
# logs. This is updated automatically as part of each release. See the
# `tasks/update-sensitive-params.rake` for more information.
#
# begin
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/log/param_filter.rb#19
Aws::Log::ParamFilter::SENSITIVE = T.let(T.unsafe(nil), Array)

# @api private
class Aws::Log::ParamFormatter
  # @api private
  # @return [ParamFormatter] a new instance of ParamFormatter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#13
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#17
  def summarize(value); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#64
  def summarize_array(array); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#60
  def summarize_file(path); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#23
  def summarize_hash(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#41
  def summarize_string(str); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#35
  def summarize_string_hash(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#29
  def summarize_symbol_hash(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#49
  def summarize_value(value); end
end

# String longer than the max string size are truncated
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/log/param_formatter.rb#11
Aws::Log::ParamFormatter::MAX_STRING_SIZE = T.let(T.unsafe(nil), Integer)

# Decorates a {Seahorse::Client::Response} with paging convenience methods.
# Some AWS calls provide paged responses to limit the amount of data returned
# with each response. To optimize for latency, some APIs may return an
# inconsistent number of responses per page. You should rely on the values of
# the `next_page?` method or using enumerable methods such as `each` rather
# than the number of items returned to iterate through results. See below for
# examples.
#
# # Paged Responses Are Enumerable
# The simplest way to handle paged response data is to use the built-in
# enumerator in the response object, as shown in the following example.
#
#     s3 = Aws::S3::Client.new
#
#     s3.list_objects(bucket:'aws-sdk').each do |response|
#       puts response.contents.map(&:key)
#     end
#
# This yields one response object per API call made, and enumerates objects
# in the named bucket. The SDK retrieves additional pages of data to
# complete the request.
#
# # Handling Paged Responses Manually
# To handle paging yourself, use the response’s `next_page?` method to verify
# there are more pages to retrieve, or use the last_page? method to verify
# there are no more pages to retrieve.
#
# If there are more pages, use the `next_page` method to retrieve the
# next page of results, as shown in the following example.
#
#     s3 = Aws::S3::Client.new
#
#     # Get the first page of data
#     response = s3.list_objects(bucket:'aws-sdk')
#
#     # Get additional pages
#     while response.next_page? do
#       response = response.next_page
#       # Use the response data here...
#       puts response.contents.map(&:key)
#     end
#
# @note Methods such as `to_json` will enumerate all of the responses before
#   returning the full response as JSON.
module Aws::PageableResponse
  # Yields the current and each following response to the given block.
  #
  # @return [Enumerable, nil] Returns a new Enumerable if no block is given.
  # @yieldparam response [Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#83
  def each(&block); end

  # Yields the current and each following response to the given block.
  # Actual implementation is in PageableResponse::Extension
  #
  # @return [Enumerable, nil] Returns a new Enumerable if no block is given.
  # @yieldparam response [Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#83
  def each_page(&block); end

  # Returns `true` if there are no more results.  Calling {#next_page}
  # when this method returns `false` will raise an error.
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#64
  def last_page?; end

  # @return [Seahorse::Client::Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#76
  def next_page(params = T.unsafe(nil)); end

  # Returns `true` if there are more results.  Calling {#next_page} will
  # return the next response.
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#71
  def next_page?; end

  # @return [Paging::Pager]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#59
  def pager; end

  # @return [Paging::Pager]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#59
  def pager=(_arg0); end

  private

  # @param params [Hash] A hash of additional request params to
  #   merge into the next page request.
  # @return [Hash] Returns the hash of request parameters for the
  #   next page, merging any given params.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#102
  def next_page_params(params); end

  # @param params [Hash] A hash of additional request params to
  #   merge into the next page request.
  # @return [Seahorse::Client::Response] Returns the next page of
  #   results.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#94
  def next_response(params); end

  class << self
    # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#51
    def apply(base); end
  end
end

# The actual decorator module implementation. It is in a distinct module
# so that it can be used to extend objects without busting Ruby's constant cache.
# object.extend(mod) bust the constant cache only if `mod` contains constants of its own.
#
# @api private
module Aws::PageableResponse::Extension
  include ::Enumerable
  include ::Aws::PageableResponse::UnsafeEnumerableMethods

  # @api private
  # @yield [response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#188
  def each(&block); end

  # @api private
  # @yield [response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#188
  def each_page(&block); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#169
  def last_page?; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#180
  def next_page(params = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#176
  def next_page?; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#167
  def pager; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#167
  def pager=(_arg0); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#207
  def next_page_params(params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#201
  def next_response(params); end
end

# Raised when calling {PageableResponse#next_page} on a pager that
# is on the last page of results.  You can call {PageableResponse#last_page?}
# or {PageableResponse#next_page?} to know if there are more pages.
class Aws::PageableResponse::LastPageError < ::RuntimeError
  # @param response [Seahorse::Client::Response]
  # @return [LastPageError] a new instance of LastPageError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#112
  def initialize(response); end

  # @return [Seahorse::Client::Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#118
  def response; end
end

# A handful of Enumerable methods, such as #count are not safe
# to call on a pageable response, as this would trigger n api calls
# simply to count the number of response pages, when likely what is
# wanted is to access count on the data. Same for #to_h.
#
# @api private
module Aws::PageableResponse::UnsafeEnumerableMethods
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#149
  def as_json(_options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#129
  def count; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#137
  def respond_to?(method_name, *args); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#145
  def to_h; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pageable_response.rb#153
  def to_json(options = T.unsafe(nil)); end
end

# @api private
class Aws::Pager
  # @api private
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Pager] a new instance of Pager
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#12
  def initialize(options); end

  # @api private
  # @return [Symbol, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#19
  def limit_key; end

  # @api private
  # @param response [Seahorse::Client::Response]
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#26
  def next_tokens(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#34
  def prev_tokens(response); end

  # @api private
  # @return [Hash, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#22
  def tokens; end

  # @api private
  # @param response [Seahorse::Client::Response]
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#43
  def truncated?(response); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#55
  def empty_value?(value); end
end

# @api private
class Aws::Pager::NullPager
  # @api private
  # @return [nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#62
  def limit_key; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#64
  def next_tokens; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#68
  def prev_tokens; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/pager.rb#72
  def truncated?(response); end
end

# @api private
class Aws::ParamConverter
  include ::Seahorse::Model::Shapes

  # @api private
  # @return [ParamConverter] a new instance of ParamConverter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#18
  def initialize(rules); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#36
  def close_opened_files; end

  # @api private
  # @param params [Hash]
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#28
  def convert(params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#24
  def opened_files; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#86
  def c(ref, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#57
  def list(ref, values); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#66
  def map(ref, values); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#77
  def member(ref, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#43
  def structure(ref, values); end

  class << self
    # Registers a new value converter.  Converters run in the context
    # of a shape and value class.
    #
    #     # add a converter that stringifies integers
    #     shape_class = Seahorse::Model::Shapes::StringShape
    #     ParamConverter.add(shape_class, Integer) { |i| i.to_s }
    #
    # @api private
    # @param shape_class [Class<Model::Shapes::Shape>]
    # @param value_class [Class]
    # @param converter [#call] (nil) An object that responds to `#call`
    #   accepting a single argument.  This function should perform
    #   the value conversion if possible, returning the result.
    #   If the conversion is not possible, the original value should
    #   be returned.
    # @return [void]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#111
    def add(shape_class, value_class, converter = T.unsafe(nil), &block); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#126
    def c(shape, value, instance = T.unsafe(nil)); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#92
    def convert(shape, params); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#115
    def ensure_open(file, converter); end

    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#136
    def converter_for(shape_class, value); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#161
    def each_base_class(shape_class, &block); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_converter.rb#147
    def find(shape_class, value); end
  end
end

# @api private
class Aws::ParamValidator
  include ::Seahorse::Model::Shapes

  # @api private
  # @option options
  # @param rules [Seahorse::Model::Shapes::ShapeRef]
  # @param options [Hash] a customizable set of options
  # @return [ParamValidator] a new instance of ParamValidator
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#20
  def initialize(rules, options = T.unsafe(nil)); end

  # @api private
  # @param params [Hash]
  # @raise [ArgumentError]
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#32
  def validate!(params); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#197
  def correct_type?(ref, value, errors, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#128
  def document(ref, value, errors, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#222
  def error_messages(errors); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#232
  def expected_got(context, expected, got); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#213
  def io_like?(value, require_size = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#99
  def list(ref, values, errors, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#113
  def map(ref, values, errors, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#148
  def shape(ref, value, errors, context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#218
  def streaming_input?(ref); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#40
  def structure(ref, values, errors, context); end

  class << self
    # @api private
    # @param rules [Seahorse::Model::Shapes::ShapeRef]
    # @param params [Hash]
    # @return [void]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#14
    def validate!(rules, params); end
  end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/param_validator.rb#9
Aws::ParamValidator::EXPECTED_GOT = T.let(T.unsafe(nil), String)

# @api private
module Aws::Plugins; end

# @api private
class Aws::Plugins::BearerAuthorization < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/bearer_authorization.rb#34
  def add_handlers(handlers, cfg); end
end

# @api private
class Aws::Plugins::BearerAuthorization::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/bearer_authorization.rb#51
  def call(context); end
end

# @api private
class Aws::Plugins::ChecksumAlgorithm < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#56
  def add_handlers(handlers, _config); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#248
    def calculate_checksum(algorithm, body); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#258
    def digest_for_algorithm(algorithm); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#79
    def operation_response_algorithms(context); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#65
    def request_algorithm_selection(context); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#72
    def request_validation_mode(context); end

    # The trailer size (in bytes) is the overhead + the trailer name +
    # the length of the base64 encoded checksum
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#274
    def trailer_length(algorithm, location_name); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#278
    def update_in_chunks(digest, io); end
  end
end

# Wrapper for request body that implements application-layer
# chunking with Digest computed on chunks + added as a trailer
#
# @api private
class Aws::Plugins::ChecksumAlgorithm::AwsChunkedTrailerDigestIO
  # @api private
  # @return [AwsChunkedTrailerDigestIO] a new instance of AwsChunkedTrailerDigestIO
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#292
  def initialize(io, algorithm, location_name); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#317
  def read(length, buf); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#313
  def rewind; end

  # the size of the application layer aws-chunked + trailer body
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#301
  def size; end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#290
Aws::Plugins::ChecksumAlgorithm::AwsChunkedTrailerDigestIO::CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# priority order of checksum algorithms to validate responses against
# Remove any algorithms not supported by client (ie, depending on CRT availability)
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#23
Aws::Plugins::ChecksumAlgorithm::CHECKSUM_ALGORITHM_PRIORITIES = T.let(T.unsafe(nil), Array)

# byte size of checksums, used in computing the trailer length
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#26
Aws::Plugins::ChecksumAlgorithm::CHECKSUM_SIZE = T.let(T.unsafe(nil), Hash)

# one MB
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#7
Aws::Plugins::ChecksumAlgorithm::CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# determine the set of supported client side checksum algorithms
# CRC32c requires aws-crt (optional sdk dependency) for support
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#11
Aws::Plugins::ChecksumAlgorithm::CLIENT_ALGORITHMS = T.let(T.unsafe(nil), Array)

# @api private
class Aws::Plugins::ChecksumAlgorithm::ChecksumHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#118
  def call(context); end

  private

  # Add events to the http_response to verify the checksum as its read
  # This prevents the body from being read multiple times
  # verification is done only once a successful response has completed
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#192
  def add_verify_response_checksum_handlers(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#164
  def apply_request_trailer_checksum(context, checksum_properties); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#150
  def calculate_request_checksum(context, checksum_properties); end

  # determine where (header vs trailer) a request checksum should be added
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#238
  def checksum_request_in(context); end

  # returns nil if no headers to verify
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#229
  def response_header_to_verify(headers, validation_list); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#141
  def should_calculate_request_checksum?(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#146
  def should_verify_response_checksum?(context); end
end

# Interface for computing digests on request/response bodies
# which may be files, strings or IO like objects
# Applies only to digest functions that produce 32 bit integer checksums
# (eg CRC32)
#
# @api private
class Aws::Plugins::ChecksumAlgorithm::Digest32
  # @api private
  # @param digest_fn [Object]
  # @return [Digest32] a new instance of Digest32
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#42
  def initialize(digest_fn); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#51
  def base64digest; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#47
  def update(chunk); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#39
  def value; end
end

# @api private
class Aws::Plugins::ChecksumAlgorithm::OptionHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/checksum_algorithm.rb#88
  def call(context); end
end

# @api private
class Aws::Plugins::ClientMetricsPlugin < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#60
  def add_handlers(handlers, config); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#114
    def resolve_client_id(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#100
    def resolve_client_side_monitoring(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#87
    def resolve_client_side_monitoring_host(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#74
    def resolve_client_side_monitoring_port(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#70
    def resolve_publisher(cfg); end
  end
end

# @api private
class Aws::Plugins::ClientMetricsPlugin::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#123
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#202
  def _calculate_service_id(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_plugin.rb#208
  def _fallback_service_id(id); end
end

# @api private
class Aws::Plugins::ClientMetricsSendPlugin < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_send_plugin.rb#9
  def add_handlers(handlers, config); end
end

# @api private
class Aws::Plugins::ClientMetricsSendPlugin::AttemptHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_send_plugin.rb#31
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_send_plugin.rb#76
  def _extract_error_name(error); end
end

# @api private
class Aws::Plugins::ClientMetricsSendPlugin::LatencyHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/client_metrics_send_plugin.rb#20
  def call(context); end
end

# @api private
class Aws::Plugins::CredentialsConfiguration < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::DefaultsMode < ::Seahorse::Client::Plugin
  class << self
    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/defaults_mode.rb#29
    def resolve_defaults_mode(cfg); end
  end
end

# @api private
class Aws::Plugins::EndpointDiscovery < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#60
  def add_handlers(handlers, config); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#162
    def resolve_endpoint_discovery(cfg); end
  end
end

# @api private
class Aws::Plugins::EndpointDiscovery::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#66
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#98
  def _apply_endpoint_discovery_user_agent(ctx); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#106
  def _discover_endpoint(ctx, required); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_discovery.rb#89
  def _valid_uri(address); end
end

# @api private
class Aws::Plugins::EndpointPattern < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_pattern.rb#17
  def add_handlers(handlers, config); end
end

# @api private
class Aws::Plugins::EndpointPattern::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_pattern.rb#23
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_pattern.rb#35
  def _apply_endpoint_trait(context, trait); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/endpoint_pattern.rb#48
  def _replace_label_value(ori, label, input_ref, params); end
end

# @api private
class Aws::Plugins::EventStreamConfiguration < ::Seahorse::Client::Plugin; end

# This plugin provides the ability to provide global configuration for
# all AWS classes or specific ones.
#
# ## Global AWS configuration
#
# You can specify global configuration defaults via `Aws.config`
#
#     Aws.config[:region] = 'us-west-2'
#
# Options applied to `Aws.config` are merged with constructed
# service interfaces.
#
#     # uses the global configuration
#     Aws::EC2.new.config.region #=> 'us-west-2'
#
#     # constructor args have priority over global configuration
#     Aws::EC2.new(region: 'us-east-1').config.region #=> 'us-east-1'
#
# ## Service Specific Global Configuration
#
# Some services have very specific configuration options that are not
# shared by other services.
#
#     # oops, this option is only recognized by Aws::S3
#     Aws.config[:force_path_style] = true
#     Aws::EC2.new
#     #=> raises ArgumentError: invalid configuration option `:force_path_style'
#
# To avoid this issue, you can nest service specific options
#
#     Aws.config[:s3] = { force_path_style: true }
#
#     Aws::EC2.new # no error this time
#     Aws::S3.new.config.force_path_style #=> true
#
# @api private
class Aws::Plugins::GlobalConfiguration < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/global_configuration.rb#49
  def before_initialize(client_class, options); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/global_configuration.rb#65
  def apply_aws_defaults(client_class, options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/global_configuration.rb#57
  def apply_service_defaults(client_class, options); end

  class << self
    # Registers an additional service identifier.
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/global_configuration.rb#77
    def add_identifier(identifier); end

    # @api private
    # @return [Set<String>]
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/global_configuration.rb#83
    def identifiers; end
  end
end

# @api private
class Aws::Plugins::HelpfulSocketErrors < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::HelpfulSocketErrors::Handler < ::Seahorse::Client::Handler
  # Wrap `SocketError` errors with `Aws::Errors::NoSuchEndpointError`
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/helpful_socket_errors.rb#11
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/helpful_socket_errors.rb#30
  def no_such_endpoint_error(context, error); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/helpful_socket_errors.rb#23
  def socket_endpoint_error?(error); end
end

# @api private
class Aws::Plugins::HttpChecksum < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#56
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::Plugins::HttpChecksum::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#13
  def call(context); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#24
  def checksum_required?(context); end

  # @api private
  # @param value [File, Tempfile, IO#read, String]
  # @return [String<MD5>]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#32
  def md5(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#45
  def update_in_chunks(digest, io); end
end

# one MB
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/http_checksum.rb#11
Aws::Plugins::HttpChecksum::Handler::CHUNK_SIZE = T.let(T.unsafe(nil), Integer)

# Provides support for auto filling operation parameters
# that enabled with `idempotencyToken` trait  with random UUID v4
# when no value is provided
#
# @api private
class Aws::Plugins::IdempotencyToken < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::IdempotencyToken::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/idempotency_token.rb#17
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/idempotency_token.rb#24
  def auto_fill(params, ref); end
end

# Converts input value to JSON Syntax for members with jsonvalue trait
#
# @api private
class Aws::Plugins::JsonvalueConverter < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::JsonvalueConverter::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/jsonvalue_converter.rb#12
  def call(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/jsonvalue_converter.rb#19
  def convert_jsonvalue(m, ref, params, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/jsonvalue_converter.rb#46
  def serialize_jsonvalue(v, context); end
end

# @api private
# @see Log::Formatter
class Aws::Plugins::Logging < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/logging.rb#31
  def add_handlers(handlers, config); end
end

# @api private
class Aws::Plugins::Logging::Handler < ::Seahorse::Client::Handler
  # @api private
  # @param context [RequestContext]
  # @return [Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/logging.rb#39
  def call(context); end

  private

  # @api private
  # @param config [Configuration]
  # @param response [Response]
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/logging.rb#59
  def format(config, response); end

  # @api private
  # @param config [Configuration]
  # @param response [Response]
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/logging.rb#52
  def log(config, response); end
end

# @api private
class Aws::Plugins::ParamConverter < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/param_converter.rb#17
  def add_handlers(handlers, config); end
end

# @api private
class Aws::Plugins::ParamConverter::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/param_converter.rb#23
  def call(context); end
end

# @api private
class Aws::Plugins::ParamValidator < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/param_validator.rb#16
  def add_handlers(handlers, config); end
end

# @api private
class Aws::Plugins::ParamValidator::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/param_validator.rb#24
  def call(context); end
end

# @api private
module Aws::Plugins::Protocols; end

# @api private
class Aws::Plugins::Protocols::JsonRpc < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::Protocols::Query < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::Protocols::RestJson < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::Protocols::RestJson::ContentTypeHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/protocols/rest_json.rb#9
  def call(context); end
end

# @api private
class Aws::Plugins::Protocols::RestXml < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::RecursionDetection < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::RecursionDetection::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/recursion_detection.rb#10
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/recursion_detection.rb#22
  def validate_header(header_value); end
end

# @api private
class Aws::Plugins::RegionalEndpoint < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/regional_endpoint.rb#90
  def after_initialize(client); end

  class << self
    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/regional_endpoint.rb#99
    def resolve_region(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/regional_endpoint.rb#107
    def resolve_use_dualstack_endpoint(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/regional_endpoint.rb#115
    def resolve_use_fips_endpoint(cfg); end
  end
end

# @api private
class Aws::Plugins::ResponsePaging < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::ResponsePaging::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/response_paging.rb#10
  def call(context); end
end

# @api private
module Aws::Plugins::Retries; end

# Used only in 'adaptive' retry mode
#
# @api private
class Aws::Plugins::Retries::ClientRateLimiter
  # @api private
  # @return [ClientRateLimiter] a new instance of ClientRateLimiter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#17
  def initialize; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#32
  def token_bucket_acquire(amount, wait_to_fill = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#50
  def update_sending_rate(is_throttling_error); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#122
  def calculate_time_window; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#128
  def cubic_success(timestamp); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#133
  def cubic_throttle(rate_to_use); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#105
  def enable_token_bucket; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#79
  def token_bucket_refill; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#94
  def token_bucket_update_rate(new_rps); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#109
  def update_measured_rate; end
end

# How much to scale back after a throttling response
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#13
Aws::Plugins::Retries::ClientRateLimiter::BETA = T.let(T.unsafe(nil), Float)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#9
Aws::Plugins::Retries::ClientRateLimiter::MIN_CAPACITY = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#10
Aws::Plugins::Retries::ClientRateLimiter::MIN_FILL_RATE = T.let(T.unsafe(nil), Float)

# Controls how aggressively we scale up after being throttled
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#15
Aws::Plugins::Retries::ClientRateLimiter::SCALE_CONSTANT = T.let(T.unsafe(nil), Float)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/client_rate_limiter.rb#11
Aws::Plugins::Retries::ClientRateLimiter::SMOOTH = T.let(T.unsafe(nil), Float)

# @api private
class Aws::Plugins::Retries::ClockSkew
  # @api private
  # @return [ClockSkew] a new instance of ClockSkew
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#12
  def initialize; end

  # Gets the clock_correction in seconds to apply to a given endpoint
  #
  # @api private
  # @param endpoint [URI / String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#26
  def clock_correction(endpoint); end

  # Determines whether a request has clock skew by comparing
  # the current time against the server's time in the response
  #
  # @api private
  # @param context [Seahorse::Client::RequestContext]
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#44
  def clock_skewed?(context); end

  # The estimated skew factors in any clock skew from
  # the service along with any network latency.
  # This provides a more accurate value for the ttl,
  # which should represent when the client will stop
  # waiting for a request.
  # Estimated Skew should not be used to correct clock skew errors
  # it should only be used to estimate TTL for a request
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#37
  def estimated_skew(endpoint); end

  # Called only on clock skew related errors
  # Update the stored clock skew correction value for an endpoint
  # from the server's time in the response
  #
  # @api private
  # @param context [Seahorse::Client::RequestContext]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#54
  def update_clock_correction(context); end

  # Called for every request
  # Update our estimated clock skew for the endpoint
  # from the servers time in the response
  #
  # @api private
  # @param context [Seahorse::Client::RequestContext]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#67
  def update_estimated_skew(context); end

  private

  # @api private
  # @param response [Seahorse::Client::Http::Response:]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#80
  def server_time(response); end

  # Sets the clock correction for an endpoint
  #
  # @api private
  # @param endpoint [URI / String]
  # @param correction [Number]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#91
  def set_clock_correction(endpoint, correction); end
end

# five minutes
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/clock_skew.rb#10
Aws::Plugins::Retries::ClockSkew::CLOCK_SKEW_THRESHOLD = T.let(T.unsafe(nil), Integer)

# This class will be obsolete when APIs contain modeled exceptions
#
# @api private
class Aws::Plugins::Retries::ErrorInspector
  # @api private
  # @return [ErrorInspector] a new instance of ErrorInspector
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#68
  def initialize(error, http_status_code); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#85
  def checksum?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#115
  def clock_skew?(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#99
  def endpoint_discovery?(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#74
  def expired_credentials?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#107
  def modeled_retryable?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#111
  def modeled_throttling?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#89
  def networking?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#120
  def retryable?(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#95
  def server?; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#78
  def throttling_error?; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#137
  def extract_name(error); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#133
  def refreshable_credentials?(context); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#40
Aws::Plugins::Retries::ErrorInspector::CHECKSUM_ERRORS = T.let(T.unsafe(nil), Set)

# See: https://github.com/aws/aws-sdk-net/blob/5810dfe401e0eac2e59d02276d4b479224b4538e/sdk/src/Core/Amazon.Runtime/Pipeline/RetryHandler/RetryPolicy.cs#L78
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#57
Aws::Plugins::Retries::ErrorInspector::CLOCK_SKEW_ERRORS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#9
Aws::Plugins::Retries::ErrorInspector::EXPIRED_CREDS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#47
Aws::Plugins::Retries::ErrorInspector::NETWORKING_ERRORS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/error_inspector.rb#21
Aws::Plugins::Retries::ErrorInspector::THROTTLING_ERRORS = T.let(T.unsafe(nil), Set)

# Used in 'standard' and 'adaptive' retry modes.
#
# @api private
class Aws::Plugins::Retries::RetryQuota
  # @api private
  # @return [RetryQuota] a new instance of RetryQuota
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#15
  def initialize(opts = T.unsafe(nil)); end

  # check if there is sufficient capacity to retry
  # and return it.  If there is insufficient capacity
  # return 0
  #
  # @api private
  # @return [Integer] The amount of capacity checked out
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#25
  def checkout_capacity(error_inspector); end

  # capacity_amount refers to the amount of capacity requested from
  # the last retry.  It can either be RETRY_COST, TIMEOUT_RETRY_COST,
  # or unset.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#44
  def release(capacity_amount); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#10
Aws::Plugins::Retries::RetryQuota::INITIAL_RETRY_TOKENS = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#12
Aws::Plugins::Retries::RetryQuota::NO_RETRY_INCREMENT = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#11
Aws::Plugins::Retries::RetryQuota::RETRY_COST = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retries/retry_quota.rb#13
Aws::Plugins::Retries::RetryQuota::TIMEOUT_RETRY_COST = T.let(T.unsafe(nil), Integer)

# @api private
class Aws::Plugins::RetryErrors < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#421
  def add_handlers(handlers, config); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#198
    def resolve_adaptive_retry_wait_to_fill(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#212
    def resolve_correct_clock_skew(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#184
    def resolve_max_attempts(cfg); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#165
    def resolve_retry_mode(cfg); end
  end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#29
Aws::Plugins::RetryErrors::DEFAULT_BACKOFF = T.let(T.unsafe(nil), Proc)

# BEGIN LEGACY OPTIONS
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#14
Aws::Plugins::RetryErrors::EQUAL_JITTER = T.let(T.unsafe(nil), Proc)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#15
Aws::Plugins::RetryErrors::FULL_JITTER = T.let(T.unsafe(nil), Proc)

# @api private
class Aws::Plugins::RetryErrors::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#230
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#327
  def add_retry_headers(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#341
  def compute_request_ttl(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#309
  def exponential_backoff(retries); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#273
  def get_send_token(config); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#322
  def refresh_credentials?(context, error); end

  # maxsendrate is updated if on adaptive mode and based on response
  # retry quota is updated if the request is successful (both modes)
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#288
  def request_bookkeeping(context, response, error_inspector); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#314
  def retry_request(context, error); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#302
  def retryable?(context, response, error_inspector); end
end

# Max backoff (in seconds)
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#228
Aws::Plugins::RetryErrors::Handler::MAX_BACKOFF = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#18
Aws::Plugins::RetryErrors::JITTERS = T.let(T.unsafe(nil), Hash)

# @api private
class Aws::Plugins::RetryErrors::LegacyHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#359
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#397
  def delay_retry(context); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#407
  def refresh_credentials?(context, error); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#416
  def response_truncatable?(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#379
  def retry_if_possible(response, error_inspector); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#412
  def retry_limit(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#388
  def retry_request(context, error); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#401
  def should_retry?(context, error); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/retry_errors.rb#16
Aws::Plugins::RetryErrors::NO_JITTER = T.let(T.unsafe(nil), Proc)

# @api private
class Aws::Plugins::Sign < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#20
  def add_handlers(handlers, cfg); end

  class << self
    # Return a signer with the `sign(context)` method
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#27
    def signer_for(auth_scheme, config, region_override = T.unsafe(nil)); end
  end
end

# @api private
class Aws::Plugins::Sign::Bearer
  # @api private
  # @return [Bearer] a new instance of Bearer
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#63
  def initialize; end

  # @api private
  # @raise [ArgumentError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#80
  def presign_url(*args); end

  # @api private
  # @raise [Errors::MissingBearerTokenError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#66
  def sign(context); end

  # @api private
  # @raise [ArgumentError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#84
  def sign_event(*args); end
end

# @api private
class Aws::Plugins::Sign::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#39
  def call(context); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#54
  def v2_signing?(config); end
end

# @api private
class Aws::Plugins::Sign::NullSigner
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#192
  def presign_url(*args); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#189
  def sign(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#195
  def sign_event(*args); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#18
Aws::Plugins::Sign::SUPPORTED_AUTH_TYPES = T.let(T.unsafe(nil), Array)

# @api private
class Aws::Plugins::Sign::SignatureV4
  # @api private
  # @return [SignatureV4] a new instance of SignatureV4
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#91
  def initialize(auth_scheme, config, region_override = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#145
  def presign_url(*args); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#118
  def sign(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#149
  def sign_event(*args); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#155
  def apply_authtype(context, req); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#170
  def apply_clock_skew(context, req); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/sign.rb#162
  def reset_signature(req); end
end

# Necessary to exist after endpoints 2.0
#
# @api private
class Aws::Plugins::SignatureV4 < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#52
  def add_handlers(handlers, cfg); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#141
    def apply_authtype(context); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#98
    def apply_signature(options = T.unsafe(nil)); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#77
    def build_signer(cfg); end
  end
end

# @api private
class Aws::Plugins::SignatureV4::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#62
  def call(context); end
end

# @api private
class Aws::Plugins::SignatureV4::MissingCredentialsSigner
  # @api private
  # @raise [Errors::MissingCredentialsError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#69
  def sign_request(*args); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/plugins/signature_v4.rb#11
Aws::Plugins::SignatureV4::V4_AUTH = T.let(T.unsafe(nil), Array)

# @api private
class Aws::Plugins::StubResponses < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#31
  def add_handlers(handlers, config); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#35
  def after_initialize(client); end
end

# @api private
class Aws::Plugins::StubResponses::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#64
  def apply_stub(stub, response, async_mode = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#50
  def call(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#73
  def signal_error(error, http_resp); end

  # @api private
  # @param stub [Seahorse::Client::Http::Response]
  # @param http_resp [Seahorse::Client::Http::Response | Seahorse::Client::Http::AsyncResponse]
  # @param async_mode [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/stub_responses.rb#84
  def signal_http(stub, http_resp, async_mode = T.unsafe(nil)); end
end

# For Streaming Input Operations, when `requiresLength` is enabled
# checking whether `Content-Length` header can be set,
# for `v4-unsigned-body` operations, set `Transfer-Encoding` header
#
# @api private
class Aws::Plugins::TransferEncoding < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::TransferEncoding::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/transfer_encoding.rb#13
  def call(context); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/transfer_encoding.rb#40
  def requires_length?(ref); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/transfer_encoding.rb#31
  def streaming?(ref); end
end

# @api private
class Aws::Plugins::UserAgent < ::Seahorse::Client::Plugin; end

# @api private
class Aws::Plugins::UserAgent::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/user_agent.rb#11
  def call(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/plugins/user_agent.rb#16
  def set_user_agent(context); end
end

# A credential provider that executes a given process and attempts
# to read its stdout to recieve a JSON payload containing the credentials.
#
#     credentials = Aws::ProcessCredentials.new('/usr/bin/credential_proc')
#     ec2 = Aws::EC2::Client.new(credentials: credentials)
#
# Automatically handles refreshing credentials if an Expiration time is
# provided in the credentials payload.
#
# @see https://docs.aws.amazon.com/cli/latest/topic/config-vars.html#sourcing-credentials-from-external-processes
class Aws::ProcessCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # Creates a new ProcessCredentials object, which allows an
  # external process to be used as a credential provider.
  #
  # credentials provider.
  #
  # @param process [String] Invocation string for process
  # @return [ProcessCredentials] a new instance of ProcessCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/process_credentials.rb#24
  def initialize(process); end

  private

  # @raise [Errors::InvalidProcessCredentialsPayload]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/process_credentials.rb#58
  def _parse_payload_format_v1(creds_json); end

  # source://aws-sdk-core//lib/aws-sdk-core/process_credentials.rb#33
  def credentials_from_process(proc_invocation); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/process_credentials.rb#74
  def near_expiration?(expiration_length); end

  # source://aws-sdk-core//lib/aws-sdk-core/process_credentials.rb#70
  def refresh; end
end

# @api private
module Aws::Query; end

class Aws::Query::EC2ParamBuilder
  include ::Seahorse::Model::Shapes

  # @return [EC2ParamBuilder] a new instance of EC2ParamBuilder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#11
  def initialize(param_list); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#17
  def apply(ref, params); end

  # Returns the value of attribute params.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#15
  def params; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#68
  def blob(value); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#44
  def format(ref, value, prefix); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#33
  def list(ref, values, prefix); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#56
  def query_name(ref); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#60
  def set(name, value); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#23
  def structure(ref, values, prefix); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#73
  def timestamp(ref, value); end

  # source://aws-sdk-core//lib/aws-sdk-core/query/ec2_param_builder.rb#64
  def ucfirst(str); end
end

# @api private
class Aws::Query::Handler < ::Seahorse::Client::Handler
  include ::Seahorse::Model::Shapes

  # @api private
  # @param context [Seahorse::Client::RequestContext]
  # @return [Seahorse::Client::Response]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#28
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#55
  def apply_params(param_list, params, rules); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#43
  def build_request(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#59
  def parse_xml(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#81
  def remove_wrapper(data, context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#68
  def rules(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#64
  def xml(context); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#10
Aws::Query::Handler::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/query/handler.rb#16
Aws::Query::Handler::METADATA_REF = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ShapeRef)

# @api private
class Aws::Query::Handler::METADATA_STRUCT < ::Struct
  # Returns the value of attribute request_id
  #
  # @return [Object] the current value of request_id
  def request_id; end

  # Sets the attribute request_id
  #
  # @param value [Object] the value to set the attribute request_id to.
  # @return [Object] the newly set value
  def request_id=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @api private
class Aws::Query::Handler::WRAPPER_STRUCT < ::Struct
  # Returns the value of attribute response_metadata
  #
  # @return [Object] the current value of response_metadata
  def response_metadata; end

  # Sets the attribute response_metadata
  #
  # @param value [Object] the value to set the attribute response_metadata to.
  # @return [Object] the newly set value
  def response_metadata=(_); end

  # Returns the value of attribute result
  #
  # @return [Object] the current value of result
  def result; end

  # Sets the attribute result
  #
  # @param value [Object] the value to set the attribute result to.
  # @return [Object] the newly set value
  def result=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @api private
class Aws::Query::Param
  # @api private
  # @param name [String]
  # @param value [String, nil] (nil)
  # @return [Param] a new instance of Param
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#9
  def initialize(name, value = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#33
  def <=>(other); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#26
  def ==(other); end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#15
  def name; end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#21
  def to_s; end

  # @api private
  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#18
  def value; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param.rb#39
  def escape(str); end
end

# @api private
class Aws::Query::ParamBuilder
  include ::Seahorse::Model::Shapes

  # @api private
  # @return [ParamBuilder] a new instance of ParamBuilder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#11
  def initialize(param_list); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#17
  def apply(ref, params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#15
  def params; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#98
  def blob(value); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#84
  def flat?(ref); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#65
  def format(ref, value, prefix); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#32
  def list(ref, values, prefix); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#53
  def map(ref, values, prefix); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#76
  def query_name(ref, default = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#80
  def set(name, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#23
  def structure(ref, values, prefix); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_builder.rb#88
  def timestamp(ref, value); end
end

# @api private
class Aws::Query::ParamList
  include ::Enumerable

  # @api private
  # @return [ParamList] a new instance of ParamList
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#12
  def initialize; end

  # @api private
  # @return [Param, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#27
  def [](param_name); end

  # @api private
  # @param param_name [String]
  # @param param_value [String, nil]
  # @return [Param]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#19
  def []=(param_name, param_value = T.unsafe(nil)); end

  # @api private
  # @param param_name [String]
  # @return [Param, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#33
  def delete(param_name); end

  # @api private
  # @return [Enumerable]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#38
  def each(&block); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#43
  def empty?; end

  # @api private
  # @param param_name [String]
  # @param param_value [String, nil]
  # @return [Param]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#19
  def set(param_name, param_value = T.unsafe(nil)); end

  # @api private
  # @return [Array<Param>] Returns an array of sorted {Param} objects.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#48
  def to_a; end

  # @api private
  # @return [#read, #rewind, #size]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#58
  def to_io; end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#53
  def to_s; end
end

# @api private
class Aws::Query::ParamList::IoWrapper
  # @api private
  # @param param_list [ParamList]
  # @return [IoWrapper] a new instance of IoWrapper
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#66
  def initialize(param_list); end

  # @api private
  # @return [ParamList]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#72
  def param_list; end

  # @api private
  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#85
  def read(bytes = T.unsafe(nil), output_buffer = T.unsafe(nil)); end

  # @api private
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#80
  def rewind; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/query/param_list.rb#75
  def size; end
end

# Base class used credential classes that can be refreshed. This
# provides basic refresh logic in a thread-safe manner. Classes mixing in
# this module are expected to implement a #refresh method that populates
# the following instance variables:
#
# * `@access_key_id`
# * `@secret_access_key`
# * `@session_token`
# * `@expiration`
#
# @api private
module Aws::RefreshingCredentials
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#25
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Credentials]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#34
  def credentials; end

  # @api private
  # @return [Time, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#40
  def expiration; end

  # Refresh credentials.
  #
  # @api private
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#47
  def refresh!; end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#86
  def near_expiration?(expiration_length); end

  # Refreshes credentials asynchronously and synchronously.
  # If we are near to expiration, block while getting new credentials.
  # Otherwise, if we're approaching expiration, use the existing credentials
  # but attempt a refresh in the background.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#61
  def refresh_if_near_expiration!; end
end

# 10 minutes
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#21
Aws::RefreshingCredentials::ASYNC_EXPIRATION_LENGTH = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#23
Aws::RefreshingCredentials::CLIENT_EXCLUDE_OPTIONS = T.let(T.unsafe(nil), Set)

# 5 minutes
#
# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/refreshing_credentials.rb#20
Aws::RefreshingCredentials::SYNC_EXPIRATION_LENGTH = T.let(T.unsafe(nil), Integer)

# Module/mixin used by token provider classes that can be refreshed. This
# provides basic refresh logic in a thread-safe manner. Classes mixing in
# this module are expected to implement a #refresh method that populates
# the following instance variable:
#
# * `@token` [Token] - {Aws::Token} object with the `expiration` and `token`
#       fields set.
#
# @api private
module Aws::RefreshingToken
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#18
  def initialize(options = T.unsafe(nil)); end

  # @api private
  # @return [Time, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#33
  def expiration; end

  # Refresh token.
  #
  # @api private
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#40
  def refresh!; end

  # @api private
  # @return [Token]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#27
  def token; end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#62
  def near_expiration?; end

  # Refreshes token if it is within
  # 5 minutes of expiration.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/refreshing_token.rb#51
  def refresh_if_near_expiration; end
end

module Aws::Resources; end

class Aws::Resources::Collection
  include ::Enumerable
  extend ::Aws::Deprecations

  # @api private
  # @option options
  # @option options
  # @param batches [Enumerator<Array>]
  # @param options [Hash] a customizable set of options
  # @return [Collection] a new instance of Collection
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#14
  def initialize(batches, options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def [](*args, &block); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#30
  def batches; end

  # @return [Enumerator<Band>]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#50
  def each(&block); end

  # @param count [Integer]
  # @return [Resource, Collection]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#64
  def first(count = T.unsafe(nil)); end

  # @return [Integer, nil] Returns the size of this collection if known, returns `nil` when
  #   an API call is necessary to enumerate items in this collection.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#23
  def length; end

  # Returns a new collection that will enumerate a limited number of items.
  #
  #     collection.limit(10).each do |band|
  #       # yields at most 10 times
  #     end
  #
  # @param limit [Integer]
  # @return [Collection]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#85
  def limit(limit); end

  # @return [Integer, nil] Returns the size of this collection if known, returns `nil` when
  #   an API call is necessary to enumerate items in this collection.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#23
  def size; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#91
  def batch_enum; end

  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#107
  def limited_batches; end

  # source://aws-sdk-core//lib/aws-sdk-core/resources/collection.rb#99
  def non_empty_batches; end
end

# @api private
module Aws::Rest; end

# @api private
class Aws::Rest::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/handler.rb#8
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/handler.rb#18
  def apply_request_id(context); end
end

# @api private
module Aws::Rest::Request; end

# @api private
class Aws::Rest::Request::Body
  include ::Seahorse::Model::Shapes

  # @api private
  # @param serializer_class [Class]
  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Body] a new instance of Body
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#12
  def initialize(serializer_class, rules); end

  # @api private
  # @param http_req [Seahorse::Client::Http::Request]
  # @param params [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#19
  def apply(http_req, params); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#66
  def body_params(params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#43
  def build_body(params); end

  # operation is modeled for body when it is modeled for a payload
  # either with payload trait or normal members.
  #
  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#34
  def modeled_body?; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#62
  def serialize(rules, params); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/body.rb#55
  def streaming?; end
end

# @api private
class Aws::Rest::Request::Builder
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#8
  def apply(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#33
  def populate_body(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#21
  def populate_endpoint(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#28
  def populate_headers(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#17
  def populate_http_method(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/builder.rb#40
  def serializer_class(context); end
end

# @api private
class Aws::Rest::Request::Endpoint
  # @api private
  # @param rules [Seahorse::Model::Shapes::ShapeRef]
  # @param request_uri_pattern [String]
  # @return [Endpoint] a new instance of Endpoint
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#12
  def initialize(rules, request_uri_pattern); end

  # @api private
  # @param base_uri [URI::HTTPS, URI::HTTP]
  # @param params [Hash, Struct]
  # @return [URI::HTTPS, URI::HTTP]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#23
  def uri(base_uri, params); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#32
  def apply_path_params(uri, params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#57
  def apply_querystring_params(uri, params); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#71
  def escape(string); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#51
  def param_name(placeholder); end

  # @api private
  # @raise [ArgumentError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/endpoint.rb#39
  def param_value_for_placeholder(placeholder, params); end
end

# @api private
class Aws::Rest::Request::Headers
  include ::Seahorse::Model::Shapes

  # @api private
  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Headers] a new instance of Headers
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#14
  def initialize(rules); end

  # @api private
  # @param http_req [Seahorse::Client::Http::Request]
  # @param params [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#20
  def apply(http_req, params); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#60
  def apply_header_map(headers, ref, values); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#33
  def apply_header_value(headers, ref, value); end

  # With complex headers value in json syntax,
  # base64 encodes value to avoid weird characters
  # causing potential issues in headers
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#70
  def apply_json_trait(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#52
  def list(headers, ref, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/headers.rb#42
  def timestamp(ref, value); end
end

# @api private
class Aws::Rest::Request::QuerystringBuilder
  include ::Seahorse::Model::Shapes

  # Provide shape references and param values:
  #
  #     [
  #       [shape_ref1, 123],
  #       [shape_ref2, "text"]
  #     ]
  #
  # Returns a querystring:
  #
  #   "Count=123&Words=text"
  #
  # @api private
  # @param params [Array<Array<Seahorse::Model::ShapeRef, Object>>] An array of
  #   model shape references and request parameter value pairs.
  # @return [String] Returns a built querystring
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#25
  def build(params); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#33
  def build_part(shape_ref, param_value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#98
  def escape(string); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#92
  def list_of_strings(name, values); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#74
  def query_map_of_string(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#82
  def query_map_of_string_list(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/request/querystring_builder.rb#64
  def timestamp(ref, value); end
end

# @api private
module Aws::Rest::Response; end

# @api private
class Aws::Rest::Response::Body
  include ::Seahorse::Model::Shapes

  # @api private
  # @param parser_class [Class]
  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Body] a new instance of Body
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#12
  def initialize(parser_class, rules); end

  # @api private
  # @param body [IO]
  # @param data [Hash, Struct]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#19
  def apply(body, data); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#33
  def event_stream?; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#44
  def parse(body, rules, target = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#48
  def parse_eventstream(body); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/body.rb#37
  def streaming?; end
end

# @api private
class Aws::Rest::Response::Headers
  include ::Seahorse::Model::Shapes

  # @api private
  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Headers] a new instance of Headers
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#14
  def initialize(rules); end

  # @api private
  # @param http_resp [Seahorse::Client::Http::Response]
  # @param target [Hash, Struct]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#20
  def apply(http_resp, target); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#36
  def cast_value(ref, value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#61
  def extract_header_map(headers, name, ref, data); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#30
  def extract_header_value(headers, name, ref, data); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/headers.rb#71
  def extract_json_trait(value); end
end

# @api private
class Aws::Rest::Response::Parser
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/parser.rb#8
  def apply(response); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/parser.rb#32
  def extract_body(rules, response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/parser.rb#27
  def extract_headers(rules, response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/parser.rb#22
  def extract_status_code(rules, response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/parser.rb#40
  def parser_class(response); end
end

# @api private
class Aws::Rest::Response::StatusCode
  # @api private
  # @param rules [Seahorse::Model::Shapes::ShapeRef]
  # @return [StatusCode] a new instance of StatusCode
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/status_code.rb#9
  def initialize(rules); end

  # @api private
  # @param http_resp [Seahorse::Client::Http::Response]
  # @param data [Hash, Struct]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/rest/response/status_code.rb#15
  def apply(http_resp, data); end
end

module Aws::S3; end

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption.rb#20
Aws::S3::AES_GCM_TAG_LEN_BYTES = T.let(T.unsafe(nil), Integer)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_region_cache.rb#78
Aws::S3::BUCKET_REGIONS = T.let(T.unsafe(nil), Aws::S3::BucketRegionCache)

class Aws::S3::Bucket
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#678
  def acl; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/bucket.rb#15
  def clear!; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#47
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#686
  def cors; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#276
  def create(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#40
  def creation_date; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#62
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#70
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#293
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/bucket.rb#35
  def delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#362
  def delete_objects(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#971
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#77
  def exists?(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#694
  def lifecycle; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#702
  def lifecycle_configuration; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/bucket.rb#136
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#710
  def logging; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#773
  def multipart_uploads(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#33
  def name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#795
  def notification; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#804
  def object(key); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#853
  def object_versions(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#909
  def objects(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#930
  def policy; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/bucket.rb#126
  def presigned_post(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#665
  def put_object(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#53
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#938
  def request_payment; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#946
  def tagging; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/bucket.rb#88
  def url(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#954
  def versioning; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#202
  def wait_until(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#94
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#111
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#962
  def website; end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#978
  def extract_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#999
  def separate_params_and_options(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket.rb#989
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::Bucket::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketAcl
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#275
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#52
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#72
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#80
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#284
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#45
  def grants; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#62
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#39
  def owner; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#266
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#62
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#164
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_acl.rb#291
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketAcl::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketCors
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#264
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#47
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#40
  def cors_rules; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#67
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#75
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#189
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#273
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#57
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#255
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#57
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#159
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_cors.rb#280
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketCors::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLifecycle
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#267
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#46
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#66
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#276
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#56
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#258
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#56
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#39
  def rules; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle.rb#283
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLifecycle::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLifecycleConfiguration
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#287
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#46
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#66
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#296
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#56
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#278
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#56
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#39
  def rules; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_lifecycle_configuration.rb#303
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLifecycleConfiguration::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketLogging
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#246
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#52
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#72
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#80
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#255
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#62
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#45
  def logging_enabled; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#237
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#62
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#164
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_logging.rb#262
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketLogging::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketNotification
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#281
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#67
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#87
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#95
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#290
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#60
  def event_bridge_configuration; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#54
  def lambda_function_configurations; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#77
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#272
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#47
  def queue_configurations; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#77
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#40
  def topic_configurations; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#179
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_notification.rb#297
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketNotification::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketPolicy
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#244
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#46
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#66
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#253
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#56
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#39
  def policy; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#235
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#56
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_policy.rb#260
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketPolicy::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketRequestPayment
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#231
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#46
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#66
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#240
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#56
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#39
  def payer; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#222
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#56
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_request_payment.rb#247
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketRequestPayment::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketTagging
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#253
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#46
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#66
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#74
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#188
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#262
  def deprecated_identifiers; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#56
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#244
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#56
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#39
  def tag_set; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#158
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_tagging.rb#269
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketTagging::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketVersioning
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#358
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#55
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#75
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#83
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#367
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#231
  def enable(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#65
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#48
  def mfa_delete; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#293
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#65
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#39
  def status; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#344
  def suspend(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#167
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_versioning.rb#374
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketVersioning::Collection < ::Aws::Resources::Collection; end

class Aws::S3::BucketWebsite
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#22
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#294
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#33
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#68
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#88
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#96
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#210
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#303
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#54
  def error_document; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#47
  def index_document; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#78
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#285
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#40
  def redirect_all_requests_to; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#78
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#61
  def routing_rules; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#180
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/bucket_website.rb#310
  def extract_bucket_name(args, options); end
end

class Aws::S3::BucketWebsite::Collection < ::Aws::Resources::Collection; end

module Aws::S3::ClientApi
  include ::Seahorse::Model
end

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#2661
Aws::S3::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#16
Aws::S3::ClientApi::AbortDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#17
Aws::S3::ClientApi::AbortIncompleteMultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#18
Aws::S3::ClientApi::AbortMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#19
Aws::S3::ClientApi::AbortMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#20
Aws::S3::ClientApi::AbortRuleId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#21
Aws::S3::ClientApi::AccelerateConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#22
Aws::S3::ClientApi::AcceptRanges = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#23
Aws::S3::ClientApi::AccessControlPolicy = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#24
Aws::S3::ClientApi::AccessControlTranslation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#25
Aws::S3::ClientApi::AccessPointArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#26
Aws::S3::ClientApi::AccountId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#27
Aws::S3::ClientApi::AllowQuotedRecordDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#28
Aws::S3::ClientApi::AllowedHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#29
Aws::S3::ClientApi::AllowedHeaders = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#30
Aws::S3::ClientApi::AllowedMethod = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#31
Aws::S3::ClientApi::AllowedMethods = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#32
Aws::S3::ClientApi::AllowedOrigin = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#33
Aws::S3::ClientApi::AllowedOrigins = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#34
Aws::S3::ClientApi::AnalyticsAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#35
Aws::S3::ClientApi::AnalyticsConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#36
Aws::S3::ClientApi::AnalyticsConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#37
Aws::S3::ClientApi::AnalyticsExportDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#38
Aws::S3::ClientApi::AnalyticsFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#39
Aws::S3::ClientApi::AnalyticsId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#40
Aws::S3::ClientApi::AnalyticsS3BucketDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#41
Aws::S3::ClientApi::AnalyticsS3ExportFileFormat = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#42
Aws::S3::ClientApi::ArchiveStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#43
Aws::S3::ClientApi::Body = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BlobShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#44
Aws::S3::ClientApi::Bucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#45
Aws::S3::ClientApi::BucketAccelerateStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#46
Aws::S3::ClientApi::BucketAlreadyExists = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#47
Aws::S3::ClientApi::BucketAlreadyOwnedByYou = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#48
Aws::S3::ClientApi::BucketCannedACL = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#49
Aws::S3::ClientApi::BucketKeyEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#50
Aws::S3::ClientApi::BucketLifecycleConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#51
Aws::S3::ClientApi::BucketLocationConstraint = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#52
Aws::S3::ClientApi::BucketLoggingStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#53
Aws::S3::ClientApi::BucketLogsPermission = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#54
Aws::S3::ClientApi::BucketName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#55
Aws::S3::ClientApi::BucketVersioningStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#56
Aws::S3::ClientApi::Buckets = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#57
Aws::S3::ClientApi::BypassGovernanceRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#58
Aws::S3::ClientApi::BytesProcessed = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#59
Aws::S3::ClientApi::BytesReturned = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#60
Aws::S3::ClientApi::BytesScanned = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#61
Aws::S3::ClientApi::CORSConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#62
Aws::S3::ClientApi::CORSRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#63
Aws::S3::ClientApi::CORSRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#64
Aws::S3::ClientApi::CSVInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#65
Aws::S3::ClientApi::CSVOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#66
Aws::S3::ClientApi::CacheControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#67
Aws::S3::ClientApi::Checksum = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#68
Aws::S3::ClientApi::ChecksumAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#69
Aws::S3::ClientApi::ChecksumAlgorithmList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#70
Aws::S3::ClientApi::ChecksumCRC32 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#71
Aws::S3::ClientApi::ChecksumCRC32C = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#72
Aws::S3::ClientApi::ChecksumMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#73
Aws::S3::ClientApi::ChecksumSHA1 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#74
Aws::S3::ClientApi::ChecksumSHA256 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#75
Aws::S3::ClientApi::CloudFunction = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#76
Aws::S3::ClientApi::CloudFunctionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#77
Aws::S3::ClientApi::CloudFunctionInvocationRole = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#78
Aws::S3::ClientApi::Code = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#79
Aws::S3::ClientApi::Comments = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#80
Aws::S3::ClientApi::CommonPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#81
Aws::S3::ClientApi::CommonPrefixList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#82
Aws::S3::ClientApi::CompleteMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#83
Aws::S3::ClientApi::CompleteMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#84
Aws::S3::ClientApi::CompletedMultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#85
Aws::S3::ClientApi::CompletedPart = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#86
Aws::S3::ClientApi::CompletedPartList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#87
Aws::S3::ClientApi::CompressionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#88
Aws::S3::ClientApi::Condition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#89
Aws::S3::ClientApi::ConfirmRemoveSelfBucketAccess = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#90
Aws::S3::ClientApi::ContentDisposition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#91
Aws::S3::ClientApi::ContentEncoding = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#92
Aws::S3::ClientApi::ContentLanguage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#93
Aws::S3::ClientApi::ContentLength = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#94
Aws::S3::ClientApi::ContentMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#95
Aws::S3::ClientApi::ContentRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#96
Aws::S3::ClientApi::ContentType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#97
Aws::S3::ClientApi::ContinuationEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#98
Aws::S3::ClientApi::CopyObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#99
Aws::S3::ClientApi::CopyObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#100
Aws::S3::ClientApi::CopyObjectResult = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#101
Aws::S3::ClientApi::CopyPartResult = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#102
Aws::S3::ClientApi::CopySource = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#103
Aws::S3::ClientApi::CopySourceIfMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#104
Aws::S3::ClientApi::CopySourceIfModifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#105
Aws::S3::ClientApi::CopySourceIfNoneMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#106
Aws::S3::ClientApi::CopySourceIfUnmodifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#107
Aws::S3::ClientApi::CopySourceRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#108
Aws::S3::ClientApi::CopySourceSSECustomerAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#109
Aws::S3::ClientApi::CopySourceSSECustomerKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#110
Aws::S3::ClientApi::CopySourceSSECustomerKeyMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#111
Aws::S3::ClientApi::CopySourceVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#112
Aws::S3::ClientApi::CreateBucketConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#113
Aws::S3::ClientApi::CreateBucketOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#114
Aws::S3::ClientApi::CreateBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#115
Aws::S3::ClientApi::CreateMultipartUploadOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#116
Aws::S3::ClientApi::CreateMultipartUploadRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#117
Aws::S3::ClientApi::CreationDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#118
Aws::S3::ClientApi::Date = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#119
Aws::S3::ClientApi::Days = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#120
Aws::S3::ClientApi::DaysAfterInitiation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#121
Aws::S3::ClientApi::DefaultRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#122
Aws::S3::ClientApi::Delete = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#123
Aws::S3::ClientApi::DeleteBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#124
Aws::S3::ClientApi::DeleteBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#125
Aws::S3::ClientApi::DeleteBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#126
Aws::S3::ClientApi::DeleteBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#127
Aws::S3::ClientApi::DeleteBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#128
Aws::S3::ClientApi::DeleteBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#129
Aws::S3::ClientApi::DeleteBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#130
Aws::S3::ClientApi::DeleteBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#131
Aws::S3::ClientApi::DeleteBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#132
Aws::S3::ClientApi::DeleteBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#133
Aws::S3::ClientApi::DeleteBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#134
Aws::S3::ClientApi::DeleteBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#135
Aws::S3::ClientApi::DeleteBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#136
Aws::S3::ClientApi::DeleteMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#137
Aws::S3::ClientApi::DeleteMarkerEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#138
Aws::S3::ClientApi::DeleteMarkerReplication = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#139
Aws::S3::ClientApi::DeleteMarkerReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#140
Aws::S3::ClientApi::DeleteMarkerVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#141
Aws::S3::ClientApi::DeleteMarkers = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#142
Aws::S3::ClientApi::DeleteObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#143
Aws::S3::ClientApi::DeleteObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#144
Aws::S3::ClientApi::DeleteObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#145
Aws::S3::ClientApi::DeleteObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#146
Aws::S3::ClientApi::DeleteObjectsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#147
Aws::S3::ClientApi::DeleteObjectsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#148
Aws::S3::ClientApi::DeletePublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#149
Aws::S3::ClientApi::DeletedObject = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#150
Aws::S3::ClientApi::DeletedObjects = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#151
Aws::S3::ClientApi::Delimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#152
Aws::S3::ClientApi::Description = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#153
Aws::S3::ClientApi::Destination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#154
Aws::S3::ClientApi::DisplayName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#155
Aws::S3::ClientApi::ETag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#156
Aws::S3::ClientApi::EmailAddress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#157
Aws::S3::ClientApi::EnableRequestProgress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#158
Aws::S3::ClientApi::EncodingType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#159
Aws::S3::ClientApi::Encryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#160
Aws::S3::ClientApi::EncryptionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#161
Aws::S3::ClientApi::End = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#162
Aws::S3::ClientApi::EndEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#163
Aws::S3::ClientApi::Error = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#164
Aws::S3::ClientApi::ErrorCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#165
Aws::S3::ClientApi::ErrorDocument = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#166
Aws::S3::ClientApi::ErrorMessage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#167
Aws::S3::ClientApi::Errors = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#168
Aws::S3::ClientApi::Event = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#169
Aws::S3::ClientApi::EventBridgeConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#170
Aws::S3::ClientApi::EventList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#171
Aws::S3::ClientApi::ExistingObjectReplication = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#172
Aws::S3::ClientApi::ExistingObjectReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#173
Aws::S3::ClientApi::Expiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#174
Aws::S3::ClientApi::ExpirationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#175
Aws::S3::ClientApi::ExpiredObjectDeleteMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#176
Aws::S3::ClientApi::Expires = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#177
Aws::S3::ClientApi::ExpiresString = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#178
Aws::S3::ClientApi::ExposeHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#179
Aws::S3::ClientApi::ExposeHeaders = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#180
Aws::S3::ClientApi::Expression = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#181
Aws::S3::ClientApi::ExpressionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#182
Aws::S3::ClientApi::FetchOwner = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#183
Aws::S3::ClientApi::FieldDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#184
Aws::S3::ClientApi::FileHeaderInfo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#185
Aws::S3::ClientApi::FilterRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#186
Aws::S3::ClientApi::FilterRuleList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#187
Aws::S3::ClientApi::FilterRuleName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#188
Aws::S3::ClientApi::FilterRuleValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#189
Aws::S3::ClientApi::GetBucketAccelerateConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#190
Aws::S3::ClientApi::GetBucketAccelerateConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#191
Aws::S3::ClientApi::GetBucketAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#192
Aws::S3::ClientApi::GetBucketAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#193
Aws::S3::ClientApi::GetBucketAnalyticsConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#194
Aws::S3::ClientApi::GetBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#195
Aws::S3::ClientApi::GetBucketCorsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#196
Aws::S3::ClientApi::GetBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#197
Aws::S3::ClientApi::GetBucketEncryptionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#198
Aws::S3::ClientApi::GetBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#199
Aws::S3::ClientApi::GetBucketIntelligentTieringConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#200
Aws::S3::ClientApi::GetBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#201
Aws::S3::ClientApi::GetBucketInventoryConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#202
Aws::S3::ClientApi::GetBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#203
Aws::S3::ClientApi::GetBucketLifecycleConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#204
Aws::S3::ClientApi::GetBucketLifecycleConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#205
Aws::S3::ClientApi::GetBucketLifecycleOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#206
Aws::S3::ClientApi::GetBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#207
Aws::S3::ClientApi::GetBucketLocationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#208
Aws::S3::ClientApi::GetBucketLocationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#209
Aws::S3::ClientApi::GetBucketLoggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#210
Aws::S3::ClientApi::GetBucketLoggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#211
Aws::S3::ClientApi::GetBucketMetricsConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#212
Aws::S3::ClientApi::GetBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#213
Aws::S3::ClientApi::GetBucketNotificationConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#214
Aws::S3::ClientApi::GetBucketOwnershipControlsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#215
Aws::S3::ClientApi::GetBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#216
Aws::S3::ClientApi::GetBucketPolicyOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#217
Aws::S3::ClientApi::GetBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#218
Aws::S3::ClientApi::GetBucketPolicyStatusOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#219
Aws::S3::ClientApi::GetBucketPolicyStatusRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#220
Aws::S3::ClientApi::GetBucketReplicationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#221
Aws::S3::ClientApi::GetBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#222
Aws::S3::ClientApi::GetBucketRequestPaymentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#223
Aws::S3::ClientApi::GetBucketRequestPaymentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#224
Aws::S3::ClientApi::GetBucketTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#225
Aws::S3::ClientApi::GetBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#226
Aws::S3::ClientApi::GetBucketVersioningOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#227
Aws::S3::ClientApi::GetBucketVersioningRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#228
Aws::S3::ClientApi::GetBucketWebsiteOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#229
Aws::S3::ClientApi::GetBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#230
Aws::S3::ClientApi::GetObjectAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#231
Aws::S3::ClientApi::GetObjectAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#232
Aws::S3::ClientApi::GetObjectAttributesOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#233
Aws::S3::ClientApi::GetObjectAttributesParts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#234
Aws::S3::ClientApi::GetObjectAttributesRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#235
Aws::S3::ClientApi::GetObjectLegalHoldOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#236
Aws::S3::ClientApi::GetObjectLegalHoldRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#237
Aws::S3::ClientApi::GetObjectLockConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#238
Aws::S3::ClientApi::GetObjectLockConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#239
Aws::S3::ClientApi::GetObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#240
Aws::S3::ClientApi::GetObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#241
Aws::S3::ClientApi::GetObjectResponseStatusCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#242
Aws::S3::ClientApi::GetObjectRetentionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#243
Aws::S3::ClientApi::GetObjectRetentionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#244
Aws::S3::ClientApi::GetObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#245
Aws::S3::ClientApi::GetObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#246
Aws::S3::ClientApi::GetObjectTorrentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#247
Aws::S3::ClientApi::GetObjectTorrentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#248
Aws::S3::ClientApi::GetPublicAccessBlockOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#249
Aws::S3::ClientApi::GetPublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#250
Aws::S3::ClientApi::GlacierJobParameters = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#251
Aws::S3::ClientApi::Grant = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#252
Aws::S3::ClientApi::GrantFullControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#253
Aws::S3::ClientApi::GrantRead = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#254
Aws::S3::ClientApi::GrantReadACP = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#255
Aws::S3::ClientApi::GrantWrite = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#256
Aws::S3::ClientApi::GrantWriteACP = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#257
Aws::S3::ClientApi::Grantee = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#258
Aws::S3::ClientApi::Grants = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#259
Aws::S3::ClientApi::HeadBucketRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#260
Aws::S3::ClientApi::HeadObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#261
Aws::S3::ClientApi::HeadObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#262
Aws::S3::ClientApi::HostName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#263
Aws::S3::ClientApi::HttpErrorCodeReturnedEquals = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#264
Aws::S3::ClientApi::HttpRedirectCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#265
Aws::S3::ClientApi::ID = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#266
Aws::S3::ClientApi::IfMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#267
Aws::S3::ClientApi::IfModifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#268
Aws::S3::ClientApi::IfNoneMatch = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#269
Aws::S3::ClientApi::IfUnmodifiedSince = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#270
Aws::S3::ClientApi::IndexDocument = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#271
Aws::S3::ClientApi::Initiated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#272
Aws::S3::ClientApi::Initiator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#273
Aws::S3::ClientApi::InputSerialization = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#274
Aws::S3::ClientApi::IntelligentTieringAccessTier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#275
Aws::S3::ClientApi::IntelligentTieringAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#276
Aws::S3::ClientApi::IntelligentTieringConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#277
Aws::S3::ClientApi::IntelligentTieringConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#278
Aws::S3::ClientApi::IntelligentTieringDays = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#279
Aws::S3::ClientApi::IntelligentTieringFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#280
Aws::S3::ClientApi::IntelligentTieringId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#281
Aws::S3::ClientApi::IntelligentTieringStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#282
Aws::S3::ClientApi::InvalidObjectState = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#283
Aws::S3::ClientApi::InventoryConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#284
Aws::S3::ClientApi::InventoryConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#285
Aws::S3::ClientApi::InventoryDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#286
Aws::S3::ClientApi::InventoryEncryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#287
Aws::S3::ClientApi::InventoryFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#288
Aws::S3::ClientApi::InventoryFormat = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#289
Aws::S3::ClientApi::InventoryFrequency = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#290
Aws::S3::ClientApi::InventoryId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#291
Aws::S3::ClientApi::InventoryIncludedObjectVersions = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#292
Aws::S3::ClientApi::InventoryOptionalField = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#293
Aws::S3::ClientApi::InventoryOptionalFields = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#294
Aws::S3::ClientApi::InventoryS3BucketDestination = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#295
Aws::S3::ClientApi::InventorySchedule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#296
Aws::S3::ClientApi::IsEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#297
Aws::S3::ClientApi::IsLatest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#298
Aws::S3::ClientApi::IsPublic = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#299
Aws::S3::ClientApi::IsTruncated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#300
Aws::S3::ClientApi::JSONInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#301
Aws::S3::ClientApi::JSONOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#302
Aws::S3::ClientApi::JSONType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#303
Aws::S3::ClientApi::KMSContext = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#304
Aws::S3::ClientApi::KeyCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#305
Aws::S3::ClientApi::KeyMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#306
Aws::S3::ClientApi::KeyPrefixEquals = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#307
Aws::S3::ClientApi::LambdaFunctionArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#308
Aws::S3::ClientApi::LambdaFunctionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#309
Aws::S3::ClientApi::LambdaFunctionConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#310
Aws::S3::ClientApi::LastModified = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#311
Aws::S3::ClientApi::LifecycleConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#312
Aws::S3::ClientApi::LifecycleExpiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#313
Aws::S3::ClientApi::LifecycleRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#314
Aws::S3::ClientApi::LifecycleRuleAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#315
Aws::S3::ClientApi::LifecycleRuleFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#316
Aws::S3::ClientApi::LifecycleRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#317
Aws::S3::ClientApi::ListBucketAnalyticsConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#318
Aws::S3::ClientApi::ListBucketAnalyticsConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#319
Aws::S3::ClientApi::ListBucketIntelligentTieringConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#320
Aws::S3::ClientApi::ListBucketIntelligentTieringConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#321
Aws::S3::ClientApi::ListBucketInventoryConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#322
Aws::S3::ClientApi::ListBucketInventoryConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#323
Aws::S3::ClientApi::ListBucketMetricsConfigurationsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#324
Aws::S3::ClientApi::ListBucketMetricsConfigurationsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#325
Aws::S3::ClientApi::ListBucketsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#326
Aws::S3::ClientApi::ListMultipartUploadsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#327
Aws::S3::ClientApi::ListMultipartUploadsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#328
Aws::S3::ClientApi::ListObjectVersionsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#329
Aws::S3::ClientApi::ListObjectVersionsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#330
Aws::S3::ClientApi::ListObjectsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#331
Aws::S3::ClientApi::ListObjectsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#332
Aws::S3::ClientApi::ListObjectsV2Output = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#333
Aws::S3::ClientApi::ListObjectsV2Request = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#334
Aws::S3::ClientApi::ListPartsOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#335
Aws::S3::ClientApi::ListPartsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#336
Aws::S3::ClientApi::Location = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#337
Aws::S3::ClientApi::LocationPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#338
Aws::S3::ClientApi::LoggingEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#339
Aws::S3::ClientApi::MFA = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#340
Aws::S3::ClientApi::MFADelete = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#341
Aws::S3::ClientApi::MFADeleteStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#342
Aws::S3::ClientApi::Marker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#343
Aws::S3::ClientApi::MaxAgeSeconds = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#344
Aws::S3::ClientApi::MaxKeys = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#345
Aws::S3::ClientApi::MaxParts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#346
Aws::S3::ClientApi::MaxUploads = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#347
Aws::S3::ClientApi::Message = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#348
Aws::S3::ClientApi::Metadata = T.let(T.unsafe(nil), Seahorse::Model::Shapes::MapShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#349
Aws::S3::ClientApi::MetadataDirective = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#350
Aws::S3::ClientApi::MetadataEntry = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#351
Aws::S3::ClientApi::MetadataKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#352
Aws::S3::ClientApi::MetadataValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#353
Aws::S3::ClientApi::Metrics = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#354
Aws::S3::ClientApi::MetricsAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#355
Aws::S3::ClientApi::MetricsConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#356
Aws::S3::ClientApi::MetricsConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#357
Aws::S3::ClientApi::MetricsFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#358
Aws::S3::ClientApi::MetricsId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#359
Aws::S3::ClientApi::MetricsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#360
Aws::S3::ClientApi::Minutes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#361
Aws::S3::ClientApi::MissingMeta = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#362
Aws::S3::ClientApi::MultipartUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#363
Aws::S3::ClientApi::MultipartUploadId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#364
Aws::S3::ClientApi::MultipartUploadList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#365
Aws::S3::ClientApi::NextKeyMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#366
Aws::S3::ClientApi::NextMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#367
Aws::S3::ClientApi::NextPartNumberMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#368
Aws::S3::ClientApi::NextToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#369
Aws::S3::ClientApi::NextUploadIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#370
Aws::S3::ClientApi::NextVersionIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#371
Aws::S3::ClientApi::NoSuchBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#372
Aws::S3::ClientApi::NoSuchKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#373
Aws::S3::ClientApi::NoSuchUpload = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#374
Aws::S3::ClientApi::NoncurrentVersionExpiration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#375
Aws::S3::ClientApi::NoncurrentVersionTransition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#376
Aws::S3::ClientApi::NoncurrentVersionTransitionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#377
Aws::S3::ClientApi::NotificationConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#378
Aws::S3::ClientApi::NotificationConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#379
Aws::S3::ClientApi::NotificationConfigurationFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#380
Aws::S3::ClientApi::NotificationId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#381
Aws::S3::ClientApi::Object = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#382
Aws::S3::ClientApi::ObjectAlreadyInActiveTierError = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#383
Aws::S3::ClientApi::ObjectAttributes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#384
Aws::S3::ClientApi::ObjectAttributesList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#385
Aws::S3::ClientApi::ObjectCannedACL = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#386
Aws::S3::ClientApi::ObjectIdentifier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#387
Aws::S3::ClientApi::ObjectIdentifierList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#388
Aws::S3::ClientApi::ObjectKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#389
Aws::S3::ClientApi::ObjectList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#390
Aws::S3::ClientApi::ObjectLockConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#391
Aws::S3::ClientApi::ObjectLockEnabled = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#392
Aws::S3::ClientApi::ObjectLockEnabledForBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#393
Aws::S3::ClientApi::ObjectLockLegalHold = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#394
Aws::S3::ClientApi::ObjectLockLegalHoldStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#395
Aws::S3::ClientApi::ObjectLockMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#396
Aws::S3::ClientApi::ObjectLockRetainUntilDate = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#397
Aws::S3::ClientApi::ObjectLockRetention = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#398
Aws::S3::ClientApi::ObjectLockRetentionMode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#399
Aws::S3::ClientApi::ObjectLockRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#400
Aws::S3::ClientApi::ObjectLockToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#401
Aws::S3::ClientApi::ObjectNotInActiveTierError = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#402
Aws::S3::ClientApi::ObjectOwnership = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#403
Aws::S3::ClientApi::ObjectPart = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#404
Aws::S3::ClientApi::ObjectSize = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#405
Aws::S3::ClientApi::ObjectSizeGreaterThanBytes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#406
Aws::S3::ClientApi::ObjectSizeLessThanBytes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#407
Aws::S3::ClientApi::ObjectStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#408
Aws::S3::ClientApi::ObjectVersion = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#409
Aws::S3::ClientApi::ObjectVersionId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#410
Aws::S3::ClientApi::ObjectVersionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#411
Aws::S3::ClientApi::ObjectVersionStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#412
Aws::S3::ClientApi::OutputLocation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#413
Aws::S3::ClientApi::OutputSerialization = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#414
Aws::S3::ClientApi::Owner = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#415
Aws::S3::ClientApi::OwnerOverride = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#416
Aws::S3::ClientApi::OwnershipControls = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#417
Aws::S3::ClientApi::OwnershipControlsRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#418
Aws::S3::ClientApi::OwnershipControlsRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#419
Aws::S3::ClientApi::ParquetInput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#420
Aws::S3::ClientApi::Part = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#421
Aws::S3::ClientApi::PartNumber = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#422
Aws::S3::ClientApi::PartNumberMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#423
Aws::S3::ClientApi::Parts = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#424
Aws::S3::ClientApi::PartsCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#425
Aws::S3::ClientApi::PartsList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#426
Aws::S3::ClientApi::Payer = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#427
Aws::S3::ClientApi::Permission = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#428
Aws::S3::ClientApi::Policy = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#429
Aws::S3::ClientApi::PolicyStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#430
Aws::S3::ClientApi::Prefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#431
Aws::S3::ClientApi::Priority = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#432
Aws::S3::ClientApi::Progress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#433
Aws::S3::ClientApi::ProgressEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#434
Aws::S3::ClientApi::Protocol = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#435
Aws::S3::ClientApi::PublicAccessBlockConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#436
Aws::S3::ClientApi::PutBucketAccelerateConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#437
Aws::S3::ClientApi::PutBucketAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#438
Aws::S3::ClientApi::PutBucketAnalyticsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#439
Aws::S3::ClientApi::PutBucketCorsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#440
Aws::S3::ClientApi::PutBucketEncryptionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#441
Aws::S3::ClientApi::PutBucketIntelligentTieringConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#442
Aws::S3::ClientApi::PutBucketInventoryConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#443
Aws::S3::ClientApi::PutBucketLifecycleConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#444
Aws::S3::ClientApi::PutBucketLifecycleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#445
Aws::S3::ClientApi::PutBucketLoggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#446
Aws::S3::ClientApi::PutBucketMetricsConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#447
Aws::S3::ClientApi::PutBucketNotificationConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#448
Aws::S3::ClientApi::PutBucketNotificationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#449
Aws::S3::ClientApi::PutBucketOwnershipControlsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#450
Aws::S3::ClientApi::PutBucketPolicyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#451
Aws::S3::ClientApi::PutBucketReplicationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#452
Aws::S3::ClientApi::PutBucketRequestPaymentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#453
Aws::S3::ClientApi::PutBucketTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#454
Aws::S3::ClientApi::PutBucketVersioningRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#455
Aws::S3::ClientApi::PutBucketWebsiteRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#456
Aws::S3::ClientApi::PutObjectAclOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#457
Aws::S3::ClientApi::PutObjectAclRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#458
Aws::S3::ClientApi::PutObjectLegalHoldOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#459
Aws::S3::ClientApi::PutObjectLegalHoldRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#460
Aws::S3::ClientApi::PutObjectLockConfigurationOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#461
Aws::S3::ClientApi::PutObjectLockConfigurationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#462
Aws::S3::ClientApi::PutObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#463
Aws::S3::ClientApi::PutObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#464
Aws::S3::ClientApi::PutObjectRetentionOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#465
Aws::S3::ClientApi::PutObjectRetentionRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#466
Aws::S3::ClientApi::PutObjectTaggingOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#467
Aws::S3::ClientApi::PutObjectTaggingRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#468
Aws::S3::ClientApi::PutPublicAccessBlockRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#469
Aws::S3::ClientApi::QueueArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#470
Aws::S3::ClientApi::QueueConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#471
Aws::S3::ClientApi::QueueConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#472
Aws::S3::ClientApi::QueueConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#473
Aws::S3::ClientApi::Quiet = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#474
Aws::S3::ClientApi::QuoteCharacter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#475
Aws::S3::ClientApi::QuoteEscapeCharacter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#476
Aws::S3::ClientApi::QuoteFields = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#477
Aws::S3::ClientApi::Range = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#478
Aws::S3::ClientApi::RecordDelimiter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#479
Aws::S3::ClientApi::RecordsEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#480
Aws::S3::ClientApi::Redirect = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#481
Aws::S3::ClientApi::RedirectAllRequestsTo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#482
Aws::S3::ClientApi::ReplaceKeyPrefixWith = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#483
Aws::S3::ClientApi::ReplaceKeyWith = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#484
Aws::S3::ClientApi::ReplicaKmsKeyID = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#485
Aws::S3::ClientApi::ReplicaModifications = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#486
Aws::S3::ClientApi::ReplicaModificationsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#487
Aws::S3::ClientApi::ReplicationConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#488
Aws::S3::ClientApi::ReplicationRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#489
Aws::S3::ClientApi::ReplicationRuleAndOperator = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#490
Aws::S3::ClientApi::ReplicationRuleFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#491
Aws::S3::ClientApi::ReplicationRuleStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#492
Aws::S3::ClientApi::ReplicationRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#493
Aws::S3::ClientApi::ReplicationStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#494
Aws::S3::ClientApi::ReplicationTime = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#495
Aws::S3::ClientApi::ReplicationTimeStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#496
Aws::S3::ClientApi::ReplicationTimeValue = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#497
Aws::S3::ClientApi::RequestCharged = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#498
Aws::S3::ClientApi::RequestPayer = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#499
Aws::S3::ClientApi::RequestPaymentConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#500
Aws::S3::ClientApi::RequestProgress = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#501
Aws::S3::ClientApi::RequestRoute = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#502
Aws::S3::ClientApi::RequestToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#503
Aws::S3::ClientApi::ResponseCacheControl = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#504
Aws::S3::ClientApi::ResponseContentDisposition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#505
Aws::S3::ClientApi::ResponseContentEncoding = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#506
Aws::S3::ClientApi::ResponseContentLanguage = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#507
Aws::S3::ClientApi::ResponseContentType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#508
Aws::S3::ClientApi::ResponseExpires = T.let(T.unsafe(nil), Seahorse::Model::Shapes::TimestampShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#509
Aws::S3::ClientApi::Restore = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#510
Aws::S3::ClientApi::RestoreObjectOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#511
Aws::S3::ClientApi::RestoreObjectRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#512
Aws::S3::ClientApi::RestoreOutputPath = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#513
Aws::S3::ClientApi::RestoreRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#514
Aws::S3::ClientApi::RestoreRequestType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#515
Aws::S3::ClientApi::Role = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#516
Aws::S3::ClientApi::RoutingRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#517
Aws::S3::ClientApi::RoutingRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#518
Aws::S3::ClientApi::Rule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#519
Aws::S3::ClientApi::Rules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#520
Aws::S3::ClientApi::S3KeyFilter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#521
Aws::S3::ClientApi::S3Location = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#522
Aws::S3::ClientApi::SSECustomerAlgorithm = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#523
Aws::S3::ClientApi::SSECustomerKey = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#524
Aws::S3::ClientApi::SSECustomerKeyMD5 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#525
Aws::S3::ClientApi::SSEKMS = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#526
Aws::S3::ClientApi::SSEKMSEncryptionContext = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#527
Aws::S3::ClientApi::SSEKMSKeyId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#528
Aws::S3::ClientApi::SSES3 = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#529
Aws::S3::ClientApi::ScanRange = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#530
Aws::S3::ClientApi::SelectObjectContentEventStream = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#531
Aws::S3::ClientApi::SelectObjectContentOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#532
Aws::S3::ClientApi::SelectObjectContentRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#533
Aws::S3::ClientApi::SelectParameters = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#534
Aws::S3::ClientApi::ServerSideEncryption = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#535
Aws::S3::ClientApi::ServerSideEncryptionByDefault = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#536
Aws::S3::ClientApi::ServerSideEncryptionConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#537
Aws::S3::ClientApi::ServerSideEncryptionRule = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#538
Aws::S3::ClientApi::ServerSideEncryptionRules = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#539
Aws::S3::ClientApi::Setting = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#540
Aws::S3::ClientApi::Size = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#541
Aws::S3::ClientApi::SkipValidation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::BooleanShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#542
Aws::S3::ClientApi::SourceSelectionCriteria = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#543
Aws::S3::ClientApi::SseKmsEncryptedObjects = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#544
Aws::S3::ClientApi::SseKmsEncryptedObjectsStatus = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#545
Aws::S3::ClientApi::Start = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#546
Aws::S3::ClientApi::StartAfter = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#547
Aws::S3::ClientApi::Stats = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#548
Aws::S3::ClientApi::StatsEvent = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#549
Aws::S3::ClientApi::StorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#550
Aws::S3::ClientApi::StorageClassAnalysis = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#551
Aws::S3::ClientApi::StorageClassAnalysisDataExport = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#552
Aws::S3::ClientApi::StorageClassAnalysisSchemaVersion = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#553
Aws::S3::ClientApi::Suffix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#554
Aws::S3::ClientApi::Tag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#555
Aws::S3::ClientApi::TagCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#556
Aws::S3::ClientApi::TagSet = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#557
Aws::S3::ClientApi::Tagging = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#558
Aws::S3::ClientApi::TaggingDirective = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#559
Aws::S3::ClientApi::TaggingHeader = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#560
Aws::S3::ClientApi::TargetBucket = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#561
Aws::S3::ClientApi::TargetGrant = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#562
Aws::S3::ClientApi::TargetGrants = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#563
Aws::S3::ClientApi::TargetPrefix = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#564
Aws::S3::ClientApi::Tier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#565
Aws::S3::ClientApi::Tiering = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#566
Aws::S3::ClientApi::TieringList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#567
Aws::S3::ClientApi::Token = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#568
Aws::S3::ClientApi::TopicArn = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#569
Aws::S3::ClientApi::TopicConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#570
Aws::S3::ClientApi::TopicConfigurationDeprecated = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#571
Aws::S3::ClientApi::TopicConfigurationList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#572
Aws::S3::ClientApi::Transition = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#573
Aws::S3::ClientApi::TransitionList = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#574
Aws::S3::ClientApi::TransitionStorageClass = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#575
Aws::S3::ClientApi::Type = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#576
Aws::S3::ClientApi::URI = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#577
Aws::S3::ClientApi::UploadIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#578
Aws::S3::ClientApi::UploadPartCopyOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#579
Aws::S3::ClientApi::UploadPartCopyRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#580
Aws::S3::ClientApi::UploadPartOutput = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#581
Aws::S3::ClientApi::UploadPartRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#582
Aws::S3::ClientApi::UserMetadata = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#583
Aws::S3::ClientApi::Value = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#584
Aws::S3::ClientApi::VersionCount = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#585
Aws::S3::ClientApi::VersionIdMarker = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#586
Aws::S3::ClientApi::VersioningConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#587
Aws::S3::ClientApi::WebsiteConfiguration = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#588
Aws::S3::ClientApi::WebsiteRedirectLocation = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#589
Aws::S3::ClientApi::WriteGetObjectResponseRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/client_api.rb#590
Aws::S3::ClientApi::Years = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption.rb#21
Aws::S3::EC_USER_AGENT = T.let(T.unsafe(nil), String)

module Aws::S3::Encryption; end

class Aws::S3::Encryption::Client
  extend ::Aws::Deprecations
  extend ::Forwardable

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def initialize(*args, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def build_request(*args, **_arg1, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#245
  def client; end

  # source://forwardable/1.3.2/forwardable.rb#229
  def config(*args, **_arg1, &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def delete_object(*args, **_arg1, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#252
  def envelope_location; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#289
  def get_object(params = T.unsafe(nil), &block); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def head_object(*args, **_arg1, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#257
  def instruction_file_suffix; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#249
  def key_provider; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#265
  def put_object(params = T.unsafe(nil)); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#328
  def cipher_provider(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#230
  def deprecated_initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#352
  def envelope_options(params); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#306
  def extract_client(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#341
  def extract_key_provider(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#362
  def extract_location(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#373
  def extract_suffix(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryption/client.rb#319
  def kms_client(options); end
end

module Aws::S3::Encryption::Errors; end
class Aws::S3::Encryption::Errors::DecryptionError < ::RuntimeError; end
class Aws::S3::Encryption::Errors::EncryptionError < ::RuntimeError; end

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3.rb#76
Aws::S3::GEM_VERSION = T.let(T.unsafe(nil), String)

class Aws::S3::MultipartUpload
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#26
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#247
  def abort(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#367
  def basic_complete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#39
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#92
  def checksum_algorithm; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#99
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/multipart_upload.rb#27
  def complete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#114
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#122
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#484
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#49
  def id; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#67
  def initiated; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#86
  def initiator; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#61
  def key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#105
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#384
  def object; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#44
  def object_key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#80
  def owner; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#394
  def part(part_number); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#456
  def parts(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#105
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#73
  def storage_class; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#55
  def upload_id; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#206
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/multipart_upload.rb#36
  def compute_parts; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#495
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#517
  def extract_id(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload.rb#506
  def extract_object_key(args, options); end
end

class Aws::S3::MultipartUpload::Collection < ::Aws::Resources::Collection; end

class Aws::S3::MultipartUploadPart
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#28
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#42
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#89
  def checksum_crc32; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#103
  def checksum_crc32c; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#117
  def checksum_sha1; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#131
  def checksum_sha256; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#138
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#391
  def copy_from(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#153
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#161
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#542
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#69
  def etag; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#63
  def last_modified; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#144
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#531
  def multipart_upload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#52
  def multipart_upload_id; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#47
  def object_key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#57
  def part_number; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#144
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#75
  def size; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#517
  def upload(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#245
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#554
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#576
  def extract_multipart_upload_id(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#565
  def extract_object_key(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/multipart_upload_part.rb#587
  def extract_part_number(args, options); end
end

class Aws::S3::MultipartUploadPart::Collection < ::Aws::Resources::Collection; end

class Aws::S3::Object
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#24
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#55
  def accept_ranges; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1696
  def acl; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#96
  def archive_status; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1705
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#286
  def bucket_key_enabled; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#36
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#193
  def cache_control; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#122
  def checksum_crc32; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#136
  def checksum_crc32c; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#150
  def checksum_sha1; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#164
  def checksum_sha256; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#402
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#199
  def content_disposition; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#207
  def content_encoding; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#213
  def content_language; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#108
  def content_length; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#219
  def content_type; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#67
  def copy_from(source, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#108
  def copy_to(target, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#425
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#433
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#882
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#49
  def delete_marker; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1736
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#478
  def download_file(destination, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#171
  def etag; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#440
  def exists?(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#64
  def expiration; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#225
  def expires; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#230
  def expires_string; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#989
  def get(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1684
  def head(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1159
  def initiate_multipart_upload(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#41
  def key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#102
  def last_modified; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#412
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#254
  def metadata; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#181
  def missing_meta; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#120
  def move_to(target, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1714
  def multipart_upload(id); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#395
  def object_lock_legal_hold_status; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#373
  def object_lock_mode; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#381
  def object_lock_retain_until_date; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#360
  def parts_count; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#134
  def presigned_post(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#278
  def presigned_request(method, params = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#205
  def presigned_url(method, params = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#313
  def public_url(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1467
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#412
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#352
  def replication_status; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#307
  def request_charged; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#90
  def restore; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1600
  def restore_object(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#248
  def server_side_encryption; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#108
  def size; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#262
  def sse_customer_algorithm; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#271
  def sse_customer_key_md5; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#279
  def ssekms_key_id; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#300
  def storage_class; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#434
  def upload_file(source, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object.rb#363
  def upload_stream(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1725
  def version(id); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#187
  def version_id; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#569
  def wait_until(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#457
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#476
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#238
  def website_redirect_location; end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1746
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1757
  def extract_key(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1778
  def separate_params_and_options(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1768
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::Object::Collection < ::Aws::Resources::Collection
  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1851
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object.rb#1851
  def deprecated_delete(options = T.unsafe(nil)); end
end

class Aws::S3::ObjectAcl
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#24
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#36
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#67
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#90
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#98
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#334
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#53
  def grants; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#77
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#324
  def object; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#41
  def object_key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#47
  def owner; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#312
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#77
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#60
  def request_charged; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#182
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#344
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_acl.rb#355
  def extract_object_key(args, options); end
end

class Aws::S3::ObjectAcl::Collection < ::Aws::Resources::Collection; end

class Aws::S3::ObjectSummary
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#24
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1306
  def acl; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1315
  def bucket; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#36
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#79
  def checksum_algorithm; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#104
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#85
  def content_length; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#16
  def copy_from(source, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#24
  def copy_to(target, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#119
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#127
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#576
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1355
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#79
  def download_file(destination, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#73
  def etag; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#134
  def exists?(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#683
  def get(options = T.unsafe(nil), &block); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#853
  def initiate_multipart_upload(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#41
  def key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#47
  def last_modified; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#110
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#32
  def move_to(target, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1324
  def multipart_upload(id); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1334
  def object; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#97
  def owner; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#40
  def presigned_post(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#48
  def presigned_url(http_method, params = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#56
  def public_url(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1161
  def put(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#110
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1294
  def restore_object(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#85
  def size; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#91
  def storage_class; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#64
  def upload_file(source, options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/customizations/object_summary.rb#71
  def upload_stream(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1344
  def version(id); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#263
  def wait_until(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#151
  def wait_until_exists(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#170
  def wait_until_not_exists(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1365
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1376
  def extract_key(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1397
  def separate_params_and_options(options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1387
  def yield_waiter_and_warn(waiter, &block); end
end

class Aws::S3::ObjectSummary::Collection < ::Aws::Resources::Collection
  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1470
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_summary.rb#1470
  def deprecated_delete(options = T.unsafe(nil)); end
end

class Aws::S3::ObjectVersion
  extend ::Aws::Deprecations

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#26
  def initialize(*args); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#39
  def bucket_name; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#61
  def checksum_algorithm; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#111
  def client; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#126
  def data; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#134
  def data_loaded?; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#270
  def delete(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#480
  def deprecated_identifiers; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#55
  def etag; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#375
  def get(options = T.unsafe(nil), &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#457
  def head(options = T.unsafe(nil)); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#49
  def id; end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def identifiers(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#92
  def is_latest; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#79
  def key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#98
  def last_modified; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#117
  def load; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#470
  def object; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#44
  def object_key; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#104
  def owner; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#117
  def reload; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#67
  def size; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#73
  def storage_class; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#85
  def version_id; end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#218
  def wait_until(options = T.unsafe(nil), &block); end

  private

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#491
  def extract_bucket_name(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#513
  def extract_id(args, options); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#502
  def extract_object_key(args, options); end
end

class Aws::S3::ObjectVersion::Collection < ::Aws::Resources::Collection
  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#580
  def batch_delete!(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/deprecations.rb#65
  def delete(*args, &block); end

  # source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/object_version.rb#580
  def deprecated_delete(options = T.unsafe(nil)); end
end

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryptionV2/client.rb#8
Aws::S3::REQUIRED_PARAMS = T.let(T.unsafe(nil), Array)

# source://aws-sdk-s3/1.117.2/lib/aws-sdk-s3/encryptionV2/client.rb#9
Aws::S3::SUPPORTED_SECURITY_PROFILES = T.let(T.unsafe(nil), Array)

# This module provides support for AWS Single Sign-On. This module is available in the
# `aws-sdk-core` gem.
#
# # Client
#
# The {Client} class provides one method for each API operation. Operation
# methods each accept a hash of request parameters and return a response
# structure.
#
#     sso = Aws::SSO::Client.new
#     resp = sso.get_role_credentials(params)
#
# See {Client} for more information.
#
# # Errors
#
# Errors returned from AWS Single Sign-On are defined in the
# {Errors} module and all extend {Errors::ServiceError}.
#
#     begin
#       # do stuff
#     rescue Aws::SSO::Errors::ServiceError
#       # rescues all AWS Single Sign-On API errors
#     end
#
# See {Errors} for more information.
module Aws::SSO; end

# An API client for SSO.  To construct a client, you need to configure a `:region` and `:credentials`.
#
#     client = Aws::SSO::Client.new(
#       region: region_name,
#       credentials: credentials,
#       # ...
#     )
#
# For details on configuring region and credentials see
# the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
#
# See {#initialize} for a full list of supported configuration options.
class Aws::SSO::Client < ::Seahorse::Client::Base
  include ::Aws::ClientStubs

  # @overload initialize
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#365
  def initialize(*args); end

  # @api private
  # @param params [{}]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#579
  def build_request(operation_name, params = T.unsafe(nil)); end

  # Returns the STS short-term credentials for a given role name that is
  # assigned to the user.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_role_credentials({
  #   role_name: "RoleNameType", # required
  #   account_id: "AccountIdType", # required
  #   access_token: "AccessTokenType", # required
  #   })
  # @example Response structure
  #
  #   resp.role_credentials.access_key_id #=> String
  #   resp.role_credentials.secret_access_key #=> String
  #   resp.role_credentials.session_token #=> String
  #   resp.role_credentials.expiration #=> Integer
  # @option params
  # @option params
  # @option params
  # @overload get_role_credentials
  # @param params [Hash] ({})
  # @return [Types::GetRoleCredentialsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetRoleCredentialsResponse#role_credentials #role_credentials} => Types::RoleCredentials
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/GetRoleCredentials AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#412
  def get_role_credentials(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists all roles that are assigned to the user for a given AWS account.
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_account_roles({
  #   next_token: "NextTokenType",
  #   max_results: 1,
  #   access_token: "AccessTokenType", # required
  #   account_id: "AccountIdType", # required
  #   })
  # @example Response structure
  #
  #   resp.next_token #=> String
  #   resp.role_list #=> Array
  #   resp.role_list[0].role_name #=> String
  #   resp.role_list[0].account_id #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload list_account_roles
  # @param params [Hash] ({})
  # @return [Types::ListAccountRolesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListAccountRolesResponse#next_token #next_token} => String
  #   * {Types::ListAccountRolesResponse#role_list #role_list} => Array&lt;Types::RoleInfo&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccountRoles AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#465
  def list_account_roles(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lists all AWS accounts assigned to the user. These AWS accounts are
  # assigned by the administrator of the account. For more information,
  # see [Assign User Access][1] in the *IAM Identity Center User Guide*.
  # This operation returns a paginated response.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/singlesignon/latest/userguide/useraccess.html#assignusers
  #
  # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.list_accounts({
  #   next_token: "NextTokenType",
  #   max_results: 1,
  #   access_token: "AccessTokenType", # required
  #   })
  # @example Response structure
  #
  #   resp.next_token #=> String
  #   resp.account_list #=> Array
  #   resp.account_list[0].account_id #=> String
  #   resp.account_list[0].account_name #=> String
  #   resp.account_list[0].email_address #=> String
  # @option params
  # @option params
  # @option params
  # @overload list_accounts
  # @param params [Hash] ({})
  # @return [Types::ListAccountsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::ListAccountsResponse#next_token #next_token} => String
  #   * {Types::ListAccountsResponse#account_list #account_list} => Array&lt;Types::AccountInfo&gt;
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccounts AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#522
  def list_accounts(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Removes the locally stored SSO tokens from the client-side cache and
  # sends an API call to the IAM Identity Center service to invalidate the
  # corresponding server-side IAM Identity Center sign in session.
  #
  # <note markdown="1"> If a user uses IAM Identity Center to access the AWS CLI, the user’s
  # IAM Identity Center sign in session is used to obtain an IAM session,
  # as specified in the corresponding IAM Identity Center permission set.
  # More specifically, IAM Identity Center assumes an IAM role in the
  # target account on behalf of the user, and the corresponding temporary
  # AWS credentials are returned to the client.
  #
  #  After user logout, any existing IAM role sessions that were created by
  # using IAM Identity Center permission sets continue based on the
  # duration configured in the permission set. For more information, see
  # [User authentications][1] in the *IAM Identity Center User Guide*.
  #
  #  </note>
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/singlesignon/latest/userguide/authconcept.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.logout({
  #   access_token: "AccessTokenType", # required
  #   })
  # @option params
  # @overload logout
  # @param params [Hash] ({})
  # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/Logout AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#570
  def logout(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#594
  def waiter_names; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#604
    def errors_module; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-sso/client.rb#601
    def identifier; end
  end
end

# @api private
module Aws::SSO::ClientApi
  include ::Seahorse::Model
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#108
Aws::SSO::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#16
Aws::SSO::ClientApi::AccessKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#17
Aws::SSO::ClientApi::AccessTokenType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#18
Aws::SSO::ClientApi::AccountIdType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#19
Aws::SSO::ClientApi::AccountInfo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#20
Aws::SSO::ClientApi::AccountListType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#21
Aws::SSO::ClientApi::AccountNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#22
Aws::SSO::ClientApi::EmailAddressType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#23
Aws::SSO::ClientApi::ErrorDescription = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#24
Aws::SSO::ClientApi::ExpirationTimestampType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#25
Aws::SSO::ClientApi::GetRoleCredentialsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#26
Aws::SSO::ClientApi::GetRoleCredentialsResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#27
Aws::SSO::ClientApi::InvalidRequestException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#28
Aws::SSO::ClientApi::ListAccountRolesRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#29
Aws::SSO::ClientApi::ListAccountRolesResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#30
Aws::SSO::ClientApi::ListAccountsRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#31
Aws::SSO::ClientApi::ListAccountsResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#32
Aws::SSO::ClientApi::LogoutRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#33
Aws::SSO::ClientApi::MaxResultType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#34
Aws::SSO::ClientApi::NextTokenType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#35
Aws::SSO::ClientApi::ResourceNotFoundException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#36
Aws::SSO::ClientApi::RoleCredentials = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#37
Aws::SSO::ClientApi::RoleInfo = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#38
Aws::SSO::ClientApi::RoleListType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#39
Aws::SSO::ClientApi::RoleNameType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#40
Aws::SSO::ClientApi::SecretAccessKeyType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#41
Aws::SSO::ClientApi::SessionTokenType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#42
Aws::SSO::ClientApi::TooManyRequestsException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/client_api.rb#43
Aws::SSO::ClientApi::UnauthorizedException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# Endpoint parameters used to influence endpoints per request.
class Aws::SSO::EndpointParameters < ::Struct
  include ::Aws::Structure

  # @return [EndpointParameters] a new instance of EndpointParameters
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/endpoint_parameters.rb#51
  def initialize(options = T.unsafe(nil)); end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint; end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint=(_); end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region; end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region=(_); end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack; end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack=(_); end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips; end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Aws::SSO::EndpointProvider
  # @return [EndpointProvider] a new instance of EndpointProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/endpoint_provider.rb#12
  def initialize(rule_set = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-sso/endpoint_provider.rb#25
  def resolve_endpoint(parameters); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sso/endpoint_provider.rb#30
Aws::SSO::EndpointProvider::RULES = T.let(T.unsafe(nil), String)

module Aws::SSO::Endpoints; end

class Aws::SSO::Endpoints::GetRoleCredentials
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sso/endpoints.rb#15
    def build(context); end
  end
end

class Aws::SSO::Endpoints::ListAccountRoles
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sso/endpoints.rb#29
    def build(context); end
  end
end

class Aws::SSO::Endpoints::ListAccounts
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sso/endpoints.rb#43
    def build(context); end
  end
end

class Aws::SSO::Endpoints::Logout
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sso/endpoints.rb#57
    def build(context); end
  end
end

# When SSO returns an error response, the Ruby SDK constructs and raises an error.
# These errors all extend Aws::SSO::Errors::ServiceError < {Aws::Errors::ServiceError}
#
# You can rescue all SSO errors using ServiceError:
#
#     begin
#       # do stuff
#     rescue Aws::SSO::Errors::ServiceError
#       # rescues all SSO API errors
#     end
#
#
# ## Request Context
# ServiceError objects have a {Aws::Errors::ServiceError#context #context} method that returns
# information about the request that generated the error.
# See {Seahorse::Client::RequestContext} for more information.
#
# ## Error Classes
# * {InvalidRequestException}
# * {ResourceNotFoundException}
# * {TooManyRequestsException}
# * {UnauthorizedException}
#
# Additionally, error classes are dynamically generated for service errors based on the error code
# if they are not defined above.
module Aws::SSO::Errors
  extend ::Aws::Errors::DynamicErrors
end

class Aws::SSO::Errors::InvalidRequestException < ::Aws::SSO::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSO::Types::InvalidRequestException]
  # @return [InvalidRequestException] a new instance of InvalidRequestException
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#46
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#51
  def message; end
end

class Aws::SSO::Errors::ResourceNotFoundException < ::Aws::SSO::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSO::Types::ResourceNotFoundException]
  # @return [ResourceNotFoundException] a new instance of ResourceNotFoundException
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#61
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#66
  def message; end
end

class Aws::SSO::Errors::ServiceError < ::Aws::Errors::ServiceError; end

class Aws::SSO::Errors::TooManyRequestsException < ::Aws::SSO::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSO::Types::TooManyRequestsException]
  # @return [TooManyRequestsException] a new instance of TooManyRequestsException
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#76
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#81
  def message; end
end

class Aws::SSO::Errors::UnauthorizedException < ::Aws::SSO::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSO::Types::UnauthorizedException]
  # @return [UnauthorizedException] a new instance of UnauthorizedException
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#91
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/errors.rb#96
  def message; end
end

# source://aws-sdk-core//lib/aws-sdk-sso.rb#57
Aws::SSO::GEM_VERSION = T.let(T.unsafe(nil), String)

module Aws::SSO::Plugins; end

class Aws::SSO::Plugins::Endpoints < ::Seahorse::Client::Plugin
  # source://aws-sdk-core//lib/aws-sdk-sso/plugins/endpoints.rb#71
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::SSO::Plugins::Endpoints::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/plugins/endpoints.rb#27
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/plugins/endpoints.rb#46
  def apply_endpoint_headers(context, headers); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/plugins/endpoints.rb#57
  def parameters_for_operation(context); end
end

class Aws::SSO::Resource
  # @option options
  # @param options [{}]
  # @return [Resource] a new instance of Resource
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/resource.rb#16
  def initialize(options = T.unsafe(nil)); end

  # @return [Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-sso/resource.rb#21
  def client; end
end

module Aws::SSO::Types; end

# Provides information about your AWS account.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/AccountInfo AWS API Documentation
class Aws::SSO::Types::AccountInfo < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#33
Aws::SSO::Types::AccountInfo::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/GetRoleCredentialsRequest AWS API Documentation
class Aws::SSO::Types::GetRoleCredentialsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#61
Aws::SSO::Types::GetRoleCredentialsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/GetRoleCredentialsResponse AWS API Documentation
class Aws::SSO::Types::GetRoleCredentialsResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#73
Aws::SSO::Types::GetRoleCredentialsResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that a problem occurred with the input to the request. For
# example, a required parameter might be missing or out of range.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/InvalidRequestException AWS API Documentation
class Aws::SSO::Types::InvalidRequestException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#87
Aws::SSO::Types::InvalidRequestException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccountRolesRequest AWS API Documentation
class Aws::SSO::Types::ListAccountRolesRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#121
Aws::SSO::Types::ListAccountRolesRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccountRolesResponse AWS API Documentation
class Aws::SSO::Types::ListAccountRolesResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#139
Aws::SSO::Types::ListAccountRolesResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccountsRequest AWS API Documentation
class Aws::SSO::Types::ListAccountsRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#168
Aws::SSO::Types::ListAccountsRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ListAccountsResponse AWS API Documentation
class Aws::SSO::Types::ListAccountsResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#186
Aws::SSO::Types::ListAccountsResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/LogoutRequest AWS API Documentation
class Aws::SSO::Types::LogoutRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#204
Aws::SSO::Types::LogoutRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# The specified resource doesn't exist.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/ResourceNotFoundException AWS API Documentation
class Aws::SSO::Types::ResourceNotFoundException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#217
Aws::SSO::Types::ResourceNotFoundException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Provides information about the role credentials that are assigned to
# the user.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/RoleCredentials AWS API Documentation
class Aws::SSO::Types::RoleCredentials < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#265
Aws::SSO::Types::RoleCredentials::SENSITIVE = T.let(T.unsafe(nil), Array)

# Provides information about the role that is assigned to the user.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/RoleInfo AWS API Documentation
class Aws::SSO::Types::RoleInfo < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#284
Aws::SSO::Types::RoleInfo::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the request is being made too frequently and is more
# than what the server can handle.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/TooManyRequestsException AWS API Documentation
class Aws::SSO::Types::TooManyRequestsException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#298
Aws::SSO::Types::TooManyRequestsException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the request is not authorized. This can happen due to
# an invalid access token in the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/UnauthorizedException AWS API Documentation
class Aws::SSO::Types::UnauthorizedException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sso/types.rb#312
Aws::SSO::Types::UnauthorizedException::SENSITIVE = T.let(T.unsafe(nil), Array)

# An auto-refreshing credential provider that assumes a role via
# {Aws::SSO::Client#get_role_credentials} using a cached access
# token. When `sso_session` is specified, token refresh logic from
# {Aws::SSOTokenProvider} will be used to refresh the token if possible.
# This class does NOT implement the SSO login token flow - tokens
# must generated separately by running `aws login` from the
# AWS CLI with the correct profile. The `SSOCredentials` will
# auto-refresh the AWS credentials from SSO.
#
#     # You must first run aws sso login --profile your-sso-profile
#     sso_credentials = Aws::SSOCredentials.new(
#       sso_account_id: '123456789',
#       sso_role_name: "role_name",
#       sso_region: "us-east-1",
#       sso_session: 'my_sso_session'
#     )
#     ec2 = Aws::EC2::Client.new(credentials: sso_credentials)
#
# If you omit `:client` option, a new {Aws::SSO::Client} object will be
# constructed with additional options that were provided.
#
# @see Aws::SSO::Client#get_role_credentials
# @see https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html
class Aws::SSOCredentials
  include ::Aws::CredentialProvider
  include ::Aws::RefreshingCredentials

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [SSOCredentials] a new instance of SSOCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#69
  def initialize(options = T.unsafe(nil)); end

  # @return [SSO::Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#121
  def client; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#125
  def read_cached_token; end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#140
  def refresh; end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#164
  def sso_cache_file; end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#33
Aws::SSOCredentials::LEGACY_REQUIRED_OPTS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#37
Aws::SSOCredentials::SSO_LOGIN_GUIDANCE = T.let(T.unsafe(nil), String)

# source://aws-sdk-core//lib/aws-sdk-core/sso_credentials.rb#34
Aws::SSOCredentials::TOKEN_PROVIDER_REQUIRED_OPTS = T.let(T.unsafe(nil), Array)

# This module provides support for AWS SSO OIDC. This module is available in the
# `aws-sdk-core` gem.
#
# # Client
#
# The {Client} class provides one method for each API operation. Operation
# methods each accept a hash of request parameters and return a response
# structure.
#
#     ssooidc = Aws::SSOOIDC::Client.new
#     resp = ssooidc.create_token(params)
#
# See {Client} for more information.
#
# # Errors
#
# Errors returned from AWS SSO OIDC are defined in the
# {Errors} module and all extend {Errors::ServiceError}.
#
#     begin
#       # do stuff
#     rescue Aws::SSOOIDC::Errors::ServiceError
#       # rescues all AWS SSO OIDC API errors
#     end
#
# See {Errors} for more information.
module Aws::SSOOIDC; end

# An API client for SSOOIDC.  To construct a client, you need to configure a `:region` and `:credentials`.
#
#     client = Aws::SSOOIDC::Client.new(
#       region: region_name,
#       credentials: credentials,
#       # ...
#     )
#
# For details on configuring region and credentials see
# the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
#
# See {#initialize} for a full list of supported configuration options.
class Aws::SSOOIDC::Client < ::Seahorse::Client::Base
  include ::Aws::ClientStubs

  # @overload initialize
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#365
  def initialize(*args); end

  # @api private
  # @param params [{}]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#575
  def build_request(operation_name, params = T.unsafe(nil)); end

  # Creates and returns an access token for the authorized client. The
  # access token issued will be used to fetch short-term credentials for
  # the assigned roles in the AWS account.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.create_token({
  #   client_id: "ClientId", # required
  #   client_secret: "ClientSecret", # required
  #   grant_type: "GrantType", # required
  #   device_code: "DeviceCode",
  #   code: "AuthCode",
  #   refresh_token: "RefreshToken",
  #   scope: ["Scope"],
  #   redirect_uri: "URI",
  #   })
  # @example Response structure
  #
  #   resp.access_token #=> String
  #   resp.token_type #=> String
  #   resp.expires_in #=> Integer
  #   resp.refresh_token #=> String
  #   resp.id_token #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload create_token
  # @param params [Hash] ({})
  # @return [Types::CreateTokenResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::CreateTokenResponse#access_token #access_token} => String
  #   * {Types::CreateTokenResponse#token_type #token_type} => String
  #   * {Types::CreateTokenResponse#expires_in #expires_in} => Integer
  #   * {Types::CreateTokenResponse#refresh_token #refresh_token} => String
  #   * {Types::CreateTokenResponse#id_token #id_token} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/CreateToken AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#460
  def create_token(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Registers a client with IAM Identity Center. This allows clients to
  # initiate device authorization. The output should be persisted for
  # reuse through many authentication requests.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.register_client({
  #   client_name: "ClientName", # required
  #   client_type: "ClientType", # required
  #   scopes: ["Scope"],
  #   })
  # @example Response structure
  #
  #   resp.client_id #=> String
  #   resp.client_secret #=> String
  #   resp.client_id_issued_at #=> Integer
  #   resp.client_secret_expires_at #=> Integer
  #   resp.authorization_endpoint #=> String
  #   resp.token_endpoint #=> String
  # @option params
  # @option params
  # @option params
  # @overload register_client
  # @param params [Hash] ({})
  # @return [Types::RegisterClientResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::RegisterClientResponse#client_id #client_id} => String
  #   * {Types::RegisterClientResponse#client_secret #client_secret} => String
  #   * {Types::RegisterClientResponse#client_id_issued_at #client_id_issued_at} => Integer
  #   * {Types::RegisterClientResponse#client_secret_expires_at #client_secret_expires_at} => Integer
  #   * {Types::RegisterClientResponse#authorization_endpoint #authorization_endpoint} => String
  #   * {Types::RegisterClientResponse#token_endpoint #token_endpoint} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/RegisterClient AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#511
  def register_client(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Initiates device authorization by requesting a pair of verification
  # codes from the authorization service.
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.start_device_authorization({
  #   client_id: "ClientId", # required
  #   client_secret: "ClientSecret", # required
  #   start_url: "URI", # required
  #   })
  # @example Response structure
  #
  #   resp.device_code #=> String
  #   resp.user_code #=> String
  #   resp.verification_uri #=> String
  #   resp.verification_uri_complete #=> String
  #   resp.expires_in #=> Integer
  #   resp.interval #=> Integer
  # @option params
  # @option params
  # @option params
  # @overload start_device_authorization
  # @param params [Hash] ({})
  # @return [Types::StartDeviceAuthorizationResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::StartDeviceAuthorizationResponse#device_code #device_code} => String
  #   * {Types::StartDeviceAuthorizationResponse#user_code #user_code} => String
  #   * {Types::StartDeviceAuthorizationResponse#verification_uri #verification_uri} => String
  #   * {Types::StartDeviceAuthorizationResponse#verification_uri_complete #verification_uri_complete} => String
  #   * {Types::StartDeviceAuthorizationResponse#expires_in #expires_in} => Integer
  #   * {Types::StartDeviceAuthorizationResponse#interval #interval} => Integer
  # @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/StartDeviceAuthorization AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#566
  def start_device_authorization(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#590
  def waiter_names; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#600
    def errors_module; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-ssooidc/client.rb#597
    def identifier; end
  end
end

# @api private
module Aws::SSOOIDC::ClientApi
  include ::Seahorse::Model
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#150
Aws::SSOOIDC::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#16
Aws::SSOOIDC::ClientApi::AccessDeniedException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#17
Aws::SSOOIDC::ClientApi::AccessToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#18
Aws::SSOOIDC::ClientApi::AuthCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#19
Aws::SSOOIDC::ClientApi::AuthorizationPendingException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#20
Aws::SSOOIDC::ClientApi::ClientId = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#21
Aws::SSOOIDC::ClientApi::ClientName = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#22
Aws::SSOOIDC::ClientApi::ClientSecret = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#23
Aws::SSOOIDC::ClientApi::ClientType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#24
Aws::SSOOIDC::ClientApi::CreateTokenRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#25
Aws::SSOOIDC::ClientApi::CreateTokenResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#26
Aws::SSOOIDC::ClientApi::DeviceCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#27
Aws::SSOOIDC::ClientApi::Error = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#28
Aws::SSOOIDC::ClientApi::ErrorDescription = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#29
Aws::SSOOIDC::ClientApi::ExpirationInSeconds = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#30
Aws::SSOOIDC::ClientApi::ExpiredTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#31
Aws::SSOOIDC::ClientApi::GrantType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#32
Aws::SSOOIDC::ClientApi::IdToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#33
Aws::SSOOIDC::ClientApi::InternalServerException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#34
Aws::SSOOIDC::ClientApi::IntervalInSeconds = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#35
Aws::SSOOIDC::ClientApi::InvalidClientException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#36
Aws::SSOOIDC::ClientApi::InvalidClientMetadataException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#37
Aws::SSOOIDC::ClientApi::InvalidGrantException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#38
Aws::SSOOIDC::ClientApi::InvalidRequestException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#39
Aws::SSOOIDC::ClientApi::InvalidScopeException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#40
Aws::SSOOIDC::ClientApi::LongTimeStampType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::IntegerShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#41
Aws::SSOOIDC::ClientApi::RefreshToken = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#42
Aws::SSOOIDC::ClientApi::RegisterClientRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#43
Aws::SSOOIDC::ClientApi::RegisterClientResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#44
Aws::SSOOIDC::ClientApi::Scope = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#45
Aws::SSOOIDC::ClientApi::Scopes = T.let(T.unsafe(nil), Seahorse::Model::Shapes::ListShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#46
Aws::SSOOIDC::ClientApi::SlowDownException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#47
Aws::SSOOIDC::ClientApi::StartDeviceAuthorizationRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#48
Aws::SSOOIDC::ClientApi::StartDeviceAuthorizationResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#49
Aws::SSOOIDC::ClientApi::TokenType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#50
Aws::SSOOIDC::ClientApi::URI = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#51
Aws::SSOOIDC::ClientApi::UnauthorizedClientException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#52
Aws::SSOOIDC::ClientApi::UnsupportedGrantTypeException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/client_api.rb#53
Aws::SSOOIDC::ClientApi::UserCode = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# Endpoint parameters used to influence endpoints per request.
class Aws::SSOOIDC::EndpointParameters < ::Struct
  include ::Aws::Structure

  # @return [EndpointParameters] a new instance of EndpointParameters
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoint_parameters.rb#51
  def initialize(options = T.unsafe(nil)); end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint; end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint=(_); end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region; end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region=(_); end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack; end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack=(_); end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips; end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Aws::SSOOIDC::EndpointProvider
  # @return [EndpointProvider] a new instance of EndpointProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoint_provider.rb#12
  def initialize(rule_set = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoint_provider.rb#25
  def resolve_endpoint(parameters); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoint_provider.rb#30
Aws::SSOOIDC::EndpointProvider::RULES = T.let(T.unsafe(nil), String)

module Aws::SSOOIDC::Endpoints; end

class Aws::SSOOIDC::Endpoints::CreateToken
  class << self
    # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoints.rb#15
    def build(context); end
  end
end

class Aws::SSOOIDC::Endpoints::RegisterClient
  class << self
    # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoints.rb#29
    def build(context); end
  end
end

class Aws::SSOOIDC::Endpoints::StartDeviceAuthorization
  class << self
    # source://aws-sdk-core//lib/aws-sdk-ssooidc/endpoints.rb#43
    def build(context); end
  end
end

# When SSOOIDC returns an error response, the Ruby SDK constructs and raises an error.
# These errors all extend Aws::SSOOIDC::Errors::ServiceError < {Aws::Errors::ServiceError}
#
# You can rescue all SSOOIDC errors using ServiceError:
#
#     begin
#       # do stuff
#     rescue Aws::SSOOIDC::Errors::ServiceError
#       # rescues all SSOOIDC API errors
#     end
#
#
# ## Request Context
# ServiceError objects have a {Aws::Errors::ServiceError#context #context} method that returns
# information about the request that generated the error.
# See {Seahorse::Client::RequestContext} for more information.
#
# ## Error Classes
# * {AccessDeniedException}
# * {AuthorizationPendingException}
# * {ExpiredTokenException}
# * {InternalServerException}
# * {InvalidClientException}
# * {InvalidClientMetadataException}
# * {InvalidGrantException}
# * {InvalidRequestException}
# * {InvalidScopeException}
# * {SlowDownException}
# * {UnauthorizedClientException}
# * {UnsupportedGrantTypeException}
#
# Additionally, error classes are dynamically generated for service errors based on the error code
# if they are not defined above.
module Aws::SSOOIDC::Errors
  extend ::Aws::Errors::DynamicErrors
end

class Aws::SSOOIDC::Errors::AccessDeniedException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::AccessDeniedException]
  # @return [AccessDeniedException] a new instance of AccessDeniedException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#54
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#59
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#64
  def error_description; end
end

class Aws::SSOOIDC::Errors::AuthorizationPendingException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::AuthorizationPendingException]
  # @return [AuthorizationPendingException] a new instance of AuthorizationPendingException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#74
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#79
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#84
  def error_description; end
end

class Aws::SSOOIDC::Errors::ExpiredTokenException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::ExpiredTokenException]
  # @return [ExpiredTokenException] a new instance of ExpiredTokenException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#94
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#99
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#104
  def error_description; end
end

class Aws::SSOOIDC::Errors::InternalServerException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InternalServerException]
  # @return [InternalServerException] a new instance of InternalServerException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#114
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#119
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#124
  def error_description; end
end

class Aws::SSOOIDC::Errors::InvalidClientException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InvalidClientException]
  # @return [InvalidClientException] a new instance of InvalidClientException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#134
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#139
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#144
  def error_description; end
end

class Aws::SSOOIDC::Errors::InvalidClientMetadataException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InvalidClientMetadataException]
  # @return [InvalidClientMetadataException] a new instance of InvalidClientMetadataException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#154
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#159
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#164
  def error_description; end
end

class Aws::SSOOIDC::Errors::InvalidGrantException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InvalidGrantException]
  # @return [InvalidGrantException] a new instance of InvalidGrantException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#174
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#179
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#184
  def error_description; end
end

class Aws::SSOOIDC::Errors::InvalidRequestException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InvalidRequestException]
  # @return [InvalidRequestException] a new instance of InvalidRequestException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#194
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#199
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#204
  def error_description; end
end

class Aws::SSOOIDC::Errors::InvalidScopeException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::InvalidScopeException]
  # @return [InvalidScopeException] a new instance of InvalidScopeException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#214
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#219
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#224
  def error_description; end
end

class Aws::SSOOIDC::Errors::ServiceError < ::Aws::Errors::ServiceError; end

class Aws::SSOOIDC::Errors::SlowDownException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::SlowDownException]
  # @return [SlowDownException] a new instance of SlowDownException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#234
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#239
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#244
  def error_description; end
end

class Aws::SSOOIDC::Errors::UnauthorizedClientException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::UnauthorizedClientException]
  # @return [UnauthorizedClientException] a new instance of UnauthorizedClientException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#254
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#259
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#264
  def error_description; end
end

class Aws::SSOOIDC::Errors::UnsupportedGrantTypeException < ::Aws::SSOOIDC::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::SSOOIDC::Types::UnsupportedGrantTypeException]
  # @return [UnsupportedGrantTypeException] a new instance of UnsupportedGrantTypeException
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#274
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#279
  def error; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/errors.rb#284
  def error_description; end
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc.rb#57
Aws::SSOOIDC::GEM_VERSION = T.let(T.unsafe(nil), String)

module Aws::SSOOIDC::Plugins; end

class Aws::SSOOIDC::Plugins::Endpoints < ::Seahorse::Client::Plugin
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/plugins/endpoints.rb#69
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::SSOOIDC::Plugins::Endpoints::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/plugins/endpoints.rb#27
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/plugins/endpoints.rb#46
  def apply_endpoint_headers(context, headers); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/plugins/endpoints.rb#57
  def parameters_for_operation(context); end
end

class Aws::SSOOIDC::Resource
  # @option options
  # @param options [{}]
  # @return [Resource] a new instance of Resource
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/resource.rb#16
  def initialize(options = T.unsafe(nil)); end

  # @return [Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-ssooidc/resource.rb#21
  def client; end
end

module Aws::SSOOIDC::Types; end

# You do not have sufficient access to perform this action.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/AccessDeniedException AWS API Documentation
class Aws::SSOOIDC::Types::AccessDeniedException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#26
Aws::SSOOIDC::Types::AccessDeniedException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that a request to authorize a client with an access user
# session token is pending.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/AuthorizationPendingException AWS API Documentation
class Aws::SSOOIDC::Types::AuthorizationPendingException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#44
Aws::SSOOIDC::Types::AuthorizationPendingException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/CreateTokenRequest AWS API Documentation
class Aws::SSOOIDC::Types::CreateTokenRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#120
Aws::SSOOIDC::Types::CreateTokenRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/CreateTokenResponse AWS API Documentation
class Aws::SSOOIDC::Types::CreateTokenResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#176
Aws::SSOOIDC::Types::CreateTokenResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the token issued by the service is expired and is no
# longer valid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/ExpiredTokenException AWS API Documentation
class Aws::SSOOIDC::Types::ExpiredTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#194
Aws::SSOOIDC::Types::ExpiredTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that an error from the service occurred while trying to
# process a request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InternalServerException AWS API Documentation
class Aws::SSOOIDC::Types::InternalServerException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#212
Aws::SSOOIDC::Types::InternalServerException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the `clientId` or `clientSecret` in the request is
# invalid. For example, this can occur when a client sends an incorrect
# `clientId` or an expired `clientSecret`.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InvalidClientException AWS API Documentation
class Aws::SSOOIDC::Types::InvalidClientException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#231
Aws::SSOOIDC::Types::InvalidClientException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the client information sent in the request during
# registration is invalid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InvalidClientMetadataException AWS API Documentation
class Aws::SSOOIDC::Types::InvalidClientMetadataException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#249
Aws::SSOOIDC::Types::InvalidClientMetadataException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that a request contains an invalid grant. This can occur if
# a client makes a CreateToken request with an invalid grant type.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InvalidGrantException AWS API Documentation
class Aws::SSOOIDC::Types::InvalidGrantException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#267
Aws::SSOOIDC::Types::InvalidGrantException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that something is wrong with the input to the request. For
# example, a required parameter might be missing or out of range.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InvalidRequestException AWS API Documentation
class Aws::SSOOIDC::Types::InvalidRequestException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#285
Aws::SSOOIDC::Types::InvalidRequestException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the scope provided in the request is invalid.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/InvalidScopeException AWS API Documentation
class Aws::SSOOIDC::Types::InvalidScopeException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#302
Aws::SSOOIDC::Types::InvalidScopeException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/RegisterClientRequest AWS API Documentation
class Aws::SSOOIDC::Types::RegisterClientRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#327
Aws::SSOOIDC::Types::RegisterClientRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/RegisterClientResponse AWS API Documentation
class Aws::SSOOIDC::Types::RegisterClientResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#368
Aws::SSOOIDC::Types::RegisterClientResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the client is making the request too frequently and is
# more than the service can handle.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/SlowDownException AWS API Documentation
class Aws::SSOOIDC::Types::SlowDownException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#386
Aws::SSOOIDC::Types::SlowDownException::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/StartDeviceAuthorizationRequest AWS API Documentation
class Aws::SSOOIDC::Types::StartDeviceAuthorizationRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#416
Aws::SSOOIDC::Types::StartDeviceAuthorizationRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/StartDeviceAuthorizationResponse AWS API Documentation
class Aws::SSOOIDC::Types::StartDeviceAuthorizationResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#460
Aws::SSOOIDC::Types::StartDeviceAuthorizationResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the client is not currently authorized to make the
# request. This can happen when a `clientId` is not issued for a public
# client.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/UnauthorizedClientException AWS API Documentation
class Aws::SSOOIDC::Types::UnauthorizedClientException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#479
Aws::SSOOIDC::Types::UnauthorizedClientException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Indicates that the grant type in the request is not supported by the
# service.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/UnsupportedGrantTypeException AWS API Documentation
class Aws::SSOOIDC::Types::UnsupportedGrantTypeException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-ssooidc/types.rb#497
Aws::SSOOIDC::Types::UnsupportedGrantTypeException::SENSITIVE = T.let(T.unsafe(nil), Array)

class Aws::SSOTokenProvider
  include ::Aws::TokenProvider
  include ::Aws::RefreshingToken

  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [SSOTokenProvider] a new instance of SSOTokenProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#30
  def initialize(options = T.unsafe(nil)); end

  # @return [SSOOIDC::Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#49
  def client; end

  private

  # return true if all required fields are present
  # return false if registrationExpiresAt exists and is later than now
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#123
  def can_refresh_token?(token_json); end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#95
  def read_cached_token; end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#53
  def refresh; end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#113
  def sso_cache_file; end

  # source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#107
  def update_token_cache(token_json); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#13
Aws::SSOTokenProvider::SSO_LOGIN_GUIDANCE = T.let(T.unsafe(nil), String)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/sso_token_provider.rb#10
Aws::SSOTokenProvider::SSO_REQUIRED_OPTS = T.let(T.unsafe(nil), Array)

# This module provides support for AWS Security Token Service. This module is available in the
# `aws-sdk-core` gem.
#
# # Client
#
# The {Client} class provides one method for each API operation. Operation
# methods each accept a hash of request parameters and return a response
# structure.
#
#     sts = Aws::STS::Client.new
#     resp = sts.assume_role(params)
#
# See {Client} for more information.
#
# # Errors
#
# Errors returned from AWS Security Token Service are defined in the
# {Errors} module and all extend {Errors::ServiceError}.
#
#     begin
#       # do stuff
#     rescue Aws::STS::Errors::ServiceError
#       # rescues all AWS Security Token Service API errors
#     end
#
# See {Errors} for more information.
module Aws::STS; end

# An API client for STS.  To construct a client, you need to configure a `:region` and `:credentials`.
#
#     client = Aws::STS::Client.new(
#       region: region_name,
#       credentials: credentials,
#       # ...
#     )
#
# For details on configuring region and credentials see
# the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
#
# See {#initialize} for a full list of supported configuration options.
class Aws::STS::Client < ::Seahorse::Client::Base
  include ::Aws::ClientStubs

  # @overload initialize
  # @return [Client] a new instance of Client
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#372
  def initialize(*args); end

  # Returns a set of temporary security credentials that you can use to
  # access Amazon Web Services resources that you might not normally have
  # access to. These temporary credentials consist of an access key ID, a
  # secret access key, and a security token. Typically, you use
  # `AssumeRole` within your account or for cross-account access. For a
  # comparison of `AssumeRole` with other API operations that produce
  # temporary credentials, see [Requesting Temporary Security
  # Credentials][1] and [Comparing the Amazon Web Services STS API
  # operations][2] in the *IAM User Guide*.
  #
  # **Permissions**
  #
  # The temporary security credentials created by `AssumeRole` can be used
  # to make API calls to any Amazon Web Services service with the
  # following exception: You cannot call the Amazon Web Services STS
  # `GetFederationToken` or `GetSessionToken` API operations.
  #
  # (Optional) You can pass inline or managed [session policies][3] to
  # this operation. You can pass a single JSON policy document to use as
  # an inline session policy. You can also specify up to 10 managed policy
  # Amazon Resource Names (ARNs) to use as managed session policies. The
  # plaintext that you use for both inline and managed session policies
  # can't exceed 2,048 characters. Passing policies to this operation
  # returns new temporary credentials. The resulting session's
  # permissions are the intersection of the role's identity-based policy
  # and the session policies. You can use the role's temporary
  # credentials in subsequent Amazon Web Services API calls to access
  # resources in the account that owns the role. You cannot use session
  # policies to grant more permissions than those allowed by the
  # identity-based policy of the role that is being assumed. For more
  # information, see [Session Policies][3] in the *IAM User Guide*.
  #
  # When you create a role, you create two policies: A role trust policy
  # that specifies *who* can assume the role and a permissions policy that
  # specifies *what* can be done with the role. You specify the trusted
  # principal who is allowed to assume the role in the role trust policy.
  #
  # To assume a role from a different account, your Amazon Web Services
  # account must be trusted by the role. The trust relationship is defined
  # in the role's trust policy when the role is created. That trust
  # policy states which accounts are allowed to delegate that access to
  # users in the account.
  #
  # A user who wants to access a role in a different account must also
  # have permissions that are delegated from the user account
  # administrator. The administrator must attach a policy that allows the
  # user to call `AssumeRole` for the ARN of the role in the other
  # account.
  #
  # To allow a user to assume a role in the same account, you can do
  # either of the following:
  #
  # * Attach a policy to the user that allows the user to call
  #   `AssumeRole` (as long as the role's trust policy trusts the
  #   account).
  #
  # * Add the user as a principal directly in the role's trust policy.
  #
  # You can do either because the role’s trust policy acts as an IAM
  # resource-based policy. When a resource-based policy grants access to a
  # principal in the same account, no additional identity-based policy is
  # required. For more information about trust policies and resource-based
  # policies, see [IAM Policies][4] in the *IAM User Guide*.
  #
  # **Tags**
  #
  # (Optional) You can pass tag key-value pairs to your session. These
  # tags are called session tags. For more information about session tags,
  # see [Passing Session Tags in STS][5] in the *IAM User Guide*.
  #
  # An administrator must grant you the permissions necessary to pass
  # session tags. The administrator can also create granular permissions
  # to allow you to pass only specific session tags. For more information,
  # see [Tutorial: Using Tags for Attribute-Based Access Control][6] in
  # the *IAM User Guide*.
  #
  # You can set the session tags as transitive. Transitive tags persist
  # during role chaining. For more information, see [Chaining Roles with
  # Session Tags][7] in the *IAM User Guide*.
  #
  # **Using MFA with AssumeRole**
  #
  # (Optional) You can include multi-factor authentication (MFA)
  # information when you call `AssumeRole`. This is useful for
  # cross-account scenarios to ensure that the user that assumes the role
  # has been authenticated with an Amazon Web Services MFA device. In that
  # scenario, the trust policy of the role being assumed includes a
  # condition that tests for MFA authentication. If the caller does not
  # include valid MFA information, the request to assume the role is
  # denied. The condition in a trust policy that tests for MFA
  # authentication might look like the following example.
  #
  # `"Condition": \{"Bool": \{"aws:MultiFactorAuthPresent": true\}\}`
  #
  # For more information, see [Configuring MFA-Protected API Access][8] in
  # the *IAM User Guide* guide.
  #
  # To use MFA with `AssumeRole`, you pass values for the `SerialNumber`
  # and `TokenCode` parameters. The `SerialNumber` value identifies the
  # user's hardware or virtual MFA device. The `TokenCode` is the
  # time-based one-time password (TOTP) that the MFA device produces.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison
  # [3]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session
  # [4]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html
  # [5]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
  # [6]: https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_attribute-based-access-control.html
  # [7]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_role-chaining
  # [8]: https://docs.aws.amazon.com/IAM/latest/UserGuide/MFAProtectedAPI.html
  #
  # @example Example: To assume a role
  #
  #   resp = client.assume_role({
  #   external_id: "123ABC",
  #   policy: "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":\"Allow\",\"Action\":\"s3:ListAllMyBuckets\",\"Resource\":\"*\"}]}",
  #   role_arn: "arn:aws:iam::123456789012:role/demo",
  #   role_session_name: "testAssumeRoleSession",
  #   tags: [
  #   {
  #   key: "Project",
  #   value: "Unicorn",
  #   },
  #   {
  #   key: "Team",
  #   value: "Automation",
  #   },
  #   {
  #   key: "Cost-Center",
  #   value: "12345",
  #   },
  #   ],
  #   transitive_tag_keys: [
  #   "Project",
  #   "Cost-Center",
  #   ],
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   assumed_role_user: {
  #   arn: "arn:aws:sts::123456789012:assumed-role/demo/Bob",
  #   assumed_role_id: "ARO123EXAMPLE123:Bob",
  #   },
  #   credentials: {
  #   access_key_id: "AKIAIOSFODNN7EXAMPLE",
  #   expiration: Time.parse("2011-07-15T23:28:33.359Z"),
  #   secret_access_key: "wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY",
  #   session_token: "AQoDYXdzEPT//////////wEXAMPLEtc764bNrC9SAPBSM22wDOk4x4HIZ8j4FZTwdQWLWsKWHGBuFqwAeMicRXmxfpSPfIeoIYRqTflfKD8YUuwthAx7mSEI/qkPpKPi/kMcGdQrmGdeehM4IC1NtBmUpp2wUE8phUZampKsburEDy0KPkyQDYwT7WZ0wq5VSXDvp75YU9HFvlRd8Tx6q6fE8YQcHNVXAkiY9q6d+xo0rKwT38xVqr7ZD0u0iPPkUL64lIZbqBAz+scqKmlzm8FDrypNC9Yjc8fPOLn9FX9KSYvKTr4rvx3iSIlTJabIQwj2ICCR/oLxBA==",
  #   },
  #   packed_policy_size: 8,
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.assume_role({
  #   role_arn: "arnType", # required
  #   role_session_name: "roleSessionNameType", # required
  #   policy_arns: [
  #   {
  #   arn: "arnType",
  #   },
  #   ],
  #   policy: "sessionPolicyDocumentType",
  #   duration_seconds: 1,
  #   tags: [
  #   {
  #   key: "tagKeyType", # required
  #   value: "tagValueType", # required
  #   },
  #   ],
  #   transitive_tag_keys: ["tagKeyType"],
  #   external_id: "externalIdType",
  #   serial_number: "serialNumberType",
  #   token_code: "tokenCodeType",
  #   source_identity: "sourceIdentityType",
  #   })
  # @example Response structure
  #
  #   resp.credentials.access_key_id #=> String
  #   resp.credentials.secret_access_key #=> String
  #   resp.credentials.session_token #=> String
  #   resp.credentials.expiration #=> Time
  #   resp.assumed_role_user.assumed_role_id #=> String
  #   resp.assumed_role_user.arn #=> String
  #   resp.packed_policy_size #=> Integer
  #   resp.source_identity #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload assume_role
  # @param params [Hash] ({})
  # @return [Types::AssumeRoleResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::AssumeRoleResponse#credentials #credentials} => Types::Credentials
  #   * {Types::AssumeRoleResponse#assumed_role_user #assumed_role_user} => Types::AssumedRoleUser
  #   * {Types::AssumeRoleResponse#packed_policy_size #packed_policy_size} => Integer
  #   * {Types::AssumeRoleResponse#source_identity #source_identity} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRole AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#840
  def assume_role(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a set of temporary security credentials for users who have
  # been authenticated via a SAML authentication response. This operation
  # provides a mechanism for tying an enterprise identity store or
  # directory to role-based Amazon Web Services access without
  # user-specific credentials or configuration. For a comparison of
  # `AssumeRoleWithSAML` with the other API operations that produce
  # temporary credentials, see [Requesting Temporary Security
  # Credentials][1] and [Comparing the Amazon Web Services STS API
  # operations][2] in the *IAM User Guide*.
  #
  # The temporary security credentials returned by this operation consist
  # of an access key ID, a secret access key, and a security token.
  # Applications can use these temporary security credentials to sign
  # calls to Amazon Web Services services.
  #
  # **Session Duration**
  #
  # By default, the temporary security credentials created by
  # `AssumeRoleWithSAML` last for one hour. However, you can use the
  # optional `DurationSeconds` parameter to specify the duration of your
  # session. Your role session lasts for the duration that you specify, or
  # until the time specified in the SAML authentication response's
  # `SessionNotOnOrAfter` value, whichever is shorter. You can provide a
  # `DurationSeconds` value from 900 seconds (15 minutes) up to the
  # maximum session duration setting for the role. This setting can have a
  # value from 1 hour to 12 hours. To learn how to view the maximum value
  # for your role, see [View the Maximum Session Duration Setting for a
  # Role][3] in the *IAM User Guide*. The maximum session duration limit
  # applies when you use the `AssumeRole*` API operations or the
  # `assume-role*` CLI commands. However the limit does not apply when you
  # use those operations to create a console URL. For more information,
  # see [Using IAM Roles][4] in the *IAM User Guide*.
  #
  # <note markdown="1"> [Role chaining][5] limits your CLI or Amazon Web Services API role
  # session to a maximum of one hour. When you use the `AssumeRole` API
  # operation to assume a role, you can specify the duration of your role
  # session with the `DurationSeconds` parameter. You can specify a
  # parameter value of up to 43200 seconds (12 hours), depending on the
  # maximum session duration setting for your role. However, if you assume
  # a role using role chaining and provide a `DurationSeconds` parameter
  # value greater than one hour, the operation fails.
  #
  #  </note>
  #
  # **Permissions**
  #
  # The temporary security credentials created by `AssumeRoleWithSAML` can
  # be used to make API calls to any Amazon Web Services service with the
  # following exception: you cannot call the STS `GetFederationToken` or
  # `GetSessionToken` API operations.
  #
  # (Optional) You can pass inline or managed [session policies][6] to
  # this operation. You can pass a single JSON policy document to use as
  # an inline session policy. You can also specify up to 10 managed policy
  # Amazon Resource Names (ARNs) to use as managed session policies. The
  # plaintext that you use for both inline and managed session policies
  # can't exceed 2,048 characters. Passing policies to this operation
  # returns new temporary credentials. The resulting session's
  # permissions are the intersection of the role's identity-based policy
  # and the session policies. You can use the role's temporary
  # credentials in subsequent Amazon Web Services API calls to access
  # resources in the account that owns the role. You cannot use session
  # policies to grant more permissions than those allowed by the
  # identity-based policy of the role that is being assumed. For more
  # information, see [Session Policies][6] in the *IAM User Guide*.
  #
  # Calling `AssumeRoleWithSAML` does not require the use of Amazon Web
  # Services security credentials. The identity of the caller is validated
  # by using keys in the metadata document that is uploaded for the SAML
  # provider entity for your identity provider.
  #
  # Calling `AssumeRoleWithSAML` can result in an entry in your CloudTrail
  # logs. The entry includes the value in the `NameID` element of the SAML
  # assertion. We recommend that you use a `NameIDType` that is not
  # associated with any personally identifiable information (PII). For
  # example, you could instead use the persistent identifier
  # (`urn:oasis:names:tc:SAML:2.0:nameid-format:persistent`).
  #
  # **Tags**
  #
  # (Optional) You can configure your IdP to pass attributes into your
  # SAML assertion as session tags. Each session tag consists of a key
  # name and an associated value. For more information about session tags,
  # see [Passing Session Tags in STS][7] in the *IAM User Guide*.
  #
  # You can pass up to 50 session tags. The plaintext session tag keys
  # can’t exceed 128 characters and the values can’t exceed 256
  # characters. For these and additional limits, see [IAM and STS
  # Character Limits][8] in the *IAM User Guide*.
  #
  # <note markdown="1"> An Amazon Web Services conversion compresses the passed inline session
  # policy, managed policy ARNs, and session tags into a packed binary
  # format that has a separate limit. Your request can fail for this limit
  # even if your plaintext meets the other requirements. The
  # `PackedPolicySize` response element indicates by percentage how close
  # the policies and tags for your request are to the upper size limit.
  #
  #  </note>
  #
  # You can pass a session tag with the same key as a tag that is attached
  # to the role. When you do, session tags override the role's tags with
  # the same key.
  #
  # An administrator must grant you the permissions necessary to pass
  # session tags. The administrator can also create granular permissions
  # to allow you to pass only specific session tags. For more information,
  # see [Tutorial: Using Tags for Attribute-Based Access Control][9] in
  # the *IAM User Guide*.
  #
  # You can set the session tags as transitive. Transitive tags persist
  # during role chaining. For more information, see [Chaining Roles with
  # Session Tags][10] in the *IAM User Guide*.
  #
  # **SAML Configuration**
  #
  # Before your application can call `AssumeRoleWithSAML`, you must
  # configure your SAML identity provider (IdP) to issue the claims
  # required by Amazon Web Services. Additionally, you must use Identity
  # and Access Management (IAM) to create a SAML provider entity in your
  # Amazon Web Services account that represents your identity provider.
  # You must also create an IAM role that specifies this SAML provider in
  # its trust policy.
  #
  # For more information, see the following resources:
  #
  # * [About SAML 2.0-based Federation][11] in the *IAM User Guide*.
  #
  # * [Creating SAML Identity Providers][12] in the *IAM User Guide*.
  #
  # * [Configuring a Relying Party and Claims][13] in the *IAM User
  #   Guide*.
  #
  # * [Creating a Role for SAML 2.0 Federation][14] in the *IAM User
  #   Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison
  # [3]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session
  # [4]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
  # [5]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-role-chaining
  # [6]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session
  # [7]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
  # [8]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html#reference_iam-limits-entity-length
  # [9]: https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_attribute-based-access-control.html
  # [10]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_role-chaining
  # [11]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
  # [12]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml.html
  # [13]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml_relying-party.html
  # [14]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_saml.html
  #
  # @example Example: To assume a role using a SAML assertion
  #
  #   resp = client.assume_role_with_saml({
  #   duration_seconds: 3600,
  #   principal_arn: "arn:aws:iam::123456789012:saml-provider/SAML-test",
  #   role_arn: "arn:aws:iam::123456789012:role/TestSaml",
  #   saml_assertion: "VERYLONGENCODEDASSERTIONEXAMPLExzYW1sOkF1ZGllbmNlPmJsYW5rPC9zYW1sOkF1ZGllbmNlPjwvc2FtbDpBdWRpZW5jZVJlc3RyaWN0aW9uPjwvc2FtbDpDb25kaXRpb25zPjxzYW1sOlN1YmplY3Q+PHNhbWw6TmFtZUlEIEZvcm1hdD0idXJuOm9hc2lzOm5hbWVzOnRjOlNBTUw6Mi4wOm5hbWVpZC1mb3JtYXQ6dHJhbnNpZW50Ij5TYW1sRXhhbXBsZTwvc2FtbDpOYW1lSUQ+PHNhbWw6U3ViamVjdENvbmZpcm1hdGlvbiBNZXRob2Q9InVybjpvYXNpczpuYW1lczp0YzpTQU1MOjIuMDpjbTpiZWFyZXIiPjxzYW1sOlN1YmplY3RDb25maXJtYXRpb25EYXRhIE5vdE9uT3JBZnRlcj0iMjAxOS0xMS0wMVQyMDoyNTowNS4xNDVaIiBSZWNpcGllbnQ9Imh0dHBzOi8vc2lnbmluLmF3cy5hbWF6b24uY29tL3NhbWwiLz48L3NhbWw6U3ViamVjdENvbmZpcm1hdGlvbj48L3NhbWw6U3ViamVjdD48c2FtbDpBdXRoblN0YXRlbWVudCBBdXRoPD94bWwgdmpSZXNwb25zZT4=",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   assumed_role_user: {
  #   arn: "arn:aws:sts::123456789012:assumed-role/TestSaml",
  #   assumed_role_id: "ARO456EXAMPLE789:TestSaml",
  #   },
  #   audience: "https://signin.aws.amazon.com/saml",
  #   credentials: {
  #   access_key_id: "ASIAV3ZUEFP6EXAMPLE",
  #   expiration: Time.parse("2019-11-01T20:26:47Z"),
  #   secret_access_key: "8P+SQvWIuLnKhh8d++jpw0nNmQRBZvNEXAMPLEKEY",
  #   session_token: "IQoJb3JpZ2luX2VjEOz////////////////////wEXAMPLEtMSJHMEUCIDoKK3JH9uGQE1z0sINr5M4jk+Na8KHDcCYRVjJCZEvOAiEA3OvJGtw1EcViOleS2vhs8VdCKFJQWPQrmGdeehM4IC1NtBmUpp2wUE8phUZampKsburEDy0KPkyQDYwT7WZ0wq5VSXDvp75YU9HFvlRd8Tx6q6fE8YQcHNVXAkiY9q6d+xo0rKwT38xVqr7ZD0u0iPPkUL64lIZbqBAz+scqKmlzm8FDrypNC9Yjc8fPOLn9FX9KSYvKTr4rvx3iSIlTJabIQwj2ICCR/oLxBA==",
  #   },
  #   issuer: "https://integ.example.com/idp/shibboleth",
  #   name_qualifier: "SbdGOnUkh1i4+EXAMPLExL/jEvs=",
  #   packed_policy_size: 6,
  #   subject: "SamlExample",
  #   subject_type: "transient",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.assume_role_with_saml({
  #   role_arn: "arnType", # required
  #   principal_arn: "arnType", # required
  #   saml_assertion: "SAMLAssertionType", # required
  #   policy_arns: [
  #   {
  #   arn: "arnType",
  #   },
  #   ],
  #   policy: "sessionPolicyDocumentType",
  #   duration_seconds: 1,
  #   })
  # @example Response structure
  #
  #   resp.credentials.access_key_id #=> String
  #   resp.credentials.secret_access_key #=> String
  #   resp.credentials.session_token #=> String
  #   resp.credentials.expiration #=> Time
  #   resp.assumed_role_user.assumed_role_id #=> String
  #   resp.assumed_role_user.arn #=> String
  #   resp.packed_policy_size #=> Integer
  #   resp.subject #=> String
  #   resp.subject_type #=> String
  #   resp.issuer #=> String
  #   resp.audience #=> String
  #   resp.name_qualifier #=> String
  #   resp.source_identity #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload assume_role_with_saml
  # @param params [Hash] ({})
  # @return [Types::AssumeRoleWithSAMLResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::AssumeRoleWithSAMLResponse#credentials #credentials} => Types::Credentials
  #   * {Types::AssumeRoleWithSAMLResponse#assumed_role_user #assumed_role_user} => Types::AssumedRoleUser
  #   * {Types::AssumeRoleWithSAMLResponse#packed_policy_size #packed_policy_size} => Integer
  #   * {Types::AssumeRoleWithSAMLResponse#subject #subject} => String
  #   * {Types::AssumeRoleWithSAMLResponse#subject_type #subject_type} => String
  #   * {Types::AssumeRoleWithSAMLResponse#issuer #issuer} => String
  #   * {Types::AssumeRoleWithSAMLResponse#audience #audience} => String
  #   * {Types::AssumeRoleWithSAMLResponse#name_qualifier #name_qualifier} => String
  #   * {Types::AssumeRoleWithSAMLResponse#source_identity #source_identity} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithSAML AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#1192
  def assume_role_with_saml(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a set of temporary security credentials for users who have
  # been authenticated in a mobile or web application with a web identity
  # provider. Example providers include the OAuth 2.0 providers Login with
  # Amazon and Facebook, or any OpenID Connect-compatible identity
  # provider such as Google or [Amazon Cognito federated identities][1].
  #
  # <note markdown="1"> For mobile applications, we recommend that you use Amazon Cognito. You
  # can use Amazon Cognito with the [Amazon Web Services SDK for iOS
  # Developer Guide][2] and the [Amazon Web Services SDK for Android
  # Developer Guide][3] to uniquely identify a user. You can also supply
  # the user with a consistent identity throughout the lifetime of an
  # application.
  #
  #  To learn more about Amazon Cognito, see [Amazon Cognito Overview][4]
  # in *Amazon Web Services SDK for Android Developer Guide* and [Amazon
  # Cognito Overview][5] in the *Amazon Web Services SDK for iOS Developer
  # Guide*.
  #
  #  </note>
  #
  # Calling `AssumeRoleWithWebIdentity` does not require the use of Amazon
  # Web Services security credentials. Therefore, you can distribute an
  # application (for example, on mobile devices) that requests temporary
  # security credentials without including long-term Amazon Web Services
  # credentials in the application. You also don't need to deploy
  # server-based proxy services that use long-term Amazon Web Services
  # credentials. Instead, the identity of the caller is validated by using
  # a token from the web identity provider. For a comparison of
  # `AssumeRoleWithWebIdentity` with the other API operations that produce
  # temporary credentials, see [Requesting Temporary Security
  # Credentials][6] and [Comparing the Amazon Web Services STS API
  # operations][7] in the *IAM User Guide*.
  #
  # The temporary security credentials returned by this API consist of an
  # access key ID, a secret access key, and a security token. Applications
  # can use these temporary security credentials to sign calls to Amazon
  # Web Services service API operations.
  #
  # **Session Duration**
  #
  # By default, the temporary security credentials created by
  # `AssumeRoleWithWebIdentity` last for one hour. However, you can use
  # the optional `DurationSeconds` parameter to specify the duration of
  # your session. You can provide a value from 900 seconds (15 minutes) up
  # to the maximum session duration setting for the role. This setting can
  # have a value from 1 hour to 12 hours. To learn how to view the maximum
  # value for your role, see [View the Maximum Session Duration Setting
  # for a Role][8] in the *IAM User Guide*. The maximum session duration
  # limit applies when you use the `AssumeRole*` API operations or the
  # `assume-role*` CLI commands. However the limit does not apply when you
  # use those operations to create a console URL. For more information,
  # see [Using IAM Roles][9] in the *IAM User Guide*.
  #
  # **Permissions**
  #
  # The temporary security credentials created by
  # `AssumeRoleWithWebIdentity` can be used to make API calls to any
  # Amazon Web Services service with the following exception: you cannot
  # call the STS `GetFederationToken` or `GetSessionToken` API operations.
  #
  # (Optional) You can pass inline or managed [session policies][10] to
  # this operation. You can pass a single JSON policy document to use as
  # an inline session policy. You can also specify up to 10 managed policy
  # Amazon Resource Names (ARNs) to use as managed session policies. The
  # plaintext that you use for both inline and managed session policies
  # can't exceed 2,048 characters. Passing policies to this operation
  # returns new temporary credentials. The resulting session's
  # permissions are the intersection of the role's identity-based policy
  # and the session policies. You can use the role's temporary
  # credentials in subsequent Amazon Web Services API calls to access
  # resources in the account that owns the role. You cannot use session
  # policies to grant more permissions than those allowed by the
  # identity-based policy of the role that is being assumed. For more
  # information, see [Session Policies][10] in the *IAM User Guide*.
  #
  # **Tags**
  #
  # (Optional) You can configure your IdP to pass attributes into your web
  # identity token as session tags. Each session tag consists of a key
  # name and an associated value. For more information about session tags,
  # see [Passing Session Tags in STS][11] in the *IAM User Guide*.
  #
  # You can pass up to 50 session tags. The plaintext session tag keys
  # can’t exceed 128 characters and the values can’t exceed 256
  # characters. For these and additional limits, see [IAM and STS
  # Character Limits][12] in the *IAM User Guide*.
  #
  # <note markdown="1"> An Amazon Web Services conversion compresses the passed inline session
  # policy, managed policy ARNs, and session tags into a packed binary
  # format that has a separate limit. Your request can fail for this limit
  # even if your plaintext meets the other requirements. The
  # `PackedPolicySize` response element indicates by percentage how close
  # the policies and tags for your request are to the upper size limit.
  #
  #  </note>
  #
  # You can pass a session tag with the same key as a tag that is attached
  # to the role. When you do, the session tag overrides the role tag with
  # the same key.
  #
  # An administrator must grant you the permissions necessary to pass
  # session tags. The administrator can also create granular permissions
  # to allow you to pass only specific session tags. For more information,
  # see [Tutorial: Using Tags for Attribute-Based Access Control][13] in
  # the *IAM User Guide*.
  #
  # You can set the session tags as transitive. Transitive tags persist
  # during role chaining. For more information, see [Chaining Roles with
  # Session Tags][14] in the *IAM User Guide*.
  #
  # **Identities**
  #
  # Before your application can call `AssumeRoleWithWebIdentity`, you must
  # have an identity token from a supported identity provider and create a
  # role that the application can assume. The role that your application
  # assumes must trust the identity provider that is associated with the
  # identity token. In other words, the identity provider must be
  # specified in the role's trust policy.
  #
  # Calling `AssumeRoleWithWebIdentity` can result in an entry in your
  # CloudTrail logs. The entry includes the [Subject][15] of the provided
  # web identity token. We recommend that you avoid using any personally
  # identifiable information (PII) in this field. For example, you could
  # instead use a GUID or a pairwise identifier, as [suggested in the OIDC
  # specification][16].
  #
  # For more information about how to use web identity federation and the
  # `AssumeRoleWithWebIdentity` API, see the following resources:
  #
  # * [Using Web Identity Federation API Operations for Mobile Apps][17]
  #   and [Federation Through a Web-based Identity Provider][18].
  #
  # * [ Web Identity Federation Playground][19]. Walk through the process
  #   of authenticating through Login with Amazon, Facebook, or Google,
  #   getting temporary security credentials, and then using those
  #   credentials to make a request to Amazon Web Services.
  #
  # * [Amazon Web Services SDK for iOS Developer Guide][2] and [Amazon Web
  #   Services SDK for Android Developer Guide][3]. These toolkits contain
  #   sample apps that show how to invoke the identity providers. The
  #   toolkits then show how to use the information from these providers
  #   to get and use temporary security credentials.
  #
  # * [Web Identity Federation with Mobile Applications][20]. This article
  #   discusses web identity federation and shows an example of how to use
  #   web identity federation to get access to content in Amazon S3.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
  # [2]: http://aws.amazon.com/sdkforios/
  # [3]: http://aws.amazon.com/sdkforandroid/
  # [4]: https://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-auth.html#d0e840
  # [5]: https://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-auth.html#d0e664
  # [6]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html
  # [7]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison
  # [8]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session
  # [9]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
  # [10]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session
  # [11]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
  # [12]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html#reference_iam-limits-entity-length
  # [13]: https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_attribute-based-access-control.html
  # [14]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_role-chaining
  # [15]: http://openid.net/specs/openid-connect-core-1_0.html#Claims
  # [16]: http://openid.net/specs/openid-connect-core-1_0.html#SubjectIDTypes
  # [17]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_manual.html
  # [18]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity
  # [19]: https://aws.amazon.com/blogs/aws/the-aws-web-identity-federation-playground/
  # [20]: http://aws.amazon.com/articles/web-identity-federation-with-mobile-applications
  #
  # @example Example: To assume a role as an OpenID Connect-federated user
  #
  #   resp = client.assume_role_with_web_identity({
  #   duration_seconds: 3600,
  #   policy: "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":\"Allow\",\"Action\":\"s3:ListAllMyBuckets\",\"Resource\":\"*\"}]}",
  #   provider_id: "www.amazon.com",
  #   role_arn: "arn:aws:iam::123456789012:role/FederatedWebIdentityRole",
  #   role_session_name: "app1",
  #   web_identity_token: "Atza%7CIQEBLjAsAhRFiXuWpUXuRvQ9PZL3GMFcYevydwIUFAHZwXZXXXXXXXXJnrulxKDHwy87oGKPznh0D6bEQZTSCzyoCtL_8S07pLpr0zMbn6w1lfVZKNTBdDansFBmtGnIsIapjI6xKR02Yc_2bQ8LZbUXSGm6Ry6_BG7PrtLZtj_dfCTj92xNGed-CrKqjG7nPBjNIL016GGvuS5gSvPRUxWES3VYfm1wl7WTI7jn-Pcb6M-buCgHhFOzTQxod27L9CqnOLio7N3gZAGpsp6n1-AJBOCJckcyXe2c6uD0srOJeZlKUm2eTDVMf8IehDVI0r1QOnTV6KzzAI3OY87Vd_cVMQ",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   assumed_role_user: {
  #   arn: "arn:aws:sts::123456789012:assumed-role/FederatedWebIdentityRole/app1",
  #   assumed_role_id: "AROACLKWSDQRAOEXAMPLE:app1",
  #   },
  #   audience: "client.5498841531868486423.1548@apps.example.com",
  #   credentials: {
  #   access_key_id: "AKIAIOSFODNN7EXAMPLE",
  #   expiration: Time.parse("2014-10-24T23:00:23Z"),
  #   secret_access_key: "wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY",
  #   session_token: "AQoDYXdzEE0a8ANXXXXXXXXNO1ewxE5TijQyp+IEXAMPLE",
  #   },
  #   packed_policy_size: 123,
  #   provider: "www.amazon.com",
  #   subject_from_web_identity_token: "amzn1.account.AF6RHO7KZU5XRVQJGXK6HEXAMPLE",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.assume_role_with_web_identity({
  #   role_arn: "arnType", # required
  #   role_session_name: "roleSessionNameType", # required
  #   web_identity_token: "clientTokenType", # required
  #   provider_id: "urlType",
  #   policy_arns: [
  #   {
  #   arn: "arnType",
  #   },
  #   ],
  #   policy: "sessionPolicyDocumentType",
  #   duration_seconds: 1,
  #   })
  # @example Response structure
  #
  #   resp.credentials.access_key_id #=> String
  #   resp.credentials.secret_access_key #=> String
  #   resp.credentials.session_token #=> String
  #   resp.credentials.expiration #=> Time
  #   resp.subject_from_web_identity_token #=> String
  #   resp.assumed_role_user.assumed_role_id #=> String
  #   resp.assumed_role_user.arn #=> String
  #   resp.packed_policy_size #=> Integer
  #   resp.provider #=> String
  #   resp.audience #=> String
  #   resp.source_identity #=> String
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload assume_role_with_web_identity
  # @param params [Hash] ({})
  # @return [Types::AssumeRoleWithWebIdentityResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::AssumeRoleWithWebIdentityResponse#credentials #credentials} => Types::Credentials
  #   * {Types::AssumeRoleWithWebIdentityResponse#subject_from_web_identity_token #subject_from_web_identity_token} => String
  #   * {Types::AssumeRoleWithWebIdentityResponse#assumed_role_user #assumed_role_user} => Types::AssumedRoleUser
  #   * {Types::AssumeRoleWithWebIdentityResponse#packed_policy_size #packed_policy_size} => Integer
  #   * {Types::AssumeRoleWithWebIdentityResponse#provider #provider} => String
  #   * {Types::AssumeRoleWithWebIdentityResponse#audience #audience} => String
  #   * {Types::AssumeRoleWithWebIdentityResponse#source_identity #source_identity} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithWebIdentity AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#1573
  def assume_role_with_web_identity(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @param params [{}]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2310
  def build_request(operation_name, params = T.unsafe(nil)); end

  # Decodes additional information about the authorization status of a
  # request from an encoded message returned in response to an Amazon Web
  # Services request.
  #
  # For example, if a user is not authorized to perform an operation that
  # he or she has requested, the request returns a
  # `Client.UnauthorizedOperation` response (an HTTP 403 response). Some
  # Amazon Web Services operations additionally return an encoded message
  # that can provide details about this authorization failure.
  #
  # <note markdown="1"> Only certain Amazon Web Services operations return an encoded
  # authorization message. The documentation for an individual operation
  # indicates whether that operation returns an encoded message in
  # addition to returning an HTTP code.
  #
  #  </note>
  #
  # The message is encoded because the details of the authorization status
  # can contain privileged information that the user who requested the
  # operation should not see. To decode an authorization status message, a
  # user must be granted permissions through an IAM [policy][1] to request
  # the `DecodeAuthorizationMessage` (`sts:DecodeAuthorizationMessage`)
  # action.
  #
  # The decoded message includes the following type of information:
  #
  # * Whether the request was denied due to an explicit deny or due to the
  #   absence of an explicit allow. For more information, see [Determining
  #   Whether a Request is Allowed or Denied][2] in the *IAM User Guide*.
  #
  # * The principal who made the request.
  #
  # * The requested action.
  #
  # * The requested resource.
  #
  # * The values of condition keys in the context of the user's request.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-denyallow
  #
  # @example Example: To decode information about an authorization status of a request
  #
  #   resp = client.decode_authorization_message({
  #   encoded_message: "<encoded-message>",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   decoded_message: "{\"allowed\": \"false\",\"explicitDeny\": \"false\",\"matchedStatements\": \"\",\"failures\": \"\",\"context\": {\"principal\": {\"id\": \"AIDACKCEVSQ6C2EXAMPLE\",\"name\": \"Bob\",\"arn\": \"arn:aws:iam::123456789012:user/Bob\"},\"action\": \"ec2:StopInstances\",\"resource\": \"arn:aws:ec2:us-east-1:123456789012:instance/i-dd01c9bd\",\"conditions\": [{\"item\": {\"key\": \"ec2:Tenancy\",\"values\": [\"default\"]},{\"item\": {\"key\": \"ec2:ResourceTag/elasticbeanstalk:environment-name\",\"values\": [\"Default-Environment\"]}},(Additional items ...)]}}",
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.decode_authorization_message({
  #   encoded_message: "encodedMessageType", # required
  #   })
  # @example Response structure
  #
  #   resp.decoded_message #=> String
  # @option params
  # @overload decode_authorization_message
  # @param params [Hash] ({})
  # @return [Types::DecodeAuthorizationMessageResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::DecodeAuthorizationMessageResponse#decoded_message #decoded_message} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/DecodeAuthorizationMessage AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#1654
  def decode_authorization_message(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the account identifier for the specified access key ID.
  #
  # Access keys consist of two parts: an access key ID (for example,
  # `AKIAIOSFODNN7EXAMPLE`) and a secret access key (for example,
  # `wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY`). For more information
  # about access keys, see [Managing Access Keys for IAM Users][1] in the
  # *IAM User Guide*.
  #
  # When you pass an access key ID to this operation, it returns the ID of
  # the Amazon Web Services account to which the keys belong. Access key
  # IDs beginning with `AKIA` are long-term credentials for an IAM user or
  # the Amazon Web Services account root user. Access key IDs beginning
  # with `ASIA` are temporary credentials that are created using STS
  # operations. If the account in the response belongs to you, you can
  # sign in as the root user and review your root user access keys. Then,
  # you can pull a [credentials report][2] to learn which IAM user owns
  # the keys. To learn who requested the temporary credentials for an
  # `ASIA` access key, view the STS events in your [CloudTrail logs][3] in
  # the *IAM User Guide*.
  #
  # This operation does not indicate the state of the access key. The key
  # might be active, inactive, or deleted. Active keys might not have
  # permissions to perform an operation. Providing a deleted access key
  # might return an error that the key doesn't exist.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html
  # [3]: https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html
  #
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_access_key_info({
  #   access_key_id: "accessKeyIdType", # required
  #   })
  # @example Response structure
  #
  #   resp.account #=> String
  # @option params
  # @overload get_access_key_info
  # @param params [Hash] ({})
  # @return [Types::GetAccessKeyInfoResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetAccessKeyInfoResponse#account #account} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetAccessKeyInfo AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#1715
  def get_access_key_info(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns details about the IAM user or role whose credentials are used
  # to call the operation.
  #
  # <note markdown="1"> No permissions are required to perform this operation. If an
  # administrator adds a policy to your IAM user or role that explicitly
  # denies access to the `sts:GetCallerIdentity` action, you can still
  # perform this operation. Permissions are not required because the same
  # information is returned when an IAM user or role is denied access. To
  # view an example response, see [I Am Not Authorized to Perform:
  # iam:DeleteVirtualMFADevice][1] in the *IAM User Guide*.
  #
  #  </note>
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_access-denied-delete-mfa
  #
  # @example Example: To get details about a calling IAM user
  #
  #   # This example shows a request and response made with the credentials for a user named Alice in the AWS account
  #   # 123456789012.
  #
  #   resp = client.get_caller_identity({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   account: "123456789012",
  #   arn: "arn:aws:iam::123456789012:user/Alice",
  #   user_id: "AKIAI44QH8DHBEXAMPLE",
  #   }
  # @example Example: To get details about a calling user federated with AssumeRole
  #
  #   # This example shows a request and response made with temporary credentials created by AssumeRole. The name of the assumed
  #   # role is my-role-name, and the RoleSessionName is set to my-role-session-name.
  #
  #   resp = client.get_caller_identity({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   account: "123456789012",
  #   arn: "arn:aws:sts::123456789012:assumed-role/my-role-name/my-role-session-name",
  #   user_id: "AKIAI44QH8DHBEXAMPLE:my-role-session-name",
  #   }
  # @example Example: To get details about a calling user federated with GetFederationToken
  #
  #   # This example shows a request and response made with temporary credentials created by using GetFederationToken. The Name
  #   # parameter is set to my-federated-user-name.
  #
  #   resp = client.get_caller_identity({
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   account: "123456789012",
  #   arn: "arn:aws:sts::123456789012:federated-user/my-federated-user-name",
  #   user_id: "123456789012:my-federated-user-name",
  #   }
  # @example Response structure
  #
  #   resp.user_id #=> String
  #   resp.account #=> String
  #   resp.arn #=> String
  # @overload get_caller_identity
  # @param params [Hash] ({})
  # @return [Types::GetCallerIdentityResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetCallerIdentityResponse#user_id #user_id} => String
  #   * {Types::GetCallerIdentityResponse#account #account} => String
  #   * {Types::GetCallerIdentityResponse#arn #arn} => String
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetCallerIdentity AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#1799
  def get_caller_identity(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a set of temporary security credentials (consisting of an
  # access key ID, a secret access key, and a security token) for a
  # federated user. A typical use is in a proxy application that gets
  # temporary security credentials on behalf of distributed applications
  # inside a corporate network. You must call the `GetFederationToken`
  # operation using the long-term security credentials of an IAM user. As
  # a result, this call is appropriate in contexts where those credentials
  # can be safely stored, usually in a server-based application. For a
  # comparison of `GetFederationToken` with the other API operations that
  # produce temporary credentials, see [Requesting Temporary Security
  # Credentials][1] and [Comparing the Amazon Web Services STS API
  # operations][2] in the *IAM User Guide*.
  #
  # <note markdown="1"> You can create a mobile-based or browser-based app that can
  # authenticate users using a web identity provider like Login with
  # Amazon, Facebook, Google, or an OpenID Connect-compatible identity
  # provider. In this case, we recommend that you use [Amazon Cognito][3]
  # or `AssumeRoleWithWebIdentity`. For more information, see [Federation
  # Through a Web-based Identity Provider][4] in the *IAM User Guide*.
  #
  #  </note>
  #
  # You can also call `GetFederationToken` using the security credentials
  # of an Amazon Web Services account root user, but we do not recommend
  # it. Instead, we recommend that you create an IAM user for the purpose
  # of the proxy application. Then attach a policy to the IAM user that
  # limits federated users to only the actions and resources that they
  # need to access. For more information, see [IAM Best Practices][5] in
  # the *IAM User Guide*.
  #
  # **Session duration**
  #
  # The temporary credentials are valid for the specified duration, from
  # 900 seconds (15 minutes) up to a maximum of 129,600 seconds (36
  # hours). The default session duration is 43,200 seconds (12 hours).
  # Temporary credentials obtained by using the Amazon Web Services
  # account root user credentials have a maximum duration of 3,600 seconds
  # (1 hour).
  #
  # **Permissions**
  #
  # You can use the temporary credentials created by `GetFederationToken`
  # in any Amazon Web Services service except the following:
  #
  # * You cannot call any IAM operations using the CLI or the Amazon Web
  #   Services API.
  #
  # * You cannot call any STS operations except `GetCallerIdentity`.
  #
  # You must pass an inline or managed [session policy][6] to this
  # operation. You can pass a single JSON policy document to use as an
  # inline session policy. You can also specify up to 10 managed policy
  # Amazon Resource Names (ARNs) to use as managed session policies. The
  # plaintext that you use for both inline and managed session policies
  # can't exceed 2,048 characters.
  #
  # Though the session policy parameters are optional, if you do not pass
  # a policy, then the resulting federated user session has no
  # permissions. When you pass session policies, the session permissions
  # are the intersection of the IAM user policies and the session policies
  # that you pass. This gives you a way to further restrict the
  # permissions for a federated user. You cannot use session policies to
  # grant more permissions than those that are defined in the permissions
  # policy of the IAM user. For more information, see [Session
  # Policies][6] in the *IAM User Guide*. For information about using
  # `GetFederationToken` to create temporary security credentials, see
  # [GetFederationToken—Federation Through a Custom Identity Broker][7].
  #
  # You can use the credentials to access a resource that has a
  # resource-based policy. If that policy specifically references the
  # federated user session in the `Principal` element of the policy, the
  # session has the permissions allowed by the policy. These permissions
  # are granted in addition to the permissions granted by the session
  # policies.
  #
  # **Tags**
  #
  # (Optional) You can pass tag key-value pairs to your session. These are
  # called session tags. For more information about session tags, see
  # [Passing Session Tags in STS][8] in the *IAM User Guide*.
  #
  # <note markdown="1"> You can create a mobile-based or browser-based app that can
  # authenticate users using a web identity provider like Login with
  # Amazon, Facebook, Google, or an OpenID Connect-compatible identity
  # provider. In this case, we recommend that you use [Amazon Cognito][3]
  # or `AssumeRoleWithWebIdentity`. For more information, see [Federation
  # Through a Web-based Identity Provider][4] in the *IAM User Guide*.
  #
  #  </note>
  #
  # An administrator must grant you the permissions necessary to pass
  # session tags. The administrator can also create granular permissions
  # to allow you to pass only specific session tags. For more information,
  # see [Tutorial: Using Tags for Attribute-Based Access Control][9] in
  # the *IAM User Guide*.
  #
  # Tag key–value pairs are not case sensitive, but case is preserved.
  # This means that you cannot have separate `Department` and `department`
  # tag keys. Assume that the user that you are federating has the
  # `Department`=`Marketing` tag and you pass the
  # `department`=`engineering` session tag. `Department` and `department`
  # are not saved as separate tags, and the session tag passed in the
  # request takes precedence over the user tag.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison
  # [3]: http://aws.amazon.com/cognito/
  # [4]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity
  # [5]: https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html
  # [6]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session
  # [7]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getfederationtoken
  # [8]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
  # [9]: https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_attribute-based-access-control.html
  #
  # @example Example: To get temporary credentials for a role by using GetFederationToken
  #
  #   resp = client.get_federation_token({
  #   duration_seconds: 3600,
  #   name: "testFedUserSession",
  #   policy: "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":\"Allow\",\"Action\":\"s3:ListAllMyBuckets\",\"Resource\":\"*\"}]}",
  #   tags: [
  #   {
  #   key: "Project",
  #   value: "Pegasus",
  #   },
  #   {
  #   key: "Cost-Center",
  #   value: "98765",
  #   },
  #   ],
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   credentials: {
  #   access_key_id: "AKIAIOSFODNN7EXAMPLE",
  #   expiration: Time.parse("2011-07-15T23:28:33.359Z"),
  #   secret_access_key: "wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY",
  #   session_token: "AQoDYXdzEPT//////////wEXAMPLEtc764bNrC9SAPBSM22wDOk4x4HIZ8j4FZTwdQWLWsKWHGBuFqwAeMicRXmxfpSPfIeoIYRqTflfKD8YUuwthAx7mSEI/qkPpKPi/kMcGdQrmGdeehM4IC1NtBmUpp2wUE8phUZampKsburEDy0KPkyQDYwT7WZ0wq5VSXDvp75YU9HFvlRd8Tx6q6fE8YQcHNVXAkiY9q6d+xo0rKwT38xVqr7ZD0u0iPPkUL64lIZbqBAz+scqKmlzm8FDrypNC9Yjc8fPOLn9FX9KSYvKTr4rvx3iSIlTJabIQwj2ICCR/oLxBA==",
  #   },
  #   federated_user: {
  #   arn: "arn:aws:sts::123456789012:federated-user/Bob",
  #   federated_user_id: "123456789012:Bob",
  #   },
  #   packed_policy_size: 8,
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_federation_token({
  #   name: "userNameType", # required
  #   policy: "sessionPolicyDocumentType",
  #   policy_arns: [
  #   {
  #   arn: "arnType",
  #   },
  #   ],
  #   duration_seconds: 1,
  #   tags: [
  #   {
  #   key: "tagKeyType", # required
  #   value: "tagValueType", # required
  #   },
  #   ],
  #   })
  # @example Response structure
  #
  #   resp.credentials.access_key_id #=> String
  #   resp.credentials.secret_access_key #=> String
  #   resp.credentials.session_token #=> String
  #   resp.credentials.expiration #=> Time
  #   resp.federated_user.federated_user_id #=> String
  #   resp.federated_user.arn #=> String
  #   resp.packed_policy_size #=> Integer
  # @option params
  # @option params
  # @option params
  # @option params
  # @option params
  # @overload get_federation_token
  # @param params [Hash] ({})
  # @return [Types::GetFederationTokenResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetFederationTokenResponse#credentials #credentials} => Types::Credentials
  #   * {Types::GetFederationTokenResponse#federated_user #federated_user} => Types::FederatedUser
  #   * {Types::GetFederationTokenResponse#packed_policy_size #packed_policy_size} => Integer
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetFederationToken AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2144
  def get_federation_token(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a set of temporary credentials for an Amazon Web Services
  # account or IAM user. The credentials consist of an access key ID, a
  # secret access key, and a security token. Typically, you use
  # `GetSessionToken` if you want to use MFA to protect programmatic calls
  # to specific Amazon Web Services API operations like Amazon EC2
  # `StopInstances`. MFA-enabled IAM users would need to call
  # `GetSessionToken` and submit an MFA code that is associated with their
  # MFA device. Using the temporary security credentials that are returned
  # from the call, IAM users can then make programmatic calls to API
  # operations that require MFA authentication. If you do not supply a
  # correct MFA code, then the API returns an access denied error. For a
  # comparison of `GetSessionToken` with the other API operations that
  # produce temporary credentials, see [Requesting Temporary Security
  # Credentials][1] and [Comparing the Amazon Web Services STS API
  # operations][2] in the *IAM User Guide*.
  #
  # <note markdown="1"> No permissions are required for users to perform this operation. The
  # purpose of the `sts:GetSessionToken` operation is to authenticate the
  # user using MFA. You cannot use policies to control authentication
  # operations. For more information, see [Permissions for
  # GetSessionToken][3] in the *IAM User Guide*.
  #
  #  </note>
  #
  # **Session Duration**
  #
  # The `GetSessionToken` operation must be called by using the long-term
  # Amazon Web Services security credentials of the Amazon Web Services
  # account root user or an IAM user. Credentials that are created by IAM
  # users are valid for the duration that you specify. This duration can
  # range from 900 seconds (15 minutes) up to a maximum of 129,600 seconds
  # (36 hours), with a default of 43,200 seconds (12 hours). Credentials
  # based on account credentials can range from 900 seconds (15 minutes)
  # up to 3,600 seconds (1 hour), with a default of 1 hour.
  #
  # **Permissions**
  #
  # The temporary security credentials created by `GetSessionToken` can be
  # used to make API calls to any Amazon Web Services service with the
  # following exceptions:
  #
  # * You cannot call any IAM API operations unless MFA authentication
  #   information is included in the request.
  #
  # * You cannot call any STS API *except* `AssumeRole` or
  #   `GetCallerIdentity`.
  #
  # <note markdown="1"> We recommend that you do not call `GetSessionToken` with Amazon Web
  # Services account root user credentials. Instead, follow our [best
  # practices][4] by creating one or more IAM users, giving them the
  # necessary permissions, and using IAM users for everyday interaction
  # with Amazon Web Services.
  #
  #  </note>
  #
  # The credentials that are returned by `GetSessionToken` are based on
  # permissions associated with the user whose credentials were used to
  # call the operation. If `GetSessionToken` is called using Amazon Web
  # Services account root user credentials, the temporary credentials have
  # root user permissions. Similarly, if `GetSessionToken` is called using
  # the credentials of an IAM user, the temporary credentials have the
  # same permissions as the IAM user.
  #
  # For more information about using `GetSessionToken` to create temporary
  # credentials, go to [Temporary Credentials for Users in Untrusted
  # Environments][5] in the *IAM User Guide*.
  #
  #
  #
  # [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html
  # [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison
  # [3]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getsessiontoken.html
  # [4]: https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#create-iam-users
  # [5]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getsessiontoken
  #
  # @example Example: To get temporary credentials for an IAM user or an AWS account
  #
  #   resp = client.get_session_token({
  #   duration_seconds: 3600,
  #   serial_number: "YourMFASerialNumber",
  #   token_code: "123456",
  #   })
  #
  #   resp.to_h outputs the following:
  #   {
  #   credentials: {
  #   access_key_id: "AKIAIOSFODNN7EXAMPLE",
  #   expiration: Time.parse("2011-07-11T19:55:29.611Z"),
  #   secret_access_key: "wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY",
  #   session_token: "AQoEXAMPLEH4aoAH0gNCAPyJxz4BlCFFxWNE1OPTgk5TthT+FvwqnKwRcOIfrRh3c/LTo6UDdyJwOOvEVPvLXCrrrUtdnniCEXAMPLE/IvU1dYUg2RVAJBanLiHb4IgRmpRV3zrkuWJOgQs8IZZaIv2BXIa2R4OlgkBN9bkUDNCJiBeb/AXlzBBko7b15fjrBs2+cTQtpZ3CYWFXG8C5zqx37wnOE49mRl/+OtkIKGO7fAE",
  #   },
  #   }
  # @example Request syntax with placeholder values
  #
  #   resp = client.get_session_token({
  #   duration_seconds: 1,
  #   serial_number: "serialNumberType",
  #   token_code: "tokenCodeType",
  #   })
  # @example Response structure
  #
  #   resp.credentials.access_key_id #=> String
  #   resp.credentials.secret_access_key #=> String
  #   resp.credentials.session_token #=> String
  #   resp.credentials.expiration #=> Time
  # @option params
  # @option params
  # @option params
  # @overload get_session_token
  # @param params [Hash] ({})
  # @return [Types::GetSessionTokenResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
  #
  #   * {Types::GetSessionTokenResponse#credentials #credentials} => Types::Credentials
  # @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetSessionToken AWS API Documentation
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2301
  def get_session_token(params = T.unsafe(nil), options = T.unsafe(nil)); end

  # @api private
  # @deprecated
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2325
  def waiter_names; end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2335
    def errors_module; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-sts/client.rb#2332
    def identifier; end
  end
end

# @api private
module Aws::STS::ClientApi
  include ::Seahorse::Model
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#237
Aws::STS::ClientApi::API = T.let(T.unsafe(nil), Seahorse::Model::Api)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#16
Aws::STS::ClientApi::AssumeRoleRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#17
Aws::STS::ClientApi::AssumeRoleResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#18
Aws::STS::ClientApi::AssumeRoleWithSAMLRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#19
Aws::STS::ClientApi::AssumeRoleWithSAMLResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#20
Aws::STS::ClientApi::AssumeRoleWithWebIdentityRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#21
Aws::STS::ClientApi::AssumeRoleWithWebIdentityResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#22
Aws::STS::ClientApi::AssumedRoleUser = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#23
Aws::STS::ClientApi::Audience = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#24
Aws::STS::ClientApi::Credentials = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#25
Aws::STS::ClientApi::DecodeAuthorizationMessageRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#26
Aws::STS::ClientApi::DecodeAuthorizationMessageResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#27
Aws::STS::ClientApi::ExpiredTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#28
Aws::STS::ClientApi::FederatedUser = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#29
Aws::STS::ClientApi::GetAccessKeyInfoRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#30
Aws::STS::ClientApi::GetAccessKeyInfoResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#31
Aws::STS::ClientApi::GetCallerIdentityRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#32
Aws::STS::ClientApi::GetCallerIdentityResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#33
Aws::STS::ClientApi::GetFederationTokenRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#34
Aws::STS::ClientApi::GetFederationTokenResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#35
Aws::STS::ClientApi::GetSessionTokenRequest = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#36
Aws::STS::ClientApi::GetSessionTokenResponse = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#37
Aws::STS::ClientApi::IDPCommunicationErrorException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#38
Aws::STS::ClientApi::IDPRejectedClaimException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#39
Aws::STS::ClientApi::InvalidAuthorizationMessageException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#40
Aws::STS::ClientApi::InvalidIdentityTokenException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#41
Aws::STS::ClientApi::Issuer = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#42
Aws::STS::ClientApi::MalformedPolicyDocumentException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#43
Aws::STS::ClientApi::NameQualifier = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#44
Aws::STS::ClientApi::PackedPolicyTooLargeException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#45
Aws::STS::ClientApi::PolicyDescriptorType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#46
Aws::STS::ClientApi::RegionDisabledException = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#47
Aws::STS::ClientApi::SAMLAssertionType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#48
Aws::STS::ClientApi::Subject = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#49
Aws::STS::ClientApi::SubjectType = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StringShape)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/client_api.rb#50
Aws::STS::ClientApi::Tag = T.let(T.unsafe(nil), Seahorse::Model::Shapes::StructureShape)

# Endpoint parameters used to influence endpoints per request.
class Aws::STS::EndpointParameters < ::Struct
  include ::Aws::Structure

  # @return [EndpointParameters] a new instance of EndpointParameters
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/endpoint_parameters.rb#58
  def initialize(options = T.unsafe(nil)); end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint; end

  # Override the endpoint used to send this request
  #
  # @return [String]
  def endpoint=(_); end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region; end

  # The AWS region used to dispatch the request.
  #
  # @return [String]
  def region=(_); end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack; end

  # When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
  #
  # @return [Boolean]
  def use_dual_stack=(_); end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips; end

  # When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
  #
  # @return [Boolean]
  def use_fips=(_); end

  # Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
  #
  # @return [Boolean]
  def use_global_endpoint; end

  # Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
  #
  # @return [Boolean]
  def use_global_endpoint=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class Aws::STS::EndpointProvider
  # @return [EndpointProvider] a new instance of EndpointProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/endpoint_provider.rb#12
  def initialize(rule_set = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-sts/endpoint_provider.rb#25
  def resolve_endpoint(parameters); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-sts/endpoint_provider.rb#30
Aws::STS::EndpointProvider::RULES = T.let(T.unsafe(nil), String)

module Aws::STS::Endpoints; end

class Aws::STS::Endpoints::AssumeRole
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#15
    def build(context); end
  end
end

class Aws::STS::Endpoints::AssumeRoleWithSAML
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#30
    def build(context); end
  end
end

class Aws::STS::Endpoints::AssumeRoleWithWebIdentity
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#45
    def build(context); end
  end
end

class Aws::STS::Endpoints::DecodeAuthorizationMessage
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#60
    def build(context); end
  end
end

class Aws::STS::Endpoints::GetAccessKeyInfo
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#75
    def build(context); end
  end
end

class Aws::STS::Endpoints::GetCallerIdentity
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#90
    def build(context); end
  end
end

class Aws::STS::Endpoints::GetFederationToken
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#105
    def build(context); end
  end
end

class Aws::STS::Endpoints::GetSessionToken
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/endpoints.rb#120
    def build(context); end
  end
end

# When STS returns an error response, the Ruby SDK constructs and raises an error.
# These errors all extend Aws::STS::Errors::ServiceError < {Aws::Errors::ServiceError}
#
# You can rescue all STS errors using ServiceError:
#
#     begin
#       # do stuff
#     rescue Aws::STS::Errors::ServiceError
#       # rescues all STS API errors
#     end
#
#
# ## Request Context
# ServiceError objects have a {Aws::Errors::ServiceError#context #context} method that returns
# information about the request that generated the error.
# See {Seahorse::Client::RequestContext} for more information.
#
# ## Error Classes
# * {ExpiredTokenException}
# * {IDPCommunicationErrorException}
# * {IDPRejectedClaimException}
# * {InvalidAuthorizationMessageException}
# * {InvalidIdentityTokenException}
# * {MalformedPolicyDocumentException}
# * {PackedPolicyTooLargeException}
# * {RegionDisabledException}
#
# Additionally, error classes are dynamically generated for service errors based on the error code
# if they are not defined above.
module Aws::STS::Errors
  extend ::Aws::Errors::DynamicErrors
end

class Aws::STS::Errors::ExpiredTokenException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::ExpiredTokenException]
  # @return [ExpiredTokenException] a new instance of ExpiredTokenException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#50
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#55
  def message; end
end

class Aws::STS::Errors::IDPCommunicationErrorException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::IDPCommunicationErrorException]
  # @return [IDPCommunicationErrorException] a new instance of IDPCommunicationErrorException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#65
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#70
  def message; end
end

class Aws::STS::Errors::IDPRejectedClaimException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::IDPRejectedClaimException]
  # @return [IDPRejectedClaimException] a new instance of IDPRejectedClaimException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#80
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#85
  def message; end
end

class Aws::STS::Errors::InvalidAuthorizationMessageException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::InvalidAuthorizationMessageException]
  # @return [InvalidAuthorizationMessageException] a new instance of InvalidAuthorizationMessageException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#95
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#100
  def message; end
end

class Aws::STS::Errors::InvalidIdentityTokenException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::InvalidIdentityTokenException]
  # @return [InvalidIdentityTokenException] a new instance of InvalidIdentityTokenException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#110
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#115
  def message; end
end

class Aws::STS::Errors::MalformedPolicyDocumentException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::MalformedPolicyDocumentException]
  # @return [MalformedPolicyDocumentException] a new instance of MalformedPolicyDocumentException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#125
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#130
  def message; end
end

class Aws::STS::Errors::PackedPolicyTooLargeException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::PackedPolicyTooLargeException]
  # @return [PackedPolicyTooLargeException] a new instance of PackedPolicyTooLargeException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#140
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#145
  def message; end
end

class Aws::STS::Errors::RegionDisabledException < ::Aws::STS::Errors::ServiceError
  # @param context [Seahorse::Client::RequestContext]
  # @param message [String]
  # @param data [Aws::STS::Types::RegionDisabledException]
  # @return [RegionDisabledException] a new instance of RegionDisabledException
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#155
  def initialize(context, message, data = T.unsafe(nil)); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/errors.rb#160
  def message; end
end

class Aws::STS::Errors::ServiceError < ::Aws::Errors::ServiceError; end

# source://aws-sdk-core//lib/aws-sdk-sts.rb#57
Aws::STS::GEM_VERSION = T.let(T.unsafe(nil), String)

module Aws::STS::Plugins; end

class Aws::STS::Plugins::Endpoints < ::Seahorse::Client::Plugin
  # source://aws-sdk-core//lib/aws-sdk-sts/plugins/endpoints.rb#79
  def add_handlers(handlers, _config); end
end

# @api private
class Aws::STS::Plugins::Endpoints::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/plugins/endpoints.rb#27
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/plugins/endpoints.rb#46
  def apply_endpoint_headers(context, headers); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/plugins/endpoints.rb#57
  def parameters_for_operation(context); end
end

class Aws::STS::Plugins::STSRegionalEndpoints < ::Seahorse::Client::Plugin
  class << self
    # source://aws-sdk-core//lib/aws-sdk-sts/plugins/sts_regional_endpoints.rb#22
    def resolve_sts_regional_endpoints(cfg); end
  end
end

# Allows you to create presigned URLs for STS operations.
#
# @example
#
#   signer = Aws::STS::Presigner.new
#   url = signer.get_caller_identity_presigned_url(
#   headers: {"X-K8s-Aws-Id" => 'my-eks-cluster'}
#   )
class Aws::STS::Presigner
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Presigner] a new instance of Presigner
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/presigner.rb#18
  def initialize(options = T.unsafe(nil)); end

  # Returns a presigned url for get_caller_identity.
  #
  # This can be easily converted to a token used by the EKS service:
  # {https://ruby-doc.org/stdlib-2.3.1/libdoc/base64/rdoc/Base64.html#method-i-encode64}
  # "k8s-aws-v1." + Base64.urlsafe_encode64(url).chomp("==")
  #
  # @example
  #
  #   url = signer.get_caller_identity_presigned_url(
  #   headers: {"X-K8s-Aws-Id" => 'my-eks-cluster'},
  #   )
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [String] A presigned url string.
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/presigner.rb#40
  def get_caller_identity_presigned_url(options = T.unsafe(nil)); end
end

class Aws::STS::Resource
  # @option options
  # @param options [{}]
  # @return [Resource] a new instance of Resource
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/resource.rb#16
  def initialize(options = T.unsafe(nil)); end

  # @return [Client]
  #
  # source://aws-sdk-core//lib/aws-sdk-sts/resource.rb#21
  def client; end
end

module Aws::STS::Types; end

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleRequest AWS API Documentation
class Aws::STS::Types::AssumeRoleRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#304
Aws::STS::Types::AssumeRoleRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the response to a successful AssumeRole request, including
# temporary Amazon Web Services credentials that can be used to make
# Amazon Web Services requests.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleResponse AWS API Documentation
class Aws::STS::Types::AssumeRoleResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#370
Aws::STS::Types::AssumeRoleResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithSAMLRequest AWS API Documentation
class Aws::STS::Types::AssumeRoleWithSAMLRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#511
Aws::STS::Types::AssumeRoleWithSAMLRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the response to a successful AssumeRoleWithSAML request,
# including temporary Amazon Web Services credentials that can be used
# to make Amazon Web Services requests.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithSAMLResponse AWS API Documentation
class Aws::STS::Types::AssumeRoleWithSAMLResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#627
Aws::STS::Types::AssumeRoleWithSAMLResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithWebIdentityRequest AWS API Documentation
class Aws::STS::Types::AssumeRoleWithWebIdentityRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#783
Aws::STS::Types::AssumeRoleWithWebIdentityRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the response to a successful AssumeRoleWithWebIdentity
# request, including temporary Amazon Web Services credentials that can
# be used to make Amazon Web Services requests.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumeRoleWithWebIdentityResponse AWS API Documentation
class Aws::STS::Types::AssumeRoleWithWebIdentityResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#884
Aws::STS::Types::AssumeRoleWithWebIdentityResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The identifiers for the temporary security credentials that the
# operation returns.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumedRoleUser AWS API Documentation
class Aws::STS::Types::AssumedRoleUser < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#913
Aws::STS::Types::AssumedRoleUser::SENSITIVE = T.let(T.unsafe(nil), Array)

# Amazon Web Services credentials for API authentication.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/Credentials AWS API Documentation
class Aws::STS::Types::Credentials < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#944
Aws::STS::Types::Credentials::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/DecodeAuthorizationMessageRequest AWS API Documentation
class Aws::STS::Types::DecodeAuthorizationMessageRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#956
Aws::STS::Types::DecodeAuthorizationMessageRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# A document that contains additional information about the
# authorization status of a request from an encoded message that is
# returned in response to an Amazon Web Services request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/DecodeAuthorizationMessageResponse AWS API Documentation
class Aws::STS::Types::DecodeAuthorizationMessageResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#972
Aws::STS::Types::DecodeAuthorizationMessageResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The web identity token that was passed is expired or is not valid. Get
# a new identity token from the identity provider and then retry the
# request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/ExpiredTokenException AWS API Documentation
class Aws::STS::Types::ExpiredTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#987
Aws::STS::Types::ExpiredTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# Identifiers for the federated user that is associated with the
# credentials.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/FederatedUser AWS API Documentation
class Aws::STS::Types::FederatedUser < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1014
Aws::STS::Types::FederatedUser::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetAccessKeyInfoRequest AWS API Documentation
class Aws::STS::Types::GetAccessKeyInfoRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1030
Aws::STS::Types::GetAccessKeyInfoRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetAccessKeyInfoResponse AWS API Documentation
class Aws::STS::Types::GetAccessKeyInfoResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1042
Aws::STS::Types::GetAccessKeyInfoResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @api private
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetCallerIdentityRequest AWS API Documentation
class Aws::STS::Types::GetCallerIdentityRequest < ::Aws::EmptyStructure; end

# Contains the response to a successful GetCallerIdentity request,
# including information about the entity making the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetCallerIdentityResponse AWS API Documentation
class Aws::STS::Types::GetCallerIdentityResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1082
Aws::STS::Types::GetCallerIdentityResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetFederationTokenRequest AWS API Documentation
class Aws::STS::Types::GetFederationTokenRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1256
Aws::STS::Types::GetFederationTokenRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the response to a successful GetFederationToken request,
# including temporary Amazon Web Services credentials that can be used
# to make Amazon Web Services requests.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetFederationTokenResponse AWS API Documentation
class Aws::STS::Types::GetFederationTokenResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1295
Aws::STS::Types::GetFederationTokenResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetSessionTokenRequest AWS API Documentation
class Aws::STS::Types::GetSessionTokenRequest < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1343
Aws::STS::Types::GetSessionTokenRequest::SENSITIVE = T.let(T.unsafe(nil), Array)

# Contains the response to a successful GetSessionToken request,
# including temporary Amazon Web Services credentials that can be used
# to make Amazon Web Services requests.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetSessionTokenResponse AWS API Documentation
class Aws::STS::Types::GetSessionTokenResponse < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1366
Aws::STS::Types::GetSessionTokenResponse::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request could not be fulfilled because the identity provider (IDP)
# that was asked to verify the incoming identity token could not be
# reached. This is often a transient error caused by network conditions.
# Retry the request a limited number of times so that you don't exceed
# the request rate. If the error persists, the identity provider might
# be down or not responding.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/IDPCommunicationErrorException AWS API Documentation
class Aws::STS::Types::IDPCommunicationErrorException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1384
Aws::STS::Types::IDPCommunicationErrorException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The identity provider (IdP) reported that authentication failed. This
# might be because the claim is invalid.
#
# If this error is returned for the `AssumeRoleWithWebIdentity`
# operation, it can also mean that the claim has expired or has been
# explicitly revoked.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/IDPRejectedClaimException AWS API Documentation
class Aws::STS::Types::IDPRejectedClaimException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1402
Aws::STS::Types::IDPRejectedClaimException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The error returned if the message passed to
# `DecodeAuthorizationMessage` was invalid. This can happen if the token
# contains invalid characters, such as linebreaks.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/InvalidAuthorizationMessageException AWS API Documentation
class Aws::STS::Types::InvalidAuthorizationMessageException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1417
Aws::STS::Types::InvalidAuthorizationMessageException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The web identity token that was passed could not be validated by
# Amazon Web Services. Get a new identity token from the identity
# provider and then retry the request.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/InvalidIdentityTokenException AWS API Documentation
class Aws::STS::Types::InvalidIdentityTokenException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1432
Aws::STS::Types::InvalidIdentityTokenException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the policy document was malformed.
# The error message describes the specific error.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/MalformedPolicyDocumentException AWS API Documentation
class Aws::STS::Types::MalformedPolicyDocumentException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1446
Aws::STS::Types::MalformedPolicyDocumentException::SENSITIVE = T.let(T.unsafe(nil), Array)

# The request was rejected because the total packed size of the session
# policies and session tags combined was too large. An Amazon Web
# Services conversion compresses the session policy document, session
# policy ARNs, and session tags into a packed binary format that has a
# separate limit. The error message indicates by percentage how close
# the policies and tags are to the upper size limit. For more
# information, see [Passing Session Tags in STS][1] in the *IAM User
# Guide*.
#
# You could receive this error even though you meet other defined
# session policy and session tag limits. For more information, see [IAM
# and STS Entity Character Limits][2] in the *IAM User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
# [2]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/PackedPolicyTooLargeException AWS API Documentation
class Aws::STS::Types::PackedPolicyTooLargeException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1475
Aws::STS::Types::PackedPolicyTooLargeException::SENSITIVE = T.let(T.unsafe(nil), Array)

# A reference to the IAM managed policy that is passed as a session
# policy for a role session or a federated user session.
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/PolicyDescriptorType AWS API Documentation
class Aws::STS::Types::PolicyDescriptorType < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1497
Aws::STS::Types::PolicyDescriptorType::SENSITIVE = T.let(T.unsafe(nil), Array)

# STS is not activated in the requested region for the account that is
# being asked to generate credentials. The account administrator must
# use the IAM console to activate STS in that region. For more
# information, see [Activating and Deactivating Amazon Web Services STS
# in an Amazon Web Services Region][1] in the *IAM User Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/RegionDisabledException AWS API Documentation
class Aws::STS::Types::RegionDisabledException < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1518
Aws::STS::Types::RegionDisabledException::SENSITIVE = T.let(T.unsafe(nil), Array)

# You can pass custom key-value pair attributes when you assume a role
# or federate a user. These are called session tags. You can then use
# the session tags to control access to resources. For more information,
# see [Tagging Amazon Web Services STS Sessions][1] in the *IAM User
# Guide*.
#
#
#
# [1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
#
# @see http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/Tag AWS API Documentation
class Aws::STS::Types::Tag < ::Struct
  include ::Aws::Structure
end

# source://aws-sdk-core//lib/aws-sdk-sts/types.rb#1561
Aws::STS::Types::Tag::SENSITIVE = T.let(T.unsafe(nil), Array)

# @api private
class Aws::SharedConfig
  # Constructs a new SharedConfig provider object. This will load the shared
  # credentials file, and optionally the shared configuration file, as ini
  # files which support profiles.
  #
  # By default, the shared credential file (the default path for which is
  # `~/.aws/credentials`) and the shared config file (the default path for
  # which is `~/.aws/config`) are loaded. However, if you set the
  # `ENV['AWS_SDK_CONFIG_OPT_OUT']` environment variable, only the shared
  # credential file will be loaded. You can specify the shared credential
  # file path with the `ENV['AWS_SHARED_CREDENTIALS_FILE']` environment
  # variable or with the `:credentials_path` option. Similarly, you can
  # specify the shared config file path with the `ENV['AWS_CONFIG_FILE']`
  # environment variable or with the `:config_path` option.
  #
  # The default profile name is 'default'. You can specify the profile name
  # with the `ENV['AWS_PROFILE']` environment variable or with the
  # `:profile_name` option.
  #
  # @api private
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash]
  # @return [SharedConfig] a new instance of SharedConfig
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#52
  def initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def adaptive_retry_wait_to_fill(opts = T.unsafe(nil)); end

  # Attempts to assume a role from shared config or shared credentials file.
  # Will always attempt first to assume a role from the shared credentials
  # file, if present.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#120
  def assume_role_credentials_from_config(opts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#130
  def assume_role_web_identity_credentials_from_config(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def ca_bundle(opts = T.unsafe(nil)); end

  # @api private
  # @return [Boolean] returns `true` if use of the shared config file is
  #   enabled.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#96
  def config_enabled?; end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#16
  def config_path; end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def correct_clock_skew(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def credential_process(opts = T.unsafe(nil)); end

  # Sources static credentials from shared credential/config files.
  #
  # @api private
  # @option options
  # @param opts [Hash]
  # @param options [Hash] a customizable set of options
  # @return [Aws::Credentials] credentials sourced from configuration values,
  #   or `nil` if no valid credentials were found.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#107
  def credentials(opts = T.unsafe(nil)); end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#13
  def credentials_path; end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def csm_client_id(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def csm_enabled(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def csm_host(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def csm_port(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def defaults_mode(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def ec2_metadata_service_endpoint(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def ec2_metadata_service_endpoint_mode(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def endpoint_discovery_enabled(opts = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#69
  def fresh(options = T.unsafe(nil)); end

  # @api private
  # @note This method does not indicate if the file found at {#path}
  #   will be parsable, only if it can be read.
  # @return [Boolean] Returns `true` if a credential file
  #   exists and has appropriate read permissions at {#path}.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#90
  def loadable?(path); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def max_attempts(opts = T.unsafe(nil)); end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#19
  def profile_name; end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def region(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def retry_mode(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def s3_disable_multiregion_access_points(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def s3_us_east_1_regional_endpoint(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def s3_use_arn_region(opts = T.unsafe(nil)); end

  # Attempts to load from shared config or shared credentials file.
  # Will always attempt first to load from the shared credentials
  # file, if present.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#149
  def sso_credentials_from_config(opts = T.unsafe(nil)); end

  # Attempts to load from shared config or shared credentials file.
  # Will always attempt first to load from the shared credentials
  # file, if present.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#161
  def sso_token_from_config(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def sts_regional_endpoints(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def use_dualstack_endpoint(opts = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#175
  def use_fips_endpoint(opts = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#216
  def assume_role_from_profile(cfg, profile, opts, chain_config); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#309
  def assume_role_process_credentials_from_config(profile); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#324
  def credentials_from_config(profile, _opts); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#399
  def credentials_from_profile(prof_config); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#318
  def credentials_from_shared(profile, _opts); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#294
  def credentials_from_source(credential_source, config); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#426
  def default_shared_config_path(file); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#422
  def determine_config_path; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#418
  def determine_credentials_path; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#442
  def determine_profile(options); end

  # Get a config value from from shared credential/config files.
  # Only loads a value when config_enabled is true
  # Return a value from credentials preferentially over config
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#208
  def get_config_value(key, opts); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#414
  def load_config_file; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#408
  def load_credentials_file; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#269
  def resolve_source_profile(profile, opts = T.unsafe(nil)); end

  # If any of the sso_ profile values are present, attempt to construct
  # SSOCredentials
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#332
  def sso_credentials_from_profile(cfg, profile); end

  # If the required sso_ profile values are present, attempt to construct
  # SSOTokenProvider
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#375
  def sso_token_from_profile(cfg, profile); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#433
  def validate_profile_exists(profile); end

  class << self
    # Add an accessor method (similar to attr_reader) to return a configuration value
    # Uses the get_config_value below to control where
    # values are loaded from
    #
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#173
    def config_reader(*attrs); end
  end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#6
Aws::SharedConfig::SSO_CREDENTIAL_PROFILE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#7
Aws::SharedConfig::SSO_PROFILE_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#9
Aws::SharedConfig::SSO_SESSION_KEYS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/shared_config.rb#8
Aws::SharedConfig::SSO_TOKEN_PROFILE_KEYS = T.let(T.unsafe(nil), Array)

class Aws::SharedCredentials
  include ::Aws::CredentialProvider

  # Constructs a new SharedCredentials object. This will load static
  # (access_key_id, secret_access_key and session_token) AWS access
  # credentials from an ini file, which supports profiles. The default
  # profile name is 'default'. You can specify the profile name with the
  # `ENV['AWS_PROFILE']` or with the `:profile_name` option.
  #
  # To use credentials from the default credential resolution chain
  # create a client without the credential option specified.
  # You may access the resolved credentials through
  # `client.config.credentials`.
  #
  # @option [String]
  # @option [String]
  # @param [String] [Hash] a customizable set of options
  # @return [SharedCredentials] a new instance of SharedCredentials
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#34
  def initialize(options = T.unsafe(nil)); end

  # @return [Credentials]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#59
  def credentials; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#62
  def inspect; end

  # @deprecated This method is no longer used.
  # @note This method does not indicate if the file found at {#path}
  #   will be parsable, only if it can be read.
  # @return [Boolean] Returns `true` if a credential file
  #   exists and has appropriate read permissions at {#path}.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#76
  def loadable?; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#53
  def path; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#56
  def profile_name; end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/shared_credentials.rb#11
Aws::SharedCredentials::KEY_MAP = T.let(T.unsafe(nil), Hash)

class Aws::StaticTokenProvider
  include ::Aws::TokenProvider

  # @param token [String]
  # @param expiration [Time]
  # @return [StaticTokenProvider] a new instance of StaticTokenProvider
  #
  # source://aws-sdk-core//lib/aws-sdk-core/static_token_provider.rb#10
  def initialize(token, expiration = T.unsafe(nil)); end
end

# @api private
module Aws::Structure
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#7
  def initialize(values = T.unsafe(nil)); end

  # @api private
  # @return [Boolean] Returns `true` if all of the member values are `nil`.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#20
  def empty?; end

  # @api private
  # @return [Boolean] Returns `true` if this structure has a value
  #   set for the given member.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#15
  def key?(member_name); end

  # Deeply converts the Structure into a hash.  Structure members that
  # are `nil` are omitted from the resultant hash.
  #
  # You can call #orig_to_h to get vanilla #to_h behavior as defined
  # in stdlib Struct.
  #
  # @api private
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#31
  def to_h(obj = T.unsafe(nil), options = T.unsafe(nil)); end

  # Deeply converts the Structure into a hash.  Structure members that
  # are `nil` are omitted from the resultant hash.
  #
  # You can call #orig_to_h to get vanilla #to_h behavior as defined
  # in stdlib Struct.
  #
  # @api private
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#31
  def to_hash(obj = T.unsafe(nil), options = T.unsafe(nil)); end

  # Wraps the default #to_s logic with filtering of sensitive parameters.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#52
  def to_s(obj = T.unsafe(nil)); end

  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#59
    def new(*args); end
  end
end

# @api private
module Aws::Structure::Union
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#77
  def member; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/structure.rb#81
  def value; end
end

# @api private
module Aws::Stubbing; end

class Aws::Stubbing::DataApplicator
  include ::Seahorse::Model::Shapes

  # @param rules [Seahorse::Models::Shapes::ShapeRef]
  # @return [DataApplicator] a new instance of DataApplicator
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/data_applicator.rb#10
  def initialize(rules); end

  # @param data [Hash]
  # @param stub [Structure]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/data_applicator.rb#16
  def apply_data(data, stub); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/data_applicator.rb#22
  def apply_data_to_struct(ref, data, struct); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/data_applicator.rb#29
  def member_value(ref, value); end
end

class Aws::Stubbing::EmptyStub
  include ::Seahorse::Model::Shapes

  # @param rules [Seahorse::Models::Shapes::ShapeRef]
  # @return [EmptyStub] a new instance of EmptyStub
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/empty_stub.rb#10
  def initialize(rules); end

  # @return [Structure]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/empty_stub.rb#15
  def stub; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/empty_stub.rb#25
  def stub_ref(ref, visited = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/empty_stub.rb#49
  def stub_scalar(ref); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/empty_stub.rb#39
  def stub_structure(ref, visited); end
end

module Aws::Stubbing::Protocols; end
class Aws::Stubbing::Protocols::ApiGateway < ::Aws::Stubbing::Protocols::RestJson; end

class Aws::Stubbing::Protocols::EC2
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/ec2.rb#8
  def stub_data(api, operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/ec2.rb#18
  def stub_error(error_code); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/ec2.rb#34
  def build_body(api, operation, data); end
end

class Aws::Stubbing::Protocols::Json
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/json.rb#8
  def stub_data(api, operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/json.rb#17
  def stub_error(error_code); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/json.rb#35
  def build_body(operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/json.rb#31
  def content_type(api); end
end

class Aws::Stubbing::Protocols::Query
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/query.rb#8
  def stub_data(api, operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/query.rb#15
  def stub_error(error_code); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/query.rb#24
  def build_body(api, operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/query.rb#39
  def xmlns(api); end
end

class Aws::Stubbing::Protocols::Rest
  include ::Seahorse::Model::Shapes

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#12
  def stub_data(api, operation, data); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#41
  def apply_body(api, operation, resp, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#37
  def apply_headers(operation, resp, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#29
  def apply_status_code(operation, resp, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#45
  def build_body(api, operation, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#105
  def encode_error(opts, event_data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#185
  def encode_event(opts, rules, event_data, builder); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#85
  def encode_eventstream_response(rules, data, builder); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#135
  def encode_modeled_event(opts, rules, event_type, event_data, builder); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#121
  def encode_unknown_event(opts, event_type, event_data); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#81
  def eventstream?(rules); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#77
  def head_operation(operation); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#22
  def new_http_response; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest.rb#65
  def streaming?(ref); end
end

class Aws::Stubbing::Protocols::RestJson < ::Aws::Stubbing::Protocols::Rest
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest_json.rb#8
  def body_for(_a, _b, rules, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest_json.rb#16
  def stub_error(error_code); end
end

class Aws::Stubbing::Protocols::RestXml < ::Aws::Stubbing::Protocols::Rest
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest_xml.rb#8
  def body_for(api, operation, rules, data); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest_xml.rb#20
  def stub_error(error_code); end

  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/protocols/rest_xml.rb#27
  def xmlns(api); end
end

# @api private
class Aws::Stubbing::StubData
  # @api private
  # @return [StubData] a new instance of StubData
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/stub_data.rb#8
  def initialize(operation); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/stub_data.rb#13
  def stub(data = T.unsafe(nil)); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/stub_data.rb#43
  def apply_data(data, stub); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/stub_data.rb#22
  def remove_paging_tokens(stub); end
end

# @api private
class Aws::Stubbing::XmlError
  # @api private
  # @return [XmlError] a new instance of XmlError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/xml_error.rb#7
  def initialize(error_code); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/stubbing/xml_error.rb#11
  def to_xml; end
end

class Aws::Token
  # @param token [String]
  # @param expiration [Time]
  # @return [Token] a new instance of Token
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token.rb#8
  def initialize(token, expiration = T.unsafe(nil)); end

  # @return [Time, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token.rb#17
  def expiration; end

  # Removing the token from the default inspect string.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token.rb#26
  def inspect; end

  # @return [Boolean] Returns `true` if token is set
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token.rb#20
  def set?; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token.rb#14
  def token; end
end

module Aws::TokenProvider
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider.rb#10
  def set?; end

  # @return [Token]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider.rb#7
  def token; end
end

# @api private
class Aws::TokenProviderChain
  # @api private
  # @return [TokenProviderChain] a new instance of TokenProviderChain
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#6
  def initialize(config = T.unsafe(nil)); end

  # @api private
  # @return [TokenProvider, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#11
  def resolve; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#46
  def determine_profile_name(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#21
  def providers; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#37
  def sso_token(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/token_provider_chain.rb#28
  def static_profile_sso_token(options); end
end

# @api private
class Aws::TypeBuilder
  # @api private
  # @return [TypeBuilder] a new instance of TypeBuilder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/type_builder.rb#7
  def initialize(svc_module); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/type_builder.rb#11
  def build_type(shape, shapes); end
end

# @api private
module Aws::Util
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#18
    def copy_hash(hash); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#26
    def deep_copy(obj); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#10
    def deep_merge(left, right); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#49
    def monotonic_milliseconds; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#57
    def monotonic_seconds; end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/util.rb#61
    def str_2_bool(str); end
  end
end

module Aws::Waiters; end
module Aws::Waiters::Errors; end

class Aws::Waiters::Errors::FailureStateError < ::Aws::Waiters::Errors::WaiterFailed
  # @return [FailureStateError] a new instance of FailureStateError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#15
  def initialize(response); end

  # @return [Seahorse::Client::Response] The response that matched
  #   the failure state.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#22
  def response; end
end

# source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#13
Aws::Waiters::Errors::FailureStateError::MSG = T.let(T.unsafe(nil), String)

# Raised when attempting to get a waiter by name and the waiter has not
# been defined.
class Aws::Waiters::Errors::NoSuchWaiterError < ::ArgumentError
  # @return [NoSuchWaiterError] a new instance of NoSuchWaiterError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#60
  def initialize(waiter_name, waiter_names); end
end

# source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#58
Aws::Waiters::Errors::NoSuchWaiterError::MSG = T.let(T.unsafe(nil), String)

class Aws::Waiters::Errors::TooManyAttemptsError < ::Aws::Waiters::Errors::WaiterFailed
  # @return [TooManyAttemptsError] a new instance of TooManyAttemptsError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#30
  def initialize(attempts); end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#36
  def attempts; end
end

# source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#28
Aws::Waiters::Errors::TooManyAttemptsError::MSG = T.let(T.unsafe(nil), String)

class Aws::Waiters::Errors::UnexpectedError < ::Aws::Waiters::Errors::WaiterFailed
  # @return [UnexpectedError] a new instance of UnexpectedError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#44
  def initialize(error); end

  # @return [Exception] The unexpected error.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#50
  def error; end
end

# source://aws-sdk-core//lib/aws-sdk-core/waiters/errors.rb#42
Aws::Waiters::Errors::UnexpectedError::MSG = T.let(T.unsafe(nil), String)

# Raised when a waiter detects a condition where the waiter can never
# succeed.
class Aws::Waiters::Errors::WaiterFailed < ::StandardError; end

# Polls a single API operation inspecting the response data and/or error
# for states matching one of its acceptors.
#
# @api private
class Aws::Waiters::Poller
  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Poller] a new instance of Poller
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#17
  def initialize(options = T.unsafe(nil)); end

  # Makes an API call, returning the resultant state and the response.
  #
  # * `:success` - A success state has been matched.
  # * `:failure` - A terminate failure state has been matched.
  # * `:retry`   - The waiter may be retried.
  # * `:error`   - The waiter encountered an un-expected error.
  #
  # @api private
  # @example A trival (bad) example of a waiter that polls indefinetly.
  #
  #   loop do
  #
  #   state, resp = poller.call(client:client, params:{})
  #
  #   case state
  #   when :success then return true
  #   when :failure then return false
  #   when :retry   then next
  #   when :error   then raise 'oops'
  #   end
  #
  #   end
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Array<Symbol,Response>]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#50
  def call(options = T.unsafe(nil)); end

  # @api private
  # @return [Symbol]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#23
  def operation_name; end

  private

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#68
  def acceptor_matches?(acceptor, response); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#96
  def matches_error?(acceptor, response); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#72
  def matches_path?(acceptor, response); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#80
  def matches_pathAll?(acceptor, response); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#86
  def matches_pathAny?(acceptor, response); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#92
  def matches_status?(acceptor, response); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#105
  def non_empty_array(acceptor, response, &block); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#101
  def path(acceptor); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#62
  def send_request(options); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/waiters/poller.rb#12
Aws::Waiters::Poller::RAISE_HANDLER = Seahorse::Client::Plugins::RaiseResponseErrors::Handler

# @api private
class Aws::Waiters::Waiter
  # @api private
  # @return [Waiter] a new instance of Waiter
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#12
  def initialize(options = T.unsafe(nil)); end

  # Register a callback that is invoked before every polling attempt.
  # Yields the number of attempts made so far.
  #
  #     waiter.before_attempt do |attempts|
  #       puts "#{attempts} made, about to make attempt #{attempts + 1}"
  #     end
  #
  # Throwing `:success` or `:failure` from the given block will stop
  # the waiter and return or raise. You can pass a custom message to the
  # throw:
  #
  #     # raises Aws::Waiters::Errors::WaiterFailed
  #     waiter.before_attempt do |attempts|
  #       throw :failure, 'custom-error-message'
  #     end
  #
  #     # cause the waiter to stop polling and return
  #     waiter.before_attempt do |attempts|
  #       throw :success
  #     end
  #
  # @api private
  # @yieldparam attempts [Integer] The number of attempts made.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#54
  def before_attempt(&block); end

  # Register a callback that is invoked after an attempt but before
  # sleeping. Yields the number of attempts made and the previous response.
  #
  #     waiter.before_wait do |attempts, response|
  #       puts "#{attempts} made"
  #       puts response.error.inspect
  #       puts response.data.inspect
  #     end
  #
  # Throwing `:success` or `:failure` from the given block will stop
  # the waiter and return or raise. You can pass a custom message to the
  # throw:
  #
  #     # raises Aws::Waiters::Errors::WaiterFailed
  #     waiter.before_attempt do |attempts|
  #       throw :failure, 'custom-error-message'
  #     end
  #
  #     # cause the waiter to stop polling and return
  #     waiter.before_attempt do |attempts|
  #       throw :success
  #     end
  #
  # @api private
  # @yieldparam attempts [Integer] The number of attempts already made.
  # @yieldparam response [Seahorse::Client::Response] The response from
  #   the previous polling attempts.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#85
  def before_wait(&block); end

  # @api private
  # @return [Float]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#27
  def delay; end

  # @api private
  # @return [Float]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#27
  def delay=(_arg0); end

  # @api private
  # @return [Float]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#27
  def interval; end

  # @api private
  # @return [Float]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#27
  def interval=(_arg0); end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#24
  def max_attempts; end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#24
  def max_attempts=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#21
  def poller; end

  # @api private
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#91
  def wait(options); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#102
  def poll(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#124
  def trigger_before_attempt(attempts); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#128
  def trigger_before_wait(attempts, response); end
end

# @api private
#
# source://aws-sdk-core//lib/aws-sdk-core/waiters/waiter.rb#9
Aws::Waiters::Waiter::RAISE_HANDLER = Seahorse::Client::Plugins::RaiseResponseErrors::Handler

# @api private
module Aws::Xml; end

class Aws::Xml::Builder
  include ::Seahorse::Model::Shapes

  # @return [Builder] a new instance of Builder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#11
  def initialize(rules, options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#19
  def serialize(params); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#19
  def to_xml(params); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#99
  def blob(value); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#50
  def list(name, ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#65
  def map(name, ref, hash); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#87
  def member(name, ref, value); end

  # The `args` list may contain:
  #
  #   * [] - empty, no value or attributes
  #   * [value] - inline element, no attributes
  #   * [value, attributes_hash] - inline element with attributes
  #   * [attributes_hash] - self closing element with attributes
  #
  # Pass a block if you want to nest XML nodes inside.  When doing this,
  # you may *not* pass a value to the `args` list.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#124
  def node(name, ref, *args, &block); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#131
  def shape_attrs(ref); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#27
  def structure(name, ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#41
  def structure_attrs(ref, values); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#104
  def timestamp(ref, value); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/builder.rb#143
  def xml_attribute?(ref); end
end

# @api private
class Aws::Xml::DefaultList < ::Array
  # @api private
  def nil?; end
end

# @api private
class Aws::Xml::DefaultMap < ::Hash
  # @api private
  def nil?; end
end

class Aws::Xml::DocBuilder
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [DocBuilder] a new instance of DocBuilder
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#10
  def initialize(options = T.unsafe(nil)); end

  # @overload node
  # @overload node
  # @overload node
  # @return [void]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#36
  def node(name, *args, &block); end

  # Returns the value of attribute target.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#21
  def target; end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#78
  def attributes(attr); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#65
  def close_el(name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#53
  def empty_element(name, attrs); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#69
  def escape(string, text_or_attr); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#88
  def increase_pad(&block); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#57
  def inline_element(name, value, attrs); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/doc_builder.rb#61
  def open_el(name, attrs); end
end

class Aws::Xml::ErrorHandler < ::Seahorse::Client::Handler
  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#9
  def call(context); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#18
  def error(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#61
  def error_code(body, context); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#42
  def error_data(context, code); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#90
  def error_message(body); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#33
  def extract_error(body, context); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#69
  def http_status_error_code(context); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#82
  def remove_prefix(error_code, context); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#98
  def request_id(body); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/error_handler.rb#104
  def unescape(str); end
end

# A SAX-style XML parser that uses a shape context to handle types.
#
# @api private
class Aws::Xml::Parser
  include ::Seahorse::Model::Shapes

  # @api private
  # @param rules [Seahorse::Model::ShapeRef]
  # @return [Parser] a new instance of Parser
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#10
  def initialize(rules, options = T.unsafe(nil)); end

  # Parses the XML document, returning a parsed structure.
  #
  # If you pass a block, this will yield for XML
  # elements that are not modeled in the rules given
  # to the constructor.
  #
  #   parser.parse(xml) do |path, value|
  #     puts "uhandled: #{path.join('/')} - #{value}"
  #   end
  #
  # The purpose of the unhandled callback block is to
  # allow callers to access values such as the EC2
  # request ID that are part of the XML body but not
  # part of the operation result.
  #
  # @api private
  # @param xml [String] An XML document string to parse.
  # @param target [Structure] (nil)
  # @return [Structure]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#33
  def parse(xml, target = T.unsafe(nil), &unhandled_callback); end

  class << self
    # @api private
    # @return [Class] Returns the default parsing engine.
    #   One of:
    #
    #   * {OxEngine}
    #   * {OgaEngine}
    #   * {LibxmlEngine}
    #   * {NokogiriEngine}
    #   * {RexmlEngine}
    #
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#64
    def engine; end

    # @api private
    # @param engine [Symbol, Class] Must be one of the following values:
    #
    #   * :ox
    #   * :oga
    #   * :libxml
    #   * :nokogiri
    #   * :rexml
    #
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#51
    def engine=(engine); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#69
    def set_default_engine; end

    private

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#82
    def load_engine(name); end

    # @api private
    #
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser.rb#88
    def try_load_engine(name); end
  end
end

class Aws::Xml::Parser::BlobFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#268
  def result; end
end

class Aws::Xml::Parser::BooleanFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#274
  def result; end
end

# source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#317
Aws::Xml::Parser::FRAME_CLASSES = T.let(T.unsafe(nil), Hash)

class Aws::Xml::Parser::FlatListFrame < ::Aws::Xml::Parser::Frame
  # @return [FlatListFrame] a new instance of FlatListFrame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#178
  def initialize(xml_name, *args); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#191
  def child_frame(xml_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#195
  def consume_child_frame(child); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#183
  def result; end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#187
  def set_text(value); end
end

class Aws::Xml::Parser::FloatFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#280
  def result; end
end

class Aws::Xml::Parser::Frame
  include ::Seahorse::Model::Shapes

  # @return [Frame] a new instance of Frame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#40
  def initialize(path, parent, ref, result); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#58
  def child_frame(xml_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#62
  def consume_child_frame(child); end

  # Returns the value of attribute parent.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#48
  def parent; end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#65
  def path; end

  # Returns the value of attribute ref.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#50
  def ref; end

  # Returns the value of attribute result.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#52
  def result; end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#54
  def set_text(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#74
  def yield_unhandled_value(path, value); end

  class << self
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#15
    def new(path, parent, ref, result = T.unsafe(nil)); end

    private

    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#27
    def frame_class(ref); end
  end
end

class Aws::Xml::Parser::IntegerFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#286
  def result; end
end

class Aws::Xml::Parser::ListFrame < ::Aws::Xml::Parser::Frame
  # @return [ListFrame] a new instance of ListFrame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#156
  def initialize(*args); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#162
  def child_frame(xml_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#170
  def consume_child_frame(child); end
end

class Aws::Xml::Parser::MapEntryFrame < ::Aws::Xml::Parser::Frame
  # @return [MapEntryFrame] a new instance of MapEntryFrame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#224
  def initialize(xml_name, *args); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#238
  def child_frame(xml_name); end

  # @return [StringFrame]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#233
  def key; end

  # @return [Frame]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#236
  def value; end
end

class Aws::Xml::Parser::MapFrame < ::Aws::Xml::Parser::Frame
  # @return [MapFrame] a new instance of MapFrame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#203
  def initialize(*args); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#208
  def child_frame(xml_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#216
  def consume_child_frame(child); end
end

class Aws::Xml::Parser::NokogiriEngine
  # @return [NokogiriEngine] a new instance of NokogiriEngine
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#10
  def initialize(stack); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#32
  def characters(chars); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#21
  def comment(*args); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#20
  def end_document; end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#36
  def end_element_namespace(*ignored); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#40
  def error(msg); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#14
  def parse(xml); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#19
  def start_document; end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#23
  def start_element_namespace(element_name, attributes = T.unsafe(nil), *ignored); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/engines/nokogiri.rb#18
  def xmldecl(*args); end
end

class Aws::Xml::Parser::NullFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#255
  def set_text(value); end

  class << self
    # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#251
    def new(xml_name, parent); end
  end
end

class Aws::Xml::Parser::ParsingError < ::RuntimeError
  # @return [ParsingError] a new instance of ParsingError
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/parsing_error.rb#8
  def initialize(msg, line, column); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/parsing_error.rb#16
  def column; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/parsing_error.rb#13
  def line; end
end

class Aws::Xml::Parser::Stack
  # @return [Stack] a new instance of Stack
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#8
  def initialize(ref, result = T.unsafe(nil), &unhandled_callback); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#23
  def attr(name, value); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#50
  def child_frame(name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#54
  def consume_child_frame(frame); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#37
  def end_element(*args); end

  # @raise [ParsingError]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#46
  def error(msg, line = T.unsafe(nil), column = T.unsafe(nil)); end

  # Returns the value of attribute frame.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#15
  def frame; end

  # Returns the value of attribute result.
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#17
  def result; end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#19
  def start_element(name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#33
  def text(value); end

  # @api private
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/stack.rb#59
  def yield_unhandled_value(path, value); end
end

class Aws::Xml::Parser::StringFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#292
  def result; end
end

class Aws::Xml::Parser::StructureFrame < ::Aws::Xml::Parser::Frame
  # @return [StructureFrame] a new instance of StructureFrame
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#82
  def initialize(xml_name, parent, ref, result = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#95
  def child_frame(xml_name); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#105
  def consume_child_frame(child); end

  private

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#133
  def apply_default_value(name, ref); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#148
  def flattened_list?(ref); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#140
  def xml_name(ref); end
end

class Aws::Xml::Parser::TimestampFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#301
  def parse(value); end

  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#298
  def result; end
end

class Aws::Xml::Parser::UnknownMemberFrame < ::Aws::Xml::Parser::Frame
  # source://aws-sdk-core//lib/aws-sdk-core/xml/parser/frame.rb#262
  def result; end
end

module Seahorse; end
module Seahorse::Client; end

class Seahorse::Client::AsyncBase < ::Seahorse::Client::Base
  # @return [AsyncBase] a new instance of AsyncBase
  #
  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#14
  def initialize(plugins, options); end

  # Closes the underlying HTTP2 Connection for the client
  #
  # @return [Symbol] Returns the status of the connection (:closed)
  #
  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#31
  def close_connection; end

  # @return [H2::Connection]
  #
  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#21
  def connection; end

  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#45
  def connection_errors; end

  # Creates a new HTTP2 Connection for the client
  #
  # @return [Seahorse::Client::H2::Connection]
  #
  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#37
  def new_connection; end

  # @return [Array<Symbol>] Returns a list of valid async request
  #   operation names.
  #
  # source://aws-sdk-core//lib/seahorse/client/async_base.rb#25
  def operation_names; end
end

class Seahorse::Client::AsyncResponse
  # @return [AsyncResponse] a new instance of AsyncResponse
  #
  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#7
  def initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#15
  def context; end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#19
  def error; end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#50
  def join!; end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#23
  def on(range, &block); end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#28
  def on_complete(&block); end

  # source://aws-sdk-core//lib/seahorse/client/async_response.rb#33
  def wait; end
end

class Seahorse::Client::Base
  include ::Seahorse::Client::HandlerBuilder

  # @api private
  # @return [Base] a new instance of Base
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#21
  def initialize(plugins, options); end

  # Builds and returns a {Request} for the named operation.  The request
  # will not have been sent.
  #
  # @param operation_name [Symbol, String]
  # @return [Request]
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#37
  def build_request(operation_name, params = T.unsafe(nil)); end

  # @return [Configuration<Struct>]
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#28
  def config; end

  # @return [HandlerList]
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#31
  def handlers; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#44
  def inspect; end

  # @return [Array<Symbol>] Returns a list of valid request operation
  #   names. These are valid arguments to {#build_request} and are also
  #   valid methods.
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#51
  def operation_names; end

  private

  # Gives each plugin the opportunity to modify this client.
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#79
  def after_initialize(plugins); end

  # Constructs a {Configuration} object and gives each plugin the
  # opportunity to register options with default values.
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#59
  def build_config(plugins, options); end

  # Gives each plugin the opportunity to register handlers for this client.
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#69
  def build_handler_list(plugins); end

  # @return [RequestContext]
  #
  # source://aws-sdk-core//lib/seahorse/client/base.rb#86
  def context_for(operation_name, params); end

  class << self
    # Registers a plugin with this client.
    #
    # @example Register a plugin
    #
    #   ClientClass.add_plugin(PluginClass)
    # @example Register a plugin by name
    #
    #   ClientClass.add_plugin('gem-name.PluginClass')
    # @example Register a plugin with an object
    #
    #   plugin = MyPluginClass.new(options)
    #   ClientClass.add_plugin(plugin)
    # @param plugin [Class, Symbol, String, Object]
    # @return [void]
    # @see .clear_plugins
    # @see .set_plugins
    # @see .remove_plugin
    # @see .plugins
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#127
    def add_plugin(plugin); end

    # @return [Model::Api]
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#171
    def api; end

    # @return [void]
    # @see .set_plugins
    # @see .add_plugin
    # @see .remove_plugin
    # @see .plugins
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#145
    def clear_plugins; end

    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [Class<Client::Base>]
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#187
    def define(options = T.unsafe(nil)); end

    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [Class<Client::Base>]
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#187
    def extend(options = T.unsafe(nil)); end

    # source://aws-sdk-core//lib/seahorse/client/base.rb#97
    def new(options = T.unsafe(nil)); end

    # Returns the list of registered plugins for this Client.  Plugins are
    # inherited from the client super class when the client is defined.
    #
    # @return [Array<Plugin>]
    # @see .clear_plugins
    # @see .set_plugins
    # @see .add_plugin
    # @see .remove_plugin
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#166
    def plugins; end

    # @return [void]
    # @see .clear_plugins
    # @see .set_plugins
    # @see .add_plugin
    # @see .plugins
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#136
    def remove_plugin(plugin); end

    # @param api [Model::Api]
    # @return [Model::Api]
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#177
    def set_api(api); end

    # @param plugins [Array<Plugin>]
    # @return [void]
    # @see .clear_plugins
    # @see .add_plugin
    # @see .remove_plugin
    # @see .plugins
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#155
    def set_plugins(plugins); end

    private

    # source://aws-sdk-core//lib/seahorse/client/base.rb#215
    def before_initialize(plugins, options); end

    # source://aws-sdk-core//lib/seahorse/client/base.rb#211
    def build_plugins; end

    # source://aws-sdk-core//lib/seahorse/client/base.rb#199
    def define_operation_methods; end

    # @private
    #
    # source://aws-sdk-core//lib/seahorse/client/base.rb#221
    def inherited(subclass); end
  end
end

class Seahorse::Client::BlockIO
  # @return [BlockIO] a new instance of BlockIO
  #
  # source://aws-sdk-core//lib/seahorse/client/block_io.rb#7
  def initialize(headers = T.unsafe(nil), &block); end

  # @param bytes [Integer] (nil)
  # @param output_buffer [String] (nil)
  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/block_io.rb#24
  def read(bytes = T.unsafe(nil), output_buffer = T.unsafe(nil)); end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/block_io.rb#30
  def size; end

  # @param chunk [String]
  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/block_io.rb#15
  def write(chunk); end
end

# Configuration is used to define possible configuration options and
# then build read-only structures with user-supplied data.
#
# ## Adding Configuration Options
#
# Add configuration options with optional default values.  These are used
# when building configuration objects.
#
#     configuration = Configuration.new
#
#     configuration.add_option(:max_retries, 3)
#     configuration.add_option(:use_ssl, true)
#
#     cfg = configuration.build!
#     #=> #<struct max_retires=3 use_ssl=true>
#
# ## Building Configuration Objects
#
# Calling {#build!} on a {Configuration} object causes it to return
# a read-only (frozen) struct.  Options passed to {#build!} are merged
# on top of any default options.
#
#     configuration = Configuration.new
#     configuration.add_option(:color, 'red')
#
#     # default
#     cfg1 = configuration.build!
#     cfg1.color #=> 'red'
#
#     # supplied color
#     cfg2 = configuration.build!(color: 'blue')
#     cfg2.color #=> 'blue'
#
# ## Accepted Options
#
# If you try to {#build!} a {Configuration} object with an unknown
# option, an `ArgumentError` is raised.
#
#     configuration = Configuration.new
#     configuration.add_option(:color)
#     configuration.add_option(:size)
#     configuration.add_option(:category)
#
#     configuration.build!(price: 100)
#     #=> raises an ArgumentError, :price was not added as an option
class Seahorse::Client::Configuration
  # @api private
  # @return [Configuration] a new instance of Configuration
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#77
  def initialize; end

  # Adds a getter method that returns the named option or a default
  # value.  Default values can be passed as a static positional argument
  # or via a block.
  #
  #    # defaults to nil
  #    configuration.add_option(:name)
  #
  #    # with a string default
  #    configuration.add_option(:name, 'John Doe')
  #
  #    # with a dynamic default value, evaluated once when calling #build!
  #    configuration.add_option(:name, 'John Doe')
  #    configuration.add_option(:username) do |config|
  #       config.name.gsub(/\W+/, '').downcase
  #    end
  #    cfg = configuration.build!
  #    cfg.name #=> 'John Doe'
  #    cfg.username #=> 'johndoe'
  #
  # @param name [Symbol] The name of the configuration option.  This will
  #   be used to define a getter by the same name.
  # @param default The default value for this option.  You can specify
  #   a default by passing a value, a `Proc` object or a block argument.
  #   Procs and blocks are evaluated when {#build!} is called.
  # @return [self]
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#108
  def add_option(name, default = T.unsafe(nil), &block); end

  # Constructs and returns a configuration structure.
  # Values not present in `options` will default to those supplied via
  # add option.
  #
  #     configuration = Configuration.new
  #     configuration.add_option(:enabled, true)
  #
  #     cfg1 = configuration.build!
  #     cfg1.enabled #=> true
  #
  #     cfg2 = configuration.build!(enabled: false)
  #     cfg2.enabled #=> false
  #
  # If you pass in options to `#build!` that have not been defined,
  # then an `ArgumentError` will be raised.
  #
  #     configuration = Configuration.new
  #     configuration.add_option(:enabled, true)
  #
  #     # oops, spelling error for :enabled
  #     cfg = configuration.build!(enabld: true)
  #     #=> raises ArgumentError
  #
  # The object returned is a frozen `Struct`.
  #
  #     configuration = Configuration.new
  #     configuration.add_option(:enabled, true)
  #
  #     cfg = configuration.build!
  #     cfg.enabled #=> true
  #     cfg[:enabled] #=> true
  #     cfg['enabled'] #=> true
  #
  # @param options [Hash] ({}) A hash of configuration options.
  # @return [Struct] Returns a frozen configuration `Struct`.
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#149
  def build!(options = T.unsafe(nil)); end

  private

  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#173
  def apply_defaults(struct, options); end

  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#162
  def apply_options(struct, options); end

  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#158
  def empty_struct; end
end

# @api private
class Seahorse::Client::Configuration::DefaultResolver
  # @api private
  # @return [DefaultResolver] a new instance of DefaultResolver
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#185
  def initialize(struct); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#198
  def override_config(k, v); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#190
  def resolve; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#194
  def respond_to?(method_name, *args); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#226
  def method_missing(method_name, *args); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#217
  def resolve_defaults(opt_name, defaults); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#204
  def value_at(opt_name); end
end

# @api private
class Seahorse::Client::Configuration::Defaults < ::Array
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#58
  def each(&block); end
end

# @api private
class Seahorse::Client::Configuration::DynamicDefault
  # @api private
  # @return [DynamicDefault] a new instance of DynamicDefault
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#67
  def initialize(block = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#65
  def block; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#65
  def block=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/configuration.rb#71
  def call(*args); end
end

# @api private
module Seahorse::Client::H2; end

# H2 Connection build on top of `http/2` gem
# (requires Ruby >= 2.1)
# with TLS layer plus ALPN, requires:
# Ruby >= 2.3 and OpenSSL >= 1.0.2
#
# @api private
class Seahorse::Client::H2::Connection
  # @api private
  # @return [Connection] a new instance of Connection
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#38
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#139
  def close!; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#150
  def closed?; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#73
  def connect(endpoint); end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def connection_read_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def connection_timeout; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#154
  def debug_output(msg, type = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def enable_alpn; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#61
  def errors; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def http_wire_trace; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#63
  def input_signal_thread; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#63
  def input_signal_thread=(_arg0); end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def logger; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def max_concurrent_streams; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#65
  def new_stream; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def ssl_ca_bundle; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def ssl_ca_directory; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def ssl_ca_store; end

  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def ssl_verify_peer; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#56
  def ssl_verify_peer?; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#103
  def start(stream); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#167
  def _debug_entry(str); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#234
  def _default_ca_bundle; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#239
  def _default_ca_directory; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#201
  def _nonblocking_connect(tcp, addr); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#172
  def _register_h2_callbacks; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#191
  def _tcp_socket(endpoint); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#217
  def _tls_context; end
end

# chunk read size at socket
#
# @api private
#
# source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#34
Seahorse::Client::H2::Connection::CHUNKSIZE = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#20
Seahorse::Client::H2::Connection::OPTIONS = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/h2/connection.rb#36
Seahorse::Client::H2::Connection::SOCKET_FAMILY = T.let(T.unsafe(nil), Integer)

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#22
Seahorse::Client::H2::DNS_ERROR_MESSAGES = T.let(T.unsafe(nil), Array)

# @api private
class Seahorse::Client::H2::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#29
  def call(context); end

  private

  # H2 pseudo headers
  # https://http2.github.io/http2-spec/#rfc.section.8.1.2.3
  #
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#127
  def _h2_headers(req); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#85
  def _register_callbacks(resp, stream, stream_mutex, close_condition, sync_queue); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#115
  def _send_initial_data(req, stream); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#106
  def _send_initial_headers(req, stream); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#139
  def error_message(req, error); end
end

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/h2/handler.rb#14
Seahorse::Client::H2::NETWORK_ERRORS = T.let(T.unsafe(nil), Array)

class Seahorse::Client::Handler
  # @param handler [Handler] (nil) The next handler in the stack that
  #   should be called from within the {#call} method.  This value
  #   must only be nil for send handlers.
  # @return [Handler] a new instance of Handler
  #
  # source://aws-sdk-core//lib/seahorse/client/handler.rb#10
  def initialize(handler = T.unsafe(nil)); end

  # @param context [RequestContext]
  # @return [Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler.rb#19
  def call(context); end

  # @return [Handler, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler.rb#15
  def handler; end

  # @return [Handler, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler.rb#15
  def handler=(_arg0); end

  # source://aws-sdk-core//lib/seahorse/client/handler.rb#23
  def inspect; end
end

# This module provides the ability to add handlers to a class or
# module.  The including class or extending module must respond to
# `#handlers`, returning a {HandlerList}.
module Seahorse::Client::HandlerBuilder
  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#26
  def handle(*args, &block); end

  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#11
  def handle_request(*args, &block); end

  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#18
  def handle_response(*args, &block); end

  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#26
  def handler(*args, &block); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#34
  def handler_for(name = T.unsafe(nil), &block); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_builder.rb#43
  def new_handler(block); end
end

class Seahorse::Client::HandlerList
  include ::Enumerable

  # @api private
  # @return [HandlerList] a new instance of HandlerList
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#13
  def initialize(options = T.unsafe(nil)); end

  # Registers a handler.  Handlers are used to build a handler stack.
  # Handlers default to the `:build` step with default priority of 50.
  # The step and priority determine where in the stack a handler
  # will be.
  #
  # ## Handler Stack Ordering
  #
  # A handler stack is built from the inside-out.  The stack is
  # seeded with the send handler.  Handlers are constructed recursively
  # in reverse step and priority order so that the highest priority
  # handler is on the outside.
  #
  # By constructing the stack from the inside-out, this ensures
  # that the validate handlers will be called first and the sign handlers
  # will be called just before the final and only send handler is called.
  #
  # ## Steps
  #
  # Handlers are ordered first by step.  These steps represent the
  # life-cycle of a request.  Valid steps are:
  #
  # * `:initialize`
  # * `:validate`
  # * `:build`
  # * `:sign`
  # * `:send`
  #
  # Many handlers can be added to the same step, except for `:send`.
  # There can be only one `:send` handler.  Adding an additional
  # `:send` handler replaces the previous one.
  #
  # ## Priorities
  #
  # Handlers within a single step are executed in priority order.  The
  # higher the priority, the earlier in the stack the handler will
  # be called.
  #
  # * Handler priority is an integer between 0 and 99, inclusively.
  # * Handler priority defaults to 50.
  # * When multiple handlers are added to the same step with the same
  #   priority, the last one added will have the highest priority and
  #   the first one added will have the lowest priority.
  #
  # @note There can be only one `:send` handler.  Adding an additional
  #   send handler replaces the previous.
  # @option options
  # @option options
  # @option options
  # @param handler_class [Class<Handler>] This should be a subclass
  #   of {Handler}.
  # @param options [Hash] a customizable set of options
  # @raise [InvalidStepError]
  # @raise [InvalidPriorityError]
  # @return [Class<Handler>] Returns the handler class that was added.
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#105
  def add(handler_class, options = T.unsafe(nil)); end

  # Copies handlers from the `source_list` onto the current handler list.
  # If a block is given, only the entries that return a `true` value
  # from the block will be copied.
  #
  # @param source_list [HandlerList]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#129
  def copy_from(source_list, &block); end

  # Yields the handlers in stack order, which is reverse priority.
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#151
  def each(&block); end

  # @return [Array<HandlerListEntry>]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#22
  def entries; end

  # Returns a handler list for the given operation.  The returned
  # will have the operation specific handlers merged with the common
  # handlers.
  #
  # @param operation [String] The name of an operation.
  # @return [HandlerList]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#146
  def for(operation); end

  # @param handler_class [Class<Handler>]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#118
  def remove(handler_class); end

  # Constructs the handlers recursively, building a handler stack.
  # The `:send` handler will be at the top of the stack and the
  # `:validate` handlers will be at the bottom.
  #
  # @return [Handler]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#161
  def to_stack; end

  private

  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#167
  def add_entries(entries); end

  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#173
  def add_entry(entry); end

  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#178
  def filter(operation); end

  # source://aws-sdk-core//lib/seahorse/client/handler_list.rb#189
  def next_index; end
end

# A container for an un-constructed handler. A handler entry has the
# handler class, and information about handler priority/order.
#
# This class is an implementation detail of the {HandlerList} class.
# Do not rely on public interfaces of this class.
class Seahorse::Client::HandlerListEntry
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [HandlerListEntry] a new instance of HandlerListEntry
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#28
  def initialize(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#62
  def <=>(other); end

  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [HandlerListEntry]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#72
  def copy(options = T.unsafe(nil)); end

  # @return [Handler, Class<Handler>] Returns the handler.  This may
  #   be a constructed handler object or a handler class.
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#41
  def handler_class; end

  # @return [Integer] The insertion order/position.  This is used to
  #   determine sort order when two entries have the same priority.
  #   Entries inserted later (with a higher inserted value) have a
  #   lower priority.
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#47
  def inserted; end

  # @return [Set<String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#56
  def operations; end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#53
  def priority; end

  # @return [Symbol]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#50
  def step; end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#59
  def weight; end

  private

  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#106
  def compute_weight; end

  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#78
  def option(name, options); end

  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#97
  def set_priority(priority); end

  # source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#87
  def set_step(step); end
end

# source://aws-sdk-core//lib/seahorse/client/handler_list_entry.rb#13
Seahorse::Client::HandlerListEntry::STEPS = T.let(T.unsafe(nil), Hash)

module Seahorse::Client::Http; end

# Rasied when trying to use an closed connection
class Seahorse::Client::Http2ConnectionClosedError < ::StandardError; end

# Raised when sending initial headers and data failed
# for event stream requests over Http2
class Seahorse::Client::Http2InitialRequestError < ::StandardError
  # @return [Http2InitialRequestError] a new instance of Http2InitialRequestError
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#21
  def initialize(error); end

  # @return [HTTP2::Error]
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#26
  def original_error; end
end

# Raised when connection failed to initialize a new stream
class Seahorse::Client::Http2StreamInitializeError < ::StandardError
  # @return [Http2StreamInitializeError] a new instance of Http2StreamInitializeError
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#33
  def initialize(error); end

  # @return [HTTP2::Error]
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#38
  def original_error; end
end

class Seahorse::Client::Http::AsyncResponse < ::Seahorse::Client::Http::Response
  # @return [AsyncResponse] a new instance of AsyncResponse
  #
  # source://aws-sdk-core//lib/seahorse/client/http/async_response.rb#8
  def initialize(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/seahorse/client/http/async_response.rb#24
  def signal_done(options = T.unsafe(nil)); end

  # source://aws-sdk-core//lib/seahorse/client/http/async_response.rb#12
  def signal_headers(headers); end
end

# Provides a Hash-like interface for HTTP headers.  Header names
# are treated indifferently as lower-cased strings.  Header values
# are cast to strings.
#
#     headers = Http::Headers.new
#     headers['Content-Length'] = 100
#     headers[:Authorization] = 'Abc'
#
#     headers.keys
#     #=> ['content-length', 'authorization']
#
#     headers.values
#     #=> ['100', 'Abc']
#
# You can get the header values as a vanilla hash by calling {#to_h}:
#
#     headers.to_h
#     #=> { 'content-length' => '100', 'authorization' => 'Abc' }
class Seahorse::Client::Http::Headers
  include ::Enumerable

  # @api private
  # @return [Headers] a new instance of Headers
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#31
  def initialize(headers = T.unsafe(nil)); end

  # @param key [String]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#40
  def [](key); end

  # @param key [String]
  # @param value [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#46
  def []=(key, value); end

  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#64
  def clear; end

  # @param key [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#60
  def delete(key); end

  # @return [nil]
  # @yield [key, value]
  # @yieldparam key [String]
  # @yieldparam value [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#87
  def each(&block); end

  # @return [nil]
  # @yield [key, value]
  # @yieldparam key [String]
  # @yieldparam value [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#87
  def each_pair(&block); end

  # @return [Boolean] Returns `true` if the header is set.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#100
  def has_key?(key); end

  # @return [Boolean] Returns `true` if the header is set.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#100
  def include?(key); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#113
  def inspect; end

  # @return [Boolean] Returns `true` if the header is set.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#100
  def key?(key); end

  # @return [Array<String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#69
  def keys; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#107
  def to_h; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#107
  def to_hash; end

  # @param headers [Hash]
  # @return [Headers]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#52
  def update(headers); end

  # @return [Array<String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#74
  def values; end

  # @return [Array<String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/headers.rb#79
  def values_at(*keys); end
end

class Seahorse::Client::Http::Request
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Request] a new instance of Request
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#15
  def initialize(options = T.unsafe(nil)); end

  # @return [IO]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#46
  def body; end

  # @param io [#read, #size, #rewind]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#59
  def body=(io); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#51
  def body_contents; end

  # @return [URI::HTTP, URI::HTTPS, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#29
  def endpoint; end

  # @param endpoint [String, URI::HTTP, URI::HTTPS, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#34
  def endpoint=(endpoint); end

  # @return [Headers] The hash of request headers.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#26
  def headers; end

  # @return [Headers] The hash of request headers.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#26
  def headers=(_arg0); end

  # @return [String] The HTTP request method, e.g. `GET`, `PUT`, etc.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#23
  def http_method; end

  # @return [String] The HTTP request method, e.g. `GET`, `PUT`, etc.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/request.rb#23
  def http_method=(_arg0); end
end

class Seahorse::Client::Http::Response
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Response] a new instance of Response
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#11
  def initialize(options = T.unsafe(nil)); end

  # @return [IO]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#32
  def body; end

  # @param io [#read, #size, #rewind]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#37
  def body=(io); end

  # @return [String|Array]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#46
  def body_contents; end

  # @return [StandardError, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#29
  def error; end

  # @return [Headers]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#26
  def headers; end

  # @return [Headers]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#26
  def headers=(_arg0); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#130
  def on_data(&callback); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#134
  def on_done(status_code_range = T.unsafe(nil), &callback); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#151
  def on_error(&callback); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#126
  def on_headers(status_code_range = T.unsafe(nil), &block); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#143
  def on_success(status_code_range = T.unsafe(nil), &callback); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#159
  def reset; end

  # @param chunk [string]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#67
  def signal_data(chunk); end

  # Completes the http response.
  #
  # @example Completing the response in a single call
  #
  #   http_response.signal_done(
  #   status_code: 200,
  #   headers: {},
  #   body: ''
  #   )
  # @example Complete the response in parts
  #
  #   # signal headers straight-way
  #   http_response.signal_headers(200, {})
  #
  #   # signal data as it is received from the socket
  #   http_response.signal_data("...")
  #   http_response.signal_data("...")
  #   http_response.signal_data("...")
  #
  #   # signal done once the body data is all written
  #   http_response.signal_done
  # @overload signal_done
  # @overload signal_done
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#104
  def signal_done(options = T.unsafe(nil)); end

  # @param networking_error [StandardError]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#121
  def signal_error(networking_error); end

  # @param status_code [Integer]
  # @param headers [Hash<String,String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#60
  def signal_headers(status_code, headers); end

  # @return [Integer] Returns `0` if the request failed to generate
  #   any response.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#23
  def status_code; end

  # @return [Integer] Returns `0` if the request failed to generate
  #   any response.
  #
  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#23
  def status_code=(_arg0); end

  private

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#181
  def emit(event_name, *args); end

  # source://aws-sdk-core//lib/seahorse/client/http/response.rb#168
  def listener(range, callback); end
end

# @api private
# @deprecated Use Aws::Logging instead.
module Seahorse::Client::Logging; end

# A log formatter receives a {Response} object and return
# a log message as a string. When you construct a {Formatter}, you provide
# a pattern string with substitutions.
#
#     pattern = ':operation :http_response_status_code :time'
#     formatter = Seahorse::Client::Logging::Formatter.new(pattern)
#     formatter.format(response)
#     #=> 'get_bucket 200 0.0352'
#
# # Canned Formatters
#
# Instead of providing your own pattern, you can choose a canned log
# formatter.
#
# * {Formatter.default}
# * {Formatter.colored}
# * {Formatter.short}
#
# # Pattern Substitutions
#
# You can put any of these placeholders into you pattern.
#
#   * `:client_class` - The name of the client class.
#
#   * `:operation` - The name of the client request method.
#
#   * `:request_params` - The user provided request parameters. Long
#     strings are truncated/summarized if they exceed the
#     {#max_string_size}.  Other objects are inspected.
#
#   * `:time` - The total time in seconds spent on the
#     request.  This includes client side time spent building
#     the request and parsing the response.
#
#   * `:retries` - The number of times a client request was retried.
#
#   * `:http_request_method` - The http request verb, e.g., `POST`,
#     `PUT`, `GET`, etc.
#
#   * `:http_request_endpoint` - The request endpoint.  This includes
#      the scheme, host and port, but not the path.
#
#   * `:http_request_scheme` - This is replaced by `http` or `https`.
#
#   * `:http_request_host` - The host name of the http request
#     endpoint (e.g. 's3.amazon.com').
#
#   * `:http_request_port` - The port number (e.g. '443' or '80').
#
#   * `:http_request_headers` - The http request headers, inspected.
#
#   * `:http_request_body` - The http request payload.
#
#   * `:http_response_status_code` - The http response status
#     code, e.g., `200`, `404`, `500`, etc.
#
#   * `:http_response_headers` - The http response headers, inspected.
#
#   * `:http_response_body` - The http response body contents.
#
#   * `:error_class`
#
#   * `:error_message`
#
# @api private
class Seahorse::Client::Logging::Formatter
  # @api private
  # @option options
  # @param pattern [String] The log format pattern should be a string
  #   and may contain substitutions.
  # @param options [Hash] a customizable set of options
  # @return [Formatter] a new instance of Formatter
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#84
  def initialize(pattern, options = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#104
  def ==(other); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#104
  def eql?(other); end

  # Given a {Response}, this will format a log message and return it
  #   as a string.
  #
  # @api private
  # @param response [Response]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#99
  def format(response); end

  # @api private
  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#93
  def max_string_size; end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#90
  def pattern; end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#119
  def _client_class(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#185
  def _error_class(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#189
  def _error_message(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#165
  def _http_request_body(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#141
  def _http_request_endpoint(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#161
  def _http_request_headers(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#149
  def _http_request_host(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#157
  def _http_request_method(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#153
  def _http_request_port(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#145
  def _http_request_scheme(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#177
  def _http_response_body(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#173
  def _http_response_headers(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#169
  def _http_response_status_code(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#123
  def _operation(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#127
  def _request_params(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#137
  def _retries(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#131
  def _time(response); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#111
  def method_missing(method_name, *args); end

  # @api private
  # @param array [Array]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#247
  def summarize_array(array); end

  # Given the path to a file on disk, this method returns a summarized
  # inspecton string that includes the file size.
  #
  # @api private
  # @param path [String]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#241
  def summarize_file(path); end

  # @api private
  # @param hash [Hash]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#195
  def summarize_hash(hash); end

  # @api private
  # @param str [String]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#228
  def summarize_string(str); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#207
  def summarize_string_hash(hash); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#201
  def summarize_symbol_hash(hash); end

  # @api private
  # @param value [Object]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#215
  def summarize_value(value); end

  class << self
    # The default log format with ANSI colors.
    #
    # @api private
    # @example A sample of the colored format (sans the ansi colors).
    #
    #   [ClientClass 200 0.580066 0 retries] list_objects(:bucket_name => 'bucket')
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#300
    def colored; end

    # The default log format.
    #
    # @api private
    # @example A sample of the default format.
    #
    #   [ClientClass 200 0.580066 0 retries] list_objects(:bucket_name => 'bucket')
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#261
    def default; end

    # The short log format.  Similar to default, but it does not
    # inspect the request params or report on retries.
    #
    # @api private
    # @example A sample of the short format
    #
    #   [ClientClass 200 0.494532] list_buckets
    # @return [Formatter]
    #
    # source://aws-sdk-core//lib/seahorse/client/logging/formatter.rb#282
    def short; end
  end
end

# @api private
class Seahorse::Client::Logging::Handler < ::Seahorse::Client::Handler
  # @api private
  # @param context [RequestContext]
  # @return [Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/handler.rb#12
  def call(context); end

  private

  # @api private
  # @param config [Configuration]
  # @param response [Response]
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/handler.rb#32
  def format(config, response); end

  # @api private
  # @param config [Configuration]
  # @param response [Response]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/logging/handler.rb#25
  def log(config, response); end
end

# This utility class is used to track files opened by Seahorse.
# This allows Seahorse to know what files it needs to close.
class Seahorse::Client::ManagedFile < ::File
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/managed_file.rb#10
  def open?; end
end

# @api private
module Seahorse::Client::NetHttp; end

# @api private
class Seahorse::Client::NetHttp::ConnectionPool
  # @api private
  # @return [ConnectionPool] a new instance of ConnectionPool
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#41
  def initialize(options = T.unsafe(nil)); end

  # Removes stale http sessions from the pool (that have exceeded
  # the idle timeout).
  #
  # @api private
  # @return [nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#133
  def clean!; end

  # Closes and removes all sessions from the pool.
  # If empty! is called while there are outstanding requests they may
  # get checked back into the pool, leaving the pool in a non-empty
  # state.
  #
  # @api private
  # @return [nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#143
  def empty!; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_continue_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_idle_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_open_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_proxy; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_read_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_wire_trace; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def http_wire_trace?; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def logger; end

  # Makes an HTTP request, yielding a Net::HTTPResponse object.
  #
  #   pool.request(URI.parse('http://domain'), Net::HTTP::Get.new('/')) do |resp|
  #     puts resp.code # status code
  #     puts resp.to_h.inspect # dump the headers
  #     puts resp.body
  #   end
  #
  # @api private
  # @param endpoint [URI::HTTP, URI::HTTPS] The HTTP(S) endpoint
  #   to connect to (e.g. 'https://domain.com').
  # @param request [Net::HTTPRequest] The request to make.  This can be
  #   any request object from Net::HTTP (e.g. Net::HTTP::Get,
  #   Net::HTTP::POST, etc).
  # @return [nil]
  # @yieldparam net_http_response [Net::HTTPResponse]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#75
  def request(endpoint, request, &block); end

  # @api private
  # @param endpoint [URI::HTTP, URI::HTTPS] The HTTP(S) endpoint
  #   to connect to (e.g. 'https://domain.com').
  # @return [nil]
  # @yieldparam session [Net::HTTPSession]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#87
  def session_for(endpoint, &block); end

  # @api private
  # @return [Integer] Returns the count of sessions currently in the
  #   pool, not counting those currently in use.
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#120
  def size; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_ca_bundle; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_ca_directory; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_ca_store; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_timeout; end

  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_verify_peer; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#51
  def ssl_verify_peer?; end

  private

  # Removes stale sessions from the pool.  This method *must* be called
  #
  # @api private
  # @note **Must** be called behind a `@pool_mutex` synchronize block.
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#313
  def _clean; end

  # Extract the parts of the http_proxy URI
  #
  # @api private
  # @return [Array(String)]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#265
  def http_proxy_parts; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#155
  def remove_path_and_query(endpoint); end

  # Starts and returns a new HTTP(S) session.
  #
  # @api private
  # @param endpoint [String]
  # @return [Net::HTTPSession]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#277
  def start_session(endpoint); end

  class << self
    # Returns a connection pool constructed from the given options.
    # Calling this method twice with the same options will return
    # the same pool.
    #
    # @api private
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @param options [Hash] a customizable set of options
    # @return [ConnectionPool]
    #
    # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#219
    def for(options = T.unsafe(nil)); end

    # @api private
    # @return [Array<ConnectionPool>] Returns a list of the
    #   constructed connection pools.
    #
    # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#228
    def pools; end

    private

    # Filters an option hash, merging in default values.
    #
    # @api private
    # @return [Hash]
    #
    # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#238
    def pool_options(options); end
  end
end

# Helper methods extended onto Net::HTTPSession objects opened by the
# connection pool.
#
# @api private
class Seahorse::Client::NetHttp::ConnectionPool::ExtendedSession
  # @api private
  # @return [ExtendedSession] a new instance of ExtendedSession
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#330
  def initialize(http); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#338
  def __getobj__; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#342
  def __setobj__(obj); end

  # Attempts to close/finish the session without raising an error.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#353
  def finish; end

  # @api private
  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#336
  def last_used; end

  # Sends the request and tracks that this session has been used.
  #
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#347
  def request(*args, &block); end
end

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/net_http/connection_pool.rb#25
Seahorse::Client::NetHttp::ConnectionPool::OPTIONS = T.let(T.unsafe(nil), Hash)

# The default HTTP handler for Seahorse::Client.  This is based on
# the Ruby's `Net::HTTP`.
#
# @api private
class Seahorse::Client::NetHttp::Handler < ::Seahorse::Client::Handler
  # @api private
  # @param context [RequestContext]
  # @return [Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#49
  def call(context); end

  # @api private
  # @param config [Configuration]
  # @return [ConnectionPool]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#56
  def pool_for(config); end

  private

  # Constructs and returns a Net::HTTP::Request object from
  # a {Http::Request}.
  #
  # @api private
  # @param request [Http::Request]
  # @return [Net::HTTP::Request]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#151
  def build_net_request(request); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#105
  def complete_response(req, resp, bytes_received); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#62
  def error_message(req, error); end

  # @api private
  # @param response [Net::HTTP::Response]
  # @return [Hash<String, String>]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#193
  def extract_headers(response); end

  # @api private
  # @param request [Http::Request]
  # @return [Hash] Returns a vanilla hash of headers to send with the
  #   HTTP request.
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#177
  def headers(request); end

  # @api private
  # @param request [Http::Request]
  # @raise [InvalidHttpVerbError]
  # @return Returns a base `Net::HTTP::Request` class, e.g.,
  #   `Net::HTTP::Get`, `Net::HTTP::Post`, etc.
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#167
  def net_http_request_class(request); end

  # Extracts the {ConnectionPool} configuration options.
  #
  # @api private
  # @param config [Configuration]
  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#140
  def pool_options(config); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#127
  def session(config, req, &block); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#113
  def should_verify_bytes?(req, resp); end

  # @api private
  # @param config [Configuration]
  # @param req [Http::Request]
  # @param resp [Http::Response]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#75
  def transmit(config, req, resp); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#117
  def verify_bytes_received(resp, bytes_received); end
end

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#38
Seahorse::Client::NetHttp::Handler::DNS_ERROR_MESSAGES = T.let(T.unsafe(nil), Array)

# Raised when a {Handler} cannot construct a `Net::HTTP::Request`
# from the given http verb.
#
# @api private
class Seahorse::Client::NetHttp::Handler::InvalidHttpVerbError < ::StandardError; end

# @api private
#
# source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#24
Seahorse::Client::NetHttp::Handler::NETWORK_ERRORS = T.let(T.unsafe(nil), Array)

# @api private
class Seahorse::Client::NetHttp::Handler::TruncatedBodyError < ::IOError
  # @api private
  # @return [TruncatedBodyError] a new instance of TruncatedBodyError
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/handler.rb#17
  def initialize(bytes_expected, bytes_received); end
end

# @api private
module Seahorse::Client::NetHttp::Patches
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/net_http/patches.rb#13
    def apply!; end
  end
end

# For requests with bodys, Net::HTTP sets a default content type of:
#   'application/x-www-form-urlencoded'
# There are cases where we should not send content type at all.
# Even when no body is supplied, Net::HTTP uses a default empty body
# and sets it anyway. This patch disables the behavior when a Thread
# local variable is set.
#
# @api private
module Seahorse::Client::NetHttp::Patches::PatchDefaultContentType
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/net_http/patches.rb#27
  def supply_default_content_type; end
end

class Seahorse::Client::NetworkingError < ::StandardError
  # @return [NetworkingError] a new instance of NetworkingError
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#7
  def initialize(error, msg = T.unsafe(nil)); end

  # Returns the value of attribute original_error.
  #
  # source://aws-sdk-core//lib/seahorse/client/networking_error.rb#13
  def original_error; end
end

class Seahorse::Client::Plugin
  extend ::Seahorse::Client::HandlerBuilder

  # @param handlers [HandlerList]
  # @param config [Configuration]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#24
  def add_handlers(handlers, config); end

  # @param config [Configuration]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#11
  def add_options(config); end

  # @param client [Client::Base]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#39
  def after_initialize(client); end

  # @param client_class [Class<Client::Base>]
  # @param options [Hash]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#31
  def before_initialize(client_class, options); end

  class << self
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#71
    def after_initialize(&block); end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#91
    def after_initialize_hooks; end

    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#67
    def before_initialize(&block); end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#86
    def before_initialize_hooks; end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#81
    def handlers; end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#96
    def literal(string); end

    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @overload option
    # @param options [Hash] a customizable set of options
    # @return [void]
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#54
    def option(name, default = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin.rb#76
    def options; end
  end
end

# @api private
class Seahorse::Client::Plugin::PluginOption
  # @api private
  # @return [PluginOption] a new instance of PluginOption
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#112
  def initialize(name, options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#121
  def default; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#121
  def default=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#122
  def default_block; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#122
  def default_block=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#128
  def doc_default(options); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#125
  def doc_default=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#124
  def doc_type; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#124
  def doc_type=(_arg0); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#126
  def docstring; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#126
  def docstring=(_arg0); end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#136
  def documented?; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#120
  def name; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#123
  def required; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin.rb#123
  def required=(_arg0); end
end

class Seahorse::Client::PluginList
  include ::Enumerable

  # @option options
  # @param plugins [Array, Set]
  # @param options [Hash] a customizable set of options
  # @return [PluginList] a new instance of PluginList
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#14
  def initialize(plugins = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds and returns the `plugin`.
  #
  # @param plugin [Plugin]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#27
  def add(plugin); end

  # Enumerates the plugins.
  #
  # @return [Enumerator]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#59
  def each(&block); end

  # Removes and returns the `plugin`.
  #
  # @param plugin [Plugin]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#37
  def remove(plugin); end

  # Replaces the existing list of plugins.
  #
  # @param plugins [Array<Plugin>]
  # @return [void]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#47
  def set(plugins); end

  private

  # Not safe to call outside the mutex.
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#68
  def _add(plugin); end

  # Yield each PluginDetail behind the mutex
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#73
  def each_plugin(&block); end
end

# A utility class that computes the canonical name for a plugin
# and defers requiring the plugin until the plugin class is
# required.
#
# @api private
class Seahorse::Client::PluginList::PluginWrapper
  # @api private
  # @param plugin [String, Symbol, Module, Class]
  # @return [PluginWrapper] a new instance of PluginWrapper
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#86
  def initialize(plugin); end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#103
  def canonical_name; end

  # @api private
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#121
  def eql?(other); end

  # @api private
  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#127
  def hash; end

  # @api private
  # @return [Class<Plugin>]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#106
  def plugin; end

  private

  # @api private
  # @return [Class<Plugin>]
  #
  # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#134
  def require_plugin; end

  class << self
    # Returns the given plugin if it is already a PluginWrapper.
    #
    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/client/plugin_list.rb#111
    def new(plugin); end
  end
end

module Seahorse::Client::Plugins; end
class Seahorse::Client::Plugins::ContentLength < ::Seahorse::Client::Plugin; end

# @api private
class Seahorse::Client::Plugins::ContentLength::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/content_length.rb#17
  def call(context); end
end

# https://github.com/ruby/net-http/blob/master/lib/net/http/requests.rb
# Methods without body are forwards compatible, because content-length
# may be set for requests without body but is technically incorrect.
#
# @api private
#
# source://aws-sdk-core//lib/seahorse/client/plugins/content_length.rb#13
Seahorse::Client::Plugins::ContentLength::Handler::METHODS_WITHOUT_BODY = T.let(T.unsafe(nil), Set)

class Seahorse::Client::Plugins::Endpoint < ::Seahorse::Client::Plugin
  # source://aws-sdk-core//lib/seahorse/client/plugins/endpoint.rb#23
  def add_handlers(handlers, config); end

  # source://aws-sdk-core//lib/seahorse/client/plugins/endpoint.rb#27
  def after_initialize(client); end
end

class Seahorse::Client::Plugins::Endpoint::Handler < ::Seahorse::Client::Handler
  # source://aws-sdk-core//lib/seahorse/client/plugins/endpoint.rb#45
  def call(context); end
end

class Seahorse::Client::Plugins::H2 < ::Seahorse::Client::Plugin; end

# @api private
class Seahorse::Client::Plugins::Logging < ::Seahorse::Client::Plugin
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/logging.rb#28
  def add_handlers(handlers, config); end
end

class Seahorse::Client::Plugins::NetHttp < ::Seahorse::Client::Plugin
  class << self
    # source://aws-sdk-core//lib/seahorse/client/plugins/net_http.rb#45
    def resolve_http_open_timeout(cfg); end

    # source://aws-sdk-core//lib/seahorse/client/plugins/net_http.rb#53
    def resolve_http_read_timeout(cfg); end

    # source://aws-sdk-core//lib/seahorse/client/plugins/net_http.rb#61
    def resolve_ssl_timeout(cfg); end
  end
end

class Seahorse::Client::Plugins::RaiseResponseErrors < ::Seahorse::Client::Plugin
  # source://aws-sdk-core//lib/seahorse/client/plugins/raise_response_errors.rb#22
  def add_handlers(handlers, config); end
end

# @api private
class Seahorse::Client::Plugins::RaiseResponseErrors::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/raise_response_errors.rb#15
  def call(context); end
end

# @api private
class Seahorse::Client::Plugins::ReadCallbackIO
  extend ::Forwardable

  # @api private
  # @return [ReadCallbackIO] a new instance of ReadCallbackIO
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#15
  def initialize(io, on_read = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#32
  def io; end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#34
  def read(*args); end

  # source://forwardable/1.3.2/forwardable.rb#229
  def size(*args, **_arg1, &block); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#42
  def handle_chunk(chunk); end
end

# @api private
class Seahorse::Client::Plugins::RequestCallback < ::Seahorse::Client::Plugin; end

# @api private
class Seahorse::Client::Plugins::RequestCallback::OptionHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#65
  def call(context); end
end

# @api private
class Seahorse::Client::Plugins::RequestCallback::ReadCallbackHandler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#77
  def call(context); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/request_callback.rb#91
  def unwrap_callback_body(context); end
end

# @api private
class Seahorse::Client::Plugins::ResponseTarget < ::Seahorse::Client::Plugin; end

# This handler is responsible for replacing the HTTP response body IO
# object with custom targets, such as a block, or a file. It is important
# to not write data to the custom target in the case of a non-success
# response. We do not want to write an XML error message to someone's
# file.
#
# @api private
class Seahorse::Client::Plugins::ResponseTarget::Handler < ::Seahorse::Client::Handler
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/response_target.rb#18
  def call(context); end

  private

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/response_target.rb#29
  def add_event_listeners(context, target); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/plugins/response_target.rb#64
  def io(target, headers); end
end

class Seahorse::Client::Request
  include ::Seahorse::Client::HandlerBuilder

  # @param handlers [HandlerList]
  # @param context [RequestContext]
  # @return [Request] a new instance of Request
  #
  # source://aws-sdk-core//lib/seahorse/client/request.rb#11
  def initialize(handlers, context); end

  # @return [RequestContext]
  #
  # source://aws-sdk-core//lib/seahorse/client/request.rb#20
  def context; end

  # @return [HandlerList]
  #
  # source://aws-sdk-core//lib/seahorse/client/request.rb#17
  def handlers; end

  # Sends the request, returning a {Response} object.
  #
  #     response = request.send_request
  #
  # # Streaming Responses
  #
  # By default, HTTP responses are buffered into memory.  This can be
  # bad if you are downloading large responses, e.g. large files.
  # You can avoid this by streaming the response to a block or some other
  # target.
  #
  # ## Streaming to a File
  #
  # You can stream the raw HTTP response body to a File, or any IO-like
  # object, by passing the `:target` option.
  #
  #     # create a new file at the given path
  #     request.send_request(target: '/path/to/target/file')
  #
  #     # or provide an IO object to write to
  #     File.open('photo.jpg', 'wb') do |file|
  #       request.send_request(target: file)
  #     end
  #
  # **Please Note**: The target IO object may receive `#truncate(0)`
  # if the request generates a networking error and bytes have already
  # been written to the target.
  #
  # ## Block Streaming
  #
  # Pass a block to `#send_request` and the response will be yielded in
  # chunks to the given block.
  #
  #     # stream the response data
  #     request.send_request do |chunk|
  #       file.write(chunk)
  #     end
  #
  # **Please Note**: When streaming to a block, it is not possible to
  # retry failed requests.
  #
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/request.rb#70
  def send_request(options = T.unsafe(nil), &block); end
end

class Seahorse::Client::RequestContext
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [RequestContext] a new instance of RequestContext
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#17
  def initialize(options = T.unsafe(nil)); end

  # Returns the metadata for the given `key`.
  #
  # @param key [Symbol]
  # @return [Object]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#63
  def [](key); end

  # Sets the request context metadata for the given `key`.  Request metadata
  # useful for handlers that need to keep state on the request, without
  # sending that data with the request over HTTP.
  #
  # @param key [Symbol]
  # @param value [Object]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#72
  def []=(key, value); end

  # @return [Model::Authorizer] APIG SDKs only
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#37
  def authorizer; end

  # @return [Model::Authorizer] APIG SDKs only
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#37
  def authorizer=(_arg0); end

  # @return [Seahorse::Client::Base]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#40
  def client; end

  # @return [Seahorse::Client::Base]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#40
  def client=(_arg0); end

  # @return [Configuration] The client configuration.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#46
  def config; end

  # @return [Configuration] The client configuration.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#46
  def config=(_arg0); end

  # @return [Http::Request]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#49
  def http_request; end

  # @return [Http::Request]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#49
  def http_request=(_arg0); end

  # @return [Http::Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#52
  def http_response; end

  # @return [Http::Response]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#52
  def http_response=(_arg0); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#58
  def metadata; end

  # @return [Model::Operation]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#34
  def operation; end

  # @return [Model::Operation]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#34
  def operation=(_arg0); end

  # @return [Symbol] Name of the API operation called.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#31
  def operation_name; end

  # @return [Symbol] Name of the API operation called.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#31
  def operation_name=(_arg0); end

  # @return [Hash] The hash of request parameters.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#43
  def params; end

  # @return [Hash] The hash of request parameters.
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#43
  def params=(_arg0); end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#55
  def retries; end

  # @return [Integer]
  #
  # source://aws-sdk-core//lib/seahorse/client/request_context.rb#55
  def retries=(_arg0); end
end

class Seahorse::Client::Response
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @return [Response] a new instance of Response
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#12
  def initialize(options = T.unsafe(nil)); end

  # Necessary to define as a subclass of Delegator
  #
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#71
  def __getobj__; end

  # Necessary to define as a subclass of Delegator
  #
  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#77
  def __setobj__(obj); end

  # @return [RequestContext]
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#24
  def context; end

  # @return The response data.  This may be `nil` if the response contains
  #   an {#error}.
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#28
  def data; end

  # @return The response data.  This may be `nil` if the response contains
  #   an {#error}.
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#28
  def data=(_arg0); end

  # @return [StandardError, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#31
  def error; end

  # @return [StandardError, nil]
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#31
  def error=(_arg0); end

  # @overload on
  # @overload on
  # @return [self]
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#43
  def on(range, &_block); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#64
  def on_complete(&block); end

  # Yields to the block if the response has a 200 level status code.
  #
  # @return [self]
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#53
  def on_success(&block); end

  # @return [Boolean] Returns `true` if the response is complete with
  #   a ~ 200 level http status code.
  #
  # source://aws-sdk-core//lib/seahorse/client/response.rb#59
  def successful?; end
end

module Seahorse::Model; end

class Seahorse::Model::Api
  # @return [Api] a new instance of Api
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#7
  def initialize; end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#75
  def add_authorizer(name, authorizer); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#51
  def add_operation(name, operation); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#47
  def async_operation_names; end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#63
  def authorizer(name); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#71
  def authorizer_names; end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#55
  def authorizers(&block); end

  # @return [Symbol|nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#22
  def endpoint_operation; end

  # @return [Symbol|nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#22
  def endpoint_operation=(_arg0); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#79
  def inspect(*args); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#19
  def metadata; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#19
  def metadata=(_arg0); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#35
  def operation(name); end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#43
  def operation_names; end

  # source://aws-sdk-core//lib/seahorse/model/api.rb#27
  def operations(&block); end

  # @return [Boolean|nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#25
  def require_endpoint_discovery; end

  # @return [Boolean|nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#25
  def require_endpoint_discovery=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#16
  def version; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/api.rb#16
  def version=(_arg0); end
end

class Seahorse::Model::Authorizer
  # @return [Authorizer] a new instance of Authorizer
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#7
  def initialize; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#13
  def name; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#13
  def name=(_arg0); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#19
  def placement; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#19
  def placement=(_arg0); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#16
  def type; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/authorizer.rb#16
  def type=(_arg0); end
end

class Seahorse::Model::Operation
  # @return [Operation] a new instance of Operation
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#7
  def initialize; end

  # source://aws-sdk-core//lib/seahorse/model/operation.rb#65
  def [](key); end

  # source://aws-sdk-core//lib/seahorse/model/operation.rb#69
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#63
  def async; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#63
  def async=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#47
  def authorizer; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#47
  def authorizer=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#32
  def deprecated; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#32
  def deprecated=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#41
  def documentation; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#41
  def documentation=(_arg0); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#38
  def endpoint_discovery; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#38
  def endpoint_discovery=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#35
  def endpoint_operation; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#35
  def endpoint_operation=(_arg0); end

  # @return [Hash, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#44
  def endpoint_pattern; end

  # @return [Hash, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#44
  def endpoint_pattern=(_arg0); end

  # @return [Array<ShapeRef>]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#56
  def errors; end

  # @return [Array<ShapeRef>]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#56
  def errors=(_arg0); end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#29
  def http_checksum; end

  # @return [Hash]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#29
  def http_checksum=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#26
  def http_checksum_required; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#26
  def http_checksum_required=(_arg0); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#20
  def http_method; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#20
  def http_method=(_arg0); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#23
  def http_request_uri; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#23
  def http_request_uri=(_arg0); end

  # @return [ShapeRef, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#50
  def input; end

  # @return [ShapeRef, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#50
  def input=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#17
  def name; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#17
  def name=(_arg0); end

  # @return [ShapeRef, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#53
  def output; end

  # @return [ShapeRef, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#53
  def output=(_arg0); end

  # APIG only
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#60
  def require_apikey; end

  # APIG only
  #
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/operation.rb#60
  def require_apikey=(_arg0); end
end

module Seahorse::Model::Shapes; end

class Seahorse::Model::Shapes::BlobShape < ::Seahorse::Model::Shapes::Shape
  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#141
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#141
  def max=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#138
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#138
  def min=(_arg0); end
end

class Seahorse::Model::Shapes::BooleanShape < ::Seahorse::Model::Shapes::Shape; end
class Seahorse::Model::Shapes::DocumentShape < ::Seahorse::Model::Shapes::Shape; end

class Seahorse::Model::Shapes::FloatShape < ::Seahorse::Model::Shapes::Shape
  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#153
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#153
  def max=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#150
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#150
  def min=(_arg0); end
end

class Seahorse::Model::Shapes::IntegerShape < ::Seahorse::Model::Shapes::Shape
  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#163
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#163
  def max=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#160
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#160
  def min=(_arg0); end
end

class Seahorse::Model::Shapes::ListShape < ::Seahorse::Model::Shapes::Shape
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#179
  def flattened; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#179
  def flattened=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#176
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#176
  def max=(_arg0); end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#170
  def member; end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#170
  def member=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#173
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#173
  def min=(_arg0); end
end

class Seahorse::Model::Shapes::MapShape < ::Seahorse::Model::Shapes::Shape
  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#198
  def flattened; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#198
  def flattened=(_arg0); end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#186
  def key; end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#186
  def key=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#195
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#195
  def max=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#192
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#192
  def min=(_arg0); end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#189
  def value; end

  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#189
  def value=(_arg0); end
end

class Seahorse::Model::Shapes::Shape
  # @return [Shape] a new instance of Shape
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#103
  def initialize(options = T.unsafe(nil)); end

  # Gets metadata for the given `key`.
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#124
  def [](key); end

  # Sets metadata for the given `key`.
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#129
  def []=(key, value); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#118
  def documentation; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#118
  def documentation=(_arg0); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#115
  def name; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#115
  def name=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#121
  def union; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#121
  def union=(_arg0); end
end

class Seahorse::Model::Shapes::ShapeRef
  # @return [ShapeRef] a new instance of ShapeRef
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#11
  def initialize(options = T.unsafe(nil)); end

  # Gets metadata for the given `key`.
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#86
  def [](key); end

  # Sets metadata for the given `key`.
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#95
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#44
  def deprecated; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#44
  def deprecated=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#65
  def document; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#65
  def document=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#41
  def documentation; end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#41
  def documentation=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#47
  def event; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#47
  def event=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#56
  def eventheader; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#56
  def eventheader=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#62
  def eventheader_type; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#62
  def eventheader_type=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#53
  def eventpayload; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#53
  def eventpayload=(_arg0); end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#59
  def eventpayload_type; end

  # @return [String]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#59
  def eventpayload_type=(_arg0); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#50
  def eventstream; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#50
  def eventstream=(_arg0); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#68
  def location; end

  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#72
  def location=(location); end

  # @return [String, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#77
  def location_name; end

  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#81
  def location_name=(location_name); end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#38
  def required; end

  # @return [Boolean]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#38
  def required=(_arg0); end

  # @return [Shape]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#35
  def shape; end

  # @return [Shape]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#35
  def shape=(_arg0); end
end

class Seahorse::Model::Shapes::StringShape < ::Seahorse::Model::Shapes::Shape
  # @return [Set<String>, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#205
  def enum; end

  # @return [Set<String>, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#205
  def enum=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#211
  def max; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#211
  def max=(_arg0); end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#208
  def min; end

  # @return [Integer, nil]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#208
  def min=(_arg0); end
end

class Seahorse::Model::Shapes::StructureShape < ::Seahorse::Model::Shapes::Shape
  # @return [StructureShape] a new instance of StructureShape
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#217
  def initialize(options = T.unsafe(nil)); end

  # @param name [Symbol]
  # @param shape_ref [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#232
  def add_member(name, shape_ref); end

  # @param name [Symbol]
  # @return [ShapeRef]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#258
  def member(name); end

  # @param member_name [Symbol]
  # @return [Boolean] Returns `true` if there exists a member with
  #   the given name.
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#247
  def member?(member_name); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#267
  def member_by_location_name(location_name); end

  # @return [Array<Symbol>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#240
  def member_names; end

  # @return [Enumerator<[Symbol,ShapeRef]>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#252
  def members; end

  # @return [Set<Symbol>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#225
  def required; end

  # @return [Set<Symbol>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#225
  def required=(_arg0); end

  # @return [Class<Struct>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#228
  def struct_class; end

  # @return [Class<Struct>]
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#228
  def struct_class=(_arg0); end
end

class Seahorse::Model::Shapes::TimestampShape < ::Seahorse::Model::Shapes::Shape; end

class Seahorse::Model::Shapes::UnionShape < ::Seahorse::Model::Shapes::StructureShape
  # @return [UnionShape] a new instance of UnionShape
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#274
  def initialize(options = T.unsafe(nil)); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#285
  def add_member_subclass(member, subclass); end

  # @api private
  #
  # source://aws-sdk-core//lib/seahorse/model/shapes.rb#280
  def member_subclass(member); end
end

# @api private
module Seahorse::Util
  class << self
    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/util.rb#17
    def escape_header_list_string(s); end

    # Checks for a valid host label
    #
    # @api private
    # @return [Boolean]
    # @see https://tools.ietf.org/html/rfc3986#section-3.2.2
    # @see https://tools.ietf.org/html/rfc1123#page-13
    #
    # source://aws-sdk-core//lib/seahorse/util.rb#24
    def host_label?(str); end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/util.rb#9
    def uri_escape(string); end

    # @api private
    #
    # source://aws-sdk-core//lib/seahorse/util.rb#13
    def uri_path_escape(path); end
  end
end
