# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `addressable` gem.
# Please instead update this file by running `bin/tapioca gem addressable`.

# Addressable is a library for processing links and URIs.
module Addressable; end

module Addressable::IDNA
  class << self
    # Converts from a Unicode internationalized domain name to an ASCII
    # domain name as described in RFC 3490.
    #
    # source://addressable//lib/addressable/idna/pure.rb#67
    def to_ascii(input); end

    # Converts from an ASCII domain name to a Unicode internationalized
    # domain name as described in RFC 3490.
    #
    # source://addressable//lib/addressable/idna/pure.rb#93
    def to_unicode(input); end

    # Unicode normalization form KC.
    #
    # source://addressable//lib/addressable/idna/pure.rb#116
    def unicode_normalize_kc(input); end

    private

    # source://addressable//lib/addressable/idna/pure.rb#282
    def lookup_unicode_combining_class(codepoint); end

    # source://addressable//lib/addressable/idna/pure.rb#290
    def lookup_unicode_compatibility(codepoint); end

    # source://addressable//lib/addressable/idna/pure.rb#305
    def lookup_unicode_composition(unpacked); end

    # source://addressable//lib/addressable/idna/pure.rb#297
    def lookup_unicode_lowercase(codepoint); end

    # Bias adaptation method
    #
    # source://addressable//lib/addressable/idna/pure.rb#660
    def punycode_adapt(delta, numpoints, firsttime); end

    # @return [Boolean]
    #
    # source://addressable//lib/addressable/idna/pure.rb#628
    def punycode_basic?(codepoint); end

    # source://addressable//lib/addressable/idna/pure.rb#506
    def punycode_decode(punycode); end

    # Returns the numeric value of a basic codepoint
    # (for use in representing integers) in the range 0 to
    # base - 1, or PUNYCODE_BASE if codepoint does not represent a value.
    #
    # source://addressable//lib/addressable/idna/pure.rb#646
    def punycode_decode_digit(codepoint); end

    # @return [Boolean]
    #
    # source://addressable//lib/addressable/idna/pure.rb#633
    def punycode_delimiter?(codepoint); end

    # source://addressable//lib/addressable/idna/pure.rb#385
    def punycode_encode(unicode); end

    # source://addressable//lib/addressable/idna/pure.rb#638
    def punycode_encode_digit(d); end

    # source://addressable//lib/addressable/idna/pure.rb#188
    def ucs4_to_utf8(char, buffer); end

    # source://addressable//lib/addressable/idna/pure.rb#139
    def unicode_compose(unpacked); end

    # source://addressable//lib/addressable/idna/pure.rb#164
    def unicode_compose_pair(ch_one, ch_two); end

    # source://addressable//lib/addressable/idna/pure.rb#244
    def unicode_decompose(unpacked); end

    # source://addressable//lib/addressable/idna/pure.rb#265
    def unicode_decompose_hangul(codepoint); end

    # Unicode aware downcase method.
    #
    # @api private
    # @param input [String] The input string.
    # @return [String] The downcased result.
    #
    # source://addressable//lib/addressable/idna/pure.rb#131
    def unicode_downcase(input); end

    # source://addressable//lib/addressable/idna/pure.rb#220
    def unicode_sort_canonical(unpacked); end
  end
end

# source://addressable//lib/addressable/idna/pure.rb#355
Addressable::IDNA::ACE_MAX_LENGTH = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#40
Addressable::IDNA::ACE_PREFIX = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/idna/pure.rb#344
Addressable::IDNA::COMPOSITION_TABLE = T.let(T.unsafe(nil), Hash)

# source://addressable//lib/addressable/idna/pure.rb#311
Addressable::IDNA::HANGUL_LBASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#312
Addressable::IDNA::HANGUL_LCOUNT = T.let(T.unsafe(nil), Integer)

# 588
#
# source://addressable//lib/addressable/idna/pure.rb#317
Addressable::IDNA::HANGUL_NCOUNT = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#310
Addressable::IDNA::HANGUL_SBASE = T.let(T.unsafe(nil), Integer)

# 11172
#
# source://addressable//lib/addressable/idna/pure.rb#318
Addressable::IDNA::HANGUL_SCOUNT = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#315
Addressable::IDNA::HANGUL_TBASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#316
Addressable::IDNA::HANGUL_TCOUNT = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#313
Addressable::IDNA::HANGUL_VBASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#314
Addressable::IDNA::HANGUL_VCOUNT = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#357
Addressable::IDNA::PUNYCODE_BASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#361
Addressable::IDNA::PUNYCODE_DAMP = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#364
Addressable::IDNA::PUNYCODE_DELIMITER = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#362
Addressable::IDNA::PUNYCODE_INITIAL_BIAS = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#363
Addressable::IDNA::PUNYCODE_INITIAL_N = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#366
Addressable::IDNA::PUNYCODE_MAXINT = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#368
Addressable::IDNA::PUNYCODE_PRINT_ASCII = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/idna/pure.rb#360
Addressable::IDNA::PUNYCODE_SKEW = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#359
Addressable::IDNA::PUNYCODE_TMAX = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#358
Addressable::IDNA::PUNYCODE_TMIN = T.let(T.unsafe(nil), Integer)

# Input is invalid.
class Addressable::IDNA::PunycodeBadInput < ::StandardError; end

# Output would exceed the space provided.
class Addressable::IDNA::PunycodeBigOutput < ::StandardError; end

# Input needs wider integers to process.
class Addressable::IDNA::PunycodeOverflow < ::StandardError; end

# source://addressable//lib/addressable/idna/pure.rb#335
Addressable::IDNA::UNICODE_DATA = T.let(T.unsafe(nil), Hash)

# source://addressable//lib/addressable/idna/pure.rb#322
Addressable::IDNA::UNICODE_DATA_CANONICAL = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#320
Addressable::IDNA::UNICODE_DATA_COMBINING_CLASS = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#323
Addressable::IDNA::UNICODE_DATA_COMPATIBILITY = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#321
Addressable::IDNA::UNICODE_DATA_EXCLUSION = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#325
Addressable::IDNA::UNICODE_DATA_LOWERCASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#326
Addressable::IDNA::UNICODE_DATA_TITLECASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#324
Addressable::IDNA::UNICODE_DATA_UPPERCASE = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#354
Addressable::IDNA::UNICODE_MAX_LENGTH = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/idna/pure.rb#36
Addressable::IDNA::UNICODE_TABLE = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/idna/pure.rb#42
Addressable::IDNA::UTF8_REGEX = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/idna/pure.rb#53
Addressable::IDNA::UTF8_REGEX_MULTIBYTE = T.let(T.unsafe(nil), Regexp)

# This is an implementation of a URI parser based on
# <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>,
# <a href="http://www.ietf.org/rfc/rfc3987.txt">RFC 3987</a>.
class Addressable::URI
  # Creates a new uri object from component parts.
  #
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @option [String,
  # @param [String, [Hash] a customizable set of options
  # @return [Addressable::URI] The constructed URI object.
  #
  # source://addressable//lib/addressable/uri.rb#824
  def initialize(options = T.unsafe(nil)); end

  # Joins two URIs together.
  #
  # @param The [String, Addressable::URI, #to_str] URI to join with.
  # @return [Addressable::URI] The joined URI.
  #
  # source://addressable//lib/addressable/uri.rb#1898
  def +(uri); end

  # Returns <code>true</code> if the URI objects are equal. This method
  # normalizes both URIs before doing the comparison.
  #
  # @param uri [Object] The URI to compare.
  # @return [TrueClass, FalseClass] <code>true</code> if the URIs are equivalent, <code>false</code>
  #   otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#2248
  def ==(uri); end

  # Returns <code>true</code> if the URI objects are equal. This method
  # normalizes both URIs before doing the comparison, and allows comparison
  # against <code>Strings</code>.
  #
  # @param uri [Object] The URI to compare.
  # @return [TrueClass, FalseClass] <code>true</code> if the URIs are equivalent, <code>false</code>
  #   otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#2226
  def ===(uri); end

  # Determines if the URI is absolute.
  #
  # @return [TrueClass, FalseClass] <code>true</code> if the URI is absolute. <code>false</code>
  #   otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#1888
  def absolute?; end

  # The authority component for this URI.
  # Combines the user, password, host, and port components.
  #
  # @return [String] The authority component.
  #
  # source://addressable//lib/addressable/uri.rb#1235
  def authority; end

  # Sets the authority component for this URI.
  #
  # @param new_authority [String, #to_str] The new authority component.
  #
  # source://addressable//lib/addressable/uri.rb#1275
  def authority=(new_authority); end

  # The basename, if any, of the file in the path component.
  #
  # @return [String] The path's basename.
  #
  # source://addressable//lib/addressable/uri.rb#1593
  def basename; end

  # The default port for this URI's scheme.
  # This method will always returns the default port for the URI's scheme
  # regardless of the presence of an explicit port in the URI.
  #
  # @return [Integer] The default port.
  #
  # source://addressable//lib/addressable/uri.rb#1457
  def default_port; end

  # This method allows you to make several changes to a URI simultaneously,
  # which separately would cause validation errors, but in conjunction,
  # are valid.  The URI will be revalidated as soon as the entire block has
  # been executed.
  #
  # @param block [Proc] A set of operations to perform on a given URI.
  # @raise [LocalJumpError]
  #
  # source://addressable//lib/addressable/uri.rb#2405
  def defer_validation; end

  # Creates a URI suitable for display to users. If semantic attacks are
  # likely, the application should try to detect these and warn the user.
  # See <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>,
  # section 7.6 for more information.
  #
  # @return [Addressable::URI] A URI suitable for display purposes.
  #
  # source://addressable//lib/addressable/uri.rb#2210
  def display_uri; end

  # Returns the public suffix domain for this host.
  #
  # @example
  #   Addressable::URI.parse("http://www.example.co.uk").domain # => "example.co.uk"
  #
  # source://addressable//lib/addressable/uri.rb#1226
  def domain; end

  # Clones the URI object.
  #
  # @return [Addressable::URI] The cloned URI.
  #
  # source://addressable//lib/addressable/uri.rb#2280
  def dup; end

  # Determines if the URI is an empty string.
  #
  # @return [TrueClass, FalseClass] Returns <code>true</code> if empty, <code>false</code> otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#2342
  def empty?; end

  # Returns <code>true</code> if the URI objects are equal. This method
  # does NOT normalize either URI before doing the comparison.
  #
  # @param uri [Object] The URI to compare.
  # @return [TrueClass, FalseClass] <code>true</code> if the URIs are equivalent, <code>false</code>
  #   otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#2262
  def eql?(uri); end

  # The extname, if any, of the file in the path component.
  # Empty string if there is no extension.
  #
  # @return [String] The path's extname.
  #
  # source://addressable//lib/addressable/uri.rb#1603
  def extname; end

  # The fragment component for this URI.
  #
  # @return [String] The fragment component.
  #
  # source://addressable//lib/addressable/uri.rb#1817
  def fragment; end

  # Sets the fragment component for this URI.
  #
  # @param new_fragment [String, #to_str] The new fragment component.
  #
  # source://addressable//lib/addressable/uri.rb#1844
  def fragment=(new_fragment); end

  # Freeze URI, initializing instance variables.
  #
  # @return [Addressable::URI] The frozen URI object.
  #
  # source://addressable//lib/addressable/uri.rb#861
  def freeze; end

  # A hash value that will make a URI equivalent to its normalized
  # form.
  #
  # @return [Integer] A hash of the URI.
  #
  # source://addressable//lib/addressable/uri.rb#2272
  def hash; end

  # The host component for this URI.
  #
  # @return [String] The host component.
  #
  # source://addressable//lib/addressable/uri.rb#1119
  def host; end

  # Sets the host component for this URI.
  #
  # @param new_host [String, #to_str] The new host component.
  #
  # source://addressable//lib/addressable/uri.rb#1157
  def host=(new_host); end

  # This method is same as URI::Generic#host except
  # brackets for IPv6 (and 'IPvFuture') addresses are removed.
  #
  # @return [String] The hostname for this URI.
  # @see Addressable::URI#host
  #
  # source://addressable//lib/addressable/uri.rb#1179
  def hostname; end

  # This method is same as URI::Generic#host= except
  # the argument can be a bare IPv6 address (or 'IPvFuture').
  #
  # @param new_hostname [String, #to_str] The new hostname for this URI.
  # @see Addressable::URI#host=
  #
  # source://addressable//lib/addressable/uri.rb#1191
  def hostname=(new_hostname); end

  # The inferred port component for this URI.
  # This method will normalize to the default port for the URI's scheme if
  # the port isn't explicitly specified in the URI.
  #
  # @return [Integer] The inferred port component.
  #
  # source://addressable//lib/addressable/uri.rb#1443
  def inferred_port; end

  # Returns a <code>String</code> representation of the URI object's state.
  #
  # @return [String] The URI object's state, as a <code>String</code>.
  #
  # source://addressable//lib/addressable/uri.rb#2393
  def inspect; end

  # Determines if the scheme indicates an IP-based protocol.
  #
  # @return [TrueClass, FalseClass] <code>true</code> if the scheme indicates an IP-based protocol.
  #   <code>false</code> otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#1864
  def ip_based?; end

  # Joins two URIs together.
  #
  # @param The [String, Addressable::URI, #to_str] URI to join with.
  # @return [Addressable::URI] The joined URI.
  #
  # source://addressable//lib/addressable/uri.rb#1898
  def join(uri); end

  # Destructive form of <code>join</code>.
  #
  # @param The [String, Addressable::URI, #to_str] URI to join with.
  # @return [Addressable::URI] The joined URI.
  # @see Addressable::URI#join
  #
  # source://addressable//lib/addressable/uri.rb#2001
  def join!(uri); end

  # Merges a URI with a <code>Hash</code> of components.
  # This method has different behavior from <code>join</code>. Any
  # components present in the <code>hash</code> parameter will override the
  # original components. The path component is not treated specially.
  #
  # @param The [Hash, Addressable::URI, #to_hash] components to merge with.
  # @return [Addressable::URI] The merged URI.
  # @see Hash#merge
  #
  # source://addressable//lib/addressable/uri.rb#2016
  def merge(hash); end

  # Destructive form of <code>merge</code>.
  #
  # @param The [Hash, Addressable::URI, #to_hash] components to merge with.
  # @return [Addressable::URI] The merged URI.
  # @see Addressable::URI#merge
  #
  # source://addressable//lib/addressable/uri.rb#2081
  def merge!(uri); end

  # Returns a normalized URI object.
  #
  # NOTE: This method does not attempt to fully conform to specifications.
  # It exists largely to correct other people's failures to read the
  # specifications, and also to deal with caching issues since several
  # different URIs may represent the same resource and should not be
  # cached multiple times.
  #
  # @return [Addressable::URI] The normalized URI.
  #
  # source://addressable//lib/addressable/uri.rb#2173
  def normalize; end

  # Destructively normalizes this URI object.
  #
  # @return [Addressable::URI] The normalized URI.
  # @see Addressable::URI#normalize
  #
  # source://addressable//lib/addressable/uri.rb#2199
  def normalize!; end

  # The authority component for this URI, normalized.
  #
  # @return [String] The authority component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1253
  def normalized_authority; end

  # The fragment component for this URI, normalized.
  #
  # @return [String] The fragment component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1825
  def normalized_fragment; end

  # The host component for this URI, normalized.
  #
  # @return [String] The host component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1127
  def normalized_host; end

  # The password component for this URI, normalized.
  #
  # @return [String] The password component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#999
  def normalized_password; end

  # The path component for this URI, normalized.
  #
  # @return [String] The path component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1540
  def normalized_path; end

  # The port component for this URI, normalized.
  #
  # @return [Integer] The port component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1395
  def normalized_port; end

  # The query component for this URI, normalized.
  #
  # @return [String] The query component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1620
  def normalized_query(*flags); end

  # The scheme component for this URI, normalized.
  #
  # @return [String] The scheme component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#889
  def normalized_scheme; end

  # The normalized combination of components that represent a site.
  # Combines the scheme, user, password, host, and port components.
  # Primarily useful for HTTP and HTTPS.
  #
  # For example, <code>"http://example.com/path?query"</code> would have a
  # <code>site</code> value of <code>"http://example.com"</code>.
  #
  # @return [String] The normalized components that identify a site.
  #
  # source://addressable//lib/addressable/uri.rb#1488
  def normalized_site; end

  # The user component for this URI, normalized.
  #
  # @return [String] The user component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#942
  def normalized_user; end

  # The userinfo component for this URI, normalized.
  #
  # @return [String] The userinfo component, normalized.
  #
  # source://addressable//lib/addressable/uri.rb#1067
  def normalized_userinfo; end

  # Omits components from a URI.
  #
  # @example
  #   uri = Addressable::URI.parse("http://example.com/path?query")
  #   #=> #<Addressable::URI:0xcc5e7a URI:http://example.com/path?query>
  #   uri.omit(:scheme, :authority)
  #   #=> #<Addressable::URI:0xcc4d86 URI:/path?query>
  # @param *components [Symbol] The components to be omitted.
  # @return [Addressable::URI] The URI with components omitted.
  #
  # source://addressable//lib/addressable/uri.rb#2306
  def omit(*components); end

  # Destructive form of omit.
  #
  # @param *components [Symbol] The components to be omitted.
  # @return [Addressable::URI] The URI with components omitted.
  # @see Addressable::URI#omit
  #
  # source://addressable//lib/addressable/uri.rb#2333
  def omit!(*components); end

  # The origin for this URI, serialized to ASCII, as per
  # RFC 6454, section 6.2.
  #
  # @return [String] The serialized origin.
  #
  # source://addressable//lib/addressable/uri.rb#1315
  def origin; end

  # Sets the origin for this URI, serialized to ASCII, as per
  # RFC 6454, section 6.2. This assignment will reset the `userinfo`
  # component.
  #
  # @param new_origin [String, #to_str] The new origin component.
  #
  # source://addressable//lib/addressable/uri.rb#1334
  def origin=(new_origin); end

  # The password component for this URI.
  #
  # @return [String] The password component.
  #
  # source://addressable//lib/addressable/uri.rb#991
  def password; end

  # Sets the password component for this URI.
  #
  # @param new_password [String, #to_str] The new password component.
  #
  # source://addressable//lib/addressable/uri.rb#1022
  def password=(new_password); end

  # The path component for this URI.
  #
  # @return [String] The path component.
  #
  # source://addressable//lib/addressable/uri.rb#1531
  def path; end

  # Sets the path component for this URI.
  #
  # @param new_path [String, #to_str] The new path component.
  #
  # source://addressable//lib/addressable/uri.rb#1572
  def path=(new_path); end

  # The port component for this URI.
  # This is the port number actually given in the URI. This does not
  # infer port numbers from default values.
  #
  # @return [Integer] The port component.
  #
  # source://addressable//lib/addressable/uri.rb#1387
  def port; end

  # Sets the port component for this URI.
  #
  # @param new_port [String, Integer, #to_s] The new port component.
  #
  # source://addressable//lib/addressable/uri.rb#1411
  def port=(new_port); end

  # The query component for this URI.
  #
  # @return [String] The query component.
  #
  # source://addressable//lib/addressable/uri.rb#1612
  def query; end

  # Sets the query component for this URI.
  #
  # @param new_query [String, #to_str] The new query component.
  #
  # source://addressable//lib/addressable/uri.rb#1648
  def query=(new_query); end

  # Converts the query component to a Hash value.
  #
  # @example
  #   Addressable::URI.parse("?one=1&two=2&three=3").query_values
  #   #=> {"one" => "1", "two" => "2", "three" => "3"}
  #   Addressable::URI.parse("?one=two&one=three").query_values(Array)
  #   #=> [["one", "two"], ["one", "three"]]
  #   Addressable::URI.parse("?one=two&one=three").query_values(Hash)
  #   #=> {"one" => "three"}
  #   Addressable::URI.parse("?").query_values
  #   #=> {}
  #   Addressable::URI.parse("").query_values
  #   #=> nil
  # @param return_type [Class] The return type desired. Value must be either
  #   `Hash` or `Array`.
  # @return [Hash, Array, nil] The query string parsed as a Hash or Array
  #   or nil if the query string is blank.
  #
  # source://addressable//lib/addressable/uri.rb#1679
  def query_values(return_type = T.unsafe(nil)); end

  # Sets the query component for this URI from a Hash object.
  # An empty Hash or Array will result in an empty query string.
  #
  # @example
  #   uri.query_values = {:a => "a", :b => ["c", "d", "e"]}
  #   uri.query
  #   # => "a=a&b=c&b=d&b=e"
  #   uri.query_values = [['a', 'a'], ['b', 'c'], ['b', 'd'], ['b', 'e']]
  #   uri.query
  #   # => "a=a&b=c&b=d&b=e"
  #   uri.query_values = [['a', 'a'], ['b', ['c', 'd', 'e']]]
  #   uri.query
  #   # => "a=a&b=c&b=d&b=e"
  #   uri.query_values = [['flag'], ['key', 'value']]
  #   uri.query
  #   # => "flag&key=value"
  # @param new_query_values [Hash, #to_hash, Array] The new query values.
  #
  # source://addressable//lib/addressable/uri.rb#1730
  def query_values=(new_query_values); end

  # Determines if the URI is relative.
  #
  # @return [TrueClass, FalseClass] <code>true</code> if the URI is relative. <code>false</code>
  #   otherwise.
  #
  # source://addressable//lib/addressable/uri.rb#1878
  def relative?; end

  # The HTTP request URI for this URI.  This is the path and the
  # query string.
  #
  # @return [String] The request URI required for an HTTP request.
  #
  # source://addressable//lib/addressable/uri.rb#1781
  def request_uri; end

  # Sets the HTTP request URI for this URI.
  #
  # @param new_request_uri [String, #to_str] The new HTTP request URI.
  #
  # source://addressable//lib/addressable/uri.rb#1793
  def request_uri=(new_request_uri); end

  # Returns the shortest normalized relative form of this URI that uses the
  # supplied URI as a base for resolution. Returns an absolute URI if
  # necessary. This is effectively the opposite of <code>route_to</code>.
  #
  # @param uri [String, Addressable::URI, #to_str] The URI to route from.
  # @return [Addressable::URI] The normalized relative URI that is equivalent to the original URI.
  #
  # source://addressable//lib/addressable/uri.rb#2094
  def route_from(uri); end

  # Returns the shortest normalized relative form of the supplied URI that
  # uses this URI as a base for resolution. Returns an absolute URI if
  # necessary. This is effectively the opposite of <code>route_from</code>.
  #
  # @param uri [String, Addressable::URI, #to_str] The URI to route to.
  # @return [Addressable::URI] The normalized relative URI that is equivalent to the supplied URI.
  #
  # source://addressable//lib/addressable/uri.rb#2159
  def route_to(uri); end

  # The scheme component for this URI.
  #
  # @return [String] The scheme component.
  #
  # source://addressable//lib/addressable/uri.rb#881
  def scheme; end

  # Sets the scheme component for this URI.
  #
  # @param new_scheme [String, #to_str] The new scheme component.
  #
  # source://addressable//lib/addressable/uri.rb#910
  def scheme=(new_scheme); end

  # The combination of components that represent a site.
  # Combines the scheme, user, password, host, and port components.
  # Primarily useful for HTTP and HTTPS.
  #
  # For example, <code>"http://example.com/path?query"</code> would have a
  # <code>site</code> value of <code>"http://example.com"</code>.
  #
  # @return [String] The components that identify a site.
  #
  # source://addressable//lib/addressable/uri.rb#1470
  def site; end

  # Sets the site value for this URI.
  #
  # @param new_site [String, #to_str] The new site value.
  #
  # source://addressable//lib/addressable/uri.rb#1509
  def site=(new_site); end

  # Returns the top-level domain for this host.
  #
  # @example
  #   Addressable::URI.parse("http://www.example.co.uk").tld # => "co.uk"
  #
  # source://addressable//lib/addressable/uri.rb#1208
  def tld; end

  # Sets the top-level domain for this URI.
  #
  # @param new_tld [String, #to_str] The new top-level domain.
  #
  # source://addressable//lib/addressable/uri.rb#1216
  def tld=(new_tld); end

  # Returns a Hash of the URI components.
  #
  # @return [Hash] The URI as a <code>Hash</code> of components.
  #
  # source://addressable//lib/addressable/uri.rb#2376
  def to_hash; end

  # Converts the URI to a <code>String</code>.
  #
  # @return [String] The URI's <code>String</code> representation.
  #
  # source://addressable//lib/addressable/uri.rb#2350
  def to_s; end

  # Converts the URI to a <code>String</code>.
  # URI's are glorified <code>Strings</code>. Allow implicit conversion.
  #
  # @return [String] The URI's <code>String</code> representation.
  #
  # source://addressable//lib/addressable/uri.rb#2350
  def to_str; end

  # The user component for this URI.
  #
  # @return [String] The user component.
  #
  # source://addressable//lib/addressable/uri.rb#934
  def user; end

  # Sets the user component for this URI.
  #
  # @param new_user [String, #to_str] The new user component.
  #
  # source://addressable//lib/addressable/uri.rb#965
  def user=(new_user); end

  # The userinfo component for this URI.
  # Combines the user and password components.
  #
  # @return [String] The userinfo component.
  #
  # source://addressable//lib/addressable/uri.rb#1051
  def userinfo; end

  # Sets the userinfo component for this URI.
  #
  # @param new_userinfo [String, #to_str] The new userinfo component.
  #
  # source://addressable//lib/addressable/uri.rb#1090
  def userinfo=(new_userinfo); end

  protected

  # Converts the string to be UTF-8 if it is not already UTF-8
  #
  # @api private
  #
  # source://addressable//lib/addressable/uri.rb#2554
  def force_utf8_encoding_if_needed(str); end

  # Resets composite values for the entire URI
  #
  # @api private
  #
  # source://addressable//lib/addressable/uri.rb#2545
  def remove_composite_values; end

  # Replaces the internal state of self with the specified URI's state.
  # Used in destructive operations to avoid massive code repetition.
  #
  # @param uri [Addressable::URI] The URI to replace <code>self</code> with.
  # @return [Addressable::URI] <code>self</code>.
  #
  # source://addressable//lib/addressable/uri.rb#2508
  def replace_self(uri); end

  # Splits path string with "/" (slash).
  # It is considered that there is empty string after last slash when
  # path ends with slash.
  #
  # @param path [String] The path to split.
  # @return [Array<String>] An array of parts of path.
  #
  # source://addressable//lib/addressable/uri.rb#2535
  def split_path(path); end

  # Ensures that the URI is valid.
  #
  # source://addressable//lib/addressable/uri.rb#2465
  def validate; end

  class << self
    # Converts a path to a file scheme URI. If the path supplied is
    # relative, it will be returned as a relative URI. If the path supplied
    # is actually a non-file URI, it will parse the URI as if it had been
    # parsed with <code>Addressable::URI.parse</code>. Handles all of the
    # various Microsoft-specific formats for specifying paths.
    #
    # @example
    #   base = Addressable::URI.convert_path("/absolute/path/")
    #   uri = Addressable::URI.convert_path("relative/path")
    #   (base + uri).to_s
    #   #=> "file:///absolute/path/relative/path"
    #
    #   Addressable::URI.convert_path(
    #   "c:\\windows\\My Documents 100%20\\foo.txt"
    #   ).to_s
    #   #=> "file:///c:/windows/My%20Documents%20100%20/foo.txt"
    #
    #   Addressable::URI.convert_path("http://example.com/").to_s
    #   #=> "http://example.com/"
    # @param path [String, Addressable::URI, #to_str] Typically a <code>String</code> path to a file or directory, but
    #   will return a sensible return value if an absolute URI is supplied
    #   instead.
    # @return [Addressable::URI] The parsed file scheme URI or the original URI if some other URI
    #   scheme was provided.
    #
    # source://addressable//lib/addressable/uri.rb#279
    def convert_path(path); end

    # Percent encodes any special characters in the URI.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI to encode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @return [String, Addressable::URI] The encoded URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#609
    def encode(uri, return_type = T.unsafe(nil)); end

    # Percent encodes a URI component.
    #
    #  '9' to be percent encoded. If a <code>Regexp</code> is passed, the
    #   value <code>/[^b-zB-Z0-9]/</code> would have the same effect. A set of
    #   useful <code>String</code> values may be found in the
    #   <code>Addressable::URI::CharacterClasses</code> module. The default
    #   value is the reserved plus unreserved character classes specified in
    #   <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>.
    #
    # @example
    #   Addressable::URI.encode_component("simple/example", "b-zB-Z0-9")
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.encode_component("simple/example", /[^b-zB-Z0-9]/)
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.encode_component(
    #   "simple/example", Addressable::URI::CharacterClasses::UNRESERVED
    #   )
    #   => "simple%2Fexample"
    # @param component [String, #to_str] The URI component to encode.
    # @param character_class [String, Regexp] The characters which are not percent encoded. If a <code>String</code>
    #   is passed, the <code>String</code> must be formatted as a regular
    #   expression character class. (Do not include the surrounding square
    #   brackets.)  For example, <code>"b-zB-Z0-9"</code> would cause
    #   everything but the letters 'b' through 'z' and the numbers '0' through
    # @param upcase_encoded [Regexp] A string of characters that may already be percent encoded, and whose
    #   encodings should be upcased. This allows normalization of percent
    #   encodings for characters not included in the
    #   <code>character_class</code>.
    # @return [String] The encoded component.
    #
    # source://addressable//lib/addressable/uri.rb#394
    def encode_component(component, character_class = T.unsafe(nil), upcase_encoded = T.unsafe(nil)); end

    # Percent encodes any special characters in the URI.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI to encode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @return [String, Addressable::URI] The encoded URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#609
    def escape(uri, return_type = T.unsafe(nil)); end

    # Percent encodes a URI component.
    #
    #  '9' to be percent encoded. If a <code>Regexp</code> is passed, the
    #   value <code>/[^b-zB-Z0-9]/</code> would have the same effect. A set of
    #   useful <code>String</code> values may be found in the
    #   <code>Addressable::URI::CharacterClasses</code> module. The default
    #   value is the reserved plus unreserved character classes specified in
    #   <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>.
    #
    # @example
    #   Addressable::URI.encode_component("simple/example", "b-zB-Z0-9")
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.encode_component("simple/example", /[^b-zB-Z0-9]/)
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.encode_component(
    #   "simple/example", Addressable::URI::CharacterClasses::UNRESERVED
    #   )
    #   => "simple%2Fexample"
    # @param component [String, #to_str] The URI component to encode.
    # @param character_class [String, Regexp] The characters which are not percent encoded. If a <code>String</code>
    #   is passed, the <code>String</code> must be formatted as a regular
    #   expression character class. (Do not include the surrounding square
    #   brackets.)  For example, <code>"b-zB-Z0-9"</code> would cause
    #   everything but the letters 'b' through 'z' and the numbers '0' through
    # @param upcase_encoded [Regexp] A string of characters that may already be percent encoded, and whose
    #   encodings should be upcased. This allows normalization of percent
    #   encodings for characters not included in the
    #   <code>character_class</code>.
    # @return [String] The encoded component.
    #
    # source://addressable//lib/addressable/uri.rb#394
    def escape_component(component, character_class = T.unsafe(nil), upcase_encoded = T.unsafe(nil)); end

    # Encodes a set of key/value pairs according to the rules for the
    # <code>application/x-www-form-urlencoded</code> MIME type.
    #
    # @param form_values [#to_hash, #to_ary] The form values to encode.
    # @param sort [TrueClass, FalseClass] Sort the key/value pairs prior to encoding.
    #   Defaults to <code>false</code>.
    # @return [String] The encoded value.
    #
    # source://addressable//lib/addressable/uri.rb#734
    def form_encode(form_values, sort = T.unsafe(nil)); end

    # Decodes a <code>String</code> according to the rules for the
    # <code>application/x-www-form-urlencoded</code> MIME type.
    #
    # @param encoded_value [String, #to_str] The form values to decode.
    # @return [Array] The decoded values.
    #   This is not a <code>Hash</code> because of the possibility for
    #   duplicate keys.
    #
    # source://addressable//lib/addressable/uri.rb#787
    def form_unencode(encoded_value); end

    # Converts an input to a URI. The input does not have to be a valid
    # URI — the method will use heuristics to guess what URI was intended.
    # This is not standards-compliant, merely user-friendly.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI string to parse.
    #   No parsing is performed if the object is already an
    #   <code>Addressable::URI</code>.
    # @param hints [Hash] A <code>Hash</code> of hints to the heuristic parser.
    #   Defaults to <code>{:scheme => "http"}</code>.
    # @return [Addressable::URI] The parsed URI.
    #
    # source://addressable//lib/addressable/uri.rb#178
    def heuristic_parse(uri, hints = T.unsafe(nil)); end

    # Returns an array of known ip-based schemes. These schemes typically
    # use a similar URI form:
    # <code>//<user>:<password>@<host>:<port>/<url-path></code>
    #
    # source://addressable//lib/addressable/uri.rb#1370
    def ip_based_schemes; end

    # Joins several URIs together.
    #
    # @example
    #   base = "http://example.com/"
    #   uri = Addressable::URI.parse("relative/path")
    #   Addressable::URI.join(base, uri)
    #   #=> #<Addressable::URI:0xcab390 URI:http://example.com/relative/path>
    # @param *uris [String, Addressable::URI, #to_str] The URIs to join.
    # @return [Addressable::URI] The joined URI.
    #
    # source://addressable//lib/addressable/uri.rb#330
    def join(*uris); end

    # Normalizes the encoding of a URI component.
    #
    # @example
    #   Addressable::URI.normalize_component("simpl%65/%65xampl%65", "b-zB-Z")
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.normalize_component(
    #   "simpl%65/%65xampl%65", /[^b-zB-Z]/
    #   )
    #   => "simple%2Fex%61mple"
    #   Addressable::URI.normalize_component(
    #   "simpl%65/%65xampl%65",
    #   Addressable::URI::CharacterClasses::UNRESERVED
    #   )
    #   => "simple%2Fexample"
    #   Addressable::URI.normalize_component(
    #   "one%20two%2fthree%26four",
    #   "0-9a-zA-Z &/",
    #   "/"
    #   )
    #   => "one two%2Fthree&four"
    # @param component [String, #to_str] The URI component to encode.
    # @param character_class [String, Regexp] The characters which are not percent encoded. If a <code>String</code>
    #   is passed, the <code>String</code> must be formatted as a regular
    #   expression character class. (Do not include the surrounding square
    #   brackets.)  For example, <code>"b-zB-Z0-9"</code> would cause
    #   everything but the letters 'b' through 'z' and the numbers '0'
    #   through '9' to be percent encoded. If a <code>Regexp</code> is passed,
    #   the value <code>/[^b-zB-Z0-9]/</code> would have the same effect. A
    #   set of useful <code>String</code> values may be found in the
    #   <code>Addressable::URI::CharacterClasses</code> module. The default
    #   value is the reserved plus unreserved character classes specified in
    #   <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>.
    # @param leave_encoded [String] When <code>character_class</code> is a <code>String</code> then
    #   <code>leave_encoded</code> is a string of characters that should remain
    #   percent encoded while normalizing the component; if they appear percent
    #   encoded in the original component, then they will be upcased ("%2f"
    #   normalized to "%2F") but otherwise left alone.
    # @return [String] The normalized component.
    #
    # source://addressable//lib/addressable/uri.rb#544
    def normalize_component(component, character_class = T.unsafe(nil), leave_encoded = T.unsafe(nil)); end

    # Resolves paths to their simplest form.
    #
    # @param path [String] The path to normalize.
    # @return [String] The normalized path.
    #
    # source://addressable//lib/addressable/uri.rb#2429
    def normalize_path(path); end

    # Normalizes the encoding of a URI. Characters within a hostname are
    # not percent encoded to allow for internationalized domain names.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI to encode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @return [String, Addressable::URI] The encoded URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#664
    def normalized_encode(uri, return_type = T.unsafe(nil)); end

    # Returns a URI object based on the parsed string.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI string to parse.
    #   No parsing is performed if the object is already an
    #   <code>Addressable::URI</code>.
    # @return [Addressable::URI] The parsed URI.
    #
    # source://addressable//lib/addressable/uri.rb#101
    def parse(uri); end

    # Returns a hash of common IP-based schemes and their default port
    # numbers. Adding new schemes to this hash, as necessary, will allow
    # for better URI normalization.
    #
    # source://addressable//lib/addressable/uri.rb#1377
    def port_mapping; end

    # Unencodes any percent encoded characters within a URI component.
    # This method may be used for unencoding either components or full URIs,
    # however, it is recommended to use the <code>unencode_component</code>
    # alias when unencoding components.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI or component to unencode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @param leave_encoded [String] A string of characters to leave encoded. If a percent encoded character
    #   in this list is encountered then it will remain percent encoded.
    # @return [String, Addressable::URI] The unencoded component or URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#464
    def unencode(uri, return_type = T.unsafe(nil), leave_encoded = T.unsafe(nil)); end

    # Unencodes any percent encoded characters within a URI component.
    # This method may be used for unencoding either components or full URIs,
    # however, it is recommended to use the <code>unencode_component</code>
    # alias when unencoding components.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI or component to unencode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @param leave_encoded [String] A string of characters to leave encoded. If a percent encoded character
    #   in this list is encountered then it will remain percent encoded.
    # @return [String, Addressable::URI] The unencoded component or URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#464
    def unencode_component(uri, return_type = T.unsafe(nil), leave_encoded = T.unsafe(nil)); end

    # Unencodes any percent encoded characters within a URI component.
    # This method may be used for unencoding either components or full URIs,
    # however, it is recommended to use the <code>unencode_component</code>
    # alias when unencoding components.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI or component to unencode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @param leave_encoded [String] A string of characters to leave encoded. If a percent encoded character
    #   in this list is encountered then it will remain percent encoded.
    # @return [String, Addressable::URI] The unencoded component or URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#464
    def unescape(uri, return_type = T.unsafe(nil), leave_encoded = T.unsafe(nil)); end

    # Unencodes any percent encoded characters within a URI component.
    # This method may be used for unencoding either components or full URIs,
    # however, it is recommended to use the <code>unencode_component</code>
    # alias when unencoding components.
    #
    # @param uri [String, Addressable::URI, #to_str] The URI or component to unencode.
    # @param return_type [Class] The type of object to return.
    #   This value may only be set to <code>String</code> or
    #   <code>Addressable::URI</code>. All other values are invalid. Defaults
    #   to <code>String</code>.
    # @param leave_encoded [String] A string of characters to leave encoded. If a percent encoded character
    #   in this list is encountered then it will remain percent encoded.
    # @return [String, Addressable::URI] The unencoded component or URI.
    #   The return type is determined by the <code>return_type</code>
    #   parameter.
    #
    # source://addressable//lib/addressable/uri.rb#464
    def unescape_component(uri, return_type = T.unsafe(nil), leave_encoded = T.unsafe(nil)); end
  end
end

# Container for the character classes specified in
# <a href="http://www.ietf.org/rfc/rfc3986.txt">RFC 3986</a>.
#
# Note: Concatenated and interpolated `String`s are not affected by the
#       `frozen_string_literal` directive and must be frozen explicitly.
#
#       Interpolated `String`s *were* frozen this way before Ruby 3.0:
#       https://bugs.ruby-lang.org/issues/17104
module Addressable::URI::CharacterClasses; end

# source://addressable//lib/addressable/uri.rb#47
Addressable::URI::CharacterClasses::ALPHA = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#56
Addressable::URI::CharacterClasses::AUTHORITY = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#48
Addressable::URI::CharacterClasses::DIGIT = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#59
Addressable::URI::CharacterClasses::FRAGMENT = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#49
Addressable::URI::CharacterClasses::GEN_DELIMS = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#55
Addressable::URI::CharacterClasses::HOST = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#57
Addressable::URI::CharacterClasses::PATH = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#53
Addressable::URI::CharacterClasses::PCHAR = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#58
Addressable::URI::CharacterClasses::QUERY = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#51
Addressable::URI::CharacterClasses::RESERVED = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#54
Addressable::URI::CharacterClasses::SCHEME = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#50
Addressable::URI::CharacterClasses::SUB_DELIMS = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#52
Addressable::URI::CharacterClasses::UNRESERVED = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#72
Addressable::URI::EMPTY_STR = T.let(T.unsafe(nil), String)

# Raised if something other than a uri is supplied.
class Addressable::URI::InvalidURIError < ::StandardError; end

# source://addressable//lib/addressable/uri.rb#1535
Addressable::URI::NORMPATH = T.let(T.unsafe(nil), Regexp)

module Addressable::URI::NormalizeCharacterClasses; end

# source://addressable//lib/addressable/uri.rb#67
Addressable::URI::NormalizeCharacterClasses::FRAGMENT = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#63
Addressable::URI::NormalizeCharacterClasses::HOST = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#65
Addressable::URI::NormalizeCharacterClasses::PCHAR = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#68
Addressable::URI::NormalizeCharacterClasses::QUERY = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#66
Addressable::URI::NormalizeCharacterClasses::SCHEME = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#64
Addressable::URI::NormalizeCharacterClasses::UNRESERVED = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#2416
Addressable::URI::PARENT = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#76
Addressable::URI::PORT_MAPPING = T.let(T.unsafe(nil), Hash)

# source://addressable//lib/addressable/uri.rb#2418
Addressable::URI::RULE_2A = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#2419
Addressable::URI::RULE_2B_2C = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#2420
Addressable::URI::RULE_2D = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#2421
Addressable::URI::RULE_PREFIXED_PARENT = T.let(T.unsafe(nil), Regexp)

# source://addressable//lib/addressable/uri.rb#2415
Addressable::URI::SELF_REF = T.let(T.unsafe(nil), String)

# Tables used to optimize encoding operations in `self.encode_component`
# and `self.normalize_component`
#
# source://addressable//lib/addressable/uri.rb#347
Addressable::URI::SEQUENCE_ENCODING_TABLE = T.let(T.unsafe(nil), Hash)

# source://addressable//lib/addressable/uri.rb#353
Addressable::URI::SEQUENCE_UPCASED_PERCENT_ENCODING_TABLE = T.let(T.unsafe(nil), Hash)

# source://addressable//lib/addressable/uri.rb#71
Addressable::URI::SLASH = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/uri.rb#74
Addressable::URI::URIREGEX = T.let(T.unsafe(nil), Regexp)

module Addressable::VERSION; end

# source://addressable//lib/addressable/version.rb#24
Addressable::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/version.rb#25
Addressable::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://addressable//lib/addressable/version.rb#28
Addressable::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://addressable//lib/addressable/version.rb#26
Addressable::VERSION::TINY = T.let(T.unsafe(nil), Integer)
