# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `activerecord` gem.
# Please instead update this file by running `bin/tapioca gem activerecord`.

module ActiveRecord
  extend ::ActiveSupport::Autoload

  class << self
    # source://activerecord//lib/active_record.rb#277
    def action_on_strict_loading_violation; end

    # source://activerecord//lib/active_record.rb#277
    def action_on_strict_loading_violation=(_arg0); end

    # source://activerecord//lib/active_record.rb#270
    def application_record_class; end

    # source://activerecord//lib/active_record.rb#270
    def application_record_class=(_arg0); end

    # source://activerecord//lib/active_record.rb#213
    def async_query_executor; end

    # source://activerecord//lib/active_record.rb#213
    def async_query_executor=(_arg0); end

    # source://activerecord//lib/active_record.rb#183
    def default_timezone; end

    # Determines whether to use Time.utc (using :utc) or Time.local (using :local) when pulling
    # dates and times from the database. This is set to :utc by default.
    #
    # source://activerecord//lib/active_record.rb#187
    def default_timezone=(default_timezone); end

    # source://activerecord//lib/active_record.rb#311
    def dump_schema_after_migration; end

    # source://activerecord//lib/active_record.rb#311
    def dump_schema_after_migration=(_arg0); end

    # source://activerecord//lib/active_record.rb#321
    def dump_schemas; end

    # source://activerecord//lib/active_record.rb#321
    def dump_schemas=(_arg0); end

    # source://activerecord//lib/active_record.rb#357
    def eager_load!; end

    # source://activerecord//lib/active_record.rb#296
    def error_on_ignored_order; end

    # source://activerecord//lib/active_record.rb#296
    def error_on_ignored_order=(_arg0); end

    # Returns the currently loaded version of Active Record as a <tt>Gem::Version</tt>.
    #
    # source://activerecord//lib/active_record/gem_version.rb#5
    def gem_version; end

    # source://activerecord//lib/active_record.rb#236
    def global_executor_concurrency; end

    # Set the +global_executor_concurrency+. This configuration value can only be used
    # with the global thread pool async query executor.
    #
    # source://activerecord//lib/active_record.rb#228
    def global_executor_concurrency=(global_executor_concurrency); end

    # source://activerecord//lib/active_record.rb#216
    def global_thread_pool_async_query_executor; end

    # source://activerecord//lib/active_record.rb#240
    def index_nested_attribute_errors; end

    # source://activerecord//lib/active_record.rb#240
    def index_nested_attribute_errors=(_arg0); end

    # source://activerecord//lib/active_record.rb#171
    def lazily_load_schema_cache; end

    # source://activerecord//lib/active_record.rb#171
    def lazily_load_schema_cache=(_arg0); end

    # source://activerecord//lib/active_record.rb#180
    def legacy_connection_handling; end

    # source://activerecord//lib/active_record.rb#180
    def legacy_connection_handling=(_arg0); end

    # source://activerecord//lib/active_record.rb#258
    def maintain_test_schema; end

    # source://activerecord//lib/active_record.rb#258
    def maintain_test_schema=(_arg0); end

    # source://activerecord//lib/active_record.rb#340
    def query_transformers; end

    # source://activerecord//lib/active_record.rb#340
    def query_transformers=(_arg0); end

    # source://activerecord//lib/active_record.rb#255
    def queues; end

    # source://activerecord//lib/active_record.rb#255
    def queues=(_arg0); end

    # source://activerecord//lib/active_record.rb#200
    def reading_role; end

    # source://activerecord//lib/active_record.rb#200
    def reading_role=(_arg0); end

    # source://activerecord//lib/active_record.rb#177
    def schema_cache_ignored_tables; end

    # source://activerecord//lib/active_record.rb#177
    def schema_cache_ignored_tables=(_arg0); end

    # source://activerecord//lib/active_record.rb#288
    def schema_format; end

    # source://activerecord//lib/active_record.rb#288
    def schema_format=(_arg0); end

    # source://activerecord//lib/active_record.rb#328
    def suppress_multiple_database_warning; end

    # source://activerecord//lib/active_record.rb#328
    def suppress_multiple_database_warning=(_arg0); end

    # source://activerecord//lib/active_record.rb#302
    def timestamped_migrations; end

    # source://activerecord//lib/active_record.rb#302
    def timestamped_migrations=(_arg0); end

    # source://activerecord//lib/active_record.rb#347
    def use_yaml_unsafe_load; end

    # source://activerecord//lib/active_record.rb#347
    def use_yaml_unsafe_load=(_arg0); end

    # source://activerecord//lib/active_record.rb#248
    def verbose_query_logs; end

    # source://activerecord//lib/active_record.rb#248
    def verbose_query_logs=(_arg0); end

    # source://activerecord//lib/active_record.rb#337
    def verify_foreign_keys_for_fixtures; end

    # source://activerecord//lib/active_record.rb#337
    def verify_foreign_keys_for_fixtures=(_arg0); end

    # Returns the currently loaded version of Active Record as a <tt>Gem::Version</tt>.
    #
    # source://activerecord//lib/active_record/version.rb#7
    def version; end

    # source://activerecord//lib/active_record.rb#267
    def warn_on_records_fetched_greater_than; end

    # source://activerecord//lib/active_record.rb#267
    def warn_on_records_fetched_greater_than=(_arg0); end

    # source://activerecord//lib/active_record.rb#197
    def writing_role; end

    # source://activerecord//lib/active_record.rb#197
    def writing_role=(_arg0); end

    # source://activerecord//lib/active_record.rb#354
    def yaml_column_permitted_classes; end

    # source://activerecord//lib/active_record.rb#354
    def yaml_column_permitted_classes=(_arg0); end
  end
end

# Raised when trying to use a feature in Active Record which requires Active Job but the gem is not present.
class ActiveRecord::ActiveJobRequiredError < ::ActiveRecord::ActiveRecordError; end

# = Active Record Errors
#
# Generic Active Record exception class.
class ActiveRecord::ActiveRecordError < ::StandardError; end

# Raised when Active Record cannot find database adapter specified in
# +config/database.yml+ or programmatically.
class ActiveRecord::AdapterNotFound < ::ActiveRecord::ActiveRecordError; end

# Raised when adapter not specified on connection (or configuration file
# +config/database.yml+ misses adapter field).
class ActiveRecord::AdapterNotSpecified < ::ActiveRecord::ActiveRecordError; end

# AdapterTimeout will be raised when database clients times out while waiting from the server.
class ActiveRecord::AdapterTimeout < ::ActiveRecord::QueryAborted; end

# See ActiveRecord::Aggregations::ClassMethods for documentation
module ActiveRecord::Aggregations
  # source://activerecord//lib/active_record/aggregations.rb#11
  def reload(*_arg0); end

  private

  # source://activerecord//lib/active_record/aggregations.rb#17
  def clear_aggregation_cache; end

  # source://activerecord//lib/active_record/aggregations.rb#21
  def init_internals; end

  # source://activerecord//lib/active_record/aggregations.rb#6
  def initialize_dup(*_arg0); end
end

# Active Record implements aggregation through a macro-like class method called #composed_of
# for representing attributes as value objects. It expresses relationships like "Account [is]
# composed of Money [among other things]" or "Person [is] composed of [an] address". Each call
# to the macro adds a description of how the value objects are created from the attributes of
# the entity object (when the entity is initialized either as a new object or from finding an
# existing object) and how it can be turned back into attributes (when the entity is saved to
# the database).
#
#   class Customer < ActiveRecord::Base
#     composed_of :balance, class_name: "Money", mapping: %w(balance amount)
#     composed_of :address, mapping: [ %w(address_street street), %w(address_city city) ]
#   end
#
# The customer class now has the following methods to manipulate the value objects:
# * <tt>Customer#balance, Customer#balance=(money)</tt>
# * <tt>Customer#address, Customer#address=(address)</tt>
#
# These methods will operate with value objects like the ones described below:
#
#  class Money
#    include Comparable
#    attr_reader :amount, :currency
#    EXCHANGE_RATES = { "USD_TO_DKK" => 6 }
#
#    def initialize(amount, currency = "USD")
#      @amount, @currency = amount, currency
#    end
#
#    def exchange_to(other_currency)
#      exchanged_amount = (amount * EXCHANGE_RATES["#{currency}_TO_#{other_currency}"]).floor
#      Money.new(exchanged_amount, other_currency)
#    end
#
#    def ==(other_money)
#      amount == other_money.amount && currency == other_money.currency
#    end
#
#    def <=>(other_money)
#      if currency == other_money.currency
#        amount <=> other_money.amount
#      else
#        amount <=> other_money.exchange_to(currency).amount
#      end
#    end
#  end
#
#  class Address
#    attr_reader :street, :city
#    def initialize(street, city)
#      @street, @city = street, city
#    end
#
#    def close_to?(other_address)
#      city == other_address.city
#    end
#
#    def ==(other_address)
#      city == other_address.city && street == other_address.street
#    end
#  end
#
# Now it's possible to access attributes from the database through the value objects instead. If
# you choose to name the composition the same as the attribute's name, it will be the only way to
# access that attribute. That's the case with our +balance+ attribute. You interact with the value
# objects just like you would with any other attribute:
#
#   customer.balance = Money.new(20)     # sets the Money value object and the attribute
#   customer.balance                     # => Money value object
#   customer.balance.exchange_to("DKK")  # => Money.new(120, "DKK")
#   customer.balance > Money.new(10)     # => true
#   customer.balance == Money.new(20)    # => true
#   customer.balance < Money.new(5)      # => false
#
# Value objects can also be composed of multiple attributes, such as the case of Address. The order
# of the mappings will determine the order of the parameters.
#
#   customer.address_street = "Hyancintvej"
#   customer.address_city   = "Copenhagen"
#   customer.address        # => Address.new("Hyancintvej", "Copenhagen")
#
#   customer.address = Address.new("May Street", "Chicago")
#   customer.address_street # => "May Street"
#   customer.address_city   # => "Chicago"
#
# == Writing value objects
#
# Value objects are immutable and interchangeable objects that represent a given value, such as
# a Money object representing $5. Two Money objects both representing $5 should be equal (through
# methods such as <tt>==</tt> and <tt><=></tt> from Comparable if ranking makes sense). This is
# unlike entity objects where equality is determined by identity. An entity class such as Customer can
# easily have two different objects that both have an address on Hyancintvej. Entity identity is
# determined by object or relational unique identifiers (such as primary keys). Normal
# ActiveRecord::Base classes are entity objects.
#
# It's also important to treat the value objects as immutable. Don't allow the Money object to have
# its amount changed after creation. Create a new Money object with the new value instead. The
# <tt>Money#exchange_to</tt> method is an example of this. It returns a new value object instead of changing
# its own values. Active Record won't persist value objects that have been changed through means
# other than the writer method.
#
# The immutable requirement is enforced by Active Record by freezing any object assigned as a value
# object. Attempting to change it afterwards will result in a +RuntimeError+.
#
# Read more about value objects on http://c2.com/cgi/wiki?ValueObject and on the dangers of not
# keeping value objects immutable on http://c2.com/cgi/wiki?ValueObjectsShouldBeImmutable
#
# == Custom constructors and converters
#
# By default value objects are initialized by calling the <tt>new</tt> constructor of the value
# class passing each of the mapped attributes, in the order specified by the <tt>:mapping</tt>
# option, as arguments. If the value class doesn't support this convention then #composed_of allows
# a custom constructor to be specified.
#
# When a new value is assigned to the value object, the default assumption is that the new value
# is an instance of the value class. Specifying a custom converter allows the new value to be automatically
# converted to an instance of value class if necessary.
#
# For example, the +NetworkResource+ model has +network_address+ and +cidr_range+ attributes that should be
# aggregated using the +NetAddr::CIDR+ value class (https://www.rubydoc.info/gems/netaddr/1.5.0/NetAddr/CIDR).
# The constructor for the value class is called +create+ and it expects a CIDR address string as a parameter.
# New values can be assigned to the value object using either another +NetAddr::CIDR+ object, a string
# or an array. The <tt>:constructor</tt> and <tt>:converter</tt> options can be used to meet
# these requirements:
#
#   class NetworkResource < ActiveRecord::Base
#     composed_of :cidr,
#                 class_name: 'NetAddr::CIDR',
#                 mapping: [ %w(network_address network), %w(cidr_range bits) ],
#                 allow_nil: true,
#                 constructor: Proc.new { |network_address, cidr_range| NetAddr::CIDR.create("#{network_address}/#{cidr_range}") },
#                 converter: Proc.new { |value| NetAddr::CIDR.create(value.is_a?(Array) ? value.join('/') : value) }
#   end
#
#   # This calls the :constructor
#   network_resource = NetworkResource.new(network_address: '192.168.0.1', cidr_range: 24)
#
#   # These assignments will both use the :converter
#   network_resource.cidr = [ '192.168.2.1', 8 ]
#   network_resource.cidr = '192.168.0.1/24'
#
#   # This assignment won't use the :converter as the value is already an instance of the value class
#   network_resource.cidr = NetAddr::CIDR.create('192.168.2.1/8')
#
#   # Saving and then reloading will use the :constructor on reload
#   network_resource.save
#   network_resource.reload
#
# == Finding records by a value object
#
# Once a #composed_of relationship is specified for a model, records can be loaded from the database
# by specifying an instance of the value object in the conditions hash. The following example
# finds all customers with +address_street+ equal to "May Street" and +address_city+ equal to "Chicago":
#
#   Customer.where(address: Address.new("May Street", "Chicago"))
module ActiveRecord::Aggregations::ClassMethods
  # Adds reader and writer methods for manipulating a value object:
  # <tt>composed_of :address</tt> adds <tt>address</tt> and <tt>address=(new_address)</tt> methods.
  #
  # Options are:
  # * <tt>:class_name</tt> - Specifies the class name of the association. Use it only if that name
  #   can't be inferred from the part id. So <tt>composed_of :address</tt> will by default be linked
  #   to the Address class, but if the real class name is +CompanyAddress+, you'll have to specify it
  #   with this option.
  # * <tt>:mapping</tt> - Specifies the mapping of entity attributes to attributes of the value
  #   object. Each mapping is represented as an array where the first item is the name of the
  #   entity attribute and the second item is the name of the attribute in the value object. The
  #   order in which mappings are defined determines the order in which attributes are sent to the
  #   value class constructor.
  # * <tt>:allow_nil</tt> - Specifies that the value object will not be instantiated when all mapped
  #   attributes are +nil+. Setting the value object to +nil+ has the effect of writing +nil+ to all
  #   mapped attributes.
  #   This defaults to +false+.
  # * <tt>:constructor</tt> - A symbol specifying the name of the constructor method or a Proc that
  #   is called to initialize the value object. The constructor is passed all of the mapped attributes,
  #   in the order that they are defined in the <tt>:mapping option</tt>, as arguments and uses them
  #   to instantiate a <tt>:class_name</tt> object.
  #   The default is <tt>:new</tt>.
  # * <tt>:converter</tt> - A symbol specifying the name of a class method of <tt>:class_name</tt>
  #   or a Proc that is called when a new value is assigned to the value object. The converter is
  #   passed the single value that is used in the assignment and is only called if the new value is
  #   not an instance of <tt>:class_name</tt>. If <tt>:allow_nil</tt> is set to true, the converter
  #   can return +nil+ to skip the assignment.
  #
  # Option examples:
  #   composed_of :temperature, mapping: %w(reading celsius)
  #   composed_of :balance, class_name: "Money", mapping: %w(balance amount)
  #   composed_of :address, mapping: [ %w(address_street street), %w(address_city city) ]
  #   composed_of :gps_location
  #   composed_of :gps_location, allow_nil: true
  #   composed_of :ip_address,
  #               class_name: 'IPAddr',
  #               mapping: %w(ip to_i),
  #               constructor: Proc.new { |ip| IPAddr.new(ip, Socket::AF_INET) },
  #               converter: Proc.new { |ip| ip.is_a?(Integer) ? IPAddr.new(ip, Socket::AF_INET) : IPAddr.new(ip.to_s) }
  #
  # source://activerecord//lib/active_record/aggregations.rb#222
  def composed_of(part_id, options = T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/aggregations.rb#245
  def reader_method(name, class_name, mapping, allow_nil, constructor); end

  # source://activerecord//lib/active_record/aggregations.rb#258
  def writer_method(name, class_name, mapping, allow_nil, converter); end
end

class ActiveRecord::AmbiguousSourceReflectionForThroughAssociation < ::ActiveRecord::ActiveRecordError
  # @return [AmbiguousSourceReflectionForThroughAssociation] a new instance of AmbiguousSourceReflectionForThroughAssociation
  #
  # source://activerecord//lib/active_record/associations.rb#188
  def initialize(klass, macro, association_name, options, possible_sources); end
end

class ActiveRecord::AssociationNotFoundError < ::ActiveRecord::ConfigurationError
  include ::DidYouMean::Correctable

  # @return [AssociationNotFoundError] a new instance of AssociationNotFoundError
  #
  # source://activerecord//lib/active_record/associations.rb#7
  def initialize(record = T.unsafe(nil), association_name = T.unsafe(nil)); end

  # Returns the value of attribute association_name.
  #
  # source://activerecord//lib/active_record/associations.rb#5
  def association_name; end

  # source://activerecord//lib/active_record/associations.rb#20
  def corrections; end

  # Returns the value of attribute record.
  #
  # source://activerecord//lib/active_record/associations.rb#5
  def record; end
end

class ActiveRecord::AssociationRelation < ::ActiveRecord::Relation
  # @return [AssociationRelation] a new instance of AssociationRelation
  #
  # source://activerecord//lib/active_record/association_relation.rb#5
  def initialize(klass, association, **_arg2); end

  # source://activerecord//lib/active_record/association_relation.rb#14
  def ==(other); end

  def insert(attributes, **kwargs); end
  def insert!(attributes, **kwargs); end
  def insert_all(attributes, **kwargs); end
  def insert_all!(attributes, **kwargs); end

  # source://activerecord//lib/active_record/association_relation.rb#10
  def proxy_association; end

  def upsert(attributes, **kwargs); end
  def upsert_all(attributes, **kwargs); end

  private

  # source://activerecord//lib/active_record/association_relation.rb#35
  def _create(attributes, &block); end

  # source://activerecord//lib/active_record/association_relation.rb#39
  def _create!(attributes, &block); end

  # source://activerecord//lib/active_record/association_relation.rb#31
  def _new(attributes, &block); end

  # source://activerecord//lib/active_record/association_relation.rb#43
  def exec_queries; end
end

# Raised when an object assigned to an association has an incorrect type.
#
#   class Ticket < ActiveRecord::Base
#     has_many :patches
#   end
#
#   class Patch < ActiveRecord::Base
#     belongs_to :ticket
#   end
#
#   # Comments are not patches, this assignment raises AssociationTypeMismatch.
#   @ticket.patches << Comment.new(content: "Please attach tests to your patch.")
class ActiveRecord::AssociationTypeMismatch < ::ActiveRecord::ActiveRecordError; end

# See ActiveRecord::Associations::ClassMethods for documentation.
module ActiveRecord::Associations
  extend ::ActiveSupport::Autoload
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Associations::ClassMethods

  # Returns the association instance for the given name, instantiating it if it doesn't already exist
  #
  # source://activerecord//lib/active_record/associations.rb#297
  def association(name); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations.rb#311
  def association_cached?(name); end

  private

  # Returns the specified association instance if it exists, +nil+ otherwise.
  #
  # source://activerecord//lib/active_record/associations.rb#327
  def association_instance_get(name); end

  # Set the specified association instance.
  #
  # source://activerecord//lib/active_record/associations.rb#332
  def association_instance_set(name, association); end

  # source://activerecord//lib/active_record/associations.rb#321
  def init_internals; end

  # source://activerecord//lib/active_record/associations.rb#315
  def initialize_dup(*_arg0); end

  class << self
    # source://activerecord//lib/active_record/associations.rb#290
    def eager_load!; end
  end
end

# Keeps track of table aliases for ActiveRecord::Associations::JoinDependency
class ActiveRecord::Associations::AliasTracker
  # table_joins is an array of arel joins which might conflict with the aliases we assign here
  #
  # @return [AliasTracker] a new instance of AliasTracker
  #
  # source://activerecord//lib/active_record/associations/alias_tracker.rb#49
  def initialize(connection, aliases); end

  # source://activerecord//lib/active_record/associations/alias_tracker.rb#54
  def aliased_table_for(arel_table, table_name = T.unsafe(nil)); end

  # Returns the value of attribute aliases.
  #
  # source://activerecord//lib/active_record/associations/alias_tracker.rb#76
  def aliases; end

  private

  # source://activerecord//lib/active_record/associations/alias_tracker.rb#79
  def truncate(name); end

  class << self
    # source://activerecord//lib/active_record/associations/alias_tracker.rb#9
    def create(connection, initial_table, joins, aliases = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/associations/alias_tracker.rb#26
    def initial_count_for(connection, name, table_joins); end
  end
end

# = Active Record Associations
#
# This is the root class of all associations ('+ Foo' signifies an included module Foo):
#
#   Association
#     SingularAssociation
#       HasOneAssociation + ForeignAssociation
#         HasOneThroughAssociation + ThroughAssociation
#       BelongsToAssociation
#         BelongsToPolymorphicAssociation
#     CollectionAssociation
#       HasManyAssociation + ForeignAssociation
#         HasManyThroughAssociation + ThroughAssociation
#
# Associations in Active Record are middlemen between the object that
# holds the association, known as the <tt>owner</tt>, and the associated
# result set, known as the <tt>target</tt>. Association metadata is available in
# <tt>reflection</tt>, which is an instance of <tt>ActiveRecord::Reflection::AssociationReflection</tt>.
#
# For example, given
#
#   class Blog < ActiveRecord::Base
#     has_many :posts
#   end
#
#   blog = Blog.first
#
# The association of <tt>blog.posts</tt> has the object +blog+ as its
# <tt>owner</tt>, the collection of its posts as <tt>target</tt>, and
# the <tt>reflection</tt> object represents a <tt>:has_many</tt> macro.
class ActiveRecord::Associations::Association
  # @return [Association] a new instance of Association
  #
  # source://activerecord//lib/active_record/associations/association.rb#40
  def initialize(owner, reflection); end

  # source://activerecord//lib/active_record/associations/association.rb#203
  def create(attributes = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/association.rb#207
  def create!(attributes = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/association.rb#36
  def disable_joins; end

  # source://activerecord//lib/active_record/associations/association.rb#152
  def extensions; end

  # source://activerecord//lib/active_record/associations/association.rb#193
  def initialize_attributes(record, except_from_scope_attributes = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/association.rb#136
  def inversed_from(record); end

  # source://activerecord//lib/active_record/associations/association.rb#140
  def inversed_from_queries(record); end

  # Returns the class of the target. belongs_to polymorphic overrides this to look at the
  # polymorphic_type field on the owner.
  #
  # source://activerecord//lib/active_record/associations/association.rb#148
  def klass; end

  # Loads the \target if needed and returns it.
  #
  # This method is abstract in the sense that it relies on +find_target+,
  # which is expected to be provided by descendants.
  #
  # If the \target is already \loaded it is just returned. Thus, you can call
  # +load_target+ unconditionally to get the \target.
  #
  # ActiveRecord::RecordNotFound is rescued within the method, and it is
  # not reraised. The proxy is \reset and +nil+ is the return value.
  #
  # source://activerecord//lib/active_record/associations/association.rb#172
  def load_target; end

  # Asserts the \target has been loaded setting the \loaded flag to +true+.
  #
  # source://activerecord//lib/active_record/associations/association.rb#77
  def loaded!; end

  # Has the \target been already \loaded?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#72
  def loaded?; end

  # We can't dump @reflection and @through_reflection since it contains the scope proc
  #
  # source://activerecord//lib/active_record/associations/association.rb#182
  def marshal_dump; end

  # source://activerecord//lib/active_record/associations/association.rb#187
  def marshal_load(data); end

  # source://activerecord//lib/active_record/associations/association.rb#38
  def options(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/association.rb#36
  def owner; end

  # source://activerecord//lib/active_record/associations/association.rb#36
  def reflection; end

  # Reloads the \target and returns +self+ on success.
  # The QueryCache is cleared if +force+ is true.
  #
  # source://activerecord//lib/active_record/associations/association.rb#63
  def reload(force = T.unsafe(nil)); end

  # Remove the inverse association, if possible
  #
  # source://activerecord//lib/active_record/associations/association.rb#130
  def remove_inverse_instance(record); end

  # Resets the \loaded flag to +false+ and sets the \target to +nil+.
  #
  # source://activerecord//lib/active_record/associations/association.rb#51
  def reset; end

  # source://activerecord//lib/active_record/associations/association.rb#57
  def reset_negative_cache; end

  # source://activerecord//lib/active_record/associations/association.rb#110
  def reset_scope; end

  # source://activerecord//lib/active_record/associations/association.rb#98
  def scope; end

  # Set the inverse association, if possible
  #
  # source://activerecord//lib/active_record/associations/association.rb#115
  def set_inverse_instance(record); end

  # source://activerecord//lib/active_record/associations/association.rb#122
  def set_inverse_instance_from_queries(record); end

  # The target is stale if the target no longer points to the record(s) that the
  # relevant foreign_key(s) refers to. If stale, the association accessor method
  # on the owner will reload the target. It's up to subclasses to implement the
  # stale_state method if relevant.
  #
  # Note that if the target has not been loaded, it is not considered stale.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#88
  def stale_target?; end

  # source://activerecord//lib/active_record/associations/association.rb#36
  def target; end

  # Sets the target of this association to <tt>\target</tt>, and the \loaded flag to +true+.
  #
  # source://activerecord//lib/active_record/associations/association.rb#93
  def target=(target); end

  private

  # The scope for this association.
  #
  # Note that the association_scope is merged into the target_scope only when the
  # scope method is called. This is because at that point the call may be surrounded
  # by scope.scoping { ... } or unscoped { ... } etc, which affects the scope which
  # actually gets built.
  #
  # source://activerecord//lib/active_record/associations/association.rb#254
  def association_scope; end

  # source://activerecord//lib/active_record/associations/association.rb#336
  def build_record(attributes); end

  # source://activerecord//lib/active_record/associations/association.rb#351
  def enqueue_destroy_association(options); end

  # Reader and writer methods call this so that consistent errors are presented
  # when the association target class does not exist.
  #
  # source://activerecord//lib/active_record/associations/association.rb#214
  def ensure_klass_exists!; end

  # source://activerecord//lib/active_record/associations/association.rb#218
  def find_target; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#274
  def find_target?; end

  # Returns true if record contains the foreign_key
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#324
  def foreign_key_for?(record); end

  # Returns true if there is a foreign key present on the owner which
  # references the target. This is used to determine whether we can load
  # the target if the owner is currently a new record (and therefore
  # without a key). If the owner is a new record then foreign_key must
  # be present in order to load target.
  #
  # Currently implemented by belongs_to (vanilla and polymorphic) and
  # has_one/has_many :through associations which go through a belongs_to.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#286
  def foreign_key_present?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#359
  def inversable?(record); end

  # source://activerecord//lib/active_record/associations/association.rb#304
  def inverse_association_for(record); end

  # Can be redefined by subclasses, notably polymorphic belongs_to
  # The record parameter is necessary to support polymorphic inverses as we must check for
  # the association in the specific class of the record.
  #
  # source://activerecord//lib/active_record/associations/association.rb#313
  def inverse_reflection_for(record); end

  # Returns true if inverse association on the given record needs to be set.
  # This method is redefined by subclasses.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#319
  def invertible_for?(record); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#364
  def matches_foreign_key?(record); end

  # Raises ActiveRecord::AssociationTypeMismatch unless +record+ is of
  # the kind of the class of the associated objects. Meant to be used as
  # a safety check when you are about to assign an associated record.
  #
  # source://activerecord//lib/active_record/associations/association.rb#293
  def raise_on_type_mismatch!(record); end

  # source://activerecord//lib/active_record/associations/association.rb#270
  def scope_for_create; end

  # Returns true if statement cache should be skipped on the association reader.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#344
  def skip_statement_cache?(scope); end

  # This should be implemented to return the values of the relevant key(s) on the owner,
  # so that when stale_state is different from the value stored on the last find_target,
  # the target is stale.
  #
  # This is only relevant to certain associations, which is why it returns +nil+ by default.
  #
  # source://activerecord//lib/active_record/associations/association.rb#333
  def stale_state; end

  # Can be overridden (i.e. in ThroughAssociation) to merge in other scopes (i.e. the
  # through association's scope)
  #
  # source://activerecord//lib/active_record/associations/association.rb#266
  def target_scope; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/association.rb#242
  def violates_strict_loading?; end
end

class ActiveRecord::Associations::AssociationScope
  # @return [AssociationScope] a new instance of AssociationScope
  #
  # source://activerecord//lib/active_record/associations/association_scope.rb#15
  def initialize(value_transformation); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#21
  def scope(association); end

  private

  # source://activerecord//lib/active_record/associations/association_scope.rb#117
  def add_constraints(scope, owner, chain); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#154
  def apply_scope(scope, table, key, value); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#162
  def eval_scope(reflection, scope, owner); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#105
  def get_chain(reflection, association, tracker); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#54
  def join(table, constraint); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#58
  def last_chain_scope(scope, reflection, owner); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#78
  def next_chain_scope(scope, reflection, next_reflection); end

  # source://activerecord//lib/active_record/associations/association_scope.rb#74
  def transform_value(value); end

  # Returns the value of attribute value_transformation.
  #
  # source://activerecord//lib/active_record/associations/association_scope.rb#52
  def value_transformation; end

  class << self
    # source://activerecord//lib/active_record/associations/association_scope.rb#10
    def create(&block); end

    # source://activerecord//lib/active_record/associations/association_scope.rb#34
    def get_bind_values(owner, chain); end

    # source://activerecord//lib/active_record/associations/association_scope.rb#6
    def scope(association); end
  end
end

# source://activerecord//lib/active_record/associations/association_scope.rb#19
ActiveRecord::Associations::AssociationScope::INSTANCE = T.let(T.unsafe(nil), ActiveRecord::Associations::AssociationScope)

class ActiveRecord::Associations::AssociationScope::ReflectionProxy < ::SimpleDelegator
  # @return [ReflectionProxy] a new instance of ReflectionProxy
  #
  # source://activerecord//lib/active_record/associations/association_scope.rb#97
  def initialize(reflection, aliased_table); end

  # Returns the value of attribute aliased_table.
  #
  # source://activerecord//lib/active_record/associations/association_scope.rb#95
  def aliased_table; end

  # source://activerecord//lib/active_record/associations/association_scope.rb#102
  def all_includes; end
end

# = Active Record Belongs To Association
class ActiveRecord::Associations::BelongsToAssociation < ::ActiveRecord::Associations::SingularAssociation
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#48
  def decrement_counters; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#56
  def decrement_counters_before_last_save; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#35
  def default(&block); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#7
  def handle_dependency; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#52
  def increment_counters; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#30
  def inversed_from(record); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#39
  def reset; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#79
  def saved_change_to_target?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#71
  def target_changed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#75
  def target_previously_changed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#44
  def updated?; end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#113
  def find_target?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#133
  def foreign_key_present?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#137
  def invertible_for?(record); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#129
  def primary_key(klass); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#84
  def replace(record); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#121
  def replace_keys(record, force: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#117
  def require_counter_update?; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#142
  def stale_state; end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#98
  def update_counters(by); end

  # source://activerecord//lib/active_record/associations/belongs_to_association.rb#108
  def update_counters_via_scope(klass, foreign_key, by); end
end

# = Active Record Belongs To Polymorphic Association
class ActiveRecord::Associations::BelongsToPolymorphicAssociation < ::ActiveRecord::Associations::BelongsToAssociation
  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#7
  def klass; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#20
  def saved_change_to_target?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#12
  def target_changed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#16
  def target_previously_changed?; end

  private

  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#35
  def inverse_reflection_for(record); end

  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#39
  def raise_on_type_mismatch!(record); end

  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#25
  def replace_keys(record, force: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/belongs_to_polymorphic_association.rb#43
  def stale_state; end
end

module ActiveRecord::Associations::Builder; end

class ActiveRecord::Associations::Builder::Association
  class << self
    # source://activerecord//lib/active_record/associations/builder/association.rb#25
    def build(model, name, scope, options, &block); end

    # @raise [ArgumentError]
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#40
    def create_reflection(model, name, scope, options, &block); end

    # Returns the value of attribute extensions.
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#17
    def extensions; end

    # Sets the attribute extensions
    #
    # @param value the value to set the attribute extensions to.
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#17
    def extensions=(_arg0); end

    private

    # source://activerecord//lib/active_record/associations/builder/association.rb#144
    def add_after_commit_jobs_callback(model, dependent); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#139
    def add_destroy_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#53
    def build_scope(scope); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#129
    def check_dependent_options(dependent, model); end

    # Defines the setter and getter methods for the association
    # class Post < ActiveRecord::Base
    #   has_many :comments
    # end
    #
    # Post.first.comments and Post.first.comments= methods are defined by this method...
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#94
    def define_accessors(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#76
    def define_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#121
    def define_change_tracking_methods(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#73
    def define_extensions(model, name); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#101
    def define_readers(mixin, name); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#117
    def define_validations(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#109
    def define_writers(mixin, name); end

    # @raise [NotImplementedError]
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#61
    def macro; end

    # @raise [NotImplementedError]
    #
    # source://activerecord//lib/active_record/associations/builder/association.rb#125
    def valid_dependent_options; end

    # source://activerecord//lib/active_record/associations/builder/association.rb#65
    def valid_options(options); end

    # source://activerecord//lib/active_record/associations/builder/association.rb#69
    def validate_options(options); end
  end
end

# source://activerecord//lib/active_record/associations/builder/association.rb#21
ActiveRecord::Associations::Builder::Association::VALID_OPTIONS = T.let(T.unsafe(nil), Array)

class ActiveRecord::Associations::Builder::BelongsTo < ::ActiveRecord::Associations::Builder::SingularAssociation
  class << self
    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#43
    def touch_record(o, changes, foreign_key, name, touch, touch_method); end

    private

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#27
    def add_counter_cache_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#102
    def add_default_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#108
    def add_destroy_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#78
    def add_touch_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#20
    def define_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#130
    def define_change_tracking_methods(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#112
    def define_validations(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#5
    def macro; end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#16
    def valid_dependent_options; end

    # source://activerecord//lib/active_record/associations/builder/belongs_to.rb#9
    def valid_options(options); end
  end
end

class ActiveRecord::Associations::Builder::CollectionAssociation < ::ActiveRecord::Associations::Builder::Association
  class << self
    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#13
    def define_callbacks(model, reflection); end

    private

    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#30
    def define_callback(model, callback_name, name, options); end

    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#22
    def define_extensions(model, name, &block); end

    # Defines the setter and getter methods for the collection_singular_ids.
    #
    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#58
    def define_readers(mixin, name); end

    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#68
    def define_writers(mixin, name); end

    # source://activerecord//lib/active_record/associations/builder/collection_association.rb#9
    def valid_options(options); end
  end
end

# source://activerecord//lib/active_record/associations/builder/collection_association.rb#7
ActiveRecord::Associations::Builder::CollectionAssociation::CALLBACKS = T.let(T.unsafe(nil), Array)

class ActiveRecord::Associations::Builder::HasAndBelongsToMany
  # @return [HasAndBelongsToMany] a new instance of HasAndBelongsToMany
  #
  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#7
  def initialize(association_name, lhs_model, options); end

  # Returns the value of attribute association_name.
  #
  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#5
  def association_name; end

  # Returns the value of attribute lhs_model.
  #
  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#5
  def lhs_model; end

  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#63
  def middle_reflection(join_model); end

  # Returns the value of attribute options.
  #
  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#5
  def options; end

  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#13
  def through_model; end

  private

  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#96
  def belongs_to_options(options); end

  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#75
  def middle_options(join_model); end

  # source://activerecord//lib/active_record/associations/builder/has_and_belongs_to_many.rb#84
  def table_name; end
end

class ActiveRecord::Associations::Builder::HasMany < ::ActiveRecord::Associations::Builder::CollectionAssociation
  class << self
    private

    # source://activerecord//lib/active_record/associations/builder/has_many.rb#5
    def macro; end

    # source://activerecord//lib/active_record/associations/builder/has_many.rb#18
    def valid_dependent_options; end

    # source://activerecord//lib/active_record/associations/builder/has_many.rb#9
    def valid_options(options); end
  end
end

class ActiveRecord::Associations::Builder::HasOne < ::ActiveRecord::Associations::Builder::SingularAssociation
  class << self
    # source://activerecord//lib/active_record/associations/builder/has_one.rb#38
    def touch_record(record, name, touch); end

    private

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#27
    def add_destroy_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#47
    def add_touch_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#22
    def define_callbacks(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#31
    def define_validations(model, reflection); end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#5
    def macro; end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#18
    def valid_dependent_options; end

    # source://activerecord//lib/active_record/associations/builder/has_one.rb#9
    def valid_options(options); end
  end
end

class ActiveRecord::Associations::Builder::SingularAssociation < ::ActiveRecord::Associations::Builder::Association
  class << self
    private

    # source://activerecord//lib/active_record/associations/builder/singular_association.rb#11
    def define_accessors(model, reflection); end

    # Defines the (build|create)_association methods for belongs_to or has_one association
    #
    # source://activerecord//lib/active_record/associations/builder/singular_association.rb#26
    def define_constructors(mixin, name); end

    # source://activerecord//lib/active_record/associations/builder/singular_association.rb#7
    def valid_options(options); end
  end
end

# \Associations are a set of macro-like class methods for tying objects together through
# foreign keys. They express relationships like "Project has one Project Manager"
# or "Project belongs to a Portfolio". Each macro adds a number of methods to the
# class which are specialized according to the collection or association symbol and the
# options hash. It works much the same way as Ruby's own <tt>attr*</tt>
# methods.
#
#   class Project < ActiveRecord::Base
#     belongs_to              :portfolio
#     has_one                 :project_manager
#     has_many                :milestones
#     has_and_belongs_to_many :categories
#   end
#
# The project class now has the following methods (and more) to ease the traversal and
# manipulation of its relationships:
# * <tt>Project#portfolio</tt>, <tt>Project#portfolio=(portfolio)</tt>, <tt>Project#reload_portfolio</tt>
# * <tt>Project#project_manager</tt>, <tt>Project#project_manager=(project_manager)</tt>, <tt>Project#reload_project_manager</tt>
# * <tt>Project#milestones.empty?</tt>, <tt>Project#milestones.size</tt>, <tt>Project#milestones</tt>, <tt>Project#milestones<<(milestone)</tt>,
#   <tt>Project#milestones.delete(milestone)</tt>, <tt>Project#milestones.destroy(milestone)</tt>, <tt>Project#milestones.find(milestone_id)</tt>,
#   <tt>Project#milestones.build</tt>, <tt>Project#milestones.create</tt>
# * <tt>Project#categories.empty?</tt>, <tt>Project#categories.size</tt>, <tt>Project#categories</tt>, <tt>Project#categories<<(category1)</tt>,
#   <tt>Project#categories.delete(category1)</tt>, <tt>Project#categories.destroy(category1)</tt>
#
# === A word of warning
#
# Don't create associations that have the same name as {instance methods}[rdoc-ref:ActiveRecord::Core] of
# <tt>ActiveRecord::Base</tt>. Since the association adds a method with that name to
# its model, using an association with the same name as one provided by <tt>ActiveRecord::Base</tt> will override the method inherited through <tt>ActiveRecord::Base</tt> and will break things.
# For instance, +attributes+ and +connection+ would be bad choices for association names, because those names already exist in the list of <tt>ActiveRecord::Base</tt> instance methods.
#
# == Auto-generated methods
# See also Instance Public methods below for more details.
#
# === Singular associations (one-to-one)
#                                     |            |  belongs_to  |
#   generated methods                 | belongs_to | :polymorphic | has_one
#   ----------------------------------+------------+--------------+---------
#   other                             |     X      |      X       |    X
#   other=(other)                     |     X      |      X       |    X
#   build_other(attributes={})        |     X      |              |    X
#   create_other(attributes={})       |     X      |              |    X
#   create_other!(attributes={})      |     X      |              |    X
#   reload_other                      |     X      |      X       |    X
#   other_changed?                    |     X      |      X       |
#   other_previously_changed?         |     X      |      X       |
#
# === Collection associations (one-to-many / many-to-many)
#                                     |       |          | has_many
#   generated methods                 | habtm | has_many | :through
#   ----------------------------------+-------+----------+----------
#   others                            |   X   |    X     |    X
#   others=(other,other,...)          |   X   |    X     |    X
#   other_ids                         |   X   |    X     |    X
#   other_ids=(id,id,...)             |   X   |    X     |    X
#   others<<                          |   X   |    X     |    X
#   others.push                       |   X   |    X     |    X
#   others.concat                     |   X   |    X     |    X
#   others.build(attributes={})       |   X   |    X     |    X
#   others.create(attributes={})      |   X   |    X     |    X
#   others.create!(attributes={})     |   X   |    X     |    X
#   others.size                       |   X   |    X     |    X
#   others.length                     |   X   |    X     |    X
#   others.count                      |   X   |    X     |    X
#   others.sum(*args)                 |   X   |    X     |    X
#   others.empty?                     |   X   |    X     |    X
#   others.clear                      |   X   |    X     |    X
#   others.delete(other,other,...)    |   X   |    X     |    X
#   others.delete_all                 |   X   |    X     |    X
#   others.destroy(other,other,...)   |   X   |    X     |    X
#   others.destroy_all                |   X   |    X     |    X
#   others.find(*args)                |   X   |    X     |    X
#   others.exists?                    |   X   |    X     |    X
#   others.distinct                   |   X   |    X     |    X
#   others.reset                      |   X   |    X     |    X
#   others.reload                     |   X   |    X     |    X
#
# === Overriding generated methods
#
# Association methods are generated in a module included into the model
# class, making overrides easy. The original generated method can thus be
# called with +super+:
#
#   class Car < ActiveRecord::Base
#     belongs_to :owner
#     belongs_to :old_owner
#
#     def owner=(new_owner)
#       self.old_owner = self.owner
#       super
#     end
#   end
#
# The association methods module is included immediately after the
# generated attributes methods module, meaning an association will
# override the methods for an attribute with the same name.
#
# == Cardinality and associations
#
# Active Record associations can be used to describe one-to-one, one-to-many, and many-to-many
# relationships between models. Each model uses an association to describe its role in
# the relation. The #belongs_to association is always used in the model that has
# the foreign key.
#
# === One-to-one
#
# Use #has_one in the base, and #belongs_to in the associated model.
#
#   class Employee < ActiveRecord::Base
#     has_one :office
#   end
#   class Office < ActiveRecord::Base
#     belongs_to :employee    # foreign key - employee_id
#   end
#
# === One-to-many
#
# Use #has_many in the base, and #belongs_to in the associated model.
#
#   class Manager < ActiveRecord::Base
#     has_many :employees
#   end
#   class Employee < ActiveRecord::Base
#     belongs_to :manager     # foreign key - manager_id
#   end
#
# === Many-to-many
#
# There are two ways to build a many-to-many relationship.
#
# The first way uses a #has_many association with the <tt>:through</tt> option and a join model, so
# there are two stages of associations.
#
#   class Assignment < ActiveRecord::Base
#     belongs_to :programmer  # foreign key - programmer_id
#     belongs_to :project     # foreign key - project_id
#   end
#   class Programmer < ActiveRecord::Base
#     has_many :assignments
#     has_many :projects, through: :assignments
#   end
#   class Project < ActiveRecord::Base
#     has_many :assignments
#     has_many :programmers, through: :assignments
#   end
#
# For the second way, use #has_and_belongs_to_many in both models. This requires a join table
# that has no corresponding model or primary key.
#
#   class Programmer < ActiveRecord::Base
#     has_and_belongs_to_many :projects       # foreign keys in the join table
#   end
#   class Project < ActiveRecord::Base
#     has_and_belongs_to_many :programmers    # foreign keys in the join table
#   end
#
# Choosing which way to build a many-to-many relationship is not always simple.
# If you need to work with the relationship model as its own entity,
# use #has_many <tt>:through</tt>. Use #has_and_belongs_to_many when working with legacy schemas or when
# you never work directly with the relationship itself.
#
# == Is it a #belongs_to or #has_one association?
#
# Both express a 1-1 relationship. The difference is mostly where to place the foreign
# key, which goes on the table for the class declaring the #belongs_to relationship.
#
#   class User < ActiveRecord::Base
#     # I reference an account.
#     belongs_to :account
#   end
#
#   class Account < ActiveRecord::Base
#     # One user references me.
#     has_one :user
#   end
#
# The tables for these classes could look something like:
#
#   CREATE TABLE users (
#     id bigint NOT NULL auto_increment,
#     account_id bigint default NULL,
#     name varchar default NULL,
#     PRIMARY KEY  (id)
#   )
#
#   CREATE TABLE accounts (
#     id bigint NOT NULL auto_increment,
#     name varchar default NULL,
#     PRIMARY KEY  (id)
#   )
#
# == Unsaved objects and associations
#
# You can manipulate objects and associations before they are saved to the database, but
# there is some special behavior you should be aware of, mostly involving the saving of
# associated objects.
#
# You can set the <tt>:autosave</tt> option on a #has_one, #belongs_to,
# #has_many, or #has_and_belongs_to_many association. Setting it
# to +true+ will _always_ save the members, whereas setting it to +false+ will
# _never_ save the members. More details about <tt>:autosave</tt> option is available at
# AutosaveAssociation.
#
# === One-to-one associations
#
# * Assigning an object to a #has_one association automatically saves that object and
#   the object being replaced (if there is one), in order to update their foreign
#   keys - except if the parent object is unsaved (<tt>new_record? == true</tt>).
# * If either of these saves fail (due to one of the objects being invalid), an
#   ActiveRecord::RecordNotSaved exception is raised and the assignment is
#   cancelled.
# * If you wish to assign an object to a #has_one association without saving it,
#   use the <tt>#build_association</tt> method (documented below). The object being
#   replaced will still be saved to update its foreign key.
# * Assigning an object to a #belongs_to association does not save the object, since
#   the foreign key field belongs on the parent. It does not save the parent either.
#
# === Collections
#
# * Adding an object to a collection (#has_many or #has_and_belongs_to_many) automatically
#   saves that object, except if the parent object (the owner of the collection) is not yet
#   stored in the database.
# * If saving any of the objects being added to a collection (via <tt>push</tt> or similar)
#   fails, then <tt>push</tt> returns +false+.
# * If saving fails while replacing the collection (via <tt>association=</tt>), an
#   ActiveRecord::RecordNotSaved exception is raised and the assignment is
#   cancelled.
# * You can add an object to a collection without automatically saving it by using the
#   <tt>collection.build</tt> method (documented below).
# * All unsaved (<tt>new_record? == true</tt>) members of the collection are automatically
#   saved when the parent is saved.
#
# == Customizing the query
#
# \Associations are built from <tt>Relation</tt> objects, and you can use the Relation syntax
# to customize them. For example, to add a condition:
#
#   class Blog < ActiveRecord::Base
#     has_many :published_posts, -> { where(published: true) }, class_name: 'Post'
#   end
#
# Inside the <tt>-> { ... }</tt> block you can use all of the usual Relation methods.
#
# === Accessing the owner object
#
# Sometimes it is useful to have access to the owner object when building the query. The owner
# is passed as a parameter to the block. For example, the following association would find all
# events that occur on the user's birthday:
#
#   class User < ActiveRecord::Base
#     has_many :birthday_events, ->(user) { where(starts_on: user.birthday) }, class_name: 'Event'
#   end
#
# Note: Joining, eager loading, and preloading of these associations is not possible.
# These operations happen before instance creation and the scope will be called with a +nil+ argument.
#
# == Association callbacks
#
# Similar to the normal callbacks that hook into the life cycle of an Active Record object,
# you can also define callbacks that get triggered when you add an object to or remove an
# object from an association collection.
#
#   class Firm < ActiveRecord::Base
#     has_many :clients,
#              dependent: :destroy,
#              after_add: :congratulate_client,
#              after_remove: :log_after_remove
#
#     def congratulate_client(record)
#       # ...
#     end
#
#     def log_after_remove(record)
#       # ...
#     end
#
# It's possible to stack callbacks by passing them as an array. Example:
#
#   class Firm < ActiveRecord::Base
#     has_many :clients,
#              dependent: :destroy,
#              after_add: [:congratulate_client, -> (firm, record) { firm.log << "after_adding#{record.id}" }],
#              after_remove: :log_after_remove
#   end
#
# Possible callbacks are: +before_add+, +after_add+, +before_remove+, and +after_remove+.
#
# If any of the +before_add+ callbacks throw an exception, the object will not be
# added to the collection.
#
# Similarly, if any of the +before_remove+ callbacks throw an exception, the object
# will not be removed from the collection.
#
# Note: To trigger remove callbacks, you must use +destroy+ / +destroy_all+ methods. For example:
#
# * <tt>firm.clients.destroy(client)</tt>
# * <tt>firm.clients.destroy(*clients)</tt>
# * <tt>firm.clients.destroy_all</tt>
#
# +delete+ / +delete_all+ methods like the following do *not* trigger remove callbacks:
#
# * <tt>firm.clients.delete(client)</tt>
# * <tt>firm.clients.delete(*clients)</tt>
# * <tt>firm.clients.delete_all</tt>
#
# == Association extensions
#
# The proxy objects that control the access to associations can be extended through anonymous
# modules. This is especially beneficial for adding new finders, creators, and other
# factory-type methods that are only used as part of this association.
#
#   class Account < ActiveRecord::Base
#     has_many :people do
#       def find_or_create_by_name(name)
#         first_name, last_name = name.split(" ", 2)
#         find_or_create_by(first_name: first_name, last_name: last_name)
#       end
#     end
#   end
#
#   person = Account.first.people.find_or_create_by_name("David Heinemeier Hansson")
#   person.first_name # => "David"
#   person.last_name  # => "Heinemeier Hansson"
#
# If you need to share the same extensions between many associations, you can use a named
# extension module.
#
#   module FindOrCreateByNameExtension
#     def find_or_create_by_name(name)
#       first_name, last_name = name.split(" ", 2)
#       find_or_create_by(first_name: first_name, last_name: last_name)
#     end
#   end
#
#   class Account < ActiveRecord::Base
#     has_many :people, -> { extending FindOrCreateByNameExtension }
#   end
#
#   class Company < ActiveRecord::Base
#     has_many :people, -> { extending FindOrCreateByNameExtension }
#   end
#
# Some extensions can only be made to work with knowledge of the association's internals.
# Extensions can access relevant state using the following methods (where +items+ is the
# name of the association):
#
# * <tt>record.association(:items).owner</tt> - Returns the object the association is part of.
# * <tt>record.association(:items).reflection</tt> - Returns the reflection object that describes the association.
# * <tt>record.association(:items).target</tt> - Returns the associated object for #belongs_to and #has_one, or
#   the collection of associated objects for #has_many and #has_and_belongs_to_many.
#
# However, inside the actual extension code, you will not have access to the <tt>record</tt> as
# above. In this case, you can access <tt>proxy_association</tt>. For example,
# <tt>record.association(:items)</tt> and <tt>record.items.proxy_association</tt> will return
# the same object, allowing you to make calls like <tt>proxy_association.owner</tt> inside
# association extensions.
#
# == Association Join Models
#
# Has Many associations can be configured with the <tt>:through</tt> option to use an
# explicit join model to retrieve the data. This operates similarly to a
# #has_and_belongs_to_many association. The advantage is that you're able to add validations,
# callbacks, and extra attributes on the join model. Consider the following schema:
#
#   class Author < ActiveRecord::Base
#     has_many :authorships
#     has_many :books, through: :authorships
#   end
#
#   class Authorship < ActiveRecord::Base
#     belongs_to :author
#     belongs_to :book
#   end
#
#   @author = Author.first
#   @author.authorships.collect { |a| a.book } # selects all books that the author's authorships belong to
#   @author.books                              # selects all books by using the Authorship join model
#
# You can also go through a #has_many association on the join model:
#
#   class Firm < ActiveRecord::Base
#     has_many   :clients
#     has_many   :invoices, through: :clients
#   end
#
#   class Client < ActiveRecord::Base
#     belongs_to :firm
#     has_many   :invoices
#   end
#
#   class Invoice < ActiveRecord::Base
#     belongs_to :client
#   end
#
#   @firm = Firm.first
#   @firm.clients.flat_map { |c| c.invoices } # select all invoices for all clients of the firm
#   @firm.invoices                            # selects all invoices by going through the Client join model
#
# Similarly you can go through a #has_one association on the join model:
#
#   class Group < ActiveRecord::Base
#     has_many   :users
#     has_many   :avatars, through: :users
#   end
#
#   class User < ActiveRecord::Base
#     belongs_to :group
#     has_one    :avatar
#   end
#
#   class Avatar < ActiveRecord::Base
#     belongs_to :user
#   end
#
#   @group = Group.first
#   @group.users.collect { |u| u.avatar }.compact # select all avatars for all users in the group
#   @group.avatars                                # selects all avatars by going through the User join model.
#
# An important caveat with going through #has_one or #has_many associations on the
# join model is that these associations are *read-only*. For example, the following
# would not work following the previous example:
#
#   @group.avatars << Avatar.new   # this would work if User belonged_to Avatar rather than the other way around
#   @group.avatars.delete(@group.avatars.last)  # so would this
#
# == Setting Inverses
#
# If you are using a #belongs_to on the join model, it is a good idea to set the
# <tt>:inverse_of</tt> option on the #belongs_to, which will mean that the following example
# works correctly (where <tt>tags</tt> is a #has_many <tt>:through</tt> association):
#
#   @post = Post.first
#   @tag = @post.tags.build name: "ruby"
#   @tag.save
#
# The last line ought to save the through record (a <tt>Tagging</tt>). This will only work if the
# <tt>:inverse_of</tt> is set:
#
#   class Tagging < ActiveRecord::Base
#     belongs_to :post
#     belongs_to :tag, inverse_of: :taggings
#   end
#
# If you do not set the <tt>:inverse_of</tt> record, the association will
# do its best to match itself up with the correct inverse. Automatic
# inverse detection only works on #has_many, #has_one, and
# #belongs_to associations.
#
# <tt>:foreign_key</tt> and <tt>:through</tt> options on the associations
# will also prevent the association's inverse from being found automatically,
# as will a custom scopes in some cases. See further details in the
# {Active Record Associations guide}[https://guides.rubyonrails.org/association_basics.html#bi-directional-associations].
#
# The automatic guessing of the inverse association uses a heuristic based
# on the name of the class, so it may not work for all associations,
# especially the ones with non-standard names.
#
# You can turn off the automatic detection of inverse associations by setting
# the <tt>:inverse_of</tt> option to <tt>false</tt> like so:
#
#   class Tagging < ActiveRecord::Base
#     belongs_to :tag, inverse_of: false
#   end
#
# == Nested \Associations
#
# You can actually specify *any* association with the <tt>:through</tt> option, including an
# association which has a <tt>:through</tt> option itself. For example:
#
#   class Author < ActiveRecord::Base
#     has_many :posts
#     has_many :comments, through: :posts
#     has_many :commenters, through: :comments
#   end
#
#   class Post < ActiveRecord::Base
#     has_many :comments
#   end
#
#   class Comment < ActiveRecord::Base
#     belongs_to :commenter
#   end
#
#   @author = Author.first
#   @author.commenters # => People who commented on posts written by the author
#
# An equivalent way of setting up this association this would be:
#
#   class Author < ActiveRecord::Base
#     has_many :posts
#     has_many :commenters, through: :posts
#   end
#
#   class Post < ActiveRecord::Base
#     has_many :comments
#     has_many :commenters, through: :comments
#   end
#
#   class Comment < ActiveRecord::Base
#     belongs_to :commenter
#   end
#
# When using a nested association, you will not be able to modify the association because there
# is not enough information to know what modification to make. For example, if you tried to
# add a <tt>Commenter</tt> in the example above, there would be no way to tell how to set up the
# intermediate <tt>Post</tt> and <tt>Comment</tt> objects.
#
# == Polymorphic \Associations
#
# Polymorphic associations on models are not restricted on what types of models they
# can be associated with. Rather, they specify an interface that a #has_many association
# must adhere to.
#
#   class Asset < ActiveRecord::Base
#     belongs_to :attachable, polymorphic: true
#   end
#
#   class Post < ActiveRecord::Base
#     has_many :assets, as: :attachable         # The :as option specifies the polymorphic interface to use.
#   end
#
#   @asset.attachable = @post
#
# This works by using a type column in addition to a foreign key to specify the associated
# record. In the Asset example, you'd need an +attachable_id+ integer column and an
# +attachable_type+ string column.
#
# Using polymorphic associations in combination with single table inheritance (STI) is
# a little tricky. In order for the associations to work as expected, ensure that you
# store the base model for the STI models in the type column of the polymorphic
# association. To continue with the asset example above, suppose there are guest posts
# and member posts that use the posts table for STI. In this case, there must be a +type+
# column in the posts table.
#
# Note: The <tt>attachable_type=</tt> method is being called when assigning an +attachable+.
# The +class_name+ of the +attachable+ is passed as a String.
#
#   class Asset < ActiveRecord::Base
#     belongs_to :attachable, polymorphic: true
#
#     def attachable_type=(class_name)
#        super(class_name.constantize.base_class.to_s)
#     end
#   end
#
#   class Post < ActiveRecord::Base
#     # because we store "Post" in attachable_type now dependent: :destroy will work
#     has_many :assets, as: :attachable, dependent: :destroy
#   end
#
#   class GuestPost < Post
#   end
#
#   class MemberPost < Post
#   end
#
# == Caching
#
# All of the methods are built on a simple caching principle that will keep the result
# of the last query around unless specifically instructed not to. The cache is even
# shared across methods to make it even cheaper to use the macro-added methods without
# worrying too much about performance at the first go.
#
#   project.milestones             # fetches milestones from the database
#   project.milestones.size        # uses the milestone cache
#   project.milestones.empty?      # uses the milestone cache
#   project.milestones.reload.size # fetches milestones from the database
#   project.milestones             # uses the milestone cache
#
# == Eager loading of associations
#
# Eager loading is a way to find objects of a certain class and a number of named associations.
# It is one of the easiest ways to prevent the dreaded N+1 problem in which fetching 100
# posts that each need to display their author triggers 101 database queries. Through the
# use of eager loading, the number of queries will be reduced from 101 to 2.
#
#   class Post < ActiveRecord::Base
#     belongs_to :author
#     has_many   :comments
#   end
#
# Consider the following loop using the class above:
#
#   Post.all.each do |post|
#     puts "Post:            " + post.title
#     puts "Written by:      " + post.author.name
#     puts "Last comment on: " + post.comments.first.created_on
#   end
#
# To iterate over these one hundred posts, we'll generate 201 database queries. Let's
# first just optimize it for retrieving the author:
#
#   Post.includes(:author).each do |post|
#
# This references the name of the #belongs_to association that also used the <tt>:author</tt>
# symbol. After loading the posts, +find+ will collect the +author_id+ from each one and load
# all of the referenced authors with one query. Doing so will cut down the number of queries
# from 201 to 102.
#
# We can improve upon the situation further by referencing both associations in the finder with:
#
#   Post.includes(:author, :comments).each do |post|
#
# This will load all comments with a single query. This reduces the total number of queries
# to 3. In general, the number of queries will be 1 plus the number of associations
# named (except if some of the associations are polymorphic #belongs_to - see below).
#
# To include a deep hierarchy of associations, use a hash:
#
#   Post.includes(:author, { comments: { author: :gravatar } }).each do |post|
#
# The above code will load all the comments and all of their associated
# authors and gravatars. You can mix and match any combination of symbols,
# arrays, and hashes to retrieve the associations you want to load.
#
# All of this power shouldn't fool you into thinking that you can pull out huge amounts
# of data with no performance penalty just because you've reduced the number of queries.
# The database still needs to send all the data to Active Record and it still needs to
# be processed. So it's no catch-all for performance problems, but it's a great way to
# cut down on the number of queries in a situation as the one described above.
#
# Since only one table is loaded at a time, conditions or orders cannot reference tables
# other than the main one. If this is the case, Active Record falls back to the previously
# used <tt>LEFT OUTER JOIN</tt> based strategy. For example:
#
#   Post.includes([:author, :comments]).where(['comments.approved = ?', true])
#
# This will result in a single SQL query with joins along the lines of:
# <tt>LEFT OUTER JOIN comments ON comments.post_id = posts.id</tt> and
# <tt>LEFT OUTER JOIN authors ON authors.id = posts.author_id</tt>. Note that using conditions
# like this can have unintended consequences.
# In the above example, posts with no approved comments are not returned at all because
# the conditions apply to the SQL statement as a whole and not just to the association.
#
# You must disambiguate column references for this fallback to happen, for example
# <tt>order: "author.name DESC"</tt> will work but <tt>order: "name DESC"</tt> will not.
#
# If you want to load all posts (including posts with no approved comments), then write
# your own <tt>LEFT OUTER JOIN</tt> query using <tt>ON</tt>:
#
#   Post.joins("LEFT OUTER JOIN comments ON comments.post_id = posts.id AND comments.approved = '1'")
#
# In this case, it is usually more natural to include an association which has conditions defined on it:
#
#   class Post < ActiveRecord::Base
#     has_many :approved_comments, -> { where(approved: true) }, class_name: 'Comment'
#   end
#
#   Post.includes(:approved_comments)
#
# This will load posts and eager load the +approved_comments+ association, which contains
# only those comments that have been approved.
#
# If you eager load an association with a specified <tt>:limit</tt> option, it will be ignored,
# returning all the associated objects:
#
#   class Picture < ActiveRecord::Base
#     has_many :most_recent_comments, -> { order('id DESC').limit(10) }, class_name: 'Comment'
#   end
#
#   Picture.includes(:most_recent_comments).first.most_recent_comments # => returns all associated comments.
#
# Eager loading is supported with polymorphic associations.
#
#   class Address < ActiveRecord::Base
#     belongs_to :addressable, polymorphic: true
#   end
#
# A call that tries to eager load the addressable model
#
#   Address.includes(:addressable)
#
# This will execute one query to load the addresses and load the addressables with one
# query per addressable type.
# For example, if all the addressables are either of class Person or Company, then a total
# of 3 queries will be executed. The list of addressable types to load is determined on
# the back of the addresses loaded. This is not supported if Active Record has to fallback
# to the previous implementation of eager loading and will raise ActiveRecord::EagerLoadPolymorphicError.
# The reason is that the parent model's type is a column value so its corresponding table
# name cannot be put in the +FROM+/+JOIN+ clauses of that query.
#
# == Table Aliasing
#
# Active Record uses table aliasing in the case that a table is referenced multiple times
# in a join. If a table is referenced only once, the standard table name is used. The
# second time, the table is aliased as <tt>#{reflection_name}_#{parent_table_name}</tt>.
# Indexes are appended for any more successive uses of the table name.
#
#   Post.joins(:comments)
#   # => SELECT ... FROM posts INNER JOIN comments ON ...
#   Post.joins(:special_comments) # STI
#   # => SELECT ... FROM posts INNER JOIN comments ON ... AND comments.type = 'SpecialComment'
#   Post.joins(:comments, :special_comments) # special_comments is the reflection name, posts is the parent table name
#   # => SELECT ... FROM posts INNER JOIN comments ON ... INNER JOIN comments special_comments_posts
#
# Acts as tree example:
#
#   TreeMixin.joins(:children)
#   # => SELECT ... FROM mixins INNER JOIN mixins childrens_mixins ...
#   TreeMixin.joins(children: :parent)
#   # => SELECT ... FROM mixins INNER JOIN mixins childrens_mixins ...
#                               INNER JOIN parents_mixins ...
#   TreeMixin.joins(children: {parent: :children})
#   # => SELECT ... FROM mixins INNER JOIN mixins childrens_mixins ...
#                               INNER JOIN parents_mixins ...
#                               INNER JOIN mixins childrens_mixins_2
#
# Has and Belongs to Many join tables use the same idea, but add a <tt>_join</tt> suffix:
#
#   Post.joins(:categories)
#   # => SELECT ... FROM posts INNER JOIN categories_posts ... INNER JOIN categories ...
#   Post.joins(categories: :posts)
#   # => SELECT ... FROM posts INNER JOIN categories_posts ... INNER JOIN categories ...
#                              INNER JOIN categories_posts posts_categories_join INNER JOIN posts posts_categories
#   Post.joins(categories: {posts: :categories})
#   # => SELECT ... FROM posts INNER JOIN categories_posts ... INNER JOIN categories ...
#                              INNER JOIN categories_posts posts_categories_join INNER JOIN posts posts_categories
#                              INNER JOIN categories_posts categories_posts_join INNER JOIN categories categories_posts_2
#
# If you wish to specify your own custom joins using ActiveRecord::QueryMethods#joins method, those table
# names will take precedence over the eager associations:
#
#   Post.joins(:comments).joins("inner join comments ...")
#   # => SELECT ... FROM posts INNER JOIN comments_posts ON ... INNER JOIN comments ...
#   Post.joins(:comments, :special_comments).joins("inner join comments ...")
#   # => SELECT ... FROM posts INNER JOIN comments comments_posts ON ...
#                              INNER JOIN comments special_comments_posts ...
#                              INNER JOIN comments ...
#
# Table aliases are automatically truncated according to the maximum length of table identifiers
# according to the specific database.
#
# == Modules
#
# By default, associations will look for objects within the current module scope. Consider:
#
#   module MyApplication
#     module Business
#       class Firm < ActiveRecord::Base
#         has_many :clients
#       end
#
#       class Client < ActiveRecord::Base; end
#     end
#   end
#
# When <tt>Firm#clients</tt> is called, it will in turn call
# <tt>MyApplication::Business::Client.find_all_by_firm_id(firm.id)</tt>.
# If you want to associate with a class in another module scope, this can be done by
# specifying the complete class name.
#
#   module MyApplication
#     module Business
#       class Firm < ActiveRecord::Base; end
#     end
#
#     module Billing
#       class Account < ActiveRecord::Base
#         belongs_to :firm, class_name: "MyApplication::Business::Firm"
#       end
#     end
#   end
#
# == Bi-directional associations
#
# When you specify an association, there is usually an association on the associated model
# that specifies the same relationship in reverse. For example, with the following models:
#
#    class Dungeon < ActiveRecord::Base
#      has_many :traps
#      has_one :evil_wizard
#    end
#
#    class Trap < ActiveRecord::Base
#      belongs_to :dungeon
#    end
#
#    class EvilWizard < ActiveRecord::Base
#      belongs_to :dungeon
#    end
#
# The +traps+ association on +Dungeon+ and the +dungeon+ association on +Trap+ are
# the inverse of each other, and the inverse of the +dungeon+ association on +EvilWizard+
# is the +evil_wizard+ association on +Dungeon+ (and vice-versa). By default,
# Active Record can guess the inverse of the association based on the name
# of the class. The result is the following:
#
#    d = Dungeon.first
#    t = d.traps.first
#    d.object_id == t.dungeon.object_id # => true
#
# The +Dungeon+ instances +d+ and <tt>t.dungeon</tt> in the above example refer to
# the same in-memory instance since the association matches the name of the class.
# The result would be the same if we added +:inverse_of+ to our model definitions:
#
#    class Dungeon < ActiveRecord::Base
#      has_many :traps, inverse_of: :dungeon
#      has_one :evil_wizard, inverse_of: :dungeon
#    end
#
#    class Trap < ActiveRecord::Base
#      belongs_to :dungeon, inverse_of: :traps
#    end
#
#    class EvilWizard < ActiveRecord::Base
#      belongs_to :dungeon, inverse_of: :evil_wizard
#    end
#
# For more information, see the documentation for the +:inverse_of+ option.
#
# == Deleting from associations
#
# === Dependent associations
#
# #has_many, #has_one, and #belongs_to associations support the <tt>:dependent</tt> option.
# This allows you to specify that associated records should be deleted when the owner is
# deleted.
#
# For example:
#
#     class Author
#       has_many :posts, dependent: :destroy
#     end
#     Author.find(1).destroy # => Will destroy all of the author's posts, too
#
# The <tt>:dependent</tt> option can have different values which specify how the deletion
# is done. For more information, see the documentation for this option on the different
# specific association types. When no option is given, the behavior is to do nothing
# with the associated records when destroying a record.
#
# Note that <tt>:dependent</tt> is implemented using Rails' callback
# system, which works by processing callbacks in order. Therefore, other
# callbacks declared either before or after the <tt>:dependent</tt> option
# can affect what it does.
#
# Note that <tt>:dependent</tt> option is ignored for #has_one <tt>:through</tt> associations.
#
# === Delete or destroy?
#
# #has_many and #has_and_belongs_to_many associations have the methods <tt>destroy</tt>,
# <tt>delete</tt>, <tt>destroy_all</tt> and <tt>delete_all</tt>.
#
# For #has_and_belongs_to_many, <tt>delete</tt> and <tt>destroy</tt> are the same: they
# cause the records in the join table to be removed.
#
# For #has_many, <tt>destroy</tt> and <tt>destroy_all</tt> will always call the <tt>destroy</tt> method of the
# record(s) being removed so that callbacks are run. However <tt>delete</tt> and <tt>delete_all</tt> will either
# do the deletion according to the strategy specified by the <tt>:dependent</tt> option, or
# if no <tt>:dependent</tt> option is given, then it will follow the default strategy.
# The default strategy is to do nothing (leave the foreign keys with the parent ids set), except for
# #has_many <tt>:through</tt>, where the default strategy is <tt>delete_all</tt> (delete
# the join records, without running their callbacks).
#
# There is also a <tt>clear</tt> method which is the same as <tt>delete_all</tt>, except that
# it returns the association rather than the records which have been deleted.
#
# === What gets deleted?
#
# There is a potential pitfall here: #has_and_belongs_to_many and #has_many <tt>:through</tt>
# associations have records in join tables, as well as the associated records. So when we
# call one of these deletion methods, what exactly should be deleted?
#
# The answer is that it is assumed that deletion on an association is about removing the
# <i>link</i> between the owner and the associated object(s), rather than necessarily the
# associated objects themselves. So with #has_and_belongs_to_many and #has_many
# <tt>:through</tt>, the join records will be deleted, but the associated records won't.
#
# This makes sense if you think about it: if you were to call <tt>post.tags.delete(Tag.find_by(name: 'food'))</tt>
# you would want the 'food' tag to be unlinked from the post, rather than for the tag itself
# to be removed from the database.
#
# However, there are examples where this strategy doesn't make sense. For example, suppose
# a person has many projects, and each project has many tasks. If we deleted one of a person's
# tasks, we would probably not want the project to be deleted. In this scenario, the delete method
# won't actually work: it can only be used if the association on the join model is a
# #belongs_to. In other situations you are expected to perform operations directly on
# either the associated records or the <tt>:through</tt> association.
#
# With a regular #has_many there is no distinction between the "associated records"
# and the "link", so there is only one choice for what gets deleted.
#
# With #has_and_belongs_to_many and #has_many <tt>:through</tt>, if you want to delete the
# associated records themselves, you can always do something along the lines of
# <tt>person.tasks.each(&:destroy)</tt>.
#
# == Type safety with ActiveRecord::AssociationTypeMismatch
#
# If you attempt to assign an object to an association that doesn't match the inferred
# or specified <tt>:class_name</tt>, you'll get an ActiveRecord::AssociationTypeMismatch.
#
# == Options
#
# All of the association macros can be specialized through options. This makes cases
# more complex than the simple and guessable ones possible.
module ActiveRecord::Associations::ClassMethods
  # Specifies a one-to-one association with another class. This method should only be used
  # if this class contains the foreign key. If the other class contains the foreign key,
  # then you should use #has_one instead. See also ActiveRecord::Associations::ClassMethods's overview
  # on when to use #has_one and when to use #belongs_to.
  #
  # Methods will be added for retrieval and query for a single associated object, for which
  # this object holds an id:
  #
  # +association+ is a placeholder for the symbol passed as the +name+ argument, so
  # <tt>belongs_to :author</tt> would add among others <tt>author.nil?</tt>.
  #
  # [association]
  #   Returns the associated object. +nil+ is returned if none is found.
  # [association=(associate)]
  #   Assigns the associate object, extracts the primary key, and sets it as the foreign key.
  #   No modification or deletion of existing records takes place.
  # [build_association(attributes = {})]
  #   Returns a new object of the associated type that has been instantiated
  #   with +attributes+ and linked to this object through a foreign key, but has not yet been saved.
  # [create_association(attributes = {})]
  #   Returns a new object of the associated type that has been instantiated
  #   with +attributes+, linked to this object through a foreign key, and that
  #   has already been saved (if it passed the validation).
  # [create_association!(attributes = {})]
  #   Does the same as <tt>create_association</tt>, but raises ActiveRecord::RecordInvalid
  #   if the record is invalid.
  # [reload_association]
  #   Returns the associated object, forcing a database read.
  # [association_changed?]
  #   Returns true if a new associate object has been assigned and the next save will update the foreign key.
  # [association_previously_changed?]
  #   Returns true if the previous save updated the association to reference a new associate object.
  #
  # === Example
  #
  # A Post class declares <tt>belongs_to :author</tt>, which will add:
  # * <tt>Post#author</tt> (similar to <tt>Author.find(author_id)</tt>)
  # * <tt>Post#author=(author)</tt> (similar to <tt>post.author_id = author.id</tt>)
  # * <tt>Post#build_author</tt> (similar to <tt>post.author = Author.new</tt>)
  # * <tt>Post#create_author</tt> (similar to <tt>post.author = Author.new; post.author.save; post.author</tt>)
  # * <tt>Post#create_author!</tt> (similar to <tt>post.author = Author.new; post.author.save!; post.author</tt>)
  # * <tt>Post#reload_author</tt>
  # * <tt>Post#author_changed?</tt>
  # * <tt>Post#author_previously_changed?</tt>
  # The declaration can also include an +options+ hash to specialize the behavior of the association.
  #
  # === Scopes
  #
  # You can pass a second argument +scope+ as a callable (i.e. proc or
  # lambda) to retrieve a specific record or customize the generated query
  # when you access the associated object.
  #
  # Scope examples:
  #   belongs_to :firm, -> { where(id: 2) }
  #   belongs_to :user, -> { joins(:friends) }
  #   belongs_to :level, ->(game) { where("game_level > ?", game.current_level) }
  #
  # === Options
  #
  # [:class_name]
  #   Specify the class name of the association. Use it only if that name can't be inferred
  #   from the association name. So <tt>belongs_to :author</tt> will by default be linked to the Author class, but
  #   if the real class name is Person, you'll have to specify it with this option.
  # [:foreign_key]
  #   Specify the foreign key used for the association. By default this is guessed to be the name
  #   of the association with an "_id" suffix. So a class that defines a <tt>belongs_to :person</tt>
  #   association will use "person_id" as the default <tt>:foreign_key</tt>. Similarly,
  #   <tt>belongs_to :favorite_person, class_name: "Person"</tt> will use a foreign key
  #   of "favorite_person_id".
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option.
  # [:foreign_type]
  #   Specify the column used to store the associated object's type, if this is a polymorphic
  #   association. By default this is guessed to be the name of the association with a "_type"
  #   suffix. So a class that defines a <tt>belongs_to :taggable, polymorphic: true</tt>
  #   association will use "taggable_type" as the default <tt>:foreign_type</tt>.
  # [:primary_key]
  #   Specify the method that returns the primary key of associated object used for the association.
  #   By default this is +id+.
  # [:dependent]
  #   If set to <tt>:destroy</tt>, the associated object is destroyed when this object is. If set to
  #   <tt>:delete</tt>, the associated object is deleted *without* calling its destroy method. If set to
  #   <tt>:destroy_async</tt>, the associated object is scheduled to be destroyed in a background job.
  #   This option should not be specified when #belongs_to is used in conjunction with
  #   a #has_many relationship on another class because of the potential to leave
  #   orphaned records behind.
  # [:counter_cache]
  #   Caches the number of belonging objects on the associate class through the use of CounterCache::ClassMethods#increment_counter
  #   and CounterCache::ClassMethods#decrement_counter. The counter cache is incremented when an object of this
  #   class is created and decremented when it's destroyed. This requires that a column
  #   named <tt>#{table_name}_count</tt> (such as +comments_count+ for a belonging Comment class)
  #   is used on the associate class (such as a Post class) - that is the migration for
  #   <tt>#{table_name}_count</tt> is created on the associate class (such that <tt>Post.comments_count</tt> will
  #   return the count cached, see note below). You can also specify a custom counter
  #   cache column by providing a column name instead of a +true+/+false+ value to this
  #   option (e.g., <tt>counter_cache: :my_custom_counter</tt>.)
  #   Note: Specifying a counter cache will add it to that model's list of readonly attributes
  #   using +attr_readonly+.
  # [:polymorphic]
  #   Specify this association is a polymorphic association by passing +true+.
  #   Note: If you've enabled the counter cache, then you may want to add the counter cache attribute
  #   to the +attr_readonly+ list in the associated classes (e.g. <tt>class Post; attr_readonly :comments_count; end</tt>).
  # [:validate]
  #   When set to +true+, validates new objects added to association when saving the parent object. +false+ by default.
  #   If you want to ensure associated objects are revalidated on every update, use +validates_associated+.
  # [:autosave]
  #   If true, always save the associated object or destroy it if marked for destruction, when
  #   saving the parent object.
  #   If false, never save or destroy the associated object.
  #   By default, only save the associated object if it's a new record.
  #
  #   Note that NestedAttributes::ClassMethods#accepts_nested_attributes_for
  #   sets <tt>:autosave</tt> to <tt>true</tt>.
  # [:touch]
  #   If true, the associated object will be touched (the updated_at/on attributes set to current time)
  #   when this record is either saved or destroyed. If you specify a symbol, that attribute
  #   will be updated with the current time in addition to the updated_at/on attribute.
  #   Please note that with touching no validation is performed and only the +after_touch+,
  #   +after_commit+ and +after_rollback+ callbacks are executed.
  # [:inverse_of]
  #   Specifies the name of the #has_one or #has_many association on the associated
  #   object that is the inverse of this #belongs_to association.
  #   See ActiveRecord::Associations::ClassMethods's overview on Bi-directional associations for more detail.
  # [:optional]
  #   When set to +true+, the association will not have its presence validated.
  # [:required]
  #   When set to +true+, the association will also have its presence validated.
  #   This will validate the association itself, not the id. You can use
  #   +:inverse_of+ to avoid an extra query during validation.
  #   NOTE: <tt>required</tt> is set to <tt>true</tt> by default and is deprecated. If
  #   you don't want to have association presence validated, use <tt>optional: true</tt>.
  # [:default]
  #   Provide a callable (i.e. proc or lambda) to specify that the association should
  #   be initialized with a particular record before validation.
  # [:strict_loading]
  #   Enforces strict loading every time the associated record is loaded through this association.
  # [:ensuring_owner_was]
  #   Specifies an instance method to be called on the owner. The method must return true in order for the
  #   associated records to be deleted in a background job.
  #
  # Option examples:
  #   belongs_to :firm, foreign_key: "client_of"
  #   belongs_to :person, primary_key: "name", foreign_key: "person_name"
  #   belongs_to :author, class_name: "Person", foreign_key: "author_id"
  #   belongs_to :valid_coupon, ->(o) { where "discounts > ?", o.payments_count },
  #                             class_name: "Coupon", foreign_key: "coupon_id"
  #   belongs_to :attachable, polymorphic: true
  #   belongs_to :project, -> { readonly }
  #   belongs_to :post, counter_cache: true
  #   belongs_to :comment, touch: true
  #   belongs_to :company, touch: :employees_last_updated_at
  #   belongs_to :user, optional: true
  #   belongs_to :account, default: -> { company.account }
  #   belongs_to :account, strict_loading: true
  #
  # source://activerecord//lib/active_record/associations.rb#1790
  def belongs_to(name, scope = T.unsafe(nil), **options); end

  # Specifies a many-to-many relationship with another class. This associates two classes via an
  # intermediate join table. Unless the join table is explicitly specified as an option, it is
  # guessed using the lexical order of the class names. So a join between Developer and Project
  # will give the default join table name of "developers_projects" because "D" precedes "P" alphabetically.
  # Note that this precedence is calculated using the <tt><</tt> operator for String. This
  # means that if the strings are of different lengths, and the strings are equal when compared
  # up to the shortest length, then the longer string is considered of higher
  # lexical precedence than the shorter one. For example, one would expect the tables "paper_boxes" and "papers"
  # to generate a join table name of "papers_paper_boxes" because of the length of the name "paper_boxes",
  # but it in fact generates a join table name of "paper_boxes_papers". Be aware of this caveat, and use the
  # custom <tt>:join_table</tt> option if you need to.
  # If your tables share a common prefix, it will only appear once at the beginning. For example,
  # the tables "catalog_categories" and "catalog_products" generate a join table name of "catalog_categories_products".
  #
  # The join table should not have a primary key or a model associated with it. You must manually generate the
  # join table with a migration such as this:
  #
  #   class CreateDevelopersProjectsJoinTable < ActiveRecord::Migration[7.0]
  #     def change
  #       create_join_table :developers, :projects
  #     end
  #   end
  #
  # It's also a good idea to add indexes to each of those columns to speed up the joins process.
  # However, in MySQL it is advised to add a compound index for both of the columns as MySQL only
  # uses one index per table during the lookup.
  #
  # Adds the following methods for retrieval and query:
  #
  # +collection+ is a placeholder for the symbol passed as the +name+ argument, so
  # <tt>has_and_belongs_to_many :categories</tt> would add among others <tt>categories.empty?</tt>.
  #
  # [collection]
  #   Returns a Relation of all the associated objects.
  #   An empty Relation is returned if none are found.
  # [collection<<(object, ...)]
  #   Adds one or more objects to the collection by creating associations in the join table
  #   (<tt>collection.push</tt> and <tt>collection.concat</tt> are aliases to this method).
  #   Note that this operation instantly fires update SQL without waiting for the save or update call on the
  #   parent object, unless the parent object is a new record.
  # [collection.delete(object, ...)]
  #   Removes one or more objects from the collection by removing their associations from the join table.
  #   This does not destroy the objects.
  # [collection.destroy(object, ...)]
  #   Removes one or more objects from the collection by running destroy on each association in the join table, overriding any dependent option.
  #   This does not destroy the objects.
  # [collection=objects]
  #   Replaces the collection's content by deleting and adding objects as appropriate.
  # [collection_singular_ids]
  #   Returns an array of the associated objects' ids.
  # [collection_singular_ids=ids]
  #   Replace the collection by the objects identified by the primary keys in +ids+.
  # [collection.clear]
  #   Removes every object from the collection. This does not destroy the objects.
  # [collection.empty?]
  #   Returns +true+ if there are no associated objects.
  # [collection.size]
  #   Returns the number of associated objects.
  # [collection.find(id)]
  #   Finds an associated object responding to the +id+ and that
  #   meets the condition that it has to be associated with this object.
  #   Uses the same rules as ActiveRecord::FinderMethods#find.
  # [collection.exists?(...)]
  #   Checks whether an associated object with the given conditions exists.
  #   Uses the same rules as ActiveRecord::FinderMethods#exists?.
  # [collection.build(attributes = {})]
  #   Returns a new object of the collection type that has been instantiated
  #   with +attributes+ and linked to this object through the join table, but has not yet been saved.
  # [collection.create(attributes = {})]
  #   Returns a new object of the collection type that has been instantiated
  #   with +attributes+, linked to this object through the join table, and that has already been
  #   saved (if it passed the validation).
  # [collection.reload]
  #   Returns a Relation of all of the associated objects, forcing a database read.
  #   An empty Relation is returned if none are found.
  #
  # === Example
  #
  # A Developer class declares <tt>has_and_belongs_to_many :projects</tt>, which will add:
  # * <tt>Developer#projects</tt>
  # * <tt>Developer#projects<<</tt>
  # * <tt>Developer#projects.delete</tt>
  # * <tt>Developer#projects.destroy</tt>
  # * <tt>Developer#projects=</tt>
  # * <tt>Developer#project_ids</tt>
  # * <tt>Developer#project_ids=</tt>
  # * <tt>Developer#projects.clear</tt>
  # * <tt>Developer#projects.empty?</tt>
  # * <tt>Developer#projects.size</tt>
  # * <tt>Developer#projects.find(id)</tt>
  # * <tt>Developer#projects.exists?(...)</tt>
  # * <tt>Developer#projects.build</tt> (similar to <tt>Project.new(developer_id: id)</tt>)
  # * <tt>Developer#projects.create</tt> (similar to <tt>c = Project.new(developer_id: id); c.save; c</tt>)
  # * <tt>Developer#projects.reload</tt>
  # The declaration may include an +options+ hash to specialize the behavior of the association.
  #
  # === Scopes
  #
  # You can pass a second argument +scope+ as a callable (i.e. proc or
  # lambda) to retrieve a specific set of records or customize the generated
  # query when you access the associated collection.
  #
  # Scope examples:
  #   has_and_belongs_to_many :projects, -> { includes(:milestones, :manager) }
  #   has_and_belongs_to_many :categories, ->(post) {
  #     where("default_category = ?", post.default_category)
  #   }
  #
  # === Extensions
  #
  # The +extension+ argument allows you to pass a block into a
  # has_and_belongs_to_many association. This is useful for adding new
  # finders, creators, and other factory-type methods to be used as part of
  # the association.
  #
  # Extension examples:
  #   has_and_belongs_to_many :contractors do
  #     def find_or_create_by_name(name)
  #       first_name, last_name = name.split(" ", 2)
  #       find_or_create_by(first_name: first_name, last_name: last_name)
  #     end
  #   end
  #
  # === Options
  #
  # [:class_name]
  #   Specify the class name of the association. Use it only if that name can't be inferred
  #   from the association name. So <tt>has_and_belongs_to_many :projects</tt> will by default be linked to the
  #   Project class, but if the real class name is SuperProject, you'll have to specify it with this option.
  # [:join_table]
  #   Specify the name of the join table if the default based on lexical order isn't what you want.
  #   <b>WARNING:</b> If you're overwriting the table name of either class, the +table_name+ method
  #   MUST be declared underneath any #has_and_belongs_to_many declaration in order to work.
  # [:foreign_key]
  #   Specify the foreign key used for the association. By default this is guessed to be the name
  #   of this class in lower-case and "_id" suffixed. So a Person class that makes
  #   a #has_and_belongs_to_many association to Project will use "person_id" as the
  #   default <tt>:foreign_key</tt>.
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option.
  # [:association_foreign_key]
  #   Specify the foreign key used for the association on the receiving side of the association.
  #   By default this is guessed to be the name of the associated class in lower-case and "_id" suffixed.
  #   So if a Person class makes a #has_and_belongs_to_many association to Project,
  #   the association will use "project_id" as the default <tt>:association_foreign_key</tt>.
  # [:validate]
  #   When set to +true+, validates new objects added to association when saving the parent object. +true+ by default.
  #   If you want to ensure associated objects are revalidated on every update, use +validates_associated+.
  # [:autosave]
  #   If true, always save the associated objects or destroy them if marked for destruction, when
  #   saving the parent object.
  #   If false, never save or destroy the associated objects.
  #   By default, only save associated objects that are new records.
  #
  #   Note that NestedAttributes::ClassMethods#accepts_nested_attributes_for sets
  #   <tt>:autosave</tt> to <tt>true</tt>.
  # [:strict_loading]
  #   Enforces strict loading every time an associated record is loaded through this association.
  #
  # Option examples:
  #   has_and_belongs_to_many :projects
  #   has_and_belongs_to_many :projects, -> { includes(:milestones, :manager) }
  #   has_and_belongs_to_many :nations, class_name: "Country"
  #   has_and_belongs_to_many :categories, join_table: "prods_cats"
  #   has_and_belongs_to_many :categories, -> { readonly }
  #   has_and_belongs_to_many :categories, strict_loading: true
  #
  # source://activerecord//lib/active_record/associations.rb#1962
  def has_and_belongs_to_many(name, scope = T.unsafe(nil), **options, &extension); end

  # Specifies a one-to-many association. The following methods for retrieval and query of
  # collections of associated objects will be added:
  #
  # +collection+ is a placeholder for the symbol passed as the +name+ argument, so
  # <tt>has_many :clients</tt> would add among others <tt>clients.empty?</tt>.
  #
  # [collection]
  #   Returns a Relation of all the associated objects.
  #   An empty Relation is returned if none are found.
  # [collection<<(object, ...)]
  #   Adds one or more objects to the collection by setting their foreign keys to the collection's primary key.
  #   Note that this operation instantly fires update SQL without waiting for the save or update call on the
  #   parent object, unless the parent object is a new record.
  #   This will also run validations and callbacks of associated object(s).
  # [collection.delete(object, ...)]
  #   Removes one or more objects from the collection by setting their foreign keys to +NULL+.
  #   Objects will be in addition destroyed if they're associated with <tt>dependent: :destroy</tt>,
  #   and deleted if they're associated with <tt>dependent: :delete_all</tt>.
  #
  #   If the <tt>:through</tt> option is used, then the join records are deleted (rather than
  #   nullified) by default, but you can specify <tt>dependent: :destroy</tt> or
  #   <tt>dependent: :nullify</tt> to override this.
  # [collection.destroy(object, ...)]
  #   Removes one or more objects from the collection by running <tt>destroy</tt> on
  #   each record, regardless of any dependent option, ensuring callbacks are run.
  #
  #   If the <tt>:through</tt> option is used, then the join records are destroyed
  #   instead, not the objects themselves.
  # [collection=objects]
  #   Replaces the collections content by deleting and adding objects as appropriate. If the <tt>:through</tt>
  #   option is true callbacks in the join models are triggered except destroy callbacks, since deletion is
  #   direct by default. You can specify <tt>dependent: :destroy</tt> or
  #   <tt>dependent: :nullify</tt> to override this.
  # [collection_singular_ids]
  #   Returns an array of the associated objects' ids
  # [collection_singular_ids=ids]
  #   Replace the collection with the objects identified by the primary keys in +ids+. This
  #   method loads the models and calls <tt>collection=</tt>. See above.
  # [collection.clear]
  #   Removes every object from the collection. This destroys the associated objects if they
  #   are associated with <tt>dependent: :destroy</tt>, deletes them directly from the
  #   database if <tt>dependent: :delete_all</tt>, otherwise sets their foreign keys to +NULL+.
  #   If the <tt>:through</tt> option is true no destroy callbacks are invoked on the join models.
  #   Join models are directly deleted.
  # [collection.empty?]
  #   Returns +true+ if there are no associated objects.
  # [collection.size]
  #   Returns the number of associated objects.
  # [collection.find(...)]
  #   Finds an associated object according to the same rules as ActiveRecord::FinderMethods#find.
  # [collection.exists?(...)]
  #   Checks whether an associated object with the given conditions exists.
  #   Uses the same rules as ActiveRecord::FinderMethods#exists?.
  # [collection.build(attributes = {}, ...)]
  #   Returns one or more new objects of the collection type that have been instantiated
  #   with +attributes+ and linked to this object through a foreign key, but have not yet
  #   been saved.
  # [collection.create(attributes = {})]
  #   Returns a new object of the collection type that has been instantiated
  #   with +attributes+, linked to this object through a foreign key, and that has already
  #   been saved (if it passed the validation). *Note*: This only works if the base model
  #   already exists in the DB, not if it is a new (unsaved) record!
  # [collection.create!(attributes = {})]
  #   Does the same as <tt>collection.create</tt>, but raises ActiveRecord::RecordInvalid
  #   if the record is invalid.
  # [collection.reload]
  #   Returns a Relation of all of the associated objects, forcing a database read.
  #   An empty Relation is returned if none are found.
  #
  # === Example
  #
  # A <tt>Firm</tt> class declares <tt>has_many :clients</tt>, which will add:
  # * <tt>Firm#clients</tt> (similar to <tt>Client.where(firm_id: id)</tt>)
  # * <tt>Firm#clients<<</tt>
  # * <tt>Firm#clients.delete</tt>
  # * <tt>Firm#clients.destroy</tt>
  # * <tt>Firm#clients=</tt>
  # * <tt>Firm#client_ids</tt>
  # * <tt>Firm#client_ids=</tt>
  # * <tt>Firm#clients.clear</tt>
  # * <tt>Firm#clients.empty?</tt> (similar to <tt>firm.clients.size == 0</tt>)
  # * <tt>Firm#clients.size</tt> (similar to <tt>Client.count "firm_id = #{id}"</tt>)
  # * <tt>Firm#clients.find</tt> (similar to <tt>Client.where(firm_id: id).find(id)</tt>)
  # * <tt>Firm#clients.exists?(name: 'ACME')</tt> (similar to <tt>Client.exists?(name: 'ACME', firm_id: firm.id)</tt>)
  # * <tt>Firm#clients.build</tt> (similar to <tt>Client.new(firm_id: id)</tt>)
  # * <tt>Firm#clients.create</tt> (similar to <tt>c = Client.new(firm_id: id); c.save; c</tt>)
  # * <tt>Firm#clients.create!</tt> (similar to <tt>c = Client.new(firm_id: id); c.save!</tt>)
  # * <tt>Firm#clients.reload</tt>
  # The declaration can also include an +options+ hash to specialize the behavior of the association.
  #
  # === Scopes
  #
  # You can pass a second argument +scope+ as a callable (i.e. proc or
  # lambda) to retrieve a specific set of records or customize the generated
  # query when you access the associated collection.
  #
  # Scope examples:
  #   has_many :comments, -> { where(author_id: 1) }
  #   has_many :employees, -> { joins(:address) }
  #   has_many :posts, ->(blog) { where("max_post_length > ?", blog.max_post_length) }
  #
  # === Extensions
  #
  # The +extension+ argument allows you to pass a block into a has_many
  # association. This is useful for adding new finders, creators, and other
  # factory-type methods to be used as part of the association.
  #
  # Extension examples:
  #   has_many :employees do
  #     def find_or_create_by_name(name)
  #       first_name, last_name = name.split(" ", 2)
  #       find_or_create_by(first_name: first_name, last_name: last_name)
  #     end
  #   end
  #
  # === Options
  # [:class_name]
  #   Specify the class name of the association. Use it only if that name can't be inferred
  #   from the association name. So <tt>has_many :products</tt> will by default be linked
  #   to the +Product+ class, but if the real class name is +SpecialProduct+, you'll have to
  #   specify it with this option.
  # [:foreign_key]
  #   Specify the foreign key used for the association. By default this is guessed to be the name
  #   of this class in lower-case and "_id" suffixed. So a Person class that makes a #has_many
  #   association will use "person_id" as the default <tt>:foreign_key</tt>.
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option.
  # [:foreign_type]
  #   Specify the column used to store the associated object's type, if this is a polymorphic
  #   association. By default this is guessed to be the name of the polymorphic association
  #   specified on "as" option with a "_type" suffix. So a class that defines a
  #   <tt>has_many :tags, as: :taggable</tt> association will use "taggable_type" as the
  #   default <tt>:foreign_type</tt>.
  # [:primary_key]
  #   Specify the name of the column to use as the primary key for the association. By default this is +id+.
  # [:dependent]
  #   Controls what happens to the associated objects when
  #   their owner is destroyed. Note that these are implemented as
  #   callbacks, and Rails executes callbacks in order. Therefore, other
  #   similar callbacks may affect the <tt>:dependent</tt> behavior, and the
  #   <tt>:dependent</tt> behavior may affect other callbacks.
  #
  #   * <tt>nil</tt> do nothing (default).
  #   * <tt>:destroy</tt> causes all the associated objects to also be destroyed.
  #   * <tt>:destroy_async</tt> destroys all the associated objects in a background job. <b>WARNING:</b> Do not use
  #     this option if the association is backed by foreign key constraints in your database. The foreign key
  #     constraint actions will occur inside the same transaction that deletes its owner.
  #   * <tt>:delete_all</tt> causes all the associated objects to be deleted directly from the database (so callbacks will not be executed).
  #   * <tt>:nullify</tt> causes the foreign keys to be set to +NULL+. Polymorphic type will also be nullified
  #     on polymorphic associations. Callbacks are not executed.
  #   * <tt>:restrict_with_exception</tt> causes an <tt>ActiveRecord::DeleteRestrictionError</tt> exception to be raised if there are any associated records.
  #   * <tt>:restrict_with_error</tt> causes an error to be added to the owner if there are any associated objects.
  #
  #   If using with the <tt>:through</tt> option, the association on the join model must be
  #   a #belongs_to, and the records which get deleted are the join records, rather than
  #   the associated records.
  #
  #   If using <tt>dependent: :destroy</tt> on a scoped association, only the scoped objects are destroyed.
  #   For example, if a Post model defines
  #   <tt>has_many :comments, -> { where published: true }, dependent: :destroy</tt> and <tt>destroy</tt> is
  #   called on a post, only published comments are destroyed. This means that any unpublished comments in the
  #   database would still contain a foreign key pointing to the now deleted post.
  # [:counter_cache]
  #   This option can be used to configure a custom named <tt>:counter_cache.</tt> You only need this option,
  #   when you customized the name of your <tt>:counter_cache</tt> on the #belongs_to association.
  # [:as]
  #   Specifies a polymorphic interface (See #belongs_to).
  # [:through]
  #   Specifies an association through which to perform the query. This can be any other type
  #   of association, including other <tt>:through</tt> associations. Options for <tt>:class_name</tt>,
  #   <tt>:primary_key</tt> and <tt>:foreign_key</tt> are ignored, as the association uses the
  #   source reflection.
  #
  #   If the association on the join model is a #belongs_to, the collection can be modified
  #   and the records on the <tt>:through</tt> model will be automatically created and removed
  #   as appropriate. Otherwise, the collection is read-only, so you should manipulate the
  #   <tt>:through</tt> association directly.
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option on the source association on the
  #   join model. This allows associated records to be built which will automatically create
  #   the appropriate join model records when they are saved. (See the 'Association Join Models'
  #   section above.)
  # [:disable_joins]
  #   Specifies whether joins should be skipped for an association. If set to true, two or more queries
  #   will be generated. Note that in some cases, if order or limit is applied, it will be done in-memory
  #   due to database limitations. This option is only applicable on <tt>has_many :through</tt> associations as
  #   +has_many+ alone do not perform a join.
  # [:source]
  #   Specifies the source association name used by #has_many <tt>:through</tt> queries.
  #   Only use it if the name cannot be inferred from the association.
  #   <tt>has_many :subscribers, through: :subscriptions</tt> will look for either <tt>:subscribers</tt> or
  #   <tt>:subscriber</tt> on Subscription, unless a <tt>:source</tt> is given.
  # [:source_type]
  #   Specifies type of the source association used by #has_many <tt>:through</tt> queries where the source
  #   association is a polymorphic #belongs_to.
  # [:validate]
  #   When set to +true+, validates new objects added to association when saving the parent object. +true+ by default.
  #   If you want to ensure associated objects are revalidated on every update, use +validates_associated+.
  # [:autosave]
  #   If true, always save the associated objects or destroy them if marked for destruction,
  #   when saving the parent object. If false, never save or destroy the associated objects.
  #   By default, only save associated objects that are new records. This option is implemented as a
  #   +before_save+ callback. Because callbacks are run in the order they are defined, associated objects
  #   may need to be explicitly saved in any user-defined +before_save+ callbacks.
  #
  #   Note that NestedAttributes::ClassMethods#accepts_nested_attributes_for sets
  #   <tt>:autosave</tt> to <tt>true</tt>.
  # [:inverse_of]
  #   Specifies the name of the #belongs_to association on the associated object
  #   that is the inverse of this #has_many association.
  #   See ActiveRecord::Associations::ClassMethods's overview on Bi-directional associations for more detail.
  # [:extend]
  #   Specifies a module or array of modules that will be extended into the association object returned.
  #   Useful for defining methods on associations, especially when they should be shared between multiple
  #   association objects.
  # [:strict_loading]
  #   When set to +true+, enforces strict loading every time the associated record is loaded through this
  #   association.
  # [:ensuring_owner_was]
  #   Specifies an instance method to be called on the owner. The method must return true in order for the
  #   associated records to be deleted in a background job.
  #
  # Option examples:
  #   has_many :comments, -> { order("posted_on") }
  #   has_many :comments, -> { includes(:author) }
  #   has_many :people, -> { where(deleted: false).order("name") }, class_name: "Person"
  #   has_many :tracks, -> { order("position") }, dependent: :destroy
  #   has_many :comments, dependent: :nullify
  #   has_many :tags, as: :taggable
  #   has_many :reports, -> { readonly }
  #   has_many :subscribers, through: :subscriptions, source: :user
  #   has_many :subscribers, through: :subscriptions, disable_joins: true
  #   has_many :comments, strict_loading: true
  #
  # source://activerecord//lib/active_record/associations.rb#1466
  def has_many(name, scope = T.unsafe(nil), **options, &extension); end

  # Specifies a one-to-one association with another class. This method should only be used
  # if the other class contains the foreign key. If the current class contains the foreign key,
  # then you should use #belongs_to instead. See also ActiveRecord::Associations::ClassMethods's overview
  # on when to use #has_one and when to use #belongs_to.
  #
  # The following methods for retrieval and query of a single associated object will be added:
  #
  # +association+ is a placeholder for the symbol passed as the +name+ argument, so
  # <tt>has_one :manager</tt> would add among others <tt>manager.nil?</tt>.
  #
  # [association]
  #   Returns the associated object. +nil+ is returned if none is found.
  # [association=(associate)]
  #   Assigns the associate object, extracts the primary key, sets it as the foreign key,
  #   and saves the associate object. To avoid database inconsistencies, permanently deletes an existing
  #   associated object when assigning a new one, even if the new one isn't saved to database.
  # [build_association(attributes = {})]
  #   Returns a new object of the associated type that has been instantiated
  #   with +attributes+ and linked to this object through a foreign key, but has not
  #   yet been saved.
  # [create_association(attributes = {})]
  #   Returns a new object of the associated type that has been instantiated
  #   with +attributes+, linked to this object through a foreign key, and that
  #   has already been saved (if it passed the validation).
  # [create_association!(attributes = {})]
  #   Does the same as <tt>create_association</tt>, but raises ActiveRecord::RecordInvalid
  #   if the record is invalid.
  # [reload_association]
  #   Returns the associated object, forcing a database read.
  #
  # === Example
  #
  # An Account class declares <tt>has_one :beneficiary</tt>, which will add:
  # * <tt>Account#beneficiary</tt> (similar to <tt>Beneficiary.where(account_id: id).first</tt>)
  # * <tt>Account#beneficiary=(beneficiary)</tt> (similar to <tt>beneficiary.account_id = account.id; beneficiary.save</tt>)
  # * <tt>Account#build_beneficiary</tt> (similar to <tt>Beneficiary.new(account_id: id)</tt>)
  # * <tt>Account#create_beneficiary</tt> (similar to <tt>b = Beneficiary.new(account_id: id); b.save; b</tt>)
  # * <tt>Account#create_beneficiary!</tt> (similar to <tt>b = Beneficiary.new(account_id: id); b.save!; b</tt>)
  # * <tt>Account#reload_beneficiary</tt>
  #
  # === Scopes
  #
  # You can pass a second argument +scope+ as a callable (i.e. proc or
  # lambda) to retrieve a specific record or customize the generated query
  # when you access the associated object.
  #
  # Scope examples:
  #   has_one :author, -> { where(comment_id: 1) }
  #   has_one :employer, -> { joins(:company) }
  #   has_one :latest_post, ->(blog) { where("created_at > ?", blog.enabled_at) }
  #
  # === Options
  #
  # The declaration can also include an +options+ hash to specialize the behavior of the association.
  #
  # Options are:
  # [:class_name]
  #   Specify the class name of the association. Use it only if that name can't be inferred
  #   from the association name. So <tt>has_one :manager</tt> will by default be linked to the Manager class, but
  #   if the real class name is Person, you'll have to specify it with this option.
  # [:dependent]
  #   Controls what happens to the associated object when
  #   its owner is destroyed:
  #
  #   * <tt>nil</tt> do nothing (default).
  #   * <tt>:destroy</tt> causes the associated object to also be destroyed
  #   * <tt>:destroy_async</tt> causes the associated object to be destroyed in a background job. <b>WARNING:</b> Do not use
  #     this option if the association is backed by foreign key constraints in your database. The foreign key
  #     constraint actions will occur inside the same transaction that deletes its owner.
  #   * <tt>:delete</tt> causes the associated object to be deleted directly from the database (so callbacks will not execute)
  #   * <tt>:nullify</tt> causes the foreign key to be set to +NULL+. Polymorphic type column is also nullified
  #     on polymorphic associations. Callbacks are not executed.
  #   * <tt>:restrict_with_exception</tt> causes an <tt>ActiveRecord::DeleteRestrictionError</tt> exception to be raised if there is an associated record
  #   * <tt>:restrict_with_error</tt> causes an error to be added to the owner if there is an associated object
  #
  #   Note that <tt>:dependent</tt> option is ignored when using <tt>:through</tt> option.
  # [:foreign_key]
  #   Specify the foreign key used for the association. By default this is guessed to be the name
  #   of this class in lower-case and "_id" suffixed. So a Person class that makes a #has_one association
  #   will use "person_id" as the default <tt>:foreign_key</tt>.
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option.
  # [:foreign_type]
  #   Specify the column used to store the associated object's type, if this is a polymorphic
  #   association. By default this is guessed to be the name of the polymorphic association
  #   specified on "as" option with a "_type" suffix. So a class that defines a
  #   <tt>has_one :tag, as: :taggable</tt> association will use "taggable_type" as the
  #   default <tt>:foreign_type</tt>.
  # [:primary_key]
  #   Specify the method that returns the primary key used for the association. By default this is +id+.
  # [:as]
  #   Specifies a polymorphic interface (See #belongs_to).
  # [:through]
  #   Specifies a Join Model through which to perform the query. Options for <tt>:class_name</tt>,
  #   <tt>:primary_key</tt>, and <tt>:foreign_key</tt> are ignored, as the association uses the
  #   source reflection. You can only use a <tt>:through</tt> query through a #has_one
  #   or #belongs_to association on the join model.
  #
  #   If the association on the join model is a #belongs_to, the collection can be modified
  #   and the records on the <tt>:through</tt> model will be automatically created and removed
  #   as appropriate. Otherwise, the collection is read-only, so you should manipulate the
  #   <tt>:through</tt> association directly.
  #
  #   If you are going to modify the association (rather than just read from it), then it is
  #   a good idea to set the <tt>:inverse_of</tt> option on the source association on the
  #   join model. This allows associated records to be built which will automatically create
  #   the appropriate join model records when they are saved. (See the 'Association Join Models'
  #   section above.)
  # [:disable_joins]
  #   Specifies whether joins should be skipped for an association. If set to true, two or more queries
  #   will be generated. Note that in some cases, if order or limit is applied, it will be done in-memory
  #   due to database limitations. This option is only applicable on <tt>has_one :through</tt> associations as
  #   +has_one+ alone does not perform a join.
  # [:source]
  #   Specifies the source association name used by #has_one <tt>:through</tt> queries.
  #   Only use it if the name cannot be inferred from the association.
  #   <tt>has_one :favorite, through: :favorites</tt> will look for a
  #   <tt>:favorite</tt> on Favorite, unless a <tt>:source</tt> is given.
  # [:source_type]
  #   Specifies type of the source association used by #has_one <tt>:through</tt> queries where the source
  #   association is a polymorphic #belongs_to.
  # [:validate]
  #   When set to +true+, validates new objects added to association when saving the parent object. +false+ by default.
  #   If you want to ensure associated objects are revalidated on every update, use +validates_associated+.
  # [:autosave]
  #   If true, always save the associated object or destroy it if marked for destruction,
  #   when saving the parent object. If false, never save or destroy the associated object.
  #   By default, only save the associated object if it's a new record.
  #
  #   Note that NestedAttributes::ClassMethods#accepts_nested_attributes_for sets
  #   <tt>:autosave</tt> to <tt>true</tt>.
  # [:inverse_of]
  #   Specifies the name of the #belongs_to association on the associated object
  #   that is the inverse of this #has_one association.
  #   See ActiveRecord::Associations::ClassMethods's overview on Bi-directional associations for more detail.
  # [:required]
  #   When set to +true+, the association will also have its presence validated.
  #   This will validate the association itself, not the id. You can use
  #   +:inverse_of+ to avoid an extra query during validation.
  # [:strict_loading]
  #   Enforces strict loading every time the associated record is loaded through this association.
  # [:ensuring_owner_was]
  #   Specifies an instance method to be called on the owner. The method must return true in order for the
  #   associated records to be deleted in a background job.
  #
  # Option examples:
  #   has_one :credit_card, dependent: :destroy  # destroys the associated credit card
  #   has_one :credit_card, dependent: :nullify  # updates the associated records foreign
  #                                                 # key value to NULL rather than destroying it
  #   has_one :last_comment, -> { order('posted_on') }, class_name: "Comment"
  #   has_one :project_manager, -> { where(role: 'project_manager') }, class_name: "Person"
  #   has_one :attachment, as: :attachable
  #   has_one :boss, -> { readonly }
  #   has_one :club, through: :membership
  #   has_one :club, through: :membership, disable_joins: true
  #   has_one :primary_address, -> { where(primary: true) }, through: :addressables, source: :addressable
  #   has_one :credit_card, required: true
  #   has_one :credit_card, strict_loading: true
  #
  # source://activerecord//lib/active_record/associations.rb#1630
  def has_one(name, scope = T.unsafe(nil), **options); end
end

# = Active Record Association Collection
#
# CollectionAssociation is an abstract class that provides common stuff to
# ease the implementation of association proxies that represent
# collections. See the class hierarchy in Association.
#
#   CollectionAssociation:
#     HasManyAssociation => has_many
#       HasManyThroughAssociation + ThroughAssociation => has_many :through
#
# The CollectionAssociation class provides common methods to the collections
# defined by +has_and_belongs_to_many+, +has_many+ or +has_many+ with
# the +:through association+ option.
#
# You need to be careful with assumptions regarding the target: The proxy
# does not fetch records from the database until it needs them, but new
# ones created with +build+ are added to the target. So, the target may be
# non-empty and still lack children waiting to be read from the database.
# If you look directly to the database you cannot assume that's the entire
# collection because new records may have been added to the target, etc.
#
# If you need to work on all current children, new and existing records,
# +load_target+ and the +loaded+ flag are your friends.
class ActiveRecord::Associations::CollectionAssociation < ::ActiveRecord::Associations::Association
  # source://activerecord//lib/active_record/associations/collection_association.rb#271
  def add_to_target(record, skip_callbacks: T.unsafe(nil), replace: T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#109
  def build(attributes = T.unsafe(nil), &block); end

  # Add +records+ to this association. Since +<<+ flattens its argument list
  # and inserts each record, +push+ and +concat+ behave identically.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#119
  def concat(*records); end

  # Removes +records+ from this association calling +before_remove+ and
  # +after_remove+ callbacks.
  #
  # This method is abstract in the sense that +delete_records+ has to be
  # provided by descendants. Note this method does not imply the records
  # are actually removed from the database, that depends precisely on
  # +delete_records+. They are in any case removed from the collection.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#178
  def delete(*records); end

  # Removes all records from the association without calling callbacks
  # on the associated records. It honors the +:dependent+ option. However
  # if the +:dependent+ value is +:destroy+ then in that case the +:delete_all+
  # deletion strategy for the association is applied.
  #
  # You can force a particular deletion strategy by passing a parameter.
  #
  # Example:
  #
  # @author.books.delete_all(:nullify)
  # @author.books.delete_all(:delete_all)
  #
  # See delete for more info.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#142
  def delete_all(dependent = T.unsafe(nil)); end

  # Deletes the +records+ and removes them from this association calling
  # +before_remove+, +after_remove+, +before_destroy+ and +after_destroy+ callbacks.
  #
  # Note that this method removes records from the database ignoring the
  # +:dependent+ option.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#187
  def destroy(*records); end

  # Destroy all the records from this association.
  #
  # See destroy for more info.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#164
  def destroy_all; end

  # Returns true if the collection is empty.
  #
  # If the collection has been loaded
  # it is equivalent to <tt>collection.size.zero?</tt>. If the
  # collection has not been loaded, it is equivalent to
  # <tt>!collection.exists?</tt>. If the collection has not already been
  # loaded and you are going to fetch the records anyway it is better to
  # check <tt>collection.length.zero?</tt>.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#224
  def empty?; end

  # source://activerecord//lib/active_record/associations/collection_association.rb#86
  def find(*args); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#298
  def find_from_target?; end

  # Implements the ids reader method, e.g. foo.item_ids for Foo.has_many :items
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#49
  def ids_reader; end

  # Implements the ids writer method, e.g. foo.item_ids= for Foo.has_many :items
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#60
  def ids_writer(ids); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#250
  def include?(record); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#262
  def load_target; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#294
  def null_scope?; end

  # Implements the reader method, e.g. foo.items for Foo.has_many :items
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#32
  def reader; end

  # Replace this collection with +other_array+. This will perform a diff
  # and delete/add only records that have changed.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#234
  def replace(other_array); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#79
  def reset; end

  # source://activerecord//lib/active_record/associations/collection_association.rb#288
  def scope; end

  # Returns the size of the collection by executing a SELECT COUNT(*)
  # query if the collection hasn't been loaded, and calling
  # <tt>collection.size</tt> if it has.
  #
  # If the collection has been already loaded +size+ and +length+ are
  # equivalent. If not and you are going to need the records anyway
  # +length+ will take one less query. Otherwise +size+ is more efficient.
  #
  # This method is abstract in the sense that it relies on
  # +count_records+, which is a method descendants have to provide.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#201
  def size; end

  # source://activerecord//lib/active_record/associations/collection_association.rb#275
  def target=(record); end

  # Implements the writer method, e.g. foo.items= for Foo.has_many :items
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#44
  def writer(records); end

  private

  # source://activerecord//lib/active_record/associations/collection_association.rb#340
  def _create_record(attributes, raise = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#478
  def callback(method, record); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#484
  def callbacks_for(callback_name); end

  # @raise [ActiveRecord::Rollback]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#424
  def concat_records(records, raise = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#371
  def delete_or_destroy(records, method); end

  # Delete the given records from the association,
  # using one of the methods +:destroy+, +:delete_all+
  # or +:nullify+ (or +nil+, in which case a default is used).
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#400
  def delete_records(records, method); end

  # If the :inverse_of option has been
  # specified, then #find scans the entire collection.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#507
  def find_by_scan(*args); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#493
  def include_in_memory?(record); end

  # Do the relevant stuff to insert the given record into the association collection.
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#363
  def insert_record(record, validate = T.unsafe(nil), raise = T.unsafe(nil), &block); end

  # We have some records loaded from the database (persisted) and some that are
  # in-memory (memory). The same record may be represented in the persisted array
  # and in the memory array.
  #
  # So the task of this method is to merge them according to the following rules:
  #
  #   * The final array must not have duplicates
  #   * The order of the persisted array is to be preserved
  #   * Any changes made to attributes on objects in the memory array are to be preserved
  #   * Otherwise, attributes should have the value found in the database
  #
  # source://activerecord//lib/active_record/associations/collection_association.rb#321
  def merge_target_lists(persisted, memory); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#385
  def remove_records(existing_records, records, method); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#416
  def replace_common_records_in_memory(new_target, original_target); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#443
  def replace_on_target(record, skip_callbacks, replace:, inversing: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#404
  def replace_records(new_target, original_target); end

  # source://activerecord//lib/active_record/associations/collection_association.rb#307
  def transaction(&block); end
end

# Collection proxies in Active Record are middlemen between an
# <tt>association</tt>, and its <tt>target</tt> result set.
#
# For example, given
#
#   class Blog < ActiveRecord::Base
#     has_many :posts
#   end
#
#   blog = Blog.first
#
# The collection proxy returned by <tt>blog.posts</tt> is built from a
# <tt>:has_many</tt> <tt>association</tt>, and delegates to a collection
# of posts as the <tt>target</tt>.
#
# This class delegates unknown methods to the <tt>association</tt>'s
# relation class via a delegate cache.
#
# The <tt>target</tt> result set is not loaded until needed. For example,
#
#   blog.posts.count
#
# is computed directly through SQL and does not trigger by itself the
# instantiation of the actual post records.
class ActiveRecord::Associations::CollectionProxy < ::ActiveRecord::Relation
  # @return [CollectionProxy] a new instance of CollectionProxy
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#30
  def initialize(klass, association, **_arg2); end

  # Adds one or more +records+ to the collection by setting their foreign keys
  # to the association's primary key. Since <tt><<</tt> flattens its argument list and
  # inserts each record, +push+ and +concat+ behave identically. Returns +self+
  # so several appends may be chained together.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 0
  #   person.pets << Pet.new(name: 'Fancy-Fancy')
  #   person.pets << [Pet.new(name: 'Spook'), Pet.new(name: 'Choo-Choo')]
  #   person.pets.size # => 3
  #
  #   person.id # => 1
  #   person.pets
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1031
  def <<(*records); end

  # Equivalent to <tt>Array#==</tt>. Returns +true+ if the two arrays
  # contain the same number of elements and if each element is equal
  # to the corresponding element in the +other+ array, otherwise returns
  # +false+.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>
  #   #    ]
  #
  #   other = person.pets.to_ary
  #
  #   person.pets == other
  #   # => true
  #
  #   other = [Pet.new(id: 1), Pet.new(id: 2)]
  #
  #   person.pets == other
  #   # => false
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#962
  def ==(other); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def _select!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def and(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def and!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def annotate(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def annotate!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def annotate_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def annotate_values=(arg); end

  # Adds one or more +records+ to the collection by setting their foreign keys
  # to the association's primary key. Since <tt><<</tt> flattens its argument list and
  # inserts each record, +push+ and +concat+ behave identically. Returns +self+
  # so several appends may be chained together.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 0
  #   person.pets << Pet.new(name: 'Fancy-Fancy')
  #   person.pets << [Pet.new(name: 'Spook'), Pet.new(name: 'Choo-Choo')]
  #   person.pets.size # => 3
  #
  #   person.id # => 1
  #   person.pets
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1031
  def append(*records); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def arel(*_arg0, **_arg1, &_arg2); end

  # Returns a new object of the collection type that has been instantiated
  # with +attributes+ and linked to this object, but have not yet been saved.
  # You can pass an array of attributes hashes, this will return an array
  # with the new objects.
  #
  #   class Person
  #     has_many :pets
  #   end
  #
  #   person.pets.build
  #   # => #<Pet id: nil, name: nil, person_id: 1>
  #
  #   person.pets.build(name: 'Fancy-Fancy')
  #   # => #<Pet id: nil, name: "Fancy-Fancy", person_id: 1>
  #
  #   person.pets.build([{name: 'Spook'}, {name: 'Choo-Choo'}, {name: 'Brain'}])
  #   # => [
  #   #      #<Pet id: nil, name: "Spook", person_id: 1>,
  #   #      #<Pet id: nil, name: "Choo-Choo", person_id: 1>,
  #   #      #<Pet id: nil, name: "Brain", person_id: 1>
  #   #    ]
  #
  #   person.pets.size  # => 5 # size of the collection
  #   person.pets.count # => 0 # count from database
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#316
  def build(attributes = T.unsafe(nil), &block); end

  # --
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#722
  def calculate(operation, column_name); end

  # Equivalent to +delete_all+. The difference is that returns +self+, instead
  # of an array with the deleted objects, so methods can be chained. See
  # +delete_all+ for more information.
  # Note that because +delete_all+ removes records by directly
  # running an SQL query into the database, the +updated_at+ column of
  # the object is not changed.
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1048
  def clear; end

  # Adds one or more +records+ to the collection by setting their foreign keys
  # to the association's primary key. Since <tt><<</tt> flattens its argument list and
  # inserts each record, +push+ and +concat+ behave identically. Returns +self+
  # so several appends may be chained together.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 0
  #   person.pets << Pet.new(name: 'Fancy-Fancy')
  #   person.pets << [Pet.new(name: 'Spook'), Pet.new(name: 'Choo-Choo')]
  #   person.pets.size # => 3
  #
  #   person.id # => 1
  #   person.pets
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1031
  def concat(*records); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def construct_join_dependency(*_arg0, **_arg1, &_arg2); end

  # Returns a new object of the collection type that has been instantiated with
  # attributes, linked to this object and that has already been saved (if it
  # passes the validations).
  #
  #   class Person
  #     has_many :pets
  #   end
  #
  #   person.pets.create(name: 'Fancy-Fancy')
  #   # => #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>
  #
  #   person.pets.create([{name: 'Spook'}, {name: 'Choo-Choo'}])
  #   # => [
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.size  # => 3
  #   person.pets.count # => 3
  #
  #   person.pets.find(1, 2, 3)
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#347
  def create(attributes = T.unsafe(nil), &block); end

  # Like #create, except that if the record is invalid, raises an exception.
  #
  #   class Person
  #     has_many :pets
  #   end
  #
  #   class Pet
  #     validates :name, presence: true
  #   end
  #
  #   person.pets.create!(name: nil)
  #   # => ActiveRecord::RecordInvalid: Validation failed: Name can't be blank
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#363
  def create!(attributes = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def create_with(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def create_with!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def create_with_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def create_with_value=(arg); end

  # Deletes the +records+ supplied from the collection according to the strategy
  # specified by the +:dependent+ option. If no +:dependent+ option is given,
  # then it will follow the default strategy. Returns an array with the
  # deleted records.
  #
  # For <tt>has_many :through</tt> associations, the default deletion strategy is
  # +:delete_all+.
  #
  # For +has_many+ associations, the default deletion strategy is +:nullify+.
  # This sets the foreign keys to +NULL+.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets # dependent: :nullify option by default
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete(Pet.find(1))
  #   # => [#<Pet id: 1, name: "Fancy-Fancy", person_id: 1>]
  #
  #   person.pets.size # => 2
  #   person.pets
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   Pet.find(1)
  #   # => #<Pet id: 1, name: "Fancy-Fancy", person_id: nil>
  #
  # If it is set to <tt>:destroy</tt> all the +records+ are removed by calling
  # their +destroy+ method. See +destroy+ for more information.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets, dependent: :destroy
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete(Pet.find(1), Pet.find(3))
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.size # => 1
  #   person.pets
  #   # => [#<Pet id: 2, name: "Spook", person_id: 1>]
  #
  #   Pet.find(1, 3)
  #   # => ActiveRecord::RecordNotFound: Couldn't find all Pets with 'id': (1, 3)
  #
  # If it is set to <tt>:delete_all</tt>, all the +records+ are deleted
  # *without* calling their +destroy+ method.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets, dependent: :delete_all
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete(Pet.find(1))
  #   # => [#<Pet id: 1, name: "Fancy-Fancy", person_id: 1>]
  #
  #   person.pets.size # => 2
  #   person.pets
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   Pet.find(1)
  #   # => ActiveRecord::RecordNotFound: Couldn't find Pet with 'id'=1
  #
  # You can pass +Integer+ or +String+ values, it finds the records
  # responding to the +id+ and executes delete on them.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete("1")
  #   # => [#<Pet id: 1, name: "Fancy-Fancy", person_id: 1>]
  #
  #   person.pets.delete(2, 3)
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#618
  def delete(*records); end

  # Deletes all the records from the collection according to the strategy
  # specified by the +:dependent+ option. If no +:dependent+ option is given,
  # then it will follow the default strategy.
  #
  # For <tt>has_many :through</tt> associations, the default deletion strategy is
  # +:delete_all+.
  #
  # For +has_many+ associations, the default deletion strategy is +:nullify+.
  # This sets the foreign keys to +NULL+.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets # dependent: :nullify option by default
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete_all
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.size # => 0
  #   person.pets      # => []
  #
  #   Pet.find(1, 2, 3)
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: nil>,
  #   #       #<Pet id: 2, name: "Spook", person_id: nil>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: nil>
  #   #    ]
  #
  # Both +has_many+ and <tt>has_many :through</tt> dependencies default to the
  # +:delete_all+ strategy if the +:dependent+ option is set to +:destroy+.
  # Records are not instantiated and callbacks will not be fired.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets, dependent: :destroy
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete_all
  #
  #   Pet.find(1, 2, 3)
  #   # => ActiveRecord::RecordNotFound: Couldn't find all Pets with 'id': (1, 2, 3)
  #
  # If it is set to <tt>:delete_all</tt>, all the objects are deleted
  # *without* calling their +destroy+ method.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets, dependent: :delete_all
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.delete_all
  #
  #   Pet.find(1, 2, 3)
  #   # => ActiveRecord::RecordNotFound: Couldn't find all Pets with 'id': (1, 2, 3)
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#472
  def delete_all(dependent = T.unsafe(nil)); end

  # Destroys the +records+ supplied and removes them from the collection.
  # This method will _always_ remove record from the database ignoring
  # the +:dependent+ option. Returns an array with the removed records.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.destroy(Pet.find(1))
  #   # => [#<Pet id: 1, name: "Fancy-Fancy", person_id: 1>]
  #
  #   person.pets.size # => 2
  #   person.pets
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.destroy(Pet.find(2), Pet.find(3))
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.size  # => 0
  #   person.pets       # => []
  #
  #   Pet.find(1, 2, 3) # => ActiveRecord::RecordNotFound: Couldn't find all Pets with 'id': (1, 2, 3)
  #
  # You can pass +Integer+ or +String+ values, it finds the records
  # responding to the +id+ and then deletes them from the database.
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 4, name: "Benny", person_id: 1>,
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  #   person.pets.destroy("4")
  #   # => #<Pet id: 4, name: "Benny", person_id: 1>
  #
  #   person.pets.size # => 2
  #   person.pets
  #   # => [
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  #   person.pets.destroy(5, 6)
  #   # => [
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  #   person.pets.size  # => 0
  #   person.pets       # => []
  #
  #   Pet.find(4, 5, 6) # => ActiveRecord::RecordNotFound: Couldn't find all Pets with 'id': (4, 5, 6)
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#690
  def destroy(*records); end

  # Deletes the records of the collection directly from the database
  # ignoring the +:dependent+ option. Records are instantiated and it
  # invokes +before_remove+, +after_remove+, +before_destroy+, and
  # +after_destroy+ callbacks.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 3
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.destroy_all
  #
  #   person.pets.size # => 0
  #   person.pets      # => []
  #
  #   Pet.find(1) # => Couldn't find Pet with id=1
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#499
  def destroy_all; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def distinct(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def distinct!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def distinct_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def distinct_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def eager_load(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def eager_load!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def eager_load_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def eager_load_values=(arg); end

  # Returns +true+ if the collection is empty. If the collection has been
  # loaded it is equivalent
  # to <tt>collection.size.zero?</tt>. If the collection has not been loaded,
  # it is equivalent to <tt>!collection.exists?</tt>. If the collection has
  # not already been loaded and you are going to fetch the records anyway it
  # is better to check <tt>collection.load.empty?</tt>.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.count  # => 1
  #   person.pets.empty? # => false
  #
  #   person.pets.delete_all
  #
  #   person.pets.count  # => 0
  #   person.pets.empty? # => true
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#829
  def empty?; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def except(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def excluding(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def excluding!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extending(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extending!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extending_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extending_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extensions(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def extract_associated(*_arg0, **_arg1, &_arg2); end

  # Finds an object in the collection responding to the +id+. Uses the same
  # rules as ActiveRecord::Base.find. Returns ActiveRecord::RecordNotFound
  # error if the object cannot be found.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.find(1) # => #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>
  #   person.pets.find(4) # => ActiveRecord::RecordNotFound: Couldn't find Pet with 'id'=4
  #
  #   person.pets.find(2) { |pet| pet.name.downcase! }
  #   # => #<Pet id: 2, name: "fancy-fancy", person_id: 1>
  #
  #   person.pets.find(2, 3)
  #   # => [
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#136
  def find(*args); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def from(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def from!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def from_clause(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def from_clause=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def group(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def group!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def group_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def group_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def having(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def having!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def having_clause(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def having_clause=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def in_order_of(*_arg0, **_arg1, &_arg2); end

  # Returns +true+ if the given +record+ is present in the collection.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets # => [#<Pet id: 20, name: "Snoop">]
  #
  #   person.pets.include?(Pet.find(20)) # => true
  #   person.pets.include?(Pet.find(21)) # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#925
  def include?(record); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def includes(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def includes!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def includes_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def includes_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def insert(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def insert!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def insert_all(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def insert_all!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1100
  def inspect; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def invert_where(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def invert_where!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def joins(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def joins!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def joins_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def joins_values=(arg); end

  # Returns the last record, or the last +n+ records, from the collection.
  # If the collection is empty, the first form returns +nil+, and the second
  # form returns an empty array.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.last # => #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #
  #   person.pets.last(2)
  #   # => [
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   another_person_without.pets         # => []
  #   another_person_without.pets.last    # => nil
  #   another_person_without.pets.last(3) # => []
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#257
  def last(limit = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def left_joins(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def left_outer_joins(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def left_outer_joins!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def left_outer_joins_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def left_outer_joins_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def limit(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def limit!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def limit_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def limit_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def load_async(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#42
  def load_target; end

  # Returns +true+ if the association has been loaded, otherwise +false+.
  #
  #   person.pets.loaded? # => false
  #   person.pets.records
  #   person.pets.loaded? # => true
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#51
  def loaded; end

  # Returns +true+ if the association has been loaded, otherwise +false+.
  #
  #   person.pets.loaded? # => false
  #   person.pets.records
  #   person.pets.loaded? # => true
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#51
  def loaded?; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def lock(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def lock!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def lock_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def lock_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def merge(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def merge!(*_arg0, **_arg1, &_arg2); end

  # Returns a new object of the collection type that has been instantiated
  # with +attributes+ and linked to this object, but have not yet been saved.
  # You can pass an array of attributes hashes, this will return an array
  # with the new objects.
  #
  #   class Person
  #     has_many :pets
  #   end
  #
  #   person.pets.build
  #   # => #<Pet id: nil, name: nil, person_id: 1>
  #
  #   person.pets.build(name: 'Fancy-Fancy')
  #   # => #<Pet id: nil, name: "Fancy-Fancy", person_id: 1>
  #
  #   person.pets.build([{name: 'Spook'}, {name: 'Choo-Choo'}, {name: 'Brain'}])
  #   # => [
  #   #      #<Pet id: nil, name: "Spook", person_id: 1>,
  #   #      #<Pet id: nil, name: "Choo-Choo", person_id: 1>,
  #   #      #<Pet id: nil, name: "Brain", person_id: 1>
  #   #    ]
  #
  #   person.pets.size  # => 5 # size of the collection
  #   person.pets.count # => 0 # count from database
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#316
  def new(attributes = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def none(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def none!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def offset(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def offset!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def offset_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def offset_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def only(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def optimizer_hints(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def optimizer_hints!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def optimizer_hints_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def optimizer_hints_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def or(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def or!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def order(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def order!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def order_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def order_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#726
  def pluck(*column_names); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def preload(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def preload!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def preload_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def preload_values=(arg); end

  # @raise [NoMethodError]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1038
  def prepend(*args); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#929
  def proxy_association; end

  # Adds one or more +records+ to the collection by setting their foreign keys
  # to the association's primary key. Since <tt><<</tt> flattens its argument list and
  # inserts each record, +push+ and +concat+ behave identically. Returns +self+
  # so several appends may be chained together.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 0
  #   person.pets << Pet.new(name: 'Fancy-Fancy')
  #   person.pets << [Pet.new(name: 'Spook'), Pet.new(name: 'Choo-Choo')]
  #   person.pets.size # => 3
  #
  #   person.id # => 1
  #   person.pets
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #      #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1031
  def push(*records); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def readonly(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def readonly!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def readonly_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def readonly_value=(arg); end

  # :method: to_ary
  #
  # :call-seq:
  #   to_ary()
  #
  # Returns a new array of objects from the collection. If the collection
  # hasn't been loaded, it fetches the records from the database.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [
  #   #       #<Pet id: 4, name: "Benny", person_id: 1>,
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  #   other_pets = person.pets.to_ary
  #   # => [
  #   #       #<Pet id: 4, name: "Benny", person_id: 1>,
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  #   other_pets.replace([Pet.new(name: 'BooGoo')])
  #
  #   other_pets
  #   # => [#<Pet id: nil, name: "BooGoo", person_id: 1>]
  #
  #   person.pets
  #   # This is not affected by replace
  #   # => [
  #   #       #<Pet id: 4, name: "Benny", person_id: 1>,
  #   #       #<Pet id: 5, name: "Brain", person_id: 1>,
  #   #       #<Pet id: 6, name: "Boss",  person_id: 1>
  #   #    ]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1006
  def records; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def references(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def references!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def references_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def references_values=(arg); end

  # Reloads the collection from the database. Returns +self+.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets # fetches pets from the database
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  #   person.pets # uses the pets cache
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  #   person.pets.reload # fetches pets from the database
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1067
  def reload; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reorder(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reorder!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reordering_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reordering_value=(arg); end

  # Replaces this collection with +other_array+. This will perform a diff
  # and delete/add only records that have changed.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [#<Pet id: 1, name: "Gorby", group: "cats", person_id: 1>]
  #
  #   other_pets = [Pet.new(name: 'Puff', group: 'celebrities')]
  #
  #   person.pets.replace(other_pets)
  #
  #   person.pets
  #   # => [#<Pet id: 2, name: "Puff", group: "celebrities", person_id: 1>]
  #
  # If the supplied array has an incorrect association type, it raises
  # an <tt>ActiveRecord::AssociationTypeMismatch</tt> error:
  #
  #   person.pets.replace(["doo", "ggie", "gaga"])
  #   # => ActiveRecord::AssociationTypeMismatch: Pet expected, got String
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#389
  def replace(other_array); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reselect(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reselect!(*_arg0, **_arg1, &_arg2); end

  # Unloads the association. Returns +self+.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets # fetches pets from the database
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  #   person.pets # uses the pets cache
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  #   person.pets.reset # clears the pets cache
  #
  #   person.pets  # fetches pets from the database
  #   # => [#<Pet id: 1, name: "Snoop", group: "dogs", person_id: 1>]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1088
  def reset; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1094
  def reset_scope; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reverse_order(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reverse_order!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reverse_order_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def reverse_order_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def rewhere(*_arg0, **_arg1, &_arg2); end

  # Returns a <tt>Relation</tt> object for the records in this association
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#934
  def scope; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def scoping(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def select_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def select_values=(arg); end

  # Returns the size of the collection. If the collection hasn't been loaded,
  # it executes a <tt>SELECT COUNT(*)</tt> query. Else it calls <tt>collection.size</tt>.
  #
  # If the collection has been already loaded +size+ and +length+ are
  # equivalent. If not and you are going to need the records anyway
  # +length+ will take one less query. Otherwise +size+ is more efficient.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets.size # => 3
  #   # executes something like SELECT COUNT(*) FROM "pets" WHERE "pets"."person_id" = 1
  #
  #   person.pets # This will execute a SELECT * FROM query
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.size # => 3
  #   # Because the collection is already loaded, this will behave like
  #   # collection.size and no SQL count query is executed.
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#780
  def size; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def skip_preloading!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def skip_query_cache!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def skip_query_cache_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def skip_query_cache_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def spawn(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def strict_loading(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def strict_loading!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def strict_loading_value(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def strict_loading_value=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def structurally_compatible?(*_arg0, **_arg1, &_arg2); end

  # Gives a record (or N records if a parameter is supplied) from the collection
  # using the same rules as <tt>ActiveRecord::Base.take</tt>.
  #
  #   class Person < ActiveRecord::Base
  #     has_many :pets
  #   end
  #
  #   person.pets
  #   # => [
  #   #       #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #       #<Pet id: 2, name: "Spook", person_id: 1>,
  #   #       #<Pet id: 3, name: "Choo-Choo", person_id: 1>
  #   #    ]
  #
  #   person.pets.take # => #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>
  #
  #   person.pets.take(2)
  #   # => [
  #   #      #<Pet id: 1, name: "Fancy-Fancy", person_id: 1>,
  #   #      #<Pet id: 2, name: "Spook", person_id: 1>
  #   #    ]
  #
  #   another_person_without.pets         # => []
  #   another_person_without.pets.take    # => nil
  #   another_person_without.pets.take(2) # => []
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#287
  def take(limit = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#38
  def target; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def uniq!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def unscope(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def unscope!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def unscope_values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def unscope_values=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def upsert(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def upsert_all(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def values(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def where(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def where!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def where_clause(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def where_clause=(arg); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1114
  def without(*_arg0, **_arg1, &_arg2); end

  private

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1135
  def exec_queries; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1131
  def find_from_target?; end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1122
  def find_nth_from_last(index); end

  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1117
  def find_nth_with_limit(index, limit); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/collection_proxy.rb#1127
  def null_scope?; end
end

class ActiveRecord::Associations::DisableJoinsAssociationScope < ::ActiveRecord::Associations::AssociationScope
  # source://activerecord//lib/active_record/associations/disable_joins_association_scope.rb#6
  def scope(association); end

  private

  # source://activerecord//lib/active_record/associations/disable_joins_association_scope.rb#33
  def add_constraints(reflection, key, join_ids, owner, ordered); end

  # source://activerecord//lib/active_record/associations/disable_joins_association_scope.rb#18
  def last_scope_chain(reverse_chain, owner); end
end

module ActiveRecord::Associations::ForeignAssociation
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/foreign_association.rb#5
  def foreign_key_present?; end

  # source://activerecord//lib/active_record/associations/foreign_association.rb#13
  def nullified_owner_attributes; end

  private

  # Sets the owner attributes on the given record
  #
  # source://activerecord//lib/active_record/associations/foreign_association.rb#22
  def set_owner_attributes(record); end
end

# = Active Record Has Many Association
# This is the proxy that handles a has many association.
#
# If the association has a <tt>:through</tt> option further specialization
# is provided by its child HasManyThroughAssociation.
class ActiveRecord::Associations::HasManyAssociation < ::ActiveRecord::Associations::CollectionAssociation
  include ::ActiveRecord::Associations::ForeignAssociation

  # source://activerecord//lib/active_record/associations/has_many_association.rb#13
  def handle_dependency; end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#56
  def insert_record(record, validate = T.unsafe(nil), raise = T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/associations/has_many_association.rb#136
  def _create_record(attributes, *_arg1); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#132
  def concat_records(records, *_arg1); end

  # Returns the number of records in this collection.
  #
  # If the association has a counter cache it gets that value. Otherwise
  # it will attempt to do a count via SQL, bounded to <tt>:limit</tt> if
  # there's one. Some configuration options like :group make it impossible
  # to do an SQL count, in those cases the array count will be used.
  #
  # That does not depend on whether the collection has already been loaded
  # or not. The +size+ method is the one that takes the loaded flag into
  # account and delegates to +count_records+ if needed.
  #
  # If the collection is empty the target is set to an empty array and
  # the loaded flag is set to true as well.
  #
  # source://activerecord//lib/active_record/associations/has_many_association.rb#75
  def count_records; end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#107
  def delete_count(method, scope); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#115
  def delete_or_nullify_all_records(method); end

  # Deletes the records according to the <tt>:dependent</tt> option.
  #
  # source://activerecord//lib/active_record/associations/has_many_association.rb#122
  def delete_records(records, method); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#151
  def difference(a, b); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#155
  def intersection(a, b); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#93
  def update_counter(difference, reflection = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#144
  def update_counter_if_success(saved_successfully, difference); end

  # source://activerecord//lib/active_record/associations/has_many_association.rb#99
  def update_counter_in_memory(difference, reflection = T.unsafe(nil)); end
end

# = Active Record Has Many Through Association
class ActiveRecord::Associations::HasManyThroughAssociation < ::ActiveRecord::Associations::HasManyAssociation
  include ::ActiveRecord::Associations::ThroughAssociation

  # @return [HasManyThroughAssociation] a new instance of HasManyThroughAssociation
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#9
  def initialize(owner, reflection); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#14
  def concat(*records); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#24
  def insert_record(record, validate = T.unsafe(nil), raise = T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#86
  def build_record(attributes); end

  # The through record (built with build_record) is temporarily cached
  # so that it may be reused if insert_record is subsequently called.
  #
  # However, after insert_record has been called, the cache is cleared in
  # order to allow multiple instances of the same record in an association.
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#56
  def build_through_record(record); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#37
  def concat_records(records); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#126
  def delete_or_nullify_all_records(method); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#130
  def delete_records(records, method); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#199
  def delete_through_records(records); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#167
  def difference(a, b); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#183
  def distribution(array); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#215
  def find_target; end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#173
  def intersection(a, b); end

  # NOTE - not sure that we can actually cope with inverses here
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#222
  def invertible_for?(record); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#179
  def mark_occurrence(distribution, record); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#106
  def remove_records(existing_records, records, method); end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#77
  def save_through_record(record); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#111
  def target_reflection_has_associated_record?; end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#189
  def through_records_for(record); end

  # Returns the value of attribute through_scope.
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#68
  def through_scope; end

  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#70
  def through_scope_attributes; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/has_many_through_association.rb#115
  def update_through_counter?(method); end
end

# = Active Record Has One Association
class ActiveRecord::Associations::HasOneAssociation < ::ActiveRecord::Associations::SingularAssociation
  include ::ActiveRecord::Associations::ForeignAssociation

  # source://activerecord//lib/active_record/associations/has_one_association.rb#26
  def delete(method = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/has_one_association.rb#9
  def handle_dependency; end

  private

  # source://activerecord//lib/active_record/associations/has_one_association.rb#126
  def _create_record(attributes, raise_error = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/has_one_association.rb#114
  def nullify_owner_attributes(record); end

  # source://activerecord//lib/active_record/associations/has_one_association.rb#90
  def remove_target!(method); end

  # source://activerecord//lib/active_record/associations/has_one_association.rb#54
  def replace(record, save = T.unsafe(nil)); end

  # The reason that the save param for replace is false, if for create (not just build),
  # is because the setting of the foreign keys is actually handled by the scoping when
  # the record is instantiated, and so they are set straight away and do not need to be
  # updated within replace.
  #
  # source://activerecord//lib/active_record/associations/has_one_association.rb#86
  def set_new_record(record); end

  # source://activerecord//lib/active_record/associations/has_one_association.rb#118
  def transaction_if(value, &block); end
end

# = Active Record Has One Through Association
class ActiveRecord::Associations::HasOneThroughAssociation < ::ActiveRecord::Associations::HasOneAssociation
  include ::ActiveRecord::Associations::ThroughAssociation

  private

  # source://activerecord//lib/active_record/associations/has_one_through_association.rb#15
  def create_through_record(record, save); end

  # source://activerecord//lib/active_record/associations/has_one_through_association.rb#10
  def replace(record, save = T.unsafe(nil)); end
end

class ActiveRecord::Associations::JoinDependency
  include ::Polyamorous::JoinDependencyExtensions
  extend ::ActiveSupport::Autoload
  extend ::Polyamorous::JoinDependencyExtensions::ClassMethods

  # @return [JoinDependency] a new instance of JoinDependency
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#71
  def initialize(base, table, associations, join_type); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#153
  def apply_column_aliases(relation); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#77
  def base_klass; end

  # source://ransack/3.2.1/lib/polyamorous/activerecord_6.1_ruby_2/join_dependency.rb#4
  def build(associations, base_klass); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#158
  def each(&block); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#105
  def instantiate(result_set, strict_loading_value, &block); end

  # source://ransack/3.2.1/lib/polyamorous/activerecord_6.1_ruby_2/join_dependency.rb#30
  def join_constraints(joins_to_add, alias_tracker, references); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#81
  def reflections; end

  protected

  # Returns the value of attribute join_root.
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#163
  def join_root; end

  # Returns the value of attribute join_type.
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#163
  def join_type; end

  private

  # Returns the value of attribute alias_tracker.
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#166
  def alias_tracker; end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#168
  def aliases; end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#242
  def construct(ar_parent, parent, row, seen, model_cache, strict_loading_value); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#278
  def construct_model(record, node, row, model_cache, id, strict_loading_value); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#223
  def find_reflection(klass, name); end

  # Returns the value of attribute join_root_alias.
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#166
  def join_root_alias; end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#190
  def make_constraints(parent, child, join_type); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#184
  def make_join_constraints(join_root, join_type); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#214
  def walk(left, right, join_type); end

  class << self
    # source://activerecord//lib/active_record/associations/join_dependency.rb#47
    def make_tree(associations); end

    # source://ransack/3.2.1/lib/polyamorous/activerecord_6.1_ruby_2/join_dependency.rb#71
    def walk_tree(associations, hash); end
  end
end

class ActiveRecord::Associations::JoinDependency::Aliases
  # @return [Aliases] a new instance of Aliases
  #
  # source://activerecord//lib/active_record/associations/join_dependency.rb#14
  def initialize(tables); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#34
  def column_alias(node, column); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#30
  def column_aliases(node); end

  # source://activerecord//lib/active_record/associations/join_dependency.rb#26
  def columns; end
end

class ActiveRecord::Associations::JoinDependency::Aliases::Column < ::Struct
  # Returns the value of attribute alias
  #
  # @return [Object] the current value of alias
  def alias; end

  # Sets the attribute alias
  #
  # @param value [Object] the value to set the attribute alias to.
  # @return [Object] the newly set value
  def alias=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::Associations::JoinDependency::Aliases::Table < ::Struct
  # source://activerecord//lib/active_record/associations/join_dependency.rb#39
  def column_aliases; end

  # Returns the value of attribute columns
  #
  # @return [Object] the current value of columns
  def columns; end

  # Sets the attribute columns
  #
  # @param value [Object] the value to set the attribute columns to.
  # @return [Object] the newly set value
  def columns=(_); end

  # Returns the value of attribute node
  #
  # @return [Object] the current value of node
  def node; end

  # Sets the attribute node
  #
  # @param value [Object] the value to set the attribute node to.
  # @return [Object] the newly set value
  def node=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::Associations::JoinDependency::JoinAssociation < ::ActiveRecord::Associations::JoinDependency::JoinPart
  include ::Polyamorous::SwappingReflectionClass
  include ::Polyamorous::JoinAssociationExtensions

  # @return [JoinAssociation] a new instance of JoinAssociation
  #
  # source://ransack/3.2.1/lib/polyamorous/activerecord_6.1_ruby_2/join_association.rb#8
  def initialize(reflection, children, polymorphic_class = T.unsafe(nil), join_type = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#24
  def join_constraints(foreign_table, foreign_klass, join_type, alias_tracker); end

  # source://ransack/3.2.1/lib/polyamorous/activerecord_6.1_ruby_2/join_association.rb#5
  def join_type; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#19
  def match?(other); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#78
  def readonly?; end

  # Returns the value of attribute reflection.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#10
  def reflection; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#84
  def strict_loading?; end

  # Returns the value of attribute table.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#11
  def table; end

  # Sets the attribute table
  #
  # @param value the value to set the attribute table to.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#11
  def table=(_arg0); end

  # Returns the value of attribute tables.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#10
  def tables; end

  private

  # source://activerecord//lib/active_record/associations/join_dependency/join_association.rb#91
  def append_constraints(join, constraints); end
end

class ActiveRecord::Associations::JoinDependency::JoinBase < ::ActiveRecord::Associations::JoinDependency::JoinPart
  # @return [JoinBase] a new instance of JoinBase
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_base.rb#11
  def initialize(base_klass, table, children); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_base.rb#16
  def match?(other); end

  # Returns the value of attribute table.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_base.rb#9
  def table; end
end

# A JoinPart represents a part of a JoinDependency. It is inherited
# by JoinBase and JoinAssociation. A JoinBase represents the Active Record which
# everything else is being joined onto. A JoinAssociation represents an association which
# is joining to the base. A JoinAssociation may result in more than one actual join
# operations (for example a has_and_belongs_to_many JoinAssociation would result in
# two; one for the join table and one for the target table).
class ActiveRecord::Associations::JoinDependency::JoinPart
  include ::Enumerable

  # @return [JoinPart] a new instance of JoinPart
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#22
  def initialize(base_klass, children); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#20
  def attribute_types(*_arg0, **_arg1, &_arg2); end

  # The Active Record class which this join part is associated 'about'; for a JoinBase
  # this is the actual base model, for a JoinAssociation this is the target model of the
  # association.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#18
  def base_klass; end

  # The Active Record class which this join part is associated 'about'; for a JoinBase
  # this is the actual base model, for a JoinAssociation this is the target model of the
  # association.
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#18
  def children; end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#20
  def column_names(*_arg0, **_arg1, &_arg2); end

  # @yield [_self]
  # @yieldparam _self [ActiveRecord::Associations::JoinDependency::JoinPart] the object that the method was called on
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#31
  def each(&block); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#36
  def each_children(&block); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#48
  def extract_record(row, column_names_with_alias); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#65
  def instantiate(row, aliases, column_types = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#27
  def match?(other); end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#20
  def primary_key(*_arg0, **_arg1, &_arg2); end

  # An Arel::Table for the active_record
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#44
  def table; end

  # source://activerecord//lib/active_record/associations/join_dependency/join_part.rb#20
  def table_name(*_arg0, **_arg1, &_arg2); end
end

# Implements the details of eager loading of Active Record associations.
#
# Suppose that you have the following two Active Record models:
#
#   class Author < ActiveRecord::Base
#     # columns: name, age
#     has_many :books
#   end
#
#   class Book < ActiveRecord::Base
#     # columns: title, sales, author_id
#   end
#
# When you load an author with all associated books Active Record will make
# multiple queries like this:
#
#   Author.includes(:books).where(name: ['bell hooks', 'Homer']).to_a
#
#   => SELECT `authors`.* FROM `authors` WHERE `name` IN ('bell hooks', 'Homer')
#   => SELECT `books`.* FROM `books` WHERE `author_id` IN (2, 5)
#
# Active Record saves the ids of the records from the first query to use in
# the second. Depending on the number of associations involved there can be
# arbitrarily many SQL queries made.
#
# However, if there is a WHERE clause that spans across tables Active
# Record will fall back to a slightly more resource-intensive single query:
#
#   Author.includes(:books).where(books: {title: 'Illiad'}).to_a
#   => SELECT `authors`.`id` AS t0_r0, `authors`.`name` AS t0_r1, `authors`.`age` AS t0_r2,
#             `books`.`id`   AS t1_r0, `books`.`title`  AS t1_r1, `books`.`sales` AS t1_r2
#      FROM `authors`
#      LEFT OUTER JOIN `books` ON `authors`.`id` =  `books`.`author_id`
#      WHERE `books`.`title` = 'Illiad'
#
# This could result in many rows that contain redundant data and it performs poorly at scale
# and is therefore only used when necessary.
class ActiveRecord::Associations::Preloader
  extend ::ActiveSupport::Autoload

  # Eager loads the named associations for the given Active Record record(s).
  #
  # In this description, 'association name' shall refer to the name passed
  # to an association creation method. For example, a model that specifies
  # <tt>belongs_to :author</tt>, <tt>has_many :buyers</tt> has association
  # names +:author+ and +:buyers+.
  #
  # == Parameters
  # +records+ is an array of ActiveRecord::Base. This array needs not be flat,
  # i.e. +records+ itself may also contain arrays of records. In any case,
  # +preload_associations+ will preload all associations records by
  # flattening +records+.
  #
  # +associations+ specifies one or more associations that you want to
  # preload. It may be:
  # - a Symbol or a String which specifies a single association name. For
  #   example, specifying +:books+ allows this method to preload all books
  #   for an Author.
  # - an Array which specifies multiple association names. This array
  #   is processed recursively. For example, specifying <tt>[:avatar, :books]</tt>
  #   allows this method to preload an author's avatar as well as all of his
  #   books.
  # - a Hash which specifies multiple association names, as well as
  #   association names for the to-be-preloaded association objects. For
  #   example, specifying <tt>{ author: :avatar }</tt> will preload a
  #   book's author, as well as that author's avatar.
  #
  # +:associations+ has the same format as the +:include+ method in
  # <tt>ActiveRecord::QueryMethods</tt>. So +associations+ could look like this:
  #
  #   :books
  #   [ :books, :author ]
  #   { author: :avatar }
  #   [ :books, { author: :avatar } ]
  #
  # +available_records+ is an array of ActiveRecord::Base. The Preloader
  # will try to use the objects in this array to preload the requested
  # associations before querying the database. This can save database
  # queries by reusing in-memory objects. The optimization is only applied
  # to single associations (i.e. :belongs_to, :has_one) with no scopes.
  #
  # @return [Preloader] a new instance of Preloader
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#96
  def initialize(records:, associations:, scope: T.unsafe(nil), available_records: T.unsafe(nil), associate_by_default: T.unsafe(nil)); end

  # Returns the value of attribute associate_by_default.
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#54
  def associate_by_default; end

  # Returns the value of attribute associations.
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#54
  def associations; end

  # source://activerecord//lib/active_record/associations/preloader.rb#123
  def branches; end

  # source://activerecord//lib/active_record/associations/preloader.rb#117
  def call; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#113
  def empty?; end

  # source://activerecord//lib/active_record/associations/preloader.rb#127
  def loaders; end

  # Returns the value of attribute records.
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#54
  def records; end

  # Returns the value of attribute scope.
  #
  # source://activerecord//lib/active_record/associations/preloader.rb#54
  def scope; end
end

class ActiveRecord::Associations::Preloader::Association
  # @return [Association] a new instance of Association
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#87
  def initialize(klass, owners, reflection, preload_scope, reflection_scope, associate_by_default); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#202
  def associate_records_from_unscoped(unscoped_records); end

  # The name of the key on the associated records
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#144
  def association_key_name; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#102
  def future_classes; end

  # Returns the value of attribute klass.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#85
  def klass; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#180
  def load_records(raw_records = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#159
  def loaded?(owner); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#148
  def loader_query; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#152
  def owners_by_key; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#137
  def preloaded_records; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#131
  def records_by_owner; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#118
  def run; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#114
  def run?; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#110
  def runnable_loaders; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#167
  def scope; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#171
  def set_inverse(record); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#98
  def table_name; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#163
  def target_for(owner); end

  private

  # source://activerecord//lib/active_record/associations/preloader/association.rb#229
  def associate_records_to_owner(owner, records); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#257
  def association_key_type; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#269
  def build_scope; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#285
  def cascade_strict_loading(scope); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#249
  def convert_key(key); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#241
  def key_conversion_required?; end

  # Returns the value of attribute model.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#222
  def model; end

  # The name of the key on the model which declares the association
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#225
  def owner_key_name; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#261
  def owner_key_type; end

  # Returns the value of attribute owners.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#222
  def owners; end

  # Returns the value of attribute preload_scope.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#222
  def preload_scope; end

  # Returns the value of attribute reflection.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#222
  def reflection; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#265
  def reflection_scope; end
end

class ActiveRecord::Associations::Preloader::Association::LoaderQuery
  # @return [LoaderQuery] a new instance of LoaderQuery
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#10
  def initialize(scope, association_key_name); end

  # Returns the value of attribute association_key_name.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#8
  def association_key_name; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#15
  def eql?(other); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#21
  def hash; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#38
  def load_records_for_keys(keys, &block); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#29
  def load_records_in_batch(loaders); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#25
  def records_for(loaders); end

  # Returns the value of attribute scope.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#8
  def scope; end
end

class ActiveRecord::Associations::Preloader::Association::LoaderRecords
  # @return [LoaderRecords] a new instance of LoaderRecords
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#44
  def initialize(loaders, loader_query); end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#53
  def records; end

  private

  # source://activerecord//lib/active_record/associations/preloader/association.rb#80
  def already_loaded_records; end

  # Returns the value of attribute already_loaded_records_by_key.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#58
  def already_loaded_records_by_key; end

  # Returns the value of attribute keys_to_load.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#58
  def keys_to_load; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#74
  def load_records; end

  # Returns the value of attribute loader_query.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#58
  def loader_query; end

  # Returns the value of attribute loaders.
  #
  # source://activerecord//lib/active_record/associations/preloader/association.rb#58
  def loaders; end

  # source://activerecord//lib/active_record/associations/preloader/association.rb#60
  def populate_keys_to_load_and_already_loaded_records; end
end

class ActiveRecord::Associations::Preloader::Batch
  # @return [Batch] a new instance of Batch
  #
  # source://activerecord//lib/active_record/associations/preloader/batch.rb#7
  def initialize(preloaders, available_records:); end

  # source://activerecord//lib/active_record/associations/preloader/batch.rb#12
  def call; end

  private

  # source://activerecord//lib/active_record/associations/preloader/batch.rb#40
  def group_and_load_similar(loaders); end

  # Returns the value of attribute loaders.
  #
  # source://activerecord//lib/active_record/associations/preloader/batch.rb#38
  def loaders; end
end

class ActiveRecord::Associations::Preloader::Branch
  # @return [Branch] a new instance of Branch
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#11
  def initialize(association:, children:, parent:, associate_by_default:, scope:); end

  # Returns the value of attribute associate_by_default.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#8
  def associate_by_default; end

  # Returns the value of attribute association.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#7
  def association; end

  # Returns the value of attribute children.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#7
  def children; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#66
  def done?; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#21
  def future_classes; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#74
  def grouped_records; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#25
  def immediate_future_classes; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#47
  def likely_reflections; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#112
  def loaders; end

  # Returns the value of attribute parent.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#7
  def parent; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#102
  def polymorphic?; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#62
  def preloaded_records; end

  # Sets the attribute preloaded_records
  #
  # @param value the value to set the attribute preloaded_records to.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#9
  def preloaded_records=(_arg0); end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#85
  def preloaders_for_reflection(reflection, reflection_records); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#54
  def root?; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#70
  def runnable_loaders; end

  # Returns the value of attribute scope.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#8
  def scope; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#58
  def source_records; end

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#37
  def target_classes; end

  private

  # source://activerecord//lib/active_record/associations/preloader/branch.rb#120
  def build_children(children); end

  # Returns a class containing the logic needed to load preload the data
  # and attach it to a relation. The class returned implements a `run` method
  # that accepts a preloader.
  #
  # source://activerecord//lib/active_record/associations/preloader/branch.rb#137
  def preloader_for(reflection); end
end

class ActiveRecord::Associations::Preloader::ThroughAssociation < ::ActiveRecord::Associations::Preloader::Association
  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#51
  def future_classes; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#7
  def preloaded_records; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#11
  def records_by_owner; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#41
  def runnable_loaders; end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#67
  def data_available?; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#76
  def middle_records; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#100
  def preload_index; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#72
  def source_preloaders; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#92
  def source_records_by_owner; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#88
  def source_reflection; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#80
  def through_preloaders; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#96
  def through_records_by_owner; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#84
  def through_reflection; end

  # source://activerecord//lib/active_record/associations/preloader/through_association.rb#106
  def through_scope; end
end

class ActiveRecord::Associations::SingularAssociation < ::ActiveRecord::Associations::Association
  # source://activerecord//lib/active_record/associations/singular_association.rb#22
  def build(attributes = T.unsafe(nil), &block); end

  # Implements the reload reader method, e.g. foo.reload_bar for
  # Foo.has_one :bar
  #
  # source://activerecord//lib/active_record/associations/singular_association.rb#30
  def force_reload_reader; end

  # Implements the reader method, e.g. foo.bar for Foo.has_one :bar
  #
  # source://activerecord//lib/active_record/associations/singular_association.rb#7
  def reader; end

  # Implements the writer method, e.g. foo.bar= for Foo.belongs_to :bar
  #
  # source://activerecord//lib/active_record/associations/singular_association.rb#18
  def writer(record); end

  private

  # @raise [RecordInvalid]
  #
  # source://activerecord//lib/active_record/associations/singular_association.rb#56
  def _create_record(attributes, raise_error = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/associations/singular_association.rb#40
  def find_target; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/associations/singular_association.rb#48
  def replace(record); end

  # source://activerecord//lib/active_record/associations/singular_association.rb#36
  def scope_for_create; end

  # source://activerecord//lib/active_record/associations/singular_association.rb#52
  def set_new_record(record); end
end

# = Active Record Through Association
module ActiveRecord::Associations::ThroughAssociation
  # source://activerecord//lib/active_record/associations/through_association.rb#7
  def source_reflection(*_arg0, **_arg1, &_arg2); end

  private

  # source://activerecord//lib/active_record/associations/through_association.rb#109
  def build_record(attributes); end

  # Construct attributes for :through pointing to owner and associate. This is used by the
  # methods which create and delete records on the association.
  #
  # We only support indirectly modifying through associations which have a belongs_to source.
  # This is the "has_many :tags, through: :taggings" situation, where the join model
  # typically has a belongs_to on both side. In other words, associations which could also
  # be represented as has_and_belongs_to_many associations.
  #
  # We do not support creating/deleting records on the association where the source has
  # some other type, because this opens up a whole can of worms, and in basically any
  # situation it is more natural for the user to just create or modify their join records
  # directly as required.
  #
  # source://activerecord//lib/active_record/associations/through_association.rb#53
  def construct_join_attributes(*records); end

  # source://activerecord//lib/active_record/associations/through_association.rb#89
  def ensure_mutable; end

  # source://activerecord//lib/active_record/associations/through_association.rb#99
  def ensure_not_nested; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/associations/through_association.rb#85
  def foreign_key_present?; end

  # Note: this does not capture all cases, for example it would be impractical
  # to try to properly support stale-checking for nested associations.
  #
  # source://activerecord//lib/active_record/associations/through_association.rb#79
  def stale_state; end

  # We merge in these scopes for two reasons:
  #
  #   1. To get the default_scope conditions for any of the other reflections in the chain
  #   2. To get the type conditions for any STI models in the chain
  #
  # source://activerecord//lib/active_record/associations/through_association.rb#30
  def target_scope; end

  # source://activerecord//lib/active_record/associations/through_association.rb#22
  def through_association; end

  # source://activerecord//lib/active_record/associations/through_association.rb#10
  def through_reflection; end
end

class ActiveRecord::AsynchronousQueriesTracker
  # @return [AsynchronousQueriesTracker] a new instance of AsynchronousQueriesTracker
  #
  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#46
  def initialize; end

  # Returns the value of attribute current_session.
  #
  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#44
  def current_session; end

  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#55
  def finalize_session; end

  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#50
  def start_session; end

  class << self
    # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#39
    def complete(asynchronous_queries_tracker); end

    # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#31
    def install_executor_hooks(executor = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#35
    def run; end
  end
end

module ActiveRecord::AsynchronousQueriesTracker::NullSession
  class << self
    # @return [Boolean]
    #
    # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#7
    def active?; end

    # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#11
    def finalize; end
  end
end

class ActiveRecord::AsynchronousQueriesTracker::Session
  # @return [Session] a new instance of Session
  #
  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#17
  def initialize; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#21
  def active?; end

  # source://activerecord//lib/active_record/asynchronous_queries_tracker.rb#25
  def finalize; end
end

# AsynchronousQueryInsideTransactionError will be raised when attempting
# to perform an asynchronous query from inside a transaction
class ActiveRecord::AsynchronousQueryInsideTransactionError < ::ActiveRecord::ActiveRecordError; end

module ActiveRecord::AttributeAssignment
  include ::ActiveModel::ForbiddenAttributesProtection
  include ::ActiveModel::AttributeAssignment

  private

  # source://activerecord//lib/active_record/attribute_assignment.rb#10
  def _assign_attributes(attributes); end

  # Instantiates objects for all attribute classes that needs more than one constructor parameter. This is done
  # by calling new on the column type or aggregation type (through composed_of) object with these parameters.
  # So having the pairs written_on(1) = "2004", written_on(2) = "6", written_on(3) = "24", will instantiate
  # written_on (a date type) with Date.new("2004", "6", "24"). You can also specify a typecast character in the
  # parentheses to have the parameters typecasted before they're used in the constructor. Use i for Integer and
  # f for Float. If all the values for a given attribute are empty, the attribute will be set to +nil+.
  #
  # source://activerecord//lib/active_record/attribute_assignment.rb#40
  def assign_multiparameter_attributes(pairs); end

  # Assign any deferred nested attributes after the base attributes have been set.
  #
  # source://activerecord//lib/active_record/attribute_assignment.rb#30
  def assign_nested_parameter_attributes(pairs); end

  # source://activerecord//lib/active_record/attribute_assignment.rb#46
  def execute_callstack_for_multiparameter_attributes(callstack); end

  # source://activerecord//lib/active_record/attribute_assignment.rb#64
  def extract_callstack_for_multiparameter_attributes(pairs); end

  # source://activerecord//lib/active_record/attribute_assignment.rb#82
  def find_parameter_position(multiparameter_name); end

  # source://activerecord//lib/active_record/attribute_assignment.rb#78
  def type_cast_attribute_value(multiparameter_name, value); end
end

# Raised when an error occurred while doing a mass assignment to an attribute through the
# {ActiveRecord::Base#attributes=}[rdoc-ref:AttributeAssignment#attributes=] method.
# The exception has an +attribute+ property that is the name of the offending attribute.
class ActiveRecord::AttributeAssignmentError < ::ActiveRecord::ActiveRecordError
  # @return [AttributeAssignmentError] a new instance of AttributeAssignmentError
  #
  # source://activerecord//lib/active_record/errors.rb#355
  def initialize(message = T.unsafe(nil), exception = T.unsafe(nil), attribute = T.unsafe(nil)); end

  # Returns the value of attribute attribute.
  #
  # source://activerecord//lib/active_record/errors.rb#353
  def attribute; end

  # Returns the value of attribute exception.
  #
  # source://activerecord//lib/active_record/errors.rb#353
  def exception; end
end

# = Active Record Attribute Methods
module ActiveRecord::AttributeMethods
  extend ::ActiveSupport::Concern
  extend ::ActiveSupport::Autoload
  include GeneratedInstanceMethods
  include ::ActiveModel::AttributeMethods
  include ::ActiveRecord::AttributeMethods::Read
  include ::ActiveRecord::AttributeMethods::Write
  include ::ActiveRecord::AttributeMethods::BeforeTypeCast
  include ::ActiveRecord::AttributeMethods::Query
  include ::ActiveRecord::AttributeMethods::PrimaryKey
  include ::ActiveRecord::AttributeMethods::TimeZoneConversion
  include ::ActiveModel::Dirty
  include ::ActiveRecord::AttributeMethods::Dirty
  include ::ActiveRecord::AttributeMethods::Serialization

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeMethods::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Read::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Write::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::PrimaryKey::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::TimeZoneConversion::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Dirty::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Serialization::ClassMethods

  # Returns the value of the attribute identified by <tt>attr_name</tt> after it has been typecast (for example,
  # "2004-12-12" in a date column is cast to a date object, like Date.new(2004, 12, 12)). It raises
  # <tt>ActiveModel::MissingAttributeError</tt> if the identified attribute is missing.
  #
  # Note: +:id+ is always present.
  #
  #   class Person < ActiveRecord::Base
  #     belongs_to :organization
  #   end
  #
  #   person = Person.new(name: 'Francesco', age: '22')
  #   person[:name] # => "Francesco"
  #   person[:age]  # => 22
  #
  #   person = Person.select('id').first
  #   person[:name]            # => ActiveModel::MissingAttributeError: missing attribute: name
  #   person[:organization_id] # => ActiveModel::MissingAttributeError: missing attribute: organization_id
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#329
  def [](attr_name); end

  # Updates the attribute identified by <tt>attr_name</tt> with the specified +value+.
  # (Alias for the protected #write_attribute method).
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   person = Person.new
  #   person[:age] = '22'
  #   person[:age] # => 22
  #   person[:age].class # => Integer
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#343
  def []=(attr_name, value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#240
  def _has_attribute?(attr_name); end

  # Returns the name of all database fields which have been read from this
  # model. This can be useful in development mode to determine which fields
  # need to be selected. For performance critical pages, selecting only the
  # required fields can be an easy performance win (assuming you aren't using
  # all of the fields on the model).
  #
  # For example:
  #
  #   class PostsController < ActionController::Base
  #     after_action :print_accessed_fields, only: :index
  #
  #     def index
  #       @posts = Post.all
  #     end
  #
  #     private
  #
  #     def print_accessed_fields
  #       p @posts.first.accessed_fields
  #     end
  #   end
  #
  # Which allows you to quickly change your code to:
  #
  #   class PostsController < ActionController::Base
  #     def index
  #       @posts = Post.select(:id, :title, :author_id, :updated_at)
  #     end
  #   end
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#376
  def accessed_fields; end

  # Returns an <tt>#inspect</tt>-like string for the value of the
  # attribute +attr_name+. String attributes are truncated up to 50
  # characters. Other attributes return the value of <tt>#inspect</tt>
  # without modification.
  #
  #   person = Person.create!(name: 'David Heinemeier Hansson ' * 3)
  #
  #   person.attribute_for_inspect(:name)
  #   # => "\"David Heinemeier Hansson David Heinemeier Hansson ...\""
  #
  #   person.attribute_for_inspect(:created_at)
  #   # => "\"2012-10-22 00:15:07.000000000 +0000\""
  #
  #   person.attribute_for_inspect(:tag_ids)
  #   # => "[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]"
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#283
  def attribute_for_inspect(attr_name); end

  # Returns an array of names for the attributes available on this object.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   person = Person.new
  #   person.attribute_names
  #   # => ["id", "created_at", "updated_at", "name", "age"]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#252
  def attribute_names; end

  # Returns +true+ if the specified +attribute+ has been set by the user or by a
  # database load and is neither +nil+ nor <tt>empty?</tt> (the latter only applies
  # to objects that respond to <tt>empty?</tt>, most notably Strings). Otherwise, +false+.
  # Note that it always returns +true+ with boolean attributes.
  #
  #   class Task < ActiveRecord::Base
  #   end
  #
  #   task = Task.new(title: '', is_done: false)
  #   task.attribute_present?(:title)   # => false
  #   task.attribute_present?(:is_done) # => true
  #   task.title = 'Buy milk'
  #   task.is_done = true
  #   task.attribute_present?(:title)   # => true
  #   task.attribute_present?(:is_done) # => true
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#305
  def attribute_present?(attr_name); end

  # Returns a hash of all the attributes with their names as keys and the values of the attributes as values.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   person = Person.create(name: 'Francesco', age: 22)
  #   person.attributes
  #   # => {"id"=>3, "created_at"=>Sun, 21 Oct 2012 04:53:04, "updated_at"=>Sun, 21 Oct 2012 04:53:04, "name"=>"Francesco", "age"=>22}
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#264
  def attributes; end

  # Returns +true+ if the given attribute is in the attributes hash, otherwise +false+.
  #
  #   class Person < ActiveRecord::Base
  #     alias_attribute :new_name, :name
  #   end
  #
  #   person = Person.new
  #   person.has_attribute?(:name)     # => true
  #   person.has_attribute?(:new_name) # => true
  #   person.has_attribute?('age')     # => true
  #   person.has_attribute?(:nothing)  # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#234
  def has_attribute?(attr_name); end

  # A Person object with a name attribute can ask <tt>person.respond_to?(:name)</tt>,
  # <tt>person.respond_to?(:name=)</tt>, and <tt>person.respond_to?(:name?)</tt>
  # which will all return +true+. It also defines the attribute methods if they have
  # not been generated.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   person = Person.new
  #   person.respond_to?(:name)    # => true
  #   person.respond_to?(:name=)   # => true
  #   person.respond_to?(:name?)   # => true
  #   person.respond_to?('age')    # => true
  #   person.respond_to?('age=')   # => true
  #   person.respond_to?('age?')   # => true
  #   person.respond_to?(:nothing) # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#207
  def respond_to?(name, include_private = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#381
  def attribute_method?(attr_name); end

  # Filters out the virtual columns and also primary keys, from the attribute names, when the primary
  # key is to be generated (e.g. the id attribute has no value).
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#401
  def attributes_for_create(attribute_names); end

  # Filters the primary keys, readonly attributes and virtual columns from the attribute names.
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#391
  def attributes_for_update(attribute_names); end

  # source://activerecord//lib/active_record/attribute_methods.rb#386
  def attributes_with_values(attribute_names); end

  # source://activerecord//lib/active_record/attribute_methods.rb#409
  def format_for_inspect(name, value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#425
  def pk_attribute?(name); end

  class << self
    # source://activerecord//lib/active_record/attribute_methods.rb#31
    def dangerous_attribute_methods; end
  end

  module GeneratedClassMethods
    def attribute_aliases; end
    def attribute_aliases=(value); end
    def attribute_aliases?; end
    def attribute_method_matchers; end
    def attribute_method_matchers=(value); end
    def attribute_method_matchers?; end
    def partial_inserts; end
    def partial_inserts=(value); end
    def partial_inserts?; end
    def partial_updates; end
    def partial_updates=(value); end
    def partial_updates?; end
    def skip_time_zone_conversion_for_attributes; end
    def skip_time_zone_conversion_for_attributes=(value); end
    def skip_time_zone_conversion_for_attributes?; end
    def time_zone_aware_attributes; end
    def time_zone_aware_attributes=(value); end
    def time_zone_aware_attributes?; end
    def time_zone_aware_types; end
    def time_zone_aware_types=(value); end
    def time_zone_aware_types?; end
  end

  module GeneratedInstanceMethods
    def attribute_aliases; end
    def attribute_aliases?; end
    def attribute_method_matchers; end
    def attribute_method_matchers?; end
    def partial_inserts; end
    def partial_inserts?; end
    def partial_updates; end
    def partial_updates?; end
    def skip_time_zone_conversion_for_attributes; end
    def skip_time_zone_conversion_for_attributes?; end
    def time_zone_aware_attributes; end
    def time_zone_aware_attributes?; end
    def time_zone_aware_types; end
    def time_zone_aware_types?; end
  end
end

# = Active Record Attribute Methods Before Type Cast
#
# ActiveRecord::AttributeMethods::BeforeTypeCast provides a way to
# read the value of the attributes before typecasting and deserialization.
#
#   class Task < ActiveRecord::Base
#   end
#
#   task = Task.new(id: '1', completed_on: '2012-10-21')
#   task.id           # => 1
#   task.completed_on # => Sun, 21 Oct 2012
#
#   task.attributes_before_type_cast
#   # => {"id"=>"1", "completed_on"=>"2012-10-21", ... }
#   task.read_attribute_before_type_cast('id')           # => "1"
#   task.read_attribute_before_type_cast('completed_on') # => "2012-10-21"
#
# In addition to #read_attribute_before_type_cast and #attributes_before_type_cast,
# it declares a method for all attributes with the <tt>*_before_type_cast</tt>
# suffix.
#
#   task.id_before_type_cast           # => "1"
#   task.completed_on_before_type_cast # => "2012-10-21"
module ActiveRecord::AttributeMethods::BeforeTypeCast
  extend ::ActiveSupport::Concern

  # Returns a hash of attributes before typecasting and deserialization.
  #
  #   class Task < ActiveRecord::Base
  #   end
  #
  #   task = Task.new(title: nil, is_done: true, completed_on: '2012-10-21')
  #   task.attributes
  #   # => {"id"=>nil, "title"=>nil, "is_done"=>true, "completed_on"=>Sun, 21 Oct 2012, "created_at"=>nil, "updated_at"=>nil}
  #   task.attributes_before_type_cast
  #   # => {"id"=>nil, "title"=>nil, "is_done"=>true, "completed_on"=>"2012-10-21", "created_at"=>nil, "updated_at"=>nil}
  #
  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#65
  def attributes_before_type_cast; end

  # Returns a hash of attributes for assignment to the database.
  #
  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#70
  def attributes_for_database; end

  # Returns the value of the attribute identified by +attr_name+ before
  # typecasting and deserialization.
  #
  #   class Task < ActiveRecord::Base
  #   end
  #
  #   task = Task.new(id: '1', completed_on: '2012-10-21')
  #   task.read_attribute('id')                            # => 1
  #   task.read_attribute_before_type_cast('id')           # => '1'
  #   task.read_attribute('completed_on')                  # => Sun, 21 Oct 2012
  #   task.read_attribute_before_type_cast('completed_on') # => "2012-10-21"
  #   task.read_attribute_before_type_cast(:completed_on)  # => "2012-10-21"
  #
  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#48
  def read_attribute_before_type_cast(attr_name); end

  private

  # Dispatch target for <tt>*_before_type_cast</tt> attribute methods.
  #
  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#76
  def attribute_before_type_cast(attr_name); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#84
  def attribute_came_from_user?(attr_name); end

  # source://activerecord//lib/active_record/attribute_methods/before_type_cast.rb#80
  def attribute_for_database(attr_name); end
end

module ActiveRecord::AttributeMethods::ClassMethods
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#186
  def _has_attribute?(attr_name); end

  # Returns +true+ if +attribute+ is an attribute method and table exists,
  # +false+ otherwise.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   Person.attribute_method?('name')   # => true
  #   Person.attribute_method?(:age=)    # => true
  #   Person.attribute_method?(:nothing) # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#150
  def attribute_method?(attribute); end

  # Returns an array of column names as strings if it's not an abstract class and
  # table exists. Otherwise it returns an empty array.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   Person.attribute_names
  #   # => ["id", "created_at", "updated_at", "name", "age"]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#162
  def attribute_names; end

  # A method name is 'dangerous' if it is already (re)defined by Active Record, but
  # not by any ancestors. (So 'puts' is not dangerous but 'save' is.)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#109
  def dangerous_attribute_method?(name); end

  # A class method is 'dangerous' if it is already (re)defined by Active Record, but
  # not by any ancestors. (So 'puts' is not dangerous but 'new' is.)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#127
  def dangerous_class_method?(method_name); end

  # Generates all the attribute related methods for columns in the database
  # accessors, mutators and query methods.
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#58
  def define_attribute_methods; end

  # Returns true if the given attribute exists, otherwise false.
  #
  #   class Person < ActiveRecord::Base
  #     alias_attribute :new_name, :name
  #   end
  #
  #   Person.has_attribute?('name')     # => true
  #   Person.has_attribute?('new_name') # => true
  #   Person.has_attribute?(:age)       # => true
  #   Person.has_attribute?(:nothing)   # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#180
  def has_attribute?(attr_name); end

  # source://activerecord//lib/active_record/attribute_methods.rb#42
  def inherited(child_class); end

  # source://activerecord//lib/active_record/attribute_methods.rb#47
  def initialize_generated_modules; end

  # Raises an ActiveRecord::DangerousAttributeError exception when an
  # \Active \Record method is defined in the model, otherwise +false+.
  #
  #   class Person < ActiveRecord::Base
  #     def save
  #       'already defined by Active Record'
  #     end
  #   end
  #
  #   Person.instance_method_already_implemented?(:save)
  #   # => ActiveRecord::DangerousAttributeError: save is defined by Active Record. Check to make sure that you don't have an attribute or method with the same name.
  #
  #   Person.instance_method_already_implemented?(:name)
  #   # => false
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#91
  def instance_method_already_implemented?(method_name); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods.rb#113
  def method_defined_within?(name, klass, superklass = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/attribute_methods.rb#70
  def undefine_attribute_methods; end
end

module ActiveRecord::AttributeMethods::Dirty
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveModel::AttributeMethods
  include ::ActiveModel::Dirty

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeMethods::ClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Dirty::ClassMethods

  # Returns the original value of an attribute before the last save.
  #
  # This method is useful in after callbacks to get the original value of an
  # attribute before the save that triggered the callbacks to run. It can be
  # invoked as +name_before_last_save+ instead of
  # <tt>attribute_before_last_save("name")</tt>.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#100
  def attribute_before_last_save(attr_name); end

  # Returns the change to an attribute that will be persisted during the
  # next save.
  #
  # This method is useful in validations and before callbacks, to see the
  # change to an attribute that will occur when the record is saved. It can
  # be invoked as +name_change_to_be_saved+ instead of
  # <tt>attribute_change_to_be_saved("name")</tt>.
  #
  # If the attribute will change, the result will be an array containing the
  # original value and the new value about to be saved.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#142
  def attribute_change_to_be_saved(attr_name); end

  # Returns the value of an attribute in the database, as opposed to the
  # in-memory value that will be persisted the next time the record is
  # saved.
  #
  # This method is useful in validations and before callbacks, to see the
  # original value of an attribute prior to any changes about to be
  # saved. It can be invoked as +name_in_database+ instead of
  # <tt>attribute_in_database("name")</tt>.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#154
  def attribute_in_database(attr_name); end

  # Returns a hash of the attributes that will change when the record is
  # next saved.
  #
  # The hash keys are the attribute names, and the hash values are the
  # original attribute values in the database (as opposed to the in-memory
  # values about to be saved).
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#181
  def attributes_in_database; end

  # Returns an array of the names of any attributes that will change when
  # the record is next saved.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#171
  def changed_attribute_names_to_save; end

  # Returns a hash containing all the changes that will be persisted during
  # the next save.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#165
  def changes_to_save; end

  # Will the next call to +save+ have any changes to persist?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#159
  def has_changes_to_save?; end

  # <tt>reload</tt> the record and clears changed attributes.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#57
  def reload(*_arg0); end

  # Returns the change to an attribute during the last save. If the
  # attribute was changed, the result will be an array containing the
  # original value and the saved value.
  #
  # This method is useful in after callbacks, to see the change in an
  # attribute during the save that triggered the callbacks to run. It can be
  # invoked as +saved_change_to_name+ instead of
  # <tt>saved_change_to_attribute("name")</tt>.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#90
  def saved_change_to_attribute(attr_name); end

  # Did this attribute change when we last saved?
  #
  # This method is useful in after callbacks to determine if an attribute
  # was changed during the save that triggered the callbacks to run. It can
  # be invoked as +saved_change_to_name?+ instead of
  # <tt>saved_change_to_attribute?("name")</tt>.
  #
  # ==== Options
  #
  # +from+ When passed, this method will return false unless the original
  # value is equal to the given option
  #
  # +to+ When passed, this method will return false unless the value was
  # changed to the given value
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#78
  def saved_change_to_attribute?(attr_name, **options); end

  # Returns a hash containing all the changes that were just saved.
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#110
  def saved_changes; end

  # Did the last call to +save+ have any changes to change?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#105
  def saved_changes?; end

  # Will this attribute change the next time we save?
  #
  # This method is useful in validations and before callbacks to determine
  # if the next call to +save+ will change a particular attribute. It can be
  # invoked as +will_save_change_to_name?+ instead of
  # <tt>will_save_change_to_attribute?("name")</tt>.
  #
  # ==== Options
  #
  # +from+ When passed, this method will return false unless the original
  # value is equal to the given option
  #
  # +to+ When passed, this method will return false unless the value will be
  # changed to the given value
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#128
  def will_save_change_to_attribute?(attr_name, **options); end

  private

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#221
  def _create_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#186
  def _touch_row(attribute_names, time); end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#215
  def _update_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#231
  def attribute_names_for_partial_inserts; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#227
  def attribute_names_for_partial_updates; end

  module GeneratedClassMethods
    def attribute_aliases; end
    def attribute_aliases=(value); end
    def attribute_aliases?; end
    def attribute_method_matchers; end
    def attribute_method_matchers=(value); end
    def attribute_method_matchers?; end
    def partial_inserts; end
    def partial_inserts=(value); end
    def partial_inserts?; end
    def partial_updates; end
    def partial_updates=(value); end
    def partial_updates?; end
  end

  module GeneratedInstanceMethods
    def attribute_aliases; end
    def attribute_aliases?; end
    def attribute_method_matchers; end
    def attribute_method_matchers?; end
    def partial_inserts; end
    def partial_inserts?; end
    def partial_updates; end
    def partial_updates?; end
  end
end

module ActiveRecord::AttributeMethods::Dirty::ClassMethods
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#31
  def partial_writes; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#47
  def partial_writes=(value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#39
  def partial_writes?; end
end

module ActiveRecord::AttributeMethods::PrimaryKey
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::AttributeMethods::PrimaryKey::ClassMethods

  # Returns the primary key column's value.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#18
  def id; end

  # Sets the primary key column's value.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#23
  def id=(value); end

  # Queries the primary key column's value.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#28
  def id?; end

  # Returns the primary key column's value before type cast.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#33
  def id_before_type_cast; end

  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#47
  def id_for_database; end

  # Returns the primary key column's value from the database.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#43
  def id_in_database; end

  # Returns the primary key column's previous value.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#38
  def id_was; end

  # Returns this record's primary key value wrapped in an array if one is
  # available.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#12
  def to_key; end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#52
  def attribute_method?(attr_name); end
end

module ActiveRecord::AttributeMethods::PrimaryKey::ClassMethods
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#63
  def dangerous_attribute_method?(method_name); end

  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#89
  def get_primary_key(base_name); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#59
  def instance_method_already_implemented?(method_name); end

  # Defines the primary key field -- can be overridden in subclasses.
  # Overwriting will negate any effect of the +primary_key_prefix_type+
  # setting, though.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#70
  def primary_key; end

  # Sets the name of the primary key column.
  #
  #   class Project < ActiveRecord::Base
  #     self.primary_key = 'sysid'
  #   end
  #
  # You can also define the #primary_key method yourself:
  #
  #   class Project < ActiveRecord::Base
  #     def self.primary_key
  #       'foo_' + super
  #     end
  #   end
  #
  #   Project.primary_key # => "foo_id"
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#119
  def primary_key=(value); end

  # Returns a quoted version of the primary key name, used to construct
  # SQL statements.
  #
  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#77
  def quoted_primary_key; end

  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#81
  def reset_primary_key; end

  private

  # source://activerecord//lib/active_record/attribute_methods/primary_key.rb#126
  def suppress_composite_primary_key(pk); end
end

# source://activerecord//lib/active_record/attribute_methods/primary_key.rb#57
ActiveRecord::AttributeMethods::PrimaryKey::ClassMethods::ID_ATTRIBUTE_METHODS = T.let(T.unsafe(nil), Set)

module ActiveRecord::AttributeMethods::Query
  extend ::ActiveSupport::Concern

  # source://activerecord//lib/active_record/attribute_methods/query.rb#12
  def query_attribute(attr_name); end

  private

  # source://activerecord//lib/active_record/attribute_methods/query.rb#12
  def attribute?(attr_name); end
end

# source://activerecord//lib/active_record/attribute_methods.rb#24
ActiveRecord::AttributeMethods::RESTRICTED_CLASS_METHODS = T.let(T.unsafe(nil), Array)

module ActiveRecord::AttributeMethods::Read
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Read::ClassMethods

  # This method exists to avoid the expensive primary_key check internally, without
  # breaking compatibility with the read_attribute API
  #
  # source://activerecord//lib/active_record/attribute_methods/read.rb#37
  def _read_attribute(attr_name, &block); end

  # Returns the value of the attribute identified by <tt>attr_name</tt> after
  # it has been typecast (for example, "2004-12-12" in a date column is cast
  # to a date object, like Date.new(2004, 12, 12)).
  #
  # source://activerecord//lib/active_record/attribute_methods/read.rb#27
  def read_attribute(attr_name, &block); end

  private

  # This method exists to avoid the expensive primary_key check internally, without
  # breaking compatibility with the read_attribute API
  #
  # source://activerecord//lib/active_record/attribute_methods/read.rb#37
  def attribute(attr_name, &block); end
end

module ActiveRecord::AttributeMethods::Read::ClassMethods
  private

  # source://activerecord//lib/active_record/attribute_methods/read.rb#10
  def define_method_attribute(name, owner:); end
end

module ActiveRecord::AttributeMethods::Serialization
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Serialization::ClassMethods
end

module ActiveRecord::AttributeMethods::Serialization::ClassMethods
  # If you have an attribute that needs to be saved to the database as a
  # serialized object, and retrieved by deserializing into the same object,
  # then specify the name of that attribute using this method and serialization
  # will be handled automatically.
  #
  # The serialization format may be YAML, JSON, or any custom format using a
  # custom coder class.
  #
  # Keep in mind that database adapters handle certain serialization tasks
  # for you. For instance: +json+ and +jsonb+ types in PostgreSQL will be
  # converted between JSON object/array syntax and Ruby +Hash+ or +Array+
  # objects transparently. There is no need to use #serialize in this
  # case.
  #
  # For more complex cases, such as conversion to or from your application
  # domain objects, consider using the ActiveRecord::Attributes API.
  #
  # ==== Parameters
  #
  # * +attr_name+ - The name of the attribute to serialize.
  # * +class_name_or_coder+ - Optional. May be one of the following:
  #   * <em>default</em> - The attribute value will be serialized as YAML.
  #     The attribute value must respond to +to_yaml+.
  #   * +Array+ - The attribute value will be serialized as YAML, but an
  #     empty +Array+ will be serialized as +NULL+. The attribute value
  #     must be an +Array+.
  #   * +Hash+ - The attribute value will be serialized as YAML, but an
  #     empty +Hash+ will be serialized as +NULL+. The attribute value
  #     must be a +Hash+.
  #   * +JSON+ - The attribute value will be serialized as JSON. The
  #     attribute value must respond to +to_json+.
  #   * <em>custom coder</em> - The attribute value will be serialized
  #     using the coder's <tt>dump(value)</tt> method, and will be
  #     deserialized using the coder's <tt>load(string)</tt> method. The
  #     +dump+ method may return +nil+ to serialize the value as +NULL+.
  #
  # ==== Options
  #
  # * +:default+ - The default value to use when no value is provided. If
  #   this option is not passed, the previous default value (if any) will
  #   be used. Otherwise, the default will be +nil+.
  #
  # ==== Examples
  #
  # ===== Serialize the +preferences+ attribute using YAML
  #
  #   class User < ActiveRecord::Base
  #     serialize :preferences
  #   end
  #
  # ===== Serialize the +preferences+ attribute using JSON
  #
  #   class User < ActiveRecord::Base
  #     serialize :preferences, JSON
  #   end
  #
  # ===== Serialize the +preferences+ +Hash+ using YAML
  #
  #   class User < ActiveRecord::Base
  #     serialize :preferences, Hash
  #   end
  #
  # ===== Serialize the +preferences+ attribute using a custom coder
  #
  #   class Rot13JSON
  #     def self.rot13(string)
  #       string.tr("a-zA-Z", "n-za-mN-ZA-M")
  #     end
  #
  #     # Serializes an attribute value to a string that will be stored in the database.
  #     def self.dump(value)
  #       rot13(ActiveSupport::JSON.dump(value))
  #     end
  #
  #     # Deserializes a string from the database to an attribute value.
  #     def self.load(string)
  #       ActiveSupport::JSON.load(rot13(string))
  #     end
  #   end
  #
  #   class User < ActiveRecord::Base
  #     serialize :preferences, Rot13JSON
  #   end
  #
  # source://activerecord//lib/active_record/attribute_methods/serialization.rb#103
  def serialize(attr_name, class_name_or_coder = T.unsafe(nil), **options); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/serialization.rb#126
  def type_incompatible_with_serialize?(type, class_name); end
end

class ActiveRecord::AttributeMethods::Serialization::ColumnNotSerializableError < ::StandardError
  # @return [ColumnNotSerializableError] a new instance of ColumnNotSerializableError
  #
  # source://activerecord//lib/active_record/attribute_methods/serialization.rb#9
  def initialize(name, type); end
end

module ActiveRecord::AttributeMethods::TimeZoneConversion
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::AttributeMethods::TimeZoneConversion::ClassMethods

  module GeneratedClassMethods
    def skip_time_zone_conversion_for_attributes; end
    def skip_time_zone_conversion_for_attributes=(value); end
    def skip_time_zone_conversion_for_attributes?; end
    def time_zone_aware_attributes; end
    def time_zone_aware_attributes=(value); end
    def time_zone_aware_attributes?; end
    def time_zone_aware_types; end
    def time_zone_aware_types=(value); end
    def time_zone_aware_types?; end
  end

  module GeneratedInstanceMethods
    def skip_time_zone_conversion_for_attributes; end
    def skip_time_zone_conversion_for_attributes?; end
    def time_zone_aware_attributes; end
    def time_zone_aware_attributes?; end
    def time_zone_aware_types; end
    def time_zone_aware_types?; end
  end
end

module ActiveRecord::AttributeMethods::TimeZoneConversion::ClassMethods
  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#76
  def define_attribute(name, cast_type, **_arg2); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#84
  def create_time_zone_conversion_attribute?(name, cast_type); end
end

class ActiveRecord::AttributeMethods::TimeZoneConversion::TimeZoneConverter
  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#17
  def cast(value); end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#13
  def deserialize(value); end

  private

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#38
  def convert_time_to_time_zone(value); end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#56
  def map_avoiding_infinite_recursion(value); end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#52
  def set_time_zone_without_conversion(value); end

  class << self
    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#9
    def new(subtype); end
  end
end

module ActiveRecord::AttributeMethods::Write
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::AttributeMethods::Write::ClassMethods

  # This method exists to avoid the expensive primary_key check internally, without
  # breaking compatibility with the write_attribute API
  #
  # source://activerecord//lib/active_record/attribute_methods/write.rb#41
  def _write_attribute(attr_name, value); end

  # Updates the attribute identified by <tt>attr_name</tt> with the
  # specified +value+. Empty strings for Integer and Float columns are
  # turned into +nil+.
  #
  # source://activerecord//lib/active_record/attribute_methods/write.rb#31
  def write_attribute(attr_name, value); end

  private

  # This method exists to avoid the expensive primary_key check internally, without
  # breaking compatibility with the write_attribute API
  #
  # source://activerecord//lib/active_record/attribute_methods/write.rb#41
  def attribute=(attr_name, value); end
end

module ActiveRecord::AttributeMethods::Write::ClassMethods
  private

  # source://activerecord//lib/active_record/attribute_methods/write.rb#14
  def define_method_attribute=(name, owner:); end
end

# See ActiveRecord::Attributes::ClassMethods for documentation
module ActiveRecord::Attributes
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Attributes::ClassMethods

  module GeneratedClassMethods
    def attributes_to_define_after_schema_loads; end
    def attributes_to_define_after_schema_loads=(value); end
    def attributes_to_define_after_schema_loads?; end
  end

  module GeneratedInstanceMethods; end
end

module ActiveRecord::Attributes::ClassMethods
  # Defines an attribute with a type on this model. It will override the
  # type of existing attributes if needed. This allows control over how
  # values are converted to and from SQL when assigned to a model. It also
  # changes the behavior of values passed to
  # {ActiveRecord::Base.where}[rdoc-ref:QueryMethods#where]. This will let you use
  # your domain objects across much of Active Record, without having to
  # rely on implementation details or monkey patching.
  #
  # +name+ The name of the methods to define attribute methods for, and the
  # column which this will persist to.
  #
  # +cast_type+ A symbol such as +:string+ or +:integer+, or a type object
  # to be used for this attribute. See the examples below for more
  # information about providing custom type objects.
  #
  # ==== Options
  #
  # The following options are accepted:
  #
  # +default+ The default value to use when no value is provided. If this option
  # is not passed, the previous default value (if any) will be used.
  # Otherwise, the default will be +nil+.
  #
  # +array+ (PostgreSQL only) specifies that the type should be an array (see the
  # examples below).
  #
  # +range+ (PostgreSQL only) specifies that the type should be a range (see the
  # examples below).
  #
  # When using a symbol for +cast_type+, extra options are forwarded to the
  # constructor of the type object.
  #
  # ==== Examples
  #
  # The type detected by Active Record can be overridden.
  #
  #   # db/schema.rb
  #   create_table :store_listings, force: true do |t|
  #     t.decimal :price_in_cents
  #   end
  #
  #   # app/models/store_listing.rb
  #   class StoreListing < ActiveRecord::Base
  #   end
  #
  #   store_listing = StoreListing.new(price_in_cents: '10.1')
  #
  #   # before
  #   store_listing.price_in_cents # => BigDecimal(10.1)
  #
  #   class StoreListing < ActiveRecord::Base
  #     attribute :price_in_cents, :integer
  #   end
  #
  #   # after
  #   store_listing.price_in_cents # => 10
  #
  # A default can also be provided.
  #
  #   # db/schema.rb
  #   create_table :store_listings, force: true do |t|
  #     t.string :my_string, default: "original default"
  #   end
  #
  #   StoreListing.new.my_string # => "original default"
  #
  #   # app/models/store_listing.rb
  #   class StoreListing < ActiveRecord::Base
  #     attribute :my_string, :string, default: "new default"
  #   end
  #
  #   StoreListing.new.my_string # => "new default"
  #
  #   class Product < ActiveRecord::Base
  #     attribute :my_default_proc, :datetime, default: -> { Time.now }
  #   end
  #
  #   Product.new.my_default_proc # => 2015-05-30 11:04:48 -0600
  #   sleep 1
  #   Product.new.my_default_proc # => 2015-05-30 11:04:49 -0600
  #
  # \Attributes do not need to be backed by a database column.
  #
  #   # app/models/my_model.rb
  #   class MyModel < ActiveRecord::Base
  #     attribute :my_string, :string
  #     attribute :my_int_array, :integer, array: true
  #     attribute :my_float_range, :float, range: true
  #   end
  #
  #   model = MyModel.new(
  #     my_string: "string",
  #     my_int_array: ["1", "2", "3"],
  #     my_float_range: "[1,3.5]",
  #   )
  #   model.attributes
  #   # =>
  #     {
  #       my_string: "string",
  #       my_int_array: [1, 2, 3],
  #       my_float_range: 1.0..3.5
  #     }
  #
  # Passing options to the type constructor
  #
  #   # app/models/my_model.rb
  #   class MyModel < ActiveRecord::Base
  #     attribute :small_int, :integer, limit: 2
  #   end
  #
  #   MyModel.create(small_int: 65537)
  #   # => Error: 65537 is out of range for the limit of two bytes
  #
  # ==== Creating Custom Types
  #
  # Users may also define their own custom types, as long as they respond
  # to the methods defined on the value type. The method +deserialize+ or
  # +cast+ will be called on your type object, with raw input from the
  # database or from your controllers. See ActiveModel::Type::Value for the
  # expected API. It is recommended that your type objects inherit from an
  # existing type, or from ActiveRecord::Type::Value
  #
  #   class MoneyType < ActiveRecord::Type::Integer
  #     def cast(value)
  #       if !value.kind_of?(Numeric) && value.include?('$')
  #         price_in_dollars = value.gsub(/\$/, '').to_f
  #         super(price_in_dollars * 100)
  #       else
  #         super
  #       end
  #     end
  #   end
  #
  #   # config/initializers/types.rb
  #   ActiveRecord::Type.register(:money, MoneyType)
  #
  #   # app/models/store_listing.rb
  #   class StoreListing < ActiveRecord::Base
  #     attribute :price_in_cents, :money
  #   end
  #
  #   store_listing = StoreListing.new(price_in_cents: '$10.00')
  #   store_listing.price_in_cents # => 1000
  #
  # For more details on creating custom types, see the documentation for
  # ActiveModel::Type::Value. For more details on registering your types
  # to be referenced by a symbol, see ActiveRecord::Type.register. You can
  # also pass a type object directly, in place of a symbol.
  #
  # ==== \Querying
  #
  # When {ActiveRecord::Base.where}[rdoc-ref:QueryMethods#where] is called, it will
  # use the type defined by the model class to convert the value to SQL,
  # calling +serialize+ on your type object. For example:
  #
  #   class Money < Struct.new(:amount, :currency)
  #   end
  #
  #   class MoneyType < ActiveRecord::Type::Value
  #     def initialize(currency_converter:)
  #       @currency_converter = currency_converter
  #     end
  #
  #     # value will be the result of +deserialize+ or
  #     # +cast+. Assumed to be an instance of +Money+ in
  #     # this case.
  #     def serialize(value)
  #       value_in_bitcoins = @currency_converter.convert_to_bitcoins(value)
  #       value_in_bitcoins.amount
  #     end
  #   end
  #
  #   # config/initializers/types.rb
  #   ActiveRecord::Type.register(:money, MoneyType)
  #
  #   # app/models/product.rb
  #   class Product < ActiveRecord::Base
  #     currency_converter = ConversionRatesFromTheInternet.new
  #     attribute :price_in_bitcoins, :money, currency_converter: currency_converter
  #   end
  #
  #   Product.where(price_in_bitcoins: Money.new(5, "USD"))
  #   # => SELECT * FROM products WHERE price_in_bitcoins = 0.02230
  #
  #   Product.where(price_in_bitcoins: Money.new(5, "GBP"))
  #   # => SELECT * FROM products WHERE price_in_bitcoins = 0.03412
  #
  # ==== Dirty Tracking
  #
  # The type of an attribute is given the opportunity to change how dirty
  # tracking is performed. The methods +changed?+ and +changed_in_place?+
  # will be called from ActiveModel::Dirty. See the documentation for those
  # methods in ActiveModel::Type::Value for more details.
  #
  # source://activerecord//lib/active_record/attributes.rb#208
  def attribute(name, cast_type = T.unsafe(nil), default: T.unsafe(nil), **options); end

  # This is the low level API which sits beneath +attribute+. It only
  # accepts type objects, and will do its work immediately instead of
  # waiting for the schema to load. Automatic schema detection and
  # ClassMethods#attribute both call this under the hood. While this method
  # is provided so it can be used by plugin authors, application code
  # should probably use ClassMethods#attribute.
  #
  # +name+ The name of the attribute being defined. Expected to be a +String+.
  #
  # +cast_type+ The type object to use for this attribute.
  #
  # +default+ The default value to use when no value is provided. If this option
  # is not passed, the previous default value (if any) will be used.
  # Otherwise, the default will be +nil+. A proc can also be passed, and
  # will be called once each time a new value is needed.
  #
  # +user_provided_default+ Whether the default value should be cast using
  # +cast+ or +deserialize+.
  #
  # source://activerecord//lib/active_record/attributes.rb#253
  def define_attribute(name, cast_type, default: T.unsafe(nil), user_provided_default: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/attributes.rb#263
  def load_schema!; end

  private

  # source://activerecord//lib/active_record/attributes.rb#275
  def define_default_attribute(name, value, type, from_user:); end
end

# source://activerecord//lib/active_record/attributes.rb#272
ActiveRecord::Attributes::ClassMethods::NO_DEFAULT_PROVIDED = T.let(T.unsafe(nil), Object)

# = Active Record Autosave Association
#
# AutosaveAssociation is a module that takes care of automatically saving
# associated records when their parent is saved. In addition to saving, it
# also destroys any associated records that were marked for destruction.
# (See #mark_for_destruction and #marked_for_destruction?).
#
# Saving of the parent, its associations, and the destruction of marked
# associations, all happen inside a transaction. This should never leave the
# database in an inconsistent state.
#
# If validations for any of the associations fail, their error messages will
# be applied to the parent.
#
# Note that it also means that associations marked for destruction won't
# be destroyed directly. They will however still be marked for destruction.
#
# Note that <tt>autosave: false</tt> is not same as not declaring <tt>:autosave</tt>.
# When the <tt>:autosave</tt> option is not present then new association records are
# saved but the updated association records are not saved.
#
# == Validation
#
# Child records are validated unless <tt>:validate</tt> is +false+.
#
# == Callbacks
#
# Association with autosave option defines several callbacks on your
# model (around_save, before_save, after_create, after_update). Please note that
# callbacks are executed in the order they were defined in
# model. You should avoid modifying the association content before
# autosave callbacks are executed. Placing your callbacks after
# associations is usually a good practice.
#
# === One-to-one Example
#
#   class Post < ActiveRecord::Base
#     has_one :author, autosave: true
#   end
#
# Saving changes to the parent and its associated model can now be performed
# automatically _and_ atomically:
#
#   post = Post.find(1)
#   post.title       # => "The current global position of migrating ducks"
#   post.author.name # => "alloy"
#
#   post.title = "On the migration of ducks"
#   post.author.name = "Eloy Duran"
#
#   post.save
#   post.reload
#   post.title       # => "On the migration of ducks"
#   post.author.name # => "Eloy Duran"
#
# Destroying an associated model, as part of the parent's save action, is as
# simple as marking it for destruction:
#
#   post.author.mark_for_destruction
#   post.author.marked_for_destruction? # => true
#
# Note that the model is _not_ yet removed from the database:
#
#   id = post.author.id
#   Author.find_by(id: id).nil? # => false
#
#   post.save
#   post.reload.author # => nil
#
# Now it _is_ removed from the database:
#
#   Author.find_by(id: id).nil? # => true
#
# === One-to-many Example
#
# When <tt>:autosave</tt> is not declared new children are saved when their parent is saved:
#
#   class Post < ActiveRecord::Base
#     has_many :comments # :autosave option is not declared
#   end
#
#   post = Post.new(title: 'ruby rocks')
#   post.comments.build(body: 'hello world')
#   post.save # => saves both post and comment
#
#   post = Post.create(title: 'ruby rocks')
#   post.comments.build(body: 'hello world')
#   post.save # => saves both post and comment
#
#   post = Post.create(title: 'ruby rocks')
#   comment = post.comments.create(body: 'hello world')
#   comment.body = 'hi everyone'
#   post.save # => saves post, but not comment
#
# When <tt>:autosave</tt> is true all children are saved, no matter whether they
# are new records or not:
#
#   class Post < ActiveRecord::Base
#     has_many :comments, autosave: true
#   end
#
#   post = Post.create(title: 'ruby rocks')
#   comment = post.comments.create(body: 'hello world')
#   comment.body = 'hi everyone'
#   post.comments.build(body: "good morning.")
#   post.save # => saves post and both comments.
#
# Destroying one of the associated models as part of the parent's save action
# is as simple as marking it for destruction:
#
#   post.comments # => [#<Comment id: 1, ...>, #<Comment id: 2, ...]>
#   post.comments[1].mark_for_destruction
#   post.comments[1].marked_for_destruction? # => true
#   post.comments.length # => 2
#
# Note that the model is _not_ yet removed from the database:
#
#   id = post.comments.last.id
#   Comment.find_by(id: id).nil? # => false
#
#   post.save
#   post.reload.comments.length # => 1
#
# Now it _is_ removed from the database:
#
#   Comment.find_by(id: id).nil? # => true
#
# === Caveats
#
# Note that autosave will only trigger for already-persisted association records
# if the records themselves have been changed. This is to protect against
# <tt>SystemStackError</tt> caused by circular association validations. The one
# exception is if a custom validation context is used, in which case the validations
# will always fire on the associated records.
module ActiveRecord::AutosaveAssociation
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::AutosaveAssociation::ClassMethods

  # Returns whether or not this record has been changed in any way (including whether
  # any of its nested autosave associations are likewise changed)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#271
  def changed_for_autosave?; end

  # Returns the association for the parent being destroyed.
  #
  # Used to avoid updating the counter cache unnecessarily.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#265
  def destroyed_by_association; end

  # Records the association that is being destroyed and destroying this
  # record in the process.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#258
  def destroyed_by_association=(reflection); end

  # Marks this record to be destroyed as part of the parent's save transaction.
  # This does _not_ actually destroy the record instantly, rather child record will be destroyed
  # when <tt>parent.save</tt> is called.
  #
  # Only useful if the <tt>:autosave</tt> option on the parent is enabled for this associated model.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#245
  def mark_for_destruction; end

  # Returns whether or not this record will be destroyed as part of the parent's save transaction.
  #
  # Only useful if the <tt>:autosave</tt> option on the parent is enabled for this associated model.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#252
  def marked_for_destruction?; end

  # Reloads the attributes of the object as usual and clears <tt>marked_for_destruction</tt> flag.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#234
  def reload(options = T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/autosave_association.rb#508
  def _ensure_no_duplicate_errors; end

  # If the record is new or it has changed, returns true.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#464
  def _record_changed?(reflection, record, key); end

  # Is used as an around_save callback to check while saving a collection
  # association whether or not the parent was a new record before saving.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#366
  def around_save_collection_association; end

  # Returns the record for an association collection that should be validated
  # or saved. If +autosave+ is +false+ only new records will be returned,
  # unless the parent is/was a new record itself.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#279
  def associated_records_to_validate_or_save(association, new_record, autosave); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#470
  def association_foreign_key_changed?(reflection, record, key); end

  # Returns whether or not the association is valid and applies any errors to
  # the parent, <tt>self</tt>, if it wasn't. Skips any <tt>:autosave</tt>
  # enabled records if they're marked_for_destruction? or destroyed.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#330
  def association_valid?(reflection, record, index = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#504
  def custom_validation_context?; end

  # Go through nested autosave associations that are loaded in memory (without loading
  # any new ones), and return true if any are changed for autosave.
  # Returns false if already called to prevent an infinite loop.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/autosave_association.rb#292
  def nested_records_changed_for_autosave?; end

  # source://activerecord//lib/active_record/autosave_association.rb#356
  def normalize_reflection_attribute(indexed_attribute, reflection, index, attribute); end

  # Saves the associated record if it's new or <tt>:autosave</tt> is enabled.
  #
  # In addition, it will destroy the association if it was marked for destruction.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#479
  def save_belongs_to_association(reflection); end

  # Saves any new associated records, or all loaded autosave associations if
  # <tt>:autosave</tt> is enabled on the association.
  #
  # In addition, it destroys all children that were marked for destruction
  # with #mark_for_destruction.
  #
  # This all happens inside a transaction, _if_ the Transactions module is included into
  # ActiveRecord::Base after the AutosaveAssociation module, which it does by default.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#383
  def save_collection_association(reflection); end

  # Saves the associated record if it's new or <tt>:autosave</tt> is enabled
  # on the association.
  #
  # In addition, it will destroy the association if it was marked for
  # destruction with #mark_for_destruction.
  #
  # This all happens inside a transaction, _if_ the Transactions module is included into
  # ActiveRecord::Base after the AutosaveAssociation module, which it does by default.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#437
  def save_has_one_association(reflection); end

  # Validate the associated records if <tt>:validate</tt> or
  # <tt>:autosave</tt> is turned on for the association specified by
  # +reflection+.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#319
  def validate_collection_association(reflection); end

  # Validate the association if <tt>:validate</tt> or <tt>:autosave</tt> is
  # turned on for the association.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#310
  def validate_single_association(reflection); end
end

module ActiveRecord::AutosaveAssociation::AssociationBuilderExtension
  class << self
    # source://activerecord//lib/active_record/autosave_association.rb#142
    def build(model, reflection); end

    # source://activerecord//lib/active_record/autosave_association.rb#146
    def valid_options; end
  end
end

module ActiveRecord::AutosaveAssociation::ClassMethods
  private

  # Adds validation and save callbacks for the association as specified by
  # the +reflection+.
  #
  # For performance reasons, we don't check whether to validate at runtime.
  # However the validation and callback methods are lazy and those methods
  # get created when they are invoked for the very first time. However,
  # this can change, for instance, when using nested attributes, which is
  # called _after_ the association has been defined. Since we don't want
  # the callbacks to get defined multiple times, there are guards that
  # check if the save or validation methods have already been defined
  # before actually defining them.
  #
  # source://activerecord//lib/active_record/autosave_association.rb#187
  def add_autosave_association_callbacks(reflection); end

  # source://activerecord//lib/active_record/autosave_association.rb#217
  def define_autosave_validation_callbacks(reflection); end

  # source://activerecord//lib/active_record/autosave_association.rb#157
  def define_non_cyclic_method(name, &block); end
end

# = Active Record
#
# Active Record objects don't specify their attributes directly, but rather infer them from
# the table definition with which they're linked. Adding, removing, and changing attributes
# and their type is done directly in the database. Any change is instantly reflected in the
# Active Record objects. The mapping that binds a given Active Record class to a certain
# database table will happen automatically in most common cases, but can be overwritten for the uncommon ones.
#
# See the mapping rules in table_name and the full example in link:files/activerecord/README_rdoc.html for more insight.
#
# == Creation
#
# Active Records accept constructor parameters either in a hash or as a block. The hash
# method is especially useful when you're receiving the data from somewhere else, like an
# HTTP request. It works like this:
#
#   user = User.new(name: "David", occupation: "Code Artist")
#   user.name # => "David"
#
# You can also use block initialization:
#
#   user = User.new do |u|
#     u.name = "David"
#     u.occupation = "Code Artist"
#   end
#
# And of course you can just create a bare object and specify the attributes after the fact:
#
#   user = User.new
#   user.name = "David"
#   user.occupation = "Code Artist"
#
# == Conditions
#
# Conditions can either be specified as a string, array, or hash representing the WHERE-part of an SQL statement.
# The array form is to be used when the condition input is tainted and requires sanitization. The string form can
# be used for statements that don't involve tainted data. The hash form works much like the array form, except
# only equality and range is possible. Examples:
#
#   class User < ActiveRecord::Base
#     def self.authenticate_unsafely(user_name, password)
#       where("user_name = '#{user_name}' AND password = '#{password}'").first
#     end
#
#     def self.authenticate_safely(user_name, password)
#       where("user_name = ? AND password = ?", user_name, password).first
#     end
#
#     def self.authenticate_safely_simply(user_name, password)
#       where(user_name: user_name, password: password).first
#     end
#   end
#
# The <tt>authenticate_unsafely</tt> method inserts the parameters directly into the query
# and is thus susceptible to SQL-injection attacks if the <tt>user_name</tt> and +password+
# parameters come directly from an HTTP request. The <tt>authenticate_safely</tt> and
# <tt>authenticate_safely_simply</tt> both will sanitize the <tt>user_name</tt> and +password+
# before inserting them in the query, which will ensure that an attacker can't escape the
# query and fake the login (or worse).
#
# When using multiple parameters in the conditions, it can easily become hard to read exactly
# what the fourth or fifth question mark is supposed to represent. In those cases, you can
# resort to named bind variables instead. That's done by replacing the question marks with
# symbols and supplying a hash with values for the matching symbol keys:
#
#   Company.where(
#     "id = :id AND name = :name AND division = :division AND created_at > :accounting_date",
#     { id: 3, name: "37signals", division: "First", accounting_date: '2005-01-01' }
#   ).first
#
# Similarly, a simple hash without a statement will generate conditions based on equality with the SQL AND
# operator. For instance:
#
#   Student.where(first_name: "Harvey", status: 1)
#   Student.where(params[:student])
#
# A range may be used in the hash to use the SQL BETWEEN operator:
#
#   Student.where(grade: 9..12)
#
# An array may be used in the hash to use the SQL IN operator:
#
#   Student.where(grade: [9,11,12])
#
# When joining tables, nested hashes or keys written in the form 'table_name.column_name'
# can be used to qualify the table name of a particular condition. For instance:
#
#   Student.joins(:schools).where(schools: { category: 'public' })
#   Student.joins(:schools).where('schools.category' => 'public' )
#
# == Overwriting default accessors
#
# All column values are automatically available through basic accessors on the Active Record
# object, but sometimes you want to specialize this behavior. This can be done by overwriting
# the default accessors (using the same name as the attribute) and calling
# +super+ to actually change things.
#
#   class Song < ActiveRecord::Base
#     # Uses an integer of seconds to hold the length of the song
#
#     def length=(minutes)
#       super(minutes.to_i * 60)
#     end
#
#     def length
#       super / 60
#     end
#   end
#
# == Attribute query methods
#
# In addition to the basic accessors, query methods are also automatically available on the Active Record object.
# Query methods allow you to test whether an attribute value is present.
# Additionally, when dealing with numeric values, a query method will return false if the value is zero.
#
# For example, an Active Record User with the <tt>name</tt> attribute has a <tt>name?</tt> method that you can call
# to determine whether the user has a name:
#
#   user = User.new(name: "David")
#   user.name? # => true
#
#   anonymous = User.new(name: "")
#   anonymous.name? # => false
#
# Query methods will also respect any overrides of default accessors:
#
#   class User
#     # Has admin boolean column
#     def admin
#       false
#     end
#   end
#
#   user.update(admin: true)
#
#   user.read_attribute(:admin)  # => true, gets the column value
#   user[:admin] # => true, also gets the column value
#
#   user.admin   # => false, due to the getter override
#   user.admin?  # => false, due to the getter override
#
# == Accessing attributes before they have been typecasted
#
# Sometimes you want to be able to read the raw attribute data without having the column-determined
# typecast run its course first. That can be done by using the <tt><attribute>_before_type_cast</tt>
# accessors that all attributes have. For example, if your Account model has a <tt>balance</tt> attribute,
# you can call <tt>account.balance_before_type_cast</tt> or <tt>account.id_before_type_cast</tt>.
#
# This is especially useful in validation situations where the user might supply a string for an
# integer field and you want to display the original string back in an error message. Accessing the
# attribute normally would typecast the string to 0, which isn't what you want.
#
# == Dynamic attribute-based finders
#
# Dynamic attribute-based finders are a mildly deprecated way of getting (and/or creating) objects
# by simple queries without turning to SQL. They work by appending the name of an attribute
# to <tt>find_by_</tt> like <tt>Person.find_by_user_name</tt>.
# Instead of writing <tt>Person.find_by(user_name: user_name)</tt>, you can use
# <tt>Person.find_by_user_name(user_name)</tt>.
#
# It's possible to add an exclamation point (!) on the end of the dynamic finders to get them to raise an
# ActiveRecord::RecordNotFound error if they do not return any records,
# like <tt>Person.find_by_last_name!</tt>.
#
# It's also possible to use multiple attributes in the same <tt>find_by_</tt> by separating them with
# "_and_".
#
#  Person.find_by(user_name: user_name, password: password)
#  Person.find_by_user_name_and_password(user_name, password) # with dynamic finder
#
# It's even possible to call these dynamic finder methods on relations and named scopes.
#
#   Payment.order("created_on").find_by_amount(50)
#
# == Saving arrays, hashes, and other non-mappable objects in text columns
#
# Active Record can serialize any object in text columns using YAML. To do so, you must
# specify this with a call to the class method
# {serialize}[rdoc-ref:AttributeMethods::Serialization::ClassMethods#serialize].
# This makes it possible to store arrays, hashes, and other non-mappable objects without doing
# any additional work.
#
#   class User < ActiveRecord::Base
#     serialize :preferences
#   end
#
#   user = User.create(preferences: { "background" => "black", "display" => large })
#   User.find(user.id).preferences # => { "background" => "black", "display" => large }
#
# You can also specify a class option as the second parameter that'll raise an exception
# if a serialized object is retrieved as a descendant of a class not in the hierarchy.
#
#   class User < ActiveRecord::Base
#     serialize :preferences, Hash
#   end
#
#   user = User.create(preferences: %w( one two three ))
#   User.find(user.id).preferences    # raises SerializationTypeMismatch
#
# When you specify a class option, the default value for that attribute will be a new
# instance of that class.
#
#   class User < ActiveRecord::Base
#     serialize :preferences, OpenStruct
#   end
#
#   user = User.new
#   user.preferences.theme_color = "red"
#
#
# == Single table inheritance
#
# Active Record allows inheritance by storing the name of the class in a
# column that is named "type" by default. See ActiveRecord::Inheritance for
# more details.
#
# == Connection to multiple databases in different models
#
# Connections are usually created through
# {ActiveRecord::Base.establish_connection}[rdoc-ref:ConnectionHandling#establish_connection] and retrieved
# by ActiveRecord::Base.connection. All classes inheriting from ActiveRecord::Base will use this
# connection. But you can also set a class-specific connection. For example, if Course is an
# ActiveRecord::Base, but resides in a different database, you can just say <tt>Course.establish_connection</tt>
# and Course and all of its subclasses will use this connection instead.
#
# This feature is implemented by keeping a connection pool in ActiveRecord::Base that is
# a hash indexed by the class. If a connection is requested, the
# {ActiveRecord::Base.retrieve_connection}[rdoc-ref:ConnectionHandling#retrieve_connection] method
# will go up the class-hierarchy until a connection is found in the connection pool.
#
# == Exceptions
#
# * ActiveRecordError - Generic error class and superclass of all other errors raised by Active Record.
# * AdapterNotSpecified - The configuration hash used in
#   {ActiveRecord::Base.establish_connection}[rdoc-ref:ConnectionHandling#establish_connection]
#   didn't include an <tt>:adapter</tt> key.
# * AdapterNotFound - The <tt>:adapter</tt> key used in
#   {ActiveRecord::Base.establish_connection}[rdoc-ref:ConnectionHandling#establish_connection]
#   specified a non-existent adapter
#   (or a bad spelling of an existing one).
# * AssociationTypeMismatch - The object assigned to the association wasn't of the type
#   specified in the association definition.
# * AttributeAssignmentError - An error occurred while doing a mass assignment through the
#   {ActiveRecord::Base#attributes=}[rdoc-ref:AttributeAssignment#attributes=] method.
#   You can inspect the +attribute+ property of the exception object to determine which attribute
#   triggered the error.
# * ConnectionNotEstablished - No connection has been established.
#   Use {ActiveRecord::Base.establish_connection}[rdoc-ref:ConnectionHandling#establish_connection] before querying.
# * MultiparameterAssignmentErrors - Collection of errors that occurred during a mass assignment using the
#   {ActiveRecord::Base#attributes=}[rdoc-ref:AttributeAssignment#attributes=] method.
#   The +errors+ property of this exception contains an array of
#   AttributeAssignmentError
#   objects that should be inspected to determine which attributes triggered the errors.
# * RecordInvalid - raised by {ActiveRecord::Base#save!}[rdoc-ref:Persistence#save!] and
#   {ActiveRecord::Base.create!}[rdoc-ref:Persistence::ClassMethods#create!]
#   when the record is invalid.
# * RecordNotFound - No record responded to the {ActiveRecord::Base.find}[rdoc-ref:FinderMethods#find] method.
#   Either the row with the given ID doesn't exist or the row didn't meet the additional restrictions.
#   Some {ActiveRecord::Base.find}[rdoc-ref:FinderMethods#find] calls do not raise this exception to signal
#   nothing was found, please check its documentation for further details.
# * SerializationTypeMismatch - The serialized object wasn't of the class specified as the second parameter.
# * StatementInvalid - The database server rejected the SQL statement. The precise error is added in the message.
#
# *Note*: The attributes listed are class-level attributes (accessible from both the class and instance level).
# So it's possible to assign a logger to the class through <tt>Base.logger=</tt> which will then be used by all
# instances in the current object space.
class ActiveRecord::Base
  include ::ActiveRecord::Core
  include ::ActiveRecord::Persistence
  include ::ActiveRecord::ReadonlyAttributes
  include ::ActiveRecord::ModelSchema
  include ::ActiveRecord::Inheritance
  include ::ActiveRecord::Scoping
  include ::ActiveRecord::Scoping::Default
  include ::ActiveRecord::Scoping::Named
  include ::ActiveRecord::Sanitization
  include ::ActiveModel::ForbiddenAttributesProtection
  include ::ActiveModel::AttributeAssignment
  include ::ActiveRecord::AttributeAssignment
  include ::ActiveModel::Conversion
  include ::ActiveRecord::Integration
  include ::ActiveModel::Validations
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods
  include ::ActiveRecord::Validations
  include ::ActiveRecord::CounterCache
  include ::ActiveRecord::Attributes
  include ::ActiveRecord::Locking::Optimistic
  include ::ActiveRecord::Locking::Pessimistic
  include ::ActiveModel::AttributeMethods
  include ::ActiveRecord::AttributeMethods
  include ::ActiveRecord::Base::GeneratedAttributeMethods
  include ::ActiveRecord::Base::GeneratedAssociationMethods
  include ::ActiveRecord::AttributeMethods::Read
  include ::ActiveRecord::AttributeMethods::Write
  include ::ActiveRecord::AttributeMethods::BeforeTypeCast
  include ::ActiveRecord::AttributeMethods::Query
  include ::ActiveRecord::AttributeMethods::PrimaryKey
  include ::ActiveRecord::AttributeMethods::TimeZoneConversion
  include ::ActiveModel::Dirty
  include ::ActiveRecord::AttributeMethods::Dirty
  include ::ActiveRecord::AttributeMethods::Serialization
  include ::ActiveRecord::Callbacks
  include ::ActiveModel::Validations::Callbacks
  include ::ActiveRecord::Timestamp
  include ::ActiveRecord::Associations
  include ::ActiveModel::SecurePassword
  include ::ActiveRecord::AutosaveAssociation
  include ::ActiveRecord::NestedAttributes
  include ::ActiveRecord::Transactions
  include ::ActiveRecord::TouchLater
  include ::ActiveRecord::NoTouching
  include ::ActiveRecord::Reflection
  include ::ActiveModel::Serialization
  include ::ActiveModel::Serializers::JSON
  include ::ActiveRecord::Serialization
  include ::ActiveRecord::Store
  include ::ActiveRecord::SecureToken
  include ::ActiveRecord::SignedId
  include ::ActiveRecord::Suppressor
  include ::ActiveRecord::Encryption::EncryptableRecord
  include ::Kaminari::ActiveRecordExtension
  include ::CounterCulture::Extensions
  include ::WhinyValidation
  extend ::ActiveModel::Naming
  extend ::ActiveSupport::Benchmarkable
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActiveRecord::ConnectionHandling
  extend ::ActiveRecord::QueryCache::ClassMethods
  extend ::ActiveRecord::Querying
  extend ::ActiveModel::Translation
  extend ::ActiveRecord::Translation
  extend ::ActiveRecord::DynamicMatchers
  extend ::ActiveRecord::DelegatedType
  extend ::ActiveRecord::Explain
  extend ::ActiveRecord::Enum
  extend ::ActiveRecord::Delegation::DelegateCache
  extend ::ActiveRecord::Aggregations::ClassMethods
  extend ::ActiveRecord::Core::ClassMethods
  extend ::ActiveRecord::Persistence::ClassMethods
  extend ::ActiveRecord::ReadonlyAttributes::ClassMethods
  extend ::ActiveRecord::ModelSchema::ClassMethods
  extend ::ActiveRecord::Inheritance::ClassMethods
  extend ::ActiveRecord::Scoping::ClassMethods
  extend ::ActiveRecord::Scoping::Default::ClassMethods
  extend ::ActiveRecord::Scoping::Named::ClassMethods
  extend ::ActiveRecord::Sanitization::ClassMethods
  extend ::ActiveModel::Conversion::ClassMethods
  extend ::ActiveRecord::Integration::ClassMethods
  extend ::ActiveModel::Validations::ClassMethods
  extend ::ActiveModel::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveModel::Validations::HelperMethods
  extend ::ActiveRecord::Validations::ClassMethods
  extend ::ActiveRecord::CounterCache::ClassMethods
  extend ::ActiveRecord::Attributes::ClassMethods
  extend ::ActiveRecord::Locking::Optimistic::ClassMethods
  extend ::ActiveModel::AttributeMethods::ClassMethods
  extend ::ActiveRecord::AttributeMethods::ClassMethods
  extend ::ActiveRecord::AttributeMethods::Read::ClassMethods
  extend ::ActiveRecord::AttributeMethods::Write::ClassMethods
  extend ::ActiveRecord::AttributeMethods::PrimaryKey::ClassMethods
  extend ::ActiveRecord::AttributeMethods::TimeZoneConversion::ClassMethods
  extend ::ActiveRecord::AttributeMethods::Dirty::ClassMethods
  extend ::ActiveRecord::AttributeMethods::Serialization::ClassMethods
  extend ::ActiveRecord::Callbacks::ClassMethods
  extend ::ActiveModel::Validations::Callbacks::ClassMethods
  extend ::ActiveRecord::Timestamp::ClassMethods
  extend ::ActiveRecord::Associations::ClassMethods
  extend ::ActiveModel::SecurePassword::ClassMethods
  extend ::ActiveRecord::AutosaveAssociation::ClassMethods
  extend ::ActiveRecord::NestedAttributes::ClassMethods
  extend ::ActiveRecord::Transactions::ClassMethods
  extend ::ActiveRecord::NoTouching::ClassMethods
  extend ::ActiveRecord::Reflection::ClassMethods
  extend ::ActiveRecord::Store::ClassMethods
  extend ::ActiveRecord::SecureToken::ClassMethods
  extend ::ActiveRecord::SignedId::ClassMethods
  extend ::ActiveRecord::Suppressor::ClassMethods
  extend ::ActiveRecord::Encryption::EncryptableRecord::ClassMethods
  extend ::Kaminari::ActiveRecordExtension::ClassMethods
  extend ::Ransack::Adapters::ActiveRecord::Base
  extend ::CounterCulture::Extensions::ClassMethods

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks?; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _before_commit_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _commit_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _create_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _destroy_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _find_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _initialize_callbacks; end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
  def _ransack_aliases; end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
  def _ransack_aliases=(_arg0); end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
  def _ransack_aliases?; end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
  def _ransackers; end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
  def _ransackers=(_arg0); end

  # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
  def _ransackers?; end

  # source://activerecord//lib/active_record/reflection.rb#11
  def _reflections; end

  # source://activerecord//lib/active_record/reflection.rb#11
  def _reflections?; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _rollback_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_before_commit_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_commit_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_create_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_destroy_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_find_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_initialize_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_rollback_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_save_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_touch_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_update_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_validate_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_validation_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _save_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _touch_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _update_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _validate_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _validation_callbacks; end

  # source://activemodel/7.0.4/lib/active_model/validations.rb#52
  def _validators; end

  # source://activemodel/7.0.4/lib/active_model/validations.rb#52
  def _validators?; end

  # source://activerecord//lib/active_record/reflection.rb#12
  def aggregate_reflections; end

  # source://activerecord//lib/active_record/reflection.rb#12
  def aggregate_reflections?; end

  # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#73
  def attribute_aliases; end

  # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#73
  def attribute_aliases?; end

  # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#74
  def attribute_method_matchers; end

  # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#74
  def attribute_method_matchers?; end

  # source://activerecord//lib/active_record/reflection.rb#13
  def automatic_scope_inversing; end

  # source://activerecord//lib/active_record/reflection.rb#13
  def automatic_scope_inversing?; end

  # source://activerecord//lib/active_record/integration.rb#16
  def cache_timestamp_format; end

  # source://activerecord//lib/active_record/integration.rb#16
  def cache_timestamp_format?; end

  # source://activerecord//lib/active_record/integration.rb#24
  def cache_versioning; end

  # source://activerecord//lib/active_record/integration.rb#24
  def cache_versioning?; end

  # source://activerecord//lib/active_record/integration.rb#32
  def collection_cache_versioning; end

  # source://activerecord//lib/active_record/integration.rb#32
  def collection_cache_versioning?; end

  # source://activerecord//lib/active_record/model_schema.rb#171
  def column_for_attribute(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/core.rb#74
  def default_connection_handler; end

  # source://activerecord//lib/active_record/core.rb#74
  def default_connection_handler?; end

  # source://activerecord//lib/active_record/core.rb#76
  def default_role; end

  # source://activerecord//lib/active_record/core.rb#76
  def default_role?; end

  # source://activerecord//lib/active_record/scoping/default.rb#20
  def default_scope_override; end

  # source://activerecord//lib/active_record/scoping/default.rb#19
  def default_scopes; end

  # source://activerecord//lib/active_record/core.rb#78
  def default_shard; end

  # source://activerecord//lib/active_record/core.rb#78
  def default_shard?; end

  # source://activerecord//lib/active_record/enum.rb#116
  def defined_enums; end

  # source://activerecord//lib/active_record/enum.rb#116
  def defined_enums?; end

  # source://activerecord//lib/active_record/core.rb#26
  def destroy_association_async_job; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
  def encrypted_attributes; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
  def encrypted_attributes=(_arg0); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
  def encrypted_attributes?; end

  # source://activemodel/7.0.4/lib/active_model/serializers/json.rb#15
  def include_root_in_json; end

  # source://activemodel/7.0.4/lib/active_model/serializers/json.rb#15
  def include_root_in_json?; end

  # source://activerecord//lib/active_record/locking/optimistic.rb#56
  def lock_optimistically; end

  # source://activerecord//lib/active_record/locking/optimistic.rb#56
  def lock_optimistically?; end

  # source://activerecord//lib/active_record/core.rb#20
  def logger; end

  # source://activerecord//lib/active_record/core.rb#20
  def logger?; end

  # source://activemodel/7.0.4/lib/active_model/naming.rb#244
  def model_name(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/nested_attributes.rb#15
  def nested_attributes_options; end

  # source://activerecord//lib/active_record/nested_attributes.rb#15
  def nested_attributes_options?; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#18
  def partial_inserts; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#18
  def partial_inserts?; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#17
  def partial_updates; end

  # source://activerecord//lib/active_record/attribute_methods/dirty.rb#17
  def partial_updates?; end

  # source://activerecord//lib/active_record/model_schema.rb#156
  def pluralize_table_names; end

  # source://activerecord//lib/active_record/model_schema.rb#156
  def pluralize_table_names?; end

  # source://activerecord//lib/active_record/model_schema.rb#151
  def primary_key_prefix_type; end

  # source://activerecord//lib/active_record/model_schema.rb#151
  def primary_key_prefix_type?; end

  # source://activerecord//lib/active_record/timestamp.rb#47
  def record_timestamps; end

  # source://activerecord//lib/active_record/timestamp.rb#47
  def record_timestamps=(_arg0); end

  # source://activerecord//lib/active_record/timestamp.rb#47
  def record_timestamps?; end

  # source://activerecord//lib/active_record/signed_id.rb#13
  def signed_id_verifier_secret; end

  # source://activerecord//lib/active_record/signed_id.rb#13
  def signed_id_verifier_secret?; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#71
  def skip_time_zone_conversion_for_attributes; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#71
  def skip_time_zone_conversion_for_attributes?; end

  # source://activerecord//lib/active_record/inheritance.rb#42
  def store_full_class_name; end

  # source://activerecord//lib/active_record/inheritance.rb#42
  def store_full_class_name?; end

  # source://activerecord//lib/active_record/inheritance.rb#46
  def store_full_sti_class; end

  # source://activerecord//lib/active_record/inheritance.rb#46
  def store_full_sti_class?; end

  # source://activerecord//lib/active_record/model_schema.rb#152
  def table_name_prefix; end

  # source://activerecord//lib/active_record/model_schema.rb#152
  def table_name_prefix?; end

  # source://activerecord//lib/active_record/model_schema.rb#153
  def table_name_suffix; end

  # source://activerecord//lib/active_record/model_schema.rb#153
  def table_name_suffix?; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#70
  def time_zone_aware_attributes; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#70
  def time_zone_aware_attributes?; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#72
  def time_zone_aware_types; end

  # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#72
  def time_zone_aware_types?; end

  # source://activerecord//lib/active_record/model_schema.rb#171
  def type_for_attribute(*_arg0, **_arg1, &_arg2); end

  # source://activemodel/7.0.4/lib/active_model/validations.rb#48
  def validation_context; end

  private

  # source://activemodel/7.0.4/lib/active_model/validations.rb#48
  def validation_context=(_arg0); end

  class << self
    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks?; end

    # source://activerecord//lib/active_record/readonly_attributes.rb#8
    def _attr_readonly; end

    # source://activerecord//lib/active_record/readonly_attributes.rb#8
    def _attr_readonly=(value); end

    # source://activerecord//lib/active_record/readonly_attributes.rb#8
    def _attr_readonly?; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _before_commit_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _before_commit_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _commit_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _commit_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _create_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _create_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _destroy_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _destroy_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _find_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _find_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _initialize_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _initialize_callbacks=(value); end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
    def _ransack_aliases; end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
    def _ransack_aliases=(value); end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#9
    def _ransack_aliases?; end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
    def _ransackers; end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
    def _ransackers=(value); end

    # source://ransack/3.2.1/lib/ransack/adapters/active_record/base.rb#8
    def _ransackers?; end

    # source://activerecord//lib/active_record/reflection.rb#11
    def _reflections; end

    # source://activerecord//lib/active_record/reflection.rb#11
    def _reflections=(value); end

    # source://activerecord//lib/active_record/reflection.rb#11
    def _reflections?; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _rollback_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _rollback_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _save_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _save_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _touch_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _touch_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _update_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _update_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _validate_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _validate_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _validation_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _validation_callbacks=(value); end

    # source://activemodel/7.0.4/lib/active_model/validations.rb#52
    def _validators; end

    # source://activemodel/7.0.4/lib/active_model/validations.rb#52
    def _validators=(value); end

    # source://activemodel/7.0.4/lib/active_model/validations.rb#52
    def _validators?; end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_create(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_destroy(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_find(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_initialize(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_save(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_touch(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#144
    def after_update(*args, **options, &block); end

    # source://activerecord//lib/active_record/reflection.rb#12
    def aggregate_reflections; end

    # source://activerecord//lib/active_record/reflection.rb#12
    def aggregate_reflections=(value); end

    # source://activerecord//lib/active_record/reflection.rb#12
    def aggregate_reflections?; end

    # source://activerecord//lib/active_record/core.rb#82
    def application_record_class?; end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#137
    def around_create(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#137
    def around_destroy(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#137
    def around_save(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#137
    def around_update(*args, **options, &block); end

    # source://activerecord//lib/active_record/core.rb#129
    def asynchronous_queries_session; end

    # source://activerecord//lib/active_record/core.rb#133
    def asynchronous_queries_tracker; end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#73
    def attribute_aliases; end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#73
    def attribute_aliases=(value); end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#73
    def attribute_aliases?; end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#74
    def attribute_method_matchers; end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#74
    def attribute_method_matchers=(value); end

    # source://activemodel/7.0.4/lib/active_model/attribute_methods.rb#74
    def attribute_method_matchers?; end

    # source://activerecord//lib/active_record/attributes.rb#11
    def attributes_to_define_after_schema_loads; end

    # source://activerecord//lib/active_record/attributes.rb#11
    def attributes_to_define_after_schema_loads=(value); end

    # source://activerecord//lib/active_record/attributes.rb#11
    def attributes_to_define_after_schema_loads?; end

    # source://activerecord//lib/active_record/reflection.rb#13
    def automatic_scope_inversing; end

    # source://activerecord//lib/active_record/reflection.rb#13
    def automatic_scope_inversing=(value); end

    # source://activerecord//lib/active_record/reflection.rb#13
    def automatic_scope_inversing?; end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#130
    def before_create(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#130
    def before_destroy(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#130
    def before_save(*args, **options, &block); end

    # source://activemodel/7.0.4/lib/active_model/callbacks.rb#130
    def before_update(*args, **options, &block); end

    # source://activerecord//lib/active_record/core.rb#68
    def belongs_to_required_by_default; end

    # source://activerecord//lib/active_record/core.rb#68
    def belongs_to_required_by_default=(value); end

    # source://activerecord//lib/active_record/core.rb#68
    def belongs_to_required_by_default?; end

    # source://activerecord//lib/active_record/integration.rb#16
    def cache_timestamp_format; end

    # source://activerecord//lib/active_record/integration.rb#16
    def cache_timestamp_format=(value); end

    # source://activerecord//lib/active_record/integration.rb#16
    def cache_timestamp_format?; end

    # source://activerecord//lib/active_record/integration.rb#24
    def cache_versioning; end

    # source://activerecord//lib/active_record/integration.rb#24
    def cache_versioning=(value); end

    # source://activerecord//lib/active_record/integration.rb#24
    def cache_versioning?; end

    # source://activerecord//lib/active_record/integration.rb#32
    def collection_cache_versioning; end

    # source://activerecord//lib/active_record/integration.rb#32
    def collection_cache_versioning=(value); end

    # source://activerecord//lib/active_record/integration.rb#32
    def collection_cache_versioning?; end

    # source://activerecord//lib/active_record/core.rb#56
    def configurations; end

    # source://activerecord//lib/active_record/core.rb#50
    def configurations=(config); end

    # source://activerecord//lib/active_record/core.rb#201
    def connected_to_stack; end

    # source://activerecord//lib/active_record/core.rb#215
    def connection_class; end

    # source://activerecord//lib/active_record/core.rb#211
    def connection_class=(b); end

    # source://activerecord//lib/active_record/core.rb#219
    def connection_class?; end

    # source://activerecord//lib/active_record/core.rb#223
    def connection_class_for_self; end

    # source://activerecord//lib/active_record/core.rb#94
    def connection_handler; end

    # source://activerecord//lib/active_record/core.rb#98
    def connection_handler=(handler); end

    # source://activerecord//lib/active_record/core.rb#102
    def connection_handlers; end

    # source://activerecord//lib/active_record/core.rb#111
    def connection_handlers=(handlers); end

    # source://activerecord//lib/active_record/core.rb#188
    def current_preventing_writes; end

    # source://activerecord//lib/active_record/core.rb#147
    def current_role; end

    # source://activerecord//lib/active_record/core.rb#169
    def current_shard; end

    # source://activerecord//lib/active_record/core.rb#74
    def default_connection_handler; end

    # source://activerecord//lib/active_record/core.rb#74
    def default_connection_handler=(value); end

    # source://activerecord//lib/active_record/core.rb#74
    def default_connection_handler?; end

    # source://activerecord//lib/active_record/core.rb#76
    def default_role; end

    # source://activerecord//lib/active_record/core.rb#76
    def default_role=(value); end

    # source://activerecord//lib/active_record/core.rb#76
    def default_role?; end

    # source://activerecord//lib/active_record/scoping/default.rb#20
    def default_scope_override; end

    # source://activerecord//lib/active_record/scoping/default.rb#20
    def default_scope_override=(value); end

    # source://activerecord//lib/active_record/scoping/default.rb#19
    def default_scopes; end

    # source://activerecord//lib/active_record/scoping/default.rb#19
    def default_scopes=(value); end

    # source://activerecord//lib/active_record/core.rb#78
    def default_shard; end

    # source://activerecord//lib/active_record/core.rb#78
    def default_shard=(value); end

    # source://activerecord//lib/active_record/core.rb#78
    def default_shard?; end

    # source://activerecord//lib/active_record/enum.rb#116
    def defined_enums; end

    # source://activerecord//lib/active_record/enum.rb#116
    def defined_enums=(value); end

    # source://activerecord//lib/active_record/enum.rb#116
    def defined_enums?; end

    # source://activerecord//lib/active_record/core.rb#26
    def destroy_association_async_job; end

    # source://activerecord//lib/active_record/core.rb#26
    def destroy_association_async_job=(value); end

    # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
    def encrypted_attributes; end

    # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
    def encrypted_attributes=(value); end

    # source://activerecord//lib/active_record/encryption/encryptable_record.rb#11
    def encrypted_attributes?; end

    # source://activerecord//lib/active_record/core.rb#66
    def enumerate_columns_in_select_statements; end

    # source://activerecord//lib/active_record/core.rb#66
    def enumerate_columns_in_select_statements=(value); end

    # source://activerecord//lib/active_record/core.rb#66
    def enumerate_columns_in_select_statements?; end

    # source://activerecord//lib/active_record/core.rb#72
    def has_many_inversing; end

    # source://activerecord//lib/active_record/core.rb#72
    def has_many_inversing=(value); end

    # source://activerecord//lib/active_record/core.rb#72
    def has_many_inversing?; end

    # source://activerecord//lib/active_record/model_schema.rb#158
    def immutable_strings_by_default; end

    # source://activerecord//lib/active_record/model_schema.rb#158
    def immutable_strings_by_default=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#158
    def immutable_strings_by_default?; end

    # source://activerecord//lib/active_record/model_schema.rb#157
    def implicit_order_column; end

    # source://activerecord//lib/active_record/model_schema.rb#157
    def implicit_order_column=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#157
    def implicit_order_column?; end

    # source://activemodel/7.0.4/lib/active_model/serializers/json.rb#15
    def include_root_in_json; end

    # source://activemodel/7.0.4/lib/active_model/serializers/json.rb#15
    def include_root_in_json=(value); end

    # source://activemodel/7.0.4/lib/active_model/serializers/json.rb#15
    def include_root_in_json?; end

    # source://activerecord//lib/active_record/model_schema.rb#160
    def inheritance_column; end

    # source://activerecord//lib/active_record/model_schema.rb#311
    def inheritance_column=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#160
    def inheritance_column?; end

    # source://activerecord//lib/active_record/model_schema.rb#155
    def internal_metadata_table_name; end

    # source://activerecord//lib/active_record/model_schema.rb#155
    def internal_metadata_table_name=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#155
    def internal_metadata_table_name?; end

    # source://activerecord//lib/active_record/store.rb#99
    def local_stored_attributes; end

    # source://activerecord//lib/active_record/store.rb#99
    def local_stored_attributes=(_arg0); end

    # source://activerecord//lib/active_record/locking/optimistic.rb#56
    def lock_optimistically; end

    # source://activerecord//lib/active_record/locking/optimistic.rb#56
    def lock_optimistically=(value); end

    # source://activerecord//lib/active_record/locking/optimistic.rb#56
    def lock_optimistically?; end

    # source://activerecord//lib/active_record/core.rb#20
    def logger; end

    # source://activerecord//lib/active_record/core.rb#20
    def logger=(value); end

    # source://activerecord//lib/active_record/core.rb#20
    def logger?; end

    # source://activerecord//lib/active_record/nested_attributes.rb#15
    def nested_attributes_options; end

    # source://activerecord//lib/active_record/nested_attributes.rb#15
    def nested_attributes_options=(value); end

    # source://activerecord//lib/active_record/nested_attributes.rb#15
    def nested_attributes_options?; end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#18
    def partial_inserts; end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#18
    def partial_inserts=(value); end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#18
    def partial_inserts?; end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#17
    def partial_updates; end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#17
    def partial_updates=(value); end

    # source://activerecord//lib/active_record/attribute_methods/dirty.rb#17
    def partial_updates?; end

    # source://activerecord//lib/active_record/model_schema.rb#156
    def pluralize_table_names; end

    # source://activerecord//lib/active_record/model_schema.rb#156
    def pluralize_table_names=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#156
    def pluralize_table_names?; end

    # source://activerecord//lib/active_record/model_schema.rb#151
    def primary_key_prefix_type; end

    # source://activerecord//lib/active_record/model_schema.rb#151
    def primary_key_prefix_type=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#151
    def primary_key_prefix_type?; end

    # source://activerecord//lib/active_record/timestamp.rb#47
    def record_timestamps; end

    # source://activerecord//lib/active_record/timestamp.rb#47
    def record_timestamps=(value); end

    # source://activerecord//lib/active_record/timestamp.rb#47
    def record_timestamps?; end

    # source://activerecord//lib/active_record/model_schema.rb#154
    def schema_migrations_table_name; end

    # source://activerecord//lib/active_record/model_schema.rb#154
    def schema_migrations_table_name=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#154
    def schema_migrations_table_name?; end

    # source://activerecord//lib/active_record/core.rb#80
    def shard_selector; end

    # source://activerecord//lib/active_record/core.rb#80
    def shard_selector=(value); end

    # source://activerecord//lib/active_record/core.rb#80
    def shard_selector?; end

    # source://activerecord//lib/active_record/signed_id.rb#13
    def signed_id_verifier_secret; end

    # source://activerecord//lib/active_record/signed_id.rb#13
    def signed_id_verifier_secret=(value); end

    # source://activerecord//lib/active_record/signed_id.rb#13
    def signed_id_verifier_secret?; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#71
    def skip_time_zone_conversion_for_attributes; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#71
    def skip_time_zone_conversion_for_attributes=(value); end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#71
    def skip_time_zone_conversion_for_attributes?; end

    # source://activerecord//lib/active_record/inheritance.rb#42
    def store_full_class_name; end

    # source://activerecord//lib/active_record/inheritance.rb#42
    def store_full_class_name=(value); end

    # source://activerecord//lib/active_record/inheritance.rb#42
    def store_full_class_name?; end

    # source://activerecord//lib/active_record/inheritance.rb#46
    def store_full_sti_class; end

    # source://activerecord//lib/active_record/inheritance.rb#46
    def store_full_sti_class=(value); end

    # source://activerecord//lib/active_record/inheritance.rb#46
    def store_full_sti_class?; end

    # source://activerecord//lib/active_record/core.rb#70
    def strict_loading_by_default; end

    # source://activerecord//lib/active_record/core.rb#70
    def strict_loading_by_default=(value); end

    # source://activerecord//lib/active_record/core.rb#70
    def strict_loading_by_default?; end

    # source://activerecord//lib/active_record/core.rb#238
    def strict_loading_violation!(owner:, reflection:); end

    # source://activerecord//lib/active_record/model_schema.rb#152
    def table_name_prefix; end

    # source://activerecord//lib/active_record/model_schema.rb#152
    def table_name_prefix=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#152
    def table_name_prefix?; end

    # source://activerecord//lib/active_record/model_schema.rb#153
    def table_name_suffix; end

    # source://activerecord//lib/active_record/model_schema.rb#153
    def table_name_suffix=(value); end

    # source://activerecord//lib/active_record/model_schema.rb#153
    def table_name_suffix?; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#70
    def time_zone_aware_attributes; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#70
    def time_zone_aware_attributes=(value); end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#70
    def time_zone_aware_attributes?; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#72
    def time_zone_aware_types; end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#72
    def time_zone_aware_types=(value); end

    # source://activerecord//lib/active_record/attribute_methods/time_zone_conversion.rb#72
    def time_zone_aware_types?; end

    private

    # source://activerecord//lib/active_record/model_schema.rb#160
    def _inheritance_column=(value); end
  end
end

module ActiveRecord::Base::GeneratedAssociationMethods; end
module ActiveRecord::Base::GeneratedAttributeMethods; end

module ActiveRecord::Batches
  # Looping through a collection of records from the database
  # (using the Scoping::Named::ClassMethods.all method, for example)
  # is very inefficient since it will try to instantiate all the objects at once.
  #
  # In that case, batch processing methods allow you to work
  # with the records in batches, thereby greatly reducing memory consumption.
  #
  # The #find_each method uses #find_in_batches with a batch size of 1000 (or as
  # specified by the +:batch_size+ option).
  #
  #   Person.find_each do |person|
  #     person.do_awesome_stuff
  #   end
  #
  #   Person.where("age > 21").find_each do |person|
  #     person.party_all_night!
  #   end
  #
  # If you do not provide a block to #find_each, it will return an Enumerator
  # for chaining with other methods:
  #
  #   Person.find_each.with_index do |person, index|
  #     person.award_trophy(index + 1)
  #   end
  #
  # ==== Options
  # * <tt>:batch_size</tt> - Specifies the size of the batch. Defaults to 1000.
  # * <tt>:start</tt> - Specifies the primary key value to start from, inclusive of the value.
  # * <tt>:finish</tt> - Specifies the primary key value to end at, inclusive of the value.
  # * <tt>:error_on_ignore</tt> - Overrides the application config to specify if an error should be raised when
  #   an order is present in the relation.
  # * <tt>:order</tt> - Specifies the primary key order (can be +:asc+ or +:desc+). Defaults to +:asc+.
  #
  # Limits are honored, and if present there is no requirement for the batch
  # size: it can be less than, equal to, or greater than the limit.
  #
  # The options +start+ and +finish+ are especially useful if you want
  # multiple workers dealing with the same processing queue. You can make
  # worker 1 handle all the records between id 1 and 9999 and worker 2
  # handle from 10000 and beyond by setting the +:start+ and +:finish+
  # option on each worker.
  #
  #   # In worker 1, let's process until 9999 records.
  #   Person.find_each(finish: 9_999) do |person|
  #     person.party_all_night!
  #   end
  #
  #   # In worker 2, let's process from record 10_000 and onwards.
  #   Person.find_each(start: 10_000) do |person|
  #     person.party_all_night!
  #   end
  #
  # NOTE: Order can be ascending (:asc) or descending (:desc). It is automatically set to
  # ascending on the primary key ("id ASC").
  # This also means that this method only works when the primary key is
  # orderable (e.g. an integer or string).
  #
  # NOTE: By its nature, batch processing is subject to race conditions if
  # other processes are modifying the database.
  #
  # source://activerecord//lib/active_record/relation/batches.rb#68
  def find_each(start: T.unsafe(nil), finish: T.unsafe(nil), batch_size: T.unsafe(nil), error_on_ignore: T.unsafe(nil), order: T.unsafe(nil), &block); end

  # Yields each batch of records that was found by the find options as
  # an array.
  #
  #   Person.where("age > 21").find_in_batches do |group|
  #     sleep(50) # Make sure it doesn't get too crowded in there!
  #     group.each { |person| person.party_all_night! }
  #   end
  #
  # If you do not provide a block to #find_in_batches, it will return an Enumerator
  # for chaining with other methods:
  #
  #   Person.find_in_batches.with_index do |group, batch|
  #     puts "Processing group ##{batch}"
  #     group.each(&:recover_from_last_night!)
  #   end
  #
  # To be yielded each record one by one, use #find_each instead.
  #
  # ==== Options
  # * <tt>:batch_size</tt> - Specifies the size of the batch. Defaults to 1000.
  # * <tt>:start</tt> - Specifies the primary key value to start from, inclusive of the value.
  # * <tt>:finish</tt> - Specifies the primary key value to end at, inclusive of the value.
  # * <tt>:error_on_ignore</tt> - Overrides the application config to specify if an error should be raised when
  #   an order is present in the relation.
  # * <tt>:order</tt> - Specifies the primary key order (can be +:asc+ or +:desc+). Defaults to +:asc+.
  #
  # Limits are honored, and if present there is no requirement for the batch
  # size: it can be less than, equal to, or greater than the limit.
  #
  # The options +start+ and +finish+ are especially useful if you want
  # multiple workers dealing with the same processing queue. You can make
  # worker 1 handle all the records between id 1 and 9999 and worker 2
  # handle from 10000 and beyond by setting the +:start+ and +:finish+
  # option on each worker.
  #
  #   # Let's process from record 10_000 on.
  #   Person.find_in_batches(start: 10_000) do |group|
  #     group.each { |person| person.party_all_night! }
  #   end
  #
  # NOTE: Order can be ascending (:asc) or descending (:desc). It is automatically set to
  # ascending on the primary key ("id ASC").
  # This also means that this method only works when the primary key is
  # orderable (e.g. an integer or string).
  #
  # NOTE: By its nature, batch processing is subject to race conditions if
  # other processes are modifying the database.
  #
  # source://activerecord//lib/active_record/relation/batches.rb#128
  def find_in_batches(start: T.unsafe(nil), finish: T.unsafe(nil), batch_size: T.unsafe(nil), error_on_ignore: T.unsafe(nil), order: T.unsafe(nil)); end

  # Yields ActiveRecord::Relation objects to work with a batch of records.
  #
  #   Person.where("age > 21").in_batches do |relation|
  #     relation.delete_all
  #     sleep(10) # Throttle the delete queries
  #   end
  #
  # If you do not provide a block to #in_batches, it will return a
  # BatchEnumerator which is enumerable.
  #
  #   Person.in_batches.each_with_index do |relation, batch_index|
  #     puts "Processing relation ##{batch_index}"
  #     relation.delete_all
  #   end
  #
  # Examples of calling methods on the returned BatchEnumerator object:
  #
  #   Person.in_batches.delete_all
  #   Person.in_batches.update_all(awesome: true)
  #   Person.in_batches.each_record(&:party_all_night!)
  #
  # ==== Options
  # * <tt>:of</tt> - Specifies the size of the batch. Defaults to 1000.
  # * <tt>:load</tt> - Specifies if the relation should be loaded. Defaults to false.
  # * <tt>:start</tt> - Specifies the primary key value to start from, inclusive of the value.
  # * <tt>:finish</tt> - Specifies the primary key value to end at, inclusive of the value.
  # * <tt>:error_on_ignore</tt> - Overrides the application config to specify if an error should be raised when
  #   an order is present in the relation.
  # * <tt>:order</tt> - Specifies the primary key order (can be +:asc+ or +:desc+). Defaults to +:asc+.
  #
  # Limits are honored, and if present there is no requirement for the batch
  # size, it can be less than, equal, or greater than the limit.
  #
  # The options +start+ and +finish+ are especially useful if you want
  # multiple workers dealing with the same processing queue. You can make
  # worker 1 handle all the records between id 1 and 9999 and worker 2
  # handle from 10000 and beyond by setting the +:start+ and +:finish+
  # option on each worker.
  #
  #   # Let's process from record 10_000 on.
  #   Person.in_batches(start: 10_000).update_all(awesome: true)
  #
  # An example of calling where query method on the relation:
  #
  #   Person.in_batches.each do |relation|
  #     relation.update_all('age = age + 1')
  #     relation.where('age > 21').update_all(should_party: true)
  #     relation.where('age <= 21').delete_all
  #   end
  #
  # NOTE: If you are going to iterate through each record, you should call
  # #each_record on the yielded BatchEnumerator:
  #
  #   Person.in_batches.each_record(&:party_all_night!)
  #
  # NOTE: Order can be ascending (:asc) or descending (:desc). It is automatically set to
  # ascending on the primary key ("id ASC").
  # This also means that this method only works when the primary key is
  # orderable (e.g. an integer or string).
  #
  # NOTE: By its nature, batch processing is subject to race conditions if
  # other processes are modifying the database.
  #
  # source://activerecord//lib/active_record/relation/batches.rb#204
  def in_batches(of: T.unsafe(nil), start: T.unsafe(nil), finish: T.unsafe(nil), load: T.unsafe(nil), error_on_ignore: T.unsafe(nil), order: T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/relation/batches.rb#286
  def act_on_ignored_order(error_on_ignore); end

  # source://activerecord//lib/active_record/relation/batches.rb#278
  def apply_finish_limit(relation, finish, order); end

  # source://activerecord//lib/active_record/relation/batches.rb#268
  def apply_limits(relation, start, finish, order); end

  # source://activerecord//lib/active_record/relation/batches.rb#274
  def apply_start_limit(relation, start, order); end

  # source://activerecord//lib/active_record/relation/batches.rb#282
  def batch_order(order); end
end

class ActiveRecord::Batches::BatchEnumerator
  include ::Enumerable

  # @return [BatchEnumerator] a new instance of BatchEnumerator
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#8
  def initialize(relation:, of: T.unsafe(nil), start: T.unsafe(nil), finish: T.unsafe(nil)); end

  # The size of the batches yielded by the BatchEnumerator.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#25
  def batch_size; end

  # Deletes records in batches. Returns the total number of rows affected.
  #
  #   Person.in_batches.delete_all
  #
  # See Relation#delete_all for details of how each batch is deleted.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#63
  def delete_all; end

  # Destroys records in batches.
  #
  #   Person.where("age < 10").in_batches.destroy_all
  #
  # See Relation#destroy_all for details of how each batch is destroyed.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#83
  def destroy_all; end

  # Yields an ActiveRecord::Relation object for each batch of records.
  #
  #   Person.in_batches.each do |relation|
  #     relation.update_all(awesome: true)
  #   end
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#92
  def each(&block); end

  # Looping through a collection of records from the database (using the
  # +all+ method, for example) is very inefficient since it will try to
  # instantiate all the objects at once.
  #
  # In that case, batch processing methods allow you to work with the
  # records in batches, thereby greatly reducing memory consumption.
  #
  #   Person.in_batches.each_record do |person|
  #     person.do_awesome_stuff
  #   end
  #
  #   Person.where("age > 21").in_batches(of: 10).each_record do |person|
  #     person.party_all_night!
  #   end
  #
  # If you do not provide a block to #each_record, it will return an Enumerator
  # for chaining with other methods:
  #
  #   Person.in_batches.each_record.with_index do |person, index|
  #     person.award_trophy(index + 1)
  #   end
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#50
  def each_record(&block); end

  # The primary key value at which the BatchEnumerator ends, inclusive of the value.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#19
  def finish; end

  # The relation from which the BatchEnumerator yields batches.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#22
  def relation; end

  # The primary key value from which the BatchEnumerator starts, inclusive of the value.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#16
  def start; end

  # Updates records in batches. Returns the total number of rows affected.
  #
  #   Person.in_batches.update_all("age = age + 1")
  #
  # See Relation#update_all for details of how each batch is updated.
  #
  # source://activerecord//lib/active_record/relation/batches/batch_enumerator.rb#72
  def update_all(updates); end
end

# source://activerecord//lib/active_record/relation/batches.rb#7
ActiveRecord::Batches::ORDER_IGNORE_MESSAGE = T.let(T.unsafe(nil), String)

module ActiveRecord::Calculations
  # Calculates the average value on a given column. Returns +nil+ if there's
  # no row. See #calculate for examples with options.
  #
  #   Person.average(:age) # => 35.8
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#59
  def average(column_name); end

  # This calculates aggregate values in the given column. Methods for #count, #sum, #average,
  # #minimum, and #maximum have been added as shortcuts.
  #
  #   Person.calculate(:count, :all) # The same as Person.count
  #   Person.average(:age) # SELECT AVG(age) FROM people...
  #
  #   # Selects the minimum age for any family without any minors
  #   Person.group(:last_name).having("min(age) > 17").minimum(:age)
  #
  #   Person.sum("2 * age")
  #
  # There are two basic forms of output:
  #
  # * Single aggregate value: The single value is type cast to Integer for COUNT, Float
  #   for AVG, and the given column's type for everything else.
  #
  # * Grouped values: This returns an ordered hash of the values and groups them. It
  #   takes either a column name, or the name of a belongs_to association.
  #
  #      values = Person.group('last_name').maximum(:age)
  #      puts values["Drake"]
  #      # => 43
  #
  #      drake  = Family.find_by(last_name: 'Drake')
  #      values = Person.group(:family).maximum(:age) # Person belongs_to :family
  #      puts values[drake]
  #      # => 43
  #
  #      values.each do |family, max_age|
  #        ...
  #      end
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#138
  def calculate(operation, column_name); end

  # Count the records.
  #
  #   Person.count
  #   # => the total count of all people
  #
  #   Person.count(:age)
  #   # => returns the total count of all people whose age is present in database
  #
  #   Person.count(:all)
  #   # => performs a COUNT(*) (:all is an alias for '*')
  #
  #   Person.distinct.count(:age)
  #   # => counts the number of different age values
  #
  # If #count is used with {Relation#group}[rdoc-ref:QueryMethods#group],
  # it returns a Hash whose keys represent the aggregated column,
  # and the values are the respective amounts:
  #
  #   Person.group(:city).count
  #   # => { 'Rome' => 5, 'Paris' => 3 }
  #
  # If #count is used with {Relation#group}[rdoc-ref:QueryMethods#group] for multiple columns, it returns a Hash whose
  # keys are an array containing the individual values of each column and the value
  # of each key would be the #count.
  #
  #   Article.group(:status, :category).count
  #   # =>  {["draft", "business"]=>10, ["draft", "technology"]=>4,
  #   #      ["published", "business"]=>0, ["published", "technology"]=>2}
  #
  # If #count is used with {Relation#select}[rdoc-ref:QueryMethods#select], it will count the selected columns:
  #
  #   Person.select(:age).count
  #   # => counts the number of different age values
  #
  # Note: not all valid {Relation#select}[rdoc-ref:QueryMethods#select] expressions are valid #count expressions. The specifics differ
  # between databases. In invalid cases, an error from the database is thrown.
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#43
  def count(column_name = T.unsafe(nil)); end

  # Pluck all the ID's for the relation using the table's primary key
  #
  #   Person.ids # SELECT people.id FROM people
  #   Person.joins(:companies).ids # SELECT people.id FROM people INNER JOIN companies ON companies.person_id = people.id
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#242
  def ids; end

  # Calculates the maximum value on a given column. The value is returned
  # with the same data type of the column, or +nil+ if there's no row. See
  # #calculate for examples with options.
  #
  #   Person.maximum(:age) # => 93
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#77
  def maximum(column_name); end

  # Calculates the minimum value on a given column. The value is returned
  # with the same data type of the column, or +nil+ if there's no row. See
  # #calculate for examples with options.
  #
  #   Person.minimum(:age) # => 7
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#68
  def minimum(column_name); end

  # Pick the value(s) from the named column(s) in the current relation.
  # This is short-hand for <tt>relation.limit(1).pluck(*column_names).first</tt>, and is primarily useful
  # when you have a relation that's already narrowed down to a single row.
  #
  # Just like #pluck, #pick will only load the actual value, not the entire record object, so it's also
  # more efficient. The value is, again like with pluck, typecast by the column type.
  #
  #   Person.where(id: 1).pick(:name)
  #   # SELECT people.name FROM people WHERE id = 1 LIMIT 1
  #   # => 'David'
  #
  #   Person.where(id: 1).pick(:name, :email_address)
  #   # SELECT people.name, people.email_address FROM people WHERE id = 1 LIMIT 1
  #   # => [ 'David', 'david@loudthinking.com' ]
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#230
  def pick(*column_names); end

  # Use #pluck as a shortcut to select one or more attributes without
  # loading an entire record object per row.
  #
  #   Person.pluck(:name)
  #
  # instead of
  #
  #   Person.all.map(&:name)
  #
  # Pluck returns an Array of attribute values type-casted to match
  # the plucked column names, if they can be deduced. Plucking an SQL fragment
  # returns String values by default.
  #
  #   Person.pluck(:name)
  #   # SELECT people.name FROM people
  #   # => ['David', 'Jeremy', 'Jose']
  #
  #   Person.pluck(:id, :name)
  #   # SELECT people.id, people.name FROM people
  #   # => [[1, 'David'], [2, 'Jeremy'], [3, 'Jose']]
  #
  #   Person.distinct.pluck(:role)
  #   # SELECT DISTINCT role FROM people
  #   # => ['admin', 'member', 'guest']
  #
  #   Person.where(age: 21).limit(5).pluck(:id)
  #   # SELECT people.id FROM people WHERE people.age = 21 LIMIT 5
  #   # => [2, 3]
  #
  #   Person.pluck(Arel.sql('DATEDIFF(updated_at, created_at)'))
  #   # SELECT DATEDIFF(updated_at, created_at) FROM people
  #   # => ['0', '27761', '173']
  #
  # See also #ids.
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#192
  def pluck(*column_names); end

  # Calculates the sum of values on a given column. The value is returned
  # with the same data type of the column, +0+ if there's no row. See
  # #calculate for examples with options.
  #
  #   Person.sum(:age) # => 4562
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#86
  def sum(identity_or_column = T.unsafe(nil), &block); end

  private

  # source://activerecord//lib/active_record/relation/calculations.rb#286
  def aggregate_column(column_name); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#247
  def all_attributes?(column_names); end

  # source://activerecord//lib/active_record/relation/calculations.rb#475
  def build_count_subquery(relation, column_name, distinct); end

  # Converts the given field to the value that the database adapter returns as
  # a usable column name:
  #
  #   column_alias_for("users.id")                 # => "users_id"
  #   column_alias_for("sum(id)")                  # => "sum_id"
  #   column_alias_for("count(distinct users.id)") # => "count_distinct_users_id"
  #   column_alias_for("count(*)")                 # => "count_all"
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#408
  def column_alias_for(field); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#282
  def distinct_select?(column_name); end

  # source://activerecord//lib/active_record/relation/calculations.rb#328
  def execute_grouped_calculation(operation, column_name, distinct); end

  # source://activerecord//lib/active_record/relation/calculations.rb#298
  def execute_simple_calculation(operation, column_name, distinct); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/calculations.rb#251
  def has_include?(column_name); end

  # source://activerecord//lib/active_record/relation/calculations.rb#423
  def lookup_cast_type_from_join_dependencies(name, join_dependencies = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/calculations.rb#294
  def operation_over_aggregate_column(column, operation, distinct); end

  # source://activerecord//lib/active_record/relation/calculations.rb#255
  def perform_calculation(operation, column_name); end

  # source://activerecord//lib/active_record/relation/calculations.rb#466
  def select_for_count; end

  # source://activerecord//lib/active_record/relation/calculations.rb#448
  def type_cast_calculated_value(value, operation, type); end

  # source://activerecord//lib/active_record/relation/calculations.rb#431
  def type_cast_pluck_values(result, columns); end

  # source://activerecord//lib/active_record/relation/calculations.rb#418
  def type_for(field, &block); end
end

# = Active Record \Callbacks
#
# \Callbacks are hooks into the life cycle of an Active Record object that allow you to trigger logic
# before or after a change in the object state. This can be used to make sure that associated and
# dependent objects are deleted when {ActiveRecord::Base#destroy}[rdoc-ref:Persistence#destroy] is called (by overwriting +before_destroy+) or
# to massage attributes before they're validated (by overwriting +before_validation+).
# As an example of the callbacks initiated, consider the {ActiveRecord::Base#save}[rdoc-ref:Persistence#save] call for a new record:
#
# * (-) <tt>save</tt>
# * (-) <tt>valid</tt>
# * (1) <tt>before_validation</tt>
# * (-) <tt>validate</tt>
# * (2) <tt>after_validation</tt>
# * (3) <tt>before_save</tt>
# * (4) <tt>before_create</tt>
# * (-) <tt>create</tt>
# * (5) <tt>after_create</tt>
# * (6) <tt>after_save</tt>
# * (7) <tt>after_commit</tt>
#
# Also, an <tt>after_rollback</tt> callback can be configured to be triggered whenever a rollback is issued.
# Check out ActiveRecord::Transactions for more details about <tt>after_commit</tt> and
# <tt>after_rollback</tt>.
#
# Additionally, an <tt>after_touch</tt> callback is triggered whenever an
# object is touched.
#
# Lastly an <tt>after_find</tt> and <tt>after_initialize</tt> callback is triggered for each object that
# is found and instantiated by a finder, with <tt>after_initialize</tt> being triggered after new objects
# are instantiated as well.
#
# There are nineteen callbacks in total, which give a lot of control over how to react and prepare for each state in the
# Active Record life cycle. The sequence for calling {ActiveRecord::Base#save}[rdoc-ref:Persistence#save] for an existing record is similar,
# except that each <tt>_create</tt> callback is replaced by the corresponding <tt>_update</tt> callback.
#
# Examples:
#   class CreditCard < ActiveRecord::Base
#     # Strip everything but digits, so the user can specify "555 234 34" or
#     # "5552-3434" and both will mean "55523434"
#     before_validation(on: :create) do
#       self.number = number.gsub(/[^0-9]/, "") if attribute_present?("number")
#     end
#   end
#
#   class Subscription < ActiveRecord::Base
#     before_create :record_signup
#
#     private
#       def record_signup
#         self.signed_up_on = Date.today
#       end
#   end
#
#   class Firm < ActiveRecord::Base
#     # Disables access to the system, for associated clients and people when the firm is destroyed
#     before_destroy { |record| Person.where(firm_id: record.id).update_all(access: 'disabled')   }
#     before_destroy { |record| Client.where(client_of: record.id).update_all(access: 'disabled') }
#   end
#
# == Inheritable callback queues
#
# Besides the overwritable callback methods, it's also possible to register callbacks through the
# use of the callback macros. Their main advantage is that the macros add behavior into a callback
# queue that is kept intact through an inheritance hierarchy.
#
#   class Topic < ActiveRecord::Base
#     before_destroy :destroy_author
#   end
#
#   class Reply < Topic
#     before_destroy :destroy_readers
#   end
#
# When <tt>Topic#destroy</tt> is run only +destroy_author+ is called. When <tt>Reply#destroy</tt> is
# run, both +destroy_author+ and +destroy_readers+ are called.
#
# *IMPORTANT:* In order for inheritance to work for the callback queues, you must specify the
# callbacks before specifying the associations. Otherwise, you might trigger the loading of a
# child before the parent has registered the callbacks and they won't be inherited.
#
# == Types of callbacks
#
# There are three types of callbacks accepted by the callback macros: method references (symbol), callback objects,
# inline methods (using a proc). Method references and callback objects are the recommended approaches,
# inline methods using a proc are sometimes appropriate (such as for creating mix-ins).
#
# The method reference callbacks work by specifying a protected or private method available in the object, like this:
#
#   class Topic < ActiveRecord::Base
#     before_destroy :delete_parents
#
#     private
#       def delete_parents
#         self.class.delete_by(parent_id: id)
#       end
#   end
#
# The callback objects have methods named after the callback called with the record as the only parameter, such as:
#
#   class BankAccount < ActiveRecord::Base
#     before_save      EncryptionWrapper.new
#     after_save       EncryptionWrapper.new
#     after_initialize EncryptionWrapper.new
#   end
#
#   class EncryptionWrapper
#     def before_save(record)
#       record.credit_card_number = encrypt(record.credit_card_number)
#     end
#
#     def after_save(record)
#       record.credit_card_number = decrypt(record.credit_card_number)
#     end
#
#     alias_method :after_initialize, :after_save
#
#     private
#       def encrypt(value)
#         # Secrecy is committed
#       end
#
#       def decrypt(value)
#         # Secrecy is unveiled
#       end
#   end
#
# So you specify the object you want to be messaged on a given callback. When that callback is triggered, the object has
# a method by the name of the callback messaged. You can make these callbacks more flexible by passing in other
# initialization data such as the name of the attribute to work with:
#
#   class BankAccount < ActiveRecord::Base
#     before_save      EncryptionWrapper.new("credit_card_number")
#     after_save       EncryptionWrapper.new("credit_card_number")
#     after_initialize EncryptionWrapper.new("credit_card_number")
#   end
#
#   class EncryptionWrapper
#     def initialize(attribute)
#       @attribute = attribute
#     end
#
#     def before_save(record)
#       record.send("#{@attribute}=", encrypt(record.send("#{@attribute}")))
#     end
#
#     def after_save(record)
#       record.send("#{@attribute}=", decrypt(record.send("#{@attribute}")))
#     end
#
#     alias_method :after_initialize, :after_save
#
#     private
#       def encrypt(value)
#         # Secrecy is committed
#       end
#
#       def decrypt(value)
#         # Secrecy is unveiled
#       end
#   end
#
# == <tt>before_validation*</tt> returning statements
#
# If the +before_validation+ callback throws +:abort+, the process will be
# aborted and {ActiveRecord::Base#save}[rdoc-ref:Persistence#save] will return +false+.
# If {ActiveRecord::Base#save!}[rdoc-ref:Persistence#save!] is called it will raise an ActiveRecord::RecordInvalid exception.
# Nothing will be appended to the errors object.
#
# == Canceling callbacks
#
# If a <tt>before_*</tt> callback throws +:abort+, all the later callbacks and
# the associated action are cancelled.
# Callbacks are generally run in the order they are defined, with the exception of callbacks defined as
# methods on the model, which are called last.
#
# == Ordering callbacks
#
# Sometimes application code requires that callbacks execute in a specific order. For example, a +before_destroy+
# callback (+log_children+ in this case) should be executed before records in the +children+ association are destroyed by the
# <tt>dependent: :destroy</tt> option.
#
# Let's look at the code below:
#
#   class Topic < ActiveRecord::Base
#     has_many :children, dependent: :destroy
#
#     before_destroy :log_children
#
#     private
#       def log_children
#         # Child processing
#       end
#   end
#
# In this case, the problem is that when the +before_destroy+ callback is executed, records in the +children+ association no
# longer exist because the {ActiveRecord::Base#destroy}[rdoc-ref:Persistence#destroy] callback was executed first.
# You can use the +prepend+ option on the +before_destroy+ callback to avoid this.
#
#   class Topic < ActiveRecord::Base
#     has_many :children, dependent: :destroy
#
#     before_destroy :log_children, prepend: true
#
#     private
#       def log_children
#         # Child processing
#       end
#   end
#
# This way, the +before_destroy+ is executed before the <tt>dependent: :destroy</tt> is called, and the data is still available.
#
# Also, there are cases when you want several callbacks of the same type to
# be executed in order.
#
# For example:
#
#   class Topic < ActiveRecord::Base
#     has_many :children
#
#     after_save :log_children
#     after_save :do_something_else
#
#     private
#
#     def log_children
#       # Child processing
#     end
#
#     def do_something_else
#       # Something else
#     end
#   end
#
# In this case the +log_children+ is executed before +do_something_else+.
# The same applies to all non-transactional callbacks.
#
# As seen below, in case there are multiple transactional callbacks the order
# is reversed.
#
# For example:
#
#   class Topic < ActiveRecord::Base
#     has_many :children
#
#     after_commit :log_children
#     after_commit :do_something_else
#
#     private
#
#     def log_children
#       # Child processing
#     end
#
#     def do_something_else
#       # Something else
#     end
#   end
#
# In this case the +do_something_else+ is executed before +log_children+.
#
# == \Transactions
#
# The entire callback chain of a {#save}[rdoc-ref:Persistence#save], {#save!}[rdoc-ref:Persistence#save!],
# or {#destroy}[rdoc-ref:Persistence#destroy] call runs within a transaction. That includes <tt>after_*</tt> hooks.
# If everything goes fine a +COMMIT+ is executed once the chain has been completed.
#
# If a <tt>before_*</tt> callback cancels the action a +ROLLBACK+ is issued. You
# can also trigger a +ROLLBACK+ raising an exception in any of the callbacks,
# including <tt>after_*</tt> hooks. Note, however, that in that case the client
# needs to be aware of it because an ordinary {#save}[rdoc-ref:Persistence#save] will raise such exception
# instead of quietly returning +false+.
#
# == Debugging callbacks
#
# The callback chain is accessible via the <tt>_*_callbacks</tt> method on an object. Active Model \Callbacks support
# <tt>:before</tt>, <tt>:after</tt> and <tt>:around</tt> as values for the <tt>kind</tt> property. The <tt>kind</tt> property
# defines what part of the chain the callback runs in.
#
# To find all callbacks in the +before_save+ callback chain:
#
#   Topic._save_callbacks.select { |cb| cb.kind.eql?(:before) }
#
# Returns an array of callback objects that form the +before_save+ chain.
#
# To further check if the before_save chain contains a proc defined as <tt>rest_when_dead</tt> use the <tt>filter</tt> property of the callback object:
#
#   Topic._save_callbacks.select { |cb| cb.kind.eql?(:before) }.collect(&:filter).include?(:rest_when_dead)
#
# Returns true or false depending on whether the proc is contained in the +before_save+ callback chain on a Topic model.
module ActiveRecord::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveModel::Validations::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker

  # source://activerecord//lib/active_record/callbacks.rb#435
  def destroy; end

  # source://activerecord//lib/active_record/callbacks.rb#451
  def increment!(attribute, by = T.unsafe(nil), touch: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/callbacks.rb#447
  def touch(*_arg0, **_arg1); end

  private

  # source://activerecord//lib/active_record/callbacks.rb#460
  def _create_record; end

  # source://activerecord//lib/active_record/callbacks.rb#464
  def _update_record; end

  # source://activerecord//lib/active_record/callbacks.rb#456
  def create_or_update(**_arg0); end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://activerecord//lib/active_record/callbacks.rb#297
ActiveRecord::Callbacks::CALLBACKS = T.let(T.unsafe(nil), Array)

module ActiveRecord::Callbacks::ClassMethods
  include ::ActiveModel::Callbacks
end

module ActiveRecord::Coders; end

class ActiveRecord::Coders::JSON
  class << self
    # source://activerecord//lib/active_record/coders/json.rb#6
    def dump(obj); end

    # source://activerecord//lib/active_record/coders/json.rb#10
    def load(json); end
  end
end

class ActiveRecord::Coders::YAMLColumn
  # @return [YAMLColumn] a new instance of YAMLColumn
  #
  # source://activerecord//lib/active_record/coders/yaml_column.rb#10
  def initialize(attr_name, object_class = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/coders/yaml_column.rb#34
  def assert_valid_value(obj, action:); end

  # source://activerecord//lib/active_record/coders/yaml_column.rb#16
  def dump(obj); end

  # source://activerecord//lib/active_record/coders/yaml_column.rb#23
  def load(yaml); end

  # Returns the value of attribute object_class.
  #
  # source://activerecord//lib/active_record/coders/yaml_column.rb#8
  def object_class; end

  # Sets the attribute object_class
  #
  # @param value the value to set the attribute object_class to.
  #
  # source://activerecord//lib/active_record/coders/yaml_column.rb#8
  def object_class=(_arg0); end

  private

  # source://activerecord//lib/active_record/coders/yaml_column.rb#42
  def check_arity_of_constructor; end

  # source://activerecord//lib/active_record/coders/yaml_column.rb#49
  def yaml_load(payload); end
end

class ActiveRecord::ConcurrentMigrationError < ::ActiveRecord::MigrationError
  # @return [ConcurrentMigrationError] a new instance of ConcurrentMigrationError
  #
  # source://activerecord//lib/active_record/migration.rb#172
  def initialize(message = T.unsafe(nil)); end
end

# source://activerecord//lib/active_record/migration.rb#169
ActiveRecord::ConcurrentMigrationError::DEFAULT_MESSAGE = T.let(T.unsafe(nil), String)

# source://activerecord//lib/active_record/migration.rb#170
ActiveRecord::ConcurrentMigrationError::RELEASE_LOCK_FAILED_MESSAGE = T.let(T.unsafe(nil), String)

# Raised when association is being configured improperly or user tries to use
# offset and limit together with
# {ActiveRecord::Base.has_many}[rdoc-ref:Associations::ClassMethods#has_many] or
# {ActiveRecord::Base.has_and_belongs_to_many}[rdoc-ref:Associations::ClassMethods#has_and_belongs_to_many]
# associations.
class ActiveRecord::ConfigurationError < ::ActiveRecord::ActiveRecordError; end

module ActiveRecord::ConnectionAdapters
  extend ::ActiveSupport::Autoload
end

# Active Record supports multiple database systems. AbstractAdapter and
# related classes form the abstraction layer which makes this possible.
# An AbstractAdapter represents a connection to a database, and provides an
# abstract interface for database-specific functionality such as establishing
# a connection, escaping values, building the right SQL fragments for +:offset+
# and +:limit+ options, etc.
#
# All the concrete database adapters follow the interface laid down in this class.
# {ActiveRecord::Base.connection}[rdoc-ref:ConnectionHandling#connection] returns an AbstractAdapter object, which
# you can use.
#
# Most of the methods in the adapter are useful during migrations. Most
# notably, the instance methods provided by SchemaStatements are very useful.
class ActiveRecord::ConnectionAdapters::AbstractAdapter
  include ::ActiveSupport::Callbacks
  include ::ActiveRecord::Migration::JoinTable
  include ::ActiveRecord::ConnectionAdapters::SchemaStatements
  include ::ActiveRecord::ConnectionAdapters::DatabaseStatements
  include ::ActiveRecord::ConnectionAdapters::Quoting
  include ::ActiveRecord::ConnectionAdapters::DatabaseLimits
  include ::ActiveRecord::ConnectionAdapters::QueryCache
  include ::ActiveRecord::ConnectionAdapters::Savepoints
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker

  # @return [AbstractAdapter] a new instance of AbstractAdapter
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#82
  def initialize(connection, logger = T.unsafe(nil), config = T.unsafe(nil)); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks?; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _checkin_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _checkout_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_checkin_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_checkout_callbacks(&block); end

  # Checks whether the connection to the database is still active. This includes
  # checking whether the database is actually capable of responding, i.e. whether
  # the connection isn't stale.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#523
  def active?; end

  # Returns the human-readable name of the adapter. Use mixed case - one
  # can always use downcase if needed.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#292
  def adapter_name; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#478
  def advisory_locks_enabled?; end

  # Override to check all foreign key constraints in a database.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#514
  def all_foreign_keys_valid?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#461
  def async_enabled?; end

  # Called by ActiveRecord::InsertAll,
  # Passed an instance of ActiveRecord::InsertAll::Builder,
  # This method implements standard bulk inserts for all databases, but
  # should be overridden by adapters to implement common features with
  # non-standard syntax like handling duplicates or returning values.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#638
  def build_insert_sql(insert); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#609
  def case_insensitive_comparison(attribute, value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#605
  def case_sensitive_comparison(attribute, value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#118
  def check_if_write_query(sql); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#653
  def check_version; end

  # Clear any caching the database adapter may be doing.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#574
  def clear_cache!; end

  # Check the connection back in to the connection pool
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#625
  def close; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#223
  def connection_class; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def create(*_arg0); end

  # This is meant to be implemented by the adapters that support custom enum types
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#475
  def create_enum(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#649
  def database_version; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#629
  def default_index_type?(index); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#601
  def default_uniqueness_comparison(attribute, value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def delete(*_arg0); end

  # This is meant to be implemented by the adapters that support extensions
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#467
  def disable_extension(name); end

  # Override to turn off referential integrity while executing <tt>&block</tt>.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#509
  def disable_referential_integrity; end

  # Immediately forget this connection ever existed. Unlike disconnect!,
  # this will not communicate with the server.
  #
  # After calling this method, the behavior of all other methods becomes
  # undefined. This is called internally just before a forked process gets
  # rid of a connection that belonged to its parent.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#547
  def discard!; end

  # Disconnects from the database if already connected. Otherwise, this
  # method does nothing.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#536
  def disconnect!; end

  # This is meant to be implemented by the adapters that support extensions
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#471
  def enable_extension(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def exec_insert_all(*_arg0); end

  # this method must only be called while holding connection pool's mutex
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#249
  def expire; end

  # A list of extensions, to be filled in by adapters that support them.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#497
  def extensions; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#664
  def field_ordered_value(column, values); end

  # This is meant to be implemented by the adapters that support advisory
  # locks
  #
  # Return true if we got the lock, otherwise false
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#486
  def get_advisory_lock(lock_id); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#646
  def get_database_version; end

  # Returns the value of attribute owner.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#42
  def in_use?; end

  # A list of index algorithms, to be filled by adapters that support them.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#502
  def index_algorithms; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def insert(*_arg0); end

  # this method must only be called while holding connection pool's mutex
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#208
  def lease; end

  # Returns the value of attribute lock.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#42
  def lock; end

  # Returns the value of attribute logger.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#42
  def logger; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#153
  def migration_context; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#149
  def migrations_paths; end

  # Returns the value of attribute owner.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#42
  def owner; end

  # Returns the value of attribute pool.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#41
  def pool; end

  # Sets the attribute pool
  #
  # @param value the value to set the attribute pool to.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#41
  def pool=(_arg0); end

  # Should primary key values be selected from their corresponding
  # sequence before the insert statement? If true, next_sequence_value
  # is called before each insert to set the record's primary key.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#324
  def prefetch_primary_key?(table_name = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#175
  def prepared_statements; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#175
  def prepared_statements?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#180
  def prepared_statements_disabled_cache; end

  # Determines whether writes are currently being prevented.
  #
  # Returns true if the connection is a replica.
  #
  # If the application is using legacy handling, returns
  # true if +connection_handler.prevent_writes+ is set.
  #
  # If the application is using the new connection handling
  # will return true based on +current_preventing_writes+.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#141
  def preventing_writes?; end

  # Provides access to the underlying database driver for this adapter. For
  # example, this method returns a Mysql2::Client object in case of Mysql2Adapter,
  # and a PG::Connection object in case of PostgreSQLAdapter.
  #
  # This is useful for when you need to call a proprietary method such as
  # PostgreSQL's lo_* methods.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#596
  def raw_connection; end

  # Disconnects from the database if already connected, and establishes a
  # new connection with the database. Implementors should call super if they
  # override the default implementation.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#529
  def reconnect!; end

  # This is meant to be implemented by the adapters that support advisory
  # locks.
  #
  # Return true if we released the lock, otherwise false
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#493
  def release_advisory_lock(lock_id); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#124
  def replica?; end

  # Returns true if its required to reload the connection between requests for development mode.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#579
  def requires_reloading?; end

  # Reset the state of this connection, directing the DBMS to clear
  # transactions and other connection-related server-side state. Usually a
  # database-dependent operation.
  #
  # The default implementation does nothing; the implementation should be
  # overridden by concrete adapters.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#563
  def reset!; end

  # The role (e.g. +:writing+) for the current connection. In a
  # non-multi role application, +:writing+ is returned.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#229
  def role; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def rollback_db_transaction(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def rollback_to_savepoint(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#239
  def schema_cache; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#243
  def schema_cache=(cache); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#157
  def schema_migration; end

  # Returns the version identifier of the schema currently available in
  # the database. This is generally equal to the number of the highest-
  # numbered migration that has been executed, or 0 if no schema
  # information is present / the database is empty.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#660
  def schema_version; end

  # Seconds since this connection was returned to the pool
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#278
  def seconds_idle; end

  # The shard (e.g. +:default+) for the current connection. In
  # a non-sharded application, +:default+ is returned.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#235
  def shard; end

  # this method must only be called while holding connection pool's mutex (and a desire for segfaults)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#265
  def steal!; end

  # Does this adapter support application-enforced advisory locking?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#317
  def supports_advisory_locks?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#307
  def supports_bulk_alter?; end

  # Does this adapter support creating check constraints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#384
  def supports_check_constraints?; end

  # Does this adapter support metadata comments on database objects (tables, columns, indexes)?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#409
  def supports_comments?; end

  # Can comments for tables, columns, and indexes be specified in create/alter table statements?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#414
  def supports_comments_in_create?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#433
  def supports_common_table_expressions?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#457
  def supports_concurrent_connections?; end

  # Does this adapter support datetime with precision?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#399
  def supports_datetime_with_precision?; end

  # Does this adapter support DDL rollbacks in transactions? That is, would
  # CREATE TABLE or ALTER TABLE get rolled back by a transaction?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#303
  def supports_ddl_transactions?; end

  # Does this adapter support creating deferrable constraints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#379
  def supports_deferrable_constraints?; end

  # Does this adapter support explain?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#348
  def supports_explain?; end

  # Does this adapter support expression indices?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#343
  def supports_expression_index?; end

  # Does this adapter support database extensions?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#358
  def supports_extensions?; end

  # Does this adapter support creating foreign key constraints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#369
  def supports_foreign_keys?; end

  # Does this adapter support foreign/external tables?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#424
  def supports_foreign_tables?; end

  # Does this adapter support index sort order?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#333
  def supports_index_sort_order?; end

  # Does this adapter support creating indexes in the same statement as
  # creating the table?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#364
  def supports_indexes_in_create?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#453
  def supports_insert_conflict_target?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#445
  def supports_insert_on_duplicate_skip?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#449
  def supports_insert_on_duplicate_update?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#441
  def supports_insert_returning?; end

  # Does this adapter support json data type?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#404
  def supports_json?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#437
  def supports_lazy_transactions?; end

  # Does this adapter support materialized views?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#394
  def supports_materialized_views?; end

  # Does this adapter support optimizer hints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#429
  def supports_optimizer_hints?; end

  # Does this adapter support partial indices?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#338
  def supports_partial_index?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#328
  def supports_partitioned_indexes?; end

  # Does this adapter support savepoints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#312
  def supports_savepoints?; end

  # Does this adapter support setting the isolation level for a transaction?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#353
  def supports_transaction_isolation?; end

  # Does this adapter support creating invalid constraints?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#374
  def supports_validate_constraints?; end

  # Does this adapter support views?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#389
  def supports_views?; end

  # Does this adapter support virtual columns?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#419
  def supports_virtual_columns?; end

  # Removes the connection from the pool and disconnect it.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#568
  def throw_away!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def truncate(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def truncate_tables(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#283
  def unprepared_statement; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#20
  def update(*_arg0); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#128
  def use_metadata_table?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#203
  def valid_type?(type); end

  # Checks whether the connection to the database is still active (i.e. not stale).
  # This is done under the hood by calling #active?. If the connection
  # is no longer active, then this method will reconnect to the database.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#586
  def verify!; end

  # Returns the value of attribute visitor.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#42
  def visitor; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#108
  def with_instrumenter(instrumenter, &block); end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#817
  def arel_visitor; end

  # Builds the result object.
  #
  # This is an internal hook to make possible connection adapters to build
  # custom result objects with connection-specific data.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#828
  def build_result(columns:, rows:, column_types: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#821
  def build_statement_pool; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#619
  def can_perform_case_insensitive_comparison_for?(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#803
  def collector; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#792
  def column_for(table_name, column_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#798
  def column_for_attribute(attribute); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#755
  def log(sql, name = T.unsafe(nil), binds = T.unsafe(nil), type_casted_binds = T.unsafe(nil), statement_name = T.unsafe(nil), async: T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#771
  def transform_query(sql); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#778
  def translate_exception(exception, message:, sql:, binds:); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#745
  def translate_exception_class(e, sql, binds); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#741
  def type_map; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#788
  def without_prepared_statement?(binds); end

  class << self
    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks?; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _checkin_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _checkin_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _checkout_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _checkout_callbacks=(value); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#68
    def build_read_query_regexp(*parts); end

    # Does the database for this adapter exist?
    #
    # @raise [NotImplementedError]
    # @return [Boolean]
    #
    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#297
    def database_exists?(config); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#74
    def quoted_column_names; end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#78
    def quoted_table_names; end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#57
    def type_cast_config_to_boolean(config); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#47
    def type_cast_config_to_integer(config); end

    private

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#733
    def extract_limit(sql_type); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#729
    def extract_precision(sql_type); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#722
    def extract_scale(sql_type); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#675
    def initialize_type_map(m); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#708
    def register_class_with_limit(mapping, key, klass); end

    # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#715
    def register_class_with_precision(mapping, key, klass); end
  end
end

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#29
ActiveRecord::ConnectionAdapters::AbstractAdapter::ADAPTER_NAME = T.let(T.unsafe(nil), String)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#39
ActiveRecord::ConnectionAdapters::AbstractAdapter::COMMENT_REGEX = T.let(T.unsafe(nil), Regexp)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#65
ActiveRecord::ConnectionAdapters::AbstractAdapter::DEFAULT_READ_QUERY = T.let(T.unsafe(nil), Array)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#106
ActiveRecord::ConnectionAdapters::AbstractAdapter::EXCEPTION_IMMEDIATE = T.let(T.unsafe(nil), Hash)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#105
ActiveRecord::ConnectionAdapters::AbstractAdapter::EXCEPTION_NEVER = T.let(T.unsafe(nil), Hash)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#38
ActiveRecord::ConnectionAdapters::AbstractAdapter::SIMPLE_INT = T.let(T.unsafe(nil), Regexp)

# source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#738
ActiveRecord::ConnectionAdapters::AbstractAdapter::TYPE_MAP = T.let(T.unsafe(nil), ActiveRecord::Type::TypeMap)

class ActiveRecord::ConnectionAdapters::AbstractAdapter::Version
  include ::Comparable

  # @return [Version] a new instance of Version
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#189
  def initialize(version_string, full_version_string = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#194
  def <=>(version_string); end

  # Returns the value of attribute full_version_string.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#187
  def full_version_string; end

  # source://activerecord//lib/active_record/connection_adapters/abstract_adapter.rb#198
  def to_s; end
end

module ActiveRecord::ConnectionAdapters::AbstractPool
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#13
  def get_schema_cache(connection); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#23
  def lazily_set_schema_cache; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#19
  def set_schema_cache(cache); end
end

class ActiveRecord::ConnectionAdapters::AddColumnDefinition < ::Struct
  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def column; end

  # Sets the attribute column
  #
  # @param value [Object] the value to set the attribute column to.
  # @return [Object] the newly set value
  def column=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::ConnectionAdapters::AlterTable
  # @return [AlterTable] a new instance of AlterTable
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#535
  def initialize(td); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#554
  def add_check_constraint(expression, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#562
  def add_column(name, type, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#546
  def add_foreign_key(to_table, options); end

  # Returns the value of attribute adds.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#531
  def adds; end

  # Returns the value of attribute check_constraint_adds.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#533
  def check_constraint_adds; end

  # Returns the value of attribute check_constraint_drops.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#533
  def check_constraint_drops; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#558
  def drop_check_constraint(constraint_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#550
  def drop_foreign_key(name); end

  # Returns the value of attribute foreign_key_adds.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#532
  def foreign_key_adds; end

  # Returns the value of attribute foreign_key_drops.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#532
  def foreign_key_drops; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#544
  def name; end
end

class ActiveRecord::ConnectionAdapters::ChangeColumnDefinition < ::Struct
  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def column; end

  # Sets the attribute column
  #
  # @param value [Object] the value to set the attribute column to.
  # @return [Object] the newly set value
  def column=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::ConnectionAdapters::CheckConstraintDefinition < ::Struct
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#148
  def export_name_on_schema_dump?; end

  # Returns the value of attribute expression
  #
  # @return [Object] the current value of expression
  def expression; end

  # Sets the attribute expression
  #
  # @param value [Object] the value to set the attribute expression to.
  # @return [Object] the newly set value
  def expression=(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#139
  def name; end

  # Returns the value of attribute options
  #
  # @return [Object] the current value of options
  def options; end

  # Sets the attribute options
  #
  # @param value [Object] the value to set the attribute options to.
  # @return [Object] the newly set value
  def options=(_); end

  # Returns the value of attribute table_name
  #
  # @return [Object] the current value of table_name
  def table_name; end

  # Sets the attribute table_name
  #
  # @param value [Object] the value to set the attribute table_name to.
  # @return [Object] the newly set value
  def table_name=(_); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#143
  def validate?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#143
  def validated?; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# An abstract definition of a column in a table.
class ActiveRecord::ConnectionAdapters::Column
  include ::ActiveRecord::ConnectionAdapters::Deduplicable
  extend ::ActiveRecord::ConnectionAdapters::Deduplicable::ClassMethods

  # Instantiates a new column in the table.
  #
  # +name+ is the column's name, such as <tt>supplier_id</tt> in <tt>supplier_id bigint</tt>.
  # +default+ is the type-casted default value, such as +new+ in <tt>sales_stage varchar(20) default 'new'</tt>.
  # +sql_type_metadata+ is various information about the type of the column
  # +null+ determines if this column allows +NULL+ values.
  #
  # @return [Column] a new instance of Column
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#20
  def initialize(name, default, sql_type_metadata = T.unsafe(nil), null = T.unsafe(nil), default_function = T.unsafe(nil), collation: T.unsafe(nil), comment: T.unsafe(nil), **_arg7); end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#66
  def ==(other); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#34
  def bigint?; end

  # Returns the value of attribute collation.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def collation; end

  # Returns the value of attribute comment.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def comment; end

  # Returns the value of attribute default.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def default; end

  # Returns the value of attribute default_function.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def default_function; end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#56
  def encode_with(coder); end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#66
  def eql?(other); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#30
  def has_default?; end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#78
  def hash; end

  # Returns the human name of the column name.
  #
  # ===== Examples
  #  Column.new('sales_stage', ...).human_name # => 'Sales stage'
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#42
  def human_name; end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#46
  def init_with(coder); end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#12
  def limit(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def name; end

  # Returns the value of attribute null.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def null; end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#12
  def precision(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#12
  def scale(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#12
  def sql_type(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute sql_type_metadata.
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#10
  def sql_type_metadata; end

  # source://activerecord//lib/active_record/connection_adapters/column.rb#12
  def type(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#90
  def virtual?; end

  private

  # source://activerecord//lib/active_record/connection_adapters/column.rb#95
  def deduplicated; end
end

# Abstract representation of a column definition. Instances of this type
# are typically created by methods in TableDefinition, and added to the
# +columns+ attribute of said TableDefinition object, in order to be used
# for generating a number of table creation or table changing SQL statements.
class ActiveRecord::ConnectionAdapters::ColumnDefinition < ::Struct
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#75
  def aliased_types(name, fallback); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def collation; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def collation=(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def comment; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def comment=(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def default; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def default=(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def limit; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def limit=(value); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def null; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def null=(value); end

  # Returns the value of attribute options
  #
  # @return [Object] the current value of options
  def options; end

  # Sets the attribute options
  #
  # @param value [Object] the value to set the attribute options to.
  # @return [Object] the newly set value
  def options=(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def precision; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def precision=(value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#59
  def primary_key?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#65
  def scale; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#69
  def scale=(value); end

  # Returns the value of attribute sql_type
  #
  # @return [Object] the current value of sql_type
  def sql_type; end

  # Sets the attribute sql_type
  #
  # @param value [Object] the value to set the attribute sql_type to.
  # @return [Object] the newly set value
  def sql_type=(_); end

  # Returns the value of attribute type
  #
  # @return [Object] the current value of type
  def type; end

  # Sets the attribute type
  #
  # @param value [Object] the value to set the attribute type to.
  # @return [Object] the newly set value
  def type=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

module ActiveRecord::ConnectionAdapters::ColumnMethods
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::ConnectionAdapters::ColumnMethods::ClassMethods

  # Appends a primary key definition to the table definition.
  # Can be called multiple times, but this is probably not a good idea.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#245
  def primary_key(name, type = T.unsafe(nil), **options); end
end

module ActiveRecord::ConnectionAdapters::ColumnMethods::ClassMethods
  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#269
  def define_column_methods(*column_types); end
end

# ConnectionHandler is a collection of ConnectionPool objects. It is used
# for keeping separate connection pools that connect to different databases.
#
# For example, suppose that you have 5 models, with the following hierarchy:
#
#   class Author < ActiveRecord::Base
#   end
#
#   class BankAccount < ActiveRecord::Base
#   end
#
#   class Book < ActiveRecord::Base
#     establish_connection :library_db
#   end
#
#   class ScaryBook < Book
#   end
#
#   class GoodBook < Book
#   end
#
# And a database.yml that looked like this:
#
#   development:
#     database: my_application
#     host: localhost
#
#   library_db:
#     database: library
#     host: some.library.org
#
# Your primary database in the development environment is "my_application"
# but the Book model connects to a separate database called "library_db"
# (this can even be a database on a different machine).
#
# Book, ScaryBook, and GoodBook will all use the same connection pool to
# "library_db" while Author, BankAccount, and any other models you create
# will use the default connection pool to "my_application".
#
# The various connection pools are managed by a single instance of
# ConnectionHandler accessible via ActiveRecord::Base.connection_handler.
# All Active Record models use this handler to determine the connection pool that they
# should use.
#
# The ConnectionHandler class is not coupled with the Active models, as it has no knowledge
# about the model. The model needs to pass a connection specification name to the handler,
# in order to look up the correct connection pool.
class ActiveRecord::ConnectionAdapters::ConnectionHandler
  # @return [ConnectionHandler] a new instance of ConnectionHandler
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#75
  def initialize; end

  # Returns true if there are any active connections among the connection
  # pools that the ConnectionHandler is managing.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#161
  def active_connections?(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#117
  def all_connection_pools; end

  # Returns any connections in use by the current thread back to the pool,
  # and also returns connections to the pool cached by threads that are no
  # longer alive.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#168
  def clear_active_connections!(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#179
  def clear_all_connections!(role = T.unsafe(nil)); end

  # Clears the cache which maps classes.
  #
  # See ConnectionPool#clear_reloadable_connections! for details.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#175
  def clear_reloadable_connections!(role = T.unsafe(nil)); end

  # Returns true if a connection that's accessible to this class has
  # already been opened.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#216
  def connected?(spec_name, role: T.unsafe(nil), shard: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#121
  def connection_pool_list(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#113
  def connection_pool_names; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#121
  def connection_pools(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#126
  def establish_connection(config, owner_name: T.unsafe(nil), role: T.unsafe(nil), shard: T.unsafe(nil)); end

  # Disconnects all currently idle connections.
  #
  # See ConnectionPool#flush! for details.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#186
  def flush_idle_connections!(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#83
  def prevent_writes; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#87
  def prevent_writes=(prevent_writes); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#221
  def remove_connection_pool(owner, role: T.unsafe(nil), shard: T.unsafe(nil)); end

  # Locate the connection of the nearest super class. This can be an
  # active or defined connection: if it is the latter, it will be
  # opened and set as the active connection for the class it was defined
  # for (not necessarily the current class).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#194
  def retrieve_connection(spec_name, role: T.unsafe(nil), shard: T.unsafe(nil)); end

  # Retrieving the connection pool happens a lot, so we cache it in @owner_to_pool_manager.
  # This makes retrieving the connection pool O(1) once the process is warm.
  # When a connection is established or removed, we invalidate the cache.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#235
  def retrieve_connection_pool(owner, role: T.unsafe(nil), shard: T.unsafe(nil)); end

  # Prevent writing to the database regardless of role.
  #
  # In some cases you may want to prevent writes to the database
  # even if you are on a database that can write. +while_preventing_writes+
  # will prevent writes to the database for the duration of the block.
  #
  # This method does not provide the same protection as a readonly
  # user and is meant to be a safeguard against accidental writes.
  #
  # See +READ_QUERY+ for the queries that are blocked by this
  # method.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#102
  def while_preventing_writes(enabled = T.unsafe(nil)); end

  private

  # Returns the pool manager for an owner.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#244
  def get_pool_manager(owner); end

  # Returns the value of attribute owner_to_pool_manager.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#241
  def owner_to_pool_manager; end

  # Returns an instance of PoolConfig for a given adapter.
  # Accepts a hash one layer deep that contains all connection information.
  #
  # == Example
  #
  #   config = { "production" => { "host" => "localhost", "database" => "foo", "adapter" => "sqlite3" } }
  #   pool_config = Base.configurations.resolve_pool_config(:production)
  #   pool_config.db_config.configuration_hash
  #   # => { host: "localhost", database: "foo", adapter: "sqlite3" }
  #
  # @raise [AdapterNotSpecified]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#258
  def resolve_pool_config(config, owner_name, role, shard); end
end

# source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#56
ActiveRecord::ConnectionAdapters::ConnectionHandler::FINALIZER = T.let(T.unsafe(nil), Proc)

class ActiveRecord::ConnectionAdapters::ConnectionHandler::StringConnectionOwner
  # @return [StringConnectionOwner] a new instance of StringConnectionOwner
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#62
  def initialize(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#70
  def current_preventing_writes; end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#60
  def name; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_handler.rb#66
  def primary_class?; end
end

# Connection pool base class for managing Active Record database
# connections.
#
# == Introduction
#
# A connection pool synchronizes thread access to a limited number of
# database connections. The basic idea is that each thread checks out a
# database connection from the pool, uses that connection, and checks the
# connection back in. ConnectionPool is completely thread-safe, and will
# ensure that a connection cannot be used by two threads at the same time,
# as long as ConnectionPool's contract is correctly followed. It will also
# handle cases in which there are more threads than connections: if all
# connections have been checked out, and a thread tries to checkout a
# connection anyway, then ConnectionPool will wait until some other thread
# has checked in a connection.
#
# == Obtaining (checking out) a connection
#
# Connections can be obtained and used from a connection pool in several
# ways:
#
# 1. Simply use {ActiveRecord::Base.connection}[rdoc-ref:ConnectionHandling.connection]
#    as with Active Record 2.1 and
#    earlier (pre-connection-pooling). Eventually, when you're done with
#    the connection(s) and wish it to be returned to the pool, you call
#    {ActiveRecord::Base.clear_active_connections!}[rdoc-ref:ConnectionAdapters::ConnectionHandler#clear_active_connections!].
#    This will be the default behavior for Active Record when used in conjunction with
#    Action Pack's request handling cycle.
# 2. Manually check out a connection from the pool with
#    {ActiveRecord::Base.connection_pool.checkout}[rdoc-ref:#checkout]. You are responsible for
#    returning this connection to the pool when finished by calling
#    {ActiveRecord::Base.connection_pool.checkin(connection)}[rdoc-ref:#checkin].
# 3. Use {ActiveRecord::Base.connection_pool.with_connection(&block)}[rdoc-ref:#with_connection], which
#    obtains a connection, yields it as the sole argument to the block,
#    and returns it to the pool after the block completes.
#
# Connections in the pool are actually AbstractAdapter objects (or objects
# compatible with AbstractAdapter's interface).
#
# == Options
#
# There are several connection-pooling-related options that you can add to
# your database connection configuration:
#
# * +pool+: maximum number of connections the pool may manage (default 5).
# * +idle_timeout+: number of seconds that a connection will be kept
#   unused in the pool before it is automatically disconnected (default
#   300 seconds). Set this to zero to keep connections forever.
# * +checkout_timeout+: number of seconds to wait for a connection to
#   become available before giving up and raising a timeout error (default
#   5 seconds).
#
# --
# Synchronization policy:
# * all public methods can be called outside +synchronize+
# * access to these instance variables needs to be in +synchronize+:
#   * @connections
#   * @now_connecting
# * private methods that require being called in a +synchronize+ blocks
#   are now explicitly documented
class ActiveRecord::ConnectionAdapters::ConnectionPool
  include ::MonitorMixin
  include ::ActiveRecord::ConnectionAdapters::QueryCache::ConnectionPoolConfiguration
  include ::ActiveRecord::ConnectionAdapters::AbstractPool

  # Creates a new ConnectionPool object. +pool_config+ is a PoolConfig
  # object which describes database connection information (e.g. adapter,
  # host name, username, password, etc), as well as the maximum size for
  # this ConnectionPool.
  #
  # The default ConnectionPool maximum size is 5.
  #
  # @return [ConnectionPool] a new instance of ConnectionPool
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#120
  def initialize(pool_config); end

  # Returns true if there is an open connection being used for the current thread.
  #
  # This method only works for connections that have been obtained through
  # #connection or #with_connection methods. Connections obtained through
  # #checkout will not be detected by #active_connection?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#189
  def active_connection?; end

  # Returns the value of attribute async_executor.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def async_executor; end

  # Returns the value of attribute automatic_reconnect.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#107
  def automatic_reconnect; end

  # Sets the attribute automatic_reconnect
  #
  # @param value the value to set the attribute automatic_reconnect to.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#107
  def automatic_reconnect=(_arg0); end

  # Check-in a database connection back into the pool, indicating that you
  # no longer need this connection.
  #
  # +conn+: an AbstractAdapter object, which was obtained by earlier by
  # calling #checkout on this pool.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#349
  def checkin(conn); end

  # Check-out a database connection from the pool, indicating that you want
  # to use it. You should call #checkin when you no longer need this.
  #
  # This is done by either returning and leasing existing connection, or by
  # creating a new connection and leasing it.
  #
  # If all connections are leased and the pool is at capacity (meaning the
  # number of currently leased connections is greater than or equal to the
  # size limit set), an ActiveRecord::ConnectionTimeoutError exception will be raised.
  #
  # Returns: an AbstractAdapter object.
  #
  # Raises:
  # - ActiveRecord::ConnectionTimeoutError no connection can be obtained from the pool.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#340
  def checkout(checkout_timeout = T.unsafe(nil)); end

  # Returns the value of attribute checkout_timeout.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#107
  def checkout_timeout; end

  # Sets the attribute checkout_timeout
  #
  # @param value the value to set the attribute checkout_timeout to.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#107
  def checkout_timeout=(_arg0); end

  # Clears the cache which maps classes and re-connects connections that
  # require reloading.
  #
  # Raises:
  # - ActiveRecord::ExclusiveConnectionTimeoutError if unable to gain ownership of all
  #   connections in the pool within a timeout interval (default duration is
  #   <tt>spec.db_config.checkout_timeout * 2</tt> seconds).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#298
  def clear_reloadable_connections(raise_on_acquisition_timeout = T.unsafe(nil)); end

  # Clears the cache which maps classes and re-connects connections that
  # require reloading.
  #
  # The pool first tries to gain ownership of all connections. If unable to
  # do so within a timeout interval (default duration is
  # <tt>spec.db_config.checkout_timeout * 2</tt> seconds), then the pool forcefully
  # clears the cache and reloads connections without any regard for other
  # connection owning threads.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#322
  def clear_reloadable_connections!; end

  # Returns true if a connection has already been opened.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#221
  def connected?; end

  # Retrieve the connection associated with the current thread, or call
  # #checkout to obtain one if necessary.
  #
  # #connection can be called any number of times; the connection is
  # held in a cache keyed by a thread.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#180
  def connection; end

  # Returns the value of attribute connection_class.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def connection_class; end

  # Returns the value of attribute connection_class.
  #
  # source://activesupport/7.0.4/lib/active_support/deprecation/method_wrappers.rb#63
  def connection_klass(*args, **_arg1, &block); end

  # Returns an array containing the connections currently in the pool.
  # Access to the array does not require synchronization on the pool because
  # the array is newly created and not retained by the pool.
  #
  # However; this method bypasses the ConnectionPool's thread-safe connection
  # access pattern. A returned connection may be owned by another thread,
  # unowned, or by happen-stance owned by the calling thread.
  #
  # Calling methods on a connection without ownership is subject to the
  # thread-safety guarantees of the underlying method. Many of the methods
  # on connection adapter classes are inherently multi-thread unsafe.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#236
  def connections; end

  # Returns the value of attribute db_config.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def db_config; end

  # Discards all connections in the pool (even if they're currently
  # leased!), along with the pool itself. Any further interaction with the
  # pool (except #spec and #schema_cache) is undefined.
  #
  # See AbstractAdapter#discard!
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#277
  def discard!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#287
  def discarded?; end

  # Disconnects all connections in the pool, and clears the pool.
  #
  # Raises:
  # - ActiveRecord::ExclusiveConnectionTimeoutError if unable to gain ownership of all
  #   connections in the pool within a timeout interval (default duration is
  #   <tt>spec.db_config.checkout_timeout * 2</tt> seconds).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#246
  def disconnect(raise_on_acquisition_timeout = T.unsafe(nil)); end

  # Disconnects all connections in the pool, and clears the pool.
  #
  # The pool first tries to gain ownership of all connections. If unable to
  # do so within a timeout interval (default duration is
  # <tt>spec.db_config.checkout_timeout * 2</tt> seconds), then the pool is forcefully
  # disconnected without any regard for other connection owning threads.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#268
  def disconnect!; end

  # Disconnect all connections that have been idle for at least
  # +minimum_idle+ seconds. Connections currently checked out, or that were
  # checked in less than +minimum_idle+ seconds ago, are unaffected.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#420
  def flush(minimum_idle = T.unsafe(nil)); end

  # Disconnect all currently idle connections. Connections currently checked
  # out are unaffected.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#442
  def flush!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#167
  def lock_thread=(lock_thread); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#447
  def num_waiting_in_queue; end

  # Returns the value of attribute pool_config.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def pool_config; end

  # Recover lost connections for the pool. A lost connection can occur if
  # a programmer forgets to checkin a connection at the end of a thread
  # or a thread dies unexpectedly.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#397
  def reap; end

  # Returns the value of attribute reaper.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def reaper; end

  # Signal that the thread is finished with the current connection.
  # #release_connection releases the connection-thread association
  # and returns the connection to the pool.
  #
  # This method only works for connections that have been obtained through
  # #connection or #with_connection methods, connections obtained through
  # #checkout will not be automatically released.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#200
  def release_connection(owner_thread = T.unsafe(nil)); end

  # Remove a connection from the connection pool. The connection will
  # remain open and active but will no longer be managed by this pool.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#365
  def remove(conn); end

  # Returns the value of attribute role.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def role; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#469
  def schedule_query(future_result); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#112
  def schema_cache(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#112
  def schema_cache=(arg); end

  # Returns the value of attribute shard.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def shard; end

  # Returns the value of attribute size.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#108
  def size; end

  # Return connection pool's usage statistic
  # Example:
  #
  #    ActiveRecord::Base.connection_pool.stat # => { size: 15, connections: 1, busy: 1, dead: 0, idle: 0, waiting: 0, checkout_timeout: 5 }
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#455
  def stat; end

  # If a connection obtained through #connection or #with_connection methods
  # already exists yield it to the block. If no such connection
  # exists checkout a connection, yield it to the block, and checkin the
  # connection when finished.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#210
  def with_connection; end

  private

  # Acquire a connection by one of 1) immediately removing one
  # from the queue of available connections, 2) creating a new
  # connection if the pool is not at capacity, 3) waiting on the
  # queue for a connection to become available.
  #
  # Raises:
  # - ActiveRecord::ConnectionTimeoutError if a connection could not be acquired
  #
  # --
  # Implementation detail: the connection returned by +acquire_connection+
  # will already be "+connection.lease+ -ed" to the current thread.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#633
  def acquire_connection(checkout_timeout); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#693
  def adopt_connection(conn); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#527
  def attempt_to_checkout_all_existing_connections(raise_on_acquisition_timeout = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#475
  def build_async_executor; end

  # --
  # this is unfortunately not concurrent
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#493
  def bulk_make_new_connections(num_new_conns_needed); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#703
  def checkout_and_verify(c); end

  # --
  # Must be called in a synchronize block.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#573
  def checkout_for_exclusive_access(checkout_timeout); end

  # @raise [ConnectionNotEstablished]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#698
  def checkout_new_connection; end

  # --
  # From the discussion on GitHub:
  #  https://github.com/rails/rails/pull/14938#commitcomment-6601951
  # This hook-in method allows for easier monkey-patching fixes needed by
  # JRuby users that use Fibers.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#508
  def connection_cache_key(thread); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#512
  def current_thread; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#655
  def new_connection; end

  # --
  # if owner_thread param is omitted, this must be called in synchronize block
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#650
  def release(conn, owner_thread = T.unsafe(nil)); end

  # --
  # if owner_thread param is omitted, this must be called in synchronize block
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#650
  def remove_connection_from_thread_cache(conn, owner_thread = T.unsafe(nil)); end

  # If the pool is not at a <tt>@size</tt> limit, establish new connection. Connecting
  # to the DB is done outside main synchronized section.
  # --
  # Implementation constraint: a newly established connection returned by this
  # method must be in the +.leased+ state.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#666
  def try_to_checkout_new_connection; end

  # Take control of all existing connections so a "group" action such as
  # reload/disconnect can be performed safely. It is no longer enough to
  # wrap it in +synchronize+ because some pool's actions are allowed
  # to be performed outside of the main +synchronize+ block.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#520
  def with_exclusively_acquired_all_connections(raise_on_acquisition_timeout = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#593
  def with_new_connections_blocked; end
end

# Adds the ability to turn a basic fair FIFO queue into one
# biased to some thread.
module ActiveRecord::ConnectionAdapters::ConnectionPool::BiasableQueue
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#176
  def with_a_bias_for(thread); end
end

class ActiveRecord::ConnectionAdapters::ConnectionPool::BiasableQueue::BiasedConditionVariable
  # semantics of condition variables guarantee that +broadcast+, +broadcast_on_biased+,
  # +signal+ and +wait+ methods are only called while holding a lock
  #
  # @return [BiasedConditionVariable] a new instance of BiasedConditionVariable
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#140
  def initialize(lock, other_cond, preferred_thread); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#147
  def broadcast; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#152
  def broadcast_on_biased; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#157
  def signal; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#166
  def wait(timeout); end
end

# Connections must be leased while holding the main pool mutex. This is
# an internal subclass that also +.leases+ returned connections while
# still in queue's critical section (queue synchronizes with the same
# <tt>@lock</tt> as the main pool) so that a returned connection is already
# leased and there is no need to re-enter synchronized block.
class ActiveRecord::ConnectionAdapters::ConnectionPool::ConnectionLeasingQueue < ::ActiveRecord::ConnectionAdapters::ConnectionPool::Queue
  include ::ActiveRecord::ConnectionAdapters::ConnectionPool::BiasableQueue

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#201
  def internal_poll(timeout); end
end

# Threadsafe, fair, LIFO queue.  Meant to be used by ConnectionPool
# with which it shares a Monitor.
class ActiveRecord::ConnectionAdapters::ConnectionPool::Queue
  # @return [Queue] a new instance of Queue
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#12
  def initialize(lock = T.unsafe(nil)); end

  # Add +element+ to the queue.  Never blocks.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#35
  def add(element); end

  # Test if any threads are currently waiting on the queue.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#20
  def any_waiting?; end

  # Remove all elements from the queue.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#50
  def clear; end

  # If +element+ is in the queue, remove and return it, or +nil+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#43
  def delete(element); end

  # Returns the number of threads currently waiting on this
  # queue.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#28
  def num_waiting; end

  # Remove the head of the queue.
  #
  # If +timeout+ is not given, remove and return the head of the
  # queue if the number of available elements is strictly
  # greater than the number of threads currently waiting (that
  # is, don't jump ahead in line).  Otherwise, return +nil+.
  #
  # If +timeout+ is given, block if there is no element
  # available, waiting up to +timeout+ seconds for an element to
  # become available.
  #
  # Raises:
  # - ActiveRecord::ConnectionTimeoutError if +timeout+ is given and no element
  # becomes available within +timeout+ seconds,
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#70
  def poll(timeout = T.unsafe(nil)); end

  private

  # Test if the queue currently contains any elements.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#84
  def any?; end

  # A thread can remove an element from the queue without
  # waiting if and only if the number of currently available
  # connections is strictly greater than the number of waiting
  # threads.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#92
  def can_remove_no_wait?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#75
  def internal_poll(timeout); end

  # Remove and return the head of the queue if the number of
  # available elements is strictly greater than the number of
  # threads currently waiting.  Otherwise, return +nil+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#104
  def no_wait_poll; end

  # Removes and returns the head of the queue if possible, or +nil+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#97
  def remove; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#79
  def synchronize(&block); end

  # Waits on the queue up to +timeout+ seconds, then removes and
  # returns the head of the queue.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/queue.rb#110
  def wait_poll(timeout); end
end

# Every +frequency+ seconds, the reaper will call +reap+ and +flush+ on
# +pool+. A reaper instantiated with a zero frequency will never reap
# the connection pool.
#
# Configure the frequency by setting +reaping_frequency+ in your database
# yaml file (default 60 seconds).
class ActiveRecord::ConnectionAdapters::ConnectionPool::Reaper
  # @return [Reaper] a new instance of Reaper
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#18
  def initialize(pool, frequency); end

  # Returns the value of attribute frequency.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#16
  def frequency; end

  # Returns the value of attribute pool.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#16
  def pool; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#69
  def run; end

  class << self
    # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#28
    def register_pool(pool, frequency); end

    private

    # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool/reaper.rb#39
    def spawn_thread(frequency); end
  end
end

class ActiveRecord::ConnectionAdapters::CreateIndexDefinition < ::Struct
  # Returns the value of attribute algorithm
  #
  # @return [Object] the current value of algorithm
  def algorithm; end

  # Sets the attribute algorithm
  #
  # @param value [Object] the value to set the attribute algorithm to.
  # @return [Object] the newly set value
  def algorithm=(_); end

  # Returns the value of attribute if_not_exists
  #
  # @return [Object] the current value of if_not_exists
  def if_not_exists; end

  # Sets the attribute if_not_exists
  #
  # @param value [Object] the value to set the attribute if_not_exists to.
  # @return [Object] the newly set value
  def if_not_exists=(_); end

  # Returns the value of attribute index
  #
  # @return [Object] the current value of index
  def index; end

  # Sets the attribute index
  #
  # @param value [Object] the value to set the attribute index to.
  # @return [Object] the newly set value
  def index=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

module ActiveRecord::ConnectionAdapters::DatabaseLimits
  # Returns the maximum length of an index name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_limits.rb#16
  def index_name_length; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_limits.rb#6
  def max_identifier_length; end

  # Returns the maximum length of a table alias.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_limits.rb#11
  def table_alias_length; end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_limits.rb#21
  def bind_params_length; end
end

module ActiveRecord::ConnectionAdapters::DatabaseStatements
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#6
  def initialize; end

  # Register a record with the current transaction so that its after_commit and after_rollback callbacks
  # can be called.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#345
  def add_transaction_record(record, ensure_finalize = T.unsafe(nil)); end

  # Begins the transaction (and turns off auto-committing).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#350
  def begin_db_transaction; end

  # Begins the transaction with the isolation level set. Raises an error by
  # default; adapters that support setting the isolation level should implement
  # this method.
  #
  # @raise [ActiveRecord::TransactionIsolationError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#364
  def begin_isolated_db_transaction(isolation); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def begin_transaction(*_arg0, **_arg1, &_arg2); end

  # This is used in the StatementCache object. It returns an object that
  # can be used to query the database repeatedly.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#49
  def cacheable_query(klass, arel); end

  # Commits the transaction (and turns on auto-committing).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#369
  def commit_db_transaction; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def commit_transaction(*_arg0, **_arg1, &_arg2); end

  # Executes an INSERT query and returns the new record's ID
  #
  # +id_value+ will be returned unless the value is +nil+, in
  # which case the database will attempt to calculate the last inserted
  # id and return that value.
  #
  # If the next id was calculated in advance (as in Oracle), it should be
  # passed in as +id_value+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#165
  def create(arel, name = T.unsafe(nil), pk = T.unsafe(nil), id_value = T.unsafe(nil), sequence_name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def current_transaction(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#383
  def default_sequence_name(table, column); end

  # Executes the delete statement and returns the number of rows affected.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#179
  def delete(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def disable_lazy_transactions!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#415
  def empty_insert_statement_value(primary_key = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def enable_lazy_transactions!(*_arg0, **_arg1, &_arg2); end

  # Executes delete +sql+ statement in the context of this connection using
  # +binds+ as the bind substitutes. +name+ is logged along with
  # the executed +sql+ statement.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#138
  def exec_delete(sql, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Executes insert +sql+ statement in the context of this connection using
  # +binds+ as the bind substitutes. +name+ is logged along with
  # the executed +sql+ statement.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#130
  def exec_insert(sql, name = T.unsafe(nil), binds = T.unsafe(nil), pk = T.unsafe(nil), sequence_name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#149
  def exec_insert_all(sql, name); end

  # Executes +sql+ statement in the context of this connection using
  # +binds+ as the bind substitutes. +name+ is logged along with
  # the executed +sql+ statement.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#123
  def exec_query(sql, name = T.unsafe(nil), binds = T.unsafe(nil), prepare: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#377
  def exec_rollback_db_transaction; end

  # Executes update +sql+ statement in the context of this connection using
  # +binds+ as the bind substitutes. +name+ is logged along with
  # the executed +sql+ statement.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#145
  def exec_update(sql, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Executes the SQL statement in the context of this connection and returns
  # the raw result from the connection adapter.
  # Note: depending on your database connector, the result returned by this
  # method may be manually memory managed. Consider using the exec_query
  # wrapper instead.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#116
  def execute(sql, name = T.unsafe(nil)); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#153
  def explain(arel, binds = T.unsafe(nil)); end

  # Returns an Arel SQL literal for the CURRENT_TIMESTAMP for usage with
  # arbitrary precision date/time columns.
  #
  # Adapters supporting datetime with precision should override this to
  # provide as much precision as is available.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#453
  def high_precision_current_timestamp; end

  # Executes an INSERT query and returns the new record's ID
  #
  # +id_value+ will be returned unless the value is +nil+, in
  # which case the database will attempt to calculate the last inserted
  # id and return that value.
  #
  # If the next id was calculated in advance (as in Oracle), it should be
  # passed in as +id_value+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#165
  def insert(arel, name = T.unsafe(nil), pk = T.unsafe(nil), id_value = T.unsafe(nil), sequence_name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Inserts the given fixture into the table. Overridden in adapters that require
  # something beyond a simple insert (e.g. Oracle).
  # Most of adapters should implement +insert_fixtures_set+ that leverages bulk SQL insert.
  # We keep this method to provide fallback
  # for databases like sqlite that do not support bulk inserts.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#397
  def insert_fixture(fixture, table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#401
  def insert_fixtures_set(fixture_set, tables_to_delete = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#328
  def mark_transaction_written_if_write(sql); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def materialize_transactions(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def open_transactions(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#102
  def query(sql, name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#94
  def query_value(sql, name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#98
  def query_values(sql, name = T.unsafe(nil)); end

  # Set the sequence to the max value of the table's column.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#388
  def reset_sequence!(table, column, sequence = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#339
  def reset_transaction; end

  # Rolls back the transaction (and turns on auto-committing). Must be
  # done if the transaction block raises an exception or returns false.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#373
  def rollback_db_transaction; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#379
  def rollback_to_savepoint(name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def rollback_transaction(*_arg0, **_arg1, &_arg2); end

  # Sanitizes the given LIMIT parameter in order to prevent SQL injection.
  #
  # The +limit+ may be anything that can evaluate to a string via #to_s. It
  # should look like an integer, or an Arel SQL literal.
  #
  # Returns Integer and Arel::Nodes::SqlLiteral limits as is.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#425
  def sanitize_limit(limit); end

  # Returns an ActiveRecord::Result instance.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#62
  def select_all(arel, name = T.unsafe(nil), binds = T.unsafe(nil), preparable: T.unsafe(nil), async: T.unsafe(nil)); end

  # Returns a record hash with the column names as keys and column values
  # as values.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#73
  def select_one(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Returns an array of arrays containing the field values.
  # Order is the same as that returned by +columns+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#90
  def select_rows(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Returns a single value from a record
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#78
  def select_value(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Returns an array of the values of the first column in a select:
  #   select_values("SELECT id FROM companies LIMIT 3") => [1,2,3]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#84
  def select_values(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Converts an arel AST to SQL
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#12
  def to_sql(arel_or_sql_string, binds = T.unsafe(nil)); end

  # Runs the given block in a database transaction, and returns the result
  # of the block.
  #
  # == Nested transactions support
  #
  # #transaction calls can be nested. By default, this makes all database
  # statements in the nested transaction block become part of the parent
  # transaction. For example, the following behavior may be surprising:
  #
  #   ActiveRecord::Base.transaction do
  #     Post.create(title: 'first')
  #     ActiveRecord::Base.transaction do
  #       Post.create(title: 'second')
  #       raise ActiveRecord::Rollback
  #     end
  #   end
  #
  # This creates both "first" and "second" posts. Reason is the
  # ActiveRecord::Rollback exception in the nested block does not issue a
  # ROLLBACK. Since these exceptions are captured in transaction blocks,
  # the parent block does not see it and the real transaction is committed.
  #
  # Most databases don't support true nested transactions. At the time of
  # writing, the only database that supports true nested transactions that
  # we're aware of, is MS-SQL.
  #
  # In order to get around this problem, #transaction will emulate the effect
  # of nested transactions, by using savepoints:
  # https://dev.mysql.com/doc/refman/en/savepoint.html.
  #
  # It is safe to call this method if a database transaction is already open,
  # i.e. if #transaction is called within another #transaction block. In case
  # of a nested call, #transaction will behave as follows:
  #
  # - The block will be run without doing anything. All database statements
  #   that happen within the block are effectively appended to the already
  #   open database transaction.
  # - However, if +:requires_new+ is set, the block will be wrapped in a
  #   database savepoint acting as a sub-transaction.
  #
  # In order to get a ROLLBACK for the nested transaction you may ask for a
  # real sub-transaction by passing <tt>requires_new: true</tt>.
  # If anything goes wrong, the database rolls back to the beginning of
  # the sub-transaction without rolling back the parent transaction.
  # If we add it to the previous example:
  #
  #   ActiveRecord::Base.transaction do
  #     Post.create(title: 'first')
  #     ActiveRecord::Base.transaction(requires_new: true) do
  #       Post.create(title: 'second')
  #       raise ActiveRecord::Rollback
  #     end
  #   end
  #
  # only post with title "first" is created.
  #
  # See ActiveRecord::Transactions to learn more.
  #
  # === Caveats
  #
  # MySQL doesn't support DDL transactions. If you perform a DDL operation,
  # then any created savepoints will be automatically released. For example,
  # if you've created a savepoint, then you execute a CREATE TABLE statement,
  # then the savepoint that was created will be automatically released.
  #
  # This means that, on MySQL, you shouldn't execute DDL operations inside
  # a #transaction call that you know might create a savepoint. Otherwise,
  # #transaction will raise exceptions when it tries to release the
  # already-automatically-released savepoints:
  #
  #   Model.connection.transaction do  # BEGIN
  #     Model.connection.transaction(requires_new: true) do  # CREATE SAVEPOINT active_record_1
  #       Model.connection.create_table(...)
  #       # active_record_1 now automatically released
  #     end  # RELEASE SAVEPOINT active_record_1  <--- BOOM! database error!
  #   end
  #
  # == Transaction isolation
  #
  # If your database supports setting the isolation level for a transaction, you can set
  # it like so:
  #
  #   Post.transaction(isolation: :serializable) do
  #     # ...
  #   end
  #
  # Valid isolation levels are:
  #
  # * <tt>:read_uncommitted</tt>
  # * <tt>:read_committed</tt>
  # * <tt>:repeatable_read</tt>
  # * <tt>:serializable</tt>
  #
  # You should consult the documentation for your database to understand the
  # semantics of these different levels:
  #
  # * https://www.postgresql.org/docs/current/static/transaction-iso.html
  # * https://dev.mysql.com/doc/refman/en/set-transaction.html
  #
  # An ActiveRecord::TransactionIsolationError will be raised if:
  #
  # * The adapter does not support setting the isolation level
  # * You are joining an existing open transaction
  # * You are creating a nested (savepoint) transaction
  #
  # The mysql2 and postgresql adapters support setting the transaction
  # isolation level.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#309
  def transaction(requires_new: T.unsafe(nil), isolation: T.unsafe(nil), joinable: T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#352
  def transaction_isolation_levels; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#322
  def transaction_manager; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#335
  def transaction_open?; end

  # Executes the truncate statement.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#185
  def truncate(table_name, name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#189
  def truncate_tables(*table_names); end

  # Executes the update statement and returns the number of rows affected.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#173
  def update(arel, name = T.unsafe(nil), binds = T.unsafe(nil)); end

  # Fixture value is quoted by Arel, however scalar values
  # are not quotable. In this case we want to convert
  # the column value to YAML.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#436
  def with_yaml_fallback(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#324
  def within_new_transaction(*_arg0, **_arg1, &_arg2); end

  # Determines whether the SQL statement is a write query.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#107
  def write_query?(sql); end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#576
  def arel_from_relation(relation); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#471
  def build_fixture_sql(fixtures, table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#513
  def build_fixture_statements(fixture_set); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#520
  def build_truncate_statement(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#524
  def build_truncate_statements(table_names); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#534
  def combine_multi_statements(total_sql); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#467
  def default_insert_value(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#458
  def execute_batch(statements, name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#567
  def last_inserted_id(result); end

  # Returns an ActiveRecord::Result instance.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#539
  def select(sql, name = T.unsafe(nil), binds = T.unsafe(nil), prepare: T.unsafe(nil), async: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#571
  def single_value_from_rows(rows); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#563
  def sql_for_insert(sql, pk, binds); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#17
  def to_sql_and_binds(arel_or_sql_string, binds = T.unsafe(nil), preparable = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#530
  def with_multi_statements; end
end

# source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#464
ActiveRecord::ConnectionAdapters::DatabaseStatements::DEFAULT_INSERT_VALUE = T.let(T.unsafe(nil), Arel::Nodes::SqlLiteral)

# This is a safe default, even if not high precision on all databases
#
# source://activerecord//lib/active_record/connection_adapters/abstract/database_statements.rb#445
ActiveRecord::ConnectionAdapters::DatabaseStatements::HIGH_PRECISION_CURRENT_TIMESTAMP = T.let(T.unsafe(nil), Arel::Nodes::SqlLiteral)

module ActiveRecord::ConnectionAdapters::Deduplicable
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::ConnectionAdapters::Deduplicable::ClassMethods

  # source://activerecord//lib/active_record/connection_adapters/deduplicable.rb#18
  def -@; end

  # source://activerecord//lib/active_record/connection_adapters/deduplicable.rb#18
  def deduplicate; end

  private

  # source://activerecord//lib/active_record/connection_adapters/deduplicable.rb#24
  def deduplicated; end
end

module ActiveRecord::ConnectionAdapters::Deduplicable::ClassMethods
  # source://activerecord//lib/active_record/connection_adapters/deduplicable.rb#13
  def new(*_arg0, **_arg1); end

  # source://activerecord//lib/active_record/connection_adapters/deduplicable.rb#9
  def registry; end
end

class ActiveRecord::ConnectionAdapters::ForeignKeyDefinition < ::Struct
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#93
  def column; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#113
  def custom_primary_key?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#109
  def deferrable; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#126
  def defined_for?(to_table: T.unsafe(nil), validate: T.unsafe(nil), **options); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#122
  def export_name_on_schema_dump?; end

  # Returns the value of attribute from_table
  #
  # @return [Object] the current value of from_table
  def from_table; end

  # Sets the attribute from_table
  #
  # @param value [Object] the value to set the attribute from_table to.
  # @return [Object] the newly set value
  def from_table=(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#89
  def name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#101
  def on_delete; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#105
  def on_update; end

  # Returns the value of attribute options
  #
  # @return [Object] the current value of options
  def options; end

  # Sets the attribute options
  #
  # @param value [Object] the value to set the attribute options to.
  # @return [Object] the newly set value
  def options=(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#97
  def primary_key; end

  # Returns the value of attribute to_table
  #
  # @return [Object] the current value of to_table
  def to_table; end

  # Sets the attribute to_table
  #
  # @param value [Object] the value to set the attribute to_table to.
  # @return [Object] the newly set value
  def to_table=(_); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#117
  def validate?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#117
  def validated?; end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#133
  def default_primary_key; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Abstract representation of an index definition on a table. Instances of
# this type are typically created and returned by methods in database
# adapters. e.g. ActiveRecord::ConnectionAdapters::MySQL::SchemaStatements#indexes
class ActiveRecord::ConnectionAdapters::IndexDefinition
  # @return [IndexDefinition] a new instance of IndexDefinition
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#11
  def initialize(table, name, unique = T.unsafe(nil), columns = T.unsafe(nil), lengths: T.unsafe(nil), orders: T.unsafe(nil), opclasses: T.unsafe(nil), where: T.unsafe(nil), type: T.unsafe(nil), using: T.unsafe(nil), comment: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#36
  def column_options; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def columns; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def comment; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def lengths; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def opclasses; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def orders; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def table; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def type; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def unique; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def using; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#9
  def where; end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#45
  def concise_options(options); end
end

class ActiveRecord::ConnectionAdapters::LegacyPoolManager
  # @return [LegacyPoolManager] a new instance of LegacyPoolManager
  #
  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#6
  def initialize; end

  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#22
  def get_pool_config(_, shard); end

  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#14
  def pool_configs(_ = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#18
  def remove_pool_config(_, shard); end

  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#26
  def set_pool_config(role, shard, pool_config); end

  # source://activerecord//lib/active_record/connection_adapters/legacy_pool_manager.rb#10
  def shard_names; end
end

class ActiveRecord::ConnectionAdapters::NullColumn < ::ActiveRecord::ConnectionAdapters::Column
  # @return [NullColumn] a new instance of NullColumn
  #
  # source://activerecord//lib/active_record/connection_adapters/column.rb#107
  def initialize(name, **_arg1); end
end

class ActiveRecord::ConnectionAdapters::NullPool
  include ::ActiveRecord::ConnectionAdapters::AbstractPool

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#39
  def async_executor; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#37
  def checkin(_); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#36
  def connection_class; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#38
  def remove(_); end

  # Returns the value of attribute schema_cache.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#34
  def schema_cache; end

  # Sets the attribute schema_cache
  #
  # @param value the value to set the attribute schema_cache to.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/connection_pool.rb#34
  def schema_cache=(_arg0); end
end

class ActiveRecord::ConnectionAdapters::NullTransaction
  # @return [NullTransaction] a new instance of NullTransaction
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#77
  def initialize; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#82
  def add_record(record, _ = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#79
  def closed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#81
  def joinable?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#80
  def open?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#78
  def state; end
end

class ActiveRecord::ConnectionAdapters::PoolConfig
  include ::Mutex_m

  # @return [PoolConfig] a new instance of PoolConfig
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#20
  def initialize(connection_class, db_config, role, shard); end

  # Returns the value of attribute connection_class.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#8
  def connection_class; end

  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#30
  def connection_specification_name; end

  # Returns the value of attribute db_config.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#8
  def db_config; end

  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#59
  def discard_pool!; end

  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#38
  def disconnect!; end

  # source://mutex_m/0.1.1/mutex_m.rb#93
  def lock; end

  # source://mutex_m/0.1.1/mutex_m.rb#83
  def locked?; end

  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#53
  def pool; end

  # Returns the value of attribute role.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#8
  def role; end

  # Returns the value of attribute schema_cache.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#9
  def schema_cache; end

  # Sets the attribute schema_cache
  #
  # @param value the value to set the attribute schema_cache to.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#9
  def schema_cache=(_arg0); end

  # Returns the value of attribute shard.
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#8
  def shard; end

  # source://mutex_m/0.1.1/mutex_m.rb#78
  def synchronize(&block); end

  # source://mutex_m/0.1.1/mutex_m.rb#88
  def try_lock; end

  # source://mutex_m/0.1.1/mutex_m.rb#98
  def unlock; end

  class << self
    # source://activerecord//lib/active_record/connection_adapters/pool_config.rb#15
    def discard_pools!; end
  end
end

# source://activerecord//lib/active_record/connection_adapters/pool_config.rb#11
ActiveRecord::ConnectionAdapters::PoolConfig::INSTANCES = T.let(T.unsafe(nil), ObjectSpace::WeakMap)

class ActiveRecord::ConnectionAdapters::PoolManager
  # @return [PoolManager] a new instance of PoolManager
  #
  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#6
  def initialize; end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#34
  def get_pool_config(role, shard); end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#18
  def pool_configs(role = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#30
  def remove_pool_config(role, shard); end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#26
  def remove_role(role); end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#14
  def role_names; end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#38
  def set_pool_config(role, shard, pool_config); end

  # source://activerecord//lib/active_record/connection_adapters/pool_manager.rb#10
  def shard_names; end
end

class ActiveRecord::ConnectionAdapters::PrimaryKeyDefinition < ::Struct
  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

module ActiveRecord::ConnectionAdapters::QueryCache
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#52
  def initialize(*_arg0); end

  # Enable the query cache within the block.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#59
  def cache; end

  # Clears the query cache.
  #
  # One reason you may wish to call this method explicitly is between queries
  # that ask the database to randomize results. Otherwise the cache would see
  # the same SQL query and repeatedly return the same result each time, silently
  # undermining the randomness you were expecting.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#90
  def clear_query_cache; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#71
  def disable_query_cache!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#67
  def enable_query_cache!; end

  # Returns the value of attribute query_cache.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#50
  def query_cache; end

  # Returns the value of attribute query_cache_enabled.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#50
  def query_cache_enabled; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#96
  def select_all(arel, name = T.unsafe(nil), binds = T.unsafe(nil), preparable: T.unsafe(nil), async: T.unsafe(nil)); end

  # Disable the query cache within the block.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#77
  def uncached; end

  private

  # Database adapters can override this method to
  # provide custom cache information.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#145
  def cache_notification_info(sql, name, binds); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#127
  def cache_sql(sql, name, binds); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#156
  def configure_query_cache!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#115
  def lookup_sql_cache(sql, name, binds); end

  class << self
    # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#17
    def dirties_query_cache(base, *method_names); end

    # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#9
    def included(base); end
  end
end

module ActiveRecord::ConnectionAdapters::QueryCache::ConnectionPoolConfiguration
  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#30
  def initialize(*_arg0); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#40
  def disable_query_cache!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#35
  def enable_query_cache!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/query_cache.rb#45
  def query_cache_enabled; end
end

module ActiveRecord::ConnectionAdapters::Quoting
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#152
  def column_name_matcher; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#156
  def column_name_with_order_matcher; end

  # If you are having to call this function, you are likely doing something
  # wrong. The column does not have sufficient type information if the user
  # provided a custom type on the class level either explicitly (via
  # Attributes::ClassMethods#attribute) or implicitly (via
  # AttributeMethods::Serialization::ClassMethods#serialize, +time_zone_aware_attributes+).
  # In almost all cases, the sql type should only be used to change quoting behavior, when the primitive to
  # represent the type doesn't sufficiently reflect the differences
  # (varchar vs binary) for example. The type used to get this primitive
  # should have been provided before reaching the connection adapter.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#63
  def lookup_cast_type_from_column(column); end

  # Quotes the column value to help prevent
  # {SQL injection attacks}[https://en.wikipedia.org/wiki/SQL_injection].
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#11
  def quote(value); end

  # Quote a value to be used as a bound parameter of unknown type. For example,
  # MySQL might perform dangerous castings when comparing a string to a number,
  # so this method will cast numbers to string.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#50
  def quote_bound_value(value); end

  # Quotes the column name. Defaults to no quoting.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#74
  def quote_column_name(column_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#95
  def quote_default_expression(value, column); end

  # Quotes a string, escaping any ' (single quote) and \ (backslash)
  # characters.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#69
  def quote_string(s); end

  # Quotes the table name. Defaults to column name quoting.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#79
  def quote_table_name(table_name); end

  # Override to return the quoted table name for assignment. Defaults to
  # table quoting.
  #
  # This works for mysql2 where table.column can be used to
  # resolve ambiguity.
  #
  # We override this in the sqlite3 and postgresql adapters to use only
  # the column name (as per syntax requirements).
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#91
  def quote_table_name_for_assignment(table, attr); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#144
  def quoted_binary(value); end

  # Quote date/time values for use in SQL input. Includes microseconds
  # if the value is a Time responding to usec.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#122
  def quoted_date(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#112
  def quoted_false; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#139
  def quoted_time(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#104
  def quoted_true; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#148
  def sanitize_as_sql_comment(value); end

  # Cast a +value+ to a type that the database understands. For example,
  # SQLite does not understand dates, so this method will convert a Date
  # to a String.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#32
  def type_cast(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#116
  def unquoted_false; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#108
  def unquoted_true; end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#216
  def lookup_cast_type(sql_type); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#206
  def type_casted_binds(binds); end
end

# Regexp for column names (with or without a table name prefix).
# Matches the following:
#
#   "#{table_name}.#{column_name}"
#   "#{column_name}"
#
# source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#165
ActiveRecord::ConnectionAdapters::Quoting::COLUMN_NAME = T.let(T.unsafe(nil), Regexp)

# Regexp for column names with order (with or without a table name prefix,
# with or without various order modifiers). Matches the following:
#
#   "#{table_name}.#{column_name}"
#   "#{table_name}.#{column_name} #{direction}"
#   "#{table_name}.#{column_name} #{direction} NULLS FIRST"
#   "#{table_name}.#{column_name} NULLS LAST"
#   "#{column_name}"
#   "#{column_name} #{direction}"
#   "#{column_name} #{direction} NULLS FIRST"
#   "#{column_name} NULLS LAST"
#
# source://activerecord//lib/active_record/connection_adapters/abstract/quoting.rb#189
ActiveRecord::ConnectionAdapters::Quoting::COLUMN_NAME_WITH_ORDER = T.let(T.unsafe(nil), Regexp)

class ActiveRecord::ConnectionAdapters::RealTransaction < ::ActiveRecord::ConnectionAdapters::Transaction
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#218
  def commit; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#203
  def materialize!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#213
  def rollback; end
end

class ActiveRecord::ConnectionAdapters::ReferenceDefinition
  # @return [ReferenceDefinition] a new instance of ReferenceDefinition
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#154
  def initialize(name, polymorphic: T.unsafe(nil), index: T.unsafe(nil), foreign_key: T.unsafe(nil), type: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#174
  def add_to(table); end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#191
  def as_options(value); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#225
  def column_name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#229
  def column_names; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#217
  def columns; end

  # Returns the value of attribute foreign_key.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def foreign_key; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#213
  def foreign_key_options; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#233
  def foreign_table_name; end

  # Returns the value of attribute index.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def index; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#203
  def index_options(table_name); end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def name; end

  # Returns the value of attribute options.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def options; end

  # Returns the value of attribute polymorphic.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def polymorphic; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#199
  def polymorphic_index_name(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#195
  def polymorphic_options; end

  # Returns the value of attribute type.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#189
  def type; end
end

class ActiveRecord::ConnectionAdapters::SavepointTransaction < ::ActiveRecord::ConnectionAdapters::Transaction
  # @return [SavepointTransaction] a new instance of SavepointTransaction
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#172
  def initialize(connection, savepoint_name, parent_transaction, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#194
  def commit; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#199
  def full_rollback?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#184
  def materialize!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#189
  def rollback; end
end

module ActiveRecord::ConnectionAdapters::Savepoints
  # source://activerecord//lib/active_record/connection_adapters/abstract/savepoints.rb#10
  def create_savepoint(name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/savepoints.rb#6
  def current_savepoint_name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/savepoints.rb#14
  def exec_rollback_to_savepoint(name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/savepoints.rb#18
  def release_savepoint(name = T.unsafe(nil)); end
end

class ActiveRecord::ConnectionAdapters::SchemaCache
  # @return [SchemaCache] a new instance of SchemaCache
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#38
  def initialize(conn); end

  # Add internal cache for table with +table_name+.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#97
  def add(table_name); end

  # Clears out internal caches
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#149
  def clear!; end

  # Clear out internal caches for the data source +name+.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#164
  def clear_data_source_cache!(name); end

  # Get the columns for a table
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#111
  def columns(table_name); end

  # Get the columns for a table as a hash, key is the column name
  # value is the column object.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#123
  def columns_hash(table_name); end

  # Checks whether the columns hash is already cached for a table.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#130
  def columns_hash?(table_name); end

  # Returns the value of attribute connection.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#36
  def connection; end

  # Sets the attribute connection
  #
  # @param value the value to set the attribute connection to.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#36
  def connection=(_arg0); end

  # A cached lookup for table existence.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#88
  def data_source_exists?(name); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#106
  def data_sources(name); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#144
  def database_version; end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#172
  def dump_to(filename); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#57
  def encode_with(coder); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#134
  def indexes(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#68
  def init_with(coder); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#184
  def marshal_dump; end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#190
  def marshal_load(array); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#79
  def primary_keys(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#159
  def size; end

  # Returns the value of attribute version.
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#35
  def version; end

  private

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#222
  def deep_deduplicate(value); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#214
  def derive_columns_hash_and_deduplicate_values; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#204
  def ignored_table?(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#48
  def initialize_dup(other); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#241
  def open(filename); end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#235
  def prepare_data_sources; end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#210
  def reset_version!; end

  # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#198
  def tables_to_cache; end

  class << self
    # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#8
    def load_from(filename); end

    private

    # source://activerecord//lib/active_record/connection_adapters/schema_cache.rb#24
    def read(filename, &block); end
  end
end

class ActiveRecord::ConnectionAdapters::SchemaCreation
  # @return [SchemaCreation] a new instance of SchemaCreation
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#6
  def initialize(conn); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#11
  def accept(o); end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#162
  def action_sql(action, dependency); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#137
  def add_column_options!(sql, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#128
  def add_table_options!(create_sql, o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#133
  def column_options(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def options_include_default?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def quote_column_name(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def quote_default_expression(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def quote_table_name(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#120
  def quoted_columns(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def quoted_columns_for_index(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def supports_check_constraints?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def supports_foreign_keys?(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#124
  def supports_index_using?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def supports_indexes_in_create?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def supports_partial_index?(*_arg0, **_arg1, &_arg2); end

  # Returns any SQL string to go between CREATE and TABLE. May be nil.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#158
  def table_modifier_in_create(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#152
  def to_sql(sql); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#16
  def type_to_sql(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#112
  def visit_AddCheckConstraint(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#38
  def visit_AddColumnDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#83
  def visit_AddForeignKey(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#22
  def visit_AlterTable(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#108
  def visit_CheckConstraintDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#31
  def visit_ColumnDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#91
  def visit_CreateIndexDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#116
  def visit_DropCheckConstraint(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#87
  def visit_DropForeignKey(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#72
  def visit_ForeignKeyDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#68
  def visit_PrimaryKeyDefinition(o); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_creation.rb#42
  def visit_TableDefinition(o); end
end

class ActiveRecord::ConnectionAdapters::SchemaDumper < ::ActiveRecord::SchemaDumper
  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#13
  def column_spec(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#17
  def column_spec_for_primary_key(column); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#38
  def default_primary_key?(column); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#42
  def explicit_primary_key_default?(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#25
  def prepare_column_options(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#101
  def schema_collation(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#86
  def schema_default(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#97
  def schema_expression(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#62
  def schema_limit(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#67
  def schema_precision(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#82
  def schema_scale(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#54
  def schema_type(column); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#46
  def schema_type_with_virtual(column); end

  class << self
    # source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#8
    def create(connection, options); end
  end
end

# source://activerecord//lib/active_record/connection_adapters/abstract/schema_dumper.rb#6
ActiveRecord::ConnectionAdapters::SchemaDumper::DEFAULT_DATETIME_PRECISION = T.let(T.unsafe(nil), Integer)

module ActiveRecord::ConnectionAdapters::SchemaStatements
  include ::ActiveRecord::Migration::JoinTable

  # Adds a reference. The reference column is a bigint by default,
  # the <tt>:type</tt> option can be used to specify a different type.
  # Optionally adds a +_type+ column, if <tt>:polymorphic</tt> option is provided.
  # #add_reference and #add_belongs_to are acceptable.
  #
  # The +options+ hash can include the following keys:
  # [<tt>:type</tt>]
  #   The reference column type. Defaults to +:bigint+.
  # [<tt>:index</tt>]
  #   Add an appropriate index. Defaults to true.
  #   See #add_index for usage of this option.
  # [<tt>:foreign_key</tt>]
  #   Add an appropriate foreign key constraint. Defaults to false, pass true
  #   to add. In case the join table can't be inferred from the association
  #   pass <tt>:to_table</tt> with the appropriate table name.
  # [<tt>:polymorphic</tt>]
  #   Whether an additional +_type+ column should be added. Defaults to false.
  # [<tt>:null</tt>]
  #   Whether the column allows nulls. Defaults to true.
  #
  # ====== Create a user_id bigint column without an index
  #
  #   add_reference(:products, :user, index: false)
  #
  # ====== Create a user_id string column
  #
  #   add_reference(:products, :user, type: :string)
  #
  # ====== Create supplier_id, supplier_type columns
  #
  #   add_reference(:products, :supplier, polymorphic: true)
  #
  # ====== Create a supplier_id column with a unique index
  #
  #   add_reference(:products, :supplier, index: { unique: true })
  #
  # ====== Create a supplier_id column with a named index
  #
  #   add_reference(:products, :supplier, index: { name: "my_supplier_index" })
  #
  # ====== Create a supplier_id column and appropriate foreign key
  #
  #   add_reference(:products, :supplier, foreign_key: true)
  #
  # ====== Create a supplier_id column and a foreign key to the firms table
  #
  #   add_reference(:products, :supplier, foreign_key: { to_table: :firms })
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#988
  def add_belongs_to(table_name, ref_name, **options); end

  # Adds a new check constraint to the table. +expression+ is a String
  # representation of verifiable boolean condition.
  #
  #   add_check_constraint :products, "price > 0", name: "price_check"
  #
  # generates:
  #
  #   ALTER TABLE "products" ADD CONSTRAINT price_check CHECK (price > 0)
  #
  # The +options+ hash can include the following keys:
  # [<tt>:name</tt>]
  #   The constraint name. Defaults to <tt>chk_rails_<identifier></tt>.
  # [<tt>:validate</tt>]
  #   (PostgreSQL only) Specify whether or not the constraint should be validated. Defaults to +true+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1185
  def add_check_constraint(table_name, expression, **options); end

  # Add a new +type+ column named +column_name+ to +table_name+.
  #
  # See {ActiveRecord::ConnectionAdapters::TableDefinition.column}[rdoc-ref:ActiveRecord::ConnectionAdapters::TableDefinition#column].
  #
  # The +type+ parameter is normally one of the migrations native types,
  # which is one of the following:
  # <tt>:primary_key</tt>, <tt>:string</tt>, <tt>:text</tt>,
  # <tt>:integer</tt>, <tt>:bigint</tt>, <tt>:float</tt>, <tt>:decimal</tt>, <tt>:numeric</tt>,
  # <tt>:datetime</tt>, <tt>:time</tt>, <tt>:date</tt>,
  # <tt>:binary</tt>, <tt>:blob</tt>, <tt>:boolean</tt>.
  #
  # You may use a type not in this list as long as it is supported by your
  # database (for example, "polygon" in MySQL), but this will not be database
  # agnostic and should usually be avoided.
  #
  # Available options are (none of these exists by default):
  # * <tt>:comment</tt> -
  #   Specifies the comment for the column. This option is ignored by some backends.
  # * <tt>:collation</tt> -
  #   Specifies the collation for a <tt>:string</tt> or <tt>:text</tt> column.
  #   If not specified, the column will have the same collation as the table.
  # * <tt>:default</tt> -
  #   The column's default value. Use +nil+ for +NULL+.
  # * <tt>:limit</tt> -
  #   Requests a maximum column length. This is the number of characters for a <tt>:string</tt> column
  #   and number of bytes for <tt>:text</tt>, <tt>:binary</tt>, <tt>:blob</tt>, and <tt>:integer</tt> columns.
  #   This option is ignored by some backends.
  # * <tt>:null</tt> -
  #   Allows or disallows +NULL+ values in the column.
  # * <tt>:precision</tt> -
  #   Specifies the precision for the <tt>:decimal</tt>, <tt>:numeric</tt>,
  #   <tt>:datetime</tt>, and <tt>:time</tt> columns.
  # * <tt>:scale</tt> -
  #   Specifies the scale for the <tt>:decimal</tt> and <tt>:numeric</tt> columns.
  # * <tt>:collation</tt> -
  #   Specifies the collation for a <tt>:string</tt> or <tt>:text</tt> column. If not specified, the
  #   column will have the same collation as the table.
  # * <tt>:comment</tt> -
  #   Specifies the comment for the column. This option is ignored by some backends.
  # * <tt>:if_not_exists</tt> -
  #   Specifies if the column already exists to not try to re-add it. This will avoid
  #   duplicate column errors.
  #
  # Note: The precision is the total number of significant digits,
  # and the scale is the number of digits that can be stored following
  # the decimal point. For example, the number 123.45 has a precision of 5
  # and a scale of 2. A decimal with a precision of 5 and a scale of 2 can
  # range from -999.99 to 999.99.
  #
  # Please be aware of different RDBMS implementations behavior with
  # <tt>:decimal</tt> columns:
  # * The SQL standard says the default scale should be 0, <tt>:scale</tt> <=
  #   <tt>:precision</tt>, and makes no comments about the requirements of
  #   <tt>:precision</tt>.
  # * MySQL: <tt>:precision</tt> [1..63], <tt>:scale</tt> [0..30].
  #   Default is (10,0).
  # * PostgreSQL: <tt>:precision</tt> [1..infinity],
  #   <tt>:scale</tt> [0..infinity]. No default.
  # * SQLite3: No restrictions on <tt>:precision</tt> and <tt>:scale</tt>,
  #   but the maximum supported <tt>:precision</tt> is 16. No default.
  # * Oracle: <tt>:precision</tt> [1..38], <tt>:scale</tt> [-84..127].
  #   Default is (38,0).
  # * SqlServer: <tt>:precision</tt> [1..38], <tt>:scale</tt> [0..38].
  #   Default (38,0).
  #
  # == Examples
  #
  #  add_column(:users, :picture, :binary, limit: 2.megabytes)
  #  # ALTER TABLE "users" ADD "picture" blob(2097152)
  #
  #  add_column(:articles, :status, :string, limit: 20, default: 'draft', null: false)
  #  # ALTER TABLE "articles" ADD "status" varchar(20) DEFAULT 'draft' NOT NULL
  #
  #  add_column(:answers, :bill_gates_money, :decimal, precision: 15, scale: 2)
  #  # ALTER TABLE "answers" ADD "bill_gates_money" decimal(15,2)
  #
  #  add_column(:measurements, :sensor_reading, :decimal, precision: 30, scale: 20)
  #  # ALTER TABLE "measurements" ADD "sensor_reading" decimal(30,20)
  #
  #  # While :scale defaults to zero on most databases, it
  #  # probably wouldn't hurt to include it.
  #  add_column(:measurements, :huge_integer, :decimal, precision: 30)
  #  # ALTER TABLE "measurements" ADD "huge_integer" decimal(30)
  #
  #  # Defines a column that stores an array of a type.
  #  add_column(:users, :skills, :text, array: true)
  #  # ALTER TABLE "users" ADD "skills" text[]
  #
  #  # Defines a column with a database-specific type.
  #  add_column(:shapes, :triangle, 'polygon')
  #  # ALTER TABLE "shapes" ADD "triangle" polygon
  #
  #  # Ignores the method call if the column exists
  #  add_column(:shapes, :triangle, 'polygon', if_not_exists: true)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#616
  def add_column(table_name, column_name, type, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#630
  def add_columns(table_name, *column_names, type:, **options); end

  # Adds a new foreign key. +from_table+ is the table with the key column,
  # +to_table+ contains the referenced primary key.
  #
  # The foreign key will be named after the following pattern: <tt>fk_rails_<identifier></tt>.
  # +identifier+ is a 10 character long string which is deterministically generated from the
  # +from_table+ and +column+. A custom name can be specified with the <tt>:name</tt> option.
  #
  # ====== Creating a simple foreign key
  #
  #   add_foreign_key :articles, :authors
  #
  # generates:
  #
  #   ALTER TABLE "articles" ADD CONSTRAINT fk_rails_e74ce85cbc FOREIGN KEY ("author_id") REFERENCES "authors" ("id")
  #
  # ====== Creating a foreign key, ignoring method call if the foreign key exists
  #
  #  add_foreign_key(:articles, :authors, if_not_exists: true)
  #
  # ====== Creating a foreign key on a specific column
  #
  #   add_foreign_key :articles, :users, column: :author_id, primary_key: "lng_id"
  #
  # generates:
  #
  #   ALTER TABLE "articles" ADD CONSTRAINT fk_rails_58ca3d3a82 FOREIGN KEY ("author_id") REFERENCES "users" ("lng_id")
  #
  # ====== Creating a cascading foreign key
  #
  #   add_foreign_key :articles, :authors, on_delete: :cascade
  #
  # generates:
  #
  #   ALTER TABLE "articles" ADD CONSTRAINT fk_rails_e74ce85cbc FOREIGN KEY ("author_id") REFERENCES "authors" ("id") ON DELETE CASCADE
  #
  # The +options+ hash can include the following keys:
  # [<tt>:column</tt>]
  #   The foreign key column name on +from_table+. Defaults to <tt>to_table.singularize + "_id"</tt>
  # [<tt>:primary_key</tt>]
  #   The primary key column name on +to_table+. Defaults to +id+.
  # [<tt>:name</tt>]
  #   The constraint name. Defaults to <tt>fk_rails_<identifier></tt>.
  # [<tt>:on_delete</tt>]
  #   Action that happens <tt>ON DELETE</tt>. Valid values are +:nullify+, +:cascade+, and +:restrict+
  # [<tt>:on_update</tt>]
  #   Action that happens <tt>ON UPDATE</tt>. Valid values are +:nullify+, +:cascade+, and +:restrict+
  # [<tt>:if_not_exists</tt>]
  #   Specifies if the foreign key already exists to not try to re-add it. This will avoid
  #   duplicate column errors.
  # [<tt>:validate</tt>]
  #   (PostgreSQL only) Specify whether or not the constraint should be validated. Defaults to +true+.
  # [<tt>:deferrable</tt>]
  #   (PostgreSQL only) Specify whether or not the foreign key should be deferrable. Valid values are booleans or
  #   +:deferred+ or +:immediate+ to specify the default behavior. Defaults to +false+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1085
  def add_foreign_key(from_table, to_table, **options); end

  # Adds a new index to the table. +column_name+ can be a single Symbol, or
  # an Array of Symbols.
  #
  # The index will be named after the table and the column name(s), unless
  # you pass <tt>:name</tt> as an option.
  #
  # ====== Creating a simple index
  #
  #   add_index(:suppliers, :name)
  #
  # generates:
  #
  #   CREATE INDEX index_suppliers_on_name ON suppliers(name)
  #
  # ====== Creating a index which already exists
  #
  #   add_index(:suppliers, :name, if_not_exists: true)
  #
  # generates:
  #
  #   CREATE INDEX IF NOT EXISTS index_suppliers_on_name ON suppliers(name)
  #
  # Note: Not supported by MySQL.
  #
  # ====== Creating a unique index
  #
  #   add_index(:accounts, [:branch_id, :party_id], unique: true)
  #
  # generates:
  #
  #   CREATE UNIQUE INDEX index_accounts_on_branch_id_and_party_id ON accounts(branch_id, party_id)
  #
  # ====== Creating a named index
  #
  #   add_index(:accounts, [:branch_id, :party_id], unique: true, name: 'by_branch_party')
  #
  # generates:
  #
  #  CREATE UNIQUE INDEX by_branch_party ON accounts(branch_id, party_id)
  #
  # ====== Creating an index with specific key length
  #
  #   add_index(:accounts, :name, name: 'by_name', length: 10)
  #
  # generates:
  #
  #   CREATE INDEX by_name ON accounts(name(10))
  #
  # ====== Creating an index with specific key lengths for multiple keys
  #
  #   add_index(:accounts, [:name, :surname], name: 'by_name_surname', length: {name: 10, surname: 15})
  #
  # generates:
  #
  #   CREATE INDEX by_name_surname ON accounts(name(10), surname(15))
  #
  # Note: only supported by MySQL
  #
  # ====== Creating an index with a sort order (desc or asc, asc is the default)
  #
  #   add_index(:accounts, [:branch_id, :party_id, :surname], name: 'by_branch_desc_party', order: {branch_id: :desc, party_id: :asc})
  #
  # generates:
  #
  #   CREATE INDEX by_branch_desc_party ON accounts(branch_id DESC, party_id ASC, surname)
  #
  # Note: MySQL only supports index order from 8.0.1 onwards (earlier versions accepted the syntax but ignored it).
  #
  # ====== Creating a partial index
  #
  #   add_index(:accounts, [:branch_id, :party_id], unique: true, where: "active")
  #
  # generates:
  #
  #   CREATE UNIQUE INDEX index_accounts_on_branch_id_and_party_id ON accounts(branch_id, party_id) WHERE active
  #
  # Note: Partial indexes are only supported for PostgreSQL and SQLite.
  #
  # ====== Creating an index with a specific method
  #
  #   add_index(:developers, :name, using: 'btree')
  #
  # generates:
  #
  #   CREATE INDEX index_developers_on_name ON developers USING btree (name) -- PostgreSQL
  #   CREATE INDEX index_developers_on_name USING btree ON developers (name) -- MySQL
  #
  # Note: only supported by PostgreSQL and MySQL
  #
  # ====== Creating an index with a specific operator class
  #
  #   add_index(:developers, :name, using: 'gist', opclass: :gist_trgm_ops)
  #   # CREATE INDEX developers_on_name ON developers USING gist (name gist_trgm_ops) -- PostgreSQL
  #
  #   add_index(:developers, [:name, :city], using: 'gist', opclass: { city: :gist_trgm_ops })
  #   # CREATE INDEX developers_on_name_and_city ON developers USING gist (name, city gist_trgm_ops) -- PostgreSQL
  #
  #   add_index(:developers, [:name, :city], using: 'gist', opclass: :gist_trgm_ops)
  #   # CREATE INDEX developers_on_name_and_city ON developers USING gist (name gist_trgm_ops, city gist_trgm_ops) -- PostgreSQL
  #
  # Note: only supported by PostgreSQL
  #
  # ====== Creating an index with a specific type
  #
  #   add_index(:developers, :name, type: :fulltext)
  #
  # generates:
  #
  #   CREATE FULLTEXT INDEX index_developers_on_name ON developers (name) -- MySQL
  #
  # Note: only supported by MySQL.
  #
  # ====== Creating an index with a specific algorithm
  #
  #  add_index(:developers, :name, algorithm: :concurrently)
  #  # CREATE INDEX CONCURRENTLY developers_on_name on developers (name)
  #
  # Note: only supported by PostgreSQL.
  #
  # Concurrently adding an index is not supported in a transaction.
  #
  # For more information see the {"Transactional Migrations" section}[rdoc-ref:Migration].
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#851
  def add_index(table_name, column_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1339
  def add_index_options(table_name, column_name, name: T.unsafe(nil), if_not_exists: T.unsafe(nil), internal: T.unsafe(nil), **options); end

  # Adds a reference. The reference column is a bigint by default,
  # the <tt>:type</tt> option can be used to specify a different type.
  # Optionally adds a +_type+ column, if <tt>:polymorphic</tt> option is provided.
  # #add_reference and #add_belongs_to are acceptable.
  #
  # The +options+ hash can include the following keys:
  # [<tt>:type</tt>]
  #   The reference column type. Defaults to +:bigint+.
  # [<tt>:index</tt>]
  #   Add an appropriate index. Defaults to true.
  #   See #add_index for usage of this option.
  # [<tt>:foreign_key</tt>]
  #   Add an appropriate foreign key constraint. Defaults to false, pass true
  #   to add. In case the join table can't be inferred from the association
  #   pass <tt>:to_table</tt> with the appropriate table name.
  # [<tt>:polymorphic</tt>]
  #   Whether an additional +_type+ column should be added. Defaults to false.
  # [<tt>:null</tt>]
  #   Whether the column allows nulls. Defaults to true.
  #
  # ====== Create a user_id bigint column without an index
  #
  #   add_reference(:products, :user, index: false)
  #
  # ====== Create a user_id string column
  #
  #   add_reference(:products, :user, type: :string)
  #
  # ====== Create supplier_id, supplier_type columns
  #
  #   add_reference(:products, :supplier, polymorphic: true)
  #
  # ====== Create a supplier_id column with a unique index
  #
  #   add_reference(:products, :supplier, index: { unique: true })
  #
  # ====== Create a supplier_id column with a named index
  #
  #   add_reference(:products, :supplier, index: { name: "my_supplier_index" })
  #
  # ====== Create a supplier_id column and appropriate foreign key
  #
  #   add_reference(:products, :supplier, foreign_key: true)
  #
  # ====== Create a supplier_id column and a foreign key to the firms table
  #
  #   add_reference(:products, :supplier, foreign_key: { to_table: :firms })
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#988
  def add_reference(table_name, ref_name, **options); end

  # Adds timestamps (+created_at+ and +updated_at+) columns to +table_name+.
  # Additional options (like +:null+) are forwarded to #add_column.
  #
  #   add_timestamps(:suppliers, null: true)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1316
  def add_timestamps(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1228
  def assume_migrated_upto_version(version); end

  # Changes the column's definition according to the new options.
  # See TableDefinition#column for details of the options you can use.
  #
  #   change_column(:suppliers, :name, :string, limit: 80)
  #   change_column(:accounts, :description, :text)
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#679
  def change_column(table_name, column_name, type, **options); end

  # Changes the comment for a column or removes it if +nil+.
  #
  # Passing a hash containing +:from+ and +:to+ will make this change
  # reversible in migration:
  #
  #   change_column_comment(:posts, :state, from: "old_comment", to: "new_comment")
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1398
  def change_column_comment(table_name, column_name, comment_or_changes); end

  # Sets a new default value for a column:
  #
  #   change_column_default(:suppliers, :qualification, 'new')
  #   change_column_default(:accounts, :authorized, 1)
  #
  # Setting the default to +nil+ effectively drops the default:
  #
  #   change_column_default(:users, :email, nil)
  #
  # Passing a hash containing +:from+ and +:to+ will make this change
  # reversible in migration:
  #
  #   change_column_default(:posts, :state, from: nil, to: "draft")
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#697
  def change_column_default(table_name, column_name, default_or_changes); end

  # Sets or removes a <tt>NOT NULL</tt> constraint on a column. The +null+ flag
  # indicates whether the value can be +NULL+. For example
  #
  #   change_column_null(:users, :nickname, false)
  #
  # says nicknames cannot be +NULL+ (adds the constraint), whereas
  #
  #   change_column_null(:users, :nickname, true)
  #
  # allows them to be +NULL+ (drops the constraint).
  #
  # The method accepts an optional fourth argument to replace existing
  # <tt>NULL</tt>s with some other value. Use that one when enabling the
  # constraint if needed, since otherwise those rows would not be valid.
  #
  # Please note the fourth argument does not set a column's default.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#717
  def change_column_null(table_name, column_name, null, default = T.unsafe(nil)); end

  # A block for changing columns in +table+.
  #
  #   # change_table() yields a Table instance
  #   change_table(:suppliers) do |t|
  #     t.column :name, :string, limit: 60
  #     # Other column alterations here
  #   end
  #
  # The +options+ hash can include the following keys:
  # [<tt>:bulk</tt>]
  #   Set this to true to make this a bulk alter query, such as
  #
  #     ALTER TABLE `users` ADD COLUMN age INT, ADD COLUMN birthdate DATETIME ...
  #
  #   Defaults to false.
  #
  #   Only supported on the MySQL and PostgreSQL adapter, ignored elsewhere.
  #
  # ====== Add a column
  #
  #   change_table(:suppliers) do |t|
  #     t.column :name, :string, limit: 60
  #   end
  #
  # ====== Change type of a column
  #
  #   change_table(:suppliers) do |t|
  #     t.change :metadata, :json
  #   end
  #
  # ====== Add 2 integer columns
  #
  #   change_table(:suppliers) do |t|
  #     t.integer :width, :height, null: false, default: 0
  #   end
  #
  # ====== Add created_at/updated_at columns
  #
  #   change_table(:suppliers) do |t|
  #     t.timestamps
  #   end
  #
  # ====== Add a foreign key column
  #
  #   change_table(:suppliers) do |t|
  #     t.references :company
  #   end
  #
  # Creates a <tt>company_id(bigint)</tt> column.
  #
  # ====== Add a polymorphic foreign key column
  #
  #  change_table(:suppliers) do |t|
  #    t.belongs_to :company, polymorphic: true
  #  end
  #
  # Creates <tt>company_type(varchar)</tt> and <tt>company_id(bigint)</tt> columns.
  #
  # ====== Remove a column
  #
  #  change_table(:suppliers) do |t|
  #    t.remove :company
  #  end
  #
  # ====== Remove several columns
  #
  #  change_table(:suppliers) do |t|
  #    t.remove :company_id
  #    t.remove :width, :height
  #  end
  #
  # ====== Remove an index
  #
  #  change_table(:suppliers) do |t|
  #    t.remove_index :company_id
  #  end
  #
  # See also Table for details on all of the various column transformations.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#487
  def change_table(table_name, **options); end

  # Changes the comment for a table or removes it if +nil+.
  #
  # Passing a hash containing +:from+ and +:to+ will make this change
  # reversible in migration:
  #
  #   change_table_comment(:posts, from: "old_comment", to: "new_comment")
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1388
  def change_table_comment(table_name, comment_or_changes); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1195
  def check_constraint_options(table_name, expression, options); end

  # Returns an array of check constraints for the given table.
  # The check constraints are represented as CheckConstraintDefinition objects.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1167
  def check_constraints(table_name); end

  # Checks to see if a column exists in a given table.
  #
  #   # Check a column exists
  #   column_exists?(:suppliers, :name)
  #
  #   # Check a column exists of a particular type
  #   #
  #   # This works for standard non-casted types (eg. string) but is unreliable
  #   # for types that may get cast to something else (eg. char, bigint).
  #   column_exists?(:suppliers, :name, :string)
  #
  #   # Check a column exists with a specific definition
  #   column_exists?(:suppliers, :name, :string, limit: 100)
  #   column_exists?(:suppliers, :name, :string, default: 'default')
  #   column_exists?(:suppliers, :name, :string, null: false)
  #   column_exists?(:suppliers, :tax, :decimal, precision: 8, scale: 2)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#138
  def column_exists?(table_name, column_name, type = T.unsafe(nil), **options); end

  # Returns an array of +Column+ objects for the table specified by +table_name+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#114
  def columns(table_name); end

  # Given a set of columns and an ORDER BY clause, returns the columns for a SELECT DISTINCT.
  # PostgreSQL, MySQL, and Oracle override this for custom DISTINCT syntax - they
  # require the order columns appear in the SELECT.
  #
  #   columns_for_distinct("posts.id", ["posts.created_at desc"])
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1288
  def columns_for_distinct(columns, orders); end

  # Creates a new join table with the name created using the lexical order of the first two
  # arguments. These arguments can be a String or a Symbol.
  #
  #   # Creates a table called 'assemblies_parts' with no id.
  #   create_join_table(:assemblies, :parts)
  #
  # You can pass an +options+ hash which can include the following keys:
  # [<tt>:table_name</tt>]
  #   Sets the table name, overriding the default.
  # [<tt>:column_options</tt>]
  #   Any extra options you want appended to the columns definition.
  # [<tt>:options</tt>]
  #   Any extra options you want appended to the table definition.
  # [<tt>:temporary</tt>]
  #   Make a temporary table.
  # [<tt>:force</tt>]
  #   Set to true to drop the table before creating it.
  #   Defaults to false.
  #
  # Note that #create_join_table does not create any indices by default; you can use
  # its block form to do so yourself:
  #
  #   create_join_table :products, :categories do |t|
  #     t.index :product_id
  #     t.index :category_id
  #   end
  #
  # ====== Add a backend specific option to the generated SQL (MySQL)
  #
  #   create_join_table(:assemblies, :parts, options: 'ENGINE=InnoDB DEFAULT CHARSET=utf8')
  #
  # generates:
  #
  #   CREATE TABLE assemblies_parts (
  #     assembly_id bigint NOT NULL,
  #     part_id bigint NOT NULL,
  #   ) ENGINE=InnoDB DEFAULT CHARSET=utf8
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#384
  def create_join_table(table_1, table_2, column_options: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1402
  def create_schema_dumper(options); end

  # Creates a new table with the name +table_name+. +table_name+ may either
  # be a String or a Symbol.
  #
  # There are two ways to work with #create_table. You can use the block
  # form or the regular form, like this:
  #
  # === Block form
  #
  #   # create_table() passes a TableDefinition object to the block.
  #   # This form will not only create the table, but also columns for the
  #   # table.
  #
  #   create_table(:suppliers) do |t|
  #     t.column :name, :string, limit: 60
  #     # Other fields here
  #   end
  #
  # === Block form, with shorthand
  #
  #   # You can also use the column types as method calls, rather than calling the column method.
  #   create_table(:suppliers) do |t|
  #     t.string :name, limit: 60
  #     # Other fields here
  #   end
  #
  # === Regular form
  #
  #   # Creates a table called 'suppliers' with no columns.
  #   create_table(:suppliers)
  #   # Add a column to 'suppliers'.
  #   add_column(:suppliers, :name, :string, {limit: 60})
  #
  # The +options+ hash can include the following keys:
  # [<tt>:id</tt>]
  #   Whether to automatically add a primary key column. Defaults to true.
  #   Join tables for {ActiveRecord::Base.has_and_belongs_to_many}[rdoc-ref:Associations::ClassMethods#has_and_belongs_to_many] should set it to false.
  #
  #   A Symbol can be used to specify the type of the generated primary key column.
  # [<tt>:primary_key</tt>]
  #   The name of the primary key, if one is to be added automatically.
  #   Defaults to +id+. If <tt>:id</tt> is false, then this option is ignored.
  #
  #   If an array is passed, a composite primary key will be created.
  #
  #   Note that Active Record models will automatically detect their
  #   primary key. This can be avoided by using
  #   {self.primary_key=}[rdoc-ref:AttributeMethods::PrimaryKey::ClassMethods#primary_key=] on the model
  #   to define the key explicitly.
  #
  # [<tt>:options</tt>]
  #   Any extra options you want appended to the table definition.
  # [<tt>:temporary</tt>]
  #   Make a temporary table.
  # [<tt>:force</tt>]
  #   Set to true to drop the table before creating it.
  #   Set to +:cascade+ to drop dependent objects as well.
  #   Defaults to false.
  # [<tt>:if_not_exists</tt>]
  #   Set to true to avoid raising an error when the table already exists.
  #   Defaults to false.
  # [<tt>:as</tt>]
  #   SQL to use to generate the table. When this option is used, the block is
  #   ignored, as are the <tt>:id</tt> and <tt>:primary_key</tt> options.
  #
  # ====== Add a backend specific option to the generated SQL (MySQL)
  #
  #   create_table(:suppliers, options: 'ENGINE=InnoDB DEFAULT CHARSET=utf8mb4')
  #
  # generates:
  #
  #   CREATE TABLE suppliers (
  #     id bigint auto_increment PRIMARY KEY
  #   ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
  #
  # ====== Rename the primary key column
  #
  #   create_table(:objects, primary_key: 'guid') do |t|
  #     t.column :name, :string, limit: 80
  #   end
  #
  # generates:
  #
  #   CREATE TABLE objects (
  #     guid bigint auto_increment PRIMARY KEY,
  #     name varchar(80)
  #   )
  #
  # ====== Change the primary key column type
  #
  #   create_table(:tags, id: :string) do |t|
  #     t.column :label, :string
  #   end
  #
  # generates:
  #
  #   CREATE TABLE tags (
  #     id varchar PRIMARY KEY,
  #     label varchar
  #   )
  #
  # ====== Create a composite primary key
  #
  #   create_table(:orders, primary_key: [:product_id, :client_id]) do |t|
  #     t.belongs_to :product
  #     t.belongs_to :client
  #   end
  #
  # generates:
  #
  #   CREATE TABLE order (
  #       product_id bigint NOT NULL,
  #       client_id bigint NOT NULL
  #   );
  #
  #   ALTER TABLE ONLY "orders"
  #     ADD CONSTRAINT orders_pkey PRIMARY KEY (product_id, client_id);
  #
  # ====== Do not add a primary key column
  #
  #   create_table(:categories_suppliers, id: false) do |t|
  #     t.column :category_id, :bigint
  #     t.column :supplier_id, :bigint
  #   end
  #
  # generates:
  #
  #   CREATE TABLE categories_suppliers (
  #     category_id bigint,
  #     supplier_id bigint
  #   )
  #
  # ====== Create a temporary table based on a query
  #
  #   create_table(:long_query, temporary: true,
  #     as: "SELECT * FROM orders INNER JOIN line_items ON order_id=orders.id")
  #
  # generates:
  #
  #   CREATE TEMPORARY TABLE long_query AS
  #     SELECT * FROM orders INNER JOIN line_items ON order_id=orders.id
  #
  # See also TableDefinition#column for details on how to create columns.
  #
  # @yield [td]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#299
  def create_table(table_name, id: T.unsafe(nil), primary_key: T.unsafe(nil), force: T.unsafe(nil), **options); end

  # Checks to see if the data source +name+ exists on the database.
  #
  #   data_source_exists?(:ebooks)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#44
  def data_source_exists?(name); end

  # Returns the relation names usable to back Active Record models.
  # For most adapters this means all #tables and #views.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#34
  def data_sources; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1292
  def distinct_relation_for_primary_key(relation); end

  # Drops the join table specified by the given arguments.
  # See #create_join_table for details.
  #
  # Although this command ignores the block if one is given, it can be helpful
  # to provide one in a migration's +change+ method so it can be reverted.
  # In that case, the block will be used by #create_join_table.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#404
  def drop_join_table(table_1, table_2, **options); end

  # Drops a table from the database.
  #
  # [<tt>:force</tt>]
  #   Set to +:cascade+ to drop dependent objects as well.
  #   Defaults to false.
  # [<tt>:if_exists</tt>]
  #   Set to +true+ to only drop the table if it exists.
  #   Defaults to false.
  #
  # Although this command ignores most +options+ and the block if one is given,
  # it can be helpful to provide these in a migration's +change+ method so it can be reverted.
  # In that case, +options+ and the block will be used by #create_table.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#517
  def drop_table(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1219
  def dump_schema_information; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1153
  def foreign_key_column_for(table_name); end

  # Checks to see if a foreign key exists on a table for a given foreign key definition.
  #
  #   # Checks to see if a foreign key exists.
  #   foreign_key_exists?(:accounts, :branches)
  #
  #   # Checks to see if a foreign key on a specified column exists.
  #   foreign_key_exists?(:accounts, column: :owner_id)
  #
  #   # Checks to see if a foreign key with a custom name exists.
  #   foreign_key_exists?(:accounts, name: "special_fk_name")
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1149
  def foreign_key_exists?(from_table, to_table = T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1158
  def foreign_key_options(from_table, to_table, options); end

  # Returns an array of foreign keys for the given table.
  # The foreign keys are represented as ForeignKeyDefinition objects.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1027
  def foreign_keys(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1365
  def index_algorithm(algorithm); end

  # Checks to see if an index exists on a table for a given index definition.
  #
  #   # Check an index exists
  #   index_exists?(:suppliers, :company_id)
  #
  #   # Check an index on multiple columns exists
  #   index_exists?(:suppliers, [:company_id, :company_type])
  #
  #   # Check a unique index exists
  #   index_exists?(:suppliers, :company_id, unique: true)
  #
  #   # Check an index with a custom name exists
  #   index_exists?(:suppliers, :company_id, name: "idx_company_id")
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#99
  def index_exists?(table_name, column_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#920
  def index_name(table_name, options); end

  # Verifies the existence of an index with a given name.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#935
  def index_name_exists?(table_name, index_name); end

  # Returns an array of indexes for the given table.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#81
  def indexes(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1224
  def internal_string_options_for_primary_key; end

  # Returns a hash of mappings from the abstract data types to the native
  # database types. See TableDefinition#column for details on the recognized
  # abstract data types.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#14
  def native_database_types; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1378
  def options_include_default?(options); end

  # Returns just a table's primary key
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#151
  def primary_key(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1371
  def quoted_columns_for_index(column_names, options); end

  # Removes the reference(s). Also removes a +type+ column if one exists.
  # #remove_reference and #remove_belongs_to are acceptable.
  #
  # ====== Remove the reference
  #
  #   remove_reference(:products, :user, index: false)
  #
  # ====== Remove polymorphic reference
  #
  #   remove_reference(:products, :supplier, polymorphic: true)
  #
  # ====== Remove the reference with a foreign key
  #
  #   remove_reference(:products, :user, foreign_key: true)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1008
  def remove_belongs_to(table_name, ref_name, foreign_key: T.unsafe(nil), polymorphic: T.unsafe(nil), **options); end

  # Removes the given check constraint from the table.
  #
  #   remove_check_constraint :products, name: "price_check"
  #
  # The +expression+ parameter will be ignored if present. It can be helpful
  # to provide this in a migration's +change+ method so it can be reverted.
  # In that case, +expression+ will be used by #add_check_constraint.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1208
  def remove_check_constraint(table_name, expression = T.unsafe(nil), **options); end

  # Removes the column from the table definition.
  #
  #   remove_column(:suppliers, :qualification)
  #
  # The +type+ and +options+ parameters will be ignored if present. It can be helpful
  # to provide these in a migration's +change+ method so it can be reverted.
  # In that case, +type+ and +options+ will be used by #add_column.
  # Depending on the database you're using, indexes using this column may be
  # automatically removed or modified to remove this column from the index.
  #
  # If the options provided include an +if_exists+ key, it will be used to check if the
  # column does not exist. This will silently ignore the migration rather than raising
  # if the column was already used.
  #
  #   remove_column(:suppliers, :qualification, if_exists: true)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#667
  def remove_column(table_name, column_name, type = T.unsafe(nil), **options); end

  # Removes the given columns from the table definition.
  #
  #   remove_columns(:suppliers, :qualification, :experience)
  #
  # +type+ and other column options can be passed to make migration reversible.
  #
  #    remove_columns(:suppliers, :qualification, :experience, type: :string, null: false)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#643
  def remove_columns(table_name, *column_names, type: T.unsafe(nil), **options); end

  # Removes the given foreign key from the table. Any option parameters provided
  # will be used to re-add the foreign key in case of a migration rollback.
  # It is recommended that you provide any options used when creating the foreign
  # key so that the migration can be reverted properly.
  #
  # Removes the foreign key on +accounts.branch_id+.
  #
  #   remove_foreign_key :accounts, :branches
  #
  # Removes the foreign key on +accounts.owner_id+.
  #
  #   remove_foreign_key :accounts, column: :owner_id
  #
  # Removes the foreign key on +accounts.owner_id+.
  #
  #   remove_foreign_key :accounts, to_table: :owners
  #
  # Removes the foreign key named +special_fk_name+ on the +accounts+ table.
  #
  #   remove_foreign_key :accounts, name: :special_fk_name
  #
  # Checks if the foreign key exists before trying to remove it. Will silently ignore indexes that
  # don't exist.
  #
  #   remove_foreign_key :accounts, :branches, if_exists: true
  #
  # The +options+ hash accepts the same keys as SchemaStatements#add_foreign_key
  # with an addition of
  # [<tt>:to_table</tt>]
  #   The name of the table that contains the referenced primary key.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1126
  def remove_foreign_key(from_table, to_table = T.unsafe(nil), **options); end

  # Removes the given index from the table.
  #
  # Removes the index on +branch_id+ in the +accounts+ table if exactly one such index exists.
  #
  #   remove_index :accounts, :branch_id
  #
  # Removes the index on +branch_id+ in the +accounts+ table if exactly one such index exists.
  #
  #   remove_index :accounts, column: :branch_id
  #
  # Removes the index on +branch_id+ and +party_id+ in the +accounts+ table if exactly one such index exists.
  #
  #   remove_index :accounts, column: [:branch_id, :party_id]
  #
  # Removes the index named +by_branch_party+ in the +accounts+ table.
  #
  #   remove_index :accounts, name: :by_branch_party
  #
  # Removes the index on +branch_id+ named +by_branch_party+ in the +accounts+ table.
  #
  #   remove_index :accounts, :branch_id, name: :by_branch_party
  #
  # Checks if the index exists before trying to remove it. Will silently ignore indexes that
  # don't exist.
  #
  #   remove_index :accounts, if_exists: true
  #
  # Removes the index named +by_branch_party+ in the +accounts+ table +concurrently+.
  #
  #   remove_index :accounts, name: :by_branch_party, algorithm: :concurrently
  #
  # Note: only supported by PostgreSQL.
  #
  # Concurrently removing an index is not supported in a transaction.
  #
  # For more information see the {"Transactional Migrations" section}[rdoc-ref:Migration].
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#894
  def remove_index(table_name, column_name = T.unsafe(nil), **options); end

  # Removes the reference(s). Also removes a +type+ column if one exists.
  # #remove_reference and #remove_belongs_to are acceptable.
  #
  # ====== Remove the reference
  #
  #   remove_reference(:products, :user, index: false)
  #
  # ====== Remove polymorphic reference
  #
  #   remove_reference(:products, :supplier, polymorphic: true)
  #
  # ====== Remove the reference with a foreign key
  #
  #   remove_reference(:products, :user, foreign_key: true)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1008
  def remove_reference(table_name, ref_name, foreign_key: T.unsafe(nil), polymorphic: T.unsafe(nil), **options); end

  # Removes the timestamp columns (+created_at+ and +updated_at+) from the table definition.
  #
  #  remove_timestamps(:suppliers)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1331
  def remove_timestamps(table_name, **options); end

  # Renames a column.
  #
  #   rename_column(:suppliers, :description, :name)
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#725
  def rename_column(table_name, column_name, new_column_name); end

  # Renames an index.
  #
  # Rename the +index_people_on_last_name+ index to +index_users_on_last_name+:
  #
  #   rename_index :people, 'index_people_on_last_name', 'index_users_on_last_name'
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#908
  def rename_index(table_name, old_name, new_name); end

  # Renames a table.
  #
  #   rename_table('octopuses', 'octopi')
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#501
  def rename_table(table_name, new_name); end

  # Truncates a table alias according to the limits of the current adapter.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#28
  def table_alias_for(table_name); end

  # Returns the table comment that's stored in database metadata.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#23
  def table_comment(table_name); end

  # Checks to see if the table +table_name+ exists on the database.
  #
  #   table_exists?(:developers)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#59
  def table_exists?(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#18
  def table_options(table_name); end

  # Returns an array of table names defined in the database.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#51
  def tables; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1248
  def type_to_sql(type, limit: T.unsafe(nil), precision: T.unsafe(nil), scale: T.unsafe(nil), **_arg4); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1335
  def update_table_definition(table_name, base); end

  # Checks to see if the view +view_name+ exists on the database.
  #
  #   view_exists?(:ebooks)
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#74
  def view_exists?(view_name); end

  # Returns an array of view names defined in the database.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#66
  def views; end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1636
  def add_column_for_alter(table_name, column_name, type, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1411
  def add_index_sort_order(quoted_columns, **options); end

  # Overridden by the MySQL adapter for supporting index lengths and by
  # the PostgreSQL adapter for supporting operator classes.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1428
  def add_options_for_index_columns(quoted_columns, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1654
  def add_timestamps_for_alter(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1611
  def bulk_change_table(table_name, operations); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1607
  def can_remove_index_by_name?(column_name, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1581
  def check_constraint_for(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1587
  def check_constraint_for!(table_name, expression: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1571
  def check_constraint_name(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1407
  def column_options_keys; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1498
  def create_alter_table(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1494
  def create_table_definition(name, **options); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1684
  def data_source_sql(name = T.unsafe(nil), type: T.unsafe(nil)); end

  # Try to identify whether the given column name is an expression
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1534
  def expression_column_name?(column_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1563
  def extract_foreign_key_action(specifier); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1598
  def extract_new_comment_value(default_or_changes); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1598
  def extract_new_default_value(default_or_changes); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1502
  def extract_table_options!(options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1506
  def fetch_type_metadata(sql_type); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1553
  def foreign_key_for(from_table, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1558
  def foreign_key_for!(from_table, to_table: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1544
  def foreign_key_name(table_name, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1517
  def index_column_names(column_names); end

  # @raise [ArgumentError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1436
  def index_name_for_remove(table_name, column_name, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1525
  def index_name_options(column_names); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1671
  def insert_versions_sql(versions); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1418
  def options_for_index_columns(options); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1688
  def quoted_scope(name = T.unsafe(nil), type: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1646
  def remove_column_for_alter(table_name, column_name, type = T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1650
  def remove_columns_for_alter(table_name, *column_names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1667
  def remove_timestamps_for_alter(table_name, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1477
  def rename_column_indexes(table_name, column_name, new_column_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1642
  def rename_column_sql(table_name, column_name, new_column_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1468
  def rename_table_indexes(table_name, new_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1490
  def schema_creation; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1538
  def strip_table_name_prefix_and_suffix(table_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_statements.rb#1592
  def validate_index_length!(table_name, new_name, internal = T.unsafe(nil)); end
end

class ActiveRecord::ConnectionAdapters::SqlTypeMetadata
  include ::ActiveRecord::ConnectionAdapters::Deduplicable
  extend ::ActiveRecord::ConnectionAdapters::Deduplicable::ClassMethods

  # @return [SqlTypeMetadata] a new instance of SqlTypeMetadata
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#11
  def initialize(sql_type: T.unsafe(nil), type: T.unsafe(nil), limit: T.unsafe(nil), precision: T.unsafe(nil), scale: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#19
  def ==(other); end

  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#19
  def eql?(other); end

  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#29
  def hash; end

  # Returns the value of attribute limit.
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#9
  def limit; end

  # Returns the value of attribute precision.
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#9
  def precision; end

  # Returns the value of attribute scale.
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#9
  def scale; end

  # Returns the value of attribute sql_type.
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#9
  def sql_type; end

  # Returns the value of attribute type.
  #
  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#9
  def type; end

  private

  # source://activerecord//lib/active_record/connection_adapters/sql_type_metadata.rb#39
  def deduplicated; end
end

# Represents an SQL table in an abstract way for updating a table.
# Also see TableDefinition and {connection.create_table}[rdoc-ref:SchemaStatements#create_table]
#
# Available transformations are:
#
#   change_table :table do |t|
#     t.primary_key
#     t.column
#     t.index
#     t.rename_index
#     t.timestamps
#     t.change
#     t.change_default
#     t.change_null
#     t.rename
#     t.references
#     t.belongs_to
#     t.check_constraint
#     t.string
#     t.text
#     t.integer
#     t.bigint
#     t.float
#     t.decimal
#     t.numeric
#     t.datetime
#     t.timestamp
#     t.time
#     t.date
#     t.binary
#     t.blob
#     t.boolean
#     t.foreign_key
#     t.json
#     t.virtual
#     t.remove
#     t.remove_foreign_key
#     t.remove_references
#     t.remove_belongs_to
#     t.remove_index
#     t.remove_check_constraint
#     t.remove_timestamps
#   end
class ActiveRecord::ConnectionAdapters::Table
  include ::ActiveRecord::ConnectionAdapters::ColumnMethods
  extend ::ActiveRecord::ConnectionAdapters::ColumnMethods::ClassMethods

  # @return [Table] a new instance of Table
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#618
  def initialize(table_name, base); end

  # Adds a reference.
  #
  #  t.references(:user)
  #  t.belongs_to(:supplier, foreign_key: true)
  #
  # See {connection.add_reference}[rdoc-ref:SchemaStatements#add_reference] for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#763
  def belongs_to(*args, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def bigint(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def binary(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def blob(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def boolean(*names, **options); end

  # Changes the column's definition according to the new options.
  #
  #  t.change(:name, :string, limit: 80)
  #  t.change(:description, :text)
  #
  # See TableDefinition#column for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#692
  def change(column_name, type, **options); end

  # Sets a new default value for a column.
  #
  #  t.change_default(:qualification, 'new')
  #  t.change_default(:authorized, 1)
  #  t.change_default(:status, from: nil, to: "draft")
  #
  # See {connection.change_column_default}[rdoc-ref:SchemaStatements#change_column_default]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#703
  def change_default(column_name, default_or_changes); end

  # Sets or removes a NOT NULL constraint on a column.
  #
  #  t.change_null(:qualification, true)
  #  t.change_null(:qualification, false, 0)
  #
  # See {connection.change_column_null}[rdoc-ref:SchemaStatements#change_column_null]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#713
  def change_null(column_name, null, default = T.unsafe(nil)); end

  # Adds a check constraint.
  #
  #  t.check_constraint("price > 0", name: "price_check")
  #
  # See {connection.add_check_constraint}[rdoc-ref:SchemaStatements#add_check_constraint]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#817
  def check_constraint(*args, **options); end

  # Adds a new column to the named table.
  #
  #  t.column(:name, :string)
  #
  # See TableDefinition#column for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#628
  def column(column_name, type, index: T.unsafe(nil), **options); end

  # Checks to see if a column exists.
  #
  #  t.string(:name) unless t.column_exists?(:name, :string)
  #
  # See {connection.column_exists?}[rdoc-ref:SchemaStatements#column_exists?]
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#641
  def column_exists?(column_name, type = T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def date(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def datetime(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def decimal(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def float(*names, **options); end

  # Adds a foreign key to the table using a supplied table name.
  #
  #  t.foreign_key(:authors)
  #  t.foreign_key(:authors, column: :author_id, primary_key: "id")
  #
  # See {connection.add_foreign_key}[rdoc-ref:SchemaStatements#add_foreign_key]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#789
  def foreign_key(*args, **options); end

  # Checks to see if a foreign key exists.
  #
  #  t.foreign_key(:authors) unless t.foreign_key_exists?(:authors)
  #
  # See {connection.foreign_key_exists?}[rdoc-ref:SchemaStatements#foreign_key_exists?]
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#808
  def foreign_key_exists?(*args, **options); end

  # Adds a new index to the table. +column_name+ can be a single Symbol, or
  # an Array of Symbols.
  #
  #  t.index(:name)
  #  t.index([:branch_id, :party_id], unique: true)
  #  t.index([:branch_id, :party_id], unique: true, name: 'by_branch_party')
  #
  # See {connection.add_index}[rdoc-ref:SchemaStatements#add_index] for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#653
  def index(column_name, **options); end

  # Checks to see if an index exists.
  #
  #  unless t.index_exists?(:branch_id)
  #    t.index(:branch_id)
  #  end
  #
  # See {connection.index_exists?}[rdoc-ref:SchemaStatements#index_exists?]
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#664
  def index_exists?(column_name, options = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def integer(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def json(*names, **options); end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#616
  def name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def numeric(*names, **options); end

  # Adds a reference.
  #
  #  t.references(:user)
  #  t.belongs_to(:supplier, foreign_key: true)
  #
  # See {connection.add_reference}[rdoc-ref:SchemaStatements#add_reference] for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#763
  def references(*args, **options); end

  # Removes the column(s) from the table definition.
  #
  #  t.remove(:qualification)
  #  t.remove(:qualification, :experience)
  #
  # See {connection.remove_columns}[rdoc-ref:SchemaStatements#remove_columns]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#723
  def remove(*column_names, **options); end

  # Removes a reference. Optionally removes a +type+ column.
  #
  #  t.remove_references(:user)
  #  t.remove_belongs_to(:supplier, polymorphic: true)
  #
  # See {connection.remove_reference}[rdoc-ref:SchemaStatements#remove_reference]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#776
  def remove_belongs_to(*args, **options); end

  # Removes the given check constraint from the table.
  #
  #  t.remove_check_constraint(name: "price_check")
  #
  # See {connection.remove_check_constraint}[rdoc-ref:SchemaStatements#remove_check_constraint]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#826
  def remove_check_constraint(*args, **options); end

  # Removes the given foreign key from the table.
  #
  #  t.remove_foreign_key(:authors)
  #  t.remove_foreign_key(column: :author_id)
  #
  # See {connection.remove_foreign_key}[rdoc-ref:SchemaStatements#remove_foreign_key]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#799
  def remove_foreign_key(*args, **options); end

  # Removes the given index from the table.
  #
  #   t.remove_index(:branch_id)
  #   t.remove_index(column: [:branch_id, :party_id])
  #   t.remove_index(name: :by_branch_party)
  #   t.remove_index(:branch_id, name: :by_branch_party)
  #
  # See {connection.remove_index}[rdoc-ref:SchemaStatements#remove_index]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#735
  def remove_index(column_name = T.unsafe(nil), **options); end

  # Removes a reference. Optionally removes a +type+ column.
  #
  #  t.remove_references(:user)
  #  t.remove_belongs_to(:supplier, polymorphic: true)
  #
  # See {connection.remove_reference}[rdoc-ref:SchemaStatements#remove_reference]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#776
  def remove_references(*args, **options); end

  # Removes the timestamp columns (+created_at+ and +updated_at+) from the table.
  #
  #  t.remove_timestamps
  #
  # See {connection.remove_timestamps}[rdoc-ref:SchemaStatements#remove_timestamps]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#744
  def remove_timestamps(**options); end

  # Renames a column.
  #
  #  t.rename(:description, :name)
  #
  # See {connection.rename_column}[rdoc-ref:SchemaStatements#rename_column]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#753
  def rename(column_name, new_column_name); end

  # Renames the given index on the table.
  #
  #  t.rename_index(:user_id, :account_id)
  #
  # See {connection.rename_index}[rdoc-ref:SchemaStatements#rename_index]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#673
  def rename_index(index_name, new_index_name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def string(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def text(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def time(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def timestamp(*names, **options); end

  # Adds timestamps (+created_at+ and +updated_at+) columns to the table.
  #
  #  t.timestamps(null: false)
  #
  # See {connection.add_timestamps}[rdoc-ref:SchemaStatements#add_timestamps]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#682
  def timestamps(**options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def virtual(*names, **options); end
end

# Represents the schema of an SQL table in an abstract way. This class
# provides methods for manipulating the schema representation.
#
# Inside migration files, the +t+ object in {create_table}[rdoc-ref:SchemaStatements#create_table]
# is actually of this type:
#
#   class SomeMigration < ActiveRecord::Migration[7.0]
#     def up
#       create_table :foo do |t|
#         puts t.class  # => "ActiveRecord::ConnectionAdapters::TableDefinition"
#       end
#     end
#
#     def down
#       ...
#     end
#   end
class ActiveRecord::ConnectionAdapters::TableDefinition
  include ::ActiveRecord::ConnectionAdapters::ColumnMethods
  extend ::ActiveRecord::ConnectionAdapters::ColumnMethods::ClassMethods

  # @return [TableDefinition] a new instance of TableDefinition
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#306
  def initialize(conn, name, temporary: T.unsafe(nil), if_not_exists: T.unsafe(nil), options: T.unsafe(nil), as: T.unsafe(nil), comment: T.unsafe(nil), **_arg7); end

  # Returns a ColumnDefinition for the column with name +name+.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#339
  def [](name); end

  # Returns the value of attribute as.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def as; end

  # Adds a reference.
  #
  #  t.references(:user)
  #  t.belongs_to(:supplier, foreign_key: true)
  #  t.belongs_to(:supplier, foreign_key: true, type: :integer)
  #
  # See {connection.add_reference}[rdoc-ref:SchemaStatements#add_reference] for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#482
  def belongs_to(*args, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def bigint(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def binary(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def blob(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def boolean(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#456
  def check_constraint(expression, **options); end

  # Returns the value of attribute check_constraints.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def check_constraints; end

  # Instantiates a new column for the table.
  # See {connection.add_column}[rdoc-ref:ConnectionAdapters::SchemaStatements#add_column]
  # for available options.
  #
  # Additional options are:
  # * <tt>:index</tt> -
  #   Create an index for the column. Can be either <tt>true</tt> or an options hash.
  #
  # This method returns <tt>self</tt>.
  #
  # == Examples
  #
  #  # Assuming +td+ is an instance of TableDefinition
  #  td.column(:granted, :boolean, index: true)
  #
  # == Short-hand examples
  #
  # Instead of calling #column directly, you can also work with the short-hand definitions for the default types.
  # They use the type as the method name instead of as a parameter and allow for multiple columns to be defined
  # in a single statement.
  #
  # What can be written like this with the regular calls to column:
  #
  #   create_table :products do |t|
  #     t.column :shop_id,     :integer
  #     t.column :creator_id,  :integer
  #     t.column :item_number, :string
  #     t.column :name,        :string, default: "Untitled"
  #     t.column :value,       :string, default: "Untitled"
  #     t.column :created_at,  :datetime
  #     t.column :updated_at,  :datetime
  #   end
  #   add_index :products, :item_number
  #
  # can also be written as follows using the short-hand:
  #
  #   create_table :products do |t|
  #     t.integer :shop_id, :creator_id
  #     t.string  :item_number, index: true
  #     t.string  :name, :value, default: "Untitled"
  #     t.timestamps null: false
  #   end
  #
  # There's a short-hand method for each of the type values declared at the top. And then there's
  # TableDefinition#timestamps that'll add +created_at+ and +updated_at+ as datetimes.
  #
  # TableDefinition#references will add an appropriately-named _id column, plus a corresponding _type
  # column if the <tt>:polymorphic</tt> option is supplied. If <tt>:polymorphic</tt> is a hash of
  # options, these will be used when creating the <tt>_type</tt> column. The <tt>:index</tt> option
  # will also create an index, similar to calling {add_index}[rdoc-ref:ConnectionAdapters::SchemaStatements#add_index].
  # So what can be written like this:
  #
  #   create_table :taggings do |t|
  #     t.integer :tag_id, :tagger_id, :taggable_id
  #     t.string  :tagger_type
  #     t.string  :taggable_type, default: 'Photo'
  #   end
  #   add_index :taggings, :tag_id, name: 'index_taggings_on_tag_id'
  #   add_index :taggings, [:tagger_id, :tagger_type]
  #
  # Can also be written as follows using references:
  #
  #   create_table :taggings do |t|
  #     t.references :tag, index: { name: 'index_taggings_on_tag_id' }
  #     t.references :tagger, polymorphic: true
  #     t.references :taggable, polymorphic: { default: 'Photo' }, index: false
  #   end
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#410
  def column(name, type, index: T.unsafe(nil), **options); end

  # Returns an array of ColumnDefinition objects for the columns of the table.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#336
  def columns; end

  # Returns the value of attribute comment.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def comment; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def date(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def datetime(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def decimal(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def float(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#452
  def foreign_key(to_table, **options); end

  # Returns the value of attribute foreign_keys.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def foreign_keys; end

  # Returns the value of attribute if_not_exists.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def if_not_exists; end

  # Adds index options to the indexes hash, keyed by column name
  # This is primarily used to track indexes that need to be created after the table
  #
  #   index(:account_id, name: 'index_projects_on_account_id')
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#448
  def index(column_name, **options); end

  # Returns the value of attribute indexes.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def indexes; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def integer(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def json(*names, **options); end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def name; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#507
  def new_check_constraint_definition(expression, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#489
  def new_column_definition(name, type, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#499
  def new_foreign_key_definition(to_table, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def numeric(*names, **options); end

  # Returns the value of attribute options.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def options; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#330
  def primary_keys(name = T.unsafe(nil)); end

  # Adds a reference.
  #
  #  t.references(:user)
  #  t.belongs_to(:supplier, foreign_key: true)
  #  t.belongs_to(:supplier, foreign_key: true, type: :integer)
  #
  # See {connection.add_reference}[rdoc-ref:SchemaStatements#add_reference] for details of the options you can use.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#482
  def references(*args, **options); end

  # remove the column +name+ from the table.
  #   remove_column(:account_id)
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#440
  def remove_column(name); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def string(*names, **options); end

  # Returns the value of attribute temporary.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#304
  def temporary; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def text(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def time(*names, **options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def timestamp(*names, **options); end

  # Appends <tt>:datetime</tt> columns <tt>:created_at</tt> and
  # <tt>:updated_at</tt> to the table. See {connection.add_timestamps}[rdoc-ref:SchemaStatements#add_timestamps]
  #
  #   t.timestamps null: false
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#464
  def timestamps(**options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#272
  def virtual(*names, **options); end

  private

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#517
  def aliased_types(name, fallback); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#513
  def create_column_definition(name, type, options); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#521
  def integer_like_primary_key?(type, options); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/schema_definitions.rb#525
  def integer_like_primary_key_type(type, options); end
end

class ActiveRecord::ConnectionAdapters::Transaction
  # @return [Transaction] a new instance of Transaction
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#89
  def initialize(connection, isolation: T.unsafe(nil), joinable: T.unsafe(nil), run_commit_callbacks: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#100
  def add_record(record, ensure_finalize = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#142
  def before_commit_records; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#167
  def closed?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#146
  def commit_records; end

  # Returns the value of attribute connection.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#86
  def connection; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#165
  def full_rollback?; end

  # Returns the value of attribute isolation_level.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#86
  def isolation_level; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#166
  def joinable?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#118
  def materialize!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#122
  def materialized?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#168
  def open?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#110
  def records; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#126
  def rollback_records; end

  # Returns the value of attribute savepoint_name.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#86
  def savepoint_name; end

  # Returns the value of attribute state.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#86
  def state; end

  # Returns the value of attribute written.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#87
  def written; end

  # Sets the attribute written
  #
  # @param value the value to set the attribute written to.
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#87
  def written=(_arg0); end
end

class ActiveRecord::ConnectionAdapters::TransactionManager
  # @return [TransactionManager] a new instance of TransactionManager
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#225
  def initialize(connection); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#233
  def begin_transaction(isolation: T.unsafe(nil), joinable: T.unsafe(nil), _lazy: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#293
  def commit_transaction; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#359
  def current_transaction; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#265
  def disable_lazy_transactions!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#270
  def enable_lazy_transactions!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#274
  def lazy_transactions_enabled?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#278
  def materialize_transactions; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#355
  def open_transactions; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#308
  def rollback_transaction(transaction = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#316
  def within_new_transaction(isolation: T.unsafe(nil), joinable: T.unsafe(nil)); end

  private

  # Deallocate invalidated prepared statements outside of the transaction
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#367
  def after_failure_actions(transaction, error); end
end

# source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#364
ActiveRecord::ConnectionAdapters::TransactionManager::NULL_TRANSACTION = T.let(T.unsafe(nil), ActiveRecord::ConnectionAdapters::NullTransaction)

class ActiveRecord::ConnectionAdapters::TransactionState
  # @return [TransactionState] a new instance of TransactionState
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#6
  def initialize(state = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#11
  def add_child(state); end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#63
  def commit!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#20
  def committed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#44
  def completed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#16
  def finalized?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#67
  def full_commit!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#53
  def full_rollback!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#24
  def fully_committed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#40
  def fully_completed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#32
  def fully_rolledback?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#58
  def invalidate!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#36
  def invalidated?; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#71
  def nullify!; end

  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#48
  def rollback!; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_adapters/abstract/transaction.rb#28
  def rolledback?; end
end

module ActiveRecord::ConnectionHandling
  # source://activerecord//lib/active_record/connection_handling.rb#337
  def clear_active_connections!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_handling.rb#337
  def clear_all_connections!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_handling.rb#333
  def clear_cache!; end

  # Clears the query cache for all connections associated with the current thread.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#266
  def clear_query_caches_for_current_thread; end

  # source://activerecord//lib/active_record/connection_handling.rb#337
  def clear_reloadable_connections!(*_arg0, **_arg1, &_arg2); end

  # Returns +true+ if Active Record is connected.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_handling.rb#317
  def connected?; end

  # Connects to a role (e.g. writing, reading, or a custom role) and/or
  # shard for the duration of the block. At the end of the block the
  # connection will be returned to the original role / shard.
  #
  # If only a role is passed, Active Record will look up the connection
  # based on the requested role. If a non-established role is requested
  # an +ActiveRecord::ConnectionNotEstablished+ error will be raised:
  #
  #   ActiveRecord::Base.connected_to(role: :writing) do
  #     Dog.create! # creates dog using dog writing connection
  #   end
  #
  #   ActiveRecord::Base.connected_to(role: :reading) do
  #     Dog.create! # throws exception because we're on a replica
  #   end
  #
  # When swapping to a shard, the role must be passed as well. If a non-existent
  # shard is passed, an +ActiveRecord::ConnectionNotEstablished+ error will be
  # raised.
  #
  # When a shard and role is passed, Active Record will first lookup the role,
  # and then look up the connection by shard key.
  #
  #   ActiveRecord::Base.connected_to(role: :reading, shard: :shard_one_replica) do
  #     Dog.first # finds first Dog record stored on the shard one replica
  #   end
  #
  # source://activerecord//lib/active_record/connection_handling.rb#137
  def connected_to(role: T.unsafe(nil), shard: T.unsafe(nil), prevent_writes: T.unsafe(nil), &blk); end

  # Returns true if role is the current connected role.
  #
  #   ActiveRecord::Base.connected_to(role: :writing) do
  #     ActiveRecord::Base.connected_to?(role: :writing) #=> true
  #     ActiveRecord::Base.connected_to?(role: :reading) #=> false
  #   end
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_handling.rb#252
  def connected_to?(role:, shard: T.unsafe(nil)); end

  # Connects a role and/or shard to the provided connection names. Optionally +prevent_writes+
  # can be passed to block writes on a connection. +reading+ will automatically set
  # +prevent_writes+ to true.
  #
  # +connected_to_many+ is an alternative to deeply nested +connected_to+ blocks.
  #
  # Usage:
  #
  #   ActiveRecord::Base.connected_to_many(AnimalsRecord, MealsRecord, role: :reading) do
  #     Dog.first # Read from animals replica
  #     Dinner.first # Read from meals replica
  #     Person.first # Read from primary writer
  #   end
  #
  # source://activerecord//lib/active_record/connection_handling.rb#172
  def connected_to_many(*classes, role:, shard: T.unsafe(nil), prevent_writes: T.unsafe(nil)); end

  # Use a specified connection.
  #
  # This method is useful for ensuring that a specific connection is
  # being used. For example, when booting a console in readonly mode.
  #
  # It is not recommended to use this method in a request since it
  # does not yield to a block like +connected_to+.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#198
  def connecting_to(role: T.unsafe(nil), shard: T.unsafe(nil), prevent_writes: T.unsafe(nil)); end

  # Returns the connection currently associated with the class. This can
  # also be used to "borrow" the connection to do database work unrelated
  # to any of the specific Active Records.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#279
  def connection; end

  # Returns the db_config object from the associated connection:
  #
  #  ActiveRecord::Base.connection_db_config
  #    #<ActiveRecord::DatabaseConfigurations::HashConfig:0x00007fd1acbded10 @env_name="development",
  #      @name="primary", @config={pool: 5, timeout: 5000, database: "db/development.sqlite3", adapter: "sqlite3"}>
  #
  # Use only for reading.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#304
  def connection_db_config; end

  # source://activerecord//lib/active_record/connection_handling.rb#308
  def connection_pool; end

  # Return the connection specification name from the current class or its parent.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#286
  def connection_specification_name; end

  # Sets the attribute connection_specification_name
  #
  # @param value the value to set the attribute connection_specification_name to.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#283
  def connection_specification_name=(_arg0); end

  # Connects a model to the databases specified. The +database+ keyword
  # takes a hash consisting of a +role+ and a +database_key+.
  #
  # This will create a connection handler for switching between connections,
  # look up the config hash using the +database_key+ and finally
  # establishes a connection to that config.
  #
  #   class AnimalsModel < ApplicationRecord
  #     self.abstract_class = true
  #
  #     connects_to database: { writing: :primary, reading: :primary_replica }
  #   end
  #
  # +connects_to+ also supports horizontal sharding. The horizontal sharding API
  # also supports read replicas. Connect a model to a list of shards like this:
  #
  #   class AnimalsModel < ApplicationRecord
  #     self.abstract_class = true
  #
  #     connects_to shards: {
  #       default: { writing: :primary, reading: :primary_replica },
  #       shard_two: { writing: :primary_shard_two, reading: :primary_shard_replica_two }
  #     }
  #   end
  #
  # Returns an array of database connections.
  #
  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/connection_handling.rb#81
  def connects_to(database: T.unsafe(nil), shards: T.unsafe(nil)); end

  # Establishes the connection to the database. Accepts a hash as input where
  # the <tt>:adapter</tt> key must be specified with the name of a database adapter (in lower-case)
  # example for regular databases (MySQL, PostgreSQL, etc):
  #
  #   ActiveRecord::Base.establish_connection(
  #     adapter:  "mysql2",
  #     host:     "localhost",
  #     username: "myuser",
  #     password: "mypass",
  #     database: "somedatabase"
  #   )
  #
  # Example for SQLite database:
  #
  #   ActiveRecord::Base.establish_connection(
  #     adapter:  "sqlite3",
  #     database: "path/to/dbfile"
  #   )
  #
  # Also accepts keys as strings (for parsing from YAML for example):
  #
  #   ActiveRecord::Base.establish_connection(
  #     "adapter"  => "sqlite3",
  #     "database" => "path/to/dbfile"
  #   )
  #
  # Or a URL:
  #
  #   ActiveRecord::Base.establish_connection(
  #     "postgres://myuser:mypass@localhost/somedatabase"
  #   )
  #
  # In case {ActiveRecord::Base.configurations}[rdoc-ref:Core.configurations]
  # is set (Rails automatically loads the contents of config/database.yml into it),
  # a symbol can also be given as argument, representing a key in the
  # configuration hash:
  #
  #   ActiveRecord::Base.establish_connection(:production)
  #
  # The exceptions AdapterNotSpecified, AdapterNotFound, and +ArgumentError+
  # may be returned on an error.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#49
  def establish_connection(config_or_env = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_handling.rb#337
  def flush_idle_connections!(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/connection_handling.rb#256
  def lookup_connection_handler(handler_key); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_handling.rb#293
  def primary_class?; end

  # Prohibit swapping shards while inside of the passed block.
  #
  # In some cases you may want to be able to swap shards but not allow a
  # nested call to connected_to or connected_to_many to swap again. This
  # is useful in cases you're using sharding to provide per-request
  # database isolation.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#214
  def prohibit_shard_swapping(enabled = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_handling.rb#321
  def remove_connection(name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/connection_handling.rb#312
  def retrieve_connection; end

  # Determine whether or not shard swapping is currently prohibited
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/connection_handling.rb#223
  def shard_swapping_prohibited?; end

  # Prevent writing to the database regardless of role.
  #
  # In some cases you may want to prevent writes to the database
  # even if you are on a database that can write. +while_preventing_writes+
  # will prevent writes to the database for the duration of the block.
  #
  # This method does not provide the same protection as a readonly
  # user and is meant to be a safeguard against accidental writes.
  #
  # See +READ_QUERY+ for the queries that are blocked by this
  # method.
  #
  # source://activerecord//lib/active_record/connection_handling.rb#238
  def while_preventing_writes(enabled = T.unsafe(nil), &block); end

  private

  # source://activerecord//lib/active_record/connection_handling.rb#382
  def append_to_connected_to_stack(entry); end

  # source://activerecord//lib/active_record/connection_handling.rb#341
  def clear_on_handler(handler); end

  # source://activerecord//lib/active_record/connection_handling.rb#347
  def resolve_config_for_connection(config_or_env); end

  # source://activerecord//lib/active_record/connection_handling.rb#390
  def swap_connection_handler(handler, &blk); end

  # source://activerecord//lib/active_record/connection_handling.rb#357
  def with_handler(handler_key, &blk); end

  # source://activerecord//lib/active_record/connection_handling.rb#362
  def with_role_and_shard(role, shard, prevent_writes); end
end

# source://activerecord//lib/active_record/connection_handling.rb#6
ActiveRecord::ConnectionHandling::DEFAULT_ENV = T.let(T.unsafe(nil), Proc)

# source://activerecord//lib/active_record/connection_handling.rb#5
ActiveRecord::ConnectionHandling::RAILS_ENV = T.let(T.unsafe(nil), Proc)

# Raised when connection to the database could not been established (for example when
# {ActiveRecord::Base.connection=}[rdoc-ref:ConnectionHandling#connection]
# is given a +nil+ object).
class ActiveRecord::ConnectionNotEstablished < ::ActiveRecord::ActiveRecordError; end

# Raised when a connection could not be obtained within the connection
# acquisition timeout period: because max connections in pool
# are in use.
class ActiveRecord::ConnectionTimeoutError < ::ActiveRecord::ConnectionNotEstablished; end

module ActiveRecord::Core
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Core::ClassMethods

  # New objects can be instantiated as either empty (pass no construction parameter) or pre-set with
  # attributes but not yet saved (pass a hash with key names matching the associated table column names).
  # In both instances, valid attribute keys are determined by the column names of the associated table --
  # hence you can't have attributes that aren't part of the table columns.
  #
  # ==== Example:
  #   # Instantiates a single new object
  #   User.new(first_name: 'Jamie')
  #
  # @yield [_self]
  # @yieldparam _self [ActiveRecord::Core] the object that the method was called on
  #
  # source://activerecord//lib/active_record/core.rb#461
  def initialize(attributes = T.unsafe(nil)); end

  # Allows sort on objects
  #
  # source://activerecord//lib/active_record/core.rb#614
  def <=>(other_object); end

  # Returns true if +comparison_object+ is the same exact object, or +comparison_object+
  # is of the same type and +self+ has an ID and it is equal to +comparison_object.id+.
  #
  # Note that new records are different from any other record by definition, unless the
  # other record is the receiver itself. Besides, if you fetch existing records with
  # +select+ and leave the ID out, you're on your own, this predicate will return false.
  #
  # Note also that destroying a record preserves its ID in the model instance, so deleted
  # models are still comparable.
  #
  # source://activerecord//lib/active_record/core.rb#580
  def ==(comparison_object); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#626
  def blank?; end

  # source://activerecord//lib/active_record/core.rb#682
  def connection_handler; end

  # Populate +coder+ with attributes about this record that should be
  # serialized. The structure of +coder+ defined in this method is
  # guaranteed to match the structure of +coder+ passed to the #init_with
  # method.
  #
  # Example:
  #
  #   class Post < ActiveRecord::Base
  #   end
  #   coder = {}
  #   Post.new.encode_with(coder)
  #   coder # => {"attributes" => {"id" => nil, ... }}
  #
  # source://activerecord//lib/active_record/core.rb#565
  def encode_with(coder); end

  # Returns true if +comparison_object+ is the same exact object, or +comparison_object+
  # is of the same type and +self+ has an ID and it is equal to +comparison_object.id+.
  #
  # Note that new records are different from any other record by definition, unless the
  # other record is the receiver itself. Besides, if you fetch existing records with
  # +select+ and leave the ID out, you're on your own, this predicate will return false.
  #
  # Note also that destroying a record preserves its ID in the model instance, so deleted
  # models are still comparable.
  #
  # source://activerecord//lib/active_record/core.rb#580
  def eql?(comparison_object); end

  # Clone and freeze the attributes hash such that associations are still
  # accessible, even on destroyed records, but cloned models will not be
  # frozen.
  #
  # source://activerecord//lib/active_record/core.rb#603
  def freeze; end

  # Returns +true+ if the attributes hash has been frozen.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#609
  def frozen?; end

  # Delegates to id in order to allow two records of the same type and id to work with something like:
  #   [ Person.find(1), Person.find(2), Person.find(3) ] & [ Person.find(1), Person.find(4) ] # => [ Person.find(1) ]
  #
  # source://activerecord//lib/active_record/core.rb#590
  def hash; end

  # Initialize an empty model object from +coder+. +coder+ should be
  # the result of previously encoding an Active Record model, using
  # #encode_with.
  #
  #   class Post < ActiveRecord::Base
  #   end
  #
  #   old_post = Post.new(title: "hello world")
  #   coder = {}
  #   old_post.encode_with(coder)
  #
  #   post = Post.allocate
  #   post.init_with(coder)
  #   post.title # => 'hello world'
  #
  # source://activerecord//lib/active_record/core.rb#488
  def init_with(coder, &block); end

  # Initialize an empty model object from +attributes+.
  # +attributes+ should be an attributes object, and unlike the
  # `initialize` method, no assignment calls are made per attribute.
  #
  # @yield [_self]
  # @yieldparam _self [ActiveRecord::Core] the object that the method was called on
  #
  # source://activerecord//lib/active_record/core.rb#498
  def init_with_attributes(attributes, new_record = T.unsafe(nil)); end

  # Returns the contents of the record as a nicely formatted string.
  #
  # source://activerecord//lib/active_record/core.rb#687
  def inspect; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#622
  def present?; end

  # Takes a PP and prettily prints this record to it, allowing you to get a nice result from <tt>pp record</tt>
  # when pp is required.
  #
  # source://activerecord//lib/active_record/core.rb#705
  def pretty_print(pp); end

  # Marks this record as read only.
  #
  # source://activerecord//lib/active_record/core.rb#678
  def readonly!; end

  # Returns +true+ if the record is read only.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#631
  def readonly?; end

  # Returns a hash of the given methods with their names as keys and returned values as values.
  #
  # source://activerecord//lib/active_record/core.rb#729
  def slice(*methods); end

  # Sets the record to strict_loading mode. This will raise an error
  # if the record tries to lazily load an association.
  #
  #   user = User.first
  #   user.strict_loading! # => true
  #   user.comments
  #   => ActiveRecord::StrictLoadingViolationError
  #
  # === Parameters:
  #
  # * value - Boolean specifying whether to enable or disable strict loading.
  # * mode - Symbol specifying strict loading mode. Defaults to :all. Using
  #          :n_plus_one_only mode will only raise an error if an association
  #          that will lead to an n plus one query is lazily loaded.
  #
  # === Example:
  #
  #   user = User.first
  #   user.strict_loading!(false) # => false
  #   user.comments
  #   => #<ActiveRecord::Associations::CollectionProxy>
  #
  # source://activerecord//lib/active_record/core.rb#661
  def strict_loading!(value = T.unsafe(nil), mode: T.unsafe(nil)); end

  # Returns +true+ if the record is in strict_loading mode.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#636
  def strict_loading?; end

  # Returns the value of attribute strict_loading_mode.
  #
  # source://activerecord//lib/active_record/core.rb#670
  def strict_loading_mode; end

  # Returns +true+ if the record uses strict_loading with +:n_plus_one_only+ mode enabled.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#673
  def strict_loading_n_plus_one_only?; end

  # Returns an array of the values returned by the given methods.
  #
  # source://activerecord//lib/active_record/core.rb#734
  def values_at(*methods); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/core.rb#771
  def custom_inspect_method_defined?; end

  # source://activerecord//lib/active_record/core.rb#751
  def init_internals; end

  # source://activerecord//lib/active_record/core.rb#539
  def initialize_dup(other); end

  # source://activerecord//lib/active_record/core.rb#768
  def initialize_internals_callback; end

  # source://activerecord//lib/active_record/core.rb#782
  def inspection_filter; end

  # +Array#flatten+ will call +#to_ary+ (recursively) on each of the elements of
  # the array, and then rescues from the possible +NoMethodError+. If those elements are
  # +ActiveRecord::Base+'s, then this triggers the various +method_missing+'s that we have,
  # which significantly impacts upon performance.
  #
  # So we can avoid the +method_missing+ hit by explicitly defining +#to_ary+ as +nil+ here.
  #
  # See also https://tenderlovemaking.com/2011/06/28/til-its-ok-to-return-nil-from-to_ary.html
  #
  # source://activerecord//lib/active_record/core.rb#747
  def to_ary; end

  module GeneratedClassMethods
    def belongs_to_required_by_default; end
    def belongs_to_required_by_default=(value); end
    def belongs_to_required_by_default?; end
    def default_connection_handler; end
    def default_connection_handler=(value); end
    def default_connection_handler?; end
    def default_role; end
    def default_role=(value); end
    def default_role?; end
    def default_shard; end
    def default_shard=(value); end
    def default_shard?; end
    def destroy_association_async_job; end
    def destroy_association_async_job=(value); end
    def enumerate_columns_in_select_statements; end
    def enumerate_columns_in_select_statements=(value); end
    def enumerate_columns_in_select_statements?; end
    def has_many_inversing; end
    def has_many_inversing=(value); end
    def has_many_inversing?; end
    def logger; end
    def logger=(value); end
    def logger?; end
    def shard_selector; end
    def shard_selector=(value); end
    def shard_selector?; end
    def strict_loading_by_default; end
    def strict_loading_by_default=(value); end
    def strict_loading_by_default?; end
  end

  module GeneratedInstanceMethods
    def default_connection_handler; end
    def default_connection_handler?; end
    def default_role; end
    def default_role?; end
    def default_shard; end
    def default_shard?; end
    def destroy_association_async_job; end
    def logger; end
    def logger?; end
  end
end

module ActiveRecord::Core::ClassMethods
  # Override the default class equality method to provide support for decorated models.
  #
  # source://activerecord//lib/active_record/core.rb#415
  def ===(object); end

  # source://activerecord//lib/active_record/core.rb#340
  def action_on_strict_loading_violation; end

  # source://activerecord//lib/active_record/core.rb#348
  def action_on_strict_loading_violation=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def application_record_class; end

  # source://activerecord//lib/active_record/core.rb#348
  def application_record_class=(value); end

  # Returns an instance of <tt>Arel::Table</tt> loaded with the current table name.
  #
  # source://activerecord//lib/active_record/core.rb#420
  def arel_table; end

  # source://activerecord//lib/active_record/core.rb#432
  def cached_find_by_statement(key, &block); end

  # source://activerecord//lib/active_record/core.rb#340
  def default_timezone; end

  # source://activerecord//lib/active_record/core.rb#348
  def default_timezone=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def dump_schema_after_migration; end

  # source://activerecord//lib/active_record/core.rb#348
  def dump_schema_after_migration=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def dump_schemas; end

  # source://activerecord//lib/active_record/core.rb#348
  def dump_schemas=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def error_on_ignored_order; end

  # source://activerecord//lib/active_record/core.rb#348
  def error_on_ignored_order=(value); end

  # Returns columns which shouldn't be exposed while calling +#inspect+.
  #
  # source://activerecord//lib/active_record/core.rb#373
  def filter_attributes; end

  # Specifies columns which shouldn't be exposed while calling +#inspect+.
  #
  # source://activerecord//lib/active_record/core.rb#382
  def filter_attributes=(filter_attributes); end

  # source://activerecord//lib/active_record/core.rb#268
  def find(*ids); end

  # source://activerecord//lib/active_record/core.rb#287
  def find_by(*args); end

  # source://activerecord//lib/active_record/core.rb#329
  def find_by!(*args); end

  # source://activerecord//lib/active_record/core.rb#362
  def generated_association_methods; end

  # source://activerecord//lib/active_record/core.rb#340
  def index_nested_attribute_errors; end

  # source://activerecord//lib/active_record/core.rb#348
  def index_nested_attribute_errors=(value); end

  # source://activerecord//lib/active_record/core.rb#255
  def inherited(child_class); end

  # source://activerecord//lib/active_record/core.rb#251
  def initialize_find_by_cache; end

  # source://activerecord//lib/active_record/core.rb#358
  def initialize_generated_modules; end

  # Returns a string like 'Post(id:integer, title:string, body:text)'
  #
  # source://activerecord//lib/active_record/core.rb#399
  def inspect; end

  # source://activerecord//lib/active_record/core.rb#387
  def inspection_filter; end

  # source://activerecord//lib/active_record/core.rb#340
  def legacy_connection_handling; end

  # source://activerecord//lib/active_record/core.rb#348
  def legacy_connection_handling=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def maintain_test_schema; end

  # source://activerecord//lib/active_record/core.rb#348
  def maintain_test_schema=(value); end

  # source://activerecord//lib/active_record/core.rb#424
  def predicate_builder; end

  # source://activerecord//lib/active_record/core.rb#340
  def queues; end

  # source://activerecord//lib/active_record/core.rb#348
  def queues=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def reading_role; end

  # source://activerecord//lib/active_record/core.rb#348
  def reading_role=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def schema_format; end

  # source://activerecord//lib/active_record/core.rb#348
  def schema_format=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def suppress_multiple_database_warning; end

  # source://activerecord//lib/active_record/core.rb#348
  def suppress_multiple_database_warning=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def timestamped_migrations; end

  # source://activerecord//lib/active_record/core.rb#348
  def timestamped_migrations=(value); end

  # source://activerecord//lib/active_record/core.rb#428
  def type_caster; end

  # source://activerecord//lib/active_record/core.rb#340
  def verbose_query_logs; end

  # source://activerecord//lib/active_record/core.rb#348
  def verbose_query_logs=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def warn_on_records_fetched_greater_than; end

  # source://activerecord//lib/active_record/core.rb#348
  def warn_on_records_fetched_greater_than=(value); end

  # source://activerecord//lib/active_record/core.rb#340
  def writing_role; end

  # source://activerecord//lib/active_record/core.rb#348
  def writing_role=(value); end

  private

  # source://activerecord//lib/active_record/core.rb#438
  def relation; end

  # source://activerecord//lib/active_record/core.rb#448
  def table_metadata; end
end

class ActiveRecord::Core::InspectionMask
  # source://activerecord//lib/active_record/core.rb#776
  def pretty_print(pp); end
end

# = Active Record Counter Cache
module ActiveRecord::CounterCache
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::CounterCache::ClassMethods

  private

  # source://activerecord//lib/active_record/counter_cache.rb#165
  def _create_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/counter_cache.rb#175
  def destroy_row; end

  # source://activerecord//lib/active_record/counter_cache.rb#190
  def each_counter_cached_associations; end
end

module ActiveRecord::CounterCache::ClassMethods
  # Decrement a numeric field by one, via a direct SQL update.
  #
  # This works the same as #increment_counter but reduces the column value by
  # 1 instead of increasing it.
  #
  # ==== Parameters
  #
  # * +counter_name+ - The name of the field that should be decremented.
  # * +id+ - The id of the object that should be decremented or an array of ids.
  # * <tt>:touch</tt> - Touch timestamp columns when updating.
  #   Pass +true+ to touch +updated_at+ and/or +updated_on+. Pass a symbol to
  #   touch that column or an array of symbols to touch just those ones.
  #
  # ==== Examples
  #
  #   # Decrement the posts_count column for the record with an id of 5
  #   DiscussionBoard.decrement_counter(:posts_count, 5)
  #
  #   # Decrement the posts_count column for the record with an id of 5
  #   # and update the updated_at value.
  #   DiscussionBoard.decrement_counter(:posts_count, 5, touch: true)
  #
  # source://activerecord//lib/active_record/counter_cache.rb#159
  def decrement_counter(counter_name, id, touch: T.unsafe(nil)); end

  # Increment a numeric field by one, via a direct SQL update.
  #
  # This method is used primarily for maintaining counter_cache columns that are
  # used to store aggregate values. For example, a +DiscussionBoard+ may cache
  # posts_count and comments_count to avoid running an SQL query to calculate the
  # number of posts and comments there are, each time it is displayed.
  #
  # ==== Parameters
  #
  # * +counter_name+ - The name of the field that should be incremented.
  # * +id+ - The id of the object that should be incremented or an array of ids.
  # * <tt>:touch</tt> - Touch timestamp columns when updating.
  #   Pass +true+ to touch +updated_at+ and/or +updated_on+. Pass a symbol to
  #   touch that column or an array of symbols to touch just those ones.
  #
  # ==== Examples
  #
  #   # Increment the posts_count column for the record with an id of 5
  #   DiscussionBoard.increment_counter(:posts_count, 5)
  #
  #   # Increment the posts_count column for the record with an id of 5
  #   # and update the updated_at value.
  #   DiscussionBoard.increment_counter(:posts_count, 5, touch: true)
  #
  # source://activerecord//lib/active_record/counter_cache.rb#134
  def increment_counter(counter_name, id, touch: T.unsafe(nil)); end

  # Resets one or more counter caches to their correct value using an SQL
  # count query. This is useful when adding new counter caches, or if the
  # counter has been corrupted or modified directly by SQL.
  #
  # ==== Parameters
  #
  # * +id+ - The id of the object you wish to reset a counter on.
  # * +counters+ - One or more association counters to reset. Association name or counter name can be given.
  # * <tt>:touch</tt> - Touch timestamp columns when updating.
  #   Pass +true+ to touch +updated_at+ and/or +updated_on+. Pass a symbol to
  #   touch that column or an array of symbols to touch just those ones.
  #
  # ==== Examples
  #
  #   # For the Post with id #1, reset the comments_count
  #   Post.reset_counters(1, :comments)
  #
  #   # Like above, but also touch the +updated_at+ and/or +updated_on+
  #   # attributes.
  #   Post.reset_counters(1, :comments, touch: true)
  #
  # source://activerecord//lib/active_record/counter_cache.rb#29
  def reset_counters(id, *counters, touch: T.unsafe(nil)); end

  # A generic "counter updater" implementation, intended primarily to be
  # used by #increment_counter and #decrement_counter, but which may also
  # be useful on its own. It simply does a direct SQL update for the record
  # with the given ID, altering the given hash of counters by the amount
  # given by the corresponding value:
  #
  # ==== Parameters
  #
  # * +id+ - The id of the object you wish to update a counter on or an array of ids.
  # * +counters+ - A Hash containing the names of the fields
  #   to update as keys and the amount to update the field by as values.
  # * <tt>:touch</tt> option - Touch timestamp columns when updating.
  #   If attribute names are passed, they are updated along with updated_at/on
  #   attributes.
  #
  # ==== Examples
  #
  #   # For the Post with id of 5, decrement the comment_count by 1, and
  #   # increment the action_count by 1
  #   Post.update_counters 5, comment_count: -1, action_count: 1
  #   # Executes the following SQL:
  #   # UPDATE posts
  #   #    SET comment_count = COALESCE(comment_count, 0) - 1,
  #   #        action_count = COALESCE(action_count, 0) + 1
  #   #  WHERE id = 5
  #
  #   # For the Posts with id of 10 and 15, increment the comment_count by 1
  #   Post.update_counters [10, 15], comment_count: 1
  #   # Executes the following SQL:
  #   # UPDATE posts
  #   #    SET comment_count = COALESCE(comment_count, 0) + 1
  #   #  WHERE id IN (10, 15)
  #
  #   # For the Posts with id of 10 and 15, increment the comment_count by 1
  #   # and update the updated_at value for each counter.
  #   Post.update_counters [10, 15], comment_count: 1, touch: true
  #   # Executes the following SQL:
  #   # UPDATE posts
  #   #    SET comment_count = COALESCE(comment_count, 0) + 1,
  #   #    `updated_at` = '2016-10-13T09:59:23-05:00'
  #   #  WHERE id IN (10, 15)
  #
  # source://activerecord//lib/active_record/counter_cache.rb#107
  def update_counters(id, counters); end
end

# Raised when attribute has a name reserved by Active Record (when attribute
# has name of one of Active Record instance methods).
class ActiveRecord::DangerousAttributeError < ::ActiveRecord::ActiveRecordError; end

# Raised when creating a database if it exists.
class ActiveRecord::DatabaseAlreadyExists < ::ActiveRecord::StatementInvalid; end

# ActiveRecord::DatabaseConfigurations returns an array of DatabaseConfig
# objects (either a HashConfig or UrlConfig) that are constructed from the
# application's database configuration hash or URL string.
class ActiveRecord::DatabaseConfigurations
  # @return [DatabaseConfigurations] a new instance of DatabaseConfigurations
  #
  # source://activerecord//lib/active_record/database_configurations.rb#19
  def initialize(configurations = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/database_configurations.rb#17
  def any?(*_arg0, **_arg1, &_arg2); end

  # Checks if the application's configurations are empty.
  #
  # Aliased to blank?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations.rb#98
  def blank?; end

  # Collects the configs for the environment and optionally the specification
  # name passed in. To include replica configurations pass <tt>include_hidden: true</tt>.
  #
  # If a name is provided a single DatabaseConfig object will be
  # returned, otherwise an array of DatabaseConfig objects will be
  # returned that corresponds with the environment and type requested.
  #
  # ==== Options
  #
  # * <tt>env_name:</tt> The environment name. Defaults to +nil+ which will collect
  #   configs for all environments.
  # * <tt>name:</tt> The db config name (i.e. primary, animals, etc.). Defaults
  #   to +nil+. If no +env_name+ is specified the config for the default env and the
  #   passed +name+ will be returned.
  # * <tt>include_replicas:</tt> Deprecated. Determines whether to include replicas in
  #   the returned list. Most of the time we're only iterating over the write
  #   connection (i.e. migrations don't need to run for the write and read connection).
  #   Defaults to +false+.
  # * <tt>include_hidden:</tt> Determines whether to include replicas and configurations
  #   hidden by +database_tasks: false+ in the returned list. Most of the time we're only
  #   iterating over the primary connections (i.e. migrations don't need to run for the
  #   write and read connection). Defaults to +false+.
  #
  # source://activerecord//lib/active_record/database_configurations.rb#45
  def configs_for(env_name: T.unsafe(nil), name: T.unsafe(nil), include_replicas: T.unsafe(nil), include_hidden: T.unsafe(nil)); end

  # Returns the value of attribute configurations.
  #
  # source://activerecord//lib/active_record/database_configurations.rb#16
  def configurations; end

  # Checks if the application's configurations are empty.
  #
  # Aliased to blank?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations.rb#98
  def empty?; end

  # Returns a single DatabaseConfig object based on the requested environment.
  #
  # If the application has multiple databases +find_db_config+ will return
  # the first DatabaseConfig for the environment.
  #
  # source://activerecord//lib/active_record/database_configurations.rb#73
  def find_db_config(env); end

  # A primary configuration is one that is named primary or if there is
  # no primary, the first configuration for an environment will be treated
  # as primary. This is used as the "default" configuration and is used
  # when the application needs to treat one configuration differently. For
  # example, when Rails dumps the schema, the primary configuration's schema
  # file will be named `schema.rb` instead of `primary_schema.rb`.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations.rb#88
  def primary?(name); end

  # Returns fully resolved connection, accepts hash, string or symbol.
  # Always returns a DatabaseConfiguration::DatabaseConfig
  #
  # == Examples
  #
  # Symbol representing current environment.
  #
  #   DatabaseConfigurations.new("production" => {}).resolve(:production)
  #   # => DatabaseConfigurations::HashConfig.new(env_name: "production", config: {})
  #
  # One layer deep hash of connection values.
  #
  #   DatabaseConfigurations.new({}).resolve("adapter" => "sqlite3")
  #   # => DatabaseConfigurations::HashConfig.new(config: {"adapter" => "sqlite3"})
  #
  # Connection URL.
  #
  #   DatabaseConfigurations.new({}).resolve("postgresql://localhost/foo")
  #   # => DatabaseConfigurations::UrlConfig.new(config: {"adapter" => "postgresql", "host" => "localhost", "database" => "foo"})
  #
  # source://activerecord//lib/active_record/database_configurations.rb#122
  def resolve(config); end

  private

  # source://activerecord//lib/active_record/database_configurations.rb#148
  def build_configs(configs); end

  # source://activerecord//lib/active_record/database_configurations.rb#187
  def build_configuration_sentence; end

  # source://activerecord//lib/active_record/database_configurations.rb#221
  def build_db_config_from_hash(env_name, name, config); end

  # source://activerecord//lib/active_record/database_configurations.rb#200
  def build_db_config_from_raw_config(env_name, name, config); end

  # source://activerecord//lib/active_record/database_configurations.rb#211
  def build_db_config_from_string(env_name, name, config); end

  # source://activerecord//lib/active_record/database_configurations.rb#136
  def default_env; end

  # source://activerecord//lib/active_record/database_configurations.rb#140
  def env_with_configs(env = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/database_configurations.rb#242
  def environment_url_config(env, name, config); end

  # source://activerecord//lib/active_record/database_configurations.rb#249
  def environment_value_for(name); end

  # source://activerecord//lib/active_record/database_configurations.rb#233
  def merge_db_environment_variables(current_env, configs); end

  # source://activerecord//lib/active_record/database_configurations.rb#173
  def resolve_symbol_connection(name); end

  # source://activerecord//lib/active_record/database_configurations.rb#167
  def walk_configs(env_name, config); end
end

# Expands a connection string into a hash.
class ActiveRecord::DatabaseConfigurations::ConnectionUrlResolver
  # == Example
  #
  #   url = "postgresql://foo:bar@localhost:9000/foo_test?pool=5&timeout=3000"
  #   ConnectionUrlResolver.new(url).to_hash
  #   # => {
  #     adapter:  "postgresql",
  #     host:     "localhost",
  #     port:     9000,
  #     database: "foo_test",
  #     username: "foo",
  #     password: "bar",
  #     pool:     "5",
  #     timeout:  "3000"
  #   }
  #
  # @return [ConnectionUrlResolver] a new instance of ConnectionUrlResolver
  #
  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#25
  def initialize(url); end

  # Converts the given URL to a full connection hash.
  #
  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#39
  def to_hash; end

  private

  # Returns name of the database.
  #
  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#84
  def database_from_path; end

  # Converts the query parameters of the URI into a hash.
  #
  #   "localhost?pool=5&reaping_frequency=2"
  #   # => { pool: "5", reaping_frequency: "2" }
  #
  # returns empty hash if no query present.
  #
  #   "localhost"
  #   # => {}
  #
  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#61
  def query_hash; end

  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#65
  def raw_config; end

  # Returns the value of attribute uri.
  #
  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#46
  def uri; end

  # source://activerecord//lib/active_record/database_configurations/connection_url_resolver.rb#48
  def uri_parser; end
end

# ActiveRecord::Base.configurations will return either a HashConfig or
# UrlConfig respectively. It will never return a DatabaseConfig object,
# as this is the parent class for the types of database configuration objects.
class ActiveRecord::DatabaseConfigurations::DatabaseConfig
  # @return [DatabaseConfig] a new instance of DatabaseConfig
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#13
  def initialize(env_name, name); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#30
  def _database=(database); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#34
  def adapter; end

  # source://activerecord//lib/active_record/database_configurations/database_config.rb#18
  def adapter_method; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#54
  def checkout_timeout; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#26
  def database; end

  # source://activerecord//lib/active_record/database_configurations/database_config.rb#9
  def env_name; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#74
  def for_current_env?; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#22
  def host; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#62
  def idle_timeout; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#50
  def max_queue; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#46
  def max_threads; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#70
  def migrations_paths; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#42
  def min_threads; end

  # source://activerecord//lib/active_record/database_configurations/database_config.rb#9
  def name; end

  # Returns the value of attribute owner_name.
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#11
  def owner_name; end

  # Sets the attribute owner_name
  #
  # @param value the value to set the attribute owner_name to.
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#11
  def owner_name=(_arg0); end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#38
  def pool; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#58
  def reaping_frequency; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#66
  def replica?; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/database_configurations/database_config.rb#78
  def schema_cache_path; end
end

# A HashConfig object is created for each database configuration entry that
# is created from a hash.
#
# A hash config:
#
#   { "development" => { "database" => "db_name" } }
#
# Becomes:
#
#   #<ActiveRecord::DatabaseConfigurations::HashConfig:0x00007fd1acbded10
#     @env_name="development", @name="primary", @config={database: "db_name"}>
#
# ==== Options
#
# * <tt>:env_name</tt> - The Rails environment, i.e. "development".
# * <tt>:name</tt> - The db config name. In a standard two-tier
#   database configuration this will default to "primary". In a multiple
#   database three-tier database configuration this corresponds to the name
#   used in the second tier, for example "primary_readonly".
# * <tt>:config</tt> - The config hash. This is the hash that contains the
#   database adapter, name, and other important information for database
#   connections.
class ActiveRecord::DatabaseConfigurations::HashConfig < ::ActiveRecord::DatabaseConfigurations::DatabaseConfig
  # @return [HashConfig] a new instance of HashConfig
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#30
  def initialize(env_name, name, configuration_hash); end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#61
  def _database=(database); end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#96
  def adapter; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#81
  def checkout_timeout; end

  # Returns the value of attribute configuration_hash.
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#28
  def configuration_hash; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#57
  def database; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#139
  def database_tasks?; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#107
  def default_schema_cache_path; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#49
  def host; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#91
  def idle_timeout; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#111
  def lazy_schema_cache_path; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#77
  def max_queue; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#73
  def max_threads; end

  # The migrations paths for a database configuration. If the
  # +migrations_paths+ key is present in the config, +migrations_paths+
  # will return its value.
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#45
  def migrations_paths; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#69
  def min_threads; end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#65
  def pool; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#115
  def primary?; end

  # +reaping_frequency+ is configurable mostly for historical reasons, but it could
  # also be useful if someone wants a very low +idle_timeout+.
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#87
  def reaping_frequency; end

  # Determines whether a database configuration is for a replica / readonly
  # connection. If the +replica+ key is present in the config, +replica?+ will
  # return +true+.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#38
  def replica?; end

  # The path to the schema cache dump file for a database.
  # If omitted, the filename will be read from ENV or a
  # default will be derived.
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#103
  def schema_cache_path; end

  # Determines whether to dump the schema/structure files and the
  # filename that should be used.
  #
  # If +configuration_hash[:schema_dump]+ is set to +false+ or +nil+
  # the schema will not be dumped.
  #
  # If the config option is set that will be used. Otherwise Rails
  # will generate the filename from the database config name.
  #
  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#127
  def schema_dump(format = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#53
  def socket; end

  private

  # source://activerecord//lib/active_record/database_configurations/hash_config.rb#144
  def schema_file_type(format); end
end

class ActiveRecord::DatabaseConfigurations::InvalidConfigurationError < ::StandardError; end

# A UrlConfig object is created for each database configuration
# entry that is created from a URL. This can either be a URL string
# or a hash with a URL in place of the config hash.
#
# A URL config:
#
#   postgres://localhost/foo
#
# Becomes:
#
#   #<ActiveRecord::DatabaseConfigurations::UrlConfig:0x00007fdc3238f340
#     @env_name="default_env", @name="primary",
#     @config={adapter: "postgresql", database: "foo", host: "localhost"},
#     @url="postgres://localhost/foo">
#
# ==== Options
#
# * <tt>:env_name</tt> - The Rails environment, i.e. "development".
# * <tt>:name</tt> - The db config name. In a standard two-tier
#   database configuration this will default to "primary". In a multiple
#   database three-tier database configuration this corresponds to the name
#   used in the second tier, for example "primary_readonly".
# * <tt>:url</tt> - The database URL.
# * <tt>:config</tt> - The config hash. This is the hash that contains the
#   database adapter, name, and other important information for database
#   connections.
class ActiveRecord::DatabaseConfigurations::UrlConfig < ::ActiveRecord::DatabaseConfigurations::HashConfig
  # @return [UrlConfig] a new instance of UrlConfig
  #
  # source://activerecord//lib/active_record/database_configurations/url_config.rb#34
  def initialize(env_name, name, url, configuration_hash = T.unsafe(nil)); end

  # Returns the value of attribute url.
  #
  # source://activerecord//lib/active_record/database_configurations/url_config.rb#32
  def url; end

  private

  # Return a Hash that can be merged into the main config that represents
  # the passed in url
  #
  # source://activerecord//lib/active_record/database_configurations/url_config.rb#44
  def build_url_hash; end
end

# Raised when connection to the database could not been established because it was not
# able to connect to the host or when the authorization failed.
class ActiveRecord::DatabaseConnectionError < ::ActiveRecord::ConnectionNotEstablished
  # @return [DatabaseConnectionError] a new instance of DatabaseConnectionError
  #
  # source://activerecord//lib/active_record/errors.rb#69
  def initialize(message = T.unsafe(nil)); end

  class << self
    # source://activerecord//lib/active_record/errors.rb#74
    def hostname_error(hostname); end

    # source://activerecord//lib/active_record/errors.rb#81
    def username_error(username); end
  end
end

# Deadlocked will be raised when a transaction is rolled
# back by the database when a deadlock is encountered.
class ActiveRecord::Deadlocked < ::ActiveRecord::TransactionRollbackError; end

# == Delegated types
#
# Class hierarchies can map to relational database tables in many ways. Active Record, for example, offers
# purely abstract classes, where the superclass doesn't persist any attributes, and single-table inheritance,
# where all attributes from all levels of the hierarchy are represented in a single table. Both have their
# places, but neither are without their drawbacks.
#
# The problem with purely abstract classes is that all concrete subclasses must persist all the shared
# attributes themselves in their own tables (also known as class-table inheritance). This makes it hard to
# do queries across the hierarchy. For example, imagine you have the following hierarchy:
#
#   Entry < ApplicationRecord
#   Message < Entry
#   Comment < Entry
#
# How do you show a feed that has both +Message+ and +Comment+ records, which can be easily paginated?
# Well, you can't! Messages are backed by a messages table and comments by a comments table. You can't
# pull from both tables at once and use a consistent OFFSET/LIMIT scheme.
#
# You can get around the pagination problem by using single-table inheritance, but now you're forced into
# a single mega table with all the attributes from all subclasses. No matter how divergent. If a Message
# has a subject, but the comment does not, well, now the comment does anyway! So STI works best when there's
# little divergence between the subclasses and their attributes.
#
# But there's a third way: Delegated types. With this approach, the "superclass" is a concrete class
# that is represented by its own table, where all the superclass attributes that are shared amongst all the
# "subclasses" are stored. And then each of the subclasses have their own individual tables for additional
# attributes that are particular to their implementation. This is similar to what's called multi-table
# inheritance in Django, but instead of actual inheritance, this approach uses delegation to form the
# hierarchy and share responsibilities.
#
# Let's look at that entry/message/comment example using delegated types:
#
#   # Schema: entries[ id, account_id, creator_id, created_at, updated_at, entryable_type, entryable_id ]
#   class Entry < ApplicationRecord
#     belongs_to :account
#     belongs_to :creator
#     delegated_type :entryable, types: %w[ Message Comment ]
#   end
#
#   module Entryable
#     extend ActiveSupport::Concern
#
#     included do
#       has_one :entry, as: :entryable, touch: true
#     end
#   end
#
#   # Schema: messages[ id, subject, body ]
#   class Message < ApplicationRecord
#     include Entryable
#   end
#
#   # Schema: comments[ id, content ]
#   class Comment < ApplicationRecord
#     include Entryable
#   end
#
# As you can see, neither +Message+ nor +Comment+ are meant to stand alone. Crucial metadata for both classes
# resides in the +Entry+ "superclass". But the +Entry+ absolutely can stand alone in terms of querying capacity
# in particular. You can now easily do things like:
#
#   Account.find(1).entries.order(created_at: :desc).limit(50)
#
# Which is exactly what you want when displaying both comments and messages together. The entry itself can
# be rendered as its delegated type easily, like so:
#
#   # entries/_entry.html.erb
#   <%= render "entries/entryables/#{entry.entryable_name}", entry: entry %>
#
#   # entries/entryables/_message.html.erb
#   <div class="message">
#     <div class="subject"><%= entry.message.subject %></div>
#     <p><%= entry.message.body %></p>
#     <i>Posted on <%= entry.created_at %> by <%= entry.creator.name %></i>
#   </div>
#
#   # entries/entryables/_comment.html.erb
#   <div class="comment">
#     <%= entry.creator.name %> said: <%= entry.comment.content %>
#   </div>
#
# == Sharing behavior with concerns and controllers
#
# The entry "superclass" also serves as a perfect place to put all that shared logic that applies to both
# messages and comments, and which acts primarily on the shared attributes. Imagine:
#
#   class Entry < ApplicationRecord
#     include Eventable, Forwardable, Redeliverable
#   end
#
# Which allows you to have controllers for things like +ForwardsController+ and +RedeliverableController+
# that both act on entries, and thus provide the shared functionality to both messages and comments.
#
# == Creating new records
#
# You create a new record that uses delegated typing by creating the delegator and delegatee at the same time,
# like so:
#
#   Entry.create! entryable: Comment.new(content: "Hello!"), creator: Current.user
#
# If you need more complicated composition, or you need to perform dependent validation, you should build a factory
# method or class to take care of the complicated needs. This could be as simple as:
#
#   class Entry < ApplicationRecord
#     def self.create_with_comment(content, creator: Current.user)
#       create! entryable: Comment.new(content: content), creator: creator
#     end
#   end
#
# == Adding further delegation
#
# The delegated type shouldn't just answer the question of what the underlying class is called. In fact, that's
# an anti-pattern most of the time. The reason you're building this hierarchy is to take advantage of polymorphism.
# So here's a simple example of that:
#
#   class Entry < ApplicationRecord
#     delegated_type :entryable, types: %w[ Message Comment ]
#     delegate :title, to: :entryable
#   end
#
#   class Message < ApplicationRecord
#     def title
#       subject
#     end
#   end
#
#   class Comment < ApplicationRecord
#     def title
#       content.truncate(20)
#     end
#   end
#
# Now you can list a bunch of entries, call <tt>Entry#title</tt>, and polymorphism will provide you with the answer.
#
# == Nested Attributes
#
# Enabling nested attributes on a delegated_type association allows you to
# create the entry and message in one go:
#
#   class Entry < ApplicationRecord
#     delegated_type :entryable, types: %w[ Message Comment ]
#     accepts_nested_attributes_for :entryable
#   end
#
#   params = { entry: { entryable_type: 'Message', entryable_attributes: { subject: 'Smiling' } } }
#   entry = Entry.create(params[:entry])
#   entry.entryable.id # => 2
#   entry.entryable.subject # => 'Smiling'
module ActiveRecord::DelegatedType
  # Defines this as a class that'll delegate its type for the passed +role+ to the class references in +types+.
  # That'll create a polymorphic +belongs_to+ relationship to that +role+, and it'll add all the delegated
  # type convenience methods:
  #
  #   class Entry < ApplicationRecord
  #     delegated_type :entryable, types: %w[ Message Comment ], dependent: :destroy
  #   end
  #
  #   Entry#entryable_class # => +Message+ or +Comment+
  #   Entry#entryable_name  # => "message" or "comment"
  #   Entry.messages        # => Entry.where(entryable_type: "Message")
  #   Entry#message?        # => true when entryable_type == "Message"
  #   Entry#message         # => returns the message record, when entryable_type == "Message", otherwise nil
  #   Entry#message_id      # => returns entryable_id, when entryable_type == "Message", otherwise nil
  #   Entry.comments        # => Entry.where(entryable_type: "Comment")
  #   Entry#comment?        # => true when entryable_type == "Comment"
  #   Entry#comment         # => returns the comment record, when entryable_type == "Comment", otherwise nil
  #   Entry#comment_id      # => returns entryable_id, when entryable_type == "Comment", otherwise nil
  #
  # You can also declare namespaced types:
  #
  #   class Entry < ApplicationRecord
  #     delegated_type :entryable, types: %w[ Message Comment Access::NoticeMessage ], dependent: :destroy
  #   end
  #
  #   Entry.access_notice_messages
  #   entry.access_notice_message
  #   entry.access_notice_message?
  #
  # === Options
  #
  # The +options+ are passed directly to the +belongs_to+ call, so this is where you declare +dependent+ etc.
  # The following options can be included to specialize the behavior of the delegated type convenience methods.
  #
  # [:foreign_key]
  #   Specify the foreign key used for the convenience methods. By default this is guessed to be the passed
  #   +role+ with an "_id" suffix. So a class that defines a
  #   <tt>delegated_type :entryable, types: %w[ Message Comment ]</tt> association will use "entryable_id" as
  #   the default <tt>:foreign_key</tt>.
  # [:primary_key]
  #   Specify the method that returns the primary key of associated object used for the convenience methods.
  #   By default this is +id+.
  #
  # Option examples:
  #   class Entry < ApplicationRecord
  #     delegated_type :entryable, types: %w[ Message Comment ], primary_key: :uuid, foreign_key: :entryable_uuid
  #   end
  #
  #   Entry#message_uuid      # => returns entryable_uuid, when entryable_type == "Message", otherwise nil
  #   Entry#comment_uuid      # => returns entryable_uuid, when entryable_type == "Comment", otherwise nil
  #
  # source://activerecord//lib/active_record/delegated_type.rb#206
  def delegated_type(role, types:, **options); end

  private

  # source://activerecord//lib/active_record/delegated_type.rb#212
  def define_delegated_type_methods(role, types:, options:); end
end

module ActiveRecord::Delegation
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Delegation::ClassMethods

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def &(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def +(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def -(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def [](*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def as_json(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def compact(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#93
  def connection(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def each(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def encode_with(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def in_groups(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def in_groups_of(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def index(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def join(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def length(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#93
  def primary_key(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def reverse(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def rindex(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def rotate(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def sample(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def shuffle(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def slice(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def split(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def to_formatted_s(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def to_fs(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def to_sentence(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def to_xml(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/relation/delegation.rb#88
  def |(*_arg0, **_arg1, &_arg2); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/delegation.rb#128
  def respond_to_missing?(method, _); end
end

module ActiveRecord::Delegation::ClassMethods
  # source://activerecord//lib/active_record/relation/delegation.rb#117
  def create(klass, *args, **kwargs); end

  private

  # source://activerecord//lib/active_record/relation/delegation.rb#122
  def relation_class_for(klass); end
end

module ActiveRecord::Delegation::ClassSpecificRelation
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Delegation::ClassSpecificRelation::ClassMethods

  private

  # source://activerecord//lib/active_record/relation/delegation.rb#105
  def method_missing(method, *args, **_arg2, &block); end
end

module ActiveRecord::Delegation::ClassSpecificRelation::ClassMethods
  # source://activerecord//lib/active_record/relation/delegation.rb#99
  def name; end
end

module ActiveRecord::Delegation::DelegateCache
  # source://activerecord//lib/active_record/relation/delegation.rb#38
  def generate_relation_method(method); end

  # source://activerecord//lib/active_record/relation/delegation.rb#33
  def inherited(child_class); end

  # source://activerecord//lib/active_record/relation/delegation.rb#13
  def initialize_relation_delegate_cache; end

  # source://activerecord//lib/active_record/relation/delegation.rb#9
  def relation_delegate_class(klass); end

  protected

  # source://activerecord//lib/active_record/relation/delegation.rb#43
  def include_relation_methods(delegate); end

  private

  # source://activerecord//lib/active_record/relation/delegation.rb#49
  def generated_relation_methods; end
end

class ActiveRecord::Delegation::GeneratedRelationMethods < ::Module
  include ::Mutex_m

  # source://activerecord//lib/active_record/relation/delegation.rb#60
  def generate_method(method); end

  # source://mutex_m/0.1.1/mutex_m.rb#93
  def lock; end

  # source://mutex_m/0.1.1/mutex_m.rb#83
  def locked?; end

  # source://mutex_m/0.1.1/mutex_m.rb#78
  def synchronize(&block); end

  # source://mutex_m/0.1.1/mutex_m.rb#88
  def try_lock; end

  # source://mutex_m/0.1.1/mutex_m.rb#98
  def unlock; end
end

# This error is raised when trying to destroy a parent instance in N:1 or 1:1 associations
# (has_many, has_one) when there is at least 1 child associated instance.
# ex: if @project.tasks.size > 0, DeleteRestrictionError will be raised when trying to destroy @project
class ActiveRecord::DeleteRestrictionError < ::ActiveRecord::ActiveRecordError
  # @return [DeleteRestrictionError] a new instance of DeleteRestrictionError
  #
  # source://activerecord//lib/active_record/associations.rb#241
  def initialize(name = T.unsafe(nil)); end
end

class ActiveRecord::DestroyAssociationAsyncError < ::StandardError; end

# Job to destroy the records associated with a destroyed record in background.
class ActiveRecord::DestroyAssociationAsyncJob < ::ActiveJob::Base
  # source://activerecord//lib/active_record/destroy_association_async_job.rb#13
  def perform(owner_model_name: T.unsafe(nil), owner_id: T.unsafe(nil), association_class: T.unsafe(nil), association_ids: T.unsafe(nil), association_primary_key_column: T.unsafe(nil), ensuring_owner_was_method: T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/destroy_association_async_job.rb#32
  def owner_destroyed?(owner, ensuring_owner_was_method); end

  class << self
    # source://activejob/7.0.4/lib/active_job/queue_name.rb#56
    def queue_name; end

    # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
    def rescue_handlers; end
  end
end

class ActiveRecord::DisableJoinsAssociationRelation < ::ActiveRecord::Relation
  # @return [DisableJoinsAssociationRelation] a new instance of DisableJoinsAssociationRelation
  #
  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#7
  def initialize(klass, key, ids); end

  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#17
  def first(limit = T.unsafe(nil)); end

  # Returns the value of attribute ids.
  #
  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#5
  def ids; end

  # Returns the value of attribute key.
  #
  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#5
  def key; end

  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#13
  def limit(value); end

  # source://activerecord//lib/active_record/disable_joins_association_relation.rb#25
  def load; end
end

class ActiveRecord::DuplicateMigrationNameError < ::ActiveRecord::MigrationError
  # @return [DuplicateMigrationNameError] a new instance of DuplicateMigrationNameError
  #
  # source://activerecord//lib/active_record/migration.rb#104
  def initialize(name = T.unsafe(nil)); end
end

class ActiveRecord::DuplicateMigrationVersionError < ::ActiveRecord::MigrationError
  # @return [DuplicateMigrationVersionError] a new instance of DuplicateMigrationVersionError
  #
  # source://activerecord//lib/active_record/migration.rb#94
  def initialize(version = T.unsafe(nil)); end
end

module ActiveRecord::DynamicMatchers
  private

  # source://activerecord//lib/active_record/dynamic_matchers.rb#15
  def method_missing(name, *arguments, &block); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#6
  def respond_to_missing?(name, _); end
end

class ActiveRecord::DynamicMatchers::FindBy < ::ActiveRecord::DynamicMatchers::Method
  # source://activerecord//lib/active_record/dynamic_matchers.rb#100
  def finder; end

  class << self
    # source://activerecord//lib/active_record/dynamic_matchers.rb#96
    def prefix; end
  end
end

class ActiveRecord::DynamicMatchers::FindByBang < ::ActiveRecord::DynamicMatchers::Method
  # source://activerecord//lib/active_record/dynamic_matchers.rb#116
  def finder; end

  class << self
    # source://activerecord//lib/active_record/dynamic_matchers.rb#108
    def prefix; end

    # source://activerecord//lib/active_record/dynamic_matchers.rb#112
    def suffix; end
  end
end

class ActiveRecord::DynamicMatchers::Method
  # @return [Method] a new instance of Method
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#52
  def initialize(model, method_name); end

  # Returns the value of attribute attribute_names.
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#50
  def attribute_names; end

  # source://activerecord//lib/active_record/dynamic_matchers.rb#63
  def define; end

  # Returns the value of attribute model.
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#50
  def model; end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#50
  def name; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#59
  def valid?; end

  private

  # Given that the parameters starts with `_`, the finder needs to use the
  # same parameter name.
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#84
  def attributes_hash; end

  # source://activerecord//lib/active_record/dynamic_matchers.rb#72
  def body; end

  # @raise [NotImplementedError]
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#88
  def finder; end

  # The parameters in the signature may have reserved Ruby words, in order
  # to prevent errors, we start each param name with `_`.
  #
  # source://activerecord//lib/active_record/dynamic_matchers.rb#78
  def signature; end

  class << self
    # source://activerecord//lib/active_record/dynamic_matchers.rb#32
    def match(model, name); end

    # Returns the value of attribute matchers.
    #
    # source://activerecord//lib/active_record/dynamic_matchers.rb#30
    def matchers; end

    # source://activerecord//lib/active_record/dynamic_matchers.rb#37
    def pattern; end

    # @raise [NotImplementedError]
    #
    # source://activerecord//lib/active_record/dynamic_matchers.rb#41
    def prefix; end

    # source://activerecord//lib/active_record/dynamic_matchers.rb#45
    def suffix; end
  end
end

# This error is raised when trying to eager load a polymorphic association using a JOIN.
# Eager loading polymorphic associations is only possible with
# {ActiveRecord::Relation#preload}[rdoc-ref:QueryMethods#preload].
class ActiveRecord::EagerLoadPolymorphicError < ::ActiveRecord::ActiveRecordError
  # @return [EagerLoadPolymorphicError] a new instance of EagerLoadPolymorphicError
  #
  # source://activerecord//lib/active_record/associations.rb#228
  def initialize(reflection = T.unsafe(nil)); end
end

module ActiveRecord::Encryption
  include ::ActiveRecord::Encryption::Configurable
  include ::ActiveRecord::Encryption::Contexts
  extend ::ActiveSupport::Autoload
  extend ::ActiveRecord::Encryption::Configurable::ClassMethods
  extend ::ActiveRecord::Encryption::Contexts::ClassMethods

  # source://activerecord//lib/active_record/encryption/configurable.rb#10
  def config; end

  # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#56
  def custom_contexts; end

  # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#100
  def custom_contexts=(obj); end

  # source://activerecord//lib/active_record/encryption/contexts.rb#17
  def default_context; end

  # source://activerecord//lib/active_record/encryption/configurable.rb#11
  def encrypted_attribute_declaration_listeners; end

  # source://activerecord//lib/active_record/encryption/configurable.rb#11
  def encrypted_attribute_declaration_listeners=(val); end

  class << self
    # source://activerecord//lib/active_record/encryption/configurable.rb#10
    def config; end

    # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#48
    def custom_contexts; end

    # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#92
    def custom_contexts=(obj); end

    # source://activerecord//lib/active_record/encryption/contexts.rb#17
    def default_context; end

    # source://activerecord//lib/active_record/encryption.rb#49
    def eager_load!; end

    # source://activerecord//lib/active_record/encryption/configurable.rb#11
    def encrypted_attribute_declaration_listeners; end

    # source://activerecord//lib/active_record/encryption/configurable.rb#11
    def encrypted_attribute_declaration_listeners=(val); end
  end
end

# The algorithm used for encrypting and decrypting +Message+ objects.
#
# It uses AES-256-GCM. It will generate a random IV for non deterministic encryption (default)
# or derive an initialization vector from the encrypted content for deterministic encryption.
#
# See +Cipher::Aes256Gcm+.
class ActiveRecord::Encryption::Cipher
  extend ::ActiveSupport::Autoload

  # Decrypt the provided +Message+.
  #
  # When +key+ is an Array, it will try all the keys raising a
  # +ActiveRecord::Encryption::Errors::Decryption+ if none works.
  #
  # source://activerecord//lib/active_record/encryption/cipher.rb#25
  def decrypt(encrypted_message, key:); end

  # Encrypts the provided text and return an encrypted +Message+.
  #
  # source://activerecord//lib/active_record/encryption/cipher.rb#15
  def encrypt(clean_text, key:, deterministic: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/cipher.rb#35
  def iv_length; end

  # source://activerecord//lib/active_record/encryption/cipher.rb#31
  def key_length; end

  private

  # source://activerecord//lib/active_record/encryption/cipher.rb#48
  def cipher_for(secret, deterministic: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/cipher.rb#40
  def try_to_decrypt_with_each(encrypted_text, keys:); end
end

# A 256-GCM cipher.
#
# By default it will use random initialization vectors. For deterministic encryption, it will use a SHA-256 hash of
# the text to encrypt and the secret.
#
# See +Encryptor+
class ActiveRecord::Encryption::Cipher::Aes256Gcm
  # When iv not provided, it will generate a random iv on each encryption operation (default and
  # recommended operation)
  #
  # @return [Aes256Gcm] a new instance of Aes256Gcm
  #
  # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#30
  def initialize(secret, deterministic: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#56
  def decrypt(encrypted_message); end

  # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#35
  def encrypt(clear_text); end

  private

  # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#92
  def generate_deterministic_iv(clear_text); end

  # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#84
  def generate_iv(cipher, clear_text); end

  class << self
    # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#23
    def iv_length; end

    # source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#19
    def key_length; end
  end
end

# source://activerecord//lib/active_record/encryption/cipher/aes256_gcm.rb#16
ActiveRecord::Encryption::Cipher::Aes256Gcm::CIPHER_TYPE = T.let(T.unsafe(nil), String)

# source://activerecord//lib/active_record/encryption/cipher.rb#12
ActiveRecord::Encryption::Cipher::DEFAULT_ENCODING = T.let(T.unsafe(nil), Encoding)

# Container of configuration options
class ActiveRecord::Encryption::Config
  # @return [Config] a new instance of Config
  #
  # source://activerecord//lib/active_record/encryption/config.rb#11
  def initialize; end

  # Returns the value of attribute add_to_filter_parameters.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def add_to_filter_parameters; end

  # Sets the attribute add_to_filter_parameters
  #
  # @param value the value to set the attribute add_to_filter_parameters to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def add_to_filter_parameters=(_arg0); end

  # Returns the value of attribute deterministic_key.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def deterministic_key; end

  # Sets the attribute deterministic_key
  #
  # @param value the value to set the attribute deterministic_key to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def deterministic_key=(_arg0); end

  # Returns the value of attribute encrypt_fixtures.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def encrypt_fixtures; end

  # Sets the attribute encrypt_fixtures
  #
  # @param value the value to set the attribute encrypt_fixtures to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def encrypt_fixtures=(_arg0); end

  # Returns the value of attribute excluded_from_filter_parameters.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def excluded_from_filter_parameters; end

  # Sets the attribute excluded_from_filter_parameters
  #
  # @param value the value to set the attribute excluded_from_filter_parameters to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def excluded_from_filter_parameters=(_arg0); end

  # Returns the value of attribute extend_queries.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def extend_queries; end

  # Sets the attribute extend_queries
  #
  # @param value the value to set the attribute extend_queries to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def extend_queries=(_arg0); end

  # Returns the value of attribute forced_encoding_for_deterministic_encryption.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def forced_encoding_for_deterministic_encryption; end

  # Sets the attribute forced_encoding_for_deterministic_encryption
  #
  # @param value the value to set the attribute forced_encoding_for_deterministic_encryption to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def forced_encoding_for_deterministic_encryption=(_arg0); end

  # Returns the value of attribute key_derivation_salt.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def key_derivation_salt; end

  # Sets the attribute key_derivation_salt
  #
  # @param value the value to set the attribute key_derivation_salt to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def key_derivation_salt=(_arg0); end

  # Configure previous encryption schemes.
  #
  #   config.active_record.encryption.previous = [ { key_provider: MyOldKeyProvider.new } ]
  #
  # source://activerecord//lib/active_record/encryption/config.rb#18
  def previous=(previous_schemes_properties); end

  # Returns the value of attribute previous_schemes.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def previous_schemes; end

  # Sets the attribute previous_schemes
  #
  # @param value the value to set the attribute previous_schemes to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def previous_schemes=(_arg0); end

  # Returns the value of attribute primary_key.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def primary_key; end

  # Sets the attribute primary_key
  #
  # @param value the value to set the attribute primary_key to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def primary_key=(_arg0); end

  # Returns the value of attribute store_key_references.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def store_key_references; end

  # Sets the attribute store_key_references
  #
  # @param value the value to set the attribute store_key_references to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def store_key_references=(_arg0); end

  # Returns the value of attribute support_unencrypted_data.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def support_unencrypted_data; end

  # Sets the attribute support_unencrypted_data
  #
  # @param value the value to set the attribute support_unencrypted_data to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def support_unencrypted_data=(_arg0); end

  # Returns the value of attribute validate_column_size.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def validate_column_size; end

  # Sets the attribute validate_column_size
  #
  # @param value the value to set the attribute validate_column_size to.
  #
  # source://activerecord//lib/active_record/encryption/config.rb#7
  def validate_column_size=(_arg0); end

  private

  # source://activerecord//lib/active_record/encryption/config.rb#39
  def add_previous_scheme(**properties); end

  # source://activerecord//lib/active_record/encryption/config.rb#25
  def set_defaults; end
end

# Configuration API for ActiveRecord::Encryption
module ActiveRecord::Encryption::Configurable
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Encryption::Configurable::ClassMethods
end

module ActiveRecord::Encryption::Configurable::ClassMethods
  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def cipher(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#20
  def configure(primary_key:, deterministic_key:, key_derivation_salt:, **properties); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#47
  def encrypted_attribute_was_declared(klass, name); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def encryptor(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def frozen_encryption(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#53
  def install_auto_filtered_parameters_hook(application); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def key_generator(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def key_provider(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#17
  def message_serializer(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/configurable.rb#42
  def on_encrypted_attribute_declared(&block); end

  private

  # source://activerecord//lib/active_record/encryption/configurable.rb#61
  def excluded_from_filter_parameters?(filter_parameter); end
end

# An encryption context configures the different entities used to perform encryption:
#
# * A key provider
# * A key generator
# * An encryptor, the facade to encrypt data
# * A cipher, the encryption algorithm
# * A message serializer
class ActiveRecord::Encryption::Context
  # @return [Context] a new instance of Context
  #
  # source://activerecord//lib/active_record/encryption/context.rb#19
  def initialize; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def cipher; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def cipher=(_arg0); end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def encryptor; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def encryptor=(_arg0); end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def frozen_encryption; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def frozen_encryption=(_arg0); end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def frozen_encryption?; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def key_generator; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def key_generator=(_arg0); end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def key_provider; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def key_provider=(_arg0); end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def message_serializer; end

  # source://activerecord//lib/active_record/encryption/context.rb#16
  def message_serializer=(_arg0); end

  private

  # source://activerecord//lib/active_record/encryption/context.rb#26
  def set_defaults; end
end

# source://activerecord//lib/active_record/encryption/context.rb#13
ActiveRecord::Encryption::Context::PROPERTIES = T.let(T.unsafe(nil), Array)

# ActiveRecord::Encryption uses encryption contexts to configure the different entities used to
# encrypt/decrypt at a given moment in time.
#
# By default, the library uses a default encryption context. This is the Context that gets configured
# initially via +config.active_record.encryption+ options. Library users can define nested encryption contexts
# when running blocks of code.
#
# See Context.
module ActiveRecord::Encryption::Contexts
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Encryption::Contexts::ClassMethods
end

module ActiveRecord::Encryption::Contexts::ClassMethods
  # source://activerecord//lib/active_record/encryption/contexts.rb#62
  def context; end

  # source://activerecord//lib/active_record/encryption/contexts.rb#66
  def current_custom_context; end

  # source://activerecord//lib/active_record/encryption/contexts.rb#57
  def protecting_encrypted_data(&block); end

  # source://activerecord//lib/active_record/encryption/contexts.rb#33
  def with_encryption_context(properties); end

  # source://activerecord//lib/active_record/encryption/contexts.rb#49
  def without_encryption(&block); end
end

# A KeyProvider that derives keys from passwords.
class ActiveRecord::Encryption::DerivedSecretKeyProvider < ::ActiveRecord::Encryption::KeyProvider
  # @return [DerivedSecretKeyProvider] a new instance of DerivedSecretKeyProvider
  #
  # source://activerecord//lib/active_record/encryption/derived_secret_key_provider.rb#7
  def initialize(passwords); end
end

# A KeyProvider that derives keys from passwords.
class ActiveRecord::Encryption::DeterministicKeyProvider < ::ActiveRecord::Encryption::DerivedSecretKeyProvider
  # @raise [ActiveRecord::Encryption::Errors::Configuration]
  # @return [DeterministicKeyProvider] a new instance of DeterministicKeyProvider
  #
  # source://activerecord//lib/active_record/encryption/deterministic_key_provider.rb#7
  def initialize(password); end
end

# This is the concern mixed in Active Record models to make them encryptable. It adds the +encrypts+
# attribute declaration, as well as the API to encrypt and decrypt records.
module ActiveRecord::Encryption::EncryptableRecord
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Encryption::EncryptableRecord::ClassMethods

  # Returns the ciphertext for +attribute_name+.
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#146
  def ciphertext_for(attribute_name); end

  # Decrypts all the encryptable attributes and saves the changes.
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#156
  def decrypt; end

  # Encrypts all the encryptable attributes and saves the changes.
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#151
  def encrypt; end

  # Returns whether a given attribute is encrypted or not.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#141
  def encrypted_attribute?(attribute_name); end

  private

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#190
  def build_decrypt_attribute_assignments; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#184
  def build_encrypt_attribute_assignments; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#199
  def cant_modify_encrypted_attributes_when_frozen; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#169
  def decrypt_attributes; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#163
  def encrypt_attributes; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#180
  def has_encrypted_attributes?; end

  # @raise [ActiveRecord::Encryption::Errors::Configuration]
  #
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#176
  def validate_encryption_allowed; end

  module GeneratedClassMethods
    def encrypted_attributes; end
    def encrypted_attributes=(value); end
    def encrypted_attributes?; end
  end

  module GeneratedInstanceMethods
    def encrypted_attributes; end
    def encrypted_attributes=(value); end
    def encrypted_attributes?; end
  end
end

module ActiveRecord::Encryption::EncryptableRecord::ClassMethods
  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#56
  def deterministic_encrypted_attributes; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#45
  def encrypts(*names, key_provider: T.unsafe(nil), key: T.unsafe(nil), deterministic: T.unsafe(nil), downcase: T.unsafe(nil), ignore_case: T.unsafe(nil), previous: T.unsafe(nil), **context_properties); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#63
  def source_attribute_from_preserved_attribute(attribute_name); end

  private

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#127
  def add_length_validation_for_encrypted_columns; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#82
  def encrypt_attribute(name, attribute_scheme); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#76
  def global_previous_schemes_for(scheme); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#121
  def load_schema!; end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#104
  def override_accessors_to_preserve_original(name, original_attribute_name); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#93
  def preserve_original_encrypted(name); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#68
  def scheme_for(key_provider: T.unsafe(nil), key: T.unsafe(nil), deterministic: T.unsafe(nil), downcase: T.unsafe(nil), ignore_case: T.unsafe(nil), previous: T.unsafe(nil), **context_properties); end

  # source://activerecord//lib/active_record/encryption/encryptable_record.rb#133
  def validate_column_size(attribute_name); end
end

# source://activerecord//lib/active_record/encryption/encryptable_record.rb#161
ActiveRecord::Encryption::EncryptableRecord::ORIGINAL_ATTRIBUTE_PREFIX = T.let(T.unsafe(nil), String)

# An ActiveModel::Type::Value that encrypts/decrypts strings of text.
#
# This is the central piece that connects the encryption system with +encrypts+ declarations in the
# model classes. Whenever you declare an attribute as encrypted, it configures an +EncryptedAttributeType+
# for that attribute.
class ActiveRecord::Encryption::EncryptedAttributeType < ::ActiveRecord::Type::Text
  include ::ActiveModel::Type::Helpers::Mutable

  # === Options
  #
  # * <tt>:scheme</tt> - A +Scheme+ with the encryption properties for this attribute.
  # * <tt>:cast_type</tt> - A type that will be used to serialize (before encrypting) and deserialize
  #   (after decrypting). ActiveModel::Type::String by default.
  #
  # @return [EncryptedAttributeType] a new instance of EncryptedAttributeType
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#23
  def initialize(scheme:, cast_type: T.unsafe(nil), previous_type: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#16
  def accessor(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute cast_type.
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#13
  def cast_type; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#42
  def changed_in_place?(raw_old_value, new_value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#30
  def deserialize(value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def deterministic?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def downcase?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def fixed?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def key_provider(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def previous_schemes(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#47
  def previous_types; end

  # Returns the value of attribute scheme.
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#13
  def scheme; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#34
  def serialize(value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#15
  def with_context(*_arg0, **_arg1, &_arg2); end

  private

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#61
  def build_previous_types_for(schemes); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#135
  def clean_text_scheme; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#71
  def decrypt(value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#131
  def decryption_options; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#113
  def encrypt(value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#127
  def encryption_options; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#119
  def encryptor; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#91
  def handle_deserialize_error(error, value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#53
  def previous_schemes_including_clean_text; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#67
  def previous_type?; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#57
  def previous_types_without_clean_text; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#107
  def serialize_with_current(value); end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#103
  def serialize_with_oldest(value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#99
  def serialize_with_oldest?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#123
  def support_unencrypted_data?; end

  # source://activerecord//lib/active_record/encryption/encrypted_attribute_type.rb#83
  def try_to_deserialize_with_previous_encrypted_types(value); end
end

module ActiveRecord::Encryption::EncryptedFixtures
  # source://activerecord//lib/active_record/encryption/encrypted_fixtures.rb#6
  def initialize(fixture, model_class); end

  private

  # source://activerecord//lib/active_record/encryption/encrypted_fixtures.rb#14
  def encrypt_fixture_data(fixture, model_class); end

  # source://activerecord//lib/active_record/encryption/encrypted_fixtures.rb#26
  def process_preserved_original_columns(fixture, model_class); end
end

# An encryptor that can encrypt data but can't decrypt it.
class ActiveRecord::Encryption::EncryptingOnlyEncryptor < ::ActiveRecord::Encryption::Encryptor
  # source://activerecord//lib/active_record/encryption/encrypting_only_encryptor.rb#7
  def decrypt(encrypted_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end
end

# An encryptor exposes the encryption API that ActiveRecord::Encryption::EncryptedAttributeType
# uses for encrypting and decrypting attribute values.
#
# It interacts with a KeyProvider for getting the keys, and delegate to
# ActiveRecord::Encryption::Cipher the actual encryption algorithm.
class ActiveRecord::Encryption::Encryptor
  # Decrypts a +clean_text+ and returns the result as clean text
  #
  # === Options
  #
  # [:key_provider]
  #   Key provider to use for the encryption operation. It will default to
  #   +ActiveRecord::Encryption.key_provider+ when not provided
  #
  # [:cipher_options]
  #   Cipher-specific options that will be passed to the Cipher configured in
  #   +ActiveRecord::Encryption.cipher+
  #
  # source://activerecord//lib/active_record/encryption/encryptor.rb#52
  def decrypt(encrypted_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # Encrypts +clean_text+ and returns the encrypted result
  #
  # Internally, it will:
  #
  # 1. Create a new ActiveRecord::Encryption::Message
  # 2. Compress and encrypt +clean_text+ as the message payload
  # 3. Serialize it with +ActiveRecord::Encryption.message_serializer+ (+ActiveRecord::Encryption::SafeMarshal+
  #    by default)
  # 4. Encode the result with Base 64
  #
  # === Options
  #
  # [:key_provider]
  #   Key provider to use for the encryption operation. It will default to
  #   +ActiveRecord::Encryption.key_provider+ when not provided.
  #
  # [:cipher_options]
  #   Cipher-specific options that will be passed to the Cipher configured in
  #   +ActiveRecord::Encryption.cipher+
  #
  # source://activerecord//lib/active_record/encryption/encryptor.rb#34
  def encrypt(clear_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # Returns whether the text is encrypted or not
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/encryptor.rb#62
  def encrypted?(text); end

  private

  # source://activerecord//lib/active_record/encryption/encryptor.rb#88
  def build_encrypted_message(clear_text, key_provider:, cipher_options:); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#84
  def cipher; end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#122
  def compress(data); end

  # Under certain threshold, ZIP compression is actually worse that not compressing
  #
  # source://activerecord//lib/active_record/encryption/encryptor.rb#114
  def compress_if_worth_it(string); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#74
  def default_key_provider; end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#102
  def deserialize_message(message); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#142
  def force_encoding_if_needed(value); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#150
  def forced_encoding_for_deterministic_encryption; end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#98
  def serialize_message(message); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#109
  def serializer; end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#136
  def uncompress(data); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#128
  def uncompress_if_needed(data, compressed); end

  # source://activerecord//lib/active_record/encryption/encryptor.rb#78
  def validate_payload_type(clear_text); end
end

# source://activerecord//lib/active_record/encryption/encryptor.rb#70
ActiveRecord::Encryption::Encryptor::DECRYPT_ERRORS = T.let(T.unsafe(nil), Array)

# source://activerecord//lib/active_record/encryption/encryptor.rb#71
ActiveRecord::Encryption::Encryptor::ENCODING_ERRORS = T.let(T.unsafe(nil), Array)

# source://activerecord//lib/active_record/encryption/encryptor.rb#72
ActiveRecord::Encryption::Encryptor::THRESHOLD_TO_JUSTIFY_COMPRESSION = T.let(T.unsafe(nil), Integer)

# Implements a simple envelope encryption approach where:
#
# * It generates a random data-encryption key for each encryption operation.
# * It stores the generated key along with the encrypted payload. It encrypts this key
#   with the master key provided in the +active_record_encryption.primary_key+ credential.
#
# This provider can work with multiple master keys. It will use the last one for encrypting.
#
# When +config.active_record.encryption.store_key_references+ is true, it will also store a reference to
# the specific master key that was used to encrypt the data-encryption key. When not set,
# it will try all the configured master keys looking for the right one, in order to
# return the right decryption key.
class ActiveRecord::Encryption::EnvelopeEncryptionKeyProvider
  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#31
  def active_primary_key; end

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#26
  def decryption_keys(encrypted_message); end

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#18
  def encryption_key; end

  private

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#40
  def decrypt_data_key(encrypted_message); end

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#36
  def encrypt_data_key(random_secret); end

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#50
  def generate_random_secret; end

  # source://activerecord//lib/active_record/encryption/envelope_encryption_key_provider.rb#46
  def primary_key_provider; end
end

module ActiveRecord::Encryption::Errors; end
class ActiveRecord::Encryption::Errors::Base < ::StandardError; end
class ActiveRecord::Encryption::Errors::Configuration < ::ActiveRecord::Encryption::Errors::Base; end
class ActiveRecord::Encryption::Errors::Decryption < ::ActiveRecord::Encryption::Errors::Base; end
class ActiveRecord::Encryption::Errors::Encoding < ::ActiveRecord::Encryption::Errors::Base; end
class ActiveRecord::Encryption::Errors::EncryptedContentIntegrity < ::ActiveRecord::Encryption::Errors::Base; end
class ActiveRecord::Encryption::Errors::Encryption < ::ActiveRecord::Encryption::Errors::Base; end
class ActiveRecord::Encryption::Errors::ForbiddenClass < ::ActiveRecord::Encryption::Errors::Base; end

# Automatically expand encrypted arguments to support querying both encrypted and unencrypted data
#
# Active Record \Encryption supports querying the db using deterministic attributes. For example:
#
#   Contact.find_by(email_address: "jorge@hey.com")
#
# The value "jorge@hey.com" will get encrypted automatically to perform the query. But there is
# a problem while the data is being encrypted. This won't work. During that time, you need these
# queries to be:
#
#   Contact.find_by(email_address: [ "jorge@hey.com", "<encrypted jorge@hey.com>" ])
#
# This patches ActiveRecord to support this automatically. It addresses both:
#
# * ActiveRecord::Base - Used in <tt>Contact.find_by_email_address(...)</tt>
# * ActiveRecord::Relation - Used in <tt>Contact.internal.find_by_email_address(...)</tt>
#
# ActiveRecord::Base relies on ActiveRecord::Relation (ActiveRecord::QueryMethods) but it does
# some prepared statements caching. That's why we need to intercept +ActiveRecord::Base+ as soon
# as it's invoked (so that the proper prepared statement is cached).
#
# When modifying this file run performance tests in +test/performance/extended_deterministic_queries_performance_test.rb+ to
#   make sure performance overhead is acceptable.
#
# We will extend this to support previous "encryption context" versions in future iterations
module ActiveRecord::Encryption::ExtendedDeterministicQueries
  class << self
    # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#34
    def install_support; end
  end
end

class ActiveRecord::Encryption::ExtendedDeterministicQueries::AdditionalValue
  # @return [AdditionalValue] a new instance of AdditionalValue
  #
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#124
  def initialize(value, type); end

  # Returns the value of attribute type.
  #
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#122
  def type; end

  # Returns the value of attribute value.
  #
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#122
  def value; end

  private

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#130
  def process(value); end
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::CoreQueries
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Encryption::ExtendedDeterministicQueries::CoreQueries::ClassMethods
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::CoreQueries::ClassMethods
  include ::ActiveRecord::Encryption::ExtendedDeterministicQueries::EncryptedQueryArgumentProcessor

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#114
  def find_by(*args); end
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::EncryptedQueryArgumentProcessor
  extend ::ActiveSupport::Concern

  private

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#74
  def additional_values_for(value, type); end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#56
  def process_encrypted_query_argument(value, check_for_additional_values, type); end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#45
  def process_encrypted_query_arguments(args, check_for_additional_values); end
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::ExtendedEncryptableType
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#136
  def serialize(data); end
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::InWithAdditionalValues
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#150
  def encryption_aware_type_caster; end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#146
  def proc_for_binds; end
end

module ActiveRecord::Encryption::ExtendedDeterministicQueries::RelationQueries
  include ::ActiveRecord::Encryption::ExtendedDeterministicQueries::EncryptedQueryArgumentProcessor

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#89
  def exists?(*args); end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#94
  def find_or_create_by(attributes, &block); end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#98
  def find_or_create_by!(attributes, &block); end

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#84
  def where(*args); end

  private

  # source://activerecord//lib/active_record/encryption/extended_deterministic_queries.rb#103
  def process_encrypted_query_arguments_if_needed(args); end
end

module ActiveRecord::Encryption::ExtendedDeterministicUniquenessValidator
  class << self
    # source://activerecord//lib/active_record/encryption/extended_deterministic_uniqueness_validator.rb#6
    def install_support; end
  end
end

module ActiveRecord::Encryption::ExtendedDeterministicUniquenessValidator::EncryptedUniquenessValidator
  # source://activerecord//lib/active_record/encryption/extended_deterministic_uniqueness_validator.rb#11
  def validate_each(record, attribute, value); end
end

# A key is a container for a given +secret+
#
# Optionally, it can include +public_tags+. These tags are meant to be stored
# in clean (public) and can be used, for example, to include information that
# references the key for a future retrieval operation.
class ActiveRecord::Encryption::Key
  # @return [Key] a new instance of Key
  #
  # source://activerecord//lib/active_record/encryption/key.rb#13
  def initialize(secret); end

  # source://activerecord//lib/active_record/encryption/key.rb#23
  def id; end

  # Returns the value of attribute public_tags.
  #
  # source://activerecord//lib/active_record/encryption/key.rb#11
  def public_tags; end

  # Returns the value of attribute secret.
  #
  # source://activerecord//lib/active_record/encryption/key.rb#11
  def secret; end

  class << self
    # source://activerecord//lib/active_record/encryption/key.rb#18
    def derive_from(password); end
  end
end

# Utility for generating and deriving random keys.
class ActiveRecord::Encryption::KeyGenerator
  # Derives a key from the given password. The key will have a size in bytes of +:length+ (configured +Cipher+'s length
  # by default)
  #
  # The generated key will be salted with the value of +ActiveRecord::Encryption.key_derivation_salt+
  #
  # source://activerecord//lib/active_record/encryption/key_generator.rb#32
  def derive_key_from(password, length: T.unsafe(nil)); end

  # Returns a random key in hexadecimal format. The key will have a size in bytes of +:length+ (configured +Cipher+'s
  # length by default)
  #
  # Hexadecimal format is handy for representing keys as printable text. To maximize the space of characters used, it is
  # good practice including not printable characters. Hexadecimal format ensures that generated keys are representable with
  # plain text
  #
  # To convert back to the original string with the desired length:
  #
  #   [ value ].pack("H*")
  #
  # source://activerecord//lib/active_record/encryption/key_generator.rb#24
  def generate_random_hex_key(length: T.unsafe(nil)); end

  # Returns a random key. The key will have a size in bytes of +:length+ (configured +Cipher+'s length by default)
  #
  # source://activerecord//lib/active_record/encryption/key_generator.rb#10
  def generate_random_key(length: T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/encryption/key_generator.rb#37
  def key_length; end
end

# A +KeyProvider+ serves keys:
#
# * An encryption key
# * A list of potential decryption keys. Serving multiple decryption keys supports rotation-schemes
#   where new keys are added but old keys need to continue working
class ActiveRecord::Encryption::KeyProvider
  # @return [KeyProvider] a new instance of KeyProvider
  #
  # source://activerecord//lib/active_record/encryption/key_provider.rb#11
  def initialize(keys); end

  # Returns the list of decryption keys
  #
  # When the message holds a reference to its encryption key, it will return an array
  # with that key. If not, it will return the list of keys.
  #
  # source://activerecord//lib/active_record/encryption/key_provider.rb#32
  def decryption_keys(encrypted_message); end

  # Returns the first key in the list as the active key to perform encryptions
  #
  # When +ActiveRecord::Encryption.config.store_key_references+ is true, the key will include
  # a public tag referencing the key itself. That key will be stored in the public
  # headers of the encrypted message
  #
  # source://activerecord//lib/active_record/encryption/key_provider.rb#20
  def encryption_key; end

  private

  # source://activerecord//lib/active_record/encryption/key_provider.rb#41
  def keys_grouped_by_id; end
end

# A message defines the structure of the data we store in encrypted attributes. It contains:
#
# * An encrypted payload
# * A list of unencrypted headers
#
# See Encryptor#encrypt
class ActiveRecord::Encryption::Message
  # @return [Message] a new instance of Message
  #
  # source://activerecord//lib/active_record/encryption/message.rb#14
  def initialize(payload: T.unsafe(nil), headers: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/message.rb#21
  def ==(other_message); end

  # Returns the value of attribute headers.
  #
  # source://activerecord//lib/active_record/encryption/message.rb#12
  def headers; end

  # Sets the attribute headers
  #
  # @param value the value to set the attribute headers to.
  #
  # source://activerecord//lib/active_record/encryption/message.rb#12
  def headers=(_arg0); end

  # Returns the value of attribute payload.
  #
  # source://activerecord//lib/active_record/encryption/message.rb#12
  def payload; end

  # Sets the attribute payload
  #
  # @param value the value to set the attribute payload to.
  #
  # source://activerecord//lib/active_record/encryption/message.rb#12
  def payload=(_arg0); end

  private

  # source://activerecord//lib/active_record/encryption/message.rb#26
  def validate_payload_type(payload); end
end

# A message serializer that serializes +Messages+ with JSON.
#
# The generated structure is pretty simple:
#
#   {
#     p: <payload>,
#     h: {
#       header1: value1,
#       header2: value2,
#       ...
#     }
#   }
#
# Both the payload and the header values are encoded with Base64
# to prevent JSON parsing errors and encoding issues when
# storing the resulting serialized data.
class ActiveRecord::Encryption::MessageSerializer
  # @raise [ActiveRecord::Encryption::Errors::ForbiddenClass]
  #
  # source://activerecord//lib/active_record/encryption/message_serializer.rb#29
  def dump(message); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#22
  def load(serialized_content); end

  private

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#79
  def decode_if_needed(value); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#71
  def encode_if_needed(value); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#65
  def headers_to_json(headers); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#58
  def message_to_json(message); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#35
  def parse_message(data, level); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#50
  def parse_properties(headers, level); end

  # source://activerecord//lib/active_record/encryption/message_serializer.rb#40
  def validate_message_data_format(data, level); end
end

# An encryptor that won't decrypt or encrypt. It will just return the passed
# values
class ActiveRecord::Encryption::NullEncryptor
  # source://activerecord//lib/active_record/encryption/null_encryptor.rb#12
  def decrypt(encrypted_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/null_encryptor.rb#8
  def encrypt(clean_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/null_encryptor.rb#16
  def encrypted?(text); end
end

# This is a wrapper for a hash of encryption properties. It is used by
# +Key+ (public tags) and +Message+ (headers).
#
# Since properties are serialized in messages, it is important for storage
# efficiency to keep their keys as short as possible. It defines accessors
# for common properties that will keep these keys very short while exposing
# a readable name.
#
#   message.headers.encrypted_data_key # instead of message.headers[:k]
#
# See +Properties::DEFAULT_PROPERTIES+, Key, Message
class ActiveRecord::Encryption::Properties
  # @return [Properties] a new instance of Properties
  #
  # source://activerecord//lib/active_record/encryption/properties.rb#42
  def initialize(initial_properties = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/properties.rb#20
  def ==(arg); end

  # Set a value for a given key
  #
  # It will raise an +EncryptedContentIntegrity+ if the value exists
  #
  # @raise [Errors::EncryptedContentIntegrity]
  #
  # source://activerecord//lib/active_record/encryption/properties.rb#50
  def []=(key, value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#62
  def add(other_properties); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def auth_tag; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def auth_tag=(value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def compressed; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def compressed=(value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def encoding; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def encoding=(value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def encrypted_data_key; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def encrypted_data_key=(value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def encrypted_data_key_id; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def encrypted_data_key_id=(value); end

  # source://activerecord//lib/active_record/encryption/properties.rb#33
  def iv; end

  # source://activerecord//lib/active_record/encryption/properties.rb#37
  def iv=(value); end

  # source://activesupport/7.0.4/lib/active_support/core_ext/module/delegation.rb#302
  def method_missing(method, *args, **_arg2, &block); end

  # source://activerecord//lib/active_record/encryption/properties.rb#68
  def to_h; end

  # source://activerecord//lib/active_record/encryption/properties.rb#56
  def validate_value_type(value); end

  private

  # Returns the value of attribute data.
  #
  # source://activerecord//lib/active_record/encryption/properties.rb#73
  def data; end

  # source://activesupport/7.0.4/lib/active_support/core_ext/module/delegation.rb#294
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# source://activerecord//lib/active_record/encryption/properties.rb#17
ActiveRecord::Encryption::Properties::ALLOWED_VALUE_CLASSES = T.let(T.unsafe(nil), Array)

# For each entry it generates an accessor exposing the full name
#
# source://activerecord//lib/active_record/encryption/properties.rb#23
ActiveRecord::Encryption::Properties::DEFAULT_PROPERTIES = T.let(T.unsafe(nil), Hash)

# A +NullEncryptor+ that will raise an error when trying to encrypt data
#
# This is useful when you want to reveal ciphertexts for debugging purposes
# and you want to make sure you won't overwrite any encryptable attribute with
# the wrong content.
class ActiveRecord::Encryption::ReadOnlyNullEncryptor
  # source://activerecord//lib/active_record/encryption/read_only_null_encryptor.rb#15
  def decrypt(encrypted_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # @raise [Errors::Encryption]
  #
  # source://activerecord//lib/active_record/encryption/read_only_null_encryptor.rb#11
  def encrypt(clean_text, key_provider: T.unsafe(nil), cipher_options: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/read_only_null_encryptor.rb#19
  def encrypted?(text); end
end

# A container of attribute encryption options.
#
# It validates and serves attribute encryption options.
#
# See EncryptedAttributeType, Context
class ActiveRecord::Encryption::Scheme
  # @return [Scheme] a new instance of Scheme
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#13
  def initialize(key_provider: T.unsafe(nil), key: T.unsafe(nil), deterministic: T.unsafe(nil), downcase: T.unsafe(nil), ignore_case: T.unsafe(nil), previous_schemes: T.unsafe(nil), **context_properties); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#38
  def deterministic?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#34
  def downcase?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#42
  def fixed?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#30
  def ignore_case?; end

  # source://activerecord//lib/active_record/encryption/scheme.rb#47
  def key_provider; end

  # source://activerecord//lib/active_record/encryption/scheme.rb#54
  def merge(other_scheme); end

  # Returns the value of attribute previous_schemes.
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#11
  def previous_schemes; end

  # Sets the attribute previous_schemes
  #
  # @param value the value to set the attribute previous_schemes to.
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#11
  def previous_schemes=(_arg0); end

  # source://activerecord//lib/active_record/encryption/scheme.rb#58
  def to_h; end

  # source://activerecord//lib/active_record/encryption/scheme.rb#63
  def with_context(&block); end

  private

  # source://activerecord//lib/active_record/encryption/scheme.rb#90
  def build_key_provider; end

  # @raise [Errors::Configuration]
  #
  # source://activerecord//lib/active_record/encryption/scheme.rb#72
  def validate_config!; end

  # source://activerecord//lib/active_record/encryption/scheme.rb#83
  def validate_credential(key, error_message = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/encryption/scheme.rb#77
  def validate_keys!; end
end

# Declare an enum attribute where the values map to integers in the database,
# but can be queried by name. Example:
#
#   class Conversation < ActiveRecord::Base
#     enum :status, [ :active, :archived ]
#   end
#
#   # conversation.update! status: 0
#   conversation.active!
#   conversation.active? # => true
#   conversation.status  # => "active"
#
#   # conversation.update! status: 1
#   conversation.archived!
#   conversation.archived? # => true
#   conversation.status    # => "archived"
#
#   # conversation.status = 1
#   conversation.status = "archived"
#
#   conversation.status = nil
#   conversation.status.nil? # => true
#   conversation.status      # => nil
#
# Scopes based on the allowed values of the enum field will be provided
# as well. With the above example:
#
#   Conversation.active
#   Conversation.not_active
#   Conversation.archived
#   Conversation.not_archived
#
# Of course, you can also query them directly if the scopes don't fit your
# needs:
#
#   Conversation.where(status: [:active, :archived])
#   Conversation.where.not(status: :active)
#
# Defining scopes can be disabled by setting +:scopes+ to +false+.
#
#   class Conversation < ActiveRecord::Base
#     enum :status, [ :active, :archived ], scopes: false
#   end
#
# You can set the default enum value by setting +:default+, like:
#
#   class Conversation < ActiveRecord::Base
#     enum :status, [ :active, :archived ], default: :active
#   end
#
#   conversation = Conversation.new
#   conversation.status # => "active"
#
# It's possible to explicitly map the relation between attribute and
# database integer with a hash:
#
#   class Conversation < ActiveRecord::Base
#     enum :status, active: 0, archived: 1
#   end
#
# Finally it's also possible to use a string column to persist the enumerated value.
# Note that this will likely lead to slower database queries:
#
#   class Conversation < ActiveRecord::Base
#     enum :status, active: "active", archived: "archived"
#   end
#
# Note that when an array is used, the implicit mapping from the values to database
# integers is derived from the order the values appear in the array. In the example,
# <tt>:active</tt> is mapped to +0+ as it's the first element, and <tt>:archived</tt>
# is mapped to +1+. In general, the +i+-th element is mapped to <tt>i-1</tt> in the
# database.
#
# Therefore, once a value is added to the enum array, its position in the array must
# be maintained, and new values should only be added to the end of the array. To
# remove unused values, the explicit hash syntax should be used.
#
# In rare circumstances you might need to access the mapping directly.
# The mappings are exposed through a class method with the pluralized attribute
# name, which return the mapping in a ActiveSupport::HashWithIndifferentAccess :
#
#   Conversation.statuses[:active]    # => 0
#   Conversation.statuses["archived"] # => 1
#
# Use that class method when you need to know the ordinal value of an enum.
# For example, you can use that when manually building SQL strings:
#
#   Conversation.where("status <> ?", Conversation.statuses[:archived])
#
# You can use the +:prefix+ or +:suffix+ options when you need to define
# multiple enums with same values. If the passed value is +true+, the methods
# are prefixed/suffixed with the name of the enum. It is also possible to
# supply a custom value:
#
#   class Conversation < ActiveRecord::Base
#     enum :status, [ :active, :archived ], suffix: true
#     enum :comments_status, [ :active, :inactive ], prefix: :comments
#   end
#
# With the above example, the bang and predicate methods along with the
# associated scopes are now prefixed and/or suffixed accordingly:
#
#   conversation.active_status!
#   conversation.archived_status? # => false
#
#   conversation.comments_inactive!
#   conversation.comments_active? # => false
module ActiveRecord::Enum
  # source://activerecord//lib/active_record/enum.rb#167
  def enum(name = T.unsafe(nil), values = T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/enum.rb#119
  def inherited(base); end

  private

  # source://activerecord//lib/active_record/enum.rb#180
  def _enum(name, values, prefix: T.unsafe(nil), suffix: T.unsafe(nil), scopes: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/enum.rb#261
  def _enum_methods_module; end

  # source://activerecord//lib/active_record/enum.rb#269
  def assert_valid_enum_definition_values(values); end

  # source://activerecord//lib/active_record/enum.rb#288
  def detect_enum_conflict!(enum_name, method_name, klass_method = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/enum.rb#310
  def detect_negative_enum_conditions!(method_names); end

  # @raise [ArgumentError]
  #
  # source://activerecord//lib/active_record/enum.rb#300
  def raise_conflict_error(enum_name, method_name, type: T.unsafe(nil), source: T.unsafe(nil)); end

  class << self
    # source://activerecord//lib/active_record/enum.rb#115
    def extended(base); end
  end
end

# source://activerecord//lib/active_record/enum.rb#282
ActiveRecord::Enum::ENUM_CONFLICT_MESSAGE = T.let(T.unsafe(nil), String)

class ActiveRecord::Enum::EnumMethods < ::Module
  # @return [EnumMethods] a new instance of EnumMethods
  #
  # source://activerecord//lib/active_record/enum.rb#232
  def initialize(klass); end

  private

  # source://activerecord//lib/active_record/enum.rb#239
  def define_enum_methods(name, value_method_name, value, scopes); end

  # Returns the value of attribute klass.
  #
  # source://activerecord//lib/active_record/enum.rb#237
  def klass; end
end

class ActiveRecord::Enum::EnumType < ::ActiveModel::Type::Value
  # @return [EnumType] a new instance of EnumType
  #
  # source://activerecord//lib/active_record/enum.rb#127
  def initialize(name, mapping, subtype); end

  # source://activerecord//lib/active_record/enum.rb#155
  def assert_valid_value(value); end

  # source://activerecord//lib/active_record/enum.rb#133
  def cast(value); end

  # source://activerecord//lib/active_record/enum.rb#143
  def deserialize(value); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/enum.rb#151
  def serializable?(value, &block); end

  # source://activerecord//lib/active_record/enum.rb#147
  def serialize(value); end

  # Returns the value of attribute subtype.
  #
  # source://activerecord//lib/active_record/enum.rb#161
  def subtype; end

  # source://activerecord//lib/active_record/enum.rb#125
  def type(*_arg0, **_arg1, &_arg2); end

  private

  # Returns the value of attribute mapping.
  #
  # source://activerecord//lib/active_record/enum.rb#164
  def mapping; end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/enum.rb#164
  def name; end
end

class ActiveRecord::EnvironmentMismatchError < ::ActiveRecord::ActiveRecordError
  # @return [EnvironmentMismatchError] a new instance of EnvironmentMismatchError
  #
  # source://activerecord//lib/active_record/migration.rb#198
  def initialize(current: T.unsafe(nil), stored: T.unsafe(nil)); end
end

class ActiveRecord::EnvironmentStorageError < ::ActiveRecord::ActiveRecordError
  # @return [EnvironmentStorageError] a new instance of EnvironmentStorageError
  #
  # source://activerecord//lib/active_record/migration.rb#212
  def initialize; end
end

# Raised when a pool was unable to get ahold of all its connections
# to perform a "group" action such as
# {ActiveRecord::Base.connection_pool.disconnect!}[rdoc-ref:ConnectionAdapters::ConnectionPool#disconnect!]
# or {ActiveRecord::Base.clear_reloadable_connections!}[rdoc-ref:ConnectionAdapters::ConnectionHandler#clear_reloadable_connections!].
class ActiveRecord::ExclusiveConnectionTimeoutError < ::ActiveRecord::ConnectionTimeoutError; end

module ActiveRecord::Explain
  # Executes the block with the collect flag enabled. Queries are collected
  # asynchronously by the subscriber and returned.
  #
  # source://activerecord//lib/active_record/explain.rb#9
  def collecting_queries_for_explain; end

  # Makes the adapter execute EXPLAIN for the tuples of queries and bindings.
  # Returns a formatted string ready to be logged.
  #
  # source://activerecord//lib/active_record/explain.rb#19
  def exec_explain(queries); end

  private

  # source://activerecord//lib/active_record/explain.rb#39
  def render_bind(attr); end
end

# This is a thread locals registry for EXPLAIN. For example
#
#   ActiveRecord::ExplainRegistry.queries
#
# returns the collected queries local to the current thread.
class ActiveRecord::ExplainRegistry
  # @return [ExplainRegistry] a new instance of ExplainRegistry
  #
  # source://activerecord//lib/active_record/explain_registry.rb#24
  def initialize; end

  # Returns the value of attribute collect.
  #
  # source://activerecord//lib/active_record/explain_registry.rb#21
  def collect; end

  # Sets the attribute collect
  #
  # @param value the value to set the attribute collect to.
  #
  # source://activerecord//lib/active_record/explain_registry.rb#21
  def collect=(_arg0); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/explain_registry.rb#28
  def collect?; end

  # Returns the value of attribute queries.
  #
  # source://activerecord//lib/active_record/explain_registry.rb#22
  def queries; end

  # source://activerecord//lib/active_record/explain_registry.rb#32
  def reset; end

  class << self
    # source://activerecord//lib/active_record/explain_registry.rb#13
    def collect(*_arg0, **_arg1, &_arg2); end

    # source://activerecord//lib/active_record/explain_registry.rb#13
    def collect=(arg); end

    # source://activerecord//lib/active_record/explain_registry.rb#13
    def collect?(*_arg0, **_arg1, &_arg2); end

    # source://activerecord//lib/active_record/explain_registry.rb#13
    def queries(*_arg0, **_arg1, &_arg2); end

    # source://activerecord//lib/active_record/explain_registry.rb#13
    def reset(*_arg0, **_arg1, &_arg2); end

    private

    # source://activerecord//lib/active_record/explain_registry.rb#16
    def instance; end
  end
end

class ActiveRecord::ExplainSubscriber
  # source://activerecord//lib/active_record/explain_subscriber.rb#12
  def finish(name, id, payload); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/explain_subscriber.rb#25
  def ignore_payload?(payload); end

  # source://activerecord//lib/active_record/explain_subscriber.rb#8
  def start(name, id, payload); end
end

# source://activerecord//lib/active_record/explain_subscriber.rb#24
ActiveRecord::ExplainSubscriber::EXPLAINED_SQLS = T.let(T.unsafe(nil), Regexp)

# SCHEMA queries cannot be EXPLAINed, also we do not want to run EXPLAIN on
# our own EXPLAINs no matter how loopingly beautiful that would be.
#
# On the other hand, we want to monitor the performance of our real database
# queries, not the performance of the access to the query cache.
#
# source://activerecord//lib/active_record/explain_subscriber.rb#23
ActiveRecord::ExplainSubscriber::IGNORED_PAYLOADS = T.let(T.unsafe(nil), Array)

module ActiveRecord::FinderMethods
  # Returns true if a record exists in the table that matches the +id+ or
  # conditions given, or false otherwise. The argument can take six forms:
  #
  # * Integer - Finds the record with this primary key.
  # * String - Finds the record with a primary key corresponding to this
  #   string (such as <tt>'5'</tt>).
  # * Array - Finds the record that matches these +where+-style conditions
  #   (such as <tt>['name LIKE ?', "%#{query}%"]</tt>).
  # * Hash - Finds the record that matches these +where+-style conditions
  #   (such as <tt>{name: 'David'}</tt>).
  # * +false+ - Returns always +false+.
  # * No args - Returns +false+ if the relation is empty, +true+ otherwise.
  #
  # For more information about specifying conditions as a hash or array,
  # see the Conditions section in the introduction to ActiveRecord::Base.
  #
  # Note: You can't pass in a condition as a string (like <tt>name =
  # 'Jamie'</tt>), since it would be sanitized and then queried against
  # the primary key column, like <tt>id = 'name = \'Jamie\''</tt>.
  #
  #   Person.exists?(5)
  #   Person.exists?('5')
  #   Person.exists?(['name LIKE ?', "%#{query}%"])
  #   Person.exists?(id: [1, 4, 8])
  #   Person.exists?(name: 'David')
  #   Person.exists?(false)
  #   Person.exists?
  #   Person.where(name: 'Spartacus', rating: 4).exists?
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#326
  def exists?(conditions = T.unsafe(nil)); end

  # Find the fifth record.
  # If no order is defined it will order by primary key.
  #
  #   Person.fifth # returns the fifth object fetched by SELECT * FROM people
  #   Person.offset(3).fifth # returns the fifth object from OFFSET 3 (which is OFFSET 7)
  #   Person.where(["user_name = :u", { u: user_name }]).fifth
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#240
  def fifth; end

  # Same as #fifth but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#246
  def fifth!; end

  # Find by id - This can either be a specific id (1), a list of ids (1, 5, 6), or an array of ids ([5, 6, 10]).
  # If one or more records cannot be found for the requested ids, then ActiveRecord::RecordNotFound will be raised.
  # If the primary key is an integer, find by id coerces its arguments by using +to_i+.
  #
  #   Person.find(1)          # returns the object for ID = 1
  #   Person.find("1")        # returns the object for ID = 1
  #   Person.find("31-sarah") # returns the object for ID = 31
  #   Person.find(1, 2, 6)    # returns an array for objects with IDs in (1, 2, 6)
  #   Person.find([7, 17])    # returns an array for objects with IDs in (7, 17)
  #   Person.find([1])        # returns an array for the object with ID = 1
  #   Person.where("administrator = 1").order("created_on DESC").find(1)
  #
  # NOTE: The returned records are in the same order as the ids you provide.
  # If you want the results to be sorted by database, you can use ActiveRecord::QueryMethods#where
  # method and provide an explicit ActiveRecord::QueryMethods#order option.
  # But ActiveRecord::QueryMethods#where method doesn't raise ActiveRecord::RecordNotFound.
  #
  # ==== Find with lock
  #
  # Example for find with a lock: Imagine two concurrent transactions:
  # each will read <tt>person.visits == 2</tt>, add 1 to it, and save, resulting
  # in two saves of <tt>person.visits = 3</tt>. By locking the row, the second
  # transaction has to wait until the first is finished; we get the
  # expected <tt>person.visits == 4</tt>.
  #
  #   Person.transaction do
  #     person = Person.lock(true).find(1)
  #     person.visits += 1
  #     person.save!
  #   end
  #
  # ==== Variations of #find
  #
  #   Person.where(name: 'Spartacus', rating: 4)
  #   # returns a chainable list (which can be empty).
  #
  #   Person.find_by(name: 'Spartacus', rating: 4)
  #   # returns the first item or nil.
  #
  #   Person.find_or_initialize_by(name: 'Spartacus', rating: 4)
  #   # returns the first item or returns a new instance (requires you call .save to persist against the database).
  #
  #   Person.find_or_create_by(name: 'Spartacus', rating: 4)
  #   # returns the first item or creates it and returns it.
  #
  # ==== Alternatives for #find
  #
  #   Person.where(name: 'Spartacus', rating: 4).exists?(conditions = :none)
  #   # returns a boolean indicating if any record with the given conditions exist.
  #
  #   Person.where(name: 'Spartacus', rating: 4).select("field1, field2, field3")
  #   # returns a chainable list of instances with only the mentioned fields.
  #
  #   Person.where(name: 'Spartacus', rating: 4).ids
  #   # returns an Array of ids.
  #
  #   Person.where(name: 'Spartacus', rating: 4).pluck(:field1, :field2)
  #   # returns an Array of the required fields.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#67
  def find(*args); end

  # Finds the first record matching the specified conditions. There
  # is no implied ordering so if order matters, you should specify it
  # yourself.
  #
  # If no record is found, returns <tt>nil</tt>.
  #
  #   Post.find_by name: 'Spartacus', rating: 4
  #   Post.find_by "published_at < ?", 2.weeks.ago
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#80
  def find_by(arg, *args); end

  # Like #find_by, except that if no record is found, raises
  # an ActiveRecord::RecordNotFound error.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#86
  def find_by!(arg, *args); end

  # Finds the sole matching record. Raises ActiveRecord::RecordNotFound if no
  # record is found. Raises ActiveRecord::SoleRecordExceeded if more than one
  # record is found.
  #
  #   Product.find_sole_by(["price = %?", price])
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#129
  def find_sole_by(arg, *args); end

  # Find the first record (or first N records if a parameter is supplied).
  # If no order is defined it will order by primary key.
  #
  #   Person.first # returns the first object fetched by SELECT * FROM people ORDER BY people.id LIMIT 1
  #   Person.where(["user_name = ?", user_name]).first
  #   Person.where(["user_name = :u", { u: user_name }]).first
  #   Person.order("created_on DESC").offset(5).first
  #   Person.first(3) # returns the first three objects fetched by SELECT * FROM people ORDER BY people.id LIMIT 3
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#142
  def first(limit = T.unsafe(nil)); end

  # Same as #first but raises ActiveRecord::RecordNotFound if no record
  # is found. Note that #first! accepts no arguments.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#152
  def first!; end

  # Find the forty-second record. Also known as accessing "the reddit".
  # If no order is defined it will order by primary key.
  #
  #   Person.forty_two # returns the forty-second object fetched by SELECT * FROM people
  #   Person.offset(3).forty_two # returns the forty-second object from OFFSET 3 (which is OFFSET 44)
  #   Person.where(["user_name = :u", { u: user_name }]).forty_two
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#256
  def forty_two; end

  # Same as #forty_two but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#262
  def forty_two!; end

  # Find the fourth record.
  # If no order is defined it will order by primary key.
  #
  #   Person.fourth # returns the fourth object fetched by SELECT * FROM people
  #   Person.offset(3).fourth # returns the fourth object from OFFSET 3 (which is OFFSET 6)
  #   Person.where(["user_name = :u", { u: user_name }]).fourth
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#224
  def fourth; end

  # Same as #fourth but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#230
  def fourth!; end

  # Returns true if the relation contains the given record or false otherwise.
  #
  # No query is performed if the relation is loaded; the given record is
  # compared to the records in memory. If the relation is unloaded, an
  # efficient existence query is performed, as in #exists?.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#352
  def include?(record); end

  # Find the last record (or last N records if a parameter is supplied).
  # If no order is defined it will order by primary key.
  #
  #   Person.last # returns the last object fetched by SELECT * FROM people
  #   Person.where(["user_name = ?", user_name]).last
  #   Person.order("created_on DESC").offset(5).last
  #   Person.last(3) # returns the last three objects fetched by SELECT * FROM people.
  #
  # Take note that in that last case, the results are sorted in ascending order:
  #
  #   [#<Person id:2>, #<Person id:3>, #<Person id:4>]
  #
  # and not:
  #
  #   [#<Person id:4>, #<Person id:3>, #<Person id:2>]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#171
  def last(limit = T.unsafe(nil)); end

  # Same as #last but raises ActiveRecord::RecordNotFound if no record
  # is found. Note that #last! accepts no arguments.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#182
  def last!; end

  # Returns true if the relation contains the given record or false otherwise.
  #
  # No query is performed if the relation is loaded; the given record is
  # compared to the records in memory. If the relation is unloaded, an
  # efficient existence query is performed, as in #exists?.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#352
  def member?(record); end

  # This method is called whenever no records are found with either a single
  # id or multiple ids and raises an ActiveRecord::RecordNotFound exception.
  #
  # The error message is different depending on whether a single id or
  # multiple ids are provided. If multiple ids are provided, then the number
  # of results obtained should be provided in the +result_size+ argument and
  # the expected number of results should be provided in the +expected_size+
  # argument.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#370
  def raise_record_not_found_exception!(ids = T.unsafe(nil), result_size = T.unsafe(nil), expected_size = T.unsafe(nil), key = T.unsafe(nil), not_found_ids = T.unsafe(nil)); end

  # Find the second record.
  # If no order is defined it will order by primary key.
  #
  #   Person.second # returns the second object fetched by SELECT * FROM people
  #   Person.offset(3).second # returns the second object from OFFSET 3 (which is OFFSET 4)
  #   Person.where(["user_name = :u", { u: user_name }]).second
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#192
  def second; end

  # Same as #second but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#198
  def second!; end

  # Find the second-to-last record.
  # If no order is defined it will order by primary key.
  #
  #   Person.second_to_last # returns the second-to-last object fetched by SELECT * FROM people
  #   Person.offset(3).second_to_last # returns the second-to-last object from OFFSET 3
  #   Person.where(["user_name = :u", { u: user_name }]).second_to_last
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#288
  def second_to_last; end

  # Same as #second_to_last but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#294
  def second_to_last!; end

  # Finds the sole matching record. Raises ActiveRecord::RecordNotFound if no
  # record is found. Raises ActiveRecord::SoleRecordExceeded if more than one
  # record is found.
  #
  #   Product.where(["price = %?", price]).sole
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#112
  def sole; end

  # Gives a record (or N records if a parameter is supplied) without any implied
  # order. The order will depend on the database implementation.
  # If an order is supplied it will be respected.
  #
  #   Person.take # returns an object fetched by SELECT * FROM people LIMIT 1
  #   Person.take(5) # returns 5 objects fetched by SELECT * FROM people LIMIT 5
  #   Person.where(["name LIKE '%?'", name]).take
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#97
  def take(limit = T.unsafe(nil)); end

  # Same as #take but raises ActiveRecord::RecordNotFound if no record
  # is found. Note that #take! accepts no arguments.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#103
  def take!; end

  # Find the third record.
  # If no order is defined it will order by primary key.
  #
  #   Person.third # returns the third object fetched by SELECT * FROM people
  #   Person.offset(3).third # returns the third object from OFFSET 3 (which is OFFSET 5)
  #   Person.where(["user_name = :u", { u: user_name }]).third
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#208
  def third; end

  # Same as #third but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#214
  def third!; end

  # Find the third-to-last record.
  # If no order is defined it will order by primary key.
  #
  #   Person.third_to_last # returns the third-to-last object fetched by SELECT * FROM people
  #   Person.offset(3).third_to_last # returns the third-to-last object from OFFSET 3
  #   Person.where(["user_name = :u", { u: user_name }]).third_to_last
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#272
  def third_to_last; end

  # Same as #third_to_last but raises ActiveRecord::RecordNotFound if no record
  # is found.
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#278
  def third_to_last!; end

  private

  # source://activerecord//lib/active_record/relation/finder_methods.rb#410
  def apply_join_dependency(eager_loading: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#391
  def construct_relation_for_exists(conditions); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#570
  def find_last(limit); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#532
  def find_nth(index); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#556
  def find_nth_from_last(index); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#537
  def find_nth_with_limit(index, limit); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#464
  def find_one(id); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#480
  def find_some(ids); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#504
  def find_some_ordered(ids); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#516
  def find_take; end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#524
  def find_take_with_limit(limit); end

  # @raise [UnknownPrimaryKey]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#442
  def find_with_ids(*ids); end

  # source://activerecord//lib/active_record/relation/finder_methods.rb#574
  def ordered_relation; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/relation/finder_methods.rb#438
  def using_limitable_reflections?(reflections); end
end

# source://activerecord//lib/active_record/relation/finder_methods.rb#7
ActiveRecord::FinderMethods::ONE_AS_ONE = T.let(T.unsafe(nil), String)

class ActiveRecord::Fixture
  include ::Enumerable

  # @return [Fixture] a new instance of Fixture
  #
  # source://activerecord//lib/active_record/fixtures.rb#750
  def initialize(fixture, model_class); end

  # source://activerecord//lib/active_record/fixtures.rb#763
  def [](key); end

  # source://activerecord//lib/active_record/fixtures.rb#755
  def class_name; end

  # source://activerecord//lib/active_record/fixtures.rb#759
  def each(&block); end

  # @raise [FixtureClassNotFound]
  #
  # source://activerecord//lib/active_record/fixtures.rb#769
  def find; end

  # Returns the value of attribute fixture.
  #
  # source://activerecord//lib/active_record/fixtures.rb#748
  def fixture; end

  # Returns the value of attribute model_class.
  #
  # source://activerecord//lib/active_record/fixtures.rb#748
  def model_class; end

  # Returns the value of attribute fixture.
  #
  # source://activerecord//lib/active_record/fixtures.rb#748
  def to_hash; end
end

class ActiveRecord::Fixture::FixtureError < ::StandardError; end
class ActiveRecord::Fixture::FormatError < ::ActiveRecord::Fixture::FixtureError; end
class ActiveRecord::FixtureClassNotFound < ::ActiveRecord::ActiveRecordError; end

# \Fixtures are a way of organizing data that you want to test against; in short, sample data.
#
# They are stored in YAML files, one file per model, which are placed in the directory
# appointed by <tt>ActiveSupport::TestCase.fixture_path=(path)</tt> (this is automatically
# configured for Rails, so you can just put your files in <tt><your-rails-app>/test/fixtures/</tt>).
# The fixture file ends with the +.yml+ file extension, for example:
# <tt><your-rails-app>/test/fixtures/web_sites.yml</tt>).
#
# The format of a fixture file looks like this:
#
#   rubyonrails:
#     id: 1
#     name: Ruby on Rails
#     url: http://www.rubyonrails.org
#
#   google:
#     id: 2
#     name: Google
#     url: http://www.google.com
#
# This fixture file includes two fixtures. Each YAML fixture (i.e. record) is given a name and
# is followed by an indented list of key/value pairs in the "key: value" format. Records are
# separated by a blank line for your viewing pleasure.
#
# Note: Fixtures are unordered. If you want ordered fixtures, use the omap YAML type.
# See https://yaml.org/type/omap.html
# for the specification. You will need ordered fixtures when you have foreign key constraints
# on keys in the same table. This is commonly needed for tree structures. Example:
#
#    --- !omap
#    - parent:
#        id:         1
#        parent_id:  NULL
#        title:      Parent
#    - child:
#        id:         2
#        parent_id:  1
#        title:      Child
#
# = Using Fixtures in Test Cases
#
# Since fixtures are a testing construct, we use them in our unit and functional tests. There
# are two ways to use the fixtures, but first let's take a look at a sample unit test:
#
#   require "test_helper"
#
#   class WebSiteTest < ActiveSupport::TestCase
#     test "web_site_count" do
#       assert_equal 2, WebSite.count
#     end
#   end
#
# By default, +test_helper.rb+ will load all of your fixtures into your test
# database, so this test will succeed.
#
# The testing environment will automatically load all the fixtures into the database before each
# test. To ensure consistent data, the environment deletes the fixtures before running the load.
#
# In addition to being available in the database, the fixture's data may also be accessed by
# using a special dynamic method, which has the same name as the model.
#
# Passing in a fixture name to this dynamic method returns the fixture matching this name:
#
#   test "find one" do
#     assert_equal "Ruby on Rails", web_sites(:rubyonrails).name
#   end
#
# Passing in multiple fixture names returns all fixtures matching these names:
#
#   test "find all by name" do
#     assert_equal 2, web_sites(:rubyonrails, :google).length
#   end
#
# Passing in no arguments returns all fixtures:
#
#   test "find all" do
#     assert_equal 2, web_sites.length
#   end
#
# Passing in any fixture name that does not exist will raise <tt>StandardError</tt>:
#
#   test "find by name that does not exist" do
#     assert_raise(StandardError) { web_sites(:reddit) }
#   end
#
# Alternatively, you may enable auto-instantiation of the fixture data. For instance, take the
# following tests:
#
#   test "find_alt_method_1" do
#     assert_equal "Ruby on Rails", @web_sites['rubyonrails']['name']
#   end
#
#   test "find_alt_method_2" do
#     assert_equal "Ruby on Rails", @rubyonrails.name
#   end
#
# In order to use these methods to access fixtured data within your test cases, you must specify one of the
# following in your ActiveSupport::TestCase-derived class:
#
# - to fully enable instantiated fixtures (enable alternate methods #1 and #2 above)
#     self.use_instantiated_fixtures = true
#
# - create only the hash for the fixtures, do not 'find' each instance (enable alternate method #1 only)
#     self.use_instantiated_fixtures = :no_instances
#
# Using either of these alternate methods incurs a performance hit, as the fixtured data must be fully
# traversed in the database to create the fixture hash and/or instance variables. This is expensive for
# large sets of fixtured data.
#
# = Dynamic fixtures with ERB
#
# Sometimes you don't care about the content of the fixtures as much as you care about the volume.
# In these cases, you can mix ERB in with your YAML fixtures to create a bunch of fixtures for load
# testing, like:
#
#   <% 1.upto(1000) do |i| %>
#   fix_<%= i %>:
#     id: <%= i %>
#     name: guy_<%= i %>
#   <% end %>
#
# This will create 1000 very simple fixtures.
#
# Using ERB, you can also inject dynamic values into your fixtures with inserts like
# <tt><%= Date.today.strftime("%Y-%m-%d") %></tt>.
# This is however a feature to be used with some caution. The point of fixtures are that they're
# stable units of predictable sample data. If you feel that you need to inject dynamic values, then
# perhaps you should reexamine whether your application is properly testable. Hence, dynamic values
# in fixtures are to be considered a code smell.
#
# Helper methods defined in a fixture will not be available in other fixtures, to prevent against
# unwanted inter-test dependencies. Methods used by multiple fixtures should be defined in a module
# that is included in ActiveRecord::FixtureSet.context_class.
#
# - define a helper method in <tt>test_helper.rb</tt>
#     module FixtureFileHelpers
#       def file_sha(path)
#         OpenSSL::Digest::SHA256.hexdigest(File.read(Rails.root.join('test/fixtures', path)))
#       end
#     end
#     ActiveRecord::FixtureSet.context_class.include FixtureFileHelpers
#
# - use the helper method in a fixture
#     photo:
#       name: kitten.png
#       sha: <%= file_sha 'files/kitten.png' %>
#
# = Transactional Tests
#
# Test cases can use begin+rollback to isolate their changes to the database instead of having to
# delete+insert for every test case.
#
#   class FooTest < ActiveSupport::TestCase
#     self.use_transactional_tests = true
#
#     test "godzilla" do
#       assert_not_empty Foo.all
#       Foo.destroy_all
#       assert_empty Foo.all
#     end
#
#     test "godzilla aftermath" do
#       assert_not_empty Foo.all
#     end
#   end
#
# If you preload your test database with all fixture data (probably by running <tt>bin/rails db:fixtures:load</tt>)
# and use transactional tests, then you may omit all fixtures declarations in your test cases since
# all the data's already there and every case rolls back its changes.
#
# In order to use instantiated fixtures with preloaded data, set +self.pre_loaded_fixtures+ to
# true. This will provide access to fixture data for every table that has been loaded through
# fixtures (depending on the value of +use_instantiated_fixtures+).
#
# When *not* to use transactional tests:
#
# 1. You're testing whether a transaction works correctly. Nested transactions don't commit until
#    all parent transactions commit, particularly, the fixtures transaction which is begun in setup
#    and rolled back in teardown. Thus, you won't be able to verify
#    the results of your transaction until Active Record supports nested transactions or savepoints (in progress).
# 2. Your database does not support transactions. Every Active Record database supports transactions except MySQL MyISAM.
#    Use InnoDB, MaxDB, or NDB instead.
#
# = Advanced Fixtures
#
# Fixtures that don't specify an ID get some extra features:
#
# * Stable, autogenerated IDs
# * Label references for associations (belongs_to, has_one, has_many)
# * HABTM associations as inline lists
#
# There are some more advanced features available even if the id is specified:
#
# * Autofilled timestamp columns
# * Fixture label interpolation
# * Support for YAML defaults
#
# == Stable, Autogenerated IDs
#
# Here, have a monkey fixture:
#
#   george:
#     id: 1
#     name: George the Monkey
#
#   reginald:
#     id: 2
#     name: Reginald the Pirate
#
# Each of these fixtures has two unique identifiers: one for the database
# and one for the humans. Why don't we generate the primary key instead?
# Hashing each fixture's label yields a consistent ID:
#
#   george: # generated id: 503576764
#     name: George the Monkey
#
#   reginald: # generated id: 324201669
#     name: Reginald the Pirate
#
# Active Record looks at the fixture's model class, discovers the correct
# primary key, and generates it right before inserting the fixture
# into the database.
#
# The generated ID for a given label is constant, so we can discover
# any fixture's ID without loading anything, as long as we know the label.
#
# == Label references for associations (+belongs_to+, +has_one+, +has_many+)
#
# Specifying foreign keys in fixtures can be very fragile, not to
# mention difficult to read. Since Active Record can figure out the ID of
# any fixture from its label, you can specify FK's by label instead of ID.
#
# === +belongs_to+
#
# Let's break out some more monkeys and pirates.
#
#   ### in pirates.yml
#
#   reginald:
#     id: 1
#     name: Reginald the Pirate
#     monkey_id: 1
#
#   ### in monkeys.yml
#
#   george:
#     id: 1
#     name: George the Monkey
#     pirate_id: 1
#
# Add a few more monkeys and pirates and break this into multiple files,
# and it gets pretty hard to keep track of what's going on. Let's
# use labels instead of IDs:
#
#   ### in pirates.yml
#
#   reginald:
#     name: Reginald the Pirate
#     monkey: george
#
#   ### in monkeys.yml
#
#   george:
#     name: George the Monkey
#     pirate: reginald
#
# Pow! All is made clear. Active Record reflects on the fixture's model class,
# finds all the +belongs_to+ associations, and allows you to specify
# a target *label* for the *association* (monkey: george) rather than
# a target *id* for the *FK* (<tt>monkey_id: 1</tt>).
#
# ==== Polymorphic +belongs_to+
#
# Supporting polymorphic relationships is a little bit more complicated, since
# Active Record needs to know what type your association is pointing at. Something
# like this should look familiar:
#
#   ### in fruit.rb
#
#   belongs_to :eater, polymorphic: true
#
#   ### in fruits.yml
#
#   apple:
#     id: 1
#     name: apple
#     eater_id: 1
#     eater_type: Monkey
#
# Can we do better? You bet!
#
#   apple:
#     eater: george (Monkey)
#
# Just provide the polymorphic target type and Active Record will take care of the rest.
#
# === +has_and_belongs_to_many+ or <tt>has_many :through</tt>
#
# Time to give our monkey some fruit.
#
#   ### in monkeys.yml
#
#   george:
#     id: 1
#     name: George the Monkey
#
#   ### in fruits.yml
#
#   apple:
#     id: 1
#     name: apple
#
#   orange:
#     id: 2
#     name: orange
#
#   grape:
#     id: 3
#     name: grape
#
#   ### in fruits_monkeys.yml
#
#   apple_george:
#     fruit_id: 1
#     monkey_id: 1
#
#   orange_george:
#     fruit_id: 2
#     monkey_id: 1
#
#   grape_george:
#     fruit_id: 3
#     monkey_id: 1
#
# Let's make the HABTM fixture go away.
#
#   ### in monkeys.yml
#
#   george:
#     id: 1
#     name: George the Monkey
#     fruits: apple, orange, grape
#
#   ### in fruits.yml
#
#   apple:
#     name: apple
#
#   orange:
#     name: orange
#
#   grape:
#     name: grape
#
# Zap! No more fruits_monkeys.yml file. We've specified the list of fruits
# on George's fixture, but we could've just as easily specified a list
# of monkeys on each fruit. As with +belongs_to+, Active Record reflects on
# the fixture's model class and discovers the +has_and_belongs_to_many+
# associations.
#
# == Autofilled Timestamp Columns
#
# If your table/model specifies any of Active Record's
# standard timestamp columns (+created_at+, +created_on+, +updated_at+, +updated_on+),
# they will automatically be set to <tt>Time.now</tt>.
#
# If you've set specific values, they'll be left alone.
#
# == Fixture label interpolation
#
# The label of the current fixture is always available as a column value:
#
#   geeksomnia:
#     name: Geeksomnia's Account
#     subdomain: $LABEL
#     email: $LABEL@email.com
#
# Also, sometimes (like when porting older join table fixtures) you'll need
# to be able to get a hold of the identifier for a given label. ERB
# to the rescue:
#
#   george_reginald:
#     monkey_id: <%= ActiveRecord::FixtureSet.identify(:reginald) %>
#     pirate_id: <%= ActiveRecord::FixtureSet.identify(:george) %>
#
# == Support for YAML defaults
#
# You can set and reuse defaults in your fixtures YAML file.
# This is the same technique used in the +database.yml+ file to specify
# defaults:
#
#   DEFAULTS: &DEFAULTS
#     created_on: <%= 3.weeks.ago.to_fs(:db) %>
#
#   first:
#     name: Smurf
#     <<: *DEFAULTS
#
#   second:
#     name: Fraggle
#     <<: *DEFAULTS
#
# Any fixture labeled "DEFAULTS" is safely ignored.
#
# Besides using "DEFAULTS", you can also specify what fixtures will
# be ignored by setting "ignore" in "_fixture" section.
#
#   # users.yml
#   _fixture:
#     ignore:
#       - base
#     # or use "ignore: base" when there is only one fixture that needs to be ignored.
#
#   base: &base
#     admin: false
#     introduction: "This is a default description"
#
#   admin:
#     <<: *base
#     admin: true
#
#   visitor:
#     <<: *base
#
# In the above example, 'base' will be ignored when creating fixtures.
# This can be used for common attributes inheriting.
#
# == Configure the fixture model class
#
# It's possible to set the fixture's model class directly in the YAML file.
# This is helpful when fixtures are loaded outside tests and
# +set_fixture_class+ is not available (e.g.
# when running <tt>bin/rails db:fixtures:load</tt>).
#
#   _fixture:
#     model_class: User
#   david:
#     name: David
#
# Any fixtures labeled "_fixture" are safely ignored.
class ActiveRecord::FixtureSet
  # @return [FixtureSet] a new instance of FixtureSet
  #
  # source://activerecord//lib/active_record/fixtures.rb#650
  def initialize(_, name, class_name, path, config = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/fixtures.rb#662
  def [](x); end

  # source://activerecord//lib/active_record/fixtures.rb#666
  def []=(k, v); end

  # source://activerecord//lib/active_record/fixtures.rb#468
  def all_loaded_fixtures; end

  # source://activerecord//lib/active_record/fixtures.rb#468
  def all_loaded_fixtures=(val); end

  # Returns the value of attribute config.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def config; end

  # source://activerecord//lib/active_record/fixtures.rb#670
  def each(&block); end

  # Returns the value of attribute fixtures.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def fixtures; end

  # Returns the value of attribute ignored_fixtures.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def ignored_fixtures; end

  # Returns the value of attribute model_class.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def model_class; end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def name; end

  # source://activerecord//lib/active_record/fixtures.rb#674
  def size; end

  # Returns the value of attribute table_name.
  #
  # source://activerecord//lib/active_record/fixtures.rb#648
  def table_name; end

  # Returns a hash of rows to be inserted. The key is the table, the value is
  # a list of rows to insert to that table.
  #
  # source://activerecord//lib/active_record/fixtures.rb#680
  def table_rows; end

  private

  # source://activerecord//lib/active_record/fixtures.rb#700
  def ignored_fixtures=(base); end

  # source://activerecord//lib/active_record/fixtures.rb#692
  def model_class=(class_name); end

  # Loads the fixtures from the YAML file at +path+.
  # If the file sets the +model_class+ and current instance value is not set,
  # it uses the file value.
  #
  # source://activerecord//lib/active_record/fixtures.rb#718
  def read_fixture_files(path); end

  # source://activerecord//lib/active_record/fixtures.rb#734
  def yaml_file_path(path); end

  class << self
    # source://activerecord//lib/active_record/fixtures.rb#468
    def all_loaded_fixtures; end

    # source://activerecord//lib/active_record/fixtures.rb#468
    def all_loaded_fixtures=(val); end

    # source://activerecord//lib/active_record/fixtures.rb#536
    def cache_fixtures(connection, fixtures_map); end

    # source://activerecord//lib/active_record/fixtures.rb#520
    def cache_for_connection(connection); end

    # source://activerecord//lib/active_record/fixtures.rb#528
    def cached_fixtures(connection, keys_to_fetch = T.unsafe(nil)); end

    # Superclass for the evaluation contexts used by ERB fixtures.
    #
    # source://activerecord//lib/active_record/fixtures.rb#589
    def context_class; end

    # source://activerecord//lib/active_record/fixtures.rb#555
    def create_fixtures(fixtures_directory, fixture_set_names, class_names = T.unsafe(nil), config = T.unsafe(nil), &block); end

    # source://activerecord//lib/active_record/fixtures.rb#504
    def default_fixture_model_name(fixture_set_name, config = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/fixtures.rb#510
    def default_fixture_table_name(fixture_set_name, config = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://activerecord//lib/active_record/fixtures.rb#524
    def fixture_is_cached?(connection, table_name); end

    # Returns a consistent, platform-independent identifier for +label+.
    # Integer identifiers are values less than 2^30. UUIDs are RFC 4122 version 5 SHA-1 hashes.
    #
    # source://activerecord//lib/active_record/fixtures.rb#580
    def identify(label, column_type = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/fixtures.rb#549
    def instantiate_all_loaded_fixtures(object, load_instances = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/fixtures.rb#540
    def instantiate_fixtures(object, fixture_set, load_instances = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/fixtures.rb#516
    def reset_cache; end

    private

    # source://activerecord//lib/active_record/fixtures.rb#612
    def insert(fixture_sets, connection); end

    # source://activerecord//lib/active_record/fixtures.rb#594
    def read_and_insert(fixtures_directory, fixture_files, class_names, connection); end

    # source://activerecord//lib/active_record/fixtures.rb#643
    def update_all_loaded_fixtures(fixtures_map); end
  end
end

class ActiveRecord::FixtureSet::ClassCache
  # @return [ClassCache] a new instance of ClassCache
  #
  # source://activerecord//lib/active_record/fixtures.rb#471
  def initialize(class_names, config); end

  # source://activerecord//lib/active_record/fixtures.rb#481
  def [](fs_name); end

  private

  # source://activerecord//lib/active_record/fixtures.rb#498
  def default_fixture_model(fs_name, config); end

  # source://activerecord//lib/active_record/fixtures.rb#489
  def insert_class(class_names, name, klass); end
end

class ActiveRecord::FixtureSet::File
  include ::Enumerable

  # @return [File] a new instance of File
  #
  # source://activerecord//lib/active_record/fixture_set/file.rb#19
  def initialize(file); end

  # source://activerecord//lib/active_record/fixture_set/file.rb#23
  def each(&block); end

  # source://activerecord//lib/active_record/fixture_set/file.rb#31
  def ignored_fixtures; end

  # source://activerecord//lib/active_record/fixture_set/file.rb#27
  def model_class; end

  private

  # source://activerecord//lib/active_record/fixture_set/file.rb#40
  def config_row; end

  # source://activerecord//lib/active_record/fixture_set/file.rb#51
  def raw_rows; end

  # source://activerecord//lib/active_record/fixture_set/file.rb#36
  def rows; end

  # Validate our unmarshalled data.
  #
  # source://activerecord//lib/active_record/fixture_set/file.rb#76
  def validate(data); end

  # source://activerecord//lib/active_record/fixture_set/file.rb#61
  def validate_config_row(data); end

  class << self
    # Open a fixture file named +file+.  When called with a block, the block
    # is called with the filehandle and the filehandle is automatically closed
    # when the block finishes.
    #
    # source://activerecord//lib/active_record/fixture_set/file.rb#14
    def open(file); end
  end
end

# --
# An instance of FixtureSet is normally stored in a single YAML file and
# possibly in a folder with the same name.
# ++
#
# source://activerecord//lib/active_record/fixtures.rb#464
ActiveRecord::FixtureSet::MAX_ID = T.let(T.unsafe(nil), Integer)

class ActiveRecord::FixtureSet::ModelMetadata
  # @return [ModelMetadata] a new instance of ModelMetadata
  #
  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#6
  def initialize(model_class); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#18
  def has_primary_key_column?; end

  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#27
  def inheritance_column_name; end

  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#10
  def primary_key_name; end

  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#14
  def primary_key_type; end

  # source://activerecord//lib/active_record/fixture_set/model_metadata.rb#23
  def timestamp_column_names; end
end

# NOTE: This class has to be defined in compact style in
# order for rendering context subclassing to work correctly.
class ActiveRecord::FixtureSet::RenderContext
  class << self
    # source://activerecord//lib/active_record/fixture_set/render_context.rb#6
    def create_subclass; end
  end
end

class ActiveRecord::FixtureSet::TableRow
  # @return [TableRow] a new instance of TableRow
  #
  # source://activerecord//lib/active_record/fixture_set/table_row.rb#65
  def initialize(fixture, table_rows:, label:, now:); end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#73
  def to_hash; end

  private

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#165
  def add_join_records(association); end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#86
  def fill_row_model_attributes; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#103
  def fill_timestamps; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#119
  def generate_primary_key; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#112
  def interpolate_label; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#82
  def model_class; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#78
  def model_metadata; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#95
  def reflection_class; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#128
  def resolve_enums; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#136
  def resolve_sti_reflections; end
end

class ActiveRecord::FixtureSet::TableRow::HasManyThroughProxy < ::ActiveRecord::FixtureSet::TableRow::ReflectionProxy
  # source://activerecord//lib/active_record/fixture_set/table_row.rb#33
  def join_table; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#29
  def lhs_key; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#25
  def rhs_key; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#37
  def timestamp_column_names; end
end

class ActiveRecord::FixtureSet::TableRow::PrimaryKeyError < ::StandardError
  # @return [PrimaryKeyError] a new instance of PrimaryKeyError
  #
  # source://activerecord//lib/active_record/fixture_set/table_row.rb#43
  def initialize(label, association, value); end
end

class ActiveRecord::FixtureSet::TableRow::ReflectionProxy
  # @return [ReflectionProxy] a new instance of ReflectionProxy
  #
  # source://activerecord//lib/active_record/fixture_set/table_row.rb#7
  def initialize(association); end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#11
  def join_table; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#15
  def name; end

  # source://activerecord//lib/active_record/fixture_set/table_row.rb#19
  def primary_key_type; end
end

class ActiveRecord::FixtureSet::TableRows
  # @return [TableRows] a new instance of TableRows
  #
  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#9
  def initialize(table_name, model_class:, fixtures:); end

  # Returns the value of attribute model_class.
  #
  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#21
  def model_class; end

  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#27
  def model_metadata; end

  # Returns the value of attribute tables.
  #
  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#21
  def tables; end

  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#23
  def to_hash; end

  private

  # source://activerecord//lib/active_record/fixture_set/table_rows.rb#32
  def build_table_rows_from(table_name, fixtures); end
end

class ActiveRecord::FutureResult
  # @return [FutureResult] a new instance of FutureResult
  #
  # source://activerecord//lib/active_record/future_result.rb#33
  def initialize(pool, *args, **kwargs); end

  # source://activerecord//lib/active_record/future_result.rb#57
  def cancel; end

  # source://activerecord//lib/active_record/future_result.rb#29
  def empty?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/future_result.rb#53
  def execute!(connection); end

  # source://activerecord//lib/active_record/future_result.rb#63
  def execute_or_skip; end

  # Returns the value of attribute lock_wait.
  #
  # source://activerecord//lib/active_record/future_result.rb#31
  def lock_wait; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/future_result.rb#94
  def pending?; end

  # source://activerecord//lib/active_record/future_result.rb#81
  def result; end

  # source://activerecord//lib/active_record/future_result.rb#48
  def schedule!(session); end

  # source://activerecord//lib/active_record/future_result.rb#29
  def to_a(*_arg0, **_arg1, &_arg2); end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/future_result.rb#99
  def canceled?; end

  # source://activerecord//lib/active_record/future_result.rb#126
  def exec_query(connection, *args, **kwargs); end

  # source://activerecord//lib/active_record/future_result.rb#103
  def execute_or_wait; end

  # source://activerecord//lib/active_record/future_result.rb#118
  def execute_query(connection, async: T.unsafe(nil)); end
end

class ActiveRecord::FutureResult::Canceled < ::ActiveRecord::ActiveRecordError; end

class ActiveRecord::FutureResult::EventBuffer
  # @return [EventBuffer] a new instance of EventBuffer
  #
  # source://activerecord//lib/active_record/future_result.rb#6
  def initialize(future_result, instrumenter); end

  # source://activerecord//lib/active_record/future_result.rb#18
  def flush; end

  # source://activerecord//lib/active_record/future_result.rb#12
  def instrument(name, payload = T.unsafe(nil), &block); end
end

class ActiveRecord::FutureResult::SelectAll < ::ActiveRecord::FutureResult
  private

  # source://activerecord//lib/active_record/future_result.rb#132
  def exec_query(*_arg0, **_arg1); end
end

class ActiveRecord::HasManyThroughAssociationNotFoundError < ::ActiveRecord::ActiveRecordError
  include ::DidYouMean::Correctable

  # @return [HasManyThroughAssociationNotFoundError] a new instance of HasManyThroughAssociationNotFoundError
  #
  # source://activerecord//lib/active_record/associations.rb#77
  def initialize(owner_class = T.unsafe(nil), reflection = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/associations.rb#90
  def corrections; end

  # Returns the value of attribute owner_class.
  #
  # source://activerecord//lib/active_record/associations.rb#75
  def owner_class; end

  # Returns the value of attribute reflection.
  #
  # source://activerecord//lib/active_record/associations.rb#75
  def reflection; end
end

class ActiveRecord::HasManyThroughAssociationPointlessSourceTypeError < ::ActiveRecord::ActiveRecordError
  # @return [HasManyThroughAssociationPointlessSourceTypeError] a new instance of HasManyThroughAssociationPointlessSourceTypeError
  #
  # source://activerecord//lib/active_record/associations.rb#125
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil), source_reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasManyThroughAssociationPolymorphicSourceError < ::ActiveRecord::ActiveRecordError
  # @return [HasManyThroughAssociationPolymorphicSourceError] a new instance of HasManyThroughAssociationPolymorphicSourceError
  #
  # source://activerecord//lib/active_record/associations.rb#105
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil), source_reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasManyThroughAssociationPolymorphicThroughError < ::ActiveRecord::ActiveRecordError
  # @return [HasManyThroughAssociationPolymorphicThroughError] a new instance of HasManyThroughAssociationPolymorphicThroughError
  #
  # source://activerecord//lib/active_record/associations.rb#115
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasManyThroughCantAssociateThroughHasOneOrManyReflection < ::ActiveRecord::ThroughCantAssociateThroughHasOneOrManyReflection; end
class ActiveRecord::HasManyThroughNestedAssociationsAreReadonly < ::ActiveRecord::ThroughNestedAssociationsAreReadonly; end

class ActiveRecord::HasManyThroughOrderError < ::ActiveRecord::ActiveRecordError
  # @return [HasManyThroughOrderError] a new instance of HasManyThroughOrderError
  #
  # source://activerecord//lib/active_record/associations.rb#168
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil), through_reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasManyThroughSourceAssociationNotFoundError < ::ActiveRecord::ActiveRecordError
  # @return [HasManyThroughSourceAssociationNotFoundError] a new instance of HasManyThroughSourceAssociationNotFoundError
  #
  # source://activerecord//lib/active_record/associations.rb#155
  def initialize(reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasOneAssociationPolymorphicThroughError < ::ActiveRecord::ActiveRecordError
  # @return [HasOneAssociationPolymorphicThroughError] a new instance of HasOneAssociationPolymorphicThroughError
  #
  # source://activerecord//lib/active_record/associations.rb#145
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasOneThroughCantAssociateThroughCollection < ::ActiveRecord::ActiveRecordError
  # @return [HasOneThroughCantAssociateThroughCollection] a new instance of HasOneThroughCantAssociateThroughCollection
  #
  # source://activerecord//lib/active_record/associations.rb#135
  def initialize(owner_class_name = T.unsafe(nil), reflection = T.unsafe(nil), through_reflection = T.unsafe(nil)); end
end

class ActiveRecord::HasOneThroughCantAssociateThroughHasOneOrManyReflection < ::ActiveRecord::ThroughCantAssociateThroughHasOneOrManyReflection; end
class ActiveRecord::HasOneThroughNestedAssociationsAreReadonly < ::ActiveRecord::ThroughNestedAssociationsAreReadonly; end

class ActiveRecord::IllegalMigrationNameError < ::ActiveRecord::MigrationError
  # @return [IllegalMigrationNameError] a new instance of IllegalMigrationNameError
  #
  # source://activerecord//lib/active_record/migration.rb#124
  def initialize(name = T.unsafe(nil)); end
end

# Raised when a relation cannot be mutated because it's already loaded.
#
#   class Task < ActiveRecord::Base
#   end
#
#   relation = Task.all
#   relation.loaded? # => true
#
#   # Methods which try to mutate a loaded relation fail.
#   relation.where!(title: 'TODO')  # => ActiveRecord::ImmutableRelation
#   relation.limit!(5)              # => ActiveRecord::ImmutableRelation
class ActiveRecord::ImmutableRelation < ::ActiveRecord::ActiveRecordError; end

# == Single table inheritance
#
# Active Record allows inheritance by storing the name of the class in a column that by
# default is named "type" (can be changed by overwriting <tt>Base.inheritance_column</tt>).
# This means that an inheritance looking like this:
#
#   class Company < ActiveRecord::Base; end
#   class Firm < Company; end
#   class Client < Company; end
#   class PriorityClient < Client; end
#
# When you do <tt>Firm.create(name: "37signals")</tt>, this record will be saved in
# the companies table with type = "Firm". You can then fetch this row again using
# <tt>Company.where(name: '37signals').first</tt> and it will return a Firm object.
#
# Be aware that because the type column is an attribute on the record every new
# subclass will instantly be marked as dirty and the type column will be included
# in the list of changed attributes on the record. This is different from non
# Single Table Inheritance(STI) classes:
#
#   Company.new.changed? # => false
#   Firm.new.changed?    # => true
#   Firm.new.changes     # => {"type"=>["","Firm"]}
#
# If you don't have a type column defined in your table, single-table inheritance won't
# be triggered. In that case, it'll work just like normal subclasses with no special magic
# for differentiating between them or reloading the right type with find.
#
# Note, all the attributes for all the cases are kept in the same table. Read more:
# https://www.martinfowler.com/eaaCatalog/singleTableInheritance.html
module ActiveRecord::Inheritance
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods

  private

  # Sets the attribute used for single table inheritance to this class name if this is not the
  # ActiveRecord::Base descendant.
  # Considering the hierarchy Reply < Message < ActiveRecord::Base, this makes it possible to
  # do Reply.new without having to set <tt>Reply[Reply.inheritance_column] = "Reply"</tt> yourself.
  # No such attribute would be set for objects of the Message class in that example.
  #
  # source://activerecord//lib/active_record/inheritance.rb#343
  def ensure_proper_type; end

  # source://activerecord//lib/active_record/inheritance.rb#327
  def initialize_dup(other); end

  # source://activerecord//lib/active_record/inheritance.rb#333
  def initialize_internals_callback; end

  module GeneratedClassMethods
    def store_full_class_name; end
    def store_full_class_name=(value); end
    def store_full_class_name?; end
    def store_full_sti_class; end
    def store_full_sti_class=(value); end
    def store_full_sti_class?; end
  end

  module GeneratedInstanceMethods
    def store_full_class_name; end
    def store_full_class_name?; end
    def store_full_sti_class; end
    def store_full_sti_class?; end
  end
end

module ActiveRecord::Inheritance::ClassMethods
  # Set this to +true+ if this is an abstract class (see
  # <tt>abstract_class?</tt>).
  # If you are using inheritance with Active Record and don't want a class
  # to be considered as part of the STI hierarchy, you must set this to
  # true.
  # +ApplicationRecord+, for example, is generated as an abstract class.
  #
  # Consider the following default behaviour:
  #
  #   Shape = Class.new(ActiveRecord::Base)
  #   Polygon = Class.new(Shape)
  #   Square = Class.new(Polygon)
  #
  #   Shape.table_name   # => "shapes"
  #   Polygon.table_name # => "shapes"
  #   Square.table_name  # => "shapes"
  #   Shape.create!      # => #<Shape id: 1, type: nil>
  #   Polygon.create!    # => #<Polygon id: 2, type: "Polygon">
  #   Square.create!     # => #<Square id: 3, type: "Square">
  #
  # However, when using <tt>abstract_class</tt>, +Shape+ is omitted from
  # the hierarchy:
  #
  #   class Shape < ActiveRecord::Base
  #     self.abstract_class = true
  #   end
  #   Polygon = Class.new(Shape)
  #   Square = Class.new(Polygon)
  #
  #   Shape.table_name   # => nil
  #   Polygon.table_name # => "polygons"
  #   Square.table_name  # => "polygons"
  #   Shape.create!      # => NotImplementedError: Shape is an abstract class and cannot be instantiated.
  #   Polygon.create!    # => #<Polygon id: 1, type: nil>
  #   Square.create!     # => #<Square id: 2, type: "Square">
  #
  # Note that in the above example, to disallow the creation of a plain
  # +Polygon+, you should use <tt>validates :type, presence: true</tt>,
  # instead of setting it as an abstract class. This way, +Polygon+ will
  # stay in the hierarchy, and Active Record will continue to correctly
  # derive the table name.
  #
  # source://activerecord//lib/active_record/inheritance.rb#153
  def abstract_class; end

  # Set this to +true+ if this is an abstract class (see
  # <tt>abstract_class?</tt>).
  # If you are using inheritance with Active Record and don't want a class
  # to be considered as part of the STI hierarchy, you must set this to
  # true.
  # +ApplicationRecord+, for example, is generated as an abstract class.
  #
  # Consider the following default behaviour:
  #
  #   Shape = Class.new(ActiveRecord::Base)
  #   Polygon = Class.new(Shape)
  #   Square = Class.new(Polygon)
  #
  #   Shape.table_name   # => "shapes"
  #   Polygon.table_name # => "shapes"
  #   Square.table_name  # => "shapes"
  #   Shape.create!      # => #<Shape id: 1, type: nil>
  #   Polygon.create!    # => #<Polygon id: 2, type: "Polygon">
  #   Square.create!     # => #<Square id: 3, type: "Square">
  #
  # However, when using <tt>abstract_class</tt>, +Shape+ is omitted from
  # the hierarchy:
  #
  #   class Shape < ActiveRecord::Base
  #     self.abstract_class = true
  #   end
  #   Polygon = Class.new(Shape)
  #   Square = Class.new(Polygon)
  #
  #   Shape.table_name   # => nil
  #   Polygon.table_name # => "polygons"
  #   Square.table_name  # => "polygons"
  #   Shape.create!      # => NotImplementedError: Shape is an abstract class and cannot be instantiated.
  #   Polygon.create!    # => #<Polygon id: 1, type: nil>
  #   Square.create!     # => #<Square id: 2, type: "Square">
  #
  # Note that in the above example, to disallow the creation of a plain
  # +Polygon+, you should use <tt>validates :type, presence: true</tt>,
  # instead of setting it as an abstract class. This way, +Polygon+ will
  # stay in the hierarchy, and Active Record will continue to correctly
  # derive the table name.
  #
  # source://activerecord//lib/active_record/inheritance.rb#153
  def abstract_class=(_arg0); end

  # Returns whether this class is an abstract class or not.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/inheritance.rb#156
  def abstract_class?; end

  # Returns the class descending directly from ActiveRecord::Base, or
  # an abstract class, if any, in the inheritance hierarchy.
  #
  # If A extends ActiveRecord::Base, A.base_class will return A. If B descends from A
  # through some arbitrarily deep hierarchy, B.base_class will return A.
  #
  # If B < A and C < B and if A is an abstract_class then both B.base_class
  # and C.base_class would return B as the answer since A is an abstract_class.
  #
  # source://activerecord//lib/active_record/inheritance.rb#104
  def base_class; end

  # Returns whether the class is a base class.
  # See #base_class for more information.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/inheritance.rb#108
  def base_class?; end

  # Returns +true+ if this does not need STI type condition. Returns
  # +false+ if STI type condition needs to be applied.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/inheritance.rb#81
  def descends_from_active_record?; end

  # source://activerecord//lib/active_record/inheritance.rb#219
  def dup; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/inheritance.rb#91
  def finder_needs_type_condition?; end

  # source://activerecord//lib/active_record/inheritance.rb#213
  def inherited(subclass); end

  # Determines if one of the attributes passed in is the inheritance column,
  # and if the inheritance column is attr accessible, it initializes an
  # instance of the given subclass instead of the base class.
  #
  # source://activerecord//lib/active_record/inheritance.rb#55
  def new(attributes = T.unsafe(nil), &block); end

  # Returns the class for the provided +name+.
  #
  # It is used to find the class correspondent to the value stored in the polymorphic type column.
  #
  # source://activerecord//lib/active_record/inheritance.rb#205
  def polymorphic_class_for(name); end

  # Returns the value to be stored in the polymorphic type column for Polymorphic Associations.
  #
  # source://activerecord//lib/active_record/inheritance.rb#198
  def polymorphic_name; end

  # Sets the application record class for Active Record
  #
  # This is useful if your application uses a different class than
  # ApplicationRecord for your primary abstract class. This class
  # will share a database connection with Active Record. It is the class
  # that connects to your primary database.
  #
  # source://activerecord//lib/active_record/inheritance.rb#166
  def primary_abstract_class; end

  # Returns the class for the provided +type_name+.
  #
  # It is used to find the class correspondent to the value stored in the inheritance column.
  #
  # source://activerecord//lib/active_record/inheritance.rb#183
  def sti_class_for(type_name); end

  # Returns the value to be stored in the inheritance column for STI.
  #
  # source://activerecord//lib/active_record/inheritance.rb#176
  def sti_name; end

  protected

  # Returns the class type of the record using the current module as a prefix. So descendants of
  # MyApp::Business::Account would appear as MyApp::Business::AccountSubclass.
  #
  # source://activerecord//lib/active_record/inheritance.rb#235
  def compute_type(type_name); end

  # source://activerecord//lib/active_record/inheritance.rb#263
  def set_base_class; end

  private

  # Called by +instantiate+ to decide which class to use for a new
  # record instance. For single-table inheritance, we check the record
  # for a +type+ column and return the corresponding class.
  #
  # source://activerecord//lib/active_record/inheritance.rb#283
  def discriminate_class_for_record(record); end

  # source://activerecord//lib/active_record/inheritance.rb#295
  def find_sti_class(type_name); end

  # source://activerecord//lib/active_record/inheritance.rb#227
  def initialize_clone(other); end

  # Detect the subclass from the inheritance column of attrs. If the inheritance column value
  # is not self or a valid subclass, raises ActiveRecord::SubclassNotFound
  #
  # source://activerecord//lib/active_record/inheritance.rb#315
  def subclass_from_attributes(attrs); end

  # source://activerecord//lib/active_record/inheritance.rb#306
  def type_condition(table = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/inheritance.rb#291
  def using_single_table_inheritance?(record); end
end

class ActiveRecord::InsertAll
  # @raise [ArgumentError]
  # @return [InsertAll] a new instance of InsertAll
  #
  # source://activerecord//lib/active_record/insert_all.rb#10
  def initialize(model, inserts, on_duplicate:, update_only: T.unsafe(nil), returning: T.unsafe(nil), unique_by: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Returns the value of attribute connection.
  #
  # source://activerecord//lib/active_record/insert_all.rb#7
  def connection; end

  # source://activerecord//lib/active_record/insert_all.rb#37
  def execute; end

  # Returns the value of attribute inserts.
  #
  # source://activerecord//lib/active_record/insert_all.rb#7
  def inserts; end

  # Returns the value of attribute keys.
  #
  # source://activerecord//lib/active_record/insert_all.rb#7
  def keys; end

  # TODO: Consider remaining this method, as it only conditionally extends keys, not always
  #
  # source://activerecord//lib/active_record/insert_all.rb#80
  def keys_including_timestamps; end

  # source://activerecord//lib/active_record/insert_all.rb#61
  def map_key_with_value; end

  # Returns the value of attribute model.
  #
  # source://activerecord//lib/active_record/insert_all.rb#7
  def model; end

  # Returns the value of attribute on_duplicate.
  #
  # source://activerecord//lib/active_record/insert_all.rb#8
  def on_duplicate; end

  # source://activerecord//lib/active_record/insert_all.rb#48
  def primary_keys; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/insert_all.rb#75
  def record_timestamps?; end

  # Returns the value of attribute returning.
  #
  # source://activerecord//lib/active_record/insert_all.rb#8
  def returning; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/insert_all.rb#53
  def skip_duplicates?; end

  # Returns the value of attribute unique_by.
  #
  # source://activerecord//lib/active_record/insert_all.rb#8
  def unique_by; end

  # source://activerecord//lib/active_record/insert_all.rb#44
  def updatable_columns; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/insert_all.rb#57
  def update_duplicates?; end

  # Returns the value of attribute update_only.
  #
  # source://activerecord//lib/active_record/insert_all.rb#8
  def update_only; end

  # Returns the value of attribute update_sql.
  #
  # source://activerecord//lib/active_record/insert_all.rb#8
  def update_sql; end

  private

  # source://activerecord//lib/active_record/insert_all.rb#91
  def configure_on_duplicate_update_logic; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/insert_all.rb#105
  def custom_update_sql_provided?; end

  # @raise [ArgumentError]
  #
  # source://activerecord//lib/active_record/insert_all.rb#172
  def disallow_raw_sql!(value); end

  # source://activerecord//lib/active_record/insert_all.rb#133
  def ensure_valid_options_for_connection!; end

  # source://activerecord//lib/active_record/insert_all.rb#109
  def find_unique_index_for(unique_by); end

  # source://activerecord//lib/active_record/insert_all.rb#157
  def readonly_columns; end

  # Returns the value of attribute scope_attributes.
  #
  # source://activerecord//lib/active_record/insert_all.rb#89
  def scope_attributes; end

  # source://activerecord//lib/active_record/insert_all.rb#181
  def timestamps_for_create; end

  # source://activerecord//lib/active_record/insert_all.rb#152
  def to_sql; end

  # source://activerecord//lib/active_record/insert_all.rb#161
  def unique_by_columns; end

  # source://activerecord//lib/active_record/insert_all.rb#128
  def unique_indexes; end

  # source://activerecord//lib/active_record/insert_all.rb#166
  def verify_attributes(attributes); end
end

class ActiveRecord::InsertAll::Builder
  # @return [Builder] a new instance of Builder
  #
  # source://activerecord//lib/active_record/insert_all.rb#190
  def initialize(insert_all); end

  # source://activerecord//lib/active_record/insert_all.rb#219
  def conflict_target; end

  # source://activerecord//lib/active_record/insert_all.rb#194
  def into; end

  # source://activerecord//lib/active_record/insert_all.rb#188
  def keys(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/insert_all.rb#188
  def keys_including_timestamps(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute model.
  #
  # source://activerecord//lib/active_record/insert_all.rb#186
  def model; end

  # source://activerecord//lib/active_record/insert_all.rb#243
  def raw_update_sql; end

  # source://activerecord//lib/active_record/insert_all.rb#243
  def raw_update_sql?; end

  # source://activerecord//lib/active_record/insert_all.rb#188
  def record_timestamps?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/insert_all.rb#209
  def returning; end

  # source://activerecord//lib/active_record/insert_all.rb#188
  def skip_duplicates?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/insert_all.rb#233
  def touch_model_timestamps_unless(&block); end

  # source://activerecord//lib/active_record/insert_all.rb#229
  def updatable_columns; end

  # source://activerecord//lib/active_record/insert_all.rb#188
  def update_duplicates?(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/insert_all.rb#198
  def values_list; end

  private

  # source://activerecord//lib/active_record/insert_all.rb#256
  def columns_list; end

  # Returns the value of attribute connection.
  #
  # source://activerecord//lib/active_record/insert_all.rb#250
  def connection; end

  # @raise [UnknownAttributeError]
  #
  # source://activerecord//lib/active_record/insert_all.rb#260
  def extract_types_from_columns_on(table_name, keys:); end

  # source://activerecord//lib/active_record/insert_all.rb#269
  def format_columns(columns); end

  # Returns the value of attribute insert_all.
  #
  # source://activerecord//lib/active_record/insert_all.rb#250
  def insert_all; end

  # source://activerecord//lib/active_record/insert_all.rb#273
  def quote_columns(columns); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/insert_all.rb#252
  def touch_timestamp_attribute?(column_name); end
end

module ActiveRecord::Integration
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Integration::ClassMethods

  # Returns a stable cache key that can be used to identify this record.
  #
  #   Product.new.cache_key     # => "products/new"
  #   Product.find(5).cache_key # => "products/5"
  #
  # If ActiveRecord::Base.cache_versioning is turned off, as it was in Rails 5.1 and earlier,
  # the cache key will also include a version.
  #
  #   Product.cache_versioning = false
  #   Product.find(5).cache_key  # => "products/5-20071224150000" (updated_at available)
  #
  # source://activerecord//lib/active_record/integration.rb#72
  def cache_key; end

  # Returns a cache key along with the version.
  #
  # source://activerecord//lib/active_record/integration.rb#114
  def cache_key_with_version; end

  # Returns a cache version that can be used together with the cache key to form
  # a recyclable caching scheme. By default, the #updated_at column is used for the
  # cache_version, but this method can be overwritten to return something else.
  #
  # Note, this method will return nil if ActiveRecord::Base.cache_versioning is set to
  # +false+.
  #
  # source://activerecord//lib/active_record/integration.rb#97
  def cache_version; end

  # Returns a +String+, which Action Pack uses for constructing a URL to this
  # object. The default implementation returns this record's id as a +String+,
  # or +nil+ if this record's unsaved.
  #
  # For example, suppose that you have a User model, and that you have a
  # <tt>resources :users</tt> route. Normally, +user_path+ will
  # construct a path with the user object's 'id' in it:
  #
  #   user = User.find_by(name: 'Phusion')
  #   user_path(user)  # => "/users/1"
  #
  # You can override +to_param+ in your model to make +user_path+ construct
  # a path using the user's name instead of the user's id:
  #
  #   class User < ActiveRecord::Base
  #     def to_param  # overridden
  #       name
  #     end
  #   end
  #
  #   user = User.find_by(name: 'Phusion')
  #   user_path(user)  # => "/users/Phusion"
  #
  # source://activerecord//lib/active_record/integration.rb#57
  def to_param; end

  private

  # Detects if the value before type cast
  # can be used to generate a cache_version.
  #
  # The fast cache version only works with a
  # string value directly from the database.
  #
  # We also must check if the timestamp format has been changed
  # or if the timezone is not set to UTC then
  # we cannot apply our transformations correctly.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/integration.rb#178
  def can_use_fast_cache_version?(timestamp); end

  # Converts a raw database string to `:usec`
  # format.
  #
  # Example:
  #
  #   timestamp = "2018-10-15 20:02:15.266505"
  #   raw_timestamp_to_cache_version(timestamp)
  #   # => "20181015200215266505"
  #
  # PostgreSQL truncates trailing zeros,
  # https://github.com/postgres/postgres/commit/3e1beda2cde3495f41290e1ece5d544525810214
  # to account for this we pad the output with zeros
  #
  # source://activerecord//lib/active_record/integration.rb#197
  def raw_timestamp_to_cache_version(timestamp); end

  module GeneratedClassMethods
    def cache_timestamp_format; end
    def cache_timestamp_format=(value); end
    def cache_timestamp_format?; end
    def cache_versioning; end
    def cache_versioning=(value); end
    def cache_versioning?; end
    def collection_cache_versioning; end
    def collection_cache_versioning=(value); end
    def collection_cache_versioning?; end
  end

  module GeneratedInstanceMethods
    def cache_timestamp_format; end
    def cache_timestamp_format?; end
    def cache_versioning; end
    def cache_versioning?; end
    def collection_cache_versioning; end
    def collection_cache_versioning?; end
  end
end

module ActiveRecord::Integration::ClassMethods
  # source://activerecord//lib/active_record/integration.rb#163
  def collection_cache_key(collection = T.unsafe(nil), timestamp_column = T.unsafe(nil)); end

  # Defines your model's +to_param+ method to generate "pretty" URLs
  # using +method_name+, which can be any attribute or method that
  # responds to +to_s+.
  #
  #   class User < ActiveRecord::Base
  #     to_param :name
  #   end
  #
  #   user = User.find_by(name: 'Fancy Pants')
  #   user.id         # => 123
  #   user_path(user) # => "/users/123-fancy-pants"
  #
  # Values longer than 20 characters will be truncated. The value
  # is truncated word by word.
  #
  #   user = User.find_by(name: 'David Heinemeier Hansson')
  #   user.id         # => 125
  #   user_path(user) # => "/users/125-david-heinemeier"
  #
  # Because the generated param begins with the record's +id+, it is
  # suitable for passing to +find+. In a controller, for example:
  #
  #   params[:id]               # => "123-fancy-pants"
  #   User.find(params[:id]).id # => 123
  #
  # source://activerecord//lib/active_record/integration.rb#147
  def to_param(method_name = T.unsafe(nil)); end
end

# This class is used to create a table that keeps track of values and keys such
# as which environment migrations were run in.
#
# This is enabled by default. To disable this functionality set
# `use_metadata_table` to false in your database configuration.
class ActiveRecord::InternalMetadata < ::ActiveRecord::Base
  include ::ActiveRecord::InternalMetadata::GeneratedAttributeMethods
  include ::ActiveRecord::InternalMetadata::GeneratedAssociationMethods
  include ::Kaminari::ActiveRecordModelExtension
  include ::Kaminari::ConfigurationMethods
  extend ::Kaminari::ConfigurationMethods::ClassMethods

  class << self
    # source://activerecord//lib/active_record/internal_metadata.rb#34
    def [](key); end

    # source://activerecord//lib/active_record/internal_metadata.rb#28
    def []=(key, value); end

    # source://activemodel/7.0.4/lib/active_model/validations.rb#52
    def _validators; end

    # Creates an internal metadata table with columns +key+ and +value+
    #
    # source://activerecord//lib/active_record/internal_metadata.rb#41
    def create_table; end

    # source://activerecord//lib/active_record/enum.rb#116
    def defined_enums; end

    # source://activerecord//lib/active_record/internal_metadata.rb#53
    def drop_table; end

    # @return [Boolean]
    #
    # source://activerecord//lib/active_record/internal_metadata.rb#16
    def enabled?; end

    # source://kaminari-activerecord/1.2.2/lib/kaminari/activerecord/active_record_model_extension.rb#15
    def page(num = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/internal_metadata.rb#20
    def primary_key; end

    # source://activerecord//lib/active_record/timestamp.rb#47
    def record_timestamps; end

    # source://activerecord//lib/active_record/internal_metadata.rb#24
    def table_name; end
  end
end

module ActiveRecord::InternalMetadata::GeneratedAssociationMethods; end
module ActiveRecord::InternalMetadata::GeneratedAttributeMethods; end

# Raised when a record cannot be inserted or updated because it references a non-existent record,
# or when a record cannot be deleted because a parent record references it.
class ActiveRecord::InvalidForeignKey < ::ActiveRecord::WrappedDatabaseException; end

class ActiveRecord::InverseOfAssociationNotFoundError < ::ActiveRecord::ActiveRecordError
  include ::DidYouMean::Correctable

  # @return [InverseOfAssociationNotFoundError] a new instance of InverseOfAssociationNotFoundError
  #
  # source://activerecord//lib/active_record/associations.rb#36
  def initialize(reflection = T.unsafe(nil), associated_class = T.unsafe(nil)); end

  # Returns the value of attribute associated_class.
  #
  # source://activerecord//lib/active_record/associations.rb#34
  def associated_class; end

  # source://activerecord//lib/active_record/associations.rb#49
  def corrections; end

  # Returns the value of attribute reflection.
  #
  # source://activerecord//lib/active_record/associations.rb#34
  def reflection; end
end

class ActiveRecord::InverseOfAssociationRecursiveError < ::ActiveRecord::ActiveRecordError
  # @return [InverseOfAssociationRecursiveError] a new instance of InverseOfAssociationRecursiveError
  #
  # source://activerecord//lib/active_record/associations.rb#64
  def initialize(reflection = T.unsafe(nil)); end

  # Returns the value of attribute reflection.
  #
  # source://activerecord//lib/active_record/associations.rb#63
  def reflection; end
end

# Exception that can be raised to stop migrations from being rolled back.
# For example the following migration is not reversible.
# Rolling back this migration will raise an ActiveRecord::IrreversibleMigration error.
#
#   class IrreversibleMigrationExample < ActiveRecord::Migration[7.0]
#     def change
#       create_table :distributors do |t|
#         t.string :zipcode
#       end
#
#       execute <<~SQL
#         ALTER TABLE distributors
#           ADD CONSTRAINT zipchk
#             CHECK (char_length(zipcode) = 5) NO INHERIT;
#       SQL
#     end
#   end
#
# There are two ways to mitigate this problem.
#
# 1. Define <tt>#up</tt> and <tt>#down</tt> methods instead of <tt>#change</tt>:
#
#  class ReversibleMigrationExample < ActiveRecord::Migration[7.0]
#    def up
#      create_table :distributors do |t|
#        t.string :zipcode
#      end
#
#      execute <<~SQL
#        ALTER TABLE distributors
#          ADD CONSTRAINT zipchk
#            CHECK (char_length(zipcode) = 5) NO INHERIT;
#      SQL
#    end
#
#    def down
#      execute <<~SQL
#        ALTER TABLE distributors
#          DROP CONSTRAINT zipchk
#      SQL
#
#      drop_table :distributors
#    end
#  end
#
# 2. Use the #reversible method in <tt>#change</tt> method:
#
#   class ReversibleMigrationExample < ActiveRecord::Migration[7.0]
#     def change
#       create_table :distributors do |t|
#         t.string :zipcode
#       end
#
#       reversible do |dir|
#         dir.up do
#           execute <<~SQL
#             ALTER TABLE distributors
#               ADD CONSTRAINT zipchk
#                 CHECK (char_length(zipcode) = 5) NO INHERIT;
#           SQL
#         end
#
#         dir.down do
#           execute <<~SQL
#             ALTER TABLE distributors
#               DROP CONSTRAINT zipchk
#           SQL
#         end
#       end
#     end
#   end
class ActiveRecord::IrreversibleMigration < ::ActiveRecord::MigrationError; end

# IrreversibleOrderError is raised when a relation's order is too complex for
# +reverse_order+ to automatically reverse.
class ActiveRecord::IrreversibleOrderError < ::ActiveRecord::ActiveRecordError; end

module ActiveRecord::LegacyYamlAdapter
  class << self
    # source://activerecord//lib/active_record/legacy_yaml_adapter.rb#5
    def convert(coder); end
  end
end

# LockWaitTimeout will be raised when lock wait timeout exceeded.
class ActiveRecord::LockWaitTimeout < ::ActiveRecord::StatementInvalid; end

module ActiveRecord::Locking
  extend ::ActiveSupport::Autoload
end

# In de/serialize we change `nil` to 0, so that we can allow passing
# `nil` values to `lock_version`, and not result in `ActiveRecord::StaleObjectError`
# during update record.
class ActiveRecord::Locking::LockingType
  # source://activerecord//lib/active_record/locking/optimistic.rb#196
  def deserialize(value); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#208
  def encode_with(coder); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#204
  def init_with(coder); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#200
  def serialize(value); end

  class << self
    # source://activerecord//lib/active_record/locking/optimistic.rb#192
    def new(subtype); end
  end
end

# == What is Optimistic Locking
#
# Optimistic locking allows multiple users to access the same record for edits, and assumes a minimum of
# conflicts with the data. It does this by checking whether another process has made changes to a record since
# it was opened, an <tt>ActiveRecord::StaleObjectError</tt> exception is thrown if that has occurred
# and the update is ignored.
#
# Check out <tt>ActiveRecord::Locking::Pessimistic</tt> for an alternative.
#
# == Usage
#
# Active Record supports optimistic locking if the +lock_version+ field is present. Each update to the
# record increments the +lock_version+ column and the locking facilities ensure that records instantiated twice
# will let the last one saved raise a +StaleObjectError+ if the first was also updated. Example:
#
#   p1 = Person.find(1)
#   p2 = Person.find(1)
#
#   p1.first_name = "Michael"
#   p1.save
#
#   p2.first_name = "should fail"
#   p2.save # Raises an ActiveRecord::StaleObjectError
#
# Optimistic locking will also check for stale data when objects are destroyed. Example:
#
#   p1 = Person.find(1)
#   p2 = Person.find(1)
#
#   p1.first_name = "Michael"
#   p1.save
#
#   p2.destroy # Raises an ActiveRecord::StaleObjectError
#
# You're then responsible for dealing with the conflict by rescuing the exception and either rolling back, merging,
# or otherwise apply the business logic needed to resolve the conflict.
#
# This locking mechanism will function inside a single Ruby process. To make it work across all
# web requests, the recommended approach is to add +lock_version+ as a hidden field to your form.
#
# This behavior can be turned off by setting <tt>ActiveRecord::Base.lock_optimistically = false</tt>.
# To override the name of the +lock_version+ column, set the <tt>locking_column</tt> class attribute:
#
#   class Person < ActiveRecord::Base
#     self.locking_column = :lock_person
#   end
module ActiveRecord::Locking::Optimistic
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::Locking::Optimistic::ClassMethods

  # source://activerecord//lib/active_record/locking/optimistic.rb#63
  def increment!(*_arg0, **_arg1); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#59
  def locking_enabled?; end

  private

  # source://activerecord//lib/active_record/locking/optimistic.rb#73
  def _create_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#137
  def _lock_value_for_database(locking_column); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#82
  def _touch_row(attribute_names, time); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#87
  def _update_row(attribute_names, attempted_action = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/locking/optimistic.rb#120
  def destroy_row; end

  module GeneratedClassMethods
    def lock_optimistically; end
    def lock_optimistically=(value); end
    def lock_optimistically?; end
  end

  module GeneratedInstanceMethods
    def lock_optimistically; end
    def lock_optimistically?; end
  end
end

module ActiveRecord::Locking::Optimistic::ClassMethods
  # source://activerecord//lib/active_record/locking/optimistic.rb#179
  def define_attribute(name, cast_type, **_arg2); end

  # The version column used for optimistic locking. Defaults to +lock_version+.
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#162
  def locking_column; end

  # Set the column to use for optimistic locking. Defaults to +lock_version+.
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#156
  def locking_column=(value); end

  # Returns true if the +lock_optimistically+ flag is set to true
  # (which it is, by default) and the table includes the
  # +locking_column+ column (defaults to +lock_version+).
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#151
  def locking_enabled?; end

  # Reset the column used for optimistic locking back to the +lock_version+ default.
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#168
  def reset_locking_column; end

  # Make sure the lock version column gets updated when counters are
  # updated.
  #
  # source://activerecord//lib/active_record/locking/optimistic.rb#174
  def update_counters(id, counters); end
end

# source://activerecord//lib/active_record/locking/optimistic.rb#146
ActiveRecord::Locking::Optimistic::ClassMethods::DEFAULT_LOCKING_COLUMN = T.let(T.unsafe(nil), String)

# Locking::Pessimistic provides support for row-level locking using
# SELECT ... FOR UPDATE and other lock types.
#
# Chain <tt>ActiveRecord::Base#find</tt> to ActiveRecord::QueryMethods#lock to obtain an exclusive
# lock on the selected rows:
#   # select * from accounts where id=1 for update
#   Account.lock.find(1)
#
# Call <tt>lock('some locking clause')</tt> to use a database-specific locking clause
# of your own such as 'LOCK IN SHARE MODE' or 'FOR UPDATE NOWAIT'. Example:
#
#   Account.transaction do
#     # select * from accounts where name = 'shugo' limit 1 for update nowait
#     shugo = Account.lock("FOR UPDATE NOWAIT").find_by(name: "shugo")
#     yuko = Account.lock("FOR UPDATE NOWAIT").find_by(name: "yuko")
#     shugo.balance -= 100
#     shugo.save!
#     yuko.balance += 100
#     yuko.save!
#   end
#
# You can also use <tt>ActiveRecord::Base#lock!</tt> method to lock one record by id.
# This may be better if you don't need to lock every row. Example:
#
#   Account.transaction do
#     # select * from accounts where ...
#     accounts = Account.where(...)
#     account1 = accounts.detect { |account| ... }
#     account2 = accounts.detect { |account| ... }
#     # select * from accounts where id=? for update
#     account1.lock!
#     account2.lock!
#     account1.balance -= 100
#     account1.save!
#     account2.balance += 100
#     account2.save!
#   end
#
# You can start a transaction and acquire the lock in one go by calling
# <tt>with_lock</tt> with a block. The block is called from within
# a transaction, the object is already locked. Example:
#
#   account = Account.first
#   account.with_lock do
#     # This block is called within a transaction,
#     # account is already locked.
#     account.balance -= 100
#     account.save!
#   end
#
# Database-specific information on row locking:
#
# [MySQL]
#   https://dev.mysql.com/doc/refman/en/innodb-locking-reads.html
#
# [PostgreSQL]
#   https://www.postgresql.org/docs/current/interactive/sql-select.html#SQL-FOR-UPDATE-SHARE
module ActiveRecord::Locking::Pessimistic
  # Obtain a row lock on this record. Reloads the record to obtain the requested
  # lock. Pass an SQL locking clause to append the end of the SELECT statement
  # or pass true for "FOR UPDATE" (the default, an exclusive row lock). Returns
  # the locked record.
  #
  # source://activerecord//lib/active_record/locking/pessimistic.rb#67
  def lock!(lock = T.unsafe(nil)); end

  # Wraps the passed block in a transaction, locking the object
  # before yielding. You can pass the SQL locking clause
  # as an optional argument (see #lock!).
  #
  # You can also pass options like <tt>requires_new:</tt>, <tt>isolation:</tt>,
  # and <tt>joinable:</tt> to the wrapping transaction (see
  # ActiveRecord::ConnectionAdapters::DatabaseStatements#transaction).
  #
  # source://activerecord//lib/active_record/locking/pessimistic.rb#89
  def with_lock(*args); end
end

class ActiveRecord::LogSubscriber < ::ActiveSupport::LogSubscriber
  # source://activerecord//lib/active_record/log_subscriber.rb#7
  def backtrace_cleaner; end

  # source://activerecord//lib/active_record/log_subscriber.rb#7
  def backtrace_cleaner=(_arg0); end

  # source://activerecord//lib/active_record/log_subscriber.rb#7
  def backtrace_cleaner?; end

  # source://activerecord//lib/active_record/log_subscriber.rb#30
  def sql(event); end

  # source://activerecord//lib/active_record/log_subscriber.rb#22
  def strict_loading_violation(event); end

  private

  # source://activerecord//lib/active_record/log_subscriber.rb#94
  def colorize_payload_name(name, payload_name); end

  # source://activerecord//lib/active_record/log_subscriber.rb#127
  def debug(progname = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/log_subscriber.rb#143
  def extract_query_source_location(locations); end

  # source://activerecord//lib/active_record/log_subscriber.rb#147
  def filter(name, value); end

  # source://activerecord//lib/active_record/log_subscriber.rb#135
  def log_query_source; end

  # source://activerecord//lib/active_record/log_subscriber.rb#123
  def logger; end

  # source://activerecord//lib/active_record/log_subscriber.rb#79
  def render_bind(attr, value); end

  # source://activerecord//lib/active_record/log_subscriber.rb#102
  def sql_color(sql); end

  # source://activerecord//lib/active_record/log_subscriber.rb#75
  def type_casted_binds(casted_binds); end

  class << self
    # source://activerecord//lib/active_record/log_subscriber.rb#7
    def backtrace_cleaner; end

    # source://activerecord//lib/active_record/log_subscriber.rb#7
    def backtrace_cleaner=(value); end

    # source://activerecord//lib/active_record/log_subscriber.rb#7
    def backtrace_cleaner?; end

    # source://activerecord//lib/active_record/log_subscriber.rb#17
    def reset_runtime; end

    # source://activerecord//lib/active_record/log_subscriber.rb#13
    def runtime; end

    # source://activerecord//lib/active_record/log_subscriber.rb#9
    def runtime=(value); end
  end
end

# source://activerecord//lib/active_record/log_subscriber.rb#5
ActiveRecord::LogSubscriber::IGNORE_PAYLOAD_NAMES = T.let(T.unsafe(nil), Array)

module ActiveRecord::Middleware
  extend ::ActiveSupport::Autoload
end

# The DatabaseSelector Middleware provides a framework for automatically
# swapping from the primary to the replica database connection. Rails
# provides a basic framework to determine when to swap and allows for
# applications to write custom strategy classes to override the default
# behavior.
#
# The resolver class defines when the application should switch (i.e. read
# from the primary if a write occurred less than 2 seconds ago) and a
# resolver context class that sets a value that helps the resolver class
# decide when to switch.
#
# Rails default middleware uses the request's session to set a timestamp
# that informs the application when to read from a primary or read from a
# replica.
#
# To use the DatabaseSelector in your application with default settings,
# run the provided generator.
#
#   bin/rails g active_record:multi_db
#
# This will create a file named +config/initializers/multi_db.rb+ with the
# following contents:
#
#   Rails.application.configure do
#     config.active_record.database_selector = { delay: 2.seconds }
#     config.active_record.database_resolver = ActiveRecord::Middleware::DatabaseSelector::Resolver
#     config.active_record.database_resolver_context = ActiveRecord::Middleware::DatabaseSelector::Resolver::Session
#   end
#
# Alternatively you can set the options in your environment config or
# any other config file loaded on boot.
#
# The default behavior can be changed by setting the config options to a
# custom class:
#
#   config.active_record.database_selector = { delay: 2.seconds }
#   config.active_record.database_resolver = MyResolver
#   config.active_record.database_resolver_context = MyResolver::MySession
#
# Note: If you are using `rails new my_app --minimal` you will need to call
# `require "active_support/core_ext/integer/time"` to load the libraries
# for +Time+.
class ActiveRecord::Middleware::DatabaseSelector
  # @return [DatabaseSelector] a new instance of DatabaseSelector
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#50
  def initialize(app, resolver_klass = T.unsafe(nil), context_klass = T.unsafe(nil), options = T.unsafe(nil)); end

  # Middleware that determines which database connection to use in a multiple
  # database application.
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#61
  def call(env); end

  # Returns the value of attribute context_klass.
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#57
  def context_klass; end

  # Returns the value of attribute options.
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#57
  def options; end

  # Returns the value of attribute resolver_klass.
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#57
  def resolver_klass; end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/middleware/database_selector.rb#84
  def reading_request?(request); end

  # source://activerecord//lib/active_record/middleware/database_selector.rb#70
  def select_database(request, &blk); end
end

# The Resolver class is used by the DatabaseSelector middleware to
# determine which database the request should use.
#
# To change the behavior of the Resolver class in your application,
# create a custom resolver class that inherits from
# DatabaseSelector::Resolver and implements the methods that need to
# be changed.
#
# By default the Resolver class will send read traffic to the replica
# if it's been 2 seconds since the last write.
class ActiveRecord::Middleware::DatabaseSelector::Resolver
  # @return [Resolver] a new instance of Resolver
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#26
  def initialize(context, options = T.unsafe(nil)); end

  # Returns the value of attribute context.
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#33
  def context; end

  # Returns the value of attribute delay.
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#33
  def delay; end

  # Returns the value of attribute instrumenter.
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#33
  def instrumenter; end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#35
  def read(&blk); end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#47
  def update_context(response); end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#43
  def write(&blk); end

  private

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#52
  def read_from_primary(&blk); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#74
  def read_from_primary?; end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#58
  def read_from_replica(&blk); end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#78
  def send_to_replica_delay; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#82
  def time_since_last_write_ok?; end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#64
  def write_to_primary; end

  class << self
    # source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#22
    def call(context, options = T.unsafe(nil)); end
  end
end

# source://activerecord//lib/active_record/middleware/database_selector/resolver.rb#20
ActiveRecord::Middleware::DatabaseSelector::Resolver::SEND_TO_REPLICA_DELAY = T.let(T.unsafe(nil), ActiveSupport::Duration)

# The session class is used by the DatabaseSelector::Resolver to save
# timestamps of the last write in the session.
#
# The last_write is used to determine whether it's safe to read
# from the replica or the request needs to be sent to the primary.
class ActiveRecord::Middleware::DatabaseSelector::Resolver::Session
  # @return [Session] a new instance of Session
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#28
  def initialize(session); end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#34
  def last_write_timestamp; end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#42
  def save(response); end

  # Returns the value of attribute session.
  #
  # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#32
  def session; end

  # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#38
  def update_last_write_timestamp; end

  class << self
    # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#13
    def call(request); end

    # Converts time to a timestamp that represents milliseconds since
    # epoch.
    #
    # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#19
    def convert_time_to_timestamp(time); end

    # Converts milliseconds since epoch timestamp into a time object.
    #
    # source://activerecord//lib/active_record/middleware/database_selector/resolver/session.rb#24
    def convert_timestamp_to_time(timestamp); end
  end
end

# The ShardSelector Middleware provides a framework for automatically
# swapping shards. Rails provides a basic framework to determine which
# shard to switch to and allows for applications to write custom strategies
# for swapping if needed.
#
# The ShardSelector takes a set of options (currently only +lock+ is supported)
# that can be used by the middleware to alter behavior. +lock+ is
# true by default and will prohibit the request from switching shards once
# inside the block. If +lock+ is false, then shard swapping will be allowed.
# For tenant based sharding, +lock+ should always be true to prevent application
# code from mistakenly switching between tenants.
#
# Options can be set in the config:
#
#   config.active_record.shard_selector = { lock: true }
#
# Applications must also provide the code for the resolver as it depends on application
# specific models. An example resolver would look like this:
#
#   config.active_record.shard_resolver = ->(request) {
#     subdomain = request.subdomain
#     tenant = Tenant.find_by_subdomain!(subdomain)
#     tenant.shard
#   }
class ActiveRecord::Middleware::ShardSelector
  # @return [ShardSelector] a new instance of ShardSelector
  #
  # source://activerecord//lib/active_record/middleware/shard_selector.rb#30
  def initialize(app, resolver, options = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/middleware/shard_selector.rb#38
  def call(env); end

  # Returns the value of attribute options.
  #
  # source://activerecord//lib/active_record/middleware/shard_selector.rb#36
  def options; end

  # Returns the value of attribute resolver.
  #
  # source://activerecord//lib/active_record/middleware/shard_selector.rb#36
  def resolver; end

  private

  # source://activerecord//lib/active_record/middleware/shard_selector.rb#49
  def selected_shard(request); end

  # source://activerecord//lib/active_record/middleware/shard_selector.rb#53
  def set_shard(shard, &block); end
end

# = Active Record Migrations
#
# Migrations can manage the evolution of a schema used by several physical
# databases. It's a solution to the common problem of adding a field to make
# a new feature work in your local database, but being unsure of how to
# push that change to other developers and to the production server. With
# migrations, you can describe the transformations in self-contained classes
# that can be checked into version control systems and executed against
# another database that might be one, two, or five versions behind.
#
# Example of a simple migration:
#
#   class AddSsl < ActiveRecord::Migration[7.0]
#     def up
#       add_column :accounts, :ssl_enabled, :boolean, default: true
#     end
#
#     def down
#       remove_column :accounts, :ssl_enabled
#     end
#   end
#
# This migration will add a boolean flag to the accounts table and remove it
# if you're backing out of the migration. It shows how all migrations have
# two methods +up+ and +down+ that describes the transformations
# required to implement or remove the migration. These methods can consist
# of both the migration specific methods like +add_column+ and +remove_column+,
# but may also contain regular Ruby code for generating data needed for the
# transformations.
#
# Example of a more complex migration that also needs to initialize data:
#
#   class AddSystemSettings < ActiveRecord::Migration[7.0]
#     def up
#       create_table :system_settings do |t|
#         t.string  :name
#         t.string  :label
#         t.text    :value
#         t.string  :type
#         t.integer :position
#       end
#
#       SystemSetting.create  name:  'notice',
#                             label: 'Use notice?',
#                             value: 1
#     end
#
#     def down
#       drop_table :system_settings
#     end
#   end
#
# This migration first adds the +system_settings+ table, then creates the very
# first row in it using the Active Record model that relies on the table. It
# also uses the more advanced +create_table+ syntax where you can specify a
# complete table schema in one block call.
#
# == Available transformations
#
# === Creation
#
# * <tt>create_join_table(table_1, table_2, options)</tt>: Creates a join
#   table having its name as the lexical order of the first two
#   arguments. See
#   ActiveRecord::ConnectionAdapters::SchemaStatements#create_join_table for
#   details.
# * <tt>create_table(name, options)</tt>: Creates a table called +name+ and
#   makes the table object available to a block that can then add columns to it,
#   following the same format as +add_column+. See example above. The options hash
#   is for fragments like "DEFAULT CHARSET=UTF-8" that are appended to the create
#   table definition.
# * <tt>add_column(table_name, column_name, type, options)</tt>: Adds a new column
#   to the table called +table_name+
#   named +column_name+ specified to be one of the following types:
#   <tt>:string</tt>, <tt>:text</tt>, <tt>:integer</tt>, <tt>:float</tt>,
#   <tt>:decimal</tt>, <tt>:datetime</tt>, <tt>:timestamp</tt>, <tt>:time</tt>,
#   <tt>:date</tt>, <tt>:binary</tt>, <tt>:boolean</tt>. A default value can be
#   specified by passing an +options+ hash like <tt>{ default: 11 }</tt>.
#   Other options include <tt>:limit</tt> and <tt>:null</tt> (e.g.
#   <tt>{ limit: 50, null: false }</tt>) -- see
#   ActiveRecord::ConnectionAdapters::TableDefinition#column for details.
# * <tt>add_foreign_key(from_table, to_table, options)</tt>: Adds a new
#   foreign key. +from_table+ is the table with the key column, +to_table+ contains
#   the referenced primary key.
# * <tt>add_index(table_name, column_names, options)</tt>: Adds a new index
#   with the name of the column. Other options include
#   <tt>:name</tt>, <tt>:unique</tt> (e.g.
#   <tt>{ name: 'users_name_index', unique: true }</tt>) and <tt>:order</tt>
#   (e.g. <tt>{ order: { name: :desc } }</tt>).
# * <tt>add_reference(:table_name, :reference_name)</tt>: Adds a new column
#   +reference_name_id+ by default an integer. See
#   ActiveRecord::ConnectionAdapters::SchemaStatements#add_reference for details.
# * <tt>add_timestamps(table_name, options)</tt>: Adds timestamps (+created_at+
#   and +updated_at+) columns to +table_name+.
#
# === Modification
#
# * <tt>change_column(table_name, column_name, type, options)</tt>:  Changes
#   the column to a different type using the same parameters as add_column.
# * <tt>change_column_default(table_name, column_name, default_or_changes)</tt>:
#   Sets a default value for +column_name+ defined by +default_or_changes+ on
#   +table_name+. Passing a hash containing <tt>:from</tt> and <tt>:to</tt>
#   as +default_or_changes+ will make this change reversible in the migration.
# * <tt>change_column_null(table_name, column_name, null, default = nil)</tt>:
#   Sets or removes a <tt>NOT NULL</tt> constraint on +column_name+. The +null+ flag
#   indicates whether the value can be +NULL+. See
#   ActiveRecord::ConnectionAdapters::SchemaStatements#change_column_null for
#   details.
# * <tt>change_table(name, options)</tt>: Allows to make column alterations to
#   the table called +name+. It makes the table object available to a block that
#   can then add/remove columns, indexes, or foreign keys to it.
# * <tt>rename_column(table_name, column_name, new_column_name)</tt>: Renames
#   a column but keeps the type and content.
# * <tt>rename_index(table_name, old_name, new_name)</tt>: Renames an index.
# * <tt>rename_table(old_name, new_name)</tt>: Renames the table called +old_name+
#   to +new_name+.
#
# === Deletion
#
# * <tt>drop_table(name)</tt>: Drops the table called +name+.
# * <tt>drop_join_table(table_1, table_2, options)</tt>: Drops the join table
#   specified by the given arguments.
# * <tt>remove_column(table_name, column_name, type, options)</tt>: Removes the column
#   named +column_name+ from the table called +table_name+.
# * <tt>remove_columns(table_name, *column_names)</tt>: Removes the given
#   columns from the table definition.
# * <tt>remove_foreign_key(from_table, to_table = nil, **options)</tt>: Removes the
#   given foreign key from the table called +table_name+.
# * <tt>remove_index(table_name, column: column_names)</tt>: Removes the index
#   specified by +column_names+.
# * <tt>remove_index(table_name, name: index_name)</tt>: Removes the index
#   specified by +index_name+.
# * <tt>remove_reference(table_name, ref_name, options)</tt>: Removes the
#   reference(s) on +table_name+ specified by +ref_name+.
# * <tt>remove_timestamps(table_name, options)</tt>: Removes the timestamp
#   columns (+created_at+ and +updated_at+) from the table definition.
#
# == Irreversible transformations
#
# Some transformations are destructive in a manner that cannot be reversed.
# Migrations of that kind should raise an <tt>ActiveRecord::IrreversibleMigration</tt>
# exception in their +down+ method.
#
# == Running migrations from within Rails
#
# The Rails package has several tools to help create and apply migrations.
#
# To generate a new migration, you can use
#   bin/rails generate migration MyNewMigration
#
# where MyNewMigration is the name of your migration. The generator will
# create an empty migration file <tt>timestamp_my_new_migration.rb</tt>
# in the <tt>db/migrate/</tt> directory where <tt>timestamp</tt> is the
# UTC formatted date and time that the migration was generated.
#
# There is a special syntactic shortcut to generate migrations that add fields to a table.
#
#   bin/rails generate migration add_fieldname_to_tablename fieldname:string
#
# This will generate the file <tt>timestamp_add_fieldname_to_tablename.rb</tt>, which will look like this:
#   class AddFieldnameToTablename < ActiveRecord::Migration[7.0]
#     def change
#       add_column :tablenames, :fieldname, :string
#     end
#   end
#
# To run migrations against the currently configured database, use
# <tt>bin/rails db:migrate</tt>. This will update the database by running all of the
# pending migrations, creating the <tt>schema_migrations</tt> table
# (see "About the schema_migrations table" section below) if missing. It will also
# invoke the db:schema:dump command, which will update your db/schema.rb file
# to match the structure of your database.
#
# To roll the database back to a previous migration version, use
# <tt>bin/rails db:rollback VERSION=X</tt> where <tt>X</tt> is the version to which
# you wish to downgrade. Alternatively, you can also use the STEP option if you
# wish to rollback last few migrations. <tt>bin/rails db:rollback STEP=2</tt> will rollback
# the latest two migrations.
#
# If any of the migrations throw an <tt>ActiveRecord::IrreversibleMigration</tt> exception,
# that step will fail and you'll have some manual work to do.
#
# == More examples
#
# Not all migrations change the schema. Some just fix the data:
#
#   class RemoveEmptyTags < ActiveRecord::Migration[7.0]
#     def up
#       Tag.all.each { |tag| tag.destroy if tag.pages.empty? }
#     end
#
#     def down
#       # not much we can do to restore deleted data
#       raise ActiveRecord::IrreversibleMigration, "Can't recover the deleted tags"
#     end
#   end
#
# Others remove columns when they migrate up instead of down:
#
#   class RemoveUnnecessaryItemAttributes < ActiveRecord::Migration[7.0]
#     def up
#       remove_column :items, :incomplete_items_count
#       remove_column :items, :completed_items_count
#     end
#
#     def down
#       add_column :items, :incomplete_items_count
#       add_column :items, :completed_items_count
#     end
#   end
#
# And sometimes you need to do something in SQL not abstracted directly by migrations:
#
#   class MakeJoinUnique < ActiveRecord::Migration[7.0]
#     def up
#       execute "ALTER TABLE `pages_linked_pages` ADD UNIQUE `page_id_linked_page_id` (`page_id`,`linked_page_id`)"
#     end
#
#     def down
#       execute "ALTER TABLE `pages_linked_pages` DROP INDEX `page_id_linked_page_id`"
#     end
#   end
#
# == Using a model after changing its table
#
# Sometimes you'll want to add a column in a migration and populate it
# immediately after. In that case, you'll need to make a call to
# <tt>Base#reset_column_information</tt> in order to ensure that the model has the
# latest column data from after the new column was added. Example:
#
#   class AddPeopleSalary < ActiveRecord::Migration[7.0]
#     def up
#       add_column :people, :salary, :integer
#       Person.reset_column_information
#       Person.all.each do |p|
#         p.update_attribute :salary, SalaryCalculator.compute(p)
#       end
#     end
#   end
#
# == Controlling verbosity
#
# By default, migrations will describe the actions they are taking, writing
# them to the console as they happen, along with benchmarks describing how
# long each step took.
#
# You can quiet them down by setting ActiveRecord::Migration.verbose = false.
#
# You can also insert your own messages and benchmarks by using the +say_with_time+
# method:
#
#   def up
#     ...
#     say_with_time "Updating salaries..." do
#       Person.all.each do |p|
#         p.update_attribute :salary, SalaryCalculator.compute(p)
#       end
#     end
#     ...
#   end
#
# The phrase "Updating salaries..." would then be printed, along with the
# benchmark for the block when the block completes.
#
# == Timestamped Migrations
#
# By default, Rails generates migrations that look like:
#
#    20080717013526_your_migration_name.rb
#
# The prefix is a generation timestamp (in UTC).
#
# If you'd prefer to use numeric prefixes, you can turn timestamped migrations
# off by setting:
#
#    config.active_record.timestamped_migrations = false
#
# In application.rb.
#
# == Reversible Migrations
#
# Reversible migrations are migrations that know how to go +down+ for you.
# You simply supply the +up+ logic, and the Migration system figures out
# how to execute the down commands for you.
#
# To define a reversible migration, define the +change+ method in your
# migration like this:
#
#   class TenderloveMigration < ActiveRecord::Migration[7.0]
#     def change
#       create_table(:horses) do |t|
#         t.column :content, :text
#         t.column :remind_at, :datetime
#       end
#     end
#   end
#
# This migration will create the horses table for you on the way up, and
# automatically figure out how to drop the table on the way down.
#
# Some commands cannot be reversed. If you care to define how to move up
# and down in these cases, you should define the +up+ and +down+ methods
# as before.
#
# If a command cannot be reversed, an
# <tt>ActiveRecord::IrreversibleMigration</tt> exception will be raised when
# the migration is moving down.
#
# For a list of commands that are reversible, please see
# <tt>ActiveRecord::Migration::CommandRecorder</tt>.
#
# == Transactional Migrations
#
# If the database adapter supports DDL transactions, all migrations will
# automatically be wrapped in a transaction. There are queries that you
# can't execute inside a transaction though, and for these situations
# you can turn the automatic transactions off.
#
#   class ChangeEnum < ActiveRecord::Migration[7.0]
#     disable_ddl_transaction!
#
#     def up
#       execute "ALTER TYPE model_size ADD VALUE 'new_value'"
#     end
#   end
#
# Remember that you can still open your own transactions, even if you
# are in a Migration with <tt>self.disable_ddl_transaction!</tt>.
class ActiveRecord::Migration
  # @return [Migration] a new instance of Migration
  #
  # source://activerecord//lib/active_record/migration.rb#684
  def initialize(name = T.unsafe(nil), version = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#883
  def announce(message); end

  # source://activerecord//lib/active_record/migration.rb#914
  def connection; end

  # source://activerecord//lib/active_record/migration.rb#937
  def copy(destination, sources, options = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#677
  def disable_ddl_transaction; end

  # source://activerecord//lib/active_record/migration.rb#836
  def down; end

  # source://activerecord//lib/active_record/migration.rb#864
  def exec_migration(conn, direction); end

  # source://activerecord//lib/active_record/migration.rb#918
  def method_missing(method, *arguments, **_arg2, &block); end

  # Execute this migration in the named direction
  #
  # source://activerecord//lib/active_record/migration.rb#843
  def migrate(direction); end

  # Returns the value of attribute name.
  #
  # source://activerecord//lib/active_record/migration.rb#682
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://activerecord//lib/active_record/migration.rb#682
  def name=(_arg0); end

  # Determines the version number of the next migration.
  #
  # source://activerecord//lib/active_record/migration.rb#1003
  def next_migration_number(number); end

  # Finds the correct table name given an Active Record object.
  # Uses the Active Record object's own table_name, or pre/suffix from the
  # options passed in.
  #
  # source://activerecord//lib/active_record/migration.rb#994
  def proper_table_name(name, options = T.unsafe(nil)); end

  # Used to specify an operation that can be run in one direction or another.
  # Call the methods +up+ and +down+ of the yielded object to run a block
  # only in one given direction.
  # The whole block will be called in the right order within the migration.
  #
  # In the following example, the looping on users will always be done
  # when the three columns 'first_name', 'last_name' and 'full_name' exist,
  # even when migrating down:
  #
  #    class SplitNameMigration < ActiveRecord::Migration[7.0]
  #      def change
  #        add_column :users, :first_name, :string
  #        add_column :users, :last_name, :string
  #
  #        reversible do |dir|
  #          User.reset_column_information
  #          User.all.each do |u|
  #            dir.up   { u.first_name, u.last_name = u.full_name.split(' ') }
  #            dir.down { u.full_name = "#{u.first_name} #{u.last_name}" }
  #            u.save
  #          end
  #        end
  #
  #        revert { add_column :users, :full_name, :string }
  #      end
  #    end
  #
  # source://activerecord//lib/active_record/migration.rb#788
  def reversible; end

  # Reverses the migration commands for the given block and
  # the given migrations.
  #
  # The following migration will remove the table 'horses'
  # and create the table 'apples' on the way up, and the reverse
  # on the way down.
  #
  #   class FixTLMigration < ActiveRecord::Migration[7.0]
  #     def change
  #       revert do
  #         create_table(:horses) do |t|
  #           t.text :content
  #           t.datetime :remind_at
  #         end
  #       end
  #       create_table(:apples) do |t|
  #         t.string :variety
  #       end
  #     end
  #   end
  #
  # Or equivalently, if +TenderloveMigration+ is defined as in the
  # documentation for Migration:
  #
  #   require_relative "20121212123456_tenderlove_migration"
  #
  #   class FixupTLMigration < ActiveRecord::Migration[7.0]
  #     def change
  #       revert TenderloveMigration
  #
  #       create_table(:apples) do |t|
  #         t.string :variety
  #       end
  #     end
  #   end
  #
  # This command can be nested.
  #
  # source://activerecord//lib/active_record/migration.rb#731
  def revert(*migration_classes, &block); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#748
  def reverting?; end

  # Runs the given migration classes.
  # Last argument can specify options:
  #
  # - +:direction+ - Default is +:up+.
  # - +:revert+ - Default is +false+.
  #
  # source://activerecord//lib/active_record/migration.rb#816
  def run(*migration_classes); end

  # Takes a message argument and outputs it as is.
  # A second boolean argument can be passed to specify whether to indent or not.
  #
  # source://activerecord//lib/active_record/migration.rb#891
  def say(message, subitem = T.unsafe(nil)); end

  # Outputs text along with how long it took to run its block.
  # If the block returns an integer it assumes it is the number of rows affected.
  #
  # source://activerecord//lib/active_record/migration.rb#897
  def say_with_time(message); end

  # Takes a block as an argument and suppresses any output generated by the block.
  #
  # source://activerecord//lib/active_record/migration.rb#907
  def suppress_messages; end

  # Builds a hash for use in ActiveRecord::Migration#proper_table_name using
  # the Active Record object's table_name prefix and suffix
  #
  # source://activerecord//lib/active_record/migration.rb#1013
  def table_name_options(config = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#830
  def up; end

  # Used to specify an operation that is only run when migrating up
  # (for example, populating a new column with its initial values).
  #
  # In the following example, the new column +published+ will be given
  # the value +true+ for all existing records.
  #
  #    class AddPublishedToPosts < ActiveRecord::Migration[7.0]
  #      def change
  #        add_column :posts, :published, :boolean, default: false
  #        up_only do
  #          execute "update posts set published = 'true'"
  #        end
  #      end
  #    end
  #
  # source://activerecord//lib/active_record/migration.rb#807
  def up_only(&block); end

  # source://activerecord//lib/active_record/migration.rb#681
  def verbose; end

  # source://activerecord//lib/active_record/migration.rb#681
  def verbose=(val); end

  # Returns the value of attribute version.
  #
  # source://activerecord//lib/active_record/migration.rb#682
  def version; end

  # Sets the attribute version
  #
  # @param value the value to set the attribute version to.
  #
  # source://activerecord//lib/active_record/migration.rb#682
  def version=(_arg0); end

  # source://activerecord//lib/active_record/migration.rb#879
  def write(text = T.unsafe(nil)); end

  private

  # source://activerecord//lib/active_record/migration.rb#1029
  def command_recorder; end

  # source://activerecord//lib/active_record/migration.rb#1021
  def execute_block; end

  class << self
    # source://activerecord//lib/active_record/migration.rb#568
    def [](version); end

    # Raises <tt>ActiveRecord::PendingMigrationError</tt> error if any migrations are pending.
    #
    # @raise [ActiveRecord::PendingMigrationError]
    #
    # source://activerecord//lib/active_record/migration.rb#626
    def check_pending!(connection = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/migration.rb#572
    def current_version; end

    # source://activerecord//lib/active_record/migration.rb#618
    def delegate; end

    # source://activerecord//lib/active_record/migration.rb#618
    def delegate=(_arg0); end

    # source://activerecord//lib/active_record/migration.rb#619
    def disable_ddl_transaction; end

    # Disable the transaction wrapping this migration.
    # You can still create your own transactions even after calling #disable_ddl_transaction!
    #
    # For more details read the {"Transactional Migrations" section above}[rdoc-ref:Migration].
    #
    # source://activerecord//lib/active_record/migration.rb#672
    def disable_ddl_transaction!; end

    # source://activerecord//lib/active_record/migration.rb#619
    def disable_ddl_transaction=(_arg0); end

    # source://activerecord//lib/active_record/migration.rb#556
    def inherited(subclass); end

    # source://activerecord//lib/active_record/migration.rb#630
    def load_schema_if_pending!; end

    # source://activerecord//lib/active_record/migration.rb#653
    def maintain_test_schema!; end

    # source://activerecord//lib/active_record/migration.rb#659
    def method_missing(name, *args, **_arg2, &block); end

    # source://activerecord//lib/active_record/migration.rb#664
    def migrate(direction); end

    # source://activerecord//lib/active_record/migration.rb#621
    def nearest_delegate; end

    # source://activerecord//lib/active_record/migration.rb#681
    def verbose; end

    # source://activerecord//lib/active_record/migration.rb#681
    def verbose=(val); end
  end
end

# This class is used to verify that all migrations have been run before
# loading a web page if <tt>config.active_record.migration_error</tt> is set to +:page_load+.
class ActiveRecord::Migration::CheckPending
  # @return [CheckPending] a new instance of CheckPending
  #
  # source://activerecord//lib/active_record/migration.rb#581
  def initialize(app, file_watcher: T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#588
  def call(env); end

  private

  # source://activerecord//lib/active_record/migration.rb#607
  def build_watcher(&block); end

  # source://activerecord//lib/active_record/migration.rb#612
  def connection; end
end

# <tt>ActiveRecord::Migration::CommandRecorder</tt> records commands done during
# a migration and knows how to reverse those commands. The CommandRecorder
# knows how to invert the following commands:
#
# * add_column
# * add_foreign_key
# * add_check_constraint
# * add_index
# * add_reference
# * add_timestamps
# * change_column
# * change_column_default (must supply a +:from+ and +:to+ option)
# * change_column_null
# * change_column_comment (must supply a +:from+ and +:to+ option)
# * change_table_comment (must supply a +:from+ and +:to+ option)
# * create_join_table
# * create_table
# * disable_extension
# * drop_join_table
# * drop_table (must supply a block)
# * enable_extension
# * remove_column (must supply a type)
# * remove_columns (must specify at least one column name or more)
# * remove_foreign_key (must supply a second table)
# * remove_check_constraint
# * remove_index
# * remove_reference
# * remove_timestamps
# * rename_column
# * rename_index
# * rename_table
class ActiveRecord::Migration::CommandRecorder
  include ::ActiveRecord::Migration::JoinTable
  include ::ActiveRecord::Migration::CommandRecorder::StraightReversions

  # @return [CommandRecorder] a new instance of CommandRecorder
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#51
  def initialize(delegate = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_belongs_to(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_check_constraint(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_column(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_foreign_key(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_index(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_reference(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def add_timestamps(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def change_column(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def change_column_comment(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def change_column_default(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def change_column_null(*args, **_arg1, &block); end

  # @yield [delegate.update_table_definition(table_name, self)]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#120
  def change_table(table_name, **options); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def change_table_comment(*args, **_arg1, &block); end

  # Returns the value of attribute commands.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def commands; end

  # Sets the attribute commands
  #
  # @param value the value to set the attribute commands to.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def commands=(_arg0); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def create_join_table(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def create_table(*args, **_arg1, &block); end

  # Returns the value of attribute delegate.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def delegate; end

  # Sets the attribute delegate
  #
  # @param value the value to set the attribute delegate to.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def delegate=(_arg0); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def disable_extension(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def drop_join_table(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def drop_table(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def enable_extension(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def execute(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def execute_block(*args, **_arg1, &block); end

  # Returns the inverse of the given command. For example:
  #
  #   recorder.inverse_of(:rename_table, [:old, :new])
  #   # => [:rename_table, [:new, :old]]
  #
  # If the inverse of a command requires several commands, returns array of commands.
  #
  #   recorder.inverse_of(:remove_columns, [:some_table, :foo, :bar, type: :string])
  #   # => [[:add_column, :some_table, :foo, :string], [:add_column, :some_table, :bar, :string]]
  #
  # This method will raise an +IrreversibleMigration+ exception if it cannot
  # invert the +command+.
  #
  # @raise [IrreversibleMigration]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#98
  def inverse_of(command, args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_belongs_to(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_belongs_to(args, &block); end

  # Record +command+. +command+ should be a method name and arguments.
  # For example:
  #
  #   recorder.record(:method_name, [:arg1, :arg2])
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#78
  def record(*command, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_belongs_to(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_check_constraint(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_column(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_columns(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_foreign_key(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_index(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_reference(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def remove_timestamps(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def rename_column(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def rename_index(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def rename_table(*args, **_arg1, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#124
  def replay(migration); end

  # While executing the given block, the recorded will be in reverting mode.
  # All commands recorded will end up being recorded reverted
  # and in reverse order.
  # For example:
  #
  #   recorder.revert{ recorder.record(:rename_table, [:old, :new]) }
  #   # same effect as recorder.record(:rename_table, [:new, :old])
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#64
  def revert; end

  # Returns the value of attribute reverting.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def reverting; end

  # Sets the attribute reverting
  #
  # @param value the value to set the attribute reverting to.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#49
  def reverting=(_arg0); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#111
  def transaction(*args, **_arg1, &block); end

  private

  # source://activerecord//lib/active_record/migration/command_recorder.rb#252
  def invert_change_column_comment(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#223
  def invert_change_column_default(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#233
  def invert_change_column_null(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#262
  def invert_change_table_comment(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#168
  def invert_drop_table(args, &block); end

  # @raise [ActiveRecord::IrreversibleMigration]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#272
  def invert_remove_check_constraint(args); end

  # @raise [ActiveRecord::IrreversibleMigration]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#179
  def invert_remove_column(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#184
  def invert_remove_columns(args); end

  # @raise [ActiveRecord::IrreversibleMigration]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#238
  def invert_remove_foreign_key(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#202
  def invert_remove_index(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#197
  def invert_rename_column(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#192
  def invert_rename_index(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#175
  def invert_rename_table(args); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#157
  def invert_transaction(args, &block); end

  # Forwards any missing method call to the \target.
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#282
  def method_missing(method, *args, **_arg2, &block); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration/command_recorder.rb#277
  def respond_to_missing?(method, _); end
end

# source://activerecord//lib/active_record/migration/command_recorder.rb#37
ActiveRecord::Migration::CommandRecorder::ReversibleAndIrreversibleMethods = T.let(T.unsafe(nil), Array)

module ActiveRecord::Migration::CommandRecorder::StraightReversions
  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_check_constraint(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_column(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_foreign_key(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_index(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_reference(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_add_timestamps(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_create_join_table(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_create_table(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_disable_extension(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_drop_join_table(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_drop_table(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_enable_extension(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_execute_block(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_check_constraint(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_column(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_foreign_key(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_index(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_reference(args, &block); end

  # source://activerecord//lib/active_record/migration/command_recorder.rb#147
  def invert_remove_timestamps(args, &block); end
end

module ActiveRecord::Migration::Compatibility
  class << self
    # source://activerecord//lib/active_record/migration/compatibility.rb#6
    def find(version); end
  end
end

class ActiveRecord::Migration::Compatibility::V4_2 < ::ActiveRecord::Migration::Compatibility::V5_0
  # source://activerecord//lib/active_record/migration/compatibility.rb#324
  def add_belongs_to(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#324
  def add_reference(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#330
  def add_timestamps(table_name, **options); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration/compatibility.rb#335
  def index_exists?(table_name, column_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#346
  def remove_index(table_name, column_name = T.unsafe(nil), **options); end

  private

  # source://activerecord//lib/active_record/migration/compatibility.rb#352
  def compatible_table_definition(t); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#359
  def index_name_for_remove(table_name, column_name, options); end
end

module ActiveRecord::Migration::Compatibility::V4_2::TableDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#312
  def belongs_to(*_arg0, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#312
  def references(*_arg0, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#318
  def timestamps(**options); end
end

class ActiveRecord::Migration::Compatibility::V5_0 < ::ActiveRecord::Migration::Compatibility::V5_1
  # source://activerecord//lib/active_record/migration/compatibility.rb#296
  def add_belongs_to(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#286
  def add_column(table_name, column_name, type, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#296
  def add_reference(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#281
  def create_join_table(table_1, table_2, column_options: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#258
  def create_table(table_name, **options); end

  private

  # source://activerecord//lib/active_record/migration/compatibility.rb#302
  def compatible_table_definition(t); end
end

module ActiveRecord::Migration::Compatibility::V5_0::TableDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#252
  def belongs_to(*args, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#247
  def primary_key(name, type = T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#252
  def references(*args, **options); end
end

class ActiveRecord::Migration::Compatibility::V5_1 < ::ActiveRecord::Migration::Compatibility::V5_2
  # source://activerecord//lib/active_record/migration/compatibility.rb#225
  def change_column(table_name, column_name, type, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#236
  def create_table(table_name, **options); end
end

class ActiveRecord::Migration::Compatibility::V5_2 < ::ActiveRecord::Migration::Compatibility::V6_0
  # source://activerecord//lib/active_record/migration/compatibility.rb#202
  def add_timestamps(table_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#186
  def change_table(table_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#194
  def create_join_table(table_1, table_2, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#178
  def create_table(table_name, **options); end

  private

  # source://activerecord//lib/active_record/migration/compatibility.rb#215
  def command_recorder; end

  # source://activerecord//lib/active_record/migration/compatibility.rb#208
  def compatible_table_definition(t); end
end

module ActiveRecord::Migration::Compatibility::V5_2::CommandRecorder
  # source://activerecord//lib/active_record/migration/compatibility.rb#169
  def invert_change_column_comment(args); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#173
  def invert_change_table_comment(args); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#165
  def invert_transaction(args, &block); end
end

module ActiveRecord::Migration::Compatibility::V5_2::TableDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#158
  def column(name, type, index: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#153
  def timestamps(**options); end
end

class ActiveRecord::Migration::Compatibility::V6_0 < ::ActiveRecord::Migration::Compatibility::V6_1
  # source://activerecord//lib/active_record/migration/compatibility.rb#132
  def add_belongs_to(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#132
  def add_reference(table_name, ref_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#116
  def change_table(table_name, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#124
  def create_join_table(table_1, table_2, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#108
  def create_table(table_name, **options); end

  private

  # source://activerecord//lib/active_record/migration/compatibility.rb#143
  def compatible_table_definition(t); end
end

class ActiveRecord::Migration::Compatibility::V6_0::ReferenceDefinition < ::ActiveRecord::ConnectionAdapters::ReferenceDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#90
  def index_options(table_name); end
end

module ActiveRecord::Migration::Compatibility::V6_0::TableDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#96
  def belongs_to(*args, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#102
  def column(name, type, index: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#96
  def references(*args, **options); end
end

class ActiveRecord::Migration::Compatibility::V6_1 < ::ActiveRecord::Migration::Current
  # source://activerecord//lib/active_record/migration/compatibility.rb#50
  def add_column(table_name, column_name, type, **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#59
  def create_table(table_name, **options); end

  private

  # source://activerecord//lib/active_record/migration/compatibility.rb#80
  def compatible_table_definition(t); end
end

class ActiveRecord::Migration::Compatibility::V6_1::PostgreSQLCompat
  class << self
    # source://activerecord//lib/active_record/migration/compatibility.rb#37
    def compatible_timestamp_type(type, connection); end
  end
end

module ActiveRecord::Migration::Compatibility::V6_1::TableDefinition
  # source://activerecord//lib/active_record/migration/compatibility.rb#73
  def column(name, type, index: T.unsafe(nil), **options); end

  # source://activerecord//lib/active_record/migration/compatibility.rb#68
  def new_column_definition(name, type, **options); end
end

# This file exists to ensure that old migrations run the same way they did before a Rails upgrade.
# e.g. if you write a migration on Rails 6.1, then upgrade to Rails 7, the migration should do the same thing to your
# database as it did when you were running Rails 6.1
#
# "Current" is an alias for `ActiveRecord::Migration`, it represents the current Rails version.
# New migration functionality that will never be backward compatible should be added directly to `ActiveRecord::Migration`.
#
# There are classes for each prior Rails version. Each class descends from the *next* Rails version, so:
# 6.1 < 7.0
# 5.2 < 6.0 < 6.1 < 7.0
#
# If you are introducing new migration functionality that should only apply from Rails 7 onward, then you should
# find the class that immediately precedes it (6.1), and override the relevant migration methods to undo your changes.
#
# For example, Rails 6 added a default value for the `precision` option on datetime columns. So in this file, the `V5_2`
# class sets the value of `precision` to `nil` if it's not explicitly provided. This way, the default value will not apply
# for migrations written for 5.2, but will for migrations written for 6.0.
#
# source://activerecord//lib/active_record/migration/compatibility.rb#33
ActiveRecord::Migration::Compatibility::V7_0 = ActiveRecord::Migration::Current

# This must be defined before the inherited hook, below
class ActiveRecord::Migration::Current < ::ActiveRecord::Migration; end

module ActiveRecord::Migration::JoinTable
  private

  # source://activerecord//lib/active_record/migration/join_table.rb#7
  def find_join_table_name(table_1, table_2, options = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration/join_table.rb#11
  def join_table_name(table_1, table_2); end
end

# source://activerecord//lib/active_record/migration.rb#576
ActiveRecord::Migration::MigrationFilenameRegexp = T.let(T.unsafe(nil), Regexp)

class ActiveRecord::Migration::ReversibleBlockHelper < ::Struct
  # source://activerecord//lib/active_record/migration.rb#757
  def down; end

  # Returns the value of attribute reverting
  #
  # @return [Object] the current value of reverting
  def reverting; end

  # Sets the attribute reverting
  #
  # @param value [Object] the value to set the attribute reverting to.
  # @return [Object] the newly set value
  def reverting=(_); end

  # source://activerecord//lib/active_record/migration.rb#753
  def up; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# MigrationContext sets the context in which a migration is run.
#
# A migration context requires the path to the migrations is set
# in the +migrations_paths+ parameter. Optionally a +schema_migration+
# class can be provided. For most applications, +SchemaMigration+ is
# sufficient. Multiple database applications need a +SchemaMigration+
# per primary database.
class ActiveRecord::MigrationContext
  # @return [MigrationContext] a new instance of MigrationContext
  #
  # source://activerecord//lib/active_record/migration.rb#1071
  def initialize(migrations_paths, schema_migration = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#1190
  def current_environment; end

  # source://activerecord//lib/active_record/migration.rb#1146
  def current_version; end

  # source://activerecord//lib/active_record/migration.rb#1120
  def down(target_version = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/migration.rb#1106
  def forward(steps = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#1138
  def get_all_versions; end

  # @raise [NoEnvironmentInSchemaError]
  #
  # source://activerecord//lib/active_record/migration.rb#1198
  def last_stored_environment; end

  # Runs the migrations in the +migrations_path+.
  #
  # If +target_version+ is +nil+, +migrate+ will run +up+.
  #
  # If the +current_version+ and +target_version+ are both
  # 0 then an empty array will be returned and no migrations
  # will be run.
  #
  # If the +current_version+ in the schema is greater than
  # the +target_version+, then +down+ will be run.
  #
  # If none of the conditions are met, +up+ will be run with
  # the +target_version+.
  #
  # source://activerecord//lib/active_record/migration.rb#1089
  def migrate(target_version = T.unsafe(nil), &block); end

  # source://activerecord//lib/active_record/migration.rb#1159
  def migrations; end

  # Returns the value of attribute migrations_paths.
  #
  # source://activerecord//lib/active_record/migration.rb#1069
  def migrations_paths; end

  # source://activerecord//lib/active_record/migration.rb#1172
  def migrations_status; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1151
  def needs_migration?; end

  # source://activerecord//lib/active_record/migration.rb#1134
  def open; end

  # source://activerecord//lib/active_record/migration.rb#1155
  def pending_migration_versions; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1194
  def protected_environment?; end

  # source://activerecord//lib/active_record/migration.rb#1102
  def rollback(steps = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#1130
  def run(direction, target_version); end

  # Returns the value of attribute schema_migration.
  #
  # source://activerecord//lib/active_record/migration.rb#1069
  def schema_migration; end

  # source://activerecord//lib/active_record/migration.rb#1110
  def up(target_version = T.unsafe(nil), &block); end

  private

  # source://activerecord//lib/active_record/migration.rb#1209
  def migration_files; end

  # source://activerecord//lib/active_record/migration.rb#1218
  def move(direction, steps); end

  # source://activerecord//lib/active_record/migration.rb#1214
  def parse_migration_filename(filename); end
end

class ActiveRecord::MigrationError < ::ActiveRecord::ActiveRecordError
  # @return [MigrationError] a new instance of MigrationError
  #
  # source://activerecord//lib/active_record/migration.rb#13
  def initialize(message = T.unsafe(nil)); end
end

# MigrationProxy is used to defer loading of the actual migration classes
# until they are needed
class ActiveRecord::MigrationProxy < ::Struct
  # @return [MigrationProxy] a new instance of MigrationProxy
  #
  # source://activerecord//lib/active_record/migration.rb#1037
  def initialize(name, version, filename, scope); end

  # source://activerecord//lib/active_record/migration.rb#1046
  def announce(*_arg0, **_arg1, &_arg2); end

  # source://activerecord//lib/active_record/migration.rb#1042
  def basename; end

  # source://activerecord//lib/active_record/migration.rb#1046
  def disable_ddl_transaction(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute filename
  #
  # @return [Object] the current value of filename
  def filename; end

  # Sets the attribute filename
  #
  # @param value [Object] the value to set the attribute filename to.
  # @return [Object] the newly set value
  def filename=(_); end

  # source://activerecord//lib/active_record/migration.rb#1046
  def migrate(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  # Returns the value of attribute scope
  #
  # @return [Object] the current value of scope
  def scope; end

  # Sets the attribute scope
  #
  # @param value [Object] the value to set the attribute scope to.
  # @return [Object] the newly set value
  def scope=(_); end

  # Returns the value of attribute version
  #
  # @return [Object] the current value of version
  def version; end

  # Sets the attribute version
  #
  # @param value [Object] the value to set the attribute version to.
  # @return [Object] the newly set value
  def version=(_); end

  # source://activerecord//lib/active_record/migration.rb#1046
  def write(*_arg0, **_arg1, &_arg2); end

  private

  # source://activerecord//lib/active_record/migration.rb#1053
  def load_migration; end

  # source://activerecord//lib/active_record/migration.rb#1049
  def migration; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::Migrator
  # @return [Migrator] a new instance of Migrator
  #
  # source://activerecord//lib/active_record/migration.rb#1250
  def initialize(direction, migrations, schema_migration, target_version = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/migration.rb#1267
  def current; end

  # source://activerecord//lib/active_record/migration.rb#1267
  def current_migration; end

  # source://activerecord//lib/active_record/migration.rb#1263
  def current_version; end

  # source://activerecord//lib/active_record/migration.rb#1312
  def load_migrated; end

  # source://activerecord//lib/active_record/migration.rb#1280
  def migrate; end

  # source://activerecord//lib/active_record/migration.rb#1308
  def migrated; end

  # source://activerecord//lib/active_record/migration.rb#1299
  def migrations; end

  # source://activerecord//lib/active_record/migration.rb#1303
  def pending_migrations; end

  # source://activerecord//lib/active_record/migration.rb#1272
  def run; end

  # source://activerecord//lib/active_record/migration.rb#1288
  def runnable; end

  private

  # Wrap the migration in a transaction only if supported by the adapter.
  #
  # source://activerecord//lib/active_record/migration.rb#1409
  def ddl_transaction(migration, &block); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1404
  def down?; end

  # source://activerecord//lib/active_record/migration.rb#1353
  def execute_migration_in_transaction(migration); end

  # source://activerecord//lib/active_record/migration.rb#1374
  def finish; end

  # source://activerecord//lib/active_record/migration.rb#1453
  def generate_migrator_advisory_lock_id; end

  # Return true if a valid version is not provided.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1349
  def invalid_target?; end

  # Used for running multiple migrations up to or down to a certain value.
  #
  # source://activerecord//lib/active_record/migration.rb#1328
  def migrate_without_lock; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1344
  def ran?(migration); end

  # Stores the current environment in the database.
  #
  # source://activerecord//lib/active_record/migration.rb#1339
  def record_environment; end

  # source://activerecord//lib/active_record/migration.rb#1390
  def record_version_state_after_migrating(version); end

  # Used for running a specific migration.
  #
  # @raise [UnknownMigrationVersionError]
  #
  # source://activerecord//lib/active_record/migration.rb#1318
  def run_without_lock; end

  # source://activerecord//lib/active_record/migration.rb#1378
  def start; end

  # source://activerecord//lib/active_record/migration.rb#1370
  def target; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1400
  def up?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1421
  def use_advisory_lock?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/migration.rb#1417
  def use_transaction?(migration); end

  # @raise [DuplicateMigrationNameError]
  #
  # source://activerecord//lib/active_record/migration.rb#1382
  def validate(migrations); end

  # source://activerecord//lib/active_record/migration.rb#1425
  def with_advisory_lock; end

  # source://activerecord//lib/active_record/migration.rb#1442
  def with_advisory_lock_connection(&block); end

  class << self
    # For cases where a table doesn't exist like loading from schema cache
    #
    # source://activerecord//lib/active_record/migration.rb#1243
    def current_version; end

    # Returns the value of attribute migrations_paths.
    #
    # source://activerecord//lib/active_record/migration.rb#1240
    def migrations_paths; end

    # Sets the attribute migrations_paths
    #
    # @param value the value to set the attribute migrations_paths to.
    #
    # source://activerecord//lib/active_record/migration.rb#1240
    def migrations_paths=(_arg0); end
  end
end

# source://activerecord//lib/active_record/migration.rb#1452
ActiveRecord::Migrator::MIGRATOR_SALT = T.let(T.unsafe(nil), Integer)

# Raised when a foreign key constraint cannot be added because the column type does not match the referenced column type.
class ActiveRecord::MismatchedForeignKey < ::ActiveRecord::StatementInvalid
  # @return [MismatchedForeignKey] a new instance of MismatchedForeignKey
  #
  # source://activerecord//lib/active_record/errors.rb#184
  def initialize(message: T.unsafe(nil), sql: T.unsafe(nil), binds: T.unsafe(nil), table: T.unsafe(nil), foreign_key: T.unsafe(nil), target_table: T.unsafe(nil), primary_key: T.unsafe(nil), primary_key_column: T.unsafe(nil)); end
end

module ActiveRecord::ModelSchema
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::ModelSchema::ClassMethods

  class << self
    # Derives the join table name for +first_table+ and +second_table+. The
    # table names appear in alphabetical order. A common prefix is removed
    # (useful for namespaced models like Music::Artist and Music::Record):
    #
    #   artists, records => artists_records
    #   records, artists => artists_records
    #   music_artists, music_records => music_artists_records
    #
    # source://activerecord//lib/active_record/model_schema.rb#183
    def derive_join_table_name(first_table, second_table); end
  end

  module GeneratedClassMethods
    def immutable_strings_by_default; end
    def immutable_strings_by_default=(value); end
    def immutable_strings_by_default?; end
    def implicit_order_column; end
    def implicit_order_column=(value); end
    def implicit_order_column?; end
    def inheritance_column; end
    def inheritance_column=(value); end
    def inheritance_column?; end
    def internal_metadata_table_name; end
    def internal_metadata_table_name=(value); end
    def internal_metadata_table_name?; end
    def pluralize_table_names; end
    def pluralize_table_names=(value); end
    def pluralize_table_names?; end
    def primary_key_prefix_type; end
    def primary_key_prefix_type=(value); end
    def primary_key_prefix_type?; end
    def schema_migrations_table_name; end
    def schema_migrations_table_name=(value); end
    def schema_migrations_table_name?; end
    def table_name_prefix; end
    def table_name_prefix=(value); end
    def table_name_prefix?; end
    def table_name_suffix; end
    def table_name_suffix=(value); end
    def table_name_suffix?; end
  end

  module GeneratedInstanceMethods
    def pluralize_table_names; end
    def pluralize_table_names?; end
    def primary_key_prefix_type; end
    def primary_key_prefix_type?; end
    def table_name_prefix; end
    def table_name_prefix?; end
    def table_name_suffix; end
    def table_name_suffix?; end
  end
end

module ActiveRecord::ModelSchema::ClassMethods
  # source://activerecord//lib/active_record/model_schema.rb#486
  def _default_attributes; end

  # source://activerecord//lib/active_record/model_schema.rb#428
  def attribute_types; end

  # source://activerecord//lib/active_record/model_schema.rb#410
  def attributes_builder; end

  # Returns a hash where the keys are column names and the values are
  # default values when instantiating the Active Record object for this table.
  #
  # source://activerecord//lib/active_record/model_schema.rb#481
  def column_defaults; end

  # Returns the column object for the named attribute.
  # Returns an +ActiveRecord::ConnectionAdapters::NullColumn+ if the
  # named attribute does not exist.
  #
  #   class Person < ActiveRecord::Base
  #   end
  #
  #   person = Person.new
  #   person.column_for_attribute(:name) # the result depends on the ConnectionAdapter
  #   # => #<ActiveRecord::ConnectionAdapters::Column:0x007ff4ab083980 @name="name", @sql_type="varchar(255)", @null=true, ...>
  #
  #   person.column_for_attribute(:nothing)
  #   # => #<ActiveRecord::ConnectionAdapters::NullColumn:0xXXX @name=nil, @sql_type=nil, @cast_type=#<Type::Value>, ...>
  #
  # source://activerecord//lib/active_record/model_schema.rb#472
  def column_for_attribute(name); end

  # Returns an array of column names as strings.
  #
  # source://activerecord//lib/active_record/model_schema.rb#492
  def column_names; end

  # source://activerecord//lib/active_record/model_schema.rb#423
  def columns; end

  # source://activerecord//lib/active_record/model_schema.rb#418
  def columns_hash; end

  # Returns an array of column objects where the primary id, all columns ending in "_id" or "_count",
  # and columns used for single table inheritance have been removed.
  #
  # source://activerecord//lib/active_record/model_schema.rb#503
  def content_columns; end

  # source://activerecord//lib/active_record/model_schema.rb#288
  def full_table_name_prefix; end

  # source://activerecord//lib/active_record/model_schema.rb#292
  def full_table_name_suffix; end

  # The list of columns names the model should ignore. Ignored columns won't have attribute
  # accessors defined, and won't be referenced in SQL queries.
  #
  # source://activerecord//lib/active_record/model_schema.rb#317
  def ignored_columns; end

  # Sets the columns names the model should ignore. Ignored columns won't have attribute
  # accessors defined, and won't be referenced in SQL queries.
  #
  # A common usage pattern for this method is to ensure all references to an attribute
  # have been removed and deployed, before a migration to drop the column from the database
  # has been deployed and run. Using this two step approach to dropping columns ensures there
  # is no code that raises errors due to having a cached schema in memory at the time the
  # schema migration is run.
  #
  # For example, given a model where you want to drop the "category" attribute, first mark it
  # as ignored:
  #
  #   class Project < ActiveRecord::Base
  #     # schema:
  #     #   id         :bigint
  #     #   name       :string, limit: 255
  #     #   category   :string, limit: 255
  #
  #     self.ignored_columns = [:category]
  #   end
  #
  # The schema still contains "category", but now the model omits it, so any meta-driven code or
  # schema caching will not attempt to use the column:
  #
  #   Project.columns_hash["category"] => nil
  #
  # You will get an error if accessing that attribute directly, so ensure all usages of the
  # column are removed (automated tests can help you find any usages).
  #
  #   user = Project.create!(name: "First Project")
  #   user.category # => raises NoMethodError
  #
  # source://activerecord//lib/active_record/model_schema.rb#356
  def ignored_columns=(columns); end

  # Returns the next value that will be used as the primary key on
  # an insert statement.
  #
  # source://activerecord//lib/active_record/model_schema.rb#401
  def next_sequence_value; end

  # Determines if the primary key values should be selected from their
  # corresponding sequence before the insert statement.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/model_schema.rb#395
  def prefetch_primary_key?; end

  # The array of names of environments where destructive actions should be prohibited. By default,
  # the value is <tt>["production"]</tt>.
  #
  # source://activerecord//lib/active_record/model_schema.rb#298
  def protected_environments; end

  # Sets an array of names of environments where destructive actions should be prohibited.
  #
  # source://activerecord//lib/active_record/model_schema.rb#307
  def protected_environments=(environments); end

  # Returns a quoted version of the table name, used to construct SQL statements.
  #
  # source://activerecord//lib/active_record/model_schema.rb#273
  def quoted_table_name; end

  # source://activerecord//lib/active_record/model_schema.rb#311
  def real_inheritance_column=(value); end

  # Resets all the cached information about columns, which will cause them
  # to be reloaded on the next request.
  #
  # The most common usage pattern for this method is probably in a migration,
  # when just after creating a table you want to populate it with some default
  # values, e.g.:
  #
  #  class CreateJobLevels < ActiveRecord::Migration[7.0]
  #    def up
  #      create_table :job_levels do |t|
  #        t.integer :id
  #        t.string :name
  #
  #        t.timestamps
  #      end
  #
  #      JobLevel.reset_column_information
  #      %w{assistant executive manager director}.each do |type|
  #        JobLevel.create(name: type)
  #      end
  #    end
  #
  #    def down
  #      drop_table :job_levels
  #    end
  #  end
  #
  # source://activerecord//lib/active_record/model_schema.rb#537
  def reset_column_information; end

  # source://activerecord//lib/active_record/model_schema.rb#369
  def reset_sequence_name; end

  # Computes the table name, (re)sets it internally, and returns it.
  #
  # source://activerecord//lib/active_record/model_schema.rb#278
  def reset_table_name; end

  # source://activerecord//lib/active_record/model_schema.rb#361
  def sequence_name; end

  # Sets the name of the sequence to use when generating ids to the given
  # value, or (if the value is +nil+ or +false+) to the value returned by the
  # given block. This is required for Oracle and is useful for any
  # database which relies on sequences for primary key generation.
  #
  # If a sequence name is not explicitly set when using Oracle,
  # it will default to the commonly used pattern of: #{table_name}_seq
  #
  # If a sequence name is not explicitly set when using PostgreSQL, it
  # will discover the sequence corresponding to your primary key for you.
  #
  #   class Project < ActiveRecord::Base
  #     self.sequence_name = "projectseq"   # default would have been "project_seq"
  #   end
  #
  # source://activerecord//lib/active_record/model_schema.rb#388
  def sequence_name=(value); end

  # source://activerecord//lib/active_record/model_schema.rb#496
  def symbol_column_to_string(name_symbol); end

  # Indicates whether the table associated with this class exists
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/model_schema.rb#406
  def table_exists?; end

  # Guesses the table name (in forced lower-case) based on the name of the class in the
  # inheritance hierarchy descending directly from ActiveRecord::Base. So if the hierarchy
  # looks like: Reply < Message < ActiveRecord::Base, then Message is used
  # to guess the table name even when called on Reply. The rules used to do the guess
  # are handled by the Inflector class in Active Support, which knows almost all common
  # English inflections. You can add new inflections in config/initializers/inflections.rb.
  #
  # Nested classes are given table names prefixed by the singular form of
  # the parent's table name. Enclosing modules are not considered.
  #
  # ==== Examples
  #
  #   class Invoice < ActiveRecord::Base
  #   end
  #
  #   file                  class               table_name
  #   invoice.rb            Invoice             invoices
  #
  #   class Invoice < ActiveRecord::Base
  #     class Lineitem < ActiveRecord::Base
  #     end
  #   end
  #
  #   file                  class               table_name
  #   invoice.rb            Invoice::Lineitem   invoice_lineitems
  #
  #   module Invoice
  #     class Lineitem < ActiveRecord::Base
  #     end
  #   end
  #
  #   file                  class               table_name
  #   invoice/lineitem.rb   Invoice::Lineitem   lineitems
  #
  # Additionally, the class-level +table_name_prefix+ is prepended and the
  # +table_name_suffix+ is appended. So if you have "myapp_" as a prefix,
  # the table name guess for an Invoice class becomes "myapp_invoices".
  # Invoice::Lineitem becomes "myapp_invoice_lineitems".
  #
  # Active Model Naming's +model_name+ is the base name used to guess the
  # table name. In case a custom Active Model Name is defined, it will be
  # used for the table name as well:
  #
  #   class PostRecord < ActiveRecord::Base
  #     class << self
  #       def model_name
  #         ActiveModel::Name.new(self, nil, "Post")
  #       end
  #     end
  #   end
  #
  #   PostRecord.table_name
  #   # => "posts"
  #
  # You can also set your own table name explicitly:
  #
  #   class Mouse < ActiveRecord::Base
  #     self.table_name = "mice"
  #   end
  #
  # source://activerecord//lib/active_record/model_schema.rb#247
  def table_name; end

  # Sets the table name explicitly. Example:
  #
  #   class Project < ActiveRecord::Base
  #     self.table_name = "project"
  #   end
  #
  # source://activerecord//lib/active_record/model_schema.rb#257
  def table_name=(value); end

  # Returns the type of the attribute with the given name, after applying
  # all modifiers. This method is the only valid source of information for
  # anything related to the types of a model's attributes. This method will
  # access the database and load the model's schema if it is required.
  #
  # The return value of this method will implement the interface described
  # by ActiveModel::Type::Value (though the object itself may not subclass
  # it).
  #
  # +attr_name+ The name of the attribute to retrieve the type for. Must be
  # a string or a symbol.
  #
  # source://activerecord//lib/active_record/model_schema.rb#448
  def type_for_attribute(attr_name, &block); end

  # source://activerecord//lib/active_record/model_schema.rb#433
  def yaml_encoder; end

  protected

  # source://activerecord//lib/active_record/model_schema.rb#547
  def initialize_load_schema_monitor; end

  private

  # source://activerecord//lib/active_record/model_schema.rb#637
  def _convert_type_from_options(type); end

  # Computes and returns a table name according to default conventions.
  #
  # source://activerecord//lib/active_record/model_schema.rb#621
  def compute_table_name; end

  # source://activerecord//lib/active_record/model_schema.rb#552
  def inherited(child_class); end

  # source://activerecord//lib/active_record/model_schema.rb#561
  def load_schema; end

  # source://activerecord//lib/active_record/model_schema.rb#575
  def load_schema!; end

  # source://activerecord//lib/active_record/model_schema.rb#595
  def reload_schema_from_cache; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/model_schema.rb#557
  def schema_loaded?; end

  # Guesses the table name, but does not decorate it with prefix and suffix information.
  #
  # source://activerecord//lib/active_record/model_schema.rb#615
  def undecorated_table_name(model_name); end
end

# Raised when there are multiple errors while doing a mass assignment through the
# {ActiveRecord::Base#attributes=}[rdoc-ref:AttributeAssignment#attributes=]
# method. The exception has an +errors+ property that contains an array of AttributeAssignmentError
# objects, each corresponding to the error while assigning to an attribute.
class ActiveRecord::MultiparameterAssignmentErrors < ::ActiveRecord::ActiveRecordError
  # @return [MultiparameterAssignmentErrors] a new instance of MultiparameterAssignmentErrors
  #
  # source://activerecord//lib/active_record/errors.rb#369
  def initialize(errors = T.unsafe(nil)); end

  # Returns the value of attribute errors.
  #
  # source://activerecord//lib/active_record/errors.rb#367
  def errors; end
end

module ActiveRecord::NestedAttributes
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveRecord::NestedAttributes::ClassMethods

  # Returns ActiveRecord::AutosaveAssociation::marked_for_destruction? It's
  # used in conjunction with fields_for to build a form element for the
  # destruction of this association.
  #
  # See ActionView::Helpers::FormHelper::fields_for for more info.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#383
  def _destroy; end

  private

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#588
  def allow_destroy?(association_name); end

  # Assigns the given attributes to the collection association.
  #
  # Hashes with an <tt>:id</tt> value matching an existing associated record
  # will update that record. Hashes without an <tt>:id</tt> value will build
  # a new record for the association. Hashes with a matching <tt>:id</tt>
  # value and a <tt>:_destroy</tt> key set to a truthy value will mark the
  # matched record for destruction.
  #
  # For example:
  #
  #   assign_nested_attributes_for_collection_association(:people, {
  #     '1' => { id: '1', name: 'Peter' },
  #     '2' => { name: 'John' },
  #     '3' => { id: '2', _destroy: true }
  #   })
  #
  # Will update the name of the Person with ID 1, build a new associated
  # person with the name 'John', and mark the associated Person with ID 2
  # for destruction.
  #
  # Also accepts an Array of attribute hashes:
  #
  #   assign_nested_attributes_for_collection_association(:people, [
  #     { id: '1', name: 'Peter' },
  #     { name: 'John' },
  #     { id: '2', _destroy: true }
  #   ])
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#464
  def assign_nested_attributes_for_collection_association(association_name, attributes_collection); end

  # Assigns the given attributes to the association.
  #
  # If an associated record does not yet exist, one will be instantiated. If
  # an associated record already exists, the method's behavior depends on
  # the value of the update_only option. If update_only is +false+ and the
  # given attributes include an <tt>:id</tt> that matches the existing record's
  # id, then the existing record will be modified. If no <tt>:id</tt> is provided
  # it will be replaced with a new record. If update_only is +true+ the existing
  # record will be modified regardless of whether an <tt>:id</tt> is provided.
  #
  # If the given attributes include a matching <tt>:id</tt> attribute, or
  # update_only is true, and a <tt>:_destroy</tt> key set to a truthy value,
  # then the existing record will be marked for destruction.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#405
  def assign_nested_attributes_for_one_to_one_association(association_name, attributes); end

  # Updates a record with the +attributes+ or marks it for destruction if
  # +allow_destroy+ is +true+ and has_destroy_flag? returns +true+.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#550
  def assign_to_or_mark_for_destruction(record, attributes, allow_destroy); end

  # Determines if a record with the particular +attributes+ should be
  # rejected by calling the reject_if Symbol or Proc (if defined).
  # The reject_if option is defined by +accepts_nested_attributes_for+.
  #
  # Returns false if there is a +destroy_flag+ on the attributes.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#572
  def call_reject_if(association_name, attributes); end

  # Takes in a limit and checks if the attributes_collection has too many
  # records. It accepts limit in the form of symbol, proc, or
  # number-like object (anything that can be compared with an integer).
  #
  # Raises TooManyRecords error if the attributes_collection is
  # larger than the limit.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#530
  def check_record_limit!(limit, attributes_collection); end

  # Determines if a hash contains a truthy _destroy key.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#556
  def has_destroy_flag?(hash); end

  # @raise [RecordNotFound]
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#592
  def raise_nested_attributes_record_not_found!(association_name, record_id); end

  # Determines if a new record should be rejected by checking
  # has_destroy_flag? or if a <tt>:reject_if</tt> proc exists for this
  # association and evaluates to +true+.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#563
  def reject_new_record?(association_name, attributes); end

  # Only take into account the destroy flag if <tt>:allow_destroy</tt> is true
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#584
  def will_be_destroyed?(association_name, attributes); end

  module GeneratedClassMethods
    def nested_attributes_options; end
    def nested_attributes_options=(value); end
    def nested_attributes_options?; end
  end

  module GeneratedInstanceMethods
    def nested_attributes_options; end
    def nested_attributes_options?; end
  end
end

# = Active Record Nested Attributes
#
# Nested attributes allow you to save attributes on associated records
# through the parent. By default nested attribute updating is turned off
# and you can enable it using the accepts_nested_attributes_for class
# method. When you enable nested attributes an attribute writer is
# defined on the model.
#
# The attribute writer is named after the association, which means that
# in the following example, two new methods are added to your model:
#
# <tt>author_attributes=(attributes)</tt> and
# <tt>pages_attributes=(attributes)</tt>.
#
#   class Book < ActiveRecord::Base
#     has_one :author
#     has_many :pages
#
#     accepts_nested_attributes_for :author, :pages
#   end
#
# Note that the <tt>:autosave</tt> option is automatically enabled on every
# association that accepts_nested_attributes_for is used for.
#
# === One-to-one
#
# Consider a Member model that has one Avatar:
#
#   class Member < ActiveRecord::Base
#     has_one :avatar
#     accepts_nested_attributes_for :avatar
#   end
#
# Enabling nested attributes on a one-to-one association allows you to
# create the member and avatar in one go:
#
#   params = { member: { name: 'Jack', avatar_attributes: { icon: 'smiling' } } }
#   member = Member.create(params[:member])
#   member.avatar.id # => 2
#   member.avatar.icon # => 'smiling'
#
# It also allows you to update the avatar through the member:
#
#   params = { member: { avatar_attributes: { id: '2', icon: 'sad' } } }
#   member.update params[:member]
#   member.avatar.icon # => 'sad'
#
# If you want to update the current avatar without providing the id, you must add <tt>:update_only</tt> option.
#
#   class Member < ActiveRecord::Base
#     has_one :avatar
#     accepts_nested_attributes_for :avatar, update_only: true
#   end
#
#   params = { member: { avatar_attributes: { icon: 'sad' } } }
#   member.update params[:member]
#   member.avatar.id # => 2
#   member.avatar.icon # => 'sad'
#
# By default you will only be able to set and update attributes on the
# associated model. If you want to destroy the associated model through the
# attributes hash, you have to enable it first using the
# <tt>:allow_destroy</tt> option.
#
#   class Member < ActiveRecord::Base
#     has_one :avatar
#     accepts_nested_attributes_for :avatar, allow_destroy: true
#   end
#
# Now, when you add the <tt>_destroy</tt> key to the attributes hash, with a
# value that evaluates to +true+, you will destroy the associated model:
#
#   member.avatar_attributes = { id: '2', _destroy: '1' }
#   member.avatar.marked_for_destruction? # => true
#   member.save
#   member.reload.avatar # => nil
#
# Note that the model will _not_ be destroyed until the parent is saved.
#
# Also note that the model will not be destroyed unless you also specify
# its id in the updated hash.
#
# === One-to-many
#
# Consider a member that has a number of posts:
#
#   class Member < ActiveRecord::Base
#     has_many :posts
#     accepts_nested_attributes_for :posts
#   end
#
# You can now set or update attributes on the associated posts through
# an attribute hash for a member: include the key +:posts_attributes+
# with an array of hashes of post attributes as a value.
#
# For each hash that does _not_ have an <tt>id</tt> key a new record will
# be instantiated, unless the hash also contains a <tt>_destroy</tt> key
# that evaluates to +true+.
#
#   params = { member: {
#     name: 'joe', posts_attributes: [
#       { title: 'Kari, the awesome Ruby documentation browser!' },
#       { title: 'The egalitarian assumption of the modern citizen' },
#       { title: '', _destroy: '1' } # this will be ignored
#     ]
#   }}
#
#   member = Member.create(params[:member])
#   member.posts.length # => 2
#   member.posts.first.title # => 'Kari, the awesome Ruby documentation browser!'
#   member.posts.second.title # => 'The egalitarian assumption of the modern citizen'
#
# You may also set a +:reject_if+ proc to silently ignore any new record
# hashes if they fail to pass your criteria. For example, the previous
# example could be rewritten as:
#
#   class Member < ActiveRecord::Base
#     has_many :posts
#     accepts_nested_attributes_for :posts, reject_if: proc { |attributes| attributes['title'].blank? }
#   end
#
#   params = { member: {
#     name: 'joe', posts_attributes: [
#       { title: 'Kari, the awesome Ruby documentation browser!' },
#       { title: 'The egalitarian assumption of the modern citizen' },
#       { title: '' } # this will be ignored because of the :reject_if proc
#     ]
#   }}
#
#   member = Member.create(params[:member])
#   member.posts.length # => 2
#   member.posts.first.title # => 'Kari, the awesome Ruby documentation browser!'
#   member.posts.second.title # => 'The egalitarian assumption of the modern citizen'
#
# Alternatively, +:reject_if+ also accepts a symbol for using methods:
#
#   class Member < ActiveRecord::Base
#     has_many :posts
#     accepts_nested_attributes_for :posts, reject_if: :new_record?
#   end
#
#   class Member < ActiveRecord::Base
#     has_many :posts
#     accepts_nested_attributes_for :posts, reject_if: :reject_posts
#
#     def reject_posts(attributes)
#       attributes['title'].blank?
#     end
#   end
#
# If the hash contains an <tt>id</tt> key that matches an already
# associated record, the matching record will be modified:
#
#   member.attributes = {
#     name: 'Joe',
#     posts_attributes: [
#       { id: 1, title: '[UPDATED] An, as of yet, undisclosed awesome Ruby documentation browser!' },
#       { id: 2, title: '[UPDATED] other post' }
#     ]
#   }
#
#   member.posts.first.title # => '[UPDATED] An, as of yet, undisclosed awesome Ruby documentation browser!'
#   member.posts.second.title # => '[UPDATED] other post'
#
# However, the above applies if the parent model is being updated as well.
# For example, if you wanted to create a +member+ named _joe_ and wanted to
# update the +posts+ at the same time, that would give an
# ActiveRecord::RecordNotFound error.
#
# By default the associated records are protected from being destroyed. If
# you want to destroy any of the associated records through the attributes
# hash, you have to enable it first using the <tt>:allow_destroy</tt>
# option. This will allow you to also use the <tt>_destroy</tt> key to
# destroy existing records:
#
#   class Member < ActiveRecord::Base
#     has_many :posts
#     accepts_nested_attributes_for :posts, allow_destroy: true
#   end
#
#   params = { member: {
#     posts_attributes: [{ id: '2', _destroy: '1' }]
#   }}
#
#   member.attributes = params[:member]
#   member.posts.detect { |p| p.id == 2 }.marked_for_destruction? # => true
#   member.posts.length # => 2
#   member.save
#   member.reload.posts.length # => 1
#
# Nested attributes for an associated collection can also be passed in
# the form of a hash of hashes instead of an array of hashes:
#
#   Member.create(
#     name: 'joe',
#     posts_attributes: {
#       first:  { title: 'Foo' },
#       second: { title: 'Bar' }
#     }
#   )
#
# has the same effect as
#
#   Member.create(
#     name: 'joe',
#     posts_attributes: [
#       { title: 'Foo' },
#       { title: 'Bar' }
#     ]
#   )
#
# The keys of the hash which is the value for +:posts_attributes+ are
# ignored in this case.
# However, it is not allowed to use <tt>'id'</tt> or <tt>:id</tt> for one of
# such keys, otherwise the hash will be wrapped in an array and
# interpreted as an attribute hash for a single post.
#
# Passing attributes for an associated collection in the form of a hash
# of hashes can be used with hashes generated from HTTP/HTML parameters,
# where there may be no natural way to submit an array of hashes.
#
# === Saving
#
# All changes to models, including the destruction of those marked for
# destruction, are saved and destroyed automatically and atomically when
# the parent model is saved. This happens inside the transaction initiated
# by the parent's save method. See ActiveRecord::AutosaveAssociation.
#
# === Validating the presence of a parent model
#
# The +belongs_to+ association validates the presence of the parent model
# by default. You can disable this behavior by specifying <code>optional: true</code>.
# This can be used, for example, when conditionally validating the presence
# of the parent model:
#
#   class Veterinarian < ActiveRecord::Base
#     has_many :patients, inverse_of: :veterinarian
#     accepts_nested_attributes_for :patients
#   end
#
#   class Patient < ActiveRecord::Base
#     belongs_to :veterinarian, inverse_of: :patients, optional: true
#     validates :veterinarian, presence: true, unless: -> { awaiting_intake }
#   end
#
# Note that if you do not specify the +:inverse_of+ option, then
# Active Record will try to automatically guess the inverse association
# based on heuristics.
#
# For one-to-one nested associations, if you build the new (in-memory)
# child object yourself before assignment, then this module will not
# overwrite it, e.g.:
#
#   class Member < ActiveRecord::Base
#     has_one :avatar
#     accepts_nested_attributes_for :avatar
#
#     def avatar
#       super || build_avatar(width: 200)
#     end
#   end
#
#   member = Member.new
#   member.avatar_attributes = {icon: 'sad'}
#   member.avatar.width # => 200
module ActiveRecord::NestedAttributes::ClassMethods
  # Defines an attributes writer for the specified association(s).
  #
  # Supported options:
  # [:allow_destroy]
  #   If true, destroys any members from the attributes hash with a
  #   <tt>_destroy</tt> key and a value that evaluates to +true+
  #   (e.g. 1, '1', true, or 'true'). This option is off by default.
  # [:reject_if]
  #   Allows you to specify a Proc or a Symbol pointing to a method
  #   that checks whether a record should be built for a certain attribute
  #   hash. The hash is passed to the supplied Proc or the method
  #   and it should return either +true+ or +false+. When no +:reject_if+
  #   is specified, a record will be built for all attribute hashes that
  #   do not have a <tt>_destroy</tt> value that evaluates to true.
  #   Passing <tt>:all_blank</tt> instead of a Proc will create a proc
  #   that will reject a record where all the attributes are blank excluding
  #   any value for +_destroy+.
  # [:limit]
  #   Allows you to specify the maximum number of associated records that
  #   can be processed with the nested attributes. Limit also can be specified
  #   as a Proc or a Symbol pointing to a method that should return a number.
  #   If the size of the nested attributes array exceeds the specified limit,
  #   NestedAttributes::TooManyRecords exception is raised. If omitted, any
  #   number of associations can be processed.
  #   Note that the +:limit+ option is only applicable to one-to-many
  #   associations.
  # [:update_only]
  #   For a one-to-one association, this option allows you to specify how
  #   nested attributes are going to be used when an associated record already
  #   exists. In general, an existing record may either be updated with the
  #   new set of attribute values or be replaced by a wholly new record
  #   containing those values. By default the +:update_only+ option is +false+
  #   and the nested attributes are used to update the existing record only
  #   if they include the record's <tt>:id</tt> value. Otherwise a new
  #   record will be instantiated and used to replace the existing one.
  #   However if the +:update_only+ option is +true+, the nested attributes
  #   are used to update the record's attributes always, regardless of
  #   whether the <tt>:id</tt> is present. The option is ignored for collection
  #   associations.
  #
  # Examples:
  #   # creates avatar_attributes=
  #   accepts_nested_attributes_for :avatar, reject_if: proc { |attributes| attributes['name'].blank? }
  #   # creates avatar_attributes=
  #   accepts_nested_attributes_for :avatar, reject_if: :all_blank
  #   # creates avatar_attributes= and posts_attributes=
  #   accepts_nested_attributes_for :avatar, :posts, allow_destroy: true
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#333
  def accepts_nested_attributes_for(*attr_names); end

  private

  # Generates a writer method for this association. Serves as a point for
  # accessing the objects in the association. For example, this method
  # could generate the following:
  #
  #   def pirate_attributes=(attributes)
  #     assign_nested_attributes_for_one_to_one_association(:pirate, attributes)
  #   end
  #
  # This redirects the attempts to write objects in an association through
  # the helper methods defined below. Makes it seem like the nested
  # associations are just regular associations.
  #
  # source://activerecord//lib/active_record/nested_attributes.rb#368
  def generate_association_writer(association_name, type); end
end

# source://activerecord//lib/active_record/nested_attributes.rb#284
ActiveRecord::NestedAttributes::ClassMethods::REJECT_ALL_BLANK_PROC = T.let(T.unsafe(nil), Proc)

class ActiveRecord::NestedAttributes::TooManyRecords < ::ActiveRecord::ActiveRecordError; end

# Attribute hash keys that should not be assigned as normal attributes.
# These hash keys are nested attributes implementation details.
#
# source://activerecord//lib/active_record/nested_attributes.rb#390
ActiveRecord::NestedAttributes::UNASSIGNABLE_KEYS = T.let(T.unsafe(nil), Array)

# Raised when a given database does not exist.
class ActiveRecord::NoDatabaseError < ::ActiveRecord::StatementInvalid
  include ::ActiveSupport::ActionableError
  extend ::ActiveSupport::ActionableError::ClassMethods

  # @return [NoDatabaseError] a new instance of NoDatabaseError
  #
  # source://activerecord//lib/active_record/errors.rb#245
  def initialize(message = T.unsafe(nil)); end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions; end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions=(_arg0); end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions?; end

  class << self
    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions; end

    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions=(value); end

    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions?; end

    # source://activerecord//lib/active_record/errors.rb#250
    def db_error(db_name); end
  end
end

class ActiveRecord::NoEnvironmentInSchemaError < ::ActiveRecord::MigrationError
  # @return [NoEnvironmentInSchemaError] a new instance of NoEnvironmentInSchemaError
  #
  # source://activerecord//lib/active_record/migration.rb#178
  def initialize; end
end

# = Active Record No Touching
module ActiveRecord::NoTouching
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::NoTouching::ClassMethods

  # Returns +true+ if the class has +no_touching+ set, +false+ otherwise.
  #
  #   Project.no_touching do
  #     Project.first.no_touching? # true
  #     Message.first.no_touching? # false
  #   end
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/no_touching.rb#53
  def no_touching?; end

  # source://activerecord//lib/active_record/no_touching.rb#61
  def touch(*_arg0, **_arg1); end

  # source://activerecord//lib/active_record/no_touching.rb#57
  def touch_later(*_arg0); end

  class << self
    # @return [Boolean]
    #
    # source://activerecord//lib/active_record/no_touching.rb#36
    def applied_to?(klass); end

    # source://activerecord//lib/active_record/no_touching.rb#29
    def apply_to(klass); end

    private

    # source://activerecord//lib/active_record/no_touching.rb#41
    def klasses; end
  end
end

module ActiveRecord::NoTouching::ClassMethods
  # Lets you selectively disable calls to +touch+ for the
  # duration of a block.
  #
  # ==== Examples
  #   ActiveRecord::Base.no_touching do
  #     Project.first.touch  # does nothing
  #     Message.first.touch  # does nothing
  #   end
  #
  #   Project.no_touching do
  #     Project.first.touch  # does nothing
  #     Message.first.touch  # works, but does not touch the associated project
  #   end
  #
  # source://activerecord//lib/active_record/no_touching.rb#23
  def no_touching(&block); end
end

# Raised when a record cannot be inserted or updated because it would violate a not null constraint.
class ActiveRecord::NotNullViolation < ::ActiveRecord::StatementInvalid; end

module ActiveRecord::NullRelation
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#29
  def any?; end

  # source://activerecord//lib/active_record/null_relation.rb#41
  def calculate(operation, _column_name); end

  # source://activerecord//lib/active_record/null_relation.rb#17
  def delete(_id_or_array); end

  # source://activerecord//lib/active_record/null_relation.rb#9
  def delete_all; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#21
  def empty?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#50
  def exists?(_conditions = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#37
  def many?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#25
  def none?; end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/null_relation.rb#33
  def one?; end

  # source://activerecord//lib/active_record/null_relation.rb#54
  def or(other); end

  # source://activerecord//lib/active_record/null_relation.rb#5
  def pluck(*column_names); end

  # source://activerecord//lib/active_record/null_relation.rb#13
  def update_all(_updates); end

  private

  # source://activerecord//lib/active_record/null_relation.rb#59
  def exec_main_query(async: T.unsafe(nil)); end
end

class ActiveRecord::PendingMigrationError < ::ActiveRecord::MigrationError
  include ::ActiveSupport::ActionableError
  extend ::ActiveSupport::ActionableError::ClassMethods

  # @return [PendingMigrationError] a new instance of PendingMigrationError
  #
  # source://activerecord//lib/active_record/migration.rb#146
  def initialize(message = T.unsafe(nil)); end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions; end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions=(_arg0); end

  # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
  def _actions?; end

  private

  # source://activerecord//lib/active_record/migration.rb#151
  def detailed_migration_message; end

  class << self
    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions; end

    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions=(value); end

    # source://activesupport/7.0.4/lib/active_support/actionable_error.rb#15
    def _actions?; end
  end
end

# = Active Record \Persistence
module ActiveRecord::Persistence
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveRecord::Persistence::ClassMethods

  # Returns an instance of the specified +klass+ with the attributes of the
  # current record. This is mostly useful in relation to single table
  # inheritance (STI) structures where you want a subclass to appear as the
  # superclass. This can be used along with record identification in
  # Action Pack to allow, say, <tt>Client < Company</tt> to do something
  # like render <tt>partial: @client.becomes(Company)</tt> to render that
  # instance using the companies/company partial instead of clients/client.
  #
  # Note: The new instance will share a link to the same attributes as the original class.
  # Therefore the STI column value will still be the same.
  # Any change to the attributes on either instance will affect both instances.
  # If you want to change the STI column as well, use #becomes! instead.
  #
  # source://activerecord//lib/active_record/persistence.rb#711
  def becomes(klass); end

  # Wrapper around #becomes that also changes the instance's STI column value.
  # This is especially useful if you want to persist the changed class in your
  # database.
  #
  # Note: The old instance's STI column value will be changed too, as both objects
  # share the same set of attributes.
  #
  # source://activerecord//lib/active_record/persistence.rb#731
  def becomes!(klass); end

  # Initializes +attribute+ to zero if +nil+ and subtracts the value passed as +by+ (default is 1).
  # The decrement is performed directly on the underlying attribute, no setter is invoked.
  # Only makes sense for number-based attributes. Returns +self+.
  #
  # source://activerecord//lib/active_record/persistence.rb#856
  def decrement(attribute, by = T.unsafe(nil)); end

  # Wrapper around #decrement that writes the update to the database.
  # Only +attribute+ is updated; the record itself is not saved.
  # This means that any other modified attributes will still be dirty.
  # Validations and callbacks are skipped. Supports the +touch+ option from
  # +update_counters+, see that for more.
  # Returns +self+.
  #
  # source://activerecord//lib/active_record/persistence.rb#866
  def decrement!(attribute, by = T.unsafe(nil), touch: T.unsafe(nil)); end

  # Deletes the record in the database and freezes this instance to
  # reflect that no changes should be made (since they can't be
  # persisted). Returns the frozen instance.
  #
  # The row is simply removed with an SQL +DELETE+ statement on the
  # record's primary key, and no callbacks are executed.
  #
  # Note that this will also delete records marked as {#readonly?}[rdoc-ref:Core#readonly?].
  #
  # To enforce the object's +before_destroy+ and +after_destroy+
  # callbacks or any <tt>:dependent</tt> association
  # options, use #destroy.
  #
  # source://activerecord//lib/active_record/persistence.rb#663
  def delete; end

  # Deletes the record in the database and freezes this instance to reflect
  # that no changes should be made (since they can't be persisted).
  #
  # There's a series of callbacks associated with #destroy. If the
  # <tt>before_destroy</tt> callback throws +:abort+ the action is cancelled
  # and #destroy returns +false+.
  # See ActiveRecord::Callbacks for further details.
  #
  # source://activerecord//lib/active_record/persistence.rb#676
  def destroy; end

  # Deletes the record in the database and freezes this instance to reflect
  # that no changes should be made (since they can't be persisted).
  #
  # There's a series of callbacks associated with #destroy!. If the
  # <tt>before_destroy</tt> callback throws +:abort+ the action is cancelled
  # and #destroy! raises ActiveRecord::RecordNotDestroyed.
  # See ActiveRecord::Callbacks for further details.
  #
  # source://activerecord//lib/active_record/persistence.rb#695
  def destroy!; end

  # Returns true if this object has been destroyed, otherwise returns false.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#579
  def destroyed?; end

  # Initializes +attribute+ to zero if +nil+ and adds the value passed as +by+ (default is 1).
  # The increment is performed directly on the underlying attribute, no setter is invoked.
  # Only makes sense for number-based attributes. Returns +self+.
  #
  # source://activerecord//lib/active_record/persistence.rb#833
  def increment(attribute, by = T.unsafe(nil)); end

  # Wrapper around #increment that writes the update to the database.
  # Only +attribute+ is updated; the record itself is not saved.
  # This means that any other modified attributes will still be dirty.
  # Validations and callbacks are skipped. Supports the +touch+ option from
  # +update_counters+, see that for more.
  # Returns +self+.
  #
  # source://activerecord//lib/active_record/persistence.rb#845
  def increment!(attribute, by = T.unsafe(nil), touch: T.unsafe(nil)); end

  # Returns true if this object hasn't been saved yet -- that is, a record
  # for the object doesn't exist in the database yet; otherwise, returns false.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#562
  def new_record?; end

  # Returns true if the record is persisted, i.e. it's not a new record and it was
  # not destroyed, otherwise returns false.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#585
  def persisted?; end

  # Returns true if this object was just created -- that is, prior to the last
  # save, the object didn't exist in the database and new_record? would have
  # returned true.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#569
  def previously_new_record?; end

  # Returns true if this object was previously persisted but now it has been deleted.
  #
  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#574
  def previously_persisted?; end

  # Reloads the record from the database.
  #
  # This method finds the record by its primary key (which could be assigned
  # manually) and modifies the receiver in-place:
  #
  #   account = Account.new
  #   # => #<Account id: nil, email: nil>
  #   account.id = 1
  #   account.reload
  #   # Account Load (1.2ms)  SELECT "accounts".* FROM "accounts" WHERE "accounts"."id" = $1 LIMIT 1  [["id", 1]]
  #   # => #<Account id: 1, email: 'account@example.com'>
  #
  # Attributes are reloaded from the database, and caches busted, in
  # particular the associations cache and the QueryCache.
  #
  # If the record no longer exists in the database ActiveRecord::RecordNotFound
  # is raised. Otherwise, in addition to the in-place modification the method
  # returns +self+ for convenience.
  #
  # The optional <tt>:lock</tt> flag option allows you to lock the reloaded record:
  #
  #   reload(lock: true) # reload with pessimistic locking
  #
  # Reloading is commonly used in test suites to test something is actually
  # written to the database, or when some action modifies the corresponding
  # row in the database but not the object in memory:
  #
  #   assert account.deposit!(25)
  #   assert_equal 25, account.credit        # check it is updated in memory
  #   assert_equal 25, account.reload.credit # check it is also persisted
  #
  # Another common use case is optimistic locking handling:
  #
  #   def with_optimistic_retry
  #     begin
  #       yield
  #     rescue ActiveRecord::StaleObjectError
  #       begin
  #         # Reload lock_version in particular.
  #         reload
  #       rescue ActiveRecord::RecordNotFound
  #         # If the record is gone there is nothing to do.
  #       else
  #         retry
  #       end
  #     end
  #   end
  #
  # source://activerecord//lib/active_record/persistence.rb#943
  def reload(options = T.unsafe(nil)); end

  # :call-seq:
  #   save(**options)
  #
  # Saves the model.
  #
  # If the model is new, a record gets created in the database, otherwise
  # the existing record gets updated.
  #
  # By default, save always runs validations. If any of them fail the action
  # is cancelled and #save returns +false+, and the record won't be saved. However, if you supply
  # <tt>validate: false</tt>, validations are bypassed altogether. See
  # ActiveRecord::Validations for more information.
  #
  # By default, #save also sets the +updated_at+/+updated_on+ attributes to
  # the current time. However, if you supply <tt>touch: false</tt>, these
  # timestamps will not be updated.
  #
  # There's a series of callbacks associated with #save. If any of the
  # <tt>before_*</tt> callbacks throws +:abort+ the action is cancelled and
  # #save returns +false+. See ActiveRecord::Callbacks for further
  # details.
  #
  # Attributes marked as readonly are silently ignored if the record is
  # being updated.
  #
  # source://activerecord//lib/active_record/persistence.rb#614
  def save(**options, &block); end

  # :call-seq:
  #   save!(**options)
  #
  # Saves the model.
  #
  # If the model is new, a record gets created in the database, otherwise
  # the existing record gets updated.
  #
  # By default, #save! always runs validations. If any of them fail
  # ActiveRecord::RecordInvalid gets raised, and the record won't be saved. However, if you supply
  # <tt>validate: false</tt>, validations are bypassed altogether. See
  # ActiveRecord::Validations for more information.
  #
  # By default, #save! also sets the +updated_at+/+updated_on+ attributes to
  # the current time. However, if you supply <tt>touch: false</tt>, these
  # timestamps will not be updated.
  #
  # There's a series of callbacks associated with #save!. If any of
  # the <tt>before_*</tt> callbacks throws +:abort+ the action is cancelled
  # and #save! raises ActiveRecord::RecordNotSaved. See
  # ActiveRecord::Callbacks for further details.
  #
  # Attributes marked as readonly are silently ignored if the record is
  # being updated.
  #
  # Unless an error is raised, returns true.
  #
  # source://activerecord//lib/active_record/persistence.rb#647
  def save!(**options, &block); end

  # Assigns to +attribute+ the boolean opposite of <tt>attribute?</tt>. So
  # if the predicate returns +true+ the attribute will become +false+. This
  # method toggles directly the underlying value without calling any setter.
  # Returns +self+.
  #
  # Example:
  #
  #   user = User.first
  #   user.banned? # => false
  #   user.toggle(:banned)
  #   user.banned? # => true
  #
  # source://activerecord//lib/active_record/persistence.rb#882
  def toggle(attribute); end

  # Wrapper around #toggle that saves the record. This method differs from
  # its non-bang version in the sense that it passes through the attribute setter.
  # Saving is not subjected to validation checks. Returns +true+ if the
  # record could be saved.
  #
  # source://activerecord//lib/active_record/persistence.rb#891
  def toggle!(attribute); end

  # Saves the record with the updated_at/on attributes set to the current time
  # or the time specified.
  # Please note that no validation is performed and only the +after_touch+,
  # +after_commit+ and +after_rollback+ callbacks are executed.
  #
  # This method can be passed attribute names and an optional time argument.
  # If attribute names are passed, they are updated along with updated_at/on
  # attributes. If no time argument is passed, the current time is used as default.
  #
  #   product.touch                         # updates updated_at/on with current time
  #   product.touch(time: Time.new(2015, 2, 16, 0, 0, 0)) # updates updated_at/on with specified time
  #   product.touch(:designed_at)           # updates the designed_at attribute and updated_at/on
  #   product.touch(:started_at, :ended_at) # updates started_at, ended_at and updated_at/on attributes
  #
  # If used along with {belongs_to}[rdoc-ref:Associations::ClassMethods#belongs_to]
  # then +touch+ will invoke +touch+ method on associated object.
  #
  #   class Brake < ActiveRecord::Base
  #     belongs_to :car, touch: true
  #   end
  #
  #   class Car < ActiveRecord::Base
  #     belongs_to :corporation, touch: true
  #   end
  #
  #   # triggers @brake.car.touch and @brake.car.corporation.touch
  #   @brake.touch
  #
  # Note that +touch+ must be used on a persisted object, or else an
  # ActiveRecordError will be thrown. For example:
  #
  #   ball = Ball.new
  #   ball.touch(:updated_at)   # => raises ActiveRecordError
  #
  # source://activerecord//lib/active_record/persistence.rb#993
  def touch(*names, time: T.unsafe(nil)); end

  # Updates the attributes of the model from the passed-in hash and saves the
  # record, all wrapped in a transaction. If the object is invalid, the saving
  # will fail and false will be returned.
  #
  # source://activerecord//lib/active_record/persistence.rb#764
  def update(attributes); end

  # Updates its receiver just like #update but calls #save! instead
  # of +save+, so an exception is raised if the record is invalid and saving will fail.
  #
  # source://activerecord//lib/active_record/persistence.rb#775
  def update!(attributes); end

  # Updates a single attribute and saves the record.
  # This is especially useful for boolean flags on existing records. Also note that
  #
  # * Validation is skipped.
  # * \Callbacks are invoked.
  # * updated_at/updated_on column is updated if that column is available.
  # * Updates all the attributes that are dirty in this object.
  #
  # This method raises an ActiveRecord::ActiveRecordError  if the
  # attribute is marked as readonly.
  #
  # Also see #update_column.
  #
  # source://activerecord//lib/active_record/persistence.rb#753
  def update_attribute(name, value); end

  # Equivalent to <code>update_columns(name => value)</code>.
  #
  # source://activerecord//lib/active_record/persistence.rb#785
  def update_column(name, value); end

  # Updates the attributes directly in the database issuing an UPDATE SQL
  # statement and sets them in the receiver:
  #
  #   user.update_columns(last_request_at: Time.current)
  #
  # This is the fastest way to update attributes because it goes straight to
  # the database, but take into account that in consequence the regular update
  # procedures are totally bypassed. In particular:
  #
  # * \Validations are skipped.
  # * \Callbacks are skipped.
  # * +updated_at+/+updated_on+ are not updated.
  # * However, attributes are serialized with the same rules as ActiveRecord::Relation#update_all
  #
  # This method raises an ActiveRecord::ActiveRecordError when called on new
  # objects, or when at least one of the attributes is marked as readonly.
  #
  # @raise [ActiveRecordError]
  #
  # source://activerecord//lib/active_record/persistence.rb#805
  def update_columns(attributes); end

  private

  # Creates a record with values matching those of the instance attributes
  # and returns its id.
  #
  # @yield [_self]
  # @yieldparam _self [ActiveRecord::Persistence] the object that the method was called on
  #
  # source://activerecord//lib/active_record/persistence.rb#1093
  def _create_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/persistence.rb#1043
  def _delete_row; end

  # source://activerecord//lib/active_record/persistence.rb#1018
  def _find_record(options); end

  # source://activerecord//lib/active_record/persistence.rb#1031
  def _primary_key_constraints_hash; end

  # @raise [ReadOnlyRecord]
  #
  # source://activerecord//lib/active_record/persistence.rb#1122
  def _raise_readonly_record_error; end

  # source://activerecord//lib/active_record/persistence.rb#1114
  def _raise_record_not_destroyed; end

  # @raise [ActiveRecordError]
  #
  # source://activerecord//lib/active_record/persistence.rb#1126
  def _raise_record_not_touched_error; end

  # source://activerecord//lib/active_record/persistence.rb#1047
  def _touch_row(attribute_names, time); end

  # Updates the associated record with values matching those of the instance attributes.
  # Returns the number of affected rows.
  #
  # @yield [_self]
  # @yieldparam _self [ActiveRecord::Persistence] the object that the method was called on
  #
  # source://activerecord//lib/active_record/persistence.rb#1073
  def _update_record(attribute_names = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/persistence.rb#1057
  def _update_row(attribute_names, attempted_action = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://activerecord//lib/active_record/persistence.rb#1026
  def apply_scoping?(options); end

  # The name of the method used to touch a +belongs_to+ association when the
  # +:touch+ option is used.
  #
  # source://activerecord//lib/active_record/persistence.rb#1135
  def belongs_to_touch_method; end

  # source://activerecord//lib/active_record/persistence.rb#1064
  def create_or_update(**_arg0, &block); end

  # A hook to be overridden by association modules.
  #
  # source://activerecord//lib/active_record/persistence.rb#1036
  def destroy_associations; end

  # source://activerecord//lib/active_record/persistence.rb#1039
  def destroy_row; end

  # source://activerecord//lib/active_record/persistence.rb#1012
  def strict_loaded_associations; end

  # @raise [ActiveRecordError]
  #
  # source://activerecord//lib/active_record/persistence.rb#1110
  def verify_readonly_attribute(name); end
end

module ActiveRecord::Persistence::ClassMethods
  # source://activerecord//lib/active_record/persistence.rb#516
  def _delete_record(constraints); end

  # source://activerecord//lib/active_record/persistence.rb#477
  def _insert_record(values); end

  # source://activerecord//lib/active_record/persistence.rb#499
  def _update_record(values, constraints); end

  # Creates an object (or multiple objects) and saves it to the database, if validations pass.
  # The resulting object is returned whether the object was saved successfully to the database or not.
  #
  # The +attributes+ parameter can be either a Hash or an Array of Hashes. These Hashes describe the
  # attributes on the objects that are to be created.
  #
  # ==== Examples
  #   # Create a single new object
  #   User.create(first_name: 'Jamie')
  #
  #   # Create an Array of new objects
  #   User.create([{ first_name: 'Jamie' }, { first_name: 'Jeremy' }])
  #
  #   # Create a single object and pass it into a block to set other attributes.
  #   User.create(first_name: 'Jamie') do |u|
  #     u.is_admin = false
  #   end
  #
  #   # Creating an Array of new objects using a block, where the block is executed for each object:
  #   User.create([{ first_name: 'Jamie' }, { first_name: 'Jeremy' }]) do |u|
  #     u.is_admin = false
  #   end
  #
  # source://activerecord//lib/active_record/persistence.rb#33
  def create(attributes = T.unsafe(nil), &block); end

  # Creates an object (or multiple objects) and saves it to the database,
  # if validations pass. Raises a RecordInvalid error if validations fail,
  # unlike Base#create.
  #
  # The +attributes+ parameter can be either a Hash or an Array of Hashes.
  # These describe which attributes to be created on the object, or
  # multiple objects when given an Array of Hashes.
  #
  # source://activerecord//lib/active_record/persistence.rb#50
  def create!(attributes = T.unsafe(nil), &block); end

  # Deletes the row with a primary key matching the +id+ argument, using an
  # SQL +DELETE+ statement, and returns the number of rows deleted. Active
  # Record objects are not instantiated, so the object's callbacks are not
  # executed, including any <tt>:dependent</tt> association options.
  #
  # You can delete multiple rows at once by passing an Array of <tt>id</tt>s.
  #
  # Note: Although it is often much faster than the alternative, #destroy,
  # skipping callbacks might bypass business logic in your application
  # that ensures referential integrity or performs other essential jobs.
  #
  # ==== Examples
  #
  #   # Delete a single row
  #   Todo.delete(1)
  #
  #   # Delete multiple rows
  #   Todo.delete([2,3,4])
  #
  # source://activerecord//lib/active_record/persistence.rb#473
  def delete(id_or_array); end

  # Destroy an object (or multiple objects) that has the given id. The object is instantiated first,
  # therefore all callbacks and filters are fired off before the object is deleted. This method is
  # less efficient than #delete but allows cleanup methods and other actions to be run.
  #
  # This essentially finds the object (or multiple objects) with the given id, creates a new object
  # from the attributes, and then calls destroy on it.
  #
  # ==== Parameters
  #
  # * +id+ - This should be the id or an array of ids to be destroyed.
  #
  # ==== Examples
  #
  #   # Destroy a single object
  #   Todo.destroy(1)
  #
  #   # Destroy multiple objects
  #   todos = [1,2,3]
  #   Todo.destroy(todos)
  #
  # source://activerecord//lib/active_record/persistence.rb#447
  def destroy(id); end

  # Inserts a single record into the database in a single SQL INSERT
  # statement. It does not instantiate any models nor does it trigger
  # Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # See #insert_all for documentation.
  #
  # source://activerecord//lib/active_record/persistence.rb#66
  def insert(attributes, returning: T.unsafe(nil), unique_by: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Inserts a single record into the database in a single SQL INSERT
  # statement. It does not instantiate any models nor does it trigger
  # Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # See #insert_all! for more.
  #
  # source://activerecord//lib/active_record/persistence.rb#155
  def insert!(attributes, returning: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Inserts multiple records into the database in a single SQL INSERT
  # statement. It does not instantiate any models nor does it trigger
  # Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # The +attributes+ parameter is an Array of Hashes. Every Hash determines
  # the attributes for a single row and must have the same keys.
  #
  # Rows are considered to be unique by every unique index on the table. Any
  # duplicate rows are skipped.
  # Override with <tt>:unique_by</tt> (see below).
  #
  # Returns an ActiveRecord::Result with its contents based on
  # <tt>:returning</tt> (see below).
  #
  # ==== Options
  #
  # [:returning]
  #   (PostgreSQL only) An array of attributes to return for all successfully
  #   inserted records, which by default is the primary key.
  #   Pass <tt>returning: %w[ id name ]</tt> for both id and name
  #   or <tt>returning: false</tt> to omit the underlying <tt>RETURNING</tt> SQL
  #   clause entirely.
  #
  #   You can also pass an SQL string if you need more control on the return values
  #   (for example, <tt>returning: "id, name as new_name"</tt>).
  #
  # [:unique_by]
  #   (PostgreSQL and SQLite only) By default rows are considered to be unique
  #   by every unique index on the table. Any duplicate rows are skipped.
  #
  #   To skip rows according to just one unique index pass <tt>:unique_by</tt>.
  #
  #   Consider a Book model where no duplicate ISBNs make sense, but if any
  #   row has an existing id, or is not unique by another unique index,
  #   <tt>ActiveRecord::RecordNotUnique</tt> is raised.
  #
  #   Unique indexes can be identified by columns or name:
  #
  #     unique_by: :isbn
  #     unique_by: %i[ author_id name ]
  #     unique_by: :index_books_on_isbn
  #
  # [:record_timestamps]
  #   By default, automatic setting of timestamp columns is controlled by
  #   the model's <tt>record_timestamps</tt> config, matching typical
  #   behavior.
  #
  #   To override this and force automatic setting of timestamp columns one
  #   way or the other, pass <tt>:record_timestamps</tt>:
  #
  #     record_timestamps: true  # Always set timestamps automatically
  #     record_timestamps: false # Never set timestamps automatically
  #
  # Because it relies on the index information from the database
  # <tt>:unique_by</tt> is recommended to be paired with
  # Active Record's schema_cache.
  #
  # ==== Example
  #
  #   # Insert records and skip inserting any duplicates.
  #   # Here "Eloquent Ruby" is skipped because its id is not unique.
  #
  #   Book.insert_all([
  #     { id: 1, title: "Rework", author: "David" },
  #     { id: 1, title: "Eloquent Ruby", author: "Russ" }
  #   ])
  #
  #   # insert_all works on chained scopes, and you can use create_with
  #   # to set default attributes for all inserted records.
  #
  #   author.books.create_with(created_at: Time.now).insert_all([
  #     { id: 1, title: "Rework" },
  #     { id: 2, title: "Eloquent Ruby" }
  #   ])
  #
  # source://activerecord//lib/active_record/persistence.rb#145
  def insert_all(attributes, returning: T.unsafe(nil), unique_by: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Inserts multiple records into the database in a single SQL INSERT
  # statement. It does not instantiate any models nor does it trigger
  # Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # The +attributes+ parameter is an Array of Hashes. Every Hash determines
  # the attributes for a single row and must have the same keys.
  #
  # Raises <tt>ActiveRecord::RecordNotUnique</tt> if any rows violate a
  # unique index on the table. In that case, no rows are inserted.
  #
  # To skip duplicate rows, see #insert_all. To replace them, see #upsert_all.
  #
  # Returns an ActiveRecord::Result with its contents based on
  # <tt>:returning</tt> (see below).
  #
  # ==== Options
  #
  # [:returning]
  #   (PostgreSQL only) An array of attributes to return for all successfully
  #   inserted records, which by default is the primary key.
  #   Pass <tt>returning: %w[ id name ]</tt> for both id and name
  #   or <tt>returning: false</tt> to omit the underlying <tt>RETURNING</tt> SQL
  #   clause entirely.
  #
  #   You can also pass an SQL string if you need more control on the return values
  #   (for example, <tt>returning: "id, name as new_name"</tt>).
  #
  # [:record_timestamps]
  #   By default, automatic setting of timestamp columns is controlled by
  #   the model's <tt>record_timestamps</tt> config, matching typical
  #   behavior.
  #
  #   To override this and force automatic setting of timestamp columns one
  #   way or the other, pass <tt>:record_timestamps</tt>:
  #
  #     record_timestamps: true  # Always set timestamps automatically
  #     record_timestamps: false # Never set timestamps automatically
  #
  # ==== Examples
  #
  #   # Insert multiple records
  #   Book.insert_all!([
  #     { title: "Rework", author: "David" },
  #     { title: "Eloquent Ruby", author: "Russ" }
  #   ])
  #
  #   # Raises ActiveRecord::RecordNotUnique because "Eloquent Ruby"
  #   # does not have a unique id.
  #   Book.insert_all!([
  #     { id: 1, title: "Rework", author: "David" },
  #     { id: 1, title: "Eloquent Ruby", author: "Russ" }
  #   ])
  #
  # source://activerecord//lib/active_record/persistence.rb#212
  def insert_all!(attributes, returning: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Given an attributes hash, +instantiate+ returns a new instance of
  # the appropriate class. Accepts only keys as strings.
  #
  # For example, +Post.all+ may return Comments, Messages, and Emails
  # by storing the record's subclass in a +type+ attribute. By calling
  # +instantiate+ instead of +new+, finder methods ensure they get new
  # instances of the appropriate class for each record.
  #
  # See <tt>ActiveRecord::Inheritance#discriminate_class_for_record</tt> to see
  # how this "single-table" inheritance mapping is implemented.
  #
  # source://activerecord//lib/active_record/persistence.rb#346
  def instantiate(attributes, column_types = T.unsafe(nil), &block); end

  # Updates an object (or multiple objects) and saves it to the database, if validations pass.
  # The resulting object is returned whether the object was saved successfully to the database or not.
  #
  # ==== Parameters
  #
  # * +id+ - This should be the id or an array of ids to be updated.
  #   Optional argument, defaults to all records in the relation.
  # * +attributes+ - This should be a hash of attributes or an array of hashes.
  #
  # ==== Examples
  #
  #   # Updates one record
  #   Person.update(15, user_name: "Samuel", group: "expert")
  #
  #   # Updates multiple records
  #   people = { 1 => { "first_name" => "David" }, 2 => { "first_name" => "Jeremy" } }
  #   Person.update(people.keys, people.values)
  #
  #   # Updates multiple records from the result of a relation
  #   people = Person.where(group: "expert")
  #   people.update(group: "masters")
  #
  # Note: Updating a large number of records will run an UPDATE
  # query for each record, which may cause a performance issue.
  # When running callbacks is not needed for each record update,
  # it is preferred to use {update_all}[rdoc-ref:Relation#update_all]
  # for updating all records in a single query.
  #
  # source://activerecord//lib/active_record/persistence.rb#378
  def update(id = T.unsafe(nil), attributes); end

  # Updates the object (or multiple objects) just like #update but calls #update! instead
  # of +update+, so an exception is raised if the record is invalid and saving will fail.
  #
  # source://activerecord//lib/active_record/persistence.rb#404
  def update!(id = T.unsafe(nil), attributes); end

  # Updates or inserts (upserts) a single record into the database in a
  # single SQL INSERT statement. It does not instantiate any models nor does
  # it trigger Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # See #upsert_all for documentation.
  #
  # source://activerecord//lib/active_record/persistence.rb#222
  def upsert(attributes, on_duplicate: T.unsafe(nil), returning: T.unsafe(nil), unique_by: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  # Updates or inserts (upserts) multiple records into the database in a
  # single SQL INSERT statement. It does not instantiate any models nor does
  # it trigger Active Record callbacks or validations. Though passed values
  # go through Active Record's type casting and serialization.
  #
  # The +attributes+ parameter is an Array of Hashes. Every Hash determines
  # the attributes for a single row and must have the same keys.
  #
  # Returns an ActiveRecord::Result with its contents based on
  # <tt>:returning</tt> (see below).
  #
  # By default, +upsert_all+ will update all the columns that can be updated when
  # there is a conflict. These are all the columns except primary keys, read-only
  # columns, and columns covered by the optional +unique_by+.
  #
  # ==== Options
  #
  # [:returning]
  #   (PostgreSQL only) An array of attributes to return for all successfully
  #   inserted records, which by default is the primary key.
  #   Pass <tt>returning: %w[ id name ]</tt> for both id and name
  #   or <tt>returning: false</tt> to omit the underlying <tt>RETURNING</tt> SQL
  #   clause entirely.
  #
  #   You can also pass an SQL string if you need more control on the return values
  #   (for example, <tt>returning: "id, name as new_name"</tt>).
  #
  # [:unique_by]
  #   (PostgreSQL and SQLite only) By default rows are considered to be unique
  #   by every unique index on the table. Any duplicate rows are skipped.
  #
  #   To skip rows according to just one unique index pass <tt>:unique_by</tt>.
  #
  #   Consider a Book model where no duplicate ISBNs make sense, but if any
  #   row has an existing id, or is not unique by another unique index,
  #   <tt>ActiveRecord::RecordNotUnique</tt> is raised.
  #
  #   Unique indexes can be identified by columns or name:
  #
  #     unique_by: :isbn
  #     unique_by: %i[ author_id name ]
  #     unique_by: :index_books_on_isbn
  #
  # Because it relies on the index information from the database
  # <tt>:unique_by</tt> is recommended to be paired with
  # Active Record's schema_cache.
  #
  # [:on_duplicate]
  #   Configure the SQL update sentence that will be used in case of conflict.
  #
  #   NOTE: If you use this option you must provide all the columns you want to update
  #   by yourself.
  #
  #   Example:
  #
  #     Commodity.upsert_all(
  #       [
  #         { id: 2, name: "Copper", price: 4.84 },
  #         { id: 4, name: "Gold", price: 1380.87 },
  #         { id: 6, name: "Aluminium", price: 0.35 }
  #       ],
  #       on_duplicate: Arel.sql("price = GREATEST(commodities.price, EXCLUDED.price)")
  #     )
  #
  #   See the related +:update_only+ option. Both options can't be used at the same time.
  #
  # [:update_only]
  #   Provide a list of column names that will be updated in case of conflict. If not provided,
  #   +upsert_all+ will update all the columns that can be updated. These are all the columns
  #   except primary keys, read-only columns, and columns covered by the optional +unique_by+
  #
  #   Example:
  #
  #     Commodity.upsert_all(
  #       [
  #         { id: 2, name: "Copper", price: 4.84 },
  #         { id: 4, name: "Gold", price: 1380.87 },
  #         { id: 6, name: "Aluminium", price: 0.35 }
  #       ],
  #       update_only: [:price] # Only prices will be updated
  #     )
  #
  #   See the related +:on_duplicate+ option. Both options can't be used at the same time.
  #
  # [:record_timestamps]
  #   By default, automatic setting of timestamp columns is controlled by
  #   the model's <tt>record_timestamps</tt> config, matching typical
  #   behavior.
  #
  #   To override this and force automatic setting of timestamp columns one
  #   way or the other, pass <tt>:record_timestamps</tt>:
  #
  #     record_timestamps: true  # Always set timestamps automatically
  #     record_timestamps: false # Never set timestamps automatically
  #
  # ==== Examples
  #
  #   # Inserts multiple records, performing an upsert when records have duplicate ISBNs.
  #   # Here "Eloquent Ruby" overwrites "Rework" because its ISBN is duplicate.
  #
  #   Book.upsert_all([
  #     { title: "Rework", author: "David", isbn: "1" },
  #     { title: "Eloquent Ruby", author: "Russ", isbn: "1" }
  #   ], unique_by: :isbn)
  #
  #   Book.find_by(isbn: "1").title # => "Eloquent Ruby"
  #
  # source://activerecord//lib/active_record/persistence.rb#332
  def upsert_all(attributes, on_duplicate: T.unsafe(nil), update_only: T.unsafe(nil), returning: T.unsafe(nil), unique_by: T.unsafe(nil), record_timestamps: T.unsafe(nil)); end

  private

  # Called by +_update_record+ and +_delete_record+
  # to build `where` clause from default scopes.
  # Skips empty scopes.
  #
  # source://activerecord//lib/active_record/persistence.rb#552
  def build_default_constraint; end

  # Called by +instantiate+ to decide which class to use for a new
  # record instance.
  #
  # See +ActiveRecord::Inheritance#discriminate_class_for_record+ for
  # the single-table inheritance discriminator.
  #
  # source://activerecord//lib/active_record/persistence.rb#545
  def discriminate_class_for_record(record); end

  # Given a class, an attributes hash, +instantiate_instance_of+ returns a
  # new instance of the class. Accepts only keys as strings.
  #
  # source://activerecord//lib/active_record/persistence.rb#535
  def instantiate_instance_of(klass, attributes, column_types = T.unsafe(nil), &block); end
end

class ActiveRecord::PredicateBuilder
  # @return [PredicateBuilder] a new instance of PredicateBuilder
  #
  # source://activerecord//lib/active_record/relation/predicate_builder.rb#12
  def initialize(table); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#53
  def [](attr_name, value, operator = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#57
  def build(attribute, value, operator = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#67
  def build_bind_attribute(column_name, value); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#23
  def build_from_hash(attributes, &block); end

  # Define how a class is converted to Arel nodes when passed to +where+.
  # The handler can be any object that responds to +call+, and will be used
  # for any value that +===+ the class given. For example:
  #
  #     MyCustomDateRange = Struct.new(:start, :end)
  #     handler = proc do |column, range|
  #       Arel::Nodes::Between.new(column,
  #         Arel::Nodes::And.new([range.start, range.end])
  #       )
  #     end
  #     ActiveRecord::PredicateBuilder.new("users").register_handler(MyCustomDateRange, handler)
  #
  # source://activerecord//lib/active_record/relation/predicate_builder.rb#49
  def register_handler(klass, handler); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#71
  def resolve_arel_attribute(table_name, column_name, &block); end

  protected

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#76
  def expand_from_hash(attributes, &block); end

  private

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#144
  def convert_dot_notation_to_hash(attributes); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#134
  def grouping_queries(queries); end

  # source://activerecord//lib/active_record/relation/predicate_builder.rb#160
  def handler_for(object); end

  # Returns the value of attribute table.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder.rb#132
  def table; end

  class << self
    # source://activerecord//lib/active_record/relation/predicate_builder.rb#28
    def references(attributes); end
  end
end

class ActiveRecord::PredicateBuilder::ArrayHandler
  # @return [ArrayHandler] a new instance of ArrayHandler
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/array_handler.rb#8
  def initialize(predicate_builder); end

  # source://activerecord//lib/active_record/relation/predicate_builder/array_handler.rb#12
  def call(attribute, value); end

  private

  # Returns the value of attribute predicate_builder.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/array_handler.rb#39
  def predicate_builder; end
end

module ActiveRecord::PredicateBuilder::ArrayHandler::NullPredicate
  class << self
    # source://activerecord//lib/active_record/relation/predicate_builder/array_handler.rb#42
    def or(other); end
  end
end

class ActiveRecord::PredicateBuilder::AssociationQueryValue
  # @return [AssociationQueryValue] a new instance of AssociationQueryValue
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#6
  def initialize(associated_table, value); end

  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#11
  def queries; end

  private

  # Returns the value of attribute associated_table.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#16
  def associated_table; end

  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#33
  def convert_to_id(value); end

  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#18
  def ids; end

  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#29
  def primary_key; end

  # Returns the value of attribute value.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/association_query_value.rb#16
  def value; end
end

class ActiveRecord::PredicateBuilder::BasicObjectHandler
  # @return [BasicObjectHandler] a new instance of BasicObjectHandler
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/basic_object_handler.rb#6
  def initialize(predicate_builder); end

  # source://activerecord//lib/active_record/relation/predicate_builder/basic_object_handler.rb#10
  def call(attribute, value); end

  private

  # Returns the value of attribute predicate_builder.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/basic_object_handler.rb#16
  def predicate_builder; end
end

class ActiveRecord::PredicateBuilder::PolymorphicArrayValue
  # @return [PolymorphicArrayValue] a new instance of PolymorphicArrayValue
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#6
  def initialize(associated_table, values); end

  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#11
  def queries; end

  private

  # Returns the value of attribute associated_table.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#23
  def associated_table; end

  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#45
  def convert_to_id(value); end

  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#36
  def klass(value); end

  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#32
  def primary_key(value); end

  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#25
  def type_to_ids_mapping; end

  # Returns the value of attribute values.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/polymorphic_array_value.rb#23
  def values; end
end

class ActiveRecord::PredicateBuilder::RangeHandler
  # @return [RangeHandler] a new instance of RangeHandler
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/range_handler.rb#8
  def initialize(predicate_builder); end

  # source://activerecord//lib/active_record/relation/predicate_builder/range_handler.rb#12
  def call(attribute, value); end

  private

  # Returns the value of attribute predicate_builder.
  #
  # source://activerecord//lib/active_record/relation/predicate_builder/range_handler.rb#19
  def predicate_builder; end
end

class ActiveRecord::PredicateBuilder::RangeHandler::RangeWithBinds < ::Struct
  # Returns the value of attribute begin
  #
  # @return [Object] the current value of begin
  def begin; end

  # Sets the attribute begin
  #
  # @param value [Object] the value to set the attribute begin to.
  # @return [Object] the newly set value
  def begin=(_); end

  # Returns the value of attribute end
  #
  # @return [Object] the current value of end
  def end; end

  # Sets the attribute end
  #
  # @param value [Object] the value to set the attribute end to.
  # @return [Object] the newly set value
  def end=(_); end

  # Returns the value of attribute exclude_end?
  #
  # @return [Object] the current value of exclude_end?
  def exclude_end?; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class ActiveRecord::PredicateBuilder::RelationHandler
  # source://activerecord//lib/active_record/relation/predicate_builder/relation_handler.rb#6
  def call(attribute, value); end
end

# Raised when PostgreSQL returns 'cached plan must not change result type' and
# we cannot retry gracefully (e.g. inside a transaction)
class ActiveRecord::PreparedStatementCacheExpired < ::ActiveRecord::StatementInvalid; end

# Raised when the number of placeholders in an SQL fragment passed to
# {ActiveRecord::Base.where}[rdoc-ref:QueryMethods#where]
# does not match the number of values supplied.
#
# For example, when there are two placeholders with only one value supplied:
#
#   Location.where("lat = ? AND lng = ?", 53.7362)
class ActiveRecord::PreparedStatementInvalid < ::ActiveRecord::ActiveRecordError; end

class ActiveRecord::ProtectedEnvironmentError < ::ActiveRecord::ActiveRecordError
  # @return [ProtectedEnvironmentError] a new instance of ProtectedEnvironmentError
  #
  # source://activerecord//lib/active_record/migration.rb#189
  def initialize(env = T.unsafe(nil)); end
end

# Superclass for errors that have been aborted (either by client or server).
class ActiveRecord::QueryAborted < ::ActiveRecord::StatementInvalid; end

# = Active Record Query Cache
class ActiveRecord::QueryCache
  class << self
    # source://activerecord//lib/active_record/query_cache.rb#42
    def complete(pools); end

    # source://activerecord//lib/active_record/query_cache.rb#58
    def install_executor_hooks(executor = T.unsafe(nil)); end

    # source://activerecord//lib/active_record/query_cache.rb#28
    def run; end
  end
end

module ActiveRecord::QueryCache::ClassMethods
  # Enable the query cache within the block if Active Record is configured.
  # If it's not, it will execute the given block.
  #
  # source://activerecord//lib/active_record/query_cache.rb#9
  def cache(&block); end

  # Disable the query cache within the block if Active Record is configured.
  # If it's not, it will execute the given block.
  #
  # source://activerecord//lib/active_record/query_cache.rb#19
  def uncached(&block); end
end

# QueryCanceled will be raised when canceling statement due to user request.
class ActiveRecord::QueryCanceled < ::ActiveRecord::QueryAborted; end

# = Active Record Query Logs
#
# Automatically tag SQL queries with runtime information.
#
# Default tags available for use:
#
# * +application+
# * +pid+
# * +socket+
# * +db_host+
# * +database+
#
# _Action Controller and Active Job tags are also defined when used in Rails:_
#
# * +controller+
# * +action+
# * +job+
#
# The tags used in a query can be configured directly:
#
#     ActiveRecord::QueryLogs.tags = [ :application, :controller, :action, :job ]
#
# or via Rails configuration:
#
#     config.active_record.query_log_tags = [ :application, :controller, :action, :job ]
#
# To add new comment tags, add a hash to the tags array containing the keys and values you
# want to add to the comment. Dynamic content can be created by setting a proc or lambda value in a hash,
# and can reference any value stored in the +context+ object.
#
# Example:
#
#    tags = [
#      :application,
#      {
#        custom_tag: ->(context) { context[:controller]&.controller_name },
#        custom_value: -> { Custom.value },
#      }
#    ]
#    ActiveRecord::QueryLogs.tags = tags
#
# The QueryLogs +context+ can be manipulated via the +ActiveSupport::ExecutionContext.set+ method.
#
# Temporary updates limited to the execution of a block:
#
#    ActiveSupport::ExecutionContext.set(foo: Bar.new) do
#      posts = Post.all
#    end
#
# Direct updates to a context value:
#
#    ActiveSupport::ExecutionContext[:foo] = Bar.new
#
# Tag comments can be prepended to the query:
#
#    ActiveRecord::QueryLogs.prepend_comment = true
#
# For applications where the content will not change during the lifetime of
# the request or job execution, the tags can be cached for reuse in every query:
#
#    ActiveRecord::QueryLogs.cache_query_log_tags = true
#
# This option can be set during application configuration or in a Rails initializer:
#
#    config.active_record.cache_query_log_tags = true
module ActiveRecord::QueryLogs
  class << self
    # source://activerecord//lib/active_record/query_logs.rb#75
    def cache_query_log_tags; end

    # source://activerecord//lib/active_record/query_logs.rb#75
    def cache_query_log_tags=(val); end

    # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#48
    def cached_comment; end

    # source://activesupport/7.0.4/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#92
    def cached_comment=(obj); end

    # source://activerecord//lib/active_record/query_logs.rb#79
    def call(sql); end

    # source://activerecord//lib/active_record/query_logs.rb#87
    def clear_cache; end

    # source://activerecord//lib/active_record/query_logs.rb#74
    def prepend_comment; end

    # source://activerecord//lib/active_record/query_logs.rb#74
    def prepend_comment=(val); end

    # source://activerecord//lib/active_record/query_logs.rb#72
    def taggings; end

    # source://activerecord//lib/active_record/query_logs.rb#72
    def taggings=(val); end

    # source://activerecord//lib/active_record/query_logs.rb#73
    def tags; end

    # source://activerecord//lib/active_record/query_logs.rb#73
    def tags=(val); end

    private

    # Returns an SQL comment +String+ containing the query log tags.
    # Sets and returns a cached comment if <tt>cache_query_log_tags</tt> is +true+.
    #
    # source://activerecord//lib/active_record/query_logs.rb#96
    def comment; end

    # source://activerecord//lib/active_record/query_logs.rb#111
    def escape_sql_comment(content); end

    # source://activerecord//lib/active_record/query_logs.rb#115
    def tag_content; end

    # source://activerecord//lib/active_record/query_logs.rb#104
    def uncached_comment; end
  end
end

module ActiveRecord::QueryMethods
  include ::ActiveModel::ForbiddenAttributesProtection

  # source://activerecord//lib/active_record/relation/query_methods.rb#317
  def _select!(*fields); end

  # Returns a new relation, which is the logical intersection of this relation and the one passed
  # as an argument.
  #
  # The two relations must be structurally compatible: they must be scoping the same model, and
  # they must differ only by #where (if no #group has been defined) or #having (if a #group is
  # present).
  #
  #    Post.where(id: [1, 2]).and(Post.where(id: [2, 3]))
  #    # SELECT `posts`.* FROM `posts` WHERE `posts`.`id` IN (1, 2) AND `posts`.`id` IN (2, 3)
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#845
  def and(other); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#853
  def and!(other); end

  # Adds an SQL comment to queries generated from this relation. For example:
  #
  #   User.annotate("selecting user names").select(:name)
  #   # SELECT "users"."name" FROM "users" /* selecting user names */
  #
  #   User.annotate("selecting", "user", "names").select(:name)
  #   # SELECT "users"."name" FROM "users" /* selecting */ /* user */ /* names */
  #
  # The SQL block comment delimiters, "/*" and "*/", will be added automatically.
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1219
  def annotate(*args); end

  # Like #annotate, but modifies relation in place.
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1225
  def annotate!(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def annotate_values; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def annotate_values=(value); end

  # Returns the Arel object associated with the relation.
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1280
  def arel(aliases = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#1284
  def construct_join_dependency(associations, join_type); end

  # Sets attributes to be used when creating new records from a
  # relation object.
  #
  #   users = User.where(name: 'Oscar')
  #   users.new.name # => 'Oscar'
  #
  #   users = users.create_with(name: 'DHH')
  #   users.new.name # => 'DHH'
  #
  # You can pass +nil+ to #create_with to reset attributes:
  #
  #   users = users.create_with(nil)
  #   users.new.name # => 'Oscar'
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1038
  def create_with(value); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#1042
  def create_with!(value); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def create_with_value; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def create_with_value=(value); end

  # Specifies whether the records should be unique or not. For example:
  #
  #   User.select(:name)
  #   # Might return two records with the same name
  #
  #   User.select(:name).distinct
  #   # Returns 1 record per distinct name
  #
  #   User.select(:name).distinct.distinct(false)
  #   # You can also remove the uniqueness
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1102
  def distinct(value = T.unsafe(nil)); end

  # Like #distinct, but modifies relation in place.
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1107
  def distinct!(value = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def distinct_value; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def distinct_value=(value); end

  # Forces eager loading by performing a LEFT OUTER JOIN on +args+:
  #
  #   User.eager_load(:posts)
  #   # SELECT "users"."id" AS t0_r0, "users"."name" AS t0_r1, ...
  #   # FROM "users" LEFT OUTER JOIN "posts" ON "posts"."user_id" =
  #   # "users"."id"
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#207
  def eager_load(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#212
  def eager_load!(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def eager_load_values; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def eager_load_values=(value); end

  # Excludes the specified record (or collection of records) from the resulting
  # relation. For example:
  #
  #   Post.excluding(post)
  #   # SELECT "posts".* FROM "posts" WHERE "posts"."id" != 1
  #
  #   Post.excluding(post_one, post_two)
  #   # SELECT "posts".* FROM "posts" WHERE "posts"."id" NOT IN (1, 2)
  #
  # This can also be called on associations. As with the above example, either
  # a single record of collection thereof may be specified:
  #
  #   post = Post.find(1)
  #   comment = Comment.find(2)
  #   post.comments.excluding(comment)
  #   # SELECT "comments".* FROM "comments" WHERE "comments"."post_id" = 1 AND "comments"."id" != 2
  #
  # This is short-hand for <tt>.where.not(id: post.id)</tt> and <tt>.where.not(id: [post_one.id, post_two.id])</tt>.
  #
  # An <tt>ArgumentError</tt> will be raised if either no records are
  # specified, or if any of the records in the collection (if a collection
  # is passed in) are not instances of the same model that the relation is
  # scoping.
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1261
  def excluding(*records); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#1273
  def excluding!(records); end

  # Used to extend a scope with additional methods, either through
  # a module or through a block provided.
  #
  # The object returned is a relation, which can be further extended.
  #
  # === Using a module
  #
  #   module Pagination
  #     def page(number)
  #       # pagination code goes here
  #     end
  #   end
  #
  #   scope = Model.all.extending(Pagination)
  #   scope.page(params[:page])
  #
  # You can also pass a list of modules:
  #
  #   scope = Model.all.extending(Pagination, SomethingElse)
  #
  # === Using a block
  #
  #   scope = Model.all.extending do
  #     def page(number)
  #       # pagination code goes here
  #     end
  #   end
  #   scope.page(params[:page])
  #
  # You can also use a block and a module list:
  #
  #   scope = Model.all.extending(Pagination) do
  #     def per_page(number)
  #       # pagination code goes here
  #     end
  #   end
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1148
  def extending(*modules, &block); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#1156
  def extending!(*modules, &block); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def extending_values; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def extending_values=(value); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def extensions; end

  # Extracts a named +association+ from the relation. The named association is first preloaded,
  # then the individual association records are collected from the relation. Like so:
  #
  #   account.memberships.extract_associated(:user)
  #   # => Returns collection of User records
  #
  # This is short-hand for:
  #
  #   account.memberships.preload(:user).collect(&:user)
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#240
  def extract_associated(association); end

  # Specifies the table from which the records will be fetched. For example:
  #
  #   Topic.select('title').from('posts')
  #   # SELECT title FROM posts
  #
  # Can accept other relation objects. For example:
  #
  #   Topic.select('title').from(Topic.approved)
  #   # SELECT title FROM (SELECT * FROM topics WHERE approved = 't') subquery
  #
  # Passing a second argument (string or symbol), creates the alias for the SQL from clause. Otherwise the alias "subquery" is used:
  #
  #   Topic.select('a.title').from(Topic.approved, :a)
  #   # SELECT a.title FROM (SELECT * FROM topics WHERE approved = 't') a
  #
  # It does not add multiple arguments to the SQL from clause. The last +from+ chained is the one used:
  #
  #   Topic.select('title').from(Topic.approved).from(Topic.inactive)
  #   # SELECT title FROM (SELECT topics.* FROM topics WHERE topics.active = 'f') subquery
  #
  # For multiple arguments for the SQL from clause, you can pass a string with the exact elements in the SQL from list:
  #
  #   color = "red"
  #   Color
  #     .from("colors c, JSONB_ARRAY_ELEMENTS(colored_things) AS colorvalues(colorvalue)")
  #     .where("colorvalue->>'color' = ?", color)
  #     .select("c.*").to_a
  #   # SELECT c.*
  #   # FROM colors c, JSONB_ARRAY_ELEMENTS(colored_things) AS colorvalues(colorvalue)
  #   # WHERE (colorvalue->>'color' = 'red')
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#1083
  def from(value, subquery_name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#1087
  def from!(value, subquery_name = T.unsafe(nil)); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def from_clause; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def from_clause=(value); end

  # Allows to specify a group attribute:
  #
  #   User.group(:name)
  #   # SELECT "users".* FROM "users" GROUP BY name
  #
  # Returns an array with distinct records based on the +group+ attribute:
  #
  #   User.select([:id, :name])
  #   # => [#<User id: 1, name: "Oscar">, #<User id: 2, name: "Oscar">, #<User id: 3, name: "Foo">]
  #
  #   User.group(:name)
  #   # => [#<User id: 3, name: "Foo", ...>, #<User id: 2, name: "Oscar", ...>]
  #
  #   User.group('name AS grouped_name, age')
  #   # => [#<User id: 3, name: "Foo", age: 21, ...>, #<User id: 2, name: "Oscar", age: 21, ...>, #<User id: 5, name: "Foo", age: 23, ...>]
  #
  # Passing in an array of attributes to group by is also supported.
  #
  #   User.select([:id, :first_name]).group(:id, :first_name).first(3)
  #   # => [#<User id: 1, first_name: "Bill">, #<User id: 2, first_name: "Earl">, #<User id: 3, first_name: "Beto">]
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#363
  def group(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#368
  def group!(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def group_values; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def group_values=(value); end

  # Allows to specify a HAVING clause. Note that you can't use HAVING
  # without also specifying a GROUP clause.
  #
  #   Order.having('SUM(price) > 30').group('user_id')
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#903
  def having(opts, *rest); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#907
  def having!(opts, *rest); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def having_clause; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def having_clause=(value); end

  # Allows to specify an order by a specific set of values. Depending on your
  # adapter this will either use a CASE statement or a built-in function.
  #
  #   User.in_order_of(:id, [1, 5, 3])
  #   # SELECT "users".* FROM "users"
  #   #   ORDER BY FIELD("users"."id", 1, 5, 3)
  #   #   WHERE "users"."id" IN (1, 5, 3)
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#447
  def in_order_of(column, values); end

  # Specify relationships to be included in the result set. For
  # example:
  #
  #   users = User.includes(:address)
  #   users.each do |user|
  #     user.address.city
  #   end
  #
  # allows you to access the +address+ attribute of the +User+ model without
  # firing an additional query. This will often result in a
  # performance improvement over a simple join.
  #
  # You can also specify multiple relationships, like this:
  #
  #   users = User.includes(:address, :friends)
  #
  # Loading nested relationships is possible using a Hash:
  #
  #   users = User.includes(:address, friends: [:address, :followers])
  #
  # === Conditions
  #
  # If you want to add string conditions to your included models, you'll have
  # to explicitly reference them. For example:
  #
  #   User.includes(:posts).where('posts.name = ?', 'example')
  #
  # Will throw an error, but this will work:
  #
  #   User.includes(:posts).where('posts.name = ?', 'example').references(:posts)
  #
  # Note that #includes works with association names while #references needs
  # the actual table name.
  #
  # If you pass the conditions via hash, you don't need to call #references
  # explicitly, as #where references the tables for you. For example, this
  # will work correctly:
  #
  #   User.includes(:posts).where(posts: { name: 'example' })
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#191
  def includes(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#196
  def includes!(*args); end

  # source://activerecord//lib/active_record/relation/query_methods.rb#139
  def includes_values; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#143
  def includes_values=(value); end

  # Allows you to invert an entire where clause instead of manually applying conditions.
  #
  #   class User
  #     scope :active, -> { where(accepted: true, locked: false) }
  #   end
  #
  #   User.where(accepted: true)
  #   # WHERE `accepted` = 1
  #
  #   User.where(accepted: true).invert_where
  #   # WHERE `accepted` != 1
  #
  #   User.active
  #   # WHERE `accepted` = 1 AND `locked` = 0
  #
  #   User.active.invert_where
  #   # WHERE NOT (`accepted` = 1 AND `locked` = 0)
  #
  # Be careful because this inverts all conditions before +invert_where+ call.
  #
  #   class User
  #     scope :active, -> { where(accepted: true, locked: false) }
  #     scope :inactive, -> { active.invert_where } # Do not attempt it
  #   end
  #
  #   # It also inverts `where(role: 'admin')` unexpectedly.
  #   User.where(role: 'admin').inactive
  #   # WHERE NOT (`role` = 'admin' AND `accepted` = 1 AND `locked` = 0)
  #
  # source://activerecord//lib/active_record/relation/query_methods.rb#811
  def invert_where; end

  # source://activerecord//lib/active_record/relation/query_methods.rb#815
  def invert_where!; end

  # Performs JOINs on +args+. The given symbol(s) should match the name of
  # the association(s).
  #
  #   User.joins(:posts)
  #   # SELECT "users".*
  #   # FROM "users"
  #   # INNER JOIN "posts" ON "posts"."user_id" = "users"."id"
  #
  # Multiple joins:
  #
  #   User.joins(:posts, :account)
  #   # SELECT "users".*
  #   # FROM "users"
  #   # INNER JOIN "posts" ON "posts"."user_id