# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `activejob` gem.
# Please instead update this file by running `bin/tapioca gem activejob`.

module ActiveJob
  extend ::ActiveSupport::Autoload

  class << self
    # Returns the currently loaded version of Active Job as a <tt>Gem::Version</tt>.
    #
    # source://activejob//lib/active_job/gem_version.rb#5
    def gem_version; end

    # Returns the currently loaded version of Active Job as a <tt>Gem::Version</tt>.
    #
    # source://activejob//lib/active_job/version.rb#7
    def version; end
  end
end

module ActiveJob::Arguments
  extend ::ActiveJob::Arguments

  # Deserializes a set of arguments. Intrinsic types that can safely be
  # deserialized without mutation are returned as-is. Arrays/Hashes are
  # deserialized element by element. All other types are deserialized using
  # GlobalID.
  #
  # source://activejob//lib/active_job/arguments.rb#42
  def deserialize(arguments); end

  # Serializes a set of arguments. Intrinsic types that can safely be
  # serialized without mutation are returned as-is. Arrays/Hashes are
  # serialized element by element. All other types are serialized using
  # GlobalID.
  #
  # source://activejob//lib/active_job/arguments.rb#34
  def serialize(arguments); end

  private

  # source://activejob//lib/active_job/arguments.rb#204
  def convert_to_global_id_hash(argument); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/arguments.rb#151
  def custom_serialized?(hash); end

  # source://activejob//lib/active_job/arguments.rb#122
  def deserialize_argument(argument); end

  # source://activejob//lib/active_job/arguments.rb#147
  def deserialize_global_id(hash); end

  # source://activejob//lib/active_job/arguments.rb#161
  def deserialize_hash(serialized_hash); end

  # source://activejob//lib/active_job/arguments.rb#95
  def serialize_argument(argument); end

  # source://activejob//lib/active_job/arguments.rb#155
  def serialize_hash(argument); end

  # source://activejob//lib/active_job/arguments.rb#174
  def serialize_hash_key(key); end

  # source://activejob//lib/active_job/arguments.rb#185
  def serialize_indifferent_hash(indifferent_hash); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/arguments.rb#143
  def serialized_global_id?(hash); end

  # source://activejob//lib/active_job/arguments.rb#191
  def transform_symbol_keys(hash, symbol_keys); end
end

# source://activejob//lib/active_job/arguments.rb#52
ActiveJob::Arguments::GLOBALID_KEY = T.let(T.unsafe(nil), String)

# source://activejob//lib/active_job/arguments.rb#60
ActiveJob::Arguments::OBJECT_SERIALIZER_KEY = T.let(T.unsafe(nil), String)

# source://activejob//lib/active_job/arguments.rb#50
ActiveJob::Arguments::PERMITTED_TYPES = T.let(T.unsafe(nil), Array)

# source://activejob//lib/active_job/arguments.rb#63
ActiveJob::Arguments::RESERVED_KEYS = T.let(T.unsafe(nil), Array)

# source://activejob//lib/active_job/arguments.rb#56
ActiveJob::Arguments::RUBY2_KEYWORDS_KEY = T.let(T.unsafe(nil), String)

# source://activejob//lib/active_job/arguments.rb#54
ActiveJob::Arguments::SYMBOL_KEYS_KEY = T.let(T.unsafe(nil), String)

# source://activejob//lib/active_job/arguments.rb#58
ActiveJob::Arguments::WITH_INDIFFERENT_ACCESS_KEY = T.let(T.unsafe(nil), String)

# = Active Job
#
# Active Job objects can be configured to work with different backend
# queuing frameworks. To specify a queue adapter to use:
#
#   ActiveJob::Base.queue_adapter = :inline
#
# A list of supported adapters can be found in QueueAdapters.
#
# Active Job objects can be defined by creating a class that inherits
# from the ActiveJob::Base class. The only necessary method to
# implement is the "perform" method.
#
# To define an Active Job object:
#
#   class ProcessPhotoJob < ActiveJob::Base
#     def perform(photo)
#       photo.watermark!('Rails')
#       photo.rotate!(90.degrees)
#       photo.resize_to_fit!(300, 300)
#       photo.upload!
#     end
#   end
#
# Records that are passed in are serialized/deserialized using Global
# ID. More information can be found in Arguments.
#
# To enqueue a job to be performed as soon as the queuing system is free:
#
#   ProcessPhotoJob.perform_later(photo)
#
# To enqueue a job to be processed at some point in the future:
#
#   ProcessPhotoJob.set(wait_until: Date.tomorrow.noon).perform_later(photo)
#
# More information can be found in ActiveJob::Core::ClassMethods#set
#
# A job can also be processed immediately without sending to the queue:
#
#  ProcessPhotoJob.perform_now(photo)
#
# == Exceptions
#
# * DeserializationError - Error class for deserialization errors.
# * SerializationError - Error class for serialization errors.
class ActiveJob::Base
  include ::ActiveJob::Core
  include ::ActiveJob::QueueAdapter
  include ::ActiveJob::QueueName
  include ::ActiveJob::QueuePriority
  include ::ActiveJob::Enqueuing
  include ::ActiveSupport::Rescuable
  include ::ActiveJob::Execution
  include ::ActiveSupport::Callbacks
  include ::ActiveJob::Callbacks
  include ::ActiveJob::Exceptions
  include ::ActiveJob::Instrumentation
  include ::ActiveJob::Logging
  include ::ActiveJob::Timezones
  include ::ActiveJob::Translation
  include ::ActiveJob::TestHelper::TestQueueAdapter
  extend ::ActiveJob::Core::ClassMethods
  extend ::ActiveJob::QueueAdapter::ClassMethods
  extend ::ActiveJob::QueueName::ClassMethods
  extend ::ActiveJob::QueuePriority::ClassMethods
  extend ::ActiveJob::Enqueuing::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods
  extend ::ActiveJob::Execution::ClassMethods
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActiveJob::Callbacks::ClassMethods
  extend ::ActiveJob::Exceptions::ClassMethods
  extend ::ActiveJob::TestHelper::TestQueueAdapter::ClassMethods

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
  def __callbacks?; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _enqueue_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#940
  def _perform_callbacks; end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_enqueue_callbacks(&block); end

  # source://activesupport/7.0.4/lib/active_support/callbacks.rb#928
  def _run_perform_callbacks(&block); end

  # source://activejob//lib/active_job/logging.rb#11
  def logger; end

  # source://activejob//lib/active_job/logging.rb#11
  def logger=(val); end

  # source://activejob//lib/active_job/queue_adapter.rb#15
  def queue_adapter(*_arg0, **_arg1, &_arg2); end

  # source://activejob//lib/active_job/queue_name.rb#58
  def queue_name_prefix; end

  # source://activejob//lib/active_job/queue_name.rb#58
  def queue_name_prefix=(_arg0); end

  # source://activejob//lib/active_job/queue_name.rb#58
  def queue_name_prefix?; end

  # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
  def rescue_handlers; end

  # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
  def rescue_handlers?; end

  class << self
    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#68
    def __callbacks?; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _enqueue_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _enqueue_callbacks=(value); end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#932
    def _perform_callbacks; end

    # source://activesupport/7.0.4/lib/active_support/callbacks.rb#936
    def _perform_callbacks=(value); end

    # source://activejob//lib/active_job/queue_adapter.rb#13
    def _queue_adapter; end

    # source://activejob//lib/active_job/queue_adapter.rb#13
    def _queue_adapter=(value); end

    # source://activejob//lib/active_job/queue_adapter.rb#12
    def _queue_adapter_name; end

    # source://activejob//lib/active_job/queue_adapter.rb#12
    def _queue_adapter_name=(value); end

    # source://activejob//lib/active_job/test_helper.rb#19
    def _test_adapter; end

    # source://activejob//lib/active_job/test_helper.rb#19
    def _test_adapter=(value); end

    # source://activejob//lib/active_job/logging.rb#12
    def log_arguments; end

    # source://activejob//lib/active_job/logging.rb#12
    def log_arguments=(value); end

    # source://activejob//lib/active_job/logging.rb#12
    def log_arguments?; end

    # source://activejob//lib/active_job/logging.rb#11
    def logger; end

    # source://activejob//lib/active_job/logging.rb#11
    def logger=(val); end

    # source://activejob//lib/active_job/queue_priority.rb#32
    def priority; end

    # source://activejob//lib/active_job/queue_priority.rb#32
    def priority=(value); end

    # source://activejob//lib/active_job/queue_priority.rb#32
    def priority?; end

    # source://activejob//lib/active_job/queue_name.rb#56
    def queue_name; end

    # source://activejob//lib/active_job/queue_name.rb#56
    def queue_name=(value); end

    # source://activejob//lib/active_job/queue_name.rb#56
    def queue_name?; end

    # source://activejob//lib/active_job/queue_name.rb#57
    def queue_name_delimiter; end

    # source://activejob//lib/active_job/queue_name.rb#57
    def queue_name_delimiter=(value); end

    # source://activejob//lib/active_job/queue_name.rb#57
    def queue_name_delimiter?; end

    # source://activejob//lib/active_job/queue_name.rb#58
    def queue_name_prefix; end

    # source://activejob//lib/active_job/queue_name.rb#58
    def queue_name_prefix=(value); end

    # source://activejob//lib/active_job/queue_name.rb#58
    def queue_name_prefix?; end

    # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
    def rescue_handlers; end

    # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
    def rescue_handlers=(value); end

    # source://activesupport/7.0.4/lib/active_support/rescuable.rb#13
    def rescue_handlers?; end

    # source://activejob//lib/active_job/exceptions.rb#11
    def retry_jitter; end

    # source://activejob//lib/active_job/exceptions.rb#11
    def retry_jitter=(value); end

    # source://activesupport/7.0.4/lib/active_support/deprecation/method_wrappers.rb#63
    def skip_after_callbacks_if_terminated(*args, **_arg1, &block); end

    # source://activesupport/7.0.4/lib/active_support/deprecation/method_wrappers.rb#63
    def skip_after_callbacks_if_terminated=(*args, **_arg1, &block); end
  end
end

# These methods will be included into any Active Job object, adding
# callbacks for +perform+ and +enqueue+ methods.
module ActiveJob::Callbacks::ClassMethods
  # Defines a callback that will get called right after the
  # job is enqueued.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     after_enqueue do |job|
  #       $statsd.increment "enqueue-video-job.success"
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#146
  def after_enqueue(*filters, &blk); end

  # Defines a callback that will get called right after the
  # job's perform method has finished.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     after_perform do |job|
  #       UserMailer.notify_video_processed(job.arguments.first)
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#75
  def after_perform(*filters, &blk); end

  # Defines a callback that will get called around the enqueuing
  # of the job.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     around_enqueue do |job, block|
  #       $statsd.time "video-job.process" do
  #         block.call
  #       end
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#167
  def around_enqueue(*filters, &blk); end

  # Defines a callback that will get called around the job's perform method.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     around_perform do |job, block|
  #       UserMailer.notify_video_started_processing(job.arguments.first)
  #       block.call
  #       UserMailer.notify_video_processed(job.arguments.first)
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # You can access the return value of the job only if the execution wasn't halted.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     around_perform do |job, block|
  #       value = block.call
  #       puts value # => "Hello World!"
  #     end
  #
  #     def perform
  #       "Hello World!"
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#108
  def around_perform(*filters, &blk); end

  # Defines a callback that will get called right before the
  # job is enqueued.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     before_enqueue do |job|
  #       $statsd.increment "enqueue-video-job.try"
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#127
  def before_enqueue(*filters, &blk); end

  # Defines a callback that will get called right before the
  # job's perform method is executed.
  #
  #   class VideoProcessJob < ActiveJob::Base
  #     queue_as :default
  #
  #     before_perform do |job|
  #       UserMailer.notify_video_started_processing(job.arguments.first)
  #     end
  #
  #     def perform(video_id)
  #       Video.find(video_id).process
  #     end
  #   end
  #
  # source://activejob//lib/active_job/callbacks.rb#56
  def before_perform(*filters, &blk); end
end

class ActiveJob::ConfiguredJob
  # @return [ConfiguredJob] a new instance of ConfiguredJob
  #
  # source://activejob//lib/active_job/configured_job.rb#5
  def initialize(job_class, options = T.unsafe(nil)); end

  # source://activejob//lib/active_job/configured_job.rb#14
  def perform_later(*_arg0, **_arg1, &_arg2); end

  # source://activejob//lib/active_job/configured_job.rb#10
  def perform_now(*_arg0, **_arg1, &_arg2); end
end

# Provides general behavior that will be included into every Active Job
# object that inherits from ActiveJob::Base.
module ActiveJob::Core
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveJob::Core::ClassMethods

  # Creates a new job instance. Takes the arguments that will be
  # passed to the perform method.
  #
  # source://activejob//lib/active_job/core.rb#91
  def initialize(*arguments, **_arg1); end

  # Job arguments
  #
  # source://activejob//lib/active_job/core.rb#10
  def arguments; end

  # Job arguments
  #
  # source://activejob//lib/active_job/core.rb#10
  def arguments=(_arg0); end

  # Attaches the stored job data to the current instance. Receives a hash
  # returned from +serialize+
  #
  # ==== Examples
  #
  #    class DeliverWebhookJob < ActiveJob::Base
  #      attr_writer :attempt_number
  #
  #      def attempt_number
  #        @attempt_number ||= 0
  #      end
  #
  #      def serialize
  #        super.merge('attempt_number' => attempt_number + 1)
  #      end
  #
  #      def deserialize(job_data)
  #        super
  #        self.attempt_number = job_data['attempt_number']
  #      end
  #
  #      rescue_from(Timeout::Error) do |exception|
  #        raise exception if attempt_number > 5
  #        retry_job(wait: 10)
  #      end
  #    end
  #
  # source://activejob//lib/active_job/core.rb#146
  def deserialize(job_data); end

  # Track any exceptions raised by the backend so callers can inspect the errors.
  #
  # source://activejob//lib/active_job/core.rb#54
  def enqueue_error; end

  # Track any exceptions raised by the backend so callers can inspect the errors.
  #
  # source://activejob//lib/active_job/core.rb#54
  def enqueue_error=(_arg0); end

  # Track when a job was enqueued
  #
  # source://activejob//lib/active_job/core.rb#44
  def enqueued_at; end

  # Track when a job was enqueued
  #
  # source://activejob//lib/active_job/core.rb#44
  def enqueued_at=(_arg0); end

  # Hash that contains the number of times this job handled errors for each specific retry_on declaration.
  # Keys are the string representation of the exceptions listed in the retry_on declaration,
  # while its associated value holds the number of executions where the corresponding retry_on
  # declaration handled one of its listed exceptions.
  #
  # source://activejob//lib/active_job/core.rb#35
  def exception_executions; end

  # Hash that contains the number of times this job handled errors for each specific retry_on declaration.
  # Keys are the string representation of the exceptions listed in the retry_on declaration,
  # while its associated value holds the number of executions where the corresponding retry_on
  # declaration handled one of its listed exceptions.
  #
  # source://activejob//lib/active_job/core.rb#35
  def exception_executions=(_arg0); end

  # Number of times this job has been executed (which increments on every retry, like after an exception).
  #
  # source://activejob//lib/active_job/core.rb#29
  def executions; end

  # Number of times this job has been executed (which increments on every retry, like after an exception).
  #
  # source://activejob//lib/active_job/core.rb#29
  def executions=(_arg0); end

  # Job Identifier
  #
  # source://activejob//lib/active_job/core.rb#17
  def job_id; end

  # Job Identifier
  #
  # source://activejob//lib/active_job/core.rb#17
  def job_id=(_arg0); end

  # I18n.locale to be used during the job.
  #
  # source://activejob//lib/active_job/core.rb#38
  def locale; end

  # I18n.locale to be used during the job.
  #
  # source://activejob//lib/active_job/core.rb#38
  def locale=(_arg0); end

  # Priority that the job will have (lower is more priority).
  #
  # source://activejob//lib/active_job/core.rb#23
  def priority=(_arg0); end

  # ID optionally provided by adapter
  #
  # source://activejob//lib/active_job/core.rb#26
  def provider_job_id; end

  # ID optionally provided by adapter
  #
  # source://activejob//lib/active_job/core.rb#26
  def provider_job_id=(_arg0); end

  # Queue in which the job will reside.
  #
  # source://activejob//lib/active_job/core.rb#20
  def queue_name=(_arg0); end

  # Timestamp when the job should be performed
  #
  # source://activejob//lib/active_job/core.rb#14
  def scheduled_at; end

  # Timestamp when the job should be performed
  #
  # source://activejob//lib/active_job/core.rb#14
  def scheduled_at=(_arg0); end

  # Returns a hash with the job data that can safely be passed to the
  # queuing adapter.
  #
  # source://activejob//lib/active_job/core.rb#104
  def serialize; end

  # Sets the attribute serialized_arguments
  #
  # @param value the value to set the attribute serialized_arguments to.
  #
  # source://activejob//lib/active_job/core.rb#11
  def serialized_arguments=(_arg0); end

  # Configures the job with the given options.
  #
  # source://activejob//lib/active_job/core.rb#160
  def set(options = T.unsafe(nil)); end

  # Track whether the adapter received the job successfully.
  #
  # source://activejob//lib/active_job/core.rb#47
  def successfully_enqueued=(_arg0); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/core.rb#49
  def successfully_enqueued?; end

  # Timezone to be used during the job.
  #
  # source://activejob//lib/active_job/core.rb#41
  def timezone; end

  # Timezone to be used during the job.
  #
  # source://activejob//lib/active_job/core.rb#41
  def timezone=(_arg0); end

  private

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/core.rb#193
  def arguments_serialized?; end

  # source://activejob//lib/active_job/core.rb#189
  def deserialize_arguments(serialized_args); end

  # source://activejob//lib/active_job/core.rb#178
  def deserialize_arguments_if_needed; end

  # source://activejob//lib/active_job/core.rb#185
  def serialize_arguments(arguments); end

  # source://activejob//lib/active_job/core.rb#170
  def serialize_arguments_if_needed(arguments); end
end

# These methods will be included into any Active Job object, adding
# helpers for de/serialization and creation of job instances.
module ActiveJob::Core::ClassMethods
  # Creates a new job instance from a hash created with +serialize+
  #
  # source://activejob//lib/active_job/core.rb#60
  def deserialize(job_data); end

  # Creates a job preconfigured with the given options. You can call
  # perform_later with the job arguments to enqueue the job with the
  # preconfigured options
  #
  # ==== Options
  # * <tt>:wait</tt> - Enqueues the job with the specified delay
  # * <tt>:wait_until</tt> - Enqueues the job at the time specified
  # * <tt>:queue</tt> - Enqueues the job on the specified queue
  # * <tt>:priority</tt> - Enqueues the job with the specified priority
  #
  # ==== Examples
  #
  #    VideoJob.set(queue: :some_queue).perform_later(Video.last)
  #    VideoJob.set(wait: 5.minutes).perform_later(Video.last)
  #    VideoJob.set(wait_until: Time.now.tomorrow).perform_later(Video.last)
  #    VideoJob.set(queue: :some_queue, wait: 5.minutes).perform_later(Video.last)
  #    VideoJob.set(queue: :some_queue, wait_until: Time.now.tomorrow).perform_later(Video.last)
  #    VideoJob.set(queue: :some_queue, wait: 5.minutes, priority: 10).perform_later(Video.last)
  #
  # source://activejob//lib/active_job/core.rb#84
  def set(options = T.unsafe(nil)); end
end

# Raised when an exception is raised during job arguments deserialization.
#
# Wraps the original exception raised as +cause+.
class ActiveJob::DeserializationError < ::StandardError
  # @return [DeserializationError] a new instance of DeserializationError
  #
  # source://activejob//lib/active_job/arguments.rb#11
  def initialize; end
end

# Can be raised by adapters if they wish to communicate to the caller a reason
# why the adapter was unexpectedly unable to enqueue a job.
class ActiveJob::EnqueueError < ::StandardError; end

module ActiveJob::Enqueuing
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveJob::Enqueuing::ClassMethods

  # Enqueues the job to be performed by the queue adapter.
  #
  # ==== Options
  # * <tt>:wait</tt> - Enqueues the job with the specified delay
  # * <tt>:wait_until</tt> - Enqueues the job at the time specified
  # * <tt>:queue</tt> - Enqueues the job on the specified queue
  # * <tt>:priority</tt> - Enqueues the job with the specified priority
  #
  # ==== Examples
  #
  #    my_job_instance.enqueue
  #    my_job_instance.enqueue wait: 5.minutes
  #    my_job_instance.enqueue queue: :important
  #    my_job_instance.enqueue wait_until: Date.tomorrow.midnight
  #    my_job_instance.enqueue priority: 10
  #
  # source://activejob//lib/active_job/enqueuing.rb#59
  def enqueue(options = T.unsafe(nil)); end
end

# Includes the +perform_later+ method for job initialization.
module ActiveJob::Enqueuing::ClassMethods
  # Push a job onto the queue. By default the arguments must be either String,
  # Integer, Float, NilClass, TrueClass, FalseClass, BigDecimal, Symbol, Date,
  # Time, DateTime, ActiveSupport::TimeWithZone, ActiveSupport::Duration,
  # Hash, ActiveSupport::HashWithIndifferentAccess, Array, Range, or
  # GlobalID::Identification instances, although this can be extended by adding
  # custom serializers.
  #
  # Returns an instance of the job class queued with arguments available in
  # Job#arguments or false if the enqueue did not succeed.
  #
  # After the attempted enqueue, the job will be yielded to an optional block.
  #
  # @yield [job]
  #
  # source://activejob//lib/active_job/enqueuing.rb#28
  def perform_later(*_arg0, **_arg1, &_arg2); end

  private

  # source://activejob//lib/active_job/enqueuing.rb#38
  def job_or_instantiate(*args, **_arg1); end
end

# Provides behavior for retrying and discarding jobs on exceptions.
module ActiveJob::Exceptions
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveJob::Exceptions::ClassMethods

  # Reschedules the job to be re-executed. This is useful in combination
  # with the +rescue_from+ option. When you rescue an exception from your job
  # you can ask Active Job to retry performing your job.
  #
  # ==== Options
  # * <tt>:wait</tt> - Enqueues the job with the specified delay in seconds
  # * <tt>:wait_until</tt> - Enqueues the job at the time specified
  # * <tt>:queue</tt> - Enqueues the job on the specified queue
  # * <tt>:priority</tt> - Enqueues the job with the specified priority
  #
  # ==== Examples
  #
  #  class SiteScraperJob < ActiveJob::Base
  #    rescue_from(ErrorLoadingSite) do
  #      retry_job queue: :low_priority
  #    end
  #
  #    def perform(*args)
  #      # raise ErrorLoadingSite if cannot scrape
  #    end
  #  end
  #
  # source://activejob//lib/active_job/exceptions.rb#124
  def retry_job(options = T.unsafe(nil)); end

  private

  # source://activejob//lib/active_job/exceptions.rb#134
  def determine_delay(seconds_or_duration_or_algorithm:, executions:, jitter: T.unsafe(nil)); end

  # source://activejob//lib/active_job/exceptions.rb#154
  def determine_jitter_for_delay(delay, jitter); end

  # source://activejob//lib/active_job/exceptions.rb#159
  def executions_for(exceptions); end

  module GeneratedClassMethods
    def retry_jitter; end
    def retry_jitter=(value); end
  end

  module GeneratedInstanceMethods; end
end

module ActiveJob::Exceptions::ClassMethods
  # Discard the job with no attempts to retry, if the exception is raised. This is useful when the subject of the job,
  # like an Active Record, is no longer available, and the job is thus no longer relevant.
  #
  # You can also pass a block that'll be invoked. This block is yielded with the job instance as the first and the error instance as the second parameter.
  #
  # ==== Example
  #
  #  class SearchIndexingJob < ActiveJob::Base
  #    discard_on ActiveJob::DeserializationError
  #    discard_on(CustomAppException) do |job, error|
  #      ExceptionNotifier.caught(error)
  #    end
  #
  #    def perform(record)
  #      # Will raise ActiveJob::DeserializationError if the record can't be deserialized
  #      # Might raise CustomAppException for something domain specific
  #    end
  #  end
  #
  # source://activejob//lib/active_job/exceptions.rb#94
  def discard_on(*exceptions); end

  # Catch the exception and reschedule job for re-execution after so many seconds, for a specific number of attempts.
  # If the exception keeps getting raised beyond the specified number of attempts, the exception is allowed to
  # bubble up to the underlying queuing system, which may have its own retry mechanism or place it in a
  # holding queue for inspection.
  #
  # You can also pass a block that'll be invoked if the retry attempts fail for custom logic rather than letting
  # the exception bubble up. This block is yielded with the job instance as the first and the error instance as the second parameter.
  #
  # ==== Options
  # * <tt>:wait</tt> - Re-enqueues the job with a delay specified either in seconds (default: 3 seconds),
  #   as a computing proc that takes the number of executions so far as an argument, or as a symbol reference of
  #   <tt>:exponentially_longer</tt>, which applies the wait algorithm of <tt>((executions**4) + (Kernel.rand * (executions**4) * jitter)) + 2</tt>
  #   (first wait ~3s, then ~18s, then ~83s, etc)
  # * <tt>:attempts</tt> - Re-enqueues the job the specified number of times (default: 5 attempts) or a symbol reference of <tt>:unlimited</tt>
  #   to retry the job until it succeeds
  # * <tt>:queue</tt> - Re-enqueues the job on a different queue
  # * <tt>:priority</tt> - Re-enqueues the job with a different priority
  # * <tt>:jitter</tt> - A random delay of wait time used when calculating backoff. The default is 15% (0.15) which represents the upper bound of possible wait time (expressed as a percentage)
  #
  # ==== Examples
  #
  #  class RemoteServiceJob < ActiveJob::Base
  #    retry_on CustomAppException # defaults to ~3s wait, 5 attempts
  #    retry_on AnotherCustomAppException, wait: ->(executions) { executions * 2 }
  #    retry_on CustomInfrastructureException, wait: 5.minutes, attempts: :unlimited
  #
  #    retry_on ActiveRecord::Deadlocked, wait: 5.seconds, attempts: 3
  #    retry_on Net::OpenTimeout, Timeout::Error, wait: :exponentially_longer, attempts: 10 # retries at most 10 times for Net::OpenTimeout and Timeout::Error combined
  #    # To retry at most 10 times for each individual exception:
  #    # retry_on Net::OpenTimeout, wait: :exponentially_longer, attempts: 10
  #    # retry_on Net::ReadTimeout, wait: 5.seconds, jitter: 0.30, attempts: 10
  #    # retry_on Timeout::Error, wait: :exponentially_longer, attempts: 10
  #
  #    retry_on(YetAnotherCustomAppException) do |job, error|
  #      ExceptionNotifier.caught(error)
  #    end
  #
  #    def perform(*args)
  #      # Might raise CustomAppException, AnotherCustomAppException, or YetAnotherCustomAppException for something domain specific
  #      # Might raise ActiveRecord::Deadlocked when a local db deadlock is detected
  #      # Might raise Net::OpenTimeout or Timeout::Error when the remote service is down
  #    end
  #  end
  #
  # source://activejob//lib/active_job/exceptions.rb#58
  def retry_on(*exceptions, wait: T.unsafe(nil), attempts: T.unsafe(nil), queue: T.unsafe(nil), priority: T.unsafe(nil), jitter: T.unsafe(nil)); end
end

# source://activejob//lib/active_job/exceptions.rb#131
ActiveJob::Exceptions::JITTER_DEFAULT = T.let(T.unsafe(nil), Object)

module ActiveJob::Execution
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Rescuable

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Rescuable::ClassMethods
  mixes_in_class_methods ::ActiveJob::Execution::ClassMethods

  # source://activejob//lib/active_job/execution.rb#51
  def perform(*_arg0); end

  # Performs the job immediately. The job is not sent to the queuing adapter
  # but directly executed by blocking the execution of others until it's finished.
  # +perform_now+ returns the value of your job's +perform+ method.
  #
  #   class MyJob < ActiveJob::Base
  #     def perform
  #       "Hello World!"
  #     end
  #   end
  #
  #   puts MyJob.new(*args).perform_now # => "Hello World!"
  #
  # source://activejob//lib/active_job/execution.rb#40
  def perform_now; end

  private

  # source://activejob//lib/active_job/execution.rb#56
  def _perform_job; end

  module GeneratedClassMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end

  module GeneratedInstanceMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end
end

# Includes methods for executing and performing jobs instantly.
module ActiveJob::Execution::ClassMethods
  # source://activejob//lib/active_job/execution.rb#21
  def execute(job_data); end

  # Performs the job immediately.
  #
  #   MyJob.perform_now("mike")
  #
  # source://activejob//lib/active_job/execution.rb#17
  def perform_now(*_arg0, **_arg1, &_arg2); end
end

module ActiveJob::Instrumentation
  extend ::ActiveSupport::Concern

  # source://activejob//lib/active_job/instrumentation.rb#13
  def perform_now; end

  private

  # source://activejob//lib/active_job/instrumentation.rb#18
  def _perform_job; end

  # source://activejob//lib/active_job/instrumentation.rb#39
  def halted_callback_hook(*_arg0); end

  # source://activejob//lib/active_job/instrumentation.rb#23
  def instrument(operation, payload = T.unsafe(nil), &block); end
end

class ActiveJob::LogSubscriber < ::ActiveSupport::LogSubscriber
  # source://activejob//lib/active_job/log_subscriber.rb#94
  def discard(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#8
  def enqueue(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#27
  def enqueue_at(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#71
  def enqueue_retry(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#53
  def perform(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#46
  def perform_start(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#85
  def retry_stopped(event); end

  private

  # source://activejob//lib/active_job/log_subscriber.rb#108
  def args_info(job); end

  # source://activejob//lib/active_job/log_subscriber.rb#117
  def format(arg); end

  # source://activejob//lib/active_job/log_subscriber.rb#134
  def logger; end

  # source://activejob//lib/active_job/log_subscriber.rb#104
  def queue_name(event); end

  # source://activejob//lib/active_job/log_subscriber.rb#130
  def scheduled_at(event); end
end

module ActiveJob::Logging
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods

  # source://activejob//lib/active_job/logging.rb#17
  def perform_now; end

  private

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/logging.rb#31
  def logger_tagged_by_active_job?; end

  # source://activejob//lib/active_job/logging.rb#22
  def tag_logger(*tags, &block); end

  module GeneratedClassMethods
    def log_arguments; end
    def log_arguments=(value); end
    def log_arguments?; end
  end

  module GeneratedInstanceMethods; end
end

# The <tt>ActiveJob::QueueAdapter</tt> module is used to load the
# correct adapter. The default queue adapter is the +:async+ queue.
module ActiveJob::QueueAdapter
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveJob::QueueAdapter::ClassMethods

  module GeneratedClassMethods
    def _queue_adapter; end
    def _queue_adapter=(value); end
    def _queue_adapter_name; end
    def _queue_adapter_name=(value); end
  end

  module GeneratedInstanceMethods; end
end

# Includes the setter method for changing the active queue adapter.
module ActiveJob::QueueAdapter::ClassMethods
  # Returns the backend queue provider. The default queue adapter
  # is the +:async+ queue. See QueueAdapters for more information.
  #
  # source://activejob//lib/active_job/queue_adapter.rb#24
  def queue_adapter; end

  # Specify the backend queue provider. The default queue adapter
  # is the +:async+ queue. See QueueAdapters for more
  # information.
  #
  # source://activejob//lib/active_job/queue_adapter.rb#37
  def queue_adapter=(name_or_adapter); end

  # Returns string denoting the name of the configured queue adapter.
  # By default returns <tt>"async"</tt>.
  #
  # source://activejob//lib/active_job/queue_adapter.rb#30
  def queue_adapter_name; end

  private

  # source://activejob//lib/active_job/queue_adapter.rb#53
  def assign_adapter(adapter_name, queue_adapter); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/queue_adapter.rb#60
  def queue_adapter?(object); end
end

# source://activejob//lib/active_job/queue_adapter.rb#58
ActiveJob::QueueAdapter::ClassMethods::QUEUE_ADAPTER_METHODS = T.let(T.unsafe(nil), Array)

# == Active Job adapters
#
# Active Job has adapters for the following queuing backends:
#
# * {Backburner}[https://github.com/nesquena/backburner]
# * {Delayed Job}[https://github.com/collectiveidea/delayed_job]
# * {Que}[https://github.com/chanks/que]
# * {queue_classic}[https://github.com/QueueClassic/queue_classic]
# * {Resque}[https://github.com/resque/resque]
# * {Sidekiq}[https://sidekiq.org]
# * {Sneakers}[https://github.com/jondot/sneakers]
# * {Sucker Punch}[https://github.com/brandonhilkert/sucker_punch]
# * {Active Job Async Job}[https://api.rubyonrails.org/classes/ActiveJob/QueueAdapters/AsyncAdapter.html]
# * {Active Job Inline}[https://api.rubyonrails.org/classes/ActiveJob/QueueAdapters/InlineAdapter.html]
# * Please Note: We are not accepting pull requests for new adapters. See the {README}[link:files/activejob/README_md.html] for more details.
#
# === Backends Features
#
#   |                   | Async | Queues | Delayed    | Priorities | Timeout | Retries |
#   |-------------------|-------|--------|------------|------------|---------|---------|
#   | Backburner        | Yes   | Yes    | Yes        | Yes        | Job     | Global  |
#   | Delayed Job       | Yes   | Yes    | Yes        | Job        | Global  | Global  |
#   | Que               | Yes   | Yes    | Yes        | Job        | No      | Job     |
#   | queue_classic     | Yes   | Yes    | Yes*       | No         | No      | No      |
#   | Resque            | Yes   | Yes    | Yes (Gem)  | Queue      | Global  | Yes     |
#   | Sidekiq           | Yes   | Yes    | Yes        | Queue      | No      | Job     |
#   | Sneakers          | Yes   | Yes    | No         | Queue      | Queue   | No      |
#   | Sucker Punch      | Yes   | Yes    | Yes        | No         | No      | No      |
#   | Active Job Async  | Yes   | Yes    | Yes        | No         | No      | No      |
#   | Active Job Inline | No    | Yes    | N/A        | N/A        | N/A     | N/A     |
#
# ==== Async
#
# Yes: The Queue Adapter has the ability to run the job in a non-blocking manner.
# It either runs on a separate or forked process, or on a different thread.
#
# No: The job is run in the same process.
#
# ==== Queues
#
# Yes: Jobs may set which queue they are run in with queue_as or by using the set
# method.
#
# ==== Delayed
#
# Yes: The adapter will run the job in the future through perform_later.
#
# (Gem): An additional gem is required to use perform_later with this adapter.
#
# No: The adapter will run jobs at the next opportunity and cannot use perform_later.
#
# N/A: The adapter does not support queuing.
#
# NOTE:
# queue_classic supports job scheduling since version 3.1.
# For older versions you can use the queue_classic-later gem.
#
# ==== Priorities
#
# The order in which jobs are processed can be configured differently depending
# on the adapter.
#
# Job: Any class inheriting from the adapter may set the priority on the job
# object relative to other jobs.
#
# Queue: The adapter can set the priority for job queues, when setting a queue
# with Active Job this will be respected.
#
# Yes: Allows the priority to be set on the job object, at the queue level or
# as default configuration option.
#
# No: The adapter does not allow the priority of jobs to be configured.
#
# N/A: The adapter does not support queuing, and therefore sorting them.
#
# ==== Timeout
#
# When a job will stop after the allotted time.
#
# Job: The timeout can be set for each instance of the job class.
#
# Queue: The timeout is set for all jobs on the queue.
#
# Global: The adapter is configured that all jobs have a maximum run time.
#
# No: The adapter does not allow the timeout of jobs to be configured.
#
# N/A: This adapter does not run in a separate process, and therefore timeout
# is unsupported.
#
# ==== Retries
#
# Job: The number of retries can be set per instance of the job class.
#
# Yes: The Number of retries can be configured globally, for each instance or
# on the queue. This adapter may also present failed instances of the job class
# that can be restarted.
#
# Global: The adapter has a global number of retries.
#
# No: The adapter does not allow the number of retries to be configured.
#
# N/A: The adapter does not run in a separate process, and therefore doesn't
# support retries.
#
# === Async and Inline Queue Adapters
#
# Active Job has two built-in queue adapters intended for development and
# testing: +:async+ and +:inline+.
module ActiveJob::QueueAdapters
  extend ::ActiveSupport::Autoload

  class << self
    # Returns adapter for specified name.
    #
    #   ActiveJob::QueueAdapters.lookup(:sidekiq)
    #   # => ActiveJob::QueueAdapters::SidekiqAdapter
    #
    # source://activejob//lib/active_job/queue_adapters.rb#136
    def lookup(name); end
  end
end

# source://activejob//lib/active_job/queue_adapters.rb#128
ActiveJob::QueueAdapters::ADAPTER = T.let(T.unsafe(nil), String)

# == Active Job Async adapter
#
# The Async adapter runs jobs with an in-process thread pool.
#
# This is the default queue adapter. It's well-suited for dev/test since
# it doesn't need an external infrastructure, but it's a poor fit for
# production since it drops pending jobs on restart.
#
# To use this adapter, set queue adapter to +:async+:
#
#   config.active_job.queue_adapter = :async
#
# To configure the adapter's thread pool, instantiate the adapter and
# pass your own config:
#
#   config.active_job.queue_adapter = ActiveJob::QueueAdapters::AsyncAdapter.new \
#     min_threads: 1,
#     max_threads: 2 * Concurrent.processor_count,
#     idletime: 600.seconds
#
# The adapter uses a {Concurrent Ruby}[https://github.com/ruby-concurrency/concurrent-ruby] thread pool to schedule and execute
# jobs. Since jobs share a single thread pool, long-running jobs will block
# short-lived jobs. Fine for dev/test; bad for production.
class ActiveJob::QueueAdapters::AsyncAdapter
  # See {Concurrent::ThreadPoolExecutor}[https://ruby-concurrency.github.io/concurrent-ruby/master/Concurrent/ThreadPoolExecutor.html] for executor options.
  #
  # @return [AsyncAdapter] a new instance of AsyncAdapter
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#35
  def initialize(**executor_options); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#39
  def enqueue(job); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#43
  def enqueue_at(job, timestamp); end

  # Used for our test suite.
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#55
  def immediate=(immediate); end

  # Gracefully stop processing jobs. Finishes in-progress work and handles
  # any new jobs following the executor's fallback policy (`caller_runs`).
  # Waits for termination by default. Pass `wait: false` to continue.
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#50
  def shutdown(wait: T.unsafe(nil)); end
end

# Note that we don't actually need to serialize the jobs since we're
# performing them in-process, but we do so anyway for parity with other
# adapters and deployment environments. Otherwise, serialization bugs
# may creep in undetected.
class ActiveJob::QueueAdapters::AsyncAdapter::JobWrapper
  # @return [JobWrapper] a new instance of JobWrapper
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#64
  def initialize(job); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#69
  def perform; end
end

class ActiveJob::QueueAdapters::AsyncAdapter::Scheduler
  # @return [Scheduler] a new instance of Scheduler
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#86
  def initialize(**options); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#92
  def enqueue(job, queue_name:); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#96
  def enqueue_at(job, timestamp, queue_name:); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#110
  def executor; end

  # Returns the value of attribute immediate.
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#84
  def immediate; end

  # Sets the attribute immediate
  #
  # @param value the value to set the attribute immediate to.
  #
  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#84
  def immediate=(_arg0); end

  # source://activejob//lib/active_job/queue_adapters/async_adapter.rb#105
  def shutdown(wait: T.unsafe(nil)); end
end

# source://activejob//lib/active_job/queue_adapters/async_adapter.rb#75
ActiveJob::QueueAdapters::AsyncAdapter::Scheduler::DEFAULT_EXECUTOR_OPTIONS = T.let(T.unsafe(nil), Hash)

# == Active Job Inline adapter
#
# When enqueuing jobs with the Inline adapter the job will be executed
# immediately.
#
# To use the Inline set the queue_adapter config to +:inline+.
#
#   Rails.application.config.active_job.queue_adapter = :inline
class ActiveJob::QueueAdapters::InlineAdapter
  # source://activejob//lib/active_job/queue_adapters/inline_adapter.rb#14
  def enqueue(job); end

  # @raise [NotImplementedError]
  #
  # source://activejob//lib/active_job/queue_adapters/inline_adapter.rb#18
  def enqueue_at(*_arg0); end
end

# == Sidekiq adapter for Active Job
#
# Simple, efficient background processing for Ruby. Sidekiq uses threads to
# handle many jobs at the same time in the same process. It does not
# require Rails but will integrate tightly with it to make background
# processing dead simple.
#
# Read more about Sidekiq {here}[http://sidekiq.org].
#
# To use Sidekiq set the queue_adapter config to +:sidekiq+.
#
#   Rails.application.config.active_job.queue_adapter = :sidekiq
class ActiveJob::QueueAdapters::SidekiqAdapter
  # source://activejob//lib/active_job/queue_adapters/sidekiq_adapter.rb#20
  def enqueue(job); end

  # source://activejob//lib/active_job/queue_adapters/sidekiq_adapter.rb#29
  def enqueue_at(job, timestamp); end
end

class ActiveJob::QueueAdapters::SidekiqAdapter::JobWrapper
  include ::Sidekiq::Worker
  include ::Sidekiq::Worker::Options
  extend ::Sidekiq::Worker::Options::ClassMethods
  extend ::Sidekiq::Worker::ClassMethods

  # source://activejob//lib/active_job/queue_adapters/sidekiq_adapter.rb#41
  def perform(job_data); end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#137
  def sidekiq_options_hash; end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#149
  def sidekiq_options_hash=(_arg0); end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#137
  def sidekiq_retries_exhausted_block; end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#149
  def sidekiq_retries_exhausted_block=(_arg0); end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#137
  def sidekiq_retry_in_block; end

  # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#149
  def sidekiq_retry_in_block=(_arg0); end

  class << self
    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#104
    def sidekiq_options_hash; end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#112
    def sidekiq_options_hash=(val); end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#104
    def sidekiq_retries_exhausted_block; end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#112
    def sidekiq_retries_exhausted_block=(val); end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#104
    def sidekiq_retry_in_block; end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#112
    def sidekiq_retry_in_block=(val); end

    private

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#99
    def __synchronized_sidekiq_options_hash; end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#99
    def __synchronized_sidekiq_retries_exhausted_block; end

    # source://sidekiq/6.5.8/lib/sidekiq/worker.rb#99
    def __synchronized_sidekiq_retry_in_block; end
  end
end

# == Test adapter for Active Job
#
# The test adapter should be used only in testing. Along with
# ActiveJob::TestCase and ActiveJob::TestHelper
# it makes a great tool to test your Rails application.
#
# To use the test adapter set +queue_adapter+ config to +:test+.
#
#   Rails.application.config.active_job.queue_adapter = :test
class ActiveJob::QueueAdapters::TestAdapter
  # Returns the value of attribute at.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def at; end

  # Sets the attribute at
  #
  # @param value the value to set the attribute at to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def at=(_arg0); end

  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#28
  def enqueue(job); end

  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#33
  def enqueue_at(job, timestamp); end

  # Provides a store of all the enqueued jobs with the TestAdapter so you can check them.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#19
  def enqueued_jobs; end

  # Sets the attribute enqueued_jobs
  #
  # @param value the value to set the attribute enqueued_jobs to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#16
  def enqueued_jobs=(_arg0); end

  # Returns the value of attribute filter.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def filter; end

  # Sets the attribute filter
  #
  # @param value the value to set the attribute filter to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def filter=(_arg0); end

  # Returns the value of attribute perform_enqueued_at_jobs.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def perform_enqueued_at_jobs; end

  # Sets the attribute perform_enqueued_at_jobs
  #
  # @param value the value to set the attribute perform_enqueued_at_jobs to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def perform_enqueued_at_jobs=(_arg0); end

  # Returns the value of attribute perform_enqueued_jobs.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def perform_enqueued_jobs; end

  # Sets the attribute perform_enqueued_jobs
  #
  # @param value the value to set the attribute perform_enqueued_jobs to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def perform_enqueued_jobs=(_arg0); end

  # Provides a store of all the performed jobs with the TestAdapter so you can check them.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#24
  def performed_jobs; end

  # Sets the attribute performed_jobs
  #
  # @param value the value to set the attribute performed_jobs to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#16
  def performed_jobs=(_arg0); end

  # Returns the value of attribute queue.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def queue; end

  # Sets the attribute queue
  #
  # @param value the value to set the attribute queue to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def queue=(_arg0); end

  # Returns the value of attribute reject.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def reject; end

  # Sets the attribute reject
  #
  # @param value the value to set the attribute reject to.
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#15
  def reject=(_arg0); end

  private

  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#79
  def filter_as_proc(filter); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#57
  def filtered?(job); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#71
  def filtered_job_class?(job); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#65
  def filtered_queue?(job); end

  # @return [Boolean]
  #
  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#61
  def filtered_time?(job); end

  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#39
  def job_to_hash(job, extras = T.unsafe(nil)); end

  # source://activejob//lib/active_job/queue_adapters/test_adapter.rb#48
  def perform_or_enqueue(perform, job, job_data); end
end

module ActiveJob::QueueName
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveJob::QueueName::ClassMethods

  # Returns the name of the queue the job will be run on.
  #
  # source://activejob//lib/active_job/queue_name.rb#62
  def queue_name; end

  module GeneratedClassMethods
    def queue_name; end
    def queue_name=(value); end
    def queue_name?; end
    def queue_name_delimiter; end
    def queue_name_delimiter=(value); end
    def queue_name_delimiter?; end
    def queue_name_prefix; end
    def queue_name_prefix=(value); end
    def queue_name_prefix?; end
  end

  module GeneratedInstanceMethods
    def queue_name_prefix; end
    def queue_name_prefix=(value); end
    def queue_name_prefix?; end
  end
end

# Includes the ability to override the default queue name and prefix.
module ActiveJob::QueueName::ClassMethods
  # source://activejob//lib/active_job/queue_name.rb#9
  def default_queue_name; end

  # source://activejob//lib/active_job/queue_name.rb#9
  def default_queue_name=(val); end

  # Specifies the name of the queue to process the job on.
  #
  #   class PublishToFeedJob < ActiveJob::Base
  #     queue_as :feeds
  #
  #     def perform(post)
  #       post.to_feed!
  #     end
  #   end
  #
  # Can be given a block that will evaluate in the context of the job
  # allowing +self.arguments+ to be accessed so that a dynamic queue name
  # can be applied:
  #
  #   class PublishToFeedJob < ApplicationJob
  #     queue_as do
  #       post = self.arguments.first
  #
  #       if post.paid?
  #         :paid_feeds
  #       else
  #         :feeds
  #       end
  #     end
  #
  #     def perform(post)
  #       post.to_feed!
  #     end
  #   end
  #
  # source://activejob//lib/active_job/queue_name.rb#40
  def queue_as(part_name = T.unsafe(nil), &block); end

  # source://activejob//lib/active_job/queue_name.rb#48
  def queue_name_from_part(part_name); end

  class << self
    # source://activejob//lib/active_job/queue_name.rb#9
    def default_queue_name; end

    # source://activejob//lib/active_job/queue_name.rb#9
    def default_queue_name=(val); end
  end
end

module ActiveJob::QueuePriority
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveJob::QueuePriority::ClassMethods

  # Returns the priority that the job will be created with
  #
  # source://activejob//lib/active_job/queue_priority.rb#36
  def priority; end

  module GeneratedClassMethods
    def priority; end
    def priority=(value); end
    def priority?; end
  end

  module GeneratedInstanceMethods; end
end

# Includes the ability to override the default queue priority.
module ActiveJob::QueuePriority::ClassMethods
  # source://activejob//lib/active_job/queue_priority.rb#9
  def default_priority; end

  # source://activejob//lib/active_job/queue_priority.rb#9
  def default_priority=(val); end

  # Specifies the priority of the queue to create the job with.
  #
  #   class PublishToFeedJob < ActiveJob::Base
  #     queue_with_priority 50
  #
  #     def perform(post)
  #       post.to_feed!
  #     end
  #   end
  #
  # Specify either an argument or a block.
  #
  # source://activejob//lib/active_job/queue_priority.rb#22
  def queue_with_priority(priority = T.unsafe(nil), &block); end

  class << self
    # source://activejob//lib/active_job/queue_priority.rb#9
    def default_priority; end

    # source://activejob//lib/active_job/queue_priority.rb#9
    def default_priority=(val); end
  end
end

# = Active Job Railtie
class ActiveJob::Railtie < ::Rails::Railtie; end

# Raised when an unsupported argument type is set as a job argument. We
# currently support String, Integer, Float, NilClass, TrueClass, FalseClass,
# BigDecimal, Symbol, Date, Time, DateTime, ActiveSupport::TimeWithZone,
# ActiveSupport::Duration, Hash, ActiveSupport::HashWithIndifferentAccess,
# Array, Range, or GlobalID::Identification instances, although this can be
# extended by adding custom serializers.
# Raised if you set the key for a Hash something else than a string or
# a symbol. Also raised when trying to serialize an object which can't be
# identified with a GlobalID - such as an unpersisted Active Record model.
class ActiveJob::SerializationError < ::ArgumentError; end

# The <tt>ActiveJob::Serializers</tt> module is used to store a list of known serializers
# and to add new ones. It also has helpers to serialize/deserialize objects.
module ActiveJob::Serializers
  extend ::ActiveSupport::Autoload

  # source://activejob//lib/active_job/serializers.rb#22
  def _additional_serializers; end

  # source://activejob//lib/active_job/serializers.rb#22
  def _additional_serializers=(val); end

  class << self
    # source://activejob//lib/active_job/serializers.rb#22
    def _additional_serializers; end

    # source://activejob//lib/active_job/serializers.rb#22
    def _additional_serializers=(val); end

    # Adds new serializers to a list of known serializers.
    #
    # source://activejob//lib/active_job/serializers.rb#54
    def add_serializers(*new_serializers); end

    # Returns deserialized object.
    # Will look up through all known serializers.
    # If no serializer found will raise <tt>ArgumentError</tt>.
    #
    # @raise [ArgumentError]
    #
    # source://activejob//lib/active_job/serializers.rb#38
    def deserialize(argument); end

    # Returns serialized representative of the passed object.
    # Will look up through all known serializers.
    # Raises <tt>ActiveJob::SerializationError</tt> if it can't find a proper serializer.
    #
    # @raise [SerializationError]
    #
    # source://activejob//lib/active_job/serializers.rb#29
    def serialize(argument); end

    # Returns list of known serializers.
    #
    # source://activejob//lib/active_job/serializers.rb#49
    def serializers; end
  end
end

class ActiveJob::Serializers::DateSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/date_serializer.rb#10
  def deserialize(hash); end

  # source://activejob//lib/active_job/serializers/date_serializer.rb#6
  def serialize(date); end

  private

  # source://activejob//lib/active_job/serializers/date_serializer.rb#15
  def klass; end
end

class ActiveJob::Serializers::DateTimeSerializer < ::ActiveJob::Serializers::TimeObjectSerializer
  # source://activejob//lib/active_job/serializers/date_time_serializer.rb#6
  def deserialize(hash); end

  private

  # source://activejob//lib/active_job/serializers/date_time_serializer.rb#11
  def klass; end
end

class ActiveJob::Serializers::DurationSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/duration_serializer.rb#10
  def deserialize(hash); end

  # source://activejob//lib/active_job/serializers/duration_serializer.rb#6
  def serialize(duration); end

  private

  # source://activejob//lib/active_job/serializers/duration_serializer.rb#18
  def klass; end
end

class ActiveJob::Serializers::ModuleSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/module_serializer.rb#11
  def deserialize(hash); end

  # @raise [SerializationError]
  #
  # source://activejob//lib/active_job/serializers/module_serializer.rb#6
  def serialize(constant); end

  private

  # source://activejob//lib/active_job/serializers/module_serializer.rb#16
  def klass; end
end

# Base class for serializing and deserializing custom objects.
#
# Example:
#
#   class MoneySerializer < ActiveJob::Serializers::ObjectSerializer
#     def serialize(money)
#       super("amount" => money.amount, "currency" => money.currency)
#     end
#
#     def deserialize(hash)
#       Money.new(hash["amount"], hash["currency"])
#     end
#
#     private
#
#       def klass
#         Money
#       end
#   end
class ActiveJob::Serializers::ObjectSerializer
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # Deserializes an argument from a JSON primitive type.
  #
  # @raise [NotImplementedError]
  #
  # source://activejob//lib/active_job/serializers/object_serializer.rb#42
  def deserialize(json); end

  # Serializes an argument to a JSON primitive type.
  #
  # source://activejob//lib/active_job/serializers/object_serializer.rb#37
  def serialize(hash); end

  # Determines if an argument should be serialized by a serializer.
  #
  # @return [Boolean]
  #
  # source://activejob//lib/active_job/serializers/object_serializer.rb#32
  def serialize?(argument); end

  private

  # The class of the object that will be serialized.
  #
  # @raise [NotImplementedError]
  #
  # source://activejob//lib/active_job/serializers/object_serializer.rb#48
  def klass; end

  class << self
    # source://activejob//lib/active_job/serializers/object_serializer.rb#28
    def deserialize(*_arg0, **_arg1, &_arg2); end

    # source://activejob//lib/active_job/serializers/object_serializer.rb#28
    def serialize(*_arg0, **_arg1, &_arg2); end

    # source://activejob//lib/active_job/serializers/object_serializer.rb#28
    def serialize?(*_arg0, **_arg1, &_arg2); end

    private

    def allocate; end
    def new(*_arg0); end
  end
end

class ActiveJob::Serializers::RangeSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/range_serializer.rb#13
  def deserialize(hash); end

  # source://activejob//lib/active_job/serializers/range_serializer.rb#8
  def serialize(range); end

  private

  # source://activejob//lib/active_job/serializers/range_serializer.rb#18
  def klass; end
end

# source://activejob//lib/active_job/serializers/range_serializer.rb#6
ActiveJob::Serializers::RangeSerializer::KEYS = T.let(T.unsafe(nil), Array)

class ActiveJob::Serializers::SymbolSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/symbol_serializer.rb#10
  def deserialize(argument); end

  # source://activejob//lib/active_job/serializers/symbol_serializer.rb#6
  def serialize(argument); end

  private

  # source://activejob//lib/active_job/serializers/symbol_serializer.rb#15
  def klass; end
end

class ActiveJob::Serializers::TimeObjectSerializer < ::ActiveJob::Serializers::ObjectSerializer
  # source://activejob//lib/active_job/serializers/time_object_serializer.rb#8
  def serialize(time); end
end

# source://activejob//lib/active_job/serializers/time_object_serializer.rb#6
ActiveJob::Serializers::TimeObjectSerializer::NANO_PRECISION = T.let(T.unsafe(nil), Integer)

class ActiveJob::Serializers::TimeSerializer < ::ActiveJob::Serializers::TimeObjectSerializer
  # source://activejob//lib/active_job/serializers/time_serializer.rb#6
  def deserialize(hash); end

  private

  # source://activejob//lib/active_job/serializers/time_serializer.rb#11
  def klass; end
end

class ActiveJob::Serializers::TimeWithZoneSerializer < ::ActiveJob::Serializers::TimeObjectSerializer
  # source://activejob//lib/active_job/serializers/time_with_zone_serializer.rb#6
  def deserialize(hash); end

  private

  # source://activejob//lib/active_job/serializers/time_with_zone_serializer.rb#11
  def klass; end
end

class ActiveJob::TestCase < ::ActiveSupport::TestCase
  include ::ActiveJob::TestHelper
end

# Provides helper methods for testing Active Job
module ActiveJob::TestHelper
  include ::ActiveSupport::Testing::Assertions

  # source://activejob//lib/active_job/test_helper.rb#51
  def after_teardown; end

  # Asserts that the number of enqueued jobs matches the given number.
  #
  #   def test_jobs
  #     assert_enqueued_jobs 0
  #     HelloJob.perform_later('david')
  #     assert_enqueued_jobs 1
  #     HelloJob.perform_later('abdelkader')
  #     assert_enqueued_jobs 2
  #   end
  #
  # If a block is passed, asserts that the block will cause the specified number of
  # jobs to be enqueued.
  #
  #   def test_jobs_again
  #     assert_enqueued_jobs 1 do
  #       HelloJob.perform_later('cristian')
  #     end
  #
  #     assert_enqueued_jobs 2 do
  #       HelloJob.perform_later('aaron')
  #       HelloJob.perform_later('rafael')
  #     end
  #   end
  #
  # Asserts the number of times a specific job was enqueued by passing +:only+ option.
  #
  #   def test_logging_job
  #     assert_enqueued_jobs 1, only: LoggingJob do
  #       LoggingJob.perform_later
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # Asserts the number of times a job except specific class was enqueued by passing +:except+ option.
  #
  #   def test_logging_job
  #     assert_enqueued_jobs 1, except: HelloJob do
  #       LoggingJob.perform_later
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # +:only+ and +:except+ options accept Class, Array of Class, or Proc. When passed a Proc,
  # a hash containing the job's class and it's argument are passed as argument.
  #
  # Asserts the number of times a job is enqueued to a specific queue by passing +:queue+ option.
  #
  #   def test_logging_job
  #     assert_enqueued_jobs 2, queue: 'default' do
  #       LoggingJob.perform_later
  #       HelloJob.perform_later('elfassy')
  #     end
  #   end
  #
  # source://activejob//lib/active_job/test_helper.rb#123
  def assert_enqueued_jobs(number, only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # Asserts that the job has been enqueued with the given arguments.
  #
  #   def test_assert_enqueued_with
  #     MyJob.perform_later(1,2,3)
  #     assert_enqueued_with(job: MyJob, args: [1,2,3])
  #
  #     MyJob.set(wait_until: Date.tomorrow.noon, queue: "my_queue").perform_later
  #     assert_enqueued_with(at: Date.tomorrow.noon, queue: "my_queue")
  #   end
  #
  # The given arguments may also be specified as matcher procs that return a
  # boolean value indicating whether a job's attribute meets certain criteria.
  #
  # For example, a proc can be used to match a range of times:
  #
  #   def test_assert_enqueued_with
  #     at_matcher = ->(job_at) { (Date.yesterday..Date.tomorrow).cover?(job_at) }
  #
  #     MyJob.set(wait_until: Date.today.noon).perform_later
  #
  #     assert_enqueued_with(job: MyJob, at: at_matcher)
  #   end
  #
  # A proc can also be used to match a subset of a job's args:
  #
  #   def test_assert_enqueued_with
  #     args_matcher = ->(job_args) { job_args[0].key?(:foo) }
  #
  #     MyJob.perform_later(foo: "bar", other_arg: "No need to check in the test")
  #
  #     assert_enqueued_with(job: MyJob, args: args_matcher)
  #   end
  #
  # If a block is passed, asserts that the block will cause the job to be
  # enqueued with the given arguments.
  #
  #   def test_assert_enqueued_with
  #     assert_enqueued_with(job: MyJob, args: [1,2,3]) do
  #       MyJob.perform_later(1,2,3)
  #     end
  #
  #     assert_enqueued_with(job: MyJob, at: Date.tomorrow.noon) do
  #       MyJob.set(wait_until: Date.tomorrow.noon).perform_later
  #     end
  #   end
  #
  # source://activejob//lib/active_job/test_helper.rb#392
  def assert_enqueued_with(job: T.unsafe(nil), args: T.unsafe(nil), at: T.unsafe(nil), queue: T.unsafe(nil), priority: T.unsafe(nil), &block); end

  # Asserts that no jobs have been enqueued.
  #
  #   def test_jobs
  #     assert_no_enqueued_jobs
  #     HelloJob.perform_later('jeremy')
  #     assert_enqueued_jobs 1
  #   end
  #
  # If a block is passed, asserts that the block will not cause any job to be enqueued.
  #
  #   def test_jobs_again
  #     assert_no_enqueued_jobs do
  #       # No job should be enqueued from this block
  #     end
  #   end
  #
  # Asserts that no jobs of a specific kind are enqueued by passing +:only+ option.
  #
  #   def test_no_logging
  #     assert_no_enqueued_jobs only: LoggingJob do
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # Asserts that no jobs except specific class are enqueued by passing +:except+ option.
  #
  #   def test_no_logging
  #     assert_no_enqueued_jobs except: HelloJob do
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # +:only+ and +:except+ options accept Class, Array of Class, or Proc. When passed a Proc,
  # a hash containing the job's class and it's argument are passed as argument.
  #
  # Asserts that no jobs are enqueued to a specific queue by passing +:queue+ option
  #
  #   def test_no_logging
  #     assert_no_enqueued_jobs queue: 'default' do
  #       LoggingJob.set(queue: :some_queue).perform_later
  #     end
  #   end
  #
  # Note: This assertion is simply a shortcut for:
  #
  #   assert_enqueued_jobs 0, &block
  #
  # source://activejob//lib/active_job/test_helper.rb#185
  def assert_no_enqueued_jobs(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # Asserts that no jobs have been performed.
  #
  #   def test_jobs
  #     assert_no_performed_jobs
  #
  #     perform_enqueued_jobs do
  #       HelloJob.perform_later('matthew')
  #       assert_performed_jobs 1
  #     end
  #   end
  #
  # If a block is passed, asserts that the block will not cause any job to be performed.
  #
  #   def test_jobs_again
  #     assert_no_performed_jobs do
  #       # No job should be performed from this block
  #     end
  #   end
  #
  # The block form supports filtering. If the +:only+ option is specified,
  # then only the listed job(s) will not be performed.
  #
  #   def test_no_logging
  #     assert_no_performed_jobs only: LoggingJob do
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # Also if the +:except+ option is specified,
  # then the job(s) except specific class will not be performed.
  #
  #   def test_no_logging
  #     assert_no_performed_jobs except: HelloJob do
  #       HelloJob.perform_later('jeremy')
  #     end
  #   end
  #
  # +:only+ and +:except+ options accept Class, Array of Class, or Proc. When passed a Proc,
  # an instance of the job will be passed as argument.
  #
  # If the +:queue+ option is specified,
  # then only the job(s) enqueued to a specific queue will not be performed.
  #
  #   def test_assert_no_performed_jobs_with_queue_option
  #     assert_no_performed_jobs queue: :some_queue do
  #       HelloJob.set(queue: :other_queue).perform_later("jeremy")
  #     end
  #   end
  #
  # Note: This assertion is simply a shortcut for:
  #
  #   assert_performed_jobs 0, &block
  #
  # source://activejob//lib/active_job/test_helper.rb#343
  def assert_no_performed_jobs(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # Asserts that the number of performed jobs matches the given number.
  # If no block is passed, <tt>perform_enqueued_jobs</tt>
  # must be called around or after the job call.
  #
  #   def test_jobs
  #     assert_performed_jobs 0
  #
  #     perform_enqueued_jobs do
  #       HelloJob.perform_later('xavier')
  #     end
  #     assert_performed_jobs 1
  #
  #     HelloJob.perform_later('yves')
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_jobs 2
  #   end
  #
  # If a block is passed, asserts that the block will cause the specified number of
  # jobs to be performed.
  #
  #   def test_jobs_again
  #     assert_performed_jobs 1 do
  #       HelloJob.perform_later('robin')
  #     end
  #
  #     assert_performed_jobs 2 do
  #       HelloJob.perform_later('carlos')
  #       HelloJob.perform_later('sean')
  #     end
  #   end
  #
  # This method also supports filtering. If the +:only+ option is specified,
  # then only the listed job(s) will be performed.
  #
  #     def test_hello_job
  #       assert_performed_jobs 1, only: HelloJob do
  #         HelloJob.perform_later('jeremy')
  #         LoggingJob.perform_later
  #       end
  #     end
  #
  # Also if the +:except+ option is specified,
  # then the job(s) except specific class will be performed.
  #
  #     def test_hello_job
  #       assert_performed_jobs 1, except: LoggingJob do
  #         HelloJob.perform_later('jeremy')
  #         LoggingJob.perform_later
  #       end
  #     end
  #
  # An array may also be specified, to support testing multiple jobs.
  #
  #     def test_hello_and_logging_jobs
  #       assert_nothing_raised do
  #         assert_performed_jobs 2, only: [HelloJob, LoggingJob] do
  #           HelloJob.perform_later('jeremy')
  #           LoggingJob.perform_later('stewie')
  #           RescueJob.perform_later('david')
  #         end
  #       end
  #     end
  #
  # A proc may also be specified. When passed a Proc, the job's instance will be passed as argument.
  #
  #     def test_hello_and_logging_jobs
  #       assert_nothing_raised do
  #         assert_performed_jobs(1, only: ->(job) { job.is_a?(HelloJob) }) do
  #           HelloJob.perform_later('jeremy')
  #           LoggingJob.perform_later('stewie')
  #           RescueJob.perform_later('david')
  #         end
  #       end
  #     end
  #
  # If the +:queue+ option is specified,
  # then only the job(s) enqueued to a specific queue will be performed.
  #
  #     def test_assert_performed_jobs_with_queue_option
  #       assert_performed_jobs 1, queue: :some_queue do
  #         HelloJob.set(queue: :some_queue).perform_later("jeremy")
  #         HelloJob.set(queue: :other_queue).perform_later("bogdan")
  #       end
  #     end
  #
  # source://activejob//lib/active_job/test_helper.rb#275
  def assert_performed_jobs(number, only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # Asserts that the job has been performed with the given arguments.
  #
  #   def test_assert_performed_with
  #     MyJob.perform_later(1,2,3)
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_with(job: MyJob, args: [1,2,3])
  #
  #     MyJob.set(wait_until: Date.tomorrow.noon, queue: "my_queue").perform_later
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_with(at: Date.tomorrow.noon, queue: "my_queue")
  #   end
  #
  # The given arguments may also be specified as matcher procs that return a
  # boolean value indicating whether a job's attribute meets certain criteria.
  #
  # For example, a proc can be used to match a range of times:
  #
  #   def test_assert_performed_with
  #     at_matcher = ->(job_at) { (Date.yesterday..Date.tomorrow).cover?(job_at) }
  #
  #     MyJob.set(wait_until: Date.today.noon).perform_later
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_with(job: MyJob, at: at_matcher)
  #   end
  #
  # A proc can also be used to match a subset of a job's args:
  #
  #   def test_assert_performed_with
  #     args_matcher = ->(job_args) { job_args[0].key?(:foo) }
  #
  #     MyJob.perform_later(foo: "bar", other_arg: "No need to check in the test")
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_with(job: MyJob, args: args_matcher)
  #   end
  #
  # If a block is passed, that block performs all of the jobs that were
  # enqueued throughout the duration of the block and asserts that
  # the job has been performed with the given arguments in the block.
  #
  #   def test_assert_performed_with
  #     assert_performed_with(job: MyJob, args: [1,2,3]) do
  #       MyJob.perform_later(1,2,3)
  #     end
  #
  #     assert_performed_with(job: MyJob, at: Date.tomorrow.noon) do
  #       MyJob.set(wait_until: Date.tomorrow.noon).perform_later
  #     end
  #   end
  #
  # source://activejob//lib/active_job/test_helper.rb#494
  def assert_performed_with(job: T.unsafe(nil), args: T.unsafe(nil), at: T.unsafe(nil), queue: T.unsafe(nil), priority: T.unsafe(nil), &block); end

  # source://activejob//lib/active_job/test_helper.rb#39
  def before_setup; end

  # source://activejob//lib/active_job/test_helper.rb#9
  def enqueued_jobs(*_arg0, **_arg1, &_arg2); end

  # source://activejob//lib/active_job/test_helper.rb#9
  def enqueued_jobs=(arg); end

  # Performs all enqueued jobs. If a block is given, performs all of the jobs
  # that were enqueued throughout the duration of the block. If a block is
  # not given, performs all of the enqueued jobs up to this point in the test.
  #
  #   def test_perform_enqueued_jobs
  #     perform_enqueued_jobs do
  #       MyJob.perform_later(1, 2, 3)
  #     end
  #     assert_performed_jobs 1
  #   end
  #
  #   def test_perform_enqueued_jobs_without_block
  #     MyJob.perform_later(1, 2, 3)
  #
  #     perform_enqueued_jobs
  #
  #     assert_performed_jobs 1
  #   end
  #
  # This method also supports filtering. If the +:only+ option is specified,
  # then only the listed job(s) will be performed.
  #
  #   def test_perform_enqueued_jobs_with_only
  #     perform_enqueued_jobs(only: MyJob) do
  #       MyJob.perform_later(1, 2, 3) # will be performed
  #       HelloJob.perform_later(1, 2, 3) # will not be performed
  #     end
  #     assert_performed_jobs 1
  #   end
  #
  # Also if the +:except+ option is specified,
  # then the job(s) except specific class will be performed.
  #
  #   def test_perform_enqueued_jobs_with_except
  #     perform_enqueued_jobs(except: HelloJob) do
  #       MyJob.perform_later(1, 2, 3) # will be performed
  #       HelloJob.perform_later(1, 2, 3) # will not be performed
  #     end
  #     assert_performed_jobs 1
  #   end
  #
  # +:only+ and +:except+ options accept Class, Array of Class, or Proc. When passed a Proc,
  # an instance of the job will be passed as argument.
  #
  # If the +:queue+ option is specified,
  # then only the job(s) enqueued to a specific queue will be performed.
  #
  #   def test_perform_enqueued_jobs_with_queue
  #     perform_enqueued_jobs queue: :some_queue do
  #       MyJob.set(queue: :some_queue).perform_later(1, 2, 3) # will be performed
  #       HelloJob.set(queue: :other_queue).perform_later(1, 2, 3) # will not be performed
  #     end
  #     assert_performed_jobs 1
  #   end
  #
  # If the +:at+ option is specified, then only run jobs enqueued to run
  # immediately or before the given time
  #
  # source://activejob//lib/active_job/test_helper.rb#598
  def perform_enqueued_jobs(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), at: T.unsafe(nil), &block); end

  # source://activejob//lib/active_job/test_helper.rb#9
  def performed_jobs(*_arg0, **_arg1, &_arg2); end

  # source://activejob//lib/active_job/test_helper.rb#9
  def performed_jobs=(arg); end

  # Accesses the queue_adapter set by ActiveJob::Base.
  #
  #   def test_assert_job_has_custom_queue_adapter_set
  #     assert_instance_of CustomQueueAdapter, HelloJob.queue_adapter
  #   end
  #
  # source://activejob//lib/active_job/test_helper.rb#634
  def queue_adapter; end

  # Specifies the queue adapter to use with all Active Job test helpers.
  #
  # Returns an instance of the queue adapter and defaults to
  # ActiveJob::QueueAdapters::TestAdapter.
  #
  # Note: The adapter provided by this method must provide some additional
  # methods from those expected of a standard ActiveJob::QueueAdapter
  # in order to be used with the active job test helpers. Refer to
  # ActiveJob::QueueAdapters::TestAdapter.
  #
  # source://activejob//lib/active_job/test_helper.rb#66
  def queue_adapter_for_test; end

  private

  # source://activejob//lib/active_job/test_helper.rb#639
  def clear_enqueued_jobs; end

  # source://activejob//lib/active_job/test_helper.rb#643
  def clear_performed_jobs; end

  # source://activejob//lib/active_job/test_helper.rb#704
  def deserialize_args_for_assertion(job); end

  # source://activejob//lib/active_job/test_helper.rb#679
  def enqueued_jobs_with(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), at: T.unsafe(nil), &block); end

  # source://activejob//lib/active_job/test_helper.rb#673
  def filter_as_proc(filter); end

  # source://activejob//lib/active_job/test_helper.rb#687
  def flush_enqueued_jobs(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), at: T.unsafe(nil)); end

  # source://activejob//lib/active_job/test_helper.rb#711
  def instantiate_job(payload, skip_deserialize_arguments: T.unsafe(nil)); end

  # source://activejob//lib/active_job/test_helper.rb#647
  def jobs_with(jobs, only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), at: T.unsafe(nil)); end

  # source://activejob//lib/active_job/test_helper.rb#683
  def performed_jobs_with(only: T.unsafe(nil), except: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # source://activejob//lib/active_job/test_helper.rb#695
  def prepare_args_for_assertion(args); end

  # source://activejob//lib/active_job/test_helper.rb#718
  def queue_adapter_changed_jobs; end

  # @raise [ArgumentError]
  #
  # source://activejob//lib/active_job/test_helper.rb#725
  def validate_option(only: T.unsafe(nil), except: T.unsafe(nil)); end
end

module ActiveJob::TestHelper::TestQueueAdapter
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveJob::TestHelper::TestQueueAdapter::ClassMethods

  module GeneratedClassMethods
    def _test_adapter; end
    def _test_adapter=(value); end
  end

  module GeneratedInstanceMethods; end
end

module ActiveJob::TestHelper::TestQueueAdapter::ClassMethods
  # source://activejob//lib/active_job/test_helper.rb#27
  def disable_test_adapter; end

  # source://activejob//lib/active_job/test_helper.rb#31
  def enable_test_adapter(test_adapter); end

  # source://activejob//lib/active_job/test_helper.rb#23
  def queue_adapter; end
end

module ActiveJob::Timezones
  extend ::ActiveSupport::Concern
end

module ActiveJob::Translation
  extend ::ActiveSupport::Concern
end

module ActiveJob::VERSION; end

# source://activejob//lib/active_job/gem_version.rb#10
ActiveJob::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://activejob//lib/active_job/gem_version.rb#11
ActiveJob::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://activejob//lib/active_job/gem_version.rb#13
ActiveJob::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://activejob//lib/active_job/gem_version.rb#15
ActiveJob::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://activejob//lib/active_job/gem_version.rb#12
ActiveJob::VERSION::TINY = T.let(T.unsafe(nil), Integer)
