Одна из самых сложных деталей при работе с датами — часовые пояса (_time zones_).

Вся Земля делится на 24 часовых пояса, так что в соседних поясах время чаще всего отличается на час. Нулевым временем считается [всемирное координированное время](https://ru.wikipedia.org/wiki/Всемирное_координированное_время) (UTC). Часовые пояса вокруг земного шара выражаются, как положительное или отрицательное смещение от UTC. Например, в Москве часовой пояс +3.

Изюминку в этот механизм добавляет переход на летнее и зимнее время. Причем если пояса строго фиксированы, то переход на зимнее и летнее время — прерогатива конкретных государств, которые периодически его вводят или отменяют. Время UTC никогда не переводят, смещения происходят относительно него. Кроме этого есть еще тысяча и одна проблема.

Главное правило при работе с датами — хранение и сравнение должно производиться в UTC формате. А вот выводить даты лучше в той зоне, в которой живет пользователь.

Если вам нужно проверить текущую таймзону, можно воспользоваться функцией `date_default_timezone_get()`. Установить зону функцией `date_default_timezone_set()`.
