Одна из главных функций по работе с датами в PHP — [date()](https://php.net/manual/ru/function.date.php). Она конвертирует _timestamp_ в человекочитаемый формат.

Первым параметром в эту функцию передается описание формата даты, которое похоже на форматы для функции [sprintf()](https://php.net/manual/ru/function.sprintf.php):

```php
<?php

// Y означает год
date('Y'); // 2018
```

По умолчанию `date()` использует текущее время. Но если нужно, ей можно передать конкретный _timestamp_:

```php
<?php

date('M', 123123123); // Nov
```

Различных опций форматирования в функции `date()` — десятки. Все они подробно перечислены на странице документации. Вряд ли стоит их все запоминать, но понимать общий принцип работы — полезно. Все опции могут комбинироваться между собой в любых вариациях:

```php
<?php

date('l jS \of F Y h:i:s A'); // Thursday 26th of July 2018 10:58:55 AM
```
