Часто в работе со строками нужно определить, является ли одна строка **подстрокой** — частью другой строки. В большинстве языков программирования есть встроенная функция, предназначенная именно для этой задачи.

В PHP такая функция появилась лишь в восьмой версии. До этого ее имитировали с помощью функции [mb_strpos()](https://php.net/manual/ru/function.mb-strpos.php). Эта функция ищет позицию первого вхождения одной строки в другую. Пока мы будем использовать именно `mb_strpos()`:

```php
<?php

if (mb_strpos('Валар Моргулис', 'Моргулис')) { // 6
    // ...
}
```

В примере выше функция вернет 6, что соответствует индексу буквы М:

```php
<?php

if (mb_strpos('Валар Моргулис', 'Валар')) { // 0
    // ...
}
```

А в этом примере вернется `0`, что соответствует первой букве строки. В этом коде скрыта ошибка, которую часто допускают новички. В PHP `0` рассматривается, как `false` — значит, условие не выполнится. Правильная проверка выглядит так:

```php
<?php

if (mb_strpos('Валар Моргулис', 'Валар') !== false) {
    // ...
}
```

Функция `mb_strpos()` возвращает `false`, если подстрока не была найдена. Значит, можно воспользоваться строгим сравнением с `false`.
